$! RCM_HTML.COM V4.0-507SP4a  Generation: 315  30-APR-2002 16:43:05.66   !!!!>
$ SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)                                    !!!!>
$ rcm_ver = "V4.0-507SP4a"                                               !!!!>
$!
$! RCM_HTML.COM V4.0	Converts RCM Collected data to HTML.  Pat Moran 13-Feb-2001
$!
$ set noon
$ if p1 .eqs. "" 
$ then
$   write sys$output ""                                                                             
$   write sys$output "               RCM Data Collector ''rcm_ver' for OpenVMS"
$   write sys$output "                       RCM_HTML Utility"                                                                 
$   write sys$output ""                                                                             
$   write sys$output "                  Copyright 2001 Compaq Information Technologies Group, L.P."
$   write sys$output " "
$   write sys$output "Usage:  @RCM$DIR:RCM_HTML <inputfile(s)>"
$   exit
$ endif
$!
$ prev_fil = ""
$!
$ cr[0,8] = 13
$ main_loop:
$ filnam = f$search("''p1'",1)
$ if filnam .eqs. prev_fil then exit
$!
$ prev_fil = filnam
$ if filnam .eqs. "" then exit
$ htmlfil = f$parse(filnam,,,"name") + ".HTML"
$!
$ outnode = f$extract(5, 6, f$parse("''filnam'",,,"NAME"))
$ outnode = f$extract(0, f$locate("-", outnode), outnode)
$!
$ cmpy_name = ""
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search/out=rcm_cust_'outnode'.tmp 'filnam' "CompanyName="
$ if $status .eq. 1
$ then
$ 	open/read custfil rcm_cust_'outnode'.tmp
$ 	read custfil custrec
$ 	cmpy_name = f$extract(f$locate("CompanyName=", custrec) + 12, 60, custrec)
$       cmpy_name = f$edit(cmpy_name, "TRIM")
$ 	close custfil
$ endif
$ if f$search("rcm_cust_''outnode'.tmp") .nes. "" then delete/nolog rcm_cust_'outnode'.tmp;*
$!
$ open/read/error=error_1 infil 'filnam
$!
$ open/write/error=error_2 htmoutfil 'htmlfil'     !PTR36-4-492 use htmoutfil - seems to be conflict with
$!                                                 ! outfil in rcm_collect.com
$!
$ write htmoutfil "<! RCM HTML report>"
$ write htmoutfil "<HTML><HEAD>"
$ write htmoutfil "<TITLE>RCM Data Collector Output for OpenVMS Node ''outnode'</TITLE></HEAD>"
$ write htmoutfil "<BODY BGCOLOR=""#FFFFFF"" TEXT=""#000000"" LINK=""#0000EE"">"
$ write htmoutfil "<CENTER>"                                                                        
$ write htmoutfil "<H1>RCM Data Collector Output<BR>for OpenVMS Node ''outnode'</H1><HR>"
$ write htmoutfil "</CENTER>"                                                                       
$ gen = "unknown"
$!
$ fru_ver = "Not Found"
$!
$! get the generation of RCM_HTML.COM from the file
$!
$   open/read/share/error=nogen genfil 'f$environment("PROCEDURE")
$   read genfil genrec
$   if f$loc("Generation", genrec) .ne. f$len(genrec) 
$   then 
$     gen = f$extract(f$loc("Generation: ", genrec)+ 12, 6, genrec)
$   endif
$   close genfil
$ goto carryon
$!
$ nogen:
$ write sys$output "Error opening RCM$DIR:RCM_HTML.COM"
$ 
$ carryon:
$ write htmoutfil "Generated: ''f$time()' by RCM Data Collector ''rcm_ver' for OpenVMS  (RCM_HTML.COM gen: ''gen')"
$ write htmoutfil "<P>This is not the full RCM report, it is a HTML version of the raw collected data."
$ write htmoutfil "<P><B>Please login to the internal Compaq RCM Server at <A HREF=""http://soggey.ilo.cpqcorp.net/products/rcm"">http://soggey.ilo.cpqcorp.net/products/rcm</A> to view the official RCM Report.</B>"  
$ gosub get_toc
$!
$ READINFIL:
$! write sys$output "At READINFIL"
$ read/end=end_infil infil inrec
$!
$ if f$locate("--- START RCM LOG ---", inrec) .ne. f$length(inrec) then gosub get_logdata
$ if f$locate("--- START RCM FRU ---", inrec) .ne. f$length(inrec) then gosub get_raw_FRU
$ if f$locate("--- START RCM CT5 ---", inrec) .ne. f$length(inrec) then gosub get_raw_CT5
$ if f$locate("--- START RCM HSJ/HSD ---", inrec) .ne. f$length(inrec) then gosub get_raw_HSJD
$ if f$locate("--- START RCM HSZ ---", inrec) .ne. f$length(inrec) then gosub get_raw_HSZ
$ if f$locate("--- START RCM HSG ---", inrec) .ne. f$length(inrec) then gosub get_raw_HSG
$ if f$locate("--- START RCM OPERATING SYSTEM ---", inrec) .ne. f$length(inrec) then gosub get_opdata
$ if f$locate("--- START RCM NODE ---", inrec) .ne. f$length(inrec) then gosub get_nodedata
$ if f$locate("--- START RCM CLUSTER ---", inrec) .ne. f$length(inrec) then gosub get_clusterdata
$ if f$locate("--- START RCM DEVICE ---", inrec) .ne. f$length(inrec) then gosub get_devicedata
$ if f$locate("--- START RCM TAPE EXTENDED ---", inrec) .ne. f$length(inrec) then gosub get_tapedata
$ if f$locate("--- START RCM SYSGEN ---", inrec) .ne. f$length(inrec) then gosub get_sysgendata
$ if f$locate("--- START RCM SOFTWARE ---", inrec) .ne. f$length(inrec) then gosub get_softdata
$ if f$locate("--- START RCM PATCHES ---", inrec) .ne. f$length(inrec) then gosub get_patchdata
$ if f$locate("--- START RCM PRODUCT HISTORY ---", inrec) .ne. f$length(inrec) then gosub get_prodhist
$ if f$locate("--- START RCM LICENSE ---", inrec) .ne. f$length(inrec) then gosub get_newlicense
$ if f$locate("--- END RCM SYSGEN ---", inrec) .ne. f$length(inrec) then goto end_infil
$!
$ goto readinfil
$ end_infil:
$ close infil
$!
$! Add the raw FRU and raw Device information here
$!
$ gosub add_hsjd_data
$ gosub add_hsz_data
$ gosub add_hsg_data
$ gosub add_fru_entry
$ gosub add_ct5_entry
$!
$ write htmoutfil "<h5><em>End of RCM Data Collector Output</em></h5>"
$ write htmoutfil "<small><p>"
$ write htmoutfil "&copy; 2000 Compaq Computer Corporation.  This"
$ write htmoutfil "software is the property of, and contains confidential technology of,"
$ write htmoutfil "Compaq Computer Corporation.  Possession, use, reproduction or"
$ write htmoutfil "transfer of this software and media is strictly prohibited unless"
$ write htmoutfil "authorized in writing by Compaq or a Compaq Authorized Service"
$ write htmoutfil "Provider.  Consistent with FAR 12.211 and 12.212, Commercial Computer"
$ write htmoutfil "Software, Computer Software Documentation, and Technical Data for"
$ write htmoutfil "Commercial Items are licensed under vendor's standard commercial"
$ write htmoutfil "license."
$ write htmoutfil "</p>"
$ write htmoutfil "<p>"
$ write htmoutfil "Compaq Service materials (including diagnostic"
$ write htmoutfil "Software, hardware and Software tools, and associated documentation)"
$ write htmoutfil "provided by Compaq or a Compaq Authorized Service Provider for its use"
$ write htmoutfil "in the delivery of warranty or other services remain the exclusive"
$ write htmoutfil "property of Compaq.  Customer may use such service materials only for"
$ write htmoutfil "activities related to, and only during the term of, such delivery of"
$ write htmoutfil "the applicable warranty or other services, and may not modify or"
$ write htmoutfil "reverse engineer, remove, or transfer the service materials or make"
$ write htmoutfil "them, or any resultant diagnostic or system management data, available"
$ write htmoutfil "to other parties without Compaq's written consent.  Upon termination"
$ write htmoutfil "of the applicable warranty or service delivery, Customer will, at"
$ write htmoutfil "Compaq's option, destroy or return all service materials in its"
$ write htmoutfil "possession.  Parts replaced by Compaq become the property of Compaq."
$ write htmoutfil "</p>"
$ write htmoutfil "</small>"
$ write htmoutfil "</BODY>"
$ close htmoutfil
$ write sys$output "''f$time()': HTML outfile is: ''htmlfil'"
$ goto main_loop
$ exit
$!
$!------------------------------------------------------------------------------------
$!------------------------------------------------------------------------------------
$!
$ get_toc:
$ !  write sys$output "Generating Table of Contents"
$!     write htmoutfil "<center>"
$     write htmoutfil "<H2><A NAME=""#0"">Table Of Contents</A></H2>"
$     write htmoutfil "<DL>"
$     write htmoutfil "<DT><A HREF=""#1"">Summary</A>"
$     write htmoutfil "<DT><A HREF=""#2"">Customer and Collection Details</A>"
$     write htmoutfil "<DT><A HREF=""#2a"">Cluster Details</A>"
$     write htmoutfil "<DT><A HREF=""#8A"">Device Details</A>"
$     write htmoutfil "<DT><A HREF=""#8B"">Tape Details</A>"
$     write htmoutfil "<DT><A HREF=""#9A"">SYSGEN Parameters</A>"
$     write htmoutfil "<DT><A HREF=""#10"">Installed Software</A>"
$     write htmoutfil "<DT><A HREF=""#10A"">Installed Patches</A>"
$     write htmoutfil "<DT><A HREF=""#11"">Product Licenses</A>"
$     write htmoutfil "<DT><A HREF=""#13"">HSJ/HSD Data</A>"
$     search/remaining/out='outnode'_hs1.tmp 'filnam "START RCM HSJ"   
$     search/window=(1000000,0)/out='outnode'_hs2.tmp 'outnode'_hs1.tmp "END RCM HSJ"
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search/out='outnode'_hs.tmp 'outnode'_hs2.tmp ">", "SHOW "/match=and
$ if $STATUS .eq. 1
$ then
$   open/read thfil 'outnode'_hs.tmp
$   write htmoutfil "<DL>"
$   th_loop:
$     read/end=endth_loop thfil threc
$     ctrl = f$edit(threc, "COLLAPSE") - ">" 
$     write htmoutfil "<DT><A HREF=""#''ctrl'"">''threc'</A>"
$     goto th_loop
$     endth_loop:
$     close thfil
$     write htmoutfil "</DL>"
$ if f$search("''outnode'_hs.tmp") .nes. "" then delete/nolog 'outnode'_hs.tmp;*
$ if f$search("''outnode'_hs%.tmp") .nes. "" then delete/nolog 'outnode'_hs%.tmp;*
$ endif
$ write htmoutfil "<DT><A HREF=""#14"">HSZ Data</A>"
$ search/remaining/out='outnode'_hsz1.tmp 'filnam "START RCM HSZ"   
$ search/window=(1000000,0)/out='outnode'_hsz2.tmp 'outnode'_hsz1.tmp "END RCM HSZ"
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search/out='outnode'_hsz.tmp 'outnode'_hsz2.tmp "RCMSCRIPT -f"
$ if $STATUS .eq. 1
$ then
$   open/read thfil 'outnode'_hsz.tmp
$   write htmoutfil "<DL>"
$   th_loop:
$     read/end=endth_loop thfil threc
$     ctrl = f$edit(threc, "COLLAPSE") - ">" 
$     write htmoutfil "<DT><A HREF=""#''ctrl'"">''threc'</A>"
$     goto th_loop
$     endth_loop:
$     close thfil
$     write htmoutfil "</DL>"
$     if f$search("''outnode'_hsz*.tmp") .nes. "" then delete/nolog 'outnode'_hsz*.tmp;*
$!     write htmoutfil "</center>"
$ endif 
$!
$ write htmoutfil "<DT><A HREF=""#14A"">HSG Data</A>"
$ search/remaining/out='outnode'_hsg1.tmp 'filnam "START RCM HSG"   
$ search/window=(1000000,0)/out='outnode'_hsg2.tmp 'outnode'_hsg1.tmp "END RCM HSG"
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search/out='outnode'_hsg.tmp 'outnode'_hsg2.tmp "RCMSCRIPT -f"
$ if $STATUS .eq. 1
$ then
$   open/read thfil 'outnode'_hsg.tmp
$   write htmoutfil "<DL>"
$   th_loopg:
$     read/end=endth_loopg thfil threc
$     ctrl = f$edit(threc, "COLLAPSE") - ">" 
$     write htmoutfil "<DT><A HREF=""#''ctrl'"">''threc'</A>"
$     goto th_loopg
$     endth_loopg:
$     close thfil
$     write htmoutfil "</DL>"
$     if f$search("''outnode'_hsg*.tmp") .nes. "" then delete/nolog 'outnode'_hsg*.tmp;*
$!     write htmoutfil "</center>"
$ endif 
$!
$     write htmoutfil "<DT><A HREF=""#15"">Raw FRU Entry from DECevent</A>"
$     write htmoutfil "<DT><A HREF=""#15A"">Raw CT5 data</A>"
$ return              
$!
$!------------------------------------------------------------------------------------
$!
$ get_logdata:
$!  write sys$output "Getting Log data"
$ logloop:
$   if f$locate("RCM OpenVMS Data Collector", inrec) .ne. f$length(inrec)
$   then
$     rcmver = f$edit(f$extract(f$locate("RCM OpenVMS Data Collector", inrec)+27, 8, inrec), "TRIM")
$   endif
$   if f$locate("RCM_COLLECT started", inrec) .ne. f$length(inrec)
$   then                             
$     coll_date = f$edit(f$extract(f$locate("at ", inrec)+3, 23, inrec), "TRIM")
$     tzone = f$edit(f$extract(47, 3, inrec), "TRIM")
$   endif
$   if f$locate("DECevent Version = ", inrec) .ne. f$length(inrec)
$   then
$     de_ver = f$edit(f$extract(f$locate("DECevent Version = ", inrec)+19, 23, inrec), "TRIM")
$   endif
$   if f$locate("no FRU ", inrec) .ne. f$length(inrec) then fru_ver = "Not Found"
$   if f$locate("--- END RCM LOG ---", inrec) .ne. f$length(inrec) then return
$   read/end=end_infil infil inrec
$   goto logloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_raw_FRU:
$ ! write sys$output "Getting FRU data"
$  read/end=end_infil infil inrec
$  open/write rfru 'outnode'.FRU
$  write rfru "<pre>"
$ rawfruloop:
$   if f$locate("--- END RCM FRU ---", inrec) .ne. f$length(inrec) 
$   then 
$     write rfru "</pre>"
$     close rfru
$     return
$   endif
$    write rfru inrec
$   read/end=end_infil infil inrec
$   goto rawfruloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_raw_CT5:
$ ! write sys$output "Getting CT5 data"
$  read/end=end_infil infil inrec
$  open/write rct5 'outnode'.CT5_TMP
$  write rct5 "<pre>"
$ rawct5loop:
$   if f$locate("--- END RCM CT5 ---", inrec) .ne. f$length(inrec) 
$   then 
$     write rct5 "</pre>"
$     close rct5
$     return
$   endif
$    write rct5 inrec
$   read/end=end_infil infil inrec
$   goto rawct5loop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_raw_HSJD:
$ ! write sys$output "Getting HSJ/HSD data"
$   read/end=end_infil infil inrec
$  open/write rhsjd 'outnode'.HS
$  write rhsjd "<pre>"
$ rawhsjdloop:
$   if f$locate("--- END RCM HSJ/HSD ---", inrec) .ne. f$length(inrec) 
$   then 
$     write rhsjd "</pre>"
$     close rhsjd
$     return
$   endif
$!
$   if f$locate("SHOW ", inrec) .ne. f$length(inrec) .and. f$loc(">", inrec) .ne. f$len(inrec)  
$   then 
$     ctrl = f$edit(inrec, "COLLAPSE") - ">"
$     if f$locate("THIS_CONTROLLER", inrec) .eq. f$len(inrec)
$     then
$       write rhsjd "</pre>"
$       write rhsjd "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$     endif
$     write rhsjd "<h3><a name=""''ctrl'"">''inrec'</a></h3>"
$     write rhsjd "<pre>"
$   else
$     write rhsjd inrec
$     if f$locate("EXIT", inrec) .ne. f$len(inrec) .and. f$loc(">", inrec) .ne. f$len(inrec)
$     then
$       write rhsjd "</pre>"
$       write rhsjd "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$     endif
$   endif
$   read/end=end_infil infil inrec
$   goto rawhsjdloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_raw_HSZ:
$ ! write sys$output "Getting HSZ data"
$   read/end=end_infil infil inrec
$   read/end=end_infil infil inrec
$  open/write rhsz 'outnode'.HSZ
$  if f$locate("RCMSCRIPT -f", inrec) .ne. f$length(inrec)
$  then 
$     ctrl = f$edit(inrec, "COLLAPSE") - ">"
$     write rhsz "<h3><a name=""''ctrl'"">''inrec'</a></h3>"
$     write rhsz "<pre>"
$   else
$     write rhsz "<pre>"
$   endif
$   read/end=end_infil infil inrec
$ rawhszloop:
$   if f$locate("--- END RCM HSZ ---", inrec) .ne. f$length(inrec) 
$   then 
$     write rhsz "</pre>"
$     close rhsz
$     return
$   endif
$   if f$locate("SET HOST/SCSI", inrec) .ne. f$length(inrec)
$   then 
$     ctrl = f$edit(inrec, "COLLAPSE") - ">"
$     if f$locate("RCMSCRIPT -f", inrec) .ne. f$length(inrec)
$     then
$       write rhsz "</pre>"
$       write rhsz "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$     endif
$     write rhsz "<h3><a name=""''ctrl'"">''inrec'</a></h3>"
$     write rhsz "<pre>"
$   else
$      if f$extract(f$len(inrec) - 1, 1, inrec) .eqs. cr
$      then
$        inrec = inrec - cr
$        if f$len(inrec) .ne. 0 
$        then 
$           write rhsz inrec
$           read/end=end_infil infil inrec                   ! eat the line after nonblank line<CR>  - if its empty
$           inrec = inrec - cr                              !
$           if f$len(inrec) .ne. 0 then write rhsz inrec     !
$        endif
$      else
$        write rhsz inrec
$      endif
$       if f$locate("EXIT", inrec) .ne. f$len(inrec) .and. f$loc(">", inrec) .ne. f$len(inrec)
$       then
$         write rhsz "</pre>"
$         write rhsz "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$       endif
$   endif
$   read/end=end_infil infil inrec
$   goto rawhszloop
$ !write sys$output "finished hsz"
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_raw_HSG:
$ ! write sys$output "Getting HSG data"
$   read/end=end_infil infil inrec
$   read/end=end_infil infil inrec
$  open/write rhsg 'outnode'.HSG
$  if f$locate("RCMSCRIPT -f", inrec) .ne. f$length(inrec)
$  then 
$     ctrl = f$edit(inrec, "COLLAPSE") - ">"
$     write rhsg "<h3><a name=""''ctrl'"">''inrec'</a></h3>"
$     write rhsg "<pre>"
$   else
$     write rhsg "<pre>"
$   endif
$   read/end=end_infil infil inrec
$ rawhsgloop:
$   if f$locate("--- END RCM HSG ---", inrec) .ne. f$length(inrec) 
$   then 
$     write rhsg "</pre>"
$     close rhsg
$     return
$   endif
$   if f$locate("RCMSCRIPT -f", inrec) .ne. f$length(inrec)
$   then 
$     ctrl = f$edit(inrec, "COLLAPSE") - ">"
$     if f$locate("RCMSCRIPT -f", inrec) .ne. f$length(inrec)
$     then
$       write rhsg "</pre>"
$       write rhsg "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$     endif
$     write rhsg "<h3><a name=""''ctrl'"">''inrec'</a></h3>"
$     write rhsg "<pre>"
$   else
$      if f$extract(f$len(inrec) - 1, 1, inrec) .eqs. cr
$      then
$        inrec = inrec - cr
$        if f$len(inrec) .ne. 0 
$        then 
$           write rhsg inrec
$           read/end=end_infil infil inrec                   ! eat the line after nonblank line<CR>  - if its empty
$           inrec = inrec - cr                               !
$           if f$len(inrec) .ne. 0 then write rhsg inrec     !
$        endif
$      else
$        write rhsg inrec
$      endif
$       if f$locate("EXIT", inrec) .ne. f$len(inrec) .and. f$loc(">", inrec) .ne. f$len(inrec)
$       then
$         write rhsg "</pre>"
$         write rhsg "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$       endif
$   endif
$   read/end=end_infil infil inrec
$   goto rawhsgloop
$ !write sys$output "finished hsg"
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_opdata:
$ cons_ver = " &nbsp;"
$ pal_ver = " &nbsp;"
$! write sys$output "Getting Operating System details"
$ oploop:
$   if f$locate("Operating System = VMS ", inrec) .ne. f$length(inrec)
$   then
$     op_sys = f$edit(f$extract(f$locate("Operating System = ", inrec) + 19, 12, inrec), "TRIM")
$   endif
$   if f$locate("Console Version = ", inrec) .ne. f$length(inrec)
$   then
$     cons_ver = f$edit(f$extract(f$locate("Console Version = ", inrec) + 18, 12, inrec), "TRIM")
$   endif
$   if f$locate("Palcode Version = ", inrec) .ne. f$length(inrec)
$   then
$     pal_ver = f$edit(f$extract(f$locate("Palcode Version = ", inrec) + 18, 12, inrec), "TRIM")
$   endif
$   if f$locate("--- END RCM OPERATING SYSTEM ---", inrec) .ne. f$length(inrec) then return
$   read/end=end_infil infil inrec
$   goto oploop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_nodedata:
$!  write sys$output "Getting node details"
$ nodeloop:
$   if f$locate("Node System Type = ", inrec) .ne. f$length(inrec)
$   then
$     sys_type = f$edit(f$extract(f$locate("Node System Type = ", inrec)+19, 30, inrec), "TRIM")
$     write htmoutfil "<BR><BR><H2><A NAME=""1"">Summary</A></H2>"
$     write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=60%>"   
$     write htmoutfil "<TR><TD><B>Company Name</B></TD><TD>''cmpy_name'</TD></TR>"
$     write htmoutfil "<TR><TD><B>System Name</B></TD><TD>''outnode'</TD></TR>"
$     write htmoutfil "<TR><TD><B>Collection Date</B></TD><TD>''coll_date'</TD></TR>"
$     write htmoutfil "<TR><TD><B>System Type</B></TD><TD>''sys_type'</TD></TR>"
$     write htmoutfil "<TR><TD><B>Operating System</B></TD><TD>''op_sys'</TD></TR>"
$     if cons_ver .eqs. "" then cons_ver = "&nbsp;"
$     write htmoutfil "<TR><TD><B>Console Version</B></TD><TD>''cons_ver'</TD></TR>"
$     if pal_ver .eqs. "" then pal_ver = "&nbsp;"
$     write htmoutfil "<TR><TD><B>Palcode Version</B></TD><TD>''pal_ver'</TD></TR>"
$     write htmoutfil "</TABLE><BR>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$!     gosub get_toc
$     gosub get_cust_details
$   endif
$   if f$locate("Node Domain Name = ", inrec) .ne. f$length(inrec)
$   then
$      dom = f$edit(f$extract(f$locate("Node Domain Name = ", inrec) + 19, 30, inrec), "trim")
$   endif
$   if f$locate("--- END RCM NODE ---", inrec) .ne. f$length(inrec) 
$   then
$      return
$   endif
$   read/end=end_infil infil inrec
$   goto nodeloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_clusterdata:
$  ! write sys$output "Getting Cluster details"
$   clusloop:
$   str = "Cluster Name = "
$   if f$locate("''str'", inrec) .ne. f$length(inrec)
$   then
$     clus_name = f$edit(f$extract(f$locate("''str'", inrec)+f$len(str), 10, inrec), "TRIM") - "::"
$     write htmoutfil "<H2><a name=""2a"">Cluster Details for ''clus_name'</a></H2>"
$     write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$     write htmoutfil "<TR>"
$     write htmoutfil "<TH>NODE</TH>"
$     write htmoutfil "<TH>Hardware Type</TH>"
$     write htmoutfil "<TH>Software</TH>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("|", inrec) .ne. f$length(inrec) -
                .and. f$loc("SYS_ID", inrec) .eq. f$len(inrec) -
                   .and. f$loc("SYSTEMS", inrec) .eq. f$len(inrec)
$   then
$     nd =  f$edit(f$element(1, "|", inrec), "trim")
$     hwt =  f$edit(f$element(4, "|", inrec), "trim") 
$     swt =  f$edit(f$element(5, "|", inrec), "trim")
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''nd'</TD>"
$     write htmoutfil "<TD>''hwt'</TD>"
$     write htmoutfil "<TD>''swt'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("--- END RCM CLUSTER ---", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$  !   write sys$output "Finished Cluster details"
$     return
$   endif
$   read/end=end_infil infil inrec
$   goto clusloop
$ return
$!
$!
$ get_cust_details:
$! write sys$output "Getting Customer details"
$ write htmoutfil "<H2><a name=""2"">Customer & Collection Details</a></H2>"
$!
$ cmpy_name = "&nbsp;"
$ id_num = "&nbsp;"
$ contact = "&nbsp;"
$ c_phone = "&nbsp;"
$ c_email = "&nbsp;"
$ acc_mgr = "&nbsp;"
$ acc_mgr_email = "&nbsp;"
$ fru_ver = "&nbsp;"
$ arch = "&nbsp;"
$ host_name = "&nbsp;"
$!
$ define/user sys$output NLA0:
$ define/user sys$error NLA0:
$ search/out=cust_'outnode'.tmp/wi=(0,60) 'filnam' "--- START RCM CUSTOMER INFO ---"
$ if $status .ne. 1 then return
$ open/read custfil cust_'outnode'.tmp
$ custloop:
$ read/end=endcustloop custfil custrec
$!
$  if f$locate("=", custrec) .ne. f$len(custrec) then value = f$extract(f$locate("=", custrec)+1,30, custrec)
$  if f$locate("CompanyName=", custrec) .ne. f$len(custrec) then cmpy_name = value
$  if f$locate("ContactName=", custrec) .ne. f$len(custrec) then contact = value
$  if f$locate("ContactTelephone=", custrec) .ne. f$len(custrec) then c_phone = value
$  if f$locate("ContactEmail=", custrec) .ne. f$len(custrec) then c_email = value
$  if f$locate("CustomerAccessID=", custrec) .ne. f$len(custrec) then id_num = value
$  if f$locate("TAMName=", custrec) .ne. f$len(custrec) then acc_mgr = value
$  if f$locate("TAMEmail=", custrec) .ne. f$len(custrec) then acc_mgr_email = value
$  if f$locate("FRUVersion=", custrec) .ne. f$len(custrec) then fru_ver = value
$  if f$locate("KitVersion=", custrec) .ne. f$len(custrec) then rcmver = value
$  if f$locate("Architecture=", custrec) .ne. f$len(custrec) then arch = value
$  if f$locate("FullHostName=", custrec) .ne. f$len(custrec) then host_name = value
$  if f$locate("--- END RCM CONFIG INFO ---", custrec) .ne. f$len(custrec) 
$  then 
$ 	write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=60%>"                                                
$ 	write htmoutfil "<TR><TD><B>Company Name</B></TD><TD>''cmpy_name'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Customer Access ID</B></TD><TD>''id_num'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Contact Name</B></TD><TD>''contact'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Contact Telephone</B></TD><TD>''c_phone'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Contact Email</B></TD><TD>''c_email'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Technical Account Manager</B></TD><TD>''acc_mgr'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Account Manager Email</B></TD><TD>''acc_mgr_email'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Collection Date</B></TD><TD>''coll_date' ''tzone'</TD></TR>"
$ 	write htmoutfil "<TR><TD><B>Collector Version</B></TD><TD>RCM_COLLECT ''rcmver'</TD></TR>"
$       write htmoutfil "<TR><TD><B>FRU Table Version</B></TD><TD>''fru_ver'</TD></TR>"
$!       write htmoutfil "<TR><TD><B>Architecture</B></TD><TD>''arch'</TD></TR>"
$!       write htmoutfil "<TR><TD><B>System Name</B></TD><TD>''host_name'</TD></TR>"
$ 	write htmoutfil "</TABLE></BR>"
$ 	write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$       goto endcustfil
$  endif
$ goto custloop
$ endcustfil:
$ close custfil
$ if f$search("cust_'outnode'.tmp") .nes. "" then delete/nolog  cust_'outnode'.tmp;
$ return
$!
$! 
$!------------------------------------------------------------------------------------
$!
$! --- START RCM DEVICE ---
$! 
$! DSA0, AXPVMSRL71, RZ28, 4110480, 236972
$! DSA1, SALTHL_SYS, RZ56, 1299174, 207246
$! DPA10, MCS_DSK1, RAID5, 8000000, 1770360
$! DPA11, MCS_DSK2, RAID5, 8000000, 2681232
$! DPA12, MCS_DSK3, RAID5, 8000000, 3249704
$! DPA13, MCS_DSK4, RAID5, 8000000, 720054
$! DPA14, USER_DISK, RAID5, 1472784, 883917
$! $10$DKA100, ARRAY29_1000, RZ29B, 8380080, 32
$! $10$DKA200, ARRAY29_1001, RZ29B, 8380080, 32
$! $10$DKA300, ARRAY29_1002, RZ29B, 8380080, 32
$! $10$DKA400, ARRAY29_1003, RZ29B, 8380080, 32
$! $10$DKA500, ARRAY29_1004, RZ29B, 8380080, 32
$! DAD2, VAXDOCJUN981, RRD42, 1290600, 137916
$! 
$! --- END RCM DEVICE ---
$! 
$!------------------------------------------------------------------------------------
$!
$ get_devicedata:
$!   write sys$output "Getting DEVICE details"
$   write htmoutfil "<H2><a name=""8A"">Device Details</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Device Name</TH>"
$   write htmoutfil "<TH>Volume Name</TH>"
$   write htmoutfil "<TH>Device Type</TH>"
$   write htmoutfil "<TH>Total Blocks</TH>"
$   write htmoutfil "<TH>Free Blocks</TH>"
$   write htmoutfil "</TR>"
$   read/end=end_infil infil inrec
$   deviceloop:
$     devnam =  "&nbsp;"
$     volnam = "&nbsp;"
$     devtyp = "&nbsp;"
$     tblk = "&nbsp;"
$     fblk = "&nbsp;"
$!     tmp = f$edit(f$extract(0, 16, inrec), "compress, trim")
$     if f$loc(",", inrec) .eq. f$len(inrec) then goto skipdev
$     devnam = f$element(0, ",", inrec)
$     volnam = f$element(1, ",", inrec)
$     devtyp = f$element(2, ",", inrec)
$     tblk   = f$element(3, ",", inrec)
$     fblk   = f$element(4, ",", inrec)
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''devnam'</TD>"
$     write htmoutfil "<TD>''volnam'</TD>"
$     write htmoutfil "<TD>''devtyp'</TD>"
$     write htmoutfil "<TD>''tblk'</TD>"
$     write htmoutfil "<TD>''fblk'</TD>"
$     write htmoutfil "</TR>"
$   skipdev:
$   if f$locate("--- END RCM DEVICE ---", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$!     write sys$output "Finished DEVICE details"
$     goto enddevice
$   endif
$   read/end=end_infil infil inrec
$   goto deviceloop
$   enddevice:
$ return
$!
$!------------------------------------------------------------------------------------
$!--- START RCM TAPE EXTENDED ---
$!
$!TapeName, Type, Media,  MNT,  Host
$!_XSIVE$MKA400:, TLZ07, TLZ07, FALSE, XSIVE
$!_MAD0:, unknown, , FALSE, XSIVE
$!
$!--- END RCM TAPE EXTENDED ---
$!
$ get_tapedata:
$!   write sys$output "Getting TAPE details"
$   write htmoutfil "<H2><a name=""8B"">Tape Details</a></H2>"
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Tape Name</TH>"
$   write htmoutfil "<TH>Type</TH>"
$   write htmoutfil "<TH>Media</TH>"
$   write htmoutfil "<TH>MNT</TH>"
$   write htmoutfil "<TH>Host</TH>"
$   write htmoutfil "</TR>"
$   tapeloop:
$     read/end=end_infil infil inrec
$!     tmp = f$edit(f$extract(0, 16, inrec), "compress, trim")
$     if f$loc(",", inrec) .eq. f$len(inrec) then goto skiptap
$     tapnam = f$element(0, ",", inrec)
$     if tapnam .eqs. "TapeName" then goto tapeloop
$     taptyp = f$element(1, ",", inrec)
$     tapmed = f$element(2, ",", inrec)
$     tapmnt = f$element(3, ",", inrec)
$     taphst = f$element(4, ",", inrec)
$     if tapnam .eqs. "" then tapnam = "&nbsp;"
$     if taptyp .eqs. "" then taptyp = "&nbsp;"
$     if tapmed .eqs. "" then tapmed = "&nbsp;"
$     if tapmnt .eqs. "" then tapmnt = "&nbsp;"
$     if taphst .eqs. "" then taphst = "&nbsp;"
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''tapnam'</TD>"
$     write htmoutfil "<TD>''taptyp'</TD>"
$     write htmoutfil "<TD>''tapmed'</TD>"
$     write htmoutfil "<TD>''tapmnt'</TD>"
$     write htmoutfil "<TD>''taphst'</TD>"
$     write htmoutfil "</TR>"
$   skiptap:
$   if f$locate("--- END RCM TAPE EXTENDED ---", inrec) .ne. f$length(inrec)
$   then
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"
$!     write sys$output "Finished TAPE details"
$     goto endtape
$   endif
$   goto tapeloop
$   endtape:
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_sysgendata:
$!   write sys$output "Getting SYSGEN details"
$   write htmoutfil "<H2><a name=""9A"">SYSGEN Parameters</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Parameter Name</TH>"
$   write htmoutfil "<TH>Current</TH>"
$   write htmoutfil "<TH>Default</TH>"
$   write htmoutfil "<TH>Min.</TH>"
$   write htmoutfil "<TH>Max.</TH>"
$   write htmoutfil "<TH>Unit</TH>"
$   write htmoutfil "<TH>Dynamic</TH>"
$   write htmoutfil "</TR>"
$   read/end=end_infil infil inrec
$   sysgenloop:
$     par =  "&nbsp;"
$     cur = "&nbsp;"
$     def = "&nbsp;"
$     min = "&nbsp;"
$     max = "&nbsp;"
$     uni  = "&nbsp;"
$     dyn  = "&nbsp;"
$!
$   if f$locate("--- END RCM SYSGEN ---", inrec) .ne. f$length(inrec) .or. f$locate("cpu type:", inrec) .ne. f$length(inrec) -
.or. f$extract(0, 16, inrec) .eqs. "__Driver_____Sta"
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$   !  write sys$output "Finished SYSGEN details"
$     return
$   endif
$!
$   tmp = f$edit(f$extract(0, 16, inrec), "compress, trim")
$   if tmp .nes. "Parameter Name" .and. tmp .nes. "Parameters in us" .and. tmp .nes. "" .and. tmp .nes. "--------------" -
.and. f$edit(f$extract(0, 1, inrec), "compress,trim") .nes. ""
$   then
$     par =  tmp - """" - """"
$     cur = f$edit(f$extract(16, 18, inrec), "trim") - """" - """"  ! to get rid of any quotes
$     cur = f$edit(cur, "compress,trim")
$     if cur .eqs. "" then cur = "&nbsp;"
$     def = f$edit(f$extract(34, 10, inrec), "trim")  - """" - """"
$     def = f$edit(def, "compress,trim")
$     if def .eqs. "" then def = "&nbsp;"
$     min = f$edit(f$extract(44, 10, inrec), "trim")  - """" - """"
$     min = f$edit(min, "compress,trim")
$     if min .eqs. "" then min = "&nbsp;"
$     max = f$edit(f$extract(54, 11, inrec), "trim")  - """" - """"
$     max = f$edit(max, "compress,trim")
$     if max .eqs. "" then max = "&nbsp;"
$     uni  = f$edit(f$extract(65, 11, inrec), "trim")  - """" - """"
$     uni = f$edit(uni, "compress,trim")
$     if uni .eqs. "" then uni = "&nbsp;"
$     dyn  = f$edit(f$extract(76, 10, inrec), "trim")  - """" - """"
$     dyn = f$edit(dyn, "compress,trim")
$     if dyn .eqs. "" then dyn = "&nbsp;"
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''par'</TD>"
$     write htmoutfil "<TD>''cur'</TD>"
$     write htmoutfil "<TD>''def'</TD>"
$     write htmoutfil "<TD>''min'</TD>"
$     write htmoutfil "<TD>''max'</TD>"
$     write htmoutfil "<TD>''uni'</TD>"
$     write htmoutfil "<TD>''dyn'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   read/end=end_infil infil inrec
$   goto sysgenloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ get_softdata:
$  ! write sys$output "Getting Sofware details"
$   write htmoutfil "<H2><a name=""10"">Installed Software Details</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Product Name</TH>"
$   write htmoutfil "<TH>Image Name</TH>"
$   write htmoutfil "<TH>UPI</TH>"
$   write htmoutfil "<TH>Installed Version</TH>"
$   write htmoutfil "<TH>Current</TH>"
$   write htmoutfil "<TH>Linktime</TH>"
$   write htmoutfil "</TR>"
$   softloop:
$   if f$locate("|", inrec) .ne. f$length(inrec)
$   then
$     pr =  f$edit(f$element(0, "|", inrec), "trim")
$     upi = f$edit(f$element(1, "|", inrec), "trim")
$     ver = f$edit(f$element(2, "|", inrec), "trim")
$     cv =  f$edit(f$element(3, "|", inrec), "trim") 
$     dr =  f$edit(f$element(5, "|", inrec), "trim")
$     im  = f$edit(f$element(6, "|", inrec), "trim")
$     lk  = f$edit(f$element(7, "|", inrec), "trim")
$!     if f$locate("-", lk) .eq. 1 
$!     then 
$!        lk = "0" + lk
$!     endif
$     lk = f$extract(0, 11, lk)
$     if f$locate("]", dr) .eq. f$length(dr) then im = dr + ":" + im ! + ".EXE"
$     if f$locate("]", dr) .ne. f$length(dr) then im = dr + im !+ ".EXE"
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''pr'</TD>"
$     write htmoutfil "<TD>''im'</TD>"
$     write htmoutfil "<TD>''upi'</TD>"
$     write htmoutfil "<TD>''ver'</TD>"
$     write htmoutfil "<TD>''cv'</TD>"
$     write htmoutfil "<TD>''lk'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("--- END RCM SOFTWARE ---", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$   !  write sys$output "Finished Sofware details"
$     return
$   endif
$   read/end=end_infil infil inrec
$   goto softloop
$ return
$!
$!--------------------------------------------------------------------------------------
$!
$ get_patchdata:
$  tmppatchloop:        !try to detect if Alpha or Vax by looking for alpha/Vax in first couple of lines
$   read/end=end_infil infil inrec
$   if f$locate("Alpha", inrec) .ne. f$len(inrec) 
$   then 
$      gosub get_alppatchdata
$      return
$   endif
$   if f$locate("VAX", inrec) .ne. f$len(inrec) 
$   then 
$      gosub get_vaxpatchdata
$      return
$   endif
$   goto tmppatchloop
$ return
$!
$!-------------------------------------------------------------------------------------
$!
$ get_alppatchdata:
$!   write sys$output "Getting Alpha Patch details"
$   write htmoutfil "<H2><a name=""10A"">Installed Patch Details</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$!
$!Patch Name           Version   Install Date    Status     Node    Installer
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Patch Name</TH>"
$   write htmoutfil "<TH>Version</TH>"
$   write htmoutfil "<TH>Install Date</TH>"
$   write htmoutfil "<TH>Status</TH>"
$   write htmoutfil "<TH>Node</TH>"
$   write htmoutfil "<TH>Installer</TH>"
$   write htmoutfil "</TR>"
$   patchloop:
$   if f$locate("|", inrec) .ne. f$length(inrec)
$   then
$     pn =  f$edit(f$element(0, "|", inrec), "trim")
$     ver = f$edit(f$element(1, "|", inrec), "trim")
$     ind = f$edit(f$element(2, "|", inrec), "trim")
$     st =  f$edit(f$element(3, "|", inrec), "trim") 
$     nd =  f$edit(f$element(4, "|", inrec), "trim")
$     ins  = f$edit(f$element(5, "|", inrec), "trim")
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''pn'</TD>"
$     write htmoutfil "<TD>''ver'</TD>"
$     write htmoutfil "<TD>''ind'</TD>"
$     write htmoutfil "<TD>''st'</TD>"
$     write htmoutfil "<TD>''nd'</TD>"
$     write htmoutfil "<TD>''ins'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("--- END RCM PATCHES ---", inrec) .ne. f$length(inrec) 
$!   if f$locate("Patch & Product Information for Alpha node", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$!     write sys$output "Finished AlphaPatch details"
$     return
$   endif
$   read/end=end_infil infil inrec
$   goto patchloop
$ return
$!
$!------------------------------------------------------------------------------------
$!
$!
$ get_vaxpatchdata:
$!   write sys$output "Getting VAX Patch details"
$   write htmoutfil "<H2><a name=""10A"">Installed Patch Details</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>Patch Name</TH>"
$   write htmoutfil "<TH>Date</TH>"
$   write htmoutfil "</TR>"
$   inrec = f$edit(inrec, "compress,trim")
$   patchloop:
$   if f$extract(0,3, inrec) .eqs. "VAX"
$   then
$     pn =  f$edit(f$element(0, " ", inrec), "trim")
$     dt  = f$extract(f$loc(" ", inrec),23, inrec)
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''pn'</TD>"
$     write htmoutfil "<TD>''dt'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("--- END RCM PATCHES ---", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$     write sys$output "Finished VAX Patch details"
$     return
$   endif
$   read/end=end_infil infil inrec
$   inrec = f$edit(inrec, "compress,trim")
$   goto patchloop
$ return
$!
$!-----------------------------------------------------------------------------
$ get_prodhist:
$!   write sys$output "Getting PRODUCT SHOW HISTORY details"
$   write htmoutfil "<H2>Installed Patch Details - from PRODUCT SHOW HISTORY</H2>"                       
$!   prdloop:
$!     read/end=end_infil infil inrec
$!     if f$locate("Patch & Product Information for", inrec) .ne. f$length(inrec) 
$!     then
$!       if f$locate("Alpha", inrec) .ne. f$length(inrec) 
$!       then
$!         plat = "Alpha"
$!       else
$!         plat = "VAX"
$!       endif
$!       goto getprds 
$!     endif
$!     goto prdloop
$! getprds:
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   tmpprodloop:
$      read/end=end_infil infil inrec
$      if f$locate(" KIT TYPE ", inrec) .ne. f$length(inrec) 
$      then
$        read/end=end_infil infil inrec
$        read/end=end_infil infil inrec
$        goto getprods 
$      endif
$   goto tmpprodloop
$   getprods:
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>PRODUCT</TH>"
$   write htmoutfil "<TH>KIT TYPE</TH>"
$   write htmoutfil "<TH>OPERATION</TH>"
$   write htmoutfil "<TH>DATE AND TIME</TH>"
$   write htmoutfil "<TH>USERNAME</TH>"
$   write htmoutfil "</TR>"
$   prodpatchloop:
$   if f$locate(" Patch ", inrec) .ne. f$length(inrec) .and. f$locate(" Install ", inrec) .ne. f$length(inrec) 
$   then
$     prod = f$edit(f$extract(0, 36, inrec), "trim")
$     kit  = f$edit(f$extract(36, 11, inrec), "trim")
$     oper = f$edit(f$extract(48, 11, inrec), "trim")
$     dtetim = f$edit(f$extract(60, 22, inrec), "trim") 
$     usern =  f$edit(f$extract(85, 12, inrec), "trim")
$     write htmoutfil "<TR>"
$     write htmoutfil "<TD>''prod'</TD>"
$     write htmoutfil "<TD>''kit'</TD>"
$     write htmoutfil "<TD>''oper'</TD>"
$     write htmoutfil "<TD>''dtetim'</TD>"
$     write htmoutfil "<TD>''usern'</TD>"
$     write htmoutfil "</TR>"
$   endif
$   if f$locate("--- END RCM PRODUCT HISTORY ---", inrec) .ne. f$length(inrec) 
$   then 
$     write htmoutfil "</TABLE><br>"
$     write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$!     write sys$output "Finished PRODUCT SHOW HISTORY details"
$     return
$   endif
$   read/end=end_infil infil inrec
$   goto prodpatchloop
$ return
$!
$!---------------------------------------------------------------------------
$!
$ get_newlicense:
$! write sys$output "Writing out License details"
$ prd = "&nbsp;"
$ upi = "&nbsp;"
$ aut = "&nbsp;"
$ trm = "&nbsp;"
$ unt = "&nbsp;"
$!
$   read/end=end_infil infil inrec
$   write htmoutfil "<H2><a name=""11"">Product Licenses</a></H2>"                       
$   write htmoutfil "<TABLE border=1 cellspacing=0 cellpadding=4 width=100%>"    
$   write htmoutfil "<TR>"
$   write htmoutfil "<TH>License Name</TH>"
$   write htmoutfil "<TH>UPI</TH>"
$   write htmoutfil "<TH>Authorization</TH>" 
$   write htmoutfil "<TH>Termination</TH>" 
$   write htmoutfil "<TH>Units</TH>" 
$   write htmoutfil "</TR>"
$!
$licloop:
$   read/end=end_infil infil inrec
$   inrec = f$edit(inrec, "compress")
$   if f$locate("License Name", inrec) .ne. f$length(inrec) 
$   then 
$   	read/end=end_infil infil inrec
$       lic1loop:
$   	   inrec = f$edit(inrec, "compress")
$   	   if f$locate("--- END RCM LICENSE ---", inrec) .ne. f$length(inrec) 
$   	   then 
$          	write htmoutfil "</TABLE><br>"
$          	write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$               return
$          endif
$   	   if inrec .nes. "" .and. f$extract(0,3,inrec) .nes. "---"
$          then
$     		prd = f$edit(f$element(0, " ", inrec), "trim")
$     		upi = f$edit(f$element(1, " ", inrec), "trim")
$     		aut = f$edit(f$element(2, " ", inrec), "trim")
$     		trm = f$edit(f$element(3, " ", inrec), "trim") 
$     		unt = f$edit(f$element(4, " ", inrec), "trim")
$   		write htmoutfil "<TR>"
$   		write htmoutfil "<TD>''prd'</TD>"
$   		write htmoutfil "<TD>''upi'</TD>"
$   		write htmoutfil "<TD>''aut'</TD>" 
$   		write htmoutfil "<TD>''trm'</TD>" 
$   		write htmoutfil "<TD>''unt'</TD>" 
$   		write htmoutfil "</TR>"
$	    endif
$   	    read/end=end_infil infil inrec
$	    goto lic1loop
$   else
$           goto licloop
$   endif
$ return
$!
$!------------------------------------------------------------------------------------
$!
$ add_FRU_entry:
$!
$ if f$search("''outnode'.fru") .eqs. "" 
$ then 
$   write htmoutfil "No FRU entry found<p>"
$   goto no_fru
$ else
$   write htmoutfil "<H2><a name=""15"">Raw FRU Entry from DECevent</a></H2>"                       
$ endif
$!
$ open/read infru 'outnode'.fru 
$ fruloop:
$ read/end=endfruloop infru frurec
$ write htmoutfil frurec
$ goto fruloop
$ endfruloop:
$ close infru
$ no_fru:
$ write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$ if f$search("''outnode'.fru") .nes. "" then delete/nolog 'outnode'.fru;
$ return
$!------------------------------------------------------------------------------------
$!
$ add_CT5_entry:
$!
$ if f$search("''outnode'.ct5_TMP") .eqs. "" 
$ then 
$   write htmoutfil "No CT5 entry found<p>"
$   goto no_ct5
$ else
$   write htmoutfil "<H2><a name=""15A"">Raw CT5 Entry</a></H2>"                       
$ endif
$!
$ open/read inct5 'outnode'.ct5_TMP 
$ ct5loop:
$ read/end=endct5loop inct5 ct5rec
$ write htmoutfil ct5rec
$ goto ct5loop
$ endct5loop:
$ close inct5
$ no_ct5:
$ write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$ if f$search("''outnode'.ct5_TMP") .nes. "" then delete/nolog 'outnode'.ct5_tmp;
$ return
$!
$!-------------------------------------------------------------------------------
$!
$ add_hsjd_data:
$ write htmoutfil "<H2><a name=""13"">HSJ/HSD Data</a></H2>"                       
$ if f$search("''outnode'.hs") .eqs. "" 
$ then 
$   write htmoutfil "No HSJ/HSD Devices found<p>"
$   goto no_hs
$ endif
$ open/read inhs 'outnode'.hs 
$ hsloop:
$ read/end=endhsloop inhs hsrec
$ write htmoutfil hsrec
$ goto hsloop
$ endhsloop:
$ close inhs
$ no_hs:
$ write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$ if f$search("''outnode'.hs") .nes. "" then delete/nolog 'outnode'.hs;
$ return
$!
$ add_hsz_data:
$  write htmoutfil "<H2><a name=""14"">HSZ Data</a></H2>"                       
$ if f$search("''outnode'.hsz") .eqs. "" 
$ then 
$   write htmoutfil "No HSZ Devices found<p>"
$   goto no_hsz
$ endif
$ open/read inhsz 'outnode'.hsz 
$ hszloop:
$   read/end=endhszloop inhsz hszrec
$   write htmoutfil hszrec
$!   write sys$output "''hszrec'"
$   goto hszloop
$ endhszloop:
$ close inhsz
$ no_hsz:
$ write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$ if f$search("''outnode'.hsz") .nes. "" then delete/nolog 'outnode'.hsz;
$ return
$!
$ add_hsg_data:
$  write htmoutfil "<H2><a name=""14A"">HSG Data</a></H2>"                       
$ if f$search("''outnode'.hsg") .eqs. "" 
$ then 
$   write htmoutfil "No HSG Devices found<p>"
$   goto no_hsg
$ endif
$ open/read inhsg 'outnode'.hsg 
$ hsgloop:
$   read/end=endhsgloop inhsg hsgrec
$   write htmoutfil hsgrec
$!   write sys$output "''hsgrec'"
$   goto hsgloop
$ endhsgloop:
$ close inhsg
$ no_hsg:
$ write htmoutfil "<a href=""#0""><em>Return to Table of Contents</em></a><br>"    
$ if f$search("''outnode'.hsg") .nes. "" then delete/nolog 'outnode'.hsg;
$ return
$!------------------------------------------------------------------------------
$!
$ error_1:
$ write sys$output "File: ''filnam' not found"
$ exit
$!
$ error_2:
$ write sys$output "Error writing ''outfil'"
$ exit
$!
$!*****************************************************************************
$!                                                                             
$!                            RCM_HTML.COM                                     
$!                                                                             
$!****************************************************************************
$!
$!    Copyright 2001 Compaq Information Technologies Group, L.P.
$!
$!    Compaq and the Compaq logo are trademarks of Compaq Information
$!    Technologies Group, L.P. in the U.S. and/or other countries.
$!
$!    Confidential computer software. Valid license from Compaq required for
$!    possession, use or copying. Consistent with FAR 12.211 and 12.212,
$!    Commercial Computer Software, Computer Software Documentation, and
$!    Technical Data for Commercial Items are licensed to the U.S. Government
$!    under vendor's standard commercial license.
$!
$!    Compaq service tool software, including associated documentation, is the
$!    property of and contains confidential technology of Compaq Computer 
$!    Corporation or its affiliates. Service customer is hereby licensed to use
$!    the software only for activities directly relating to the delivery of, 
$!    and only during the term of, the applicable services delivered by Compaq
$!    or its authorized service provider. Customer may not modify or reverse
$!    engineer, remove, or transfer the software or make the software or any
$!    resultant diagnosis or system management data available to other parties
$!    without Compaqs or its authorized service providers consent. Upon 
$!    termination of the services, customer will, at Compaqs or its service
$!    providers option, destroy or return the software and associated
$!    documentation in its possession.
$!
$!****************************************************************************
$!                                                                             
$!      FACILITY                :       OpenVMS RCM Data Collector       
$!
$!      COMMAND FILE            :       RCM_HTML.COM                           
$!                                                                             
$!      DESCRIPTION             :       Generates a HTML Report from the collected data
$!                                                                             
$!      PROGRAMMER              :       Pat Moran, 22 Jun 1998    
$!
$!      MODIFICATIONS           :       Version V1.0.3   PTR 36-4-125/126 10 Aug 1998
$!                                      Version V2.1.0   Update to V2.1.0  3-Nov-1998
$!                                      Version V2.1.1   Update to V2.1.1 11-Dec-1998
$!                                      Version V2.1.2   Update to V2.1.2 20-Jan-1999
$!                                                       PTR36-4-492 sometimes no HTMLs created
$!                                                       
$!                                      Version V2.2     Update to V2.2   29-Mar-1999
$!                                      Version V3.0     Update to V3.0   11-May-1999
$!                                      Version V4.0     Update to V4.0   13-Feb-2001
$!*****************************************************************************
$!
$! Parameters: p1, File spec of input file(s) (Can be wildcard)
$!
$! Description: 
$!	
$!*****************************************************************************
