#! perl
# Author: Dan Sugalski <sugalskd@ous.edu>
#
# Copyright 1998, Oregon University System
#
# This program may be redistributed under the same terms as perl itself
#
# sou_menu.pl - duplicate the SQL*Menu functionality (more or less) with
# perl, perlmenu, DBD::Oracle, and Curses.

use DBI;
BEGIN {$Curses::OldCurses = 1;}
use Curses;
use perlmenu;
require "menuutil.pl";

# The application we're running as
$application_name = "BASIS_JOBS";

# setup for perlmenu
$row = $col = 0;
$| = 1;
{
  # Quiet uninitialized value warnings
  local($^W);
  $window = initscr();
  menu_curses_application($window);
  menu_quit_routine("endwin");
  menu_init(1, "Southern Oregon University", 1, "Basisjobs");
}
$message_string = "";

$SQL_statement = <<"SQL_STATEMENT";

select option_text, command_line, command_type
from   sosc.menu_b_option
where menu_name = ?
and application_name = ?
and command_type <= 5
and exists (select * 
            from sosc.menu_b_user,
                 sosc.menu_b_grp_priv, sosc.menu_b_priv
            where upper(menu_b_user.user_name) = upper(?)
            and menu_b_grp_priv.group_name = menu_b_user.group_name
            and menu_b_grp_priv.application_name = menu_b_option.application_name
            and menu_b_priv.privilege_id = menu_b_grp_priv.privilege_id
            and menu_b_priv.application_name = menu_b_option.application_name
            and menu_b_priv.option_number = menu_b_option.option_number
            and menu_b_priv.menu_name = menu_b_option.menu_name)
order by option_number

SQL_STATEMENT

# One big block, so we can loop if we need to. We reevaluate the template
# each time through so the message string gets picked up new each time.
{
  # Quiet uninitialized value warnings
  local($^W);
  # Go prompt for username and password
  menu_load_template_array(split("\n", <<"END_OF_TEMPLATE"));
  

                           Southern Oregon University
                                Basisjobs login

                                 Perlmenu v4.0
                                 Curses v$Curses::VERSION
                             perl version $]

           (To exit, hit [RETURN] with a blank username and password)


                        Username: [____________________]
                        Password: [^^^^^^^^^^^^^^^^^^^^]









$message_string
END_OF_TEMPLATE

  #initialize the login array
  @login_info = ('sugalskd', 'sugalskd');

  menu_display_template(*login_info);
  $username = $login_info[0];
  $password = $login_info[1];
  if (!$username) {
    exit;
  }
  $dbh = DBI->connect("dbi:Oracle:", $username, $password);
  if (!defined($dbh)) {
    $message_string = chr(27)."[7mInvalid username/password. Please reenter".chr(27)."[0m";
    redo;
  }
}

# 'Kay, go do things
draw_our_menu($dbh, $application_name, "BASIS Jobs top level menu", 1);


# This is the sub that actually goes and does things. It takes as its
# parameters a database handle, the username, and the name of the menu
# to display. perlmenu.pm doesn't keep any state, so we do submenus
# with a recursive call
sub draw_our_menu {
  my ($dbh, $menu_name, $menu_desc, $is_top) = @_;
  my (@rec_list);

  my $sth = $dbh->prepare($SQL_statement);
  $sth->execute($menu_name, $application_name, $username) || return;

  while (my $rec_ref = $sth->fetchrow_arrayref) {
    my @rec_array = @$rec_ref;
    push(@rec_list, \@rec_array);
  }
  # just loop forever, unless they exit
  while (1) {
    my $count = 0;
    # Init this level of menu
    menu_init(1, "BASIS Jobs", $is_top, $menu_desc);
    foreach my $rec_ref (@rec_list) {
      $count = menu_item("$rec_ref->[0]", $count+1);
    }
    # Add a default up if the menu's empty
    menu_item("Up", "%UP%") unless $count;
    my $return_val = &menu_display("");
    if ($return_val > 0) {
      # They chose something. See what
      if ($rec_list[$return_val-1][2] == 1) {
        # a sub-menu!
        &clear(); $row = $col = 0; refresh();
        draw_our_menu($dbh, $rec_list[$return_val-1][1], 
                      $rec_list[$return_val-1][0], 0);
      } elsif ($rec_list[$return_val-1][2] == 2 || 
               $rec_list[$return_val-1][2] == 3) {
        # Not a submenu. Execute the procedure they wanted.
        system($rec_list[$return_val-1][1]);
        # Type 3 has a pause
        pause() if $rec_list[$return_val-1][2] == 3;
        &clear(); $row = $col = 0; refresh();
      } elsif ($rec_list[$return_val-1][2] == 4 || 
               $rec_list[$return_val-1][2] == 5) {
        # SQL*Form or SQL*Menu login. Do a search 'n replace of the user
        # and password if it's specified
        my $command_line = $rec_list[$return_val-1][1];
        $command_line =~ s/&UN/$username/;
        $command_line =~ s/&PW/$password/;
        system($rec_list[$return_val-1][1]);
        &clear(); $row = $col = 0; refresh();
      }
    } else {
      return;
    }
  }
}

