$! PCSI_INSTALLATION.COM - POLYCENTER Software Installation utility $!                         for DECwindows Motif for OpenVMS$!$!------------------------------------------------------------------------------$! Copyright Digital Equipment Corporation 1988, 1995. All rights reserved.$! $! Restricted Rights: Use, duplication, or disclosure by the U.S. Government$! is subject to restrictions as set forth in subparagraph (c)(1)(ii) of DFARS $! 252.227-7013, or in FAR 52.227-19, or in FAR 52.227-14 Alt. III, as $! applicable.$! $! This software is proprietary to and embodies the confidential technology of$! Digital Equipment Corporation. Possession, use, or copying of this software$! and media is authorized only pursuant to a valid written license from Digital$! or an authorized sublicensor.$!------------------------------------------------------------------------------$!$!	This command procedure does the following:$!		1.  Displays the copyright message.$!		2.  Checks for supported versions of OpenVMS and saves$!                    architecture type (VAX/Alpha)$!                  Note: Version 1.2-3 requires OpenVMS Version 6.1$!                        systems or higher$!              2.A - Make sure that we have enough GBLPAGES & CLISYMTBL.$!              3. Verify that DECwindows Motif application and run-time$!                    support files are installed (for example, transport)$!              4. Checks if the server is installed and warns the user if$!                    the system cannot be a workstation or a workstation boot$!                    server.$!              5. Asks if the user wants to save the OSF/Motif Release$!                    1.1.3 programming files.$!              6. Asks if the user wants to reboot the system $!                    For non VMS 6.2 systems to run AUTOGEN to reset any $!		      incorrect system parameters.  For VMS AXP 6.2 and greater $!                    a system reboot required periord because fo a Shared $!                    linkage/replace problem in 6.2$!              6. Asks if the user wants to reboot the system and run$!                    AUTOGEN to reset any incorrect system parameters.$!              7. Installs DECwindows Motif Version 1.2-3 for OpenVMS using$!                    the POLYCENTER Software Installation utility.$!              8. Updates the [SYSLIB]DCLTABLES.EXE executable with the$!                    new verbs.$!$!              9. Tells the user how to run the IVP after the installation$!                    is complete.$!              10. Checks the system parameters and runs AUTOGEN if the$!                    user selected this option for instances where the$!                    system parameters are incorrect.$!$  ON CONTROL_Y THEN GOTO handle_control_y$!$!$  define/process vmi$root sys$common$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 1. Display the copyright information.$!---------------------------------------------------------------------------$ type sys$input  DECwindows Motif V1.2-3 for OpenVMS installation procedure  Copyright Digital Equipment Corporation 1988, 1995. All rights reserved.  Restricted Rights: Use, duplication, or disclosure by the U.S. Government  is subject to restrictions as set forth in subparagraph (c)(1)(ii) of  DFARS  252.227-7013, or in FAR 52.227-19, or in FAR 52.227-14 Alt. III,  as  applicable.  This software is proprietary to and embodies the confidential technology  of Digital Equipment Corporation. Possession, use, or copying of this  software and media is authorized only pursuant to a valid written license  from Digital or an authorized sublicensor.$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 2. Determine the version of the OpenVMS operating system and architecture.$!---------------------------------------------------------------------------$ VAX   = 1$ Alpha = 2$ ARCH = F$Getsyi("ARCH_TYPE")$ SID  = F$Getsyi("SID")$ VER  = F$Getsyi("VERSION")$!$ VMS_VERSION_NUMBER = f$extr(1,3,VER)$ MIN_VMS_VERSION = "6.1"$!$! CHECK TO SEE IF THIS IS AN INTERNAL TEST VERSION OF OPENVMS$ IF f$extr(0,1,ver) .EQS. "X"$ THEN$   write sys$output ""$   write sys$output "   *** NOTE: OpenVMS version ''ver' DETECTED ***"$   write sys$output "   *** OpenVMS V6.1 or later is required for this kit, please verify ***"$   write sys$output "   *** your operating system version ***"$   GOTO skip_version_check$ ENDIF$!$ IF (VMS_VERSION_NUMBER .LTS. MIN_VMS_VERSION) THEN GOTO version_bad$ GOTO version_ok$!$ version_bad:$ write sys$output ""$ IF (ARCH .EQ. VAX)$ THEN$    write sys$output "  WARNING: This kit may be installed only on OpenVMS VAX"$    write sys$output "           Version V''MIN_VMS_VERSION'  systems or higher."$ ELSE$    write sys$output "  WARNING: This kit may be installed only on OpenVMS ALPHA"$    write sys$output "           Version V''MIN_VMS_VERSION'  systems or higher."$ ENDIF$ EXIT$!$ version_ok:$ write sys$output " "$ write sys$output "  **** Supported OpenVMS Version ''ver' DETECTED ****"$ write sys$output " "$ skip_version_check:$!$! 2.A - Make sure that we have enough GBLPAGES & CLISYMTBL.$!$ insufficient_params = 0$ num_gblpages = f$getsyi("GBLPAGES")$ free_gblpages = f$getsyi("FREE_GBLPAGES")$$ IF (ARCH .EQ. alpha) .AND. (num_gblpages .LT. 90000)$ THEN$     type sys$input         The SYSGEN parameter GBLPAGES is too low.  It must be at least        90000 for OpenVMS Alpha.  Please increase GBLPAGES to a minimum        of 90000 and reinstall DECWindows. See the installation guide        for information on setting system parameters.$     insufficient_params = 1$ ENDIF$$ IF ( ARCH .NE. alpha) .AND. (num_gblpages .LT. 62000)$ THEN$     type sys$input         The SYSGEN parameter GBLPAGES is too low.  It must be at least        62000 for OpenVMS VAX.  Please increase GBLPAGES to a minimum        of 62000 and reinstall DECWindows. See the installation guide        for information on setting system parameters.$     insufficient_params = 1$ ENDIF$$ IF (ARCH .EQ. alpha) .AND. (free_gblpages .LT 12000) $ THEN$     type sys$input         The number of free GBLPAGES is too low.  This installation requires 	at least 12000 free GBLPAGES on OpenVMS Alpha.  Please increase 	GBLPAGES so there is a minimum of 12000 free then reinstall DECWindows.$     write sys$output -	"        Currently there is only ''free_gblpages' free GBLPAGES."$     type sys$input 	See the installation guide for information on setting system parameters.$     insufficient_params = 1$ ENDIF$ !$ IF (ARCH .NE. alpha) .AND. (free_gblpages .LT 6000) $ THEN$     type sys$input         The number of free GBLPAGES is too low.  This installation requires 	at least 6000 free GBLPAGES on OpenVMS VAX.  Please increase 	GBLPAGES so there is a minimum of 6000 free then reinstall DECWindows.$       write sys$output -	"        Currently there is only ''free_gblpages' free GBLPAGES."$     type sys$input	See the installation guide for information on setting system parameters.$     insufficient_params = 1$ ENDIF$ !$ num_clisymtbl = f$getsyi("CLISYMTBL") $ IF (num_clisymtbl .LT. 265)$ THEN$  type sys$input         The SYSGEN parameter CLISYMTBL is too low.  It must be at least        265.  Please increase CLISYMTBL to a minimum of 265 and reinstall 	DECWindows. See the installation guide for information on setting 	system parameters.$     insufficient_params = 1$ ENDIF$ !$ IF insufficient_params THEN exit !vmi$_failure$!$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 3. Check if user installed DECwindows support files when they installed$!    the OpenVMS system.$!---------------------------------------------------------------------------$ IF ( .NOT. ((ARCH .EQ. Alpha) .OR. f$trnlnm("DECW$IGNORE_BUNDLED")))$ THEN$   IF (f$search("SYS$COMMON:[SYSLIB]DECW$TRANSPORT_COMMON.EXE") .EQS. "")$   THEN $     type sys$input  The DECwindows Motif application and run-time support files have not been  installed.  You can use the DECwindows tailoring facility to tailor on the device  support files and the 75DPI and/or the 100DPI font files using the  DECwindows save sets which are shipped with the OpenVMS kit as follows:         $ RUN SYS$UPDATE:DECW$TAILOR  The installation of DECwindows Motif cannot continue.$ !$     EXIT$   ENDIF$ ENDIF$ write sys$output " "$ write sys$output "  **** DECwindows Motif application and run-time support files DETECTED ****"$ write sys$output "$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 4. Check if the server is installed and warn the user that it cannot$!    be a workstation or workstation boot server.$!---------------------------------------------------------------------------$!$ IF ( (f$search("SYS$COMMON:[SYSEXE]DECW$SERVER_MAIN.EXE")  .EQS. "") .OR. -       (f$search("SYS$COMMON:[SYSFONT.DECW.*DPI]FIXED*.*")   .EQS. "") )$ THEN$    type sys$input  The DECwindows device support files for using this machine as a  workstation or as a boot node for workstations have not been installed.  You can use the DECwindows tailoring facility to tailor on the device  support files and the 75DPI and/or the 100DPI font files using the  DECwindows save sets which are shipped with the OpenVMS kit as follows:       $ RUN SYS$UPDATE:DECW$TAILOR$    INQUIRE/NOPUNCT answer "Do you wish to continue with this installation without the workstation support" -$    IF .NOT. answer$    THEN$       exit$    ENDIF$ ENDIF$ write sys$output " "$ write sys$output "  **** DECwindows device support files DETECTED ****"$ write sys$output "$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$!  5. Check if the OSF/Motif Release 1.1.3 programming environment exists$!     on the system. If it does, ask if it should be moved.$!---------------------------------------------------------------------------$ decw$saveprog = "False"$ decw$spe_action = "IGNORE"$!$! Check for XUI UIL Compiler, if it exists, OSF/Motif Release 1.1.3 is still there$ IF (f$search("SYS$COMMON:[SYSEXE]DECW$UILCOMPILER.EXE") .EQS. "") THEN -	GOTO saveprog_done$$ type sys$input  The DECwindows Motif programming environment was installed with a   previous version of this kit.  This environment is incompatible with the   OSF/Motif Release 1.2 environment provided with DECwindows Motif Version  1.2. The XUI programming environment is also not included in  DECwindows Motif Version 1.2-3.  If you intend to continue developing programs for XUI or OSF/Motif  Release 1.1.3 then save this environment.  Please refer to the  installation guide for more details and information on accessing these  files in their new location.  If you do not choose to save the XUI and OSF/Motif Release 1.1.3   programming environment, those files will be removed from the system  disk.$!$ INQUIRE/NOPUNCT decw$saveprog "Save the OSF/Motif Release 1.1.3 and XUI programming environment?"$!$! Either save or delete existing programming environment depending on$! answer to, "Save the OSF/Motif Release..." question$ IF decw$saveprog$ THEN$   decw$spe_action = "MOVE"$ ELSE$   decw$spe_action = "DELETE"$ ENDIF$!$ IF (decw$spe_action .nes. "MOVE") .and. (decw$spe_action .nes. "DELETE") -        then goto saveprog_done$$ ! Create the directories for old programming files (if necessary)$ !$ ! The rename command used to move the files will$ ! fail if the same generation of the file already exists in the$ ! subdirectory, so delete any files that may exist in the DECW$113$ ! subdirectories.$ !$ IF decw$spe_action .EQS. "MOVE"$ THEN$   IF F$SEARCH("vmi$root:[decw$include]decw$113.dir;") .EQS. ""$   THEN$     create/directory vmi$root:[decw$include.decw$113]$   ELSE$     IF F$SEARCH("vmi$root:[decw$include.decw$113]*.*") .NES. ""$     THEN$       DELETE/NOLOG vmi$root:[decw$include.decw$113]*.*;*$     ENDIF$   ENDIF$ !$   IF F$SEARCH("vmi$root:[sysexe]decw$113.dir;") .EQS. ""$   THEN$     create/directory vmi$root:[sysexe.decw$113]$   ELSE$     IF F$SEARCH("vmi$root:[sysexe.decw$113]*.*") .NES. ""$     THEN$       DELETE/NOLOG vmi$root:[sysexe.decw$113]*.*;*$     ENDIF$   ENDIF$ ENDIF$ !$ ! --- MOVE or DELETE DECW$INCLUDE header files (OSF/Motif V1.1.3 and XUI)---$ !$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ARROWB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ARROWBG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ARROWBGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ARROWBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ATOMMGR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "BASECLASSI.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "BITMAPS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "BULLETINB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "BULLETINBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CACHEP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CASCADEB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CASCADEBG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CASCADEBGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CASCADEBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMMAND.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMMANDP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMPOBJ.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMPOBJP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMPOSITE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COMPOSITEP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CONSTRAINP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CONSTRAINT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CONVERT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CORE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "COREP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CSTEXTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CUTPASTE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "CUTPASTEP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "D2DX.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "D2DXSTR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECSPECIFIC.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECWDWTAPPLPROG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECWDWTWIDGETPROG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECWI18N.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECWMHINTS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DIALOGS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DIALOGSP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRAWINGA.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRAWINGAP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRAWNB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRAWNBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRMDECLS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DRMPUBLIC.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTAPPL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTSTRING.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTWIDGET.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMCOLOR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMCOLORP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMCSTEXT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMCSTEXTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMHELPB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMHELPBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMHELPSP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMPRINT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMPRINTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMSVN.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMSVNP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "EVENT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "EXTOBJECT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "EXTOBJECTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FILESB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FILESBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FORM.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FORMP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FRAME.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "FRAMEP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "GETSECRES.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "IDB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "INTRINSIC.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "INTRINSICP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "KEYSYM.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "KEYSYMDEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LABEL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LABELG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LABELGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LABELP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LIST.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "LISTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MAINW.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MAINWP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MENUSHELL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MENUSHELLP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MESSAGEB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MESSAGEBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MRM.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MRMAPPL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MRMDECLS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MRMPUBLIC.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MRMWIDGET.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "MWMUTIL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "OBJECT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "OBJECTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PANEDW.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PANEDWP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PROTOCOLS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PROTOCOLSP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PUSHB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PUSHBG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PUSHBGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "PUSHBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "QUARKS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "RECTOBJ.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "RECTOBJP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ROWCOLUMN.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "ROWCOLUMNP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SASHP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCALE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCALEP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCROLLBAR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCROLLBARP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCROLLEDW.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SCROLLEDWP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SELECTIOB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SELECTIOBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SELECTION.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SEPARATOG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SEPARATOGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SEPARATOR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SEPARATORP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SHELL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "SHELLP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "STRINGDEFS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "STRINGSRCP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTFP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTINP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTOUTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TEXTSRCP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TOGGLEB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TOGGLEBG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TOGGLEBGP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TOGGLEBP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TRANSLATE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "TRAVERSAL.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "UILDBDEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "UILLEXPARS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VASIMPLE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VENDOR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VENDORE.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VENDOREP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VENDORP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VIRTKEYS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "VIRTKEYSP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "WINDOWOBJ.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "WINDOWOBJP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "X.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XATOM.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XFUNCS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XFUNCPROTO.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XM.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XMD.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XMP.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XOS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XPROTO.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XPROTOSTR.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XTOS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XOSDEFS.H" "''decw$spe_action'"$ !$ ! --- Move DECW$INCLUDE UIL Files ---$ !$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DECWDWTAPPLPROG.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTAPPL.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTXLATARG.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DWTXLATTEXT.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMXLATARG.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "DXMXLATTEXT.UIL" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[DECW$INCLUDE]" "XMAPPL.UIL" "''decw$spe_action'"$ !$ ! --- Move [SYSEXE] UIL Compiler (XUI and OSF/Motif V1.1.3)---$ !$ CALL DECW$MOVE_SPE_FILE "[SYSEXE]" "DECW$UILCOMPILER.EXE" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSEXE]" "DECW$UILMOTIF.EXE" "''decw$spe_action'"$ !$ ! --- Move [SYSLIB] Xlib R4 (R5 only shipped starting with V1.2)$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBSHR.EXE" "''decw$spe_action'"$ !$ ! If there are non-C languages on the system, move these also$ !$ IF (f$search("VMI$ROOT:[SYSLIB]DECW$XLIBDEF.*") .EQS. "") THEN -	GOTO saveprog_done$ !$ IF decw$spe_action .EQS. "MOVE"$ THEN$   IF F$SEARCH("vmi$root:[syslib]decw$113.dir;") .EQS. "" $   THEN $     create/directory vmi$root:[syslib.decw$113]$   ELSE$     IF F$SEARCH("vmi$root:[syslib.decw$113]*.*") .NES. ""$     THEN$       DELETE/NOLOG vmi$root:[syslib.decw$113]*.*;*$     ENDIF$   ENDIF$ ENDIF$ !$ ! --- Move [SYSLIB] Non-C language support ---$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.PLI" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTDEF.UIL" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTENTRY.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.PLI" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTMSG.H" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTSTRUCT.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETDEF.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$DWTWIDGETSTRUCT.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$MOTIF.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$MOTIF.PAS" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBDEF.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.PLI" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "DECW$XLIBMSG.H" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$DPSOPS.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$DPSOPS.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$DPSOPS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$DPSOPS.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$DPSOPS.MAR" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPS.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPS.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPS.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPS.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPS.MAR" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPSLIB.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPSLIB.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPSLIB.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPSLIB.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XDPS$XDPSLIB.MAR" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$DEF.PLI" "''decw$spe_action'"$ !$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.BAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.R32" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.H" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.FOR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.MAR" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.PAS" "''decw$spe_action'"$ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "XNL$MSG.PLI" "''decw$spe_action'"$!$!=========================================================================$!$! SUBROUTINE - DECW$MOVE_SPE_FILE$!$!    moves or deletes a file associated$!    with the saved programming environment.  If moved, the file is$!    transferred from its location to a DECW$113 subdirectory.$!$!    P1 is the directory location of the programming support file$!       to be moved.$!    P2 is the name of the programming support file to be moved.$!    P3 is a keyword - either "MOVE" or "DELETE"$!$!    example: $ CALL DECW$MOVE_SPE_FILE "[SYSLIB]" "FILENAME.H" "MOVE"$! $decw$move_spe_file:  SUBROUTINE$!$  decw$param1 = "''P1'"$  decw$param2 = "''P2'"$  decw$param3 = "''P3'"$  decw$spe_file_name =   f$parse(decw$param2,,,"NAME") -			+ f$parse(decw$param2,,,"TYPE")$!$  decw$from_dir = "VMI$ROOT:" + decw$param1$  decw$old_copy =   decw$from_dir + decw$spe_file_name$  IF decw$param3 .EQS. "MOVE"$  THEN$    decw$spe_dir = decw$from_dir + "DECW$113.DIR"$    decw$to_dir = decw$from_dir - "]" + ".DECW$113]"$    decw$new_copy =   decw$to_dir + decw$spe_file_name$  ENDIF$!$! Check to verify that spe file exists$  IF f$search(decw$old_copy) .EQS. "" THEN GOTO decw$finished_spe_move$  IF decw$param3 .EQS. "MOVE"$  THEN$!   Check to verify that spe subdirectory exists$    IF f$search(decw$spe_dir)  .EQS. "" THEN GOTO decw$finished_spe_move$  ENDIF$!$! The file is going to be moved or deleted - if it is an image, and it$! is installed, then delete the file entry.$!$  IF f$parse(decw$old_copy,,,"TYPE") .EQS. ".EXE"$  THEN$    IF f$file(decw$old_copy,"KNOWN") THEN install remove 'decw$old_copy$  ENDIF$!$  IF decw$param3 .EQS. "MOVE"$  THEN$    rename/nolog 'decw$old_copy 'decw$new_copy$    GOTO decw$finished_spe_move$  ENDIF$!$  IF decw$param3 .EQS. "DELETE"$  THEN$    DELETE/NOLOG 'decw$old_copy';*$    GOTO decw$finished_spe_move$  ENDIF$!$decw$finished_spe_move:$  exit$  ENDSUBROUTINE$!$ saveprog_done:$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 6. Tell the installer that the product won't start if the system$!    parameters are not correct.  Tell them that either a reboot could$!    be allowed, or that the procedure will direct them if a reboot is$!    necessary.$! $!    Then ask the installer if a reboot will be allowed.$!---------------------------------------------------------------------------$skip_for_now:$ IF (ARCH .EQ. alpha) .AND. ( VMS_VERSION_NUMBER .GES. "6.2" )$ THEN$     type sys$input  The installation of DECwindows Motif Version 1.2-3 on systems with  OpenVMS Alpha Version 6.2 (or higher) requires a system reboot after  the installation. If you do not allow a system shutdown, the  installation procedure will aborted.$     read sys$command/prompt="Will you allow a system reboot after this product is installed? " decw$allow_reboot$     IF .NOT. decw$allow_reboot THEN exit$$ ELSE$     type sys$input  NOTE: DECwindows Motif will not start if your system parameters are not        set correctly  o If you allow a system shutdown, the installation procedure reboots    the system at the end of the installation.  If your system parameters    are incorrect, the installation runs AUTOGEN prior to the system    reboot.  o If you do not allow a system shutdown, the installation procedure    continues; you are informed at the end of the installation whether you    need to modify your system parameters to start DECwindows Motif.$     read sys$command/prompt="Will you allow a system reboot after this product is installed? " decw$allow_reboot$ ENDIF$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 7. Install the kit using the PCSI Installation utility$!---------------------------------------------------------------------------$ type sys$input       To answer the following question, enter the directory specification       of the DECwindows Motif for OpenVMS POLYCENTER Software       Installation utility kit.$ find_kit:$ read sys$command/prompt="Where is the PCSI kit located? " kit_location$!$ IF (ARCH .EQ. VAX)$ THEN$   IF (f$search(kit_location+"DEC-VAXVMS-DWMOTIF-V0102-3-1.PCSI") .EQS. "")$   THEN$     type sys$input         The DECwindows Motif Version V1.2-3 for OpenVMS  POLYCENTER         Software Installation kit cannot be located.         Type Ctrl/C to exit the installation procedure or reenter the         directory specification of the kit.$     GOTO find_kit$   ENDIF$ ELSE$   IF (f$search(kit_location+"DEC-AXPVMS-DWMOTIF-V0102-3-1.PCSI") .EQS. "")$   THEN$     type sys$input         The DECwindows Motif V1.2-3 for OpenVMS ALPHA PCSI kit not found         Type Control C to exit installation procedure or reenter kit location.$     GOTO find_kit$   ENDIF$ ENDIF$!$ type sys$input       Caution: POLYCENTER Software installations differ from VMSINSTAL       installations in one major area: in POLYCENTER Software       installations, files are deleted from your system disk unless you       specifically answer "Yes" to the questions that ask if you want to       install the support. Although the support may exist on your previous       kit, answer "Yes" to each question. If you answer "No," the       files are deleted from the your system disk using the POLYCENTER       Software Installation history file. With VMSINSTAL installations,       the previous files are not deleted.       For example, if your previous kit included programming support       for all languages except Fortran and you want to add Fortran       support and keep the previous programming support, answer "Yes"       to the question that asks if you want to install Fortran       programming support. Also answer "Yes" to the other questions       that pertain to parts of the kit that want to keep on your system.$ product install/source='kit_location/configuration=producer dwmotif$!$!Check to see if error returned from PCSI installation and abort$ IF $STATUS .EQ. 1 THEN GOTO create_new_dcltable$ type sys$input   Terminating installation of DECwindows Motif V1.2-3 for OpenVMS$ EXIT $STATUS$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 8. Update [SYSLIB]DCLTABLES.EXE with new verbs$!---------------------------------------------------------------------------$!$ create_new_dcltable:$ IF f$search("SYS$SYSROOT:[SYSLIB]DECW$UILCOMPILER.CLD")  .EQS. "" THEN GOTO skip_uil$ SET COMMAND/tables=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      /output=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      SYS$SYSROOT:[SYSLIB]DECW$UILCOMPILER.CLD$!$ skip_uil:$ IF f$search("SYS$COMMON:[SYSLIB]ddif$view.cld")  .EQS. "" THEN GOTO skip_view$ SET COMMAND/tables=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      /output=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      SYS$COMMON:[SYSLIB]ddif$view.cld$!$skip_view:$ IF f$search("SYS$COMMON:[SYSLIB]pswrap.cld")  .EQS. "" THEN GOTO skip_pswrap$ SET COMMAND/tables=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      /output=SYS$COMMON:[SYSLIB]DCLTABLES.EXE -      SYS$COMMON:[SYSLIB]pswrap.cld$skip_pswrap:$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! 9. Tell the installer where to find the IVP$!---------------------------------------------------------------------------$ tell_about_ivp:$ type sys$input  Run the Installation Verification Procedure (IVP) after the installation  is completed and DECwindows Motif is restarted. The IVP is located in the  following directory: SYS$TEST:DECW$IVP.COM.$!$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$!   10. Determine whether the system parameters are set correctly. Then$!       reboot the system if necessary and if allowed by the installer.$!---------------------------------------------------------------------------$!$!   This procedure checks if the system parameters are set correctly, and$!   if the following required files are present: DECW$AUTOGEN.COM and$!   AUTOGEN.dat.$!$! See if we need to AUTOGEN$!$ VMI$_SUCCESS == 1$ VMI$_ROOT == "SYS$COMMON"$!$ type sys$input  Checking to see if system parameters are set correctly....$ @sys$manager:decw$autogen set_params$ IF .NOT. $status .AND. decw$allow_reboot THEN GOTO run_autogen$ IF .NOT. $status THEN GOTO need_reboot$ IF (VMS_VERSION_NUMBER .GES. "6.2") .AND. decw$allow_reboot THEN GOTO v62_reboot$!$ type sys$input  The installation procedure has determined that your system parameter values   are acceptable.  A reboot of the system is not required.$!$ EXIT VMI$_SUCCESS$!$! We will get here if the sysgen params are not currently set correctly.$! It will cause AUTOGEN to be run and thereby reset the parameters.$! VMSINSTAL will then cause the system to reboot.$!$run_autogen:$ @sys$update:autogen getdata reboot check_feedback$ EXIT vmi$_success$$! If we get here the sysgen parameters are not set correctly, but the$! user has not allowed a reboot.  Display an error message and then exit.$!$need_reboot:$ type sys$input  The installation procedure determined that some system parameter values  require modification to start the DECwindows Motif Version 1.2-3 for  OpenVMS software. To set your parameters correctly, run AUTOGEN using  the following DCL command:        $ @SYS$UPDATE:AUTOGEN GETDATA REBOOT CHECK_FEEDBACK  This procedure adjusts your system parameters and reboots the system.$ EXIT vmi$_success$!$v62_reboot:$ @sys$system:shutdown 0 SHUTDOWN YES NO LATER YES NONE$ EXIT vmi$_success$!$!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++$! CONTROL Y handler$!---------------------------------------------------------------------------$handle_control_y:$ EXIT