                            (4 $      PWRKV50F1050.F                                                                                                                                                                                               p               PWRKV50F1050.F  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY NW$BLD_ROOT:[NW.KIT.EXE]*.*; KIT$BLD_ROOT:[KIT]PWRKV50F1050.F/LABEL=(PATHWORKS)/SAVE/BLOCK=9000/GROUP=25/NOINIT/NOREWI  VAX/VMS SPKITBLD Procedure  PWBUILD           @
mD      V6.1 	 _POCUS:: 
    _$1$DUA2000:  V6.1 
  $       }
                             * [NW.KIT.EXE]EXAMPLE.C;1 +  , \  .     /     4 U       #                   - n  0   1    2   3      K   P   W   O     5   6 j{`1  7 @mD  8          9          G    H  J                         /*
**  Sample source code example to make some Portable NetWare calls to
**  attach to a server and create a few files. Read PWVN$EXAMPLES:EXAMPLE.COM
**  to see how to build and link this image.
**
*/

#include <stdio.h>
#include <nwapi.h>
#include <nwerrors.h>
#include "getopt.h"

#define USERTYPE        1

static CreateFile(uint16 connID, char *fileName);
static CheckError(int ccode, char *name);

main(argc, argv)
int	argc;
char **argv;
{
	uint16		connID;
	int		ccode;
	char		c;
	char		*server = 0;
	char		*userName = 0;
	char		*password = 0;
	int		files = 1;
	char		*volume = 0;
	int		i;
	char		buf[255];
	
	while( ( c = getopt( argc, argv, "f:s:u:v:p:" ) ) != -1 ) {
	    switch( c ) {
		case	'f':	files = atoi(optarg);
		    break;
		case	's':	server = optarg;
		    break;
		case	'u':	userName = optarg;
		    break;
		case	'v':	volume = optarg;
		    break;
		case	'p':	password = optarg;
		    break;
		case	'?':
		    printf( "Usage: %s ", argv[0] );
		    printf( "-s SERVER [-u USERNAME] [-p PASSWORD] [-v VOLUME] [-f FILECOUNT]\n" );
		    return;
		}
	}

	if( !server )
	    {
	    printf( "Usage: %s ", argv[0] );
	    printf( "-s SERVER [-u USERNAME] [-p PASSWORD] [-v VOLUME] [-f FILECOUNT]\n" );
	    return;
	    }
	
	if( !userName )
		userName = "SUPERVISOR";
	if( !password )
		password = "";
	if(!volume)
		volume = "SYS:";

	printf("Attaching to server %s...\n", server);
	ccode = NWAttachToServerPlatform( server, &connID );
	CheckError(ccode, "NWAttachToServerPlatform");
	printf("   Attach to server <%s> succeeded.\n", server);

	printf("Logging in as user %s...\n", userName);
	ccode = NWLoginToServerPlatform( connID, userName, USERTYPE, password );
	CheckError(ccode, "NWLoginToServerPlatform");
	printf("   Log in as user <%s> succeeded.\n", userName);
	
	for (i = 0; i < files; i++)
	    {
	    sprintf(buf, "%s%06d", volume, i);
	    CreateFile(connID, buf);
	    }

	printf("Detaching...\n");
	ccode = NWDetachFromServerPlatform( connID );
	CheckError(ccode, "NWDetachFromServerPlatform");
	printf("   Detached.\n");
	
	printf("Closing transport...\n");
	ccode = NWCloseTransport();
	CheckError(ccode, "NWCloseTransport");
	printf("   Closed transport.\n");
}

static CreateFile(uint16 connID, char *fileName)
{
char		    data[132];
int		    ccode;
int		    i;
uint32		    startingOffset = 0;
uint32		    bytesToWrite;
NWFileHandle_ta     fileHandle;
NWPath_t	    path;
char		    buf[255];
FILE		    *f;

    bytesToWrite = sizeof(data);
    memset (data, 'X', bytesToWrite);
	
    path.dirHandle = 0;
    path.serverConnID = connID;
    path.pathName = fileName;

    printf("Creating file <%s>...\n", fileName);
    ccode = NWCreateFile( &path, NWFA_NORMAL, fileHandle );
    CheckError(ccode, "NWCreateFile");
    printf("   Created file <%s>.\n", fileName);
    
    printf("Writing file <%s>...\n", fileName);
    ccode = NWWriteFile( connID, fileHandle, &startingOffset, bytesToWrite, data );
    CheckError(ccode, "NWWriteFile");
    printf("   File <%s> written.\n", fileName);

    printf("Closing file <%s>...\n", fileName);
    ccode = NWCloseFile( connID, fileHandle);
    CheckError(ccode, "NWCloseFile");
    printf("   File <%s> closed.\n", fileName);

}

static CheckError(int ccode, char *name)
{
    if (ccode != SUCCESS)
	{
	printf("ERROR: %s failed; error = %x(hex)\n", name, NWErrno);
	exit(1);
	}
}

                                                                                                                                                                                                                                            * [NW.KIT.EXE]EXAMPLE.COM;1 +  , \  . 2    /     4 D   2    @                   - n  0   1    2   3      K   P   W   O 3    5   6 VV~  7 "mD  8          9          G    H  J                       D $! Command file to compile and link sample NetWare program EXAMPLE.C $! $! Compile and link the C file0 $ cc pwvn$examples:example, pwvn$examples:getopt4 $ link example, getopt, pwvn$examples:example/option $!/ $! define foreign command to access the program 6 $ EXAMPLE == "$" + f$enviroment("DEFAULT") + "EXAMPLE"                                                                                                                                                                                                               * [NW.KIT.EXE]EXAMPLE.OPT;1 +  , \  .     /     4 #       F                    - n  0   1    2   3      K   P   W   O     5   6 	q|  7 @=mD  8          9          G    H  J                        SYS$LIBRARY:VAXCRTL.EXE/share # SYS$LIBRARY:PWVN$NWAPISHR.EXE/share                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [NW.KIT.EXE]GETOPT.C;1 +  , \  . 2    /     4 I   2                       - n  0   1    2   3      K   P   W   O 3    5   6 1Nt~  7 ©mD  8          9          G    H  J                          #include <stdio.h>
#include "getopt.h"

	char	noshare * optarg;
	int	noshare optind = 1;
	int	noshare opterr = 1;

	int	getopt(   int argc, char ** argv, char * optstr   );

int
getopt (argc, argv, optstr)
	int	argc;
	char	** argv;
	char	* optstr;
{
	char	* arg;
	char	ch;
	char	* errmsg = (char *)0;
	char	* cp1;
	int	i1;
	char	* opt;
static	int	optchind = 1;

top:
	if (optind >= argc
	|| !(opt = argv[optind])
	||  opt[0] != '-'
	||  optchind <= 0)
		return -1;
	if (!opt[optchind]) {
		optind++;
		for (i1 = optind; i1 < argc  &&  argv[i1]; i1++) {
			if (argv[i1] == optarg) {
				optind = i1 + 1;
				break;
			}
		}
		optchind = 1;
		goto top;
	}
	if (opt[1] == '-') {
		optchind = -1;
		optind++;
		return -1;
	}
	arg = argv[optind + 1];
	for (cp1 = optstr; ch = *cp1; cp1++) {
		if (ch == opt[optchind]) {
			if (cp1[1] == ':') {
				for (i1 = ++optind; i1 < argc  &&  argv[i1]; i1++) {
					if (argv[i1] == optarg) {
						arg = argv[i1 + 1];
						break;
					}
				}
				if (!(optarg = arg)  ||  arg[0] == '-')
					errmsg = "%s: option '%c' not followed by argument\n";
				else {
					optind++;
					optchind = 0;
				}
			}
			break;
		}
	}
	if (!ch)
		errmsg = "%s: unknown option '%c'\n";
	if (errmsg  &&  opterr) {
	        char *the_program_name = "getopt";
                fprintf(stderr, errmsg, the_program_name, opt[optchind]);
		ch = '?';
	}
	optchind++;
	if (!opt[optchind]) {
		optind++;
		optchind = 1;
	}
	return ch;
}
                                                                                                        * [NW.KIT.EXE]GETOPT.H;1 +  , \  . 2    /     4 ?   2                        - n  0   1    2   3      K   P   W   O 3    5   6 \#r՗  7 `ȩmD  8          9          G    H  J                          /* A simple "getopt" routine for VMS */

extern	char	noshare * optarg;
extern	int	noshare optind;
extern	int	noshare opterr;

extern	int	getopt(   int argc, char ** argv, char * optstr   );
                                                                                                                                                                                                                                                                                                                                                 * [NW.KIT.EXE]NWAPI.H;1 +  , *   . 2    /     4 N   2   ! ?                   - n  0   1    2   3      K   P   W   O 3    5   6 p  7 ˩mD  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                         p $      PWRKV50F1050.F                 *  n [NW.KIT.EXE]NWAPI.H;1                                                                                                          N     2                         @{ "            /*
 *
 *	This is a header file to be included by the NetWare application program 
 *
 */

#ifndef _api_h_
#define _api_h_

/* The rest of the code requirement unaligned structures, so force it here  */
#ifdef __DECC
#pragma nostandard
#pragma member_alignment __save
#pragma nomember_alignment
#endif

/* Include basetypes.h directly so we don't depend on that file */
#ifndef __basetypes__
#define __basetypes__

/*
 *	Define base types.  To avoid conflicts with DEC C's types, include its
 *	declarations of these instead.
 */
#ifdef __DECC

#include <ints.h>

#else

typedef	unsigned int		uint32;	/* 32-bit unsigned type */
typedef	unsigned short		uint16;	/* 16-bit unsigned type */
typedef	unsigned char		uint8;	/* 8-bit unsigned type */ 	

typedef	int			int32;	/* 32-bit signed type */
typedef	short			int16;	/* 16-bit signed type */
typedef char			int8;	/* 8-bit signed type */

#endif
#endif


typedef short			NWBoolean_ts;

#define 	SUCCESS		0

#ifndef 	TRUE
#define		TRUE		1
#define		FALSE		0
#endif

/* Declaration of NWErrno */
extern volatile uint32 noshare NWErrno;

/*******************************************************************
 *
 * Information pertaining to the accounting API calls
 *
 *******************************************************************/
#define		NWMAX_OBJECT_NAME_LENGTH	48
#define		NWMAX_NUMBER_OF_HOLDS		32
#define		NWMAX_COMMENT_LENGTH		48

/* the following definitions are for use with NWSubmitAccountNote */
#define 	NWAN_CONNECT_TIME		1
#define		NWAN_DISK_STORAGE		2
#define		NWAN_LOG_IN			3
#define		NWAN_LOG_OUT			4
#define		NWAN_ACCOUNT_LOCKED		5
#define		NWAN_SERVER_TIME_MODIFIED	6

typedef struct {
	uint32	objectID;
	int32	holdAmount;
} NWHoldInfo_t;


/*******************************************************************
 *
 * Information pertaining to the bindery API calls
 *
 *******************************************************************/
 /* object and property states */
#define		NWBF_STATIC			0x00	
#define		NWBF_DYNAMIC			0x01	

/* property types */
#define		NWBF_ITEM			0x00
#define		NWBF_SET			0x02

#define		NWMAX_SEGMENT_DATA_LENGTH	128
#define		NWMAX_OBJECT_NAME_LENGTH	48
#define		NWMAX_PROPERTY_NAME_LENGTH	16	
#define		NWMAX_MEMBER_NAME_LENGTH	48	
#define		NWMAX_PASSWORD_LENGTH		128
#define		NWMAX_PASSWORD_ENCRYPT_LENGTH	16
#define		NWMAX_PROPERTY_VALUE_LENGTH     128	

#define 	NWBS_ANY_READ			0x00
#define		NWBS_LOGGED_READ		0x01
#define		NWBS_OBJECT_READ		0x02
#define		NWBS_SUPER_READ			0x03
#define		NWBS_BINDERY_READ		0x04
#define		NWBS_ANY_WRITE			0x00
#define		NWBS_LOGGED_WRITE		0x10
#define		NWBS_OBJECT_WRITE		0x20
#define		NWBS_SUPER_WRITE		0x30
#define		NWBS_BINDERY_WRITE		0x40

#define		NWOT_WILD			0xFFFF
#define		NWOT_UNKNOWN			0x0000
#define		NWOT_USER			0x0001
#define		NWOT_USER_GROUP			0x0002
#define		NWOT_PRINT_QUEUE		0x0003
#define		NWOT_FILE_SERVER		0x0004
#define		NWOT_JOB_SERVER			0x0005
#define		NWOT_GATEWAY			0x0006
#define		NWOT_PRINT_SERVER		0x0007
#define		NWOT_ARCHIVE_QUEUE		0x0008
#define		NWOT_ARCHIVE_SERVER		0x0009
#define		NWOT_JOB_QUEUE			0x000A
#define		NWOT_ADMINISTRATION		0x000B
#define		NWOT_NAS_SNA_GATEWAY		0x0021
#define		NWOT_REMOTE_BRIDGE_SERVER	0x0024
#define		NWOT_TIME_SYNCHRONIZATION_SERVER 0x002D
#define		NWOT_ARCHIVE_SERVER_DYNAMIC_SAP	0x002E
#define		NWOT_ADVERTISING_PRINT_SERVER	0x0047
#define		NWOT_BTRIEVE_VAP		0x0050
#define		NWOT_PRINT_QUEUE_USER		0x0053
#define		NWOT_NVT_SERVER			0x009E

typedef struct {
	char		objectName[ NWMAX_OBJECT_NAME_LENGTH ];
	uint32		objectID;
	uint16		objectType;
	uint8		objectState;
	uint8		objectSecurity;
} NWObjectInfo_t;

typedef struct {
	char		propertyName[ NWMAX_PROPERTY_NAME_LENGTH ];
	uint8		propertyStateAndType;
	uint8		propertySecurity;
	uint8		propertyHasAValue;
} NWPropertyInfo_t;


/******************************************************************* 
* 
* Information pertaining to the connection API calls 
*
* *******************************************************************/ 
#define 	NWMAX_OBJECT_NAME_LENGTH	48	
#define		NWMAX_LOGIN_TIME_LENGTH		7 
#define		NWMAX_INTERNET_ADDRESS_LENGTH	12 
#define		NWMAX_KEYED_PASSWORD_LENGTH	8



/********************************************************************
 *
 * Information pertaining to the file system API calls 
 *
 ********************************************************************/
#define		NWMAX_DIR_PATH_LENGTH		255
#define		NWMAX_FILE_HANDLE_SIZE		6
#define		NWMAX_DIR_NAME_LENGTH		16	
#define		NWMAX_FILE_NAME_LENGTH		16	
#define		NWMAX_VOLUME_NAME_LENGTH	16	
#define		NWMAX_NS_NAME			16
#define		NWMAX_DS_NAME			16
#define		NWMAX_NUM_NS			10 
#define		NWMAX_NUM_DS			10
#define		NWMAX_NS_COUNT			10 
#define		NWMAX_USER_RESTRICTIONS		12

/* file attributes */
#define		NWFA_NORMAL			0x00000000L
#define		NWFA_READ_ONLY			0x00000001L
#define		NWFA_HIDDEN			0x00000002L
#define		NWFA_SYSTEM			0x00000004L
#define		NWFA_EXECUTE_ONLY		0x00000008L
#define		NWFA_NEED_ARCHIVE		0x00000020L
#define		NWFA_SHARABLE			0x00000080L
#define		NWFA_TRANSACTIONAL		0x00001000L
#define		NWFA_INDEXED			0x00002000L
#define		NWFA_READ_AUDIT 		0x00004000L
#define		NWFA_WRITE_AUDIT		0x00008000L
#define		NWFA_PURGE			0x00010000L
#define		NWFA_RENAME_INHIBIT		0x00020000L
#define		NWFA_DELETE_INHIBIT		0x00040000L
#define		NWFA_COPY_INHIBIT		0x00080000L
						
/* Trustee Access Rights in a 286 Network directory */
#define		NWTA_NONE             ((uint8)0x00)
#define		NWTA_READ             ((uint8)0x01)
#define		NWTA_WRITE            ((uint8)0x02)
#define		NWTA_OPEN             ((uint8)0x04)
#define		NWTA_CREATE           ((uint8)0x08)
#define		NWTA_DELETE           ((uint8)0x10)
#define		NWTA_OWNERSHIP        ((uint8)0x20)
#define		NWTA_SEARCH           ((uint8)0x40)
#define		NWTA_MODIFY           ((uint8)0x80)
#define		NWTA_ALL              ((uint8)0xFF)

/* trustee rights and inherited rights for 386 */
#define		NWTR_NONE		0x0000
#define		NWTR_READ		0x0001
#define		NWTR_WRITE		0x0002
/*					0x0004 ignore this bit */
#define		NWTR_CREATE		0x0008
#define		NWTR_ERASE		0x0010
#define		NWTR_ACCESS		0x0020
#define		NWTR_FILE_SCAN		0x0040
#define		NWTR_MODIFY		0x0080
#define		NWTR_SUPERVISOR 	0x0100
#define		NWTR_NORMAL		0x00FF 
#define		NWTR_ALL		0x01FF

/* search attributes */
#define		NWSA_NONE		0x00
#define		NWSA_HIDDEN		0x02
#define		NWSA_SYSTEM		0x04
#define		NWSA_BOTH		0x06
#define		NWSA_FILES_ONLY 	0x20  /* NOT for 286 */
#define		NWSA_DIRECTORIES_ONLY	0x10  /* NOT for 286 */

/* desired open access rights */
#define		NWOR_READ		0x01
#define		NWOR_WRITE		0x02
#define		NWOR_DENY_READ		0x04
#define		NWOR_DENY_WRITE 	0x08
#define		NWOR_COMPATIBILITY	0x10
#define		NWOR_SYNC_MODE		0x40

/* change attributes used in conjunction with set dir/file info */
#define		NWCA_NAME			0x0001	
#define		NWCA_ATTRIBUTES			0x0002
#define		NWCA_CREATE_DATE_AND_TIME	0x000C
#define		NWCA_OWNER_ID			0x0010
#define		NWCA_LAST_ARCHIVED_DATE_AND_TIME    0x0060
#define		NWCA_LAST_ARCHIVED_ID		0x0080
#define		NWCA_LAST_MODIFY_DATE_AND_TIME	0x0300
#define		NWCA_LAST_MODIFY_ID		0x0400
#define		NWCA_LAST_ACCESSED_DATE		0x0800
#define		NWCA_INHERITED_RIGHTS_MASK	0x1000
#define		NWCA_DIR_RESTRICTION		0x2000


typedef		uint8	NWDirHandle_ts;
typedef 	uint8	NWFileHandle_ta[ NWMAX_FILE_HANDLE_SIZE ];

typedef struct {
	NWDirHandle_ts	dirHandle;
	uint16	serverConnID;
	char	*pathName;
} NWPath_t;

typedef struct {
	uint32	totalBlocks;
	uint32	availableBlocks;
	uint32	purgableBlocks;
	uint32	notYetPurgableBlocks;
	uint32	totalDirEntries;
	uint32	availDirEntries;
	uint32	maxDirEntriesUsed;
	uint16	volNum;
	uint16	sectorsPerBlock;
	uint8	isHashed;
	uint8	isCached;
	uint8	isRemovable;
	uint8	isMounted;
	char	volName[ NWMAX_VOLUME_NAME_LENGTH ];
} NWVolUsage_t;

typedef struct {
	uint32	attributes;
	uint32	creationDateAndTime;
	uint32	ownerID;
	uint32	archiveDateAndTime;
	uint32	archiverID;
	uint32	lastModifyDateAndTime;
	uint32	dirRestriction;
	uint16	inheritedRightsMask;
	uint8	nameSpaceID;
	char	entryName[ NWMAX_DIR_NAME_LENGTH ];
} NWDirEntryInfo_t;

typedef struct {
	uint32	attributes;
	uint32	creationDateAndTime;
	uint32	ownerID;
	uint32	archiveDateAndTime;
	uint32	archiverID;
	uint32	updateDateAndTime;
	uint32	updatorID;
	uint32	fileSize;
	uint32	lastAccessDateAndTime;
	uint16	inheritedRightsMask;
	uint8	nameSpaceID;
	char	entryName[ NWMAX_FILE_NAME_LENGTH ];
} NWFileEntryInfo_t;

typedef struct {
	uint32	trusteeID;
	uint16	trusteeRights;
} NWTrusteeRights_t;

typedef struct {
	uint16	level;
	uint32	maxBlocks;
	uint32	availableBlocks;
} NWDirRestriction_t;

typedef struct {
	uint32	objectID;
	uint32	restriction;
} NWUserRestriction_t;

typedef struct
{
	uint32   deletedFileTime;
	uint32   deletedDateAndTime;
	uint32   deleterID;
                                                                                                                                                                                                                                                                           ] $      PWRKV50F1050.F                 *  n [NW.KIT.EXE]NWAPI.H;1                                                                                                          N     2                                       	uint32   attributes;
	uint32   creationDateAndTime;
	uint32   ownerID;
	uint32   archiveDateAndTime;
	uint32   archiverID;
	uint32   updateDateAndTime;
	uint32   updatorID;
	uint32   fileSize;
	uint32   inheritedRightsMask;
	uint32   lastAccessDateAndTime;
	uint8    nameSpaceID;
	char     fileName[NWMAX_NS_NAME];
} NWSalvageableInfo_t;

typedef struct {
	uint8	definedDataStreams;
	char	dataStreamName[NWMAX_NUM_DS] [NWMAX_DS_NAME];
} NWDataStreamInfo_t;
	
typedef struct {
	uint8	definedNameSpaces;
	char	nameSpaceName[NWMAX_NUM_NS] [NWMAX_NS_NAME];
	uint8	nameSpaceDataStreams;
	NWDataStreamInfo_t	dataStream[NWMAX_NUM_NS];
	uint8	loadedNSCount;
	uint8	loadedNS[NWMAX_NS_COUNT];
	uint8	volumesNSCount;
	uint8	volumesNS[NWMAX_NS_COUNT];
	uint8	volumesDSCount;
	uint8	volumesDS[NWMAX_NS_COUNT];
} NWNameSpaceInfo_t;


/*******************************************************************
 *
 * Information pertaining to the path services API calls
 *
 *******************************************************************/



/*******************************************************************
 *
 * Information pertaining to the queue management API calls
 *
 *******************************************************************/
#define		NWMAX_QUEUE_NAME_LENGTH 			48
#define		NWMAX_JOB_STRUCT_SIZE				256
#define		NWMAX_QUEUE_SUBDIR_LENGTH			119
#define		NWMAX_NUMBER_OF_JOB_NUMBERS			250
#define		NWMAX_NUMBER_OF_SERVER_CONN_NUMBERS		25
#define		NWMAX_NUMBER_OF_SERVER_OBJECT_IDS		25
#define		NWMAX_SERVER_STATUS_RECORD_LENGTH		64
#define		NWMAX_QUEUE_JOB_TIME_SIZE			6
#define		NWMAX_JOB_FILE_NAME_LENGTH			14
#define		NWMAX_JOB_DESCRIPTION_LENGTH			50
#define		NWMAX_CLIENT_RECORD_LENGTH			152
#define		NWMAX_FORM_NAME_LENGTH				16
#define		NWMAX_BANNER_NAME_FIELD_LENGTH			13
#define		NWMAX_BANNER_FILE_FIELD_LENGTH			13
#define		NWMAX_HEADER_FILE_NAME_LENGTH			14
#define		NWMAX_JOB_DIR_PATH_LENGTH			80	

/* the following are job control flags */
#define		NWCF_OPERATOR_HOLD		0x80
#define		NWCF_USER_HOLD			0x40
#define		NWCF_ENTRY_OPEN			0x20
#define		NWCF_SERVICE_RESTART		0x10
#define		NWCF_SERVICE_AUTO_START		0x08

/* the following are control flags used with NWPrintRecord_t */
#define		NWPCF_SUPPRESS_FF		0x0008
#define		NWPCF_NOTIFY_USER		0x0010
#define		NWPCF_TEXT_MODE			0x0040
#define		NWPCF_PRINT_BANNER		0x0080

/* the queue status flags are used with NWSetQueueCurrentStatus */
#define		NWQS_NO_SERVER_RESTRICTIONS	0x00
#define		NWQS_NO_MORE_JOBS		0x01
#define		NWQS_NO_MORE_SERVER_ATTACHMENTS	0x02
#define		NWQS_SERVERS_DISABLED		0x04

typedef unsigned char NWClientRecord_ta[ NWMAX_CLIENT_RECORD_LENGTH ];

typedef struct {
	uint8	versionNumber;
	uint8	tabSize;
	uint16	numCopies;
	uint16	controlFlags;
	uint16	linesPerPage;
	uint16	charsPerLine;
	char	formName[ NWMAX_FORM_NAME_LENGTH ];
	char	bannerNameField[ NWMAX_BANNER_NAME_FIELD_LENGTH ];
	char	bannerFileField[ NWMAX_BANNER_FILE_FIELD_LENGTH ];
	char	headerFileName[ NWMAX_HEADER_FILE_NAME_LENGTH ];
	char	directoryPath[ NWMAX_JOB_DIR_PATH_LENGTH ];
} NWPrintRecord_t;

typedef struct {
	uint8	clientStation;
	uint8	clientTask;
	uint32	clientID;
	uint32	targetServerID;
	uint8	targetExecutionTime[ NWMAX_QUEUE_JOB_TIME_SIZE];
	uint8	jobEntryTime[ NWMAX_QUEUE_JOB_TIME_SIZE ];
	uint16	jobNumber;
	uint16	jobType;
	uint8	jobPosition;
	uint8	jobControlFlags;
	uint8	jobFileName[ NWMAX_JOB_FILE_NAME_LENGTH ];
	NWFileHandle_ta		jobFileHandle;
	uint8	servicingServerStation;
	uint8	servicingServerTaskNumber;
	uint32	servicingServerIDNumber;
	uint8	jobDescription[ NWMAX_JOB_DESCRIPTION_LENGTH ];
	NWClientRecord_ta	queueRecord;
} NWQueueJobStruct_t;


/*******************************************************************
 *
 * Information pertaining to the server platform API calls
 *
 *******************************************************************/
#define		NWMAX_OBJECT_NAME_LENGTH		48	
#define		NWMAX_COMPANY_NAME_LENGTH		80 
#define		NWMAX_DESCRIPTION_LENGTH		80
#define		NWMAX_DATE_LENGTH			24
#define		NWMAX_COPYRIGHT_NOTICE_LENGTH		80
#define		NWMAX_SERVER_NAME_LENGTH		48
#define		NWMAX_CONNECTION_LIST_LENGTH		50

typedef struct {
	uint16	majorVersion;
	uint16	minorVersion;
	uint16	revision;
	uint16	SFTLevel;
	uint16	TTSLevel;
	uint16	accountingVersion;
	uint16	VAPVersion;
	uint16	queueingVersion;
	uint16	printServerVersion;
	uint16	virtualConsoleVersion;
	uint16	securityRestrictionLevel;
	uint16	internetBridgeSupport;
	uint16	maxClientConnSupported;
	uint16	clientConnInUse;
	uint16	peakClientConnUsed;
	uint16	maxVolumes;
	char	serverName[ NWMAX_SERVER_NAME_LENGTH ];
} NWServerPlatformInfo_t;

typedef struct {
	uint8	year;
	uint8	month;
	uint8	day;
	uint8	hour;
	uint8	minute;
	uint8	second;
	uint8	dayOfWeek;	/* 0 means sunday */
} NWServerPlatformDateAndTime_t;

typedef struct {    /* For 286 core printer use only */
	uint8	printerHalted;
	uint8	printerOffLine;
	uint8	currentFormType;
	uint8	redirectedPrinter;
} NWPrinterInfo_t;

typedef struct {
	char	companyName[ NWMAX_COMPANY_NAME_LENGTH ];
	char	revisionDescription[ NWMAX_DESCRIPTION_LENGTH ];
	char	revisionDate[ NWMAX_DATE_LENGTH ];
	char	copyrightNotice[ NWMAX_COPYRIGHT_NOTICE_LENGTH ];
} NWDescriptionStrings_t;


/*******************************************************************
 *
 * The following structures are used by sconsole to retrieve server
 * statistics per the 3.11 interface definition, and have been
 * retrofitted into the 3.01b for VMS to provide statistics info
 * given the lack of a private interface for use by sconsole.
 *
 * 03 Jan 91	TRL	Retrofit
 *
 *******************************************************************/


typedef struct {  /* For Portable NetWare only  */
	uint32	NWProcs;
	uint32	TotalPackets;
	uint32	CreateConnectionRequests;
	uint32	CreateFileRequests;
	uint32	OpenRequests;
	uint32	ReadRequests;
	uint32	WriteRequests;
	uint32	NumOpenFiles;
	uint32	MaxSimultaneousOpens;
	uint32	LostPacketResends;
	uint32	CacheHits;
	uint32	CacheMisses;
	uint32	PrintRequests;
	uint32	MessageRequests;
	uint32	DirectoryRequests;
	uint32	BinderyAndMiscRequests;
	uint32	UnknownRequests;
	uint32	TTSRequests;
} NWServerPlatformStats_t;


typedef struct {  /* For Portable NetWare only  */
	uint32	TTSRequests;
	uint32	TotalWrites;
	uint32	TotalBackouts; 
	uint32	TransactionBackouts;
	uint32	UnfilledBackoutRequests;
	uint32	NumTransactions;
	uint32	MaxTransactionsOpened;
} NWServerPlatformTTS_t;

			
typedef struct {  /* For Portable NetWare only  */
	uint32	LogicalLockRequests;
	uint32	NumLogicalLocks;
	uint32	MaxSimultaneousLogLocks;
	uint32	FileLockRequests;
	uint32	NumFileLocks;
	uint32	MaxSimultaneousFileLocks;
	uint32	PhysLockRequests;
	uint32	NumPhysLocks;
	uint32	MaxSimultaneousPhysLocks;
	uint32	SemaphoreRequests;
	uint32	NumSemaphores;
	uint32	MaxSimultaneousSemaphores;
} NWServerPlatformSync_t;

			
typedef struct {  /* For Portable NetWare only  */
	uint32	SharedMemorySize;
	uint32	CurrentSharedMemoryUsage;
	uint32	MaxSharedMemoryUsed;	
} NWServerPlatformSharedMemoryInfo_t;
			
			
/*******************************************************************
 *
 * Information pertaining to the synchronization platform API calls
 *
 *******************************************************************/
#define		NWMAX_LOGICAL_RECORD_NAME_LENGTH 	80
#define		NWMAX_SEMAPHORE_NAME_LENGTH 		127

/* file lock log flags */
#define		NWFL_LOG_ONLY				0x00
#define		NWFL_LOG_AND_LOCK			0x01

/* physical and logical record log flags */
#define		NWPL_LOG_ONLY				0x00
#define		NWPL_LOG_AND_LOCK_EXCLUSIVE		0x01
#define		NWPL_LOG_AND_LOCK_SHAREABLE		0x03

/* logical and physical lock set flags */
#define		NWLS_EXCLUSIVE				0x00
#define		NWLS_SHAREABLE				0x02


/*******************************************************************
 *
 * Information pertaining to the transaction tracking platform API calls
 *
 *******************************************************************/
/* currently no data */


#ifdef __DECC
#pragma member_alignment __restore
#pragma standard
#endif

#endif
                                                                                                                                                                                                                * [NW.KIT.EXE]NWERRORS.H;1 +  , s  . B    /     4 I   B   : W                   - n   0   1    2   3      K   P   W   O C    5   6 E
  7  ҩmD  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     a+I7 $      PWRKV50F1050.F                 s n [NW.KIT.EXE]NWERRORS.H;1                                                                                                       I     B                          "            /*======================================================================
  ==    program         : NetWare Directory Services Platform Library
  ==
  ==    file            : nwerrors.h
  ==
  ==    date            : 13 December 1989
  ==
  ==    modifications   :
  ==
  ==    comments        : The format of the error code, which is 
  ==					contained in an unsigned long word 
  ==					(32-bits), is as follows:
  ==                 ||   high word       |       low word           ||
  ==                   ----------------------------------------------
  ==                 ||high byte| low byte| high byte  | low byte    ||
  ==                   ==============================================
  ==                 ||reserved | section | subsection | server error||
  ==                   ==============================================
  ==
  ==    Copyright (c) 1988-1990 Novell, Inc.  All rights reserved.
  ==
  ===================================================================*/

#ifndef _NWERRORS_
#define _NWERRORS_

/* Declaration of NWErrno */
extern volatile uint32 noshare NWErrno;

#define NWSUCCESSFUL                       0x00000000L

/*=====================================================================
=                   		Sub-Section Base Masks
=
= 0x00      Sub-Section code is for errors returned by servers running
				netware 386 and later and errors created by the OS2
				api library software team before 3/1/90.
				Sub-Section code 0x00 and low order bytes between
				0x30-0x70 are for errors that were created by 
				the portable api library software team and have to 
				passed back using only one byte (nwccode_t) and later 
				ored with a section base mask.
=
= 0x10		Sub-Section code is reserved for errors that are like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=
= 0x20		Sub-Section code is reserved for errors that are non-like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=======================================================================
*/

/*======================================================================
=                   		Section Base Masks
=
========================================================================
*/
#define NWERR_ACCOUNT           0x00010000L
#define NWERR_ACCOUNT_INVALID_PARAMETERS   (NWERR_ACCOUNT | 0x000020FBL)
#define NWERR_ACCOUNT_INVALID_CONNECTION_ID	(NWERR_ACCOUNT | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_ACCOUNT_INVALID_NCP_PACKET_LENGTH (NWERR_ACCOUNT | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_ACCOUNT_SETTING_UP_TIMEOUT		(NWERR_ACCOUNT | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_ACCOUNT_TRANSPORT_SEND			(NWERR_ACCOUNT | \
													NWERR_TRANSPORT_SEND
#define NWERR_ACCOUNT_IN_SETTING_SIGNALS		(NWERR_ACCOUNT | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_ACCOUNT_INVALID_PARAMETER_LENGTH	(NWERR_ACCOUNT | \
													0x00001001L)



#define	NWERR_BINDERY			0x00070000L
#define NWERR_BIND              NWERR_BINDERY
#define NWERR_BIND_SERVER_OUT_OF_MEMORY     (NWERR_BIND | 0x96)
#define NWERR_BIND_LOGIN_LOCKOUT            (NWERR_BIND | 0xC5)
#define NWERR_BIND_DUPLICATE_PASSWORD       (NWERR_BIND | 0xD7)
#define NWERR_BIND_NO_DISK_TRACK            (NWERR_BIND | 0xE7)
#define NWERR_BIND_WRITE_TO_GROUP           (NWERR_BIND | 0xE8)
#define NWERR_BIND_MEMBER_EXISTS            (NWERR_BIND | 0xE9)
#define NWERR_BIND_NO_SUCH_MEMBER           (NWERR_BIND | 0xEA)
#define NWERR_BIND_NOT_SET_PROPERTY         (NWERR_BIND | 0xEB)
#define NWERR_BIND_NO_SUCH_SET              (NWERR_BIND | 0xEC)
#define NWERR_BIND_OBJECT_EXISTS            (NWERR_BIND | 0xEE)
#define NWERR_BIND_ILLEGAL_NAME             (NWERR_BIND | 0xEF)
#define NWERR_BIND_ILLEGAL_WILDCARD         (NWERR_BIND | 0xF0)
#define NWERR_BIND_BINDERY_SECURITY         (NWERR_BIND | 0xF1)
#define NWERR_BIND_NO_OBJECT_READ           (NWERR_BIND | 0xF2)
#define NWERR_BIND_NO_OBJECT_DELETE         (NWERR_BIND | 0xF4)
#define NWERR_BIND_NO_OBJECT_CREATE         (NWERR_BIND | 0xF5)
#define NWERR_BIND_NO_PROPERTY_DELETE       (NWERR_BIND | 0xF6)
#define NWERR_BIND_NO_PROPERTY_CREATE       (NWERR_BIND | 0xF7)
#define NWERR_BIND_NO_PROPERTY_WRITE        (NWERR_BIND | 0xF8)
#define NWERR_BIND_NO_PROPERTY_READ         (NWERR_BIND | 0xF9)
#define NWERR_BIND_NO_SUCH_PROPERTY         (NWERR_BIND | 0xFB)
#define NWERR_BIND_NO_SUCH_OBJECT           (NWERR_BIND | 0xFC)
#define NWERR_BIND_DIR_LOCKED               (NWERR_BIND | 0xFE)
#define NWERR_BIND_HARD_FAILURE             (NWERR_BIND | 0xFF)
#define NWERR_BIND_FAILURE                  (NWERR_BIND | 0xFF)
#define NWERR_BIND_NO_MORE_OBJECTS			NWERR_BIND_NO_SUCH_OBJECT
#define NWERR_BIND_NO_MORE_PROPERTIES       NWERR_BIND_NO_SUCH_PROPERTY
#define NWERR_BIND_NO_MORE_PROP_VALS        NWERR_BIND_NO_PROPERTY_READ
#define NWERR_BIND_INVALID_PARAMETERS		(NWERR_BIND | 0x000020FBL)
#define NWERR_BIND_INVALID_CONNECTION_ID	(NWERR_BIND | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_BIND_INVALID_NCP_PACKET_LENGTH (NWERR_BIND | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_BIND_SETTING_UP_TIMEOUT		(NWERR_BIND | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_BIND_TRANSPORT_SEND			(NWERR_BIND | \
													NWERR_TRANSPORT_SEND
#define NWERR_BIND_IN_SETTING_SIGNALS		(NWERR_BIND | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_BIND_INVALID_PARAMETER_LENGTH	(NWERR_BIND | 0x00001001L)



#define NWERR_CONNECTION   		0x00090000L
#define NWERR_CONN        		0x00090000L
#define NWERR_CONN_INVALID_CONNECTION_ID	(NWERR_CONN | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_CONN_INVALID_NCP_PACKET_LENGTH (NWERR_CONN | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_CONN_SETTING_UP_TIMEOUT		(NWERR_CONN | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_CONN_TRANSPORT_SEND			(NWERR_CONN | \
													NWERR_TRANSPORT_SEND
#define NWERR_CONN_IN_SETTING_SIGNALS		(NWERR_CONN | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_CONN_INVALID_PARAMETER_LENGTH	(NWERR_CONN | 0x00001001L)
#define NWERR_CONN_SETTING_UP_INTERRUPT		(NWERR_CONN | 0x00002001L)
#define NWERR_CONN_TRANSPORT_OPEN			(NWERR_CONN | 0x00002002L)
#define NWERR_CONN_TRANSPORT_CLOSE			(NWERR_CONN | 0x00002003L)
#define NWERR_CONN_NOT_CONNECTED_TO_SERVER	(NWERR_CONN | 0x00002004L)
#define NWERR_CONN_CONNECT_LIST_OVERFLOW	(NWERR_CONN | 0x00000004L)
#define NWERR_CONN_UNENCRYPTED_PASSWORD		(NWERR_CONN | 0x000000D6L)
#define NWERR_CONN_SERVER_OUT_OF_MEMORY		(NWERR_CONN | 0x00000096L)
#define NWERR_CONN_NO_ACCOUNT_BALANCE		(NWERR_CONN | 0x000000C1L)
#define NWERR_CONN_CREDIT_LIMIT_EXCEEDED	(NWERR_CONN | 0x000000C2L)
#define NWERR_CONN_LOGIN_LOGOUT				(NWERR_CONN | 0x000000C5L)
#define NWERR_CONN_ACCOUNT_BAD				(NWERR_CONN | 0x000000D7L)
#define NWERR_CONN_PASSWORD_TOO_SHORT		(NWERR_CONN | 0x000000D8L)
#define NWERR_CONN_MAX_LOGINS_EXCEEDED		(NWERR_CONN | 0x000000D9L)
#define NWERR_CONN_BAD_LOGIN_TIME			(NWERR_CONN | 0x000000DAL)
#define NWERR_CONN_LOGIN_STATION_ERROR		(NWERR_CONN | 0x000000DBL)
#define NWERR_CONN_BAD_PASSWORD				(NWERR_CONN | 0x000000DEL)
#define NWERR_CONN_PASSWORD_EXPIRED			(NWERR_CONN | 0x000000DFL)
#define NWERR_CONN_WRITE_TO_GROUP			(NWERR_CONN | 0x000000E8L)
#define NWERR_CONN_NO_SUCH_SET				(NWERR_CONN | 0x000000ECL)
#define NWERR_CONN_PROPERTY_EXISTS			(NWERR_CONN | 0x000000EDL)
#define NWERR_CONN_ILLEGAL_NAME				(NWERR_CONN | 0x000000EFL)
#define NWERR_CONN_ILLEGAL_WILDCARD			(NWERR_CONN | 0x000000F0L)
#define NWERR_CONN_BINDERY_SECURITY			(NWERR_CONN | 0x000000F1L)
#define NWERR_CONN_NO_OBJECT_READ			(NWERR_CONN | 0x000000F2L)
#define NWERR_CONN_NO_PROPERTY_DELETE		(NWERR_CONN | 0x000000F6L)
#define NWERR_CONN_ALREADY_ATTACHED_TO_SERVER (NWERR_CONN | 0x000000F8L)
#define NWERR_CONN_NO_FREE_CONNECTION_SLOTS	(NWERR_CONN | 0x000000F9L)
#define NWERR_CONN_NO_MORE_SERVER_SLOTS		(NWERR_CONN | 0x000000FAL)
#define NWERR_CONN_INVALID_PARAMETERS		(NWERR_CONN | 0x000020FBL)
#define NWERR_CONN_UNKNOWN_FILE_SERVER		(NWERR_CONN | 0x000000FCL)
#define NWERR_CONN_SERVER_BINDERY_LOCKED	(NWERR_CONN | 0x000000FEL)
#define NWERR_CONN_NO_RESPONSE_FROM_SERVER	(NWERR_CONN | 0x000000FFL)




#define NWERR_FS                             0x00110000L
#define NWERR_FS_PATH_TOO_LONG               (NWERR_FS | 0x00000001L)   
#define NWERR_FS_NO_MORE_RESTRICTIONS        (NWERR_FS | 0x00000024L)
#define NWERR_FS_NO_CREATE_PRIVILEGES        (NWERR_FS | 0x00000084L)
#define NWERR_FS_NO_MORE_TRUSTEES                                                                                                                                                                                                                                                                              Ъn $      PWRKV50F1050.F                 s n [NW.KIT.EXE]NWERRORS.H;1                                                                                                       I     B                         ) "                     (NWERR_FS | 0x0000009CL)
#define NWERR_FS_DIRECTORY_NOT_EMPTY         (NWERR_FS | 0x000000A0L)
#define NWERR_FS_NOT_386_FILE_SYSTEM         (NWERR_FS | 0x000000FBL)
#define NWERR_FS_NO_SUCH_RESTRICTION         (NWERR_FS | 0x000000FEL)
#define NWERR_FS_FILE_ALREADY_EXISTS		(NWERR_FS | 0x000000FFL)
#define NWERR_FS_PATH_NOT_LOCATABLE			(NWERR_FS | 0x000000FFL)
#define NWERR_FS_NO_MODIFY_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_MODIFY_PRIVILEGES)
#define NWERR_FS_NO_DELETE_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_DELETE_PRIVILEGES)
#define NWERR_FS_ENTRY_IN_USE                (NWERR_FS | \
                                             NWERR_ENTRY_IN_USE)
#define NWERR_FS_NO_CONSOLE_RIGHTS           (NWERR_FS | \
                                             NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_FS_SERVER_OUT_OF_MEMORY        (NWERR_FS |   \
                                             NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_FS_VOL_DOES_NOT_EXIST          (NWERR_FS |   \
                                             NWERR_VOL_DOES_NOT_EXIST)
#define NWERR_FS_NO_SUCH_BINDERY_OBJ         (NWERR_FS |   \
                                             NWERR_NO_SUCH_BINDERY_OBJ)
#define NWERR_FS_NO_OBJECT_READ              (NWERR_FS |   \
                                             NWERR_NO_OBJECT_READ)
#define NWERR_FS_BAD_DIR_HANDLE              (NWERR_FS |   \
                                             NWERR_BAD_DIR_HANDLE)
#define NWERR_FS_INVALID_PATH                (NWERR_FS |   \
                                             NWERR_INVALID_PATH)
#define NWERR_FS_ENTRY_EXISTS                (NWERR_FS |   \
                                             NWERR_ENTRY_EXISTS)
#define NWERR_FS_DIR_FULL                    (NWERR_FS |   \
                                             NWERR_DIR_FULL)
#define NWERR_FS_ENTRY_NOT_FOUND             (NWERR_FS |   \
                                             NWERR_ENTRY_NOT_FOUND)
#define NWERR_FS_INVALID_PARAMETERS			 (NWERR_FS | 0x000020FBL)	
#define NWERR_FS_INVALID_CONNECTION_ID		(NWERR_FS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_FS_INVALID_NCP_PACKET_LENGTH 	(NWERR_FS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_FS_SETTING_UP_TIMEOUT			(NWERR_FS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_FS_TRANSPORT_SEND				(NWERR_FS | \
												NWERR_TRANSPORT_SEND
#define NWERR_FS_IN_SETTING_SIGNALS			(NWERR_FS | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_FS_INVALID_PARAMETER_LENGTH	(NWERR_FS | 0x00001001L)
#define NWERR_FS_CORRUPTION_OF_CURRENT_SCAN	(NWERR_FS | 0x00002001L)




#define NWERR_PATH              0x001b0000L
#define NWERR_PATH_BAD_SRCH_DRIVE_VCTR       (NWERR_PATH | 0x00000001L)
#define NWERR_PATH_INVALID_PATH_LENGTH       (NWERR_PATH | 0x00000002L) 
#define NWERR_PATH_INVALID_DRIVE_NUM         (NWERR_PATH | 0x00000020L)
#define NWERR_PATH_NO_DRIVES_AVAILABLE       (NWERR_PATH | 0x00000025L)
#define NWERR_PATH_WS_DOES_NOT_SUPPORT       (NWERR_PATH | 0x00000030L)
#define NWERR_PATH_INVALID_PARAMETERS		 (NWERR_PATH | 0x000020FBL)
#define NWERR_PATH_INVALID_CONNECTION_ID	(NWERR_PATH | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_PATH_INVALID_PATH				(NWERR_PATH | 0x0000009CL)
#define NWERR_PATH_NO_DIRECTORY_HANDLES		(NWERR_PATH | 0x0000009DL)
#define NWERR_PATH_INVALID_NCP_PACKET_LENGTH (NWERR_PATH | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_PATH_SETTING_UP_TIMEOUT		(NWERR_PATH | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_PATH_TRANSPORT_SEND			(NWERR_PATH | \
													NWERR_TRANSPORT_SEND
#define NWERR_PATH_IN_SETTING_SIGNALS		(NWERR_PATH | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_PATH_INVALID_PARAMETER_LENGTH	(NWERR_PATH | 0x00001001L)



#define NWERR_QUEUE             0x00210000L
#define NWERR_Q                 NWERR_QUEUE
#define NWERR_Q_SERVER_OUT_OF_MEMORY            (NWERR_QUEUE | 0x96)
#define NWERR_Q_DIR_FULL                        (NWERR_QUEUE | 0x99)
#define NWERR_Q_BAD_DIR_HANDLE                  (NWERR_QUEUE | 0x9B)
#define NWERR_Q_INVALID_PATH                    (NWERR_QUEUE | 0x9C)
#define NWERR_Q_ERROR                           (NWERR_QUEUE | 0xD0)
#define NWERR_Q_NO_QUEUE                        (NWERR_QUEUE | 0xD1)
#define NWERR_Q_NO_QUEUE_SERVER                 (NWERR_QUEUE | 0xD2)
#define NWERR_Q_NO_QUEUE_RIGHTS                 (NWERR_QUEUE | 0xD3)
#define NWERR_Q_FULL                            (NWERR_QUEUE | 0xD4)
#define NWERR_Q_NO_JOB                          (NWERR_QUEUE | 0xD5)
#define NWERR_Q_NO_JOB_RIGHTS                   (NWERR_QUEUE | 0xD6)
#define NWERR_Q_PASSWORD_NOT_UNIQUE             (NWERR_QUEUE | 0xD7)
#define NWERR_Q_SERVICING                       (NWERR_QUEUE | 0xD7)
#define NWERR_Q_NOT_ACTIVE                      (NWERR_QUEUE | 0xD8)
#define NWERR_Q_PASSWORD_TOO_SHORT              (NWERR_QUEUE | 0xD8)
#define NWERR_Q_STATION_NOT_SERVER              (NWERR_QUEUE | 0xD9)
#define NWERR_Q_HALTED                          (NWERR_QUEUE | 0xDA)
#define NWERR_Q_MAX_QUEUE_SERVERS               (NWERR_QUEUE | 0xDB)
#define NWERR_Q_NO_SUCH_MEMBER                  (NWERR_QUEUE | 0xEA)
#define NWERR_Q_PROPERTY_ALREADY_EXISTS         (NWERR_QUEUE | 0xED)
#define NWERR_Q_OBJECT_ALREADY_EXISTS           (NWERR_QUEUE | 0xEE)
#define NWERR_Q_INVALID_NAME                    (NWERR_QUEUE | 0xEF)
#define NWERR_Q_WILD_CARD_NOT_ALLOWED           (NWERR_QUEUE | 0xF0)
#define NWERR_Q_INVALID_BINDERY_SECUR           (NWERR_QUEUE | 0xF1)
#define NWERR_Q_NO_OBJECT_DELETE_PRIVILEGE		(NWERR_QUEUE | 0xF4)
#define NWERR_Q_NO_OBJECT_CREATE_PRIV           (NWERR_QUEUE | 0xF5)
#define NWERR_Q_NO_PROPERTY_CREATE_PRIV         (NWERR_QUEUE | 0xF7)
#define NWERR_Q_NO_SUCH_OBJECT                  (NWERR_QUEUE | 0xFC)
#define NWERR_Q_SERVER_BINDERY_LOCKED           (NWERR_QUEUE | 0xFE)
#define NWERR_Q_BINDERY_FAILURE                 (NWERR_QUEUE | 0xFF)
#define NWERR_Q_HARDWARE_FAILURE                (NWERR_QUEUE | 0xFF)
#define NWERR_Q_VOL_DOES_NOT_EXIST				(NWERR_QUEUE | 0x98)
#define NWERR_Q_INVALID_PARAMETERS				(NWERR_QUEUE | \
												0x000020FBL)
#define NWERR_Q_INVALID_CONNECTION_ID	(NWERR_QUEUE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_Q_INVALID_NCP_PACKET_LENGTH (NWERR_QUEUE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_Q_SETTING_UP_TIMEOUT		(NWERR_QUEUE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_Q_TRANSPORT_SEND			(NWERR_QUEUE | \
													NWERR_TRANSPORT_SEND
#define NWERR_Q_IN_SETTING_SIGNALS		(NWERR_QUEUE | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_Q_INVALID_PARAMETER_LENGTH	(NWERR_QUEUE | 0x00001001L)



#define NWERR_SP                0x00230000L  /* server platform */

#define NWERR_SP_VERSION_TOO_LOW    (NWERR_SP | 0x00000001L)
#define NWERR_SP_SFT_LEVEL_TOO_LOW  (NWERR_SP | 0x00000002L)
#define NWERR_SP_TTS_LEVEL_TOO_LOW  (NWERR_SP | 0x00000004L)
#define NWERR_SP_AFP_LEVEL_TOO_LOW  (NWERR_SP | 0x00000008L)
#define NWERR_SP_NO_CONSOLE_RIGHTS  (NWERR_SP | 0x000000C6L)
#define NWERR_SP_OPEN_FILES         (NWERR_SP | 0x000000FFL)
#define NWERR_SP_INVALID_PARAMETERS (NWERR_SP | 0x000020FBL)
#define NWERR_SP_NOT_286_FILE_SYSTEM (NWERR_SP | 0x000010FCL)
#define NWERR_SP_INVALID_CONNECTION_ID	(NWERR_SP | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SP_INVALID_NCP_PACKET_LENGTH (NWERR_SP | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SP_SETTING_UP_TIMEOUT		(NWERR_SP | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SP_TRANSPORT_SEND			(NWERR_SP | \
													NWERR_TRANSPORT_SEND
#define NWERR_SP_IN_SETTING_SIGNALS		(NWERR_SP | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SP_INVALID_PARAMETER_LENGTH	(NWERR_SP | 0x00001001L)




#define NWERR_SYNC                         0x00270000L
#define NWERR_SYNC_SERVER_OUT_OF_MEMORY   (NWERR_SYNC |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_SYNC_INVALID_NAME_LEN       (NWERR_SYNC | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SYNC_TIMEOUT_FAILURE        (NWERR_SYNC | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SYNC_INVALID_PARAMETERS	  (NWERR_SYNC | 0x000020FBL)
#define NWERR_SYNC_INVALID_CONNECTION_ID	(NWERR_SYNC | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SYNC_INVALID_NCP_PACKET_LENGTH (NWERR_SYNC | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SYNC_SETTING_UP_TIMEOUT		(NWERR_SYNC | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SYNC_TRANSPORT_SEND			(NWERR_SYNC | \
													NWERR_TRANSPORT_SEN                                                                                                                                                                                                                                                                           ]B~ $      PWRKV50F1050.F                 s n [NW.KIT.EXE]NWERRORS.H;1                                                                                                       I     B                          "     #       D
#define NWERR_SYNC_IN_SETTING_SIGNALS		(NWERR_SYNC | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SYNC_INVALID_PARAMETER_LENGTH	(NWERR_SYNC | 0x00001001L)



#define NWERR_SEMAPHORE                   (NWERR_SYNC | 0x00000100L)
#define NWERR_SEMAPHORE_OVERFLOW          (NWERR_SEMAPHORE | 0x00000001L)
#define NWERR_SEMAPHORE_INVALID_NAM_LEN   (NWERR_SEMAPHORE | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SEMAPHORE_TIMEOUT_FAILURE   (NWERR_SEMAPHORE | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SEMAPHORE_INVALID_CONNECTION_ID	(NWERR_SEMAPHORE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SEMAPHORE_INVALID_NCP_PACKET_LENGTH (NWERR_SEMAPHORE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SEMAPHORE_SETTING_UP_TIMEOUT		(NWERR_SEMAPHORE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SEMAPHORE_TRANSPORT_SEND			(NWERR_SEMAPHORE | \
													NWERR_TRANSPORT_SEND
#define NWERR_SEMAPHORE_IN_SETTING_SIGNALS		(NWERR_SEMAPHORE | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SEMAPHORE_INVALID_PARAMETER_LENGTH	(NWERR_SEMAPHORE | \
													0x00001001L)



#define NWERR_TTS                         0x00290000L
#define NWERR_TTS_SERVER_OUT_OF_MEMORY    (NWERR_TTS |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_TTS_NO_CONSOLE_RIGHTS       (NWERR_TTS |  \
                                           NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_TTS_IMPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_RECORDS_STILL_LOCKED    (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_NO_EXPL_TRANS_ACTIVE    (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_EXPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_TRANS_NOT_WRITTEN       (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_INVALID_CONNECTION_ID	(NWERR_TTS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_TTS_INVALID_NCP_PACKET_LENGTH (NWERR_TTS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_TTS_SETTING_UP_TIMEOUT		(NWERR_TTS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_TTS_TRANSPORT_SEND			(NWERR_TTS | \
													NWERR_TRANSPORT_SEND
#define NWERR_TTS_IN_SETTING_SIGNALS		(NWERR_TTS | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_TTS_INVALID_PARAMETER_LENGTH	(NWERR_TTS | 0x00001001L)


/*======================================================================
                       Server-Returned Error Codes
========================================================================
*/
#define	NWERR_OUT_OF_DISK_SPACE				0x00000001L
#define	NWERR_BAD_SRCH_DRIVE_VECTOR			0x00000001L
#define	NWERR_VERSION_TOO_LOW				0x00000001L
#define NWERR_SFT_LEVEL_TOO_LOW				0x00000002L
#define NWERR_TTS_LEVEL_TOO_LOW				0x00000004L
#define NWERR_AFP_LEVEL_TOO_LOW				0x00000008L
#define NWERR_INVALID_DRIVE_NUM				0x00000020L
#define NWERR_NO_MORE_RESTRICTIONS			0x00000024L
#define NWERR_NO_DRIVES_AVAILABLE			0x00000025L
#define NWERR_WS_DOES_NOT_SUPPORT			0x00000030L
#define NWERR_LOCK_FAIL						0x00000080L
#define NWERR_FILE_IN_USE					0x00000080L
#define NWERR_NO_MORE_FILE_HANDLES			0x00000081L
#define NWERR_NO_OPEN_PRIVILEGES			0x00000082L
#define NWERR_IO_ERROR_NETWORK_DISK			0x00000083L
#define NWERR_NO_CREATE_PRIVILEGES			0x00000084L
#define NWERR_NO_CREATE_DELETE_PRIVILEGES	0x00000085L
#define NWERR_CREATE_FILE_EXISTS_READ_ONLY	0x00000086L
#define NWERR_CREATE_ERROR					0x00000087L
#define NWERR_WILD_CARDS_IN_CREATE_FILE_NAM	0x00000087L
#define NWERR_CREATE_FILE_NAME				0x00000087L
#define	NWERR_INVALID_FILE_HANDLE			0x00000088L
#define NWERR_NO_SEARCH_PRIVILEGES			0x00000089L
#define NWERR_NO_DELETE_PRIVILEGES         	0x0000008AL
#define NWERR_NO_RENAME_PRIVILEGES			0x0000008BL
#define NWERR_NO_MODIFY_PRIVILEGES         	0x0000008CL
#define NWERR_ENTRY_IN_USE                 	0x0000008DL
#define NWERR_SOME_FILES_AFFECTED_IN_USE	0x0000008DL
#define NWERR_ALL_FILES_IN_USE				0x0000008EL
#define NWERR_NO_FILES_AFFECTED_IN_USE		0x0000008EL
#define NWERR_SOME_FILES_AFFECTED_READ_ONLY	0x0000008FL
#define NWERR_ALL_READ_ONLY					0x00000090L
#define NWERR_NO_FILES_AFFECTED_READ_ONLY	0x00000090L
#define NWERR_SOME_FILES_RENAMED_NAME_EXIST 0x00000091L
#define NWERR_NO_FILES_RENAMED_NAME_EXISTS  0x00000092L
#define NWERR_NO_READ_PRIVILEGES			0x00000093L
#define NWERR_NO_WRITE_PRIVILEGES			0x00000094L
#define NWERR_FILE_DETACHED					0x00000095L 
#define NWERR_SERVER_OUT_OF_MEMORY         	0x00000096L 
#define NWERR_NO_DISK_SPACE_FOR_SPOOL_FILE	0x00000097L
#define NWERR_VOL_DOES_NOT_EXIST           	0x00000098L 
#define NWERR_BAD_VOL_NUM   	        	0x00000098L 
#define NWERR_DIR_FULL                     	0x00000099L 
#define NWERR_INVALID_NAME                 	0x00000099L 
#define NWERR_RENAMING_ACROSS_VOLUMES		0x0000009AL
#define NWERR_BAD_DIR_HANDLE               	0x0000009BL
#define NWERR_INVALID_PATH                 	0x0000009CL
#define NWERR_NO_MORE_TRUSTEES				0x0000009CL
#define NWERR_NO_MORE_DIRECTORY_HANDLES		0x0000009DL
#define NWERR_BAD_FILE_NAME					0x0000009EL
#define NWERR_INVALID_FILE_NAME				0x0000009EL
#define NWERR_DIRECTORY_ACTIVE				0x0000009FL
#define NWERR_DIRECTORY_NOT_EMPTY			0x000000A0L
#define NWERR_DIRECTORY_IO_ERROR			0x000000A1L
#define NWERR_READ_FILE_WITH_RECORD_LOCKED	0x000000A2L
#define NWERR_NO_ACCOUNT_PRIVILEGES		   	0x000000C0L
#define NWERR_NO_ACCOUNT_BALANCE			0x000000C1L
#define NWERR_CREDIT_LIMIT_EXCEEDED			0x000000C2L
#define NWERR_LOGIN_DENIED_NO_CREDIT_LIMIT	0x000000C2L
#define NWERR_TOO_MANY_HOLDS				0x000000C3L
#define NWERR_USER_ACCOUNT_DISABLED			0x000000C4L
#define NWERR_INTRUDER_DETECTION_LOCK		0x000000C5L
#define NWERR_LOGIN_LOCKOUT					0x000000C5L
#define NWERR_NO_CONSOLE_OPERATOR_RIGHTS  	0x000000C6L
#define NWERR_QUEUE_ERROR					0x000000D0L
#define NWERR_NO_QUEUE                      0x000000D1L
#define NWERR_NO_QUEUE_SERVER               0x000000D2L
#define NWERR_NO_QUEUE_RIGHTS               0x000000D3L
#define NWERR_QUEUE_FULL                    0x000000D4L
#define NWERR_NO_JOB    		            0x000000D5L
#define NWERR_NO_JOB_RIGHTS    			    0x000000D6L
#define NWERR_UNENCRYPTED_PASSWORD			0x000000D6L
#define NWERR_ACCOUNT_BAD					0x000000D7L
#define NWERR_PASSWORD_NOT_UNIQUE			0x000000D7L
#define NWERR_QUEUE_SERVICING				0x000000D7L
#define NWERR_PASSWORD_TOO_SHORT			0x000000D8L
#define NWERR_QUEUE_NOT_ACTIVE				0x000000D8L
#define NWERR_MAXIMUM_LOGINS_EXCEEDED		0x000000D9L
#define NWERR_LOGIN_DENIED_NO_CONNECTION	0x000000D9L
#define NWERR_QUEUE_PASSWORD_TOO_SHORT		0x000000D9L
#define NWERR_BAD_LOGIN_TIME				0x000000DAL
#define NWERR_UNAUTHORIZED_LOGIN_TIME		0x000000DAL
#define NWERR_QUEUE_HALTED					0x000000DAL
#define NWERR_LOG_STATION_ERROR				0x000000DBL
#define NWERR_UNAUTHORIZED_LOGIN_STATION	0x000000DBL
#define NWERR_MAX_QUEUE_SERVERS				0x000000DBL
#define NWERR_ACCOUNT_DISABLED				0x000000DCL
#define NWERR_BAD_PASSWORD					0x000000DEL
#define NWERR_PASSWORD_HAS_EXPIRED_NO_GRACE	0x000000DEL
#define NWERR_OLD_PASSWORD					0x000000DFL
#define NWERR_NO_DISK_TRACK					0x000000E7L
#define NWERR_WRITE_PROPERTY_TO_GROUP		0x000000E8L
#define NWERR_NOT_ITEM_PROPERTY				0x000000E8L
#define NWERR_MEMBER_ALREADY_EXISTS			0x000000E9L
#define NWERR_NO_SUCH_MEMBER				0x000000EAL
#define NWERR_NOT_SET_PROPERTY				0x000000EBL
#define	NWERR_NO_SUCH_SET					0x000000ECL
#define	NWERR_NO_SUCH_SEGMENT				0x000000ECL
#define NWERR_PROPERTY_ALREADY_EXISTS		0x000000EDL
#define	NWERR_OBJECT_ALREADY_EXISTS			0x000000EEL
#define NWERR_ILLEGAL_NAME					0x000000EFL
#define NWERR_ILLEGAL_WILDCARD				0x000000F0L
#define NWERR_WILDCARD_NOT_ALLOWED			0x000000F0L
#define NWERR_MALFORMED_NCP_PACKET			0x000000F0L
#define NWERR_INVALID_BINDERY_SECURITY		0x000000F1L
#define NWERR_NO_OBJECT_READ_PRIVILEGE     	0x000000F2L
#define NWERR_NO_OBJECT_RENAME_PRIVILEGE	0x000000F3L
#define NWERR_NO_OBJECT_DELETE_PRIVILEGE	0x000000F4L
#define NWERR_NO_OBJECT_CREATE_PRIVILEGE	0x000000F5L
#define NWERR_NO_PROPERTY_DELETE_PRIVILEGE	0x000000F6L
#define NWERR_NOT_SAME_LOCAL_DRIVE			0x000000F6L
#define NWERR_NO_PROPERTY_CREATE_PRIVILEGE	0x000000F7L 
#define NWERR_TARGET_DRIVE_NOT_LOCAL		0x000000F7L
#define NWERR_NO_PROPERTY_WRITE_PRIVILEGE	0x000000F8L
#define NWERR_ALREADY_ATTACHED_TO_SERVER	0x000000F8L
#define NWERR_NOT_ATTACHED_TO_SERVER		0x000000F8L
#define NWERR_NO_PROPERTY_READ_PRIVILEGE	0x000000F9L
#define NWERR_NO_MORE_PROP_VALS				0x000000F9L
#define NWERR_NO_MORE_SERVER_SLOTS			0x000000FAL
#define NWERR_TEMP_REMAP_ERROR				0x000000FAL
#define NWERR_INVALID_PARAMETERS           	0x000000FBL 
#define NWERR_NOT_386_FILE_SYSTEM          	0x000000FBL 
#define NWERR_NO_MORE_PROPERTIES          	0x000000                                                                                                                                                                                                                                                                           + $      PWRKV50F1050.F                 s n [NW.KIT.EXE]NWERRORS.H;1                                                                                                       I     B                         "Z      4       FBL 
#define NWERR_NO_SUCH_PROPERTY          	0x000000FBL 
#define NWERR_INTERNET_PACKET_REQT_CANCELED	0x000000FBL 
#define NWERR_SEMAPHORE_INVALID_PARAMETERS 	0x000000FBL 
#define NWERR_SYNC_INVALIDE_PARAMETERS     	0x000000FBL 
#define NWERR_NO_SUCH_OBJECT	          	0x000000FCL
#define NWERR_NO_MORE_OBJECTS	          	0x000000FCL
#define NWERR_UNKNOWN_FILE_SERVER			0x000000FCL
#define NWERR_MESSAGE_QUEUE_FULL			0x000000FCL
#define NWERR_BAD_STATION_NUMBER			0x000000FDL
#define NWERR_INVALID_PACKET_LENGTH			0x000000FDL
#define NWERR_TTS_DISABLED					0x000000FDL
#define NWERR_UNKNOWN_REQUEST				0x000000FDL
#define NWERR_TIMEOUT_FAILURE              	0x000000FEL
#define NWERR_INVALID_NAME_LEN             	0x000000FEL
#define NWERR_BINDERY_LOCKED				0x000000FEL
#define NWERR_DIRECTORY_LOCKED				0x000000FEL
#define NWERR_INVALID_SEMAPHORE_NAME_LENGTH 0x000000FEL
#define NWERR_IMPLICIT_TRANS_ACTIVE			0x000000FEL
#define NWERR_NO_SUCH_RESTRICTION			0x000000FEL
#define NWERR_PACKET_NOT_DELIVERABLE		0x000000FEL
#define NWERR_RECORDS_STILL_LOCKED			0x000000FEL
#define NWERR_SERVER_BINDERY_LOCKED			0x000000FEL
#define NWERR_SOCKET_TABLE_FULL				0x000000FEL
#define NWERR_SPOOL_DIRECTORY_ERROR			0x000000FEL
#define NWERR_SUPERVISOR_HAS_DISABLED_LOGIN 0x000000FEL
#define NWERR_ENTRY_NOT_FOUND              	0x000000FFL
#define NWERR_NO_FILES_FOUND               	0x000000FFL
#define NWERR_BAD_PRINTER_ERROR				0x000000FFL
#define NWERR_BAD_RECORD_OFFSET				0x000000FFL
#define NWERR_CLOSE_FCB_ERROR				0x000000FFL
#define NWERR_ENTRY_EXISTS					0x000000FFL
#define NWERR_ENTRY_NOT_FOUND				0x000000FFL
#define NWERR_EXPLICIT_TRANS_ACTIVE			0x000000FFL
#define NWERR_FILE_ALREADY_EXISTS			0x000000FFL
#define NWERR_FILE_EXTENSION_ERROR			0x000000FFL
#define NWERR_FILE_NAME_ERROR				0x000000FFL
#define NWERR_HARDWARE_FAILURE				0x000000FFL
#define NWERR_INVALID_DRIVE_NUMBER			0x000000FFL
#define NWERR_INVALID_INITIAL_SEMAPHORE_VAL 0x000000FFL
#define NWERR_INVALID_SEMAPHORE_HANDLE		0x000000FFL
#define NWERR_IO_BOUND_ERROR				0x000000FFL
#define NWERR_NO_EXPLICIT_TRANS_ACTIVE		0x000000FFL
#define NWERR_NO_FILES_FOUND_ERROR			0x000000FFL
#define NWERR_NO_MORE_FILES_FOUND			0x000000FFL	
#define NWERR_NO_RESPONSE_FROM_SERVER		0x000000FFL
#define NWERR_NO_SUCH_OBJECT_OR_BAD_PASSWORD 0x000000FFL
#define NWERR_OPEN_FILES					0x000000FFL
#define NWERR_PATH_NOT_LOCATABLE			0x000000FFL
#define NWERR_QUEUE_FULL_ERROR				0x000000FFL
#define NWERR_REQUEST_NOT_OUTSTANDING		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_VALUE		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_HANDLE		0x000000FFL
#define NWERR_SOCKET_ALREADY_OPEN			0x000000FFL
#define NWERR_SYNC_LOCK_FAILURE				0x000000FFL
#define NWERR_SYNC_ENTRY_NOT_FOUND			0x000000FFL
#define NWERR_SYNC_RECORD_NOT_FOUND			0x000000FFL
#define NWERR_TRANS_NOT_WRITTEN				0x000000FFL
#define NWERR_TTS_NOT_AVAILABLE				0x000000FFL

/*======================================================================
                   Client Generated - Returned Error Codes
========================================================================
*/
#define NWERR_INVALID_CONNECTION_ID						0x00000030L
#define NWERR_INVALID_NCP_PACKET_LENGTH 				0x00000031L
#define NWERR_SETTING_UP_TIMEOUT					 	0x00000032L
#define NWERR_TRANSPORT_SEND						 	0x00000033L
#define NWERR_IN_SETTING_SIGNALS					 	0x00000034L
#define NWERR_NO_RESPONSE_FROM_SERVER					0x000000FFL

#endif
                                                                                                                                                                                        * [NW.KIT.EXE]PWRK$NETWARE.SAV;1 +  , q  .     /     4   $           $               - n  0   1    2   3      K   P   W   O     5   6  Ӄ`D  7 -۩mD  8          9          G    H  J                                              U $      PWRK$NETWARE.SAV                                                                                                                                                                                             7                PWRK$NETWARE.SAVs  BACKUP/NOASSIST/INTER/LOG/VERIFY NW$BLD_SEARCH:[PWRK$NWROOT...]*.*; [.EXE]PWRK$NETWARE.SAV/SAVE/BLOCK=9000/GROUP=25  PWBUILD           `饃`D      V6.1 	 _POCUS:: 
    _$1$DUA2000:  V6.1 
  $       }
               * [PWRK$NWROOT]NETWARE.DIR;1 +  , q  .     /     4                          - q   0   1    2   3     K  P   W   O     5   6 p{`D  7 ߷`D  8          9          G    H  J  I                 CONF_FILES.DIR q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 % * [PWRK$NWROOT.NETWARE]CONF_FILES.DIR;1 +  , q  .     /     4                          - q   0   1    2   3     K  P   W   O     5   6 @{`D  7 Ȃ`D  8          9          G    H   J  I                       PWVN$CONFIG_ENG.HELP ]   PWVN$MSGS_ENG.DAT  q    PWVN$NWCONFIG0.CFG q    PWVN$NWCONFIG3.CFG q    PWVN$NWCONFIG5.CFG x   PWVN$NWCONFIG7.CFG 
]   PWVN$NWCONFIG9.CFG q    PWVN$NWPRINT.CFG ] "  PWVN$SCONSOLE_ENG.HELP q                                                                                                                                                                                                                                         6 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1 +  , ]  . 2    /     4 P   2   ,                     - q  0   1    2   3      K  P   W   O 3    5   6  H?_D  7  ׂ`D  8          9          G    H   J                          # L # Copyright 1989, 1991 Unpublished Work of Novell, Inc. All Rights Reserved. # > # THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, A # PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS ? # TO THIS WORK IS RESTRICTED TO (I) NOVELL EMPLOYEES WHO HAVE A 9 # NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR : # ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL WHO HAVE' # ENTERED INTO APPROPRIATE AGREEMENTS.  9 # NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED, ? # COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED, ; # CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, : # TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT: # OF NOVELL.  ANY USE OR EXPLOITATION OF THIS WORK WITHOUT= # AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND  # CIVIL LIABILITY. # ; #    @(#)cmd/sconsole/help/config_help 1.7 (Novell) 7/29/91  #    # 	 # Format:  #  #	<offset-number>  #	<number-fields>  #	1 <field-1-text-1> #	1 <field-1-text-2> #	1 <field-1-text-3> #		. #		. #		. #	n <field-n-text-1> #	n <field-n-text-2> #	n <field-n-text-3> #		. #		. #		. # D # See "sconsole.h" for offset numbers and consult the menu structure$ # definitions for the field numbers. # D # The first line determines the left justification of all additional4 # lines, so try to make it the longest of the 3. JAA #    # EDIT_GEN_OFF  (110)  110  19 1 C 1 Spawn ahead processes indicates the number of NetWare "NW_ENGINE" / 1 to be started when the NetWare server starts.    2 F 2 Maximum number of processes indicates the maximum number of NetWare 6 2 "NW_ENGINE" process that can be running at one time.   3 E 3 Clients per process indicates the maximum number of NetWare clients 7 3 that can be attached to a single "NW_ENGINE" process.    4 H 4 Max Connections indicates the maximum number of users that can connect 4 to the NetWare server.   5 E 5 Max Volumes indicates the maximum number of volumes allowed on the  	 5 system.    6 ) 6 Server Name is the name of your server.  6    7 @ 7 Network number is the number assigned to your NetWare network. 7    8 B 8 Directory Cache Flag indicates if NetWare sh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          #K $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                          "     
       ould put directories 8 in memory on the system.   9 F 9 File Cache Flag indicates if NetWare should put file entries in the  9 memory on the system.   C 10 Save Deleted Files indicates if files deleted by NetWare will be F 10 removed from the system or only marked for deletion by a subsequent 10 purge command.    11G 11 Saved File Location indicates the location where deleted files would  11 be saved.   12E 12 TTS Flag indicates if Transaction Tracking is turned on. (TTS will & 12 be implemented in future releases.)   13H 13 TTS Backout File location indicates the location where backout files = 13 associated with a terminated transaction would be located.    14E 14 Console Flag indicates if system error messages will be written to  14 the system console.   15> 15 Track on Flag indicates if tracking is currently on or off. 15   16@ 16 Login Flag indicates if logins are enabled when the server is 16 started.    17B 17 Capture Flag indicates if data capture is to be configured into& 17 the system when NetWare is started.   18 18 18   19? 19 Cache Block Size indicates the block size to be used for the  19 cache in shared memory.     # EDIT_VOL_OFF (120) 120  8  1 ' 1 Enter the name of the NetWare Volume. ! 1 Can be from 2 to 15 characters.    = 2 Enter the OpenVMS Directory path for the NetWare Volume. If : 2 the optional Hybrid Volume does not already exist, enter1 2 'Hybrid Volume' here if you wish to create one.     L 3 CHECK = Always check OpenVMS and PATHWORKS for OpenVMS (NetWare) security.@ 3 NOCHECK = Only check PATHWORKS for OpenVMS (NetWare) security.J 3 CONDITIONAL = Check OpenVMS security if file was not created by NetWare.  = 4 Specifies the OpenVMS file protection mask applied to newly ; 4 created files.  Enter 'RMS Default' to propagate the Host > 4 file protection as applied to the current OpenVMS directory.   B 5 Specifies the OpenVMS directory protection mask applied to newlyA 5 created directories.  Enter 'RMS Default' to propagate the Host C 5 directory protection as applied to the current OpenVMS directory.    6 @ 6 Record type can be STREAM, FIXED, or FIXED:n.  If no value is + 6 specified the default FIXED length is 80.   G 7 Deferred File Close option is either ACTIVE or INACTIVE.  The value,  : 7 in seconds, is set in the File Services Configuration -   7 File Services Parameters menu.  F # remove these comments and change the following block to start with 9J # rather then 8 when SHARE_LM comes back ... Also, change the number under* # EDIT_VOL_OFF above to be 9 rather than 8F #8 Applies to volume sharing with other PATHWORKS for OpenVMS servers.J #8 ACTIVE = Volume is shared between PATHWORKS LanMan and NetWare servers.A #8 INACTIVE = Volume is not shared with PATHWORKS LanMan servers.   D 8 Applies to clustered PATHWORKS for OpenVMS (NetWare) servers only.> 8 ACTIVE = Volume is available to all servers in this cluster.< 8 INACTIVE = Volume is available to only the current server.   # EDIT_SYS_OFF (130) 130  17E 1 Shared Memory Size indicates the amount of shared memory to be used D 1 by NetWare.  The recommended value in the documentation should not
 1 be changed.    2 M 2 Server Name is the name of the PATHWORKS for OpenVMS (NetWare) File Server.  2    3 ; 3 Console Flag indicates whether to send error messages to   3 the OpenVMS system console.    4 = 4 Console Device indicates the OpenVMS system console device. % 4 /dev/console is equivalent to OPA0:    5 A 5 Priority is the OpenVMS priority assigned to NetWare processes.  5   I 6 Specifies AST queue limit for the OpenVMS NetWare File Server process,  G 6 The AST queue limit is the maximum number of asynchronous system trap < 6 (AST) operations that can be outstanding at any one time.   G 7 Specifies a buffered I/O count limit.  The buffered I/O count is the  G 7 maximum number of buffered I/O operations that can be outstanding at   7 any one time.    G 8 Specifies the lock queue limit.  The lock queue limit is the maximum  H 8 number of locks that can be queued by the OpenVMS NetWare File Server  8 process at one time.     9 E 9 The open file limit is the maximum number of files that can be open : 9 by the OpenVMS NetWare File Server process at one time.    10L 10 JTquota refers to the size (in bytes) of the OpenVMS NetWare File Server = 10 process Job Table, for process or job level logicals, etc.   A 11 Specifies the paging file limit.  The paging file limit is                                                                                                                                                                            
- $      PWRK$NETWARE.SAV               ] q 6[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1                                                                         P     2                         ` "            the G 11 maximum number of pages that the OpenVMS NetWare File Server process % 11 can use in the system paging file.   E 12 Specifies the subprocess creation limit.  The subprocess creation  E 12 limit is the maximum number of subprocesses that can exist at one  4 12 time for the OpenVMS NetWare File Server process.  E 13 Specifies the total number of entries in the timer queue, plus the G 13 number of temporary common event flags that the OpenVMS NetWare File ' 13 Server process can have at one time.   D 14 Specifies the default working set size.  The default working set D 14 size represents the default number of physical pages the process  14 can use.   H 15 Specifies the working set extent.  The working set extent represents L 15 the absolute limit of physical memory allowed to the OpenVMS NetWare File 15 Server process.  G 16 Specifies the working set quota.  The working set quota is the limit H 16 for the amount of physical memory for the OpenVMS NetWare File Server 16 process.   D 17 Cluster Flag indicates whether the product was installed with theD 17 cluster support option.  This flag is set during installation and 17 is not modifiable.    # SRV_INFO_OFF (140) 140  10 1 . 1 Server name is the name of your file server. 1    2 C 2 Version name displays the NetWare version running on your server.  2    3 8 3 Revision date displays when this version was released. 3    4 C 4 Maximum connections supported displays the number of clients that - 4 can be logged into your server at one time.    5 B 5 Connections in use displays the number of users currently logged 5 into your server.    6 B 6 Peak connections used displays the largest number of users that ; 6 have been logged into the server since it was brought up.    7 B 7 Maximum volumes supported displays the maximum number of NetWare( 7 volumes that your file server can use.   8 ; 8 Revision level displays the level of patches to your file 	 8 server.    9 = 9 SFT level displays what level of System Fault Tolerance is   9 running on your file server.   10< 10 TTS level displays what level of the Transaction Tracking) 10 System is running on your file server.    # SRV_STATS_OFF (150)  150  18 1 = 1 NWProcs displays the number of NetWare processes currently   1 running on your file server.   2 @ 2 Total Packets is the total number of packets received by your & 2 file server since it was brought up.   3 C 3 Create connection requests displays the number of users that have A 3 logged into or attached to your server since it was brought up.    4 B 4 Create file request displays the number of requests to create a ; 4 file serviced by the file server since it was brought up.    5 B 5 File open requests displays the number of requests to open files' 5 since the file server was brought up.    6 B 6 File read requests displays the number of requests to read files' 6 since the file server was brought up.    7 D 7 File write requests displays the number of requests to write files' 7 since the file server was brought up.    8 C 8 Number of open files displays the number of files currently open.  8    9 C 9 Maximum simultaneous open files shows the maximum number of files : 9 opened at one time since the file server was brought up.   10B 10 Lost packet resends refers to the number packets that had to be 10 "resent" to the server.   11B 11 Cache hits refers to the number of successful attempts to read 1 11 files or directories residing in cache memory.    12D 12 Cache hits refers to the number of unsuccessful attempts to read 1 12 files or directories residing in cache memory.h   13A 13 Print requests refers to the number of print jobs submitted toL 13 the file server.N   14D 14 Message request refers to the number of messages sent to the file
 14 server.   15D 15 Directo                                                                                                                                                                                                                                                   	                        | $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         l6 "            ry requests refers to the number of requests for directory, 15 information serviced by the file servers.   16E 16 Bindery and miscellaneous requests refers to the number of binderyA( 16 requests serviced by the file server.   17A 17 Semaphore requests refers to the number of semaphore requests D 17 serviced by the file server.    18D 18 Unknown requests refers to the number of unknown requests made to 18 the server.   # TTS_STATS_OFF (160)N 160  7F 1V@ 1 TTS request refers to the total number of Transaction Tracking 1 requests made to the server.   2IC 2 Transactions performed refers to the total number of transactions_1 2 performed since the file server was brought up.    3o= 3 Transaction writes performed refers to the total number of fD 3 transaction writes completed since the file server was brought up.   4>< 4 Transaction backouts refers to the number of transactions 8 4 "backed out" or rolled back to their beginning state.    5uA 5 Unfilled Backout Requests refers to backout requests that couldi 5 not be completed.t   6iG 6 Number of transactions refers to the number of transactions currently  6 running on the file server.1   7 C 7 Maximum simultaneous transactions refers to the maximum number of C 7 transactions running at one time since the server was brought up.    # LOCK_MGR_OFF (170) 170  12 1eE 1 Logical lock requests displays the number of logical lock requests n 1 made to the server.    2e> 2 Number of logical locks displays the number of logical locks 2 currently in place.d   3 D 3 Maximum simultaneous logical locks refers to the maximum number ofF 3 logical locks occurring at one time since the server was brought up.   4 C 4 File lock requests displays the number of file lock requests madey 4 to the server.   5N8 5 Number of file locks displays the number of file locks 5 currently in place.e   6yA 6 Maximum simultaneous file locks refers to the maximum number of C 6 file locks occurring at one time since the server was brought up.i   7cF 7 Physical lock requests displays the number of physical lock requests 7 made to the server.v   8e@ 8 Number of physical locks displays the number of physical locks 8 currently in place.n   9rE 9 Maximum simultaneous physical locks refers to the maximum number oflG 9 physical locks occurring at one time since the server was brought up..   10? 10 Semaphore requests displays the number of semaphore requestsS 10 made to the server.   118 11 Number of semaphore displays the number of semaphore  11 currently in place.   12A 12 Maximum simultaneous semaphore refers to the maximum number oftC 12 semaphore occurring at one time since the server was brought up.e     # VOL_STATS_OFF (180)  180l 1 A 1 This screen displays the number of active NetWare volumes, the .E 1 amount in K-bytes of disk space that are used by that volume, stilleC 1 free on that volume, and the number of directories used and free.s   # CONN_STATS_OFF (190) 190s 1e 1h? 1 This screen displays the number of users currently connected n 1 to the server.   # DATACAPTURE_OFF (200)9 200e 10 1rA 1 File name is the name of the file in which to store the capturee 1 data.e   2 < 2 Maximum file size is the maximum size of the capture file. 2n   3iD 3 Maximum packet size is the maximum number of bytes to be retrieved 3 for each packet.   4e@ 4 Read only captures only those packets coming into this server. 4    5a= 5 Write only captures only those packets leaving this server.  5O   6 D 6 Address filter captures only those packets which are received from, 6 or are destined for the address specified.   7 D 7 Network filter captures only those packets which are received from, 7 or are destined for the network specified.   8aC 8 Socket filter captures only those packets which are received fromi+ 8 or are destined for the socket specified.r   9tF 9 Packet filter captures only those packets which are of the specified 9 packet type.   10E 10 The logical OR flag allows the filters to be ORed together instead  10 of the default logical AND.   # EDIT_NVT_OFF (210) 210o 6l 1i= 1 NVT Flag indicates if remote login is to be configured intoF% 1 the system when NetWare is started.A   2.9 2 Server Name that this machine will be known as for NVT.o 2g   3o6 3 NVT Getty Entry is the baud rate for the NVT gettys. 3m   4 ? 4 NVT Init Level is the machine run level for NVT to be active.h 4S   5L2 5 NVT Spawns is the number of NVT gettys to spawn. 5V   6FF 6 NVT Line Discipline is the line discipline to use from the gettydefs 6 file.o   # MISC_OFF (220) 220T 3  1o2 1 Enter the file name of the data capture to view. 1v   2 . 2 Enter the name of the file in which you wish( 2 to save the current server statistics.   3TA 3 The sample interval is the delay for refreshes on the statistica
 3 screens.   # EDIT_TRAN_OFF (230). 230N                                                                                                                                                                                                                                                                             $      PWRK$NETWARE.SAV               ] q 6[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1                                                                         P     2                                      16D 1 Internal Network Number is a unique eight digit hexadecimal numberC 1 between 0x00000001 and 0xFFFFFFFE (inclusive). This number should 8 1 not be duplicated on any network on your internetwork.  A 2 Service Advertising Protocol daemon should be started when the sC 2 protocol stack is brought up.  This should be ACTIVE. This daemon @ 2 assists in advertising and collecting services on the network.  C 3 This dictates how long this server will wait before answering to eB 3 a Get Nearest Server Request (GNS).  If this is your only serverE 3 set to 0 otherwise set to a value greater than 0 and less than 300.s  = 4 This device/file will receive all standard output from the e= 4 sap daemon.  Standard output includes track messages.  This 0 4 should be set to the console device or a file.  = 5 This device or file will receive all error output from the d= 5 sap daemon.  If the SAP daemon encounters any errors duringu6 5 operation it will write them to this device or file.  = 6 SPX - Sequenced Packet eXchange driver flag.  If active thee8 6 Novell Protocol Suite Daemon will link the driver into" 6 the protocol stack upon startup.  7 7 This flag will cause the Novell Protocol Suite daemonf: 7 to link the NETBIOS driver into the protocol stack upon 
 7 startup.  A 8 This is the name a module that converts NETBIOS request packetsrA 8 into requests to the underlying transport service.  This shouldo( 8 be set to nbix for operation over IPX.  ? 9 The Network Number is a unique eight digit hexadecimal numberiC 9 between 0x00000001 and 0xFFFFFFFE (inclusive). This number should 8 9 not be duplicated on any network on your internetwork.   10+ 10 Good Luck!!  Nothing is acceptable here.T 10   111 11 How did you ever get passed the Adapter field?u 11 Enter the net_type here.o   12  12 Enter the PPA.  Join the PTA. 12   13 13 Enter the If_name here. 13   14 14 Enter the Net_Frame here. 14   15 15 Enter the net module here.m 15   16$ 16 Enter the Network Number you wish  16 removed from the file server.   # EDIT_AT_OFF (250)t 250f 5tA 1 If set to active, then the protocol stack daemon will cause theeA 1 AppleTalk protocol modules to be activated on startup.  This isS, 1 required in order to provide AFP services.   2xB 2 The host file system path name of the network link device driver 2 interface, such as /dev/en0.   3 = 3 The type of the network link device, such as ETHERNET_DLPI.t 3o   4 < 4 For DLPI device drivers, the physical point of attachment.$ 4 This is usually the unit selector.   5CC 5 The name of an option module to be pushed between the link devicec8 5 driver and the bottom of the AppleTalk protocol stack.   # EDIT_AFP_OFF (260) 260  4  1R= 1 If set to active, then AFP services will be provided by theu2 1 NetWare service engines when NetWare is started.  C 2 The name of the AFP server.  It may be different that the name ofi@ 2 the NetWare server, and only needs to conform to AFP/Macintosh 2 name restrictions.   3eG 3 Indicates if NetWare encryption is required for NetWare for Macintosh  3 utilities.   4 E 4 Indicates if the "false descendants" performance improvement shouldr 4 be employed.   # EDIT_FILE_OFF (280)s 280l 9e 1n? 1 Specify the Account Name, in the User Authorization File, for F 1 OpenVMS security validatio                                                                                                                                                                                                                                                   
                        a( $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                          "     ,       n of non-hybrid NetWare user transactions.  E 2 Specify the value for the deferred file close option.  The deferrediD 2 close flag (ACTIVE/INACTIVE) is volume specific and is selected in7 2 the File Services Configuration Menu - Edit a Volume.a   3s8 3 Specify the default NetWare/OpenVMS security algorithm. 3 to be enforced: CHECK, NOCHECK, CONDITIONAL.  ? 4 Specify the default RMS file type applied to files created in A 4 NetWare volumes.  Record type can be STREAM, FIXED, or FIXED:n.r; 4 If no value is specified, the default FIXED length is 80.t   5t> 5 Specify the maximum number of open files allowed per client.* 5 Can range from 20 to 200, default is 50.   6e5 6 Specify the maximum number of connections (clients)d1 6 for the PATHWORKS for OpenVMS (NetWare) server.h   7 5 7 Specify the maximum number of NetWare volumes to beq: 7 supported by the PATHWORKS for OpenVMS (NetWare) server.  N 8 Applies to CONDITIONAL security check only.  If ACTIVE, OpenVMS security is P 8 not checked if file was created by a PATHWORKS for OpenVMS (NetWare) server.  P 8 If INACTIVE, VMS security is not checked if created by any PATHWORKS server.    J 9 If INACTIVE, only file names complying with DOS standards are accessibleM 9 through NetWare.  If ACTIVE, all OpenVMS file names are accessible, but ares5 9 transparently mapped to unique DOS compliant names.    # EDIT_SECURITY_OFF (290)e 290w 6h; 1 Set the Forced Logout Logging to ACTIVE if you want a logl> 1 entry made in the error log file whenever a client is logged 1 out by watchdog.  @ 2 Set the Forced Logout Display to ACTIVE if you want a message B 2 displayed on the console device whenever a client is logged out  2 by watchdog.   3hD 3 Set the Password Encryption Flag to ACTIVE to require all clients  3 to use encrypted passwords.i  C 4 Enter the login name of an additional NetWare user which you wish E 4 to receive alert messages from the file server.  SUPERVISOR and allM. 4 OPERATORS receive alert messages by default.  @ 5 Enter the name of the NetWare user which you wish removed from? 5 the alert message list.  SUPERVISOR and all OPERATORS receivet 5 alert messages by default.  J 6 Determines login status at startup.  If INACTIVE, login is denied to allJ 6 NetWare users except SUPERVISOR.  After the server is up, SUPERVISOR canJ 6 change the server login status with the FCONSOLE NetWare client utility.   # EDIT_HYBRID_OFF (300)u 300o 2n 1w2 1 Enter the NetWare login name of the hybrid user. 11   2 2 2 Enter the OpenVMS login name of the hybrid user. 2o   # EDIT_PS_OFF (310)  310u 8s 1d5 1 Enter the name of a NetWare print server previously 3 1 created with the PCONSOLE NetWare client utility.c   2 / 2 Enter the name of a NetWare file server which , 2 you wish the Host print server to service.   3 7 3 Enter the password assigned to the Host print server.o 3t   4 = 4 Enter the name of the NetWare queue residing on the NetWaren> 4 file server which you wish the Host print server to service.   5 < 5 Enter the name of a Host print server which was previously6 5 configured in the Host Print Server Assignment Menu.   6r4 6 Enter the name of the OpenVMS queue where the Host, 6 print server will send NetWare print jobs.  5 7 Enter the name of a NetWare form previously definedn4 7 with the PRINTDEF NetWare client utility which you- 7 wish to assign to an existing OpenVMS form.    8i? 8 Enter the name of an existing OpenVMS form which will be used ( 8 in place of the assigned NetWare form.   0a 0o                                                                                                                                                                                                                                                                                                                                                           3 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG.DAT;1 +  , q  .     /     4        D                   - q   0   1    2   3      K  P   W   O     5   6 @^D  7 `D  8          9          G    H   J                            
 0:ACTIVE 1:Dynamic Message String. N 2:PNWError(0x%X, %s):  PATHWORKS for OpenVMS (NetWare) must be run as root. G 3:PNWInform:  PATHWORKS for OpenVMS (NetWare) initialization started. + 4:PNWInform:  Initializing bindery files. H 5:PNWError(0x%X, %s):  A server is currently elsewhere in the cluster.7 6:PWVN$Error:  Function %s returned status of (0x%X). ( 7:PNWInform:  Invalid server name %s. C 8:PNWInform:  Shared memory size (%d) too small; converted to %d. > 9:PNWInform:  Maximum procs (%d) too small; converted to %d.E 10:PNWInform:  Maximum connections (%d) too small; converted to %d.rE 11:PNWInform:  Maximum connections (%d) too large; converted to %d.aA 12:PNWInform:  Maximum volumes (%d) too small; converted to %d.NA 13:PNWInform:  Maximum volumes (%d) too large; converted to %d. C 14:PNWInform:  Spawn ahead procs (%d) too small; converted to %d.rE 15:PNWInform:  Clients per process (%d) too small; converted to %d.o> 16:PNWInform:  Client stack (%d) too small; conv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          b $      PWRK$NETWARE.SAV               q q 3[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG.DAT;1                                                                                                         
              erted to %d.9 17:PNWInform:  Priority (%d) too high; converted to %d.t8 18:PNWInform:  Priority (%d) too low; converted to %d.B 19:PNWInform:  Cache block size (%d) too small; converted to %d.B 20:PNWInform:  Cache block size (%d) too large; converted to %d.3 21:PNWInform:  Server name changed from %s to %s. < 22:PNWInform:  Volume %s assignment changed from %s to %s.6 23:PNWInform:  Network number changed from %X to %X.@ 24:PNWInform:  Log file size (%d) too small; converted to %d. I 25:PNWInform:  Print server loop delay (%d) too small; converted to %d. G 26:PNWInform:  Print server loop delay (%d) too big; converted to %d.n< 27:PNWInform:  Ulimit (0x%d) too small; converted to 0x%d.H 28:PNWInform:  Native locks requires 1 client per process; converted. I 29:PNWInform:  Nearest server response (%d) too small; converted to %d.gG 30:PNWInform:  Nearest server response (%d) too big; converted to %d.mC 31:PNWInform:  Salvage num files (%d) too small; converted to %d.tA 32:PNWInform:  Salvage num files (%d) too big; converted to %d.nT 33:PNWError(0x%X, %s):  NetWare account name not specified in configuration file. E 34:PNWError(0x%X, %s):  NetWare account name (%s) not found in UAF.P0 35:PNWError(0x%X, %s):  Volume %s not added.  8 36:PNWError(0x%X, %s):  Trustee volume %s not added.  > 37:PNWError(0x%X, %s):  Creating shared memory (%d bytes).  / 38:PNWError(0x%X, %s):  Creating semaphore.  17 39:PNWError(0x%X, %s):  Attaching to shared memory.  t. 40:PNWError(0x%X, %s):  Opening device %s.  8 41:PNWError(0x%X, %s):  Communication setup failure.  7 42:PNWError(0x%X, %s):  Invalid configuration file.  - 43:PNWError(0x%X, %s):  Creating process.  s? 44:PNWError(0x%X, %s):  Bad %s volume. Invalid directory: %s.e5 45:PNWError(0x%X, %s):  Asynchronous event setup.  dG 46:PNWError(0x%X, %s):  Duplicate volume assignments for %s and %s.  E 47:PNWInform:  Shm. size and server configuration are incompatible.:N 48:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) initialization complete.C 49:PNWInform:  Salvage max bytes (%d) too small; converted to %d.rA 50:PNWInform:  Salvage max bytes (%d) too big; converted to %d. ; 51:PNWInform:  File mask (0%o) too low; converted to 0%o.v@ 52:PNWInform:  Directory mask (0%o) too low; converted to 0%o.+ 53:PNWInform:  Server advertiser started.:S 54:PNWInform:  Server address: %02X%02X%02X%02X %02X%02X%02X%02X%02X%02X %02X%02XeH 55:PNWError(0x%X, %s):  Unable to open SERVER log file (%s) reason %d.* 56:PNWError(0x%X, %s):  Create file %s. ' 57:PNWInform:  Service Agent started. : 58:PNWError(0x%X, %s):  Initializing IPC/RPC facility.  4 59:PNWError(0x%X, %s):  Sending IPC/RPC message.  6 60:PNWError(0x%X, %s):  Receiving IPC/RPC messag                                                                                                                                                                                                                                                                           + $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         UE "     =       e.  8 61:PNWError(0x%X, %s):  Destroying IPC/RPC facility.  ; 62:PNWInform:  Watchdog logged out %s from connection %d.e9 63:PNWInform:  Watchdog detached %s from connection %d.2: 64:PNWError(0x%X, %s):  System alloc failed (bytes: %d).6 65:PNWError(0x%X, %s):  Process memory heap corrupt.9 66:PNWInform:  Process memory usage reached %d percent.oC 67:PNWInform:  Process memory usage %d percent, please reconfige.s< 68:PNWInform:  Process memory exhausted (bytes wanted %d).A 69:PNWError(0x%X, %s):  Shared memory alloc failed (bytes: %d).R5 70:PNWError(0x%X, %s):  Shared memory heap corrupt. 8 71:PNWInform:  Shared memory usage reached %d percent.D 72:PNWInform:  Shared memory usage %d percent, please reconfigure.; 73:PNWInform:  Shared memory exhausted (bytes wanted %d).o' 74:PNWError(0x%X, %s):  List corrupt.s) 75:PNWError(0x%X, %s):  Adding to list.P- 76:PNWError(0x%X, %s):  Removing from list.e* 77:PNWError(0x%X, %s):  Destroying list.G 78:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) shutdown started.d; 79:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) down.c> 80:PNWError:  Shutdown failure.  Server may be in odd state.S 81:PNWInform:  PATHWORKS for OpenVMS (NetWare) being brought down remotely by %s.o' 82:PNWInform:  Possible Power FailuredK 83:PNWInform:  Maximum client open files (%d) too small; converted to %d.dK 84:PNWInform:  Maximum client open files (%d) too large; converted to %d.(N 85:PNWInform:  Trustee database being resynchronized with OpenVMS volume %s.P 86:PNWError:  SYS volume not defined in Cluster Volume File, or token missing.A 87:PNWError:  SYS volume not defined in PWVN$NWCONFIG.CFG file. 5 88:PWVNError: Close of file %s failed with code %d.b' 89:PNWInform:  Maximum procs reached.o- 90:PNWInform:  Maximum connections reached.M) 91:PNWInform:  Maximum volumes reached.nC 92:PNWInform:  Received unknown NCP. Func: 0x%02X (%02X%02X%02X).a: 93:PNWInform:  Received unknown NCP request type (0x%X).> 94:PNWError(0x%X, %s):  Entry partially renamed. (name: %s).9 95:PNWInform:  Hybrid user id (%s) bound to system id. .F 96:PNWError(0x%X, %s):  NW Filesystem may be corrupt.  Please check.H 97:PNWAlert:  File system version mismatch; volume %s. Please upgrade.H 98:PNWError(0x%X, %s):  UNIX ulimit exceeded for file %s on volume %s.C 99:PNWError(0x%X, %s):  Disk space may be exhausted on volume %s.nX 100:PNWInform:  Host directory not found (%s:%s).  Possible NetWare information lost. E 101:PNWError(0x%X, %s):  SYS volume static directory init failure. .C 102:PNWError(0x%X, %s):  Unable to salvage file %s on volume %s. W6 103:PNWAlert:  Server %s going down in %d minute(s).# 104:PNWAlert:  Server %s is down.e  105:PNWAlert:  Bindery opened.  106:PNWAlert:  Bindery closed.^ 107:PNWAlert:  Intruder detection: %s, [%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X %02X%02X].* 108:PNWAlert:  Account for %s is locked.4 109:PNWAlert:  New volume %s mounted to server %s.4 110:PNWAlert:  Volume %s unmounted from server %s.; 111:PNWError(0x%X, %s):  Bindery initialization failure. UE 112:PNWAlert: Station %d attempted login with unencrypted password.i= 113:PNWInform:  Trustee DIR consistency check, KEY:%X RN:%X E 114:PNWInform:  Trustee FILE consistency check, KEY:%X FN:%X RN:%X 0E 115:PNWInform:  Trustee USER consistency check, KEY:%X ID:%X RN:%X %C 116:PNWError(0x%X, %s):  Trustee database initialization failure.:A 117:PNWError(0x%X, %s):  Failure to open trustee database file.l= 118:PNWAlert:  Disk volume %s is running low on disk space.n 119:PNWAlert:  Hybrid user name or UIC mismatch (NetWare name:%s, OpenVMS name:%s).  Use SCONSOLE program to remap hybrid user %s.` 120:PNWAlert:  Hybrid user OpenVMS account disabled in UAF (NetWare name:%s, OpenVMS name:%s).7 121:PNWInform:  No more transport packets available.  Q 122:PNWInform:  Failure to create thread, probably insufficient virtual memory.iZ 123:PNWInform: Connection 0x%X logged out due to time restrictions (user objectID 0x%X).? 124:PNWInform:  Field Test image has expired, process exited.HZ 125:PNWInform:  Please obtain an official release copy of PATHWORKS for OpenVMS Netware.P 126:PNWInform:  PATHWORKS for OpenVMS NetWare field test software has expired.: 127:PNWInform:  This field test image will expire on %s.` 128:PNWInform:  Warning - Trustee id number is nearing limit, call you support representative.B 129:PNWInform:  Fatal - Trustee id number has reached its limit. 130:PWNError:  Disk quotas enabled for SYS volume and no quota record exists for NetWare UIC [%o,%o], or remaining quota is less than 1000 blocks./ 131:PWNError:  Error 0x%X verifying queue %s.wN 132:PWNError:  RMS error 0x%X writing bindery; bindery may be corrupted now.s 133:PWNInform:  Routine TriggerPacket() received a packet with an invalid value (%d) in the PacketEnqueued field.nring limit, call you support representative.B 129:PNWInform:  Fatal - Trustee id number has reached its limit. 130:PWNError:  Disk quotas enabled for SYS volume and no quota record exists for NetWare UIC [%o,%o], or remaining quota is less than 1000 blocks./ 131:PWNError:  Error 0x%X verifying queue %s.wN 132:PWNError:  RMS error 0x%X writing bindery; bindery may be corrupted now.s 133:PWNInform:  Routine TriggerPacket() receiv             4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG0.CFG;1 +  , q  . 2    /     4 E   2    g                   - q   0   1    2   3      K  P   W   O 3    5   6 ŭss  7  `D  8          9          G    H   J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        d $      PWRK$NETWARE.SAV               q q 4[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG0.CFG;1                                                                           E    2                                      
/*	Portable NetWare configuration/tunables file 			*/

config_file_version = 1		/*	Please don't modify.		*/

/*	General configuration. 						*/
client_stack = 80000		/*  	PGFILE usage per client         */
shm_size = 512*1024		/*	Shared memory segment size 	*/
max_connections = 250		/*	Max connections to be supported */

/*	PATHWORKS for OpenVMS (NetWare) specific configuration options:	*/

	/*	
	**	security	(optional)
	**		Specifies the OpenVMS security checking algorithm
	**		used for accessing files in all NetWare volumes */

/*	**		that do not have an explicit security option
	**		specified in the volume connection command.
	**		Three choices are available:
	**			CHECK
	**			  OpenVMS security is always checked.
	**			NOCHECK
	**			  OpenVMS security is not checked.
	**			CONDITIONAL
	**			  OpenVMS security is checked if the file
	**			  was NOT created by the PATHWORKS for
	**			  OpenVMS (NetWare) server.  
	**		If this command is missing, it defaults to
	**		CONDITIONAL.
	*/

/* security = "CONDITIONAL" */

	/*
	**	creator_ace	(optional)
	**		Applicable for CONDITIONAL security check only.
	**		Flag that determines what test is used to determine
	**		if a file was created by the server.  If CREATOR_ACE
	**		is ACTIVE, then the existence of the COMMON ACE is
	**		sufficient to bypass OpenVMS security using the
	**		CONDITIONAL security checking algorithm; otherwise,
	**		the creator field of the COMMON ACE is tested to 
	**		determine creatorship.  Defaults to INACTIVE.
	*/

/* creator_ace = INACTIVE */

	/*	
	**	deferred_close	(optional)
	**		Number of seconds between the time the client closes
	**		a file, and the file is physically closed by the
	**		server.  DOS applications and batch files typically
	**		close and reopen the same file quickly, so waiting
	**		some seconds before closing the file to allow the
	**		client time to reopen the file improves server
	**		performance.  Configurable from 0 to 60.  Default 
	**		is 6 seconds.  Specifying 0 forces server to close
	**		files in real time.  Deferred close can be turned
	**		off per volume by specifying the /CLOSE qualifier
	**		in the volume connect command.  
	*/

/* deferred_close = 6 */

	/*	
	**	max_filees_per_client	(optional)
	**		Number of open files allowed per client.  Can                                                                                                                                                                                                                                                                           CF $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         I "     N        range
	**		from 20 to 200, default is 50.
	*/

/* max_files_per_client = 50 */

	/*	record_type	(optional)
	**		RMS record type applied to files created by the
	**		server when not specified in the volume connect
	**		command.  
	**			STREAM		(default)
	**			FIXED = n	
	**			  where n is the record size.  Record
	**			  size defaults to 80.

/* record_type = "STREAM" */

                                                                                                                                                                                                                                                                                                                                                                                                                                      4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG3.CFG;1 +  , q  . 2    /     4 ?   2                        - q   0   1    2   3      K  P   W   O 3    5 1  6  Oޔ  7 ``D  8          9          G    H   J                           
/*	Set the location of the binaries. This parameter is used by
 *	SCONSOLE to determine where the binaries are located when it
 *	starts Portable NetWare. */
                                                                                                                                                                                                                                                                                                                                                                              4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG5.CFG;1 +  , x  .     /     4 F                          - q  0   1    2   3      K  P   W   O     5   6 CB  7 `8`D  8          9          G    H   J                           
/* 	
**	VOLUME ASSIGNMENTS
**
**	Format:
**		volume = "<volname> / <OpenVMS path> [ / <qualifier> ... ]"
**
**		One volume assignment (the SYS volume) is required, others
**		are optional.  The SYS volume must always have 4 required
**		NetWare subdirectories, MAIL, LOGIN, SYSTEM, and PUBLIC.
**		There are no restrictions on locations of volumes. 
**		Multiple volumes may be connected to the same location,
**		may be in a subdirectory of another volume, and may
**		be moved to different locations between instantiations
**		of the server.
**
**	Qualifiers:
**		All volume qualifiers are optional, and may be specified 
**		in any order, but must be specified after the OpenVMS path in 
**		the volume assignment command.  Most qualifiers can be 
**		abbreviated.  The most abbreviated form, if allowed, is shown.
**
**		/security=<label>
**		/sec=<label>
**			Specifies the OpenVMS security checking algorithm used 
**			for the volume.  
**			Three choices are available:
**				CHECK
**				  OpenVMS security is always checked.
**				NOCHECK
**				  OpenVMS security is not checked.
**				CONDITIONAL
**				  OpenVMS security is checked if the file
**				  was NOT created by the PATHWORKS for
**				  OpenVMS (NetWare) server.  
**			If not specified, the server-wide default value
**			is used.
**
**		/file_protection=<specification>
**		/filepro=<specification>
**			Specifies the OpenVMS file protection mask applied to newly
**			created files.  If not specified, OpenVMS is allowed
**			to put its default protection mask on the file 
**			according to its algorithm.
**			Example:	/filepro=s:rwed,o:rwed,g,w
**
**		/dir_protection=<specification>
**		/dirpro=<specification>
**			Specifies the OpenVMS directory protection mask applied 
**			to newly created directories.  If not specified, OpenVMS is 
**			allowed to put its default protection mask on the
**			directory according to its algorithm.
**			Example:	/dirpro=s:rwed,o:rwed,g:r,w:r
**
**		/close
**			Disables deferred file closing for the volume.
**			Files are closed in real time, before response
**			is returned to client.
**
**		
**		/record_type=< STREAM | FIXED | FIXED:n >
**		/rec=< STREAM | FIXED | FIXED:n >
**			Specifies the RMS file type applied to newly
**			created files in the volume.  Default is STREAM.
**			If FIXED is specified, an optional record length
**			value can be specified, which defaults to 80 if
**			FIXED is specified without a length.
**			Examples:
**				/rec = STREAM
**				/rec = FIXED:512
*/


/*	
**	Hybrid users can have a special home volume available whose root
**	is the hybrid user's default directory from the UAF.  To disable
**	this feature, comment out the "hybrid_volume" definition.  The
**	volume name is initially set to HOME, but can be any valid 
**	NetWare volume name.  The format of the "hybrid_volume" definition
**	is:
**		hybrid_volume = "<volname> [ / <qualifier> ... ]"
**
**	Note that the format is the same as the format for normal volumes,
**	except that <OpenVMS path> is not specified.  All volume qualifiers
**	are valid for the hybrid volume.  Also note that the hybrid user 
**	always has ALL NetWare trustee rights to the root directory of his 
**	hybrid volume.
*/	

hybrid_volume = "HOME"

                                                                                                                                                                                                                                                                                                                                                                4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG7.CFG;1 +  , 
]  .     /     4 G       A                    - q  0   1    2   3      K  P   W   O     5   6 ~A  7 @6$`D  8          9          G    H   J                           
/*	This flag indicates the device where PNW msgs will be printed.  The
 *	default is /dev/console (which actually equates to OPA0:)	*/
console_device = "/dev/console"	
console_flag = active		/* Are messages to be printed? 		*/

/*	The next two parameters are watchdog parameters. If you want a
 *	log entry made in the error log file whenever a client is logged
 *	out by watchdog then set log_watchdog_logouts to active.  If you
 *	want a message displayed on the console device for this situation
 *	then set P                                                                                                                                                                                                                                                                                                                                                                                          ;v' $      PWRK$NETWARE.SAV               
] q 4[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG7.CFG;1                                                                           G                                           display_watchdog_logouts to active. */
log_watchdog_logouts = active		/* default is active 		*/
display_watchdog_logouts = active	/* default is active 		*/

/*	Allow logins on startup flag.  This flag disables login to all
 *	users except the NetWare supervisor.  The supervisor can
 *	change this flag after the server is up in the DOS command line
 *	utility FCONSOLE.EXE  						*/  
login = active			/* default is active. 			*/

/*	This flag when active requires all clients to use encrypted
 *	passwords.  If you want to allow clients to use non-encrypted
 *	passwords then set this flag to inactive.  Think of this flag as the
 *	"password encryption required" flag.  */
req_password_encryption = inactive		/* default is active 	*/

/*	Shared memory variable.  The key indicates the unique number that 
 *	will be the PNW shared memory segment. 	*/
shm_key = 101861		/* default is 101861 			*/

/*	Message language. This value will directly correspond to a
 *	messages file in this directory.  Only the first three letters
 *	of the value are actually used.  Default is ENGLISH. 		*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG9.CFG;1 +  , q  .     /     4 E                          - q   0   1    2   3      K  P   W   O     5   6 KF   7 .`D  8                                                                                                                                                                                                                                                         
                        	 $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                          "     _           9          G    H   J                           
/*	Parameter passed to print server to tell it how long to delay
 *	between NetWare queue check for finding of print jobs. */
print_check_time_delay = 5		/* seconds; 5 is default */

/*	Portable NetWare has a simple read-ahead cache; used mostly on
 *	executable file down loads.  There is NO general purpose cache. 
 *	The cache block size token should be tuned to the UNIX
 *	filesystem block size that Portable NetWare is using (ie. 1K
 *	filesystems, 4K filesystems). */
read_ahead_cache = active				/* default: active */
read_ahead_cache_block_size = 9*1024		/* default is 1024 */

/*	If a write behind is wanted then this flag should be activated.
 *	We have found a 5-20 percent improvement on writes with this
 *	feature. NOTE:  the default for this flag is INACTIVE. */
write_behind_flag = active		/*	default: inactive */

/*	Assign list of users to get alert messages.  SUPERVISOR and
 *	all OPERATORS are always in the list so they need not be listed 
 *	here.  Users are seperated by a semi-colon ( ';' ).  There must 
 *	be a trailing semi-colon on the last token, as well, even if
 *	there in only one item. */
/* alert_notify_list = "GUEST;" */
ALERT_DIST_LIST = GUEST;


/******************************************************************/
/******************************************************************/
/*******From here down these tokens are not documented.************/
/******************************************************************/
/******************************************************************/


/*	NetWare supports a facility to save deleted files for a time.  
 *	This feature is managed through these tokens.  To activate this
 *	utility set the flag to active.  The facility will save up to
 *	salvage_num_files or salvage_max_bytes.  Those are the constraints
 *	of the facility.  NetWare will NOT save more than salvge_num_files
 *	files or more than salvage_max_bytes bytes.  A simple LRU is used
 *	to free up space in the event one of the two params is max'ed out,
 *	and someone has deleted another file. Salvage_num_files and 
 *	salvage_max_bytes apply to EACH NetWare volume. Once an file has
 *	been deleted and becomes a part of the salvage data base all
 *	trustee rights are lost. 
 *
 *	NOTE:  this facility of Portable NetWare has not been certified 
 *	in Novell's testing organization and for lack of testing time 
 *	Novell will make no guarantee of this facility.  For this reason 
 *	we turn the utility off. */ 
salvage_utility_flag = inactive;
salvage_num_files = 10				/* default: 20 files */
salvage_max_bytes = 2*1024*1024 	/* default: 2MB */

/*	Undocumented flag to set dir cache element size. */
dir_cache_items = 30		/* default: 30 */

/*	For development purposes only there is a runtime debug level.  
 *	See the header file debug.h for more details. */
debug = 0
ASTLM = 32767
BASEPRIOR = 8
BIOLM = 32767
DIOLM = 32757
ENQLM = 32767
FILLM = 32767
JTQUOTA = 1025
PGFLQUOTA = 200000
PRCLM = 12
TQELM = 22
WSDEFAULT = 2048
WSEXTENT = 16392
WSQUOTA = 8192
LONG_NAME_SUPPORT = active
                                2 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWPRINT.CFG;1 +  , ]  .     /     4 O                           - q  0   1    2   3      K  P   W   O     5   6 )z  7  9`D  8          9          G    H   J                 
             !++  ! PWVN$NWPRINT.CFG ! M ! This file is for configuring native NetWare print queues for use by OpenVMS L ! users only. It is not a configuration file for setting up print queues for+ ! PC clients. Use SCONSOLE to do that task.  ! J ! For each OpenVMS queue that you create that you want to be serviced by aM ! native NetWare server to a printer connected to that server you must define M ! that in this file. Five lines are needed for each queue definition. Leading L ! blanks and trailing line comments are allowed, except on the password line; ! (since the password can contain blanks and exclaimations)  ! 7 ! These lines must appear in the order specified below.  ! A ! Line 1: The name of the OpenVMS queue that you want to redirect J ! Line 2: The name of the NetWare file server that will service this queueK ! Line 3: The name of the NetWare print queue for the file server on line 2 E ! Line 4: The username to log in to the NetWare file server on line 2 - ! Line 5: The password for the user on line 4  ! O ! All values must be specified; if the password is blank, there must be a blank  ! line indicating that.  ! K ! It is recommended that the username not be SUPERVISOR; but one is created L ! either per NetWare queue or a single one for all NetWare queues. This userO ! does not need any privileges, except that they can add, delete, and list jobs 3 ! in the NetWare print queue; which is the default.  ! N ! The example below, when uncommented, sets up a OpenVMS queue called NW_HPJETO ! to be serviced by a NetWare server called NETS that has a NetWare print queue O ! called HPJET.  The user name VMSPRINTERS password PRINTIT is defined on NETS.  ! ! ! NW_HPJET			! OpenVMS queue name / ! NETS				! NetWare server for the target queue & ! HPJET 			! Name of the queue on NETS: ! VMSPRINTERS			! User name to log into NETS to print from	 ! PRINTIT * !				! Previous line contains the password ! F ! Add your groups of five lines below for the queues you are defining: !  !--    ! * !-- end of definitions in PWVN$NWPRINT.CFG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               8 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1 +  , q  .     /     4 L       T                   - q   0   1    2   3      K  P   W   O     5   6 S]_D  7  4A`D  8          9          G    H   J                        # L # Copyright 1989, 1991 Unpublished Work of Novell, Inc. All Rights Reserved. # > # THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, A # PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS ? # TO THIS WORK IS RESTRICTED TO (I) NOVELL EMPLOYEES WHO HAVE A 9 # NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR : # ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL WHO HAVE' # ENTERED INTO APPROPRIATE AGREEMENTS.  9 # NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED, ? # COP                                                                                                                                                                                                                                                                                                                                                                                          $ $      PWRK$NETWARE.SAV               q q 8[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1                                                                       L                              = "            PIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED, ; # CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, : # TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT: # OF NOVELL.  ANY USE OR EXPLOITATION OF THIS WORK WITHOUT= # AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND  # CIVIL LIABILITY. # 8 #    @(#)cmd/sconsole/help/helpfile 1.4 (Novell) 7/29/91 #    # 	 # Format:  #  #	<offset-number>  #	<number-fields>  #	1 <field-1-text-1> #	1 <field-1-text-2> #	1 <field-1-text-3> #		. #		. #		. #	n <field-n-text-1> #	n <field-n-text-2> #	n <field-n-text-3> #		. #		. #		. # D # See "sconsole.h" for offset numbers and consult the menu structure$ # definitions for the field numbers. #    # HELP_OFF (100) 100  1 8 1 Pressing a number executes the corresponding function.0 1 'CTRL/Z' or 'R' returns to the previous menu.  1 'E' exits SCONSOLE.    # MAIN_OFF (110) 110  4  1 0 1 Enter '1' to perform administrative functions.1 1 (NetWare Startup/Shutdown, and Error Log menus)    2 , 2 Enter '2' to view or set NetWare transport 2 and server configurations.   3 / 3 Enter '3' to view or save NetWare Statistics.  3    4 / 4 Enter '4' to run NetWare transport and server  4 maintenance utilities.                                                                                                                                                                                                                                                                              2 $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         : "     p       # BACK_REST_OFF (120)  120  4  1 & 1 Enter '1' to backup NetWare volumes. 1    2 . 2 Enter '2' to restore NetWare backup tape(s). 2    3 4 3 Enter '3' to view or print the Backup/Restore Log. 3    4 , 4 Enter '4' to clear the Backup/Restore Log. 4    # CONFIG_OFF (130) 130  3  1 < 1 Enter '1' to edit general system configuration parameters.4 1 (Server Name, base priority, process quotas, etc.)   2 < 2 Enter '2' to maintain the NetWare transport configuration. 2    3 9 3 Enter '3' to maintain the NetWare server configuration.  3    # ADMIN_OFF (140)  140  5  1 / 1 Enter '1' to start all configured components.  1      2 . 2 Enter '2' to stop all configured components. 2    3 ) 3 Enter '3' to start specific components.  3    4 ( 4 Enter '4' to stop specific components. 4    5 , 5 Enter '5' to maintain the error log files. 5      # UTIL_OFF (150) 150  2  1 , 1 Enter '1' to list the transport utilities. 1    2 * 2 Enter '2' to list the service utilities. 2    # STAT_OFF (160) 160  7  # 1 B # 1 Enter '1' to set the interval at which statistics are updated. # 1    1 8 1 Enter '1' to display general file server information. 7 1 (Server name, Versions, Connection information, etc.)    2 . 2 Enter '2' to display file server statistics. 2    3 7 3 Enter '3' to display file server internal statistics.  3    4 7 4 Enter '4' to display NetWare file locking statistics.  4    5 1 5 Enter '5' to display NetWare volume statistics.  5    6 : 6 Enter '6' to display the current connection statistics.  6    7 - 7 Enter '7' to save all statistics to a file.  7    # PRINT_OFF (170)  170  3  1 G 1 Enter '1' to maintain Host print server to NetWare queue assignments.  1    2 G 2 Enter '2' to maintain Host print server to OpenVMS queue assignments.  2    3 < 3 Enter '3' to maintain NetWare to OpenVMS form assignments. 3    # PSERV_FRM_OFF (180)  180  3  1 8 1 Enter '1' to list NetWare to OpenVMS form assignments. 1    2 7 2 Enter '2' to assign a NetWare form to a OpenVMS form.  2    3 ; 3 Enter '3' to deassign a NetWare form from a OpenVMS form.  3    # PSERV_CFG_OFF (190)  190  3  1 = 1 Enter '1' to list currently assigned Host print servers and 9 1 the File Servers and NetWare queues which they service.   ? 2 Enter '2' to bind Host print servers to NetWare print servers ? 2 (previously created with the NetWare PCONSOLE client utility) B 2 and assign them to service print queues on NetWare File Servers.   3 , 3 Enter '3' to deassign a Host print server. 3    # DATA_CAP_OFF (200) Unused    # START_OFF (210)  210  6  1 4 1 Enter '1' to start NetWare communication services. 1    2 - 2 Enter '2' to start the NetWare file server.  2    3 . 3 Enter '3' to start the NetWare print server. 3    4 - 4 Enter '4' to stop the NetWare print server.  4    5 * 5 Enter '5' to stop NetWare file services. 5    6 3 6 Enter '6' to stop NetWare communication services.  6   . # HYBRID_OFF (220) Replaced by HYBRID_CNFG_OFF   # ERR_LOG_OFF (230)  230  2  1 2 1 Enter '1' to maintain Transport error log files. 1    2 1 2 Enter '2' to maintain Services error log files.  2    # TRAN_UTIL_OFF (240)  240  3  1 , 1 Enter '1' to view IPX routing information. 1    2 - 2 Enter '2' to reset IPX routing information.  2    3 3 3 Enter '3' to view IPX network status information.  3    # 4 8 # 4 Enter '4' to enter the IPX "track" menu for tracking8 # 4 routing information and service advertising packets.   # SERV_UTIL_OFF (250)  250  2  1 4 1 Enter '1' to see a list of "visible" file servers. 1    2 , 2 Enter '2' to see a list of attached users. 2    # 4 7 # 4 Enter '4' to see a list of "visible" print servers.    # 5 3 # 5 Enter '5' to monitor local print server status.    # TRACK_OFF (260)  260  4  1 7 1 Enter '1' to view the routing information and service  1 advertising packet trace log.    2 8 2 Enter '2' to clear the routing information and service 2 advertising packet trace log.    3 > 3 Enter '3' to start logging (or tracking) routing information" 3 and service advertising packets.   4 = 4 Enter '4' to stop logging (or tracking) routing information " 4 and service advertising packets.   # TRAN_CNFG_OFF (270)  270  5  1 > 1 Enter '1' to view or set transport configuration parameters. 1    2 < 2 Enter '2' to configure Novell Virtual Terminal parameters. 2    3 , 3 Enter '3' to list configured IPX networks. 3    4 7 4 Enter '4' to add an IPX network to the configuration.  4    5 < 5 Enter '5' to remove an IPX network from the configuration. 5    # 8 : # 8 Enter '8' to enter the Named Pipes configuration menu.   # SERV_CNFG_OFF (280)  280  4  1 5 1 Enter '1' to maintain file services configurations.  1    2 4 2 Enter '2' to maintain print server configurations. 2    3 6 3 Enter '3' to maintain the Hybrid User configuration. 3    4 3 4 Enter '4' to maintain the security configuration.  4    # TRAN_ERRLOG_OFF (290)  290  2  1 4 1 Enter '1' to view the NetWare Transport error log. 1    2 5 2 Enter '2' to clear the NetWare Transport error log.  2    # FILE_CNFG_OFF (300)  300  5  1 + 1 Enter '1' to set file service parameters.  1    2 2 2 Enter '2' to list NetWare volume configurations. 2    3 0 3 Enter '3' to modify a specific NetWare volume. 3    4 ; 4 Enter '4' to add a new NetWare volume.  (Associate a host * 4 file-system path with a NetWare volume).   # 4 7 # 4 Enter '4' to change the name-space assignments of a  # 4 NetWare volume.    5 2 5 Enter '5' to delete a NetWare volume assignment.4 5 (Does not remove files from the host file-system.)   # HYBRID_CNFG_OFF (310)  310  3  1 5 1 Enter '1' to list the current hybrid user bindings.  1    2 ) 2 Enter '2' to add a hybrid user binding.  2    3 , 3 Enter '3' to delete a hybrid user binding. 3    # SECURITY_OFF (320) 320  4  1 5 1 Enter '1' to set security configuration parameters.  1    2 0 2 Enter '2' to show the alert notification list. 2    3 9 3 Enter '3' to add a user to the alert notification list.  3    4 > 4 Enter '4' to remove a user from the alert notification list. 4    # PSERV_QUE_OFF (330)  330  3  1 C 1 Enter '1' to list Host print server to OpenVMS queue assignments.  1    2 = 2 Enter '2' to assign a Host print server to a OpenVMS queue.  2    3 A 3 Enter '3' to deassign a Host print server from a OpenVMS queue.  3    # TRAN_ERR_LOG_OFF (340) 340  4  1 C 1 Enter '1' to maintain the Service Advertising Protocol error log.  1    2 : 2 Enter '2' to maintain Novell Virtual Terminal error log. 2    3 8 3 Enter '3' to maintain the IPX/Decnet Tunnel error log. 3    4 , 4 Enter '4' to maintain the Stack error log. 4      # SRVCS_ERR_LOG_OFF (341)  341  4  1 . 1 Enter '1' to maintain the NetWare error log.$ 1             SYS:SYSTEM/SYS$LOG.ERR   2 - 2 Enter '2' to maintain the Server log files.  2    3 3 3 Enter '3' to maintain the Print Server log files.  3    4 4 4 Enter '4' to maintain the Print Spawner error log. 4    # NW_ERR_LOG_OFF (342) 342  2  1 3 1 Enter '1' to view the NetWare Services error log. $ 1             SYS:SYSTEM/SYS$LOG.ERR   2 4 2 Enter '2' to clear the NetWare Services error log.$ 2             SYS:SYSTEM/SYS$LOG.ERR   # PSRV_ERR_LOG_OFF (343) 343  4  1 ) 1 Enter '1' to view the Print Server log. % 1      PWVN$LOGFILES:PWVN$PSERVER.LOG    2 * 2 Ente                                                                                                                                                                                                                                                                           . $      PWRK$NETWARE.SAV               q q 8[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1                                                                       L                              W 
            r '2' to clear the Print Server log.% 2      PWVN$LOGFILES:PWVN$PSERVER.LOG    3 / 3 Enter '3' to view the Print Server error log. ' 3        PWVN$LOGFILES:PWVN$PSERVER.ERR    4 0 4 Enter '4' to clear the Print Server error log.( 4         PWVN$LOGFILES:PWVN$PSERVER.ERR     # SRV_ERR_LOG_OFF (344)  344  4  1 # 1 Enter '1' to view the Server log. ! 1   PWVN$LOGFILES:PWVN$SERVER.LOG    2 $ 2 Enter '2' to clear the Server log.! 2   PWVN$LOGFILES:PWVN$SERVER.LOG    3 ) 3 Enter '3' to view the Server error log. # 3     PWVN$LOGFILES:PWVN$SERVER.ERR    4 * 4 Enter '4' to clear the Server error log.# 4     PWVN$LOGFILES:PWVN$SERVER.ERR      # SAP_ERR_LOG_OFF (345)  345  2  1 & 1 Enter '1' to view the SAP error log.# 1   PWVN$LOGFILES:PW                                                                                                                                                                                                                                                                           mb $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         ' "            VN$SAPERROR.LOG    2 ' 2 Enter '2' to clear the SAP error log. # 2   PWVN$LOGFILES:PWVN$SAPERROR.LOG      # NVT_ERR_LOG_OFF (346)  346  2  1 & 1 Enter '1' to view the NVT error log.! 1     PWVN$LOGFILES:PWVN$NVTD.LOG    2 ' 2 Enter '2' to clear the NVT error log. ! 2     PWVN$LOGFILES:PWVN$NVTD.LOGb     # TNNL_ERR_LOG_OFF (347) 347h 2R 1r) 1 Enter '1' to view the Tunnel error log.K$ 1      PWVN$LOGFILES:PWVN$STUACP.LOG   2 * 2 Enter '2' to clear the Tunnel error log.$ 2      PWVN$LOGFILES:PWVN$STUACP.LOG     # NOT_USED_348 (348)   # SPWN_ERR_LOG_OFF (349) 349F 2  1K+ 1 Enter '1' to view the PSpawner error log.N& 1      PWVN$LOGFILES:PWVN$PSPAWNER.LOG   2 , 2 Enter '2' to clear the PSpawner error log.& 2      PWVN$LOGFILES:PWVN$PSPAWNER.LOG     # NOT_USED_350 (350)   # STK_ERR_LOG_OFF (351)D 351N 2T 1 ( 1 Enter '1' to view the Stack error log.# 1      PWVN$LOGFILES:PWVN$STACK.LOGN   2E) 2 Enter '2' to clear the Stack error log.E# 2      PWVN$LOGFILES:PWVN$STACK.LOGT         # STARTCOMP_OFF (352)H 352T 4  1L8 1 Enter '1' to start NetWare communication services and  1 the Tunnel(s) if configured.   2h3 2 Enter '2' to start the NVT process if configured.  2	   3e- 3 Enter '3' to start the NetWare File Server.x 3>   4 . 4 Enter '4' to start the NetWare print server. 4      # STOPCOMP_OFF (353) 353  4e   1t- 1 Enter '1' to stop the NetWare Print Server.  1    2 - 2 Enter '2' to stop the NetWare File Server.   2u   3c2 3 Enter '3' to stop the NVT process if configured. 3P   4(7 4 Enter '4' to stop NetWare communication services and n 4 Tunnel(s) if configured.     0e 0n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              	                           9|Z                                        ] q 3[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG)DAT;1                                                                               2                         + =             m~j$gjCRu\X},g&T:]n3>BOinKv8fXE.2}dmFS"z1M9c`<Y$oPivRZRzgA;W,/:kc+TLVn'\D,z?'4R) '|qxQ_0w:Y`iC_>	VRcv,uD!@|u
vtv_54g(Y*:iO;D/{k5_`d^?|40hZ~=pozU)R`LYtY
 1HaIwL!wQY7aB(a%KW
                                                                                                                                                                                                                                                                           c% $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NETWARE.SAV;1                                                                                                   $   $                         z "            uEJ@?fqo$$$cF%ADUY.JzpK>n0HH}*7%K>Mjx~&MWU	A)o$s
VL0(fv.Cs=]) !v)89HOvC}#7W:M7Yb2;~8yj4`86"<Cs*?@"sL^2^x~sdz^Y`ecPi
/K`BEuva/rasHYf!Sn7,OXxyoT~uN
.
Yn5 oM>GMIkfT.- g3Q?WP)w59akEf
Z~AOk
@
&};<xUOr9J	;0-DnA{'f~^xWD>~^mUwCe=B\7(rl0Hfxxz)e1fpi0+?)g)7P6snZM4}w-"qU6)"$CERUlN2p/~Etx,52&Pwm#	A]ipmGo`56@+;^Db)A4$(qstVhkOa+%:xn!8dP#{n:E\ r*h0\8h(0llrB/d.)>&+ agBH:sqE#Nid_E
0S"^p#[,=?4
&8A_{)oaGc_OP%E+ze36{EF_X+;{RDugY"<:PRO%B~J	/Z1S[wdZB6 .fHRx=p "t</ *H6e7/dpuUX&GW\;Z
t,-t/bO'>-V0-ia^K='v(Q2-*Cc)rdS?_Dpc2(c?x2OdQ2~J
ONl:K/{kDYUJ_	_GGZo&}B	LuNEf D
+4
Nj&g93N[BZB3|JOF=[@q@T"/0;I "^~Hq*q" <
F9AK?{eIP1%
t`Q*=o=e6,_z}Sc lU[X}K|o`[kntdLyh'   gx"1%IJ
p=+uZ\:I=jQO ^ NrW
gLHsi?J.V exDxc,T&N%t:FCO:8wL-~2=e6
X|3	*tX+IRzgK`^LKXP8Le;MvbVQ_#z&[=FV)>@p
bT7.
rT*ksHf!_=z]Gv'h
F
ffR
TYa=b?<+6?wM	\Wq(H)Il
]/yqi(j!4~ 50j_O{#OG M-/z>
N>DF|UvH@o[?tG
YD=hS5kU{zB1b*
Jl:\J#+t6s03(mt5k6ZUJ!^(ti$$uLt?%8NkY#?,zgdKs5Whks0s$<FlHAIT>R;?[)5Rc!k&=cIEo_$(2:R9phxkl5SZ4rO1s~wW
{KG2(RL+B} 8p?,X0p +G@WrK=M X_@
IP?_-O2"w@I
8U
`S<n*rW-1-9}lo$kF#E2y%;rjo^[M"'h7e9"7` cKbM|je3uVrWP'_vT[U@YjXc1-d}j
5
#d_$TQj0Pff}tjeaUNgZ!g4jW:co-|jp6 }ae~yocL<$-`#f:|YbM:(@2)7W#mV:]S8`9,g2XZX\B5 yyu
(\j
r`j'} ]'4X
d_GHTk44216)O=<o@EfZn{i*y[dr4!$GXO:2.
AZSz(hR
\F sUNL9Fm6
oMxFAu&QJw}B)5#;}UL2K
bZ%A1S
d *h[#WE:<@q.tr#:LUc/d\G
*4qeg{]<+_GQ[\rP	G"^k)VR~epo[Y+cAQ,&L
nS5$9>k&:9FFcp$)+!21b[2?	ywy&9LHo_]8E74jm3~REvsde+~~R}oJ4~!1	's$Fm71:Rx
c?@8k/.<%Zjya.hX)u0Q9~iC";2gJ~ZfjdV]w-m]u2I1
|+a!-hr[a1'`>Pr}?TK*=xfB7R9# z2IIIa;{t	~dK+6?@\AnQLusuf7zks8E>K2>R	fm`D-WL"~Pr$%# r)dhg DP8|#h?$'V\PqyFJ?r-0UKppr&g=.&aE?u/Z1r4jo,VSGJ[	/Yl!m$L
zs
4}L2=R7W>1;GSYO*NnM#=
Bf|y(WEC"Y	y)pwF$0|Y+^}7\'w1l)7"W,uAH'%o(F]b/4G4a6bWyd$x!Ru}
 JRXZ]('I#eU4J5eobYk%O$.M^Y
WihVp
`KxJ_8) @!d3 H`\m"\
hzJL="N
=xX1Nfp-G%
>sg{)uK%H cz0@(d,-!k'~\MScN(&Yv0x-Sf4,%T7$UW{yPT:AITe*gbg$Ax	Des/VF+
iDl!oX!MVGrDQ-|bk|Y0w'i565%b~E<kF%<h_QzN 5 B$cx&t+N"2
h

FmRcMBuB]yI#sp tJE NqkRu	reN! Xicbt.^=hdk%.Z[9']>s'i`>D&Q'#;'Vc=p2r1a^
Wk{ERb1A+[Rdx TNo[n>,Po+g;P6pB^mGyj{uz'*e #,/[!xlV_'=]5*,-`>7('L/b%=["E[{dF{uJ1(N}s[F-uX!+yc'
9[m[WGIGUHCvS0'rgp8^a62a?n^U1:W97<-j0BHhs@c]S\n)x4eltw'j\`G=4y34P!,/4MT[ufB[,O7m6VJYMCbdU_d]$-S'c5d7QANADS|p[ne9S /`0C|$a\>_0N22gZ=I#:X3pKV8%/Iu#IVXr{6 #ZCeWl
Wei1',-iO3`"EINwNZq&/lE%v6BBa Y{Y~3(A|~_0Q(XW*Up[# <='ze71I>\HU.Jf^LYEb%nW3x|(	P	r[;+5IrQ-HV
J:3~E=&Qw|31s jYQIF
P[eI>ELhD#J!tlgSZ}6}^bP@G8FGs4k~NZLP
Z4}f"{!8z}j.;l5]|%9_K[j+x6'}fZnRTL
boC4gQpUq+o&5f~LX8?.-]*R44e:J3O|8Iik=mm~s7D1fKYM=W)gXp'&rOe':UV4'2O]0]]\T
OBy)@/D
L1!zILP,v8wD=)<FB<d$q.uy|um.cEruU
 <hnTbggKpdSeDK[&bI> Lt	m
f>J{97)	r1aczb<-($a}tdoX7G>O9 5mi+Yv	)4VY/P
!wgM(@k!^Yr"\]
vN0K5X^r?Zfc1U=[o,rQw;ppZgx^0!
of#V}qoT\D)a@OLeitrc}rY}|9 =<KlCS?m%n? 3Y7yeCCv:9<<+S95x_\,ibUD7tb:c#<B}N~3CQ8*t~lu?|n zH,To.Sl6U@[M3'e#MGT3
?uK<Bca=5{GK 4mT66g:4NXT?SVk)hv_"u<Di<EYkz}cp+k6#0[h+ZtEVBrd$D]j T	uGmnwOe|\c,cKEv
#[tZ6QB<tfH1oe9kDl(mfie^%f\|cW,E_<*p?C8ZR)@(E	rY(!B&Vo:+JB>~C zi%9|Ti3TBu#S`}+(kKWcA<`Wkf2ELl2:_vP#.("E&wNv-gpEJSae ? )Fm(*khrBPDcXj>uq;,wnAY^~I8vF HJyhPU.z5m]
Of
:uf3s>ebet<NRLtyYL_5ah#WE>AgvrQeDE[X(qIMLOB!]uD1aAR7A:Hx8o.oW ]y^"])25|yuL
{ZLv0{>xitj;E@$-Y`^s;i,!pb~v}z6"}bjs#--Vao2^6LCXPj>EC&)q* =4=03WB6?Qa^4W.KEx
%yo=iVuyf^=UY|J$aXC"9;U*Sgx_a6QN[% 8CKk|_~T~,\m?kS'Z
CXh_VXGEo<Fy5%g<0	\l[fG`U>iTcH[10t1>zg,>TL}S&
J4&r8.i;loG+&re%g{wagS
sCZdk# iS*[Q2P8PM.! "^b to.XR =c[n
Wt5`ksRV
y#][ct`6	QNnIBZ:1Cu~)c
bRF,2IraSn>u&A"Z	1S2&b =>lunh1a(BbivN&%XKt0JJRE5hcuTR,C5;yg	IV [:m{KUUoe?qEf[JB &{{< "BNa0#{JD',^-D;JC@RJ=O"|m	w>k	-CD\@]E~ u2"YW
LiJYZ@KqhZM97`^YAZuoq)-Pu?:!qC8l@F>g	MMMH
uV KK)E#06Jb:4;r7/at( "|(J${r> 6.#.vVJ.VEZDLs
Hv:Z\ K\	hmIn/O_f}e0z@dZS*{_1qI77F]CySR3~[jXBIP?\4y/rWK=GWQ42R8([bN
Jb !:#)/Z-]I=5_|.9G4]()dn48S -3)$}`'uB%H_U	G	EFJAy#f	U8;>Ie'CH3=S"_)wL5Y G0TWy}%W*,< 3uvk:J5@8 `7/~js8uQeYt.% yWQYu*;DA:&zd6AmIR
}	}|k W-3CV\*"6> tg&il>N /T-i|u#$1'F(5/s J77F0 2:fZ[k s&rqe* ;lr|E81M^lS(ETZam<_BU4P=NM<
9_..f
U6b}/bc,cnSU(OEeb &o]$'x_}_Xhm+Vz,
1-L2M:wlxf&e?`-#vB(FTl~RiB#)Wy0{	8_[,'Jr~+wy{jZ*uD&?<~76m#s 5UfZ{z
wbZw(Uz^7:>gSS8zP@ix7>g<' 1g"/oM7Aag>@%`\GXzH,1II.L*7Ck?<O]yC?7*i$16zwFa<u>43ffqc=h+U{'~4grv2u2g%TxPi%UkZ:pgU:Wq}cw_1y$d ]uI 
?s5X#&bK |4n
Ca{1dYR%)](2qqd!(|#kmP(Jic)TJ?hZgk{o2) x5x6">:rg2v+r% K7c-&kJ4v`_6C44+:In 0b\FW[`|AW?7:-Z/-W4&oxO?vBXYl:[A/8c5[Eu.TJ|5.ooqc<Qj\F

Yk<Pag;$v Up->~fRXB-P$F#e pQ.\^yA"yt$i?r8t!*Ue}{c
q8^05%-?@_\1>0UQA[,801rli	{;qY_O2f:2~5ny<3wRN4,qdf?Mgq84:YGbDbGPO1b(Oqr~yd:l&h9'-99>t)VRf~L}/9t]UD70NxS8og73#upF.n$[3,8!aP)ptV&[>U?^E@V;2]dCP3a]G8dm O0iuA$9?Z82y$
ok#=<v y-prmrhdCkw%$i(+i9PYA Bri" k]t>aRl}rD
d(w^Sq(J\Ej9K9tM8
Z(CPJIp0u+.<9p\lqr(#<~n DFeEx[C
5(8E"/$F]M$7"_);\D*4iV#_K0l[F6#/k,VWhRTUhmn=CGr?M-*do.+AEJK@Ni}+:@pUQCe345yx~GM\V6RHc}cm"3>~uGEmX#v[YMY<Z39v?K0@##,%$oPvi N5UK0%x59 `\FR=tJP	{6m3t4+5*eD3]`[0VN(l>XE|="?pX8]=V2FP KV\?8a'a>HJu{%d!"s2IU>0|]	/~4|&6	qj}<Cb{J/2%n@	"!tQx;aV@,Elh0YwDts553m`)0E@L^6J]Im
3t~F/iE}1R'auVGChV[uX\Vx sSh1u-[YFA+bdu`S4|S5,?y2Yie7@pm50+RZl\b%t,KoH ?FRWakI3yQhQ+,de-oc)bw+$6Yq%pfg2&$W[~%@ZI
X?S>)d?:ZG:&^eXew(%qK#+> QTL7%ASM`I0)S
xbe m,4rBWSF2SV-7:7|< ,\7y_-m[n\laXEDxF% JM`3?#e~#Fc=_
!> R5IOPb Kz)<}]
@8S"q^	 suli^ i|O"S? X67N#G9)F*X8I?>Sh"0ao1KqKe7_JCkfmPhJ%\pQGS!SH&kZ$42Dn"@}N-4h6c^rNI1X?2?ixs-E"FP5S"GQ;3%>L!\C8Co?}
jfUDL3hCB9pXE{9U]Zb<3s,	#U[\4*[q47Hr$Z=t8~)$-[8gM9p!*y: 4"_WV6=V&

e{b$c7JFgY6>VG0N0C=/{>8v"B8@mmd1p8EY\(A'/,\b:	YP|Mrry^X5g%5A
	8 #~KD4e,WCj]9t&=,HdU$t3l-{3"70SSZ{n
Bh(
qhDB|.h%V)u08^7?#E{.Y#Ik*1};8=e58oR!5U+9!mvu6j/"Fbls8*;+x~|'"yCRmab"(4U.?kP ?l;;N#wIWIN u{c}d^rb;EHem+Sfg4et*`Y#iaU?^%+5h ed4
j[Fpu6=|O9t7v>&*`x=IU_JNFa!Sj6Yg-4"{fn-S.Y]VC?a~wD;7r\9^wOu(r83d0x &&#k4Lr1Ks gp<`E:u D3["YntbLR7/yJu*r9Lqwcn}c))u&J~v@=3[dM:nAhM0-JL5!R9kSt8=dk,~aqo|dY ZA,!-f/vr8/`nvx b-8E.f*bd(,&!X;	,b`o>o.r<0g0r"fId/_x&(c> btx4EWb:~>!4k/V,9: NP	DRGR~Z<
_0U`I,b;05
{|q'~kJG/kc`?jsCyHq5?=ؘr%`GJ;eoL$#UK82TX?Ql_jF8DG)SjzoH
dg~x25T1
nGr-%-$#Pk6`*3z;K b>0pO,QlW
/(k~) j,pf%N?p3Y`A9ZD?T g#JQ"#-]^x@#$@"#&[RT7*Di
Kg|00:oN2kx4 P~_
qs*>PA)=?cx!{zS=wm"}d?Bsm#STz_iUfq)xn>mS59 98i^o(F!+]Lsh{	 "hZ`P_FSj	-DZw
;1j#d4}m@z$P[A=PAq]OQnr.$4)R#;/
'2Wp(xPjjf${rot2V;tbR1gp}q~41 Q.vr,Xqv$"?.
~~cgaZg^^
e,NAAq/cz8C}BFL }Tq$?5-5*7nq#GgesX3[.1	"}O#j4_WcSQ~wvEQOk[#(dEP[3qb2\=X^P>s?
;I)AhGWdl8uok8rolV!|Y;՚c-w_<]^*z+F|ad
}
;.dtS+}GWaGs:]Jo2Z(d:n.Yz	Eg::;fSB[8ujfmQ
OXM6Yq.*9;uWtHP+
S-=bFRTZF2z&.E,8HDHsj
+wTvb~NL pIaKc$v0 Zv~b eha] *
4,pR%tv| Vlvj&,1"1 @/l*;'o o6=q : u9fyc17F=;dahB~79D"1j\
T
,5;&al9[XTMHBxS`Tyzbiu$Ns#]`BDW}A[ paCs or job level logicals, etc.   A 11 Specifies the paging file limit.  The paging file limit is                                                                                                                                                                                                                                                                                                                                                                                                                           P$ $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWRK$NWCONFIG.COM;1                                                                                                ^                              j               * [NW.KIT.EXE]PWRK$NWCONFIG.COM;1 +  , q  .     /     4 ^      	                     - n  0   1    2   3      K   P   W   O     5   6 OXM  7 ߩmD  8          9          G    H  J                 I $! Copyright  Digital Equipment Corporation, 1994.  All rights reserved.  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!6 $!	 NetWare initial configuration command procedure		! $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!% $ set symbol/scope=(nolocal,noglobal)  $ STATUS = 1 $ on error then goto ERROR_EXIT " $ on control_y then goto CONTROL_Y $ get := read SYS$COMMAND  $ put := write SYS$OUTPUT  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!' $!	 Check for required privileges					!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!N $ REQ_PRIVS = "ACNT,ALTPRI,BYPASS,CMKRNL,DETACH,GROUP,GRPNAM,NETMBX,OPER," + -J      "PHY_IO,PSWAPM,SETPRV,SHARE,SYSGBL,SYSLCK,SYSNAM,SYSPRV,TMPMBX,WORLD"" $ PREV_PRIVS = f$setprv(REQ_PRIVS)! $ if .not. f$privilege(REQ_PRIVS)  $ then? $    put "%PWRK-F-NOPRIV, no privilege for attempted operation" 
 $    put -O      "-PWRK-I-REQPRIV, operation requires the following privileges: "+REQ_PRIVS  $    goto NO_PRIV  $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!? $!	 Define all PATHWORKS logicals necessary for configuration	!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!" $@SYS$STARTUP:PWRK$COMMON_LOGICALSB $ ROOT = f$parse(f$trnlnm("PWRK$NWROOT"),,,"device","syntax_only") $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!/ $!	 Check for minimum number of blocks free			!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $ BLOCKS = 0N $ if f$search("SYS$UPDATE:PWRK$NETWARE.SAV").nes."" then BLOCKS = BLOCKS + 250- $ MIN_FREE_BLOCKS = BLOCKS	! No section files + $ FREE_BLOCKS = f$getdvi(ROOT,"FREEBLOCKS") # $ if FREE_BLOCKS.lt.MIN_FREE_BLOCKS  $ then $    put "" K $    put "''ROOT' has only ''FREE_BLOCKS' blocks free.  PATHWORKS requires" K $    put "a minimum of ''MIN_FREE_BLOCKS' blocks for PATHWORKS data files." , $    put "Please delete files from ''ROOT'." $    put ""  $    goto ERROR_EXIT $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!7 $!	 Check for minimum number of blocks in disk quota		!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $ define/user SYS$OUTPUT NL: $ define/user SYS$ERROR NL:  $ on error then continue $ mcr PWRK$SHOWQUOTA 'ROOT' C $ if $STATUS.eq.%x000003D4 then PWRK$BLOCKS_AVAILABLE = "999999999"  $ on error then goto ERROR_EXIT - $ if PWRK$BLOCKS_AVAILABLE.lt.MIN_FREE_BLOCKS  $ then $    put "" \ $    put "User ''f$user()' has ''PWRK$BLOCKS_AVAILABLE' blocks available on device ''ROOT'."^ $    put "PATHWORKS requires a minimum of ''MIN_FREE_BLOCKS' blocks for PATHWORKS data files."5 $    put "Please increase the disk quota on ''ROOT'."  $    put ""  $    goto ERROR_EXIT $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!1 $!	 Create the initial NetWare directory tree			!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!3 $ if f$search("SYS$UPDATE:PWRK$NETWARE.SAV").nes.""  $ then* $ put "Creating NetWare directory tree..." $ exclude_list = "" O $ backup SYS$UPDATE:PWRK$NETWARE.SAV/save_set/select=[PWRK$NWROOT.NETWARE...] - ,   PWRK$NWROOT:[NETWARE...]/new'exclude_list'+ $ purge PWRK$NWROOT:[NETWARE.CONF_FILES]*.* & $ delete SYS$UPDATE:PWRK$NETWARE.SAV;* $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									! $!	 Common exit							!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!
 $COMMON_EXIT: B $ if "''PREV_PRIVS'".nes."" then PREV_PRIVS = f$setprv(PREV_PRIVS)
 $ exit STATUS  $! $CONTROL_Y: : $ STATUS = %X1000002C		! SS$_ABORT, with output suppressed $ goto COMMON_EXIT $!	 $NO_PRIV: ; $ STATUS = %X10000024		! SS$_NOPRIV, with output suppressed  $ goto COMMON_EXIT $! $ERROR_EXIT: $ STATUS = $STATUS $ goto COMMON_EXIT                                                                                                                                                                                                                                                                                                                                                                                                 * [NW.KIT.EXE]PWRK$NW_IVP.DAT;1 +  , lF  .     /     4 B       0                  - n  0   1    2   3      K   P   W   O     5   6 `!ǤmD  7 `HmD  8          9          G    H  J                   @ data,req,sys$common:[syshlp.examples.pwvn]example.c,1849847944A data,req,sys$common:[syshlp.examples.pwvn]example.com,561457547 B data,req,sys$common:[syshlp.examples.pwvn]example.opt,1196717556> data,req,sys$common:[syshlp.examples.pwvn]getopt.c,641818418> data,req,sys$common:[syshlp.examples.pwvn]getopt.h,3210822460 data,req,sys$common:[syslib]nwapi.h,16015297113 data,req,sys$common:[syslib]nwerrors.h,1098768834 8 data,opt,sys$common:[sysupd]pwrk$netware.sav,4240203179 data,req,sys$common:[sysupd]pwrk$nwconfig.com,893298262s9 image,req,sys$common:[sysexe]pwvn$banner.exe,3791738939x; image,req,sys$common:[sysexe]pwvn$binddown.exe,2071045231s8 image,req,sys$common:[syslib]pwvn$cache.exe,32628159018 image,req,sys$common:[sysexe]pwvn$client.exe,325989110; image,req,sys$common:[sysexe]pwvn$doslogin.exe,4256042718r: image,req,sys$common:[sysexe]pwvn$netware.exe,39583418987 image,req,sys$common:[sysexe]pwvn$nssp.exe,2799828668:7 image,req,sys$common:[sysexe]pwvn$nvtd.exe,4186886200:; image,req,sys$common:[syslib]pwvn$nwapishr.exe,2278290289[@ data,req,sys$common:[sys$startup]pwvn$nvt_start.com,2066729336A data,req,sys$common:[sys$startup]pwvn$nssp_start.com,2066729856$@ data,req,sys$common:[sys$startup]pwvn$nwcp_start.com,476564969D data,req,sys$common:[sys$startup]pwvn$pspawner_start.com,846109118B data,req,sys$common:[sys$startup]pwvn$server_start.com,995547267: image,req,sys$common:[sysexe]pwvn$pserver.exe,26479619909 image,req,sys$common:[sysexe]pwvn$pspawner.exe,25336787g; image,req,sys$common:[sysexe]pwvn$sconsole.exe,3218140862a6 image,req,sys$common:[sysexe]pwvn$smb.exe,26856564048 image,req,sys$common:[sysexe]pwvn$slist.exe,34259362578 image,req,sys$common:[sysexe]pwvn$tlist.exe,34426158387 image,req,sys$common:[sysexe]pwvn$ulist.exe,817334315pn$pspawner_start.com,846109118B data,req,sys$common:[sys$startup]pwvn$server_start.com,995547267: image,req,sys$common:[sysexe]pwvn$pserver.exe,26479619909 image,req,sys$common:[sysexe]pwvn$pspawner.e               * [NW.KIT.EXE]PWVN$BANNER.EXE;1 +  , q  .     /     4                             - n  0   1    2   3      K   P   W   O     5   6  !YD  7  pmD  8          9          G    H  J                    0 D `     0205        !YD     
  hx                                       PWVN$BANNER                            	V1.0-611F      !YD 05-13                                                
       ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ) $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$BANNER.EXE;1                                                                                                                                { 
                                                                                         	        
$  D   f                                                                                                                                                                                                                                                                                                                                                                                          ************************************************************************* %s
 * Software: %s
 PATHWORKS V1.0-611F for OpenVMS (NetWare) * Build:    %s
 04/05/98 *** Unable to read system parameters, status = %08X
 %s
 * Type:     %s
 * Version:  %s
 * Model:    %s
 * SMP:      %d of %d CPUs running
 * SMP:      No
 * Node:     %s
 * Cluster:  %d nodes
 * Cluster:  No
 %s
  < ^  wRbUUߢJ  Scߢ^ߢNc  c|~߭|~ 0PTTЭTTT¡ cU cP<%\L
<\L<9\L<\L   Sc c c
c
P-c7=  Sc 2~McccUs  P                                                                                                                                                                                                                                                                                                                                            @   @       T   `                                                             
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                                                                                                                                                                 
    BANNER x  main
   main_1     D  		:
x  :        DIGITAL_COPYRIGHT                                                                                                                                                                                                                                                                                                                                                                                       * [NW.KIT.EXE]PWVN$BINDDOWN.EXE;1 +  , q  . K    /     4     K   2                     - n  0   1    2   3      K   P   W   O L    5   6 `ԡYD  7  mD  8          9          G    H  J                  0 D `     0205        YD     : h4             #                         
PWVN$BINDDOWN                          	V1.0-611F      YD 05-13                                                                   
        ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001&      !         PWVN$NWAPISHR_001'      !         PWRK$XTILIBSHR_001(      !       PWRK$STREAMSSHR_001#      !         PWRK$CSSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001'      !         PWRK$CMTLIBSHR_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            %c 
%c w+b ctx=stm rfm=stm 
BINDDOWN ERROR: Writing to bindery upgrade file.
 Create rb ctx=stm rfm=stm 
BINDUP ERROR: Invalid file
 Attempting to attach to %s
 
BINDDOWN Error %X: Attaching to file server
 
BINDERY Error %X: Could not get connection ID for server!
 Please enter the SUPERVISOR password for %s
 Performing login as %s to server
 SUPERVISOR SUPERVISOR 
Invalid password
 
BINDDOWN ERROR %X: Logging in to file server
 
  Reading objects into memory  * 
 BINDDOWN ERROR: Failure to allocate memory
 * 
BINDDOWN ERROR %X: NWScanTrusteePaths
 
BINDDOWN ERROR %X: NWIsObjectInSet(%s,%s)
 fwrite fwrite 
BINDDOWN ERROR %X: NWScanPropertyValue
 
 BINDDOWN ERROR: SetValue: Property must be a set 
 fwrite fwrite 
BINDDOWN ERROR %X: NWScanPropertyValue
 Q_DIRECTORY fwrite fwrite Q_DIRECTORY 
BINDDOWN Error %X: SetValue failed
 
BINDDOWN Error %X:ItemValue failed
 * 
BINDDOWN ERROR %X: NWScanProperty
 Q_DIRECTORY 
BINDDOWN Error %X: SetValue failed
 
BINDDOWN Error %X:ItemValue failed
 SYS:\MAIL\%X \LOGIN Error reading "%s"
 
 BINDDOWN: Total number of objects to be down loaded = %d 
 
  Scanning objects * 
  Scanning object %s FILE *%X
 REC_HEADER type: %X, len %X
 Header W Object 
Properties call failed
 Trustees call failed
 
 BINDDOWN: So far we have downloaded  %d  objects; Remaining %d more objects
 
  Creating properties for %s VMS_USERS 
BINDUP Error NWGetObjectID( %X, "%s", %X, id ) == %X
 SYS:SYSTEM/%08X 
BINDUP INFORM %X: NWCreateDir - Directory already exists - %s
 
BINDUP ERROR %X: NWCreateDir - error creating %s
 PASSWORD GROUP_MEMBERS 
BINDUP ERROR %X: CreateProperty
 PASSWORD 
BINDUP Error %X: NWAddObjectToSet
 
NWGetObjectID error %X 
BINDUP Error %X: NWChangeQueueJobEntry
 Skipped set addition for %s(%s)
 PASSWORD 
BINDUP Error %X: NWWritePropertyValue( "%s", %X, "%s"...)
 
BINDUP INFORM %X: NWCreateQueue - Queue already exists
 
BINDUP ERROR %X: NWCreateQueue
 Found object mail directory out of order!
 SYS:\MAIL\%X 
BINDUP INFORM %X: NWCreateDir - Directory already exists - %s
 
BINDUP ERROR %X: NWCreateDir - error creating %s
 
Found login script out of order %X
 SYS:\MAIL\%X\LOGIN 
Failed to write the login script!
 Could not open file %s
 
  Adding Information to Objects BINDUP Error: Invalid record %c
 \*.* 
NWDeleteFile( "%s", %X ) == %X
 
NWDeleteDir( "%s" ) == %X
 
  Creating objects  Header R Seek Header R2 
  Skipping QUEUE entry SUPERVISOR 
  Skipping Supervisor
 
BINDUP Error %X: NWCreateObject.
 
  Created Object %s   
BINDUP Error %X: Failed to set password for user %s.
 Usage: binddown filename servername {upload|download}
 SYS$COMMAND r Fatal: can't open SYS$COMMAND input
 SYS$COMMAND w Fatal: can't open SYS$COMMAND output
 DOWNLOAD UPLOAD Usage: binddown filename servername {upload|download}
 First attempt to establish a connection with the server failed.
 Retrying... 
 Could not establish a connection with the server requested.
 Could not create a file to store temporary bindary information
 
BindDown has failed.  Your bindery was not recovered from
 the server selected.
 
BindDown                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           mE $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$BINDDOWN.EXE;1                                                                                                     K                         e "            was successful.
  The bindery was stored in %s.
 Could not open temporary bindary file
 Upload of the bindary has failed.  Please report this problem.
 Your bindery was successfully restored.
 %d id = %08x name = %s type = %d 
  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ЬP%`!ЬRb~'  PbRЬRbP ^WVU Te&  PdPPP; U  U U  GPF?PdЬRbb~&  PbRbTTgf&  d dTRTRdЬScc~J&  PcScP ^SRQQ-PQPP-) I A 	?PP\   /P|   "P\|/P-P-~ %   ^]RjSTߢߢߢݬ%  Pd9cUdc%  Pߢ}%  d`%  PPߢNo%  P ^RS?Tߢ`ߢXߢUݬ%  PdJdc%  PPc
ߢh	%  Pd
%  d<~c$  PPPP| |^_S`Vu%  UЬRbPb~$  PbRbЬRRÅ $  Td?fR$%  P0e 	 eá dP?fR%  Pe dPݬ?$  Td~|Z8d|e<f~$  P+e 	 
pdPe 	 eÃdPP2 P  ^<e~a$  <W~W$  P^8TVW+Y@$  XSZĲw#  QQ-OQPP-( H @ ?PP\   /P|   "P\|/P-P-~ߤ#  ߭<~<i~#  P
ˏ hPPZP1c<PP1Wg1RPZ   ZP6g~"  Pf"  PUQQ-OQPP-( H @ ?PP\   /P|   "P\|/P-P-~ߤ""  ߭<~<i~"  P
ˏ hPPZEP7<PP.6URfPB`PЭ`߭fPB!  fPB4P`UUg1'Z   Z6ݧ   !  ZP ^TRެSRc0PTRP޼Q @aPRPЬQ@aT @aRRcҚSS޼RCb^TXV!  YRS :!  1!   [!  Z   UQQ-OQPP-( H @ >?PP\   /P|   "P\|/P-P-~ߤ~    W<~ ?߭W[<h~jPS.ˏ iPPSS   [S   RS!   SP;TfePPf<~ePPS1ZPP@   1P<^=TW7ZYE   US   Vg1N<   [Y  XQQ-OQPP-( H @ ?PP\   /P|   "P\|/P-P-~ߤ  6VQgRA4P<`~Aݬ[ݬ<j~a  e!e  ݬݬe,  PezS2ihPX  P2   6VRgPB߭  gPB4Rbi2hP_?  PVV1P^U[YA&  <n    X   ~ B@ABݬݮݬ<@~,  PP%F  f  ˏ 0  RRRP@RRŏ^  PBVWf1 W 1 kZPfPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ
Z6k
PReS2ihP  P2 ߭4i2hP  PVWfW 1:A1PPt^SYEX  TRU b  u W< Z  VQQ-OQPP-( H @ n?PP\   /P|   "P\|/P-P-~ߣ  ~ v  uvwxugZݬ<i~  PUdd  ˏ dPPUUP<PPP
?gf  P.x[  PP@x/	@x\@xP䐏VhfP  Ph~vfP  Pw1P ^1S2ZX@  WRT   Q<PPP
QQ[1 ߭<~ݬ<j~  P1 Ph  PPh  PPVPP'߭<~ݬPT8g!  TP߭<~ݬFPTTF  TP   <Y   Um  VQQ-OQPP-( H @ ?PP\   /P|   "P\|/P-P-~ߣ
   0  ߭kYe<j~i  PT!g  T1 Pgm  TP[߭Ñ  P1 PhfPPhfPPTPP&߭<~e4PT7gÝ>  TP߭<~ePTT  TP1P| ^SUTЬR<4PP1hM<~   ݢ0  e      e   Pd+  PPd<~
  PP1 ԭ<Vԭ߭V߭<e~\      Ld  PPխdݭ5  PP<e~  P^UZNY  [S|W34  L%   H  RR-ORPP-( H @ j?PP\   /P|   "P\|/P-P-~ߥ  ߭<~`<j~)  PWˏ kRRW1jPR1_<RR1S߭߭~  ޭޮQ0nnVRTn+PRTP @PTP@R @TTnؚnRRB߭b  VfO8i  P(ixf<~~łfş  Pi8  PŨ  PPP<~߭PWůb  WPݭPWD  WPXz  XP{
PQPP1X~X  1W   WWP ^S =PP sPRP   Ec  PPc  Uc{  PP2 P μ^SW
  VJЬP<~ݬ2  PP߼߭M  ޭ̮ޮU0nnT|Qn(QRP @PRP@Q @RRnؚnPP@߭-  {ЬR<4PPP
PbK  P<4PP7qЬR<4~b<g~  ff<4~b<g~UW  PЬP<4PPcŰgÌ(  ~  P/f  fÜ  Pf  2 P  ^   ЬP<~  PP5<~t  +  #     PP ^RNT  S ݬl  *ЬP<~ݬ  PPdP߼&  PdP<PP߼  PvЬQ~~aЬQ<4~a<D~  cc  c&  dP8^TWS  V2   CЬP<~+  PP)1$߼HB  PP<~߭߼ЬQ<4~a<g~P  ff  fQ  P<xPP1 <PP1 RP Q`a`PQR<~߭<g~  ffux  PѣPˏ  PPU<UPxPRxPPPRRU<UXxPPU<UPxPRxPPPRRU<UPxPPXPc <g~x  f!fč  ߭߼Ķ  2 P< t^kT  U~ v  ЬP<~v  PPkЬP<4PP߼  PPw~xv~ЬScЬR<4~b<~  ezc<4~be/  c*Z߭x ЬQ<4~a<~_  e(e ! e
  PeU
  2 P ^GRd  SЬP<~
  PP߭ЬQ<4~a<~
  P
vb
  iݭ¡>
  <~
  P0c  c®

  Pc  2 P ^sRtSЬP<PPe  PP߭ЬQ<4~a<c~
  PE
  !  1 PݭFr  cԭ   P>ЬP<~߭<c~  PY  <c~  ݭ}  2 PΤ^{V[uZzUX|  YQRƕ  QQ-OQPP-( H @ 
?PP\   /P|   "P\|/P-P-~ߦJ  h~,  PPEPPPL   
 &!  && 8 & 1
n?PwP10PTW 
  h<~ͦ
  PS6Pjͨ<ͦ~k
  ii   SPSS1PP1P]P1PP1pPPP1YP
P1BP~ƶ	  P ^cR
  SЬP<~	  PPZ	  	  	  Pc  cݭG	  x	  Pc  cݭ	  PΈ^SZXY	  WlR	  QQ-OQPP-( H @ &?PP\   /P|   "P\|/P-P-~ߣf  i~H  P.	P  PE1MF1SPO)<~i  й P1.7	  Pi<~  P<	  P<PPP
F	  1P<PP#߭^	  Pi	  1P~~<~߭<j~  g#g  g  gÂ	D  1q߭߭W  ޭޮV0nnUQTn(QTP @PTP@Q @TTnؚnPP@߭å	  <PPP1û	ú	P߭<j~  g1g  1߭gü	  1P <~i  й TP                                                                                                                                                                                                                                                                           E $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$BINDDOWN.EXE;1                                                                                                     K                         Ti "             r^5  TZV:WUѬ
ЬR?	$   3  6
*
  P
8
     i
]
  Pk
     ЬRТRbb~  PbRbđ
ЬRݢ  PU,Ě
ݢ  PUġ
a   p  ЬRݢnPG
<  SccݢKP$'c<j~  <j~     U1?ЬRТSߤߤߤS  Pg@fUgf  Pߤ  g  RPRPߤN  RRd}  X1~ PSx PYSg ~  Eg*  PS8g/  Ug  PSSSĤ    X1 ЬRݢ  X1 U1 ЬRТUߤ`ߤXߤUU~  PgQgfv  PS@fߤhj  S-Pgk  g<~f>  P	SSSS1*  X,P PX  XĘ  X<j~  <j~  g	g  XP  ^ѼPѼPPP ^߭  PP߭n  PRЬQaPPP  P< ^SЬRTެUTe!<4~bT*  6RTTe                                                                                                                                                                                                                                                                                                                                                                                                                                                       @   @     (  4                                           
   L      l   <   T         |     D     4  ,      l      t                 0   0  (     H  P        H                h       0  8    H  (  0  `  (   x  p      ܨ     8  
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                         
PWVN$NWAPISHR                                                  PWRK$XTILIBSHR                                                 PWRK$STREAMSSHR                                                
PWRK$CSSHR                                                     	SECURESHR                                                      
SECURESHRP                                                     PWRK$CMTLIBSHR                               $9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     BINDDOWN  	PGETINT32 <   
   strupr 0 strupr_1     1    T GetPassword t 
GetPassword_2  
GetPassword_3  GetPassword_137  
GetPassword_1 
        K         GetPassword_138   
GetPassword_1 
             MyClock b 	MyClock_4 &         
CreateFile  CreateFile_5  CreateFile_6     9     CreateFile_7 
    x     OpenFile B 
OpenFile_8 ] 
OpenFile_9 
    J     OpenFile_10          MakeConnection  MakeConnection_139  MakeConnection_1 
    !     MakeConnection_11  MakeConnection_12      MakeConnection_13     0    g MakeConnection_14 p MakeConnection_15 
     MakeConnection_16     +        
Disconnect "     ObjectsToMem   ObjectsToMem_17   ObjectsToMem_140 6 ObjectsToMem_4 &    j     ObjectsToMem_18 
         ObjectsToMem_19      ObjectsToMem_20  ObjectsToMem_141  ObjectsToMem_4 &    j    k ObjectsToMem_21 
     ObjectsToMem_22 .        $    	BlankName  BlankName_23  BlankName_24     '    P    0 Trustees  Trustees_25  Trustees_142  
Trustees_4 &    j     Trustees_26 % Trustees_27 B Trustees_28     .    Y Trustees_29 ;               OldSetValue  OldSetValue_30  OldSetValue_143 F 
OldSetValue_4 &    j     OldSetValue_31      OldSetValue_32  OldSetValue_33     2 OldSetValue_34     z    2      T SetValue  SetValue_35  SetValue_36 %     SetValue_37     4 SetValue_38 4 SetValue_144 7     SetValue_39  SetValue_40      SetValue_41     e        ^       	ItemValue X ItemValue_42 X 
ItemValue_145  ItemValue_4 &    j     ItemValue_43     : ItemValue_44 ] ItemValue_45     .     ItemValue_46      ItemValue_47     _       
Properties @  
Properties_48   
Properties_49   
Properties_50   
Properties_51     '      
Properties_52   
Properties_53     '    V          
Properties_54   Properties_146 2! Properties_4 &    j    ! 
Properties_55 ! 
Properties_56     !    " 
Properties_57 " 
Properties_58 %" 
Properties_59     &    6" 
Properties_60 K" 
Properties_61     &    T    `      h" WriteMailDir " WriteMailDir_62 m# WriteMailDir_63 # WriteMailDir_64         h       $ Objects \$ 
Objects_65 \$ Objects_147 $ 	Objects_4 &    j    $ 
Objects_66     	% 
Objects_67 % Objects_148 0% 
Objects_23 I% 
Objects_24     !    K    % 
Objects_68 (    % 
Objects_69     & 
Objects_70     !& 
Objects_71     O      k   l& DownLoad & DownLoad_72         & HandleObject G' HandleObject_149 \' HandleObject_23 u' HandleObject_24     !    F    ' HandleObject_73     ' HandleObject_74     ( HandleObject_75     *( HandleObject_76 ^( HandleObject_77 /    c       ( 
HandleTrustee ) HandleTrustee_78     |    ) HandleProperties z) HandleProperties_79     ) HandleProperties_80 
        ) 	HandleSet L* HandleSet_81 ^* HandleSet_82     * HandleSet_83     * HandleSet_84 * HandleSet_85     * HandleSet_86     `+ HandleSet_87 
        !   p+ HandleSet_88        + HandleValue + HandleValue_89 ,, HandleValue_90     h    L, HandleValue_91 q, HandleValue_92 z, HandleValue_93 
    , HandleValue_94 
    (    Z    $   , 
HandleMailDir - HandleMailDir_95     - HandleMailDir_96 I- HandleMailDir_97 0    i        - HandleLoginFile - HandleLoginFile_98     - HandleLoginFile_99 &. HandleLoginFile_100 I. HandleLoginFile_101     <    d. HandleLoginFile_102             x. AddObjectStuff . AddObjectStuff_103 . AddObjectStuff_150 . AddObjectStuff_4 &    j    v/ AddObjectStuff_104 / AddObjectStuff_151 / AddObjectStuff_78     h             0 NukeMailDir 0 NukeMailDir_105 Z       
 d1 UpLoad 1 
UpLoad_106 1 
UpLoad_152 1 UpLoad_4 &    j    !2 
UpLoad_107     @2 
UpLoad_108 
    W2 
UpLoad_109 r2 
UpLoad_110     )    2 
UpLoad_111     2 
UpLoad_112     2 
UpLoad_113     3 
UpLoad_114     03 
UpLoad_115 =3 
UpLoad_153 T3 	UpLoad_23 m3 	UpLoad_24     !    H    c    3 
UpLoad_116 3 
UpLoad_117     :    >      4 main A4 main_118     m4 main_119     4 main_120     4 main_154
 4 main_1 
         4 main_121     4 main_122     5 main_123     *5 main_124 M5 main_125 T5 main_155     $    G    y5 main_126 }5 main_156
 5 main_5
 5 main_6     =   
 5 main_7     g    5 main_127 
    5 main_128 5 main_157 6 main_72         6 main_129     6 main_130         <   6 main_131 6 main_158
 6 main_8
 6 main_9     P    07 main_10     s                                                                                                                                                                                                                                                                           kݙ $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$BINDDOWN.EXE;1                                                                                                     K                               .           ;7 main_132 
    L7 main_133 W7 main_134     h7 main_135     *        v7 main_159       
 7 objcmp     7 	GetNWTime X    8 
print_objlist 08 print_objlist_136     =   		           	      	    	            	 	      	  	   	                   	                     	   	       	 	       	 	 	   	           	       
     
	     	                    
                               DIGITAL_COPYRIGHT                                                                                                                                                                                                                                                                                                                                                                                                * [NW.KIT.EXE]PWVN$CACHE.EXE;1 +  , \  .     /     4         h                   - n  0   1    2   3      K   P   W   O     5   6 ZD  7 +mD  8          9          G    H  J                     0 D `     0205                  hP              G      N          N      
PWVN$CACHE                             	V1.0-611F      ~ZD 05-13           <             <   
  >     C   
 E          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001  J  <        .    6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    ^с  Y  Xu  Wp~  TT~ݬ	  PT~ݬ	  P29PѼ2<PާRޤSP~ S   h  _cS~Rf
  PRShv  RQQQRRRPޤ\RޤS< ~ RA  P~ S2    ߧ!R$  hR
  SP~R	  PR|~S  Pǀ  ︀  ﶀ  RQQQRRRP   Pޤ\SRդդRRP	2;UXP< ~ S  oS  hSl  ߤS  PiPPԤi2:PPUURRRPݬ  PUURޤ\nVR  
  RRPSߤ	  P
|iPVVSSRR	,  UPP< ^E|  S  ݬ  P	,  ޣ\nUR^  
N  RRPT"ߣ*	  P|4  PUUTTRR	,j  RPP< ^r  R{  SޢTޣUP~ U   ,  
  _eU~T  PTU    TTTTP< ^ir  TB{  Rޢ\SޢU< ~ S  P~ U  l~  ߤ!S  ~  Sq  UP~SN  PS|~UV  P+~  ~  ~  SPPPx^~  Vq  Wz  RޢYާ9Zf, $(0|4"xf|ާ>"ާQ#ާm#,ǅ #ǣ #$ #  #̞(#؞0"䞦4<"8TXS1 PXP@QaT@|QaU@xP`SP~ Y  YP~T  PPP>|~Y~  S"S#)Pe$PPePZY~  PeeXX
XЦPPP1^2 P ^-p  Sy  Rޢ\TQբբQQP2;P< ~ TX~  oTO~  ]|  T4~  ߢT  P{  PԢ{  2:P ^x  Rޢ\nSQ{  
{  QQPPߢ  P|{  PSSP                                                           ^ԭTЬS=T9Pw}  PRPRPPT RB}  ЭbRSTTJխEޭnTSn,о R&bb-   PSSݾ }  Ծ T	,}  TSP< ^UTЬPh`Pc`G`nSRn/о P)``PRRݾ |  Ծ SP,|  STTЬRb|  bU	,w|  UPP ^xRRWWUVSUUSSVTTTRRU,V(z  UP{TPQPPRSRSSVTTTRRUVVXWWTUPTTPPUSSSRRT/U+Pz  TP{SPQPPRPRPPUSSSPPTUUWP  ^ЬЬԭ|~ ߭|~ 0PQPQQP^|аȐʐޭحX  ߭.{  ݬ{  PRRݬ߭{  RSѬlԭޭRSR_bSRS P<WPVRUޭTWVUTԭ|~ ߭|~ 0PQPQQRR	SPPޭح̰SЬRb|~|~|~ P
XЭbXPP ^ЬPPRRRS SPPP ^ЬPPRRRS
 SPPP ^SQЬP`ՠQQRѬ.ѬLЬQЬP`aԡQ`RQ4aPQ*PЬQЬPРaQRQ`QPSSP ^SЬP`\ՠWѬ!Ѭ7ЬPЬQa`а aа PԠ#PЬRЬQСbbPРbP԰P ݼ&y  SSPP| ^0l  VЏ   (	}(#(
4ޭRSRЬRݭx  PЬݭx  PSЬTT>ԭ߭ ߭P	я  P2RBd2SPSSP ^SЬRb|~ bPbPSSPP ^&x  PR
 Rw   qP RP ^SЬRbPՠPw  bS
,w  SPP< ^UTЬP1 `P1 ՠHnSRn/о P)``PRRݾ sw  Ծ SP,gw  STT4ЬRSRbPՠP;w  bS	,3w  SUPTUP,w  UPP ^ЬQСPRP
`PRPRPP< ^i  TЬSݣݣݣcSߤAv  УRUR#PݢݢݢbRߤqqv  bRURUP| ^UTѬ TTUSSSRެVRf1U-  Tz  TP{SPQPPRPRPPUSSSPPTUUP^X   WSgX	XPVз UVgRТUPUeRSNQRS
PQQRSPAUPPSTSQTTfUBeURR   SXqTP ^h  \̤ Fu  RbX~̺ b b b8 b8 b~
b~b*b<bQb~]b<nbb̌b0̗b   ^p  RЬS S|߭߭߭t  P{ݭ ݭt  ЏSKBEЭPSЭP ЭPЬЭPЬЭPԠЭPТЭPЏBESKբЭ
ТPЭЭ֢SPЭPРP  ^ݬt    ^ЬPPQQ ^h  QЬPPRRޡ
ޡnP  ^ޭSЬRвTQac
עX(s  PPЏBIO`ЭPЏREQ֢\խ2QPЭSЬRТR޲DR bPЭRЬЭRЬЬS֣TЭR,PP^p  Y q  Zh  [(T ,(T (T ̈́Ѯ10͈4͌͐8
ѪJ8SѪЪSSS   	2A1 z  SP{   PQPP
2B1 S͐<͔@͘P2HyP2H`PP2HDPP2H(PP2HP,q  Ѯ1m  < ~tP͈͌,ݮ,]P͔,RǏd   RЮ,ŏ   ,(z    P{PQPP  $z  D   P{PQPPD   Xz     P{PQPP   WxRRSz  SP{PQPPSVxRRSz  SP{PQPPSUA WRVR8R(RUR8RXR$R߭ݭy  Pl  ͈S͐SR͌R߭߭ݭ  Pޭ0վ0
ݾ0p  Ծ0ЮPЭTn  l  Э͐SЮ0n  ЭRR   R                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          M $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                  "     
       R  RR  @ RRWRRVRR8RR(RRURR8RRXRR$R TŏX   TRRDTTSxSRRCCRRbRSSTTRRDTTЭiЏGC iRЏCBiRЭiRЭiRЭiRЮ iRЭԢiRԢiRЭ iRЭТ$iRԢ,iRЭ̢0iRЮ,4iRЭȢ8iRЮ<iRЭĢ@iRЭDiRЭHiRЭLiRЭPiRЭTiRЭ`iRЭ(iRԢXiRТX\iRԢdiRТdhiRЮliRԢpiRԢtiR͈xiRԢ|iR<  iR<  iR Ѫ,	iRЪ, iR Ѫ	iRЪ iR Ѫ$	iRЪ$ iR Ѫ 	iRЪ  iR¤ Ѫ(	iRЪ(¤ iR¨ Ѫ0	iRЪ0¨ iRЪ4¬ iRЪ8° iRЭ iRЭ  iRЭ ЮЮ͠í͜  ͤD  ͨ    ͬ*  ͰJ  ʹ
  ͸3M  ͼ!  iR(T ̈́iR(T ,iR(T (T 
i  Ю XiRЮ    VXRiSFЏCFDbЏSDV8T   X  ViRЮ    WTW   WSЭRS<SW  Tԧ<iRТ8WЮXVծ,1 WSЏBCBcЏBCB(RRb(RR0RRb0RRX@iRТDRTTTѭhԣd|\ԣlP   ޫ
P   WiRТRXVV,1q8 iRݢ0k  iRЏGSB0iRТ0RЏGSB _B  P @D   E&  P .D  iRЏTHRҐ iR RЏTBLiR S iR SЮiR RԢiSÐ RТTЏTHRӠ iR  RЏTBLiR  S iR  STRRiR  RiSà RTЏTHRӘ iR RЏTBLiR S iR STRRiR RiR RTnf  jmf  iSУRբÐ e    P2TPiR  C    P2TPiR !    P2UP6f   g   P ^g  Sf  RТPP  u U U U   1 6?PcQСPՠݬ 	  ݬcP 	  ݬcP 	  ~g  վ
ݾi  Ծ`g  cnվ 
ݾ i  Ծ ԢP,i  2 P| ^Eg  S^^  TOe  RޢUV  PƏ   P|~߭PHPQP	QBi  Эգ8%ЭЭ| ߭߭P2WP޼QPaPP3ݬ ah  f  "ߤ;Uh  f  Uh  2IVVPP ^yf  RS  PƏ   P|~߭PHPQP	Qh  ЬPЭ``բ4%ЭЭ| ߭߭P2VP޼QPaPPݬ ah  P2JSSPP ^ЬRbbh  bP ^ЬRbbg  bP ^\  Se  \ЬRݢߣRg  TdݢߣpdݢÌ dݢñ dݬ4 dݬl d̈ d̔ @d̜ gd̤ Ìd̨ ïd̬ d̰ d  ^d  WTgRz  P{ PQPPVT1 gRF$SUS%T Ѭ@	2MT	PSUУ<SSTT\ݬ_P2HTEݬHP2HT.nd  ЬXPXgRբ2LTP,f  T1 gRТQС<С8PgRQ@gRТ(R0gR֢,QSRRbRRRRbRRRRbRR RRb RR(RRb(RRԣ<Ь@VDЬHЬLԣPXTЬXЬ\8 `e  ЏFSB`ЏFSBdØ |à Ü U
gRSF$S<TУ8RTRRP  ^P ^)c  ScPРRТ<Т8QcPRAcPР(P0cP֠,RP   ^b  Sc\̐   PRPѢ1P G  c\Ь\ݬPP \=  Ѣ   ^ЬPՠd 7=  ЬPՠh '=  ЬPՠ\ =  ЬPՠ` =  ЬPՠl <  ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q :<   ^ЬQ޼RAbPѠ8ѠDР<PP ^Z  Rޢ
nޭTЬSг`Qadףd)Poc  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP^`  [Z  SޣnլѬ   kTЬRBX2NPЬRТTդPѨTݤb  ԤPԤkUХxPPYXYTQTPХ<TTTPTQPQP{TPPQQZХ@WZVYQXPFgRѢ8PѢDQТ<RRU :  ץPPTRXRpե\kեlfե`aȠ RХ0P0RPRE` `:   ЭRݢkPРR޲LRbkPР`R޲TЭRdkP֠dPU#G  P    ^U_  SЬQСTT~ ݡta  RTPݬcPРPް@P`PRRT2 P| ^_  UTެVfRTN  STRBRբ0ЏTHRbЏDSCePРPްDP `PԢRPTfPTP< ^TެUeRTNХ STRУPBP`.ePРPBP`ЬQСPBP`СPBP`PTePTPP< ^TެUeRTPХ STRУPBP`0ePРPBQaBP`ЬPРPBP`PTePTP^]  WUVU1 ެXШ YUTթe  STP@RѢ=ЬhPՠ~ݢgPРPްLP`gPРPݠPU
PТRRUTTUgPРR޲PRbU1v  ^ЬPՠd 7  ЬPՠh 7  ЬPՠ\ 7  ЬPՠ` 7  ЬPՠl 7  ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q 6   ^ЬQ޼RAbPѠ8ѠDР<PP ^U  Rޢ
nޭTЬSг`Qadףd)P^  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP ^ޭSЬRвTQac
עX(s]  PPЏBIO`ЭPЏREQ֢\խ2QPЭSЬRТR޲DR bPЭRЬЭRЬЬS֣TЭR,P0^Z  YT  ЬRТX|ԨլѬ   iSЬRBU2NPѬ   2OPŤ 2XPŘ 2PPiPР0R֢֥hѬXլPѥT{ݬs\  P|Ԩ2QPЬTЬRRRPPX
RXPЬiPР0R֢֥xTݥ@HPSݨ\  |Ԩ2RPSPŠ 1 ޭRiPа`QabiPנd*[  PPЏTWE`ЭPЏTWEiP֠hխ2QPЭRiPРPްDP `PЭP,iPРPްHP `Ť 2XPŘ 2PPŠ 1aiSУxRRURQRPУ<RRRPRQPQP{RPPQQУPRbR1У0R֢ ŀ ޭWiTR  ޭPд`Sc`פd+PZ  PPRЏTWEbЭRЏTWE֤hխ2QV4ЭSФR޲DR bPФPR޲SЭRcФR޲HR bPgVVRRPiPР@VЮTЮPUSDfQPѡ8SѡDPС<QQW*ݭc<  UݬݬWݬ!P	|ԨPiRТPЭSТ@WЮTЮZР[UVգd M2  գh A2  գ\ 52  գ` )2  գl 2  |||| (,У,(04У40V8ZDZ[PPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgUݬݬݭݬρP	|ԨPiPР@VЮTЮPUSDfQPѡ8SѡDPС<QQ1 A  P1iPР0R֢ ŀ ޭWiTP  nޭPд`Sc`פd+PX  PPRЏTWEbЭRЏTWE֤hխ2QV4ЭSФR޲DR bPФPR޲SЭRcФR޲HR bPgVVRRPiPР@VЮTЮPUSDfQPѡ8SѡDPС<QQW*ݭ;:  UݬݬWݬP	|ԨPiRТPЭSТ@WЮTЮZР[UVգd %0  գh 0  գ\ 
0  գ` 0  գl /  |||| (,У,(04У40V8ZDZ[PPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgUݬݬݭݬYPPiRТPЮSТ@WЮTЮZР[UVգd K/  գh ?/  գ\ 3/  գ` '/  գl /  |||| (,У,(04У40V8ZDZ[PPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgݬUݬݬݮ(ݬϨP	|ԨPiPР0R֢֥pUݬݬݮݬP	|ԨP^S  [M  Rޢ"nЬPРWЬS(Pѣ(PGգdԣdЬUUTЬPTXUXPЬU£DU@U֣P1PkPР0P֠$ЬP SVWZYkUޭTеTP`d	ץX'KU  PPЏBIO`ЭPЏREQ֥\խ2QX3ЭTХPްDS cPЭPZЭPY֦TЭP,XXSSPkPРPްHS cޭTЬSU(dUUףT֣PգdԣdЬTĤ pףPU!ЭPS ݣkPРPްLSc,PPPTi7   ݤ82  ݬ
  kPРTPްSЭPckP֠X2XPЬTTSЬPSX	TXЬTЬP DT@TUЭPS ݣkPРPްLSckPРTPްSЭPckP֠X   P^aQ  [rK  Rޢ7nЬPРWЬVWZYkUޭTеTScdץX)PoS  PPЏBIO`ЭPЏREQ֥\խ2QX3ЭTХPްDS cPЭPZЭPY֦TЭP,XXPЬPԠЬQСDЬPРXSSDSHáDSkPРPРЬUХ@kPР0P֠ЬT֤xݬݤ@HP1 Ĥ ޭSQ(cQQץTQЭPS ݣkPРPްLSc*PPTY5   ݤ8	0  ݬ  kPРTPްSЭPckP֠X2XPޭSЬQU(cUUסT֡PЬTáDTP@PTTSЬPSX
TXPЬUЭPS ݣkPРPްLSckPРTPްSЭPckP֠X P0^MI  XԮZިInЬRТЬVЮYWO  TޭUдTSceפX*P?Q  PPRЏBIObЭRЏREQ֤\խ2QU2ЭSФR޲DR bPЭRYЭRW֦TЭR,UURRPЬSЮRУDЬRТXTTDTH£DTЮRTZRN  RТRޢSЮRcZЬRЮSТ@ZFѬ2ìTN  RТSƣT RRTRSPTSSPM  R ԮЬSM  RТRD[Ѯ1^ެоR[X1Lо _(   [SM  TQSPФ<SSSPSQPQP{SPPQQФ@VЮU[TЮQEfRPѢ8QѢDTТ<RRP1 78  PV1%M  RТPVSТ@YЮT[WРZоUգd գh գ\ գ` գl |||| (,У,(04У40U8WDWZPPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Di<SDiVWpZYhL  TޭUдTSce
פX)N  PPRЏBIObЭRЏREQ֤\                                                                                                                                                                                                                                                                           , $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 AT "            խ2QU2ЭSФR޲DR bPЭRZЭRY֧TЭR,UURRP[|Ц@xоRТXSS[SH	[StPK  PРRТtppK  PР0R֢оR֢x֮K  PРR[Ѯ
оR[X1ЬTԤZK  RТ0R֢ЬS֣xTݣ@HP$ä RRSz0   ݣ8*+  ЬRТRRYbU1 pWVigRRUTޭRS(bSSfRRפTS#ЭRS ݣJ  PРR޲LRb"ЬR¤ T  PTO2  J  PРTR޲SЭRcvJ  P֠XeU1jޭRЬTV(bVVפTЬR¤ WV#ЭRS ݣ+J  RТR޲LRb
T/  
J  RТTR޲SЭRcI  R֢X2XPЬS֣PЬRТUЬTãDTR@RTTSЬRSXTXPЬV ЭRS ݣI  RТR޲LRbI  RТTR޲SЭRcjI  R֢XХP | ^UI  VլPЬPP C  1 P?P8 fPݠ0WK  fRЏGSB0fPР0PЏGSBUcЬTdd   
fRdP@R
2NS$P8 `K  ЏFSB`ЏFSBdSSUPݬϜ PUPUUP ^H  R8 b\ݬ0J  b\ЏGSB0b\Ь0\ЏGSBP ^ЬP``   @H  R`P@R2NP8 `YJ  ЏFSB`ЏFSBdP ^H  RЬPРPP
	Pd   PЬPՠѠPЬQա4
bPѡ44PЬPՠDPЬQաH
bPѡH4PЬQbPРPѡ(СbQСPŠ4PǏd   PlbPՠlР4lЬQbPРPѡСbPѡ4 С4 bPѡD СD bPѡH СH P   ^G  Sc\̘ PRPc\Ь\޼H\ lѢ
 +       ^ЬPՠd _!  ЬPՠh O!  ЬPՠ\ ?!  ЬPՠ` /!  ЬPՠl !  ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q b    ^ЬQ޼RAbPѠ8ѠDР<PP ^@  nޭSЬRв`Qacעd)PG  PPЏTWE`ЭPЏTWE֢hխ2QPЭSЬRТPްDP `PТPPްQЭPa޼SТPްHP `PcP| `^D  V`?  Sޣ!ЬRТ8UեP1 ޭPfRв`Td`fPנd-PF  PPRЏTWEbЭRЏTWEfP֠hխ2QPЭTfPРR޲DR bPЭR$fPРR޲HR bЬRբP1 ޭPfRв`Td`
fPנd,WF  PPRЏTWEbЭRЏTWEfP֠hխ2QPЭTfPРR޲DR bPЬR޲4TЭRdfPРR޲HR bfQЬRС@UТLQAePAeTPPPRТ<dԢ8P<TР<P   ЬPՠdhQaԠdhQaP4  P ^1C  Rb\44hSb\ShLP_E  P\2QP \/E  ЏTWElЏTWEbP`b\֬dSb\ShP    ^ЬPՠd k  ЬPՠh [  ЬPՠ\ K  ЬPՠ` ;  ЬPՠl +  ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q n   ^ЬQ޼RAbPѠ8ѠDР<PP ^M<  RޢnޭTЬSг`Qadףd)PC  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP ^ޭSЬRвTQac
עX(C  PPЏBIO`ЭPЏREQ֢\խ2QPЭSЬRТR޲DR bPЭRЬЭRЬЬS֣TЭR,P0^Q@  X;  [ޫլѬ   hSЬRBU2NPѬ   2OPŤ 2XPŘ 2PPhPР0R֢֥lЬTФPѥTDЬSSRRXRXլSXShPР0R֢֥|Tݥ@LP2SPŠ 1 ޭRhPа`QabhPנd*A  PPЏTWE`ЭPЏTWEhP֠hխ2QPЭRhPРPްDP `PЭP,hPРPްHP `Ť 2XPŘ 2PPŠ 1ahPѠpl8 8PR(P RhPРPްLP`hP PRhRŜ ¨ ,  PRU#  ݬRhPРR޲LRbhSУxRRURQRPУ<RRRPRQPQ{RPPQQУPRbR1"У0R֢ ŀ ޭWhTޫޭPд`Sc`פd*PG@  PPRЏTWEbЭRЏTWE֤hխ2QV4ЭSФR޲DR bPФPR޲SЭRcФR޲HR bPgVVRRPhPР@VЮTЮPUSDfQPѡ8SѡDPС<QQWKݭ!  լѬXUݬݬWݬPRUݬWݬϩPRRPRPhRТPЭSТ@WЮTЮYРZUVգd   գh   գ\   գ` |  գl p  |||| (,У,(04У40V8YDYZPPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgլѬXUݬݬݭݬPRPUݬݭݬϘPRRPRPhPР@VЮTЮPUSDfQѡ8SѡDPС<QQ18 &  P1$hPР0R֢ ŀ ޭWhTޫnޭPд`Sc`פd*P=  PPRЏTWEbЭRЏTWE֤hխ2QV4ЭSФR޲DR bPФPR޲SЭRcФR޲HR bPgVVRRPhPР@VЮTЮPUSDfQPѡ8SѡDPС<QQWKݭo  լѬXUݬݬWݬ}PRUݬWݬA	PRRPRPhRТPЭSТ@WЮTЮYРZUVգd 8  գh ,  գ\    գ`   գl   |||| (,У,(04У40V8YDYZPPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgլѬXUݬݬݭݬϨPRPUݬݭݬ0PRRPRPhRТPЮSТ@WЮTЮYРZUVգd 3  գh '  գ\   գ`   գl   |||| (,У,(04У40V8YDYZPPPHTL|P|X|`|hԣp|xԣtÀ |È Ä Dg<SDgլѬXUݬݬݮ$ݬϣPRPUݬݮ ݬ,PRRPRPhPР0R֢֥tլѬXUݬݬݮ ݬ&PRUݬݮݬPRRPRP^E8  Z3  Vަ$nЬRТ[ЬT(RѤ(R1 դdԤdЬUХXWѬWEWD?WH9jRТRz  WP{PQP@PSWݮ S:  jRТ0R֢0Ő ЬRâDS@SR(RcSЬRSXSXѢX\ТX\ЬTդ\jR֢pЬSÜ \ЬPjRТ0R֢(ЬR ЬW[YXjTޭUдTSceפX+Ps9  PPRЏBIObЭRЏREQ֤\խ2QU2ЭSФR޲DR bPЭRYЭRX֧TЭR,UURRPjRТR޲HR bޭRЬTX(bXXפTդdԤdЬTĤ kXЭRS ݣjRТR޲LRb*RRT   ݤ8I  ݬKjRТTR޲SЭRcjR֢X2XPЬUХXWѬWIЬSWD?WH9jRТRz  WP{PQP@PTWݮ T7  jRТ0R֢0Ő ЬRâDS@SR(RcSЬRSXSXѢX\ТX\ЬTդ\jR֢pЬSÜ \XЭRS ݣjRТR޲LRbjRТTR޲SЭRcjR֢XЬP4^5  Z/  Wާ:nЬRТЬSѬDcЬVѣDXjRТRѬJRЮT(R@RRXRXѦX\ЦX\jR֢pЬTĜ ЬS\ЬPЬUЬXШXRUR1ЬSRD	RH1У@TãDU[[ T6  £DU@URЮS(RejSУxRRXYXYRQRPУ<RRRPRQPQP{RPPQQУ@QЮPYTXS@aVPѦ8SѦDTЦ<VVU1ЬTjRТRz  XP{PQP@PSäXH[[[ S5  ЬTXѤX\ФX\jR֢pĜ ЬS\jRТ0R֢0Đ ЬPЬUХXVѬV;ЬTjRТRz  VP{PQP@PSV[[ Sd5  jRТ0R֢0Ő ЬRRVpYXjTޭUдTSceפX+P;5  PPRЏBIObЭRЏREQ֤\խ2QU2ЭSФR޲DR bPЭRYЭRX֦TЭR,UURRPЬTФD|ЬRТXSSDSHäDStjRТRТtЬSУ@xpjRТ0R֢ЬT֤xݤ@HPЬVæDS@SRЮT(RcޭRU(bUUצTSЬRSXSXѢX\ТX\jR֢pЬTĜ ЬS\UЭRS ݣjRТR޲LRbjRТTR޲SЭRcjRX  P ^m1  V6,  SޣMnЬR  fPР0P֠, ЬRТ[ЬP(QѠ(Q1}PW[ZYfUޭPеTTd`ץX+PO3  PPRЏBIObЭRЏREQ֥\խ2QX2ЭTХR޲DR bPЭRZЭRY֧TЭR,XXRRPfPРR޲HR bޭRЬTW(bWWfPРTR޲UЭRefP֠XפTWդT 
  ЬR¤ 1 PPRy   ݢ8)  ݬ+ެUeR  (GT  RdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(2XPЬPѬD
ѬHԮЬUХXWЬXЬTfPРRz  XP{PQP@PRåXHPPݮ R1  դ\fP֠pŜ \դdԤdեP1 ޭUfRв`TdefPנd+W1  PPRЏTWEbЭRЏTWEfP֠hխ2QPЭTfPРR޲DR bPЬR޲$TЭRdfPРR޲HR bЬRPPR  ݢ8  WݬެWgUU ծ1 ЬTԫfPРxQQQРRQTݥ@LPZŤ Š (DTgRdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(2SPެUeR  (DTeRdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(PP8^y-  VB(  SޣinЬR  fPР0P֠, ЬRТ[ЬPPWpZYfUޭPеTTd`ץX+Pg/  PPRЏBIObЭRЏREQ֥\խ2QX2ЭTХR޲DR bPЭRZЭRY֧TЭR,XXRRPЬQСD|ЬRТXRRDRHáDRtfPРRТtЬTФ@xpfPР0P֠ЬP֠xݠ@HPޭRW(bWWפTfPРTR޲UЭRefP֠XWդTP   GPdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(2XPЬPѬD
ѬHԮЬTФXWЬXЬUfPРRz  XP{PQP@PRäXHPPݮ R-  ե\fP֠pĜ \PPT  ݤ8J  ЬRբP1 ޭUfRв`TdefPנd-PW-  PPRЏTWEbЭRЏTWEfP֠hխ2QPЭTfPРR޲DR bPЬR޲$TЭRdfPРR޲HR bWݬЬTT&ծ1 fPР0P֠4Ĕ ЬUԫfPРxQQQРRQUݤ@LP1 Ĥ Ġ PPT   ݤ87
                                                                                                                                                                                                                                                                            f $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 p "     /        ޭUެWgR(eDTgRdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(2XPެUeR  (DTeRdPP ЭPݠfPРPްLP`fPР`PްQЭPafP֠d(PP\^c)  X,$  Uł nhRҢxSҬTTSTТRTSSSTYY1b ZZYShTQSPФ<SSSPSQPQ{SPPQQ[Ф@W[TYQZSDgRѢ8SѢDQТ<RRV1 զP1 ޭThRв`ScdhPנd-P*  PPRЏTWEbЭRЏTWEhP֠hխ2QPЭShPРR޲DR bPЭR4hPРR޲HR bhQVRС@TТLQAdPAdSPPPRТ<cԢ8P<SР<P   զdhP`ԦdhP`Vx  hPРRYY1P ^ޭSЬRвTQac
עX()  PPЏBIO`ЭPЏREQ֢\խ2QPЭSЬRТR޲DR bPЭRЬЭRЬЬS֣TЭR,P ^)'  Rb\44\Sb\S\LPW)  P\2QP \')  ЏBIOlЏREQbPTb\֬XSb\S\P   < ^&  UTլ
Ѭ   
2NT\PeQЬP@S~S[P2NT5ѣT
2NT$PØ TPà TP,(  T1 Ø 0ePנ,ѣT"ݬ  ݬ  PTä 2XTУDRePB$QaSaPaP<QaSaPaSPPУ<aԣ<P,(  SQС8RTePР<ePQePBTPP  ^P  ^2 P ^q%  SЬPР8RЬQTcPР<cPQcPB   ^P`P    ^-%  Sc\̠ PRPc\Ь\޼H\ lѢ P       ^ЬPՠd ЬPՠh wЬPՠ\ gЬPՠ` WЬPՠl GЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q  ^ЬQ޼RAbPѠ8ѠDР<PP ^1  RޢnޭTЬSг`Qadףd)P%  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP ,^"  VfSЬRBTդP~ޭUг`ScefRעd-P%  PPRЏTWEbЭRЏTWEfR֢hխ2QPЭSfRТR޲DR bPЭR$fRТR޲HR bRѤRPU1 2 WfPנpĜ gRRЭRԢ\ЭR֢XЭRբl ЭRlЭR ЭPРD ЭPР@ ЭQѤXDѤXHáDX fPРRТ ЭR eЭR UfPР0R֢֤|fP֠|1Tԭ쟭ݤ@LPĤ ЭU1 < WgRRUЭRԢlЭRעXЭRPTPXPjբdЭRԢdfQЭRС@TТLQAdPAdSPPPRТ<cԢ8P<SР<P ޭSЭRcݭ  
P fPנ|eU1[fRբ|[ޭTТLRdM2 TdRR ЭRݢfPРR޲LRbfPР`R޲SЭRcfP֠dޭQfPРLRaP  ^լѬ   V   QЬP@Q2NP 2XP 2PP PѡTPPPPQU   ݬ   P | $^  UePЬRBSØ Pà 	լPRѣRPT1  VfPPЭPԠ`ЭP֠XЭPlЭP ЭPРD ЭPР@ ЭQѣXDѣXH
áDX PePРPР ЭP dЭP TeP֠|ePР0P֠֣|1lԭ֣Pݣ@LPä ЭRN< TdPPRЭPԠlЭPנXЭPPTQXQՠ\ՠlՠ`	Pf  ePנ|bRףP; 4 ЭRݢeRТR޲LRbeRТ`R޲SЭRceR֢deRբ|ZޭTвLScdM2 ScPP ЭPݠePРPްLRbePР`PްRЭPbeP֠dޭQePаLP`aP  ^լլPЬPP  - 5?Pݬ-PR#ݬ PRPݬDPRPRRP ^  S0 ЬRR  cPР0PРbcPР0PРcPР0PРcPР0PРcPР0PРcPР0PРcPР0PР cPР0PР$cPР0PР( cPР0PР,$cPР0PР0(cPР0PР4,P ^4 ЬRR
  bb     QbP@S2NPЬRУhУlУpУtУxУ|À Ä  È $Ì (Ð ,Ô 0P ^Y  ST~ ЬRR}  cPаbcPРPРcPРPРcPРPРcPРPРcPРPРcPР,cPР4cPРd cPРh$cPРl(cPРp,cPР|0cP 4cP 8cP <cP @cP DcP HcP LcP PP   ^q  SޭRcPаPQab8ݬЭPݠcPРPްLP`cPР`PްRЭPbcP֠dcRЬQDhP< ^	  Ue\Ь,SЬ(\lRR\P0Td\\RS \\  
ݢ8TТ0Re\R(SP   | ^  VլPЬRSSPЬRТS2 UePPSգ`6գl1fPנpЬQ ޭRTbTTԣ\ `TУSЬPPSPP   ^ЬPՠd ЬPՠh ЬPՠ\ ЬPՠ` ЬPՠl ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q  ^ЬQ޼RAbPѠ8ѠDР<PP ^  RޢnޭTЬSг`Qadףd)P  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP| ^9  V^  SޣޭTfRвLP`d1 fPЬRР@UТLP@eQ@eTQPQRТ<dԢ8P<TС<Q ޭTЬPdPЭRݢfPРR޲LRbfPР`R޲TЭRdfP֠dPޭPfRвPTd`1 fPЬRР@UТLP@eQ@eTQQRТ<dԢ8P<TС<Q ޭTЬPdPЭRݢfPРR޲LRbfPР`R޲TЭRdfP֠dPЬRբd fPРHRЬPdP    ^ЬPՠd {ЬPՠh kЬPՠ\ [ЬPՠ` KЬPՠl ;ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q ~ ^ЬQ޼RAbPѠ8ѠDР<PP ^  RޢnޭTЬSг`Qadףd)P  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP(^  TB  ZYުޭUdRвDSce`ЭRԢhЭRբd oЭRբh _ЭRբ\ OЭRբ` ?ЭRբl /ЭPޭUdRвHSce1 ЭRԢddSЭRУ@WТLSCgUCgVUURТ<fԢ8P<VХ<U ޭSЭRcЭRբd ЭRբh ЭRբ\ ЭRբ` ЭRբl sЭPԮdRѮ¤ 1V  XIWNdRТ,[Т(RbSSRP0   RRS[Ø 1_RR1Rà 1Id\̠ fPU1 PޭRd\м`P`bd\׬d'hPP\ЏTWElЭ\ЏTWEd\֬hխ gЭRd\Ь\޼D\ lPd\ЬL\޼RЭ\bYd\Ь\޼H\ lPUЭ\լd AЭ\լh 1Э\լ\ !Э\լ` Э\լl ЭPd\̠ fPU1Y&YØ 
RRUd\̠ У0SSݣ8Ud\ЬR޲LRbУ0SdRS([1{բ|֮dRѮ¤ 1EdRբ|1 ޭUв`Sce
dRעd,  PPRЏTWEbЭRЏTWEdR֢hխ !ЭSdRТR޲DR bPdRТLR޲SЭRcdRТR޲HR bPPRQբd ЭRբh ЭRբ\ ЭRբ` ЭRբl ЭPP  ^ЬPՠd wЬPՠh gЬPՠ\ WЬPՠ` GЬPՠl 7ЬQ|||| (,С,(04С40ЬTT8ЬDRRRHЬL|P|X|`|hԡp|xԡt |  ЬRЬP@b<Q@b < ^ެUeRЬSТLP@cQ@cTQQeЬPР<dԠ8<TС<Q z ^ЬQ޼RAbPѠ8ѠDР<PP ^  RޢnޭTЬSг`Qadףd)P  PPЏTWE`ЭPЏTWE֣hխ2QPЭTЬSУPްDP `PУPPްQЭPa޼TУPްHP `PdP ^  VfSЬRBUp2 WgRRfQЭRС@TТLQAdPAdSPPPRТ<cԢ8P<SР<P GЭRբdЭRԢdݭ   P  ^Y  SЬPՠdՠh
ՠ\ՠ` ޭRcPаLQab9ݬЭPݠcPРPްLP`cPР`PްRЭPbcP֠dPޭRcPаPQab9ݬЭPݠcPРPްLP`cPР`PްRЭPbcP֠dPcRЬQDhP                                                                                                                                                                                                                                                                                                                                                                           PWNC_CACHE PWVN$UNIQUE_CONFIG_ID PWVN$CACHE_CONFIG_FLAGS TRUE PWVN$CACHE_DISABLE PWVN$CACHE_ENABLE_OVERRIDES PWVN$CACHE_NONCACHESIZE PWVN$CACHE_READ_AHEAD_BUFFERS PWVN$CACHE_PERIOD_FLUSH_THREADS PWVN$CACHE_FILE_FLUSH_THREADS PWVN$CACHE_THRESH_FLUSH_THREADS PWVN$CACHE_MAX_FLUSH_PASSES PWVN$CACHE_DIRTY_BUFS_PER_FILE PWVN$CACHE_LOCK_BUFFERS PWVN$CACHE_LOCK_STRUCTURES PWVN$CACHE_INUSE PWNC_UTL LNM$PROCESS_TABLE LNM$JOB LNM$SYSTEM_TABLE LNM$FILE_DEV 
we: %X flink: %X blink: %X bdsc: %X param: %X
 bdsc: %X flink: %X bufadr: %X offset: %X count %X
 DATA STRUCTURE SIZES
 CALLVECTOR_T (Q): %d
 DS_TAG_T: %d
 BIOREQ_T: %d
 FSB_T (Q): %d
 GSB_T (Q): %d
 CFDSC_T (Q): %d
 BCB_T (Q): %d
 THRDSC_T (Q): %d
 THRTBLDSC_T (Q): %d
 TWE_T : %d
 GCCB_T (Q) : %d
 OVERRIDE_T : %d
 BDSC_T : %d
 WE_T : %d
 GLOBAL_COUNTERS_T : %d
  PWNC_UTL_MEM block is bad blocks were bad   PWNC_INIT %PWNC-E-BCBQINSERR, error inserting BCB on queue PWNC_CACHE_CTRL_MEMORY PWVN$CACHE: buffersize =  %d
 PWVN$CACHE: cachesize = %d
 PWVN$CACHE: dirty_buffer                                                                                                                                                                                                                                                                           E $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 M "     @       _ratio = %d
 PWVN$CACHE: flush_interval = %d
 PWVN$CACHE: num_cache_buffers = %d
 PWVN$CACHE: dirty_buf_max =  %d
 PWVN$CACHE: num_read_ahead_buffers = %d
 PWVN$CACHE: num_thresh_flush_thr = %d
 PWVN$CACHE: num_file_flush_thr = %d
 PWVN$CACHE: max_flush_passes = %d
 PWVN$CACHE: dirty_bufs_per_file = %d
 PWVN$CACHE: lock_buffers = %d
 PWVN$CACHE: lock_structures = %d
   PWNC_OPEN   periodic_flush_thread   PWNC_RELEASE wait_for_bcb pwnc_release  PWNC_THRTBL pwnc_thrtbl_create pwnc_thrtbl_register pwnc_thrtbl_get_avail_thr pwnc_thrtbl_make_avail_thr pwnc_thrtbl_shutdown   PWNC_READ wait_for_bcb read_cache read_existing_buffer read_fresh_buffer read_fresh_buffer_rah  threshold_flush_thread  wait_for_bcb PWNC_TOSS_BUF_IOERR toss_buffer_ioerr  PWNC_INIT   PWNC_WRITE wait_for_bcb write_cache write_existing_buffer write_fresh_buffer truncate_to_existing_buffer truncate_to_fresh_buffer toss_buffers_for_truncate PWNC_INIT   PWNC_CLOSE  file_flush_thread   PWNC_FINAL_FLUSH wait_for_bcb final_flush   flush_cache_buffers PWNC_FLUSH_FILE flush_file  PWNC_GIVE_BUF_AWAY  make_flush_pass move_dirty2flush    PWNC_PLACE_BUF wait_for_bcb place_buffer    PWNC_FINDBUFFER wait_for_bcb pwnc_find_a_buffer PWNC_TOSS_ALL_BUFS wait_for_bcb PWNC_TOSS_BUF    x                                                                                                                                                                                                                                                                                                                                                          y  0{                  \{                                                                                                                                                                                                                                                                                                                                                      t}  }  }  }  }  }  }  ~  )~  @~  ~  ~  ~  ~                     0  @  T      Ѐ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @  @                                                            t  ,            P  0  (               
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                 !         <  @  T              ă  ȃ  ̃  Ѓ  ԃ  ؃  ܃                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
PWNC_CACHE P  PWNC_InitCache   PWNC_InitCache_1       PWNC_InitCache_2       PWNC_InitCache_24   PWNC_InitCache_11     W      PWNC_InitCache_3       PWNC_InitCache_25 _  PWNC_InitCache_12           PWNC_InitCache_4       PWNC_InitCache_5       PWNC_InitCache_26   PWNC_InitCache_18       PWNC_InitCache_19 	      PWNC_InitCache_20     v    "  PWNC_InitCache_6     8  PWNC_InitCache_7 8  PWNC_InitCache_27 X  PWNC_InitCache_21     j  PWNC_InitCache_22     t  PWNC_InitCache_23     A      PWNC_InitCache_8 	    R    >     PWNC_UnloadCache   PWNC_UnloadCache_9 	      PWNC_UnloadCache_28   PWNC_UnloadCache_21       PWNC_UnloadCache_22 
      PWNC_UnloadCache_23     F    	  PWNC_UnloadCache_10 	       "   pwnc___set_unique_config_id% k  pwnc___set_unique_config_id_11     s   $   pwnc___set_cache_config_flags'    pwnc___set_cache_config_flags_12        ! (  pwnc___set_override_params$    pwnc___set_override_params_13$ h  pwnc___set_override_params_14$ }  pwnc___set_override_params_15$ }  pwnc___set_override_params_16    $   pwnc___set_override_params_17 "    )    >          $   pwnc___mark_init_cache_called'    pwnc___mark_init_cache_called_18    ' 6   pwnc___mark_init_cache_called_19 
   ' D   pwnc___mark_init_cache_called_20        & T  pwnc___mark_init_cache_callable)   "pwnc___mark_init_cache_callable_21    )   "pwnc___mark_init_cache_callable_22 
   )   "pwnc___mark_init_cache_callable_23     R   		P                       G

     K   	  A    	 
 ] -     $  	
     
     M          W    	            PWNC_UTL   utl_bdsc_alloc   utl_bdsc_alloc_1 	  utl_bdsc_alloc_2     .    7	  utl_bdsc_alloc_3 7	  utl_bdsc_alloc_46 J	  utl_bdsc_alloc_4 N	  utl_bdsc_alloc_5     ^	  utl_bdsc_alloc_6 ^	  utl_bdsc_alloc_7 
        $    p	  utl_bdsc_alloc_8 	    E    E        	  
utl_bdsc_free 	  utl_bdsc_free_4 	  utl_bdsc_free_5 	  utl_bdsc_free_47 	  utl_bdsc_free_4 	  utl_bdsc_free_5     	  utl_bdsc_free_6 	  utl_bdsc_free_7 
        $    	  utl_bdsc_free_8 	    G    G    	  utl_bdsc_free_6 	  utl_bdsc_free_7 
        a    	  utl_bdsc_free_8 	       # 
  utl_compute_num_hash_entries& 
  utl_compute_num_hash_entries_48& @
  utl_compute_num_hash_entries_38     N   & o
  utl_compute_num_hash_entries_49& 
  utl_compute_num_hash_entries_38     Q        
  
utl_getsyi 
  utl_getsyi_9     ?      utl_lock_ex W  utl_lock_ex_10 m  utl_lock_ex_50 |  
utl_lock_ex_9     E    l      utl_lock_ex_11           utl_probe_for_read '    ,  utl_probe_for_write '    T  utl_que_ins |  utl_que_ins_12 |  utl_que_ins_13 %      utl_que_ins_14 "      utl_que_ins_15     O    {      utl_que_rem   utl_que_rem_16   utl_que_rem_17   utl_que_rem_18     
  utl_que_rem_19     (
  utl_que_rem_20     ;    U    <
  utl_que_rem_21     r    D
  
utl_trnlnm 
  
utl_trnlnm_22     
  
utl_trnlnm_23       
utl_trnlnm_24           
utl_unlock $  
utl_unlock_25 6  
utl_unlock_26         .    D  utl_we_alloc W  utl_we_alloc_27 
    4    x  utl_we_free   utl_we_free_28   utl_we_free_29   utl_we_free_30 	              utl_we_free_31 	    5      utl_we_and_bdsc_free   utl_we_and_bdsc_free_32   utl_we_and_bdsc_free_33   utl_we_and_bdsc_free_51   utl_we_and_bdsc_free_4   utl_we_and_bdsc_free_5       utl_we_and_bdsc_free_6   utl_we_and_bdsc_free_7 
        $      utl_we_and_bdsc_free_8 	    H    H      utl_we_and_bdsc_free_34   utl_we_and_bdsc_free_52 +  utl_we_and_bdsc_free_28 0  utl_we_and_bdsc_free_29 0  utl_we_and_bdsc_free_30 	            @  utl_we_and_bdsc_free_31 	    0    0    P  utl_we_and_bdsc_free_35         X  utl_we_and_bdsc_free_36 	        h  utl_count_bdscs !      utl_dump_bdscs   utl_dump_bdscs_37     X      utl___is_prime   utl___is_prime_38     `    D  utl___validate_abs_queue" X  utl___validate_abs_queue_39" j  utl___validate_abs_queue_40" l  utl___validate_abs_queue_41    " x  utl___validate_abs_queue_42    "   utl___validate_abs_queue_43     "   "   utl___validate                                                                                                                                                                                                                                                                           1{N $      PWRKV50F1050.F                  	                           	ubz1                                                                                                 ^$   $                         Z     %       d&N:/fdC[?&u!T6cu#XSޞ9̱t"613E	B~?7⫋p=!NN7 ڽn"N89qd[XOvlQţoMn> x`5S@ 9re܌9("e.z =K(,d%_[tW(zb`9覩$=hly7T/XAbϫl5-Sb
y]1Ǽy)
W<ET;^+1
,VM1bkKkcȶhӺgLi{p>_pZB0F@%0?"at!xWNU dsw=!XKY.Y&!+hf3ȦLEG-W_y>sr|Te}o%,Ǝa%m8,Uh+#˻u>:!;Dde&;Y\RChrto98U; HiWM͋'VtZf-q	1!w>,	t؏0c3;ceGRkϭr>l@kO fx.BAGR	;dh=ZQMv$<yiQ89o<d^(iۙ/I,Jl& _^lqp9W߆֌MǴĹk9P`
2AV1Xv7ЌgFR_!	9Y6,|\fĉ"H=q\9N,9W>Χ7=,HJ %l* bQ q19YfnȌ\X>ڰQ愘F&:BߊN۵Ǣ<ǜb,gN]^>ÍpV )s⢤
[샇NY374Q
9&{܅O秫޵\(G/7&(TdME::^bt18Kr%1o\M2]@-+b̒IZ_zew4jC+I$ʇE +$IP$F0x 9#7o*+̨#s>z;eXkbdb)4FGAXd.
E
<=|d?ưVQDq>`9fö98hr3$WJOK<8:ጊZ14KIw %ѩJA
d	زG(¡v5Dm[|(k([W>`O@*0rpM޼δ/CRTH1gM/ 
li]	6 [o$7d$FQrRӌ5HyظWXX=1**Ll-?m
[ጵ85kQGo!yHmtoeeIjDhdѰ%슘O*ӦI:X,
PR=T5-0qK5nGmk׍~$n#:a~V*G'p8?lHa8QSAl1yQe8.x;2c 1-=p$d"][R'70CK9[-º \% 0|.L{Q[>,Sؤ0LFka$RnTo,A	&K=x_~6Rp)&zų:ܺhlQqHWkit("<c}|BfowQAU
9{":x6Ew-ZS3Dˎ9&\LRƚRcMg{~qܳSy8Qof[nAۜDM$Rt]L [mi`{-FBJz{VM3^n㟥Dg:46L&`$5?ZW1x@
yS"|yY\o)[Fc`FŒK>'+OKIq$	MJ2<c%kXwQ}U$	YAVvMOxZT
shFUeuYRv
lI,%
8<po+e4%迹E63k%.Ơ%OhF7^~?
cy╰FObw+dtC5C<	3 YA.@ŉ7-Udjgޏ*OCr[8CE;؆3p| vw	2Ö+HaG%-4
%6:{f(A^ $t[eiP{gHҬX<T\	p#J4
B0q4uVW#X&IglY
򐝟d.&h`;j
plv/>2"0Nǖ/y;Wsǚm^9/"\ܪCku(\
q։$:/eZbg
3LN`
X
0#.Bذ5Q`Ǝ|$e4^!_ͥL`9zL[&MX8``eUE
I~\E54p,ʊXAOE&CB.H
:sOcZ6&q2C'xCDt?h(Gv[%!O년iyH¦(p	.Raž!:6<Q ocޕxOw1JuP{{lt
Ϩ"#cBQ拃
kYE)SFama{Zc!
~}?s\DIO/	"dp4ipXg.	W鮦=qDRq'wAr4]HȠdVNGD#C&3^}2D2D~8ĘD
 䇿p띓:&f>F}cՋ*Z5 
cH"c"|NV~&xLBnFT9Sʀߵ.tY挿wgF^$0}5O'	<-.ks'w<T{t|w!LP7_%p~ќ Tɕ`48rT/UlK>=/p~V͞>k:mvI9o?5A_!ie=.BmP4|$M(3Eܵ1:Iw[5O~ߝ	̂ &(}t)4nqCn:HW90>5Ug=.YrkAm\5	N:Gu\7n(	s;)N}.0Wr)k:/7o;.%гt#Ɩ9̷<!ږ5-=0<oxnX'Zj<c;9zD`;`IbZ:͝MoYג_Te:t鯳_fuE/))W)5%Ǆ/GLPd&=rN/u(uSPY^Sܵ%r7ZL/0&v/ J~ɐ u2-P$rWCKhڦ.Y5chGJa{%y7g32Y4<aqVo~gÝXL$Вs9 hΆu;t0^ `#&ֺ[`Y&_;s_IjbHGTg$Ƣ5Hk<CJNW;d wD'=t|_R;fsW#9e\\c
L4v.N]rk_NZu*c9{EG%3Иw.d+0]x?[~ g,|jSٶ,uY8^ISt)wM_[5*t2c/	M^oBt@d̙cmZlE?S3RC#_8CD:Zhh,8ʝZLHHL=O
"/AO0wo*5*pAł=2RB*szh)=c.
'0V\[s.J/k֭gq.fģf*7	 ꯪLXjL8s[IFvd`xdЅk`W:GS
WW7qck=A|N QwAd:GwiI|3EefxcӧȑJ?{_YHSgtJf!JuZRs0Q"mTu'I6J+!qz.*ʁC2*o	Rd8n;^3!?5QW(|Dd^XA";Y=%1oF=ԶXQN},x7r;g`A%$#Kf_c~.~ VQꝲU=e3z"!~HmG6bWьL]8-fVqJ$>pI mv>hlEYޜ0+״cDD(tf&8WX^ؼlhw&- [VO(K	8z24.
ټn!bgN'B[Iud$PH ʐt_O
!^JBL26I9*f*'+ZMzIM׋VCPs!^P>B:FW7hGtُ%{0f)A\qŢ"@!y蹮HC,V[v>UeV0~Q!_CJAQ	0@F,{񚐕 Tx)gnk7"5䴵J`o)\C	((ęҌsr1t]Ȥwc<˷SK{E~;ޫEvW2c1]z4̚_6&Y9Bn[6Ŵ}}Bj;Ab+KK;u~<dnp(:hi'P*$vI	>6 bX;+{~fȗv wkz\H7ѭuVSRYٕu`h*XpȐ+G4∈ZV"61ʥK[u
1s 4kŒ.OTGm(Pn<O9\Ef'}bGL%Z*}izϴ}xAn#:9zv	0R]0Kb*E->&
j俵|U$뒬
[^4+byu *wWlCl[>l䩪ʞhZ;褅@/<2
ʟ`7d#"^=w:?y~}v]+ז;HKs1\"G҄8[:zb/Ѧi~9xp,>Ƿ#!dmZ/s>ߧ9oederLn+@'jVAQJ_~3fb)#N7WKH#i$V٘\X[,0Z%o5{
aQ
JMvKj&|DK)G).|K9JoTս"28C4л;Y9"[qH^p]6Qʜl63iF3J\h+vh>.S'JVC$>RʪDr¨Gp[( t2ERa:o}@)'j2r*.ofҤQ7Nu#gI, ?d[
|{ޖDLO
?ƾU`.xd,_C
½m~
u;Hc}3VGtv-%H<FېZx/EW^(IGu `krӺČA9x>WHz<RpU?n뫽~#iW1̆#Zx`_](\	gdr7<(08ZnGw4q,ݳrPË&ieL,u|F)ˁ`&ɦK=Dj$x+?:Nպ
ES+F	 
2sM"6S&~>Rw$pcY$=)-<`v^h8>16^S/U'+huT9OPk9`õZPA<ݐg|4	JG</ϪibQ_mEz
? +,}|X!W6]}.Hbm?n;xf:x$IpWB.h$	;4.m̏V c;G+[|18n$kJD4jQQXIKZKɀ&,} T/EyNcz6Kӈ}jnRNA*|Aj}3t.ԳUXJM`/W5/w(G|WqmCcgK֥sWp+ֳ1tepݮlWC֟ĕw̺ļyƼ*vc# 8=7]lXl_ZVW +d9\gI~L{^5|	䦄9a#RX%@WKT?;:lTiۇX߽7Ba2ИSlJH6snE%^l[[]m()v]DyhV:4Ԕ'n2ԕ"$=#ء@*ʪ_vޭ!^RڀL?[*[GY#Ts@G}v,1sꃪ[Ps[
6e),f؛AJSaw߭DgٷjUhFˌ<	a^1RbȄ%lú#llGs5Gq4"LtK9wK>#|.7}LIxFXAl!>3:<tUu#uQ!p"ig#.V]9SBR!(ݖVh`{Oɯ:tŪo%"ZA(vC[H5i/&&i#ꏺtaj''vlKT4?kۢ;5+|ҩO'w;_U<
j~	bշU2rV:ts@N%
8S94XKER~֭_+g-`ǀYiŇPYSo^k{gvÒ[32uByNcp,F`	o)K wj[Mj|%_c5k㓧TF*W;szT]*fĜ7Y>x*Zyl̟7'%	l]sT5k-.5$+G݉t}Gu
4Cr5֍p	zƨs)SJmh1۞բR)#;$"KWѾNZQ.ʏ|.0/*LkZ'|%
ыsgYylcŗULLfRU~q,`U9-`ڙAwyN/Z Ǹd
F'כT/'e(ia6a(,[hxoMEB:*?Ž։Ղ31$~tf,.dssNjF-{,xE&W^XGTWJRŁAR{|ڼ2CqӬ\*/;VyDSϓPb_[o(F[ 2wBS7TKV sG#N"@0nIGiAQi&п$բIC=KfV씫	%JV6Y1.Ps-m9
h)Y	\nE};oj.a#j=lL(l78kHX:Z}$`'tna!=28JhʫQ oNg#l\m)ZfGd"$n:0NÓ8-b3ͭ(E
 W)817]k(gjuRQAFf&p0KဝlM(]"dm%5/<.a;s9McOqLB](6ښ{(kqeZ[5:h
b(	-ÃCF?
v6+SX']z?_{:.բ^LPXPCsh+A                                                                                                                                                                                                                                                                           Gb $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 > "     Q       _abs_queue_44"   utl___validate_abs_queue_45     >              utl_dump_ds_sizes    		!         : 
	        6 ? 
 
C
       	
 	  ?   ?   C	          O		               L	     :	  	    :  5 
  ǹ    9           C  =                     PWNC_UTL_MEM   utl_mem_tracked_alloc   utl_mem_tracked_alloc_1    utl_mem_tracked_alloc_2     (  utl_mem_tracked_alloc_3 	    x        L  utl_mem_tracked_free     \  utl_mem_report     p  utl_mem_check_links '   		  o 	        6 	 x 6  ; 7   '     	PWNC_INIT   queue_bioreq_to_bcb   queue_bioreq_to_bcb_1   queue_bioreq_to_bcb_2       queue_bioreq_to_bcb_3     B        (  init_configure_cache l  init_configure_cache_4 l  init_configure_cache_5   init_configure_cache_6   init_configure_cache_7 	      init_configure_cache_8 	    J      init_configure_cache_9       init_configure_cache_10     1  init_configure_cache_11     M  init_configure_cache_12     i  init_configure_cache_13             init_configure_cache_14 x  init_configure_cache_15       init_configure_cache_16   init_configure_cache_54   init_configure_cache_50   init_configure_cache_51 
    
            T  init_configure_cache_17     l  init_configure_cache_18 w  init_configure_cache_19           init_configure_cache_20     \  init_configure_cache_21 (      init_configure_cache_22       init_configure_cache_23   init_configure_cache_24       init_configure_cache_25     &  init_configure_cache_26 
    8  init_configure_cache_27           init_configure_cache_28       init_configure_cache_29       init_configure_cache_30   init_configure_cache_31     m       	   0  init_cache_unload b  init_cache_unload_32 d  init_cache_unload_33      d  init_cache_unload_34 p  init_cache_unload_35     <      init_cache_unload_36        init_cache_unload_37        init_cache_unload_38   init_cache_unload_55   init_cache_unload_52   init_cache_unload_53 
    
               init_cache_unload_39   init_cache_unload_56   init_cache_unload_50   init_cache_unload_51 
    
              init_cache_unload_40       init_cache_unload_41 	           %   init___alloc_cache_ctrl_memory( D  !init___alloc_cache_ctrl_memory_42 %   ( y  !init___alloc_cache_ctrl_memory_43(   !init___alloc_cache_ctrl_memory_44     1   (   !init___alloc_cache_ctrl_memory_45            init___alloc_cache_memory#   init___alloc_cache_memory_46 %   # :  init___alloc_cache_memory_47# H  init___alloc_cache_memory_48         # L  init___alloc_cache_memory_49        $ X  init___free_cache_ctrl_memory' e   init___free_cache_ctrl_memory_50' e   init___free_cache_ctrl_memory_51 	            t  init___free_cache_memory"   init___free_cache_memory_52"   init___free_cache_memory_53 	              log_cache_configuration    		:     6   
  y 	 	               
 !           	  	     	    
 	  
           
         <  
   
                     ֹ  [        	    O            <  B       	PWNC_OPEN 8  open_cache_file a  open_cache_file_1 a  open_cache_file_2 t  open_cache_file_3 {  open_cache_file_4       open_cache_file_5           open_cache_file_6       open_cache_file_7       open_cache_file_8       open_cache_file_9       open_cache_file_10               open_cache_file_11   open_cache_file_19 	   open_cache_file_20      -    *   open_cache_file_12     9   open_cache_file_13     H   open_cache_file_14     W   open_cache_file_15     f   open_cache_file_16        open_cache_file_17        open_cache_file_18               open___assign_cache_fd        open___alloc_cfdsc !  open___alloc_cfdsc_21      :   		V8   

  
                          NG      PWNC_PFLUSH_THR 0!  periodic_flush_thread \!  periodic_flush_thread_1 (    c   		_0!  % 
     PWNC_RELEASE !  insert_to_bcb_hash_tbl     d"  remove_from_bcb_hash_tbl! "  remove_from_bcb_hash_tbl_1! "  remove_from_bcb_hash_tbl_2         C    "  
bcb_lookup )    "  wait_for_bcb "  wait_for_bcb_3 "  wait_for_bcb_4     #  wait_for_bcb_5     C        p#  pwnc_release #  pwnc_release_6     #  pwnc_release_7     #  pwnc_release_8 #  pwnc_release_9 
        $  pwnc_release_16 )    ;$  pwnc_release_10     `$  pwnc_release_11 s$  pwnc_release_12 y$  pwnc_release_13     $  pwnc_release_14     A    $  pwnc_release_15 	    a    U  		!  ڹ 	          	 *      	   
             PWNC_THRTBL $  pwnc_thrtbl_create $  pwnc_thrtbl_create_1 	%  pwnc_thrtbl_create_2         O    %  pwnc_thrtbl_register 8%  pwnc_thrtbl_register_3 F%  pwnc_thrtbl_register_4 0    >    l     %  pwnc_thrtbl_get_avail_thr" %  pwnc_thrtbl_get_avail_thr_5" %  pwnc_thrtbl_get_avail_thr_6     ?    e   ! %  pwnc_thrtbl_make_avail_thr# &  pwnc_thrtbl_make_avail_thr_7# 1&  pwnc_thrtbl_make_avail_thr_8     A    h    T&  pwnc_thrtbl_shutdown t&  pwnc_thrtbl_shutdown_9 &  pwnc_thrtbl_shutdown_10 &  pwnc_thrtbl_shutdown_11 &  pwnc_thrtbl_shutdown_12     &  pwnc_thrtbl_shutdown_13     9    &  pwnc_thrtbl_shutdown_14     &  pwnc_thrtbl_shutdown_15      &  pwnc_thrtbl_shutdown_16      W    &  pwnc_thrtbl_shutdown_17            		$       %        "   #  	                           	PWNC_READ  '  insert_to_bcb_hash_tbl     '  remove_from_bcb_hash_tbl! '  remove_from_bcb_hash_tbl_1! '  remove_from_bcb_hash_tbl_2         C    (  
bcb_lookup )    @(  wait_for_bcb P(  wait_for_bcb_3 a(  wait_for_bcb_4     }(  wait_for_bcb_5     C        (  queue_bioreq_to_bcb (  queue_bioreq_to_bcb_6 (  queue_bioreq_to_bcb_7     
)  queue_bioreq_to_bcb_8     B        l)  
read_cache )  read_cache_9     )  
read_cache_10     )  
read_cache_11     )  
read_cache_12     )  
read_cache_13     )  
read_cache_14 *  
read_cache_15 *  
read_cache_16                                                                                                                                                                                                                                                                                   2 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 2 "     b        \*  
read_cache_17 \*  
read_cache_18 
    f*  
read_cache_19         {    *  
read_cache_20 *  
read_cache_21 *  
read_cache_22 
    *  
read_cache_23     F        i+  
read_cache_24 t+  
read_cache_87 +  read_cache_3 +  read_cache_4     +  read_cache_5     A        	,  
read_cache_25     ,  
read_cache_88 -    ?,  
read_cache_26 _,  
read_cache_27 _,  
read_cache_28     	    *    i,  
read_cache_29 p,  
read_cache_89     ?-  
read_cache_30 ?-  
read_cache_31     	           L-  
read_cache_90 .    -  
read_cache_32 -  
read_cache_33 -  
read_cache_91 -  read_cache_3 -  read_cache_4     -  read_cache_5     A        1.  
read_cache_34     8.  
read_cache_92 -    g.  
read_cache_35 .  
read_cache_36 .  
read_cache_37     	    *    .  
read_cache_38 .  
read_cache_93     g/  
read_cache_39            k/  
read_cache_40 r/  
read_cache_94     D0  
read_cache_41 D0  
read_cache_42     	           N0  
read_cache_43 q0  
read_cache_44 q0  
read_cache_45     	    -       |0  read_existing_buffer 0  read_existing_buffer_46 0  read_existing_buffer_47     A    0  read_existing_buffer_48 1  read_existing_buffer_95 1  read_existing_buffer_6 1  read_existing_buffer_7     51  read_existing_buffer_8     =        1  read_existing_buffer_49     1  read_existing_buffer_50     1  read_existing_buffer_51 1  read_existing_buffer_52      2  read_existing_buffer_53 
2  read_existing_buffer_54     )    )2  read_existing_buffer_55     p    2  read_existing_buffer_56     2  read_existing_buffer_57        @   2  read_fresh_buffer 2  read_fresh_buffer_96 2  read_fresh_buffer_6 2  read_fresh_buffer_7     3  read_fresh_buffer_8     ?        k3  read_fresh_buffer_58     3  read_fresh_buffer_59 3  read_fresh_buffer_60     4  read_fresh_buffer_61 4  read_fresh_buffer_62     )    94  read_fresh_buffer_63         4  read_fresh_buffer_64     4  read_fresh_buffer_65     ,   4  read_fresh_buffer_rah 5  read_fresh_buffer_rah_97 5  read_fresh_buffer_rah_6 %5  read_fresh_buffer_rah_7     B5  read_fresh_buffer_rah_8     @        5  read_fresh_buffer_rah_66     5  read_fresh_buffer_rah_67     5  read_fresh_buffer_rah_68     5  read_fresh_buffer_rah_69 6  read_fresh_buffer_rah_70 -    F    6  read_fresh_buffer_rah_71 6  read_fresh_buffer_rah_98 ,    6  read_fresh_buffer_rah_72 7  read_fresh_buffer_rah_99      7  read_fresh_buffer_rah_100 7  read_fresh_buffer_rah_6 7  read_fresh_buffer_rah_7     7  read_fresh_buffer_rah_8     ?        C8  read_fresh_buffer_rah_73           8  read_fresh_buffer_rah_74 8  read_fresh_buffer_rah_75     $    (9  read_fresh_buffer_rah_76 Q9  read_fresh_buffer_rah_77      ~9  read_fresh_buffer_rah_78 	    9  read_fresh_buffer_rah_79 	    9  read_fresh_buffer_rah_80 !        9  read_fresh_buffer_rah_81 9  read_fresh_buffer_rah_82      :  read_fresh_buffer_rah_83 	    :  read_fresh_buffer_rah_84 !    W    :  read_fresh_buffer_rah_85      :  read_fresh_buffer_rah_86 !      		 '   	          	   p 	             
  	                 
           
       
            J
                       H                2                 
                                  PWNC_SET :  set_cache_data :  set_cache_data_1 :  set_cache_data_13 .    (;  set_cache_data_14 F;  set_cache_data_2     I            ;  zero_global_counters <    ;  zero_file_counters ;  zero_file_counters_2     P    <  set_global_cache_data @<  set_global_cache_data_3     S<  set_global_cache_data_4     j<  set_global_cache_data_5     w<  set_global_cache_data_6     <  set_global_cache_data_7     <  set_global_cache_data_8 (    <  set_global_cache_data_9     <  set_global_cache_data_10     <  set_global_cache_data_11     =  set_global_cache_data_12        		]:          
  ?                              PWNC_TFLUSH_THR =  threshold_flush_thread ;=  threshold_flush_thread_1     ?=  threshold_flush_thread_2     M   		=  (          PWNC_TOSS_BUF_IOERR l=  insert_to_bcb_hash_tbl     <>  remove_from_bcb_hash_tbl! \>  remove_from_bcb_hash_tbl_1! a>  remove_from_bcb_hash_tbl_2         C    >  
bcb_lookup )    >  wait_for_bcb >  wait_for_bcb_3 >  wait_for_bcb_4     >  wait_for_bcb_5     C        D?  toss_buffer_ioerror n?  toss_buffer_ioerror_6 n?  toss_buffer_ioerror_7 ~?  toss_buffer_ioerror_8 
    ?  toss_buffer_ioerror_9     I        ?  toss_buffer_ioerror_10 ?  toss_buffer_ioerror_11 @  toss_buffer_ioerror_12 
    *@  toss_buffer_ioerror_13     H        @  toss_buffer_ioerror_15 @  toss_buffer_ioerror_1 @  toss_buffer_ioerror_2 	        <    @  toss_buffer_ioerror_14       		l=   	          	             PWNC_TWE @  
twe_init_pool A  twe_init_pool_1 >    q   		@   	      
PWNC_WRITE `A  insert_to_bcb_hash_tbl     0B  remove_from_bcb_hash_tbl! PB  remove_from_bcb_hash_tbl_1! UB  remove_from_bcb_hash_tbl_2         C    tB  
bcb_lookup )    B  wait_for_bcb B  wait_for_bcb_3 B  wait_for_bcb_4     B  wait_for_bcb_5     C        <C  queue_bioreq_to_bcb AC  queue_bioreq_to_bcb_6 RC  queue_bioreq_to_bcb_7     mC  queue_bioreq_to_bcb_8     B        C  write_cache D  
write_cache_9     D  write_cache_10     D  write_cache_11     )D  write_cache_12     JD  write_cache_13 D  write_cache_14     D    D  write_cache_15 D  write_cache_16 D  write_cache_17 
    D  write_cache_18     F        E  write_cache_19 E  write_cache_20     ,    E  write_cache_21 F  write_cache_130 F  
write_cache_3 F  
write_cache_4     :F  
write_cache_5     @        F  write_cache_22     F  write_cache_131 -    F  write_cache_23 F  write_cache_24     F  write_cache_25     G  write_cache_26     K    G  write_cache_27 G  write_cache_132     G  write_cache_28     G  write_cache_29     H  write_cache_30        "   H  write_cache_133 ,    OH  write_cache_31 _H  write_cache_32 mH  write_cache_134 xH  
write_cache_3 H  
write_cache_4     H  
write_cache_5     @        H  write_cache_33     I  write_cache_135 -    3I  write_cache_34 II  write_cache_35     `I  write_cache_36     vI  write_cache_37     K    ~I  write_cache_38 I  write_cache_136     IJ  write_cache_39     dJ  write_cache_40     {J  write_cache_41        $   J  write_cache_42 J  write_cache_137     NK  write_cache_43     hK  write_cache_44     K  write_cache_45        8   K  write_cache_46 K  write_                                                                                                                                                                                                                                                                           Y` $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                  "     s       cache_47     K  write_cache_48     K  write_cache_49     P       K  write_existing_buffer L  write_existing_buffer_50 
L  write_existing_buffer_51     /L  write_existing_buffer_52 9    L  write_existing_buffer_53     L  write_existing_buffer_54          L  write_existing_buffer_138 L  write_existing_buffer_6 L  write_existing_buffer_7     M  write_existing_buffer_8     A        gM  write_existing_buffer_55     M  write_existing_buffer_56     M  write_existing_buffer_57 M  write_existing_buffer_58     M  write_existing_buffer_59 M  write_existing_buffer_60     )    M  write_existing_buffer_61     k    6N  write_existing_buffer_62 9    N  write_existing_buffer_63     N  write_existing_buffer_64     N  write_existing_buffer_65     N  write_existing_buffer_66     ,   O  write_fresh_buffer HO  write_fresh_buffer_67 bO  write_fresh_buffer_68     J    O  write_fresh_buffer_69 !P  write_fresh_buffer_139 ,    OP  write_fresh_buffer_70 1       P  write_fresh_buffer_71 ;    Q  write_fresh_buffer_140 Q  write_fresh_buffer_6 (Q  write_fresh_buffer_7     FQ  write_fresh_buffer_8     A        Q  write_fresh_buffer_72     R  write_fresh_buffer_73 R  write_fresh_buffer_74      R  write_fresh_buffer_75 R  write_fresh_buffer_76           R  write_fresh_buffer_77           ER  write_fresh_buffer_78     tR  write_fresh_buffer_79     R  write_fresh_buffer_80       " R  truncate_to_existing_buffer% R  truncate_to_existing_buffer_81& R  truncate_to_existing_buffer_141$ S  truncate_to_existing_buffer_6$ S  truncate_to_existing_buffer_7    $ 2S  truncate_to_existing_buffer_8     A       % S  truncate_to_existing_buffer_82    % S  truncate_to_existing_buffer_83    % S  truncate_to_existing_buffer_84    % S  truncate_to_existing_buffer_85% S  truncate_to_existing_buffer_86    % 4T  truncate_to_existing_buffer_87% RT  truncate_to_existing_buffer_88     7        }  % T  truncate_to_existing_buffer_89    % T  truncate_to_existing_buffer_90    % T  truncate_to_existing_buffer_91% T  truncate_to_existing_buffer_92% U  truncate_to_existing_buffer_93 
   % *U  truncate_to_existing_buffer_94     G       % U  truncate_to_existing_buffer_95    % U  truncate_to_existing_buffer_96% U  truncate_to_existing_buffer_97% V  truncate_to_existing_buffer_98% "V  truncate_to_existing_buffer_99     7    Z       & `V  truncate_to_existing_buffer_100& ~V  truncate_to_existing_buffer_101     7       V  truncate_to_fresh_buffer# V  truncate_to_fresh_buffer_142! V  truncate_to_fresh_buffer_6! V  truncate_to_fresh_buffer_7    ! W  truncate_to_fresh_buffer_8     A       # sW  truncate_to_fresh_buffer_102    # W  truncate_to_fresh_buffer_103    # W  truncate_to_fresh_buffer_104    # X  truncate_to_fresh_buffer_105    # X  truncate_to_fresh_buffer_106# X  truncate_to_fresh_buffer_107     # X  truncate_to_fresh_buffer_108# :X  truncate_to_fresh_buffer_109     7    G   # X  truncate_to_fresh_buffer_110    # X  truncate_to_fresh_buffer_111    # X  truncate_to_fresh_buffer_112# X  truncate_to_fresh_buffer_113# 
Y  truncate_to_fresh_buffer_114 
   # *Y  truncate_to_fresh_buffer_115     I       # Y  truncate_to_fresh_buffer_116# Y  truncate_to_fresh_buffer_117# Y  truncate_to_fresh_buffer_118    # Z  truncate_to_fresh_buffer_119# 6Z  truncate_to_fresh_buffer_120     7           # tZ  truncate_to_fresh_buffer_121# Z  truncate_to_fresh_buffer_122     7        Z  toss_buffers_for_truncate$ [  toss_buffers_for_truncate_123$ 4[  toss_buffers_for_truncate_143 )   $ b[  toss_buffers_for_truncate_124$ j[  toss_buffers_for_truncate_125$ j[  toss_buffers_for_truncate_126$ z[  toss_buffers_for_truncate_127 
   $ [  toss_buffers_for_truncate_128     I       $ [  toss_buffers_for_truncate_144" \  toss_buffers_for_truncate_1" 
\  toss_buffers_for_truncate_2 	        ;   $ .\  toss_buffers_for_truncate_129         H     		`A   	          	               
  	                                            
           
                   4
                                      ,         
                                     ' 
                     	      &

                 鵹         	                    PWNC_BIOREQ d\  queue_bioreq_to_bcb i\  queue_bioreq_to_bcb_1 z\  queue_bioreq_to_bcb_2     \  queue_bioreq_to_bcb_3     B        \  bioreq_init_pool ]  bioreq_init_pool_4 >    q   		F#d\  0   	      
PWNC_CLOSE h]  close_cache_file w]  close_cache_file_1 w]  close_cache_file_2 ]  close_cache_file_3     ]  close_cache_file_4     ]  close_cache_file_5     ]  close_cache_file_6     ]  close_cache_file_7     g    r    ]  close_cache_file_8 ^  close_cache_file_9 ^  close_cache_file_10      ^  close_cache_file_11      $^  close_cache_file_12     "    ]^  close_cache_file_13     h^  close_cache_file_14 	    q^  close_cache_file_15 x^  close_cache_file_16      !        .    ^  close___deassign_cache_fd    ! ^  close___flush_before_close     ^  close___free_cfdsc ^  close___free_cfdsc_17      3   		h]         
          	         
      L:
L 	     
PWNC_CRASH ^  crash 
   '^         PWNC_FFLUSH_THR ^  file_flush_thread _  file_flush_thread_1     _  file_flush_thread_2 #    Q   		L^  1 
          PWNC_FINAL_FLUSH D_  insert_to_bcb_hash_tbl     `  remove_from_bcb_hash_tbl! 4`  remove_from_bcb_hash_tbl_1! 9`  remove_from_bcb_hash_tbl_2         C    X`  
bcb_lookup )    `  wait_for_bcb `  wait_for_bcb_3 `  wait_for_bcb_4     `  wait_for_bcb_5     C         a  final_flush =a  
final_flush_6 =a  
final_flush_7 Ja  
final_flush_8 
    ja  
final_flush_9     F    ~    a  final_flush_10     a  final_flush_11 b  final_flush_12         b  final_flush_13     b  final_flush_14 b  final_flush_15 b  final_flush_16     b  final_flush_20  c  
final_flush_1 c  
final_flush_2 	        ;    e    <c  final_flush_17         lc  final_flush_18 c  final_flush_19     7      		D_   	          	 ]    
        +            
PWNC_FLUSH c  flush_cache_buffers c  flush_cache_buffers_1     c  flush_cache_buffers_2     c  flush_cache_buffers_3     d  flush_cache_buffers_4     d  f                                                                                                                                                                                                                                                                           L $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                 ;A "            lush_cache_buffers_5     d  flush_cache_buffers_6        		c  <                  PWNC_FLUSH_FILE 8d  
flush_file d  flush_file_1 d  flush_file_2         0e  flush_file_3     @e  flush_file_4 D    e  flush_file_5 e  flush_file_6 e  flush_file_7     4    ;    e  flush_file_8 f  flush_file_9     7      		 8d          
          PWNC_GET 0f  get_cache_data Zf  get_cache_data_1 1    _    f  get_global_counters     @g  get_file_counters tg  get_file_counters_2         g  get_global_cache_data    		\0f  |                PWNC_GIVE_BUF_AWAY h  give_buffer_away h  give_buffer_away_1 h  give_buffer_away_2     5     i  give_buffer_away_3     h   		  h   
         PWNC_FLUSH_PASS i  make_flush_pass <i  make_flush_pass_1 Zi  make_flush_pass_2 
    ,    e   		Zi  %          PWNC_DIRTY2FLUSH |i  move_dirty2flush i  move_dirty2flush_1     i  move_dirty2flush_2     i  move_dirty2flush_3 i  move_dirty2flush_4 1    E       		|i  @               PWNC_PLACE_BUF j  insert_to_bcb_hash_tbl     j  remove_from_bcb_hash_tbl! j  remove_from_bcb_hash_tbl_1! j  remove_from_bcb_hash_tbl_2         C    k  
bcb_lookup )    Hk  wait_for_bcb Xk  wait_for_bcb_3 ik  wait_for_bcb_4     k  wait_for_bcb_5     C        k  place_buffer l  place_buffer_6 l  place_buffer_11 0l  place_buffer_1 5l  place_buffer_2 	        ;    tl  place_buffer_7         l  place_buffer_8 l  place_buffer_12 l  place_buffer_1 l  place_buffer_2 	        :    m  place_buffer_9         .m  place_buffer_10     i  		Wj  Ź 	          	              PWNC_FINDBUFFER Pm  insert_to_bcb_hash_tbl      n  remove_from_bcb_hash_tbl! @n  remove_from_bcb_hash_tbl_1! En  remove_from_bcb_hash_tbl_2         C    dn  
bcb_lookup )    n  wait_for_bcb n  wait_for_bcb_3 n  wait_for_bcb_4     n  wait_for_bcb_5     C        ,o  pwnc_find_a_buffer Vo  pwnc_find_a_buffer_6 ao  pwnc_find_a_buffer_7 P    `    o  pwnc_find_a_buffer_8 o  pwnc_find_a_buffer_27 o  pwnc_find_a_buffer_1 o  pwnc_find_a_buffer_2 	        :    p  pwnc_find_a_buffer_9 P        p  pwnc_find_a_buffer_10 p  pwnc_find_a_buffer_11 p  pwnc_find_a_buffer_12 q  pwnc_find_a_buffer_13 q  pwnc_find_a_buffer_14 q  pwnc_find_a_buffer_15 
    .q  pwnc_find_a_buffer_16     C    q  pwnc_find_a_buffer_17 q  pwnc_find_a_buffer_18 P    U        q  pwnc_find_a_buffer_19 r  pwnc_find_a_buffer_20     &    I   u      nr  pwnc_find_a_buffer_21 nr  pwnc_find_a_buffer_22 {r  pwnc_find_a_buffer_23 
    r  pwnc_find_a_buffer_24     E    r  pwnc_find_a_buffer_25 r  pwnc_find_a_buffer_26 L    Q        '  		Pm   	          	 W 
	        	  
       '           PWNC_TOSS_ALL_BUFS Ts  insert_to_bcb_hash_tbl     $t  remove_from_bcb_hash_tbl! Dt  remove_from_bcb_hash_tbl_1! It  remove_from_bcb_hash_tbl_2         C    ht  
bcb_lookup )    t  wait_for_bcb t  wait_for_bcb_3 t  wait_for_bcb_4     t  wait_for_bcb_5     C        0u  toss_all_buffers Tu  toss_all_buffers_6 ^u  toss_all_buffers_8 xu  toss_all_buffers_1 }u  toss_all_buffers_2 	        ;    u  toss_all_buffers_7     i       		UTs   	          	 A         
PWNC_TOSS_BUF u  toss_buffer u  
toss_buffer_1     u  
toss_buffer_2 v  
toss_buffer_3     9    Hv  
toss_buffer_4 dv  
toss_buffer_5     9       		 u  0  
          DIGITAL_COPYRIGHT                                                                                                                                                                                        ?  DEFAULT_CLUSTER   +   J   i                 '  F  _              6  V  }             B  k          F  h          K  p        +  \                	  +	  J	  b	  	  	  	  	  
  
  5
  S
  j
  
  
  
    *  N  u      
    A  T  j          
  $
  :
  W
  t
  
  
  
  
  
    C  g  y            %  9  ^  q            '  F  e          ,  K  j          =  j            "  E  h          O  r  Q  n        
  '  L        2  d            +  P  v          ;  Z  y          E  k          "  H  u          4  P  s            7  S             :   k            !!  X!  y!  !  !  !  ,"  Q"  y"  "  "  "  1#  Z#  B'  Y'  r'  '  '  '  '  (  +(  K(  k(  (  (  (  (  )  8)  Y)  z)  )  )  )  *  **  X*  1+  N+  ~+  +  +  ,  (,  _,  x,  ,  ,  ,  ,  ,  -  8-  N-  r-  -  -  -  -  -  .  N.  E/  _/  {/  /  /  /  0  :0  ]0  0  0  0  1  01  N1  m1  1  1  1  2  +2  X2  2  b3  3  3  3   4  4  -4  C4  `4  4  4  4  4  5  +5  F5  b5  ~5  5  5  5  5  6  6  46  ^6  s6  6  6  6  6  6  7  '7  P7  l7  7  7  7  7  7  
8  "8  S8  o8  8  8  8  8  8  9  "9  >9  S9  h9  9  9  9  9  :  :  3:  d:  y:  :  :  :  :  ';  F;  e;  ;  ;  ;  <  '<  F<  l<  <  <  <  =  ?=  X=  t=  =  =  =  >   >  C>  _>  >  >  >   ?  ?  =?  \?  ?  ?  ?  @  +@  K@  y@  @  @  @  A  (A  GA  mA  A  A  A  $B  DB  kB  B  B  B  C  .C  UC  C  C  C  G  G  H  !H  :H  nH  H  H  H  H  I  >I  dI  I  I  I  I  #J  JJ  {J  AK  _K  K  K  L  )L  IL  kL  L  L  L  L  M  -M  HM  eM  M  M  M  M  N  9N  lN  N  N  N  O  O  O  P  MP  rP  P  P  P  Q  Q  .Q  KQ  vQ  Q  Q  Q  R  R  3R  PR  mR  R  R  R  R  R  
S  8S  NS  rS  S  S  S  S  S  T  5T  KT  hT  T  T  T  T  T  U  BU  `U  vU  U  U  U  U  U  V  9V  OV  lV  V  V  V  V  V  W  FW  \W  zW  W  W  W  W  X  /X  ZX  wX  X  X  X  Y  :Y  [Y  zY  Y  Y  Y  "Z  BZ  iZ  Z  Z  Z  [  3[  Z[  [  [  [  [  \  .\  S\  ~\  \  \  \  \  0]  T]  q]  ]  ]  ]  ^  ,^  P^  {^  ^  ^  ^  _  <_  v_  _  _  _  #`  P`  v`  `  `  a  8a  ^a  a  a  a  b  ?b  eb  b  b  
c  *c  Nc  pc  c  c  c  &d  Qd  |d  d  d  d  (e  Se  ~e  e  e  e  *f  Nf  rf  f  f  g  %g  ^g  g  g  g  g  h  ?h  kh  h  h  h  %i  ii  +o  Fo  co  o  o  o  o  Hp  `p  zp  p  p  p  p  q  Gq  aq  {q  q  q  q  
r  ,r  Gr  ~r  r  r  r  s  s  s  #t  <t  ^t  t  t  u  "u  Du  {u  u  u  u  u  v  v  .v  Cv  _v  v  v  v  v  v  w  )w  Fw  \w  qw  w  w  w  
x  Oy  jy  y  y  y  y  z  Lz  z  z  z  z  {  '{  ;{  O{  x{  {  {  [|  q|  |  |  |  |  "}  }  }  }  ~  G~  ~  ~  ~  ~  ,  D  e        2  W  w    Ѐ        0  [  o        ݁      .  D  o        ƃ      ?  X  l      ʄ       *  F  c      څ      1  N  k      ׆  	  &  f      ć      H      ԉ    -  F  EZ  p      Њ        M    M  `  |      Ɍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   AV $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$CACHE.EXE;1                                                                                                                                              <     
PWVN$CACHE	V1.0-611F 5-APR-1998 20:33 5-APR-1998 20:33  VAX-11 Linker V05-13        	.$$ABS$$.         UTL_MEM_TRACKED_ALLOC        UTL_MEM_TRACKED_FREE         UTL_MEM_REPORT       PWNC_INITCACHE      < PWNC_UNLOADCACHE&       PWNC_GA_CACHE_BUF_MEMORY"    $  PWNC_GA_CACHE_MEMORY    (  PWNC_GA_GCCB$    ,  PWNC_GB_CACHE_LOCKDOWN,    0  PWNC_GB_MAP_CACHE_CTRL_TO_GSEC)    4  PWNC_GB_MAP_CACHE_MEM_TO_S0 ,    8  PWNC_GL_USERS_CONFIG_FLAGS_VAL <   <  PWNC_GR_OVERRIDE+    x  PWNC_GS_UNIQUE_CONFIG_ID_STR0                                                                                                                                                                                                                                                                                                                                                                                                                                          * [NW.KIT.EXE]PWVN$CLD.CLD;1 +  , q  . 2    /     4 @   2    2                   - n  0   1    2   3      K   P   W   O 3    5   6 .;  7  9mD  8          9          G    H  J                       module PWVN$CLD    define verb NSHOW      image PWVN$CLIENT >     parameter P1, label=QUEUE, prompt="Queue", value(required)   define verb NDELETE      image PWVN$CLIENT >     parameter P1, label=QUEUE, prompt="Queue", value(required)@     qualifier ENTRY, nonnegatable, value(type=$number, required)                                                                                                                                                                                                                           * [NW.KIT.EXE]PWVN$CLIENT.EXE;1 +  , q  .     /     4                             - n  0   1    2   3      K   P   W   O     5   6  X4"_D  7 `mD  8          9          G    H  J                    0 D `     0205        !_D     @                                                 PWVN$CLIENT                            	V1.0-611F      k!_D 05-13                                 
                                  
       ?   &      !         PWVN$NWAPISHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001'      !         PWRK$XTILIBSHR_001(      !       PWRK$STREAMSSHR_001#      !         PWRK$CSSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001'      !         PWRK$CMTLIBSHR_001       !        VAXCRTL_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @                                          @                 
                 3     E     N     W     _      g  @   o     z                             @                                                                                                                                                                                                     $VERB QUEUE ENTRY NSHO NDEL SYS$CLUSTER_NODE SYS$NODE OpenVMS User %[^:]::%s job %d; %s stopped paused busy idle , closed  NetWare printer queue %s, %s%s, on server %s
 OpenVMS User %[^:]::%s job %d; %s 
  Entry  Jobname         Username     Blocks  Status
   -----  -------         --------     ------  ------
 Pending Holding Adding Printing no privilege   %5d  %-15s %-12s %6d  %s
    aligning idle operator request paused pausing remote resetting resuming server stalled starting stopped stopping unavailable closed busy available disabled autostart inactive stop pending , %s Aborting Printing Holding Refused Requeue Restarting Retained Starting Holding after Suspended Pending Stalled Incomplete Completing %s  Printer queue %.*s , on %.*s::, mounted form %.*s
 
  Entry  Jobname         Username     Blocks  Status
   -----  -------         --------     ------  ------
 no privilege   %5d  %-15.*s %-12.*s %6d   
 
 PWVN$CONF_DIR:PWVN$NWPRINT.CFG r PWVN$CONF_DIR:PWVN$NWPRINT.CFG VMS queue name NetWare server name NetWare queue name NetWare user name                                      ^߭ݬݬ
  PRPRP߭ݬݬ  PRPRPխ խݏ>ݬݏ>  Џ	>PP ^ݬ
  PRPRPݬ
  PRPRPЏ	>PPP^  Sʐ̐cΰĐޣưޣYԭԭЏ   b dޭfjnpޭr|v|~ՐԴԭ?ڟҟ  PRPRP<PPߣݭ  PV.P<PPߣݭ  PVPЏ2 PՐԴԭ?ڟҟu  PRPRP<~ݭ߭  <P@V;ՐԴԭ?ڟҟ/  PRRЏP Pݭb  PY߭R  PRP߭ݏ:>  |~Zb|~ PRPZRRRP߭ ߭  PRPRPVvnޭUYT߭Tݮ  PWPWRMP߭Tݮ9	  PWPWR1Pխ#խݏ>Tݏ>5  PRЏ	>RRPVDޭTݮF  PXPXR"Pݮb  PXPXR
PЏ	>RRPP                                     < <^QT.R
ư!>ΰҰ ޭ||d  PS
ߤ  PSSS  y  Pi  P@|~߭|~  PUPЭUUUP<P@!<PPQPA! QP@!QˏPQPQQ0  Џ	>P ^-R  ݏ2>ݏj>}  ^  WV(f?
J  PXjg 	 ݏR>
ݏB>)  g 	 ݏJ>
ݏB>  gݏ2>
ݏB>  f<~  PXEg  ݏb>
ݏZ>  gݏ2>
ݏZ>    Џ	>P ^Rbb<~C  PS =  PSbЏ	>P ^  TRߢ<~  PS dݏ2>
ݏZ>
  ߢ<~  PSEd  ݏr>ݏj>
  dݏ2>ݏj>
  ߢ?ݢ<~j  PS dݏ2>ݏj>Z
  Џ	>P (^S  VRԼT<PTP1
  Wf<D~ݢ<~  PU,U ! 1hfݏ2>ݏj>	  f  PU fݏ2>ݏj>	  ߣ  P1 *߭R_ߣ'͜  P͜ݏ >g1 Phhݢݏ(>g01 ѭ1 0B_D  PR!1  Pݏ>ݏz>  <D~ݢ<~  PU fݏ2>ݏz>  ݭݏ>  T<PTP1bЏ	>PP^T  WSn|~??!ݣ<~  PX gݏ2>ݏj>  <Rޤ<U"P!RRޤDU<RޤKUޤPU!RRޤURPޤ^R
RUߤ_  V<RVR1  Z  [  YP^<F~ݣ<~]  PX,g ! 1gݏ2>ݏj>Q  ^!  PX gݏ2>ݏj>  č xjP1^"߭JWĚ ͔0  P͔ݏ >k1'P``ݣݏ(>k01 ߭<F~ݣ<~m  PX,g ! 1 gݏ2>ݏj>e    RQRPЏ   R	RP	Q{RPQPQnnį i iUyRˏ?RP$UR,U͐3U01WjPJ!jP<"  JUݭJ"ݭIiV<PVP1Џ	>PP ^SЏ	>R PRP!ݬ                                                                                                                                                                                                                                            P $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$CLIENT.EXE;1                                                                                                                                             PRP 'PRP PRcc<~0  PT *  PTԣ RP ^SЏ	>R `PRP'ݬϊPRP ϿPRPݬݬϚPRcc<~  PT   PTcRP                                                                                                                                                                                                               < ^TSUPxUQAcRҬPPbPAP`ļ   UP< ^TZRUPxUQA  SҬPPcPA¤ P`F  
U 0^؛|ܰެ||ԼЬRbu  Pb|~߭  8PSPЭSS(SB Џ	>PSݬݏ>    ݏ>  ΰ^VtUYBMD|FNLPޭRVZF\ޭ^>bfGhޭjnrKtޭv>z~ޭ>ޭ|ԭͻLͽޭͿޭ',>Q>.ޭ1ޭ||ЬTd  PBdF|~|~   PX|~ͳB   PXXͳXXXP߭<~J  WTxTP@eSWRRcR@RbƼ ]  T߭<~߭<~]@  |~ͳͻ   PXXͳXXXB 1 X 1 XPYY}  ƴ  !    Pܴݭ<~<~  TSxSQAŠ RTPPbPAŤ P`Fn  
S_  1Q  Џ	>P  ^ެPPS<TT ЬRTRTRPSSQa@ RRT|~  ɏ   P   < ^iSݬ< ~  PP  PRB
Bլ
PTUR~  RPRB!BBB B	UUBTB~  PBR,  RPT  PRBd Bd	RP@dPRT
  P1TP ^ЬRݬ
  PP
  Pbݬb
   ^T2Sߤdy
  PXߤ!ݏ><߭ XϋP1fR
  U[
  VP
  WPePRݏ>cPR@ޭЭRRfPPePRݾgխݏ>cP@PЭ`߭ XP ݭߤ@ݏ> ݏ>{ޭЭRRfPPePRݾgխݏ>CcP@PЭ߭ XυP ݭߤOݏ> ݏ>ޭЭRRfPPePRݾgխݏ>cP@PЭ߭ XP ݭߤcݏ> ݏ>ޭЭRRfPPePRݾgխݏ>YcP@PЭ߭XϛP ݭߤvݏ> ݏ>ޭnЭRRfPPeP Rݾgխݏ>cP@PЭc߭ X%P1X
  Џ	>P ^uW +PSSSPgݏ>Vg1PFRbݬ
  PFR(bЏ	>PVVgЏ:>P  < `^, n 䐏P;
  /
  ݬ
  ^| 
  VX^, n 䐏Q	  	  ݬf^PRݬ	  l$լݬfRP| 	  VD^, n ȐSȞo	  ؞c	  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏T    l
լЬ^< `^, n 䐏U  x  ݬb  ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            e           (                             {     >   >  >Z   >  (>  0>  8>:  @>  H>  P>  X><  `>|  h>  p>  x>  >B  >r  >  >  >  >  >R  >  .        NORMALNormal successful completion D       	NWDELETED0entry !SL aborting or deleted from NetWare queue0       DELETEDentry !SL aborting or deleted <       
INVALIDVMS&invalid VMS job description format !AZ F       MISMATCH3mismatched job owner; expected ID !8XL, got ID !8XL.       NWERRNONetWare error code is 0x!8XLL       
NOTNWQUEUE6VMS queue !AZ is not assigned to a NetWare print queue >       	ATTSERVER*error attaching to NetWare file server !AZ6        	UNKSERVER"server is unknown or not reachableB        NOTRANS0error opening transport; NPSD may not be running@       	LOGSERVER+error logging in to NetWare file server !AZ &        	UNKUSRNAMunknown user name 4       ERRQUEUE error querying NetWare queue !AZ .        	UNKQUENAMunknown NetWare queue name>       	DELQUEERR)error deleting job from NetWare queue !AZ 0        NOTYOURSjob was not submitted by you ,        
NOTDELETEDerror deleting job !SL          	NOSUCHJOBno such job         NOMEMno more memory8       	OPENERROR$error opening configuration file !AZ>        NOQUEUES+no queues defined in the configuration fileD        EARLYEOF0premature end of file reading configuration file $        LASTREADlast read !AZ !AZ >PWVN                                             @   @                                                      h           p  `     (              `  H  P     
     l   <   d             L    
             ܨ     >   
                 @                                                                       
PWVN$NWAPISHR                                                  LIBRTL                                                         MTHRTL                                                         PWRK$XTILIBSHR                                                 PWRK$STREAMSSHR                                                
PWRK$CSSHR                                                     	SECURESHR                                                      
SECURESHRP                                                     PWRK$CMTLIBSHR                                                 VAXCRTL                                      >                                                                                                 * [NW.KIT.EXE]PWVN$DOSLOGIN.EXE;1 +  , \  .     /     4                             - n  0   1    2   3      K   P   W   O     5   6 eYD  7 mD  8          9          G    H  J                  0 D `     0205        שYD       hh	                                       
PWVN$DOSLOGIN                          	V1.0-611F      `MשYD 05-13                                                
  
     ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001&      !         PWVN$NWAPISHR_001'      !         PWRK$XTILIBSHR_001(      !       PWRK$STREAMSSHR_001#      !         PWRK$CSSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001'      !         PWRK$CMTLIBSHR_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                    @(#)getopt.c		2.1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !                        -n} $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$DOSLOGIN.EXE;1                                                                                                                                           d:l:s:u:p: Usage: doslogin  [-s SERVER] [-u USERNAME] [-p PASSWORD] [-d DELAY] [-l LOOPS]
 PWVN$SERVER_NAME Usage: doslogin  -s SERVER [-u USERNAME] [-p PASSWORD] [-d DELAY] [-l LOOPS]
 SUPERVISOR  
Starting loop %d of %d
 
 NWAttachToServer failed with %x.
 Attach to server Successful.
 Login failed with %x.
 Login Successful.
 Welcome to server %s.
 Get server connection ID failed with %x.
 Server connection ID = %d.
 Get server name failed with %x.
 Server connection ID %d has server name of %s.
 Get client connection ID failed with %x.
 Client connection ID = %d.
 Pausing for %d seconds...
 Logout failed with %x.
 Logging out of server %s.
 Detach from file server failed with %x.
 Detaching from server %s.
 Close of Transport unsuccessful. Failed with %x.
 Closed transport.
 %s    %s: option '%c' not followed by argument
 %s: unknown option '%c'
 getopt   ^  RS  WV|ZYXbݬݬ  PTT1   UTQQ?1 wQd   1 QPPd   0 x x x x x x x < x x x X x x H x P RPb?PcePY>PcePX2PcV+Pc[#PcZPߢ  ߢ  Pbݬݬ1  PTT1IV
ߢ[  PVVߢl  ߢ}  P[º [Z ZTX1]XT~ q?V  Pg V1NPGZ[<~  Pg!'<~l  18VK?VL  Pgb <~ V<~'  Pg¨ V<~ϱ ?<~  Pgϔ <~#χ Y?}Yt  <~  P
gZ[VrQ<~  P
g8V¶.TTX1   P
gVP ^R   P  ݬݬݬݬݬ  4    '  P`P
~     ^YWWXniiS޼RCb[
k-ըPШRBk:iiRR)ެSB   TBdgRiRRB -
iPiS޼RCbUЬVfZrPШRZBk^:_iiRR/ެSB %cTBdgRP޼Q@aURRB Uge-nPiԨVfZZnn,$SШRBk~Sݮ  i  ?Z֨ШRBkiZP ^RPb|~?H<P@b  P ^Џigԭ߭߬  PR ߭߯0߭  PRP	R  խ խP  ^|~                                                                                                                                                                                                                                                                                                                                                                     @   @   x                                                 |   
    &        L         
          (   p  `  x      0         ܨ 8
  ,
         
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                         
PWVN$NWAPISHR                                                  PWRK$XTILIBSHR                                                 PWRK$STREAMSSHR                                                
PWRK$CSSHR                                                     	SECURESHR                                                      
SECURESHRP                                                     PWRK$CMTLIBSHR                                                                                                                                                           DOSLOGIN h	  main
 	  main_1
 
  main_2 J       
 
  main_3    
 
  main_4
 
  main_5    
   main_6    
 @  main_7    
 i  main_8    
   main_9       main_10 
      main_11 
    R     main_12 
       4  log_message Y   		)h	     ެ           	 
    GETOPT
   getopt   getopt_1   getopt_2   getopt_3         :    
  getopt_4 
    8
  getopt_5 B
  getopt_6 H
  getopt_7 `
  getopt_8 f
  getopt_9         
  	getopt_10     U    ]    h    
  	getopt_11 $    
  	getopt_12     h  		  @               VMS_SPECIFIC 
  GetCurrentTime <    4  	RealSleep   RealSleep_1     Y      
RealSleep_ast    		
  4      DIGITAL_COPYRIGHT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [NW.KIT.EXE]PWVN$NETWARE.EXE;1 +  , \  .    /     4                           - n  0   1    2   3      K   P   W   O    5   6 ]^D  7 `mD  8          9          G    H  J                   0 D `     0205        ^D      hPw                                   PWVN$NETWARE                           	V1.0-611F      @7^D 05-13                      	           (        * 3      
    ]      7                
      ?   # <     !         PWVN$CACHE_001      !        
LIBRTL_001 O    !       
MTHRTL_001'      !         PWRK$XTILIBSHR_001#      !         PWRK$CSSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001'      !         PWRK$CMTLIBSHR_001,      !         PWRK$LICENSE_LIBSHR_001(      !       PWRK$STREAMSSHR_001       !        VAXCRTL_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
 (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      syscfg.sys                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "                        piJ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ^ "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           DOS Primary Data Stream. MACINTOSH Macintosh Resource Fork.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 SYSTEM/SPOOL.SYS SYSTEM                                                                                                                                                                                                                            f (   t g H                                                                                                                @(#) qsetup.c 1.1 11/27/89 15:59:55                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	

  	


 
		

 
 	


 	
	
  
		 

	
 

	 
 
	
	 


 
	 	



 	
 	
 
	 
	
	   	
 


	
				


 
 	


 	
	 



	

 	 
 	
 

	
  



HFg=捷z&Z5kpGܧP                                                                                                            
   /   a      K  #        I                                                                                                                                                                                                                                                                                                                                                                                                       @                                                                                                                            @(#)lockmgr.c 1.33 7/17/89 11:33:51                                                                                                                     PWVN$CONF_DIR:PWVN$MSGS.DAT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @                                                                                           nbes nbed                                                                                                                                                                                                                                                                                 #                        ( $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "                                                                                        @(#)propops.c 3.2 9/7/90 18:18:58                                               @(#)bindops.c 2.5 8/23/89 12:30:47                                                 @(#)bindutil.c 3.3 9/6/90                                       *?"/\[]:|<>+=;,                                                                              @(#) proputil.c 3.1 8/14/90 15:58:35                                        @(#) bindInt.c 3.1 8/14/90 15:58:04                                     @(#) propInt.c 2.4 8/28/89 16:22:15                                     3D211112"2211@22413311112   @(#) bindsetup.c 3.1 8/14/90 15:58:11                                       NET$OBJ.SYS NET$PROP.SYS NET$VAL.SYS RMS$OBJ.SYS RMS$PROP.SYS RMS$VAL.SYS       @(#) bindmisc.c 3.1 8/14/90 15:58:06                                           ; Z x     0N                                                                                                                                                                                                                                                                                                                          RMS_T_FILE.SYS                                                                      SYSTEM/T_FILE.SYS                                                                                                                  RMS_T_USER.SYS                                                                           SYSTEM/T_USER.SYS                                                                                                                                                                                                    RMS_T_DJNUMB.SYS T_DJNUMB.SYS                                                                                                                                                                                                                                                                                                                                                                                 SYSTEM/T_DNODE.SYS RMS_T_DNODE.SYS                                                                                                                                                                                                                                                                                                                                                                           ؅    	                     
     @  ̆                       ؅                  &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @           <  L    4  N                                                    L 
 L                                                                                                                                                                                                                                                                                                                                                                        Account has expired on server %s. Logged out.   Supervisor has deleted your account with server %s. Account balance exceeded.   SYSTEM/NET$ACCT.DAT ACCT_LOCKOUT    Account balance exceeded on server %s. Logged out.  ACCOUNT_SERVERS  ( t      ./srv_agent NWServiceAgent                                                                                                                                                                                                                                                                                                                                                                                                                  )  H  ]  x              )  8  OBJ_BACK_LINKS  ACCOUNT_BALANCE                            | | | | | | | | | a | X*  F b @d     #  @  | | | | | | | | | | | | | | | | | | | | | | | | |   , (            < t  T     H     | | | | | | | | | | | | | | | | | | | M | | |   8 t     Џ d  Е l    \ , L X  | | | | | | | | | | | | | | | | | | | | | | | | | | | | |     | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | d $e <f f  g Xg | g h @` ! lh | | | | | | | | | | | | | | | | | | p+ | |  | | | | | | | | | | | | | | | | | | | | | | BLOCKS_READ BLOCKS_WRITTEN                                  ĕ  p                     H  X  l            Ĳ                     Digital     CONNECT_TIME        04/05/98          &  0  9  @                  /dev/console                                                                                                                                                                                                                                                    SYSTEM/SYS$LOG.ERR  PWVN$CONF_DIR:  SYS      \ P @ \ d  | | | l 8   T  | |  `    , | |  |    H h % p& \' ( T)   8 $ x) H   D < { ,|   |         DISK_STORAGE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              R "     )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ̊ 8$ d     h   h  pq ԓ ܋ ܓ  ;  7 L  ` EVERYONE                                                     H   \I                                                                                                                          ACCOUNT_HOLD    HOME_DIRECTORY  .hpfsres    VMS account (%s) disabled in UAF    Invalid default directory specified in UAF  User name or UIC mismatch (Netware:%s, VMS name:%s) Invalid connect time on server %s. Logged out.                    LOGIN_CONTROL   .macres MANAGERS    GROUP_MEMBERS       I  Q  Z  `  f  j  o  t  {        ] ^ p_ _ | | | | | _ | GROUPS_I'M_IN   | | | N xO P 0Q pQ R S S |T T dU U | | (L L pk i hL L L $j j  V LW W X X Y LM Pi M | | | | | | | | | | | | | | | | | | | | | | | | | K ,   ȶ , / / 5 6 8 ; ; T= x> ? @ B | pD | | | | 1 I | | | | | | | | | | M | | | | | | | | | | | | | | |  | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |         NET_ADDRESS  5 NODE_CONTROL    (C) Copyright 1989-1992 Novell Inc,
1992 Digital Equip Corp All Rights Reserved                                         	               #     0  
   =     L     U     Y     c     t  	     
          \                                                 -     ;     I     X     g     v                       !     "     #     $     %     &     '     (   !  )   /  *   >  +   M  ,   \  -   k  .   z  /     0     1     2     3     4     5     6     7   !  8   4  9   G  :   [  ;   o  <     =     >     ?     @     A     B     C     D      E   
  F     G   '  H   4  I   A  J   O  K   ]  L   k  M   y  N     O           PWVN$CONF_DIR:PWVN$NPSCONFIG.CFG                     NetWareFileSrvr ./ncp_engine    NWEngine                OBJ_SUPERVISORS OLD_PASSWORDS       OPERATORS           PASSWORD         X ̰ D x     |   (     | k r 4u y                                                                                                                                                                                                                                                                       Q     P     R          S     S     U     U     T     V     ^     ^   +  b   3  c   >  d   I  ]   Y  ]   e  W   q  W   z  X     X     Y     Y     Y     Y     Z     Z     [     [     [     [     _     _     _     `   0  `   B  a   V  a   g  g   u  g   {  g     e     e     e     f     f     f     h     h     i     i     k   0  j   @  j   O  j   _  x   l  x   w  x     p     p     p     q     q     r     r     t     s     s     s   #  s   :  l   O  l   _  l   q  l   ~  l     m     n     o     o     o     o     w   
  w   %  w   .  y   >  y   G  y   S  y   a  z   h  z   v  {     |     }     ~     ~     u     v     v     v     v             .     B     O     ^     s                                                                                             PWVN$CONF_DIR:PWVN$NWCONFIG.CFG ./ptr_server          | | | | | | | | | H    H     G    G    G    G    G    G     H @   H    H    H     H    'H    .H    5H     <H  @  CH    JH    PH    VH    [H    cH    jH     qH   @ xH    H    H    H    H    H    H     H    @H    H         NWPrintServer     H L | | | | |  ܄                                 Q_DIRECTORY Q_OPERATORS Q_SERVERS   Q_USERS         REQUESTS_MADE   PATHWORKS V1.0-611F for OpenVMS (NetWare)                                                                                                       $$salv$$.db deleted.sav $$%4.4d$$.$$            ./sap   NWServerAdvertiser  pnw_stats   SECURITY_EQUALS PZ  [ [ \ ] |                                                                                                                                                                                                                                                                                                                     SUPERVISOR                                                                                                                                   $                                4 X                                      ALERT:  Write failed on file %s. Check disk space.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |              RESERVED.SPC                                                                                    *                                                                                                                                                                                                                                                                                                                               PWRK$NW_XPORT Initializer Initialization Error: VMSCheckPrivs: %08X
 pwvn$svr Error obtaining startup process lock
 Initialization Error: threadcreate: %X
 eng  NWDMain(NWConfig) Error obtaining cluster control lock
 This happens for two reasons:
   1) Another node's server is initializing at the same time
      this node's server is initializing
      If this is the case, simply restart this server
      If restarting this server fails to clear the problem
      stop all servers in the cluster, and restart them.
 
   2) Some node in the cluster is configured cluster inactive.
      To fix this, run @SYS$UPDATE:PWVN$CONFIG on that node
      and that node's server will be configured as a
      cluster server
 
 This node's server is not configured to run in a cluster
 but there are %d other servers running in this cluster
 
This is an illegal configuration.  To fix this, run
 @SYS$UPDATE:PWVN$CONFIG on this node and it will be 
 configured to run in a cluster.

 NWDMain() SYS NWDMain(NWConfig) NWDMain(NPSConfig)  NWDMain() NWDMain_Vollist() SYS SEC*URITY FILE_PRO*TECTION DIR_PRO*TECTION REC*ORD_TYPE CLOSE VolRoot SYS NWDMain_VolList() NWDMain_VolList() NWDMain() NWDMain() NWDMain() NWDMain() NWDMain_GetAddress() STARTUP: LongNameSupport is set to: %d
 STARTUP: DeferredClose is set to: %d
 STARTUP: Initializing communications
 STARTUP: Max connections changed from %d to %d.
 STARTUP: Initializing file system
 NWDMain_VolList() SYS NWDMain() NWDMain_VolList() SYS NWDMain() NWDMain_VolList() NWDMain() NWDInitStati                                                                                                                                                                                                                                                   %                        eP $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              R "     :       cDirs() StartupBindery OpenBinderyFiles STARTUP: Initializing trustee database.
 StartupTrustee STARTUP: Initializing qms.
 QMS: Not all queues could be started STARTUP: Initializing accounting.
 STARTUP: Initializing disk quota.
 StartupDiskQuota StartupAES STARTUP: Server will use XQP+ 
 STARTUP: Server will not use XQP+ 
 STARTUP: Updating configuration file
 STARTUP: Starting SAP thread
 CreateDownMsgThread Server is running in a cluster
 Error converting cluster control lock
 ERROR: Can't map file server %s to ID
 Error obtaining file server name lock
  STARTUP: Spawning Transport Listener.
 pwvn$svr Error obtaining running okay process lock
 STARTUP: Initializing async. events
 SHUTDOWN: Server shutdown initiated
 SHUTDOWN: Stopping communications
 PATHWORKS for OpenVMS (NetWare) (%s) down.
 SHUTDOWN: Received shutdown signal...
 SetupMemory() TransportListener SpawnTLThread() SAPDaemon SpawnSAPThread() system.dir public.dir mail.dir login.dir VerifyExistenceOfNWDirs() SYS %s/%s 
This file contains information and statistics  about a particular
iteration of the server. 


		PATHWORKS for OpenVMS (Netware) Information

 Server Name:		%s
 %s %s %d, 19%d  %02d:%02d:%02d Server Start Time:	%s
 %s %s %d, 19%d  %02d:%02d:%02d Server Stop Time:	%s
 Server Version:		%d.%02d Rev. %d
 Max. Supported Connections:	%d
 Max. Supported Volumes:		%d
 Max. Supported Volumes:		%ld
 Max. NetWare Processes:		%d
 Max. Clients Per Process:	%d
 Process Spawn Ahead Count:	%d
 Read-Ahead Cache Block Size:	%d
 Read-Ahead Cache Flag:			%s
 INACTIVE ACTIVE Write-Behind Flag:				%s
 INACTIVE ACTIVE Creator ACE Flag:				%s
 INACTIVE ACTIVE Maximum Directory Searches:			%d
 Deferred Close File Timer:			%d
 

		PATHWORKS for OpenVMS (Netware) Statistics

 Total Packets Received:			%d
 Create Connection Requests:		%d
 Max. Simultaneous Connections:	%d
 
File Creations:			%d
 File Opens:				%d
 File Read Requests:		%d
 File Write Requests:	%d
 Max. Simultaneous File Opens:	%d
 
Lost Packet Resends:	%d
 Unknown NCP requests:	%d
 
TTS Requests:				%d
 Transactions Performed:		%d
 Transaction Backouts:		%d
 Max. Simultaneous Transactions:		%d
 
Logical Lock Requests:				%d
 Max. Simultaneous Logical Locks:	%d
 NW File Lock Requests:				%d
 Max. Simultaneous NW File Locks:	%d
 Physical Lock Requests:				%d
 Max. Simultaneous Physical Locks:	%d
 NW Semaphore Requests:				%d
 Max. Simultaneous Semaphores:		%d
 
Messages Sent:	%d
 
Num. of Watchdog Packets Sent:	%d
 Num. of Clients Watchdogged:	%d
 
Num. of Files Salvaged:			%d
 Num. of Files Salvage Failures:	%d
 
Num. of Hybrid Check Failures:	%d
 
Num. of New FS Entries Found:			%d
 Num. of Lost FS Entries Encountered:	%d
 
Num. of FS Dir. Cache Misses:	%d
 Num. of FS Dir. Cache Hits:		%d
 
Num. of Read-Ahead Cache Hits:		%d
 Num. of Read-Ahead Cache Misses:	%d
 CreateMBX DownMsgThread SYS$SYSDEVICE PWVN$XQP_THREADS STARTUP: XQP: Error getting sytem version information. $GETSYI Status = 0x%08X
 V5.5 STARTUP: XQP+ is not present/installed. $GETSYI Status = 0x%08X
 STARTUP: SYSGEN parameter VMSD2 value is 0. XQP+ cannot be enabled.
 STARTUP: SYSGEN parameter XQPCTLD1 value is 0.  XQP+ cannot be enabled.
          Please refer to PATHWORKS Installation guide for more information about setting up XQP+
 STARTUP: PWVN$XQP_THREADS value is being lowered from %d to %d
 STARTUP: Error enabling XQP+. $ASSIGN Status = 0x%08X
 STARTUP: Error checking status of XQP+ threads. $QIOW Status = 0x%08X
 STARTUP: XQP+ status; Threads-mapped: %d  Threads-active: %d
 STARTUP: Allocating %d additional XQP+ thread(s)
 STARTUP:     Error allocating XQP+ thread, $QIOW status = 0x%08X 
 STARTUP: Deleting %d additional XQP+ thread(s)
 STARTUP:     Error deleting XQP+ thread, $QIOW status = 0x%08X 
 STARTUP: Error checking status of XQP+ threads. $QIOW status = 0x%08X
 STARTUP: XQP+ status; Threads-mapped: %d  Threads-active: %d
 STARTUP: XQP+: Error enabling deferred cache writeback. $QIOW Status = 0x%08X
 PWVN$LIC_SPECIAL_OBJ_LIMIT PWVN$FSLR_LOGIN TRUE PWVN$BYPASS_LIC TRUE PWVN$DISABLE_PTS_PANIC TRUE STARTUP: PTS PANIC disabled
 PWVN$DISABLE_ERASE_BLOCKS TRUE STARTUP: Erase disk blocks disabled
 PWVN$LOG_LOGIN_INFO TRUE STARTUP: Log Login-Info enabled
 PWVN$DIAGNOSE_HEAP TRUE STARTUP: Diagnose heap enabled
 PWVN$ALLOW_MORE_CONNECTIONS PWVN$ALLOW_MORE_CONNECTIONS has been defined - server can support more than %d connections
  InitAsynEvents() InitAsynEvents::EnableAsyncOnSocket() GetServerID() PWVN$DIAG_DUMP_OPENFILES_TIME Registering as event agent
 Status %02.2X from registering as event agent
     -- Begin debugging data
 control->Time_BitMap[%d] = 0%X
 bit = 0%X, 1 << bit = 0%X
 (control->Time_BitMap[ byte ]) & (1 << bit) = 0%X
 -- End debugging data
 NOT-KNOWN NOT-LOGGED-IN Rcvd watchdog reply %02X from NCID %02X; no match found with address  %02X   
 Failed setting LOG_THIS_GUY_OUT_BIT flag for VCID %04X; ccode = %02X
 NOT-KNOWN NOT-LOGGED-IN Rcvd watchdog reply N from VCID %04X (NCID %02X, username %s); logout failed with %02X
 Failed clearing WD count for VCID %04X; ccode = %02X
 Failed updating Last PacketInterval for %04X; ccode = %02X
 LNM$DCL_LOGICAL PWVN$LOG_CONNINFO_CID    PutSystemConfig()   eng NWSap() NWSapOpenChannel() SAPThread::EnableAsyncOnSocket() ERROR: can not allocate server object table
 Creating network table with %d servers
 SapThread() NET_ADDRESS NET_ADDRESS NET_ADDRESS Internal SAP Socket not found in socket table.  Server Down.
 Get Nearest Server Give Nearest Server SAPTimer SpawnSAPTimer() NET_ADDRESS NET_ADDRESS ERROR: can not allocate server object table
 Expanding network table to %d servers
 Sap timer is %d seconds late 
 Last SAP: %d; Curr SAP: %d
 OUT:	[A:FFFFFFFFFFFF]	%s
 IN:	[A:%02X%02X%02X%02X%02X%02X] 	Hops: %2d	Name: %s
 w NWSapTrackControl() %s
 SYS$OUTPUT: Log file closed
 a NetWare Print Server
WARNING - Log file %s in use
 %s %s %s %s w Log file %s opened
 %s built on %s
 PATHWORKS V1.0-611F for OpenVMS (NetWare) 04/05/98 .SYSTEM] PWVN$VOLCONF.SYS   rb wb   TLThread: InitTransportPacket pool failed! Exiting...
 TLThread: EnableAsyncOnSocket Failed! Exiting...
 PWVN$XPORT_NOTAVAIL_LIMIT TlThread: GetFreetransportPacket failed with cc=%d; NO recv transport buffers; AccCnt = %d 
 Invalid packet received with Cid = %d ; req_type= %08Xh; pkt dropped 
 For above: the REQUEST_NCP (Not TRUE_NCP) is:
   %02X 
 TLThread: Creating a new client thread: cid = %4d
 NCPEngineThread   
tpacket.c; GetFree, freelist blown RACE CONDITION DETECTED! 
STATE MASK = %d 
ADDRESS = %x tpacket.c; GetFree PACKET corrupted! 
TPACKET ERROR in ReleaseTransportPacket, Packet corrupt
 PWVN$TRANSREADPOOL_VIEW.TXT w Transport Read Packet Pool.  PACKET_INUSE=<%08X>; PACKET_FREE=<%08X>;
 Size of Transport Read Packet = <%08X>;  Number of bytes displayed for each Packet = <%08X>;
 Beginning Address of Pool = <%08X>; Number of Read Transport Buffers Allocated = <%08X>;

 
Buf <%08X> @%08X:  %02X%02X%02X%02X  
                            eng Invalid NCP received from:   %02X 

   RequestType:           0x%04X
   ServiceConnection:     %d
   SequenceNumber:        %d
   CurrentTask:           %d
   Function:              %d
   SubFunctionStructLen:  0x%04X
   SubFunctionCode:       %d
   PacketSize:            0x%04X
 
   Raw NCP (REQUEST_NCP format) :

      %08X  . %c     %02X
 
   NetWare error code returned to client: %08X

   : MAIL %X / NCPMoveFileDir: ConvertTokenStringToCString() failed : CID = %0xh 
 %s %s CID = %0xh 
  OBJ_SUPERVISORS /MAIL/%x OBJ_SUPERVISORS /MAIL/%x    .         LOGIN LOGIN / /    / Could not get the client address from NCP to verify license; Conn Num = %d
 netbios/streams/ipx Unable to communicate with Lic Reg to verify license; Conn Num = %d
 Call to Lic Reg to verify license returns unknown status = %d
 Could not get the client address from NCP to release license; Conn Num = %d
 netbios/streams/ipx Unable to communicate with Lic Reg to release license; Conn Num = %d
 Call to Lic Reg to release license returns unknown status = %d
  LOGIN LOGIN WARNING: inNCP is NULL in NCPDestroyServiceConnection
 WARNING: outNCP is NULL in NCPDestroyServiceConnection.
 WARNING: outNCP is NULL in NCPDestroyServiceConnection for connection %05d.
 %s station %d cleared.  Connection terminated. NOT-LOGGED-IN   / / / / / / /   / / /   LOGIN LOGIN %d  ODS2 DEVICE ID  /   :   *.* *.* / *.* *.* / *.* *.* *.* . / / *.* / *.* /   SYS SYS SYS SYS HOST_ID HOST_ID NWEngInitInNCP() NWEngInitNCPPool() Sunday Monday Tuesday Wednesday Thursday Friday Saturday January February March April May June July August September October November December Authors:  Grover (Bluto) Righter  Bryan (Gee Wally) Sparks  Drew (Aardvark) Spencer  Tom (Yellowj                                                                                                                                                                                                                                                   &                        * $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              k "     K       acket) Fulton  Dave (Col. Flagg) Hefner  Paul (The Terminator) Cameron  Mike (Radar) Fritch  Hashem (Playboy) Ebrahemi  Karl (Enigma) Walbrecht  Tim (Tweety) Bird  Nikki (Responsible Adult) Bennett  Shelly (Howdy) Dowdy  Marie (Hot Lips) Jackson  Craig (The Toy) Toyama  Curtis (The Owl) Johnson  Testing geeks  and many more.  PWVN$EVENT_TABLE_SIZE ScheduleEvent: FunctionCode (%d) beyond limit (%d)   
 EVNET.C: Nomore event slots, EvtCode=%d, period=%d   cid = %7d 
 fid=  %6Xh 
  other=  %08Xh 
 Registered as event agent.
 Shutdown signal in async events
 Error. Register as event terminated.
  DUMP of Event Tables: max_events = %d 
 
  TotalEventsEntered  = %d , CurrentEventsEntered = %d 
 evtidx	flags	timingctr	period	agent	funccode  cid/fid                    Time 
 %6d %6d %8d %12d %6d %8d    %15d    %02X  %08Xh                           
  **********End of DUMP of Event Tables: *************** 
 CurBatchEvtCtr table: 
 index= %3d  Value = %6d 
  ###############################################################################
 %s  StartupSpooler() StartupSpooler() %s/%04x.SPL LST:  HOST_ID SYS$SYSDEVICE:  StartUpAllocMem() NWFree() NWrealloc() Overwriting allocated block.
    MemPoolAlloc: Block stamp trashed!
 Pid = %d
 In MemPoolAlloc MemPoolAlloc: Checksums don't match!
 Pid = %d
 In MemPoolAlloc MemPoolFree: Checksums don't match!
 Pid = %d
 MemPoolFree: Block stamps don't match!
 Pid = %d
 CoalesceMemPool: Checksum mismatch!
 Pid = %d
 CoalesceMemPool: Block stamp mismatch!
 Pid = %d
 
Memory pool at 0x%x:
 Pid = %d
 %s
 Free list head = 0x%x    (%d free blocks)
 currentInUse, peakInUse, maxMemAvailable = %d, %d, %d
 initialSize, blockHeadPtr = %d, 0x%x
 allocFreeFunctions = %d
 accessSemaphore = %d
 0x%x: end: 0x%x  size: %u  next: 0x%x
 ValidateMemPool: Block stamp trashed!
 ValidateMemPool: Checksums don't match!
  /JF .QUE Netware/SRC v1.0D QMS file /*.* %s%s File %s finished on %s:%s %s/JB%s.%03d    Q_%0X / QUELIb.c CreateNWQueue: ERROR: after SeparatePath = %0xh 
 Q_OPERATORS Q_SERVERS Q_OPERATORS Q_USERS    STARTUP: QMS: ERROR - unable to allocate queue management system memory
 STARTUP: QMS: SYSGEN SCSNODE not defined; $GETSYI status = 0x%08X
 STARTUP: QMS: Queue file for queue %s contains obsolete record format.
               Queue is not available for use.
 STARTUP: QMS: Created queue %s
  UpdateRecordFileHeader RemoveFromRecordFileFreeList REWRITE: FAILURE, Bad record number passed! 
   r shr = get /* /*   %x %o %d    NVT_SERVER_NAME NVT NVT_GETTY_ENTRY NVT_INIT NVT_SPAWNS NVT_LINE_DISCIPLINE LOAD_NVT SPX SPX_FLAG LOAD_SPX NETBIOS NETBIOS_FLAG NETBIOS_SHIM NETBIOS_MODULE SAP_FLAG SAP START_SAP SAP_STANDARD_OUT SAP_ERROR_OUT SAP_REPLY_DELAY INTERNAL_NETWORK VMS_REQUEST_TYPE PRIORITY LAN_0_ADAPTER LAN_1_ADAPTER LAN_2_ADAPTER LAN_3_ADAPTER LAN_4_ADAPTER LAN_5_ADAPTER LAN_6_ADAPTER LAN_7_ADAPTER LAN_8_ADAPTER LAN_9_ADAPTER LAN_10_ADAPTER LAN_11_ADAPTER LAN_12_ADAPTER LAN_13_ADAPTER LAN_14_ADAPTER LAN_15_ADAPTER LAN_0_NETWORK LAN_1_NETWORK LAN_2_NETWORK LAN_3_NETWORK LAN_4_NETWORK LAN_5_NETWORK LAN_6_NETWORK LAN_7_NETWORK LAN_8_NETWORK LAN_9_NETWORK LAN_10_NETWORK LAN_11_NETWORK LAN_12_NETWORK LAN_13_NETWORK LAN_14_NETWORK LAN_15_NETWORK LAN_0_ADAPTER_TYPE LAN_1_ADAPTER_TYPE LAN_2_ADAPTER_TYPE LAN_3_ADAPTER_TYPE LAN_4_ADAPTER_TYPE LAN_5_ADAPTER_TYPE LAN_6_ADAPTER_TYPE LAN_7_ADAPTER_TYPE LAN_8_ADAPTER_TYPE LAN_9_ADAPTER_TYPE LAN_10_ADAPTER_TYPE LAN_11_ADAPTER_TYPE LAN_12_ADAPTER_TYPE LAN_13_ADAPTER_TYPE LAN_14_ADAPTER_TYPE LAN_15_ADAPTER_TYPE LAN_0_MODULE LAN_1_MODULE LAN_2_MODULE LAN_3_MODULE LAN_4_MODULE LAN_5_MODULE LAN_6_MODULE LAN_7_MODULE LAN_8_MODULE LAN_9_MODULE LAN_10_MODULE LAN_11_MODULE LAN_12_MODULE LAN_13_MODULE LAN_14_MODULE LAN_15_MODULE    CLUSTER CLUSTER_VOLUMES CLIENT_STACK LONG_NAME_SUPPORT CONFIG_VERSION CONFIG_FILE_VERSION VOLUME VOL HYBRID_VOLUME SECURITY SHM_SIZE SHARED_MEMORY SHM_KEY SHM_ACCESS IPC_ACCESS MAX_CONNECTIONS CONNECTIONS MAX_VOLUMES MAX_VOLS DEBUG_OPTIONS DEBUG FILE_SERVER_NAME FS_NAME SERVER_NAME SERVER LANGUAGE MSG_LANGUAGE NET NETWORK NET_NUMBER NETWORK_NUMBER MAX_PROCESSES MAX_PROCESS MAX_PROCS SPAWN_AHEAD_PROCESSES SPAWN_AHEAD_PROCS CLIENTS_PER_PROCESS CLIENTS_PER_PROC LOGIN_ENABLED LOGIN LOGIN_STATUS TTS_ENABLED TTS TTS_STATUS TTS_LOCATION TTS_BACKOUT_FILES TTS_BACKOUT WRITE_BEHIND_FLAG WRITE_BEHIND READ_AHEAD_CACHE_FLAG READ_AHEAD_CACHE READ_AHEAD_CACHE_BLOCK_SIZE DIR_CACHE_ELEMS DIR_CACHE_SIZE DIR_CACHE_ITEMS NATIVE_LOCKS HOST_LOCKS BLEED_THROUGH_LOCKS CONSOLE_FLAG CONSOLE PRINT_MESSAGES CONSOLE_DEVICE CONSOLE_DEV ERR_LOG_FILE_SIZE LOG_FILE_SIZE ERR_LOG_FILE PTR_LOOP_DELAY PRINT_DELAY PRINT_CHECK_TIME PRINT_CHECK_TIME_DELAY SALVAGE_UTILITY_FLAG SALVAGE_UTILITY SALVAGE_UTIL_FLAG SALVAGE_FLAG SAVE_DELETED_FILES SALVAGE_NUM_FILES SALVAGE_MAX_BYTES CAPTURE_UTILITY_FLAG CAPTURE_UTILITY CAPTURE_UTIL_FLAG CAPTURE_FLAG PASSWORD_ENCRYPTION REQ_PASSWORD_ENCRYPTION PASSWORD BINARY_LOCATION BINARIES EXECUTABLES EXEC_LOCATION ULIMIT MAX_FILE_SIZE NEAREST_SERVER_RESPONSE_DELAY LOG_WATCHDOG_LOGOUTS DISPLAY_WATCHDOG_LOGOUTS ALERT_DIST_LIST ALERT_NOTIFY_LIST ACCOUNT RECORD_TYPE REC_TYPE RECORDTYPE RECORD SAVE_STATS USE_SAVED_STATS CLIENT_AUTO_CONNECT AUTO_CONNECT AUTO_RECONNECT MAX_FILES_PER_CLIENT CREATOR_ACE MAX_DIR_SEARCHES DEFERRED_CLOSE BASEPRIOR ASTLM BIOLM DIOLM BYTELM ENQLM FILLM JTQUOTA PGFLQUOTA PRCLM TQELM WSDEFAULT WSEXTENT WSQUOTA  **Error creating semaphore at %08X; status = %08X
 **Error destroying semaphore at %08X; status = %08X
 **Error locking semaphore at %08X; status = %08X
 **Error locking shared semaphore at %08X; status = %08X
 **Error unlocking semaphore at %08X; status = %08X
  MakePathString error - thread-id %08X, pos:%d, len:%d
 GetLastElementFromPath() failed: len of path (%d) excceeds DOS max limit( %d) 
 . .. %s (index(%d) + tokenlen(%d)) > %s (%d)
    StartupServerInfo() No memory for NW Engine List
 StartupServerInfo() DestroyEngines() IncNWEnginePackets() IncNWEnginePackets2() IncNWEngineClientCount() IncNWEngineClientCount2() DecNWEngineClientCount() DecNWEngineClientCount2() RemoveNWEngine() RemoveNWEngine2()  StartupVolumeTable() StartupVolumeTable() Can't add duplicate (cluster) volume %s
	Check cluster members for duplicate volume name.
 ] NWDMain() NWDMain()  I_AllocAheadSLList routine: Failure to allocate memory
 I_AllocAheadSLNode routine: Failure to allocate memory
 
 key = %s   hash index = %u     LOGGED     LOCKED_EXCLUSIVE by client %d, task %d     LOCKED_SHAREABLE by %d client/tasks.     loggingCounter = %d 
   StartupSemaphores   StartupPhysicalLocks Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module Physical lock module    StartupLockManager  StartupStatsStruct() StartupStatsStruct() Error returned from getdata in GetCacheHits: %d
 Error returned from getdata in GetCacheMisses: %d
   PNW_MSG_FAILURE:  Error getting error msg (%d).
 (%s)  %s
 
 Inform() couldn't print msg %s.
 %s  
 Inform: The previous message was not written to sys:\system\sys$log.err.

 
%s %08X:%08X
 %s 
 PNWError:  Couldn't open/create error file.
 PNWError:  Couldn't open/create error file.
 PNWError:  Couldn't get file size of log file.
 PNWError:  Unable to create old log file.
 PNWError:  Unable to recreate log file.
 r PNW_FAILURE:  Unable to open error message file.
 %[^:]:%[^
] r PNW_FAILURE:  Unable to open error message file %s.
 PNW_FAILURE:  Error message file %s empty.
 .OLD OLD %s  Error doing cache %s ; file: %s, cache handle: %d 
 %PWNC-E-CLOSING, file is being closed %PWNC-E-BADCOUNT, count to read exceeds max %PWNC-E-BCBQINSERR, error inserting BCB on queue %PWNC-E-ERRALLOCCACHEMEM, error allocating cache memory %PWNC-E-ERRALLOCCACHECTRL, error allocating cache control memory %PWNC-E-DIRTYBUFRATIOTOOBIG, dirty buffer ratio too big %PWNC-E-DIRTYBUFRATIOTOOSMALL, dirty buffer ratio too small %PWNC-E-CACHESIZNOTMULT, cache size is not a multiple of buffer size %PWNC-E-CACHEBUFSIZNOTMULT, cache buffer is an 'odd' size %PWNC-E-CACHECONFIGURED, InitCache already called -- cache configured %PWNC-E-CANTGETCACHELOCK, can not acquire cache configuration lock %PWNC-E-BASENEGVALUE, dummy error message -- report is ever received %PWNC-E-ERRDISKREAD, diskread failed %PWNC-E-ERRDISKWRITE, diskwrite failed %PWNC-E-ERRLOCKBUFS, error locking cache buffers %PWNC-E-ERRLOCKSTRUCTS, error locking cache data structures %PWNC-E-IOERR, i/o error occurred on file %PWNC-E-ERROR, error completion %PWNC-F-FAILURE, failure completion %PWNC-E-FFLUSHINITERR, error starting file flush threads %PWNC-E-FILEALREADYOPEN,                                                                                                                                                                                                                                                   '                        td $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ! "     \        file already open for caching %PWNC-E-FLUSHINTERVALTOOSMALL, flush interval too small %PWNC-E-FUNCACCVIO, no access to function address specified %PWNC-E-ILLDIRTYBUFRATIO, illegal dirty buffer ratio %PWNC-E-ILLFLUSHINTERVAL, illegal flush interval %PWNC-E-INCOMPATVERSION, incompatible interface version %PWNC-E-INVARGADDRESS, invalid argument address -- argument could not be accessed %PWNC-E-INVCACHEBUFSIZE, invalid cache buffer size %PWNC-E-INVCACHEFILEDSC, invalid cache file descriptor %PWNC-E-INVCACHESIZE, invalid cache size %PWNC-E-INVNONCACHESIZE, invalid noncache size %PWNC-E-MAXFILESREACHED, maximum number of open cache files reached %PWNC-E-NOMEM, out of memory %PWNC-E-NONCACHESIZNOTMULT, noncache size is not a multiple of buffer size %PWNC-S-SUCCESS, normal successful completion %PWNC-E-TFLUSHINITERR, error starting threshold flush threads %PWNC-E-TOPNEGVALUE, dummy error message -- report is ever received %PWVNC-E-UNDEFINED, undefined cache error: %X 
     SetConnectionCommInfo failed!!! in SetClient 
 StartupComm() netbios/streams/ncp BuildNCPMuxChannel: t_open() of netbios/streams/ncp failed - 1
 netbios/streams/ipx BuildNCPMuxChannel: t_open() of netbios/streams/ipx failed - 2
 BuildNCPMuxChannel: BindToSocketFailed() failed %d
 PWVN$CONNECTIONS_PER_256 BuildNCPMuxChannel: SET_MAX_CLIENTS failed
 BuildNCPMuxChannel: t_ioctl(I_LINK) failed %d
 netbios/streams/ncp BuildNCPMuxChannel: t_open() of netbios/streams/ncp failed - 2
 BuildNCPMuxChannel(): t_optmgmt(PWRK_HANDLE) failed
 BuildNCPMuxChannel: AllocReadWriteBuffer() failed
 BuildNCPMuxChannel: MarkEngineForUse() failed
 netbios/streams/ncp netbios/streams/ipx OpenChannel() - t_bind Failed!
 EnableAsyncOnSocket: StreamAsync() failed %d
 EnableAsyncOnSocket: t_optmgmt(PWRK_ASYNC_ENABLE) failed %d
 GetPacket: PWVNStreamPostRecv() failed %d
 GetPacket: PWVNStreamRecvList() failed %d
 GetPacket: t_rcvudata() failed %d
 t_rcvudata 	 Call t_look()...
 t_look() did not return T_UDERR t_rcvuderr GetPacket: t_rcvudata() returned T_MORE, rcv_flags says there is more data...
 SendPacket: PWVNStreamSendList failed %d
 SendPacket: t_sndudata() failed %d
 t_sndudata 	Flow controlled: TFLOW
 netbios/streams/ipx netbios/streams/ncp netbios/streams/ncp netbios/streams/ncp netbios/streams/ncp netbios/streams/ncp netbios/streams/ncp netbios/streams/ncp netbios/streams/ipx PWVN$TRANSWRITEPOOL_VIEW.TXT w Transport Write Packet Pool.  Beginning Address of Pool = <%08X>;
 Size of Transport Write Packet = <%08X>;  Number of bytes displayed for each Packet = <%08X>;
 Number of Write Transport Buffers Allocated = <%08X>;

 
Buf <%08X> @%08X:  %02X%02X%02X%02X  
                            StartupConnectionTable() PWVN$TRIGGER_CT StartupConnectionTable() StartupConnectionTable()   Trigger Pkt Msg: PktEnqued = %d, CID  = %d
     Working NCP is:
           Queued NCP is:
               NCP that caused Trigger Message is 
   
 Received msg from connection with low byte zero, high byte not zero, %04X
 
  **** Begin Connection Info ****** 
 
  Connection ID = %5d
 
  Connection ID = %5d
 
 **** End Connection Info ***** 

 Obj. Name= %s ;  Obj. Name = NULL ;  
Flags = %04Xh ;  StatusFlag= %04Xh ;  WatchCt= %d ; ExpSeq = %d ; WorkSeq= %d ; PktEnq = %d ;  DuplPktCtr = %d ; TrigMsgCtr = %d 
 TOTALDuplicatePktCtr = %d ; TOTALTriggerMsgCtr = %d 
  Login info for client thread: cid = %d
 Obj. Name= %s ;  Obj. Name = (NULL) ;  
 Lic. ObjType =   Unknown  Regular  Special  %d  ;  Lic. Status  =   Holding  NotHolding  %d  ;  ipxaddr =  %02X   %02X   %02X ;  ObjType =   USER  FS  %04d  ;  %02X   
 PWVN$CONNTABLE_VIEW.TXT w CONNECTION TABLE
 	Total_DuplicatePktCtr = %u
 	Total_TriggerMsgCtr = %u
 ====================================================================

 
CONNECTION_ENTRY @%08X SlotInTable: %04X Flags: %04X StatusFlags: %02X ClientType: %02X
 LoginTime =  %02X    LoginTimeInMinutes: %08X WatchdogCount: %08X LastPacketInterval: %08X
 ExpectedSeqNumber: %02X workingSeqNumber: %08X MaxBufferSize: %04X LocalFileTable: %08X
 Message1: %08X Message2: %08X ObjectType: %04X ObjectName: %08X ObjectID: %08X
 OpenFiles: %08X Requests: %08X WriteBytes: %08X ReadBytes: %08X RecentRequests: %08X RecentWriteBytes: %08X
 RecentReadBytes: %08X ConnectTimeCheck: %08X NumEquivs: %08X Equivs: %08X HandleTable: %08X
 FileSequenceNum: %08X FileSearchContext: %08X Packet: %08X PacketSize: %08X WorkingPacket: %08X
 WorkingPacketSize: %08X outPacketLength: %08X
 outPacket: %08X PacketAcquired: %08X PacketEnqueued: %04X PacketSync: %04X CommInfo: %08X LogKey: %08X
 SpoolerInfo: %08X HybridUserStruct: %08X memDebug: %08X EngineProcessID: %08X Undefined: %08X
 ipxaddr =  %02X   %02X   %02X   pwvn_obj_type: %08X pwvn_lic_status: %08X DuplicatePktCtr: %08X 
TriggerMsgCtr: %08X
 HOST_ID HOST_ID * /MAIL/%X /MAIL/%X 
 Dumping Object: 
 ID     = %08X h %d d
 Type   = %X h %d d 
 Name   = %s 
 Flags  = %X 
 Secu   = %X 
 Prop   = %X 
 Hash   = %X 
 
 Press RETURN to continue >   OBJ_BACK_LINKS * OBJ_BACK_LINKS DYNBINDCACHE module: Failure to allocate memory
 DYNBINDCACHE module: Failure to allocate memory
 DYNBINDCACHE module: Failure to allocate memory
  I_AllocAheadAceCache routine: Failure to allocate memory
   *   SYS SYSTEM/ SYSTEM/ SYSTEM/ .system] SYS CreateBinderyFiles() SYSTEM/ CreateBinderyFiles() SYSTEM/ CreateBinderyFiles() SYSTEM/ CreateBinderyFiles() CreateBinderyFiles() CreateBinderyFiles() CreateBinderyFiles() CreateBinderyFiles() GUEST SUPERVISOR GUEST EVERYONE GROUP_MEMBERS GROUP_MEMBERS GROUP_MEMBERS PASSWORD GROUPS_I'M_IN SECURITY_EQUALS GROUPS_I'M_IN SECURITY_EQUALS PASSWORD GROUPS_I'M_IN SECURITY_EQUALS GROUPS_I'M_IN SECURITY_EQUALS USER_DEFAULTS USER_DEFAULTS SYS Add Server Object SYS OpenBinderyFiles() SYSTEM/ OpenBinderyFiles() SYSTEM/ OpenBinderyFiles() SYSTEM/ OpenBinderyFiles() OpenBinderyFiles() OpenBinderyFiles() OpenBinderyFiles() SYS InitBindery() InitBindery() PWVN$TRUSTEECONTROL PWVN$TRUSTEELOCK PWVN$FILE_SERVER_NAME PerformTrusteeSync: Error (%d).
 TrusteeBlockingAST2: Error (%d).
 TrusteeBlockingAST: Error (%d).
 TrusteeClusterLock: Error (%d %d) getting exclusive trustee lock.
 TrusteeClusterLock TrusteeClusterLock TrusteeClusterLock: Error (iosb %d) converting to PWMODE.
 TrusteeClusterLock TrusteeClusterLock: Error (status %d) converting to PWMODE.
 TrusteeClusterLock TrusteeClusterLock: Error (iosb %d) converting to CWMODE.
 TrusteeClusterLock TrusteeClusterLock: Error (status %d) converting to CWMODE.
 TrusteeClusterLock TrusteeClusterLock: Error (status %d) dequeuing lock.
 TrusteeClusterLock TrusteeClusterLock: Error (%d %d) getting exclusive trustee lock.
 TrusteeClusterLock TrusteeClusterLock TrusteeClusterLock: Error (%d, %d) initializing lock.
 TrusteeClusterLock: Error (%d %d) converting to CWMODE.
 TrusteeClusterLock TrusteeClusterLock TrusteeClusterLock: Error (status %d) dequeuing lock.
 TrusteeClusterLock BroadcastToOtherServers BroadcastToOtherServers BroadcastToOtherServers FindTrusteeDNode CreateTrusteeDNode GetTrusteeDNodeUserList FindTrusteeDNode CreateTrusteeDirUserEntry   No memory for trustee file struct
 .system] Netware/SRC v1.0 TFILE  .system]    .system] Netware/SRC v1.0 TUSER  .system]   Failure to setup cluster trustee lock
 StartupTrustee() StartupTrustee() Failure to setup cluster trustee lock
 
InitTrustee: DJMount returnError code %d  InitTrustee()   SYSTEM MAIL PUBLIC LOGIN CreateTrusteeDJNumFile:  Failed to alloc memory
 .system] CreateTrusteeDJNumFile:  Failed to alloc memory
 SYSTEM/ Netware/SRC v1.0 T_DJNumFILE  CreateTrusteeDJNumFile:  Failed to alloc memory
 .system] CreateTrusteeDJNumFile:  Failed to alloc memory
 SYSTEM/ DJDeleteEntries failed in DJMountDNodes
 DJDeleteEntries failed in DJMountFNodes
 DJDeleteEntries failed in DJMountUNodes
  No memory for new object list
  .system] Netware/SRC v1.0 TDNODE  .system]  StartupAccounting() .system] net$acct.dat   SYS$SYSTEM:SYSUAF.DAT SYS$SYSTEM:SYSUAF.DAT      .  ..  dummy routine called
 StartupFSFile() StartupFSFile()  error allocating CACHE memory
 init ITNS$_ACCESS 0 00:%d:%d.00 Error locking OpenFileSema
 Error unlocking OpenFileSema
 close PWVNError: Close of file %s failed with code %d
 FSIDeferredCloseFile: Error returned from PLM_fileunlock - %d
 flush on deferred close WARNING: CloseFile has found duplicate copies of shared open file [%s line %d]; continuing...
 NW$BLD_ROOT:[NW.SERVER.SRC]FILE.C;1 read read release read release flush FSIWriteFile() write write write  . .. /LOGIN /SYSTEM PWVN$VOLCONF.SYS PWVN$VOLCONF.SYS PWVN$LOGFILES .PRINT] *.*;* PWVN$LOGFILES .PRINT]  OpenCreateFile: PWVN_getFileId failed - %d
 OpenCreateFile: Incompatible open mode requested on a shared volume
 OpenCreateFile: PLM_fi                                                                                                                                                                                                                                                   (                        {Oǣ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ǡ "     m       lelock failed - %d
 OpenCreateFile: PWVN_getFileId failed - %d
 OpenCreateFile: Incompatible open mode requested on a shared volume
 OpenCreateFile: PLM_filelock failed - %d
 OpenCreateFile: PWVN_getFileId failed - %d
 OpenCreateFile: Incompatible open mode requested on a shared volume
 OpenCreateFile: PLM_filelock failed - %d
 open open OpenCreateFile: PWVN_getFileId failed - %d
 OpenCreateFile: Incompatible open mode requested on a shared volume
 OpenCreateFile: PLM_filelock failed - %d
 flush close OpenCreateFile: plmLockFlag set when opening a file on a shared volume - unlocking
 OpenCreateFile: Error returned from PLM_fileunlock - %d
  close dc1 open dc1 close dc1 open dc1 close dc1  close ; PWVN$CACHE_NUMBUFFERS PWVN$CACHE_FLUSHRATIO PWVN$CACHE_FLUSHINTERVAL PWVN$ALLOC_DISKBLOCKS PWVN$EXTEND_DISKBLOCKS PWVN$TRUNCATE_DISKBLOCKS PWVN$CACHE_BUFFERSIZE %s is less than min value(%d); FS uses %d
 %s is greater than max value(%d); FS uses %d
 %s has been defined with value %d
 %s is not a multiple of %d; FS uses %d
 %s is not defined; FS uses default %d
 PWVN$DISABLE_LM_VERIFY_MODE TRUE PWVN$DISABLE_LM_VERIFY_MODE = TRUE, disabling LM mode check.
 FALSE PWVN$DISABLE_LM_VERIFY_MODE = FALSE, enabling LM mode check.
 Open File List for this client is empty.
 Open File List 
  S.No  OpenCt   Intern.Flags,  FileAttr   NWOpenFlags   LMOpenFlags  VolName   DOSfileName
 %3d %7d         %0xh             %0xh         %s         %0xh          %s    VolName_NULL       %s   PAthNAME_NULL  
 Open File List for this client is empty.
 PWVN$OPEN_FILE_CACHE_VIEW.TXT w There are a total of %d files on the SharedOpenList

 *** SharedOpenList: <is empty>

 There are a total of %d files on the SharedCloseList

 *** SharedCLoseList: <is empty>

 *** SharedCloseList:
 *** OpenFileList[%02d]:
 	SHARED_OPEN_FILE = %08x
 	Semaphore      %08X
 	unique_number  tvol = %02X, node = %04X %04X %04X, u_num = %04X %04X %04X, forkType = %02X
 	HostVolNum     %02X
 	VMSVolListPtr  %08X
 	OpenCount      %08X
 	OpenFlags      %02X
 	FileAttributes %08X
 	ForkType       %02X
 	Channel        %04X
 	FileSize       %08X
 	DosName        %s
 	ACE_CONTROL    <not shown>
 	VMSmodtime     %s
 	CloseVMStime   %s
 	FileModified   %d
 	WriteCacheMute %08X
 	WriteCache     %08X
 	ClientList      <empty>
 
		ClientNumber  %02X
 		TaskNumber    %02X
 		OpenCount     %08X
 		OpenFlags     %02X
 
 <empty>
 	BeingDeleted   %X
 	FileType       %02X
 	RMSblock       %08X
 	cacheHandle    %08X
 

  ./ FSIGetVolumeInformation FSIGetVolumeInformation FSIGetVolumeInformation CHECK NOCHECK CONDITIONAL STR*EAM FIX*ED FSIVolumeSetup: setting up a shared volume
 FSIVolumeSetup: error returned from PWVN_getDevId %d
 [ ] (unknown) ODS-2 ISO-9660 High-Sierra Spiralog Ignoring volume - Unsupported FS-Type:%s, Path:%s
 Ignoring volume - Unsupported FS-Type:%s, Path:%s
 AddDeviceToVMSList Accepting volume #:%d, FS-Type:%s, Path:%s
 AddDeviceToVMSList 000000 CHECK NOCHECK STR*EAM FIX*ED /MAIL/* %x /MAIL/ /* /MAIL/ /MAIL/ GUEST HOST_ID   VMS volume-list is being setup...
 VMSParseACL VMSParseACL VMSParseACL VMSParseACL VMSVerifyAces:  Pathworks ACE too big
 VMSReadFileAttributes VMSReadFileAttributes VMSFileFind VMSFileFind VMSFileFind VMSFileFind VMSFileFind VMSFileFind VMSFileFind VMSFileFind VMSTrusteeACE %ld VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSTrusteeACE VMSUpdateDOSNameSpace VMSBackLinkHost VMSBackLinkHost %ld VMSNextFile VMSGetFileName VMSGetFileName VMSBackLink VMSBackLink VMSFoundFile VMSFoundFile VMSForwardLink VMSDirectoryReadAhead VMSmkdir assign VMSmkdir parent VMSmkdir parent VMSmkdir create VMSmkdir create VMSmkdir write VMSmkdir write VMSmkdir close VMSmkdir close VMSmkdir VMSrmdir VMSrmdir VMSrename VMSrename VMSrename VMSrename VMSWriteFileAttributes, status VMSWriteFileAttributes, iosb VMSWriteFileAttributes, acl status VMSWriteRecordAttributes VMSWriteRecordAttributes VMSOpenFile VMSOpenFile VMSOpenFile VMSOpenFile VMSOpenFile VMSReOpenFile VMSReOpenFile VMSReOpenFile VMSReOpenFile VMSCloseFile VMSCloseFile VMSCloseFile VMSCloseFile VMSReadData VMSReadData VMSWriteData VMSWriteData VMSAllocateDiskSpace VMSAllocateDiskSpace VMSAllocateDiskSpace (erase - s) VMSAllocateDiskSpace (erase - i) VMSTruncateFile VMSTruncateFile VMSDeleteFile VMSDeleteFile VMSCreateFile, assign VMSCreateFile, qio create, status VMSCreateFile, qio create, iosb VMSCreateFile, qio erase, status VMSCreateFile, qio erase, iosb VMSCreateFile, deaccess VMSCreateFile, dassgn VMSOverWriteFile VMSOverWriteFile VMSOverWriteFile - erase status VMSOverWriteFile erase iosb VMSGetRootCreateDate VMSGetRootCreateDate DECCacheRead: no bdscs on we DECCacheRead: failed to malloc iosbs DECCacheRead: sys$qio failed DECCacheRead: error returned in iosb DECCacheRead: threadqiow failed DECCacheRead: threadqiow returned error in iosb DECCacheRead: threadqiow (nba) returned error DECCacheRead: threadqiow (nba) returned error in isob DECCacheWrite: no bdscs on we DECCacheWrite: Erase failed DECCacheWrite: Erase failed (iosb) DECCacheWrite: failed to malloc iosbs DECCacheWrite: sys$qio failed DECCacheWrite: error returned in iosb DECCacheWrite: threadqiow failed DECCacheWrite: threadqiow returned error in iosb DECCacheWrite: threadqiow (nba) returned error DECCacheWrite: threadqiow (nba) returned error in isob DECCacheWrite: error from pwn$qiow nba DECCacheWrite: error returned in iosb nba DECcache Thread %d No memory for ClusterServerNamesList
 
Callback Information
 Callback Information
 	Called from PC = %08X
 	Called from PC = %08X
 	Can't trace off of User stack
 	Can't trace off of User stack
 
 
    RMSOpenFile RMSCloseFile RMSConnectFile RMSDisconnectFile 
SEEK FAILURE !!! RMSRewind RMSSeqRead RMSSeqRead RMSRFARead RMSRFARead Bad prefix count %d
 Bad postfix count %d
 RMSResumeThreadAst: Invalid RAB pointer
 RMSResumeThreadAst: Invalid Thread Pointer
 RMSGetAnotherRAB: stv = %d
 RMSGetAnotherRAB RMSGetAnotherRAB: stv = %d
 RMSGetAnotherRAB RMSReadRecord: bad rcontext argument, rabptr == 0
 WARNING:  Possibly invalid record lock is about to be taken out
	RAB = 0x%08X, recnum = %d
 RMSReadRecord: Unexpected return from SYS$GET (0x%08X) reading %s
 RMSReadRecord: Timeout reading %s
 RMSReadRecord: Unexpected completion status from SYS$GET (0x%08X) reading %s
 RMSWriteRecord: Error (%d) during sys$put
 RMSCreateAppendFile: stv = %d
 RMSCreateAppendFile RMSCreateAppendFile: stv = %d
 RMSCreateAppendFile RMSAppendRecord: Error (%d) starting sys$put
 RMSAppendAST: Error (%d) during sys$put
 RMSTruncateAppendFile: Error (%d) during sys$put
 Error : RMSFlushList Full
 Error : RMSFlushList entry not found
 RMSFlushRecordFile: Error getting another RAB
 RMSFlushRecordFile: Error (%d) starting flush
 RMSFlushRecordFile: Error (%d) doing flush
 %02d/%02d/%02d %02d:%02d:%02d   %s; code : 0x%X
 **WARNING ** VMSVolListPtr is retuning NULL;  cid = %d ; VolNum = %d 
 VMSProcessAction VMSForwardLink %d %d %d %d %d VMSGetDOSPath / / .DIR;1 __2E %X .DIR;1 * .* .DIR;1 VMSToDOSTime VMSCreateMutex VMSDeleteMutex VMSAcquireMutex VMSReleaseMutex VMSTryAcquireMutex VMSChkPro VMSClearProtection: Error (%08X) returned in status from pnw$qiow
 VMSClearProtection: Error (%08X) returned in iosb from pnw$qiow
 PWVN$CLUSTERCONTROL Ready to get cluster control lock %s
 Lock %s in use. Waiting.
 PWVN$MAX_LOCK_WAIT_SECS Lock timeout after %d seconds on %s
 Got lock %s with status %08.8X
 PWVN$SVR_%08X getting checking GetFileServerNameLock GetFileServerNameLock  
<-------------------------------------------------------> 
This process has the following attribs/quotas/privs:  
 Username: %s is ultimate source of quotas and privs. 
  [This was the USERNAME in effect during startup.] 
  [Thus, that USERNAME is termed the 'startup username'.] 
 Note: Some process-privs are intentionally being disabled. 
  [This is necessary for proper server behavior.] 
  [Examples are READALL, EXQUOTA, and possibly others.] 
  Thus, remaining privs in effect are:
%s 
  Key resources and quotas are tunable, via the SCONSOLE utility. 
  These are kept in file PWVN$CONF_DIR:PWVN$NWCONFIG.CFG 
  [A few, such as BYTLM, are built into the server.] 
  [The remaining are tunable via the OpenVMS...] 
  [...Authorize utility, upon the 'startup username' acct.] 
 Astlm: %d 
 Bytlm: %d 
 Biolm: %d 
 Fillm: %d 
 Diolm: %d 
 Tqlm : %d 
 Prclm: %d 
 Pgflquota: %d 
 Wssize: %d 
 Wsextent: %d 
 Wsquota: %d 
<------------------------------------------------------->
 ERROR: Can't read disk quotas; status = %08X
  PWVN blocking lock PWVN blocking lock   NLA0: NLA0: PWVN$DOING_INSTALL CMKRNL CMEXEC SYSNAM GRPNAM ALLSPOOL DETA                                                                                                                                                                                                                                                   )                        + $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              Z8 "     ~       CH DIAGNOSE LOG_IO GROUP NOACNT PRMCEB PRMMBX PSWAPM ALTPRI SETPRV TMPMBX WORLD MOUNT OPER EXQUOTA NETMBX VOLPRO PHY_IO BUGCHK PRMGBL SYSGBL PFNMAP SHMEM SYSPRV BYPASS SYSLCK SHARE  READALL  The following privs are required, but not present:
     %s
     %s
  PWVN$CONF_DIR:MBXCFG.SYS w MBA%d
 PWVN$CONF_DIR:MBXCFG.SYS r %s SHUT THIS SERVER DOWN   1-SEP-1993 ftstchk  DIAG_VM<error allocating %d bytes of memory, status=%d> DIAG_VM<attempt to free 0x%08X twice, data corrupt, or not allocated> DIAG_VM<guard word before allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<guard word before allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<guard word after allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<error freeing %d bytes of memory at 0x%08X, status = %d> DIAG_VM<attempt to free 0x%08X twice, data corrupt, or not allocated> DIAG_VM<guard word before allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<guard word before allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<guard word after allocation 0x%08X overwritten with 0x%08X ='0x%08X'> DIAG_VM<error freeing %d bytes of memory at 0x%08X, status = %d>    LNM$SYSTEM PWVN$PROCESS_%08X %d    S U S U    %c S U S S %08x    FSP$Main    PWVN$FAKE_VM_ENABLE PWVN$FAKE_VM_LOG PWVN$FAKE_VM_EFN_OFF PWVN$FAKE_VM_STRING_OFF PWVN$FAKE_VM_CHECK_ACTIVE_LIST PWVN$FAKE_VM_REAL_FREE_OFF MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ,^	eR<0]
((PP7]0]U]US'Vď  VVSTTb<~xq PPbbSjTbkSq PPPP  ^߭ ߭߭up PP߭߭߬cp խPPP ^ЬSSݬ PTTPЬRcRRcݬ RcTP ^ݬ
 PRRP0 ݬ, Pq PRP  ^ЬP׬PQЬP֬Q`ЬP׬PP ^jRޢЏ%QԭЏ   Џ  S䟭p P\\\ߢD\  \p ߢEm PߢN"\   p  ݭ|~S~3   o P\\ߢt[  \p \mo  jo Ĕ^iTTVWZXr`Wp |[Ĝ v[?p (ޮ(QUЏ- PPSPSURPЮ(\(aRlP\P\%$ޮ$QUЏ- PPSPSURPЮ$\$aRlP\P\TPѭ
ݭo o PR,R ĒRo PėZ  Fo PR.RW RVo PZ   n  7   P	 o ЏSă%o PPn PSSЏSS`UĞn PRR ĮRn PUU|`En PR,R YRn P^Y  PvD^tvnr~Џ    |xpЏ   Џ   l< Џ   2n2Џ jhdbĠ m RbЏ Ha<;a<ODybD{bWwbEN} PVVRġ R*%  ,m B?` Q~APR`B  Pkĳ 7X  Rb b b5b^bĔbbb
bIbąbĺbb l DBD8B;W  Sc B~cCcycįc >l A1D< ~ PݮP~` PVVRV~  k 7 ݮM
 PVVRR*  k ͉ЏU   ~ PV͉ $͉ͅ/ ͅ|k P$P ͉U~ PVV\ݮ
 $V~  k  PVVRR*  j wS PVVRR*  j ߭S~^
 ScPVVRUZ~
 PV@q~
 PVa   v@X~cPV?b\~cPVVR	E#a< ~R~PR   	Џ   ?	߭蚏_~Rb߭䚏a~b߭욏`~bPRѭЭY PR#YYz Y']b~ ScPV
]c~cPVKd~cPVؚ߭j~cPVVRѭ

ѭ؏d   ?| i~:Rb?z h~b?l x~bPRlѭ ?p p~Rb?j |~b?h }~byt~ PVVRy ߭Țr~W߭Ěs~EPR!ѭď   ~ݭ( ߭{~
PRѭݭ < ~߭̚k~PR#ѭ̏ @  < @~ݭ < @ݏ   ߭z~?~ l~Rb?t g~b?v ~b?n w~b?r e~b
߭m~APRѭ22ݭ * 2Э1ݏ   ߭n~PR'ѭ   2ݭ2 Џ   ЭW ķ P<W~R  W
߭]~PR"ЭRѭRRݭ Rn߭W~cPR&ѭ   ~ݭ
F S~߭~$PR#ѭ   ~ݭT~ ȭ́V~O	 P́́ ̓v~(	 P̓e ̓ ?x ~?~D PVVR?$?RR


?PRd   d?߭~ "Y oZ ԭ@`:<p ݮ PVVRR*  d `͉T~. PVVR
[@[͉U~	 PVVR1b Wd Z Rd X SY Y U<+~V Pͼ<+~~@~g jͼ\`)͉9 ͉ͼ\/b[-ͼ\2!ͼ\hP#ͼ+ ͼ1ͼ\2/bͼ\0ͼ\.ͼ\,ͼ\*ͼ\(ͼ\*ͅ/bPV͇ͅ=b%͇cPͼ\0 b1 /͇cPͼ\. bb@͇cPͼ\, b>P͇cPͼ\* b]͇cP
ͼ\(V\1+ݼͼ\2O  PͰͼ\2c,gikͼ\hPOͼ\2}xb W ͼV PVV\o\K~gi(Pͼ9V PVV\ā\K~g֭[[͉U~ePVP ͉U~ePVV\1 `~`ݮ ) PVV\ē\*g j@5͉T~ePVV\[@&P[͉U~ePV͉U~ePVV\17ݮ ݮg {f~n PVVR{ AY~H PVVR1 A  A ޮ Uݮ ` PSaЮ \ elRSMR0R9RARZ֑R_БR+ˑR#ƑR.R-R!R&R$R%R@SS>A; -Aͅu~ Pĝ~!
  ` ߭߭ͅS> P ͅħ~"  _ ~~ PV?f ~Rb?d ~b?b ~b w i@}ı~*V  ]_ O< ЭSpSݮRRS PPRSP	R%  _ Sݾ _ ͬͨ﹟ ͬRͨ͸pݸ ȏ   +S  S} ȏ   Sh  RH
 PVVR!ĻR)I    I^ H߭U^ ~} ݭ ߭ A
 ݭ+ A
, >  I! Lh+ ݭ$ <nUU$ WW	% ݭ/% ݭU% ݭ{% ݭ% 2t~9& 2v~]& 2v~H  Sc2n~n& 2r~& {& 2J' `O' 3( :Ds( 2~~) ݭ%* ݭK* 2|~( 2z~( 2x~( ?~#) ݭ) ݭcݭ=) 3$ 2" 2p~#" ݭI" yn" 2l~% ݭ+ 2j~x+ 2h~+ 2f~P, 2b~|, ݭ+ ݭ`* ݭ*        -  T  {        !  OcUݭ~ ȏ   OU OW2 OX</0  PVVR1 ;[ P*<Z ; |ޭRRSͤRRPR\SRSb`SRSPbPSPRcblͤRRS͠RRPR\SRSb`SRSPbPSPRcbl͠E <nRRRDE  Rd11vL  	 
w  I z W ! % )r - 1 5 9z = A E9 I M Q U Y" ] a e i m3 ql u y } ́ ͅ 
 ȏ   MuC  X PR+Rs RrX P C  8̓́8 ȏ   LSRM ͼM PVVRĘRJ~    Īͼ\W Pjͼ/0 PVVR ͼ\ĮR#  {  ͼ\ŏ.  SRByW ͼ\2B{W .L PVV\ͼL PVV\1RhL ͼL PVVRĸRJ~    ͼ\W Pjͼ\2`\=/ PVVRͼ\R# Sͼ\ŏ.  SRByV                                                                                                                                                                                                                                                    *                        0 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            ͼ\2BV K PVV\ͼK PVV\1R~K ͼK PVVRRJ~    ͼ\2c\j. PVVRͼ\R# Sͼ\ŏ.  SRByU ͼ\2BU .J PVV\ͼK PVV\1fJ ͼJ P.	K J PͼJ PK }ޮSĘ\l1 Rݮ
U ݌T T P͜P͜PPR^<^PʏPQPQQR"\P`		R,|  Y  l1j _ PVVRRe~L  )  ?4  PVVRR     ^ PVVRR    ȏ   [H((?   PVVRRQ    ȏ   H`>   PVVRR|g ȏ @  GS;SmS P>SI  Э\LS e PVV\֭SPݭ" ġG>  DT ȏ@   YG&>  ǟ PVVRR    ȏ    Gx ȏ   G PVVRRZ  7  ȏ   F   P
=  #=  3%*R ЭUЭYЭ]<naeЭiЭmЭqG$=  %K'  PV q B {P  l   3 m<  	Ā	͔ |~ݏ   ͔~'  %P P͘Ċ	~+# ͘P 
 |~ݏ  ~  O P͐͌R͐O RRVVRRRċ  {    10 ?\! >&<ğ;       PVVRĿ;      ʹ1 b PVVR1[;       ʹ+ PVVR
4;       N Pw4;  ^	 |~ݏ   ~UC  bN P̈́p	~+` 
P̈́=N \ Pe:      Đ:   ]   ^HSCR/TAõL:     0 dh~
 dN~    AA & g@]@Ώ q Ab   ﮏ    ? b V b % b D b  b ﺲ 	b ۰ 
b   b 9P b  
b '/ b t b  b  b m  P 8  b > ߤ 8   U  Ҏ qM  ^ЬR߭1 Э    ^FR)	8   
<  ~Ym   ^<R ~  ^mFSެRpbݬ@@bD PTTPbP	P%ｾ  L ݬݼL  ^
FR^	 ݭ|~ݏ   ~D@  QK P\p	~+Q \3K P ^ER		 ݭ|~ݏ   ~p"  J P\	~+ \J P ^T Sݬŏ.  TRBTK PЬPB ݬK PTT   ŚP  ^ݬK PPЬP֬`PPP0P9PAPZڑP_ԑP+ϑP#ʑP.őP-P!P&P$P%P@P| ^DUSޣDRb1~ TݬK ݂K J QPQQTV<VPʏPQPQQT"RP`		T,  nb^CS5?  m=	JJ A  PXX\YY<~<~J PTT	I RbJ UePTI Vf
bePTfD
bePTf͸ ͸w
bePTf߭ ~~~~~\L+\L/É
ͺ	bͺè
bePTf߭ ~~~~~\Lz+\Lÿ
ͺ	bͺ
bePTf]   ~~~
bePTf? <~bePTf ~6bePTf߭ ݭSbePTf߭ ݭqbePTf߭ ݭÎbePTf߭ ݭìbePTf? *߭ ݭbePTf
RP	RRG UeG VfPTF Wg? <R3RRefPTg? eR\RRCefPTg ~lefPTg߭' ݭÎefPTgïefPTg߭@ Э2ݭefPTg߭ Э6ݭefPTg߭郎 Э:ݭ
efPTg߭ Э>ݭB
efPTg߭x ЭBݭY
efPTg߭ ЭFݭl
efPTg߭ ЭJݭÅ
efPTg߭H ЭNݭÞ
efPTg߭Ю ЭRݭ
efPTg߭l ЭVݭ
efPTg߭ ЭZݭ
efPTg߭  Э^ݭ
efPTg߭4 Эbݭ'efPTg߭來 ЭfݭBefPTg߭h ЭjݭgefPTg߭t ЭnݭÆefPTg߭ ЭrݭëefPTg߭︮ ЭvݭefPTg߭$ ЭzݭefPTg߭$ Э~ݭ
efPTg߭ Э͂ݭ3efPTg߭ Э͆ݭQefPTg߭ Э͊ݭtefPTg߭ Э͎ݭÈefPTg߭ Э͒ݭìefPTg߭ Э͖ݭefPTg߭0 Э͚ݭefPTg߭D Э͞ݭefPTg߭X Э͢ݭ4efPTg߭l ЭͦݭYefPTg߭ ЭͪݭÂefPTg߭ ЭͮݭåefPTg߭ ЭͲݭefPTg߭  ЭͶݭefPTgY.  PXTt? P  ^?   ^?   ^8\߭ PP  v  
?  ^a8R
 ݭ|~ݏ  ~|= PSPP= P <^8Rԭ
԰֞>ԭİzޭ>ԭ6  O PTP|~߭|~ PSS<SSSGx)  P2\L߭!> PA|~߭|~ PSS<SSS&)  PЭ\2ƏA)  
P"(  k(  P\T\T(  ЭTT   P| <^6UʀSƭ n= |~?XPPTPT
x(  P|~|~ ߭|~8<~  PTP2TTTD8(  <~P~~ŋ(  PЬRPRdPR~'  ܘPPVVRD|~|~ ߭|~߭8<~  PTP<TTT'  PVVPЬRPRcRP~>'  ܘVVRGP|~|~ ߭|~߭8<~  PTP<TTTnA'  PVV|~|~ ߭|~8<~  PTP2TTTů&  <~P~~&  |~|~ ߭|~߭8<~  PTP<TT
T4&  <~P ^4SЏRÃF; PP; PRRЏRRPP ^U4STÞ; PRR îR: PTTP ^4STó: PRR R: PTTP ^3S: PR.R[ RZ: P%   9 PP ^3S9: PR+R R
: P 7%  PP ^93SE9 PR,R YR9 P^$  P ^2S9 PR,Rs ÒRr9 P×$  P ^2RS ·k P<S~_$  SP    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^YIT|R<@~ PUU\d~)   <@~3 PUU\ߤ\)[   ߢ8n  ߢ4ߢ8 J PUU\ߤ7\-  P 0 << ~AX Sc < ~c << ~c < ~c << ~c 	<,~< ~c ~< ~c <  ~c G~< ~c < ~c x~< ~c ߤE <ݏQ 8 PV V< ~c V< ~cߤck"  Q@Y PUU~ߤH"     4^S1 ?<S~ PTT\1 1 ?<S~O PTT\1 1 <S~ PTT\1 ߭6 R<bP P\<\\x\Q P<P\x\\\QQb<Q\\\b<\P P\<\\x\Q P<P\x\\\QQb<S\ \!߭߭<@~Y PTSS1P  ^?  ϷP ^RqBP?<R~ PSS\<R\\ \ﰶ RR/X^FUV%yXoQw 1
 Z<5   T n	5 [߭<~ PP\1ѭ01xS vwSfݭ  PP\1Ů c4 PtRPBoPBc\P\/BoPBc\P\                                                                                                                                                                                                                                                   +                        w $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              cK "            |~w~Sfݭ jRR-ߨ8qq<\\\1PuP0Pr\\\\Ps\\WPWW\\PQЮP\
\P
Q{\PQPQYQЮP\\\P\QPQP{\PPQQI\xT\\\T\tŲ kI~Y kTݮ kI\\\\T~k9kݭ<SS{~[ ߨ8vqqSS1Pt^G&[vVX1/6 Y?<X~ PZZR11 1 vUWe<X~ PZZR1  tuke<X~ PZZR1 2 TDe@De\\Pޭ\\R\QP\PlbP\PRlRPR\`laЭDeWTT TWDe0
0<X~i
PTTWUW<X~ PZZR(Ueݦ4<XSSjo PZZRSiXX1 ^߭t ߭t ŏd   RQRPЭRRPQP{RPQPQ\\_   '\H~x  

<  ~Q 6P\Z   \H~H P\K   \G~,  yt ^H)ZATjU1,1 W?<U~ PVV\1 1 ߭<U~l PVV\1 ѭ
1 '߭<U~Z PVV\
P߭g>XPZ߭g?XS? S?   S<URR߭X2S~C Rr  ? P߭<U~ PVV\:j~/ PYY<U\\M\t P <U~ PVUU1P^'X`@T<߭<@~E PVVRP<`S SR<RRxR\ S<SRxRRR\\``<`S SR<RRxR\ S<SRxRRR\\`?~  PVVR\~~h  q  U/ SURB~ĮcRR	ĳcUU\\ĵ. 1PRRN   1 <~ PVVRR<~ķ  ?<~ *߭<~, PVVR߭z. >W߭f. ?W<~x PVVRR߭Ě~<~{  1h<~߭W
 1SP <~ PVVRR<~m:  h<~- PVVR1R<~ģ  1P 0^<~ PTTP߭- S<cQ QP<PPxPR Q<QPxPPPRRcc<cQ QP<PPxPR Q<QPxPPPRRc<P P?߭߭<@~{ PT ՛   ^P  ^߭o \\ <X~< ~M P Џ    ~L   ^P  ^ t P  ^ \v P  ^<   ~  ,^=S>pRԭЬݬb, P찏Ԟhذ>hԭ 쟭 PhQ<hP@hQQPP< 4^<ToRnҐԐִڐܐԭnn+ Pڰ➢h>hԭ ڟ PhP<h\LhPPSSS+ PU? UU P~   ^   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^qRw PSSPSߢ0* ߭ PSSP-Џ- ߭ ݏ- ݬݭ	 PSݭ SP ^pR PSSPhߢ0]* ߭<~f PSSP=P8 &߭ ݏ- ݬݭȺ PSݭ SP   MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP@^S=TWpSd) ߭<~ݏ  PUURߤR'A  r x5) ߭j Э\Эߣ80 Ä  ߭  <P~i PUURߤR)њ   <P~~ PUURߤR)連   <~ P|ߤ@    dÀ À ߤm  \À P8\P@|\\À Ä PUĕ U~&)  Z * |~ ~[	& PR3~+ܙ PR& vߣh l rRQbs~r~q~p~o~n~m~l~k~j~i~h~6t <Pn͞R 	b͠V<nP P\<\RxRQ P<PRxR\\QQfߣh͒Y' ͜RRb͒B~͞<P~o PX ߭ߣ8 y9 PU ġ ݭ  PU A~ ĭ ݭ 5 PU~ P& ߣhP& |~ PĹ ݭ  PUB~ P&  P Rߣ8To& ߣḧ́s& ͐ߣhD_& ~HR& NRRbDB~P<P~d vߣ8ݣx%  LNߣh% RRbL<P~  ߣ8% ߣh>% J< ߭<P~ PUU\#\    C% g x PgÄ R<bP P\<\\x\Q P<P\x\\\QQ1$Q1-ݭe <P P\<\\x\Q P<P\x\\\QQQ\\  1 R? ߭ﻉ ߭ ŭP<\P\\<P\P.P?\ PUUPRP\<P\PձRy 
\v\Pݣx
$ / B~
<P~c PU\v&\Pݣx# P~:PUÄ 19 ^q7R* ݭ|~ ~o" P\3~+o P\O" Pt^7ViTUW߭e Xݬ: RĀ N8RSФ|PCQa1ݬC'# PC|PPФ|PCPЭ`UPRRĀ UR1 A~<~ݬ k, PXXR1 ߭<~ݬ 5 PXXR1e A~ Cݭ  PXXR1B~ t" ݬtx" |~ tOݭ  PXRĀ PP8RSC|P9C|Ф|PCP`Ф|PCPЭ`ݬФ|PC " WPRRĀ W1 Ā RRUd   RĀ 8Ā ~ݤ| P|[  XmĀ ƈ  USSĀ P8SRB|SSĀ 8URB|8USФ|RCRb8USФ|RCRЭbݬ8UФ|REC! XPP| ^gTެUe8 RĀ <P8RSФ|PCe! PФ|PCP`C|PRRĀ  ߭<~ݬ 63 PVVR|~ݭ / PVVP^I4YfTQЬPЏ@   R
RP
Q{RPQPQnZn1q  V2  xZRRU<eS SR<RRxRP S<SRxRRRP1j<>S SR<RRxRP S<SRxRRPRR1 <eS SR<RRxRP S<SRxRRRPޮXPޮWݮ~7 RĀ 7P8RSФ|PCݮfPФ|PCQaC`PRRĀ  ߭<~ݮ 1 P[[R|~ݭ - P[[3P2<eS SR<RRxRP S<SRxRRRP~ϴPvZUSr~q~p~o~n~m~l~ݤx	,<>S SR<RRxRP S<SRxRRRP~%ݤxZZn1^PP< ά^S2SeR ` PT;{_  L PUTU\\Z   \ïK UT< UTtB~ ^   ߢ8- ߢh2 ߢh߭  ~ \Rl߭B~<P~) vߢ8ݢx t\\1" t1P ^H1ScRB~    ߢ8o ߢht ߢh߭b ~V \Rl߭B~<P~k vߢ8ݢx P< ^\cSP 	`T<Q QP<PPxPR Q<QPxPPPRRdߣh߭ PR`߭B~߭<P~ PU ^10SbRݬx   =  ^	0TbRr~q~p~o~n~m~l~ݢx	 ЬP<>Q QP<PPxPS Q<QPxPPPS~%x    < <^MbTUĄg ߭}] \Ā 1 P8\RФ|SBcPPtBP`PP,  XB߭ Ф|PBP<`P ߭2P~߭ - PUUP7|~ݭ ) PUUP!8\P@|PBPЭ`\\Ā 1oĄ UP< 8^.TtaRB~    ߢ8 ߢh  ߢh߭ ~ \Rl߭B~<P~ߥ vߢ8ݢxL <RnJ\ 	lLS<nP P\<\\x\Q P<P\x\\\QQcߢh>I H\Rl>B~JЏP  ~] PU   ^-SU`RB~    ߢ8 ߢh  ߢh߭ ~ \Rl߭B~<P~ vߢ8ݢx-  ^,T_RѬ;vMv:  Px <~( PѬv
vݢx ޯSS S  ^q,S&_RvݬPݢxz                          d^.S Ua`T"ޭ>||~ |~  PRPQPPѭPPQQcߤ ed5Pݬߤ e PVe  ЬPP   1?Pͮ"ͰޭͲ>Ͷ|ͺ|~ ͮ|~  PWPQPPѭPPQQߣ_ߤ* Pd	R(Pߤߣa  ï Å ߣu  RR   1YP͖"͘ޭ͚>͞|ͪ͢|~ ͖|~  PXPQPѭPPQQߣ_ߤ Pd	R(Pߤߣa  ï Å ߣu  RR   P~"̀ޭ͂>͆|͊͒|~ ~|~  PYPQ
PѭPPQQid YPf"hޭj>n|rz|~ f|~  PZPQPPѭPPQQPP ^+S]Rߣ   bb PP< ^+Th]SެRR~ݬ! 
  1  B PUARPߤߣ PcRc	 cR<cߣߤmUߤSc c Pc г R
~p P ^*R SެPP~ݬM   PߢYZ cc- г P
~  $^M*R6\Sް"ޭ>|ԭ|~ ߭|~  PTPQPPѭPPQQߢ_ߣ PcPߣa H¯  u 3P $^ް"ޭ>|ԭ|~ ߭|~  PRPPRѭRRPMRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP $^SjT\Rޢ@ܰ"ޢ@|ݬߢ@ `~ c P~ d dPc(c`ޢ@,ݤ, P4ޢ@                                                                                                                                                                                                                                                   ,                        $ҍ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              G "            
|~d0PPQA@ޢ@P`P`:`P`ߢ@u P|~ 쟭ܟ|~P<PPPL @ P^	W	ZYUQVZR[
I~j P[[P[1`~ e P~ f fPe(e`Ь,ݦ, P4~n P[1(Х<
|~f0PSP[1ԥP@<ݢ< ]~ݢ<I PS[1 P'S! 'S iI~ݢ<if P[[P I~ݢ<ive P[[P|SiI~ݢ<if PSSPX`g8~ iFb P1P֢8Tgj{ PSSPg8~ ib Pџihg TXPSX[P ^SVU(YRTWeI~ݢ<ee PTT\Pc8~ ea P/֢8Wcfӡ PTT\c8~ ema Pџef WPTP ^uSZVGWXRUfȢ ߭fУ P4@~ݬ߽C PЭP@1tP߭f P̕gI~ݢ<gd PUUP1B1 Tgf PUUP1բ8cg` PUUP1 c8~gf` PRP֢8cf PUUP1 @~ݬ߽o P@Tc8~g` PT1 @~ݬcm 8@A<~@ PUZc8~ga PUPc8~ ga PUUP֢8cfܟ PUUP@g	gd UPP ^}Sc ߭c PPR߭c PPRRЭP@P   < ^S1$ݬ
 PRPRެUe PGe	 PTS2PeT!
 TddRe PR SP< ^#TUߤݬ PSPЬR#PSݬRL PUPbRSV UP  MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP4^#VrY[WW|~   PfK   
 <Q~ PXXRߦ7  iԧ8 ߦi <d ~ݏ  P< Xi1߭  PXXR%֧8ѧ8<ݧ8Rƃ  0
 Pԧ8<߭߭ݭ<Q~ޔ PXXRݭ   	 Pi1Yݭ ЭRb[ZZ=o<[~<Z~ >ЭS'
 U
 Tz  UP{PQPPVdc~XdS U]
 ݭN   _	 1<[RR  1SR""  1s1^R33  1b1]RUU  1Q1<R  1@1+R  1/1,?<ZSS) 
ݭݭ 1#S ݭS PXXR1<ZRR_(R֐ؐƒ ݭ|~q   PS <~Pa PSS< ~<~嵐 PXXRy<ZRЭTS߭߭<R~ ЭRSݭT z~, Xݭ  -Pݭݭ [ ݭݭ XXR1=<Z~O ݭ}  1&P  P ^R ݭ|~I  Z PQS <~Q8 PSS< ~<~| TTTP  ^߭߭<~v ЭPݭݬ·  | ^UzSSެTdVecccRQdRP`eRQVԠRQQdPP< ^9 T&SSУUԼգPe2edr Rbeߤ=bUߤNb
ߤ\R PeУPРP ^TRSЬRbPbā  bУ R P  ^߭ ߭߭% PP߭߭߬ խPPP^=TĻ R Rv PPЬRR0  	RP( ݮG Rbݮ<0~ ݮb<~n~ݮbY\[Y  1  WЮV[ZYЮXZݮVgSZUSXKUPPRb~PRb~PRb~`~VgSRz  RP{(PQPP	VgSUSX0  [YY  1y   h YP^	SݬݬެWgE TЬUެXThT0 VPUPPRb~PRb~PRb~`~gfTRz  RP{(PQPP	gfTUThP  MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ZYc[WmVX/  9 PެS<cRR  8i   ߭߭R <cSď   SfRCj R  ?ЭP<~ <RR  10R""  1rRUU  1~1 R  1=1jPެT<dRď   RfPBSЭPc߭ݭ`  PU j <d~ fPBPg`1P<RR PUUP1ЭP&߭R ݭݭRw  pm 1|<Sď   SfPCRbݭЭPPP@iP`hP֠fPCPg`1<<RRp PUUP1 ЭP&߭RN ݭݭR  l 1 ݭݭ#a  1 ЭRPP
ݭRc 1 ݭRP@jP`1 k1 <RRۜ PUUP1 ЭP%߭R ݭݭRV  Ol \ЭRPPݭR ݭRP@P`hP֠<Rď   RfPBPg`
P<~5 ݭc߭߭<~ 1wP^1VZ[ߦT S<Rď   RTRPkR@¤ ~ߦ!> Tߦ&1 Wgެnо U<e~ߦ)g<~ߦJg~ߦgg~Ƅ g~ơ g<S SR<RRxRT S<SRxRRRT~ƾ g	~ g<Sď   SkRCnRb ggg<Sď   SkRCnRbZz  ZP{PQPPRRRRZUWUZRWRgV  T  XXZYBdWSRRP@cGdRU Rb MdPb~OdRUXW~RdWWY\ ~^?   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^TЬR
? V
SR RP<PPxPQ2RRʏ RRP<PPxPPPQQVPP   UXPSV~x  ߭2~  PUUP(ЬRݭЬR<~ PUUP  TЬRUTTRݬ~ ^ZЬR
? Sc߭c߭c?c?cWUWSSP@bYSCbV<R RP<PPxPS R<RPxPPPSSޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭR RP<PPxPS2RPʏ P<PPxPPPSS<R RP<PPxPS R<RPxPPPSSWPP   YPP   XlPUW~ VY~  ߭2~  PXXP,Y~<~ݭݭݭ<~ЬP<~	 PXЬPXZZPݬ| ^XЬR
߭ ? WUޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭR RP<PPxPS2RPʏ P<PPxPPPSSWPP   VGUW~p  ߭2~  PVVPݭݭЬP<~} PVЬRVXXRݬ{ ^ZЬR
? Sc?c?cYVYTTP@bXTP@bU<R RP<PPxPQ R<RPxPPPQQR RP<PPxPS2RPʏ P<PPxPPPSS<R RP<PPxPQ R<RPxPPPQQT   XPP   WdPVY~0 UX~   ߭2~ F
 PWWP$X~<~ݭ<~ЬP<~5
 PWЬPWZZPݬEz NCPMoveFileDir: ConvertTokenStringToCString() failed :  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^WЬS
XUT
RRT~K PVVR1?ЬR<~֑ PVVR1i
V1]PX~ЬR<~? PVVRRRV1.U~ЬR<~ PVVR1ЬSЭ C<  PVVR1 ? ^(n~ЬR<~` PVVR1 ~ЬR<~ PCIP   6P:P<R2 ^(n~ЬR<~-9  PV5PV,P<~^(n~ X~ЬR<~T PVVRЬSVWWSݬw < ^UЬR
SS~<~ PTTP1 ~ЬP<~ PTTP1  S~ЬP<~޲ PTTPx~ЬP<~'b PTTPU PS PSS   T*ЬR	j 	` SSUTЬRTUURݬv ^SXYЬS
UZT
RRT~\ PWWR1 e PWWR	W1hP?ЬR<~ﺎ PWWR1IWRR   15W1.埭U~ЬR<~ PWWR1 V<~^(n~ЬR<~ PWWRR   1 W1 P߭ЬR<~ PWWR1 ЬSЭݭ I PWWROZRR   C?RЬV<~I  ؟d P<~^(n~<~y ЬSWYYSЬSSt WR1 R1 R<~i P1 ߨ P1 ?<~ 1 / PRR߭ߨRq ݭЬR<~ P[[RRG ؟c PW߭ЬV<~ <~ݭ^(n~<~1t ^WЬS
UT
RRT~ PVVR1W?ЬR<~& PVVR1:
V1.PU~ЬR<~ PVVR1 v X<~^(n~ЬR<~U PVVRRV1 PV1  P	V1 PЬSЭ PVVRR   JVEP PVVR0^(n~ЬR<~x ^(n~鱗 VЬSVWWS   ur ^WZЬS
[XUXTTRBcY
TRBcSUTڢ PVVRSY~¢ PVVR1 [~ЬR<~[ PVVR1 - ﺥ   Pߧ
  ^(n^(n~ ЬR~<~PD  PVЬSVZZS   =q Ό^[ЬS
Z? Rb
?b߭bXV<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTޭRRSޭRRURTSRSbeSRSUbUSURcbdЭVX~
 PWWR1R?Ь                                                                                                                                                                                                                                                   -                        0C $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ( "            R<~ PWWR15埭Z~ЬR<~ PWWR1
  < ~^(n~ЬR<~| PWWR	W1 P<;~ ͠" ͬͮЭͼYYЬS͑͓͔͕Э͖͚͜͠Y͑\ PWWRL?~ЬV<~B  ؟͑^ PWWR<~^(n~<~s PWЬSW [[S n Π^XЬS
TͰT~<~% PWWR1T~ЬR<~ͪ PWWR1ЬS͡ͣͤͥͬͶͰ͡d PWWR1|Ͱ~ЬV<~
 P?~<~ P?^(Ͱn~<~ RRSޭRRURTSRSbeSRSUbUSURcbdЭҞRRSޭRRURTSRSbeSRSUbUSURcbdЭЬSRb TdRb  RbͶ# "dğ dҟ$dΟ*dП(dڟ,dʟ2d̟0d4 8b?ld nb   XЬSWXXS   l x^YЬS
UX߭ ߭ T S֭ST~" PWWR1B2V͇߭ˏ   ~ЬR<~ PWWR1PV߭ЬS<~t ۚU~<~7 PWWR1՚U~ЬR<~O PWWR1SխNЬSx?/ ?ܚ~<~M <RR <~~<~ PW1ePЬS͍͏͐͑Э͖͒͘V"͇͍͜; PWWR1P͜ݭ͍ PWWR1߭ݭЬR<~" PWWR1?ˏ͠~ݭ蚭~ЬR<~xy PWWRW1͠J͍͘͜0^ PW1k͜͏~<͍~ PWWRW1CW1 ЬR߭ ͠
W1P͠XRʏR
W1P͠	W1Pˏ?R<RRЬR<~^  PW<RʏwRWˏxR<RRW<Rʏ~RW<RRWЭ͠ˏR2<RR&ЬT.ͨ ,ͪ WcЬS<~D  PL0͸ ͸RRSޭRRURTSRSbeSRSUbUSURcbdЭ͸WˏR5<RR)ЬT6ʹ% 4Ͷ PW1 ЬR8 RRSޭRRURTSRSbeSRSUbUSURcbdЭ*<Rʏ~RWЬR<~1 PWˏR:<Rʏ}R)ЬT>ͰY <ͲI PW<RRWP͠WWR1͠V$͜ݭ͇͍ PWWR1Z!͜ݭݭ͍ PWWR171 <RR1 ͠_ЬVx? ?ܟ<~Jj <RR <~^(n~<~k PWWR1 jPЬVt?= ?ܟ<~+j <RR <~^(n^(n~<~p PWWR^WSV͠V͖͒ﯚ (͍x̓͘͜Vx͍ PWЬSWYYS   f  ΀^TЬQ
RR~<~ PUUP1 ߭ǚ~ЬP<~ PUUP1 ЬP PUUPmVԭWЬR Scccc߭cVT߭ǟ ߭ PPTЬQUTTQݬe ^XԮЬS
Z
UUZ~ PYYR<~ߨ_Y1$WUTVZUVUdSSSWSTVVU
WRЬSBcWRBc[WRBcRR[~ﱚ PYYR<~1ߨPY1   ~ЬR<~ PYYRq~ЬR<~\ PYYRH	Y;P~^(n^(n~ ЬR~<~6  PYЬSYݮSݬc | ^SЬQ
VRU
PPU~ PTTP>?R~V~ЬP~<~2'  PTTPЬP	SЬQTSSQ   b | ^SЬQ
VRU
PPU~o PTTP>?R~V~ЬP~<~&  PTTPЬP	SЬQTSSQ   eb < ^SЬR
TT~<~ PUЬQU   SSQR)b | ^SЬQ
VRU
PPU~ PTTP>?R~V~ЬP~<~%  PTTPЬP	SЬQTSSQݬa     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^XЬQ
VTVRRP@aURP@aSR0UPP   WW~QkP߭TV~ SU~q ?c ЬP<~p~S W P ߭ЬP<~%  PWЬQWXXQ ` ^nЬU
UP`YUWYTTRWRP`[UVRV[SSQVQP`Z
URUQUT0
SZPPXX~ݬeP߭WY~ Rb߭V[~b߭UZ~b ߭߭ЬR<~ PXXP ߭߭ݭ<~9 PXЬQXnnQݬ_  ^|RЬQSRRQ   _ ^XЬR
? W
TWQ
QP@bVQP@bSQ0VPPUU~R1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭TW~s ߭SV~d ?V ЬP<~p~P U P 2~߭߭ЬP<~#  PUЬQUXXQݬ^ ^UЬR
XW? TSTQQP@bQ0S P/VV~ݬOPR RP<PPxPQ2RPʏ P<PPxPPPQQ~W~X~2~SЬP<~ PVЬQV UUQ ] Ό^XЬS
? W
VWPP0UU~S-|PS SP<PRxRQ2SRʏ R<RRxRPPQQͿVW~  ߭2~ͿЬR<~ PUUP~ݭЬR<~ PUЬRUXXRݬ\ UP1 ͎3 ͎Ū ?@ T1    SP?<T~t PUUP\W߭<T~z PUUPBѭ;<TRRv  <  ~cRt  <  ~cTTP^XЬR
?q W
TWQ
QP@bVQP@bSQ0VPP0UU~R1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭TW~ ߭SV~  ߭2~߭ЬP<~) PUUP~߭ݭЬP<~@ PUЬQUXXQ   -[  ^UЬR
?u V
TVPP0WW~R1&PR RP<PPxPS2RPʏ P<PPxPPPSS߭TV~3 ~߭2~߭ЬP<~R PWWP1 ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭR RP<PPxPS2RPʏ P<PPxPPPSS߭ЬRv ?g U߭C ߭I P0~ ߭9 P@b4 0UЬQWUUQ   Y | ^UЬP
߭ ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ~ݭЬP<~M PVVP1 ޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ𭰰R RP<PPxPS2RPʏ P<PPxPPPSS߭ЬR(  U  P0~  P@b 0UЬQVUUQ aX |^VЬR
߭ ? WUWPP0XX~R1vPޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭR RP<PPxPS2RPʏ P<PPxPPPSS߭UW~ }ݭ2~߭ЬP<~~ PXXP1 }PPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ}R RP<PPxPS2RPʏ P<PPxPPPSS}ЬR[ L V( . P0~  P@b 0V>?@VЬQXVVQ   V  8^UЬR
W? 
TSTPP0VV~RVR RP<PPxPQ2RPʏ P<PPxPPPQQ߭ST~ W~2~߭ЬP<~ PVЬQVUUQ U ^ZЬS
? Y
VYT
TP@cTP@c[TP@cXTP@cUQ QP<PPxPR2QPʏ P<PPxPPPRRT0XPPWW~Se߭VY~ﱅ ߭UX~  ߭2~߭ЬP<~ PWWP#~[~~߭ݭЬP<~ PWЬQW ZZQ T ^XЬR
?	 W
TWQ
QP@bVQP@bSQ0VPPUU~R1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭TW~﯄ ߭SV~  ߭2~߭ЬP<~ PUUP ߭ݭЬP<~ PUЬQUXXQ S ^XЬR
? V
TVQ
QP@bYQP@bWQP@bSQ0WPPUU~R1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭TV~﯃ ߭SW~  ߭2~߭ЬP<~ PUUP~Y~߭ݭЬP<~q PUЬQUXXQݬR ^[ЬTTVЬU
V~? VP`Z
VWZSSRWR~߭ VPRP`YVRVS0YPPXX~T 1R RP<PPxPS2RPʏ P<PPxPPPSSޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ߭WZ~` ߭VY~Q ߭{ PX1 ߭2~߭ЬP<~] PXXPP   1 X1 Pݭ߭ݭЬP<~5 PXXP1 URR  PQP~ QR~ ޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ쭆߭U~E ѭѭ[ЬQX[[QݬP ^WЬTTSЬU
S~? SP`Y
SVYR
RP@c[SPRQQP`ZSQSR0ZPPXX~T1 Q QP<PPxPR2QPʏ P<PPxPPPRR߭VY~w ߭SZ~h ~߭2~߭ЬP<~ PXXP>UP~P[~߭ݭЬP<~ۮ PXň ŉ    WЬQXWWQ   iO t^ԮЬWWR
R~? RP`Z
RYZT
TP@bTP@bRPTQQP`[RVQV[PVPXT0PUU~W1Q QP<PPxPR2QPʏ P<PPxPPPRR߭YZ~7 ߭V[~(  ߭2~߭ЬP<~I PUUP1 ~ 
~X~߭ݭЬP<~ PUUP                                                                                                                                                                                                                                                   .                        	W $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              4 "            ߭ Pk?ￕ SXP?<S~of PUUP94<S~i PUUP߭F P<S~Rf SSЬQU Q M ^X?" ЬP<~p~? U1 ЬR
? W
TWQ
QP@bVQP@bSQ0VPPUU~R1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭TW~{} ߭SV~l}  ߭2~߭ЬP<~ PUUP ߭ݭЬP<~F PUЬQUXXQ L ^nЬU
U~? UP`Y
UWYTTRWRP`[UVRV[SSQVQP`ZURUQUT0
SZPPXX~ݬ1 PQ QP<PPxPR2QPʏ P<PPxPPPRR߭WY~d| Rb߭V[~b߭UZ~b ߭2~߭ЬR<~k PXXP ߭߭ݭ<~ PXЬQXnnQݬuK <^XЬRRS
SUS~? SP`WSWPSPTP0VV~RvPQ QP<PPxPR2QPʏ P<PPxPPPRR߭SW~o{  ߭2~߭ЬR<~ PVVPTUݭ<~, PVЬQVXXQ   J  <^WЬR
T? VSVPP0UU~RvR RP<PPxPQ2RPʏ P<PPxPPPQQ߭SV~z  ߭2~߭ЬP<~ PUUPTݭЬP<~z PUЬQUWWQ I  ^SЬR<~" PTPTЬQTSSQRI ^YЬTTSЬW
S~߭ S~? ZSVZRRP@c[SURUR0[PPXX~T1 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭR RP<PPxPS2RPʏ P<PPxPPPSS߭VZ~0y ߭U[~!y  ߭2~߭ЬP<~B PXMWWݭ߭ݭЬP<~ģ PX<gSxSPPPY SP<PPxPR S<SPxPPPRRgЬQX YYQ H D^nЬS
?` 
YU
URBcZURBcXURZTTRBc?* URTRBc[URTRBcVU0
[RR0TWW~ݬ:1PS SR<RRxRT2SRʏ R<RRxRRRTTS SR<RRxRT2SRʏ R<RRxRRRTT߭YTTw Sc߭XZ~c}V[~cT0W1 ZRRW1 P ߭2~߭ЬR<~ PWWR1  ߭2~}ЬR<~f PWWR1 ~ݭ߭ݭЬS<~߸ PWV߭ PonpqrswZyݭ+Z  Mn{5 P"<~ݭ^(Nn ЬR<~F ЬSWnnS   E D^ZnЬW
W~?  WRb
WYVVTYTRbWXTX
UUSXS~? WRTRSRbWTWSWV0RR0U[[~ݬ1kPS SR<RRxRT2SRʏ R<RRxRRRTTS SR<RRxRT2SRʏ R<RRxRRRTT߭Y
~au Sc߭X~c}W~c ߭2~߭ЬR<~e P[[R1  ߭2~}ЬR<~> P[[R1 ݭ߭ݭЬR<~ P[[R|ߪ߭ PkЬSnpqrswZyݭߪ)ZY  MnT3 Pݭ^(Nn ЬR<~F ЬS[nnS C t^nЬV
V~? VP`
VXUUSXSP`[VWSW[TTRWR~? VPSPRP`ZVSVRVU0
ZPP0TYY~ݬ1 Q QP<PPxPR2QPʏ P<PPxPPPRRQ QP<PPxPR2QPʏ P<PPxPPPRR߭X~Ms Rb߭W[~b}VZ~b ߭2~߭ЬP<~S PYYPA ߭2~}ЬP<~/ PYYP ݭ߭ݭЬP<~ PYЬQYnnQݬ5B  ^SЬR<~v3 PT QT SSQRB  ^SЬR<~3 PT QT SSQRA  ^VЬU߭ЬP<~_ PWW~	U~ fPޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ߭	U~ ЬP<~B P3VЬQWVVQ   
A  ^UЬP
߭V ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭЬT<~) PVЬRSVQQPxPPPQcUW   UURTu@  ^SЬPRRЬP<~ PTTPRЬP<~o PTTPSЬQT SSQ @  8^VЬR
T?Z USUPP0WW~RWR RP<PPxPQ2RPʏ P<PPxPPPQQ߭SU~p 2~T߭ЬP<~  PWЬQWVVQݬe? MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP,^߭߭<~c PVVR1 Րؐ(ЬWխoY<   XV?䟭?YGX5 PVVR9V'P<R^(n PVVRPWWVRSPSSPP^cVXYЬЬݬlr ЬSˏ   cRc
Yʏ   cݬ ݬݬ PWWR1լfݬ  P8~<~@ P1 P   
1 
PW1 Pߦֽ P1 h½ P1 ߭ݼ<~r PWWRuЬ S9RR~,ݭ~<~K PWWRFЬ R<9RR91Ь R<9R& Ь R^(3n~<~P1Yݼ<~ۦ WPP  ^픭ݬ PP ^WЬVݦ߼ PG~<f~ PP   ЬRbWP
PWGPЬR(ݬV@ PWWR$լЬV(ԦݬVZ PWWRWP| ^ݬ~<~An PVVR1Э PVVR1 ~ ^(n~ݬ~~<~	q PVVR1 ?<~S PVVR1 
A _Pݬ  ^(n~<~H PVVRQ< R2 ^(n~<SSPV~S~s < ~~<~1y PVVRVPPΤ^YZn<nSS<~6PZZR1S  [R 7, ?y ݬ PZ1FP ߭2~ݬ  PZZRZ1!Q  PZZR1
ݭ2~ݬ<~l PZZR1<~; PZZR1͸ͼЏ  VURR   uUq SP ןViݭ ﴘ PHVRT
RcP
R͸cPU
RT՚RR   UR
UZ1 V ןV拏ݭ 5 PZZR11 R   1RPP   U               2 1P>?P~P 2 4ݭ , PZZR1~ VҸ *~¸ 
@|~ Vݭ З PZZR11P1)ѭ[	$Z1Pѭ[1f PVWfUTdSeRSR3dSeRSR |~~V^ݭ J UTW	$Z1PS0SRRRRSRRTPTTRRSSRz  SP{PQPPSBRxSSRRRSR&Z1JPW?ݭGm PZZRZ1%<US SR<RRxRT2SRʏ R<RRxRRTRUR	'Z1P PBP UTdSeRSR)dSeRSR!ѭ["Z1UTP̚~ݬݭ<~ PZZR1tѭ[1+   P1X ןXyݭ q PZZR	?Z1+PhRRSޭRRURTSRSbeSRSUbUSURcbdЭWRRSޭRRURTSRSbeSRSUbUSURcbdЭXV ןVJݭ Ҕ PZZREQf;xQRBRRSޭRRURTSRSbeSRSUbUSURcbd­WQWX>Z1BPVЭf ן؟ݭ P PZZRXNPW Qa<aRRSޭRRURTSRSbeSRSUbUSURcbdЭaQWWXVX<~X PZZR1 ѭ[0<~L )PSX!PCf[0<~L 
PSSX߭ R PZZRQXVWݭ<SS PZZRSL 
ݭ  <~W  PZZR1  ןݭ  PZZRlT8Sc<Sc!
URR   ѭ[
|~Tݭ  PZZRm # ެR<bVV:bͩͬͭͮ V :ʹٟͩ& '^(n ߘ~ V	i ZRI<nRR  <Sď   SRC° Rb:<Sď   SÈRC° RbP<Sď   SRC° RbZRZSSSP ^?<~J PSSPHC߭<RRP ߭Rt3 R ߭
ݭ  RPSSP| ^U?<~CJ PUUP1 1 ԭެRb甭߭ PUխ<  R Y R[ ׭ެR<bTTC <bSď   SPC RbVU<V~T}
PUUPuRC° P`Td PUUP ^<RR8z R!< ~RI Rv   P ^ ߭2~ݬ<~ PRRPݬݬݬݭ<~A PRRPP ^W  ݬd ~<~b PVVR1bݬd  P  Pߧ  ?<~mH PVVR1 1?^(n~~<~? PVVR1 PA<SSSRRVSSSVR1 V1 P<SS!SRR	VlPVRdV^Эݬ ~ݬ~U PVVR<~Y   VPP ^W  ݬb ퟭ~<~<a PVVR1?<~G PVVR1V1?^(n~~<~R> PVVR1a<RRV1Rݬb !c PVVR	V1(P Pj ߧ^ O ߭<~=L PVVR1 Э&ݭݬ$~ݬ ~N PVVR|h<RR<ݭݬ$~ݬ ~  PVVR<RG2PV<P8Pݭݬ$~ݬ ~ PVVR<~V   VPP@^Xhwjyl{լ	ѬkzkzW1P(|( mݬ` ݬ(` ݬh` ͂wPWWR                                                                                                                                                                                                                                                   /                        ;4 ] $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            15ݬ(6` s hPWWR1(|( mԭ1d H e  [ 8 Z͂sP^ߨsP#sPs͂sЏ   ߭ݬ,wkPWWRUW19߭ݬ,wkPWWR	W1PW1P͂s  PVVVY<Y~^(n~<~jPWWRW1  P1 ,1 hY dЏ   ͆߭YkPWWR1Y<~^( n~<~jPWWR1 W1#PЏ   ͆߭ݏ YkPWWRW1 Y<~ ^( n~<~jPWWR5W1 PY<~^( n~<~jPWWRW1 &~<~7 PWWRWr(wY YPߨsP!sk~)^ PWWR	W(Pݬ,hw PWWR1KWPPΨ^WZ߭<~BG PVVR1߭9 ѭYYݬ] a PXXMݬ\ @[<[~^(n~<~u5 PVVRRV1PV1ͪͬͭͮЬͯͳTԭ ͵͹߭ݬͪ PVVRTV1 V1 Pݬ[ ߧ< P ߧ& ͹ ͹ ͵͹~<~/ PVVRV) 2Y~ݬͪ PVVRVZXT1-ݭ<~f VRZSVSSP ^AST߭<RRR5 PTTPRߣ P|~ߣl<~߭F PRRPP   (  BPn?PTDT?PT7P<~À AǘTTPR TTP ^STެRb æ (߭<b~4 PTTPbʑPQݬ߭p PRRݬe
RëTPP| ^TSVS 0 .P߭<S~3 PVVPS6   UPQS߭ؤ PRRSePR   ^aUnWV]#V<Qď   QD{PA P`1-P<QFQPP? ? ? ? ? ? ; P?PP  g;V1 g1 P1 <nS߭<RR2 PSSPRߥ :   T1 |~ߥl<~߭ݣ PRRPP  '  A?PSDS?PS7P<n~ŀ ڏ`SPSPR ﷏SSTTVVP;VVP<Qď   QzPA P`VPP^VyXWW<Qď   QhPA P`1 P<Qď   QhPA P`RRW1 P<PPP1 1 <TUT ã -߭<T~1 PUUPTʎ   S=QT߭l PRRTeRƫUSSW	PWR<Qď   QhPA P`WP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^uWVXЬSY?<~Zh PVVR1  ЬS<~NS <~ 5v  	 ЬR<~8 PVVR1 ݬ߭ЬR<~c PVVR1 ЬR<~u" PVVRjЬR㔭g럭嚭~<~ PVVR< PVVR'ߧ^(n ~ ЬR<~	X ЬScRVXXcݬI! VR
<Y~VPP< ^%Sլլ5լ
ߣլ ЬRߣC<~ߣ|~ЬPT<TPЬPUUP   <TRRFRi< ^RЬP
SSPTCPЬP<~S~*h PU߭<U~! PTTP߭ЬP RЬQT RRQ 5   8^SЬQ
RQRPP0	T1 P߭QR~P ?g <~  PRTTR߭T PTTPR.  /ЬQSPPR	 PPSR  ЬQTSSQ   q | <^TЬR
? U
SR RP<PPxPQ2RRʏ RRP<PPxPPPQQUPP0Vz߭SU~O ?f <~  PSVKS2~߭S PVVP&ЬQTRRS	 RRTS
  ЬRVTTRݬ  ^oVWЬP
TTPS1 ЬR<~T~e PU?<~6 PSSP1 1 ?<U~d6 PSSP1 S1 PS߭Ea <URR߭  RH <  ~R+6  <  ~  
<U~f <U~5  <  ~  S:SЬQSWWQ   Q  ^@VUЬP
RRPW1PЬP<~R~d PT?d TW1b?<T~C5 PWWP1IЬR>S?#ԭ ߭ S  [P>  W>U1 P?<TRR9 ߭R: ߭Ü ߭RS8 SR> ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭR RP<PPxPS2RPʏ P<PPxPPPSS߭ЬRL ?= U߭ ߭ P0~ ߭ P@b
 8UЬQWUUQݬ   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^XЬS
[߭ ޭRRSޭRRPRTSRSb`SRSPbPSPRcbdЭЬRV[ZЬUA WVRR~Z<~  PYYPYR1 ЬPVX1 PޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ䞭PPRޭPPTPSRPR`dRPR`RQRPa`cЭ߭VRxRR	RPЬS@cg
RBcgXVVPP
1$ЬSY XXS   ^UЬR
W߭* ߭ ޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭ?ЬP<~1 VݭݭW~ЬP<~  PVЬRVUUR     ^UЬQ
W߭> ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ?ЬP<~0 VPݭW~ЬP<~+  PVЬQV UUQ Q | ^VЬQ
RR~<~TT PUUP1߭ЬP<~c6 PUUP1 ߭ݭ~ЬP<~  PUUP1 ߭ݭ~ЬP<~  PUUP1  
ޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭ?ЬR Sc
߭c߭cVЬRUVVRݬ  ^|RЬQSRRQ     ^UЬQ
W߭" ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭԭЏ߭ݭW~ЬP<~F  PVVPG߭ݭW~ЬP<~R  PVVP'߭ЬR ߭ UVЬRVUUR   ^UЬQ
W߭B ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP<~3 PVVP1 ѭѭtЬPWUޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬR	 U 
v UVPVЬRVUUR    < ^UЬP
߭. ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭? ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭЬR߭ ߭ ~~ ЬQUURQ    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^SЬRQ퐢Q;  PTЬQT   SSQRy  μ^UЬQVT	R
PPR~C PWWP1S; S~T~V~ЬP~<~SPWWP1ЬRͼͽ	;
Ϳ
U;7 ScP; ;cP~ ;cP@b UPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSЬR  Sc$c&c(c*cUЬQWUUQ Q < ^TЬRS퐢S PUЬQUTTQR S~<~ S# PUUP<~;  } ά^WЬSXV	T
RRT~KA PYYR1Uͮ V~U~X~ЬR~<~	]PYYR1ͶRRSޭRRURTSRSbeSRSUbUSURcbdЭͶͺRRSޭRRURTSRSbeSRSUbUSURcbdͺ;RRSޭRRURTSRSbeSRSUbUSURcbd;RRSޭRRURTSRSbeSRSUbUSURcbdRRSޭRRURTSRSbeSRSUbUSURcbdЬVͬͭ	ͮ
ͯͰͱ
Wͮo PZZͻ
Z,Zͮ WͲͶ @ Rbͺ$b;&b(b*bWЬSYWWS    Π^WЬSZ	Y
VTRRT~> PXXR1VRR@V@Y"B ݟZ~ЬR<~z@ PXXR1:LB I P&  ҭ  Џ   ͥ߭^(n~ЬR<~$PXXRR   1VPVVPP . 6 f               1 :?PX1 Pͥ Y~Z~ЬR~<~;PXePͥ Y~Z~ЬR~<~	PXͥ Y~Z~ЬR~<~	PXPXXR1ͭRRSޭRRURTSRSbeSRSUbUSURcbdЭͭͱRRSޭRRURTSRSbeSRSUbUSURcbdͱ͵RRSޭRRURTSRSbeSRSUbUSURcbd͵͹RRSޭRRURTSRSbeSRSUbUSURcbd͹ͻRRSޭRRURTSRSbeSRSUbUSURcbdͻЬVͣͤ	ͥ
ͦͧͨ
Wͥ P[[Ͳ
[,[ͥ Wͩͭ k Rbͱ$b͵&b͹(bͻ*bW-WЬSXWWS   
 ^WXЬSUY	T
RRT~ ; PVVR1 ?ЬR<~" PVVR                                                                                                                                                                                                                                                   0                        =g $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              t "            1 V1 )> U~ЬR<~< PVVRwV> S P0 Pߧ"  Y~^(n~ЬR~<~PVЬSVXXSݬ}	 ^sY[ЬSZ	V
UVT
TRBcTRBcWTRBcSUT9 PXXRSW~9 PXXR1< Z~ЬR<~F; PXXR1]=  P ߩ ׈ h< ~ЬR<~: PXXR1 <  Pk ߩ^ O X|PWW^(n^(n~ ЬV~<~PXXRR   4W~^(n^(n~ ~<~iPXЬSX[[SݬY Θ^OWZЬSXU	
TRRT~7 PVVR1: U~ЬR<~Q9 PVVR1?^(n~ЬR<~l PVVRV1WVXRR<RʏwRVXRʏxR<RRVXRR<Rʏ~RVVR1:  Py  Pߧj [ ЬSͬͮͯͰ(ͱͷ ͬ͟% PVVRsͬ͟B P	VYP͟ЬR~<~) PVVR	V-P[XYʏ YYͿͻ[~ͬU PVЬSVZZSݬ9 | ^UЬQR吡߭R PVVPMޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ߭ЬP UЬQVUUQ  | (^SЬR߭ ?ׄ ޭRRPޭRRTRQPRPbdPRPTbTPTR`baЭ<T TP<PPxPQ T<TPxPPPQQ<QTTЬP
R߭TݭЬP~<~ PVVPP   VyPRSЬQߐRݭ?ݭ PVVP?<UURRS UR<RRxRT U<URxRRRTT?ЬR ЬPVSSPЬUU> <S SR<RRxRT S<SRxRRRTT  <~< ~+  $^ЬRU߭H ?9 VޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭ<R RP<PPxPS R<RPxPPPSS߭<RSRSSݭUЬP~<~G PWWPP   ,W&ЬQߐVݭ?ݭ PWЬPWPЬRR   <~< ~+ 0^UЬRVW߭ Sc߭c߭cޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭЬQѐ߭ݭݭWV5 PXXPKޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭ߭ЬP UЬRXUURݬq  | ^UЬST? ? <Q QP<PPxPR Q<QPxPPPRR<Q QP<PPxPR Q<QPxPPPRR鐣<~<~T+ PVЬQV   UUQS μ^YЬSWU	V
TRRT~30 PZZR1; V~U~W~ЬR~<~PZZR1cRRSޭRRURTSRSbeSRSUbUSURcbdЭ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTЬVSͼcSͼRRbc;~ PXX
X,X;  ~ Rb$b&b(b*b$YЬSZ YYS  μ^YЬSWU	T
RRT~K. PZZR1V; U~V~W~ЬR~<~	]PZZR1cRRSޭRRURTSRSbeSRSUbUSURcbdЭ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTЬVSͼcSͼRRbc;| PXX
X,X;  | Rb$b&b(b*b$YЬSZYYS  Θ^ۛXZЬSYU	
TRRT~S, PVVR1/ U~ЬR<~- PVVR1~?^(n~ЬR<~ PVVRV1MYWxWRˏ RWVˏ?WR<RRЬR<~r PVW<RRVVR1 +/ ({ P{  Pߨ
z z ЬSͬͮͯͰ(ͱͷ ͬ͟ PVVRiͬ͟ P	VOP͟ЬR~<~ﵦ PVVR	V#P[WͿͻ[~ͬ PVЬSV ZZS  Έ^ÙY[ЬS
T?z Rb?b?b?b߭bУXXYZW[Q<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTޭRRSޭRRURTSRSbeSRSUbUSURcbdЭQW~() PVVR1Z, ៭X~ЬR<~* PVVR1?^(n~X~ЬR<~ PVVR1_<RRV1PSˏ Sͭ͵ͷ͹ͻͽͿЭ<Z?ЬR<~ PVVR1 Z+ w Pw  Pߩw w ЬS͚͜͝͞(ͥ͟ ͍͚m PVVRa͍͚ P	VGP͍ЬR~<~q PVVR	VPͩZ
~͚ﯚ PVЬSV [[S   ^|RЬQSRRQ   m  4^UЬR	߭v ߭v ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭЬR߭߭ޟ PWWP1 ѭW1 < íRQRPЭR	RP	Q{RPQPQVVPP   < VVPPޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭ߭ЬRu ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭ߭ЬRmu UV~^u VUWЬRWUUR     ^SЬR	߭u 琢߭ PTTP  <~i ЬQTSSQݬl     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^  ЬR	TTSS
ݬR,  P RCeP   ^  ЬR	TTSS
ݬR  P RCVP   ^  ЬR	TTSS2ݬRﬂ  P RCKP   ^  ЬQ	RݬQRP@DP` ^ЬRPP
ݬRI  ݬR P@w^P   ^ 4 ЬRTTSSݬR  P RCGfP   ^  ЬRTTSS
ݬRȁ  PݬRChP`    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^  XЬSYZ	?r WU<S SR<RRxRT S<SRxRRRTTUW~" PVVR1 % Y~ЬR<~$ PVVR1 % q Pq  ~q q ЬS(<~Z~} PVVRR@~ЬR<~k	 ЬSVXXSݬ < ^ | TЬR?q <Q QP<PPxPS Q<QPxPPPSS<S~~<~ PUUPP@~ЬP<~ ЬQUTTQ   I ^OX  YЬSUT	RRT~  PWWR1 # U~ЬR<~C" PWWR1 $ p Po ߨo o ЬV(~<~7 PWЬSW YYS %  ^  SЬR~<~? PTЬQT   SSQR ^X { YЬSUT	RRT~U PWWR1 " U~ЬR<~  PWWR1 " n Pn ߨ~n on ЬV(~<~? PWЬSW YYS   ^ ` SЬR~<~ PTЬQTSSQR     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP x^ * UЬRW?m 
TS<R RP<PPxPQ R<RPxPPPQQTPP   VPPyST~L y<~W~ЬP~<~v PVVRR@~ЬR<~ ЬRVUUR u | ^ \ TЬR?l <Q QP<PPxPS Q<QPxPPPSSU<~U~~<~|} PVVPP@~ЬP<~j ЬQVTTQ     x^  SЬQRQRPP   T-P{QR~ {ЬP~<~ey PTЬQTSSQݬe  x^ J SЬQRQRPP   T-P{QR~ {ЬP~<~Y{ PTЬQTSSQݬ  ^  SЬR~<~z PTЬQT   SSQR  ^  SЬR~<~y PTЬQTSSQRt     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^  VЬRXU߭pj Sc߭c?cޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭ<R RP<PPxPS R<RPxPPPSS<S~X~ݭݭUЬP~<~2 PWWPP@~ЬP<~ ЬRWVVR 	 | ^ ` TЬRU?Gi <Q QP<PPxPS Q<QPxPPPSS<S~U~~<~ PVVPP@~ЬP<~  ЬQVTTQݬq  ^  VЬRU                                                                                                                                                                                                                                                   1                        e< $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              p "           h ߭h ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭݭݭUЬS~<~ PWЬRW   VVRS  ^  SЬR~<~ PTЬQT   SSQRY  ^  VЬRU߭g ߭g ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭݭݭUЬS~<~S PWЬRW   VVRS  ^  SЬR~<~߹ PTЬQTSSQRD     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| p^UЬRS	T
RTPP   V1 rRT~H ߭S~rЬP~<~Ђ PVVPQޭPPޭRRSRQPRPbcPRPSbSPSR`baЭ߭ЬRe UЬRVUUR 5 | ^UЬP߭~e ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭ PVVPЬP	UЬQVUUQݬ | ^UЬR߭d ?d ޭPPQޭPQRQbQRQbPTPSQPQR`dbcЭ<R RP<PPxPS R<RPxPPPSS<S~ݭЬR~<~  PVVPP@~<~^ ЬRVUURݬ P| ^UЬP߭d ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭU PVЬQVUUQݬU VP % | ^UЬP߭c ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭЬR~<~ PVЬQVUUQR   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ZЬS
XVXPPRBcYP@cSЬRX	UYRR:[1 ߭SY~ TXjPTQAfPAeQЬP<~TRBf~) PW?<WSSH P Be߭S PBePBeTTX <  ~-  [XRRRZЬS[ZZS  | ^U߭ЬP<~
 PVVP<ЬRS߭a TdPcU߭dP߭	a ߭dPUVЬQVUUQЬRR ?<~X 
<  ~<~ <~)  ^S~ЬR<~> TЬQT   SSQR  ^S~ЬR<~> TЬQT   SSQRu  ^SЬQ
RQRPP:T"P߭QR~ ߭k TЬQTSSQ    ^UZЬQ
[V[SSRBaXSCaRXPP   Y1 RX~H ?ЬR<~ PYYP1 	:Y1 P[SGT1 ?<TRR Rw
 UT<TPPHYTSSP<TP@fPAЬP<~<TP@f~& PW?<WRRc R
 UTTSU <  ~S  YЬRYZZRݬ     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^S4?ЬR^ SSSRݬI | ^T߭! ߭ЬSu^ ߭{^ P0~ ߭k^ P@cf^ 0T! 8T" 9T?W% <Q QP<PPxPR Q<QPxPPPRR?: ^ UeT?8 <Q QP<PPxPR Q<QPxPPPRR?<eT% Q QP<PPxPR Q<QPxPPPRR?>eTn! @T! AT! BT߭3 <Q QP<PPxPR Q<QPxPPPRR?CeT! ETFT! GT! HT! IT" JT#" KT< L\ <TVTTSݬ  ^UЬP
WЏʽޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ4߭ЬR\ ?[ UVUUR   }  ^S?ЬP<~ PRRPRP:RЬQRSSQ   1  ^|V%  5& & & ЬT:[ Ue<[ ScPPVcPR 	RP@de cPPV c	RPRRP@decPPVcRPRRBdecPPVc	PR cPRRcPRRcPRRBdVW VVT   ^TЬP
R?<~K PSSP*ЬPRP8 PSP:SЬQSTTQ     ^S?ЬP<~ PRRP
 |" R:RЬQRSSQ   U  ^S?ЬP<~ PRRP
$" R:RЬQRSSQ     ^R?ЬP<~3 PSSP&?! ЬPRS:SЬQSRRQ     ^S?ЬP<~ PRRP
 (" R:RЬQRSSQ   A  ^S?ЬP<~w PRRP
! R:RЬQRSSQ     <^SЬQ
T?<~ PRRPE:R;߭ЬP<~ PRRP ߭X TPխRRRЬQRSSQݬe RP߭ƚQ~       ^RЬPo  PSSPRЬQS RRQ  < $^TЬS?NW <R RP<PPxPQ R<RPxPPPQQ<~o PUUP P?  <~ЬS<~r <R RP<PPxPQ R<RPxPPPQQ?ЬRV T   TTRS1 | ^TЬQTЬRSUTQR <S~ PVVPmԭSUꐭ߭ PVխ<SRR  d ׭UR<S~X PR<S~ U~<S~ PVP| ^uVUЬTUЬS锭fUTSG 뚭~<~
u PA<u <~異ߦ^(n ~ <~	 <~u| ^tUTЬS<~ߥ߭
U ߭U P	0߭ЬRT 
TVTTRSy < ^U߭ﶹ ޭPPޭЭR֭ЭP׭`bЭR֭ЭP׭`bЭR֭ЭP׭`bЭ߭ЬPlT U߭ ޭPPޭЭR֭ЭP׭`bЭR֭ЭP׭`bЭR֭ЭP׭`bЭ߭ЬPT U߭鷺 ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭܭ߭ЬPS U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭح߭ЬPIS U߭d ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭԭ߭ЬPR U߭D ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭЭ߭ЬPR U߭$ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ̭߭ЬP 5R U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭȭ߭ЬP$Q U߭T ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭĭ߭ЬP(}Q U߭ﰻ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP,!Q U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP0P U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP4iP U߭ﴷ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP8
P U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP<O U߭L ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP@UO U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPDN U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPHN U߭T ޭPPޭPPSPRЭP׭`cЭP׭`ЭP׭`bЭ߭ЬRLBN UU|~URݬ < $^U߭۶ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPM U߭ﻶ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPlM U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPM U߭g ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPL U߭3 ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPXL U߭' ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPK U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭܭ߭ЬR K U U|~UR ! < 8^U߭k ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP$K U߭# ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPJ U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPlJ U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPJ U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPI U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPXI U߭￵ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭܭ߭ЬP H U߭﫵 ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭح߭ЬP$H U߭7 ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭԭ߭ЬP(DH U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭЭ߭ЬP,G U߭k ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ̭߭ЬP0G U߭ ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭȭ߭ЬR40G U U|~UR  < ^U߭Ӊ  ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬP                                                                                                                                                                                                                                                   2                        C $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           F U߭/  ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬPXF U߭  ޭPPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭ߭ЬRE UU|~URݬ    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ݓSXЬTXߣ0	  VfߣIߣ0lE Ue
P@dfߣ0e	PRߣIePRRBdRP@dߣ4RP@dfRߣ4ePRRBdP`ߣSfߣ0ePRߣIePRߣ4ePRߣSePRRWWXWPW	P@dWPW	P@dWPW	P@dWPW	P@dWPW	P@dWPW	P@dXYXXT ) Θ^XЬS
V߭lD YV~<~N" P
W1}P߭ЬR<~> PWWR1]TT~ЬR<~ PWWR19ЬS͚͜Y͝V͞(ͥͩ͟ݭ͚l PWWR1? ^(nV~ЬR<~f PWWR1RRSޭRRURTSRSbeSRSUbUSURcbdЭ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTÞRRSޭRRURTSRSbeSRSUbUSURcbdЭ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT ЬSB VfzB Ue fY fͩ   e"eş$e(eß*e͟,e0e2e4 8f?꟣le nf   XЬSWXXSݬU ^RЬQ
VYX
WTPPT~  PSSPiVP
P	PUUPSIPU~W~X~Y~ЬP~<~	PSSPЬPA RЬQSRRQݬ MRB  ^ѬѬЬQ<PxPR<aPPRЬS<RxRP<cRRPP ^XSݬ@ PЬգ(ߣ< ~?`? PRR	RRP|~?⟭PPRPRPޭϭ>୧ޭ譯ԭޭ||~ ߭߭ <~ PRP<~RPЭRR<~RPѭԭH<~|P߭߭ ߭ߣ<> PRRR<~RP<~PRPRPxPPP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^UЬS
?? T<Q QP<PPxPR Q<QPxPPPRRT<~<~Xk  PVЬQVUUQSI < ^SЬR
TT~<~e  PUЬQU   SSQR
  ^T߭ЬP<~ PSSP1 խ,<&~ PS1 <&~ ݭ> ЬR
ЭQЭQЭQ
ЭQЭP= ЭQPP
Q S9ЭQPPPݭЬP<~ PSSP
ݭ ЬQSTTQ 	  ^WЬS
UTRRT~  PVVRJU~ЬR<~#  PVVR"^(n~ЬR<~g  PVЬSVWWS   q  ^WЬS
UTRRT~  PVVR1 !  U~ЬR<~y  PVVRsN  K< P(< "P
\< < ^(n~ЬR<~d  PVЬSVWWSݬy | 0^UЬP
R߭ԚR~f  PVVPMPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭЭЬPn; UЬQVUUQݬ                           ^QޭPPSPRQPQ`cQPQS`SQSPa`bPΨ^ZЬSЬ[
S~?: X
SPXU
URBcURBcYUVSVS SR<RRxRT2SRʏ R<RRxRRRTTU0	W1QP߭PX~  ͻVY~  PWWR1$ͼ럭ͻ~ЬR<~=  PWWR1 ͽ~ЬR<~ PWWR1 Yͽ9 ЬSͮͰͱͲ(ͳͼ͹ͽ9 @ͽͮ|PWWRv߭ͽ߭2~ЬR<~_  PWWR;ޭRRSޭRRURTSRSbeSRSUbUSURcbdЭPԭ߭[~59 ZЬSWZZSݬﵸ | ^UЬP
P~߭8 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭL PVPݭЬP<~ﮫ  PVЬQVUUQ  ^YЬnЬX
~߭`8 ޭRRSޭRRURTSRSbeSRSUbUSURcbdЭݭK P/[1 XSSX~
X~X~ݭЬR<~4  P[[R1 ZZWxWRRWRYSVUW@PEfPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭEfUUWZSxSRSR~X~X~p7 
~X~^7 ЬS[YYSݬ ^VЬU
U~߭)7 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭJ P/WPXXݭЬP<~d  PWЬQWVVQ   A  ^|VVЬU
U~߭6 ޭPPQޭPQRQbQRQbPTPSQRQPbd`cЭUݭJ P/W1<~ *6 U~6 U~6 PPQޭPQRQbQRQbPTPSQRQPbd`cЭ<R RP<PPxPS R<RPxPPPSSЬR<<~s PW1
p5 Rb26b~hPbݭЬP~<~  PWPPQޭPQRQbQRQbPTPSQRQPbd`cЭPPQޭPQRQbQRQbPTPSQRQPbd`cЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSWP1 ЬPR bR~:4 ScR~c
R~cR~cR~cR~cR~c*R~c0 2R~3 6VЬRWVVRݬ= | ^UЬR
R~߭3 R~?u3 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭF P/VP<~ݭЬP~<~  PVЬQVUUQ i | ^UЬR
R~߭2 R~?2 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭF P/VP<~ݭЬP~<~J  PVЬQVUUQ  ^WЬRЬV
R~߭1 ޭRRSޭRRQRPSRSbaSRSQbQSQRcb`ЭݭtE P/X1 PVU
VTTUݭЬR<~z  PXXRcP<eRPR/<@dR RQ<QQxQS R<RQxQQQSS@dP<eQPQ<eTTTWW TR<RRxRS T<TRxRRRSSeЬSXWWS   ^VЬRЬU
R~߭0 R~?0 ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭ-D P	/W1P<~ݭЬP<~v  PW1PPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSU e/ Rbb
bbbbb
*b 012b26b~Nhb   VЬQWVVQ     Π^WЬU
U~߭7. ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ1ͣͥͻͧޭͫ|ͯͷURbP1 Ѣ1 <PPP?1 ?ЬP<~ 	/V1PݢЬP<~H  PV1rҢKK|~ ͣ K  PVVPP/V1EQͻPQPa aQͻPQPퟢ;ͻ- P/V1ݢ; QH  PV1P/V1Pݭ@ P/V1UЬP<~e~ P, Rbb
bbbbb*b012b26b~hJbPPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSݭЬP<~"  PVЬQVWWQ  | ^UЬP
P~߭* ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭh> P/VPݭЬP<~ﾭ  PVUЬQVUUQ    | ^UЬP
P~߭1* ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭ= P/VPݭЬP<~  PVUЬQVUUQ   M  ^VЬRЬU
R~߭) R~?) ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭ< P	/W1P<~ݭЬP~<~  PWWP1PPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSU e' Rbb
bbbbb
*b 012b6VЬQW VVQ Ѧ | ^UЬS
S~߭' RbS~?bS~?bޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSS<R RP<PPxPS R<RPxPPPSSݭO: P/V#P<~ЬQ~<~ݭ<~  PVЬQVUUQ ɥ | ^UЬR
R~߭& R~?& ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭw9 PVP<~ݭЬP<~  PVЬQVUUQ   ^|VЬU
U~߭A% ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭ8 P/WPPU~?$ <R RP<PPxPS R<RPxPPPSS<S~ݭ                                                                                                                                                                                                                                                   3                        Mx $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              I "     (      P<~  PWЬQWVVQ )  ^RЬQRRQݬ	 ^XЬUЬV
U~߭M$ U~߭=$ ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭݭ7 P/WAPݭ7 P.W,V~Ue~ݭݭЬP<~  PWWP@XЬQWXXQ     ^VЬU
U~߭E# ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݭ6 P/WPU~ݭЬP<~  PWЬQWVVQ a  ^VЬRЬU
R~߭" R~?" ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭ6 P/W1 ߭<~ݭЬP~<~Ǳ  PWWP1 ޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ<R RP<PPxPS R<RPxPPPSSޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ߭U~^! Rb?U~b߭U~b
VЬQWVVQ   ^UЬR
R~߭	! R~?  WޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ<R RP<PPxPS R<RPxPPPSSݭk4 P/VPW~<~ݭЬP<~  PVЬQVUUQݬ    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^YЬS
X߭ WWTTRBcUT   URR   V1 PЬSWRR    RBcU~  k  X~<~2 PVVR1 X~ЬR<~J PVVRcX~ЬR<~ PVVREЬS␣吭(ݭ  ߭v PVЬSVYYS i  ^WЬS
U߭ TTRR   V1 PЬST~  \  U~<~# PVVR|U~ЬR<~> PVVR_U~ЬR<~ PVVRAЬS␣吭(ݭ۽  ߭z PVЬSVWWS a  ΐ^W<;~ ͑   ЬS
T߭ T~<~3 PVVR1T~ЬR<~K PVVR1~T~ЬR<~ PVVR1]ЬSʐ̐͐(ݭ  ٟ͑߭ PVVR1ͭRRSޭRRURTSRSbeSRSUbUSURcbdЭͭ͵RRSޭRRURTSRSbeSRSUbUSURcbdЭ͵͹RRSޭRRURTSRSbeSRSUbUSURcbdЭ͹RRSޭRRURTSRSbeSRSUbUSURcbdЭ߭ЬS TdW  Ue͕d e e͑  ͝&d͟$dͭ(dͩ.dͫ,d͵0dͥ6dͧ4d͹8d͙<d, @e le͡nd pe۟vd?ٟtdݟxd |e   WЬSVWWSݬM MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bPΘ^C:Xԭ, ͣ ;ͣZЬS
W[߭6 VSVRh 7PSRM  PYYR10*ߨ d  ۟W~ЬR<~  PYYR1֭4ʏ   ߭߭ݭЬR<~T	 PYYR1ЭRТU  8 Pߨ*  ͣ߭[~^(n~ЬR<~>ZPYYR1)Эnͧ?ЬR<~ ?ЬR<~ﾛ ߭ݭЬR<~	 PYYR1׭ͿRRSޭRRURTSRSbeSRSUbUSURcbdЭͿRRSޭRRURTSRSbeSRSUbUSURcbdЭRRSޭRRURTSRSbeSRSUbUSURcbdЭ߭ЬV WgZRbͧgRbRbRb Rbͣ  ͱ$gͯ&gͿ(gͽ,gͻ.g0g͹4gͷ6g[RRA8gͫ<g, @ ,@?⟦lgͳng, p p, 8 88?⟦pg, r r   ZЬTYZЬSZTSI YRn~<~wYPΜ^g6V<;~ ͟x WЬS
UY߭W TSTRߦ
( 7PSRm  PXXR1F*ߦ   ןU~ЬR<~  PXXR1֭   ߦ s ߭͟Y~^(n~ЬR<~VPXXR1wЭ[׭?͟^(n~ЬR<~ PXXR1CͻRRSޭRRURTSRSbeSRSUbUSURcbdЭͻRRSޭRRURTSRSbeSRSUbUSURcbdЭRRSޭRRURTSRSbeSRSUbUSURcbdЭ߭ЬS^ TdWRbͣdRbRbRb Rb͟x  ͭ$dͫ&dͻ(d͹,dͷ.d0d͵4dͳ6dYRRM8dͧ<d, @ ?ޟldͯnd pn '8 8^ ?ޟpd rE    Wz  P{   PQPPRSRSxSSSƏ   ߭ЬR  Sc߭ c߭ cWЬTXWЬSZWTST XR[~<Z~UP ^s2SVЬQWU	RRU~  PTTP1(B  *ߣ+ W~ЬP<~'  PTTP1 ЬQЭ TPTTP1  <R RP<PPxPQ R<RPxPPPQQ<R RP<PPxPQ R<RPxPPPQQЬR?	S ?D 
VЬRTVVR   ｐ Τ^0YXЬS? 
 
WV<T TR<RRxRU T<TRxRRRUUԭ购욮~<~  P
Z1P<S SR<RRxRT S<SRxRRRTTVW~  PZZR1*ߩ%   <RRЬR<~m PZZR1eͮ~^(n~ЬR<~QPZZR10Эn<S SR<RRxRT S<SRxRRRTTͶRRSޭRRURTSRSbeSRSUbUSURcbdЭͶ<ͺS SR<RRxRT S<SRxRRRTTͺ<ͼS SR<RRxRT S<SRxRRRTTͼ<;S SR<RRxRT S<SRxRRRTT;<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTRRSޭRRURTSRSbeSRSUbUSURcbdЭЬVa WgXͮK P[[ͻ
[,[ͮ XͲXRRDͶgͺ g;"g$g&g
X?ѭͺgͼg g$?&g
XЬTZXЬSXTS ZRn
~<~JPΨ^;-WZЬS
Y?>
 
VUS SR<RRxRT2SRʏ R<RRxRRRTTUV~@  P[[R1*ߧ S  韭Y~ЬR<~﫾  P[[R1Y}  2RRԭխ)Џ   @  Pȏ   ߧ  
 ߧ"  ͱ߭^(n~ЬR<~MP[[R1Эnͱ PXXЬR,Xͱ Z Pͱq  Pߧ$b ͱS ?ЬS<~
 ЬR <~<~ S SR<RRxRT2SRʏ R<RRxRRRTT<ͽS SR<RRxRT S<SRxRRRTTͽ<ͿS SR<RRxRT S<SRxRRRTTͿRRSޭRRURTSRSbeSRSUbUSURcbdЭͽЬSl
 TdͿdd!?"dZЬT[U3UV3 VVZЬSZTS憎 Un~<~LPΨ^)XYЬS?	 	W
VUS SR<RRxRT2SRʏ R<RRxRRRTTUV~ƹ  PZZR1z*ߨ&H	 2RRЏ   @ʼ  럭W~ЬR<~"  PZZR1   ߨ*  ͳ߭~^(n~ЬR<~IPZZR1ЭnnnS SR<RRxRT2SRʏ R<RRxRRRTT<ͿS SR<RRxRT S<SRxRRRTTͿͻRRSޭRRURTSRSbeSRSUbUSURcbdЭͻ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTT?ЬV~ WgYͳh P[[
[,[ͳ YͷͿ gͻgͿ g"g$g&gYЬTZYЬSYTSx ZRn~<~IΠ^&XYЬS
? [
WVUS SR<RRxRT2SRʏ R<RRxRRRTTUV~  PZZR1*ߨ, W2RRЏ   @  短[~ЬR<~  PZZR1[ƹ    Pߨ0  ͯ߭W~^(n~ЬR<~FPZZR1ЭnRRRS R<RRxRT2SRʏ R<RRxRRRTT<ͻS SR<RRxRT S<SRxRRRTTͻͷRRSޭRRURTSRSbeSRSUbUSURcbdЭͷ<ͿS SR<RRxRT S<SRxRRRTTͿ<S SR<RRxRT S<SRxRRRTT<S SR<RRxRT S<SRxRRRTTRRSޭRRURTSRSbeSRSUbUSURcbdЭ?ЬV WgYͯ PѮͼ
,ͯ 
YͳͷgͻgͿ g"g$gY&g@   YЬTZYЬSYTS ZRn~<~/F   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^W[VЬS
Z߭ YQޭRRSޭRRURTSRSbeSRSUbU                                                                                                                                                                                                                                                   4                        R $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$DBYAD="S3;Rt;1                                                                                                                                          iL%8kY;X`BC:Y]D 8{}0V ҷo:"2jO@ajA,,_R%%b[U{K_T+6ZBb(+zt!6s%(@jn#k煙~Hۋ
 sLM{x9JZ1&e><'=}ȟW"[դ<Nl!gPsP6ЭqqR=ܦP",Ɂ4]Tz'U䓸a$ 4x#P$5@:$_N_]&0E@X"`x
Q$&gE21eXZpx'&#PϫfVUmTqL%<3B}4l+-mq$:RvvIԐ%<ܛ>li,
}z)Bo" k]9ýnǵ2JGSкmwW]WΤYKTy[CLU+,KCƁ c燴};2?t؏emAsI4~Szѩȵ"$?J,JMIZTn4_qqpfW{~	KlAy=t?6IWZH*L2\!
O2	äd!{?@@4 cӏS%VGK%Jл"*J,~w=8t~Z~YĠb-+`ʾ(iPYxZeٙTEEJ' 
͝r39w/Զ0Č~%XKtB
?"ς3 XC*NhcYB.wPb1yO-r_; %I$iD6L9LIyP;lчxs_`K'0On?W+nvE]kR\" P;BMΎ4SA]86(ҺP2=zp!o[`ҏ54IB>f!,
aX\Np<Hlw6EgyH	7+rP<-xv:ֺ8M߾ŵ)B
4&S;`S)[}J(kT}#gv<?&;OAPb^pFsQwT"qG_Y9p8t7^ֈ/).j7W\{Au*N>ڎ#J$,6,.e+%mPl=O) }^̦mQRh
JdO1!ـa1F'2+śL#n/?F !xm@#D#r$G$4LO?Fcf* 6'^KFËI4H!$ϋl6k8u$S] 
xVT?14ɦT-Nב{FoO4îR3FRRo|i-*bY6IL>]Vc3p
)fïy򫓨{}:dȯ	=Gu5IFD 2&@1
";a^lª|y՝?ñ>#p̉5^A{I[ a]0'͒*Xb@:bf'
{ӣYJ:[rV=J&[ǔjg)Gp#pꈺam>Lnj	<=2jq(X
LF&QA~PO7ϒ8˸qΐ;]``55is%ڝş=2[zPʷad}DŌĤ:M8<;x[Y?SZj]s(ZS0DF9zx/n#qǎ]an*ICmpND>C$Sn6mtN[ZT`Mcu'}2l?zH#!jhΫ%"F_h\44k	_H]ﳏM$=~T 2!|W>`sxNa> B	cow³y煈~#uH$R֤>سnkC,⹞⒁(wm6cpO	
S1}!+f#o»
(kfeȯ✢V
=[ݢߠ*L!R'2:*(xOy|qd}QY[1/ycSYbdɭ"9ү6Pejֺ
x@U$b
&f.k^
4mlT^~+B*zq6@or$Nep*рSX9)?3Q*3=qF=qԜ8VvXL@u гh~[KSCBy,`lW*CBs۸lÿ6B3cBPiaO0t	{Dr tOk};=_wXIK,~I;+ͼ8%p'h@ʗu`]W>̑ƭn LPҦEtO*ԎRRWu;F	<r!qhB?En`B$.^ll	g#m7MMؚuZbFS485UýI7C=^C@5HN qi5~_~`cF	R`C(.8C2
iOTĖh>`ޡouMm.߿+RP9aX
wJh3<Kx?~ejvNNj *kxO6E"kHgMmBh *ۨMR5x*-d2EX(`#LC8T,70r7HX;BAUETEq46&a1KGxgVhU&ׯϬY_
qo7Ƴ0;naVv~H4FECEX5?,]CLFEn -p(<5a#''
LU=9ְaY>^ak=1e9	=Hvyzī2Ѯ)7Q/]KAi9҅ni|o j1"l}w5;n1`ᣳ3\GrI/]w. i#N_JŒn*o[8v
wxK?dz{tũO]$Y2USǟ:]su?=L{I2c &$M8X#KjbwrB4}#}ϋ[čֆY]i:pssJH>e6sp=h>l+?`=>Q^	PQټo2EFn')1*wۙj_kKZ5;0*	]|ixwĸA|-N>{#V}[?ou_/|WR4(vQ	G1H9z'&'k!L5VZ-uFZB4@Jӡ}
>|P"tP;Ո8swA.,Y<ٖ=P>>};M\1GHUj04pdA_;	Ø6jBbVxX}wh"oKWNKHxAͤ
O1
elb2MQǳSOPt$oO$i#0cKEm5\s0p}3 KEx3 IypFAq۾7 ʎ$+qLpݷ ^	fʕ4Ϝ{)|6%j]:86ܡEld'~G_X* [Ksv׊4W6(cDq:0&=vo i*-2lO'/A134O(:ER7TUf/#S3ec
QofQMMO[m1'۰)Au4QQ17.*X,bCf=VcB#TPlY# F9F(Uv=y#AsyYӕm4@,0(sdl_yNJ<ҖC }ζ)McHVZS9ccfFuuRϱ@9ʡI>Ɯ"{-qvsR 94U.LU("Й4<GK 4ŉϦmQ=&qUyb2W΂
?,9
dѾOt{+`8sB!ak
B疋v,v|a'L
AuS$pB_Xo^5o跰)XG+GqB\>j|D&q/s
a`bx@t\<;%.bp3L
?LWn7 i/"$jf8dgA	a|m]~grFU8qủDXIkR]}C1`+
n:ycekAbu(ŵI7ñ
Fy&ے
p))LKEz[a>GqÆ^.(c8WuqsI!|($4b@TɥR?{1}yFijf̦ d#uON\495VJ"Ml&ϣ.AAS
C	@Ü[讈^:ȯ
x(-Y4S+Pυ>8$*	vL4u
B+7Z:u1C~>@i<븈)ah;700﫟[3^x(&J^vOw	e^rsIعx"*AKˑa9drrJGp\/OFw}H[p`x/߂0iH7eq9k 4oK鳃i0@66<W1ӽK$sm~1s|d;eIt@vzS{_@6#N9 ;ԩ'yCAM*֜oCk m]qOϒq@zؾLSLoO{x tCX>tL%~ք(fa!J`gy0BaJ?$|QҚ-^f^?I}ldB`f3ehQ֞P,~n0u{rLmS`/BZ7^$()-J>k^mGl*>>v>9"kxN\>]=N%l3{!s4Nו<@s&
~BK`qnI=o,+.
CI1JGaL\,ol3\2X_;]U3\y^D,+<I۬ӆLajLͅ,К,ti=R姍iz٭8ba9*nM]pKsVI-yX%]qKm4{4qXr=Gq}_.:K17_}mBU|IBZL0ՆGY{˗5ޚ<rLT;[nbܢZӂOײhH\EضV=4{=ρ_đ}"lo	{\\؈.J:/BNg)|^2O: ;/yUU:rl~uSZޏYR(Δ5m+q@e?`0TsMUyB.Z̄7N%)L ۟QAF;#'Ӹ
ӯI?EuFo9:`Nf=NFl@-gWqHd#r	;WI3PNa 3 ,Ͱ̀Ĝ
3"w$#ˠ̰Х2KfJj!Cbo,qu)ŝ:PMXsjjB+5[˔IkZhR,4%-jbѶ"E7ߎR#AWu^|O(,oۅJB$s)CD~j*N`V+3w_C+%(4ku97,Ȃ96Y>d"(˷-m= >4xLsz	&߸T4!dj6Zi7բk3
Hx$C碚m(Dz
&)
b)>qmvx	]u9c55ӍOAGC}3jGFߕDa_s BǦm|<vW/'KV<dEY_ۋux,w5YI
	?LM/-J,0u(g#du9X70m:*𳕺O(@+9YpOK
dѡEau
nsYN`44ˬs%/iꣁS"M8F6uȜc%g^+i
&jG]	! iJsc┵cˋEx57<z4/+a&ec0bU?-xM5ľv	y6:aw7$~>OhԼGl!$4wa8Y*rHtlϔQ1Nԧ;`SlF^RFj8i 0VJ/c(bсH(|yKΧxvKI;+x.#u)zGʭiRbZ(zIw4l#	Cz-5VN-Wni	a]o.)Lm.VnP12j7&N&3ԙ)aM.w8`$[-0]3]IŸsza?`Y,<GߗhCK&߾
<#
itCT3~ｦ"7ۧ8d
BլLvfCI<|zr|ZI7-@ @I[b#NtGL5Ըxύ'jۥ\+;xqʿaK חѤ^v1}Tprs|ZKhr=VqNޟA>jIy5Z k/Mc>8FKxh0p{e/TYHeW/%[]&;5M^x)?['EކxG@?U S]yhr.}|PZ2tu
Ͽ'G:Nݦ&qo>K14%ˑTq EZS9΁+9̏@Q8VA
Ir.)BB
O%|;ڈ,PB(
OV}fT aJ!cLSA!&weX6IEt8(U(q&nlNm#Gi~zfU~Ƒ6^d&ssd)[%]
nti˥x4L!E_5p[G&V̙Pw"R`e2<O#7
#yu)IGBX$b"*u=c]0 5퍩1A)gM23v0{;8ȇfI^Rh?k}DO.-K-Dęw_Q9/*ڍ|"W5ĥQ Tը4-AY뙬GqeI4,2ŮWӿ4B6$0y:X$LܑFL1}F->nb/ ZW+va<?Q͠RTh98LèֈY`J'rlhʍ/|\sK&׬pT~	BRs=h#sDVJobyC;ǤbIE׋.jQ|Օ'ZZvАrUU_>#ofkP'v1jEv~Njw|Ly&e׳bHfgy^ιO4v'J31*S~IG5ϴSZ dmzp0PLy;.&z'95@w,?}P3N5`g/]}6Us/vݻ&S6Lb70.LuK 'je9u71BqsRc)w/?j.A
tURܮ6ط: ^SЏ	>R PRP!ݬ                                                                                                                                                                                                                   5                        h! $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     9      SURcbdЭQY~ܲ  PVVR1ݭ_ PVVR1 ퟭZ~ЬR<~`  PVVR1  X<WRR X<X~^(n~Z~ЬR<~9 PVVRR   1 V1 PЬS( p PVVRV6(WW<W~ݭ^(n~ЬR<~1 PVЬSV[[Sݬ ^YЬS
X߭D WQޭRRSޭRRURTSRSbeSRSUbUSURcbdЭQW~9  PVVR1 ퟭX~ЬR<~Ҳ  PVVR1  Z< ~^(n~X~ЬS<~﷏ PVVRݭ<~ PVnPЬS( .o PVVR*ݭ^(n~ЬR<~ PVVRVЬSV YYS  Θ^WЬVЬS
UYT
RRT~  PXXR1ퟭU~ЬR<~  PXXR1Џ   ͧ߭^(n~ЬR<~@PXXR1fЬS͘͚͛͜(ͣ͝ ͘n PXXR1! VS S 4VR R RSY~^(n~ЬR<~ PX1 ͧ PRRRͶͧx R~ RSCf| WVU<ͳS SR<RRxRT S<SRxRRRTTeVU<͵S SR<RRxRT S<SRxRRRTTeVRRSޭRRURTSRSbeSRSUbUSURcbdЭf!WXЬSX WWS e} ^ZЬVЬS
Y? 
߭ S SR<RRxRT2SRʏ R<RRxRRRTTޭRRSޭRRURTSRSbeSRSUbUSURcbdЭ߭
V~$ VXhY~ЬR<~  P
[1P?䟭XY~ݭЬR<~ P[hԦ
	Z[1 P<~ЬS<~$ VW@~ W WY~<~>  P1 Wr PRPn:BgY((ЬR<~+ P1>W W  PhS SR<RRxRT2SRʏ R<RRxRRRTThR	RRZ[ЬS[ ZZS m{ ^XЬWЬS
UYT
R+RT~  PVVR1 ,+U~ЬR<~|  PVVR1 ЬR<~ PVVRV1 ЬS(, j PVVR	VePWR?*RY~^(&n^( n~ЬR<~
 PVVRV<~*	W~ <RRRXVЬSVXXSݬz ^YЬS
X߭` ?Q WQޭRRSޭRRURTSRSbeSRSUbUSURcbdЭQW~F  PVVR1lݭ
 PVVR1W럭X~ЬR<~ʫ  PVVR1, Z< ~^(n~X~ЬR<~﯈ PVVRV1 ЬS( :h PVVR
V1 P/u P+<~ݭ^(n~ЬR<~x PVjP٬  ЬR~<~% PVVRV1<~ݭ^(n^(n~ЬR<~~ PVYЬSVYYS 
x ^|WXЬS
UTRRT~  PWWR1 U~ЬR<~"  PWWR1 ЬS( f PWW1 P?^(n^(n~ЬV<~l PWWRU<R4Ws P! ^(n~<~7PWWR?ЬRF XЬSWXXS v ^YЬS
X߭ WQޭRRSޭRRURTSRSbeSRSUbUSURcbdЭQW~  PVVR1ퟭX~ЬR<~  PVVR1  Z< ~^(n~X~ЬS<~{ PVVRݭ<~a
 PV1 ЬS( d PVVaq P%ݭ^(n~ЬR<~w PV,ݭ^(n^(n~ЬR<~} PVYЬSVYYS u Τ^WЬS
XTRRT~  PVVR1 X~ЬR<~,  PVVR1 ЬSͧͩͪͫ(ͬͲЏ   Ͷ߭ͧ(% PVVRVMP?^(n~X~ЬR<~ PVVRЬR<~ЬR<~ WЬSVWWS   s ^XЬS
UZY
TRRT~o  PWWR1 U~ЬR<~  PWWR1 ?^(n~ЬR<~w PWWRa<~ЬV<~+ SYRRRSSSRSZRRS?~<~( <~^(n~<~w PWЬRWXXRݬr  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^|RЬQSRRQ   r  ^RSЬQSRRQݬir  ^RSЬQSRRQݬEr  ^RSЬQSRRQݬ!r  ^RSЬQSRRQݬq  ^RЬQP`SRRQ   q  ^|RЬQSRRQ   q  ^RЬQP`SRRQ   q  ^|RЬQSRRQ   ]q  ^RSЬQSRRQݬ9q  ^RSЬQSRRQݬq  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ Y ЬPRRP p  ^ЬPRRPݬp   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ΀^TVЬQ
U?<~~ PWWP1m1 ?ЬRj Sc?
c?c?c?c
Vd ߤ P~ ߤ
 P@b V"P`VW1PU~ЬP<~ PWWP1߭ǚ~ЬP<~r  PWWP1ЬP| PWWP1o<Q QP<PPxPR Q<QPxPPPRR?ЬSM Ue<Q QP<PPxPR Q<QPxPPPRR?
e<Q QP<PPxPR Q<QPxPPPRR?e <Q QP<PPxPR Q<QPxPPPRR?e <Q QP<PPxPR Q<QPxPPPRR?e
V߭Ǟ_ RbP߭ǟ6 ߭bP~ ߭bP@c/ Vş"eVЬQWVVQݬm |^VЬQ
W߭W~<~  PXXP+ ЬP +VX14ЬP}W} PXXP1
߭  ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭ߭ЬTB UeVWV
V<R RP<PPxPS R<RPxPPPSS?ee<R RP<PPxPS R<RPxPPPSS?e<R RP<PPxPS R<RPxPPPSS?e <R RP<PPxPS R<RPxPPPSS?e <R RP<PPxPS R<RPxPPPSS?e <R RP<PPxPS R<RPxPPPSS?e V!V߭ RbP߭" ߭bP~ ߭b"P@d VЬQX VVQ 	k | ^UЬQR߭ʚR~<~  PVVP ЬP5 UV1ЬPR PVVP1<Q QP<PPxPR Q<QPxPPPRR?ЬS Td<Q QP<PPxPR Q<QPxPPPRR?
d<Q QP<PPxPR Q<QPxPPPRR?d <Q QP<PPxPR Q<QPxPPPRR?d <Q QP<PPxPR Q<QPxPPPRR?d
U߭ʞ RbP߭ʟ ߭bP~ ߭bP@c U<Q QP<PPxPR Q<QPxPPPRRȟ"dUЬQVUUQ h  8^SЬQ
RQRPP0Tv߭QR~A  ߭  ߭
 P@:߭ P@߭ Pٟ߭ЬP<~  PTTPЬPSЬQTSSQݬAh  8^RЬP
T߯  PSSPbTQPPQP	SNP߭˚T~ЬP<~  PSSP#߭ЬP  ߭0 PR
PSЬPRЬQSRRQ   g | x^TЬQ
R߭R~<~  PUUP+ ЬP +TU1 ЬP{R{ PUUP1 VԭЭ߭ЬR{ ScЭ߭cԭ߭c߭cЭ߭cЭ߭c߭ cV$T߭%k  ߭ PPTЬQU TTQ f  ^V6STWЬR<~a P	T1PЬRUReգ0 <~ߣ0w PTTR1{Pݣ0w ЬP
RRߦ߭6 PT17RR   1 ݣ0
} PT1ݣ03y ߭ݣ0:z P1 PRЭPPRPRP@PPBRЭPPRPB߭   P@Uݭ  PTPݭ#  PTTPP
ߣ0w l߭ݣ0y P1hU߭ЬR& Wߣ0v 2Pգ0T%P߭ݣ0w <~ЬRݭ ЬPTWWPݬd     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< t^SЬUݬ PQT1 <<
߭tg Rb߭xbݬI PPݬ|b~|~cU<~n PTTP-P   "P tߣU<~0 PTTP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^SUЬR<~&  PbRc~@~KU  T  <~ ݼc <TT&  Peߣ~@~U    T   &  ^STPŏ  TQcPAP<`PcPAPŏ  TQcPARЬPbcPAP TP ^STPŏ  TQcPAP`cPAcPA`P`P T< P| ^QUV T  Sŏ  VReQBP`dPBePB`PЬ`P V͚P ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^ЬPQQPЬP<~#0P ^ЬPQQP
PPЬPPЬP
PЬPЬR<~{ @~<~y ݬR`     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^1R~ˇ P0   ~ ݢ0  j <^~<~2 P4Т0S4~                                                                                                                                                                                                                                                   6                        b& $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     J      { PÀ Т0P  屢  4~ Т0P  Բ0Т0PԠTբ4PTQТ0P PAP`TT4ЬQQPТ0D SP QPРD0S`~ ߢ<!   ^P  ^0Q P ЬPD 0 P ^qV0SW Ѭݬߦ1PլЬP@<	@<1Pֳ0У0P֠ M RUգ4&0 TĀ QUP@P`R
PUU4R1 լ
ݬb Ԭ/W֣8ѣ8cݬݬߦMWլDѬѬ(<~Ƃ  %P~Ǝ  PݼƜ   /  1 P1 PUTУ0P PDRЬbУ0P PDPЬ`У0P PDPЬ`У0P PDPЬ`У0P PQDPQ`У0PЀ PD` У0P PDP`)`X У0P PDP`У0P PDP`UQУ0P PARЬbլЬP@<WWPP^m VX.SЬUQУ0PQRBRbURPQQ
   RRYYRPW0   PWRBRbWW
W
PWUУ0RERЬbУ0RERЬbУ0RERb   hݬ  he  \  Tգ4+TRУ0PЀ PB`Q ѡ¬TT4Tգ41  UTQУ0PЀ PA`R 1 Ѣ1 բ1 Ѣբ	ݢeԢԢУ0Pנ1 PѢ
 բ ТP޼Q@aP`ТP@<PݢТP޼Q@aP`ݢeԢWQУ0PAP` J Тb PԢУ0PנTT416  -  1P ^,RS0 QSP@P`PSS
< P^-Un,Wݧ48I ScЧ0Rݢb:crcЧ0R TXէ41  Vդ1 ݤݤݤݤݤXfդ[Ѥ	ѤA<~fFP RSz  SP{PQPPfb~fRSݴffd< PffTXX41R[ HP S< RbS`9 RS{  %  ^Rݬ P  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ΰ^KT\+RͲʹ͵Ͷޢ4ͽͷͶ~<Ͳ~+ PSSPdP&tK  籠   Ͳ) PSSPͲ<* ߢ0v  PSSPߤP&K  O  ЬPТ0h   ^*\0 e    ^*QЬPh 0   ^u*Rݢ0j  ߭<~l PSSP1 խS1 PP1 㔭ЭPЭP蚭~<~ PSSP1 ЭP߭u ߭8) PSSPsPP   w? PSSPR ЭP1 ЭPЭP0+ݭ<~4PSSPݭ  <~ 0     SPά^G)Vݦ0<  ߭<~> PWWR1#XխI<&~b~ PW1<&~ ݭ{ Xݭ<~~ PWWR1 ЭRݬڊ  ݭ<~fPWWR1 ЭRЭRͮͰͱͲ(ͳЬ͹ͽ|~ͮ7& PWWR ЭR (PЭRЭSRݬ' XRRݭ}  <~ 0 ]  WP ά^'RͬͮͯͰޢ4ͷͱͰ~<ͬ~ PWWP1 ͻ ͬ:# PWWP1 ߭ͬ>> PWWP1 QЭPЏZ   SSPQP{SPQPQUŏZ   U~  PSWqPZ US ?ͬ* PWWPBެTdQUPQPW,PVЬUdTďZ   TFeQxVPTP@2P`aVV
SU  ͬ& WPP ^&Rݢ0}  ݬ~ϚPS0 }  SPά^k&Xݨ0`}  ߭<~b PYYR1NZխ`<&~{ PY1,<&~ ݭ Zݭ<~ PYYRZR1 ݭ{ 1 PЭRЭRЭRЬWWЭR# ެVfͮͰͱͲ(ͳW͹ͽ|~ͮ! PYYR ZRRoݭ{  <f~ WЭSRWﶇ  ݭ<~PYYRZRRݭz  <~療 ͮQ$ 0   T|  YP< ΄^T$Rݢ0{  ߭<~ˁ PSSP1~Uխa<&~y P	S1\P<&~ ݭ Uݭ<~
 PSSPUP1%ݭy 1P<&~ ݭ ͮͰͲͱ<~ߢEߤ"͆ ͆͹ͳͲ~<ͮ~ PSSP1 ͽ|~ͮ" PSЭPЭPSPIЭPͲЭP' ߤ.ЭP  ͆ЭP ݬ ?ЭPͮ0 PSSPЭP<QQPͮ" ݢ0z  SP P^#VSݦ0
z  TPRSTަ4[UT~<P~ PUUP1C_ P^ PUUP1#߭]Pa9 PUUP1 QЭPЏZ   RRPQP{RPQPQWխvŏZ   W~8  PTU1 Z WT ?]P% PUUP1 SW-PݬŏZ   SP@ P
SUXSSWհSݬR SCSS
ZŏZ   W~?]P@/ PUխ	T/  ]P  0 x  UPΨ^o!XWݨ0bx  ͪͬͭͮި4͵ͯͮ~<ͪ~0 PTTP1͹ ͪ PTTP1_߭ͪ7 PTTP15խT1*PQЭPЏZ   R	RP	Q{RPQPQVŏZ   V~  PRT1 Z VR ?ͪ# PTTP1 SV*PݬŏZ   SP@ PSWSSVSVT1 ͪ PTTPi͹ ͪ PTTPJSUSVAPSW3ZŏZ   SP@bŏZ   U~?ͪf- PTTP	USSVRL  ͪ ݨ0w  TP ά^Vݦ0v  ͬͮͯͰަ4ͷͱͰ~<ͬ~R PWWP1#ͻ ͬ PWWP1߭ͬ5 PWWP1 խW1 QЭPЏZ   R	RP	Q{RPQPQTŏZ   T~  PSW1 Z TS ?ͬ" PWWPeެR<bQTPQPWOP<bTďZ   TD  U REbQxUPTP@2P`aUU
<PďZ   P@cP`S  ͬ 0 u  WP< ά^Tݤ0 u  ͮͰͱͲޤ4͹ͳͲ~<ͮ~ PUUPtͽ ͮY PUUPW߭ͮ`4 PUUP0խU%޼SQЭPЏZ   R	RP	Q{RPQPQcͮ ݤ0t  UPΨ^;YVݩ0.t  ͪͬͭͮީ4͵ͯͮ~<ͪ~ PUUR1͹ ͪ PUUR1t߭ͪ3 PUUR1JQЭPЏZ   R
RP
Q{RPQPQWխ1ŏZ   W~]  PSU1Z WS ?ͪ PUUR1 VW9PTŏZ   VQPxTPQP@2P`
U1 PTT
VVWVWWݬŏZ   VRBn P6BcP<`PP
"BcQaX<XPxPPRP@2PЬ`aUPUBPVVWVW$Z WS ?ͪ$) PUPU
PUPS  ͪ 0   r  UPΨ^Yq:r  ͪͬͭͮU͵ͯͮ~<ͪ~ PZZR1͹ ͪ PZZR1}߭ͪ1 PZZR1SQЭPЏZ   RRPQP{RPQPQ[խ1ŏZ   [~e  PTZ1Z [T ?ͪ PZZR1 VY[1 PݬŏZ   YWG PnXxXRWRB2RbNXUU	3ŏZ   YSPxURSRUPxPPSP@2P`QB2Pa`UU	ŏZ   YRBdRbZVVXX
V
YY[1iY[$Z [T ?ͪ$' PZPZ
PZPT  ͪ p  ZP ^ЬPPPЬPPP
PЬP
  PWP<~
  PUW  V1~
  PTWk  Ub  V1P<~ U@ ~, ЬR8 db< <~ob PVVP1A
ЬR-J Sc:cP~Hc~Tj ߭Ԛ~PVVP1 Uݭ <~I@  PVVP1 ЬPÞʟĚ~<~ PVVP1 ЬR߭  W ߭Ο PVVPhW ЬP,$ PVVPG<~ݭ<~hA  PVVP-߭Ο ЬQaPP  , U	  RbTbWbVP MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^RЬ8߭ Or PխТ8QЭPGP T^VTސԭWY|[ce|go#qޭsw {
}W̓@͇͉͋|͏߭<~q PUUP1խ+ޭnо Pՠݠqk о PԠݾ `k Ծ 9k PU1;ݭ<RRp ЭPԠЭPԠЭPЭPRL߭J  ЭP߭o  ЭP ЭP ߭R  1P߭<~a PUUP1 柭͖fݭ<~Q PUUP1|P   111k[ЭPg͖SSSS/ P|~ W|~ PWP1~Mԭ߭<RR_ SfX XRm  <  ~1P͖͖QQaЭPѭ`1
߭<~  PUUP1Ф8PGЭPФ8PMQ*QРPA1 1bWߦx( "PWPP@WWPPPx PP@PPPx ЭPxФ8PM~<RR￙ P1 ЭPԠ[Rnl  <  ~1 PЭPԠ1 Pԭ߭<~] խSݭ7͗P PSߦ͗6 ͗<~k  <  ~?߭}  ЭP߭  ЭP ЭP UUPP  ^SмRԭbԭ촢߭䟭 PTP{<QQ<PxPP@!P}`QPQݭRR PSSP1 /߭fQ PSSP1 ݭR PSSPm1lT!  
߭<PPK߭ݭW <PxPP!P~Rf PRSR<~l R9R~ݭV խ
߭VQ SPP ^ЬRbPՠݠf bRԢЬRbf b   MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^޼R  P  P  ^P  ^ŏ  ~ P ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^P  ^P  ^P                                                                                                                                                                                                                                                     7                        S $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ;x "     [      ^P  ^P ^լ
Ѭ$$ЬS
RǏ   Rcz  RP{   PQPPRRZ   cP ^ЬSS QcP<RRPQP{RPQPQ P  ^ Խ P ^߭ PP߭q PRЬQaPPPbP  ^)SЬPPQP0|    ^	\8 e    ^ P  ^2 P ^PР0QСP ^PР0QСP ^PР0QСP  ^Џ@B P ^PР0RѢТѢТP ^QPР0Q¬P  ^9\Ь0PРP  ^!\<   P ^
TެScQcPRRRPRQPQ{RPPQQ0PcQcPRRRPRQPQP{RPPQQݬb PSݬD~- !SPЏ`ЬެQQQ<SSPP< ^UNSլTTRbߥ~A~-  !  < Tb  ^=W
VլAЬS8SRbߧ~A~1-  Ⱥ ¢<Rbb PլݬTdߧ~A~,  x ѤЬPѬg~9PSP~ݬS̺ ЬU8URbߧ~A~y,   ¢<Ra SPѬg~PSP~ݬS^ ЬT8TRbߧ~A~,   ¢<R<a SPP ^ŬSSXPR
S R RPP ^RլPѠߢ' z  )   ^ n`  ^ެRb` b   | ^)UЬPP   < TPTTR$0PSPR~0PTPTc|RTЬլ ,a  PVVPP cPRЏO!ų cPPУ P SP ^SЬRѢ ݢ 8a  ݢ `  ЬPݠРRBDR   ^ЬRѢ ݢ `  ݢ `  ^aW YZЬUެScc  cˏcRRRRcѥ 
ݥ `    RSR1CbO!,gi  v Pߧ$i ߧ.U`  RPѢP-ߧ>i  > Pߧdip ߧnU(  Ѣ
RSТR1{P PѢPFS	ТePТЬPЬXXѠРץѥ 
ݥ (`  RPТTЬRЏO!bRQâTЏO!aQSQeQТЬPЬXXѠРѥ 
ݥ _  RPݬ0PR'ݬI~( ѥ 
ݥ _  PЬЏO!bRЬTЬXXѤФѥ 
ݥ A_  RP^EWj XЬSѣ 
ݣ ^  RRTѢT"ߧ~hѵ   Pǣ h bO!#ǭ h  ^ P h SU¢  QPQPRcPRԢ+PRQPRcPRQPQPСQP֣SCѣ 
ݣ C^  P ^ЬQѡС  ^ЬP¬ | ^TB VЬS  RR1 RPѢP# f  n Pf bO!#f  B P6fs RPТUPUТPРRף1wPUR1nPP< ^iS UЬRRTR@e Rb ɳ PWebݬaebݤdeebݤݤݤÐebݤݤebݤebݤ ebdR PݢݢݢRe ТR< ^Sֳ T   RURDbO!CdN U)RPѢPjd0 UPТRPUP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^P  ^P  ^P 4^߭̚~<~ﭒ  PRRPլЬPЏ`RRRP 4^߭̚~<~m  PRRPP 4^߭̚~<~I  PRRPP 4^߭̚~<~%  PRRPЏ P 4^߭̚~<~  PRRPԼP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP p^oWﬣVUͼݬ$  PUURRP< ~ ͼPď  PfR@K ͼPď  PfR@K|ݬ=c  PUUR1ͼPď  PfR@KvD gv< Rb>vbߧvbͼPď  PfR@O| @  ͼPď  PfR@KRbͼPď  PfR@MͼPď  PfR@NͼPď  PfR@VRvbͼQď  QfPAPAO~AKR<b~  PUUR1ͼPď  PfR@ZRb	bsX  1ͽ ͼPď  PfR@K~ PUͼPď  PfR@VRbURU1sͼPď  PfR@E  ߧ	ͼPď  PfR@	N ͼPď  PfR@)RbͼPď  PfR@-RbͼPď  PfR@/R<bͼPď  PfR@5RbͼPď  PfR@=RbͼPď  PfR@38ͼPď  PfR@	 ?@E@K' PU<RR8U1o|tRtxRP8P~?ͼQď  QfPAEAK
 PU<PPU1"   RͼPď  PfR@E@KR<b~ nPͽ ͼPď  PfR@K PUͼPď  PfR@VRbURU1 PͼPď  PfR@E! ͼnT8 Sď  SfRC	 8fRC	 ?CECK PTTRTTUUR0ͼ~ PUURݬͼPď  PfR@^ UPP μ^RЬQ<PСQ<P~mQߢHQK PP~|~ݬa PSSPݬ. SPP ^S8 Rď  R؞PB	 8PB	 ?BEBK PSSPSSP< ^UTRď  RePBASc'B=Px`~aS PcePBAP`TFRď  RePB)P`ePBAQa8?BEBK1 PTTPTTTPP ^Sݬ  PRRPQď  QcPAEAK PRQď  QcPAAP``R Qď  QcPAAP`RPP ^/WlTݬ]  PUUPЬSSC  PVVPPR`PQď  QdPAEAK/ PVQď  QdPAAP``?R Qď  QdPAAP`VRRUPQď  QdPAKΪ ߧ$Ī Qď  QdPAVP`Qď  QdPAK PUQď  QdPAKd Qď  QdPAK PUUQď  QdPAVPԠ UP^Yݬ  PZZRRPլ0Z1|Sď  SiRC5Vf!C/UC)TedTC=RxbR8RTRWIfWSď  SiRC5W?CECK PZZR	<RR	Z1PЬTSď  SiRC-Rb(Sď  SiRC)RbRR->0<(~~<~~  PZZR1߭Sď  SiRCK1 ߭ЬR  RW?Sď  SiRCECK PZZR18WЬR/~-~<(~~	PZZR1Sď  SiRC-P`Sď  SiRC-R<bPP  bUWWQď  QiPA)RUbDSď  SiRCAXhVC-   TxUP@fP`dUWQď  QiPA)PU`ښQď  QiPA)RUb1MnT8nSď  SiRC	 ?CECK PTTZZR$Sď  SiRCECKR<b~ ZZP ά^T<P0S1 PЬQa<~\QߤHQ: Rď  R
PBKͲ ݬͲ Ͳ퐬՘PBO~<~c PSSP0S7PͲ~|~ PSSP0SPݬ SSPP^eVRď  RfQB)P`X<XTxTSBAPް PC`P`fPBAP`PCfPBAP`PCfPBAP`PCPЬ`fPBAPް QnCaRWR<TPxPP8P~?Qď  QfPAEAK PWWPPQPWQQYYRQď  QfPA)P`RP< ^ݬr  PUUPPď  PXR@bSЬT;/T<RxRRУAPBP`?EK> PUTQУAPB-UP1 У5<RxRRУAPBP`5߭УAPBP`?EK
 PUUP\<~~UnT8nPď  PR@	 ?@E@K PTTUUPE<K~ UUP^YW<SxSSެVfTď  TgPDARbRCXUfSď  SC)RUb;xURgQDAP`PBXfPď  P@AP`PBUgPC)RUb<UUVTď  TgSD=RVb2D)RUbRRxR~UxUUDARbSEc<RxRRBc3 Tď  TgRD)RbgPD)Rb%bgSDAR 8?DEDK ^=X<SxSSެWgVď  VhRFARbRCPCQgUď  UhRE)RQb<xQThSFARbRDPgRď  RBARbRDQhRE)RQbQެVfPď  PhR@)RQbH  Uď  UxQThSEARbRDfRď  RBARbRDQhR@)RQb<SxSSTď  ThRDARbRChRD)RbhSDAR 8?DEDKG PYhRDEDKR< ~D YPΈ^Y
͚ݬ  PZZR1Zլ0Z1ެ<ެX   W?ݮh͚~ϒP[<[RR  +Z1yݬ<[~ݬ0  P1TЬUѥ	ѥh1=
*1+եD1#~͛O ͛ PNV͛F P͛T   ScRdQRQ@R@͛QRQ
V	TSPصV1 hLK<gDgܐސߚ͚Sď  SRCOᚭ~<~ ͛知0͚Sď  STRCKߩ)ݭ^ ͡~|~~ PZ>P ݬ<[~ݬ0  PZ

ZR1`ZP^WQެXhSď  SgRC)RQb1   [ď  [PZgRK)RPb1 Z1   Vď  VQYxPUgSFARbRERRYdhRď  RBARbSERRTTDERʏR6ZSď  SgRCARbRERRgRCAR޲ REbR<bPPhSď  SgRC)RPbZ1cQhSď  SgRC)RQb1<P ^R8Qď  QﴐPA	 ?AE AK   PRRP ^Rݬ<PxPP8P~?Qď  QbPAEAK PRRPRP^Z0UVݬ  PVVR1<SޮYSޮX>ޮWPSď  SeRC)RPbAPxPReQCAQޱ QBaRb
PT#PPRď  ReQB)RPb   TTVVR+V1됬Sď  SeRCO~<~ PVVR1 Sď  SeRCKݭ< <RЭS<R~;~SߪHS <~ݬ   PV1 7 PV <~<~ݬ:PVVRVOVRIDXRR;Sď  SeRC^}                                                                                                                                                                                                                                                   8                        P $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              
 "     l      ͍ߪ. e VPP ^
R<~v}ݬߢH   O P^%VXݬ  PXXR1%Sď  SfTCdR<TޮZTnnY>ޮWPTď  TfSD)SPcAPxPSfQDAQޱ QCaScnPU$PPSď  SfQC)SPc   UUXXS1 Pď  PfS@/ScЬUU<PxPPТAS@Sc?Tď  TfSDEDK3 PX<TxTTТASD-<TxTTТASD/XS+XPXXPP^ьUYݬ
  PYYR1<SޮXSޮW>ޮVPSď  SeRC)RPb@PxPReQCAQޱ QBaRb
PT#PPRď  ReQB)RPb   TTYYR1JЬT<SxSSPď  PeR@ARbR-C-~<~~ϥPYYR1<SxSSPď  PeR@ARbR/CPď  PeR@/RbRR~<SxSSPď  PeT@ARbRCRb~?@E@K PYYR+YyP<TxTTPď  PeR@AR޲ P<SnSWD`TVT<WRxRR8R~?Sď  SeRCECK2 PVVRRSVSSYYPP< ^͊Tݬ  PUURRPQRď  RdPB)RQbPď  PdR@)SRď  RdPB)RSbVPxSRQď  QdPAAPް PB`P`~<S~~PPSQď  QdPA)RSbP< ^UPެTdQď  QeRA)RPbE Sď  SxPReQCAQޱ QBaRbPPPdRď  ReQB)RPb< P< ^Uݬ{
  PSSRRPTRď  RePB=RTb" RDbTQď  QePA=PT`TRď  RePB)RTbpxTRQď  QePAAP`PBPP   -xTRQď  QePAAP`PBQQ޼SB`P`AcTQď  QePA)PT`PP ^Sݬ	  PRRPQď  QcPA3Qď  QcPA)P`Qď  QcPA=P` P ^Sݬ(	  PSSPQď  QPA3nR8nQď  QPA	 ?AE AK PRRSSP^ｇUݬ  PYYRRP<SޮXSޮW>ޮVPSď  SeRC)RPbAPxPReQCAQޱ QBaRb
PT#PPRď  ReQB)RPb   TTYYR1 <SxSSPď  PeR@ARbRC<TxTTPď  PeR@AR޲ P<SnSVD`TWT<VRxRR8R~?Sď  SeRCECK PWWRRSWSSYYPP^iUYݬY  PYYRRP<SޮXSnnW>ޮVPSď  SeRC)RPbAPxPReQCAQޱ QBaRbnPT$PPRď  ReQB)RPb   TTYYQ$<SxSSPď  PeR@ARbRCQPP Τ^GSݬ|  PRRP鐬Qď  QSPAOퟭ~<~ PRRPQď  QPAK. <P<P~+tݮߣHݮ Џ   ͭ߭R PRRP
͵P+RRP| ^_Uݬ  PTTPQď  QhPAO~<~ PTTPQď  Q/PAK? <P<P~<sݮߥHݮ <~ݬPTTPS վP<`PRݮS PV ݮՑ TP ^ЬP`P<`PPݬݬ PR ݬ RP0x%02.2x from %s of DestroyNWQueue
 ShmDeleteNodeSLList  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^ STPтRŏ  PQAbQaSPP   P   PdR   RRUUP!Qď  QPAZRb 9  UP< ^ STPYRŏ  PQAbQaSPP   P   PdR   RRUUP!Qď  QPAZRb9  UP$^VXUW<~ PUUP > ︁a8  ~1 <~ݬ<~S PUUP1GW~ݬ<~ݬ<~ PUUP1!SrTP  Rŏ  PQAbQaSPP   P   PdR   RRUUP1ЬRbf߭( ߦݬ# ߭ݬ ~1 b<~Of PUUP1ЬSS PSs |~ Sﮀݼ<~ n 42Ss@  PUUPPߦy1#%'()2 m  40*)~<%~ڭ PUUP1  %Į PUWrSď  ShPC`Pм`rRď  RhPBrRď  RhPB  PUUP~ݬݼݬPUUPd~1ݼ<~	e PUUP@~1ߦCݼ<~d PUUP~1ݼ<~d PU  U*WW ݼ<~ ݼ<~ 
6  UPP ^P~RPŏ  PQAbQaPP   P   PP< P^~UY[Vݬ<~ PP~15    ЬWWSTP  Rŏ  PQAbQaSPP   P   PdR   RRXXPQď  QePAZRb4  XPPP0Y1VPЬSTP  Rŏ  PQAbQaSPP   P   PdR   RRYYPmЬWWSTPХ Rŏ  PQAbQaSPP   P   PdR   RRZZPQď  QePAZRbd4  1ݬ<~P[Qď  QePARb  S߭Qď  QePARbz  PfPݭ>2 Qď  QePAP`v  PVVPSόPbv߭Qď  QePAP`  PQď  QePARb$   ݬ<~ޘ PYSYPYЬVVSTP  Rŏ  PQAbQaSPP   P   PdR   RRRPQď  QePAZRb2  Qď  QePARbRď  RePB`P`Rď  RePB - {2  [P[RPYRRP^}{Vݬ<~PWWRR   
3 QP3RQQPЬUUSTPЦ Rŏ  PQAbQaSPP   P   PdR   RRXXPQď  QfPAZRb1  XPPPP߭߭ݬݬPWЬSTP  Rŏ  PQAbQaSPP   P   PdR   RRWWP1 ЬSRď  RfPBccP1 ЬUUTQď  QfRAPxPP@eSARb  PWWP0WuP߭Qď  QfPARbi  PPнЭPQď  QfPAP`  P#߭Qď  QfPAP`  PЬUUSTPЦ Rŏ  PQAbQaSPP   P   PdR   RRYYPQď  QfPAZRbD0  WP^!yXVݬ<~ϑPVVRR   3 Q3RQQPЬUUSTPШ Rŏ  PQAbQaSPP   P   PdR   RRWWPQď  QhPAZRb0/  WPPPP~ݬ-PVЬUUSTP  Rŏ  PQAbQaSPP   P   PdR   RRYYPQď  QhPAZRb/  VP^wXVݬ<~\PVVRR   3 Q3RQQPЬUUSTPШ Rŏ  PQAbQaSPP   P   PdR   RRWWPQď  QhPAZRb-  WPPPP߭߭ݬPVPP&V1 ѭ,VsЬPѠF ݠ<~ϗ PVVPJ ЬPݠ wݬ<~ PVVP.V ЬQ /Q~<~ݬPVЬUUSTPШ Rŏ  PQAbQaSPP   P   PdR   RRYYPQď  QhPAZRbL-  VP^Wݬ<~ϠPWWP1ЬRRPSSP!Qď  QuPAZP`,  SPPPP<RQ<PЬSPUQTR<R~T~<U~SPVVPPRPP<~SPVVPPR1PPP$ ~<~SPVVPPRPRRWЬRR/PXXP!Qď  QuPAZP`,  WPP ^<~~<~ݬ5PRRP<~ݬWPRRPPP ~<~ݬPRRPP< ^Sݬ<~PSSPP   3 Q3PQQPЬRRQPTTP!Qď  Q8tPAZP`*  TPPPP <~~<~ݬPSЬRRPUUP!Qď  QsPAZP`*  SPP^Wݬ<~,PWWPP   3 Q3PQQPЬRRyPSSP!Qď  Q`sPAZP`)  SPPPPЬTЬVЬUS߭߭TPSSPPRPfUTqPSSRRWЬRRPXXP!Qď  QrPAZP`)  WPP ^R߭߭ݬPRRPݬݬPRRP< ^Sݬ<~PSSPP   3 Q3PQQPЬRR9PTTP!Qď  Q rPAZP`(  TPPPPݬ<~ݬPSЬRRPUUP!Qď  QqPAZP`(  SPP< Θ^Tݬ<~PTTPЬR͠R{PSSP"͠Qď  QaqPAZP`'  SPPPPЬRѢF ͡ݢ<~ PTTP16 ݢ0qݬ<~. PTTP.T1<(PP	P  +T1 PP

D1 <(~ݬ}PTTP1 &1 -P1 .1 (
1 
- ~ Sc >c0c&D-K.L-PP / /ݬ<(~ݬPTP+TP)TP-TЬR͟RPUUP"͟Qď  QoPAZP`&  TPP ^oVSݬ<~PSSPЬRRePTTPQď  QfPAZP`%  TPPPP<~ݬPSSP<ЬRRPUUPQď  QfPAZP`%  \PSQQ~<~ݬPSЬRRPWWPQď  QfPAZP`%  SPP,^qnTVݬ<~PVVPЬRRDPSSPQď  QdPAZP`$  SPPPP߭߭ݬ[PV0V1PP&V1}PݬPVVP/V1`߭<~ ޮUЭSޭޮWQď  QdPAP`y  PYYP   R1 PݮQď  QdPAP`y  P`ЮYѹ SRXPQď  QdPAP`ly  P   R-PݮQď  QdPAP`qy  P   RRP|<QUQЭSH~! PQ   R:PSaQUQď  QdPAP`rv  PXXP0                                                                                                                                                                                                                                                   9                         ! $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              a "     }      XXRRVQď  QdPAVЬRRYPZZPQď  QdPAZP`H#  VP ^H~! PQPЬaQQď  QkPAP`u  PRRP0RRP^kTnnVЬSޭޮWnQď  QdPAP`w  PRRP
   R1 PݮQď  QdPAP`w  P\ЮXѸ SRTPnQď  QdPAP`}w  P	   R*ݮQď  QdPAP`w  P   RRUUP.Qď  QdPAP`~w  PUݭ  P.UUP ^jTQď  QdPARbv  PSSPPެRbެScQď  QdPAP`v  PTPв P`PcQď  QdPAP`v  PPbcQď  QdPAP`v  P< P| ^iUSЬRRPTTPQď  QePAZP`q   TPPPPݬPSSP4߭<~ ݭ~ϵPSSPQď  QePAЬRR_PVVPQď  QePAZP`N   SPP< ^Sݬ<~ϟPSSP1<R"߭,:   ߭߭Ry PS߭R PSS1 ЬRRPTTP!Qď  QhPAZP`E  TPPPP߭߭ݬPS,PP$ݬ<~ݭ~<~ݬhPS
PS&SЬRR1PUUP!Qď  QhPAZP`  SP< ^Tݬ<~pPTTP1 ЬRRPSSP!Qď  QgPAZP`T  SPPPP<~~<~ݬ?PTЬRRpPUUP!Qď  QWgPAZP`[  TPP< ^Sݬ<~ϩPSSPЬRRPTTP"Qď  QfPAZP`  TPPPP<~ݬPSSP1 "	S1 P"0߭<~ PSSPbѭ-SJP
PP#")*<~ݬmPS <~)~<~ݬPSЬRRPUUP"Qď  QePAZP`  SP< ^UЬRRPSSP!Qď  QePAZP`T  SPPPP<~ݬPUЬRRwPTTP!Qď  Q^ePAZP`b  UPP  ^<P^1eTUݬ<~ϡPUUPЬRRPSSPQď  QdPAZP`  SPPPPݬPUUP1 ޮVЬSޭޮWQď  QdPAP`p  PXXP   R1 PݮQď  QdPAP`p  P`ЮXѸ SRXPQď  QdPAP`lp  P   R-PݮQď  QdPAP`qp  P   RRUUP@~ЭPݬr ЬRRPYYPQď  QdPAZP`  UP^cTUݬ<~PUUPЬRR\PSSPQď  QdPAZP`  SPPPPݬPUUP1 ߭<~$ nnVЭSޭޮWnQď  QdPAP`n  PXXP
   R1 PݮQď  QdPAP`o  P\ЮXѸ SRTPnQď  QdPAP`n  P	   R*ݮQď  QdPAP`n  P   RRUUP@~ݬЭPQp    UP ^Sݬ<~yPSSPlЬRRPTTP!Qď  QaPAZP``  TPPPPݬ<~~<~ݬPSݬSP ^RSЬQa<Pa1 ߭߭P	 PSSP1 PP&ݭݭߢOݬ<~溺 PSSPЬQaPP&ݭݭߢYݬ<~z PSSPЬQaPP&ݭݭߢeݬ<~L PSSPЬQaP-SPSSP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ߗZPXM`SR`W	 "`O$>(,UЬY`X  YT`\ݏ  Pc	   Vgݏ < ~  
n Rŏ  RQcPA`P`cPAcPAP`cPAAP`cPAZP`cPAEP`   Rc<VVjXP|~߭ |~ P[[<[[[ߪIXP2RBbNnhRݢ,  RhPRhP Rre PH 0gݭ K P(0ݭPPUUPP~  RhPRШ R,   UP  ^^  PP| ^Tp^VUc^   SPURď  RfSBcRЬbPď  PfR@Og  PUUR1  ݬݬЬSS?PUUR;Pď  PfR@RR ISČ 5WS (WU1 PݬݬSPUURqݬV?ެScPUURGR<PRP<P<B~cPP <B~|~cR<PRPƚUSRď  RfPB`Rb]  SPP ^\S\3  ЬT\\ݏ  PcPݏ ~ݣ j Pŏ  PRcQBaQacQBcQBQacQBAQacQBZQacQBEQa   Pc<P ^RЬPSPQ\ C\< >\|RRP  ^QЬPР\!\Р<\|P   ^QޭPPSPRQPQ`cQPQS`SQSPa`bPμ^ͽ ݬ? PWWPWWPݬi Ьͽ ݬZ ݬЬRbi Ԣ 0($Ь,0R ?ݬݬ PW0WPWЬTЬSЬVUST, PXXZWRZPRP| μ^Ϳ ݬﹶ PVVPVGݬi ЬUЬTެSR0c ?TUս PRRP0RRVVP ^R0ݼ ?ݬݬ PRRP0RRPP ^@ЬRЬQЬP0P ?QR| PTTSSPPђ&     PSSP ^0ݬ ?ݬ   ' PRRP ^SЬQ,ż,T(TSU RbT?ݬݬļ PSSP,<PЬQP,Ѳ Pż,T(TSSSP^V[ЬQѡ$š ,Z(ZС 1 PЬUЬTQRޭSТ$cŢ,$Y(YY?TU  PW<PPWWPЭ$PXXPPߦ  8ЬPŠ,Z(Z[ЭЬP,ݬZ?ݬݬ PXXP[RЬP֠ XP ^ЬRТ$Ţ,$T(TT?ݬݬo PS<PPSSPЭ$< ^SЬP,<~
 PSPSP`ЬRТ$Ţ,T(TST?ݬݬ$ PUS(
 UPPЬR $ P< ^]SЬPѬ ߣ4e PЬQš,U(U,ݬU?ݬЬRR PTTP
ݬ<b~ﲿ TPP^ЬVЬUЬRЬTW,<~+ PW
   SGWPТ$`Ţ,TY(YWY?UV7 PXW; XP
   ST$SSZZP    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^TθRЬSߤdݬRd PcP|4 h#|h'h'xN  P  ^  d P ^R QaPP QPRPP*QP`/ЬP`
Q`Pa/QP`*ЬP`
Q`PQPa
QPRQRQ^פֿU.KYOXܷT    ݬ< ~h#
c P0Pg'h#V0nnWRVQaPP QPRS_PP*QP`/ 	Q a/QP`* 	Q  QPa
QPRQRQS1Oݬ=߭D  ЬRb"bPPaPz
P~7b PbRbhSc?Pݬcb P%ߥݭb P`ݭݬ|b УPSciRb1Pݬb`b P%ߥݭa P`ݭݬ4b ТPRb1< ^ݬb nnS )P PPaPzP~Za P nc TMRb#ba PТUT	PRbT0IRb%Pba PТUT	PRbTPU P ^߭ݬ(PPP   Pݭs  PRRPP   P a P  ^)\0 ^RR1MRb#Ѣݬb` PPRbPRR0HRb%PѢݬb` PPRbPP ^R-LRbPѢbݬI` PRbPRR(GRbѢbݬ` PRb< P ^*PЬRbPPaPz
P~S_ Pb֬P ^ݬ_ PP&_ PRݬR_ RP| ^VмS
ЬP`Pc Sc լSݬ__ RLP~SW_ PTլSݬ5_ RVPdUdլSݬ_ UdTRRެScTT_ TPPRRTb PbRRcb VP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^!Sգ00 Tŏ  TP@4Rb	T߭ݬPUURPTŏ  TRB4P``ݬB6.^ B5RЭbP	TT
Z VUŏ  URB4Td&VB6] PdB5RbxP	UU
   RPRPPP< ^ASUPŏ  URB4Td&ݬB6] PdB5Rb	UU
PPP< ^R2UPŏ  UP@4Qa|~@5P`\  	USŏ  SP@4P`APŏ  SP@5P`P   Pݬ   PTTP	SP ^?R2TPŏ  TP@4Qa|~@5P`[  r	TSŏ  SP@4P`=Pŏ  SP@5P`uP   Pݬ  P	SP ^
SЬP`T`ЬRb0:xԭ8߭cy[ &P߭ߣRe[ P߭ߣRQ[ TЭP^U|Yn[ЬWg g	Wg g	gPWXPg0g9
[n1PgQ1QPP 
   	V?PP 1P 
| j j j j 
P"?PPx   1Px    . 1P?Ph0WPXP1xP[P[ZYgZn1GnY
[	ZZYZYj޼TXRWScVcb0:xԭ8߭eY &P߭ߥRY P߭ߥRY VcЭd1 PXRWScVcb0<x!ԭ:P߭eY &P߭ߥRqY P߭ߥR]Y VcЭTYQQ&ZQPP&? S S S ' / S 7 	?PP|   +-T&PTPTPЬQaPPTaPTYgPWXPW1P ^ЬRb b	Rb b	b"RRY RPPQQR-aPP 
P	P
aQQRaPP P	P
QRa"aRݬX P   ^Qޭ                                                                                                                                                                                                                                                   :                        Q(c $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              3 "           PPSPRQPQ`cQPQS`SQSPa`bЭP    ^QޭPPSPRQPQ`cQPQS`SQSPa`bЭP    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^  MRB   ^P  ^P  ^P ^ݬiV PRPR B< P ^R߬6V PSPSݬ3 B< P ^͍R߬V PSPSݬh B< P ^R߬U PSPSݬ VB< P ^eS߬U PRPP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^5Rݬt P0PТ0 P  ^	QС0PP  ^\լ0ݬ0y Ԭ0PP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^Rߢ0ﶖЬP0  P  ^P  ^QЬPР0P ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^߭5U ЬS7cŏ   cRQRP
R
RP
Q{RPQPQ P  ^߭T k7P  ^QЬP 0   ^߭ŕݭw*   й     ^ $     invalid character too many separators element too long total too long program bug                                                                                                                                             	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MakePathString() failed after %d due to %s in:
%s
 ConvertTokenStringToCString failed; MAX_PATH_LENGTH  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ެSc~ݬЬRRO  P@  P^YЬTZ|VRR   RQQ<Q[S[1 ЬnC UUP@RRPP 	 > / > 3 o > > > > 1 r?PpXYU1 ~PUPUPPUUVR	VWVW	
WVWPVPMSXYbPTRTUPP\   /QPUQQb|VZZ(XY.P2XY!SS[12PP   	 XYdY   M[ݬN K0VW M Pｅ9XS{9YP ^ݬN Sc:N PRTbRݬcRݬcTTP ^,   ݬRݬR<~	 PWWR1ݬM :L PSRS }M PSSZcSc/ScSݬOM ݬ<~{,  PWWR1 ݬ~<~l PWWR|[/.ݬ~<~l PWWRZЬRݬL (ݬ~<~ PWWR,ݬݬL ЬSSL PVVFc/FcWWPP ^ЬSЬTTL PRRcPRTPwL TR  ^լPݬЬRR<L /RK PQQRa%PQaP:RyK PQQaPbPP ^YTլP/ЬSS>K PRR:S)K PRRSRRK PRK Pߤ76PRݬ{K P| ^قVSЬPP >B1=?PƇ ݬJK P,ݬ6K PS1Ɖ ݬK Pd,ݬ
K PS1 ЬQa1 aPP!PPS1 aPP"5P[/P])P:$P;P<P>P+P=P,P|SyPaPP?P*PPSYPQa1{ЬP|TR`'P`.`	RPPRUTP`UTS	PPSSP^uWЬVUXլmPfYVYQUQPP   )~ϾQUϒǌ 5ЬPE``PYRRTTVЬSEcI RU/EcUTVXXլ
UR޼SBcP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ݬݬЬRRI @bbЬRR
I @bbPP< ^ѬѬPPЬR֬bTTRR*1%1 R?1QR   1
RPP                        J 1 P?PѬ1k֬1eЬRR1XbPP.1MR1EѬP Rbݬݬݬ PPP֬ѬbߚP ScЬRRݬݬPPPbPP.PRѬc͚PѬ1ЬR֬bPP.1PѬPЬR֬bUTU1P ^ެTdrG PSRS5  QBaPP?B PP*P   	P   PRRSP| ^ݬ  VUTUQVRbS1 1 S*1 SPP*                      
P6?PP   gP   ? _ _ _ W _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ 7 1?Pa*PTaaPaPTaabQR1-ݬ럭ePP ^ݬE RScP+P.$	P   STЬPRЬPRԠSRPЬRTQ P`R	ЬRQPQ ^TЬQ RbS1 1 S*1 SPP*                      
P?PP   cP   ? [ [ [ S [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ 7 -v?Pa&PTaaPaTaabQR11^XЬTЬQaSСRЬUedPP  1 I m   1 P?Pա{PPPסkPաcPPPסSPXաGPPס<ա7PPס,XաSסաRסX.
PT1ZPeURb.b   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP(^)VЬZݬ߭C Ԯ X  [ [C T0UeYYSS'QSPR	RP	Q{RPQPAPxPPPY#QSPR
RP
Q{RPQPAPPYTTP@ QaRYPxPPPRa
TPY@ UT[߭B jYTjQ   ScPxPRaPxPPPRRaQSTYRxRSRxRRRSSWjUTdYWWQxQQYRˏRPPQA0SWWQQxQQRPxPPQP@0PxPPPSYYedUTW߭ 9B < ,^޼PPSޭRRPRTSRSb`SRSPbPSPRcbdЭU߭ݬU   SSޭRRPRTSRSb`SRSPbPSPRcbdЭUޭRR~ݬUp   RSRPCBRSRQTQ RADAbQTQPP  ^ݬݬݬ~~~y4^XЬ  ߭A RRRTRSdRլ׬SRSbPլѬ "RQЬP֬`aQR Ѭ ެYiTլ.Wi V@SQTViTcaPaaSQWUQˏURޭPB`aQUݬ߭   ^X|Y WVgT@  UdSYRRSVRPʏP@gQePPQQSSPRPPYSdTUVZ ݬ? VЬWgUV%VRЬSBcTdSeRB@RxRPPSdPVRЬSBcSeRB@cUVPP^SYVXWU߭ VXWU<`TURVPxPPRPP`PTPxPPP`<`RR  
MRPP`<bTWRXPxPPRPPbPTPxPPPb<bRR  
SRPPbU<`R<bPPR<TRTz  RP{PQPPRBePPTˏ TP< ^TЬUT<SURUSPbTTP    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^=vSRЬ8~ P0~c~E~ʯ   Т0P8  PTTPߣ( Т0PԠJТ0PԠFߢ4PTTPߣ2P&l   ЬPТ004 T   ^U\4   ^=QЬPP8Р00РT4  ^Rݬ.= PP P0P 0 < P ^Rݲ0ݬ< P ^RТ0Sݬ< PP PТ0PՠPݬТ0P   < P ^qRТ0Pݠݬk< P  ^QPР0Q-P ^9QС0P-P  ^!PР0Q.P ^	QС0P.P  ^PР0Q/P ^QС0P/P  ^PР0Q0P ^QС0P0P  ^PР0Q1P ^yQС0P1P  ^aPР0Q2P ^IQС0P2P  ^1PР0Q3P ^QС0P3P  ^PР0Q4P ^QС0P4P  ^PР0Q5P ^QС0P5P  ^PР0Q6P ^QС0P6P  ^qPР0Q7P ^YQС0P7P  ^APР0Q<P ^)QС0P<P  ^PР0QЬBP ^QС0PРBP ^Sݬ9 PP PRPݬR9 У0PRFP ^RТ0QաFPݡFݬ9 P ^qSݬ9 PPE PRPݬRO9 У0PRJP ^-RТ0QաJPݡJݬ9 P  ^PР0QЬP ^QС0PРP ^RТ0PN<<   P ^QС0PNP  ^PР0QPP ^QС0PPP  ^iPР0QЬQP ^QQС0PРQP  ^9PР0QЬUP ^!QС0PРUP  ^	PР0QЬYP ^QС0PРYP  ^PР0QЬ]P ^QС0PР]P ^RТ0Sݬ7 PPy PÃ Т0P PݬТ0P s7 P ^YRТ0P    O7 P  ^5PР0Q8P ^QС0P8P  ^PР0Q:P ^QС0P:P  ^PР0Q>P ^QС0P>P  ^PР0Q@P                                                                                                                                                                                                                                                   ;                        ,} $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            ^QС0P@P ^uPР0RoP ^]QС0PoP ^ERТ0SݬR6 PP PqТ0PՠqPݬТ0Pq   6 P ^RТ0Pݠqݬ5 P ^RТ0Sݬ5 PP PТ0PՠPݬТ0P   5 P ^RТ0Pݠݬ5 P ^eRТ0Sݬr5 PP5 P!Т0Pՠ!PݬТ0P!   /5 P ^RТ0Pݠ!ݬ5 P ^RТ0Sݬ5 PP P%Т0Pՠ%PݬТ0P%   4 P ^RТ0Pݠ%ݬ4 P ^RТ0Sݬ4 PPU P)Т0Pՠ)PݬТ0P)   O4 P ^5RТ0Pݠ)ݬ/4 P  ^PР0QaP ^QС0PaP  ^PР0QcP ^QС0PcP  ^PР0QiP ^QС0PiP  ^PР0Q    P ^iQС0P    P  ^MPР0QЬeP ^5QС0PРeP  ^PР0QЬkP ^QС0PРkP  ^PР0QuP ^QС0PuP  ^PР0QЬwP ^QС0PРwP  ^PР0QЬ{P ^uQС0PР{P ^]Rݬ0 P g2 P ^9RТ0P  C2 P  ^PР0QЬЬSP ^QС0PРP ^Rݬ0 P 1 P ^RТ0P  1 P  ^PР0Q    P ^yQС0P    P  ^]PР0Q    P ^AQС0P    P  ^%PР0Q    P ^	QС0P    P  ^PР0Q    P ^QС0P    P  ^PР0Q    P ^QС0P    P  ^}PР0Q    P ^aQС0P    P ^ERx~" PSТ0PЬ PТ0PЬ x~ݬS'0 0 PS   P ^QЬRС0P b
С0P P  ^PР0Q    P ^QС0P    P  ^PР0Q    P ^qQС0P    P ^USУ0\Ь"߭[*  PTT\TnУ0\Э PRTN߭߭oЭb|Эݣ4~ݭ,  Rݭ*  PTݣ4TPP^fWTޭRФ0PР]bݤ4+Ф0PРVVn,  ߭V,  PXXP1  RUSЭPՠ<SS2URqPRxU~RrPRUPн@bVF,  PXXP:߭Vf,  PXXPߧFPJ~؟  ݤ4 1p"SUCboSSURqXݤ4XP< ^SУ0PРUݣ4U]+  RլPU+  PTTP+RR߭U+  PTTPݭݬL- 4 !TP< ^AeU
Rݢ4Т0\ЬSS*  ߭m߭S@+  PTT\#ߥW\J~ﲞ  ݢ4 Э\l֬VPS*  PTT\T>P߭S*  PTT\ߥl\J~R  ݢ4T yP4 =TP< ^]dU&Rݢ4Т0\ЬSS)  ߭l߭S\*  PTT\$ł \J~͝  ݢ4 Э\l֬US)  PTT\T>P߭S)  PTT\ś \J~m  ݢ4o P4 YTP< ^ycUBRݢ4Т0\ЬSS)  ߭k߭Sx)  PTT\$ŵ \J~  ݢ4 Э\l
լY׬TS(  PTT\T>P߭S)  PTT\ \J~  ݢ4 P4 qTP< ^bUZRݢ4Т0PРSS*(  ߭S(  PTTP$ PJ~  ݢ4
 2ѽS(  PTݭ% WPS(  PTTPT>P߭S((  PTTP PJ~  ݢ4 P4 TP ^uPР8QСPMRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^YbUVRSSS P<Se~E~ܚ   
ߢ8PVVPߥP&ﳚ   ЬPТ<$Т8LTެSTcOPTQQA<P`Т<PAP`Т<PAP`Т<PAP`Т<PAP`Т<PAP`TTcP  ^\8  ^iSԭ ;( RRУ<PBP`У<PBP`
( P߭ p߭& PTPУ<PBQaTTP  ^QЬPР$<РL8 ,^TVЬSnnZޮ[ޮYXR`RUUSФ<PC`QaDݮCP`O' P/Ф<PCP U<~ PXPRPRRXXRRRЬRM`0PE1 PRRB<Rb1 |~ݬ~   PVVR~  VR
[~h  PPФ<R@R qԭ m& SSФ<RCRbФ<RCRb?& P߭ p߭@$ PWФ<RCScWWVVP1[~ė  Џ   P^W|Xݧ8FެVfRU4Ц TUSSЧ<RCRb% P	X1PUUЕ1&1$ЬR21VVЧ<UFeRb1FR 1 TTSRSR1 TT(FeDeЧ<RFRb% P~ PU	X1PެScTTЧ<RDRbU$ cSSSЧ<RCRUbЧ<RDRb$ P~g PU
X1PެTdSSЧ<RCRbUZ$ dTTSSЧ<RCRUbT PXXR1aЬR2$ P~ PVX1:ЬR2
$ P~ PUX1ЬT2SSЧ<RCRbb2# PYЬRV# 2U# SSЧ<RCRb	b SSЧ<RCRVbЧ<RCRb	by SSЧ<RCRUbSSЧ<RCRb# ݬ PXXR*Y&SSC<RbЧ<RCRbЧ<RCRb8 XP< ^SUTTRPRRqQQУ<PAP`P`USPRRУ<PB`P`<`У<PBP`x У<PBP`У<PBP`[ У<PBP`UP  ^uQPQ2QP| ^!TRFRQQQVGQQФ<RAbP`0<S"AP ~S PV
PVPV2VPP ^TSSRRRS+PPФ<Q@aRb@RbSSS2SPP ^ETSjSRRRS+PPФ<Q@aRb@R SSS2SPP| ^TVRaRUUSФ<PC`QaDݬCP`  P/Ф<PCP U<~~ PVPRPRRVVP| ^]URRQQQ	V1 PR<nRRRORQQQTCSSPХ<R@bQa+<nQ@P SQ~ PTTPTTPP"QQХ<PAP`ݬj VPVVP^XW~VSSRRR	X1 PR<nRRSoSRRRUCTTRЦ<QBaP`+<nSBR TS9} PUUPUUPPF~<~} PRP߲
ЬSS} ݢSu ǅ Sh XXXP| ^URRQQQ	V1 PR<nRRRsRQQQTCSSPХ<R@bQa+<nQ@P SQ=| PTTPTTRRQQХ<PAP`VVVP| ^URRQQQ	V1 PR<nRRRRQQQTCSSPХ<R@bQa+<nQ@P SQq{ PTTPTTPPQQХ<PAP``VVVP< ^TR<nRRRRQQQUCSSPФ<R@bQa+<nQ@P SQz PUUPUUPP ~<~z PPP< P< ^9TR<nRRRSRQQQUCSSPФ<R@bQa+<nQ@P SQz PUUPUUPP ~<~y PPP< P< ^<+~1 PSP<+~ SQ ЬP)PPTPQdURUTRTPBRRTBUUT2PRTPB2RRTB2URUTRTPB0RRTB0URUTRTB.RRTURUTRTPB,RRTURUTRTPB*RRTRaRR(*  SP| ^uSTݬPRUSЬScQVPV V~RQ:PUUQ
cPPPccPPPcć Q#Ƌ  R UP< ^Sݣ8FެTd~ 
d1  UPdRRУ<PBP``eУ<PBP`У<PBRbdRRУ<PBP``eУ<PBP`У<PBRbdRRУ<PBP`B<P`У<PBP`У<PBP`dd1kݣ8^RXSݬqPVW1a&ЬRbRYYR121 ݣ8!U1 UTTRУ<PB`QadBP ZT PMB<P`У<PBP`t У<PBP`У<PBP`W У<PBP`T 	UUݣ8ެT 1  PP@<Rb;dRb~R P*bQQУ<PAP dQaPPPaa?PY~VЬUe~PWWTeRRReȑ T#P  V WPP^Vݦ8οެXh1 U YhRRB<Rb1 h~ P1 hSSЦ<RCRbbiЦ<RCRbЦ<RCRbhSSЦ<RCRbbiЦ<RCRbЦ<RCRbhWWSSRSR)PWRRSЦ<TRR(BdCdWWSSRSRښRRRB<R, b bW~H Phh1ݦ8'  < ^TP
SP
P@dPSPP
,ЬP@XP`PRPxCd~ЬP@:P`PURPUbCdլ	PЬլЬլЬլԢЬxCd~ U Ь||$RP^!VSެXhRSJ  WC R6  TbUݲФP@fP`ݢФP@fP`RФP@fP`URSSެUeRբeSУRbTRУRBfRbTެUeRբ !  SУ RТTRУRBfRbT                                                                                                                                                                                                                                                    <                        ? $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              x "           ScУRBfRbSУRBfR  | ^ЬSݣݬУRBjRbPTSRЬVQТP$ѠVQ``aע(PUPQ`PV~ТSCScPUUSPЬUեݬХRBRbPRХRRݬzPPPRݬݳ ЬUD cЬSVݬݬV SD V P^YXnYެ[kTݤެZjФRBjRbPWG RSR1   VݲjЦP@iP`PdS޼T޴ TbGdPbcЬTТUѤ$2eФP@hP`UФP@hP`PФ U ֤$RЬPРP@hP`PRSbRP ^UެWgSݣެTdУRBRbPVF R$gSݲdУP@eP`PRPbRԼЏ   P ^ЬRТ PQP5Ѡ$ЬRע$Q
Т SУ SPPRТRPPQРPݬЬRТRBnRbPSPЬRТRBQRbPPЬS  ^ЬRѢ$2)ЬScТP@P`SТP@wP`PЬPТ P $    ^QЬRТP.PѠQ
ЬR`P`aЬRע(PQ`P~ЬRТRBRb ^ЬRѢ(2ݬТP@P`PЬPТ`P֢(  ^P  P  ^P  P ^ЬRbQxRQRRPaQPԼԼPQaQС  P ^ռPмPRмQЬSxTcTQTAP&ЬTRSRPCdR
Q`ЬP`PQaPЬSxTcTQTԼ RP ^ЬPR``SRQQSRP`QRPЬSSSPSQPQP{SPPQQPP  ^  P ^ЬP`QЭPЬRRRPRQPQP{RPPQQPP ^SЬPQa
aPPSQaQSPЬRRRPRQPQP{RPPQQPP  ^ЬQЬPѡPЬQЬPѡPPPP  ^ݬݬ   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^ `  PP  ^    PP ^ݬ  PRRPݬ     PP ^ݬ  PRRPݬ     PP ^ݬI  PRRPݬ     PP ^ݬ
  PRRPݬݬO  PRRPݬd  PP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^ |  PP  ^   PP ^լPݬ  PRRPݬ   PP ^ݬ9  PRRPݬ   T  PP ^ݬ
  PRRPݬ     PP ^լPݬ
  PRRPݬݬ
  PRRP 	  PP  ^ݬ
  PP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ЬROPb	SPЬQԱ aPԠaPԠSSPP ^NOPR	SiPЬPՠR`RRRQЬ԰SCЬPհRRRQЬ԰РSPЬPаbRRRPЬSSPP ^NPR	StPЬPՠR`RRRQЬ԰SNЬP`R`Р RRPЬS+PЬQձRбbСPРRСPЬSSPP  ^ЬP`P  ^ЬPР   P  ^ЬPՠQЬPհQ
PЬPаQQP ^ЬPՠPЬPРPР   RP| ^ЬRբV1 ЬRТPbP3`PJNb|V1 ЬRвb.NТbV1 ЬPѠiРT`ެScRT9cQաUPձU	PбUUPPPVRcPTЬRݲMТԲV/ЬRвQaТPСѢQТԲQMVVPP  ^ЬPՠPݬ_M P ^ЬRLPb	SPЬQԱ aPԠaPԠSSPP ^VLPR	S1 PЬPՠ#R`RRRQЬ԰РPԠSVPЬPհ#RРRRQЬ԰РS*PЬQбbСRRбPRСPЬSSP ^KPR	S1 PЬPՠ#R`RRRQЬ԰РPԠS^PЬQСPaP#RСbRRPԠСaСPЬS,ЬQСbСPРЬСPRСPRRSSP  ^ЬP`P  ^ЬPР   P  ^ЬPՠQЬPհQ
PЬPаQQP ^ЬPРPՠRЬQСPРRRP ^ЬPՠPЬPРPР   RP ^ЬRբT1 ЬRТSbS;cSJb|TxЬRвbJТbТRԢTVPЬRТPѢPРݲJԲТT*PЬSУRRPbbRРPJУTTP  ^ЬPՠPݬWJԬP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^Tߤ4߭ PRR? PФ4SSRx	\Q\P\\PQP{\PQPQVUVRcUSRUV  P ^5?WTߤ0߭x PRRߧ8  PФ0SSRx	\Q\P\\PQP{\PQPQVUVRcUSRUV  P^Uե4ߥ4߭ PRP>    WFPХ4TTSx	RQRPR	RP	Q{RPQPQXVXSdVTSVXdWWYYRRPЬSХ4cг 4Գ cRԢcR   YP^=YVUե0|ߥ0߭; PRPߩ8    WFPХ0TTSx	RQRPR	RP	Q{RPQPQXVXSdVTSVXdWWZZRRPХ0Td0ЬRբTbTTTSЬԲZCЬRղTTTSЬԲТZPЬRвdTTTRЬZZPP^<YNUե0|ߥ0߭3 PRPߩ8    WFPХ0TTSx	RQRPR	RP	Q{RPQPQXVXSdVTSVXdWWZZRRPХ0Td0ЬRբTbTTTSЬԲZNЬP`T`Р TTRЬZ+PЬSճTгdУRТTУRЬZZPP  ^ЬP`P  ^ P P  ^ЬPЬ   P  ^ЬPР   P  ^ЬPՠQЬPհQ
PЬPаQQP ^ЬPՠPЬPРPР   RP| ^UЬPՠV1 ЬQСPaP3`Х0`С0a|V1 ЬPаХ0 `0Р`V1 ЬPѠmРS`ެRbPS9bQաTPձT	PбTTPPPVUbPSЬPаQХ0aа0Р԰V/PЬPаRbРQТѠRР԰Х0bR0VVPP  ^QЬPՠPЬPС4`P4ԬP< ^ЬS~ PcU;PTެSTc+ RTQA P`bPAP`bPAP`TTcڔUUP  ^Q޼PA P ^ЬR PbSPЬQԱ aPԠaPԠSSPP ^h PRS1 ЬPՠ#R`RRRQЬ԰РPԠSVPЬPհ#RРRRQЬ԰РS*PЬQбbСRRбPRСPЬSSP ^ȥ PRS1 ЬPՠ#R`RRRQЬ԰РPԠS^PЬQСPaP#RСbRRPԠСaСPЬS,ЬQСbСPРЬСPRСPRRSSP  ^ЬP`P  ^ЬPР   P  ^ЬPՠQЬPհQ
PЬPаQQP ^ЬPРPՠRЬQСPРRRP ^ЬPՠPЬPРPР   RP ^ЬRբT1 ЬRТSbS?cS捻 Ԣb|TyPЬRвb bТbТRԢTTЬRТPѢPРݲW ԲТT*PЬSУPPQ``RСQ( УTTP  ^ЬPՠPݬ ԬP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ PRRP ^ PRRP ^ݬ-PRRPݬݬPRRP ^ݬPRRP"ݬݬhPRRP
ݬ~PRRP   0x%02.2x from %s in LMAgeLogicalLocks
 ShmDeleteNodeSLList 0x%02.2x from %s (%d) of CheckLogicalLockPendingEvents
 ShmDeleteNodeSLList  ^Rߢ8yPPPPP1 Pݏ    AP@բ@ 8  PPP~ PPPjЬЭPР(ЭPPТ8`ЭPТ0ЭPТ4ЭPТ@$ЭP 0PPPPP ﶥݬ   PPP ^Rݬݢ@APP ^Rݬݢ@C ^ɰRݢ8ﵢݏ   ݏ  ߢ0Pݢ8\\P ^uRݢ8a ݏ  ߢ4Pݢ8\\P  ^%\ݬ8ݡݬ@@ P  ^QЬЭPР(ЭPР0ЭPР4ЭPޠP`8ЭPР <ЭPР$@ P ^ﭯRݢ8޼P `ݢ<߭ݢ<HP1 ЬQaPPaЭQPPЭPՠ_ЭPPPЭP>P<`PPy  ݢ<PPPPPϻPPψݭ
ݢ<PP߭ݢ<P1Vݢ8#2  P ^ﱮRݢ<߭ݢ<^P1P߭Э\ݬЭ\Ѭ 1 Ѭ1_P Э\ݬݭЭ\\\Э\>\<l\\P\\kЭ\\\Э\>\<l\\x   $b  ݢ<P\\\\\\ω{ݭP1 Э\\\Э\>\<l\\nP\\bЭ\\\Э\>\<l\\Zx  ݢ<SP\\\\;\\ݭ>&Э\Ь\\\Э\Ь\>\<l\\Ϟݢ<P߭ݢ<P1N P ^ɬRݢ8ﵞPPPP<PPPխݢ8Џ   Pݬݭπ	Pխݢ8Џ   PЭPР߬ݭPP1 PP	P  ݭݬPP<PPϒ P皭PPݢ8G P߭<PP6խݢ8!Џ   P;P<PPݭݬPP<PP'Pݢ8PPPݢ8ѝ P ^aRPP<PPϒPݬݭPխЏ   PݬϳPխЏ   PЭPՠkѬ Ѭ.]PЭPЭPP`ЭPЭP PЭPЭPЭPP`ЭPЭP PЭPѠlѬ 
Ѭ$^PЭPЭP P1 PЭP1 PЭP1 PЭPЭPЭP PЭPѠuѬ ѬBgЭPѠ[ЭP'ЭPЭPЭPЭP  P'ЭPѠ PЭQPPЭP P߭<PPg4խЏ   PlPխЏ   PЭЭPЭЭPP`ЭPЭPЭPЬ                                                                                                                                                                                                                                                   =                        l $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           ЭPЭݭݢ<PPP皭PPPPP2 P ^Rݢ8ݬPP<PPPݢ8$PPP  ^PP<PPPݬݭHPխЏ   Pݭݭ ϭ P ^YRݢ8EPP<PP8 2  P ^RPP<PPNPխЏ   PнխPнݭݭ>Эխ߭ݭ%ݭݢ4  P ^Rݢ8PP<PP8 ϙ2  P  ^PP<PPϕP нխ1 ЭPРЭQСPP   O P?PZPVPЭQPPЭPՠЭP  +[  ЭP ! [  ЭP ЭP Pнխ1oխ  P ^Rݢ8yݬPP<PPPݢ8８PPP  ^PP<PP}PݬݭPխЏ   PЭPР ЭQСPP   N 
Pf?PZPVPЭQPPЭPՠЭP  Z  ЭP ! Y  ЭP ЭP Pխ  P ^qRݢ8]<PPPPPP<PPPݢ8PPP $^!RPP  PP<PP>Pխ P нխ1	ЭPР߭ݭ( ݭݭ욬PP<PP6PݚPP1 PPP<PP߭<PP?/խЏ   PDPխЏ   PЭЭPЭЭPP`ЭPЭP ЭPЭЭPЭݭݢ<kPPPݚPPPPPнխ1	PP PP ^ﭣR ߭ݢ4+PPP3 P߭߭ݢ4DPPP PP  ^޼P`խ7P߭ЭPݠݬݭ PЭPнխ2  P ^ݬݬPխЭPPխ PЭP ޼P`ЭЭRݬ1PЭRբ PЭRТP`RR`޼RЭbP ^aR߭ݬݢ0PPPЭP"Pխ P   ߭ݬݢ0PPP PP ^ݡR߭ݬ5ЬQaPPa޼P`߭ݬݭݢ0pP  ^ЬPР߭ݬЭPЬQСPP   A 	?P^PZP U  ЭQPPЭPՠЭP 1 eU  ЭPЭPPЭP PЬPݠݬ޼P`ѭ޼P`ݭ޼PЭ`խPѽ
Pнխ޼P`  ^$RnS߭߭ݣ0߭߭߭ݣ0P1bz ߭ݭݭߢ\ ݏ  ݭBPݭߢ7 Э\ЬPP  S ' PJ?PVPߢ	 GPЭ\\\\\Э\>\<l\\\\ߢ( Э\ݬߢS Pݽߢ|   ߭߭߭ݣ0P1 P D^'Rݢ8LPݢ4PPPGGPPݢ8Jݏ  TLPݢ4PխP ѭGHЭP@THHPPP<PPRPPѭݏ  TLPݢ4Pխݢ8 ^)Rݢ8PP<PPݢ8_  0x%02.2x from %s of LMAgeSemaphores
 ShmDeleteNodeSLList 0x%02.2x from %s of CheckSemaphorePendingEvents ShmDeleteNodeSLList P ^ﵝRߢ<PTTP1 < ~C-P8!T~'X   ︑ݢ<~|~ <~ߢ0EPSݢ<\STTPNЬPР(PТ<Т0Т8PTTP (ЬSУ(QС0С4С<С8TTPP ^ٜR 8 - ^｜R 8 / ^Rݢ<J~|~ <~ߢ0uPSݢ<SP  ^a\ݬ<֍8 ,P ^=RЬPР(QС0С4С<С8 P ^Rݢ<ﺍެSԳ ݢ4߭ݢ4lP1 ֳ ЭPנЭPՠP~<`~3f  ЭPРQPPPݢ4OPTTP|PQݭݢ8].ݢ4P߭ݢ4P1{< lP ^ARݢ<ݢ44߭ݢ4PrPЭPР\C~<`~e  ݭݢ8-ݢ4PSS\$\9Pݢ4P߭ݢ41Pݢ<ﻌP ^Rݢ4߭ݢ4PpЭPР\C~<`~e  ݭݢ8,-ݢ4PSS\$_\)Pݢ4jP߭ݢ4PPP ^WPݬ P   Pݧ<|߭ݬݧ0PVVR1 鐬 PVVRݧ<RP䐬߭短ݭPVVRݧ<_RP߭ݬݧ0PVVRݧ<4RP 1O  PVVRݧ<RP ݧ<P(鰬䐬߭ݭPVVR	'䐬߭短ݭ-PVЭ<   P ^aRݢ<
ݬ~<~PS< USP< ^)TB  g ЬPPS߭P,PUUPP߭ݭݤ0GPUUPPSP߭ݣPUUR)ЭP`<`P"߭ݭݭݣPRPc<cP4߭ݬݣ.ݭݤ0 M  PUUPPP ^9Rݢ<ݬPS< 5SP< ^	R"  G ЬPPS߭PPUUPP߭ݭݢ0'PUUPPSPP1 ݢ4߭ݢ4
PpЭQСPC~<a~a  ݭݢ8<)ݢ4PTTP$oP9Pݢ4zP߭ݢ4PPP ^Rݢ<慎<~ݬ~<~PS< SP| ^ŕT   ЬRRS߭RPUURP߭ݭݤ0PUURPSPP߭<~խLݤ8&PRR PPbSЭRݤ4IPVVPPP ^Rݢ<ݬݬݬPSݢ<SP ^R   ЬPPS߭PPTTPP߭ݭݢ0PTTPPSPc   PΜ^O[ݫ<ʹ͸ݫ0~PVVRݫ<<<~\ʹ͸ݫ0PU1 B yZ
XTU1 PD\WЧYͬͰYPVVRݫ<ʅ<~ͼͬͰYjPSdPRSAPBͼPͨPhPVVP!ݨWͨP~<~!1PRRS<~ͼͬͰYjPSTTU1L<~\ʹ͸ݫ0jPU1!ݫ4ͤݫ4qPqͤSУRB~<c~t]  ͤݫ8%ݫ4`PPR!RϚݫ4Pͤݫ4 P< Μ^_[ݫ<ʹ͸ݫ0PVVRݫ<L<~\ʹ͸ݫ0PU1 R ZXTU1 PD\WЧYͬͰYPVVRݫ<ڃ<~ͼͬͰYjPShPRSEPBͼPͨPhPVVP%ͨP`W~<~,1	RRS<~ͼͬͰYjPSTTU1H<~\ʹ͸ݫ0jPU1ݫ4ͤݫ4}PqͤSУRB~<c~[  ͤݫ8#ݫ4lPPR!RϦݫ4Pͤݫ4P<  ^ЬQ<aPˏ  PRxRRPʏ  PPRQRPЬSSSPSQPQ{SPPQQPP< ^ЬUЬTeQdPQPPQPPSRSRPSRPPP  ^ЬQѡ 	  ЬPPЬPЬP|~pP  0x%02.2x from %s in LMAgeFileLocks
 ShmDeleteNodeSLList 0x%02.2x from %s (%d) in CheckFileLockPendingEvents
 ShmDeleteNodeSLList P< ^MRߢ8RPTTP1 < ~P@ ݢ8 <~ߢ0PSݢ8ƀSTTP1 ݢ8I <~ߢ4tPUݢ8UTTPXЬPР(PТ80Т0(Т4,Т@84PTTP RЬSУ(QС(0С,4С08С4<С8@TTPP ^=R @  ^!R @   ^Rݢ8n <~ߢ0PSݢ8SP ^ōRݢ8. <~ߢ4YPSݢ8pSP  ^\ݬ8~@ P ^aRЬPР(QС(0С,4С08С4<С8@P ^1Rݢ8~ެSԳ ݢ<߭ݢ<LPsֳ ЭPנЭPՠA~<~W  ݢ<DPTTPPݭݢ@Rݢ<P߭ݢ<Pݢ8c~P  ^y\ݬ8} 8 ;~P^QSݣ<߭ݣ<}P1aV  Y}@  TWX<VPЭRբwѢ1ЭRТRb1bЭRТ\ЭRТ\
ЭR~<~i dݭݣ@gݣ<hPUUR1 ,Rf1 Pн\lRiPѲ&ТQЭ\ТPЭ\
 d8PR\нP`RR\&ТQaЭP	
abRR\bRЭR~<~iݣ<hPUURψRMfݭݣ@g߭ݣ<P1PP(^X,  ݬ sЬVf~<WW P((ݨ8{UWV>TS߭Uݨ0lPYYRЭRbdЭR
cR
P   RRZZR
ݨ8{Pݨ8{P8 {P,^ىX,  ݬ rЬVf~<WW4 P((ݨ8zUWV>TS߭Uݨ0PYYRЭRbdЭR
cR
P   RRZZR
ݨ8{Pݨ8zP<RURV>TS߭Uݨ0P[ЭRbdЭR
cR	P   RRZZR
ݨ8zPݨ8tzP8 dzP ^yR߭ݬݢ0PSSPЭP`ЭP
P< P ^5R߭ݬݢ0@PSЭP`ЭP
PЏ   P^WPЬV~<f~e PƐ V?                                                                                                                                                                                                                                                   >                        )
 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              Am "            PYYR
(Pԭδ(,  ԟݦwapݧ8xS<fUSTԭUÐT߭ݧ4jPXXR"߭߭ݧ4PXXRRЭRRSݧ8xP<~SPRݧ8xP1 ТUe4 ݬB P$eЬTd
 
;  ݧ8xP߭<~խݧ8dxPݧ@PRݧ8DxPSbUЬUeЭRݧ<.PYYTݧ8xTPݧ8wP8 wP<^WЬV~<f~~ Pʐ V= P(	PԭҴ(,  ؟ݦ}nݧ8wS<USTԭUǐT߭ݧ4PXXR!߭߭ݧ4ﰹPXXRRЭRRS<~SϷPRݧ8vPRSφ ϭݧ8vP ^Rݢ8Zv~<~PS8 vSP ^ｄUS<WSVԭWV߭ݥ4ﲺPTTR"߭߭ݥ4ݸPTTRSЭSSTdRbSRTSR߭T'ݭݥ4 PP ^!Tݤ8uS<WSVԭWV߭ݤ4PUUR$߭߭ݤ47PUURSPЭSSP`R1 ТSc
	 8  cbR &8 SuP<^iWЬV~<f~ Pא V/; P(ѭ	Pԭߴ(˭,  埭ݦkݧ8otS<USTԭUǐT߭ݧ4PXXR!߭߭ݧ4PXXRRЭRRS<~S#PRݧ8dtPТRb
	 6  b 8 /tP^EVݦ8sS<UԭUS߭쟭ݦ43PTTR#߭߭ݦ4^PTTRRPЭRRXhT1 WФS߭Sיּc
g
ݭ<g~ϋP1 TPhTTPФScdTTP߭<~խݦ8CsPݦ@PRݦ8#sPXbSԢЭRݦ<PYYUݦ8rUPݦ8rPcg
 :5  dT18 rP ^Rԭ߭ݢ4￶PSSP ߭߭ݢ4PSSPPP ^мR(߭ݢ?ݭݬ  PRPbRPP ^1TмR)P߭ݢݭݬ  PRPbR
ݤ@yPRPмb<WЬU߭Uݤ0PVVPЭP֠ЭSFPݤ@0PS.Pԭ߭Uݤ0PVVPSЭSSPR   RP ^UR߭ݬݢ0`PSSPЭP֠ЭPݢ@PPԭ߭ݬݢ0cPSSPPP ^~SЬRעb'߭ݬ﫶ЭP`
	 /3  bЬPՠ߭P|ݭݣ0۳P ,^}~W߭ݬSЭRbTSTS߭ R -V<TSV~S
 PVVRR   VЭR(ԭЭRբ* ԟ5 P7ԟ8 (PVЭR(ЭR(՟ԟ8 ЬRЬTТSףc&߭T{ЭRb
	 1  cգ߭SPݭݧ0ﯲЬUeRЬSRScTSݧ@TeR!bЬScbSݧ@PbRP< P^}Uݥ8pnTXݥ4PSSRݥ8n<~\TXݥ4PSZTRS-PPB\dPP`
~<~ϼRRS<~\TXݥ4﮴PS8 .n ^E|Rݢ8m~<~e8 m  ^V<TЬSV~T PcVVRR   VЬW(է1 3 PPЬR(7 2PP((短7 2PP^ЬSЬRѣPЬSЬRPPЬSЬRPЬWէ	ЬXը7ЬV PPէ(Pզ(PѧPЬSЬRPP 0x%02.2x from %s of LMAgePhysLocks
 ShmDeleteNodeSLList 0x%02.2x from %s (%d) of CheckPhysLockPendingEvents ShmDeleteNodeSLList ^	X.ZozVj1kPYYRhR&4   nݏ  f	PS mSD 
 <~ߦ8PTݦ84PȽ  E~u4   mT  E~W4   mTYYR1c  <~ߦ<PUݦ<P  E~4   9mU  E~3   mUYYR1ЬRТ(WSpSDjDЦ8<Ц<@}~h Pg,   }  ݦDH	Plݧl.Pߨ E~p3   lԷlݦD	PPݧPPߨ* E~63   glݦDP`ݧ`Pߨ? E~2   0lݦDPhݧhPߨT E~2   kݦDiPLݧLOPߨi E~2   kݦD2P\ݧ\Pߨ~ E~Z2   kݦDPdݧdPȓ  E~"2   SkHﭲPYYRȨ RE~1   'kЧ<8Ч@<ЧDjЧH@ЧLLЧPPЧ\TЧ`XЧd\Чh`ԶPԶLöL&  TST#PݦDLPRжPbRPֶLTSжPRbP׶LRSSTжPdTPֶLѶL  $жPRbSRݦD	SP׶LѶL  Զ`Զ\ö\&  TST!ݦDPRж`bR`ֶ\TSж`Rb`׶\RSSTж`dT`ֶ\Ѷ\  $ж`RbSRݦDS`׶\Ѷ\  ԶXԶTöT&  TST"ݦDDPRжXRXֶTTSжXRТX׶TRSSUжXUXֶTѶT  &жXRТSRݦDSX׶TѶT  ЬTФ(SУ<8У@<УDjУH@УpDcHУLLУPPУ\TУ`XУd\Уh`УldYYPP ^EuR D u ^)uR D u ^SuR 
 <~ߢ8`PTݢ8 Pý  E~T/   hT  E~6/   ghTPP ^StR  <~ߢ<PTݢ<P  E~.   	hT  E~.   gTPP  ^t\ƧeD P ^sRЬPР(QС<8С@<СDСH@СpDaHСLLСPPС\TС`XСd\Сh`l d P ^sRBdެVԶ ݢ@߭ݢ@eP1 UPֶ ЭPנЭPՠq~<~"=  ЭTвXTXֲTѲT  !вXPРSPݢDeSXײTѲT  ݢ@PWWS#SＦPݢ@P߭ݢ@ﵹP1Z`9dPP| ^rVBcd, H } H߭߭ݦ8-߭߭߭ݦ8XP1 ߭ݭ۩ЭRբ~ЭR<RQRPЏ  RRRPRQPQP{RPPQQ\Q\PR
RP
Q{RPQPQSQ\PRRRPRQPQ{RPPQA0CH߭߭߭ݦ8里P1Pd   Dc  ^1b  bPP^QqRݢ@ʷ߭ݢ@9P1TP;  ZUFXYPЭSգ1 ѣ1
 ЭP`\ݬݬ~<~< Э\ݬl~<~pPVVWpЭ\~<~jЭTвXTXֲTѲT  $PвX\ЬS\ݢDeSXײTѲT  ݢ@hPVVS1pSφi1^WPЭ\~<~ЭSЭS߭ݢ<PVV\aЭTвXTXֲTѲT  $PвX\ЬS\ݢDeSXײTѲT  ݢ@hPVVS1  Si1 н\;P ЭPݠ\~<~8PVVPЭP~<~#ul\Э\~<~jЭTвXTXֲTѲT  #PвX\ЬS\ݢDeSXײTѲT  ݢ@hPVVS#sS9iPݢ@µP߭ݢ@P1PP ^WnUݬݬ<~% PVVSSPյd1 <SQSPЏ  SSSPSQPQ{SPPQQRQRPS
SP
Q{SPQPAHTQRPSSSPSQPQP{SPPQA0STTTSTPgq_߭ݥ8գPVVRg_P~<~ݬݬݭσPVVRgZ_Pݧ K_P^]XmYݬݬ<~$ PUUSSPչd1 <SQSPЏ  SSSPSQPQ{SPPQQRQRPS
SP
Q{SPQPAHTQRPSSSPSQPQP{SPPQA0STTTSTPhI^߭ݩ8ﭢPUURh\^PЭRSL   STSTncRaPRVЬQЬWѦQѦQP+P'ѦQQWUUWPUPPPPh]PbRSSTЭRTUL   UVUV}eRoPRTЬQЬWѤQѤQP+P'ѤQQWSSWPSPPPPhV]PbRUUVh;]P  ^ЬPѠѠPPЬPѠ!QQPЬPQPP2 P ^ЬSTQL   QRQRuPaPfPPPTЬVЬWѤVѤVU-PU'ѤVVWSSWUSUUUUP`PQQRP ^iWjUլPѬ¬g[P<nPԭP<nTPSTS߭ݥ<.PVVRԭЭ,n퐮߭߭ݥ<FPXXRPPЭPPR g[PݬݬݬR<~
PS gs[PPP   B B \?PgK[P<~ S~<~DPYg([YP<~S~<~ PYg[YPݧ Z< P$^ЬRТT߭TߠPPRRPԮԮSެ[ޤ оR1 kXRQШWШYѡWѡWV+V'ѡWWYPPYVPVVVV=)Ѯ"kPѢPPѢPbR1pSZԮZPެ[T  оR1 kXRQШWШYѡWѡWV+V'ѡWWYSSYVSVVVV<(Z"kSѢSSѢSZPZbR1qP[լOծ
1Pծծ
1PKPծ1Z/Z	PծѮ	PR1ZѮЬRݢݢ~<~}wgd   ?jg&  SRS+<g1PGg`P?g5gSR/gR
b%ggЬWЧVVVQЧPSSSPSQPQP{SPPQլATbRATPAbRA֤RЭS<SQSPЏ  SSSPSQPQP{SPPQQUQUPS
SP
Q                                                                                                                                                                                                                                                   ?                        vlj $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           {SPQPQVQUPSSSPSQPQ{SPPQAeFf   P߭<~խPed   Ce&  SRS/PePePeeSReRТeeRPЬbЬЭRPe﹠PPSSPP ^菱VެQa¬aaݬݬ~<~PRpIVRP< ^dRQ<TQSTS߭ݢ<UPUUPԭЭUP ݬݬݬU<~PPPPPUϡ
 P ^ٗJU~<~PRｗUPP| ^cVS<UUS߭ݦ<酪PTTRԭЭTPdRbSRT
SRﰬݦ< 'P  ^-T~<~T| ^IcSP<UPTUT߭ݣ<PVVRԭЭPP`R#Pբ ݢݢ~<~HbRP ^T ݬݬݬ~<~PRjCTRPP^bXѬ¬S<TTS߭ݨ<APUURԭЭUP~ݬݬݬU<~ϳPVVPզPQЦPRRRPRQPQP{RPPQQTѦ1 ЦUЦSSDTHcRSYи`iY`ָ\Ѹ\  %и`ScWSݨD
W`׸\Ѹ\  RDT1DTS1PcRRGbcЦYи`iY`ָ\Ѹ\  1 и`RbWRݨDW`׸\Ѹ\  1 cS1 ЦUЦSSDIcRSYи`iY`ָ\Ѹ\  &Pи`ScWSݨDQW`׸\Ѹ\  RD^DSVcRRGbcЦWи`gW`ָ\Ѹ\  0Pи`RbTRݨDT`׸\Ѹ\  PcSץ m  ԦR P ^Q<~~~<~PRQRPP^`VUUSS<RRϩRXSTXT߭ݦ<﷕PYYRԭЭSPcT1 Y<   X UTYXQPWWR1 ~<~=߭<~խPѶTd   3öT&  SRS"PݦDPжXPXֶTSRжXRТX׶TRPTbԢUЭRݦ@ﰚPWWSSPPdT10P ^W^VgOS<TTS߭ݦ<PUURԭЭUg&PPeR# TbSPPd`	RUSReݦ<T   OP ^)^R߭ݢ<PSSPԭP| ^]SԭQ<TQRTR߭ݣ<PUUPԭЭ*퐬߭߭ݣ<﹑PVVPPP(^߭ݬ<~o PRRPPмSS1 ߭ݣЭRЮTѤP PЮUPbPPPcSѣѣ1 ѬcSSRcScSPSl߭ݣkЭPЮVѦQ PЮWQ`QQQcSѣ
ѣcScSPRPSPPS߭ݣnЭRnXѨPnYP bPPPcSѣѣcS 4^[T߭ݬ<~ PSSRPмRb߭ݢ[ЭSЮUѥP PЮWPcPPPѢѢRPbRѴLd   0ôL&  SRSݤDPдP`PPִLSRдPRbP״LRPмbn߭ݮݤ8ِPVVS	ֽЭUT?CL~ߤh L~ߤhG| ߭𚏤~?ݮݤ8̎PVVSUЭUUPЬЬ|ݬ/ R   RP T^_ZR߭ݬݢ8&PSSPֽЭPTXL~ߢhܢ L~ߢh\ʢ ߭~Tݬݢ8PSSPPP ^YSЬPРRbՠ ݠݠ~<~b߭REݭݣ8癩P^YT߭ݬЭRbYXЬRբ ݢݢX~<Y~ϭXS<YWSVЬUХScե ݥݥV~<W~c߭Sﳐݭݤ8мSЬUSUFeRSVдPfVPִLѴL  &PдPP`UPݤD%UP״LѴL  RSPccSЬRbcRUдPeUPִLѴL  &PдPRbSRݤDSP״LѴL  P ^MXTѴLd   2ôL&  RSR!ݤDdP\дPl\PִLRSдPRbP״LRPP ^WRЬSвPcSPֲLѲL  'PвPP`SPݢDSPײLѲL  P ^WTѴTd   3ôT&  RSR"ݤDP\дX\XִTRSдXRТX״TRP ^EWRЬSвXSXֲTѲT  'PвXPРSPݢDpSXײTѲT  P ^VTѴ\d   2ô\&  RSR!ݤDP\д`l\`ִ\RSд`Rb`״\RPP ^VRЬSв`cS`ֲ\Ѳ\  'Pв`P`SPݢDS`ײ\Ѳ\  P  ^ЬQЬPѡPЬQЬPPPPP| P^ÉVVUf*GTXݥ<ﰍPSSR
foG<~\TXݥ<ÍPS]PTPRS-PPB\dPP`
~<~ψRRS<~\TXݥ<fPS  F  ^~<~    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^t~jD PS{ E~X   HЬRRPS( RlRRR
  ^=U\T     {  E ^ RRRxRR> ^ SS< RR*SR{SRSR ^< RRRR{R  ^qT\լT߭߭"߭߭  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^SRTCTR~B Pd~c~E~
   F~ d ߢ0CPUUPߣP&a
   FЬPd4Т0X  ^S\0 C  ^SQЬPР4羅X 0   ^\  P  ^}\llPP  ^eP` P  ^Q\ P  ^=PЬP  ^)PРP  ^\ P  ^PЬP  ^PРP  ^َ\ P  ^ŎPЬP  ^ﱎPРP  ^\, P  ^PЬ,P 4^R	pP8PPߢ*ę Pԭ P  ^9\0 P  ^%PЬ0P 4^SoP8PPߣ[` P̭QԭPPQ   P  ^ɍ\ P  ^﵍PЬP  ^PРP  ^PѠЬP  ^qPЬP  ^]PРP  ^I\ P  ^5PЬP  ^!PРP  ^
\4 P  ^PР4P  ^\8 P  ^ьPР8P  ^ｌ\< P  ^社PР<P  ^\@ P  ^PР@P  ^m\H P  ^YPЬHP  ^EPРHP  ^1\֬ '\Ѭ$ Ь $PP  ^	\լ ׬ P  ^PР P  ^݋PЬ$P  ^ɋPР$P  ^﵋\L P  ^PЬLP  ^PРLP  ^y\P P  ^ePЬPP  ^QPРPP  ^=\T P  ^)PРTP  ^\X P  ^PЬXP  ^PРXP  ^ي\\ P  ^ŊPР\P  ^ﱊ\֬`流\Ѭd`֬dP  ^\լ`׬`P  ^uPР`P  ^aPЬdP  ^MPРdP  ^9\( P  ^%PЬ(P  ^PР(P  ^\ P  ^PЬP  ^ՉPРP  ^\h P  ^שּ\֬l\ѬplЬlpPP  ^\լl׬lP  ^mPЬhP  ^YPРhP  ^EPРlP  ^1PЬpP  ^PРpP  ^	\t P  ^\֬x\Ѭ|xЬx|PP  ^͈\լx׬xP  ^﵈PЬtP  ^PРtP  ^PЬ|P  ^yPР|P  ^ePРxP  ^Q\̀ P  ^=\̄ 2\̈ ̄ ̄ ̈ PP  ^\̄ ̄ PP  ^P    P  ^݇P    P  ^ŇP    P  ^קּP    P  ^P    P  ^}\̌ P  ^i\̐ ^\̔ ̐ ̐ ̔ PP  ^=\̐ ̐ PP  ^!P    P  ^	P    P  ^P    P  ^نP    P  ^P    P  ^渚\D P  ^PРDP  ^\̘ P  ^mP    P  ^UP    P  ^=\̜ PP  ^%P    P  ^
\̤ P  ^P    P  ^\̨ P  ^ͅP    P  ^﵅\̬ P  ^P    P  ^P    P  ^q\̰ P  ^]P    P  ^EP    P  ^-\̠ P  ^\̠ P  ^P    P  ^\̴ P  ^لP    P  ^\̸ P  ^פּP    P  ^P    P  ^}\̼ P  ^iP    P  ^QP    P  ^9\ P  ^%P    P  ^
P    P  ^\ P  ^P    P  ^ɃP    P  ^ﱃ\ P  ^P    P  ^P    P  ^m\ P  ^YP    P  ^AP    P  ^)\ P  ^P    P  ^P    P  ^\ P  ^тP P    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP0^W0yZ- [FYլj ЬTT+TQ  PSTg Sͺ jѬެTkTͺ> ?TVGP?<V~_%  PXXP'"<V~8   <  ~XVV1Ͳ!PͲߧ1 ͺ T ?TV1 ?<V~$  PXXP1 QQ1 Q`                                                                                                                                                                                                                                                   @                        rZa $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           Q\<VS߭<S~*  PUUP0߭߭x\RխPѭB`URRUUPQPQQP"<V~6   <  ~KVV1L 1 ޵j ?QPXʹRPXPaʹ׋ dѬߧ7  Pͺ ߧ< TͺF ͺ7
  Pߧ?M j1 UA Pߧ`- ͺ> ߧd4 T kk֊ л R
~ 1}ߧfΊ ߭ͺ  Pݭ @ PǱ  Ta ͶPͫͭͮͯͶͶͰͯ~<ͫ~ PXXP : 1Pp|~ͫq PXXP-p|~ͫ PXXP  1P߭nͫJ PXXPǉ nͫ 1T߭Oѭ1ͶS͸nSݮ .ݮ
 PRFݮ RKRy ͸Ͷ  ͫ 5|~ͫ PXXPO *P߭|~3nͫ$ 3ͫ ԭnͫ ͶͶ  ͫ' p|~ͫ. PXXPz 8 Pݭ?ܟnͫ nͫe | ^UASTs1 sݮW PЮRߣ0-  PR 1 PR< ~r bP R 1 P1 0Knn PnRߣ0 J PRN 2R< ~چ bP# R ЬVţ PRť TIPߣLR\ ц PVR ޣLTbPR TTPPP ^QTF?Rģb PSĥj PߢL߭S؅ ߭N PS' ޢLPcPS PP ^T>SЬRR. Pߣ0  PRŅ R< ~R bP R~  ^ETݬЬSS .S PRFS{ PRKRe  ^߭<~Q#  PSSP0߭߭8URխPѭB`SRRSSPRPRRP2PPP  ^+ PQЬaЬQ<  ~  ^ЬPݠ    ^E=\   ^5R : POa ScݬScլ
ݬݬhc6 Ѭ81ЬPP8!)		) I Y     i9 y y9IYiyP?PP1lP$441[Pr?P 1PP­ 1@Py 10P
i 1 PBY 1PI 1 P»9 1P) 1P< 1Pv	 1P¼ 1P 1PDق 1Piɂ 1P 1pP 1`P 1PP' 1@PGy 10Pki 1 P¤Y 1PI 1 P9 1 PO) 1 P 1 Pµ	 1 P 1 P? 1 Prف 1 P©Ɂ 1 P qP	 aPE	 QPb	 AP­	y 1P	i !P
Y Pݬ]
F 
;     ^ < ^ݬG PRR   R; *~ݬ RPP QPQQP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^E;P0 ^ЬQQRPxPPPSP PPSSP ^ЬSSR33bЬQ<P P<Pʏ PPPP<Pď   PUR@bQЬz ݬSЏQ  ~'  PTTP ^ ݬݬ<Q~  PRRP| ^e:TV{& PRUjV߭OPUUPUЭb0<~H
  PUUP6R<SS
0  PUUPo  S/  PVR
V	RE& UP $^<~e0  PRRPݬ~ RRP ^< ~O  PRRP ^< ~  PRRP ^<~  PRRP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^< P  ^P  ^ԼЏ   P  ^P  MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ݬݬݬϥ PRRP#P)Z ' Z} | ^]qTr8S<QnnVH %U
URBd\ln+B\la{ Bd\lBRbݣH%RP	UH %   R^<VpT7RDDd~ d| ߢH$Q
QP@dP<`PPQ  Y1P	QUP
UP@dP<`P	U
UP@Sߦz Pccߦ"gY1Pߦb}z PXX%ߦv[g
UP@P`Iz Y1cP<Q~X0PYYP,Pƶ g
UP@P`
z Xz 1!  |~9 P[x[PɬPޭ<nԟ
UP@Scy P%fcy Xy Y1PX
UP@Scy P%P/\fcSy XJy Y1dY
UP@S^5y PccrfY1,
USCdPQ`䭬|ԭCScx P$YƲecx Xx 1 
UP@QЭaqrcl@ScEPYYP!necex X\x zP<QSW
WP@dP<`PPSWW
W
Z9P|<n
WP@P`(x PZPZZPPPdYYP^YmU4WݧH!DDd~ esy Q
QP@eP`X1s	QTP
TP@eP<`P	TT
X1N
Џ  SS<PPQ  |
TP@RSI7w PbbX1Ğ|ԭ
TP@P`v P	X1 P
TP@PЭ`1 
TP@RS]v PbbX1 
TSCP` Wx V<Q QP<PPxPR Q<QPxPPPRRfԭԭ CP`5v PXq'c
TP@eP`XݧH XP< ^kT2SH 2 U
URBdP`(BP`u BdP`BRbݣHe P	UݣHT Џ   P< μ^﫾TLkSU
URBcP`1 <PPQ  < u |~Pu u BP`v PwPđ/bPu tu  u Pܭ؞|ԭ̞BP`t PPĿaPP	U8Џ   P| ^ĽSejUVլ
լլV1  RTb
R	TT
V1l<PPQ  wԭмЬ(n蟭ݢu PVP#a1$ t ̭߭ݢt PVP'`1 PЭм1 ЬЬмԭ߭
TP@P`s P1 s 
V1 PR`us s 	gs 	^VÀh`
TP@P`^s P@   
ÔFs + 
TP@P`Ds Pô!s PVѭÿ`VЭļVP ^SThRPb
R	PP
T1 <PPQ  ?ԭЬЬlܟݢcs P1 P_T1 <PPR  
P@  P
PPԭЏ  ЬЬЬ議ݢ4r P/P8_\ r r g^TTP ^RЬQЬPѡѡa`RRPPP< Ψ^úUͨŀq PRRP< <iR{q PRIq PR;q PPRޭPPSPQRPR`cRPR`QTQSRQRPad`cЭЬRRr    r P ^SÔp PRRTAPޞޭ<nRp PTTRep TP ^pSèOp PRRTPPޞޭ<nR*p PTݬq TRo TPP 4^Süo PRRT>Pެ<	nRo PTTRqo TP ^%eSRP
RP@cP<`PPRR
R
T8P|<n
RP@P`4o PTPTTPP 4^
Sn PRRT>Pެ<nRn PTTRn TP 4^S|n PRRP><nR^n PTTR%n TP 4^1Sn PRRT>Pެ<nRm PTTRm TP< 4^Tm PSSUrPЬRRQ<Pʏ PPPP<P PaR<<nSLm PUPUSm UP Τ^Vլ1 ͤ l PRRP< <iRl PRl PRl UŏB   UP@PՠUPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭݬ߭m P PUU WWWPP  ^><iݬk PPP^ݴU"4RQR)m PPЬRR  RP(VeSݮl Rbݮ<~ŖݮbݮݮbYe[Y1 l WЮV[ZYЮXZݮ-VgSZTSXKTPPRb~PRb~PRb~`~AVgSRz  RP{(PQPP	SVgSTSX  [YY1| )l YP^ﭳVݬݬ-ެWgl SЬTެXShTk UPTPPRb~PRb~PRb~`~AgeSRz  RP{(PQPP	SgeSTShP  MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^QXBAY&WЬ<<RRď   RR5 PiRh~E~# T ߨ ݏ  ) PDiScR,cTVެUVecVb|^| Ԣ(Ԣ.ԢZ  |   Ԣj|rT~° ´ |¸   TԢz  Ԣf   R                                                                                                                                                                                                                                                   A                        fe $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                                "           VVes@PZZRߨ)R&` ЬRi ?@Hߧ@1iS@~& P iRբ )<RRŏ   R~ߨB~E~  1iS@R,   R       ^?1?-^?Z2%W[ԮnPެS<c~#  p?<cRď   RjSBcVԦb|6|>ԦԦF|JԦR,Ԧ2ԦVƠ ư ƴ |Ƹ զ~!<~ P~	[1 P<~  զ ,@~ P [1 Pn@R,   R ƌ ƌ  ƌ 88YX8'>T<XSď   SjRCRbdYXX8S>d<Y~;Y
Z~5[R/Ѯզ~
ݦ~c Ԧ~nզ 
ݦ L Ԧ 
=[PP ^<Qď   Q=PAP` P ^<PPP<Qď   Q|=PAP RP ^<PPP<Qď   QD=PAQ RP ^<PPP<Qď   Q=PASP ^<PPXP<>R<Qď   Q<PAP`b<PASS<SP ^<PPP<4>R<Qď   Q[<PAP`bH<PASSG<XSP ^<PPP<>R<Qď   Q;PAP`b;PAP`SPS;SP ^<PPP;X>R<Qď   Q;PAP`bl;PAP`SPSg;xSP ^>R<Qď   Q.;PAP`b;PASSSP< ^S:U<PPRP:
>R<Qď   QePAP`bTrPߣ[ݬd P<Qď   QePA.P`Fݬd PP PRT&PݬRd <Qď   QePA.PR`TN:_
TPP ^!:S<PP}P:>R<Qď   QcPAP`bcPA.P`T"<Qď   QcPA.P`ݬc T9TPP ^9S<PPP95>R<Qď   QcPAP`bcPA.P`T<Qď   QcPA.P`79HTP ^<PPpP9>R<Qď   Q8PAP`b8PA,P`SS8SP ^<PP P8H>R<Qď   Qo8PAP`b[8PA,P`SSW8hSP ^<PPP/8
>R<Qď   Q7PAP`b7PA2PЬ`SS7
SP ^7S<P<Qď   QcPA2P`P<PPP>R<Qď   QcPAP`bcPA2P`TPTTP ^<PPPG7	>R<Qď   Q7PAP`b7PARPЬ`SS6
SP ^<PP8P6	>R<Qď   Q6PAP`b6PARP`SPS6	SP ^<PPPg6	>R<Qď   Q76PAP`b$6PAFP`SS#64	SP ^<PP\P5>R<Qď   Q5PAP`b5PAFP`SPS5SP ^<PPP54>R<Qď   Q[5PAP`bH5PANP`SPSC5TP ^<PP|P5>R<Qď   Q4PAP`b4PANP`SS4P ^<PPP4X>R<Qď   Q4PAP`bl4PAJP`SPSg4xP ^<PPP?4>R<Qď   Q4PAP`b3PAJP`SS3P ^3ݬ<Qď   Q3PA ] R3RP ^<PPP34>R<Qď   Q[3PAP`bE3PAݬ] SPS;3LSP ^<PPtP3>R<Qď   Q2PAP`b2PA
P`SS2SP< ^2U<PPPx~ PSPx~ݬS\ s2>R<Qď   QePAP`bePAVPЬ`TePAZPS`TTSx 2/TPP< ^1U<PPMP<Qď   QePAZP`	`& x~ PSPx~ݬS[ 1L>R<Qď   QePAP`bePAVPЬ`TePAZPS`TTS N1_TPP ^!1T<PP}P1>R<Qď   QdPAP`bdPAVP`SdPAZP`SS0SP ^<PPP<Qď   Q0PA P`SP ^<PPP<Qď   QP0PA PЬ`RP ^<PPP70>R<Qď   Q0PAP`b/PAP`SPS/ SP ^<PP(P/p>R<Qď   Q/PAP`b/PAPЬ`SPS/SP ^<PPPW/ >R<Qď   Q'/PAP`b/PAP`SS/$SP ^<PPLP.>R<Qď   Q.PAP`b.PAP`SPS.SP ^<PP
P<Qď   Q\.PAPЬ RP ^A.T<PP
P>R<Qď   QdPAP`bdPA:P`SdPAFP`SSSP ^<PPD
P- >R<Qď   Q-PAP`b-PA:P`SS- SP ^<Rď   Rf-PBBQaV-PBNQ P ^<PPP?->R<Qď   Q-PAP`b,PABP`SS, SP ^<Rď   R,PB>Qa,PBJQ P ^<PPP,D>R<Qď   Qk,PAP`bW,PA>P`SSS,dSP ^<PPP>R<Qď   Q,PAP`b+PA6P`SSSP ^<PP8P+>R<Qď   Q+PAP`b+PA6P`SPS+SP ^<PP
Pg+>R<Qď   Q7+PAP`b#+PA6P`PS+0SP| ^*V<PPQ
P*>S<Qď   QfPARbcU1 ЬRRT P:9RT PP PTUiPݬTT U<Pď   PfR@$Sc@(RbT UTbPTcUR<Rď   RfP@B -*0UP| ^)U<PPQ	P)>R<Qď   QePAP`bV1 V<Sď   SePC$Td;C(P`T`ݬS ePC(Rb ePC(Rb*PdݬS ePC$Rb ePC$Rb<Rď   RePB$QaB(QaBQaP@PaP <  ~Ps(VPP ^<PP4P(|<Qď   Q(PA PЬ  (RP ^}(S<PPP>R<Qď   QcPAP`bcPA P`T
PcP TTP ^<PPP(<Qď   Q'PA PЬ  'RP ^<PP,P<Qď   Q'PA P`SP ^<PPP'<>R<Qď   Qc'PAP`bO'PA PЬ`SSK'\SP ^<PPP#'>R<Qď   Q&PAP`b&PA P`SS&SP  ^ЬP`Q`QQQQQQQ| ^u&U<PPPp&>S<Qď   QePARbcV1 <Rď   RePB P``w ePB Rbլq PSV]ݬS&P SP`T`TTTTTTT<Qď   QePA RSbV%VPP ^<PPPo%>R<Qď   Q?%PAP`b,%PA P`SS'%8SP ^$S<PPYP$<Qď   QcPA P`P	P# <Rď   RcPB QЬPPaTPcPB N  cPB N $P ^i$S<PPPc<Qď   Q($PA P`RTRc;PRݬHN cP $^U#W#TV<PP1P<n>S<nPP
   R%<nQď   QdPAP `dPAP`cRRVVP1ެRb߭+ ߭:g<bRď   RdPBP`dPB߭dPBjM dPB
PЭ`dPB,P`dPB2PЬ`ߥ\ݬ-M P
dPB.P`OݬM PP PRVg>ݬRL <Qď   QdPA.PR`g/	<~_VPP ^<PPPެT<dRď   RA"PB`SJ">Q%"PBRba<dRR,   ԣ6 "%RT  Rw P ^W<Rď   R!SBcVզ.
ݦ. Ԧ.զ$
ݦ$	 Ԧ$զ(
ݦ( Ԧ(զZ
ݦZ ԦZƐ Ɛ  Ɛ զfݦf<~6 ԦfƔ Ɣ ΋զ ݦ <~ @R,   R | ^!US<8RR   8VPV TTV^>R<TQď   QePAP`b9ePA,Rb+A.RbݬPЬQaPaPP޼RT@bTTV PP< ^] US` 	T80>R<TQď   QePAP`bЬP`TT8 +P< ^UST8B>R<TQď   QePAP`bޭRePA2P`bѭЬP`TT8PP^qY<RRPl<Sď   SiRC^Rb1 ߭sDPWWRW1<Sď   SiRC^RЭb PV	W1mPf<Sď   SiRCRbP($VݭEPWWR1V 1ݭF PV
                                                                                                                                                                                                                                                   B                        Ez $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           W1 Pf($<Sď   SiRCRbXPXXRR   	WgP߭ݭFPWWRWJPЭRX*VݭDPWWRWV5 JPWXݭFPWWRWRVݭCPWWRWXX WP ^<PPPg<Qď   Q;PA^P`SR1 S7E߭SEPRRPReЭP)PX ԭSEPRRP< Y3PS'EPRRPR߭S@EPRRPRRPP ^<PPP,<Qď   QWPA^P`SR1 SSD߭SDPRRPRsЭQaP4PPP&Qa ԭSDPRRP7 bS3DPRRPRP߭SLDPRRPRRP ^<PPP<<Qď   QgPA^P`RS1 RcC߭RCPSSPScݭ ԭRCPSSP ߭RCPSSPǔSSP"RD<Qď   QPA^P`SP ^<RRP\<Sď   SRC^RbWVnPWB߭WBPVVRVIЭR
(V3PWBPVVRV߭WBPVVRV'VPP ^<PPLP<Qď   QPA^P`SRjPSA߭S+BPRRPREЭP	R0SAPRRPR߭SAPRRPRRcRPP ^<PPP'<Qď   QPA^P`SRjPS@߭SgAPRRPREЭP	R0SAPRRPR߭S APRRPRRPP ^<PPPc<Qď   Q7PA^P`SRjPS3@߭S@PRRPREЭP	R0SC@PRRPR߭S\@PRRPRRPP ^<PP PH<Qď   QsPA^P`SRjPSo?߭S?PRRPREЭP	<R0S?PRRPR߭S?PRRPRRPP  ^P ^<RR4P|<Sď   SRC^RbWV~PW>߭W?PVVRVYЭR<ЭRЭR(V1W>PVVRV߭W>PVVRV&7VPP ^WUV81 f>T>R<VQď   QgPAP`b1 <VQď   QgPA^P`RqR=߭RdPSSPXЭP,y? Pݭ R
>PSR=PSSP߭RdPSSPVV81L*;P ^S<Rď   RcPBbP`cPBbQaBbP`cPBbP  P ^ެQ<aPPRP<aQď   QPAjPЬ`RRP ^RެQ<aPPR<aPď   P\Q@aPРjР~RP ^<PPԼ<Qď   Q!PAzPР    ^<Qď   QPA PA   ^V3[wZЬR<Rď   RSBcXȆ R	R,bPȇ ЬjЬnȆ Ȝ Z< ȇ 1PЬSRѨRըjSjЬnȆ 1ȸ kS)61PШjRЬS	ȸ k1aRѨR1Tȼ Y2ȼ D1?<~Ȇ ~ߦ]s(ըrYƉ < ШrY WYTSW1< UPd~Ɔez  SP{PQPPƋeTSSWƍ< ըjWƤ < ШjY WYTSW/< Ud~Ɔez  SP{PQPPƋeTSSWƍU<  J< ЬX WXUSW02< Te~Ɔdz  SP{PQPPƋdUSSWƍ;  ; ЬR<~o  ݬ4PP ^T<RR
P<Qď   QdPARbdRA <   Rď   R a: dPB <Sď   SdRC dRC JCjRbdPCnRbdRCrPCjRb`dRCnPCvR`bdPCjRb 9 _P : dPCjRbdPCnRbdRCrPCjRb`dRCnPCvR`bdPCj R   9 dPC P ^TC<Rď   RdPBQa=adPB P`P	P <Qď   QdPA Rb<~9J ^<PPtP<Qď   QPAP `PAP  P  ^<PP,Pt<Qď   QPAfPЬ P ^<PPP{$<Qď   QOPAfP` RcP ^<Qď   QPA P`    ^TRS8+P<SQŏ   Q\dPL`\ 	QSS8P  ^^<Qď   QPAP   P ^iT<R RSSP"ˏ RPPPPP
R #PެPS`RP`P<PP P<PP| ^	USVTT8_>R<TQď   QePAP`b*ePA P`P/ݬSPTVP<TP   PPTT8VP ^
S
;?R<RQď   QcPAQaPPaRRT
ePP  ^<Qď   Q
PA PЬ    ^<PPh<Qď   QPA ^<PP<<Qď   QPARbQPPPQQQPb^W>UXgP RV8KP>S<VTŏ   TQgPAP`cѢ2ݬTNPPX   RVV8 Џ    ~VXP| ^TS:6 <o!ެVfUUCR<8PRPca5 Rc<!<R~Z   R R<8PRP+y5 U{!<f~"   U đ5    ^YT<Rď   R?SBcUŤ ޮVF=5 S   Rb~Q&5 RSV5 S W Rb~X4 R	S]4 
S X
 Rb~_4 RSd4 2,ng4 2nPP 3 3 # )?Pr4 !Pxy4 P2n~|f4 Ă\4 Rbե.ݥ.ĵb
PbŰ R-4 RPP  " 2 :Pj?P	4 0P3  P3 PR3 3 Ŵ R3 RR )3  P23 PR>3 By3 Scņ ~ݥ~ݥ~2~cż Ÿ :c<Rh(^(^cP^T<Rď   RSBcU<~Ĕ_Ť ޮVF2 SRb~Q2 RSV2 S W Rb~X2 R	S]2 
S X
 Rb~_z2 RSdi2 2,ngZ2 2nPP 3 3 # )?Pr52 !Px%2 P2n~|2 Ă2 Rbե.ݥ.Ľb
Pb1  ^R1 ЬPP  ! 1 9?P1 1P1 !P1 Pݬn1   a1  ^ERI1 ѬѬ#P)-1 !P21 Pݬ>
1 B  0 < ^~TF0 U޼ScRb~Q0 RUV0 U R Sc~X0 S	U]0 
U R
 Sc~_v0 SUde0  ^I~RgM0 2PP 5 5 % +P?Pr%0 "Px0 P2~|0 /  ^}TЬWVެUVe0/ Sg~Ćcz  VP{PQPPċcWVVeč/ | ^}TrVUďRħRX/ PSPլЬUĩSB/ Rbp$ĻSbe$SbSbRUŏ   RPfQ@aS   RRUS. RP^|UެWg*/ gެVfS~~2~<c~S:g. Ŕg. TЦ R Sc~šg|. STެXhSݣݣݣ
ŧެWgTTS. Vfݣ <~ݣ~Tfݣ2ݣ.2,~ݣ(ݣ$ITfݣJݣFݣBݣ>ݣ:ݣ6řTfݣ^ݣZݣVݣRݣNTfݣrݣnݣjݣfݣbcTfݣzݣvTfÌ È Ç ~Æ ~Â ݣ~Tfà Ü Ø Ô Ð [TfźTfTШ R   Sc~g`- STެVfI- T R¨ Sc~f,- S	TެVf- 
T R® Sc~f, STЬR¸ ´ ° ݬ, ¼ ݬ,   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^aTլ$PѬP딭""PݬP?` PR<PP"$Pݬ~ݬ} PRRP ^լPѬP<딭""PݬP?"  PR<PP".PݬZ~ݬ>7 PRRPPRPP ^S<QЬP3`3RPݬQ(k  PRRPP   1 Mj?PEPЬP7~R~E  P-S(RQQЬP7~QE  P

SPSSP| ^ެScRRݬRR  PU-PRTPcTTRݬݬR
#  PUUPѼPU<R
ЬP3`3VݬR<j  PVVPP   1 M~?PEPЬP7~V~E  P-U(VRRЬP7~RD  P

UPUUP^Yݬ* PPݬݬݬݼS  PPެRbSPbSSZЬPѠ8Rx8RRUU1    WUSgTЬViZS
PS	   R_딭""SPTP?C~ PX<PP"'   R!PTS~Vz PXXRR[[PUZ gPݬPPgPѠQxQQPP
PUPPUU1P ^%P4PA   ڝ   ~~~ݬݬ<~n  PR ﹝  S  RP ^
P4P,ݜ   v  |~~ݬݬ<~r  PRRP }ݬ' P ݬ  8    RPP|^7XV2
P4PN      RPRR~ݬ<~WPUUP1ݬ^' Pݬ>  PU1# h~ PUUP1bVV~ݬPUUP1:X~~A  P1~~A  P1RR~QA                                                                                                                                                                                                                                                     C                        ` $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              )S "     '      P1 R~]A  P1  1 ѭRPxRRSnVTS
PS   RuP@""SPnP?Q/ PW<PP"3   R-PnS~Thgy PWWP   RPWRRU~ݭݬY  PUPUVVh}    V  UPP ^|-  P4T\|~ݬ<~>PTTP> S R cbݬPTTPcP`b~~?  PÙ  TPP ^XfR4P  ݬ<~hd  P1ެScUU.UTcTTR .R  PP.U3L  PR1foЬRWo1L<  [h  Z=$ Y. no|ЮR֮Rݬݮ 	s  PPRR   1 1 PUkP |kRRStRRPRTSRSb`SRSPbPSPRcbdtj  PU UkU E|xu< V|~ݬݬxPPQpPPSPRQPQ`cQPQS`SQSPa`bpVjPxWiWXX UU 
E|xo1ﳗ  X  P ^Sݬ" Pݬ :  PPݬݬ~ݬݬ|PRRPݼ<~0b  PSPP   1 Ev?P=PЬP~S~<  P%R ЬP~S~<  P	RRRP< ^Uݬ" Pݬd9  PPެScRRݬRI  PT(P ݬRRcRR  PTTRѼPݬݬ~ݬݬkPTTPݼ<~a  PUPP   0 Df?P=PЬP~U~;  P%T ЬP~U~;  P	TTTP ^	ﺕ  P4*  ~ݬݬݬݬݬݬ<~	p  PRPR  RP< ^vUV  P41 ެScRRR@H  PT(P RRcRR  PTTPQ ~~~ݬݬݬݬ<~	`q  PTTP#ߥݬ  Pݬݬ Tﰔ  TP ^    RPP^gW|[ԮԭYM  P4	X1PߧTj ԮUެScRRyRG  PX& yRRcRRn  PXXP1#y Y[\	ݬ<~	n  PXXPP   UX PPU\I lXPP   1X1P͹V|~Y[\Pݠ$<RR	6n  PXXP'y YZV ݬR	
n  PXXZ1PZ\R RP<PPxPS2RPʏ P<PPxPPPS^R RP<PPxPS2RPʏ P<PPxPPPS`R RP<PPxPS2RPʏ P<PPxPPPSߧT  P[DR RP<PPxPS2RPʏ P<PPxPPPSSYF߭ ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭP[PYPY	;X1PU4լݬݬ<~bY  PX1kݬ PX1Wլs߭<~%խXP9IݭPXXP19ݬw P1 Xݬݬ<~X  P1 1 PެUePPRޭPPTPSRPR`dRPR`RQRPa`cЭe9ݬ; PݬެUePXePPRޭPPTPSRPR`dRPR`RQRPa`cЭeXP1II9 PXݬ PXP1 Z1 ծ1 Y2YPPSY[ޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭ߭FV J[ޭPPRޭPPTPSRPR`dRPR`RQRPa`cЭܭ߭F  YP<PPxPR2YPʏ P<PPxPPPRRDJ<~*  DZ#y|~Z~Vݬ<~	k  Q  Ԯլ
 <~r9<~Ï  9
ݬ ) D~C~B~A~@~?~>~=~<~;~:~9~k~܋Ѯ
פֿ  XP|^[PR4PR߫T ެUeTT͂TaA  P)P ͂TTeTT  PSSPլ?߭<~PխSPݬݬ<~U  PRPݬ PRݬ<TT'0  PSRSݬݬݬTPPTTP{  AT4r  P   ͂ e\ݬ<~	:h  PPT-R)S$T   	T    eT T1͂ ݬ<~	g  PTp~u PTp~ u լ1 R1   ެWgRRUޭRRQRPURUbaURUQbQUQReb`Эg ެWgOPgRRUޭRRVRPURUbfURUQbQUQReb`ЭgR1Pe' ЬUeRRRRRe1 PެWgRRUޭRRVRPURUbfURUQbQUQReb`Эgݬ PݬެWgoPgRRUޭRRVRPURUbfURUQbQUQReb`ЭgR1RVU P)1U   R͂ Qݬ<~	e  P1yZ
"1gPլURUR&(1KPRݬ RP	(1.P >S
"1P
S SR<RRxRU2SRʏ R<RRxRRRUW1 <~-  PRRUXSW?PTXUSVRRWSRWB$"PSRB$WSSSXSRWB$XSW߭~  PYq  PYY-U UR<RRxRV2URʏ R<RRxRRRVYVTXSW͂|~~ݬ<~	e  ~ v a լݬF P͂~ ~ݬ<SS	Je  PPRR   Y͂ D~ ݬS|Y  PPR_͂~ ~ݬ<~	d  PPR-T)͂~ ~e2ݬ<~	d   ͈  g(  լ
 <~RR   P ,^.~ |0 ެTdSS2S:  PWWRiRPSSPdSST!-9j PWWRRP--2T
  PWWRR   1 WRѬ2WWR1ެTdSS2S+:  PWWR>RPSSdSSR-2Rw
  PWWRR   12~ݬݬݬ<~qV  PWWR	W1PR   1qV2~rs|Vݬݬ<~	~a  PWWR	R   rRRW1'PWR1  | Y  PUUAެPPQxPPSPRQPQ`cQPQS`SQSPa`bxE|1 PVs,2~rs|Vݬݬ<~	`  PWWWP1eWRR   vs | ҅  ެRRStRRURTSRSbeSRSUbUSURcbdt|2 ~s~|Vݬݬ<~	a  PW.-lh WP| 4^ެTdSS6S8  PV% 6SSdSSZ  PVVR1"U6~vw|Uݬݬ<~	_  PVVRvRRV1 PVR1  |ެPPQxPPSPRQPQ`cQPQS`SQSPa`bxP  PQQHQ~A|QP@|{  ԭ6 ~w~|Uݬݬ<~	j`  PV@w.6~vw|UUݬݬ<~	^  PVVVP1)VRR   VVPP ^ݬ &  PT1 PެScRRRe6  PT% RRcRR  PTTP
ѭTTPb ~ݬ%PTTPDT:PPPP0)ݬ<RRM  PݬRM  PTTP ^  dP4. +  ~ݬݬݬ<~cd  PR   PRd  RP| ^Vf;  P4f6  P ﺂ  ݬݬݬ<~~PUUP1  ݬݬݬ<~PUUP1 PѬ$ݬ
 Pݬ PݬݬЬTTЬSS^   PPPASTK   PPP. TS<RRB ShTR- ށ  ݦ <  UP^_b[TެXh1 ߭~߫h6  P1 PЭScRxW߭Wݽh;  PYYSW ЭSެSSPޭSSUSQPSPcePSPUcUPUS`caݭ  PTWP߭R߫h/6  P1dTP ެScUcUU  PY1ѭc1ѭUPxUUSS1  Z  XSVW^V
RV	   Uf""VRݮR?_ P<RR"'   U"ݮCV~W)>\ PUUY1 1 ѭU	PxUURR1 P RjPYYP1  ެPPUޭPPVPQUPU`fUPU`QWQVUQUPag`fݭhP
TRPUxUURR1nѭU	PxUUSS1{TP< P 4^_VެRRSޭRRURTSRSbeSRSUbUSURcbdݭߦ߭F	 ٔ۔ݐޭ䟭ޚ~<~( PWWR ̟x PW<~ݬ^(  |~ﱈ   4^^VbRѬ ެRRSޭRRURTSRSbeSRSUbUSURcbdݭߦ߭ ٔ۔ݐޭ䟭ޚ~<~' PWWR ̟[w PWݬ^(n|~)   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ݬ PSPQPRQPЬP֬`PPSRPRPz  SP{   PQPP ^aYլ$PѬP딭xP@ݬP?_\ PR<PP@   $Pݬ~ݬX PRRPP ^լPѬPA딭@xPݬP?e PR<PP@   .Pݬ9~ݬ*Z PRRPPRP ^\Td` ScЬRbbߤc2PPPߤ*cߤ?c6~ߤMc7~ߤ[cݢ8ߤicݢ<ߤwcą c\ } P ^]լPѬP딭ŏ   PݬP?
Z PR<PP   $PݬM~ݬ12W PRP ^լPѬP!>ԭ뛏ŏ   PݬP?^d PR<PP   .Pݬ~ݬX PRRPPP ^QЬP7RRPQP{RPQPQ~ 7`V PSSP޼TSQЬP                                                                                                                                                                                                                                                   D                        "N $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              _ "     8      RRRPRQPQP{RPPQxQQQSc  P| ^UTd$\ QЬPeRRPQP{RPQPQ~dU PVVRd\ RPSQЬPeRRRPRQPQP{RPPQxQQQSЬcQЬPeR
RP
Q{RPQPQ~d'W PV [ P| ^UTdD[ QЬPeRRPQP{RPQPQ~dT PVVSd;[ SPSQЬPeRRRPRQPQP{RPPQxQQQScЬcQЬPeR
RP
Q{RPQPQ~d?V PV Z P  ^ﱾP T ^Zݬ P/PЬVV  P2RR[1%P1 VTTH PUPRPSRPPPUSRSRz  UP{   PQPPUޭnQUPFRRPQP{RPQPQ~ GpS PWWR RT=PSQUPRRRPRQPQ{RPPQxQQQSc TTYYRJRPVTTz PUPRPSRPPUSRSRz  UP{   PQPPR>SBc[ѭ1 W XЭTgUЬVaT
sPT   ShPxTR@UR?U P<PP@   &   S!UT~VR PSSYYPgPm  P[1 P2PѭPzgRh[ ݬPYݬhPYPYYP3T+gR"hPb PPP[֭$gPР<RRPRPRѭ1< P^[ЬRޮTݮs PSPQPRQЮPd`PPSRPRPz  SP{   PQPPW޼RbSxbSSZ1 WUޭpQUP=R
RP
Q{RPQPQ~ klP PVVRRTAPpSQUPRRRPRQPQP{RPPQxQQQScTTYYRRPpRGbЭSSSZ1ЬRS<ZTRUЬVT
RT
   S}Hacd@xTRUR?%a
] P<RR@   1   S,UHT~Vk?Q PPR
   SSSYYR1<K1 WUZV\kNU \QUPRRPQP{RPQPQ~\kN PPR\k@U RT1 PSQUPdRRRPRQPQP{RPPQxQQQSVcQUP*RRPQP{RPQPQ~\k:P P\kT TTYYR1;RPRZGb1)PެV  ЭPPWPTfUbT
PT	   Sd
xTR@ݮR?T
Q PX<PP@   "   SݮwT~UkM PXXSSYЭYPѭ	ѭZ1HYR1_ЬRЭ<ZTRUЬVT
'RT   S~P>H @xTRUR?vZ Pn<RR@   2   S,UT~VkN PnPR   SPnSSYZWTЬUT
|RT
   S1 PL@xTRݮR?Y P<RR@   4   S/PݮT~UkM PPR	   SSSYYP^ZYЬRޮTݮA PSPQPRQPЮPd`PPSRPRPz  SP{   PQPPV޼RbSxbSSXj1 VUޭtQUP
R
RP
Q{RPQPQ~ 8K PPRRT@PtSQUPRRRPRQPQP{RPPQxQQQScTTYYRRP<RFbѭX1!j1ЬRVUТ<owP o/QUP=R
RP
Q{RPQPQ~o=fJ PPRo#P RT1 P/SQUPRRRPRQPQP{RPPQxQQQSЮc/QUPR
RP
Q{RPQPQ~oK Po1P TTPSЬRТ<FcPެV ѭ1ѭX1{PЭTfUjdT
RPT   SjP "#xTR@ݮR? L P[<PP@   &   S ݮT~UH P[[SSYYP1 ѭX1 ЬPР<ЭSfTS
PS	   R{jH@xSPݮP?U PW<PP@   5   R/ݮ3S~T&J PWWP
   RWRRYЭѭ	ѭX1YPH^[hVԭkR4RP<~W  PPݬ4 P/ݬݬ  PP"SˏSRRʏSS0Pj  kR4Rj  P k   ~ݬݬ  PXXRX1JP ~ݬݬPXXRX1$,  @  1 ֦XX\xXRR\: ݭ  P*P֦XXxXRR\ ݭ  P,  0ݬ 🭸+  PX1~*L PXXR1`Z?s%F PXXR	X1/PsZkRjkRЪkSѣ1 УYYUWaUU   TpPdfgxUR@ݮR?,dH P<RR@   *   T%PݮKU~W1ZE PTTXXR1_kRЭ1 ѣ X1D,  @ 41 kRТTUTT
   S1 PLUWX@xTRݮR?TU9R P<RR@   8   S3PݮsT~UYfF PPR	   SSSXXR|kRТS֢SYxYRR,  0ݬ 🭳PX(%kRТjkRТsE XRk D~ݭ<SS7  PXS  P: 2ݭS7   S
  PݭSH   5g  f  խ&I XPP ^Rf   f   ~~ݬ<~1  PR f  k,f  RP ^WYvgR4RPݬ; P/Pݬ  PPgRѬ Pe   Gf  ЬSS1 S  PVVR	ѭSVVR1Nz~2~ݬ  PVVR z~2~ݬPVVR	V1
PRR   'RRR0ݬ<~/  P
V1ݬݬ#  PV1?uiG PVVR1u5uiA PVVRV1xuެRbSPbSSTnuUm_T	gRT
   Sd&()xTR@nR?&jD PX<RR@   "   SnT~Ui@ PXXSSVVR
ѭVVR1 z~2~ݬE  PVVR!uuz~2~ݬOPVVRViPRR   'RRR0ݬ<~[.  P
V4u:,  0ݬ} uV c  d%c  v
uiZF VPP ^P4PP2~ݬ  PPb  ݬ~2RRݬ*  PSSP ݬ~Rݬ=PSSP"ЬQ7PPRa<~_-  RPS量fb  SPP ^>b  P4~ݬ2~ݬ<~0  PRRSb  RP^=Xha  P4ha  PެScRRݬR  PV1 RQPcQQSЬTU^S
PPS	   Rc딭xSP@TP?A PW<PP@   &   R TS~U= PWWRRVVP.ЬP`!7PPRݬ<~+  RPV  `  VP ^`  P41 ެTdRRR  PSqPRQPdQQRRSIP RPSSP1ѭ*ЭPPSPRS
PPRPS_ `  SP ^ITd_  P4d_  PѬRP RPRRPP&P[ݬެRbݬݬ  PSSP=bެP`Q`QQP ݬPݬݬPSSPSd\_  SP ^Rb3_  ݬݬ  Pb)_  P ݼ~ݬݬPSb_  P    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^qP    ^<n<nPR,?<~ﾁPTTPRPRPRRP߭߭<~$PSPݭݭPݠ <~&  PSSPQPQQP ^<PP?<~+PRRPPPP ^߭߭<~PRPݭݭݬ]  PPPP ^ɹz]  ݬ<~`(  PR﫹l]  RP ^ݬ PQQRQPR,PЬQ֬aQQSSQQ*Q?PPQPQP ^﹤TЬRRG PQQ/QbRR.PQRQRyPЬScWWRяa   RRz    RPPcFPR :RnnVޤLޮUSPSPn@PR
PPSRRP֬QRQRPP  ^PլЬQ@aPPP  ^Pݬ	 ^߭ݬFPRԭP ^ԭP4P2~ݬPPQˏQPPʏQQ0P[   -\  ~2~ݬ
  PTTPEfo> PTTP1  2~ݬPTTPrݭ<~&  PTZPPPP0FЭSSSM
  PT+SRxSRRPTT Z[  Z  խK= TP  ^ݬ<~Id    ^< P ^PެP`RP`RRP PPSSPѭPPP  ^QPʏPQPPP  ^QPʏPPPQPPPPL^vnЬRR jk|ݮ;b<~	4  PVVRR   V1 *i!u<q< PVVRRPuVR1K  
    $ :Y  YY  Xh W ([ZԮ|Ѯ 1վ1P޾RRStRRURTSRSbeSRSUbUSURcbdt*ѾSxSSPVVR'ݬ*Ѿ SPx SSPVVR1U*1J*1  ݮ >:* PVVR1ԐtUtRtxU*8PVVP xP޼PPQpPPSPRQPQ`cQPQS`SQSPa`bpiPQQ*xPRQ~AbQP@bh |g1/                                                                                                                                                                                                                                                   E                        ʊ' $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              b "     I      PUtP1\1bSxbSS Ѯ 10 ݮ( PVVR11 &S
Px&SSUU1 PuzUkPVVP1  ͈޼PPRlPPTPSRPR`dRPR`RQRPa`cliPQQ2͈RQ~AbQP@bh |guzUj)P͂Rx͂RRUU1F"S	Px"SS Ѯ 1֮Ѯ վ1k5ЬRR jk|֮ݮ7b<~	0  PVPVVR1VRR   VvuW8 VPStatus 0x%02.2x from ShmDeleteNodeSLList in DeleteAllDynamicValues
 0x%02.2x from ShmDeleteNodeSLList in DeleteDynamicProperty
 0x%02.2x from ShmDeleteNodeSLList of DeleteAllDynamicProperties
 0x%02.2x from ShmDeleteNodeSLList %d of %s
 DeleteDynamicObjectFromCache P ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^<P~9 PR66' PRD   RPSPbSD   RD   PS  P ^5T<~օ PRߤ1 PRc&RPSPbS&R&PS  P ^5T<~ PRߤbs PR+   RPSPbS   R   PS  P^95YvXoZ<P~ PRi    Q3PRD   RP2 TPbTD   RD   PTbQQ\P<~ PRߩ1    T$R)&RP2 UPbU&R&PUbTT\P<~L PRߩb=    T0R   RP2 VPbV   R   PVbTT\PSChPWW\PSS   SCjPWW\PSS   PP ^ݬ PSPQPRQPЬP֬`PPSRPRPz  SP{   PQPP ^ЬTT PUPRPSRRRUSRSRz  UP{   PQPPRBiVPV߭V|PPЭS2RѬR!ݬ	 PЬR(@ bPVPWWR߭V,PЏ   P^Z[VѬݬ P{Ѭ!ѬݬݬݬPXXP[ЬTTm PUPRPSRPRRUSRSRz  UP{   PQPPRBQWPެUe`[ W߭WSP1F1>Y  RbbWW߭W$P1R   Y1P[TW߭WP1 V1 eVWPXXR1 ߭WP1 eSPeSQSPЏ   RRRPRQPQP{RPPQQYY   \aS&TIjW<W߭WcP'V2eVWdPXXR߭WcPYY   PЭV2RR
ѬL[!ݬ P7ЬR(@ bP ݬ&PXXRЬR(@ bPWePXXR߭WPXXR1t[PYY   PIjWW߭WFP19 ^ެRbSbSQSPЏ   RRRPRQPQP{RPPQAＰVPV_߭VP6PѬ(@ PVyPWWR߭VP͚P ^ެRbSbSQSPЏ   RRRPRQPQP{RPPQAVPV߭V#P;PѬЬR(@ bPVPWWR߭VPЏ   P< ^ެP`T`TQTPЏ   RRRPRQPQP{RPPQA\SPS߭SoP3PѬЭPSPUUP߭S<PЏ   P^ЬUޭnnXUTPUTQTPЏ   RRRPRQPQP{RPPQA郞S	   TTSG߭SP4PU
Э T)ScPVVR߭SP   TTWWRRPЭRբ@PЭRݢ@߭ЭRݢ@?PjPѬ' ЭRݬPЭRRb("PѭЭRݢ@PWWR߭ЭRݢ@PP^ЬTޭnnXTUPTUQUPЏ   RRRPRQPQP{RPPQADS	   RTS߭SSP4PT
Э R)SPVVP߭SP   RRWWPЭPՠ@PЭPݠ@s߭ЭPݠ@PhPѬ& ЭPݬ'PЭPP`PѭЭPݠ@[PWWP߭ЭPݠ@vP< P^XЬTޭnnYTUTUQUPЏ   RRRPRQPQP{RPPQAS	   RTS߭SP4PT
Э R)SPWWP߭SP   RRVVRRPЭRޮUݮE PTPSPRSPЮPe`PPTRPRPz  TP{   PQPPRB SPS߭S3P@PѭXSAPVVP"SPVVP߭SPÕXPЬSS PTPQPRQPPPTRPRPz  TP{   PQPPUEqRRsݭRPVVRRP0 ЭR) ݬЭR  P^(Zr[ЬTޭnnXTVTVQVPЏ   RRRPRQPQP{RPPQAĩS	   RTSc߭SP4PT
Э R)SPWWP߭SP   RRYYPkQ<~w PRߪ1    S!Rk&RQ2 UQbU&R&QUbSSPPkSckԣ"ЭPՠ@@PYYPЭRݢ@SЭRݢ@[PYYR
kcSkRP  P^XЬTޭnnYTVTVQVPЏ   RRRPRQPQP{RPPQAPS	   RTS߭S_P4PT
Э R)SPWWP߭S+P   RRUUPЭPՠ@PЭPݠ@߭ЭPݠ@P>PѬX0ЭPݠ@PUUPP߭ЭPݠ@PĕXPЭPՠ"PXЭPݠ"߭ЭPݠ"mPLXPЭQ2PѬPQXЭPݠ"PUUP߭ЭPݠ"!PXP< P^MZ[YЬTޭޮnTVTVQVPЏ   RRRPRQPQP{RPPQA|S	   RTS߭SP4PT
ЭR)S7PWWP߭SWP   RRUURRPЭRբ@PЭRݢ@߭ЭRݢ@P?PѬ[0ЭPݠ@PUUPP߭ЭPݠ@Pĕ[PЭRբ""hPUURRPSЭRݢ"߭ЭRݢ"P1 YjЭjЭPݠ"PUUP;ЭP2RѬR~ݬ YPѬRPRSЭPݠ"PUUP߭ЭPݠ"P1uYPSRѬRPja<~Qs PS#?    T.PSj   SR2 XRcX   S   RXcTTPPjнjݭЭRݢ"PUURjЭjRPЭRЭPP`ЭRЭЭR~ݬЭR P^ЬTޭnnXTUPTUQUPЏ   RRRPRQPQP{RPPQAS	   RTS+߭SP4PT
Э R)SGPVVP߭SgP   RRWWPЭPՠ@PЭPݠ@߭ЭPݠ@&P@PѬЭQPЭPݠ@PWWP߭ЭPݠ@P< P< ^SЬRբ"PެUeRݢ"7߭ݢ"PH  Rݢ"PTTP
PtecЭcݢ"߭ݢ"^PЬR" {" P ^eS߭ݬOPRRPЭPՠ@PЭPݠ@߭ЭPݠ@PkѬ8ݭЭPݠ@PRRP
P老cЭcPЭPݠ@oPRRP߭ЭPݠ@P< P^ﹳXЬRnnUn PTPRPSRPnRnebRRTSRSRz  TP{   PQPPWGha<P~o PT{    U.PThD   TS2 VSdVD   TD   SVdUURPhVfh(@ fԦ@VGmPYYR
hfVhRP޼RbSPxbSz  SP{   PQPPRB#(VBPYYRRPP< ^MSЬRբ@PެUeRݢ@߭ݢ@PR  Rݭݢ@ PTTP
P:﫲cЭcݢ@5߭ݢ@PЬRݢ@Ԣ@P ^WެTdVPdVQVPЏ   RRRPRQPQP{RPPQASjS߭S PQd*S5PUURRϪڱW"SPUUP߭SPWPWЭRnnTn` PSPQPRQPnPnd`PPSRPRPz  SP{   PQPPRB>TlT߭TVPSPѬ)WTePUUR6R
!TPUUP߭TPWݭ/Э%PP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^9T@ߤ0߭J PRR PФ0S   SRx	\Q\PЏ   \\PQP{\PQPQVUVRcU   S   RUV  P^敏Uե01 @ߥ0߭ PRPW    WVPХ0T   TSx	RQRPЏ   R	RP	Q{RPQPQXVXSdV   T   SVXdWWYYRRPЬRХ0bв 0P  ^QЬPС0`P0    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ,^߭<~sխP  ߭ ެUePPQޭPPSPRQPQ`cQPQS`SQSPa`bЭe ߭ݬPVVP߭ԟݭPVVP߭ݬ PRRRPP ^7  `P4" ~ݬݬݬ<~,  PRPR䀘l7  RP ^F7  P4ݬݬݬݬ<~  PRPR[7  RPd^ZЬRPެU 1 iSiR1Ь  YﭱXi߭Sݾݵ nP[[R1MRЭTVR OfKfWݵ WiP-Wݵ iP  Wjݵ <TTh ݵ jWThRVR fSiR1u1 PЬRѢTxTTS[S1    U̴YݰX jS	P[[R1 RxVR QfMPfWݵ WiP-Wݵ iP  Wjݵ <TTh ݵ jWThRVR frTx                                                                                                                                                                                                                                                   F                        
.@h $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              , "     Z      rTTSS1b[P   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^?<~=XPRP<~PP߭߭<~dPRPݭݭݬ<~w  PS%Pݭݭݬ4  P   SPSSPh^Z,V[nfP4PfPѬ PެRbSS1 SQPbQQYVmj PP7mrmj PTTP1CrUfPefPХmmY9PTSPTTP1mѭT11 PPP01 <nЬS?<~VPXRz<n~2PRg߭߭<~bPXRLPݭݭS<~  PW%PݭݭS2  P   WPWWRR	T1-PT1ѭEm<~PTTP1 ~ nݬ<~  PTTP1 [譲1 m)@~  ˏ fPРmY'PTTP/fPY#fPРermj n mj n
Pݬ G2  [ݬ<~	 62  n
mj TPP ^2~ݬ0PP~2RRݬPUUP ~RݬӹPUUP1 Pʏ P1 PPT<nЭS?<~-TPWRz<n~PRg߭߭<~`PWRLPݭݭS<~c  PV%PݭݭS0  P   VPVVRTRPUQЭQPP| t^Vݬ~vVݬݬ<~	&  PUURRRUUR1 P vެPPQޭPPSPRQPQ`cQPQS`SQSPa`bݭ/  P<,ݬ~vVVݬݬ<~	
  PUUUP1yURR   RRUUUP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP@^XМ[%xVMHRhScݬ, PBTSRÏ1  Lf PZZR1LGZ PZZR1gGQG3H PZZR1@QSkRckRУGլ4LSPSS~ݬ<~GPZ)SPSS~ݬݬ<~PZZR1ݬ PݬPZ1RB~~PݬӸ P~~PZ1QP ~ݬݬvPZZRZZRR   1k߭ݬnPZZR1ЭRR, b bݬW PݬЭRH ЭSЭSЭSмЭR1PkSѣ+УYGY7PZZR1kRЭBPѣ Z1gkRТY,  "GYuPZZR1=kR֢xYRR,  ݬ Pݬ~ ЬTdФ8UUSPxUSSWWWY2UЭ8LTdSxdSS֯1 PWP, s "sGsWPZZRlЭTTSPxTSSRRRY"TЭGsWTWPRWWGY0PZMLｨZ HA+QSkRТckRТQG	 G ZPP^ԭԭԭԮЬTT1լ.SSS~T<~PZ*PSPSS~ݬT<~PZZRRPSSTP߭SݬݬPZZRR   gRRPR~~P:R<~ݽݬPZZRRP֮нTTS1zPծZPZZPլ`u!~ PZZR1SPSS~ݬ<~gPZ.PSPSS~ݬݬ<~PZZR1OЬScTPxcTTѣ8Ux8UUﰉ1 m PZZR1ABCX PZZR1BS*RcRУퟭR PZZR1E& PZZR1`&SƕRcﻕRУѮ1$  u[ퟭݮ<PZZR1 ݬiP1R~~P1R<~KѮ-ЬRЭ8>򟭨ݮGPZZR1{!PЭ~dݮPZZR1XЮXѭSPxSSѭW	PxWWYˏ V,  "VtRТퟭXPXRX֮Y1 ʹY$PZZR1 ˏ ʹVͼW	PxͼWWX, ʹ  ʹVʹRТͼʹYkPZZRJΓRYXYY1v.Ю"d/ ѭSxSSѮ1ծZZխK խG2BSGRТc<RТB#  խG2&SRТcRТ& ۢP ZP ^լ$0  RRR~ݬݬ<~PT.P  RRR~ݬݬ$ݬ<~PTTP1:ݬ߭ݬݭݬ-PTTP1 ~ЭPݬ TPѭQPxQQRSRh R9PTTP1 2PѬPC2PPSTk2SSQxQQRRRRT)P~ݬ TP ^,'\1  1 +Y P[[R1+&9 P[[R1y&0&ݠ P[[R1R&0S﬐RcRУլ[1#+SPSS~ݬݬ$ݬ<~P[[R1 [1~ݬݬݭݬPPVѭSPxSSZUZt&LZKP[[R1wXR2RU2RTTZVTSxTSSZT~ݬZ$ 1SZZURѬR[1rSѣ3&LݣﵦP[[R1DRТZT>PУZ, L  LT&LZP[[R1R֢xZRRLЭPX~ݬZ] V@ЭTL+ѭڏSPxSSP[[R1!F&;VץP[[R1TL&;V9P[[R1 1 TS	PxTSSXTX1 &;X[P[[Rvˏ ;VWxWWY, ;  ;V;﷍RТ&;XP[[RRXYXX1q&LZXP[,+U 'I30S<RТc1RТ0&+ & [PPt^R4PS|~vw|Sݬݬ<~	 PZZRvRRZZR1  X  YRhV W |BgPPQxPPUPTQPQ`eQPQU`UQUPa`dxiPBRRhw*|~vw|SSݬݬ<~	SPZPZZR1iZRR   vRRZPZZP| ^Vݬݬݬ<~hPVVP~ЬUUݬЬTT<SSؕRbPVVPd UyTSb TyUSb`PT$ݬɨ P![ݬ P
ݬݬVP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ TЊYﭚZV˚[XyfSWU PUURRPݬ}1JͲʹ͵fͽͶd<Ͳ~ͷͶ~<Ͳ~I  PUUP	W1P< ?ߤf ߣXf <~ Ͳ  PUUPW1|j ߤfJ ߣdfB <~ Ͳ  PUUPW10E| ߤf ߣqf <~ Ͳv  PUUPW1{ʦ 1Ph,k|~ `f |~ ݠf ߤfu  fr Pjߣ}jW @~fh PUUPW1RPШP<6RQRPR
RP
Q{RPQPQ`rRr h PUUP1ТТ_iPiPТ~{ ϠPUUP1[É j "f"_ PUUPW1 PRP  PUUP1	ТiPiPТÖ j? ~fk PUUPW;PR k PUUP1 ТiPiPТWPP ϣPUPiP4ݬ3  PUrzDޣXͽyͲ  RbޣdͽyͲbޣqͽyͲbPhl RbbkbUPP  ^ 6̆\ݬ(Lﻆ\ݬ,L 	   ^dU}WT_< Q< PeRRPQP{RPQPQVQaԡ< VС? g3 PTTPQ6PeRRPQP{RPQPQVSePQxSPPQaSSeSV#S~ g PTTPSSVPPp^RﬅZ[ﾘXY\aTj\Ԭj\Ԭj\Ԭx1
_abhjcߢ%<_~	dc~<_~8  PWW\ߢ)~o~| Mߢ>h ߤXhy $ _  PWW\ߢF~o~* [M8ߤX) <($ _  "8w ߢ[h ߤdh $ _2  PWW\ߢc~o~ L8ߤd) <($ _8  "v ߢxhi ߤqha $ _  PWW\" ~o~ BL1Pߤqr( <($ _  ",v 1Pߤ}kԠ 
@~hiS PWW\ ~o~ Kߤ}' Щ\<6\Q\P\\PQP{\PQPQ！EP\ª ~o~3 dKĉ k7 
"h﯒ PWW\ ¿ ~o~  KDPĉ Q' \lԬo QJ PWW\\PĖ k 
~h7( PWW\  ~o~c JDPĖ & t\lԬt ّ PWW\\Pj\43 @7 < 1 w \l 1 y l 1   lia A~ R l ߭                                                                                                                                                                                                                                                     G                        @ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              [ "     k      
Vf ߭  f ߭  f 1	ݭ uUe ݭݭ YSc ݭ%ݭ c D~ 3ݭ e 1<ݭ e 1Jݭ e ݭZݭ c ݭhݭ c D~ xݭ e 1ݭ e 2ݭ e ݭݭ c ݭ­ݭ c j\  f j\$} f 1 ½ݭ e~ nP \lt*~xl~l|~ nݭ C|}S3 	5? 4j\ݬ$ Z: 5S t7 Y9j\     ?WP^Z[YԮWZr1
<~{~<~﮻  PYYR1ޫX߭<qR Td~SQЭPЏ@   RRPQP{RPQPQޫd߭pd?~SQЭP"RRPQP{RPQPQޫq߭pd~SQЭPЏ   RRPQP{RPQPQ1Bq1ﮍ PYYR1͈S͈ PYYR1}Rw}RУ_ PYYR1fSf3H PYYR1h}R}RУE PYYR11S PYYR1|R|RУo|SR1	R<PYYSS   1YS1 ܙ PѭTxTTR9ˏ S@~ ߭ S|SУ|SRRPjPUoRU︕PYYS1P:jSEc.jSREcRPYYSS   1R1z{RS1q VSlP1LϘ PѭTxTTS1ˏ R" fR{RТ {RS1 ѭTxTTUZUXZUZPXXLW%ݮPYWYRR   1UOPYYRR   1YRѭ5Yˏ R" fRNzRТBzRSPЭ꭪ЭWS_kPYYRR   1HS1W"U9PYYRR   1ySR1 VE WZRfP1TySУ
ySR1fPTUPxTUUXXjPѭ<ˏ S~  SySУ
ySR1 ѭPxPPTUTTfPTTpgUT~tg|P
Px|PPTTTfPT|T	UЭ
Xzi|
|tݮjRjR1P 
   
  1 ͈SwRТwRТc͈ TdPYRYfSwRТwRТcfpdPYYRYSZwRТNwRТcIdPYYRY8uWuS ؑ ߭u ֦PY﶑YR# tݭ PYYRO A~ t ﰝPYYR R   R1 YRR   YݬV XvR 8 ' ;vR$Ct 
4tS3 +? +vRݢ$ 0 ,S . /uR  S6n1 ͈SuRТuRТc͈q TdPYRYfSguRТ[uRТcfBdPYYRYS,uRТ uRТcdPYYRYԄq фZ ΄C YPP  ^3 <*? *tPݠ$ / "+ݬ , .YtP     4P| ΰ^kRVIUOSKg1Ͳʹ͵eͽͶ<Ͳ~pͷͶ~<Ͳ~۰  PTT\~o~ O<e" ߣXe <~ Ͳ  PTT\~o~ ;eڐ !e ߣde <~ Ͳ5  PTT\!)~o~` ;Pen <eM ߣqeE <~ Ͳ  PTT\!D~o~ %;1 P5e 1 PRCߣ}fԏ @~e8 PTT\W~o~ :BÉ f "e? PTT\j~o~B s:DÖ f> ~eʁ PTT\}~o~  ':q\4 P ^uqR<QbPQ0PbPݠ,  bPԠ0bP4bPݠ,  Џi   ~ P ^qR<~APPbP4PbPݠ,"  d_  bQ<0 2    A_  bPݠ,  <j ~ P< ^UZLSc(f \ljlul1 P픭Ő<~l~<~.  PTT\\PޣXb  RbPTޣdbbPTޣqbbPTo\4   TP< ^S6^UoRT53 Pb5I~ 8b>< ~3 Pe< ~I~ 7< ~~eЌ e bPCwbPbPbPbPԠ0bP4bP(4PTÔT~&L }7bPР(V],p4PTâT~& J7bQС,] PQ8   ^P< ^nTNJR¤ P¤ ЬQС8ddP`\Р(\Р,\US dP4 SP  ^ЬPР8'nР8P`\Р(\Р,\|P  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^ݬ3  ^ݬ4  ^PլЬQ@aPPP ^RެTRdЬS߬Bc RRd< ^RެUReЬTЬSBdBc RRe  ^P  ^P $^<~;PRRP { P< ^UISЬRbPPŏm  PQPPQTTP2@XPPQPQPUQbPRRRPRQPQ{RPPQQPTUUPP| ^HTЬScPPŏm  PRPPRUUP2@XPPRPPRVQcPRRRPRQPQ{RPPQQPUVVPPRЬQPPR<RPRP  MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^)~1~PP0 D X l          0@LX18r?PЬP"  1PЬP  1
PЬP  1 PЬPb  1 PЬP   1 PЬP6   1 PЬP"  1 PЬPn#  1 PЬP#  ЬP$  oЬP&%  _ЬP%  OЬPN&  ?ЬP&  /ЬP'  f Z    ||}0 ^TЬQ<SSAPP@. PRЬPR\ R <  ~\PS	  Sߤ; P ^yR|~<   ЬQQp 8i<~ PSPSߢ\ P ^)R|~ ЬQQ h<~ PSPSߢ~_ P  ^ݼ	 ^ShWzREUPP  ;1]?PJ{PŌ P τ PbPT|~ T zX PVP  <XPP7<X~Vß  V V&  <X~ P|~ b g<~ PVP: D <QQTQ
  <~- C<~ PV<!  VV ÓV PŌ 1."zPŌ 1Ō b8|~8_ g<~ PVP2  <QQ>Qæ <~ VPV_ 1V |~ ݥ\PXPXD1 {X PV1^P|~|~|~(yX PVˏVT<XPP8<X~VÎӃ TVV <X~E P|~|~|~g PVP<PP<~Vv PТ@1 |~8|~g<~ PVˏVT<PP9<~V. TgV Pz<~ V|~ ݥ\PXPXÍՂ X\ PVPP^9WFwR+BU|~|~|~it PXˏXS<t\\*SX P<t~ P19) PVVYEPTT\lVSS? PS
 PT<S
 PTT\qPTT\S|~ ݥxPXX
X# V( TPP ^vRP\   	< ^uUvvTSqv)WPSSR1 ߭ݬs  PS1 ݭ~PSSR1 ߭ݭZPzPd ЭRݢ4  ЭRP߭ݢ	A  PS߭ݢ
ݢ	~C  PSSP
ݬݭ#/  ݭ~P߭ݭ~Pݬt  (V!SR
RЬbP^u3)P^WtXV9u(UPVVR1<~<~  PY߭^(nY~@  PVVR1`RPP   1RZ?P߭^(nY~=  PVVRRn1P߭ݬݭB  PVVR<~ݭ2,  PV1 ߭<~ݭݬ+  PVVR1 P<~^(n<~<~t  PVVRR0V1 ߭^(nY~'?  PVVRRC]߭^(nY~<  PVVRR[-߭<~ݭݬ*  PVVRRlST.VR
SЭRТcSЭRТcFs'VRR   VVPP^rWXs&SwPXXRc<~<~x  PY߭^(nYVV=  P6ݬݭ*  PXXR!ݭC+  P^(nV|t  *S/XR
RYbRV(fVRЬbRr'&XPP| ^9r%ݬЬV^(nf~< ~;  r%P| ^qf%ݬЬV^(n^(n f~<   ~>  q%                                                                                                                                                                                                                                                   H                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              j5 "     |      P|  ^q%픭(Ь k  PVVRݬ^(n~<~:  Sq(%VP|  ^=q$픭(Ь   PVVT Pݬ^(n~<~\:  )Pݬ^(n^(n ~<~=  PVp|$VP^pZoWj#QPXXR
j9$RP<~<~  PY߭^(nY~^;  PXXR&RA<~^(n<~<~p  PX$<~^(n<~<~qq  PXX{PHXR7
V߭^(nY~8  PXXRЭRТfP  a#XP^uoYnVi"<~<~  PXO;߭^(nX~88  PWWRdPWWR
i"RP ^(nX~p  PWO&WR
RXbR(bD  "WP^nZnXj"6OPWWR
jU"RP<~<VV  PY߭^(nY~P7  PWWR  ߭^(nЭRݢ!V7:  PWWPP  ]  1 ?PݬЭRݢ'  P< ~ЭRݢ%  PW1 P < ~ݭݬQ$  PW1 P<~^(n<~<~Ln  PW^P߭^(nY~6  ߭<~^(nݭ<~-  P	WP < ~ݭݬ#  PWWM_WRN
S߭ݬЭRݢz;  PWWR&ЭRТcSЭRТcSЭRТc
PPP   WP^l[lXYk @MPYYR
k_ RP<~<WW  PZ߭^(n^(nZVVW9  PYYR1 ݬݭ>$  PYYR|ݭ$  Pn߭^(nVP6  PV ߭^(nݭW7  P ЭS<!RR  ݣݭWS  ^(nZ~m  YHL1YR 
R	ZbRV(fVRЬbP  EYP^YkZjXjKPWWR
jRP<~<~寮  PY߭^(nY~3  PWWRR1 1 P^(nЭRݢ!<VV  PD<~ЭRݢ!  PWWR1  ߭^(nЭRݢ!<~6  PW1 P߭<~^(nݭV-  PWkWeP<~^(n<~<~j  PWW<߭^(nY~3  ߭<~^(nݭ<~  PWWJ0WR
SЭRТcSЭRТcP8  WP^	iWi<~<VV  PY߭^(nY~3  PXXR1  ߭^(nݭVV5  PXXRtIPXXRZЭRݢݭ<~CQ  PXI9XR"
RYbRV(fVR(bPLPXhXP| ^V?ݬ^(n~<~   PVVRRRRRVVVP| ^V?ݬ^(n~<~   PVVRRRRRVVVP ^ԭ? ݬ߭~<~A  PR?ݬ߭~<~"  PR߭M0  RPPPPPRRRP| ^ݬݬ^(n~<~   PVVRRVVP $^ugW?<~N
PVVR1 
A1 Pg딭(Ьݟޟ  PVVRRRVg1Pݬ^(n^(n~<~(  PVgVPP^fX?<~	PWWR1 
A1 P~OPA1 hЬRb7RЬV^(n^(nf~<~O(  PWWRh
Bݬ ЬRݼU,  PWݬЬRݼ:,  PWhWPP| ^V?ݬ^(n~~<~(   PVVRVRRRRRVVVP ^eXVR'Ɔݬ]p PݬR<~-PWrh픭(Ь   PWh.ݬ^(n^(n~<~6&  PWhWPP ^Wd<߭^(n~<~B  P~/  PWW1>ݭVmP1-TT_RTTTSRSOP߭ݭmPW6ЭTݤ<~ڮPRݭAmP	WPRSW1 RP߭ݭKmP޼SBc޼SBcR1 ЭSݣ<~vP]޼VЭSSSTޭSSPSUTSTc`TSTPcPTPSdceЭBf޼SBcЭS<~<~Z  RݭlPR1RRWWTc)WP^W;c2 P*߭^(n~<~  P~..  PW4߭^(n^(n~<SSl  P~Sl0  PWW	W1tPݭzkPWWR1]Ь(Rxb<b~ Ь$RRm RYP   RXT]RTTSRSOP߭ݭkPW6ЭTݤ<~ڬPRݭAkP	WPRSW1 Ь Rb߭ݭIkP1 bRR1 <   VЭRݢVtPQ QЭRRRSޭRRURTSRSbeSRSUbUSURcbdЭAiЬ TdSЭRChdݭjP߭ݭjP RR1o R	WPWDaWP| ^-aݬ^(n^(n~<~L"  PV`VP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^S߭ݼh]  PS1 ݭViPSSR1 ߭ݭiPfPЭRP߭ݢ	9,  PS߭ݢ
ݢ	~<.  PSSP
ݼݭ  ݭ1iP߭ݭTiPݼ^  PP^E`["`V_Y`_XWЬRbSRмZhSj  PWWR1 fZ   PWWR1 i^(n
~(  PWWRt*= PiW1 *hiWj iR!FeP
W1 PiR+ePWni$_RbePWQkݦiRݢ^-  PWWR<~iRݢ  PW!k<~iݦ  PWWRkRZWPP^WЬRbYRЬV(fVмX߭^(nYVV)  P5Xݭt  PWWR!ݭ  P^(nV+`  WPP^]X]VмSfS"i  PWWR1 h^(n
~&  PWWRp* PhWb*fhh hR!cPW>hRcPW'h]Rb6dPW
WhR%%WPP ^ЬRbVR( ^(  V~/_  PWWP^]Z\[[]X\Y\WЬRbSRЬRbTRмngSg  PVVR1kT  PVVR1ohݮ  PVVR1Xi^(n
~%  PVVRx*U PiV1$*giog iR!^bP
V1 PiRCbPV1 i<\RbbP
V1 P j^(niRݢ! (  PVVRY0
 Pj	V1 P0kjf jRaPVcjiRݢ!]bP	VJP[ݨjRݢ)  PVVR)[<~jݨ  PVVR[RnVP^1[ZZXZYZVЬRbSRмTfS(f  PWWR11hT.  PWWR1i^(n
~#  PWWRz* Pi
W1 P*fie iR!`P
W1 PiR`PW1 iZRbaP
W1 P j^(niRݢ! Y&  PWWRY0 Pj	WKP0hje jR`PW$jiRݢ!`P	WPjR!!WP^ЬRbXRЬV(fV(߭^(nX~#  PWWR: ߭^(nݭ %  PWWRЭRݢݭ A  PWWWPP^WЬRbXRЬV(fVмY|~ ꟭X~o PWWR1 ߭^(n^(nXVV &  PWWR1 Yݭ  PWWR~ݭf  Pp߭^(nV"  PX ߭^(nݭ $  P ЭS<!RR  ݣݭ @  ^(nX~IZ  PWWPP ^}XRмTbT  PSSP6Wݢ	q=  PSSPcXbWPPݠ~A  PSSPP| ^WSЬP`VPЬP`UPмTcT=  PRRPncU<  PRRP[WVcPݠ!Q=  PRRP>cPݠ!`PRRP)cT<  PRRP;WcPݠ!]PRRPP^ЬV(fVЬRbYRмXVXb<  PWWRWVYVRݢ!<  PWWR6VSSTУ+R&a P	Т++PRTТ+RۚWPP ^VRмTbTu  PSSPW/Vݢ	;  PSSP?KVݢ
VPݠ!<  PSSPV<~Vݢ  PSSPP^VVjVXUYмSUS#  PWWR10 PfW1 fR(0UbifRݢ;  PWWR1 ߭fRݢiRݢ!a;  PWWR1 fSЭRТЭRԢfRЭ+fRݢ2^hfRݢ^P2PhRffRݢP^PWWRhfRݢm^P߭fRݢiRݢ!:  PWWR'iRݢ!f^PWWRfiRݢ![PWWP| ^ЬRbSRЬRbTRiTS:  PVVR.TTJTRݢ!S:  PVVR
eTS(VP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^W<SˏSRR   VʏSȏ   SSVVݬ<~^(nݬ<~  PWWRRPSݼd  PWWRRPWP ^Sԭ<QˏQPP   	RPʏQȏ   QQRR߭ݬ\PSSPЭP!NS ݭt  PSSP| ^ ߭^(nݬ<~,  PVPP^SYԭݬ[PSSRP߭ެWg \Pn<X|~|~ ЭV^(n~X
c ЭRݢi  i ЭRݢ  ݭ g[P߭g[PެRb%[b[P
b[PP^<SˏSRR   
RPʏSȏ   SSRRQE߭y.  PXXRRP|~ЬRݢݭ߭ 
~<~	b PXXR-RP߭߭ ЬR
~]h PXXRRPЬR0J PbSGPЬWgR!gR(gRЬV
gR(gRЭgRЦgRV'gRԢ+gRWPXXRRPݼЬR!   WPXXP< ^URw11 0< ~ PS|~魯 `S[ |~  ݠS[ \lߥ#Sl Sl0S0 PTS| T\\P  |>> 0郞 PTT\\P³ µ ¶ ·  ¾ ¸ · ~<³ ~nz  PTT\TTPߥ,0 ­ ³ PTT\T                                                                                                                                                                                                                                                     I                        @s\^ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           TP ^RS4>00y PS ­ ³ PSSP< ^=UnRT1 /}0< ~  PS|~ `SZ |~t ݠSY \lߥDSl Sl0S0 PTS  T\\PTP³ µ ¶ ·  ¾ ¸ · ~<³ ~y  PTT\T)P ­ ³ -PTT\TTTP ^iR.1 0 PTTP>0浪 PTTS0 SPբB֢>>6ТBnݭ0` PTTS0￰ SPТnBЬPЭPݭ0 PTTS0 SP>0 PT0` TP PTTP 
ЬP ЬP ߭ݬ ­ ³ uPTS6-0߮ PSP ­ ³ ;PSTP ^R^-ЬPPݠ 0 PTTP"ЬPݠP ­ ³ PTm PTTPЬPݠP ­ ³ TPTS5,0 PS ­ ³ sPSTP ^R,1 0 PTTP>0L PTTS0﫮 SPnݬ0 PTTS0| SPТBnrnݬ0̩ PTTS0G SPЬB>0 PT0 TPݬ ­ ³ uPTh PTTPݬ ­ ³ JPTS7e+0 PSP ­ ³ PSTP| ^SP+qެRѲ  ֲ ެTdUUݲ  0ɦ PVVP6ѥ,Pֲ dݲ  0 PVVP
dPѠךVPЬRbRݬ í    PVVP ^Rݬݬ 0B PP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^T( PSTvЬRSbЬЬQС	С
QSݡOPTTPS! (PS@  PTTPHSB  PTTPP ^T PSPЬPS`ЬЬR
Т	ԣ
RSݢ+OPTTR
S RPSa@  PTTPNHS  PTTP ^SެRb߭ݬgQPSSQЭPb	HQ ݭ  PSSP| ^V߭ݬݬA  PVVPG ЭPݠt  ݭrA  ЬSЬT߭TS   PUUPPR&PSPPUݭ6A  ݭ ԭVP  ^ݬP߭ݬPPPP ^-GSݬOPP߭ެRbSPPKPc ЭPݠ  ݭ@  ݭ ԭbOP߭bPPެRb{ObPPPbPPP ^߭ݬݬ  PRRPݬOPRݭ@  l RP ^߭ݬݬ  PRP2 P< ^IU6R&1 0< ~ PS|~ܮ `SP |~8 ݠSP \leSlߢvSlS0" PTS T\\Pߢv |>> 0 PTT\ \P        ~< ~o  PTT\T2~ߥ	   PTT\T B TPP ^	RS 4z%0ﵦ PS   PS SP< ^ɮUR P&%|0< ~: PS|~V `SCO |~ﲭ ݠS3O \lߥ!SlߢvSlS0դ PTS1 T\\P TP        ~< ~Jn  PTT\T(   mPTT\TT TP ^R.$1 07 PTTP>0 PTTS0C SPբB֢>>6ТBZݭ0 PTTS0 SPТZBЬPЭPݭ0K PTTS0ƥ SP>0  PT0 TP PTTP¾ 
ЬPº ЬP¾ ߭ݬ   PTS 6"0 PSP   {PS TP ^%R"ЬPPݠ 0R PTTP"ЬPݠP   PTm 	PTTPЬPݠP   PTS 5"0V PS   PS TP ^]
R!1 0ߣ PTTP>0 PTTS0 SPZݬ0] PTTS0Ｃ SPТBZ^Zݬ0 PTTS0 SPЬB>0ܞ PT0\ TPݬ   PTh PTTPݬ   PTS 7 0 PSP   ;PS TP| ^S PS qެRѲ  ֲ ެTdUUݲ  0	 PVVP6ѥ,Pֲ dݲ  0 PVVP
dPѠךVPЬRbRݬÚ Å    PVVP ^-Rݬݬ 0 PP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ԭ߭ެV^(fn^(nSS<~   PWWRES'PA0<fRݬ ݭ  PWݬfݭ  PWޭnо Rբݢ= о RԢо Rբݢ# о RԢݾ      WP^|ZX  PVVVP|f(YY<WW6  P
^(nYW  P~  PԦ
WPZZR1F^RզPB1LRRެScެRb P[b~<c~g  P1wP   
P1f
PZ1[P(;  PZZR1
P,  ~<~f  PP   [P
PZ1PXXSRRR~ PCXZ1SPXRBWRRR, g Rg~<~ƥ P
g1 PЦR?Bg^(n~<~j  PZZR&R1Z[ЦRBg1 PЦR BgvSզo?C  ~<~^
  P
 @Cg<P<RR+RX1PBx BRRX1eCgSS[Z(ﭸ  PZZR12~<~4e  PP   1P[1P1Z1 PXRBQXSaCPRզPPЦT<D`TT   Ba,P<B`TT @   @B`ЦUBaTTE`BaB`BaRRSRXSRSBBm BRRSXXRBXRBkXXRBRRR~ PDզ
ݦ ԦZ,ZR&RX BB BRRXZP^|ZЬR	1ЬRբ1ЬSУ
RѢ1PЬXRRR,  RR1 ݬh~<~ P
1ЬWЧR?BЬY^(ing~<~  PPRwR1qYg~<~c  PЧRBNЧRB@Pը
ШRB-ШR?B^(n^(nݨ
h~<~  PVެXhRV1 Ш W Y?FYݬݧ
~<~"  P&hTФRФUФSFbRRCeFe=F6P<RR1 PRRZ[PhR޲RFbVhRV1v[ЬTZd<ZSˏSRE Sd?ެT VެUeRV  SF VVЬT<dSˏSR SdP ^ЬRbPՠݠ bRԢЬScRբݢi cRԢЬRbV b    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^6P`TT?PUURRPެRbT
@PE Sв Pcв P

PT?PUPbT?PP^Y<~<~  PnnX(SޭޮUK6RbVV?PWWRRTXݮVd?PDоRѭоR
n
T'V?PWTݮV ?PTTYYT
ЭR%PTP^nnX(SޭޮU5RbVVN>PWWRRTXݮV>PDоRѭоR
n
T'VO>PWTݮVl>PTTYYR
ЭRТ!PYYP ^߭ݬF  PRRPЭPР!PRRP^YnnX(SޭޮU4RbVVh=PWWRRTZPݮV=PDоRѭоR
n
T'Vg=PWTݮV=PTT
ЭRТYYYP ^R߭ݬ`  PЭPРRPRRP ^ݬ<ެUeݬ=PVVRt> TPе RdP
ЬSмcPе PР+RPdP4Т+Rݬ<PVVRPeݬ<PVVRPWмSգ+j~ PzM P&Wլ= P(ЬRSbPWݣУ'Rݢ!<~  У+Sգ+P ^ ЬV6߭^(n<~<~C  PPWWRRWWPЦ!߭߭^(nݭ<~P	ЭR! PP| ^V߭^(n~PVVP ߭^(nݭ<~/PVЭRТPVVP| ^UTЬSޭR߭S9  PVVP
ЭPР!bPVVUUP߭ݬݭx  PUЭPРUUP ^ݬU:ެRbݬ:PSSP9в PѠPݬl:PSSPPbݬ:PSSPЏ   P^R ߭^(n~?PRAPլP ߭^(nЬRݢ!<~PRPЭRТЭTЬUޭnnWT}9nT9PVVR=Pо RѢUS4PT9PVVRSPnT9PVVR   SSXXT	ЭRTP 0x%02.2x from %s (%d) of StartupTrustee
 ShmInitSLList  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^!S/T[UR//e& PRRPcS:  8P< PdI~01V/_PRRPߣ'P&1 ߭"5PRRPP;%1 Э ߭4PRRPPϡ%1 PdPЭdPPRRPߣ8P&n߭4PRRPuPF$FdPЭЬPd,n.P DeֲRP
ߣI9 
J.Pe	ﭲ 2< P| ^qUԭTV &
  PTT\% w  PTT\ 
  PTT\1  .3  PTT\3\T P                                                                                                                                                                                                                                                    J                        
<a $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              SF "           1  PTT\ 2  PTT\1  (PTT\1\T PTT\ PTT\1  PTT\.\T PTT\ ~PTT\a\\
 (PTNPR<R~*P7~
  PTT\\ߥp7 PR<R~)PW
M|R 1  PR PSR\SR PSR\SR R  PSR\SRRVT\VTT\+ś \t~ ũ N~ @TP ^|R 21  PR dPSR\SR PSR\SR   PSR\SRRP0^5\FZGXVn#   拉  YY[ЮR֮RPP& Z       .Jb1aP2?PjRݢ, ߭h HPVjRݢ,%1$P씭봭韭~<~U  PV1 PW~^(n|~PV1 ̫  ܟiPV1 W~^(n|~PV1 ̲  ܟiPV1 W~^(n|~PV1 W<~ݭ^(n|~kPVg̷  ܟiPVPPAW<W~ݭ^(n|~kPV2̾  ܟiPVPAW<W~ݭ^(n|~kPVѮnVR1hVR׮RP  ^)6)\ $P ^)RТWݢ:W2߭W2PVVR?Э\^(nl~<~W2PVVR߭W2PVVRh)Rݢ5^Q)YiRݢiRТW	 PVXPPf(W1VW/PXXR
V P <  ~SXiRݢXP  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^TVR0%x#%2  2 Pf1 ~ PSd2 P|~ `S2 |~] ݠS2 \lߤ1SlߢaSlS0F PUS U\\Pߢa ԢDߢD 0 PUf 0 PU1 P~; PSߤ:,2 PߤkS;2 ߢrS32 RTUVS]WV~<R~Q  PUU\1  ߤs ߢLRPUS U\\Pߢr(  ]   PUU\\PԢDߢ@ߢD ߢLRPUߢ@f ߢLRPU
S U\UUPP ^T6#WURV1 բH1~  PSđ 0 P|~
 `S0 |~f ݠS0 \l SlߢaSlS0 PVS V\V1He 04 P1tgxg/  / Pee 0 1EPբH1;~' PS 0 P S%0 ߢrS0 RTUVS]WV~<R~~O  PVV\S V1 P ߢLRPVS V\V1 H¤ 5gxg.  . Peߢ@e ߢLR\¤ T@ߢ@e ߢLRSP6gxg.  . Pe@ݢ@e ߢLR9VP ^RSբH.0  ߢLRQPSԢHSPP ^mRSpբHG EPS;բH
 4PSS\Ԣ@ߢ@߭ ߢLRvPSS\ЭDSP< ^RUТHSYT SG PT;S
 PTTPԢ@ߢ@߭ ߢLRPTTPЭDTUUPѢD´ ~ğѢD¸ Pn0 ߢD0C PUUS0 SP֢DߢD0 PU0y UPТD*֢DԢ@ݢ@ߢD ߢLR[PUUSТDPP< ^SURTRQRQPP   0 4V?P~XPSP~ϫPSP~?PSSPRTP RRPP   ?PUUUSPP^!Zｌ[Y|߭+  P1 *V*WЬ1 ԭЭUޭޮXSк TT*PSSPPRAPݮTfP0оPѠUR%PTgPSSPRPݮTfPRRYYP1ޭЭSR PQSоaQ&R P߭  PYYP	ЭPЭߠ߭*  P1Yխ4ЭUTUSPcRS SRSYR
!+ YYPP^
|ԭ߭P1Hg)Z,) YQ)X)* [  1ԭЭVޭޮWTRbUU(PTTRRS?ݮUjP0оRѢVS%PUPTTRSݮUjPSS
SR0ޭЭTSiPTо`P1VPS1LԭЭRТ!UЭVޭޮWSUTXU'ݮUhPSSR7PоRѢVT-PUPSSRTݮUhPSSR   TT
TR|ЭSSWSFkP-ޭ ЭUTiPUо `P 1 T1 SWУ+S0PVP(0fԦ(ЭզV+K0PVP(0f$P
PRRPVЭRݢ!$P
PRRP߭XP1
խ%ЭUTUScRS SRS픮
R
   P^|ԭԭ߭쟭P16&W&Y6  &Vn&XЬ1ЭUޭ ޮ ZSAP`TT%PSSPPRBPݮ TgP0о PѠUR%PTiPSSPRPݮ TgPRRRP0ޭЭSRPQSоaQ1QR1IPЭPРZP[1 ЭPР!TЭUޭޮRTSZPT/%ݮTfPRRP7PоPѠUS-PThPRRPSPݮTfPRRP   SSSP0ޭЭSRPQSоaQ1 R1 ЭPРZP[߭ݭZ*PPP1ޭЭSRPQSоaQ7PR.P߭[Z  PPRЭPЭݠPRP߭쟭P1խ$ЭUTUScRSD SRS픮R   P  ^P  ^P  ^P ^R PQЬЬP`aQ`RRP ^ЬScRS SRSPP ^TP`SSZ#PTTPެRbS#P4Pв PѠPSm#PTTPPbS#P2 P ^SլPݬ"ެRbݬV#PSSP:Pв PѠPݬ #PSSPPbݬ#PSSPЏ   P^XԭլլPЬRb*g PbPЬWgRЬV%%gR

gR(gRЦgRЦ߭RPXgRЭ!߭=PXgRЭg6Rݢ PXXP^XЬTЬVޭnnWUTSaPT!nT,"PUUR;о RѢVS4PT!PUURSPnT!PUUR   SSXXRP.|~|~ ЭR~<~	(  ЭRݢUЭSУ+T;ݬ!PXЭRݢЭRբ
ݢ"ݭ3 JTVЭR(ЭR(ЭRЦЭRЦЭRЦЭRЦ++V P^WYЬTЬVޭnnXUTS^Tc nT PUUR;о PѠVS4PT PUUPSPnT PUUP   SSYYRPЭPР+R?Т+Sg&|~|~ ~<~	b'  ݢR RSRЭRԢ+ݬM PYЭRݢЭRբ
ݢ1!g.|~|~ ЭR~<~	&  ЭRݢ P ^TЬRb, PbPЬScPЬRcPcPТcPТ		cPТ

cPТcPcPЬcݬPTTRc
 cRPݼ
  PTTP   ^QޭPPSPRQPQ`cQPQS`SQSPa`bPp^Y,[Pr~<~f  P 
\1߭ЬRݢPZZR |~|~ݬ#~<~	n% 1	PЭRݬ P%  ЭRݢ|~ݬ#~<~	0% 1	߭ЬV^(fnSSP!  ЭRݢ|~VS<~	$ 1m	kPZZR1T	pЭR<%~^(n~<~  PZZR1#	߭^(n~<PZZR1	k
SЭRТcЭRݢ߭ЭRݢ.P1YTkdPZZR1߭ЭS<~ݭݣPZZR1rk ZR
S
ЭRТcdpЭRݢzP18߭ЭRݢP1o1kﶗPZZR1 ߭ЬRݢkPZZR|~|~ ݬ#~<~	I# 1P߭ЬSݣЭRݢ!PZZR`ЭR
1 ЭRݬs PoЭRݬ\ PX|~ЭRݢݢ|~ݬ#~<~	" 6P߭߭ݣ϶PZZR|~|~ ݬ#~<~	" 1߭ЬV^(fn~'PZZWW|<~^(fn~<~  PZZR1߭^(n~PZZR1k7
SЭRТc/&PZZR1tW1j{ЬW~|, P1ѭj{VЬUVRUSb5b;0c,c;'bc   T)PRSbb;	cc;ڑbcT   TTZZR1c1]ݬ P1
߭ݧЭRݢ!PZZR1ЭRݢ!)PZZR1ݭЭRݢ!MPZZR1kЭ{VЬUVRUSb4b;/c+c;&bc   T)PRSbb;	cc;ڑbcT   TTZZRk1
SЭRТcSЭRТcSЭRТcsjPZZR11=17PЭRR1 ߭ݧݢ!{PZZR1ЭRݢ!
PZZR1hݭЭRݢ!.PZZR1LЭkC
SЭRТcSЭRТcSЭRТcﺓﱓPZZR1ЭRТ+WRXWxPݬ PYkA
V(fVSЭRТcSЭRТcOFPZZR1Ч++ ݧ	WXЧ+WЭ蚮R;Э߭߭ЭRݢݬݬ~V PZZRѭح	ЭPP  M1j?P߭ЭR<!~^(nݭ<~PZZR1Эnk*
SЭRТcSЭRТcg
ЭRݢ߭ЭRݢ
P1 5Tk
dPZZR1q߭ЭS<~ݭݣPZZR1Nk
S
ЭRТcdQ
ЭRݢ[PZZR߭ЭRݢvP1s|~ЭRݢݢ|~ݬ~<~	_ 10ž PZ1(0ЭS(ݭvZRݭ߾ ԭ1ЭRԢЭRЭ+Эnk
SЭRТc
ЭRݢB߭ЭRݢP5ЭRЭЭRݢ]PZZR߭ЭRݢxP߭ЭRݢЭRݢ!PZZR5ЭRݢ!nPZZR1 ݭЭRݢ!PZZR1 |~ЭRݢݢ|~ݬ~<~	                                                                                                                                                                                                                                                   K                        ? $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            ݬЭR  ݭɾЭnk6
SЭRТcSЭRТcSЭR(c܏R|~ЭRݢݢ|~ݬ~<~	 n	n  Zk 
ܾZP  ^ЬQЬPa/a;*`&`;!a`PQPaa;	``;a`PЏ   P ^
P`TT\PRRP߭TP1 R{SPЭPݠ!"߭ЭPݠ!bP8ЭPѠ
ЭЭPЭPݠ!cP߭ЭPݠ!bPTcPP߭TbP< P ^߭ݬ2PRRP<߭ݬЭPݠ!PRRP߭߭ݬ PRRP
ЭЭRPP^X"ZЬRR[Т+1 Yԭ ߭ ЬS~	  խѭcj*	iPPRY	ЬVЦ++ ݦj'
W(gWSЦcSЦciЬRR[Т+1a ^QޭPPSPRQPQ`cQPQS`SQSPa`bP  ^ЬQaaPPaaPʏPa ^SЬRbbQ<QPPQbQb    ^QޭPPSPRQPQ`cQPQS`SQSPa`bP^ЬRТUޭnnXTԭPРVVP   SaP߭VPTTRDѽUЭPР S8VPTTP   SP߭VPTTP   SSWWRg PSslPЬRТc!
PWWRRPУSPݠ
PWWR1 RPЭTЬRT߭TPqЭP=ЭP2PЭPѠ		!PЭPѠ

ЭPѠ		S1PTP   SP߭TP   SSWPݬPWWP^ЬRТUޭnnWTԭ%PРVVP   SaP߭V<PTTRDѽUЭPР S8VPTTP   SP߭VPTTP   SSXXRPЭTЬRTQ߭TPqЭP=ЭP2PЭPѠ		!PЭPѠ

ЭPѠ		S1PT7P   SP߭TPP   SSXXR
ݭ[PXXP^ЬUޭnnWTԭRТVV
P   SaP߭V
PTTRDѽUЭRТ S8V
PTTR   SP߭V
PTTR   SSX% ݬ;  ݬ- P߭ЬSS<~ݭ<~T  PXXR1 c% ݬ  ݬ 1 PЭRЭWRRZЧV((  զ+nЬSSЭR~  <P~ PHݦЦ'Rݢ!<~P(cЬVЧR(fݬVЭR~  <P~ XP ^Rԭ,PРSSPP߭SIPRRP>ѽЭPРPSPRRPP߭SPRRP< P< ^<~<~8T  PUݬ_P	ԼPS"PݬP	ԼPSSSLެR TbdP	ԼPв PUSPd2P	ԼPS ^ݬ
߭ݬ8PxެSУ RЭPAЭQcP3cQPЭPѠ		ЭPѠ

ЭQcPѡ		Pݬ
PP߭ݬ
PЏ   P^ЬTޭnnXSԭYPРUU
P   RaP߭Up
PSSPDѽTЭPР R8U
PSSP   RP߭U,
PSSP   RRVPݭ	PVVPPݭ
PVVPݭЬT PРRRP	P   SfP߭R	PLѽTݭp R	PWWS2PRK	P   SP߭Rd	P   SPP ^	 PРRRPP߭R&	PEPѽݭ R.	PSSPRPP߭RPP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| ^Vԭ߭<~^(n<~<RRP  PR  PVVRRP
ݭs  PVVRЭRݢ<~!
  VP| ^Vԭ߭<~^(n~ p  PVVRRP
ݭ
  PVVRЭRݢ 	  VPP| ^Vԭ߭^(n<~<~O  PIPVVRRPЭR%& ݭ   PVVP| ^Vԭ߭^(n~PVVRRPjЭR<%RR  PЭRբ!"ݢ!߭ЭRݢ!PPЭRբ"ݢY߭ЭRݢPPo ЭRݢ1  PVЭR      PVVP^V(?߭PXXRRP  ݭ|~~<~	K
 PXXR(RP ߭ ~ PXXRRPզ0ЬR*{ PbPЬRЦ0bж00,   * ЬWgR%gR
gR(gRЭgRԢ߭WPXgRЭ!߭BPXgRЭg;R  PXXP< ^hUR1 4< ~Ｍ PS|~d `S |~4e ݠS \leSl Sl*S4[ PTSﱭ T\\P ͍ |BB 4Y PTT\p iP      § ¡   ~< ~%  PTT\ ߥ	*«   PTT\T A TP ^RS 4z4\ PS«   PS SP< ^YgUvR T1 P"1 4< ~3 PS|~Oc `S< |~c ݠS, \lߥ"Sl Sl*S4Z PTS) T\\PB 4V PTT\ \P      § ¡ |~1$  PTT\«   ZPTT\TT TP ^aR1 4#\ PTTPB4U PTTS4/\ SPբF֢BB6ТFlݭ4U PTTS4[ SPТlFЬPЭPݭ47W PTTS4[ SPB4W PT4[ TP PTP ЬP 
ЬP ߭ݬ«   PTS 64Z PSP«   gPS TP ^RTЬPPݠ 4<V PTTP$ЬPݠP«   ﰜPToP PTTPЬPݠP«   |PTS 54>Y PS«   PS TP ^R1 ѬP4Y PTTPB4iS PTTS4Y SPlݬ4:S PTTS4Y SPТFlplݬ4T PTTS4dY SPЬFB4T PT49Y TPݬ«   PTi iPTTPݬ«   fPTS 74W PSP«   PS TP| ^S:pެRѲ 	 Pֲ ެTdUUݲ  4Q PVVP6ѥ,Pֲ dݲ  4Q PVVP
dPѠךVP PЬRbR ë Ö    PVVP ^RѬPݬݬ 4   PQ PP ^RS߭ݬPP|~|~ЭP
~<~	 ЭPݠ!<~ZPSЭPݠPSЭPՠ!
ݠ!ЭPՠ
ݠ.P`PSЭPԠТ0Э0SP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP| 4^`USߣ0￦PVVPeP&hp ЬPУ0`߭r ߣ4߭ PV< ~ PT|~8\ `T% |~\ ݠT RbߥTbߥT fTH!V PVT	 |~Џ    ~  ^\0  μ^WV   PP?T1 U?<T~WPSS\1 1 ߭<T~7PSS\1  ?<TRR"PSS\\   VyݭRw   PSS\arnVRѭLg <T\\} <  ~e\ﾔ 
<  ~eTT1P ^mV<n<nRS1 P߭߭<~PSSRfݭݭݦ4<~9PSSPP   ; > > > > > > > > > > > > > > > > 3 3 P?PSPSSWWR	W1 P ݬݬ<~PWWRZR   MPP?WBP=P    SSݬ<~OPWWR, c  cWWPΈ^7[ZXݫ0︣߭<~PZZRZ1p͵<ެRRSޭRRURTSRSbeSRSUbUSURcbdЭޭRRSޭRRURTSRSbeSRSUbUSURcbdЭ<S SR<RRxRT S<SRxRRRTTެRRSޭRRURTSRSbeSRSUbUSURcbdЭެV<fS SR<RRxRT S<SRxRRRTTf, ͛ ͛߭͝ Rb͵͡bͧ?ͩb߭ͫb߭ͯb?fͳb<<RY1 P߭߭<~/PYYRfݭݭݫ4<~6PYYPP   ; > > > > > > > > > > > > > > > > 3 3 PB?PYPYYZZR	Z1P<Y Yݬ<~PZZR1DRR   16RPP   / 7 7 7 7 7 7 7 7 7 7 7 7 7 7 / 1?PP?Z1P1լ1^ͼV Vݬ<~SPZZR1.WPWRxRRBfRRSޭRRURTSRSbeSRSUbUSURcbdЭRR1 WRxRRBRRSޭRRURTSRSbeSRSUbUSURcbdìЭWSxSSCfRbCRbX[PWQxQQޭRRSޭRRURTSRSbeSRSUbUSURcbdЭSARSbXPWWRR1X)|~~Vݬ<~PZZR1iRRSޭRRURTSRSbeSRSUbUSURcbdìȭޭRRSޭRRURTSRSbeSRSUbUSURcbdЭiRRSޭRRURTSRSbeSRSUbUSURcbdЭRѭR)Ѭ#?Z   P <  ~|~~Y3ݬ<~$1 Zͨ<RU͛RVЬ XUV<WWS SR<RRxRT S<SRxRRRTT?ݮ Tdݮ﬜ PSUݮSdVXSU~dSWO 0 ZPμ^[ݫ0<<RS1 ߭߭<~PSSRfݭݭݫ4<~2PSSPP   ; > > > > > > > > > > > > > > > > 3 3 P?PSPSSYYR	Y1OPFZ ƟZݬ<~PYYR1NR                                                                                                                                                                                                                                                   L                        n $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "              1RPP   / 2 2 2 2 2 2 2 2 2 2 2 2 2 2 / 1v?P
P?Y1PV ƟVݬ<~#PYYR1BR   1RPP   C S S S S S S S S S S S S S S 3 1a?P'P, f  fP, f  fP1.߭<~晴PYYR1XWPxWSCfRbX1 WX1 CfRRSޭRRURTSRSbeSRSUbUSURcbdЭRR1 լxWSCfRbCRb1AxWRBRRSޭRRURTSRSbeSRSUbUSURcbdxWSCfRbCRb1 xWQޭRRSޭRRURTSRSbeSRSUbUSURcbdЭSARSb1 PWլ1X=Y1PXWxWWޭRRSޭRRURTSRSbeSRSUbUSURcbdЭSGfRSbXWxWWެRRSޭRRURTSRSbeSRSUbUSURcbdЭSGRSbլ1RRSޭRRURTSRSbeSRSUbUSURcbdЭRR   1 jRRSޭRRURTSRSbeSRSUbUSURcb WQxQRBfSc7BRRSޭRRURTSRSbeSRSUbUSURcbd­WQRRSޭRRURTSRSbeSRSUbUSURcbdЭRWR>YN$ 0 !ݬ<~PYYR$|~~Vݬ<~PYYR0 tYP^lV ݦ4﴾ݦ4 h-PUURSPSSRRP<<RT߭߭<~﷔PTTRfݭݭWݦ4<~]-PTTPP   ; > > > > > > > > > > > > > > > > 3 3 P?PTPTTZZR	Z1P߭<~PZZR1߭m1ެQaRRSޭRRURTSRSbeSRSUbUSURcbdЭaޭRRSޭRRURTSRSbeSRSUbUSURcbdЭެX<hS SR<RRxRT S<SRxRRRTThެW<gS SR<RRxRT S<SRxRRRTTg,  ߭˞ Rb߭ߟbՔ?hb߬b?gb<RUޭɮRWЬYUW[<[XXS SR<RRxRT S<SRxRRRTT?ݮ7 Td[ PSUݮSdWYSU~dSXNG ZP ^ղR ݢ4ݢ4 *PSS\PPPPP x^R ݢ4ݢ4 *PTT\PPPP\P z&ݢ4 >PSS\P zNݢ4 PSS\P zݢ4 PSS\P zݢ4 PSS\PPP  ^?<~ϭPP  ^߭.\\ <~< ~P|~<  ~ ^IR<PS1 ߭߭<~ːPSSPfݭݭkݢ4<~q)PSSPP   ; > > > > > > > > > > > > > > > > 3 3 P?PSPSSP| ^ЬTTV<VUUQ QP<PPxPR Q<QPxPPPRR?ݬ ScVI PRTݬRcݬ RT~  RU?E P  ^լլPŬQxPPQ QP^[߭,߭,ZZRxRRRZRRRYRRYWެX  VWP@PoWQhPA	YaWQhTAPPZPHA
P`AP`ޭPPQޭPPSPRQPQ`cQPQS`SQSPa`bЭdWW|~~ݬݬ4  {P ^V, z  z ݬݦ4 PWWRy~z zݬϾЬU~S SR<RRxRT2SRʏ R<RRxRRRTTeS SR<RRxRT2SRʏ R<RRxRRRTTWWRSPSSPP| ^ЬV, f fPSWPS:PS5PSS	f*2SPP^n,    nR料ϩPSnTϕPSnUƽρPSnVﾽmPSS
߾ 3*SW1]P߭*X߭<~
PWWR15߭<~-PWWR1խѭЭܭí𵭤.ЭV2P2UPUTPVPSxURRSUSTTXݭ<RRQ߭RPWWR1<~-ЭV2P2UPUTPVPSxURRSUSTTX߭<~難PWWR1N<~QЭPЏ   R
RP
Q{RPQPQY*YV2P2UPUTVPSxURRSUSTTX߭<~PWWR1<~mQЭPЏ   R
RP
Q{RPQPQZ*ZV2P2UPUTVPSxURRSUSTTXWX1v߭<VV,  ߭V߭V߭V0íܭޭRRSޭRRURTSRSbeSRSUbUSURcbdЭԭޭRRSޭRRURTSRSbeSRSUbUSURcbdЭЭޭRRSޭRRURTSRSbeSRSUbUSURcbdЭ̭ޭRRSޭRRURTSRSbeSRSUbUSURcbdЭȭ߭🭴w Rb߭쟭b߭蟭b߭䟭b2~߭ Xݭ 	PWWPP  ^i?   ^gݬ                                      ^TЬݬ P|~ 6|~} PPdP`P` `	PP`(   Ğ< R  RĠޤ.ޮSPPRPQRP`PcQPQP딾 ޮSQQRQPRPQaQcPQPQ딾 ߤN  ޮSQQRQPRQaQcPQPQ딾 ߤN ĭ nnS QQRQPRPnQa QcPQPQ    P< (^{ET|SU
+-O/>4379ޭ;>4?|CKP~ \ rsd͈ߤ P͐|~\P  1D~ ͬ \ͮ |~ͬP  |~\1 |~ͬP  1 PP~PRP` PRRPPRP@|~|~+|~ P=	P  2QOP` PQAOѭ1nOPU|~ͬ|~\UPP ^ЬQaRRSRPSQRbaRQPRPRa  MRB  ^ERЬP`P   P    ^P ^RЬP`P   P    ^ЬQЬPa`
PQ\ PP< P ^ЬRЬP`bP  ^~<~$? PQPЬP`a
PP\ PPP ^~<~> PR ݬi PbݬR PP ^ЬVզ|B ݬݦ^(n~~< ~  PWWP^EBWXЬVզߧݦ P
ЬR(+ ݦ^(n~~<f~ﲥ  PXXRݬЬS~<c~I PXXPPl^AWXЬRբߧݢV PP,  7%ЬVݦŒ
m߭<f~OнЭRmЭosm%^(n~~<f~ߤ  PXXR1 ЬRݢﶒ l??w5R PXXR1 Э֭   ֭ݭ'Y ЭVfRRVV, f fRRRfݭX ЭVfRRVV, f fRRRfЬRR  TRTT!wݬ  PXRբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3Ʉ Ԣ3XPP^?WXЬRբߧݢr PP, U 7UxЬVݦސ ^(n~~<f~+  PXXR~ͣЬVݦ, ͌ ͌͌͐͒͌ͣVF  PXXR1lRX!Pݬ  PXݬ  URբ#
ݢ#Ԣ#բ'
ݢ'oԢ'բ3
ݢ3 Ԣ3XPP^>WXЬRբߧݢ2 PP, ͽ 7ͽ\ЬVݦ ^(n~~<f~  PXXR1ЬSݣYY+ Y~S  PXXR1wR
X1aPR	X1HPͨ1 <ͰR1 ЬV(ͪ(+%ԭ?߭~<f~T  ЭS1 2ͨ~5ݬݬ  ЭT |QФ"PЏ   R	RP	Q{RPQPQQV PtЭRQТ"PЏ   SSSPSQPQP{SPPQQx|~ЭRl5+< ~  ݭ%  B2ͨ~ͽݬݬڦ  |~ ͽ+ЬS~<c~(8 <J~  PXͽRբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3
 Ԣ3XPPH^W, ͽ 7ͽ,  7ЬSЬR
W1>PЬVݦ ^(n~~<f~c  PWWR1ЬVݦ6L, J J@JNPSX+JVg  PWWR1,P+~@~V  PWWR1p(ͪRW1Xͨ	W1FPR	W1.PR	W1PЬVݦ ^(n~~<f~;  PWWR1 ЬSݣͨTPTb 2T~S\  PWRRWPWR~WxͨXX a??X~h8K ;1 P`h^(n1^(nݬ  PWWR+ݬ  ͽRբ#
ݢ#9Ԣ#բ'
ݢ''Ԣ'բ3
ݢ3A~ Ԣ3Rբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3~ Ԣ3WPP^X,  7Ь߭߭<~<~  PWWR1 ЭRW1 #|~ЭRݬ  PWWR1 1 <R1 ЬV((#h~߭~<f~N  P2ЭR&ЬRb  ݭV  h~0Ph~ݬ#V;  ݬ#ݬ'  ֽЭRнRբ#
ݢ#Ԣ#բ'
ݢ'vԢ'բ3
ݢ3| Ԣ3WP ^W,  7/|~ݬݬM  PXXR1 1 <R1 ЬV"(#(/)gs}߭~"<f~jM  P2ЭR&ЬRb  ݭV  g}0Pg}ݬ/V  ݬ/ݬ  Rբ#
ݢ#`Ԣ#բ'
ݢ'NԢ'բ3
ݢ3h{ Ԣ3XP ^,  7gЬ߭߭<~<~U  PWWR1yЭR
W1c!|~ЭRݬ  PWWR1A1 <R1 ЬV((!ԭ?߭~<f~=M  3\|ЭS1 2~5ݬݬ  ЭT ~QФ"PЏ   RRPQP{RPQPQQTO PtЭRQТ"PЏ   SSSPSQPQP{SPPQQx|~ЭRl5!< ~  ݭF  ?2~ݬݬ@                                                                                                                                                                                                                                                     M                        & $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              J "           |~ !ЬS~<c~0 <J~8  PWWRֽЭRнRբ#
ݢ#YԢ#բ'
ݢ'GԢ'բ3
ݢ3ay Ԣ3WPP  ^,  7_
-|~ݬݬ$  PWWR1@1 <R1 ЬV (!(-'ԭ?߭~ <f~tK  jzЭS1 2~5ݬݬ  ЭT }QФ"PЏ   R
RP
Q{RPQPQQM PtЭRQТ"PЏ   SSSPSQPQP{SPPQQx|~ЭRl5-< ~  ݭ~  ?2~ݬݬx  |~ -ЬS~<c~. <J~p  PWRբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3w Ԣ3WPP ^RЬPՠݬ`~<~: PRPݬЬP`~<~: PRRP  ^Ь߭߭<~<~]  PfЭQa^< PWPPMЭP=ЭP"ЭPЭPPЭPݭݭ<~ݬ3  P ^1[WsRNZZԭЬYK P1 м߭߭<~<i~  P1 ЭR
W1բ1~ݩXX ЭR"X~'~B PWWR1~ЭRЬ#ЭR"1~!1wPW1YPмˏ   R1ЮWݩ ^(n~~<i~k  PWWR1ЬRݢBR߫- P1 	W1P, ͞ 7͞K	|~ݬ  PWWRD͞Rբ#
ݢ#	Ԣ#բ'
ݢ'	Ԣ'բ31Zݢ3t Ԣ31JPЬSSݬ  PW߫cy ͞Rբ#
ݢ#i	Ԣ#բ'
ݢ'W	Ԣ'բ31ݢ3nt Ԣ31߫2 P1W1ЬS~<c~+ <J~]  PWWR1, ͞ 7͞%|~ݬ  PWWRB͞Rբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ314ݢ3s Ԣ31$ЬSSݬ  PW߫cU ͞Rբ#
ݢ#EԢ#բ'
ݢ'3Ԣ'բ31ݢ3Js Ԣ31ЬSSj  ߭߭<~<c~A  ЭR~ XX ЭR"X~'~N? PWWR1JЭR"!ЭRЬ#AЮ߭߭<~<i~ｴ  PЭR
W1PW1PЭR<¥ R1 PЭR¥ ߭ЭR§ j_ ЭRբDЭS<å RҐW1P߽ЬSc =ЭR  ЭS<å R1mä TT" ݬSݭ<~ݬ  PW1FPT1<ë ë [ ߭ЭR« ] ߼߽] ЭRԢ
1PЭR1 1 <RRzЭRЭRЭRZWЭR"SSL~ʒ  P>ZXX ???X~ЭR'~r= PWWR1n1pW1ePЬR bݭݭݬR  PWWR"ЭRЭRЭRЭR111ЭRPP  S   1 ?PЭRЭR1ЬSc! =ЭR"   1 ЭRݭݭ<~ݬ  PWWR1ЭR1ЭRW1qPЭRZWЭR"SSL~j  P>ZXX ???X~ЭR'~< PWWR11ЭRW1 PֽЭRн2RN1 Z ݬݭݭ<~ݬ  PW1 ЭSä iä TT" ݬSݭ<~ݬ   PW1 PT;ë ë X ߭ЭR« UZ ߼߽ ЭRԢ
ЭS"?ЬTˏ~d~6 P   Tݭݭ<~ݬ`   PWWSOЭRIbES   3ЭS5c,!ЭR '*'.!ЭRbWP8^ٍXY[ԭ֨ЬR"ES~*~?SSZZR0.ЬR~ PRSRb*b?SSZPZ.ЬSc PTcRc RPTt0d9t1d9T޼RRTVVVVЬR« « HW ЬR§ L~§ -W P§ qW ЬSä RR,߭ë X ߼߽ ЭR
ЭRШЬTĤ RʏR:߭V ߭ݭ?X ЬScЭR3ЭR-"~߼r P1߭ R§ W ЬSSЬTT<~ݬ  PYYR#ç V ë V 1ZЬS<RRYЬR¤ 1ЭRbЬTTЬSSݬu  PYYRYĤ 11PZdЭSˏ~cЬS~3 P   >ä RʏR[+P߭ë V ߽߽A ЭRԢ
1PЬR¥ ¤ SSS1V߽߼ P1ЬTĤ SˏSR1S1 ߭ ߽ī ] P1 ЭRբ
1 Ѣ1 խ߭T ЭRТ
UU8߭ݭ+V ЬScЭR3ЭR-c+ 1 PUS߭ݭU cЭRDЭR>ca+ XP߭ЬR« U ߽߽	 ЭRԢ
-߭ī U ߽߽ ЭRЭ
ЭRШЬTĤ RʏRAխ߭S ߭ݭEU ޽ЭSЭRDЭSЭR>HխC">~߽q P-߽ЬScU =ЭR U ĥ 1P߭ЬR§ T 1PխZ1j[~ݬݬ  PY1TPЬS~<c~ JݭU ߭ݭV P1 Vݽ߭ Pݽ߭fWW<WR*Rd   ЭRԲ1 ߭ݽf<W~ݽV* |~ݽЬR« b[ P߭« S ݽ߽fЭRԢ
<W~ЭRݢ<
~w  ЬR#EЭR޲R(bЬR߭蟭<b~<  PݽЭR&fЭRТTRW߭ݭU P1Z[~ݬݬI   PYЬS"ЬRä å <å Rç S խ
߭R YP| ^U1 ެTdSç CW PRRVç qS ߭ç wT PPdSЭPˏ~`~/ P   dR§ W <¥ P¥ ߭ç 'T PЬTˏ~dЬS~. P   [<å RQç R ߭ç S ߽d| =ЭR | ç W <å R	å UUP^WЬS~<c~ PXPШ
RJY<RP ЬVݦ^(n~~<f~   PWWR1 ( P1 XRnѾ bnSS n: P   S	P   SSRz: PW5꟭<Y~  PWWR( P1xWPMRB 0x%02.2x from %s of StartupFileStructs ShmInitSLListBlock ShmInitSLList InitFileBitMap   ^5 PP ^ TﮄS z  P z  P {  P& PRQR BRi PG#ąRC Pċp߼DePUURߤR&. hЬRePUURߤ&R&. g@~ЬRvPUURϥRx gЬRPUURϊRJﻧ gߣL߭ PVP	   R< (PݣP ݣLS RRUURARd 9gЬRR  R  R  RR<  T~ B PHPRRܑRߤ6 fb ay  P8P ^x  PWŢWԢ wx  P x  P H L" DF  @n  P|(R P|~ߤVP6 Nf  ^r  ܥicǭ\cP (^YUTSޥ[ِېޭЬQQ<QPԠat:С:С./СGУ<PMߣ@DPxP~PdRPRPPdPB`RPRPУ<P% У<P%У<P)[У<PL߭چУ<P+QЭP<R	RP	Q{RPQPQWQЭP<RRRPRQPQP{RPPQQVVWߥh߭ ߭ PУ<P-XУ<PN`,H qJ   ^~<~H PPLP| ^%V ݷ PЬRբ7
Э77PЬRѢ77Pԭ߭? ߭ݦHP PЭP߭ݦHkK ,  ,ЭЭRЭP^5Z2[/<Rx3 YǶW   VUYkiPRR%߭RgP2T< S쟭TSݭfRePXXP߭RgPYY@   <SSTjʵ߭j:P;2 R쟭RSݭ$   jߵPXXP߭jPP ^߼5 PPPP1)ЬS<ú Ü $գУLP УDRм}Ì Ü *P#1 SP`4 ЬP< PЬSգУDRмУLPTSԣ1 Pì | wQУ"PЏ   R
RP
Q{RPQPQQ2 PtQУ"PЏ   RRRPRQPQP{RPPQQx2~ l < ~*  ߼3 ЬR<2º P^Z}YʩTԭޭ1ﴩӠ^Pߪv> k  xd߭d0P1UT3 SPi1 ߽3 P\\\\\dePVV\1 1 Э\<i̺ ЭRª   PXXPݭTޭndϳPWW\ݾ 3  ݾ 3  Ծ W\\\?߽cЭ\<u̺ ,߽2 Э\<~̺ 4R\lcЭ\<̺ dePVV\߭d(P1	O}]Pʒ    P  ^߼1   ^ x2 PP  ^߼1  ^R\Pߢv    ^R]P P }   ^]VzUWЬR¬ 9 Ү d  PWR     5ТP<J~k  1 < P1 ² Х<PHPް$P`PTT² &ư T.ЬSò QУ"PЏ   RRPQP{RPQPQQ|/ PtQУ"PЏ   RRRPRQPQP{RPPQQx S  PWTWPWWPPЬP&ƶ WPP ^딭  ݬ~ݬ~   8  PRRP ^딭 ݬPɏ   P~ݬ~   7  PRRP ^  ݬ~ݬ ~ 7  PRRP ^씭  ݬ~ݬ~   k7  PRRP ^xS<TЬR<Q@PQP
   PT
   PPPWWPЬP<R<VRUޭT߭<V~!xUPPP   RP`   RP`dRRWWPЭP֠P ^9xS<TЬR<Q@PQP
   PT
   PPPWWPЬP<R<VRUЬT߭<V~uwUPPP   RP`   RP`dRRWWPP                                                                                                                                                                                                                                                   N                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     9      8٢'+1sFɹ2 Ws7[{:|4g(E$e 09^ikf.џg%tv(h@ ǪO%~>7}yPA;m PxF2,U"M˦c냎C@wjpiqV^@dM ft5}T.{k
$1V7
lAiUiTNrs̴x$.*#	nXeb
JV娅lt.'2Q8%@n 'V	,m0ӽ=c`ls>§.3e%-+|Q8Q]Hy|@[
 %'OXgϧ
RA98(̵~
+sM">5~4x
 H;
"dω=SaōeU/g	jYt;.3yGutQg )R,%XW|YE!{<̢ԛOoSobSQ|lB?@DJ"7*7`dDc" _k:V膝W噓Q|?/]X'	pT-:MzQ'	MVwG<q)B2Yh<8&\cc$*]eJ)t_M%#e2|m{DyfчuO06n6c70>:g#|U[BĆi_v7I:]eG[2bx$5}
GiQ&@tyVLJu'
ild[NW f1tù̂"Ā{O-%Rsi6E{Z DzT.NE}z\PZ)q됧jU8>K3r2bBސao핂=3
y8f@ū;N)n40XG#QNn^zk,_\b	7:I
]z$inK6fo=.^
?w5(+=o=(hb#!W5@ʛhjD_F
,PIuX3bCqFnрJ*cU.OZ.1CR4rwwM.]GJϋ;ǊJ@v~iM41:~2Z\(0>KRLAsac]8^ƪꊚ錨 ~(ƕMP溼(
W a(^ =S5r:K]U1{g@D@ds9Ȕcu.!yWˎeToq \Rm 8]VU`_ۨ?4
)
,@0l<%'Ą%u'f_Q@4hGhz"ɵO@~ȃZL_fԆ+fkׁ Iԏ9BX/rhXz4
2+e;˪_o3 .4Y3׾fsw]Ca]Ʃ+vZ=wyAF5/YRX ^VoP,ilry;'M\\$LQsJ]/Z
nQ7s``v2B"glo8X5/*b7/IG,BIcȱ@P%;VMʖmiTZEpy)oWn?u堋^#n'5PwiŘFd3Ivd*YGC?
4=.גQQz,5kƢMmG:2ES,1Dh<c6Dc{r%i%Sͻ$G9i|)\[b7>1$~vƠy+C`"`,D1Nי7o9놊ɆNcFZWLڡw;z-&:?X/6_5PΉfGU";MhFX!~RTdɓK_HvcӲ 䐰mGS"j!eLgǍOfsd\H)kN ,zqDZ!Ie7]^T<6lsHpd4 漷Ac,jRXtkNdMR_FXU?
hm!	qUR3Uo%YHZ<u9B?TbwV=<y"ҹ}Pk!&<[q k\V7`vYEhڿO2\'9sN0dHCCG'32P <oH]JQIGůжRLo6vm~
RԭڋPKv(
*6wpi-,bFN#S+l~9;u-4klsy5\΍"tJ\C \+wZ<ib;ˢQF@P7r%l.5v'kKt0$]=,{728N-Dz;ЛXQ<&=8R6+^#i$""
[^aMdl' Z!^+
XqGiYh*|?-%@lrTq#$<++FBݙ܇L&'>ÅqfP+`U%lQ0#ajg؋kPw4IK=Bdnr~RÂx#
-LɁtg\F;
(rQƮ&H-s
Yg{$l#4n,/2BPL
ܟiŏ;6iX)yJޣCK	rmS<ŋʁʗ1;*lt	;mCOflfέ 288g,lmr
C#`!u
_x cnCl.sk8ϫjF5hu?3
BtD{f
ռU
l~grqI5	 ozŎ*OQejGtKl=gE
W'6!r04U,?g0ue")bMatQ,O?>b&9j
=5Mǌhr׷|&&j݂PT/ӱ,_롏f"").J^
7")Z@S^;NmйeJt,
Dϙ&w˧s|A.q)R|	5p/M\|tIsm\H?&4aF7Δޒ*M2)bfTpeveM/o`QFW`O1!T|[e-2G+A@CcY;6B8sJHzrOiQf$3_M(Mz8v7TWu	^?JFҀk^f4ي5?@xeεxsO\bA+cmtD[QKamjDuLJ=ް:X	ST(#0KIyIbLʡ0*g[ #uPߠ3~i<@V1
ә^iY[ع]ƕuH /}pamm4 p;eS tdp&DY+`e73<ocϽ⃸}m0JRj!)P>JX jfZ9g}>Xk|׻rةvɏ
F<YPSm~=5;/PTZvwfPRLѻ.94"&0nL3C
َBt"_geZÝ[h>mhO;E
ʙ":F/5#wQZi&13:DqıF OE@I(]-Kog+J~63.f
d~w@i<D_"xWv/zXy'4ScB0ybWcY[h~Z51BvZ(~؃7>.2Nc`%s|#5&`|U鿩ם`E{8a2RE^}ݝ QQ㭿BT>fC;+98(d~
$4bZujA?o	[;9幑u5I1M
ThIB~9} ';!hB
lҟH+a4%EzVnlw<6?}J2;Տy!Lf8-avznVfOqcjOkEL7gw0AQ͡<%$/):9ڄGFSK=g	]L:m$kiPޡi,J'ٗDwN`jC&$b
Zfa=҅cw6?IB?]m<|JE.$36 y~Y` 	6*z.P*75`:?VRS̗,)cC~`N[(F+rZaNpz3LA"_̒~U㰒hផg(ˢ;k*NY!ʓ1Ι}{[NP"h"(xeH~k0%eL)B*ܚޗĮ̞a^c7
QzUyjbz9GeS5~Fs%PP9^vJʀܛIc7D,@H4yt#QɐFyJN>O:wyO4
 aj2&||sy\[mpx"Q<A'w&:sbwt=
!6Z3Ϗ*mi覲cCTm}{&ဗ'6|Ƃ M?=k=Wx$nBOX`x&G^ΪQym
%餡tfe=1YSrwIJ?/9:#bEH@ޖuCO:X?/,4bqB̌iBWDgeqsBʦ$(b%*0n0^( FBF]*씔k%	f iE[XCf2˔
vcp5dc.(?X$EH?~sYG`ޕJS}.yKVQ%'y>@$r%ţ,w&z#ZiJ!{tbuZ>{_z39w,纽>qC#[&#;UBR-.־1B,Z!(Q"by|,C1
le~kR
ѵ*5	Nk(fm%n	|Ш{Ū%t%Fu9\NA`)y_AR]ao*$M3B&[\gjPu}[
eӔc%(F_YLkP0Dl?νvbP/_nA@hVq)p45%ml@5E'[B54|Mu$rLe^g  ]D1	7Խ%a 50
E6Be	-|/1C n0:d1wjUiLb4-O˅YZPNfBǇ$5ZG~̺:co9+nչ+!Ob,k,Ɲ9RGy@~
%"x-pʧl4S`΋UIVӪaLoNT(ޛJMu{d*]8%DU3:vc2M68-15#P
WtN]؝Mj&2>5pq_4B]pv'X͓z:?'֕'~%OQ)L#eRRߒCTU9v9FJor4YaX\.R$JJrt 8[#RL['?- DFuryq8qlwʎN=;D?B&%vRv*P49#n[|yfXV6'|̅'lvu\ZZy_a[L7vK6X߻2E'_X
MȨ
Is}2X^9v}oKJh0?^Y x'=9'26c7H^Tg*kց:~,Qd}XOzdoы|񴼶
0T$B==nV"x]mdv!껛i'$lsǿ@-ѝx.ջUN@Y~HP%Y^-kGOWEm*P?H&. SYfURtkR r5$iAJ^p)^j{ԊR.EhѷD,?OZe`2\:Ӯt0Џ'P2)~k Ndù!Fi
%R>ZGR5?N肍OFWzt^LkFnKMcy)eUL:0@ֵ
G\"JGlBBvNf.\-XͻDyC7CNf-F
.JcQ؋䌞
xy&uwY i/X	xznD"G^h5{kZOzi,@@'KA=JG˰/|m5" 6LTxɹϙi"d#QUXg8m?	FAaLVu	=d	f3<S/{KN
赠[V}ˈag.vB-] QfHS8(oAohm;;<
mC]jnk?4Q/G.4״_runl`t&V>\+Au:jo,8R!^*N5N7`LWSoѽWE]Г"ޕ pby&U1SҒÐ7*R>126pRZBbYOf`ДX8Zf9&!Q~dp5É#cC
}Q4r
(g6N'D,3W|w"И
6v;V}e,~I*8-E(Uw|lU%h6+KK#G0zhaP	mfMÚ	JLA/?}| ޤy{m !lžnG<?wQ^9FWokˆ{yQ9W
:٫J;6AiT}J\)}w%BU[EW4L<^K&}cH.\Q `D=8_Ҥ5:i`qz^@K=Aך@N)fZϡX1ge_e#_stޢj6Id5؏LP"ۓrUKRN;r8Z ^/D$?*'`Xg	R&x{K8舛~޲<h.q1"
p؊&j-nOגz<p]'9YH8L!EQ^W5VC7"Fg;ѵ,ziל5;F|E&Waf{n P'OXOtGlS	(j"S"vSCJ- +[D,}gӆTv;BPd䨭%-p2d֤!km`thA7áN@J-&zj$u".0ʕMl#ύzl;ueCrv¨'bjx.3_nLތ^}:QWkfϪLDk~z/u}H>w&~+cqު~搐#E3Z fĞ”V{TtSmt(cH'bg!g`U8uruo	 IrZQuŽ礲=MdLNZytD7
WpOal*Uu$pcJb/y#,w<'쇕ji-YNY&EQ ;3ːsxڑ	7eW~S3[5NͻZEDI>_#2T<f Q!Z	CYL@I>t38Km{g-Da?]{In#~HUFgʷsG!c}́#x                                                                                                                                                                                                                                                   O                        . $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              9 "           P ^욬PP   <  < 0F?P  ݬݬ~ݬ~ݬ	Q  PRRRP ^욬PP   D  D 8?P ݬݬPɏ   P~ݬ~ݬ	NQ  PRRRP ^씭횬PP   <  < 0?P  ݬݬ~ݬ~ݬ	P  PRRRP  ^ ݬݬ~ݬ ~ 	P  PP< ^YvS<TЬR<Q@PQP
   PT
   PPPUUPUP  ^ ݬݬ   PP<^]VﶙYuXZ<UЬT<S@RSR
   RU
   RRRZZR1߭ЬT<d~LPZZRЬR<S<dWSUޭT߭<W~uURRR
   Sb   SPbdSSZZR1,ЭRѢע1ЭRТ+1ЭRЭR(ЭR(ЭR [isVPߦv J  ߽+ PRRRRR)iVPƒ     W ЭR<º ЭRբ8ikVPƒ ﬘   ߽* ЭR<º 1Axϟ]( ЭRТDRЭϢЭRТLRЭЭR9ЭRТLR ЭRТLRЭЭR&
ЭRТDRЭϢЭR} ЭR¬ ЭRբ3ݢ3,  ЭRԢ3ЭPU*UШ<RТTE%8ЭSì .߭<~P ö E&Rb P
P 珞ЭRѢ6ЭRT*TШ<SУRD<+RSݭ"PZXSЭR Ш<R-  ЭR¬ 1² Ш<RHR޲0RbPЭR² &&P)' ߭ЭR~<~F$  PRѭ<u~Ɲ>Җ2S~[~Ӛ~ЬTT߭*  ЬR<S<dRT߭<R~qSRRRTЭRԢ+i,TPƒ m   խ߽( ЭR<º ZP0^]
[qZn<UЬT<S@RSR   RPU
   RRRRRRPլPЬR<S<VSUޭT߭<V~qURRR	   Sb   SPbdSSSRPЭRТ+Yɬ #ݬݬݬݢ3ɮ <~  P12nRRR"Ѭ"1Pì"RRn<R1 ЭV  Pզ7Э77XbPѦ7	7XRPԭ촭߭? ߭ݪHA PЭX(߭ݪH< ,  ,ЭЭRЭXXWЭR7W2nЬЬ$$   QЮPЪ8RRPQP{RPQPQŪ8QѮ   	< ЮRRî PЮ Ю( ݧ ݮɲ Ъ<RHR޲(RbPX1 ɲ &2X~#}PЬV(X$f2XSVSЬT2dRSRRd2XSSSɲ Ъ<RHR޲4RbP+ɲ &2X~$ɲ &2X~$ծ1XP$^i
[nZЬRbnլbPЬRТ+Yɬ #ݬݬݬݢ3ɮ <~t  P12nRRR"Ѭ"1Pì"RRn<R1 ЬV ; Pզ7Э77XbPѦ7	7XRPԭ߭? ߭ݪHC? PЭX(߭ݪH9 ,  ,ЭЭRЭXXWЬR7W2nЬЬ$   QЮPЪ8RRPQP{RPQPQŪ8QѮ   	< ЮRRî PЮ Ю( ݧ ݮɲ Ъ<RHR޲(RbPX1 ɲ &2X~!uPЬV(X$f2XSVSЬT2dRSRRd2XSSSɲ Ъ<RHR޲4RbPR<RRRɲ &RE!Pծ1XP^!XlV<SЬR<Q@PQP   PPS
   PPPWWPЬP<R<URTޭS߭<U~kTPPP   RP`   RP`cRRWWPЭPР+R² Ц<PHPް0P`P² &PI (^|[kZYެTdRkPB`1ЬSSRQRPЏ   R	RP	Q{RPQPQЬRâpQWx	RRSR+¼SSQSPЏ   RRPQP{RPQPQﮎdS<USTWSޭUͺͼͽT;̈́ͺs  PVVPR1P\PʹPRʹS
SRRRRkPB`Y1P߼  ЬU<ź ЬVQVPЪ8RRPQP{RPQPQSЬTx	pddRQRPЪ8R	RP	Q{RPQPSQ1Wx	﬍RdRVR+dVRRQRPЏ   RRPQP{RPQPQrެScRkPB`1 VQVPЏ   R
RP
Q{RPQPQåpQWcS<USTWSޭUuwxTy?uq  PPPR0PPoPRoS
SRRR)RkPB`Y߼ ЬR<4º 1J   XЬPlݭ< ~  PYYPP   %PkQ@aXWXWYU1 U   1 ެTdRkPB`ЬS& ЬR<b~OL <  ~߭ǚd~<b~/߭Uc~3߭ǚv~#U   6YSP` ЬR<º /P߼ ЬR<º ߼ ЬR<º YPP^gY<UЬT<S@RSR	   RU
   RRRRRRPլPЬR<S<VSUޭT߭<V~fURRR
   Sb   SPbdSSSRRPЭRТ+WǬ PЧ"nЭR!RRPЭR 'PЭRǜ 2RRЮRQRPЩ8R
RP
Q{RPQPQSx	pЭRQRPЩ8RRPQP{RPQPSQ&߭ݮWЭR~ݬPPR1q1 ѧ"1_Ю"<R1 ЭV  Pզ7Э77X`Ѧ7	7XRPԭ购߭? ߭ݩH7 PЭX(߭ݩH1 ,  ,ЭЭRЭXXSЭR7SЬ(| ݣ ݣ(ǲ Щ<RHR޲,RbPR<RRR1ǲ &2R~1u<R1 ЭX  Pը7Э77Z_Ѩ7	7ZRPԭഭ߭? ߭ݩH6 PЭZ(߭ݩH0 ,  ,ЭЭRЭZZVЭR7V2Ь[Ь$   Q[PЩ8R	RP	Q{RPQPQũ8QѮ   	< Ю[RR[ Ю [(ݦ [ǲ Щ<RHR޲,RbPU"Iǲ &2U~,P2URR$ЬT<dS2URSRRd2URR[2URR1?Ѯ"Ю"n"wЧLRnQЧ"PЏ   R	RP	Q{RPQPQQ PtQЧ"PЏ   RRRPRQPQP{RPPQQxl< ~B   P8^ecYլPЬRТ+XȬ PШ"nЬR!RRPЬR 'PЬTȜ 2RRЮRQRPЩ8R
RP
Q{RPQPQSx	pЭRQRPЩ8RRPQP{RPQPSQ"߭ݮX~ݬPPR1]1 Ѩ"1KЮ"<R1 ЬV - Pզ7Э77W`Ѧ7	7WRPԭ߭? ߭ݩH73 PЭW(߭ݩH- ,  ,ЭЭRЭWWSЬR7SЬ(| ݣ ݣ(Ȳ Щ<RHR޲,RbPR<RRR11xP<R1 ЬW \ Pէ7Э77[_ѧ7	7[RPԭ购߭? ߭ݩHg2 PЭ[(߭ݩH, ,  ,ЭЭRЭ[[VЬR7V2ЬZЬ$   QZPЩ8R	RP	Q{RPQPQũ8QѮ   	< ЮZRRZ Ю Z(ݦ ZȲ Щ<RHR޲,RbPU"IȲ &2U~,P2URR$ЬT<dS2URSRRd2URRZ2URR1?Ѯ"Ю"n"wШLRnQШ"PЏ   R	RP	Q{RPQPQQD PtQШ"PЏ   RRRPRQPQP{RPPQQxl< ~   Pΰ^ЬXݨLެZjQP1 |VԭXͲ ͽݨL ͷ^(n~~<h~Q^  PYYRP߭ݬЬRRPݭ<b~Ё  VPWPV~ 2~ݬͲB  PYYRYWP~ 2 ~  XB  PP ^^SW<TЬR<Q@PQP   PPT
   PPPWWPЬP<R<VRUޭT߭<V~]UPPP   RP`   RP`dRRWWPЭPР+PР" WP^]T<SЬR<Q@PQP   PPS
   PPPUUP1<SЬR<Q@PQP	   PS
   PPPUUP1hЬP<R<WRVޭS߭<W~\VPPP
   R`   RP`cRRUUP1
ЬP<R<WRVޭS߭<W~\VPPP   RP`   RP`cRRUUP1 ЭPР+RЬP`YԠ SѬ"1 ì"XX   < XX<XQQQYüYPPSݬ?ݬݬOPUUPDݬ?ݬݬOPUUP ЬQ<PPa<QQQS1eUUPP ^[SW<TЬR<Q@PQP   PPT
   PPPWWP1 ЬP<R<VRUޭT߭<V~'[UPPP
   R`   RP`dRRWWP-ЭP&ЭPР+RТDPТDP xWPP^[YԼ߭<~ZխTЭVެWgRX@:UP fRТSЬTdgeSVXX@ДZZPP ^ZVW<TЬR<Q@PQP   SPT
   SSSWWPЬP<R<URTޭS߭<U~YTPPP   RP`   RP`cRRWWPЭPР+SSP` <Wú ò Ц<PHPް0RbQУ"PЏ   RRPQP{RPQPQQ PtQУ"PЏ   RRRPRQPQP{RPPQQx Ì l5< ~  SP` <f   WP^5YYЬSS~  RݬSPZZPԼ߭<~XխSЭWX@DެVU)gR$fSТS TdfeSWXX@ǔZZP^XWЬR<S@RSRPЬR<S<VSUޭT߭<V~WURRR   SPb   SPbdSSXXRPЬVЭR
fЭR(ЭR( P0^OW,  7%ЬRbЬRբݢ PЬVЬR(,  X15PЬVݦ"D ^(n~~<f~oV  PXXR1ЬRݢFD7 Pyq" PЬV(,  X1P
 P;q PxЬS~<c~:  P` PX1IPЬS~<c~  <J~  PXXR1ЬV(,  X1P1 ݬ￉  PXXR#ЬV(,  ЬR1 b1 R1 RTѤ	F
?Ѥ175/ЬRS<bVSUU~<V~  PSPLSS3Ѥp) 72ͮ~T                                                                                                                                                                                                                                                   P                        V $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              @ "           1ЬS~<c~nPXͮЬV(1,  ЬV((1XRբ#
ݢ#MԢ#բ'
ݢ';Ԣ'բ3
ݢ3U5 Ԣ3XPP^
UV߭<~TX@1   WPЭPm`Rݬ PWQ<TQSS~<T~gPULUЬPQ<`TQSS~<T~gPQLQUQ
ݬZXX@1{P ^W ЬVݦ^(n~~<f~KS  PWWR)ݬЬS~<c~  <J~t  PWWRWPP  ^ݬݬ~<~  <J   ~@  PP  ^P  ^P| ^VЬS ݬPTTRP(
cQw5Pߦvw   ԭ߭~ЬS~<c~:  PR
w65Pƒ ww   RPP <^yV
S\
߭  Wg߭g   Ь<R5߭^(n  Q   Ь<R;߭^(n  Q   PPh2 PR-RgR R2 < ~<2 PS>j PSg]~SF PRS\2 PLR TdTR S P̐ΐS|~|~|~|~	 Z PSd]~SΊ hPdS PĐƐS ?|~  S1 P^|Y[мS	Z1 PT<Ræ SRnnXTޮTޭޮVSUiPSݮS{PUURIоRbn7RR   *SPUURݮS9PUURPUURRR[ЭR֢ЭSмW֧Z1 ~o0 PW
Y1ZPW, g  gЬV(7f5, f 7fǲ 
ݬe g PYYR1ЬRЮRQЭPЏ@   RRRPRQPQP{RPPQQ|PY1 WPPYYR1 [ѧ%Ǣ ǜ ~<~  P[fǦ Ǧ PYYRMK/ P	Y6PЭRЭRЭRݭǦ PYYRЬRբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3"/ Ԣ3YPP ^լRkݬﮅݬݬPRRPKмQa8PP   +ݬ﹅PRRPݬݬ؅PRRPPRRPP ^ЬPnnR QЭPЏ@   RRRPRQPQP{RPPQQz(PTTPWTӄR<SR~<S~  PQPLQQVݬTPUUPcЬQмPѡ)"РPVLPP   4мP)TPUUPݬTPUUPPUUPԼWT>UPP^VpWMUPg.PߦvIq v  ԼЬRnnR QЭPRRRPRQPQP{RPPQQQYQЭPRRPQP{RPQPQRQRPХPRRRPRQPQP{RPPQQXYRRRLXP`PxRPPʏPPZZPP  5  U 1 P?P ݬ~ݬ<~  cP ݬ~ݬ<~CP ЬSSTTݬ<RRnc STݬR  PռRмP` PP5мR<º g}-Pƒ o    , 1MмR<º < ^MKTԼЬRnnR QЭPRRRPRQPQ{RPPQQQUQЭPRRPQP{RPQPQRQRPФPRRRPRQPQP{RPPQQSUPPPLSRbRxPRRʏRRPP  ,  @Z?PPݬ~ݬ<~^   Pݬ~ݬ<~7PЬSS~ݬ<RRcS~ݬR   ռPP ^vUePWeҀQ<TQRR~<T~  PQPLQQVݬePSSPcЬQмPѡ)"РPVLPP   4мP)ePSSPݬe＀PSSPPSSPԼWe:SPP ^ЬP ެScR¦ ߭¦ `P5У Rݭ") ԭ¦ P߭cP +PެScR¦ ¦ 2P  R¦ P R¦ ¦  ^ЬR® PZ`P*ՠ(ݠ(( Ү RԢ(ЬRҮ u( Ү ЬR® Rբ
 ЬR® J( ® ЬR5Rբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3( Ԣ3ЬRb  !:  R' Ԭ ^=t&PSSPЬRbYbbSPP4^mGWмTP<RĦ SRޮYPޮRޭޮXSUgS~ݮS~PUUPIоP`6PP   )S ~PUUPݮS@~PUUPPUUVVP1ЭRעЭRբ#Ħ 4~PVݭ& ԭVP1|פ14ЬRЮRQЭPЏ@   RRRPRQPQ{RPPQQrTP}TTԼ1Pr<tTrzPVVP1ЬRЮRQЭPRRRPRQPQP{RPPQQQQЭPRRPQP{RPQPQRQRPЧPRRRPRQPQP{RPPQQ[PPPL[RbRxPRRʏRRRRRR1ЬRޮSЮRQЭPRRRPRQPQ{RPPQQQQЭPRRPQP{RPQPQRQRPЧPRRRPRQPQP{RPPQQZQRʏRxQRRRcLZScPxQRRRRRPPPRcLZP`@P   ,{߭Ħ {PVVPЭPĦ J{PҔVVP ^޼Rb/ ߭~ݬ<~PUUPU1 PЭbЭPՠU1 PS<QЭP RQnnWSޮSޭޮVRTiPRkzݮRzPTTPIоP`n7PP   *RyzPTTPݮRzPTTPPTTUUPЭQЭPѡUPUUPQPQQP2PPP| ^BR߭<~nBЭST@SV
PSTT@T@PcWT@PPPݢDX  PUŏc   U~<~ PQPSVQcQUPSc   QQcUcTP ^5BRSբ@#SPP``<~[ SS@ ^ARЬP<Q@PQPPЬPPPP ^ЬRbPP3 bbbbbQQPP
QbbPQbb^YxAZƴ"Ԯ$ԭԭԭԭJЬRb1Ԯ$Т[߭<~=PDѮDK1ЬR((kd"Pߩv1e ^  "@ЬR6 ߭~ЬS<c~PKPR ݮH<c~/  1
˩ RaТTΈ ވ RR1 T
ވ ވ Tވ ވ 1 ވ SSRRSވ ވ vPSވ ވ fPЭRТLRYТT΄ ބ RRFT
ބ ބ Tބ ބ )Pބ SSRRSބ ބ PSބ ބ ߭ЬRݢ,1, X 7X{[߭<~PDѮD
K1PЬRբpݢqx PK ݮH<~.  1PͦЬWݧ+ ͦ^(n~~<g~+>  PKPR ݮH<g~3.  1h߭ЬRݢ+?ЬR7 ߭ЬSS@r  PKPR ݮH<c~-  1, ͏ ͏͏RR͏RR͏͓͕͏߭ЬSSq  PKPR ݮH<c~u-  1PCK ݮH<~V-  1PЬW((ЬR5߭~<g~5PKPRK ݮH<g~ -  15@ԭ?߭~ЬT<d~o"ЭSM'G;<˅ R4?/?AajPɒ a ط  "1rPoV.ê K ݮH<d~g,  1Į@ЭRТLVK ݮH<~9,  1nPK ݮH<~,  1KPK ݮH<~+  1'P "RRK ݮH<~+  1PЦ$ЦT΀ ހ RRGT
ހ ހ Tހ ހ *Pހ SSRRSހ ހ PSހ ހ @1ЭRCCSˏSRR1 ʏSS<SˏSRRʏSS1SSʏSS 1SˏSRʏSS1CRʏRR SˏSRRʏSS1CSˏSRRIʏSS SˏSRRʏSS1jSˏSRʏSS1MCSˏSRRʏSSRʏRR1 CRʏRRRʏRR1 RʏR1 CRR1 RR1 ЬRU<bSЭR¦ TShޮhVU|ޮ|SޭΌ Ό UTXmPT?qΌ TqPXXRLތ Rbh|8|RR   +TJqPXXRΌ TiqPXXRPXXRRRЭSЭRѣK ݮH<~)  1;PЬUT*TЪ<RТSD%1ЭR¶ DRbRݢN1P'Pq]K ݮH<e~(  1PdޭخxԾxdSˏSRRRxS	 xPxdSSSxP0xPS x
Pȏ@   xЭS\TRPˏSRR@   4ˏSRR0'ˏSRR !ˏSRR
ˏSRRTPTT%ɝ\K ݮH<~'  1P ݭЬT~<d~ݭ ЭR¶ S*SЪ<RТRC&Rbo P&Pm\K ݮH<d~I'  1~Pݭ˒ ~~ЬS~<c~߭iPKPR ݮH<c~'  16P[Pɒ [   "1Pխ11k  P1:[cPɒ [ ѱ  "߭ЬS<c~ݬ ЬRݢ
[?S艹  PKPR ݮH<c~I&  1~PЬTS*SЪ<RТRC%1߭ԞCRbRݢNk.P%P[K ݮH<d~%  1!`ޭخtԾt`SˏSRRRtS	 tPt`SSStP0tPS t
Pȏ@   tЭSZTRPˏSRR@   4ˏSRR0'ˏSRR !ˏSRR
ˏSRRTPTT%8ZK ݮH<~$  1.P ݭЬT~<d~ݭ ݭԚS*SЪ<RТRC&Rbm P'P}YK ݮH<d~$  1PYPߩvY ﲯ  "ЬV(k(ݭ˒ ~~~<f~߭PKPR ݮH<f~$  1PЭRЭ¶ VTЮTRTQPRRRPRQPQ{RPPQQQ*QPR
RP
Q{RPQPQRQRPЪPRRRPRQPQP{RPPQQ*SSSLRbRxSRRʏRR)RRR*)R*RxRRR)*RxRRR)LS)c߽  ЭR<º WPɒ X 2  "߭䟫]&  P(15                                                                                                                                                                                                                                                   Q                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              y "           P߭䟫]  P(<˅ RT=J(RDЬRS*SЪ<RТRC%+<ˇ R	$$K ݮH<~n"  1PЬUT*TЪ<RТSD%1(R1߭ԞDRbRݢNk+P$Pɧ+WK ݮH<e~"  1<\ޭخpԾp\SˏSRRRpS	 pPp\SSSpP0pPS p
Pȏ@   pЭS2VTRPˏSRR@   4ˏSRR0'ˏSRR !ˏSRR
ˏSRRTPTT%:VK ݮH<~!  1JP ݭЬT~<d~ݭ ݭԚS*SЪ<RТRC&Rb7i P'PUK ݮH<d~   1
Pݭ˒ ~~ЬS~<c~߭PKPR ݮH<c~m   1
PЭRЭ¶ VPЮPRP;Q;PRRRPRQPQ{RPPQQQQ;PR
RP
Q{RPQPQRQRPЪPRRRPRQPQP{RPPQQSSSLRbRxSRRʏRR+RRR*+RRxRRR+RxRRR+LS+c߽d  ЭR<[º SPɒ UT   "(RmЭR P® ЭR® K1ЭR® R, b b߭^(knݬ  PKPR1QЭRЭRЭҮ &ݬ ݮ(?^(knݬ  PKPR1(R1RRUЭSݭ  亂  SЪ<RHR޲ RbPò 1ЭR² &B² rK1PЭSݭ ş  O  SЪ<RHR޲ RbPò 1gЭR² &G² K1^P߭䟫]#  P(ЬUT*TЪ<RТSD%1(R1ЭR¶ DRbRݢNk&P&PLRK ݮH<e~q  1PXޭخlԾlXSˏSRRRlS	 lPlXSSSlP0lPS l
Pȏ@   lЭSQTRPˏSRR@   4ˏSRR0'ˏSRR !ˏSRR
ˏSRRTPTT%xQK ݮH<~}  1P ݭЬT~<d~ݭ ЭR¶ S*SЪ<RТRC&Rbd P&Pɽ=QK ݮH<d~  1NPݭ˒ ~~ЬS~<c~߭9PKPR ݮH<c~  1PΘ ͽΘ Rͼޘ ͺQͺPЏ@   RRRPRQPQP{RPPQQXXePRRlZݭRaPKPR ݮH<~C  1xЭR XzcPKPR ݮH<~  1FPVPVΔ ͹Δ R͸ޔ ͶQͶPRRRPRQPQ{RPPQQQ͵QͶPR	RP	Q{RPQPQRQRPЪPRRRPRQPQP{RPPQQК͵SSSLRbRxSRRʏRRRRRR1 ΐ LޮLSʹΐ Rͳސ ͱQͱPRRRPRQPQP{RPPQQQQͱPR
RP
Q{RPQPQRQRPЪPRRRPRQPQP{RPPQQTLRʏRxTRRRcLUeSxTRRRRRSSSReLSLcMPɒ ]N   "ЭSˏ~Tˏ~$RTR1 ò 1ò Ъ<RHR޲0RbPЭR² &PTЬRS*SЪ<RТRC%լ TT~ݮ(ЭR< ~=  PKЭRЮ$VpЭRƢ ЭR( ]lЭS(ì ЭRЭ"ЭR}ˉ  ЭRЮ$ЭTЬRS<bVSUU~<V~  PS	ЭRLSS߭ЭR&a ,  c ЭRЭ+ЬTdЭRЭRЭUS<dVSTT~<V~﬿  PS
PЭRLSS
ЭRЬVЭRЭR(ЭR(ЭRЭR!ЭRЭآ"ЭRԢ/ЭRfЭTDЭTЭRТLRТ'ЭRԢ3ЭRSKЭSì kЭR3Ӯ ʥ  PKPR ЭRҮ d  ~P6ЭR"ˉ ݢDV.  PЭS"ЭRݢ3î <~y  ЭR&ЬSc`  ݭݬ,  ЭR t` K1 PѮD ݮH<~r  "&JPߩvbK   "ЭR² 1² Ъ<RHR޲$RbPЭR² &P8ЭR²  ߭TTЬS<c~KPRT~S߭VKRPJ߭ЬS<c~ݭ ЭR¶ S*SЪ<RТRC&Rb] P
PG}J"#IPɒ \J   խ߽  ЭR<º ˒ Rբ#
ݢ#Ԣ#բ'
ݢ'КԢ'բ3
ݢ3 Ԣ3K P^Y%WԮ[ԭЬ RbԢ	ЬRբɀݢk^ PP, ͭ 7ͭЬVݦ߭<f~]Ь Sн
ЭRЭ
^(n~~<f~#  PZZR1ЬRݢB.!,  
ݬW  PZZR1yZ1R
Z1PЬV((Ь R&~<f~HPZZRZ1N<͠R1͠?߭~ЬS<c~խEGPɒ G &  5-
[	[1PZ1Ь RЭ	ЭT 1:߭~~<c~9PZ߽  ЭR<|º 1{PЭR² 1 ² Ч<RHR޲$RbP5ЭR² &ɁPMZ߽t  ЭR<º 1PЭS|~    SЧ<RHR޲ RbPò 5ЭR² &ɋ² Z߽  ЭR<º 1߭<~!X@HЭR/bSЭRѣ+R"¬ գ3
ݣ3  ԣ3ЭRԣ+X<XRR@ݭЭRԢЭRЮRQPЏ@   RRRPRQPQ{RPPQQCNZPYPZZR߽  ЭR<º 1PNOݭMVPZZR߽  ЭR<º 1P1 PĲ 1 Ĳ Ч<RHR޲$RbPTT6ЭR² &ɔTNZ߽u  ЭR<º 1PЭS|~    SЧ<RHR޲ RbPò MЭR² &ɞ² ЭR² &ɧTZ߽  ЭR<º 1ЭR¬ Q Ү ͝  2ޭLWPPRݾݾԾЬ RԢ	7PͬRR10 ?? !n  Z&yCPɒ C   ͤxͤ  ͭͭ#  ͭVfRRVVͼݭRRRݭ, f ff   ͱͱ  ͱVfRRVVݱRRRݱ, f ffЬЬ(͚|, x  xЮ|ЬUT*TЧ<SУRDTdI x|P xxRRRRbЧ<S<R	PzOzEPd xxRRRR,T*TЧ<RТSDR<bR	PzDRbz1ЭRI DTЬRS*SЧ<RТRC%$TT~ݬЭR< ~{  PZЭRЬЭR Ԣ"ЭR¬  xЭRlV Ь R
<~ݬ  PZZR 1 ߽  ЭR<º 1 ЭRX5Rբ#
ݢ#CԢ#բ'
ݢ'1Ԣ'բ3
ݢ3K  Ԣ37ͭЭR5V , ͭ 7ͭRR
RR2$~ݬ ݬ"~ݬ~ݬ*PZ#p@Pɒ @   ͭRբ#
ݢ#Ԣ#բ'
ݢ'mԢ'բ3
ݢ3  Ԣ3ZP ^Ɵ($  PRRPPy?PѭPPѭ
ЬPP^KZWЬV~<f~Ҳ  Jԭ,  զʱݦT PP, ͋ 7͋ͮ׏ЬVݦ}ݦ ^(n~~<f~X  P[[R1$  P[[R1ݬXN  P[[R1`͢R[1K͢R	[16P(x? ЬV(ޭ(ص+<~ њ~<f~MP[[R	[1PЧ<RA[ERЬRRTRSS~<T~$  PVLV|T~<U~
  PSPLSVS m1?߭~<~ЭS1GУLRBSRbB  ЭR<º a=Pʒ =   [1_ЭRª >b  ЭR<º =APʒ = ﯓ  [1PЭRª 11ЭR¦ O߭ЭR¦ RPP1 ]  T<UЭS߭<U~gX@8PЭR!bRѢ+Sբ3	ݢ3dԢ3Ԣ+ЭRXX@ЭR¦ OP߭ЭR¦ OPЭRݬ?  ЭRЮRQPЏ@   RRRPRQPQ{RPPQQDQP{OP[߽~  ЭR<º ;Pʒ < 4  ݭϰݭvݭ [RЭR<º <~^(n~<~ϦP[1N߭~њ~<~7PGЭRª ߽  ЭR<º :Pʒ V;   [1߭ЬS<c~x  ЭRТDRЭRТLRЭ߭<c~AY@`ЭRKbTѤ+A<ЭRТLR ЭRТLRЭ&ЭRТDRЭR} PYY@:+Pʒ l:   ЭSì 1 H߭<~Y@1ЭRbRѢ+բ3
ݢ3J  Ԣ3YY@ ЭRҮ B  P1 ݭq   ЭR  5ТR<J~@o  1 ò Ч<RHR޲$RbPЭR² &ʲPЭR² ЭTQФ"PЏ   RRPQP{RPQPQQT  PtЭRQТ"PЏ   SSSPSQPQP{SPPQQx ݭs  ЭR 1߭<~JY@1PЭRbRѢ+
Ԣ+ЭRYY@1 ͢R.[,8UP1 ʒ 8   1 <~Rq
Ѯ*7Pʒ V8   [1 7Pʒ ,8 Y  ~  1P7Pʒ 7 !  <~^(n~<~ϿP[[Rݬ:  ЭR1N< R1 7Pߪv7 ﵍   ߭~ެS< ~1ЭRТYYm~њ~c߭{YYKP ߭~< ~ޭ^?GJPPRݾ|ݾ&Ծa6Pxʒ 6   dP:6Pߪv6 Ҍ  ߽  ЭR<º ЭRª 5$Pʒ e6     ͋Rբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3  Ԣ3[PP^![V;ЬRJ PX                                                                                                                                                                                                                                                   R                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              y "           X˸J ;I PXެWg  gl  PZYZWPXg  PVVRV=ݬ<~v  PVVR&^(n^(n~<~YYZVP  ^߭<~QQQPaPa P  ^߭<~MPPP    ^S߭<~T@<ЭP&`RѢ+բ3
ݢ3Ҏ  Ԣ3Ԣ+ЭRTT@ ^5RߢL߭OG PSSP< (PݢP ݢLI P< ^SЬRbQЭPRRRPRQPQP{RPPQQQTQЭPRRPQP{RPQPQRQRPУPRRRPRQPQP{RPPQQUTPPPL UR  RxPRRʏRRP ^AUЬRbQЭPRRRPRQPQP{RPPQQQWQЭPRRPQP{RPQPQRQRPХPRRRPRQPQP{RPPQQVWQRʏRxQRRRLVScPxQRRRRRPPPRcLVP   | ^qSЬRbQЭPRRRPRQPQP{RPPQQQUQЭPRRPQP{RPQPQRQRPУPRRRPRQPQP{RPPQQVUPPPLVRbRxPRRʏRRTTRRTRURxRRRTPURxRRRTLVPT (^):V
XЬTdЭYQYPRRRPRQPQ{RPPQQQQYPRRPQP{RPQPQRQRPШPRRRPRQPQP{RPPQQήSLЮRxSRRʏRRRRR1xPZQYPZRRRPRQPQP{RPPQQ[UWTRbQЭPЏ@   RRRPRQPQ{RPPQQ8lEPSS8CPTSC߭SCPmЭPQЭPZRRRPRQPQ{RPPQ[QUUPPTSBSBP߭SCPTSBfBPSfB߭fBPuPЭPQЭPZRRRPRQPQ{RPPQ[QUP
WWPPSf8BfVBP߭fzBPSfBLP`STxTRRRRRSSSR`URLScPxTRRPcPWR)LScPxTRRPcxRRRRRR ^ЬP`QЭPЏ@   RRRPRQPQP{RPPQQPP  ^< P  ^P  ^< P ^R º Џ   ~ݏ        ^mR  <P ~<_ ~2    ^ER        ^!R Џ   ~    ^R < ~< ~]    ^ѤR ,,Џ   ~2    ^磻R E< ~< ~< ~Џ   ~    ^uUЬVЬRRB PT]TA PVЬPVPPVVPR[-2PЬPVPPVVPRņ,VRŴ,ЬSJQVPSRRRPRQPQP{RPPQQWWSPPVTVSݬ,TVݬw,VPP ^ЬRbQˏQPPPbPQ bbPPP	P0PP 
Pȏ@   P  ^+PЬQˏQPP@   3ˏQPP0&ˏQPP ˏQPPʏQQPP ^｢S&i@ PRRR? BR:@ PGg+*$PÅR@ PË@+*PPθ^GSVX߭ݬ`խ +PЭUWզ@1 ? TP1 eR1 XddX͸͸!~   ݢ"͸ݢ'ݢݢX`d~ݬPYYPádëdݬnPYYPûd
PddUWW@14X	*  ^QQЬP֬r`QЬP֬+`ЬP֬w`Q ЬP֬+`ЬP֬d`ЬP֬r`Q ЬP֬+`ЬP֬d`ЬP֬w`QЬP֬+`ЬP֬c`QЬP֬+`ЬP֬s`Q ЬP֬+`ЬP֬n`ЬP֬c` | ^VBTo1USf	 	= Pff= fRRRe=Pr   PS?RSS 	fP= PV	f?=  08   PPw	f= fRRs= Rn= 	R< 2 P< ^%UzTSe9= eЬRR:߭RK;PRx0
Į	e< PѬ^0	e< ݬ	ex< ݭ2   Sݬ:P߭ݬ:P Q:SP| 4^iUﾞS ΐАޭ֭en< eЬTT	e; Vfd
ef~<~<
~<~<	~<~<~~/
e
f~Ì
efݤâ
efݤø
ef~
efݤ
ef~
ef< ~efݤ"&ef&<efPef Č ?w9 2RBݭmef Ĕ ?P9 2RBݭÁef2Ĝ ~ÕefĞ éefĢ ÿefefĦ 1 Ħ 8߭Ħ 59P
efsP<~e: RbЭP~ebЭPݠebЭP~2ebЬP 8PHe2: 	JefЬR2ª ~Se: Td2¬ ~ged® }ed² ÓedéedMRB   ^QPЬРQ!  ^4WV~<~F  PX	V1PШ
RJYլｨݬ9 P+(լ 1Uݬ X~<~2  PV18ЬSS[c/ݬXXPcb[([TTUZPdd/TPdZPde.eg1 SPSSRR2ݬXWP	P   V1ݬݬ<Y~8H  SRBeRR.RgRV1xZ1%լ 1ݬ ݬX~<~F  PVVR1G1 U8 P1  ??߭U  PVVR1Z ݬ ߭ݬ<Y~~<~ٜ  PV߭ݬ<Y~I  PVVR1 cRNpU   PcݬUݬ:  PVVR
V1 PZ0լ +ݬ ݬ ~<~T  PVVRX
PVNPZ/dTTU1=<R6?RfPVVR"ЬSRc59VVP ^ЬRR67 PT.R$7 PS~R7 PSS0TPP`0`9P`0
p1`9PPSRs0c9SPc0SS
c1c9PìRPPPTPPPRPP^ЬWǡ Xǩ YЬV, f ;fЬR,(-(g3Щˏ~ fﱦ  ]  P1XSǉ UTգ
U
5 PУdRPRЬTЩЩ$Щ(    P< ^UХR!ХR!STPxTP@P`xTQARb
AP`TT<ccS ^ЬSЬPР
ݬ  P/ЬRЬT
Sբ
T
4 P
ТcPPЬPЬTЬTФФ&Ф*Ф"   P| ^VЬTԤЬU
e
ݬ  
  v  ԤnnUޮTЦR!GЦP!  RSPxSP@P`+xSP@Qa @P`SS<bbRЬR|&"   P^ЬVЦLYЦDXЬW(
.ЩЦ"
ЩЩ&Щ*Щ"P< ^ЬPРSРTJ	ЬPЬP
Pʏ	ʏPЬUˏURЬQˏUPЬQUЬQˏUPЬQU
ЬPU
ЬP$
U
ЬP(U
ЬP  ^ЬRբ
ݬ
#2 P	ТPPP ^ЬPРDQ} 
РDRР"   < ^]UХR!4<~   P!ХR!<~ ХR!1  R!STPxTQAP`
APм`xTQAP`APм`APЬ`TT<c$<~   Pc<~ cl1 cSP  ^ЬPԭ	`ݬ MRB          ^mP  ^WZ ޭЭЬS~<c~Ɏ  PV߭߭<J~m  PXXgX  Z1PM1 ߭<~,  нԭ|~8<J~	  PXXߧXﮍ  Z1ЭSS%ѭܭíحYYRRCY=ԭ7PS  ԭ&PS  MPߧ0SP  Z1PPQЭPЏ@   R	RP	Q{RPQPQ  
]PެTdRbQЭPbRRPQP{RPQPQ  ,  SccQЭPcR
RP
Q{RPQPQ  ЬSQЭPcRRPQP{RPQPQQЭPcRRPQP{RPQPQѣ  <ѣ  <<  ԣQЭPRRPQP{RPQPQQЭPRRPQP{RPQPQ <$<(ԣ,4Э0ZZPP ^RQ*QТPРPA   P^cXVYЦRբLЦSR*R~  PЦRբY1PЦRТSR*R, c RcЬTS*SЦR޲RCbS*SЦRТRCRbߨHЬU0- WgPS*SЦRТRC\ߨN0gPS*SЦRТRC7ߨV0gPS*SЦRТRCS*SЦRТRCЬU.ЬRS*SЦRТRCRbPЬRS*SЦRТRCRbЬTS*SЦRТRC.߭  ,S*SЦRТRC
RbS*SЦRТRC
RbS*SЦRТRC,  S*SЦRТRCRbS*SЦRТRCRbߨb*塞  PS*SЦRТRCRb1 P*:߭^ߨj`  P`S*SЦRТRCRb ߭%+ PS*SЦRТRC) ЬUS*SЦRТRЬT(CS*SЦRТR)CS*SЦRТR*C%ݬD+ P8S*SЦRТRCRbS*SЦRТRCЦRM1 ЬTS*SЦRТRCЦRMMݬ* S*SЦRТRCݬ~<d~  PYU*UЦRТWE%cߨqS*SЦRТRCR޲ R߭RPPȝ PЬRS*SЦRТRC&RЭbE&RbYP ^mVS*SЦRТRCRb'b  ЦRТRCRbЦRТRCRbS*SЦR޲RCbR, b *bЦRMMP ^VެWgygnnT*TЦSУRDRb0УRDRb  ЦRТRDRbЦRТRDRbnS*SЦR޲RCbR, b *bЦRMnMggP^YWVS*SЧRТRCRb'b  ЧRТRCRbЧRТRCRbXXSS                                                                                                                                                                                                                                                   S                        V $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              
 "     &      RSR>XS*SVЧRТRS*S(*CbFbЧSУRFXMXXSSRSRÚSS*SЧR޲RCbR,   *   ^VWWS*SЦRТTR*R(*BdCdЦSWRRMP ^VPR'PW1 PݬPWWP1 ߭ݬ~   PWWP1 ЬSЭ
ݬ' ]~& P`[~x' PU X' UUZ' PP  PTWQPUT%' ЬSգ
ݣB  ԣЬST U& cU~<~O  PWWPWP^X(VZ [@	%
Bޭ| ޭ, u ` u, % P %%P&uMu`v}ЬQQ+& PYЬ́|~%0PYYZ1P̀RЬSBcSC  S% PS|~ 	|~PYY<RRZ1ЭPP P P P P $ , 4 >PJ?P [E [= [5 [ݬ[Z1Lݬ[8lZ15Pݬ% :% P	Z1PPRb:Z1PRbЦRݢ  ެScЦRݢ  P,г Rb$ P1cЦRݢ  P$ P|~?ҟPPYY1Y@  YD  Y	  
kY論  Z1>PRF<~k  P7߭yԮ߭W<W~<~~ʕZ1 ݬЦRݢo  PZZR1 ЬScRҢJcR# PBcRbF߳ # cRЭN%<~PZZR}ЬWgRLSЦRC,  ԭЏ  |~8<~	U  PYY<RR  	gRMgRMZR#RRPݬ[R~	ZR"<RRPYY
ȪY  ZPP^XЬV.V" PV1 o" WPVRb]tVRb[j(Ƚ<~#  PTVSS߭
" PSRb]b.RSSTgd]TVgPTV~gT  Vf.V! PV1i  ^P  ^ cPP  ^ݬ! PЬ➭||~ |~i  PRPP<< P ^RQ P<A P< ,^@.01ޭ2608ޭ:>@B2DޭF>JP|~ 6 <~ PTPTPЭP6*8ޭ:>BDޭFJ@N4PfR>V\|RUխsP.|~ 6.|~PTPTPЭPRPPRPRRSPPSPSPS<~f߭#  UUЬPR`ЬPS`P MRB  ^QޭPPSPRQPQ`cQPQS`SQSPa`bP< ^{TSЬU<P~ 復  PR R8R@dݬq P	PߤݬW Pߤݬ  P
NPЬ=߭oߤq  P$ ߭H5  RaR_=P  ^ x= c ^ЬPР@RRb=Rcμ^WV	WXШ8RA]9d~gn  T ͽTPuB P^Wgͽg  PU ߦFͽ PRb́ͽT1{Pᔭ䔭ԭ洭쟭|~+=(ߦ 71eg1^͑߭MP\\Rݭ   1.Pԭ߭ߦ%͑ խ|~ ߭g!  P͑̓ ߦ( ͑ ߦ/ ԭ͑߭-MP\ݭ ~  \R1>͑߭LP\\Rݭ I  7Pm ͑b  P\ߦ2: ̓/ >P\1Pg﷭  ߦ9 RR@<  <߭  0 P~ ݏ   /< ߭ߦ@ -PC <߭   P~_ ݏ   ;< 4^RTS SnP# PXRd߭d  PU :ߢFݭ P:\l686ݭS   MRB   ^UPЬ8<<^=YX|Z߭<~PPR1խ1Щ8RLRxRR  Rݮ<~V  P1},  ЭR V, f 7f#ZUЭRЭRЭR[ЭR@WЭRYЭRZЭRaЭRbЭRЭRV/ЭR1ЭR 3ЭR7ЭR9ЭRg;ЭR?ЭRAЭRqCЭRGЭRIЭRyKЭROЭRQЭRkSЭRWЭRYЭRm[ЭR _ЭRaЭRcЭRgЭRiЭR	kЭR oЭR%qЭR sЭRwЭR&yЭR{ݭ<~PֽЭRЭS<RR  WЩ8RLRWR1 PЭRGV4<_~<~P  PV1xPЭRVGWW1f\WW<SVR1         h§ § o  « 1 « [  1 ![ѦX&ЦXWZ[ЦXWZ[
ѦXЦXWZWЩ8RLRWR1ЭRJVZZ<SVRD        § § Ĩ  « « ﳨ  ЬXЭRh
ЭR, f <fнЬW(ЭRfƍ  P ^QSTݬ<~PTTPEռ<PPУ8PLPPT#PЬR<QмPAbbP`TTPP< ^TЬ߭<~]PPխ<PPФ8RLPPЭP
ЭR<PЭR@SS<USRD    N    %§ § ,  « «   c^UXХ8RLRXRr T  VHăSN<WSR8    f  § § f« « fS<~2  XХ8RLRXRЬR Rբ#
ݢ#PԢ#բ'
ݢ'PԢ'բ3
ݢ3һ  Ԣ3ݬ<~՛  < ^9SU߭<~PUUP1 խЬR<bPPУ8PLPbPU1 <QQЭPARU1 ЭPЬTd
ЭPЭPЭQ<PP  ЭPԢ b¥ ¯     f  § § U  « « D  UP^AW߭<~PSSR1Bխ1:VЧ8RLRVR1'  UXP<VPЭR@T1 ЬPPPaP[d<STR4    e  h§ § e« « eЭQ<P<VRRPR
ЭR<VPPudq<STR4    e  h§ § e« « eЭQ<P<VSSRPR
ЭRT<~  ЭRCVЧ8RLRVR1 ^RSЬ߭<~SPSSPUխ<PPТ8PLPPS3<QЭPAPSS	P SPP ^UR߭<~PPwխrSТ8PLPSPbЭPCQFaBЬP7ЬP`&ЬP`SТ8PLPSP  ^լЬP    ЬP  oЬP  r  ЬP  ]  ^]V߭<~PRtխoWЦ8RLRWR_ЭRGRCb?  9߭? ߬  W  PXXRЭR(ЭRТPWЦ8RLRWRP< ^S߭<~FPRgխbTУ8RLRTRRЭPDR6b2  ,ݬ? ߬  ￧  PUUP	  PTУ8PLPTP< P  ^9VWլ1 м<S<USޮSޭޭnTݮ<U~PTTRFվ<RRЦ8RLRRT$Pc<SоRC о RbTTWWRjЭR  ЬRbb  PWWRC߭ݼg  PWWR.<~lPЭS(ЭRЬScɏ   cWP MRB MaintainClusterServerNames failed: ShmAddAfterSLList 0x%02.2x
  ^-SЬRR8Rl  RQ  ?T<R ~8P   8^TZ@ސЬⰏ Ұ%|ԭЬRb|Ԣ||բ3
ݢ3Ѵ  Ԣ3ЬSѣ4	  գ0ЬR|+!P߭ЬPP/0~ݠ#<~Y  ЬPѠ/   Р/RB#Ѡ+   1x`
ՠՠ1bЬSã/+n   nn~  P3PR	Z1-PnSCbUެVfSУ
e
RbWfUެXhS< YХ03W |~ ޟ2Y	# P[Pߤ#[j  Z1 P<PP5ߤ/<~i  <PP	  ߤ;Pi  ZrZlPfP 4ߤGЬPݠ4i  ZKP߭hRR߭fPî0~ݭ<~   b
բբW   WPPn1ЬP
SЭcZR1 ЬRb9բ+	Т#b"Pբ''FPZZRwЬRТ'b ݼA  ЬRբGբ+   #(Pբ''FPZZR/ЬP   'ЬRݢх  ݬݬ  PZZRխݭ<~S  ZPP^TެXԸ VެWVg1 hUeRQQ1 mQ   1 QPP    .    B 1 P?PЬP`oR`fPЬPՠZR
PЬPՠFR<bQQ38PѢ%&ЬScQ<~V  Pcb~Rc=
 bPPeVVg15^5{[мVfZYVYZYPfRfRR HPP  2 2 2 % &F?PЬRբVЬRբVfSSYSVYZЬRբkZRR   ߫Sa	 PЬScWgRRWW RRR , g ggЬR
k  ^  ЧЬRТVfZYVYZ6Pf.fRR $RR
ЬRբVfSSYSVYZЬWէ;ЧXhRRXXRRR, h hhXݧݬ  ԨЬRբ_ТVfZYVYZMPfFfRR <RRRЬRբVЬRբVfSSYSVYZPP ^ЬRRЬPЬPRЬPЬPRЬPЬPRЬRȏ   Pμ^xVW@#%&K'Ϳޭ %ЬTĵ &Ľ  	+ V	|T	P]ЬS~<c~d  JY, K @ KORЬScbS Ϳ                                                                                                                                                                                                                                                   T                        e $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              2 "     7      |~ #2<Y~	 PXXߦzXc  W1 <SS$S	  W1 Ɛ Sc  W1 ЬTKݤat  PaOd9 ;ą ?ć 
}} 	 P`ЬURURRЬSÒ K<Y~ЬT<d~U<Ò ~<d~  P&Ò U<d~  PRWWWPp^vXYVA' 	19+-ЬV 
] %Ƶ &ƽ #|ͻͽ;Ϳ@ͳ͵ͶͷWЬS~<c~vb  J[Ƒ ,  @ ͿRЬScbư	ͫ1 ͩͪ??ݬw  PYYR1ЬR Pͻ<PRͪ	Y1P |~ͻͳͫ2<[~	L PZЬSÃ RÃ <ͫRR	  1  1 ͩͪ??ЬRݬw  PYYR1GЬSq Pͻ<PR.ͪY1 |~ͻͳͫ2<[~	 PZЬSÃ RÃ ZȦ Zt`  Y1P<ͫVV A P1@`1;PV	  1RN1 ݬvP1 W,  @ ݬݬݬݬ`  PYYRYЬR 1ERЬScbư  |~ ͳͫ2<[~	  PZЬSÃ RÃ ZȲ Z_  Y1P<ͫSS A PW`SPS	  YЬR 1Ⱦ S;_  Y1YЬR 1 V_  Y1uRN1|W1u
'ͩRBA.5W0ͩSCA.ͩRRBA;WPCA;WW1&SЬRbSS~ЬVƒ '<[~ЬW<g~
Ʊ R<R1 ,  @ ݬݬݬW  PYYR
YƑ 1PRЬScbư  |~ ͳͫ2<[~	  PZЬSÃ RÃ Z Z]  Y16P<ͫSS AS  P3`/PS	  YЬR 1 S]  Y1
'" YЬR 1PЬR}	PЬR}ЬSݣa|  Pa}9É .SЬRbSS~ЬR '<[~<~ЬUeSЭcŅ Ň Ak  ЬT1:d13Œ ЬS~<c~  PV1VuwAy }	́ͅ͇+͉͍͏-͑ ͕%͗ŵ ͙͝&͟Ž ͥ͡}Ϳ  PͻV	}ͅ
P}}VYЬR 'ЬSc<~h  PR
Y1;PY12PЬR}	ЬRЬR1VЬS&;A  P~ݣ   PYYR1 ԭ u|~ͻͳͫ2<[~	j  PZZ ZG[  Y1 <ͫTT(ЬRb A  P*`&PT   kT0	  b TZ  YP<RЬS	RY5Y/PV1ЬR '<[~<~61PYP δ^WԭݬݬrPVVR1I߭߭<~<~>PVVR1)1WݬЭR~  ЭRԢ#U ЭR"U~'~:p  PVVR1ЭR   Sݭݭ<~c  PVVRЭRЭRЭR>͵ݭݭc  PVVRЭRЭRЭR͵VR5 ͵ݭݭ<~ݬ4PVVRЬSЭc1!P 1W<~&PVVR1 ݬЭR~  ЭR#U ЭR"U~'~o  PVVR1 ЭR Sݭݭ<~c  PVVRЭRЭRЭR>͵ݭݭc  PVVRЭRЭRЭR͵VR/ ͵ݭݭ<~ݬ3PVVR
ЬSЭcխ^(n<~bVPP^{Z@VO5!##ͦ%)+-1 |	%ͦ!ͦͦRbͦRЬRbS8RC
,  @ լ1 ݬ   |~ 2<*~	  PRĭkݮV  1P<SS=լ`;OO  PR RA  P`ݬbkRR  )S	  1TBkSmV  1>PЬR(bXͦ1 $RR1 ~ͦs  ͦScRSRVRRcf	  ЬY(iЬЬ,  @ dYc   |~ 6<*~	  PPsjݮU  1`<SScjSrU  1CP19QjݭQU  1"PЮWg[W[*g%gRR WXgSS[SW[֚$RR1 X1 RR1 Эn,  @ ݬn  n |~ 6<*~	  PPiݮT  1gP<SSiSvT  1GP1=iݭUT  1&PX<ͦTdShRRSRRdhRXRͦRRRR   ~ݮX   NPXͦScRSRXRRch	x  (ЬЬͦЭn,  @ ݬ<  n |~ 6<*~	  PPhݮdS  6P<SShSFS  hݭ,S     P^fY@#|߭0PSSRЭЭR,  @ ݬX   |~ 2<~	  PZZ<RRɤZR  1 P,  ЭRb8 Ro  ЭTdRTRSRRdcpP!ЭVfXWVWX0Pf)fRR VR7fSSWSVWXЭScRRScRRRR |~ 6<~	  -0^CeXWZ@z|}͂~,  7ş8/ЬRbS8RC[, ͂ @ ͂ݬ͆  VЬSS %Э&	  |~ zr2<[~	  PYR͊YȺY_P  Z1 <rSS$S	  Z1 S3P  Z1 լ3;  PR R  P`ݬRR    ş͂<[~ oЭTЬRbЬRbPЬSФcЬSЭRТcRբ#
ݢ#%.Ԣ#բ'
ݢ'.Ԣ'բ3
ݢ3-  Ԣ3ZPP^cVX@ݬ  PЬ,  @ RЬScbм|~|~2<~	  PWWWN  X$P<RRЭ̼ЬTЭdĤPXPP^XbVX@VЬԭ,  @ RЬScb |~ 2<~	X  PWWW5N  X<SSS	  
SN  XPP^aWX@ЬVVԭ,  @ RЬScb |~ 2<~	  PYRĦYYM  X#P<SSS	  
S_M  XXP^ aXŷWY@ЬVVVЬԭ,  @ RЬScb |~ 2S8R<C~	  PZRĦZ ZL  Y <SSS	  
-SL  YYP^0`VW@ݬ  PЬ,  @ RЬScb|~|~2<~	(  PXX:XL  W<RR	WPЬTЭdĤWPP^_WYЬS1 <R1 1 ߭߭RЬT<d~yPvգ'<ЭRԢЭRЭRЭRЭR¥ ЭRЭR¯ 7P<RR%ЭR"RSTp  ЭRPЭRЬR|   | | ﮔ  ЬVRbԦG;P,  @ !SЬUХc
% +'c'7  P_ЬTЬU
ХХ'   ޭWů ߭  ߭  P /?_W2ЬS~<c~J  <J~	  PXXYIXI  (<~ݭ߭  <RB߭ů Q  YP^[VЬRբ'$ЬSԣå ï [1PЬUեХХЬSУ'
gZPZ#Z 1tPZ 1cPЬR, b =bЬT ЬSä ä Z~Ñ ЬRRā [  b1"ЬR2~2~ЬRRd  Pb1ЬYSЬTФcЬWЬX.(/(5Z"߭߭~.<h~d 6PԭЭRТLVݬRݬWPЬRK  gЬS~<c~H  <J~<c~P[[RR	  [12ЬR VV3ЬS#
 1PЬS#
 1ЬUŤ RR1
RRRݬő   P@ū ū {  ߭ЬR« |  ݬ߽  ЭRԢ
PݬЬR   
ЭSУTRPЬS RRЬTĤ 1 P<SSc   c<S~߭f  <~ݬ@R  ЬSë @|~ݬë F  P,ä "߭~!  Pݬő   1 ЬRݬgݬXPݬ  yݬЬR RvRTЬRѤ	3
,Ѥ%UЬS~<c~0/PRUR5Ѥ+ ЬR Z~TЬRЬS~<c~
ݭ3[Px^OYWXZ@ͮͰͱͶͲݬ	  PͦͨͩЬͪ ͕͗v͙͝͟͡ЬRҒ ͥͧ ͩҖ ͭͯ ͱ y{V}́̓Rͅ ͉
͋R͍͑|~?ЬS~<c~*E  BPPYY_YyD  Z13P, Ͷ @ ͶͺRЬScb; y|~ ͖ͮ2<~	C  PYYoY D  Z1P<͖SSSD  Z1 Vv  Rz  ЬR¡ V߭<~PZZR1x[ЬUS*S8RТRC
Rb9<[TxTTD͵RbDͷRbS*S8RТRCSD͹RSb[ЬTd$<[SxSSC͵RbCͷRbC͹RTb[<[SxSSC͵RbCͷRb͞x}͞}͞͞`  Ц, Ͷ @ ͶRЬScb< ͶYRR~ka  P~ ͕|~͖ͦͮ~<~	  PYYǏYcB  Z1<͖SS<Sh  	S  Z1 SP  Z1 ǟSB  Z1                                                                                                                                                                                                                                                    U                        
b $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     H      ͶYRRj,   |~ < ~͖0<~	  PYYǯYA  Zl<͖SSǾSA  ZRP |~ ͖ͮ4<~	  PYYY^A  Z<͖SSSCA  Z<R$RPYYYA  ZRZZPP^TWX@ЬV}  P,  @ W  |~|~<5~ЬS~<c~'A  <J~	  PYYYu@  X(<SS!St!  XPSK@  XXP8^SVX@ݬ  PЬЬ;=>C?ЬS~<c~d@  JZV;, ͺ @ ͺYI  |~;?5<Z~	  PWWWx?  X1&P<SS-S	  <YR1X1PSC?  X1 <RRBC  ;ݬ  P`;C  PPݬ  ݬ  P|~|~3<ZTT	  PWˏWS<RRbG  C8  P;|~|~; 3T	  XSWk>  $<~Y>  PY1PXP| ^ｨUVЬT1T9VRxRRЬSBcP`BP#`ޥ8QBPQ`VVRxRR QBcPQ`BP!`BPd`V(VRxRRЬS QBcPQ`BP`BPd`V
W9VRxRRЬSBcP`BP#`8QBPQ`VVRxRRQBcPQ`BP!`BPФ`V)VRxRRЬSQBcPQ`BP`BPФ`Vլ%VQxQQЬRAbP `AP`APЬ`VЬS(c$VQxQQЬRAbP`AP`APS`VVRxRRЬQBaP`BP  t^_PVW@ݬݬݬ|:,  @ RЬScbĵ' ||~ |~t6<~  PX! ||~ t6<~	.  PXX.X<  WSP<tSS$S	  W;PMS;  W'PЬR
jݭ;  WWPP^TOVW@ Ьԭ,  @ RЬScb |~ 6<~	U  PXXƍX2;  W)<SS!S	  WPƦX;  WWP| ^@"ЬRR!ЬЬ|b,  @ ݬ?   |~ 6<~	  PVVP<RRPPP^NWͤVY@Z,  @   ЬST*T8RТRD%4լ/~ P+ ȏ   < < |~?ЬS~<c~>:  BPPXXǿX9  Yp|~|~ r~<~	}  PXXXZ9  Y=<SSZ0S	  Y"PS   YS9  YYRS<RMZ)|~|~  4R	  PXX
X8  <~PXXX8  YPP^\LVX@,  @ |~|~ 4<~	  PWWW]8  X1 P<SS	S@8  X1 P  ,  @   լ#  ȏ   P< < |~|~ r~<~	  PWWW7  XP<SS%S7  XXPt^3KWZ[@tvw|xЬVݦtV  PX, | @ |ѦpX X g&|~|~ t|~4< ~  PY P|~|~ t4< ~	  PY2~|~ЬR5< ~bPƌ l5d' |~ t|~4< ~  PY! |~ t4< ~	s  PYY3YP6  [sP<SSES   '<RR   ЬRS*S8RТRC%9@<~6  [%議Mݭ5  [
ЬRABЬR< ~PYY
ZY5  ЬR    [P^QIVZЬUQUPЏ   RRRPRQPQP{RPPQQWrWXX<TT^  PS|~ QUPЏ   R	RP	Q{RPQPQQXS1<~	'  PYݬWS~ݬ  ST^  @P|~ QUPЏ   R
RP
Q{RPQPQQݬݬ1<~	  PYYgY4  Z<RRsR4  ZZP^-HXЬQЮPЏ   RRRPRQPQP{RPPQQ[<YYRQRPЏ   RRRPRQPQP{RPPQQS[S1 SS   S[YZSZZ<~]  PV1 [ZWZRR
îWWW
, f Zf$PWVݮ<~<~PPR1 <~ݬ[V~  |~ QЬPЏ   R	RP	Q{RPQPQQZV0<~	G  PnV<~\  >|~ QЮPЏ   R	RP	Q{RPQPQQYݬ0<~	  Pnnݮ2  <SSSp  ȌS2  P^TFVW@,  @ ݬ  Ь|~|~ 6<~	_  PXXƙX<2  W1 P<TTЬRحSSS/PTP  	T  WoƮT1  W]PS|~ ݭx	~ <0~<~	  PXXX1  WP<SSS1  WWP^4EVW@ Ьԭ,  @ ݬ   Ь |~ 6<~	+  PXXX1  W'P<TT
ЬRT0  WWP^DWX@ЬVE  P,  @   |~|~<5~<~	r  PYY%YO0  XMP<SS5S   X5PS	  XP3S0  XP  XP`^CVdW[@ЬR]  P df]hln ptv xҒ |~ Җ  ||ԭ© RТY,  @ ЬRS*S8RТRC%$լYYȏ   P<	Y< δZլ%<ZTxTTDRbDRbެSDRSbZЬUS*S8RТRCTd,CRb<ZTxTTDRbDRb>SDRSb|~?~<e~.  BPPXXAXA.  [1 PЬR   d|~~<~	  PXXWX-  [1 <SSS  
yS-  [1 ЬR  lV|~ ݭx	~ <0~<~	  PXXƙX~-  [8<SSƺSd-  [PЬTЭФad  [RT<RN)|~|~  4R	+  PXX
X-  <~PXXX,  [PPX^@VHW@ެT<dRЬS~<c~(-  J[X
d[sX,  @ ЬTd  ѤaX X֐ ]Ē rYЬTd$Y<YSxSSCbRbCdRbCfRTbЬRS*S8RТRCTd1CRbY<YTxTTDbRbDdRb>SDfRSb<YRRrSxRRBbS S|~ 6<[~	  PZZZy+  1 P<TT0ЬR­Ңa%T   yT;+  fЬSÞ ß <RQҭIx	an|~ ݮ <0~<[~	  PZZ
)Z*  <SS
IS*   P^p>VX@Ьԭ,  @ ´ |~ 2<~	v  PWWeWS*  X<RRzW<*  XXP  ^ЬQa<aP
ݡB  $^=WZԮЬSУRǏZ)  PXbbRXЬRТS 1`<XRR1X<XRxR~s  PUǬZ)  P   PVX1YУTTU|~ QУPЏ   R
RP
Q{RPQPQQT~ݣ<VRxRRBe1ЬR< ~ iPZP|~ QУPЏ   R	RP	Q{RPQPQQTݣ<VRxRRBe1ЬR< ~ iPZZ8Z(  <VP<Q<XRPRRQRR   UVr  PTc
cSVVX1   VX7<VPxPP@eR<bRR@eR<b~Q(  Ur  PVVXUq  1УUUI|~ QУPЏ   R
RP
Q{RPQPQQU~ݣ1ЬR< ~	  PZDP|~ QУPЏ   R	RP	Q{RPQPQQUݣ1ЬR< ~	  PZZZ'  P<TT3Tw'  PU1УУUQЮPЏ   RRRPRQPQP{RPPQQQ1 U[[[Q[PЏ   RRPQP{RPQPQnx	n~^p  PTP|~ QЮPЏ   R
RP
Q{RPQPQQ[TЬR1ЬR< ~	  PZUT~ݣ3  TFp  1 PUM|~ QЮPЏ   R
RP
Q{RPQPQQU~ݣЬR1ЬR< ~	L  PZHP|~ QЮPЏ   R	RP	Q{RPQPQQUݣЬR1ЬR< ~	  PZZcZ%  PЬP Ǒ2~%  PUccS1E   P^P9Y ԮЬSУRݮ$|%  P[bbR[ЬRТV{
PǏ   RRЬRîpSSx	SS|~ ݮ$S <0~< ~	$  P Pݮ$$  P<SSS$  PPЬR 1<[RR1M[<[RxR~!n  PX$ݮ$$  P   PZ[1 P  WЦЦUUU|~ QЮ$PЏ   RRPQP{RPQPQQUݦݮ8<ZTxTRBh0< ~ P P8Jݮ$$  T<S<[RTRRSRR U  Xm  PUf
fVZZ[1S ,  Z[9P<ZSxSSChR<bRRhChR<b~#  XPm  PZZ[X<m  1ЦЦTTT|~ QЮ$PЏ   RRPQP{RPQPQQTݦ0ЬR< ~	>  P PɎݮ$#  P<SSɯS#  PT1bPЦЦXQЮPЏ   RRRPRQPQP{RPPQQXRQRPЏ   RRRPRQPQP{RPPQQծծ1Vծ
î   XRRݮk  PWPînЮnSЬRS"n"Ԯծ
, g g1 P|~ QЮPЏ   R	RP	Q{RPQPQQݮ WЬR1ЬR< ~	  P PW~k  ݮ$!  PЬS WZk  	2~!  PXݦW~  |~ QЮ$PЏ   RRPQP{RPQPQQݮWЬR0ЬR< ~	F  P Wj  IP|~ QЮ$PЏ   R	RP	Q{RPQPQQXݦЬR0ЬR< ~	  P  F	ݮ$   PЬRSSSpm	2S~   PXffV1P   P ^54S ×	|~|~ݬ  PRR  RP  ^ŏ   ~   ^3XﰊW[@z|}~                                                                                                                                                                                                                                                   V                        6h $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              u "     Y      Ԯn,  77S8RC;ݬv  P[1P֮VFHeJNPR VXZ ^%`7bf&h?jnЬVЬZ<   Y,  @ Rfbݮȧ	ݮ  Z  P>@AZB F|~>zr2ݮ4	  PR[1 <rRR$<rRR0	  1 R	  1 [1  K<~ &/RXRSծ	УУn@iP1Ɵ	iP"ѬMݬݬݣݣP[[R2ծݬݬݮݮP[P[Rբ#
ݢ#}Ԣ#բ'
ݢ'kԢ'բ3
ݢ3g  Ԣ3[PP^i1XV'Rff5PYYP
Ȫ	Vf<  PSЬUUTT  PSS0<T<ܿ  e1 f1 Wf߭fP7P<ݭ  PWfﳽP߭f׽P˕WZ<x  PP;f  P<<ݭG  ݭfPYYPPϩjݭLf  ԭ<< ^ŔUԼeЬTeӼ߭eCPS   Sݭ  PR RPP   0ݭT  RTR e̼P߭ePּd   ^	|~M     ^Ɉ 3   P  ^       ^2   ^^9TF  XUW]RU ТR	WPR]PРSWUլ
dh  ЬR
Ub
Pߤ  RUHУVլVߤ-he  #PЬPRVBPVߤEP  УSURUW*լߤ]h  ЬR
ߤ}  լĝ h  Pլğ   PMRB   ^eP 8 ^XԼ|VP~c  PVX1`~c  PWX1, f P f, g ` gP`fgW($  ЬS~<c~k  PRbg  PX1 b߭@  :߭  P`߭4  P߭럧   Ⱥ  Pz   RRRVPY º  Y}7YL  XP Ѧ 	XPXXRVPV	Vb  W	Wb  XPP  ^ЬPݠ   ^7RSЬQ|ԡ|~QPTPߢT  SPЬP SSP^6XWԼP~a  PVWo, f D fDf<Ь<   P
  RRRVPY   YߨY!  W W
PD|HVWP< ^6SUЬQQRԡ|~QPTPߣ(T  UPЬP UբH
ݢHea  ԢHݬXa   UP| ^VԼЬRޭ$   ݬ<~4  PTTP1 ЬRТSS ,߭߭ Rg  UUТ<PPP&U"PS	<"UPSz 1 T1 PVQVP
RRRPRQPQP{RPPQQTЬPՠ
hJ  PTTPD߭ЬPݠK  PTTP+ЬPЭP(  мU1 ЬR ЬSS<~  ԣ$    TP^|ZЬUUTЬS1 գ!ZU<~k  PWWR1JPݣK  ߭ݣL  P!ZU<~/  PWWR1CPЭRѬb7ZbD.V  U<~  PWWR1нDZ1 ЬSգ'դD1 ݬ<~  PWWR1vP߭߬ݣR  P>ЭRbDTЬRͷ  R<~  PWWR1EнD դDݬ<~?  PWWR1ެVfR<"RDRѬR1ެXhUЦ S< Y!ZЭPfP
  PZ<"QQDSYQ  PWWP1 fPѠz 
ЬP1 PZ~[Q[P
RRRPRQPQP{RPPQQQhPՠ
G  PWWPG߭hPݠ5I  PWWP/fPЭP  ФDfP<"PDPѬP1
WR
%2WP| ^1SUЬQQRСV|ԡ"D|~QPTPߣLTu  U+ЬP UPݬ<~   PUԢDЬPV UP^U1VWЬRRTЏ | V  P  PPPRPS P  S%S Sz ߦVS  W1 ЬSУUU)߭߭~S  <"RPRPP"1 PU k~߭߭ S  XXXݤH<~<  PHWHЬR HLФL$~R<~&   PWWPUz ߦaU  WWP^0VWЬRRTЏ Y|   Ps  PPPRPS   S$S Sz ߦlS  W1 ЬSУUU%߭߭S  <"RPRPP"1 U k~߭߭ Sa  XXXݤH<~:  PHWHЬR HLФL$~R<~PWWPUz ߦwU  WЬPYWP^XVЬR<bYbЬSSTդHZ߭߭ S  У<Q<6P 6 < RRR~Y  PHX1zЬRHLФL$ЬW&դD1 ݬ<~rPXXP1@xެSWDDUcR<"PPUWU"Wcݬ<~PXXP1:PWU2<   RcRPXXP1 cQ<"P
ѡz ЬRѢz 1 ެUeR<"RäDPPR~Y  PVVäDRLR~ݬ  VYteS<W<"QQDSWPXXPTePѠz CeP<"ZVZRRYZݤLV~  RVVY~ݤLV~  YVVYVXPP^,WUԼTԼЬQQSС<PVV'T1F<"PLP
`<"PLPP
`1+V1$С$RUT1P<"P" b$Qw1~ Q mQPP f f f f ^ f f f f f f V f f f f 2 F @?PBPU
X
ZT
Y/PUXT
YPT
YU
XU
XT
YuЬP$QUQLУLRUPP    P*?PZbRXbPPUǂ [TLURЬP<"PPRYbT
TǗ .UT  ^q+SЬRí Pբ P =   ^1+VЬSݣB  ߭ݣE  P	ЭRբ< ߭ݣB  PP,  D ЭRDЭR<ЭSЬRТ<ЭR ٭  P3RRRݭPW ҭ  W+ЭRݢ)WL  ЭRԢ<PЭS ,ݣ/KЭRݢ  ЭRԢ<PЭЭTЬRТR6"" ЭRЭR4ЭR P| ^)TЬS>ЬRբ
߭RPPPТ
ЭPР
ЭPЏ\PУУ\= jPЭPЏЬRbRRЭPȏ   RЭPȏ   ЭR h  PЭRެ0ЭRЬ$Ѭ ЭRݬRďﻘ PPPݭPV )  UVHVz ЭRЬPРP6"" Vz ЬPРPݠ,VPUnPЭRТSS`Sz ЬPРP6"" U@S ЬPРPݠ,.UЬPРPݠ,VQUլЭPЬRТ
Э
UPP| ^
(UTЬS0ЬRբ
߭RPPPТ
ЭPР
УЭR   PЭRެ0ЭPЏЭRЬ( PPPݭPV   ˏVRЭP ЬP?PRV~T%ЭRѢ TݢşҖTլЭPЬRТ
Э
TP^'XuVPP~(R  PWP, g P gPgݬ0  PPQ  P,Pݬݧ,  ݧ,  P4Џ    6JH|~WPYY ݧ,Q  ԧ,WQ  PЬRWD~;  Ԣ
bRUS< TdU-TSR< ScUB<SRȹPP^%XtVPP~P  PWP, g P gݬ  PPP  P,Pݬݧ,ϩ  ЬRWD~:  Ԣ
Pgݧ,  P4Џ    6J|~WPYY ݧ,P  ԧ,WP  PЬRbRU S< TdU-TSR< ScUB<SRȹJPP< ^$UVsRЬSPޢ<QaS@<QPެTdSݣ;  ߭ݣ<  P(Ф SЭPԠ|~ݭ߭ݣ<  PЬT:  ФSԣ|~ݤФSݣ,yO  ФSԣ,ݤhO  Ԥ
    ^ЬRբ
ЬPRnPPPЬPТ
РPР
PP ^|~ЬSݣxУPЬRТ
У
^U#YPP~N  PWP, g P g`~dN  PXWN  P, h ` hPg`hX(Ь,ݧ,R  P4Џ   H|~WPZZ X7N  W.N  PЬVfWD~7  ߭ݦu9  ,  D Э
ЭRDЭR< ЭRЦ<ЭR|~ݭPZZ+ЭRݢﻑZ  ЭRԢ<PЭS ,ݣЭRݢ  ЭRԢ<PЭRԢЭR$ݬ  ԧ(X/M  P< ^!SUЬPР
Rբ
   բԢ<Ь("+   PPPRPTPT0ސUUPP ^!!SЬRբ(
ݢ(L  Ԣ(ЬR ݢ^P ^ SЬPР
RբP   բ||~RԢ("|~RPTP
TÇ:< ^ UJoSެTdRQ< RbdRQP< RbЬ@<RP   ^- TnRެScQP< Qac@<QP   ^nSR< TddPPPd
TRP ^SЬRբ
߭RcPP7Т
ЭPР
ЭR   PЭPԠ0ЭP<ЭPԠ(PPPݭPR v  RR)ҎЭR ݢXﺎЭPЬQС
Э
   MRB                         Ready to get long term fs name lock %s
 Unexpected status %08.8X dequeuing lock %s
 Unexpected status %08.8X %s lock %s, stage %d
  ^ݬ$ݬ ݬݬݬݬݬ<~<~	  PRRP ^"R߭j~~~~~~b5  ݬݬ $     ^ѬЬP P ^
mRЬ8߭ GO<ЭP>| ^
"VlRT*TТ8PРSD$߭<~OЭPՠUРU
PDP`UU~<~ߦ1ҌUPP ^qlRT*TТ8PРSD߭<~NЭPՠPPDP`PD P< ^lRQ*QТ8PРTAuS<USnSS*SC$߭<U~/NЭPՠQPQPCP`QPCQQSPcݬ  QPQ                                                                                                                                                                                                                                                   W                        : $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     j      QP2PPPP8^ WxkVY,  P , H ` H,  P PHАH`I<<~G  PԔԚS<SST*TЦ8RТSD$߭<~>MЭRբUТU
PDRbUU~<~ߧ1URbݭ  ݬݭ  ݭ  Pܟ0PXXrݬ  PY<nЭRRF  ԭԴXP|~0YPδ^[[(jZ@ , L 7LoTޭ %o&wЬS1c1 S<USVTVS*SЪ8RТRCPP   &P?PSbFPT@ФR:Ѣ4SJЪ8RRR"R	S3PTФR
ѢS?<U~6SSS
լ_S<VSST*TЪ8RТSD#߭<V~KЭRբUUPDRbUPDUUYPЬYY1,  @ RЬScbЩ
R<JX2WDQP|UTS~STUVPQ<W~<X~	  PnPPWЮSޫxT ~~~~~~kŜ  ST߫   H14<DRR1$
1PЬScݭS#  <R1 LЩ
R<J~<SSnRSTRULUS*SЪ8RТRCPP   /P?PSrVPծOЮRТREѢ?SUPЪ8RRR*R	S;PծЮRТR
ѢSP?<T~3SSSL<~  PLRբ#
ݢ#Ԣ#բ'
ݢ'sԢ'բ3
ݢ3B  Ԣ3 Pμ^gZ4fY@ݬ0  PЬ,  7J,  @ RЬScbư53 %&#ЬR1 [b1 S<USVTVS*SЩ8RТRCPP   'P?PSbFPT@ФR:Ѣ4SJЩ8RRR"R	S3PTФR
ѢS?<U~1SSSP[<X2WQPV|T[S~STUVPQ<W~<X~	'  PnPPYЮSʉ Ty~~~~~~j>  STߪ0   16P<RR	1%ݬ5  [1ЬSc
5Sy  <R1 /<~<SSRSTRUUS*SЩ8RТRCPP   .PJ?PSrVPծOЮRТREѢ?SUPЩ8RRR*R	S;PծЮRТR
ѢSP?<T~;0SSS/<~	  PRբ#
ݢ#Ԣ#բ'
ݢ'Ԣ'բ3
ݢ3?  Ԣ3P ^ЬP
.ЬRR  PS
R  RPSЬRTT*
S߭}  ߭SSo  P
sP
S߭S  ߭S~E  T S߭4  ߭SS&  
sTs
s| ^-T<P
ЬP
.ЬRR  PS	RSVPR  PVRVS<UU
_V&ЬP
cRUĘ S~  RcЬR
S߭  Uě Sn  ߭Rj  Ud   1 V'ЬP
cRUĞ S~-  RcV7ЬR
S߭  Uġ S~  ߭R  ЬR
S߭ݕ  UĤ Sʕ  ߭Rƕ   ^ЬRbTSRST<PbQQSQRST<Pt^[͈ V$&͝(,.ޭ04#6@8<@@ԭ7`RN4P@R(͈S<WSST*T_RТSD%߭<W~AЭRբU PUPDRbUPDUU(	1PЮ(RТ
RJ, @ @ @͈ݮ,AP   1<   2  $@RbpJRbNDS͈c͌H   ʹWЮY2X̀WQPޭUTS~STUPQW<X~<Y~	1  PP͌RH͌WЮS˧ TͭsͲ~ͱ~Ͱ~ͭ~ͯ~ͮ~k8  ST߫*   1H<̀RR19Ю(RТ
RѢNѢN*ݭʹ  ЭRBʹʹ͝  ^RNE@?@UUVf,ZVZ,PTfSSZSVZ,小TT#ˏ~ ͎͝4&P.͝o  ` ͎͝4͎1KP<S͎=  <PRRSRR<RRR   	1<RR  R
R͎͎,˵ ,͈ݮ,ＰP   1͈4Ѿ4  Ю4RRR	P   RRR4(0Ѿ0  Ю0RRR
P   RRRi/  PSHc/  PS4   U-  TS~Ud˷ Udc/s  PSݬ     P ^TЬRЬSb1KPbPPPP*8 ((( (((((((((((((((( 1 6?PTPRbbPP.Rb
bPP.bPR.S`  PSbPP?P*PPTS1 TPcc.1 RbbPP.Rb
bPP.bPRP`[cWPTcRQaPP?	P*aPc.PRP`
SP`PT
bcPRSb1լcRR.PP^WVZU[XVYZլ
ޭTЬTЬSЬRb1PbQQ 1QPP ^~?PP_   1RP`_1 RQa1 RP`1 QD @  PP 1 PA   PZ   _c17Pa   Pz   
_c1PP0P9
_c1
PP$P_   P-	_c1 PcRPP.1 X1}XY0Y9ЬQaVZ1 d.1 d1 PTd.1 d1 P_c1 ' ǹ R  P1[1RP`1 `;1 .cX1 XY0Y9ЬQaVZ$d.dTd.dP1 1 bcХ8PNGXVVPPeЬQa1 PVVPPNЬQaRb.hbdRb.]bWPXVVPP[EPVVPP
[1PZcdZPcdP8TRcYSb1]cXY0Y9ЬScZ[R[P2 P,^qY>WU|VXԮЬRbRRԮRԮЬTЬRRZbP1ЬRbPPSSVWPP1BWPP9R   ֬ЬQaPSSaQˏQPP.QQ1PPddPP*7 1?PWP1V1VХ8PN`PPYRRWPPIЬP`*dT9R5WTP`0`9Tp1`9
TP*dTTT6
ЬP.`1)P	X1d T  T.dTW1Х8PN"PPTPP`1`9PT*dTPSPPV
ЬQa1GЬQa֬ЬP`QˏQPP.QQ1׬1
VЬQaXЬQa%dT1 S0~ T~  _dTP_`TV1 X1 PdRRARZTV1 X1 PR0R9
TV}XyRaRzR~ֈ  PdTVZXVR$R_R-TV?X;PTD@T'  P1_dTP_`TVXW֬P1dRRЬScRìTPPRRcХ8RN1 RR1 VwWPP#PP
*dTd1 %dT*dTdqPPPfծaݮ߭m  %֮%֮PP%֮߭ݮC  $TRb0b9Tr1b9T*dTdT1 ݬ  1wPХ8RN-RR%VWPP*dTdWPP*dTd`ծSTSc%ìSRRRS:PcPP% % % % %  #P?PP*cP
PSSȵlTRPPRPP[îRPP[b%[X<[P<PbPP% % % % %  P?PP*bPX	R[<[PǕծX*RbЬRb0V,ЬRb ݬ  P ݬ   ݬ   P ^.ЬTTt  PS<TSP<PQ2PQPPR;SJ  P<PQ2RPQP#PPT)  <PS2RSRP2 P ^OޭЬRЬSGPԢ
cЬPЬQ<P

   ЬS<RЬR   ЬS<R!<RЬR   PУP  ^ЬQa ^ЬRbbPRPQPPba  ^ЬQa	P< ^TݬPUˏURZU  1 RJUR S߭~~~~~~dK  RSߤ=   ЬS<PDPPc c<RQRPRRPQP{RPQPQ   ^ЬP`  	PPP  ^ЬP`
<PPPP  ^x Q< PQP< ^Tݬ:  PUPPUR S߭s~~~~~~d>  RSߤ0   P< ^YTݬҁ  PUPPUR S߭~~~~~~d҂  RSߤĂ   UP< ^Tݬj  PUPPURS߭~~~~~~df  RSߤX   P< ^Tݬ  PUPPURS߭/~~~~~~d  RSߤ   }P< ^Tݬj  PUUPPPUPUR&S߭~~~~~~d  RSߤq   < P^UЬRbP"bRRRRR	RRUHPЬRbPPPP5bP.<QQ'PPˏ QPQPPPPQPQPUUPeP1 ЬPՠԼ1[PРPxPRPPRPЬRP
x	16ТPxPRPPRPPRx	RRЬP<PPR1
ЬRբx	1 PТPxPRPPRPЬRP
x	1 ТPxPRPPRPPRx	RRЬP<PPR1 ЬR<QQWWQVPPVТPxPRPPRPYЬQ<XPPBYSQ< PWR
RP
Q{RPQPQSTQXPWR	RP	Q{RPQPQT*PYRx	RRXRQRPWRRPQP{RPQPQTVTUPP ^RЬPЬQ`gaca_a 9`_` 
P`_` a_a 
Qa_a PQPa*QR`aPPQ`a`_`*
P`_`*`
aa*RP2 P| ^Ь(߭$PЬU,߭e                                                                                                                                                                                                                                                   X                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              l "     {      PV:߭eR ߭eRPPG   K o o o o o o o ; o o o / o o o [ KP?PЬP`T=ЬP `T/PЬP ` TЬS<cR Rc T	VR1 ScRR RA1 RZ1 cPPD    i             5     M sPB?PЬR<bQ<TPPPQQQPbRPЬR<bQ<TPPPPPQQQPb7PЬR<bQ<TPxPPPPQQQPbPЬR<bQ<TPxPPPPQQQPbScPP 1KPA	PZ1<VR1`Pd^[GUY߭<~'*PPVVRBnQaޭԡVVRBnQaԡЭP<S VVRBnQSaЭP!ԡ߭ )PPЭP<S VVRBnQSaЭP!ԡVVRBnQaЭPԡVVRBnQaЬPԡVVRBnQa
>ԡЬSգ+BVVRBnQ/aУ#ԡգ3!VVRBnQã/+PPaУ3ԡVVRBnP`ԭЭSЬRcXХ<XWcЬPԭЬRRRRRRRխRYPPZnRbPTPPY4T$/nbPTPPT$nbPTPPЭPWXнХ<ZWP T$OTR9Sgal~k~j~g~i~h~k&z  RS߫z   嗢PP ^ERQ*QТ8PРPAPP   (?PPKPլCЬPРP9Ѡ3PТ8PPP"PPլЬPРP	ѠP?<~PPP ^ЬRТSЭRS5P<SRxRRЭQB%P `B!RbЬP԰SЭPS߭ q&PխSЭRS5P<SRxRRЭQB%P `B!RbЬP԰SЭPS  ^     ^ݬ     ^ݬ     ^P^ZCX>ԭ@,  @ Ш8R(;/ݬw  PU\~ݬw  PUUЬUUU)x  PUnԮT*TШ8RТSD%߭<~#%ЭRբUPТU
PDRbUU~<~ߪ1bUR<JY6WVQP|TS~STUPQV<W~<Y~	u  P[[SSSCb<SS
SʆbP| ,^]U*BTܰL||욬R
R1 1Pݭ.bH|~|~|~H PVPPVݭav  Џ3SPPuv  PSR<HPRS#v  R<HPRS<HSݭR3aSݭXa<HPPP|~ ߭ܟL PVP<PP4P}HP|~|~|~ P PVP<PPPPPP< ^S߭u  Pޭݬx߭u  ԭ߭u  PRR߭5`|~|~|~R PT9T	  Pխ&|~ ݭPUU߭UX`ÎQÆQQRT&߭RT+`×TNP<PP&߭RP_íTPPP  ^ԭݬt  PЬݬur  PP< P ^oR "#$t  Scc$ ?Ο |~ <q  2\L߭6cmc¢c($ ?Ο |~ <q  2\L((s  PΰP\\d 0|P2\\P\&QP\\<@(,	
@(PQP2\P\5s  SccMc(c±cc.cdcc|~߭|~<	p  \lݭc|~߭|~<lݭc|~߭|~<lݭc|~߭|~<lݭc|~߭|~<lݭc|~߭|~<lݭc|~߭|~<lݭc|~߭|~<lݭ'c|~߭|~<lݭ7c|~߭|~<lݭDc|~߭|~<lݭScac2 P x^RҐԐ՞ڭְ  z|}~߭?߭?ԭ Pq  |~z?|~8<~  PSPSB\P<PP  P<PPPíPP  PP ^ݬp  PSPc~p  RbPY   c~bPT   c~bP1Pc~o  RbPN   c~bPF   c~bP0P   P  ^ݬMp  PЬPPp     ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^ЬS	S޼R<~Sݬo  Pb޼R Sݬo  PbѼPP ^ ݬݬn  яPPЬRݬݬݬn  PbbPPP ^ ݬݬn  яPPЬRݬݬݬn  PbbPPP  ^ݬn  P   ^ЬR<QQ<PPQQ~  PbP ЬRbn  bP P ^լPЬQԡaСPP`РPP ^ռPмRТSPУRS_  SRSЬRbK    P< ^լPЬRТSGգ5<QQ<PPQ
Q~  PPУSԣТPУScS<Q<PPQPSP
PUe<TTUQмaPTݬU~m  cSbP ^լPЬRТSGգ5<QQ<PPQ
Q~  PPУSԣТPУScSЬT<Q<PPQPSPPddP`cSb P  ^լЬP   ^լЬQ< PPP  ^լPЬR2PPPP2Q<PQPPPPPQQb
bQPСQQbP<SS<PPSPQP
PTdPP0<PPPTPСQQbP
QT<~T~ݬk  P ^լPЬQ2PPPP2R<PRPPPPPRRa
aRPТRRaP<SS<PPSPRP
PTdPP0<PPPTPТRRaP
RTT P ^լPЬR2PPPPP2S<PSPТSSb<PPPPbS<PУSSbP<QQ<   PPQPSP
PTdPP@<P<PPPTУSSbP<QQ<PPQPSP
PT<~T~ݬi  P ^լPЬR2PPPPP2S<PSPТSSb<PPPPbS<PУSSbP<QQ<   PPQPSP
PTdPP@<P<PPPTУSSbP<QQ<PPQPSP
PTT P  ^լP P< P ^լPЬR<Q<PPQ P ^լPЬRWbUVЬTЬQQPTެScPPP<PPTTcPPWUbV   P ^լЬQ
2R<PRPaS<RR<PPRPSP
PTdPPc2PPPPd^լPЬSVЬRYPbY<YWXTfP<RQWPRRPQP{RPQPQXXT<TRЦVPT<TPQ<YP<RRRPRQPQ{RPPQQT<RR1 V1O<fPTXЦV1 
VUToPePPR<PUPP`*ЬPU`ЬR<XQ<PPQ<TPPQQPPbPѣV<Q<TPPQPP<PUPPUTTTXЦVV1h1 V1 f  WP<fPTXЦV1 
VUTyPePP\<~ݬ<PUPPPgP*ЬPU`ЬR<XQ<PPQ<TPPQQPPbPѣV<Q<TPPQPP<PUPPUTTTXЦVV1^< P ^լPЬRUWTU1 e  VP<ePTWХUk
USTXPcPP;ݬ<PSPPPfP
ЬPS`PѢU<Q<TPPQPP<PSPPSTTTWХUU< P^ԼլPЬTS<cPP<QQ<cPPQPXЬQ
SPXPPa<RR	Ѽ NRݱ ݬd  P9УS<cPPSR<QQ	ѼbPQRݬd  PP<cVVެR
SW<   U<QQVXQXXWPP U
в PѼ`P<~в P`ݬ4d  PPVP 4^)RS|հ͐ϐޭݭb-d  PSS<LPߢ߭d  ޭݭѰS|~|~|~ PQQ2QЭH/QP                                                                                                                                              P ,^.Sְc>|ԭ b  P|~ ߭ ߭  PP2P@cЬR<Rb  PRb  PRPP  P  ,^ְޭ>|ԭݬ{b  PЬ|~ ߭֟|~ PPP  $^ްޭ>|ԭ|~ ߭ ߬  PPP  ^ 6a   ,^ЬSްޭ>|ԭؐSa  PS|~ ߭ޟ|~ PPЭPPRPRPP`  < ^|UАԭԭ< <ԭԭԭԭԭ	ԭԭ
ԭ
ԭÔԭЬЬЬ$Ь Ь(Ь,Ь0Ь4Ь8Ь<Ь@ЬDЬHÐݬ`  ScPЬݬcPЬЬRސRcPRЬRR``  PR֐eG`  Pޥ<@
~|~ݬ̟߭լTTTլRRRWPSS5լL-RWPLPPa_  RRPSPP ^R+Sߢ_  P||~ ߣ,|~  PЬQңPPaPPaңPPPP.ңPP PP ңPP$PP$Q   $P ݬ P|~ ߣ,|~  PTTTPЬQңPPaPPaңPPPPQ!   $Pլ ݬ  TPP| ^OU
ORVЬSЬQacˡC^  SxSP@Td3xSQAP`PPPAbP`;^  SxSP@P`TxTP@Sc5PxTQAP`PPPAeP`C]  TxTP@P`                        < ,^Uԭԭ԰ޭޭ|ԭЬP`|~ < ~|~P PQPQP|~ ߭ ЬTd PSPdRRPQPQPSPdRRPQPQP2PѭdRRPQPQPSPߥe\  PRмSSPQPQPPݭߥR\  R\  2 P ,^S                                                                                                                                                                                                                                                   Y                        |E $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              : "           ֐ؐޭޭԼߣ;ߣ"K\  PRP߭ߣ=R[  R.\  ߭h\  P|~ ЬRRPPQPbQPP  ^ݬPQPQP2 P ^cRԭߢ@ݮ[  [  |~|~P0ݬ		PQPQP2P2 P ^R|~|~< ~1ݬ	PQPQP2Pߢ@ݮW[  2P@C[  P2 P ^RЬP`ߢ@P[  P   ,^R;Sޢn21 xc~ސcZ  cZ  Pc䟭XPP߭X  ߭zX  ѭ%~~S\l|~l}~lPѭ,ѭ%|~ \l}~l~~lPí\\}~c~PP ^QޭPPSPRQPQ`cQPQS`SQSPa`bP ^0ݬW  ЬRR߭߭W  PSSPPPPSR<DHW  ЭQRЭЏsaaRA~ݭLY  RPЏs`P  ^U0ݬݬV  Ŭ~   ^-0ݬݬV  ݬݬ.  ^0ݬV  ݬP ^߭߭V  PRRPPPPRݬICUV  ЭQЬRRЭЏsaaRA~ݭUX  RЏsbP ^ЬSS߭߭EV  PRRPPPPRS8CU  ЭQSЭЏsaaSA~ݭW  SPЏs`ЭR  RW  RP< ^]SЬPPRPPߣ8BUU  bsbbݬߣ~B2U  Ѣsݢݬ pBU  P`s``ݬFBT  RТTTݭF~ݭV  ߭߭T  PUUPPPPUݬTjAT  P ^eSЬPPRPPëA\T  bsbbݬA8T  Ѣsݢݬ@vAT  P`s``ݬÏLAS  RТUUЬRR߭߭T  PTTPPPPTRcAS  ЭQRЭЏsaaRA~ݭU  RPЏs`ЭTЬPUPURPRRWWݬTpU  ݭF~ݭcU  ߭߭"S  PVVPPPPVݬUd@R  TP                            ^S RΐАޭ֭Ұޭ>|ԭ|~ ߭|~  P	PwR  ݭߣߢT  ߢT  Pbޢ[   TTߣ߭_T  ߭iT  P|~Οb$R  P	PR  P  ^) \   Q    ^<J~Q                              $^߭ݬ  PP   P	   $^Rߢ߭ݬ  PPP  QPQQPP $^Rߢ߭ݬx  PPP  P $^URߢ߭ݬH  PPP  P  $^%\ް"ޭ>|ԭ|~ ߭|~  Pѭ߬R  P  ^\
߬
R   ^SRbk\\-P\PP-) I A 	f?PP\   /P|   "P\|/P-P-~ߣQ  < ^ SRߣ߭ݬ  PUP"ޭ>|ԭ|~ ߭|~  PѭbߣQ  b cQ  <PT XQ  PT1 U  Pb
ߣ
QQ  PbkQQ-PQPP-) I A 	F?PP\   /P|   "P\|/P-P-~ߣP  P   P  PT1Zb
ߣ
P  P< ^SRߣ߭ݬ  PUPߣ߭ݬ  PTP"ޭ>|ԭ|~ ߭|~  Pѭbߣ*P  bTU  Pb
ߣ
P  PU7  Pb
ߣ
O  PbkQQ-PQPP-) I A 	?PP\   /P|   "P\|/P-P-~ߣzO  =O  1HP< ^SRߣ߭ݬ|  PUP"ޭ>|ԭ|~ ߭|~  PѭbߣN  b N     PT N  PT1 U  Pb
ߣ
N  PbkQQ-PQPP-) I A 	?PP\   /P|   "P\|/P-P-~ߣJN  
N   N  PT1Zb
ߣ
$N  P ^ER氏ޭ>ԭ|~ |~ 0PݭߢݬM  PPP $^TլլPݬM  PRޭSݰޭ>ԭ|~ |~ 0PݭߤS~M  P߭M  PRRRPݬЬSS]M  Rb߭SbݬS SP ,^RՐאޭݭݬ.M  PRR<LPݬ߭M  ޭݭٰR|~|~|~ݬ    ,^RՐאޭݭݬL  PRR<LPݬ߭L  ޭݭٰR|~|~|~ݬ   4^|XWVЬTUޭͭTVL  PUU
<LS3PT߭(L  ޭͭU|~|~|~VWX PSSR2PQRPQQPP8^|XWVЬTUޭͭTK  PUU
<LS3PT߭K  ޭͭU|~|~|~VWX PSSR2PQRPQQ|~ ݭPPP ,^WЬVUЬSTޭխS)K  PTT	<LR2PS߭J  ޭխT|~|~|~UVW PRRPP
ЬRТP P  ^
ޭޭ𭸰ԭޭ|ԭ|ԭ|߭ݬ'PP|~ ݭԼP|~ ߭߭ PQP譨QH  PЭؼ|~ ݭP  ^RPb|~?H<P@b  P ^Џigԭ߭߬{G  PR ߭߯0߭  PRP	RiG  խ խP  ^|~ MRB   ^H  ݬݬ߯G  P  ^ W|~|~G  ݬݬPG  |~ tG   H   ^%R bPP ߢ\lP
@  @  ߢ%lP
@  ?  ߢ:lP
?  ?   ߢRlP
@  ?   ߢqP\\PP   $  $  P>?P\?  	P?   "  P   
LIB$GET_VM   LIB$SGET1_DD ALLOC        	ALLOC_OPT    
XMEMORY_ALLOCLIB$VM_ALLOC ???          
already freedLIB$FREE_VM  
LIB$SFREE1_DDFREE         FREE_OPT     XMEMORY_FREE LIB$VM_FREE  ???          
already freed  ЬQѡl  )ЬPѡ 	  lD  <	P  E  P  D  P  D  P  D  P  yD  P  D  P  yD  P  D  P  D  P  D  P  qD  P      P      P      P      P      P      P      P      P      P      P  E  P  QE  P  CE  P  E  P  +E  P  E  P  E  P  E  P  D  P  D  P      P      P      P      P      P      P      P      P/%FAKE_VM, symbol !AC in image !AC is revectored2%FAKE_VM, correcting transfer vector for !AC, etc.2%FAKE_VM, transfer vector for !AC, etc., corrected=%FAKE_VM, illegal transfer vector for symbol !AC in image !AC<    UTмSz3ЬP`*ѠVAXC RTL?  	PݬTLЬRb:ѢXTFR0EE(R0e~cPSмSRcePݬRĖ eԼP  	 mlA    ~^}~}A  6%FAKE_VM, failure to image activate !AC for symbol !AC<%FAKE_VM, register mask mismatch for symbol !AC in image !AC<   U^T^ЬScЬRb~ݬdPRSKeԼRSݬVPмPPQQQa`	Qe,%FAKE_VM, illegal exit vector for symbol !AC,%FAKE_VM, illegal exit vector for symbol !AC<%FAKE_VM, register mask mismatch for symbol !AC in image !AC<   U\TԼԼԼЬRbPݬT5?բm}~}~ϟ
ݬ-eRPSSRRRbRR}~ݬ!PRPSScbݬݬZeLIBRTL
LIB$GET_VMLIB$FREE_VMLIB$SGET1_DD
LIB$SFREE1_DD
LIB$SFREEN_DD
LIB$GET_EFLIB$FREE_EF
LIB$VM_MALLOC
LIB$VM_CALLOCLIB$VM_REALLOCLIB$VM_FREEDECC$SHRDECC$MALLOCDECC$CALLOCDECC$REALLOC	DECC$FREE
DECC$CFREEDECC$VAXC$MALLOC_OPTDECC$VAXC$CALLOC_OPTDECC$VAXC$REALLOC_OPTDECC$VAXC$FREE_OPTDECC$VAXC$CFREE_OPTVAXCRTLMALLOCCALLOCREALLOCFREECFREEVAXC$MALLOC_OPTVAXC$CALLOC_OPTVAXC$REALLOC_OPT
VAXC$FREE_OPTVAXC$CFREE_OPTDECW$XLIBSHRXMEMORY_MALLOCXMEMORY_CALLOCXMEMORY_REALLOCXMEMORY_FREEDECW$DWTLIBSHRXTFREEXTMALLOCXTCALLOC	XTREALLOC W8  VƤffƨfƬffffƴ ƴ ƴ Ƹ |Ƽ    | |   | , n   S?RARSZg1RS dg"RSngRSxgRS$ ǂgRS0,(ǌgRS<84ǖgRSHD@ǠgRSTPLǪgRS`\XǴgϵRSlhdǾg˦ưSϟRϣRSxtpgϔRSƄƀ|gυRSƐƌƈgwRSƜƘƔgfRSƨƤƠgVRSƴưƬgPRSƼƸgJRSgERSg=RS"g˦ƴS/R2RS,gRS6g
RS @gRSJgRS TgRS,($^gRS840hg϶RSD@<rgϬRSPLH|gϟRS\XTǆg˦ƸSόRϔRShd`ǐgψRStplǚg|RSƀ|xǤgqRSƌƈƄǮg˦ƼS\RfRSƼƸƴgRRSƘƔƐǸg@RSƤƠƜ                                                                                                                                                                                                                                                   Z                        6{ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           g.RSưƬƨg4%FAKE_VM, XMEMORY_* calls mapped into LIB$VM_* calls.%FAKE_VM, XT* calls mapped into LIB$VM_* calls/  [/  Z,  Y*  XR)  W/  V.  UU3  TLЬR  }<~8~b  }H~D~bP<5#  }T~P~b$  }`~\~bv%  }l~h~bT(&  }x~t~b'  }Ą~Ā~b$/  }Đ~Čb/  }Ĝ~Ęb/  }Ĩ~Ĥb /  }Ĵ~İbX1 W}~ļbX}~bY}~bU}~bU}~bZ}~b[}~b".  }~bV} ~bV},~(b\1 W}8~4bX}D~@bY}P~LbU}\~XbU}h~dbZ}t~pb[}Ā~|bv-  }Č~ĈbV}Ę~ĔbV}Ĥ~Ġb`1 ĴP,`PS"PPd4~  S-  }İ~Ĭb-  }ļ~ĸb-  }~b,  }~bdP,`PS"PPd4~ϙV  S,  }~b,  }~b{,  }~bo,  }~ b^ЬV{Xˏ  WjXˏ  VW( gWn|~P7( gXlЬ	Ь}~|~0P	P3   SϋR^~Ԯ@ m~cP	.  cЏ, P bHcP  ЬPРP^}~W^ЬVЬWˏ  WXˏ  VXi( hXn|~PA( hlЬ	gWP}~|~0P	P2   SςR^~Ԯ@ m~cP	~-  cЏ, P b	HcP  ЬPРP^}~N` mЬWXWXgV-  UUTdTTU3XTg-X d	VXTP-` dVXXgVP  ~^}~1   x mԼe-  QQTdTTQ_ѬTTPѬPT`PѬPѬPP-X dPTP-` dPPP  ~^}~&1  SYS$OUTPUT: 	+  WgWЬV, n P fPf@ ,0g45ЬW, n D gDgV<MemoryStringMallocMalOptXallocLibMal??????<free>FAKE_VM.LISStill active memory list:!6AC:    Size: !XL    Addr: !XL     No errors!+     From PC: !XL!6AC:    Size: !XL    Addr: !XL  Errors: !XL From PC: !XL        From PC: !XL From PC: !XL From PC: !XL From PC: !XL        From PC: !XL From PC: !XL From PC: !XL From PC: !XL        From PC: !XL From PC: !XL From PC: !XL From PC: !XL        From PC: !XL From PC: !XL From PC: !XL From PC: !XL !XL !XL !XL !XL !16AF !6XLFAKE_VM processing has been *disabled*All memory has been returnedSpecified address not in active listNo erring packets foundFAKE_VM string processing has been *disabled*FAKE_VM has announced !UL error!%S^|m~P	(   ~ϬSlϰPlP1|Zl#Ѭլ[ЬZl
[[hn4)  ЮVfVV1pZZZVVPZPn%ЮlPkn@ϳ<
9dݦݮ`ݦ PP@#dd0PP^dhlPq;d} ~}~dd,PP^dhlPq;϶d}0~}(~dd,PP^dhlPq;Ϫd}@~}8~dd,PP^dhlPD;Ϟd}P~}H~dd,PPkdhlPQ[1`XЦYWYYWyd`PPX~}W~hݨݨݨdd8
PPuWQQQPPQ@P, n PhdhlP;[1XWY1n%  %&ЮlP\1 nCZ$Z
#ЮlPs%  -"2d&  dd PP5dhlPlP
P
P0*  	P  ЬPРP^}~%%%%% Memory leaks! %%%%%Debugger (D), List (L), or file name? YnXu#  Wd^|m~iP	 h~
P)#PQPQP
Ѡ   @1 F)  P
P,)  n&7^(  PVVz gVWZnRRdD<l~(  gRlL	Rg(R PVgViVPiP  ЬPРP^}~`!UL bucket!%S of !UL byte!%S, !UL error!%S !9UL skipped |!XL !9UL |!#*X!#**!#*>!UL, !ULP[Z^ЬPYPXYЬR`"Р(RP:*nj<ЬPݠ}~kP"Э(RPx\!  PP	P  ;PЬTŏd   RPRRRXdWSSY1 CgRSPP@gSPQQ
?PSn*<QkPЬP"Э(PP1 ŏd   CgQRQPRPUUQ|UQXVPQUn9<UA CgŤS~k=ŤSU|PCgPQQSSPEnO<PUkPЬP"Э(PP
PK&  S1FAKE_VM.LISFAKE_VM processing has been *disabled*Memory size histogram:FAKE_VM string processing has been *disabled*String size histogram: TJ!  SϑR`^~Ԯ mn~dP	< 2\TPqPd@&<lլݬS~bSSbD#-
2Ю8P0bP
TP
P$  dP  ЬPРP\`^}~yFAKE_VM.LISFAKE_VM processing has been *disabled*Current inuse EFNs: !XL !XL EFN !UL allocated from PC !XL WPVUϼT!  S^|Um~gP	 dG|P,xP &p!tpЮtxePw1 hl^Pn?^ nhԮh ?dptP`ݮhݮphl΀ fPq`ЮdxeP^RBìP6ptP`PRhl΀ fP1`ЮdxeP?RxP
P
P"  gP  ЬPРP ^}~jFAKE_VM_LOG.LOG S  Rl^#🢰PXRPLnXP""Ю(RPRP	P!  EXAMINE/ASCIC FAKE_VM_MESSAGE   R^b~XP+W!  Pg<l~f!  P	PN!  3%FAKE_VM, histogram LIB$GET_VM failed: Status = !XL4%FAKE_VM, histogram LIB$FREE_VM failed: Status = !XL^ЬVǦWW1 xW  Pnn֦nZxЮYY[fZЮSYXX  <X(XjcXZXY[XX  <X, n XcX[f%ЮV  Pnn֦nrЮffPG`G`G`2%FAKE_VM, LIB$GET_VM incorrect argument count: !UL4%FAKE_VM, Bad leading guards: Size = !XL, Addr = !XL5%FAKE_VM, Bad trailing guards: Size = !XL, Addr = !XL9%FAKE_VM, Bad active list: Status = !XL, Last entry = !XL.%FAKE_VM, !AC failed: Status = !XL, Size = !XLr%FAKE_VM, !AC: Size: !XL, Addr: !XL, From PCs: !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL["  Z^|vm~P	@ ul$.lլ$ռ	l8jl~kTV]R	  PѢP/  PѢPTqv  PѢPj  PѢP]VТRТP  QPQ  QPQ4  QPQ  QPQ  QPQ  QPQ
VVVТR$I^^PYY     ) ; jnY jnP`ݠujnP`ݠϙkмXpn`9`3|~  PǏ   P~HP
P  ЮnY
^8PYY$jݮYVP@֟ϙkԼ1 1 nSЮXVQPRТPТRPQ SXWW  <W, nWcWX =nP}P~}H~}@~}8~}0~}(~} ~}~ݠ`ݠVF3֟R	YP  ЬPРP^}~3%FAKE_VM, LIB$FREE_VM incorrect argument count: !UL4%FAKE_VM, Bad leading guards: Size = !XL, Addr = !XL5%FAKE_VM, Bad trailing guards: Size = !XL, Addr = !XL9%FAKE_VM, Bad active list: Status = !XL, Last entry = !XL8%FAKE_VM, !AC not in active list: Size = !XL, Addr = !XL=%FAKE_VM, !AC not same size: Old = !XL, New = !XL, Addr = !XL1%FAKE_VM, !AC not same addr: Old = !XL, New = !XL8%FAKE_VM, !AC bad leading guards: Size = !XL, Addr = !XL9%FAKE_VM, !AC bad trailing guards: Size = !XL, Addr = !XL<%FAKE_VM, !AC freeing !AC allocation: Size = !XL, Addr = !XL1%FAKE_VM, !AC found bad active list: Status = !XLr%FAKE_VM, !AC: Size: !XL, Addr: !XL, From PCs: !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL !XL:%FAKE_VM, !AC failed: Status = !XL, Size = !XL, Addr = !XLi  [LZ^|gm~P	@ ^ۑl$0lլ&ռ!	lDkl~ʕ)ϲV]T  PѤP
l  PѤPq	  PѤPj  PѤP]VФTФP  QPQ  QPQ4  QPQ   QPQ  QPQ  QPQ
VVVФT$K^nPYY     ) = knY4* knP`ݠ)knP`ݠ)^мUUмSSϏPYY " : W q   kYVP@j+ϒk(VP@jn*|n\k(ЮPݠVP@jʧ*]?kU`   ~VP@j* k(VP@j+k(VP@jP+OnRV?,VV*$k( PP@VP@jʊ+'Vn                                                                                                                                                                                                                                                   [                        [x $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           P	V1 Џ, P SUPQTФQФTQ@PnP}P~}H~}@~}8~}0~}(~} ~}~ݠݼݼVP@j+ϚУ`!ЮXXWW  <W, nUWcWX`?`(nP|~P
P  	P^DPYYknݮYVFjl,ϰ	YP  ЬPРP^}~-4%FAKE_VM, LIB$SGET1_DD incorrect argument count: !UL5%FAKE_VM, LIB$SGET1_DD failed: Size = !XL, Addr = !XL=%FAKE_VM, LIB$SGET1_DD warning: Class not dynamic, Addr = !XL@%FAKE_VM, LIB$SGET1_DD warning: LIB$SFREE1_DD needed, Addr = !XL| V  UσT^~Ԯϼ m~fP	@ ulel~dSѼ   eݬݼdfЏ, PЬReRdբ eR%dR   PSS$'bݬ$PSSbԢfSP  ЬPРP^}~H5%FAKE_VM, LIB$SFREE1_DD incorrect argument count: !UL>%FAKE_VM, LIB$SFREE1_DD warning: Class not dynamic, Addr = !XL Џ, WVd  UT^| m~fP	@ ulel~>dSЬReR\dfWPբ<bnPSSWSbԢfSP  ЬPРP^}~5%FAKE_VM, LIB$SFREEN_DD incorrect argument count: !UL< UϖT^~ԮZ m~eP	   dlC
  l~ċSRBnd*PSSReSP  ЬPРP^}~H2%FAKE_VM, LIB$GET_EF incorrect argument count: !UL)%FAKE_VM, LIB$GET_EF failed: Status = !XL%FAKE_VM, EFN too big: !UL*%FAKE_VM, EFN !UL already allocated by !XL| Vi  UT^~Ԯu m~fP	 ul
l~dݬHPSSS3мRR?RLdBePPRTdЮBefSP  ЬPРP^}~3%FAKE_VM, LIB$FREE_EF incorrect argument count: !UL*%FAKE_VM, LIB$FREE_EF failed: Status = !XL%FAKE_VM, EFN too big: !UL%FAKE_VM, EFN !UL not allocated| V  UϗT^~Ԯp m~fP	 ul
l~ dмRݬTPSSS9R?RWdBe	RbdBefSP  ЬPРP^}~Ϩ.%FAKE_VM, MALLOC incorrect argument count: !UL S5R^|P m~cP	3	   bl	  l~Ь^¯PncnP  ЬPРP^}~.%FAKE_VM, CALLOC incorrect argument count: !ULYπX^|| m~iP	~   hl/	  l~ȋŬ^ȯP*nSЮWWVV  <V, n VcVЮWninP  ЬPРP^}~/%FAKE_VM, REALLOC incorrect argument count: !UL3%FAKE_VM, REALLOC with zero old address: Size = !XL<%FAKE_VM, REALLOC not in active list: Size = !XL, Addr = !XLA%FAKE_VM, REALLOC not same size: Old = !XL, New = !XL, Addr = !XL5%FAKE_VM, REALLOC not same addr: Old = !XL, New = !XL<%FAKE_VM, REALLOC bad leading guards: Size = !XL, Addr = !XL=%FAKE_VM, REALLOC bad trailing guards: Size = !XL, Addr = !XL5%FAKE_VM, REALLOC found bad active list: Status = !XL2%FAKE_VM, REALLOC free of old failed: Status = !XLc[^|m~P	   ul  l~kЬЮR  _  ݬk1Т@ЮSSPZZ  - G d t  %  ZkB  RSϷ/  RSЮPݠk  R`   ~kԮ!  RS%  RSRkЮVnìSRgЬ]P  QѠQ$  QѠQРPQSPРSРPSAQR  <R, nRF	VPЬ^$PZZOЮVKVYnSЦXXWW  <W(WicWYWX㟮PZZ  Zkn	nP  ЬPРP^}~,%FAKE_VM, FREE incorrect argument count: !UL TϑS^|e m~dP	   cl@  l~ËRЬnnPР^m$PP, RdRP  ЬPРP^}~:  P  lϵ  lb  l	  lA  P  lϐ  l=  l  l  P  lk  l  lϿ RlPRRP  P                                                                                                                                                                                                                                                                                                                                                                                                            P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                      "               x        
  
       H  H    0  @  8  (  8        	      (
  
  
    P
    0
  P              (   h   p   x            X                  p      P     (       X  `  h  x            8  p	  x    0  H  X
  P
                   	             
             A            |  t        
        $      T      D             d                 L        L   &  $   \   L  L   L  l   <   |   D             d     d    D    t    |                       8
  ,
  0
        
                 @                                                                       
PWVN$CACHE                                                     LIBRTL                                                         MTHRTL                                                         PWRK$XTILIBSHR                                                 
PWRK$CSSHR                                                     	SECURESHR                                                      
SECURESHRP                                                     PWRK$CMTLIBSHR                                                 PWRK$LICENSE_LIBSHR                                            PWRK$STREAMSSHR                                                VAXCRTL                                      Ծ ؾ ܾ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     START pM 	PGETINT32 <    M AllocReadWriteBuffer N AllocReadWriteBuffer_1     5N AllocReadWriteBuffer_2         @N AllocPacketPool bN AllocPacketPool_3     }N AllocPacketPool_4     N AllocPacketPool_5     H    N GetMinIntVal N GetMinIntVal_6 N GetMinIntVal_7         ?    N GetStringActive N GetStringActive_8 0    S    O mymemset *    HO fsp$main O 
fsp$main_9     O fsp$main_10     O fsp$main_11         P 
InitialThread eP InitialThread_145 8    P InitialThread_146 8    P InitialThread_147 Q InitialThread_142 Q InitialThread_143     ,    <    0Q InitialThread_148 @Q InitialThread_136 ZQ InitialThread_137     .    >    Q InitialThread_149 Q InitialThread_133     9    Q InitialThread_150 Q InitialThread_134     6    Q InitialThread_151 R InitialThread_140 "R InitialThread_141                                                                                                                                                                                                                                                   \                        C $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              Պ "                ,    <    VS InitialThread_12     S InitialThread_13     S InitialThread_14 k    #T InitialThread_15 ;    jT InitialThread_16 T InitialThread_17     T InitialThread_18     T InitialThread_19 4U InitialThread_20 	    \    kU InitialThread_21     U InitialThread_22     D   U InitialThread_23     U InitialThread_24      V InitialThread_25     V InitialThread_26     V InitialThread_27 V InitialThread_28     #    jW InitialThread_29     W InitialThread_30 W InitialThread_31 W InitialThread_32             HX InitialThread_33 RX InitialThread_34     !    X InitialThread_35 X InitialThread_36         X InitialThread_37 X InitialThread_38     #    LY InitialThread_39 RY InitialThread_40         Y InitialThread_41 Y InitialThread_42     '    Y InitialThread_174 Y InitialThread_144     -    Y InitialThread_43 Y InitialThread_44     "    *Z InitialThread_45 4Z InitialThread_46     &    iZ InitialThread_47 sZ InitialThread_48     #    [ InitialThread_49 #    q[ InitialThread_50 [ InitialThread_51     <    [ InitialThread_52     [ InitialThread_53      \ InitialThread_54 5\ InitialThread_55     \ InitialThread_56 \ InitialThread_57 \ InitialThread_58         -    \ InitialThread_59     ] InitialThread_60     ^ InitialThread_61 K    h^ InitialThread_62 &    ^ InitialThread_63     ^ InitialThread_64 ^ InitialThread_65     _ InitialThread_66 _ InitialThread_67     $_ InitialThread_68     3    ~    (   Y_ InitialThread_69 c_ InitialThread_70 
        _ InitialThread_71 _ InitialThread_175 _ InitialThread_112 `        @` InitialThread_72         l` InitialThread_73     ` InitialThread_74      #a InitialThread_75     La InitialThread_176 {a InitialThread_109     Y    a InitialThread_177     2b InitialThread_76 !    e InitialThread_77 e InitialThread_78 *    e InitialThread_178 3    f InitialThread_179 6    Sf InitialThread_79         tf InitialThread_80 }f InitialThread_81 v      h InitialThread_180 $h InitialThread_138 >h InitialThread_139     +    ;    h InitialThread_82     h InitialThread_83 h InitialThread_84 h InitialThread_85      i        {i InitialThread_86     i InitialThread_87 i InitialThread_88 i InitialThread_89     `        ej InitialThread_90     j InitialThread_91 j InitialThread_92 j InitialThread_93     b        8k InitialThread_94     pk InitialThread_181 k InitialThread_113 k InitialThread_114 "            -l InitialThread_95     kl InitialThread_96     l InitialThread_97     l InitialThread_98     m InitialThread_99     8m InitialThread_100 K    m InitialThread_101     !n InitialThread_102     
o InitialThread_182 m    wo InitialThread_183 o InitialThread_118     o InitialThread_119     [    o InitialThread_103     
p InitialThread_184     !p InitialThread_104 Kp InitialThread_105     <    |p InitialThread_106     p InitialThread_107     p InitialThread_185 g    Kq InitialThread_108     \!   pq 
ServerDown Er ServerDown_186 
       ,s 
SetupShutDown     Hs ShutdownProc ,    ts 
PowerfailProc     s SetupMemory s SetupMemory_109     `    s 
SpawnTLThread ^    Ht SpawnSAPThread ^    t GetConfiguredVolHostPath# t GetConfiguredVolHostPath_110# t GetConfiguredVolHostPath_111     0    L    t IsValidServerName u IsValidServerName_112 ]    t    hu VerifyExistenceOfNWDirs" u VerifyExistenceOfNWDirs_113" u VerifyExistenceOfNWDirs_114 "    z        v SaveServerStats By SaveServerStats_115 *     SaveServerStats_116       & $ SavePotentialAutoConnectClients     4 AutoConnectClients     D 
DownMsgThread _ DownMsgThread_117     O     CreateDownMsgThread Ӂ CreateDownMsgThread_118     ׁ CreateDownMsgThread_119 
    P     
enable_xqp c enable_xqp_120      enable_xqp_121     ͂ enable_xqp_122 2     enable_xqp_123     =    $ enable_multi_threaded_xqp$ c enable_multi_threaded_xqp_124    $  enable_multi_threaded_xqp_125    $  enable_multi_threaded_xqp_126$   enable_multi_threaded_xqp_127$ * enable_multi_threaded_xqp_128     <    d   $ Q enable_multi_threaded_xqp_129$ p enable_multi_threaded_xqp_130$  enable_multi_threaded_xqp_131     <    c   $  enable_multi_threaded_xqp_132     8   \ getSpecialObjLimit ~ getSpecialObjLimit_133     B     get_FSLR_Login  get_FSLR_Login_134     ?     get_BYPASS_Lic  get_BYPASS_Lic_135     ?      
set_PTS_PANIC < set_PTS_PANIC_136 V set_PTS_PANIC_137     .    M    p set_EraseDiskBlocks  set_EraseDiskBlocks_138  set_EraseDiskBlocks_139     +    J     set_LogLoginInfo ؆ set_LogLoginInfo_140  set_LogLoginInfo_141     ,    K     set_DiagnoseHeap $ set_DiagnoseHeap_142 > set_DiagnoseHeap_143     ,    K    T getMaxConnectionsAllowed# u getMaxConnectionsAllowed_144     9   		pM  ?   	              :                                                                      @                      &                                                    
 
 
         
	 
 
   	           
    .     
   
       D   	     
          	                       	    AE  	PGETINT32 <    ̇ InitAsyncEvents  InitAsyncEvents_1     ! InitAsyncEvents_2     ] InitAsyncEvents_3     8 InitAsyncEvents_4 ;        CheckBroadcastMsgs  CheckBroadcastMsgs_5                                                                                                                                                                                                                                                          ]                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              H "             CheckEngineCount     ̊ CheckConnectionsInLimbo   CheckConnectionsInLimbo_6   CheckConnectionsInLimbo_7     4    T   "   CheckClientLegalConnectTime$ | CheckClientLegalConnectTime_8$  CheckClientLegalConnectTime_9%  CheckClientLegalConnectTime_10 7   % ' CheckClientLegalConnectTime_11 *    t   %  CheckClientLegalConnectTime_12 t       E  $ h CheckConnectionUpdateSecurity'   CheckConnectionUpdateSecurity_13'   CheckConnectionUpdateSecurity_14' 
  CheckConnectionUpdateSecurity_35 7    >   ' T  CheckConnectionUpdateSecurity_15' [  CheckConnectionUpdateSecurity_16 
           T    
CheckShmUsage  CheckShmUsage_17 #    , CheckShmUsage_18 4        h WatchdogConnections  WatchdogConnections_19  WatchdogConnections_20 ԏ WatchdogConnections_21 ُ WatchdogConnections_22 "      WatchdogConnections_23 
         WatchdogConnections_24            R    PollWatchdogPackets ؐ PollWatchdogPackets_25 ` PollWatchdogPackets_26  PollWatchdogPackets_27 !    Y    ͑ PollWatchdogPackets_28  PollWatchdogPackets_29 '    0 PollWatchdogPackets_30          PollWatchdogPackets_31 O          ܒ SendWatchdogPacket      AddMoreNWEnginesIfNeeded    !  SyncClientLegalConnectTime$  SyncClientLegalConnectTime_32    $  SyncClientLegalConnectTime_33     K    ԓ CheckVolDiskSpace     ܓ SyncConnectionTables 
     AsyncCloseFiles 
     AsyncDestroyConnection    
  getlnm  	getlnm_34 
         DiagnoseConnInfo  DiagnoseConnInfo_36  DiagnoseConnInfo_34 
    z        ` DiagnoseCloseOpenFile    		  !    
  
	     	 
		    
        	
          " 	   
          	 
 			
	 	  
    SYSCFG h 	PGETINT32 <     GetSystemConfig x     PutSystemConfig f PutSystemConfig_1        		h I     
     
    SAP  	PGETINT32 <     	SAPThread ; SAPThread_1      SAPThread_2     ֗ SAPThread_3      SAPThread_4     0 SAPThread_5     Q SAPThread_6     j SAPThread_44 S     SAPThread_45 l     SAPThread_46  SAPThread_32  SAPThread_47              SAPThread_7 - SAPThread_8 6 SAPThread_9     !     SAPThread_10 ӛ SAPThread_11  SAPThread_12 0 SAPThread_13          H SAPThread_14 O SAPThread_48 Z SAPThread_43          SAPThread_49  SAPThread_43         c        -         М 
SpawnSAPTimer Z    , 	AddServer d AddServer_15  AddServer_16     D     AddServer_17 h AddServer_18 s AddServer_19 6    D     AddServer_20  AddServer_21      AddServer_22            9   h DeleteServer  DeleteServer_23  DeleteServer_24     0         
UpdateServers D UpdateServers_25  UpdateServers_26  UpdateServers_50  UpdateServers_23  UpdateServers_24     ,            L UpdateServers_27 0     UpdateServers_28  UpdateServers_51 Z    Z           Timer  Timer_29 , Timer_30     N Timer_52 ͢ Timer_32 ͢ Timer_53              Timer_31         	    SendSAP  
SendSAP_32  
SendSAP_54              PingNPSProcs p     TrackOut (    8 TrackIn x     UpdateObjectTable  UpdateObjectTable_33  UpdateObjectTable_34  UpdateObjectTable_35 T    \ UpdateObjectTable_36 	    t             SAPShutDown  SAPShutDown_55  SAPShutDown_37  SAPShutDown_56             ( SAPShutDown_57 n         SendShutDownSAP 6 SendShutDownSAP_37 6 SendShutDownSAP_58             H TrackControl a TrackControl_38 g TrackControl_39       TrackControl_40     ;     TrackControl_41  TrackControl_42              Ч TrackService  TrackService_43     +   		/               	           	     	  	              	          	                	     MESSAGE_LOGGER  
MsgInitialize 0 MsgInitialize_16 M     MsgInitialize_1      MsgInitialize_2  MsgInitialize_3     3     MsgInitialize_4  MsgInitialize_17  MsgInitialize_18 M    5 MsgInitialize_15          MsgInitialize_19  MsgInitialize_20 K    թ MsgInitialize_15         # MsgInitialize_21 J    q MsgInitialize_5      MsgInitialize_22 M           MsgClose  
MsgClose_6     1     	MsgInform D MsgInform_7     W MsgInform_8 g MsgInform_9 l MsgInform_10      MsgInform_11     A     MsgInform_12 	    ̫ MsgInform_13              	MsgPrintf . MsgPrintf_14     _    H 
CreateFile [ 
CreateFile_23 F     
CreateFile_15          Interactive H   		~
                                         
    VOLCFG 0 	PGETINT32 <    l 
VMSGetPhysVol    p VCF_Initialize  VCF_Initialize_1      VCF_Initialize_2     > VCF_Initialize_3     l VCF_Initialize_4      VCF_Initialize_5     ǯ VCF_Initialize_17 ͯ VCF_Initialize_6      VCF_Initialize_7            P 
load_vol_recs y load_vol_recs_6      load_vol_recs_7          get_vol_rec_and_add , get_vol_rec_and_add_8 A get_vol_rec_and_add_9     $    d get_vol_rec_and_add_10      get_vol_rec_and_add_11  get_vol_rec_and_add_12      get_vol_rec_and_add_13  get_vol_rec_and_add_14     9        b get_vol_rec_and_add_15        Բ get_vol_rec_from_index   get_vol_rec_from_index_16     ]   		0  ,                                      )         	BINCFGFIL 4 read_bin_cfg p read_bin_cfg_1  read_bin_cfg_2     1        ĳ 
write_bin_cfg  write_bin_cfg_3  write_bin_cfg_4         Z   		4 ?     
    NCPXDR    TLTHREAD $ 	PGETINT32 <    ` TransListenerThread  TransListenerThread_1      TransListenerThread_2      TransListenerThread_3  TransListenerThread_4  TransListenerThread_5     #    ^ TransListenerThread_6      TransListenerThread_7  TransListenerThread_8 ĵ TransListenerThread_9 !    J    o    l TransListenerThread_10  TransListenerThread_11 
     TransListenerThread_12  TransListenerThread_13       TransListenerThread_19                                                                                                                                                                                                                                                    ^                        	f $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            TransListenerThread_17      TransListenerThread_18     q    : TransListenerThread_14 = TransListenerThread_20 .    J         TransListenerThread_15     G    TransListenerThread_16        }     CreateNewConnectionThread#  CreateNewConnectionThread_17    # < CreateNewConnectionThread_18     x    X SendImmediateResponse /   		B$                               	     	           TPACKET  InitTransportPacketPool   InitTransportPacketPool_1     R    ܸ GetFreeTransportPacket  GetFreeTransportPacket_2 
 GetFreeTransportPacket_3     2    p    L ReleaseTransportPacket D     AllocatePacketPool  AllocatePacketPool_4     ͹ AllocatePacketPool_5     й AllocatePacketPool_6     H    ع dbg$dump_readpool t dbg$dump_readpool_7 t dbg$dump_readpool_9  dbg$dump_readpool_8 ?    r    r    4    dbg$dump_readbuffer H dbg$dump_readbuffer_8 ?       		 ʹ 
        	              NCP_MAIN  	PGETINT32 <    ػ NCPEngineThread t NCPEngineThread_1 Ƽ NCPEngineThread_2 3 NCPEngineThread_3      3 NCPEngineThread_4 > NCPEngineThread_5 %    1     NCPEngineThread_6       NCPEngineThread_7 ʽ NCPEngineThread_8 %    1    9 NCPEngineThread_9 T NCPEngineThread_10      T NCPEngineThread_11 _ NCPEngineThread_12 $    0              %     
logInvalidNCP 8 logInvalidNCP_13 O      		  l 	                                   ACCT  	PGETINT32 <   !  NCPGetCurrentAccountStatus# E NCPGetCurrentAccountStatus_1          NCPSubmitAccountCharge F NCPSubmitAccountCharge_5 <     NCPSubmitAccountCharge_6 <    % NCPSubmitAccountCharge_2         NCPSubmitAccountHold  NCPSubmitAccountHold_7 5    N NCPSubmitAccountHold_3         NCPSubmitAccountNote  NCPSubmitAccountNote_4     \  		w  .     =   E   6   
    DIR H 	PGETINT32 <     NCPSetDirectoryHandle  NCPSetDirectoryHandle_1      NCPSetDirectoryHandle_2  NCPSetDirectoryHandle_3          NCPSetDirectoryHandle_4  NCPSetDirectoryHandle_5  NCPSetDirectoryHandle_6     '    >       \ NCPGetADirectoryPath " NCPGetADirectoryPath_7        l NCPCreateDirectory  NCPCreateDirectory_8      NCPCreateDirectory_9     w NCPCreateDirectory_10      NCPCreateDirectory_11 # NCPCreateDirectory_12     C     NCPCreateDirectory_13  NCPCreateDirectory_14  NCPCreateDirectory_15 G               8 NCPDeleteDirectory  NCPDeleteDirectory_16      NCPDeleteDirectory_17     # NCPDeleteDirectory_18     p NCPDeleteDirectory_19         NCPRenameDirectory  NCPRenameDirectory_20     8  !  NCPSetDirectoryInformation$  NCPSetDirectoryInformation_66 7   $  NCPSetDirectoryInformation_21    $ . NCPSetDirectoryInformation_22     P   h NCPGetADirectoryEntry $ NCPGetADirectoryEntry_23     ? NCPGetADirectoryEntry_67 7    v NCPGetADirectoryEntry_68 7    $  &  NCPSetDirectoryEntryInformation)  "NCPSetDirectoryEntryInformation_24 -   ) v "NCPSetDirectoryEntryInformation_25 L   )  "NCPSetDirectoryEntryInformation_26    )   "NCPSetDirectoryEntryInformation_27    )  "NCPSetDirectoryEntryInformation_28    )  "NCPSetDirectoryEntryInformation_29)  "NCPSetDirectoryEntryInformation_30    )  "NCPSetDirectoryEntryInformation_31     J   )  "NCPSetDirectoryEntryInformation_32)  "NCPSetDirectoryEntryInformation_33)  "NCPSetDirectoryEntryInformation_34     
   ) & "NCPSetDirectoryEntryInformation_35    ) 5 "NCPSetDirectoryEntryInformation_36) ; "NCPSetDirectoryEntryInformation_37        ) O "NCPSetDirectoryEntryInformation_38) W "NCPSetDirectoryEntryInformation_39        ) s "NCPSetDirectoryEntryInformation_40    )  "NCPSetDirectoryEntryInformation_41    )  "NCPSetDirectoryEntryInformation_42    )  "NCPSetDirectoryEntryInformation_43        )  "NCPSetDirectoryEntryInformation_44)  "NCPSetDirectoryEntryInformation_45 $    2   ) 	 "NCPSetDirectoryEntryInformation_46)  "NCPSetDirectoryEntryInformation_47) , "NCPSetDirectoryEntryInformation_69 9    I    c   ) w "NCPSetDirectoryEntryInformation_48)  "NCPSetDirectoryEntryInformation_49 $    5   )  "NCPSetDirectoryEntryInformation_50)  "NCPSetDirectoryEntryInformation_70 9   )  "NCPSetDirectoryEntryInformation_51        ) > "NCPSetDirectoryEntryInformation_52) K "NCPSetDirectoryEntryInformation_53 $    :   ) | "NCPSetDirectoryEntryInformation_54    )  "NCPSetDirectoryEntryInformation_55 !   )  "NCPSetDirectoryEntryInformation_56     )  "NCPSetDirectoryEntryInformation_57)  "NCPSetDirectoryEntryInformation_58) 	 "NCPSetDirectoryEntryInformation_59 [   ) h "NCPSetDirectoryEntryInformation_60 a           )  "NCPSetDirectoryEntryInformation_61 S      $ D NCPGetNewDirectoryInformation     < NCPMoveFileDir { NCPMoveFileDir_62      NCPMoveFileDir_63      NCPMoveFileDir_64     s NCPMoveFileDir_65       !  NCPAllocPermanentDirHandle     ` NCPAllocTempDirHandle      NCPDeAllocateDirHandle <   # , NCPAllocSpecialTempDirHandle    		H             
        
                                                                     
                                                                                   $    
    	        BINDERY  	PGETINT32 <     NCPLoginUser 1 NCPLoginUser_1     s NCPLoginUser_2          NCPChangeUserPassword  NCPChangeUserPassword_3     y NCPChangeUserPassword_4          NCPGetMemberSetOfGroup $     NCPLoginObject  NCPLoginObject_5      NCPLoginObject_6         NCPCreateObject  NCPCreateObject_7          NCPDeleteObject  NCPDeleteObject_8     r NCPDeleteObject_9  NCPDeleteObject_10 q           , NCPRenameObject o NCPRenameObject_11         ( NCPGetObjectNumber S NCPGetObjectNumber_12      NCPGetObjectNumber_43 <        NCPGetObjectName  NCPGetObjectName_44 7     NCPGetObjectName_45 5    L    
NCPScanObject / NCPScanObject_13     D                                                                                                                                                                                                                                                    _                        ʐ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              q` "           NCPScanObject_46 <     NCPScanObject_47 >        NCPChangeObjectSecurity!  NCPChangeObjectSecurity_14          NCPCreateProperty  NCPCreateProperty_15         NCPDeleteProperty  NCPDeleteProperty_16           NCPChangePropertySecurity#  NCPChangePropertySecurity_17         NCPScanProperty  NCPScanProperty_18     . NCPScanProperty_48 7     NCPScanProperty_19      NCPScanProperty_20      NCPScanProperty_21      . NCPScanProperty_49 5    (    NCPReadPropertyValue  NCPReadPropertyValue_22     4    NCPWritePropertyValue R NCPWritePropertyValue_23      NCPWritePropertyValue_24 ( NCPWritePropertyValue_25 N    k        NCPVerifyObjectPassword!  NCPVerifyObjectPassword_26    !  NCPVerifyObjectPassword_27     $    NCPChangeObjectPassword! # NCPChangeObjectPassword_28    !  NCPChangeObjectPassword_29          NCPKeyedChangePassword   NCPKeyedChangePassword_30       NCPKeyedChangePassword_31          NCPKeyedVerifyPassword   NCPKeyedVerifyPassword_32          NCPIsObjectManager <     NCPListObjectRelations  " NCPListObjectRelations_33      4 NCPListObjectRelations_50 7    t   < NCPAddObjectToGroup  NCPAddObjectToGroup_34     Q NCPAddObjectToGroup_35     ` NCPAddObjectToGroup_36      NCPAddObjectToGroup_37 o    8   t NCPDeleteObjectFromGroup"  NCPDeleteObjectFromGroup_38    "  NCPDeleteObjectFromGroup_39 k         NCPIsObjectInGroup  NCPIsObjectInGroup_40          NCPOpenBindery 4    T NCPCloseBindery 4     NCPGetBinderyAccessLevel"  NCPGetBinderyAccessLevel_41    "  NCPGetBinderyAccessLevel_51 7        H NCPGetObjectAccessLevel! b NCPGetObjectAccessLevel_52 7         NCPGetLogKey `    @  
NCPKeyedLogin n  NCPKeyedLogin_42        		   
  0     	             	     
  	          '       "                  
    
   
 	     
   	       
           
               	
 
    COMMON   	PGETINT32 <    0 CommonHasSubTreeRights | CommonHasSubTreeRights_1  CommonHasSubTreeRights_2  CommonHasSubTreeRights_3     P    \         CommonDirSearch N CommonDirSearch_4 R CommonDirSearch_5 
        \ CommonDirSearch_6  CommonDirSearch_7  CommonDirSearch_8     8    N CommonDirSearch_9 1    #       CommonDirectoryReadAhead (   $  CommonGetDirEntryAndCachePath'   CommonGetDirEntryAndCachePath_10'   CommonGetDirEntryAndCachePath_11     E   '    CommonGetDirEntryAndCachePath_12    ' 9  CommonGetDirEntryAndCachePath_13         \ CommonAllocHandle $ CommonAllocHandle_14 N CommonAllocHandle_15 m CommonAllocHandle_16     2    \    A    CommonLogin  CommonLogin_17 
     CommonLogin_18  CommonLogin_19         5 CommonLogin_20      CommonLogin_21  CommonLogin_22  CommonLogin_23     '    W    6 CommonLogin_24      CommonLogin_25     : CommonLogin_26 ? CommonLogin_27         Q CommonLogin_28 f CommonLogin_29 p CommonLogin_30 6     CommonLogin_31     V    	 CommonLogin_32     	 CommonLogin_33 1	 CommonLogin_34     g	 CommonLogin_35     W       	 CommonLogin_36 	 CommonLogin_37 	 CommonLogin_38     ,    B    	 CommonLogin_39  
 CommonLogin_40 +
 CommonLogin_41     4
 CommonLogin_113 5    i
 CommonLogin_114 6    
 CommonLogin_42 
 CommonLogin_115 3    E     CommonLogin_43        +   T CommonLogin_44 \ CommonLogin_45 ` CommonLogin_116 5    9    K     CommonLogin_46  CommonLogin_47  CommonLogin_48         '    d CommonLogin_49  CommonLogin_50  CommonLogin_51  CommonLogin_52 
        l         CommonLogin_53 m    o
 CommonLogin_54 D    D   
 CommonLogout g    L CommonLogoutResources  CommonLogoutResources_55      CommonLogoutResources_56           CommonDestroyConnection <    L CommonChangePassword B     CommonOpenFileFork  CommonOpenFileFork_57     G CommonOpenFileFork_58 -     CommonOpenFileFork_59      CommonOpenFileFork_60      CommonOpenFileFork_61        D CommonCreateFileFork  CommonCreateFileFork_62      CommonCreateFileFork_63      CommonCreateFileFork_64     < CommonCreateFileFork_65      CommonCreateFileFork_66 $     CommonCreateFileFork_67  CommonCreateFileFork_68  CommonCreateFileFork_69     <     CommonCreateFileFork_70 $    h       H CommonMoveEntry  CommonMoveEntry_71 !     CommonMoveEntry_72  CommonMoveEntry_73  CommonMoveEntry_74  CommonMoveEntry_75     #     CommonMoveEntry_76     ^      CommonMoveEntry_77  CommonMoveEntry_78     N     CommonMoveEntry_79      CommonMoveEntry_80  CommonMoveEntry_81  CommonMoveEntry_82  CommonMoveEntry_83     1     CommonMoveEntry_84 < CommonMoveEntry_85     D CommonMoveEntry_86 g CommonMoveEntry_87     *    V        p CommonMoveEntry_88  CommonMoveEntry_89     ,         CommonMoveEntry_90  CommonMoveEntry_91     &     CommonMoveEntry_92  CommonMoveEntry_93     !          @ CommonDeleteFile  CommonDeleteFile_94  CommonDeleteFile_95     M    $ CommonDeleteFile_96 A CommonDeleteFile_97     t CommonDeleteFile_98      CommonDeleteFile_99             pwvn_acquire_lic > pwvn_acquire_lic_100      pwvn_acquire_lic_101 J         pwvn_release_lic  pwvn_release_lic_102      pwvn_release_lic_103  pwvn_release_lic_104     '    > pwvn_release_lic_105         d LRMsgLogoutEveryone p LRMsgLogoutEveryone_117 ~ LRMsgLogoutEveryone_102      LRMsgLogoutEveryone_103  LRMsgLogoutEveryone_104     ,     LRMsgLogoutEveryone_105 !             pwvn_common_acquire_lic"  pwvn_common_acquire_lic_106     " i pwvn_common_acquire_lic_107"  pwvn_common_acquire_lic_118"  pwvn_common_acquire_lic_100    "  pwvn_common_acquire_lic_101 J           " G pwvn_common_acquire_lic_108     n   h pwvn_common_release_lic"  pwvn_common_release_lic_109    "  pwvn_common_release_lic_110    "  pwvn_common_release_lic_111"  pwvn_common_release_lic_119"  pwvn_common_release_lic_102    "  pwvn_common_release_lic_103"  pwvn_common_release_lic_104     ,   " B pwvn_common_release_lic_105                                                                                                                                                                                                                                                              `                        	 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              
 "            " w pwvn_common_release_lic_112     *  		    
                        
         

            
             
              ߮                                             
    	                              	        	  	               	 	                                                       CONNECT  	PGETINT32 <   !  NCPCreateServiceConnection#  NCPCreateServiceConnection_1    #  NCPCreateServiceConnection_2     N  "   NCPDestroyServiceConnection$ 6 NCPDestroyServiceConnection_3$ J NCPDestroyServiceConnection_4      5         NCPGetInternetAddress  NCPGetInternetAddress_5     x       NCPGetUserConnectionList! ;  NCPGetUserConnectionList_6    ! m  NCPGetUserConnectionList_7    !   NCPGetUserConnectionList_8    !   NCPGetUserConnectionList_9        !   NCPGetObjectConnectionList$ ;! NCPGetObjectConnectionList_10    $ i! NCPGetObjectConnectionList_11    $ ! NCPGetObjectConnectionList_12         ! NCPClearConnectionNumber" ! NCPClearConnectionNumber_13    " 3" NCPClearConnectionNumber_14" T" NCPClearConnectionNumber_15    " a" NCPClearConnectionNumber_16 P        0   # NCPGetStationLoggedInfo!  # NCPGetStationLoggedInfo_17    ! M# NCPGetStationLoggedInfo_18    ! y# NCPGetStationLoggedInfo_19! }# NCPGetStationLoggedInfo_20    ! # NCPGetStationLoggedInfo_21     ?   ! # NCPGetStationLoggedInfo_22 @   ! # NCPGetStationLoggedInfo_23 7      		   
                          
ǹ                      	DISKLIMIT $ 	PGETINT32 <   ! % NCPScanAVolObjectDiskLimit# *% NCPScanAVolObjectDiskLimit_7 7   # x% NCPScanAVolObjectDiskLimit_1# % NCPScanAVolObjectDiskLimit_2# % NCPScanAVolObjectDiskLimit_3 
       # % NCPScanAVolObjectDiskLimit_8 7   # % NCPScanAVolObjectDiskLimit_9 5        d  ! p& NCPAddAnObjectVolDiskLimit$ & NCPAddAnObjectVolDiskLimit_10 5   $ & NCPAddAnObjectVolDiskLimit_11 5   # ' NCPAddAnObjectVolDiskLimit_4        $ \' NCPRemoveAnObjectVolDiskLimit' z'  NCPRemoveAnObjectVolDiskLimit_12 7   & ' NCPRemoveAnObjectVolDiskLimit_5        ! ( NCPGetDiskLimitByDirHandle$ ( NCPGetDiskLimitByDirHandle_13 5   $ ( NCPGetDiskLimitByDirHandle_14 5    P  ! T) NCPSetDiskLimitByDirHandle $     x) NCPGetObjectLimitByVolume# ) NCPGetObjectLimitByVolume_15 5        X* NCPGetDiskUtilization v* NCPGetDiskUtilization_16 <    * NCPGetDiskUtilization_6 * NCPGetDiskUtilization_17 <    o      % p+ NCPGetObjectRemainingDiskSpace( + !NCPGetObjectRemainingDiskSpace_18 <   ( + !NCPGetObjectRemainingDiskSpace_19 <       		v$        *
              X       NFILE \, 	PGETINT32 <    , 
NCPCommitFile D    , NCPOpenFileOLD - NCPOpenFileOLD_38 >    (   / NCPCloseFile     / 
NCPCreateFile / NCPCreateFile_39 9    +0 NCPCreateFile_40 9    d0 NCPCreateFile_41 9    0 NCPCreateFile_42 9    0 NCPCreateFile_43 9    M1 NCPCreateFile_1     H   1 NCPOpenCreateFile 2 NCPOpenCreateFile_2     2 NCPOpenCreateFile_3      2 NCPOpenCreateFile_4     "3 NCPOpenCreateFile_5     3 NCPOpenCreateFile_44 9     4 NCPOpenCreateFile_45 9    94 NCPOpenCreateFile_46 9    r4 NCPOpenCreateFile_47 9    4 NCPOpenCreateFile_48 9    "5 NCPOpenCreateFile_6        5 NCPEraseFile 	6 NCPEraseFile_7     x6 NCPEraseFile_8     0   6 
NCPRenameFile 7 NCPRenameFile_9     <8 NCPRenameFile_10     `8 NCPRenameFile_11     $   8 NCPSetFileAttributes 9 NCPSetFileAttributes_12     9 NCPSetFileAttributes_13     9 NCPSetFileAttributes_14     9 NCPSetFileAttributes_15     0: NCPSetFileAttributes_16     : NCPSetFileAttributes_17     : NCPSetFileAttributes_18         ; NCPGetCurrentFileSize P; NCPGetCurrentFileSize_49 7        ; NCPReadFile ; NCPReadFile_50 7    r< NCPReadFile_19     < NCPReadFile_20        T= NCPWriteFile = NCPWriteFile_51 5    > NCPWriteFile_21     $   x> NCPServerFileCopy > NCPServerFileCopy_52 5    > NCPServerFileCopy_53 5    ? NCPServerFileCopy_54 5    ? NCPServerFileCopy_55 5    l   ? NCPSetFileTimeDateStamp     @ NCPOpenFile A NCPOpenFile_56 9    	B NCPOpenFile_22        B NCPCreateNewFile B NCPCreateNewFile_57 9    C NCPCreateNewFile_23       " pD NCPSetFileExtendedAttribute% E NCPSetFileExtendedAttribute_24    % ;E NCPSetFileExtendedAttribute_25% CE NCPSetFileExtendedAttribute_26        % ^E NCPSetFileExtendedAttribute_27    % E NCPSetFileExtendedAttribute_28    % F NCPSetFileExtendedAttribute_29    % CF NCPSetFileExtendedAttribute_30        F NCPSetFileInformation G NCPSetFileInformation_58 7    QH NCPSetFileInformation_31     XH NCPSetFileInformation_32 4    H NCPSetFileInformation_33     [I NCPSetFileInformation_34     I NCPSetFileInformation_35     <   I NCPPurgeAllErasedFiles $    I NCPGetSparseFileBitMap  J NCPGetSparseFileBitMap_59 5     qJ NCPGetSparseFileBitMap_36      J NCPGetSparseFileBitMap_60 5     K NCPGetSparseFileBitMap_61 5       K NCPDupHandle K NCPDupHandle_37     i   		\,  
 
 
    	,        #                                                )
   )     ]       
   
                                                                                                                                                                                                                                                       a                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            -           "              
M  
	      	FUNCTABLE K 	PGETINT32 <    (L NCPPrintServices @    hL NCPMessageServices @    L NCPDirectoryServices @     L NCPBinderyAndMiscServices (    M NCPPNWSpecific <    LM NCPSemaphoreServices @   % M NCPTransactionTrackingServices =   		K k  

	    FILELOCK M 	PGETINT32 <    N 
NCPLogFile N NCPLogFile_1      JO NCPLogFile_2     p   xO NCPLockFileSet O NCPLockFileSet_3         P NCPReleaseFile P NCPReleaseFile_4     $   0Q NCPReleaseFileSet @    pQ NCPClearFile R NCPClearFile_5     $   R NCPClearFileSet =   		M                                LOGLOCK R 	PGETINT32 <    S NCPLogLogicalRecord pS NCPLogLogicalRecord_1     S NCPLogLogicalRecord_2         S NCPLockLogicalRecordSet  KT NCPLockLogicalRecordSet_3         |T NCPClearLogicalRecord T NCPClearLogicalRecord_4     t    T NCPReleaseLogicalRecord  U NCPReleaseLogicalRecord_5     t   ! dU NCPReleaseLogicalRecordSet @    U NCPClearLogicalRecordSet =   		vR ù        	      
  
        PHYSLOCK U 	PGETINT32 <     V NCPLogPhysicalRecord bV NCPLogPhysicalRecord_3 5    V NCPLogPhysicalRecord_4 5    W NCPLogPhysicalRecord_1     ,   LW NCPLockPhysicalRecordSet! W NCPLockPhysicalRecordSet_2         W NCPReleasePhysicalRecord! X NCPReleasePhysicalRecord_5 5   ! MX NCPReleasePhysicalRecord_6 5       " X NCPReleasePhysicalRecordSet @    X NCPClearPhysicalRecord 0Y NCPClearPhysicalRecord_7 5    eY NCPClearPhysicalRecord_8 5         Y NCPClearPhysicalRecordSet =   		wU  
 
      	      	  	      	SEMAPHORE Z 	PGETINT32 <    PZ NCPOpenASemaphore uZ NCPOpenASemaphore_1     Z NCPOpenASemaphore_3 6         [ NCPExamineASemaphore :[ NCPExamineASemaphore_4 7        [ NCPWaitOnASemaphore [ NCPWaitOnASemaphore_5 5    [\ NCPWaitOnASemaphore_2         \ NCPSignalASemaphore \ NCPSignalASemaphore_6 7        ] NCPCloseASemaphore &] NCPCloseASemaphore_7 7       		wZ  
   
  	         MESSAGE ] 	PGETINT32 <    ] NCPSendBroadcastMessage  ^ NCPSendBroadcastMessage_1      $^ NCPSendBroadcastMessage_2  -^ NCPSendBroadcastMessage_3      `^ NCPSendBroadcastMessage_4  l^ NCPSendBroadcastMessage_5         `        ^ NCPGetBroadcastMessage 
_ NCPGetBroadcastMessage_6     Q_ NCPGetBroadcastMessage_7         p_ NCPDisableBroadcasts 8    _ NCPEnableBroadcasts 8    _ NCPBroadcastToConsole _ NCPBroadcastToConsole_8     `    @` NCPSendConsoleBroadcast  u` NCPSendConsoleBroadcast_9    ! ` NCPSendConsoleBroadcast_10    ! ` NCPSendConsoleBroadcast_11! ` NCPSendConsoleBroadcast_12! ` NCPSendConsoleBroadcast_13     (    E   ! a NCPSendConsoleBroadcast_14! a NCPSendConsoleBroadcast_15! Ja NCPSendConsoleBroadcast_16     J    Y    U  		]       	      
 	
 	           NCP_MISC a 	PGETINT32 <    a NCPVerifySerialization 8   " b NCPGetFileServerInformation 4    @d NCPGetNetworkSerialNumber# Wd NCPGetNetworkSerialNumber_16 <         d NCPCheckConsolePrivileges L   $ $e NCPGetServerDescriptorStrings   " <f NCPSetFileServerDateAndTime$ kf NCPSetFileServerDateAndTime_1     l     f NCPDisableFileServerLogin" f NCPDisableFileServerLogin_2     X     g NCPEnableFileServerLogin! +g NCPEnableFileServerLogin_3     X   " Xg NCPGetFileServerLoginStatus$ g NCPGetFileServerLoginStatus_4     d   $ g NCPDisableTransactionTracking& g NCPDisableTransactionTracking_5     X   # h NCPEnableTransactionTracking% ?h NCPEnableTransactionTracking_6     X    lh NCPDownFileServer h NCPDownFileServer_7     h NCPDownFileServer_8 h NCPDownFileServer_9         h NCPDownFileServer_10     h NCPDownFileServer_11        " i NCPGetFileServerDateAndTime <    Pi NCPNegotiateBufferSize  i NCPNegotiateBufferSize_12         $j NCPEndOfJob j NCPEndOfJob_13         j 	NCPLogout #k NCPLogout_14 ?        pk NCPGetStationNumber k NCPGetStationNumber_15 	    l    k NCPGetFileServerStats k NCPGetFileServerStats_17 K    Yl NCPGetFileServerStats_18 K    l NCPGetFileServerStats_19 <     m NCPGetFileServerStats_20 <    |m NCPGetFileServerStats_21 <    m NCPGetFileServerStats_22 <    4n NCPGetFileServerStats_23 <    n NCPGetFileServerStats_24 <    n NCPGetFileServerStats_25 <    Ho NCPGetFileServerStats_26 <    o NCPGetFileServerStats_27 <     p NCPGetFileServerStats_28 <    \p NCPGetFileServerStats_29 <    p NCPGetFileServerStats_30 <    q NCPGetFileServerStats_31 <    pq NCPGetFileServerStats_32 <    q NCPGetFileServerStats_33 <    (r NCPGetFileServerStats_34 ;       r NCPGetFileServerTTS r NCPGetFileServerTTS_35 <    r NCPGetFileServerTTS_36 <    Ys NCPGetFileServerTTS_37 <    s NCPGetFileServerTTS_38 <    t NCPGetFileServerTTS_39 <    mt NCPGetFileServerTTS_40 <    t NCPGetFileServerTTS_41 <       4u NCPGetFileServerSync Eu NCPGetFileServerSync_42 <    u NCPGetFileServerSync_43 <    u NCPGetFileServerSync_44 <    Yv NCPGetFileServerSync_45 <    v NCPGetFileServerSync_46 <    w NCPGetFileServerSync_47 <    mw NCPGetFileServerSync_48 <    w NCPGetFileServerSync_49 <    %x NCPGetFileServerSync_50 <    x NCPGetFileServerSync_51 <    x NCPGetFileServerSync_52 <    9y NCPGetFileServerSync_53 <    p   y NCPGetSharedMemoryInfo  y NCPGetSharedMemoryInfo_54 <     z NCPGetSharedMemoryInfo_55 <     mz NCPGetSharedMemoryInfo_56 <    2  		a   7 
 
          	  	  
	            	  '	    
   	  ڹ
    NSPACE z 	PGETINT32 <    { NCPReturnNameSpaceInfo   % ,| NCPGetO                                                                                                                                                                                                                                                   b                        + $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              .y "     %      therNameSpaceDirEntries' b|  NCPGetOtherNameSpaceDirEntries_1    ' }  NCPGetOtherNameSpaceDirEntries_3 7   ' }  NCPGetOtherNameSpaceDirEntries_4 7         NCPOpenDataStream I NCPOpenDataStream_2        		zz ڹ  
 
            
       
    PLMPFS  PWVN_getFileId ?     
PWVN_getDevId 1 PWVN_getDevId_1 (    Ā PWVN_getDevId_2     ڀ PWVN_getDevId_3      PWVN_getDevId_4      PWVN_getDevId_5  PWVN_getDevId_6     - PWVN_getDevId_7     H    Z  		 R             PRINT ` 	PGETINT32 <     NCPWriteToASpoolFile p     NCPCloseSpoolFile <    H NCPSetSpoolFileFlags q NCPSetSpoolFileFlags_1  NCPSetSpoolFileFlags_2     ,     NCPSetSpoolFileFlags_3        L NCPSpoolADiskFile      NCPCreateSpoolFile  NCPCreateSpoolFile_4          ܄ NCPGetPrinterQueue   NCPGetPrinterQueue_5 7       		x`   	  L               
	      QUEUE  	PGETINT32 <     NCPCreateQueue / NCPCreateQueue_1     5 NCPCreateQueue_33 7        NCPDestroyQueue  NCPDestroyQueue_34 7         8 NCPReadQueueCurrentStatus# X NCPReadQueueCurrentStatus_35 7   "  NCPReadQueueCurrentStatus_2    " ӈ NCPReadQueueCurrentStatus_3#  NCPReadQueueCurrentStatus_36 7        <   t NCPSetQueueCurrentStatus"  NCPSetQueueCurrentStatus_37 7   ! ԉ NCPSetQueueCurrentStatus_4          NCPCreateQueueJobAndFile" 3 NCPCreateQueueJobAndFile_38 5   ! y NCPCreateQueueJobAndFile_5    "  NCPCreateQueueJobAndFile_39 7   "  NCPCreateQueueJobAndFile_40 7   " ̋ NCPCreateQueueJobAndFile_41 7   ! Y NCPCreateQueueJobAndFile_6       #  NCPCloseFileAndStartQueueJob& C NCPCloseFileAndStartQueueJob_42 7   %  NCPCloseFileAndStartQueueJob_7          NCPRemoveJobFromQueue  NCPRemoveJobFromQueue_43 7     NCPRemoveJobFromQueue_8          NCPGetQueueJobList ߎ NCPGetQueueJobList_44 7    $ NCPGetQueueJobList_9     R NCPGetQueueJobList_10 c       Џ NCPReadQueueJobEntry  NCPReadQueueJobEntry_45 7    k NCPReadQueueJobEntry_11      NCPReadQueueJobEntry_46 7    ͐ NCPReadQueueJobEntry_47 7     NCPReadQueueJobEntry_48 7       d NCPChangeQueueJobEntry   NCPChangeQueueJobEntry_49 7      NCPChangeQueueJobEntry_12   NCPChangeQueueJobEntry_13   NCPChangeQueueJobEntry_14   NCPChangeQueueJobEntry_15      j NCPChangeQueueJobEntry_16       NCPChangeQueueJobEntry_17       NCPChangeQueueJobEntry_18                 ޓ NCPChangeQueueJobEntry_19       NCPChangeQueueJobEntry_50 7      NCPChangeQueueJobEntry_51 7      NCPChangeQueueJobEntry_52 7    l   Е NCPAttachServerToQueue   NCPAttachServerToQueue_53 7     0 NCPAttachServerToQueue_20        $ l NCPDetachQueueServerFromQueue'   NCPDetachQueueServerFromQueue_54 7   ' ̖  NCPDetachQueueServerFromQueue_21          NCPServiceQueueJob 9 NCPServiceQueueJob_55 7     NCPServiceQueueJob_22     ՗ NCPServiceQueueJob_23 ՗ NCPServiceQueueJob_56 7     NCPServiceQueueJob_57 7    C NCPServiceQueueJob_58 7       |  !  NCPFinishServicingQueueJob$  NCPFinishServicingQueueJob_59 7   $ I NCPFinishServicingQueueJob_24          NCPAbortServicingQueueJob#  NCPAbortServicingQueueJob_60 7   # ! NCPAbortServicingQueueJob_25         \ NCPChangeToClientRights! w NCPChangeToClientRights_61 7   !  NCPChangeToClientRights_26        " , NCPRestoreQueueServerRights     & L NCPReadQueueServerCurrentStatus) { "NCPReadQueueServerCurrentStatus_62 7   )  "NCPReadQueueServerCurrentStatus_63 5   )  "NCPReadQueueServerCurrentStatus_27    ) 
 "NCPReadQueueServerCurrentStatus_28       % X NCPSetQueueServerCurrentStatus( s !NCPSetQueueServerCurrentStatus_64 7   (  !NCPSetQueueServerCurrentStatus_29          NCPGetQueueJobFileSize  # NCPGetQueueJobFileSize_65 7      NCPGetQueueJobFileSize_30       NCPGetQueueJobFileSize_31   NCPGetQueueJobFileSize_66 5      NCPGetQueueJobFileSize_67 5            NCPChangeQueueJobOrder  ß NCPChangeQueueJobOrder_68 7     - NCPChangeQueueJobOrder_32        		          
	            
    	              	     
     	  	     	    A          SALVAGE l 	PGETINT32 <     NCPRestoreSalvagableFile!  NCPRestoreSalvagableFile_1     D    NCPPurgeSalvagableFile  NCPPurgeSalvagableFile_2         NCPScanSalvagedFiles ݣ NCPScanSalvagedFiles_3 9     NCPScanSalvagedFiles_4 9    O NCPScanSalvagedFiles_5 9     NCPScanSalvagedFiles_6 7      		tl                 &                     
    SEARCH  	PGETINT32 <    H NCPDirectorySearch  NCPDirectorySearch_1 5     NCPDirectorySearch_2 4    p NCPDirectorySearch_3     ˧ NCPDirectorySearch_4      NCPDirectorySearch_5     ! NCPDirectorySearch_26 9    Z NCPDirectorySearch_27 9     NCPDirectorySearch_28 9     NCPDirectorySearch_6 ?    ȩ NCPDirectorySearch_7        $ NCPAltDirectorySearch  NCPAltDirectorySearch_8 5     NCPAltDirectorySearch_9      NCPAltDirectorySearch_29 9    ֫ NCPAltDirectorySearch_30 9     NCPAltDirectorySearch_31 9     NCPAltDirectorySearch_10 K    P NCPAltDirectorySearch_11 '    ~ NCPAltDirectorySearch_12 b        NCPFileSearchInitialize     NCPFileSearchContinue  NCPFileSearchContinue_13      NCPFileSearchContinue_32 9     NCPFileSearchContinue_33 9    q NCPFileSearchContinue_14      NCPFileSearchContinue_15 B    ز NCPFileSearchContinue_16 ?      " P NCPScanDirectoryInformation% H NCPScanDirectoryInformation_17% e NCPScanDirectoryInformation_18     )   %  NCPScanDirectoryInformation_19    %  NCPScanDirectoryInformation_20    % 8 NCPScanDirectoryInformation_21    %   NCPScanDirectoryInformation_34 9    u   ȶ NCPSearchForAFile з NCPSearchForAFile_22     z NCPSearchForAFile_35 9    T NCPSearchForAFile_23     +    NCPScanFileInformation    NCPScanFileInformation_24       NCPScanFileInformation_36 9     [ NCPScanFileInformation_37 9     ¼ NCPScanFileInformation_25     v  		}  2)                                                                                                                                                                                                                                                                               c                        9h $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     6             
                          !     
 8	             3	      
      *  ѹ        #               TRUSTEE l 	PGETINT32 <     NCPAddTrusteeToDirectory" ٽ NCPAddTrusteeToDirectory_25 7   !  NCPAddTrusteeToDirectory_1    !  NCPAddTrusteeToDirectory_2       $ T NCPDeleteTrusteeFromDirectory' |  NCPDeleteTrusteeFromDirectory_26 7   & ) NCPDeleteTrusteeFromDirectory_3& < NCPDeleteTrusteeFromDirectory_4         x  "  NCPScanDirectoryForTrustees$  NCPScanDirectoryForTrustees_5    $  NCPScanDirectoryForTrustees_6    %  NCPScanDirectoryForTrustees_27 7    $     NCPScanObjectTrusteePaths# M NCPScanObjectTrusteePaths_28 7   "  NCPScanObjectTrusteePaths_7    "  NCPScanObjectTrusteePaths_8"  NCPScanObjectTrusteePaths_9              NCPScanTrusteesForFileDir# i NCPScanTrusteesForFileDir_10    #  NCPScanTrusteesForFileDir_11    #  NCPScanTrusteesForFileDir_12     P  % 8 NCPAddExtendedTrusteeToFileDir( o !NCPAddExtendedTrusteeToFileDir_29 7   ( 1 !NCPAddExtendedTrusteeToFileDir_13    ( z !NCPAddExtendedTrusteeToFileDir_14    (  !NCPAddExtendedTrusteeToFileDir_15(  !NCPAddExtendedTrusteeToFileDir_16     g      & H NCPGetEffectiveRightsByDirEntry)  "NCPGetEffectiveRightsByDirEntry_17    )   "NCPGetEffectiveRightsByDirEntry_18) & "NCPGetEffectiveRightsByDirEntry_19) 9 "NCPGetEffectiveRightsByDirEntry_20 !    4    U    H  "  NCPRemoveTrusteeFromFileDir%  NCPRemoveTrusteeFromFileDir_30 7   % e NCPRemoveTrusteeFromFileDir_21% x NCPRemoveTrusteeFromFileDir_22        %  NCPRemoveTrusteeFromFileDir_23       % @ NCPGetEffectiveDirectoryRights(  !NCPGetEffectiveDirectoryRights_24       ! \ NCPModifyMaximumRightsMask   		wl  
               4         %                             
                                  
    TTS h 	PGETINT32 <     NCPIsTTSAvailable $     NCPBeginTransaction $     NCPEndTransaction $     NCPAbortTransaction $    4 NCPTransactionStatus $   " X NCPGetApplicationThresholds ,   "  NCPSetApplicationThresholds $   "  NCPGetWorkstationThresholds ,   "  NCPSetWorkstationThresholds $     NCPGetTransactionBits $     NCPSetTransactionBits $   		zh Ź        
   
         UNKNOWN @ 	PGETINT32 <    | NCPUnknownRequest (     
NCPOS2Request    		@ (      
NCP_VOLUME  	PGETINT32 <   !   NCPGetVolumeInfoWithHandle# 9 NCPGetVolumeInfoWithHandle_1         NCPGetVolumeInformation   NCPGetVolumeInformation_2    ! - NCPGetVolumeInformation_19 7      ! L NCPGetVolumeInfoWithNumber# u NCPGetVolumeInfoWithNumber_3        d NCPGetVolumeNumber  NCPGetVolumeNumber_4          NCPGetVolumeName C NCPGetVolumeName_5     i NCPGetVolumeName_6 .       !  NCPGetNewVolumeInformation#  NCPGetNewVolumeInformation_7          
NCPSyncVolume  NCPSyncVolume_8      NCPSyncVolume_9   NCPSyncVolume_10     z NCPSyncVolume_11     e     NCPSyncVolume_12  NCPSyncVolume_13      NCPSyncVolume_14 9 NCPSyncVolume_15 ? NCPSyncVolume_16             d NCPSyncVolume_17          NCPSyncVolume_18       		           C
       
       
      
    h                       SPECIAL  	PGETINT32 <     UpgradeHybridUser 1 UpgradeHybridUser_1      UpgradeHybridUser_2        		x 7 &           LASTPKT  	PGETINT32 <     InitNCPPool . 
InitNCPPool_1     l 
InitNCPPool_2          GetFreeNCPPacket  GetFreeNCPPacket_3  GetFreeNCPPacket_4      GetFreeNCPPacket_5     G    `     GetLostNCPPacket  GetLostNCPPacket_6  GetLostNCPPacket_7     -    G    @ SaveLostPacketLength X SaveLostPacketLength_8 y SaveLostPacketLength_9     /    P   		} W '   +   -  *      PRIVFUNC  	PGETINT32 <     Watchdog  
Watchdog_1     "     LockMgr 	 	LockMgr_2 #    q   		y =           	     EXTERNS    EVENT d 	PGETINT32 <     
StartupEvents p StartupEvents_35          ShutDownEvents      
InitEvents (     
ScheduleEvent  ScheduleEvent_1     	 ScheduleEvent_2  ScheduleEvent_3         @ ScheduleEvent_4 M ScheduleEvent_5         c ScheduleEvent_6 h ScheduleEvent_7 
     ScheduleEvent_8  ScheduleEvent_9  ScheduleEvent_10 6    D    `     ScheduleEvent_11  ScheduleEvent_12              s ScheduleEvent_13 s ScheduleEvent_14     )        RegisterAsEventAgent  RegisterAsEventAgent_36  RegisterAsEventAgent_28     ,    , RegisterAsEventAgent_15 
     RegisterAsEventAgent_16  RegisterAsEventAgent_17 "     RegisterAsEventAgent_18  RegisterAsEventAgent_19  RegisterAsEventAgent_20  RegisterAsEventAgent_21  RegisterAsEventAgent_22     	        J RegisterAsEventAgent_23     h RegisterAsEventAgent_24 z RegisterAsEventAgent_25          RegisterAsEventAgent_26      RegisterAsEventAgent_27 
            W   
    
ValidateAgent  ValidateAgent_28     3     dbg_dump_event_slots p dbg_dump_event_slots_29 x dbg_dump_event_slots_30  dbg_dump_event_slots_31  dbg_dump_event_slots_32  dbg_dump_event_slots_33 !    -    M     dbg_dump_event_slots_37             < dbg_dump_event_slots_34     P   ` 
print_time $   		d  
 $(M                <    晹                                                                                                                                                                                                                                                           d                        ,( $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              e "     G                     SPOOLER  	PGETINT32 <     StartupSpooler 	 StartupSpooler_1     > StartupSpooler_2     ^ StartupSpooler_3          ShutDownSpooler      InitSpooler      CloseSpoolFile  CloseSpoolFile_4      CloseSpoolFile_5      CloseSpoolFile_6 +    ,    CreateSpoolFile  CreateSpoolFile_7 ( CreateSpoolFile_8     0 CreateSpoolFile_9     I     CreateSpoolFile_10      CreateSpoolFile_11 %     CreateSpoolFile_12     c   @ GetPrinterQueuesInternal"  GetPrinterQueuesInternal_13     A    GetPrinterQueues 4     SpoolADiskFile  SpoolADiskFile_14  SpoolADiskFile_15      SpoolADiskFile_16     6 SpoolADiskFile_17     `     SpoolADiskFile_18  SpoolADiskFile_19           SpoolADiskFile_20  SpoolADiskFile_21     I       H WriteToASpoolFile  WriteToASpoolFile_22  WriteToASpoolFile_23 	     WriteToASpoolFile_24      WriteToASpoolFile_25     a    t WriteToASpoolFile_26 I        AddPrinterToSystem  AddPrinterToSystem_27  AddPrinterToSystem_28      AddPrinterToSystem_29 * AddPrinterToSystem_30 
    $    v        DeletePrinterFromSystem! H DeletePrinterFromSystem_31    !  DeletePrinterFromSystem_32    !  DeletePrinterFromSystem_33!  DeletePrinterFromSystem_34         !  DeletePrinterFromSystem_35    ! 0 DeletePrinterFromSystem_36 8        ScanPrinters & ScanPrinters_37     ` ScanPrinters_38      ScanPrinters_39 M        GetNumberOfPrinters  GetNumberOfPrinters_40          AssignQueueToPrinter  AssignQueueToPrinter_41  AssignQueueToPrinter_42      AssignQueueToPrinter_43  AssignQueueToPrinter_44 
 AssignQueueToPrinter_45         /    ( AssignQueueToPrinter_46 B AssignQueueToPrinter_47 N AssignQueueToPrinter_48 "    p AssignQueueToPrinter_49     4    P     AssignQueueToPrinter_50      AssignQueueToPrinter_51         AssignQueueToPrinter_52         RemoveQueueFromPrinter   RemoveQueueFromPrinter_53   RemoveQueueFromPrinter_54       RemoveQueueFromPrinter_55   RemoveQueueFromPrinter_56   RemoveQueueFromPrinter_57   RemoveQueueFromPrinter_58  ( RemoveQueueFromPrinter_59 "    N    e    n          RemoveQueueFromPrinter_60       RemoveQueueFromPrinter_61          RemoveQueueFromPrinter_62          SpoolFinish / SpoolFinish_63     P SpoolFinish_64      SpoolFinish_65      W  		|   	              
                     
 
            
           	              	               	                                                  
d                  
HYBRID_USR < 	PGETINT32 <    x InitHybridStructs 5     AssignHostUserInfo L AssignHostUserInfo_16 Y AssignHostUserInfo_15     +     AssignHostUserInfo_1      AssignHostUserInfo_2 J    _ AssignHostUserInfo_3  AssignHostUserInfo_4  AssignHostUserInfo_5 J     AssignHostUserInfo_6 _ AssignHostUserInfo_7  AssignHostUserInfo_8       AssignHostUserInfo_9 *           ~   k       ReadIdentifiers  ReadIdentifiers_10 1  ReadIdentifiers_11     L  ReadIdentifiers_12 .          ReadIdentifiers_13   ReadIdentifiers_14     K    *     FreeHybridMemory 
 FreeHybridMemory_15     1   		J<  ,    	                               =                  NPMISC_MISC 4 	PGETINT32 <    p GetMyProcessIdentifier      SetPriorityLevel      NWSleep    		4 0   7  
    SIGNAL  	PGETINT32 <     
SignalProcess      EnterCriticalSection      ExitCriticalSection      
TurnOffSignal      TurnOnSignal    		 2           TIME  ConvertToUsableTime D    P GetTimeInMinutes 4     GetTimeInSeconds      	GetNWTime W   		f 7 	  
     ALLOC  StartupAllocMem  StartupAllocMem_1       StartupAllocMem_12            ShutDownAllocMem     ( 	ShmOffset     4 IsInSharedMemory     @ GetCurrentShmUsage     X 
GetMaxShmUsed     p GetRecentMaxShmUsed      
GetShmSize      IncShmUsage 0     DecShmUsage      ResetRecentMaxShmUsed      GetAllocRunningTotal      nwalloc  	nwalloc_2      	nwalloc_3 !       
  nwfree  nwfree_4      nwfree_5 	    X     	nwrealloc 4 nwrealloc_6 4 nwrealloc_13 G nwrealloc_4     i nwrealloc_5 	    >    A     nwrealloc_7      nwrealloc_8  nwrealloc_14  nwrealloc_4     ! nwrealloc_5 	    >    g    5 nwrealloc_9 Z nwrealloc_15 m nwrealloc_4      nwrealloc_5 	    >    g        nwcalloc *     LocalMemoryCheck  LocalMemoryCheck_10     8     allocateMemory      
freeMemory  
freeMemory_11        		]	                        	   	      (       MEMPOOL 0 
CreateMemPool  CreateMemPool_1          DestroyMemPool  DestroyMemPool_2     D     ShutDownMemPool + ShutDownMemPool_3     (    @ MemPoolAlloc p MemPoolAlloc_4      MemPoolAlloc_5  MemPoolAlloc_6 ,     MemPoolAlloc_7 -    	 MemPoolAlloc_8 
    /	 MemPoolAlloc_9 A	 MemPoolAlloc_24     F    	 MemPoolAlloc_25     J   	 MemPoolAlloc_10 '    +
 MemPoolAlloc_26        \
 MemPoolFree 
 MemPoolFree_11 "    
 MemPoolFree_12 #    
 MemPoolFree_27     
 MemPoolFree_13 
 MemPoolFree_14      MemPoolFree_15     ?        X IncUsage     t DecUsage      CoalesceMemPool  CoalesceMemPool_16  CoalesceMemPool_17 #     CoalesceMemPool_18 #     CoalesceMemPool_19             8 ShowMemPool  ShowMemPool_20          ValidateMemPool 
 ValidateMemPool_21 
 ValidateMemPool_22     7
 ValidateMemPool_23     D    h   		,	0  	          	                                                                                                                                                                                                                                                                                 e                        o $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              u "     X                	DISKQUOTA X
 	PGETINT32 <    
 StartupDiskQuota     
 ShutDownDiskQuota     
 
InitDiskQuota     
 ScanObjectDiskQuota 
 ScanObjectDiskQuota_1     ?    
 AddObjectDiskQuota #     RemoveObjectDiskQuota #    4 GetObjectDiskQuota ,    ` GetObjectCurrentDiskUse &   		X
 e 	    	      QUEFILE  	PGETINT32 <     
OpenQueueFile a OpenQueueFile_1  OpenQueueFile_2      OpenQueueFile_3      OpenQueueFile_4  OpenQueueFile_5     D       , OpenQueueFile_6 p OpenQueueFile_7     k     OpenQueueFile_51  OpenQueueFile_8     J    ^   $ OpenJobFile : OpenJobFile_52     j     LoadQueueStatus  LoadQueueStatus_8     [     LoadQueueIndex  LoadQueueIndex_9 2 LoadQueueIndex_10     '    w LoadQueueIndex_11          CloseQueueFile  CloseQueueFile_12     ~     DeleteQueue 0 DeleteQueue_53  DeleteQueue_12     ~    x   | AddJobRecord  AddJobRecord_13      AddJobRecord_14      AddJobRecord_15 # AddJobRecord_16     H     AddJobRecord_17  AddJobRecord_18 
         AddJobRecord_54 /       , 
CreateJobFile @ CreateJobFile_19     N CreateJobFile_55      CreateJobFile_20      CreateJobFile_21          
EnqueueJob  
EnqueueJob_56 K          
DequeueJob 7 
DequeueJob_22 ;     
DequeueJob_23       
DequeueJob_57 3         RemoveJobFromIndex h RemoveJobFromIndex_24 ,     RemoveJobFromIndex_25 2     RemoveJobFromIndex_26 %       < ResequenceQueue  ResequenceQueue_27 ,     ResequenceQueue_28 -    `    
ServiceJob  
ServiceJob_29      
ServiceJob_30 
 
ServiceJob_31     + 
ServiceJob_32 T 
ServiceJob_33       
ServiceJob_34  
ServiceJob_35      N    T           FindNextJob   FindNextJob_36   FindNextJob_37 -! FindNextJob_38 ;! FindNextJob_39 6    D            #   ! UpdateQueueFile @    ! UpdateIndexFile L    @" 	DeleteJob z" DeleteJob_58 " DeleteJob_47 " DeleteJob_48     $    {    " DeleteJob_40     l# DeleteJob_59     # DeleteJob_41     # DeleteJob_42 ;       ($ BuildJobFilePath ,    T$ 
ReadJobRecord $ ReadJobRecord_60 $ ReadJobRecord_47 $ ReadJobRecord_48     $    y    % ReadJobRecord_43     R   % WriteJobRecord % WriteJobRecord_61 & WriteJobRecord_47 && WriteJobRecord_48     $    z    & WriteJobRecord_44     (' WriteJobRecord_45     W' WriteJobRecord_62 L       ' ChangeJobOrder  ( ChangeJobOrder_46 9        x( SearchForJob ( SearchForJob_47 ( SearchForJob_48     !    x    ( BuildSequenceList l) BuildSequenceList_49 U        ) GetQueueFileStatus h    H* SetQueueFileStatus * SetQueueFileStatus_63 4    t    * SetJobStatus * SetJobStatus_64  + SetJobStatus_47 :+ SetJobStatus_48     $    {    p+ SetJobStatus_50 + SetJobStatus_65 L        R   , GetJobStatus @, GetJobStatus_66 t, GetJobStatus_47 , GetJobStatus_48     $    y        , GetJobFileSize z- GetJobFileSize_67         - CloseJob i. CloseJob_68     . CloseJob_69 =       . CloseJobFile <   		4  
                   	    	                 	            	     
                  	                      	 	        
 	           
                     
    
    ܊  
 
    QUELIB `/ 	PGETINT32 <    / 	LockQueue / LockQueue_47 / LockQueue_5     / LockQueue_6     / LockQueue_7     F    x    0 UnLockQueue 0 UnLockQueue_48 ,0 
UnLockQueue_5     Q0 
UnLockQueue_6     X0 
UnLockQueue_7     F    x    0 
CreateNWQueue 0 CreateNWQueue_1     1 CreateNWQueue_49 (1 CreateNWQueue_5     M1 CreateNWQueue_6     T1 CreateNWQueue_7     A    	2 CreateNWQueue_2     F3 CreateNWQueue_3 P3 CreateNWQueue_4      *       3 
GetQueueIndex 3 GetQueueIndex_5     3 GetQueueIndex_6     3 GetQueueIndex_7     C    3 DestroyNWQueue 4 DestroyNWQueue_50 
4 DestroyNWQueue_51 4 DestroyNWQueue_5     =4 DestroyNWQueue_6     D4 DestroyNWQueue_7     A    m    x4 DestroyNWQueue_8     4 DestroyNWQueue_52 4 DestroyNWQueue_5     4 DestroyNWQueue_6     4 DestroyNWQueue_7     C    4 DestroyNWQueue_9 4 DestroyNWQueue_53 4 DestroyNWQueue_54 4 DestroyNWQueue_5     5 DestroyNWQueue_6     5 DestroyNWQueue_7     @    i    l    5 DestroyNWQueue_10 5 DestroyNWQueue_11     A    -6 DestroyNWQueue_55 16 DestroyNWQueue_56 @6 DestroyNWQueue_5     e6 DestroyNWQueue_6     l6 DestroyNWQueue_7     B    l    3   6 ReadQueueStatus ;7 ReadQueueStatus_57 ?7 ReadQueueStatus_58 L7 ReadQueueStatus_5     q7 ReadQueueStatus_6     x7 ReadQueueStatus_7     @    l    7 ReadQueueStatus_59 7 ReadQueueStatus_5     8 ReadQueueStatus_6     8 ReadQueueStatus_7     C    q8 ReadQueueStatus_12     8 ReadQueueStatus_13 ,    8 ReadQueueStatus_60 8 ReadQueueStatus_61 8 ReadQueueStatus_5     !9 ReadQueueStatus_6     (9 ReadQueueStatus_7     @    i    \   X9 SetQueueStatus 9 SetQueueStatus_62 9 SetQueueStatus_63 9 SetQueueStatus_5     9 SetQueueStatus_6     9 SetQueueStatus_7     @    l    : SetQueueStatus_64 ": SetQueueStatus_65 0: SetQueueStatus_5     U: SetQueueStatus_6     \: SetQueueStatus_7     A    j    4   : CreateQueueJob : CreateQueueJob_66 : CreateQueueJob_67 : CreateQueueJob_5     ; CreateQueueJob_6     ; CreateQueueJob_7     @    l    ^; CreateQueueJob_14     k; CreateQueueJob_15     ~; CreateQueueJob_16 ; CreateQueueJob_17     F    ; CreateQueueJob_68 ; CreateQueueJob_69 ; CreateQueueJob_5     < CreateQueueJob_6      < CreateQueueJob_7     @    i       P< 
StartQueueJob s< StartQueueJob_70 <    < StartQueueJob_72 = StartQueueJob_18 $    }    E= StartQueueJob_73 9    2   = EnableQueueJob = EnableQueueJob_18     h    = RemoveJobFromQueue #> RemoveJobFromQueue_74 <    > RemoveJobFromQueue_75 9        > 
ListQueueJobs > ListQueueJobs_76 <    A? ListQueueJobs_77 D    ? ListQueueJobs_78 9       ? 
GetJobList <   
 @ GetJob ;@ 	GetJob_79 <    @ 	GetJob_80 9        @ ModifyJobEntry @ ModifyJobEntry_81 >    NA ModifyJobEntry_19 A ModifyJobEntry_20     F    A ModifyJobEntry_21     A ModifyJobEntry_22 A ModifyJobEntry_23 A ModifyJobEntry_24 	B ModifyJobEntry_25                                                                                                                                                                                                                                                                    f                        
r $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              \ "     i      B ModifyJobEntry_82 ;       B ModifyQueueOrder C ModifyQueueOrder_83 :    lC ModifyQueueOrder_26 lC ModifyQueueOrder_84 7    9    C ModifyQueueOrder_27     C ModifyQueueOrder_85 7    !   D AttachServerToQueue 0D AttachServerToQueue_86 8    D AttachServerToQueue_28     D AttachServerToQueue_29     D AttachServerToQueue_30     D AttachServerToQueue_87 4E AttachServerToQueue_33 <        E AttachServerToQueue_31 E AttachServerToQueue_88 ]    |    F AttachServerToQueue_89 5    L   TF AddServerToQueueList [     F RemoveServerFromQueueList# F RemoveServerFromQueueList_90# $G RemoveServerFromQueueList_33 8       # G RemoveServerFromQueueList_32 )       G FindQServer $H FindQServer_33 1        |H DetachServerFromQueue H DetachServerFromQueue_91 8    I DetachServerFromQueue_34     I DetachServerFromQueue_92 5        PI ServiceQueueJob zI ServiceQueueJob_35      I ServiceQueueJob_93 <    <J ServiceQueueJob_36     CJ ServiceQueueJob_94 9    0   J FinishJobServicing J FinishJobServicing_95 <    K FinishJobServicing_96 9        DK AbortJobServicing hK AbortJobServicing_97 >    K AbortJobServicing_37     K AbortJobServicing_38 
L AbortJobServicing_39     0    L AbortJobServicing_40 !    @L AbortJobServicing_41     \L AbortJobServicing_98 ;    W  ! L ChangeServerToClientRights$ L ChangeServerToClientRights_99 <   % L ChangeServerToClientRights_100 9        <M RestoreServerRights     HM ReadServerStatus pM ReadServerStatus_101 8    M ReadServerStatus_102 4N ReadServerStatus_33 <        N ReadServerStatus_103 5       N SetServerStatus O SetServerStatus_104 8    O SetServerStatus_105 O SetServerStatus_33 8           xP GetQueueJobSize P GetQueueJobSize_106 <        Q CheckQueueAccess "Q CheckQueueAccess_42     (Q CheckQueueAccess_43 JQ CheckQueueAccess_44 &    wQ CheckQueueAccess_45 &    Q CheckQueueAccess_46 &           		`/  V
                             	       
         	                  	        
              
                               	               ܹ                	                
    QSETUP Q 	PGETINT32 <    R 
StartupQMS cR 
StartupQMS_15 R 
StartupQMS_13 	    R 
StartupQMS_14 A        S StartupQMS_1     6S StartupQMS_2     pS StartupQMS_3 S StartupQMS_4 S StartupQMS_5 S StartupQMS_6     (    H    Z       S ShutDownQMS      T VerifyQueue T 
VerifyQueue_7 T 
VerifyQueue_8      9    T 
VerifyQueue_9 '    U VerifyQueue_10 U VerifyQueue_11 /    G    WU VerifyQueue_12     }   U AllocQMSMemory U AllocQMSMemory_13     U AllocQMSMemory_14 A        $V InitQMS +V 
InitQMS_16     (    LV 
InitQMSMemory    		Q  *
 
               
             
                  RECFILE lV 	PGETINT32 <    V CreateRecordFile V CreateRecordFile_1     @W CreateRecordFile_2     CW CreateRecordFile_20 QW CreateRecordFile_7 QW CreateRecordFile_21      QW CreateRecordFile_8               gW CreateRecordFile_3     kW CreateRecordFile_4         pW OpenRecordFile W OpenRecordFile_5     W OpenRecordFile_22 W OpenRecordFile_6     5    s    W LoadFileHeader X LoadFileHeader_6     5    X CloseRecordFile &X CloseRecordFile_7 &X CloseRecordFile_23 %    SX CloseRecordFile_8     @    `    |X UpdateRecordFileHeader (    X 
ReadRecord X ReadRecord_9 X 
ReadRecord_10 X 
ReadRecord_11         K    w    Y WriteRecord 8Y WriteRecord_12     LY WriteRecord_13 LY WriteRecord_24 Y WriteRecord_17     M    Y WriteRecord_14     ~    Y WriteRecord_15     Y WriteRecord_16         #  Z RemoveFromRecordFileFreeList& EZ RemoveFromRecordFileFreeList_17     K    LZ AddToRecordFileFreeList! Z AddToRecordFileFreeList_18 	    x    Z 
ReWriteRecord Z ReWriteRecord_19     j    0[ DeleteRecord 5[ DeleteRecord_25 [ DeleteRecord_18 	    y       		lV  M         
                        x    
 	  
 
   	
     TOKEN [ 	PGETINT32 <    [ 
TokenOpenFile L    @\ TokenCloseFile     T\ TokenProcessLine `\ TokenProcessLine_1 \ TokenProcessLine_2     \ TokenProcessLine_3     \ TokenProcessLine_4 	    u        \ GetToken ] 
GetToken_5 ] 
GetToken_6     '] GetToken_33 8] 
GetToken_1 c] 
GetToken_2     ] 
GetToken_3     ] 
GetToken_4 	    q        ] GetToken_34 ] GetToken_29     *    ] 
GetToken_7 ^ 
GetToken_8 %    8    @^ 
GetToken_9 P^ GetToken_10 %    8    x      ^ StringEnumToToken ^ StringEnumToToken_35 ^ StringEnumToToken_29 "    6    ^ StringEnumToToken_11 ^ StringEnumToToken_12 	        _ StringEnumToToken_13 _ StringEnumToToken_14 !_ StringEnumToToken_15 	        0    7_ StringEnumToToken_16         D_ StringEnumToTokenValue  d_ StringEnumToTokenValue_17      _ StringEnumToTokenValue_18     [    _ ClearTokenStack     _ 
TokenMatch _ 
TokenMatch_19 _ 
TokenMatch_20     1    _ 
TokenMatch_21 ` 
TokenMatch_22     0    }    0` 
TokenToString ;` TokenToString_23 H` TokenToString_24 O` TokenToString_25         -    q` TokenToString_26 |` TokenToString_27 ` TokenToString_28         (    o    ` ConvertToUpperCase ` ConvertToUpperCase_29 #    5   
 ` strdup /    a GetSubString a GetSubString_30 
    4a GetSubString_31     ^a GetSubString_32        		q[                                     y                 
    TOKENI a 	PGETINT32 <    b 
OpenParseFile b OpenParseFile_1     Tb OpenParseFile_2 eb OpenParseFile_3     0    b OpenParseFile_4 b OpenParseFile_33 b OpenParseFile_5 b OpenParseFile_6 b OpenParseFile_7     &    8    U    Z        b CloseParseFile b CloseParseFile_5 c CloseParseFile_6  c CloseParseFile_7     &    8    Y    Hc GetIntegerValue \c GetIntegerValue_8 `c                                                                                                                                                                                                                                                   g                        # $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     z       GetIntegerValue_9 rc GetIntegerValue_10     *    2    c GetIntegerValue_11 c GetIntegerValue_12 c GetIntegerValue_13 c GetIntegerValue_14     ?    A    S        c GetStringValue  d GetStringValue_15 d GetStringValue_16 d GetStringValue_17     *    2    4d GetStringValue_18 Fd GetStringValue_19 Hd GetStringValue_20 rd GetStringValue_21     ;    =    O        d 
MakeNumber d 
MakeNumber_22 d 
MakeNumber_23     d 
MakeNumber_24     5    p    d 	GetNumber 8e GetNumber_25 Be GetNumber_26     e GetNumber_27 f GetNumber_28 f GetNumber_29     &f GetNumber_34 6f GetNumber_22 =f GetNumber_23     \f GetNumber_24     5    `    f GetNumber_30 f GetNumber_35 f GetNumber_22 f GetNumber_23     f GetNumber_24     7    b    #g GetNumber_31 -        G      -   n   lg 	GetString g GetString_32        		va                                                         #    
      SCANNER g 	PGETINT32 9   		vg       	NPSTOKENS 0h 	PGETINT32 9   		w0h       	PNWTOKENS lh 	PGETINT32 <    h 	PNWTokens    		~lh       SEMA h StartupSemaphores     h InitSemaphores     h ShutDownSemaphores     h CreateAndSetSemaphore h CreateAndSetSemaphore_1     0    h DestroySemaphore i DestroySemaphore_2     4    0i 
LockSemaphore Ni LockSemaphore_3     4    di LockSharedSemaphore i LockSharedSemaphore_4     4    i UnLockSemaphore i UnLockSemaphore_5     #   		Fh e                         
    SHM i 	PGETINT32 <    i CreateSharedMemory j CreateSharedMemory_1     ,    $j AttachToSharedMemory     @j DestroySharedMemory Qj DestroySharedMemory_2 Qj DestroySharedMemory_3 
        &   		i 6 X     
    AES hj 	PGETINT32 <    j 
StartupAES $    j ShutDownAES     j InitAES    		hj / 
  	      GENERAL_MISC j 	PGETINT32 <    $k GetIntervalMarker D   ! hk GetIntervalMarkerInSeconds     k InitShutDown     k EngineShutDown (    k ServerShutDown    		j D 4 8 ' %
#
    STRING p 	PGETINT32 <    p NullTerminateString (    p MakePathString 4q MakePathString_1 fq MakePathString_2 q MakePathString_3     q MakePathString_4             r MakePathString_5 	    #r MakePathString_6 M    x   tr SeparatePath r SeparatePath_7     L    r 
DisectPath r DisectPath_8     &s DisectPath_9     :s 
DisectPath_10 X    s 
DisectPath_11 s 
DisectPath_12 +    s 
DisectPath_13 '    [    R   t PutNetWareString 4     Ht RemoveLastElementFromPath# Rt RemoveLastElementFromPath_14    # xt RemoveLastElementFromPath_15     a    t GetLastElementFromPath  t GetLastElementFromPath_16      u GetLastElementFromPath_17      u GetLastElementFromPath_18         ,u ValidateEntryName Ru ValidateEntryName_19 zu ValidateEntryName_20     u ValidateEntryName_21     u ValidateEntryName_22 u ValidateEntryName_23 u ValidateEntryName_24         
v ValidateEntryName_25     -v ValidateEntryName_26     ~    Lv ValidateEntryName_27 Wv ValidateEntryName_28          zv ValidateEntryName_29     9   c  " v ConvertTokenStringToCString% v ConvertTokenStringToCString_30% v ConvertTokenStringToCString_31 )    b       		p  * 3 M                      (  :               +" ȹ%     ,                 )       WILD 0w 	PGETINT32 <    lw 	WildMatch ww WildMatch_1     K   
 w WMatch w WMatch_2     Fx WMatch_3 x WMatch_4     x WMatch_5 x WMatch_6     -        x   0y HasWild Py 	HasWild_7 )    S    y WildReplace y WildReplace_26 y WildReplace_12 Bz WildReplace_13 1            
   z 
parseInput z parseInput_8 z parseInput_9     6    z 
parseInput_10 { 
parseInput_11             { parsePattern  { parsePattern_12 { parsePattern_13 -            { rewriteInput | rewriteInput_14 *| rewriteInput_15 4| rewriteInput_16 	    L| rewriteInput_17 	    `| rewriteInput_18 e| rewriteInput_19 	        p| rewriteInput_20 u| rewriteInput_21 	        | rewriteInput_22 | rewriteInput_23     
    | rewriteInput_24 | rewriteInput_25     
               		v0w  7                               $ >                                 
U                                  ENCRYPT | 	PGETINT32 <   
  } Decode ,} Decode_1 @} Decode_2 y    ~ Decode_3 D    <      ~ 
GetPassKey ~ 
GetPassKey_11 6    ~ 
GetPassKey_12 1        \ 
DecodePass ,     EncryptPass  
EncryptPass_4      
EncryptPass_5  
EncryptPass_6         < 
EncryptPass_7         ` Encrypt t 	Encrypt_8  	Encrypt_9 -    A    Ѐ 
Encrypt_10 =         RandomEvent      	NewLogKey -   		n|  !    	-
	     	    	  
    SERVER D 	PGETINT32 <     StartupServerStruct  StartupServerStruct_1     ߂ StartupServerStruct_2      StartupServerStruct_3         8 ShutDownServerStruct     P InitServerStructs      p 
SetServerName @     
GetServerName     ̃ SetMsgLanguage P     GetMsgLanguage      < SetMajorVersion     T GetMajorVersion     l SetMinorVersion      GetMinorVersion      SetRevision      GetRevision     ̄ SetSFTLevel      GetSFTLevel      SetTTSLevel      GetTTSLevel     , SetAccountingVersion     D GetAccountingVersion     \ 
SetQMSVersion     t 
GetQMSVersion      SetPrintVersion      GetPrintVersion      SetVirtualConsoleVersion     ԅ GetVirtualConsoleVersion    $  SetSecurityRestrictionVersion    $  GetSecurityRestrictionVersion      SetBridgeVersion     4 GetBridgeVersion     L SetConsoleFlag     d GetConsoleFlag     | SetLogFileSize      GetLogFileSize      
SetLogFile D     
GetLogFile ,     SetConsoleDevice D    ` GetConsoleDevice ,     SetNetNumber      GetNetNumber      SetMaxConnections      ܇ GetMaxConnections      
SetMaxVolumes      
GetMaxVolumes     $ SetMaxOpens     < GetMaxOpens     T SetMaxNWProcesses     l GetMaxNWProcesses      SetMaxClientsPerProcess      GetMaxClientsPerProcess       SetProcessSpawnAheadCount      ̈ GetProcessSpawnAheadCount      SetNWControlDir P    4 GetNWControlDir $    X SetLoginStatus     p GetLoginSt                                                                                                                                                                                                                                                   h                        ǁ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           SmeLs
ą!\lN`t
_,q?Ϲ^$[xX3G~]wnTzZF#ܕlōիM
#/' 	ri)4OMd*BLM=,'4cp\rw4]N{\KvI5?v*ν30y%V$Ziͳ
&oȃxDxZ&GAlly?QU5Z2K|x^?:apX3z*x$8x4:e k
M\Eٞ?@'Ȝpkc2*0nbixJ6LFQ$6@#A3p$_
L׶tF.r0@J'R!=Da{q\[~xChR}x?c5.$,TiTHv0Z˨mZcE"=c`<cUE"j@Ma1F܇7_#,X,8` Lmwu4r}byq*ɅXJr_k'J,ŶWxz"`r8cI#(˨EGΓfTho>b /
={PMfFKO|
x*5,/@toXmZ!rfTy(	v`5 S_GKmH!( ]t_Ǭ?i
J̙z @% E4=(AOjhs
?i(~Wcқ"A|KN
mbW {Mfz.DgjUHXzC;c6?}%CŽA2Џ-rYvh<(9F4aS'Xn{f2id5uA`0mPKHqis۪ĢVh.llCKYXhwsݾؕsј8hCQoy8tr^q]Ye
tg!n.vfY1ۨ**!&dNR]i +s-<*uÎ,qJ}ZYigƊw"}(C yWuXbk4m
lSQҸRO.E(Βژs$=G_c)5X<F"
kYу2DI]u4f[P4ԵUHKa!wwH)l
8"]e|8}nE7[9C	:-9\$),#PV1[OXPgu0ِ
}
ثŚ*8s{
Ns~*(Z&KGҮX0Aӄaj5{Dva;p,N6Bm\_]U7ؼh6 -*7ǵZH`IEc:նUne(/u)6aXyj'SE#1
AS#q%|Ng&R=ªIlϗdưť-aZ`/Όz<QL"̎ۘj٥QVmKצ!|$D88D)fz%kO6T'Iq{PB>?tѢ<i"4/TĢ=뵲OAcL3ğ&tCNLAc_ʝױߦ6Yy],'W1UW8R3_jXە/SHj%Xלm r:C9*^1q5W{q,r$;K#`7:A^2a}΂){(]l.]I*!^2kٴfQ
#%?1Ikawj\HLTW4Gڿ\?X\kԓgF	p"xJMhH
lX6A:J2si{59px"A4%dJ%~~;ehh,/yh("Kq뤏)tk+wvi18~"ҨGǰuJr"6dhEٵxZw;_m<mn51⌛>:'A!P}৮Ӂ;hUVq+Xy{R3~bӸ68^6\[
{tХQ=Wc{*vZ#T7aza9(6)˿nӣo
W%7rIνJ5c3^?Q? LhxNx4,)6>Y,
%7'RLP ssx|en%i9UY2t:]?!Vܮlw/%
BBmNDM< T׷,zoio3EB\U)ԸcbL|#bݒXmUDX,});QaSRض\fsesCٕjN@lҳ+Uk2EuvepIeMGrU)P7(H@z%En!6ra0]OD,G~kqPb1G+eKqsF#ɯD>XR(H)}s"W''CԳYWBDTEdݤ,|Ѕ]H"Xy
w:!ѯY[;5c_
 T;'?߿ZH,6_ T,<[kzvpeZFNxO"wOR_9ض
RO~]zRBu\9q&1|?,2boTy	ٯ0<B/ï	BV:Z?*D(𲴅./&&daV:,wi]BHϷ_Cf#Y6}9ma)f3
Z"q/TtFIL4Qp(h5[{P Vs|e^/5t(A9nZY'&@r#Y$q{d[U
A\{!a@eFʗ(V$,\8;g/Tj+ث-'T28muVXqg R\uCdejh3ZOx3
rUr]L@ɘ!!yqwp;ĻAo!P_9-\>
.3A/VsHⱋuU`CZf>V,
4{Rc ub4yn(0R8$;D jZdA=@}fkǦ?尣BCS2K`6GeyD,p##xp'{\੄HSI$u@0SйKUx2>-ڨ
QFwjFFj~2:	*g^1qS4
? i'u=d2XuA$zBwpШts43o.9z f lcD͘,
[ gL)~9e!&
-6*ʷVj5qJ/ꆍ)1>c@q{07D³j#6Cz߻}ΡPEE?<ӂ7;zf	krkaww?v]J:Q~*^BaPoz6ֻHCF ҧH@г2' ^z+[ Bo{渓gSˣ)X0Ű]@,eibC+?!DErޓ\l񈦯zs(?Bz}7"q9K O2&zX&K4yOͼW<Y7$<)ٯ6_UVB!MnXh6!9-FO
H/䗒:otsWo ڟCWMr!7>+zNKûyމ'}j+G/bduVנ?6Bc6:򴦣"""ي~']t,UgSշ:N\(UOZggTu"
g`ge)kyr!/o|=~[ք@]JU!1Qtd'Sxl	% 6/b<^D*+fcmH!}2<q=Q@<rX\GT	E*Za*~a
IL_iu˴
)[.A{X9n3m:ýZ6&Ȫ0tA%PȜ>@?.uIiW!5<eYOO̼5cѦIeJҒqM|ponJN?}̅ҧP
z`tt>4)ꛠAY-ASϫ;VjG-Ł8D+<5;@
XmE/OP,*nFlg҆뢥BpfOb<,.:pz&u;>ZYk8z.h||]t!>0'jşN*'@e0O
)4DuYLw:Iδ=xHJe	
`fĴ
wb1k4X_cy9}4PI
?}qn~,/*JCz*nn-{]?^U=4'L[yxUCQ` @hϲNFTK{̐}̧Q\{gYtF0\yFO66e\۵+ɧ#OΛĘXT
+b73>5ݞ-JHW:CLM>|1y_f1(Tk,'+Ěдmn˦VLhqqg0GnK		^
ʩ[*ce^$6NYms&ݬ#ݶO}Բ{YTS#oRk6YH}!v55@Qtߵ+5uU>-|Ir̎ą=@yܿ()0fd6Ze\Yg( &ka]Ңһ[rh5fɱ
VBҌAAٶaET;:JGp.&a4?0K%;
t͊S1di#=9uXmU\AɝV|)zVw=+g:HRE !gj1
\]߻D#a;eBrL  1 7`ɲ*R%Nz=b۵B%o,|`
Q~.$d}}wA{΅A|Vn'AhZ|ۡd6}ibNȈ,]+]ŤeO$!Sԫ]9кsg)JlOY!mҎX;栀T$$2c
.3uԦZ{~L8]^Dۆd
qP"]y_
j3Һ~98AT'Q{4܆"6	+\11vZl
"VvJBp}WMH|~ӔQw IYMSoa]Db᨟ix+8R>lqEgƅ^KW	GMwbp=qs{3fλ¸2؊Ddεh;PJiZj;
>뀼2
snIY40SE[ ws>MO{	_ct.jվ{@v6
0JjډmTz~.[[(*z<pYWT)"[Z2a>5.lQ_4IPx$8?NK&7ڇvP"Mp=JN#g1xPBw?y(>.fcK3'"u,z_B.(mCAj_ܺ?9֘m.b\j=}#{MZ@R2=䩳'JwR[O4L_\Oe[rE$3H
$ag oJXF
\fAB -M+c?[P?CsM 4EA!s:CeLܿf[NϴbfXs63VǐޚvoHsǍ'YDŵ6^6whaV7D92D(JY!n~^]Ifx/UJY3b3R1l	JS*|?Hi];><WY9'0R)Hˋs&XXbAyXa|gׇBCL&ǆ?H; Ǔ6o1+^.KIy~cTny325)vI 6˶(isUI?:H_l炧tdB$qJR߈YKVdtt&1$'BpϤ<g(#Vβc0 ~޽%q`AveO#ѧ0Ԟ|3yr]|.hg!z#0ܔex[jzTa.n/Geo||YcK*ފUsʌPVګd̡E@WvRxˉ#W	B$?=_tb\\?uoAx[&NMqkoGLۥ|'W7&F-i сT^b`13PNhSw06rhPޡ*_cS8qEZ"iRƹڗm"{$:;-X|a:jiG6Y=.HDKX|d]PX	uhz[<zRIW:@eH4[q`(Q
$_ ^^[gaz>ۓQQε%.ߥFCRO~n<WMWD[bcN$	EV_pRȉ ݙdVT"kHObR"H41![6}UvnvͬD_:WkWڲbsC̦dk
g.g!vw@KVLa )z2xP`Eb+lG
;Kƴ%Β ᩁEչRlYgK˝M'tСnѣvշOa_C`dbη/
OJA&dD]Tـv*ܵW<ҩz	5"O^k*
R$j;`߼RؘR9Ǣ98 ZI2Q}foj`:P4w.~l wvsC:`-|1bا](#$XTvMDAuu	KPcL=/WHc%KmUB#27)YzG	H"	#0/j:fQ|4!mXf7t\uP]c$of`J2O)|$ 9	atOR)D}k:9cZ~9ׄR^dɚ󌵸6vV=&6	M5Awd[ZU|ǐdCJWRku8+Q/mlʙu_kq/>u가an'F7bSuVĤ:o,A5Ɉ*Yq
'D%! ؛W%T!" ۇ!"ՖoR^0xU3CÀf[Aq7m㎞.Veitӣ2:{5Z͐˝viyvAX
[ɚ=l׳j-2
^ZH1mȟ{T

2CD
PBc[֢N+L$y$AcLMc,^dȧ! 3lݟg~۵K|ŶR{gЋa3Na,%4-TeK"Ͻ
Q7תOW՚(fŎ//uΊBdjZ*ےQlDt"`\sX]'<>չwvA-_%F)(F&UzKMۄsǏ_6;]# ~՚G1@Ey쟼]9P۫01~Lp"N4%U'혡SsHbXv}VjpICU"8hjBMӋ@.]oEZOU
ZjZiKgV,AN)2`VEE'o`aB{
G]UtY}
OBC`
+8nna
7                                                                                                                                                                                                                                                   i                        Qn $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              m "           atus      SetLongNameSupport      GetLongNameSupport      SetPasswordEncrypt     Љ GetPasswordEncrypt      SetNativeLockFlag       GetNativeLockFlag      SetTTSStatus     0 GetTTSStatus     H SetTTSVolume P     GetTTSVolumeName       SetCompanyNameString P     GetCompanyNameString      ( SetRevisionString P    x GetRevisionString       
SetDateString P     
GetDateString       SetNoticeString P    X GetNoticeString      x SetWriteBehindFlag      GetWriteBehindFlag      SetReadAheadCacheFlag      GetReadAheadCacheFlag     ، SetCreatorACEFlag      GetCreatorACEFlag      SetMaxDirSearches     $ GetMaxDirSearches     @ SetCacheBlockSize     X GetCacheBlockSize     p SetDeferredClose      GetDeferredClose      SetSalvageUtilityFlag      GetSalvageUtilityFlag     Ѝ SetSalvageNumFiles      GetSalvageNumFiles       SetSalvageMaxBytes      GetSalvageMaxBytes     0 SetServerAddress $    T GetServerAddress $    x SetServerStartTime       GetServerStartTime      SetServerStartInNWTime $    Ԏ GetServerStartInNWTime $     
SetGroupOwner      
GetGroupOwner     0 SetUserOwner     L GetUserOwner     h SetNearestSrvRspDelay      GetNearestSrvRspDelay      SetDirCacheElems      GetDirCacheElems     ؏ SetLogWatchdogLogouts      GetLogWatchdogLogouts       SetDisplayWatchdogLogouts      , GetDisplayWatchdogLogouts     H SetAlertNotifyList g SetAlertNotifyList_4     X     GetAlertNotifyList (    Ȑ SetSaveStatsFlag      GetSaveStatsFlag       SetAutoConnectFlag      GetAutoConnectFlag     8 InitNewNWEngine O InitNewNWEngine_5 a InitNewNWEngine_6     "     InitNewNWEngine_7          ܑ DestroyNotNeededNWEngines#  DestroyNotNeededNWEngines_37    " 8 DestroyNotNeededNWEngines_8" A DestroyNotNeededNWEngines_9# L DestroyNotNeededNWEngines_10# V DestroyNotNeededNWEngines_11    # d DestroyNotNeededNWEngines_12     1    <   #  DestroyNotNeededNWEngines_13 #       # Β DestroyNotNeededNWEngines_14 "    $     GetNWEngineInfo 0 GetNWEngineInfo_15     {   & | IncNWEngineTotalPacketsReceived) ȓ "IncNWEngineTotalPacketsReceived_16 #   )  "IncNWEngineTotalPacketsReceived_17)  "IncNWEngineTotalPacketsReceived_18    ) 
 "IncNWEngineTotalPacketsReceived_19    ) ( "IncNWEngineTotalPacketsReceived_20 #    `       $ ` IncNWEngineCurrentClientCount'   IncNWEngineCurrentClientCount_21 $   ' Д  IncNWEngineCurrentClientCount_22' ڔ  IncNWEngineCurrentClientCount_23    '   IncNWEngineCurrentClientCount_24    '   IncNWEngineCurrentClientCount_25 $    `       $ D DecNWEngineCurrentClientCount'   DecNWEngineCurrentClientCount_26 $   '   DecNWEngineCurrentClientCount_27'   DecNWEngineCurrentClientCount_28' Õ  DecNWEngineCurrentClientCount_29     
   ' ٕ  DecNWEngineCurrentClientCount_30    '   DecNWEngineCurrentClientCount_31 $    d        , RemoveNWEngine n RemoveNWEngine_32 $     RemoveNWEngine_33  RemoveNWEngine_34     Ŗ RemoveNWEngine_35      RemoveNWEngine_36 $    r         GetSAPProcessID    		|D  j     
 
                        	  	  	  	      	    	  	  	  
      	        
        	                  	  
        	                   	         	                       	 
    VOLUME 4 	PGETINT32 <    p StartupVolumeTable  StartupVolumeTable_1     ɗ StartupVolumeTable_2      StartupVolumeTable_3 E        L ShutDownVolumeTable     d SetVolWriteLockState Ř SetVolWriteLockState_4     ̘ SetVolWriteLockState_5     {     InitVolumeStructs      	AddVolume  AddVolume_67 8 AddVolume_27 L AddVolume_28 a AddVolume_29  AddVolume_30     -    D    X         AddVolume_6     ԙ AddVolume_7  AddVolume_8 9 AddVolume_9 > AddVolume_68  AddVolume_4      AddVolume_5     i    q               К ModifyVolume  ModifyVolume_10 / ModifyVolume_11     (    H ModifyVolume_12  ModifyVolume_13 Û ModifyVolume_14     " ModifyVolume_15          ModifyVolume_16      ModifyVolume_17     &    ModifyVolume_18 &        RemoveVolume  RemoveVolume_69     , RemoveVolume_19     H RemoveVolume_20 <         IsValidVolumeNumber #     
IsVolumeInUse  IsVolumeInUse_70     ܞ IsVolumeInUse_21  IsVolumeInUse_22 +    F    z    ( IsVolumeWriteLocked 8 IsVolumeWriteLocked_71     X IsVolumeWriteLocked_23 l IsVolumeWriteLocked_24     *    ^     IsVolumeHomeVol  IsVolumeHomeVol_72      IsVolumeHomeVol_25 ̟ IsVolumeHomeVol_26     *    ^     GetVolumeNumber  GetVolumeNumber_27  GetVolumeNumber_28 1 GetVolumeNumber_29 P GetVolumeNumber_30     -    D    X        p 
GetVolumeName  GetVolumeName_73      GetVolumeName_31  GetVolumeName_74  GetVolumeName_75     Ԡ GetVolumeName_21  GetVolumeName_22 &    B    m     GetVolumeName_32             H GetHostPath _ GetHostPath_76      GetHostPath_33  GetHostPath_77  GetHostPath_78      GetHostPath_21 ɡ GetHostPath_22 &    B    m     GetHostPath_34 D           L IncVolumeUseCount \ IncVolumeUseCount_79      IncVolumeUseCount_35  IncVolumeUseCount_80  IncVolumeUseCount_81      IncVolumeUseCount_21 Ţ IncVolumeUseCount_22 &    B    m     IncVolumeUseCount_36              DecVolumeUseCount ( DecVolumeUseCount_82     L DecVolumeUseCount_37 T DecVolumeUseCount_83 [ DecVolumeUseCount_84     | DecVolumeUseCount_21  DecVolumeUseCount_22 &    B    m    ƣ DecVolumeUseCount_38              GetVolumeInheritedRights"  GetVolumeInheritedRights_85"  GetVolumeInheritedRights_86    " $ GetVolumeInheritedRights_21" 9 GetVolumeInheritedRights_22 &    B    m   " n GetVolumeInheritedRights_39           SetVolumeInheritedRights"  SetVolumeInheritedRights_87"  SetVolumeInheritedRights_88    " Ф SetVolumeInheritedRights_21"  SetVolumeInheritedRights_22 &    B    m   "  SetVolumeInheritedRights_40          @ CreateInitVolStruct  CreateInitVolStruct_41        T 
SyncVolume m 
SyncVolume_42      
SyncVolume_43     Ʀ 
SyncVolume_44 	        Ԧ 
EndVolumes  
EndVolumes_45  
EndVolumes_46 ' 
EndVolumes_47 ' 
EndVolumes_48         .    B 
EndVolumes_49 U 
EndVolumes_50 U 
EndVolumes_51         .                                                                                                                                                                                                                                                        j                        [) $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "                   SyncClusterVolume ԧ SyncClusterVolume_52      SyncClusterVolume_53  SyncClusterVolume_54 G SyncClusterVolume_55 L    x         SyncClusterVolume_56 6    ( SyncClusterVolume_57     < SyncClusterVolume_58 	       L EndClusterVolumes  EndClusterVolumes_59  EndClusterVolumes_60  EndClusterVolumes_61  EndClusterVolumes_62  EndClusterVolumes_63         .    ҩ EndClusterVolumes_64  EndClusterVolumes_65  EndClusterVolumes_66         .            &  		4             	                                                     	                            	HASHTABLE t CreateHashTable  CreateHashTable_1  CreateHashTable_2             D DestroyHashTable d DestroyHashTable_3 p DestroyHashTable_4 /    =     DestroyHashTable_5      DestroyHashTable_6           AddToHashTable A AddToHashTable_26 P AddToHashTable_17 V AddToHashTable_18         I         DeleteHashTableNode T DeleteHashTableNode_7 h DeleteHashTableNode_8  DeleteHashTableNode_27  DeleteHashTableNode_15      DeleteHashTableNode_16     9    b    x        ح SearchHashTable  SearchHashTable_9 $ SearchHashTable_10         d    < GetKeyBlock P GetKeyBlock_11 W GetKeyBlock_12 b GetKeyBlock_13 
    o GetKeyBlock_14     $    2        Ȯ FreeKeyBlock ׮ FreeKeyBlock_15 &      FreeKeyBlock_16     L     GetDataNode ( GetDataNode_17 / GetDataNode_18     #    X    l FreeDataNode { FreeDataNode_19      FreeDataNode_20     4     HashKeyFromDataPointer      DataSizeFromDataPointer    ! ȯ InitFastHashTableTraversal$  InitFastHashTableTraversal_21$  InitFastHashTableTraversal_22         @     LoadHashTablePointers 0 LoadHashTablePointers_23 8 LoadHashTablePointers_24 H LoadHashTablePointers_25 
        0    t    | 
StringHash M    ̰ DefaultKeyLength      HashUniqueNumber E    ( HashFileLockKey M    x CompareUniqueNumbers 9     HashTableStrcmp    		t        	     	 	   	                           

 	    
 	    	 	     
LOCALQUEUE ȱ 	PGETINT32 <     CreateQueue      DestroyQueue     , 
QueueHeadPeek ,    X 
QueueNextPeek ,     
AddToQueue ,     RemoveFromQueue <   		wȱ C            SHMQUEUE  	PGETINT32 <    ( ShmCreateQueue     < ShmDestroyQueue     P ShmQueueHeadPeek 4     ShmQueueNextPeek ,     
ShmAddToQueue ,    ܳ ShmRemoveFromQueue G    $ ShmRemoveFromDeque    		w R       
     	LOCALLIST 8 	PGETINT32 <    t 
InitSLList  InitSLList_1     9     AddAfterSLList ô AddAfterSLList_2     մ AddAfterSLList_3      AddAfterSLList_4         8 AddBeforeSLList K AddBeforeSLList_5     ] AddBeforeSLList_6      AddBeforeSLList_7         ̵ RewindSLList     ܵ SeekToEndSLList      NextNodeSLList  NextNodeSLList_8     
 NextNodeSLList_9     3    $ GetContentsSLList (    L DeleteNodeSLList Z DeleteNodeSLList_10     m DeleteNodeSLList_11 q DeleteNodeSLList_12     2     DeleteNodeSLList_13  DeleteNodeSLList_31      DeleteNodeSLList_14  DeleteNodeSLList_32 ȶ DeleteNodeSLList_8     ն DeleteNodeSLList_9     &     DeleteNodeSLList_15     0    h    / DeleteNodeSLList_16         H 
DestroySLList $    l 
InitDLList  
InitDLList_17     9     AddAfterDLList  AddAfterDLList_18     ͷ AddAfterDLList_19 !     AddAfterDLList_20 !        H AddBeforeDLList [ AddBeforeDLList_21     m AddBeforeDLList_22 !     AddBeforeDLList_23 #         RewindDLList       SeekToEndDLList      NextNodeDLList " NextNodeDLList_24     1 NextNodeDLList_25     3    H PreviousNodeDLList Z PreviousNodeDLList_26     +    t GetContentsDLList (     DeleteNodeDLList  DeleteNodeDLList_27      DeleteNodeDLList_28  DeleteNodeDLList_29     8     DeleteNodeDLList_30         P 
DestroyDLList #   		w8       	                 	  	           LIST t 	PGETINT32 <     I_AllocAheadSLList Ӻ I_AllocAheadSLList_1         0 I_AllocAheadSLNode Z I_AllocAheadSLNode_2          
ShmInitSLList Ż ShmInitSLList_3 Ż ShmInitSLList_40 ܻ ShmInitSLList_1     s            h ShmAddAfterSLList  ShmAddAfterSLList_4  ShmAddAfterSLList_41  ShmAddAfterSLList_2     p    |    
 ShmAddAfterSLList_5     1 ShmAddAfterSLList_6        p ShmAddBeforeSLList  ShmAddBeforeSLList_7  ShmAddBeforeSLList_42  ShmAddBeforeSLList_2     p    |     ShmAddBeforeSLList_8     : ShmAddBeforeSLList_9         ShmRewindSLList      
ShmSaveSLList      ShmRestoreSLList      ShmSeekToEndSLList     ̾ ShmNextNodeSLList ھ ShmNextNodeSLList_10      ShmNextNodeSLList_11     3      ShmGetContentsSLList (    ( ShmDeleteNodeSLList = ShmDeleteNodeSLList_12     Q ShmDeleteNodeSLList_13 U ShmDeleteNodeSLList_14     2     ShmDeleteNodeSLList_15  ShmDeleteNodeSLList_43      ShmDeleteNodeSLList_16  ShmDeleteNodeSLList_44  ShmDeleteNodeSLList_10      ShmDeleteNodeSLList_11     &    Ͽ ShmDeleteNodeSLList_17     0    k     ShmDeleteNodeSLList_18        0 ShmDestroySLList ,    \ ShmInitSLListBlock x ShmInitSLListBlock_19      ShmInitSLListBlock_20     `     	GetSLList      
ShmInitDLList  ShmInitDLList_21     9     ShmAddAfterDLList ! ShmAddAfterDLList_22     1 ShmAddAfterDLList_23 !    ] ShmAddAfterDLList_24 !         ShmAddBeforeDLList  ShmAddBeforeDLList_25      ShmAddBeforeDLList_26 !     ShmAddBeforeDLList_27 #        T ShmRewindDLList     d ShmSeekToEndDLList     x ShmNextNodeDLList  ShmNextNodeDLList_28      ShmNextNodeDLList_29     3     ShmPreviousNodeDLList  ShmPreviousNodeDLList_30     +     ShmGetContentsDLList (      ShmDeleteNodeDLList  ShmDeleteNodeDLList_31     ! ShmDeleteNodeDLList_32 % ShmDeleteNodeDLList_33 % ShmDeleteNodeDLList_34         E ShmDeleteNodeDLList_35     >    n ShmDeleteNodeDLList_36 s ShmDeleteNodeDLList_37 
                                                                                                                                                                                                                                                       k                        r $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              Tl "                ShmDeleteNodeDLList_38 	         ShmDestroyDLList  ShmDestroyDLList_39 
    #   		zt  s   	  	   	          	                     	  	           SHMSTACK  	PGETINT32 <     	InitStack     0 DestroyStack     H 	PushStack +    t PopStack =   		2 :            LOG_LOCK < StartupLogicalLocks  StartupLogicalLocks_1         ( AllocLogLockMem      H FreeLogLockMem    # d CreateLogicalStatusHashTable T      CreateLogicalLogHashTable P     ShutDownLogicalLocks (    0 InitLogicalLocks P     LMAgeLogicalLocks  LMAgeLogicalLocks_2  LMAgeLogicalLocks_3 ]           $ | CheckLogicalLockPendingEvents&  CheckLogicalLockPendingEvents_4&  CheckLogicalLockPendingEvents_5&  CheckLogicalLockPendingEvents_6&  CheckLogicalLockPendingEvents_7 g   & | CheckLogicalLockPendingEvents_8         &  CheckLogicalLockPendingEvents_9'   CheckLogicalLockPendingEvents_10 `   '   CheckLogicalLockPendingEvents_11 &       ' 4  CheckLogicalLockPendingEvents_12     a         d LMLogLogicalRecord  LMLogLogicalRecord_13      LMLogLogicalRecord_14      LMLogLogicalRecord_15 F LMLogLogicalRecord_16     l LMLogLogicalRecord_17      LMLogLogicalRecord_18 8        h    
LockRecord  
LockRecord_19     " 
LockRecord_20     3 
LockRecord_21 A 
LockRecord_22 ]    k     
LockRecord_23  
LockRecord_24 ^    l     
LockRecord_25 , 
LockRecord_26 N 
LockRecord_27     g    u     
LockRecord_28      
LockRecord_29     ( 
LockRecord_30     k   8 LMClearLogicalRecord H     ClearLogicalRecord  ClearLogicalRecord_31     T     LMClearLogicalRecordSet <     ClearLogicalRecordSet P ClearLogicalRecordSet_32           LMReleaseLogicalRecordSet <     ReleaseLogicalRecordSet!   ReleaseLogicalRecordSet_33! * ReleaseLogicalRecordSet_34 Z             LMReleaseLogicalRecord H     ReleaseLogicalRecord  ReleaseLogicalRecord_35     R ReleaseLogicalRecord_36 Z         LMLockLogicalRecordSet P     LockLogicalRecordSet ` LockLogicalRecordSet_37     q    OpenLogTable  OpenLogTable_38 3    s     SearchLogTable  SearchLogTable_39 +    P    D OpenLogNode      OpenLogicalStatusNode  OpenLogicalStatusNode_40         P CloseLogicalStatusNode  ~ CloseLogicalStatusNode_41     M     CloseLogTableNode  CloseLogTableNode_42 ^    h CloseLogTableNode_43      CloseLogTableNode_44  CloseLogTableNode_45             ShowLogicalStatusTable    ShowLogicalStatusTable_46  n ShowLogicalStatusTable_47 V        I  &  LMReleaseClientLogLockResources) C "LMReleaseClientLogLockResources_48    ) | "LMReleaseClientLogLockResources_49)  "LMReleaseClientLogLockResources_50)  "LMReleaseClientLogLockResources_51     6    R         LMClientEOTLogLock 6   		(
<     


   

                  
            
                                  	       	             	 ҹ   	  	        
     	           
SEMAPHORES  StartupNWSemaphores  StartupNWSemaphores_1      StartupNWSemaphores_49 0    m StartupNWSemaphores_2     t StartupNWSemaphores_50          AllocSemaphoreMem      FreeSemaphoreMem      CreateSemaphoreTable @     ShutDownNWSemaphores $    4 InitNWSemaphores ,    ` LMAgeSemaphores  LMAgeSemaphores_3  LMAgeSemaphores_4  LMAgeSemaphores_51 
    P    q       $ 0 LMCheckSemaphorePendingEvents' F  LMCheckSemaphorePendingEvents_52& d LMCheckSemaphorePendingEvents_5& q LMCheckSemaphorePendingEvents_6'   LMCheckSemaphorePendingEvents_53 
    @    ^           "  CheckSemaphorePendingEvents$  CheckSemaphorePendingEvents_5$  CheckSemaphorePendingEvents_6% # CheckSemaphorePendingEvents_54 
    @    ^        | LMOpenSemaphore  LMOpenSemaphore_7  LMOpenSemaphore_8     / LMOpenSemaphore_9     Z LMOpenSemaphore_10     w LMOpenSemaphore_11          LMOpenSemaphore_12  LMOpenSemaphore_13      LMOpenSemaphore_14      LMOpenSemaphore_15 &    q        LMCloseSemaphore 7    H CloseSemaphore  CloseSemaphore_16  CloseSemaphore_17     %     CloseSemaphore_18      CloseSemaphore_19 4        8 LMSignalSemaphore /    h LMSignalSemaphoreBody  LMSignalSemaphoreBody_20      LMSignalSemaphoreBody_21      LMSignalSemaphoreBody_22      LMSignalSemaphoreBody_23      LMSignalSemaphoreBody_55  LMSignalSemaphoreBody_5  LMSignalSemaphoreBody_6  LMSignalSemaphoreBody_56 
    @    ^           p LMWaitOnSemaphore ;     LMWaitOnSemaphoreBody  LMWaitOnSemaphoreBody_24      LMWaitOnSemaphoreBody_25      LMWaitOnSemaphoreBody_26      LMWaitOnSemaphoreBody_27     ( LMWaitOnSemaphoreBody_28 ( LMWaitOnSemaphoreBody_57     D LMWaitOnSemaphoreBody_29     o LMWaitOnSemaphoreBody_30     L        | LMExamineSemaphore 4     LMExamineSemaphoreBody   LMExamineSemaphoreBody_31       LMExamineSemaphoreBody_32       LMExamineSemaphoreBody_33     p   #   LMReleaseClientSemaResources& R LMReleaseClientSemaResources_34    &  LMReleaseClientSemaResources_35&  LMReleaseClientSemaResources_36&  LMReleaseClientSemaResources_37    &  LMReleaseClientSemaResources_38&  LMReleaseClientSemaResources_39&  LMReleaseClientSemaResources_40     8    G           & w LMReleaseClientSemaResources_58%  LMReleaseClientSemaResources_5%  LMReleaseClientSemaResources_6&  LMReleaseClientSemaResources_59     B    ^            LMClientEOTSema B LMClientEOTSema_41      LMClientEOTSema_42  LMClientEOTSema_43  LMClientEOTSema_44      LMClientEOTSema_45  LMClientEOTSema_46  LMClientEOTSema_47     <    K            k LMClientEOTSema_60  LMClientEOTSema_5  LMClientEOTSema_6  LMClientEOTSema_61     B    ^            HashClientTaskNumbers Q    X CompareClientTaskNumbers B     SemaTrapErrors  SemaTrapErrors_48     B   		
         		 	                               	 	        		
         	                                                                                                                                                                                                                                                            l                        @ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ` "                  
ܹ                                     			o       	FILE_LOCK d StartupFileLocks  StartupFileLocks_1      StartupFileLocks_79 0     StartupFileLocks_80 0    C StartupFileLocks_2     J StartupFileLocks_81 !    
   t AllocFileLockMem      FreeFileLockMem       CreateFileStatusHashTable @     CreateFileLogHashTable @    , ShutDownFileLocks $    P 
InitFileLocks 0     LMAgeFileLocks  LMAgeFileLocks_3  LMAgeFileLocks_4  LMAgeFileLocks_82 
    ?    b       # 8 LMCheckFileLockPendingEvents (   ! ` CheckFileLockPendingEvents#  CheckFileLockPendingEvents_5#  CheckFileLockPendingEvents_6#  CheckFileLockPendingEvents_7#  CheckFileLockPendingEvents_8$  CheckFileLockPendingEvents_83 	    X    k   # 0 CheckFileLockPendingEvents_9$ < CheckFileLockPendingEvents_10$ B CheckFileLockPendingEvents_11 #   $ h CheckFileLockPendingEvents_12$ x CheckFileLockPendingEvents_13$  CheckFileLockPendingEvents_14$  CheckFileLockPendingEvents_15             5    a   $  CheckFileLockPendingEvents_84 	       $  CheckFileLockPendingEvents_16         '     "  LMVerifyFileAccessPrivilege% N LMVerifyFileAccessPrivilege_85% t LMVerifyFileAccessPrivilege_23% } LMVerifyFileAccessPrivilege_24         I   %  LMVerifyFileAccessPrivilege_17 
   %  LMVerifyFileAccessPrivilege_18        "  LMVerifyFileCreatePrivilege% 6 LMVerifyFileCreatePrivilege_86% \ LMVerifyFileCreatePrivilege_23% e LMVerifyFileCreatePrivilege_24         I   %  LMVerifyFileCreatePrivilege_19 
   %  LMVerifyFileCreatePrivilege_20    %  LMVerifyFileCreatePrivilege_87%  LMVerifyFileCreatePrivilege_25     B   %  LMVerifyFileCreatePrivilege_21 
   %  LMVerifyFileCreatePrivilege_22     _   8 LMIsFileLocked \ LMIsFileLocked_23 e LMIsFileLocked_24         D    | LMIsFileLogged  LMIsFileLogged_25     @     	LMLogFile 
 LMLogFile_26      LMLogFile_27     P LMLogFile_88 v LMLogFile_54 "    L     LMLogFile_28      LMLogFile_29      LMLogFile_30  LMLogFile_31 4    * LMLogFile_32     9 LMLogFile_33 9 LMLogFile_89     J LMLogFile_34      LMLogFile_35     m            LMClearFile  LMClearFile_36      LMClearFile_37     5 LMClearFile_90 [ LMClearFile_54 !    K     LMClearFile_38         LMClearFileSet 4     ClearFileSet  ClearFileSet_91 . ClearFileSet_54 "    L    \ ClearFileSet_39          LMReleaseFileSet  LMReleaseFileSet_92  LMReleaseFileSet_54 $    N     LMReleaseFileSet_40 ' LMReleaseFileSet_41 	    ,        H 
LMReleaseFile  LMReleaseFile_42      LMReleaseFile_43      LMReleaseFile_93  LMReleaseFile_54 !    K    * LMReleaseFile_44     P LMReleaseFile_45 	    $   l 
LMLockFileSet  LMLockFileSet_94  LMLockFileSet_54 #    J     LMLockFileSet_46  LMLockFileSet_47 $ LMLockFileSet_48     K LMLockFileSet_49     Z LMLockFileSet_50 Z LMLockFileSet_95     k LMLockFileSet_51      LMLockFileSet_52     i         LMLockFileSet_53             OpenLogTable ! OpenLogTable_54      W    H SearchLogTable T SearchLogTable_55 "    6     OpenLogNode  OpenLogNode_56 "     OpenLogNode_96      OpenLogNode_97  OpenLogNode_57 
     OpenLogNode_98     n        \ OpenFileStatusNode  OpenFileStatusNode_57      OpenFileStatusNode_99     t     CloseFileStatusNode  CloseFileStatusNode_58  CloseFileStatusNode_59  CloseFileStatusNode_60 	        '     CloseFileStatusNode_61     b    4 CloseLogTableNode x CloseLogTableNode_62      CloseLogTableNode_63  CloseLogTableNode_64 
    %     CloseLogTableNode_65 %    	 CloseLogTableNode_100  CloseLogTableNode_58 / CloseLogTableNode_59 6 CloseLogTableNode_60 	        &    D CloseLogTableNode_61     T    m CloseLogTableNode_66 p CloseLogTableNode_101          CloseLogTableNode_67  CloseLogTableNode_68  CloseLogTableNode_102             r  !  LMReleaseClientFileLockRes$  LMReleaseClientFileLockRes_69    $  LMReleaseClientFileLockRes_70$  LMReleaseClientFileLockRes_71$ + LMReleaseClientFileLockRes_72 
    $    3        l LMClientEOTFileLock /     
IsFileOpen  
IsFileOpen_73      
IsFileOpen_74 1    ! 
IsFileOpen_75 #        D CompareFileKeys  CompareFileKeys_76  CompareFileKeys_77     7     CompareFileKeys_78        		;
d            
 
 
     
 
 	                            	    	        
                                   	              
                              

 
   
   	                     	    m                        	PHYS_LOCK x StartupPhysicalLocks  StartupPhysicalLocks_1      StartupPhysicalLocks_2      StartupPhysicalLocks_134  StartupPhysicalLocks_11     " StartupPhysicalLocks_12     b    G StartupPhysicalLocks_135 q StartupPhysicalLocks_13      StartupPhysicalLocks_14     b     StartupPhysicalLocks_136     
 StartupPhysicalLocks_3     & StartupPhysicalLocks_137     D StartupPhysicalLocks_4     ] StartupPhysicalLocks_138     { StartupPhysicalLocks_5      StartupPhysicalLocks_139      StartupPhysicalLocks_6      StartupPhysicalLocks_140      StartupPhysicalLocks_7       StartupPhysicalLocks_141        StartupPhysicalLocks_8     9  StartupPhysicalLocks_142     W  StartupPhysicalLocks_9       StartupPhysicalLocks_10       StartupPhysicalLocks_143   StartupPhysicalLocks_118   StartupPhysicalLocks_119   StartupPhysicalLocks_144         4     StartupPhysicalLocks_120     A     StartupPhysicalLocks_145 0 StartupPhysicalLocks_121 7 StartupPhysicalLocks_146         <    Z StartupPhysicalLocks_147 Z StartupPhysicalLocks_126 l StartupPhysicalLocks_127 l StartupPhysicalLocks_148         2     StartupPhysicalLocks_128     ?     StartupPhysicalLocks_149  StartupPhysicalLocks_129  StartupPhysicalLocks_150         <     StartupPhysicalLocks_151  StartupPhysicalLocks_122  StartupPhysicalLocks_123  StartupPhysicalLocks_152         3     StartupPhysicalLocks_124     A    " StartupPhysicalLocks_153 < StartupPhysicalLocks_125 D StartupPhysicalLocks_154         ?    a StartupPhysicalLocks_155 G    6    AllocPhysLockMem      FreePhysLockMem    $  CreatePhysFileStatusHashTable' %  CreatePhysFileStatusHashTable_11    ' C  CreatePhysFileStatusHashTable_12     y    d CreatePhysLogHashTable   CreatePhysLogHashTable_13                                                                                                                                                                                                                                                         m                        7{ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "            CreatePhysLogHashTable_14     y     ShutDownPhysicalLocks '     InitPhysicalLocks \    d LMAgePhysLocks  LMAgePhysLocks_15  LMAgePhysLocks_16  LMAgePhysLocks_156  LMAgePhysLocks_125  LMAgePhysLocks_157         ;    m            d LMPurgePhysLockBitMaps   LMPurgePhysLockBitMaps_17   LMPurgePhysLockBitMaps_18 ~          # | LMCheckPhysLockPendingEvents &   !  CheckPhysLockPendingEvents$  CheckPhysLockPendingEvents_19$  CheckPhysLockPendingEvents_20$  CheckPhysLockPendingEvents_21$ @ CheckPhysLockPendingEvents_22% O CheckPhysLockPendingEvents_158% l CheckPhysLockPendingEvents_125% t CheckPhysLockPendingEvents_159         >    p       $  CheckPhysLockPendingEvents_23$  CheckPhysLockPendingEvents_24%  CheckPhysLockPendingEvents_160%  CheckPhysLockPendingEvents_125%  CheckPhysLockPendingEvents_161         >    a   $ X CheckPhysLockPendingEvents_25$ x CheckPhysLockPendingEvents_26     $ x CheckPhysLockPendingEvents_27     4   %  CheckPhysLockPendingEvents_162%  CheckPhysLockPendingEvents_125%  CheckPhysLockPendingEvents_163         =    H  $  CheckPhysLockPendingEvents_28        "      (	 LMVerifyReadPrivilege W	 LMVerifyReadPrivilege_29     
 LMVerifyReadPrivilege_30     5
 LMVerifyReadPrivilege_31     (   P
 LMVerifyWritePrivilege  3 LMVerifyWritePrivilege_32      T LMVerifyWritePrivilege_33  \ LMVerifyWritePrivilege_34! \ LMVerifyWritePrivilege_164  m LMVerifyWritePrivilege_39  s LMVerifyWritePrivilege_40      x LMVerifyWritePrivilege_41           LMVerifyWritePrivilege_42   LMVerifyWritePrivilege_43       LMVerifyWritePrivilege_44         G      LMVerifyWritePrivilege_35     Y    f      LMVerifyWritePrivilege_36   LMVerifyWritePrivilege_37!  LMVerifyWritePrivilege_165   LMVerifyWritePrivilege_39   LMVerifyWritePrivilege_40       LMVerifyWritePrivilege_41           LMVerifyWritePrivilege_42   LMVerifyWritePrivilege_43        LMVerifyWritePrivilege_44         G     9 LMVerifyWritePrivilege_38     g    t       ` LockRecordTouches p LockRecordTouches_39 w LockRecordTouches_40     { LockRecordTouches_41          LockRecordTouches_42  LockRecordTouches_43      LockRecordTouches_44     !    P     IsRecordLockedExclusive!  IsRecordLockedExclusive_45!  IsRecordLockedExclusive_46"  IsRecordLockedExclusive_166!  IsRecordLockedExclusive_39!  IsRecordLockedExclusive_40    !  
 IsRecordLockedExclusive_41        ! 

 IsRecordLockedExclusive_42! 
 IsRecordLockedExclusive_43    ! $
 IsRecordLockedExclusive_44         I   ! /
 IsRecordLockedExclusive_47    ! 2
 IsRecordLockedExclusive_48      ^    k        D
 LMLogPhysicalRecord 
 LMLogPhysicalRecord_167 
 LMLogPhysicalRecord_168 +    
 LMLogPhysicalRecord_101 ,    k    
 LMLogPhysicalRecord_49      LMLogPhysicalRecord_50     B LMLogPhysicalRecord_51 D LMLogPhysicalRecord_52     P LMLogPhysicalRecord_53 $    t LMLogPhysicalRecord_54 $     LMLogPhysicalRecord_55     f    d    
LockRecord  
LockRecord_56      
LockRecord_57  
LockRecord_58  LockRecord_169  
LockRecord_39  
LockRecord_40      
LockRecord_41          
LockRecord_42 & 
LockRecord_43     , 
LockRecord_44         G    R 
LockRecord_59 "             
LockRecord_60  
LockRecord_61  LockRecord_170  
LockRecord_39  
LockRecord_40      
LockRecord_41          
LockRecord_42  
LockRecord_43      
LockRecord_44         G    	 
LockRecord_62 "            E 
LockRecord_63 J 
LockRecord_64     Y 
LockRecord_65 ^ 
LockRecord_66     h 
LockRecord_67         u 
LockRecord_68      
LockRecord_69  
LockRecord_70 	        L     
LockRecord_71  
LockRecord_72 	         
LockRecord_73  
LockRecord_74      LockRecord_171  LockRecord_126   LockRecord_127   LockRecord_172     '    ?    4 LockRecord_128 
    b     
LockRecord_75      
LockRecord_76      
LockRecord_77        W 
LockRecord_78     \ 
LockRecord_79 \ LockRecord_173 i LockRecord_122  LockRecord_123  LockRecord_174     (    C     LockRecord_124     g      
LockRecord_80         `    LMClearPhysicalRecord K    T ClearPhysicalRecord h ClearPhysicalRecord_175 *         LMClearPhysicalRecordSet 1     ClearPhysicalRecordSet!  ClearPhysicalRecordSet_176 '     P ClearPhysicalRecordSet_81     x   !  LMReleasePhysicalRecordSet ,     ReleasePhysicalRecordSet#  ReleasePhysicalRecordSet_177 *   "  ReleasePhysicalRecordSet_82"  ReleasePhysicalRecordSet_83         p     LMReleasePhysicalRecord =    \ ReleasePhysicalRecord   ReleasePhysicalRecord_178 '     ReleasePhysicalRecord_84   ReleasePhysicalRecord_85  # ReleasePhysicalRecord_179  < ReleasePhysicalRecord_129  C ReleasePhysicalRecord_180         =    E    h ReleasePhysicalRecord_86 t ReleasePhysicalRecord_87 } ReleasePhysicalRecord_88   ReleasePhysicalRecord_181   ReleasePhysicalRecord_129   ReleasePhysicalRecord_182         @    F    P    a         ReleasePhysicalRecord_89  ReleasePhysicalRecord_90   ReleasePhysicalRecord_183   ReleasePhysicalRecord_129   ReleasePhysicalRecord_184         >    F    $ ReleasePhysicalRecord_91 , ReleasePhysicalRecord_92 5 ReleasePhysicalRecord_93  8 ReleasePhysicalRecord_185  T ReleasePhysicalRecord_129  [ ReleasePhysicalRecord_186         @    E    P    ]        @    LMLockPhysicalRecordSet :     LockPhysicalRecordSet   LockPhysicalRecordSet_187 -    H LockPhysicalRecordSet_94 b LockPhysicalRecordSet_95  LockPhysicalRecordSet_96      LockPhysicalRecordSet_97   LockPhysicalRecordSet_188   LockPhysicalRecordSet_122   LockPhysicalRecordSet_123   LockPhysicalRecordSet_189         3      LockPhysicalRecordSet_124     K                C    LMClearPhysLocksOnClose" @ LMClearPhysLocksOnClose_190 '   ! i LMClearPhysLocksOnClose_98    !  LMClearPhysLocksOnClose_99    "  LMClearPhysLocksOnClose_100          FindLogTable 7     OpenLogTable  OpenLogTable_191 +    H OpenLogTable_101 *    t    x FindLogNode  FindLogNode_192 9     FindLogNode_102      FindLogNode_103 	 FindLogNode_104  FindLogNode_105             5 FindLogNode_193 9    r FindLogNode_106      FindLogNode_107  FindLogNode_108          FindLogNode_194 6     FindLogNode_109      FindLogNode_110         OpenLogNode 8 OpenLogNode_111 E OpenLogNode_195 9    \     OpenLogNode_196  OpenLogNode_118  OpenLogNode_119  OpenLogNode_197         0     OpenLogNode_120     G     OpenLogNode_198  OpenLogNode_112 	    y        OpenFileStatusNode  OpenFileStatusNode_112          CloseFileStatusNode 3 CloseFileStatusNode_113     O CloseFileStatusNode_114     Q    l CloseLogTableNode  CloseLogTableNode_115      CloseLogTableNode_199  CloseLogTableNode_113      CloseLogTableNode_114     E     CloseLogTableNode_116 
 CloseLogTableNode_200 $ CloseLogTableNode_121 + CloseLogTableNode_201         >    F    T CloseLogTableNode_117 	    f CloseLogTableNode_202  CloseLogTableNode_121  CloseLogTableNode_203         >    9    AllocateLogTableNode  AllocateLogTableNode_118  AllocateLogTableNode_119  AllocateLogTableNode_204         2     AllocateLogTableNode_120     Y      Free                                                                                                                                                                                                                                                   n                        x $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           LogTableNode ,  FreeLogTableNode_121 3  FreeLogTableNode_205         M    T  AllocateEventNode j  AllocateEventNode_122 |  AllocateEventNode_123 |  AllocateEventNode_206         3      AllocateEventNode_124     [      
FreeEventNode   FreeEventNode_125   FreeEventNode_207         N     ! AllocateLockRecord ! AllocateLockRecord_126 (! AllocateLockRecord_127 (! AllocateLockRecord_208         2    N! AllocateLockRecord_128     Y    \! FreeLockRecord ! FreeLockRecord_129 ! FreeLockRecord_209         M    ! 
CompareU_Nums 9   ! ! LMReleaseClientPhysLockRes%  " LMReleaseClientPhysLockRes_130 
   % T" LMReleaseClientPhysLockRes_131% \" LMReleaseClientPhysLockRes_132% s" LMReleaseClientPhysLockRes_133 
    $    3        " LMClientEOTPhysicalLock    		
x           	  	  
     
  ʸ 
	    	     	                  	  ϭ        	 ϭ  	           
               ' 		                                                                          ɲ            
 

	        
                                  
                                            	                                	           LOCKMGR " 	PGETINT32 <    # StartupLockManager # StartupLockManager_1     d    l# ShutDownLockManager 0    # InitLockManager /    # LMClientEndOfTask <    $ LMReleaseClientResources /    8$ AgeLocks ;   		{" ] 7  				
    STATS t$ 	PGETINT32 <    $ StartupStatsStruct $ StartupStatsStruct_1     % StartupStatsStruct_2         @% ShutDownStatsStruct     X% 	InitStats      x% 
IncNWProcs     % 
DecNWProcs     % 
GetNumNWProcs     % IncOpenRequests     % SetOpenRequests     % GetOpenRequests     % IncReadRequests     & SetReadRequests     & GetReadRequests     0& IncWriteRequests     D& SetWriteRequests     X& GetWriteRequests     l& IncCacheHits     & SetCacheHits     & GetCacheHits & GetCacheHits_3     <    & IncCacheMisses     & SetCacheMisses     & GetCacheMisses ' GetCacheMisses_4     H   " @' IncCreateConnectionRequests    " T' SetCreateConnectionRequests    " h' GetCreateConnectionRequests     |' CheckCurrentConnCount     ' SetMaxSimultaneousConns     ' GetMaxSimultaneousConns     ' IncTotalPacketsReceived     ' SetTotalPacketsReceived     ' GetTotalPacketsReceived     ' IncPrintRequests     ( GetPrintRequests     $( IncMessageRequests     8( GetMessageRequests     L( IncDirectoryRequests     `( GetDirectoryRequests      t( IncBinderyAndMiscRequests      ( GetBinderyAndMiscRequests     ( IncUnknownRequests     ( SetUnknownRequests     ( GetUnknownRequests     ( IncNumOpenFiles %     ) DecNumOpenFiles     ) GetNumOpenFiles     ,) SetMaxSimultaneousOpens     @) GetMaxSimultaneousOpens     T) IncTTSRequests     h) SetTTSRequests     |) GetTTSRequests     ) IncTransactionsPerformed     ) SetTransactionsPerformed     ) GetTransactionsPerformed    $ ) IncTransactionWritesPerformed    $ ) GetTransactionWritesPerformed     ) IncTransactionBackouts     * SetTransactionBackouts     * GetTransactionBackouts    ! 0* IncUnfilledBackoutRequests    ! D* GetUnfilledBackoutRequests     X* IncNumTransactions #    |* DecNumTransactions     * GetNumTransactions    % * SetMaxSimultaneousTransactions    % * GetMaxSimultaneousTransactions     * IncLostPacketResend     * SetLostPacketResend     * GetLostPacketResend     + IncCreateFileRequests      + SetCreateFileRequests     4+ GetCreateFileRequests     H+ IncLogicalLockRequests     \+ IncLogicalLocks %    + DecLogicalLocks     + SetLogicalLockRequests     + GetLogicalLockRequests     + GetNumLogicalLocks    % + SetMaxSimultaneousLogicalLocks    % + GetMaxSimultaneousLogicalLocks      , IncFileLockRequests     , IncFileLocks %    <, DecFileLocks     T, SetFileLockRequests     h, GetFileLockRequests    " |, SetMaxSimultaneousFileLocks    " , GetMaxSimultaneousFileLocks     , GetNumFileLocks     , IncPhysLockRequests     , IncPhysLocks *    , DecPhysLocks     - SetPhysLockRequests     ,- GetPhysLockRequests    " D- SetMaxSimultaneousPhysLocks    " \- GetMaxSimultaneousPhysLocks     t- GetNumPhysLocks     - IncSemaphoreRequests     - 
IncSemaphores *    - 
DecSemaphores     - SetSemaphoreRequests      . GetSemaphoreRequests    # . SetMaxSimultaneousSemaphores    # 0. GetMaxSimultaneousSemaphores     H. GetNumSemaphores     `. IncAFPRequests     t. GetAFPRequests     . IncMessagesSent     . SetMessagesSent     . GetMessagesSent     . 
IncInforms . IncInforms_5         . 
GetInforms     . IncEventsEntered     / GetEventsEntered     (/ IncEventsServiced     </ GetEventsServiced     T/ IncWatchdogPacketsSent     h/ SetWatchdogPacketsSent     / GetWatchdogPacketsSent     / IncNumClientsWatchdogged     / SetNumClientsWatchdogged     / GetNumClientsWatchdogged     / IncNumCurrentDirHandles     / DecNumCurrentDirHandles     0 GetNumCurrentDirHandles     0 IncLoginFailures     00 GetLoginFailures     H0 IncNumSalvagedFiles     \0 SetNumSalvagedFiles     t0 GetNumSalvagedFiles     0 IncSalvageFileFailures     0 SetSalvageFileFailures     0 GetSalvageFileFailures      0 IncHostFSRightsRejections      0 SetHostFSRightsRejections      0 GetHostFSRightsRejections     1 IncNewFSEntries     (1 SetNewFSEntries     @1 GetNewFSEntries     X1 IncLostFSEntries     l1 SetLostFSEntries     1 GetLostFSEntries     1 IncDirCacheMisses     1 SetDirCacheMisses     1 GetDirCacheMisses     1 IncDirCacheHits     1 SetDirCacheHits     2 GetDirCacheHits    ! $2 IncClearTextPasswordLogins    ! 82 GetClearTextPasswordLogins    		t$                                                                                                                                                                                                                                                                              o                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              & "                                                                                   
    INFORM P2 	PGETINT32 <   
 2 Inform 2 Inform_1 2 Inform_2     +    3 Inform_3 83 Inform_4 R3 Inform_5 "    <    k    3 Inform_6 3 Inform_7 4 	Inform_41 44 	Inform_37 ;4 	Inform_38         W    _4 Inform_8 "           4 Inform_9 4 	Inform_10     4 	Inform_11     4 	Inform_12 4 	Inform_13     4 	Inform_14     )5 	Inform_15     d        D5 	Inform_16 5 	Inform_17     5 	Inform_18 5 	Inform_19     5 	Inform_20     ?6 	Inform_21     k6 	Inform_22 6 	Inform_23     -    6 	Inform_24     6 	Inform_25 6 	Inform_42 7 	Inform_36     G    p7 	Inform_26 '    7 	Inform_27 
       }         (8 GetMessageFromNumber K8 GetMessageFromNumber_28 K8 GetMessageFromNumber_43 8 GetMessageFromNumber_35             8 GetMessageFromNumber_29 8 GetMessageFromNumber_30 8 GetMessageFromNumber_44 '9 GetMessageFromNumber_35     ~            o9 GetMessageFromNumber_31      o9 GetMessageFromNumber_45 9 GetMessageFromNumber_32     9 GetMessageFromNumber_33 9 GetMessageFromNumber_34     4    p       9 GetMessageFromFile : GetMessageFromFile_32     : GetMessageFromFile_33 @: GetMessageFromFile_34     1    z    d: SetMessageLanguage : SetMessageLanguage_35         : MakeOLDLogFileName 0; MakeOLDLogFileName_36     L    @; 
IsInAlertList t; IsInAlertList_37 {; IsInAlertList_38         a    ; AsyncInform 4    ; AsyncInformService     ; FileSystemAvailToLogger     < 
PWVN$cachemsg 6< PWVN$cachemsg_39 
    < PWVN$cachemsg_40 `   F  		P2  3                                           
	 	   
                                              OPMSG L? 
set_optype     \? 
send_opcom w   		L? !  
    PACKET ? 	PGETINT32 <    @ 
InitPacket      @ ConvertNCPPacket 4    T@ SendReplyToClient @ SendReplyToClient_1 #    |    @ 
SendLastReply      @ SetClientCommInfo A SetClientCommInfo_2     A SetClientCommInfo_3     _A SetClientCommInfo_4     |A SetClientCommInfo_5     A SetClientCommInfo_6 	        A GetClientAddress 0   ! A PrivateNCPLogoutConnection ,    A PrivateNCPLockFail 4    $B PrivateNCPLockSuccess 2   		1?  
 
 
            
  
         UCOMM XB 	PGETINT32 <    B OpenUDPChannel     B CloseUDPChannel     B GetUDPPacket     B 
SendUDPPacket 
   		XB (  		 	      MPS_COMM B 	PGETINT32 <    C StartupComm C 
StartupComm_1 #    ?    DC ShutDownComm WC ShutDownComm_77 lC ShutDownComm_28 yC ShutDownComm_29 (    8    c    w    C BuildNCPMuxChannel C BuildNCPMuxChannel_2     C BuildNCPMuxChannel_3 D BuildNCPMuxChannel_4          D BuildNCPMuxChannel_5 -D BuildNCPMuxChannel_6      
    UD BuildNCPMuxChannel_7     D BuildNCPMuxChannel_8 "    D BuildNCPMuxChannel_9 +    ;E BuildNCPMuxChannel_10 #    E BuildNCPMuxChannel_11 %    E BuildNCPMuxChannel_12     F BuildNCPMuxChannel_13 #    oF BuildNCPMuxChannel_14     F BuildNCPMuxChannel_78 F BuildNCPMuxChannel_63     F BuildNCPMuxChannel_64     F BuildNCPMuxChannel_65     e    F BuildNCPMuxChannel_15     P   G OpenChannel 6G OpenChannel_16     LG OpenChannel_17 ZG OpenChannel_18         hG OpenChannel_19 uG OpenChannel_20      
    ~G OpenChannel_21     G OpenChannel_22 G OpenChannel_23     H OpenChannel_24     y     H OpenChannel_25 EH OpenChannel_26     H OpenChannel_27            H CloseChannel  I CloseChannel_28 I CloseChannel_29 (    6    l    LI EnableAsyncOnSocket dI EnableAsyncOnSocket_30 uI EnableAsyncOnSocket_31 I EnableAsyncOnSocket_32 I EnableAsyncOnSocket_33     <    I EnableAsyncOnSocket_34 J EnableAsyncOnSocket_35     e                4J 	GetPacket YJ GetPacket_36     hJ GetPacket_37 	    zJ GetPacket_38     J GetPacket_39 J GetPacket_40     J GetPacket_41     9K GetPacket_42 BK GetPacket_43     HK GetPacket_44 rK GetPacket_45 K GetPacket_46 
    K GetPacket_47 
    a            K GetPacket_48     _      K 
SendPacket L 
SendPacket_49 	    L 
SendPacket_50     -L 
SendPacket_51 YL 
SendPacket_52     L 
SendPacket_53     L 
SendPacket_54 L 
SendPacket_55     /           M CompareIPXAddress +    4M GetDriverServerAddress  _M GetDriverServerAddress_56      M GetDriverServerAddress_57      M GetDriverServerAddress_79 >        N NCPMuxBadPacketACK =N NCPMuxBadPacketACK_58     s    N GetNCPMuxClientAddress  N GetNCPMuxClientAddress_59      N GetNCPMuxClientAddress_60        ! O SetNCPMuxClientsPerProcess$ 4O SetNCPMuxClientsPerProcess_61    $ fO SetNCPMuxClientsPerProcess_62     o    |O MarkEngineForUse O MarkEngineForUse_63     O MarkEngineForUse_64     O MarkEngineForUse_65     n    O SetNCPMuxMaxProcs P SetNCPMuxMaxProcs_66     FP SetNCPMuxMaxProcs_67     o    \P DestroyNCPMuxClient k    P SetNCPMuxMaxConnections! P SetNCPMuxMaxConnections_68    ! "Q SetNCPMuxMaxConnections_69     o    8Q SendPrivateNCP `Q SendPrivateNCP_70     Q SendPrivateNCP_71         Q NegotiateBuffSize Q NegotiateBuffSize_72 FR NegotiateBuffSize_73     `R NegotiateBuffSize_74 sR NegotiateBuffSize_80 7    h           R BindToSocket 8    S dbg$dump_writepool S dbg$dump_writepool_75 S dbg$dump_writepool_81 S dbg$dump_writepool_76 ?    r    r    /   LT dbg$dump_writebuffer T dbg$dump_writebuffer_76 ?       		B                      
         
      		              
    	              
                                                                                                                                                                                                                                                    p                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              S "                    
  

    

         *       	CONNTABLE T 	PGETINT32 <    U StartupConnectionTable TU StartupConnectionTable_1     U StartupConnectionTable_2 \    V StartupConnectionTable_3     jV StartupConnectionTable_4 )       V ShutDownConnectionTable      V AllocConnectionSlot wW AllocConnectionSlot_5 W AllocConnectionSlot_6     !    W AllocConnectionSlot_7 W AllocConnectionSlot_8     ,    W AllocConnectionSlot_9      X AllocConnectionSlot_10     \X AllocConnectionSlot_11 gX AllocConnectionSlot_12 
    ~X AllocConnectionSlot_13 
    /       X GetConnectionFlags $    X SetConnectionFlags 8     Y ClearConnectionFlags 8    8Y GetConnectionStatusFlags 4    lY 
GetClientType l    Y 
SetClientType l    DZ SetMaxBufferSize p    Z GetMaxBufferSize p    $[ GetExpectedSeqNumber ?    d[ SetConnectionName [ SetConnectionName_14     [ SetConnectionName_15  \ SetConnectionName_16     F        @\ GetConnectionName \ GetConnectionName_17         \ GetConnectionNamePtr &] GetConnectionNamePtr_18         T] SetConnectionObjectType p    ] GetConnectionObjectType p    4^ SetConnectionObjectID p    ^ GetConnectionObjectID w   $ _ SetConnectionConnectTimeCheck p   $ _ GetConnectionConnectTimeCheck p   $ _ ResetConnectionRecentRequests l   " h` GetConnectionRecentRequests p   # ` GetConnectionRecentReadBytes o   % Ha ResetConnectionRecentReadBytes k   $ a GetConnectionRecentWriteBytes o   & $b ResetConnectionRecentWriteBytes k    b SetConnectionLoginTime H    b GetConnectionLoginTime x   & Pc GetConnectionLoginTimeInMinutes p    c SetConnectionEquivs 3d SetConnectionEquivs_19     Pd SetConnectionEquivs_20         pd ResetConnectionEquivs e ResetConnectionEquivs_21      e ResetConnectionEquivs_22         @e GetConnectionEquivs e GetConnectionEquivs_23     |   " e GetConnectionUndefinedField 8   " e PutConnectionUndefinedField 8   ! ,f GetConnectionWatchdogCount p   ! f SetConnectionWatchdogCount p   ! g IncConnectionWatchdogCount l   & xg GetConnectionLastPacketInterval p   & g PutConnectionLastPacketInterval 8     h IncConnectionRequests ]h IncConnectionRequests_24     _    h GetConnectionRequests p    h IncConnectionReadBytes 4    $i GetConnectionReadBytes p    i IncConnectionWriteBytes 4    i GetConnectionWriteBytes p    8j IncConnectionOpenFiles S    j DecConnectionOpenFiles p    j GetConnectionOpenFiles p    lk SetConnectionMessage k SetConnectionMessage_25     k SetConnectionMessage_26     l SetConnectionMessage_27 "l SetConnectionMessage_28         8l SetConnectionMessage_29         ll GetConnectionMessage l GetConnectionMessage_30     l GetConnectionMessage_31 l GetConnectionMessage_32     l GetConnectionMessage_33 '    6    m GetConnectionMessage_34 '    Wm GetConnectionMessage_35 
    hm GetConnectionMessage_36     !  $ m SetConnectionHybridUserStruct T   $ m GetConnectionHybridUserStruct _    Dn SetConnectionMemDebugPtr T    n GetConnectionMemDebugPtr 8    n SetConnectionSpoolerInfo p    @o GetConnectionSpoolerInfo p    o SwapKey <    o SetConnectionLogKey 5p SetConnectionLogKey_37     Tp SetConnectionLogKey_38     mp SetConnectionLogKey_39 }p SetConnectionLogKey_40     p SetConnectionLogKey_163 5    q       p GetConnectionLogKey p    dq SetConnectionCommInfo     r GetConnectionCommInfo Pr GetConnectionCommInfo_41 Tr GetConnectionCommInfo_42          p    |r LoginConnection r LoginConnection_164 >    s LoginConnection_43 
    s LoginConnection_44 s LoginConnection_45     N        t LogoutConnection    " t DeAllocConnectionSlotMemory% t DeAllocConnectionSlotMemory_46 
   % t DeAllocConnectionSlotMemory_47 
   % t DeAllocConnectionSlotMemory_48 
   % t DeAllocConnectionSlotMemory_49 
   % t DeAllocConnectionSlotMemory_50    % u DeAllocConnectionSlotMemory_51    % 3u DeAllocConnectionSlotMemory_52         Pu GetConnectionList u GetConnectionList_53 u GetConnectionList_54 9    W        v GetConnectionsInUse 0v GetConnectionsInUse_55 (    l     pv GetClientConnectionsInUse# v GetClientConnectionsInUse_56# v GetClientConnectionsInUse_57     :    ~    v AllocDirectoryHandle 7w AllocDirectoryHandle_58 Iw AllocDirectoryHandle_59     ww AllocDirectoryHandle_60     w AllocDirectoryHandle_61 	        w AllocDirectoryHandle_62     Cx AllocDirectoryHandle_63 Ox AllocDirectoryHandle_64     mx AllocDirectoryHandle_65     ~x AllocDirectoryHandle_66 x AllocDirectoryHandle_67     *    g    x AllocDirectoryHandle_68 x AllocDirectoryHandle_69            x RemoveDirectoryHandle <y RemoveDirectoryHandle_70     ay RemoveDirectoryHandle_71     hy RemoveDirectoryHandle_72 sy RemoveDirectoryHandle_73 &    y RemoveDirectoryHandle_74     y RemoveDirectoryHandle_75     d        y RemoveTempDirHandles  z RemoveTempDirHandles_76     Ez RemoveTempDirHandles_77     Lz RemoveTempDirHandles_78 jz RemoveTempDirHandles_79 $    z RemoveTempDirHandles_80 z RemoveTempDirHandles_81         z RemoveTempDirHandles_82     r        z RemoveAllClientHandles  { RemoveAllClientHandles_83      5{ RemoveAllClientHandles_84      <{ RemoveAllClientHandles_85  u{ RemoveAllClientHandles_86     ;     |{ RemoveAllClientHandles_87 "        { GetHandleDirEntry { GetHandleDirEntry_88     | GetHandleDirEntry_89     | GetHandleDirEntry_90 '| GetHandleDirEntry_91 
    E| GetHandleDirEntry_92     `| GetHandleDirEntry_93     H        x| GetHandleVolumeNumber | GetHandleVolumeNumber_94     | GetHandleVolumeNumber_95     | GetHandleVolumeNumber_96 | GetHandleVolumeNumber_97 	    	} GetHandleVolumeNumber_98     $} GetHandleVolumeNumber_99     D        <} 
GetHandleType |} GetHandleType_100     } GetHandleType_101     } GetHandleType_102 } GetHandleType_103 	    } GetHandleType_104     } GetHandleType_105     D         ~ GetHandleRights @~ GetHandleRights_106     e~ GetHandleRights_107     l~ GetHandleRights_108 w~ GetHandleRights_109 	    ~ GetHandleRights_110     ~ GetHandleRights_111     D        ~ SetHandleRights  SetHandleRights_112     ) SetHandleRights_113     0 SetHandleRights_114 ; SetHandleRights_115 	    U SetHandleRights_116     p SetHandleRights_117     D         
GetHandlePath      
SetHandlePath  SetHandlePath_118      SetHandlePath_119      SetHandlePath_120  SetHandlePath_121     5 SetHandlePath_122     P SetHandlePath_123     X       # h RemoveDirHandlesWithDirEntry'   RemoveDirHandlesWithDirEntry_124'   RemoveDirHandlesWithDirEntry_125'   RemoveDirHandlesWithDirEntry_126    ' $  RemoveDirHandlesWithDirEntry_127     X            ` GetNewFileSequenceNum H     
SetPacketAddr ā SetPacketAddr_128     <     
GetPacketAddr   GetPacketAddr_129     ?    $ GetOutNCPLength 6 GetOutNCPLength_130     4    X SetConnectionSyncTrigger ,     
TriggerPacket Ƃ TriggerPacket_131  TriggerPacket_132 
     TriggerPacket_133     7 TriggerPacket_134     @ TriggerPacket_135 M TriggerPacket_136 b TriggerPacket_137 z Tr                                                                                                                                                                                                                                                   q                        S $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              G "           iggerPacket_138  TriggerPacket_165  TriggerPacket_161 !    N    Y    ؃ TriggerPacket_139  TriggerPacket_166  TriggerPacket_161 !    L    W    : TriggerPacket_167 T TriggerPacket_161 !    M    ?   T   a      *    InterlockPacket * InterlockPacket_140 F    t InterlockPacket_141  InterlockPacket_142     ]    $   ԅ DestroyConnection  DestroyConnection_143 =    {    P CancelDestroyAndGetFlags H     
SetContextHdr P     
GetContextHdr P    8 GetLocalFileTable $   $ \ ConnTableSyncConnectionTables(  !ConnTableSyncConnectionTables_144      b     
lock_event @      GuessConnectionNumber   GuessConnectionNumber_145  , GuessConnectionNumber_146 
    "     E GuessConnectionNumber_147      I GuessConnectionNumber_148     X     X GetConnectionWatchdogVCID$ x GetConnectionWatchdogVCID_149$  GetConnectionWatchdogVCID_150$  GetConnectionWatchdogVCID_151     *    L       " ܈ SetAllConnectionStatusFlags&  SetAllConnectionStatusFlags_152     Z    8 SetThreadID $    \ SetConnectionStatusFlags ,   !  ClearConnectionStatusFlags <    ĉ BroadcastToAllObjectIDs"  BroadcastToAllObjectIDs_153"  BroadcastToAllObjectIDs_154     A        P Diag_dump_ConnInfo  Diag_dump_ConnInfo_155  Diag_dump_ConnInfo_156 +    A    ̊ Diag_dump_ConnInfo_157 +       !  Diag_dump_Connection_Entry% 2 Diag_dump_Connection_Entry_168    % ǋ Diag_dump_Connection_Entry_169%  Diag_dump_Connection_Entry_160 0    e   % G Diag_dump_Connection_Entry_170% n Diag_dump_Connection_Entry_158 ?    q   %  Diag_dump_Connection_Entry_171% Ԍ Diag_dump_Connection_Entry_159 -    W    F   X Diag_dump_Login_Info  Diag_dump_Login_Info_172      Diag_dump_Login_Info_173 B Diag_dump_Login_Info_160 0    e    O    print_lic_type ֎ print_lic_type_158 @    |    $ print_lic_status I print_lic_status_159 1    d     
print_address       print_objectType R print_objectType_160 1    o     DumpNCP  DumpNCP_161 !    X     dbg$dump_conntable d dbg$dump_conntable_162           dbg$dump_connection_entry #  		T   	       0                             
  	  	    	    
      
 
        
               	       	   	    	
                                                   
       
       
       	
        
        
        " 	                        
             	       !    	     
  ṩ
 	              
     PROPOPS  	PGETINT32 <     GetPropertyRecord  GetPropertyRecord_1 T    Q GetPropertyRecord_2         t PutPropertyRecord  PutPropertyRecord_3 <    Ք PutPropertyRecord_4 )          CheckPropertyAccessObject"  CheckPropertyAccessObject_5 
   "   CheckPropertyAccessObject_6    " J CheckPropertyAccessObject_7 I         CheckPropertyAccess  CheckPropertyAccess_8 *     CheckPropertyAccess_9 
     CheckPropertyAccess_10     6 CheckPropertyAccess_11 I         FindProperty  FindProperty_12  FindProperty_115  FindProperty_1 X    t FindProperty_2             x    AddProperty d    ` DeleteProperty      ChangePropertySecurity  i ChangePropertySecurity_13      ~ ChangePropertySecurity_14       ChangePropertySecurity_15  " ChangePropertySecurity_16! > ChangePropertySecurity_116 l ChangePropertySecurity_3 >     ChangePropertySecurity_4 (                :     ScanProperties ? ScanProperties_17     b ScanProperties_18      l ScanProperties_19 !         
ListRelations  ListRelations_20      ListRelations_21 )    | ListRelations_22  ListRelations_23     Ӝ ListRelations_24 ٜ ListRelations_117 2    P    8 ListRelations_25 @ ListRelations_118 4     ListRelations_26     `    +       ȝ CheckAndGetPropertyObject#  CheckAndGetPropertyObject_27    # > CheckAndGetPropertyObject_28 A         CheckAndGetProperty ! CheckAndGetProperty_29     N CheckAndGetProperty_30 A        ReadProperty  ReadProperty_31 &    \     
WriteProperty  WriteProperty_32         Ġ WriteLogControlProperty #     VerifyPassword # VerifyPassword_33     ġ VerifyPassword_34     С VerifyPassword_35      VerifyPassword_36     i VerifyPassword_37     p VerifyPassword_38 3 VerifyPassword_119 6    n VerifyPassword_39     { VerifyPassword_40         VerifyPassword_41  VerifyPassword_42  VerifyPassword_43          VerifyPassword_44     4     VerifyPassword_45  VerifyPassword_46 + VerifyPassword_47         n    4 VerifyPassword_48 8 VerifyPassword_120 3     VerifyPassword_121 3    ޤ VerifyPassword_49          VerifyPassword_50 
 VerifyPassword_51  VerifyPassword_52  VerifyPassword_122 5    Q    h VerifyPassword_53 n VerifyPassword_123 5    J             VerifyPassword_54     > VerifyPassword_55 r     VerifyPassword_56         Ȧ ChangePassword M ChangePassword_57 :     ChangePassword_58      ChangePasswor                                                                                                                                                                                                                                                   r                         z $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                                "     $      d_59      ChangePassword_60     D ChangePassword_61 V ChangePassword_62     $     ChangePassword_63      ChangePassword_64     Ө ChangePassword_65 ڨ ChangePassword_66  ChangePassword_124 5    = ChangePassword_125 5             ChangePassword_67 ĩ ChangePassword_126 5     ChangePassword_127 5        d ChangePassword_68 x ChangePassword_69          ChangePassword_70 ƪ ChangePassword_71     ժ ChangePassword_72  ChangePassword_73          ChangePassword_74  ChangePassword_75          ChangePassword_76     M ChangePassword_77 a ChangePassword_78 
    p ChangePassword_79  ChangePassword_80  ChangePassword_81         <     ChangePassword_82         y    ChangePassword_83 Y       p GroupAdd  GroupAdd_84      GroupAdd_85 ѭ GroupAdd_86 !    e    8 GroupAdd_87     Q GroupAdd_88 :     GroupAdd_89      GroupAdd_90      GroupAdd_91 3 GroupAdd_92 3 GroupAdd_128 ;    >    | GroupAdd_93 *        ү GroupAdd_129 :       P GroupDelete ܰ GroupDelete_94      GroupDelete_95  GroupDelete_130 3    < GroupDelete_96 G           ر CheckPrivilegeLevel  CheckPrivilegeLevel_97     l CheckPrivilegeLevel_98      CheckPrivilegeLevel_99 )         AddMemberToGroup β AddMemberToGroup_100 )    `     DeleteMember 1 DeleteMember_101     e DeleteMember_102       DeleteMember_103       DeleteMember_104      DeleteMember_105 .    (   8 
CountLinks S CountLinks_106 p CountLinks_107 | CountLinks_108  CountLinks_109  CountLinks_110  CountLinks_131 2    P    m    x            | CountLinks_111 | CountLinks_132  CountLinks_1 ^     CountLinks_2          CountLinks_112 H CountLinks_113 d CountLinks_133 7     CountLinks_114             y     #  GrantSupervisorMailDirAccess'   GrantSupervisorMailDirAccess_134 2       $  RevokeSupervisorMailDirAccess( ӷ !RevokeSupervisorMailDirAccess_135 2       		  x  
      	               
            
    
	 

              
                                                
 
                                                     	   
                                                                                              

        
	                    
                       	3      BINDOPS l 	PGETINT32 <     BinderyHash E     GetObjectRecord  GetObjectRecord_1 Q GetObjectRecord_2     Y    V GetObjectRecord_3         | PutObjectRecord  PutObjectRecord_4 A     PutObjectRecord_5 )         
DumpObject |     GetValueRecord  GetValueRecord_6 ]     GetValueRecord_7          PutValueRecord = PutValueRecord_8 >    { PutValueRecord_9 )         ObjectHashFromFile  ObjectHashFromFile_10         4 ObjectHashToFile  ObjectHashToFile_11           ReplaceObjectHashFromFile# m ReplaceObjectHashFromFile_12          InvisibleStaticServers      FindStaticObject B FindStaticObject_13     T FindStaticObject_14 ` FindStaticObject_15 ` FindStaticObject_79 <     FindStaticObject_80 ܾ FindStaticObject_10 	            . FindStaticObject_81 :    "    FindStaticObject_16  FindStaticObject_82  FindStaticObject_1  FindStaticObject_2 	    a     FindStaticObject_3         K FindStaticObject_17 R FindStaticObject_18         s FindStaticObject_19 w FindStaticObject_20      FindStaticObject_21  FindStaticObject_22          FindStaticObject_23  FindStaticObject_24     3    h     FindStaticObject_25 $    l       AddObjectToHash . AddObjectToHash_83 K     AddObjectToHash_26  AddObjectToHash_84  AddObjectToHash_10 	            W AddObjectToHash_27 _ AddObjectToHash_85  AddObjectToHash_4 H     AddObjectToHash_5 (         AddObjectToHash_28  AddObjectToHash_29  AddObjectToHash_86 k AddObjectToHash_11                     AddObjectToHash_30 ( AddObjectToHash_31 / AddObjectToHash_87 B AddObjectToHash_1  AddObjectToHash_2 	    b     AddObjectToHash_3              AddObjectToHash_32  AddObjectToHash_88   AddObjectToHash_4 G    h AddObjectToHash_5 (         AddObjectToHash_89  AddObjectToHash_4 I     AddObjectToHash_5 (        _   '   /   L RemoveObjectFromHash ` RemoveObjectFromHash_90 M     RemoveObjectFromHash_33  RemoveObjectFromHash_91  RemoveObjectFromHash_10 	             RemoveObjectFromHash_34  RemoveObjectFromHash_92  RemoveObjectFromHash_11         !    RemoveObjectFromHash_35  RemoveObjectFromHash_93  RemoveObjectFromHash_1 + RemoveObjectFromHash_2 	    d    4 RemoveObjectFromHash_3         d RemoveObjectFromHash_36 m RemoveObjectFromHash_37 v RemoveObjectFromHash_94  RemoveObjectFromHash_4 H     RemoveObjectFromHash_5 ,              RemoveObjectFromHash_38         e      < 	AddObject  AddObject_39      AddObject_40      AddObject_41 2 AddObject_42     $    J AddObject_43 O AddObject_44     x AddObject_45          AddObject_46      AddObject_47 ' AddObject_48     ?    W AddObject_49 [ AddObject_95 o AddObject_1  AddObject_2 	    ^     AddObject_3              AddObject_50  AddObject_51     - AddObject_52 0 AddObject_96 \ AddObject_4 I     AddObject_5 ,                7 AddObject_53 %    a AddObject_54  AddObject_55 :    k        DeleteObject L    H RenameObject  RenameObject_56 ' RenameObject_57     ^ RenameObject_58          RenameObject_59  RenameObject_60     ?     RenameObject_97  RenameObject_1 F RenameObject_2 	    ^    P RenameObject_3          RenameObject_61 !     RenameObject_62      RenameObject_63        d MapNameToObject      MapNameToID . MapNameToID_64     P    ` 
MapIDToObject  MapIDToObject_65      MapIDToObject_98  MapIDToObject_1 & MapIDToObject_2 	    ]    0 MapIDToObject_3         W MapIDToObject_66 .    4    CheckID  
CheckID_67  
CheckID_6                                                                                                                                                                                                                                                   s                         $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ~ "     5      8  
CheckID_69  
CheckID_70 & 
CheckID_71     1 
CheckID_72     ?    A    i            T FindNextObject u FindNextObject_73      FindNextObject_74  FindNextObject_75      FindNextObject_76  FindNextObject_77         [         GetLoginObject > GetLoginObject_78     Y   		'l  _  	           	      
                  
                                                                                                               	   	                   	 	   	                                    
          BINDUTIL t 	PGETINT32 <     GetSupervisorObjectID      	IsManager  IsManager_28 6        \ IsSupervisor 4     IsEquivalent A     MgtLevel 4     HasWildCardChar ( HasWildCardChar_1      L    T HasWierdChar  HasWierdChar_2  HasWierdChar_29  HasWierdChar_3     1    n         FindChar  
FindChar_3 
    $    0 	IsBadName     L LoggedUserID      l ChangeSecurity  ChangeSecurity_4  ChangeSecurity_5     E    H ChangeSecurity_6     ^ ChangeSecurity_7 C    h    KillDirectoryRights      FindTrustee      CheckStationObjectID [    P CanRead i 	CanRead_8     m 	CanRead_9          p CanWrite  CanWrite_10      CanWrite_11     %     ZapObjectLinks  ZapObjectLinks_12      ZapObjectLinks_13 !    l ZapObjectLinks_14  ZapObjectLinks_15  ZapObjectLinks_30 9    + ZapObjectLinks_16 0 ZapObjectLinks_17 \ ZapObjectLinks_18 l ZapObjectLinks_19  ZapObjectLinks_31 3     ZapObjectLinks_20 '                     ZapObjectLinks_21 < ZapObjectLinks_22 ] ZapObjectLinks_23  ZapObjectLinks_24  ZapObjectLinks_32 1     ZapObjectLinks_25 /            #   X       ZapObjectLinks_26 0     ZapObjectLinks_27     S   X  		t  | 
	             
                                                              DYNBINDCACHE  	PGETINT32 <    8 DynamicObjectPreallocate! P DynamicObjectPreallocate_1     [   !  DynamicPropertyPreallocate#  DynamicPropertyPreallocate_2     S     DynamicValuePreallocate   DynamicValuePreallocate_3     _   $ H InitializeDynamicBinderyCache' t  InitializeDynamicBinderyCache_76&  InitializeDynamicBinderyCache_1     X   '   InitializeDynamicBinderyCache_77&  InitializeDynamicBinderyCache_2     J   ' *  InitializeDynamicBinderyCache_78& = InitializeDynamicBinderyCache_3     V   &  InitializeDynamicBinderyCache_4    &  InitializeDynamicBinderyCache_5         DynBinderyHash E      GetDynamicObjectByName  % GetDynamicObjectByName_79 ;     GetDynamicObjectByName_6  GetDynamicObjectByName_7     @         FindDynamicObject  FindDynamicObject_8   FindDynamicObject_9     : FindDynamicObject_80 >    {     FindDynamicObject_10  FindDynamicObject_11      FindDynamicObject_12  FindDynamicObject_13  FindDynamicObject_14     #    6    Z     FindDynamicObject_15  FindDynamicObject_16  FindDynamicObject_17 $    P    L FindDynamicObject_18  FindDynamicObject_19  FindDynamicObject_20     B            FindDynamicObject_21  FindDynamicObject_22  FindDynamicObject_23  FindDynamicObject_24 ' FindDynamicObject_25     !    7 FindDynamicObject_26 N FindDynamicObject_27     '    L         FindDynamicObject_28  FindDynamicObject_29  FindDynamicObject_30     2    4            PutDynamicObject 8 PutDynamicObject_31 ? PutDynamicObject_32     #        p GetDynamicObjectUsingID!  GetDynamicObjectUsingID_33!  GetDynamicObjectUsingID_34     (       ! $ GetDynamicObjectPtrUsingID$  GetDynamicObjectPtrUsingID_35$  GetDynamicObjectPtrUsingID_36               GetDynamicProperty  GetDynamicProperty_81 P GetDynamicProperty_35 V GetDynamicProperty_36 	    !         GetDynamicProperty_37  GetDynamicProperty_38  GetDynamicProperty_39     '    R    d   4 GetDynamicPropertyPtr 9 GetDynamicPropertyPtr_82  GetDynamicPropertyPtr_35  GetDynamicPropertyPtr_36 	    !        ( GetDynamicPropertyPtr_40 2 GetDynamicPropertyPtr_41 I GetDynamicPropertyPtr_42     &    Q    `    RenameDynamicObject  RenameDynamicObject_83  RenameDynamicObject_35  RenameDynamicObject_36 	    !        \ RenameDynamicObject_84 M     RenameDynamicObject_43  RenameDynamicObject_44     -     RenameDynamicObject_85 >        AddDynamicPropertyPtr  AddDynamicPropertyPtr_86 4 AddDynamicPropertyPtr_35 : AddDynamicPropertyPtr_36 	    !        y AddDynamicPropertyPtr_45 y AddDynamicPropertyPtr_87  AddDynamicPropertyPtr_2     G    Q     AddDynamicPropertyPtr_46      AddDynamicPropertyPtr_47 
       ( GetDynamicValuePtr / GetDynamicValuePtr_88  GetDynamicValuePtr_35  GetDynamicValuePtr_36 	    !         GetDynamicValuePtr_48 # GetDynamicValuePtr_49     '     GetDynamicValuePtr_50  GetDynamicValuePtr_51      GetDynamicValuePtr_52     6        AddDynamicValue   AddDynamicValue_89 | AddDynamicValue_35  AddDynamicValue_36 	    !         AddDynamicValue_53  AddDynamicValue_54     '    B AddDynamicValue_55      AddDynamicValue_56  AddDynamicValue_57      AddDynamicValue_58     s    % AddDynamicValue_59 % AddDynamicValue_90 8 AddDynamicValue_3     W    a     AddDynamicValue_60       !  PutDynamicPropertySecurity$  PutDynamicPropertySecurity_91$ l PutDynamicPropertySecurity_35$ r PutDynamicPropertySecurity_36 	    !       $  PutDynamicPropertySecurity_61$  PutDynamicPropertySecurity_62     )    8   $ DeleteAllDynamicValues  d DeleteAllDynamicValues_63 1         DeleteDynamicProperty  DeleteDynamicProperty_64  DeleteDynamicProperty_65 8    U         AddDynamicObjectToCache!  AddDynamicObjectToCache_92 G   !  AddDynamicObjectToCache_66!  AddDynamicObjectToCache_93   AddDynamicObjectToCache_1     W    a   ! r AddDynamicObjectToCache_67 
    S  !  DeleteAllDynamicProperties$  DeleteAllDynamicProperties_68 ;       # t DeleteDynamicObjectFromCache&  DeleteDynamicObjectFromCache_69&  DeleteDynamicObjectFromCache_70&  DeleteDynamicObjectFromCache_71 )    A    j   & D DeleteDynamicObjectFromCache_94 G   &  DeleteDynamicObjectFromCache_72&  DeleteDynamicObjectFromCache_73&  DeleteDynamicObjectFromCache_74 )                                                                                                                                                                                                                                                   t                        2Z $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     F          A    l   &  DeleteDynamicObjectFromCache_75       		
  7            
                                                                             
                               	                                                                   ACECACHE ( 	PGETINT32 <    d I_AllocAheadAceCache  I_AllocAheadAceCache_1          
AllocAceCache  AllocAceCache_2  AllocAceCache_3   AllocAceCache_1                  DeallocAceCache    		u( >            PROPUTIL  	PGETINT32 <      	IsNullKey - IsNullKey_10 5         IsMember  
IsMember_1     T     	IsElement & IsElement_2     P    X ZapPropertyLinks ~ ZapPropertyLinks_3  ZapPropertyLinks_4  ZapPropertyLinks_5  ZapPropertyLinks_6      =            t ZapPropertyLinks_7  ZapPropertyLinks_8  ZapPropertyLinks_9      =          		  q  	   	                      BINDINT   	PGETINT32 <    T  
I_MgtLevel       I_DeleteObject 0 I_DeleteObject_1 Q I_DeleteObject_2 l I_DeleteObject_3 7    V         I_DeleteObject_4      I_DeleteObject_16      I_DeleteObject_5      I_DeleteObject_6      I_DeleteObject_7 E     I_DeleteObject_8 ] I_DeleteObject_9 r I_DeleteObject_10     /     I_DeleteObject_11             
I_MapNameToID e I_MapNameToID_17     *    
I_IsMember d 
I_IsMember_12 j 
I_IsMember_18 2     
I_IsMember_13 )     
I_IsMember_14          
I_IsMember_15        		   r  
                             
               PROPINT  	PGETINT32 <    H 
I_AddProperty t I_AddProperty_1  I_AddProperty_2          I_AddProperty_3     ( I_AddProperty_4 1     I_AddProperty_5      I_AddProperty_6     - I_AddProperty_7 i     I_AddProperty_8 '     I_AddProperty_9  I_AddProperty_10     @    z	 I_AddProperty_11 ,    	 I_AddProperty_12 	 I_AddProperty_13 
 I_AddProperty_14     s        d
 I_AddProperty_15 i
 I_AddProperty_16 +    A    a   
 I_DeleteProperty 
 I_DeleteProperty_17 8 I_DeleteProperty_18 z I_DeleteProperty_19  I_DeleteProperty_20     8            I_DeleteProperty_21  I_DeleteProperty_22     \    8 I_DeleteProperty_23 ,     I_DeleteProperty_24  I_DeleteProperty_25 A    6
 I_DeleteProperty_26 E        
 I_DeleteProperty_27 
 I_DeleteProperty_28 
 I_DeleteProperty_29      I_DeleteProperty_30 % I_DeleteProperty_31     )    D I_DeleteProperty_32      I_DeleteProperty_33 ~       t I_DeleteProperty_34 .        I_DeleteProperty_35  I_DeleteProperty_36 2    G    ! I_DeleteProperty_37 & I_DeleteProperty_38 2    G       l I_ReadProperty x I_ReadProperty_39 +     I_ReadProperty_40 +     I_ReadProperty_41 :    D I_ReadProperty_42 ^ I_ReadProperty_43      s I_ReadProperty_44     _     I_ReadProperty_45     {    I_WriteProperty  I_WriteProperty_46      I_WriteProperty_47      I_WriteProperty_48       I_WriteProperty_49     0 I_WriteProperty_50 L I_WriteProperty_51      ] I_WriteProperty_52     | I_WriteProperty_53  I_WriteProperty_54      I_WriteProperty_55         k     I_WriteProperty_56      I_WriteProperty_57  I_WriteProperty_58      .     I_WriteProperty_59 ) I_WriteProperty_60      ;    d I_WriteProperty_61  I_WriteProperty_62      >     I_WriteProperty_63 F     I_WriteProperty_64   I_WriteProperty_65          I_WriteProperty_66  I_WriteProperty_67 3    I    E   0 I_IsElement  I_IsElement_68  I_IsElement_69  I_IsElement_75 3    I        7 I_IsElement_70        P I_AddMember \ I_AddMember_71      I_AddMember_72  I_AddMember_73       I_AddMember_74 
    d       		                                                                                                                                                       ι                                         	BINDSETUP  	PGETINT32 <    H StartupBindery  StartupBindery_1  StartupBindery_2     5 StartupBindery_3      StartupBindery_4     D    StartupBindery_5 d StartupBindery_6      StartupBindery_7      StartupBindery_8      StartupBindery_9 <    | StartupBindery_10      StartupBindery_11 8        StartupBindery_12      StartupBindery_13      StartupBindery_14 @    0 StartupBindery_15        P ShutDownBindery 4     InitializeFileHash  InitializeFileHash_16 _    D InitializeFileHash_17         l CreateBinderyFiles  CreateBinderyFiles_18  CreateBinderyFiles_19     N CreateBinderyFiles_20     l CreateBinderyFiles_21 7     CreateBinderyFiles_22      CreateBinderyFiles_23 7    f CreateBinderyFiles_24      CreateBinderyFiles_25 7        CreateBinderyFiles_26  CreateBinderyFiles_27     D  CreateBinderyFiles_28       CreateBinderyFiles_29       CreateBinderyFiles_30 B    ! CreateBinderyFiles_31     4! CreateBinderyFiles_32 B       # CreateBinderyFiles_90 b       $ 
VerifyBindery F$ VerifyBindery_33    P% VerifyBindery_34 \% VerifyBindery_35      B   & VerifyBindery_36 & VerifyBindery_37 & VerifyBindery_38 4    4' VerifyBindery_39 N' VerifyBindery_40     l' VerifyBindery_41     O           ' VerifyBindery_42 ' VerifyBindery_43 ( VerifyBindery_44 .    4( VerifyBindery_45 R( VerifyBindery_46 
    g( VerifyBindery_47 l( VerifyBindery_48 %    L    ( VerifyBindery_49 0    ( VerifyBindery_50         L   c   3) VerifyBindery_51 "    |) VerifyBindery_52 ) VerifyBindery_53 ) VerifyBindery_54     ) VerifyBindery_55 ) VerifyBindery_56 8    $* VerifyBindery_57 I* VerifyBindery_58 Z* VerifyBindery_59         t* VerifyBindery_60 * VerifyBindery_61 * Veri                                                                                                                                                                                                                                                   u                        t $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              5, "     W      fyBindery_62         T    * VerifyBindery_63     * VerifyBindery_64         d         F+ VerifyBindery_65     , VerifyBindery_66 O, VerifyBindery_67     S    s, VerifyBindery_68 , VerifyBindery_69     O    - VerifyBindery_91 i    w- VerifyBindery_70     e
   |. SetupServerStation l    . OpenBinderyFiles / OpenBinderyFiles_71 Y/ OpenBinderyFiles_72     / OpenBinderyFiles_73     0 OpenBinderyFiles_74     0 OpenBinderyFiles_75        0 OpenBinderyFiles_76 0 OpenBinderyFiles_77 0 OpenBinderyFiles_78     C    1 OpenBinderyFiles_79 51 OpenBinderyFiles_80     B    Y1 OpenBinderyFiles_81 1 OpenBinderyFiles_82     D           1 OpenBindery X    2 CloseBindery     2 CloseBinderyFiles 2 CloseBinderyFiles_83 "    2 CloseBinderyFiles_84         d3 AllocBinderyMemory 3 AllocBinderyMemory_85     3 AllocBinderyMemory_86 3 AllocBinderyMemory_87     >    .4 AllocBinderyMemory_88     a4 AllocBinderyMemory_89     ,   4 DeallocBinderyMemory     4 InitBindery 4 InitBindery_92 $    \    4 InitBinderyMemory /   		J                                                                     	 
	                                                                                                                        
        
             BINDMISC $5 	PGETINT32 <    `5 CPSemaphore     p5 CVSemaphore    
 5 CFindD 5 CFindD_1     $    5 CSetD +    5 CMovD /     6 StartFSTransaction     6 EndFSTransaction    % 6 MapConnectionToInternetAddress 0    @6 CalcDays u    6 CalcMinutes 6 
CalcMinutes_2 h       		$5 q           LTRUSTEE L7 	PGETINT32 <    7 TrusteeClusterFuncTable  7 TrusteeClusterFuncTable_1 1      9 PerformTrusteeSync 39 PerformTrusteeSync_2 99 PerformTrusteeSync_3 7    =    }9 PerformTrusteeSync_4      n    9 TrusteeBlockingAST2 N    9 TrusteeBlockingAST J    (: TrusteeResumeThread     8: TrusteeClusterLock r: TrusteeClusterLock_5 : TrusteeClusterLock_6     ; TrusteeClusterLock_7 1; TrusteeClusterLock_8 :        ; TrusteeClusterLock_9 ; TrusteeClusterLock_10     -    < TrusteeClusterLock_11     F< TrusteeClusterLock_12     < TrusteeClusterLock_13 8    < TrusteeClusterLock_14     U= TrusteeClusterLock_15 9    = TrusteeClusterLock_16     W      = BroadcastToOtherServers! > BroadcastToOtherServers_17 *   ! l> BroadcastToOtherServers_18! z> BroadcastToOtherServers_19    ! > BroadcastToOtherServers_20 :    f   ! > BroadcastToOtherServers_21 	    6   ? GetClusterServerNames ,    0? PurgeTrustee [? PurgeTrustee_22     ? PurgeTrustee_23 g    7@ PurgeTrustee_24 <@ PurgeTrustee_25     !    8  $ h@ AddExplicitTrusteeToDirectory' @  AddExplicitTrusteeToDirectory_26    ' @  AddExplicitTrusteeToDirectory_27' 
A  AddExplicitTrusteeToDirectory_28    ' <A  AddExplicitTrusteeToDirectory_29    ' PA  AddExplicitTrusteeToDirectory_30    ' A  AddExplicitTrusteeToDirectory_31    ' A  AddExplicitTrusteeToDirectory_32    ' A  AddExplicitTrusteeToDirectory_33    ' (B  AddExplicitTrusteeToDirectory_34     K  ' BB  AddExplicitTrusteeToDirectory_35' GB  AddExplicitTrusteeToDirectory_36     .    )  ! B RemoveTrusteeFromDirectory$ B RemoveTrusteeFromDirectory_37    $ B RemoveTrusteeFromDirectory_38$ C RemoveTrusteeFromDirectory_39     6   $ ,C RemoveTrusteeFromDirectory_40     $ 5C RemoveTrusteeFromDirectory_41$ :C RemoveTrusteeFromDirectory_42     /       " xC GetDirectoryInheritedRights @    C GetFileInheritedRights L   & D GetDirectoryInheritedRightsName p    tD GetInheritedRights D GetInheritedRights_43        "  E SetDirectoryInheritedRights% EE SetDirectoryInheritedRights_44% VE SetDirectoryInheritedRights_45 
       % E SetDirectoryInheritedRights_46 D   % E SetDirectoryInheritedRights_47% E SetDirectoryInheritedRights_48% 
F SetDirectoryInheritedRights_49     2    H       <F EraseTrusteeDirectory sF EraseTrusteeDirectory_50 F EraseTrusteeDirectory_51 
    ;    F EraseTrusteeDirectory_52 F EraseTrusteeDirectory_53     &        G AddExplicitTrusteeToFile" )G AddExplicitTrusteeToFile_54" :G AddExplicitTrusteeToFile_55 
       " G AddExplicitTrusteeToFile_56" G AddExplicitTrusteeToFile_57    " G AddExplicitTrusteeToFile_58    " H AddExplicitTrusteeToFile_59    " [H AddExplicitTrusteeToFile_60        " H AddExplicitTrusteeToFile_61" H AddExplicitTrusteeToFile_62" H AddExplicitTrusteeToFile_63 "    I    _      $ H RemoveExplicitTrusteeFromFile' I  RemoveExplicitTrusteeFromFile_64' 0I  RemoveExplicitTrusteeFromFile_65 
       ' }I  RemoveExplicitTrusteeFromFile_66' I  RemoveExplicitTrusteeFromFile_67' I  RemoveExplicitTrusteeFromFile_68 Q    i       ' J  RemoveExplicitTrusteeFromFile_69    ' J  RemoveExplicitTrusteeFromFile_70' J  RemoveExplicitTrusteeFromFile_71     1    _   XJ SetFileInheritedRights  }J SetFileInheritedRights_72  J SetFileInheritedRights_73 
         J SetFileInheritedRights_74  J SetFileInheritedRights_75 ?     <K SetFileInheritedRights_76 $     K SetFileInheritedRights_77          K SetFileInheritedRights_78  K SetFileInheritedRights_79     0       L EraseTrusteeFile ]L EraseTrusteeFile_80 L EraseTrusteeFile_81     L EraseTrusteeFile_82 L EraseTrusteeFile_83     3        L EraseTrusteeFile_84         M CheckTrusteeMask 0M CheckTrusteeMask_85     G    LM CheckTrusteeMaskInfoCode" xM CheckTrusteeMaskInfoCode_86     G    M CheckTrusteeMaskWithUnum" M CheckTrusteeMaskWithUnum_87     s    N GetTrusteeMask 4    <N GetTrusteeMaskInfoCode  fN GetTrusteeMaskInfoCode_88      pN GetTrusteeMaskInfoCode_89  N GetTrusteeMaskInfoCode_90             N GetTrusteeMaskWithUnum  &O GetTrusteeMaskWithUnum_91      @O GetTrusteeMaskWithUnum_92      HO GetTrusteeMaskWithUnum_93  YO GetTrusteeMaskWithUnum_94  O GetTrusteeMaskWithUnum_95     7           ! O CheckTrusteeMaskWithHandle$ 
P CheckTrusteeMaskWithHandle_96     O    (P GetTrusteeMaskWithHandle" SP GetTrusteeMaskWithHandle_97    " hP GetTrusteeMaskWithHandle_98" P GetTrusteeMaskWithHandle_99     r        P 
GetTrusteeSet Q GetTrusteeSet_100     5Q GetTrusteeSet_101      >Q GetTrusteeSet_102 PQ GetTrusteeSet_103 aQ GetTrusteeSet_104     Q GetTrusteeSet_105     H    _    Q GetTrusteeSet_106 Q GetTrusteeSet_107     Q GetTrusteeSet_108 Q GetTrusteeSet_109 Q GetTrusteeSet_118 7                                                                                                                                                                                                                                                     v                        Ó $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     h        ]    t           tR GetExtendedTrusteeSet  R GetExtendedTrusteeSet_110      S GetExtendedTrusteeSet_111       @S GetExtendedTrusteeSet_112  PS GetExtendedTrusteeSet_113  aS GetExtendedTrusteeSet_114      S GetExtendedTrusteeSet_115     H    ]     S GetExtendedTrusteeSet_116  S GetExtendedTrusteeSet_117  S GetExtendedTrusteeSet_119 7    Q    t      $ T GetEffectiveRightsForDirEntry H   		L7                                                                      	                                                                      		 
 
       	                                                                	                   
	                	       	            

            	                        	     
                  CTRUSTEE T 	PGETINT32 <    U 
CPurgeTrustee LU CPurgeTrustee_1 S       % U CAddExplicitTrusteeToDirectory' <V  CAddExplicitTrusteeToDirectory_2' LV  CAddExplicitTrusteeToDirectory_3    ' rV  CAddExplicitTrusteeToDirectory_4    ' V  CAddExplicitTrusteeToDirectory_5    ' V  CAddExplicitTrusteeToDirectory_6     t   ' V  CAddExplicitTrusteeToDirectory_7 !    E  " W CRemoveTrusteeFromDirectory$ HW CRemoveTrusteeFromDirectory_8$ jW CRemoveTrusteeFromDirectory_9     5    y   # W CSetDirectoryInheritedRights& W CSetDirectoryInheritedRights_10& W CSetDirectoryInheritedRights_11    & X CSetDirectoryInheritedRights_12    & X CSetDirectoryInheritedRights_13    & 6X CSetDirectoryInheritedRights_14     p        LX CEraseTrusteeDirectory 4     X CAddExplicitTrusteeToFile# $Y CAddExplicitTrusteeToFile_15# 4Y CAddExplicitTrusteeToFile_16    # ZY CAddExplicitTrusteeToFile_17    # uY CAddExplicitTrusteeToFile_18    # Y CAddExplicitTrusteeToFile_19     x   # Y CAddExplicitTrusteeToFile_20# Y CAddExplicitTrusteeToFile_21    # Y CAddExplicitTrusteeToFile_22    # Z CAddExplicitTrusteeToFile_23     Y   # 6Z CAddExplicitTrusteeToFile_24 )       dZ CSetFileInheritedRights! Z CSetFileInheritedRights_25! Z CSetFileInheritedRights_26    ! [ CSetFileInheritedRights_27    ! 1[ CSetFileInheritedRights_28    ! N[ CSetFileInheritedRights_29     z   ! {[ CSetFileInheritedRights_30! [ CSetFileInheritedRights_31    ! [ CSetFileInheritedRights_32    ! [ CSetFileInheritedRights_33     Y    |   [ CEraseTrusteeFile "\ CEraseTrusteeFile_34 7    \\ CEraseTrusteeFile_35        % d\ CRemoveExplicitTrusteeFromFile( \ !CRemoveExplicitTrusteeFromFile_36( \ !CRemoveExplicitTrusteeFromFile_37( ] !CRemoveExplicitTrusteeFromFile_38 Q    i       ( d] !CRemoveExplicitTrusteeFromFile_39        l] 
CResyncDir ]    ] 
CMoveFNode     |^ CDeleteFNode ^ CDeleteFNode_40 ^ CDeleteFNode_41             _ CResyncFile ~    _ CNewVersion _ CNewVersion_42     h` CNewVersion_43     ` CNewVersion_44 '    L   ` 
COverWrite f   		T        	               	                 	                         	                                                                              TFILE Ha 	PGETINT32 <    a CreateTrusteeFileEntry a CreateTrusteeFileEntry_1         b ModifyTrusteeFileEntry w    b IsTrusteeFileInList ,    b PurgeTrusteeFileList b PurgeTrusteeFileList_2 Z        |c AddTrusteeFileToList c AddTrusteeFileToList_3 E    d AddTrusteeFileToList_4 )    ?d AddTrusteeFileToList_5     P   d CreateTrusteeTFileFile d CreateTrusteeTFileFile_6 Oe CreateTrusteeTFileFile_7 	        e CreateTrusteeTFileFile_8     7   f CloseTrusteeTFile f CloseTrusteeTFile_9 4    L    Pf OpenTrusteeTFile nf OpenTrusteeTFile_10      wf OpenTrusteeTFile_11 f OpenTrusteeTFile_12 	    }    )g OpenTrusteeTFile_13     Kg OpenTrusteeTFile_14        \g AddTrusteeFileRecord tg AddTrusteeFileRecord_15 g AddTrusteeFileRecord_16     g AddTrusteeFileRecord_17 	    g AddTrusteeFileRecord_18 g AddTrusteeFileRecord_19     6    %h AddTrusteeFileRecord_20         kh AddTrusteeFileRecord_21     h AddTrusteeFileRecord_33 h AddTrusteeFileRecord_9 6    >       h ModifyTrusteeFileRecord! i ModifyTrusteeFileRecord_22    ! Di ModifyTrusteeFileRecord_23! Si ModifyTrusteeFileRecord_24    ! si ModifyTrusteeFileRecord_34  {i ModifyTrusteeFileRecord_9 5    =    l        i DeleteTrusteeFileRecord! i DeleteTrusteeFileRecord_25!  j DeleteTrusteeFileRecord_26    ! /j DeleteTrusteeFileRecord_27    ! dj DeleteTrusteeFileRecord_28        ! j DeleteTrusteeFileRecord_29! j DeleteTrusteeFileRecord_30    ! j DeleteTrusteeFileRecord_35  j DeleteTrusteeFileRecord_9 7    ?    h    x   ,k ScanTrusteeFileFile Lk ScanTrusteeFileFile_31 k ScanTrusteeFileFile_32     q        k ReadFileRecord "   		Ha    = 
 %     	        >                                                     4            TUSER l 	PGETINT32 <   ! Dl CreateTrusteeFileUserEntry# al CreateTrusteeFileUserEntry_1    # l CreateTrusteeFileUserEntry_2# l CreateTrusteeFileUserEntry_3 	             l CreateTrusteeDirUserEntry" Em CreateTrusteeDirUserEntry_4" Em CreateTrusteeDirUserEntry_5 	    
        |m ModifyTrusteeUserEntry L    m DeleteTrusteeEntry 
n DeleteTrusteeEntry_37 Fn DeleteTrusteeEntry_8 
    I        Xn 
NoTrustees '    n PurgeTrusteeUserList n PurgeTrusteeUserList_6 n PurgeTrusteeUserList_7 
    8        (o RemoveTrusteeFromFSList  ]o RemoveTrusteeFromFSList_8     H    po IsTrusteeUserInList #    o CreateTrusteeUserFile o CreateTrusteeUserFile_9 p CreateTrusteeUserFile_10                                                                                                                                                                                                                                                   w                        `_ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              _ "     y       	        p CreateTrusteeUserFile_11     p CreateTrusteeUserFile_12     2   p CloseTrusteeUserFile p CloseTrusteeUserFile_13 4    L    q OpenTrusteeUserFile -q OpenTrusteeUserFile_14     9q OpenTrusteeUserFile_15 q OpenTrusteeUserFile_16 	    |    q OpenTrusteeUserFile_17     r OpenTrusteeUserFile_18        r AddTrusteeUserRecord 4r AddTrusteeUserRecord_19 hr AddTrusteeUserRecord_20     r AddTrusteeUserRecord_21 	    r AddTrusteeUserRecord_22 r AddTrusteeUserRecord_23     6    r AddTrusteeUserRecord_24         (s AddTrusteeUserRecord_25     js AddTrusteeUserRecord_38 rs AddTrusteeUserRecord_13 6    >       s ModifyTrusteeUserRecord! s ModifyTrusteeUserRecord_26    ! t ModifyTrusteeUserRecord_27! t ModifyTrusteeUserRecord_28    ! 3t ModifyTrusteeUserRecord_39! ;t ModifyTrusteeUserRecord_13 5    =    l        tt DeleteTrusteeUserRecord! t DeleteTrusteeUserRecord_29! t DeleteTrusteeUserRecord_30    ! t DeleteTrusteeUserRecord_31    ! $u DeleteTrusteeUserRecord_32        ! u DeleteTrusteeUserRecord_33! u DeleteTrusteeUserRecord_34    ! u DeleteTrusteeUserRecord_40! u DeleteTrusteeUserRecord_13 7    ?    h    x   u ScanTrusteeUserFile v ScanTrusteeUserFile_35 Pv ScanTrusteeUserFile_36     q        v ReadUserRecord "   		l  )       
  	  I 
 	                                           h             
      
    RIGHTS v 	PGETINT32 <    w CalculateEffectiveRights! ;w CalculateEffectiveRights_1 E   " w CalculateEffectiveRights_59" w CalculateEffectiveRights_56    " w CalculateEffectiveRights_57    " w CalculateEffectiveRights_58 
    H        w CalcEffRightsSetup w CalcEffRightsSetup_2     tx CalcEffRightsSetup_3 }x CalcEffRightsSetup_4         x CalcEffRightsSetup_5 x CalcEffRightsSetup_6     W    y CalcEffRightsSetup_7     ?y CalcEffRightsSetup_8     Ty CalcEffRightsSetup_9 ty CalcEffRightsSetup_10 	    y CalcEffRightsSetup_11     y CalcEffRightsSetup_12 y CalcEffRightsSetup_13 y CalcEffRightsSetup_14 
    y CalcEffRightsSetup_15         &    z CalcEffRightsSetup_16 .z CalcEffRightsSetup_17     8z CalcEffRightsSetup_18 Az CalcEffRightsSetup_19 Pz CalcEffRightsSetup_20     *    :    f    z CalcEffRightsSetup_21        z CalcEffRightsSetup_22 z CalcEffRightsSetup_23 	{ CalcEffRightsSetup_24     !{ CalcEffRightsSetup_25     8{ CalcEffRightsSetup_26     E    ]    T{ CalcEffRightsSetup_27 [{ CalcEffRightsSetup_28         x{ CalcEffRightsSetup_29     { CalcEffRightsSetup_30 { CalcEffRightsSetup_31 { CalcEffRightsSetup_32 { CalcEffRightsSetup_33 
    
        ?    { CalcEffRightsSetup_34 { CalcEffRightsSetup_35 { CalcEffRightsSetup_36         &    3    | CalcEffRightsCalc | CalcEffRightsCalc_37 	    %| CalcEffRightsCalc_38     6| CalcEffRightsCalc_39 D| CalcEffRightsCalc_40         i| CalcEffRightsCalc_41 ~| CalcEffRightsCalc_42 	    | CalcEffRightsCalc_43 | CalcEffRightsCalc_44 -    5        | CalcEffRightsCalc_45  } CalcEffRightsCalc_46 -    =    H} CalcEffRightsCalc_47 j} CalcEffRightsCalc_48 s} CalcEffRightsCalc_49     } CalcEffRightsCalc_50     "    } CalcEffRightsCalc_51 } CalcEffRightsCalc_52 	    } CalcEffRightsCalc_53     4    |    } CalcEffRightsCalc_54     ~ CalcEffRightsCalc_55     4   4~ CalcEffRightsCleanup E~ CalcEffRightsCleanup_56     a~ CalcEffRightsCleanup_57     q~ CalcEffRightsCleanup_58 
    M   		v   	          
                                        	                                                      8           TSEARCH ~ 	PGETINT32 <    ~ FindTrusteeDNode ~ FindTrusteeDNode_1  FindTrusteeDNode_2     1        @ GetTrusteeDNodeIRights  V GetTrusteeDNodeIRights_28  GetTrusteeDNodeIRights_1  GetTrusteeDNodeIRights_2     4             GetTrusteeDNodeFileList! 
 GetTrusteeDNodeFileList_29  T GetTrusteeDNodeFileList_1  t GetTrusteeDNodeFileList_2     4          GetTrusteeDNodeFileList_3 	          DJGetTrusteeDNodeFileList" Ҁ DJGetTrusteeDNodeFileList_4 	    /     GetTrusteeDNodeUserList!  GetTrusteeDNodeUserList_30  < GetTrusteeDNodeUserList_1  \ GetTrusteeDNodeUserList_2     4          GetTrusteeDNodeUserList_5           DJGetTrusteeDNodeUserList"  DJGetTrusteeDNodeUserList_6     /    ́ FindTrusteeFile  FindTrusteeFile_7  FindTrusteeFile_8 
     FindTrusteeFile_9 ( FindTrusteeFile_10     !    W    x FindTrusteeFile_11  FindTrusteeFile_12  FindTrusteeFile_13     &     FindTrusteeFile_14     d        GetTrusteeFileIRights  GetTrusteeFileIRights_15  GetTrusteeFileIRights_16     6    ) GetTrusteeFileIRights_17     N GetTrusteeFileIRights_18 	    v    \ GetTrusteeFileUserList  ~ GetTrusteeFileUserList_19       GetTrusteeFileUserList_20 	      GetTrusteeFileUserList_21     [     DJGetTrusteeFileUserList" Ã DJGetTrusteeFileUserList_31! ߃ DJGetTrusteeFileUserList_4     ,   "  DJGetTrusteeFileUserList_22    " 
 DJGetTrusteeFileUserList_23 	   "  DJGetTrusteeFileUserList_24     g      FindTrusteeUserByFS H FindTrusteeUserByFS_25 $    h     GetTrusteeUserRights  GetTrusteeUserRights_26       GetTrusteeUserRights_27 <     GetTrusteeUserRights_32  GetTrusteeUserRights_25 (    o       		~~   
      	    	  	   	  
               	 
         
             
        
    TSETUP  	PGETINT32 <     StartupTrustee  StartupTrustee_1 ( StartupTrustee_2     &    M StartupTrustee_3     u StartupTrustee_4      StartupTrustee_5     ǆ StartupTrustee_6      StartupTrustee_7     " StartupTrustee_8     Y StartupTrustee_9 g StartupTrustee_10             InitTrusteeDatabase  InitTrusteeDatabase_11 ɇ InitTrusteeDatabase_12     %     InitTrusteeDatabase_13  InitTrusteeDatabase_14  InitTrusteeDatabase_15         3    0 InitTrusteeDatabase_16 < InitTrusteeDatabase_17 K InitTrusteeDatabase_18         1    p InitTrusteeDatabase_19 | InitTrusteeDatabase_20  InitTrusteeDatabase_21         .     InitTrusteeDatabase_22 
    Ȉ InitTrusteeDatabase_23 ۈ InitTrusteeDatabase_24     $     InitTrusteeDatabase_25  InitTrusteeDatabase_33 B    M    Y InitTrusteeDatabase_26 +        CloseTrustee K    ԉ AddDefaultTrustees  AddDefaultTrustees_27 B AddDefaultTrustees_28 X       AddDefa                                                                                                                                                                                                                                                   x                        <
 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              = "           ultTrustees_29         ShutDownTrustee '    ܋ EraseTrusteeEvent  EraseTrusteeEvent_30 ?         d ScheduleEraseTrusteeEvent#  ScheduleEraseTrusteeEvent_31    # ǌ ScheduleEraseTrusteeEvent_32        		  0                 
                                    
                                  
T_DJNUMBER  	PGETINT32 <    8 CreateTrusteeDJNumFile  CreateTrusteeDJNumFile_1  CreateTrusteeDJNumFile_2      CreateTrusteeDJNumFile_3 	        < CreateTrusteeDJNumFile_4 N CreateTrusteeDJNumFile_5      CreateTrusteeDJNumFile_6  CreateTrusteeDJNumFile_7 	        ( CreateTrusteeDJNumFile_8 	           @ OpenTrusteeDJNumFile o OpenTrusteeDJNumFile_9 w OpenTrusteeDJNumFile_10  OpenTrusteeDJNumFile_11      OpenTrusteeDJNumFile_12 	     OpenTrusteeDJNumFile_13      OpenTrusteeDJNumFile_14 ,            H OpenTrusteeDJNumFile_15 P OpenTrusteeDJNumFile_16 b OpenTrusteeDJNumFile_17      OpenTrusteeDJNumFile_18  OpenTrusteeDJNumFile_19 	        ܐ OpenTrusteeDJNumFile_20 	     OpenTrusteeDJNumFile_21      OpenTrusteeDJNumFile_22 2    7 OpenTrusteeDJNumFile_23 U OpenTrusteeDJNumFile_24 6    T    ;   C   O    CloseTrusteeDJNumFile  CloseTrusteeDJNumFile_25 .    E    ؑ InitTrusteeDJNumFile  InitTrusteeDJNumFile_26       InitTrusteeDJNumFile_27  InitTrusteeDJNumFile_28     ;    g    @ GetTrusteeDJNumber T GetTrusteeDJNumber_80 _ GetTrusteeDJNumber_26     p GetTrusteeDJNumber_27  GetTrusteeDJNumber_28     :    V     GetTrusteeDJNumber_29     ޒ GetTrusteeDJNumber_30 	 GetTrusteeDJNumber_31     l    L GetTrusteeDJNumber_32 *    9   | DJMountTrustee  DJMountTrustee_33  DJMountTrustee_34 .    H     DJMountTrustee_35  DJMountTrustee_36  DJMountTrustee_81       DJMountTrustee_82        DJMountTrustee_83                    
DJMountDNodes H DJMountDNodes_37 U DJMountDNodes_84 y DJMountDNodes_63      DJMountDNodes_64  DJMountDNodes_65     $    j    ǔ DJMountDNodes_38 ǔ DJMountDNodes_85  DJMountDNodes_57     -    /        1 DJMountDNodes_39 1 DJMountDNodes_86 ; DJMountDNodes_58      ; DJMountDNodes_59      ; DJMountDNodes_60      @ DJMountDNodes_61 C DJMountDNodes_62         "    X DJMountDNodes_40 
    4    a   l 
DJMountFNodes ȕ DJMountFNodes_41 Օ DJMountFNodes_87  DJMountFNodes_63      DJMountFNodes_64  DJMountFNodes_65     $    n    L DJMountFNodes_42 L DJMountFNodes_88 b DJMountFNodes_57     ,    /     DJMountFNodes_89  DJMountFNodes_66 Ɩ DJMountFNodes_67     ̖ DJMountFNodes_68      $    t      DJMountFNodes_43  DJMountFNodes_44  DJMountFNodes_45  DJMountFNodes_90 1 DJMountFNodes_57     )    ,    <    z    | DJMountFNodes_46 K        DJMountFNodes_47  DJMountFNodes_91  DJMountFNodes_58       DJMountFNodes_59       DJMountFNodes_60       DJMountFNodes_61  DJMountFNodes_62               DJMountFNodes_48      %        
DJMountUNodes ` DJMountUNodes_49 j DJMountUNodes_92  DJMountUNodes_63      DJMountUNodes_64  DJMountUNodes_65     $    q     DJMountUNodes_50  DJMountUNodes_93  DJMountUNodes_57     ,    /     DJMountUNodes_51     ( DJMountUNodes_52 , DJMountUNodes_94 h DJMountUNodes_66 r DJMountUNodes_67     x DJMountUNodes_68      $    w     DJMountUNodes_53  DJMountUNodes_95 ę DJMountUNodes_57     ,    /         DJMountUNodes_54  DJMountUNodes_96  DJMountUNodes_57     -    /       x DJMountUNodes_55 x DJMountUNodes_97  DJMountUNodes_58       DJMountUNodes_59       DJMountUNodes_60       DJMountUNodes_61  DJMountUNodes_62              DJMountUNodes_56      $        DJUnmountUsers      DJUnmountDNodes      DJUnmountFNodes      DJPutInDeleteList Ӛ DJPutInDeleteList_57     0     DJDeleteEntries  DJDeleteEntries_58       DJDeleteEntries_59       DJDeleteEntries_60       DJDeleteEntries_61  DJDeleteEntries_62         "     DJFindTrusteeDNode 2 DJFindTrusteeDNode_63     H DJFindTrusteeDNode_64 S DJFindTrusteeDNode_65     #    p     DJFindTrusteeFile  DJFindTrusteeFile_66  DJFindTrusteeFile_67      DJFindTrusteeFile_68      $    t     DJAddTrusteeDNodeToList! " DJAddTrusteeDNodeToList_69        "  DJRemoveTrusteeFileFromList%  DJRemoveTrusteeFileFromList_98% ܜ DJRemoveTrusteeFileFromList_66%  DJRemoveTrusteeFileFromList_67    %  DJRemoveTrusteeFileFromList_68      (    {   % 1 DJRemoveTrusteeFileFromList_70 .   % i DJRemoveTrusteeFileFromList_71 8   %  DJRemoveTrusteeFileFromList_72%  DJRemoveTrusteeFileFromList_73 	    I    T  "  DJDeleteTrusteeFileFromList%  DJDeleteTrusteeFileFromList_99% 4 DJDeleteTrusteeFileFromList_66% > DJDeleteTrusteeFileFromList_67    % D DJDeleteTrusteeFileFromList_68      (    x   %  DJDeleteTrusteeFileFromList_74%  DJDeleteTrusteeFileFromList_75 &   %  DJDeleteTrusteeFileFromList_76     <   %  DJDeleteTrusteeFileFromList_77 .    O   @ DJAddTrusteeToFSList  DJAddTrusteeToFSList_78  DJAddTrusteeToFSList_79            		  W 	       	   	                                  	       M            
                            
                           	                              	        	  :	         
T_DJRESYNC  	PGETINT32 <     DJReSyncTrustee 9 DJReSyncTrustee_1     o DJReSyncTrustee_2  DJReSyncTrustee_3      DJReSyncTrustee_4 $     DJReSyncTrustee_5 !    ) DJReSyncTrustee_6      DJReSyncTrustee_7      DJReSyncTrustee_8  DJReSyncTrustee_9     ) DJReSyncTrustee_10     y       y DJReSyncTrustee_11      DJReSyncTrustee_12      DJReSyncTrustee_13 ( DJReSyncTrustee_14      \    L DJReSyncTrustee_15 b DJReSyncTrustee_16     4     DJReSyncTrustee_17  DJReSyncTrustee_18 -    y    K DJReSyncTrustee_19 R DJReSyncTrustee_20 R DJReSyncTrustee_55 t DJReSyncTrustee_45     Y    g     DJReSyncTrustee_21 Ҥ DJReSyncTrustee_22 + DJReSyncTrustee_56 L DJReSyncTrustee_45     X     DJReSyncTrustee_23 C       #       DJReSyncTrustee_24  DJReSyncTrustee_25 O DJReSyncTrustee_26 C         DJReSyncTrustee_27  DJReSyncTrustee_28  DJReSyncTrustee_29 A    Y    l    5   $                                                                                                                                                                                                                                                    y                        r $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              F "           DJReSyncTrustee_30 V DJReSyncTrustee_31 	    ;    v DJReSyncTrustee_32  DJReSyncTrustee_33 *     DJReSyncTrustee_34 	 DJReSyncTrustee_35     H DJReSyncTrustee_36     u    Ũ DJReSyncTrustee_37      DJReSyncTrustee_38  DJReSyncTrustee_39 
         DJReSyncTrustee_40     X DJReSyncTrustee_41      DJReSyncTrustee_42 5    , DJReSyncTrustee_43 6        DJReSyncTrustee_44     
    MatchNameAndExtension  MatchNameAndExtension_45 
    P      SearchAllTrusteeFileNodes# T SearchAllTrusteeFileNodes_46# t SearchAllTrusteeFileNodes_47#  SearchAllTrusteeFileNodes_48 
    &    e        ̫ ResyncFindFilenum  ResyncFindFilenum_49  ResyncFindFilenum_50 
    <    Z    ( ScanLowerVersions T ScanLowerVersions_51  ScanLowerVersions_52  ScanLowerVersions_53      ScanLowerVersions_54 '    c           		  
    	  	                       	   
    	                                                           
                               	              
    TUTILS  	PGETINT32 <    0 MapNewTrusteeMaskToOld '    X MapOldTrusteeMaskToNew %   		w .       TOBJLST  	PGETINT32 <     AddTrusteeToObjectIDList" ŭ AddTrusteeToObjectIDList_31"  AddTrusteeToObjectIDList_14"  AddTrusteeToObjectIDList_15 
    0       ! _ AddTrusteeToObjectIDList_1! o AddTrusteeToObjectIDList_2     g   ! Ʈ AddTrusteeToObjectIDList_3" Ʈ AddTrusteeToObjectIDList_32"  AddTrusteeToObjectIDList_23"  AddTrusteeToObjectIDList_24    "  AddTrusteeToObjectIDList_25    " = AddTrusteeToObjectIDList_26 	    `       ! d AddTrusteeToObjectIDList_4           $ | RemoveTrusteeFromObjectIDList'   RemoveTrusteeFromObjectIDList_33' ̯  RemoveTrusteeFromObjectIDList_14' ү  RemoveTrusteeFromObjectIDList_15 
    0       ' "  RemoveTrusteeFromObjectIDList_34' D  RemoveTrusteeFromObjectIDList_23' `  RemoveTrusteeFromObjectIDList_24    ' p  RemoveTrusteeFromObjectIDList_25    '   RemoveTrusteeFromObjectIDList_26 	    `        X   ԰ ScanTrusteePaths ٰ ScanTrusteePaths_35   ScanTrusteePaths_14 & ScanTrusteePaths_15 
    0        p ScanTrusteePaths_5 %     ScanTrusteePaths_6  ScanTrusteePaths_7      ScanTrusteePaths_8  ScanTrusteePaths_9  ScanTrusteePaths_10  ScanTrusteePaths_11 7 ScanTrusteePaths_12     @    E    Y    T ScanTrusteePaths_13 +                FindTrusteeObjectList  FindTrusteeObjectList_14 ǲ FindTrusteeObjectList_15     )         ScanTrusteeObjectList ) ScanTrusteeObjectList_16 	    < ScanTrusteeObjectList_17 J ScanTrusteeObjectList_18 	        h ScanTrusteeObjectList_19 w ScanTrusteeObjectList_20 	     ScanTrusteeObjectList_21      ScanTrusteeObjectList_22 	    ?       #  FindTrusteeObjectListElement& Գ FindTrusteeObjectListElement_23&  FindTrusteeObjectListElement_24    &  FindTrusteeObjectListElement_25    & . FindTrusteeObjectListElement_26     _        L PurgeTrusteeObjectIDList" Q PurgeTrusteeObjectIDList_36"  PurgeTrusteeObjectIDList_14"  PurgeTrusteeObjectIDList_15 
    0       "  PurgeTrusteeObjectIDList_27    "   PurgeTrusteeObjectIDList_28 
   "  PurgeTrusteeObjectIDList_37" T PurgeTrusteeObjectIDList_29" Z PurgeTrusteeObjectIDList_30     <        ^    RemoveObjectListElement!  RemoveObjectListElement_29!  RemoveObjectListElement_30     3    |   		                                         	     	            	                  
      
    TDNODE ( 	PGETINT32 <    d CreateTrusteeDNode w    ܶ CreateTrusteeDNodeHost f    D ModifyTrusteeDNode c     DeleteTrusteeDNode ٷ DeleteTrusteeDNode_1  DeleteTrusteeDNode_2 "    ! DeleteTrusteeDNode_3 "    j        x AddTrusteeDNodeToList  AddTrusteeDNodeToList_4 ?    Ѹ AddTrusteeDNodeToList_5 $     AddTrusteeDNodeToList_6  AddTrusteeDNodeToList_7          AddTrusteeDNodeToList_8      AddTrusteeDNodeToList_9           CreateTrusteeDNodeFile   CreateTrusteeDNodeFile_10   CreateTrusteeDNodeFile_11 	         \ CreateTrusteeDNodeFile_12 g    /   Ⱥ CloseTrusteeDNodeFile ܺ CloseTrusteeDNodeFile_13 4    L     OpenTrusteeDNodeFile - OpenTrusteeDNodeFile_14     @ OpenTrusteeDNodeFile_15  OpenTrusteeDNodeFile_16 	         OpenTrusteeDNodeFile_17        0 AddTrusteeDNodeRecord H AddTrusteeDNodeRecord_18 | AddTrusteeDNodeRecord_19      AddTrusteeDNodeRecord_20 	     AddTrusteeDNodeRecord_21  AddTrusteeDNodeRecord_22     6     AddTrusteeDNodeRecord_23         < AddTrusteeDNodeRecord_24     ~ AddTrusteeDNodeRecord_36  AddTrusteeDNodeRecord_13 6    >        ModifyTrusteeDNodeRecord" ׽ ModifyTrusteeDNodeRecord_25    "  ModifyTrusteeDNodeRecord_26" ( ModifyTrusteeDNodeRecord_27    " K ModifyTrusteeDNodeRecord_37" S ModifyTrusteeDNodeRecord_13 5    =    l         DeleteTrusteeDNodeRecord"  DeleteTrusteeDNodeRecord_28"  DeleteTrusteeDNodeRecord_29    "  DeleteTrusteeDNodeRecord_30    " G DeleteTrusteeDNodeRecord_31        "  DeleteTrusteeDNodeRecord_32"  DeleteTrusteeDNodeRecord_33    " Ϳ DeleteTrusteeDNodeRecord_38" տ DeleteTrusteeDNodeRecord_13 7    ?    h        ScanTrusteeDNodeFile % ScanTrusteeDNodeFile_34 h ScanTrusteeDNodeFile_35     p         ReadDNodeRecord 0   #  DJRemoveTrusteeDNodeFromList    		(   	  
	   		                       
 
                                    
                    	     ACCOUNT  	PGETINT32 <     StartupAcctStruct  StartupAcctStruct_1      StartupAcctStruct_2 	         ShutDownAcctStruct      CheckServerAccounting @ CheckServerAccounting_3 ` CheckServerAccounting_4  CheckServerAccounting_5  CheckServerAccounting_6 L    y            0   ( GetAccountStatus 8 GetAccountStatus_46 = GetAccountStatus_40      GetAccountStatus_41 
         GetAccountStatus_7     
 GetAccountStatus_8     M GetAccountStatus_9     3   \ SubmitAccountCharge  SubmitAccountCharge_10      SubmitAccountCharge_47 7     SubmitAccountCharge_48 7    2 SubmitAccountCharge_49 7     SubmitAccountCharge_50  SubmitAccountCharge_40     r SubmitAccountCharge_41 
         SubmitAccountCharge_11      SubmitAccountCharge_12      SubmitAcc                                                                                                                                                                                                                                                   z                        G!n $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           ountCharge_13 L SubmitAccountCharge_14 P SubmitAccountCharge_15 W SubmitAccountCharge_51 6     SubmitAccountCharge_16  SubmitAccountCharge_52 3     SubmitAccountCharge_17      SubmitAccountCharge_18  SubmitAccountCharge_53 6    H            Q SubmitAccountCharge_19 )    .   ^   z SubmitAccountCharge_54 1     SubmitAccountCharge_55 6     SubmitAccountCharge_56 6    * SubmitAccountCharge_20 9 SubmitAccountCharge_21     #    s SubmitAccountCharge_22 | SubmitAccountCharge_57             SubmitAccountHold 1 SubmitAccountHold_58 7 SubmitAccountHold_40      SubmitAccountHold_41 
         SubmitAccountHold_23     > SubmitAccountHold_24      SubmitAccountHold_25 .     SubmitAccountHold_26  SubmitAccountHold_27     ( SubmitAccountHold_59 6    g SubmitAccountHold_28 l SubmitAccountHold_29      SubmitAccountHold_60 3     SubmitAccountHold_30      SubmitAccountHold_61 6           * SubmitAccountHold_31      0 SubmitAccountHold_32     ? SubmitAccountHold_62 6     SubmitAccountHold_63 6     SubmitAccountHold_64 6     SubmitAccountHold_33  SubmitAccountHold_65 7    D SubmitAccountHold_34 P SubmitAccountHold_66 3    C     SubmitAccountHold_67 6     SubmitAccountHold_35          SubmitAccountHold_36 $       ( AccountNote 5 AccountNote_68 ,    n AccountNote_69 t AccountNote_40      AccountNote_41 
         AccountNote_37     / AccountNote_70 5    d AccountNote_71 7    8 AccountNote_72         IsAccountingInstalled 6     ChargeForServices  ChargeForServices_73 +         
AccountLogout      SyncAccounting  SyncAccounting_38     8 SyncAccounting_39     G    L ValidateAccountingServer" ^ ValidateAccountingServer_40    "  ValidateAccountingServer_41 
         SubmitAccountRecord     l DeltaCharge (     CalculateNewRate  CalculateNewRate_42  CalculateNewRate_43  CalculateNewRate_74 6    H    s        x GetRate     D GetCurrentRate e     AccountBilling  AccountBilling_75 k    ! AccountBilling_44      AccountBilling_76 +     AccountBilling_77 *    i AccountBilling_78 '     AccountBilling_79 '     AccountBilling_45 W AccountBilling_80 7     AccountBilling_81 7     AccountBilling_82 7     AccountBilling_83 7    v       TruncateAccountingFile      
GetAccountFid    		  *  &-       .            N	   ݴ               ʾ       /
  ݴ     ݶ                      8       ( 0    ** 	          	 
    	   
    s           CACHE    PASSWORD  getpwnam 5 
getpwnam_1     \ 
getpwnam_8 t 
getpwnam_7     0     
getpwnam_9  
getpwnam_7     4     getpwnam_10  
getpwnam_7     2     getpwnam_11 ( 
getpwnam_7     2    l   H getpwuid < 
getpwuid_2     L 
getpwuid_3 e 
getpwuid_4      
getpwuid_5  
getpwuid_6     2            PTOC
 $ PTOC_7 
    .   			                           	DIRECTORY @ StartupDirStructs L StartupDirStructs_202     (    h ShutDownDirStructs     p InitDirStructs (     IsAtRoot  
IsAtRoot_1     4     	SetAtRoot      IsAtRootVol  
IsAtRootVol_2     H    , SetAtRootVol =   ! l FSIMapPathToDirectoryEntry @   !  FSIMapDirectoryEntryToPath     0 FSICreateDirectory _ FSICreateDirectory_3      FSICreateDirectory_4      FSICreateDirectory_5  FSICreateDirectory_6 
     FSICreateDirectory_7 
     FSICreateDirectory_8  FSICreateDirectory_9 
    
    :        FSIDeleteDirectory C FSIDeleteDirectory_10      FSIDeleteDirectory_11      FSIDeleteDirectory_12  FSIDeleteDirectory_13 
    / FSIDeleteDirectory_14 
    A FSIDeleteDirectory_15 A FSIDeleteDirectory_16 
    
    ;    >   T FSISetEntryInfo  FSISetEntryInfo_17     % FSISetEntryInfo_18 * FSISetEntryInfo_19         > FSISetEntryInfo_20 C FSISetEntryInfo_21         _ FSISetEntryInfo_22  FSISetEntryInfo_23  FSISetEntryInfo_24 |             FSISetEntryInfo_25  FSISetEntryInfo_26 
     FSISetEntryInfo_27 
     FSISetEntryInfo_28  FSISetEntryInfo_29 
    
    ;    }    FSIMoveEntry  FSIMoveEntry_30      FSIMoveEntry_31      FSIMoveEntry_32     | FSIMoveEntry_33 H     FSIMoveEntry_34 *     FSIMoveEntry_35      FSIMoveEntry_36     " FSIMoveEntry_37 ' FSIMoveEntry_38         : FSIMoveEntry_39 ? FSIMoveEntry_40          FSIMoveEntry_41     [ FSIMoveEntry_42 e FSIMoveEntry_43 
    w FSIMoveEntry_44 
     FSIMoveEntry_45  FSIMoveEntry_46 
    
    ;     FSIMoveEntry_47  FSIMoveEntry_48 
     FSIMoveEntry_49 
     FSIMoveEntry_50  FSIMoveEntry_51 
    
    ;        FSIGetEntryInfoWithIndex"  FSIGetEntryInfoWithIndex_52    " - FSIGetEntryInfoWithIndex_53    " g FSIGetEntryInfoWithIndex_54"  FSIGetEntryInfoWithIndex_55 -   "  FSIGetEntryInfoWithIndex_56        " 
 FSIGetEntryInfoWithIndex_57"  FSIGetEntryInfoWithIndex_58 
   " ( FSIGetEntryInfoWithIndex_59 
   " : FSIGetEntryInfoWithIndex_60" : FSIGetEntryInfoWithIndex_61 
    
    :    s   L FSIGetEntryInfoWithFID  Z FSIGetEntryInfoWithFID_62       FSIGetEntryInfoWithFID_63   FSIGetEntryInfoWithFID_64 -      FSIGetEntryInfoWithFID_65          5 FSIGetEntryInfoWithFID_66  > FSIGetEntryInfoWithFID_67 
     P FSIGetEntryInfoWithFID_68 
     b FSIGetEntryInfoWithFID_69  b FSIGetEntryInfoWithFID_70 
    
    :    '   t FSISetEntryInfoWithIndex" { FSISetEntryInfoWithIndex_71    "  FSISetEntryInfoWithIndex_72    "  FSISetEntryInfoWithIndex_73" E FSISetEntryInfoWithIndex_74" b FSISetEntryInfoWithIndex_75 ~           " 0 FSISetEntryInfoWithIndex_76    " < FSISetEntryInfoWithIndex_77" E FSISetEntryInfoWithIndex_78 
   " W FSISetEntryInfoWithIndex_79 
   " i FSISetEntryInfoWithIndex_80" i FSISetEntryInfoWithIndex_81 
    
    :       | FSISetEntryInfoWithFID   FSISetEntryInfoWithFID_82       FSISetEntryInfoWithFID_83   FSISetEntryInfoWithFID_84  + FSISetEntryInfoWithFID_85 }              FSISetEntryInfoWithFID_86   FSISetEntryInfoWithFID_87 
      FSISetEntryInfoWithFID_88 
       FSISetEntryInfoWithFID_89    FSISetEntryInfoWithFID_90 
    
    :       4 FSIGetPathFromUNum D FSIGetPathFromUNum_91     K     FSIDirectoryReadAhead  FSIDirectoryReadAhead_92          FSIDirectorySearch K FSIDirectorySearch_93 m FSIDirectorySearch_94 ~ FSIDirectorySearch_95      FSIDirectorySearch_96  FSIDirectorySearch_97 ^    f    }     FSIDirectorySearch_98          FSIDirectorySearch_99  FSIDirectorySearch_100  FSIDirectorySearch_10                                                                                                                                                                                                                                                   {                        " $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              5 "           1  FSIDirectorySearch_102      FSIDirectorySearch_103      FSIDirectorySearch_104  FSIDirectorySearch_105  FSIDirectorySearch_106 
     FSIDirectorySearch_107 
     FSIDirectorySearch_108  FSIDirectorySearch_109 
    
    >    A    + FSIDirectorySearch_110 5 FSIDirectorySearch_111 
    G FSIDirectorySearch_112 
    \ FSIDirectorySearch_113 \ FSIDirectorySearch_114 
    
    >         FSIDirectorySearch_115  FSIDirectorySearch_116      FSIDirectorySearch_117      FSIDirectorySearch_118  FSIDirectorySearch_119  FSIDirectorySearch_120 
     FSIDirectorySearch_121 
     FSIDirectorySearch_122  FSIDirectorySearch_123 
    
    >    A    O FSIDirectorySearch_124 Y FSIDirectorySearch_125 
    k FSIDirectorySearch_126 
     FSIDirectorySearch_127  FSIDirectorySearch_128 
    
    >          $ FSIDirectorySearch_129 C FSIDirectorySearch_130 T FSIDirectorySearch_131         \ FSIDirectorySearch_132     @    l   r FSIDirectorySearch_133 t FSIDirectorySearch_134  FSIDirectorySearch_135  FSIDirectorySearch_136         `     FSIDirectorySearch_137  FSIDirectorySearch_138      FSIDirectorySearch_139 ;    l        T FSIDirectorySearch_140 k FSIDirectorySearch_141 r FSIDirectorySearch_142  FSIDirectorySearch_143 >    x     FSIDirectorySearch_144 "        < FSIDirectorySearch_145 Z FSIDirectorySearch_146 r FSIDirectorySearch_147 &     FSIDirectorySearch_148      FSIDirectorySearch_149 >               t FSIDirectorySearch_150       FSIDirectorySearch_151  FSIDirectorySearch_152      FSIDirectorySearch_153 ;    i     FSIDirectorySearch_154 3 FSIDirectorySearch_155     ?    T FSIDirectorySearch_156 
    m FSIDirectorySearch_157 s FSIDirectorySearch_158 | FSIDirectorySearch_159 "    +    1     FSIDirectorySearch_160         LongNameProcess  LongNameProcess_161  LongNameProcess_162 (    @    A LongNameProcess_163      LongNameProcess_164 ,     LongNameProcess_165 7    ( LongNameProcess_166     X LongNameProcess_167 } LongNameProcess_168 #     LongNameProcess_169      LongNameProcess_170     2 LongNameProcess_171 H LongNameProcess_172 (    >    } LongNameProcess_173      LongNameProcess_174  LongNameProcess_175  LongNameProcess_176  LongNameProcess_177 2    H LongNameProcess_178 /        | LongNameProcess_179 &         LongNameProcess_180 -        LongNameProcess_181 ?    $ LongNameProcess_182 ? LongNameProcess_183 +    H    ,    LongNameProcess_184  LongNameProcess_185          LongNameProcess_186  LongNameProcess_187      LongNameProcess_188  LongNameProcess_189  LongNameProcess_190 
    *    N LongNameProcess_191     g     LongNameProcess_192  LongNameProcess_193     E          LongNameProcess_194        @  FilterLongNames O  FilterLongNames_195   FilterLongNames_196   FilterLongNames_197     ;          FilterLongNames_198  FilterLongNames_199 O    [       \ FSIIsTreeElement  FSIIsTreeElement_200  FSIIsTreeElement_203  FSIIsTreeElement_1     ;    . FSIIsTreeElement_201     r      		$@              	    	        
    
	                 	                		     	             
        
          
                                                                                                                                                                                                   2          FILE  dummyroutine      StartupFileStructs  StartupFileStructs_454 - StartupFileStructs_432 G StartupFileStructs_433     m StartupFileStructs_434     Q    a     StartupFileStructs_1      StartupFileStructs_2      StartupFileStructs_3      StartupFileStructs_4     4 StartupFileStructs_455 7    s StartupFileStructs_5      StartupFileStructs_6     a StartupFileStructs_7        x ShutDownFileStructs )     InitFileStructs    P VolumeToHostVolNum     % p GetWorkElementStructClientZero'   GetWorkElementStructClientZero_8 
         FSICommitAllFiles  FSICommitAllFiles_9  FSICommitAllFiles_456  FSICommitAllFiles_29                H FSICommitAllFiles_10 t FSICommitAllFiles_11     U     FSICommitAllFiles_12  FSICommitAllFiles_13 %    T    	 FSICommitAllFiles_457 	 FSICommitAllFiles_30              	 CommitAFile 	 CommitAFile_458 
    8	 CommitAFile_14 =	 CommitAFile_15          a	 CommitAFile_16 i	 CommitAFile_17 i	 CommitAFile_459              	 CommitAFile_18     	 CommitAFile_19 
    	 CommitAFile_20 w    ;
 CommitAFile_21 ;
 CommitAFile_460 
        I   T
 
FSIAsyncClose 
 FSIAsyncClose_461 
 FSIAsyncClose_29     "    
 FSIAsyncClose_22 
 FSIAsyncClose_462      FSIAsyncClose_23     - FSIAsyncClose_24 D FSIAsyncClose_25 L FSIAsyncClose_463 /     FSIAsyncClose_26  FSIAsyncClose_464         M     FSIAsyncClose_27  FSIAsyncClose_465 
        ~     FSIAsyncClose_28  FSIAsyncClose_466              FSIAsyncClose_467  FSIAsyncClose_30     #        LockSharedOpenFile    "  LockSharedOpenFileNoRetries     0 UnLockSharedOpenFile     @ LockOpenFileSema ] LockOpenFileSema_29     /    p UnLockOpenFileSema  UnLockOpenFileSema_30     0     ActuallyCloseFile  ActuallyCloseFile_31 6    
 ActuallyCloseFile_32 
 ActuallyCloseFile_33         
 ActuallyCloseFile_34     1   
 FSIOpenFileFork 4     FSIOpenSharedFileFork <    D FSIOpenFileForkNoCheck 4    x FSIOpenFileForkAccess 8     FSIDupHandle  FSIDupHandle_468 .     FSIDupHandle_469 $ FSIDupHandle_405 	    F        \ FSIClientFileStruct l FSIClientFileStruct_470 .     FSIClientFileStruct_471  FSIClientFileStruct_405 	    F         FSICreateFileFork & FSICreateFileFork_35 -    S    X FSICreateSharedFileFork! z FSICreateSharedFileFork_36 5    [     FSICreateFileForkCheck   FSICreateFileForkCheck_37 -    W     FSICreateNewFileFork 0    < FSIStartCloseFile L FSIStartCloseFile_472 .    K     FSICloseFile      FSIDe                                                                                                                                                                                                                                                   |                        j5/ $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              O9 "           ferredCloseFile  FSIDeferredCloseFile_473 .     FSIDeferredCloseFile_38       FSIDeferredCloseFile_39     ! FSIDeferredCloseFile_474 B FSIDeferredCloseFile_405 	    D    z FSIDeferredCloseFile_40      FSIDeferredCloseFile_41  FSIDeferredCloseFile_475  FSIDeferredCloseFile_29          FSIDeferredCloseFile_476      FSIDeferredCloseFile_42  FSIDeferredCloseFile_477  FSIDeferredCloseFile_30         (    g    $ FSIDeferredCloseFile_43 $ FSIDeferredCloseFile_478 1 FSIDeferredCloseFile_30         C FSIDeferredCloseFile_479 
    7     FSIDeferredCloseFile_44 9     FSIDeferredCloseFile_45      FSIDeferredCloseFile_46 7 FSIDeferredCloseFile_47 
    .    s FSIDeferredCloseFile_48      FSIDeferredCloseFile_49  FSIDeferredCloseFile_50  FSIDeferredCloseFile_51     1    W     FSIDeferredCloseFile_52     > FSIDeferredCloseFile_480     c FSIDeferredCloseFile_481 p FSIDeferredCloseFile_30          FSIDeferredCloseFile_53  FSIDeferredCloseFile_482 
             FSIReadFile  FSIReadFile_483 0      FSIReadFile_54      FSIReadFile_484 3 FSIReadFile_405 	    C    q FSIReadFile_55      FSIReadFile_56  FSIReadFile_57  FSIReadFile_58          FSIReadFile_485  
FSIReadFile_8         l FSIReadFile_59  FSIReadFile_60  FSIReadFile_61         Q FSIReadFile_62 (    | FSIReadFile_63               FSIReadFileMainLine  FSIReadFileMainLine_64      FSIReadFileMainLine_65      FSIReadFileMainLine_66  FSIReadFileMainLine_67   FSIReadFileMainLine_68          FSIReadFileMainLine_486 . FSIReadFileMainLine_8          FSIReadFileMainLine_69 > FSIReadFileMainLine_70 C FSIReadFileMainLine_71          FSIReadFileMainLine_72      FSIReadFileMainLine_73           H    	FlushFile  
FlushFile_487 /    7 
FlushFile_488 X 
FlushFile_405 	    F     FlushFile_74          AllocDiskSpace  AllocDiskSpace_75 _ AllocDiskSpace_489  AllocDiskSpace_350      AllocDiskSpace_351 
    o     AllocDiskSpace_76      AllocDiskSpace_77         AllocDiskSpace_490 
    Q AllocDiskSpace_78  AllocDiskSpace_79  AllocDiskSpace_491 $ AllocDiskSpace_350     3 AllocDiskSpace_351 
    o    F AllocDiskSpace_80     X AllocDiskSpace_81 [ AllocDiskSpace_492 
            | AllocDiskSpace_82  AllocDiskSpace_83  AllocDiskSpace_84     "    I     AllocDiskSpace_85 r AllocDiskSpace_86 u AllocDiskSpace_493              AllocDiskSpace_87  AllocDiskSpace_494 
        W    AllocDiskSpace_495 
        FSIWriteFile  FSIWriteFile_496 -    -  FSIWriteFile_497 N  FSIWriteFile_405 	    D    ! FSIWriteFile_88 &    D! FSIWriteFile_89 \! FSIWriteFile_498 p! FSIWriteFile_8         " FSIWriteFile_90         A" FSIWriteFile_499 U" FSIWriteFile_8     ~    " FSIWriteFile_91 V# FSIWriteFile_92 X# FSIWriteFile_93             # FSIWriteFile_94 n    l   0$ FSIWriteFileMainLine $ FSIWriteFileMainLine_95 "    % FSIWriteFileMainLine_96 (% FSIWriteFileMainLine_500 <% FSIWriteFileMainLine_8             % FSIWriteFileMainLine_501 
& FSIWriteFileMainLine_8     ~    & FSIWriteFileMainLine_97 ' FSIWriteFileMainLine_98 ' FSIWriteFileMainLine_99             t' FSIWriteFileMainLine_100 n       ' 
FSIDeleteFile ( FSIDeleteFile_101 t( FSIDeleteFile_102 ( FSIDeleteFile_103     `           ( FSIGetFileSize ) FSIGetFileSize_502 0    K) FSIGetFileSize_503 l) FSIGetFileSize_405 	    F        ) FSIServerCopyFile ) FSIServerCopyFile_504 0    ) FSIServerCopyFile_505 -    A* FSIServerCopyFile_506 b* FSIServerCopyFile_405 	    D    * FSIServerCopyFile_507 * FSIServerCopyFile_405 	    E     + FSIServerCopyFile_104 .+ FSIServerCopyFile_105            + FSISetFileTimeDateStamp" + FSISetFileTimeDateStamp_508 0   " + FSISetFileTimeDateStamp_509" , FSISetFileTimeDateStamp_405 	    D        |, FSIPerformLogout , FSIPerformLogout_106 , FSIPerformLogout_107 , FSIPerformLogout_108 , FSIPerformLogout_109 
             (    z    , 
FSICommitFile 
- FSICommitFile_510 0    O- FSICommitFile_511 p- FSICommitFile_405 	    F    - FSICommitFile_512     G. FSICommitFile_513     h   `. FSIPerformEndOfTask . FSIPerformEndOfTask_110     . FSIPerformEndOfTask_111 . FSIPerformEndOfTask_112 . FSIPerformEndOfTask_113 . FSIPerformEndOfTask_114 . FSIPerformEndOfTask_115 
        $    )    1         / FSIGetU_NumWithHandle  // FSIGetU_NumWithHandle_514  P/ FSIGetU_NumWithHandle_405 	    F        / FSIGetU_NumWithName / FSIGetU_NumWithName_116     / FSIGetU_NumWithName_117     0 FSIGetU_NumWithName_118     0 FSIGetU_NumWithName_119 0 FSIGetU_NumWithName_120 0 FSIGetU_NumWithName_121     0    u    i1 FSIGetU_NumWithName_122 #    1 FSIGetU_NumWithName_123 1 FSIGetU_NumWithName_515     1 FSIGetU_NumWithName_124 3        2 FSIGetU_NumWithName_125     42 FSIGetU_NumWithName_126     G2 FSIGetU_NumWithName_127 Q2 FSIGetU_NumWithName_128 
    c2 FSIGetU_NumWithName_129 
    u2 FSIGetU_NumWithName_130 u2 FSIGetU_NumWithName_131 
    
    ;       2 FSICloseFileWithFID 2 FSICloseFileWithFID_132 2 FSICloseFileWithFID_133 2 FSICloseFileWithFID_516     3 FSICloseFileWithFID_517     m    z        @3 FSIGetParentDnode b    3 GetBackLink ,    3 
FSILockRecord     3 FSIReleaseRecord     3 
FSIIsFileOpen 3 FSIIsFileOpen_134     4 FSIIsFileOpen_518 "4 FSIIsFileOpen_29     "    U4 FSIIsFileOpen_519 f4 FSIIsFileOpen_30     #        4 FSIInitializeStaticDirs" 5 FSIInitializeStaticDirs_135" 15 FSIInitializeStaticDirs_136 	    6   " o5 FSIInitializeStaticDirs_137" o5 FSIInitializeStaticDirs_138 	       " 5 FSIInitializeStaticDirs_139 +   " 5 FSIInitializeStaticDirs_140 1   " 6 FSIInitializeStaticDirs_141 	       (6 AddToSharedOpenList @6 AddToSharedOpenList_142 H6 AddToSharedOpenList_520 h6 AddToSharedOpenList_158     6 AddToSharedOpenList_159 B        6 AddToSharedOpenList_143     6 AddToSharedOpenList_144         7 AddToSharedOpenList_145 7 AddToSharedOpenList_146     o7 AddToSharedOpenList_521 B    7 AddToSharedOpenList_147     7 AddToSharedOpenList_148         7 AddToSharedOpenList_149 %    8 AddToSharedOpenList_150 8 AddToSharedOpenList_151     ?8 AddToSharedOpenList_152     f    {8 AddToSharedOpenList_153 8 AddToSharedOpenList_154 
    8 AddToSharedOpenList_155 
    8 AddToSharedOpenList_156 8 AddToSharedOpenList_157 
    
    :       8 GetClientSharedFile 8 GetClientSharedFile_158     8 GetClientSharedFile_159 E    ~    <9 GetSharedOpenFile E9 GetSharedOpenFile_522 @    9 GetSharedOpenFile_523     9 GetSharedOpenFile_160 : GetSharedOpenFile_161     4: GetSharedOpenFile_162      H: GetSharedOpenFile_163      ]    .  " l: FindAndLockSharedFileStruct& : FindAndLockSharedFileStruct_164& : FindAndLockSharedFileStruct_524% : FindAndLockSharedFileStruct_29        & : FindAndLockSharedFileStruct_525    & n; FindAndLockSharedFileStruct_165& ; FindAndLockSharedFileStruct_166        & ; FindAndLockSharedFileStruct_167& ; FindAndLockSharedFileStruct_526 
   & < FindAndLockSharedFileStruct_168& < FindAndLockSharedFileStruct_527% < FindAndLockSharedFileStruct_30         4    R          H< FindSharedFileStruct [< FindSharedFileStruct_528                                                                                                                                                                                                                                                        }                        ='
 $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              Ҡ "           = FindSharedFileStruct_169 n    D   = GetSharedCloseFile = GetSharedCloseFile_529     = GetSharedCloseFile_170 > GetSharedCloseFile_171     8> GetSharedCloseFile_172      L> GetSharedCloseFile_173      ]        p> DestroyClientList > DestroyClientList_174 > DestroyClientList_175 
            $? DeallocateSharedFile 4? DeallocateSharedFile_176 9? DeallocateSharedFile_177 >? DeallocateSharedFile_178     P? DeallocateSharedFile_179     *    {? DeallocateSharedFile_180     Z    ? DeallocateSharedFile_181 ? DeallocateSharedFile_182 
    ? DeallocateSharedFile_183 
    ? DeallocateSharedFile_184 ? DeallocateSharedFile_185 
    
    >    ? DeallocateSharedFile_186         ? RemoveFromCloseList 6    (@ RemoveFromOpenList @@ RemoveFromOpenList_530 b@ RemoveFromOpenList_158     @ RemoveFromOpenList_159 C        @ RemoveFromOpenList_187 @ RemoveFromOpenList_188 
    #    A RemoveFromOpenList_189 A RemoveFromOpenList_531 A    A RemoveFromOpenList_190     A RemoveFromOpenList_191 A RemoveFromOpenList_532     xB RemoveFromOpenList_533        0   HC RemoveFromOpenList_192 XC RemoveFromOpenList_193     >    d   C IsSoleOpener C IsSoleOpener_194 C IsSoleOpener_195     ,    C IsSoleOpener_196     C IsSoleOpener_534 D IsSoleOpener_158     -D IsSoleOpener_159 B        !   D FindFreeDescSlot D FindFreeDescSlot_197 D FindFreeDescSlot_198         D FindFreeDescSlot_199 @E FindFreeDescSlot_200 
    T        `E FreeLocalFileStructs tE FreeLocalFileStructs_201     7    E ValidateNWHandle 6    E 	SetUpMode E 
SetUpMode_202 E 
SetUpMode_203     E 
SetUpMode_204     E 
SetUpMode_205 F 
SetUpMode_206     F 
SetUpMode_207         3    D    F OpenCreateFile ZF OpenCreateFile_208 F OpenCreateFile_209     F OpenCreateFile_535 F OpenCreateFile_29     "    F OpenCreateFile_210 F OpenCreateFile_211     6    G OpenCreateFile_537 !G OpenCreateFile_202 $G OpenCreateFile_203 
    2G OpenCreateFile_204 
    @G OpenCreateFile_205 LG OpenCreateFile_206     \G OpenCreateFile_207     '    F    \    vG OpenCreateFile_538 G OpenCreateFile_202 G OpenCreateFile_203 
    G OpenCreateFile_204 
    G OpenCreateFile_205 G OpenCreateFile_206     G OpenCreateFile_207     '    F    Y       G OpenCreateFile_212 G OpenCreateFile_213     H OpenCreateFile_214     ?H OpenCreateFile_215     H OpenCreateFile_216     H OpenCreateFile_217 H OpenCreateFile_218     6    H OpenCreateFile_219 TI OpenCreateFile_220     l    nI OpenCreateFile_221     I OpenCreateFile_222 I OpenCreateFile_223     5    J OpenCreateFile_224 J OpenCreateFile_225 !J OpenCreateFile_545 2J OpenCreateFile_30     #    -    J    TJ OpenCreateFile_226 ^J OpenCreateFile_227     -    J OpenCreateFile_228 J OpenCreateFile_229         J OpenCreateFile_230 J OpenCreateFile_231         J OpenCreateFile_232 J OpenCreateFile_233         J OpenCreateFile_234     K OpenCreateFile_551 0K OpenCreateFile_202 3K OpenCreateFile_203 
    AK OpenCreateFile_204 
    PK OpenCreateFile_205 \K OpenCreateFile_206     lK OpenCreateFile_207     '    G    Z       K OpenCreateFile_235 K OpenCreateFile_236 K OpenCreateFile_237 <        BL OpenCreateFile_238 I    L OpenCreateFile_239 R    M OpenCreateFile_240 M OpenCreateFile_552 4M OpenCreateFile_158     ZM OpenCreateFile_159 E            M OpenCreateFile_241 N OpenCreateFile_242 $    AN OpenCreateFile_555 ^N OpenCreateFile_422     gN OpenCreateFile_423     pN OpenCreateFile_424     |N OpenCreateFile_425 N OpenCreateFile_426     N OpenCreateFile_427         N OpenCreateFile_428     N OpenCreateFile_429     c    N OpenCreateFile_556 N OpenCreateFile_430     O OpenCreateFile_431     c    O OpenCreateFile_243 #    nO OpenCreateFile_244 $       O OpenCreateFile_245     O OpenCreateFile_560 O OpenCreateFile_30     #       P OpenCreateFile_246 P OpenCreateFile_247 (P OpenCreateFile_248 (P OpenCreateFile_561 9P OpenCreateFile_30     #    P OpenCreateFile_249     P OpenCreateFile_250 P OpenCreateFile_251 $    P OpenCreateFile_564 Q OpenCreateFile_422     Q OpenCreateFile_423     $Q OpenCreateFile_424     0Q OpenCreateFile_425 4Q OpenCreateFile_426     <Q OpenCreateFile_427         HQ OpenCreateFile_428     PQ OpenCreateFile_429     c    XQ OpenCreateFile_565 Q OpenCreateFile_430     Q OpenCreateFile_431     c    Q OpenCreateFile_252 #    R OpenCreateFile_253 $       HR OpenCreateFile_568 YR OpenCreateFile_29     "    R OpenCreateFile_254     R OpenCreateFile_569     S OpenCreateFile_570 
    S OpenCreateFile_571 S OpenCreateFile_30     #       T OpenCreateFile_255 ET OpenCreateFile_256 UT OpenCreateFile_257     +    T OpenCreateFile_258 T OpenCreateFile_259 $    T OpenCreateFile_572 T OpenCreateFile_422     T OpenCreateFile_423     U OpenCreateFile_424     U OpenCreateFile_425 U OpenCreateFile_426      U OpenCreateFile_427         ,U OpenCreateFile_428     4U OpenCreateFile_429     c    <U OpenCreateFile_573 U OpenCreateFile_430     U OpenCreateFile_431     c    U OpenCreateFile_260 #    V OpenCreateFile_261 $       \V OpenCreateFile_262     }V OpenCreateFile_574     ^W OpenCreateFile_575 
    wW OpenCreateFile_576 W OpenCreateFile_30     #    W OpenCreateFile_263 W OpenCreateFile_264     k    X OpenCreateFile_265 &    2   ?X OpenCreateFile_266 GX OpenCreateFile_267 xX OpenCreateFile_268 !    R    X OpenCreateFile_269 X OpenCreateFile_270 !    R           X OpenCreateFile_271 &Y OpenCreateFile_272 FY OpenCreateFile_273 $    qY OpenCreateFile_577 Y OpenCreateFile_422     Y OpenCreateFile_423     Y OpenCreateFile_424     Y OpenCreateFile_425 Y OpenCreateFile_426     Y OpenCreateFile_427         Y OpenCreateFile_428     Y OpenCreateFile_429     c    Y OpenCreateFile_578 -Z OpenCreateFile_430     4Z OpenCreateFile_431     c    ;Z OpenCreateFile_274 #    Z OpenCreateFile_275 $       Z OpenCreateFile_276     [ OpenCreateFile_579 I    [ OpenCreateFile_277     [ OpenCreateFile_278     [ OpenCreateFile_580     \ OpenCreateFile_581     o] OpenCreateFile_582 ] OpenCreateFile_30     #    ] OpenCreateFile_279 ] OpenCreateFile_280 ] OpenCreateFile_281     1        D   8^ OpenCreateFile_282 ^ OpenCreateFile_583 #    p       ^ OpenCreateFile_584 $    _ OpenCreateFile_283 _ OpenCreateFile_284     _ OpenCreateFile_285 6    k    k` OpenCreateFile_286 k` OpenCreateFile_585 |` OpenCreateFile_29     "    &    ` OpenCreateFile_287 ` OpenCreateFile_288     1    ` OpenCreateFile_289     a OpenCreateFile_290 ^a OpenCreateFile_291 
    P    pa OpenCreateFile_586 a OpenCreateFile_30     #    a OpenCreateFile_292 a OpenCreateFile_587 
        a OpenCreateFile_293 a OpenCreateFile_294 
    a OpenCreateFile_295 
    a OpenCreateFile_296 a OpenCreateFile_297 
    
    ;       a CreateDataFork Nb CreateDataFork_298     b CreateDataFork_299     7c CreateDataFork_300 <c CreateDataFork_301     Nc CreateDataFork_302     zc CreateDataFork_303 c CreateDataFork_304     &    c CreateDataFork_305 c CreateDataF                                                                                                                                                                                                                                                   ~                        B $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              vJ "           ork_306 c CreateDataFork_588 c CreateDataFork_30     #    d CreateDataFork_307     D    d CreateDataFork_308 :d CreateDataFork_309 Wd CreateDataFork_310 Zd CreateDataFork_589 
        d CreateDataFork_311 d CreateDataFork_312 d CreateDataFork_590 
    3    d CreateDataFork_313 e CreateDataFork_591 
    5        Le CreateDataFork_314 Ue CreateDataFork_315 be CreateDataFork_316 me CreateDataFork_317 
    "    /    <    e CreateDataFork_592 F    f CreateDataFork_318 f CreateDataFork_593 
        Qf CreateDataFork_319 Qf CreateDataFork_594 
        5   tf CreateDataFork_320 f CreateDataFork_321 f CreateDataFork_322 f CreateDataFork_595 
    3    f CreateDataFork_323 4g CreateDataFork_596 
    M            Vg CreateDataFork_324 hg CreateDataFork_597 2    Q          t   g CreateDataFork_325 '    g CreateDataFork_326 g CreateDataFork_598 g CreateDataFork_30     #    &    )h CreateDataFork_327 S    |h CreateDataFork_328 N    i CreateDataFork_329 i CreateDataFork_330 ,i CreateDataFork_331     3    D    Li CreateDataFork_332 bi CreateDataFork_333 ,    B    i CreateDataFork_334 i CreateDataFork_335 D    i CreateDataFork_336      ,j CreateDataFork_337 4j CreateDataFork_338 4j CreateDataFork_599 
             Rj CreateDataFork_339 Rj CreateDataFork_340 [j CreateDataFork_341 
    mj CreateDataFork_342 
    j CreateDataFork_343 j CreateDataFork_344 
    
    :    X       j CreateDataFork_600 k CreateDataFork_30     #    k CreateDataFork_345 k CreateDataFork_346 
    1k CreateDataFork_347 
    Ck CreateDataFork_348 Ck CreateDataFork_349 
    
    ;    `	   Tk IsAvailDiskSpace k IsAvailDiskSpace_350     k IsAvailDiskSpace_351 
    \    k 
DeleteFile l DeleteFile_352     l DeleteFile_353 l DeleteFile_354         l DeleteFile_355 l DeleteFile_356         -m DeleteFile_357 Om DeleteFile_358     +    vm DeleteFile_601     m DeleteFile_602     m DeleteFile_359 
    m DeleteFile_360 m DeleteFile_361 m DeleteFile_603     n DeleteFile_604 n 
DeleteFile_30     #    A    6n DeleteFile_362 6n DeleteFile_605 	    Jn DeleteFile_606 [n 
DeleteFile_30     #    <    n DeleteFile_363 n DeleteFile_364 n DeleteFile_365 n DeleteFile_607 n DeleteFile_406 n DeleteFile_407 n DeleteFile_408 n DeleteFile_409 	        !    .    R    i    Po DeleteFile_608 E    o DeleteFile_609 
    o DeleteFile_610 o 
DeleteFile_30     #    	p DeleteFile_366        Yp DeleteFile_367 ap DeleteFile_611 
    vp DeleteFile_612 p 
DeleteFile_30     #    G     q DeleteFile_368 	q DeleteFile_369 q DeleteFile_370 9    K    X       `q DeleteFile_613 qq 
DeleteFile_30     #    q DeleteFile_371 q DeleteFile_372 q DeleteFile_373 q DeleteFile_374 q DeleteFile_375 q DeleteFile_376 
            )    H    q DeleteFile_377 +        $r DeleteFile_378 =r DeleteFile_379         r DeleteFile_380 r DeleteFile_381 s DeleteFile_382 s DeleteFile_383 
        !    E    D   (s DeleteFile_384 2s DeleteFile_385 6s DeleteFile_614 Js 
DeleteFile_30     &    -    gs DeleteFile_386 vs DeleteFile_387 vs DeleteFile_615 s 
DeleteFile_30     #    *    s DeleteFile_388 s DeleteFile_616 s 
DeleteFile_30     #    5    n    s DeleteFile_617 s 
DeleteFile_30     #        %t DeleteFile_389      <t DeleteFile_390 Et DeleteFile_391 Et DeleteFile_618 Vt 
DeleteFile_29     "    t DeleteFile_392 -    t DeleteFile_393 t DeleteFile_619 2    I    u DeleteFile_620 u 
DeleteFile_30     #        (u DeleteFile_394 (u DeleteFile_621 9u 
DeleteFile_29     "    Ju DeleteFile_622 
    gu DeleteFile_623 xu 
DeleteFile_30     #    b    N   u DeleteFile_395 u DeleteFile_396 
    u DeleteFile_397 
    u DeleteFile_398 u DeleteFile_399 
    
    ;    *
   u DeleteAllFiles u DeleteAllFiles_400     v DeleteAllFiles_401     Dv DeleteAllFiles_402 Wv DeleteAllFiles_403     rv DeleteAllFiles_404      M        v GetOpenFileStruct v GetOpenFileStruct_405     <    v MarkOpenFileStruct (     w ClearLocalFileTable $w ClearLocalFileTable_406 -w ClearLocalFileTable_407 7w ClearLocalFileTable_408 <w ClearLocalFileTable_409 
        &    3    `    `w InitFileBitMap @    w 
GetFileBitMap     Tx 
SetFileBitMap     $y SetFileBitMapOpen     z SetFileBitMapClosed z SetFileBitMapClosed_410 { SetFileBitMapClosed_624 9    x{ SetFileBitMapClosed_411 { SetFileBitMapClosed_412 { SetFileBitMapClosed_413         ]    | SetFileBitMapClosed_414 R| SetFileBitMapClosed_415 a| SetFileBitMapClosed_416         b          | HashFID E    D} FSIRestoreSalvage     P} FSIPurgeSalvage     X} FSIScanSalvage     d} getCache_numBuffers +    } getCache_flushRatio (    } getCache_flushInterval $    } get_alloc_disk_blocks '    ~ get_extend_disk_blocks (    ,~ get_truncate_disk_blocks +    X~ getCache_buffSize 0    ~ getLogicalValue ~ getLogicalValue_417 ~ getLogicalValue_418     ~ getLogicalValue_419     ]    
 getLogicalValue_420 : getLogicalValue_421     J        x mapNW2LMmode  mapNW2LMmode_422      mapNW2LMmode_423      mapNW2LMmode_424      mapNW2LMmode_425  mapNW2LMmode_426      mapNW2LMmode_427          mapNW2LMmode_428      mapNW2LMmode_429     h     verifyLMmode 9 verifyLMmode_430     < verifyLMmode_431     `     @ set_Override_verifyLMmode$ \ set_Override_verifyLMmode_432$ v set_Override_verifyLMmode_433    $  set_Override_verifyLMmode_434     R    q   "  Diag_dump_open_files_client& ݀ Diag_dump_open_files_client_435    &  Diag_dump_open_files_client_436&  Diag_dump_open_files_client_437&  Diag_dump_open_files_client_438&  Diag_dump_open_files_client_439                 ,    convertNWflagsTostr  convertNWflagsTostr_440      convertNWflagsTostr_441      8 convertNWflagsTostr_442      \ convertNWflagsTostr_443     u convertNWflagsTostr_444      convertNWflagsTostr_445           dbg$dump_open_file_lists# l dbg$dump_open_file_lists_446 	       % | dbg$dump_open_file_list_bucket)  "dbg$dump_open_file_list_bucket_447    )  "dbg$dump_open_file_list_bucket_448 '        8 dbg$dump_sfile_struct  * dbg$dump_sfile_struct_449      Q dbg$dump_sfile_struct_450       dbg$dump_sfile_struct_451  ܅ dbg$dump_sfile_struct_452  ܅ dbg$dump_sfile_struct_453 Y    f        `  		3                		    
 
           		     	                             
 
  	  
  
 	  	         	         	         
 	
 
             	   	                                                                                                                                                                                                                                                                                                          $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "                                               چ                 	       
	 	                
 	              
          	                      
         
                     
                   
      
	                                                                      
 
                   	                  	     	                                             #                      
                                                                                	                	                                    	                                     	                                                                                      :                    ӵ ӵ ӵ ѵ              
		 
          )     	           +              	                           m &             	SYNCCHECK
    FSUTIL  InitFSUtilStructs      ProcessPath ۆ 
ProcessPath_1      
ProcessPath_2  
ProcessPath_3     +    < 
ProcessPath_4     L 
ProcessPath_5     h 
ProcessPath_6 h 
ProcessPath_7      
ProcessPath_8  
ProcessPath_9  ProcessPath_10  ProcessPath_11     2    <     ProcessPath_12      ProcessPath_13 "        4 ProcessPath_14  ProcessPath_15  ProcessPath_16 ވ ProcessPath_17      ProcessPath_18     _     ProcessPath_19                2 ProcessPath_20 e ProcessPath_21     6       l ValidFilenum  ValidFilenum_22 ĉ ValidFilenum_23 
    0    Չ ValidFilenum_24  ValidFilenum_25     O        ( FillInEntryStruct  FillInEntryStruct_44  FillInEntryStruct_36 	    1         MapUICToObjectID 8 MapUICToObjectID_26 < MapUICToObjectID_27 Y MapUICToObjectID_28 
    '    :    `   ! t FillInEntryStructReadAhead$  FillInEntryStructReadAhead_45$  FillInEntryStructReadAhead_36 	    /         FillInEntryStructNoAces! g FillInEntryStructNoAces_46!  FillInEntryStructNoAces_26!  FillInEntryStructNoAces_27!  FillInEntryStructNoAces_28     (    :    e         ܌ FillInEntryStructOpenFile d    @ 	FillInAce V FillInAce_29 s FillInAce_30      FillInAce_31     J     FillInAce_32     ȍ FillInAce_33     ܍ FillInAce_34      FillInAce_35         @ CheckDOSACE a CheckDOSACE_36 	    -    p UpdateDOSACE       AddHybridOwnerToMem  AddHybridOwnerToMem_37 4     AddHybridOwnerToMem_38  AddHybridOwnerToMem_39  AddHybridOwnerToMem_40 
     AddHybridOwnerToMem_41     9    , AddHybridOwnerToMem_42 $    o        X UpdateHybridOwnerToMem  h UpdateHybridOwnerToMem_43 	    '   		$  		                                                      +                   
      
      
                         HOST  InitHostStructs      FSIGetVolumeInformation   FSIGetVolumeInformation_1       FSIGetVolumeInformation_2  ^ FSIGetVolumeInformation_3      w FSIGetVolumeInformation_4  ~ FSIGetVolumeInformation_5            FSIGetVolumeInformation_6            FSIGetVolumeInformation_7 Z       $ IsClusterVolume $    H FSIVolumeSetUp z FSIVolumeSetUp_8  FSIVolumeSetUp_9     L     FSIVolumeSetUp_10  FSIVolumeSetUp_11 `        t FSIVolumeSetUp_12 7     FSIVolumeSetUp_13 O FSIVolumeSetUp_14     `     FSIVolumeSetUp_15     C    FSIRemoveVolume  FSIRemoveVolume_16  FSIRemoveVolume_17  FSIRemoveVolume_18     '    ?    u     
FSIEndVolumes $ FSIEndVolumes_19 ' FSIEndVolumes_48 ' FSIEndVolumes_16 > FSIEndVolumes_17 > FSIEndVolumes_18 !    0    G    n    q         FSIMoveVolumesDown  FSIMoveVolumesDown_20 Η FSIMoveVolumesDown_21 Η FSIMoveVolumesDown_22     '    ?     FSIMoveVolumesDown_23 -        d FSIMoveHomeVolume <     SetUpVolRoot  SetUpVolRoot_24 Ę SetUpVolRoot_25     '    = SetUpVolRoot_26     l SetUpVolRoot                                                                                                                                                                                                                                                                           *$! $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           _27      SetUpVolRoot_28  SetUpVolRoot_29  SetUpVolRoot_30 
    
        Ù SetUpVolRoot_31      '   ș AddDeviceToVMSList  AddDeviceToVMSList_32     ɚ AddDeviceToVMSList_33 9    
 AddDeviceToVMSList_34     6 AddDeviceToVMSList_35 N     AddDeviceToVMSList_36      AddDeviceToVMSList_37      AddDeviceToVMSList_38      AddDeviceToVMSList_39 K AddDeviceToVMSList_40 .     AddDeviceToVMSList_41 7         AddDeviceToVMSList_42 #     AddDeviceToVMSList_43     B    VMSMakeRealPath 8 VMSMakeRealPath_44 L VMSMakeRealPath_45  VMSMakeRealPath_46 	    j            О FSISetFSDateAndTime     ؞ FSIGetFSDateAndTime      VerifyAccountName \    H 
GetChannel     d get_volset_space , get_volset_space_47 i    O  		g3   
           "                	                                                
    ) 
       START_FS  	PGETINT32 <     StartupFileSystem  StartupFileSystem_1  StartupFileSystem_2 $    K         ShutDownFileSystem      InitFileSystem     %  AdditionalFileSystemProcessing( R !AdditionalFileSystemProcessing_13( T !AdditionalFileSystemProcessing_10( } !AdditionalFileSystemProcessing_11(  !AdditionalFileSystemProcessing_12     W           ' .  AdditionalFileSystemProcessing_3' 4  AdditionalFileSystemProcessing_4' O  AdditionalFileSystemProcessing_5    '   AdditionalFileSystemProcessing_6'   AdditionalFileSystemProcessing_7'   AdditionalFileSystemProcessing_8     ]        R   ^  '   AdditionalFileSystemProcessing_9 C    D   \ LoadHybridUsers t LoadHybridUsers_10  LoadHybridUsers_11 ϥ LoadHybridUsers_12     R    y       		y  ,     		              	             SEARCHUTILS  InitSearchContexts      AllocateSearchContext F AllocateSearchContext_1 p AllocateSearchContext_2      AllocateSearchContext_3        T AllocateSearchContext_4 ` AllocateSearchContext_5 u AllocateSearchContext_6     3     AllocateSearchContext_7  AllocateSearchContext_50 O    \     AllocateSearchContext_8  AllocateSearchContext_9  AllocateSearchContext_10     
     AllocateSearchContext_11 
        " AllocateSearchContext_12         P AllocateSearchContext_51 I     AllocateSearchContext_13 
        GetSearchContext = GetSearchContext_14     b GetSearchContext_15     e GetSearchContext_16      m    l DeleteSearchContext  DeleteSearchContext_17 
     DeleteSearchContext_18  DeleteSearchContext_52 I    S        8 RemoveAllSearchContexts! ` RemoveAllSearchContexts_19! h RemoveAllSearchContexts_20! l RemoveAllSearchContexts_53 =    N    V   ! ƫ RemoveAllSearchContexts_21! ԫ RemoveAllSearchContexts_22 
   !  RemoveAllSearchContexts_23 
   !  RemoveAllSearchContexts_24!  RemoveAllSearchContexts_25 
    
    ?         ResetSearchContext Z ResetSearchContext_26     r ResetSearchContext_27      ResetSearchContext_28 
         DeleteTasksContexts \ DeleteTasksContexts_29 n DeleteTasksContexts_30  DeleteTasksContexts_31  DeleteTasksContexts_54 9    ٭ DeleteTasksContexts_32 
    [     DeleteTasksContexts_33  DeleteTasksContexts_55 9    @ DeleteTasksContexts_34 
    q           h   t GetSearchRightsContext   GetSearchRightsContext_35      Ӯ GetSearchRightsContext_36       GetSearchRightsContext_37          MarkSearchContexts , MarkSearchContexts_38 G MarkSearchContexts_39 M MarkSearchContexts_40     h MarkSearchContexts_41     7    R         ClearContext `     
GetSeqFileNum $ GetSeqFileNum_42 : GetSeqFileNum_43 ] GetSeqFileNum_44     9    O         GetSeqNumStruct  GetSeqNumStruct_45 Ұ GetSeqNumStruct_46  GetSeqNumStruct_47 	    ,    B         AddNodeToSeqStruct * AddNodeToSeqStruct_48 7 AddNodeToSeqStruct_56 | AddNodeToSeqStruct_14      AddNodeToSeqStruct_15      AddNodeToSeqStruct_16      n         AddNodeToSeqStruct_49       		'  
                                                          	    ع                    
        	              VMSFILE ` VMSInitStructs L     VMSParseACL  
VMSParseACL_1  
VMSParseACL_2 
    
     
VMSParseACL_3     $ 
VMSParseACL_4     f 
VMSParseACL_5 | 
VMSParseACL_6  
VMSParseACL_7      
VMSParseACL_8  
VMSParseACL_9     ' VMSParseACL_10 B VMSParseACL_11     2    d VMSParseACL_12         b   x    VMSParseACL_13  VMSParseACL_14      VMSParseACL_15  VMSParseACL_16         9    ( VMSParseACL_17 - VMSParseACL_18 
    < VMSParseACL_19 A VMSParseACL_20     %    G        VMSScanACLSegment  VMSScanACLSegment_21  VMSScanACLSegment_22  VMSScanACLSegment_23     ! VMSScanACLSegment_24     5 VMSScanACLSegment_25     ] VMSScanACLSegment_26     y             
VMSVerifyAces  VMSVerifyAces_27 ֶ VMSVerifyAces_28     I     VMSVerifyAces_29  VMSVerifyAces_30     k     VMSVerifyAces_31  VMSVerifyAces_32 
    %    ̷ VMSVerifyAces_33 ;     VMSVerifyAces_34 $ VMSVerifyAces_35 C VMSVerifyAces_36     =    _       t MapICACEToNetWare  MapICACEToNetWare_37      MapICACEToNetWare_38      MapICACEToNetWare_39      MapICACEToNetWare_40     V    ̸ VMSReadFileAttributes  VMSReadFileAttributes_41      VMSReadFileAttributes_42      VMSReadFileAttributes_43     A VMSReadFileAttributes_44     H VMSReadFileAttributes_45     b VMSReadFileAttributes_46 K     VMSReadFileAttributes_47  VMSReadFileAttributes_48     &    S     VMSFileFind m VMSFileFind_49  VMSFileFind_50          VMSFileFind_51 	 VMSFileFind_52 Y VMSFileFind_53              VMSFileFind_54      VMSFileFind_55     ܽ VMSFileFind_56  VMSFileFind_57 ( VMSFileFind_58      VMSFileFind_59      VMSFileFind_60      VMSFileFind_61     о VMSFileFind_62          VMSFileFind_63         VMSFileFind_64      VMSFileFind_65 % VMSFileFind_66     8 VMSFileFind_67 E VMSFileFind_68     \ VMSFileFind_69     /    n VMSFileFind_70  VMSFileFind_71      VMSFileFind_72 ۿ VMSFileFind_73                                                                                                                                                                                                                                                                           % $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              II "     #           3 VMSFileFind_74     P VMSFileFind_75     q VMSFileFind_76      VMSFileFind_77         &   u    VMSFileFind_78  VMSFileFind_79          VMSFileFind_80 .    I VMSFileFind_81 l VMSFileFind_82  VMSFileFind_83      VMSFileFind_84      VMSFileFind_85  VMSFileFind_86 4 VMSFileFind_87     Y    u VMSFileFind_88 &     VMSFileFind_89      VMSFileFind_90 $     VMSFileFind_91     2 VMSFileFind_92 ; VMSFileFind_93         W VMSFileFind_94     g      3   `    LongNameSearch  LongNameSearch_95 ( LongNameSearch_96 C LongNameSearch_97     z LongNameSearch_98     l     LongNameSearch_99  LongNameSearch_100     5        LongNameSearch_101  LongNameSearch_102     L LongNameSearch_103 g LongNameSearch_104      LongNameSearch_105     l     LongNameSearch_106  LongNameSearch_107 
    /           
VMSTrusteeACE  VMSTrusteeACE_108     / VMSTrusteeACE_109     O VMSTrusteeACE_110 T VMSTrusteeACE_111 5    :     VMSTrusteeACE_112      VMSTrusteeACE_113      VMSTrusteeACE_114 y VMSTrusteeACE_115      VMSTrusteeACE_116      VMSTrusteeACE_117          VMSTrusteeACE_118  VMSTrusteeACE_119  VMSTrusteeACE_120         >     VMSTrusteeACE_121 - VMSTrusteeACE_122 r VMSTrusteeACE_123      VMSTrusteeACE_124      VMSTrusteeACE_125          VMSTrusteeACE_126 :         VMSTrusteeACE_127      VMSTrusteeACE_128      VMSTrusteeACE_129      VMSTrusteeACE_130         VMSUpdateDOSNameSpace   VMSUpdateDOSNameSpace_131       VMSUpdateDOSNameSpace_132 4      VMSUpdateDOSNameSpace_133   VMSUpdateDOSNameSpace_134   VMSUpdateDOSNameSpace_135   VMSUpdateDOSNameSpace_136 
         j    n       | VMSBackLinkHost  VMSBackLinkHost_137      VMSBackLinkHost_138      VMSBackLinkHost_139      VMSBackLinkHost_140       VMSBackLinkHost_141      VMSBackLinkHost_142      VMSBackLinkHost_143 3    C VMSBackLinkHost_144     X VMSBackLinkHost_145     p VMSBackLinkHost_146 y VMSBackLinkHost_147 
     VMSBackLinkHost_148 
     VMSBackLinkHost_149  VMSBackLinkHost_150 
    
    :    2    VMSNextFile + VMSNextFile_151     G VMSNextFile_152     \ VMSNextFile_153         h VMSGetFileName  VMSGetFileName_154      VMSGetFileName_155          VMSBackLink  VMSBackLink_156      VMSBackLink_157          VMSFoundFile Z VMSFoundFile_158     s VMSFoundFile_159          VMSForwardLink  VMSForwardLink_160      VMSForwardLink_161         < VMSDirectoryReadAhead  m VMSDirectoryReadAhead_162   VMSDirectoryReadAhead_163   VMSDirectoryReadAhead_164 8      VMSDirectoryReadAhead_165 !    v          VMSDirectoryReadAhead_166   VMSDirectoryReadAhead_167          8 VMSDirectoryReadAhead_168      H VMSDirectoryReadAhead_169 9      VMSDirectoryReadAhead_170 
      VMSDirectoryReadAhead_171      , VMSDirectoryReadAhead_172 '       X VMSRetrieveDirReadAhead" p VMSRetrieveDirReadAhead_173 !   "  VMSRetrieveDirReadAhead_174    "  VMSRetrieveDirReadAhead_175    "  VMSRetrieveDirReadAhead_176"  VMSRetrieveDirReadAhead_177 
       "  VMSRetrieveDirReadAhead_178"  VMSRetrieveDirReadAhead_179 
       " I VMSRetrieveDirReadAhead_180" b VMSRetrieveDirReadAhead_181        "  VMSRetrieveDirReadAhead_182"  VMSRetrieveDirReadAhead_183        "  VMSRetrieveDirReadAhead_184    "  VMSRetrieveDirReadAhead_185" % VMSRetrieveDirReadAhead_186     K   " 9 VMSRetrieveDirReadAhead_187" G VMSRetrieveDirReadAhead_188 
   " b VMSRetrieveDirReadAhead_189 
    3   " { VMSRetrieveDirReadAhead_190"  VMSRetrieveDirReadAhead_191 ;   "  VMSRetrieveDirReadAhead_192" / VMSRetrieveDirReadAhead_193    " V VMSRetrieveDirReadAhead_194" j VMSRetrieveDirReadAhead_195     -    o      "  VMSRetrieveDirReadAhead_196" ( VMSRetrieveDirReadAhead_197 5    v       p VMSmkdir  VMSmkdir_198      VMSmkdir_199      VMSmkdir_200      VMSmkdir_201 9     VMSmkdir_202 $     VMSmkdir_203      VMSmkdir_204      VMSmkdir_205      VMSmkdir_206      VMSmkdir_207 Z VMSmkdir_208     t VMSmkdir_209     j     VMSmkdir_210      VMSmkdir_211      VMSmkdir_212  VMSmkdir_213     $        VMSrmdir  VMSrmdir_214      VMSrmdir_215          	VMSrename ` 
VMSrename_216  
VMSrename_217      
VMSrename_218      
VMSrename_219     b 
VMSrename_220  
VMSrename_221     _    d       VMSCommonWriteAttributes#  VMSCommonWriteAttributes_222#  VMSCommonWriteAttributes_223 R   # @ VMSCommonWriteAttributes_224 (   # m VMSCommonWriteAttributes_225 U   #  VMSCommonWriteAttributes_226 )      #  VMSCommonWriteAttributes_227 %   # ! VMSCommonWriteAttributes_228 $       ` VMSWriteFileAttributes!   VMSWriteFileAttributes_229    ! % VMSWriteFileAttributes_230    ! , VMSWriteFileAttributes_231    ! D VMSWriteFileAttributes_232! J VMSWriteFileAttributes_233        ! T VMSWriteFileAttributes_234     	   l VMSWriteRecordAttributes#  VMSWriteRecordAttributes_235    #  VMSWriteRecordAttributes_236    #  VMSWriteRecordAttributes_237          VMSOverWriteICACE      VMSOpenFile  VMSOpenFile_238 , VMSOpenFile_239      1 VMSOpenFile_240     -    L VMSOpenFile_241     ~ VMSOpenFile_242      VMSOpenFile_243      VMSOpenFile_244      VMSOpenFile_245      VMSOpenFile_246      VMSOpenFile_247  VMSOpenFile_248 )    K       d 
VMSReOpenFile  VMSReOpenFile_249      VMSReOpenFile_250     
 VMSReOpenFile_251  VMSReOpenFile_252     !    0 VMSReOpenFile_253     \ VMSReOpenFile_254     w VMSReOpenFile_255     '    VMSCloseFile  VMSCloseFile_256      VMSCloseFile_257 c    X VMSCloseFile_258 `     VMSCloseFile_259      VMSCloseFile_260  VMSCloseFile_261       VMSCloseFile_262     D      VMSCloseFile_263        p VMSReadData  VMSReadData_264 n    $ VMSReadData_265 >    e VMSReadData_266     x VMSReadData_267  VMSReadData_268         #    VMSWriteData  VMSWriteData_269 @ VMSWriteData_270     \ VMSWriteData_271 
    j VMSWriteData_272     t VMSWriteData_273 "         VMSWriteData_274 =    4 VMSWriteData_275     V VMSWriteData_276        l VMSAllocateDiskSpace  VMSAllocateDiskSpace_277      VMSAllocateDiskSpace_278      VMSAllocateDiskSpace_279     4 VMSAllocateDiskSpace_280 [ VMSAllocateDiskSpace_281     w VMSAllocateDiskSpace_282     S        VMSTruncateFile  VMSTruncateFile_283     , VMSTruncateFile_284         @ 
VMSDeleteFile  VMSDeleteFile_285      VMSDeleteFile_286      VMSDeleteFile_287           
VMSCreateFile  VMSCreateFile_288  VMSCreateFile_289         $ VMSCreateFile_290 	    9 VMSCreateFile_291 %    { VMSCreateFile_292 ,     VMSCreateFile_293      VMSCreateFile_294     3 VMSCreateFile_295     f VMSCreateFile_296  VMSCreateFile_297      VMSCreateFile_298     V     VMSCreateFile_299  VMSCreateFile_300 )    L       < VMSOverWriteFile r VMSOverWriteFile_301      VMSOverWriteFile_302 
     VMSOverWriteFile_303      VMSOverWriteFile_304 $    ' VMSOverWriteFile_305 1                                                                                                                                                                                                                                                                              ' $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "           )cag`#"o0yVF>ibN?aޖ,rx>t]0,ÖaЬ9˭5]-aaeC.~ijBȮSM;CR$Ǆԛ^K9Yg[jnnQ Jd>쀗^<\wЅ% +Y[ʊM/|F
@*NHi kŇ??.qs ː,ys1 IB<07d.}'0wvC?ʭ&O?=cC䚼[x3Uʴe}?zr];abt>
K"Qh$Y\"7Pb1[qЫbn,>K/Z<v;jeόpsrᡊ`-Μg8Éi[Ί8G9(
.a ,EEx~-1t$=j~ EMayEEbeXuv
K`R)çɛZ h{d@Toʜ݈:-XVM̀([iDdtE^ p'	@1r$'
ıTG͐O˴'MXnxrԫc+jZ1Dĩ	hjzhFJ4]w34c6ϝ=$G#&]<'HS^Ve !Xa4%Rn@iڶ] iqhJY+}H ںo8_PMX[籉1EJC}֚avË񽋌jvȒ%!38q'`<j{L[1&Ii0b\
]脊, ص8t]q5ǌڥ8zZ
^4#:y1\H'q\3NCXvmsn0QT@@OKnˊ!@'N}tmgYU8t˜=_z}ϓp\%qF
%Jc4Odv.*%=Exdr#DS/\+AMlezy;w Ps6`6J2G/P	g}[8N	k5K~iqBA({4VdD'`h cO^*⑺.hۺ~O101}ʬzXd*
x l=J#.꼄_^jƋ2A9HzXPޜBjƇ`ZI, fvWiF>g]9^h:
[M",qԴK7%~Eg3\xRB/'<ybccgMI@J83W䚢+r˔ڧ7Ke?/uIgXH,etgotH9Ez%m
%}ѡ
'b3Cѭ$"Z[ɮ7h!2
6cON]l}ĭ+{0܋ziӜ`2XNl7;Pt'V#h!è7ua `z06jO!&(^9.ct	Uaۢ,p9?P,mӠ;ka1PhG2V`IܤcK Rdv-	uDI޷nCt	غK0SQ$gQA%a|?HI@9qЙ:Md+o`JO͢BbZ*iWӏA1"p ai=`bWڑ;*omH}z8iu~v4e@+9L6 FLw'6u",E9w\Ri@tҤ8Ċ:Tk r{W[X~@XeQVACgN3dB,$FνkrKu
 v>m0]-~TQK+q*5fl:Ԇ4F ,Q|U8-4N:&6OuF'fPj]o`$tC[VQGN
	I,pݛ/°eRl
al3!R@d{`.^齴#nl6LFYSJj\Ieg[tjXýC|4e
NX㩠SddIb<-+߳ I4:	J "%ͭBF7 =P,%rGLҦD1q?q2oB3z,<cTw䄧3tf~ߧ5C}%;VwX٬k}E@i#'bO_=^B<8Ջ,#?LGS2TEMh dmuęMJaF
jWl9ڝ|mэ§Â	nR~#XmWB>0oŀ~۝؉7̶xoJqGޕIynm7;Y!:osU|l>SH4!}()Ա;%;ZYrd7'_$dT7>}8g%'zb':8v^P&s;!C-P9(G-&LMLC.'h48yeQy@
z8fi-2@2){
d6Ȟo׈9aybJZiq{4_6}︱/BB1FHrb^_c֘2/(,SK.30rXlP0=ZCQvS'fz`3'ͬm**:gub;buLe	*C
P7NBW6<j83djps֑IrBks9)Kוγ[VMdk(!(j+*Ga^tvل53HlX@w
bR9IS(9&|3;ns˭Ź6MbޑLK<څh֔\Umm{? WB螸'kߍaz-*>-w!ot/pp?/!`"|1<zoҠ	g8ppF(^aqEPؠ@6ŷ7(g<F Aa>
p5Iw0/lT(bs.
<xmc6ji,r
~2IY&8bAF
l7trgK0ub}+z6bkM6Cz!Sz2DbaͮTL}Q]c^ahzfpm:?dʛRW`Da
_2$&c|O'1Qd%	jible0yV
O=8
T-Guޡw\*xCh%-;JşFȗ'ٲf ҬӲL6\H(_\Pʗ~^7m&Ku=_5̄QK>mvd4$8[6^!oDb]QY9\g].|GEEO/*g|grHLxSuꐫDm2JQD@*g؈8
w&zpqL5p)D8~kЩ~
8~jSwiz+KxO˩O/l۞+nB@zU`t4bҙ6RO&|2^-:8<?PcT`NAG܈5|<TGrr[?g)ꡑ#fFuXXFeVR謂ML|8RlL)lZ}lGew~?G;YPJq
,	`rd߮©V- &ZGEb`Sgd%Z
lzoTtm]&YG'_|5XGҜJcs`qEuJHċ:c$L,+ߌCJheg^sSh&*syT'zpPx=$ArN\fP	BqakAwXT/ɸ!㙋Me"',/I2-SFjՖ'؈Z%9ԫڽgϽZr=FOΝT4-HkFՏS̡>4S{XGI:F:4"XG-ѡwZéeO*]LUI$..o}+eza?[
<a煱z^O1N
sw4mT
?Zy'EE9N]j:o=lTvkEr/>]hh"rCgST:ж;RTf1],4*Ȃzu͆d:y϶)9R:#JqKnzM0BI;vWˆϳmq
{Ls8$+_usD*\e1ʼ
:vL=Fz ׼יZA`_g20`A^_uk9A]kU=ς?pt/ .圷Ϝh~}\%X9_%ti[sD[uuGۧ1%;t0qe1&3l3KR"-cxa]"Ġa<}_2]zS8 xI׎r(dY}K/Ί0;s:hTVv ܢEI[ WrWO)`fEdթ;;vWSC?:##=Ȕ&P3_e,mJumU;8;#'cZH$djd:}t]de^I{cRݜVtq4JPPԧ'
j<<l8݀*No4Ten-Q4!Fvk*EreQbhO\}͝sO=+lKo{r&:>e0=^QX@uHT;4FgXKVA"
jioT6US֙#$:=؆m5=X#CL^5&6~`rM_Y$ғBjX``.d~NBחip7uY;QM #oKY/wYUKHd˼GqGl3n&7zDvyμ堥4eeAn10<I2f*F?υ!]f-6bڔ-୼*t~1T2#])bBGN\q@(B!'{A
Y0ܙO,w?I`mEfaР2ߣ[b1	yvZHHی
F{hCDp~d^YdmhQ|?~|Md+UNn<vH[m.!VފJU>5jd)P6  2oz#-O.`8ZpLH䇮vPC6ؗKѣIgjɝ%4@
^jU0qm裤ub'3e=3g齉Qp`(o^?o"6d`T4
}N:è#4hh e)w(r{P1h^g1+]5rz}(Y@gyb|1>eN!dFX~'s$
Y
g4\w^x;$hC+׍<J缎}Jw %yL-a?Perϸ}1-dDMU*uN?5	e`ۚ7l>"KҖ.ϜAbrDqf:$xRCkl}_oUx2aP
eXGD[fIW3ڮ7Pq}F_4--X_rٓNޚy#;63u$j 	՘mW㫅PB/)Ğदܫ >?+g&UF$DusWA (R`m:i4"JpCF'
JI:Z5d)yR4վݺB68K*|adב	ۦ%U~G=jr#l=6)
To=nLm1իxC+0ۂ6@Üb4'!]2oUTŬ'fxtZr
MǺb.GK	л # ܷmLևONjPlK":jy%t^EB~ʰ#p.Ү|DpO#LX'aMkX}uM.BScO X1<{/ۙA̞tX84e5_:i)&N+Ldd4]wPQ<?s] ;$A;}Bv
ⰕVx᧦ ZUʗե(ULӊG(8>繁}M۳|ؗMcoUW%wU%z<,;l+(YMi.&!ά݋뭩V31P9p&Dw^ǖLhҝOpIC3O>k5RSSs1D=.$8JI6ap4yWPߥ4tm{f f2*!,h~{]_oݝs6km=zG`C&
""LL xȥhpP̈[{AzS_@L_
zLvE[cwrD<5r~olx~6:-qMm 1z7
ݐ5m[׌2N9X7M`+G M\/)6agM8A0'PavNkJڨ;t8iss;҂9ؼ O!7|Zx?*(z<m<'զI'EA;!9B-8dR`u Ll>+R*$ߩ-.xYK>/-xK-A
Ǯ_Y,i~a*`zt]p8mgKGۺ{ GS:;T~dDL=V(
-%ÛexjX!?w;4duv{{FT",kM|x%Dt:UTQſCv,xҖ&΂9:	57Pgޛu cčav8[&lŊ8kRmI2%6'
˺ #9q?+`!_Wno<~.Y|IiJNh߾G2r9>MSa5b~X{6E&F9IZbFy Ufyf	URw/MK#['((uuehL|Od.HJW	Z} ҩUO{.3^PS)QCq@Vۥ|tebau't.X[
-Z^$,;v4y6kyp?cP6bLx .H=g/I^I-h[xr4q%\Y8+UVY)h4:Y1𜶵hBx#~-F
WV14]c+j*	 6Wgf;Qv"lb|u31(bi.kt]LZ`^r2BCULƽc3FUWADw|PuCRL?9#͑
)ʗ[,&#I,EN;ɿU8&ͩR;\{~8 ǯĝ7p/=߇.zO)k׫_V00Mԩ#h̛5S=FD&B;dq?F<`?ڐ!N\ŰB)|݊'~5}7	4Y6Fw\𮫻dkH_>	8%7"6Gk7q f	E)70Lp&fFY-ʨTBuE`HjXspR`^~cy}($\I=fy~iOWF6!AƗB6zv6d'~Q_8e0Oǯowaz],з>
D*NsP7-*P=hh
9[S,	ě,D-u7걪S:Xc"ıy7.GmF*t[D:q%,ܙf1mrYiHĘHHMgc? ^{'_,aS*:PHw
zpQ|לkwV,[
6 dyj~_$&*ܥXc";W]RX!,                                                                                                                                                                                                                                                                            $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              p: "     4        VMSOverWriteFile_306      VMSOverWriteFile_307      VMSOverWriteFile_308      VMSOverWriteFile_309       VMSOverWriteFile_310 I       P VMSGetRootCreateDate  VMSGetRootCreateDate_311      VMSGetRootCreateDate_312          DECCacheCountDown  DECCacheCountDown_313 
          DECCacheRead  DECCacheRead_314     0 DECCacheRead_315     L DECCacheRead_316 W DECCacheRead_317 p DECCacheRead_318      DECCacheRead_319 J DECCacheRead_320 \ DECCacheRead_321     u DECCacheRead_322 	    8         DECCacheRead_323  DECCacheRead_324  DECCacheRead_325 	        0     DECCacheRead_326 	        DECCacheRead_327 | DECCacheRead_328      DECCacheRead_329         ]    DECCacheRead_330  DECCacheRead_331  DECCacheRead_332  DECCacheRead_333 	         DECCacheRead_334     , DECCacheRead_335     F DECCacheRead_336           p   p 
DECCacheWrite  DECCacheWrite_337      DECCacheWrite_338      DECCacheWrite_339  DECCacheWrite_340     $ DECCacheWrite_341     {    D DECCacheWrite_342 O DECCacheWrite_343 h DECCacheWrite_344      DECCacheWrite_345  DECCacheWrite_346  DECCacheWrite_347     ' DECCacheWrite_348 	    8        X DECCacheWrite_349 i DECCacheWrite_350 { DECCacheWrite_351 	        0     DECCacheWrite_352 	    I    DECCacheWrite_353  DECCacheWrite_354     
 DECCacheWrite_355            $ DECCacheWrite_356 $ DECCacheWrite_357  DECCacheWrite_358  DECCacheWrite_359      DECCacheWrite_360      DECCacheWrite_361 M DECCacheWrite_362 M DECCacheWrite_363 	        q DECCacheWrite_364 q DECCacheWrite_365 	             DECCacheWrite_366 	    Q    DECCacheWrite_367 F    > DECCacheWrite_368     b DECCacheWrite_369     [   `       DECcache_create_a_thread 0     DECCache_delay_thread      VMSLowerVersion  VMSLowerVersion_370     @ VMSLowerVersion_371     K VMSLowerVersion_372  VMSLowerVersion_373  VMSLowerVersion_374 N    9 VMSLowerVersion_375     e VMSLowerVersion_376      VMSLowerVersion_377  VMSLowerVersion_378 	     VMSLowerVersion_379 "    X    %        VMSLowerVersion_380 !  VMSLowerVersion_381 
    3  VMSLowerVersion_382 
    E  VMSLowerVersion_383 E  VMSLowerVersion_384 
    
    ;      ! X  MaintainClusterServerNames% v  MaintainClusterServerNames_385%   MaintainClusterServerNames_386 
       %   MaintainClusterServerNames_387%   MaintainClusterServerNames_388% 
 MaintainClusterServerNames_389     %   % 1 MaintainClusterServerNames_390% O MaintainClusterServerNames_391% q MaintainClusterServerNames_392% ~ MaintainClusterServerNames_393 
        <    Z        8    MakeClusterServerList   MakeClusterServerList_394 <       		3`           	       
                         	                                                                     
    	    	                                                     	                           	                                                             
                  	 
            	   
                
         
                                                                  
                                	            
                
 	          	
       
 
            
      
   	  	            

          
 
     
   
   	      
	        
     
           
                           		                     
	  
 		                         	            	               
      
 
           
     
                   
 O                     
TRACE_BACK  
trace_back * trace_back_1 	        4 stderr_trace_back B stderr_trace_back_2         P data_trace_back     d turn_traceback_on     t turn_traceback_off      do_traceback  do_traceback_3  do_traceback_4      do_traceback_5          do_traceback_6      do_traceback_7      do_traceback_8      do_traceback_9 
     do_traceback_10  do_traceback_11      do_traceback_12 
    ( do_traceback_13     @    D do_traceback_14 I do_traceback_15     ^ do_traceback_16     d do_traceback_17 
    *    s do_traceback_18 
     do_traceback_                                                                                                                                                                                                                                                                           Sff $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              6 "     E      19       		' k                 RMSFILE  RMSInitStructs      RMSOpenFile  
RMSOpenFile_1      
RMSOpenFile_2     R 
RMSOpenFile_3      
RMSOpenFile_4      
RMSOpenFile_5      
RMSOpenFile_6   
RMSOpenFile_7 	    
 
RMSOpenFile_8 	        j    RMSResumeThreadAstFAB     0 RMSCloseFile Y RMSCloseFile_9     L    | RMSConnectFile  RMSConnectFile_10      RMSConnectFile_11      RMSConnectFile_12          RMSDisconnectFile A RMSDisconnectFile_13     e RMSDisconnectFile_14 
    r RMSDisconnectFile_15     l     RMSReadWholeFile  RMSReadWholeFile_16  RMSReadWholeFile_17  RMSReadWholeFile_18     (     RMSReadWholeFile_19     A RMSReadWholeFile_20 J RMSReadWholeFile_21     T        @    RMSSeekFile  RMSSeekFile_22  RMSSeekFile_23      RMSSeekFile_24  RMSSeekFile_25     @ RMSSeekFile_26 J RMSSeekFile_27 S RMSSeekFile_28 .    7    A    }         RMSSeekFile_29  RMSSeekFile_30  RMSSeekFile_31     #     RMSSeekFile_32  RMSSeekFile_33  RMSSeekFile_34 2    <    	 RMSSeekFile_35 	 RMSSeekFile_36          t        T	 RMSSeekFile_37 ]	 RMSSeekFile_38     	 RMSSeekFile_39     	 RMSSeekFile_40 	 RMSSeekFile_41 	 RMSSeekFile_42     Q    ~           `
 	RMSRewind 
 RMSRewind_43     
 RMSRewind_44     
 RMSRewind_45         
 
RMSSeqRead A 
RMSSeqRead_46     _ 
RMSSeqRead_47 $     
RMSSeqRead_48  
RMSSeqRead_49  
RMSSeqRead_50     d    i     
RMSSeqRead_51     8    
RMSRFARead ~ 
RMSRFARead_52      
RMSRFARead_53 "     
RMSRFARead_54  
RMSRFARead_55  
RMSRFARead_56     d    i    =
 
RMSRFARead_57     @   X
 RMSReadFile v
 RMSReadFile_58 
 RMSReadFile_59     Z    
 RMSReadFile_60 
 RMSReadFile_61     #     RMSReadFile_62     A RMSReadFile_63 H RMSReadFile_64     2     RMSReadFile_65  RMSReadFile_66      RMSReadFile_67     h        @ RMSProcessCarriageControl# i RMSProcessCarriageControl_68# t RMSProcessCarriageControl_69     #   #  RMSProcessCarriageControl_70#  RMSProcessCarriageControl_71    #  RMSProcessCarriageControl_72#  RMSProcessCarriageControl_73    #  RMSProcessCarriageControl_74    #  RMSProcessCarriageControl_75#  RMSProcessCarriageControl_76    #   RMSProcessCarriageControl_77    #  RMSProcessCarriageControl_78    # $ RMSProcessCarriageControl_79    # , RMSProcessCarriageControl_80    # 4 RMSProcessCarriageControl_81     F   # E RMSProcessCarriageControl_82# n RMSProcessCarriageControl_83# p RMSProcessCarriageControl_84    # u RMSProcessCarriageControl_85    # | RMSProcessCarriageControl_86    #  RMSProcessCarriageControl_87 
       #  RMSProcessCarriageControl_88    #  RMSProcessCarriageControl_89 
    u       $  #  RMSProcessCarriageControl_90          RMSResumeThreadAst @     RMSGetAnotherRAB 8 RMSGetAnotherRAB_91       RMSGetAnotherRAB_92 +     RMSGetAnotherRAB_93 ,    @   D 
RMSReadRecord V RMSReadRecord_94 _ RMSReadRecord_95     u RMSReadRecord_96     9     RMSReadRecord_97  RMSReadRecord_98      RMSReadRecord_99     Y     RMSReadRecord_100     X RMSReadRecord_101 E     RMSReadRecord_102  RMSReadRecord_103      RMSReadRecord_104     `     RMSReadRecord_105        ( RMSWriteRecord < RMSWriteRecord_106 E RMSWriteRecord_107     [ RMSWriteRecord_108     -    l RMSWriteRecord_109      RMSWriteRecord_110      RMSWriteRecord_111      RMSWriteRecord_112      RMSWriteRecord_113      RMSWriteRecord_114        4 RMSCreateRecordFile  RMSCreateRecordFile_115  RMSCreateRecordFile_116 
     RMSCreateRecordFile_117 	        ' RMSCreateRecordFile_150 4 RMSCreateRecordFile_137 9 RMSCreateRecordFile_138          H RMSCreateRecordFile_139 L RMSCreateRecordFile_140         ?    5   l RMSOpenRecordFile < RMSOpenRecordFile_118 < RMSOpenRecordFile_119 
    I RMSOpenRecordFile_120 	        ^ RMSOpenRecordFile_151 l RMSOpenRecordFile_137 q RMSOpenRecordFile_138           RMSOpenRecordFile_139  RMSOpenRecordFile_140         @    5    RMSCloseRecordFile  RMSCloseRecordFile_152  RMSCloseRecordFile_141  RMSCloseRecordFile_142         +     RMSCloseRecordFile_121     M RMSCloseRecordFile_122     b RMSCloseRecordFile_123 
        x 
RMSGetContext  RMSGetContext_124      RMSGetContext_125     =     RMSFreeContext (     RMSCreateAppendFile % RMSCreateAppendFile_126 % RMSCreateAppendFile_127 	         RMSCreateAppendFile_128  RMSCreateAppendFile_129 	     RMSCreateAppendFile_130 	         RMSCreateAppendFile_131 +    O RMSCreateAppendFile_132 ,     RMSCreateAppendFile_133 	        RMSAppendRecord  RMSAppendRecord_134     i     RMSAppendAST ) RMSAppendAST_135 ) RMSAppendAST_136 
    
    :    P RMSTruncateAppendFile _     RMSAddToFlushList  RMSAddToFlushList_137  RMSAddToFlushList_138          RMSAddToFlushList_139  RMSAddToFlushList_140         X     RMSRemoveFromFlushList! , RMSRemoveFromFlushList_141! 1 RMSRemoveFromFlushList_142     
    C    L RMSFlushOpenFiles ` RMSFlushOpenFiles_143 p RMSFlushOpenFiles_144         2     RMSFlushRecordFile  RMSFlushRecordFile_145  RMSFlushRecordFile_146          RMSFlushRecordFile_147     	 RMSFlushRecordFile_148       RMSFlushRecordFile_149        		4                                             !       
                                                            	              	        (                                                                                                                                                 
        	               VMSUTILS  pnw$qiow 0     VMS_log_error_status P   
 h min      VMSInitUtilStructs ,     
VMSVolListPtr  VMSVolListPtr_1      n     
VMSVolRoot = VMSVolRoot_2     \ VMSVolRoot_3     S    p MyHybridHomeVol  MyHybridHomeVol_4  MyHybridHomeVol_219  MyHybridHomeVol_2 "     MyHybridHomeVol_3     H    u          VMSGetDirEntry                                                                                                                                                                                                                                                                           d1i $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              ; "     V       b  VMSGetDirEntry_220       VMSGetDirEntry_221   VMSGetDirEntry_1      ]    ! VMSGetDirEntry_5     0! VMSGetDirEntry_222 4! VMSGetDirEntry_205 	    
    P   \! VMSProcessAction ! VMSProcessAction_6     ! VMSProcessAction_7 ! VMSProcessAction_8 " VMSProcessAction_223 :" VMSProcessAction_199     k" VMSProcessAction_200         " VMSProcessAction_9 
        " VMSProcessAction_224 " VMSProcessAction_2 !    " VMSProcessAction_3     P    # VMSProcessAction_10     J# VMSProcessAction_225 8    # VMSProcessAction_11 # VMSProcessAction_226 O    V    # VMSProcessAction_12     # VMSProcessAction_13     $ VMSProcessAction_14 B$ VMSProcessAction_227 v$ VMSProcessAction_199 #    $ VMSProcessAction_200 "        $ VMSProcessAction_15 
% VMSProcessAction_16             o   % VMSProcessAction_17 % VMSProcessAction_18 
    +% VMSProcessAction_19 
    =% VMSProcessAction_20 =% VMSProcessAction_21 
    
    ;       P% VMSForwardLinkCheck % VMSForwardLinkCheck_22     % VMSForwardLinkCheck_23 & VMSForwardLinkCheck_24 %& VMSForwardLinkCheck_228 R& VMSForwardLinkCheck_199     & VMSForwardLinkCheck_200         & VMSForwardLinkCheck_25 
        & VMSForwardLinkCheck_229 6    ' VMSForwardLinkCheck_26 ' VMSForwardLinkCheck_230 P    W    k' VMSForwardLinkCheck_27     ' VMSForwardLinkCheck_28 ' VMSForwardLinkCheck_29 ' VMSForwardLinkCheck_231 ' VMSForwardLinkCheck_199 #    7( VMSForwardLinkCheck_200 "        z( VMSForwardLinkCheck_30 ( VMSForwardLinkCheck_31                   ( VMSForwardLinkCheck_32 ( VMSForwardLinkCheck_33 
    ( VMSForwardLinkCheck_34 
    ( VMSForwardLinkCheck_35 ( VMSForwardLinkCheck_36 
    
    ;       ( RestoreNonNumberedName  ) RestoreNonNumberedName_37  ) RestoreNonNumberedName_38     &     @) RestoreNonNumberedName_39  E) RestoreNonNumberedName_40      d) RestoreNonNumberedName_41      ) RestoreNonNumberedName_42     K        ) MakeNumberedName ) MakeNumberedName_43 
    ) MakeNumberedName_44     ) MakeNumberedName_45 ) MakeNumberedName_46 $    * MakeNumberedName_47 2    ]    L* MakeNumberedName_48 Q* MakeNumberedName_49 %    }* MakeNumberedName_50 5    * MakeNumberedName_51 .        W   * GetLongNameNumber * GetLongNameNumber_52     7    + 
VMSGetDOSPath + VMSGetDOSPath_53     + VMSGetDOSPath_54 
    + VMSGetDOSPath_232 + VMSGetDOSPath_2 #    , VMSGetDOSPath_3     U    ', VMSGetDOSPath_55     x, VMSGetDOSPath_56 , VMSGetDOSPath_233 D    - VMSGetDOSPath_57 - VMSGetDOSPath_234 P    W    p- VMSGetDOSPath_58     - VMSGetDOSPath_59 *    - VMSGetDOSPath_235 - VMSGetDOSPath_52     ;    . VMSGetDOSPath_60     4. VMSGetDOSPath_61 #    ]. VMSGetDOSPath_62     . VMSGetDOSPath_63     V   . VMSGetDOSPath_236 '    / VMSGetDOSPath_237 '    @/ VMSGetDOSPath_64     Z/ VMSGetDOSPath_65 |/ VMSGetDOSPath_66     H       / CompareNames / CompareNames_67 0 CompareNames_68 U0 CompareNames_69     0 CompareNames_70 7        B   x   01 MakeDOSName V1 MakeDOSName_71     x1 MakeDOSName_72 1 MakeDOSName_73 1 MakeDOSName_74 2 MakeDOSName_75 12 MakeDOSName_76     J2 MakeDOSName_77     ^2 MakeDOSName_78     {2 MakeDOSName_79     2 MakeDOSName_80 2 MakeDOSName_81     C            2 MakeDOSName_82 &    3 MakeDOSName_83     K3 MakeDOSName_84        y3 MakeDOSName_85 }3 MakeDOSName_86 3 MakeDOSName_87 
        3 MakeDOSName_88 3 MakeDOSName_89     )    D    3 MakeDOSName_90 3 MakeDOSName_91 3 MakeDOSName_92         3 MakeDOSName_93 3 MakeDOSName_94         ,    3 MakeDOSName_95 3 MakeDOSName_96 4 MakeDOSName_97 4 MakeDOSName_98                       H4 MakeVMSName y4 MakeVMSName_99     4 MakeVMSName_100 4 MakeVMSName_101     4 MakeVMSName_102     4 MakeVMSName_103 4 MakeVMSName_104 4 MakeVMSName_105         9    N5 MakeVMSName_106 U5 MakeVMSName_107     d5 MakeVMSName_108     5 MakeVMSName_109 5 MakeVMSName_110 5 MakeVMSName_111         5 MakeVMSName_112 5 MakeVMSName_113 5 MakeVMSName_114         5    Y    5 MakeVMSName_115 5 MakeVMSName_116 
    5 MakeVMSName_117 	    4    6 MakeVMSName_118     N6 MakeVMSName_119     f6 MakeVMSName_120 
    w6 MakeVMSName_121     6 MakeVMSName_122 
    6 MakeVMSName_123     6 MakeVMSName_124 +    7 MakeVMSName_125     &7 MakeVMSName_126     <7 MakeVMSName_127     d7 MakeVMSName_128 
    p7 MakeVMSName_129 7 MakeVMSName_130     9    [   
   7 MakeVMSName_131 7 MakeVMSName_132 7 MakeVMSName_133 8 MakeVMSName_134     8 MakeVMSName_135         8 MakeVMSName_136 *8 MakeVMSName_137 N8 MakeVMSName_138     ;    I    t    h8 MakeVMSName_139 v8 MakeVMSName_140     #        8 MakeVMSName_141     8 MakeVMSName_142 8 MakeVMSName_143 8 MakeVMSName_144 8 MakeVMSName_145         8 MakeVMSName_146 8 MakeVMSName_147         %    7    8 MakeVMSName_148 9 MakeVMSName_149 .9 MakeVMSName_150     0    `    M9 MakeVMSName_151 9 MakeVMSName_152 9 MakeVMSName_153     0    l    9 MakeVMSName_154     9 MakeVMSName_155 ,    : MakeVMSName_156        (: VerifyFileNameSize A: VerifyFileNameSize_157 a: VerifyFileNameSize_158     <    }: VerifyFileNameSize_159     x    : VMSMapObjectDataToACE  : VMSMapObjectDataToACE_160      ; VMSMapObjectDataToACE_161 !        @; VMSInitNetWareAce      `; VMSInitPathworksAce ; VMSInitPathworksAce_162     ?    ; VMSInitPropagatingAce 0    ; VMSToDOSTime < VMSToDOSTime_163 < VMSToDOSTime_238 H    I        < VMSIsAtRoot      < 
VMSzeroDID     < 	FlipWords     < VMSCreateMutex = VMSCreateMutex_164 = VMSCreateMutex_239 H    M    l    `= VMSDeleteMutex = VMSDeleteMutex_165 = VMSDeleteMutex_240 H    M    l    = VMSAcquireMutex = VMSAcquireMutex_166 = VMSAcquireMutex_241 H    M    l    8> VMSReleaseMutex W> VMSReleaseMutex_167 W> VMSReleaseMutex_242 H    M    l    > VMSTryAcquireMutex > VMSTryAcquireMutex_168     > VMSTryAcquireMutex_169     > VMSTryAcquireMutex_170 > VMSTryAcquireMutex_243 H    N    |     ? VMSIsStream T? VMSIsStream_171 l? VMSIsStream_172 .    F    ? VMSIsStream_173 ? VMSIsStream_174 ? VMSIsStream_244     ? VMSIsStream_245     I    @ VMSIsStream_175 @ VMSIsStream_246     <@ VMSIsStream_247     I    @ VMSIsStream_248     @ VMSIsStream_176 >    j      A strmatch 0A strmatch_177 ;A strmatch_178 6    yA strmatch_179     V        A ParseProtection A ParseProtection_180 ^B ParseProtection_181 K    B ParseProtection_182 C ParseProtection_183 j              C 	VMSChkPro D 
VMSChkPro_184      AD 
VMSChkPro_185      D 
VMSChkPro_186 D 
VMSChkPro_187 !    B    !E 
VMSChkPro_188 ,E 
VMSChkPro_189     4E 
VMSChkPro_190         @E 
VMSChkPro_191     E 
VMSChkPro_192 E 
VMSChkPro_193         E 
VMSChkPro_194 E 
VMSChkPro_195 E 
VMSChkPro_196 E 
VMSChkPro_197     /    8    E 
VMSChkPro_198     t    $F 
VMSChkPro_249 O       xF VMSShouldBeChecked F VMSShouldBeChecked_199 "    F VMSShouldBeChecked_200         G VMSResourceACECheck 4G VMSResourceACECheck_201 SG VMSResourceACECheck_202     '    G VMSResourceACECheck_203 G VMSRes                                                                                                                                                                                                                                                                           K $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              E "     g      ourceACECheck_204     '        G vmsalloc     G 
vmsrealloc     G vmsfree G vmsfree_205         G 
CleanupMemory     H VMSClearProtection H VMSClearProtection_206 H VMSClearProtection_250 H VMSClearProtection_1 !    ^    H VMSClearProtection_251 6    6I VMSClearProtection_207     KI VMSClearProtection_208 
        U   \I ClusterControlLock I ClusterControlLock_209 $J ClusterControlLock_210        n   J GetFileServerNameLock  WK GetFileServerNameLock_211  jK GetFileServerNameLock_212 &    9     K GetFileServerNameLock_213 &     K GetFileServerNameLock_214 &    5   L 
StringToInt16 C    HL VMSShowProcessInfo M VMSShowProcessInfo_215  M VMSShowProcessInfo_216 1M VMSShowProcessInfo_217 	        0       N 
TestDiskQuota O TestDiskQuota_218         O translate_log_boolean     dP translate_log_int "   		$;                              	                                                                           
                              	                                                                                                                                                                                                                               ) 
 
     	     	              		                                             O5 = ,                   ӹ      
      	 
    FSHOST P 	PGETINT32 <    P FSIHostOpen O    Q FSIHostRead J    `Q FSIHostWrite J    Q FSIHostClose    		P =        VMSLISTHANDLER Q VMSSetUpList T    R VMSResetList @R VMSResetList_1     7    LR VMSDestroyList hR VMSDestroyList_2 lR VMSDestroyList_3         |R VMSDestroyList_4 
    D    R VMSAddToList R VMSAddToList_5 R VMSAddToList_6 1    G        HS VMSAddToListPtr fS VMSAddToListPtr_7 kS VMSAddToListPtr_8 1    G        S VMSSetListToBegin     S VMSSetListToEnd     T VMSNextFromList ,T VMSNextFromList_9     GT VMSNextFromList_10     `T VMSNextFromList_11 
    lT VMSNextFromList_12 
    T VMSNextFromList_13     T VMSNextFromList_14 T VMSNextFromList_15     6        T VMSNextFromListPtr U VMSNextFromListPtr_16     +U VMSNextFromListPtr_17     DU VMSNextFromListPtr_18 
    PU VMSNextFromListPtr_19 
    dU VMSNextFromListPtr_20     U VMSNextFromListPtr_21 U VMSNextFromListPtr_22     6        U VMSPrevFromList U VMSPrevFromList_23     V VMSPrevFromList_24     4V VMSPrevFromList_25     `V VMSPrevFromList_26 |V VMSPrevFromList_27 )    E        V VMSPrevFromListPtr V VMSPrevFromListPtr_28     W VMSPrevFromListPtr_29     $W VMSPrevFromListPtr_30     PW VMSPrevFromListPtr_31 lW VMSPrevFromListPtr_32 )    E        W VMSListCount     W VMSListTotalDataSize $    W VMSListCopy X VMSListCopy_63     l    LX 
VMSDeleteItem X VMSDeleteItem_33     _    X VMSListSearchPtr X VMSListSearchPtr_34     X VMSListSearchPtr_35 Y VMSListSearchPtr_36     d    PY VMSListSearchPtr_37 XY VMSListSearchPtr_38 ]Y VMSListSearchPtr_39     tY VMSListSearchPtr_40 |Y VMSListSearchPtr_41 Y VMSListSearchPtr_42 *    R    e            Y VMSListSearchPtr_43 Z VMSListSearchPtr_44 	Z VMSListSearchPtr_45      Z VMSListSearchPtr_46 (Z VMSListSearchPtr_47 AZ VMSListSearchPtr_48 *    \    o                Z VMSListSearchStringPtr  Z VMSListSearchStringPtr_49  Z VMSListSearchStringPtr_50 
     Z VMSListSearchStringPtr_51  Z VMSListSearchStringPtr_52  [ VMSListSearchStringPtr_53 
    ;    N    z       # \[ VMSFindListEntryLargestLEPtr& [ VMSFindListEntryLargestLEPtr_54& [ VMSFindListEntryLargestLEPtr_55    & [ VMSFindListEntryLargestLEPtr_56    & [ VMSFindListEntryLargestLEPtr_57& [ VMSFindListEntryLargestLEPtr_58 	   & [ VMSFindListEntryLargestLEPtr_59     +    |   & \ VMSFindListEntryLargestLEPtr_60& +\ VMSFindListEntryLargestLEPtr_61 
   & 8\ VMSFindListEntryLargestLEPtr_62     C       		Q  	                                                                          	 	                                 	        # 
                            GETPWVNLOCK \\ GetPWVNLock \ 
GetPWVNLock_1     \ 
GetPWVNLock_2        		\\ ,    	       
VMSPROCESS l] VMSGetSetPName ] VMSGetSetPName_1 <        ^ VMSGetPIDByName [    d^ VMSGetPState D    ^ VMSStopProcess     ^ VMSStopProcByName ^ VMSStopProcByName_20 W    !_ VMSStopProcByName_21     t    0_ VMSCreateDetProc (` VMSCreateDetProc_2     C` VMSCreateDetProc_3     ` VMSCreateDetProc_4 ` VMSCreateDetProc_5 ` VMSCreateDetProc_6 ` VMSCreateDetProc_7         -    5        a 
VMSCheckPrivs !a VMSCheckPrivs_8 8a VMSCheckPrivs_9     wa VMSCheckPrivs_10     a VMSCheckPrivs_11     |    a VMSCheckPrivs_12     a VMSCheckPrivs_13     a VMSCheckPrivs_14     b VMSCheckPrivs_15        b printMissingPrivs Pb printMissingPrivs_16                                                                                                                                                                                                                                                                            I $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                               "     x       cb printMissingPrivs_17     $    b printMissingPrivs_18 b printMissingPrivs_19     $       		
l]    
           )	          =      SHUTDOWN_MBX b 	CreateMBX 0c CreateMBX_1     Uc CreateMBX_2 Uc CreateMBX_18 gc CreateMBX_9     jc CreateMBX_10              rc CreateMBX_3 rc CreateMBX_19 c CreateMBX_9     c CreateMBX_10              c CreateMBX_4 c CreateMBX_20 c CreateMBX_9     c CreateMBX_10              c CreateMBX_5 c CreateMBX_21 c CreateMBX_9     c CreateMBX_10                 c OpenMBX &d 	OpenMBX_6     jd 	OpenMBX_7     pd 	OpenMBX_8         td CloseMBX d 
CloseMBX_9     d CloseMBX_10         d WriteShutdownMBX d WriteShutdownMBX_22     d WriteShutdownMBX_11     d WriteShutdownMBX_12     d WriteShutdownMBX_13     d    d ReadShutdownMBX e ReadShutdownMBX_14 .e ReadShutdownMBX_15     6e ReadShutdownMBX_16     ;e ReadShutdownMBX_23     me ReadShutdownMBX_17     g    {    te 
GetMBXMessage "   		Y	b      	       	       
     FTSTCHK e 
check_ft_date e check_ft_date_1 f check_ft_date_2     -f check_ft_date_3 %    `f check_ft_date_4 %    f check_ft_date_5         f check_ft_date_6       		e 9 	              DIAG_VM f 	PGETINT32 <    f diag_malloc g diag_malloc_15 *g 
diag_malloc_1     Pg 
diag_malloc_2 ,    {        g diag_calloc '    g diag_realloc '    g 	diag_free !    g ML_Mem_Alloc h ML_Mem_Alloc_1     Gh ML_Mem_Alloc_2 +        xh 
ML_Mem_CAlloc }h ML_Mem_CAlloc_16 h ML_Mem_CAlloc_1     h ML_Mem_CAlloc_2 ,    x        i ML_Mem_Free i 
ML_Mem_Free_3 "i 
ML_Mem_Free_4     @i 
ML_Mem_Free_5     di 
ML_Mem_Free_6     i 
ML_Mem_Free_7         i 
ML_Mem_Free_8          j ML_Mem_Realloc j ML_Mem_Realloc_9 j ML_Mem_Realloc_10     9j ML_Mem_Realloc_11     ^j ML_Mem_Realloc_12     j ML_Mem_Realloc_13         j ML_Mem_Realloc_17 j ML_Mem_Realloc_1     j ML_Mem_Realloc_2 ,    t    rk ML_Mem_Realloc_14       		f       h   % &        '            
SIGNALDUMP k SignalDumpInit  l SignalDumpInit_1 	    cl SignalDumpInit_2 	        pl SignalDumpFini     l SignalDumpInvokeDump    		k 6         PROC_STATUS l GetPIDfromProcCode l GetPIDfromProcCode_1     l GetPIDfromProcCode_2     0    l CheckProcState m CheckProcState_3     m CheckProcState_4     9    $m GetStartupLock Dm GetStartupLock_5     Hm GetStartupLock_6 
    .    Tm GetRunningOkayLock tm GetRunningOkayLock_7     xm GetRunningOkayLock_8 
    .    m VisibleWaitBegin m VisibleWaitBegin_9     m VisibleWaitBegin_10     m VisibleWaitBegin_11     _    m VisibleWaitEnd m VisibleWaitEnd_12 
        n VisibleWait n VisibleWait_13 Rn VisibleWait_14 &    k        n WaitForStartupLock n WaitForStartupLock_15     n WaitForStartupLock_42 n WaitForStartupLock_9      n WaitForStartupLock_10 
    n WaitForStartupLock_11     I    o WaitForStartupLock_16 %o WaitForStartupLock_17 %o WaitForStartupLock_43 )o WaitForStartupLock_12 
            7o WaitForStartupLock_44 ;o WaitForStartupLock_13 ro WaitForStartupLock_14 &    k    o        o WaitForStartupLock_45 o WaitForStartupLock_12 
        G   o WaitForRunningOkayLock  o WaitForRunningOkayLock_18      p WaitForRunningOkayLock_19      p WaitForRunningOkayLock_46 Gp WaitForRunningOkayLock_9       Mp WaitForRunningOkayLock_10 
     \p WaitForRunningOkayLock_11     H     ^p WaitForRunningOkayLock_20  kp WaitForRunningOkayLock_21  kp WaitForRunningOkayLock_47  op WaitForRunningOkayLock_12 
             p WaitForRunningOkayLock_22  p WaitForRunningOkayLock_48  p WaitForRunningOkayLock_12 
             p WaitForRunningOkayLock_49  p WaitForRunningOkayLock_13  p WaitForRunningOkayLock_14 &    k    o         q WaitForRunningOkayLock_50  q WaitForRunningOkayLock_12           F   q WaitForShutdown Aq WaitForShutdown_23     Eq WaitForShutdown_51 vq WaitForShutdown_9      |q WaitForShutdown_10 
    q WaitForShutdown_11     I    q WaitForShutdown_24 q WaitForShutdown_25 q WaitForShutdown_52 q WaitForShutdown_12 
            q WaitForShutdown_53 q WaitForShutdown_13 r WaitForShutdown_14 &    k    o        Rr WaitForShutdown_54 Vr WaitForShutdown_12 
        K   dr 	GetNodeId r GetNodeId_26     Q    r GetLockName r GetLockName_27     r GetLockName_55 s GetLockName_26     D    9s GetLockName_28         ds GetLockW s GetLockW_29     d    s GetLock s 
GetLock_30     d    ,t GrabLockForever 4t GrabLockForever_56 ft GrabLockForever_29     l    t GrabLockForever_31     t GrabLockForever_32         t 	CheckLock t CheckLock_57 t CheckLock_29     l    Eu CheckLock_33     Wu CheckLock_34         \u 	GetLockID au GetLockID_58 u GetLockID_30     k    u GetLockID_35 
    u GetLockID_36         u GetPIDfromLock :v GetPIDfromLock_37     Bv GetPIDfromLock_38 Hv GetPIDfromLock_39         \v GetPIDfromLock_40 |v GetPIDfromLock_41     C       		{l                         
      	  	                        , 	         VMS_SPECIFIC v GetCurrentTime <    v 	RealSleep (w RealSleep_1     Y    8w 
RealSleep_ast    		v 4      MTS$MAIN Pw main      pw starter_thread @   		Pw      DIGITAL_COPYRIGHT    PWVN_FAKE_VM w pwvn$fake_vm rx pwvn$fake_vm_1        		w ;           FAKE_VM ty AST_REENABLE	ty 	 	  y   	    y       ?    > 
LOAD_IMAGE y EXIT_VEC_GET_VM	y 	 
 
    y EXIT_VEC_FREE_VM	y 	 
 
    y EXIT_VEC_SGET1_DD	y 	 
 
    y EXIT_VEC_SFREE1_DD	y 	 
 
    y EXIT_VEC_SFREEN_DD	y 	 
 
    y EXIT_VEC_GET_EF	y 	 
 
    y EXIT_VEC_FREE_EF	y 	 
 
    y EXIT_VEC_LIB_MALLOC	y 	 
 
    z EXIT_VEC_LIB_CALLOC	z 	 
 
    
z EXIT_VEC_LIB_REALLOC	
z 	 
 
    z EXIT_VEC_LIB_FREE	z 	 
 
    !z EXIT_VEC_DECC_MALLOC	!z 	 
 
    +z EXIT_VEC_DECC_CALLOC	+z 	 
 
    5z EXIT_VEC_DECC_REALLOC	5z 	 
 
    ?z EXIT_VEC_DECC_FREE	?z 	 
 
    Iz EXIT_VEC_DECC_CFREE	Iz 	 
 
    Sz EXIT_VEC_DECC_MALLOC_OPT	Sz 	 
 
    ]z EXIT_VEC_DECC_CALLOC_OPT	]z 	 
 
     gz EXIT_VEC_DECC_REALLOC_OPT	gz 	 
 
    qz EXIT_VEC_DECC_FREE_OPT	qz                                                                                                                                                                                                                                                                           z $      PWRKV50F1050.F                 \ n [NW.KIT.EXE]PWVN$NETWARE.EXE;1                                                                                                                              3\ "            	 
 
    {z EXIT_VEC_DECC_CFREE_OPT	{z 	 
 
    z EXIT_VEC_MALLOC	z 	 
 
    z EXIT_VEC_CALLOC	z 	 
 
    z EXIT_VEC_REALLOC	z 	 
 
    z 
EXIT_VEC_FREE	z 	 
 
    z EXIT_VEC_CFREE	z 	 
 
    z EXIT_VEC_MALLOC_OPT	z 	 
 
    z EXIT_VEC_CALLOC_OPT	z 	 
 
    z EXIT_VEC_REALLOC_OPT	z 	 
 
    z EXIT_VEC_FREE_OPT	z 	 
 
    z EXIT_VEC_CFREE_OPT	z 	 
 
    z EXIT_VEC_XMEMORY_MALLOC	z 	 
 
    z EXIT_VEC_XMEMORY_CALLOC	z 	 
 
    z EXIT_VEC_XMEMORY_REALLOC	z 	 
 
    { EXIT_VEC_XMEMORY_FREE	{ 	 
 
    { EXIT_VEC_XTMALLOC	{ 	 
 
    { EXIT_VEC_XTCALLOC	{ 	 
 
    %{ EXIT_VEC_XTREALLOC	%{ 	 
 
    /{ EXIT_VEC_XTFREE	/{ 	 
 
    Y~ 	REAL_ADDR 
| CHECK_VALID_XFER	
| 	7 
     L} 	FIND_ADDR | FIND_IMAGE_SYMBOL	| 	Z  !   	L} 	T%  v   	Y~ 	H     	> 	 ,	 	 	 	 	 	 	$ 	# 	" 	! 
	, 	+ 	* 	) 	3 	2 	1 	0 	: 	9 	8 	7 
	B 	A 	@ 	? 	I 	H 	G 	F 
	Q 	P 	O 	N 	X 	W 	V 	U 	_ 	^ 	] 	\ 	f 	e 	d 	c 	s 	r 	q 	p 	o 	n 	x 	w 	v 	u 	 	~ 	} 	| 	 	 	 	 	 	 	 	 
	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 
	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 		 	 	 	 	 	 	 	
 ǹ	 	 	 	 	 	 	 	 	 	 	- 	, 	+ 	* 	) 	( 	2 	1 	0 	/ 	9 	8 	7 	6 	@ 	? 	> 	=      
SET_INTERCEPT	 	I 	R 	Q 	P 	W 	V 	U 	` 	_ 	^ 	e 	d 	c 	j 	i 	h 	t 	s 	r 	y 	x 	w 
	 	 	~ 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	  	 	 	% 	$ 	# 	* 	) 	( 	/ 	. 	- 	S 	R 	Q 	X 	W 	V 	] 	\ 	[ 	b 	a 	`     ,       ,      $  FAKE_VM_INTERCEPT_EXIT_VECTOR  EXIT_INTERCEPT	 	n0  V   V                            	 	k 7" x   $  FAKE_VM_INTERCEPT_XFER_VECTOR  XFER_INTERCEPT	 	/  U   U                            	 	 6" x    ' CHECK_ACTIVE_LIST	' 	 =  x     FIND_IN_ACTIVE_LIST	 	C=      ; LOAD_FAB_RAB	; 	 	 L   8           _    C FAKE_VM	C 	 $ ?   Ô FAKE_VM_REPORT	Ô 	[ " R   ǘ FAKE_VM_HISTOGRAM l DO_HISTOGRAM	l 	Q	 	
       	                      ٖ   ٖ   	        &   +   O   O           n   n   	        O                      җ                         	        d      	ǘ 	N	= $ 5   g FAKE_VM_EFN	g 	M
l 	u
 	
 			
 $ $       v   D      
  DO_LOG	 	
"  <   <   
    
    I   I   	        i   i                 	              	            ɜ 
CALL_DEBUG	ɜ 	
                   
           j     ADD_TO_HISTOGRAM	 	
L 	                           FAKE_VM_GET_VM	 	P 	 
" С           FAKE_VM_FREE_VM	 	[ 	 C	 " ,          2 FAKE_VM_SGET1_DD	2 	
L 	"      FAKE_VM_SFREE1_DD	 	
; "      FAKE_VM_SFREEN_DD	 	9+ 		P "            Э FAKE_VM_GET_EF	Э 	b0 
"      FAKE_VM_FREE_EF	 	2 	"      FAKE_VM_MALLOC	 	% 
"      FAKE_VM_CALLOC	 	9 "     ` FAKE_VM_REALLOC	` 	& /	Z 	
"            FAKE_VM_FREE	 	/ "     ; FAKE_VM_DUMMY_FREE	; 	%      @ FAKE_VM_MALLOC_OPT	@ 	'      H FAKE_VM_CALLOC_OPT	H 	)      P FAKE_VM_REALLOC_OPT	P 	+      X FAKE_VM_FREE_OPT	X 	-      ` FAKE_VM_DUMMY_FREE_OPT	` 	/      e FAKE_VM_XMEMORY_MALLOC	e 	1      m FAKE_VM_XMEMORY_CALLOC	m 	3      u FAKE_VM_XMEMORY_REALLOC	u 	5      } FAKE_VM_XMEMORY_FREE	} 	7     !  FAKE_VM_XMEMORY_DUMMY_FREE	 	9       FAKE_VM_LIB_MALLOC	 	;       FAKE_VM_LIB_CALLOC	 	=       FAKE_VM_LIB_REALLOC	 	?       FAKE_VM_LIB_FREE	 	A              FAKE_VM_LIB_DUMMY_FREE	 	L        
_FAKE_VM_DATA    x 
_FAKE_VM_CODE'>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ü $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NSSP.EXE;1                                                                                                         2                         s               * [NW.KIT.EXE]PWVN$NSSP.EXE;1 +  , q  . 2    /     4     2   +                     - n  0   1    2   3      K   P   W   O 3    5   6 @|-_D  7 @mD  8          9          G    H  J                       0 D `     0205        0-_D     J  h2                                        	PWVN$NSSP                              	V1.0-611F       0-_D 05-13                                 	                               %   
       ?   &      !         PWVN$NWAPISHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001'      !         PWRK$XTILIBSHR_001(      !       PWRK$STREAMSSHR_001#      !         PWRK$CSSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001'      !         PWRK$CMTLIBSHR_001       !        VAXCRTL_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        '  E  "  ("  "  #  y$  "%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         '     '     '     '      '  @   '     '     '     '     '     '     '      '   @  (     
(     (     (     #(     ,(      ?(     Q(     Z(     c(     k(      s(  @   {(     (     (     (     (     (      (   @  (     (                                                                                                                                                                                                                                                                          @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               FATAL: In state %d, expected state %d
 Cleanup Cleanup()
 NWDetachFromServerPlatform %s: calling %s
 NWDetachFromServerPlatform %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 NWCloseTransport %s: calling %s
 NWCloseTransport %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 WARN: Unexpected state %d
 smbOpen smbOpen(queue=%s)
   Will process from VMS queue %s
 ERROR: no queue mapping for queue %s NetWare Symbiont Server Process (PWVN$NSSP) shut down
   Will send jobs to NetWare print server %s queue %s
 NWOpenTransport %s: calling %s
 NWOpenTransport %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 NWAttachToServerPlatform %s: calling %s
 NWAttachToServerPlatform %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 NWLoginToServerPlatform %s: calling %s
 NWLoginToServerPlatform %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 NWGetObjectID %s: calling %s
 NWGetObjectID %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 ERROR: Unknown NetWare queue name %s
 smbClose smbClose(shutdown=%d)
 smbWrite smbWrite(bytes=%d)
 NWWriteFile %s: calling %s
 NWWriteFile %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 smbWriteOutOfBand smbWriteOutOfBand(bytes=%d)
 INFO: Out of band write of %d characters ignored
 <%02X> INFO: >>> %s
 smbJobSetup smbJobSetup(node=%s, user=%s, job=%d, jname=%s
 %s::%s job %d; %s  OpenVMS User LST:  NWCvtPrintStructToQueueStruct %s: calling %s
 NWCvtPrintStructToQueueStruct %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 NWCreateQueueFile %s: calling %s
 NWCreateQueueFile %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 smbJobCompletion smbJobCompletion()
 NWCloseFileAndStartQueueJob %s: calling %s
 NWCloseFileAndStartQueueJob %s: %s returned NW SUCCESS %s: %s returned NW error 0x%08X
 main NetWare Symbiont Server Process (PWVN$NSSP) starting...
 PWVN$NSSP_DEBUG_FLAGS Debug Flags = 0x%08X
 PWVN$NSSP_%08X_MBX MsgOpenChannel %s: calling %s
 MsgOpenChannel %s: %s returned VMS success %s: %s returned VMS error 0x%08X
 WARN: Unexpected message type %d
 MsgCloseChannel %s: calling %s
 MsgCloseChannel %s: %s returned VMS success %s: %s returned VMS error 0x%08X
 NetWare Symbiont Server Process (PWVN$NSSP) shut down
 EXIT status = %08X
   FATAL: message handle is NULL
  PWVN$CONF_DIR:PWVN$NWPRINT.CFG r PWVN$CONF_DIR:PWVN$NWPRINT.CFG VMS queue name NetWare server name NetWare queue name NetWare user name aligning idle operator request paused pausing remote resetting resuming server stalled starting stopped stopping unavailable closed busy available disabled autostart inactive stop pending , %s Aborting Printing Holding Refused Requeue Restarting Retained Starting Holding after Suspended Pending Stalled Incomplete Completing %s  Printer queue %.*s , on %.*s::, mounted form %.*s
 
  Entry  Jobname         Username     Blocks  Status
   -----  -------         --------     ------  ------
 no privilege   %5d  %-15.*s %-12.*s %6d   
 
 SYS$OUTPUT: Log file closed
 a NetWare Print Server
WARNING - Log file %s in use
 %s %s %s %s w Log file %s opened
 %s built on %s
 PATHWORKS V1.0-611F for OpenVMS (NetWare) 04/05/98  ^RѬݬ    Y   < ^eS^Rb
ߣ/w  ТPP   . .   1 ?P < ~ݢ<~  ޣ:T bߣeߣU(  <~a  PU b+TÀ     TÛ   ü T b       PU b?T   ,Pn  T	  Pݢ*~    P^AT.  X3ScЬPMD  RգRݣd/     գUЬR`  Ueð  PWPĂeħe,Pøô  R c4$     PV c)RD  PhR_y  V< ~ĀR cĩęJ  ?ôp  PV c&R"  hR
  V< ~gR c&  ü<~  PV c'R>  hRY  V< ~zR cĘĈj  ߣø<~  PV c(RĦ<  PhR%  V+h  ø	  ,j< ~_2 P ^TScЬPݠ  ЬPՠ#գRRݣd   [  P< ^]TVRbЬPݠ1g  ѢSSݢdF     ES baQ#  ЬPݠߢ <~3  PU b-Sm  P  SĈ  U< ~+2 Pδ^Ux  WxЬRݢŻ  ެXhRТRRP   	PTPRTTVR]  ͻSRVZ  TBPPQQPPP@gPhPQ-Q~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          N $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NSSP.EXE;1                                                                                                         2                          "            
Ͷ  ͶS  Ͷ  PSRRVͻ  2 P< ^TRbЬPݠ+  SSݢd   P  < ~ ° 2  ~ "  ¶ Q   P`PQ  ЬPݠ[    "B$&m(  Scn8c{EcĀ`cāS bįğ    PU b,S  Pf  S  U
~	S b+_  ߢ° ݢ<~r  PU b,S=0  P  SX  U
~pԢP< ^TRbĊ  SSݢd   |  ĞS bĺ  ߢ< ~ݢ<~  PU b,Sp  P2  SU  U
~ϰ 2 P^  VUԥ'  `  PP  Pee
ev     Pƌ  ƟS eƾƮ  ߭Y  PWW e&S  WSu  WWPX1Pݭ  PP i Y )   9 I 1 n?PϷPW1 ;PW1 {PW1 ?PW1 PWpPTTReݢ  բ#եSSݥf   b  PWդXPey  WWݭ>  PWPXX1-S eM=?  ݭ  PYW e&S]  WSy  WYWƛ  e
W  WP     ^լ]   ~   ^|~|~<~ݬ|~1<~  PRP<RRRP ^|~|~<~ݬ|~0<~  PRP<RRPP ^< ԭ|~߭ PSPSPݬ  PЬ|~ < ~ <~?	PSP<~ PSЬRk  Pb<$P޼Pް P`SP ^ЬR_0   Q   R<  ~PSR  SP^ЬR     мPP S K #  [ + ; KPR?P$U@PDU7PЬQPPU'PЬQPPUPUPUPP<UR<TRSЬR|~|~<S~R|~0<T~  PVP<VVWW{ЬSTSRW(   I  <cU>STR|~|~<~R|~1<U~  PXP<XXcXYYWW	WPWWP| ^ЬR     Ь<TSR|~|~<S~R|~0<T~  PUP<UUVVP| ^ЬR{L   m  <U>TЬR|~|~<~R|~1<U~  PSP<SSdSVVP   < ^Sݬ< ~  PP  PRB
Bլ
PTUR  RPRB!BBB B	UUBTB~G  PBRl  RPT^  PRBd Bd	RP@dPRT3  P1TP ^ЬRݬ  PP  Pbݬb   ^
TSߤd  PXߤ!ݏ>  ߭ XϋP1f  U  V  WPePRݏ>s  cPR@ޭЭRRfPPePRݾgխݏ>3  cP@PЭ`߭ XP ݭߤ@ݏ> ݏ>  ޭЭRRfPPePRݾgխݏ>  cP@PЭ߭ XυP ݭߤOݏ> ݏ>  ޭЭRRfPPePRݾgխݏ>J  cP@PЭ߭ XP ݭߤcݏ> ݏ>
  ޭЭRRfPPePRݾgխݏ>  cP@PЭ߭XϛP ݭߤvݏ> ݏ>  ޭnЭRRfPPeP Rݾgխݏ>a  cP@PЭc߭ X%P1X	  Џ	>P ^%W +PSSSPgݏ>  Vg1PFRbݬ
  PFR(bЏ	>PVVgЏ:>P                                                                                                                                                                                                              < ^TSUPxUQAcRҬPPbPAP`ļ   UP< ^QTRUPxUQA  SҬPPcPA¤ P`FM  
U 0^؛|ܰެ||ԼЬRb9  Pb|~߭  8PSPЭSS(SB Џ	>PSݬݏ>    ݏ>  ΰ^kVUYBMD|FNLPޭRVZF\ޭ^>bfGhޭjnrKtޭv>z~ޭ>ޭ|ԭͻLͽޭͿޭ',>Q>.ޭ1ޭ||ЬTd
  PBdF|~|~   PX|~ͳB   PXXͳXXXP߭<~J
  WTxTP@eSWRRcR@RbƼ 	  T߭<~߭<~]	  |~ͳͻ   PXXͳXXXB 1 X 1 XPYY}	  ƴ{	  !	  	  Pܴݭ<~<~3	  TSxSQAŠ RTPPbPAŤ P`F	  
S  1  Џ	>P  ^ެPPS<TT ЬRTRTRPSSQa@ RRT|~  ɏ   P                           d^GS  UT"ޭ>||~ |~  PRPQPPѭPPQQcߤ  ed5Pݬߤ  e  PVe    ЬPP   1?Pͮ"ͰޭͲ>Ͷ|ͺ|~ ͮ|~  PWPQPPѭPPQQߣ_ߤ.  Pd	R(Pߤߣa  ï Å ߣu  RR   1YP͖"͘ޭ͚>͞|ͪ͢|~ ͖|~  PXPQPѭPPQQߣ_ߤ  Pd	R(Pߤߣa  ï Å ߣu  RR   P~"̀ޭ͂>͆|͊͒|~ ~|~  PYPQ
PѭPPQQid  YPf"hޭj>n|rz|~ f|~  PZPQPPѭPPQQPP ^}SRߣ   bf  PP< ^GTSެRR~ݬ%     1  V  PUARPߤߣ  PcRc	  cR<cߣߤmUߤSc  c  Pc  г R
~p  P ^sR  SެPP~ݬQ     PߢYV  cc1  г P
~   $^R^Sް"ޭ>|ԭ|~ ߭|~  PTPQPPѭPPQQߢ_ߣ  PcPߣa H¯  u 3P $^ް"ޭ>|ԭ|~ ߭|~  PRPPRѭRRP  ^  ^ݬW  PRR   RX *~ݬ  RPP QPQQP  ^RPb|~?H<P@b  P ^Џigԭ߭߬+  PR ߭߯0߭  PRP	R	  խ խP  ^|~                                                                                                                                                                                                                                                                                                                                                                         @   @                                                          H  x  (            `           
       
     L   &  $   \   |   L  L     l   <   d           
               l  D      ܨ t	  8
      H   
                 @                                                                       
PWVN$NWAPISHR                                                  LIBRTL                                                         MTHRTL                                                         PWRK$XTILIBSHR                                                 PWRK$STREAMSSHR                                                
PWRK$CSSHR                                                     	SECURESHR                                                      
SECURESHRP                                                     PWRK$CMTLIBSHR                                                 VAXCRTL                                      H     
   H  H                              NSSP `*  StateAssert 0    *  Cleanup *  	Cleanup_1 +  	Cleanup_2 +  	Cleanup_3     1    e+  	Cleanup_4 g+  	Cleanup_5     2        $   +  smbOpen +  
smbOpen_40     ,  	smbOpen_6 2,  	smbOpen_7     U    ,  	smbOpen_8 ,  	smbOpen_9     /    ,  
smbOpen_10 ,  
smbOpen_11     ,    b-  
smbOpen_12 d-  
smbOpen_13     -    -  
smbOpen_14 -  
smbOpen_15     .    .  
smbOpen_16 .  
smbOpen_17     +       8.  smbClose o.  smbClose_41     ]    .  smbWrite .  smbWrite_42     $/  smbWrite_18 &/  smbWrite_19     3        l/  smbWriteOutOfBand /  smbWriteOutOfBand_20 /  smbWriteOutOfBand_21 -    M        H0  smbJobSetup z0  smbJobSetup_43     m1  smbJobSetup_22 o1  smbJobSetup_23     2    1  smbJobSetup_24 1  smbJobSetup_25     2       ,2  smbJobCompletion N2  smbJobCompletion_44     2  smbJobComple                                                                                                                                                                                                                                                                           6LJ0 $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NSSP.EXE;1                                                                                                         2                         (       "       tion_26 2  smbJobCompletion_27     2        2  main 3  main_28 3  main_29     -    3  main_30 3  main_31 3  main_32     4  main_33     4  main_34     $4  main_35     44  main_36     D4  main_37 I4  main_45 h4  main_46     D    U           4  main_38 4  main_39     -    ]  		`*                           ! & 	                      
    MSG L5  VerifyHandle V5  VerifyHandle_1         l5  MbxRead ;    5  MbxWrite 2    5  MsgOpenChannel     x6  MsgCloseChannel }6  MsgCloseChannel_7 6  MsgCloseChannel_1         @    6  MsgSend 6  	MsgSend_8 6  	MsgSend_1         6  	MsgSend_2 7  	MsgSend_3     7  	MsgSend_4     G    H7  	MsgSend_9 2    }7  	MsgSend_5 }7  
MsgSend_10 7  
MsgSend_11 7  	MsgSend_1         7  
MsgSend_12 <    d    7  	MsgSend_6     {    D   7  
MsgSendStatus 8  MsgSendStatus_13 8  MsgSendStatus_1         (8  MsgSendStatus_14 0    `    \8  
MsgReceive a8  
MsgReceive_15 g8  MsgReceive_1         8  
MsgReceive_16 :    a   		dL5  Ĺ   	
                       ADMIN 8  	ParseLine 8  ParseLine_1 9  ParseLine_2 
    ,9  ParseLine_3 49  ParseLine_4     P9  ParseLine_5     ?    9  ParseLine_6 9  ParseLine_7 	        9  ParseLine_8            
 9  StrDup 0    9  ParseConfigurationFile T:  ParseConfigurationFile_9  v:  ParseConfigurationFile_11 #     :  ParseConfigurationFile_12 #     _;  ParseConfigurationFile_13 #     ;  ParseConfigurationFile_14 #     I<  ParseConfigurationFile_15 "    ;      <  AdmGetQueueRecord =  AdmGetQueueRecord_10     n   		8                 #        CLIENT-VMSUTIL =  
DoQueueStatus A    4>  DoJobStatus D    x>  UtilVMSDeleteJob >  UtilVMSDeleteJob_1 (        ?  UtilVMSShowQueue @  UtilVMSShowQueue_6 .    @  UtilVMSShowQueue_2 
A  UtilVMSShowQueue_3     -A  UtilVMSShowQueue_4     JA  UtilVMSShowQueue_5 !    A  UtilVMSShowQueue_7 1           A  	PrintPWVN Y   		=      			                MESSAGE_LOGGER TB  
MsgInitialize pB  MsgInitialize_16 M    B  MsgInitialize_1     B  MsgInitialize_2 B  MsgInitialize_3     3    "C  MsgInitialize_4 $C  MsgInitialize_17 $C  MsgInitialize_18 M    uC  MsgInitialize_15         C  MsgInitialize_19 C  MsgInitialize_20 K    D  MsgInitialize_15         cD  MsgInitialize_21 J    D  MsgInitialize_5     D  MsgInitialize_22 M           E  MsgClose 9E  
MsgClose_6     1    TE  	MsgInform E  MsgInform_7     E  MsgInform_8 E  MsgInform_9 E  MsgInform_10     E  MsgInform_11     A     F  MsgInform_12 	    F  MsgInform_13             (F  	MsgPrintf nF  MsgPrintf_14     _    F  
CreateFile F  
CreateFile_23 F    F  
CreateFile_15         $G  Interactive H   		~
TB                                              OPMSG lG  
set_optype     |G  
send_opcom w   		lG  !      VMS_SPECIFIC G  GetCurrentTime <    0H  	RealSleep |H  RealSleep_1     Y    H  
RealSleep_ast    		G  4      DIGITAL_COPYRIGHT                                   ! * [NW.KIT.EXE]PWVN$NSSP_START.COM;1 +  , q  . 2    /     4 O   2    |                    - n  0   1    2   3      K   P   W   O 3    5   6 %  7 mD  8          9          G    H  J               O $! Copyright  Digital Equipment Corporation, 1995, 1996.  All rights reserved.  $! $ mcr PWVN$BANNER  $ mcr PWVN$NSSP                                                                                                                                                                                                                                                                                                                                                                                                                  * [NW.KIT.EXE]PWVN$NVTD.EXE;1 +  , q  . d    /     4     d   Y                     - n  0   1    2   3      K   P   W   O e    5   6  
L`D  7  
,mD  8          9          G    H  J                      0 D `     0205        K`D      h             <                         	PWVN$NVTD                              	V1.0-611F      `zK`D 05-13                                                     
              	                  
           /            O  
  :     ?   '      !         PWRK$XTILIBSHR_001      !        
LIBRTL_001 O    !       
MTHRTL_001#      !         PWRK$CSSHR_001'      !         PWRK$CMTLIBSHR_001"      !        
SECURESHR_001#      !       SECURESHRP_001       !        VAXCRTL_001)      +        PTD$SERVICES_SHR_001  Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            U    U    U    U    U    U    U    U    V    
V    V    &V    2V    8V    FV    WV    gV    oV    {V    V    V    V    V    V    V    V    V    V    V    W    W "   'W "   -W "   :W     FW     JW     UW !   bW !   tW !   W #   W #   W $   W $   W %   W &   W &   W &   W &   	X &   X '   5X '   KX '   \X '   pX (   X (   X (   X (   X )   X )   X *   X *   X +   X +   	Y ,   Y ,    Y -   $Y -   -Y -   6Y 2   :Y 2   CY 3   KY 3   XY 4   eY 5   rY 5   Y 5   Y 5   Y 6   Y .   Y .   Y .   Y /   Y 0   Y 1   Y 7   Y 8   Z 9   Z :   (Z ;   6Z <   DZ =   RZ >   `Z ?   nZ @   |Z A   Z B   Z C   Z D   Z E   Z F   Z G   Z H   Z I    [ J   [ K   [ L   *[ M   8[ N   F[ O   T[ P   b[ Q   p[ R   [ S   [ T   [ U   [ V   [ W   [ X   [ Y   [ Z   \ [   \ \   )\ ]   <\ ^   O\ _   b\ `   u\ a   \ b   \ c   \ d   \ e   \ f   \ g    ] h   
] i   ] j   '] k   4] l   A] m   N] n   [] o   h] p   u] q   ] r   ] s   ] t   ] u   ] v   ] w                                                                                                                                                                                                                                                                                                                                                                                         (G_ $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NVTD.EXE;1                                                                                                         d                         oP "            
               	                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (a    l8                    8  8      E                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               InitialThread pwvn$nvt Failed obtaining startup process lock
 Initialization Failure: threadcreate ( InitialThread )
 NVT_MAILBOX: LIB$GETJPI failed, VMSstatus[0x%08X]
 NVT DAEMON is starting....PID[0x%08X]
 PWVN$NVT_USERS NVT is configured for max of 0 users!! Exiting...
 NVT has been configured for a max of %d users

 SYS$DCLEXH failed, VMSstatus[0x%08X]
 SYS$CREMBX failed, VMSstatus[0x%08X]
 SYS$GETDVIW (MBX_UNIT) failed, VMSstatus[0x%08X]
 pwvn$nvt Failed obtaining RunningOkay process lock. Exiting..
 %c%c
	NVT SHUTTING DOWN IN *0* SECONDS 
 NVT Daemon Shutdown initiated...executing ExitHandler
 SYS$DASSGN: Error deassigning CtrlMBX channel, VMSstatus[0x%08X]
 T_OPTMGMT (writefd) failed Device[%d], T_ERRNO[%d]
 T_SND (Shutdown) failed Device[%d], T_ERRNO[%d]
 T_SNDDIS (Shutdown) failed Device[%d], T_ERRNO[%d]
 SYS$DELPRC failed Device[%d] PID[0x%08X] VMSstatus[0x%08X]
 NVT Daemon ExitHandler done.
 PTD$CANCEL failed Device[%d], VMSstatus[0x%08X]
 PTD$DELETE failed Device[%d], VMSstatus[0x%08X]
 SYS$DELTVA failed Device[%d], VMSstatus[0x%08X]
 T_CLOSE (readfd) failed Device[%d], T_ERRNO[%d]
 SYS$SETSFM(disable) failed, VMSstatus[0x%08X]
 SYS$UNWIND failed, VMSstatus[0x%08X]
 SYS$SETSFM (enable) failed, VMSstatus[0x%08X]
 ControlMbxThread Failed spawning ControlMbxThread
 NvtSAPThread Failed spawning NvtSAPThread
 NvtListenThread Failed spawning NvtListenThread
 SrvrStatsThread Failed spawning SrvrStatsThread
 %s    INTERNAL_NETWORK netbios/streams/ipx T_OPEN (SapFd) failed T_ERRNO[%d]
 T_BIND (SapFD) failed T_ERRNO[%d]
 PWVN$CONF_DIR:PWVN$NPSCONFIG.CFG Failed opening configuration file %s.
 Failed obtaining NvtServerName from NPSConfigFile %s.
 Failed obtaining InternalNetworknumber from NPSConfigFile %s.
 %x Failed got invalid InternalNetworknumber from NPSConfigFile %s.
 T_SNDUDATA (SAP) failed T_ERRNO[%d]
 StringEnumToToken: invalid paramter name %s 
 StringEnumToTokenValue:  paramter %s not found in %s
   Post threadqiow (read CtrlMBX) failed, Status[0x%08X]
 threadqiow (read CtrlMBX) failed, VMSstatus[0x%08X]
 Process termination  PID[0x%08X]

 T_OPTMGMT (writefd) failed Device[%d], T_ERRNO[%d]
 T_SNDDIS (Release_conxn) failed Device[%d], T_ERRNO[%d]
 netbios/streams/spx T_OPEN (nvtlisFd) failed, T_ERRNO[%d]
 T_BIND (nvtlisFd) failed, T_ERRNO[%d]
 T_OPTMGMT (nvtlisFd) failed, T_ERRNO[%d]
 netbios/streams/spx T_OPEN (nvtreadFd) failed, T_ERRNO[%d]
 T_BIND (nvtreadFd) failed, T_ERRNO[%d]
 T_LISTEN failed, T_ERRNO[%d]
 T_ACCEPT failed, T_ERRNO[%d]
 %c
	All remote login ports busy. Try again later.
 NVTMaxLogins[%d] reached, rejecting connect request
 T_SND (Reject_conxn) failed, T_ERRNO[%d]
 T_SNDDIS (Reject_conxn) failed, T_ERRNO[%d]
 T_CLOSE (nvtreadFd[%d]) failed, T_ERRNO[%d]
 CreateProcThread Failed spawning CreateProcThread for dev %d
 SYS$SYSTEM:LOGINOUT.EXE                               PWVN$NVT_%04d SYS$EXPREG failed Device[%d], VMSstatus[0x%08X]
 LIB$INSQTI (buffer_q) failed Device[%d], VMSstatus[0x%08X]
 PTD$CREATE failed Device[%d], VMSstatus[0x%08X]
 SYS$GETDVIW failed Device[%d], VMSstatus[0x%08X]
 _FTA%ld: SET_EVENT_NOTIFICATION (XON) failed Device[%d], VMSstatus[0x%08X]
 SET_EVENT_NOTIFICATION (XOFF) failed Device[%d], VMSstatus[0x%08X]
 SET_EVENT_NOTIFICATION (SET_LINE) failed Device[%d], VMSstatus[0x%08X]
 T_OPTMGMT (readfd) failed Device[%d], T_ERRNO[%d]
 SYS$CREPRC failed Device[%d], VMSstatus[0x%08X]
 Created   PID[0x%08X]  FTA[%s]  Device[%d]

 Post PTD$READ failed Device[%d], VMSstatus[0x%08X]
 T_RCV failed Device[%d], T_ERRNO[%d]
 T_RCV Post PTD$WRITE failed Device[%d], VMSstatus[0x%08X]
 PTD$WRITE failed Device[%d], VMSstatus[0x%08X]
 Deleting(self) CreateProcThread[%X]...Device[%d]

 PTD$READ failed Device[%d], VMSstatus[0x%08X]
 LIB$INSQTI (buffer_q) failed Device[%d], VMSstatus[0x%08X]
 LIB$INSQTI (write_q) failed Device[%d], VMSstatus[0x%08X]
 LIB$REMQHI (buffer_q) failed Device[%d], VMSstatus[0x%08X]
 Post PTD$READ failed Device[%d], VMSstatus[0x%08X]
 PTD$WRITE failed Device[%d], VMSstatus[0x%08X]
 PTD$WRITE failed Device[%d], VMSstatus[0x%08X]
 Fail status (echo) Device[%d], VMSstatus[0x%08X]
 T_SND (echo) failed Device[%d], T_ERRNO[%d]
 T_SND(2) T_SND (XON) failed Device[%d], T_ERRNO[%d]
 T_SND(XON) T_SND (XOFF) failed Device[%d], T_ERRNO[%d]
 T_SND(XOFF) NvtWriteThread Failed spawning NvtWriteThread Device[%d]
 T_OPTMGMT (writefd) failed Device[%d], T_ERRNO[%d]
 LIB$REMQHI (write_q) failed Device[%d], VMSstatus[0x%08X]
 T_SND failed Device[%d], T_ERRNO[%d]
 T_SND NvtWriteThread: Post PTD$READ failed Device[%d], VMSstatus[0x%08X]
 LIB$INSQTI (buffer_q) failed Device[%d], VMSstatus[0x%08X]
 Deleting(self) NvtWriteThread[%X]...Device[%d]

 %c
	System resource allocation failure at SERVER.
	Try again later.
 Aborting established connection Device[%d] 
 T_SND (Abort_conxn) failed Device[%d], T_ERRNO[%d]
 T_SNDDIS (Abort_conxn) failed Device[%d], T_ERRNO[%d]
 SYS$DELPRC failed Device[%d], PID[0x%08X], VMSstatus[0x%08X]
 %s: T_DISCONNECT indication, abort session Device[%d]
 T_RCVDIS failed Device[%d], T_ERRNO[%d]
 T_RCVDIS: Device[%d] connection failed/broken
 T_RCVDIS: Device[%d] client terminated connection
 T_RCVDIS: Device[%d] disconnect reason 0x%X
 SYS$DELPRC failed Device[%d] PID[0x%08X] VMSstatus[0x%08X]
   
			Server Statistics
 
Connections     Recved  Rejected   Accpted  Norm_Term  Aborted  Shutdown
 %20d%10d%10d%10d%10d%10d
 
Network  I/O    #Reads  ByteCount  #Writes  ByteCount
 %20d%10d%10d%10d
 
Terminal I/O    #Reads  ByteCount  #Writes  ByteCount  #Echoes  ByteCount
 %20d%10d%10d%10d%10d%10d

    VOL VOLUME SHM_SIZE SHARED_MEMORY SHM_KEY SHM_ACCESS PRIORITY PRIORITY_LEVEL CONNECTIONS MAX_CONNECTIONS MAX_VOLS MAX_VOLUMES DEBUG DEBUG_OPTIONS FILE_SERVER_NAME NVT_SERVER_NAME FS_NAME SERVER_NAME SERVER NET NETWORK NET_NUMBER NETWORK_NUMBER MAX_PROCESSES MAX_PROCESS MAX_PROCS SPAWN_AHEAD_PROCESSES SPAWN_AHEAD_PROCS CLIENTS_PER_PROCESS CLIENTS_PER_PROC LOGIN_ENABLED LOGIN LOGIN_STATUS TTS_ENABLED TTS TTS_STATUS TTS_LOCATION TTS_BACKOUT_FILES TTS_BACKOUT DIR_CACHE_FLAG DIR_CACHE FILE_CACHE_FLAG FILE_CACHE CACHE_BLOCK_SIZE SALVAGE_UTILITY_FLAG SALVAGE_UTILITY SALVAGE_UTIL_FLAG SALVAGE_FLAG SAVE_DELETED_FILES SALVAGE_UTILITY_LOCATION SALVAGE_UTIL_LOCATION SALVAGE_LOCATION SAVED_FILE_LOCATION CAPTURE_UTILITY_FLAG CAPTURE_UTILITY CAPTURE_UTIL_FLAG CAPTURE_FLAG DEF_GROUP_OWNER HU_GROUP_OWNER DEF_USER_OWNER HU_USER_OWNER HOST_FILE_MASK FILE_MASK HOST_DIR_MASK DIR_MASK SPX SPX_FLAG LOAD_SPX NVT LOAD_NVT NETBIOS NETBIOS_FLAG NETBIOS_SHIM ADAPTER_NAME LAN_ADAPTER_NAME NET_ADAPTER_NAME LAN_CARD_NAME SHIM SAP_FLAG SAP START_SAP SAP_STANDARD_OUT SAP_ERROR_OUT SAP_REPLY_DELAY INTERNAL_NETWORK LA                                                                                                                                                                                                                                                                            $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NVTD.EXE;1                                                                                                         d                          "            N_0_ADAPTER LAN_1_ADAPTER LAN_2_ADAPTER LAN_3_ADAPTER LAN_4_ADAPTER LAN_5_ADAPTER LAN_6_ADAPTER LAN_7_ADAPTER LAN_8_ADAPTER LAN_9_ADAPTER LAN_10_ADAPTER LAN_11_ADAPTER LAN_12_ADAPTER LAN_13_ADAPTER LAN_14_ADAPTER LAN_15_ADAPTER LAN_0_NETWORK LAN_1_NETWORK LAN_2_NETWORK LAN_3_NETWORK LAN_4_NETWORK LAN_5_NETWORK LAN_6_NETWORK LAN_7_NETWORK LAN_8_NETWORK LAN_9_NETWORK LAN_10_NETWORK LAN_11_NETWORK LAN_12_NETWORK LAN_13_NETWORK LAN_14_NETWORK LAN_15_NETWORK LAN_0_ADAPTER_TYPE LAN_1_ADAPTER_TYPE LAN_2_ADAPTER_TYPE LAN_3_ADAPTER_TYPE LAN_4_ADAPTER_TYPE LAN_5_ADAPTER_TYPE LAN_6_ADAPTER_TYPE LAN_7_ADAPTER_TYPE LAN_8_ADAPTER_TYPE LAN_9_ADAPTER_TYPE LAN_10_ADAPTER_TYPE LAN_11_ADAPTER_TYPE LAN_12_ADAPTER_TYPE LAN_13_ADAPTER_TYPE LAN_14_ADAPTER_TYPE LAN_15_ADAPTER_TYPE LAN_0_MODULE LAN_1_MODULE LAN_2_MODULE LAN_3_MODULE LAN_4_MODULE LAN_5_MODULE LAN_6_MODULE LAN_7_MODULE LAN_8_MODULE LAN_9_MODULE LAN_10_MODULE LAN_11_MODULE LAN_12_MODULE LAN_13_MODULE LAN_14_MODULE LAN_15_MODULE   %x %o %d    S U S U    %c S U S S %08x    FSP$Main    MRB  ^R&S
bߢ;4  Pߢ@  @   ݭ|~ ~1   V@  Pcߢ>@  @  ݣ 8@   5@  ^YUT[SVWޥv|~k|~<߭?  PRR\\RŃ   R"@  4ũ    nn@  Pn?  P?  PXXXg J  ?  g4  gfPRRRB  R?  |~<H~T~?C PRR\\Rh  RW?  |~|~ <	~ PRR\\RŎ  R?  2  Pv  >  /Rŏ|   f~ R>  Qf&xQ\LcP`LP`LdP`L\lQQf۞量R@~ R>   F          !>   ^žSNRTPŏ|   d~ PD>  Qd'PxQ\LbP`LP`LcP`L\lQQd۞\@~ \>  d^S0UVYRRRd=  PX*5  <~P
Pa  ԭܞTi1   Wŏ|   TP@e\l1 ԭԭԭПȟ؞@$Rb<  P<  TãgVP Xdb[<  PX<  Tg ŏ|   T\L$\l/<  P-<  Tg ŏ|   T\LeRbPP  
PbT<gT#   ֦TTi1 $  x    ^AVﺼXCWUMTެSŏ|   cP@Rbg2b~Y<  PRRPPRcƖ  Rx;  ެSŏ|   cP@P2`~<  PRRPPRcU  R<;  ެSŏ|   cRBP`.|~BPRRPPRc  R:  ެSŏ|   cP@ Rb%b:  P:  c)  ŏ|   SCTRbCXRbC\Rb C`Rb$CdRb(ChRb,ClRb0CpRb4CtRb8CxRb<CeP|~ P:  xP@gRb@Rb@hRb@RԢ  ^S @PRRRZ  RP|~pPRR\\RÉ  R9  @PRRRï  RP ^RfS ݭ|~ ~  9  Pcv  9    9   ^RRS ݭ|~ ~  F9  Pc  9    %9   ^MRS< ݭ|~ ~  8  PcL   19    8   ^RSm ݭ|~ ~  ~8  Pc}J   8    ]8   ^ݬ8  Pݬ8  P8  PRRRPP ^QR8  S :5  PcK8  ݬݬݬݬݬc38  c68  г P
~8    MRB  0^TUGWVﵷS֜R ߤ7  Pf07  ߤ%N7   7  ԭ|ܞЭ䟭ܟf6  P6  ߤH7   q   բ:eЏ  c c$<"(g0B,fi6  Pw6  m<~6  P ^WrTsVUͶRS~6  R?
6   cGߤkey6  fe6%  PeČ 6  f&  Peĳ Y6  fnnQP@ (P@ a@ z
@ \ \\@ P@ 0f5  3lb  Pe b5   $  g)25  Pe,-5  gPˏ P\x\Qˏ P\x\\\Qˏ P\\\\Qʏ PP\\Qgg4 C5  P8 \l\P=c> @  ^TSRբBЏ  c c$<"("0B,ʴ4  P4  m2< ^$Tݬ߭s4  ޭnnUQA %A aA z
A P PPA QA Rbb߭04  PТS	PRbbݬĒ\4  4  PS P <^R߭ݬGP   ݬ4  3  P߭ݭ\#  P   P 3  P ^QެRA &bSAcaA z
A P PPA QAcMRB H^TTURzWX2  h2  l 2  Pphd\`|~|~T~t1<h~	q2  PPdS\\2~ߤ7;<t\\|VVߤlSgŏ|   S\LbP`V1 THPLTP`YHXL$\l1  P1  Sď %P ly1  Pw1  S ŏ|   S\LDP`1  LHP`1   1  SnL\l֥1SSg121   MRB ^#WבּZXҰ[￰Y\g0  Pii0  ߧj1   PS1  ZRcbP D,1  DiG0  PX0  ߧ;v0  0  .p0  ' h0  PRbSRSb؞ݰԭĞΰ̟ği/  P/  ߧbc0  \ǌ /  P{u/  Ǡ $0  ԭ| P0  P)/  P//   L/  |8 /  䭐ԭԭ|i.  PDP.  	i.  P.   c/  |iz.  PjVkŏ|   VRB RbVVk|ԭ|Pi7.  PY.  v.  Vk1 ֪|T~,.  PSk~a9 S-  P#֭-  P-  ǖTﱭ-  P#-  P-  }~-  P1-  c1֪ŏ|   V\L R>bL$R2b(8LLRЭbVTŏ|   TRBDS |~ ~g  H-  PcT+18P Tc-  1% ^S塞T~,߭S-  PR~a R߭d},  PdX,  Pq,  ÖݬdR,  Pd),  PB,  _d,  P$,  d?P< ^%STެUŏ|   eP@DR ݭ|~ ~0   ,  Pbe+P eb+    MRB d^Y[qW&ZԭiީީlnޭpޭtxެRbTTߩ6߭+  ߭+  Pޭ|~ŏ|   bSCHP+PTߩDCRb֪T   *  ެVŏ|   fRB0TBScdB8SdPcB,TBScdB<RdPbUŏ|   fXHTx  Sx	UPdPCkP]*  PRRPPRfߩuZUҐB|p}P~Џ RR Џ ˏ   Rʏ    RR ˏ   Rȏ  RR ˏ   Rʏ  RR ȏ@ŏ|   SC ЬTT*  | C_*  P,PTɱ CRb֪T   )  |~|~l ެTŏ|   dSCR2b~ PRR,Pd HCRb֪d`   3)  ݭ߭)  ߭h)  Pޭ|~ެSc  ŏ|   cP@R2b~z)  PRRPc ެSc-	  ŏ|   cP@R2b~>)  PRRPc` ެSc	  ŏ|   cP@R2b~)  PRRPcɤMs(  P(   H(  PRbܨSߨRSb\NRbﴨCQ?A3ެTŏ|   dSC Rb{'  P0|'  dCRb֪d   '  < ~<~ |~ ެTŏ|   dSCgPRR,Pd/CRb֪dG   '  ެTd߭ŏ|   dRBgScPBRbdTdfghŏ|   TRBHS h|~ ~  &  PcT Tc&  <~ެTŏ|   dSC0RbRd  CR2b~ &  PRR?Pd}=CRb֪CHRb	b(&  ݬB   &  ŏ|   P@LRbŏ|   P@Rb1k߭<~ŏ|   SC,RbPC Rba%  PX1 CRb1-{%  	r%  ݬɱPެVŏ|   fRB P`"%  P1j֪BHP`UBPP`Tfr  BRbU1 T1 U;%  1 CRb1 ެUŏ|   eSCTP`CXQXaC(PX`|~XC,RbP|~CR2b~q%  PQPQe1C<TdRbPP2b~e1PClP`CpRdP2PPb1P  $  PB  b a$  ^WUäXŏ|   P@RbެTŏ|   dSC8RbP`RRPPFR0>2R~duxdP@XC0Rb#  PQPQdǤެVŏ|   fSCdP`ChTC8RbP2PPdxfP@rC0Rbt#  PQPQfsCPTdCHRbm#  d߭ެVfTxTP@ﮝ##  PQQ ŏ|   TP@LRbPQHQf
֨ŏ|   TRBHP`#  BDP`"  f  BRbď|   TD0SЭcD8RcPbDLRb<~cP                                                                                                                                                                                                                                                                            $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NVTD.EXE;1                                                                                                         d                         V# "     )       fBDR2b~ -#  PQQPPQfWq^X&Sۢ[ŏ|   RBDP`S"  BRbŏ|   P@<RbP`RR2`~ݬȋ
ެWŏ|   gP@(RbT@,RbU@lRb@pV@<QaP2RRfaP2PPT1 ŏ|   gZJ<VJYfP2PPTPUUf|~TU|~2i~."  PQPQݬȻ|>Pŏ|   gQAlP`ApRA<P`P2PPbŏ|   gP@<P`P2PPTŏ|   RB<TB,P`dB@RbP`RR2`~ݬެVŏ|   fTD@UeP1 DtRbDxQeP2RRa eP2~D4Rb~D$Rb   PUF   	x   fPb;   P(֫Jf  DRbD\RbD`RUb^XTàVŏ|   P@Rb ެUŏ|   eSC$Rb  PWg  	  eSb  PK֦CPRbCHRb  ެRb  ŏ|   bP@RbC\P`C`QWaP^X>TVŏ|   P@Rb ެUŏ|   eSC$Rb  PWg  	  eȊb  PK֦CPRbCHRb   ȷެRb  ŏ|   bP@RbC\P`C`QWaP  ^uQŏ|   P@ P  ^YQŏ|   P@P  < ^T2RެUŏ|   eP@HS ݭ|~ ~,   Q  PceP e    ^IXF[ﻷYﬞZ喝T^W  i     PjijkެUŏ|   eSC$Rb<  PN=  eX֧CDRb	bK  ެRbb  ŏ|   bRBRb %  ŏ|   P@Rb1   ߭xP@Ν  PSS ŏ|   P@PRb   SQSެRb1֧ŏ|   bP@DRb	b  ެRb  ŏ|   bP@Rb1y ЭP2
~ŏ|   SC$Rb  PVgCRb1C
  	  ݬl`ެUŏ|   eRB$P`  PA֧Ȓe  BRb1 PCRb1 ŏ|   RB\P`B`QVaŏ|   P@Rb1 ެVŏ|   fSCLUecC0QЭaC8RaPbe<~aPfCR2b~   PQQPP1-CRb1!QfȘ/ެSxcP@ݭ  PRP1Rc1P    P     | ^TVcR~Iߢ%  PpެUeđ ݢpߢŏ|   eP@$ScB  P!c  P6  eľQ ެSŏ|   cP@$P`  P  cެUŏ|   eP@fSc+ cPQPQ  Qce)ݬ< ^SUެRbݬg #  ŏ|   bP@ P`.  PT  bÞoFѭ   ѭ    ݬJ!ݬ:ݭݬ)	'ެTŏ|   dP@eRb+ bPQPQ  QbdV	ݬ MRB | ^UJSRpVP<`~  Tf1 ŏ|   TQAD\l1 AT\lAT\lAX\lAX\lA\\l A\\lA`\l$A`\lAd\l(Ad\lAh\l,Ah\lAl\l0Al\lAp\l4Ap\lAt\l8At\lAx\l<Ax\lTTf1BeN  Tdߥdݣݣݣݣݣcߥbdߥ|dݣ$ݣ ݣݣŴ d dݣ<ݣ8ݣ4ݣ0ݣ,ݣ(d1 ^MR\b  Scߢcݬݬݬݬݬlߢbcߢ|cݬ$ݬ ݬݬ´ c cݬ<ݬ8ݬ4ݬ0ݬ,ݬ(c   ^ɃR|~ݬ<  P$$P|(  0  P  ^}\$   ^eR(((\L S?0(< ~ $  PP  P0 \ lS0SPP ^Q(R( B   ^݂RY1F  W(((\L V=0&< ~ $gPU   P0 S cV0VUUTTPbUTeVDSZZPP 
' k/ @@@3 @@@@@w1!R?PY1P1(((\L X=0&< ~ $gP\   P0 S cX0X\\SC1(((\L S=0&< ~ $gPQ   P0 \ lS0SQQ\LO(((\L S=0&< ~ $gPQ   P0 \ lS0SQQ\L~112PTV(((\L S<0&< ~ $gPQ   P0 \ lS0SQQTD{~T\(S(\C e1VTV(((\L S<0&< ~ $gPQ   P0 \ lS0SQQTD}D}T\(S(\C e1 P(((\L X=0&< ~ $gPT   P0 S cX0XTTSPSV(((\L T<0&< ~ $gPQ   P0 \ lT0TQQSC}
eZYY16ZPP ^~Qx,RB4PЬ`B8RbaScPRbcRb,< ^RެUB ЬTeSBc~  PBdRBc޼SB   ^h~U,9,x,RB4ScVB8Rbe  e  PPnP ;PVV^eRޭnnWRTSCdPCd~m  PC SCdC 3wRb!Pb߭d  PТV	PRbeݬ=  VP  ^Rb ݬPSSPbݬߢ  P< P  ^ RPP  ^A\  ^ ^ SѬ ߣ8߭PR:P߭tPP   PPPRݬ]  PRRPP ^降SѬ ߣ߭PTYP߭PPf   PPЬRRPPP:   PPPTTPP ^߭PP߭PP   PPЬRRaPPP   PPPPP  ^߭,PP߭PP   PPݬ   PP8^W߭PP0.ˏxݬg  &Pݬߧ߭  Pݬߧ߭  XT  U߭dPVVPP   F r 1 P?P߭dPRR߭ePQQ1 PRP߭dPRR߭eP1 PRwP߭dPRR߭ePvROP߭dPSS߭ePRЬQaPPRaDPSP߭dPRR߭ePRPXVX1P  ^ݬQPPPPPP  8^߭%PPPP                             $^߭ݬ  PP   P	   $^Rߢ߭ݬ  PPP  QPQQPP $^]Rߢ߭ݬx  PPP  P $^-Rߢ߭ݬH  PPP  P  $^\ް"ޭ>|ԭ|~ ߭|~  Pѭ߬  Pr  ^\^
߬
   ^}S>Rbk\\-P\PP-) I A 	f?PP\   /P|   "P\|/P-P-~ߣ>  < ^S﹄Rߣ߭ݬ  PUP"ޭ>|ԭ|~ ߭|~  Pѭbߣ
  b 
  <PT |
  PT1 U  Pb
ߣ

  PbkQQ-PQPP-) I A 	F?PP\   /P|   "P\|/P-P-~ߣ
  	   	  PT1Zb
ߣ
	  P< ^SqRߣ߭ݬ  PUPߣ߭ݬ  PTP"ޭ>|ԭ|~ ߭|~  Pѭbߣj	  bTU  Pb
ߣ
K	  PU7  Pb
ߣ
-	  PbkQQ-PQPP-) I A 	?PP\   /P|   "P\|/P-P-~ߣ  }  1HP< ^hS)Rߣ߭ݬ|  PUP"ޭ>|ԭ|~ ߭|~  Pѭbߣ;  b      PT   PT1 U  Pb
ߣ
  PbkQQ-PQPP-) I A 	?PP\   /P|   "P\|/P-P-~ߣ  M   B  PT1Zb
ߣ
d  P ^R氏ޭ>ԭ|~ |~ 0Pݭߢݬ  PPP $^TլլPݬ  PRޭSݰޭ>ԭ|~ |~ 0PݭߤS  P߭u  PRRRPݬЬSS=  Rb߭SbݬS SP ,^RՐאޭݭݬ  PRR<LPݬ߭  ޭݭٰR|~|~|~ݬ    ,^RՐאޭݭݬ  PRR<LPݬ߭  ޭݭٰR|~|~|~ݬ   4^|XWVЬTUޭͭTF  PUU
<LS3PT߭0  ޭͭU|~|~|~VWX PSSR2PQRPQQPP8^|XWVЬTUޭͭT  PUU
<LS3PT߭  ޭͭU|~|~|~VWX PSSR2PQRPQQ|~ ݭPPP ,^WЬVUЬSTޭխS  PTT	<LR2PS߭  ޭխT|~|~|~UVW PRRPP
ЬRТP P  ^
ޭޭ𭸰ԭޭ|ԭ|ԭ|߭ݬ'PP|~ ݭԼP|~ ߭߭ PQP譨Q  PЭؼ|~ ݭP  ^|RPb|~?H<P@b  P ^Џigԭ߭߬3  PR ߭߯0߭  PRP	R  խ խP  ^|~ MRB   ^)  ݬݬ߯  P  ^ /|~|~5  ݬݬP  |~    )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     'o $      PWRKV50F1050.F                 q n [NW.KIT.EXE]PWVN$NVTD.EXE;1                                                                                                         d                         ˺ "     :               @   @     `  l  
                                                   `   h      p         x                    
                      8        X      0  H        
   t  L  L    $          L           &  |     D  L              	   (   0       @       8       ,
        
                 @                                                                       PWRK$XTILIBSHR                                                 LIBRTL                                                         MTHRTL                                                         
PWRK$CSSHR                                                     PWRK$CMTLIBSHR                                                 	SECURESHR                                                      
SECURESHRP                                                     VAXCRTL                                                        PTD$SERVICES_SHR                             \             	NVT_START ^ fsp$main F^ 
fsp$main_1     w^ 
fsp$main_2         ^ 
InitialThread ^ InitialThread_3     _ InitialThread_31 .    O_ InitialThread_4     _ InitialThread_5     _ InitialThread_6     _ InitialThread_7     #` InitialThread_8     7` InitialThread_38 X` InitialThread_9     \       ` 	nvtd_Init ` nvtd_Init_9     x    (a Nvtd_ExitHandler a Nvtd_ExitHandler_10 a Nvtd_ExitHandler_11 b Nvtd_ExitHandler_12 T               b Cleanup_Dev b Cleanup_Dev_13 c Cleanup_Dev_14    