                             $      PWRKV50F1050.G                                                                                                                                                                                               op               PWRKV50F1050.G  BACKUP/NOASSIST/COMMENT=OpenVMS AXP SPKITBLD Procedure/INTER/LOG/VERIFY NW$BLD_ROOT:[NW.KIT.AEXE]*.*; KIT$BLD_ROOT:[KIT]PWRKV50F1050.G/LABEL=(PATHWORKS)/SAVE/BLOCK=9000/GROUP=25/NOINIT/NOREWI  OpenVMS AXP SPKITBLD Procedure  PWBUILD           0D      V6.1 	 _KAZAM:: 
      _$1$DUA2000:  V6.1 
  $       (                    * [NW.KIT.AEXE]EXAMPLE.C;1 +  , ¾1  .     /     4 U       #                   - >   0   1    2   3      K   P   W   O     5   6 j{`1  7 VD  8          9          G    H  J                        /*
**  Sample source code example to make some Portable NetWare calls to
**  attach to a server and create a few files. Read PWVN$EXAMPLES:EXAMPLE.COM
**  to see how to build and link this image.
**
*/

#include <stdio.h>
#include <nwapi.h>
#include <nwerrors.h>
#include "getopt.h"

#define USERTYPE        1

static CreateFile(uint16 connID, char *fileName);
static CheckError(int ccode, char *name);

main(argc, argv)
int	argc;
char **argv;
{
	uint16		connID;
	int		ccode;
	char		c;
	char		*server = 0;
	char		*userName = 0;
	char		*password = 0;
	int		files = 1;
	char		*volume = 0;
	int		i;
	char		buf[255];
	
	while( ( c = getopt( argc, argv, "f:s:u:v:p:" ) ) != -1 ) {
	    switch( c ) {
		case	'f':	files = atoi(optarg);
		    break;
		case	's':	server = optarg;
		    break;
		case	'u':	userName = optarg;
		    break;
		case	'v':	volume = optarg;
		    break;
		case	'p':	password = optarg;
		    break;
		case	'?':
		    printf( "Usage: %s ", argv[0] );
		    printf( "-s SERVER [-u USERNAME] [-p PASSWORD] [-v VOLUME] [-f FILECOUNT]\n" );
		    return;
		}
	}

	if( !server )
	    {
	    printf( "Usage: %s ", argv[0] );
	    printf( "-s SERVER [-u USERNAME] [-p PASSWORD] [-v VOLUME] [-f FILECOUNT]\n" );
	    return;
	    }
	
	if( !userName )
		userName = "SUPERVISOR";
	if( !password )
		password = "";
	if(!volume)
		volume = "SYS:";

	printf("Attaching to server %s...\n", server);
	ccode = NWAttachToServerPlatform( server, &connID );
	CheckError(ccode, "NWAttachToServerPlatform");
	printf("   Attach to server <%s> succeeded.\n", server);

	printf("Logging in as user %s...\n", userName);
	ccode = NWLoginToServerPlatform( connID, userName, USERTYPE, password );
	CheckError(ccode, "NWLoginToServerPlatform");
	printf("   Log in as user <%s> succeeded.\n", userName);
	
	for (i = 0; i < files; i++)
	    {
	    sprintf(buf, "%s%06d", volume, i);
	    CreateFile(connID, buf);
	    }

	printf("Detaching...\n");
	ccode = NWDetachFromServerPlatform( connID );
	CheckError(ccode, "NWDetachFromServerPlatform");
	printf("   Detached.\n");
	
	printf("Closing transport...\n");
	ccode = NWCloseTransport();
	CheckError(ccode, "NWCloseTransport");
	printf("   Closed transport.\n");
}

static CreateFile(uint16 connID, char *fileName)
{
char		    data[132];
int		    ccode;
int		    i;
uint32		    startingOffset = 0;
uint32		    bytesToWrite;
NWFileHandle_ta     fileHandle;
NWPath_t	    path;
char		    buf[255];
FILE		    *f;

    bytesToWrite = sizeof(data);
    memset (data, 'X', bytesToWrite);
	
    path.dirHandle = 0;
    path.serverConnID = connID;
    path.pathName = fileName;

    printf("Creating file <%s>...\n", fileName);
    ccode = NWCreateFile( &path, NWFA_NORMAL, fileHandle );
    CheckError(ccode, "NWCreateFile");
    printf("   Created file <%s>.\n", fileName);
    
    printf("Writing file <%s>...\n", fileName);
    ccode = NWWriteFile( connID, fileHandle, &startingOffset, bytesToWrite, data );
    CheckError(ccode, "NWWriteFile");
    printf("   File <%s> written.\n", fileName);

    printf("Closing file <%s>...\n", fileName);
    ccode = NWCloseFile( connID, fileHandle);
    CheckError(ccode, "NWCloseFile");
    printf("   File <%s> closed.\n", fileName);

}

static CheckError(int ccode, char *name)
{
    if (ccode != SUCCESS)
	{
	printf("ERROR: %s failed; error = %x(hex)\n", name, NWErrno);
	exit(1);
	}
}

                                                                                                                                                                                                                                            * [NW.KIT.AEXE]EXAMPLE.COM;1 +  , ž/  .     /     4 N                          - >   0   1    2   3      K   P   W   O     5   6 wF]p  7 hD  8          9          G    H  J                      D $! Command file to compile and link sample NetWare program EXAMPLE.C $! $! Compile and link the C file $!N $! *NOTE* due to the current design of this interface it must be compiled withK $! DECC using /standard=vaxc (we don't include prototypes for the routine).  $!> $ cc/standard=vaxc pwvn$examples:example, pwvn$examples:getopt4 $ link example, getopt, pwvn$examples:example/option $!/ $! define foreign command to access the program 6 $ EXAMPLE == "$" + f$enviroment("DEFAULT") + "EXAMPLE"                           * [NW.KIT.AEXE]EXAMPLE.OPT;1 +  , ˾7  .     /     4 #       &                    - >   0   1    2   3      K   P   W   O     5   6 Ҁ|  7 IIqD  8          9          G    H  J                      # SYS$LIBRARY:PWVN$NWAPISHR.EXE/share                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [NW.KIT.AEXE]GETOPT.C;1 +  , ̾9  .     /     4 I                          - >   0   1    2   3      K   P   W   O     5   6 1Nt~  7 ND  8          9          G    H  J                         #include <stdio.h>
#include "getopt.h"

	char	noshare * optarg;
	int	noshare optind = 1;
	int	noshare opterr = 1;

	int	getopt(   int argc, char ** argv, char * optstr   );

int
getopt (argc, argv, optstr)
	int	argc;
	char	** argv;
	char	* optstr;
{
	char	* arg;
	char	ch;
	char	* errmsg = (char *)0;
	char	* cp1;
	int	i1;
	char	* opt;
static	int	optchind = 1;

top:
	if (optind >= argc
	|| !(opt = argv[optind])
	||  opt[0] != '-'
	||  optchind <= 0)
		return -1;
	if (!opt[optchind]) {
		optind++;
		for (i1 = optind; i1 < argc  &&  argv[i1]; i1++) {
			if (argv[i1] == optarg) {
				optind = i1 + 1;
				break;
			}
		}
		optchind = 1;
		goto top;
	}
	if (opt[1] == '-') {
		optchind = -1;
		optind++;
		return -1;
	}
	arg = argv[optind + 1];
	for (cp1 = optstr; ch = *cp1; cp1++) {
		if (ch == opt[optchind]) {
			if (cp1[1] == ':') {
				for (i1 = ++optind; i1 < argc  &&  argv[i1]; i1++) {
					if (argv[i1] == optarg) {
						arg = argv[i1 + 1];
						break;
					}
				}
				if (!(optarg = arg)  ||  arg[0] == '-')
					errmsg = "%s: option '%c' not followed by argument\n";
				else {
					optind++;
					optchind = 0;
				}
			}
			break;
		}
	}
	if (!ch)
		errmsg = "%s: unknown option '%c'\n";
	if (errmsg  &&  opterr) {
	        char *the_program_name = "getopt";
                fprintf(stderr, errmsg, the_program_name, opt[optchind]);
		ch = '?';
	}
	optchind++;
	if (!opt[optchind]) {
		optind++;
		optchind = 1;
	}
	return ch;
}
                                                                                                        * [NW.KIT.AEXE]GETOPT.H;1 +  , ξ9  .     /     4 ?                           - >   0   1    2   3      K   P   W   O     5   6 \#r՗  7 GD  8          9          G    H  J                         /* A simple "getopt" routine for VMS */

extern	char	noshare * optarg;
extern	int	noshare optind;
extern	int	noshare opterr;

extern	int	getopt(   int argc, char ** argv, char * optstr   );
                                                                                                                                                                                                                                                                                                                                                 * [NW.KIT.AEXE]NWAPI.H;1 +  , Ӿ6  . 2    /     4 N   2   ! ?                   - >   0   1    2   3      K   P   W   O 3    5   6 p  7 rAD  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                        ' $      PWRKV50F1050.G                 Ӿ6 > [NW.KIT.AEXE]NWAPI.H;1                                                                                                         N     2                          "            /*
 *
 *	This is a header file to be included by the NetWare application program 
 *
 */

#ifndef _api_h_
#define _api_h_

/* The rest of the code requirement unaligned structures, so force it here  */
#ifdef __DECC
#pragma nostandard
#pragma member_alignment __save
#pragma nomember_alignment
#endif

/* Include basetypes.h directly so we don't depend on that file */
#ifndef __basetypes__
#define __basetypes__

/*
 *	Define base types.  To avoid conflicts with DEC C's types, include its
 *	declarations of these instead.
 */
#ifdef __DECC

#include <ints.h>

#else

typedef	unsigned int		uint32;	/* 32-bit unsigned type */
typedef	unsigned short		uint16;	/* 16-bit unsigned type */
typedef	unsigned char		uint8;	/* 8-bit unsigned type */ 	

typedef	int			int32;	/* 32-bit signed type */
typedef	short			int16;	/* 16-bit signed type */
typedef char			int8;	/* 8-bit signed type */

#endif
#endif


typedef short			NWBoolean_ts;

#define 	SUCCESS		0

#ifndef 	TRUE
#define		TRUE		1
#define		FALSE		0
#endif

/* Declaration of NWErrno */
extern volatile uint32 noshare NWErrno;

/*******************************************************************
 *
 * Information pertaining to the accounting API calls
 *
 *******************************************************************/
#define		NWMAX_OBJECT_NAME_LENGTH	48
#define		NWMAX_NUMBER_OF_HOLDS		32
#define		NWMAX_COMMENT_LENGTH		48

/* the following definitions are for use with NWSubmitAccountNote */
#define 	NWAN_CONNECT_TIME		1
#define		NWAN_DISK_STORAGE		2
#define		NWAN_LOG_IN			3
#define		NWAN_LOG_OUT			4
#define		NWAN_ACCOUNT_LOCKED		5
#define		NWAN_SERVER_TIME_MODIFIED	6

typedef struct {
	uint32	objectID;
	int32	holdAmount;
} NWHoldInfo_t;


/*******************************************************************
 *
 * Information pertaining to the bindery API calls
 *
 *******************************************************************/
 /* object and property states */
#define		NWBF_STATIC			0x00	
#define		NWBF_DYNAMIC			0x01	

/* property types */
#define		NWBF_ITEM			0x00
#define		NWBF_SET			0x02

#define		NWMAX_SEGMENT_DATA_LENGTH	128
#define		NWMAX_OBJECT_NAME_LENGTH	48
#define		NWMAX_PROPERTY_NAME_LENGTH	16	
#define		NWMAX_MEMBER_NAME_LENGTH	48	
#define		NWMAX_PASSWORD_LENGTH		128
#define		NWMAX_PASSWORD_ENCRYPT_LENGTH	16
#define		NWMAX_PROPERTY_VALUE_LENGTH     128	

#define 	NWBS_ANY_READ			0x00
#define		NWBS_LOGGED_READ		0x01
#define		NWBS_OBJECT_READ		0x02
#define		NWBS_SUPER_READ			0x03
#define		NWBS_BINDERY_READ		0x04
#define		NWBS_ANY_WRITE			0x00
#define		NWBS_LOGGED_WRITE		0x10
#define		NWBS_OBJECT_WRITE		0x20
#define		NWBS_SUPER_WRITE		0x30
#define		NWBS_BINDERY_WRITE		0x40

#define		NWOT_WILD			0xFFFF
#define		NWOT_UNKNOWN			0x0000
#define		NWOT_USER			0x0001
#define		NWOT_USER_GROUP			0x0002
#define		NWOT_PRINT_QUEUE		0x0003
#define		NWOT_FILE_SERVER		0x0004
#define		NWOT_JOB_SERVER			0x0005
#define		NWOT_GATEWAY			0x0006
#define		NWOT_PRINT_SERVER		0x0007
#define		NWOT_ARCHIVE_QUEUE		0x0008
#define		NWOT_ARCHIVE_SERVER		0x0009
#define		NWOT_JOB_QUEUE			0x000A
#define		NWOT_ADMINISTRATION		0x000B
#define		NWOT_NAS_SNA_GATEWAY		0x0021
#define		NWOT_REMOTE_BRIDGE_SERVER	0x0024
#define		NWOT_TIME_SYNCHRONIZATION_SERVER 0x002D
#define		NWOT_ARCHIVE_SERVER_DYNAMIC_SAP	0x002E
#define		NWOT_ADVERTISING_PRINT_SERVER	0x0047
#define		NWOT_BTRIEVE_VAP		0x0050
#define		NWOT_PRINT_QUEUE_USER		0x0053
#define		NWOT_NVT_SERVER			0x009E

typedef struct {
	char		objectName[ NWMAX_OBJECT_NAME_LENGTH ];
	uint32		objectID;
	uint16		objectType;
	uint8		objectState;
	uint8		objectSecurity;
} NWObjectInfo_t;

typedef struct {
	char		propertyName[ NWMAX_PROPERTY_NAME_LENGTH ];
	uint8		propertyStateAndType;
	uint8		propertySecurity;
	uint8		propertyHasAValue;
} NWPropertyInfo_t;


/******************************************************************* 
* 
* Information pertaining to the connection API calls 
*
* *******************************************************************/ 
#define 	NWMAX_OBJECT_NAME_LENGTH	48	
#define		NWMAX_LOGIN_TIME_LENGTH		7 
#define		NWMAX_INTERNET_ADDRESS_LENGTH	12 
#define		NWMAX_KEYED_PASSWORD_LENGTH	8



/********************************************************************
 *
 * Information pertaining to the file system API calls 
 *
 ********************************************************************/
#define		NWMAX_DIR_PATH_LENGTH		255
#define		NWMAX_FILE_HANDLE_SIZE		6
#define		NWMAX_DIR_NAME_LENGTH		16	
#define		NWMAX_FILE_NAME_LENGTH		16	
#define		NWMAX_VOLUME_NAME_LENGTH	16	
#define		NWMAX_NS_NAME			16
#define		NWMAX_DS_NAME			16
#define		NWMAX_NUM_NS			10 
#define		NWMAX_NUM_DS			10
#define		NWMAX_NS_COUNT			10 
#define		NWMAX_USER_RESTRICTIONS		12

/* file attributes */
#define		NWFA_NORMAL			0x00000000L
#define		NWFA_READ_ONLY			0x00000001L
#define		NWFA_HIDDEN			0x00000002L
#define		NWFA_SYSTEM			0x00000004L
#define		NWFA_EXECUTE_ONLY		0x00000008L
#define		NWFA_NEED_ARCHIVE		0x00000020L
#define		NWFA_SHARABLE			0x00000080L
#define		NWFA_TRANSACTIONAL		0x00001000L
#define		NWFA_INDEXED			0x00002000L
#define		NWFA_READ_AUDIT 		0x00004000L
#define		NWFA_WRITE_AUDIT		0x00008000L
#define		NWFA_PURGE			0x00010000L
#define		NWFA_RENAME_INHIBIT		0x00020000L
#define		NWFA_DELETE_INHIBIT		0x00040000L
#define		NWFA_COPY_INHIBIT		0x00080000L
						
/* Trustee Access Rights in a 286 Network directory */
#define		NWTA_NONE             ((uint8)0x00)
#define		NWTA_READ             ((uint8)0x01)
#define		NWTA_WRITE            ((uint8)0x02)
#define		NWTA_OPEN             ((uint8)0x04)
#define		NWTA_CREATE           ((uint8)0x08)
#define		NWTA_DELETE           ((uint8)0x10)
#define		NWTA_OWNERSHIP        ((uint8)0x20)
#define		NWTA_SEARCH           ((uint8)0x40)
#define		NWTA_MODIFY           ((uint8)0x80)
#define		NWTA_ALL              ((uint8)0xFF)

/* trustee rights and inherited rights for 386 */
#define		NWTR_NONE		0x0000
#define		NWTR_READ		0x0001
#define		NWTR_WRITE		0x0002
/*					0x0004 ignore this bit */
#define		NWTR_CREATE		0x0008
#define		NWTR_ERASE		0x0010
#define		NWTR_ACCESS		0x0020
#define		NWTR_FILE_SCAN		0x0040
#define		NWTR_MODIFY		0x0080
#define		NWTR_SUPERVISOR 	0x0100
#define		NWTR_NORMAL		0x00FF 
#define		NWTR_ALL		0x01FF

/* search attributes */
#define		NWSA_NONE		0x00
#define		NWSA_HIDDEN		0x02
#define		NWSA_SYSTEM		0x04
#define		NWSA_BOTH		0x06
#define		NWSA_FILES_ONLY 	0x20  /* NOT for 286 */
#define		NWSA_DIRECTORIES_ONLY	0x10  /* NOT for 286 */

/* desired open access rights */
#define		NWOR_READ		0x01
#define		NWOR_WRITE		0x02
#define		NWOR_DENY_READ		0x04
#define		NWOR_DENY_WRITE 	0x08
#define		NWOR_COMPATIBILITY	0x10
#define		NWOR_SYNC_MODE		0x40

/* change attributes used in conjunction with set dir/file info */
#define		NWCA_NAME			0x0001	
#define		NWCA_ATTRIBUTES			0x0002
#define		NWCA_CREATE_DATE_AND_TIME	0x000C
#define		NWCA_OWNER_ID			0x0010
#define		NWCA_LAST_ARCHIVED_DATE_AND_TIME    0x0060
#define		NWCA_LAST_ARCHIVED_ID		0x0080
#define		NWCA_LAST_MODIFY_DATE_AND_TIME	0x0300
#define		NWCA_LAST_MODIFY_ID		0x0400
#define		NWCA_LAST_ACCESSED_DATE		0x0800
#define		NWCA_INHERITED_RIGHTS_MASK	0x1000
#define		NWCA_DIR_RESTRICTION		0x2000


typedef		uint8	NWDirHandle_ts;
typedef 	uint8	NWFileHandle_ta[ NWMAX_FILE_HANDLE_SIZE ];

typedef struct {
	NWDirHandle_ts	dirHandle;
	uint16	serverConnID;
	char	*pathName;
} NWPath_t;

typedef struct {
	uint32	totalBlocks;
	uint32	availableBlocks;
	uint32	purgableBlocks;
	uint32	notYetPurgableBlocks;
	uint32	totalDirEntries;
	uint32	availDirEntries;
	uint32	maxDirEntriesUsed;
	uint16	volNum;
	uint16	sectorsPerBlock;
	uint8	isHashed;
	uint8	isCached;
	uint8	isRemovable;
	uint8	isMounted;
	char	volName[ NWMAX_VOLUME_NAME_LENGTH ];
} NWVolUsage_t;

typedef struct {
	uint32	attributes;
	uint32	creationDateAndTime;
	uint32	ownerID;
	uint32	archiveDateAndTime;
	uint32	archiverID;
	uint32	lastModifyDateAndTime;
	uint32	dirRestriction;
	uint16	inheritedRightsMask;
	uint8	nameSpaceID;
	char	entryName[ NWMAX_DIR_NAME_LENGTH ];
} NWDirEntryInfo_t;

typedef struct {
	uint32	attributes;
	uint32	creationDateAndTime;
	uint32	ownerID;
	uint32	archiveDateAndTime;
	uint32	archiverID;
	uint32	updateDateAndTime;
	uint32	updatorID;
	uint32	fileSize;
	uint32	lastAccessDateAndTime;
	uint16	inheritedRightsMask;
	uint8	nameSpaceID;
	char	entryName[ NWMAX_FILE_NAME_LENGTH ];
} NWFileEntryInfo_t;

typedef struct {
	uint32	trusteeID;
	uint16	trusteeRights;
} NWTrusteeRights_t;

typedef struct {
	uint16	level;
	uint32	maxBlocks;
	uint32	availableBlocks;
} NWDirRestriction_t;

typedef struct {
	uint32	objectID;
	uint32	restriction;
} NWUserRestriction_t;

typedef struct
{
	uint32   deletedFileTime;
	uint32   deletedDateAndTime;
	uint32   deleterID;
                                                                                                                                                                                                                                                                           w% $      PWRKV50F1050.G                 Ӿ6 > [NW.KIT.AEXE]NWAPI.H;1                                                                                                         N     2                         !              	uint32   attributes;
	uint32   creationDateAndTime;
	uint32   ownerID;
	uint32   archiveDateAndTime;
	uint32   archiverID;
	uint32   updateDateAndTime;
	uint32   updatorID;
	uint32   fileSize;
	uint32   inheritedRightsMask;
	uint32   lastAccessDateAndTime;
	uint8    nameSpaceID;
	char     fileName[NWMAX_NS_NAME];
} NWSalvageableInfo_t;

typedef struct {
	uint8	definedDataStreams;
	char	dataStreamName[NWMAX_NUM_DS] [NWMAX_DS_NAME];
} NWDataStreamInfo_t;
	
typedef struct {
	uint8	definedNameSpaces;
	char	nameSpaceName[NWMAX_NUM_NS] [NWMAX_NS_NAME];
	uint8	nameSpaceDataStreams;
	NWDataStreamInfo_t	dataStream[NWMAX_NUM_NS];
	uint8	loadedNSCount;
	uint8	loadedNS[NWMAX_NS_COUNT];
	uint8	volumesNSCount;
	uint8	volumesNS[NWMAX_NS_COUNT];
	uint8	volumesDSCount;
	uint8	volumesDS[NWMAX_NS_COUNT];
} NWNameSpaceInfo_t;


/*******************************************************************
 *
 * Information pertaining to the path services API calls
 *
 *******************************************************************/



/*******************************************************************
 *
 * Information pertaining to the queue management API calls
 *
 *******************************************************************/
#define		NWMAX_QUEUE_NAME_LENGTH 			48
#define		NWMAX_JOB_STRUCT_SIZE				256
#define		NWMAX_QUEUE_SUBDIR_LENGTH			119
#define		NWMAX_NUMBER_OF_JOB_NUMBERS			250
#define		NWMAX_NUMBER_OF_SERVER_CONN_NUMBERS		25
#define		NWMAX_NUMBER_OF_SERVER_OBJECT_IDS		25
#define		NWMAX_SERVER_STATUS_RECORD_LENGTH		64
#define		NWMAX_QUEUE_JOB_TIME_SIZE			6
#define		NWMAX_JOB_FILE_NAME_LENGTH			14
#define		NWMAX_JOB_DESCRIPTION_LENGTH			50
#define		NWMAX_CLIENT_RECORD_LENGTH			152
#define		NWMAX_FORM_NAME_LENGTH				16
#define		NWMAX_BANNER_NAME_FIELD_LENGTH			13
#define		NWMAX_BANNER_FILE_FIELD_LENGTH			13
#define		NWMAX_HEADER_FILE_NAME_LENGTH			14
#define		NWMAX_JOB_DIR_PATH_LENGTH			80	

/* the following are job control flags */
#define		NWCF_OPERATOR_HOLD		0x80
#define		NWCF_USER_HOLD			0x40
#define		NWCF_ENTRY_OPEN			0x20
#define		NWCF_SERVICE_RESTART		0x10
#define		NWCF_SERVICE_AUTO_START		0x08

/* the following are control flags used with NWPrintRecord_t */
#define		NWPCF_SUPPRESS_FF		0x0008
#define		NWPCF_NOTIFY_USER		0x0010
#define		NWPCF_TEXT_MODE			0x0040
#define		NWPCF_PRINT_BANNER		0x0080

/* the queue status flags are used with NWSetQueueCurrentStatus */
#define		NWQS_NO_SERVER_RESTRICTIONS	0x00
#define		NWQS_NO_MORE_JOBS		0x01
#define		NWQS_NO_MORE_SERVER_ATTACHMENTS	0x02
#define		NWQS_SERVERS_DISABLED		0x04

typedef unsigned char NWClientRecord_ta[ NWMAX_CLIENT_RECORD_LENGTH ];

typedef struct {
	uint8	versionNumber;
	uint8	tabSize;
	uint16	numCopies;
	uint16	controlFlags;
	uint16	linesPerPage;
	uint16	charsPerLine;
	char	formName[ NWMAX_FORM_NAME_LENGTH ];
	char	bannerNameField[ NWMAX_BANNER_NAME_FIELD_LENGTH ];
	char	bannerFileField[ NWMAX_BANNER_FILE_FIELD_LENGTH ];
	char	headerFileName[ NWMAX_HEADER_FILE_NAME_LENGTH ];
	char	directoryPath[ NWMAX_JOB_DIR_PATH_LENGTH ];
} NWPrintRecord_t;

typedef struct {
	uint8	clientStation;
	uint8	clientTask;
	uint32	clientID;
	uint32	targetServerID;
	uint8	targetExecutionTime[ NWMAX_QUEUE_JOB_TIME_SIZE];
	uint8	jobEntryTime[ NWMAX_QUEUE_JOB_TIME_SIZE ];
	uint16	jobNumber;
	uint16	jobType;
	uint8	jobPosition;
	uint8	jobControlFlags;
	uint8	jobFileName[ NWMAX_JOB_FILE_NAME_LENGTH ];
	NWFileHandle_ta		jobFileHandle;
	uint8	servicingServerStation;
	uint8	servicingServerTaskNumber;
	uint32	servicingServerIDNumber;
	uint8	jobDescription[ NWMAX_JOB_DESCRIPTION_LENGTH ];
	NWClientRecord_ta	queueRecord;
} NWQueueJobStruct_t;


/*******************************************************************
 *
 * Information pertaining to the server platform API calls
 *
 *******************************************************************/
#define		NWMAX_OBJECT_NAME_LENGTH		48	
#define		NWMAX_COMPANY_NAME_LENGTH		80 
#define		NWMAX_DESCRIPTION_LENGTH		80
#define		NWMAX_DATE_LENGTH			24
#define		NWMAX_COPYRIGHT_NOTICE_LENGTH		80
#define		NWMAX_SERVER_NAME_LENGTH		48
#define		NWMAX_CONNECTION_LIST_LENGTH		50

typedef struct {
	uint16	majorVersion;
	uint16	minorVersion;
	uint16	revision;
	uint16	SFTLevel;
	uint16	TTSLevel;
	uint16	accountingVersion;
	uint16	VAPVersion;
	uint16	queueingVersion;
	uint16	printServerVersion;
	uint16	virtualConsoleVersion;
	uint16	securityRestrictionLevel;
	uint16	internetBridgeSupport;
	uint16	maxClientConnSupported;
	uint16	clientConnInUse;
	uint16	peakClientConnUsed;
	uint16	maxVolumes;
	char	serverName[ NWMAX_SERVER_NAME_LENGTH ];
} NWServerPlatformInfo_t;

typedef struct {
	uint8	year;
	uint8	month;
	uint8	day;
	uint8	hour;
	uint8	minute;
	uint8	second;
	uint8	dayOfWeek;	/* 0 means sunday */
} NWServerPlatformDateAndTime_t;

typedef struct {    /* For 286 core printer use only */
	uint8	printerHalted;
	uint8	printerOffLine;
	uint8	currentFormType;
	uint8	redirectedPrinter;
} NWPrinterInfo_t;

typedef struct {
	char	companyName[ NWMAX_COMPANY_NAME_LENGTH ];
	char	revisionDescription[ NWMAX_DESCRIPTION_LENGTH ];
	char	revisionDate[ NWMAX_DATE_LENGTH ];
	char	copyrightNotice[ NWMAX_COPYRIGHT_NOTICE_LENGTH ];
} NWDescriptionStrings_t;


/*******************************************************************
 *
 * The following structures are used by sconsole to retrieve server
 * statistics per the 3.11 interface definition, and have been
 * retrofitted into the 3.01b for VMS to provide statistics info
 * given the lack of a private interface for use by sconsole.
 *
 * 03 Jan 91	TRL	Retrofit
 *
 *******************************************************************/


typedef struct {  /* For Portable NetWare only  */
	uint32	NWProcs;
	uint32	TotalPackets;
	uint32	CreateConnectionRequests;
	uint32	CreateFileRequests;
	uint32	OpenRequests;
	uint32	ReadRequests;
	uint32	WriteRequests;
	uint32	NumOpenFiles;
	uint32	MaxSimultaneousOpens;
	uint32	LostPacketResends;
	uint32	CacheHits;
	uint32	CacheMisses;
	uint32	PrintRequests;
	uint32	MessageRequests;
	uint32	DirectoryRequests;
	uint32	BinderyAndMiscRequests;
	uint32	UnknownRequests;
	uint32	TTSRequests;
} NWServerPlatformStats_t;


typedef struct {  /* For Portable NetWare only  */
	uint32	TTSRequests;
	uint32	TotalWrites;
	uint32	TotalBackouts; 
	uint32	TransactionBackouts;
	uint32	UnfilledBackoutRequests;
	uint32	NumTransactions;
	uint32	MaxTransactionsOpened;
} NWServerPlatformTTS_t;

			
typedef struct {  /* For Portable NetWare only  */
	uint32	LogicalLockRequests;
	uint32	NumLogicalLocks;
	uint32	MaxSimultaneousLogLocks;
	uint32	FileLockRequests;
	uint32	NumFileLocks;
	uint32	MaxSimultaneousFileLocks;
	uint32	PhysLockRequests;
	uint32	NumPhysLocks;
	uint32	MaxSimultaneousPhysLocks;
	uint32	SemaphoreRequests;
	uint32	NumSemaphores;
	uint32	MaxSimultaneousSemaphores;
} NWServerPlatformSync_t;

			
typedef struct {  /* For Portable NetWare only  */
	uint32	SharedMemorySize;
	uint32	CurrentSharedMemoryUsage;
	uint32	MaxSharedMemoryUsed;	
} NWServerPlatformSharedMemoryInfo_t;
			
			
/*******************************************************************
 *
 * Information pertaining to the synchronization platform API calls
 *
 *******************************************************************/
#define		NWMAX_LOGICAL_RECORD_NAME_LENGTH 	80
#define		NWMAX_SEMAPHORE_NAME_LENGTH 		127

/* file lock log flags */
#define		NWFL_LOG_ONLY				0x00
#define		NWFL_LOG_AND_LOCK			0x01

/* physical and logical record log flags */
#define		NWPL_LOG_ONLY				0x00
#define		NWPL_LOG_AND_LOCK_EXCLUSIVE		0x01
#define		NWPL_LOG_AND_LOCK_SHAREABLE		0x03

/* logical and physical lock set flags */
#define		NWLS_EXCLUSIVE				0x00
#define		NWLS_SHAREABLE				0x02


/*******************************************************************
 *
 * Information pertaining to the transaction tracking platform API calls
 *
 *******************************************************************/
/* currently no data */


#ifdef __DECC
#pragma member_alignment __restore
#pragma standard
#endif

#endif
                                                                                                                                                                                                                * [NW.KIT.AEXE]NWERRORS.H;1 +  , S}(  . K    /     4 I   K   : W                   - >  0   1    2   3      K   P   W   O L    5   6 E
  7 đD  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     $      PWRKV50F1050.G                 S}( > [NW.KIT.AEXE]NWERRORS.H;1                                                                                                      I     K                         A "            /*======================================================================
  ==    program         : NetWare Directory Services Platform Library
  ==
  ==    file            : nwerrors.h
  ==
  ==    date            : 13 December 1989
  ==
  ==    modifications   :
  ==
  ==    comments        : The format of the error code, which is 
  ==					contained in an unsigned long word 
  ==					(32-bits), is as follows:
  ==                 ||   high word       |       low word           ||
  ==                   ----------------------------------------------
  ==                 ||high byte| low byte| high byte  | low byte    ||
  ==                   ==============================================
  ==                 ||reserved | section | subsection | server error||
  ==                   ==============================================
  ==
  ==    Copyright (c) 1988-1990 Novell, Inc.  All rights reserved.
  ==
  ===================================================================*/

#ifndef _NWERRORS_
#define _NWERRORS_

/* Declaration of NWErrno */
extern volatile uint32 noshare NWErrno;

#define NWSUCCESSFUL                       0x00000000L

/*=====================================================================
=                   		Sub-Section Base Masks
=
= 0x00      Sub-Section code is for errors returned by servers running
				netware 386 and later and errors created by the OS2
				api library software team before 3/1/90.
				Sub-Section code 0x00 and low order bytes between
				0x30-0x70 are for errors that were created by 
				the portable api library software team and have to 
				passed back using only one byte (nwccode_t) and later 
				ored with a section base mask.
=
= 0x10		Sub-Section code is reserved for errors that are like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=
= 0x20		Sub-Section code is reserved for errors that are non-like
				errors across section base masks and do not have to be 
				passed back as one byte (nwccode_t). These errors
				were created by the portable api library software team.
=======================================================================
*/

/*======================================================================
=                   		Section Base Masks
=
========================================================================
*/
#define NWERR_ACCOUNT           0x00010000L
#define NWERR_ACCOUNT_INVALID_PARAMETERS   (NWERR_ACCOUNT | 0x000020FBL)
#define NWERR_ACCOUNT_INVALID_CONNECTION_ID	(NWERR_ACCOUNT | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_ACCOUNT_INVALID_NCP_PACKET_LENGTH (NWERR_ACCOUNT | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_ACCOUNT_SETTING_UP_TIMEOUT		(NWERR_ACCOUNT | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_ACCOUNT_TRANSPORT_SEND			(NWERR_ACCOUNT | \
													NWERR_TRANSPORT_SEND
#define NWERR_ACCOUNT_IN_SETTING_SIGNALS		(NWERR_ACCOUNT | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_ACCOUNT_INVALID_PARAMETER_LENGTH	(NWERR_ACCOUNT | \
													0x00001001L)



#define	NWERR_BINDERY			0x00070000L
#define NWERR_BIND              NWERR_BINDERY
#define NWERR_BIND_SERVER_OUT_OF_MEMORY     (NWERR_BIND | 0x96)
#define NWERR_BIND_LOGIN_LOCKOUT            (NWERR_BIND | 0xC5)
#define NWERR_BIND_DUPLICATE_PASSWORD       (NWERR_BIND | 0xD7)
#define NWERR_BIND_NO_DISK_TRACK            (NWERR_BIND | 0xE7)
#define NWERR_BIND_WRITE_TO_GROUP           (NWERR_BIND | 0xE8)
#define NWERR_BIND_MEMBER_EXISTS            (NWERR_BIND | 0xE9)
#define NWERR_BIND_NO_SUCH_MEMBER           (NWERR_BIND | 0xEA)
#define NWERR_BIND_NOT_SET_PROPERTY         (NWERR_BIND | 0xEB)
#define NWERR_BIND_NO_SUCH_SET              (NWERR_BIND | 0xEC)
#define NWERR_BIND_OBJECT_EXISTS            (NWERR_BIND | 0xEE)
#define NWERR_BIND_ILLEGAL_NAME             (NWERR_BIND | 0xEF)
#define NWERR_BIND_ILLEGAL_WILDCARD         (NWERR_BIND | 0xF0)
#define NWERR_BIND_BINDERY_SECURITY         (NWERR_BIND | 0xF1)
#define NWERR_BIND_NO_OBJECT_READ           (NWERR_BIND | 0xF2)
#define NWERR_BIND_NO_OBJECT_DELETE         (NWERR_BIND | 0xF4)
#define NWERR_BIND_NO_OBJECT_CREATE         (NWERR_BIND | 0xF5)
#define NWERR_BIND_NO_PROPERTY_DELETE       (NWERR_BIND | 0xF6)
#define NWERR_BIND_NO_PROPERTY_CREATE       (NWERR_BIND | 0xF7)
#define NWERR_BIND_NO_PROPERTY_WRITE        (NWERR_BIND | 0xF8)
#define NWERR_BIND_NO_PROPERTY_READ         (NWERR_BIND | 0xF9)
#define NWERR_BIND_NO_SUCH_PROPERTY         (NWERR_BIND | 0xFB)
#define NWERR_BIND_NO_SUCH_OBJECT           (NWERR_BIND | 0xFC)
#define NWERR_BIND_DIR_LOCKED               (NWERR_BIND | 0xFE)
#define NWERR_BIND_HARD_FAILURE             (NWERR_BIND | 0xFF)
#define NWERR_BIND_FAILURE                  (NWERR_BIND | 0xFF)
#define NWERR_BIND_NO_MORE_OBJECTS			NWERR_BIND_NO_SUCH_OBJECT
#define NWERR_BIND_NO_MORE_PROPERTIES       NWERR_BIND_NO_SUCH_PROPERTY
#define NWERR_BIND_NO_MORE_PROP_VALS        NWERR_BIND_NO_PROPERTY_READ
#define NWERR_BIND_INVALID_PARAMETERS		(NWERR_BIND | 0x000020FBL)
#define NWERR_BIND_INVALID_CONNECTION_ID	(NWERR_BIND | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_BIND_INVALID_NCP_PACKET_LENGTH (NWERR_BIND | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_BIND_SETTING_UP_TIMEOUT		(NWERR_BIND | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_BIND_TRANSPORT_SEND			(NWERR_BIND | \
													NWERR_TRANSPORT_SEND
#define NWERR_BIND_IN_SETTING_SIGNALS		(NWERR_BIND | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_BIND_INVALID_PARAMETER_LENGTH	(NWERR_BIND | 0x00001001L)



#define NWERR_CONNECTION   		0x00090000L
#define NWERR_CONN        		0x00090000L
#define NWERR_CONN_INVALID_CONNECTION_ID	(NWERR_CONN | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_CONN_INVALID_NCP_PACKET_LENGTH (NWERR_CONN | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_CONN_SETTING_UP_TIMEOUT		(NWERR_CONN | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_CONN_TRANSPORT_SEND			(NWERR_CONN | \
													NWERR_TRANSPORT_SEND
#define NWERR_CONN_IN_SETTING_SIGNALS		(NWERR_CONN | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_CONN_INVALID_PARAMETER_LENGTH	(NWERR_CONN | 0x00001001L)
#define NWERR_CONN_SETTING_UP_INTERRUPT		(NWERR_CONN | 0x00002001L)
#define NWERR_CONN_TRANSPORT_OPEN			(NWERR_CONN | 0x00002002L)
#define NWERR_CONN_TRANSPORT_CLOSE			(NWERR_CONN | 0x00002003L)
#define NWERR_CONN_NOT_CONNECTED_TO_SERVER	(NWERR_CONN | 0x00002004L)
#define NWERR_CONN_CONNECT_LIST_OVERFLOW	(NWERR_CONN | 0x00000004L)
#define NWERR_CONN_UNENCRYPTED_PASSWORD		(NWERR_CONN | 0x000000D6L)
#define NWERR_CONN_SERVER_OUT_OF_MEMORY		(NWERR_CONN | 0x00000096L)
#define NWERR_CONN_NO_ACCOUNT_BALANCE		(NWERR_CONN | 0x000000C1L)
#define NWERR_CONN_CREDIT_LIMIT_EXCEEDED	(NWERR_CONN | 0x000000C2L)
#define NWERR_CONN_LOGIN_LOGOUT				(NWERR_CONN | 0x000000C5L)
#define NWERR_CONN_ACCOUNT_BAD				(NWERR_CONN | 0x000000D7L)
#define NWERR_CONN_PASSWORD_TOO_SHORT		(NWERR_CONN | 0x000000D8L)
#define NWERR_CONN_MAX_LOGINS_EXCEEDED		(NWERR_CONN | 0x000000D9L)
#define NWERR_CONN_BAD_LOGIN_TIME			(NWERR_CONN | 0x000000DAL)
#define NWERR_CONN_LOGIN_STATION_ERROR		(NWERR_CONN | 0x000000DBL)
#define NWERR_CONN_BAD_PASSWORD				(NWERR_CONN | 0x000000DEL)
#define NWERR_CONN_PASSWORD_EXPIRED			(NWERR_CONN | 0x000000DFL)
#define NWERR_CONN_WRITE_TO_GROUP			(NWERR_CONN | 0x000000E8L)
#define NWERR_CONN_NO_SUCH_SET				(NWERR_CONN | 0x000000ECL)
#define NWERR_CONN_PROPERTY_EXISTS			(NWERR_CONN | 0x000000EDL)
#define NWERR_CONN_ILLEGAL_NAME				(NWERR_CONN | 0x000000EFL)
#define NWERR_CONN_ILLEGAL_WILDCARD			(NWERR_CONN | 0x000000F0L)
#define NWERR_CONN_BINDERY_SECURITY			(NWERR_CONN | 0x000000F1L)
#define NWERR_CONN_NO_OBJECT_READ			(NWERR_CONN | 0x000000F2L)
#define NWERR_CONN_NO_PROPERTY_DELETE		(NWERR_CONN | 0x000000F6L)
#define NWERR_CONN_ALREADY_ATTACHED_TO_SERVER (NWERR_CONN | 0x000000F8L)
#define NWERR_CONN_NO_FREE_CONNECTION_SLOTS	(NWERR_CONN | 0x000000F9L)
#define NWERR_CONN_NO_MORE_SERVER_SLOTS		(NWERR_CONN | 0x000000FAL)
#define NWERR_CONN_INVALID_PARAMETERS		(NWERR_CONN | 0x000020FBL)
#define NWERR_CONN_UNKNOWN_FILE_SERVER		(NWERR_CONN | 0x000000FCL)
#define NWERR_CONN_SERVER_BINDERY_LOCKED	(NWERR_CONN | 0x000000FEL)
#define NWERR_CONN_NO_RESPONSE_FROM_SERVER	(NWERR_CONN | 0x000000FFL)




#define NWERR_FS                             0x00110000L
#define NWERR_FS_PATH_TOO_LONG               (NWERR_FS | 0x00000001L)   
#define NWERR_FS_NO_MORE_RESTRICTIONS        (NWERR_FS | 0x00000024L)
#define NWERR_FS_NO_CREATE_PRIVILEGES        (NWERR_FS | 0x00000084L)
#define NWERR_FS_NO_MORE_TRUSTEES                                                                                                                                                                                                                                                                              | $      PWRKV50F1050.G                 S}( > [NW.KIT.AEXE]NWERRORS.H;1                                                                                                      I     K                         + "                     (NWERR_FS | 0x0000009CL)
#define NWERR_FS_DIRECTORY_NOT_EMPTY         (NWERR_FS | 0x000000A0L)
#define NWERR_FS_NOT_386_FILE_SYSTEM         (NWERR_FS | 0x000000FBL)
#define NWERR_FS_NO_SUCH_RESTRICTION         (NWERR_FS | 0x000000FEL)
#define NWERR_FS_FILE_ALREADY_EXISTS		(NWERR_FS | 0x000000FFL)
#define NWERR_FS_PATH_NOT_LOCATABLE			(NWERR_FS | 0x000000FFL)
#define NWERR_FS_NO_MODIFY_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_MODIFY_PRIVILEGES)
#define NWERR_FS_NO_DELETE_PRIVILEGES        (NWERR_FS | \
                                             NWERR_NO_DELETE_PRIVILEGES)
#define NWERR_FS_ENTRY_IN_USE                (NWERR_FS | \
                                             NWERR_ENTRY_IN_USE)
#define NWERR_FS_NO_CONSOLE_RIGHTS           (NWERR_FS | \
                                             NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_FS_SERVER_OUT_OF_MEMORY        (NWERR_FS |   \
                                             NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_FS_VOL_DOES_NOT_EXIST          (NWERR_FS |   \
                                             NWERR_VOL_DOES_NOT_EXIST)
#define NWERR_FS_NO_SUCH_BINDERY_OBJ         (NWERR_FS |   \
                                             NWERR_NO_SUCH_BINDERY_OBJ)
#define NWERR_FS_NO_OBJECT_READ              (NWERR_FS |   \
                                             NWERR_NO_OBJECT_READ)
#define NWERR_FS_BAD_DIR_HANDLE              (NWERR_FS |   \
                                             NWERR_BAD_DIR_HANDLE)
#define NWERR_FS_INVALID_PATH                (NWERR_FS |   \
                                             NWERR_INVALID_PATH)
#define NWERR_FS_ENTRY_EXISTS                (NWERR_FS |   \
                                             NWERR_ENTRY_EXISTS)
#define NWERR_FS_DIR_FULL                    (NWERR_FS |   \
                                             NWERR_DIR_FULL)
#define NWERR_FS_ENTRY_NOT_FOUND             (NWERR_FS |   \
                                             NWERR_ENTRY_NOT_FOUND)
#define NWERR_FS_INVALID_PARAMETERS			 (NWERR_FS | 0x000020FBL)	
#define NWERR_FS_INVALID_CONNECTION_ID		(NWERR_FS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_FS_INVALID_NCP_PACKET_LENGTH 	(NWERR_FS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_FS_SETTING_UP_TIMEOUT			(NWERR_FS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_FS_TRANSPORT_SEND				(NWERR_FS | \
												NWERR_TRANSPORT_SEND
#define NWERR_FS_IN_SETTING_SIGNALS			(NWERR_FS | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_FS_INVALID_PARAMETER_LENGTH	(NWERR_FS | 0x00001001L)
#define NWERR_FS_CORRUPTION_OF_CURRENT_SCAN	(NWERR_FS | 0x00002001L)




#define NWERR_PATH              0x001b0000L
#define NWERR_PATH_BAD_SRCH_DRIVE_VCTR       (NWERR_PATH | 0x00000001L)
#define NWERR_PATH_INVALID_PATH_LENGTH       (NWERR_PATH | 0x00000002L) 
#define NWERR_PATH_INVALID_DRIVE_NUM         (NWERR_PATH | 0x00000020L)
#define NWERR_PATH_NO_DRIVES_AVAILABLE       (NWERR_PATH | 0x00000025L)
#define NWERR_PATH_WS_DOES_NOT_SUPPORT       (NWERR_PATH | 0x00000030L)
#define NWERR_PATH_INVALID_PARAMETERS		 (NWERR_PATH | 0x000020FBL)
#define NWERR_PATH_INVALID_CONNECTION_ID	(NWERR_PATH | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_PATH_INVALID_PATH				(NWERR_PATH | 0x0000009CL)
#define NWERR_PATH_NO_DIRECTORY_HANDLES		(NWERR_PATH | 0x0000009DL)
#define NWERR_PATH_INVALID_NCP_PACKET_LENGTH (NWERR_PATH | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_PATH_SETTING_UP_TIMEOUT		(NWERR_PATH | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_PATH_TRANSPORT_SEND			(NWERR_PATH | \
													NWERR_TRANSPORT_SEND
#define NWERR_PATH_IN_SETTING_SIGNALS		(NWERR_PATH | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_PATH_INVALID_PARAMETER_LENGTH	(NWERR_PATH | 0x00001001L)



#define NWERR_QUEUE             0x00210000L
#define NWERR_Q                 NWERR_QUEUE
#define NWERR_Q_SERVER_OUT_OF_MEMORY            (NWERR_QUEUE | 0x96)
#define NWERR_Q_DIR_FULL                        (NWERR_QUEUE | 0x99)
#define NWERR_Q_BAD_DIR_HANDLE                  (NWERR_QUEUE | 0x9B)
#define NWERR_Q_INVALID_PATH                    (NWERR_QUEUE | 0x9C)
#define NWERR_Q_ERROR                           (NWERR_QUEUE | 0xD0)
#define NWERR_Q_NO_QUEUE                        (NWERR_QUEUE | 0xD1)
#define NWERR_Q_NO_QUEUE_SERVER                 (NWERR_QUEUE | 0xD2)
#define NWERR_Q_NO_QUEUE_RIGHTS                 (NWERR_QUEUE | 0xD3)
#define NWERR_Q_FULL                            (NWERR_QUEUE | 0xD4)
#define NWERR_Q_NO_JOB                          (NWERR_QUEUE | 0xD5)
#define NWERR_Q_NO_JOB_RIGHTS                   (NWERR_QUEUE | 0xD6)
#define NWERR_Q_PASSWORD_NOT_UNIQUE             (NWERR_QUEUE | 0xD7)
#define NWERR_Q_SERVICING                       (NWERR_QUEUE | 0xD7)
#define NWERR_Q_NOT_ACTIVE                      (NWERR_QUEUE | 0xD8)
#define NWERR_Q_PASSWORD_TOO_SHORT              (NWERR_QUEUE | 0xD8)
#define NWERR_Q_STATION_NOT_SERVER              (NWERR_QUEUE | 0xD9)
#define NWERR_Q_HALTED                          (NWERR_QUEUE | 0xDA)
#define NWERR_Q_MAX_QUEUE_SERVERS               (NWERR_QUEUE | 0xDB)
#define NWERR_Q_NO_SUCH_MEMBER                  (NWERR_QUEUE | 0xEA)
#define NWERR_Q_PROPERTY_ALREADY_EXISTS         (NWERR_QUEUE | 0xED)
#define NWERR_Q_OBJECT_ALREADY_EXISTS           (NWERR_QUEUE | 0xEE)
#define NWERR_Q_INVALID_NAME                    (NWERR_QUEUE | 0xEF)
#define NWERR_Q_WILD_CARD_NOT_ALLOWED           (NWERR_QUEUE | 0xF0)
#define NWERR_Q_INVALID_BINDERY_SECUR           (NWERR_QUEUE | 0xF1)
#define NWERR_Q_NO_OBJECT_DELETE_PRIVILEGE		(NWERR_QUEUE | 0xF4)
#define NWERR_Q_NO_OBJECT_CREATE_PRIV           (NWERR_QUEUE | 0xF5)
#define NWERR_Q_NO_PROPERTY_CREATE_PRIV         (NWERR_QUEUE | 0xF7)
#define NWERR_Q_NO_SUCH_OBJECT                  (NWERR_QUEUE | 0xFC)
#define NWERR_Q_SERVER_BINDERY_LOCKED           (NWERR_QUEUE | 0xFE)
#define NWERR_Q_BINDERY_FAILURE                 (NWERR_QUEUE | 0xFF)
#define NWERR_Q_HARDWARE_FAILURE                (NWERR_QUEUE | 0xFF)
#define NWERR_Q_VOL_DOES_NOT_EXIST				(NWERR_QUEUE | 0x98)
#define NWERR_Q_INVALID_PARAMETERS				(NWERR_QUEUE | \
												0x000020FBL)
#define NWERR_Q_INVALID_CONNECTION_ID	(NWERR_QUEUE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_Q_INVALID_NCP_PACKET_LENGTH (NWERR_QUEUE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_Q_SETTING_UP_TIMEOUT		(NWERR_QUEUE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_Q_TRANSPORT_SEND			(NWERR_QUEUE | \
													NWERR_TRANSPORT_SEND
#define NWERR_Q_IN_SETTING_SIGNALS		(NWERR_QUEUE | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_Q_INVALID_PARAMETER_LENGTH	(NWERR_QUEUE | 0x00001001L)



#define NWERR_SP                0x00230000L  /* server platform */

#define NWERR_SP_VERSION_TOO_LOW    (NWERR_SP | 0x00000001L)
#define NWERR_SP_SFT_LEVEL_TOO_LOW  (NWERR_SP | 0x00000002L)
#define NWERR_SP_TTS_LEVEL_TOO_LOW  (NWERR_SP | 0x00000004L)
#define NWERR_SP_AFP_LEVEL_TOO_LOW  (NWERR_SP | 0x00000008L)
#define NWERR_SP_NO_CONSOLE_RIGHTS  (NWERR_SP | 0x000000C6L)
#define NWERR_SP_OPEN_FILES         (NWERR_SP | 0x000000FFL)
#define NWERR_SP_INVALID_PARAMETERS (NWERR_SP | 0x000020FBL)
#define NWERR_SP_NOT_286_FILE_SYSTEM (NWERR_SP | 0x000010FCL)
#define NWERR_SP_INVALID_CONNECTION_ID	(NWERR_SP | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SP_INVALID_NCP_PACKET_LENGTH (NWERR_SP | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SP_SETTING_UP_TIMEOUT		(NWERR_SP | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SP_TRANSPORT_SEND			(NWERR_SP | \
													NWERR_TRANSPORT_SEND
#define NWERR_SP_IN_SETTING_SIGNALS		(NWERR_SP | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SP_INVALID_PARAMETER_LENGTH	(NWERR_SP | 0x00001001L)




#define NWERR_SYNC                         0x00270000L
#define NWERR_SYNC_SERVER_OUT_OF_MEMORY   (NWERR_SYNC |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_SYNC_INVALID_NAME_LEN       (NWERR_SYNC | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SYNC_TIMEOUT_FAILURE        (NWERR_SYNC | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SYNC_INVALID_PARAMETERS	  (NWERR_SYNC | 0x000020FBL)
#define NWERR_SYNC_INVALID_CONNECTION_ID	(NWERR_SYNC | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SYNC_INVALID_NCP_PACKET_LENGTH (NWERR_SYNC | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SYNC_SETTING_UP_TIMEOUT		(NWERR_SYNC | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SYNC_TRANSPORT_SEND			(NWERR_SYNC | \
													NWERR_TRANSPORT_SEN                                                                                                                                                                                                                                                                           ދ $      PWRKV50F1050.G                 S}( > [NW.KIT.AEXE]NWERRORS.H;1                                                                                                      I     K                         x "     #       D
#define NWERR_SYNC_IN_SETTING_SIGNALS		(NWERR_SYNC | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SYNC_INVALID_PARAMETER_LENGTH	(NWERR_SYNC | 0x00001001L)



#define NWERR_SEMAPHORE                   (NWERR_SYNC | 0x00000100L)
#define NWERR_SEMAPHORE_OVERFLOW          (NWERR_SEMAPHORE | 0x00000001L)
#define NWERR_SEMAPHORE_INVALID_NAM_LEN   (NWERR_SEMAPHORE | \
                                           NWERR_INVALID_NAME_LEN)
#define NWERR_SEMAPHORE_TIMEOUT_FAILURE   (NWERR_SEMAPHORE | \
                                           NWERR_TIMEOUT_FAILURE)
#define NWERR_SEMAPHORE_INVALID_CONNECTION_ID	(NWERR_SEMAPHORE | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_SEMAPHORE_INVALID_NCP_PACKET_LENGTH (NWERR_SEMAPHORE | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_SEMAPHORE_SETTING_UP_TIMEOUT		(NWERR_SEMAPHORE | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_SEMAPHORE_TRANSPORT_SEND			(NWERR_SEMAPHORE | \
													NWERR_TRANSPORT_SEND
#define NWERR_SEMAPHORE_IN_SETTING_SIGNALS		(NWERR_SEMAPHORE | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_SEMAPHORE_INVALID_PARAMETER_LENGTH	(NWERR_SEMAPHORE | \
													0x00001001L)



#define NWERR_TTS                         0x00290000L
#define NWERR_TTS_SERVER_OUT_OF_MEMORY    (NWERR_TTS |  \
                                           NWERR_SERVER_OUT_OF_MEMORY)
#define NWERR_TTS_NO_CONSOLE_RIGHTS       (NWERR_TTS |  \
                                           NWERR_NO_CONSOLE_RIGHTS)
#define NWERR_TTS_IMPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_RECORDS_STILL_LOCKED    (NWERR_TTS | 0x000000FEL)
#define NWERR_TTS_NO_EXPL_TRANS_ACTIVE    (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_EXPLICIT_TRANS_ACTIVE   (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_TRANS_NOT_WRITTEN       (NWERR_TTS | 0x000000FFL)
#define NWERR_TTS_INVALID_CONNECTION_ID	(NWERR_TTS | \
											NWERR_INVALID_CONNECTION_ID)
#define NWERR_TTS_INVALID_NCP_PACKET_LENGTH (NWERR_TTS | \
										NWERR_INVALID_NCP_PACKET_LENGTH)
#define NWERR_TTS_SETTING_UP_TIMEOUT		(NWERR_TTS | \
											NWERR_SETTING_UP_TIMEOUT)
#define NWERR_TTS_TRANSPORT_SEND			(NWERR_TTS | \
													NWERR_TRANSPORT_SEND
#define NWERR_TTS_IN_SETTING_SIGNALS		(NWERR_TTS | \
												NWERR_IN_SETTING_SIGNALS
#define NWERR_TTS_INVALID_PARAMETER_LENGTH	(NWERR_TTS | 0x00001001L)


/*======================================================================
                       Server-Returned Error Codes
========================================================================
*/
#define	NWERR_OUT_OF_DISK_SPACE				0x00000001L
#define	NWERR_BAD_SRCH_DRIVE_VECTOR			0x00000001L
#define	NWERR_VERSION_TOO_LOW				0x00000001L
#define NWERR_SFT_LEVEL_TOO_LOW				0x00000002L
#define NWERR_TTS_LEVEL_TOO_LOW				0x00000004L
#define NWERR_AFP_LEVEL_TOO_LOW				0x00000008L
#define NWERR_INVALID_DRIVE_NUM				0x00000020L
#define NWERR_NO_MORE_RESTRICTIONS			0x00000024L
#define NWERR_NO_DRIVES_AVAILABLE			0x00000025L
#define NWERR_WS_DOES_NOT_SUPPORT			0x00000030L
#define NWERR_LOCK_FAIL						0x00000080L
#define NWERR_FILE_IN_USE					0x00000080L
#define NWERR_NO_MORE_FILE_HANDLES			0x00000081L
#define NWERR_NO_OPEN_PRIVILEGES			0x00000082L
#define NWERR_IO_ERROR_NETWORK_DISK			0x00000083L
#define NWERR_NO_CREATE_PRIVILEGES			0x00000084L
#define NWERR_NO_CREATE_DELETE_PRIVILEGES	0x00000085L
#define NWERR_CREATE_FILE_EXISTS_READ_ONLY	0x00000086L
#define NWERR_CREATE_ERROR					0x00000087L
#define NWERR_WILD_CARDS_IN_CREATE_FILE_NAM	0x00000087L
#define NWERR_CREATE_FILE_NAME				0x00000087L
#define	NWERR_INVALID_FILE_HANDLE			0x00000088L
#define NWERR_NO_SEARCH_PRIVILEGES			0x00000089L
#define NWERR_NO_DELETE_PRIVILEGES         	0x0000008AL
#define NWERR_NO_RENAME_PRIVILEGES			0x0000008BL
#define NWERR_NO_MODIFY_PRIVILEGES         	0x0000008CL
#define NWERR_ENTRY_IN_USE                 	0x0000008DL
#define NWERR_SOME_FILES_AFFECTED_IN_USE	0x0000008DL
#define NWERR_ALL_FILES_IN_USE				0x0000008EL
#define NWERR_NO_FILES_AFFECTED_IN_USE		0x0000008EL
#define NWERR_SOME_FILES_AFFECTED_READ_ONLY	0x0000008FL
#define NWERR_ALL_READ_ONLY					0x00000090L
#define NWERR_NO_FILES_AFFECTED_READ_ONLY	0x00000090L
#define NWERR_SOME_FILES_RENAMED_NAME_EXIST 0x00000091L
#define NWERR_NO_FILES_RENAMED_NAME_EXISTS  0x00000092L
#define NWERR_NO_READ_PRIVILEGES			0x00000093L
#define NWERR_NO_WRITE_PRIVILEGES			0x00000094L
#define NWERR_FILE_DETACHED					0x00000095L 
#define NWERR_SERVER_OUT_OF_MEMORY         	0x00000096L 
#define NWERR_NO_DISK_SPACE_FOR_SPOOL_FILE	0x00000097L
#define NWERR_VOL_DOES_NOT_EXIST           	0x00000098L 
#define NWERR_BAD_VOL_NUM   	        	0x00000098L 
#define NWERR_DIR_FULL                     	0x00000099L 
#define NWERR_INVALID_NAME                 	0x00000099L 
#define NWERR_RENAMING_ACROSS_VOLUMES		0x0000009AL
#define NWERR_BAD_DIR_HANDLE               	0x0000009BL
#define NWERR_INVALID_PATH                 	0x0000009CL
#define NWERR_NO_MORE_TRUSTEES				0x0000009CL
#define NWERR_NO_MORE_DIRECTORY_HANDLES		0x0000009DL
#define NWERR_BAD_FILE_NAME					0x0000009EL
#define NWERR_INVALID_FILE_NAME				0x0000009EL
#define NWERR_DIRECTORY_ACTIVE				0x0000009FL
#define NWERR_DIRECTORY_NOT_EMPTY			0x000000A0L
#define NWERR_DIRECTORY_IO_ERROR			0x000000A1L
#define NWERR_READ_FILE_WITH_RECORD_LOCKED	0x000000A2L
#define NWERR_NO_ACCOUNT_PRIVILEGES		   	0x000000C0L
#define NWERR_NO_ACCOUNT_BALANCE			0x000000C1L
#define NWERR_CREDIT_LIMIT_EXCEEDED			0x000000C2L
#define NWERR_LOGIN_DENIED_NO_CREDIT_LIMIT	0x000000C2L
#define NWERR_TOO_MANY_HOLDS				0x000000C3L
#define NWERR_USER_ACCOUNT_DISABLED			0x000000C4L
#define NWERR_INTRUDER_DETECTION_LOCK		0x000000C5L
#define NWERR_LOGIN_LOCKOUT					0x000000C5L
#define NWERR_NO_CONSOLE_OPERATOR_RIGHTS  	0x000000C6L
#define NWERR_QUEUE_ERROR					0x000000D0L
#define NWERR_NO_QUEUE                      0x000000D1L
#define NWERR_NO_QUEUE_SERVER               0x000000D2L
#define NWERR_NO_QUEUE_RIGHTS               0x000000D3L
#define NWERR_QUEUE_FULL                    0x000000D4L
#define NWERR_NO_JOB    		            0x000000D5L
#define NWERR_NO_JOB_RIGHTS    			    0x000000D6L
#define NWERR_UNENCRYPTED_PASSWORD			0x000000D6L
#define NWERR_ACCOUNT_BAD					0x000000D7L
#define NWERR_PASSWORD_NOT_UNIQUE			0x000000D7L
#define NWERR_QUEUE_SERVICING				0x000000D7L
#define NWERR_PASSWORD_TOO_SHORT			0x000000D8L
#define NWERR_QUEUE_NOT_ACTIVE				0x000000D8L
#define NWERR_MAXIMUM_LOGINS_EXCEEDED		0x000000D9L
#define NWERR_LOGIN_DENIED_NO_CONNECTION	0x000000D9L
#define NWERR_QUEUE_PASSWORD_TOO_SHORT		0x000000D9L
#define NWERR_BAD_LOGIN_TIME				0x000000DAL
#define NWERR_UNAUTHORIZED_LOGIN_TIME		0x000000DAL
#define NWERR_QUEUE_HALTED					0x000000DAL
#define NWERR_LOG_STATION_ERROR				0x000000DBL
#define NWERR_UNAUTHORIZED_LOGIN_STATION	0x000000DBL
#define NWERR_MAX_QUEUE_SERVERS				0x000000DBL
#define NWERR_ACCOUNT_DISABLED				0x000000DCL
#define NWERR_BAD_PASSWORD					0x000000DEL
#define NWERR_PASSWORD_HAS_EXPIRED_NO_GRACE	0x000000DEL
#define NWERR_OLD_PASSWORD					0x000000DFL
#define NWERR_NO_DISK_TRACK					0x000000E7L
#define NWERR_WRITE_PROPERTY_TO_GROUP		0x000000E8L
#define NWERR_NOT_ITEM_PROPERTY				0x000000E8L
#define NWERR_MEMBER_ALREADY_EXISTS			0x000000E9L
#define NWERR_NO_SUCH_MEMBER				0x000000EAL
#define NWERR_NOT_SET_PROPERTY				0x000000EBL
#define	NWERR_NO_SUCH_SET					0x000000ECL
#define	NWERR_NO_SUCH_SEGMENT				0x000000ECL
#define NWERR_PROPERTY_ALREADY_EXISTS		0x000000EDL
#define	NWERR_OBJECT_ALREADY_EXISTS			0x000000EEL
#define NWERR_ILLEGAL_NAME					0x000000EFL
#define NWERR_ILLEGAL_WILDCARD				0x000000F0L
#define NWERR_WILDCARD_NOT_ALLOWED			0x000000F0L
#define NWERR_MALFORMED_NCP_PACKET			0x000000F0L
#define NWERR_INVALID_BINDERY_SECURITY		0x000000F1L
#define NWERR_NO_OBJECT_READ_PRIVILEGE     	0x000000F2L
#define NWERR_NO_OBJECT_RENAME_PRIVILEGE	0x000000F3L
#define NWERR_NO_OBJECT_DELETE_PRIVILEGE	0x000000F4L
#define NWERR_NO_OBJECT_CREATE_PRIVILEGE	0x000000F5L
#define NWERR_NO_PROPERTY_DELETE_PRIVILEGE	0x000000F6L
#define NWERR_NOT_SAME_LOCAL_DRIVE			0x000000F6L
#define NWERR_NO_PROPERTY_CREATE_PRIVILEGE	0x000000F7L 
#define NWERR_TARGET_DRIVE_NOT_LOCAL		0x000000F7L
#define NWERR_NO_PROPERTY_WRITE_PRIVILEGE	0x000000F8L
#define NWERR_ALREADY_ATTACHED_TO_SERVER	0x000000F8L
#define NWERR_NOT_ATTACHED_TO_SERVER		0x000000F8L
#define NWERR_NO_PROPERTY_READ_PRIVILEGE	0x000000F9L
#define NWERR_NO_MORE_PROP_VALS				0x000000F9L
#define NWERR_NO_MORE_SERVER_SLOTS			0x000000FAL
#define NWERR_TEMP_REMAP_ERROR				0x000000FAL
#define NWERR_INVALID_PARAMETERS           	0x000000FBL 
#define NWERR_NOT_386_FILE_SYSTEM          	0x000000FBL 
#define NWERR_NO_MORE_PROPERTIES          	0x000000                                                                                                                                                                                                                                                                           = $      PWRKV50F1050.G                 S}( > [NW.KIT.AEXE]NWERRORS.H;1                                                                                                      I     K                         X      4       FBL 
#define NWERR_NO_SUCH_PROPERTY          	0x000000FBL 
#define NWERR_INTERNET_PACKET_REQT_CANCELED	0x000000FBL 
#define NWERR_SEMAPHORE_INVALID_PARAMETERS 	0x000000FBL 
#define NWERR_SYNC_INVALIDE_PARAMETERS     	0x000000FBL 
#define NWERR_NO_SUCH_OBJECT	          	0x000000FCL
#define NWERR_NO_MORE_OBJECTS	          	0x000000FCL
#define NWERR_UNKNOWN_FILE_SERVER			0x000000FCL
#define NWERR_MESSAGE_QUEUE_FULL			0x000000FCL
#define NWERR_BAD_STATION_NUMBER			0x000000FDL
#define NWERR_INVALID_PACKET_LENGTH			0x000000FDL
#define NWERR_TTS_DISABLED					0x000000FDL
#define NWERR_UNKNOWN_REQUEST				0x000000FDL
#define NWERR_TIMEOUT_FAILURE              	0x000000FEL
#define NWERR_INVALID_NAME_LEN             	0x000000FEL
#define NWERR_BINDERY_LOCKED				0x000000FEL
#define NWERR_DIRECTORY_LOCKED				0x000000FEL
#define NWERR_INVALID_SEMAPHORE_NAME_LENGTH 0x000000FEL
#define NWERR_IMPLICIT_TRANS_ACTIVE			0x000000FEL
#define NWERR_NO_SUCH_RESTRICTION			0x000000FEL
#define NWERR_PACKET_NOT_DELIVERABLE		0x000000FEL
#define NWERR_RECORDS_STILL_LOCKED			0x000000FEL
#define NWERR_SERVER_BINDERY_LOCKED			0x000000FEL
#define NWERR_SOCKET_TABLE_FULL				0x000000FEL
#define NWERR_SPOOL_DIRECTORY_ERROR			0x000000FEL
#define NWERR_SUPERVISOR_HAS_DISABLED_LOGIN 0x000000FEL
#define NWERR_ENTRY_NOT_FOUND              	0x000000FFL
#define NWERR_NO_FILES_FOUND               	0x000000FFL
#define NWERR_BAD_PRINTER_ERROR				0x000000FFL
#define NWERR_BAD_RECORD_OFFSET				0x000000FFL
#define NWERR_CLOSE_FCB_ERROR				0x000000FFL
#define NWERR_ENTRY_EXISTS					0x000000FFL
#define NWERR_ENTRY_NOT_FOUND				0x000000FFL
#define NWERR_EXPLICIT_TRANS_ACTIVE			0x000000FFL
#define NWERR_FILE_ALREADY_EXISTS			0x000000FFL
#define NWERR_FILE_EXTENSION_ERROR			0x000000FFL
#define NWERR_FILE_NAME_ERROR				0x000000FFL
#define NWERR_HARDWARE_FAILURE				0x000000FFL
#define NWERR_INVALID_DRIVE_NUMBER			0x000000FFL
#define NWERR_INVALID_INITIAL_SEMAPHORE_VAL 0x000000FFL
#define NWERR_INVALID_SEMAPHORE_HANDLE		0x000000FFL
#define NWERR_IO_BOUND_ERROR				0x000000FFL
#define NWERR_NO_EXPLICIT_TRANS_ACTIVE		0x000000FFL
#define NWERR_NO_FILES_FOUND_ERROR			0x000000FFL
#define NWERR_NO_MORE_FILES_FOUND			0x000000FFL	
#define NWERR_NO_RESPONSE_FROM_SERVER		0x000000FFL
#define NWERR_NO_SUCH_OBJECT_OR_BAD_PASSWORD 0x000000FFL
#define NWERR_OPEN_FILES					0x000000FFL
#define NWERR_PATH_NOT_LOCATABLE			0x000000FFL
#define NWERR_QUEUE_FULL_ERROR				0x000000FFL
#define NWERR_REQUEST_NOT_OUTSTANDING		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_VALUE		0x000000FFL
#define NWERR_SEMAPHORE_INVALID_HANDLE		0x000000FFL
#define NWERR_SOCKET_ALREADY_OPEN			0x000000FFL
#define NWERR_SYNC_LOCK_FAILURE				0x000000FFL
#define NWERR_SYNC_ENTRY_NOT_FOUND			0x000000FFL
#define NWERR_SYNC_RECORD_NOT_FOUND			0x000000FFL
#define NWERR_TRANS_NOT_WRITTEN				0x000000FFL
#define NWERR_TTS_NOT_AVAILABLE				0x000000FFL

/*======================================================================
                   Client Generated - Returned Error Codes
========================================================================
*/
#define NWERR_INVALID_CONNECTION_ID						0x00000030L
#define NWERR_INVALID_NCP_PACKET_LENGTH 				0x00000031L
#define NWERR_SETTING_UP_TIMEOUT					 	0x00000032L
#define NWERR_TRANSPORT_SEND						 	0x00000033L
#define NWERR_IN_SETTING_SIGNALS					 	0x00000034L
#define NWERR_NO_RESPONSE_FROM_SERVER					0x000000FFL

#endif
                                                                                                                                                                                        * [NW.KIT.AEXE]PWRK$NETWARE.SAV;1 +  , 5  .     /     4   $           $               - >  0   1    2   3      K   P   W   O     5   6 ݽ#yD  7 $HD  8          9          G    H  J                                             < $      PWRK$NETWARE.SAV                                                                                                                                                                                                             PWRK$NETWARE.SAVt  BACKUP/NOASSIST/INTER/LOG/VERIFY NW$BLD_SEARCH:[PWRK$NWROOT...]*.*; [.AEXE]PWRK$NETWARE.SAV/SAVE/BLOCK=9000/GROUP=25  PWBUILD            #yD      V6.1 	 _KAZAM:: 
      _$1$DUA2000:  V6.1 
  $       (              * [PWRK$NWROOT]NETWARE.DIR;1 +  ,   . !    /     4    !                      -    0   1    2   3     K  P   W   O "    5   6 mEyD  7 2"yD  8          9          G    H  J  I                 CONF_FILES.DIR                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  % * [PWRK$NWROOT.NETWARE]CONF_FILES.DIR;1 +  ,   . !    /     4    !                      -    0   1    2   3     K  P   W   O "    5   6 (yD  7 
y"yD  8          9          G    H   J  I                       PWVN$CONFIG_ENG.HELP     PWVN$MSGS_ENG.DAT  O    PWVN$NWCONFIG0.CFG .    PWVN$NWCONFIG3.CFG     PWVN$NWCONFIG5.CFG     PWVN$NWCONFIG7.CFG     PWVN$NWCONFIG9.CFG     PWVN$NWPRINT.CFG O  "  PWVN$SCONSOLE_ENG.HELP .                                                                                                                                                                                                                                         6 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1 +  ,   . B    /     4 P   B   ,                     -    0   1    2   3      K  P   W   O C    5   6 7{]vD  7 0ޡ"yD  8          9          G    H   J                          # L # Copyright 1989, 1991 Unpublished Work of Novell, Inc. All Rights Reserved. # > # THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, A # PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS ? # TO THIS WORK IS RESTRICTED TO (I) NOVELL EMPLOYEES WHO HAVE A 9 # NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR : # ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL WHO HAVE' # ENTERED INTO APPROPRIATE AGREEMENTS.  9 # NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED, ? # COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED, ; # CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, : # TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT: # OF NOVELL.  ANY USE OR EXPLOITATION OF THIS WORK WITHOUT= # AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND  # CIVIL LIABILITY. # ; #    @(#)cmd/sconsole/help/config_help 1.7 (Novell) 7/29/91  #    # 	 # Format:  #  #	<offset-number>  #	<number-fields>  #	1 <field-1-text-1> #	1 <field-1-text-2> #	1 <field-1-text-3> #		. #		. #		. #	n <field-n-text-1> #	n <field-n-text-2> #	n <field-n-text-3> #		. #		. #		. # D # See "sconsole.h" for offset numbers and consult the menu structure$ # definitions for the field numbers. # D # The first line determines the left justification of all additional4 # lines, so try to make it the longest of the 3. JAA #    # EDIT_GEN_OFF  (110)  110  19 1 C 1 Spawn ahead processes indicates the number of NetWare "NW_ENGINE" / 1 to be started when the NetWare server starts.    2 F 2 Maximum number of processes indicates the maximum number of NetWare 6 2 "NW_ENGINE" process that can be running at one time.   3 E 3 Clients per process indicates the maximum number of NetWare clients 7 3 that can be attached to a single "NW_ENGINE" process.    4 H 4 Max Connections indicates the maximum number of users that can connect 4 to the NetWare server.   5 E 5 Max Volumes indicates the maximum number of volumes allowed on the  	 5 system.    6 ) 6 Server Name is the name of your server.  6    7 @ 7 Network number is the number assigned to your NetWare network. 7    8 B 8 Directory Cache Flag indicates if NetWare sh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         ! "     
       ould put directories 8 in memory on the system.   9 F 9 File Cache Flag indicates if NetWare should put file entries in the  9 memory on the system.   C 10 Save Deleted Files indicates if files deleted by NetWare will be F 10 removed from the system or only marked for deletion by a subsequent 10 purge command.    11G 11 Saved File Location indicates the location where deleted files would  11 be saved.   12E 12 TTS Flag indicates if Transaction Tracking is turned on. (TTS will & 12 be implemented in future releases.)   13H 13 TTS Backout File location indicates the location where backout files = 13 associated with a terminated transaction would be located.    14E 14 Console Flag indicates if system error messages will be written to  14 the system console.   15> 15 Track on Flag indicates if tracking is currently on or off. 15   16@ 16 Login Flag indicates if logins are enabled when the server is 16 started.    17B 17 Capture Flag indicates if data capture is to be configured into& 17 the system when NetWare is started.   18 18 18   19? 19 Cache Block Size indicates the block size to be used for the  19 cache in shared memory.     # EDIT_VOL_OFF (120) 120  8  1 ' 1 Enter the name of the NetWare Volume. ! 1 Can be from 2 to 15 characters.    = 2 Enter the OpenVMS Directory path for the NetWare Volume. If : 2 the optional Hybrid Volume does not already exist, enter1 2 'Hybrid Volume' here if you wish to create one.     L 3 CHECK = Always check OpenVMS and PATHWORKS for OpenVMS (NetWare) security.@ 3 NOCHECK = Only check PATHWORKS for OpenVMS (NetWare) security.J 3 CONDITIONAL = Check OpenVMS security if file was not created by NetWare.  = 4 Specifies the OpenVMS file protection mask applied to newly ; 4 created files.  Enter 'RMS Default' to propagate the Host > 4 file protection as applied to the current OpenVMS directory.   B 5 Specifies the OpenVMS directory protection mask applied to newlyA 5 created directories.  Enter 'RMS Default' to propagate the Host C 5 directory protection as applied to the current OpenVMS directory.    6 @ 6 Record type can be STREAM, FIXED, or FIXED:n.  If no value is + 6 specified the default FIXED length is 80.   G 7 Deferred File Close option is either ACTIVE or INACTIVE.  The value,  : 7 in seconds, is set in the File Services Configuration -   7 File Services Parameters menu.  F # remove these comments and change the following block to start with 9J # rather then 8 when SHARE_LM comes back ... Also, change the number under* # EDIT_VOL_OFF above to be 9 rather than 8F #8 Applies to volume sharing with other PATHWORKS for OpenVMS servers.J #8 ACTIVE = Volume is shared between PATHWORKS LanMan and NetWare servers.A #8 INACTIVE = Volume is not shared with PATHWORKS LanMan servers.   D 8 Applies to clustered PATHWORKS for OpenVMS (NetWare) servers only.> 8 ACTIVE = Volume is available to all servers in this cluster.< 8 INACTIVE = Volume is available to only the current server.   # EDIT_SYS_OFF (130) 130  17E 1 Shared Memory Size indicates the amount of shared memory to be used D 1 by NetWare.  The recommended value in the documentation should not
 1 be changed.    2 M 2 Server Name is the name of the PATHWORKS for OpenVMS (NetWare) File Server.  2    3 ; 3 Console Flag indicates whether to send error messages to   3 the OpenVMS system console.    4 = 4 Console Device indicates the OpenVMS system console device. % 4 /dev/console is equivalent to OPA0:    5 A 5 Priority is the OpenVMS priority assigned to NetWare processes.  5   I 6 Specifies AST queue limit for the OpenVMS NetWare File Server process,  G 6 The AST queue limit is the maximum number of asynchronous system trap < 6 (AST) operations that can be outstanding at any one time.   G 7 Specifies a buffered I/O count limit.  The buffered I/O count is the  G 7 maximum number of buffered I/O operations that can be outstanding at   7 any one time.    G 8 Specifies the lock queue limit.  The lock queue limit is the maximum  H 8 number of locks that can be queued by the OpenVMS NetWare File Server  8 process at one time.     9 E 9 The open file limit is the maximum number of files that can be open : 9 by the OpenVMS NetWare File Server process at one time.    10L 10 JTquota refers to the size (in bytes) of the OpenVMS NetWare File Server = 10 process Job Table, for process or job level logicals, etc.   A 11 Specifies the paging file limit.  The paging file limit is                                                                                                                                                                             $      PWRK$NETWARE.SAV                 6[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1                                                                         P     B                         ; "            the G 11 maximum number of pages that the OpenVMS NetWare File Server process % 11 can use in the system paging file.   E 12 Specifies the subprocess creation limit.  The subprocess creation  E 12 limit is the maximum number of subprocesses that can exist at one  4 12 time for the OpenVMS NetWare File Server process.  E 13 Specifies the total number of entries in the timer queue, plus the G 13 number of temporary common event flags that the OpenVMS NetWare File ' 13 Server process can have at one time.   D 14 Specifies the default working set size.  The default working set D 14 size represents the default number of physical pages the process  14 can use.   H 15 Specifies the working set extent.  The working set extent represents L 15 the absolute limit of physical memory allowed to the OpenVMS NetWare File 15 Server process.  G 16 Specifies the working set quota.  The working set quota is the limit H 16 for the amount of physical memory for the OpenVMS NetWare File Server 16 process.   D 17 Cluster Flag indicates whether the product was installed with theD 17 cluster support option.  This flag is set during installation and 17 is not modifiable.    # SRV_INFO_OFF (140) 140  10 1 . 1 Server name is the name of your file server. 1    2 C 2 Version name displays the NetWare version running on your server.  2    3 8 3 Revision date displays when this version was released. 3    4 C 4 Maximum connections supported displays the number of clients that - 4 can be logged into your server at one time.    5 B 5 Connections in use displays the number of users currently logged 5 into your server.    6 B 6 Peak connections used displays the largest number of users that ; 6 have been logged into the server since it was brought up.    7 B 7 Maximum volumes supported displays the maximum number of NetWare( 7 volumes that your file server can use.   8 ; 8 Revision level displays the level of patches to your file 	 8 server.    9 = 9 SFT level displays what level of System Fault Tolerance is   9 running on your file server.   10< 10 TTS level displays what level of the Transaction Tracking) 10 System is running on your file server.    # SRV_STATS_OFF (150)  150  18 1 = 1 NWProcs displays the number of NetWare processes currently   1 running on your file server.   2 @ 2 Total Packets is the total number of packets received by your & 2 file server since it was brought up.   3 C 3 Create connection requests displays the number of users that have A 3 logged into or attached to your server since it was brought up.    4 B 4 Create file request displays the number of requests to create a ; 4 file serviced by the file server since it was brought up.    5 B 5 File open requests displays the number of requests to open files' 5 since the file server was brought up.    6 B 6 File read requests displays the number of requests to read files' 6 since the file server was brought up.    7 D 7 File write requests displays the number of requests to write files' 7 since the file server was brought up.    8 C 8 Number of open files displays the number of files currently open.  8    9 C 9 Maximum simultaneous open files shows the maximum number of files : 9 opened at one time since the file server was brought up.   10B 10 Lost packet resends refers to the number packets that had to be 10 "resent" to the server.   11B 11 Cache hits refers to the number of successful attempts to read 1 11 files or directories residing in cache memory.    12D 12 Cache hits refers to the number of unsuccessful attempts to read 1 12 files or directories residing in cache memory.h   13A 13 Print requests refers to the number of print jobs submitted toL 13 the file server.N   14D 14 Message request refers to the number of messages sent to the file
 14 server.   15D 15 Directo                                                                                                                                                                                                                                                   	                        c $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         <             ry requests refers to the number of requests for directory, 15 information serviced by the file servers.   16E 16 Bindery and miscellaneous requests refers to the number of binderyA( 16 requests serviced by the file server.   17A 17 Semaphore requests refers to the number of semaphore requests D 17 serviced by the file server.    18D 18 Unknown requests refers to the number of unknown requests made to 18 the server.   # TTS_STATS_OFF (160)N 160  7F 1V@ 1 TTS request refers to the total number of Transaction Tracking 1 requests made to the server.   2IC 2 Transactions performed refers to the total number of transactions_1 2 performed since the file server was brought up.    3o= 3 Transaction writes performed refers to the total number of fD 3 transaction writes completed since the file server was brought up.   4>< 4 Transaction backouts refers to the number of transactions 8 4 "backed out" or rolled back to their beginning state.    5uA 5 Unfilled Backout Requests refers to backout requests that couldi 5 not be completed.t   6iG 6 Number of transactions refers to the number of transactions currently  6 running on the file server.1   7 C 7 Maximum simultaneous transactions refers to the maximum number of C 7 transactions running at one time since the server was brought up.    # LOCK_MGR_OFF (170) 170  12 1eE 1 Logical lock requests displays the number of logical lock requests n 1 made to the server.    2e> 2 Number of logical locks displays the number of logical locks 2 currently in place.d   3 D 3 Maximum simultaneous logical locks refers to the maximum number ofF 3 logical locks occurring at one time since the server was brought up.   4 C 4 File lock requests displays the number of file lock requests madey 4 to the server.   5N8 5 Number of file locks displays the number of file locks 5 currently in place.e   6yA 6 Maximum simultaneous file locks refers to the maximum number of C 6 file locks occurring at one time since the server was brought up.i   7cF 7 Physical lock requests displays the number of physical lock requests 7 made to the server.v   8e@ 8 Number of physical locks displays the number of physical locks 8 currently in place.n   9rE 9 Maximum simultaneous physical locks refers to the maximum number oflG 9 physical locks occurring at one time since the server was brought up..   10? 10 Semaphore requests displays the number of semaphore requestsS 10 made to the server.   118 11 Number of semaphore displays the number of semaphore  11 currently in place.   12A 12 Maximum simultaneous semaphore refers to the maximum number oftC 12 semaphore occurring at one time since the server was brought up.e     # VOL_STATS_OFF (180)  180l 1 A 1 This screen displays the number of active NetWare volumes, the .E 1 amount in K-bytes of disk space that are used by that volume, stilleC 1 free on that volume, and the number of directories used and free.s   # CONN_STATS_OFF (190) 190s 1e 1h? 1 This screen displays the number of users currently connected n 1 to the server.   # DATACAPTURE_OFF (200)9 200e 10 1rA 1 File name is the name of the file in which to store the capturee 1 data.e   2 < 2 Maximum file size is the maximum size of the capture file. 2n   3iD 3 Maximum packet size is the maximum number of bytes to be retrieved 3 for each packet.   4e@ 4 Read only captures only those packets coming into this server. 4    5a= 5 Write only captures only those packets leaving this server.  5O   6 D 6 Address filter captures only those packets which are received from, 6 or a      "       re destined for the address specified.   7 D 7 Network filter captures only those packets which are received from, 7 or are destined for the network specified.   8aC 8 Socket filter captures only those packets which are received fromi+ 8 or are destined for the socket specified.r   9tF 9 Packet filter captures only those packets which are of the specified 9 packet type.   10E 10 The logical OR flag allows the filters to be ORed together instead  10 of the default logical AND.   # EDIT_NVT_OFF (210) 210o 6l 1i= 1 NVT Flag indicates if remote login is to be configured intoF% 1 the system when NetWare is started.A   2.9 2 Server Name that this machine will be known as for NVT.o 2g   3o6 3 NVT Getty Entry is the baud rate for the NVT gettys. 3m   4 ? 4 NVT Init Level is the machine run level for NVT to be active.h 4S   5L2 5 NVT Spawns is the number of NVT gettys to spawn. 5V   6FF 6 NVT Line Discipline is the line discipline to use from the gettydefs 6 file.o   # MISC_OFF (220) 220T 3  1o2 1 Enter the file name of the data capture to view. 1v   2 . 2 Enter the name of the file in which you wish( 2 to save the current server statistics.   3TA 3 The sample interval is the delay for refreshes on the statistica
 3 screens.   # EDIT_TRAN_OFF (230). 230N                                                                                                                                                                                                                                                                            W $      PWRK$NETWARE.SAV                 6[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$CONFIG_ENG.HELP;1                                                                         P     B                         i             16D 1 Internal Network Number is a unique eight digit hexadecimal numberC 1 between 0x00000001 and 0xFFFFFFFE (inclusive). This number should 8 1 not be duplicated on any network on your internetwork.  A 2 Service Advertising Protocol daemon should be started when the sC 2 protocol stack is brought up.  This should be ACTIVE. This daemon @ 2 assists in advertising and collecting services on the network.  C 3 This dictates how long this server will wait before answering to eB 3 a Get Nearest Server Request (GNS).  If this is your only serverE 3 set to 0 otherwise set to a value greater than 0 and less than 300.s  = 4 This device/file will receive all standard output from the e= 4 sap daemon.  Standard output includes track messages.  This 0 4 should be set to the console device or a file.  = 5 This device or file will receive all error output from the d= 5 sap daemon.  If the SAP daemon encounters any errors duringu6 5 operation it will write them to this device or file.  = 6 SPX - Sequenced Packet eXchange driver flag.  If active thee8 6 Novell Protocol Suite Daemon will link the driver into" 6 the protocol stack upon startup.  7 7 This flag will cause the Novell Protocol Suite daemonf: 7 to link the NETBIOS driver into the protocol stack upon 
 7 startup.  A 8 This is the name a module that converts NETBIOS request packetsrA 8 into requests to the underlying transport service.  This shouldo( 8 be set to nbix for operation over IPX.  ? 9 The Network Number is a unique eight digit hexadecimal numberiC 9 between 0x00000001 and 0xFFFFFFFE (inclusive). This number should 8 9 not be duplicated on any network on your internetwork.   10+ 10 Good Luck!!  Nothing is acceptable here.T 10   111 11 How did you ever get passed the Adapter field?u 11 Enter the net_type here.o   12  12 Enter the PPA.  Join the PTA. 12   13 13 Enter the If_name here. 13   14 14 Enter the Net_Frame here. 14   15 15 Enter the net module here.m 15   16$ 16 Enter the Network Number you wish  16 removed from the file server.   # EDIT_AT_OFF (250)t 250f 5tA 1 If set to active, then the protocol stack daemon will cause theeA 1 AppleTalk protocol modules to be activated on startup.  This isS, 1 required in order to provide AFP services.   2xB 2 The host file system path name of the network link device driver 2 interface, such as /dev/en0.   3 = 3 The type of the network link device, such as ETHERNET_DLPI.t 3o   4 < 4 For DLPI device drivers, the physical point of attachment.$ 4 This is usually the unit selector.   5CC 5 The name of an option module to be pushed between the link devicec8 5 driver and the bottom of the AppleTalk protocol stack.   # EDIT_AFP_OFF (260) 260  4  1R= 1 If set to active, then AFP services will be provided by theu2 1 NetWare service engines when NetWare is started.  C 2 The name of the AFP server.  It may be different that the name ofi@ 2 the NetWare server, and only needs to conform to AFP/Macintosh 2 name restrictions.   3eG 3 Indicates if NetWare encryption is required for NetWare for Macintosh  3 utilities.   4 E 4 Indicates if the "false descendants" performance improvement shouldr 4 be employed.   # EDIT_FILE_OFF (280)s 280l 9e 1n? 1 Specify the Account Name, in the User Authorization File, for F 1 OpenVMS security validatio                                                                                                                                                                                                                                   
                         0 $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                          "     ,       n of non-hybrid NetWare user transactions.  E 2 Specify the value for the deferred file close option.  The deferrediD 2 close flag (ACTIVE/INACTIVE) is volume specific and is selected in7 2 the File Services Configuration Menu - Edit a Volume.a   3s8 3 Specify the default NetWare/OpenVMS security algorithm. 3 to be enforced: CHECK, NOCHECK, CONDITIONAL.  ? 4 Specify the default RMS file type applied to files created in A 4 NetWare volumes.  Record type can be STREAM, FIXED, or FIXED:n.r; 4 If no value is specified, the default FIXED length is 80.t   5t> 5 Specify the maximum number of open files allowed per client.* 5 Can range from 20 to 200, default is 50.   6e5 6 Specify the maximum number of connections (clients)d1 6 for the PATHWORKS for OpenVMS (NetWare) server.h   7 5 7 Specify the maximum number of NetWare volumes to beq: 7 supported by the PATHWORKS for OpenVMS (NetWare) server.  N 8 Applies to CONDITIONAL security check only.  If ACTIVE, OpenVMS security is P 8 not checked if file was created by a PATHWORKS for OpenVMS (NetWare) server.  P 8 If INACTIVE, VMS security is not checked if created by any PATHWORKS server.    J 9 If INACTIVE, only file names complying with DOS standards are accessibleM 9 through NetWare.  If ACTIVE, all OpenVMS file names are accessible, but ares5 9 transparently mapped to unique DOS compliant names.    # EDIT_SECURITY_OFF (290)e 290w 6h; 1 Set the Forced Logout Logging to ACTIVE if you want a logl> 1 entry made in the error log file whenever a client is logged 1 out by watchdog.  @ 2 Set the Forced Logout Display to ACTIVE if you want a message B 2 displayed on the console device whenever a client is logged out  2 by watchdog.   3hD 3 Set the Password Encryption Flag to ACTIVE to require all clients  3 to use encrypted passwords.i  C 4 Enter the login name of an additional NetWare user which you wish E 4 to receive alert messages from the file server.  SUPERVISOR and allM. 4 OPERATORS receive alert messages by default.  @ 5 Enter the name of the NetWare user which you wish removed from? 5 the alert message list.  SUPERVISOR and all OPERATORS receivet 5 alert messages by default.  J 6 Determines login status at startup.  If INACTIVE, login is denied to allJ 6 NetWare users except SUPERVISOR.  After the server is up, SUPERVISOR canJ 6 change the server login status with the FCONSOLE NetWare client utility.   # EDIT_HYBRID_OFF (300)u 300o 2n 1w2 1 Enter the NetWare login name of the hybrid user. 11   2 2 2 Enter the OpenVMS login name of the hybrid user. 2o   # EDIT_PS_OFF (310)  310u 8s 1d5 1 Enter the name of a NetWare print server previously 3 1 created with the PCONSOLE NetWare client utility.c   2 / 2 Enter the name of a NetWare file server which , 2 you wish the Host print server to service.   3 7 3 Enter the password assigned to the Host print server.o 3t   4 = 4 Enter the name of the NetWare queue residing on the NetWaren> 4 file server which you wish the Host print server to service.   5 < 5 Enter the name of a Host print server which was previously6 5 configured in the Host Print Server Assignment Menu.   6r4 6 Enter the name of the OpenVMS queue where the Host, 6 print server will send NetWare print jobs.  5 7 Enter the name of a NetWare form previously definedn4 7 with the PRINTDEF NetWare client utility which you- 7 wish to assign to an existing OpenVMS form.    8i? 8 Enter the name of an existing OpenVMS form which will be used ( 8 in place of the assigned NetWare form.   0a 0o                                                                                                                                                                                                                                                                                                                                                           3 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG.DAT;1 +  , O  . !    /     4    !    D                   -    0   1    2   3      K  P   W   O "    5   6 JuD  7 "yD  8          9          G    H   J                            
 0:ACTIVE 1:Dynamic Message String. N 2:PNWError(0x%X, %s):  PATHWORKS for OpenVMS (NetWare) must be run as root. G 3:PNWInform:  PATHWORKS for OpenVMS (NetWare) initialization started. + 4:PNWInform:  Initializing bindery files. H 5:PNWError(0x%X, %s):  A server is currently elsewhere in the cluster.7 6:PWVN$Error:  Function %s returned status of (0x%X). ( 7:PNWInform:  Invalid server name %s. C 8:PNWInform:  Shared memory size (%d) too small; converted to %d. > 9:PNWInform:  Maximum procs (%d) too small; converted to %d.E 10:PNWInform:  Maximum connections (%d) too small; converted to %d.rE 11:PNWInform:  Maximum connections (%d) too large; converted to %d.aA 12:PNWInform:  Maximum volumes (%d) too small; converted to %d.NA 13:PNWInform:  Maximum volumes (%d) too large; converted to %d. C 14:PNWInform:  Spawn ahead procs (%d) too small; converted to %d.rE 15:PNWInform:  Clients per process (%d) too small; converted to %d.o> 16:PNWInform:  Client stack (%d) too small; conv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          [ $      PWRK$NETWARE.SAV               O  3[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG.DAT;1                                                                                !                         $              erted to %d.9 17:PNWInform:  Priority (%d) too high; converted to %d.t8 18:PNWInform:  Priority (%d) too low; converted to %d.B 19:PNWInform:  Cache block size (%d) too small; converted to %d.B 20:PNWInform:  Cache block size (%d) too large; converted to %d.3 21:PNWInform:  Server name changed from %s to %s. < 22:PNWInform:  Volume %s assignment changed from %s to %s.6 23:PNWInform:  Network number changed from %X to %X.@ 24:PNWInform:  Log file size (%d) too small; converted to %d. I 25:PNWInform:  Print server loop delay (%d) too small; converted to %d. G 26:PNWInform:  Print server loop delay (%d) too big; converted to %d.n< 27:PNWInform:  Ulimit (0x%d) too small; converted to 0x%d.H 28:PNWInform:  Native locks requires 1 client per process; converted. I 29:PNWInform:  Nearest server response (%d) too small; converted to %d.gG 30:PNWInform:  Nearest server response (%d) too big; converted to %d.mC 31:PNWInform:  Salvage num files (%d) too small; converted to %d.tA 32:PNWInform:  Salvage num files (%d) too big; converted to %d.nT 33:PNWError(0x%X, %s):  NetWare account name not specified in configuration file. E 34:PNWError(0x%X, %s):  NetWare account name (%s) not found in UAF.P0 35:PNWError(0x%X, %s):  Volume %s not added.  8 36:PNWError(0x%X, %s):  Trustee volume %s not added.  > 37:PNWError(0x%X, %s):  Creating shared memory (%d bytes).  / 38:PNWError(0x%X, %s):  Creating semaphore.  17 39:PNWError(0x%X, %s):  Attaching to shared memory.  t. 40:PNWError(0x%X, %s):  Opening device %s.  8 41:PNWError(0x%X, %s):  Communication setup failure.  7 42:PNWError(0x%X, %s):  Invalid configuration file.  - 43:PNWError(0x%X, %s):  Creating process.  s? 44:PNWError(0x%X, %s):  Bad %s volume. Invalid directory: %s.e5 45:PNWError(0x%X, %s):  Asynchronous event setup.  dG 46:PNWError(0x%X, %s):  Duplicate volume assignments for %s and %s.  E 47:PNWInform:  Shm. size and server configuration are incompatible.:N 48:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) initialization complete.C 49:PNWInform:  Salvage max bytes (%d) too small; converted to %d.rA 50:PNWInform:  Salvage max bytes (%d) too big; converted to %d. ; 51:PNWInform:  File mask (0%o) too low; converted to 0%o.v@ 52:PNWInform:  Directory mask (0%o) too low; converted to 0%o.+ 53:PNWInform:  Server advertiser started.:S 54:PNWInform:  Server address: %02X%02X%02X%02X %02X%02X%02X%02X%02X%02X %02X%02XeH 55:PNWError(0x%X, %s):  Unable to open SERVER log file (%s) reason %d.* 56:PNWError(0x%X, %s):  Create file %s. ' 57:PNWInform:  Service Agent started. : 58:PNWError(0x%X, %s):  Initializing IPC/RPC facility.  4 59:PNWError(0x%X, %s):  Sending IPC/RPC message.  6 60:PNWError(0x%X, %s):  Receiving IPC/RPC messag                                                                                                                                                                                                                                                                           ] $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         O      =       e.  8 61:PNWError(0x%X, %s):  Destroying IPC/RPC facility.  ; 62:PNWInform:  Watchdog logged out %s from connection %d.e9 63:PNWInform:  Watchdog detached %s from connection %d.2: 64:PNWError(0x%X, %s):  System alloc failed (bytes: %d).6 65:PNWError(0x%X, %s):  Process memory heap corrupt.9 66:PNWInform:  Process memory usage reached %d percent.oC 67:PNWInform:  Process memory usage %d percent, please reconfige.s< 68:PNWInform:  Process memory exhausted (bytes wanted %d).A 69:PNWError(0x%X, %s):  Shared memory alloc failed (bytes: %d).R5 70:PNWError(0x%X, %s):  Shared memory heap corrupt. 8 71:PNWInform:  Shared memory usage reached %d percent.D 72:PNWInform:  Shared memory usage %d percent, please reconfigure.; 73:PNWInform:  Shared memory exhausted (bytes wanted %d).o' 74:PNWError(0x%X, %s):  List corrupt.s) 75:PNWError(0x%X, %s):  Adding to list.P- 76:PNWError(0x%X, %s):  Removing from list.e* 77:PNWError(0x%X, %s):  Destroying list.G 78:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) shutdown started.d; 79:PNWInform:  PATHWORKS for OpenVMS (NetWare) (%s) down.c> 80:PNWError:  Shutdown failure.  Server may be in odd state.S 81:PNWInform:  PATHWORKS for OpenVMS (NetWare) being brought down remotely by %s.o' 82:PNWInform:  Possible Power FailuredK 83:PNWInform:  Maximum client open files (%d) too small; converted to %d.dK 84:PNWInform:  Maximum client open files (%d) too large; converted to %d.(N 85:PNWInform:  Trustee database being resynchronized with OpenVMS volume %s.P 86:PNWError:  SYS volume not defined in Cluster Volume File, or token missing.A 87:PNWError:  SYS volume not defined in PWVN$NWCONFIG.CFG file. 5 88:PWVNError: Close of file %s failed with code %d.b' 89:PNWInform:  Maximum procs reached.o- 90:PNWInform:  Maximum connections reached.M) 91:PNWInform:  Maximum volumes reached.nC 92:PNWInform:  Received unknown NCP. Func: 0x%02X (%02X%02X%02X).a: 93:PNWInform:  Received unknown NCP request type (0x%X).> 94:PNWError(0x%X, %s):  Entry partially renamed. (name: %s).9 95:PNWInform:  Hybrid user id (%s) bound to system id. .F 96:PNWError(0x%X, %s):  NW Filesystem may be corrupt.  Please check.H 97:PNWAlert:  File system version mismatch; volume %s. Please upgrade.H 98:PNWError(0x%X, %s):  UNIX ulimit exceeded for file %s on volume %s.C 99:PNWError(0x%X, %s):  Disk space may be exhausted on volume %s.nX 100:PNWInform:  Host directory not found (%s:%s).  Possible NetWare information lost. E 101:PNWError(0x%X, %s):  SYS volume static directory init failure. .C 102:PNWError(0x%X, %s):  Unable to salvage file %s on volume %s. W6 103:PNWAlert:  Server %s going down in %d minute(s).# 104:PNWAlert:  Server %s is down.e  105:PNWAlert:  Bindery opened.  106:PNWAlert:  Bindery closed.^ 107:PNWAlert:  Intruder detection: %s, [%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X %02X%02X].* 108:PNWAlert:  Account for %s is locked.4 109:PNWAlert:  New volume %s mounted to server %s.4 110:PNWAlert:  Volume %s unmounted from server %      C       s.; 111:PNWError(0x%X, %s):  Bindery initialization failure. UE 112:PNWAlert: Station %d attempted login with unencrypted password.i= 113:PNWInform:  Trustee DIR consistency check, KEY:%X RN:%X E 114:PNWInform:  Trustee FILE consistency check, KEY:%X FN:%X RN:%X 0E 115:PNWInform:  Trustee USER consistency check, KEY:%X ID:%X RN:%X %C 116:PNWError(0x%X, %s):  Trustee database initialization failure.:A 117:PNWError(0x%X, %s):  Failure to open trustee database file.l= 118:PNWAlert:  Disk volume %s is running low on disk space.n 119:PNWAlert:  Hybrid user name or UIC mismatch (NetWare name:%s, OpenVMS name:%s).  Use SCONSOLE program to remap hybrid user %s.` 120:PNWAlert:  Hybrid user OpenVMS account disabled in UAF (NetWare name:%s, OpenVMS name:%s).7 121:PNWInform:  No more transport packets available.  Q 122:PNWInform:  Failure to create thread, probably insufficient virtual memory.iZ 123:PNWInform: Connection 0x%X logged out due to time restrictions (user objectID 0x%X).? 124:PNWInform:  Field Test image has expired, process exited.HZ 125:PNWInform:  Please obtain an official release copy of PATHWORKS for OpenVMS Netware.P 126:PNWInform:  PATHWORKS for OpenVMS NetWare field test software has expired.: 127:PNWInform:  This field test image will expire on %s.` 128:PNWInform:  Warning - Trustee id number is nearing limit, call you support representative.B 129:PNWInform:  Fatal - Trustee id number has reached its limit. 130:PWNError:  Disk quotas enabled for SYS volume and no quota record exists for NetWare UIC [%o,%o], or remaining quota is less than 1000 blocks./ 131:PWNError:  Error 0x%X verifying queue %s.wN 132:PWNError:  RMS error 0x%X writing bindery; bindery may be corrupted now.s 133:PWNInform:  Routine TriggerPacket() received a packet with an invalid value (%d) in the PacketEnqueued field.nring limit, call you support representative.B 129:PNWInform:  Fatal - Trustee id number has reached its limit. 130:PWNError:  Disk quotas enabled for SYS volume and no quota record exists for NetWare UIC [%o,%o], or remaining quota is less than 1000 blocks./ 131:PWNError:  Error 0x%X verifying queue %s.wN 132:PWNError:  RMS error 0x%X writing bindery; bindery may be corrupted now.s 133:PWNInform:  Routine TriggerPacket() receiv             4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG0.CFG;1 +  , .  . !    /     4 E   !    g                   -    0   1    2   3      K  P   W   O "    5   6 ŭss  7 Ǧ"yD  8          9          G    H   J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } $      PWRK$NETWARE.SAV               .  4[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG0.CFG;1                                                                           E    !                         0             
/*	Portable NetWare configuration/tunables file 			*/

config_file_version = 1		/*	Please don't modify.		*/

/*	General configuration. 						*/
client_stack = 80000		/*  	PGFILE usage per client         */
shm_size = 512*1024		/*	Shared memory segment size 	*/
max_connections = 250		/*	Max connections to be supported */

/*	PATHWORKS for OpenVMS (NetWare) specific configuration options:	*/

	/*	
	**	security	(optional)
	**		Specifies the OpenVMS security checking algorithm
	**		used for accessing files in all NetWare volumes */

/*	**		that do not have an explicit security option
	**		specified in the volume connection command.
	**		Three choices are available:
	**			CHECK
	**			  OpenVMS security is always checked.
	**			NOCHECK
	**			  OpenVMS security is not checked.
	**			CONDITIONAL
	**			  OpenVMS security is checked if the file
	**			  was NOT created by the PATHWORKS for
	**			  OpenVMS (NetWare) server.  
	**		If this command is missing, it defaults to
	**		CONDITIONAL.
	*/

/* security = "CONDITIONAL" */

	/*
	**	creator_ace	(optional)
	**		Applicable for CONDITIONAL security check only.
	**		Flag that determines what test is used to determine
	**		if a file was created by the server.  If CREATOR_ACE
	**		is ACTIVE, then the existence of the COMMON ACE is
	**		sufficient to bypass OpenVMS security using the
	**		CONDITIONAL security checking algorithm; otherwise,
	**		the creator field of the COMMON ACE is tested to 
	**		determine creatorship.  Defaults to INACTIVE.
	*/

/* creator_ace = INACTIVE */

	/*	
	**	deferred_close	(optional)
	**		Number of seconds between the time the client closes
	**		a file, and the file is physically closed by the
	**		server.  DOS applications and batch files typically
	**		close and reopen the same file quickly, so waiting
	**		some seconds before closing the file to allow the
	**		client time to reopen the file improves server
	**		performance.  Configurable from 0 to 60.  Default 
	**		is 6 seconds.  Specifying 0 forces server to close
	**		files in real time.  Deferred close can be turned
	**		off per volume by specifying the /CLOSE qualifier
	**		in the volume connect command.  
	*/

/* deferred_close = 6 */

	/*	
	**	max_filees_per_client	(optional)
	**		Number of open files allowed per client.  Can                                                                                                                                                                                                                                                           !5 $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         SC "     N        range
	**		from 20 to 200, default is 50.
	*/

/* max_files_per_client = 50 */

	/*	record_type	(optional)
	**		RMS record type applied to files created by the
	**		server when not specified in the volume connect
	**		command.  
	**			STREAM		(default)
	**			FIXED = n	
	**			  where n is the record size.  Record
	**			  size defaults to 80.

/* record_type = "STREAM" */

                                                                                                                                                                                                                                                                                                                                                                                                                                      4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG3.CFG;1 +  ,   . !    /     4 ?   !                        -    0   1    2   3      K  P   W   O "    5 1  6  Oޔ  7 "yD  8          9          G    H   J                           
/*	Set the location of the binaries. This parameter is used by
 *	SCONSOLE to determine where the binaries are located when it
 *	starts Portable NetWare. */
                                                                                                                                                                                                                                                                                                                                                                              4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG5.CFG;1 +  ,   . !    /     4 F   !                       -    0   1    2   3      K  P   W   O "    5   6 CB  7 ]"yD  8          9          G    H   J                           
/* 	
**	VOLUME ASSIGNMENTS
**
**	Format:
**		volume = "<volname> / <OpenVMS path> [ / <qualifier> ... ]"
**
**		One volume assignment (the SYS volume) is required, others
**		are optional.  The SYS volume must always have 4 required
**		NetWare subdirectories, MAIL, LOGIN, SYSTEM, and PUBLIC.
**		There are no restrictions on locations of volumes. 
**		Multiple volumes may be connected to the same location,
**		may be in a subdirectory of another volume, and may
**		be moved to different locations between instantiations
**		of the server.
**
**	Qualifiers:
**		All volume qualifiers are optional, and may be specified 
**		in any order, but must be specified after the OpenVMS path in 
**		the volume assignment command.  Most qualifiers can be 
**		abbreviated.  The most abbreviated form, if allowed, is shown.
**
**		/security=<label>
**		/sec=<label>
**			Specifies the OpenVMS security checking algorithm used 
**			for the volume.  
**			Three choices are available:
**				CHECK
**				  OpenVMS security is always checked.
**				NOCHECK
**				  OpenVMS security is not checked.
**				CONDITIONAL
**				  OpenVMS security is checked if the file
**				  was NOT created by the PATHWORKS for
**				  OpenVMS (NetWare) server.  
**			If not specified, the server-wide default value
**			is used.
**
**		/file_protection=<specification>
**		/filepro=<specification>
**			Specifies the OpenVMS file protection mask applied to newly
**			created files.  If not specified, OpenVMS is allowed
**			to put its default protection mask on the file 
**			according to its algorithm.
**			Example:	/filepro=s:rwed,o:rwed,g,w
**
**		/dir_protection=<specification>
**		/dirpro=<specification>
**			Specifies the OpenVMS directory protection mask applied 
**			to newly created directories.  If not specified, OpenVMS is 
**			allowed to put its default protection mask on the
**			directory according to its algorithm.
**			Example:	/dirpro=s:rwed,o:rwed,g:r,w:r
**
**		/close
**			Disables deferred file closing for the volume.
**			Files are closed in real time, before response
**			is returned to client.
**
**		
**		/record_type=< STREAM | FIXED | FIXED:n >
**		/rec=< STREAM | FIXED | FIXED:n >
**			Specifies the RMS file type applied to newly
**			created files in the volume.  Default is STREAM.
**			If FIXED is specified, an optional record length
**			value can be specified, which defaults to 80 if
**			FIXED is specified without a length.
**			Examples:
**				/rec = STREAM
**				/rec = FIXED:512
*/


/*	
**	Hybrid users can have a special home volume available whose root
**	is the hybrid user's default directory from the UAF.  To disable
**	this feature, comment out the "hybrid_volume" definition.  The
**	volume name is initially set to HOME, but can be any valid 
**	NetWare volume name.  The format of the "hybrid_volume" definition
**	is:
**		hybrid_volume = "<volname> [ / <qualifier> ... ]"
**
**	Note that the format is the same as the format for normal volumes,
**	except that <OpenVMS path> is not specified.  All volume qualifiers
**	are valid for the hybrid volume.  Also note that the hybrid user 
**	always has ALL NetWare trustee rights to the root directory of his 
**	hybrid volume.
*/	

hybrid_volume = "HOME"

                                                                                                                                                                                                                                                                                                                                                                4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG7.CFG;1 +  ,   . !    /     4 G   !    A                    -    0   1    2   3      K  P   W   O "    5   6 ~A  7 ,{"yD  8          9          G    H   J                           
/*	This flag indicates the device where PNW msgs will be printed.  The
 *	default is /dev/console (which actually equates to OPA0:)	*/
console_device = "/dev/console"	
console_flag = active		/* Are messages to be printed? 		*/

/*	The next two parameters are watchdog parameters. If you want a
 *	log entry made in the error log file whenever a client is logged
 *	out by watchdog then set log_watchdog_logouts to active.  If you
 *	want a message displayed on the console device for this situation
 *	then set P                                                                                                                                                                                                                                                                                                                                                                                          }) $      PWRK$NETWARE.SAV                 4[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG7.CFG;1                                                                           G     !                                      display_watchdog_logouts to active. */
log_watchdog_logouts = active		/* default is active 		*/
display_watchdog_logouts = active	/* default is active 		*/

/*	Allow logins on startup flag.  This flag disables login to all
 *	users except the NetWare supervisor.  The supervisor can
 *	change this flag after the server is up in the DOS command line
 *	utility FCONSOLE.EXE  						*/  
login = active			/* default is active. 			*/

/*	This flag when active requires all clients to use encrypted
 *	passwords.  If you want to allow clients to use non-encrypted
 *	passwords then set this flag to inactive.  Think of this flag as the
 *	"password encryption required" flag.  */
req_password_encryption = inactive		/* default is active 	*/

/*	Shared memory variable.  The key indicates the unique number that 
 *	will be the PNW shared memory segment. 	*/
shm_key = 101861		/* default is 101861 			*/

/*	Message language. This value will directly correspond to a
 *	messages file in this directory.  Only the first three letters
 *	of the value are actually used.  Default is ENGLISH. 		*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            4 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWCONFIG9.CFG;1 +  ,   . !    /     4 E   !                       -    0   1    2   3      K  P   W   O "    5   6 KF   7 #yD  8                                                                                                                                                                                                                                                         
                         $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                          
     _           9          G    H   J                           
/*	Parameter passed to print server to tell it how long to delay
 *	between NetWare queue check for finding of print jobs. */
print_check_time_delay = 5		/* seconds; 5 is default */

/*	Portable NetWare has a simple read-ahead cache; used mostly on
 *	executable file down loads.  There is NO general purpose cache. 
 *	The cache block size token should be tuned to the UNIX
 *	filesystem block size that Portable NetWare is using (ie. 1K
 *	filesystems, 4K filesystems). */
read_ahead_cache = active				/* default: active */
read_ahead_cache_block_size = 9*1024		/* default is 1024 */

/*	If a write behind is wanted then this flag should be activated.
 *	We have found a 5-20 percent improvement on writes with this
 *	feature. NOTE:  the default for this flag is INACTIVE. */
write_behind_flag = active		/*	default: inactive */

/*	Assign list of users to get alert messages.  SUPERVISOR and
 *	all OPERATORS are always in the list so they need not be listed 
 *	here.  Users are seperated by a semi-colon ( ';' ).  There must 
 *	be a trailing semi-colon on the last token, as well, even if
 *	there in only one item. */
/* alert_notify_list = "GUEST;" */
ALERT_DIST_LIST = GUEST;


/******************************************************************/
/******************************************************************/
/*******From here down these tokens are not documented.************/
/******************************************************************/
/******************************************************************/


/*	NetWare supports a facility to save deleted files for a time.  
 *	This feature is managed through these tokens.  To activate this
 *	utility set the flag to active.  The facility will save up to
 *	salvage_num_files or salvage_max_bytes.  Those are the constraints
 *	of the facility.  NetWare will NOT save more than salvge_num_files
 *	files or more than salvage_max_bytes bytes.  A simple LRU is used
 *	to free up space in the event one of the two params is max'ed out,
 *	and someone has deleted another file. Salvage_num_files and 
 *	salvage_max_bytes apply to EACH NetWare volume. Once an file has
 *	been deleted and becomes a part of the salvage data base all
 *	trustee rights are lost. 
 *
 *	NOTE:  this facility of Portable NetWare has not been certified 
 *	in Novell's testing organization and for lack of testing time 
 *	Novell will make no guarantee of this facility.  For this reason 
 *	we turn the utility off. */ 
salvage_utility_flag      d        = inactive;
salvage_num_files = 10				/* default: 20 files */
salvage_max_bytes = 2*1024*1024 	/* default: 2MB */

/*	Undocumented flag to set dir cache element size. */
dir_cache_items = 30		/* default: 30 */

/*	For development purposes only there is a runtime debug level.  
 *	See the header file debug.h for more details. */
debug = 0
ASTLM = 32767
BASEPRIOR = 8
BIOLM = 32767
DIOLM = 32757
ENQLM = 32767
FILLM = 32767
JTQUOTA = 1025
PGFLQUOTA = 200000
PRCLM = 12
TQELM = 22
WSDEFAULT = 2048
WSEXTENT = 16392
WSQUOTA = 8192
LONG_NAME_SUPPORT = active
                                2 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$NWPRINT.CFG;1 +  , O  . !    /     4 O   !                        -    0   1    2   3      K  P   W   O "    5   6 )z  7 Us#yD  8          9          G    H   J                 
             !++  ! PWVN$NWPRINT.CFG ! M ! This file is for configuring native NetWare print queues for use by OpenVMS L ! users only. It is not a configuration file for setting up print queues for+ ! PC clients. Use SCONSOLE to do that task.  ! J ! For each OpenVMS queue that you create that you want to be serviced by aM ! native NetWare server to a printer connected to that server you must define M ! that in this file. Five lines are needed for each queue definition. Leading L ! blanks and trailing line comments are allowed, except on the password line; ! (since the password can contain blanks and exclaimations)  ! 7 ! These lines must appear in the order specified below.  ! A ! Line 1: The name of the OpenVMS queue that you want to redirect J ! Line 2: The name of the NetWare file server that will service this queueK ! Line 3: The name of the NetWare print queue for the file server on line 2 E ! Line 4: The username to log in to the NetWare file server on line 2 - ! Line 5: The password for the user on line 4  ! O ! All values must be specified; if the password is blank, there must be a blank  ! line indicating that.  ! K ! It is recommended that the username not be SUPERVISOR; but one is created L ! either per NetWare queue or a single one for all NetWare queues. This userO ! does not need any privileges, except that they can add, delete, and list jobs 3 ! in the NetWare print queue; which is the default.  ! N ! The example below, when uncommented, sets up a OpenVMS queue called NW_HPJETO ! to be serviced by a NetWare server called NETS that has a NetWare print queue O ! called HPJET.  The user name VMSPRINTERS password PRINTIT is defined on NETS.  ! ! ! NW_HPJET			! OpenVMS queue name / ! NETS				! NetWare server for the target queue & ! HPJET 			! Name of the queue on NETS: ! VMSPRINTERS			! User name to log into NETS to print from	 ! PRINTIT * !				! Previous line contains the password ! F ! Add your groups of five lines below for the queues you are defining: !  !--    ! * !-- end of definitions in PWVN$NWPRINT.CFG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               8 * [PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1 +  , .  . !    /     4 L   !    T                   -    0   1    2   3      K  P   W   O "    5   6 |.܊vD  7 P$,#yD  8          9          G    H   J                        # L # Copyright 1989, 1991 Unpublished Work of Novell, Inc. All Rights Reserved. # > # THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, A # PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS ? # TO THIS WORK IS RESTRICTED TO (I) NOVELL EMPLOYEES WHO HAVE A 9 # NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR : # ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL WHO HAVE' # ENTERED INTO APPROPRIATE AGREEMENTS.  9 # NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED, ? # COP                                                                                                                                                                                                                                                                                                                                                                                          Z $      PWRK$NETWARE.SAV               .  8[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1                                                                       L     !                          "            PIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED, ; # CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, : # TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT: # OF NOVELL.  ANY USE OR EXPLOITATION OF THIS WORK WITHOUT= # AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND  # CIVIL LIABILITY. # 8 #    @(#)cmd/sconsole/help/helpfile 1.4 (Novell) 7/29/91 #    # 	 # Format:  #  #	<offset-number>  #	<number-fields>  #	1 <field-1-text-1> #	1 <field-1-text-2> #	1 <field-1-text-3> #		. #		. #		. #	n <field-n-text-1> #	n <field-n-text-2> #	n <field-n-text-3> #		. #		. #		. # D # See "sconsole.h" for offset numbers and consult the menu structure$ # definitions for the field numbers. #    # HELP_OFF (100) 100  1 8 1 Pressing a number executes the corresponding function.0 1 'CTRL/Z' or 'R' returns to the previous menu.  1 'E' exits SCONSOLE.    # MAIN_OFF (110) 110  4  1 0 1 Enter '1' to perform administrative functions.1 1 (NetWare Startup/Shutdown, and Error Log menus)    2 , 2 Enter '2' to view or set NetWare transport 2 and server configurations.   3 / 3 Enter '3' to view or save NetWare Statistics.  3    4 / 4 Enter '4' to run NetWare transport and server  4 maintenance utilities.                                                                                                                                                                                                                                                              Y $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         j0 "     p       # BACK_REST_OFF (120)  120  4  1 & 1 Enter '1' to backup NetWare volumes. 1    2 . 2 Enter '2' to restore NetWare backup tape(s). 2    3 4 3 Enter '3' to view or print the Backup/Restore Log. 3    4 , 4 Enter '4' to clear the Backup/Restore Log. 4    # CONFIG_OFF (130) 130  3  1 < 1 Enter '1' to edit general system configuration parameters.4 1 (Server Name, base priority, process quotas, etc.)   2 < 2 Enter '2' to maintain the NetWare transport configuration. 2    3 9 3 Enter '3' to maintain the NetWare server configuration.  3    # ADMIN_OFF (140)  140  5  1 / 1 Enter '1' to start all configured components.  1      2 . 2 Enter '2' to stop all configured components. 2    3 ) 3 Enter '3' to start specific components.  3    4 ( 4 Enter '4' to stop specific components. 4    5 , 5 Enter '5' to maintain the error log files. 5      # UTIL_OFF (150) 150  2  1 , 1 Enter '1' to list the transport utilities. 1    2 * 2 Enter '2' to list the service utilities. 2    # STAT_OFF (160) 160  7  # 1 B # 1 Enter '1' to set the interval at which statistics are updated. # 1    1 8 1 Enter '1' to display general file server information. 7 1 (Server name, Versions, Connection information, etc.)    2 . 2 Enter '2' to display file server statistics. 2    3 7 3 Enter '3' to display file server internal statistics.  3    4 7 4 Enter '4' to display NetWare file locking statistics.  4    5 1 5 Enter '5' to display NetWare volume statistics.  5    6 : 6 Enter '6' to display the current connection statistics.  6    7 - 7 Enter '7' to save all statistics to a file.  7    # PRINT_OFF (170)  170  3  1 G 1 Enter '1' to maintain Host print server to NetWare queue assignments.  1    2 G 2 Enter '2' to maintain Host print server to OpenVMS queue assignments.  2    3 < 3 Enter '3' to maintain NetWare to OpenVMS form assignments. 3    # PSERV_FRM_OFF (180)  180  3  1 8 1 Enter '1' to list NetWare to OpenVMS form assignments. 1    2 7 2 Enter '2' to assign a NetWare form to a OpenVMS form.  2    3 ; 3 Enter '3' to deassign a NetWare form from a OpenVMS form.  3    # PSERV_CFG_OFF (190)  190  3  1 = 1 Enter '1' to list currently assigned Host print servers and 9 1 the File Servers and NetWare queues which they service.   ? 2 Enter '2' to bind Host print servers to NetWare print servers ? 2 (previously created with the NetWare PCONSOLE client utility) B 2 and assign them to service print queues on NetWare File Servers.   3 , 3 Enter '3' to deassign a Host print server. 3    # DATA_CAP_OFF (200) Unused    # START_OFF (210)  210  6  1 4 1 Enter '1' to start NetWare communication services. 1    2 - 2 Enter '2' to start the NetWare file server.  2    3 . 3 Enter '3' to start the NetWare print server. 3    4 - 4 Enter '4' to stop the NetWare print server.  4    5 * 5 Enter '5' to stop NetWare file services. 5    6 3 6 Enter '6' to stop NetWare communication services.  6   . # HYBRID_OFF (220) Replaced by HYBRID_CNFG_OFF   # ERR_LOG_OFF (230)  230  2  1 2 1 Enter '1' to maintain Transport error log files. 1    2 1 2 Enter '2' to maintain Services error log files.  2    # TRAN_UTIL_OFF (240)  240  3  1 , 1 Enter '1' to view IPX routing information. 1    2 - 2 Enter '2' to reset IPX routing information.  2    3 3 3 Enter '3' to view IPX network status information.  3    # 4 8 # 4 Enter '4' to enter the IPX "track" menu for tracking8 # 4 routing information and service advertising packets.   # SERV_UTIL_OFF (250)  250  2  1 4 1 Enter '1' to see a list of "visible" file servers. 1    2 , 2 Enter '2' to see a list of attached users. 2    # 4 7 # 4 Enter '4' to see a list of "visible" print servers.    # 5 3 # 5 Enter '5' to monitor local print server status.    # TRACK_OFF (260)  260  4  1 7 1 Enter '1' to view the routing information and service  1 advertising packet trace log.    2 8 2 Enter '2' to clear the routing information and service 2 advertising packet trace log.    3 > 3 Enter '3' to start logging (or tracking) routing information" 3 and service advertising packets.   4 = 4 Enter '4' to stop logging (or tracking) routing information " 4 and service advertising packets.   # TRAN_CNFG_OFF (270)  270  5  1 > 1 Enter '1' to view or set transport configuration parameters. 1    2 < 2 Enter '2' to configure Novell Virtual Terminal parameters. 2    3 , 3 Enter '3' to list configured IPX networks. 3    4 7 4 Enter '4' to add an IPX network to the configuration.  4    5 < 5 Enter '5' to remove an IPX network from the configuration. 5    # 8 : # 8 Enter '8' to enter the Named Pipes configuration menu.   # SERV_CNFG_OFF (280)  280  4  1 5 1 Enter '1' to maintain file services configurations.  1    2 4 2 Enter '2' to maintain print server configurations. 2    3 6 3 Enter '3' to maintain the Hybrid User configuration. 3    4 3 4 Enter '4' to maintain the security configuration.  4    # TRAN_ERRLOG_OFF (290)  290  2  1 4 1 Enter '1' to view the NetWare Transport error log. 1    2 5 2 Enter '2' to clear the NetWare Transport error log.  2    # FILE_CNFG_OFF (300)  300  5  1 + 1 Enter '1' to set file service parameters.  1    2 2 2 Enter '2' to list NetWare volume configurations. 2    3 0 3 Enter '3' to modify a specific NetWare volume. 3    4 ; 4 Enter '4' to add a new NetWare volume.  (Associate a host * 4 file-system path with a NetWare volume).   # 4 7 # 4 Enter '4' to change the name-space assignments of a  # 4 NetWare volume.    5 2 5 Enter '5' to delete a NetWare volume assignment.4 5 (Does not remove files from the host file-system.)   # HYBRID_CNFG_OFF (310)  310  3  1 5 1 Enter '1' to list the current hybrid user bindings.  1    2 ) 2 Enter '2' to add a hybrid user binding.  2    3 , 3 Enter '3' to delete a hybrid user binding. 3    # SECURITY_OFF (320) 320  4  1 5 1 Enter '1' to set security configuration parameters.  1    2 0 2 Enter '2' to show the alert notification list. 2    3 9 3 Enter '3' to add a user to the alert notification list.  3    4 > 4 Enter '4' to remove a user from the alert notification list. 4    # PSERV_QUE_OFF (330)  330  3  1 C 1 Enter '1' to list Host print server to OpenVMS queue assignments.  1    2 = 2 Enter '2' to assign a Host print server to a OpenVMS queue.  2    3 A 3 Enter '3' to deassign a Host print server from a OpenVMS queue.  3    # TRAN_ERR_LOG_OFF (340) 340  4  1 C 1 Enter '1' to maintain the Service Advertising Protocol error log.  1    2 : 2 Enter '2' to maintain Novell Virtual Terminal error log. 2    3 8 3 Enter '3' to maintain the IPX/Decnet Tunnel error log. 3    4 , 4 Enter '4' to maintain the Stack error log. 4      # SRVCS_ERR_LOG_OFF (341)  341  4  1 . 1 Enter '1' to maintain the NetWare error log.$ 1             SYS:SYSTEM/SYS$LOG.ERR   2 - 2 Enter '2' to maintain the Server log files.  2    3 3 3 Enter '3' to maintain the Print Server log files.  3    4 4 4 Enter '4' to maintain the Print Spawner error log. 4    # NW_ERR_LOG_OFF (342) 342  2  1 3 1 Enter '1' to view the NetWare Services error log. $ 1             SYS:SYSTEM/SYS$LOG.ERR   2 4 2 Enter '2' to clear the NetWare Services error log.$ 2             SYS:SYSTEM/SYS$LOG.ERR   # PSRV_ERR_LOG_OFF (343) 343  4  1 ) 1 Enter '1' to view the Print Server log. % 1      PWVN$LOGFILES:PWVN$PSERVER.LOG    2 * 2 Ente                                                                                                                                                                                                                                                                           
, $      PWRK$NETWARE.SAV               .  8[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$SCONSOLE_ENG.HELP;1                                                                       L     !                          
            r '2' to clear the Print Server log.% 2      PWVN$LOGFILES:PWVN$PSERVER.LOG    3 / 3 Enter '3' to view the Print Server error log. ' 3        PWVN$LOGFILES:PWVN$PSERVER.ERR    4 0 4 Enter '4' to clear the Print Server error log.( 4         PWVN$LOGFILES:PWVN$PSERVER.ERR     # SRV_ERR_LOG_OFF (344)  344  4  1 # 1 Enter '1' to view the Server log. ! 1   PWVN$LOGFILES:PWVN$SERVER.LOG    2 $ 2 Enter '2' to clear the Server log.! 2   PWVN$LOGFILES:PWVN$SERVER.LOG    3 ) 3 Enter '3' to view the Server error log. # 3     PWVN$LOGFILES:PWVN$SERVER.ERR    4 * 4 Enter '4' to clear the Server error log.# 4     PWVN$LOGFILES:PWVN$SERVER.ERR      # SAP_ERR_LOG_OFF (345)  345  2  1 & 1 Enter '1' to view the SAP error log.# 1   PWVN$LOGFILES:PW                                                                                                                                                                                                                                                                           Ez $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                                      VN$SAPERROR.LOG    2 ' 2 Enter '2' to clear the SAP error log. # 2   PWVN$LOGFILES:PWVN$SAPERROR.LOG      # NVT_ERR_LOG_OFF (346)  346  2  1 & 1 Enter '1' to view the NVT error log.! 1     PWVN$LOGFILES:PWVN$NVTD.LOG    2 ' 2 Enter '2' to clear the NVT error log. ! 2     PWVN$LOGFILES:PWVN$NVTD.LOGb     # TNNL_ERR_LOG_OFF (347) 347h 2R 1r) 1 Enter '1' to view the Tunnel error log.K$ 1      PWVN$LOGFILES:PWVN$STUACP.LOG   2 * 2 Enter '2' to clear the Tunnel error log.$ 2      PWVN$LOGFILES:PWVN$STUACP.LOG     # NOT_USED_348 (348)   # SPWN_ERR_LOG_OFF (349) 349F 2  1K+ 1 Enter '1' to view the PSpawner error log.N& 1      PWVN$LOGFILES:PWVN$PSPAWNER.LOG   2 , 2 Enter '2' to clear the PSpawner error log.& 2      PWVN$LOGFILES:PWVN$PSPAWNER.LOG     # NOT_USED_350 (350)   # STK_ERR_LOG_OFF (351)D 351N 2T 1 ( 1 Enter '1' to view the Stack error log.# 1      PWVN$LOGFILES:PWVN$STACK.LOGN   2E) 2 Enter '2' to clear the Stack error log.E# 2      PWVN$LOGFILES:PWVN$STACK.LOGT         # STARTCOMP_OFF (352)H 352T 4  1L8 1 Enter '1' to start NetWare communication services and  1 the Tunnel(s) if configured.   2h3 2 Enter '2' to start the NVT process if configured.  2	   3e- 3 Enter '3' to start the NetWare File Server.x 3>   4 . 4 Enter '4' to start the NetWare print server. 4      # STOPCOMP_OFF (353) 353  4e   1t- 1 Enter '1' to stop the NetWare Print Server.  1    2 - 2 Enter '2' to stop the NetWare File Server.   2u   3c2 3 Enter '3' to stop the NVT process if configured. 3P   4(7 4 Enter '4' to stop NetWare communication services and n 4 Tunnel(s) if configured.     0e 0n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	                           	Oj                                        {  3[PWRK$NWROOT.NETWARE.CONF_FILES]PWVN$MSGS_ENG)DAT;1                                                                               !                         q =             m~j$gjCRu\X},g&S:]n3>BOinKv8fXE.2}dmFS"z1M9c`<Y$oPivRZRzgA;W,/:kc+PQ[i"E+Fq.$"
x/;^ coB5]y9UmJ_>COysAzCD,rs|_54C,\/SkG3B)5<V 
2X``Z7Dd+<8aS!2tmuUXjNYg+:\by]5kuQY=_F$mUEgTb                                                                                                                                                                                                                                                            %T8 $      PWRKV50F1050.G                 5 > [NW.KIT.AEXE]PWRK$NETWARE.SAV;1                                                                                                  $   $                         p "            QaHN1hm&++mFJ%ADUY.JzpK>n0HH}*7%K>Mjx~&MWU	A)o$s
VL0(v/@s=] !v)89HOvC}#7 W:M7Yb2;~8yj4`86"<Cs*??"sO^2^x~sdz^Y`ecPi
/K`BEuva/rasHY^!Sn7,OXxy0a`guN
.
YRIw5 oM>GMIkfT.- g3Q?WP)w59akEf
Z~AOk
@
&};<xUOr9J	;0-DnA{'f~^xWD>~^mUwC=B_7(rl0Hfxxz)e1fpi0+?)g)7P6snZM4}w-"qU6)"$CERUlN2p/~Etx,52&Pwm#	A]ipmGo`56@+;^Db)A4$(qstVhkOa+%:xn!8dP#{n:E\ r*h0\8h(0llrB/d.)>&+ agBH:sqE#Nid_E
0S"^p#[,=?4
&8A_{)oaGc_OP%E+ze36{EF_X+;{RDugY"<:PRO%B~J	/Z1S[wdZB6 .fHRx=p "t</ *H6e7/dpuUX&GW\;Z
t,-t/bO'>-V0-ia^K='v(Q2-*Cc)rdS?_Dpc2(c?x2OdQ2~J
ONl:K/{kDYUJ_	_GGZo&}B	LuNEf D
+4
Nj&g93N[BZB3|JOF=[@q@T"/0;I "^~Hq*q" <
F9AK?{eIP1%
t`Q*=o=e6,_z}Sc lU[X}K|o`[kntdLyh'   gx"1ZIK	p=+u0Z\:I=jQO f NrW
gLHsi?J.V exDxc,Ta%N&t:FCO:8wL-~2=e6
X|3	*tX+IRzgK`^tKXP8Le;MvbVVF#z&[=F~NO)>@p
bT7.
rT*ksHf!_=z]Gv'h
F
ffR
TYa=b?<+6?wM	\Wq(H)Il
]/yqi(j!4~ 50j_O{#N-/z>
N>DF|UvH@o[?
ZD=hS5kU{zB1b*
Jl:\J#s.+t5s03(mt5k6ZUJ!^(ti$d%uLw?%8NkY#?,zgdKs5Wh[w0w'<FlHAIT>R;?[)5Rc!k&=Dn\$(2:R9phxkl5SZ4rO1~tW
{KG2(RL+B} 8p 0q+G@WrK=M X_@
IP?_-O2"w@I
Gn
`;]<o*rW-01-9}lo$kF#E2y%;rjof[M"'h7e9"7` cKbM|je3uVrW_'_uT[U@YjXc1-d}j
5
#d_$TQj0Pff}tj]aUNgZ!g4jW:co-|jp6 V3xe~yocL<$-`#f:|YbM:(@2)7W#mV:]S8`9,g2XZX\B5 yyu
(\j
r`j'} ]'4X
d_GHTk44216)O=<o@EfZn{i*y[dr4!$GXO:2.
AZSz(hR
\F sUNL9Fm6
oMxFw%RJw}2)5#;}UL2K
bZUA1S
d *h[#WE:<@q.tr#:LU	/g_G
*4qeg{]<+_GQ[\rP	G"^k)VR~e`po[Y+cAeAa&L
nS5E >k&:9FFcp$)+!21b[2?	ywy&9LHo_]8E74jm3~REvsde+~~R}oJ4~!1	's$Fm71:Rx
c?@8k/.<%Zjya.hX)u0Q9~iC";2gJ~ZfjdV]w-m]u2I1
|+a!-hr[a1'`>Pr}?TK*=xfB7R9# z2IIIa;{t	~dK+6?@\AnQLusuf7zks8E>K2>R	fm`D-WL"~Pr$%# r)dhg DP8|#h?$'V\PqyFJ?r-0UKppr&g=.&aE?u/Z1r4jo,VSGJ[	/Yl!m$L
zs
4}L2=R7W>1;GSYO*NnM#=
Bf|y(WEC"Y	y)pwF$0|Y+^}7\'w1l)7"W,uAH'%o(F]b/4G4a6bWyd$x!Ru}
 JRXZ]('I#eU4J5eobYk%O$.M^Y
WihVp
`KxJ_8) @!d3 H`\m"\
hzJL="N
=xX1Nfp-G%
>sg{)uK%H cz0@(d,-!k'~\MScN(&Yv0x-Sf4,%T7$UW{yPT:AITe*gbg$Ax	Des/VF+
iDl!oX!MVGrDQ-|bk|Y0w'i565%b~E<kF%<h_QzN 5 B$cx&t+N"2
h

FmRcMBuB]yI#sp tJE NqkRu	reN! Xicbt.^=hdk%.Z[9']>s'i`>D&Q'#;'Vc=p2r1a^
Wk{ERb1A+[Rdx TNo[n>,Po+g;P6pB^mGyj{uz'*e #,/[!xlV_'=]5*,-`>7('L/b%=["E[{dF{uJ1(N}s[F-uX!+yc'
9[m[WGIGUHCvS0'rgp8^a62a?n^U1:W97<-j0BHhs@c]S\n)x4eltw'j\`G=4y34P!,/4MT[ufB[,O7m6VJYMCbdU_d]$-S'cm4d6QA]ADS|p[ne9S /`0P|$a\>_0N22gZ=I#:X3pKV8q%,Iu#IVXr{6 #ZCeWl
Wei1',-iO3`"EI_wNZq&/lE%v6BBa Y{F9~3(A|~_0Q(XW*Up[# <='ze71I>\HU.Jf^LYEb%nW3x|(	P	r[;+5IrQ-HV
J:3~E=&Qw|31s jYQIF
P[eI>ELhD#J!tlgSZ}6}^bP@G8FGs4k~NZLP
Z4}f"{!8z}j.;l5]|%9_K[j+x6'}fZnRTL
boC4gQpUq+o&5f~LX8?.-]*R44e:J3O|8Iik=mm~s7D1fKYM=W)gXp'&rOe':UV4'2O]0]]\T
OBy)@/D
L1!zILP,v8wD=)<FB<d$q.uy|um.cEruU
 <hnTbggKpdSeDK[&bI> Lt	m
f>J{97)	r1aczb<-($a}tdoX7G>O9 5mi+Yv	)4VY/P
!wgM(@k!^Yr"\]
vN0K5X^r?Zfc1U=[o,rQw;ppZgx^0!
of#V}qoT\D)a@OLeitrc}rY}|9 =<KlCS?m%n? 3Y7yeCCv:9<<+S95x_\,ibUD7tb:c#<B}N~3CQ8*t~lu?|n zH,To.Sl6U@[M3'e#MGT3
?uK<Bca=5{GK 4mT66g:4NXUT<SVk)Pv_"u<Di<EYkz}cp+.k6#0[h+ZtEVBrd$D]j T	uG{bntOe|\c,cKEv
#[tZ6QB<tfH1oe9kDl(Ufie^%f\|cW,E_<*<?C8ZR)@(E	rY(!B&Vo:+JB>~C zi%9|Ti3TBu#S`}+(kKWcA<`Wkf2ELl2:_vP#.("E&wNv-gpEJSae ? )Fm(*khrBPDcXj>uq;,wnAY^~I8vF HJyhPU.z5m]
Of
:uf3s>ebet<NRLtyYL_5ah#WE>AgvrQeDE[X(qIMLOB!]uD1aAR7A:Hx8o.oW ]y^"])25|yuL
{ZLv0{>xitj;E@$-Y`^s;i,!pb~v}z6"}bjs#--Vao2^6LCXPj>EC&)q* =4=03WB6?Qa^4W.KEx
%yo=iVuyf^=UY|J$aXC"9;U*Sgx_a6QN[% 8CKk|_~T~,\m?kS'Z
CXh_VXGEo<Fy5%g<0	\l[fG`U>iTcH[10t1>zg,>TL}S&
J4&r8.i;loG+&re%g{wagS
sCZdk# iS*[Q2P8PM.! "^b to.XR =c[n
Wt5`ksRV
y#][ct`6	QNnIBZ:1Cu~)c
bRF,2IraSn>u&A"Z	1S2&b =>lunh1a(BbivN&%XKt0JJRE5hcuTR,C5;yg	IV [:m{KUUoe?qEf[JB &{{< "BNa0#{JD',^-D;JC@RJ=O"|m	w>k	-CD\@]E~ u2"YW
LiJYZ@KqhZM97`^YAZuoq)-Pu?:!qC8l@F>g	MMMH
uV KK)E#06Jb:4;r72Gt+"|.(J${r> 6.#.vVr.VEZDLs
Hv:Z\ K\	hm6a/L_f}e0z@dZS*{_1qI77F]CySR3~[jXBIP\4y/rWK=GWQ42R8([7<wN
Jb !:#)/Z-]I=5_|.9G4]()dn48S -3)$}`'uB%H_U	G	EFJAy#f	U8;>Ie'CH3=S"_)wL5Y G0TWy}%W*,< 3uvk:J5@8 `7/~js8uQeYt.% yWQYu*;DA:&zd6AmIR
}	}|k W-3CV\*"6> tg&il>N /T-i|u#$1'F(5/s J77F0 2:fZ[k s&rqe* ;lr|E81M^lS(ETZam<_BU4P=NM<
9_..f
U6b}/bc,cnSU(OEeb &o]$'x_}_Xhm+Vz,
1-L2M:wlxf&e?`-#vB(FTl~RiB#)Wy0{	8_[,'Jr~+wy{jZ*uD&?<~76m#s 5UfZ{z
wbZw(Uz^7:>gSS8zP@ix7>g<' 1g"/oM7Aag>@%`\GXzH,1II.L*7Ck?<O]yC?7*i$16zwFa<u>43ffqc=h+U{'~4grv2u2g%TxPi%UkZ:pgU:Wq}cw_1y$d ]uI 
?s5X#&bK |4n
Ca{1dYR%)](2qqd!(|#kmP(Jic)TJ?hZgk{o2) x5x6">:rg2v+r% K7c-&kJ4v`_6C44+:In 0b\FW[`|AW?7:-Z/-W4&oxO?vBXYl:[A/8c5[Eu.TJ|5.ooqc<Qj\F

Yk<Pag;$v Up->~fRXB-P$F#e pQ.\^yA"yt$i?r8t!*Ue}{c
q8^05%-?@_\1>0UQA[,801rli	{;qY_O2f:2~5ny<3wRN4,qdf?Mgq84:YGbDbGPO1b(Oqr~yd:l&h9'-99>t)VRf~L}/9t]UD70NxS8og73#upF.n$[3,8!aP)ptV&[>U?^E@V;2]dCP3a]G8dm O0iuA$9?Z82y$
ok#=<v y-prmrhdCkw%$i(+i9PYA Bri" k]t>aRl}rD
d(w^Sq(J\Ej9K9tM8
Z(CPJIp0u+.<9p\lqr(#<~n DFeEx[C
5(8E"/$F]M$7"_);\D*4iV#_K0l[F6#/k,VWhRTUhmn=CGr?M-*do.+AEJK@Ni}+:@pUQCe345yx~GM\V6RHc}cm"3>~uGEmX#v[YMY<Z39v?K0@##,%$oPvi N5UK0%x59 `\FR=tJP	{6m3t4+5*eD3]`[0VN(l>XE|="?pX8]=V2FP KV\?8a'a>HJu{%d!"s2IU>0|]	/~4|&6	qj}<Cb{J/2%n@	"!tQx;aV@,Elh0YwDts553m`)0E@L^6J]Im
3t~F/iE}1R'auVGChV[uX\Vx sSh1u-[YFA+bdu`S4|S5,?y2Yie7@pm50+RZl\b%t,KoH ?FRWakI3yQhQ+,de-oc)bw+$6Yq%pfg2&$W[~%@ZI
X?S>)d?:ZG:&^eXew(%qK#+> QTL7%ASM`I0)S
xbe m,4rBWSF2SV-7:7|< ,\7y_-m[n\laXEDxF% JM`3?#e~#Fc=_
!> R5IOPb Kz)<}]
@8S"q^	 suli^ i|O"S? X67N#G9)F*X8I?>Sh"0ao1KqKe7_JCkfmPhJ%\pQGS!SH&kZ$42Dn"@}N-4h6c^rNI1X?2?ixs-E"FP5S"GQ;3%>L!\C8Co?}
jfUDL3hCB9pXE{9U]Zb<3s,	#U[\4*[q47Hr$Z=t8~)$-[8gM9p!*y: 4"_WV6=V&

e{b$c7JFgY6>VG0N0C=/{>8v"B8@mmd1p8EY\(A'Pz\b:1YP|Mrry^X5g%5A5	8 #~KD4e,WCj]9t&=,Hd*+t3o-{3"70SSZ{n
Bh(
qhDB|.h%V)u08^7?E{.Y#Ik*1}1e58oR"d,U+9!mvu6j/"Fbls8*;+x~|'"yCRmab"(4U.?kP ?l;;N#wIWIN u{c}d^rb;EHem+Sfg4et*`Y#iaU?^%+5h ed4
j[Fpu6=|O9t7v>&*`x=IU_JNFa!Sj6Yg-4"{fn-S.Y]VC?a~wD;7r\9^wOu(r83d0x &&#k4Lr1Ks gp<`E:u D3["YntbLR7/yJu*r9Lqwcn}c))u&J~v@=3[dM:nAhM0-JL5!R9kSt8=dk,~aqo|dY ZA,!-f/vr8/`nvx b-8E.f*bd(,&!X;	,b`o>o.r<0g0r"fId/_x&(c> btx4EWb:~>!4k/V,9: NP	DRGR~Z<
_0U`I,b;05
{|q'~kJG/kc`?jsCyHql=I%aDr;]oL$#UK82TXQl_RF8DG)SjzoH
dg~x25T1uaGer-&-$#Pk6`*3z;K b>0pO,QlW
/(k~) jp^%N?p3Y`A9Z{}LQJZXH"#-]^x@#$@"#&[RT7*Di
Kg|00:oN2kx4 P~_
qs*>PA)=?cx!{zS=wm"}d?Bsm#STz_iUfq)xn>mS59 98i^o(F!+]Lsh{	 "hZ`P_FSj	-DZw
;1j#d4}m@z$P[A=PAq]OQnr.$4)R#;/
'2Wp(xPjjf${rot2V;tbR1gp}q~41 Q.vr,Xqv$"?.
~~cgaZg^^
e,NA>&q,cz8CnBFL }Tq$?5-5*7nq0GgesX3[.1	"}O#j4_WcSQ~wvE.@kX#(dEP[3qb2\=X^P>s?
;I)AhGWdl8u~k8rolV!|Y;՚c-w_<]^͉pc+F|ad
}
;.dtS+}GWaGs:]Jo2Z(d:n.Yz	Eg::;fSB[8ujfmQ
OXM6Yq.*9;uWtHP+
S-=bFRTZF2z&.E,8HDHsj
+wTvb~NL pIaKc$v0 Zv~b eha] *
4,pR%tv| Vlvj&,1"1 @/l*;'o o6=q : u9fyc17F=;dahB~79D"1j\
T
,5;&al9[XTMHBxS`Tyzbiu$Ns#]`BDW}A[ paCs or job level logicals, etc.   A 11 Specifies the paging file limit.  The paging file limit is                                                                                                                                                                                                                                                                                                                                                                                                                           Yħ $      PWRKV50F1050.G                 2 >  [NW.KIT.AEXE]PWRK$NWCONFIG.COM;1                                                                                               ^                              x                * [NW.KIT.AEXE]PWRK$NWCONFIG.COM;1 +  , 2  .     /     4 ^      	                     - >   0   1    2   3      K   P   W   O     5   6 OXM  7 #D  8          9          G    H  J                I $! Copyright  Digital Equipment Corporation, 1994.  All rights reserved.  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!6 $!	 NetWare initial configuration command procedure		! $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!% $ set symbol/scope=(nolocal,noglobal)  $ STATUS = 1 $ on error then goto ERROR_EXIT " $ on control_y then goto CONTROL_Y $ get := read SYS$COMMAND  $ put := write SYS$OUTPUT  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!' $!	 Check for required privileges					!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!N $ REQ_PRIVS = "ACNT,ALTPRI,BYPASS,CMKRNL,DETACH,GROUP,GRPNAM,NETMBX,OPER," + -J      "PHY_IO,PSWAPM,SETPRV,SHARE,SYSGBL,SYSLCK,SYSNAM,SYSPRV,TMPMBX,WORLD"" $ PREV_PRIVS = f$setprv(REQ_PRIVS)! $ if .not. f$privilege(REQ_PRIVS)  $ then? $    put "%PWRK-F-NOPRIV, no privilege for attempted operation" 
 $    put -O      "-PWRK-I-REQPRIV, operation requires the following privileges: "+REQ_PRIVS  $    goto NO_PRIV  $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!? $!	 Define all PATHWORKS logicals necessary for configuration	!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!" $@SYS$STARTUP:PWRK$COMMON_LOGICALSB $ ROOT = f$parse(f$trnlnm("PWRK$NWROOT"),,,"device","syntax_only") $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!/ $!	 Check for minimum number of blocks free			!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $ BLOCKS = 0N $ if f$search("SYS$UPDATE:PWRK$NETWARE.SAV").nes."" then BLOCKS = BLOCKS + 250- $ MIN_FREE_BLOCKS = BLOCKS	! No section files + $ FREE_BLOCKS = f$getdvi(ROOT,"FREEBLOCKS") # $ if FREE_BLOCKS.lt.MIN_FREE_BLOCKS  $ then $    put "" K $    put "''ROOT' has only ''FREE_BLOCKS' blocks free.  PATHWORKS requires" K $    put "a minimum of ''MIN_FREE_BLOCKS' blocks for PATHWORKS data files." , $    put "Please delete files from ''ROOT'." $    put ""  $    goto ERROR_EXIT $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!7 $!	 Check for minimum number of blocks in disk quota		!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $ define/user SYS$OUTPUT NL: $ define/user SYS$ERROR NL:  $ on error then continue $ mcr PWRK$SHOWQUOTA 'ROOT' C $ if $STATUS.eq.%x000003D4 then PWRK$BLOCKS_AVAILABLE = "999999999"  $ on error then goto ERROR_EXIT - $ if PWRK$BLOCKS_AVAILABLE.lt.MIN_FREE_BLOCKS  $ then $    put "" \ $    put "User ''f$user()' has ''PWRK$BLOCKS_AVAILABLE' blocks available on device ''ROOT'."^ $    put "PATHWORKS requires a minimum of ''MIN_FREE_BLOCKS' blocks for PATHWORKS data files."5 $    put "Please increase the disk quota on ''ROOT'."  $    put ""  $    goto ERROR_EXIT $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									!1 $!	 Create the initial NetWare directory tree			!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!3 $ if f$search("SYS$UPDATE:PWRK$NETWARE.SAV").nes.""  $ then* $ put "Creating NetWare directory tree..." $ exclude_list = "" O $ backup SYS$UPDATE:PWRK$NETWARE.SAV/save_set/select=[PWRK$NWROOT.NETWARE...] - ,   PWRK$NWROOT:[NETWARE...]/new'exclude_list'+ $ purge PWRK$NWROOT:[NETWARE.CONF_FILES]*.* & $ delete SYS$UPDATE:PWRK$NETWARE.SAV;* $ endif  $!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!									! $!	 Common exit							!  $!									!I $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!
 $COMMON_EXIT: B $ if "''PREV_PRIVS'".nes."" then PREV_PRIVS = f$setprv(PREV_PRIVS)
 $ exit STATUS  $! $CONTROL_Y: : $ STATUS = %X1000002C		! SS$_ABORT, with output suppressed $ goto COMMON_EXIT $!	 $NO_PRIV: ; $ STATUS = %X10000024		! SS$_NOPRIV, with output suppressed  $ goto COMMON_EXIT $! $ERROR_EXIT: $ STATUS = $STATUS $ goto COMMON_EXIT                                                                                                                                                                                                                                                                                                                                                                                                 * [NW.KIT.AEXE]PWRK$NW_IVP.DAT;1 +  ,   .     /     4 B       2                  - >   0   1    2   3      K   P   W   O     5   6 "D  7 D  8          9          G    H  J                  @ data,req,sys$common:[syshlp.examples.pwvn]example.c,1849847944A data,req,sys$common:[syshlp.examples.pwvn]example.com,979771707 A data,req,sys$common:[syshlp.examples.pwvn]example.opt,992744613 > data,req,sys$common:[syshlp.examples.pwvn]getopt.c,641818418> data,req,sys$common:[syshlp.examples.pwvn]getopt.h,3210822460 data,req,sys$common:[syslib]nwapi.h,16015297113 data,req,sys$common:[syslib]nwerrors.h,1098768834 9 data,opt,sys$common:[sysupd]pwrk$netware.sav,2934642285 9 data,req,sys$common:[sysupd]pwrk$nwconfig.com,893298262p9 image,req,sys$common:[sysexe]pwvn$banner.exe,1874639354m; image,req,sys$common:[sysexe]pwvn$binddown.exe,2562170724l8 image,req,sys$common:[syslib]pwvn$cache.exe,37740071419 image,req,sys$common:[sysexe]pwvn$client.exe,4253412163s; image,req,sys$common:[sysexe]pwvn$doslogin.exe,2170078700s9 image,req,sys$common:[sysexe]pwvn$netware.exe,914327931:7 image,req,sys$common:[sysexe]pwvn$nssp.exe,3495279607s7 image,req,sys$common:[sysexe]pwvn$nvtd.exe,4275463792s; image,req,sys$common:[syslib]pwvn$nwapishr.exe,3684801782y@ data,req,sys$common:[sys$startup]pwvn$nvt_start.com,2066729336A data,req,sys$common:[sys$startup]pwvn$nssp_start.com,2066729856a@ data,req,sys$common:[sys$startup]pwvn$nwcp_start.com,476564969D data,req,sys$common:[sys$startup]pwvn$pspawner_start.com,846109118B data,req,sys$common:[sys$startup]pwvn$server_start.com,995547267: image,req,sys$common:[sysexe]pwvn$pserver.exe,1273160511: image,req,sys$common:[sysexe]pwvn$pspawner.exe,990991521: image,req,sys$common:[sysexe]pwvn$sconsole.exe,3401565156 image,req,sys$common:[sysexe]pwvn$smb.exe,36063226738 image,req,sys$common:[sysexe]pwvn$slist.exe,29555883018 image,req,sys$common:[sysexe]pwvn$tlist.exe,23031899808 image,req,sys$common:[sysexe]pwvn$ulist.exe,3422273186wvn$pspawner_start.com,846109118B data,req,sys$common:[sys$startup]pwvn$server_start.com,995547267: image,req,sys$common:[sysexe]pwvn$pserver.exe,1273160511: image,req,sys$common:[sysexe]pwvn$pspawn               * [NW.KIT.AEXE]PWVN$BANNER.EXE;1 +  , [}  . 2    /     4     2                        - >  0   1    2   3      K   P   W   O 3    5   6 _jD  7 cD  8          9          G    H  J                              h                                                  (   _jD              0       @                                     	              
            E_jD PWVN$BANNER                            	V1.0-611F      A11-14                               $             
               $             
               $                             $                             $             J                $    (                       8                        DECC$SHR_001         @                       ]|ESYS$PUBLIC_VECTORS_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       uk $      PWRKV50F1050.G                 [} > [NW.KIT.AEXE]PWVN$BANNER.EXE;1                                                                                                      2                         g             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    * Node:     %s
         @             0      * Version:  %s
         * Software: %s
         * Cluster:  No
         04/05/98              	              %s
                 0           @       <               F              `                                P      * Build:    %s
               * Type:     %s
         * Model:    %s
               * SMP:      No
         0             @                                            * Cluster:  %d nodes
   * SMP:      %d of %d CPUs running
      *** Unable to read system parameters, status = %08X
    PATHWORKS V1.0-611F for OpenVMS (NetWare)       *************************************************************************                                                                                                                                                                                                                                                    	        
`     f              0       @       P                                                                                                                                                                                                                                                                                                                                                                                                                                      #4G( ^0   ~G  ^#0 [G C8 {C  C > ޶uZk(b# @  BG( b4G3UZkG  ]( ]0 @ #kG#; cC ^( [5@ ^G  ~G( TG0 8 G  ~G0 {#
HZk" N@( BG0 bTG/@GHZk( B M@0 b!H@GGTGGZkP BCbGG  GGGGGBZk =GTG( BD0 bB  GZk"  C !  Cj X "B  .  r.Jr  rJw @   .Jz  "H   Y/CYKx  @ bQ@  0, C8 TGs@A 0H  0<  S.@@GR SJ  S>  .W J  >  z/[ zK  z?( B0 bGZk( B Q@0 bG CTGGZk( BT@0 bG CTGGZkpb  C$U@B "htG !     C X@G4G( B0 b$W@GZk( B0 bG CTGGZk`b  , H
 `   %.%J5 "1&JTG&J C #K@G4G( B$C@0 bvGZkG@G( BTG0 bnGZkG ] ] 4G  }( 0 8 @ #kB !.  r.Q!J0FrJ_  .  .TJFJ .WJF y/[yKzG ,@HD                                                                        T                           X                                       0                                     
                                     @       DECC$SHR                                               @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                             #        BANNERDEC C X5.2-003   TRANSFER$BREAK$GO     main    J  	U 	m 	m 
          P    P        __main  (        d          .        DIGITAL_COPYRIGHTDEC C X5.2-003                                                                                                                                                                                                                                          P       p               	        `                            0     @     P        3         P                                                                                                                                                                                                                                                                                                                                                                                   * [NW.KIT.AEXE]PWVN$BINDDOWN.EXE;1 +  , \}  . K    /     4     K   ;                     - >  0   1    2   3      K   P   W   O L    5   6 gekD  7 D  8          9          G    H  J                            h                                                  (   7kD              0       @  H	                                   2              :            7kD 
PWVN$BINDDOWN                          	V1.0-611F      A11-14                               $             
               $             
               $    B                         $                            $             J   0             $    (                       <                          PWVN$NWAPISHR_001        8                        DECC$SHR_001         4    &                     
LIBOTS_001       @                       ]|ESYS$PUBLIC_VECTORS_001             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    0          0                             p                            `                                         P              F              0(    2     `      <       	           `                              
              F              0     0     P                           SYS:\MAIL\%X    0@     *     p       <       0     PASSWORD        P                    &                                                           0     -            <       `              
                            0     P(     @                             GROUP_MEMBERS   0    8'     0             p	                     0      h     0@    $           |               &              VMS_USERS       SYS:SYSTEM/%08X         0                          
%c           0`     4                         0    6     @             &              \*.*            `              p              0x     (9            |                                                    SUPERVISOR                    Header R2       Header R        p               Seek    0          0              ctx=stm         rb      rfm=stm                                      0      
     p                                        0     x                  fwrite                        Q_DIRECTORY     '              0            0         p            0      p                    	     08                       *       p              08         p      <       \LOGIN                        0                            0                                   `              FILE *%X
       Object  Header W        0H     p	                          p!              @               0     #     @              U    0     0     0              w+b                   Create  0     H     0                       	              0          P              p                                          F              %c      0                 <               `                              
              0     <     @       <                       SYS$COMMAND     r       w       Retrying... 
   UPLOAD  DOWNLOAD        0             @                                    0      @     0H                                      Could not open file %s
         
Failed to write the login script!
     SYS:\MAIL\%X\LOGIN      
Found login script out of order %X
    
BINDUP ERROR %X: NWCreateDir - error creating %s
      
BINDUP INFORM %X: NWCreateDir - Directory already exists - %s
         Found object mail directory out of order!
      Skipped set addition for %s(%s)
        
BINDUP Error %X: NWChangeQueueJobEntry
        
NWGetObjectID error %X         
BINDUP Error %X: NWAddObjectToSet
     
BINDUP ERROR %X: NWCreateQueue
        
BINDUP INFORM %X: NWCreateQueue - Queue already exists
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   $      PWRKV50F1050.G                 \} >  [NW.KIT.AEXE]PWVN$BINDDOWN.EXE;1                                                                                                    K                          "     	       
BINDUP Error %X: NWWritePropertyValue( "%s", %X, "%s"...)
     
BINDUP ERROR %X: CreateProperty
       
BINDUP Error NWGetObjectID( %X, "%s", %X, id ) == %X
  
  Creating properties for %s   BINDUP Error: Invalid record %c
    x  \              <         
  Adding Information to Objects        
NWDeleteDir( "%s" ) == %X
     
NWDeleteFile( "%s", %X ) == %X
        
  Skipping QUEUE entry         
BINDUP Error %X: Failed to set password for user %s.
  
  Created Object %s    
BINDUP Error %X: NWCreateObject.
      
  Skipping Supervisor
        
  Creating objects     
BINDUP ERROR: Invalid file
    
BINDDOWN ERROR %X: NWScanTrusteePaths
         
BINDDOWN ERROR %X: NWScanPropertyValue
        
 BINDDOWN ERROR: SetValue: Property must be a set 
    
BINDDOWN ERROR %X: NWScanProperty
     
BINDDOWN Error %X:ItemValue failed
    
BINDDOWN Error %X: SetValue failed
    Error reading "%s"
     Trustees call failed
   
Properties call failed
        REC_HEADER type: %X, len %X
    
 BINDDOWN: So far we have downloaded  %d  objects; Remaining %d more objects
  
  Scanning object %s   
  Scanning objects     
 BINDDOWN: Total number of objects to be down loaded = %d 
    
 BINDDOWN ERROR: Failure to allocate memory
   
  Reading objects into memory          
BINDDOWN ERROR: Writing to bindery upgrade file.
      
BINDDOWN ERROR %X: Logging in to file server
  
Invalid password
      Performing login as %s to server
       Please enter the SUPERVISOR password for %s
    
BINDERY Error %X: Could not get connection ID for server!
     
BINDDOWN Error %X: Attaching to file server
   Attempting to attach to %s
     Your bindery was successfully restored.
        Upload of the bindary has failed.  Please report this problem.
         Could not open temporary bindary file
  
BindDown was successful.
  The bindery was stored in %s.
      the server selected.
   
BindDown has failed.  Your bindery was not recovered from
     Could not create a file to store temporary bindary information
         Could not establish a connection with the server requested.
    First attempt to establish a connection with the server failed.
        Fatal: can't open SYS$COMMAND output
   Fatal: can't open SYS$COMMAND input
    Usage: binddown filename servername {upload|download}
  
BINDDOWN ERROR %X: NWIsObjectInSet(%s,%s)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             #4G( ^0   ~G  ^#( [G C0 {C  C > ޶uZk =b# &@ӨBGb4G1UZkG  ]( ]0 @ #kGp B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k# ^ ~    ~G ^G  G  , #"( B4G0 b H    .PJJsZk  .qHP JF  >0`@G ] ] }  0 #kG# ^ ~  ( 0 ޴8 @ G  ۤ  ~G ^GGG         0 D@	C!1 @  @F    0  F  R 0 B 2  0. 0JG G0 B4G  8 bEZkG  E.sHD!DR EJX!DSF  E>  !D2  "0  UVJ0@Jd@B BF@ ùe@  _# @d@@ @ b L@P BGG  X btGCZkd@@  ,F H  <Gb#~_G ] ] }  ( 0 ݤ8 @ P #k  %,A %H  %<G( # G     ~ ^%D  %D  +D  /DGѴ%D
 GG    GG    GG   x[dC D   TG{7GZkG ]   #k# dC ^G[P;  ^h  ~ C  G  ~G{ CGJZk(b  C  0   "GG  . A"q@FP J  >  p@Fv7JUJF  WB.  A/G !#{KZ YK C[G A?BGb4GGUZk 8 Dx"
  HBPb4GH!  CFZk( B  4G0 brZk	 G 4G èBG@bG4GLZk GG ] ] }  0 #k 0 JFF # fC ^GX [dC ^ gC ~G  G( G  ~G` {G%JZkb  CXBG  G  `b C4GGZ`Zk 8 D  $,	  HB4G $H b"   CFZk G_G ] ] }  ( 0 #kH B4G  P bYZk $. $,  XB C J  cA H`b4G!FG2`Zk5 @@# ^ ~   G  ~G ^G`{#_ӘhBGpbTG   CyFZk( BG0 bTG CHZk#  	 &B "hB  %TG`R"pb0D    % CcFZk GX G8 B C@ bGTGMZk  "hBTG  % ! pb CQFZk GF GGhBTGpb  CFFZk   CGb#y_ӘbhB pb Cc  CTG8FZk  b H B CP b C$vH4G CGUZk"  b	 $  "hB4G  ! pb CD FZk G G  	 $  "hBTGDpb !   # CFZk G G G  4GG ] ] }    #k#4G ^ ~  G  {G ^0 [    ~8 { v H CHZk  c4G@ BH b#v`H CIZkG ] ] }  0 #k`#4GH ^[   P ^ CX ~` h p ޴x   > G  ~G{EZk $ H@ c 
 8 =" H H  Q   D  0@B  Q@b#a_  BCCb v H!\@GGG CGGDZk4G8 B  e  @ bFDe  B7נJUB0BsZk  C"B4G    ! b CEZk GT ? @ =	G_@b#0_  CBC!\@b v HGGG CGGDZk1  8 =  H )A3 I8  H H%  Q1A D"  6qBVBJ /  .yJ CXKWJGF ?  >G  h	0 ABvC`C}Zk  8 =B4 #q G H  p Gp1H@H D  W B     G
2A_   D  D( B`F  'GbG0 bGYZk GGH ]P ]X }` h p ݤx   =  #kG 0 H D D   G
2A_G   GGD	 @?DBG  .uSJT JF  > ?DBG  V.uvJ VJ @  . 4GT JF  >4 @?D	QB_15 B1!JB  .T J  >kG#(^0~8@H޴PX`>hG@ۤ  ~GG  ^G  _8b#_  D_  CB ]"G0v J C C "?"CZk0 B C8 bG CGGGGGfZkG   "  !?D8E#  E9     ] &"T"  BCP@JG @   itG( b4G4JGB SZk 8 D-    BC  i( bG?"4GG~SZk 8 D$  8 E =  P I?4@@? G_G ](]0}8@HݤPX`=hp#kGGBTGb" CDZk G G GP#P ^X ~` h p ޴x   > ^ ~  GpۤG  ~G@ G  GH ^G;GZ  x[{Gb#_  *G  G  B(@4 !"( b4 . v H5 A. @ CJRQJGF CAZk  	 & "    )0DL    )C0GBG/  @ ]  ltGb2_JS2R"@ ]4GSZk 8 DPBE    * "TG~ZkB(@ @CGG|Zk  ʢC8 =4GBB4 "  l4 / ?H5 6/bKY7KGp KG DG8 TGRZk 8 D*    0@A	@ GGH ]P ]X }` h p ݤx   = ] }   #k"GPBG  )G@! Xb CCZk GðB  b C4GIZk GðB  b C4GHZk GÐ# 4G ^(~08@޴HPX>`^hG  ~^#ۤGGH GP G_  & CCG1v J C CG CCGG 6B G G dBB >GbG  XBZka  @ =CC?D  0X Df  G  GAD `G~_( C  "G0 BG    Y8 bG@ G `Zk	 CB-   =pBC  jtG!?Hxb4GS2!  =GURZk 8 DK   BX "TG}ZkPB ACGG|Zk4 .5 	/4 " =CJpBXK  j!?KxbF`JTG  D 4GG6RZk 8 D4  @0 A  '?H ] G
_E_G] ](}08@ݤHPX=`]hp#k0"TGP B! b  ' C=CZk   D04G Bb! C3CZk GG`B"!hb C4GFHZk G`Bb hb C4G>HZk G # ^ ~   ޴   > G  ~G ^4G # ]G GG"  !  b#_pB  "  TG =Ci}Zk  0 B?D v H8 bFF C  =C  > > CG C CGGGAZkp  xDXD  =  BH@GG{Zk7  P B C{Zk 1 @2  C7u @" "! G  /  @ KG%  G#  6."!u @ 6J%F `+F  ." JF  F V/"                                                                                                                                                                                                                                                                           KN $      PWRKV50F1050.G                 \} >  [NW.KIT.AEXE]PWVN$BINDDOWN.EXE;1                                                                                                    K                          "             VKEG KG
 @"?
    / 1 @ KG `G  "   V.R VJ  V> & V"P"CBtG0Jb  i4GB GGqQZk 8 D)  BC  ibGTG4GGfQZk 8 D  =%   G0 I?G ] ] }   ݤ   =  #kG"TGbpB! xb  # CqBZk  c DB   b C4GGZk GB   b C4G|GZk Gp#u B@ ^GH ~P X ` ޴h p x > GHۤG  ~U!B8 ^G   D  & D( [?"0 =C#GX !v H0oCG0 { C CC  > CGCGAZkJ    =CtG(B4G!?H0b  gGP!   =PZk 8 D   G G(BC  gG0btG4GGPZk 8 D   G  PHPD'   CGGGb#,_  "GBTG"b  ! CAZk Gm CGGGHb#_  "GBGbTGp!  CAZk G[ G?   0 =G@b#_  C( B D@C 'vH0 bG C  C   CGGGGAZkGL   B!O@GCyZk3    ݦC(BG6J0b  gtGP"  ݶ4GGPZk 8 DE  (B  gC0btG4GGPZk 8 D=   PHPD   CGGGb#_G2  ( E CGGGHb#t_	G2  ( E GG8 ]@ ]H }P X ` ݤh p x =  #kG" ?& 1"BBTG  HR"bF  ! CrAZk G G GTGbB b  # CcAZk GGGBTGbp  CXAZk GÐ#4 0   ~ G8^ &@^M"H~tGPX`G4 0.G5 P.( !J[RAJ!J2F8 F  0"?"{Zk5@( >0 @.0"3 `.0"B C@JbS
`J CSF CkCZkb  =0=" C0 B  # "!?H8 bUJ`3 HxUJ D  1"G& .C# . CWJVJFF& >G# >TGZUZkB C0= G CyZkBCD@bGGTGjgZk0./}"/.G  G  #U
JTJ Ha3 HFF0>  D/>  CG# ]/C& }/G# =#G9Jr9J[yKZYKaGRG& }?# ]?CP BGX b4GGHZZk  0]./=.4G/"
0HR
PJs0HQ0JTF3F0]>/=>C`GBtGb4G  dGOZk 8 D   GZ GB0=   d Cb?"4GGOZk 8 D   GL G/./= JP    cCC  @ BC3v`JH bC  C  &GGG Cs"G<[ZkC"TGB   ! b C  @Zk ( =CBtG`3 H  d!?Hb4G D 	@( GTOZk 8 DB   =  d4GbGC  G CGOZk 8 D	    c@BCHbG#v`HTG CPZk GG8]@]H}PX`p#k !.Q!J0F0#PTG ^ ~    C  ޴   > G@ ^G [ $  ~G  $ ({<@ZkP  B4G(b"  C3@Zk¤x Gb#_  C0 BC!O@8 b v HGGG CGGjZk\  p =pBCC H H D?GGxZkCGG_P BC(bG" CTG@Zkx C GBtG Hb  g4GO8  x GNZk 8 DB9  C  gGbG4GGNZk 8 DI  CGb#_L  p =Chb#0`@ђ H_GF  p pb#_	GK    "(CPbcD  D BtGM(b0s"2CBv$H0CaD BPB0p@ CGZkp"  ) ?ED E7 G BH@  'G(bTGZkx }PtG BX  1gH(b 'J2`H CZkBb C4GDZk G ÀBP  b C4GDZk G  G P4G B(b  CZk G	 GPb4G B(bc  CZk GG ] ] }   ݤ   =  #kG#  ^( ~0 G  ~G ^{#_   G* GPb#_   G$ GPbCBGbG  c4G =tGG0NZk 8 D   G àB4G  bQZk   "CBG H  cb4G @ GNZk5 @G ]  ]( }0 @ #k# 0 H^P~GX`h޴pG  ~@^G 0.G P.G[!JRAJ  ` {2F4GXZk 8 D   G ( B =  CGwZk CG_CBGbTG" CZk"H4  BG@  4 "  4 .5 #. JQ JFx F~ @XF|  GGwZk	  4 .5 /  !JXKFXF4F  !4 #"hG4 C.5 c.  BQJSqJb0v JSF CG{Zk(¤  $4 #"G  B!v Hb
  4 c.5 C."   CqJRQJ CrFG~ZkK G4 .4 # 5 #.@ }"   CJQ!Jd3HF F>   ] #J{xJ2_JI@D G ]/ C =/  EGZXKY8K@G ]?HB;G =?tGPb $@ZkxBCbGGTGHOZk      bBCDb  c   & CGtG~Zk @  B C  &tG  b C~Zk G4G  U 4GG@]H]P}X`hݤp#kG# G  ~ ^ ^( 0.G P.G  `  `[ JR@Jh{ C2FG4GWZk 8 D   G$ G"PC  " vJ  !yvJ16J0 b Cr3 HG2F =2vJG / .XKWJG  BF ?tG >  ;( beZkp         4GG] ](0#kG# G ^G`[ " ^G  ~( 0 G >G  ~GtGxZk  .4G  .@"B5JPJb  a0FGWZk 8 D   GE "0W@XGpB4G  !  !v H:  vZk    Ķ6 ÐF@pBGG  TG8v K8 G  vZk    7 " ¦ .4 X.5 8/G  ֦4 # c.XJ  BY8K6vJ( bYF J uJ CGGxZkb &B "`B  TGR"hb    #0D    # C}Zk 4G  D 4GG ] ]  }( 0 @ #kG ;# G@ ^@ [ "H ^ "P ~GX ` h GG  !  ~GGTGxZk  . . CBG5JbVJ4G6FG;WZk 8 D   G G8 "E@P BG4 #  !!v H  uZk  G4 C.G5 #/  8 ݦXJ BY8K7vJ bCYF5vJ CGGvZkb ?$p !   " C   TG D    # Gp  ]"  $vHXD 8 =  0v H $"8 F~   d"_   R#  . q#FxJW JF  > #"  2/?F , :K "p;K@ H r# D <   . 1#?F Q/ J`JZ UK@G Q?
  . R"?F / J`JX K G ? 1"  3B  EC8b2v H:v@K@ C0BGG,zZk  TGp"  !   # C9  . $ 
 $. "  JQ
!Jh b%vHF C8 D/ @3v H"H
 /4aJ .5!H3v`J!v HaJ!HFFaS H3v`JXK 3@6Hy6HG` BWJ
 ? CF > CGtG<rZk  TGp `   # C pCGG8  CtG@BHb|Zk 4GG@ ]H ]P }X ` h p #k0#; G ^[ " ^G ~   G  ~G  !#GG "TG(wZk  .4G . CBG5JbVJG6FTVZk 8 D   Gm è4 "B3M@  %!v H5  4 #.5 C.0JRPJG2F F  GtZkZ  @4 ##4 C.PC5 #,G  G ݦYJ0 BA9H7vJ8 bF0J C  ޶AFGG|Zk 4 "BGBG   @R"b:  4 c.5 #.pJQ0J CqF   Gs|Zk0   4 c"@"PC@ BG  G  !GH b v H!v H"  4 C. C5 .SJUJCUFGGrZk b! & "B   R"    #0D    # C   #   CBbTGE|Zk4G  e   4GG ] ] }    #k#` 0 (^0~G8@G  ~ ^G 0.G P.[!J  `RAJ{> 2F C4GUZk 8 D   GV G4 #"4 C.C5 .G  $GpBQJTJxb!v HTF CGyZk  b4Gc  C: G     } C ="Bd3Hb#H1HD }G }.tH ].F@SqJRQJuFTF }> ]> CG ]GtG%~Zk  BC( bG2HTGLZk  b ?$ ! C  BD    # G C  #G@GtGBb{Zk 4GG ](]0}8@P#kG#    ~G(^0^8~@HP 0,G P.GG H0 [R@JG2D  p   #. C.   JR@J( 2F8 {4GG<UZk 8 D   Gt À4 $"4 D.C5 .G  %GBQJTJb!v HTF CGxZk    "@ ` !   $ CW   "(  ` B C ]tG)@h bG}Zk   C  %# " H HBa3 HbxH  D  CG& .C# .GWJVJFF& >G# >GtGLZk&     " c.C .C( ¢$vHP BtJUJX bGGuF CGGcZk    b4GBbd@G;{Zk  B  b C%vHTG CKZk G# ,# } & ,  HE
HGD CBbTG#{Zk 4GG(]0]8}@HP`#kGp#x4G` ^H[P  h ^ Cp ~x  G  ~GP{{Zkb#_  C(b4GBG , $   cb HTZk 8 DR  X = ?DFW  1'H'J2)B3AJ]aBS `x\\B$C  kCCGGpb#_-  : CGC(b#k_&  3 CGCCb#_  + CGCCb#_  # CGCCb#	_   CGCb#_   CGCXb#_  b#X_ , $ BC  c4Gb HGJTZk 8 D G_G` ]h ]p }x   #k 4Gx"TGHBPb !  CzZk#  0   ~^G ^(~0G 0.G P.`[!J  `RAJh{> 2F C4GTZk 8 D   Gx G.= Jz  bC?  pB}"G CrZk  BCF@( bGGTG`Zk C  #G "P B HX ba3 H4J  D G .w4J .CVJUJFF >G >GTGLZk  p" ?& 1" }. . ]"  G                                                                                                                                                                                                                                                                           0, $      PWRKV50F1050.G                 \} >  [NW.KIT.AEXE]PWVN$BINDDOWN.EXE;1                                                                                                    K                         XY       +       PrJT
J BF(b  tF"  a C CG0zZk  c=   C ]"@ Bc3`HH b H2H `D G .u2H }.CTJSrJFuF >G }>4G$LZk  pb & ]. " }.  # ="PQJS
qJ B0D(b  SFx"  C C CtG zZk GG] ](}0@#k !.Q!J0FP#4Gx ^[x   ^ C ~   ޴ G  ~G{yZkHb#_ӘCb4G BG , $   cb HvSZk 8 D  p Cb#DD  D  G6_ӈ GD@ B
   H b2H4GtG
DZk  à  Ơ ƠD x G B C  c2HbG4GGOSZk 8 D  h ݤBJ@CƒHxD^ XD\  8D qZk  ¦X" CW P¤Ch G` BG  h bҒH v HРHH CNtZk      % & "0D    % _& R"2F  b  %TG0s" C7 GB CCGGrZkCGGJ_CBGbTG" CeyZkh  H8 D   D     Ƥ BҒ H bC&vHF@ CF@GEZk  Š ?$ ! C   " CtG D	    % ¤  C4GBb?yZkHb#_ , B   C  cb HG4GGRZk 8 D^ à   C p   C G $.   ,G@ BtG%J  FHH b&FlCZk  cxb#  c cdD `_ P@G  B4G( b*~Zk GGx ] ] }   ݤ  #kG# F ^ ~  ( 0 G  ~G ^GG   1  , H D  @B4Gb" CxZk  BG( b4GEZkPB F@XbH@GGTG;|Zk`"  C    @B4Gb
" CxZk  BG( b4GEZkPB F@XbI@GGTG#|Zk"  C@B4G  	  
"b CxZk  BG( b4GEZk b#_ Bh "   CpZk  4G  B` "  CpZk  TG @4GBb# CxZk  B( bG4GEZk b#_  @"4GBbp
!  CxZkB J@bG4GxZk b#_  @"B4Gb0
!  CxxZkb#v_  BG( b4GEZk 8D'   b#:_	  @"B4GbG	!  CcxZk> àb#_  @B4GbG	  CWxZkB	c b C4GQxZkTG+ G@TG #P	   C  XD"  b#k_
  @4GBGb(	  C:xZk GPb#B_	  @bB4GbTGc  C-xZk @4G  CB4Gb$xZkb#"_b4GBb    CcZkG ] G ] }  ( 0 @ #kG  0,  P.  . .0HR
PJJU
J2DF C C1@ k!Bk                                                                                                                                                                                                                                                                                        T               X       p      h                                  0                                                        @          `  p               `    P                	              P    0    @  `       P      P  `       @  `    p	                           
                                     @       
PWVN$NWAPISHR                                          @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                     %        BINDDOWNDEC C X5.2-003   TRANSFER$BREAK$GO     	PGETINT32      	>	           @         H  strupr  H   	U	 	U	 	W	    p                  GetPassword   6  	h	  	v	 	y	 	r	          P         h MyClock     		 		 
                  0  
CreateFile  0   		  		   h       d    h      OpenFile     		 (		          P    (     x MakeConnection   8  		 (             8     P  
Disconnect     	6
   (	       T	    x     p	 ( ObjectsToMem  p	 T  	C
 (	P
 	z
 	s
 	
 <	{
   	               h  	BlankName  h !  	
 	
 	
                 
 0 Trustees   
 7  	
 	
 8	
   D
                  	 OldSetValue    8  	
 	
 !D	
    \                 SetValue   \  	
 	 0	& 	4 	6 "8	* 	                  x p 	ItemValue  x \  	n 		v 	 h	 	 	 8	     	   w                       ( 
Properties   w  	 
	 		 	 <	 (                   ` WriteMailDir   V  	( 
	[ 	\ (	[          l           Objects   T  	} 	 	 8         "    x    # p DownLoad  # "  	 	 	 $  8#       #         $  HandleObject  $ 8  	 0	
 0  P$ 	   $              '    (    8'  
HandleTrustee  8'   	@
    h'       4(        P(  HandleProperties  P( (  	j
 T	
 (  (       )        *  	HandleSet  * :  	
  	
 	(  \*       -        - 0 HandleValue  - ,  	
  	(  -       /    p    0 ` 
HandleMailDir  0 !  	> (  P0       1        2   HandleLoginFile  2 *  	e 
 	 ,  X2       p4        4  AddObjectStuff  4 8  	 	    4       h6        6  NukeMailDir  6 1  	 
	 Ĥ 	   6       8    x    (9   UpLoad  (9 `  	 	$	1 	 =		 0  h9       <        <  main  < t  	 		 	 	 	 ,   =       @        @ 	 objcmp  @   	 	       @ @    H             	GetNWTime                 
print_objlist            H	 __main  (        l          .        DIGITAL_COPYRIGHTDEC C X5.2-003                                                                                                                                                                                                                                                                                                             A  	 m  P  p	        p                @          `           P     0     0 ;                    p      3         P                                                                                                                                                                                                                                                                                                                                                          * [NW.KIT.AEXE]PWVN$CACHE.EXE;1 +  ,   . )   /     4     )                    - >  0   1    2   3      K   P   W   O *   5   6 HxřmD  7 D  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ρQ $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        %3 "                   4     h                    P                           (             P      0       @                                           L         d        mD 
PWVN$CACHE                             	V1.0-611F      A11-14                               $                             $             
              $             
               $    
                         $                           $                             $             J               8                        DECC$SHR_001         4                        
LIBRTL_001       4    &                     
LIBOTS_001       @                       ]|ESYS$PUBLIC_VECTORS_001             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                    0            @              P              0          @       <       &                           0     p     0                                      p#               0     p
     0              p     &              &                                       &              0     	                  0             !          !              &              TRUE    0          @       <                        0          @       <       0          0                                                 `a          0     @     0                   8     0      8     0      H          0           @       |                                                        0     0      @     0      @     0      P                  0           @       <                               A     `     0          P              @     0     0                          0           p                          P                   p     0      *     P              @     0     0     0                     0     1     p                          P              P     @     `          h          0     ?     0                           P     @      A     `     0       A     P       <       x     
                  0     `J     @       |       ?                       0     pU     0                           &              0     hQ     0              0     L     0              0     K                    0     p\     0                           0     `^     @              P              0     @     0              F                        0                         `              0                         0(     @     P                                            d             &                            0           @              h           &              &              p     0          @       <               X                    `               0      
     0
     >
ף                       @     0               0p    `a                                    @                                           	             0     P     `      
     
             0      `     0      h          0     `     p                                              &              0             0          0                                     @     0     `J          0          P              @     0     0     x                     0     x     @       <                    0     p     P              @     0     0          @              P              0     P     `                          P     @     H            A     `     0      h     0                                                     x     
     1          0          `             0          0              0                 ?      p\          `              0          P              @     0     0           0     p     @       <                    `              x     
                    0           >
ף         0     p                    &              0     X     0              0                         0          @       <                              `J          0          @       |                    &              0     X     P             0      h     0      `     0                         0          P              @     0     0                          0          @       |            p                  0          @       <                    @     0     0     P     P              @     0     0     H                     0     H            |                    P                   p     0     0     @       <                    P              &              0     8     0                           `                             0     0     P       |       &              P              0     )                    F                   FSB_T (Q): %d
  BIOREQ_T: %d
   DS_TAG_T: %d
   GSB_T (Q): %d
  BDSC_T : %d
    WE_T : %d
      BCB_T (Q): %d
  TWE_T : %d
     0      x(     
0    (                            0     x&     0              0      &     0     $     0              0     X%     0              0     #     0              0     p#     0               	              0     !            <       '              LNM$JOB ESS_TABLLNM$PROCLNM$SYST 
              LNM$FILEEM_TABLE0                         0      (     0           0           0      `     0               	              0H                 |       0	              @'              0                         0      +     P       <                                  &              0      .     0     p.                     `              0      .             0     .     0                                              0     `/     P              @     0     0     `6                     0      `7     0     p                                                   p     P              0     :     @              0     `i     `              A     `     P     @     H           &                             0     M     `             p&              0      x                  0      `Y                  0     7     0              0     =                  `          p\          1                     @     `     +     0     p.          .                                                                                                                                                                              0 H         `             p                                                              `             p                                                                   ` @                                                                             0                             @      P  `         p                                             PWNC_INIT       PWNC_CACHE      PWVN$CACHE_INUSE        PWVN$CACHE_LOCK_STRUCTURES      PWVN$CACHE_LOCK_BUFFERS         PWVN$CACHE_DIRTY_BUFS_PER_FILE  PWVN$CACHE_MAX_FLUSH_PASSES     PWVN$CACHE_THRESH_FLUSH_THREADS         PWVN$CACHE_FILE_FLUSH_THREADS   PWVN$CACHE_PERIOD_FLUSH_THREADS         PWVN$CACHE_READ_AHEAD_BUFFERS   PWVN$CACHE_NONCACHESIZE         PWVN$CACHE_ENABLE_OVERRIDES     PWVN$CACHE_DISABLE      PWVN$CACHE_CONFIG_FLAGS         PWVN$UNIQUE_CONFIG_ID           PWNC_CLOSE      move_dirty2flush                                                                                                                                                                                                                                                                           qo $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         "                            file_flush_thread               PWNC_FINAL_FLUSH        final_flush             PWNC_FINDBUFFER flush_cache_buffers             PWNC_FLUSH_FILE flush_file      make_flush_pass PWNC_GIVE_BUF_AWAY              PWNC_INIT       PWVN$CACHE: lock_structures = %d
       PWVN$CACHE: lock_buffers = %d
  PWVN$CACHE: dirty_bufs_per_file = %d
   PWVN$CACHE: max_flush_passes = %d
      PWVN$CACHE: num_file_flush_thr = %d
    PWVN$CACHE: num_thresh_flush_thr = %d
  PWVN$CACHE: num_read_ahead_buffers = %d
        PWVN$CACHE: dirty_buf_max =  %d
        PWVN$CACHE: num_cache_buffers = %d
     PWVN$CACHE: flush_interval = %d
        PWVN$CACHE: dirty_buffer_ratio = %d
    PWVN$CACHE: cachesize = %d
     PWVN$CACHE: buffersize =  %d
   PWNC_CACHE_CTRL_MEMORY  L  <           X   X       %PWNC-E-BCBQINSERR, error inserting BCB on queue                PWNC_OPEN       periodic_flush_thread           PWNC_PLACE_BUF  PWNC_READ       PWNC_RELEASE    threshold_flush_thread          PWNC_THRTBL     pwnc_thrtbl_create      pwnc_thrtbl_register    pwnc_thrtbl_get_avail_thr       pwnc_thrtbl_make_avail_thr      pwnc_thrtbl_shutdown            PWNC_TOSS_ALL_BUFS              PWNC_TOSS_BUF   PWNC_TOSS_BUF_IOERR             PWNC_INIT       PWNC_UTL        GLOBAL_COUNTERS_T : %d
         OVERRIDE_T : %d
        GCCB_T (Q) : %d
        THRTBLDSC_T (Q): %d
    THRDSC_T (Q): %d
       CFDSC_T (Q): %d
        CALLVECTOR_T (Q): %d
   DATA STRUCTURE SIZES
   bdsc: %X flink: %X bufadr: %X offset: %X count %X
      
we: %X flink: %X blink: %X bdsc: %X param: %X
                 PWNC_UTL_MEM    PWNC_VIEW_HOOK  PWVN$CACHE_VIEW PWNC_CACHE_VIEW PWNC_WRITE                                                                                                                                                                                                                                                                                                                                                                                                      #T    ~  ^ ^ ^  ~( 0 T 3,GW .GG HT
J 4D  C  . .JW
JF C    0 @TG KC p D X D  X C.[ c.9!K CCJU
cJScJF41BJRCJtJ!9@uF[ c> CTFX C>G7 Q  G  [G( {4G^Zk+   @.IO?$   .B!  HR@Js HQ JTF @>3F   > D .Q?$ .RE!  "5HWJx5HVJF >F >G\ ,_ .\ c#HR
JPJ2F0 B;J@Hq;JF_ > D\ < Q N G .G #,JA
#H d F CD "D .G .JW
JF C [ @Zk . $,HqHPJA#HF1D > $<DHD .vDH .UJTJF >F >  D/D $/KZDK{KY$K@G D?;G $? =T .W !.T a JB
#JQ#JBF0@BCJPJrCJ"FW !>FT > @, ./ ., "JV
JF C    4GG ] ]  }( 0 @ #kG# ^ ~  ( 0 G0 {  ~G ^G  4  .7  .4   _ .\ @"J\ `.Q
!JTJF !@2Hu2HSrJFuF_ >\ `>  \ 7/\ #_ W/8KZ
XK:G CL BGb4G1^ZkR    BG( bGGGtG KZk %.IO$  .B  HQ%JrHPJ3F %>F  >D .Q$ .RE   "HVJwHUJF >F >  #@T y/T Y#W .zKP
JpG C     #0@X a.[ .aJV
JTJF0BJSaJuJF[ >uFX a>  \ 7/_ W/\ #8KZ
XK:G C	@ 4G_G ] ] }  ( 0 @ #kGQ #G ^TGG ^ ~  G  ~Gb#GE@5  Gb#GGTGE@.    .b# #.JQ
#JF C$  !U @"  S @8 D"  b# @8 D  @b# @8 D  b#@8 D  Gb#G4G@8 DG	  pb#@ 8 D  @ BH bG4GAwZk G <  9 G ] ] }  0 #k#`; 4G ^GG ^4G  G  ~Gb#  %@ 8 D  BbG4GwZkb#@ C 8 FB  bG4GwZk G ] ]  0 #k#G ^G ~tG  ( 0 G{G ^ [ c   ~({ CMJZk BG(bG CtGEJZk  C0"0`@     CGtG1" b#FB    CGF@G  B Cb CTG~ZkG ]  ] 4G }D  ( 0 @ #k#G ^ _" ~tG  ( 0 G{G ^X[T c   ~`{ CJZkXB j@`bGGGtGJZkh   CHBTG  Pb C  䳳~Zk@B CbTGGlZkG j@8b#G CGtG8F@G	  B#j@bGGGtGpZk   ( " 4G0 D4G  a  G ] ] }  ( 0 @ #k #4G ^ ~   ޴   G  {  ~G ^G #, #"  ,JtJA#H@H #<  < D c.H C.wHSqJRQJuFTF c> C>, " .H #,sH "VJA#HF7D > #<H/ C.wH, #.RPJQ0JTF3F/ C>, #>H .rH #,$ "VJA5HF >7D #<D# #.H  .vHQ#JPJ3FF# #>  >HD' .qH$ #,UJA4HF' >6D$ #<D+ .H( /tHPJXKFG+ >( ?4 "3 #,`@D0 c.A#H b@5D3 #<ScJtF0 c>D7 .e@4 .tGPJWJ7 >4 >TGD; /8 C.XKRCJ; ?8 C>G >G$ G (1" C( >G0 ~G ~d@T ~G G  CL HR"B@ ޲h",  C ^! 8  d@H GD  C  C4 >e@` ^8BX > GP c@< oB\ f@d ~f@h g@l ^Cp Bt  @x >| ޲  >  c. #  .=@U @PaJBT
Jb ]"tFG3  uBUB !  Ҡ  C GGtGHZkGb# CGGtG6E@-  @ B  H b CGGtGXDoZk xD    0@4G  %'u@ GP B CX bL@TG}Zk @  0@'u@ 4GG ] ] }   ݤ    #k # ^ ~  G{  ~G ^  #c  D  ; ) 8 Bk@@ bG _"tGHZkH ( Bk@0 bTGGT}Zk  k@h BTGp bG'kZkGb#k@`@4GtG:C@  4G  # 4G   GB4G  :   2G ] ] }  0 #k( #0  ^      ~ G  ( G  ~0D ^G4G     4GG@b# C(E@  P 4G    0 G GG ] ] }  ( 0 #k            #   ^ ~  ( 0 ޴8 G  ~ ^GG    N / G"GGTGb#N   ! A. a.AJS
aJSF CAa@  GOC@   GT .T % W %.N JQ
!JF C4 @   G e.G .eJT
JtF ` à . .JV
JF_B4G8Dw  e/ E/K`K[eKZEKqG@G e?@ E?   ¤T %"Hb#G  4G, ./ ., t"JW
JVJWF21@BSJUJrSJF/ >F, >T /W E/KZ
QKGG C8 F    @Gxb#G4G<@Ӥ e,X" %,dHA
$HaD0DG  ƠD %"D E.G e.$ .$ "' .QJS
qJJV
JSFF CQ ?B @  F   	  C  &%G @  'C  feG  &< "G< "%D  < ,tJ? E.qtJHR
PJ D  ? .< .VJUJF? >F< > GH BGP b4GFtZkGb# @G ] G ] }  ( 0 ݤ8 @ #kGkG 4GkW P. T 0.T 0 H RAJsHQ!JTF3FW P>T 0>< p"  ? .< .  . @.   VJ!JR
AJTJ 2FHwHFF? >< >  5F8 P. a" . .JwJ; ,VJTJF >F >  PJ@
HG @F U. 5,@ @UJA
5HAF C  @   k     pC   k    G   k 2. " r.2JS
rJ3F CF\ GC 7J7Bl w"   ` 7/c .7KP
J0GG  l 7,o .3HU
J5DA  p  /Gs  . KU
 JP JuF31`B`JY Ks`JF3Gs  >p  ?   2.B r. JY
`JS`JF51BJQ JuJyF5F r> 2>   _ 7/\ w"\ . 2  0 @Y3KUJ_ 7?\ >TG . J r.Bp DJS
aJF C   c w.4G` 7,7K`7KSwJA7HpF Dc w>8F` 7<  7. ,7J@
H F CF? 4Gk    #4G ^ ~  ( 0 G  {G  ~ ^  G`b#  .  . JQ
 JF C7@G   W   #G4G !. A.!JR
AJ2F CH .K .JU
JF C [ @Zk $. D.G$JR
DJ2F Cx F(  GG b#TG
@ . $,HqHPJA$HF1D > $<  c . .JV
JF CH /K 3/KY
3KG CG [ @Zk $. D.G$JR
DJ2F Cx D? . d" .G $/J /JU
JY$KFzJXK C G $?G ? [G @ZkG ] ] }  ( 0 @ #k        #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, "ZCKY#KAG;G C? #?K/ C.`K, #.G$ # RPJQ0JTF F/ C>, #>AHD' C/{AH$ #// ., "ZAKY!K@G' C?;G$ #?5JD# #.CH  .rCHW
JQ#JPJ4FF# #>F  >+ .JD( .WJ`JF+ >VJf@F( >7 c/4 ##4 C/KpK[yKZYKqGPG7 c?4 C?4 C"D7 ,RK3 .0 #,H@
HUJ FH                                                                                                                                                                                                                                                                           H;^ $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        * "     #       vHA#HF3 >6D0 #<; #.xHD8 .Q#JD C#9F; #>PJHF8 >G C.tHD c/ @&1@RZJ[zK@FtGG C>D c?HDK .vHH #,L "UJA#HF6DK >H #<HDO /yHL #.T "XKQ0J G9FO ?L #>\ "DS C.d #"P ,GRCJDHS C>P <E @DW c/%HT C/[tKW c?ZTKT C?D[ ,l "X #,FH[ <A#HX #<D_ .\ .WJVJ_ >\ >CHDc .uCH` ,PJc >@H` <Dg #/pCHd /Y1Kg #?XKd ?Dk C.CHh ,| #RCJDHk C>h <t C"Do c/Gl C/[tKo c?ZTKl C?Ds ,p #,FHA#HD5Ds <p #<CH{ ,fCHDx .@H DWJ{ <CHFx >pCHD , "| #/DH <Y8K| #?Dw C/t .ZRKTJw C?t > C" #, c/A#H[cK5D #<fG c? ,<  D .@H DVJ <b@F >@D / ,XKDH ? < =D C/%C .ZRK C?TJ >  %? c/< .&H[fK`&HUJbGF? c?< >  e   G ] ]  }( 0 8 ݤ@ H P #kGGb#p_tGGGb#j_tGGGb#d_uGGGb#^_uGGGb#X_vG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGGP{#_G ]   #kG#( ^0 ~8 @ H ޴P X ` G  {G  ~  ^    . @. JR
@J2F CPB  P .S .JU
JF C ` .c .JW
J F  C   / @/ KZ
@K:G C     # 0 @TG`Kd " p D X D  d .g .C2AJJX
JVJF71BJ CTJwJ!2@F Cg >Fd >7 Q nG0 BG8 b4GWZk+   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  CGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh < Q :G  cG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk %. .HrHQ%JPJ3FF %> >$ "$ .@' .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk , $" $, ]"BBHA
$HD CF     0 @TG`J C p D X D  4G  C4J d#p .4@s /GJZ
KXK:G91 C5KWJy5KGs ?Fp > $. .;J@
JPJ D!1 @;HQ;Ja;H F >!F $>X (/\ "[ H/l .(Ko .A
HKZHK D 0 @HY(K`HAG G[ H?X (?l "E_ h/J\ (.V
JG[pK_ h?F0b#Q0J\ (> G
_o .l (,l  HP JqHA HFo >1Dl (< h/G H/JD .`JG .[hKZHK@ /D h"C (/aG h?JU
J@G H? H.F (. C "pJRPJtpJQ0JKY
(KUF4F H> (>GE ,K (/aK@HY(K D!G < (? "X d/[ .dKP
JpG CpB  H H.K .HJT
JTF CB @ (,0B ,JvJA5H@H8D D (< <   # (  . . 9. .UJ9JT
JPJ4F C Q" q. ,rJ@
H `FHvHF >F > "    #| "0 9.3 Y.9JR
YJ2F C q" , 1,HU
3HA3HF0 BJ@HpJ5D D 1< <| / -KR
IHID0@HXKeHEG =| ? C  #| y/ ,| "tKP
H@H0D0 @4H[tKa4H D <aG| y? $. d.$JS
dJ3F C    0 @TGJ C p D X D
 L D"L .CO /4G@ .  JC $/X
KJF CY
$K [F CTG @Zk
   - ,HaHHIGHED = < h C2AJ2@ Cl  o ,T %#X .G[ .l %,P .FHS /JT E/V
JW e/A Ho <Fl %<J[ -X
KX ,YK[
yK51BJHIF[GpJGH BED[ = BX <# d .g /d E"@JX
KF @   g ,d E#d e/FH[zKg <d e?G  #b#@ -C 9.IQ
9JE C_@   Gpb#G4GB7@ GGG0b#_  à| - ,|  IA
HEH D 1 @HHI`HD < E| =  $. D.$JR
DJ2F C  c| .| " .L "JV
JF Cg L /O 3/KY
7KG C S# s/ ,zK@
H`G C    0 @TGH C p D X DR    àC'H &. F.!'@ C&JR
FJ / $/2F CL "L .KO .Y
$KGJT
JGF C C [TG @Zk  @` ,c ,H@
H D  C     . @.JR
AJF C     cd .g .d "JX
JVJF0BJUJwJFg >Fd >  #L y/O ,L Y#zKF
HfG C   - ,ID
HE C    0 @H C p D X D 4GG  ]( ]0 }8 @ H ݤP X ` p #k            #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, "ZCKY#KAG;G C? #?K/ C.`K, #.G$ # RPJQ0JTF F/ C>, #>AHD' C/{AH$ #// ., "ZAKY!K@G' C?;G$ #?5JD# #.CH  .rCHW
JQ#JPJ4FF# #>F  >+ .JD( .WJ`JF+ >VJf@F( >7 c/4 ##4 C/KpK[yKZYKqGPG7 c?4 C?4 C"D7 ,RK3 .0 #,H@
HUJ FHvHA#HF3 >6D0 #<; #.xHD8 .Q#JD C#9F; #>PJHF8 >G C.tHD c/ @&1@RZJ[zK@FtGG C>D c?HDK .vHH #,L "UJA#HF6DK >H #<HDO /yHL #.T "XKQ0J G9FO ?L #>\ "DS C.d #"P ,GRCJDHS C>P <E @DW c/%HT C/[tKW c?ZTKT C?D[ ,l "X #,FH[ <A#HX #<D_ .\ .WJVJ_ >\ >CHDc .uCH` ,PJc >@H` <Dg #/pCHd /Y1Kg #?XKd ?Dk C.CHh ,| #RCJDHk C>h <t C"Do c/Gl C/[tKo c?ZTKl C?Ds ,p #,FHA#HD5Ds <p #<CH{ ,fCHDx .@H DWJ{ <CHFx >pCHD , "| #/DH <Y8K| #?Dw C/t .ZRKTJw C?t > C" #, c/A#H[cK5D #<fG c? ,<  D .@H DVJ <b@F >@D / ,XKDH ? < =D C/%C .ZRK C?TJ >  %? c/< .&H[fK`&HUJbGF? c?< >  e   G ] ]  }( 0 8 ݤ@ H P #kGGb#_tGGGb#_tGGGb#_uGGGb#_uGGGb#_vG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGG{#X_G ]   #kG# ^ ~  ( 0 ޴8 @ H >P ^X ~` G  {  ~G ^G  D  .G  .D   JQ
!J F  C  `. .`JT
JtF C    0 @TGJ C p D X D.  C6J!6@ Cd "d /g $/k $.h d/KY
7KQ$JGk $>[aKh d?Dh $,k .$HP
J0D \ $,\  _ . HP
 J 0D ` $,c .$HP
J 0D l $,o .l   HP
 J 0D  G  #H !.K A.!JR
AJ2F C  . .JU
JF C    0 @TGJ C p D X D;  C7J!7@d #g A/d !/GGZXKY8Kg A?d !?  c@ [.C {.[JS
{Jb#SF C@_@   d D.d $"g d.QJS
qJSF h $,k .$HP
J0D \ $,_ .\   HP
 J 0D ` $,c .$HP
J 0D l $,l  o . HP
 J 0D  G:G  #G !. " A.0JR
PJ2F Cf   c, ./ ., "JV
JF C[( /+ 3/KY
3KG C  s/ ,sK@
H`G CDM`C0J&1@0@ C (! H. (,PJA
(HAF  . .JU
JF C4E . .JW
JFG  4G
b# , X/HZ
XKDG C-0@
G    #` !.c A.!JR
AJ2F C  . .JU
JF C      0 @TGJd 8# p D X D  d X/g x/C7JYKQ
yK[yK
QE*1@AYIZYKjYI C!7@qGJGg x? Cd X?1 G0 BG8 b4GWE_%QZkG)    .TJ!   .@Ir@IQ JP J3FF  >   >WE?$ D .T!  . "4HVJw4HUJFF > >  #h y/k ,yKP
H@H
PE
0@AYI[yKjYI Dk <jGh y? Gb#G_  CG *, 
.*HP
J 0D  CD  "D @.G `.QJS
qJSF C [ @Zk .H $,qHPJA$HF >1D $<  c@L .L "O .JV
JF C " / 3/KY
7KG C     CG4G :, Z-:HJ
ZI*D CH .K .JU
JF C [ @ZkUd  /g @/d  #G8KZ
XK:G h +-k K-+IJ
KI	*E \ ,_ ,\  HD
HD` ,c K-HJ
KIDl ,l +!o , GHG
HD.G!  . (.GJQ
(JF   H. h.HJS
hJSF C	2E    GGTG 
b# . .JW
JF C/@0 (-3 H-(IJ
HI*E" GGb#4G}_  #8 (.G; H.TG 	, ),(J	HA
)HR
HJ D  CL `"L .O .2F CJU
JF C [ @Zk0 h-3 H-hIJ
HIjE   C(  .+  . JQ
 JF CD  | `. .| @"0@rJT
JtF C @ . " .JW
J F  C	@  4G   | D- ,| !HIE
HEE C ` $-c ,$IF
H&E C  . $.JQ
$JF C    0 @  TG@Jd " p D X D  d .Cg .3aJ CJY
JWJG81 CKVJxK!3@Fg >Fd > C0 0 BG8 b4GWE%TPZkG)   ,T!  , Ig IFHEHDD <  <WE$ D  .T   ,  HPJqHA$HF1D  >  <  ch .k .JX
JVJF0BJUJwJFk >Fh > `Gb#G_  àG - &-I                                                                                                                                                                                                                                                                            $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         "     4       I
&I	E CD F!D ,G ,HE
HD C [ @Zk +-H -dHaAI+IHI	%EE += =  àL &,L F!O .*HP
J0D C A" a. .rJT
JtF C     c . .JW
JF CH #/K C/#KZ
CK:G CG [ @Zk$  d ,d  g  -GHH
ID h ,k D-HJ
DID \ d,\ d!_ ,kHG
HgD `` -c ,IE
HE l ,o ,l D! GHG
HD   GG ] ] }  ( 0 ݤ8 @ H =P ]X }` p #kGGb#`_GGGGb#Z_GGGGb#T_HGGGb#N_HGGGb#H_ GGGb#B_xGGGb#<_xGGGb#6_yGGGb#0_yGGGb#*_ GGGb#$_fGGGb#_fGGGb#_gGGGb#_gGGGb#_ GGGb#_uGGGb# _uGGGb#_vGGGb#_vGGGb#_ Gy#  ;   ^ ~    ~G ^GI    !G  GX  A. a.AJS
aJSF CAB  <   . " .JV
JF 5 Ø /P  0/KY
0KG  - à P/ 4G p/PK[
pK[G @% T P.T 0"W p. 4GQJS
qJSF C8 F   G 0, " . 4G0HU
J5D CF   GG4G0b#_GGP b#GTG
 @ 4G N G ] ] }  0 #k#( ^0 ~8 @ H G0 {  ~G  ^   @. `.@JS
`J SF  C@ B   . .JV
JF4 . /JX
KF -  $/ D/ d# = $KZ
DK"@:G CF"`    0 @TG`J C p D X D  4GC8K8BD "@ x/C .D 8.G 8/xKc ,P
J` 8,7JY
7K@HA8Hc <pG` 8< x/9F 8/ C "7J[wK`7JY7KaG G x? 8?JG 8,wJ ,GA8H@H9D D 8< <l  X 8,[ .8HY
JPJF0BJA8HwJF[ >7DX 8<o .Jl 8,wJP JA HFo >7Dl 8< 8,xK ,pxK x#A8H@H7D D 8< <X $/[ ,$K@
H  G  C B  H .K .JW
JF C@   8, 8/ @HA;HwHY;K0D 8<7G 8?   # 1, .1HP
J 8. 0D  C . "  / `/ 8 Q!J7K[
wKPJ ;GHwH9FF 8> > X#  R C  |  .  .|   JY
!JQ!JF0BJPJwJ9F  >F|  >  0 ,3 8,HA
8H| # D  C `#  .  .GJY
;JQ;JF0BJPJwJ9F  >F  >| D/ ,XKQ
H@HF0 BJZXKpJ D <PG| D? . $/JY
$KF C    0 @`J C p D X D6L $" CL /O D/P D.S .K@ .Z
QKC $/DJGX
JUJF0BJRDJvJ CFS >VFP D>J [Y
$KGF CTG @Zk   D. $.4G "0HRPJs0HQ0JTF3F D> $> R C6J6@ Cl p"X 0/T 0 [ P/o .l .6KP p/Z
PKT 0.UJW P.TJS ,:Go >vKl >!J[ P/R
AJX .@
H91 C2F `G0KZPK{0KVJ  @QG[ P?FX >  @G  F\ p.\ P"_ .4Gb#rJT
JtF @` .c 0,JA
0HF  @  |  .  .|   JS
!JQ!JSF21@BAJPJrAJ3F  >F|  >  . .JV
JF CS D/P $/GP d/ G$KZ
DK@H:G91 C$Ka$K[dK DS <aGP d?J    $.# D.$JR
DJ2F C    0 @  TG`J C p D X D;   ,C T/5JGHZ
TK!5@D CL "L e/O %/ CwK D.Y
7K /yG CAJX
K [TGXF C @Zk  @` %,c .%HP
J 0D  C @" `. .rJT
JtF C     d .d "g /JZ
KXK:G0 C6KWJy6KGFg ?d >  c| ,| ;  ,L ["HD
HD Cg  L {.O .rJT
JtF C  . 2.JQ
2JF C    0 @TGJ C p D X DS  G  âC7JG 6/!7@ V/ C6K D.Z
VK .:G CL  L v.O .AJP
JeJT
JPFtF C C [TG @Zk  @` %,c .%HP
J 0D  C @" `. .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd >  cL ,O ,L ; HD
HD C  a. .aJT
JtF C    0 @TG J C p D X DG  ]( ] 4G0 }8 @ H P #k# ^ ~  ( 0 ޴8 G0 {G  ~ ^  ,  ./  .,   JQ
!JF CB ( `.+ .`JT
J tF  C  . .JW
JF C D4  C8K$1@8@ C &" F/ f/4GXK[
fK[Gpb# @ &, .G8HP
J0D C!F
   F. f.XJS
fJSF @8 .; .JU
JF C_  0 .3 &.( `.+ .JQ
&J`JT
JF tF C  C D  G ] 4G ] }  ( 0 ݤ8 @ #k        # ^ G  ~G ^      8 F  X F	 @x F  Gb#L@
 G  Gb#C@ Gb# @G ] ]   #kG#G ^G[tG ^ ~  G  ~G{GxZk /  .   XKWJ0 !.3 A.!JR
AJ2F C . .JU
JF#Hy#HG ?F  >  ` # D /0 ;.3 [. .XK;JR
[JWJ2F C p" . .JU
JFJyJGF ? >   D .0 q/3 q. .WJqKS
qJPJsG C . 1,JA
1HF#Hx#HF >F >  @ # D .0 z.3 z/ .WJzJ[
zKPJ{F C 2" . .JU
JF!Jx!JFF > >  `D #.0 s/3 S. .Q#JsKR
SJPJrG C . 2,JA
2HF#Hw#H8F #>F >    # D #.0 Y/3 y/ .Q!JYK[
yKPJ[G C S" . .JU
JFAJwAJ8FF #> >   D #.0 y/3 y. .Q#JyKS
yJPJsG C  .# 3,JA
3HF#Hr#H7F #>F >    # D #.0 X/3 x/ .Q!JXK[
xKPJ[G C$ x"$ .' .JU
JFaJraJ7FF #> >   D# #.0 y/3 .  .Q#JyKT
JPJtG C( /+ 4,KA
4HG#Hr#H3F# #>F  >  $ # D' #.0 W/3 w/$ .Q!JWK[
wKPJ[G C, ", ./ /JX
KFJrJ3FF' #>$ >   D+ #.0 y/3 .( .Q#JyKU
JPJuG C0 /3 5,KA
5HG#Hr#H3F+ #>F( >   , #D/ .G0  /3 @/, #, KZ
@KPJ :G  C4 `#4 .A8H7 .JW
J FHqHF/ >1D, #< ] 4G ] }  0 #kG#G ^G[tG ^ ~  GG  ~G{wZk  #, . ##B 4G#HP
J  R0D C   !"   . .JU
JF CA"@  !  h .k /l A" c/JX
K C/[yKFJpJZYKqGPG c? C? ##l a.o .D C,rJT
J .tFCJBCHxCJUJPD C<F >p !.t A s .GD c/!JW
J C/7F9J[yKs9JZYKtG c?SG C?t . ##w A.GD /JR
BJ .FCHXKwCHUJG ?F >x a.| A { .GD c/aJT
J C/tFyJ[yKpyJZYKrG c?PG C?| !. ## .GD /"JU
J .5FCHXKtCHWJG ?F > A. A  a.GD c/AJS
aJ C/SFYJ[yKqYJZYKuG c?QG C? .$ ## .GD# /JT
J  .FCHXKsCHWJG# ?F  > A. A  .GD' c/AJU
J$ C/UFYJ[yKpYJZYKtG' c?PG$ C? !., ## a.GD+ /"JS
bJ( .3FCHXKuCHWJG+ ?F( > A. A  .GD/ c/AJT
J, C/TFYJ[yKqYJZYKsG/ c?QG, C? . .D3 /JU
J0 .F#HXKt#HWJG3 ?F0 > N G ] ] }  0 #kG#G ^G0 [tG ^ ~  G  ~G8 {GvZk   /  .   XKWJ !. A.!JR
AJ2F C  . .JU
JF#Hy#HG ?F  >  ` # D / ;. [. .XK;JR
[JWJ2F C p" . .JU
JFJyJGF ? >   D . q/ q. .WJqKS
qJPJsG C . 1,JA
1HF#Hx#HF >F >  @ # D . z. z/ .WJzJ[
zKPJ{F C 2" . .JU
JF!Jx!JFF > >  `D #. s/ S. .Q#JsKR
SJPJrG C . 2,JA
2HF#Hw#H8F #>F >    # D #. Y/ y/ .Q!JYK[
yKPJ[G C S" . .JU
JFAJwAJ8FF #> >   D ., Y#, y// y. ## .UJzKS
zJTJsGcJacJF >F >   GD c/4 Q"4 .7 / C/JX
K[yKF9Ja9JZYKpGAG c? C?  `D# /d "d .g S.$ c"  .XKJR
TJWJFCJaCJG# ?F  >   GD' .h Q/k q/$ .UJQK[
qKTJ[G3Ja3JF' >F$ >  @GD+ c/l "l /o 2/( C/KY
7K[cKGCJaCJZCKpGAG+ c?( C?, "   GD/ #/p .s ., /Y7KJU
JXKF7Ja7J0G/ #?G, ?  @GD3 .| R#| r/ r.0 .zKS
zJUJsGCJaCJTJFF3 >0 >4 c"   GD7 c/ / 1/4 C/[sKKY
1KZSKG3Ja3JpG7 c?AG4 C?  @GD; #/ " . .8 /JW
JY#KFCJaCJXK0GG; #?8 ?< "   GD? . q" Q/ q/< .SK[
sKWJ[G4Ja4JUJFF? >< >  @DC c/ # 2/ r.@ C/8KS
xJ[cK3GCJaCJZCKpGAGC c?@ C?D c"   GDG #/ " . .D /JW
JY3KF3Ja3JXK0GGG #?D ?  @DK . r/ .H .WJrKT
JUJtGCJaCJFK >FH >   L "DO c/ q" / 1/L C/KY
3K[tKG4Ja4JZTKpGAGO c?L C?   DS /G . .P c.JW
JXK FHyHScJGyFS ?P c> 4G ] ] }  0 #k#G ^ ~  ( G  {  ~G ^  P  .S `. JS
`J 3F  C  . .JV
JF C    0 @TGJC p D X D>    9!K C!9@ x/ C 8.TG .xKQ
8J .JqG CL q"L .W
JO .GFJU
J CF C [ @Zk  `  .c  . JQ
 J F  C @" `.@ .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd > G  cABD #,D c#G ,;H                                                                                                                                                                                                                                                                           ׅ $      PWRKV50F1050.G                                           	ubz1                                                                                                ^$   $                         ht=     Z       ƺlb@JPu2ް]xW6[w\כ/^-bi?)e.rCB?rO'
xS6u  Uq .9["$LwYpE9dMt`J
"AgG$i}Sst7kRXktJwѻwr;w7N GpS Ph.`p4R3B"~q 6}Gm}_TPLbVqSo7qwؘ/%65DZХFv(F=ؚfbwͅL5lN2x)5bK5RTƦ%fIOR۾[ӟڐ;:9B:#׫gHg_{*fq́7Va0+Ò9C[a_Ci=Yrf)<w j̅57ԅn҈俍)dWֱ|^ֳ±1~!j^.zrG~/nj+lƑ3{Jf6
 F|npsR/֧$35]],Ac9LXӒ8P@7zyd<#`bTjMk\.Db-Rۨ.VD6,ěH
jz%څue2Ks\}ɌiWvf#BJ%
u|Yܗ*370K}b+̨ Ԁ\yC~T৭hg#ӸY<EԃۆQ̾'|ۓǬ?਌c6οfB<b߯M0ɞX6a3NDd4 VĿ*Bzf˧5R	%7`@J#ԧ@5gؿUm_R\vLiy2\;_Lg%-^0
(
0/5Н:_,-Xwd)E+E_1(2eTBYc&	M{Z	cfrKI a	 eR rQ|m:!]׏ժ	
^><{i:3\39"[v <=\xkła`uFO[$.r.է/$Z4p"e(sA2;JtbZ 䯐~m[2P`rs8
VyvVC=)Jk+09/LVy-wa5sUyާGY2qvt>yQZ-X񀧇RXM'?	n'X~KxHRJgӯ_P'OeAYW&yA`wdS4lS|}ѓX
HPam\M-ؔ^~0z{noߴFȬL|ɐ[w	p茆"h;=_mIUY.m&eS>OOۮ^/l!nΤtO!1:0L{
g9ܓ>WA>QCEw5W>Azc60.+{.o_*NDthӃ^1z&'p-o?hj&hV;Wf/@E
1a7SÓ0r.ZnzLhkި

I<#Z:8-8Q~[cum+~ͨ	^ϋ?Vb)vv(gn=vEK`W̰"xU~=<<6X~y,`/hrHNYsaQm-}SfA:
Fiij#B#se4N͑P̥ɱ$Z;4*V
,8x0Nw+m1*͏"1f]e>U
ɇMhf87Yqýl$.9QRap>\	)gzg^bLs&"}77XU'^Zط/L"L0B]:U{D\MD&A>¿솃['T;`<M>bFAq$	!1s\Ժ ]NfmhK^5
ukN2!a(=1peudeڜ1PRj
x8D*,)
Y8
r.7M>#P4:nv PL3	fݍ\
K70G $S;sR*Ttl5:NV廉m>({,8^[K]*kHOQHtP<XLdU7wl)_BL};!X#/[kyUxp}oyREXiY/rhs)t8<L!O JAyv`-fXʠ-{n7Vѵ܅R|J0"ƌ@@y\8ȘqDI=pdW/{tO̓/J3z!J5^ހ4.[O=NZ&XIJDQw;+|`BLdr?(8YXb<rSK+V)	>nhBv?0SSr[*p4#oy<3j632T!Ex1*FYc5>(&8KrPmt/q5׹ɡ@q ]z$kv%"D!2vn0w6/ˀm(n5d6FP~^}0=%bDMcT= 4ao R-X@N@7 n
U Ж"oQ5j<EngZ/~n,Ysg'l,Pd DU\I0u
Z>k-| K}Ȭ.v	,-,9]rsn~r(Mw	ٔ()rt"BC%q g' ZU1.RE
dH6^eSBΕùc>8HD,U,&/ d.{mX\RhYaVo=]\^w}YEWy"֣DB
Hۢo*9:>b6foˈ4Bc%37Pwӕ%beC
"(4R:i61Ajďsr>VG"(LO|[Mh2uàw)]~Ȁ9ٽ)XrbM_ty;Hu}ٔ2LhnXgĳc{,W;!L'P3`4A9(@a:;}'ꈟJS^eaϡ6Z0mmQ	f6Z0ĭD\̩yb珒Y8
g1qK]Ac+]bvزW
Uq}:=^tUxJHgb/SnRrԷy3ٱ5F4 FsOLEO5nkS+S4Av*@yz~^	ElN:F/HP~Jj`YS0
 ԉuTraG }Ãm2 e}}xg\gOb
!1vaBT%ABivlݻOoѶ<HnO6i0Jڜa#S|hUlvrX̈́!;)_Pq>=#OrNnDG0%/IVRb;?1/&'Kn90CڣQM}RɊe@;L*=e7ځ޽ʞʝnM,5;XX!W*y3[nGc:l8+~qHu]Ihs
Bgf!&"e'mhj"78aY%a(~@>@'`'UDʺ."_>*2n'q.WU_!
*(!^C
nԩ[G	l5`c@ሞ嘶1ȁtY<#wԷO;5/;b
3cn%@Qc7V@HG
ף->B_XY.֘B](X4z-;8k{9%cD`9M0Ys_Hd+oE\C1q#o=uYd lS4*տè[ӽ-%faKܮ0[Tdn{N;#t?x'/J]qs&n}7ΐmV(f7:znM}<@.K:"TRNCFi;jZ\T5;f%K?~f-j9ȼeq'E"ȼq-́wRL 9YENܓR;Wh~s̽Y@6ީ@XIĎfޏZ0CG`anٍXL0L+cEQ}N߳ WJѓ6XN2"J
k{xe@56>h~B}&Ƶbj,/I$թW㒪X.=kμSZ3K_ZD*T&d<
 u|	kpp0
c]0gλ1:EBXaIQѐ^ǥ"hf| ~am;
$MSJD)7q[+\oK5U;HwcRG`c8aX6Jʺ6bRwѭ,:hu'1lck@%T/cz*Gi#$DqBUR(:*6\O%J-j.Dd[cb x`MZǣUH4By-%l.*!Ck7^Ϩlof%IWF'bc?ַ'>mn85pyfVgIDzE!bHF-WSy hʰVeR>Yr֏u5h>c+*pLb<+
_	p|	B6O2-#7i'g/~h0}+ @4lQg2a^#_4sHa(ֿL@s(s =F7W'G_C\}֖3	8ąMr?1e/FH|ăUCQmul&TZ4*3O[`М~rb3"$\\}3,[xOŨ&֨%n5pVP╱D܊YB 
}/uNwr#XV9N7)@/շޭ#k\#N3Blj?Ǻc-^o:L3˞
Jm XInmnUu˥#㕰=kGAP&?'95x
~ ,!CP
"b3/g{;
v=EEj+ʈMWLGijWH%P۬UV(\m>8=MKfԩ^mQ@1dl*+jS ɾ;KÛ^f{#.ѺT2dsz'Fh%eh#?[]PnxMUk43t E-5;YL\? b4}R@s*lviYK̾d[]
I!ؾ{L甿RGn[%0hSțҔ' IIDѹ_nS8a/xquU(\{Y!
7wD}$ZhӒ6G ̰Cfd
l;NI~HF1MYa[YL1=@gPw,Uj,bkO:N`|THAcݐ#2%)+p,Fjq1U3[FEV=
.rT}.zIC\gp\
b|c_:Gχ'2ID{>;"a/ځ~C`B4zi ?Ա
ܧpt=!ֶNx6ߥn4嫦qdqU*jxO-a~G(ο=71xH3.crmiC؈@[EUָ.s]W@a p2&mJ`s;XY		WّX
pbLoyb0Z{MzFx+8e`n7U
ЏCJ4m6mq37żd<W~{aH^FMmVd_@F
yX؃Ey<Onz1
B=)HDS,ۘ&FI,,b!p7M@!ȃBES^rOC:)LrϬMo%cl<`yܜNB~E 7n[ʓ'V^J|SfA6zƅ891V\"gU /HߞQs.o(-1"UaB`p
gE0҄.K]t'>c7ʨe&6jsVҙыئT#df\:@mQ7ަ_SZ+@L:CY]x>r}%HM?7c_$\w޵7߾~{Jlɻ~6
"=l%Ygc`8&8-:
jQ) (g4FCfsIP~1~!޾!ĖPeJΪG@\p1YV*"b5}QM'eH,k.f^o/FJ2X	/@9lFUhHW5'B^Iޑ[l<?y,.y{fvbAbH{1ɖ<z;$wܾw:
-k&Dc#;ejNF"cuMD;>C@1))m]
5Q2@MG)PD	̊ BܿyYh5ƺWpl" c={]Pm_/ЗVV9?:DArs:/8zf58/X۸P)C=H5GدmP9~
	?u'dKF	p4:"$u#
:2gzTb74Ge5eU5?80P1
1'ˇ G..Նơpqn9MS
b|X<,Pq	i5+nSK?Տ&ྖ{-?Vb<cPGf	@sӋFO;lz\Vd]?
lSORbR" Cs*4y5dg$oZz/qlmRxBGva]X
waБF:N-ROt7{cigGjGl\BX[_E*FK|zzK(OhEBPB$	8	9x0pA*vIo5$꺇=2%DH/݅*GDb
9=J@k}T@"&c'ܙ=p'Dv'Μ--Vl7*4Bk!9R{BL.qhђo
r:g.'fH
g_p`
T^*8 A/L_H_әL2LO9c,!Y^@g`ᜍjG"_C'7hƌTAd?H	Qqc;se*(7${P*.*O1qx
ܖNX^-8K).ˎmKO+c촎"wR	 g+elEh  ml+v֤>507ʁ؍;ۗ29wƟ[QKӔyDz>lڔzsZLxGq..N\R()ko6'fZiD)x/ywvTù1ztVr봜K%JG-#l{ĥ/	܀ڇV|\:ѯ:g̿ǄbCJuRUq_!3%Ov(bH'z=
>W[rWkF/E8vH4yn^gzgG=QՋp/6e:v; S+ V^ݳ3e5h;f7/Ǵ%eL K#XT4ҹn$#Sd7>Ak?a)o| ڵs	%1DDZQ6k@
6ND7No(ѫS6T[!7J$RK Fw2D1*%
k8ҝ<u{O7
:	?tb|TBq$C?gk2V@xnrkv@wYU'}l_^4jPg #*?((f%?DW\{k&)AaX._B	[lðfS.BiHb8]M2#`N(                                                                                                                                                                                                                                                            : $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        - "     E       D
H$D C   k .4Gh .rJwrJVJUJFFk >h >G ] 4G ] }  ( 0 #k#T    ~  ^ ^ ^  ~( 0 T 3,GW .GG HT
J 4D  C  . .JW
JF C    0 @TG KC p D X D  X #.[ C.9!K C#JT
CJRCJtF31`BcJQ#JscJ!9@TF[ C> C3FX #>Q 5    [G( {4GMGZk+   @.IO?$   .B!  HR@Js HQ JTF @>3F   > D .Q?$ .RE!  "5HWJx5HVJF >F >G\ c/_ ,\ C#zKQ
H@HF0 BJ[zKpJ D_ <pG\ c? Q N G c.G .cJT
JtF CD # D .G . d JV
JF C [ @Zk . $,HqHPJA#HF1D > $<DHD .vDH .UJTJF >F >  D/D $/KZDK{KY$K@G D?;G $? =T a,W .T ! aHR
JPJ2F0 B!JCaHq!JF >qD  a< ]@, ./ ., B JU
JF C    4GG ] ]  }( 0 @ #kG# Cp^G  [x^~޴>^~޵G  G  ~h "jZk  B "  ^GA jZk"  BGt $,.   ^4 @$Hl V
Jp jZk6D C4 @ 0G$  4 @aF   " < " D  B 6 G$GGTGx }H | ݢX(}
b#,ݲ.@  ' GG\TG
b#H .@   GGG`TG
b#H .@   GGGdTG
b#H u.@  
 GGGhTG
b#4Gk.@H? D$  C¤8DG  b#  "  4G-@= G` B4Gh bGGNhZkG C b#( -@( ](R @AB1@I EMS @ C@FaBL1B-TB`F A.vB & Bc"CGGb#!CD0L B$H8CD $G
G@8 DP $ݠbCC @s" (BG4G  Gb#t@ C$ 8 D @   C`b#@9G_#TGb ="   0 ?"bA  @  Ӱ7@,  ZB0 ݰ EC4 ] @  
 -BA lB AKB8 ݲVB< A@ ]BD GGGH }#GG  ۱8K X-f8K  ,BBCJXIDH
@ED X=  <  G X-$K ,r$KJDIFH
CED X= A < !CG X.xH X-`xHRXJJXIDF
@E X> X=  G X.dH X-fdHRDJJDIHF
FE X> A X= "CG X-xH -rxHJXIHI
@EE X= = !G X.hH X-fhHRHJJHIDF
FE X> A X= #CG X-xH -rxHJXIHI
@EE X= =  G X-`H -r`HJ@IH I
DEE X= = B  #$C {#AG  ۱8K X-r8K  -  @CJXIHI
FEE X=  = KG -j K ,0BH IFHED = < CC #(¤!C {#A C  &HC% ,  A.!IDHcIRAJD <CF  A>  ơ&CB"
 C N/ # ./J{JZXKY8K@G;G N? .? C  & C4 })1 A A- -aHJAIraHHI
@E A=E =  ơ ./ / "JY5KzJXK;G .?G ?   , `,JhJDHC`HDhD < `<G  F@ ݡ / " .IyIXKVJGF ? >  f {,H ;,dHC{HA;HhD {<$D ;<  F . J. !JUJvJRNJF >VF J>  &# 9,  ,HcHA9H@H$D D# 9<  <  ' E-$ !$ e/(Jn(JJHI[hK
REnG' E=$ e?  / ,, ", /@HXK/ <, ?  &3 ,I0 ,yIGHDHD3 <D0 <  ( 7 %.4 E!4 -
Ir
IQ*JNI;FE7 %>4 =  ;  /`J8 .a`JX KVJG;  ?F8 >  ? $/< -<  gIY'KzgIMI%G? $?
E< =  FH ݡC j/I@ J.`I[jKRJJaGC j?@F@ J>  fL }G /D "D .IdIXKVJGFG ?D >  P }K G/H '/gJ`gJZGKY'KAG GK G?H '?  FT O j/L J.L *"qI[qKcqIRQJdGO j?CFL J>  X ݡS /IP .`IXKVJGS ?FP >  \ W G/T g"T '/IcIZSKY3KDG#GW G?T '?  F` }c j/` J.I`I[jKRJJaG@Fc j?` J>  + .eI( .xeIVJUJF+ >F( >  [ d.X -SdJNI[ d>X =  &X ,\ Y![ 9,_ 9.H\ -A
9HQ*J D
Hr
HMI;F_ 9>
E\ =  fg -d c-d  LIg =KeId c=  d /g ,d "k u.KD
Hh -SuJGHaHNIzFEk u>h =  o  .l @!l -IrIQ*JMI9F
Eo  >l = _"  fs {-p ,K{IEHs {=p <  w ,,t "t /A6HXKw ,<t ?  { d.$Ix -u$ISdJNIzF{ d>Ex =  4G -| @!| -OIMI =| =
B  &⥃ ,QJ q,kQJEHCqHD <kD q<  &B / ! .LJdLJXKVJGF ? >  & I/I .`IZIKUJJG I?F >,o-!8 , o < =H4 K
cID C4`@  & o! . i. I!IUJzISjJF >zF i> // o/+K[
kK;G C4`A   ƢG$ " V- 6-  KJEInKI%I
SE V=	.E 6=$ O/' //UKY
5KYG C4B`   ,- , L"KI2IjKEH	.E ,=D <  o.# .oJV
JvF C4`B   G '- " ,uIjuII5IEH	,ED '= <( -+ O.IR
OJE C4A  F ,J ,iJGHEHD <D <0 -3 .IU
JE C4A@  f4 /#4 ,7 , . 3!H S-G
HP	JDHzHJIIF
ZE > S=  8 O.; , ,OJ@
H u,DHb @FHlHCuHD <lD u<  Ƣ G]"  C 6-J ,jJI6IEH	0E 6=D <  f, ]I ] s,dI 3,CsHA3HlD s<$D 3<  ơ C4]P b .-.J ,j.JGI.IEH	0E .=D <  C =  Fp 7B08<}@}D
 CH Z- -  bZIN
I  BGL=NEP CT}
GfZk  & C  B CFD% 9. Y. "G0JR
PJC!2F Ch ]"GfZk  &  ]" $  tG }SD    Q/ q/ =QK[
qK  ]G[G  B CGfZk  B   ]"GfZkb  Ƣ@ c      6-H -jHI$IMI	!E 6=
E =@ G  GIdI P. W! p.qHGPJS
pJSF CBH   7,pI  ,GA7H@H)D 7< D  <F .I -T 7 VJMIF
E > =; 7/8 w.Y7KSwJ GpF; 7?8 w> W 7-HT ,jHBI!IDH	-EDW 7=T <0A  &3Ki3KI . .JP
JqIF CB " ; ,G8 3,DHA3HD)D; <8 3<H .dH  -T S!UJMIF >
E  =F 3,
H .q
HA6HPJ)DF 3< >P7!W -T 3/MIY*K
EW =1GT 3?  ImI i" 5,H ,PA5HD
HuH$D C:@ G I-  .JIIVJ
QE I=F  >	?E ,IJ )/mIJDHY3KD5G < )?T  ; I-H8 ),yH"JIIA)H
QE-D; I=8 )<
pAW ."T i.BAUJSdJFyFW >T i>VI  &sVIBC . !.JQ
!JF C:@I ; 6-pI8 , V#HI6IDH	5ED; 6=8 <iH -T "  v/H y"MI[vK
EpG =  v?qHF , 6,DHA:HD)D < 6<GW .T -PJMIFW >
ET =  f@ = [/ [- ;!HZIK`HJIIMG [?
@E [=? .5@< A.< !"JUJvJRQJF? >VF< A>? .B< p.< !IWJyISnJF? >yF< p>? -A< L-< ,!HMIzHJII
E? =
ZE< L=? .@< G.< '"HUJvHRQJ@FVF? > < G>G? !/5@< .< a"IY3KlIWJ0@)GF? !?< >D!G_? n/G< N/< !J[mKgJZMKpG? n?GG< N?  &CB&CB?'0 G8 .; .  B"JV
JB9#F C	G%B.eB.K .,g.K  N- aBHA.HJNI-D
GE .<  N=zH3 .4 N"0 .HqHTJPJFF3 >0 >  E7 .J4 .pJVJUJFF7 >4 >nJ -`nJ N-, ."vqJMIJGI
E
PE = N=qJ+ n/H( N/pH[nKZNKaG+ n?@G( N?E/ ., N.UJRQJFVF/ >, N>1dBC -@ N-MIJNI
EC =
PE@ N=  D @/G `/D   AK[
aK [G  C   @. .GJU
JUF C    0 @TGJ p D  
8 D= @k .,h .
4GIA.HzITJ;Dk .<Fh >Eg .d  d N.\ "UJRGJg >d N>l . E_ .0A\ ..	2AVJQ0J_ >\ .>	AEc N-rB` ,JNIc N=@H` <o .l -TJo >MIl =  F , Z.HR
ZJD C " . '.JQ
5JF @_ GHb#5@ 0   CG  FGBGbtG0 -SB$3 ,G IG
HE CumZk  SB&GGs"@b#0 (-G3 -(IL
I,E CH -nH  E-MIJEI
E
NE =  E=  &0 !.3 A.!JR
AJ2F C " . .tJwtJVJUJFF > >_  G@b#G_G`b#G&@  GG@b#_  HR$T L& -TBs" ,ID
HE CH -nH  D-MIJDI
E
NE =  D=  & !. A.!JR
AJ2F C " . .tJwtJVJUJFF > >  & y/ 9! - -yK ,H
IIhG C@
	H H- , EHJHImHGH
NE H=D <  D  P. 0,PJA
0HAF C " . .JxJWJVJFF > >  f - ;/IY
;K	E	 C , ,GH <DH <   . (. - -JQ
(JIN
IF C
E .
 C  .HxH -,WJ .VJFF >  >-H  T
J4D l/ , CY?@lK@
Hy9C `G  C    - ,dJndJI$IGH	*ED  = <9!K   - P. " -IR
PJ .I
E
 CU
J 
/ .E
IX
Kz
IWJGF 
? >
4G  fD  , ;- @HI
;ID C D! $.*K -r*KQ*JNI0F $>E =   - -IL
IE CI /zI .XKWJGF ? >  & - 	. , I-IP
	JHJ
II	E	 CD .  . CHUJgH D.TJ $/F >F  >  ƢDJY
$K / V/YF $@KZ
VKA?@G C V! . -jJ{jJP
JNIFE > =a!@  F!!H  @ , , ! 2-HG
H -(ID CL
I . .,EIWJxIUJFF > >  F 
. *.
JQ
*J
F
 C j" j/ .HgH[sKVJyG                                                                                                                                                                                                                                                                           T? $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         "     V       F j? >G  &Pb# I. ,IJD
HDF CI . -uITJHIF >E =  O/ /,  cOKA
/H  AGG;   . 8.JQ
8JF C   , P-  cHJ
@I D   . 8/JY
8KF CTGn@ 8 D  T %   &TGGPb# , , HE
HD C^@ 8 D  T    ƠTGG - -Pb#IO
IE CN@ 8 D  U  G  cb#@$ Gp]x]}ݤ=]}ݥ#k) "'B Z  栋 .gH G.xgHVJRGJF >XF G>   ,   d,`Il`IGHC`HDlD < d<  & , a,  JDHgJC`HD <gD a<  F :, z# ,{Jc{JA;H@H$D D :< <  & y, 9,  IC`HdIA HsD y<$D 9<$  Ƣ v,I 6,dICvHA6HnD v<$D 6<+G# ; ^ ~  ( 0 GG  ~G ^  @E  \@C  kTGGHb#   0, 0.0HQ
0J1D C A" a. .rJT
JtF   0. .0JU
J5F CG"@  TGGHb#  .  . JQ
 JF CG@  GGTGHb# %, .%HP
J0D C
@8 b#GG @@   eb#G @   GXBG`b4GWZkG ] 4G ] }  ( 0 @ #kG# ( ^C0 ~G8 GG  ^"[ D >4G  ~G >{7JGGG^_Zk  BbG4G}WZk =CG CBb   0. P. " }0JR
PJ 2F   }G G G tGe_Zk  W "  =GBGbtG    jZk( b0TG0 B  c  8 b C `  b CS_ZkP @ B CH bTGG&MZk GI  }G G  ]( ]0 }8 @ #kG# 0 ^G8 ~G@ GG( ^"0 [ > D ^4GC  >  ~GG8 {7JG^Zk    BG( b4GWZk = C@ "G Ch btG      Q.G q. QJ S
qJSF  G` BG  ݲ  ݲ^Zk  V   =GP BGX btG    AjZk J   }G  G( ]0 ]8 }@ P #kG#4G ^ G  ~G   ^[  {	EZk G  G ] ]   #kG#4G ^ G  ~G   ^  [  ( {DZk G  G ] ]   #kG8 #TG  ~    ^ ^ ~  (   .G  .G  [G JQ
 J0 F C( { #  . #.  JQ
!JF C CfZk #,TG .0 B#H  BP
J( bR"0D C CfZk #, .TG0 B#HP
J  BR"( b0D C CeZk #,   .TG0 B4 d  H  BP
 J( bhR"0D C CeZk4 ,7 $,TG0 HA
#H  B@"( bD C CeZkl ,l d o $,TG0 HA
#H  B"( bD C CeZk ,TG $,0 H  BA
$H( bBD CeZk $,   .TG0 B HP
 J  BXB( b0D CGeZk $,   .TG0 B HP
 J  BSB( b0D CGeZk $,   .TG0 B HP
 J  BNB( b0D CGeZk ,TG $,0 H  BA
$H( b	BD CeZk $,   .TG0 B HP
 J  BEB( b0D CGzeZk ,TG $,  BH( bA
$H0 D CoeZkG ] ] }  ( 0 #k    # ^ ~  ( 0 ޴8 @ H >P ^X ~` h GG  ~G ^G  G8 [G@ {G$  /$ "'  /G  .4GK# .Y
7KJGV
J CF C
^ZkW@	G  W @@ .C .JV
JF CtD M! < */< 
#? *,G8KA
8H
!G
 C @8E8E%  G	b#GGTG$@  H! GG	b#GTG$@  H! GX 4G  (L"  0. P. . a" .0JR
PJJU
J2FFF7DG8E9 b#T@
 C J# . C j.*Hu@KTJS`JFuF >@ j>@
_E 
, 
# j/G8H@HzXK[xK D 
<zG j?
_E .*J .v*JUJTJFF > > * 
_E 
/!J 
.z!JXKPJGF 
? 
>G
_E .JJ .vJUJTJFF > > 
"
_E 
/J *.zJXKQ0JG:F 
? *>  j"
_E# .  C  J.
HTJujJRJJF# >UF  J>
_E' 
/$ *"$ .HXKzqJWJG' 
?F$ >
_E+ J.( * ( j. C
JRJJt*HSjJUFtF+ J>( j>, 
 
_E/ . J, *.x HWJQ JF8F/ >, *>G? J.< j#< *,JsJR[JA;HTF3D? J>< *<jH
_EC 
,pjH@ .D "@
HUJ DFC 
<@ >7I
_EG J/a7ID 
/HZWKXKRGGG J?D 
?vH
_EK .L 
 H j.HTJSjJFvFK >H j>qH
_EO 
.T "L j,7KP JC`HFqDO 
>L j<d7K
_ES J.HP *,{HRJJA*HS J>P *<\ j 
_EW J/HT 
/uHZWKXKSGGW J?T 
?LA
_E[ .GX .H BtGVJTJF[ >FX >
_E_ *.SB$\ ,P bF Q#JEH!F_ *>D\ <GgZkc ,H` j,gHd * EHCjHDgDc <` j<SB$
_Eg *.F  d 
.HQ!JrHPJ3Fg *>Fd 
> . 
# . j#UJ >TJ > .G
_E .WJ >VJ >
_E J/ */ZXKY8K J? *?
_E , j,DH <C{H j< `  $ ,$  ' ,H@
H D  C@ A  @ ? +.< + < .AIrAIQ!JPJ3FF? +>< >8E 8 ,; .HV
J D  C  GG ] ] }  ( 0 ݤ8 @ H =P ]X }` h p #kGkG ;   0.   P. " . JR
@J .VJ2F C< r"< ,UJ? 2.HQ
3J DHwHF >F >  !8 ,; . . .HP
JJ DV
J@ @F C  BFB  @  ( .+ .JT
JF C p" . .JV
JF C     ! G, ./ /, "JU
KXKuF0`BtJWJstJG/ ?F, >k            #4G ^ ~  ( G  {  ~G ^  Gb#  .  . JQ
 JF C@ C  V G .TG $.DJGuDJJpb#Q
$JGF Cx F2   . d.TJSdJF >uF d>_ $. . 4GHQ$JrHPJ3F $>F >   . .JW
JF C  P 4/S T/ 4,4KZ
TK . H:G CP
 J [4G0D C @ZkGG b#_G $,   .G .$J d. HP
 JTJ0Du$JSdJ CF >uF d> [G @ZkG ] ] }  ( 0 #k    #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, "ZCKY#KAG;G C? #?K/ C.`K, #.G$ # RPJQ0JTF F/ C>, #>AHD' C/{AH$ #// ., "ZAKY!K@G' C?;G$ #?5JD# #.CH  .rCHW
JQ#JPJ4FF# #>F  >+ .JD( .WJ`JF+ >VJf@F( >7 c/4 ##4 C/KpK[yKZYKqGPG7 c?4 C?4 C"D7 ,RK3 .0 #,H@
HUJ FHvHA#HF3 >6D0 #<; #.xHD8 .Q#JD C#9F; #>PJHF8 >G C.tHD c/ @&1@RZJ[zK@FtGG C>D c?HDK .vHH #,L "UJA#HF6DK >H #<HDO /yHL #.T "XKQ0J G9FO ?L #>\ "DS C.d #"P ,GRCJDHS C>P <E @DW c/%HT C/[tKW c?ZTKT C?D[ ,l "X #,FH[ <A#HX #<D_ .\ .WJVJ_ >\ >CHDc .uCH` ,PJc >@H` <Dg #/pCHd /Y1Kg #?XKd ?Dk C.CHh ,| #RCJDHk C>h <t C"Do c/Gl C/[tKo c?ZTKl C?Ds ,p #,FHA#HD5Ds <p #<CH{ ,fCHDx .@H DWJ{ <CHFx >pCHD , "| #/DH <Y8K| #?Dw C/t .ZRKTJw C?t > C" #, c/A#H[cK5D #<fG c? ,<  D .@H DVJ <b@F >@D / ,XKDH ? < =D C/%C .ZRK C?TJ >  %? c/< .&H[fK`&HUJbGF? c?< >  e   G ] ]  }( 0 8 ݤ@ H P #kGGb#_tGGGb#_tGGGb#_uGGGb#_uGGGb#_vG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGGp{#x_G ]   #kG# ^ ~  ( 0 G    ~G ^G  L  .O @.L   !JR
AJ 2F  C  . .JU
JF C    0 @TGJ C p D X DI    C8KG@ W/!8@C w/GWK[
wK[G Cb#_b@     $ %/ E/ q. .%KZ
EKqJT
J:GtF CL "L .O . CGJW
JTGF C [ @Zk  d@` #,c .#HP
J 0D  C @" `. .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd >   dP ,S [.HR
[JD C  . .JP
JF C    0 @TG J C p D X DJ    C6JG@ /!6@C 5/Gb#KY
5KG C2_b@     $ %/ E/ q. .%KZ
EKqJT
J:GtF CL "L .O . CGJW
JTGF C [ @Zk  d@` #,c .#HP
J 0D  C @" `. .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd >( Gd #,d c#g ,GG;HE
H%D  Pb#_  H ,K $,HA
$H D  C  "  . @.0JR
PJ2F Ca@   g .d .4Gd "tJVJwtJUJFFg >d >G ] 4G ] }  ( 0 @ #k            # ^  ~( 0 8 ޴@ H G  ~ >G ^Gd 0.Gg P.d "G0JR
PJG2FG h #,k .#HP
J0D \ #,_ .\   HP
 J                                                                                                                                                                                                                                                                           補 $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        fU "     g        0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, "ZCKY#KAG;G C? #?K/ C.`K, #.G$ # RPJQ0JTF F/ C>, #>AHD' C/{AH$ #// ., "ZAKY!K@G' C?;G$ #?5JD# #.CH  .rCHW
JQ#JPJ4FF# #>F  >+ .JD( .WJ`JF+ >VJf@F( >7 c/4 ##4 C/KpK[yKZYKqGPG7 c?4 C?4 C"D7 ,RK3 .0 #,H@
HUJ FHvHA#HF3 >6D0 #<; #.xHD8 .Q#JD C#9F; #>PJHF8 >G C.tHD c/ @&1@RZJ[zK@FtGG C>D c?HDK .vHH #,L "UJA#HF6DK >H #<HDO /yHL #.T "XKQ0J G9FO ?L #>\ "DS C.d #"P ,GRCJDHS C>P <E @DW c/%HT C/[tKW c?ZTKT C?D[ ,l "X #,FH[ <A#HX #<D_ .\ .WJVJ_ >\ >CHDc .uCH` ,PJc >@H` <Dg #/pCHd /Y1Kg #?XKd ?Dk C.CHh ,| #RCJDHk C>h <t C"Do c/Gl C/[tKo c?ZTKl C?Ds ,p #,FHA#HD5Ds <p #<CH{ ,fCHDx .@H DWJ{ <CHFx >pCHD , "| #/DH <Y8K| #?Dw C/t .ZRKTJw C?t > C" #, c/A#H[cK5D #<fG c? ,<  D .@H DVJ <b@F >@D / ,XKDH ? < =D C/%C .ZRK C?TJ >  %? c/< .&H[fK`&HUJbGF? c?< >  e   G ] ]  }( 0 8 ݤ@ H P #kGG b#_tGGG b#_tGGG b#_uGGG b#_uGGG b#_vGQ ?B1!JB    8  .;  , JA
 HF C3D	  D  .G .D  "0JT
J4F CF  <  .<   ? .!JT
J 4F  CkG#  ~  ^ ^  ~( G` 1,Gc Q.1HR
QJ2D C  !. a.!JS
aJ3F C    0 @TG@JC p D X D  d .g B.1!J Cd b"!1@Q
SJJRSJ D 1 @HPJ`HQF Cg B> Fd >5 `Q n G [G{4GtZk*   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >Gh b/k ,bKQ
H@HF0 BJ[bKpJ DpGk <h b? `Q ;  b.G .bJT
JtF CD 3 D .G .JV
JF C [ @Zk #.H .rHQ#JPJ3F #>F >P .a@S .JV
JF C " / 5/KY
7KG C    B/ b/GBK[
bK[G CH B.K b.BJS
bJSF C [ @Zk }   4GG ] ]  }( 0 #k# ^  ~( 0 G  ~G T " ^G ^T 3.W S.0JR
PJ2F C  , 0,HA
0HD C    0 @TG JC p D X D  X #.[ ,2AJ C!2@T
H#J@HTF21@BCJQ#JrCJ D[ < C2FX #>G7 Q  G  [G( {4GtZk+   @.IO?$   .B!  HR@Js HQ JTF @>3F   > D .Q?$ .RE!  "5HWJx5HVJF >F >G\ ,_ .\ c#HR
JPJ2F0 B;J@Hq;JF_ > D\ < Q O G .G #,JA
#H d F CD "D .G .JW
JF C [ @Zk . $,HqHPJA#HF1D > $<DHD .vDH .@UJTJFF > >  D/GD $/KZDK{KY$K@G D?;G $? =GT R , a,T .W ./ ., ! JW
JaHF0BP
JUJJTJvJpDFFW > CT >    4GG ] ]  }( 0 @ #k#G  ~ ^ ^  ~( 0 8 ޴@ H P >X ^` ~h p x G 4,G .GG4HU
JG5D CJ '/zJ / '"  Y'KXK;GG '? ?GD g. " G.SqJ g>RQJ G>D .$" ',UJ >A H '<   O  X/ x/XK[
xK[G CPB  0   G i. I" ),X rJA
2HaF  G .P  i/J[
iKF 0 X/3 .XKP
JPG C P. p.PJ[
pJSpJ;D0 @0HRPJa0H{F p>AF P>h 	/T 	"k )/X .[ 	,	KA
)KJAG@
	H0@CY)KIK FX	KzIK  C!GGk )?
@h 	?U BST ).W I.4G0JR
PJ2F C8 F  bGrZk . ',HqHPJA'HF1D > '<G  D .gJwgJU'HVJFF > > '#D g/ '  G/Q [yKZYK g? G?D . ,PJ >EH <"G .4G f. F"2JTJu2JSrJF >uF f> '/ " /wHzwHY7KXK;GG '? ?  d@X , '"[ 	.HP
	JD C	@
   g. G.#@qHSqJtqHRQJuF g>TF G> G / " .HyHXKWJGF ? >  0 .3 ,J@
H  F  C `,  .`HS
 JQ JSF0@B@JC`Hr@J3F  >rD `<x .G{ 	/H .K .JZ
	K@ ,JC .U
J:G0 CFX	K)KWJy)K CGF{ 	?Hx >V
J [TGD C @Zk  g, ,4G0 BGgH8 bE
HeD C zZk ,H '-cH  FHI'ID	#E < '= '"D . ',P JA H > '<R D g. G.SqJRQJ g> G>à . .  JV
JF ` 7/c W/7KZ
WK:G C  7, .7HP
J0D C    0 @  hTG Jd " p D X D  d .Cg /2AJ CJZ
KXK:G91 C6KUJy6K!2@Gg ?Fd >
 C0 BGb4GqZkn   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  H
Gh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh <C @  hG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk *.
H 
.r
H, "Q*JP
J3FF *> 
>AA, ./ .JV
JF C     袤 I! 7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk 	, ),
HA
*H D
   ). I.)JR
IJ2F^P Q X   P .S .< 5#< U/JV
J? u/x .YKF{ / CJ  T-X
K T.[
yKFTIR
TJ[GB C
REbwD
 C C +ARZk
TEG @0 /C3 5/KY
5KG C  6,# .6HR
JPJ2F0 B6JA6Hq6JF1D# >  6<G I/ i/IKT
iK[iK D 0 @	HZIK`	HtG i?@G I?  (b#S_ӛ   HGGG@ *,4GC 
.*HP
J
G0D C%_ C) G  b#!_GGGGGb#@Ӏ  , -GIeGIFHLIDE < =  D ', " '- A$HI$I '< '=D G. '.RPJ G>Q0J '>dG  G Gb# . .
G@ .eGIJC .U
JJF C # 4/ T/W
JG8KZ
XKF:G C C _ =GGGGb#m@?  g-GI - g  ' KgILIfEE g= = D '- ,I#IDH '= <D '. .Q!J '>PJ >$G@ u.GC .GGuJT
JtF CG_
 C @G b#_
 C  H  C0 
.3 *.
JQ
*JF CG  a.# .aJV
JTJF0BJSaJuJFuF# >  a> 	/ )/	K[
)KY)K[G0@CIKX	KzIK;GG )? 	?b#  (_    GG@ E-GC %,4GEIA
%HAE Cs_ C) G G b#n_GGGGGb# @   ,gI ,cgI '!EHFHDD < < '"D .  ',P	J >A)H '<D g. G.SqJRQJ g> G>   G G  . .@ .JC /V
JJF C 5# U/ u/X
KGYK[
yKF[G C Cb#o_ =GGGGb#@GD G   b# . (.@ H.JQ
(JC h.HJF C " .S
hJ .GSFJV
J CF CGGGJ_GGGGGG`b#@h   , g-GIFHmIKgID <mE g=D ,   '- ' EHI$I < '= D '. .Q!JPJ '> >K   GGG0 h.G3 .H G!hJT
JtF CG .G .JY
JWJG0 CKVJxKFF > >p i/s i-iKM
iIKiIE0AI[iKlImElGs i=p i?b#/ @   -mH g- '! LIKgIEmE = g=D , g,DH <CjH g<D ', G,A)HBIH '< G<  G N G ] ]  }( 0 8 ݤ@ H P =X ]` }h p x  #k# ^ ~  ( 0 ޴8 @ H >P G  ~ ^GG( Q.+ q.G ,G 0,QJS
qJHA
0HSF C( q"DSFG Cg @d 1,g .d   HP
 J 0D	  !B   g C.d "d c.RTJStJg C>d c> @X &, g"[ .&HP
J 0D  C	@
 @ ', . @HA3HfHTJ0D '<F > G . G" .HwHVJUJFF > >   ,HD ',FHpHD <A HD "0D '<@ .C .D ,G C.JD ,HR
TJ /V
JDF C$@ BH@HaHXK D <G ?P .S c.JT
cJScJTF0@BCJPJrCJtFS c>FP >G   "Gb#  Ȣ0 ,3 6,HA
6H D  C$ "$  /'  .KS
JPJSF0@BWJXKrWJF'  >G$  ? &,G .TG4HY
JUJF0BJA4HvJF >6D &<  h_Y   (G !. A.!JR
AJ2F CH .K .JU
JF C [ @Zk( #,+ .#HP
J0D C   T .T "W . 0 @TGJY
JWJG81 CKVJxKFFW >T > JDP .CS .d .d c#Jg #.X
J:aJF0BVJJJQ
;JUJwJ C!:@FS >FFGP >p D	 C	  a@   g #.d C/d ##Q9Jg #>ZYKd C? . f# .JV
JFs P /S , C;aJKP
H@H0D!1 @#HXKa#H DGS <P ?"   Ȣ )/ I/ , ,)KZ
IKHG
H:GD C CL /O d,L "1;BKC
wH , 1, "G CHA
5H [GD CTG @Zk G , &  ,GG4GHb#D
HD C$D  _8 ,G; ,TGGHD
Hb#D CU_Gb#G4G"@  !AT ,T  W ,HG
HD C d  , $,HA
#HD C                                                                                                                                                                                                                                                                           _cH $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        ¿ "     x            HX X .[ .JW
JUJF0BJTJvJFF[ >X > X &/ @[ F/ ' &KZ
FK:G C	@ ` '.&@ .HrHQ!JPJ3FF '> >  . " .H`HWJVJFF > > '# g/HD G/[yKaHfG g?ZYKD "AG G?@ ,C ,D #.G C.HD .0JR
PJ .E
H2F D  C$@  @HWJxHVJF >F >"   h )/C I/1!J {, ,)K{HE
HZ
IKeD C:GL #,O . CL   HU
J&@5D . , C f"JD
H [GF CTG @Zk  !AT ,W e,T  HC
dHD C   #, . HP
 J0D C     X h.[ .hJV
JTJF0BJShJuJFuF[ >X h> " / '/KY
7K G  CG ] ] }  ( 0 ݤ8 @ H =P ` #kG# ^ ~  ( 0 ޴8 @ H >P G  ~ ^GG 0. P.GP;G0JR
PJG  i2F CGGGTG {#_  #. . # D D"Q!JPJ #> > "D d.D $ G . .rJ .T
JWJtFUJxUJVJF >F >X g/ "[ ,D .G $.gK@
HJQ
!J `GF  C C @ `H D.K .DJU
JUF C@
 @ / . @HXKyHWJG ?F > G  	   . . p. .WJpJT
JVJtF C " P. 0,UJA
5HAF Hx HF >F >@ $.TGC d.GE H.$JS
dJ .3F(JRHJu(JPJ@F H>F >  )0 .3 /JX
KF C a. ,aJQ
H@HF0 BJSaJpJ D <pF a>x /{ ,H G.K .KQ
H@ .GJC .U
J1D0 @UF@H'HXKa'H C DG{ <Jx ?W
J [GF C @Zk   '. .4G ' aHQ!JraHPJ3FF '> >( .+ .JV
JF C   T ,T d#W -C 0 @HQ
ITGqD#1`@9KHI{H@KFHc{H C!9@EW =DT < p D   C"  C . 5/8K e. .JY
5KaJT
JFtF C CL -2XBO 5.L   R/ 2 I r,Q
&JAKEC
aH CCG [ CGTG @Zk  ,   -GG4GH b#H
ID C D  _8 -G; ,TGGIF
H b#E Cm_Gb#G4G:@  i@T ,T  W -HH
ID C   , #,HA
$HD C     IX X .[ .JW
JUJF0BJTJvJFF[ >X > ( $/+ D/$KZ
DK:G C   T .W .T "D d,D d#JG $.Z
J@ D.WJC d.:G91 C5KVJy5K{HQ
;JFFW >qDT >DP .DJS $.S
dJJSFS
$JQ$JsG0`CdKPJ{dK3FS $>FP > . C .#@ CBhHVJwhHUJFF > > H"E .H ,qHPJDH 0 @TGFD >J <X g/C[ .5AK CgKT
J @tG C!5@	@G p D C  .%@ (/ "HPJqHY7KF >1G (? G / h" .H{HXKTJGF ? > C!     .:AK , %. E.JG
H%JR
EJF2F C CL .O .L e"!:@JU
J !/ , "F C7KF
H [G&G CTG @Zk  @T ,T g W ,HE
HD C   #, . HP
 J0D C     ) "X i.[ .iJV
JTJF0BJSiJuJFuF[ >X i> / (/KY
7K G  CG ] ] }  ( 0 ݤ8 @ H =P ` #k# ^ ~  ( 0 ޴8 @ H >P ^X ~` h p ޵x G  ~G ^G 0.G P.G[G0JR
PJ  jG	2F	 CGGGTG`{#_| D .G $.D $  . I"J i.Q
!JTJF2Hu2HSrJF >uF i>X /D D#[ '/GD d/GG ,KY
'KzK@
HG `G C  C@  H $,K D.  C$HR
DJ2D CC   G  j4G ;. [.;JR
[J2F C 0  / ,K@
H  G . " .HyHVJUJFF > >	@@ D.C d/	?E 	/DJ[
dK 	.[FIJX	K`IJP	JG 	? F 	>$ `  ʢ  V/ v/ ,VK 6,[
vKH[G8 b C " Z.A
6H .0 BPJT
JDTF C C0ALZk	B GG    . -JH
IF C  *D ,D #G .G !. A.H!JR
AJV
J2F C a" A/ a/ ` DSK[
sK[G @X .[ .  *JU
J< "F CA @ Y/C y/< 9.? Y.YK[
yK0JR
PJ[G  B2F( b C @ CLZk
GGGGG{_  C  Gb#G_ C   *G0b# !. A.@ a.!JR
AJC .aJ2F C " .T
J .GtFJW
J CF CGGp !_  j CGTG`b#_Ӡ  .| n.| N"I@ .TJC ..uISrJF >uF| n>E{ /JQ
.Jx .t "FJXKyJWJGF{ ?x >X ,[ '.HQ
'J D  CA @H n.K .nJT
JtF C@
  w .t . @HPJwHVJFw >Ft > G  *t  w .t . 9. Y.UJ9JR
YJP J2F C q" . 1,JA
3HF Hv HFw >Ft > I/ C  )/	KqIZIKY)KSG1G I?  )?0 A  	A0 4,3 -4HN
I .D  C . .JI
JVJF0BJUJwJF >F >x '.{ G.'JY
GJRGJyF0`BgJQ'JsgJYF{ G>3Fx '>  J - .IT
JE C   !- . IP
 J 0E	 C A% . " .WJVJ > >  *0 q.3 1/qJY
1KyF CTG - .IA
JTJAG0@CQKNIzQKFE > =Gx /{ ,H -K -V
H@ '-KC g-IH
IF0BE@HJXKuJ C D{ <Gx ?'I [K
gI !+E C @Zk$   -	4G - g! .+I ',IH
IGPJEq+IA+H CF1D >E '<  `b#G4G%_8 -; '-GGTGIb#I
'IE C_ - -IH
IE C  - ,I@
H	E	 C  G .C  h.!!HG(JTJ!!Au(JShJ CFuF >  h>( /+ 2/KY
2KG C   T .T "W .C 0 @JX
JTGF71B-aKVJJ JUJwJ C!-@FW >FT > p D C#  C .;aK -GTGJ  *M
I

F a. .
 C-AaJT
J . . "tF CL #L ,O A.JW
JHR
XJFD C C [ @Zk ä , ! ',GG4G
H b#A
-H D  
@ GGG b#4G1_  AT -,W 
.T 
  HP
 J 0D  C @" `. .rJT
JtF C     X .[ /JZ
KXK:G0 C5KWJy5KGF[ ?X >  ), -)HM
I	-D	 Ct?( D.+ d.DJS
dJSF C   T /W $/T "CKM
7KY7KMG:1@CWKXKzWK-GGW $?T ? ! '- 0 @ G.TG;J(IR
HJJ C!;@2Ep D
 CL  #   
 
.C .7J  /G @/JT
J KZ
@KF :G C  C0BL `,L   O , p# 0-TG P.aHE
H;IR
[JeD C2E [ C @Zk GG b#4Go
@  ʠAT -W &-T  II
'I	E C f  , ,HD
HD C     *X X a.[ .aJV
JTJF0BJSaJuJF[ >uFX a> GP -D $#S $-@ .IC /Q
$ID D/I$IG d/F0 BJHIpJ	1EES $=P =J #,X
K C.YK[
yK#HR
CJF2D C[G . . C9@ BJUJ`JTJF >F >D , C# c/HDHhH[zKD <hG c?X - @[ .IP
JE C	@
   C. c-%@ # HRAJyHKaI@FyE C> c=  . c" .HwHUJTJFF > >TG!   J 
-C --;aK - .
IIP
JI
-IE C	EL ,O l- CL , HK
aI$@D , , C $"H@
H [GD C @Zk  ʠAT &-T !W -(IN
I.E C   , ,HE
HD C     J "X -[ *,IS
*HA*HSF0@BJJLIrJJ3DE[ *<X = . .JV
J F  CG ] ] }  ( 0 ݤ8 @ H =P ]X }` h p ݥx  #k    #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, #"ZCKY#KAG;G C? #?K/ ,tK, C.G$ ##@HRQJ DTF/ <, C>YHD' c/`YH$ C// #,, "[yKZYKqG' c?@G$ C?D# .VJ  C.CHTJuCHRCJA
6HFUF# >F  C>+ .#HD( .WJ`#HF+ >VJf@F( >7 C.4 C#4 c/JtJRZJ[zKUFtG7 C>4 c?4 #D7 #,xK3 .0 #.HA
8HVJ DHwHQ#JF3 >7F0 #>; .uHD8 C.TJD c#F; >RCJHUF8 C>G /yHD #, @&1@XKA;H G9DG ?D #<HDK #.vHH .L C"Q#JPJ7FFK #>H >HDO .zHL .T #UJTJFFO >L >\ #"DS ,d "P #,GDHA#HS <P #<E @DW c/%HT #/[xKW c?Y8KT #?D[ .l #X ,PJ[ >FHX <D_ .\ .WJVJ_ >\ >CHDc C.qCH` ,RCJc C>@H` <Dg C/rCHd .ZTKg C?UJd >Dk ,CHh #,| "DHA#Hk <h #<t  Do c/Gl #/[xKo c?Y8Kl #?Ds .p ,PJFHFDs >p <CH{ ,pCHDx .@H DWJ{ <CHFx >rCHD #, "| C/A5H #<ZUK| C?Dw #/t /Y$KXKw #?t ?   , c/FH[cKD <pG c? ,< #"D .@H@ D <VJF >D . #,UJ >A7H #< ]GD #/EC /Y$K #?XK ?  Š? ,< c/H@HbH[qK DbG? << c?b@  e   G ] ]  }( 0 8 ݤ@ H P #kGGGpb#_rGGGpb#_rGGGpb#_sGGGpb#_sGGGpb#_tGQ ?B1!JB    8  .;  , JA
 HF C3D	  D  .G .D  "0JT
J4F CF  <  .<   ? .!JT
J 4F  CkG#   ^ ~  ( 0 G  ~G ^     {   # a. .aJT
JtF CAB    . .JW
JF C %/ E/%KZ
EK:G                                                                                                                                                                                                                                                                           B $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        _& "             C   GT D.T d#W d.4G0 B[JS
{J8 bSF C8@F @imZk %, ,GeHA%HpeH@H1D %< D < 4G  .G .EJvEJUJTJFF > > %#  GD E/< X" e/x .{ 8.< x.YK? .[
yK@ .JC .Q
8J[GP B FX brJT
JJV
J C  CtFFD C C @FZkGGGGl_ CG 0b#G_S %.T "P .\ e#P E.0 % GJQ
%JSeJF01 BJtJREJuFTFS e>P E>l E"DT .W /X %/[ E/JX
K%KZ
EKF:G B Bo  \ %._ ,;J@
H  Fi  l e.o .rJT
JtFc @` .c .JW
JF]  D/ .DKV
JVGR 0 %/3 .%KP
J0G CFJ     G 0 @0b#TG J C p D X D  G_   C HTG . @ %.JQ
%J CF CL A" .L a.GO . .rJT
JJtF CW
J [F C @Zk  @` $,c .$HP
J 0D  C @" `. .rJT
JtF C     c 4Gd .d "g .JY
JWJG0 CKVJxKFFg >d > GGb#4G_ 4G N G ] ] }  ( 0 @ #k    #  ^ G  ~ ^G   8 F  X F @x F  Gb# @   Gb#O @ b# @G ] ]   #k#G ^tG ~  G{  ~G ^  [{0  .3  . JQ
 JF CGlQZk  SB_&GR"SB'0  .G{#3  . JQ
 J F  C@J .v@J  .UJTJFF >  >  cG0 #/3 C/#KZ
CK:G C #  #.aK .`aKQ!JPJ2F #> F > ] 4G ] }  0 #kG#tG  ~ ^ ^   0,G 0.  [0HQ
0J 1D  C( {,     *    G 0, P.0HR
PJ2D C@@G  @ @L@QZkc ".` .SB$F  HQ"JrHPJ3FFc ">` >SB$_Dg .F  d .d "HVJwHUJFFg >d > 4G N G ] ]   #k 0, 0.0HQ
0J1D C  1U!@  2,@ @ p. . 0"4 P"qJT
JtF C  1U B  4 p.7 . ;rJT
JtF C  q @4 .7 .4 "JV
JF C	B @D .D "G .JW
JF C H .K .JW
JF C 	B  , .HW
J D  Cw H .  /JX
 KF C4DH  . H `.UJS`JFwF > `>   4,4 " t.4 .4H7 .S
tJl /J 3D  CW
J  , `.F  HS
`J 3D  No .l t"XKUJ6C DNJ!CD3Hw3HFo >Gl ?  l  ,o `.l "4 "6HS
vJl  #3D C  4 .7 .o `.Jl  /W
JSxJFJvJY8KaFo `>6Gl  ?   p" . . , 5,JHA
5HV
J D  C  #  /  ,F C8KA
8H!G CaF5    14 ,4 0 7 p. . .HS
aJJV
J DF  C CD1   ѢD ,D "G 0, . . v"HA
5HJW
J DF  C CD, `  1 4GH .K p. 1, .JS
pJ1HT
JF4D C CF(  kG k . " .uJvuJTJWJFF > >Ë /H .aHXKWJG ?F >G 6, # 6/HuHA8HY8K4D5G 6< 6?ë .J .xJ 4GVJUJFF > >k#4G ^ ~  ( 0 G  {G  ~ ^  G b#  .  . JQ
 JF C @G   U   #G4G !. A.!JR
AJ2F CH .K .JU
JF C [ @Zk $, .$HP
J0D Cx D'  GGGb#4_ .H $,qHPJA$HF >1D $<  c . .JV
JF CH /K 3/KY
3KG CG [ @Zk $, .$HP
J 0D  C x D D. $" d.G .J .QJS
qJWJSFxJVJ CF >F > [G @ZkG ] ] }  ( 0 @ #k# "  ~tG ^ ^ ~  ( 0 ޴8 G 1,G Q.G .G .1HR
QJ0 [J8 {2DV
J CS@F CrsBGSOZk   ¤G  4G0@  .  . JQ
 J F  CG@ `.C .`JT
JtF C [ @Zk  	@? 4GG ] ] }  ( 0 ݤ8 @ #k# p"  ~G ^ ^ G 0, 0.0HQ
0J1D C<   . .6q @
BJU
JF C( ' G "/ # B/@B8KZ
XK:G0  $ ".	VB' . B    JP
 J 0F'  $ .' . B  b"JU
J	ABF `$ "/' B/ B  "7KZ
WK:G  B   G , "" .0@B	ABHT
J D	   B  GG ] ]   #k .HR&  B/Ts"bJ[WJvbJZBKFVG >  B?C&_D .DSs" ". "pJTJ`pJQ0JF F > ">G  R . .JW
JF CD #D R/G ,XK@
H@G C [ @Zk ".H .rH4GQ"JPJ3FF "> > "_D /J .yJXKWJGF ? >4G_D ,J b/pJ@H[bK DpG < b?G_D . B" b.JVJwJSrJF >wF b> G 0, p" 0.G0HQ
0J 1D  C   . .JU
JF C s"."/JX
KF   s/ 3,sKA
3HaG C8 D  0@B	@B s"? GkG /TG  .JvJXKWJGF ?  > p# 0,R_B ,rRB;H@
H  D  C @ `. .`JT
J tF  Ck 0, " P.G0HR
PJ 2D  C"   . .JV
JF C "/"0/KY
7KG   0, P.0HR
PJ2D CX D  ..JU
JF CF 0`B	`B " kG P.4G  .KaKRPJWJUFF P>  > 4GkG# ^ ~  ( 0 ޴8 @ H G  ~G ^GG_ #,4G C.GG#HR
CJ2D Cr   . c" .JU
JF C gB S# . /HqHJX
KF C8 EM   . s/"PJ[zKF >qG s?F .tG 3,JTJuJA3HF >5D 3< , ,  9HE
H D   Y. Y/ s/YJ 3,Z
YKsKZF CL "L .O .A
3H?"JW
JaGF C CTG G4G   %, .%HP
J 0D  C "P @.S `. . .@JS
`JJSFV
J CF C [G @Zk  X E  G x E   EE #.0@ C.@#JR
CJ2F C	@ b4G  s . .JV
JF CP /S 3/KY
3KG C4G [ @ZkpG ] ] }  ( 0 ݤ8 @ H P #k        #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, #"ZCKY#KAG;G C? #?K/ ,tK, C.G$ ##@HRQJ DTF/ <, C>YHD' c/`YH$ C// #,, "[yKZYKqG' c?@G$ C?D# .VJ  C.CHTJuCHRCJA
6HFUF# >F  C>+ .#HD( .WJ`#HF+ >VJf@F( >7 C.4 C#4 c/JtJRZJ[zKUFtG7 C>4 c?4 #D7 #,xK3 .0 #.HA
8HVJ DHwHQ#JF3 >7F0 #>; .uHD8 C.TJD c#F; >RCJHUF8 C>G /yHD #, @&1@XKA;H G9DG ?D #<HDK #.vHH .L C"Q#JPJ7FFK #>H >HDO .zHL .T #UJTJFFO >L >\ #"DS ,d "P #,GDHA#HS <P #<E @DW c/%HT #/[xKW c?Y8KT #?D[ .l #X ,PJ[ >FHX <D_ .\ .WJVJ_ >\ >CHDc C.qCH` ,RCJc C>@H` <Dg C/rCHd .ZTKg C?UJd >Dk ,CHh #,| "DHA#Hk <h #<t  Do c/Gl #/[xKo c?Y8Kl #?Ds .p ,PJFHFDs >p <CH{ ,pCHDx .@H DWJ{ <CHFx >rCHD #, "| C/A5H #<ZUK| C?Dw #/t /Y$KXKw #?t ?   , c/FH[cKD <pG c? ,< #"D .@H@ D <VJF >D . #,UJ >A7H #< ]GD #/EC /Y$K #?XK ?  Š? ,< c/H@HbH[qK DbG? << c?b@  e   G ] ]  }( 0 8 ݤ@ H P #kGGGPb#f_rGGGPb#`_rGGGPb#Z_sGGGPb#T_sGGGPb#N_tG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGG {#_G ]   #kG# ^ ~  ( 0 ޴8 G0 {G  ~ ^    . @. JR
@J 2F  C@ B   . .JU
JF C    0 @TGJ C p D X D2  G  C8K@ W/C w/8@GWK[
wKG[G Cb#_d &,d  g . HP
 J 0D	  @   g f.d F.d &"SqJg f>RQJd F>GG@ b#4G @ , $,HA
$HD C    0 @TG J C p D X DG ] 4G ] }  ( 0 ݤ8 @ #k#d    ~\ " ^ ^ ~  ( 0 d 0,Gg 0.GG HQ
 J 1D  h p.k .pJT
JtF `\ ._ .JW
JF ` /c 0/KY
0KG @Gb#G_    L  .O  .L   JQ
!J F  C  `. .`JT
JtF C    0 @TGJ C p D X D=    ĢC7J 6/ V/!7@ C6KZ
VK . .:G CL v#L 6.JO V.P
JTG;JR
[JF2F C C [G @Zk  d@` #,c .#HP
J 0D  C @" `. .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd >h   dP ,S [.HR
[JD C  . .JP
JF C    0 @TG J C p D X D>    C6JG /!6@ 5/ CK .Y
5K .G CL U#L U.O u/JP
JZJ[
zKF[F C C [TG @Zk  d@` #,c .#HP
J 0D  C @" `. .rJT
JtF C     d .g /d "JZ
KXK:G0 C6KWJy6KGg ?Fd > G  a@D $,D d#G ,;HE
H%D C   k .4G                                                                                                                                                                                                                                                                             $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        9L "            h .CJvCJUJTJFFk >h >G ] 4G ] }  ( 0 @ #k    #d    ~ > ^ ^  ~( 0 8 ޴@ H d 0,Gg .GG HV
JG 6DGGG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, "ZCKY#KAG;G C? #?K/ C.`K, #.G$ # RPJQ0JTF F/ C>, #>AHD' C/{AH$ #// ., "ZAKY!K@G' C?;G$ #?5JD# #.CH  .rCHW
JQ#JPJ4FF# #>F  >+ .JD( .WJ`JF+ >VJf@F( >7 c/4 ##4 C/KpK[yKZYKqGPG7 c?4 C?4 C"D7 ,RK3 .0 #,H@
HUJ FHvHA#HF3 >6D0 #<; #.xHD8 .Q#JD C#9F; #>PJHF8 >G C.tHD c/ @&1@RZJ[zK@FtGG C>D c?HDK .vHH #,L "UJA#HF6DK >H #<HDO /yHL #.T "XKQ0J G9FO ?L #>\ "DS C.d #"P ,GRCJDHS C>P <E @DW c/%HT C/[tKW c?ZTKT C?D[ ,l "X #,FH[ <A#HX #<D_ .\ .WJVJ_ >\ >CHDc .uCH` ,PJc >@H` <Dg #/pCHd /Y1Kg #?XKd ?Dk C.CHh ,| #RCJDHk C>h <t C"Do c/Gl C/[tKo c?ZTKl C?Ds ,p #,FHA#HD5Ds <p #<CH{ ,fCHDx .@H DWJ{ <CHFx >pCHD , "| #/DH <Y8K| #?Dw C/t .ZRKTJw C?t > C" #, c/A#H[cK5D #<fG c? ,<  D .@H DVJ <b@F >@D / ,XKDH ? < =D C/%C .ZRK C?TJ >  %? c/< .&H[fK`&HUJbGF? c?< >  e   G ] ]  }( 0 8 ݤ@ H P #kGGb#_tGGGb#_tGGGb#_uGGGb#_uGGGb# _vG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGGP{#_G ]   #kG0#  ~ ^ ^ ~   ޴ G8 0,G; 0.G  0HQ
0J  1D CP d.S .dJT
JtF C @` .c /JX
KF C  U/ u/UK[
uK[G C    0 @  TG Jd T" p D X D  d .Cg .3aJ CJU
JWJG81 CKVJxK!3@Fg > CFd >Q 5 *0 BG8 b4GZZk+   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  EGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh < Q  G  eG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk &. .HrHQ&JPJ3FF &> >$ "$ .@' .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @ZkP ,S ,  %H@
H D  C  ` !.c A.!JR
AJ2F C  . .JU
JF C      0 @TGJd 8# p D X D  d X/g x/C7JYKR
yK[yK2F11 B9J CZYKq9J!7@rG Cg x?QGd X?7 Q  G0 BG8 b4G'ZZk+   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  EGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh < Q [ G  eG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk $. .HrHQ$JPJ3FF $> >4 "4 .@7 .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk  Gb#d  @ ,C %,HA
%HD Ck_d ,g ,a@H@
H D
     g c.d C.d #" CSqJRQJg c>d C> =b@   G Cpb#G =4G_ 4GG ] ] }   ݤ  #k# ^ ~  ( 0 G  {  ~G ^G  4  .7  .4   k .JQ
!Jh `.TJF !@ Hu HS`JFk >uFh `>  h 7/k W/7KZ
WK:G CK 0 BG8 b4GiYZkP  @ BGH bGGGtGXFZk %.WE$  .T  HQ%JrHPJ3F %>F  >D .WE$ .T   "HVJwHUJF >F >  #@` y/c .yKP
JpG C     #0@d a.g .d A"rJV
JTJF0BJSrJuJFg >uFd a>  h 7/k W/7KZ
WK:G C	@ 4GG ] ] }  ( 0 @ #kGQ         # G ^  ~( 0 8 ޴@ G  ~G  ^4G!  G0 BG8 b4GXZkC  BGC( b GGGtGEZk  %.  .HQ%JrHPJ3FF %>  > $1@	C F ݢ `CG b# @ G ] ]  }( 0 8 ݤ@ P #k# 4G ^4G  ~( G  ~G  ^G      {    0. P.0JR
PJ2F  _  0 B4G  8 b`Zk G4G =   @ BGH b4GPrZk G ] ]  }( 0 #kG#0 J ^G  CG  ~4 F ^G{#{@  P@@Gy#v@G ] G ]   #k# C( G  ~pS J  ^1v J # }GG  H  [  F( { D 4J C ]G  GGGGG{Zk8 D4GG  ] D( 0 # GkG#&P ^ "X ~tG` h p ޴x GH ^@[  =   ~GG @ =#D ] CH{G =G G9EZk0B8bG4GzzZk0 BC8 bGGGGtGhZk@ }     @8`D `  `.Gt H0 @S `JGtF  `>0@  C1@G"b#_ 8 D    d@ G G&  =qHD C  BC0?H( bG  F =C }G  G  G G  GGtG{Zk 8 D   D } ݠ$vH8D 4G  ð GGH ]P ]X }` h p ݤx  #k G FG1v H   CkG G FG1v H   CkG  0, 4G p. "0HS
pJ3D C?@  . .JW
JF CBG8@FF  X@FB @ .1H  q.w1HGVJSqJFwF >  q> #?F 1,8K Q.s8KA8HRXJ5DSF 1< Q>0J 0,r0J  . "A0HWJ3D 0<F  > F 0/5J /a5JY5KXK2G 0?G ?k  q. .qJV
JvF C " 3,7J .p7JA7HTJ2D 3<F >kG k / " 0/ q# Q.GK 1,Y
5KR[JGJsJA;HWF Q>3D 1<?F 1,J  1/rJA1HY1K3D2G 1<  1? " p/5J .a5Jy0J[uKWJrGF p? >0J F /  .XKVJG ?F  >kG . Q" .JW
JF C2J 2,p2J  .A2HTJ3DF 2<  >k# "  ~x@F ^@F ^ G G  0,4G p.0HS
pJ3D C[   . .JV
JF CT & # @  1  A/ a. .AKS
aJ  .VJSG0Hw0HUJFF >  >    8/ X/8KZ
XK:G C 3  S. .HuHRAJPJVFF S> >'  /    # 4/ 0  T/ p.8K P.Z
XKSaJ:GJuJRAJvF p>UF P>  G /   7/ KY
 K G  C@K @.s@K   .R@JP JTFF @>   >G[tG  G{CZk G GG ] ]   #kGP#` EV&  ~ ^_D" ^ ' ~15 B 4G  ` G@ ~Gx >G H@ [3|J8 ?Dx > @` vB@ ~H GP ^_' Z#0 ;H %v JX 8 "h ۦP > ^ ^  [ h  C( { ~ 8 p ޶xZk =s H  B C( b4G2?H } SF xZk  = }C( r H!>HG( 1HDP B & 2F5@ 4J  =C( C$ CCGGGX bGGGyZk8 D D     }#fHfH@  #,A #H  #< 0JJ  G ] ] }    #kG#G ^G ~G  GG    ~4G ^G    [( {ByZk 8 D     GG ] G ] }  0 #kG#4G ^[ ^  ~( G  ~G G{VZkG  BGbGGtGCZk `b#_ .  C #,HqHPJA#HF1D > #<G ] G ]  }( 0 #kG#4G ^  ~( G  ~G G ^    [{   0, 0.0HQ
0J 1D  C  ]Zk G  4G = GBGb4GxoZk G ] ]  }( 0 #kG# 4G ^ ~  ( G  ~ ^GG    0G0{#   A."@ a.AJS
aJSF @_  Gb#_G G pBGxb4GJoZkG ] G ] }  ( 0 #k 0, G 0.0HQ
0J1D C    a. 0 @ .aJT
JtF C @  . 0 @ .JW
JF C?kG# p" ^ #  ~ ^ ~  ( G .G .G 0/G P/J  0,U
J 0.8K .Z
XK .F@{0HQ
0JJW
J:G0B {#1DF C8b C C C CGGs~Zk #, .#HP
J0D C* `  C. ## c. " .G .CJ C/S
cJ c/J .U
J /YK[
yK@SFFJX
K[G0BF8b @ C C C CGGJ~Zk  #,0@ .#HP
J0D CG ] G ] }  ( 0 #kGU B0 F DGG  GGtG_ N ]  }GPB
B  GvZkCGkG#G  >" C G  8 D
  0/ # p/ " C8K[
xK;G G G   G   .C 0/GJY
0KF C4G GGB	CG F 0B	B F 0B	B 4G? "UBB  `B   0`CB   C F  Ҳ"   0 @9U @? G  #k#0 4G ^  [ @ ^G G  ~G( {}Zk0 G  BTG( b @G}Zk  B K@( bGGTG                                                                                                                                                                                                                                                   !                        Y. $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         "            }Zk  B I@( bGGTG}Zk  B G@( bGGTG}Zk  B M@( bGGTG}Zk0 G  BTG( b @G}Zk  B S@( bGGTG}Zk0   BG( bTG 
@G}Zk0   BG( bTG 
@G}Zk  B U@( bGGTG}Zk0 G  BTG( b @Gz}Zk0 G  BTG( b @Gr}Zk  B O@( bGGTGk}Zk  B Q@( bGGTGd}Zk0 G  BTG( bG]}ZkG ] ]   #k    #C  ^C0 [C( ^ B0 ~G8 tG@ H G  ~G8 {G G >G GGGzZk 8 D@ B    ]GH btGAZk BE?$SK!  @. H   .s HR@JQ JTF @>3F   >  / . "vHXKyvHWJG ?F > } . ;, dCHPJqHA;HF >1D ;< }G . " .HwH  VJUJF >F > = 9, ,HpHA9H@H1D D 9< < ]  d . . "tKVJwtKUJF >F > SK&BE"  . ,`Jq`JP JEHFD  > < ]D . . "JWJxJVJF >F > @   =   3. .%HQ%Jy%HPJ4F 3>F > ݢ    Ĳ v/0B V. C vKR
VJ d rG  C  GG  ]( ]0 }8 @ H P #kG#4G ^  [  ~ ( {GU[ZkG ]   #kk       GkG ;F  !0@  !. !J $Dk#  C ^( [@ ^G  G  ~G0 { C GGUZk   }8 4G [   @Zk2 DG ] ]  0 #k# ^  ~( 0 8 ޴@ H G  ~ >G ^Gd 0.Gg P.d "G0JR
PJG2FG h #,k .#HP
J0D \ #,_ .\   HP
 J 0D ` #,c .#HP
J0D l #,l  o . HP
 J 0D  . #,G  @HP Jq@HA HF1D > #<GD .CH .vCHUJTJFF > >G C/ # #/XH{XHZXKY8K@G;G C? #?GD .CH #,qCHPJA#HF1D > #< " .TH .wTHCHVJUJFF > >{CHD C/e@ #/, #"ZCKY#KAG;G C? #?K/ ,tK, C.G$ ##@HRQJ DTF/ <, C>YHD' c/`YH$ C// #,, "[yKZYKqG' c?@G$ C?D# .VJ  C.CHTJuCHRCJA
6HFUF# >F  C>+ .#HD( .WJ`#HF+ >VJf@F( >7 C.4 C#4 c/JtJRZJ[zKUFtG7 C>4 c?4 #D7 #,xK3 .0 #.HA
8HVJ DHwHQ#JF3 >7F0 #>; .uHD8 C.TJD c#F; >RCJHUF8 C>G /yHD #, @&1@XKA;H G9DG ?D #<HDK #.vHH .L C"Q#JPJ7FFK #>H >HDO .zHL .T #UJTJFFO >L >\ #"DS ,d "P #,GDHA#HS <P #<E @DW c/%HT #/[xKW c?Y8KT #?D[ .l #X ,PJ[ >FHX <D_ .\ .WJVJ_ >\ >CHDc C.qCH` ,RCJc C>@H` <Dg C/rCHd .ZTKg C?UJd >Dk ,CHh #,| "DHA#Hk <h #<t  Do c/Gl #/[xKo c?Y8Kl #?Ds .p ,PJFHFDs >p <CH{ ,pCHDx .@H DWJ{ <CHFx >rCHD #, "| C/A5H #<ZUK| C?Dw #/t /Y$KXKw #?t ?   , c/FH[cKD <pG c? ,< #"D .@H@ D <VJF >D . #,UJ >A7H #< ]GD #/EC /Y$K #?XK ?  Š? ,< c/H@HbH[qK DbG? << c?b@  e   G ] ]  }( 0 8 ݤ@ H P #kGGGb#R_rGGGb#L_rGGGb#F_sGGGb#@_sGGGb#:_tG#L    ~ ^ GL 0,O P. HR
@J 2D@ @  B     C&  0D @< A.<  ? a.< !"@JS
`J  CSF C? G< p.< P"? 0.G0HrJQ
2Ju0HqF   ; .G8 p.TJSpJFuF; >8 p> ]   #kGGG{#_G ]   #kGQ ?B1!JB    8  .;  , JA
 HF C3D	  D  .G .D  "0JT
J4F CF  <  .<   ? .!JT
J 4F  CkG#  ~  ^ ^  ~( G` 1,Gc Q.1HR
QJ2D C  !. a.!JS
aJ3F C    0 @TG@JC p D X D  d B.g ,1!J Cd "!1@T
HPJ@H4F11 B0JRPJq0J D Cg <QFd B>5 `GQ m [G{4GPZk*   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >Gh ,k .HR
JPJ2F0 B"J@Hq"JF Dk >h < `Q ;  .G ",JA
"HF CD "D .G .JW
JF C [ @Zk #.H .rHQ#JPJ3F #>F >P .a@S .JV
JF C " / 5/KY
7KG C    B/ b/GBK[
bK[G CH B.K b.BJS
bJSF C [ @Zk }   4GG ] ]  }( 0 #k# ^  ~( 0 G  ~G T " ^G ^T 3.W S.0JR
PJ2F C  , 0,HA
0HD C    0 @TG JC p D X D  X .[ #.2AJ C!2@R
#JJQ#J D 1 @HPJ`H2F[ #> C FX >Q 5  [G{4GEPZk+   @.IO?$   .B!  HR@Js HQ JTF @>3F   > D .Q?$ .RE!  "5HWJx5HVJF >F >G\ c/_ ,\ C#zKQ
H@HF0 BJ[zKpJ D_ <pG\ c? Q O G c.G .cJT
JtF CD # D .G . d JV
JF C [ @Zk . $,HqHPJA#HF1D > $<DHD .vDH .@UJTJFF > >  D/GD $/KZDK{KY$K@G D?;G $? =G, a,T R,W .T R"/ ., ! RHV
JaHF0BP
JTJJBRHuJpDFUD > C  R<    4GG ] ]  }( 0 @ #k#   ^"  ~( 0 8 ޴@ H P >X ^` ~h p G  ~G ^G  GG  'GO  . .JV
JF CUB    G (/ # H/X 8KZ
XK:G  G .P  (.JQ
(JF  0 A.T #3 a. GAJS
aJSF C " . .l H"JZ
JWJ:G0 C6KUJy6KF >F >l h.o .T (.rJU
JW .TJ5D0 @2HSrJa2HFo >aFl h> .8J &/P
J @JY
&K0F CF8 F Cp  X H/[ (.KrKHKQ
(JQG C
8B  [ (,X ,A(H@H3D D[ (<X <H
 E[ .wHX .UJTJFF[ >X >4G &. " F/pH`pHQ0JZPK!F@G &> F? V" /H v.eHL H#XKSrJGeF ? v>| h"  0 .3 '/JY
'KF C   ', g, HQ
`HC`HF0 B JA Hp JqD g<0D '<| .G .S L ,JU
JO ,VJG0 CKTJxKHE
HF >F| >D@ (/C , C(K [@
H G CTG @ZkGD Gà . (.  GJQ
(JF  ` .c .JU
JF C  . /JX
KF C     g 0 @TG Kd ;" p D X D  d {.g .C:AKqJR
JTJF51BJSqJuJ C!:@FuFg >	 Cd {>1 GBGb4GNZkn   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  G	Gh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh <C    gG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk ).	H 	.r	H, "Q)JP	J3FF )> 	>!A, ./ .JV
JF C     碤 (! 7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk , (,	HA
)H D
   (. H.(JR
HJ2F]P RQ PX N  gl /o 3/l "p .s .KJV
JY
7KFG C C
B+  S/4G s/SK[
sK[GG Cb#_   G  'TG ). I.)JR
IJ2F CL a"L .O .GJU
JF C [ @Zk  '4GGb# ), 	.)HP
	J0D Cw_G  ' (. (  H.4G . .!JGR
AJb#JU
J2FF C C
B!   . .JW
JF C[_  G	G@b#G4G_  TG  .  . JQ
 J F  CL @"L `.O .GGrJT
JtF C [ @Zk  'BbP 	,< I"S ),x 	.	H{ ).A
)H< i.? .	JD CQ
)J  . /FrJJX
KU
J CFuFD C C A>oZkF
G 0 .3 .JV
JF CC  5,# .5HR
JPJ2F0 B5JA5Hq5JF# >1D  5< h/G ,hKT
H@HF0BJ[hKwJ DwG < h?b#  'X_ӕ   'GG@ 	.4GC ).	JQ
)JF CG+_	 C%  G  b#h_ X H-[ ,GGHI@
HG @E  C	@  G b#@
GD GoGGGGGpb#x@ 
GD GcG  G b# ', .@ '.'HC G.P
J'J0D  C " .R
GJ .2FJV
J CF CGG_ X (-[ H-GG(IJ
HIG*E C	@  =b#@_!G
D G4 =GGGGb#O@_!G
D G(@ 	.GC ).GG	JQ
)JF CG_	 C  Gb#`_ C  ' ` }!0 	.3 ).	JQ
)JF C C  a.# .aJV
JTJF0BJSaJuJFuF# >  a> (/ H/(K@
HKZHK`G0`ChKY(K{hK@G;G H? (?b#  '_    'GG@ ),GC 	.4G)HP
	J0D C_ C% G  b#_ X H-[ ,GGHI@
HG @E  C	@  G b#@
GD G GGGGGpb# @ 
GD G G  G b#  ', .@ '.'HP
JC G.'J0D C  " . .R
GJJV
J2FF C CGGA_ X h-G[ ,GGhIG
Hb#gE C	@  =^@	GD G  =GGGGb#@ 	GD G    b# ', .@ '.'HP
JC G.'J0D C a" .R
GJ .G2FJU
J CF CGGG_ X -[ H-GGIJ
HIGE C	@ Gb#%@ 
GD GR GGGGGb#m@ 
GD GF   t " b#0 g-3 ',gIA
'H aE C " !. A.0JT
PJRPJ                                                                                                                                                                                                                                                   "                        ʦ $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         ? "            tF0`BpJQ0JspJTF3F A> !>Gt .Gw /GGJZ
KXK:G0 C6KWJy6KGFw ?t >
 X h,[ H-hHJ
HIjD C	@ `3@GD G
 GGGGGpb# @ GD G N G ] ]  }( 0 8 ݤ@ H P =X ]` }h p  #k# ^ ~  ( 0 ޴8 @ H >P ^X G  ~G ^G( Q.G+ q.G ,G 0,QJS
qJHA
0HSF C( q"DSF C @d 1,d  g . HP
 J 0D	  !B   g C.d c.d "RTJg C>StJd c>X &,D c"[ .tG0&HP
JBb0D C	BP @D .G #,JA
3H  hF C5@G  H .K C.JR
CJF CB?   3, S.@ .3HR
SJC .J2D C A" a.V
J .FrJT
JGtF CbmZkB C  Bb2@GGfxZk  0 (,3 .(HP
J 0D  C0 @.3 `.@JU
`JS`JF0BJR@JtJuFTF3 `>0 @> / &/K[
&KY&K[G0@CFKXKzFK;GG &? ?D # @ C. HC c.tGD -G . .CJ .IP
J  BS
cJ( bJV
JESFF C C!@H aBGxZkX , @[ ,HqHH@
H\ f" D  C
@  [ .\ "X &,HyHPJA&HF1D[ >X &<D\ ._ .JU
JF C	dB `_ /\ .XKWJG_ ?F\ >\ ,\ c#_ , "0" "H@
H  ! D% p .s !.JT
!JQ!JTF0@BAJPJrAJ4FFs !>p >c@ . / f.JZ
K ,uJ:G0 CD
HXK6KWJy6KdFGF ? C >   _ -\ #,4G\ c#HHIrHA;HE2D_ =\ #<0tG  h0 .3 .JW
JF C( 3/+ S/3KQ
SKZSKF0 BJY3KpJQG0G+ S?( 3?G .G f/JU
fK[fK D 0 @HTJ`HuGF f? >pb#  h"_   (G !. A.!JR
AJ2F CH .K .JU
JF C [ @Zk( #,+ .#HP
J0D C   T C/ 0 @W c/TGT ##d . Jg .Q
yKYKCF01 Bd "7aJ[yKJJV
JZYKpJ C!7@qGFW c?PGT C?G	p D
 C
 Ga@   g .d .d "WJg >VJd > / &" &/ C  KY
1KGc  !aJ!   . .G j/JV
J .jK F  CT
JL ,L  O ,tG CHG
H!BD / !/ C "KY
7K [G CTG @Zk G ,   ,GG4GHb#E
HD C D  گ_8 &-G; ,TGG&IG
Hb#'E C;_Gb#G4G_  AAT ,T  W ,HG
HD C $! d, ,iH@
	H`D C     (X X a.[ .aJV
JTJF0BJSaJuJFuF[ >X a>X /D c#[ &/  KY
&KG C	CR @D .G #.JQ
;JF CBJ  H C.K c.CJS
cJSF CCB @ . ,@ #/J@
HC C/#K F  CZ
CK `/  "  .:GB CqKP
JpGb CGkZkB   Cb2@GGtGvZk  0  .3  . JQ
 J F  C0 `.3 .`JV
JTJF0BJS`JuJF3 >uF0 `> &/ F/&KA
FKZFKaG0`CfKY&K{fKAG F?;G &?@ .D "C .2HD #.tGG ,J ',U
J .0J@
H  B'H( bW
J  FF7D C C @FJ BGYvZkX ,[ &, @\ "HA
&H D  C
@  \ &._ F.H[ .uHX f.0JR
PJTJ2FSfJ CFuF[ >	BX f>  D_ &/\ "\ /HzHY7KXK;GG_ &?\ ?\ # \ , "_ #.HQ
!J D2    H #c@p r.s .rJV
JTJF0BJSrJuJFs >uFp r> &/ F/ ,8KA
XK .HaG0`CW
JZXKxKY8K{xKDAG;G F? C &?   _ .\ c.4G\ C"HTJuHSrJFuF_ >\ c>TG!    Ƞ .C *,8K F/ f/JFK[
fKA
*H[G CFL ,O F. CL f HR
CJ!8@D . !. C   JQ
 J [F CG @Zk  (AAT i,T  W ,dHF
HfD C   , #,HA
'HD C     X h.[ .hJV
JTJF0BJShJuJF[ >uFX h> GG ] ] }  ( 0 ݤ8 @ H =P ]X ` #kG#( ^0 ~8 @ H ޴P X ` >h ^p G  ~G  ^GD Q.GG q.D 1" ,GQJ 0,S
qJ[ .H;SFX T.A
0HU
JTJ  	 CDUF DG C C  hF   P. .PJU
JUF C   0, . HV
J 6D  C Dp  @ .C .!H .tG ,JU
JBJb@
HF F C  C&HGGUuZkX ,[ , @\ & H@
HH D  C
@  \ .tH_ &.\ "[ f.HX F.JQ
!JSfJFRFJ CuFTF[ f>	$@X F>
  D_ /yH\ .XKWJGF_ ?\ > "  ) !p ,s 	,HQ
	H@	HF0 B	JGHp	J Ds 	<Dp < .c@ &, F.J f.V
4HHJD0@S
hJA4HHUJdHSF6D &<F > C   _ C/4G\ #/\ #JZXKgJY8KIG_ C?'G\ #?Fû	A `hB @H .K .JU
JF CA  @ .C #.2@BtGJbQ
#JD #!F CGtZk@ #.!HC C.tGD -G , .#J .	I@
	HBR
CJbJU
J  E2FF C @ C  B&HGtZkX ,[ &,  (HBA
&Hbx ).< i"{ I. D< .  C? .)J@ .R
IJC .J2FU
JJW
J CF	FD C	 C @^iZkGGGG}_  C	4G,    (@  /C @/ . . KX ,Z
@KJ[ .W
JH .HbFK . CP
J U. 5" u.GBDQJS
qJ CSFJV
J CGiZkB CbF   C'BG0@GtGtZk[ &, @X ,HpHA&H@H1D D[ &<X <\ F"D\ f.\ "_ .HrJT
JxHtF C	DB @_ .\ .WJVJF_ >F\ >  H " "Gp ,s :,HQ
:HA:HF0 BJ@HpJ1Ds :< Dp < F.c@ ,TJV
HDHF0BJRTJuJDUF < F> / &/KY
7KG C   _ c/\ # \ C/!Id!I[aKZAKrGDG_ c?\ C?  0 .3 .JU
JF C0 .3 /J@
KXK G0 C(KWJy(K G3 ?F0 > , &.HC
&JQ&J#D0 @&HGHa&H#F &>D <HGB	AC  @ .C .G  JBJ r/ r.V
JrKS
rJFsG Cb " / 2/ CKY
7KG ChZkB  Bb2@GGtGsZk  *0 	,3 ),	HA
)H D  C0  .3 @. JT
@JR@JtF0`B`JQ Js`JTF3 @>3F0  > . /JZ
KXK:G0 C&KWJy&KG ?F >p !  j CGTG b#Q_ D #,D #!G .| #" c.)HP
	J| C.SqJ0D C1Ht1HRQJuF c>TF| C>X .t #![ /JX
KF C7@  H c/K ,!B)HcK@
Hr)H `G  CB
  w #.t .Q)JP	J3Fw #>Ft > G  t "w #-t #, / 4/I7IKY
4KA7HG C T# t/ ,zK@
H `GHpH	1Ew #=0Dt #<@ c. CC .GD{ #/cJU
Jx /uFcJY#KtcJXK:G{ #?Gx ?  j C0 ;-3 .G4G;IP
J0E C &! . .JT
JUJtF0`BaJWJsaJF >F >x &,{ f.H /K &/U
fJ@ F/&HC ,KY
&KF0BGSfJJA&HtJFK@
H CuF{ f>4Dx &<@G [ CTG @Zk @   . &,	Iq	IP	JA)HF1D > &<( .+ .JU
JF C   T ,T c#W -C 0 @HQ
ITG	1E)1 A8JHI;I KGHi;I C!8@EW =DT < p D   C"  C e. /7J .aJ 5,KT
JA
5HtFG C CL !.L !!O A/2WB 2#)JZ
IK , -:F CHH
I [GD CTG @Zk  - &  &-GG4GIb#I
&I	E C(D  䖫_8 &-G; -TGG&IH
Ib#(E C_G@b#G4G_  ʠ@T -T  W &-II
'I	E C f  , &,HA
#HD C     JX X .[ .JW
JUJF0BJTJvJFF[ >X > D #/D #G C/;H@ #-C #, '.8K G.Z
XK#IA
#H'JR
GJ:GB!E2F C C8@fKb 8@GtGqrZk( #-+ ,#IG
H'E C   T .T "W /C 0 @JZ
KXK:G91 C6KWJy6KGFW ?T >TGX &-;aJ[ . J C&IP
J @	0E	 C!;@
$AGp DGG  \ ,_ .\ &"[ .HX .HU
JWJ DxHVJ  CF[ >FX >	@  _ .\ F#\ f/HaHPJ[zK	FaG_ >\ f?    * &#p ,s .HX
JVJF0BJGHwJFs >Dp < &-c@ F/ ,$I &,G
DKHgG0`CA
9HZDKdKI$I{dKDGG F?	;E &= C   _ /4G\ .\ "JXKaJWJG_ ?F\ >"   * , C ,3aJ i/TG 	,HG
HiK@
	HD `G  C CL .O .L ` $@JV
J $. $, "F C0JA
0H [!F CG @Zk  ʠAT &-W ,T  'ID
H$E C d  , $,HA
#HD C     JX j.[ .jJV
JTJF0BJSjJuJFuF[ >X j> GG  ]( ]0 }8 @ H ݤP X ` =h ]p  #k# 4G ^H ~aH  ( 0 ޴8 @ H >P ^X G  ~ ^G S.G 3.GGRSJQ3JTF S>!F 3>  gG	4G{#0 3.3 S.3JR
SJ2F C, ", ./ . &"JX
JVJF0BJUJwJF/ >F, > F. f.QJZ
qJSqJ:G0 C1KRQJy1KzF f>YF F>( .( $"+ .tG . /J  gU
JJX
KF CFF C  GG_C   'G !. A.!JR
AJ2F CH .K .JU
JF C [ @Zk( $,+ .$HP
J0D C     gC4AJ 0 @T .T "W .TG CJW
J KF C 3# S/ s/!4@!@YK[
yKp D[G C     T D#T "X .[ 5,JY
5HA5HyF0`BuJWJsuJ9D[ 5<FX >W ,T d/T $.GzK@
HA0H `G 1 @HsHQ0J5DW $<3FT $>   GG0b#Ʃ_Ӥ &,   . "G4G H@b#P
 J 0D{   F. f.GFJS
fJSF CF @浩_8 ,; -GGTGH`b#H
ID C_GG b#4G_ӣ , f,EHCfH < f<( ,+ ,H@
HD C    0 @TG J C p D X DK  G  GC3aJG .!3@ . CJ ,V
J #-F CL "L /O 2/HI
#IKY
7KDG C C [TG @Zk  a@` $-c ,$I@
H  E  C     . @.JR
AJF C     gd .g .d "JX
JVJF0BJUJwJFg >Fd >                                                                                                                                                                                                                                                   #                        &-_a $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                         "            ( -+ F/IZ
FKE C    0 @TG`K C p D X DX fD $.D D"G d.2JS
rJ3F C%B  H .K .JV
JF CB[ &/HX F/{HX /GPJZFKF[ >[GX F?  KY
&K@ d.C $.
G .dJ  /Q
$JD[ &,JX
 KqFH $. FK d.  CGFK .  /FK[
fK$JS
dJA
&H[Gh b3F "!GJX
K9zB` BF C C7eZkP B CX b  B0 CGGtG:pZk\ $,\  _ .
 C F# HP
 J 0D2    ' "p q.s .qJV
JTJF0BJSqJuJFuFs >p q>@ f/ &, /zKR
:H &/K D 0 @Y
7KA:HH[zK`HG2D`G &< C f?   _ .\ .4G\ "tJVJwtJUJFF_ >\ >d $#Dd $,@g D.9HR
YJ2D     g $.d d/d D#Q:Jg $>[zKd d?P .S .  ǢJU
JF C ` /c V.KR
VJG C  , 2,HA
2HD C     G 0 @TGHd z# p D X D  d .g .C1!JJW
JTJF61BJ CUJvJ!1@F Cg >Fd >7 Q GBGb4GBZk+   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  GGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh < Q eG  gG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk $. .HrHQ$JPJ3FF $> >$ "$ .@' .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk , " &,4GGHA
&H@b# D  C  F
  G _8 ,4G; &,TGGHA
&H`b#D Ca_GGGb#x@ӳ   . #,
TG  @IP Jq@IA HF1D > #< h" . H! .UJTJ > >L "  Ǣ (.E .Q*J / 6/x V/K{ v/Y
6KVKG C[
vK , 8, 8![G	HA
)H C DD  @
Hr
HP
J3F (>F >L .GO &/	4G@ .  JC F/Y
4KJFZ
FK CF [ CTGc%I @Zkj   F-%I -JEIHI
AEE F= =D &. .Q&J &>PJ >( F.+ f.FJS
fJSF C    0 @TGJ C p D X DJ    C6JG /!6@ 5/ CK #-Y
5K C-G CL U#L u/O ,!IJ
CIzKE
H*EeG C C [TG @Zk  a@` E-c ,EI@
H @E  C  !  ,  .(HP
J0D C     Gd .g .d r"JW
JUJF0BJTJvJFg >Fd >( /+ &/KY
&KG C    0 @TG@K C p D X DS ^ ã , f/EH <[fK f?( &-+ F-&IJ
FI*E C    0 @TG`H C p D X DI    C1!J h. .!1@ ChJT
J %/ E/GtF CL "L .O .!KZ
EKJW
J:GF C C [TG @Zk  '@` 	-c 	,	I@
	H  E  C     . @.JR
AJF C     gd .g .d "JX
JVJF0BJUJwJFg >Fd >( &/+ F/&KZ
FK:G C    0 @`H C p D X D GG ] ] }  ( 0 ݤ8 @ H =P ]X ` #k# 4G( ^H0 ~aH8 @ H ޴P X ` >h ^p ~x G  ~G  ^G S.G 3.G p $!RSJQ3JTF S>!F 3>  gG
4G0 3.3 S.3JR
SJ2F C, ", . F"/ . CJX
JVJF0BJUJwJF/ >F, > f. &/rJ[
2KY2K[G0@CRKSrJzRK;G &?zF f> .TG .@b#  gJU
JGFJ_ D .G $.D $  .| D"J| d.Q
!JTJF C2Hu2HSrJFuF >| d> CX /t $"[ &/KY
&KG C8@ @H ,K .!C1HHP
Jt1H D  C C
  w d.t D.SqJRQJuFw d>TFt D> G  Ǣt $ w D.t $. V/ .RAJVKP
JQ!JPG C p# , /HX
K DHsHTFw D>3Ft $>@ .	 CC $/CD{ .JY
$Kx D/FJPJxJZDKF{ >XGx D?   =0 @.3 `.@JS
`J SF  C  /  . KX
 JP JF0BJY KvJF  >6G  ?x &-TG{ &.H F/&IK f/S
&JQ&JSF0@BFJI&IrFJFK[
fK3F	2E{ &>x &=[G@ , CC .G [HP
JD C @Zk( .	G+ $.JQ
$JF C   T .T d"W .C:KJW
JUJF61BJTJvJFFW >T > 0 @  'TG C`JT 9.T y#W .!:@G;JP
Jp D0F C " . .!@JV
JF C     GT "X z/[ :,zKU
:HA:HF0BJ[zKtJ5DtG[ :<X z? T ,W .HP
J D  GGb#_ө AG   . f.4G F" &, .2JTJu2JSrJFuF >&H f>P
JD &/0D / C "Y&KXK &?F ?  b#G4G_8 ,; ,GGTGHb#E
HD C_( &-+ F-&IJ
FI*E C    0 @TG`H C p D X DI    C%HG D.!%@ d.	 CDJ 	/S
dJ )/SF CL "L .O .KY
)KJV
JGF C C [TG @Zk  G!A` ,c 
,H@
H D  C     . @.JR
AJF C     gd .g .d "JX
JVJF0BJUJwJFg >Fd >( -+ F/IZ
FKE C    0 @`H C p D X DX GD $-D d#G D.;IR
[J	2E	 C%A  H d.K .dJT
JtF C%B[ .HX /zHX .GY&KXK0G[ &?GX ?  'JW
J@ D.C d/	F !.DJ .[
dKH D/K!JD[ .V
J[FK D.6F CDK !. a.R
DJ a#G;JS
{JP
JbKY
&KRGB3FFG C C8XB
aZkB Cb  B0 CGGtGlZk\ $,\  _ .	 C  ' " HP
 J 0D1  p q. f#s .qJV
JTJF0BJSqJuJFuFs >p q>@ &, , /;HS
H &/KSF0@BY
7K@H[JA;Hr[JG D2D < C &<   _ .\ .4G\ "JWJxJVJFF_ >\ >   F.G f.4GGFJS
fJSF CD
 @b#_8 &,; .4GGTG&Hb#P
J0D C_P &,S .  '&HP
J0D C  ` q.c .qJT
JtF C  . .JW
JF C     G 0 @TG Kd z# p D X D  d Z.g z.C9!K[JQ
{JS{JF41BJ CR[JtJ!9@qF Cg z>TFd Z>7 `Q G0BG8b4G~Zk+   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  GGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh < `Q G  gG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk +. .HrHQ+JPJ3FF +> >$ "$ .aA' .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @ZkGGGb#_@ @  g "TG c#0 ,iJ3 +,HA
+HJ D  C4  "4  .7 @.0JT
PJRPJtF0`BpJQ0JspJTF3F7 @>4  >   . /JZ
KXK:G0 C6KWJy6KG ?F > #, C-A;HJ[I+D #<
IE C= (. (! .Q JP J (> >L    G h-E H-KiI . .x .J{ /V
JJF CX
K T/ 4, 4#FYKA
9H CAGD @)Hu)HJII{E h=
UE H=L .TGO &.
4G@ f. f! JC .Q
 JfJF CW
J [wF CG @Zk   &, f,KI -pKI &-A+HCkHG1D &<pD f<ID f.I
&I F.G	E CSfJ f>RFJ F>D b#4GK_8 &-; f,GGTG&Ib#C
fH#E C_( F-+ f-FIK
fIKE C    0 @TG I C p D X DI    C#aHTG $.!#@ D.
 C$J .R
DJ 
/2F CL d"L .O .JX
KJU
JFF C C [G @Zk  gAA` k,c ,kHD
HdD C   #, . HP
 J0D C     Gd .g .d r"JW
JUJF0BJTJvJFg >Fd >( /+ &/KY
&KG C    0 @ I C p D X DX _ ã , f/DH[fK < f?( &-+ f-&IK
fI+E C    0 @
TG@I C p D X DJ  G  gC1!J c. .!1@ CcJT
J %/ -GtF CL "L .O .!KH
IJW
J(GF C C [TG @Zk  @` d-c d,dIC
dHcE C ! , #,HA
(HD C     Gd .g .d r"JW
JUJF0BJTJvJFg >Fd >( &/+ F/&KZ
FK:G C    0 @@I C p D X D GG  ]( ]0 }8 @ H ݤP X ` =h ]p }x  #kG # ^ ~   ޴   G  G  ~G ^   . .x 0,JU
J{ p.0H F  CS
pJ . .3D `" CJW
JG AF F !F  B
EB  G_   f@0 B8 b< t.< "? .@ 4,C ,uJV
J4H@
HvF D C C^ZkGGGG;_ C   dP .S .JW
JF C ` ;,c .;HP
J0D C  A. a.AJS
aJSF C    0 @  ĢTGJd V# p D X D  d v/Cg 6.7J CzKS
:JQ:JSF21@BZJ[zKrZJ!7@3Fg 6>rGd v? C0 P BGX b4GK|Zk   @.WE?$   .T!  HR@Js HQ JTF @>3F   > D .WE?$ .T!  "5HWJx5HVJF >F >  DGh ,k .HR
JPJ2F0 B:J@Hq:JFk > Dh <w    dG 3, .3HU
J5D CD "D .G /JX
KF C [ @Zk (.H .rH4 "Q(JPJ3FF (> >A4 .7 .JV
JF C      7/ W/7KZ
WK:G CGH 7,K W.7HR
WJ2D C [ @Zk  b#@ (,C .(HP
Jd !0D CGX_d ,@g ',HA
(H D
     g g.d '"d G. CSqJg g>RQJd G> =@   G Cb# =G4G_   , (,HA
(H D  C  "  . @.0JR
PJ 2F @
@ 4G_G ] ] }   ݤ    #kQ                                                 T      X                     H                               %4@.,k&,"K/''!" ,@ CѧŐ"ɂ+"2",K  @!  *
$# "               1?                                  	                    P      0          
 
 p   P     p P           @   0   @  `  0
 0      `           P	  
    P
   `                                                                                                                                                                                                                                                          $                         $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        K "               0                        
                                    @       DECC$SHR                                               @       LIBRTL                                                 @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                             (        PWNC_BIOREQDEC C X5.2-003         queue_bioreq_to_bcb     %  	  	  
4$  <                 0  bioreq_init_pool   (  	R Ԑ	a `	_ 0	d   4               '        
PWNC_CACHEDEC C X5.2-003     PWNC_InitCache   P  	 [	j 	z 		 	r    D 	                 $    0    @ ` PWNC_UnloadCache  @   	 T  p              (    pwnc___set_unique_config_id     	X N

0                 *    pwnc___set_cache_config_flags   '  	 P		U              @  '  	 @ pwnc___set_override_params  	 b  	b 	 _ 4	r 
	{ 

	w 	r _	w 	r k4	   T	 	   	              8
    X  *  p
   pwnc___mark_init_cache_called  p
 /  	 ^
	n 	t   
       T       ,  p p  pwnc___mark_init_cache_callable  p !  	 <	 $                  '        
PWNC_CLOSEDEC C X5.2-003     close_cache_file    l  	 h$	 
	 
	 
%	E  	~ 0  T             &  8  close___deassign_cache_fd  8 	  	       8       '  @   close___flush_before_close  @ 	  	W       D         H  close___free_cfdsc  H   	 
    	   G              8         '        
PWNC_CRASHDEC C X5.2-003  @ 0 crash  @ 	  (       H         -        PWNC_DIRTY2FLUSHDEC C X5.2-003  P @ move_dirty2flush  P ,  	x L	   T       \         ,        PWNC_FFLUSH_THRDEC C X5.2-003    ` file_flush_thread    '  	 
x	  $  0               -        PWNC_FINAL_FLUSHDEC C X5.2-003#    insert_to_bcb_hash_tbl   2  	 9	   P       D      %    remove_from_bcb_hash_tbl   ,  	 		 		(                             
bcb_lookup                 wait_for_bcb            final_flush     	b 	  
 	    l	 =
		 P		 "  	 3	@ 	< 4          )        ,        PWNC_FINDBUFFERDEC C X5.2-003#   * P insert_to_bcb_hash_tbl   * 2  	 9	   `*       T0      %  0  remove_from_bcb_hash_tbl  0 ,  	 		 		   1       1 1                 
bcb_lookup                 wait_for_bcb         1  pwnc_find_a_buffer  1   	S 			 
	 	(	    	 	 I  	 $	 n   @	n QIx  <2       t=    
    '        
PWNC_FLUSHDEC C X5.2-003   ?  flush_cache_buffers  ? .  	y 	 		    ?       @    p    ,        PWNC_FLUSH_FILEDEC C X5.2-003   A ` 
flush_file   A   	) 	] 
\	 	h D 
	
 P	 	 1	 	 	 (  ,A       HJ    `	    ,        PWNC_FLUSH_PASSDEC C X5.2-003  `J  make_flush_pass  `J 2  	 	 	$	% 	
 ,  J       K        %        PWNC_GETDEC C X5.2-003  K ` get_cache_data  K %  	V 

	n 	j   L       lL          L @ get_global_counters  L   	   L       PQ        hQ   get_file_counters  hQ   	 X$  Q       PU      "  pU  get_global_cache_data  pU   	   U       X\         /        PWNC_GIVE_BUF_AWAYDEC C X5.2-003  p\  give_buffer_away  p\   	 	 
 $  \       H^        &        	PWNC_INITDEC C X5.2-003   `^  queue_bioreq_to_bcb  `^ %  	(  	(  
4$  ^       <a       !  `a  init_configure_cache  `a   	, I 
	:	./ 	/ &	/ c	,/ d$	/ 	/   	/ &	/ 	/ &	/ 	/ H	/ HTL\	0 	0   	0 2 $	0 0	0 	0 	0 
	0 	0 	0 !(	0 %\	0 ; 	0 2	 ^  
/(

,	1 	,	1 P	. 14  a 	   _a        	   _a        	   _a        	   _a              |    !     8 init_cache_unload   (  	1 R$


,  D             +    init___alloc_cache_ctrl_memory   ?  	2 X	.3 $                &  @ p init___alloc_cache_memory  @ 8  	3 U	3 $         p    P  *   P init___free_cache_ctrl_memory     	94 H         ̇    X   %     init___free_cache_memory     	4 N         $    X   $  @  log_cache_configuration  @    	4 	4          <        &        	PWNC_OPENDEC C X5.2-003  ` 	 open_cache_file  ` b  	 	 
$	` 	Q 	
	 / l  ȋ              #  ` 	 open___assign_cache_fd  ` 	  	g       `         h 	 open___alloc_cfdsc  h   	  (  В 	   g                  ,    ,        PWNC_PFLUSH_THRDEC C X5.2-003"   0
 periodic_flush_thread   "  	 	 
   ̓       \        +        PWNC_PLACE_BUFDEC C X5.2-003#   
 insert_to_bcb_hash_tbl   2  	 9	          ԛ      %  x 
 remove_from_bcb_hash_tbl  x ,  	 		 		           < `                 
bcb_lookup                 wait_for_bcb         x 
 place_buffer  x 3  	 
 
 (         H        &        	PWNC_READDEC C X5.2-003#  p  insert_to_bcb_hash_tbl  p 2  	 9	   С       ħ      %          remove_from_bcb_hash_tbl         h  
bcb_lookup  h   	0 D	2 	0                 ` wait_for_bcb   "  	; 	H            l          @ queue_bioreq_to_bcb   %  	  	  
8          p          
read_cache     	 $	 			 		    	s  l  l	 	 h	M d	m  l	% 	 H  8             !  P p read_existing_buffer  P e  	 
	   	   T  ̾           p     @ read_fresh_buffer   c  	!     h	!                                                                                                                                                                                                                                                     %                        + $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        3 "             4  ,           X  "    read_fresh_buffer_rah     	! *T	! .,	" 4	$" 		:" 	:" $	:" 		 ,	=" F 	="   	:" Y   
	" 	" ;    	1#  
   H                 )        PWNC_RELEASEDEC C X5.2-003#    insert_to_bcb_hash_tbl   2  	" 9	0   P       H       %          remove_from_bcb_hash_tbl           
bcb_lookup     	 D	 	       h                 wait_for_bcb         p  
 pwnc_release  p Z  	. 	G 
 
 $	  	K (             \    %        PWNC_SETDEC C X5.2-003   
 set_cache_data   $  	W 

	o 	k          @       !  X 
 zero_global_counters  X   	           X        p 
 zero_file_counters  p   	 

t	          h      "   `
 set_global_cache_data   S  	 
 X	: <	E @	L @	
 /
,	
             0    ,        PWNC_TFLUSH_THRDEC C X5.2-003#   
 threshold_flush_thread   %  	a 7t	 $         l        (        PWNC_THRTBLDEC C X5.2-003   @ pwnc_thrtbl_create   .  	 $	 	 	 
,         x      !    pwnc_thrtbl_register   >  	9 	K p	K 	K 	K 	P                 &  `  pwnc_thrtbl_get_avail_thr  `   	 <	 	 
       d      '  h  pwnc_thrtbl_make_avail_thr  h   	 \	 		        P       !  X  pwnc_thrtbl_shutdown  X V  	 !	 		] 
		%  	$ r	 0   	   W                      /        PWNC_TOSS_ALL_BUFSDEC C X5.2-003#    insert_to_bcb_hash_tbl   2  	4 9	B   p       h       %    remove_from_bcb_hash_tbl   ,  	 		 		   (                         
bcb_lookup                 wait_for_bcb          0 toss_all_buffers   0  	W 
	p 	n ,  @       p        *        
PWNC_TOSS_BUFDEC C X5.2-003   p toss_buffer   -  	 
 	 (         0        0        PWNC_TOSS_BUF_IOERRDEC C X5.2-003#  P  insert_to_bcb_hash_tbl  P 2  	 9	                %  H  remove_from_bcb_hash_tbl  H ,  	 		 		    `        0                 
bcb_lookup                 wait_for_bcb          H   toss_buffer_ioerror  H N  	 	    	   	(                 %        PWNC_TWEDEC C X5.2-003  0 P 
twe_init_pool  0 (  	' 
Ԙ	7 `	5 ,	:   \               %        PWNC_UTLDEC C X5.2-003  0  utl_bdsc_alloc  0 @  	 ;
	 	 	 	 $	,  d               8  
utl_bdsc_free  8 *  	
 < 	I 
$  h              )    utl_compute_num_hash_entries   %  	 E	 	 	 	          P    h     `  
utl_getsyi  `   	 M
                     utl_lock_ex   M  	R R$	 	 	 9	 
,  \ 	                           utl_probe_for_read     	y  
                    utl_probe_for_write     	  
                 ( p utl_que_ins  ( F  	I! 	B!  	\! 	n! 		b!  	h!       8   `          P utl_que_rem   (  	! R 	!  	          l!        !  
utl_trnlnm  ! A  	" O	~" 	o" 	p" (  "       H#        p#  
utl_unlock  p#   	" @
$  #       #         #  utl_we_alloc  #   	:# C  $       $         $ P utl_we_free  $   	# 6$  $       8%       !  X% p utl_we_and_bdsc_free  X% 0  	$ ;$	C$ 		$ N$  %       %         & @ utl_count_bdscs  &   	$ 	$       p&    h     x&   utl_dump_bdscs  x& -  	$ t	$ 	$ 	$ 	$ (  &       '        (  utl___is_prime  ( #  	% 	$ O	$%   8(       l(    `   %  x(  utl___validate_abs_queue  x( n  	6% P	% 	% 		% 	% 	% 	% 	% 	% 		% 	% 1  |( 	   w(              )        ) 0 utl_dump_ds_sizes  )   	%   )       +        )        PWNC_UTL_MEMDEC C X5.2-003"  + 0 utl_mem_tracked_alloc  + /  	& >	d 	b 
	,  +       H.      !  p.  utl_mem_tracked_free  p.   	   .       .    8     .  utl_mem_report  . 	  	       .                  utl_mem_check_links         +        PWNC_VIEW_HOOKDEC C X5.2-003  .  	__iscntrl  . 	  	 0      . .    0     .  PWNC_VIEW_HOOK  .   	O 	  /       H/         '        
PWNC_WRITEDEC C X5.2-003#  `/   insert_to_bcb_hash_tbl  `/ 2  	 9	   /       5       %  `6 P remove_from_bcb_hash_tbl  `6 ,  	V 		c 		o   x6       $7 H7         `7 p 
bcb_lookup  `7   	} D	 	}       7         7  wait_for_bcb  7 "  	 	     8       d:         :  queue_bioreq_to_bcb  : %  	S  	b  
8   :       `=         =   write_cache  =   	 #	 $	 			 	9 4   	h 	p	 	   		 d	 		 	 	\ h	w 
	 d	 %  	  	 0	 D  =       L      "  M p write_existing_buffer  M   	  

  	     
 	 	 !    @  pM       $Y    H    `Y  write_fresh_buffer  `Y   	Z!  	  ,`	"  
    '   	  <  Y       (i       (  `i   truncate_to_existing_buffer  `i   	"  	P# 	L#  	a# 	  	#   B   	# 	# 		# 	# <  i       w      %  x  truncate_to_fresh_buffer  x   	$   L	F$ 	$ 	$  	$   	$ S    	2% 	.% 
	G% 	C% D  x       0    `  &  p  toss_buffers_for_truncate  p M  	q%    		% <	% /8	%              x    .        DIGITAL_COPYRIGHTDEC C X5.2-003                                                                                                                                                                                                                                                                                                                                                                                                                                                                              &                         $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CACHE.EXE;1                                                                                                       )                        r              ,  DEFAULT_CLUSTER.   2   O   }                     6  :  R              !  .  @  D  i                $  (  L              L  Y  k  o        
    +                  7  N  `  d                  c  g          
    )  Y  f        		  	  (	  ,	  N	  	  	  	  	  	  
  
  
      %  `  m              A  E  a  4
  A
  
  
  
  
  
  '  +  ?          5  p  }            "  &  C  ]  j  |                  "  h  l              F  S  e  i    s  |                .  ;  M  Q  y            H  U  g  k              
    ,  0  Q  z          L  Y  k  o                  R  V  u            N  [  m  q          /  3  I            .  ;  |                !  3  7  T                      _  l  ~      	      (   ,   K   b!  o!  !  !  !  "  "  \"  `"  t"  "  "  "  "  O#  \#  #  #  #  #  #   $  $  "$  <$  I$  [$  _$  {$  $  $  $  $  $  =%  A%  E%  %  %  %  %  %  &&  *&  F&  }&  &  &  &  &  '  '  $'  ('  K'  w'  {'  '  '  '  '  '  '  '  (  x(  (  (  (  (  )  =)  J)  \)  `)  )  )  )  )  *  "*  <*  u*  *  *  *  *  +  +  f+  j+  +  +  +  +  +  
,  ?,  L,  P,  ,  ,  ,  -  +-  g-  k-  -  -  -  -   .  .  a.  n.  .  .  .  .  .  .  .  /  E/  R/  d/  h/  |/  /  /  /  /  /  %0  .0  E0  W0  [0  w0  0  0  0  0  0  0  0  	1  ]1  a1  e1  i1  m1  1  1  1  1  1  1  1   2  J2  W2  i2  m2  2  2  2  2  2  2  2  3  3  "3  73  ^3  k3  }3  3  3  3  3  3  3  4  :4  L4  P4  h4  4  4  4  4  4  5  5  $5  (5  J5  5  5  5  5  5  6  96  F6  6  6  6  6  6   7  7  "7  :7  G7  Y7  ]7  u7  7  7  7  8  &8  *8  <8  @8  X8  y8  8  8  8  8  #9  09  B9  F9  h9  9  9  9  9  9  9  :  :  :  -:  X:  e:  w:  {:  :  :  :  :  :  :  2<  ?<  Q<  U<  t<  =  =  +=  /=  K=   >  
>  >  #>  H>  ?  #?  5?  9?  [?  :@  G@  Y@  ]@  @  @  @                                                                                                                                                                                                                                                                                                                              	                   h         	        
      p             X  p                  0 <                                              h      @    0    0        P       @    0                     ` P   @     w  X        0 (       P     
        *   `    P    `     R
        ? p  p     P   p     
         A `	       ` 8                `J        8               K       3        p\        (               `^ ,   r          ` X         ` 4  `    	                     p    0
 `                      
 x               p |<              !                       m#          `
    V%               
 P       %        x      @         (        	          @    *               p @   P    0+       P 
          `    <-        0       P P   p    -       0 l   A         W6  p     +   0    0        7        .    @ 0    X       8  ]     `/ ^  p      0      @  3          P                                                                                                                                                               K  K               
PWVN$CACHE	V1.0-611F 5-APR-1998 22:49 5-APR-1998 22:49     Linker A11-14   
                 	.$$ABS$$.  0
 0     @   N 0       p.              UTL_MEM_TRACKED_FREE        @   N         +     0         UTL_MEM_TRACKED_ALLOC       8   N @       .              UTL_MEM_REPORT      8   N        @     `         PWNC_UNLOADCACHE    8   N                        PWNC_INITCACHE     
 	 
                                                                                  * [NW.KIT.AEXE]PWVN$CLD.CLD;1 +  ,   . !    /     4 @   !    2                   - >  0   1    2   3      K   P   W   O "    5   6 .;  7 6D  8          9          G    H  J                      module PWVN$CLD    define verb NSHOW      image PWVN$CLIENT >     parameter P1, label=QUEUE, prompt="Queue", value(required)   define verb NDELETE      image PWVN$CLIENT >     parameter P1, label=QUEUE, prompt="Queue", value(required)@     qualifier ENTRY, nonnegatable, value(type=$number, required)                                                                                                                                                                                                                           * [NW.KIT.AEXE]PWVN$CLIENT.EXE;1 +  ,   .     /     4        U                     - >  0   1    2   3      K   P   W   O     5   6 Σ!vD  7 K!D  8          9          G    H  J                         <     h                                                  (    vD              0                                                                                7x vD PWVN$CLIENT                            	V1.0-611F      A11-14                               $             
               $             
               $    ~                         $                P             $                             $             J   S             $    (                       <                          PWVN$NWAPISHR_001        8                        DECC$SHR_001         4    &                     
LIBOTS_001       @                       ]|ESYS$PUBLIC_VECTORS_001             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    0     `     0                                   0            @              `     `                                        NDEL                        $VERB   ENTRY   0'              0                        %          NSHO          QUEUE           `              @$          @'              0             @                                            0H     @     p              @              0               '              P           	              &              SYS$NODE        0     0
     0                                                         0                                            0    @     0                    &              @              P              OpenVMS User    G                            0     
     0                            P              0           0              P              `               0          @              Holding         no privilege    Adding  , closed        stopped                 idle    0    p     P                     F              busy            @              paused  Pending         Printing                              0          0              0     0     @       <             , %s    F              0         P                             P       0          @       <       %s      0                      0             
              '              
             &              no privilege    0H     `     p              	              0          `             p             '               	                            0          0              &              @               0     @     @                                                    r                             VMS queue name  0     @$     0                            &              0     8*                                                                                                                                                                                                                        '                        s $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CLIENT.EXE;1                                                                                                                               3	 "                                      (                            s     
     	     0     )                    P       0     '     0             0     %                   u     
     0     @%                   0     HP                                   0     Hd     @                     0     R                                   @              d     0(   0 ;                                  "     l          P	             `               ""     C     h>     >     =     =     08   P`                                  "             "      0   ^     0                                         $_     ^      _     ^     ^     0     8[                  0      I     p                   0(    2     p                                 6      4     4     X3     (3     0(    @[           |        ""  P               d          
     0h  pS                  4     \             ;     	     l$     T$     D$              2     (                       0     v                         $           p          0w     0w     w      w     h{      w      w      w      w     0w     h{     {      w      w      w     0w     |           |$     0    08v             t     h     0     u     p              "     0     u     p                   08     s     P               ""    dt     dt     dt     Pt     t     Pt     Pt     Pt     Pt     dt     t     t     Pt     Pt     Pt     dt     0     t            T$     
                   p          00     d     P              ""    e     e     e     e     e     e     e     e     e     e     e     e     e     e     e     e     0     |e                 $                   00     (f     p       |       "         ?     l     0      g                  *     P     0     p     ,     `     0      hm     0      8n                                                             00   0n     `              d     0      o             0     p     0     p                           \     0     |                                                               SYS$CLUSTER_NODE        
                                   %[^:]::%s job %d; %s      %5d  %-15s %-12s %6d  %s
       -----  -------         --------     ------  ------
   
  Entry  Jobname         Username     Blocks  Status
  NetWare printer queue %s, %s%s, on server %s
           idle    paused  pausing remote  server  stalled stopped closed  busy    Holding Refused Requeue Pending Stalled aligning        operator request        resetting       resuming        starting        stopping        unavailable     available       disabled        autostart inactive      stop pending    Aborting        Printing        Restarting      Retained        Starting        Holding after   Suspended       Incomplete      Completing        %5d  %-15.*s %-12.*s %6d        -----  -------         --------     ------  ------
   
  Entry  Jobname         Username     Blocks  Status
  , on %.*s::, mounted form %.*s
         Printer queue %.*s       L                   ' ,          Q          .          1                           M          L          F          G          K                                                                                NetWare user name       NetWare queue name      NetWare server name     PWVN$CONF_DIR:PWVN$NWPRINT.CFG                 *          ,            0     ă                                                                                                                                                                                                                                                                                                                                                                     p        x      @                       (         8  @  H            X    h    x                           @                               @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        #4G( ^0   ~G  ^#0 [G C8 {C  C > ޶uZk =b# b @  BG( b4G1UZkG  ]( ]0 @ #kG# C  ^tGG( ^0 ~8 G  ~G Gb#G CGd@  GC b#GGtG@   =??& ?&G1"b#4G0D  GG"G@ ?$	  G  ]( ]0 }8 @ #kG#4G ^G ^ ~  G  ~Gb#G@
  GGb#4G?$@	c GD GG ] ] }  0 #kG #[G ^ ^$ ~    tG G8 [G  ~# "BZk:C@  ]H@G & 1D@8 H }# }C  C& }C  ]@ GH G =C Gpb#G< GD L  @ә   =BF@ G!v HbtG D  nZk  
 à =1H@BG tG!v Hb4G D  nZk}  G?& =Cpb#CGC =GGtG@q   =p BC =G!v Hx btG CnZk 8D v HCP 0.Q 0JP 0>  GCpb#C&C G }GGGtG@ 8 D   $P  L ì }4GBbGNZkGGCb#GCTG@  GCPb#??&GtG:1"4GG@2 BCCbG  GGGGGG[@Zk =@  ?&P BCDX b F    GCGGG_@Zk  8D  CCG`b#_  p } C CG b#_  4G  $2  G ] ] }   #k        #P [GH ^X [ R"P ^4GX ~`   ~G#G "AZkP  C0 BC  b8 b G } =gZkG  0 BP@8 bG4GgZk  Gp B!f@x bGTGSZk  D!f@@ BGH b4GZk u @  @ B!f@H bG4GZk `@   .P J >` BCGh b8 C  GGGGG@Zk0 = _"2DJD9  8 0v J1Jp@12B  .$JT J  >6 B'  q@ G  .1 B0 B JF 5/" 5K$G  u/" uKdG `," H D  "    u.11 B uJdF `"?  . "W J >@  ?'?$	   GCGH ]P ]X }` p #k#0 @;??& ^?& GGG  ~#   j1"a4G{#2"  4GG@G ]   #kG#G ^G ~TG  ( G@{ ^Gx[c   ~#GAZk e@0 BG 8 b  \HZk5  0"	 ?&G 1" c  ?&b#4GR"F  ??&GB1"G@V G  	 ?& 1"G?& cFb#	  ??&GB1"4GJ"G@D GG??&  !?& cGb#B1"  >4G2"4GG@4 G#4G  BG  D4G!v H # c( b C*GZk"  0" ?&G 1" c  ?&b#4Gb"F  ??&GZ1"G@ GG??&  !?& cGb#Z1"  >4G2"4GGv@ ?$TG  D	  G ] ] }  ( 0 #kG#4G ^ ~  G  {G  ~ ^  0 [8 D   X D;	  8 {!!v H CIZk@ BGH brLZkG ]  ?$ ]	   }  0 #k#4G ^G ~  G{ ^G0 [#c   ~# v H8 {c@ CBZk  p"??&G?&, cG  !Z1"b#4G2"  >4GG@2   #c@0 BtG0 #G!v H8 b ChBZk  p" &G "0 c  !??&?&b#j1"0D  G4Gr"G@ G@b#_ G  #a@  Bj@ #G!v H( b C}Zk  @b#_ ?$	  G ] ] }  0 #kG#^~ ޴ (GG  ~G^#  G GH  0v JCZ  G%C  G.GH BG1v JP bGJ C %H~Zk  ! ?$ !  DB  b#_H 8 BP"@ b CCTG{{ZkL  ( BPC0 bGK@TG}Zk/  8"!h B Cp bC(BCCCGeZk  DG	  ??&xb# CtG 1"4GG@  , ! =,??& e(1"HGA
(Hxb#TGD CF  GG|@   0  D    %0@                                                                                                                                                                                                                                                     (                        n $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CLIENT.EXE;1                                                                                                                                "            !v H@??$	  _G]]} ݤ (0#kb#P_G C( BG0 b@  TG|Zk  ( BC0 bG@TG|Zk  G??&?&( exb#Gz1"4G"GA@tG  G.x B(v I % bGJ CB~Zk  ¤G??&?&( e  ƠGxb#z1"4G  ޴2"4GG&@ӷGG4G??&  d0 }tGxb#1"4GG@Ӫð#G^G~ (0޴8@G{ C^GH [c   ~#C # v H  CGGP {G C4G}Zk  Hb#_  =" C!v H    =X b" C F    5A@G@4vJFGB9F@ 8B@G, ]C0 #G( B0 bFGDZk GP   v HC    #"  F. CBG!v H #bFJ CL}Zk	  x"! & "  !Hb#0D  _Ӳ øBp="Cb CGTG|zZk  BPCb""G CTG|Zk  "> B CbC(BCCCGdZk  DG	  ??& b# CtG 1"4GG@ 
,
 
=,??& c(1"HGA
'H b#TGD CF  GG|@  k   C  F.G BG v H # bFJ C|Zk	  x! ?$ !   Hb#DW  U_^   ?"b4G( B B0J0 bG6J  vB	 GCZk( B@0 bG4GCZkG:}. "=.0J :]"L@  rJBT
Jb K@G D F  $tF1G@  D CD@BN@VFCG Gb@TG{Zk  BCbGh@TG{Zk
  BCbG1I@TG{ZkX  DX CG( BC  GP =B0 bGYCZk 0@  'vH@;?$	  _G]]} (0ݤ8@P#kGHb#_G# ^  ~( G  ~G  ^{#G_G   b#_G  pb#_G  hb#_G`b#s_G ] G ]  }( 0 #kG#  ^( ~0 G  ~G  >{# ^ ^!_G   b#_G	  b#x_G   b# =_Gpb#K_G ] G  ]( }0 @ #k            #   ^ ~  ( 0 G  ~G ^GGG  TG0 B8 b  `D   E@ %GBZk0@@  G ] ] }  ( 0 @ #kG# ^ ~  ( 0 G  ~G ^GG    TGBb  `D   D@ %GBZk0@Ӂ@  G ] ] }  ( 0 @ #kG#H ^P ^X ~` G[G@ ]G[ "  ~#8 =GR"}Zk@ ݢ C  B    / #/bKY
#KG C4G{Zk =q H  BCC( b0?HG F   .G .4G  GJU
JGF }GG|Zk }G ?$B! D?$
 F  	   G??&8 }G1"4GG
 G@ =4G??&tG  a1"8 }4GG b#@GH ]P ]X }` p #k@#  [G^~(R"tGG^GX [G  ~#@"$}Zk  B "X BG C R"}Zkp = =CCPC ]C=` "h] "C\  tCx}C =@ }"}( ]#]C]C=C(ݲ4G4G  #. C.@ B#JR
CJH b2F C#{Zk@=q H0 B8 bG0?HG F@  .G .4G  GJU
JFD}GGO|Zk0 B@} 8 b C   CGGGGGGB|Zk }C  tGBDbB   =!v H CAZkx `b#_Ӏ C }C  "GB v H#v`Hb2@ C CGAZk0 B } 8 b C   CGGGGGG|Zk =DN  G   B4GbGBAZk  4GBb @GAZk ` BCh bG D  N@TG'zZk@ B CH bG4GzZk  8 CG  ]C8 =  B1v J 3v@JbG C Ch =G  GG{AZk b#_ӐB J@bG4GrAZk0 BC8 b CG  GGGGG{Zk =D $ &Bc "DD `  BJ@bG4GUAZk?$	  G]]}#kG0 #>  @ h  ~0 ^  CG >(!v H > 75 @7J CC  G " @ "@0 @ CP1@ @ @ "`0 @ Cp1@  [CG( {GGGG]zZk(G] ?$ DP#k    # ^  ~( 0 8 ޴@ H P >X G    ~GG ^ ^GP B CX b ?"GtGEZkd  0 B CzZk @ " ,@" 1HX!D  `.S rJ`> CW 0 B C4GzZkC%  G	G  . J8F F 8F   CG  	/ )#@ B0 AH bPK4GJlZk  	.q	H0 BP 	J )!F	> CyZk A   i.S iJ  i>0 BGyZk 1 @  @  . JF 8F  1 @"  4/ #Y 8K 4?0 BGyZkC =   4GG ] ]  }( 0 8 ݤ@ H P =X ` #kG G = C  #4G ^[ ^  ~( GG  ~G > CyZk0 B0 @8 bhnZk  C      B =GyZkG ] ]  }( 0 #k#0 jC ^@ [ 	@  ^G( ~G0 TG8 G  ~GH {#CZk C `0 "G??&Pb#tG)@G1"4GG_CGGG`b#5_ BGb4G-nZk  C  C =G$ b#A$@ _   $CG  A$@G !G`b# .  .HvHUJTJFF >  >_}   =Cb#_   $CG  A$@G !G`b# . . a"HUJvHTJF >F >_z   =Cb#r_ C  $GG  A$@G !`b# .H .vHUJTJF >F >_z   =Cb#X_ C  $GG  A$@4G !`b# . a" .HvHUJTJFF > >_y   =Cb#=_   $CG  Q$@0 @ 1`b#  $ . .HvHUJTJFF > >G_nu GG??&Pb#4G1"TGa_s G??&Pb#4G1"TGY_k Gp b  ??&?&Pb# C  G1"Gs"TGGI_[ G??&Pb#4G1"TGA_S 0 ??&G?& }G0  Pb# C  ~1"Gs"TGG0_B GG??&Pb#4G1"TG'_9 0 b??&G?& G c Pb# C  1"Gs"TGG_( GG??&Pb#4G1"TG
_ 0 ??&G?& }GPb# C1"  ~Gs"TGG_ G??&Pb#4G1"TG_ ` BGh b4GajZk?$	  G ]  ]( }0 8 @ #kG# ^  ~( G  ~G > ^G{#_#   "G??&b#1"! TG  4G_ G  G "_  WG0 B0B  . .JU
JF C%wZk     "	B?$:  G ] ]  }( 0 #kG  B?$  WG 	  yZk0# G  ~G ^G ^ GG "@ByZktG  ="GPBFBb#  G$ ] ]" t@tG`Bhb "0 =" ]"vZkG ] ]  #kG#G >  @ hGG  ~ ^G ^G ~  GG8 =pB "QyZk   } G$ ]"" D(  4
@ b#G, =G tGA@tGB "b@ =" ]"fvZkTGG Gb#G@ 4G8 }c  `  =?@  G  ]" b# ="tG$@ }  ] =#v`H"v@H b@ `    .qHPJF  > G ] @  r.tRHSrJtF  r>G ] G ] }   #k .
HP
JF > r.
RHS
rJtF r>#G >  @ hGG  ~ ^G ^G ~ GGGB "xZk4G " D   t
@$ =  ` G ]_B	  G@b#L ]"H ="GtG@H   C"4G  @G" 4G 4GB GC4G7G	 B0 "GGxZkG0  0 =( " 4G B  4 C" @4G   /B] `8 ]c  `4G   / ݢB  G < ="@b#@ ]"tG@ӰB "bP =" ]"tGuZkG ] ] } 0#k   #G >  @ hGGGG  ~ ^GA G "mxZk4G  D   
@$      }B @ ݲA "a0 =" ]"tGuZkG ]  #k0# G  ~G ^G ^ GG "  BExZktG  ="G0 ` BFBb#  G$ ] ]" 6@tG@ BH b "0 =" ]"[uZkG ] ]  #k    P HH%  % ` D	   . J6xC  1 @0 @   D @  <aK|G6KF6KF  BC F(  @!@ @     J8C   1 @0 @k D   . J   1 @0 @   D @    C  @!@ @     J   1 @0 @k 6J 6J 6J 6J 6J 6J  0 @ @k @k  @0 @k  @P @k  @p @k  @ @k p @ @k P @ @k  G `G  |6aK@`K |	@G }CG#  ~ |  \R@K C  \ ^C `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܤC6`K `  C6`K `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܥC6`K `  C6`K `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܦC6`K `  C6`K `  C6`K `  <C6`K `  \C  ^6`K `  \C ^V`K `  \C ^v`K;dK} `dK `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܌C6`K `  C6`K `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܍C6`K `  C6`K `  C6`K `  <C6`K `  \C6`K `  |C6`K                                                                                                                                                                                                                                                   )                        * $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CLIENT.EXE;1                                                                                                                                "     )        `  C6`K `  C6`K `  ܎C6`K `  C6`K `  C6`K `  <C6`K `  \C6`K `  |C6`K `  C6`K `  C6`K `  ܏C6`K  c  ^ ~    ާk ~CGGP HH"   D	   . J6xC  1 @0 @   D @  <aK|G6KF6KF  6B
  @!@ @     J8C   1 @0 @kBCF 6J 6J 6J 6J 6J 6J  0 @ @k @k  @0 @k  @P @k  @p @k  @ @k p @ @k P @ @k            #   ~( ^0 ^8 ~@ H P ޴X ` h   cGGG¤G =G G  b#p@xD
 	      ?$!  v HGD      #h!$ '  G B 2B2Fb  c }xG0Bx0 D95 C C \"C8   khL g@BG =tGGb#sZk GH g
@ GP 'G@  G   G<5 @	  2U @
  @4G8`Fx`FF tG8`Fx`FF G8`Fx`FF TG8`Fx`FF H L Ǣ5@B $HH @5JF <CCFJ BB    G   G<5 @	  9U @
   4G8@Gx@G_G tG8@Gx@G_G G8@Gx@G_G TG8@Gx@G_Gy H g@ ]#"%  G }#1`@#1`@#1`@bB } C#1`@ ##h D# bB C } a  G  bB } C !Z  %D  bB  C }  S   D  ?O ` #1`@B  C {H `eG `D G ]4GG0J  ZJ< @  ] ݢ @cB F  HDHB|KG  d @c  8KK   = !%D      G  <5 @3U @  `4G tG G TG8 Gx G?G#  } ]G0J @cABJ F  JTJB|KG  7 @c
   $@ 4 	  (  (( g A  G @0FG  ?GgDl `GG, 
@4  0EC0w J @c 4GBFF1Hw J  0  1D1D  04 D  @c  4G! f@GG  /G ֢0e@0w J  vG  BF
dBBE3eBK ``F 4G, #F @c1Hw J  0  1D1D  0   @c @ EC0w JG
@B(  F 4G @cF1Hw J  0  1D1D  04 D   @c    ڢ4G VCgD e@ 0w JGB
@F\  4G @cF1Hw J  0  1D1D  0   @c @  ڢ VCgD0 bGGb#K@Ge D@  , 'G @?& 1"
yB   v x4 #   ֢ ղ   F  @D  $D G BG  z  @ $ : X4    @& " UD D   : QC@G:  @ Ǣ0e@0w JG6B ǲ( gBF @c 4GF @1Hw J  0  1D1D  0o  @   4B 4 g A ` @_& R"DD  Hײ( g Ae@ 0w J @cGBF 4GF1Hw J  0  1D1D  0P      @& "D A $ $D1%B $4 g `   (  A@ @c0w JGBF 4GF1Hw J  0  1D1D  00   @c @  c  }  f e@f4 GP@F @0 g$ 3eJ'@gJ  / A  h4@ 'B  uB 4GG  c( ]0 ]8 }@ H P ݤX ` h p #k!;ËêG#x G   ~( ^0 ^8 ~@ H P ޴X ` h >p   cGGx G
   @  R
 @ 2 $å 9v K%G  G T4 E  Ѡ# @H   c ( e @$   ?$&@ !   F @F @ @$y    @FD aD@  `< FGygD  @   C2C!C @  @ .  P8  @*  % D  %GH "  c = ABAF4 G D  0 %G#H  AB9"C9 C	  G @B  24 C 9B    @?|d	G0`B @|d E GB E0 E 5B @ \@p   k$	 )@$G$@X Bh # 'C$P etGG` b)qZkH %$8 
@   )B$!'@  d3aBd  B @  /GG   <5 @   4GGTGH %L E9@:CI@(II  A9(KG <CCgG<K %C*CGG   <5 @   4GGTGH @ =!@"$    CF*  "@ 41BC E"   "@ 41BC F   "@ ]41BC RGF @41B 4#"@?V     D   41B"@B K G4G G @c0JGJ F  rqK[qKB|KG  rr` @c  } 8KK!   sgF ` G   <5 @   4G G TG" ݶG ]0J @cJAC F  IHIB|KG  L :_" ] }G0J @caBJ F  51KY1KB|KG  5;  @c@ @c0w JTGBF 4GF1Hw J  0  1D1D  04 D+  @c  L ŢH :J @JC ] # ]G0J   RJE+ @ }  @cB F  !1KY1KB|KG  !
  @c   4JJ     ] ZD @!   }G0J @caCJ F  uqJSqJB|KG  u` @cH %0B = @F"C =   G71B@   ]  G  /    <5 @  8U @   4G   /tG G TG8`G?x`GG  / G   <5 @   4G G TGG 4 % '@  !'D"  ]G0J @c0BABJ F  IHIB|KG    @c@H e0w JTGBFFG 4GL ŲF @c1Hw J  0  1D1D  0  @c @y4 "   % @0 G  /G GG  / 㢷WC  CRC
    $ x@eD	 )@$_G @B  	BV0e@ @c0w JGBF 4GF1Hw J  0  1D1D  04 D\  @c  D d@  /GG   <5 @   4GG5TG34   c@GG   <5 @   4GG%TG#G  / FF 0 増J     @&@tD  & CA #1@    a  tD   C8 f@ Ȱ  8 ð #1@    a GGX `  A@F @ 2@tD  F CҰ a   u4 % GI  0 I    B f@GG B
    T
 @G B @  Ԣ GFh `   uC1C&G   'C 4C     r   @  4  E  0 H   G	   / @4C @  Ԣ    ۰ 4G     @    4 F 0 %#H  40 ECK T, 
@  ,  âc@  cF    G<5 @  ;U @  `4G tG G TG   & @&" 7G4 Ţ @ c@\\d@   <5 @  G8U @   4Gb tG` GGGTGGG0e@ @c0w JGBF 4GF1Hw J  0  1D1D  0r   @c @ BT 0e@ @c0w JGBF 4GF1Hw J  0  1D1D  0]   @cd @ iBd> 0e@ @c0w JGBF 4GF1Hw J  0  1D1D  0H   @c䢠 @ B( 0e@ @c0w JGBF 4GF1Hw J  0  1D1D  03   @c @ B 0e@ @c0w JGBF 4GF1Hw J  0  1D1D  0   @ @c 4GG  c( ]0 ]8 }@ H P ݤX ` h =p  #këüRhÝÈÝòÐ#G  ~   ^( ^0 ~8 @ H ޴P X ` >h GGG4 $G!J  m@ @c0w JGBF 4GF1Hw J  0  1D1D  04 Dj  @c     4 $$D @aB
pB  8DD" B `F!D7H =2    0J HJH
@   ?1C =G @c0J@J  F   1HA1HB|KG   =  @c d ]3fJGfJ0J `@ ] @cJ F  c qJSqJB|KG  c(` @c4 D@HF @ G⤠ GG   	G<5 @  1U @   4G   /tG G TG\ `4 DHF @4G   /"   	G<5 @  3U @  `4G   /tG G TGG  @ dBG = ="Gb "TG`#|mZk   G G = ? 4G )4 $(F   IG  /2HB+ @hBG&( " F( ԲGGG   <5 @   4GGTG )(A9(C  " :!   /GG   <5 @   4GG TG ( ɢJ0 EBGGGxoZk ?'GB I(   D "G G(  ="@ dTG`#Gb+mZk  GG   <5 @   4GG G| GTG Gx G4 $ ]"D@  ? `  d @0`FG GF6 ( B0w JG1  BFXF 4GF   @c1Hw J  0  1D1D  04 Dd   @c G  G    U BF G  A  u f@ հGG   <5 @   4GG G8 GTG G4 GG I FB 	( Y&A&A?"4@G( Y I ɰ4 	8 i0 )4 D  ɢ6B ɲ4 vH  
 GGG   <5 @   4GG TG GG   <5 @   4G G TG? GG  ]( ]0 }8 @ H ݤP X ` =h p #kúÕ#   _"  ~ ^G ^G G0 0P &G0 [ "?F0 B0 0  ?&1"G F B &  _&R" _$ F B G G 4 TF4 4 G G4 4  "GF4  &0 8G4G0 8( ;P "  P  # '@ !D A {#0 4?DP @0 44Gl  G  F BG G " 0D 2@ " @?  ز 84 ԢGF4 Բ4 AG4@D4 A4 ԢGGF4 ԲG  0 4J0 H زGL XG$ 8G( X@ , 8                                                                                                                                                                                                                                                     *                        v V $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CLIENT.EXE;1                                                                                                                               ; "     :       @ 8GD X0 F0B0   G C G Ԣ ?& F B ԲG bG "4 G4 4 PDF4 P4 ԢF4 Բ@ "D B  G ] ]   #kG#  ~ ^  G F"     TG@   0 [0 4 G8 {GslZkG ] 	   #kG #G>  @ h  ~h^Gp^Gx~8q @4G޴GG	8@h =G  	C8 F    F="  h ]"@BRB   B
B    
B       h }"PBSB0B  
B  Y" @( Àp #HB0 "G  G&nZkG9Q CG  W ?@ C     @   @0 C	@ ` 1
@ 0 0 @
9@_T } ]"tG `G  =" b#@G   =  }!v H3J0@0Fa HaF  } G  5J  D ݢH =81B;1 C F ;G 	B` D =0 ]G( }<5@B5U@B+ <u@B  4 G8 G
BFp ( ]  0v J"  ' G4 P =D =
BB8 F0Fb   P =4 GTB(   0v J   4 B
B8@G5JGQ@B(   G0v J   ( =B FG 0B( =X }G8"( "Pb#. `` =` ]"tG_:   G0 } G0 a`KGF!G0 vG4 ] G( = uS J3vJuF D L ]81 C  	 @4 7!G4 7L } Ps`K1_J3F p8  PF;  4 TF4 A G( ?" }TGB# B7!J =G b " ="jZkG ( =  BGGmZk ݢ  ò (  =87K   C5 C 8@5B8CG_&( 0R"@ 2F( PGG   <5 @   4GGTGF @0 ע ?'GF0 74 rT`F4 rF `4   D4 
 F  0 W &GVG0 W4 Y@F4 Y
 4 G4 F4 H =H  @( $ ', ǲF @4 7"G4 7F 4 w  `G4 wX G@"@ ' ( %@ '4 ZHF4 Z\ }GH" GGD ' `, D 4 ;0D4 ;0 <5 C5U C< <u C 7   '4 ݢ BFH ǲ3 GG  /w@KD =#B@G  0/SBD = 3K  0@Cw@KCC@G B[B  .J 0@CCC_#CC0 TGG6_J1q B1Cp1 JF0 Բ  'P 4 = @DH '  !1 @0B 7LL  G4 H  4 rSHHB @1v J  "2F4 T  }  ,y`JE HD  <  } =;v`KGGlZk< G@ 77J    Ǣ ǲ. 87K GGG(b#_ & "G
  'D@Xb#!?H 0@ Gv@ ! 8 } "hD `4 '0D4 @ @c0w JGBF 4GF1Hw J  0  1D1D  0   @c @ e &Ô" 4G3J tB    Gh]p]x}ݤ#kG k( `#Gh>  @ h4G  ~G(^0^8~@HP޴XGGG G4q @( 	@	CG  8F  Fh#   /( ]"AxBRrB  !`B
`B  2  
tB   ! 2 ( =#WxBYyB0`B  
`B  ?D"G @4G G?B   G " 4G   /B  G(b# =" ]"tG@GZ   = }!v H3J0@0Fa HaF }G 4vJBF BG  GG "  ]"  tGb#K_H B$q@G;    c4 "GG0 L #F B0  = ruS J4v`JF H G[8CA ?CB  [
$C    C    0 C9"?G rSH4 ef@B "4v`JF4    ,aJ@ H D  <  ݢ$vHGGkZk  ?'9# 4G8K C %G(]0]8}@HPݤX#k#   ~ ^ ^  ~(   cG  pGh  # $  !v H D  p G4 6J  j G0 #?D05 @ B \B@   k_ T ci@xB4G#GbhZkV GP T  G #P "U?BG GL P "  BWBG8 BGkZk    8C  `@0 D  /G  ?GF/   4 #0B F C  0 CCJ  /B  U`B;B@C  S `0aC  Z C  Y   6 7B 4 cdF ` V:AC VB, B4 v8 V    $   v BF?B 4G00Z#8B    cG ] ]  }( 0 #kGp#    ~8 ^@ ^H ~P X ` ޴h p x >   cG  G "  = 0 $  1v J F  ` 4 06!H  ` G 0Z<? 4G4G1?J !B 0 }0 # ?D D%C	  X ci@B@ #GbYhZkGG  # a@0 DG  G4 #	g@0 CV J(F0DCJ   G")!D4 `  5B @
 GB  B9B C    5!C  @C    " f@BTG0 #;`C7aK }D cGb"hZkG   ݰ  & @  / =G   <5 @   4GGTG Gn 4 FY      ݠ8 & 9A0 GG @_GiG  @ C }  {(  sCHG iF   }( 3  "H `B   GGG   <5 @   4G G TGiG  & @0 G  /G @_GD @ GD f ="  ( "BTG( =Gb @0 #gZk$ D f! Ơ ="B( "GbRHTG @7I( 0 #gZk   G c =""( "0 ]"R`H( }tG0 =hb#_   G0h0!%e@  G  c8 ]@ ]H }P X ` ݤh p x =  #k#  ~ ^ ^  ~( 0 GGG   b#_<5`@ U`@ <u`@
     P $  = G G    G ] ]  }( 0 @ #k>C  ~0 ^8 ^@ 
GH G   =  C( ]A @  =( ]  q/y1H[qKyG	    q?  RG0 8 ^@ H Ck Q/
1HZ
QKYG Q? /t @ @ KC   <wK B    kG  k   , H   4GkG  ' 4G 8Dk  ", 4G"H @T@@k  /\ K 4G<Dk . 4GWJT@@7Dk>C  ~0 ^8 ^@ ~H P X ޴` 
Gh G  =   = }(   B   DAK @ G@ ?'?9#0 @   !C  GGGG   G8 D G_ G0@-    CA@  ݢ%7H C @    CA@ @0@ 0 @   C7AK Cm#G@ = 4G Ģ   B Ĳ d0`C dGG0 8 ^@ ~H P X ޤ` h CkG8 
A@ C  CAr@ G Cm#@A @  =  >C ^ C  /  F_ @0@   G CkG &/&KHH9&K6J&KJ06C @ 1 @0 @0@a  >CG ^ C  ~ H>C  $@H H  ~ C{# D4`@_ H  ~ ~ ^C!5 @  / K  0 @ 1 @  /"&@"w@H CA@CD6BvKCD @@@  / .KWJGK9CGG   0 C6K?	?C!C "CG05@9  w@H@D4G<K C G|K @c  6 <G<G  6   @c C@ H G @c  JWJ BuJF    @c"X@ & 7AH C  C  @k  . HG6J J HG>C D vH  ~{# D_  ~GCq0@  D "CCD  8CvJCD @  / .KUJGG8B7K5BJ C<5C0B  0@@
C@?jD@CD8CvJCD @65C  / .KYJGG8B9K$K C06CC  0@@
C@SGG  /w@H@D4G6J &C GvJ @c   G G    @c0`@	e@0@@"C@  />C Cw K  >  #1`@  ޢ `C @ 6@P"1@@w@H@D4G7J CGwJ @c  خ F F  ؾg  @cGG>C   ~{#*_  ~C C  /#d@0d@D@4  D@CD98Cv KCD @75C  . .J\JGF9C<JK C0CGD@CD6BvKCD @  / .KWJGG6B<K6CK C  0B6KB BG Cw K# C F@GD BCD 6BvKCD @  / .KUJGG6B<K5BK C95C0C C@"E@o .XJ8GGHpÒGGGG>C  ^ 
GG C  #? a@0d@	   C4G0BBBBFGG0@4G@FqG ` GA @ _'?Z#0@@ @ Z@ @GGGG   G8 D G_  C   CkGG>C  ^ 
G>C  M C( m  GtGG C>CGeZkC    CH  C   Ck@ M CH mGGG>CtGdZkG0m#C0 
j_>C  ~0 ^8 ^@ ~H P 
GX G   8    1_# H :G2FJFJ @ A @ 4G  Ģ  6B Ĳ d0`C d  /G0 8 ^@ ~H P X CkGH
  
>C ^ C  /  C_ b@0d@9   <@ #4G09@9@FG "7@ C7K  / #4G09@9@FGw@H@D4G96K BFy7K @c  G G    @c #b@0@@ <@ G @c  JWJ0B|JF    @c 1 @ CkG>C  ~{#_  ~C;bCGG>C(    ;`CGG>C(       ^ ~    ޴0 ^D   <KD _D8 G?G  >C _   ^ 8 [ ^ 0 F ^>C _   ^8 [ ^0 F ^8 F ^X %5 CLD@>C _   ^   0 F ^6 C  _   D _  D $%5@. @  _   D _  D D%5@& @  _   D _  D d%5@ @  _   D _  D %5@ @  _   D _  D %5@ 8 FGH@bD@  _   D _  D  C Da@%5@Gt C"W`H>C#5`@  ~ #u`@      ` E  D@@#5`@0 F  D@8 F  DGG_ >C"@H@@ ^H P  + _   D (   Ĵ"uC D0 8 $@ H $P DX d` h p Ķx 䶀  $ D d DDD ?#  [( { @k>C  ~8 ^@ H 
G G  =  C( ]A @  =( ]  q/yH[qKyG    q?  2G8 @ H Ck Q/
HZ
QKYG                                                                                                                                                                                                                                                   +                        :$ $      PWRKV50F1050.G                  > [NW.KIT.AEXE]PWVN$CLIENT.EXE;1                                                                                                                               c      K        Q?GG>C  ^ 
G /t @   KC @  -<wK <C  9  kGG4G 
hm#_G  ,H    CkG  ' D   Ck  ,   H
  T @Ck / VK  C Dk !/   CZ!KT @ Dk            #G  ~ G ^{# ^ ~  ( 0 ޴8 @ H P X ޵` h G6 @G ] ] }  ( 0 ݤ8 @ H P X ݥ` h p #k# G  ~{# ^ ^ ~  ( 0 ޴8 @ H P X ޵` h G  1G9 @G ] ] }  ( 0 ݤ8 @ H P X ݥ` h p #kG# C 
G ޵  ( ^   >  pIWA   > A!vI GWA  >/vI A G  m#Z_GGG   m# @( ^  ޥ  0 # k#G  G( G0 ޵4G8 @ ^  pH@ \@H   kG KG !vHD vHGGGGfZkG0 DeZk  &vH%vH@ 4G  C >4(   C >/G G 
 1vH1B @3A @&  s" tF1BG:vHGB[G  C   vH@  5A @_&  R" F BG[GC   /3vH G
 1vH1B  !A @_&  !R" 2D1ABGtB8`G `&vHG     H  @ ð@$1  @ D QBhB  ! GG   G<5 @  ;U @  `4G tG G TG8F  _xFF
  4B   0 2@  P   A   /G D >" ް " ^   $ ^" ް " >GG ^"d#tG#_G   pH!I0D   GĥX   DGGGdZk  Ţ   >RJG K aJd#7J9v>KD F  >  GG @  ޤ ޥ "HoIOD   0 %@ @&  Es" SF4aBB   Ħ E   xB7B   8HC 3C 8  /GG   <5 @   4GG TG%  #  _ GG >"ĤG0d# ^"tG ް+_
G    N ø K G D/vHGGGZdZk  švH!I6D  Ų = G 7vH %GDGGGeZkG0 DcZk 4G &vH@  ) G(  % G-vH'vHGA   DG "0dZk *   -vHNIE  =4G G G DG " dZk   ( Ħ    .`HWJF  > ޲ 4GE E GGhd#_@ ^ G  ( 0 ޥ8 P # k -
HN
IE = .
HW
JF >       !k                                                                                                                                                                                                                                                                                                      e           (                             {     >   >  >Z   >  (>  0>  8>:  @>  H>  P>  X><  `>|  h>  p>  x>  >B  >r  >  >  >  >  >R  >  .        NORMALNormal successful completion D       	NWDELETED0entry !SL aborting or deleted from NetWare queue0       DELETEDentry !SL aborting or deleted <       
INVALIDVMS&invalid VMS job description format !AZ F       MISMATCH3mismatched job owner; expected ID !8XL, got ID !8XL.       NWERRNONetWare error code is 0x!8XLL       
NOTNWQUEUE6VMS queue !AZ is not assigned to a NetWare print queue >       	ATTSERVER*error attaching to NetWare file server !AZ6        	UNKSERVER"server is unknown or not reachableB        NOTRANS0error opening transport; NPSD may not be running@       	LOGSERVER+error logging in to NetWare file server !AZ &        	UNKUSRNAMunknown user name 4       ERRQUEUE error querying NetWare queue !AZ .        	UNKQUENAMunknown NetWare queue name>       	DELQUEERR)error deleting job from NetWare queue !AZ 0        NOTYOURSjob was not submitted by you ,        
NOTDELETEDerror deleting job !SL          	NOSUCHJOBno such job         NOMEMno more memory8       	OPENERROR$error opening configuration file !AZ>        NOQUEUES+no queues defined in the configuration fileD        EARLYEOF0premature end of file reading configuration file $        LASTREADlast read !AZ !AZ >PWVN                                                             T               X                                                             	    P
    
    H                            h  H    8        x  
  
       P                             @  P                                      0  `  0  p    p     @             p            	             P        0  	  P  p                             
                                     @       
PWVN$NWAPISHR                                          @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                     * [NW.KIT.AEXE]PWVN$DOSLOGIN.EXE;1 +  , ^}%  .     /     4                             - >  0   1    2   3      K   P   W   O     5   6 BkD  7 'D  8          9          G    H  J                            h                                                  (   !kD              0       @                                                                :!kD 
PWVN$DOSLOGIN                          	V1.0-611F      A11-14                               $             
               $             
               $                             $                             $             J                $    (                       <                          PWVN$NWAPISHR_001        8                        DECC$SHR_001         4                        
LIBRTL_001       @                       ]|ESYS$PUBLIC_VECTORS_001             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    0      H     @                              F              
          %s              1                            `              
                                       0                               0     @                            0                              P      d:l:s:u:p:                            SUPERVISOR      `               p                                           0             @                                            0     0     @       <       0            P      @                    F              getopt          0     
     @                                    0     `                             `              0           @                           0                                                        Closed transport.
      Close of Transport unsuccessful. Failed with %x.
       Login failed with %x.
  
 NWAttachToServer failed with %x.
     Detaching from server %s.
      Detach from file server failed with %x.
        Logging out of server %s.
      Logout failed with %x.
         Pausing for %d seconds...
      Client connection ID = %d.
     Get client connection ID failed with %x.
       Server connection ID %d has server name of %s.
         Get server name failed with %x.
        Server connection ID = %d.
     Get server connection ID failed with %x.
       Welcome to server %s.
  Login Successful.
      Attach to server Successful.
   
Starting loop %d of %d
        -s SERVER [-u USERNAME] [-p PASSWORD] [-d DELAY] [-l LOOPS]
    PWVN$SERVER_NAME        [-s SERVER] [-u USERNAME] [-p PASSWORD] [-d DELAY] [-l LOOPS]
  Usage: doslogin        8  8  8  8  8  8  8     8  8  8  0  8  8    8  $              %s: unknown option '%c'
        %s: option '%c' not followed by argument
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ,                        X $      PWRKV50F1050.G                 ^}% >  [NW.KIT.AEXE]PWVN$DOSLOGIN.EXE;1                                                                                                                                          @(#)getopt.c		2.1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            #4G( ^0   ~G  ^#0 [G C8 {C  C > ޶uZk =Xb#  @  BG( b4G1UZkG  ]( ]0 @ #kG#tG  ^( ^0 ~8 @ H ޴P X ` >h ^p GGGfC  ~G b#GGG@D?DGGtGG	4GJ  c _!*GI0H	PA   D D2  % Gu _" b2GJ	PB @  J0B\B\C  k( 4GBb  OZkG ( "4GBb  OZk	G ( "   (   Р ( "  GF@ b#GGtGU@D?D? G  4G(B0bGH" CGZk(Bc 0b C4GGZk G   B4Gb
G  ChZkG  (BG0bHJ! C4GGZk(Bc 0b C4GGZk G  K@*G@D
EG4G_  "GGb#!  C @h B
Cp bGGTGIZk    Bb#pJ! C @ ]GB4GbG*v@IG CWZk    Bb#XJ! C @  BGb#@J! C @Ә B
C bGGTGNZk    "b#B!   * C @ ]  b#*v@I   C C @ ]xBGbTG*v@I CCZk    "b#B!   * C @ ]  Gb#*v@I   C C @ ] C BG bTG*v@I COZk    "b#B`!   * Cy @ ]  b#*v@I C
G@   Cp @ J! CGb#k @Gb#G4G@ ]4Gx B b*v@I C'IZk    "b#B !   * CW @  BGb#
\AGQ @ ]H B4GP b*v@I CKZk    "Bb#6@  *GB @  B0`@Gb#
RAG	i@: @0@T_   "h !     C  G  b#bP    # C) @ H B4GP b%vH CJZk GBGbMZk    ¤b#@  &G @  GGb# @G  ] 4G( ]0 }8 @ H ݤP X ` =h ]p  #k#G  ^G jC( ^0 ~8 G  ~G`b#G > ^ ~ @0 B8 b CGTGFZk0 B G = ] } 8 bFZk  b4Gp Bx b  fZk  c4G` Bh b  c c0`HZkG  ]( ]0 }8 @ #k            #G ^ ~  ( 0 G  {G  ~ ^  
 BJ    c( TqB  0`B  	0CG 0 C@   .T1C JF; : @5q B  / K@    #
B, `	5C     @C0 b%    {G!    0 @ D  4 0 @	UC  ;G    0 @ "	PC  G   0 @
    0@C0 ⦤	PC "    G  0 @   4GD    %
B G ] ] }  ( 0 @ #kG / d#"0`B KG      C  . r#Y`B9B@J  9HV    / "WKJD 0@B "  R/@UKHI G r/ R"0`B	pB rK5q BXGF@ @  c
B. GQqB @	uB   Q C0 % @  TF! @  1"	C F  q 1" `tG ` Q 1"	C @TG  1" @G  0 C0 ⦵	C   F  1" G 10`B0 b  ; C `  Y. YJEF @    c 8 BG8 L@@ BG  GDh   Z  @X b	 @P B  . "GSJ  gJ;AZk G  %4G  #0 @@0 B  .  % Jn  E  #k    #& ^P "  [C  ^C( ~G0 G0 {G G  ~G( {G G ~L}Zk G v H `@   .P  J   > G ]  ]( }0 @ #k#g$  ^C0 [i  ( ^C0 G G  ~G _"8 {G TG ^gZk@ B CC  BH bGGGGG~Zk  ` BGh b4GuZk   GP BGX b}Zk G  ]( ]0 @ #k# 4G ^G( [TG  ~   G0 {G~ZkG ]   #k                                                                                                                                                                                                                                                                                                                                                                                T               X                0                                P            p                                                            @     0          P              `  p                       
                                     @       
PWVN$NWAPISHR                                          @       DECC$SHR                                               @       LIBRTL                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     %        DOSLOGINDEC C X5.2-003  X TRANSFER$BREAK$GO          	__iscntrl           X main      	 	 	 	 	 0  	 0	 	#<                  H P  log_message  H   	,                        __main  (        l          #        GETOPTDEC C X5.2-003  0 @ getopt  0   	 	 	 	 	 	 	 	 	 	 	 	 	 +  	 	 	 	  ` 	   /                      )        VMS_SPECIFICDEC C X5.2-003  
  GetCurrentTime  
   	 	   4       p            	RealSleep   *  	3 	? 	C          H         `  
RealSleep_ast  `   	J              H     .        DIGITAL_COPYRIGHTDEC C X5.2-003                                                                                                                                                                                                                                                                                                                                                                                                                             $     P      #     0   @ K   @ p         0           P       E     
          P   >  3         P                                                                                                                                                                                                                                                                                                                                                                                  * [NW.KIT.AEXE]PWVN$NETWARE.EXE;1 +  , a}%  . 
   /     4     
  
                    - >  0   1    2   3      K   P   W   O 
   5   6 uvuD  7 D  8          9          G    H  J                             h                                                  (   .uD              0       @                                     +             
  8        .uD PWVN$NETWARE                           	V1.0-611F      A11-14                               $    Z        
               $    >         
  1            $    
           P            $                             $             J   #            $    (                       8                          PWVN$CACHE_001       <                        PWRK$XTILIBSHR_001       8                         PWRK$CSSHR_001       <                         PWRK$CMTLIBSHR_001       @                        PWRK$LICENSE_LIBSHR_001      <    N                   PWRK$STREAMSSHR_001      8                        DECC$SHR_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     -                        IE $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        Au "                  4                        
LIBRTL_001       4    &                     
LIBOTS_001       8    @                    SECURESHRP_001       @                       ]|ESYS$PUBLIC_VECTORS_001             Copyright  Digital Equipment Corporation, 1993, 1997.  All rights reserved.    0             0H     l            <       ȶ     0(                                  0                                            0P     Pj     p              `	               #     o     &              V5.5    0     h                             h	          A          >     H     G     8     E          =     x     X3          (C     (     h;          =          V     x     hU                        6     8     L     8     J          R          P     H     x     X     Џ	     P     	          	     е     	           %s/%s                p      h	          	     8     P	          P7          H	     P     0	     X     (	           0+     INACTIVE                '              0    PI           |       F                            ACTIVE  &      	          ؚ	     p     	     0     8          	     x     	          p;             p              P4             P	          p	          	          P	          P          PS     h     L     X     M           T     8     4                    T           V          4          B     X     8          2     8     PG     X     I          ?          D                d               X	          +     @     C     0     x     `     @          "	          0-     ~                  @|          ȝ     A     00     0          
     |                  p     y     0     H>     0              ;     0     0     8X          	     @     8           )          0;      :      ;             Z	          PW	     `                          0     0                0M     p%
     -     P          0     i     0              `          CreateMBX       h          0     i     0              DownMsgThread                                             0     h                     0(    0H     P             &              &              SYS                           
0     G             0     F                     0     E     0              h%     SAPDaemon       0     E     0              SpawnTLThread()         P-     0     HD     0              0}     @}     hZ	     ؤ           SetupMemory()   0     D                     0     C                            -     p~     0     C     0                         0     Ht     0              D	     `     0               (     TRUE    0    H     @             b     P      O	          0          @              M	     p     0     v     0              P?          0     (u     0              *     0     r     0              PWVN$FSLR_LOGIN         0     Xr     0                             0     s     0              @              0     v     0               (     0      8             7          3          7          @/          8          D          HE          G     h     HB     h     0;          =          `	          	          	     `     	          h	           	           X	           	          	          H	          	          B     `     0\	     H     StartupAES           O     StartupTrustee  	                         Px          04          P	              l
     8     S     x     S     H     xT          K     h     HL     H     M          
           StartupBindery            U          p*          `	          
          @W	     P     CLOSE   VolRoot                 	     `     	     p     0          Д     h          x      :     @8                   '             
          DIR_PRO*TECTION         '     7          '             	          أ	          X	           `	     H     	     Ȱ     `	     ȯ     Ъ	     (     X	          x	     @     	           	          Ь	          	          	          P&             	     в     1     p          @               0           &             	          y     p     
           hI	     Т     P
     @     L	          p     0                             F	          NWDMain()       {             @
                    z     P     &     0z     
     P                               &              
               h	          	           x	     P     @	           	          З	          	     `     x	          @	          	     h     	          	          p&     :     /             8	     `     8	     0     0&     2     REC*ORD_TYPE    SEC*URITY       eng     `3     @:             Б     `                H	     ж     	     0     8          H*          
     `          *               P          5     x     4          V          h
     /           {     
          O     X     I          P     (     0U          `R          i
     9     i                    X          pwvn$svr                      ȱ	     0     0I
     )     `     d     x          H           I          	          	           P	     `     	          	     @     	          ȟ	     p     	     P     	           	          	          H>     X     <          p?          G     H     A          H	     p     P     
     px           3          h2     H     B     8     0           @              Initializer     ~     x     %Q                          (                       0           @                                          `              0           P       |       :     z     d     P3     <                                         PWRK$NW_XPORT   0      w     0      ؓ     00           P              H      LNM$DCL_LOGICAL         '               
              0           0              p,                         	                0                                  !     @     0     p                     6     ȁ     0     8                     `%          0      0     0          0              -     p~     x     X     NOT-LOGGED-IN   @     H	     <             8X          x     H
     %02X    
       &              F              0H               <       ȶ     0(     0               8
     '     @                                    H     NOT-KNOWN       Pu          0H           `              p&                         xO     h     X          0X                                     p	     P     	     p               p                    x     8P     8          X     0     І     0              0     Љ                X                         0                 |       U          ;                            p"     3                       0                      *             F                        `&                      *                  V          0     ~     @       <       P&          0     X~                     	          0H     @|            <            
     0     Px     0              p_	          Џ	     P     ؇     @                     @      )             x4     }     GetServerID()    #     o     0           0         @             &                                                                                                                                                                                                                                                                 .                        b $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "            A     б     P	                        C     0                  8X           C     `     0         @             XB          0      Ж     0          0              P                                        w                          8X          0                        X          p&              0     p                     F              0`                         &              &              0                                         0H                        Ȇ          `X	     أ          @     `Y	     `     P          0`     P                   0     h     @       <                     p)              F                   p     0     x     0              SAPTimer        "                                          SpawnSAPTimer()         0          0              0     0                  NET_ADDRESS             ȶ     0(                0          &                        V          G          0     Ȧ     P              0     (     P              0                          %s
     SapThread()             XW	     0     0           	     0     1     h     	                    eng             	                     X	     г     0;     00         p                     p_	          P4             Џ	     P     ȯ	          Z	     Ȥ     NWSap()         z             0          x     H
     H     `     ؇     @     (	     x     00          @               	              %s %s                         1              P               G              С           a       0               <                           P                o                              &     F              0          0              w       %s built on %s
         04/05/98        0          @      <                       &              SYS$OUTPUT:                                 0    ȶ     p             F              0          0              0      0     0           P       <       p              W          P           c     H                G          p     `     p           0                            |          0     `&                   Т     p     @     @           0     x     P              .SYSTEM]             `                  &              C           0           |     0          @       |       P}                   0              '              Ȼ          &              &              0(          P              	              0         P             `                             rb                            p&              0           0     (     @       <                     wb              0            0           @              p                      0           @              NCPEngineThread         P1     0&                  8
                                  
               0p                                    x     H
     @     0       #     o     ؇     @     P3                  /               F              |          00          p       |       @             ȶ     0(           p/                   p_	           p     (          P.                     0                                    h          d     P     %02X            0                               z     :     0          `                     F                  `     0          @       |       w                                            0           @                                          `              0           0              F              0          0              
ADDRESS = %x   0           %08X    .       %c      

      ȶ     0(          0     8     `                     F               q     
       %02X        %02X
                    K     p8     +     (     `     P     @L     "     0     0              	     p     eng                         &               ~             8           r          08     8                   <              B     x          	           x     P4     z     H1          *             *           H8          X     8           p/     P     <               0           00         `      <       p&              `	     ب          @     p          8      c     0(         P             h     @c     0@         p      <       @      a     0         P      <            pc     0           0    "     `              a	          p     pH     p          0     "     0                        0    p      `             0         `             00         p             pI             ȶ     0(     Xl	          D	     `     @             d	                C     0                  |       p&              H	           	     P     ^     P     xg	     Ч     '               v
     7      
           i	     `     
     5     v
     7      	     `                x      k     
     3               0    
                        p          pk     0     `|                    p     @	          {
     07          k                     j           k     0p                      &              (      m          L     0    `            <       
     4      h	          x     H
          {     hl     PX     P     k     0          `      |       &              &              /       08    @     `                          l     Xq	          0
     `4     0     P      }
     7     x     l     0`                      MAIL            0'              0j	               @l     &                         o
      8     %X              G              0         P      |            x     :       0H               <               n     B          0     
     4                h     H     0      P$     0P     f            <       8     0     p&              `	     ب     p          (t     0G     0     e     @       |       p          	          0     d     @                         0     (c     P       |                 &                   p     0     b     0              O
      +     0     a     0              `N
     P+     0      _                       "          @     0     Z     @            &              OBJ_SUPERVISORS                 u     
     /MAIL/%x        s
      8          {     F              0     V     @            o
      8     t          0p     S                  N          0     S     0                        0X     `Q            <       0Y          0X     O            |       a     0     0     PM                  0x     J            |       8X          p	          0     G                 	          ;             V               8
     @     H	     x     H
     0x     E                  U          0     (A                  hM                     '              &              0     ?                   (J     0     0p     =            |       H     `     0p     :                  G          0P     p9            <            X     0     h6                             0P     X4                             0P     1            |       0      0            |       8     P     0    ,           <       -     p~     Џ	     P     P                         0     X+     P       |                          0p     8)            |       0     (                     0     &                   0P    %           |       0       h     0          @                           ȶ     0(     &                                       0     ȝ                     &              &              0s           i	     `                                                                                                                                                                                                                                                        /                        P{Q $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        x "     %                 0
     `4     &              0x    (                  h	               i               Xq	           
          ب     0             /       0     n     @       |       (      m     '                   l          l     0                      
     4     `&              q	               k     0j	          p&              0P    @                 (C          x     H
     d	          B     H     
     3               B          ;          0H                      ?     H     2     X     0           @              a     0          @     0     H     0               q     0:     :     0(          `       <               H<           {     p}                    H     H-           0     p     0                   8
     `*          h	     `     !     @     0(          P              t          x      c     8      c     0     X     @               :                             0           0              @:     ;     0Y          `!             0     l     3             w     `     	          x     X     @     p     LOGIN   /     U          0    (t                 *             V                          G          V     h               ;                  p"               Q               p`          8     )     0H     h                                     pp     Y     !      g     00    p                 
     4                           0     8n     0                    (j     0(    j                 )     .       
     3               0                     p          @     H	     	          NOT-LOGGED-IN   '              p&              0X     (                  &              &              x     X     ('     p     x     H
          x                       0H         p                     -     p~          8
     F              Џ	     P               `*          p     0X                                     Ј     `	     ب     @     @     0          0P                        0          P       |       t          0          @       <       ȶ     0(          E     p     pE                           `	          "     0     6     (     08     P     p       |       LOGIN                 X
          8          l     0     l      s           0           0          @              p&              X^	     8     p          &              0     X     P       |                 0           `       |       @     P     ث          0     X                     00          p       |       	     P     0           P                        x     H
     0(     0     P              8          0     0                  `          0      @     0(          P               @     (     p&              ;          p                    08          p       <       &              u          0                               {     &               
          '               h	          
     3     x     H
     0               |       &               i	     `      a	          d	          0     `|     P     k     /       0    `           |                         
     4     0H                     @     C     0H                          @D     00     X     `               y     }     00     `     p              v          08     0     p       <       j          
     x     0          3          00          p              T     P     (
          h          2     (     0      8     `       |       0               |       00    x                       C     0(         `      <       (     0B     0`                     j     H     0H                     0     @     P       <                  C     p     C     }     H<                    0H    ؾ                 0           @              x|     }     0           0          0              @=                x      <     0     P     0              ;     pJ          0                         04     0     8     0              !     x:     8     0          0              (             9     X     0          0              `+             9     x     0     @     0              9             9          0           0          0              E          p
          p          00         `             &              d	           i	     `      a	           h	          /               (
          '              &              0          0              
          00         `             
     `     0          @              p&              p
                8
     08    `      p      <       x
     P     0           0          0              PC          o
          p          0     P     0              q
     P     0     @                   t
          `	     ب     0     0                   @n
          0          @              p&              xw
               8
     0     8
                   ,c
           0           0          0              H               `     p          0           P                        p&              0          0              0
          0           P                   `     0     p     @                   8
          @     0(          `       <       8
     X     0           0     !     @              p&              (
     `     p          0           @              
          Й
     @     0      X     @                   8
     
          0(     0     P              
     @     0                        p
          `	     ب     0      "     0    )     `                          x     H
               p          `	     ب     ('     p     -     p~     0P     (     p              8X          0     X(     0              `     (
     0     '     0                   8
     0P     %            <       '              P     H     `*          &              0P     X#                  0      ,     0     HQ     @              p&              0     Љ                p          ؉          J          I          L     (     E          D          G     (     0     @M     @              PG     X     G     8     E          L     X     L     8     @J          0     J     @              >     (     >     H     =     x     ?          A          hA           @          X9          4          h;          H:     H     P7          1     h     4          2     8     0     D     @              X3          <          8          (C     (     =          9     h     :     (     B     X     6     8     0     C     @              %d              F              '              0(     B     @                   E     LOGIN           0     l                    l     0(     @     P                        @     }     H     	     H<                    ,          H-           00      ?     `                         (     `     h     	     0     `>     0              x     X     0P     <            <       @     H	     x     H
     8X          p_	          @          0     ;     @              x	     P     0     :     @              0      9     P              	          0     8     @              	     в     0     8     @              0(     6     P                   P     0    4     @      <       &                                                                                                                                                                                                                                                                 0                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     6       Ф	          p	          	     ذ     0	     @     0     P3     @              0      2     @              ʽ            Г	     0     8          0	          	          	     е     Џ	     P     p	                     0h     -                   &              h	          	          	          Ȓ	          (	          ؔ	     д      	     p     x	     P     0     P-     @              0      R     0H    (\                      @D      a	          p          p&              0x    @V                 &                   p               h	     0     xg	     Ч     hy
     `7          pk     0     `S     @       <       '              P             0       ^     0     ^                   0                   ODS2 DEVICE ID          '              P              `              	                             0      a     08     Pj     p       <       M          p&              p          0     8h     P             &              d	           i	     `      a	           h	          /               G     Ђ     '              &              0     f     P             hN          0     0d     @                        0           (                    &              0     c     0              HD           0     b     @               R     0     0      Pk     0      Л     P              p&              8          p          H
	          0           `              `	          0          @              0	     p     0          `              (	          0                          0      H     @              x	          0           P              	          0(     H     P              	     `     08                     	          0     Ȍ     @              	           0          @              `	          0p    `                  "      {     &              	              x	     Ж     ('     p     x     H
     08                     	           0     |     P              	     p     0      `{     P              (	          0       z     P              h	          00     t                 &                        `	          0     s     @               	     @     0      q     p                  p     0     p     @                        0p    l                 d	          H	           `	     ب      a	          :               n     B               &              '              0      0     0x                     p&              &                   p     	     P                xg	     Ч     p          D	     `           p     08          `                   p     `	     ب     08         p      |             q     0            /               8n     H      i	     `     *.*             d	          '              0`                     &              &               h	           a	          p                        j     H     0`    X                 0h                     .               Xq	           l     `X      v
     7     0X    H                 h	     0     D	     `          Б     00         p             (     P     n     B     0h                     xg	     Ч     hy
     `7     0x                          А     v
     7     8          0      0     00         p      |       w
     7     d	           a	           l     `X     p          {
     07     hl     PX     0x                      
     3          i     0H                <                   
     p3     p&                   {     P
     `6     s
      8          @     0@                      h     H     
     1     0P    H           <       o
      8     8           i	     `      
     6      
          0         `            
     02     H     	     0@                     '              &              h	     0     pp     Y     &              0     Hj     H	           0    h                 j     H     
     2     &              0H    @     p             0H               <       0           0     p                     p          0                          0                          0     H                     0                          0     x                     0                           0                          0     p                     0                          0                          0           0                           p          0          0              :          0           h	          	     @     p          hL          XE     0     SYS             8g     `     F           0X     H                  `             &              P           C                p          0     p&               W          	     p     0     h                   &              H	           ^     P     '              xg	     Ч     0@                        h	          0H                 <       D	     `     `	     ب     0     P                   &              0                        ]	     p     0     0	                   	     P     x     H
     0      `!     0     "            <       p&              HOST_ID         V               Pe     G          '              0      #     0      &     Pz     0       &     0      %     0     $     0                      8X               Ј     ^	     Х     p             &              0      0'     0     X(     @                   	     `     (
     p          0     '                     p     pE     0      )     0      A                    0)              %s              F              %02X     
      
               0     0     =     `             `                   ȶ     0(                              %15d    %08Xh                  0      ;     0     x4            ?      |               H           P               p     O          p)              0     -     `             P              N          fid=  %6Xh 
    cid = %7d 
     other=  %08Xh 
         0      0-     0      8-     0     H*     @       |               &              0           p_	           #     o     0      `A     &                   Ј     `Y	     `     @     @     H     `    >          0p    @i                              u          `X	     أ     0     l     C     }     a           8N     8     0p    0d                 0h    xb           <       0p    X^                 &              0p    Z                 xA          0    V     @            0     R           |       &                                  0           (          p&              LST:            (C          %s/%04x.SPL     F              0h    J                 0H     n                  @'              @     H	     `	          0s          h	          0h    hN                  i	     `     0     M     0              0h    G                  h	          0(     HD     p              0       D     0     C                     W	          0X    B                  p_	          8X                       XW	     0     0      u     0     8     0                        08          p       |       G          0               `
              C           hg     P     g     0     F                     H     (     )             '              *             0                                   &              X	     Ю     @*                       -     p~     0    w            <                    F              p     (	     	          &              HOST_ID         (          y     `                                                                                                                                                                                                                                                        1                        # $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        F "     G       U          SYS$SYSDEVICE:                              0     v     0              0            0                          @              0           0                         $              0      p     0      P     0      H     0      @     0      8     0      0     0      `     Sc    0     x     0                      P)              p)              0     8                     0     Ȇ     0                          0      H          0           0     H                                       0                          0           0     p                    F                      P                     0          0              @             8X          0          0              &              0     @     0              NWFree()        0     0     @       <       p&              NWrealloc()     0           0      X     0      0     0            0      ؉     0           0           0           0     X                     W	          0          P       |       XW	     0          0     `                            F              p     0     H     P       |       Pid = %d
               $              %s
     0     `     P              0          P       |               `Y	     `     `X	     أ     0      ȡ     0          p             8X          In MemPoolAlloc         0          0                      W	          0     0     0              0           0@     @     P               H	           0@     ث     P               08          P               08     8     P               0@     `     P               0      X     0      P     0      H     0           0     0     0              &              C     |     0      @     {     0(     @     P                      8N     8                0                          %s/JB%s.%03d    y             F              0H    X           <       &              0     l     0p    p           <            i     0      p     @              0     (                     a           0          @              0                          0     X     0              0            @              0          0              0          @       <       Z     0     0          @              0(     `     P              0     (     @              &              0(     H     `       |       0P                      y             0s                       +          0                          0                                 `&              %s%s            p&              >          0`                      xA          &              0          0              0(     p     p              0          @                        0         @             x     l     /*.*    0           @       <               0           0     0     @              0    X           <       .QUE    /JF     c	          @'              XW	     0     	     @     0            0           {     0     `     0                      `Y	     `     0          0              `X	     أ     0     X	     P       |            p"     Q_SERVERS                 Q_OPERATORS     Q_USERS         0      `	     `       |       p     p     0     x	     @       |       <
     8     X>
     h     =
     (     00     0	     `       <       p&                        0(     (	     P              0       	     0     x	     @              p          08    	     p      |       @          `               P     0     	     P       |       0p     	            |            @     Џ	     P          А           P     0     	     0                        >
     H     0      	     P              0      	     @              85
          0           0@     `	     p       <       00    H
	     p      |                 0x    x	           |                 p:                   "     0     	     @              0(     	     P                   p     0     	     @              0     (	     P       <       0     H	     @                        X     0     0     h	     P       |       0h     `	                   p          0      	     @              X     0     00          p              0          p             @K     {     hZ
      1     pZ
     0                          hC
          ȶ     0(     P          	     @     V               @l                  X          F                         '              P:     0         P                    G          &              /                         Q_%0X           04
     `     :             c	          0     l     0      0	     0      +	     {     {     
0    +	             0     "	                             W	          0    "	     `            ȶ     0(     P             X          04
     `     `X	     أ                     P     `Y	     `     	     @     p          0      &	     @       <       XW	     0     0           &              0     	     0      |       @z     y     `	                        8X          U          P:             0      ,	     0     5	     P       |       0           a                     0     8	                     0     7	     @              F              Z     0          0     4	     0                      8N     8     0      2	     `              8X          0     01	     `             0     0	                     0     00	     0              C     }     0     /	                     0X     /	                  p&              X?     h     0P    ,	                 xA          P     k     &              0      9	     0     F	     `             &              &              '              0     E	     0              @               0     D	     0               	              0     B	                     0     `4     0     A	     @       <       &              0      @	      
     0    `>	     @      <       0    P@	     0                      O	          0      :	     0     ;	     `              +     /*      '              8W	     @                   0     :	                                   0     9	     0              r       shr = get                              0      H	     0     S	     0              &              '              0     P	     @              G              %x      %d      %o      0     Q	     `                   0     O	     P      |        Z                           ;	     p     @	          0    M	     P      |       0     L	     @       |       :	     Р     &              0     hI	     @       <       9	           P
             0       U	     0      U	     0      V	     0      8W	     0      @W	     0     `Y	                     @              0     X	     0                             ȶ     0(     0     0     `X	     0              0     W	     0                                    0     XW	     0                             0      PW	     0      HW	     0      Y	     0     Z	     0                              0      Z	     0     hZ	     0                      0           0      p[	     0      \	     pd     0      \	     0     0\	     0                                0       ]	     0     p_	                    H>          @          0     ^	     0                        	          1     x     0      ^	     d     0     X^	     0              *     p)              0     ]	     0                          0      _	     0     Xl	     `             K             p&                             ȶ     0(     0     0j	     0              &              .       )     )     ..      0      i	     @       <       `'              '              &              0      h	     0              0     xg	     0              0    d	                                                                                                                                                                                                                                                        2                        (+ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     X       `            0     l     	     P     D	     `     &                   p     	     @     &              0    c	     0             0     a	     `            0              *     0     `	     0                       0      m	     0     u	                          0      @t	     0    xr	                          &              0     q	     @             0     Xq	                    '              0     po	     @       |       Щ     0     n	     @                      D	     `     0      z	     0(     x	     P                                      $I    0     	     @       |       0     	     @       <               &              08     h	     `              0     {	     `             p&              0     	     0              0(     	     `       <       0      	     0      `	     d     0     	     @       <               `Y	     `     p_	          X>
     h     8X          0             <
     8     `X	     أ     =
     (     >
     H               0     h	     P       <                 0     `	     P       <       0     X	     P       <       0     	     `              p&              0      (	     0     	     `             0     p          Ј     @     @     0     0     0      	     P       <       0           04
     `     ]	     p     85
          =
     x     0      h	     0      	     0      	     0      `	     0      	     0     ȱ	     P       <       0      p	     0      	     0      	     0      h	     0      8	     0      	     0      ȯ	     0      	     0      X	     0      	     0      	     0      	     0     P	                     0     	                     0      ȭ	     0      	     *     0     (	                     0     Ь	                     0      	     0      `	     0      0	     0      	     0      	     0      @	     0      	     0      Ъ	     0      	     0      `	     0      0	     0      	     0      	     0      X	     0       	     0      	     0      P	     0      	     0     	                             &              0     	     @              '              0     0	                     0     8	     @              0     Ф	                     0     أ	     @              0     p	                     0     x	     @              0     	                     0     	     @              0      ؠ	     0      x	     0       	     0      ȟ	     0      p	     0      	     0      	     0      h	     0      	     0      	     0     P	                     0     X	     @              0      	     0      	     0      x	     0      H	     0      	     0      ؚ	     0      	     0      h	     0      @	     0      	     0      	     0      X	     0       	     0     	                     0     З	     0              0     P	                     0     	     0              0      P	     0      	     0      	     0      `	     0      0	     0      	     0      ؔ	     0      	     0      	     0      X	     0      (	     0       	     0      Г	     0      	     0      x	     0      P	     0       	     0      	     0      Ȓ	     0      	     0      p	     0      H	     0      	     0      	     0      	     0      	     0     0	                     0     8	     @              0     Џ	                     0     	     @              0      	     0     X	                     W	          0     H	     0              XW	     0     ȶ     0(     0      	     0     0	     P       |       d                     h	          `X	     أ     `Y	     `     &              8v          (e     @     0(    @	                 &              0           '              &              D	     `     x          pe          0      	     0              0     	     p             s     @     NWDMain()       8X          0     	     P       |       u     `     0     h	     @       <       0     	     0              0     h	     0                   X     0      	     @              0     @	     @              0     8	     0              0     X	     0              0      	     @       <       ]               &              0     H	     @              0      	     p             0     	     0              0     X	     0              0     0	     @       <       0     X	     @              	              p       0     	     P       <       `     ȶ     0(     0      	     0     	                     W	          0     H	     @       <       XW	     0     p_	          0     0	     p                             
0    	
             &              0      p	
     0     
                                    0     @
                     
0    
                     '              0     h
                     0      H
     0      
     0      
     0      @
     0     	     P       |       3     4     0     
     @       <       p)     0     h	     P             0     	     @       |       0     
                     0     	     `                   0     	     P             0      

     0     
     0              @
          P
     @     
           0     @
     0              
          
     P     0     
     0              
           0     P
     0              0     
                     
          0     

                     
          0      P
     0     
                     >
     H     0     
     0              X>
     h     <
     8     0     
     0              85
          =
     x     0      
     0              =
     (     0     
     0              0     P
                     hC
          0     
                     04
     `     0       
     0     0
                     @     @     0     H,
     0              0       ,
     0      +
     0      +
     0      *
     0      *
     0     %
     0                   Ј     0      !
     0              0     0 
                    0     
                     0      
     0      @
     0     
     0              0      P
     0      
     0     
     0              0     
     0              0     
                    0      0
     0     U
                               0      Q
     0              0      P
     0      HP
     0      O
     0      O
     0      8O
     0     J
     0              0           0     E
     0              0     D
                    0      D
     0     C
     0              0      hC
          0      =
     0      <
     0     >
                     0      X>
     0      =
     0      `=
     0      @=
     0     2
     0                                    F                   0     8
     @       <       0     85
     @       <       0     1
     0                  0     04
     0              0      U
     0     W
     0              <
     8     X>
     h     >
     H     0     0W
     0              8
          0     V
                     hC
          0     V
                     04
     `     0     @X
     @              d             p_	               `     XW	     0     
               `          0     `Z
                                       0     Z
                          H     0     Z
     0              `X	     أ     0	          `Y	     `     0     [
     0              0     H\
                              W	          
0    \
             0      ]
     @               Q     u          <
     8     X>
     h     =
     (     ȶ     0(     >
     H     08     _
     P              (v     h     `             @
          p          C          0     ,c
                   (          `     @     0x     e
                   p          
     п     0H     @n
     `                   0@     n
     `                    0(     o
                                                                                                                                                                                                                                                        3                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         5 "     i       @                   0H     |p
     `                      h	     X     0H     q
     `              0H     Tr
     `              PD          0P     t
     p                   0P     Du
     p              0x     xw
                   0     dx
                   0X     |
     p                      	          	           00     H}
     P              &              08     ~
     `              00     
     P              0(     Ѐ
     @              0H     Ё
     `              00     
     P              F              `     
       
     м     H
              LOGGED      h
          key = %s        0    <
                   0(     ܈
     @              0      
     d     0     Ћ
     0                      `X	     أ     0	          `Y	     `     0     
     @              8X               `     XW	     0     p_	                        ^	     Х     
          0     Ȧ
                     @              0      H
     
0    
                                    0     
                          H     0      
     0              Q             X>
     h     (v     h     <
     8     =
     (     ȶ     0(     >
     H     08     ؖ
                                  @
          	           h	     X                  xK     x     	          0p    P
           ?      H
          
     м     0p    Р
                 08     
     `                             0     
     @              0     @
                               0H     P
            <                      `     @               
     п     0     
     @              00     X
     P                             0     Й
     0              0     (
     @              0@     p
                   	          '              J          0     
     0              0     
     @              u          0     
     0                        W	          0      
     d     0     `
     0                      `X	     أ     0	          `Y	     `     0     
     0              0     @
     0              ^	     Х     XW	     0          `     
          0     0
                     &              0     `
                          H     0     
     @       <        R             (v     h     X>
     h     E          ȶ     0(     >
     H     <
     8     0     
     0              @
          F     x     h	     X     08     
     p       |       ؋     0}     .     s          {     0      8
     @              	          	           0     
     @              0     
     0              0    (
                 H
          
     м     0     
                               0(     8
     `       <       0     `|     0     p
                  
     п     `     @     0      
     @              08     
     p       |                      i	     `     D	     `     0     
     `             0     p
     @              08     (
     p       <       0(     h
     P              0     
     P       |       0@     x
                   0     x
     0               0     p
     0               08     
     p       <       &              08      
     p       <       0     
     0              0     0
     @              =
     (     u          0     
     0                        W	          0      
     z      e     0     
                          H     0     h$     0              0     
                               0     P#     @       <       0     h&     0              0     X%     @       <       0     p"     0              0     `!     @       <       0     `
     0              8X          p_	                        0	                    0     X
     0              0     0
     P       |            `     XW	     0     0           
                0      H'     00          p       |               @
               P}     0     P     0               	           0      
     0      
     P              R             >
     H     ȶ     0(                  X>
     h     (v     h     (             <
     8     =
     (     H     0     
     @       <       0          P                      I             X^Cy
0     X
                       <On        `H          
     п     `     @     0     X     0              h	     X     0          P       |       0     (	     P       <       0          0              `Y	     `     `X	     أ     0     p)                     0    '                 H
          
     м     0           `              0     `     `             0          @              0           @              0     0
     0              0           @              0          @              0                         	                00     (     p       |       0(          P              0     8
     `             0      
     p                     X	          0     H
     0              0(     (
     `       |       0      
     0              0(     H
     P              0     X
     @       <       u          0     h
                              W	          0      )     0(     -     @              
          @             ]
     (     X
     0     0
           0     H-     0              <
          Р
          '          (
     `     0     ,     0              
     @     P
          ܈
          p)          0     ,     0              \
          
          
          
     `     0     +                    H\
          
           h
     `     
     `     0     p*     0              p_	          
     `     0           8X          0
     p     P             @X
     p     @
          0      .     0      HW      ~     0      V     0      V     0      V     0      PV     0       V     0      U     0      U     0      hU     0      0U     0      T     0      T     0      xT     0      (T     0       T     0      S     0      S     0      PS     0      S     0      R     0      R     0      `R     0      R     0      Q     0      Q     0      pQ     0      (Q     0      P     0      P     0      P     0      8P     0      P     0      O     0      xO     0      PO     0      O     0      N     0      N     0      XN     0      N     0      M     0      M     0      `M     0      0M     0      L     0      L     0      L     0      HL     0      L     0      K     0      xK     0      J     0      pJ     0      @J     0      J     0      I     0      I     0      I     0      I     0      `H     0      H     0      G     0      G     0      G     0      PG     0      G     0      F     0      E     0      E     0      E     0      HE     0      E     0      D     0      D     0      PD     0      C     0      PC     0      (C     0      B     0      B     0      B     0      HB     0       B     0      A     0      A     0      hA     0      A     0      P@     0       @     0      ?     0      ?     0      p?     0      (?     0      >     0      >     0      >     0      H>     0       >     0      =     0      =     0      @=     0      =     0      <     0      <     0      H<     0      ;     0      h;     0      0;     0      :     0      :     0      x:     0      H:     0      9     0      9     0      9     0      X9     0      9     0      8     0      8     0      H8     0      8     0      7     0      x7     0      P7     0      7     0      6     08     6     `               q     F              p     0      5     0      5     08     4     `              0      4     0      @4     0      4     0      3     0                                                                                                                                                                                                                                                         4                        Xw $      PWRKV50F1050.G                  > ![NW.KIT.AEXE]PWVN$IFN^@A"%3X&O
1                                                                                                    
                                    RȦ'-9wcHrnuR'Q!M( J!+n%\])X\UO#uFUQxXsFRgh
$YIC\97
4'4 xhy1|pQo+Da$#h%[TELjcYdMڟ1ݝxiOJ		;ر;BKT=zUkMK<T@Trct'֧Y$w[
mYveq,@"rUE".iR,\zL3ϷuVF_%ER+/?%9_N,@*{Θx~l(g%|aK=<QȆaj5^T#;<^iٕp̺yQ<bCtL%oTH}>w9i=+j-w@}EBB7:D+JyLs|!̺&j
ۙĶRΖ?τ>N$CCZףYX&ʧ
=T4z#Sh߰	@U炔mՕ,OI?,\
r}|*%ui^+-\%
fWiȒٿfZjBxO@T2-gpaC&@+@s{|%r5a^C<)Ş$N㞬bƷK-PD/G79Ti#v=(R[M]z	1QQlb燮1P@TF~ˋb| )Fz|~ͫ={ԋL]IÒv^bRoHzԴt~Ĳ)t̅"4=ɺs>-2"~tFصͭ#FKA0@ϼA6}fxC"dmƬsdG?u7/?3NryuڙWRD4zɂEխ.kq˞!'o-';^anpSf^ֈ2sE t/ 飑E<^ҷh1)u\ɸHX`d
aBBoujyvہ">G
|{Tqn4YjC<U咖AkGȀy}'ݣзۉŞXNײhy7hB/}q%a|{lpS=sQ~NR*HQ]X [,]jrPuϼB`*A3"QN0ڷv[]O,q(r<k(6͘?;g{7RcSCH$"7r?
uѡYSN, \S{Wr sg^dXj4֭n߻UDI9}{ Jqד$U J)BQ:7;IˉLT7sl*U
#
/5*+K-MN%V'9Vq5z"6Ap\lfk+ܳ"b
xo:M$|1nMgUb`oX"_[ug\XT7<AO[:Gк<3]4^;wf$?(+ۭq}hbrfFj\.]
I_mOqqPP#/>/ 3Z8p'ꤵ/DK|;sˤ@_>}HXF_	 Cb[æZ*;|:
a
ErZ3sS᠞_ig^z+]bs)2~UD;$_bcժ`\Ru'.EEsLHZleI/x#;q:$SM; TڵQb7k~yƌ{qUj ~hf{nHfŏ}6Q/4':X۬+^bHßGW0b݆6dłUH&UJwF'R\}"}6:Ҭ{L+"GeZy)3a'[ne
'u
pƇKhȚ>IZQKMHR/S_&zOo듂=&a_/gBw
(!VҖu#?\]
d$2u$Д(ͳqvbeXJ ϖ$*ڱ{s?Xݍ@x8kB[à{Q7MC'pN@ѻS?"+۸ܥ!]ʢ#;fw Ŀ+-/HHe^ʣ'wF? C;Ccd39Լ g%e{h%	ۑVPdݞ$=cM~J@C
t4g~2N4jWu?F<$YR|N>#k}sGbyWVO9oIWGFYQ]|7g<r[{6IJZ$wn-`EIuFKry=G~T)Ώ X<YCu-	_SbzQR8M9;j	|Gmemx2n0f^Y+{~`A.?6b[bڅ\}-בEZAev(вg;K9nRd ,\ϨahtʃOJ<M2Ec!mSesSV\aC2ql"jQWg.2Es
;O3etpORpEU]љY~HF#}因Am@9%O`6n?ͯ[j Kr%\j;ONPD~XłUy?.޼ov(8%S Obu6

p.7ϕa"*ƺRN#r=: LDju`58OD*lB	4ђK\zjW[	
To'Bs9xtflF^T M)Wl);dwG
`1z@E`ܑYQV'~jK#OMuap1VʁC/y}20Q(9XeypvF#ܿ.萰Ϧv8@V2bi tAhq	Πn%ND./vzLGҶ=B갈2&*T2 l'-pLزKB3̪\얻R7 tu7ZdO'֣T/
f{DL}L-(0{ Ly#C/k͋z9"Q1u==]fMt1$	юO$yX|ǂڞq#eEM7,#`7ʔn~J$pmՓpKx([''$"qsx!ك,OZf-vSK xCѶ5O/ bVd'ׇj

(`{^.QV=ye_c+7<PM!=Ghy5D{r"F7L*$/w1MI8`IQ`/p|ϕEoƩN%-L`u:Iyb7bL
;W#7@bٞ8QѵavHM]#a=!ºEUΑ(y}(yhcXF. UZnMnuD_u]l|,@dKxF#	ϿPd:]A)I|6 ~͑Qt+!q^rC8/aLdv5Nm*qS%d21
Jd>3!"؎N59/
5#vwzAr(\qN]^vצ6ӄ[S=ia
;@q?յ2lq@!(/9H-``s縈8N}
Mi	ӿZvBXbyE+J@0qP['A%alEnec_pZut)		;&O
t߹׺rEG,<8_:޲qz630ͮr.|0l;.1I֌}+\
DLt3Ǝ&4'%&5¡r9Sm)q\+bΏFLkO
߭[]&#xrOˈ_s)a1}BoʜCzؐdB֮c>MI"KH_UDA4?9'W]n=KpxC	\ ZAdaq"tZ.Y6Сm
n744*oX׍9/i OXqϓ~Җ4z3Q*1tP~}w׽:ŗ)(㵈QzX2)>҆e0b|Ǐ NF,Aۜ|t)3R-4PlHf
)0pm68U9FAu3&Ù`f+(zr}3$줄?0um+ۀGbn9o2G\1=ތaayZ"[ުw@󺔱!r[[1IM2j@N($7\f[}1ۘ4 lx#ޅ.:	#"p[3
.\N}a4ǀ[wq-
([I <s!2b9{ݓˈ#]Ki]&Nc>^ʢk,oIoUf`g,X/˙Z\Wb<ʹ%fMVLݎeMTNv&k.W~?*DмtTVx%E%
/@ƞ<mZom1G
Ԝ`pi}7gh9e|O3S$@
_+n<;͹3iٶ>}dpxjqKPý8=}WGd,P`k1D{8#)(Ѧ0L<&nFN&p [!;5/k=:5LB5O8s 4p')s5mN_K[OfE.7x7Q̠8	߃OsKP`/|g;8OpFT~Db%ݬAJ^
_N
0!(}6%TN&=ˏ-2l}	woA{|HկR]HY"eg5rw.-HOrE%bN(d\Tp_	莩1pY+=RX.X}<<u93p
@qYfUPZ(((+mͿ&$y{ZD-"q%Wcw`Pv)mޠKofݰqs@ih4`ѕ-hU-k4;4t.v
? ijQX\I \oo􀲙e%|߅3EN;u]tDJ'g>WBsɺ`^s:hݐHPL vLԈa#CAC,U!24,LzZ+27?Mj7~d&V̫`
	kxU&wyaY7k;Mxp e %$^crgBwDR->b
\ي=L{ixW~>̂C8hinL+O%Xh-=@ns&(Ox&%w8Dl4eśiZ
oO=Dhz 3	zdwN-҇5ū9"ߞL^Pv#$Ҡ3w6MaɬPݧL;/%#jsr3IxG "[SY鿖zSpv`9"b A2'-
ߺC9]M'-PNH(+W:!SJhJ#5cYI
w>OixGݭ̝ͳшy*hyYkJQC!uN(y5B=paqV&Be%HH$j-WT1-,=F <KѹM73ud?G y~Q/5I.n7Eڃ>j`W<m}<XeV`#RUDB'R/` 9à%9v-ufAՊ^o yg@sM1jA	hqG-'R^h%tF
k!Ķ
d"~G=f I ċv\Z#(|E
 W8xQF.Ak?q)LQBZ\''Q		n婄{S=GE;UMXt<$yg;w*wL3%s_pb9kjW	^Wt }ɣKf@K/
җ\_뚒<>?:؏IVmĨH@:F43ytD6cLsbPos930BeB_DZu1q!)x*tK&`_kT
@F`9Pp1ebOvVԥH-:+I6ݙso a?4GB-2d`kU<s!wDrnguNn0#Pf&yhA;ܩT\mHQX@aU/d\[s"iΆfh:^2
)}96n'="XQfoUR˸@Cy!
UW 0L	@d)QPV8ZG++n'Sbfx&F281׸T-9:>䜷*DIEqS
n&gNzv.mEM)*Bp!ȩ4fC칂$%zRE+{X-fY/c|c& `qzЈ8`S'gW7O
JPM(knkC<77і|s^x^-EOYZQ
֞;)r|<|ۍ8u/U[
zs+JTHc"v+2Y+&MU}F`CoLPd߱	VK>dšq+­6!"1?]w?+`S)72cEO	]Iΐg{<*:-2`8:Hg<o(SNyM7$\s0afy2OZjOqރb/8v90K
'<J 5%Ȅn<KWlQom<^?^kCNB	ɦ-Z;ܗ	
r:giOkEERwT'<aTpg\} 5c^kG;\m!}_w!BrQ)`\a&)\(e
j_ ̠QC13U e"gKnS*"$<E&a:~$`
w*tidNam+xnnzTjnO>5hj\~Y]E, IZm?GKA0Q[&ū*Pm[Π}5KYj
HԕpbMB7.I'yX2	1x!8z8:H=k;2Lz'Zl0֩H%9bc֢ U;?|.ks|1Mff 3	Zw{S<,㪈zY5Gs*{knDS)GJGڴ!b_#vfAt2(
qoe7af-2S1,<%s wxb1n
n	Ôi`nRܒuJ_3֭plcSә #޳!dDe /귭F'BMqj*7qVKI
8Ip`XN0IqjzWz{+ g6~:Epp&              0     8*                                                                                                                                                                                                                        5                        7\ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        k "     z       3     0      X3     0       3     0      2     0      2     0      h2     0      2     0      1     0      1     0      H1     0       1     0e     0     0                     W	          0     @/     @              p_	          8X          0           XW	     0     &              0      W     0      j     P              F                    
       %s              С           0      i          0     pf     0                      &              `'              .OLD    OLD     &              0      0g     @              	                     0      c     P       <       f                                          r                              G              %[^:]:%[^
]     0      e     0                            '              0    b     0             P4     z     0	          1              0              
              G              v          u          0     l     N          Џ	     P     &     P       	          x     H
               xA          C     }     0     8X                  G                              -     p~     F              0s          	          %s
    (%s)    	          >          P	     0     a           P	     p      o                                  0     i                     0     h     0              0           0      n     @     0      o     @                     '              @'                            0      o             0     (v     0                      X          0     u     0              0     Pu     0              00     t     P              p&                         0      s     P       |            8     g                       0                               F                   0     r                             X          0     p                      q     0      0p     0       p             0      v     0      w     0      pw     0      hw     0      `w     0      w             0     (     `                     F                       0          P              <     w       d                                          0      w     0h    (           |       P                                             `&              08     X     p       <       0@     h     p              0@     p     p              0@          p              0          0               }     0@     Д     p              0X                                p&              0P                        0X    0                  0           0p     X                   ȶ     0(                   <                                           p               t_sndudata      0h     0            |                                    0                                          t_rcvuderr      t_rcvudata                     0P     ؇     p                              0                                                                          0          @       <       (g             `Y	     `     `X	     أ     0                                      &              @               0     x                     0      8     0               0x     0y                    #     o     XW	     0                :     0     px                            8X          StartupComm()                   Z	          0           0     p7     @       |       F                   %02X                    LoginTime =     ipxaddr =       %02X    0     5     P               q                    w       d                    <     ;     0     H2     0              F               NotHolding     Lic. Status  =           ;       Holding         %d     0     1     0               Special        Lic. ObjType =           Unknown         Regular        0     H4     0               FS     ObjType =        USER    %04d   0      3     @       <       ;       0     (.     0              0     p,     @       |       ȶ     0(     
             &     n     0          P             q             '              0           `X	     أ     `M          `Y	     `     &                        0     +     `             -     p~     0      *     0      `*     0      *     0     )     @              	          0     '     `                        0     ('                     0     P&     0              0     `%     @       |       p           0      (%     0     X$     @              0     x#     @              0      "     0     !     P       |       0     (     @       <                                   0      5     @       |       0          0                                  p/     0           0      8     0           0      @     0      X     0     0     p             X>
     h     <
     8     `&              =
     (     >
     H     0          `             0           0           P              0     @
     P       |       0          P       |       0     	     P       |       0          P       |       0          P              hC
          (Q          0          P       |       0          P       |       0                 ?      8
          04
     `     P          85
          0     @     @       <       0           0              0     0     p             n	          0           0              8     Ѓ     Ъ                z     &              <g     0          @       <               /     0     0     p0     0              00                       p&              Ȇ                     *             &                      0           @              0          @       |       0     x     @              0      8     0     p     `              0     (     @              0          @              0           0          @              0      (     0     H     @              0     P     P              0          @              0          @              0           0          @              0      0     0          @              0      h     0     P     @              0      X     0           0          @              0          @              0          @              0          @              0           0           0          @              0          P              0          P       |       0          @              0          @              0          0              0          0              0           @              0          0              0          @              0          @              0           @              0          @              0          @              0           0          @              0          @              0     h     @       <       0     p     @              0     @     @              0     P     P             0           0          @              0     h     @       <       0     `     @       <       0     H     @              0           0      `     0           0      x     0                  ?              8X          x7          0          0              W	          0     P     P              p_	           #     o     PWVN$TRIGGER_CT         <     w     `     ؚ	     p     XW	     0     0      ?     0@     H{     `              F              /MAIL/%X        0     l     o
      8          {     0      p@     @              p     @z     p             8N     8     p     `     P|     `|     0      x     `      |       X
     P1                    @      *                                   0     p                   
     p&     P           X
     `'     Y
     1     0@     |     `              s
      8     0     E     P              '              p     p      n	          0     8s            <            #                0     u                                                                                                                                                                                                                                                        6                        KI $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        J "            `             p     P!     &              hX
     `1     0X
     1     hZ
      1     pZ
     0     3     3     0      t     P              
     %     0     @l     0            0|             @           &              @     С     8Y
     01          #     h	          x     X     8      c     [
     0                xZ
     0     *     @g     0    0Y     P            p&              `&                    #     3     `     p          8X          	     P     0    a                  3     h     Z
     p0                	     0           (     P          0     X     0              0X     V                  ]          HOST_ID         0(     U     P              0     S     `                                  0     R     P       |       0     N     `      ?      0     C     P             0X     hM                  0      A     @                   0     a           0     (J                  @          0     H     @       <        
     '     0     G     P              0     B     @       |       0      }     0           @              p     @z     p             8N     8     p     `     0|     @|     0     ~                    '              0P           p               z                                           0          `             &              n	          p                        y          04          0           @              p             hX
     `1     0X
     1               0          P                    !     0H     8            |       P           0          P                   #     0          P       <       x     8$     0     (     P             0           @                   0     a           0X                 |       @     С     @           0P     H                   0P     h                  0     8                              hZ
      1     0          pZ
     0     &              &              0     P     @                   %     0                 ?      3                   (     P!                  x               
     %     P               p     0           0X     p            |       0           @              p     |     p|     0           @              0     ؁     0                      F              @                            Flags  = %X 
   Name   = %s 
   Hash   = %X 
   Prop   = %X 
   Secu   = %X 
   0            p     p      p@                    @                     
     p&     p|             Y
     1     0                      &              X
     P1     OBJ_BACK_LINKS  P           p                       @     С     *                         0           0           0H          `              0           0                          m
     `8     0      8     0     0     0              `             '              0                          @                     pZ
     0     0X
     1     hZ
      1     0|     0P                       p           !     @z                       hX
     `1          #     0     P                               0                         0          0              0      P     @                        0                          x     H
     0          @                   p"     +     0                   0           0     x     @              @             X>
     h     <
     8     >
     H     hC
          ȶ     0(     S     0     p     @              {     0                         '              0     8     @       <       z             =
     (     pq     pu     0     `                    0           F                   0          @       |               
     P     85
                0     h     @              0     P     @              0      @     @              0     P                    0           p                     p&              04
     `     8
          0           `              0     X                    0     X     @              0           P       <       &              &              0           P              n	          0     p     P       <       0     P     @              0     @     @              0     x     P       <       &              0                                  0     P     0              0           0      8          0     p     0                                    F                   0          0                      0      P     0                      P!              x     P     p                              0           P              p             0X
     1     @z             hX
     `1     @
     &     0            P                   #     0@           `              &              x     X     h	          `&              	     P     0           0                       X
     P1     
     p&     0(          P                   p     x     H
               @
     &     3     0X     x            <                               !                         h     0          `     8                    @                `     p     0|     0                       @z             @     С     P           *               p     `     hZ
      1     pZ
     0          0      
     '     &              0      `     0     
     P              P!             @l          &              8s     
     @z             H{     p     3     3     0    
     P            p&              R     p     S     0                         0     @
                  X
     P1     p     `     A          @     С     @                     0    X
     `      ?      p|             &              P|     p          0          H     0     
                 0|                             "     C          B               @      n	                    P          p@          0           P            '              0          %          E     `
     X                     3             0      
     0      V
     @z     p     pp     p     0     l     p     p     SYS     0|     p|                  Т     &              &              0             p_	          0X    0I
                  P     X     8X          X?     h     SYSTEM/          |     P|     p&              p             	     @     p     0     XV
                    0      Q
     @                      C     |     p     @     0     O
     @       <       0X
     1     hX
     `1          p     0     `N
     0              0     H
     @                        x     H
          8
     `     	          8     h     	     P     h	     p          Џ	     P     hZ
      1     ;                   A                    @     С          @     @           u                    py     0P    X4
                              0     &              p             p     `               y             p@          '                        I                       	          pZ
     0     ~     P     8     P     0     p%
     0              W	          0H     &
            |        z     pz                    @|     `)     SUPERVISOR      EVERYONE        PASSWORD        USER_DEFAULTS   GROUP_MEMBERS   Ȼ          GROUPS_I'M_IN   t          0    '
                  G          /           SECURITY_EQUALS                 P     k     xA          GUEST   `|     V          |     0     S
     @                      0           XW	     0     InitBindery()   0X    h
                                                                                                                                                                                                                                                                    7                        + $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        R "            C     }          Щ     P     0!          X     &              .system]        0      pW
     0      Z
          0     [
                     00     xZ
     P                      p&                         0      pZ
     0      hZ
     0     Y
     @       |       0     8Y
     @       <       0      X
     0     hX
                     `Y	     `     0     0X
                     `X	     أ     0      0\
     0(     
     P              ~             `X	     أ     `Y	     `     
     I     0(     
                  X>
     h     .     s     =
     (          #     
     J          @     &              <
     8          K     0(     
                   l     `X     00     
                  &                                   {     @
          0      
     0              0     
     `             X	          x     H
     @
     H     
     0I     0P     ȏ
            |       0     
                     0     
     @              X     H     0     0
     0              0     
     0              0              9     ;                   9          @               0     b
     P             0~     Xg             F              *             	              0	                             	              00     
     p              p             	     K          PJ     E     P     0(     
                  p
      D     H     J     (
     C     }      _     (
     C     00     P
                  P
     G     (
     G          `^     00      
                  X
     PH     p
     F           J     
     G     0      }
     `              0      {
                       ^     00     hy
     p                   K          L     0@     w
     p       <       0     v
     @              0      v
     @              0     s
     `             0(     o
                  
     H     8X          0      m
     `       |       
     E     <             u      Y     (     K     ({      Y     
     G          PK     0     l
                    0     i
     P             '              Џ	     P     0           /             &              p&                        0      a
                     :     0     a
                                           0     x`
                    (:     0     P_
     0                      -     p~     X
     =     `
     `=     
     ;     
     <     
     ?      
     ?      
      >     
     >     0     \
     @       <                 
     >     
     >     
     @?     @
      >     ض
     ;     س
     <     p
     0=     0      `
     0     
     @              ~     ~     8>     P     0=     Q     0     ض
     @       <       0     ~                   0           H
      @     <
     8     =
     (     >
     H     85
          X>
     h     0     
     0                           
     0D     X
     PH     0     س
     @       <       `&              0     X
     @       |       0     p
     0              H     @P     00     `
     `       <       P
     G     (
     G          p          K     E     P          `^     	     K          PJ     0     @
     @              0      
     @       |       P~             04
     `     p&              ~             (     P[     H     J     0     
     P                    J     0     
                     0     
     0              0     
     P       |       
     J     0     
     @       |       
     H     
     G     0       
     @              (     K     u      Y          PK     ({      Y     
     G     0      
     0     H
                     p     `     g     0     
     @       <               01	          p     0     
     0                      00	          p     @     .system]         /	     @     &              0                0     
     @       <               &                   X          Щ     0     l                    Т     0     `
     @       <       @     С          0     8	          @           0      
     0              7	           0      
     P       <       2	          0     P
     @       |       /           Ȼ          0#             ,	          0(     H
     `       |                 X0     T     <                  p     85
          04
     `     ȶ     0(     0     
     @              <
     8     X>
     h     
     PG     >
     H     =
     (     0     (
     0                    PJ     0     (
     0              0     p
     0              0      
     0     
                     p     `     h     0     P
     @       <               01	          p     0     `
     0                      00	          p     @     .system]         /	     @     &              0           8     0     
     @       <               &                   X          Щ     0     l                    Т     0     
     @       <       @     С          0     8	          @           0     p
     0              7	           0     p
     P       <       2	          0     
     @       |       /           Ȼ          #             ,	          0     p
                           J     0     
     0              o      Z     >
     H     0     
     0              <
     8     X>
     h     =
     (     <     0     (
     0              0     P
     @              0     
     0              0     
     P                       n      Z     85
          0     X
     P             0      
     0     X     0                        0     @
     p                  L               &              h     J          K     (      m     08    
           ?      0           .     s     `     |     H     J          @                         0      
     P       <       X	          0           0          @       <       <
     8     X>
     h     =
     (     0          `              `&              8     Ї     B     pQ               0     H     @       <       ~     0      
     0               0(     h     @              0      
     0                       0=     Q     0           @              8>     P     0      	     0               00          P              08          `              .     s     0     (     0               0           @              0            0     "     `             ~             <
     8     0           `X	     أ     -     p~     `Y	     `     85
                    0     (!     @              X>
     h     }
     7     >
     H     0                          W	          ~     0     P     0                      
     x@          [     .      U     `
     D     #     MAIL    PUBLIC  `)     @z             o
      8     00          `       <            {     {
     07     0     l          @     LOGIN   SYSTEM  
     F     p             H2     S     %     @U                     8X          /     T          (     0           @              
     8E     
     A     `     \          ]     p_	          P
     PB     F              InitTrustee()   0          `              PU           b
     4     ȶ     0(     04
     `     XW	     0     <             H>          0      $     0     H     @       <       85
          0            n      Z               0     8>     @       <       <
     8     X>
     h     =
     (     0     E     P       |       <             `
     A               hC
          
     PG     >
     H     0     B     @              0     0?     @              ~             04
     `     0     0=     @       <       0     <                                                                                                                                                                                                                                                        8                        DlE $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        cS "            0              0     ;     0              0P     8            <             J     P
     hD     P$             F              0X     4            |                     
     8@     `&              0P     3     p                   [     0     H2     0              p     `          Т          0     0     l          Щ     .system]             X     `              !               |     (     0     )     P              (i     z     &              !              &              01	          7	           p     SYSTEM/                  /	     @     2	          0     /     0              0     X0     @       <       @     С     8X          @           0     .     0              00	          p     @     0     %     P              /           Ȼ          ,	          0      pK     0     h     P       |       ~     p     0~             b
     4          p     `
     A     0      e     P              <
     8     X>
     h     =
     (     ~     0(     g     @                      8>     P     0=     Q     0      pe     p&              
           
      B     0           
     H     .     s     `Y	     `     X
     PH     ~             85
          `&              0     0L     0                      H     J     >
     H     }      _     p
      D                   `X	     أ                              
     A     y          0      @k     0      hl     0       l     0      @m     0     {     @              X>
     h     <
     8     ~             >
     H               =
     (     0     u     @              0     ({     0              hC
          0     xy     @              0     v     P              .     s     0      pp     p             &              8     Ї               B     pQ     0     o     0              0      n     @              85
          ȶ     0(     0           %             04
     `     0       }     0          0              0             hC
                    0=     Q     <             
     @C     >
     H     ~             
     PG     0     (                     p     `     i     0          @       <               01	          p     0          0                      00	          p     @     0     `     @       <       &                   X     &              0                Щ     0     l      /	     @               .system]             Т     0     8     @       <       @     С          0     8	          @           0     ؎     0              7	           0     Ћ     P       <       2	          0          @       |       /           Ȼ          0%             ,	          0(          `       |       04
     `          p     X0     T     85
          &              0(          P              <
     8     X>
     h     H     J     0           @              .     s     0     ~     @              0      }     P              0           0     H                     p&              Pp     0                                             |     0          0                      -     p~     x     X     0            P       <       x     @     0           0     x                     4j                "     0                        U          `&     :     %     %     0     X     @                   p"               0    @                 )     `!     V                    `X	     أ     `Y	     `     &              
0    @                                    0           @              Ȇ          0          @             0     H     0                                                           X           X     0     8            <            8                    x               P                     0     x                     0P     8            <       00    h                 G          0           P              0X               <       x     H
     	          Џ	     P     p                  8
               F              0                          W	          .system]        P%             X     h     8X               @          Щ     08     `     `              &              &              XW	     0     p_	                         X     net$acct.dat    0           0          @              `j          '                             &              &              0    8      	      <       p%             p&              @                                                        p                              P              0     H                     k     z     p          0                          0                               P     0(     !     `       <       `&                   X     `7                    0          @              P            W          P           xi          8g     `                   &                   Щ          @               XE     0     h          &              &              @     0P                               hL          C           F           xp     p     '              8           `      {     (           h	          ..              (     P                                i	     `          H               0(                     8     `!          0          !                   =     P      ?                @     .       0           P       <       0     0                                  x     0           @             S     p     P>          p     0v     `Y	     `     :     r     X          0         `            0     x     0             `X	     أ          t     8N          0         P             0         0                      `'              0     `     02           0     P     P            0P    x           <       0     P     0               |       8          (           (          @          0          @              0                          0     0                     0     (     0              0           0      @     0     $                     %             ȶ     0(     0@      /     p              &             F              `              <empty>
                        <
     8     
       

      X>
     h     =
     (     0     p-     @       <       }     0     +     P               }                    w                                             D
          0      )     0P    &                 F              k             H	           (%                %s             %s          PAthNAME_NULL            VolName_NULL          0     Hj     0      $     0      #     `             0                                             0     "                     0     p"                      3     0      "                     0     !                     0     !                     0     0!                     0                           0            0            0            0      x      0     (                          `=
          @=
          
0    `            0     p                     
0                0     @     0                                          0          P       |                 0     (     0               0          0              0     :                    z             `Y	     `          @     0     :                                0     P:                    `X	     أ     0     x     0                        8     `!               F           0     ȣ     0              hC
          >
     H     0          0              0     .                                                                                                                                                                                                                                                                        9                        Z;i $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "                 Щ     0          `             0     Й     @       |       0          P              85
          
     P     0          `             0          p             `'              P          &              ;               U          
     5     8g     `     \          0     8     P       <       0     P;     @       <       P>          Y     0          `     close           H     0     X           j     `     0     9                               0     p     `                           
     04                    `                i	     `     &               h	          0     `     0P    x                 `p             C           `7                               !     `                   h_     	          0X     x                   03             ^     P     0     (                                8
          0           04
     `     p           0      h%     3     0     9                             @     p     0      @     0           P       <       .                    8Y     @                flush                                   (               @     (     open     ^      g     0    H                                                       &              W           
          8N               0     F     p     `C          0x                      close dc1       open dc1             0     
                   _          8          @          0      ز     0           @       |       `/     @     0     `     @       <       0H          p              '              &              PWVN$LOGFILES   .PRINT]         P              /SYSTEM         /LOGIN  *.*;*   `              /           0         0            ..      )     .       )     z             `&                        0L     pW          X     0      0     @              0      (     0            0          0              0     `     @              0P     C                                0     C                     0     ؋     `             0          0              0      {     `             0     @     `                        0     x|     @              0      y     @       <       0      .     @              0              Hk          hL          0H    [                 Pq                            Q     x     8X          P     P<     -     p~     FSIWriteFile()  F                        0     a                  @           write   0      8N                  read              release         0(    v                 0     u     0               0`    0s                 Xq	               i     ب     0     0     j                  0     Z     0              0     T                  
0    C             0      (C     0               0      B     0               0       B     0               0      xA     0               0     @                     0      @                     0      ?     0               0      X?     0               0      >     0               0      >     0               0`     6                   |     ;                            0     1     P             0      00     `       |       	          	          0 00:%d:%d.00   h	          ITNS$_ACCESS         Ј     08     h*     `              ؚ	     p     P
              |             	     x                    0	     X         0     )                            W	          0     %     0               	              TRUE    FALSE                        0             init          @3     ^          XW	     0     p_	          0     X$     0              (V     StartupFSFile()         v     @      7          C
          0                              q             0       7     k     0     Z     @       |             .          0     ]                     0      Y     0     8Y     0              `&              0      S     0     8N                           0       E     0     K     0                           `               0      G     P              0      ?     P              0          0     =     0              &              '                         P                          0     &              ./      )     0     `7                        p           m                          X          f     x     H
               0      ^     k     0     h            <             	              0      8     00     P     @                              '              0                          x     X     0           0          P       |       &              000000          &              0                     `&                   0)     &              8X          	           W                    0              P           ISO-9660        (unknown)       ȶ     0(     0`    0|                 /             @          Spiralog        High-Sierra     ODS-2           0              	     `     X	     Ю     hL                         =          0    y     P                          `'                   8*     [                         &              ]       0     x                     0     8v     @       <             h	          0     s     @       <       0     u     0              0(    pe     p            F	                         p     CONDITIONAL     NOCHECK         CHECK           ^     0g     FIX*ED                        STR*EAM         0      (e     0x     ^            <                           Щ     (          0            0                                 3             '              G          Z     ؄     U          HOST_ID         Hk          %x              x     l     /*              C           k     /MAIL/*         p     p              /MAIL/               i     &              0               <                    &              ب     0          @l     `'                   @     H     0_     0     l     0s          F           G              GUEST   0          0                      h*          H     pf     0                         )     8     @     0m     X$           FIX*ED  NOCHECK                 .          CHECK                     0         P      |       F	          &                   f     p_	          6     p     STR*EAM         0           k     0          @                      X$          00     8     p       |       C           hL          X     @      0(          p              Hk          00          `       <       0          0              X     H     F           0     0     @              0           @              0           P              `/     @     0          @              0     Ъ     P                       8     `!     0      ب     @              0     (            ?                    .          x#               !     0     p     0              l                  P                0             C           ȶ     0(     0          @       <       @&             X>
     h     <
     8     =
     (     &              '              0          @       <       P             &              &              04
     `     X                       0           85
          0          @       <                          `     F              P     Э     0          `                           .          0H                        @          VMSParseACL          !     `/     @     P              8          @          0    y                 `&              g     hV     8     `!     &              %d              F                                                                                                                                                                                                                                                                 :                        0= $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        Z  "            0     Hy                     @              0     x     0              DECcache Thread                                              0      e                                   0      n            ?                    0              (                                 0     e                  0x     c                   0     x6                     0      _                 @3          Щ     0     W            <        3                            0              0p     U                   VMSDeleteFile   0x     8T            <       VMSTruncateFile         0h     Q            <       0     `M     p             VMSReadData     0     8O                  VMSWriteData    0     P>                                          0     H            |       VMSCloseFile    X          0x     F            <       VMSReOpenFile   0x     `C            |       VMSOpenFile     X	          0     A                    0x     @                   0     02     0            VMSrename       0p     0                   VMSrmdir        0     (                   VMSmkdir create         VMSmkdir parent         VMSmkdir write  VMSmkdir close  VMSmkdir        VMSmkdir assign                 `              (           G           xp     p     :     r     z             @
           :     pr     hL          0(     (                  8N          8           0          p     0v     0L     pW     .     s     K          0                       @'                   H     0p                        VMSForwardLink  0     
                   VMSFoundFile    0x                        VMSBackLink     0x      
                   VMSGetFileName  0x                        VMSNextFile     0P                     VMSBackLinkHost         %ld     G              0                 <                 0@                     VMSTrusteeACE   0`                          hh          0     (     P     ب     0          Б     0         `            VMSFileFind     0+          =     P     G          `'              p            0`                     0           0           0           n     0                                 ȶ     0(     P9                           0          @              h             @          hL          P          b     p                                 P              0              0           @                            0     x     0              0           0                                                        0     0     0                        0     x     @                   0     X     `                     0           '              C           `              0     @     0                            0     @                     0                          0     p     0               W          P           p              @              F           0                          0          @       <                     &              0     Ȼ     P       |       0          `              8X          0     p     P       |                          @     0     0     P       |       0           p             RMSRFARead       /     p          0          `             RMSSeqRead      0          P             RMSRewind       0      @     p                     hr     @     `&                  0                                        0(                       0          @              0          P       |       RMSConnectFile  0          0              RMSCloseFile    0     @                     00           p       |                         Щ     `'              RMSOpenFile     0                          P              0     @     0                             0               0     P?     0               	              0     =                   X	     Ю     	                         =             ȶ     0(                       '              
 Astlm: %d           
 Biolm: %d           
 Bytlm: %d     	              0     7     @             F                  
 Fillm: %d               	  
 Wssize: %d    
 Pgflquota: %d         
 Wsquota: %d   
 Wsextent: %d  
 Diolm: %d     
 Tqlm : %d     
 Prclm: %d     0     6                                   0     @     @                   @     x     X     0`     04                   XY             F              PWVN$SVR_%08X   0	              checking        getting          	              00     1     `       <       n     p     	              @
              P              0          @       <       (          0     /                   `'              0      /     0     `/                               0      /                               0     .                     0           0     ,     0              0     0+                     x     H
     0     p                    
              S     X     VMSChkPro       0         P      <       F	          0           0      X     0                                        0                         0              0                         VMSReleaseMutex                 @              0     @                    VMSAcquireMutex                                0                         VMSDeleteMutex                0     p                    VMSCreateMutex                 0           0           0          @              VMSToDOSTime                  0           0      8     0      @     0`     P            <        E          0     @
     @       <       &              0h                       &                   .DIR;1  p              %X      __2E    *               &              .*      0      0            ?              &                            0     P     @              0     8     @       <       %d      0           0                          0x                                  f     /             VMSGetDOSPath   @'              0     h     0              0H    P                 8     `!          !                              VMSForwardLink  0H                      0                 <       0              0          0              `&              0           0              0           0      0A     0     C                                   0      C     @                            P              0     XB     @                            0     A                     p              0     C     @              &              0           0     hr     `             `&              0     xp     `             &              0     Hk     p             0                             0      xi     0     HQ                    p&              0      P     0     g     P             0      hg     0      8g     0      b     0     \                    0       W     0      P     0     hL     0              0     G     @              0     F     0                        0      XE     08     t     `              C             &              '              n             0	              08      v     `              n             '              $                            	              0          @       <       8     8     F                  %s
         (E     0     ~     @              0     `              0               08     px     P               0     y                  `     NLA0:                               P              0      y                     0              08     w     `              0     `y                    0     X                     0              08     `     `              w                                            	                            E     MBA%d
  F              0     `                     &              0    h     0             &                        0         0                                                                                                                                                                                                                                                                ;                        ,p $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ǹ "            '              00     (     `              %s      r                      G              0                   0           @q     0           0          P       <                     ȶ     0(     F                           &              0                         `               (     0     X     @                                    0          P       |       p&              0                                       0           0              0     0                    p              0     Ј                    P              0X     Б                        n     '              F                                            	                   G     %d      0     Г                                           0                          p               0@          p              '              &              	              0                          0     H                    	                            @
              G                           0(          P              	              %08x            F              0      p     P       <       &              00          P              S       0@          p                      0	              0          0              0                          0                                      F              0                          %c     o     00          P                              	              0(          P              P              p)              0H          p              U       0(          P              0(     X     @              0(          @              0(          @                      0     С     @                             o     0     @                             `              0      h     @              8             0                                                        0                                        `     0           @                                                    0     h     0                   FSP$Main                                                           system.dir      public.dir      mail.dir        login.dir       SYS$SYSDEVICE   STARTUP: XQP+: Error enabling deferred cache writeback. $QIOW Status = 0x%08X
  STARTUP: Error checking status of XQP+ threads. $QIOW status = 0x%08X
  STARTUP:     Error deleting XQP+ thread, $QIOW status = 0x%08X 
        STARTUP: Deleting %d additional XQP+ thread(s)
         STARTUP:     Error allocating XQP+ thread, $QIOW status = 0x%08X 
      STARTUP: Allocating %d additional XQP+ thread(s)
       STARTUP: XQP+ status; Threads-mapped: %d  Threads-active: %d
   STARTUP: Error checking status of XQP+ threads. $QIOW Status = 0x%08X
  STARTUP: Error enabling XQP+. $ASSIGN Status = 0x%08X
  STARTUP: PWVN$XQP_THREADS value is being lowered from %d to %d
                  Please refer to PATHWORKS Installation guide for more information about setting up XQP+
       STARTUP: SYSGEN parameter XQPCTLD1 value is 0.  XQP+ cannot be enabled.
        STARTUP: SYSGEN parameter VMSD2 value is 0. XQP+ cannot be enabled.
    STARTUP: XQP+ is not present/installed. $GETSYI Status = 0x%08X
        STARTUP: XQP: Error getting sytem version information. $GETSYI Status = 0x%08X
         PWVN$XQP_THREADS        Num. of Read-Ahead Cache Misses:	%d
    
Num. of Read-Ahead Cache Hits:		%d
    Num. of FS Dir. Cache Hits:		%d
        
Num. of FS Dir. Cache Misses:	%d
      Num. of Lost FS Entries Encountered:	%d
        
Num. of New FS Entries Found:			%d
    
Num. of Hybrid Check Failures:	%d
     Num. of Files Salvage Failures:	%d
     
Num. of Files Salvaged:			%d
  Num. of Clients Watchdogged:	%d
        
Num. of Watchdog Packets Sent:	%d
     
Messages Sent:	%d
     Max. Simultaneous Semaphores:		%d
      NW Semaphore Requests:				%d
   Max. Simultaneous Physical Locks:	%d
   Physical Lock Requests:				%d
  Max. Simultaneous NW File Locks:	%d
    NW File Lock Requests:				%d
   Max. Simultaneous Logical Locks:	%d
    
Logical Lock Requests:				%d
  Max. Simultaneous Transactions:		%d
    Transaction Backouts:		%d
      Transactions Performed:		%d
    
TTS Requests:				%d
   Unknown NCP requests:	%d
       
Lost Packet Resends:	%d
       Max. Simultaneous File Opens:	%d
       File Write Requests:	%d
        File Read Requests:		%d
        File Opens:				%d
      
File Creations:			%d
  Max. Simultaneous Connections:	%d
      Create Connection Requests:		%d
        Total Packets Received:			%d
   

		PATHWORKS for OpenVMS (Netware) Statistics

        Deferred Close File Timer:			%d
        Maximum Directory Searches:			%d
       Creator ACE Flag:				%s
        Write-Behind Flag:				%s
       Read-Ahead Cache Flag:			%s
    Read-Ahead Cache Block Size:	%d
        Process Spawn Ahead Count:	%d
  Max. Clients Per Process:	%d
   Max. NetWare Processes:		%d
    Max. Supported Volumes:		%ld
   Max. Supported Volumes:		%d
    Max. Supported Connections:	%d
         Server Version:		%d.%02d Rev. %d
       Server Stop Time:	%s
   Server Start Time:	%s
  %s %s %d, 19%d  %02d:%02d:%02d  Server Name:		%s
       


		PATHWORKS for OpenVMS (Netware) Information

       about a particular
iteration of the server.    
This file contains information and statistics  PATHWORKS for OpenVMS (NetWare) (%s) down.
     SHUTDOWN: Stopping communications
      SHUTDOWN: Server shutdown initiated
    VerifyExistenceOfNWDirs()       SpawnSAPThread()        TransportListener       SHUTDOWN: Received shutdown signal...
  STARTUP: Erase disk blocks disabled
    PWVN$DISABLE_ERASE_BLOCKS       PWVN$ALLOW_MORE_CONNECTIONS has been defined - server can support more than %d connections
     PWVN$ALLOW_MORE_CONNECTIONS     STARTUP: Log Login-Info enabled
        PWVN$LOG_LOGIN_INFO     PWVN$LIC_SPECIAL_OBJ_LIMIT      STARTUP: PTS PANIC disabled
    PWVN$DISABLE_PTS_PANIC  STARTUP: Diagnose heap enabled
         PWVN$DIAGNOSE_HEAP      STARTUP: Initializing async. events
    Error obtaining running okay process lock
       STARTUP: Spawning Transport Listener.
         Error obtaining file server name lock
  ERROR: Can't map file server %s to ID
  Error converting cluster control lock
  Server is running in a cluster
         CreateDownMsgThread     STARTUP: Starting SAP thread
   STARTUP: Updating configuration file
   STARTUP: Server will not use XQP+ 
     STARTUP: Server will use XQP+ 
         StartupDiskQuota        STARTUP: Initializing disk quota.
      STARTUP: Initializing accounting.
      QMS: Not all queues could be started    STARTUP: Initializing qms.
     STARTUP: Initializing trustee database.
        OpenBinderyFiles        NWDInitStaticDirs()     STARTUP: Initializing file system
      STARTUP: Max connections changed from %d to %d.
        STARTUP: Initializing communications
   STARTUP: DeferredClose is set to: %d
   STARTUP: LongNameSupport is set to: %d
         NWDMain_GetAddress()    NWDMain_VolList()       FILE_PRO*TECTION        NWDMain_Vollist()       NWDMain(NPSConfig)      configured to run in a cluster.

       @SYS$UPDATE:PWVN$CONFIG on this node and it will be 
   
This is an illegal configuration.  To fix this, run
   but there are %d other servers running in this cluster
         This node's server is not configured to run in a cluster
            cluster server
         and that node's server will be configured as a
         To fix this, run @SYS$UPDATE:PWVN$CONFIG on that node
       2) Some node in the cluster is configured cluster inactive.
       stop all servers in the cluster, and restart them.
             If restarting this server fails to clear the problem
           If this is the case, simply restart this server
        this node's server is initializing
          1) Another node's server is initializing at the same time
    This happens for two reasons:
  Error obtaining cluster control lock
   NWDMain(NWConfig)       Initialization Error: threadcreate: %X
         Error obtaining startup process lock
   Initialization Error: VMSCheckPrivs: %08X
      PWVN$LOG_CONNINFO_CID   Failed updating Last PacketInterval for %04X; ccode = %02X
     Failed clearing WD count for VCID %04X; ccode = %02X
   Rcvd watchdog reply N from VCID %04X (NCID %02X, username %s); logout failed with %02X
         Failed setting LOG_THIS_GUY_OUT_BIT flag for VCID %04X; ccode = %02X
   Rcvd watchdog reply %02X from NCID %02X; no match found with address    -- End debugging data
  (control->Time_BitMap[ byte ]) & (1 << bit) = 0%X
      bit = 0%X, 1 << bit = 0%X
      control->Time_Bi                                                                                                                                                                                                                                                   <                         ! $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "            tMap[%d] = 0%X
         -- Begin debugging data
        Status %02.2X from registering as event agent
  Registering as event agent
     PWVN$DIAG_DUMP_OPENFILES_TIME   InitAsynEvents::EnableAsyncOnSocket()   InitAsynEvents()                PutSystemConfig()               NWSapTrackControl()     OUT:	[A:FFFFFFFFFFFF]	%s
       Last SAP: %d; Curr SAP: %d
     Sap timer is %d seconds late 
  	Hops: %2d	Name: %s
    IN:	[A:%02X%02X%02X%02X%02X%02X]        Expanding network table to %d servers
  ERROR: can not allocate server object table
    Give Nearest Server     Get Nearest Server      Internal SAP Socket not found in socket table.  Server Down.
   Creating network table with %d servers
         SAPThread::EnableAsyncOnSocket()        NWSapOpenChannel()      NetWare Print Server
WARNING - Log file %s in use
     PATHWORKS V1.0-611F for OpenVMS (NetWare)       Log file %s opened
     Log file closed
                PWVN$VOLCONF.SYS                TLThread: Creating a new client thread: cid = %4d
      For above: the REQUEST_NCP (Not TRUE_NCP) is:
  Invalid packet received with Cid = %d ; req_type= %08Xh; pkt dropped 
  TlThread: GetFreetransportPacket failed with cc=%d; NO recv transport buffers; AccCnt = %d 
    PWVN$XPORT_NOTAVAIL_LIMIT       TLThread: EnableAsyncOnSocket Failed! Exiting...
       TLThread: InitTransportPacket pool failed! Exiting...
  
                               %02X%02X%02X%02X        
Buf <%08X> @%08X:      Beginning Address of Pool = <%08X>; Number of Read Transport Buffers Allocated = <%08X>;

      Size of Transport Read Packet = <%08X>;  Number of bytes displayed for each Packet = <%08X>;
   Transport Read Packet Pool.  PACKET_INUSE=<%08X>; PACKET_FREE=<%08X>;
  PWVN$TRANSREADPOOL_VIEW.TXT     
TPACKET ERROR in ReleaseTransportPacket, Packet corrupt
       tpacket.c; GetFree PACKET corrupted!    
STATE MASK = %d        
tpacket.c; GetFree, freelist blown RACE CONDITION DETECTED!              NetWare error code returned to client: %08X

           Raw NCP (REQUEST_NCP format) :

        PacketSize:            0x%04X
          SubFunctionCode:       %d
      SubFunctionStructLen:  0x%04X
          Function:              %d
      CurrentTask:           %d
      SequenceNumber:        %d
      ServiceConnection:     %d
      RequestType:           0x%04X
        Invalid NCP received from:              %s %s CID = %0xh 
      NCPMoveFileDir: ConvertTokenStringToCString() failed : CID = %0xh 
     Unable to communicate with Lic Reg to release license; Conn Num = %d
   Call to Lic Reg to release license returns unknown status = %d
         netbios/streams/ipx     Could not get the client address from NCP to release license; Conn Num = %d
    Unable to communicate with Lic Reg to verify license; Conn Num = %d
    Call to Lic Reg to verify license returns unknown status = %d
  Could not get the client address from NCP to verify license; Conn Num = %d
     %s station %d cleared.  Connection terminated.  WARNING: outNCP is NULL in NCPDestroyServiceConnection for connection %05d.
    WARNING: outNCP is NULL in NCPDestroyServiceConnection.
        WARNING: inNCP is NULL in NCPDestroyServiceConnection
          NWEngInitNCPPool()      NWEngInitInNCP()        Sunday  Monday  Tuesday Friday  January March   April   May     June    July    August  October Wednesday       Thursday        Saturday        February        September       November        December        Authors:        Grover (Bluto) Righter  Bryan (Gee Wally) Sparks        Drew (Aardvark) Spencer         Tom (Yellowjacket) Fulton       Dave (Col. Flagg) Hefner        Paul (The Terminator) Cameron   Mike (Radar) Fritch     Hashem (Playboy) Ebrahemi       Karl (Enigma) Walbrecht         Tim (Tweety) Bird       Nikki (Responsible Adult) Bennett       Shelly (Howdy) Dowdy    Marie (Hot Lips) Jackson        Craig (The Toy) Toyama  Curtis (The Owl) Johnson        Testing geeks   and many more.  ###############################################################################
        index= %3d  Value = %6d 
       CurBatchEvtCtr table: 
          **********End of DUMP of Event Tables: *************** 
       %6d %6d %8d %12d %6d %8d        evtidx	flags	timingctr	period	agent	funccode  cid/fid                    Time 
          TotalEventsEntered  = %d , CurrentEventsEntered = %d 
          DUMP of Event Tables: max_events = %d 
        Shutdown signal in async events
        Registered as event agent.
     EVNET.C: Nomore event slots, EvtCode=%d, period=%d      ScheduleEvent: FunctionCode (%d) beyond limit (%d)   
  PWVN$EVENT_TABLE_SIZE   StartupSpooler()                                     #           
         @              Overwriting allocated block.
   ValidateMemPool: Checksums don't match!
        ValidateMemPool: Block stamp trashed!
  0x%x: end: 0x%x  size: %u  next: 0x%x
  accessSemaphore = %d
   allocFreeFunctions = %d
        initialSize, blockHeadPtr = %d, 0x%x
   currentInUse, peakInUse, maxMemAvailable = %d, %d, %d
  Free list head = 0x%x    (%d free blocks)
      
Memory pool at 0x%x:
  CoalesceMemPool: Block stamp mismatch!
         CoalesceMemPool: Checksum mismatch!
    MemPoolFree: Block stamps don't match!
         MemPoolFree: Checksums don't match!
    MemPoolAlloc: Checksums don't match!
   MemPoolAlloc: Block stamp trashed!
     File %s finished on %s:%s       Netware/SRC v1.0D QMS file      QUELIb.c CreateNWQueue: ERROR: after SeparatePath = %0xh 
      STARTUP: QMS: Created queue %s
                       Queue is not available for use.
  STARTUP: QMS: Queue file for queue %s contains obsolete record format.
         STARTUP: QMS: SYSGEN SCSNODE not defined; $GETSYI status = 0x%08X
      STARTUP: QMS: ERROR - unable to allocate queue management system memory
        REWRITE: FAILURE, Bad record number passed! 
   RemoveFromRecordFileFreeList    UpdateRecordFileHeader          l  ,  ,  ,  ,  ,     ,  ,  ,        ,             NVT     SPX     NETBIOS SAP     NVT_SERVER_NAME NVT_GETTY_ENTRY NVT_INIT        NVT_SPAWNS      NVT_LINE_DISCIPLINE     LOAD_NVT        SPX_FLAG        LOAD_SPX        NETBIOS_FLAG    NETBIOS_SHIM    NETBIOS_MODULE  SAP_FLAG        START_SAP       SAP_STANDARD_OUT        SAP_ERROR_OUT   SAP_REPLY_DELAY INTERNAL_NETWORK        VMS_REQUEST_TYPE        PRIORITY        LAN_0_ADAPTER   LAN_1_ADAPTER   LAN_2_ADAPTER   LAN_3_ADAPTER   LAN_4_ADAPTER   LAN_5_ADAPTER   LAN_6_ADAPTER   LAN_7_ADAPTER   LAN_8_ADAPTER   LAN_9_ADAPTER   LAN_10_ADAPTER  LAN_11_ADAPTER  LAN_12_ADAPTER  LAN_13_ADAPTER  LAN_14_ADAPTER  LAN_15_ADAPTER  LAN_0_NETWORK   LAN_1_NETWORK   LAN_2_NETWORK   LAN_3_NETWORK   LAN_4_NETWORK   LAN_5_NETWORK   LAN_6_NETWORK   LAN_7_NETWORK   LAN_8_NETWORK   LAN_9_NETWORK   LAN_10_NETWORK  LAN_11_NETWORK  LAN_12_NETWORK  LAN_13_NETWORK  LAN_14_NETWORK  LAN_15_NETWORK  LAN_0_ADAPTER_TYPE      LAN_1_ADAPTER_TYPE      LAN_2_ADAPTER_TYPE      LAN_3_ADAPTER_TYPE      LAN_4_ADAPTER_TYPE      LAN_5_ADAPTER_TYPE      LAN_6_ADAPTER_TYPE      LAN_7_ADAPTER_TYPE      LAN_8_ADAPTER_TYPE      LAN_9_ADAPTER_TYPE      LAN_10_ADAPTER_TYPE     LAN_11_ADAPTER_TYPE     LAN_12_ADAPTER_TYPE     LAN_13_ADAPTER_TYPE     LAN_14_ADAPTER_TYPE     LAN_15_ADAPTER_TYPE     LAN_0_MODULE    LAN_1_MODULE    LAN_2_MODULE    LAN_3_MODULE    LAN_4_MODULE    LAN_5_MODULE    LAN_6_MODULE    LAN_7_MODULE    LAN_8_MODULE    LAN_9_MODULE    LAN_10_MODULE   LAN_11_MODULE   LAN_12_MODULE   LAN_13_MODULE   LAN_14_MODULE   LAN_15_MODULE   CLUSTER VOLUME  VOL     SHM_KEY DEBUG   FS_NAME SERVER  NET     NETWORK LOGIN   TTS     CONSOLE ULIMIT  ACCOUNT RECORD  ASTLM   BIOLM   DIOLM   BYTELM  ENQLM   FILLM   JTQUOTA PRCLM   TQELM   WSQUOTA CLUSTER_VOLUMES CLIENT_STACK    LONG_NAME_SUPPORT       CONFIG_VERSION  CONFIG_FILE_VERSION     HYBRID_VOLUME   SECURITY        SHM_SIZE        SHARED_MEMORY   SHM_ACCESS      IPC_ACCESS      MAX_CONNECTIONS CONNECTIONS     MAX_VOLUMES     MAX_VOLS        DEBUG_OPTIONS   FILE_SERVER_NAME        SERVER_NAME     LANGUAGE        MSG_LANGUAGE    NET_NUMBER      NETWORK_NUMBER  MAX_PROCESSES   MAX_PROCESS     MAX_PROCS       SPAWN_AHEAD_PROCESSES   SPAWN_AHEAD_PROCS       CLIENTS_PER_PROCESS     CLIENTS_PER_PROC        LOGIN_ENABLED   LOGIN_STATUS    TTS_ENABLED     TTS_STATUS      TTS_LOCATION    TTS_BACKOUT_FILES       TTS_BACKOUT     WRITE_BEHIND_FLAG       WRITE_BEHIND    READ_AHEAD_CACHE_FLAG   READ_AHEAD_CACHE        READ_AHEAD_CACHE_BLOCK_SIZE     DIR_CACHE_ELEMS DIR_CACHE_SIZE  DIR_CACHE_ITEMS NATIVE_LOCKS    HOST_LOCKS      BLEED_THROUGH_LOCKS     CONSOLE_FLAG    PRINT_MESSAGES  CONSOLE_DEVICE  CONSOLE_DEV     ERR_LOG_FILE_SIZE       LOG_FILE_SIZE   ERR_LOG_FILE    PTR_LOOP_DELAY  PRINT_DELAY     PRINT_CHECK_TIME                                                                                                                                                                                                                                                   =                        y2 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        , "                   PRINT_CHECK_TIME_DELAY  SALVAGE_UTILITY_FLAG    SALVAGE_UTILITY SALVAGE_UTIL_FLAG       SALVAGE_FLAG    SAVE_DELETED_FILES      SALVAGE_NUM_FILES       SALVAGE_MAX_BYTES       CAPTURE_UTILITY_FLAG    CAPTURE_UTILITY CAPTURE_UTIL_FLAG       CAPTURE_FLAG    PASSWORD_ENCRYPTION     REQ_PASSWORD_ENCRYPTION PASSWORD        BINARY_LOCATION BINARIES        EXECUTABLES     EXEC_LOCATION   MAX_FILE_SIZE   NEAREST_SERVER_RESPONSE_DELAY   LOG_WATCHDOG_LOGOUTS    DISPLAY_WATCHDOG_LOGOUTS        ALERT_DIST_LIST ALERT_NOTIFY_LIST       RECORD_TYPE     REC_TYPE        RECORDTYPE      SAVE_STATS      USE_SAVED_STATS CLIENT_AUTO_CONNECT     AUTO_CONNECT    AUTO_RECONNECT  MAX_FILES_PER_CLIENT    CREATOR_ACE     MAX_DIR_SEARCHES        DEFERRED_CLOSE  BASEPRIOR       PGFLQUOTA       WSDEFAULT       WSEXTENT        **Error locking shared semaphore at %08X; status = %08X
        **Error locking semaphore at %08X; status = %08X
       **Error destroying semaphore at %08X; status = %08X
    **Error creating semaphore at %08X; status = %08X
              %s (index(%d) + tokenlen(%d)) > %s (%d)
        GetLastElementFromPath() failed: len of path (%d) excceeds DOS max limit( %d) 
         MakePathString error - thread-id %08X, pos:%d, len:%d
  `     H                                                   RemoveNWEngine2()       RemoveNWEngine()        DecNWEngineClientCount2()       DecNWEngineClientCount()        IncNWEngineClientCount2()       IncNWEngineClientCount()        IncNWEnginePackets2()   IncNWEnginePackets()    DestroyEngines()        No memory for NW Engine List
   StartupServerInfo()     Can't add duplicate (cluster) volume %s
	Check cluster members for duplicate volume name.
      StartupVolumeTable()            I_AllocAheadSLNode routine: Failure to allocate memory
         I_AllocAheadSLList routine: Failure to allocate memory
             loggingCounter = %d             LOCKED_SHAREABLE by %d client/tasks.            LOCKED_EXCLUSIVE by client %d, task %d        hash index = %u               StartupSemaphores               Physical lock module    StartupPhysicalLocks    StartupLockManager              Error returned from getdata in GetCacheMisses: %d
      Error returned from getdata in GetCacheHits: %d
        StartupStatsStruct()            %PWVNC-E-UNDEFINED, undefined cache error: %X   %PWNC-E-ERROR, error completion         %PWNC-F-FAILURE, failure completion     %PWNC-S-SUCCESS, normal successful completion   %PWNC-E-TOPNEGVALUE, dummy error message -- report is ever received     %PWNC-E-TFLUSHINITERR, error starting threshold flush threads   %PWNC-E-NONCACHESIZNOTMULT, noncache size is not a multiple of buffer size      %PWNC-E-NOMEM, out of memory    %PWNC-E-MAXFILESREACHED, maximum number of open cache files reached     %PWNC-E-INVNONCACHESIZE, invalid noncache size  %PWNC-E-INVCACHESIZE, invalid cache size        %PWNC-E-INVCACHEFILEDSC, invalid cache file descriptor  %PWNC-E-INVCACHEBUFSIZE, invalid cache buffer size      %PWNC-E-INVARGADDRESS, invalid argument address -- argument could not be accessed       %PWNC-E-INCOMPATVERSION, incompatible interface version         %PWNC-E-ILLFLUSHINTERVAL, illegal flush interval        %PWNC-E-ILLDIRTYBUFRATIO, illegal dirty buffer ratio    %PWNC-E-FUNCACCVIO, no access to function address specified     %PWNC-E-FLUSHINTERVALTOOSMALL, flush interval too small         %PWNC-E-FILEALREADYOPEN, file already open for caching  %PWNC-E-FFLUSHINITERR, error starting file flush threads        %PWNC-E-IOERR, i/o error occurred on file       %PWNC-E-ERRLOCKSTRUCTS, error locking cache data structures     %PWNC-E-ERRLOCKBUFS, error locking cache buffers        %PWNC-E-ERRDISKWRITE, diskwrite failed  %PWNC-E-ERRDISKREAD, diskread failed    %PWNC-E-BASENEGVALUE, dummy error message -- report is ever received    %PWNC-E-CANTGETCACHELOCK, can not acquire cache configuration lock      %PWNC-E-CACHECONFIGURED, InitCache already called -- cache configured   %PWNC-E-CACHEBUFSIZNOTMULT, cache buffer is an 'odd' size       %PWNC-E-CACHESIZNOTMULT, cache size is not a multiple of buffer size    %PWNC-E-DIRTYBUFRATIOTOOSMALL, dirty buffer ratio too small     %PWNC-E-DIRTYBUFRATIOTOOBIG, dirty buffer ratio too big         %PWNC-E-ERRALLOCCACHECTRL, error allocating cache control memory        %PWNC-E-ERRALLOCCACHEMEM, error allocating cache memory         %PWNC-E-BCBQINSERR, error inserting BCB on queue        %PWNC-E-BADCOUNT, count to read exceeds max     %PWNC-E-CLOSING, file is being closed     @      (  X                x        `  H  0      p            8       P  h      ; file: %s, cache handle: %d    Error doing cache %s    PNW_FAILURE:  Unable to open error message file.
       PNW_FAILURE:  Error message file %s empty.
     PNW_FAILURE:  Unable to open error message file %s.
    PNWError:  Unable to recreate log file.
        PNWError:  Unable to create old log file.
      PNWError:  Couldn't get file size of log file.
         PNWError:  Couldn't open/create error file.
    
%s %08X:%08X
 %s 
     Inform: The previous message was not written to sys:\system\sys$log.err.

      Inform() couldn't print msg %s.
        PNW_MSG_FAILURE:  Error getting error msg (%d).
         SetConnectionCommInfo failed!!! in SetClient 
                 
                               %02X%02X%02X%02X        
Buf <%08X> @%08X:      Number of Write Transport Buffers Allocated = <%08X>;

         Size of Transport Write Packet = <%08X>;  Number of bytes displayed for each Packet = <%08X>;
  Transport Write Packet Pool.  Beginning Address of Pool = <%08X>;
      PWVN$TRANSWRITEPOOL_VIEW.TXT    netbios/streams/ipx     netbios/streams/ncp     	Flow controlled: TFLOW
        SendPacket: t_sndudata() failed %d
     SendPacket: PWVNStreamSendList failed %d
       GetPacket: t_rcvudata() returned T_MORE, rcv_flags says there is more data...
  t_look() did not return T_UDERR         	 Call t_look()...
     GetPacket: t_rcvudata() failed %d
      GetPacket: PWVNStreamRecvList() failed %d
      GetPacket: PWVNStreamPostRecv() failed %d
      EnableAsyncOnSocket: t_optmgmt(PWRK_ASYNC_ENABLE) failed %d
    EnableAsyncOnSocket: StreamAsync() failed %d
   OpenChannel() - t_bind Failed!
         BuildNCPMuxChannel: MarkEngineForUse() failed
  BuildNCPMuxChannel: AllocReadWriteBuffer() failed
      BuildNCPMuxChannel(): t_optmgmt(PWRK_HANDLE) failed
    BuildNCPMuxChannel: t_open() of netbios/streams/ncp failed - 2
         BuildNCPMuxChannel: t_ioctl(I_LINK) failed %d
  BuildNCPMuxChannel: SET_MAX_CLIENTS failed
     PWVN$CONNECTIONS_PER_256        BuildNCPMuxChannel: BindToSocketFailed() failed %d
     BuildNCPMuxChannel: t_open() of netbios/streams/ipx failed - 2
         BuildNCPMuxChannel: t_open() of netbios/streams/ncp failed - 1
         
TriggerMsgCtr: %08X
     pwvn_obj_type: %08X pwvn_lic_status: %08X DuplicatePktCtr: %08X       SpoolerInfo: %08X HybridUserStruct: %08X memDebug: %08X EngineProcessID: %08X Undefined: %08X
  outPacket: %08X PacketAcquired: %08X PacketEnqueued: %04X PacketSync: %04X CommInfo: %08X LogKey: %08X
         WorkingPacketSize: %08X outPacketLength: %08X
  FileSequenceNum: %08X FileSearchContext: %08X Packet: %08X PacketSize: %08X WorkingPacket: %08X
        RecentReadBytes: %08X ConnectTimeCheck: %08X NumEquivs: %08X Equivs: %08X HandleTable: %08X
    OpenFiles: %08X Requests: %08X WriteBytes: %08X ReadBytes: %08X RecentRequests: %08X RecentWriteBytes: %08X
    Message1: %08X Message2: %08X ObjectType: %04X ObjectName: %08X ObjectID: %08X
         ExpectedSeqNumber: %02X workingSeqNumber: %08X MaxBufferSize: %04X LocalFileTable: %08X
          LoginTimeInMinutes: %08X WatchdogCount: %08X LastPacketInterval: %08X
        
CONNECTION_ENTRY @%08X SlotInTable: %04X Flags: %04X StatusFlags: %02X ClientType: %02X
       ====================================================================

  	Total_TriggerMsgCtr = %u
      	Total_DuplicatePktCtr = %u
    CONNECTION TABLE
       PWVN$CONNTABLE_VIEW.TXT         TOTALDuplicatePktCtr = %d ; TOTALTriggerMsgCtr = %d 
   DuplPktCtr = %d ; TrigMsgCtr = %d 
     
Flags = %04Xh ;  StatusFlag= %04Xh ;  WatchCt= %d ; ExpSeq = %d ; WorkSeq= %d ; PktEnq = %d ;          Obj. Name = NULL ;      Obj. Name= %s ;         **** End Connection Info ***** 

        Connection ID = %5d
    **** Begin Connection Info ****** 
    Received msg from connection with low byte zero, high byte not zero, %04X
           NCP that caused Trigger Message is 
           Queued NCP is:
                 Working NCP is:
            Trigger Pkt Msg: PktEnqued = %d, CID  = %d
     Obj. Name = (NULL) ;     Login info for client t                                                                                                                                                                                                                                                   >                        sAT $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ( "           hread: cid = %d
        StartupConnectionTable()                
 Press RETURN to continue >    Type   = %X h %d d 
    ID     = %08X h %d d
   
 Dumping Object: 
             DYNBINDCACHE module: Failure to allocate memory
                I_AllocAheadAceCache routine: Failure to allocate memory
       OpenBinderyFiles()      Add Server Object       CreateBinderyFiles()            PWVN$TRUSTEECONTROL     PWVN$TRUSTEELOCK        PWVN$FILE_SERVER_NAME   TrusteeClusterLock: Error (%d, %d) initializing lock.
  TrusteeClusterLock: Error (%d %d) converting to CWMODE.
        TrusteeClusterLock: Error (%d %d) getting exclusive trustee lock.
      TrusteeClusterLock: Error (status %d) converting to PWMODE.
    TrusteeClusterLock: Error (iosb %d) converting to PWMODE.
      TrusteeClusterLock: Error (status %d) dequeuing lock.
  TrusteeClusterLock: Error (status %d) converting to CWMODE.
    TrusteeClusterLock      TrusteeClusterLock: Error (iosb %d) converting to CWMODE.
      CreateTrusteeDirUserEntry       FindTrusteeDNode        GetTrusteeDNodeUserList         CreateTrusteeDNode      BroadcastToOtherServers         TrusteeBlockingAST: Error (%d).
        TrusteeBlockingAST2: Error (%d).
       PerformTrusteeSync: Error (%d).
                           (  @  X  p                         Netware/SRC v1.0 TFILE          No memory for trustee file struct
              Netware/SRC v1.0 TUSER            X      (  h      H  x        P      
InitTrustee: DJMount returnError code %d       StartupTrustee()        Failure to setup cluster trustee lock
          DJDeleteEntries failed in DJMountUNodes
        DJDeleteEntries failed in DJMountFNodes
        CreateTrusteeDJNumFile:  Failed to alloc memory
        Netware/SRC v1.0 T_DJNumFILE            No memory for new object list
  Netware/SRC v1.0 TDNODE         StartupAccounting()             SYS$SYSTEM:SYSUAF.DAT   
                                    dummy routine called
   	cacheHandle    %08X
   	RMSblock       %08X
   	FileType       %02X
   	BeingDeleted   %X
     		OpenFlags     %02X
   		OpenCount     %08X
   		TaskNumber    %02X
   
		ClientNumber  %02X
  	ClientList             	WriteCache     %08X
   	WriteCacheMute %08X
   	FileModified   %d
     	CloseVMStime   %s
     	VMSmodtime     %s
     	ACE_CONTROL    <not shown>
    	DosName        %s
     	FileSize       %08X
   	Channel        %04X
   	ForkType       %02X
   	FileAttributes %08X
   	OpenFlags      %02X
   	OpenCount      %08X
   	VMSVolListPtr  %08X
   	HostVolNum     %02X
   	unique_number  tvol = %02X, node = %04X %04X %04X, u_num = %04X %04X %04X, forkType = %02X
    	Semaphore      %08X
   	SHARED_OPEN_FILE = %08x
       *** OpenFileList[%02d]:
        *** SharedCloseList:
   *** SharedCLoseList: <is empty>

       There are a total of %d files on the SharedCloseList

  *** SharedOpenList: <is empty>

        There are a total of %d files on the SharedOpenList

   PWVN$OPEN_FILE_CACHE_VIEW.TXT   %3d %7d         %0xh             %0xh         %s         %0xh            S.No  OpenCt   Intern.Flags,  FileAttr   NWOpenFlags   LMOpenFlags  VolName   DOSfileName
     Open File List 
        Open File List for this client is empty.
       %s is not defined; FS uses default %d
  %s is not a multiple of %d; FS uses %d
         %s has been defined with value %d
      %s is greater than max value(%d); FS uses %d
   %s is less than min value(%d); FS uses %d
      PWVN$CACHE_BUFFERSIZE   PWVN$TRUNCATE_DISKBLOCKS        PWVN$EXTEND_DISKBLOCKS  PWVN$ALLOC_DISKBLOCKS   PWVN$CACHE_FLUSHINTERVAL        PWVN$CACHE_FLUSHRATIO   PWVN$CACHE_NUMBUFFERS   Error unlocking OpenFileSema
   Error locking OpenFileSema
     PWVNError: Close of file %s failed with code %d
        OpenCreateFile: Error returned from PLM_fileunlock - %d
        OpenCreateFile: plmLockFlag set when opening a file on a shared volume - unlocking
     OpenCreateFile: PLM_filelock failed - %d
       OpenCreateFile: Incompatible open mode requested on a shared volume
    OpenCreateFile: PWVN_getFileId failed - %d
     PWVN$VOLCONF.SYS        NW$BLD_ROOT:[NW.SERVER.SRC]FILE.C;1     WARNING: CloseFile has found duplicate copies of shared open file [%s line %d]; continuing...
  flush on deferred close         FSIDeferredCloseFile: Error returned from PLM_fileunlock - %d
  PWVN$DISABLE_LM_VERIFY_MODE = FALSE, enabling LM mode check.
   PWVN$DISABLE_LM_VERIFY_MODE = TRUE, disabling LM mode check.
   PWVN$DISABLE_LM_VERIFY_MODE      error allocating CACHE memory
                 Accepting volume #:%d, FS-Type:%s, Path:%s
     AddDeviceToVMSList      Ignoring volume - Unsupported FS-Type:%s, Path:%s
      FSIVolumeSetup: error returned from PWVN_getDevId %d
   FSIVolumeSetup: setting up a shared volume
     FSIGetVolumeInformation                 VMS volume-list is being setup...
      No memory for ClusterServerNamesList
   VMSVerifyAces:  Pathworks ACE too big
  V                    %      &             DECCacheWrite: error returned in iosb nba       DECCacheWrite: error from pwn$qiow nba  DECCacheWrite: threadqiow (nba) returned error in isob  DECCacheWrite: threadqiow (nba) returned error  DECCacheWrite: threadqiow returned error in iosb        DECCacheWrite: threadqiow failed        DECCacheWrite: error returned in iosb   DECCacheWrite: sys$qio failed   DECCacheWrite: failed to malloc iosbs   DECCacheWrite: Erase failed (iosb)      DECCacheWrite: Erase failed     DECCacheWrite: no bdscs on we   DECCacheRead: threadqiow (nba) returned error in isob   DECCacheRead: threadqiow (nba) returned error   DECCacheRead: threadqiow returned error in iosb         DECCacheRead: threadqiow failed         DECCacheRead: error returned in iosb    DECCacheRead: sys$qio failed    DECCacheRead: failed to malloc iosbs    DECCacheRead: no bdscs on we    VMSGetRootCreateDate    VMSOverWriteFile erase iosb     VMSOverWriteFile - erase status         VMSOverWriteFile        VMSCreateFile, dassgn   VMSCreateFile, deaccess         VMSCreateFile, qio erase, iosb  VMSCreateFile, qio erase, status        VMSCreateFile, qio create, iosb         VMSCreateFile, qio create, status       VMSCreateFile, assign                                                            VMSAllocateDiskSpace (erase - i)        VMSAllocateDiskSpace (erase - s)        VMSAllocateDiskSpace    VMSWriteFileAttributes, acl status      VMSWriteFileAttributes, iosb    VMSWriteFileAttributes, status  VMSWriteRecordAttributes                                                           VMSDirectoryReadAhead   V                               %      &                    VMSUpdateDOSNameSpace   V             #                   V        	                  %      &             V              	                                           %      &             VMSReadFileAttributes                                  %      &       	            V                    RMSResumeThreadAst: Invalid Thread Pointer
     RMSResumeThreadAst: Invalid RAB pointer
        RMSGetAnotherRAB        RMSGetAnotherRAB: stv = %d
     RMSFlushRecordFile: Error (%d) doing flush
     RMSFlushRecordFile: Error (%d) starting flush
  RMSFlushRecordFile: Error getting another RAB
  RMSTruncateAppendFile: Error (%d) during sys$put
       RMSAppendAST: Error (%d) during sys$put
        RMSAppendRecord: Error (%d) starting sys$put
   RMSCreateAppendFile     RMSCreateAppendFile: stv = %d
  Error : RMSFlushList entry not found
   Error : RMSFlushList Full
      RMSWriteRecord: Error (%d) during sys$put
      RMSReadRecord: Unexpected completion status from SYS$GET (0x%08X) reading %s
   RMSReadRecord: Timeout reading %s
      RMSReadRecord: Unexpected return from SYS$GET (0x%08X) reading %s
      WARNING:  Possibly invalid record lock is about to be taken out
	RAB = 0x%08X, recnum = %d
     RMSReadRecord: bad rcontext argument, rabptr == 0
      Bad postfix count %d
   Bad prefix count %d
    
SEEK FAILURE !!!       RMSDisconnectFile               ERROR: Can't read disk quotas; status = %08X
   
<------------------------------------------------------->
     
  [...Authorize utility, upon the 'startup username' acct.]    
  [The remaining are tunable via the OpenVMS...]       
  [A few, such as BYTLM, are built into the server.]   
  These are kept in file PWVN$CONF_DIR:PWVN$NWCONFIG.CFG       
  Key resources and quotas are tunable, via the SCONSOLE utility.      
  Thus, remaining privs in effect are:
%s      
  [Examples are READALL, EXQUOTA, and possibly others.]        
  [This is necessary for proper server behavior.]      
 Note: Some process-privs are intentionally bei                                                                                                                                                                                                                                                   ?                        J $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        _ "     $      ng disabled.    
  [Thus, that USERNAME is termed the 'startup username'.]      
  [This was the USERNAME in effect during startup.]    
 Username: %s is ultimate source of quotas and privs.  
This process has the following attribs/quotas/privs:   
<------------------------------------------------------->       %s; code : 0x%X
       %02d/%02d/%02d %02d:%02d:%02d   GetFileServerNameLock   Got lock %s with status %08.8X
         Lock timeout after %d seconds on %s
    PWVN$MAX_LOCK_WAIT_SECS         Lock %s in use. Waiting.
       Ready to get cluster control lock %s
   PWVN$CLUSTERCONTROL     **WARNING ** VMSVolListPtr is retuning NULL;  cid = %d ; VolNum = %d 
  VMSClearProtection: Error (%08X) returned in iosb from pnw$qiow
        VMSClearProtection: Error (%08X) returned in status from pnw$qiow
      VMSTryAcquireMutex            V             #                            %      &             VMSProcessAction                               %      &             PWVN blocking lock              CMKRNL  CMEXEC  SYSNAM  GRPNAM  DETACH  LOG_IO  GROUP   NOACNT  PRMCEB  PRMMBX  PSWAPM  ALTPRI  SETPRV  TMPMBX  WORLD   MOUNT   OPER    EXQUOTA NETMBX  VOLPRO  PHY_IO  BUGCHK  PRMGBL  SYSGBL  PFNMAP  SHMEM   SYSPRV  BYPASS  SYSLCK  SHARE           READALL         ALLSPOOL        DIAGNOSE        The following privs are required, but not present:
     PWVN$DOING_INSTALL                                       	        
    
           PWVN$CONF_DIR:MBXCFG.SYS        SHUT THIS SERVER DOWN           1-SEP-1993      DIAG_VM<error freeing %d bytes of memory at 0x%08X, status = %d>        DIAG_VM<guard word after allocation 0x%08X overwritten with 0x%08X ='0x%08X'>   DIAG_VM<guard word before allocation 0x%08X overwritten with 0x%08X ='0x%08X'>  DIAG_VM<attempt to free 0x%08X twice, data corrupt, or not allocated>   DIAG_VM<error allocating %d bytes of memory, status=%d>                 LNM$SYSTEM      PWVN$PROCESS_%08X        
                                         MRB                                         MRB                                         MRB                                         MRB                                         MRB                                         NCPMoveFileDir: ConvertTokenStringToCString() failed :          MRB                                         MRB                                         MRB                                         MRB                                         MRB                                         0x%02.2x from %s of DestroyNWQueue
     ShmDeleteNodeSLList     MRB                                         ConvertTokenStringToCString failed;     MAX_PATH_LENGTH MakePathString() failed after %d due to %s in:
%s
      total too long                                                                                                                                            	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       program bug     too many separators     element too long                invalid character       MRB                                         0x%02.2x from %s in LMAgeLogicalLocks
  ShmDeleteNodeSLList     0x%02.2x from %s (%d) of CheckLogicalLockPendingEvents
 ShmDeleteNodeSLList     0x%02.2x from %s of CheckSemaphorePendingEvents ShmDeleteNodeSLList     0x%02.2x from %s of LMAgeSemaphores
    ShmDeleteNodeSLList             0x%02.2x from %s (%d) in CheckFileLockPendingEvents
    ShmDeleteNodeSLList     0x%02.2x from %s in LMAgeFileLocks
     ShmDeleteNodeSLList     0x%02.2x from %s (%d) of CheckPhysLockPendingEvents     ShmDeleteNodeSLList     0x%02.2x from %s of LMAgePhysLocks
     ShmDeleteNodeSLList     MRB                                         MRB                                         Status 0x%02.2x from ShmDeleteNodeSLList in DeleteAllDynamicValues
     0x%02.2x from ShmDeleteNodeSLList of DeleteAllDynamicProperties
        0x%02.2x from ShmDeleteNodeSLList %d of %s
     DeleteDynamicObjectFromCache    0x%02.2x from ShmDeleteNodeSLList in DeleteDynamicProperty
     MRB                                         0x%02.2x from %s (%d) of StartupTrustee
        ShmInitSLList   MRB                                         MRB                                 0x%02.2x from %s of StartupFileStructs  InitFileBitMap  ShmInitSLList   ShmInitSLListBlock              MRB                                         MRB                                         MRB                                         MRB                                         MRB                                 MaintainClusterServerNames failed: ShmAddAfterSLList 0x%02.2x
          MRB                                         MRB                                 Unexpected status %08.8X %s lock %s, stage %d
  Unexpected status %08.8X dequeuing lock %s
     Ready to get long term fs name lock %s
 MRB                                                                                         
                                                                                   syscfg.sys                                                                                                                                                      d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           DOS     Primary Data Stream.    MACINTOSH       Macintosh Resource Fork.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            SYSTEM  SYSTEM/SPOOL.SYS                                                                                                                                                                                                                                                                                                                                                                                       @                        42 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     5                                                                                                                                                 0   `   0  `                                                                                                                      @(#) qsetup.c 1.1 11/27/89 15:59:55                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
 	
HFg=捷z&Z5kpGܧP                                    	

  	


 
		

 
 	


 	
	
  
		 

	
 

	 
 
	
	 


 
	 	



 	 
	 
	
	   	
 


	
				


 
 	


 	
	 



	

 	 
 	
 

	
  



                                                                                        
   /   a      K  #        I                                                                                                                                                                                                                                                                                                                           @                                                                                                                                    @(#)lockmgr.c 1.33 7/17/89 11:33:51                                                                                                             PWVN$CONF_DIR:PWVN$MSGS.DAT                                         @                                                                                       nbes    nbed                                                                                                           @(#)propops.c 3.2 9/7/90 18:18:58                                                                          @(#)bindops.c 2.5 8/23/89 12:30:47                                          @(#)bindutil.c 3.3 9/6/90                                           *?"/\[]:|<>+=;,                                                                                                      @(#) proputil.c 3.1 8/14/90 15:58:35                                                @(#) bindInt.c 3.1 8/14/90 15:58:04                                                 @(#) propInt.c 2.4 8/28/89 16:22:15     3D211112"2211@22413311112                                                   @(#) bindsetup.c 3.1 8/14/90 15:58:11   NET$OBJ.SYS     NET$PROP.SYS    NET$VAL.SYS     RMS$OBJ.SYS     RMS$PROP.SYS    RMS$VAL.SYS                                                 @(#) bindmisc.c 3.1 8/14/90 15:58:06       ; Z x     0N                                                                                                                                   RMS_T_FILE.SYS  SYSTEM/T_FILE.SYS                                                  RMS_T_USER.SYS  SYSTEM/T_USER.SYS                                                                                                                                                                                       RMS_T_DJNUMB.SYS        T_DJNUMB.SYS                                                                                                                                                           SYSTEM/T_DNODE.SYS      RMS_T_DNODE.SYS                                                                         `j j         j     0k j    `j Pj 	  j Pj   Xj Pj    j Pj   
 j Pj @  j Pj    j Pj                                                                                                                                                                                                                                                                                                                                                                                                                                    n n   n n                  @                                            G 
 G                Account has expired on server %s. Logged out.   Supervisor has deleted your account with server %s.             Account balance exceeded.       SYSTEM/NET$ACCT.DAT             ACCT_LOCKOUT    Account balance exceeded on server %s. Logged out.              ACCOUNT_SERVERS    `                 ./srv_agent     NWServiceAgent                                                                                                                                                                                                                                                                                                                                                                                                  p       8 P p        @ P         OBJ_BACK_LINKS  ACCOUNT_BALANCE                                                A @ PK  x  x  x  x  x  x  x  x  x e  x 0M p O e `d pK @ J I  : 9  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x h@  @ ? ? ? P?  ? > > > 0>  > = @=  =  < ; @; : ; :  u `: < < < `<  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x pT  x  x  x @n n m m `m 0m  m l l  l i k k k `k 0k  k j j j Pj  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  3 2 2 P2  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x @d c c c Pc  c  x  c b [ XJ `b  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x L  x  x z  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x BLOCKS_READ     BLOCKS_WRITTEN  ` P! `! % % `& ( ) ) * +  + + / / 3 3 3 3 P: `: p: : : ;                                          Digital         CONNECT_TIME    04/05/98                                                     /dev/console                                                                                                                                                                                                                                                    SYSTEM/SYS$LOG.ERR              PWVN$CONF_DIR:  SYS                             (9 8 @q `s r z y  x  x  x @8 7 u  v  v p7  x  x  4 3 3 z `3  x  x 6  x  o o o pr 6 `N 0N M M M 5 t pt 0r `M 0t s py 4  4 f Pf e  x     DISK_STORAGE                   _ c      ` p   p    L ` 0   :   0 EVERYONE         0  `  F                                          ACCOUNT_HOLD    HOME_DIRECTORY  .hpfsres        VMS account (%s) disabled in UAF                                                                                                                                                                                                                                                   A                        W: $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        y "     F                      Invalid default directory specified in UAF      User name or UIC mismatch (Netware:%s, VMS name:%s)             Invalid connect time on server %s. Logged out.                                                            LOGIN_CONTROL   .macres         MANAGERS        GROUP_MEMBERS    0       @  P ` P] \ \ \  x  x  x  x  x `\  x     GROUPS_I'M_IN    x  x  x PW  W V V U U X X PX X W W  x  x PU Pz ` 0b U T T Pa ` @Z  Z Y Y `Y Y 8T a S  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x N S q q  q S  S  S R pR PR 0R Q pQ @Q Q P P  x hP  x  x  x  x R O  x  x  x  x  x  x  x  x  x  x pT  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x w  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x NET_ADDRESS               NODE_CONTROL    (C) Copyright 1989-1992 Novell Inc,
1992 Digital Equip Corp All Rights Reserved `    @    p                    H            P         
           X    (    8    P 	   ` 
   p     \                                          0    @    P    `    p                      !    "    #    $     %    &     '   0 (   @ )   P *   ` +   p ,    -    .    /    0    1    2    3    4   ( 5   @ 6   X 7   p 8    9    :    ;    <    =     >    ?   0 @   @ A   P B   ` C   p D    E    F    G    H    I    J    K    L     M    N     O           PWVN$CONF_DIR:PWVN$NPSCONFIG.CFG                                                                                             NetWareFileSrvr ./ncp_engine    NWEngine                        OBJ_SUPERVISORS OLD_PASSWORDS   OPERATORS                       PASSWORD               p P               0 P                x _ ^ P^ ]                             0 Q    P    R       0 S   @ S   8 U   @ U   X T   h V   x ^    ^   H b    c    d    ]    ]    W    W    X   P X    Y   X Y     Y   ` Y   0 Z   @ Z   h [   p [   P [   ` [   p _    _    _    `    `    a    a     g   x g    g     e    e   0 e   @ f   P f   h f   x h    h    i    i    k    j     j    j     x   0 x   @ x   X p    p   h p   x q    q    r    r    t    s    s    s    s     l   8 l   H l   ` l   p l    m    n    o    o    o    o    w     w   8 w   H y   X y   h y   x y    z    z    {    |    }    ~     ~    u    v   ( v   8 v    v   H    X    h                                                                                              PWVN$CONF_DIR:PWVN$NWCONFIG.CFG ./ptr_server    | P|  x  x  x  x  x  x  x  x  x     D     E      D    D    D    D    E     D     E @   (D    0D    8D    @D    HD    PD    XD     `D  @  hD    pD    xD    D    D    D    D     D   @ D    D    D    D    D    D    D     D    @D    D             NWPrintServer   i i i h  x  x  x  x  x 0h g                                                                                 Q_DIRECTORY     Q_OPERATORS     Q_SERVERS       Q_USERS                                         REQUESTS_MADE   PATHWORKS V1.0-611F for OpenVMS (NetWare)       $$salv$$.db     deleted.sav     $$%4.4d$$.$$                                    ./sap           NWServerAdvertiser              pnw_stats       SECURITY_EQUALS [ P[ [ Z Z  x                                         SUPERVISOR                                                               w w `w @w  w  w v v v v Pv     ALERT:  Write failed on file %s. Check disk space.               x x         RESERVED.SPC                    *                                                                                                                                                                                                                                                                                                                               p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k0 #0?#8  ^.#   "( [ ^  @  ~P @( 0 @0 4`J8 ޴37aJ@ 5WH  :6 H` [ C  ~ C ^tB  7ssB B` @G  ۤ B  @  @ @GGh { CGtGLZk   G G  &N@ =GP B  #  G@ bX b B  G  &GpRZk D GG ] ]  }( 0 8 ݤ@ P #k#dC  ^ C@ [dC( ^G0 G  ~G GH {GGG[MZk   G 0 BC8 bGCCtGEZk ] @   G G G  ]( ]0 @ #kG#tG ^G  ^( ~0 8 G  ~G( {G ~G4GAD =tG
    CGG =DB `bGFA   G ]  ]( }0 8 @ #k# C^tGG^ ~(0G  ~G >G ^4G8 {ADG `CbG4GJAG C G( b4G˗A0B CGgZk =@    .wHVJF  >G] G] }(0@#k .
HV
JF >* @ 1@B!u @    .u0J0 Bw2JT J0@BF  >  .u!J0 @0`BV JF  >w3J  .2q @2@B  @T JF  >0 @  .V JF  >_	    .s0JG 1 @U JF  >0 Bk#@ ; &( ^0 ~$8 G  ^ "G   C  ~C =G   ; 8 {5wJ # =GGTGZ^C8 D
  G`b#G" CGTGQ,@ӰBbG4GSZkG b x b C4GcC 8 D  b4GG`b#c  C=,@ӰBbG4GSZkBD@ _&` bG  TG R"GGGtZk C
 `"GG`b#TGX!  C!,@ӰBbG4GSZkBGb4GDZkP BX bGEZkG  ]( ]0 }8 @ #kp#{  '^?&^p[# ~ 1"(4G08޴@HP>X^`~hpx޵[G=   ~h=>CGl CGZkx b8" C C
  /ByJXKG  ? '~Zk&"-# CGG0_='H9# CGG*_Bh}# Cb4GZk8 DXB  `bG4G[SZk(b#@b#@G@bG{bCGbG_C  XBG`b4GISZkb#@("b# $   _%@"hb#
4G  G9@4GG@ ]GH ¤ 4G ] 'B?"" =U@G  _&( "8TG@TGX{#GP    C  }GH   ?%   'X #` ]TGh }Gp x  =?#   0HP`p]tH~Zk= ¥4G C ¤B  G  /  & ]t~Zk "
#B CGn~Zkx=#B C4GGg~Zk	G  0. DbQ 0J  0>=" C	A D  h"G CbtG@!  CTGGAXB`bG4GRZk" CG4G  Gb#F_   =!v H  08 D4 D  0GGPb4GIC^  h"4GGb#!  C+@hG4Gb#   C
+@h4GGb#   C+@hG4Gb#   C*@h4GGb#P   C*@hG4Gb#   C*@h4GGb#   C*@G [@b#G4G*@hG4Gb#   C*@h4GGb#P   C*@hG4Gb#   C*@h4GGb#    C*@G [@b#G4G*@XB`bG4GTRZkB4G"h"  
  G1"7 @b#  F%   C*@  JTGhG11@Ab#
G   C*@GHJ!b# C4G*@hB4GGb#J! C*@hBG4Gb#J! C*@XBG`b4G#RZkBG4Gb ?"  
TG 8 D  _CG b
GGG4GtGA D  GbtGGTG˒AXB`bG4GRZkG b C4GAGGb4GA D  GG@b CGtGTGGAXBG`b4GQZkG  b CG4GtGG\AG b C4G
AG]" 0 bC0  CGtGAB "  C                                                                                                                                                                                                                                                   B                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        a "     W       C|Zk
  G" b CGGtG=A DG G4GGbG4GA GbtGGTGqAXB`bG4GQZkG b C4GA Dh  Gb C@  CtGTGGZAXBG`b4GQZkGx b C4GA D  h"G CbtG!  CTGGCAXB`bG4G|QZkG C0bGtG4GtGAG C bTG4GtGAӈ G4G b4G CtGAGbtGtGTG!AG0bGICG0b CG4GtGrAӀ GG4G0btG CjA D  E#? ~  .q%HPJF  >CGTG _"Gb#_ $    =	@    G  =CGs1B  uG4G4Gb#_ CG4G4GGb#_ CGG4GGb#z_    =B   H bGTGb#GTGm_  H "4GGGbG  AAB  tGőAH G   G C0bTG4GtGAG0b CtG4GtGAG C0bG4GtG	AGC0bGTG4GtGA D   GSAAE  =X=" C4GGb#Z_P  CGGb#T_! CGGb#N_  ݥGtGbG.vITG8E  ݠ4G8D {AӨ (  CGGb#8_! CGGb#2_! CGGb#,_G  b CG4GtGA D  G Cb4GACGTGGGb#_CGtGG4Gb#_
  h A
 GbGtGTGGG?AGh  CGtG4GGb#_
  X ݡA
 GGbtGGGG*AGX ݱ CGtG _"tGb#_  x  @? /@
  GGbtGG @"GA @!x CGTG _&tGb#_`! CGGb#_8! CGGb#_@! CGGb#_ ! CGGb#_0! CGGb#_ ! CGTGGb#_   =GGbTGW&@  GtGGڐATG G  CGG4Gb#l_    ?%GbtG%A  GTGTGGÐA =G =8b#n@G CG4GTGb#S_   =tGGGbG@  GtGA G +H CG4GGb#=_   tGGGbTGW@ GGATG G ,I CGTGGtGb#%_
  H tGGGbG@ GG}AGH  G C bG4GtG-A  D G= b C4GAG  b CG4GtGA  BU@ CG{ZkG Cb4G}AH! CtGGb#_GC0bGG4GtG
A D  G   TGFYB   ] ðB  G CGG0bG4GtG
AGC bG4G>AG 4G` bG@A "G C  4Gb 8 D  *
AGGb4G_A D  GG@b CGtGTGGAXBG`b4GAOZk 4G "G C bG4GtG
AD  G4G4G "G CGG b4GtG
AG_DGb4G+?"TG\C G  hGGb+"" CtGGӏAXB`bG4GOZk ݠ4G CG).)& bqHP J F)> C
A ݠG 0 bCP@0 GtG+A  ݠ""B C4G2 &,2  A  H2 &<G P ByZk  G  b\C ݰ  CGG0 bGP@tG
A ݠ0&,A &H0&< .P..0"R QJ.P> },.,"U J,> ݢ*/*"X K*? =(y/[ yK(y? *,*  F H*<GG=" C0 bCGtG
AG C0 b]" CG( ݰG CGtG
AG p b  C CTGQ@C
   =CGG0 btG0!  C
AL h" G Cp bTG!  C=@C
   =CGG0 btG.!  C
A8 G " p b C CTG*@C   =GC0 bG,!  CtG
A% GG " p b C CTG@C   =GC0 bG*!  CtG
A GG X" p b C CTG@C   =4G(A.sJR AJSF(A>E qFpF  WJ  W Cv  =Gb#P&C4Gb'@  CG   ݠ`" b CP@P@tGG4GGAG4G ! bv?A ݠ CB4GP@G+yZk$   =	"B CP&@GyZkG ` bQ?AG =TG bA>A D
  h¥G CbtG! CtGGAG 4G bL?A GGTG = @bN=A Dh¥	  Gb C! CtGtGGA  G CG4G ! CGGG btGOAD GGbG-vI4GG@ AG!b C4G
A DG  b CGtGTGGxAXBG`b4GMZk G  b CG4GtG$A
D G4G4G|!G Cp! CmG¥GG4Gb  
8E eAG bG4GZCG
  b CG4GtG A DG  b C4Gg	AӘG4G b4G CtGA D  Gb C4GX	A Cb#	@
  G CbtGGtG%A  -M I  =G]! b CG4GtGA  GG@bGtG4GGGAXBG`b4GIMZkGCb C CGGtGB  G
G@bG CtGTGGGAXB`bG4G0MZkG! b CG4GtGA   CGGb#_
CGGGb#_CG4GGb#_G]!b C4G
AGx b C4G
A  O- OI @	ݤD G G@bGtGTGGGAXB`bG4GLZkH B4GGxtb#  
@CpGb#@8 Hb#b@8 ݠ GG4GPb &.  .HrHQ&JPJ3FF &>  >8 [
A¤G ?&8 4G  ub# D  @  G4G8  4 Dlb#  @  G4G8  D`b  A  GCbG T D  4GA Dh"  Gb Cp!  CtG4GGjAGG@bAXBG`b4GLZk =G4G +v`IPbp @E )AG 4GbxAG Cxub#G4G@G C0ub#G4G@G4G b"AG CpbG4G"AGb C4GAG Cb4G1AGC bG4GQ"AG 4G0b`AG Cb4GsAG b C4GAG4GH bAG 4GPbAG4G bAG 4GbA8}4GG@b#fHfHaA@}G4G b#fHfHA@}TGhG#fHb#@  fH C$@ }4GG b#fHfHA0}G4Gb#fHfHAG C b4GA(bG4G`bGgAӰG4G`bGAӨbG4GbG AӸG4GPbG] A`}G4Gpb#fHfH!AGGb4G!AGbG4G!AX4GGb%HH AP}G4Gb#fHfH AH4GGb(II A =G4Gb	?E C!AG4G@ b9!AhGTG@ =!b# C/$@Gx 4Gb!A84GGpbGAG C@b4GaA(}G4G0b#fHfHAG4Gp PbAG=!b C4GAG4Gb%HHFAG4GX b1"A}G4G`b#fHfHb"A4GG@b(II"A =G4G b)&I&I#A 4GGb%HH7#AG 4Gb,"AG4G b!AG 4G0b!AGtG`b4GAGb4G4GAGTGb4GAGbG4GAGGPb4GAGpb4G4GAG4Gb4GAGpb4G4GAG4Gb4G
AGb4G4GAG4Gb4G/AG8 4GbAh4G  G b#D   C#@Ӱ } CGtG =  pbp`@A  &G C8 =TG'E`b  `A   CGTG8 =E  Pb&AӨ"  4GG  ,DHb#G H  <$    C@ D6  B C C
vZk  B%! C CvvZk" CGtGbGGGA}$ %c! CGgD `_C	GG_GbGtGGGA%h CG̤( C!b# C'F `tG/#@ =%G}$b%vH	-,)!8D-	IG
H,c EI@
H4GE CA$G4G-%-ѥ bII
%I	E CA$G4Gg,- pbgHO
IoD CCA$G4G-%-ѥ bII
%I	E CA}$G4G,-c bHO
ID CρA$G4G-%-ѥ bII
%I	E CA}$G4G,-c bHO
ID CA$G4G-%-ѥ bII
%I	E CEA}$G4G,-c bHO
ID CA$G4G-%-ѥ  bII
%I	E CŃA}$G4G,-c bHO
ID CQA$G4G-%-ѥ  bII
%I	E CsA}$G4G,-c  bHO
ID CA$G4G-%-ѥ @bII
%I	E C-A}$G4G,-c bHO
ID CA$G4G-%-ѥ bII
%I	E CA}$G4G,-c bHO
ID CiA$G4G-%-ѥ 0bII
%I	E CyA}$G4G,-c @bHO
ID CA$G4G-	%-ҥ PbII
%I	E CA}$G4G
,
-
c bHO
ID CkA$G4G-%-ҥ bII
%I	E C{A}$G4G,-c bHO
ID CǇA$G4G-%-ҥ @bII
%I	E CCA}$G4G,-c `bHO
ID CeA$G4G-!%-ҥ bII
%I	E CшA}$G4G",%-"c bHO
ID CA$G4G&-)%-&ҥ bII
%I	E CA}$G4G*,--*c bHO
ID C3A$G4G.-1%-.ҥ pbII
%I	E CUA}$G4G2,5-2c bHO
I                                                                                                                                                                                                                                                   C                        j $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        @ "     h      D CuA$G4G6-9%-6ҥ  bII
%I	E CA}$G4G:,=-:c bHO
ID C	A$G4G>-A%->ҥ bII
%I	E CGLAG4G8  ! bGm~A  h4GGD  G b# Cx!@xb#@G=!} 8  b C CtGkB  G   4GE` b   A:AG }  b CTG~:A DG	  b C CtGTGGAӠb#0@  B C4G ! CsZk  G bE:A D-  G  CbTG]:A D$ G4G G@b%A DG   b CGP@tGtGGAӠb#@ =%B! C	P AG8tZk =$B!  CP@G0tZkG4G ` b9AG  CbTG+:A D
  hG CbtG  CTGGYAӠb#G@  CB4GPAGsZk.   =Gb2 ,2 ) G H	G@%  x%A DG	   b CGPAtGtGG8A0 A ) IB A	 Cg@I)A$ @H  @@PAGGsZk ݢB@GPBGsZkG4G b9A D  G  CbTG9A DG 4G` b9AG C TGb9A Dh  Gb C! CtGTGGAӠb#|@ 4GGb2 ,2 %! H  9A DG3   b CTG9A D+ GG4G 	G@b%A DG	   b CGP@tGtGGЈA0 A  AB( Ig@ CHA=% @H)!'A@PAGGsZk =B@GP&@GxsZkG4G ` bG49AG C TGbr9A  G 4Gb9AG4G bG9AG4G 0b:A	! Cb#@G bGB D  h"G CbtGx)! CGGAӠb#	@  d,GGtGbGCdHTGeD  d<yAG8 4Gb A D
  Gb C CtGGGiAӠb#@G bGB D  hG CbtG`! CGGWAӠb#@h  &  G4G0 b##E  f C@G4G8 ! bd7B DG	  b C CtGGG:AӠb#@h" !  4GGG)!b#D   C@G4G8   b@ DG  b C CtGGGA   @! B C bGD  tGTG`Zk  C0 
 C(  G0 GG4Gb  /-I /I  /=+AtGH `bGE@ CG4GGGWA0 }t= D B0@0`@ bD0 }Gt=tGTG`Zk  C
G0 GH} tb CTGBAh4GGb#	G  Cz@G4G8 Gb)!WB  G Cb#4GD  k@G8 4Gzb# E@ D
  Gb C CtGGGAӠb#9@  G   8 4GE8qb#   ?%#@  G )!8 4G	Eb  !A D
  Gb C CtGGGAӠb#@   $b#D  f@  hX! C h0  CGb#4G'@Ә"B$H  CG<rZk%p$h"% }$|=$e=' ݠG$ҍ$H ݢGxd)!  CG !ٲ4Gk!b# @G%
b#H! C4G@GG b&CG4G  
xtb#@XB`b4G4GVZkGGx/b#X@GGbBG Cb#4G@ b#@b#@ D8 DG	 b C CtGGG*AӠb# @GGbAӘtGGGbtG CAhb#>@  Ρ4GhG8Eb# G! C@GbGc xBGGpbBG4GPb4GS=C D  Gb# C4G@Ӡb#| @GC`b CGGGGGNA Dh¤	  Gb# CX  CTG@Ӡb#f @GG TGPb=C Dh"  Gb#4G0)! Cw@Ӡb#U @(B0bG!|Zkh  CB4GGG !b# C  
e@Xb#@Gb C4GVC 8 DG   b# C4GV@Ӡb#4 @hb4GGb#k! CM@Gb#G@G]] }(08ݤ@HP=X]`}hpxݥ#k /
JX
KG ?M .
%HP
JF >| F  d,GC
dHeD d<#x ;4G ^ ~  h  ( G  ~G ^ C    Q.Gs1Hh!b#4GRQJSF  Q>@GG:b#W@GGp b4GAbGTG@ bG CtGSAG@ b CtGGtGLAGGb#J@ӈ 4GGTG0 b     @ӈ4GGTG0 b     @Ӏ 4GGTG0 b     @GGb#4Gc@GGb#4G  \@G4Gb4G|BG` bG@b#_@pb#+
@     De     Di     ?   Dm     P Dq      Du     ?   Dy      ?   D}     D     ?   D     ?   D     ?$ !   D     @?   D    H     D  GG bA4GGh!b#@   C}@  GGPbH A CGTGh!b#  Cn@GG bTCGG`bD@Ӹ B4G b4GDZkG ] ] }  ( 0 #kG Q.
1HR
QJSF Q>AGGb
A   DGP bG[!A   ?   DG bG7B   P DGG bA    DG bG{A   ?   DG0bGYzA    ?   DGbG@   DGG bUB   ?   D{GG bA   ?   DwGGbBrGGGh|b#J@   @?   DrGGpb@  HnG bGA   DjGG xb#@eG# C ^4GG  ~ C  G@|{#^@ = G !. .HrHQ!JPJ3FF !> > ]  0 #kG#X4G ^G   ^ C G  ~Gb#@G  "8tb#4G4GGGGe@G ] ]   #kG#tG ^TGGTG  ~ {GAG ]   #k#  ;( G ^GG ^ ~  G  ~G   G  A8 {GuA D  GI@Hb CGtGGGG݄ABbG4GDZk  CG@ BG4GqZkG ] ] }  0 #kG#& ^  G ^   [ "  ~# G8  C{tG  _&  GGG	eZk C  GD@bGtGtGGGA GB4GbtZkG ] ]  0 #k#& ^(    G ^	 "8[G  ~#  C  TG@{ _& G  GGdZk CH"  GbtG!  CtGGGvA G(B4G0btZkG ] ]  0 #k#G G  ~G ^G
BGA CG0 CnZk
  ."?C C?G ]  G  #kA CCoZkG ]  G  #kGp[GGG CoZkS @   GGk  . A#0 @PJJ,  B=B A# D	    !.0 @P:JJ"  B=B D  9B]BFQG   F `F  F
 @8F   F	 `F  xF @F  xF `	    A/  0 @P@KJ 4GGk GGk#0^8~@ @HG  ~G(^GG  0  G0 BCG CnZk    B C( bGGTG\ZkP B CX bCGGTGNZk = @"" 4 @GR HXbC 0D?@@D_1"H@ CGtGGGǃAb#I_  G(]0]8}@HP#kG@#  '  ~^-#^~޴   ,G>CG H 8 DG  C8bG4GA8 = G C b4G v H A  B ( b!X@ b CG CGwZkG$b#H   C4G@ B D=  b@ C?"_"tGlxZk4 @ "~   B"( b1"G C CTGwZkB  C CnZk0 B8 bGGtGAZk "  B ( b C!  CTGwZkB  C CnZk0 B8 bGGtGAZk "  B ( b Cx!  CTGwZkB  C CnZk0 B8 bGGtGAZkG CbG4GA "  B ( b C`!  CCtGwZkB  C CxnZk0 BG8 bGtGAZkG CbG4GAP C¤4GH 0 H  HPB  BA%@( bP H  pD  Ap H  ޶א H  H @#G CrwZk "   B C( bC(!  CtGhwZkB  C CCnZk0 B8 bGGtGSAZkG CbG4G@P  C  B4G0 H( b HFBA%@  fP H  ADp Hא H  ޶G  H @#G C>wZk  B  ( b C C CGtG4wZkB C CtGnZk0 B8 bGG AZkGCbG4GAGC(bG4G&AGC bG4G6AX ="`  Ch ݤG "?D  B DD( b
1" C C C CwZkB  C CmZk0 B8 bGGtG@ZkGCbG4GAӀ  "   B C%vH( b
!  C CtGvZkB  CmZk0 B8 b CGGtG@ZkGChbG4GAx ݤ  " C  BtGD( b
!  C CvZkB  C CmZk0 B8 bGGtG@ZkGCh bG4GA   B p ] C
  ( b CtGvZkB C CmZk0 B8 bGGtG@ZkG@  b C4GA "  B @ ] C`
! ( b CtGvZkB  C CrmZk0 BG8 bGtG@ZkG Cx b4GA   B @ ] C@
  ( b CtG}vZkB C CYmZk0 B8 bGGtGi@ZkGb C4GA "   B C@ ]tG 
! ( b CdvZkB  C C?mZk0 B8 bGGtGO@ZkG8  X b C4GA8 G Cxb4G v H 8 D  tA "   B C@ ]tG	! ( b C@vZkB  C CmZk0 B8 bGGtG+@Zk8  b" @ "  B v H( b=" 8 DD	s" C C CtG%vZkB  C C mZk0 BG8 bGtG@ZkG Cb4GA8  b" @ "  B v H( b=" 8 DD	s" C C CtGvZkB  C ClZk0 BG                                                                                                                                                                                                                                                   D                        x{RD $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     y      8 bGtGZkG C b4GA8  " @ "   B%vH( b"8DD	1" C C CtGuZkB  ClZk0 B8 b CGGtGZkG CbG4GAH =  " C  BtG D( bp	1" C CuZkB  C ClZk0 B8 bGGtGZkG b C4GA    B C@ ]tGH	  ( b CuZkB C CtGlZk0 B8 bGGZk "   B C( bTG	!  CuZkB  C CvlZk0 BG8 bGtGZkG C b4GCyAu].@ r= r=.  RAJH  BsH( bQ!JTF3Fu]>"r=> C CGtGuuZkB  CQlZk0 B8 b CGGtG`ZkG Cb4GxAy}.@ v="v].=  ¦SqJH  BtH( bRQJuFTFy}>"v]> C CGtGOuZkB  C C*lZk0 BG8 bGtG:ZkG Cb4GxA}].@ z= z=.  RAJH  BsH( bQ!JTF3F}]>"z=> C CGtG)uZkB  ClZk0 B8 b CGGtGZkG CHb4Ge{AӁ}.@ ~="~].=  ¦SqJH  BtH( bRQJuFTF}>"~]> C CGtGuZkB  C CkZk0 BG8 bGtG~ZkG Cb4GwAӅ].@ = =.  RAJH  BsH( bQ!JTF3F]>p"=> C CGtGtZkB  CkZk0 B8 b CGGtG~ZkG C8b4G%wAӉ}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>P"]> C CGtGtZkB  C CkZk0 BG8 bGtG~ZkG Cb4G-wAӍ].@ = =.  RAJH  BsH( bQ!JTF3F]>0"=> C CGtGtZkB  CmkZk0 B8 b CGGtG|~ZkG Chb4GGyAӑ}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGktZkB  C CFkZk0 BG8 bGtGV~ZkG Cb4G}zAӕ].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGEtZkB  C!kZk0 B8 b CGGtG0~ZkG CXb4GxAә}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGtZkB  C CjZk0 BG8 bGtG
~ZkG C(b4GyAӝ].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGsZkB  CjZk0 B8 b CGGtG}ZkG Cb4GyAӡ}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGsZkB  C CjZk0 BG8 bGtG}ZkG Cb4G/yAӥ].@ = =.  RAJH  BsH( bQ!JTF3F]>p"=> C CGtGsZkB  CjZk0 B8 b CGGtG}ZkG Cb4GyAө}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>H"]> C CGtGsZkB  C CbjZk0 BG8 bGtGr}ZkG C(b4G5zAӭ].@ = =.  RAJH  BsH( bQ!JTF3F]>("=> C CGtGasZkB  C=jZk0 B8 b CGGtGL}ZkG Cb4G3zAӱ}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}> "]> C CGtG;sZkB  C CjZk0 BG8 bGtG&}ZkG Cb4GzAӵ].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGsZkB  CiZk0 B8 b CGGtG }ZkG Cb4GwzAӹ}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGrZkB  C CiZk0 BG8 bGtG|ZkG Cb4GzAӽ].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGrZkB  CiZk0 B8 b CGGtG|ZkG Cb4GzA}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>p"]> C CGtGrZkB  C C~iZk0 BG8 bGtG|ZkG CHb4G{A].@ = =.  RAJH  BsH( bQ!JTF3F]>P"=> C CGtG}rZkB  CYiZk0 B8 b CGGtGh|ZkG Cb4G{A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>("]> C CGtGWrZkB  C C2iZk0 BG8 bGtGB|ZkG CXb4GA{A].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtG1rZkB  C
iZk0 B8 b CGGtG|ZkG Cb4G{A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGrZkB  C ChZk0 BG8 bGtG{ZkG C(b4G{A].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGqZkB  ChZk0 B8 b CGGtG{ZkG Cb4G{A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGqZkB  C ChZk0 BG8 bGtG{ZkG C8b4G|A].@ = =.  RAJH  BsH( bQ!JTF3F]>x"=> C CGtGqZkB  CuhZk0 B8 b CGGtG{ZkG Chb4G|A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>P"]> C CGtGsqZkB  C CNhZk0 BG8 bGtG^{ZkG Cb4G|A].@ = =.  RAJH  BsH( bQ!JTF3F]>("=> C CGtGMqZkB  C)hZk0 B8 b CGGtG8{ZkG Cb4G|A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtG'qZkB  C ChZk0 BG8 bGtG{ZkG Cb4G!|A].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGqZkB  CgZk0 B8 b CGGtGzZkG Cxb4G'|A}.@ ="].=  ¦SqJH  BtH( bRQJuFTF}>"]> C CGtGpZkB  C CgZk0 BG8 bGtGzZkG Cxb4GsA].@ = =.  RAJH  BsH( bQ!JTF3F]>"=> C CGtGpZkB  CgZk0 B8 b CGGtGzZkG Cb4GsA].@ ݠ= =.  RAJH  BsH( bQ!JTF3F]>X"=> C CGtGpZkB  CkgZk0 B8 b CGGtGzzZk `q=.n=,4Gn GH@b#Q JrHA H$Hҥ 3F2Dq=> Cn=<4GX@ӐBGb4GVZkG]]}ݤ#k  .P JFEG# C ^GG4G  ~ 0 {GAG ]   #k# C ^GG4G  ~ {GAG ]   #k# C ^GG4G ^  G  ~G( {IFC8 D  GF@(bGGtGGG{Ab#6_G4G H b9GCb#/_ӠBb4G4GzZkG ] ]  0 #k#& ^     G ^
 "P [ _&  ~# G0  CX {TG  R"  GGG[Zk C  @ BH b4GkZk 4GG ] ]  0 #k#$X ^
   ` ~z&h GP ^ " 0 "8 ="GC G @     C  ~# G G =G  G8 {4G( G0 BG   Gr   BCC( bG  GGGGGGugZkG  H =1v H
  TGGP'b#" C@ GW G0 =C@ BJ@!&H&HC8 r.S rJ8 r>yeZk   ݦA&6vJB ݶC  BCG( bG  GGGGGHgZkG  H =1v H	  GTGP'b#" C@ G* ( = "  R JX1""   C ðbc  CGP'b#4G@ӰbG4GP'b#c  C@ G ( =GbtGG#@  Xs"P'b#G C@( }b#G @GP ]X ]` }h p #kG# GP ^GX ~G` Gh p GH ^p [G@  CD G`   ~ #Gx { C  G  dZk  0 "GG'b#TG !  CS@ G,G =  $H8 @ BC!'HH b0v J$@ =C C  G  G G  G( GGdZkG  ( =!&H&H!!H   C0 TGG'b#" C'@8 }P B4GX b#v`H CdZk G ( =tG0 G1"H'b#2#H"'JGJ C@( TG0 G H'b#`"H C H C#@6  1`@@(  = "0J H!'HH0@ = 4 @ H C@& @G8 }C@ BC  G3v`JH b G C G   G( GG6dZkG  0 =0@@1v H   G0 BTGG'b#R" C@( 0 "TGG%H<@'b#HG%H  C`@3  1@@( 
 ?  !7&H%H HH @%H  Ce@$  G8 ]C@ BC  G2v@JH b G C  G  G( GcZkG  0 =%1@e@1v H   0 BTGG'b#SBG@ }8  C@ BC#gHH b%vHd@ } C  G G G G  G( GcZkG  ( $HH$H  C0 GTG'b#P   Ch@8 }4GP BX b#v`H CdZk G: G( tG0 G1H'b#2H 'JGJ CR@ }  %H8 @ B C#gHH b$vHe@ }C   CG  G G  G( GGcZkG  0 1vH  0 GTG'b#G-@8 }P B4GX b#v`H CcZk GGH ]P ]X }` h p  #k#4G ^[   ^ C ~  ( GG  ~G{6dHLZk C  BG  ( b4G?sZk	@GCDG ] G ] }  ( 0 #kG# dC ^G[4G ^  ~( G  ~G { LZk C
 `GbG4Gd@hB Z@GGcZk@ G G ] ]  }( 0 #k#p4G ^[P   ^ C ~  G  ~G{eLZk C `GbG4G>@ B  CGacZk  p"4G                                                                                                                                                                                                                                                   E                        ? $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        m "           Gb#0!  C@  B( bG4GRXZkG ] ] G }  0 #k#4G ^0 [0
   ^ C ~  G  ~G8 {5LZk C `G( bG4G@ӀB I@GG1cZk  "4GGb#
!  C}@@ b
 `  ,G@H D  <G ] ] G }  0 #k ,G@
H D <# 4G ^@[
   ^ C ~  G  ~GH{KZk C `G8bG4G@ӐB U@GGbZk   "4GG4Gb#
!  CD@       ,p`HA H0D   <G ] G ] }  0 #kG  ,
`HA
 H0D  <#@4G ^[   ^ C ~  G  ~G{KZk C `GxbG4G@B  CGbZk  @"4GG4Gb#h!  C
@       ,p`HA H0D   <G ] G ] }  0 #kG  ,
`HA
 H0D  <#0TG ^G
   ^ C  G  ~G( {G >TG2C
  0"?"GTG =TGP
! b# C@ G ] ]  0 #k            p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k#@" ^4GGTG ^ ~  G  ~GX {A D"
  GbtG!  C4G4GGwAGG( b@G@"H b4GA D  "G CbtG!  C4GGwAG( bG@PbG4G8 bc  CAG `@h bG CGGGGA DG  R@b CGtGGGwAG( bGu@G 4G`_b# "G4GTGGG@G "`_b#4G4GtGGG@G`_b# "G4GGGGܬ@G "`_b#G4GGGGӬ@G`_b# "G4GGGGʬ@G "`_b#,?"4G4GGG@G`_b# "G4GGGG@G  "`_b#G4GGGG@G`_b# "G4GGGG@G "`_b#TG4G4GGG@G`_b# "G4GGGG@b ?&GG bQ1"c  CGGGGBG`_b#G "G4GGGG}@G`_b# "G4GGGGt@b4GG 	b#hc  C@p bG4G^b#4GGGG"@b DG C 	b#TG8c  C@G( bG@G ] ] }  0 #k#P ^X ~` h p G{  ~GH ^  ,Hp `4Ge  G%vHHbC CTG7A DU  @ =G C( bCP DN  TGA DGI  @ =hb CC(DC  TGA D?  PBCXbCGGGtGlZk2  8 = CD  0. C!?H  .G`J  J3V`J1!JaJTJ3Fu JDF  > C !!   .CGGCJVJTBwJGF  > Cb JF  0/8K8 =TG  . K9V KTJ!KGu KGF  >@"A  ,H `4@!vH
%@?GH ]P ]X }` h p  #k #,A#H  D ,@HD#C ^GG4G  ~ ( {G AG ]   #kG# ^  ~( 0 8 G{  ~G ^  ,H+ `4G   G%vHbC CTGA D   = _"G( b C D	   2D  4GȩAG Cb4G}A  ,H `4@!vH
%@?G ] ]  }( 0 8 @ #k #,A#H  D ,@HDG #4G^G^~޴>^G  ~ CGhib##G@Ӡb  ,H `4G  G%vHbC CTGA D  p¤  =C  CCGGGb0D    ~G C G4GGVA DP B  CX bL@GtGtGkZk <  G_1I bC1@ ]"  .3I "SBPJ  .CJ   J0JG	PB PF   = 7,Cs`J  =GG?G3D 7< C C   G4GGcA0 As AC0 B@8 b . ! p "tG J     CjZk C C\  GC 4G`B Ihbp I'HȐ Ig@  @
(@  @  @'H	 DvH*J1H
 CB h" H." C4GSSJgJ jFF `gZk ,  ( `BGRHhb"GJ CtGgZk `BGhbG  CtGgZk , ! "TG`BGHGhbH)! D CgZk`B!hb C4GgZkG  } C(btGtGGQuAh "0 B ]!8 b@ CGtGiZk C CGTGH bAG CbGTGA  ,H `4@)vH
'A-G]]}ݤ=] #k #,A#H  D ,FHDG # ^ ~   ޴ G {G  ~ ^  ,#H `4G  G%vHbC CTGUA D   =GCH bGP D  !D   CTGA D  GC( b  = 0 BC  1C   @  CG4GGQA Do  4G4GQ C1!JC1@0 C  Y CC @_0@  C@ @0HG1u B
0B  	CGbs%  V ?@6JCB0 @  ֢Y ?@9!KF& CB0 @  9Z ?@:AK3G  CC0 @  ZP ?@0JSG @CPB0 @  4!HF  	B&@ W ?@C7J0 @B&@  ֢F  G C8bGTGAG Cx b CGGtGܑA D  GCX bC4  f C` BGGA DG  8b CGTGފA  ,H `4@ vH
@aG ] ] }   ݤ  #k #,A#H  DQ ,EHDG# C ^GG4G  ^( G  ~Glb#@G Clb#G4G@ P BtG =P @  HX bpB0@_Zk@G GGbG5tAG`ab#  "TG4GGGG~@
 àSKB  GG àwIB  GGGtGbtAGGlb#@G ]  ]( 0 #k`#` ^h ~p x  ޴   G  G{  ~X ^  $,  $H  0 @  4G  GG&vHbC CTGEA Dw  P =G CX bCq  TG=A Dm  8 =W!@H  P P F  Gb CCTG_A D  BCbG1P@TG^ZkG	 B Cp" bG CTG^ZkGG CH bG4G	AH GG8 bC v H4G 8 DT DG
AH 4 EGCGb v H C 8 DDG(IGIsAGb C4GzAGG bqA# GGC b CGTGA D    @ 4G` Bh b0ADkZk @
   Cb#C@Gx b C4GbA GG ChbGTGA  ,H 4@&vH
@yGX ]` ]h }p x  ݤ    #k .PJFd -HIEG#CH^ CGCP^GX~"`GhGpG  ~G8 {@" GA D   }  C C  0. CC  .GcJ #J3V`J1!JaJTJ3Fu#J CF  > CG  .GX bGJVJ75BwJF  >G  z.K` = J8V K6JKScJFtJ?GtF  z>GtGA D)  ` =tGG8"b#0 H?D CG
@DBCb0F@ ,TG H1eZk xD8D   BL@bG4G'eZk4@呁@B E@bG4GeZk G` GGTGH b0H؉D\ X %vH CJA D
  X G C@b#$vHG CtGw
@X GCbG%vHTG CA  PD X G CbG$vHTG C@A DB  CR@bGGTGt]ZkG	 BC P@bGGTGj]ZkGX G4G b$vH CyA D`   X =CD!v HB C CG5 GX  CGGbTG$vHG CGrA+ X GGTGx b$vH CA D
  X G C@b#%vHG CtG
@X TGG$vH  % b CؑA D
  X  C@%vHG CtGGb#
@G`  8 b   C C CG@"G~A D
GH]P]X}`hp#kG#0JH ^ CG!v JP ^GX G  ~G@  C8 {TGA DD    BC( bGCGtGhZk:   C( @ =  A. C0JG  .J @J4VJ2AJJUJTFv@J?FF  > CQ DP D  70F ?"C8KY8K4@CzXKG:G  7C  a/ CGTG  .G `K(   .@"J;aK4VJWJJtGxJX bF  >{AGH bGoAGH ]P ]X ` #kG# C ^GG4G ^  G  ~Glb#@   "G H4G   D  G  "X?"4GGGcb#GG@G ] ]  0 #kkG#G ^G  ~ ( {GAG ]   #k#G ^G  ~ ( {GSiBG ]   #k#  ~ ^   0,G0H
  G4G0 {GͣAG ]   #k 0.Q0J!Fð#$0 ^   @ [?&8 ^4G@ ~H G(   ~G  > eCH {$ , \Zk =w H  bC  ]C!?H "!  = C } 6_JG ] F   C:AK ]P B8vK &GGX bGC GGG]Zk   #  C!v Ha@  !.Q !J  !>  GG0 ]8 ]@ }H P #k#P  ^  ~( G  ~G ^G{#_ C0 B  8 b4GkZkGCH bGG4GA 4G   =0v`H!v H	B  G "G( b4G-AG ] ]  }( 0 #kk    #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k# C^4GG ^(~08G  ~GG{GADBG#  bC"TGiIZkGCb CGGTGtG4+CDGG   _& C( b-R" ]GGGG?+CG Gb4G+CG] D ](}08@#k# C^4GG ^(~08G  ~GGH {GAD  BG/  ( bCP "TG)IZkG                                                                                                                                                                                                                                                   F                        rx $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           C8 b CGG?"tG*CDp 
  GC bGGG CtGGGxpA GGC _&  bGG-R"GG+CG Gh b4GA+CG] D ](}08@#k        p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# !iC8^@~GHGP4GX޴`hG8 {G  ~0^#`  c.tCJXBTG`bScJtF  c>ZZkG C`b# &G"?"tG@ DG  O@b CGtGGGoAG0 bG@`  ,GGtGbG@HTG D  <oAGCHab#G4G@P }( 4Gh C. #.HGsHRCJP bQ#J   TF C>3F #> C@G@b4G@GC` bG4GAGbP"GTGyA D  bG CbtGc  C4GGoAG0 bG}@G bP"4G{A Db
  Gb Cc  CtG4GGoAGG0 bh@G4Gpb?"TG;C4G
  bGb#|@G/@G0 bGU@ӠGGb#G  d CTG!@d G `G_ 0 @$B	@  .'@T J  > B 0 @  .	@'@W J  >?G8@~b#G4G(@ DG  #X@b CGtGGGUoAG0 bG@Әb#_@Gb@4G@G b@4GA8 $Q&0 db!v>HD6@8 $p H8 ^G0`HP`Hp`H`H  а`H `H >P H0 >`H ~?D  0 H( tGGG$oAP"b#@GCb CGGGGGwAGPb 8 = b CGGG:AG C8 =GbG4GGGAhB CpbGGGtGeZkB @C bGGGtGdZkGC8 =b CG   G4GGGAb#j@0 } ?$! B!!H b#~HC @a@G0 =GGtGdZkH }R$GCCb#v~HG `@H GP"GGM|Ah }XB ?$ C`b#v~HGa@h = CTGyYZkBC b @GGGtGdZk }#H } $c  G D"
  xBb4G@!  C`Zk  GG0 b v H  f@GC0=  bG " C` CP"G
{A DG  4Gp~b# v H@0"G Cab#4G  AG1V J_F2AJ!JQF CX Fk `x Fo  X @0" C a" !. A"GJ 2J4VJ1!JJ4F F #F]  GCbG4G@G CbG4GdAG CbG4G-@ =  G   L0v J@   H 4GG ]2v@JC @GGC bGGTGA D   =   0@0v J@ G4Gh =8DB# b#1?J(R" 1"h = C@G@  b C4G`@GCbG CP"TGG{AӠ¤b#  C@ G` 2  Cb#1Q@@G4G}b#G@d c.
CJS
cJtF c> ,G@
H D <#& ^     G ^ "@ [G  ~#  C0 TGH {G G  GG0NZk CG	  L@(bGtGtGGGmA P B4GX b]ZkG ] ]  0 #k #4G ^G ^ ~   ޴   > ^ ~  G  ~G(db#G#G%!JCL@GG` b4GGA8"GG
G 	 )!G,vH,  G)TGh Bp b+@ " !. A. @0JRPJG2F,F	   CWZk  )+@  . J8 F    )
0@AgA	QA?
  ] a" .4G .SJUJvSJTJFF > >D G*vHP bG CG4G4GGGADGG `Cb CGGGGGADG G  B! = C bGG4GGG%ADG 8B  @b CGGtGDcZkB Cb CGtG!cZkG = C b C  G 4GGGլA  G
GM &q@
@G `   . J  8 A.8 ! 
0@A AJ @8 .8 ! 
0@A J 8 .8 ! 
0@A J 
0@A	FA8 ! 	DA0    A/ AK @
0@A	DA8 ! ( G  !.4GraI a"Q !Jq`F2F  !>  p`FvHJ_AUJjJAF  WB  ݠ # A/
A !/
@AHZXK{H@GY8K A?(BG;G !?0b CTGWZk4G  DGX 	@ bLA  iqATG!9C		  pBG4Gb#G J! Cc@E p¤TGGK@  )kkA@b#GX@  G	@ I0@  ɠ LA	@   .A
LAP  J   >    j.0@	@S jJ  j>A)4G	+AvJ  . "qFpFU JzHF  >  8Y;K:G  8W`C* @  )  I. A I-GH(BRAJ0bsHJAIDF I>
SE I= CTG9WZkG ] E ] }   ݤ   = ] }   #k 0HFF x 80H?G:G 8ð#4G ^G ^  ~( 0 8 ޴@ H G  ~G{G$!JHAӐGG     % CBTGb'@ @GVZk  %3vH'@ " !. A.0JRPJ2FqF    0@@	@   .V J  >G$vHCb CGGGGG{AD G =G8bGGGAG ] D ]  }( 0 8 ݤ@ H P #kG# ^ ~  ( 0 ޴8 @ G  ~#!J ^G`HGC2  G  %.G %,P@b# GHA%H %J D V H1!JH F ? e.> %"> %,>  SqJ1H  HSF2V@J HAJ C D D  w_ P@ CP@8b#_pGb#  'vH8D  @0@@@G ] G ] }  ( 0 ݤ8 @ P #kG#G ^0 [ ^ ~  ( 0 G  ~G8 {JZk  GGtGcb#4G׶@0 B8 bGJZk1@W+BhG  @ BTGH bB]Zkh@ BGH bG @GtG]Zk  db#4`@  dG @  pb#DؠD @  À# C` ^GP[Gh ^TGp ~tGx G  ~GX{taZk  &Pb "@BC HHb  c  @G  CTGVZkB Cbf@GGGtG@aZkX f@BGbC HX GtG5aZkPB CXbGGGtGIaZk GR?$Cb vHG @ CP"TGGxA Cb# v H 8 D  8 @G` ]h ]p }x  #kG0J;`#`1 J0V J  ~ ^*B ^J G > D`S H0 [G8 {!>HC D 	   GtG`Zk CGR_&C( b vHG @ GP"TGGxAG ] ]  #kG;#`G ^tG  [#@  ~G G  ( {XZkG ]   #k#;4G ^ ~2B  ( GX  ~G ^#P   [GH $Ґ HӰ H   H { H ?D0 H  P H ޶ >XZk> ,> "? C.> # GGB0J bRPJ   H2F1V J H!JB DG CP`@XZkG ] ] }  ( 0 #kGp#4GP ^X ~` h p ޴x  GGH ^GGG  ~G   8 {@G Ceb#G4G&@Q  $,"BCbTG&@ '"  .@ J8 F?   G. g.G@ QJS
qJSF1BB)  G'UZkdGCH bCf@   #,G .G HP J0D!&HG&HADG#  GG8 =Gh bGGкADG  B  P.R PJ  P>
 G@ } " . .tJVJwtJUJF >F >$0@@	@?G  4GX bt@GH ] DP ]X }` h p ݤx   #k# ^ G  ~G ^{# @R"Pb#_  BG( b4GKiZkG ] ]   #kG# C` ^G0 [Gh ^TGp ~tGx G  ~G8 { `Zk  &0b "  BC H( b  c  @G  CTGTZkB Cbf@GGGtG_ZkX f@BGbC HG   X tG_Zk0 B C8 bGGGtG_Zk R?$GCGb vHC @ P"TGGDwA Cb# v H 8 D  _G` ]h ]p }x  #k# F ^jC ~4G  TG( G  ~G ^G    @ [H {  $@!v H8 D    D%_Zk  C @  X "GtGx bGGGGiA
 Gx`D  	 `` Bh b4G    v H    FZk0 BG( "TG8 b@VZk0 BtG( "TG8 b:VZkG ] ] }  ( 0 #kP#G    G  ~tG ^!v H[8 D  dC  G{.WZkG ]   #k    #^ ~(08G  ~G ^G{#R@HH@0 BG8 bTG     CSZk      0 B C =TG8 bSZk   CP BGX bTG  BZk  CB
    b4GuFZk` BCh bG4G\Zk `8`D	 X`D `b#!@4 D G ðb# @ D   G Ðb#@  B4Gb4GSFZkd G ðb# @D GDG]] }(08@#k#;4G ^ ~0@  G{G  ~G ^TG  {#   @0B4G8b+FZkG ] G ] }  0 #kG8 #H> C @ h^[` ^ C ~G(tG08G  ~GX>{dZkPCG4GP bP D  ^nAPGGGbA  ;C   C  $  G( B@0 b1A@TG*^Zk  C0@  B4Gb4GvZk!@h p b@  tG?G  TG_ x B%M@ C bGGGGTVZk  4GB bEZk
 X B4G` bzZkB4Gb   0HSZkG]] }(08#k#8>  @ h^H> [C^ C ~G(G  ~G@>tG{cZkGP b CG:C  BC( b CGGtGjZZkb4GBb  	  uzZk  cpB4Gxb  c c0`HSZkG]] }(p#k# ^ ~  G  ~G ^{#, @ӘbD@BGbTG c    C]Zk  C                                                                                                                                                                                                                                                   G                        = g $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        2 "              G G" C4GtG-@Gxb#8_E@H@G @GG4GGxb#-_ GG ] ] }  0 #kG#"$8 G0 ^     [C  ~# C CG ( {G =G G  GGGTZk  G0 ]8  G@ #k( =G0 ]8 u @@ #k            #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#" &0 ^?$8 ~ "@ GH G8{G( ^G[ c   ~#  C  =tG } $ }:RZkGBGTZkp"BGG
TZk  .v9H  p KW JTGF  >?G .s$JG D#U JaJF >G  D.pJ C CR DJ4 "SF  D>D d/JrH[ zKaG d?, 9 D ,{aH@ H D <+ 9.J( / C CQ9JXK3FG+ 9>( ?
 d"?G/ Y/G, .xKZAKTJ@G/ Y?FB $ , >~RZk4 9.rHJ{aHQ 7J C2F4 9>
 .GGtGF
 >D D/ .ZAKTJ@G D?FBb >
SZk6   $,   C $H Ca@  A.R AJ  A>  pF `  . JXF   .W J  >0B  / KB CGHRZk  v H  BCC( b5HC F  G  G GGGG#SZk    G # !=H #  GG( ]0 ]8 }@ H P #k#x4G ^GTG ^tG ~  ( 0 ޴8 G  ~GG{G!C D  G   G( BtGGGOSZk¤( BGTGGISZk  .v&H #U J`JF  >D &/qHG e"Y 8KzSJ G &?, f#  .{Hv{H, "P J CF  >D .G4 f T Js%JF >/ .G, &,UJA;HF6D/ >, &<7H E.HD/ &/R EJ`HSF E>+ F/Y
7K( .  GZFKTJAG+ F?FH B C( >TGQZk4 .GvHb4GU JF4 >2C %,H e,pHA$HCdH1D %<pD e<  G\ G
 e.
 E"GbtJ8 B@ b CtF
 e>  GGtG=RZk  GI  , %  .G e. E"   H2JGTJbu2JSrJBFuF > e>4G  .W J  >>Bx BG  TG b~Zk C G' h B%M@GGPZk"BGbTGG~Zk 4GGtG  #  ,Pb CD H  <BDG G C  #4G` bGGBG D  xb# @ DG ] ] }  ( 0 ݤ8 @ #k#H;4G ^ ~tG  ( 0 ޴8 @ G{G  ~G ^G  , CG  ! H{  BDG   G% x⤠¤G  ' CG ChbG0 BGB    ' C TGG4G0 @Xb    '!CDG?G Cb4GD~ C  4G  DG ] ] }  ( 0 ݤ8 @ P #kG#4G  ^( ~0 8 @ ޴H P X >` ^h ~p x Gۤ ^GGG  ~G  G{GG#CG C  GbTG7%C  @ BG GH btG[Zk =  E.@ .R EJ Js%HSF  E> G( 4GGtG  . C J X b  5@BDG  "GCTG  	
G8 FJ  x b C CDbG   C  +4G  GFGt B   Gb C CBDGp   F   KCGGb C C0@BGzB    =   CGTG?D =0 B  b  K!CDGS  @ BG GH btGZZk@ ,,
4G  %. ,HQ %Jr%H2F  %>
_E@ @b  GBG  ˢ CGRZk@ .xJG0AbGW JTGF@ >B  G)   )    K C C	8 E   C0@A   k C CG0`@G8 bGB	DG     CGTG  0@b   C
DG @@ -  %- II %IfI	&E  %=4G( Gh b  d- C dI `BG ] D  ]( }0 8 @ ݤH P X =` ]h }p x  #kG#0J( ^4G0 ~8 @ H G  {  ^GG  ~   H { >"CG C  8 bGTGN$C   G G =4G$v H=@  GGC  TG8 b4@=$C  !vH	$@?  ] G@ 0.  r. 0JS rJtJtF  r>GG  ]( ]0 }8 @ H P #kG G        # hC^TG0 [^~ (0޴8@G  ~G8 {GGGYZk CG  4G> G  BC( bGG4GGGpZk 8 D,  GG4Gx bGTGx0C#  ` BCh bGGGGtGZZk   G '.H  .rH  B CQ'J( bPJ3FF '>  >GG4GGGoZk 8 DG GTGP BX bG4GhAZk GG]]} (0ݤ8@P#k# fC ^TG[ ^  ~( 0 8 G  ~G{G GGYZk C  4G    BG( bG4GGGdZk 8 D    . $.JQ
$JF C TG ]BGb4G+AZk G ] ]  }( 0 8 @ #k            #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#G0 ^GGTG8 ^@ ~H P X ޴` G  ~Gx {iAӰG4G b#   @  "4GGb#h!  C_G@xb#GC@Ӑ B bTG4GbZkGQ"b4GSoA  "4GGb#0!  C_G@xb#G-@"bG   4GG! b C  G  䳑6$JGGGGB  #   GCPb#4G@    $tG "0 @  DPBG  6BGb# C_P BGX bOZk GGC" C( = bG  GQ"GoAG  G( 4G b#@P BGX bNZk G  4GGHb  ( 
iA(  "tG ,  .  "  !B  `.H .Q0J!v HG`Jb#TJD	&@tF3  G C C_B4G( 4G @bGUZk pD   B!V@bG4GUZk  %,B ^@bG %HTG0@
UZk 5@B0@!Z@bG4GUZkG( 4G b#~@P BGX bNZkh G  B  3   䫪"   ?&1"  .qF  Je @GTGtFb ` =( AE GGB GTG =( bA; GG Cxb CGTGxA  ? GbTG  D   =( }A( G C b4GGbAG C( =TGbA  "G Cb#TGG"_ Cb#- @  ( = CGpb#a @G btGTGTGfAG( 4G b#@
 Ghb C4GpAG4G(  b#@  àG BG bSZkGk  @i .UJFG#?& ^ 1"  ~   (  C0 G ^#J =G@ ;Gp [G  ~#  QTG8 Gx {G   BZk C  ` Bh b1v`HGtGRZk GG #v`HX b ?" CTGxA G  GG ] ]  }( 0 @ #k#0v J  ^tGG( ^0 G  ~G >C ^C8 {A tG G  .   rJ( bQ !J2F  >G = %hAG  ]( ]0 @ #k    ( ;#0 31 B  [G  !tG      ~G  @ ^  G +   CJ 7.`J  7/ #Q7JY4K2F 7> G  7?  FGXJ B
   ,qXJ 7/@HY8K D1G < 7?  /  C W. 7"HXKyJRQJG ?YF W>0B	BG ] G   #kG;# G   ^ G A !  ~  G  ~ ^GG @D G  .4G .(JBU
Jb"F CxF! xF  CSZk  #. C.TG(#JR
CJB  b2F C CSZk    CGTG G(b4Gc  CBbSZk G G .tG  .cJwcJVJUJFF >AB  >  0 2# R/ G r/YK[
yK[G  AG ] ] }  0 #k#X{0B  ~ ^xs" ^4G ~    0,G 0.GG  [0H( {Q
0J C1D Cx#D @x"D  cSZk c.  C.tG JScJtJRCJ     uFTF c>  C> "  `6HD /y6H .XKWJG ?F >G ] ] G }  0 #k#dC  ^ C@ [dC( ^G0 G  ~G GH {GGGXZk   G 0 BC8 bGCCtGPZk ] @   G G G  ]( ]0 @ #kG#dC ^0 [X   ^G ~TG  ( 0 ޴8 G  ~G8 {G C_VZk C  8 GB0"	CB
p@bR" 1D C%DGtGtGGNZkBGb0_" @GGGNZkGB" 
@b  EGGNZk  GGGGGb# @0@@ B0 H b&  @?G4G}Zk GG ] ] }  ( 0 ݤ8 @ #kG#G ^ ~  ( 0 ޴8 @ H >P GG@  ^G( [GB  ~G0 {GGGHNZk0 8 " CGGG  C@ ¦( B `"  . " .B   ,G .    3J0 b J $HG JG.NZk C@ E( B0 bTG 	LGGH!C EA?@A !@!@  NZk@	@@ A@G ] 4G ] }  ( 0 ݤ8 @ H =P ` #k    #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#h !lC8 ^[G@ ^TGH ~P X ` ޴h p G  ~G{GGJZk`  C    ,GBGbA H0D   <MZkG b CGTGQAGx bGVAG |b#G@Ӏ bC C CGG4G`  .Gu3HbtGTJF  >^A  `HG  ¤e @  $%@j !"m a.Jj A.tJSqJRQJuFm a>TFj A> ݢTGGxb . " /CGJXKF;A  &G"Fb#  , "  .TGHP JD'" G" @櫪g"w `D                                                                                                                                                                                                                                                   H                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "             .G J]B   =\@&G@BTG = RB  r [ @Zk    , H3 DW  GH b CCTGYwA D  ( =CGTG . '"?Db JGF   CAG C =tG0 ]beAG8 bGYA  ', "GTGFb# 0H= @   = @  BTG = A2@  a [ @Zk   ',   . HR
 JP J2F0 B JA Hq JF1D > '<  d  eB " . .JxJWJVJFF > > G C b4GmAӹ GCH b CGTGvA D   ( =CGTG . '"?Db JGF   CAG C =tG0 ]beAG8 bGgYAӕ GTG = Pb#2@ӎ GGCH b CGTGvA D   ( =CGTG .  ?Db J CD 䕎AG = C0 ]tGbveAGG8 b<YAj G  TGH@   '. . Hr HQ JP J3FF '> >  = . "G JUB  u [ @Zk   ', .   HR
 JP J2F0 B JA Hq JF >1D '<  d  eB " .J .xJWJVJF >F >0 G ]C  dTG , Z#eC ;  . H ,HPJGqHGHF >D < Gb#0@GG bvVAG C b4G}A    @ '  '. .HrHQ!JPJ3FF '> >4GG  b#_G   CXb C CGtGAӢ  ,GA
 H0D  <b .
3HT
JF >{  .P JFà#4G ^Gx   ^  ~( 0 8 ޴@ H P G  ~Gb#G > C_8 G #,   .I@  %TG H( BP J0 b0D! HGa!@!B$@0@ a. !  aJCPZk @( B!D@0 bG4G;PZk  #. #,TG( B#J0 bA#HP  C!F/PZk #. #,  TG( B JA H0 b0  C!F"PZk #  ,TG( B 0 b C HPZk #  ,TG( B@0 bG HPZk #  ,TG( B@0 bG HPZk #, " #"G 0HQJ  2V@J!!HAJ( B0 bTG2DB CGOZk	 ,	 # ( BTG0 b HBOZk #,   .TG  % HP JB( B0D! H0 bLBa!@!Bn a"n .Gq .JU
JF COZk( B H@0 bG4GOZk4G( B0 b @GOZk #, .     HP J0D! Ha!@@n !"n A.q a.QJS
qJSF C!D^  54@BF Ca@@8 G( BL@0 bG4GOZk  CG  _( B!G@  'G0 bTG0@OZk @ G  _  . &"HJIA @b" C4G  E@GGTG( B  0 b@}OZk( B%@G0 b J@ CGTG@rOZk( BH@0 bG4GkOZk }TGGb#GG_G ] ]  }( 0 8 ݤ@ H P ` #k q.SqJrFVG4B    p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k#C^PBP[tG ^(~08@GG  ~GX{GGGTGRZk  C. c"
 # t1 H V H SJH_B F G C G+ GGC Cub#GtG@ GCCxb HGHGGGGADGG   . #" C.@( btGJRQJ =FG-BD? GDGG d. $"GtJb@S qJGtF d>GtGbAG] ](}08@P#k#PB@^tGH^P~X`hG[CG  ~G8 =G{#GTG`RZkBa@bGCGtGXRZkBb@bGCGtGPRZkBb@bGCTGtGHRZkBb@bGCTGtG@RZk ,0c@  CG H3V Jx@p1 J .aJPCB R"F   JGG!_C G_ =0 }C ݟ@r1 Hp1`K;V`K!V HaK!HF0 AF =  tG: G@=" Cub#G CtG6@G Cub# CGGtG.@0 @ GCb C%HGHGGGkADG   #" C.C  = C3v J .GRQJ!v H J  C }F( ]4G( b C   4G1-BG8 GbGtG ,  aEKD HGD  <8 =bAG@]H]P}X`hp#kG#C(^PB[tG0^8~@GG  ~G  >G{GGQZkBa@bGCTGtGQZk ,0b@CG HG_ }C Ga1`K;V`KaK;D = @& GGCGvb# CGtG@ CGCGb HGHGGGADG
   . #" C.tGGJRQJ =( bF ].BG  =GGbtG . ! qJP JF  >  =GaAG(]0]8}@P#k#C0^PB  [tG8^@~HPXGG  ~G( >G( {GTGGQZk  Ba@( bGCTGtG?QZk  Ba@( bGCTGtG7QZk  =0b@  ]x1Ja1 K ,v1@J2V@J5VJ9V KAJJ!KFG9D H@`@PB p/ " G =  ] @ pKݿ@ tG4 G0#vb# C CtG7@G Cvb# CGGtG/@ G0 CH b$H CHGGGGlADGG   C" .C  =G0v Jh bTJ C .!v HG CJ ]F C.BG( GGGtG ,  adKE HX bD  <( =aAG0]8]@}HPX`#k            p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k# p"  ~
 0 @ >BH^ "P^H"X~G`tGhp P.G
 ,G .GG SJxob# H J C@D   . C. #"GTGJbRQJCFpAD  8  GP F   G . #" C.CGtGJ@ bRQJ CFG?A D  0 = TG?Dx D   GH" . C . "GUJnb#JCF CCCGGo@D  . #. #  ] #JQ!J3_JFt J ?'tF  .0vJ  ݦ
   ] }# JvJ7JFFB EKG =.rEK
 =, CQ%JGA%H3F2D =>
 =< HG x3 HJqJ56JC F GG ,tG =,EHA;HD <1D =<C	b#GG@DS    . c" =CF .GTJP b2'HJ CFGGGAD? CG . c. #"  =tGGJSqJb?DF C$4B   D  (  c"Gb#G%vH    . =F .TJ2'H CJGF@   G G G (  C" .G  =1v J .UJ ?DG CJ` b4HF C CGA@ GGGbtG ,  aHD HD  <@ =_AGH]P]X}`hp#kG#
 0  ^C(~tG08@޴HG  ~G^
 , C" .G c.GG HJ{SrJGFGADG_    C" c.CGtGF .SrJb CJGFu@DN  BbCF@TGrZk . #,  GG JHbA HCFtGGAD:  . c. C" ="GJSrJ( b?DF CC CGCBD( 0B= 8b C4GDZk0BC8bGG4GDZk @!@   G GB	  b CCTGCZkB b C CTGqZk $,pH0@ GA $H0D $< $"D d.tHGb@S qJGtF d>GtGC_AG] ](}08@ݤHP#kG`# p"  ~
 0 `^Bh^ "p~`"xtG޴ P.G
 ,G .GGG SJ`pb# H JG C@DG  G`"`=" ob# C CTG@G` nb# C4GTGU@ D  G G . #  #.TGGJQ!JbCFGoADG  0 ?D0DP F   G . " .`]"G`"Job#UJ CF CCC CG@DG G`= pob# CCTG@ . #,  X CP  JGA HDb2HF CGGAD GDD  . #  #.TGGJQ!JbCFGrrAD ]Gp  . #  #.3_J #JQ!J ?'Ft J  tF 0vJ .X ݦP ] JvJ7JFFB G =,EK ,qEKP A%HGGH2DD =< < HG }u3 H`" C46J =# F JG .aJ }/H ]GPJ[yKFeG }?C >GX btG3BDG, DG)  CG . . c"b CJTJtGF3BGCbCGGGtGbB   =   c" .G .!v HX ݤHGJTJbD2GJ CF CA ,  G`HhbGF HGD <GtG-^AX DG  bDDk  . , CtGJDHD@FCG&2B_  0 B` 8 b CGGtG;qZkV   .   ,TGGR@JbDHFCG#nA0 ` B` h b CDB GTGpZk>   BC b0 @GGtGjZk .   ,TGGJFH@ =x bFaAq @)  GCbCGGGtG<bB DG   . ,  bTGJGHCFGqA     ." ,GX HGJFH8 }D bF2GJ ClAG`]h]p}xݤ#kG#B  ~
 0 0 > "8^8"@^GH~ CPtGXG
 ,G p.GGpb# H tJ@D   . C. #"GTGJbRQJCFmAD    TGP F   G . " .8]"G8"J8pb#UJ CF CCC CG]@D G8= ob# CCTG(@ . #  #.C( G  JGQ!J DP bF2H CGA D   X DGTD Gs G8= qb# C4G`@   Gj G #,   . " = '                                                                                                                                                                                                                                                   I                        Ia $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           $HPJ2?J0Ds H
  SF = .!v<H(   = JuJ6JF6D8@ = KG .q K
 ,  }8"P JDHF >D
 <G }ے`K Cw3`K0 b46J = F }G ]/J ,dJZAK@HDG D < ]?CG CGGTG1BD DD" GGC bG4G4BDG (  . c"  =tGF .TJp b2'HJ CF#A(   TGG D` b1H CjA G0 GGbtG $,  pHA $H0D  $<0 =G\AG8]@]H}PX`#kG# 0 (^tG0~8@H޴PG  ~G ^
 " =a@ , #
 .GG# H0qb# Jp@AB . R"G JG C@DG   " C0qb#GGtG@DGW  . . "  pb#JUJC "F C CGC CGr@DGC   Cob# CGTG|@G  @pb# C CTG5@ 0 B = 8 b CD  CTG@Zk   B  H@( b CGTGnZk  B    ( b C CTGnZk .   #, "  C" ݤ J #.A HG CD ޶4Hb# 2J  G ޶ CF CG4Gh#@ ݠGGG8btG ,  dHE HD  < =0\AG ](]0}8@HݤP`#k #
 0   ~pB^C^TG~tGG` >G
 ,G[G{G HKZkBa@bGCTGtGKZkBa@bGCGtGKZk@ = "H  " .C2V H .1V H`1 H!Ja1 HAJ D2D@ = JH  JG_h]# CGb@qb#GX GtG@D   . C. #"GTGJH bRQJCFkADG  h" C . . "C qb#JUJGFCCGG@D GCpb#h="G CTGw@ . #. # 8 h}"0 JGQ!J D( bF2H C CGGA D   G GBh b CG;_"tGpKZk@ = "p c#H  _&!&HX =0J` H0D= }  Dp
   . .JWJ5JFwJF }3v|J C/8 =0 = [Ky K0 :BK3GzFrB ] JG .v J
 .В JUJTJFF >
 >z3 JG C( } ="96KqJ:G vqJG .dG .GGUJTJ CFҔcG >Fx bG > CGG\3BDG)  . . c"Ch bJTJ CGFtGBGCX bCGGGtG_BD   . . "8 =HP }JGUJ?Dhb2GJ CF3v`JGA` GGGbtG ,  aHE HD  <` =[AG]]}#kGP#
 0 x^C~tG޴GG  ~p^ C"
 ,G .G c.GG HJ{SrJGFGADG
  . #" C.CGtGJXbRQJGFG	ADG  . #  #. # ] ?'JQ!J3_JFt JGtF  .0vJ( ݦ  GK JvJ7JFFB =G ].sGK =,GCRGJA'HTF ]>3D =<  CGb CGtG7BDGG   . c" . C( =tGJ8 bTJ?FF.B   . #. # ( ݤ   GJQ!JbDF C CtGT@ G .   #,C( ݤG  JGA HDH b2HF CV B8&H%HDL 8 C^_LT GH= C;!K9>KyGH=tGS_@0B4]" C;K8K@xG@TG8b 
JZk  $,G  B $"( btGA$H0D $<@D D.R QJ D>GGJZkG C0qb#p@GTG@0BP@<="8bG CTGtGIZk0B@8b>="G CTGtGIZk0B@8b CGGtGIZk0B P@H= 8bG CTGtGIZk0B@8bJ= G CTGtGIZk0B @8b CGGtGIZk0BP@D 8bG CTGtGIZk0B@8bF G CTGtGIZk  B@( bGGGtGIZk0B@ C8bGGTGtGIZk  BЍ@( bGGGtGIZkG ,  GaHb@@ HG D <GtGYAGp]x]}ݤ#k $,GA
$H0D $<j # p"  ~
 0 x >B^C^G~tG޴G P.G
 ,G [G SJ{ HGYIZk Bb@bGCGtGQIZkX  C. c"GC 0 @rb# SJX d@GtG@DGG X  ?&Gb6dJ F   F . " .CGJUJCFGGTBDG 4G GG . C. #"GTGJX bRQJCF mA .   ,CG CJ(b@HG FtGADG  . #" C.CGtGJh bRQJ CFG~ADG` = ?"X o@ BC 1Db-  G+  GTGtGHZk . ,  p tGJG@Hx bD F C CG@@   H ݤ C"p tGHGGbDDH $vH . D c. CJSrJ CF@ӟÀ " ## $D #.%   C.C  }0JRPJp ݦ4J2Fu JvJF  = /1v<JP ]F KP }DK8KsDK8F&B  ݴے`KG( ].y3`K% . DRDJPJTFF( ]>% >#G(  C+  76J&JF( rKG. .+ ,PJDHFD. >+ < CbGGC"G CtG5BDGQ GC]"X =8 bG CtGk4BDGD . #  #.CGGJbQ!JtGFX =cBDG4p  " . ]CFG C .UJb CJBF0 ]FGGA D  GÄ=" CG+ }"H b"D"  . .SJ+ .vSJCUJTJFG. >F+ > CTG_B 8 D  GG  =}"G Cxb C0v HP HG&)A D  G` =G Bc@CbP D8  GGGtG	HZk=h "D  D `GP D  РD GD   G & b "  D  H  ##GK
   . C/JZYK4GFG"AӅDGh = &s"!D  3D`$D"H =` =" Be@bTGD H tGJ   CGGZk B="e@bH!Hp HtG 0D CGTGGZkH!Hp H 0D GG` ] c"G( b4GBF @ . .JTJFA
   B bf@ CGGtGGZk C_Ӝ G` = B f@,G  H } CGpG `bTGtGGZk" Bf@b C HaHTG DtGwGZkRH!vHpS H 0D G` ] B g@bPF @ CGGtGcGZk C_8  D  H }0pG `G  .   C/4G( bJZEKFG¥AӆD`  Bg@"bHGpD H = CTGtGP0D  =GZk B="g@bH!Hp HtG 0D CGTG.GZkH!Hp H 0D GG` ]	 @H }pF `G Ä & FtFAFD F ` ]C GGC G` ]G b CG6BDG 
 GC}"X =` ]G b CG4BDG `  ? = D{  H "FFv  7   Bo@bCGGTGtGFZk .   , CGtGJhbEHFCGaA@ H ݤ ""GH bDDH ݴ #.&vH. . #/J}WJJY8KFѐ`JFBJ CGADG @ G Bn@CbGGTGtGFZk . ,  G CJbFHCFGtG\A@  ? H  ##}"bHDDH  ." C/'vH...J/ZYK=JUJJXKFGFFBJbJѐ J CG_ADGT  GG` =, .% ="K ( }.'H% ].P
JSqJ0D1Ht1HRQJuF( }>TF% ]>ݦGG( 2Jz3J96KFF:GGG( ݶ}#C Cqb#GTG@. =,+ ,  C( ݤ+   bHA'HpH@H1D. =< D+ < ݴ G .  C . "  ]HVJCwHUJGGFF > > C ]GGtG+0BGx GGGbtG ,  eHG HD  <x =XVAG]]}ݤ #kGH = &s" 3D1F1F(H $DFF%H "H0FF"?H ]BGQGG0#
 0  ^C ~tG   ޴ G  ~G ^
 , C" .G c.GG HJH {SrJGFP|ADGG8 bGg    C" c.CtGF .SrJ CJGF@DGW   = C" C c.C .1=Jp JGrJX bTJFtFFG }GTGYBDG?    B@C( bG GGtGEZk  B @( bCGGtGEZk  B@( bCGGtGEZk  B @( bCGGtGEZk  B@C( bGGGtGEZk D. GG $  sb#sHR AJP  SF@ D> CTGS@p Bx b C4GzZk@ . $ GqHbP J@F >GGtGUAG ] ] }   ݤ  #k# p"8^B@~
 0 H "PtGX޴`hG  ~0#0^G( =G P.#
 ,G .GG SJrb# H JG CL@ D` B   #. . # GCB!Jb#PJTG0FG_ G  CCG@   C3!HG4u`B
B- `,   . "@B1AJUJ	4BJ C@0@ #  .4B5JWJ BJAB@0@ G#  '/4B7JY:K B'K@0@    g/4 C9!K@`K BH@ 4 @ H0@  B? `G  . #0@B CVJABJ4B:AK@0@ BBBG5Jrb#7Ju@w@B  5/0J  7.C  p@ 5K 7JGGtG@ D   c. . # ` "G  aJPJGb#pFG@ Cn_ GW G0 @kb# C4G@G C@kb#G4G@ . " .CG0"Jsb#UJ CF CGC CG@D8  . . "GCJsb#UJC0"F CGGC CG@D$     TGDDD                                                                                                                                                                                                                                                    J                        p $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        : "            G  #" .0# = "2J . .UJG CJ  ^0=" b#F  C C4'H ޴ C JG4G@( GGbG ,  eHtGG HD  <( =TAG0]8]@}HPXݤ`hp#k# p"  ~
 0 ^B ^ "(~tG08@޴HPG P.C
 ,G .GGGFSJtb## H JGGj@DGG)   . #" c.H . "Jpb#SqJCGF JCC  G G4GGF@D  ݤ	 d" .TGqHP JF > ]GD	 .uSJT JF	 >D . "GxHbW J@F >GGtG.TAG] ](}08@ݤHP`#kG# p"  ~
 0 ^B ^ "(~tG08@޴HPG P.C
 ,G .GGGFSJtb## H JGG@DGG)   . #" c.H . "Jb#SqJCGF JCC  G GTGG@D  ݤ	 d" .TGqHP JF > ]GD	 .uSJT JF	 >D . "GxHbW J@F >GGtGSAG] ](}08@ݤHP`#kG#
 0  ^TG  ~( G  ~G > ^ C"
 ,G . c.G HJ( {SrJFwA =GGbtG . ! qHP JF  > =GSAG ] ]  }( 0 #k# p"  ~
 0 ^B ^ "(~tG08@޴HPG P.C
 ,G .GGGFSJ@ub## H JGGr@DGG)   . #" c.H . "Jb#SqJCGF JCC  G GtGGN@D  ݤ	 d" .TGqHP JF > ]GD	 .uSJT JF	 >D . "GxHH bW J@F >GGtG6SAG] ](}08@ݤHP`#k    p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #kp#
 0 X^pB`~hpx޴G  ~GH >GP^G
 , H@ BAB .  R"G Jݟ@ GGb#tGTGtGg_9 GCgb# CGtG@GCgb# CGGtG@GCqb#G4G_@@   GhbtG%vHG8D
  C.tG ,GDJ@H@FLA G .   , CGGJ0b#DH4GFCGGGj@GH GGbG ,  aHtGD HD  <H =RAGP]X]`}hpxݤ#kG@#  C  ~
 @"x > ^ ^ ~   ޴  G
  ,GG 2HC@ " .&@ pB JGdBB / "@aB KG@<  ; @G9 `gb#GGtG>@G Cgb#GGGtG6@G  gb#G CGtG.@ .   ,CGGJbEH4GFCGGGhADGG  .   #, C =GJ8bA&HGFCGNAG GG8b#tGTGtG_x GG(bG ,  dHtGF HD  <x =RAG ] ] }   ݤ   #k#    ~G ^tG G 1,GH{A  H 1<QAG ]   #kGP#Cp ^PB@[tGx ^ ~   ޴ G  ~Gh >GH{GGTGAZk , # a@ H@`@B
 P. 
 "G PJG@	 Gxb#GtGTGtGT_B GX =CG C8hb#tGr1 H!V H!HAFGX =@GC8hb# CGGtG@GCqb#G4GE@`   GbtG%vHG8D
  C.tG ,GDJ@H@FfKA G .   ,CX GJG@Hb#%H F CHGGGN@Gh GGhbG ,  aHtGD HD  <h =sQAGp ]x ] }   ݤ  #kG# p"  ~
 0  >B ^C  ^G( ~tG0 8 @ ޴H  P.G
 ,Gx[G SJ{ HGTG
AZk , # Ba@bG HG`@ r" .@4GT J >  [vZk @   = "G0 bGq1 H!V HG!H!F = .!&H .G&HJUJGFGKAG GGGb#GTGG_ GGbG ,  `HtGF HD  < =QAG ]  ]( }0 8 @ ݤH P #kG0#C^PB[tG^~GG  ~G{GGGTG@Zk , # Ga@b# HG@ @GGTGn_G/ x =CG Chb#tGr1 H!V H!HAFx =G@x  .   #,CG%H JxbA H CHFGGGADGG
   . #" C.4GH bGJRQJ =FGAG . $ GqHbP JGF >GGtGPADGV  } Pvb# C4GN@`   B Cb CGtG~ZkGCsb#G4G@Ә }G#v`H> `GG#vH Cb CGTG`A DG,   =b CCP D&  TG5dA D"   =  CGTGX b0D   CkAGp>b#  "4G4GGGG~@G CbGTG`AG  "p>b#G4GTGGGo@Ә }4@ vH#v`H	@G]]}#k0#C ^PB[tG ^ ~   ޴ G  ~G >G{GGTGZk , # a@ H@`@B
 P. 
 "G PJG@	 GHb#GGTGG_9 G =CG Cib#tGr1 H!V H!HAFG =@GCib# CGGtG@ . ,   CJG@Hb$H F CHGGGGADG  .   #,CGGJx =A%H( bGFiAG GGG8btG ,  aHE HD  < =OAG ] ] }   ݤ  #kp#CP ^PB0[tGX ^` ~h p x ޴ G  ~GGG8{GGTGhZk , # a@GGhb# HG@ @GGTG,_G[ H =CG C(ib#tGr1 H!V H!HAFH =Gs@H ݤ .   #,CG&H JbA H CHFGGGADG:  CM_H @@ G0B;V Kx1 KaKCG8bH GtG&Zk0B@C8bGGTGtGZkB Ё@bCGGTGsZkB CbG4GqtZkB @b @CGG4GhtZkBGb2 @GGtGZkG $,  GpHXbA  H@0D $<GGtG2OAGP ]X ]` }h p x ݤ  #kp# PBP ^C`[GX ^tG` ~h p x ޴  G  ~Gh{GGGG~Zk CG_H  ## .C c/ CGGJ[yKGF( bGkADGG?  C_ G =C`B@Œ Kې K%VH;aKH09KeGqHhbtGFG GG~Zk`B @hbCGGTGtG~Zk BЁ@  bG CTGbsZkB Cb4GsZkB @b @ CG4GsZk@BGHb2@GGtG~ZkG ,  GaHb@@ HG D <GtGNAGP ]X ]` }h p x ݤ   #k0#C ^PB[tG ^ ~   ޴  GG  ~G{GGGGK~ZkBa@bGCTGtGC~Zk ,0b@G HGC  GGb#tGTGtG_{  CGI_ӈ }G  C:V`K{1`KAKCzG ]tGGib#K@ӈ ݤ .   #,CG&H J }A H( b CHFGGADGV  C%_ G =CB@Œ Kې K%VH;aKH09KeGqHbtGFG GG}ZkB @bCGGTGtG}Zk0BЁ@  8bG CTGrZk B C(b4GCsZk B @(b @ CG4G;sZkpBGxb2@GGtG}Zk8 > ,>  ? $"H@ HaHG D> <vJ8 4GD? D.JsJR QJSF? D>D@ .F@ > " /yHG@bGX KGG ?tGMAG ] ] }   ݤ   #kG#
 0   ~pBH >CP ^GX ^TG` ~tGh p x G
 ,G[G{G H}Zk
 ,
 # a@GGb# HG@ @GTGGL_ G@ =CG Cib#tGr1 H!V H!HAF@ =G@@  .   #, CG%H J( bA H CHFGG	AGH GGtGb $,  pHA $H0D  $<GH =MAGP ]X ]` }h p x  #kG@#Cp ^PB[tGx ^ ~   ޴   G  ~Gh >G{GGTG*}Zk` ] #  ,a@Gw1@J2V@J HAJ@F`@B
 . /
 " P/ 0#` ] "  G PK J@ K	 `G(b#GtGTGtG_6 GGCib# CGtG'@GCib# CGGtG@ . ,  ` CJG@Hb'H F CHGGGGWADG  . #  #.CGGJ( bQ!J CFX = CGGĂAGh GGbG ,  eItGD HD  <h =MAGp ]x ] }   ݤ    #kGP#Cp ^PB [tGx ^ ~   ޴ G  ~Gh >G({GGTG|Zk , # a@ H@`@B
 P. 
 "G PJG@	 GXb#GGTGG\_9 G` =CG Cjb#tGr1 H!V H!HAFG` =@GCjb# CGGtG@ . ,  ` CJG@Hb$H F CHGGGGӘADG  .   #,CGGJX =A%H( bGFAGh GGGHbtG ,  aHE HD  <h =LAGp ]x ] }   ݤ  #k0#C ^PBP[tG ^ ~   ޴  GG  ~G >GX{GTG!|Zk , # a@ H`@@
 0. .	 
 P"B " J 2J@GG	 Gb#GGTGG_; G =CG CHjb#tGr1 H!V H!HAF                                                                                                                                                                                                                                                   K                        ?!l $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        t "           G =!@GCHjb# CGGtG@ . ,   CJG@Hb%H F CHGGGGQADG  .   #, CGGJx =A&H( bGFCG[AG GGGxbtG ,  dHF HD  < = LAG ] ] }   ݤ   #kG #C ^PB[tG ^ ~   ޴   > ^ ~ GG  ~ CGG{ CGGTG{Zk , % BCb HtG	@!AGGG{ZkA 	,G   )  Ha@BA	P"A  GGb#GTGGI_Ӥ Ð CtGp1 H V HH  F G_GCjb# CG G@GCjb# CGGtG@GH !8 b C4G:A  G G  C! .C #- CG%H
JHbI*IH	FGGGAD GDtDi G . C! #-CGG
J }I*I =( bC	FGADGV P B
@ !X bG CTGoZk@ B CH b4GG|pZkB@b@2@GtG.{Zk ] &  - CGʐ@IH IeFI	P@E = D &.ǰHrHQ !JG2F &>_ӰBCbG GGtGzZk& -&  ) ]- &! ," "IJ
EI@ 	H
E C4@DGaH " D <" =.G% ].GD .0JR
PJ2F C4 B FU JvtJF > / "GywIb@X KGG ?GtGKAG ] ] }   ݤ   = ] }  #k0#PBx ^tG ^ ~   ޴   > ^ [GC  ~G CG{G CG#GTGzZk , % G H@@
 0. .
 
 P"B " Ja@ 2J"A
GG GGb#GTGGQ_P p =CG Cjb#tGr1 H!V H!HAFGp =@GCjb# CGGtG@ . , C!p =C
JG@
Hxb)&I F C&IGGGGɖA	DG&   . #  #.CG
CJ  Q!J( bCFGh =@ G CGGAX  F- "GhHJ FITG
HE F=` =GD &.r0HQ 0J2F &> . d"GuHb@T JGF >GtGcJAGx ] ] }   ݤ   = ]  #kG#PB ^tG ^ ~   ޴   > G`[CG  ~ C =Gh{G#GTGyZk , $  H@@
 . P" .B 0.  
 "a@ 2J JB "@B J	GG  GGb#GTGG_~ è =CG CXkb#tGr1 H!V H!HAFG =@GCXkb# CGGtG@ . , #! C	JG@	Hb%H F CHGGGG#ADGT  . #  #.@ =!GGJH bQ!J   C ޶F = C CGG[ADG> 0  C BTG(b4GGmZk5  GC0vb#G4G@Ӑ %vH, G)vHCx b CGTGYADGG   !h b C CPD TG\ADG  BC(bG CTGmZk  G CX bGTGYAӐ 4@%vH'vH
@ GGGbtG (- !`HI (I	 E  (= =IAG ] ] }   ݤ   = #kGP# Cx ^4GG ^ ~   ޴ G  ~GG@ub#p >G@h  v H 8 D   C. . # GGAJ( bPJtGPFtG-CAGY GBPa@bGCTGtGyZk ,  a@ H@`@!@
 !. `
 ! G !JG@	 Gb#GtGTGtG_9 G` =CG Ckb#tGr1 H!V H!HAFG` =@GCkb# CGGtG@ . ,  ` CJG@H8b%H F CHGGGGCADG  .   #,CGGJX =A&HbGFAGp GGGbtG ,  aHF HD  <p =HAGx ] ] }   ݤ  #k0#C ^PB[tG ^ ~   ޴   G  ~G > CGG{GTGxZk , $ G HC@
 P"
 0.@a@ 2JGBaB . s"@ JB@D C GA  x =GG{1 K9V KG!KyGx =kb#tG@G(  kb#G CGtG@G  kb#G CGtG@x  .   , CG(IJXbGHCIFGGGGADG  .   #, CG CJ =A&HbGFGAG GGb#tGTGtG_Ӏ GGbG ,  dItGF HD  < =cHAG ] ] }   ݤ    #kGp#CX ^PB[tG` ^h ~p x  ޴ G  ~GP > CPBG{GGTGwZk , $ b@G(b#G HTG@@@ @G_G0 H =CG Ckb#tGr1 H!V H!HAFH =G@H ݤ .   #,CG&H JbA H CHFGGG@ADGG   . #" C.G( b4GJRQJ =GFG'AGP GGGbtG ,  aHD HD  <P =GAGX ]` ]h }p x  ݤ  #kp#PBX ^PB [C` ^tGh ~p x  GP >G  ~G({GGGTGwZk , # Gb@Xb# HG@ @GGTGR_G/ H =CG Clb#tGr1 H!V H!HAFH =G@H  .   #,CG%H JbA H CHFGGGғADGG
   . #" C.4G( bGJRQJ@ =FGAGP GGHbtG $,  pHA $H0D  $<P =GGAGX ]` ]h }p x   #k#4G ^  ~( GG  ~ >   ^G . #,G JA H( {FbA GDGxbtG 0. "r0HQ 0J2F  0> =GGVGAG ] ]  }( 0 #kG@#Cp ^PB[tGx ^ ~   ޴   > GG  ~ CGG{ CGGGvZkBa@bGCTGtGvZk ,G0b@ HGC@PB P. ` "G PJA GGb#GTG	G_Q  CG_X }Ch G:V`K{1`KAKGzGX ] CGtGxlb#  @G	Cxlb# CGGtG@ . ,  X CJG@Hb(I F CIGGGGAD	G!   .   #, CG CJ` =A%Hh }( bCFGK~A  ,	GG HH& 'H0VHE@JDP@$   &.rJQ&J2F  &> d" .u3IG@bGT JGF >tGFAGp ]x ] }   ݤ   =  #k &,A&H%DG &.
JQ
&J2F &>#C ^PB[tG ^ ~޴ (0>8GG  ~G >G{GTGCvZk , # Ba@b HCd@
 P"
 0.BGG 2JG@s@@GTGtG-vZk@ ,  @lb#  C HG&A @ ݦG }GGtGx1Ju1`J3V`J6VJaJJF }G ݶ9@Gx !lb#G CGtG1@G0@lb#@  G CGtG(@Ӥ@ G  .   ,C =GJG@HXb)&I F C&IGGG\ADGG  =   . C #,C)&IXbJA&H&IFGGIADGo  . #! , CGG	J }FH =8 bGFAӀB&N@bG CGTG jZkX   , , #!0  C"HbDH&IDaH &D0 =!v<H #.5 " =# C 2J;  1"JDK!FB3@0 =G8 .f$K5 .2H@WJVJ8 >5 > CG8 GtG86K8 G> ,; =-EHI$ID	&E> <; == ! ]tZkG0    b C CGtG!JB   ݤG ." #-GGHJ }I(I( b2GJ	FaA GGb#GTGG7_ GGbG -  iHtGH I	E  = =EAG ] ] }ݤ (0=8@#k#C ^PB`[tG ^ ~޴ (0>8GG  ~ C >Gh{GGTG0uZk , $ `BChbtG H@
 P"
 0.a@ 2JTGBB@GGGuZk@ ,  @  C HXmb#G&A @ ݦ }GGGx1Ju1`J3V`J6VJaJJF }G ݶtG(@Gx  Xmb#G CGtG @G0@@  Xmb#G CGtG@ ݤ . ! #-CG&HJbI(ICH	FGGGGOA	DG      . C #,CG(IJbA'HIFGG<A	DGGo   . ! , C }GJ =GHX bF@F9A	DG_    B C( bGTGiZkX   #- ,  0  C"$I bGH(H	'Ea I &E0 =!v<H #.5 " =# C 2J;  1"JDK!F B3@0 =G8 .h$K5 .L@WJVJ8 >5 > CG8 GtG86K8 G> ,; ,EHGHDD> <; < ! ]rZkG0     b C CGtGIB   G .G #-GJ }I(Ix bH	F2GJ^A GGGb#GTGG)_ GGbG -  iHtGH I	E  = =DAG ] ] }ݤ (0=8@#k#C ^PB[tG ^ ~   ޴   > GG  ~ C >G{GGTG"tZk , $ BCbtG H@
 P"
 0.a@ 2JTGBB@GGGtZk@ ,c  @a  C Hmb#G&A[ @ ݦ }GGGx1Ju1`J3V`J6VJaJJF }G ݶtG@G@  mb#G CGtG@G0@  mb#G CGtG	@Ө ݤ . ! #-CG&HJ8 bI(ICH	FGGGGAA	DG+      . C #,CG(IJ8 bA'HIFGG.A	DGG   . ! , C }GJ =GH( bGFAG GGGb#GTGGs_Ӱ =GGbG , )!hHtGG HD  < =CAG ] ] }   ݤ   = #k#4G ^  ~( GG  ~ >                                                                                                                                                                                                                                                     L                        q5 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        qx "            ^G . #,G JA H( {FA =GGtGb . ! qHP JF  >G =CAG ] ]  }( 0 #kG#4G ^  ~( GG  ~ >   ^G . #,G JA H( {F.A =GGtG(b . ! qHP JF  >G =|CAG ] ]  }( 0 #kG#C ^TG  ~( 0 8 ޴@ GG  ~ ^   .G #,GG C J( {A HGFWAD0 BG  8 b0@GGtG*sZk %,GA $H %< GC_CXbGPB0@ GGtGrZk .   #,4GG JA HH bFfA %.tG4Dr%HQ %J2F %> d" .uHGGxbGT JGF >tG CAG ] ]  }( 0 8 ݤ@ P #k# PB ^C[G ^tG  ~( 0 G  ~GG{GGGrZk CG_  . ## c/ CGJ[yKTGF( boA $. "G! HbQ 0J $>D d. DtHGS dJGtF d>4GtGBAG ] ]  }( 0 @ #k# !B ^TG ~  ( 0 ޴8 GG  ~ ^ #  .G C.GGGJhpb#RAJGF>@DGG   . #" C.TG( bJRQJGFaADGDG . $ qHGb@P JtGF >GGBAG ] ] }  ( 0 ݤ8 @ #kG#PBP ^PB0 [CX ^tG` ~h p x GH >G  ~G8 {GGGTG;rZk , # Gb@hb# HG@ @GGTG _G @ =CG C(ob#tGr1 H!V H!HAF@ =GG@@  .   #,GG%H J
b#A H CHFG4GG@GH GGX btG $,  pHA $H0D  $<H =GABAGP ]X ]` }h p x  #k        #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #kp#tGH ^GP ^X ~` h p ޴x  G  ~GG0 {GG#G CCCYAD Y  qH2v`H( }0J &0FFGB9'K G /
 ";H
 .6Ky6KvK{vKGFGF ?
 > ="G .H ].pHTJRQJFPF >C ]>1 `GG_? 8 = 8HCGGBCCG  7G@ bC  ޴ C CGBDG 8 =CP bTG!v H  @ 0v J0 =G1'J-BD G( =0@@ G@?GH ] DP ] @X }`  Hh p ݤx H  #kGp#a J  ~6v J  ^ &(^0^8~@HP޴X`h>p^x~ GGG HG  D DG ~#G @ G >.[J .r[J  >Q;JPJ3F >>F >GG ْ KGp^b#a3 K56J CF >  G .J /qHP JX KFC >G ?GGTG@@  ' &"	G 0D   ?& 1D  G6DJ	4G 2D  'GCGxbGGGGI"BD
G[   B"b CGTG<eZk   =GCGbѐ H CtGBH   DE  BCbGE@TG(eZk>  BC  "bGTG eZk6  G  ' CH bCtGBDG
G+  D8 b,("E9" C C ] C C CG-AD
G  9(.9":H.0JRPJ2F(F `9"  3.8.GGJVJGFBJ(b#_ 8 D G
GG)v Ib C    'TGBG(] _E0]8}@HPݤX`h=p]x}#kG#q J  ~0v J ^ ?$  C GGTG( { H  F D @ GGG!BG ] D  0 #kG#4G ^ ~  ( 0 ޴8 G  ~G ^G . #.  0 [G J8 {Q
 JG F  CGeZk1    . #. c" C.tGJGQ#J( bGF SJ`@wB   D  GS  . # 
 #.G5J .J  d.Q!JJF"HuJ7'HFJwJuFF >wF  d> G   E/Z EK  E?G5 GGX bGTGBDG,   "*   $. D.G7J
 .0J .RPJ "2FHJ9HwJ4Ky4KFFFF
 > >GD #, c# ,{JGA;Hf{J@HH b0D #< D <GGTGBGG ] D ] }  ( 0 ݤ8 @ #k#_F8^G@~HPX޴`hpG#J0^G%!J$v`H  ~ CCCGG_b#G'JG# CGGGռ@DG   =#v`H(  &  ]
 "1<Jp JVJFFs@ }yVJG /C
 .   }"XKWJG ?F
 >G }ՒJIa3J 6KrI D CG .Pb# },&HTJCsHFrD > }<CGG_DG^ `( D  =DG CF} Chb5'H  H  CGbADGJ `GChb CGTGOADG@  4GPD H   %,peHA%H0D  %<' ( } C  =GGF2'J C( bGADG$   g,gH5 G `(   =b#F2'HG^_
  G C8 bTG  , HGcA
 À}  ,  C. HCJ `G CH btGfAGG0] E8]@}HPXݤ`hp#kG %,
eHA
%H0D %< ,EHD ,FHD#^~޴>^~G(v`J  ~^GG#GGGGG0{#[
@D	G|  &"E
G4 F GGh b8AG	Ckb#G4GL@x =)v I   B CbTGGcZk  	G_GGCbGGGGGGA D  	GPGC(@b#G4G@DG	GF   } Cx bGGG^AD	G<GCb CGTG?AD	G28 ="_&, 0 ]G¤4G( =	GX GC  ^GCC  =Gb C GGGGwA   C0@GG BC(b CTGtGnZk   BC(bG CTGtGnZk  0`A!aAPA? 	4GX FF	FX =?F	)F  	G  bCGCG  =GbC  ޶ C G4GGwADB E	G xEG  = CX bGGTGGGtAD	G@BCHbGGGtG8nZk@B  Hb@GTGtG0nZkCG  8 b &,Gp J C0D &<
 @.
  "GsqJ"SF
 @>C@  C  =G  G 4GGGwAD	G  C	G .8E  !  J  8Ez  BCH@(bGGtGtGmZk2  C	GH !K    ), 	"  ,.CGA0H ,J'H 6#!!HG	!B `!F   V/{yKX   =C[G V?GF8 b CG   C G4GGxwA !A )! C	G  ,     H  UGH GC Jp J1 JА Jq1BRB
pB 2B 0B BF FwJB . "TJJ 4G0J C F  	TG7C y;v`K `G`    b C` TGW`A D  	G'G  `  C ! $0v JG+V`I?D!!HaI+D	0@  	4G BC !(bH@ CGtGtGmZk/  C "H } &, "H ] &!EH ݦA0H0@J'HPJ!!H	aA  aE   f.StJgJ3aJ	SB SF @ .IJ'I)!I	B  	F
    =
G ]#8 G   C	G d/   dK  GG C  = ChbGG|wAD	G   }8`ED `GG bB 8 D>  pP }!G  X    = Cb C  > C  CG4GGvA D  	4G CG_G C_ ¢GC C  =b	GG  ~G  CG4GGsvA D  GCC  K@  `A_'@0@6@	@ 	TG G  }CX"C  ^X  GGG  wb C C G4GGNvA D  4G C4G "_  CI@   C_   !A0@GGCG b CGtGSAD	GY   }G8`E! `& 'q@
@C   G  A	A	A 8 D   &8 D   8 F   &  8 F
  _ `  0A	A  8F  G ChbGTGMAG	CbGGTGPAD	G$ `CG C =G bGGGA D  Ghb CGTGLAG	C  ]bGGGtGTGG0
BG C0>b#4G#~@	G?EG`   C  =CbC  G G CG4GGuADH 	GM CH }C8 < ˒`I W#v`I5JCF< r  /   7/C CEKY:KH'K v H	@ 
G   4G "D@ uPJ . "wVJT JF >?F q-K vIwE q=[E  C   e/5 CCYG
   `K  	D   l. 5 @fHS dJfF l>GCG  =8 b C  G4GGGuA	GG?E bC8 GX4AGb# @ $v`HG $b,ICD@G  CGtGlB =,,D@ ,  IGA$HbrI@HCC3D =< D <GGTGBh ݤ$D@GC  4G b CG 5HG_"GG^A `#`H $  cc@ EATG ,4D ,H@HaHDH DD < < ð"#`Hcc@  QC@ b. B.SbJRBJ b> B>GD]] ?E}ݤ=]}#kG8CG# C( ^GGTG0 ^8 ~@ G  ~GG{ CKADG"    8bCTGP F   CkOAG C( b CGTG<AG C8 b4G;
BGC ]H bGGGGTGG 	BG(b#	 @G( ] D0 ]8 }@ P #kG# C( ^GGTG0 ^8 ~@ H P G  ~GG{ CKAD =C    2v`HG1>J@ b=   &QF3BC =C GGTG=B C  GGG0 b*.AG CP b4G=VA  1 @ CG Cp b4G[*A `HG  $e @b#%@ !. A.                                                                                                                                                                                                                                                   M                        Ȝ[ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           !JR
AJ2F1v H@  G4G` b@ . $,PJ >A$H $< C[AG( ]0 ] D8 }@ H P ` #k#4G ^TGG ^ ~  G  ~G8 {G CmiAGb#_G C( b ?"TGDKAG CX b4GgAGfb#G@G ] G ] }  0 #kG# C  ^GG( ^0 ~8 G ^  ~GG ~G8 {  CGGAD	  G = C ]G } ( b wAG  ]( ] D0 }8 @ #kp#GH^GP^X~`hp޴xG  ~G8 {G8 >GG@ G+AG Cpcb#GGTGu@G Ccb#CH" C CGGC CG@DGG  C cb#GGTG@ӰBH b C4G_Zk	  BH bH   C CTG_Zk BH x b C CTGLZkBH Cb CGTGLZkGCb CGTGJADGw  =H"G CbCP D  0 =G( ?F3J C C CKADGc  G4G  G  D0 FP FrF  PDDǔFPD  DTFO pF   GJ DTFG  =;v`H0  $8 ]
 ="9<K( x KzQ@KG[GGC HG .vH
 ].( H TJRQJF >VF
 ]>G ĒH Cw3H56J ]#F HG =,eH /CA:HXKG D =<G ?D@ ]G= C( bG-BDG	 G Cb4GTAGbG,AGH] DP]X}`hpݤx#kG`#GP^GX^`~hpx޴>G  ~GX {@ ^GGH %!J&J'H@.AG Cdb#GGTG@G(vHPdb#D CCP" C CGGC CG@DG	G  8 b CCTGIAD	G    	GP F   G( =P"0 ] CG C3'Jh b_F CCGAD	G ` =!D  	G GGCGcb#GTG@GP } pcb# C4GTGַ@ D  	G PBP Xb C4G^Zk	  0BP=!8b C CTG^Zk GBP=!$]@b CGTGKZkBP} 	Cb CGTGKZkGChb CGTG!MAD	Gu ` =%vH0  &@ 
 "!<H( =dH( ]pQ JDF%D3@ =G .5J
 .x5JWJVJFF >
 >Ғ@JG ]`3@JP}  C;6_K "G `G G }.pH ,H apHSpJ( bEH$vHtF }>D <8D] DD8 C C CGG-BD	G1 `' G CGG]GD
 DD8 ( b C C-BD	G `8`DTqD GDD8 C] C b CGGY-BD	G	 `G Cx b4GSAG bG+AGP] ?EX]`}hpxݤ=#kG#  ~^^~޴ >H G &v J( >?FwH(6H08?HyH F G( >G vQH7v?HxQH0vJGFF ( (aJG ^Gq I4J;]Kv IqGF >( >9>H
 @8@F	 @  $0J B   C(  GG } &( ;~K4JvC }B( GH =9'KG2 .- ]"3'H- .2Ky2K rJsrJFFGFF2 >7J- >" . }#!K .JGwJ;Ha;H@db#FFP="FF" > C >GTGc@GP @db# CGTG\@GP db# CGTG@6 .3 }.P}   C3 ]"HTJurHSrJCFuF6 >G3 }>C Cb#_Ddb#G G CGTG@& .# }.  C# ]"HTJurHSrJC ="FuF& >G# }> C Cb#_DH }GG2 ].3gJ- =.- " =5gHpJspJJuJTF3FGVF2 ]>5F- =>;gK" =/ " /$'HwK{wKHdH GG:GG" =? ?G@ 4G6 ,P="3 . C3 "P UJ@Ha5JVJ D6 <F3 ># ]/P}"& }/ C# =#J`yJ[yKZYKaG@G& }?# ]?FG Cfb#4GP @M  # .& =.# = B2N@JbQ
!JTGF CGG4G[Zk,  # =,& .# } G4G#Hfb#P
J0D Cַ@   # ].& }.3 } 3 =,# ="6 .QJS
qJG#H`fb#P
JSF0DC C CGtG@& .# =,C#  `HP Jq`HA HF1D& ># =<CGC"HbG &G@ ݲ CGGB D  / GGCCHb}"GG CGGB D  6 .3 .=  CG3 "`fb#tJVJw4HUJP="FF6 > C3 > CCtG@& .C# =,#  `HP Jq`HA HF& >1D# =<0 BC "8 bG CGtGGfZkDH =G	E#v`H( b}"2'H C C C CGtA D0 B  C = 8 bG CGtGfZk[  Dp BK  x bCCGtGfZk . .P   CG }"Hb3HUJvHTJCFF >P}" >G $C8 } CGG:B D   = CG C( bC2'HGG:A D|  * GGCGHbC8 }P}" ?&G C1"GB Dm   }G C( b C2gHGGGA Dc  
  }CG C( b C2gHGGGA DW  }G=!= xbbD ` C C C CGA DJ  ( }C0 =GC } =Gb#2_# =-# } & ,!N@BG#Ib@
HTG  E  CGZZk  # =,& .# =! }TG)HGP
	Jcb#0D Cp`H@ D$  G	CCX bGGGtGcB	DG  G GG 8`DG`DG GtG G	 TG G G G GG _G]]}ݤ = #kG # C^TG~޴>^~G%Jx^GG&vH  ~'!J{0 ~GF(AJ CGJAD	GG
G  H bC4G>A C  ]GGG0eb#TG@AD@G
Cpgb#G4GT@,v HG8= eb#
8E @ CGTG@0 ] EG8= b C2GI C CGGtA D   X D
GTD  =h IpQH%vH!<HFE%D ?&1@
 " =G .
 C0 
 .  WJ0 }JxJVJFF >
 >Ӓ`JG ]`3`JEIreH;6_KG8" `G G =,C =.8 b CA%HQ%J4D =<2F =>C( GGG
B D4G_  Dd _G8]!eb# CGTG@ӐB P@b CGTGYZk  B8!b
Q@ CGTG5HZkB8]!b8! C CTG-HZk àB8]!8!b C CTGJZZk .8]! =,
 C  G@Ih bTJu@IA H8!F >5D =< C C C CGnA DG  
CbGGGGG'6BD
GG!D C8 bGC CGGB DG 
G 8 EG E
GG C( =TGx b_EsBGjDx]] ?E}ݤ=]}#kG# C ^GGTG  ^( ~0 G  ~Gh{G>A D  0"G Cb#TG!  C_ G  G0"C0 BG8 bG2BGGGGYZkT @  4 @
    8 DG @G 0TGGb#@" C_G FG ]  ]( }0 @ #k0 CGTGb# @G_  b G  C_DG# 4 B  ^G( ~G0 tG8 G  ~G ^G  @ [H {CGdZk GG CX b0v`HGTG=ADG
    GGTG b#Be_ G G  "C` BGh btG2BGGYZk  8 D    G	B G  GGG b#TGI_ DG ]  ]( }0 8 @ #k#"  ~{# G ^_G ]   #kG#; ^    ~  GG  ~ ^GG    !#`H TGcc@#@ !" a.H A.tHGSqJRQJuFTF a> A>*  F"  $    b  F  A    srB `G	 0@B  A Gb#"_GDд8DB#`HF    Rcc@4GC@ " .tJ .wtJVJUJF >F >G ] ] F }  0 #k0 #G  [ ^    ~  ( G  ~G ^  0 J  R TGpBPB 0" .H p.uHGTJSqJFuF > p>-   b2 JdRB   @ `" . .JU
J F  C X D  G 8 F( B X F    r31`B  r Gpb#_G  c?D
  d@TG . C" c.2Ju2JTJSrJFuF > c>G ] ?D ] }  ( 0 #k#Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#  @ ^TGH ~P X ` ޴h GG  ~8 ^ C" ,C 0,G .G c.HGA HJ{SrJ#DFG4`ADGG  0  #"H bTG     . C.JRQJGFRA . ,4GGJ@Hb# F_ GGGP`b#@GGb  %A . ,4GGJ@H8 b FAADGG]   . #" C.tGbJRQJCFG\ADGO   . #" C.4GGJRQJx bF
4AD GA   C. #" c.D@ #QJSqJJ0JSFPF &{JB CG ]/0vJ =/ѐJZXKY8K@G ]?;GGG =?tGh bBDGG  X bCCTGBDG   . " .C  =D@JGUJ  ޶GbF5'J4G ޶G_"GG)VA  $GtG(b
   !. "rHQ 0JG2F !>G  $,3ADG 0b# C4G_G8 ] G@ ]H }P X ` ݤh p #k# ^ ~  ( 0 G  ~ ^GGG       @G4Gb# @Gx_3 @ `Gb#4G @Go_*  #.   ,TG@"G$Jb#@H&@ FGa_  ,   #, "GGHbA HtGD  $.Q 0J $>GG2AG C0b#4G_Gb# C4G_G ] ] }  ( 0 @ #kG#
 0   ~ ^  ^( ~0 8                                                                                                                                                                                                                                                    N                        6 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        D "     R      i;(jIM^/CNwg7DZ5V4š({Z+Cr׎eq
n=7s鼉%
vt+ekf <Zv
7-n=K@tu[9-7*GuzT^1MM :VS+mQ74_HlUZ
y-\d5*XCi,SQ衇lI:0|%Ng{s6Sr8-㇓.:#7@qWeވʵKg8
"4i>`h
T͇1¢>KJR빇O5c3Ezҧ)ˇЎt9qje"X_E4SWDC\ϿY6b~	v8K<ׁU)[UddDKmHi#}dP'~,IovY9/('zSV@]NH)/Xlu~fnM/U`DgI}@V
<M!M/*c&z8/Ӗ(i	x)<sDN]%	cpEDd#$^vitлᶼ9ϷVlkuo萛f2XVio΋~g(2C݃Fs/Z߀7;P;A3ZEjri
3}Jt>|Kul*Ey"}qK'E}H(GefԼf2G7,WpN[m`雕O-DT8^SLh':2uTG{tQ}tZ,F+آ!ڼg&)s*cZOjIhTDbu>dyl88.ӮJS@7uśan(`ՙl;-#X|V3\H0a;̺=]_sjL,*ɚb,)VN_%V
u*]<T&V`&hEEM Fh5غ8fsF1h6L~sJ
KجD5srPM"d{:EcǱQ3.l/67VȋצW+;f+eV>UUYn041-LGvuD':5&lS{b/<vQMDg=3V89IcŁ>av,È,kԪBҘNY`1k;Qw./ IۥOJh<16X`Eo8v|iI﯆Z2{컿mS5UP]8
~[7?pJ}Rxb{8 `*Js3}4FZהh7)޿iMN5(F"c3j"Lc񷣡|\Dcڀ~0,8طiP4@()k4$2,7pS: |P"%]]䣸,`[4aH0+*xG#͡Z59o 흣=ǤK"`,?ԗ	'=Tҟ5R,`#͞.J52ڱ j<n~RlmU/v ?Xn'ty.bXGQ
@Ȝ'n-^3Q^-v?r'K_ wT#0340u3]ܡ4}Hx B	.Y,>@޾wr`}I[q8n"-YnZGNce>|qǱ:
U+<CILo(p6hLv ڠ}dZ:t%1SUGAGI-4y+'W@bJ57`uw;ͺ:O+H͛knuY!Y&ǶLғ/jkcn-~ֽdPQ`}_1۵9'$|[ؕ$hPq)ŷ tk/0\ּ
8_TK0V =<JמRqtBzfJZTj|jfnQRȸ.#tI\n~,BB6]/ϖ%A_pe#[	a&/lWCYODjN"icX|<ljr<) L)of+:7}rW.2U;&k&MId
ːoa_eU=
S(;>*~`n\&+ܯy%tɰGx`ZQΙK;IVR+}nI'W(YFUD4=KpL	b60W
1W["Z<Jq!cc|P&		I5Xj7~	4mz+p&0 1gR ܛ	Bdv>o
xƲ2'TpuT6sj
`AsS˱[eZ=Ɵn-,%ȟf >3nwRe>okBnjZͭq	Zmj i²$[E?Mw١"D=A}Q'*9zΰoDuo&li/Z=X$Lrmg{.	l\P5	뛙X$5;׀,V~H)O|IsYƥLVuI9!a(tZ~`ey15gQaY@ZisW
Qw~ǪlȽhÛzLG.QBA  b3WQwo ^B~&48PU٣0mX3JJȪ0Q[aZ15P[K=E
񩽑!1{M{.$h [HO`
[=~P}xVa̰`'
<xʜn
62[H$A

2J+\tubJMZ)+hr+o˷ͱ؉=͏;
P~d].d'0Z%GZ8a^η<Ɯm5#T&
hz;&85ZJyq./d/0ΗPSt')y~%uߌ]4	a(<)^cNr@@XɧoMͲ6fW8xФfu4 L$W'duM&爛k3in%6\t1xr%TH<oUQ%
&.>=Uf3"f7/l<vT݂NiyIVCwdCU{4IBʺɳNh֍z"͡FilSUm,I`a垉r_ncFl0n12N0.=K1)ee 1
^^?8	=%Dza|^3KHď8DVl%\Hܮ"c|{D"`L/]^x	=qep2@aU3ȱC z5o)A.~Q⍬c3nhuXg+-ȏъY@N£`=㩟t\S[wFe/.zKewGy'2k}>	/x2LǦߟc\"~]|)K/9ŧ*JYϤtw\e BJ qǳMK@g%yH[U[G3϶cN'eh]+[~9ԑm#ѸfSli	#KkBҔi\2}>ilsw&6,> C#U;k8TFRc1g"("@8+gj+D5N<~g8jՏ:
hj\Y%l/83E;-bwS^?Yl+S5_}>^	U&Qxy鎏FQ#TKwm)%)pN^LwDV9sУ/:m e4"U0UT$|E\G>{<%>Fg_a$_$V67`WPZN4
јːS W<vVʺ =zN[-bBY~CMo'_.fF<w(f7@AvF`{.GyDQ
xNku+aV\yR[DcaEnLfOX+`ʌ8Eqҥ6QK|DAb~Z[&\d+Xb:qgs|ֱ Pă{eeM	i<.z7)?E
"k7}ni(ZƃѺ3II~2
K}S'\y&6ѳVcF2XɳOH<"+<
?ʓg@DҸ9vgHG*-銗P/KwgZ6rrV[QJ޳Gv}h7N/$_ä\|``HHn4kO+IfP`YBQjyTMKH
l7!yǴL@J ^kM(ds$t
-Bxv=܈*wbÁp5ɾS"/(Y֣:r%!]j5;5٢.;cyddw:E%*qDO^GSm;"ѥ3tܲr:I?W+XZZr~00[v1?93:8ã8>K=8֟,vBWߒZ}t`Rj5YR!nEZECUk.9IBnFК\%O`r
g;\K6Ynx6sYFjbxHܶ.cr,zbgmÎ28=~\Tsǚ
5V톁'XTPYݞ\~_Gk:j4bAY
73GgLִwC3A&(!ܥRyrM<h8!7_uY[^#[[hd̨ᠷjNE@SP3^q<]"(`I̖k<}tKd#`0ׂǰ}
fۚbsdYD=5#{#m#`_ B'H&ꖐNL38=ߤ"bǶ<#:[K[vSDBH0<\A^S9#,.hßY{uEtn=9H]^r塊܃+~\T?/5fG
WCmK=;7mBmo@9ŗ]}/ڲr.(rb|xmwYU:Cx_qm7>VG3sꡝv"1#m~7ڿ	@ҟX)jMD'2bMfӹ4:
h08C/>p%OsLc'Ƣ#Q
$,&p&1HӤO:pۻ|S r)EՇaXMGn)&BnClɞ
x&RY4L|2Fbֆ[14-!/L>5E+,:tyn0)wX&< hS]t햛MvNkNGэ69A+;
2Tm\RbP̴ڏ#INhu7u	c]C?H6A!\
_ [@SNX-O,y|Q3|^ O4<QXuc}:fL^I6Ab=
Shw!`Ux׸pF<4+8
HqK%hqYS*f(QYrP`vl7>_wܜ:ggWy/=A"+%wCu|..񛓹K4bTBY63̦-7;Г9xWE"7x;ZdPHu$4XD>4qlHSVhػoT*pIqߎF#T]vOI[e{iUuK$ 7[ A|8: )"K.;jYR_eYխXEONslK⹊&ei+5kHiWX7)0pܘ/2CU݅3'di@mMT!sn2eTGI=}HHҤl&Ί)qn
BЯd&mtw>K9D?\Uwf`s`<dx%Z=`FԲ+!p4`_cif*Br8c;*=mA7"Ŏ^Ŕj>eIzZ^Nq|aCEj-wf6b8]=DmnkZ391e<)h^נ<ࣛP0_>)I@mR(k[Jǜ#wX|EzWDF8}q@,zq'tyyiMbhw ꓥq@&El򟔨J\wg;}2\Ir,M
!6U5(kYiqD΋`%*R5sAQzEWFn6Hr?c$_jFs6ň֍vr|w	CF`|_o<L-ap_#{Oҡ廯$󹀌Bkfu4-3U{wY1H_cqiꃓP*4U"gn|WK&hY=6/=cT_ii6m&sE`p#HyO~w'>F(TAˈ$d?$$}a0-^jkh3ƤPƝX{T5s,AJ,נ
ZQ00ŰhDՂ{<>dRjDLAFN}ks
>%WAu9--wqؙ(J%ERڀX<9& vҘsטugrU$<(Wҷ$ŵXOeOSwe&ݢo\/9Xh(VTF-\cDhP:]쒎O5]ۙg[s?KID$Z-3<ٸ*x|`daTmMei`p&i<_#$ xt>}:39'?0ԆqДLo7Q}zM$Wn
nLn"OKzyNoJVX,}*Ne!iU`j{1)k)_;]Ǳ"?u[#~-/|\3ɠFYc6O%r@+3]1CZtp+5gYxc.	h9CH7GeN~<1Y۩2eX
ځ\#Vm*3CKc\SL*`΅a)Nv ӟb8=RS:\GQHԳCp#-iT$jxQmڮ;ۤEwK*ݞx @y\U
rH%2Bh(a-{	T>U-
Īh#*V#,>x6wfV5>JY'AFD>А0zEr"Z0
dl"h&P?Pg,yV'e)~&S<29|VyFBܾ(2ZPz?\UB)c.Haĉv."Us/?Toz`+U`3HtE@KJMSR4E95UTɟUCZC	?;U#??Rפּ)DŻڲqzT6inޮ<"ZAكqhE0L(pe-3.q$!l[C}ɤY	ri-VDL\4Aҥ/}4OY1ť9![rr:S#:.)*m^V/pgqV2Ѝ]$>|gl)dp(5KBx$PƇ\-Ω(9jӇ3/MCi7}dkN]50OGlB                                                                                                                                                                                                                                                   O                        ~~ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        Ւ "     #      @ ޴H 
 ,GGG HGG  G  #. C" c. CGTG2JbSrJ3F3`AG v H( bC CGTG3ADG  @B@HbCGtGSbZkG $,  GpHb@A  HG0D $<GtG2AG ]  ]( }0 8 @ ݤH P #kGp#
 0   ~ P"P ^X ^` ~h p x ޴  
 ,GGG HG@ CG `G> GC]b# CGtGC@GC`hb#G4G@H ݤG4G=b#&vH Cy@G  G& GCCbGG4GGGTAD`BG  @ 4G .0@hbtGqHP JF >@ ]G C_F @aZk@ D0@G=b#G4G8y@ ,  GaHb@@ HG D <GtG2AGP ]X ]` }h p x ݤ   #k`#CX ^PB[tG` ^h ~p x  ޴  GG  ~G{GGGTGaZkH  C. c"
 # t1 H V H SJHFB FH G C G? GGC C]b#GtGŭ@GChb#G4G@P ݤG4G=b#&vH Cx@G  G& H =CGC` bG!&HG&HSADBG  @ 4G D.0@b CsJR DJGSF D>tG@ F @naZk@ D0@GX>b#G4Gx@ ,  GaHb@@ HG D <GtG1AGX ]` ]h }p x  ݤ   #k#
 0   ~G@ >H^P^X~`h
 ,GGG H  t G #. C" c. CGTG2JbSrJ3F^A . #. # GCJbQ!JGFGTGAADGGW  8 $vHCbGFFPFM   CTGvAADGH  8 P F @  GB G' @GCkb#G4G@ӈ "H B CP bGGC CG{_ZkG Cp b CGTGLAG C@ b  ?"TGhAAG  "4b#4G4GGGGG`@ G C b4GTGx_AG C@ bGTGRAAG  "4b#G4GTGGG1`@G GG@ GGbG ,  aJtG@ H D  <@ =0AGH]P]X}`hp#kG`#
 0   ~X ^` ^h ~p x  ޴   
 ,GGG HGG  G  #. C" c. CGTG2JX bSrJ3F_^AGCib#GG4G@P 'vHG v H	@   GGCh b CGTG@ADG  H Ї@G  BC( bP F `  8F@4G8 ݶG@ GTG9UZkG=b#G4GDv@. G0 B@8 bGGtGu`ZkG^ GG C b CGTGCAGCb CGTGNDA  BC R@( bGGTGUZkGCb CGTGBAGx b CGTGFA@   C\_8 @BGb C6VH@ g1HJGD8 tG!`ZkB@bCGGTGtG`Zk  BЁ@C( bGGTGTZkBCbG4GlUZkB @ @bCGG4GcUZk0 BG8 b2@GGtG`ZkG -  G`Hb@H IG E =GtG-0AGX ]` ]h }p x  ݤ    #k            #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#pB  ~
 0  ^C  ^tG( ~0 8 @ ޴H P X >` ^h ~p 
 ,G[GG{GG HGG_Zk CG_  /GGX K ?G . c# C/D =CJZ[K (C>b#FG CGG~@D   	GC_ ]! C _ӐBKAbC 0aAGGGtGd_ZkB
 k!4@b C CGtGQ@Z_Zk@
 G	G   d-`H0@K dI`E d=D . $ q!IG@P JbtGF >GG/AG ]  ]( }0 8 @ ݤH P X =` ]h }p  #kG#
 0   ~pB  >C( ^G0 ^G8 ~tG@ H 
 ,G[GG{ HG_ZkB a@bCGGGtG_Zk CG1_C G-_  . ## c/GJ[yKCFGbTG^?A G D   G . #" C.GGJRQJ }>b# CF ]}@G  GGtGb .  q$HP JF  >G  =/AG( ]0 ]8 }@ H P #k#pB  ~
 0  >C  ^G( ^G0 ~tG8 @ 
 ,G [GG{ HG^Zk CG_  " .TG /GJ8 bXKCFG
?A G D  
  . #" C.tGGJRQJ>b# CF ]}@G GG(btG .  q$HP JF  > =G.AG  ]( ]0 }8 @ P #kG#
 0 8 ^C@ ~tGH P X ޴` G  ~G0 ^
 , C" .G c.GG HJ( {SrJGFTADGGbGc   . #" C.TGJRQJCF]BADGW     C" c.CGGF .SrJ>b# CJ( ]FG>}@DGGC     C" c.C>b#GF .SrJ CJ( ]FGE}@DG1   
?" =CN_C GJ_0B@C GG8bTGtG^Zk
 D.4G
 $"0Bs1H8bR QJ "SF
 D>D . @CGU JG >GtG^Zk0B @8bCGGGtG]ZkG $,  GpHXbA  H@0D $<GGtG2.AG0 ]8 ]@ }H P X ݤ` p #k#    ~G ^tG G 1,Gx{A  H 1<.AG ]   #kG#pB  ~
 0   ^C( ^tG0 ~8 @ H ޴P G
 ,G[GG{G HGG]Zk CGG_Ә6K  c# G  C .C C/GGJZ[K ?b#FG|@D$   . C. #"GCJ>b#RQJGF ]GG|@D B@bCGGGtG]ZkB@CbGGGtG]ZkG G $,  GpHbA %H@0D $<GGtG-AG  ]( ]0 }8 @ H ݤP ` #k#pB  ~
 0  ^C  ^tG( ~0 8 @ ޴H G
 ,G[GG{G HGGM]Zk CGn_  " .TG /GGJXK( bCFGBAAD#    ]8 FF `   .wHCGV J0@F >O_BC GGbGtG"]ZkB@bGGtG7]ZktG G  G $,  GpHbA %H@0D $<GGtGL-AG ]  ]( }0 8 @ ݤH P #k# PB ^C  [G  ^tG( ~0 8 G  ~GG( {GGG\Zk CG
_GChYb#G 4G|@ CG_  B@( bC GGGtG\Zk  B@( bGCGtG\ZkP BX b@GGtG\Zk #,  GGp JH b $"0D #<G D.tGR QJ D>GG,AG ]  ]( }0 8 @ #k    #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#    ~ # >  ^( ^0 ~8 G 0,G P.B ~G HR@J4J2Du H CF > .9v?HG( bG JzQJ:GGTG >~/B =GGtGHb . ! qHP JF  >G =,AG  ]( ]0 }8 @ #kGp# 0   ~PBH^	 "P^tGX~`hp޴xG P.C ,G	 .GGG PJUb## H JGGj@DGGb#G   . #" c. " ."J  SqJCFG J CG GtGG~_D ݤG  .	 d"H
 "qHP J d#F > $  ]GD	 .GJuSJT J
 d"F	 >ݦ]"D
 /yJX KG
 ?]4GD ,0@Ke[K@ HBb D <D ,PHpHF HD < C=GD
 .p Ju3JT JF
 >0QZk @  %H@B="bG CTGPZkB b C4GQZkB @b @= G C4GQZkBGb2@GGtG[Zk  C_ݤ $ GْHؐH9V K7VHD8K!K6JJGFx K&H6vJGҒ JDHH:V@Kѐ J2V@J;aKAK1!JAJzG2F3Ht@K7Jy JtFFݴsJ d/ "@G[ aK CsG d?D D/GHbtGZ TK D?@@BP@i[Zk@B HbG CTGtGa[Zk@BЄ@Hb G CTGtGX[Zk@B@ HbG CTGtGO[Zk@B HbG CTGtGG[ZkG ,  G`Ihb@F HGD <GtG{+AGH]P]X}`hpݤx#kG#    ~ # ^ _'  ^B( ~0 8 @  0,G P.G ~G HR@J4J2Du HGF > .!v>HGG JC7JTGF:@G8 { >B . $ qHGbGP JtGF >GG9+A }GG( btG0v`HP`HAGCH bGGTGB D }	  Gh b4G0v`HFAGGX bAG ]  ]( }0 8 @ P #kGP# 0   ~PBH^	 "P^tGX~`hp޴x>^~ P.G ,C	 .GGGGUb# PJ# H JGG@DGGG   #. " C. " ."0Jb#RPJ  ޴C 2FG J CG TGG4G_DG   C_  C_{ H  C9K " ;G_y H=!8J C G_y H]!8J C G_{ H 	 D"9J K ;GpK $,
 " D#A $H0D $< =GD	 d.'Jt2JS rJtF	 d>
 "GD
 $/{JY 7K;G
 $?4GD $,0 HbpHA 6H0D $<GD $.P KrKQ :JB2F $>}GD
 .p`JwtJU J}"F
 > COZk@G  G0J@B"bG CTGNZk bA H0BG8b  @2+@GGtG2ZZk D. $"} d"B@R QJ D>D .usIbGT J CF >GtGZZkB@bG CTG                                                                                                                                                                                                                                                   P                        nH $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        )K "     4      tGYZkBЄ@bG CTGtGYZkB@bG CTGtGYZkBP@bG CTGtGYZkG , d!GiIbE H@D <GGtG*AGH]P]X}`hpݤx=]}#kG0#	 p"  ~ 0 `^
 "h^Bp~ #x޴>^~	 P.G , =#
 .G . SJGGGUb# C# H J JGtG@DG	G} D  DDG ="CTb# CGTG@ . #  .	CG CJ Ub#TJC "F CGGG CG@D	G[ G "Tb# CCTG@B =!b C4GNZk
  B =   =!b C CTG2NZk G0B =! 8b C CTG|Zk0B  	C8b CGTG{Zk = ?$ = " . " . }"  CJGUJ b#C   DFG2'I C CGG_D  ?D	G G DFW  8 F;  X F @F  P  #.G . " . =#  ^4JGVJDb# "  # C C > C6F C JTG4G__ #. #-   , "G'JI'Ib# " D #  C CG   C ޶)F C H4G4GF_TG	G G . #  #. " . "JGQ!Jpb#D  F =  J C C  C CGGI_4G	G 	G?E (  C"_, ( C_({ H0! C9K " ;G(_0y H4]!8J C G0
_0y H6}!8J C G0_0{ H	 D"9J K ;G0pK $,
 " D#A $H0D $<=GD	 d.'Jt2JS rJtF	 d>
 " GD
 $/{JY 7K;G
 $? 4GD $,0 HbpHA 6H0D $< GD $.P KrKQ :JB2F $> }GD
 .p`JwtJU J }"F
 > CMZk@G  (G0J(@B "bG CTG3MZk A H`BGhb  @2,@GGtGrXZk D. $"$ d" B@R QJ D>D .uIbGT J CF >GtGBXZk B@bG CTGtG:XZk BЄ@bG CTGtG2XZk B@bG CTGtG*XZk BP@bG CTGtG"XZk- -- !fHH IE- =G , D!Gk*I(bE HAD <GGtGP(AG`]h]p}xݤ=]}#k# 0   ~PB  >	 "(^("0^G8~tG@HPG P.G ,G	 .G PJ Vb# H J C&@DGj   . C. #"8bTGJRQJCF78AD^    TGP F  Y G(="(]"Ub# C CTGʥ@ . " .( GCJPUb#UJCF C CGCGG@DG< (= (="Tb# C CTG@ BCbG4GMZk	  BCb( G CTGmLZk `BC hbG CTG>zZk`B C( hbG CTG6zZk . #  #. " G .J Q!JG DFb#C J3H CG CC_  GGXbG ,  aHtGE HD  <  ='AG(]0]8}@HP`#k#	 0 8^ p"@~HPX޴`hpG  ~G0^PB( =G	 ,G P.# . H0= 0Vb# BB T/
 4#
 / " SJ TKG J KGG CtGx@DG  0=" C0Vb#GGtGn@DG 0!C@Ub# CGTG$@ . #  .0  G CJUb#TJC0"F C CGG CG=@D GTb# C CTGI@0B0 8b C4GaLZk  B0!b C CTGKZk ÐB0! b C CTGyZkB0 Cb CGTGyZkG0 0  @Ub# C CTG@ . #  . CG0"JUb#TJCF C CGG CG@DGi Tb# C CTG@0B0 8b C4G LZk	  B0!b C CTGKZk GB0 !b C CTGXyZkB0 Cb CGTGPyZk  TG  ݤEDD  <  . #" C.0=   # J .RQJG0=" C >'Hb#F   C ޶4H C C JG4G_DEG   . #. #   D ݤJ C.Q!J  "0"b#DF0"&H C  ޴ UJ  C 4H C CG4G_( GGGbtG , !gHD HD  <( =&AG0]8]@}HPXݤ`hp#k@#H>#  ~ 0 ^	 "^pB~
 #޴@ >G P.G ,G	 .G
 . PJG CPVb# H J JtGj@DG  H"`Ub# CCTG!@ . . "G CJUb#UJCH"FGGGC CG;@D 8  . c"0 =CFG C .TJXb2'HJH}"F CGGڭA D   G D G ( =G1D1D GD  ( ]PFQFD `( 0FFGH"DUb# C CGTG@PBH Xb C4G2KZk	  0BH= 8bH   C CTGJZk ðBH  b C CTGjxZkBH Cb CGTGbxZk ,   #, "  'HA%H1J Dr HG 2F  . vH8 0J0  }# JtJ5J F D @ 2JG" ,J =,pJ[Jr[J(bD0DD" <2D =<G# .H]#& / C# "`TKUJTKGXKFCG C& ?G# >GGtG*BDG- CbGCTG=-B 8 D   G# G .   #, C" #.CGJA%HHb 2JCGFGGc@ D   G
 GGH]"CbDL CG CTGGA@ GGGbtG ,  dHF HD  <@ =z%AG]]}ݤ#k#    ~ #  ^ _'( ^B0 ~8 @ H ޴P G 0,G P.G ~G HR@J4J2Du H CF > .!v>HGC JG7JtGF:@GG{ >{&BDG
  CR_ӠB@CbG GGtGTZkG $,  GpHbA  H@0D $<GGtG(%AG  ]( ]0 }8 @ H ݤP ` #k#C0 ^B [tG8 ^@ ~H P X ޴` h GG  ~G{GGGGTZk BPb@bGCTGtGTZk CG_( ݦ #"   "GP@8VJ8 bv1JKa@F( ݶ6vJ .C c.G .GJSqJ JF C CGADG  G?DT4D8     0@4G C. c. #"  ##QJGSqJ5JSFv@J 'F ]2v^J /C =C  }G KG8KG[B ]G( bGBD BG ( =@CbG2V Hq1 HAJ!v H2FP @( ] @GTGtG_TZk ,  GaH(b@ H@ D <GGtG$A( ݤGGX b%VHf1HHD(   A(  .TG ,GJH bDH'vHF CY>AG0 ]8 ]@ }H P X ݤ` h p #k#C8 ^B`[tG@ ^H ~P X ` GG  ~B0 >Gh{GGGTZk`BPb@hbGCTGtGTZk b@CGGa_  ݦG( :AK8 b8VJv1JK #"F  ݶ6vJ . C. "F c.J CGRQJCF uJG CGGAD DTD G . #  #. " ]CJGQ!J( b3_JFt JCtF  .8vJ =G( }G JGyQJG ݶG"B0 GGbG ,  aHtGE HD  <  0 = $AGGX bA  TG . ,G$vHJH b@H C F>>AG8 ]@ ]H }P X ` p #kG#C0 ^B[tG8 ^@ ~H P X ޴` h GG  ~BBG{GGGGSZkBc@bGCGtGSZkB c@bCGGGtGzSZk CG_C( G_ =#   C_ "  #" / C C/ C ݦGK( bZWK7JGz KGF ݶ2vJ .G   JGsQ JGSF( }G ݶ%BDG CG_ӐB@CbG GGtG@SZkG ,  GaHb@ H@ D <GGtGt#AG0 ]8 ]@ }H P X ݤ` h p #kG#C0 ^B[tG8 ^@ ~H P G  ~G( >BGG{GTGSZkB b@bCGGTGtGSZk = "   " 3V H1V HG`1 H!Ja1 HaJ D  3D = / v H #/!v HGKY7K7JGy K CF 3vJ c/CG pK( buQ JuF  CG+%B( GGbtG $,  pHA $H0D  $<( =G#AG0 ]8 ]@ }H P ` #kG`# 0   ~	 "H^pBP^
 #X~`hp޴x> P.G ,C	 .G
 . PJGGGWb#G# H J JGtG@DGG`b#	G  C .G . . #"TJ  J ""F J CG GGG_D	G   C_" CG]ْHؐH9V K7VHD8K!K6JJGFx K'H6vJGВ@KDHH%VH@K0V J;aKH!!HJeG0D1HrӠH3YKt H2FBtF=  d#  -Iy `  ,qIB4GGHD  < b CGZk@G  =G!;H=@B}"@bG CTG
GZk'HPBGXb @G2AGtGJRZk $,   D"B@A  H $<D d.tHbGS rJ CtF d>GtGRZkB@ bG CTGtGRZkBЄ@b!G CTGtGRZkB@ bG CTGtGQZkBP@b!G CTGtGQZkG ,  Ge&IbG HAD <GGtG*"AGH]P]X}`hpݤx=#kG ,
IG
HD <p# 0   ~PBH^	 "P^tGX~`hp޴xG P.C ,G	 .GGG PJWb## H JGG@DGGb#G   #. " C. " ."0J  ޴RPJ C2FG J C G4GG4G_DG   C_ݦG=ےJِJ;V`K8VJF9!KaK7JK;G}Fy K6J7vJ6Gђ HFJ                                                                                                                                                                                                                                                   Q                        X $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     E      J'VHА H1V J%HH0J!J#DF2JsӠH C49Hu JSF CF= D" d  ,Hx @  r.4GBvH bSrJ CvF  r>FZk@G  G0JB@"b@G CTGFZk'HB G @bG2@GtGYQZk $. $  D" BQ !J $>D d.tH @(bGS rJ CtF d>GtG)QZk B@(b G CTGtG QZk BЄ@ (bG CTGtGQZk B@(b G CTGtGQZk BP@ (bG CTGtGQZkG ,  G`IHb@F HGD <GtG9!AGH]P]X}`hpݤx#kG r.
HS
rJvF r>@#H>#  ~ 0 ^	 "^pB~
 #޴@ >G P.G ,G	 .G
 . PJG C8Xb# H J JtG@DG  H"HWb# CCTG@ . . "G CJWb#UJCH"FGGGC CGٝ@D 8  . c"0 =CFG C .TJ@ b2'HJH}"F CGGxA D   G $HG G0 b$VH #"0H4GD  ( J	   . C.JRQJFnAGD GD ( FFGH]"Vb#D  C CGTG@8BH @b C4GEZk
  BH= H   b C CTG.EZk GBH  A@b CGTGrZkBH Cb CGTGrZk ,   #, "  'HA%H1J Dr HG 2F  . vH8 0J0  }# JtJ5J F D @ 2JG" ,J =,pJ[Jr[JbD0DD" <2D =<G# .H]#& / C# "`TKUJTKGXKFCG C& ?G# >GGtG$BDG, CbGCTG'B 8 D   G" G .   #, C" #.CGJA%H0b 2JCGFGG@ D   G GGH]"Cb CLG CTGG3A@ GGbG ,  dHtGF HD  <@ = AG]]}ݤ#kG#
 0   ~B^C^TG~tG޴p >G
 ,G[G{G HGOZkBPb@bGCTGtGOZkBb@bGCTGtGOZkBb@bGCTGtGOZkBc@bGCGtGOZkX =` Y #H 2V HP ݦ1V Ha1 H AJ`1 H!J8 2DZ C.:VJX .3VJ DY #.v1JAKX =Z "` w1JaJ UJC JFFH } 8JP ݶG_Gpk@x"Xb#G8 G CtG@DG  x"x="Wb# C CTGT@ . " .x GCJXb#UJCFG CGCGGn@DG  (  . "0 =C3J .UJb?FJ CFGCGGUAD @ = G0D   À=DH } C#P ]TG` 1!JX 3fJr@Jp J4vJFrF8 ݢTF]|ݲ . c/J[zKCGGFbe/AD h _"G? Wb#DDx= x=" C CGTG7@BCbG4GODZk
  BCx bG CTGCZk G  BC P@( bGGTGqZk  B Cx ( bG CTG~qZk ,   #, "  'HA$H1J Dr HG 2F  . vH0 0J(  }# JtJ5J F D @ 2JG" ,J =,pJ[Jr[JbD0DD" <2D =<G# .C& /# "`TKUJTKXKGFCG& ? C# >GGGtG7#BD+ GCh bGCTGZ&B 8 D   G   .   #, C" #.CGJA$Hb 2Jx"GF CG@ D   G GGCx= x bG C CGGAp GGGbtG ,  eHF HD  <p =AG]]}ݤ#k#    ~G ^tG G 1,G{A  H 1<AG ]   #kG#C8 ^0B[tG@ ^H ~P X ` GG  ~G{GGGG%NZkB a@bCGGGtGNZk CGm_(  / " #/C }CKY7K:K8 bGa KCAGGG =tGG|BD5   = G( 0B @/ 10B1!J "!JC0 B@ #F  }@8HtG B( G?_BCbG  GGMZk CG4_B@CbG( GGtGMZk  B@( bGGtGMZk@ G . $ GqHbP J@F >GGtGAG8 ]@ ]H }P X ` p #kG# 0B( ^C0 [G0 ^tG8 ~@ H GG  ~G  >8 {GGMZk #,   . " =C H( bP J2?J0Ds HGGSF = .!v>H &C JG5JTGF7@ =BDGG
  H bGgA . #,  G4G Jh bA HFw8A  GGX btG  ,   pHA  H0D   <  =GAG( ]0 ]8 }@ H P #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G ^G ^  ~( GG  ~G8 { >dA	 ,	 # GTG = H"b#]@  GB@   "G =TG@@  ` [ @ZkG ] ]  }( 0 #kG#G ^G ^  ~( GG  ~G8 { >ZA	 ,	 # GTG = H"b#]@  GB@   "G =TG@@  ` [ @ZkG ] ]  }( 0 #kG#G ^G ^  ~( GG  ~G8 { >LA	 ,	 # GTG = H0#b#]@  GB@   "G =TG@@  ` [ @ZkG ] ]  }( 0 #kG#G ^G ^  ~( GG  ~G0 { >BA	 ,	 #   TG = H@@G  ` [ @ZkG ] ]  }( 0 #k# 0   ~ P" ^ " ^TG G ,G p.G H#b#S rJtHtF p> vJB ^B@ G  TG@B  ` [ @ZkG ] ]   #k#G ^G ^  ~( GG  ~G0 { >A , # GTG = H#b# @  G7B@   "G =TG@@  ` [ @ZkG ] ]  }( 0 #kG#G ^G ^  ~( GG  ~G( { >A , # GTG = H$b#]@  G
B@ @ "G =TG@@  ` [ @ZkG ] ]  }( 0 #k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G8^G@^H~PX`G  ~GGx{0 >BA . #  ,0a@BC Jb HGGTGtGKZk  c" C.8"Ga@0V HPQb#`1 HJtG D SJ  C@DG  8"8="`Pb# C CTG@ . " .8 GCJPb#UJCFG CGCGGʘ@DGw 8= 8="Pb# C CTGԙ@0BC8bG4G@Zk	  @BCHb8 G CTGS@Zk BC ^@bGGTG$nZkB C8 bG CTGnZk ,   #, "  'HA$H1J Dr H
 =  2F  . vH( G  =1'J J tJ5J F D @ G .6'K
 ,!Jq!JJvJFDF >D
 <G }/7vJ ,C # CXKwXKG[xK@HCaG D }?( bG < CtG@DGXDb  . #,  GJA%HTGF+A G0 GGGbtG ,  aHE HD  <0 =TAG8]@]H}PX`p#kG#G ^G  ^( ~0 G  ~G{G >hA  B `@C( bGGTGtGJZk  c"G " b#0V H`1 HJtG D  . v H . .JTJ JF C@DGX DH b   . C. #"TGJRQJGFJ+A G =GGtGb . ! qHP JF  >G = AG ]  ]( }0 @ #kG#G0^G8^@~HPG  ~G{G( >A C. , # G0" CJQb# H0a@ CtGߖ@D  G0"Pb#0=" C CTG@ . . "G0 J Qb#UJCCFG CGCGG@Dm G0= Pb#0=" C CTG@ӰBCbG4GZk
  BC0 bG CTG8Zk G@BC N@HbGGTGmZk@B C0 HbG CTG mZk ,   #, "  'HA$H1J Dr HG 2F  . vH  0J 
 }# JtJ5J F D @ 2JG ,J
 =,pJ[Jr[Jb#D0DD <2D
 =<G .C . "VKUJxVKTJGF >F > . ## #, #" ,CJA9H HFtGz@( GGtGb $,  pHA $H0D  $<G( =DAG0]8]@}HP`#k#G ^G ^  ~( GG  ~G({ >ZA .   #, C" #.TGG JA H( b 2JF@ =GGHbtG . ! qHP JF  > =GAG ] ]  }( 0 #k#G0^G8^@~HPG  ~G{G( >)A C. , # G0" CJRb# H0a@ CtG@D  G0"Qb#0=" C CTG@ . . "G0 J Rb#UJCCFG CGCGGÖ@Dm G0= pQb#0=" C CTG͗@Ӑ BC bG4G~Zk
   BC0  bG CTGL~Zk G  BC N@( bGGTGlZk  B C0 ( bG CTGlZk ,   #, "  'HA$H1J Dr HG 2F  . vH  0J 
 }# JtJ5J F D @ 2JG ,J
 =,pJ[Jr[J bD0DD <2D
 =<G .C . "VKUJxVKTJGF >F > . ## #, #" ,CJA9H HFtG2@( GGtGb $,  pHA $H0D  $<G( =XAG0]8]@}HP`#k#G ^G ^  ~( GG  ~G( { >nA .   #, C"                                                                                                                                                                                                                                                   R                        8 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        8 "     V       #.TGG JA H8 b 2JF@ =GGH btG . ! qHP JF  > =G'AG ] ]  }( 0 #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k0#G ^G ^ ~  G  ~G >G{w
A ,BC # bG Ha@TGtGHZk 
 c"
 C. #  Ct1 H V H SJHPB F  tG+ GGC CPb#GtG@ . #. #   " .JQ!JG v HPpb#F CC J CGG9@DGXDbG
  . #  #.TGJQ!JFG(A  GGGbtG ,  aJ@ H D  < =AG ] ] }   #k#G ^G  ^( ~0 G  ~G8{G >
A  B a@C( bGGTGtG-HZk  "G "hrb#0V H`1 HJ # D  . v H .G c. .JVJ tJF J C@DX DG   . C. #"H bTGJRQJGF(A  =GGtGXb . ! qHP JF  >G =:AG ]  ]( }0 @ #kG@#G ^G ^ ~ GG  ~Gh{ >A , #  " C HtG@ @ GGCPb# CGtG@ . #,   #. C"G JA HPqb#C 2JFGtGV@G =GGbtG . ! qaJP JF  > =GAG ] ] }  #k@#G ^G ^ ~ GG  ~G{ >vA , #  " C HtG@ @ GGCPb# CGtG@ . #,   #. C"G JA Hrb#C 2JFGtG@G =GGbtG . ! qaJP JF  > =GAG ] ] }  #k#G ^G ^  ~( GG  ~G{ >2A .   #, C" #.TGG JA Hprb# 2JF@ =GGbtG . ! qHP JF  > =GAG ] ]  }( 0 #k#G ^G ^  ~( GG  ~G( { >A .   #, C" #.TGG JA H`rb# 2JF@ =GGH btG . ! qHP JF  > =GQAG ] ]  }( 0 #kp B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k#G( ^G0 ^8 ~@ H P G  ~G{#G  =A C.PB c"a@Xb SJGCGtGFZkPBPb@XbGCGtGFZkPB b@CXbGGTGtGFZk CG_C G_ } #"  "Ga@9V`K{1`K!KGyG = .9v K C.   c. CJ  >RQJ( b tJ }FG CGY@DXDG  . #,GbTGJA%HF&A G  GGGbtG ,  aHE HD  <  =AG( ]0 ]8 }@ H P ` #kG#G ^G  ^( ~0 8 G  ~G8{G >[A #,B "Cb a@ 0HGGTGtGEFZk  c"G "8 b0V H`1 HJG D  . v H .G .JTJ JF C[@DXDG  . #. # ( bTGJQ!JFG&A  GGtGXb $,  pHA $H0D  $<G =TAG ]  ]( }0 8 @ #k#G  ^G( ^0 ~8 @ G  ~Gh{G >ABa@bGCGtGEZkB Pb@bCGGGtGEZk CG_C G_  C/ #  . # #/a@ AKGJ }Y8K( b CFGG@ GGbtG $,  pHA $H0D  $< =GAG  ]( ]0 }8 @ P #kG#G ^G ^  ~( GG  ~G{ >A .   #, C" #.TGG JA H( b 2JF/@ =GGbtG . ! qHP JF  > =GAG ] ]  }( 0 #k#G  ^G( ^0 ~8 @ G  ~G{G >A0 Ba@8 bGCGtGsEZk0 B Pb@8 bCGGGtGjEZk CG__C G[_  C/ #  . # #/a@ AKGJ }Y8K( b CFGG@ GGbtG $,  pHA $H0D  $< =GAG  ]( ]0 }8 @ P #kG#G ^G ^  ~( GG  ~G( { >6A .   #, C" #.TGG JA H8 b 2JFG@ =GGH btG . ! qHP JF  > =GSAG ] ]  }( 0 #k        p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k #	 "  ~	 0  ^
 P" ^ ~   ޴  G	 p.G ,GG tJEHpBH CG tG3 GCXMb# CGtGݐ@ . ,   #,CJG@H vb# #" F CGG 1HCGG@DG CG_ BC@ G(bGGtGDZk    ,aH@ HG D <D $. "sHG@Q 0JHbG3F $>GtGAG ] ] }   ݤ   #kG# B( ^CP[G0 ^tG8 ~@ H G  ~G  GX{GG\DZk CGQ_CGGCtb#G  CtG
@DG   	 " C.TGsJR CJSF C> GD	 .wJV JF	 >D #/ #zHxb@Y 8KG:GG #?tG  pAG( ]0 ]8 }@ H P #k#C  ^B[tG( ^0 ~8 GG  ~G >G{GGDZkB a@bCGGTGtG
DZk CG_   #"G ";V Kx1 KaKGG  .8v K C. c.Jub#RQJ tJF C C@DGX D( b   . C. #"TGJRQJGF^$A G =GGtGb . ! qHP JF  >G =AG  ]( ]0 }8 @ #kG# B ^C[G  ^tG( ~0 8 G  ~GG >{GGCZk CG_Gpvb# C 4G%@ =GGbG . ! qHtGP JDF  > =GA GG wb#~@G ]  ]( }0 8 @ #k# B ^C  [G  ^tG( ~0 G  ~G >G( {GG}CZk CGr_  #  C/ ## . C c/ AKGJ[yKtGFvb#@ =GGH btG . ! qHP JF  > =GAG ]  ]( }0 @ #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #kP#
 0   ~ "P ^X ^` ~h p x ޴   > ^ ~ 
 ,GG	 " H /GB r" . R"yH JX K]GBGG ? C C C @G tGZ GGC CKb#GtG@F G	E @@   ,Gs0J  H    P.R PJSF  P>4  #. " .TG  .G6JbWJ J7F@AG*v HCbG CTG4#A  H =@G0D    0.rPJ2F  0> GG@Cb CGTGv.A  K-aHJ KI
AE  K= 	@G  	.q)JF  	>4 AE	EB_G  " !b#4G4GGGG	B@0@ G d- D!Gi
HK jIaCbiE d=GGtGAGP ]X ]` }h p x ݤ   = ] }  #kG#CX ^TG` ~h p x G  ~GP ^ .   #,GGG J8 {A HGF.AD  BG   ( bC4GwZk D.sH  BC( bGR DJ4GSF D>4GwZk  P B0@X bGCTG$wZk  BC( bG4GwZk0 @ G . $ qHG8b@P JtGF >GGA . ,  GTGJbDHFCG"A    G  b D  .  ?" #,TG   JA HF"A . ,4GGTGJH bDHF@AGP ]X ]` }h p x  #k#TG ^  ~( GG  ~ >   ^G .G #,G J( {A HFu"A GGhbG  ,   tGA  H   < =/AG ] ]  }( 0 #k#TG ^  ~( GG  ~ >   ^G .G #,G J( {A HFm"A GGbG  ,   tGA  H   < =AG ] ]  }( 0 #k#
 0   ~ P"H > CP ^tGX ^` ~h G
 ,GG H]@ ` GGCxLb# CGtGˍ@G C( bGtG4GtGAGH GGtGb  ,   pJA  H0D   <GH =AGP ]X ]` }h p #kG#
 0   ~ " >tG^ ^(~08@޴HPXG
 ,GG C HGB r" . R" C J_B u GGC CMb#GtG@ . #,  GTG J8 bA H CFG!ADG^   GFFPF  W G   4G  dCD `G'vHC8 b CGTG!A P D    G CH bCTG,A4G  4@ vH@+ G) G!vHG C"x b@TG  . J    !. c. !J #.SrJ2J3F>AG(v H8 bC CGTGm!A P D    GH b CCTG,A4G4@(vH	A&vHG"b#  " 4G4GGGGU@@G GGGX btG ,  gJE HD  < =$AG] ](}08@ݤHPX`#k        #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k# !B ^C[4?   ^TG( ~tG0 GG  ~G {G >G@Zk #,G  bGA  H #< TGtGAG ]  ]( }0 @ #kGp# Ch ^4G                                                                                                                                                                                                                                                   S                        ѰJ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     g      Gp ^x ~  G  ~G` G@Qb#Gg@Ba@bGCTG:uZkB CbG4GuZkB `@ @bCGG4GuZk  BG( b2 @GGtGm@ZkGH  Pb# C4G@H 8 .4GGqHP JPb#F8 > Cʘ@H 9 # 9 .4GGqHP JNb# CF9 >G@X BPg@Cb0V H`1 HJG DX GTGtG$@ZkGCbG@ 4G2A@ Bg@Cb0V H`1 HJG D@ GTGtG@ZkG CNb#G4G@P g@BCbTG`1 H@ tGZkG CPb#4G@H @ .4GGqHP JPb#F@ > C@H A # A .4GGqHP J`Pb#FA > C@H B # B .4GGqHP Jb CFB >GA8 Bph@Cb0V H`1 HJG D@ GTGtGZkG C@Pb#4G@F #.GH F "Gr0H Pb#Q 0JE c"2FF #>DE .uH C4GT JFE >@H G .G # G4GqH Pb#P JFG > C@H H .4GGqHP JOb#FH > C@H I # I .4GGqHP JOb#FI > CĘ@H J # J .4GGqHP JOb#FJ > CΘ@H K # K . i@  BGqH( bP JtGFK >GGZk ,G  bG@ H <` GtGAGh ]p ]x }   #k# dC( ^0 ~8 GG   ~G  ^G{_@BC a@4#G }HbGGtGCZk@B a@HbCGGTGtG:Zk #,  GGxbGA  H #< tGqAG  ]( ]0 }8 @ #k#TG  ^( ~0 GG  ~ >   ^G . #,G JA HX{ CFGtAD   GFF G ]GGbtG r. R"tHS rJtF  r> =G?AG ]  ]( }0 @ #k# ^4GG^ ~(08G  ~G Mb#G Cě@G Mb# C4G@G pMb# C4Gh@G CMb#G4G@  Ba@="( bG CTGsZk B b C4G&tZk B= b0 @ C4GtZk  B`@( b0!@="GG CTGsZk B b C4GtZk B 0 @b=  @ C4GtZk @  Be@P!@( b="G CTGmsZk B b C4GsZk B 0 @b=  @ C4GsZk  @  B `@ p@( bCGGTGUsZk BCbG4GsZk B 0 @b=  @ C4GsZk B= bG C4GsZk B= b @ C4GsZk BCb @G4GsZk  @G `@b     . #"0@P J  > c.tGS qJ c> GAG]] }(08@#k# PB0 ^C8 ~TG@ H G  ~G  >( ^ #  .G C.GGGJ{RAJFAD    c" ݦC( bFFPF   .G .7JGGJUJTGFxJF SB G G  GG8btG $,  pHA $H0D  $<  =GEAG( ]0 ]8 }@ H P #kG#TG  ^( ~0 GG  ~ >   ^G . #,G JA H{ CFGFADG   POb#4GFFPF  GJ@ G  G =GGXbtG . ! qHP JF  > =G	AG ]  ]( }0 @ #k#TG  ^( ~0 GG  ~ >   ^G . #,G JA HH{ CFGADG   Ob#4GFFPF  4G@ G  G =GGbtG . ! qHP JF  > =G
AG ]  ]( }0 @ #k#  C  ~C TG  ^( ^0 ~8 @ G  .G  ,   GG Jx{A HGFADGG   COb#4GFFPF  G@  G #,pHA #H4G0D #< G G c. #"GtHbS qJ@tF c> GtG
AG  ]( ]0 }8 @ P #k#TG  ^( ~0 GG  ~ >   ^G . #,G JA H{ CFGADG   POb#4GFFPF  G@@ G  G =GGbtG . ! qHP JF  > =GO
AG ]  ]( }0 @ #k#TG  ^( ~0 GG  ~ >   ^G . #,G JA H{ CFGRADG   Ob#4GFFPF  4G@ G  G =GGbtG . ! qHP JF  > =G
AG ]  ]( }0 @ #k#
 0 X ^C` ~TGh p x GG  ~H > C"P ^G
 ,G . c.G HJ8 {SrJFADG!  @ GF   G . #" C.TGGJRQJ( bCF1ADG
  GCb4G@ 8  GDG GGH =GGxbtG . ! qHDP JF  >GH =A GCH bGtG4GtGAG$b#GR@G0Cb#GM@GP ]X ]` }h p x  #k# !B ^4GG ^  ~( G  ~G G(%b#G6R@ C. #"DGGbsHR QJ DSF C>B GtGAG ] ]  }( 0 #kG#  B0 ^C[TG8 ^tG@ ~H P G  ~GG{GGG(|Zk(  C"GTG( b0V H`1 HJ D(  . c.JSrJCFG+A D   ? ( = GGC8 bCGtGA . #. # ( TGGJQ!JH b v HF CZA( @BCbTG0V H`1 HJtG D( GG{Zk $,G  bGA  H $<GTGtG$AG0 ]8 ]@ }H P ` #k#    ~ P"( ^ "0 ^tG8 ~@ H G 1,GG{A  H 1< p, p. .rHSrJ JsDGAG CH b CGTGA D 7    =qQHG0J8 baq H2v`H0D2F1D =C CGGTGwB C  G C( b4G&AGX bG@  1 @ C Gb# C4G@ GG Cx b CTG@G Ch b CTG|0AG( ]0 ]8 }@ H P #k#    ~ p"( ^ &0 ^fC8 G 1,G =##A  H 1< .J .`J ]JUJ2\JFFVB ]G ]/G }/ZYK[yK@GaG }?tG ]?GbA CGGH btG0v Hѐ HA"  GCh bGCTGA G4Gb#4G  =0v H_ = F@GC  ^4G5'J ^X bG0v HG_"GGR.A G 4GGb#0v H_G( ]0 ]8 @ #k# C ^dC  ~tG( 0 G  ~G ^ # 0 [ C.G c.G8 {GAJSaJGSF}yZk@ B CH bG4GWpZk 8 D   =p1 H!?HF&@ =@BCGbGTGtGzZk #,   .
 $"
 D. " HGP JHbR QJ0Ds1HGSF
 D>D .GtGtGU J >AG ] ]  }( 0 @ #k# C ^4GG  ^( ~0 G  ~G {GG4@ CG_Ba@bC GGGtGzZkG CH bG4G@ CG_Ba@CbG GGtGzZkG CbG4Gf@ CG_Bb@bC GGGtGzZkG CX bG4GI@ CG_Bb@CbG GGtGnzZkG CbG4G@ CG_Bc@bC GGGtG[zZkG C( bG4G/@ CG~_Bc@CbG GGtGHzZkG CbG4GJ@ CGk_Bd@bC GGGtG5zZkG C8 bG4G]@ CGX_Bd@CbG GGtG"zZkG Ch bG4Gd@ CGE_Be@bC GGGtGzZkG C bG4G@ CG2_Be@CbG GGtGyZkG CbG4G.@ CG_Bf@bC GGGtGyZkG C bG4Gi@ CG_Bf@CbG GGtGyZkG CbG4G*@ CG_Bg@bC GGGtGyZkG Cx bG4G5@ CG_Bg@CbG GGtGyZkG CbG4G@@ CG_Bh@bC GGGtGyZkG C bG4GK@ CG_Bh@CbG GGtGyZkG CbG4Gb@ CG_Bi@bC GGGtGwyZkG C8bG4G@ CG_Bi@CbG GGtGdyZk #,  GGbGA  H #< GGG	AG ]  ]( }0 @ #k# C ^4GG  ^( ~0 G  ~G H {GG@ CGi_Ba@bC GGGtG3yZkG C8 bG4G@ CGV_Ba@CbG GGtG yZkG C( bG4G@ CGC_Bb@bC GGGtG
yZkG CX bG4G@ CG0_Bb@CbG GGtGxZkG C bG4G @ CG_Bc@bC GGGtGxZkG Cx bG4G?@ CG
_Bc@CbG GGtGxZkG Ch bG4GF@ CG_Bd@bC GGGtGxZk #,G  bGA  H #< GGGGAG ]  ]( }0 @ #kG# C ^4GG  ^( ~0 G  ~G {GG@ CG_PBa@XbC GGGtGxZkG CH bG4G@ CG_PBa@CXbG GGtG|xZkG CbG4G@ CG_PBb@XbC GGGtGixZkG C( bG4G;@ CG_PBb@CXbG GGtGVxZkG CbG4GP@ CGy_PBc@XbC GGGtGCxZkG C8 bG4G1@ CGf_PBc@CXbG GGtG0xZkG CbG4G@ CGS_PBd@XbC GGGtGxZkG Cx bG4G@ CG@_PBd@CXbG GGtG
xZkG CbG4G@ CG-_PBe@XbC                                                                                                                                                                                                                                                    T                        Ʌ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        [ "     x      GGGtGwZkG CX bG4G@ CG_PBe@CXbG GGtGwZkG CbG4G@ CG_PBf@XbC GGGtGwZkG Ch bG4G@ CG_PBf@CXbG GGtGwZk #,  GGbGA  H #< GGGAG ]  ]( }0 @ #k# C ^4GG  ^( ~0 G  ~G P,b#GG*N@ CG_  Ba@( bC GGGtGwZkG C,b#G4GM@ CG_  Ba@C( bG GGtGzwZkG Cp,b#G4GM@ CG_  Bb@( bC GGGtGgwZk #,G  X bGA  H #< GGGGAG ]  ]( }0 @ #k            #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k# TG ^TG  ~( 0 8 G  ~G  ^sH C.G0 0!BGR CJ@b# CSF C>@  B( b C4GhlZkG `@@b#@P@TG@  B( b C4G\lZk  B@( bGG4GUlZk  @p@Ge@@b#TG  a.tJ "S aJ@tF  a>?D .P @TGV J >@  B @( bG4G;lZk  @ `@G p @@b#4G  `.t H@S `J0 @tF  `>TG@  B C( b4G'lZk  B( bG@4G!lZk  B@( b @G4GlZk  B@( b @4GlZk  @G  @0 @ 0@ H0@ `@!!H  .4G0@v`JU Ja@0BF  >  !/1!J0 Bq@Y !K  !?  q/0B2AJ0 BeqJ[ qKr@0BeG  q?  .7JPBXbw@T J  >0J  .awJp@ ##V JЁ@F  >  /GX K  ? ,E H <tG AG ] ]  }( 0 8 @ #kG0#pB  ~
 0 x^C^tG~޴>
 ,G[GG{GG HGGPvZk . #" C. #  ,TGGJRQJRb# HFG`@G  G2 . #" C.TGGJRQJH bCFgADG$    C" c.CGtGF .SrJ8 b CJGF,ADG  #. " C. # }yH0JRPJ4J2Fu JzqHF = .1v<J0 }G1G J2GJ7J
 = WG7F =G .4gK
 -AJ brAJJtJFE ]#F >E
 =G ,G .J( =@HaJWJG D <C CGF >GtGADGG  0  #" c.Cx bG2J .SqJJ CFG,AD@=G T 0>H!!HF@= Cs_TGP\=! CRJPJ&VH9VJF;aKH8K!KfGGfSH7J8v KDDPݴ@[_Hݦ  B@GJےJJ8V KِJ;V`K7JK9!KaKF;G( b7J6Jy KFFHݶ\GtGuZkB @<= bG CGtGuZk  B( bGGTGtGuZk ,    BaH( b@@ HG D <GtGuZkGCAb#p@GTGN@B@D bG CTGtGcuZkBP@bF G CTGtGZuZkB@b CGGtGRuZkB@P bG CTGtGIuZkBP@bR G CTGtG@uZkB@b CGGtG8uZkB@L=!bG CTGtG/uZkBP@bN G CTGtG&uZk  B	@( bGGGtG:uZkB@CbGGTGtGuZk  BЍ@( bGGGtG)uZkG , $!Gg	Ib@E HGD <GtGAAGx]]}ݤ=#k`#
 0 P^ p"X~ "`
 "hBp޴x>^GH^G  ~ 0/ P# P.G
 ,C .G
 . :KG SJGBb## H J JGtG
@D	G
G,  4G 8D  
G% G .C .G . #"GUJPb#J=# # CF > C  ޶ C C C JG_DP B
G	 @X b G CGtGtZk	G , !GfHIH bE H!AD <GGtGAGH]P]X}`hpݤx=]#k          F  !F   p. 0 aJ    .J  3bJ GvF  rk 0/ #8K    0.0J  9"K G1G  2k .  .TJJF .3bJ GWJFvF  rk x/  0.[xK0JyG 0,9"K GA0H1D1G  2k@#4G ^ ^ ~  GP [G  ~#X {G =iZk0 ?&2?J` Bs Hh b  ?$ = SF G@ }G	  C4G _"G4~Zk8 D `x D   BC bCGGG<hZk   }( C = ?'G }#~H _&0J B & 9# R" "3aJ9W$Kr@ }B( @ " GyBC }$ =CG   }C, ] C0 =8v KG0 G b C0J0 G  G GGG/jZk
   =G  B4G( b!v H CJhZk GG x }4G  B( b ` 0v J@hZk G= ` =8 D  h ) Gp = _&  B4G( b 2F   }3v`J C-hZk G* Gp BCCx bCGG CGGGG~Zk8 D `x D	     BG( b4G0v JhZk G È }4G  B( b#v`H C	hZk  h  G }$H CTD  G ] ] }   #k    #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#C ^PB`[tG  ^( ~0 GG  ~G >Gh{GTGEsZk  c"Gb#a@0V H`1 HJtG D  . v H . CJTJF;@ =GGtGxb . ! qHP JF  >G =fAG ]  ]( }0 @ #kG#
 0  ^TG  ~( G  ~G > ^ C"
 ,G . c.G HJb#SrJF8@ =GGbtG . ! qHP JF  > =G9AG ] ]  }( 0 #k#TG  ^( ~0 8 G  ~G > ^   .G #,G JH {A H CFG ADG|   &?"GTG8 bG  4GB   p ` BG &_"h btGrZk 
 ,
 #  "  $. H c#rHQ $J2F  $> }
 C" . . J "xJW JF > = # C/ , [K 9 dAK B@ H D <b@ 
 #. p. " 2JGt5JS uJGtF p>tG ݢ . , v# JaJ@ Hb D < @GrZk 4GG( b , $ GG HY@  B!    ,  " 0H"@     .G "vtJU JF > # . #/GJY8K =X bFTG( ADGG   4G( bB GGtGb  ,   pHA  H0D   <G =AG ]  ]( }0 8 @ #k#B  ~
 0  > " ^ "(^G0~ C8tG@G
 ,G p.GG?b# H tJo~@D$   " C . . "GCJ?b#UJGFCCGGH@DG   . c" =CF .TJb#2'HJ CFGG9@ GGHbtG $,  pHA $H0D  $< =G9AG ](]0}8@P#kG#B  ~
 0  > " ^ "(^G0~ C8tG@G
 ,G p.GGp@b# H tJ~@DU  G "?b# =" C CTG@ . . "G  J?b#UJCCFG CGCGG~@D9 G = 0?b# =" C CTG@Ӑ BC bG4GgZk
   BC   bG CTGrfZk G  BC N@( bGGTGBTZk  B C  ( bG CTG:TZk . #  #.C G JGQ!J Db#F2H CH7@ GGtGb $,  pHA $H0D  $<G =AG ](]0}8@P#k# C  ~C0 TG8 ^@ ^H ~P X ` 
 ,GG
 ! Gb#G HG8@DGG
  C_0 Ba@C8 bG GGtGBqZkG #,  GpHH bA  H@0D #<0 GtGvAG8 ]@ ]H }P X ` p #k            p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k0#Cp^PB[tGx^~޴>^G  ~G CG{G CGGTGpZk , %   ]G Hw1@J@2V@J
 . p" /AJ
 " "a@F@  ] C J KG @tG GGCG:b# CtG|@Gp `:b# C CGtG|@
DG @ . " .p!GCJ9b#UJp"F C CGC CG}@
DGG @ . ! #,Ch =tGJKb#A(H	?EF C@
DGy @ BC	L@ bGGTG.SZk C-   #- "  &EII%I!H
IEp@I
 }# 0D  c. vHh ]G` ݦ0J tJr@J3bJ @F D @ 4JG ]-J
 =,pJJtJ b
QE0DC
RE4D ]=G
 =<G /p" . CC !	GJ BXK`JUJCG ?F >G4GeZkGp ]!b# @AGGtG_DG%   . c" .C  =CGJTJx+b#)&IF&IG CGG`@DG  ! C_   @BCbGGGtGpZkG $- !GjHbI (I@	*E $=GGtGF AGp]x]}ݤ=]#k# PB ^C [G  ^tG( ~0 G  ~G >G{GGoZk CG_G Cb4G LA  G
 G . #" C.TGGJRQJ =*b#F7b@G tGG(b 0. "r0HQ 0J2F  0> =GG@G ]  ]( }0 @ #kG#C ^PB0[tG  ^( ~0 8 @ ޴H P X >` GG   ~GG8{ CGGGoZk CGn_G CHb4G GLA  4G7  . #  #. !G@J*b#Q!J@F =С@ CGb@                                                                                                                                                                                                                                                   U                        ^4r $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        4 "           DG$   . %"G J CYCC C `G	GGD_ !0`C CaC	 A?0B9!K8b@ C@tG]oZk 0B@8bGPAtGUoZk , $!GhHXbE H@D <GGtG@G ]  ]( }0 8 @ ݤH P X =` p #kG#C ^PB`[tG  ^( ~0 GG   ~G >Gh{GG&oZk CG_Gxb C 4G/LA  4G  = c" .tGG . 1"*b#TJ J . =JF5c@G tGGb 0. "r0HQ 0J2F  0> =GG>@G ]  ]( }0 @ #kGp#C0^PB[tG8^@~HPX޴`hp>x^~GG  ~G{GGGGnZk CG_G Cb4G Ga@KA  4G3G  BC( bGG_"tGnZkB& !Р@b CGGtGnZkB: =!b@ CGTGtGnZk C_8 & "HsHRHPH9V K8K!K;vHGzS K "zG8  =#) ].  & =." ]!RPJQ0JTF) ]>3F& => . . ]/JWJ /ZYKFJ{JXKAGG ]? ? " ,TGG   HGr1 H8 b1J 2F   C . .JWJFxADBG  P@b* }!G CGtGfnZk ,  \ C8 Ц@ HGX =2Js HBbG SF8 1>JX =GT TGtGOnZkBPCb@GGGtGFnZk .   , #  ,CGJEH ]*b# HFGb@G C_% =/"  " /H{HY%KXK:GG% =?" ? C_8 ) =.& = & .HRHPH:V@K9VHD;aKAK8K!KzGGzS@K%HQ!JrHPJ8v KEG3F) =>F& >D8 D .o @ "  e/ J % FzJ[ eKP@zG  e?   CD E.0 HBsHbR AJtGSF E>GmZkBР@b CGtGmZkBbP@ CGtGmZkBCb@GGtGmZkB
CbТ@GTGtGmZkB@b CTGtGmZk8  , e! % BȰ IbF HjI CD <@8 =GD E.'ItGs!IR AJ1 e!SF E>GmZkBЩCbP@GGtGmZk0 E-  BP@( bGJ EI0 E=D1 %-GtGGI +I1 %=mZk D- !GeHb@J HIG
EE D=GtG@G0]8]@}HPXݤ`hp=x]}#k#C  ^PB[tG( ^0 ~8 @ G  ~G >G{GGGhmZkBa@ CbGGTGtG_mZkCG4_  CG4G 4G;V Kx1 KaKGb aJA   G . #" C. " =G c.JGRQJ!v H*b#F ] tJ Cb@G =GGtGb . ! qHP JF  >G =n@G  ]( ]0 }8 @ P #k#C  ^PB[tG( ^0 ~8 @ G  ~G >G{GGGmZkBa@ CbGGTGtGmZkCG_  CG4G 4G;V Kx1 KaKG(b 	JA   G . #" C. " =G c.JGRQJ!v H*b#F ] tJ C1b@G =GGtG8b . ! qHP JF  >G =@G  ]( ]0 }8 @ P #k# PB ^C@[G ^tG  ~( 0 8 ޴@ H G  ~GH{GG CGGlZk CG_GXb C 4GGIA  4GW G . C" c.@GGJ =SrJ*b#P@FGGG b@DGC    G.GJX C- @G  .G JJT 7VJ5JJFS   %/zJ0BY%K:G  %?  g/gKP B `    ,G HeJL 3V`J&HaJDK   /wH0BXKG  ?  .JH B    G/GKF   .ZC:V@K JAK6JP`CFA   G.sJRGJSF  G> / "Gy7Hhb@X KGG ?GtG@G ] ]  }( 0 8 ݤ@ H P #k g.SgJrF /XKG %/
JY
%K:G %? ,@HD E.REJSF /
HX
KG ? '/Y'K5G ,@HD G.
JR
GJSF G>À#C8^PBp[tG@^H~PX`޴hpxG  ~GGGx{ CGGGkZkpBa@xb CGGTGtGkZkCG_ G C 4G;V Kx1 KaKGGb 4GHA   G . #" C.C =GGJRQJ =!v H*b#F CGa@DG  * # C_- =,* }#* ]/HqHA;HZ[Kd  2D- =<QG* ]? C_. !d  C_@ =. "" =.wH@R KP K0V J:V K?G!!HJ;aKAK0DzGaS H9>K:v@K9D:D@ =1 .H. ." ]" 2JVJUJFF1 >. >?F  &/r&J f"xbP@Y &KG2G  &? C( ]GD ,0@KtGtSKpB@ H D <xkZkpB@xb CGGtGpkZkpB P@PCxbGGGtGgkZkpB @xbCGGGtG^kZkpB @CxbGGTGtGUkZkpB @xbPCGGTGtGLkZk@  &  . "pB@ HxbP JqHCF >G@ ]GD .GJtGwUJV JGF >@1kZkpB P@xbЪCGGGtG(kZk\ 1 "0 &,P@pBtG DxbpHA &H0D0 &<` =GD1 .p J CvTJU JGF1 >@kZkpB CxbGGTGtGkZkpBPCxbGGGtGjZk   -  G`Hb@H IG E =GtG3@G8]@]H}PX`ݤhpx#kGP#PBp^tGx^~޴G[CG  ~ CH =G{G#GGjZk CG_@ '   {#a@ }( =  C = ] #  e#  .K E"G J  %/ E/8KZ
XK:G C4 C   %. e.K E#C;JS{J3F8 F| X Fx  N .GK .p@K ,GGJV
JXKF CGZJ{ZJDH@ BGDN ?K <GH bG  G`Zk D 8 D  4G\0 ( "+ "3 " C$HB0 7 B C)   CVB& @  1/ 1K$G-    q/[ qK  q?# ;B  , H D$    q.S qJ  q> ;B?F  . JF   /X K  ? ;B  . JF    1/Y 1K  1? ;BB_B    , HD   .U J  >" 5BB0 B;  8 b C CTG^Zk  4G %. "
 E.tGG0JR
PJb#G2F C C&@4G .   #.TGGJQ$Jx bCFG~
A  4GD  G e. E"
 .   .tG #.rJT
JG Jb#Q JtFF Cp@&@ GG4G@ bGA  4G  #.Ё@ c. C"  ,TGG2JSrJh b H3F'A] .Z =,Z  HbPJqHA%HF1D] >Z =< " d.P@G`  tJGBw1`J6Jb  F` } CGtGiZkBf  bЀ@ CGtGiZkB PCbP@GGtGiZkB Cb@GGtGiZkB CbЂ@GTGtGiZkB PCb@GTGtGiZk , $ x  "@b H1Jr HC 2Fx  .GB6HG JGwJtG Fx iZkB бCbP@GGtGiZk0 ,1 D"B  P@b H 1 $. C }tG 2J4~Juq JGF }GtiZkB CbІ@GTGtGliZkB PC@bGGGtGciZk C9_e =/b /b  HY$K{HXK%Ge =?Gb ? C,_Ӝ  C)_x i ]/f  f ,HRHPH'VH9VHD;aKH8K!KgGG*b#gSH%HZDKaHFH8v KDPGDi ]?Df <x  C" .C c.tGGJSrJ@ =GFI_@GH GGGbtG ,  f'HD HD  <H =Z@Gp]x]}ݤ#kG# PB ^C [G  ^tG( ~0 G  ~G >G({GGhZk CG_G C8b4G FA  4G
 G . #" C.TGGJRQJ =*b#F}`@G tGGHb 0. "r0HQ 0J2F  0> =GG@G ]  ]( }0 @ #kG# PB ^CP[G  ^tG( ~0 8 G  ~GG >X{GGhZk CG_Ghb C 4GEA  G4G G . #" C.TGGGJ`*b#RQJ =Fa@G G@xbtG 0. "s0HQ 0J3F  0> =G@G ]  ]( }0 8 @ #kG#C8^PB[tG@^H~PX`޴hpxG  ~GGG{ CGGGkhZkBa@b CGGTGtGbhZkCG7_ G C 4G;V Kx1 KaKGGb 4GcEA   G . #" C. " =C c.JGRQJ!v H)b#F ] tJ CGGa@DG  * # C
_- =,* ]/* }#HA;HqHZ[Kd  2DQG- =< C* ]?_. !d  C_@ =" =.. "wHR KP K0V J:V K?G!!HJ;aKAK0DzGaS H9>K:v@K9D:D@ =1 .H. .@" ]"VJUJFF1 >. > 2J  &/ f"?Fbr&JY &KP@2G  &?G( ] CD ,0@KGtSKB@ HtG D <gZkB@b CGGtGgZkB P@bPCGGGtGgZkB @CbGGGtGgZkB @bCGGTGtGgZkB @PCbGGTGtGgZk@  . &  "B HbP JqH@F >C@ ]GD .GJGwUJV JGF >tGgZkB P@bЪCGGGtGgZk\ 1 f"0 &,P@BtG DbpHA &H0D0 &<` =GD1 .p J CuSJT JGF1 >GgZk -  G`HbH I@ E =GGtG@G8]@]H}PX`ݤhpx#k#C( ^PB[tG0 ^8 ~@ H G  ~G  >G{GGGVgZkBa@bGCTGtGNgZkBb@ CbGGTGtGEgZkCG_ = C G!V Kb$V K x1 KHy1 K!HG !G =4GBDA  4G G . C" c. " =G =J .SrJG4v J!v H =F *b# J C C`@G  =GGbtG . ! qHP JF  >  =GK@G( ]0 ]8 }@ H P #kG#C  ^PB                                                                                                                                                                                                                                                   V                        ' $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        b "           [tG( ^0 ~8 @ G  ~G >G{GGGfZkBa@ CbGGTGtGfZkCG_  CG4G G;V Kx1 KaKGb CA   G . #" C.tG =GJ)b#RQJ =!v HF C`@G =GGbtG . ! qHP JF  > =G@G  ]( ]0 }8 @ P #kG#PB  ^C[tG( ^0 ~8 G >G  ~G G{GGfZk CGk_G(b C 4GCA  4G  CBtGbBGGTGfZk  c"GtG =0V H`1 H)b#J D  v H . . CJTJF`@G tGG8b 0. "r0HQ 0J2F  0> =GG@G  ]( ]0 }8 @ #kG#    ~G ^tG G 1,GX{A  H 1<@G ]   #kG#C ^PB`[tG  ^( ~0 8 @ ޴H P GG  ~ CGGh{ CGGG)fZk`B a@hbCGGGtG fZk CG_C G_G 4GxbG $CA  4G GG4G xbCA  TG  . #" C.@ e.  GJRQJ = eJ *b#GF ]G`@DDGG .  Gq&HbP J@F >GGtG&@G ]  ]( }0 8 @ ݤH P ` #kG#PB ^C[tG  ^( ~0 G >G  ~G G{GGeZk CG_Gb C 4GBA  4G  . #" C.tG GJ)b#RQJ =FЁB{`@G tGGb 0. "r0HQ 0J2F  0> =GG@G ]  ]( }0 @ #kG#C  ^PB[tG( ^0 ~8 @ H ޴P X GG  ~G{G CGGG|eZkBa@ CbGGTGtGseZkCGH_  CG4G G;V Kx1 KaK4GGb tBA  ?  . #" C. " =C c.JGRQJ!v H)b#F ] tJ CGGi`@DG)  C _ CG tG;V Kx1 KaKG _B@ CGbGG4eZkB @CbGGTGtG+eZkB@bCGGGtG"eZkTG ,  GaHb@ H@ D <GGtGV@G  ]( ]0 }8 @ H ݤP X ` #kG#C  ^PB  [tG( ^0 ~8 @ G  ~G > CGG( {GGdZk  Ba@( bGCTGtGdZk ,CG H_  CG4G ;V Kx1 KaKG8 b AA  4G G  C" c.GG1v J .SrJ,b#J C =F C\@G GGtGH b .  q$HP JF  >G =@G  ]( ]0 }8 @ P #k#Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#
 0   ~pB0 >C8^G@^GH~tGPX`޴h
 ,G0[GG8{ HGkdZk . #" Jp@B E.  EJ@ tG GG8"8b#b@ C CtG~p@G8 p/b# C4Gi@G8 8b#0@ C CtGpp@G8 p/b# C4G|i@ .   ,CG CJhb@HG FtGADGf  . #  #.CGtGJXbQ!JF C"ADGGV  . #  #.CxbtGJQ!JF CUADGH  #,   . # = _'$HPJ2?J0Ds HGSF = .!v<H( 1'J  =
 " JuJ7JF7D:@ =3'KG .6J
 ,q6JvJsvJFDFD >
 <8  G ]/ C "H .ZUKaH[G ]?GWJp/b# CF >4Gi@GCC( b8 GG C CG BG0 GGGbtG ,  eJF HD  <0 = @G8]@]H}PX`ݤhp#k#
 0   ~pB0 >C8^G@^GH~tGPX
 ,Gp[GGx{ HGcZk . #" tG JB @ GG8"(9b#b@ C CtGo@G8 /b# C4Gh@ .   #, CGC JbA HtGFADGGf   . #" C.CbtGJRQJ CFGfADGGV   . #" C.CbtGJRQJ CFGAD ]GF  . #  #.4_J ##JQ!J 'Fu J
 = F 0vJ /G( 4J  ]8   KwJ8KFFB 6GKG ].J
 =.tJGJvJUF4FYF ]>6F
 =>G , C }/ #xJ@HaH[xK DaG < }? C/b#4GUh@GC( b C8= GG CtGIBG0 GGtGb $,  pdJA $H0D  $<G0 =D@G8]@]H}PX`#k0#8 x^;_"0 [tG^~޴>G  ~GG8 {G CGbZk0 B C8 bGGGtGbZk
 ,pa@  BC
 # ( bGG HGtGbZk . C" c.GGtGJX bSrJCF:ADGGH bGk  . #" C.CtGJRQJGFGADG]  . #" C.CGtGJh bRQJGFGADGM . #  #. # ] _'JQ!J3_JFt JGtF  .0vJ0 ݦ2GJ( =
   JvJ7JFFB 4'KG =.GJ
 =,rGJJtJ3F2D5F4D =>
 =<8  G ]/ C "H .ZVK{HAG ]?GWJ CF`0b#4G >g@GCC b8 CGG CGGBD@G T G&JВ J2FJ1!J0JQF0F@ C_T\ GP} C@6aK;~KFPݶ_H=`! C;>K9!KyGH=\_ } =!`H=GR`K:v K;bK9>K0!H!>HyG:G =FH= Cp_  BC( bGG GtGbZk0 B@8 bGGGtG+bZk  B@( b<="G CGtGbZk0 B@8 bGGTGtGbZk $,  0 B@8 bGA  H $<GtGbZkG8 8b#@ CTGo@  BЄ@D="( bG CTGtGaZk  B@( bF="G CTGtGaZk  B@( b CGGtGaZk  B Ѕ@P= ( bG CTGtGaZk  B@( bR= G CTGtGaZk  B @( b CGGtGaZk  BІ@L ( bG CTGtGaZk  B@( bN G CTGtGaZk  B@( b CGGtGaZk  B@@ ( bG CGtGaZk0 B@8 bGGGtGaZk0 B@8 bGGTGtGaZk  BЍ@( bH G CTGtG|aZk0 B@8 bGGGtGaZk  BЎ@PC( bGGTGtGkaZk  B@( bCGGTGtGbaZk  B@( b CGGtGZaZk0 B@8 bGGGtGnaZkG $- !GfH bI (I@	&E $=GGtG@Gx]]}ݤ=#k            p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k@#G^~޴x^G[8  C  ~GG#GG;?"WZk = . " /
 "
 #/ C"J #.X
K 0KF ݲ C/ " 2J C CKG  8"# C C C GG8=# C06b#tGm@D8G 8]"FX%F  0 Jb"   C C@BUZkG8"@5b#8" C CTGn@ . . # G8!J5b#TJ CCF C CGGCGm@DG =G6dJG "( b0 @ =   3D =C . C .GGJVJCFG3CBDG = !. A. "0JR
PJ2F =G8"8"4b# C CTGn@8 D @B8 !8  C C?UZk PBC"XbG CTGCZkPBC8!XbG CTGCZk . #  .8"0  C( JGUJEb#CF C  2H CG CGG_DG?< C" d="GCF(b   . c. CtGJSrJGFqA G .   #,d!G C J8 bA HCFtGqA . C. # Gk J =RAJH bCF CG%CBDG
 @T=# }G&JВ J2FJ1!J0JQF31`B }0F@ } C_TGP\=# C8H'HGP_H}`=# C8~K;aKGH\_` d"H=GG:!K9>KYGH= . . =UJTJF >F >D /$J ,{$JXKGHGD ? < "<qF $,pFD $/JA$HrJY$K3D $<2G $?  բVJWB  ղ B "GcVZk /G  `5b#@X K ?8  CTGm@$  @q Dp D  HqHPJF  W@B  & "D}qFpF  բwxJVJFW C  ղ T=+ ,, $"( d/q F$K@Ha$K[dK D+ <aG( d?Pp F  rR JSuJtJtF  rWB . "PݦqFpF  aJ@H DW@    \=3 .4 "0 d/qF$KPJq$K[dKF3 >qG0 d?H}pF  fJ@HagJ D  W@  6 "LݢqFpF  qJDPJF  W@B  7 `=; ,< "8 d/l  $KB@Ha$K[dK DaG; <8 d?@@ qDD? $.J< .vJQ4JUJ7FF? $>< >GGUZk  pD   gKA9H'DW C   w n "qFHpF  qJ@WJFW`B  q  GG ÐB@qDGGUZk  pDp P@gJFHDp W Cf GGBGUZk . $#GvIbU J "F > ,@ ,GGH@HtGD2@EG  0 Pb# CGD CtGw_Gx]]}ݤ#k բF ղG 0HFF . բ0`JFF ղ3 r0 JFtF rD 0J D D I 0`J D D Z 0JFF `  0 K?D'D   0 JGFF Gt 0 JDDt P#h^[p^x~޴GG  ~G#G(";?"4UZk #,   .
 "
 . ## H /U
J J 5D                                                                                                                                                                                                                                                    W                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        G "            C. K0b@G CJ(}#  0"  C C C G("p6b# CtGj@D(G (]"FX%F  0 J0b"   C CB-SZkG("5b#(" C CTGWl@ . . # G(!J5b#TJ CCF C CGGCGqk@DG =("G(]"05b# C0 @ = CTGwl@( D B( !(  C CRZk GBC "bG CTG@ZkBC(!bG CTG@Zk . #  .("   C JGUJEb#CF C  2H CG CGG_DG@  " =C  =GGG01 B  .?F .2'H8 b CJVJ("F CGEpADG& 0D"G&JВ J2FJ1!J0JQF0F0 C_DG@}L# C'aK;~KD@_8=P# C;>K9!K  yG8=L_P8 :K8KJXG8vJ . .UJTJF >F > ,  '/G D#Y'KH;G  '? $.rH("5b#TGQ :J $> CD $, /GA$HXK0D $<G ? @   sk@$  0q Dp D  HqHPJFW@B    & "qF4}pF  բwxJVJF  ղW C D=, $"+ ,q F( d/p F$K@Ha$K[dK D+ <aG( d?@  rR JSuJtJtFWB  r . "qF@ݦpF  aJ@H D  W@  L=4 "3 .qF0 d/pF$KPJq$K[dKF3 >qG0 d?8}  fJ@HagJ DW@    6 "qF<ݢpF  qJDPJFW@B    P=5 ; ,8 d/@ "$KB@Ha$K[dK DaG; <8 d?G0< "SZk? /< .JfJXKWJl  qD GF? ?< >pD =  q2HPJF  W@B  Bn  qD8p "GSZk  բpDwHVJFW C  ղ  B8 "GqDSZkB =r "GSZkp pDf5H@H Dp WB " F  d. D.4G $"KSqJtKRQJzFTF d>	C D>D $,7J , d#JA;H BfJ@H"'DF $< D <D $.J $/ "JQ5JrJY5K3F2G $>G $? / "zIb "X K@G ?G ,G ,tGGEH@HD@	    G Cb#GD CtG2_Gh]p]x}ݤ#k '/GY
'K;G '? 0HFF  բ0`JFF ղ r0 JFtF r 0J D D  0`J D D / 0JFF 5 0 HFF V բ0 HFF ղrt 0 H" F D Dt ml "jG#0B  ~ 0 0^0"8^tG@~HPX޴`h ,G p.GGGG6b#G H pJ C{h@DGGG  0"p-b# C4Gga@0B0= p"" D XD  0H C  CPZk . #/ #G0"J 6b#Y8KCCCF C CGGGG>i@D ]G|  . #  #.3_J #JQ!J ?'Ft J  tF 0vJ .( ݦ  ] JvJ7JFFB G =,EK ,qEK  A%HGGH2DD =< < HG }u3 HC =#46JK F eKG =,C }/GA9H[yK'D =<eGC }?b#GGtGw_DG8 GCC( bGGC4GGJ5B( 	 " D.qF pFsJR DJ VHDSF D>  բ&HHPHRH DwHVJ%VHFW C  ղ!!HH+  $#q G%D  zp Gp1H[qKpG  zW B&  
 d.
 D"GfHfF
 d>GD .  GuHb@T JGF >GtG@G0]8]@}HPXݤ`hp#k բ0 HFF ղ z0 HGpG z@#
 0#  ~ "X^`^h~px޴>^~ 0,G	 P.G }G0H .RPJ4J2Du H JF } "
 P/
 # p/?D!V HYK[yK9v~J[G{S@K J;G }!H C.:J  DG ݦ{ H
 . [GG(J  TJ  . C" .a@GGb#JTJ	G# JFGTG
G<@  G@G =CGtG 7b#R HP H1V J0J!J2v>HFsS JGSF =GGKg@DG) =?EX%D  0 I  B""C COZkGC-b#G4G-`@  %Gk!H bRH #!D  .TG ,	J@	H F CG+:BDG . #  ."G	CJPb#UJCF C2I   CG CGG_DG   " R IP I!V H)!I!H0vI!EqS HF = C_( G ɒ Kʐ K)V I;V KG*AI!I9!KaK	IE;Gi I8K9v KJ	8EҒ J	9E&I J4VJ I:V@Kѐ J2V@J3aJJ(IAK1!JAJtFE2F3fJ0J5'Iv Iq JpFF(F 4}# CQ_ qD4pD HR K{KJZI
[EW@C H `B! COZk@G   ]G2[J ]B@"!@G C9OZk7J`BG@1!CGQZk] # -D  vXIH I $ E == D .qDpDU J > D .J $/qJPJY!KF1G > $?$}  T{hJZHK[GW A  T `" "qF(]pF  ؠ`UIFHD  ذWB  $ ",=q Fp F  Qw9HRYJWFW C  Q & d"(q`F p`F  TI{ IZ@K[GW @  T `<  .  GvJ $ q DF >$p D  0rKQ7J2FWB  0u @   =q Dp D  h&Kt:KSzJtFW@C  ho $ ,$ D!4}& $ F H$ <% "D% .q Dp DV J% >  0ѿ"rJQ7J2F  0WB` @# ,dK  /hdK@HXK D# <G  ?
G $/ "XbztIY 4K  :G $?AA -G .GGtGIVJEE	@ `G C b# CGtGQ_GX]`]h}pxݤ=]}#k H0 K
_E
[E H1$ T0`J_G[G$ Ti ؠ0@IDD ذn Q0 H_FWF Qs T0 I_G[G T 00 K?F2F 0 h0 KFtF h 00J?F2F 0 P"@#6Jh^p^
 0 x~B޴>G  ~G p.
 p# .G
 P/GrJ
 ,TJ [KtFGw`J`7b# HF8V`Js1`JK( G#xF CtGe@D(GpBG	G% FX%F  0 J(]"  3\@ CGNZk(ݦG("Cp6b#F(ݶ CGTG<g@ . #  .	CG CJ6b#TJC("F CGGG CGUf@D	G G(= %v I 6b# CCTG^g@ (II(5 A(I  G  @?&G =C( G4G  `8b#F =  G]i@    %4GD C( =D@pB?D  MZk(ݦ("pB( # CF  CMZk ÀB(=#!b C CTG{ZkB( 	Cb CGTG{Zk .   #,("  (=!  JGA HDb# C C2I  ޶ C CFGGG_D	G  @B(=   C@NZk0=("pBG #4/J C0MZk $/@B(" CY 8K $?NZk  pB( (! C CwMZk ÀB(= "b C CTGH{ZkB( (!b C CTG@{Zk . ! ,T G CJX b@HtG F CGjA    .@ #,GG'vH JH bA H CF4GGzA0D}" =HHH0V JȐH V H!!HJ1!J(IH0Dr1 J1V J  E!&H'H` H!J'D  DqD0QF C%_D4}pD GapKZPKAGW B GW   D"0=q@Fp@F  &Ju6JTJFWB  Q ! $/" $ D!  q DY  K! $?  p DpKHIE  W@CH   D. d# $.JsJR[JQ;JTF3F D> $>G ,?E"GEb "y6I@ H #  D < #-&vH .@G!IPJtG	0EGER@	   G Cb#GD CtG_Gh]p]x}ݤ=#kG G0`K_GAG G 0 JFF  0 KEE P#    ~4J`^	 #h^
 P#p~x޴> 0,G P.G
 0/G H	 .R@JB2D .u H :KFG6V HGa1 HJ #" J  G7b## J6D CtGc@DG 	G B ]"FX%F  0 J3X@   CGyLZk'HG @?'H6b# =!4@'H  C CGF " = CTGe@ . . # G CJ6b#TJCF C CGGCGd@DG	G   @6b# =  C CTGe@  ݤD B  =!   C CBLZk GBC6^@bGGTGzZkBC =!bG CTG
zZk .   #, " ݤ	C  JGA HDb# C C2H   CG CFGG_D	G (ݤ(" HȐH!V HG0J(I!Hs1 J0V JE1Hr HJ2F(=pF C_0=qDƒ KȐ K&VH%V K?G(IH;aKHEeGfH99K%vHDDHРH!V H:AK!H0HAGq HpDF0=(wK բVJF ղW`C `B " ChLZk@G  (ݤG&H(ݴ@B ]"G CKZk`B " CWLZk @ HBG@1BGMZk$ , $# $ fKE HqDD <D .pDU J >,ݢ  pJWJFW B  k  (] D/ d" .qDSJZSK{SJTJEG D?F >,ݠpD  8aHY5K!GWB  8[  " "q F0p F  ѢwIVJF  ѲW@V $ d"4]q`F p`F  T{@JZ@K[GW @  TQ `&  0=qDpD  &Hy%HXKGW@  K  G . !q(IG "bP J@F > ,G .GtGHWJ	?ED@	   G Cb#GE CtG_G`]h]p}xݤ=#kG բ0 KFF ղb$ 0JFF$ 貏$ 80H?G!G$ 8 Ѣ0 IFF Ѳ T0@J_G[G T 0 HGG P#
    ~4J`^ #h^
 P#p~x޴>
 0,G P.G
 0/G H .R@JB2D .u H :KFG6V HGa1 HJ #" J  G8b## J6D CtGcb@DG 	G   B ]"FX%F  0 J3F@   CGJZk'HG @?'H 7b# =!4@'H  =" CGF C = CTGd@ .                                                                                                                                                                                                                                                   X                        Ә $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "            . # G  J`7b#TJ CCF C CGGCGc@D	G G = 6b# C CTG%d@  ݤED   B  =! C CJZk G0 BC6L@8 bGGTGzxZk0 BC =!8 bG CTGrxZk .   #, " ݤE  JGA HD`b#	C C C  2H C CGFGGj_D(ݤ	G  ("HȐHG01 B!V H0J(I!Hs1 J0V JE1Hr HJ2F(=pF Ca_0=<}"ƒ KȐ K&VH%V K?G(IH;aKHEeGfH99K%vHDDHРH!V H:AK!H0HAGq HqDF0=( CA_< pDzK !EH CD W @ @BJZk@  (=1;J(=P@  B "G C/JZkB " CJZk P@B H "@ CJZkp BG1 AGKZk$= , # "f$HE H d"D <D .q`Fp`FU J >(ݦGD -J ,pJHI@HE D = <,]  T{AJZAK[GW @  T_ `qD0 pD  xHUJFW @  [  " "q F4p F  ѢwIVJF  ѲW @V $ d"0]q`F p`F  TFJ{@JZ@K[G  TW @P `<&  ) /& .HXKyHUJG) ?F& >G . !Gq(Ih bP J "F > ,@ .GGHWJtGD*@	?EG   0b# CGE CtGo_G`]h]p}xݤ=#k 0 KDD ` T0@J_G[G T$ 0HFF$  Ѣ0 IFF Ѳ T0@J_G[G T        p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k#
 0   ~pB@ >CH^GP^GX~tG`hpG
 ,G[G{G HhTZk , #  #.CG H #J_H]#2b# CG0b@( GGtG`@DG  ( b4Ga1AD  H" C . . "GCJ1b#UJGFCCGGla@DGu  GG . "8 F .0 = "2v@JbJWJF CC3'J CFGGG.mAD DDY G . #  #. # ] _'JQ!J3_JFt J = tF  .0vJ8 ݦG0 =3gJ JvJ7JFFB 5'KG" ].aJ =.saJJuJTF3FXF5F" ]> => CG# ]/C& ,# "GwK`wKDHbZWKD@G& <# ]?CGGGtGA D   G G . #" c."  D8 =JGSqJHxb?DF( }2H C CGcA@ GGG}b#tG ,  aHE HD  <@ =@GH]P]X}`hp#kG#
 0   ~pB@ >CH^GP^GX~tG`h
 ,G[GG{ HGSZk #.CG #J_H]#2b# CG0b@( GGtG_@DG  H" C . . "C1b#JUJGFCCGG`@Dy  0  . "8 =C3J .GUJ?FbJ CFGGGGjlA DG   . #,  ( =TGJbA$HF2A u @   TGU G #,   . " = ?'$HPJ2?J0Ds HGSF = .!v<H8 1'J0    JuJ6JF6D9@ =3KG" . J ,q J`Js`JFDFD" > <CG& =/# "# .uKY5KauKbVJ:GGFC& =?C# >GGGtGAD  = . c" .G8 =!HGJTJ( }?Fb2GJF CcADԟD@ =GGtG}b# . ! qHP JF  >G@ =,@GH]P]X}`hp#k0# p"  ~
 0 ^B^ "~tG޴>G P.@"
 ,G .GGG SJ2b# C# H JG C_@DG  @" . C . "GUJ@2b#JCFGCCGG_@D 8 0 = &( } "F . C .G@#WJ@b#JCC CG  >2'HFGGGL_D ]  . #. # 3_JJQ!J #Ft J _'tF 0vJ .G8 ݦ2GJ0 =
   JvJ7JFFB 4'KG =.EJ
 =,rEJJtJ3F2D5F4D =>
 =< CG ]/ "H .{HZVKCAG ]?GWJ CFHbG >GGtGADi B  "b C CGGtG`RZkB4 ' b	 C CGGtGWRZk . . #" G8 =JGTJH8 b?DF2GJ CGGGkA   GA GB@ b C4GGZk)5@G  HG(IH@@ B@]"GH b CTGFZkB@b@	GG2%AGtG!RZkHƐ IȒ I&H(V IID3  '-`H G"I'I\="	 E '=H= H&H0J!V H!HF* @  r.t2H C4GSrJtF  r>6_  G $/ #{HGAY 8KG;G $?G@~b#tG@G]]}ݤ=#k '-
HI
'I	 E '= r.
2HS
rJtF r>`#
 0   ~pB@^TGH^tGP~X`h޴px>^G
 ,C[GG{G C# HGGQZkB a@bCGGGtGQZk0 CP@G0V H`1 HJ DG0 _BC8 GGbGtGQZk & 0  C   "G  H.sJDb# CTGRHJ	GSF  H> . .JUJFz@   G . #" c.CGCJX bSqJ  CFG8 = CGGGwA  .	GJ   "_   ] .@ .GG2v@JJbUJ CF4GGA0 B
@8 bGGGtGWQZk &,  G #" Eb#A  H &< .tG C.JRQJ CFGA{@x    BG( b4G	TGFZk @Aq I   .DG:GKP  J "F   >( ]WK zWK   =!2GJ4J2AJ JTFSF ]HG =/`H / ";GGG!G =? G ? . C c.tGx bJStJFCGAӊ G
 &,
 &! " F"A )H
 &<D &.
 " "4GQ 0J &>D f.S rJ f>D
 .U J
 >D .W J >% ` BCh b CGTG}sZk  B( b C4G.FZk ,  iHG HD <  H-G HIJ5  0V J*AIJ
PE4    H.sHIRHJSF  H> .   J0@	G . "Gw5I~b#@V JGF >GtG@G@]H]P}X`hݤpx=]#kG H.
JR
HJSF H> (.Q(J0F9 (.Q(J0F H.
HIR
HJSF H>à# p"  ~
 0 ^B^ " ~tG(08޴@HP P.G
 ," .GGGG3b# SJ C# H JG C\@DGG  " . C . "3b#UJJ"FGCC CG|]@DG  . #. # 8 bTGJQ!JCFG@ D   Gv  #,   . " =]#%HPJ2?J0Ds H
  SF = .!v<H8 G@ 3gJ J0 =wJ5Jxq KFG5D =6'KG ].eJ
 =.seJJvJTF3FWF6F ]>
 => CG }/ C =, "GUK`UK[uKGA5HCeG }? DbG =<GtGA D   G1 G .% "$ / c" .C .J XK8 =JGTJH  >?DFC ~F( b@2GJ C CbJG;jA D   G G( 0@ BCbG2vHGtGOZk(  G(v I0 A ,  GfHb#AE HGD <GtG@G]] }(08ݤ@HP`#kG#
 0   ~pBH >CP^GX^G`~tGhpxG
 ,Gp[Gx{G HOZkpBa@xbGCTGtGOZk #, "CPb@ 0HG_GP"04b# C0 GGtG[@DGG  0 4G8 b,ADG  P" C . . "C3b#JUJGFCCGG\@D  8  . "@ =C3J .GUJ?FhbJ CFGGGGVhA D   G  #,   . "  = ?'$HPJ2?J0Ds HGSF  = .!v<H@ 4J8 % =" JuJ6JF6D9@  =5KG* }.J% ].tJJuJwFTFCvF* }>UF% ]>GG. ,P ]#+ =, C+  `Kr@KGDHbA HCD. <G2D+ =<GtGA D   GX  ?"GCbG D 4GB   }  " .G .6v`J@ =HGJUJ0 }?D( b2GJ CF C^A7 GP C2b# CGTG]@ .   , #" #,CGJ@Hpcb# 1H FCGׯ@ D   G G . #" c. " .G .J SqJ J@ =WJG8vJH0 FX b?DF2GJ CbJ CbAGH @GtGb# $,  pHA $H0D  $<GH =@GP]X]`}hpx#kG#B  ~
 0 @^ "H^@"P~tGX`h޴pxG
 ,G p.GGGGp4b# H tJ CZ@DGG3b#G  @" . C . "UJJCFGCCGG[@DG  . #  #. # ] _'JQ!J3_JFt JGtF  .0vJ8 ݦ2GJ0 =   JvJ7JFFB 4'KG" =.GJ =,rGJJtJ3F2D5F4D" => =<CG& ]/C# "G# .vKZVK`vKbEG& ]?GWJCFG# >GtGA D  GF G . #" c. " .C .J SqJ8 =JVJGH8 bF?DF2GJbJ CGGkiADG) ( =CG4Gb!v H  G}B    c" .G .G8 =HGJTJb#?D2GJ CFG_ 8 D DBCDb G@TGtGMZkTG ,  GaHb#@ H@ D <GGtG
@G@]H]P}X`hݤpx#kG#
 0   ~pB@ >CH^GP^GX~tG`hpG
 ,G@ [GH {G HMZk #.CG0b@ #J_H]# 5b# CGG( GtGY@DG  H" . C . "GUJP4b#JCFGCCGGZ@D  0  . "                                                                                                                                                                                                                                                   Y                        xEG $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        S^ "           8 =C3J .GUJ?F8 bJ CFGGGGxfA DG   . #,  ( =TGJ( bA$HF,A u @   Gx G #,   . " = ?'$HPJ2?J0Ds H  SF = .!v<H8 G0 3gJ JuJ6JF6D9@ =7KG" ].dJ =.sdJJwJTF3FUF7F" ]> =>CG& }/ C# =,# =#GYK`YK[yKGA9HCdG& }? DX bG# =<GtGA D   G4 GGC bG4GB   . #. #  G8 JGQ!JH( }Dx bF2GJ C]A G . }" . #  .G #.J UJ8 JGQ!JHh bF( DF2GJbJ CaAG@ G@btG $,  pHA $H0D  $<@ =G@GH]P]X}`hp#k@#B  ~
 0 x^ "^8"~tG޴G
 ,G p.GGGG@5b# H tJ CX@DGG4b#G  8" . C . "UJJCFGCCGGY@DGo   #. " C. ## } '0JRPJ4J2Fu J
 ]"F = /1v<J0 G( ]5J KwJ8KF8F;B =9GKG .J
 }.uJG2Ky2KFuFF >yF
 }>G =.8   , C }#;HQ;JsHGH4F =>D <C8 b8  &C G CGGA D  G( G0  " .C( = CFG C .UJ( b3'HJCFGGieADG  . #" c.@  =GJGSqJb!v HFG C4G.A4G ,  GaHb@ H@ D <GGtG^@Gx]]}ݤ#kG# p"  ~0>#( >
 0 0^ "8^B@~
 #HGPX޴`G P.G
 ,G .
 .G SJ C5b# H J JtG3X@DZ  0" C . . "GCJ 5b#UJGFCCGGY@DGF    . c" =CF( b C .TJ2'HJCFGG]ADG2  . c. C" =GJX bSrJ!v HCFG C4GA  C"GtG bDD  .D c. CJSrJCFÚA  .   #,G  $vH ݤ JGA HDx b2HF C Cw^A( ݠGGh bG ,  dHtGE HD  <( =@G0]8]@}HPXݤ`p#k            #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#    ~G ^tG G 1,GP|{#A  H 1<~@G ]   #kG#    ~G ^r@J G 1,tGGp|{#2D 1<Gh@G ]   #kG#    ~G ^r@J G 1,tGG|{#2D 1<GR@G ]   #kG#    ~G ^r@J G 1,tGG|{#2D 1<G<@G ]   #kG#    ~G ^r@J G 1,tGG|{#2D 1<G&@G ]   #kG#   ~G ^   1,GG q"|{#tGA1H2D 1<TG?F .T J >@G ]   #k	 1,GA
1H2D	 1<#    ~G ^tG G 1,G}{#A  H 1<@G ]   #kG#   ~G ^   1,GG q"0}{#tGA1H2D 1<TG?F .T J >@G ]   #k	 1,GA
1H2D	 1<#    ~G ^tG G 1,GP}{#A  H 1<@G ]   #kG#    ~G ^r@J G 1,tGGp}{#2D 1<G@G ]   #kG#    ~G ^r@J G 1,tGG}{#2D 1<G@G ]   #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G ^G ^  ~( GG  ~Grb# @ . G # GqH{b#P JGF > GtG>@G ] ]  }( 0 #kG# tG  ~ 1  ^sH G Q.tGG |{#R AJSF Q>G%@G ]   #k        #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k #
 0  ^C ~TG   ޴  GG  ~ ^ C"
 ,G .G c.GG HJ8 {SrJGF@DBG  @CbGP FO  G TGtGIZkBP@CbGGTGtGyIZkB@b CGGTGtGpIZkBЁ@CbGGTGtGgIZkB@b CGGTGtG^IZkBP@ bG CTG(~ZkB Cb4GG~ZkB @bP@ C4G~ZkBb2@GGtG^IZk"     ,GEHD  <GG  .   #, CGC J( bA HtGF@DGG  . #" C.C =tGJp?b#RQJ?DF CG0s@D G  = #" C.0J c.Ca HGQJbSqJ0DSFC2D =GGTGBD =G B@!!H =Cbs1 H!V HG!HGaF =TGtGHZk P@BCbG%H tG0VHe1HJD GTGHZk  ݠB@Cb&H ݴG0VHf1HJtGDG ݴTGHZk<  BЁ@Cb%HG D 1VHe1H!JTGD GtGHZk@ B@Cb%HG D 1VHe1H!JTGD GtGHZkBCbG4G~Zk 5@  X %HX BP@CbGGTGf}ZkBCbG4G}ZkB @CbP@G4G}ZkBGb2@GGtGHZkBP@CbGGTGtGuHZkG ,  GaH@yb#@@ HG D <GtG@G ] ] }   ݤ   #k ,GE
HD <0#
 0  ^tG ~   ޴  G  ~G ^
 , C" .G c.GG HJ?b#SrJGFCOr@ DG  B@bGGtGtGJHZktGG G  #  .rH #.C HGJ8bQ!J @FFC D GGTGBDGG  +b#C4GS@ӈ   C/_B@bG  CTGtGHZk ,  aHB
 "b@ HC D <D
 $.Ё@@ Q 0J
 $>G, ]GtG2AJ ]v1@J2V@JAJF ]TGGZkB CbGGGtGGZk4 ݠ@BCGb&H ݴTG1VHf1H!JtGD ݴGGZk8 ݠBЂ@Cb&H ݴG1VHf1H!JTGD ݴGtGGZk< ݠ@BCbG&HTG D ݴ1VHf1H!JtGD ݴGGZk@ ݠP@BCbG&HTG D ݴ1VHf1H!JtGD ݴGGZkD ݠ@BCbG&HTG D 1VHe1H!JtGD GGZk ,  H ݤ $ ! "@B@ H <D .ƒHGsHHbP J >D  D.vJCGR DJ4GSF  D>D! .F! >|Zk 5@  X %HX P@BCGbGTG+|Zk@BCHbG4G|Zk@B @Hb P@CGG4G|ZkBGb2@GGtG^GZkTG ,  GaHpyb#@ H@ D <GGtGv@G ] ] }   ݤ   #kG0# 0  ^tG ~   ޴  G  ~G ^ , C" .G c.GG HJ?b#SrJGFC!q@ DG  @B@HbGGGtGGZkGG G  #  .eH #.C HGJhbQ!J DFC D GGTGBD  =G B@!!H =Cbs1 H!V HG!HGaF =TGtGFZk$ P@BCbG%H tG0VHe1HJD GTGFZk( ݠB@Cb&H ݴG0VHf1HJtGDG ݴTGFZkD  BЁ@Cb%HG D 1VHe1H!JTGD GtGFZkH B@Cb%HG D 1VHe1H!JTGD GtGFZkpBCxbG4G{Zk 5@  ` %H`   BP@C( bGGTGL{ZkpBCxbG4G{ZkpB @CxbP@G4G{Zk@BGHb2@GGtGFZkP ݤP@BCbtGHŐH V H%HH!H Dp HG 0DGP GTGOFZk ,  GaHyb#@ H@ D <GGtG@G ] ] }   ݤ   #kG#
 0   ~ P"H ^tGP ^X ~` h p G
 ,GGG H C@G `E GC.b# CGtGAR@G CP%b#G4GMK@ӰB CbG4Go{Zk C  ,     H XD
  BbC4Gd{ZkC . ! P J  >CBGb4GY{Zk 5@   =!/H = . #" C.CGtGJ0@b#RQJCFGo@DG  @ 4G D.sJR DJSF D> "D .wJGyb#@V JGF >GtG@GH ]P ]X }` h p  #k#
 0   ~C@ ^4GH ^P ~X ` h ޴p x G
 ,GGG9b#G HGK`@DGG.  8 GF05 B0J	B  & G . #" C.CGtGJ@@b#RQJ CFGo@D G  -b#CG CGTGjS@BCbG4GzZk0 @  $,G4GA $H $< "D $.sHGzb#@Q 0JG3F $>GtG@G@ ]H ]P }X ` h ݤp x  #k #
 0  ^tG ~   ޴  G  ~G ^
 , C" .G c.GG HJ@b#SrJGFC[o@ DG    B@( bGGtGtGVEZktGGt G  #  .eH #.C HGJH bQ!J DFC D GGTGBD4 ]G[ BC ]@bG GtGEZkB@8 CbGG GtG	EZkB@b C GGGtGDZkB@b                                                                                                                                                                                                                                                   Z                        ZHo $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "            CGGGtGDZkB@< CbGG GtGDZkB@ @CbGG GtGDZkB@ CbGGGtGDZk$ $,GG$  `.b#rHA  HP  2D@$ $< CTGR@P BX b C4G&zZk@ $,  GpHzb#A %H@0D $<GGtG@G ] ] }   ݤ   #kG`#4G` ^h ~p x  ޴   G  ~GX ^ .   #,GGG Jh {A HGF#AG  G  #, C" #.tG   #H@ =?D 2J6    ?"GGX b   CzBDG   G4Gb̉B , # H  "
 C#8 b HFD 2FH 6H .
 "C2F@ Jw1J FH 
 #/ vH :K0 B9"K  GH TG
 #, 0HGx D  GxZk  G @ =4GG  ?Db?Du  B  G G4G  CH b@ GfBG C  G bTGBR  P =G . !" JC#  G " "  . "  u/0B0`B J[ uK`J "`G  u? " !. 0JB    V. #  u/0B0`B VJ[ uKqUJ "qG  u? " A/ XKBCGC ;, CGA ;H ;<Ab#GGtGm@ GP =C?b#TGyr@ GCP =TG0@b#q@DGG?@ 4GbF CB!  G Cx b@GTGJXB8 ݠ CG4GbB     G GGCbGTGBӀ B`@P _" btGCZk -  G`H0{b#H I@ E =GGtG@GX ]` ]h }p x  ݤ    #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k0#0J ^4GG ^ ~   G  ~G X {GGGA  C  GL G  .
 "	 @.C  BtG J( bR@J2F =G
 .G . CGJVJF HCZk  B CC( bGGGtG?CZkp B Cx bGG4GxZk  B0 @( bGGtG1CZk G0 b h b C%vHG CGGGG	AD  FG  GCH bG C CG4GGGAGG ] ?D ] }    #k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G ^ ~  GG  ~G
b#"@  G
 `X GGtb#GBGtG@GG*b#zN@h BG  _"p btGBZkG
b#"4G@btGX "GGG  G  tb#G@GG*b#^N@h BG  _"p btGBZkG ] ] }  0 #k    @.    `. @AJSaJSF @   GkG . " .  @JWJFVF @   Gk Gk0v J    . . " @JVJFF
    2      /  / KY
 K G   Gk Gk P. 0  p.G AJSaJ   SF_ . " . 0 JWJFF   / p/  K aKG  0B   Gk . J  .v JWJUJF >F  > Gk        p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# 0   ~ P" ^4G G ,G{# H   p. .rJTJtFG_G ]   #kG# 0   ~G ^ q" ^  ~( 0  ,GGG HG	   . 8 DDT JuSJF > G . "W J > . # #/GJ( bY8KCFGTG@  #  . C"GTGqH8 bP JF >GD . c.JSrJFE@Gwb#GGGtG@G ] ]  }( 0 @ #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#G ^TGG ^ ~  ( 0 ޴8 G  ~GG@ {4GBHGG&b#    1M@( B  G0 bGtGfAZkpTGG?"` b^_"x   CGGG
AxA @Gq!@  Ġ4G@ bTG  BӃ F.H &.sH  $GRFJGQ&J&b#TF F>3F &> . .JW
JF C  L@  ĠtG  ( B . &.@ @0 bJQ
&Jr @F CG+AZk  Ġ  GG &.  . & CQ&JPJ &>  >D f. F.SaJ f>RAJ F>)  G  Ģ;J  E0BB / 6/B JKY
6K0BG CC " 8,B 8.BA0H 8<Q0J 8>  V. v.VJS
vJSF C @B  #  , `/A9H[yK  < `?_ C  D #G q.D ,JvJSxJFHwFDG q>D <Gb# @( B@0 bGGGtG@ZkG ] ] }  ( 0 ݤ8 @ #kkG C4G8  8   	  D 0.D 0 G P.X!J  `R
AJ2F  0 GkG#4G ^  [ ^  ~( 0 8 ޴@ H P >X G  ~G G( {GGGG|uZk@"G
  GG@! b# CGtG.b_ӂG@ @ H !   A   C  0 @   u(  q. . "qJV
JTJF0BJSqJuJF >uF  q>?F / 1/K[
7KXK[G0@CWKzWKY7KGG;G 1?G8gb# ?@" GG  頰CX  1H2u B
QB  	CG . .JW
JF C9  X ?@xC8KB 8# X/ x/YK[
yK[G C=  0 @P ?@pB0JB p" . .JV
JF C0  0 @W ?@wB7JB 7" 7/ W/1KZ
QK:G C#  0 @[ ?@{{C;aKB # {. .xJU
JuF C `0 @6!H'@	B  W ?@wB7JB 7# W/ 7.YKQ
9JQG C  0 @'@  4GG/  b G4GdBG GGG0@ W@b#4G    CtGa_ 	xD  D   ,@ b  H	 G` "!  & C   &.&J P b  CBbTG{Zkb#@ (A ?@g!@2H 	.:H ).	JQ
)JF CBpH . .vpHUJTJF >F > 	/5H )/	KY
)KG CC x# 8, 8.{Hr{HA;HQ;J0D2F 8< 8>1H i. .iJT
JtF CuBH 3/zH .Y3KWJ!GF 3? >3H i, 	.iHP
	JpD Cq@ C" c/H /tH[rKXKuG c?G ? ), , ݢ)HD
Hb4F$D C3@ " A/ !/JpJZWKY7KQG0G A? !?4G i, I.BiHR
IJ rD  C @khZk!HGb4G $- ,$I@
H  E  C @  .  . JQ
 JF C(  湕Bh0HG #-8H ,#I@
H  E  C @ H `. @.t HGS`JR@JuFTF `> @> . .JW
JF Cx@#H c/ C/i#H[cKZCKpG c?IG C?'HE @%H @. `.A@JS
`J SF  C @H , .vHDHUJD <F >   0 C  G  B( b4G4GsZkG ] D ]  }( 0 8 ݤ@ H P =X ` #k ,DHDÀ# ^ ~  ( 0 ޴8 @ H >P ^X ~` h p G  ~G ^GGGG{#@   GE GhG  V BvB6JB / 6/KY
6KG C3 0BZ BzZC:AKB . :.JQ
:JF C'  0BR BrRB2AJB r/ ,rK@
H `G  C  0BW BwB7JB 7/ .7KV
J6G C 0BP BpB0JB P/ 0,PKA
0HAG C  0BSB_XF ` 4GG ] ] }  ( 0 ݤ8 @ H =P ]X }` h p  #kGU BhB;I"BtHHb# /ytH . 4"HXKWJGF ? >rHF 4, C T/4GA1HZQK3DRG 4< T?F . ,GUJ@H > <__Ә"  BGGb#4G@  
G4G	b#4G@GG	b#4G@  	GGC)    ' q. .qJT
JtF C 0B " . J  / 1/KY
1KG CG   q/ Q/ ,GQK[
qKRQJ[G:DCQKsQK@HTF Q> D <  ɢ0 @B6@  GGC   ' y/ ,yK@
H `G  C
 @ M" -. 
" 2J   . .JW
JF CF  M/ -,MKA
-HAG CG   . .JU
JF C@-   -/ m/-K[
mK;G C0 b
  4GQB -. 
. G
HQ-Jr
HP
J3F ->F 
> . " .  WJ >VJ > 4/ # T/8K@
XKZXK`G;1`CxKY8K{xK@G;G T? 4? F" GHb#4G!  CY__ -, 
. -"4G-HP

J0D C   M.G m.QJS
qJSFQ ?B1!J@  q [ @Zk -, 
  
. HP
 J 0D@ @ H @ # G M. -" m.4GQJS
qJSFQ ?B1!J@  q [ @Zk -, 
.4GG-HP

J0 b0D CB -. 
. G
HQ-Jr
HP
J3F ->F 
>  5IGgb#B . .JY
JWJG0 CKVJxKFF > >G@ -, 
. 
  ?"x B H bP
 J M" 0D  C  D   m.G . .rJ .T
JWJtFMJxMJVJF >F >4GLfZk G -. -  
.  Q!J ->PJ 
> `. @" .rJV
JTJF51BJSrJuJFuF > `>0`A  AwAG4G	b#4G@G	b#G4G@GxG   [ ?@{{C;aK0 @@ [. {.[JS
{JSF C0F8  R ?@rRB2AJ0 @@ r/ 2.rKQ
2JR ?@qG C0F*  rRB2AJ0 @@ r/ 2.rKQ
2JR ?@qG C0F  rRB2AJ0 @@ r/ 2.rKQ
2JR ?@qG C0F  rRB2AJ0 @@ r/ 2.rKQ
2JS!@qG C0F  _ Gk Gk#  TG ^ ~     C( 0 ޴8 @ H >P G( { ^GGG  ~#  #Gتb#T^_B C@bG4GxZktG  BB  PR"b   .  . `" . . JQ
 JJU
JF CF C CxZk  4GBb @G                                                                                                                                                                                                                                                   [                        Ӎ2? $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        j- "           xZk  #  C  . @.{   JR
@J2F C_ . e" . %# %"JU
JF Cf @ . / E/JX
K e/ %,YKF . ,[
yK .1H  W
J[GBHbP
J7DDC C  > C C CGGGxZk %, .%HP
J 0D  C/   E. %" e.G	GQJS
qJSF Cx"F "F  Gp Ef   B6B@bG4GixZk  (,B E@bG (HTG	0 A`xZk !A0 A    M@TG
    .` "  CTG JL   I@G4GBbKxZkGb#J @B)D@bG4GBxZk  0@@0@@  "4GB  bGG	3AG2xZkBo@bG4G,xZkd  _  GBtG  F  @bG xZk@  b0@?B4GbGxZkG ] ] }  ( 0 ݤ8 @ H =P ` #k5BG  -` "  CTGI I1EG#4G ^  [ ^ G  ~G( {
eZk@ BF@H bG CTGwZkG ] ]   #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#`; "  ~X^G`^ ?$h~TJpwTJxG C .G .G HGVJ{UJ @F >F >0v H ѐ HGtGA D
  @ " CGtG mb#GGGY@G0"b#G#G@G ChbCGGGG4G4GGA D  G= b CCTG"AӠ4GG b# CE@ D@ "  G mb# CGtGGG/@G0"b#GF@ C  Gk .h #,HPJqHA#HFk >1Dh #<X]`]h}px#kG#4G ^G  ~ G    {#D@G ]   #k C[h 0,k 0.0HQ
0J 1D  kG#4G0 ^8 ~@ H P ޴X ` G G( ^#JG$!J  ~&v`H   b#D@G Cb CGTG@DG   G   GD =i #v`H &G1>J "qDs@ }8}H .pB   J Jd JyJ#v`HG G ,C =,FGHA HD$D <G8b =<GtG0ADBGU  }CbGGb@GtGzZkG  HbC CGTGADGA ` =GG4GhbG  .G J C$D  KADG1 ` GPBGXbtG@zZk } ,  @ H < =A."!.RPJQ0JA>!> }  . JU JFvJF  >  = Cb#
@DGG ` 4GxbGϐBGhb CGTG
@G  4G` b#D@G( ] D0 ]8 }@ H P ݤX ` p #k@#4Gp^x~޴>G0ۤGh^$JGG  ~%!J  'vH!b#	G  ^8D@G Cb CGTG#@DG   &?"GTGbG  4GYB    ÀB CbG&_"tGzZkG = CbTG@D	4GGw   GTG$b#$vHpBGG@ = C@b#	@DGh    ?'
 }#G P. 0"sHeHR QJSF P>G 0JJ.."pJWJVJ>> " C8KDD@ uH  xuHG -2H
 =,[Jr[JE8b0DE2D =
 =<GG .G .GWJVJFC >F >GtG4GGADG
  GBGbtG@yZk G 4G`BGhbtG $,  pHA  H0D $< =  q. qJS qJFtJtF  q>  C "  C]Zk	8 EG   b4GGBG CbGTG6@G4G   b#C@Gh] Ep]x}ݤ=#kG@# ^"p^Cx~tG޴>G  ~Gh^G  &;G . ~. HGGH{2HTJu2HSrJ @FuF > ~>0v Hѐ H GADGG  CbGCGG4GGͼADG  GC& (bCG CGtGADGy    "4GG1 F0Jb#NJ C2H4H BsB B(SBG@	G  Gc GGCCxb(I GG CGGGADGM   C'1@@  GG 0`H1`Hc@Bcr@#BG#AT B5JY`Bu@4J2 .5 /2 ":!KJX
K@z@F  GaB2 ,9!K5 -2 z#!HHH
I@a@ D  VaB2 A.'H5 .2 !"7JQJP
J@w@PF  'HbB2 .6J5 .2 #:IJU
J@z@F  (I2 ,2 z#5 :/@`BHY
;KSaB D  GPb#G4G@GCXbG CTGAGh] Dp]x}ݤ=#kG#4G ^  ~( GP{G ^G  ~   (!b# >B@ @b# =D_G  4G b# B@ G ] ]  }( 0 #kG@#4Gp^x~޴>GۤGh^$JGG  ~%!J  'vHX!b#	G  ^dB@G Cb CGTGO@DG   &?"GTGbG  4GB    B CbG&_"tGGxZkG = CbTG@D	4G  GG 4GbBӓ G 4G$vH  .   qHP JeHF  > ]..r"UJ>TJ> ݢ 6/ #zJY 8K:G 6?TG }PB  ;, ;HA ;HFpJ0D  ;< =Xbp#BG ClZk  $G(I4JDD @   = "G }.6'J ].JtJJvJuFTFwF }>VF ]>G ]/ =# }/yHhyH[yKZYKeG }?HG ]?GCCXbGGGGtGGiAD 	8 EG4   4GGbG8BG CbGTGv@' G GGTG$b#    CE@ = Cb#]@DG 	8 EG   }b4GGBG CbGTGV@G& Cb CGTG|AG4G   b#A@Gh] Ep]x}ݤ=#kG0#1!J^4G~޴GG^#JG  ~  %v`H"b#H >P ^zA@G Ch b CGTGe@DG  @ &?"GTGX bG  4GB@      B C( bG&_"tG]wZkG@ = C8 bTG@D  G@ GH b4GBө   BG@ &_"( btGGwZk0 ݤ#v`HB B $&H bCfD `@0 GT@2AB CGuZk> }. } ; ]. C; = 0 ݤHGSaJbtaHRAJuF> }> CTF; ]>0vHѐHGtGADGGw C bCGGGGtG4GGûA@  Dx bV]# %,  A &H %<P@@ p.P.0"SqJp>RQJP>1  @ 0  Cp BG . "ԐJxJW JF >@ ="CGtGvZk@ GBTGb@GkZk@ TGBb  %, %HA %HFpJ0D  %<@ =  . JT JFuJF  > C@ ݢpBGkZk@ ݠ0  GCP  C(b@GGGADG `@ =H a..A"0v JrJV
JTJF BJSrJuJFuF>a> GV"b C CTG}AG  4G0"b#@@G] D]}ݤ#kG#4G^~޴ >^ ~(0Gۤ^GG'v J  G  ~G"b#GGx@@  "" ?$GC H(bG DTJ @ wTJG .G .0v HVJUJFF >ѐ H >tGКADGG  CbGCGGtGG۹ADG  GC=!bCG CGtGADGG  ( 4GBG1 Fb#1!J2N$J
 C+@I 1B Cl4B1  5@I B%BG
@G  G GCCXb%H GG CGGGADGt CG  P@pB CxbGTGRjZk  0@@PA? Å   $.rHTGQ$J2F  $>\ Ã   .uHBPCbTJGF  >0 ݦ CTGG6J0 ݶjZkD A$H0  @C A5 d.#aH2 D.2 $"@AASqJ5 d>RQJ2 D>5 .!!H2 .2 "@TAWJ5 >VJ2 >5 A/4J2 !/2 #@ZXK[A5 A?Y8K2 !?5 ,;aK2 .2  @GDH5 <P J2 >5 {.2 ;"2 [. ASASqJRQJ5 {>2 [>C0 ݦ*@IHbC
 KA6J0 ݶTG  3LAG CG CGA( G GG0b#4G@GC8bG CTGnAG4G  P"b#?@G] E]}ݤ =] }(0@#k $.
HQ
$J2F $>u .
HT
JF >w0#4Gx^~޴>^G p^GG&v J  G  ~G"b#G[?@ " " ?$G HXbG DUJ @ xUJG .C .0v HWJVJFF >ѐ H >GtGADG  GCGbCGGtGGADGG  C8b. CG CGtGADG  ( G   B1 F0JGb#4GNJ C3 I5 I BtB B)tBG@
G  Gk GGCCb)!I =GG CGGGqA	DGU  CG  	P@AB CbGTG4iZk  0@@	P+A?D GB GD G= GChb CTGADGG3 `	C( bCGGGGtG4GGADG% `C#  G	GdDxb  1 I3 I )Ar2A qB4`H6`HC32B c@GGuu@ B4BCTG TA  G CG ADG  	0 A0`@h@G`b#G4G@GChbG CTGoAG  4G"b#>@Gp] Dx]}ݤ=]#kG0#4Gx^~޴>^GPp^GG&v J  G  ~%!J(#b#( ^, Gg>@ " " ?$G HbG DUJ @ xUJG .C .0v HWJVJFF >ѐ H >GtGADG  GCG(bCGG4GGʷADGG  Chb. CG CGtGADG    G   B1 F0JG b#4GNJ C3 I5 I BtB B)tBG
@
G                                                                                                                                                                                                                                                   \                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ! "              Gy GGCCb)!I =GG CGGG}A	DGc  %vH(1 A CA  G\ G0נH( 2H  B@( be@PB%BEAP@GGTGhZk	GH ?A IR A @(I2  .5  .2   3AJJQ
!Jh@@ F  W!A2 .2AJ5 .2 "8JJV
Jr@@F  rA!A2 X/7J5 x/2 8#0!HYK[
yKw@@[G  T"A2 ,!!H5 -2 0"5J, HH
Ia@@ D  2 U.4J5 u.2 "t@VJS
vJ	 ASF  TS!A?  E/ e/EK[eK[G&   /hWKXKG  ?GG4Gb#
@GCbG CTGmAG  4G"b#=@Gp] Dx]}ݤ=]#kG /
WKX
KG ?`#4Gp^x~Gp{Gh^$v JG    ~H#b#  >Gg=@ 0" " ?$G HbG DUJ @ xUJG .C .0v HWJVJFF >ѐ H >GtGADG,  GCGHbCGG4GGʶADGG  Cb& CG CGtGADG     G 8B1 F0J  }NJ  CGGb CTGAG4G  "b#W=@Gh] Dp]x}#kG0#4Gx^~޴>^~GGp^&v JGG  G  ~h#b#G<@  "P" ?$GC HbG DUJ @ xUJG .0v H .ѐ HWJVJFF > >GtGJADGG  ChbGCGGtGGUADG  GC. bCG CGtGADG  ( XB4GG  1 F`b#1!J2N$J C4 I6 I 1Bu5B B)BG~	@
G  G G2!IC ]CbGG CGGGADG  CT  G2 J3 J 1B SBt4B2TB2AJGRAV B6J0BVB2 "2 /5 6/Z B:AKKY
7KZBG CF8 2 ,2 z#5 :,0BF BHA
;H&H D  C D,  FB2 f"2 .0B5 .X B8KJW
JXBF CD 2 .2 8#5 8,0BZ BJA
9H:AKF C$D  ZB2 z#2 ,0B5 z.SBHS
{J D  C D  0 B(B G4GO ðCG9  P@AB CbGTGxfZk  0`AhAP@?, 0`I2`I kA PBqqA0B0JPA  p. .pJTJtFYaB SpB2 "5 /2 .HyHXKWJGF5 ?2 >  p/ ,pKCH@
H#D4 @
0H[pKa0H DaG <  p? 4G èhAG  CCbG)!I C  =GGGGGAG GGGb#G4G 	@ GGGCbG CTGAG4G  "b#<@Gp] Dx]}ݤ=]}#kG #4Gx^~޴>^~G  p^GG&v J  G  ~G#b#G;@ " " ?$G HX bG DUJ @ xUJG .C .0v HWJVJFF >ѐ H >GtGADG GCGbCGGtGGADGG
 C8 b. CG CGtGADG  ( 4GBG  1 F1!Jb#2N$J C4 I6 I 1Bu5B B)BG9@
G  G GG2!IC ]C bGG CGGGŸADG  CG  GP@A_B CbGTGeZk  !`I0`I kA 0@qqA!1@!!HGAAS _B3aJ3AB3@2 "2 .5 .9AJGJV
J CF CdF `t  Y  [B;aKZ B;@:AK2 .5 ;.:@2  5 , J2 .Q
 JTB F2 "4JHFHsHVJ4@D5 <F2 >2 .2 4#5 4.@B5 .2  J2 {.Q
9J HFJUJvJSfJ  @F5 >vF2 {>2  .2 @#5  /FB5 .2 ":J2 t.Y
:K&H9F0JUJv0JSpJ&@F5 >vF2 t>2 &/2 f#5 F/2  "5 .B;K2 `.Z
[KTJ:GH0JuHSqJFuF5 > B2 `>3B  YB9!KZ B9@:AK2 ,2 y#5 ,:@2 :"5 .H2 z.F
HTJ DHuHSqJ0BFuF5 >3B2 z>  / ,K[HF
H;G95 C
!KXKy!KD <G4G  ? 8D  0@BSABg?8D `0`AhAPAQhA  CGGCx b)!I  =G CGGG޼AG GG`	b#G4G@ GGGCh bG CTGNAG4G  #b#:@Gp] Dx]}ݤ=]}#kP# 1   ~H ^P ^X ~` h p ޴x   > ^ ~ G ,GG$J H   Gs #. #  G !JY!@  lG#."#,4GG0JA
0Hb#!F C
@G   G\GG"b#4GG@G  GG0b#4G[@LGGb#4GG@G  GG0b#4GM@G0b#G4GH@9G@BGHbG_"tGpZk &. &, H@BQ&JHbrHA&H3F &>2D &<@GGtGoZk F" ,q@F     Hp@FuHTJ8 "FWB   #!  &/G #bzJY 8K C:GB C &?TGdZk  , " ("@ H  < #, "E H. 0HqFs1HR QJ "SF H>pF .   JXKyJGW@C     ( q D  c/G  Qp DsJRUJ cKSF  QWB `q EG p ExJ*vHWJFW C    H#q@Gp@G  rsKAPJF  W`B @G C8 bTG c!@D  BG  A( bG CGtGSZk  B PA( bG CGtGRZk  B		A( bG CGtGRZkB P@bG CGtGWoZk , # C Hb#_DG  G C  ]G b#GG#@D Gy  $vH0J ?&D@  c. "5H C tJ =#v`JyIF G ]/`yI }/CZYK[yK@GaG }? ]?0vHGF(bGtGADBGS b@bGCGtGoZk,, GCHXb@
HGD CCGGGADG9 .# #.CGGJHbQ
!JGFG C@GdADGG%  F. C &,tG  =FJA&Hb#AF#@DGG  =!8b
C CGTGͳA  , HD  C- c  CI `GX b CG4GGGAG0b#G4G@GG0b#4G@G0b#G4G@ DGH ]P ]X }` h p ݤx   = ] }  #k 0 HFF  0JGG  Q0 J_FSF Q 0JFF  0`KFF p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# C ^G  ~TG( G@{G ^G  ~  ~b#G@   =  c	   !.Gc. ! GC" !JS rJt2HtFGc>G ] ]  }( 0 #kG# [ G^[G^&~TG G  ~#G "SeZkG#v Hb#Cx ݶG< =CCC$ =0  CGb@DG  Cpb#  G@Gb4G4GTGUBӀ   GGG C =TGb#@Ӏ G @. H  .s HGR@JQ JTF3F @>  >  / " .6Hy6HXKWJGF ? > }  q Dp D  0Q2J  0W@B@ }CGG)b#4G . "U J >5 `M@Ӏ  =  "q Fp F  Qs4HRTJSF  QWB`G Cp)b#G4GM@Ӏ  =q Dp D  Qs4HRTJSFWB  Q`  "qFpF  XK  W C  ]CG C Z.   :,b#R@J Z>A H :<@]G Cb CGTG@DGS GN@h}" bG = C C   CC4GG@D  x?D G>G ]h"`BB| G@B ] GbZkx d H BC b!KG $Dx C  GGGGaaZk   GG CH bCD p =TG1@P0 B 8 b CGGtGkZk C h  = C @h  A. "   H a.0v JAJdSHS
aJ DSF D  C  C D  qF4G  8pFzJY;K C:G  8W`C@CGb#@DG   4G  %G.G!  J   = . q"uSJT JF >  Ţ =H ] v/ V# ,M#M.?FzK@
H J `GB0J  CWBB @_F  ,     HO     ` " " C C 2GJ0CGJ "CGI .I 9# CW J  >TG` BaZk =0CBGb!'H'HC =  . " CW J  >OZk   = ]"G CM .M   b C!@  JG*Aӊ   GG Cpb .%H e.u%Hwb# CTJSeJF >uF e>TGj@G  "b#4G4GGGG
_m À }G .H #,qHPJA#HF >1D #<` GGCGH b Cp }GTGq@p  " C G  !Q@ CGG0 BG8 bGkZk C Gwb# CTG0@G  "b#4G4GGGG_G  )b# C4G'L@Ӏ }   q Dp D  qHPJFW@B  G  Gp)b# C4G2L@Ӏ } q`Dp`D  aH@H DW B  =   = Q"q@Fp@F  TJ  WB:  ݢG 6/ " /Y7KXK 6? ?G] D]}  #k 0?F 0UG Q0 H_FSF Qf Q0 H_FSF Qq G v 80J?G:G 8 0HFF  0H D D  F   C#@ ^H ~P X ` ޴h G  `  ~  ( G0 >G8 ^  C. c.CJS
cJSF c"  ^q`F$ p`F   CUJWB   0 BC =G8 bCC%JGGGG_ZkG[   =4G #"sJ   C.R QJSF C> "D .  . =JVJFyB XB8Kx@! X#( ,! x/:Ka:K@H[zK DaG( <! x?! õ}BG C G( bTGqBDGc   GGCX bGGtGpBDGW  GC TG( bqBDGN   .  . c"0 BCJ8 bWJU
JF4B
JTJvJFF  >C > CCG_Zk                                                                                                                                                                                                                                                   ]                        unvR $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ! "               @ BCH bG4GaZk ,  #,  GCHh bA$HTG D} @"   CyB ,  #,  GGH bA$HTG D@6@ CBG  G G%vH bG CTGc@0 }G0@x bTG   7yB }GC bG `4GpBG8 ] D@ ]H }P X ` ݤh p #k F I  0#4G  ~ ^ !" ^ ~  G A.G a.GGQJS
qJ( {SF C  暁B  G @.  "  .0Hs0HRPJQ0JTF3F @>  >4GG  ( bGB  CG ] ] }  0 #k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G ^  [ ^ G  ~G( {IZk  G ] ] G   #kG Gk#@B ^0WJ  [` @  ~0 B G( {4GVZkG ] G   #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k Gk Gk Gk Gk Gk        	C B  DДD BPB3CFtNdJ5CF  6J7נJXB B6B0B0uB  0B   Gk#4G ^[ ^ ~  GG  ~G{]SZk  #   G!!H0L$H  #G ] ] }  0 #kG#4G ^[  ~ {GESZkG ] G   #kG# C ^4G8 [ ^  ~( G  ~G@ {GG/SZk 4 @   GC G( BC0 bG4GSZk  C #. "  Q 0J #r0H # 2F #> `GD  .vcJ c"U JF  > D #/4BzJ "Y 8K:G #? ` C#D .qaKP JF > @GD .uSJT JF > GD /yJX KG ?  @ GD #,pZHA :H0D #<G ] ]  }( 0 #k      C; `" @.  . "R@J @>Q0J  > D . .UJTJ > >  / D .XK  ?WJ >  k#4G ^G  ~ G  {#3@G ]   #k Gk 4Gk      .    @.!JR
AJ 2F   GkG     . @. JR
@J 2F   Gk      .    @.!JR
AJ 2F   GkG $@B     GkG     `. `# .  ,  .`JT
J;HQ
;J `/tF .1D 0@  "1HTJp1H[qK CF >pG `?aB `  . H  .t HQ JP J5F  >F  > D `. `# .  .     .{JV
JJQ
!JvFF C C3@   . . @"rJUJvrJTJF >F > Gk@     .     . @" .JQ
!J `.TJF2Hu2HSrJFuF > `> GkG@   kG# B   ^ p D  ~( G  ~ ^G	   =0 @ =p D  0 @ =p D?G4G =TGb@BG  GG ]Ggb#tG@1   C  ⦫?$ @.   .!  HR@Js#HQ#JTF @>3F   >   # D `/J @/aJ  [yKZYKqG `?AG @? D .C  .  ,61B @"RKT
JJQ JuJA HtF9F  >5D  < C  Wa@G ] G ]  }( 0 #kG#  ^   B  ~?&( G  ~G ^1"'  G tG   ,G #,GGHA
#H D  C D
  dC@gb#G4G@ӀBGb4G!SZk #, .  "4G HGP
 Jb  Q 0D  @B  ~BG ] ]  }( 0 #kG# ^ ~  ( 0 G  ~G ^GG  G{#_ G_G ] ] }  ( 0 @ #kG ``b#E_? G a@gb#&  D. d."BDJS
dJF@SF C4F  GtG4GGGL@PBGXb4GRZk $, .   HP
 J G0D C%D  ò@ @0@`b#_ C  B( b C C2@tGhZkGb#m_ Gá%@?0@`b#_ C  B . $. $ ( btGJQ
!JF C C2!@hZkGb#T_ G N# ^  ~( G  ~G ^{# _ C  B ` ]( bGGtGhZkG ] G ]  }( 0 #kG#0 {8 TG ^   ~G ^G  0B    [ 0, P.   HR
@J( { 2D  C@  G_Zk@ BGH b4G[RZkG ] ]   #kG#G ^4GGTG  ~ ( {G}BG ]   #k#4G ^G  ~ 0 {G#~BG ]   #k#   ^ B  ~G( `F0 4G8 ޴@ G0   ~G ^G  dG >G ^ [ @Zk C  G G  d@G4G [ @Zk  C   G  F. C  &.&HsHRFJQ&JTF3F F>  &> "D . F# . f"WJVJ > >HD &/vH /b@Y&KXK &? ?4G &,K f/qKHA:H[zK2DqG &< f?fHD .qfH .{HUJTJFF > > "D &,@ &/A&HY&K2D &<1G &? F/4GD /ZFKEGXK F?GG ? }D .tJ .wtJb#VJUJF >F > } `0@ D   GX G# &,   F,HpHA&HBFH1DPD# &<  F<"$  f.O   .fJT
JtF CH .xH .WJVJFF > >  F/ f/FK[
fK[G CH z,eH  Z,CzHBZHpDED z<  Z<G  &. .&JT
J4F C " q. . /qJ .U
JXKuF $BHyHWJGF ? >  , &,HA
&H D  C `   .CH ,zCHPJEHF  >D < GG ] ]  }( 0 8 ݤ@ P #kG#4G  ~ ^ ^ ~  G  0,G# 0.GG0HQ
0Jb#1D C4 B @0@  #,# .4GG#HP
Jb#0D C0@ C  p #,4G . C. H c.P
 JCJ 0D@ @ CS
cJ `SF C [ @ZkG ] ] }  0 #k#4G  ~ ^ ^ ~  G  0,G# 0.GG0HQ
0Jb#1D C4 B @}0@  #,# .4GG#HP
Jb#0D CS0@G ] ] }  0 #k# ^ ~  ( 0 ޴8 @ H >P ^X ~` G  ~"B ^@GGG  G pD2@@B2D  .# .4GGJU
J8b#F C4 B E0@  %, .G"?%%HP
JG0D C+O)!  F.TG f.0FJBS
fJ B8"(bSF  
 CIF @ C]ZkpB U@  JxbGGVDZk BG(bGGtG
F@]ZkGG8b#P@ F- &  ,TG . &.FI0B@
H BJ(bQ
!J @EFB C  @  D  
  R" C]ZkpB U@  JGxbG+DZk BG(bGGtG]Zk
F@GG8b#%@ F- , "FI@
H
@E
 CDA	   &.G F.0JR
PJ2F C @SAF `  . . " %/JV
J  /Y%KF CJzJXK;G %?G  ? G &,   . '" - HP
 J G.HI 0DHsHRQJESF = G>GG@ , e# -4GHZ
IHIzD#1`@{HGHc{HE =D <  %,# .G%HP
Jb#0D C4 B  /@   G &.H .rH @Q&JPJ3FF &> > "D .5H .x5HWJVJFF > >4I f/&I  F/`&I @[fKZFKpG@G f?  F?*HA t.TI T.aTI
 BStJRTJuFAF t> T> "F /VI .yVIXKWJ GF ? >4I T/{4I  .J`JZTKPJHGF T?  >G	  .  e.UJSeJF`F >  e>  / " .JyJXKWJGF ? > &! . T# &. ,	J t/Q
)J@H	F:Ia:I[zK 
D <aG t?GGy@  -# %/GIb#Y
%KE C	4 B  4GS/@  R GBG4G  j [ @Zk CG db#TG4GGtG@  ,# e-4GGHK
eIb#D C
4 B @5/@ G4 G g-H '-jH @KgII'IaE	*E g= '="?$D '.O!   .'HQ'Jr'HPJ3F '>F  > . " .IwIVJUJFF > >GG&@  e/4G# %-GeKI
%IiGb# C
4 B @ /@  G ] ] }  ( 0 ݤ8 @ H =P ]X }` p #k#4G  ~ > ^ ^  ~( 0 8 ޴@ G  0,G# P.GG0HR
PJb#2D C4 B `.@ = ¦pTG  @xB d"b $." D. . .$JR
DJ  JU
J2FF C @qF   CL\ZkB J@  GbGBZkxBbGGGtG>\Zk  ,"?$ ,O! "TGHxB@
Hb1" D  Cp¤ D     C+\ZkB J@  ƠbGGBZkxBGbGGtG\Zk , , " #.G C.H@
H0JT
PJ DtF3`BRPJpJQ0JspJTF C>3F #>D  . .JW
JF C @"   v/ V# ,GzKE
HeG C @   . 6. 6 GJQ
!JF C3   .  . CcJWJ`HTJF >F  >2 G
   c.  C. CHScJtHRCJwF c>TF  C> G X/ 8# ,H{HZYKEH@GD X? < $  $.J .fJQ!JPJ2F $>F > G x/ 8# X/HaH[yKZYKfGAG x? X?G . $" D.J`JVJRQJF@F > D> " .G #,b#JX
4HA4HD0@HWJfH8D #<F >= @  ,# ,4GGHF
Hb#D C 4 B  -@G ] ]  }( 0 8 ݤ@ P #kG p. 0  P.GAJS
aJSF p. 1@ P"2HTJu2HSrJF >uF p>F .0H /s0HJX
KF CB  P. ,RPJ@HTF D P> <k#  ~ ^ ^ ~  ( 0 ޴8 @   0,G 0."ſ$G0HQ
0JG1D C O  , $" $,TG D. d.H¤A
$HBQJbS
qJ   D"SF C  @  F  !  C"[ZkB F@  ƠGbGAZkBbGGGtG[Zk  ,TG ,"HB@
Hb`!  D  C D     C[ZkB F@  bGG`AZkBGbGGtGZZk , , $  . $.H@
HJ D  CQ
!J2HF                                                                                                                                                                                                                                                   ^                        ` $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        R "     "       C@AF@ @ . " . A# .JU
J .WJF  @HxHVJF >F >D D.  @ $.H a/RPJ ,tHQ0JUF D>4F $>D .zKF
H , d"fGHVJwHGHFD > < C# c/G #,zKP
:HA:H D 1 @H[zK`H0D`G #< c? GhG ] ] }  ( 0 ݤ8 @ P #kG#G >tG; ^  ~( 0 H1"8 ޴ C@ G{G ^G[  ~  {ZZk8 B D@  @ bGG@ZkBGbGGtGqZZkBI@   ]GbtGiZZk  , , $  $.G d.H@
H!JBS
aJ  Db3F" C C CTZZk ,   $, " $.G d.H .A
%H .$JS
dJJBV
J  Db3FFB C C CG8ZZk $,G $. , ,$HQ
$JHB@
H  1DbDB C CG$ZZk ,   $,tG"HA
%HB  3BDb CZZk  ,tG# ,"HB@
H  0@bD CGZZk  , ,H@
HD C& G $. $  D. d"B   .!J .R
AJ /KC $/2FJ  V
JbKY
$KGBFG C C CGGYZk , ,H@
HD CG ] ]  }( 0 8 ݤ@ P #kG# G  ~"_& ^OR" ^   0,G 0.G0HQ
0J1D C5  G  . # . a#JU
JF CF  . . !/ A/JW
J8KZ
XKF:G C 3@G ` . !.JQ
;JF C? 8 TG  ( BB0 b  GYZk 	 G  "TG( B0 b  8 "YZk G ] ]   #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k Gk Gk Gk# C@ ^0v JG?F  ~tG8 ^GH G@-{#< ~kK@ D   8 =< =4GG   q.J  Q.tJGSqJRQJuFTF q>  Q>6J< ݢ / . "JXKyJWJG ?F  > G GG@ ]H P #k# C8 ^0v JG?F  ~G@ G`-{#tG7K@G8 ] D@ DP #k# C8 ^0v JG?F  ~G@ G-{#tG#K@G8 ] D@ DP #k# C@ ^0v JG?F  ~GH G-{#tG8 ~K@ D8   G6$H  0 GG@ ]H P #k# C@ ^0v JG?F  ~GH G-{#tG8 ~J@ D8 =   G  G@ ]H P #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k # C^TGG^~G`   ~GG b#GG$aJ@ DL P =B _"  %tG?Db!@! HpBa!@B!Bp)@GG`ZkP C  tGG D @ b#  Ha!@` @  @  Bp	@Gh-@D  EG& P CBTGbFB0 Jq1BpB0BPBp	BG-UZkBh } b E@ CGTGBZk"B CbTGGBZkBD@b CGTGBZkP   CGtG D'b# @  Ha!@` @  @  BO   CGI@P    D @  Ha!@` @  @  BK "q Fp F  rStJWB  rP   4G CFB5JvBuBBBM#M5/Y 8KM5?P ]  %_GZC:@K{{CzZCzC:@N N!.r JQ  J2FN!>P }  ŢFsB3`JtBssB B3aJBV"Y3/uHV/{uHY5KXK:GY3?GV?P tG  %G Db @  Ha!@` @  @  BK@"K .L.O"JTJO@.P  F WJ ChAD  EG P 4GGb#FB0 Jq1BpB0BPBZp"Z.].Z"JU
J CF C `)@D  %P }Gh=" CbD c@#`H` @cc@ @  @K   CGGtGG
AP G  % DD@$Hcc@d@ d@#aH#@V!"Ya.VA.JtJSqJRQJuFTFYa>VA>G  JP ݦf=#   CBGFbB6JwBvBBCBGtG|_ZkP G  tG"D@@ B$HH bcc@d@d@ @ 0@$@GGBZkP   4GD@$Hcc@d@d@ @)   ,  .)  .Q!J,  >PJ)  >P ]  _FRB2@JssBrRBrBB- "qFpF  yJXKGW@C   P }  e G{C;`Kd@{{C@d@/ # 2 #.H/ .sH TGQ!JPJ4FF2 #>/ >P ]  Ţ_FRB2@JuBrRBBB5 "8 2/5 /Y7KXK8 2?5 ?P ]  _GZC:@K{{CzZCzC@= $ @ .= d,HqHPJCaHFqD@ >= d<CP  G  ŢGFB4JuBtBBB3 T"3 .W J3 >GP G  eX GC8 Ky9CxC8CxChbKX# CGC0CGGXAX $vHD  G GG H  P =C  eCGG?Fhb1BX ݶ1 JrRBq1BQBqBK" C(BGGGG5AX 0@!U@ v Ha@@  ? Gt P TG  EGF8bB0 Jq1BpB0BPBKr"K.L.HBJTJFHAA GP h=    CGGDb@$Hcc@d@d@ @K   CGtGG6AP G  % DD@$Hcc@d@ d@#aH#@V!"Ya.VA.JtJSqJRQJuFTFYa>VA>G  0 P ݦf=#   CBGFbB6JwBvBBCBGtGb^ZkP b#D. @DG P =b#?D[ @DG P =TG  B?D` =!@b! HpBa!@B@^!  CSZk DG]]}#k rF r 0JGG  B#0 J ^  ~` @( pB0 G0{@ ^G [G  #G  ~tG{$@0!@G3^Zk  cGCGhbd@ =K h@0a@G CGGGAGD ]D ]  }( 0  D@ #k B0 J` @pB#TG ^  ~( 0 8 Gh{@  ~G ^  #G0 { $@A  "A  .= `"D @.0JR
PJ2F C"  = . C@ .1!J4GJU
J1@ FQ@#tBD %.A .A % HQ!JrHPJ3FD %>FA >  GBA "A .D .JW
JF C     cCGd@) ##) C/, c/A # K#"YK[
yKG[GGY?Cb9!K =A ,GD .HP
JD C Ch@G1A D DGG ] ] G  }( 0 8 @ #k# C ^GGTG ^  ~( 0 G  ~G@b#@ D@   =btGG?D!@  #! HbpBa!@B!BKA" C(@4GqA =  #GG4G?D( b!@! HpBa!@B!BA A"A a.D .rJT
JtF C  GsB G  c D @  Ha!@` @   @ H `@A  "D `.JA @.tJSqJRQJuFD `>TFA @> DG ] ]  }( 0 @ #kG# C^TGG^ ~(0GG  ~Gb#GGO@ D}  Gb#_ D   Gv  }CTG`BDc@  #`Hhba!@cc@#@Bp)@GQZkB } b F@ CGTGZk    CbG D @  Ha!@` @   @ H  BV`"Y.V.SJvsHUJTJFFY>V>4G 4G  DGC8 Ky9CxC8CXCGK# CGA   TG`B D @hb  Ha!@` @  @  Bp	@ CQZk }4G  $GD( b c@#`H` @cc@ @  @K   C!A }  GD c@#`H` @cc@  @ H @V "Y@.V .0Hs0HRPJQ0JTF3FY@>V > GG]] }(0@#k# C( ^TGG0 ^8 ~@ H P ޴X ` G  ~G`b#$!JGG%AJ@ Ds G `o ¤FB0 J  Fq1BpB0BPB5 r"5 .8 ./ ") 2#JU
J=  F C `) R/, r// .2 /YK[
yK= 2,J@ 2.X
K[GF N HQ
 J 1D@@  B@ GGK"CFBHB CG  G(bGGGA  = D!v H D D  G/ q`D  Fp`D( FB0 Jq1BpB0BPB- p"- .. .XKJUJFyJG( W@C$  }- C"  &$vH- .DG {C;`K` @{{C @  @P J)  .)   f@g@  J C 0 @sH CF- >b#D( c.) / cJXKFxF C@D  &G  CGTGXbD@%HpBe@B%BK  CG~AӀBd@ CbGGGtG[Zk   &"GCD } @Hb%H` @e@ @  @K "@ C CGGJADG ( #.) C.- " b#- c.#J/ .RCJF2F/ c  tJ J CGJ@DG G 4G  D@$Hcc@d@ d@#aH@- "- #.. C.0JTPJR
PJtF4`B
pJQ0JspJTF. C>3F- #>   FB5JvBuBBB- #- 5/-  . U/q Dp D8KZXKdgK:G9#    EHDW@    }  fGDB2 Jq1BrRB2BqB) ") .A  , .JW
JF CCD @A 1,D ,9J HD
H%u C $D
@  C  	CG- .. q/-  J[gKF&    @. `.@JS`JSFUF* @ .	 .0 CJWJFF"  @/  ,0 C@KA HAGUG @ , ,0 CHGH    DD 0 C1KC	%B? `  `. @.`JR@J   rFuF `0 CCCqpb#@DG  TG  ƠGDb@$Hcc@d@d@@K K.L#.JQ%JFh@AG ?DG( ]0 ]8 }@ H P ݤX ` p #kG, 0JGG,  0`KDD s`#3v`Jh^p~x޴G  ~GG `^$J%!J&AJ `Gc G  #. Cb#DQ #J  #>G@P @$HB` @b  'd@@C$@p)@TGOZk0 B C8 bGGTGw}Zk  ].C =.fQH   H "G%vH(bpHRPJspHQ0J D D ?$TF@ ]>3F => @ O.O 7HC JGxH0v HF DtG5A D  G GG    ( b C CGGtGGA D  G G } B CbGGtGZZkGG`]h] Fp}xݤ                                                                                                                                                                                                                                                   _                        Fő $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     3      #kF! J B` @a!@# ^ ~  ( G{@  ~ ^G  B)  ) 5,, .A "A /D 5/ HV
JKY
7K 6DG v H CU@qFpF  x9JWJF  W C`    C C@b#DCA : A :.D .!JU
J5F CA@ " .xVJW JF >  #$CA 9"A .D Y/JZ
QKF CQ@ 1  Q.vaJR AJVF Q>  BA #A .D 7/JY
8KF CU@ U# 5. 5,JrJQ:JA:H3F2D 5> 5< C  âBA "A /D 6/ C$HKY
7KG CV@ C@    cd@) # ) ., #.JS
!JQ!JSF0@BAJPJrAJ3F, #>F) >G ] ] }  ( 0 #k 0 JFF à#C( ^TGG0 ^8 ~@ H P ޴X G  ~Gb#G$AJ @D   G  &vH`BGFB0 J  Rq1BpB0B PB1 `/ e"/ .A "2 .Ke# CbJU
J@F }CA /D %/KY
7KG CW@ 7  W.G ,AJ@
H@FG CG:AA .A % D %. C- c"JQ
!J- .F CA@T J A. !  AJu3HF- >DGU 5 /8 %/5 "A e#KY
7K$vHG  A .5 e D %.A #8 .JQ
;J5 e.TJF CP@   P. 0,ScJK%"FJA
&HE  AF#Hu#HFuF8 >5 e> G CA %/ CD . CC8KW
J7G CW@ w# W. 7,G[JA
;HbAF CGɥAD ` =Gb#?D @ }b#D8@DG K.L%,Ke b CJA#HTGFA G DG( ]0 ]8 }@ H P ݤX ` #kG B0 J` @pB# ^  ~( 0 G{@  ~G ^  #$@A  A .) a"D A.) . J, .R
@JJ FU
J  CF@ B CC  .)     G  JG_  6aJBA "A .D 4,JA
5HF C6@ " . " J	@  .05 BwJT JF >0@B  aBB) 5 ) ., .JT
JF CAB?  â0 B  BtG( bB= "= .@ .A  ) v"JT
JF CB  A 6,D V.) ., . HR
@JJW
J 2D  CF@ B1qBq!B1!J C C@XZk   C!!H @)  ")  ., @.0JT
PJRPJtF31`BpJQ0JspJTF3F, @>)  > C  cGGd@) ") ., .A ##K# JW
J CF C UB5J A C/h@D c/YK[
yK[GG CGbGAG ] ]  }( 0 @ #k B0 J` @pB# ^  ~( 0 8 G {@  ~ ^G  #$@A  A .D a. JS
`J F  C@ B `"  ,  "GT J > 0H  B)  ) p., .G`JT
J tF  CC%  G  7aJBA  A .D .JV
J F  C @ " . " J	4@  .45BxJU JF >0 B  âaBB)  ) ., .JU
J F  C B  G GB) #) ., .JU
JF CC% G  #7H$@A "A a.D .pJU
JuF C7@ " / a" K
TB   .4BwJU JF >0B   @C) ") 8,, x.0HS
pJ3D CB?  GGXbBA "A .D .JP
JF CP0B p" /`SJX KC G ?  #$@) ") ., .A !"KA"JU
JFTB4J A ,D .HP
J(@ D  C CGGGIA  cGG( bTGd@K# K.L#.JQ!JFh@mAG ] D ]  }( 0 8 @ #kG # C^TGG^~޴>^~޵G  ~G&!J0b#GGG'AJ(JG	@D
G 	G
G 
G
G %8 (v Ik! = CCb#?F CG@D  G CGGb#@  
 C -  
. -.JQ
!JF C4 @ @$D  E `* .+ .* "JVJFF D 
/G -/D "CbKY
7KGBG GGtGxWZk0 BCPA8 bGGGtG	WZkB  GC( bGCTGA4G G =  
"_  0.  @  a. 0J aJ3F)   " !   .  . J JF!  " !   0/  a/5H 0K aKyB;G   " !   0.  . 0J J4F   !  "  . 0 @  a/ @ J aKF  !  "_   p.  . pJ J
B} K .K -"rHL m#W JHFK >
EO -/xHL .5vHY;KVJ GFO -?L >D M#
EG .JD m.aJTJSzJGFG >aFD m> =jQH ݥ1vH &)>IE	IEBA.IrRB  
nANB	1E @	7A =9=IO /O  C0v I  KG{ HD;G =btG_{A ݥ# /C& =/GE  
	A.I# "zJXKi)AnAJY7KGPB	.AA 	@CH@;G& =?GXbp	@# ?GGG0UZkG
C@!h bG CGG4GGKAP B
ЧAX b>=!G CGtGVZk CGGb#1@	4G
G.v I
_E
E 
GG] _E]}ݤ=]}ݥ #k[FB0 J  q1BpB0B# @  ~)  " ^G G)  ,, .1HT
J4D CC#  C0B  A .D  /A "GJX
KF CWB 7# / KG
   7/  3. # 8K3J- `	8B   W/ " WKF 0BB?B_G ] $     #k `  .qKWJF  >  RGPBA "A ,D 0,HA
6H D  CTB  , T/HZTK D ]   #k S/ZSKQG .
KW
JF >À; B0 J#  !` @pB ^ @G  @  ~@ K "{ 0@CG ~G CGGGGkAG ] D   #kG;F B0 J  !#` @pB @ ^  @G3v J  ~@ K  ( { CSgBC C G G CGGGAG ] D   #kGp#CP^4JGTGX^`~hpx޴G  ~G$!Jb#G( %AJGG@DG   &vHC CF0b#@ D  G  eQH =$vH ?$b8K?GDD@9C9 KzZC  y9CYCG@ =B3=HOP.O"CtG PJ0v Ht@J_FtF }GzAD  %Gr  =0" . C . "?D B!@b! HpBa!@BuJWJxJVJ!Bp)@F >F >G CTG8JZk ,   , Cb#H@
HD CX @0  C CGHb#j @DGGB C8 bGG4G4GGA   CGG$vHb# CX_DG G- G+ ( ݤ}="  CD  ¢# gH@  CbDB ` =bGG?D!@! HpBa!@B@^! G CGSZkB,E},B GCH`mb#C
dHGD CTG@GP] DX]`}hpxݤ#k dC#GG0 0v J ^G@ [ C  ~G GH {GuSZkG ] G   #kG#TG( ^G  ^C0 ^8 ~@ H G  ~Ghb#G G@Di   #v`H  xF2 JBq1BrRB2BC qB C CGb#@DW   }  A " }Dc@#`HzZCcc@CCC/ # / .2 #.3v`JCJQ
!JGF =A .K"D . CGh@JV
JF CStB   s# , 3/HY
;K0 bA D D CG+AA $,D .A " } D"H  =P
J#v`H0D- . CAa@- q" A. ! T J AJGu3H DF- >A // q#D $/ ݦK?F/ Q,Y
7K6vJG CDBB [H ,   H GpHPD/ Q<G( ]0 ] D8 }@ H P #kG#TG( ^G  ^C0 ^8 ~@ H G  ~G b#GG{@D   #v`HC CFb#@D   = =  $?G  ]: JBcc@- .zZCz@#@A a"A .1v JD .- "GJU
J JF CA!B a/ !  aKb#AF  _Df     D }FB/ .0 Jq1BpB0BPBA "A .3v`JD ./ c  JJV
JF CPpB # 0/zxHY 8K:G 0? }  $ G {C;`K` @{{C @  }  @/  "/ @.A "2 .5vJK@#QJT
JCTF1 B1!J =A `.`CD `,@bGwJC
wHcF CCB " / #/KY
0K CGG`@GNA D   G  }b#   =Dc@0`Ha!@pB0@@A A"A a.1v JD . CrJT
JtF CA!B C C_G( ]0 ] D8 }@ H P #kG# C ^TGG ^  ~( 0 G  ~G#!J@b#G$AJ@ Di   =bD?DB2 J  sq1BrRB2BqB) ") ., .JV
JF C  CB $JCN  :JG;u@C
zC @	CGA Q.D q.A 1 #v`HAJS
aJSF C1 @U?C5J5@  . /JXKFF> 0 C@?C H  @  @. `.@JS`JSFCF3 @0 CZ?C:AK:@  . /JXKFF( 0 CW?C7J7@  7. w.7JSwJ3F#F  0 C2!K4C	[B_
 X?C8K8@  . ,J@HFF
 0 C4C G_G ] ]  }( 0 @ #k1v KDb#_GF B? b @  .u2H ۦ0 J` @TJpBF  > @  ֢1!JG B)   ) ., .JU
JF CC@  A .D .A "6!HJW
J0uB F
B  C 	CG1v J&   . .JTJFF-  .	 .0`CJTJFF%  . .0`CJTJFF  . .0`CJTJ    FF 0`C7aKaC	B   .  .JP J   FF 0`CaC GkG
 @  .prK GTJF  >k .
2HT
JF > .
rKT
JF ># C ^TGG ^  ~( G  ~Gb#GG@ D   = "G?D!@! H  QpBa!@BAB= a"= .@ .JU
JF CC8   B7Jw@ G  7/0B B5JY7Ku@:G  7? }  G {C;`K` @{{C @  B= @"= `.@ .rJT
J tF  CB  u   .G0BWJF  > =  q?G9C9 KzZCy9CYCyC= "= Y.@ y.PJS
pJSF CB   1GGF B4J` @tB @  @) ") .,  /JX
K F  CC;  G ]!aK  1_FRB2@JssBrRBrB2CA "A .D .JT
JF CB " . J]B    , a.B5UB5JHSaJu@ D-   U.tHRUJTF  U> ݦ0@C  aCFB6JpBvBBB) #) 0,, p.8HS
xJ3D CAC? GG ] ]  }( 0 #k 7/GY
7K:G 7?o .GW
JF                                                                                                                                                                                                                                                   `                        8h $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ~ "     D       > U.
HR
UJTF U># C  ^TGG( ^0 G  ~G >Gb# ^ ~@ D@"5   =   Q?D!@! H  .pBa!@BABU J3 a.3 !  aJv4HF  >   1 F ݢB7JxCwBC7C) W#) w/, ,zK@
H `G   G ]  1_FRB2@JssBrRBrB2B= 1 = .@ .JU
JF  6G  ]( ]0 @ #k# C ^TGG ^  ~( G  ~Gb##!JG@ D   =`"b#?D!@! H  1pBa!@B!B3 A"3 a.trHS rJtF3 a> Fm_ DG ] ]  }( 0 #kG# C ^TGG  ^( ~0 8 G  ~GGb#G$AJ@ D=   =#v`HC?D C Cb#1_D2   =B ?G9C9 K  :cc@y9Cy@#@A !"A A.D a.0v JQJS
qJSF CAB " .vHU JF >   Z F JB` @{{C `C @CA  #A `,8v KD  . Cb#yHQ
9J qD  C@ C C C7_ DG ]  ]( }0 8 @ #k# C  ^TGG( ^0 ~8 G  ~G`b#G ^G8@ D'   =#v`HC C?D Cb#_ Db    ]  CG }C8 Ky9C  .xC8CX@A " A .:v@KD ".T JJQ
!JF CAAC A. !  AJu3HF  >G  ]( ]0 }8 @ #k`# Cp^TGGx^~G  ~Gb#G( $AJGG@ D =Z   dQHG!>HbFDB 0 Jq1BpB  d#v`H0B#D _&pB2@ =6=HO.O"CG J0v HwJFF ݶtG8uA D  6   }BCbTGDc@#`Ha!@cc@#@@p)@GhEZk%vH0 }  C Cpb#_& =. C# =,#  `HGQ J( br`HA H3F& =>C2D C# =<0" &G G CGGہAD ( }8    G DGp]x]}#k# CH^TGGP^X~`hpG  ~G  Gb#$AJGG Cy@ DV   = dQH#v`HG!>H8 bFDB`0 Jq1BpB  d0B#D _&pB2@ =O.O"6=HC J0v HwJFF ݶGtGtA D2   }  C  BTGD( bc@#`Ha!@cc@#@@p)@G%vHDZk( }  C Cb#_ }. . C = aHSaJtaHPJuF(  }>F >G   C Chb#_D f C CGb#
 @ GGH]P]X}`hp#k  # ^ ~  ( G  ~ ^GG   1, 1" G1H     GGG8 b4GtGؔA  BG( bGGGtGOZk DG ] ] }  ( 0 #kG Q. GRQJAF?        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k# C  ~G ^G  G ^{#@G   ]4Gw#_GZC  :@Ka!@zZC:@BGZ!"ZA.]a.QJS
qJSF C@G ] G ]  0 #kG# C  ~G ^G  G ^{#@G   ]4GHw#_GZC  :@Ka!@zZC:@BGZ!"ZA.]a.QJS
qJSF C@G ] G ]  0 #kG#4G^^ ~޴ (0>8^@~HGG&v J  ~G` {#GGG'!J CG\@   G3GGGb'vH CA "4GG 
b#  	*@G CH}b# CGG4GGGn@DG
G  {b# C CGGGGj@D4G
G CGGHb#@D
G BM@C  EGbGtGeMZk8 B
I@@ b CGTGqZk8 B
C@ b CGTGqZkG C  %Gxb# C4GGG@DB
G  Cb
G C4G"DZkBGbGGtGNZkG  % Cwb# C  4G GGGm@G  b# }! C CGtG@DG  xb#
G CTGQ0_Ӕ   ?$GCG b# H C @ GtG;8@ }. ]. C =  ]aIGSaJ btaIRAJuF }> CTF ]>0v@Iѐ@IGtGsADG
Gn CbGG4GtGsAX XB  %D@'H  jhAg@AgA'H G.  '.s'HRGJQ'JTF G>3F  '>X   FB5JvBuBBB # 5/Y 8K 5?4GX ]  
_GZC:@K{{CzZCzCAG+b# ATGLO@DG
G2 `  %Gb#G4GG_D
G( `Hb CGTG  %4Gxb#GGG@D
G Gb!  % Cxb# CTG4GGG@D
G `  CGTG  %4Gxb#GGG@
GGG b
_E8 EA @X E `G
    %8b# CTG_G C  %G}b#4GG@G4G  		b#E@ GG]] }ݤ (0=8]@}HP#kG G    `'{#  `. .`JT
JtF CpF+ `.."0 @JV
J`"F CF  .0 @."JV
JF CpF `.0 @.JV
JF CF
 8`.;.0 @`JU
J  uF CpF `@0 @4U?@   q.r1H GS qJrF  q>kG Gk#TG ^  ^( ~0 8 @ ޴H P X >` GG$v J  ~GX {G C=@ u @G   G ( ¤4GGHb#  @GG8 bAGb#_  G CGGpb#_D GGb#_ӯ G C`b#GTG _ G4GG	GD+b#@  'Ha!@g@'@B !" A. a.QJS
qJSF CGP@ C  (TGGD @+b#'H` @g@ @  @  "  . @.0JR
PJ2F CGP@%  G 4GxbcB 4G  (GD+b# @'H` @g@ @  @  "  . @.0JR
PJ2F CP@ D  Gb# C C@tG._	0 A 4G  (GD+b# @'H` @g@ @  @  "  . @.0JR
PJ2F CQ@G C@~b#GG4GG@G  DDGb#}_ =  h G	?E)A) Id@i)A @$Hd@ #  #. .HrHQ!JPJ3FF #> >   ȢFB4JuBtBBB 4/  /Y4K 4?XK  ? ]  _GZC:@K{{CzZCzCA (! ,D H <GGDH bgDIAG  4G
b# @ DG ]  ]( }0 8 @ ݤH P X =` p #k# C8 ^0v J@ ~H P X ޴` h G  ~G0 ^GGGGGGG{#@D  X=D tGF Gb#_   G GGCCb#GGGGGt_(  C  %,Gb#pHA %H0D  %<G_DGu    &.GC  E8 Ky9CxC8CXCQ &J 8, # 8Hr&H2F  &> &J  Ţ`   FB4JuBtBBB " 4/   T/ t/7KZ
WK `K+b#:GG@@ @ C4GoO@D CG  GB G C  ETGGFB+b#0 Jq1BpB0BPB p" .G .JU
JF CO@*   =  A. a.AJS
aJSF  ' @  &/ . . "Y &KJWJFzJ:G  &?4G }0@  %GG {C;`K` @{{C @  B+b# @" `.  ,rJA
2HaF C`O@ӿGb#~_ DG0 ]8 ]@ }H P X ݤ` h p #k# C ^0v J  ~G( 0 G  ~G ^$AJG4G@{#@D  X=D tGF Gb#._   G
 GGDb# CGTG_GGb#I_ DG ] ]  }( 0 @ #kP# Cp ^x ~   ޴  G%v J  ~&!Jh ^GGGG CGGp{#@D  X=D tGFY G@b#_   GS GGCC@b#GGCGG_` TG  @ P GX =0D  :  D. $" d.CG CQJ }b#S
qJGSF C4 B GG	@DG&   D. $" d. CGQJGS
qJbGSFG CGT@ D  TG / ./ $ GDb# C JP J$Fq!JGF/ > CGG_GGb#_ DGh ]p ]x }   ݤ   #kG#1!J  ^C( ~0 8 @ ޴H G$v J >  ~GG ^%aJG CGG{#e@DG  G`b#w_   G  ݤ%vH C CD CGb# @GG(b#_ DG ]  ]( }0 8 @ ݤH P #k#_F ^1v J ^ C  ~G( 0 GG$v`J  ~Gb#G Cq_ D  GCb# CGGtG_ D   =G C@b#tG$D  $D =?D CGF_ D   GG ] ]  }( 0 @ #kG#1!J  ^C( ~0 8 @ G >$v J  ~G ^G%aJG CtGG{#@D  X=D GF Gb#_   G  =%vHG Cb# C?D CGGG_GGb#_ DG ]  ]( }0 8 @ P #k# C  ~0v J ^  ^( ~0 G ^G ~GGG{#@D  X=D tGF Gb#_   G G =G ]b#
 @ Gb#_ } DG ]  ]( }0 @ #k# C( ^C0 ^G8 ~G@ GGGC$ ^  ~G  >Gb#GG<_ D     =    0.r0HG0b#TGQ0J2F  0>G$ =f_ DG( ]0 ]8 }@ P #k 0.
0HQ
0J2F 0># C  ^0v J( ~0 8 G  ~G ~$AJ ^GGG`{#Z@D  X=D tGF G0b#i_   G  =$vHGGxb# CGtG_GGb#_ DG ]  ]( }0 8 @ #kP# C^G~޴G$v J  ~GP ^x^G CG{#$@ D Gb#7_   G
P =CGG@~b# !. A. "G0JR
PJ C2F C4 B `GG]@DG   E. %" e. C0 GQJGS
qJH bGSFG CG@ D  TG ( ._") %.
 "D "JQ%JtGF  	PB  H } `
 .
 .JV
JF4vJF
 D /G %/KY
7KG7vJ                                                                                                                                                                                                                                                   a                        ,X  $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        8 "     U      F  G( %.G) E/tGb#%JZEK:FCGG_D =G  b "   = ]
 %#  b .p Je /2v@J  ( .J) .X
K % JUJFFF @
 e/
 E/J`J[yKZYKdG@G
 e?
 E?j "h ݤ "D .0H@qHP J- % F >Gj .Cm ].GD ,JR
UJ /FWJB@HbdWJXK D <G ? =G- ,ٰ KF Ht!KtGD- <Ч@IZkB вCbGGGtGIZkB@b CGGGtG
IZk ݠD  G .K "D %,L #HP JqHA HFG >1DD %< }-  DK .p`JvtJU J/ "FK > GDO E/JL %/{JZXKY8K@G;GO E?L %? =- . HP Jq&HF- > ]GJDF @/ . JU JFvJF/ >	 / // " KX K;Gy7KG/ ?D( %.G) E/P ]tG%Jb#ZEK:FGZ_G G GGHb#R_ DGx]]}ݤ#kG# C8^0v J@~HPX޴`G  ~G$AJ0^%aJG4GG{#@ D%  Gb#_   G G$vHCb# CGGtG_DG  8 !vHGGD b# H C D   CGtG_GGxb#_ DG0]8]@}HPXݤ`p#kG# CH ^GP ~GX ` h G$v J  ~G@ ^G C {#@ DS  Gb#_   GM GCCb#GGCGGL_ D  G;  =P D  TG6 CGGb#Z_DG 4G, GGC8rb# CGTG+@8 C  =G D Cb# @  8 = C  ]b#?D C! @8 D@   %Hd@e@ @$HG @     . JP J4 Bq!JF  >Gb#_ DG@ ]H ]P }X ` h p #k#0J ^TGG ^  ~( 0 G  ~G $!J8 {G4GG1^B   G7    q Dp D  0rHQ3J2F  0W`B6 @ " qFpF  xHFWJF  W C0    .`H   ,q`HbBP J.b#A HF1D  >4J   <  szZCtBTCtBG   . . CTGJV
JF CH@DzD DG ] ]  }( 0 @ #kG 00H?F2F 0 0HFF # C ^G  ~( G  ~F ^G C@{#& @ D0  c@#`HGa!@  cc@h.b##@B !" A. a.4GQJS
qJSF CK@ =GG( b4GG]B TGG ] D ]  }( 0 #kF#4G ^ ~  ( 0 ޴8 GG1 J  ~G ^  EBq1BGpBBFB " 2.G ,0b#0J@
H F CJ@ D'  G  %TGGH0b#&@ " !. A.0JR
PJ2F CGJ@    $  e4GG  !. A.fB "0b#!JR
AJ2F C#D   . .JV
JF CJ@ TG_G ] ] }  ( 0 ݤ8 @ #k Gð#0J( ^0 ~8 @ G  ~G   ^GG0{#i_   G1 CGGb#_DG%  CGGrb#TG8v K C@  =b#D CK_DG   BFB0 J  Rq1BpB 0B0JPB p" . JT J55BuJF >Gb#`_ DG  ]( ]0 }8 @ P #kGP#1!Jx ^C ~   ޴ G$v Jh >  ~GG` %aJp ^G CGG {#@DGGG    b#C4G@G  b# C C CGGGG @ GGC8sb# CGTG@DG+  Gb#_   G& GCCb#CGGGGG}_H =Dh =CG D` FPb#G  %vHX }?F C C CGG_G ÆTFGb#_ DGp ]x ] }   ݤ  #k#2AJ  ^C( ~0 8 @ ޴H G$v J  ~G ^%aJ ^G CGG {#@DG  Gb#_   G G ݤDG Cb# C&vHG C4GGR_GGb#_ DG ]  ]( }0 8 @ ݤH P #kG# C@^GH~PX`޴hG$v J  ~G8^%AJG CGp{#V@ DQ  G@b#i_   GK G%vHCb# CGGtG_DG;  \ G  7 0v JGsb#CF   CTG@DG+  . =.. "1 ].tG }0JR
PJ2F C4 B pF   @ C` ݦGG CJb#6JF G` ݶtG\ d U_
 ` = CG C@b#Gp HGG_GGb#F_ DG8]@]H}PX`ݤhp#kG#2AJ  ^G( ~0 8 G  ~GG ^ ^p{#_   G  =CGGb#G!v HtG Cb_GG8b#_ DG ]  ]( }0 8 @ #kG Gk# C0 ^0v J8 ~G@ H G  ~G  ^G$ ( ^G{# @ D&  Gb#_   G  CGGPb#{_DG  C  =Gpb#G C_D$ ]G   tGBbBGG<EZkGhb#_ DG( ]0 ]8 }@ H P #k# C8 ^G@ ~H P X G  ~$v J( ^G0 ^G CG{#w @ D.  Gb#_   G( CGGb#8_DGG CHtb# CGTG@   C =Gb#D C_D( G	  =G  BG( btG!@GDZkGb#_ DG0 ]8 ]@ }H P X ` #k#1!J( ^C0 ~8 @ H ޴P G$v J >  ~GG %aJ  ^G CGG{#& @DG  G`b#8_   G G ݤ%vHG C  CDb# CGG_GG(b#N_ DG  ]( ]0 }8 @ H ݤP ` #kG#  ~ ^  ^( ~0 8 @ ޴H G  ,%v JGG@ H  <G&AJ GpdJ@ H D  <J GGC Cxsb#G CGtGg@DD  D  GF@  } C( bGGG@ D    $. $JQ $J@FrDJ2F  $> GJ@  } C( bGGG@ D    $. $JQ $J4@FrDJ2F  $>PDG L@  C }G( bGG@ D    d, dHC dHT@DbDHbD  d<tGD  $, $H D GG ] D  ]( }0 8 @ ݤH P #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#?& ^	 1"~ ޴(G( {G =C  ~{# ^# G } = n@	   "G4G0b#>@G%_ Gy 0 BCC8 bG  GGGGGGzZkG    =1v H   TGG0b#B~%_ G_  =4G  G!&Hb#  &Ha@, p"  A.R AJ  A>, ./ .JU
JF C
@  e #, .  G HP
 J 0D  C4  GCvb#GGtG@!  p "CGCG8 =Gub#C  ޶G G4GG@  >  8 = CCb#? @G  GTb# C CtGtGG@  Š0`@ &, .   HP
 J 0D  C	`@  4GG`b#, E., %"/ e.QJS
qJSF C
@ GG ] ]} ݤ(0#kG#4G ^G  ~ G   @	{#M
@G ] G   #kG#4G ^(~08@޴HPXGۤ^GGG  ~G  Gb#P
@G Cb#GGTGU_ 4GG D @    Hp*b#a!@` @  @  BH `.  @.tHS`JR@JuF `>TF  @> ݦ  FB6JwBvBBCBD@DGi  GGb#GGGGZ_ D     EA( Ia!@hA(@B !. !  !J$D$  0 BGGTG@b#GGKBG$_G(  @b# CGTG$_? GGb#GG4GG0_D0 "G3 GG@b#GTG$_GCCPb#GGGtG}_DG! ` G%vHC      %.CGGb#tG%J_ GGG`b#G D    e.GGeJ_ 0`@   v H`@E   =  ?D!@! HpBa!@B@ a.  A.SaJ a>RAJ  A>G4G  pb#@G] G ](}08@ݤHPX`#k#4G ^ ~  ( 0 GG ^ CGG  ~ Cb#D@  \  _ .TG\ #,HP JGqH8 bA H $F_ > 1D\ #<4GGXB     G0G  %G@ BGH btGGdBZk $G  _  %G$@ A.  !.RAJQ!J A>  !>  edB " .U J >  ŢB # V/J 6/{JGZXKY8KAG;G V? 6?  BA 0"D p.JA P.tJGSqJRQJuFTFD p>A P>  %$@Z"]!/Z/Y6K]!?XKZ?  E"DCE   edC"[.;.RPJQ0J[>;>  edB".U J>  %6@ # A/J !/pJGZXKY8KQG0G A? !?$"  EVBA r#D .A r.JuJTJS{JFuFD >A r>G  B0//Y0K0?XK?  EDC  ŢB6 v.V.SaJv>RAJV>  B t/[ tK t?  B # P/J 0/aJGZXKY8KRG!G P? 0?  eqBA "D .JA .{JGUJTJFFD >A >  BvP"y0/v/Y2Ky0?XKv?  ED"DCa  edB3 .3.TJQ!J>3>  B"u/[ vKu?  B # P/J 0/aJGZXKY8KQG!G P? 0?  erBA "D .JA .{JGVJUJFFD >A >  B0"0//Y1K0?XK?  E8$"DC  edB;.8S.TJ;>RSJ8S>  B<"<u/[ vK<u?  B # P/ 0/JaJZXKY8KRG!G P? 0?G  eqBA "D .A .J{JVJUJFFD >A >< #   BP"0//Y2KXK0??  EDC 	@}  ? . G< #.HTJuHQ!JF5F? >< #>G ] ] }  ( 0 @ #kGGG{# @ DDGkG C [\  \ 0,_ 0. HQ
 J 1D  < 0 < 0.? p. !JS
aJ3F    G                                                                                                                                                                                                                                                   b                        c? $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        G "     f      k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k`# CP^GGX^`~hpx޴G  ~GG( {GGGGGGGGtG4G
A D   G^ GB= b C CGtG@ZkG C8 bGGGTGGhA@ B CH b CTG`uZk+ %,G( ,IpIA%H@H1D D+ %<( < D' .$ E"$ e.HTJuHSrJF' >uF$ e>/ %/, "D, /HY7KzHXK;G/ %?G, ?  %,G# - CGGA%HHbHI# =  %<C GGGGʌA DGG'vHGDDDGGpb#DZ @DGP]X]`}hpxݤ#kG# CX^GGtG`^Gh~pG  ~G ^ >G8 {GGA D  G  ]"  B C( btGGG@Zk C =GGb#	 @GGX]`] ?Dh}p#k# G C  rG ^GG  ~ GX{GGA =DG ]   #!v H&DF?D Dk#F ^  ~( G  ~GG > ^ C `{# @ D
  P"G CRb#tG*@GGG@G =G( bTGÄAG ] D ]  }( 0 #kG# C ^ CGG  ~G G{G >G)AG ] D   #kG#,    ~, # ^ ^  ~( 0 8 ޴@ H P G, 2,G/ .GG HU
JG 5D , 2/G/ R/G  8KZ
XK( .+ 2.:G NJQ
2JF B_GCbGGGGGAD   , E./ e., %"  CQJS
qJ0v JSF CF    . .@ DJW
JF C4B   ( E/+ e/ OEK[
eK[G 1C  G D  GG ] ]  }( 0 8 ݤ@ H P ` #k#$    ~ > ~  ^( ^0 ~8 @ H ޴P X G$ 2,G' .GG HU
JG 5D  C 4 @G    .# /, 2#, R// r/J( .X
K+ 2.YK[
yKF C[G   NJQ
2JF B& C =GGGb#M @D
  GG Sb# CBGtGGG@" G, $,,  / .4G = HP
 J( .+ . 0D   N  %JU
JF `B, .C/ /, "GGJ =X
K HbGF ݶGXAG D  D   d,# D,dHP
DHBDH0D0 @$HCdHa$HPDaD# D<  d<G  ]( ]0 }8 @ H ݤP X ` #k#G  ^( G  ~G ^$ R.$  ' ",G@J0 {A
 H AF  $ " $ B.,  ' ., b./ .AJT
J`JU
JTF uF( .  L+ b.CJS
bJGF > @B CGG/A = $ ""!v HJ!D?DtJ D  ' b.$ B.SqJRQJuFTF' b>$ B>G ]  ]( 0 #kG#TG  ^( ~0 8 @ ޴H   ~G G >, " ^G, 2.G/ R.G0J( {R
PJ2F 0v J C4GTBG   GK  C" a.  A.JtJSaJREJuFTF a>  A>$ "$ . !#' /, #"?D a/JX
K A/FJ[yK`JZYKpG a?@G A?, C.C/ c.G( .QJS
qJ+ .JGSF  L8 bW
JGF B =GAGGH bG4GDTB  G
 G' #,$  $ C,HpHA%HBEH1DPD' #<$ C< GG ]  ]( }0 8 @ ݤH P #k#@ G  ~ >4G ^  ^( ~0 8 G  .G# .G  [GJ( {V
JF CB 6zZk G& , 2., "/ r.C( .G0J+ .S
pJGJb3F = C NW
J0JF G TBGGKAD
   . #.TGGJQ#J8 bF =qA GG ]  ]( }0 8 @ #k#  ~ G ^{#9_G ]   #kp B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# dC ^eC@ [G ^tG  G  ~G >GH {}Zk =  C     G  G G "  Ԧ  " CF  F Pܴ  Զ G ] ]  0 #kG#4G ^  [  ~ ( {GdZkG ] G   #kG  0, G 0H$D `G0 B  . " JF   q. qJ `  .P BT J  >  0, 0H$D   X%D%D ` . " JXF   q.4GvJ qJ `  q.P BS qJvF  q>  . J 0 BX!D  0 BÀD0 Bk#G ^G ^  ~( 0 8 ޴@ H P G  ~GGb#G@  $,  ¤A $H  $<P B CX b ?"GtG}ZkL  & C Cpb#!/H&_  C CGGGi@Gb#@H C C  !. A. JR
AJ2F  G  .G .TGpBJU
JxbF C+qZk(  @  . '.JQ
'JF?@B C C  . .JV
JF  /G (/pBKxbY
(KG CTGqZk$  A  . (.JQ
(JF?   G0 G0 BE@ G8 bTG#aZk    ,F H  <GBTG = g b`qZk , ,HE
H D 0 BE@ TG8 baZk    ,E H  <BG =TGb  IqZk h, ,gHE
H eD  CG ] ]  }( 0 8 ݤ@ H P ` #kG#TG  ~ >^C^G ~ C(G08 G[G {G D qZk CGXb#@Ӱ C C  !. A. JR
AJ2F    .C .GBTGJbU
JF CGpZk  a@  . #.JQ
#JF?  c. C" .4GrJT
JtF C-  C C  / 6/KY
6KG    e/C ,TGBeK@
H `G  CbGnpZk  @ G  . %.JQ
%JF?  G e. E" .4GrJT
JtF C  G G  G  uG]] }(08@#k# C ^(G  ~G >^G{#x_ D   G GC 4Gb#tG@ D   G	 G =CBTGbGpZk GG] ](0#k   kG#F ^ X D ~  ( 0 G  ~ ^GGG  *  b C C  . .JW
JFI G %/ # E/( b8KZ
XK:G  B CG
    %. E.TG%JR
EJ2F CGoZk	  @  . %.JQ
%JF?+ G 4G* 8 DB%   C C  . .JV
JF `G / " %/G  BKY
7KG CF
   e/ .TGeKP
JpG( b CoZk  @  . %.JQ
%JF? G_G ] ] }  ( 0 @ #kG 4G#( F ^ G  ~G ^ C7    C  . .JU
JF    . "  /JX
KF CF  @ `"  @/ `/@K[
`K[G @ . .JU
JF CqF	 ` @  .  /JX
 KF? G<    /G `/pB K[
`K;Gxb CTGoZk G/ G8 F  ")   C C  . .JV
JF! `G / " !/KY
7KG CF !@ "  a/ ,aK@
H `G   . .JU
JF CF  !@  a. /aJX
KxF G_G ] ]   #k  .G A/TGxbJZ
AKFpB CoZk GG#  ~ ^ ^ ~    ,GGG H    . #   B4G( bPJJ9B  ]B  cZk  .qHP JF  >0`@D  C. CJ_G ] ] }  0 #kG#4G ^[ ^  ~( G  ~G  C{oZk  B0 @( b4GdZkG  B =GbTGSoZkG ] G ]  }( 0 #kG# ^ ~  ( 0 ޴8 @ H >P G    ~G ^G   .GG JF
  0@  E. EJDF @0@  . JF?F	 @  B ( bGGTG oZkG' 0 B1'J8 bG'JTG
]ZkG    B ( bGGTGoZkGG G  , (   BG( bTGIHQ H'I  (> GnZk  ,a(I0 A@ H D  <G@ B4GH b $!  㰣@oZk @ 1 @@3 	@& `%   @, @HDD, @   .P  J   >"  @   .  J$F#    `.S `J  `>  @  . JF   .V J  >  @  . JF    /Y  K   ?  @ A_@ `  , HD   ,G H  <   @@_ D    $,A $H  $< GG ] ] }  ( 0 ݤ8 @ H =P ` #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k0 # ^     ~( 0 8 G  ~ ^GG.  `[4G   2
r"q@Fp@F  բVJWB  ղ #q Gp G  YZ[KW`C  Y{ `
"q Fp F  @HW B  w  "qFpF  WJW C  s  2#q G p G  z[`KW @  zo  R"SB?GCG0b#GTG_ D   GH G`"G2
"G  E.EJ]  @. J\ 0@ / KZ 0@  e/ eKX 0@ `e. eJV 0@ ` @0@? P@G4GO   %/xJBb CY%K8G  %?TGmZk %.% .HQ!JrHPJ3FF%>>XD Gb#: @ G  GG ] ]  }( 0 8 @ #k բF ղ} Y_G Y  D  F  zG z e.SeJrF .VJF %/Y%K8G ,@HD E.REJSF %/
JY
%K8G %?# ^ ~  ( 0 ޴8 G  ~ ^GGG2
 G  ,H-  8 D  0 BP@8 bG CTG"mZk   @0@? &."F.0JR
PJ2F C   .GG4G@b#TJF  >O_G ]XD G ]D }  ( 0 ݤ8 @ #k &,A&H  D .GT
JF >2v@J#8@F^ ~(08޴@GG  ~G >^2
  @G  &,&H@                                                                                                                                                                                                                                                    c                        DdT $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        K "     w      8 DB  .."bGJV
JGF CtG~ZkGb#G_ @  .J+ 8 F  Gd.D".CGGrJ b#T
JTGtF CC_D  D =Cxb# @  @? GG]] }(08ݤ@P#k f.SfJaF $.Q$J0F2v@J#8@F^ ~(08޴@G  G  ~G >^2
  @G  &,&HA 8 D0 B  .."8 bGJV
JGF CtG~ZkGb#GM_ @  .J, 8 F  Gd.D".CGGrJ`b#T
JTGtF C_D  D =CPb# @ G  @? GG]] }(08ݤ@P#k f.SfJaF $.Q$J0FG# 1   ~ ^ ^  ~( 0   ,GGGR H  Q>  p.DH P"H pJfF ` 0, 2H P"/D
   p. rJ @  0 b" CCP B @   8  C CG  BtG( bTZk  ,aH@ H D  < G ] ]  }( 0 @ #k# ^ ~  ( 0 ޴8 @ H >P G  ~ ^GGGGG4GG  (. (J$F  8!F  0 A.  G ñ='@	  G4G0 A ("  (,A1H'H&@9!@ B-  ]!@,  $@  1$@ !J@    \<B  C  k /D  /D
     H.G4G HJ   0.H"F 0J&F  _ GG ] ] }  ( 0 ݤ8 @ H =P ` #kG? D. G  D'F%F?F	D	  Gb#\_  0 A  (, (H#  Gb#$ER_ X%E  x%E
  %E  	/E    c `F    B     B   #   O   c  `G  G  (,0 A (H   G#  C  ~ > ^ ^  ~(    ,GGGA 1H   <  #. #J$F  8!F  0`@ 0`@0 BX$F8 b F4GGJlZk `@?   @`@     .  J$F `8!F X!F    .U J  >  @`@`@    /  KXG    @/Z @K  @?  BG TG( bkZkG ] ] G  }( 0 #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k        p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #kk     Gk Gk Gk#4G ^  [ ^ ~  G  ~G( {GhZkG   G
 G"GGtG b#6@G_ GG ] ] }  0 #k# C ^4G( [ ^  G  ~G G0 {~hZkG   G tGG =8b#B_ GG ] ]  0 #k# C ^4G[ ^  G  ~G G{hZkG   G tGG =Xb#B_ GG ] ]  0 #k# C ^4G  [ ^  G  ~G G( {hZkG   G GtG =b#@ b_ GG ] ]  0 #kG# C ^4G  [  ~ G G( {iZkGG ]D   # Gk#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#G ^4GGTG ^  G  ~G0 { ~KB"     G     GG ] ]  0 #kG    D   GkG#4G ^ ~  G0 {G  ~ ^  G( {  KB G   G  GG ] ] }  0 #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^  ~( G{G ^G  ~ hb# C_   cG  .     .aHraHQ!JPJ3FF  >  > G ] ]  }( 0 #k Gk C [   0, 0. HQ
 J 1D   Gk            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# C ^4G[ ^  ~( G  ~G{GG]Zk"   B  ! @0 H1 H@ @ 0B  B H LvH  G ] G ]  }( 0 #kG# C ^4G( [ ^  ~( G  ~G0 {GGw]Zk  "   ! @  G ] ] G  }( 0 #k C [ 0, 0.0HQ
0J 1D  kG# C ^GG4G ^  G  ~Gb#g_G 4Gb#@GGFb#t@GGb^G ] ]  0 #k#G ^G ^ G  ~Gb#_G( bG^G ] ]   #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#F ^  C[ C ^G  ~tG G  G{sZk  =G @   .Q  J   > G ]  0 #kB0 C#G ^G^?D ~(G0 "8޴@HPG  ~^GGGGGGP @  / " KG[WC  {7aCD  P\|C C  k@W2AJ8RCGrK  3,0@ @0BA 3H8aG2D  3<eG*  !U@(   p@	EB$ @0@	@ ") GKG  3,GXGA 3HesK0B%D25B  3<0BGG @0@	@ " G  t.{KH GS tJ B{F  t>0B (_" B ?# B	  " B GB0  BGG  4,sD@BCHbGA 4H  4<* GtG>sZk0    , H0  CPb  BG Q.qB( bGR QJ Q>	  hjZkGGhbGGGG_0CGGhbG@GGG_   ,D H  <G] D] }(08ݤ@HP`#k  .P JF# C^TG [^ ~(G >  ~G C({ ^GgZkB CbGTGTGUZk  G G  `.0 @ BC TGS `J(b  `>gZk G BTG(bGgZkGG]] G }(0#k# C^tGP [^ ~(08޴@HPG  ~G >G'JX {GGGGGGrZkGpb#G4G_ !vHGG`Yb# CD   CtG@Dw  BbC CTGogZkB CbGTGTGVZk E B   bCGTGVUZk+     .0 @B0 @bQ  J   >  A. CTG AJEFTF  . C J MgZk   &,A &H  &<'vHGCPb# CGtG@DA    .GG( btG J CVAD7 $   #,GGtG( b #H%D    $.'vH c  C $JVAD&   C C
 GG'vHYb# C CGtGB@D  C CBTGbgZkB Cb4GgZkC
  1 @ H @   -  IE    ,E H  < GG]] D }(08ݤ@HP`#kG#4G ^[ ^  ~( G  ~GG{ > CqgZk  #.DBsCJbQ #J0`@3F  #> =tGrZkG ] ]  }( 0 #k# ^ ~  G  ~ ^GG    1,A 1H  1<) B C CbGTGfZkBb CGTGUZk  D `   .P  J   >  0 @  @.R @J  @> GB CbTGTGUZk   0 @   ,A  H   <   #.Q #J  #>G ] G ] }  0 #kG# ^ ~  ( 0 G  ~ ^GGG    1,A 1H  1<1 G  B C( bGTGUZk  0 @	 G  B C( bTGTGUZk0 @D0 B4G8 bGfZk @  0 BbG8 b4GfZkGf@Ѐb#GGGtG9_ G G@ B CH b CTGLfZk GG ] ] }  ( 0 @ #k#8 F ^X F ~ G  G  ~G ^G  x Fs @GF Go G  BF@( b CGTGeZke  8 " C  BTG( bGeZk]    BI@( b CGTGeZkU  @ " C  BTG( bGGeZkL    #, #HC*    ". "J9$B `"BB }"B@ X$F> x+F< +F:  X'F8  x'F6 @'F4 ` 'F2  x%F0  'F. `%F, /F* 'F( X%F& 7F$  X5F"  0@@  B. BJ_GG  G  c. cJeF	 uF `  0@C0`@ 0`C0`@ 0`@4G  . JtGACCGGG G  GG ] ] }  0 #kG#C ^ ~  ( 0 ޴8 @ H >P ^X G  ~ ^GGG   GGG  %,5H0 B	0@ @8 b %HG?D
 @_A GGtGpZk AIG @r H   .0@@0@AQ  J (A2F   >C `&1@&H@  -H I  =   G@ ¢&HG C@b#B CGGGR_  F- GJ FI  F=  ,E H  <   $,A $H  $< GG ] ] }  ( 0 ݤ8 @ H =P ]X ` #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k2v@J#8@F ^  ~4G( 0 G  ~ ^GGGG @hb#z_GGhb#4Gu_Bb C4GeZkB  `@b C 4GeZk = @GGb#	 @G ] ]  }( 0 @ #kG# ^ ~  ( 0 ޴8 GG  ~0B ^GGB  GG_  #. G #J0`@X%FP `'F2  X5F: @5F `7F  @- @  e.0@                                                                                                                                                                                                                                                   d                        j $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        G "            eJeFrF@_@D ð@    E. G EJ0@2F  @_@D	 ð@    e. eJ0@eF ` G_G ] ] }  ( 0 ݤ8 @ #k@0@F@_@ GDG  bGGGGG_    %, %H0@%D?@? Gò@ @ G  bGGGGG_  0@@? G#4G ^  [ ^ G  ~G( { CdZkC  G1J0 BQ@ B  Q. QJ'F `X%F
 7F X5F	   G_G ] ]   #k 4G# C(^0G  ~G > ^G ^{# @ C G @C C ]GGb# @G ](] G0@#kG# C^TG( [^ GG  ~ C0 {G"dZk .    b. C"HTJuHSbJF >uF  b>GC 0 B0 B  . J6 F  F b/0 B B/"J`"J[bKZBKaG@G b? B?BK_D . " / .JT
JXKtFyJVJ CG ?F >  1, G 1H  0 B 0 @  1, 1H? b. B. b#HS{JtHR[JuF b>TF B> G / " .JyJXKWJGF ? > "  ,G_D ".@H <Q!J ">G]] #k GG  P. PJQ @XEF? EF- GF XUF9 UF' WF @ .  .tGJWJxJVJF >F  >  P. q#?F . PJ0 Bu[JT JF > B 1/TG  /JrJY1KXK4GG 1?  ? B0 B Q.G  ,JtJRQJ@HVF D Q>  < 4G B0 BG Q.C  1/0 BJRQJtJY1KUF Q>4G  1?  P. B PJ_ q/1H  .r1H[qKVJtG q?F  >kG# C  ~ ^ G  0, p. . .  .0HS
pJJU
J3D FV J C  >  CG  q. .  qJV
JvF C ۦ`B\|B  C  k / " 0/KY
7KGG  . #  . p" JW JuJ0 @F  > . " .0@B 0/JW
JY8KF .51BJVJwJF >7G 0?   .  2/ "G JY 2KzJ0 @:G  2?0@B 0/ . /GJY
3KZWKF31`BwJvwJXKYG P?G ? BG . " .JW
JF G  @/ #  .G @KV JwRK 0 @F  > 0/ " .0@B p.GJY
6KZXKF61BJwJSxJYG P?wF p>   .  2/ " p" JY 2KzJ 0 @:G  2?0@B 0/G . /GJY
5KZSKF51BJwJXKYGG P? ? Bj#  . . p"JW
JF `  !/G P#  . !K0@Bw8KV J0 @F  >G . B .JX
JVJF71BJUJwJFF > >F p. 0# .G "yJU
JuF] `   /  .0@BG  KU JyK 0 @F  > B . .JY
JWJG81 CKUJxKF >F >#G q.G "  . uJ0@BxzJW J 0#F  > "  . p.JS
yJF C. ` /31`B .vJzvJXKWJGF ?0 @ > B  p. 0# . "yJU
JuF C ` / .31`BvJXKzvJWJG ?F > 0 @ BGG  .vyJ0@BU J4GF  > B.#  r." JS rJF  r> _F.V J>G ]   #kp B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k# C ^ C  [tG ^  ~( 0 8 ޴@ H P >X G  ~GG( {GGGlZk`  G $!   BGbGGtGmZk GG  . J	  F	_BSB7@JC . J@J F	BB7 JC V. VJAF
  	@2@J @7Jw@  / KX K2Gy7KG  ? ú	@ @7@Kz@  z/ zK[ zKrFszJsG  z? !   B&@( b 0 @CG CGtGlZk  ,GG H  . q" Q. Q# 1/ " J . SJ q. :K  Q/8@JJ JGxJZ QK;J@JXG  Q?rG?F q/ " wJ "tWJ[ wK! KtG q?J?F Q/6D #v8HZ XK3`JVG Q? K?F .yF Q"wrJT J BF >; B 1"  . 1  1/0 B "G !K J! HJZ QK6Dr1H 1"RG'BQ? " .  H` "G JA 6HJ }# DrHG2D $<    .  BGF JFBB q.  . JG qJ J1 J {"FFF2D  ;G . " ;. 9, J 4JFJaFBB0 .?F  /@J!F JB0 J KP .B / "@ .pF {. 6H JF " Jw4HS tJ " KwF {>F .2@J #G . J H2F0FBF "xJp a.W JBF >` . aJ Y. 9"! HG . J QJF1D {"w3HT J 9#F >)C {# "0 A2A( b_ CCGtGkZkG ] ]  }( 0 8 ݤ@ H P =X ` #kG#0 ^8 ~@ H P G  ~G( ^GG C_CGGGGG{# @`@G_CGGGGb# @ } '   ] _  ,"  # "D# H?F  FD SF   c#.  D . J JW JGxKF > "$/ #D #. :K ]# ;JQ ;JYFr[J2F #>D .d  JFFU JtJF > c b@  8/ "  WX   e. e  8K GYFtEJS eJ W"tF  e> ."8,GD , J "H "Fv#HD HD < 7/  x. "D E, 2K tJSFpUJB UHPD E< w,8 "D %/ dHBaDt6HY 6K#4G %?  G( ]0 ]8 }@ H P ` #kG# ^  ~( G  ~G > ^G ^ C C{#!_  =a@b#@!@_G ] ]  }( 0 #kG# C8 ^tG[@ ^H ~P X G  ~GG G{0 ~GGG)kZk d@?   @   .  J  @     `.$1@ `J  @ `   .$1@ J  @6@0 "5  #  #/ 8   8 #K0`@9F?F?GF    c. 8"G , cJ0`@ H@ HFuJ D <  .  G X. J0`@ QJR QJ6Gy1KYF X>  .GG 8, J0`@  HA  HpFs`J3D 8< #C$@:@_" GGd@ "_$F    .G @ J.P J J`FsvJF  >
   .  V/ J VKZ VK5Gy6K0 BYG  V? "B0@B G = _p D  C0 @ p.p@GFC pJP @FFG   :.p @?D a. " :Jp`D vJpDFCCS vJ C.uJ . #uF a> CJ?D !/ A# J  @ 8KY 8KFpJC0G !??D A.Gb# ZJR ZJFtJTF A> ! 7@?0 =	 @G8 ]@ ]H }P X ` #kG# G ^ ~  ( 0 GG  ~G ^GG GGG_@B  /cF  s@6H  . KJF JC3uB  .F @@B4BFxqJU Jw@F  >  W/6H?F q. WK / " A# uJJ KvB7B .wF @@BTBF Q#xzJV Ju@F >7H  u/ "?F q. A# / uK vJJ KwB Q/5BuF @@Bt`CcG "wvJZ VK{@WG Q??F q. "  . .8H vJ . A# JK J q#V JxB5B@BuFz{J0 bDBF > @ 1"( B ! 0 B7U BGGGtGiZkG G  c _    .	@ J @@7`JPP.@  . PJ0 J JT JFuJF  > G	@  . @ J7 K@@P6/  X/ 6K XKZ XKvG{xK[G  X? ! #@ 0 @?G ] ] G }  ( 0 @ #k# 4G( ^CGG   C0 ^G8 ~TG@ G  ~G#J8 {GA     0D  =P H6v JՐ H	 0 H H_F2@J D @   G1B  0F  #7vJ
C  M"   0FFTB:v K @  9C 0F p? ;v`K
;@  S{# p  pGF 3v`J@ B( ]0v J0 ] pB6CFBNVDJ CFC` @  B @B   .  J `@8 } D@ P #kG# ^ ~  ( 0 ޴8 G  ~G ^GG%v JG Cb#_  &.rH0`@!a@Q &J0@2F  &>?G ] G ] }  ( 0 ݤ8 @ #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#G ^TG ~  ( GG ^GG  ~  4G{(?BtG  0"GG9b#G1" CGGr@Gb#G_G4Gb#@)@ D  0"G4G8 b?@Gn
_GGb#_G`b#0@M `.J  "J @.1Ht1HSqJRQJuFTFM `>J @>F " DI  /6HF .y6HXKWJGGFI  ?4GF >p_ D0"
  G9b# C!  CtGGGr@GGb#f_ CT "3 #.0 .HrHQ#JPJ3FF3 #>0 >W .GT .HVJwHUJFFW >T > ] ] }  ( 0 #k#4G ^G  ~ G X{#W_G ]   #k  C ۦT `"0  .3 @.T .W .0JR
@J  JU
J2F6 FkG#4G ^  ~( 0 G { ^G[  ~  Cc {]ZkG0 @(b4GTG|>B $.H  .rH  c GQ$JPJ3F $>F  >  . .JV
JF C `   CBTGbG\Zk GG ] ]  }( 0 @ #k@# C  ~ TG ^    .G @.[ J{R
@J 2F  CG\ZkG ] G   #kG#4G ^  ~( 0 G`{ ^G [  ~  Cc {>]ZkG0 @hb4GTG&>B $. $  .H  crHQ!JPJ3F $>F > . " . GJV
JF C `   CBTGbG\Zk GG ] ]  }( 0 @ #k# C  ~ TG ^   .    @.G[!JR
AJ{ 2F  CGn\ZkG ]  G  #k -  .-   rJQ !J2F-  > Gk  P. R PJ-  ,-     HsH GSF  P>k .  ..                                                                                                                                                                                                                                                      e                        ZE $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           rJQ !J2F.  > Gk  P. R PJ.  ,.     HsH GSF  P>k /  ./   rJQ !J2F/  > Gk  P. R PJ/  ,/     HsH GSF  P>k 0  .r JQ  J2F0  > GkG   P. R PJ0  ,  HsH GSF  P>kG 1  .1   rJQ !J2F1  > Gk   P. R PJ1  ,1     HsH GSF  P>k0 2  .2   rJQ !J2F2  > Gk@  P. R PJ2  ,2     HsH GSF  P>kP 3  .3   rJQ !J2F3  > Gk`  P. R PJ3  ,3     HsH GSF  P>kp 4  .4   rJQ !J2F4  > Gk  P. R PJ4  ,4     HsH GSF  P>k 5  .5   rJQ !J2F5  > Gk  P. R PJ5  ,5     HsH GSF  P>k 6  .6   rJQ !J2F6  > Gk  P. R PJ6  ,6     HsH GSF  P>k 7  .7   rJQ !J2F7  > Gk  P. R PJ7  ,7     HsH GSF  P>k <   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG  <  .<   = @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF > E @.B   B  .JsJRAJQ!JTF3FE @>B  > GkG  B  .B   E @.!JR
AJ 2F   GkG#4G ^[ ^  ~( G  ~G  C{[ZkG0 @Hb4GTG<BG   G  = CBTGbG[Zk@ I  .F  .F   aHQ!JraHPJ3FI  >FF  > GG ] ]  }( 0 #k`#  ~  ^ F  .F   I @.G!JR
AJ 2F  C    .T J  > G[ C{ CTGZZkG ]  G  #k#4G ^ [ ^  ~( G  ~G  C({\[ZkG0 @b4GTGD<BG   G  = CBTGbGZZk M  .J  .J   aHQ!JraHPJ3FM  >FJ  > GG ] ]  }( 0 #k#  ~  ^ J  .J   M @.G!JR
AJ 2F  C    .T J  > G[ C{ CTGZZkG ]  G  #k  @. J  .s JR@JQ JTF @>3F  > Gk   . @. JR
@J 2F   Gk0J1v J   N A"q@Fp@F  uJTJFWB      Gk 0 JFF    Gk N  .N   O @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF > P  .r JQ  J2FP  > GkG   P. R PJP  ,  HsH GSF  P>kG T @.Q   Q  .JsJRAJQ!JTF3FT @>Q  > GkG  Q  .Q   T @.!JR
AJ 2F   GkG0 X @.U   U  .JsJRAJQ!JTF3FX @>U  > GkG@ U  .U   X @.!JR
AJ 2F   GkGP \ @.Y   Y  .JsJRAJQ!JTF3F\ @>Y  > GkG` Y  .Y   \ @.!JR
AJ 2F   GkGp ` @.]   ]  .JsJRAJQ!JTF3F` @>]  > GkG ]  .]   ` @.!JR
AJ 2F   GkG#4G ^  ~( 0 G{ ^G0[  ~  Cc 8{6ZZkG0 @b4GTG;Bӆ $. $  .H  crHQ!JPJ3F $>F > . " . GJV
JF C `   C BTGbGYZk GG ] ]  }( 0 @ #k# C  ~ TG ^   .    @.G [!JR
AJ({ 2F  CGfYZkG ]  G  #k q Dp D8 QsJ GRTJSF8 QWB `kG< Q0 J G_FSF< QkG 8  .9 @. JR@J2F    .u0J GTJF  >kG .
0JT
JF > :   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG :  .:   ; @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >  >   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG >  .>   ? @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >  q Dp D@ QsJ GRTJSF@ QWB `kGD Q0 J G_FSFD QkG0 @  .A @. JR@J2F    .u0J GTJF  >kG .
0JT
JF >@F o   q Dp D  QsJ GRTJSF  QWB `kG Q0 J G_FSF QkGP  . T Jo  .o   p @. G!JRAJ2Fu0JF  >kG#4G ^  ~( 0 Gp{ ^G[  ~  Cc {YZkG0 @xb4GTG9Bt $.q $ q .H  crHQ!JPJ3Ft $>Fq >q .q "t . GJV
JF C `   CBTGbGSXZk GG ] ]  }( 0 @ #k# C  ~ TG ^ q  .q   t @.G [!JR
AJ{ 2F  CG6XZkG ]  G  #k#4G ^  ~( 0 G{ ^GP[  ~  Cc X{XZkG0 @b4GTG9B  $. $  .H  crHQ!JPJ3F  $>F > . "  . GJV
JF C `   C BTG(bGWZk GG ] ]  }( 0 @ #k# C  ~ TG ^   .     @.G@[!JR
AJH{ 2F  CGWZkG ]  G  #k#4G ^  ~( 0 G{ ^G[  ~  Cc {VXZkG0 @b4GTG>9B$ $.! $ ! .H  crHQ!JPJ3F$ $>F! >! .! "$ . GJV
JF C `   C`BTGhbGWZk GG ] ]  }( 0 @ #k# C  ~ TG ^ !  .!   $ @.G[!JR
AJ{ 2F  CGWZkG ]  G  #k#4G ^  ~( 0 G0{ ^G[  ~  Cc {WZkG0 @8b4GTG8B( $.% $ % .H  crHQ!JPJ3F( $>F% >% .% "( . GJV
JF C `   CBTGbGKWZk GG ] ]  }( 0 @ #kP# C  ~ TG ^ %  .%   ( @.G[!JR
AJ{ 2F  CG.WZkG ]  G  #k#4G ^  ~( 0 G{ ^G  [  ~  Cc ( {WZkG0 @b4GTG8B, $.) $ ) .H  crHQ!JPJ3F, $>F) >) .) ", . GJV
JF C `   CBTGbGVZk GG ] ]  }( 0 @ #k# C  ~ TG ^ )  .)   , @.G( [!JR
AJ0 { 2F  CGVZkG ]  G  #k a   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG a  .a   b @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF > c   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG c  .c   d @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF > i   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG i  .i   j @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >(   .   rJQ !J2F  > Gk8  P. R PJ  ,     HsH GSF  P>kH h @.e   e  .JsJRAJQ!JTF3Fh @>e  > GkGX e  .e   h @.!JR
AJ 2F   GkGh n @.k   k  .JsJRAJQ!JTF3Fn @>k  > GkGx k  .k   n @.!JR
AJ 2F   GkG u   q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG u  .u   v @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >è z @.w   w  .JsJRAJQ!JTF3Fz @>w  > GkG w  .w   z @.!JR
AJ 2F   GkG ~ @.{   {  .JsJRAJQ!JTF3F~ @>{  > GkG {  .{   ~ @.!JR
AJ 2F   GkG# C ^ GX[tG  ~ @ G`{G`ZkG ] G   #kG# C ^ Gx[tG  ~ @ G{G`ZkG ] G   #kG0   @.  .   JRAJsJQ!JTF @>3F  >   GkG@   .    @.!JR
AJ 2F   GkG`# C ^ G[tG  ~ @ G{Go`ZkG ] G   #kG# C ^ G[tG  ~ @ G{GY`ZkG ] G   #kG  @.     .JsJRAJQ!JTF3F @>  > GkG   .    @.!JR
AJ 2F   GkG  @.     .JsJRAJQ!JTF3F @>  > GkG   .    @.!JR
AJ 2F   GkG  @.     .JsJRAJQ!JTF3F @>  > GkG   .    @.!JR
AJ 2F   GkG  @.     .JsJRAJQ!JTF3F @>  > GkG    .    @.!JR
AJ 2F   GkG    q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG    .    @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >0    q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG@   .    @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >ð#@ B ^TGG  ^( ~0 8 @ G  ~G >Gh{ 4GG5BG  `" G! A. !. "pHRPJspHQ0JTF A>3F !>$ G` C  / " .vHyvHXKWJGF ? >tG }B ]GbN_Zk   %, , e HA#HpH@H1D %< D < GG ]  ]( }0 8 @ P #kp  @.    `. "AJS
aJSF C  0   . .JV
J F   Gk    q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG   .    @.!JRAJ2F    .u0J GTJF  >k .
0J                                                                                                                                                                                                                                                   f                        = $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        54 "           T
JF >à    q Dp D  QsJ GRTJSFWB  Q `k Q0 J G_FSF QkG   .    @.!JRAJ2F    .u0J GTJF  >k .
0JT
JF >ð#C( ^4G0 ~8 @ H G {  ~G  ^Gc Gb#  .     .JQ
!J F C  `G@ D  `   #  a. !" A.JtJSqJRQJuFTF a> A>4GGG( bTG4BG  GI GGC b#G4G_GC@b#G4G_ .   %, %# P JA H > %<HD e.vH E.SeJ e>REJ E>D .  .UJTJFF >  >  E/ e/K`K[yKZYKaG e?@G E?G4G hb#y_G 4Gb#!@GG TGb#@GG 4Gb#_G  ] D( ]0 }8 @ H P #k# C  ^4G( ~0 8 @ ޴H P X GG  ~G ^G{#=_ӀGb# E_G4G(b#  .  .   JQ
!JF CG^!@G CXb#GGTG!@DGv  G `  #.GGGQ#J2F  #> } . " .JV
JF C% ` A 0 A  0@4Gt `  C/{KG4GZCK[G  C? Gb#_ GQ @`b#GTGv_ =s@3aJG  !.@ A.!JR
AJ2F  3GG4Gb#P!@ DG  CXb#GGTGg!@ D"G CpCb#tG<@GTGGg@G  4GPb#_GGb#_Ӯ  #,#H6 `8 D  C  G_R @G2AJ b#0@@4G  TG4_Ө@GG0b#4G_GG4G  Pb#_G ] D  ]( }0 8 @ ݤH P X ` #k #.GQ
#J2F #>t C/
KZ
CK[G C? .PJFà#4G  ^( ~0 8 @ ޴H P GG  ~G >G  ^G @.    `. AJb#S
aJSFy_G Chb#G4G @ӠC  GGGXb#4G0@ @DG  @Gb#CGTG @DG	 ` ݠG tG  B( bGG7]ZkG 4Gb#_G ] D  ]( }0 8 @ ݤH P ` #k#4G  ^( ~0 8 @ G{G ^Gc   ~(b#1_G4Gb#  .  .   JQ
!JF CGJ @G C b#G4G6_G Cb#GGTG @DG  P C "_G CCb#tGTGGf@G  4Gb#D_GGb#_ G =4GG   . @.xb# JR
@J2F C!F  O @ D  GCb#GGTGf @DPG? C "   .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > GGG  4Gb#
_G ] D  ]( }0 8 @ P #k#4G  ^( ~0 8 @ G {G ^Gc   ~Hb#_G4Gb#  .  .   JQ
!JF CG@G C b#G4G_G Cb#GGTG @DG  p C "_G CCb#tGTGG}f@G  4Gb#_GG b#B_ 4G =G   . @.b# JR
@J2F CF  G@ D  GCb#GGTG@DpG? Cp "   .  " @.0JT
PJRPJtF0`BpJQ0JspJTF3F @>  > GG  4Gb#_G ] D  ]( }0 8 @ P #k#4G  ^( ~0 8 @ G0{G ^Gc   ~xb#-_G4Gb#  .  .   JQ
!JF CGF@G CPb#G4G2_G Cb#GGTG@DG   CP "_G C Db#tGTGGe@G  4G b#@_GG0b#_ 4G =G   . @.b# JR
@J2F CF  GK@ D%  GCb#GGTGb@DG? C0 "   .     . `"JQ
!JF C   . .!1 @3HUJv3HTJF >F > GGG  4G b# _G ] D  ]( }0 8 @ P #k#4G ^  ~( 0 8 GG ^GG   ~@b#_4GGb#  .     .JQ
!JF CG@G Cb#GGTG@ Dh "   C ! _G CDb#tGTGGye@G  4Gb#_GGb#>_ 4GGb#   .  . JQ
 J F  C D  G@ DG  Cb#GGTG@ Dh " CGGb#4G@ GG b4GG1B GGG  4Gb#_G ] D ]  }( 0 8 @ #k      . @. JR
@J 2F   Gk        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k#TG ^  ~( 0 8 G ^FG c@D @  ~G >{ C4G&1B      " CGtG5b#G,@GGGd@G b#G_G$@b#G4G_ D  G C5b#tG@GGGd@G b#G_    'G'  .$  .$   HQ!JrHPJ3F'  >F$  >L "O  /{#L .JXKyJWJGFO  ?L >B `  F!@A!@@q Fp F  Q CRSJW`B  Q> ` . . "  qFVJ >TJ >  8pFzqK!!HY1K@:G  8W B4B/ @ , a.GAJDH`AJSaJD <`F a>?D / !" .QJXKyQJWJ q FGF ? >p F F	BDHW`B  `G ] ]  }( 0 8 @ #k Q_F QG 80`K?G:G 8 D # 4G ^G  ~ G   {#'_G ]   #k# C ^G[G  ^tG( ~0 8 G  ~GG{G /ZZkD@Bc@Hb Cc@4G   @     . `"  .JQ
!JF = . .JU
JF C\OZk =t H  BCC( b3?HG tF F@GGGKcZk   G
    =@q`Dp`D Qs4HRTJSF QWB
 ` GG ]  ]( }0 8 @ #kG Q0 H_FSF Q C$  $ 0,' 0.L P"L p. "O . HQ
 JrJT
J 1DtF  k#C  ^G( ~0 8 @ G  ~   ^GG CGH{#V@	    "G C0 bTGGV^i GGCb#G4G6_  HDW  %   F1BQ1B1@4 B  q. .F	CqJTJCtF8`F `XC 8@A  4 B  x/ ,xK@H`G8`G ` F	B4  }GGb#F CG< @DG ` =b#?D C@ ` = tGGtG?D5b# D D  TGec@ }  b#D c@@ @ @     .  .JQ
!J F  C C  @. @J  _G D GGtG5b#tGTGHc@ GG ]  ]( }0 8 @ P #kp#0J0^4G8~@HP޴X`h>p^x~GG(^GG$AJ  ~%aJ   !  Gb#
G)_G Cb#G4G_Gb# C4G<_  	D  G_E !@P BA!@X bB C A.TG a.
4@AAJS
aJSF COMZk  _E	)@? 
GSD gD 2 .2 #")A JDRB  dB "  . . 4 AP@JUJ!HF8F}  / 6/aBGKY
7KTGG C4G  W/ WKBo  }G	@k  OZk V- ,@ BVIE
HH bEE CGNZkG @8 b4GTG.BG  
G 'G  BTG( b$@ !. A.!JR
AJ2F CmMZk G H@ BH b4G @AH  .rH  .
DA "Q JP J3FF  >  > . .JV
J
F
 CGMZkG8 b @4GTG.BG  
G G 'TG  B&H( b$@ " !. A.0JR
PJG2F C9MZk GG4Gx bFA   &, ,HpHA$H@H1D D &< < CAD
G @ B CH b4G
GMZkG @8 b4GTG.BG   G@ B2  H b C4GMZkG @8 b4GTG.BG  
G G Cb#4G)Af_ GL@P BTGX b
LA 
  *, 
. HP
 J0D C   C~LZkC 4G  B( b C CTGLZk  B( b C CTGLZk GG4Gb
LA 
- ,
ID
HE C  .B  C*IGb4G
@H 
.qH *,@ d"P
JA*HF1D 
> *< . .JU
JF C  g.B (IA   , H-eI`eIDHJEID
@E < H=	)A I)A  ]C 'D3J  Bt@J( b)BtF  " .G /TG4GJX
KF CLZkGCC bGGGtGAD
G   	Aq Ep E  caIDHD  W @* ` "q F ?$  Q! p Fs4HRTJSF  QWB$ ` . (  .VJUJ > >4GG  b#_G(] _E0]8}@HPݤX`h=p]x}#kG 0`IDD  Q0 H_FSF Q# ^  ~( 0 8 G  ~F G ^ Cp{#g @V  c@Cc@G $  #@ " !. A.0JR
PJ2F C    p. pJ   B   .q D . p DJWJF8F9  / !/  zKY
!K[`K  zGW @ C9  G4Gb C-B  0HGGb@0H p.t0H P. @ "SpJRPJuFTF p> P>4G .%H  /GJX
KF C-B  @   .`H $,q`HP JA HF >1D $< }G ] ]  } F( 0 8 @ #k zG zG# C ^4GG ^  G  ~G{#G_ G ]_D D
@@ ]  0 #kG#0J ^  ~( G?F  ~  C G ^G{#_$  c@A!@ }GTG 3v`J( bB "  !. A. C!JRAJ2F8 F   C
 ` . .JV
JF C  . J  BӠC G 4G  GG ] ]  }( 0 #k#F ^  G  ~G  ^ C{#_   =!@ PA!@A@  !. A.!JRAJ2F8 F   a. .aJTJtF5`B  GG ] ]  0 #k#F                                                                                                                                                                                                                                                   g                        s r $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "            ^  G  ~G  ^ C{#x_   =!@ PA!@A@ a"  !. A.!JRAJ2F8 F
   . .JU
JF C  . J @  GG ] ]  0 #k#0J  ^4GG ^( ^C0 ~8 @ H ޴P X ` G  ~G GPb#G_  ¤GG D      D@BH!@bBTG  0. P.0JRPJ2F8 F	   p. . CpJT
JtF CJZk   =4@D?D	B?G_G  ] D( ]0 }8 @ H ݤP X ` p #kG  ƠTG G@b &" F. f.5vJQJS
qJ CSF C C  . J  B }  -fHH IE  =#0J  ^( ~0 G?F  ~  C G ^ ^G{#_   = Cb#!v Hc@ C_ 8 D "  Cc@ }TG !BbG#@ !. A.!JR
AJ2F CGJZk G  GG ]  ]( }0 @ #kG# ^ ~  ( 0 G  ~?F ^  CGGGG0{#_2  %vH C CPb#_ 8 D+  Gxb C CTG B$  
  ,
  
  .G BTG$HbP
J  0D C CGWJZk ,	 %, C0 BTGH8 bA
$H    D  CG$xZk0 B C8 b CTGxZk G  GG ] ] }  ( 0 @ #k#0J ^  ~( G?F  ~  C G ^GP{#]_    = Cpb#c@!v HCc@ Cl_ 8 D"   C#aH ! G#@ " !. A.0JT
PJRPJtF0`BpJQ0JspJTF3F A> !>  GG ] ]  }( 0 #k# ^ ~  ( G?F  ~  C ^GGGp{#%_)  $vH C Cb#7_ 8 D"  c@Cc@ DC@ " !. A. C#aH0JR
PJC@2F CC   . b" .JW
JUJF61BJTJvJFF > > G  GG ] ] }  ( 0 #k#0v J  ^( ~0 G?F  ~G  ^ C ^ C{#_ 8 D =  Gb CGTGA   @, `   , CHA#HAD    0.rPH GQ0J2F  0>  GG ]  ]( }0 @ #kG 0.
PHQ
0J2F 0>#2AJ ^  ~( 0 G  ~#v J ^?F ^G C C{#_ 8 D  Gb C CTGA
   `  q`Dp`D  "pH GA1H0D  "W B
    GG ] ]  }( 0 @ #k "0H G?D0D "G#+?" ^TGG ^ ~  ( G  ~GG{4G*BG   G@BGHbG+_"tG}TZk C,).  )$  @HP JqHp`@F)>G  C. CJ0`@CF 7AJ8uB
C3 2  ;J  #/ #"@ #K , [ a"K@ H {" D < .  G . J [ wJU J # F >B C/ "G ;/ @K3JqHY "K	xB1G ;? C . c G . J0`@z5HW JBF >  G9J  #.0B@ #J 9, "u0JA 0H C5D 9<B0`@6J2  @ V# v/[ zK v?  c. cJ0`@F `2 D,B @H2 D<R  CCGH   C5!H9uB
5C4 3  G7J  .  @ J2 W/2 "{VJZ VK3 W [G2 W? / C"F3 7.  K4 W#uHQ "J "5F3 7> B .5 7"F4 w/ J"JxZJ[ zK	Y@xG4 w? C , c F5 . H0`@tHU JBF5 >_ @G;J  C/0 B@ CK2 ,2 "qVK@ H C D2 <B0`@0J@2 "2 .W J2 >G  C, CH0`@CC  1AH6u B
B1  0 !K  C/ "@ CK0a.tAK1"S aJ c#tF0a> .2"?D1!/ J c"`JY 7K C G1!?3" #.0K?D2A/ ;J	Bu4JZ TK CUG2A?C , c ?D3!/ H0`@{HY 7K;G3!?  :K  .0 C@ J0,aJ C@ HC D0<0`@8KG@0x/[ xK0x?  . J0`@CD  !J3u @
aB1  0 `2J  . c#@ J...R xJW J/"F.> #/ C _F/, ;K "a6K@ HB D/<12  C/ J_F0. BK	@xRHW J CF0>B c/ c _F1. uK0`@yJV JF1> @8J  .0B@ J.8,.x#rJA ;H C2D.8<B0`@G  . J0`@CF @"J!u@@
"@3 @2  8aJ  C. "@ CJ,8.,x#p[JQ ;J-8#0F,8> . "G-X/ J.X"bJZ YK #"BG-X?`B ./8#G.x/ J4aJuJ[ rK	BuG.x?  C C, c G/X/ QH0`@wYHZ YK`BWG/X?  G;aJ  .0`B@ J,[,,;"wJB QH  CWD,[<`B0`@G  #/ #K0`@CF  2!K"u@B
R@3 @2 @7J  #. #@ #J*,*w#s;J@ H+W# D*< .  F+. J,w"rJP J #"F+>B .-"F,w/ J2JxH[ sK	BBxG,w? C . c F-W/ J0`@uJZ VKBUG-W?_  G;J  /0B@ K*.*;"uKP J CF*>B0`@(D,  .* B DH J@rdHRD(D<D*d.S `J*d> GG ] ] }  ( 0 #kG# ^ ~  ( 0 G  ~G ^GG`{#_ C G'   #,Gb#G #H #J @G C_G    . JP J4 Bq#JF  >   C. CJ @  .4@BuCJT JF  >6J@G C7b#GP@tGtGG;\@GhbG4G(BG ] G ] }  ( 0 @ #k#4G ^  ~( 0 8 ޴@ G ^GG#J  ~  b#D#_G( b C4GpAG Cb#G4G_  D	@h   D!@GE!@bB C 0.4G P.0JR
PJ2F C  i(B 0HG @ H @.s H  .R@JQ JTF3F @>  >4G GbB " . /JX
KF C  M(B 0HG @  " `.1H @.t1HSqJRQJuF `>TF @> Ģ&HGB # F/ &/JBZXK{JY8K qDPG;G F? &?pD   A1HW B   $    q Dp D  rStJWB  r   . .  4`@VJUJ > >D ݤD	BG4G  b#_G ] ]  }( 0 8 ݤ@ P #k  ?D   rF rG# ^  ~( 0 8 ޴@ H P >X ^` ~h G  ~G ^GG{#_ C G GC b#G4G_  ,2 $"4GG4G Hhb# @  2 . Jo    g_ Q @e   	E)AGJ!@Hb
B p"  0.4G P.0JRPJ2F8 F   . .JU
JF C  . J   C{A   =4 AE?D	B?B  '*Bq F Q.p F q.  QJS
qJUJ  SFWB C G4Gb C'B !aIG GbAH A.sH !.
A "RAJQ!JTF3F A> !>4G .+aI .GJW
JF Cw'B GG C( b4G
KA 
  *. I *,r IQ JA H3F *>2D *<AG  4Gb#:_  c- =B cI	?E	iAM   J!  ,4G  
G HHb@G@ @   .  . JQ JF8 F     C. CJA    c-   cI	kAI)A@ '  . '.4`AtcIJQ
!JF C  A. AJ
    c.S cJtF  c>  cJF	B   . CG4G JPb#s_G	    , HG H4`AkcID  < GGF@8b# CGP@tGtGGZ@GGb4G'BG ] G ]  }( 0 8 ݤ@ H P =X ]` }h p #k F [G#4G ^  ~( 0 8 ޴@ G   ^GG#J  ~  b#z_G Cpb#G4G_ D D	 @  G $D@GFB b&B C  q.4G .qJTJtF8`F `Az   $4GG&@ . !.JQ
!JF C  8 b&B  C!!HG @ J @.  .s JR@JQ JTF @>3F  > 4GGB " . / C&HJX
KF C  8 b&B G @  " @.0H  .s0HRPJQ0JTF @>3F  > 4@GF	@$ D B( BVB C8KBB R"TG$GZk =4@ D( B4 @?G	9@    @@ @ C%HBB R"TGGZk ݦ4@D4 CF	C =G $TGp BD?Gx b9CY9C9U"C9!K 9@GtGOZkG C b4GYA 4`@ DD	@nG4G  @b#_G ] ]  }( 0 8 ݤ@ P #k    # G ^  ~( 0 8 ޴@ H P >X ^` G    ~G G ^GGGTG( ( G  8B   6 0 @9B   V 0 @:B @ v 0 @;B
 `  0 @ "B0B   0 @_ GG( bp G4GIB  i [ @Zk
 C @ G G  iG@4G  ' [P ?@ @Zk C @ G G .G j.4`D  'G
ITJu
ISjJF >uF j>
_E J/4D */ 
#JZXK{JY8K@G;G J? *?G
_E ,tD j,JDHhJCjHD <hD j< .JJ  .vJJ 
 UJTJFF >  > H
_E 
/y H 
.X KP JG 
?F 
>  j, j/CjH[jK j< j?  
_E j.H 
-  'wHSdJ0 BHIeFE j>Q ?A 
=GEZkp ݢG 
/   *,JJX
KyJA*HG 
?9D *<
_E ,eJ *-JDHI'ID	%E < *=bJ
_E# .$ j"  
- GWJH
IFE# >  
=+ J.
_E( *.RJJ+ J>Q*J( *>
_E' J/$ .ZSKTJ' J?$ > }  [G ] ]  }( 0 8 ݤ@ H P =X ]` p #kG#    ~ ^ ^ ~  ( 0 ޴8 @ H  0,G 0.GG HQ
 JG 1D  CCY  G  c. .pcJT
JtF CeB  . .JW
JF C>  #/ f# C/ . &,#KZ
CK  f.J .A
;H:GFY ?C C@  ,fJ A.U
J  y4GHR
AJ [uFD C @Zk #, . &" F.4G#H f.P
JQJ0DA ?@@S
qJ  a CSF C [ @Zk #,4G .#HP
J 0D@ @ @ C  `G [ @Zk #,   .0@@ HP
 J 0D  C@ C. c. #"pQJS
qJSF+  G / " #/   .KY
7K .JGV
J CF  w/ ,T BAwKF
HGfG  t4G [ @Zk , ,H`HEHDHDD < < "D C.HR
PJ2F  .# .JU
JF'  . /  #/# C/JX
K#KFZ
CKW B:GA C  w ,G 9, [HA
9H4GD @Zk# ,  ,H`HGHFHDD# <  <HD# #.                                                                                                                                                                                                                                                   h                        j哔 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        bb "           7i;}bTB
`~Υf"\h6.u9C
sR?7<>N?u>ScߑfuEu2Nl	MzƍT?:#-aE	Y-C	(#?`7!~1ƂLqk5NFcFs89
&o=ů lBĘ#Wyd@n8Ȩ\;Ye¢!Tu$}KFb*׫X;931oO_e	J3٢Ntw,ժ`
X\/[ rS.7RYƠy4CaDJ|V`>[p\=AVT6|
GuYh-WRkt$P^Ԣ,qNG2sX5&X$4vw_1ΞѝY~
1bHR>cnE_4z^K, P&b(U-λiPT>֓/U=#T-?ȠL1ag`I&02`D6M*pe}K	08y
:F'nTv/l_Q	f(VFwߤْrxG@(Qޑb:ϯ{ն5w^Ϯ}Ȼ3"ߖaO9jp8&H=rTêԖ Nۛ"Щm:7$)~mgXR?ddrߤgVskGωe#cώwO't^4JP(b#A`;|?pޕZԙٓS߮6t>+˄,ευPZ;fؚ@;~wt:WY_{"OY&֑{bljW-prAa9DG زzɱV_%)%A4ˡHă *d
Tq>TmRуJ	|q75F
2SrK8Ȕ/x
+$sO!ArVp.a0maV1vogl}}
tmp",R2uۮRrփp܊fO]wwJݛSկv_l5s+1_8prٲ)nƽjg?;ߝ,w?w4ZX0DJ]jk>Kr'Y>p8L9qQm۱ u#ǭ˪t%kxU$+YOS-}t@[@*ۃx='5ts6̇4$~M%ǹN»ml`ӻ~k/"zZ`wɺ@	2QcK$K]٤uI2:Ūb^	Tb05eV `FBt$m)6}cl7LJ'Gnj^bYҏ:)Eh9$.O
Wy<9Xњyz-S!Fo7!3.Bé:'&Scp
ki}~p\ikEņ#YH8AJ7
"+p1S=Hb)(Z[rJa/|p{al}GsWϨ:lGRykW+@Өvz_K%`@W<ËE WC	Ib$'O`hV-.;Au6'VYҝHnPQv
;l=nd(U$^ 
͔d=ͯ.Yξ #PV'<NEoQ,iJJ
^GR/e4$Fg'<_51-whژ0uos%	)*!~CPT[)vm8XH`P]:ovm~0&WʽzN͓-Y{۬6	q*^jWqdtXCA[=7E:Пuq':_j^S[%Ck¡웩A'ceŶjGiNߛ3tvEZ6O,	,u-~ĸp~tPM)-UG*("%PrU,=l'}䓔 ;\qY63ʊO^ Vo1yl '`
󭢽v<+߁&%0Sx4ChWjI!|x:
rPZsmf"=NmZE,q&uAU)g$HTKÑQj49Hs	f'2;;+6$HiYuo?o6ȗF_d@eA4)k1j<9Tb
y۟{M,u_}!
+($m+dz^LuA^^".<J)
--wXDJNH.sR(1
I,{Hy}f+8:oG!-.7YMH>w:}dJH'7i1x_S!dB-ˍ9`QaĬK'x4!۳q^HRc>?iݙ+>.A2 6/\=:k(c/cORUQO⣯1(EqS|='Qie]_k<-䄺ˈ8pE?9>b̺/;U<NX*
T8{.>?)|]%=PaiuS^Ъj21v_U̽;\ˁ^p5-hT-
6	z
oNMa;=3ts=v(<>}ם==[ϙ`3y6գO\a̩͸{ogCyp8E`6X$}TYr3~Fb(ݐ;~HҩU,
Fr!d&
^%gQ!H,u<Ĳ d#r&x(#->dnz:CK\K+3J7-:õr3y& /$"	2/>Ij{ʂ
;N) [OV(c. Ϛ h_ZfH)%(FMweCH XO}E3L*A: ?-#I'VuIz;mD`RQ&f$ߣ[IOݯ4){	Ǩ3gc;XW ˛tP,JBcwv>ϱ°S9>4½8@"v7	M_P/nI7r$ԥ)
ceC5.w	0ھEHIUH'$kTâ@\7/
=zY"cX0nƒDA!wgFڊ<^b~gЧbbxɒ=?37K̹BG% 5lVm]ݖ&DAH}xi}7bhqL!5;pbwRIvWdJ%)KAvZ-&M|9A[Vq*R49l$wdc]jp?$Sṕ+cY[LOrgk+f؋O"՜Ego>9QF36CX28U﫨
uNU'R喇v5cf8|]cUߧ,"wQX\Z LHm5s ,mRqb5Ψ!kɗt㧫+9ѤOm<͙rޥ}  I5E~[0K*4(>|;HhV^ٖOݥ GK)d<
P`d`P4.jq/T_>qcņ(iH.2eVDp)"q!Aw#G2Hd
JX=X{HXa4::ȕa\gS8;Fu@)+XvE%sw*K7t۠[,}qil=/lq~3îmD7Z)41sZdYYn@̖IbXb`7|+,9Q
-,&༣Aّڹ_Ҧ#GFOij	ѳCVwyհ	MH9nWv J$\OyE]I.n@a)ACD3|(~zгK$iMqj&͙^*) Tc:q<7&CI3GsyM.L@e|Ä 
bK"#Ѣq=bSgypn#LjT9A*Xk'A gz
e_Z&^Ĕ3^RX(l7[\ dUQGz_2
ob"h{|zrVh%µ0bٮ:\/nk0RRv=ё$)RF+"ODiO{7b]32$&KRbTtlJ5ѽ,z	C,}qǪΛ-2Wj4&Qkݽ@7kRLҭ]wd^4'hLvx-vYo>e Pxv6-[83vgW]m]t	3X`PJ@,vd:E*RGaZ]RՁZ'Ժ-'ҳ>0P5?3t?sÎ;k	~lsx<oƂ\.LѨe3k)S׼AĎt7%|SiM44ջ
/=vצ\<ϦVQߛSaOS9hu,E]'Z°Ә\[c=ؔgrH #_} <fujoTsnfS#.R7{ڨ<͈y޽&5.xFU;5d:#IØ6rvoVR*ehuEŗ7C[>xjΛ*'fdU*Bi,Up{Qpr E^GYz'q;BtzoIsd՚omf!OV$J	]7ӵL}AQ`[Uum	qaS(VlZUTʏGSٕi]IR֦Us	XqsDJh!T+f_XmhlxO>
&vCi|"5L<nX&Yv=odWK[1Ŵ|Z6
R;bu9u,`U#YD}ځ7 Q;shoN
' ;Q(&X$xq*л'ĴtUͥΣ_@8Fuc̔>o|NWQSB\|_/ϴSHn9tU?#-!LEncEP޾EiEt[ 0aP ,)|P_7)y7Y]]t!\$v"\ifM_>&./nP&4$'&OeDvbj=788%.Eg<OhO3VYc5)n<磷&L<
 *{^<B)t*ENaeB\SΚ5JRZ
v/t2+96P)1}[=Si8*Kt[d
3=M&Y'hCT4khgR0"
>̚f d%.%v2Ut
Pb%@biEN܄1Qy*;"{V;f:/w[3ܓB={t4a:4c	OɧDTMF	m$FJgqh ]3c_擫]bu<uT3=m0<1fȴѐFoܭ>Q-S;$Y6VL^uP'ޙ1ra`$7:v}~p³ţ{V~:O09X!)-JIy4Y{736F.kQ՗3t䵽D*:H	@HPqHBF4Ԥ!].Qmkep-u-ܐwnG`D<Z4-$NԣQ_fɴ,+ڤJy6_
D^c[,fI{{ivDf_N>J/PL&ZG/v˛sȟ:b2I}#!FR'7u!~hJ*Psr!RC!7R	y([4XV`i-o I5A)됑pAN}lC
zpQßAE!
EC7Nn)#T{ 
ۢR[:bPo
́tuG<O:>MNр{A'TqlJ~Z)S{ H<j3UNgo}8HΩLf_.G|l#J5˸tY%v>hv9-^ƪ=~& 6FRѳl{2)`w,[u{u2؜z䫲yͶr/a%] u Xea&G?ɮ ,c.1|eSwhlL0אW'*t94QC=el RJ7I~R	/p/:>
WZa2Fg1W!^QK/`a1W3Qs^y	o!|ދIE1g3Iؒ=coshr6dNO`^5wc9xѮ1a+;s"lWl>.r`p
򬓗҈|brT>޻6~*`J]gE@ix1t}M'7N_{^ tٵYbB$9.
=b#[d$PAݑGV1*WEt(k4qŭ:CzW=q)!xurhv!j[V$)E>0yGO6t'r?;HU43	?@rV-0SkE%\$h&5hķӘlx(^p!OO-BҔ k!$\*H'$<:w9&_nX$`r
Ǚ@mk!.aߺ7ܨǣMLKYhl]4~XGၜ
nwA@L7w8`GKz8W5rw	-x➉~
؆R*,<oC"J	4k>jY+6V'b>\WLO+1hPQRw<s)kfl|L~V|O$JU5׻ ,+-7F=>LyU)Zu,Sͥݤ6=}t]}Ud#
s\7y`eƠl鴎Yu:{+I/_60aoR*o{B~ThϾ\՚lSn{#:ĔRؙX|r`g!I2eѝHz剗xOCr9hc3vBץNpV\Ӑb^[u
GV:s[W
+*tAIԫ	ٜۧy24V|WQMI 'K''jL/[)Z#T6>f
\GʜV6"QL{hM9@v:Ғr?<Rd4LTb!pVP`#i.ԝJhmZn#cJaa&*B~7`hor_NhFv;r!vXڨ\-lA"0HHv\M
M_GxO}g(WU<2>*&^l[xkS@ېYZ\\(ȴo)OsrBJw4)zRZ((NEibQ]JɡhxIF}ʧ";	`p
nFIP%a=짮[ز>m "SP.,yXޜq`Х~P/^{!                                                                                                                                                                                                                                                   i                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           Q
#JF c. .4G  .cJT
J .JtFS BAV
J  sF C [G @Zk , , C4GHG
HDD @A  d [ @ZkG ] ] }  ( 0 ݤ8 @ H P #kG#p "  ~ ^TG  ^ ^  ~( 0 8 ޴@ H P  0,G .G .G0H /U
JJ5DA ?@CX
K  aGFG [ CG @ZkGGGb#@ C  Gq G . #  #.4GJQ
!JF C   c. .GhcJT
JtFR _BC  r [ @ZkG GGGb#j@ C   GP  G. " '.0Hs0HRPJQ0JTF3F G> '>G  !/G A/!KZ
AK@:G  B CDZk  .H .rH '.JW
J .Q'JF CV@PJ  6/ -3FF '> >6K  .H
ID .TJ(GzIIUJF  BF >G  >G ]rDZk  . .JV
J F  C@@H ,hH   /DHY KD(G <   ? G ]  "G ] ]  }( 0 8 ݤ@ H P ` #k# p"  ~ ^TG ^ ~  ( 0 ޴8 @ H  0,G P.G .G0H .R
PJJ2DA ?@CU
J  aGF C [GG @Zk  .G #.JQ
#JF CP@  p. .pJT
JtF Cb  . " . # &/G F/JW
J8KZ
XKF:GU B CA  ,TG 8.  uHQ
8J [D C @Zk	    . &.GJQ
&JF C>    c. .  .cJ .T
JJtF CE@W
J E/  %/FJZEK{JY%K@G;G E?  %?   . &. g.JQ
&J  -SgJF'Ht'HHIvFE g>  = " F.G ,b#WJ@
H@F C@ , , C4GHG
HDC @C  c [ @ZkG ] ] }  ( 0 ݤ8 @ H P #k#(  "  ~ ^TG ^ ^  ~( 0 8 ޴@ G 0,G p.G .G0H .S
pJJ3DA ?@CV
J  aGF C [ @Zk  . #.  ¤JQ
#JF C@@  `. .`JT
JtF C# G . " . # %/ E/JW
J8KZ
XKF:GU B C@  . 8.TG  uJQ
8J [F CG @Zk    . %.JQ
%JF C G G  tG ] ]  }( 0 8 ݤ@ P #k ]@ G  G# ^ ~  ( 0 ޴8 G  ~G ^G  0,G# P.0HR
PJG 2D  CG  G Q. 1  q.AJS
aJSF C@	   q. 1,GqJA
1HaF C?4 $ c.$ C"' .rJV
JTJF51BJSrJuJFuF' >$ c>    , @.D# . HR
@J  .2D#HUJv#HTJF# >F  >K G Q. G 1, .QJ p.A
1HTJAF0Hu0HSpJF >uF p>9 G #,4G .`#HP
J0DA ?@@G  a [ @Zk C  G' G .4G #.JQ
#JFA ?@@G  a [ @Zk  C   G  , `  @,HaHEHBCHDAD < @<H D `.tH  @.S`JR@JuF `>TF  @>G ] ] }  ( 0 ݤ8 @ #k#$    ~4G ^ ^ ~  ( 0 $ 0,G' P.GG   HR
@JG 2D  C XD   0. 0,  ,0JA
0HH!FA ?@ $.@  aQ
$J [D C @Zk #, .4G#HP
J 0D@ @ @ C  ` [ @Zk)   ,H# ,vH $.$ #H .@
HQ$J DHrHPJ3F $>F ># .  .UJTJF# >F  >D$ #/' C/8KE
XKZXKeG0`CxKY8K{xKEG;G' C?$ #?G ] ] }  ( 0 @ #k#    ~G ^  0,G P. HR
@J 2D  CF   @. .@JT
JTF C2B
 @  .G @.JR
@J F  C5 G `  @. . 0" .@JT
J p.UJTFQJvQJSqJFvF > p>   .  / .JX
 K  S.UJF3Hv3HRSJFVF >  S>G( /+ 0/KA
0KY0KAG:1@CPKXKzPK!G+ 0?G( ? ]   #k p.4G .@pJU
JuFP BC  p!B [ @ZkG ]  C   #kG0B   0, P. HR
@J 2D  C  . .JU
J F   Gk0B 0, P.0HR
PJ 2D   GkG  0, " p.?# .0HS
pJ .J 3D  CG   V
JF
  P B@ BB
 `BB  w `B    G      kG  Ѳ  Ҳ GkG   G  GkG . " /  rJX
KF  . /V BJX
KF CBBG"  `W CwB "aC0 Cײ G   . ;,JA
;HF C  . 0  p/B . 0/JJY
!K[
pKFF C  uA ?@BB?G     Gk    . .JV
JF  kG#G  ~G ^   ,G H    . "0 B3@JUJ  .2rBJ J5J p# B   P/0 B9@JZ[K  0,22CGK 0H:AK RCTGt~ZkG ]   #kGG  [GG CRZk 0 @GkG# "  ~ # ^G G  , ^ p. H 0/_F P/ uJD F8KZXK0Hx1`J:GT F;vHaS K aGt C~Zk ^   #kG# B  ~G ^G G   ,  H  G  `. " 0 @  #SuJ  .gJ J3aJ B	    / 0 @XK  @/K8K @K B_  T( t]~ZkG ]   #k 0,  
 P. q" .
 . HR
@JJU
J2DF C C3D  4Gk3D  4Gk  .  / J KFCkGG [GG C C}ZkGk    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G  ~ {#G@G ] D   #kG#4G ^G  ~ {#G%@G ] D   #kG#4G ^G ^  ~( G  ~G@b#G >@ DG   =pb#GTG@ DG ] ]  }( 0 #k#4G ^G ^  ~( G  ~G`b#G >@ DG   =b#GTG@ DG ] ]  }( 0 #k#4G ^G ^  ~( G  ~Gb#G >@ DG   = b#GTG@ DG ] ]  }( 0 #k#4G ^G ^  ~( G  ~G b#G >T@ DG
   =0b#GTG@ DG  b#G4G@ DG ] ]  }( 0 #k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G  ~ {#G	@G ] D   #kG#4G ^G  ~ {#G=
@G ] D   #kG# G ^  ~( G  ~GG > ^   GGGb#4G@ D  G =G(b#TG@ DG ] ]  }( 0 #kG#4G ^G ^  ~( G  ~Gb#G >@ DG   =Xb#GTG@ DG ] ]  }( 0 #k#4G ^G ^  ~( G  ~Gb#G >p@ DG   =Hb#GTGR	@ DG ] ]  }( 0 #k# G ^  ~( G  ~GG > ^   GGGb#4G'@ D  G =Gb#TGw@ D  Gb#G4G@ DG ] ]  }( 0 #k#4G ^G  ~ {#Gs@G ] D   #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G ^ G  ~G0{#Gt_     G&   G .0J  p.u0JGTJSpJFuF >  p>   W/ # 7/8J{8JZXKY8K@G;G W? 7?G  " G a.!J A.t!JSaJRAJuF a>TF A>G ] ]   #k#4G ^G ^ ~  G  ~GP{#GG6_  G G ".H B.uH ""JR
BJH2F C;   .  b.zHqHTJSbJFuF >  b>H_D "/ " /Y7KXK;G "?G ?_D B.vH ",yvHRBJA"HSF1D B> "<G  / .XKWJG  ?F > b/ ",bKA
"HaG C"J .  b.u"JGTJSbJFuF >  b>z   .H /{HHJX
KtHF C?  Q/  1/ZQKY1KAG;G Q?  1?    b.aH B.yaHSbJRBJuF b>TF B> .G  .VJQ!JF9F >  > "" b/ B.bKR
BJrG CrJ .  .xrJWJUJF >F  > ", b, "/"HC
bH .Y1K#DqHzqHVJ;GF "?G >1 G .J  `.uJHTJS`JFuF >  `>uH ", "."HQ
"J1D CH A/  !/{HZAKY!KRG A?;G  !? . @" b.rHzrHTJSbJFuF > b>G  / .Y2KVJ;G  ?F >G ] ] G }  0 #k#4G ^G ^ ~  G  ~Gp{#GG\_  G G ".H B.uHH"JR
BJ{H2F CA   . b. B"TJSbJF >uF b>_D B/bJ  "/ /HZBKY"KAG B?;G  "?_D b.X
K ".FSrJtHQ2J CuF4F b> "> " 7,vH /yvHGA6HXK:DG 7< ?G b/ ,bK@
H `G  C J .  `.u JTJS`JF >uF  `> G  .H .zHJW
JF CF6  "/  /Y"KXK;G "?G  ?_D B.KHzHR
BJ2D C!J .  .w!JUJTJF >F  > "/G /Y"KXK;GG "? ?K_D b.S
bJSF C " .tH .wtHVJUJF >F >d G  1/ b# Q/HaH1KZ
QK:G C	   b. B.S{JR[JtF b>AF B>_D . .  ,J   .V
JA HF CQ J  / 5/KY
5KGJrJ3D  <2F   > .  # b/G D  .J[
bK  ,F C " .Q9J /A9HJX
KFJrJ3F2D  >  < . B/JZ
BKF CH .xH  .WJVJFF >  >G ". B."JR
BJ2F C b" "/ .sH                                                                                                                                                                                                                                                   j                        / $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ^ "           zsHY3KTJ GF "? >G ] G ] }  0 #kG  0, G 0. p.0H P.Q
0JSpJ1D0Ht0HRPJuF p>TF P>kG 0,   0. . H p.Q
 JTJ 1DHuHSpJF >uF p> Gk 0, G 0.0HQ
0J1D C  kG  A. G a.AJS
aJSF C  kG p.0H P.t0H GSpJRPJuFTF p> P>k 0, G P.0HR
PJ2D C  kG . a" . GJU
JF  1kG# G  ~ ^ ^ ~  G 0,G 0.G0HQ
0J1D C     c.4G .GcJ b#T
JtF CFM   . .JW
JF C& GB_ #. G  .HrHQ#JPJ3FF #>  > GD . " .HVJwHUJF >F >D C/H #/{HZCKY#KPG;G C? #?  c.J C.tJG4GScJ b#RCJuFTF c> C>_ #, G . c.#H  C.P
JScJ0D#Ht#HRCJuF c>TF  C> G . " /GGJX
KF CF7 2_ . /JX
KF C  W/ ,WK@
H@G C0G  GF_ Gy GG4G b#ڛ_ #, C" .G . G#H c.P
JTJ0D C2Hu2HSrJFuF > c>!J !/z!J  /Y!KXK;GG !?  ?V   A. a. .AJS
aJ  !.WJSF CQ!J  . p" .JV
JFJxJF >8F  !> c/ ## C. .cK ,R
CJJrG C@
H . 2. F 2 HUJwHQ!JF7F > 2> #  c/ G c.yKS
yJsG CpF ` . . C.J #.V
JRAJF CJuJQ!JWF5F C> #>H t/sH  4/[tKY4KvG3G t?  4?4GG b#g_ GG ] ] }  0 #kG#  ~ ^  0,G 0.0HQ
0J 1D    G  #kGG4G`{#J_G ]  G  #k#4G ^G ^ G  ~G{#Gؚ_     G&   G .0J  p.u0JGTJSpJFuF >  p>   W/ # 7/8J{8JZXKY8K@G;G W? 7?G  " G a.!J A.t!JSaJRAJuF a>TF A>G ] ]   #k#4G ^G ^ ~  G  ~G0{#GG_  GG ".H B.uHH"JR
BJ{H2F CQ   . b. B"TJSbJF >uF b>_D B/bJ  "/ /HZBKY"KAG B?;G  "?_D b.X
K ".FSrJtHQ2J CuF4F b> ">wH 7,ywH /GA7HXK:D 7<G ? b/ ,bK@
H `G  C J .  `.u JGTJS`JFuF >  `>G b, .bHV
JvD C " "/ /7Jz7JY7KXK;GG "? ?   q.H .aH @#qJT
JtF CN ` .  .VJUJF >F  > /H "/uH .KY
"K `/TJGKsK[zKFsG > `?`H B.x`H ".RBJQ"JVF5F B> ">G . `.TJS`JF >xF `> b/ b" ".bKQ
"JqG CQJ .yQJ  .WJVJFF >  > ", b, /"H .C
bHXK#DsHzsHTJG ?F >G^  .`J  @.v`J "UJR@JFVF >  @> "/ ",G D @/"KA
"H  /!G4HZTK{4HXKQG @?G  ? B.H b.xHBJS
bJSF CH .  .yHWJVJF >F  > . ".TJQ"JF >8F ">_D b."JS
bJsG C  S. .SJU
JUF C " !/ .HqHY6KWJ4GF !? >G / B/KZ
BKG CbH b. B.ubHSbJRBJ`F b>UF B>G ] ] G }  0 #k#4G ^G ^ ~  G  ~G`{#GGn_  GG ".H B.uHH"JR
BJ{H2F CQ   . b. B"TJSbJF >uF b>_D B/bJ  "/ /HZBKY"KAG B?;G  "?_D b.X
K ".FSrJtHQ2J CuF4F b> ">wH 7,ywH /GA7HXK:D 7<G ? b/ ,bK@
H `G  C J .  `.u JGTJS`JFuF >  `>G b, .bHV
JvD C " "/ /7Jz7JY7KXK;GG "? ?   B. " b.HaHBJS
bJSF CQFI @ . .VJUJFF > >H /vH "/ `.K  `/Y
"KS`JG Kr K[`KaF `>rG  `? .G . @"2HUJTJFF > >z2H  /G `.XKSrJGzF  ? `> . . .J  .U
JWJF CJqJVJFF >  >tH t.xtH T.StJRTJzFXF t> T>a  . J  .w J @#VJUJFF >  > ", B.G D ."HR
BJ  .2D C a" .UJ /Q:JJX
Ks`HF:Hv:HF >6F  > D @.`H  /HR@JY KTF3G @>  ? / ",KA
"HG C !" . .JV
JF CH a,  A/rHCaHZAKsD a<RG  A? .sH "/GJY
"KF C t# 4. /HuHQ;JXK6FG 4> ? B. b,RBJCbHWFsD B> b<G ] G ] }  0 #kG  0, G 0. p.0H P.Q
0JSpJ1D0Ht0HRPJuF p>TF P>kG 0,   0. . H p.Q
 JTJ 1DHuHSpJF >uF p> Gk 0, G 0.0HQ
0J1D C  kG  a. G .aJT
JtF C  kG .0H .x0H GWJVJFF > >k 0, G 0.0HQ
0J1D C A" a. .rJT
JtF C  k .0H .x0H GWJVJFF > >k 0, G P.0HR
PJ2D C  kG . G .JU
JF  1k# G  ~ ^ ^ ~  G 0,G 0.G0HQ
0J1D C     c.4G .GcJ@b#T
JtF CF[   . .JW
JF C( G_ C.G  #.#Hs#HRCJQ#JTF3F C>  #>GD . " .5HWJx5HVJF >F >D c/#H C/q#H[cKZCKrGQG c? G C? G .J .wJG4GUJ@b#TJFF > >_ #,G . G .#HP
J  c.TJ0D C#Hu#HScJF >uF  c> !/ " /7Jz7JY7KXK;GG !? ?  C. " c. "GPJS
pJSF CFA   . . .J #.V
JWJFJxJQ#JF >8F #>D C.#J4GR
CJrG C@b#  . .JU
JF C_ #, .G C##HP
J G0D C!J .  a.u!JTJSaJF >uF  a> / #/ .KY
#K c/PJGJaJ[zKFaG > c?D   a. " . /aJ .T
JXKtFCJyCJVJ G ?F >D #.J A/ a/4GQ
#JWKF C[
wK , .[G p"GJ@b#@HrJTJ DF < >GO_ , #,HA
#H D  C  "  .G @. G0JR
PJ2F CpJ .  .wpJVJUJF >F  >G ] ] }  0 #kG#  ~ ^  0,G 0.0HQ
0J 1D    G  #kGG4Gp{#_G ]  G  #k#Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k# C ^G  ~ TG( G{G ^TG[  ~{ C EZk	  "B4Gb(@G{Zk G/  =4G    c!7!H C!!Ha@0LGv$H7 @  `4!H5uB
B =B G@B  ò0AJBB B #$  $ C$ 1"	B@!BBAB @0@B  òABa@!BB G  G ] ]  }( 0 #k# C ^G  ~ G( Gx{G ^TG( [c   ~ C0 { EZk  H "4G8 B@ bGh{Zk G-  =4G  c!7!Ha@ C!!HGv H7 @  @3!H4u`B
B `=B G B   !JBB B  c# # "	@aCBB!B @0 B  !Ba@BB G  G ] ]  }( 0 #k# ^ ~  ( GG  ~{# ^    P_*    $G  #  !  $  # .  .QJvQJUJTJFF >  >G   x/ X/ 8#YJ[yK`YJZYKbG x?@G X?  G G 0. ,PJsPJQ0JDH4FD 0> <G ] ] }  ( 0 #kG# ^ ~  ( 0 G  ~G ^G {#  ]_    %  !#Hw#H  %#H c.b#H . #"cJT
JtF C? ` . .VJUJFF > >JD ,1H  c/ C/u1H@H[cK D <bG  c?D c.Z
CK .:GSqJTJ CvF c>F > Y/ " /H`HZWKXKBG G Y? ?G , G c/H[
cKD C#H .u#H  c.TJScJFuF >  c>z   .3H /e3H#HJX
Kt#HF C?  S/  3/ "ZSKY3K[G S?%G  3? #.H ,sH  Q#J@H5F D #> < G , A,EHBWHD <SD A< C/ c/CK[
cK[G CH .  .vH GUJTJFF >  > #, C, c.#H ,B
CHSdJ"D$Hw$HEHyF c>D <1 G !.J  a/tJQ!J[aK5F !>tG  a? .#H /q#H a#JX
KF C6H ,e6H  V,@HBVH DED <  V<H .eH #/ GPJY#KF >1G #? A, /B[HXKSD A<G ?G ] ] }  ( 0 @ #kG# ^ ~  ( 0 G(  ~G ^G {#  y_    %  !#Hw#H  %#H c.{#H . #"cJT
JtF C? ` .  .VJUJFF >  >1H C/u1HD #/ZCKG@G C?Y#K;G #?#KD , c. .E
HSqJEDTJ CvFF c> > " ,H /yH@HXK D <G ? c/ G ,cKE
HeG C#H .u#H  c.TJScJFuF >  c>   C,#H .z#HCHW
JWD CSD6 @ #/  /Y#KXK%G #?G  ?D ,K#Hx#H@
H `G  C`J .  .v`JUJTJF >F  > , G C,EHBCHDXD < C<CHD c/[
cK[G C #" .H .vHUJTJF >F >d G  , ## /9H`9HHX
KD C	 @ c/ C/[yKZYKqG c?@G C?D . . /J  a.U
JXKF CSaJ  . ,JE
H "FHbH GbF ?  a> #. #/G?D .                                                                                                                                                                                                                                                   k                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        = "           #JY
#K .9F C Q# q/WJ .VJzKU
JuG4J`4JFF > > , .HP
JD C%H %/u%H  /Y%KXK:GG %?  ? c/ ,cK@
H`G C C  .H #.vH GTJQ"JF6F > #>G ] ] }  ( 0 @ #k  0, G 0. p.0H P.Q
0JSpJ1D0Ht0HRPJuF p>TF P>kG 0, 0.0HQ
0J 1D  CkG P.0J 0,s0J GRPJA0HTF3D P> 0<k 0,   0. . H p.Q
 JTJ 1DHuHSpJF >uF p> Gk 0, G 0.0HQ
0J1D C  kG  A. G a.AJS
aJSF C  kG p.0H P.t0H GSpJRPJuFTF p> P>k 0, G P.0HR
PJ2D C  kG . a" . GJU
JF  1kG#G  ~ G ^  0,G 0.0HQ
0J1D C     #kG  v. G .;vJT
JY9#tF CaF`   .G /JX
KF C.   AJ .wJ 6.JQ
6JF   6" /G  .XKUJGF ?  >JF 6/uJ .Y1KPJ7G 6?F >F V/J /pJZVKXKQGG V? ? ]   #kG 6/J .`J;Y6KUJ0GF 6? >1"    / V/KZ
VKG   ,G . .H  .P
JWJDJyJUJF >F  > ] G   #kG V/ " 6.GGTKQ
4JQG C!FK  
_ 6/ V/6KZ
VK:G C  9, .9HP
J0D CG
  G2_G ] G   #kG;  Y9#  AG . 6.JQ
6JF C  p. .pJT
JtF   .G / 6.J V/X
KQ JF CJrJZ@K3FRG 6> V?5H 5/w5H  . GY5KPJ8G 5?F  > ]   #k  A. a. .AJS
aJ  .UJSF CTJ  , .HP
J DHwHFF >  >   v. . 2,vJP
J 2. HpF CQ
 J . " . 1DHWJxHUJF >F > 6. 6  , "G!J@
H  F  C D   . v. /J .S
vJXKF CJaJWJGF ? >J 0/aJ  p.Y0KSpJ1GaF 0?  p> Gբ"  Ҳ  UG ]   #k 0, G 0.0HQ
0J1D  k [ G  r  p  k#@ ?B ^TGG ^ ~  G  ~G{Gq @4GTB     G5 ðC2  GG  b6AJG0AJvBJ 3/zJ  /GGY3KXK;GG 3?  ?0 B  #B @ @" `.J .wJGSrJVJxFF `> >B  "5J5CJ ,sJ .@HPJ DF < >_ GG ] ] }  0 #kQ ?Bq1B1!J BkG#G ^TGG ^ GG  ~{4GB     G' G  G .0J  p.u0JGTJSpJFuF >  p>   W/ # 7/8J{8JZXKY8K@G;G W? 7?G  " G a.!J A.t!JSaJRAJuF a>TF A>G ] ]   #k#TG ^G ^ ~  G  ~GG{4GGB  G ".H B.uH ""JR
BJH2F CM   .  b.zHqHTJSbJFuF >  b>H_D "/ /Y7KXK;GG "? ?`H_D B.y`H ",RBJA"HSF B>1D "<  /G .X KWJGF  ? > b/ ",bKA
"HaG C!J .u!J  a.GTJSaJF >uF  a> b,G .bHV
JvD C " "/7J /z7JY7KXK;G "?G ? G  q.H .aH @#qJT
JtF CN ` .  .VJUJF >F  > /H "/uH .KY
"K `/TJGKsK[zKFsG > `?`H B.x`H ".RBJQ"JVF5F B> ">G . `.TJS`JF >xF `> b/ b" ".bKQ
"JqG CQJ .yQJ  .WJVJFF >  > ", b, /"H .C
bHXK#DsHzsHTJG ?F >G^  .`J  @.v`J "UJR@JFVF >  @> "/ ",G D @/"KA
"H  /!G4HZTK{4HXKQG @?G  ? B.H b.xHBJS
bJSF CH .  .yHWJVJF >F  > . ".TJQ"JF >8F ">_D b."JS
bJsG C  S. .SJU
JUF C " !/ .HqHY6KWJ4GF !? >G / B/KZ
BKG CbH b. B.ubHSbJRBJ`F b>UF B>G ] ] G }  0 #k#TG ^G ^ ~  G  ~GG( {4GGB  G ".H B.uHH"JR
BJyH2F CQ   .  b. B"TJSbJF >uF  b> /H_D .XKtHG ?WJF >J_D ", b. ".A
"HSrJaGQ2J CuF4F b> ">aH /yaH .GXKWJG ?F > b/ ,bK@
H `G  C J .  `.u JGTJS`JFuF >  `>G b, .bHV
JvD C " "/ /7Jz7JY7KXK;GG "? ?   B. " b.HaHBJS
bJSF CQFI @ . .VJUJFF > >H /vH "/ `.K  `/Y
"KS`JG Kr K[`KaF `>rG  `? .G . @"2HUJTJFF > >z2H  /G `.XKSrJGzF  ? `> . . .J  .U
JWJF CJqJVJFF >  >tH t.xtH T.StJRTJzFXF t> T>`  . J  .w JVJUJF >F  > ",`H B.u`H  . ""H D @/R
BJQ J2D CZ@K .6F / a"UG  > @?J D @.X
K  /F7HRWJs7HY7KTF3G @>  ?H / b,KC
bHG C #" . .JV
JF CH #,rH  c/A#H[cK3DrG #<  c?sH .G .JW
JF C 4# 4.H /uHQ9JXK6F 4>G ? B. b,RBJCbHZF B>sD b<G ] ] G }  0 #k  0, G 0. p.0H P.Q
0JSpJ1D0Ht0HRPJuF p>TF P>kG 0,   0. . H p.Q
 JTJ 1DHuHSpJF >uF p> Gk 0, G 0.0HQ
0J1D C  kG  a. G .aJT
JtF C  kG .0H .x0H GWJVJFF > >k 0, G 0.0HQ
0J1D C A" a. .rJT
JtF C  k .0H .x0H GWJVJFF > >k 0, G P.0HR
PJ2D C  kG . G .JU
JF  1k# G  ~ ^ ^ ~  G 0,G 0.G0HQ
0J1D C    c.4G .GcJbT
JtF CF[   . .JW
JF C( GB C.G  #.#Hs#HRCJQ#JTF3F C>  #>GD . " .5HWJx5HVJF >F >D c/#H C/q#H[cKZCKrGQG c? G C? G .J .wJG4GUJbTJFF > >
B #,G . G .#HP
J  c.TJ0D C#Hu#HScJF >uF  c> !/ " /7Jz7JY7KXK;GG !? ?  C. " c. "GPJS
pJSF CFS   . . .J #.V
JWJFJxJQ#JF >8F #>D C.#J4GR
CJrG Cb  . .JU
JF C
B #, .G#HP
J0D C!J .  a.u!JGTJSaJFuF >  a> " / #/KY
#KG C8J ,  x/p8J@H[xK D <pG  x? C. G c. .CJ .S
cJVJSFTJyTJUJF >F >E G  !. " / c.!J c/X
KGScJ8FJwJ[cK`FwG c> c?cKD . . !/T
JbJTF CY
5K , 2" /FJ@HpJXK D <G ?G4G=
B , #,HA
#H D  C  "  .G @. G0JR
PJ2F CpJ .  .wpJVJUJF >F  >G ] ] }  0 #kG#  ~ ^  0,G 0.0HQ
0J 1D    G  #kGG4G( {
BG ]  G  #kp B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G  ~  {#GW_G ] D   #kG#4G ^G  ~  {#G_G ] D   #kG#4G ^G ^  ~( G  ~GXb#G >d_DG   =b#GTGP_G ] ] D  }( 0 #k#4G ^G ^  ~( G  ~Gb#G >F_DG   =b#GTG_DG  b#G4G_G ] D ]  }( 0 #k    #  ~ ^ ^  ~( 0 GG        C4GGb#_DGk    "4G4GtGGb#5_  C  "      GG b#_Gx b @GDT  G b @GDN    C  =( Q.+ q.QJS
qJSF C     " .  .JxJWJVJFF >  >  BZ c# ;,  ,[Kp[KA;H@H1D D ;<  <  BR . .CJvCJUJTJFF > >   $ ## 9,  ,KpKA9H@H1D D 9<  <d@4GG b#_DG  GG b#R_ 4Gp b @G DG ] ]  }( 0 @ #k#  ~ ^ G    =TGG{#_G ]   #k#  ~ ^ G `   =TGG{#_G ]   #k#  ~ ^ ^  G#G0   4GGxb#N_0   C4G  >?"GGG"GGPb#t_ 0  4GG b#y_ ] _DG ] ]  0 #k#  ~ ^ ^  G#G   4GG(b##_   C4G  >?"TGTGGtGGG b#I_   4GGb#N_ ] _DG ] ]  0 #k#  ~ ^ ^ GG   4GG(b#پ_  4GGb#a_ GG ] ]   #k#GG    C  ( ,+ 0,HA
0H D  ~ 3   . !.JQ
!JF  ^ 2. r.2JS
rJ3F  > !"  Q. q.QJS
qJSF      P.# p.PJS
pJSF   >$ !"  Q. q.QJS
qJSF   GG  #k#  ~  ^( ^0 GG h   4GGb#_   h" 4GGb#_h                                                                                                                                                                                                                                                   l                        - $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "              =  CTGG@b#_T   =  0 B   = Q"  r. .rJT
JtF21@B " .  .UJxUJWJVJFF >  > ] z#  , ;,HA
;H D  C,   } "  . 4.JQ4JF J ] R"  . JTGGx*b#E@h  4GG b#_  F
    "  1" C ]_F C  b( s" CtGGp b^  Cb#_ h  4GG b#_  h"  4GG8b#v_ GG  ]( ]0 @ #k#  ~8 ^@ ^H GG  4GGb#H_   =  CTGGb#_   = "  0. P.0JR
PJ2F C }" CTGG@b#C_      . !.JQ
!J F  CP   8 D   ] r"  . .JTJF J  "  . J ]  8#  Y/ y/YK[
yK[G CGG0 bI@  F   = Q"  . r.JSrJF J  "  . JTGG)b#EE@GGXb#8@  4GGb#[_  F  "@ 1" C ]_F Cbx s" C4GGGbQ^  Cb#E_]       . !.JQ!JF J ] R"  r. rJTGX b@  F-   = Q"  . r.JSrJF J  "  . JTGG)b#E@  4GGb#_  F  "@ 1" C ]_F Cbx s" CTGGGb^  Cb#_ 0      . !.JQ
!J F  C @"  . r.JSrJF J0  "  . .JW
JF C "  / KTGP b@2 GG8 ]@ ]H P #k`#  ~ ^ ^ GG p =` ]P }@  0Jx p ]2AJh ]` X P =1!JH =pb  4GGb#0_X  p DX x 0v J Ch =?F C4GtG  b@  C0 0   p"  4GG@b#Y_ Gs 0 @ =TG( b@  C8 8   p"  4GG@b#H_ Gb 8 = "  0. P.0JR
PJ2F( =( @ " CTGGb#/_X J  X =P D  4G   x }3v`J Ch F C@ ] }GGbD @  F  p"  4GG@b#_ G2 H =!v H C =" CTGG b#M_   p"  4GG@b#_ G x =!v H Ch =?F C@ ] }H 4vJ CGb @ p  4GG@b#_  D p"  4GG@b#_ GG ] ]  #kp#  ~x ^ ^ GGp ` =P ]H }@ p 0Jh ` ]2AJX ]@ 4J8 h =1v J CX ]_F C4GtGbk@  C    P =TG  b@  C( (    GP 4G( bN@  C     G = q. .qJT
JtF Cn  H > H ݢ8Fi  4G w/ W/KaK[wKZWKpGAG w? W? 4G `" 3.  .SJuSJQ3JTJ6FF 3>  > =h  "qF  8pFzJY;K:GW`C  8@ X = @"  r.t2JS rJtF  r>( 4G . .JxJWJPJFF > > G ]TG z. Z.zKtzKSzJRZJaFTF z> Z> h  "qF   pFyJX KGW @  t  =X = A"  r.t2JS rJtF  r>( ]TG . .zKvzKUJPJFF > > GR  8, 8.8HQ
8J1D CX DV  H ]> @H }8`FQ `  "  . .JVJFJh 7vJF  ] Z#  z/ zKX  D @G   =4G Q. 1,KsKRQJA1HPF3D Q> 1< 4G " w/  .JzJ[wKUJ`GF w?  >( =4G a. A.JxJSaJRAJyFXF a> A> G	  "  . .JWJFJh ]:v@KF  } {#  ;, ;HX F0D|   G  = q. /qJX
KxF C8 Fq  H =/  H 8Fl (  U/ .UKV
JVG C8F  G  } "  0, P.0HR
PJ2D0 @ {" 3.  /3Hy3HQ3JXK4FG 3>  ?( ݢ4G , .JpJ@HUJ DF < > G  = !"  q. .qJT
JtF C! 6    8#  y/ .yKPJpG`Kh ]2v@JrG* @  "  . JX FF"  ] TG . z.HaHTJSzJFaF > z>( TG . X.8Kw8KVJRXJFWF > X>     !.  .Q!JPJ !>  > Gy 8 }3v`J C0 " CTGGb#_0    Gl Gb#_  C     Gc  =  ] .  .QJvQJUJTJFF >  >  = X# :,  z/:Kp:KA:H[zK DpG :<  z? =h ] q"q`F  p`FvWJUJFWB  P  X =  "  /y0HX KG  ? ]4G :" q.  Q.qKtqKSqJRQJuFTF q>  Q> ݢH     .   ,JxJP JA HF8D  >   < =0 ] q" .  .SJzSJUJTJFF >  >0   =TGGpb#v_  =?D    F  TGGx ] ]  #k 80 J?G:G 8^ 0JGG  0@JFF à#  ~H ^P ^X GG@ 0 =  ]@  H8 0 =1!J( =   4GG8b#r_8  v H C( =?D C  ]tG  b @   4GGb#_ ] _DGH ]P ]X ` #k#  ~@ ^H ^P GG8 ( = ]8  H0 ( =1!J  =0  v H C  =?F C4GtGxb+@  C   =TGbr@  C     G   =TG  b@b#_ GG@ ]H ]P ` #k#  ~( ^0 ^8 GG   =   H  =1!J =  4GGb#_  v H C =?D CTG  b
 @Ӡ   4GGpb#@_ GG( ]0 ]8 @ #k#  ~H ^P ^X GG@ 0 =@  H8 0 =1!J( =8 0v J C(  D C4GtG(b@  C     G&  =  1  =  } `    . .JW
JF    =TGb%@     C =" CTGGb#_x  =TGG@b#y_Әb#_ GGH ]P ]X ` #k#  ~H ^P ^X GG@ 0 =@  H8 0 =1!J( =@  4GGb#_8  v H C( =?D CTGb
 @@   4GGb#ʹ_ GGH ]P ]X ` #k#  ~H ^P ^X GG@ 0 =@  H8 0 =1!J( =8 0v J C(  D C4GtGbV@  C   =  1  =  }a `   "  . .JW
JF   = y/ ,yK@
H `G  CI  8 D   X DE  4G GGb#D4@    .  .Q JP J  >  > ] . .UJTJ > >0  ݢ "  / 7/KY
7KG71B V# ,  z/JaJ@H[zK DaG <  z? = Q"  r. .rJT
JtF C    , 5/@HY5K < 5?4G =GGb#4@    .  .Q JP J  >  >  ]  . .JU
JF  ]  @b#_ GGH ]P ]X ` #k#  ~P ^X ^` GGH 8 =( ]H  H@ 8 =1!J0 =   4GG8b#_@  v H C0 =?D C( ]tG  b @   4GGb#_ ] _DGP ]X ]` p #k#  ~P ^X ^` GGH 8 =( ]H  H@ 8 =1!J0 =@  v H C0 =?F C4GtGxb@  C  ( =TGb@  C       G`   = Q"  r. .rJT
JtF =    7/ W/7KZ
WK:G CJ 8F `XFF 4G =GG0b#3@    .  .Q JP J  >  > ] . .UJTJ > >1  ݢ  #  8/ X/8KZ
XK:G61B w# ;,  ,JpJA;H@H1D D ;<  < ] r"  . .JU
JF C @  , X/@HZXK < X?4G =GG0b#H3@    .  .Q JP J  >  > ] @b#_ GGP ]X ]` p #kp#  ~x ^ ^ GGp ` =P ]@ }p 0Jh ` ]2AJX ]P 0JH @ ]2AJ8 ]  4GGb#_h  v H CX =?D CH ]_F C8 }3v`J CG b @   4GGxb#G_ ] _DGx ] ]  #kP#  ~ ^ ^ GG x =h ]X } 0J x ]2AJp ]h 0J` X ]2AJP ]` P F  4G =   0v J Cp =?F CGtG8b @  C     G 0  ]  RH ]| P 4vJ C " CTGG8b#C_    G Gb#<_  C@ @    G 4G0 =@ }  .  .JxJWJVJFF >  >@ ]8 } :  ,  .aKqaK@HPJ DF <  >@ }  "qF  pFxJWJFW C  u  @ p =  "  0.r0HQ 0J2F  0>@ ] z# .  {.TJS{J >  {>@  ݢ " 7/  /J`JY7KXK!G G 7?  ?@  = P" .  r.2Jz2JTJSrJFzF >  r>  @ =TGGb#,_    F    = ?F7 H ]  . .JU
JFH ]H ' H  8#  Y/ y/YK[
yK[G8 8 ( =" CTGGb#w_Ӏ  v H Cp =?D C( ] }GXb#_    F =1v J Cp ]_F Chb#_[0  v H 8 D   TG  GG ] ]  #k 0JFF Ð#  ~X ^` ^h GGP @ =0 ]P  HH @ =1!J8 =0  H(  C =H  =v J` H F =8 ]   HrQ@J D h =" C    CtGGb#M_  F  ( =?F   G hB }" C " C  " CGGGb#_  =?D   G   GX ]` ]h p #k#  ~0 ^8 ^@ GG(   =(      =     "  0. 0,0JA
0H!F C ]" CTGGb#_  C  = C  B`Zk   ݢ  / 6/KY
6KG ݲ   GG0 ]8 ]@ P #k#  ~8 ^@ ^H ~P GG0 ( =0 ( =b#_  C     W GXb#_  C     GN  = . q.TJSqJ > q>0         w/  W/KaK[wKZWKpGAG w?  W? }( 4Gb: @  C C  .  ",HqHPJA"HF1D >  "< } "  . .JV
JF C ` G   #  8/ X/8KZ
XK:G C  7, W,7HB
WH"D0 @ 7.  .7Hr7HQ7JPJ4FF 7>  >0  ݢ  ղ G8 ]@ ]H }P ` #k#  ~0 ^8 ^@ GG(                                                                                                                                                                                                                                                    m                        h2 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        vR "            ( = ]" CtGG@b#s_    F    G8b#_  C     G    ( = " C " CGGGb#_    =?D   G  G0 ]8 ]@ P #k#  ~( ^0 ^8 GG   =  C =" CTGGb#_  =   . @. JR
@J 2F 1 @ .  .HvHUJTJFF >  >   X/ x/XK[
xK[G C    C =" CTGGb#_Ӱ  =TGGxb#l_G( ]0 ]8 @ #k#  ~H ^P ^X GG@ 8 =8      . !.JQ
!J F @   =" CTGGb#_     .  . JQ JF J   } s"  . J }8 ݢ / 6/KY
6KG CK 8F" @XFG GGb#k0@      . !.JQ!JF J ]2v@JF7   } s"  . J FuF/ ` ݢ 6/ /Y6KXK 6? ?' GGb#K0@      . !.JQ
!JF!1 @ @" .  r.2Hu2HTJSrJFuF >  r>  #  8/ X/8KZ
XK:G C  } , ;.@HQ;J < ;>@ 8 ] r"  . .JU
JF Cb#=_@    0 0 8 =F  8 ]  . .JU
JF( ]0  C0b#_@ ( =   ) 0   0 =  q. .qJT
JtF C8 5F  0 ݢ  / 6/KY
6KG0 ݲ0 }8    . @. JR
@J F .  .HqHUJTJFF >  >8  C0b#t_GH ]P ]X ` #k#  ~0 ^8 ^@ GGp   =  C ]" CtGGb#_p   =  C ]" C( }" C4GGGb#8_n  8 "  C4G  B( bfZk(  C =  CTGGb#_Ӏ   C =TG  B( bfZk ?"TGGb#d_ 0  " C =TG  B( bfZk(   .  . JQ
 J F  C(  8 D @ X D*  0 bP s" C(  "  5. .5JVJ6F J(  "  / KtG  B( bfZk 0      C( = !"  Q. q.QJS
qJSF CTG  B( bfZk `   C4G  B( bfZk0  C( =  A. a.AJS
aJSF CTG  B( b|fZk8   C4G  B( bvfZkG0 ]8 ]@ P #k #  ~^^GG@ @  H8   4GG(b#8_  =  C ]" CtGG b#_0 0 F  "  4GGb#d_<   =  C ]" CH }" C"GGb#_  '  ( ( =  ]	2B?( }`NCH  " CTGG@b#=_    .  . JQ JF J8 ]2v@JF	  8 }3v`J C  "  . Jhb#_(  0 @(   4GGb#'_G]] #k#  ~( ^0 ^8 GG   =   H  =1!J =  4GGb#̳_  v H C =?D CHb#_   4GGb#_G( ]0 ]8 @ #k#4G ^  ~( 0 G{ ^GG c   ~ b# Ce_DT G & b# "tG4GtG_  C C  ` "GG #b#tGG3@GG0b#R_Өb#h @D =8   c( !.+ A.!JR
AJ2F CaJ .xaJ .J`JWJVJFF > > !" a/!@?D A/[aKcdG a?ZAK0b#qH@G A?vqH a.4G A.GSqJRQJwF a>VF A>_ D  Gpb#G_ b#x @ GG ] D ]  }( 0 @ #k#G ^GTG  ~   G@{#Ђ_G ]   #kG#G ^GTG  ~   G{#z_G ]   #kG#4G ^ ~  ( G{ ^GG  ~ #b# c _G a@b#tG  >G?"GGG"G:_GG  4GXb#@_G ] G ] }  ( 0 #kG#4G ^ ~  G{G ^G  ~ b# c ǲ_G4Gȹb#P_G ] ] G }  0 #k C( 0,+ 0.0HQ
0J 1D  C ; @"  ,  .2HP
J0D  1    `. .  . .`JT
JJU
JtF qF  . . 1 JU
J F  Gk#4G ^  ~( 0 G ^GGG  ~ b#  _G4GHb#  G_G CGxb#TG_R    #0 B  # ] . r"
 .JW
JUJF61BJTJvJFF
 > >  X/ 8#
 x/YK[
yK[G CG/    . X.TG 8.JRXJ b# #F 8J9@ 4GGXb#  .     .JQ
!J F  C @" `. rJS rJ4BtJtF `>_ D	  "G CbtGH !  C%@^ pb#G_G4G8b#_ӦG4G  pb#_G ] G ]  }( 0 @ #k#4G ^ ~  G0{G ^G  ~ b# c '_b#
 @G  4Gb#`_G ] ] G }  0 #k#4G ^  ~( Gp{G ^G  ~ b# c /_G C  b#GTG_=  G =TGG#b# !. " A.0JR
PJ2F C p" . JJ   . / .JXK ! F JY9@ b#G_G  4Gb#p_ D  "  Gx b C C&@tGn^ GG4G  b#+_  GC  Gb#TGC_G ] ] G  }( 0 #k# gJH ^P ~X ` h ޴p x G  ~G@ ^#G8 < G%J&!J   GG0 B C\Zk@   G G4GGdQHXb# _G  b# CGGtG_c   =GtG0b#pC!?H4GD4 @ =TG  ^TGGtGG_	  G  Gb#4G_ G G =fQH%vH  "G!?H8b#0JD%D = .4 B .CC }JV
JCFGG CGTGGi_  GG  4Gb#_ G G  0  8b# C CGGGU_  GG  4Gb#x_ G GGb#-@}  G  Gb#4Gk_ G G0 }4GGb#  #, .#HPJ0D  ?D  [_ Gz q`D4 @  Qp`Ds4HRTJSFWB  Q{ `0  ݦ "wQH  5/ U/ #6J8KZXK;vH:GGJ G =,F },  0HC
pHF#Db# C ݶ CCtGT_    }  . #.JS#JQ
#JSF4@B
CJPJrCJ3F #>F  >0   . /JZKX
K:G95 C
4KWJy4KGF ?  >  }   fQH },%vH .;K HGdHP
JD8b# 4 @ CpDCDG  CCGTGG_0 ݠ4G< G  , ,   ,HEHb#A  HDpH0D   <8 ]0 =  2  _ GG@ ]H ]P }X ` h ݤp x  #k Q0 H_FSF Q#4G  ^( ~0 8 G{ ^GG  ~  xb# c  > ^{_  =b# ] v H?D C C @GG  4G b#_G ] G  ]( }0 8 @ #kG#  ~ 8 ^@ ^H ~P X ` ޴h p   cGGG$J%!J` [	 >"TG ] 1,  ,
JsJA
1H@H4D D 1<  < CGGb#GTGGs_   G CGtG0 =  b#_   G| G( = GD  v G  eQH$vHG F"b#0JCDD  C f.G .tG  rJT
JGtF Cs_]  ( CGTGb#  %, .%HRJP
J2F15 B
%JA%Hq%JF1D >  %<%HD .GTJtF
 `( *_ ,TG ,GH0 =@
H8b#D C_  , &,CGTGHb#Q&HA
&HF05 B
J@HpJ1D D &<  <HD f.GG  SfJSF @_ , f,4GGHC
dHb#D C_G0 =TG  8b#}_GXb#G},@G D G G G  cG8 ]@ ]H }P X ` ݤh p  #kG#4G ^  ~( G{G ^G  ~   c b#_ b# @G  4G b# ˯_ G ] ]  }( 0 #kG#  ~ 0 ^8 ^@ ~H   cGG	 >"p  TG q.  Q.
HtHS
qJRQJuF q>TF  Q>G Cb#GGTG_   G( "CGtG( =  b#_   G G  = GaD   G . #" 4G JF @ G .4 B c"uJT Jb#F > c CJgH `!_ G  cG0 ]8 ]@ }H P #k#4G  ^( ~0 8 G{ ^GG  ~  b# c  > ^ ~_ ]b#  =3v@J ]0v H?D @G  Gpb#4GM_G ] G  ]( }0 8 @ #k#  ~ H ^P ^X ~` h p   cG8 G@ >GG	 ^"  TG 2,  r.
HtHA
2HSrJ5D 2<tF  r>G C`b#GGTG_n  pCGtG( =  pb#:_e    = $" "D`   D.G G QJR QJ35`BsqJSF TJ D>J T GGCb# CGTG;z_0 }tGb#C> `m_G Cb#G4Gz_   G= q`D8 p`D  QsJRTJSF  QWB> `@ ݦ " . ##HxJW J`HF >D c/ C" C/[yKZYKaG c?@G C?0 =TGD
 .2J c.Gu2JTJ SrJ@b#F
 >uF c>GJ_ D   TG	  d,   eHC eH4@@bEHbD d< G  cGH ]P ]X }` h p  #kG Q0 J_FSF Q#4G  ^( ~0 G{G ^G  ~  > b# c  ^L_ b# = ] @G  4G b# _ G ]  ]( }0 @ #kG#  ~ 8 ^@ ^H ~P   cG0 >G4 ^	 ^"p  TG r.  2,
HtHS
rJA2HuF r>4D  2<G Cb#GGTGO_   G' "CGtG( =  b#p_   G G  ] GbD @ G  . G #.4 ]JQ#J  r.FtJS rJtF  r>0 ݢ . c   . JxvHW JF  >G  c8 ]@ ]H }P ` #kG #4Gx^~޴>^~Gp^GG#J  ~ b#  ˭_G CCb#GGtG_ Df  GC}"b#GC C"G/_X  GG   'CGCb#tG q. Q" .GGrJT
JG	tF	 CG_ DB  GCCb#                                                                                                                                                                                                                                                   n                        Ҟ{ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        Ҹ "     !      GGCG"G_  
GG0 !  LCGTG b#G_ D	   =3v`H  !. A.!JRAJ2F3F
  0`A	jA !0@	@   . !  CG J0b#_G( =!  ]!b# C CtG_ D Gb#B_G4G  pb#_Gp]x]}ݤ=]}#kG #4Gx^~޴>^~GPGp^#JG$!J  ~ (b#  )_G CC b#GGtGr_ Dj  GC}"b#GC C"G_\  GG!  (CGC b#tG q. Q" .	GGrJT
JG
tF
 CGN_ DF  GCCb#GGCG"Gi_!  GG0 !  MCGTG@b#G_ D   =3v`HD  !. A.!JRAJ2F3F   . !  J6D
  0A	A !0@	@ ! C CGpb#a_G( ]!  }! b# C CtG_ D Gb#_G4G  b#_Gp]x]}ݤ=]}#k  0,G P.G p.G0H  [RPJ( { "2D!v H pJ C0v J!"H C C0D%WZkGkG C C  0,  P.  . .0HRPJJUJ2DF	4@ k	B   4Gk . " / 1"  J K	B  k	0Bk 0#G !   ~ ^G  4G Q p G  [G 4G G( {GTGfWZkG ]  4G  #k#4G ^  ~( G{G ^G c   ~  C@b#_DG[   &pb# "G4GtGvz_  C   Gb#G˭_b#w @DI  b# @DE     ( P.+ p.PJS
pJSF CJ3 .xJ0 .WJVJFF3 >0 >, #CG?F+ 1,QK( , cpQKA1HG@H2D D+ 1<( <qK; .vqK8 q.&BcTJSqJb#F; >vF8 q>/ ,xH, 1/axH@HY8K D/ <!G, 1?4GP_ DG  b#G_ pb# @ GG ] ] D  }( 0 #k#G ^GTG  ~   G {#Z{_G ]   C  #k#G ^GTG  ~   Gȷ{#}_G ]   #kG#4G ^ ~  ( G{ ^GG  ~ #b# c _G a@b#TG  >G?"GGGGG_GG  4Gb#ʫ_G ] G ] }  ( 0 #kG#4G ^ ~  ( G{ ^GG  ~ #`b# c o_G `@8b#TG  >G?"TGTGGtGG_GG  4Gb#_G ] G ] }  ( 0 #kG#4G ^ ~  G{G ^G  ~ b# c #_G 4Gb#z_G ] ] G }  0 #k C( 0,+ 0.0HQ
0J 1D  C ;, `"(  ,+  . HP
 J0D  14   , ./ .JU
JF q0  .3 . JT
JF 8  .; .4 `.7 . JU
JaJT
J F tF 1 Gk#4G ^  ~( 0 GP ^GGG  ~ b#  _G 4Gb#  _G C Hb#GTGl_M    0 B   = . . q"JW
JUJF61BJTJvJF >F >  X/ x/ 8# X"YK[
yK[G CG!   . 8.TGb#JQ2JF 8. # 8J2@G4G (b#Q_ D	  "G CbtGP !  C%@N^ `b#G_ GG4G b#_  GC GHb#TG_ӳG4G  @b#۪_G ] G ]  }( 0 @ #k#4G ^ ~  Gp{G ^G  ~ b# c _Ӱb#
 @G  4G`b#_G ] ] G }  0 #k#4G ^  ~( 0 8 G{G ^G  ~ b# c _G C  b#GTG_5 G =4G !. "
 A. "0JR
PJ2F Ci  8 F  . .JV
JF CTK  /qTK 4/KY
4KG C8 G  ,  t/@H[tK DqG <  t?  . " 0/ # ,JY
5K 0.HF CqFQ8J  DpFwHTJF W@C } ;/ ;. " / {#6KQ
6J Kb#1G C
  
 .r KTGP  JF
 >  . " T/JZWK . "FG Jq1@Gb#Ga%@ b#G7_G  4Gb#_ D  "  Gh b C C'@4GG^Ӹ  4G   .  . JQ
 J F  C    d. D" . "rJT
JtF CH  . .zHJW
JF C8F4  2/  /Y2KXK;G 2?G  ? $. , =0J@
H .  F .  Cq D a" VJWJp DFuJRXJUF VW C  d/ D# . =zKP
J 9. 9#pGG Cb# 9J
 .
 p"`3JW JGF
 >$@?  G   .  . JQ
 J F  C  D4 `G . " .JV
JF C
 "  / 4/KY
4KG C8 G   t/	 4, ]tKA4H . :.aG : JQ!JFpG
  
 t. . Z# uJ JvF ` /  4/XKY4K ?  4?  $. d/$J[
dK;F CD  . D/JZ
DKF Ct ݢTGGb# . " .JWJ . "F J0@G4G  b#_ D	    G Ch bTG C@G^ b#Gn_GC  Gb#TG_G ] ] G  }( 0 8 @ #k 0 HFF  V0J_FUF VdÐ# G8 ^G[G@ ^ "H ~4GP X ` GG  ~GG "UZkB C%HGSZkGb# C#v`H_ p1HGTGb!H 0D   D. C DJTA =D d"
 $#?D F 6v H . .JUJFbJ7bJ F  D/ d/ =YK[yK08H[GHGb#4G1HF =   è_ CC CGGCb# @  G4G  b#_ G G0 =DG4Gb#!v H#D  ( FF  _ GD G4G  b#ݨ_ GG8 ]@ ]H }P X ` p #kG# G8 ^G[G@ ^ "H ~4GP X ` GG  ~GG "UZk  B C%HG/SZkGb# C#v`H_ p1HGTGb!H 0D   D. C DJA =D d"
 $#?D F 6v H . .JUJFbJ7bJ F  D/ d/ =YK[yK08H[GHG(b#4G1HF =   E_ CC CGGCb#A @  G4G  b#w_ G/ G0 =DCC!v HC#D   ( b#FF  G Cj @  G  4Gb#^_ G 0 =4GGb#!v H#D	  ( FF  P_ GD GG4G  b#G_ GG8 ]@ ]H }P X ` p #kG#G ^GtG  ~ ^  G   Cp{# ~Q_&   = ݢ  !. A.!JR
AJ2F C8 F   .	 .JUJF   .xJWJF  > = }G
 Y/
 9#  , YK@ Hr;K D  < ] G  0 #kGG ]   G0 #k .
JW
JF ># G ^GtG  ~ ^  G   C{# ~_     .  . JQ
 JF C   `.	 .`JTJtF   .wuJ GVJF  >  ]G
 8/  z/
 # 8K[ zKqKqG  z? ]  0 #kGG ]   G0 #k .
uJV
JF >À#H ^P ~X ` h ޴p x G  ~@ ^GG%AJ?F  8D   G@  . " c.TG .GJxbScJ JFA =D "GCb?D F 5H c.GGG tJtGv1`J F 1A D/ .  4 =.5 =  ]JQ!J3XJF"H4'HtF =  G 7J ( = " ]G # !K;v@K0B9'K   "KTG `G SZk . . CGJV
Jb#F CA_Gb# C4G2_ ¤4GGb#   
_  . #, C" #.b#JA#H 2JF9@ C G  4Gb#<_ G   #.C c.GG#JScJb#3F@ CG    b#4G)_ G G8DG  !. A. "bTG0JR
PJG2F CG  . .JU
JF C) 4A'   D.  $.4G$HRDJs$HQ$JTF D>3F  $>  .qD .pD 8JWJY;KFzJ:G 8W`C @ , c 
 ,
  GG H8b#G HaHD
 <"@| G%vHCb# CGTG r_8 4GG   b#٦_ Gq tGPb#_ CG    b#4Gͦ_ Ge G .H  1,rH "PJA1HF2D >  1<H .wH .  q DVJUJFF > >p D  C/ c/  CK[cKEH[GgPKD  W BR  C. c  , q" " CJD HtsH4GD <uH?F
 .xuH .  WJVJFF
 > >TG8 } ,?F 1,`KEHg`K DGA H <b#'D 1<_DG   b#4Gw_ G GG4G  b#o_ TG GG4G  b#g_ GG@ ]H ]P }X ` h ݤp x  #kG 80J?G:G 8^ 0@KDD Ð# "  ~TG8 ^@ ^H ~P X `   2,G r.G .$J2HGSrJ{ J3D%!JGGGaA =DG "b?D F 5H c.CGG tJGv1`JtG F g0A
  / .5 = 4 =. ]JQ!J3XJF"H4'HtF =  G 7J ( = " ]G # !K;v@KB9'K$vH "KTG `G MRZk . . } G CJpb#V
JDF C٩_Gpb# C4Gʠ_Ӏb4GGb#  c _ C Cb#@ CC CGGPb#@ CG    pb#4Gӥ_ G Gb#<@b#_G4G  pb#ǥ_ GG8 ]@ ]H }P X ` p #kG#4G ^  ~( 0 G{ ^GG  ~  b# c  >j_ Pb# = v H?D C C @GG  4Gb#_G ] G ]  }( 0 @ #kG#0v J ^?F  ~( 0 G  ~G ^{#{@ C  #    Q.G q.pb#QJS
qJSF@ CGG Cb# CGTGh_PTGG = 8b#_Ӑb#_G ] G ]  }( 0 @ #k#4G ^  ~( 0                                                                                                                                                                                                                                                    o                        \ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        O! "     2      8 ޴@ H P G ^GGG  ~G #v`H(b#   >_  C0b#D C6@  C  7 G .D	 '.8@FJQ'JF8 F  % @ . g" .JU
JF C
    . /JX
KF C8F  (/	 H/(KZHK:GG#G
  
 h/G `Kb# D  g @ .  (,PJA(H >  (<  G. g.GJS
gJSF C b#P_G4G  b#_G ] G ]  }( 0 8 ݤ@ H P ` #k# "  ~TG8 ^@ ^H ~P X ` ޴h G  2,G r.$J .%!J2HGSrJh{ J3DGGGA =D "GCxb?D F 5H c.GGG tJtGv1`J F 
/A
   . =. =   ]JQ!J3XJF"H4'HtF  =   G  7J  & " =G ] # $vH!K;v@K  B9'KD "KTG `G PZk . .& } G CJ b#V
JF C|_G C b#4Gm_bG4Gxb# I_ C Cb#{@C C CGb#@ C c   G4G   b#w_ G. G !. " A.G0Jb#R
PJ2F C
 &#  . .JU
JF C8F  .	 .JWJFF 
 / KGG @ ,  ,@HEH <  <Pb#_G  4G b#H_ GG8 ]@ ]H }P X ` ݤh p #kG#4G  ^( ~0 8 @ ޴H P X >` ^h ~p x Gpۤ ^#JG$!J(v`H  ~G b#%AJD_ C Cb#@	 C    I4G @G *. 
" J.CGTG0Jb#R
PJ2F CGG _  ,,
 " .,HP
J0D C8 D   ,.	 L.,JRLJ2F(F9  
 l. tJgF5 ` = Cb#@0  qEpE 0rsHQ3J2F 0W`B @ .lI  .vlI
 #UJTJFF >  >zHE
 ,/ q@Ep@EY 8K:G
 ,?4G  qIPJFW@B    Gb#G@  
, *,
HA
*H
D
 C_   	
F   p. "	 .pJTJtF8`F ` . .JW
JF C L/  ,/ZLK L?Y,K  ,?  p/ ,pK@
H`G C
F?G%vH  @b# C CTGn_ 4GG    `b#_ Gc tGb#z_ CG    `b#4G_ GW  q!
q`Ep`E  ghHEHDW A  i  . 1 rHP J1IF >?F .v1I  . #UJTJFF >  >I Q/{I 1/ q  Q!ZXKY8K@G;G Q? 1?TG?F
 , ,GGH
 <EH <  1,?F q-
IA*Hd
I KjIb#2D 1<dE q=_	D  G  4G`b#<_ G G4G  `b#5_ TG GG4G  `b#-_ GG ]  ]( }0 8 @ ݤH P X =` ]h }p x  #k 00`H?F2F 00  0IFF  E 0`HDD #qQ J  ~0v J  ^G( ^C0 ~G8 G G{tGG H >  F D  b#C  c _  GCC  Gb#GCGG_   G  G  ]( ]0 }8 @ #k# ^  ~( 0 G  G  ~G ^  D. $" . CGTGQJb#P
JGPF C_ Gb#Gn@    $, .$HP
J0D C G_G ] ]  }( 0 @ #k Gð# ^  ~( 0 8 ޴@ G  G  ~G ^G&!J  E. " %.CGTGPJb#Q
0JQF CG_ G b#G8@6    %, .%HP
J0D CTGpb#g_ C  G) GqD  #pD r&vHStJWB r)  .  .%Jx%JWJVJFF > C  >Gb# @ E, ,  C  HBFHaHDHPDD E< <   G    GG ] ]  }( 0 8 ݤ@ P #k rF rð#tG0 ^8 ~@ G`{G( ^G  >C  ~G  GG  >b#N_   = A. !" a.QJU
qJSqJF0BJRQJtJuFTF a> A> G( ]0 ]8 }@ P #ktGb#_  C    GGGC4G }C  G  =b#G tGG_ GG#C  ~ C ^TG ^  ~( G  1,G Q.G q.1HR
QJGb#2D Q. 1"U
qJSqJQJRQJF41BJtJ CuF8 D c>TF C>"  G_  c.
 "	 .G   .  .cJG J8b#Q JTJFtFF   .   
 . J J D  
@ .  #,PJ >A#H  #<D C. #" c.GCQJb#S
qJ CSF C
  GTG_0bTGG =  b#_G ] ]  }( 0 #k# C8 ^TGG@ ^H ~P X ` ޴h G  ~GG`b#GGw_(   "C`b#  ,  " `.4J  .GHS`J JD0J5vHFF G / $/GKY
7KG CTGGX_G D8 b C CTGA0 =  . J D  4@D_B_ }tH &G3|J2GJFvB } " /PJ !/rPJG" ,KY!K ,GGKD4K DJtJD D" < <# }"G& =/sK# .zsKH bY3KWJ G& =?F# > ,# " .GGXKHP
J!@D C & ,6Hs6HC@HC D& <G# ?GGGtGQ+A9     =  C C0 G D0 G9'KD0D = `. @"
 . "G /rJTJ .6KtFBJy6K;GJGvK{vKFG ?F >  .C  ,CG = JA H FH460J5HG5֯JG F TGG( bm-A , ,  GH@
Hb#D C_  à D   (   . &.JQ
&JF CF @G   . C .b# .JU
J  .WJFfJxfJVJFF >  >_
 G  , C $,b#HA
$HD_  ðG8 ]@ ]H }P X ` ݤh p #kG#4G^~޴ G^GG#J  ~ xb#  9_G CCpb#GGtG_ D,  G CC`b#GGC"G_   GG   (v`H_GC  TGb#N_ b#   .  . JQ JFF   `.    C `J_0@	@  GG4G   b#=_G]]}ݤ #kG#4G ^  ~( G0{G ^G  ~   c b# >ߟ_  =b# v H?D C C_G  4G b#_G ] ]  }( 0 #kG#0J  ~( ^0 ^a J8 ~@ H P  GGG1HG !F %v J_GDb CTGA  #, #H D  4@D?B? ]tH " '3]JGtF  .$vH2GJ   J@J6Jr@JF@ a@ C/# " c/7HG" =.CK[cK ,d7H[GBK3F4GKDGJtJ5F" =>D <G& /  # . CXKVJGF& ?# >C c/G ,tGcK@
H `Gb  C  )A   GN  =,   .G6J
 .$H .PJJ0D"HvJ8'HFKxKF ]"FF
 > C > C.   "   CHD?DD  C.46H c.GCCJScJSF"JG5!J2GJ5֯J@JF  /r@J
 #/GG =,KY7K ,GbH3D4gHDJtJ5D =<D <GTG( b,A HHG( ]0 ]8 }@ H P ` #kG#G  ~G ^   G P. p. 1. " .@JS
`J0JT
J SF4F  C C D    4G  #kG a. A" !. " . ,rJQ2JJ@HqF FpF  G ]  4G  #k  !. 4G  . !J J4F  G ]   #k . " 6.   J  J  F  G ]  4G  #k . !.JQ
!JF C#   . ,J@
H  F  C    F  G ]  4G  #k . "
 !.   .G
 .JQ4J ]J WJFFFC  #kG  [!@BHZk  G ] 4G   #kG . A" !. G HJQ
!JF   a.
 .H
 v/`HrJ V/TJqGtF"H@G0'HJpJxG
 v?PG V? G v.   .G:GKvJT
JAKtF @ .zAK
 6.
 / J .Q JG FHF3HaJsaJG
 ?F >G ]  G  #k#4G ^  ~( 0 8 ޴@ G@{ ^GG  ~  Cb#_ D"
  Gb# C#@GGGG$@GG b#_G &b# "TG4GtGjl_ CG  b#G_Hb#    @D pb#S@D  ( P.+ p.PJS
pJSF CHs .p .wHD F#VJUJFFs >p >< F"  #G ,D f/:K@Ha:K[zKG DG <aGD f?%GD? .2J< f.v2JH bUJSrJF? >vF< f>  GGDC &,K@ ,pKA&H@H9D DC &<@ <4GTGA ,H  .aH` BGDHTJD <F  >GTJZkGb#@o .l &,  Cl  GHb#PJqHA$HF1Do >l &<l f"Do .3H4GU
JF Ci_
  GGb#GGGG@GG b#`_l ,l  o &,Gb#HA
$H D  C  k@S .P &,  CHGPJb#qHA&HFS >1DP &<DS .&H4GT
JtF Ci_
  "GGb#GGGGh@GG b#2_Gb#E@c .` &,  CHGPJb#qHA&HFc >1D` &<Dc .&H4GT
JtF Ci_
  "GGb#GGGGB@GG b#_Gb#@k .h &,  CHGPJb#qHA&HFk >1Dh &<Dk .&H4GT
JtF Ci_
  "GGb#GGGG@GG b#_Gb# @O &.L .  CL & GHb#Q!JrHPJ3FFO &>L >L "DO .J4GV
JF CXi_
  "GGb#GGGG@GG b#_Gb# @_ &.\ .  C\ & GHb#Q!JrHPJ3FF_ &>\ >\ "D_ .J4GV
JF C0i_
  "GGb#GGGG@GG b#_Gb# @g &.d .  Cd & GHb#Q!JrHPJ3FFg &>d >d "Dg .J4GV
JF Ci_
  "GGb#GGGG@GG b#n_G@ b#4G_ D
  "G Cb#GGGG@GG                                                                                                                                                                                                                                                   p                        s $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     C       b#Z_< &,<  ? .D f"L # HP
 J 0D\ "@ &.C F.&JR
FJ2F%D .G .JU
JF  cH .d "K .L &/O F/JP f/W
JS &,8K\ ,Z
XK_ F.fKA
&HF:GŲH R
PJ` &.aGc . C % D h .&Jk &/T
Jd f, Cg f.JY
&KuHS
uJ4FFG C  asD % C e Pb#  G@ C0b#@ Šb# e    G@ Cb#@ Šb#     @ Cb#7@ 0b# @ GG ] D ]  }( 0 8 ݤ@ P #k#G ^GTG  ~   G{#k_G ]   C  #k#G ^GTG  ~   G{#Xm_G ]   #kG#?" ^tG ~G  G( Gh{G ^GGG  ~#`b# C   _GG  4Gb#6h_
  bGG0b#GGGG@GG@b#_
 bGG0b#GGGG@GG@b#_G ] G ] }  ( 0 #kG#?" ^TG ~TG  G( G{G ^tGGG  ~# c b# C  _G  G0b#4Gg_
  @ bGGGb#GGG@Gb#GY_
 @ bGGGb#GGG@Gb#GK_G ] G ] }  ( 0 #k#P4G ^G ^ G  ~G   b#Q_XG4Gb#  j_G ] G ]   #k C( 0,+ 0.0HQ
0J 1D  C ;< @"<  ,?  .2HP
J0D  1D  "@ `.C . ;`JT
JtF qD .G .JU
JF  H `.K .p .`Js  ,T
J   .JL .tF .A
 HO . JS  /F_  /T
JL "JW
JFP .F\ .X
 K qJ 1\ " J Y
6Kc  ,F`  / C Fh  .k  / KA
 Hd . JY
 KGg  /F Ѳl @.l "o  /d `"JWJY
7KX
K YF,  C  1 C( F$ q Gk#4G ^  ~( 0 8 GG ^GG  ~  b#_ӈG4Gb#     _G C  8b#GTG`_K    0 B   = . . q"JW
JUJF61BJTJvJF >F >  X/ x/ 8# X"YK[
yK[G CG   . 8.TGpb#JQ2JF 8. # 8J"@ b#
@G  4Gb#B_ D`"  Gb CP !  C%@tG?^ G4G  b#_  GC  G8b#TG_ӵG4G  0b#њ_G ] G ]  }( 0 8 @ #kG#4G0 ^8 ~@ H G{( ^GG  ~  b#_ӨB4GG D, ,  CG   CFZkGGb#GtG_G CCb#GGC4GG_8    =CGGb#TGG_    .  .   JQ
!J F ]D . . r""JUJF6CFN6J8CFYC8WKy9C8C4B;JFv`K4J;aK4@[C  .  :. J G :J@ H!Fr:H D  <G  4GGPb#    Y_G( ]0 ]8 }@ H P #kG#4G ^ ~  G{G ^G  ~  b#_Ӏb# @G4G  pb#;_G ] G ] }  0 #kG#4G( ^0 ~8 @ GH{  ^GG  ~  c b#_G C  Gb#TGY_  = !.
 A. " !#0JR
PJ a#2F C]  8 F    . / .J A/X
KJF CZYK !/ V. " v.F . ;K .VJS
vJ bJW
JSFF CB CGG@ G  . @" `.  #  .  # .J @/SrJ `/J .V
JYK[
yKFF[GP b C J CG@ D   =GTGb# . A. !"JRQJ !. ! F !J @ b#@G4G  b#
_ D    " C4G C'@ G TG b  . @.  "JRQJ  .   F  J@  ]CC  .  .   3_JJQ!JGFb#t JGtF  .   G8vJ JyQ H G tG_ D   b#F@G4G  b#_ D^    " CTG C'@T    4  =GP b . a. A" . " .JSrJ A.JW
JF "F TJ CGG\@ D    . $.JQ
$JF C  ]TG b . . "JUJ . R"F J@G  4Gb#`_*  !  TGGb# . $" D.JRQJ $.  F $Jd @ b#@G  4Gb#|_ D     CtG C@GH bGy^GC  b#GTGV_ GG  ]( ]0 }8 @ P #k# C( ^G0 ^8 ~@ H P ޴X GG#v J  ~$!J  ~GX{G$ G CG"A DO   =. ", %,  0J  !   Q  3C1F" GtN6aJ5C3FVB5WJvB5B15B8!J Fv K1!J8K1CB  Q/  w/ " QKWwKJ F  ( ¤4GGb#  _G CC0b#GGtG_ D  G  4Gb#_ G D   = C$ ] Cb# @GD  4Gb#_ GDG( ]0 ]8 }@ H P ݤX ` #k P.RPJQFÐ# C  ^G( ^0 ~8 @ H ޴P X ` GG%v J  ~&!JGG{GGG CG^"A D@⤇   =. ", ',  0J  !    83C1F0"tN6aJ5C3FVB5WJvB5B15B8!J Fv K1!J8K1CB  Q/  w/ " QKWwKJ Fa  84GGb#  ._G CCb#GGtGi_ DK   @@@     GGGV @/    7/ w/7K[
wK;G C@@_ @@@0     GGG@ @   7/ w/ # 7 8K[xKD;G%G   W/ AK0D    W. w.WJS
wJSF C@@ G4G  b#_ G GG4G  b#_ G GG4G  b#_ GG  ]( ]0 }8 @ H ݤP X ` p #k P.RPJQFq 0,  
 p. HS
`J  3D C1@  p. .`JU
J uF  C Bk!B  2B2B @1@kG 4Gk
B#	CG ^C ~G  (   ~G ^;aJ"  "J  x$v`K `G c. " .pJTJ "tFD ` #._D 0JF  GGG_    #, .#HP
J0D C CC? GG ] ] }  ( 0 #k Gà#!B ^4B ~4G  ( 0 ޴8 @ H >P ^X   ~G ^Gf ` X['!JGG&vHG  
Gb#GG)HF(_D C Cb#@ C  G  
Gb#TG[_ GI  CGGGb#@ C @G  
Gb#TGK_ G9   #I$HE	@ )v I  8 E)   C C CG0b#7 @G  
Gb#4G3_ G! GG4G  
b#+_ G   $H)v I
d@ ` C C C4G0b# @GG  
4Gb#_ G G4G  
b#_ GG ] ] }  ( 0 ݤ8 @ H =P ]X ` #k#TG  ^( ~0 8 @ ޴H P X >` ^h ~p G  ~G ^G r.G , R"G&JrJhb#@
H'!J`F C C(JGG_ D( GG #T %#	4G  8. X.8JR
XJ2F CO `G . C# .G , C.JU
JHR
ZJFD C C_7   ;, [# .1vH {":HPJD0D1D+   [.xF ;" SJTF% @ "$  . C/ " ;,
 {.JZ
CK1HS
qJ F3D  C C D   C.tG . . [/TJU
JJZ
WKUFF  @ C 1 @  F4 DG 4G 4G  ;, .;HT
J4D C #CGG E!  . ,J@
H F CO `G #, " c.G . ,#HS
cJJ@
H3DF C C_7   +, K# .1vH k":HPJD0D1D+   K.x G +" SJTF% @ "$  . C/ # +,
 k.JZ
CK1HS
qJ F3D  C C D   C.tG . . K/TJU
JJZ
XKUFF  @ C 1 @  F4 DG 4G 4G  +, .+HT
J4D C 9#*CG  G  `G
  x G @ G`GE x G  xF  c. C! .1vH .D #/cJT
JJY
*KtFF C C C Cc@4Gb#@b#@  C  !q Ep E  KaHJPI
AE  KW BF  @.  "sH "R QJ !SF @> .  " .G D
  /JV
J  /FJY7KzJXK;G
  ?G  ? #, , C- c-#H D  .F
HHI ,K
hI&DKE (@!1 @0HQ0Jr0HGH3F  >D < . .JU
JF C7JNY B:J77C WC5B0 UB  ,T u#   -T ,T 5"W U-A HH IHJ
[IHDHgH0DE  <   =vHW u.#IT U.w#ISqJRQJxFW u>VFT U> C/ #/ZCKY#KDG C?7G #?. G `GmxFk_ G GUB ,  ,H U-rH u/GHFHUI[
uK
[E@Ih@ID <D  < 5. .Q5JPJ3F 5>F > /TG .JdJXKVJGF ? > %# E/   %-HjH( YK0A
9II9IaG0`CyKZYK{yK	!E[G %= E? - ,  "HI
b#GHED = < =  q. . Q"rJUJuF$CsFL6H4CdFVB4WJvB4B3tB8aJ`Fv K3aJ8K3@B  ,  7- HG 7IY 7K!Ez7H:GG  7?G@ G[ G(v I ]!b# C CTGH`_  E O øb#~@ C   GI  !
q Ep E  kHEHD  W @T ` Q. "sHqHR PJ0wqHSF Q> 1#?F .9I  .`9IVJUJFF >  >  ?F
 q/H Q/jH[yKZYKaG@G
 q? Q? Q" -TG?F ,HIGE =FHHb#D < G?F q,H q.tH CrHSrJuD q<tF q>E_ DT DG ]  ]( }0 8 @ ݤH P X =` ]h }p  #k K0H
_E
AE K 0HDD #4G  ^( ~0 8 G ^GGG  ~   b# > ^ ~F_ 4`@ b# =G `@ ]0v J D?F C CG @G  Gb#4Gq_G ] G  ]( }0 8 @ #k#0v J( ^?F0 ~8 G  ~G  ^ C ~{#   ^                                                                                                                                                                                                                                                   q                        cӆ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        .a "     T      S@ C ` G G =G ]G }Hb# G@ C   G
 !5 B   G Gb#@b#
_ GG  ]( ]0 }8 @ #k#4G ^  ~( GP{G ^G  ~   xb# >_ b# = v H?D C C @G4G   b#_G ] G ]  }( 0 #kG#1!J  ^( ~0 ?F8 @ G  ~#J >G ^ v`H C C{#@ C  G!   $  G  Q.G q.b#QJS
qJSF~@ CG  =#v`HxC HGaQ Hb# G  D D TG[_0b#_ GG ]  ]( }0 8 @ P #kG#4G ^  ~( G0{G ^G  ~   Xb# >|_ b# = v H?D C C @G4G  b#_G ] ]  }( 0 #k# ^ ~  ( 0 G  ~#v J ^?FG C C{#@ C   G$   !  %. " E. CbG%JR
EJ2F   e. C .@ . .eJT
JJW
JtFF C CG@ @  %, .%HP
J0D C GG ] ] }  ( 0 @ #kG#4G( ^0 ~8 GP{G  ^G  ~  >  xb# ^ ~ _  =G ]b# v H }?D  C C @G  4G b# A_ G  ]( ]0 }8 @ #kG#?F ^ C ~  ( 0 ޴8 @ G  ~G ^&v JG2BG4BG CrF'J{#@ C   G D C CGGGb#e@ C7@ ` G  , G &,HA
&HD C   G .8 D &. "8 b &#JQ
&JF C2JSNT _B5@J2B B2BL   . / F/JX
K f/YKF CECBT  T %.W e.[
yK JS
`J[G 3F C  C G   .b# .JP
JFG@W .T  T %,HqHP JA HF1DW >T %<p o    . .JU
JF CF  Gd   .   / `/J  @/X
K[`KFJaJZ@KdG `?AG  @? . &.JQ
%JFK  ,   , &  .b#H &.@
HJD CDCBQ
!J d. .FdJT
J CtF C3D   .G .JW
JF@ $, ,HpHA$H@H1D D $< <$ # `  . .JU
JF CF G   .   / S/J  3/X
KZSKFJ{JY3K@G S?;G  3? , .HP
JD Cb#@ ,   ,GGHP
H
b#@H0D!1 @$HEHa$H D <D <3@ , ,(b#EH <DH < 
_ GG ] ] }  ( 0 ݤ8 @ P #k#4G  ^( ~0 8 Gp{ ^GG  ~   b# > ^ ~ݑ_ = b# ]  H!v H3v@JF CH C C @G  G b#4G	_G ] G  ]( }0 8 @ #k#P@F ^  ~( 0 8 ޴@ H P >X G$J  ~&!J ^%vHDGC C C(aJ{#?_ C Cb# @  C        C CGGGhb#_ D    	. ).	JQ
)J	F	 C? GG ] ]  }( 0 8 ݤ@ H P =X ` #k C Cb#_G(v I b#   C CTG\_  G G b#*@ C   G !q Ep E  aHGHD  尡W B>   .1I  q.u1I "BTJSqJF >uF  q>?F /yH Q# 1 X KaHG ?gaH?F
 , q" q/TG@H[zK
 < q? ,?F ,EHGD <DHb#D < =G?F .3I .v3I UJTJF >F >_ D TGG 0HDD 尼à#0J( ^4G0 ~8 @ H ޴P X G  ^GG#!J  ~   b# ^_ = D C0b#0v H C; @ C(    %    G  .G . b# Q  ƢJU
JFF C @@G   =cQ`HC  G!v H G HXb#TG `D D _pb#_G  4G`b#_G  ]( ] G0 }8 @ H ݤP X ` #k#qQ J  ~0v J ^C  G tGG H  F DG  C{#G _ =GG ]  0 #D GkG#0J0 ^ G8 ~!v J@ G#!J   C  ~D G( ^ C{#_  C cQ`H   =  ]CC1?JG2v@Jb#qD CrDG }GGGG_   G  G( ]0 ]8 }@ P #k#0v J0 ^GG8 ^@ ~H P X ޴` G( >G  ~GG@ {GGCCyA D   4G? ( =  :  &. " F.CGTG0Jb#R
PJ2F CG{_ CGG@    . /JX
KF G f/ &  F/8DfKZ
FKzG CCG @ . &.JQ
!JF C$D   @  f. .fJT
JtF   . ,J@
HF C G_G0 ]8 ]@ }H P X ݤ` p #k  .G .JW
JF C*  f/ # F/CTGxKZ
XKzGG Cb#._ CGG@	    . G /JX
KF C f/ F/fKZ
FKzG CCG	 @  &, .&HP
J0D C G F. &" f.QJS
qJSF C$F=    . .JU
JF C .   .CGGJb#W
JTGF C_  CGGn@	    . /JX
KF CG f/ F# ,fKE
HeG CD  &, .:HP
J0D C$D	    &. F.&JR
FJ2F C{G GzÐ#0v J0 ^G8 ^@ ~H P X ޴` GGG( ^C  ~G{GG( >GCA D   G   à+  &. " F.CGTG0Jb#R
PJ2F CG_ CGG@   . / &#JX
KF CF  f/ F/yKZ
YKzG C%Gp    . &.JQ
&JF Cb#@ C  Gd G  #C .b#  f. F &JTJu&JSfJF >uF  f>_ @ . &,  CHPJqHA"HF >1D &<   GF G /H .yH & XKWJGF ? >HD .qH F,GPJBAHFQD > F< "D .uK f.wuKTJSfJ > f>GD ,0J ,JDH@HD D < <pJ( =GD ,  Y/ 9, 9# F,YKA9HDAG"HPD2'HFJrFJDRD < F<  ð GG0 ]8 ]@ }H P X ݤ` p #kG # C ^G ~tG  G ^GGG  ~G   b#!_   =  A. a.AJU
aJSaJF0BJRAJtJuFTF a>  A> G ] ] }   #kCG0 B4G  }#  8     Cd "GG{Zk0 B "GG{ZkG Cb#GGGGGG_ GG#    ~ " ^1!J ^0v J  ~?F( G 2,G r. CX{# HS
`J3D C  #, c.#HV
cJScJF51BJA#HuJvF5D c>  #< / 2/KY
2KG   2, r. . .2HS
rJJV
J3DF C CCBGR_  #,C .TGG#HP
J b# 0D  C	   Cu_bGTG =  hb#_G ] ]  }( 0 #kG# C ^TGG ^  ~( 0 8 ޴@ G  ~GGb#G CGR_  " d.@ .(b#  ,  .  .dJT
JHP J   tFD  J ` . C .G / $/JV
JKY
7KFG C CG _ C CGb#q_  b#F   $, $.$HQ
$J1Dm @   
    , 0,HA
0H D  CD  G  d.b# . .dJ  .T
JWJtFPJxPJVJF >F  >GN @G ] ]  }( 0 8 ݤ@ P #k#&" ^ ~  ( 0 G{G  ~4G ^  c    !@  $ B GPb#_  C   # .0@  .
@  !UJTJ  C Jv JF >F  >    20 C  2_ c  c  	    . .JU
JF  {  71B  G ] ] }  ( 0 @ #kG# ^ ~  ( G{G  ~ ^  c  .  .   UJTJC0Jv0JF >F  >     r0`B  rs" `   b#    . .GJW
JF@_  #    !11 B  !1"?G ] ] }  ( 0 #k#&" ^ ~  ( 0 Gx{G  ~4G ^  c    !@  $ B Gb#_  C   # . `" .0@  !
@UJ  CTJ3Jv3JFF > >    20 C  2_ c  c  
   . `" .JU
JF  {  71B  G ] ] }  ( 0 @ #kG# p" ^ ~  ( G{  ~G ^   .  c  .   UJCTJ3Jv3JFF > >     r0`B  rs" `G  b#   . . "GJW
JF_  #    !11 B  !1"?G ] ] }  ( 0 #kG#&" ^ ~  ( 0 G8{G  ~4G ^$ $ c    !@  $ B Gb#_  C   # .0@  .
@  !UJTJ  C Jv JF >F  >    20 C  2_ c  c  	    . .JU
JF  {  71B  G ] ] }  ( 0 @ #kG# ^ ~  ( GX{G  ~ ^( ( c  .  .   UJTJC0Jv0JF >F  >     r0`B  rs" `  `b#    . .GJW
JFB_  #    !11 B  !1"?G ] ] }  ( 0 #k 0,  
 P. q" .
 . HR
@JJU
J 2DF  C C D   4Gk P. 0  . " q. ,AJTJuJ@HTF`FSF @ 4Gk  0,  . 0H J1DCkG#4G^~޴ >GG^#JG  ~  b#_G CCb# GGtGO_ D-    G CC   b#GGC"Gi_   GG  !)v`H_GC  TG0b#_ b#   .  . JQ JF	F   `.    C `J_0@	@ !GG4G  b#	_G]]}ݤ =#k#0v J  ~?F G ^{#_G ]   #k        p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK B                                                                                                                                                                                                                                                   r                        ` $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     e      uaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G ^TGG ^  ~( G  ~GH {G4GA C G  p "GG
b#GGGW@Gb#G!_  C =G+ @.4G(  . HR@JGs#Hb#Q#JTF3F+ @>(  >_GGb#4G?_GPb#G4G_GGb#4G_G ] ]  }( 0 #k#; 4G ^GG ^ G  ~Gb#  2_GGb#_GG b#_GG b#_G ] ]   #k#4G ^G ^ ~  G  ~Gb#G/_G0b#G4G_GGb#4G_Gb#G4G_G ] ] }  0 #kG#TG ^ ^ ~  ( GG#v J?F  ~G0b# C C_Gb# C CTG_G b# C CTG_GPb# C CTG_G ] ] }  ( 0 #kG#4G ^ ^ ~  GG#v J  ~Gb# C_G Cb#4Gj_G@b# C4G`_G Cb#4G_G ] ] }  0 #k0 #C0 ^   G8 G  ~G( ^4G  G@b#_G Cxb#G4G_G Cpb#G4Gz_G Cb#G4G~_G( ]0 ]8 @ #k        p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#G ^TGG ^  ~( 0 G  ~G 4GH {lAӀbtG"GGG  G	  .@b#GG 
@GGb#_` BG  Gh btG@ZkG4GPb# C׉_ D  "G Cb#tG.@GGG
@Gb#G͋_   c7  .4  .4   aHQ!JraHPJ3F7  >F4  >  G[ .X .HVJwHUJF[ >FX > ] ]  }( 0 @ #kG#4G ^G  ~ G   H{#_G ]   #k C[4   ۦ4 0,7 0. HQ
 J 1D  X .[ .JU
JF  kG      .  . JS
 JQ JSF0@B@JP Jr@J3F  >F   > Gk      .  . JQ
 JF CC @ .01 B  `. Ju JTJS`JFuF >  `> GkG      . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    @.     .JsJRAJQ!JTF3F @>  > GkG(     .    @.!JR
AJ 2F   GkG8     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > GkH    @. J  .s JR@JQ JTF @>3F  > GkX     . @. JR
@J 2F   Gkh     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkGx    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG   ,  .,   /  .JS
!JQ!JSF0@BAJPJrAJ3FF/  >,  > GkG   / @.,   ,  .JsJRAJQ!JTF3F/ @>,  > GkG#C  ~   TG8 ^@ ^H ~P 8  .G; @.GG JR
@J4G2F CG [ @Zk
  "GBTGb'@GzZk G  ] G = A@  #G8 ]@ ]H }P ` #k   0  .3  . JS
 JQ JSF0@B@JP Jr@J3F3  >F0  > Gk   3 @. J0  .s JR@JQ JTF3 @>3F0  > Gk  #C  ~   TG8 ^@ ^H ~P 8  .G; @.GG JR
@J4G2F CG [ @Zk
  8 "G( BTG0 bGzZk G
 G ] G =  = A@ B!0@  #G8 ]@ ]H }P ` #k8     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > GkH    @. J  .s JR@JQ JTF @>3F  > GkX     . @. JR
@J 2F   Gkh     .    @. `"J!JR
AJvJ2F C0@   . .UJTJF >F > Gkx    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG   4  .4   7  .JS
!JQ!JSF0@BAJPJrAJ3FF7  >4  > GkG   4  .4   7 @.!JR
AJ 2F   GkG   8  .;  . JS
 JQ JSF0@B@JP Jr@J3F;  >F8  > Gk   8  .; @. JR
@J 2F   Gk   <  .<   ?  .JS
!JQ!JSF0@BAJPJrAJ3FF?  ><  > GkG   <  .<   ? @.!JR
AJ 2F   GkG(   @  .C  . JS
 JQ JSF0@B@JP Jr@J3FC  >F@  > Gk8   @  .C @. JR
@J 2F   GkH   H  .K  . JS
 JQ JSF0@B@JP Jr@J3FK  >FH  > GkX   K @. JH  .s JR@JQ JTFK @>3FH  > Gkh   H  .K @. JR
@J 2F   Gkx     !.# A.!JT
AJRAJtF0`BaJQ!JsaJTF# A>3F  !>     .# .$  #$  /$  "'  ,JW
J8KA
8HF!G C C5@
  ' @.$  .JsJRPJQ0JTF3F' @>$  > GkG      .#  . JQ
 JF CC @# .01 B  `. Ju JTJS`JFuF# >  `> GkG      .# @. JR
@J 2F   Gk   ' @.$   $  .JsJRAJQ!JTF3F' @>$  > GkG   $  .$   ' @.!JR
AJ 2F   GkG   L  .L   O  .JS
!JQ!JSF0@BAJPJrAJ3FFO  >L  > GkG   O @.L   L  .JsJRAJQ!JTF3FO @>L  > GkG   L  .L   O @.!JR
AJ 2F   GkG   P  .S  . JS
 JQ JSF0@B@JP Jr@J3FS  >FP  > Gk   S @. JP  .s JR@JQ JTFS @>3FP  > Gk   P  .S @. JR
@J 2F   Gk(   T  .T   W  .JS
!JQ!JSF0@BAJPJrAJ3FFW  >T  > GkG8   T  .T   W @.!JR
AJ 2F   GkGH   X  .[  . JS
 JQ JSF0@B@JP Jr@J3F[  >FX  > GkX   [ @. JX  .s JR@JQ JTF[ @>3FX  > Gkh   X  .[ @. JR
@J 2F   Gkx   \  .\   _  .JS
!JQ!JSF0@BAJPJrAJ3FF_  >\  > GkG   \  .\   _ @.!JR
AJ 2F   GkG   ` !.c A.!JT
AJRAJtF0`BaJQ!JsaJTFc A>3F` !>   `  /c  ,d "d .d  "g . KA
 HJW
J!GF C CB  g @.d  .0BJRPJsJQ0JTFg @>3Fd  > Gk   `  .c  . JQ
 JF CC @c .01 B` `. Ju JTJS`JFuFc >` `> GkG   `  .c @. JR
@J 2F   Gk   g @.d   d  .JsJRAJQ!JTF3Fg @>d  > GkG   d  .d   g @.!JR
AJ 2F   GkG   (  .+  . JS
 JQ JSF0@B@JP Jr@J3F+  >F(  > Gk   + @. J(  .s JR@JQ JTF+ @>3F(  > Gk   (  .+ @. JR
@J 2F   Gk     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk(    @. J  .s JR@JQ JTF @>3F  > Gk8     . @. JR
@J 2F   GkH   h  .k  . JS
 JQ JSF0@B@JP Jr@J3Fk  >Fh  > GkX   l !.l "o A.0JT
PJRPJtF0`BpJQ0JspJTF3Fo A>l !>   l .l "o .p  /s  ,JW
J KA
 HF!G C C5@
  s  .p  .JrJQ JP J3FFs  >p  > GkGh   l  .l   o  .l `"JQ
!JF CC @o .!1 @l .3Hv3HUJTJFFo >l > GkGx   k @. Jh  .s JR@JQ JTFk @>3Fh  > Gk   h  .k @. JR
@J 2F   Gk   l  .l   o @.!JR
AJ 2F   GkG   s @. Jp  .s JR@JQ JTFs @>3Fp  > Gk   p  .s @. JR
@J 2F   Gk   t  .t   w  .JS
!JQ!JSF0@BAJPJrAJ3FFw  >t  > GkG   x !.{ A.!JT
AJRAJtF0`BaJQ!JsaJTF{ A>3Fx !>   x .{ .|  #|  /|  "  ,JW
J8KA
8HF!G C C5@
   @.|  .JsJRPJQ0JTF3F @>|  > GkG   x  .{  . JQ
 JF CC @{ .01 Bx `. Ju JTJS`JFuF{ >x `> GkG   w @.t   t  .JsJRAJQ!JTF3Fw @>t  > GkG   t  .t   w @.!JR
AJ 2F   GkG    @.|   |  .JsJRAJQ!JTF3F @>|  > GkG(   |  .|    @.!JR
AJ 2F   GkG8   x  .{ @. JR
@J 2F   GkH     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > GkX    !. " A.0JT
PJRPJtF0`BpJQ0JspJTF3F A> !>    . " .  /  ,JW
J KA
 HF!G C C5@
    .  .JrJQ JP J3FF  >  > GkGh     .     . `"JQ
!JF CC @ .!1 @ .3Hv3HUJTJFF > > GkGx    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk     .    @.!JR
AJ 2F   GkG     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    !. A.!JT
AJRAJtF0`BaJQ!JsaJTF A>3F !>    . .  #  /  "  ,JW
J8KA
8HF!G C C5@
   @.  .JsJRPJQ0JTF3F @>  > GkG     .  . JQ
 JF CC @ .01 B `. Ju JTJS`JFuF > `> GkG    @.     .JsJRAJQ!JTF                                                                                                                                                                                                                                                   s                        Hp $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     v      3F @>  > GkG     .    @.!JR
AJ 2F   GkG    @.     .JsJRAJQ!JTF3F @>  > GkG(     .    @.!JR
AJ 2F   GkG8     . @. JR
@J 2F   GkH   D  .D   G  .JS
!JQ!JSF0@BAJPJrAJ3FFG  >D  > GkGX   D  .D   G @.!JR
AJ 2F   GkGh     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gkx    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk       .  .   JS
!JQ!JSF0@BAJPJrAJ3F  >F  > Gk     .    @.!JR
AJ 2F   GkG     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG     .    @.!JR
AJ 2F   GkG     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk     . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG(     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk8    @. J  .s JR@JQ JTF @>3F  > GkH     . @. JR
@J 2F   GkX     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gkh     .  . JS
 JQ JSF21@B@JP Jr@J3F  >F  > Gkx     . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG     .    @.!JR
AJ 2F   GkG     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk    @. J  .s JR@JQ JTF @>3F  > Gk(     . @. JR
@J 2F   Gk8     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkGH    @.     .JsJRAJQ!JTF3F @>  > GkGX     .    @.!JR
AJ 2F   GkGh     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gkx    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG    @.     .JsJRAJQ!JTF3F @>  > GkG     .    @.!JR
AJ 2F   GkG     .  . JS
 JQ JSF0@B@JP Jr@J3F  >F  > Gk    @. J  .s JR@JQ JTF @>3F  > Gk     . @. JR
@J 2F   Gk     .     .JS
!JQ!JSF0@BAJPJrAJ3FF  >  > GkG      .    @.!JR
AJ 2F   Gk            #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #kp#X>  @ h  ~ ^^~ (޴08@>HG`>G{z   ,H`G  Hb#GX_P4Ghb#  8 D    h@  C
  TG Bh=h"b C rZk  \ÀBCbG CTGjZkh  .`]8 D  J_`8 F4 F`] 4G`G`ݠp CG  BD( b4  =# C CtG{ZkG C0b#G4G_H 4G v H= @$  GG)v ICb# CGTG@ DG  @ =="b# CP D   CTG2!@G  "b#4G4GGGG4_H =4 A v I)v I		@DT  Gb#C4G\_P B=!Q@X b C CGGtGsZkB Cb CGTGWZk  B!( b C C CtGzZkG	C0b#G4GÏ_H =4G)v I= A+  G)v I Cb# CGTG@ D  @ =b#P D  $D"DaF   C@  G= b# C CTG @G  "b#4G4GGGG4_H =4 A v I)v I		@  #,R #H`4G8 C
  Gb#G4Gz_G=!pb# C4G._	 G"!B CbTGGiZk8  BP@b C(v IG8 E-  h=TG	8 E  iZk ÀB!	Cb CGTGiZkB=!(Z@b CGTGWZk  B 
=!!( b C C CtGKzZkGxb# C4G@  " B CbTG@)! CqZkPD   #-#Iy`	8 EX G  8b CG,A B CbGTGpZkB} Cb CGTGxiZkB=! b C CTGJWZk@B} Hb C CTGwZk0  B4G b  	  PZk  4GBb   0 IjZk% Ť)v I&vH!  b4G Bb
c  CpZkGC0b#G 4GI_Gb=!8bGA B0  C(bGkZkP B
c X b C CCGGGGGGGrZk  B} ( b C C CtGyZkG b# C4G#_ }.  C ]. = HGSaJ`|b#$HtHRAJ %uF }>@ CTF ]>0vH ѐHGtG@ D   Bb4G
! CkpZk G =!  b C CGGtGG@ D  Gb C CGGtG4GGs@ D	   B4Gb
! CJpZk GG	!Chb C CGtGuA D	  " B4Gbp
!  C6pZk GG Cb#G4G_   ( = C CXb#
 @l  @ }. ]. C ="GHh bSqJtHRQJuFTF }> ]> CG4GGGAG b C CGGtG4GG&@ D   Bb4G@
  CoZk G~ CXb C C CGGGG`AG Cb CTG@G Cb C  TG@ ]. =. C = GHh bRAJsHQ!JTF3F ]> => CG4GGG]AGb C CGGtG4GG@ D	   B4Gb
  CoZk GB Cb4GhZkGC  } b C C G CG@G Cb CTGV@   G ]]} (ݤ08@=H#k .WJ Fx #.`]Q#J0F8 F4 F`] .PJF2 -HI		EG  #  ~^^~ (   ,GGG H*  8 D(   b#w @ӡ`@   G GCGGb#4G  v H  k_ CGb#c @ 4G  `@   G G0b# @G]]} (0#k  .Q J!Fð# jC( ^G0 ~TG8 @ H G  G  ^G@ [  ~H { CrZk C	 " B4Gbp	!  C(oZk& Gp BP@!@x bGGCGGKZk` B Ch bG4GvZk D    % !"D?	 G0 BG8 b4G1ZZk8  G0 BG8 b4G)ZZk GG  ]( ]0 }8 @ H P #kG# ' ^ #0 [4G ^ ~  ( G  ~G8 {G>C ChZk  @   . # P J >"TGbBb#B CfgZkB H@b CGTG/rZk C	 "pB CxbTG	!  CnZk   B   ?&( b C 1"GtGsZk  " CpBTG  	! xb C D  nZkBbG4GYZkG ] ] }  ( 0 #k#  C ^TG( [ ^ ~  G  ~GG C0 {G"gZk8 B C@ bGTG^VZk	  X BI@` b CGTGTZk	 G( B 0 @J@0 bGGTG
gZkG ] ] }  0 #kG# C  ^0v JGG( ^TG0 G  ~Gxb#(@DG?  b#CCTG_ ] GC5  1AH2u B
QB&  % @GT @ }4J  0 @tBW @  7J 0 @F. wBZ @  :AK 0 @zBF&   ZP @0J 0 @F  @pB3H  !@	rBF    G ݢW @7J } 0 @B@  ֢vG _ G D @G  ] H( ]0 @ #Hk G#TG ^G ^  ~( G  ~GG >( {4GGA     .   .`Hr`Hb#Q JP J3F  >F   >  " D  /J .yJXKWJGGF  ?G >  "4G4GTGG1_G ] ]  }( 0 #k# P"  ~TG ^{# G  0, 0. p. .0HQ
0JrJT
J 1D  CtF CG_G ]   #kG ; 4G  k# hC ^GG ^ ~  ( 0 ޴8 @ G  ~GX {GGGGGA  B C( bGTGmZk0 G  BTG( bX	  CmZk	 0   BG( bG8	  CtGmZk  B8  ( b C4Gy@mZk y@ 7@ 0 \@C  kG0 "4G!  C G0 4GX  C G0 ¤4G   C G0 4G  C G0 4G  C G0 ¤4GX  C G0 4G  C G0 4G  C G0 ¤4G  C G0 4GH  C G0 4G   C G0 ¤4G  C G0 4G  C G0 4Gh  C G0 ¤4G0  C G0 4G  C G0 4G  C G0 ¤4G  C{ G0 4GH  Cu G0 4G  Co G0 ¤4G  Ci G0 4G  Cc G0 4GX  C] G0 ¤4G  CW G0 4G  CQ G0 4G  CK G0 ¤4GP  CE G0 4G   C? G0 4G  C9 G0 ¤4G  C3 G0 4G  C- G0 4G8  C' G                                                                                                                                                                                                                                                   t                        
 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           0 ¤4G   C! G0 4G   C G4`@0 
 8`D `4G    C 0 4GX   C G0 b4G0 c  C G0  GTGG  B( blZk  B( b C4GlZkG ] ] }  ( 0 ݤ8 @ P #k                kG#4G ^( [(^0~8G  ~G  C0 {eZk@ =G8 BF  C?D@ bt @2J16>H2AJTG2F =a@ =G GtGSZk#v`HH B$P bC  `@C G =GTGdZkG ] 8 D(]C0}8@#k   GkG ;F  !0@  !. !J $Dk(  kG P. C p" , . " SJ . 0 xVJW J HF > 0/ "?F 1, " 0K q# JsJA ;H "qF3D 1<  Ң HF DpFwHVJFW C  Ҳ  GkG Ң0 H GFF ҲkG  C#q D  ~ ^33?  p D  v7HGUJF  WBb  / 0#  , @# " KA :HsK "3D  < # . @# .G D  /JVJF5VJY 7KJaJ "!G  ? p. " D . xJvzJT J  [ p"F > 0, D  / 5Hx7HY 7K8G  ? . .  ZJVJF4׀JtB TC 4  . .z 4#YJ JW J4 CxKvYJF >} t.  z . J 1 SyJPJzFF} t>z >xH . CGQ" {#GW JGF >G@G ]  D  #k 0 HFF # C ^Q"GG  ~G GX{#@G ]  D  #k#0J ^GGTG  ^( ~0 8 @ ޴H G  ~G X {4GqAG  GG? GCb#G4GJD_D0 "4G }G3    $# .&v`J  .JVJ  QwJUJF >F  >D D/{YJ@ CZ YKTG[G D?Ghb#@DGG  b# CGTGS@DG   B4G b 'kZkGb# CGTGE@ G  `Gx bG4GXAG ] D  ]( }0 8 @ ݤH P #kG# C0 ^ CGTG8 ^@ G  ~G( >8b#G@D
  ( ]  BCG( bGGtGnZk GG0 ] D8 ]@ P #k#0J  ~C ^aS J(G 0v JGTG {# vH  D 1	@G ] D(0#kG#0J  ~q J ^aS J(_" 2FJGC {#G vH0v J  F D @ GTG	@G ] D(0#kG#0J  ~q J ^aS J( _" 2FJGCX{#G vH0v J  F D @ GTG@G ] D(0#k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k Gk Gk   GkG Gk           GkG ;F  !0@  !. !J $Dk#Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k# ^ G  ~G ^{#' @  GG@b# CGtG4GG_Gb#Gx_H BP bG4GwZkG ] ]   #k#Q"  ~`{# G ^8@G ]   #kG@#4G ^   tG ~  !v H ޴  GG  ~Gx ^G  [    C{GmZk@G4Gb#Giw_ Gd $ _   .
 `" @. "  # JR@J2F1" 
 . .JUJF" .  /GGJXKF" @/ `/YK[yK[GZ#@( @.)  .@JQ J2   QFR"@@G  /
 4# . 4"  KWJG   
 t/ T/0ByKZYKzG ` T.0B .QJPJPF @ t. .0B`JWJwF `( /0B) 4/KY4K2 "G  B0B_H BBUBbC@p"G CTGtGkZk $. $  .HrHHQ!JGPJb3F $>F > 4 @  " C4G̎^GFHCBGbTGX   CtGkZk4 @H"G G4GP! b C^ , d  ,4GBHF
HbD C9eZkG%GQ?"b#@  H"GG CbTG!  C^ , $, d B4GHbA
#HD CeZkBGb4GeZkH4GGGvb#GG   CGGG)A HGd = `Dp n?"` = . " .C BCJbV
Jl }Gh }F CGtGtGFiZk 4 @G   b C4G\^ ,   $,4GBHA
%HbGD CdZkBGb4GdZk  $,   .4G BG HbP
 JtG0D CiZk4 @ H"GGbTG!  C3^ , , d B4GHb@
HD CdZkBGb4GGdZk GHCBGbTGp   CtG4kZk .   $,HqHHPJGA%HbF >1D $<4 @G `P" C4G^G{ qDQ?   QpDs4HRTJ CSF  QWB| `G( ]BG tGC }, GbC  G4 tG8   < }GlZk  Hb4GGbc  C׍^ d, ,4GBgH@
Hb`D C[dZkBbG4GVdZkC G, } D" ,   $,tG	 .rH d.urHpbHA
'HGTJH bSrJP "DFuF	 > C d>G*`^G  H4GG d b  C^ ,4G ,BHb@
HD C&dZkBGb4G!dZk Q"b#M@
  Hb4GGGbc  C^ GGx ] G ] }   ݤ   #k Q0 H_FSF Q~@#4G ^ ~   ޴  GG ^#JGG  ~  Ȫb#u_  4GP¤G0 BtG   8 b C!v H     GkZkd  G0v`H_  A.
 " a. " A#AJSaJSFPF @
 . .JVJFF  / !/GKY7KGGG   a/ a.zKSzJsGpG `( A.) .AJTJ2 ! TFPF @ @G  /
 W# w. W" "KSwJG   
 w/ .0BzKTJtG ` 7.0B 7,2JA2H!F   w. /0BvJXKxF `( .0B) W/JZWK2 "F B0BXF  G G$vH¦ BB ?&b8D 1"RB"TD@E  p"C CGtGiZk &, ,  HA'HqHDH2D &<D <4 @G `G GBGG( P  H }CL GbC@  tG0 T  CX ݲG\ tGwkZk  Gk L  & 	 &. .HQ!JrHPJ3F	 &>F > qDpD   pqHA1H0DW B   g  T CBGbtGX" CiZk &, ,  HA'HpHDH1D &<D < 4 @  G= 	 .G . "TJ0 BVJ8 bwTJUJCFF	 >G >GGtGjZkG = PC V`H$  .C .r1`H  H  G/ " @F{HZGKJ[G  G?V
J@ BCH bF CGGtGaZkG4G(bG  CM^ GG  4GPb#t_G ] G ] }   ݤ   #k  0`H?D0D  #4G ^ ~  ( 0 G  G ^GG#v`H  ~  b#t_ӠGd     . %.b#JQ%JFF)  
 e. .
  eJTJtFcF! `
 . .
  JWJFF 
 %/ E/
  %KZEK:GG#G  
 %.4G .
  %JPJ0F  #F  
  @?t_ G$  %, e  .4GB#HP
JbG0D CpbZkqD  pD  !Q2J  !W@B @	 . e" .sHGvsHUJb#TJFF	 > >4Gqt_ GG ] ] }  ( 0 @ #k !?F !G# 0v JX ^` ~h G  ~GP ^Gd     #. C.#JRCJ2F0F%  
 . .
 c JUJFF 
 . /
 c JXKFF 
 C/ c/
 c CK[cK[GPG
 @
 #. #,
 c #JA#H!F0F  
 c `@ GV ï"0 B  8 bGaZk . # 	 #. Cp BGJ  BQ
!Jx bGF@ " CGkZk8 D"< `GbGX!  CTGd^ G4 0 BG  ` "8 b@ =D `ZkG0 =G( G   C C$ =C  =G }8  #"H C C.C c.tGP BQJS
qJX bG SF CGiZk
  bGGbTGc  C1^ G  GGP ]X ]` }h p #kG`#Gp ^x ~0v J   ޴   ~Gh ^G @G  G ` C  . .JVJFF( P@0 @  / %/KY%KGG  P@0 @  e/ E.eKREJrGpG `P@0 @  . .JUJFF
 P@0 @  %/ /%KXK8G0G  0 @2U!@P@_X!D @G G"bC  G@  E#  {C  TG ;B\ } CD H =G .	 e.H bJS
zJ@ BF C/nZk
  H"GGTGbG!  C^Ӓ P BGX bdZk C8  %. "	 E.C  BTG0J( bR
PJ2F CG{mZk8 D
 H"GGbTG!  CG^s D   p  !@ }A2@@G 0 = %# E/C e/C  GYK [
yK( [G0 B8 b CGtG=oZkG  ¤GHTGGP@  &"b C!DI  q^BbG4GbZk  Ơ4GHGG8D- x  b Ca^ , %,   B4GH bA
&HD CgZk DH¤  Bb4GP  CbZk  ,   %,G` BTGHh bA
&Hp  D CqoZk  B Cb4GsbZk G ݠH4GG8D   b C-^G, ݠ  ð GGh ] Dp ]x }   ݤ  #kG`#PGx ^ ~  G  ~Gp ^G$v J  . .JVJFF(  P@0 @   /  / KY KGG   P@0 @  `/  .`KP JpGdG ` P@0 @  . .JUJFF
  P@0 @   /  / KX K8G$G  0 @0U!@ P@X!D@ b]  D# @G  {  #H CL ] ;B CP =d }G  .	  ,0 BJA
9H8 bTGF CkZk8 DD  GTG" C; î$    4GD  GG  &( }                                                                                                                                                                                                                                                   u                          $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        \ "            " G =G$ }C0 =4   #< ]C@ =G @/TG  ,X bXKA
8HAGP B CHtZk  GG( bTG  C^p BP@x bG4GaZk` b4G  c  CD G( b^GGp ] Dx ] }   #k 0 q3@	    BG     Q@G ?DkG#CX^[X  `^Gh~TGptGxG  ~GG{ CpfZk4 @G   G5 GB "0 i"C( }C4 ]GbG, GtGtGdZk 4 @B  bG4G_Zk G GBGb4G_ZkD   Ch_B Cb CD GtGlgZkB`@CbGGGtGcgZk GGX]`]h}px#k#(CP ^[p  X ^  C` ~0Jh Gp G  ~GH G{TGtGfZk4 @G  G G( CH =GBC2Js Jn?#SF( G@  GD G8 =tGbtG< GcZkB 4 @b DG4Gd_ZkGP ] GX ]` }h p  #kG#`0JX ^[p  ` ^  Ch ~Cp tGx G  ~GH >TGP G{GeZk4 @G  ) G( CP =GBC2Js Jn?#SF( G@  GD G8 =tG btG< |cZk 4 @  G	 ( BPCH G0 bGtGfZkGB bG4G_ZkGX ] G` ]h }p x  #kG#C@ ^([p  H ^GP ~TGX tG` G  ~G8  C0{GeZk4 @G   G8BG0 	n"C( }C4 ]G@bG, GtGtG6cZkB 4 @G b DG4G^ZkG@ ] GH ]P }X ` p #kG#  ;G    ~G ^  !@@ @ H  B  `. .`JTJtFpF3 `0 @  !@@ @ H  B  . `.JS`JFF' 0 @  !@@ @ H  B  `. .`JTJtFpF `0 @  !@@ @ H  B  . `.JS`JFF 0 @  !@@ @ H  B  `. .`JTJtFpF `0 @S!@X!D @G ] G  0 #kG !@`[A4@h{!!H G!B a" .G A.n?  tGJ R
SJ =C F CGtGbZk 4 @GG ] D  0 # Gk#C@ ^p[p  H ^GP ~TGX tG` G  ~G8  Cx{GdZk4 @G   GBG0 n"C( }C4 ]GbG, GtGtGbZk`B 4 @Ghb DG4G.^ZkG@ ] GH ]P }X ` p #kG#C@ ^[p  H ^  CP ~0JX G` G  ~G8 G{TGtGdZk4 @G   G GBTG0 n"C( }C4 ]GbG, GtGtGLbZk4 @B Gb DGG4G]Zk GG@ ]H ]P }X ` p #k#C@ ^[p  H ^GP ~TGX tG` G  ~G8  C{GadZk4 @G   GBG0 n"C( }C4 ]GbG, GtGtGbZkB 4 @Gb DG4G]ZkG@ ] GH ]P }X ` p #kG#(C8 ^[p  @ ^ CH ~GP tGX ` G  ~G{GTG%dZk4 @G  GJ  #. C C" . 2J p"u3JT J "F > 0# . #  /  F P/JXKq FF7VJZ YKJ &{Js"[G P? ,p FF P. HxwJqHR EJ CQF P>  բVJFWB  ղ%   P/ 0#b? Z YK P?n BG0 =C4 }G( tG, }tGaZkB 4 @bG DG4GGF]ZkG8 ] G@ ]H }P X ` p #k բ0`JFF ղ`#Cp^x~X  tG޴G  ~Gh^G@ ^GY  0 [8 { CTGcZk4 @G   GP G@ B "0 i"H ]"( C4 ]GH bG, GtGtG\aZk 4 @  B  ( bG4G]Zk G6 G  BG( b4GG\ZkH  h  C 0" P.tG p.@QJS
qJSF C
  _P BCX bG C8 GTdZk  B  @0@ @ ] ?" @  r.t2JSrJtF  r>D@ ݢ  "   .xJWJF  > GGh]p]x}ݤ#kG r.
2JS
rJtF r> .
JW
JF >#TG  ^i  [1!J >C  G  ~C >tG( G({tG  ~`ZkG  ]4 @ G(  D0 #kG#0 ;eC ^TG   P [ ^8!  ~  ( 0 ޴8 @ G  ~GX {GP @ CcZk C  6 b"  ¤	C
p@B~Bb 1D  F%DGGtG\ZkBGb_" @GGG\ZkBGbG 
@GtG[ZkG   ƠGGGGb# @0@ 	@ @?@ BGH b4GiKZk GG ] ] }  ( 0 ݤ8 @ P #kG#G ^ ~  ( 0 ޴8 @ H >P GG@  ^G( [GB  ~G0 {GGG[Zk0 8 " CGGG  C@ ¦( B `"  . " .B   ,G .    3J0 b J $HG JG[Zk C@ E( B0 bTG 	LGGH!C EA?@A !@!@  [Zk@	@@ A@G ] 4G ] }  ( 0 ݤ8 @ H =P ` #k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#TG ^ ~  ( 0 ޴8 @ G$v Jpۤ ^G ׀HG   ~` @{@  &G C4GA8    "G Cb#tGX!  CGGGR_GGb#o_GG H@db#GG6$JtGGGGA("GX TG  '   q Dp D  xYJWJFW C    A#q@Gp@G  @HW B   a /^ .G^ "JXKyJWJ GFa ?^ >b !"?De a/Gb A/J[qKZQKe a?b A?wJ# .G  ,$ !#{JVJ@HF D# >  <J?D' A/G$ !.xJZYKQ9J@G;F' A?$ !>J?D+ .G( .. !"WJVJFF+ >( >J?D1 A/{J. !/GZQKY1K@G;G1 A?. !?Z "] /JZ .`JGXKWJGF] ?Z >J A/{J !/GJZAKY!K@G;G A? !?wJ?D .G !.  VJQ!JF7F > !>J A/{J !/xJ4@BZ@KY KQG;G A? !?J?D . !" .{JWJVJFF > >J A/ " !/ #GZQKY1K@G;G A? !?j !#?D .W J > !.J ,vJQ8J !>@H <m a/r  j A/[yKZYKwGVGm a?j A?Ju /vJ?Dr !.X Kv !#Gu ?Q J~  6Fr !>?Dy a/ Jv A/w J[yKZYKy a?v A? a# .G?D~ !.VJFQ J >v{J7F~ !>{J A/ !/ZAK A?Y!K !??D !. A# ,Q;J@H7F !> D <?D !/z " /Y!K !?XK ??D !. # ,Q:J !>@H <} a/f A#z .1v@J[vK} a?WJz > ,{J?D !/@H < Y8K !?Ji .
$Bf .  BWJVJFi >Ff >8@?`4GG`b# Ck_ D"
  Gb# CX!  CtGGG_GGb#m_ C  G4G# #.  .Hb#Q#JrHPJ3FF# #>  >@  K .H .HUJvHTJFFK >H >|_ f4GGTG  bQ c@(A# .H  $,qH CPJGA$Hb#F# >1D  $<  gX"tGG  .G# .GJV
JF C ` C_Gb#Gm_   ƠG`BtG  ,# ,hbR @HE
HD CaZkGh bG4Gn3_G ] ] }  ( 0 ݤ8 @ P #kG 0@JFF s  D w# C ^GG4G ^  G  ~Gb#{_ӐG4GXb#   wk_G ] ]  0 #kG# ^ ~  ( 0 ޴8 @ H >P ^X ~` h p G{$J  ~ ^G  &vHGG v HG	@   4G C8b#@"G4Gb#  	ik_ӰB H"  *` @  @ +"q Fp F  rtJSuJtFWB  r ., # "q GW J >p G  YZ[KW`C  Y`e .b +,b  6 +"P JA He >b +<: "9 k.B "6 K.> K# + SqJRQJ9 k>6 K>F K"E= .: .VJUJ= >: >N "E +/GEB /Y7KE +?XKB ?EA ,J #> k/@HA <[zK> k? +.R K# .Q!JPJ +> >2 "I .F k.TJI >SrJF k>Q . k"EN .WJQ >VJN >EM , "J +/@HM <Y8KJ +?U +,  ER k/A:HU +<q D[zKR k?p D5 K.2 +.RPJ5 K>Q0J2 +> .4GuJT JF > .W J >  8Y!K  8W @( Y +.V K#V k/ K" +#Q:J[zKY +>V k??" k.2J .t2J4GSrJPJuFF k> >~ " , .@H <WJ > / " +,XKA+H ? +<TGE k/9H K/p9H[yKZYKqGPG k? K?4GE k.?" K.GTGSkJ k>RKJ K>~ . ,E +,J /@
H bA7H +< F  CXK ?  жAӁ +.~ + ~ .HrHQ!JPJ3FF +>~ >  Gx 4G Cb#@  +,TG# .+HGP
J b  -0D C  Q 1B4GA# K.  +.HsHRKJQ+JTF3F# K>G  +>  GW G  GBtGb4GR Ad`Zk - ! ,4GGI@
HPbGE C  潶Aӏ +, , !IA-HpI@
H1D +< D <B  r3v`J	fB   _F  RG  J4G2v@J @6vJ4B6J:JvBVA " /!vJ 6/ 4A
2@KY7KG{ K[GF?G4G  	-vIb#Gej_Gb# C4G_  ctGGTG(b#TG#v`HE `_DG1 8D ~ , K-~  Pb4GHJ
FI
GD C  kAӁ ,~ ,~ k IDHfIGHD <D~ <8 EG    +,# .4GPbG+HP
JkH0D C
  QA# ,  ,jkHGHFHD# <D  <EG   	b#4Gj_ GG ] ] }  ( 0 ݤ8 @ H =P ]X }` h p  #kG r0 JFtF ri Y_G Yq 8?G 80v J0 J   pB @    @. `.AJSaJSF    .vQJ GUJF  >k .
QJU
JF >0v J C   @   Gk                                                                                                                                                                                                                                                   v                        u4 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        m "           0 J[ GpB C  R0JPB p" . .JWJU
JFF
JTJvJFF > >k 0v J C   @   Gk0 J[GpB C  R0J GPB p" . .JWJU
JF F
JTJvJF >F >kG0v J C   @   Gk[0 J  . GpB  RU JPB p. " pJvJF  >kG0#0v J  ^    C( ~0 8 G@  ~G >  ^   G* G8b4GGGb#  +i_ " ݢ  H  !` @  @  "  . @.3J0JRPJ2Ft JtF
   .     . JW JxHF  > GGG  4Ghb#Ji_ GG ]  ]( }0 8 @ #kGP# ^ ~  ( 0 G   #v J  ~G C ^@$!J   G& GX4GG#`H b#  h_0cc@    @     .2?H  . "vHJQ!JGFs JSF   .U JF > GGG  4Gb#i_ GG ] ] }  ( 0 @ #kp# ^ ~  ( 0 G   #v J  ~G C ^@$!J   G* Gx4GG#`H b#  h_Pcc@    @     .2?H  . "qFJQ!JpFFs JwHSF	    բGVJF  ղW C  GGG  4Gb#h_ GG ] ] }  ( 0 @ #k բ0HGFF ղG#0v J  ^    C( ~0 8 G@  ~G >  ^   G. Gb4GG@b#  Vh_ p"   H  !` @  @  "  .3J @. "0JRPJ2Ft JtF   . .JWJF    8/zJGY8K:G  8? GGG  4Gșb#ph_ GG ]  ]( }0 8 @ #kG 8/
JY
8K:G 8?À0v J0 J   pB @    @. `.4?HAJSaJSFu@JF
   .     / JX KyH GG  ?k Gk# ^ ~  ( 0 ޴8 @ H G   $v J  ~ ^G C@G   GZ 4GG$׀Hpb#G  d@g_Ӡ¤   @     .  .2HJQ!JFs J SF P D  < ØB"b C CTGRZk    ƠG@. & 1 &.H. .rHQ!JPJ3F1 &>F. >$ GB Cb4GGRZkG0 @b4GTGAG   G(B C0b CTG^RZk  Ơ@.  1 ,. d,IaI@HCgH DaD1 <. d<GG4G  b#g_ GG ] ] }  ( 0 ݤ8 @ H P #k#0v J  ^    C( ~0 8 G@  ~G >  ^   G0 Gb4GGGb#  mg_ "TG   H  !` @HB  @  "Pb  .3J @.. "0JRPJ2Ft JtFP F  . .1 .GJW
J F  C  GRZk GG  4Gb#g_ GG ]  ]( }0 8 @ #kG #0v J  ^    C( ~4G0 G@  ~ >G  ^%  {Gb#  &g_ "   H  !` @  @  "  .3J @.. "0JRPJ2Ft JtFP F  . .1 .JW
J F  C    4GG  8b#Fg_G ]  ] G( }0 @ #k # ^ ~  ( 0 G   #v J  ~G C ^@G   G* G(4GG#`HКb#  f_ cc@    @     .2?H  ., "qFJQ!JpFFs JwHSFP D    բGVJFW C  ղ  GG  4GXb#g_ GG ] ] }  ( 0 @ #k բ0HGFF ղG@#0v J  ^    C( ~0 8 G@  ~G >  ^   G. GHb4GGb#  f_  "   H  !` @  @  "  .3J @., "0JRPJ2Ft JtFP F
  , .- .JWJF    8/zJGY8K:G  8? GG  4Gxb#f_ GG ]  ]( }0 8 @ #kG 8/
JY
8K:G 8?`#0v J  ^    C( ~0 8 G@  ~G >  ^   G. Ghb4GGGb#  Ef_ @"   H  !` @  @  "  . @.3J2 "0JRPJJ2Ft JyJtFP F
  5  /2 .XKWJG5  ?F2 > GGG  4Gb#`f_ GG ]  ]( }0 8 @ #kG0v JP
  ! J   a!@ @2 @"2 `.5 .rJT
J tF   Gkp CP0 J G    pBB B # 0/2 " 0,8KA8H!G2?Hs KSFP D  2 .5 .JU
JF  k Gk#0v J  ^    C( ~0 8 G@  ~G >  ^   G. Gb4GGG@b#  e_ p"   H  !` @  @  "  . @.3JR "0JRPJJ2Ft JyJtFP F
  U  /R .XKWJGU  ?FR > GGG  4GȚb#e_ GG ]  ]( }0 8 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGG`b#  e_ "   H  !` @  @  "  . @.3JR "0JRPJ2Ft JtF  R .U .JW
JF   GG  4Gb#e_ GG ]  ]( }0 8 @ #kG#0v J ^    C  ~( 0 G@  ~G  ^   G' b4GGGb#  ?e_ "  H  !` @  @  "  .3J @.F "0JRPJ2Ft JtF  I .F .WJI >VJF > GGG  4Gb#`e_ GG ] ]  }( 0 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGGb#  d_ "   H  !` @  @  "  . @.3JF "0JRPJ2Ft JtF  F .I .JW
JF   GG  4G(b#e_ GG ]  ]( }0 8 @ #kG#0v J  ^    C( ~0 G  ~@ >G  ^   G$ b4GGb#  d_ "   H  !` @  @  "  .3J @.N "0JRPJ2Ft JtF  N .Q .JW
J F  G4G  Hb#d_ GG ]  ]( }0 @ #kG0#0v J ^    C  ~( G  ~@  ^G   G$ G8b4GGb#  |d_ "  H  !` @  @  "  . @.3JN "0JRPJ2Ft JtF  Q .N .WJVJQ >N >4GG  hb#d_ GG ] ]  }( 0 #kP#0v J  ^    C( ~0 G  ~@ >G  ^   G$ Xb4GG b#  @d_ 0"   H  !` @  @  "  .3J @.J "0JRPJ2Ft JtF  J .M .JW
J F  G4G  b#cd_ GG ]  ]( }0 @ #kGp#0v J ^    C  ~( G  ~@  ^G   G$ Gxb4GG b#  d_ P"  H  !` @  @  "  . @.3JJ "0JRPJ2Ft JtF  M .J .WJVJM >J >4GG  b#&d_ GG ] ]  }( 0 #k#4G ^  ~( G{G ^G  ~   @b# >c_ Gp"tG(B v H  !  H =` @  @0b @YZkG4G  țb#c_G ] G ]  }( 0 #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGG`b#  c_ "tGHB  H  !` @Pb  @  "  . @.3J0JRPJ2Ft J @tFP F   GcYZk GG  4Gb#c_ GG ]  ]( }0 8 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G* Gb4GGGb#  Sc_ "   H  !` @  @  "  . @.3J
 "0JRPJ2Ft JtFP F  
 . .JW
JF   GGG  4Gb#rc_ GG ]  ]( }0 8 @ #kG# ^  ~( 0 8 ޴@ G   $v J  ~G ^ C ^@G   GQ GGE @ b4GGTG?AG   GE G = CBGbtGGXZk4GG$׀Hb#  b_d@   $@ " !.3J A.V "uH0JRPJxuH2Ft JGtFP F  Y .V .WJVJFY >FV >  @DCZ d#] $.Z D.HsHQ;JR[J4FSF] $>Z D> GGpb4GG.AG4G  (b#c_ GG ] ]  }( 0 8 ݤ@ P #k0v J# C    ^  ~( 0 @8 ޴@ H G  ~GG ^ ^   G^ 0 JG4GeBb  deBZ "Z .] .JV
JF C  AGF @@b4GGTGAG   GB  = CBGbtGGbXZk¤4GGb#  xb_   @     .  .2?HV "JQ!JtHFs JwtHSFP D  Y .GV .VJUJFFY >V >  @Z $#] d/HZ D/qH[yKZYKpG] d?QGZ D? GGGb4GGAG4G  Hb#b_ GG ] ]  }( 0 8 ݤ@ H P #kG0#0v J  ^    C( ~0 8 G@  ~G > ^  ^   G3 8b4GGGb#  b_ " =  H  ` @ B 0" P. p.4?JV "QJSqJSFu@J ]FP F  V .Y /JX
KF    !  @Z @#Z `/] `.zKS
zJsG  r GGG  4Ghb#2b_ GG ]  ]( }0 8 @ #kG@0v J C   @   Gk [0 J GpB  RPB . .JU
JF  kGP0v J C   @   Gk0[0 J GpB  RPB0J . .v0JUJTJF >F >kGp#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gxb4GGG b#  a_ P"   H  !` @  @  "  . @.3J "0JRPJ2Ft JtF   . .JW
JF   GG  4Gb#a_ GG ]  ]( }0 8 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G, Gb4GGG@b#  Ya_ p"   H  !` @  @  "  . @.3J "0JRPJJ2Ft JyJtF	    / .XKWJGF  ? > GG  4GȜb#va_ GG ]  ]( }0 8 @ #kG#0v J ^    C  ~( 0 G@  ~G  ^   G1 øb4G                                                                                                                                                                                                                                                   w                        ?~ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        e "           GG`b#  a_ "  H  !` @ @ 0" P.4J p.  C HQJSqJ @SFu@J "F   . /JZ
KXK:G0 C6KWJy6KGF ? > GG  4Gb#*a_ GG ] ]  }( 0 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGGb#  `_ "   H  !` @  @  "  . @.3J "0JRPJ2Ft JtF   . .JW
JF   GG  4Gb#`_ GG ]  ]( }0 8 @ #kG0v J C   @   Gk[0 J GpB  RPB p" . .3Jv3JUJTJFF > >k0v J; C   0 J  QpB@2  PB " .7J . C9JJVJYBFxJ: 2 FP`F" `: ,0J= .HU
JTJF0BJ@HvJF D= >: < G  10BF "F /I p.KA
wJSwJ!G0 C7KXKy7KaFGI p>F ?k Gk#0v J  ^    C( ~0 8 G@  ~G >  ^   G* Gb4GGGb#  )`_ "   H  !` @  @  "  . @.3J: "0JRPJ2Ft JtFP F  : .= .JW
JF   GGG  4GHb#H`_ GG ]  ]( }0 8 @ #kG0v J 0 J   pB C2J0J2@B a"B .E .JW
JUJF BJTJvJFE >FB >    @N  #N  /Q @.8KS
XJRXJ3D 1@8HY8Ka8HSF!GQ @>N  ? GkG@#0v J  ^    C( ~0 8 G@  ~G >  ^   G* GHb4GGGb#  __  "   H  !` @  @  "  . @.3JB "0JRPJ2Ft JtFP F  B .E .JW
JF   GGG  4Gxb#__ GG ]  ]( }0 8 @ #kG0v J00 J   pB C2J0J2@> a"> .A .JW
JUJF BJTJvJFA >F> >    @J  #J  /M @.8KS
XJRXJ3D 1@8HY8Ka8HSF!GM @>J  ? GkGp#0v J  ^    C( ~0 8 G@  ~G >  ^   G* Gxb4GGG b#  E__ P"   H  !` @  @  "  . @.3J> "0JRPJ2Ft JtFP F  > .A .JW
JF   GGG  4Gb#d__ GG ]  ]( }0 8 @ #kG0v J`; C   0 J  1pB@   0B r" .6_J . C0JJUJ0BFwJ6 #FP@F @6 0/ G9 0,8KS
8HA8HsG0`CxKY8K{xK3D;G9 0<6 0?k Gk#0v J ^    C  ~( 0 G@  ~G  ^   G3 èb4GGGPb#  ^_ "  H  !` @ @ 0" P.4J p.  C HQJSqJ @SFu@J6 "FP F  6 .9 /JZ
KXK:G91 C6KWJy6KG9 ?F6 > GGG  4G؝b#^_ GG ] ]  }( 0 @ #kG#0v J  ^    C( ~4G0 G@  ~ >G  ^#  {Gpb#  ^_ "   H  !` @  @  "  .3J @.6 "0JRPJ2Ft JtFP F  6 .9 .JW
J F  4GG  b#^_G ]  ] G( }0 @ #k# ^ ~  ( 0 ޴8 @ H G   $v J  ~G ^ C@G   G~   4GG$׀HȦb#G  d@E^_¤   @     .  .2HJQ!JFs J SF P D  ` 0 B C8 b4G9  vIZk U@  9 #,A 'H9 #< C0 B4G8 bGkIZkGH b0 @4GTGSAG  F À B C b CTGHZk  4GG b@$  $ #,G' . HP
 J 0D  ( #.+ C.G#JR
CJ2F  gAG G+ .I( #,qIPJA#HF+ >1D( #< G' .$ c"$ .IvIUJTJFF' >$ > C   Ơ$H@ # $/ 8KY 8KHGzXK:G $?GGb#_G4G  Pb#^_ GG ] ] }  ( 0 ݤ8 @ H P #k# ^ ~  ( 0 ޴8 @ G   $v J  ~G C ^@G   G G4GG$׀Hb#G  d@]_¤  @ " !. A.3J0JRPJ2Ft JtFP F   $ .$ "' .GJW
JF C- ( !/+ A/!KZ
AK:G C    ,@ H  <E HB CPb CTG2HZk  f4GG`bd@( #,+ .#HP
J0D C֩A  C  f HG `@ H+ @.s H(  .R@JQ JTF3F+ @>(  ># HB CPb CTGHZk  f4GG`bd@$  $ #,' . HP
 J0D CA  C  f HG `@$  "' @.$  .0Hs0HRPJQ0JTF3F' @>$  >  Ơ@$ "$ . C' /$HJX
K@F C ( 5/ d#+ U/5KZ
UK:G C  d, {HC {H D`H`D d<	 G  "b4G4GGGG__G  4Gb#R]_ GG ] ] }  ( 0 ݤ8 @ P #k #0v J  ^    C( ~0 G  ~@ >G  ^   G b4GGb#  \_ 4G"   HG  !` @8b#  @  " `. @.JtJSqJRQJuFTF `> @>  ]_ GG ]  ]( }0 @ #kG0v J C   @   Gk[0 J GpB  RPB p" . .6J #JUJFwJFP`F ` 0/ 0,8KA
8H!G  1kG r/   .`KU
J uG   GkG0#0v J  ^    C( ~0 G  ~@ >G  ^   G 8b4GGb#  \_ 4G"   HG  !` @hb#  @ J `. @.t JS`JR@JuF `>TF @>  \_ GG ]  ]( }0 @ #k@0v J C   @   Gk [0 J GpB  RPB . .JU
JF  kG`#0v J  ^    C( ~0 8 G@  ~G >  ^   G, Ghb4GGGb#  ;\_ @"   H  !` @  @  "  . @.3JJ0JRPJxJ2Ft JtFP F	   . .WJVJFF > > GG  4Gb#X\_ GG ]  ]( }0 8 @ #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGG0b#  [_ `"   H  !` @  @  "  . @.3J0JRPJ2Ft JtFP F   . .JV
JF   GG  4Gb#\_ GG ]  ]( }0 8 @ #kG , 0   0. " " HGsHA 0H 0J3D  0<F ,a6J . p"@ H J D < "F P.aJ " # G@ H SJ D <F , p"aSJ 0. "@ H p" D <F . 6J "a6J G@ H J D <F 0. 0  .vJ P.Q !J  6F 0> JF . SJ p"wSJU J{HF >F 0/Y 8K;G 0?k#0v J  ^    C( ~0 8 @@ ޴H P G  ~G >  ^   G` èb4GGGPb#  _[_   H  $e @%@ " !.3J A.0JRPJ2Ft JtF  B Ì . " .4GGJW
J bF C  樧A  C  Ġ HG @  " @.0H  .s0HRPJQ0JTF @>3F  > 4GGGbTG G]AG    = C8BG@btGGQZkGR_   C%H@   , D/HaH@HZFK DAG < D?GG4G  ؞b#G[_ GG ]  ]( }0 8 @ ݤH P ` #kG#0v J  ^    C( ~0 8 G@  ~G >  ^   G( Gb4GGGb#  Z_ "   H  !` @  @  "  . @.3J "0JRPJ2Ft JtF   . .JW
JF   GG  4Gb# [_ GG ]  ]( }0 8 @ #kG# ^ ~  ( 0 ޴8 G   $v J  ~ ^G C@G   G? 4GG$׀Hb#  Z_¤d@Gpb4G   @  .  . JQ
 J F  C  GA  BtGb @`H  .  .r`HQ JP J3F  >F  >	 `   c  CBBGGWPZk	   ƠGBG btG@@iPZkG  4G(b#Z_ GG ] ] }  ( 0 ݤ8 @ #kG#0v J  ^    C( ~0 G  ~@ >G  ^   G( b4GGb#  @Z_4G =G   ! H  a!@ @Hb#  . @. JR
@J2F C  nZ_ G  = CBGbtGGPZkG4G  Hb#_Z_ GG ]  ]( }0 @ #kG9Jp#8 ^@ ~H P X ޴` h p >x ^ ~ G   %v K  ~0 ^G C@GGG   G C CGb#@DG @ =q KGCCH b0?HTGF =GGQ%AG C b#G4Gy%_ӐG4G8b#  Y_hB נH( bCi @  * C0aI0@ !" A. a.QJUqJS
qJFTF
JRQJtJuFTF a> A>G  ʢG  BB " /X K ?  *)C CGtGOZk  
  = 	@
  " @.0H
  .s0HRPJQ0JTF @>3F
  >  B, "qFpF  yHXKG  W@Cj    j N@` B CGiC2 ; 5 {.2 [.HtHSaJRAJfFTF5 {>2 [>TGh b+aICZk    G@. $ 1 $.H. .rHQ!JPJ3F1 $>F. >( GB Cb4GDZkGb0 @4GTGAG  G  4Gb#GY_  B Cb CTGDZk  J	IA.  1 i,. ,dI`dICdHFHaDD1 i<. <4GG  b#Y_P BGb#  J*v@I
8@E @B@ DG0 ]8 ]@ }H P X ݤ` h p =x ] }  #k 0HGG # ^ ~  ( 0 G   #v J  ~G C ^@   G. B1`H4GGq1B  R  b# QBY_ Cb#0 @ $ q D   0p DrHQ3J2FW`B  0 @9 .6 .6 "G4GVJ9 >UJ6 >  b#1Y_ CHb#N@G C0 b4GA GG ] ] }  ( 0 @ #kG 00 H?F2F 0#4G ^ ~  ( G  ~#v J( ^G `HG  ` @{  B. $ . ,1 .HP
JD C
  #A1 $.. . G. $ HQ!JrHPJ3FF1 $>. >$ "$ .4GD' .JGbV
JF C  
A' $. G$ .$ $ HQ!JrHPJ3F' $>F$ >                                                                                                                                                                                                                                                   x                         $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        Tt "           D( .4G+ .GJV
JbF C  A+ $. G( .HrHQ$JPJ3FF+ $>( >Z "Z .4G] .GJbV
JF C
  ۤA] $.Z . GZ $ HQ!JrHPJ3FF] $>Z >4G . .GJV
JbF C  ĤAӓ $. G .HrHQ$JPJ3FF $> >f "f . Ci .TGGJV
J8 bF C
  ,Ai $. Gf .f $ HQ!JrHPJ3Fi $>Ff > . " .@G4GJb#V
JF "_  $,TG# .G$Hwb#P
J0D C   C@` bG  $,tG# .  c$HP BP
JX bR c@0D CNZkG ] ] }  ( 0 #kH#4G ^    ~   v H( 0 ޴8 @@ H >P ^FX ~` G ^GGG  ~G  G(b#GGW_  $,	4GXBA $H  $<9 0v I  *5I0 J;vHpB0B P" p., # .. 0 rJTJtFv`JFP`E" , 0/- P/8KZXK:G;GG  . 0.1 P.GHb#tG!JR
AJ2F C4GR]_    .G JS dJ4 BtDJ@tF  d>  .w0IV JF  >	4 A8v I
CG  4Gb#W_G ] ] G }  ( 0 ݤ8 @ H =P ]X }` p #k# ^ ~  ( G  ~G ^G?    #,GG4GHb#A#H1D  #<  W_h4Gx"   !v H   3v J  8_J3`JssBB " . .JWJFyJG @P@F	 @Q`DP`D  JUJ4BwJF    4 B8v J6vJ
CG4G  Рb#W_G ] G ] }  ( 0 #k #,GA
#H1D #<# ^ ~  ( 0 G  ~ ^GGGI    $,GG4Ghb#A$H2D  $<  0W_ӈ4G"   !v H(  3v J  8_J3`JssBB " . .2 s#JWJFyJQDGP@F @2 3,PD5 .;HT
J4D C#D    KXK4 Cy6KG    @4 B3v J:v@K
zBG4G  b#=W_G ] G ] }  ( 0 @ #kG $,GA
$H2D $<p#  ^( ~0 8 @ ޴H P X >` ^h ~p x  G   %v J ޢG C  ~@ ^GG&!JG(J)J   G(G B4GG%נHȡb#G  
e@V_bGCPb#4G   @^   ^  .a  .JQ
!J F C s `G_ D    + C1!J GTG1@Hb^ A"a .^ a.JuJTJSrJFuFa >^ a>4GGʢA
G  G   
.qH M"tHP 
JTGF  
>
E m. 
#G!'HS rJ m#tF m>0H  k;H
E -/eA   .a;H .Y 8KJJVJpJFb#PF4F m"zJeI:G -? m!
 -u+I
E 
,EE
 = M" DG D 
<
E .G ,T J HF >
E .yHV JF >  /X KG  ? TGa_DG GGb4GAӕ G4G G(b#^_G4GHbGTGfA
G   G  
.qH M"tHP 
JGF  
>
E m.8K ":HS rJKtF m>xK
 .UK
E .zUKFF
 >FF > 
 
E -a I  q&IL ITGE =
E 
.P JF 
>  keA   E. e.GJSgJSFP@F4@FG_DGEXb# C GTGj_ DG   b#4G , ! H	A  4@<_DG G G GG TGb#G_ D  GbG4G.A GGGEb#	  GTG_DG G  m- -!eHGaHb#K iIGeE m=  -H IE  =_G  
4GPb#U_ EG ]  ]( }0 8 @ ݤH P X =` ]h }p x   #k8# ^  ~( 0 8 ޴@ G   #v J  ~ ^G C@$!J   GU @4GG#`Hb#D  cc@uU_G4GHb#    @^   ^  .a  .JQ
!JF C7 `G_GCxb#GGTG܎_ D,   =4GG8b# . !" JF  G_ D  G  xb# CGTGƎ_ D GG4G GbAGGXb#4G ʎ_DGG b#Gc_ tGG  4Gpb#jU_ DG ] ]  }( 0 8 ݤ@ P #kGX# ^  ~( 0 8 ޴@ G   #v J  ~ ^G C@$!J   G_ `4GG#`Hb#tG  cc@U_8    @^   ^  .a  .JQ
!JF C `D GGGhb#4G_GCb#GGTGf_ D  tG3 D =  . JF    a. " tJX`F
 x`F `GGXb#4G/_ D   G4G Gb.AGGxb#4G ݰT_DGG
  (b#G_GCb#GGTG2_ DGG  4Gb#T_ DG ] ]  }( 0 8 ݤ@ P #kG# ^  ~( 0 8 ޴@ H G   #v J  ~G C ^@   G` à4GG#`HHb#tG  cc@T_x   @^   ^  .a  .JQ
!JF C E GGGb#4G_GCb#GGTG_ D  tG4 G4G GbƠAGGb#4G _DGG
  hb#G_GCb#GGTGʍ_ DGGDb#  G4G_ C  #aHG@^  a .H^ #,qHP JA HFa >1D^ #<G4G  Сb#mT_ DG ] ]  }( 0 8 ݤ@ H P #kG#  ^( ~0 8 @ ޴H G   #v J  ~G ^ C ^@$!J   G\ G4GG#`Hhb#D  cc@T_ӘG4Gb#    @^   ^  .a  .JQ
!JF C= `G_GCb#GGTGh_ D2   =4GGb# . !" JF  G;_ D%  G  b# CGTGR_ D G ݠG ]5J . & 
 &.J .uJJ  r.Q!JFF"HuF7'HGJwJFwF >  r> tGG  4Gb#S_ DG ]  ]( }0 8 @ ݤH P #kG#  ^( ~0 8 @ ޴H G   #v J  ~G ^ C ^@$!J   GN G4GG#`Hb#D  cc@S_ӸG4Gb#    @^   ^  .a  .JQ
!JF C/ `G_GCb#GGTG_ D$   =4GGb# . !" JF  G_ D  G  b# CGTG֌_ D
  ݠ  &,  0.   &HQ 0Jr0HG2F  0> GtGG  4Gb#S_ DG ]  ]( }0 8 @ ݤH P #kG#  ^( ~0 8 @ ޴H G   #v J  ~G ^ C ^@$!J   GN G 4GG#`Hb#D  cc@S_G4Gb#    @^   ^  .a  .JQ
!JF C/ `G-_GC8b#GGTG~_ D$   =4GGb# . !" JF  GQ_ D  G  8b# CGTGh_ D
  ݠ  &,  0.   &HQ 0Jr0HG2F  0> GtGG  4G0b#S_ DG ]  ]( }0 8 @ ݤH P #kG#  ^( ~0 8 @ ޴H G   #v J  ~G ^ C ^@$!J   GR G 4GG#`HȢb#D  cc@R_G4G(b#    @^   ^  .a  .JQ
!JF C3 `G_GCXb#GGTG_ D(   =4GGb# . !" JF  G_ D  G  Xb# CGTG_ D  ݠ ] . &. & GJQ
!JF @  r.t2HSrJtF  r> GtGG  4GPb#R_ DG ]  ]( }0 8 @ ݤH P #kG r.
2HS
rJtF r>8# ^  ~( 0 8 ޴@ H G   #v J  ~G C ^@$!J%AJ   GQ @¤4GG#`Hb#D  cc@1R_G4GHb#    @^   ^  .a  .JQ
!JF C3 `GG_GCxb#GGTG_ D(   =4GG8b# . !" JF  Gk_ D  G  xb# CGTG_ D G =%vHG A. !. "HRPJsHQ0JTF A>3F !> GtGG  4Gpb#*R_ DG ] ]  }( 0 8 ݤ@ H P #k Gkh#  ^( ~0 8 @ ޴H P X G   #v J  ~G  C ^@$!J%aJ&J   Gj Gp4GG#`Hb#D  cc@Q_HG4Gxb#    @^   ^  .a  .JQ
!JF CK `Gϊ_GCb#GGTG _ D@   =4GGhb# . !" JF  G_ D3  G !b# CGTG
_ D) G &vHG#gH (. (  .HrHQ!JPJ3FF (> >G  . "wHV JF >  ]
 , 8# x/!GKyHcyH9Ha9H DcG DaG
 < x? tGG  4Gb#Q_ EG ]  ]( }0 8 @ ݤH P X ` #kG#4G  ^( ~0 8 @ ޴H P X >` ^h G ^GG#J  ~4G  b# >4Q_Ө   v HY  G!vH  4IG! Hb#
Da!@B !" A.^ " a.QJSqJSFu@JFP E> ^ /a !/KY
7K	G	 C7  G4G6_G Cb#GGTG_ D+  G =C@ BGH btG . !" JG
F   @FZk  G 4GXbXAGGb#4G_ GGb#4GE_ D	  GCb#GGTG\_ D  %4@0vH!v H
B?G4G  b#Q_G ] G  ]( }0 8 @ ݤH P X =` ]h p #k0 JpB    C1!J1@b A"b a.e .rJV
JTJF0BJSrJuJFe >uFb a>   @?$! !@Bb #b 7/TGe 7.b w"vSJ8KQ
8JSJ1G C!F  e .b .UJTJFe >Fb >    @b  #b  .e  ,9JA
9H !F  Ck0v J C   @   Gk0 J[ GpB C  R0JPBj p"m .j .3Jv3JUJTJFFm >j >k0v JG C   @  G Fk0 J FpB   Bj "j .m .~ #JW
JF C  ~ 0/ 0,8KA
8H!G C  2kG0v J C   @    k[0 JpB  RPBz p"z .} .JU
JF  kG0v J4G0 J   pB0@ !" A.R QJ A>    @ " .vtJU JF >k#H{    ~ ^ ^ ~                                                                                                                                                                                                                                                     y                        3߮5 $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "           ( G 0,G P.G  s p# HR@J2D! Ha!@ aB " . "j d" J 8FH  /4B $/ P/KY
7K [KG CF% j ,m D.j "sHHR
PJxsH D  C  m .j . d#w;HVJUJFFm >j >n " D/0Jc0JZ [KWG D?q ,n D.@HRPJ Dq <CFn D> G .G /J8 bA
KXK!G0 C$KVJy$KGF ? >4G  W0@C  WGcn^ j $,j  m . c" C. HP
 J" SJ 0D  C  .     J D   . .JX
JVJF0BJUJwJF >F >  Y0@C  Y  $, d# . c" #. D";HP
J8" 3J0D C1Dv   , . D# # HV
JTJF0BJ@HuJF D > < $"   90 C   . d/"J[
zKGF C(bBU   C. C ,tG d.AJ@H qJ@Ff^r $,r  u .4G" HP
 JB1"b 0D
   CvAZkr $,r  u .Gb# HP
 J 0D  CGm@j $,m .j  "4G HBP
 Jb1" 0D
   C]AZkj $,m .j  G HP
 Jb# 0D  CGT@4GBbp  CKAZk CGb#I@ӰB0 b C4GAAZk . ,  b#J@H F@G8 bG4Gm^6 G . 4G $ rHP J4B "F >yJD /j D# . . d"X KzHG ?m ,azHj d/JV
J@H[zK  B Dm <aGj d?FDq .n d"n .3Jt3J( bVJUJFq >Fn > C4G{Zk D, d B CH D<G ] G ] }  ( 0 #k0v J# C    ^  ~( 0 @8 G  ~G > ^ ^   G èb0 J"dB  cdB " . .JxJWJVJFF > >  CDC z/ Z# zK @G0 BG8 btzZk   @  ,     H   C1HB P" p. rJS rJ45BtJtF p>   } ]B " .j # JK j 5/m U/8KZ
XK:G  9H  #$@n  n !.q . JP
 J 0F    cdByBj .j "m /r S#u s/JX
Kr .[zKFJaJUJpGFu s?r >5H  #G$Bn  n Q.v "q .y 1/@Jv /V
JY7K VFHaHXK0Gy 1?Gv ?  cGuBj S#m S.Jj s/vJRZJ[zK0 B@FvGm S>j s?8 bzZkZ   BG( bZk   ]  @j   j  .m  .JQ
!J F  0H  c%HdBn "n .q .JV
JF  w  CCj y/m 9,j Y#u P.r 0"zKr ,A
:HRQJaG1Ht1H@HUFu P> Dr <  âGBn v"n .v V#q 6/y /Jv v/Y
3KXKFzJ`zJ[zKGy ?`Gv v?  Bj E"m .j .2Jw2JUJTJFFm >j >G0 BG8 byZk  @ ,   H GG ] ]  }( 0 8 @ #k#4G ^  ~( 0 8 ޴@ G{ ^GG  ~   b#M_ "$v H  !׀Hf!@B Q" q. . ?" CrJTJ5JtF qF/  B " / 0/K[7KY
7K[G VG
WKXKzWK;GG 0? ?4G  Ghb @ @. .@JT
JTF C  A   GG Cb#4G@H E.sH %.REJQ%JTF3F E> %>_G4G   b#M_G ] ]  }( 0 8 ݤ@ P #kG0v J C   @   Gk;0 J"pB   C2AJ @ " . .JXJV
JF F
JUJwJFF > >  !0@ A" , a.HSrJ D    .vH GUJF  >kG .
HU
JF >#0v J  ^    C( ~0 G  ~@ >G  ^   G  b4GGȤb#  "M_ 4G"   HG  !` @Pb#  @f  "i `.f @.JtJSqJRQJuFTFi `>f @>  KM_ GG ]  ]( }0 @ #kG8#0v J  ^    C( ~0 G  ~@ >G  ^   G @b4GGb#  L_ 4G" }  HG  !` @pb#  @f  "f  .i @.0JR
PJ 2F    M_ GG ]  ]( }0 @ #kG(0v J0 J   pB @  @.# `.@JS
`J SF  kG#4G ^ ~  ( 0 ޴8 G{ ^GG4G  ~  (b#L_HX¤   v H  G!vH  &G4G0 HPb#pB 0B P" p. C rJ0`F `_  4@!vH v H
 @G  4Gb#L_G ] ] }  ( 0 ݤ8 @ #k#4G ^  ~( G{G ^G  ~   Hb#uL_ x" "G4G v HФb#  !  H` @  C H  @  " @. `.QJUqJS
qJFF
JRQJtJuFTF `> @>  L_G ] G ]  }( 0 #kG#0{?F   ~G ^ G  2V JG s"0@Jx{ C @ CTGc^G ] G   #k0D   FG ]   #kG!v J# ^  ~( 0 8 ޴@ H P G  ~G ^G  G ^G3v H
3@/  4vH  9I4׀JtBB " . /JXKFzJ:G  P E ` 4. T.TGG4JR
TJb#2F C   BGG_    $  0vH!v H
B?  =    Q.sHGRQJSF  Q>G ] G ]  }( 0 8 ݤ@ H P ` #k Q.
HR
QJSF Q>#4G ^  ~( 0 G  ^GGG  ~  ȥb#K_G Cb#G4G\_ G v H  G1v H  P4 @1 J7v Hq1B C1!JQB q" . JT JFuJF > ݦ6vJ
BG  4GPb#K_G ] ] G  }( 0 @ #kG0 JpB    @    `.!J @.t!JSaJRAJuF `>TF @>kG8 C0 J[   pB C  R0J@	  PB p" . JT JFuJF >kGH C0 J([G   pB  R C@
  0JPB p" . JT J FuJF >k# ^ ~  ( 0 ޴8 @ H >P ^X GHۤG  ~G ^G  &GX	4G!v H  &  @2v I  8_I3@J2 h#ssBB " . .JWJFyJ
GP@E
 @2 .5 (.JQ
;J`b#F CF   CG_D  &	4 A0v IA!v H
B?Gb#  "4G4GGGGT _G ] D ] }  ( 0 ݤ8 @ H =P ]X ` #kG# fC ^4G[ ^ ~  ( 0 ޴8 G  ~GG{G}Zk4GG( b   C}b^ 4`@%  4G8 bG7  GG_BF@b4G0@|ZkGGTG( b   Cfb^0vHb#; @G rb#G4G`@  0@4@ v H@ GBF@bG4G|ZkGGTG( b  CHb^0v`Hb# @G rb#G4GB@ӰBF@bG4G|Zk¤4GG( b  C3b^G ] ] }  ( 0 ݤ8 @ #kGh;#  J ^  !` @ ~  ( G  @  ~ ^GG#@{##@, .- $,,  b# JA HF0JJk@. $,1 ..   BTG HP
 JR"0D C   C  4G   CBb|Zk $, .(b#$HP
J0D C @Ӵ $, .  b# HP
 J0D C @ $.   $, D# / " J $/A H d/ ,K d.!F .Y
7K "zK .@
HB " "1&J D" tJ J  ޶G`G ! b J&J C C CGK|Zk $, . D" d.tG .$H P
JrJBT
Jb0DtF" C C C7|Zk ` "tGB!   @ C  $b+|ZkG ] ] }  ( 0 #kG;# ;  J ^TG  !` @G(1" ^ C ~ C  G  ~Gh{  @Ga^t@b# @, .- #,,  b# JA HF0JJ @. #,1 ..   BTG HP
 JR"0D C   C  b4Gc  CBpb b{ZkB Cb4G{ZkG ] ] }  0 #k# fC ^4G[ ^ ~  G  ~G{GG{Zk ` 8`D
  X`D  D@
   CGTG GX b  H b  C4GBb#D@{ZkBbG4G{ZkG ] ] }  0 #kG# hC ^4G  [ ^ ~  G  ~G( {GG{Zk 8`D	  X`D  F@ p   CGTG L@G4G  B( bK@{Zk  B( bG4G{ZkG ] ] }  0 #kG#X  ^4G[ ^ ~  ( 0 G  ~GG { Cm{ZkG  _  $.0" B C bTG $J  a{Zk@B8"  b C4GY{Zk
    %,0 B C bTG %H  O{Zk@B8"  b C4GG{Zk c   ,0 B C bTG H  @<{ZkB D@ bG4G5{ZkG ] ] }  ( 0 @ #k# eC ^4G@[ ^ ~  G  ~GH{GG{Zk 8`D	  `D  D@ @   CGTG G@G4G@BHb#Q@{Zk@BHbG4G{ZkG ] ] }  0 #kG# ^ ~  ( 0 ޴8 GG  ~C ^G  G4G4G_  . BTGb J CzZk pD   B" b C4GzZk0@@0@0@BP" b C4GzZkG ] ] }  ( 0 ݤ8 @ #k  @G#;@ gC ^TG( [!  ^ ~  ( 0 ޴8 @ G  ~GG  0 { C~Zk C  : G"GBTGbcD!  CGvZkb` GBtGhc b  @ C=vZkbX GBtGHc b  @ C3vZkbBGbTG c  C+vZkG   G_  Gb#0`@ @ @Ӡ	d@@H BP bG4GeZk GG ] ] }  ( 0 ݤ8 @ P #kH #G ^    ~  ( 0 ޴8 G  ~G ^ F .G 1. "  [  d.J ,Q0J D. "dJ0 @HF`F , UJ#4J D"" HG( { C  JGGuZk  B J@( bGGTGuZk  
  _  .N@  BG( btG JG  uZk@ . d" .
 $ 
 . " $.J .U
J /J0 "Q
!JJ  BX
K( bFP9#FF C C C CGGuZk $. d. "  .  # .0J .S
pJ $,J0 W
J ,J  BA H  ( b3FF# HF C C CGGuZk, .- ,,  2 D/2 $#5 d/J( d.FH+ .YK$ $,[
yK' .$  . .. "1 /dJ0 U
JF HP
 JJX
K[G  B4JuF( b0DF C  > J                                                                                                                                                                                                                                                   z                        Ee $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        m "            C C C CGGauZk6 ,9 ,6  : .: $ = $.H@
H> .JA .DF d/Q
!JI ,J ,> "M $,FB /F D#E $/J  0 B "JV
JzK@
HH  BA
%HKY
7KF `G( bD("G  C C   C > C C C CGG-uZkZ ,] ,Z  N d.N D"Q .HV D/@
HY d/V $#^ .rJa $.T
JR .YKU /[
yKD0 ^ $ R "JQ
!JtFJX
K[G  BFF( b   C C  > C C C CGGuZkf ,i ,f  r .r D"Hu .@
Hb /e $/n D#Dj .m $.j $ n d/b "q ,J0 V
JJQ
!JKY
7KzK@
H  BFFG`G( b`  C C  ޶ C C C CGGtZkv ,y ,v  z .z $ } $.H0 @
HJ  BQ
!J( bDF0" C C CGGtZk~ $, .~   ,   d. H .P
 J D/ H d/ $" , $# ,qJU
J .YK[
yK0D0 "uFH@
H[G  B D #( b8@ C  C   C ޶ J CGGGtZk D/ $  d/ " .  DK .[
dK , ,J .[G $. C .U
J /H0 "@
HJ  ^Q
!J  BJ( bX
KF,CDFFG C C C CGGjtZk  BL@( bGGTGctZk    &, G@  BG( bG &HtG  XtZk@  BH@( bGGTGOtZk    %, G@  BG( bG %HtG  DtZk@  BH@( bGGTG;tZk    &, G@  BG( bG &HtG  0tZk@ . d" .G .   $.J .U
J .J0 Q
$JJ  BW
J( bFFFC C C CGGtZk ,G ,tG0 "H@
H  B( bGD CtZkG ] ] }  ( 0 ݤ8 @ #k            #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k0 #G  ( ^G   C0 G  ~G  ^G'  ( [#  GXsb#  R 2. 2,2JA
2H _& !F  C >
@  1>J! J2B ^ BGTG  B C CGGGE@ =!v HX$D   tG
 G tG
 h BG` G  RX b BG\A DG  ]( ]0 @ #k#G( ^0 G  ~G  ^G&     2 JGC  , .TGG HT
J 4D  C ;	@     !4J   B  B[ ?$Cmb#B >G ޶G CGG@ =!v HX$D   tGG  ]( ]0 @ #kXBGPG  R( b BG}]AD @ GG D#0v J ^ tG ~vH  ( 0 ޴8 G  ~ ^GGG%JG    .U JF  >G J G C b#TG)@  $.rHGQ $J2F  $>D! 8D `XD ?Dy @G 7 .`b# CTGQJG'J@ӄD GG 7 ,?DG Cpb#TGQHG'J@ӄTDGG ] D ] }  ( 0 ݤ8 @ #kG#TG ^ ~  ( 0 ޴8 @ H G  ~G ^GGP FGGb#G&J'J  GG; @
 !aHG4`@0b#!H"!FGtG@ DH    .&vH $.GtGJQ
$JuEJF CF<     .T JF  >G J G C b#GTG`)@  e,aHGC eHaD  e<DG# 8D  XD Fy`B`b#  7 D. CTGQDJG'JP@ӃDG D G E G7 ,FG Cpb#TGQHG'J:@ӆTDG E  GG ] ] }  ( 0 ݤ8 @ H P #kG#4G ^  [ ^ ~  ( 0 ޴8 @ G  ~GG( {GGGG CoZk @GH    . #.Gb#GJQ
#JF CP F @GG9 @ D9 G8 #.!H; C.4@!H#JR
CJ"2FD C4`@G " ÐaH4 B$ GGGGb#]_  	@G  䘜b#@GGtGI_    . &  &."JQ
!JF C4 @ @ Ó!H4`B 	cB `4`BG tGG ] ] }  ( 0 ݤ8 @ P #kG G Gx# ^     ~( 0 8 ޴@ H G  ~ ^# =G ]#J4  ,4   $aJ%J  H&J   G% G4GG#v`H b#D  DC@Gpb#GDD@G C = C ] C b# C  G%+@G`b#GGtD@G4G  b#C@ DG ] ]  }( 0 8 ݤ@ H P #kG#  ~    > ^ ^ ^  ~( 0 8 4  ,4   GG  H#J$aJ   G1 ð4GG#v`H0b#D  C@GGb#>D@G C = C ]Gpb#GG-@D } B" bG CTGmZk  G Grb#TGAGb#G!D@G  4G b#C@ GG ] ]  }( 0 8 @ #k #  ~    ^ ^ ~   ޴   > ^ G4  ,4   GG  HG%JG'aJ(J   G G"4GGE`b#C  	%vH[C@Gb#G
0`DC@TG CC E CGGGGb#=_DGu  PB CXb4GnZk @m  G	b#G4G@g    5@ D "CGTGbG^ADGY   CGF CCGGG_"G0b#_D  =GG )  x G1"Hb#TG'JF@    TGx G1Hb#D'J C@  x GDb# CE CTG@	  x G Cb#TGD C@  4G  @   qHC0HIF4 A  "EGGb#6_G GD = Cb#GtG"@G G GGTGbG^AGb#GWC@G  	4G0b#B@ DG ] ] }   ݤ   = ]  #kG`#4G` ^h ~p x  ޴   G@X ^GG&J  ~G  Gb#GP >GB@8   4  ,4     H  ( &vHCGP = CCGGb#z_G  CGGGGGb#_G    %, E" .TG %.H ݤG%HP
JPb#Q2JD0D'J C@ CG4G  b#sB@GX ] G` ]h }p x  ݤ    #k#x ^    ~޴ (0>8^@~HPXG  ~ ^#` }Gh G4  ,4   G%J  HG   G G4GG%vH  b#TG  .B@G C@b#GTG&@ U @  x G
 `!aHG4`@!HPb#"!FCGGtG@ GC b#GGTGW@DG_  h GP =
4GP B	GP }CCGCFb#P `GG  C G  CGG4G	/@DG?  ` 
0@AGC4 B  G_GCb#GGGtGA@G  G ? ` =1dA?p ]"LrA !_  CG CX G_GG b#GGGGGc(@  0BC8b CGGtGwZk0@ @  	 A !A0`A?=D DG  4Gb#A@h } E `  ,eHDHD  <G ] ] }ݤ (0=8]@}HPX`#kG ,
HD
HD <ð#4G ^[  ^( ~0 8 @ ޴H G  ~%J G{ ^GG%J ClZk @GD  
b#G4G?@?   GP _"Gb#_G  G5 GD .  =GTG  0. P.!v H`b#0JR
PJ C2F C%@  8DG  XDG  .  b#DQJ C'JTG@ӃtD G G G  ,  GDb# CQHTG'J@ӃtD G  GG ]  ]( }0 8 @ ݤH P #k#4G ^P[ ^ ~  ( 0 ޴8 @ H >P G  ~G'JX{GGGG(J CYlZk @e  G
b#G4G@_  P`D	  G`b#GGTG	G>@ G!aHG4`@b#!H"!FGGtG
@ DE    . $._"` GJQ
$J0b#F CF9 `GGH_GG Db#4  E,    $, .'vHTG$HP
J8 E0D C CZ%@   	G X E
   ,  G	Db#QH C'JTGS@ӃtD D G D G ,  G	?Eb# CQHTG'J>@ӃtD D G G  GG ] ] }  ( 0 ݤ8 @ H =P ` #k#0J0 ^4G8 ~@ H G GX =( ^G  ~  #  #!H b# = ]D }  x@@4G  G   P = ]0v J4  ,4    }   H `b#    > = ~ {-@G GGG  4GP b#h@@G( ] D0 ]8 }@ H P #kGP#4G` ^h ~p x  ޴   > G@G $J =GX ^%JG&H  ~#  '!H b#H ]L }P 1@@8P`DGb#C   TG4  ,4     H8    Gk@ !aHG4`@b#!H"!FCGGtG	@DG	G%  $vHH ]DL }C >DP Db# C  ޴ C G4G-@D	G H 0  PB CXbTGGHjZk  GP =G@tb#TG_A 	GG  4G b#?@GX ] ?E` ]h }p x  ݤ   =  #k#4G ^ ~  G`{G ^G  ~   b#?@G4G   b#?@G ] ] }  0 #k#4G^~޴ >^~ (0޵8@Gp{G^$JGG  ~#  G!b#G` G =	G }
G 
4G?@hG  4  ,4     H  GCGTGxb#G C AӨ ݡG CGTG PEb#  G@
 è ="GG@b#tG1!H4 @!J1DCGM	@DG P "$vHGH}"C >G = Cb#C  ޶ C C4G4Gr,@D=DG  GEG  ?D?DG
    BC( bH]"G CGtG4uZkX4G D E  ?D?DyG  H}"X "CGC$ .$ "' .G C  >Jb#W
J  C F CG4G4G:,@
D¡ GCb#C CGC  ~ = CG GG4G4G%,@ D                                                                                                                                                                                                                                                   {                        éd $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "             
G; GH4GG
4G b#E0VIPIRIӐI̒I2V@J,VI!!HJ1!JAJ3aJI0D2F	lF C?@ !  B
 C( bCD *CF !G0V J?D!!HJG
0DG CGtGtZk` ! C_Ӡ@  
G ,v@I %!E G ð ݢ CGGpb#tGC `  =w!@
  G B Cb4GGjZk   * Gh !b# C CTG_h }G `
 GC Ch b#GGtGH_GE0 B `p !8 b C CGtG>tZk4  G = Cpb#GtGD!@GC* è }! Cn_B Cb C 4GiZkG C@b#p !G CGGGGI_G CZ_E i 0 BC8 bG CGtGtZk  B Cb4GGiZk@E@ 
4@AU +FI@ CfIG	@  	AX 9_  BC( bB` CGGGtG:tZk4G _! C AGX %_  BC( b@` 	CGGGtG&tZk  Go1@I!b#*V@I CAID %
El@I&?I  DD Ű ! C CP	@TG>@ CD O*_ID OC    CG CE =b#GG   C  4G4G+@p4GG
G!b#  >@Ӹ   #- CGGjHb#I #ITG	*E  #= ݠ _ }Gp  !b# CE, ` CTG}>@G ] CSb#GGGTGG@p }x ]УCGGDb#0`HP`Hp`H  ɐ`H >ϰ`H `H ޴_E( ~0@I0 P@I8 `H  ~p@I@ ^tGtGGĽ_
8Ep G!b#4G  =@G] E]}ݤ =]} (0ݥ8@P#k#^~޴>^~ ޵Gۤ  ~G^#  G =GG4  ,4   'J  H   GthCGGwb#TG CAӘ CGTG`b#P D  G@ D  `Ø ="GGb#tG1!H4 @!J1DCGA@ DQ C  G*vH(b#C CGTGi_ӈ = D     GAGG C =Gb#tG@ӪC GPB CXb4GhZk @G'vH =TGb# C@ӪCy @G*D   = CGGpb#n_ D b4GG`!b#  &=@  Ơ4GG  4 ,4  0!b# H *=@ G
GG b#=@CGGC@b#   G ~ C = C   C C4G4G*@!u`AG  D  
 @xF  F	  B ]"b CGGGtGrZk D   GC@b#C G =C  ޶C  CG C4G4G)@  B0 bC CGGtGrZk!	 B0 b CGGtGrZk
G=   @B  b CGGtGrZk ]! C_GCb# C  CGGG~G_G C_D 
 GB =#Cb CGGtGrZkGC b#
CG0@GtGFG_  , ]G H0@IDD'Dq$HP JF  > CGj_PB CXb
 C 4GgZkGCb#GGGGGDG_
CGGV_D K ]! _BCGb CGtG
rZk   J!FA? GG8`BCGCG =G@b#C  ޶C  C  C4G4Gb)@ӳ  C &" .GG J  G
   ]" C  . " a. JGStJgJ3aJ	B `CPB 7#Xb / CFK4GHzgZk	@  G à =  C> 0"> P. QJ @+u`A `G CC C
 8/C 
 X# ;,7VJ :KG  u1JJq KA  HF1D ;<_ `b# C4G@Ә ݠ4G4G D  G   ( P IE0 I aAqAB  q 1"	oB 0A5A/A    1"	B  0A9A/A?4G0@G ]{QI`1ID:_K DzG@ b# @GGC G4G<@G }!@ b#G`A4Gz<@  A! @  C qG2V@JF3aJAJrF C@B DCD C ( qIG:G ְ h! .rIP JF >E h.S kJrF h>p CG C = C D0b#C   C  4G4G`)@B  b CGGtGqZkBx !b C CGtGvqZk	    d-  dI
EDHE  GPB CXb4GfZk ݥDE hE h CGCG =E0b# C   C ޶ C >G4G4G*)@DGxE`b#G#   ! =
 C  ^ C CGGGG"@DG( h CGG
 C ~E =0b# C C   C ^G4G4G)@DG G X    =C0b#E  G ޵ C  C C C4G4G(@GG b#;@G4G  0!b#);@  G CXb#GTG_
D
_E_E DG]]}ݤ=]} ݥ #kG# G ^ ~ ޴ (G  ~ ^	 = ` }H .wH	 .C@ [%JVJUJF >GH {GGF	 >G#&JGGtGpZk` GCb#TGP D  G@G D$   ` ="`BC  bTG1!HG  R4 @!J8 b1D8@FG @GG9VA D   =?D =GC0b#CGtG@D?DG  D   =` ]QFǔ?FGP`Db#D `	 CGGTG@ D   G'aHG4`@0b#H"'DCGCtGb@D?DG  G%vHC` }Db#G C CGGG!@DG  4Gs X=DGp  CCb#C  ~GG C C  CGG4G4Gr'@P =4GGDP D  W  FU  0  GCG"b#GGtGd:@4 @G X =0 Ab#C?D  CC  ~GG C ޶C  CGGG4GH'@DG? GD? h "V@CG_   GDGF"b#  CGX GGtGV:@CG_h X CGC C >Fb# C  ޴ C GGGG4G'@G tG	 , },	    CHGC
eHX bGD `GTGUA DG ] ] } ݤ (0#kG#TG ^ ~  ޴G  ~GX }P F ^#GGGb#%J&J `CG@
 G!aHG4`@b#!H"!FCGGtG@DGe  %vHDb#CC C >GGC  ޶C  CGG4G4G&@H =D4GP DFK  K  CGz_GC$b#GGGtG9@4 @GG  P =CCb#G?F  0@GC C  ޶C  C GGG4G&@D?$  TGD?  G` ="P @@$b#S1@G 0B C2BtG9@P GCC ^ Db# C  C  ޴ C GGGG4G'@  tGG ]D ]D }TD  ݤ D #kGP#0J ^4GG ^ ~   G  ~Gx Pb#GGp ~G
@  GJ GP`DG  CGb#GTGe@ !aHG4`@0b#!H"!FCGGtG@D0 G  FŔFCD*  GCG_"Gb#p_D =G А HP F  tG G!"Hx =GTG'H b#$v J>D&D   CG}@ u @	  Gp = C b#TGu@ u @D GG ] D ] }    #kG#0J( ^4G0 ~8 @ GG  ^#JG  ~ D  #b# > ^ ~8@ӈGG"b#   4  ,4     H  @9@  CGG = v H ] }`b# C!)@Gp"b#GG29@ GGG  4G"b#8@G  ] D( ]0 }8 @ P #kG#4G ^ ~  ( 0 ޴8 @ H >P G  G ^&JGG  ~G  G#b#x8@4GG    p#b#4  ,4     H  {8@ GZ GG&vH#b#G8@ CGGGb#!_	GB   CGGGGb#x_	G9    TG B0 B$ .$ ( ' (.8 bJQ
!JF CaD  G CbZk    C0 BTG8 bGbZk  GG@b#L@GG`b#. @Ӡ= @  GG`b#( @Ӡ= @(    CG CGGb#D_ C CGGGb#=_G #b#G8@G  4Gp#b# 8@ GG ] ] }  ( 0 ݤ8 @ H =P ` #k# P F(^0~8@H޴PG  ~G > ^GGL   _GCGb#J@GGG!@>   CGCPb#4G  e. %" .G .4GeJT
J JtF CP FGGGG:@ DCG_ ݢGG %b#GBGtG7@ =0@G 4 @CPb#  A.0@ a.CDAJS
aJGSFG CGGG@ D Dc !aHG4`@b#!H"!FCGGtGz@ DH S   ݠ"DO `H4@D4 BH  CGGb#_ DC  0 > ,> } A =,"ŐHHPD* A
#HD C!H4 @1D4 B" @GCb#GGtG_@ D)     CP_G }  %b#G CGtG7@ 4 @  0@" G ݠ H4@DG4 B?: ].: ="= }."QJS
qJSF C!J4 B4F4BG D  GG ](]0}8@HݤP`#kG# CH ^fCP ~CX G8 G  ~G@ ^GG_  [G( {GGGtGkZk C& .G# .# " HG ?$pab#TJVJwTJUJ @FC& >F# >0v H ѐ HGtG@ DG  C`pb#GCGtG@ D =
  G,b#G!HG2GJG"G<@G@ ]H ]P }X ` #k#CH ^   GP ~tGX G  ~G8 G@ ^   .#  . JQ
 J F  C `D;  p"C CG_`[Gh{GG:kZk C& .G# .# " HG ?$_b#TJVJwTJUJ @FC& >F# >0v H ѐ HGtG.@ DG  Cnb#GCGtG8@ D =	  G*b#G!HG2GJGG=@G@ ]H ]P }X ` #k    p B#  0. C                                                                                                                                                                                                                                                   |                        \ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        & "            >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^  [ ^ G  ~G( { CaZkG#  !1 @1u @  G  B.G . " . " 8/ BJ J B J # B 8K:q @ B B :@C0@@ B! @_0 @ `  ".G!1 @ "J0@@ B F  G ] ]   #kG   G0 #G  ( ^G   C0 G  ~G  ^G'  ( [#  GXlb#  R 2.   2,C JA
 H !F >  C
@  !>H ?&  J1@ >GG  C G CGGw@ =!v H(D   G
 G G
 h BG` G  RX b BG3LA DG  ]( ]0 @ #k#xG( ^0 G  ~G  ^G%     GGG  , . @"2HT
J ^ 4D  C;	@    !  J2^J &  CGp;  Cpib#TB ^C  CGG@ =!v H(D   G_G  ]( ]0 @ #kBGG  R( b BGMAD_ DG#8 4G ^( [ 
@ ^ ~  GG  ~G0 {GgZk  #,tG .8 "#H( BP
J0 b'B0D CGGgZk C.   #,tG8 @JA H( B0 bBAF2FJFJGgZk( B M@0 b`@GTGgZk6 ,7 # ( BK@0 bTGQH'JgZk7 ,( BS@0 bTGQH'JgZk8 #.; C. Q@( BG#J0 bR
CJTG2F CwgZk< #.? C.< # ( B O@!J0 bR
AJG2F CTGjgZk8 b4G( B0 bGdgZk@ b            FB	C11 B PF       c  c 0B  GH BGP bpgZkG ] ] }  0 #kG#G ;( ^G    B0 G  ~G  ^wB)    !%   C{ . " .8K ?'JV
JCF C
0@  0 J G  BGG CG0gb# CGGGe@  v HD G D
 G G
 BGG  R0b BG!KA GG  ]( ]0 @ #k#8@ۦG( ^G0 G  ~G  ^ B2       ֢wB  [C .    .C JU
J8K F  C	@!   0 JGG B G0gb#G > CGG @  v HD G D ( BG0 G  Rb BGLAD G@D  GG  ]( ]0 @ #k#GX ^` ~h G  {GP ^0 [  ~H L > C  #8 {;_ZkGCbP @GGGJA DL   ?   0 @ B ]"  # CH H b_ZkL @ @      GGP ]X ]` }h p #kGp# C` ^TGh ~p x  ޴ GpGX ^GG  ~P >G8 { COA GBCbD  %C^ZkGhbP @ C GGGxJADG	 C( b CGTGOA G" GB =   % CbG^ZkB@ @P bGC    %C^ZkGbP @ CGGGLAGC( b CGTGOA GGX ]` ]h }p x  ݤ  #kGp# C` ^TGh ~p x  ޴ GGX ^GG  ~P >GX{ CT ^^OA GC BCbD  %G^ZkGbP @ C GGJAD
 P }GC_"Hb C  SGTGOA G% GB =   % CbGY^ZkP @ @ BT G  CbC  ײ     %l^ZkGGbP @ CGGKAGCHb CGTGYOA GGX ]` ]h }p x  ݤ  #k   kG#4G ^[ ^  ~( 0 8 ޴@ H P >X G  ~GG{GGG CG^Zk @G>  0b#G4G;@  !H4G&H4 @ = @"Gb#  18 F
  _ !G Cb#_ D
  % G@ Gb#  _@@    GG 1vH _&R"4 B  2F"3F_ GGb#_ D	  B $!b C4G^Zk  W   GG ] ]  }( 0 8 ݤ@ H P =X ` #kG!H  $"&H4vH	0@@   D. d. &"QJSqJSFTF @F5 	  G(b# CGGtG8_
 G  B C( b CTGN]ZkGD Gh  D`    $"  TG  B( bF0   D. C d.QJSqJGSF@F' @6]Zk%    $, .4GGTG$Hx bP
J0D CiA     =	0 A4 A =< $.< "? D.0JR
PJ2F C4 B 4 B
B   G G Gp#X ^` ~h p x ޴  G  ~GP ^GG B@{#I_  . #.GJQ
#JF C4 @ @" Ð!H ¤CG  fGGpb#8`F `_  S  "  !A@  !H =GH =4 B `	@ ? /< "< .6Jy6JXKWJGF? ?< >GGGb#_7    ƠGG8D b#_/  b  cC@  *   $,A $H  $<GH CGGGb#;_D ݠ	@H ݰ  4@    ? .< .< "HWJxHVJF? >F< >GGGb#i_CD GGGb#b_GP ]X ]` }h p x ݤ   #kG`#X ^` ~h p x ޴   GG  ~GP ^G B {#_  .G #.G"JQ
#JF C4 @ @ Ó!HCG  GGPb#8F _G  S "  !A@  !H =< C"GH =G  砠b#(F  8D	 < c.? .rJT
JtF C_= G<  < , G? #,  HA
%HD@D  $0   $.Q $J  $>H ]4@B) 	HB' @CH GGb#_G   H  GD =< #"C`b#(D  < C. ? c.H QJS
qJSFD =GG_GH ݰ H =GH =4 B `	(B? GGP ]X ]` }h p x ݤ    #k # G ^0J ~   ޴   > ^ ~   G  ~ ^I "L /HۤyHI .GXK  &WJGFL ?I >#4 a/4 ! GG aKG'J(J   GGG)v Jb#4G C@   GGpB Cxb4GE\Zk @G b#GGTG@ D  } @  DB   4Gp4GGb#  P1@  4GG  4  ,4   `b#  H  T1@ GGG b#1@GG 
b#G_"GG@ D  
G[CGGG_"Gb#_ D  
GOBCbGGGtG,gZkK 8B4G4G 
 J! 0 @  
  
  *
_E  *J1!J_F CT FP = @GGP TG	b#N@
    ʠ
0@G4DF  *1!H CT FP =GP }uHBV  b C4yJGFP GtGfZkBb CGTG[Zk ]'HGeѠHxb#*GI CDD   ݰG4GB@
G bCGTG@  +b8 D  NLAD
G    @bCGC8 F8b,  H =GG?Ft BH ]G4GGGA D  
G G  & =  C C  p C . .qJWJxqJVJF >F >  F P .   Z-@Jq@JTJJ@IF
QE > Z= CH 
C  ƢGGFH  6/ v/6K[
vK;G C4 B  
Gb#^_D  
G   = . p.0JTJu0JSpJFuF > p>>  / " 6/ _'Z#KY
7KG C
VC 
G GBCGbGGtGffZk   C  FCG
  
. *  J.b#JR
AJF CGn_
D
Gn   & A. " !. " .G0JR
PJVJ2F C0 BtJwtJUJF
G >F >-I`H
 C
4EP V ]!GP ] CGG;YKBtG `GbP 'H+fZkBb CGTGZZk eѠH
C-ICDD  G }Gb#Q_  k
G   ,#@b8`E+ ` ,C ,C .HE
H  ,,PJDHqHA,HF1D >  ,<G  ƠGE L/ " . .G l/ZYKJV
J[yKFH`HkG l?@G L?G4GbGGA_E3 @ GP ! CP =b# CG  ~TGGGG@Gpb#
G C4G'@     CG CP =TGb# C  ~TGGG@GP  Cb#4G7@G Cb# CGGGGGG @GGb#00@G4G  `b#/@I }-L -I  @CfIGM
IbGmE GTGPKA _E  GG ] ] }   ݤ   = ] }    #k#4G  ^( ~0 8 G{ ^GG  ~   b# > ^ ~e/@G0b#G/@  G =GG v HF@b#?D C = C C.@GG b#G/@G  4Gb#V/@G ] D  ]( }0 8 @ #kG#G  ~I " ^4H ^w4H ~   ޴ >L .GGI .GVJ  UJFFL >I >G4  ,4   &J'aJ  H   G	 B C(b4GeZZk @   G GGGPb#4G	@   G    tG  .# %.JQ
%JF CaD   G 4GG@b#  .@GGb#~/@ P`DGE  C@
b#GGTG/
@DG   FȔF ]GCE
b#  1BJG&J_"G@D
   =CG1"HG&J_"Gb#C_ D  G GD =DG &vH'H
b# C>D&@  GTGI@ u @  tG GGG	b#GTGD@G "C"GGTG  !b C8 D   JADGGp  H CbCGFt BH ] C4GDA D  Ga G)aHH =4`@!I"C)FC?DH =GGb#X_	D =G  #DȔ?D =CEGG  G1"J
b#G&J_"GG@	D
   H =CG1I?DH =&JCG_"b#_ D  G, D =DG &vH'I
b# C	>E&A  GTG@ u @  tG Ð  H =! C Cb#	_p B  x b CGGtG?dZk` Bh b C CTGXZk C Cb#o_GGGb#.@G4G  b#-.@I ,L },I  	CHGC
fHbGD `GTGIA EG ] ]                                                                                                                                                                                                                                                   }                        A  $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "             }   ݤ = #k#  ~    ^ ^ ~  ( 0 ޴8 @ H G4  ,4   GG  HG%J   G? 2FJGpb#GFJTGGT@   G4 G 4GG b#  -@GGb#G_"GG@DG  GG_"GG`b#@_GGE`b# `  $. D.7  7 d,%vH$JR
DJ fH2FaD C CTGG@Ӡ
`@DG  4Gb#-@ EG ] ] }  ( 0 ݤ8 @ H P #kG#0J  ^4G( ~0 8 @ G0 ^GGG  ~$J #fH  DPb# > ~-@fH  CGG   0v J =4  ,4    }b# C  H  @G GGG  4G b#z-@G ] D  ]( }0 8 @ P #k#0J ^4G  ~( 0 8 ޴@ H G`ۤ ^GGG  ~G %aJ  b#K-@G4G     Pb#4  ,4     H  N-@ G5 P`DG  b#GGTG~@	 !aH4`@!H"!FGGb#
_D G    $.D D.7 d"G4vJ$Jb#R
DJTG2F CF
  
 7 , CG H@D
@D GG  4GPb#-@ DG ] ]  }( 0 8 ݤ@ H P #k#4GP ^X ~` h p ޴x GH ^GGG  ~  b#,@(P`DGCb#TG   4  ,4     H1    G&@G- !aH4`@!H"!F4 BG @G# CGGG b#_DG  G CD = b#F  4 B @
&B GGGG_DG? GG G GG  4Gb#,@GH ] DP ]X }` h p ݤx  #kG#4G ^  ~( 0 8 ޴@ H GۤG ^GGG  ~G  b# ^,@X4GG     b#4  ,4     H  ,@ G+ 4@  TG 4GRDG8 FG
 @X F   =Pb#GGGGH@DG  !H =4@!H_"DGGG b#_GDǔDG4G  b#_,@ DG ] ]  }( 0 8 ݤ@ H P #kG#4G ^  ~( 0 G   ^GGG  ~  @b# > ^2,@GG =TGb#@  G  4Gb#4,@ G  =G =_"G  ab#_G4G  b#%,@ GG ] ]  }( 0 @ #k        p B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k      .# @. JR
@J 2F  kG#  ^( ~0 G  ~#v J ^G C{#* @   4G  GGCXb# CGCtG_ D   G " C0 GG  ! }b#  A.# .AJT
JTF  CG@ D@G ]  ]( }0 @ #k#0v J G  ~ 4G ^     #kGGC{# CGTG_ D  G ] G   #kG =G ] $DC  #k# C  ^CG0v J( ^G0 G  ~G >Gb#tG;_ D   G GGtG ] = b#w+@4 @ G@DG  ]( ]0 @ #k#4G ^  ~( GX{G ^G  ~   pb# >B+@ TGG = v Hb# C@G4G  @b# B+@ G ] ]  }( 0 #k#4G ^[ ^ G  ~G{ CrVZkG    ". 1 @G 1 @ "J0@@/FX%F @'F	  
 `  . J0@@FXF F 4G  GG ] ]   #kG#4G ^0 [ ^ ~  G  ~GG8 { CDVZk!@)  (    .71 @ JF#     G  C. G CJ9LB]OB6DBF
   /yJX KG  ?G0`@71B úDB  b @ CTGG @ 4 @  G0`@71B G  4GG ] ] }  0 #kG- @!q@B
2@0J G `	CGF `  . " JF   . 0 @ J "F  . 0 @ J "F  . 0 @ 1" JF  0 @	@	@   . J 1"F  0 @	@? k1v J $#     F  ~G ^    4G  #k{#~_G ]   #kG# C ^GGTG  ~ {#Gc_ D   G G ]   #kG`#8 G  ~P ^	 "X ^4H` ~w4Hh p x ޴    .G	 .G   GVJUJF >F	 >4  ,4   $J%aJ  H   G 2FJGFJb#G_   G D} @  DB   4G} G  4GG8b#  &*@GGb#*@G Cb#GGG_"G@ D  h"  !8 D  GbCTGEADGA   F CGGxb#CGGGGw_DG1 `G$vH =TGxb# C@ u @  G& G@ }pH CGTGgHXb#!oHD@ 0D@ =PD  GG@G GHG4@8b#"D   }  C CtG_G 4GGb#GU*@G  4Gb#)@	 ,	   ,CbGHGD
HbGD TGuEA EGP ]X ]` }h p x ݤ    #k#0v J ^TGG  ~ G {#.@G ]   #kG TGk# P FP ^X G  ~H ^G   G G!AHG4@@{#!H"!FCGGtGX_ D =	   G"D   G8  GJ FGH ]P ]X ` #kF!F
0Bk>F JF
0BkG # G^hC~޴>^G  ~ = ^H .uH }.GGTJSaJFuF > }>C  $/#GG%v JY $K  $?C  1.G ,C
b# C#J  >@
H G ~ FG C4G4G>@D=D4GG  GG  .C` BGbTG JG  R  bG8@F @DAG D  =?D =D  CG	G  G _4 @    " GHGCG0b#TG;@D   (4 @  " Ð!HGb#CGtG_ D  H =   0D  P DF  GR@H Cb#GG@ D0 =    4G H
4GP D? =GCC  =GH @b#GGG)@ DG_ GGb#GCtG(@4 @   
0@AF =R @GGb#tG 1"
 CS
@ 2B C2B)@  B( bOAGGtG^ZkG ]"AI
4@A@E4 Bd  GGCb#GtG_ D0 Z  > =,A .> ]!ǐH*HPDF P
J0D C!H4 @"1D4 B= @GG}"Cb# CGGtGY_ D1  G[_G&]!b#G CGtG{(@4 @	   _"J4 BF4@BG G CU @b#V@G UA C2BtG(@  B
 C( bOAGGtGM^ZkG]!pb# C CGGtGn_: ,: ]!= ,"H@
H D  CH 4 @D4 B?	0 A2$A A#_ }C
b#H@F `  . /C  ^GJGX
K C ~0@GFG C CG4G%@G G
D_DE E =, . =!"C)HGP
	J bTG0D  GGCA DG]]}ݤ=] #k            p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^P?"GTG ^ G  ~G( {sA  @ "4G0 B8 bGYZk G! @G4G  G@B   9AJ(B1BD `9B  "  ! #9"C B(@ 8B?G0@B   BB @(@(B   GG ] ]   #kG#4G ^?"GTG ^ G  ~G{sA  "4GBbGYZk G! @G4G  G@B   :AJ "$B& )BL r `"r ! P.Bp 9BC dB$@3B_G0@B   BB @$@$B_   GG ] ]   #kG#4G ^?"GTG ^ G  ~G0{ksA  H"4G8B@bGVYZk G# @G4G  G@B   ;AJ ""1B"  6B! `"8_# 7B9bC1@ qB :B0@B   BB @1@1B   GG ] ]   #kG#x; ^ ~  ( G  ~G ^   {#    3_   G. Ðb#l_   G) Gb#_   G# GGGA @0b# @4G]_ D  0`@ ? a@ G G GGQ @0b# @4G]_ D  0`@ ? a@? G_G ] ] }  ( 0 #k G#4G ^  [ ^ G  ~G( { CQZkG#  !1 @1u @  G  B.G . " . " 8/ BJ J B J # B 8K:q @ B B :@C0@@ B! @_0 @ `  ".G!1 @ "J0@@ B F  G ] ]   #kG   G#  ^( ~0 8 @ G  ~G ^ ^GG{#_X"G4Ghb#@@  # G__G Cb#GGTG__   =TG  B( b !. " A.0JRPJ @2F1&J&JD  GPZk  GGXb#4G__ D GG ]  ]( }0 8 @ P #kG =GB   ]GCSZk GG# 4 B ^? G4G ^  ~( 0 8 ޴@ H P >X ^` ~h p G  ~GG b#GGGD_GG  4@	  4@  GGGb#_ D Gb#G_("4G@@     DG4@8b#C6   G4G__GChb#GGTGg__Ӏ   G_G ] ]  }( 0 8 ݤ@ H P =X ]` }h p  #k 
G  _  4GG8b#
  	G^_G Chb#GGTGB__[   !A
0@A?! G8b#G4G^_G Chb#GGTG/__EGE   (b#4G  P. p.PJS
pJSF CD4 FG^_ DG!H b4@!H                                                                                                                                                                                                                                                   ~                        aȞ $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     1      ?"F !
?F J"_KSA_  +4GG8b#  GG^_G Chb#GGTG^_  EG   (b#4G  P. p.PJS
pJSF CD4 FG^_ D k!lA
0@A?G 4@ P. 0" p.QJSqJSF2FJFJDF @ B  BbGTGOZk;  
  GGGb#tGР@*_ D8  GG(b#4G^_ D	  GChb#GGTG^_ DO
0@A j! KELA  %  
0@A 
!EALA  !
  GG8b#4GK^_GChb#GGTG^_ӵ
0@A  1G B ]GG&RZk G* B ]GGRZk G" J4 BH_" Dp#_F@`B  ^( ~4G0 8 G    ~G >G ^G Gb#^_G Cb#GGTGe^_   =4GG  !. A.!JR
AJ2F CpD  xb#G6^_ D G_G ]  ]( }0 8 @ #kBG  G ]QZkG J4 BH_" D#_F@`B  ^( ~4G0 8 G    ~G >G ^G Gb#]_G Cأb#GGTG!^_   =4GG  !. A.!JR
AJ2F CpD  昣b#G]_ D G_G ]  ]( }0 8 @ #k =G0B   ]GQZk GG J#H  ^( ~4G0 8 G >G  ~4 B ^?"G FXGpb#?F@ @   G]_G Cb#GGTG]_   =4GG`b#  !. A.!JR
AJ2F CpD  G]_ D G_G ]  ]( }0 8 @ #k  G =  0G# C  ^( ~0 8 @ G  ~GG ^GGGX{#_ D9   =G4Gȣb#@ !.C A.!JR
AJ2F C-  GB]_ CGTGb#@  .C  . JQ
 JF CG]_  4@G	   b#GtG BG)_    ="$D0D =4GGb#@ q.C .qJT
JtF CQ]_ D tGG ]  ]( }0 8 @ P #kG =GPBTG G a.  A.!Ht!HSaJRAJuFTF a>  A> ]PZkð# C( ^0 ~8 @ G  ~G ~G  ^GG{#F_ DG7   =b#4G@ !.C A.!JR
AJ2F C,  \_ CGTG(b#@  .C  . JQ
 JF CG']_  4@G	   b#GtG BG0)_    ="$D0D =4GGb#@ q.C .qJT
JtF C\_ D tGG  ]( ]0 }8 @ P #k = G a.!H  A.t!HSaJRAJuF a>TF  A>  ݢ  ײð# C( ^0 ~8 @ H G  ~G >G  ^{#_ DU   =b#G @_(@@   G J GG8b#4GGv\_G Chb#GGTG\_   =4G G(b#0D	  G\_ DD
 ` G- GGGHb#4G4G\_ D# G b#s_@@G4G  Pb#GS_GG =TGb#TZ_ D0 B   8 bGGЀ@tGYZk }TG  B =( b`@MZk GG  ]( ]0 }8 @ H P #kG# C  ^( ~0 8 G  ~G > ^G{#v_ DbF  b#  #  k_   G?   Gb#  " D"2J  u2J% ." d.TJSrJF% >uF" d> @ 7/C W/B7KZ
WK:GG C  4GY_ D!   =4GGXb#@ !.C A.!JR
AJ2F C[_ GTG8b#@  .C  . JQ
 JF CGY_ D    #  $   G = G  G ]  ]( }0 8 @ #kG# C( ^0 ~8 @ H ޴P X G  ~GG  ^GGGG({#_ D   =G tG@ !.C A.!JR
AJ2F C  u GG4Gb#[_ CGTGȤb#@  .C  . JQ
 JF CG[_   =4GGb#aD   @ P.C p.PJS
pJSF C[_ D tGP 4GD  tGK G = G" !." "% A.0JR
PJ2F C  ? G  .4GGGb#T J  > " ." "% /JX
KF C`[_ CGTGȤb#" ',% ."  D HP
 J0D C[_  *  = !.
 A. "0JRPJ2F1&J&JD  4G  %4G Gb#" .% /" "JX
KF Co[_ DD G}DG  ]( ]0 }8 @ H ݤP X ` #kG  &,GpJ G0D  &<G# C( ^0 ~8 @ H ޴P X ` G  ~G  ^GGGGG{#e_ D  =GG@ !. tGC A.!JR
AJ2F C   GG4Gb#Z_ CGTG b#@  .C  . JQ
 JF CGA[_   =4GGb#aD   @ P.C p.PJS
pJSF C[_ D tG 4GD  tG G =4GGb#" !." "% A.0JR
PJ2F C  P$@X_ D   }4GGb#" #,"  % .G'HP
J0D CGZ_ CGTG b#" ',% ."  E HP
 J0D CZ_=    =G4G  0 b#  ! } ]" "  P" .% .JV
JF CZ_ D   G tG( B0 b '. ' 
 .!JPJ0F1&J@&JD @GG8WZkw 4G ç	@ G 4GGb#"  ."   % @.JR
AJF CZ_ DE  a G G_ 0`@D ` GZ Gb#  '  _   GQ   ǠTG G ݰ  &" 0"b#  '" P.% p.QJS
qJ =SF C5Y_ D     g  h ݠ  ǰ8  = "q Fp F  QsHRTJSF  QWB: ` ?"G 5/  /JzJY5KXK;GG 5?  ?tG } ( B , ,  I0 b@HaIGH DD < <  .0J p.v0JGTJSpJFvF > p> BVZk GG  ]( ]0 }8 @ H ݤP X ` p #kG Q0H_FSF Q# C( ^0 ~8 G  ~GG ^  ^G{#<_ DG+   =0b#4G@ !.C A.!JR
AJ2F C  Y_ CGTG`b#@  .C  . JQ
 JF CGZ_   =4GG b#aD   @ P.C p.PJS
pJSF CY_ D tG_G  ]( ]0 }8 @ #kG = G = A. "s0JR PJSF A>#"    ~4G ^ ^  ~( 0 G" 0,G% 0.GG HQ
 J8b#1D CW  Y_" #,"  % .CGTG Hhb#P
 J0D CY_2    " ." # % #.4GGJQ
!JHb#F CY_ D   "G Cx bTGG7^ " #"  $4GG8b#      " C.% c.QJS
qJSF CXY_" #,"  % .CGTG Hhb#P
 J0D CY_" .% #." # G4GJb#Q
!JGF CZ_% #," ," C HA"HpH@H1D% #< D" <G ] ] G  }( 0 @ #kG# C  ^( ~0 G  ~GG ^G{#y_ D-   =G4GPb#@ !.C A.!JR
AJ2F C   GY_ CGTGb#@  .C  . JQ
 JF CGYY_   =4GG@b#aD   =@ q.C .qJT
JtF C*Y_ D tG_G ]  ]( }0 @ #kG b#C_ }G4G`b#@ #,C .#HP
J0D CDY_ Db  Gb C|@GTGB7^ }     #     G# ^ ~  ( 0 ޴8 GG  ~G ^ B8{#_Ӱ"G4Gأb#D@  P_ӈ    b#_   G;   ŠGH BGG  JyJ  GLZkC /@ .GGXKWJb# GC ?F@ >  TGV_ D        Ű G  #." C.#JR
CJ2F C4`@ ` ÔaHG4GFأb#DB  O_G  Gb#TGV_ DDG ] ] }  ( 0 ݤ8 @ #kG#4G  ~ ^ ^  ~( 0 @ 0,GC 0.GGG0Hb#Q
0J1D CU  MX_@ #,C .CGTG#Hb#P
J0D CX_3     xb#_@ #,C .4GG#HP
Jb#0D CX_ D  "G CbTG)@G6^   $4GGb#      @ C.C c.CJS
cJSF CX_@ #,CC .TGG#HP
Jb#0D CgX_@ .4GC #.GGJQ
#Jb#F CY_C #,@ ,HpHA#H@H1D DC #<@ <G ] G ]  }( 0 @ #k J4 BH?" D@ #?F@@B ^  ~4G( 0 8 G  G  ~G ^G= GXb#GGW_G Cb#GGTG%X_0   =GG4GHb#  !. A.!JR
AJ2F CaD  W_ DD   G_G ] ]  }( 0 8 @ #kGGGhb#4GX_ D
  G Cb4G   C@G6^4GD b#GЀ@_H G4GXb#@@  . GW_G Cb#GGTGW_$   =GG4GHb#  !. A.!JR
AJ2F CaD  W_ D GGGhb#4G4GW_ Db	  Gb C c  Cf@TGG5^D b#_   }        G    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k# C ^G  ~ G( G{G ^TG( [  ~0 { C 5ZZk	  H "8 B4G@ bG	PZk G3 G = _&R"  c " 2D7 @( 5!H p@6uB
B4GG =B  G`B   ?# _#2aJ B   # B C  B  C  1" "	VB C C B_aB 0`B   ?#aB p@ 0B B_   GG ] ]  }( 0 #kG# ^  ~( G{  ~{#    ^  _    G  #  0  !  #G ] ]  }( 0 #kG      0   k    #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k# C@ ^0v JGTGH ^P ~X G  ~G0 >GHb#8 ^M_(   BC( bG(  GGtG=SZk CG_GC } Їb#G0  C CGG'_D  G(  C@b#CtG2'_ D8 }
  P BCX bGGGtGRZk @  G                                                                                                                                                                                                                                                                           T^s $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        x "     B      G@ ]H ]P }X ` #kG#0J( ^4G0 ~8 @ GG  ^#JG  ~ D  b# > ^ ~@ C GGG    = ]0v J4  ,4    } b#  H  @G GGG  4Gb#@G  ] D( ]0 }8 @ P #kG#0J( ^4G0 ~8 @ G  {G  ^G  ~    b# > ^ ~ @@  GG    =0v J ]4  ,4    }   Hpb#  @G GGG  4Gb#@G  ] D( ]0 }8 @ P #kG# 2   ~ ^ ^ ~   ޴   > ^ ~  ,GGG HG P D%J   G G  c.4G4G cJP`Fb ` G  /C #/G  $.C D.KY
#KG$Jb#R
DJG2F C CGGG_DG   	GBG  HTGG+vHPb#8 @  c.G .cJT
JtF C@_ U @G)    . #.TGPb#JQ
#JF CG3_ u @    #. c. C  G#JGS
cJb# C3F CGGH_  #, C #. CGG#Hb#Q
#JG1D CG:_	0 A+$A A 0@Ec G , D!! $,
HA
*H D  C4 @  " ÐHG4 BS  GGCGb#GtG_DGH  	ФCG  TGGPb#9   C- #,GCIA
#HAE C_ U @+    - C-GGTGIPb#J
CI
E C_ u @  B    #, #.(vHG C#Hb#Q
#J C1D CGGG_  , C #, CGGHb#A
#HGD CG_0`A&dA	 A  _!I4 AE4@AG DG ] ] }   ݤ   = ] } #k            #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#TG( ^0 ^8 ~@ GG#v J  ~G  >xb# CC_  P D   4G, GG Cb#4G_   tG# GC(b# CGCtG_ D   G G C G }tG` B  =b#<@  
 GtG ]TG =  
b#J@ D4 D  CG( ]0 ]8 }@ P #k# G  ~	 " ^H ^xH ~ G   ޴   > ^ ~ G .G  G	 .%JWJ  $VJFF >	 >4 a#4 A/&AJ'aJ(J [K @=G  . G# .JV
JF CaD  2Q `7aH4`@J  "7G8 G	G=  BGC|b#G CTGa6A   GEG,   CP~b#CFt B ] CG4GG1AD
G    D " C C   C / .JXKyJWJG ?F >  d q . ;  [-aJraJUJJAIF
RE > [= ݦF ݶGCCb#GGGtG}_ GCb#GGTG_D
G   P =F #F  
G D }
 4vHGgJ C~FfB `b#_Ӡs @  
G D ݤ H 
G G ='vHGCPb# C4 @  CtG_D
G GJ@Cb#EGG C CGGGO@D
G  4GP =CGCH b#TGFg  GG_Ӱ BP   b CGGtGLPZk  D DP CGG *.tG J.Eb#*JR
JJ
2F C ]GR_D  $
G* C A.!I !.s!I¢CRAJQ!JTF A>3F !>  G  GGG8F ~b#E   / $/ +,KY
$K  ,A+HGHiHFH2DD +<  <4GG2A	 ,	 ! ,C"GHGF
H|b#GD TG5A =-	 ,G	 !HI(IkHDH	 ED ==	 < GGb#4G!_Gb#GDh@ G%vHPb#G CTG._GGb#^@	 ,	   -C"GHGH
I|b#GD TG5A _EG ] ] }   ݤ   = ] }  #kGp#2FJX ^0J` ^TGh ~p x  GGFJP   ~GGb#GH ~%JG	_   G- GCb#GGG_"Gk_D
  GCb#GGG_"GG_D `D 8 P b# =H0v J_D$H C@   G G `H ]    GGX ]` ]h }p x   #k#4G ^ ~   ޴   > G  ~&v J ^#GFC }CGGb#  C C  G G CGG4GR@ =D	G4GP DFt=D?E'  CG_GC
b#GGGtGB@ 4 @G   =Cb#C?D  0 AC  ~G G C C ޶GGG4G'@	G 	TG?E??EF   =TGP Ft=F	GG ] ?E ] }   ݤ   =  #kp B#  0. C ^"   0J  CF?F  BF  !  .0@B   B?D  . J31 @rJW JF  >0 @   .G?D  .  Jr!JP JF  >0 @  .G?D  . JwJV JF  >  #k# G  ~ >  ^H ^xH ~ ^#  ޴ >(^0~8@ .G .GPGWJVJF >F >G >.&J ~/@ "GHQ:JrH[zK0F >>rG ~?'aJ(J)J
GGG   CBTGb !GBZk  0`A3cA? H C  . J"`BCGTG  1pyb#G5 B #FD  G3ADGG` =CbGpyb#TG?D = C3ADGG  Czb#CGFt B ] C4GG.AD"G`  =   Q C   / " . CJXKyJWJG ?F >  1 p Q- ,qJJQIkqJ@H
LE Q= D < 
4GF  G&vH b#?ETGCCC@F CGGGGG_Ә }!G C GG&vHC b#?ETGG D CGGG_GE  B`( b C4GWCZk @ Gb#G4G_ӧ 	?E   ݤGEb# CD CTG_   B CbTGG<BZk	   =G Cb#TG	?E C}_  4GGp  b# CGG_"GGD_GGDPb#}EP`D	E	x?Ev CM  GGTG_DGm` =G BGbtG	 AGMZk  B } C( b4GCZk B`@b CGGGtGMZk = i- i `HK cI `E i= = !. "rIQ 0J2F !> }  . . 3/ "J /V
JY7KFHzHXK;G 3?G ? ! `-  -  gHKgIagHI'IhE! `=	!E  =(GbCGtGPb#   4. " T.0JR
PJ2F C4 B  C	GGy_DG`  # " =. ]. . a"0J .R
PJUJ2FJvJTJF >F >/ G 4/ ' T/{#G4KZ
TK:G C
kC `  B CbGTGtGKMZkG C`b#	G CGGtG_D  cG ` . #.JS
#JQ#JSF0@BCJPJrCJ3F #>F >4!I Bt }!b C4F Cp GGtG$MZk  B C( b4G CdBZk B CbGGGtGLZk }h IgH? #yH "EgD }0H ].s0HG =.RPJ  - ,TFQ0J ]>I3F =>@
HG . E . "HWJxHVJFF > >"8 E/; e/EK[
eK[G C4@C   ÐAK4 BP `	0AN 4 Bt G_ BCbGGTGtGLZkGH ! } Pb# C CGtG_DGi b =,b  e ."%HP
J0D C!H4 @QF4`B 	3A"  =/ / "7Hp ݢY7Kz7HXK;GG =? ?b  e -Jb ,eJG CLI`b#DHEGe = Db < CtG_4@- 4`BG) G },   -DK`DKCdHLIaDE }< =  . %.p ]; .J8 .Q
%JEJVJFwEJUJ CF; >4 BF8 >"  Ð!JGC b#GGtG_G !`b# C CGtG_G G , }- } `CHGK
cI@yb#GD `GTG
2A -   =-
_E   IbI
&IG Czb#	E  k C @ C , k  ,G4GHG
HGD  a k. .kJT
JtF a C6.AGC@yb# CGTG1AG ] E ] }  ݤ =(]0}8@P#kp# G  ~ > ^H^xH ~ G( ^#08޴@HP>X^`~hpx޵ .G .GGWJVJFF > >GG >.G ~/HQ:JrH[zK4F >>rG ~?G . >  .HWJxHVJF >F >P`D &J'aJ(J
G{  :vH D CGTGC@F CCGb#GGGG_ D  GG)vHDb#TGC E CGGGGC_ D G =!pb# CGG_"G_DxDB !Dp C  D"  ]G1J@b#TG_F'J C$_	   =  !. A.!JR
AJ2F C G p }G4vHC0b#Ӑ`JCP`F ` CGGtG_ GTGb#
0@A  %, .%HP
J0D CGj_D G Cpb#GGGG_DxD	Gt_E ?EUG GR GP' C  BGG  4GC0zb#G8 F	  GTG0ADG  F G3vHDb#TGC@FCC CGGGGG_ GGCDb#TGG D0vHGGG_GDG`  . %.JQ
%JF C4 B @" Ð!J8 e.; .GeJT
J"tF C4`B  ÐaJ¦!
GG  ֢C0zb#G C8Fv TGs0ADG EGC{b#+   CCFt B ] CG4GG,+ADp"Gt =   Q C   / " . CJXKyJWJG ?F >  1 p - ,qJLIoqJ@HE = D < =CGGTG?D0zb# = C50ADGJ /   GC{b#CFt B ] CG4GG*ADpG8  !  0 C	4G  a C . .qJWJxqJVJF >F >                                                                                                                                                                                                                                                                           -Fw $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        { "     S         = A , p/ P#ZJ@HhZJ[zK D <hG p? F 4A GGCCb#GGGtG_DG GC(b#GGGtG_  D  p  TGG1IE@b#'J C_  
  p G/vHC0b#̐I CPE GCtG_4Az -  } ,z !; %.I8 .@
HGQ%Jb# EHrHPJ3F; %>F8 >' `CCGGGtGP_DG   z =,z !} .R ]"U .C/HR }.P
JGTJ b#0D2Hu2HSrJFU >CuFR }>GGtGe_DG  ~ }.~ ]" .z !z =,"} .rJT
J` /HBP
JbtF0D C CAJ!H4@B"4 @VF1DCGG
GFGGTGtGIZkp"` z "} .C  	Cz .WJ  .  " @.VJG0JR
PJ b#G 2FHxHF} >Fz >GGtG"_     ,. ,  .IrIQ!JPJ3FF ,> >4A
0@AS G"C8b# CGGtG_ DH  "=B="Ib4 AE?DG CGGtGIZk  	}"GC  .G @.tG b# JR
@J 2F CG_ D  	$  4A (.I .rIGQ(JPJ3FF (> > GBCCbGGTGtGeIZkz -} =-z !GII
(I!E CI4 AE 4AGt_EG =. " ].C  bTG0JGR
PJ zb#2F  GG/A - - =! } !	IO
IpDGE`{b#     ` CC , e-   CHK
fIGD  ΰ %. E.%JR
EJ2F .G C4GD+AG	C zb# CGTG.A - }, !  !IbC
oHpBDGE`{b# `  J  CC , - *  CHM
IGD   *. J.!JR
AJ2F $G C4G+AGC zb# CGTG.A EG]] }(08ݤ@HP=X]`}hpxݥ#kG# G^G~ (0޴8@HGG  ~X}G`]G^#GGGb#1J3aJ
 @1v JC  CFGG CCGG_
 G1v JF b#C   CCGGGG+_DGm  P]P`D  CGG  r.А J0b#tJS rJGtF  r>   =GGG_D  BGU ` G( bGtG   CHZk GL . .. = 1 =.GJQ
!JF C!H4 @"2D4 BG% `GGCb#GGGtGd_D G/   }"0JJaJD  	B `	BG	 @4`BtF4BG4B  G !4 A4 A  G G   BаC( bGGGtG<HZk }G  ,4`@`DE HbHD  < DG]]} (0ݤ8@HP#k#H ; G^ ~޴ (0>8^@~HPXG  ~^ " /H .yH  !GXKWJG ?F >G ].G	 =.G	 }#G@ GGHR[JsHQ;JTF ]>3F	 =>`ݢ5 @h# #Dzb#'J(J)J*JGF  CGGTGw-ADG  C  TGGF  Czb#j-ADGG  C |b#CGFt B ] C4GG&(A
DBG =@ =   r C4G  ?F = S/ C 3/J{JZSKY3K@G;G S? 3?  R  2. - !JQ,JvJMI7F 2>
E = GgGG'vH	?Ep]TGb#C C E   CGGGG_
D( =GR
_E @ɐ IG	P E  KGP`DG E = Cb#GGGG_ Dw6 ]-6 !9 =-"GMII
-I	IE	 C!I	4 A,E?!4 B% `GG`= b# CCGtGZ_
DhG @h=?"-IGI!H	AG
 `4 @0D	G4 BG_0AD 

E	  4@_0@D
 GG0Bn}"8b CGGtG2GZk GB`]"GCb#tG  j , #,HA
#HD C4 B   CG_D  G h . ', '.G'HP
JIRGJsIQ'J0DTF G>3F '> C-  . " .`#0 B CJ8 bW
JGFGtGGZkG C`!pb#C  ChGGtG4_D  JG  j, ! *,mHQ
-HA-HF0 B
JCmHp
J1DpD *< j<3Hh]uH0B C ݢ4`F4YJ8bn#Fh C`}GdݲGtGFZk4 A9 ,# `]6 =,6  6 ,G 6 !@IGQ Jb#r@IA HHF
HI3F4A9 =>"2D C6 =<CDEhGGtG_DGk  G   !b# C CGtG_DG^ `G C ] C`Gpb#tGh] _DGP `EhC  "H4@D 
4 Bh; GG =!Cb# CGGtGq_ D/  0 B } C G8 bGtGFZkE CGG   Cpb#GtG , 
,aH4`@H@

H_! D _ D    lD , -HlHFHHIDE <	4@A =G?GC`= pb#G CGtG_G , }  ,
C@ GHGG
Hpzb#GD `TG+A	 , =-	 ]!  EH¤I
*IG@ !{b#D  Ơ   C `C f, &" - CGfHH
IhD  ` F. f.QJS
qJGSF  C4G)(AG	Cpzb# CGTG+A EG]] }ݤ (0=8]@}HPX`#k #`0J  ~    ^ ^ ~   ޴   > ^ ~ G4  ,4   #G  HGGGG   GH 'v J C CGC   CGGG4Gb#_ =	G4GP DDt=D*   
GG_G_GCp
b#GGGtG@ 4 @  
0@A	FA`A? CCCF  0 A  ~G G  CGGGb#_	G 	TG?
=E @ }TGP`Et}E	G GG ] ] }   ݤ   = ] }  #kG#G ^  ~( 0 8 ޴@ H GF  ~ ^GGGGb#G'v J  C1_ D@  Gb# C CGGGGh_D ݴ3   ¤G Cb#G CGGG[_Gb# C CGGGGR_`  C@ BTGH b  砈 "$ ,' ',$  HA
&H D  C `D  yZk     C@ BTGH bGyZk  GGb#GTG_ G ] ]  }( 0 8 ݤ@ H P #k        #Cp B  .  0.!1 B71 @T J 0J11BuHF  >0@B  .G_F  2/ J{JY 2K;G  2?0@B  .G_F  r. JtJS rJtF  r>0@B  .G_F  2, JvJA 2H6D  2<  #k@#GX^G`^h~px޴>^~G  ~GPb# G_ D  b#
@Ӑ{ "p = &0"#  C!>HG C`b#  4JwH0@p = CG~ .0v H{ .tGVJUJFF~ >{ >V._p CGG =b#tG0v Hѐ H/i@ D  4GGXb`" B _"b C C  STGbyZk8¤ CBTGb C5gZkG CQb#= G CG_"tGGX@ D  4GdÀB  CbGtGrDZkB` b C CTG=yZkBb@ CTGgZkG CQb#= G CG_"tGG4@ D  4G@ð" CBGbtGGNDZkB` b C CTGyZkBb@ CTGfZkGp  Qb#  C CG_"tGG@ D  4GÐ¤ CBGbtG C*DZkGGxG"TG  ,Gyb#F H  <  ,0¤@ H  < C  ),A )H  )<.AB CbGTGxZkGGxb#GTG/A  .   	  . CBTGJbQ
!JF CGfZkBN@b CGTGfZk` B Ch bGTGfZk8GpBTGB0 !b C  
xZkG Crb# CGtG'A D  4G G . %  %.CP¦GJGQ
!Jsb#!F C6 A"6 a. C7 .GrJTJ4GtFt`BsFGWJ  $AD`bG 0 "Xp C  ˢ   CI0  aI   , v/@H[vK DaG < v?0b#  K q . " .tJxtJUJWJFF > >  8 F  G@DG  B  
AbTGYxZkGrb# C CTGtGt'A D  4Gf GCsb# CGG4GG#ADG  =  C  k P C "I  TyI / .XKWJG ?F >  kTG 0B , ,;JGHr;JEHD <D <  
AbxZkG Crb# CGtG9'A D  4G+ GGCsb# CGG4GG#ADG  ]! C  + ( CIuI  0 . a.TJSaJFuF > a>  k Ƞ +/ / "HY7KzHXK;G +?G ?D8`D ` b# @ `	4Gb#  4 -4 G!h*IL IE4 = @  G8¤{ !p } 9 ~ ]-{ =- ChIGJHI0Mb#lHI(I
AE~ ]=	,E{ == C CTG@~ }-@{ ]-{ =!HKiIGlH0Mb#JII`E
LE~ }= C{ ]=GTG͇@~ ]-{ =-@{  HGJDI0Mb#kHI$I
LE~ ]=	+E{ == C CTG@ G4GG`rb#G'Axb4GG`rb#G'AӰ4GG`rb#G'A DGX]`]h}pxݤ=]}#kG#4G ^ ~  G`{G  ~ ^  G( {(  .+  . JQ
 JF C_  c4GG( b, #,,  / . HP
 J0D C|_b#
@G ] ] }  0 #kG# "P ^GX ~` h p ޴x G  {G(   ~H ^    0 [ C  # _"8 {"  D  a C  "1wZk@ BGC P @xG   ub#G 4G p$A D+    #G0 B"  8 bCwZkG
  "Y B0B  ٲ  #X BB    ز0B  #B?C @x¤GTGG C ub#CGGGJ$A D  0`@d@0@? GGH ]P ]X }` h p ݤx  #kG#tG^~޴G`{G  ~^  #0G  .     .Q!JPJ  >                                                                                                                                                                                                                                                                           d&x $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                          "     d        >  C 2, ,A2H 2<@H <  [ 0, 0" ,A1H@H 0< < $  R C0 }C @G3~J;" `B0 G> .0v H; ,; }"`b#3HTJuH@HF> > D; < C~+_0 CGG >b#tG0v Hѐ HWf@ D  "GtGb#G&@GGG͋_GbG
_B` b C CTGvZk8 CBTGb CUdZkG CRb#h= G CGGtG4GG@ D  "GtGb#G&@GGG_GbGm
_ G C {b#4GuAAG C=b#h= ?"l=G CGTGGi@Ә"Bf b CGGtGrAZkB` b C CTG=vZkBb@ CTGdZkG CRb#h= G CGGtG4GG@ D  "GtGb#G&@GGG__GbG)
_ G@ {b#4G1AAG C=b#h= ?"l=G CGTGGi@Ӱ"Bf b CGGtG.AZkB` b C CTGuZkBb@ CTGcZkG0  Rb#h  C CGGtG4GGw@ D  "GtGb#G&@GGG_GbG_ G@ {b#4G@AGh =b#? l= C CGTGGLi@Ӑf B CbG CtG@Zk 8TGpB0  b   CuZk¤0GGTG0tb# C CG#A D  "GtGb#G&@GGG݊_GbG_G {b# C4G@A &,   .0b#P HP
 J 0D  C6  "6 @.4G7 `.QJSqJSFt@BRFWJ  7_  ¤tGGGb#G@GG_GGb~_B@  TGbjuZkx¤ CGTG0tb#TG CG#A D  "GtGb#G&@GGG_GbG__ G@ {b#4Gg@A   C ¦G_"TG  APtb# C  C G  4GG"A Dt B@  TGb2uZk¤ CGG0tb#TG CGM#A D  GtGb#G0   CGG]_GbG'_ G@ {b#4G/@AӠ   G CPtb#TG  4?  $  $ C  CG4GGT"A D<   4GGGXb#tG4 ,4  aHTGG H  D4 <_Gb#G4GTGգ_PGG b#4G CG4GGGx_xGGTG b#GG4GGGm_G b# CG4GG4GGGc_G4Gpb#%P@ C_G C b#GGG4GGGR_G C`b#GGG4GGGP_GC`b# CGG4GGGF_G&N@C`b#GGGTGGG;_G H =b# CGTG4GGG_G CH =GP }Gb#G_G@ } CH =Gb#GG_G P = Cb#GGGGG_G D@P =b#GGTG4GGG_G H@P =Gb#GTG4GGG}_G!D@H }P =Gb#GGG_GH@H }P =Gb#GGG_G@ = Cb#GGGGG__G @ =b# CGTG4GGGT_G H@@ =Gb#GTGTGGGI_G@ = CH }Gb#GG_G H@@ =GH }Gb#GG_  à CGG`b#4G@GG_  c CGG`b#Gd@GG_G P = Cb#GG4GGG_ BX  (b CGGtG9ZkX }G B&H(b PCfDX }GGTGtG,Zk ݤ   B HC(b&HG @ GtGtGZkG CP = Cb#G  4G GG_ Cb#@ GG]]}ݤ#kG@# G  ~y "P^tGX^`~hpx޴>^~ >.G >,G "HGQ0JrHA0H3F2D >> >< GG >. >  .HQ!JrHPJ3F >>F >G| .Hy .wHVJUJFF| >y >G  'GG GG?!  0J ?&B > xb#0v JC CH(_Ә  CGG@b#tG0vHѐH!c@DG PB }" .C .tG CGSJ"UJRb#vSITJF >F >C@xbBA  "zWJ  + HWJ . H a. !"HTJuHSqJFuF > a>C /G =/C
DAXKY7KGG;G =?tGRb# ?͏@Ӑ p" "  +zWI HWI L . q.
CCTJSqJGHHuHF >uF q> /G =/XKY7KGG;G =?tGRb# ?@Ӑ ]   k
1@E*AI +. +  @M .Q!JPJHHrH3FF +> > H BCbGGTG  8ub# C7B#ADGG  Cvb#CGFt B ] C4GGbADGo`xb?"CC  + . a.!Ju!JTJSaJFuF > a>G    W/ # 7/J{JZXKY8K@G;G W? 7? C TGG8ub#D m#ADGG  CGCvb#GFt B ] C4GG)ADG7  +?"C . A" a.2Ju2JTJSrJFuF > a>C  G  W/ 7/J{JZWKY7K@G;G W? 7? C TGG8ub#D 5#ADG x "GCvb# CFt Bx ] C4GGADG  +?"" C .!J a.u!JTJSaJF >uF a>  k  +/ " /JzJY7KXK;GG +? ?x   J D5@Ax xb  + A. !" a.QJS
qJSF*1 @h @GCCb#GGGtGI_D?D BG W     b C4GrZk =(  _" }G4G!Hb#4 @0FfJJF @ C `_  ? G=G="8Db#	  CGGtGR_DG # À  PA  0=  P G8 BC@ b?DGGGtG9}Zk     . @.@Iv@I JR
@J2F= . .UJTJFF > >CGCGb#GGtG6_D?DGo *1@A_   P. p.PJS
pJSF'1 B GCCb#GGGtG_Ӡ   BC bG4GFrZk =e  _" . . }"!H4 @0FJGF[ @U
J"F CaJ4`BvF4G7EG  
G	G G8 G  8 E @GC CGb#GGtG_D?DG) GGCb#GCGtG_D?DG  =. ]. " }D0J R
PJ "2F CpFD F C   ._" }. "PJ =TJuPJSpJF >uF }>G =, " ,HA7HhH@H8D =< D <=4G' C?DG8 BG@ bTGtG|Zk   }"  .  .  " @.  # .UJ0JR
PJTJ2FJvJF >F > @/H  /{HZXKY8KAG @?;G  ?GC(b#GCGtG_D?DG '1@T8 EG  CGb#CGtGr_DDG  + 	- - I!
IL
IE(1 A  GGC= @b#G CGtG%_    +  - ),	Is	IIA
)HE= I. ).RIJQ)JTF3F I> )> ÕHG4@b#"D  C CGGtG%_Ө =]"= C8 BG	*E@ b 	D  
?DGtG|Zk  +] ),	I 	.t	I)HP
	J0D= i. I.SiJRIJuF i>TF I>| G . " /"
4GJX
K}#F CJ4BFC4 B	G @G C@b#GtG_
   ].?  =. "0HRPJs0HQ0JTF ]>3F =>?!4 A* Gݦ=#0#B C6Jb7JJJ C	B GtGG{Zk8=? 
GG="@b#!I	4 A E C4 @	GCGtG_?!? 4 A8= . @} # =/G .xJZXK ]"@G{xJ ]?Y8KGJU
JC;GF =?(b# CGGtGۿ_
 G0 8=C] Cb#G=G8]tG_G b#C CGGtG_(1 A,GG8b#D@ӈ =GG(b#	?E =@V   8 ]!  CG -   ,-Chvb#GII
%I C	E   C ,.G L.G,JR
LJ2F  G4GWA   ]!¢ CG , H" -Chvb#GHL
IGD  C h.G .GrJT
J4GtF   C;A  k  CG - +! ,Chvb#GIE
H CE  C +.G K.+JR
KJ2FG  h4G AG	D'EG4Gb#
4G C_x GG4Gb#  - I   o_GCxb# CGGGGGQ_GGb#4G4G__	D   G Cb#G GGG_DCG @G8b# CGGG4GGG)_GD" `}E
 G )!b# C CtGGG_  }EDGȉb#G4GR_xGhB4GGG  Gxb#G@_   CGGxb#GAGG_ Cb# @DV x"8 ]!B CG  iCGhvb# C k, ,  GgHE
HeD h C +, .+HP
J 0D  G4GA   ! CG e, " e-Chvb#GeHK
eI CkD l C %.G E.0JR
PJG2F  G4GyA  ) B CG i-   i,CGhvb#gIC
gH CcE l C ),G 	.)HP
	J0DG  ,4G^AGDD }, - }!"
CkHGH
Iub#GhD `GTGAӁ , ! ,CGHGF
Hub#GD TGAy },| =-y }!BCkHGI
+Iub#GiD `GTGAGP] DX]`}hpxݤ=]}#kG#tG ^TGG ^  ~( 0 G  ~GGb#Gd_G Cb#GGTGC_GTGXb#  $  .$   '  .JQ
!JF CG_Ghb#G4GTG_Gb#GGTGߛ_Gb#GGTGߜ_  GGb#4G@tG_G ] G ]  }( 0 @ #k #C`^   Gh~1nCptGxG  ~GX^   > $  {G!>HPb#  @ G .0v H ~. C   HTJu`HS`JF >uF ~>7#_ GCBb#G0v Hѐ HtG^@ D"  G                                                                                                                                                                                                                                                                           u $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        G "     d      ,AZ.|lĹhdٹK-,Cc}i'm`,j(%iݗ [NL[Ӫg.hQz~Hjxg&IBzu68tWb%Bԇo'R3
 w]%\Um`o	Av_6ۉ	%TYw]߈t0UU𨖎MiG;Oogqv|4ޟ0lLg#nO{1	@w
z<^QKzT~GƥaAչfkoжQC[k"^<`Ĳ@
L=u
4XpB"8o]̄l`$HhX/Z=<{E^:xWMd-iË<HHB6~O.t˕o#),58=`9Z_дQOmuΒ
&tZx=|Y4 ?Ț>`_ӏ|8b~N!Po 4Ml;XZb
RyնXxrr {.ɑ(93#j@wpRq0婄k}"Nc=pCy*zh(B݀C\Gi1py{l[Nf6DBRe}ЧM5܎+ϯqDr&7xa`r8#PmtӍ	aMgT'#!ݝ{P)?}g(1p4iU,m63YeS0yz0#njMg*^	JQ yeܼR{+EF<-[cǞpvGw(!tgv~B=u]h^OVa`"/a_!'H|eꝶ)WvH,i6BEBsS=?g@aјBEa\A햤uYxps@dVTYz`zriJ6kᓭď.:1_DJs
c^[.qΕj#C
oOH		fbB>K7ϙ몖بeT+lv%>NB$̻e#~{|]z|"߄+!/Aw%5[q~4h!zڕ>s~hI
D>#²ǭr"ºB&O`}w%
grC<985x(AlBkk~E&B%N'C*堢w(neٍ鲜$pV"5PW?C^];vuyC}Qal"B(cڭ[I;ώDӮe<g8i cQ
D;9%֧p_GTõ-V
% xԫ,$H)lN_?
q=98FB$7gW/$u<fwU(Dx'Ϫu=2|Vo> G4p=2UvemI kIߍve|` b(P\8lbӂl|o!Ei=lm&>PI-3;F4% HHG>:;-xlmv4f[ŏɖ~`xH^;K=q?Uu2(e-7߁"
<biAO͵pk1zE#	Hp(?n<LSb~Rq[4bks)L@UX`#|hJvrƐY6b	#58js[;34j!{Rp̗iu@emVtb$Շ2g	Py06)?20<9 @ˁb:<(uCH>(N4U0ŲCKOlSǋEJ^+FK%c:t7VfTr;֣V8M
g]*oP^ jIDq⍋4: %l	)<J'RC)36:1 ߊd|àz>1/G,kͼ4m)+*or5i
D~RQ	x!VN-	J.=΀AO@XjpsѽQZ
"1ʤp/vO+n{J"?ilsbl{
:p3Z¨;t$ħޡLiF6I^<[uԓt˙/T94ov4ݿMeeFQ UJ4>.{%$G EhvwH?#Z0Bƚ1]ƀ bdeSXz~Yw#L f9bng	oDKPsHE`,LƲ`[BQ
_\U*Y<!J3yCK&dһzL @eon]mSE9L zd%|B
deѦE^h<hj( gN/%Δ/GqsK<>~V;vd<=x!%k>|u%O dͰZV^/k>Ѫi๬.9~d6Si~*X
|&4#Hc`>H:>\A:SsO-5:1h[I!
.N\ul{=@l{р :&-GShK\h@B]/bK`JK'0px;&޵[puf_6PwRPkF=N
eaY/}C.AbrTLg2nX.Ƶ	Zqb/']<"%xHf*J|`&iAn!.Lp`"Mx{Pl<Lr>	oUXî]AL
{:Ao&z}9nllik uXZzЗZteQňj,bS>AZpC}7RTBϓ*b%\(uO),*Y# f1j
BՅaWѱ7{h$UkƉ?5K
&]ʸ'p@B
ebt0?8so/Ru Q;=A'smwnWy_O#C8m+Ⱦ/0?XD{bu~P4\fGVtҾ2 2J1DYN)4H#zO/:z8PpN4ߞ?j6a6%`Mͫwe|;@!Wʆ(Ӝo?ՠTvϳ++#<,0b3WVLetJޞ)9$@۶AboOKjφ#j	6m&B(D;Ϫ=8aO(qNdH?86Dgd;VHk2ȷxR*=oeU13_CBXM9#	luW6HPjpY/0b˽pȣ8q
8TP!kl
rJKLR5X.܍D~E"R!(;;cζY5%=lbsTR$)J=;U1m㳇+EM-Ynӵ C[4L&v5ڒ?'.[KaǼHC8LL$Pd?-ʀm	6aWz)"8FE25yEA\<013ln"*_εSbC8]D֧;73E.bqegWdc~_pEb<(#Xz%i
khKBi#,^ ,}i\B9V
&4QS/_Rp]\4sÌ&&q[7AaS~=E͂e&qοSRφ݁{i*¡P

سb^!ahԊŔ\W>uXIـ:_n6ӕ!'繶}vJ^󂴻g3V.qBG]𚃶nநk$[
S
8~_=DmnGT-hYzg,~Dݠ''qF~Y.Crc5hCڿmߋNi5s%b˹a]Ĳbpxj>
p4$
ǀEr2x.O}p\@33@נfx]C7<}̀<lcmGٜJsv]pZu[7 {bZW܆å[zd(_1ұ~-3~Dpȓ">]T;c򌽐
\6"^k~ɐڲfpZ0Q[pEZpuK,bmG**:R
٢k!"~>O)v
^bvUѿk JW׹pGvP\6\5>5X)@럯 UؑvJq W:ܿQ*QO="@] j"#?/ٙe<G <6[]GE%e-eVC
'3fgٴ)cV{ j S_0>'ۯ0ZRb&JXd܍URu	}
<ph4!6/-}wuVήQԛ-hT?W ?@pECsU`PĔI>=	U'%%.eEWrRU6PlHx}2w
qƎP-*'gt<W\
6/E^WvVN}`m.N@.VdV* \Vu__֔c> ؍u_CEORk娑.	;xBTҞSR@^'}mBVKa	SM{UͤL
nD:pK).t=!_55(oVm}hq.+O9OO~u/A*N(S[:*E~JF*&sW6]W2F[MrHhVv|eڕpԐJ%+j+q7*Wq?8`iTMm=`PV|1SƷB#=	=Roe*n4Zv
-}jCcp&`X,=mp)n$Ўrݫu7=	o-/j{\钹c% )ir>܆DxW7CsrBر (bR/s_Ujʮ9%?L?=ҡCV^;_-ƵPuIsg!OZ*%h&A] (gxɇM-MʅRi\Ni-m0ȧ@ݺqYH6_^O`x>wtHdi4O6Ѭ:|8]X4h?N}XO7j#PRb즍HbIfΞ:섽TbX"w!#|Md9qk73ImWZ#8Uǀ,N_Q&wאĉv=#eC$ϐ%b
V0?<Ltg Com
H+ai
Qم=Bl0;ʮUdϛ_*z{658IB CzXR_b.#ɓQUI_&2#|0m7DdÒP5	t\N%&Y_8=ʹٿ/`w&r'GZU<(e0ks0xMñ|.ȳa/B+tSxR-jetmAT7*狱-oyլ&ݲq%M1Cjߒ薪7u
:^+#L;Sfzj%'*K$;V: e,!/tf)$IeD@oNT.$#jkqc,5oh7X%4ײlIg=}h+<+kASdn/,2A
̿?0>Akn9Q#IZ]~ b޵vz_@ȫ`Tp$'>2][U;`qPAuJ#>@k\8e m;w׹vh8] ͇5GbܑT^ d
|
#*2i?°Ғe:e<HEZ^}q(pff! &K.EuM_\	#M]ɛ֥:[nz{m'd猧$ ԉ<_ɱ[2*
m/CWm&f
pR6	Jqu&n@`#̮~ueʹvԗ͵Ɣ\]0n{f2ykKG	>!3*Lw%(t2_f,jDjá~J/WjSK;-TPv+ ic5..ur\49X|1|BWm!G{tC,׵n{\@bJz}Fǡ:V@X}G7^+ʵڝ0	[VF	2L}HL6j,7|FVRc߭^%=M|&=KʥVPmb7>\mM!p&Ww#Viv*匆

xt*X$lBRj=g8%%Q&X%CtbB)ujH4QQ$pgऒܚNTQԮ(ZDuKZx;[~b[튉vqLxƀ|O(߳"U.LeGٕ7ǀ]^12m%2h.lb-
/=	B
iK	/ÙZok$*wf3hҋyE\YѵܺOؓ8uѶCږD?A4NDJ\k,^n9_p	yDc
;,jM'/7-72BLTB

Ѳ1_4fa6da`y/ϭShTh% ̃SioYF!8wI+qpƀԑ>#T*k1;! Fȧ	!yG-j/?hqZVR݃Ń@jF~{<u0⃇ջ^Yw3e@ǅg4-`_yK{<Xβb#á(xnyƝ
^Uj`{mVae" ;SS
bHiB;*sqS͵ZNV,
-*CYRΐT,B.)0-$X|J,[bSdSt4IrH99w~V˯MpIM?s!mr:J팵BQK<^%+Cְ
& %v>CYEwsb|:1-~S`
~ ֹpMKhe(f>Lpl=wYQޓ[O
Gs~a5DSwi;BB#!=P6tz z,<ѝ >YoA2(ju՟KԠ`.Ǆ̛N $KS-$ K8{{'Rm4XۗD#WzyTǵck S5E[K;Eطt@0*|L:qF#{ZMfg#eڧ.`R1|7Y' 8LL.UP?2orؤ^ h-ER{'A]dBqTV%>EH/nWwwԭ]}9+zQA<*Ҥ4.^K
W,hPYψzUW2V///!Sx2Z
|e:A%JSܴ	=))Z4`&^j\TNT
xT)l?k俾`E,79D2`˲w{TRVū{U\A*vZ΍چ4Mvmr4an_ݰG_3סCDQ]V7/	֯>ldI5.03V=[K޿{ǷпMUf+La:՛nGu!RglRdg2z2\y`1)M˜DP0)[hʕOk                                                                                                                                                                                                                                                                           v $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                         "     u      b#tGGGGG_GbGQ_B J@b CGTG<nZk(  CBTGb C\ZkG CxWb#CGGG_"tGG2}@ D"
  Gb#tGGGGG__GbG)_	 È" p B Cx bGGtG?yZkB J@b CGTG
nZkB@b CTG[ZkG CCxWb#GGG_"tGG}@ D  "GtGb#GGGG._GGb_
 G " p B Cx bGGtG
yZkB J@b CGTGmZkB@b CTG[ZkGC } xWb#G CG_"tGG|@ D  tGG CGo G} p B Cx bG CtGxZkl ØbTG( "`   ,B&@    HbG mZk  G Cxb#GGtGA D
  bGtGb#GGGGԂ_GGb_h TG( "`   d,B(@    dHbG `mZk  bG Cxb#TGGtGA D
  GtGb#GGGG_GGbz_ӠbTG( "`   ,B*@    HbG _mZk  G Cxb#GGtGyA D
  btGGGGGGb#_GGbV_P4G  DG4 ",4  p`HA  H G0D4 "<X]`]h}px#k#0v J ^ ~  G{G  ~ ^  #0 !.3 A.!JR
AJ 2F  C  F   G. G, ., a"/ .4GGJU
J@b#F CS@  4GGb#3  .0  .Q JP J3  >0  >  C4 .4 "vtJU JF4 >  c, // #/, "KY
7KG C4GF@GtG0b#4GTG4_ GG ] ] }  0 #k#4G ^ ^ ~  ( 0 GG#v J  ~Gpb# C~_   GA G@ G  $4 .4 !" J  8 , a., A"/ .4GGrJT
Jb#tF C@XG4Gb#  @  b#3  .0  .`Hr`HQ JP J3FF3  >0  >$ @b#._G4G  `b#@  G4G`b#, ,/ ,, d H@
HD C@Gb#tGTGTGف_ GG ] ] }  ( 0 @ #kG#;4G  ^   ( ~G0 G 8 D  ~ ^G  Gwb#AӠ4GGwb#GA4GGwb#G~AW G  ?$GC"b# HG @ 0v H CtG<!_ CGG(Bb#tG0v Hѐ H\@ DD  `b . ]" }.C CG2H"TJ(Rb#urHSrJF >uF }>4GtGq|@ . }. b@ ]"GH"TJ(Rb#uHSrJCFuF >G }>4GtG]|@ =. ]. = d@GaH(Rb#saHRAJQ!J"TF ]> C3F =>GG4GtGH|@ӈb D  C4 .4 " P J4 >G ]  ]( }0 @ #k#G ^TGG ^  ~( 0 G  ~G 4G0 {xMAӸbGG4Gb#G  tG  0_GG`b_4G ?"GTG   0 b  `MA  G
  Gb#4G _"tG_G`bG_xB  Gb _"tGwZk      .   .HrHQ JP J3FF  >   >      / " .JyJXKWJGF ? >  cG . ,HqHPJDHFD > <  c@ b . . "HVJwHUJF >F >  # , 9,HpHDHA9HD0D < 9<4G  CI@3 .0 r.TJ3 >SrJ0 r>  4 .4 "W J4 >  C _ DG  b# CGtGGG_GG`b~_  4G"G( $,+ .@ b$HP
J0D@  1k _ D
  GI@b# CGtGGG_GG`bb_  c" , ,/ #,,  pHHA
$HupH D  ; .G8 p.TJSpJFuF; >8 p> ] ]  }( 0 @ #k#4G ^      G  ~G ^{#      @   G Xb#_Ө4G   4  .4  "r0HQ 0J2F4  > GG ] ]   #k C [8 0,; 0.0HQ
0J 1D   C  [  !. ,!J@
H  F ;  , !"( a.+ .( aJT
JtF    G, a./ .qJT
JtF  2k    p B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#4G ^G  ~ ( {G _G ]   #k#4G ^G  ~ ( {G5 _G ]   #k" @!q@B
2@ G `    F  Ѣ 0 @F   0 @F   0 @ 1"G   0 @	@?	@ `G   1"F  0 @	@ kG# ^  ~( 0 8   ~G G ^G @GG_B CbGGGtGuZk0@	@@G ] ]  }( 0 8 @ #kG# ^ ~  ( 0 ޴8 G  ~G ^G @GGGBGbGGtG0@puZk	@@@G ] ] }  ( 0 ݤ8 @ #kkGkG# C0 ^0v JGTG8 ^@ G  ~G( >pb#G_ D	  ( BC( 0 bGGtGEuZk GG0 ]8 ]@ P #k  ,U _"2DJ ۦ p" / H1$H12B P.$J " SJ p BRB5UB5J1FBs1B.4!J1 JW H CWJq1B3BJ 3B K   B  @  @p D   ]@B0 @VFkG5B]@B0 @VFkG#G  ~{# G ^_ Y/@@ 9  9.` @ AK H 9# @0 HG ] 9J @@  B  @  #k    #Cp B!1 B  0.51 @ 0J  2.sHQ 2J3F  2>  .0@B_F  . J!1BqJP JF  >  u.0@B_F  . uJqrJP JF  >0@B  .G_F  . J`2HU JF  >  #k#4G ^ ~  ( 0 GG ^GG  ~  ({^Ӱ B  ,@ H  <  #, #H]"@n  !!H\<@C  kG0`@b#4Gk@b G0`@`b#4G@\ G0`@0b#4G@V G0`@b#4G@P G0`@b#4G5@J G0`@b#4GK@D G0`@@b#4G?@> G0`@ b#4G	@8 G0`@b#4GK@2 G0`@Pb#4G@, G0`@0b#4G@& G0`@ b#4GW@  G0`@b#4G@ G0`@ b#4G@ G0`@ b#4G@ GGXb#4G3A GGXb#4G-A 0b#@  ,4GGaeH  4G@ H8b D  <^G ] ] }  ( 0 @ #k#    ~ P" ^TG ^ ~  (  0,GGGGb#  H   0.4G 2J+  G`JA(  XB`bGa@GGtGtZkG0 b  "G4GGGGb^ G ,   #, "bTGHBA$Hbs" D     #. C.0JRPJ C2F)pZkG ] ] }  ( 0 #kG#@  ; B ^TG G  ~G ^#P[G "GX{tG  >  G  iZk  "0BG8bTG!  CoZkG ] ]   #kG#  ; B ^4G G  ~G ^#[G G{"  >G tG   iZk  P"GBTGb!  CoZkG ] ]   #k#4G  ~ ^ G  0, 0.( [0HQ
0J0 {1D CijZkG ]   #k# 8 F ^X F ~  ( 0 ޴8 @ H G  ~G ^#{ x F x   x ;  , H   GGTG  b"( G  0tG  ,`@X B?D  #,H   C A
#H` b DH "   GG"     >liZkG$  BGbnZk #,   #. " C.TG  Hb8 B0J%  RPJs"@ b2F CgoZk . ,  "TGGJ@Hsb#!  F ClATG bG8 BTG@ bxc  CPoZkbGGTGsb#c  CZAӈ BG( G bGG2iZk  8 BG@ bGG@  CTG 4oZk CG] GD_x b G  , H `YGBb  %?DQ jZk  ¤ C( btGX B .  &,HqH¦PJ` bA&HF1D >  &<  c " C `@  GG  ޶ G G  GhZk0 DG\ BGb8nZk  HU  H b  _ CX B C` b C  G >G " G  tGhZkG  BbG  nZk -   &, . I H!  P J0D! ? ("? G &. F" f.TG  8 B2JSrJ@ bG "3F CnZk . -c  CJHIF G4G   G ¤G8 BTG@ bG   Cc nZk CG G¤G  tG8 BGx  @ b CҒHnZk ! CG ¤  c  CВ`H ( ¤G  TGH "h B C , !p b@GD H <G ~tGb !    ~  ghZk0 DG  e, hH# ` E. . % "tGAJ8 BPJ@ bG'BPFGG\nZk ! CG
 G . e  ,JDH!F CGsb#TGTGZAӈ BG( G bGG2hZk  8 BG@ bGG@  CTG 4nZk CG]  GD_ ( G Gh BG  !p b A  G  G tG  hZk  Ȥ0 DG0   bGHH "h BG) p b`@  G  G G  tGgZkG
   #,   . C. %HJ  R
CJF G( G C. c" .tG8 BSJ@ bTJGTFmZk GҒH8 BG@ btGGx   CmZk c  CG ¤    CВ IGTGsb#A GG ] ] }  ( 0 ݤ8 @ H P #kG#P G ^ ~G  G( G0 ޴G8 tG@ H   ~G ^#{GP[X{@ c   `@     gZkGr    #"$H1"  В H Cn G4GH b4GTGGAGG8 bG4GB	_TGb#_G@    B( bG4GfZk @G
 !%  G .G ' p BqHx bP JGF > CGtG,qZk ,  tGb#@ H <_G  TGb#_G    BЁ@( bG4GzfZk @ .4G ' ` BqHh bP JTGF > CGeZktGb#_GpB GxbGGG1gZk                                                                                                                                                                                                                                                                             + $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        ϝ "           GGTGob#  CHAGG b4GqGA G
 GG! CGTGob#8A GG ] ] }  ( 0 ݤ8 @ H P #kG#TG ^ G  ~G ^{#T_  (TGb# 0. "r0HQ 0J2F  0>tGH_G ] ]   #k#4G( ^0 ~8 @ H ޴P G  ^GGG  ~  {^P   8 D  TGb#)_DGj  GCG b#GTGB@DG`  G4G ؋b#3_DGX  GC TGb# 4_L  0 GTG`
b#  0, 0H
   = q. . Q"GrJT
JtF C,@ ݠCGTGb# , & 	 &" H
  	 F. f.QJS
qJGSF C0'@ G =Cb# A.	 . a" .	 "
 /
 " !/ SJJV
JKY
7KGGFG C CG(@DGG   Gb#TG5@G 4Gȋb#3_ӭG b#G4GC@  D4G8D    .  "r0HQ 0J2F  >
 ` øb . s"T J  >tGb#_G  4Gbt^G  ]( ] G0 }8 @ H ݤP ` #kGp#4G0 ^8 ~@ H P ޴X ` h >p ^x ~ GG( ^$JGG  ~%!J  &J{  ^
^ӐTGb#   8 D  r_D	G  G$vH;b#%vH C CTGio@  =GCb#
G+'I CGGtG&@DG]  8 D	G   &&b# C CGs"G8C@ D"  G`b# Ch)! CtGGGy_	Gv GCb# CGGtG\&@D G`b#	GH  C CtGGGy_` G  b# C CGtGp%@DB G`b#	G0J! C CtGGGy_J G&vH }! =b# C CGG@
D	G< @G C `b# CtGGGy_2 G  b# C CGtGB%@DB G`b#	G0J! C CtGGGqy_ G }!  Cb#GtG'@ DG  &vH TGb# Cq@	 G&vH = Cb# CGG@	G  
?ETG¤8 E#   @ &, f  pcIA #H %"0D &<
   E. C e. QJS
qJ "SF  @ / 5/KY
7KG   B z/ Z#[ zK  z?tGb#_G  4Gb
_Eo^GSE( ]0 ] ?E8 }@ H P ݤX ` h =p ]x }  #k#4G  ^( ~0 8 @ ޴H P X G ^GG$J  ~G  %!J{G ^^ӰTGb#   8 D  k_DG*  G$vH%vH;b# C CTGbn@ CGGb# C%HGGtGy%@  GG TGb#@DGG   4Gb#L@  G`&b# CG4GtGB@  DtG8 E*  !  E. %"
  sJR QJ CSF E>vH  .0 @G(IU JIF  > =hI t/ЀB  T/%'K`GHeHHGpG t?EG  T?  w " Q. 1"R QJ  Q>tGb#_G4G  b^G ] G  ]( }0 8 @ ݤH P X ` #k#4G ^  ~( 0 G ^GGG  ~   ({ ^~^ c.
 C" .G   ,rJGTJ0b#0v JtF } HBJ Cy$@G  4G8b^G ] ] G  }( 0 @ #kG#4G ^  ~( 0 G0 ^GGG  ~   H{ ^L^ C. " c.
 " .G /PJ SpJ  ,JXKG5vJ b#SFF C  HbJJG%@G  4GXbn^G ] ] G  }( 0 @ #kG#0JH ^4GP ~X ` h GP@ ^GG#!J  ~8   h{( ^0 ~4 ^ a`H8  _&0 }G H1v J  D D @ ( :GKG" =/ "!J /VKzVK6Ha6H;GGGC0Db#1G" =?G ?GG& .#  # .`Ja`JUJTJCF& >GF# >GtGd@D = 8 GD!H4 }pb#0v J2GJ CG#@G4G  xb	^G@ ] GH ]P }X ` h p #kG#4G8 ^@ ~H P X ޴` h GG0 ^%JGG  ~G  &!J{ C( ^ aH0vH ?& HG  D D @ 6JG" . }"8gH .JvJKxKFFF" >F >G# =,C& =.# }#`HA;HGHGQ;JpDb# D2F C& =># =<GGtG@DG G) GCub#G4G&A
   G!vH( }DHb# C2GJGl#@ G =,   =.%vH D HGQ J( H`b#1D3gJ CJ CGG$@GG  4Gb^G0 ] D8 ]@ }H P X ݤ` h p #k#4G( ^0 ~8 @ H ޴P X ` >h ^p Gۤ  ^GG#J  ~$!J  %aJ{ ^^ӀTGb#   8 D  _DG    b4GQ^ Gd GG#v`H$vH<b# C CTGtl@ =CGGb#G)'H CGtG#@ D   8 D  G%vH'b# C C CGGD@@ G
G
 G%vH'b# C C CGG@@
G  _EGCb C8Db#& G GtG"@D
G  #,G  #!p	IA )H %"0D #< E.a@ e.QJS
qJSF  
  . "U J > ¦ . "W J  >tGb#_G  4Gb^ _EG  ]( ]0 }8 @ H ݤP X ` =h ]p  #kG#4G( ^0 ~8 @ H ޴P X GG  ^GG#v`H  ~  { > ^^  CGTG<b# v H Ck@ӠG =CGG  tG&'Hb#8 F   CG)"@DGB  TGb#_D G  4Gb^ G< G CP'b#GGtGk@@  G"D8D) G  . a"
 "uSJT J CF >xpH  .0 BG%HW JHF  > ]eH ,  v/0GK DJpJeG DpG <  v? B r. R"S rJ  r>tGb#_G4G  be^ DG  ]( ]0 }8 @ H ݤP X ` #kGp#4G8 ^@ ~H P X ޴` h p >x ^ ~ G@G0 ^$JGG  ~%!J  &JX{  ^( ~^ TGHb#   8 D
  a_	D  G  4Ghb.^ G G$vH%vH0=b# C CTGRk@  =CGG b#	G*'H CGtG!@DG   C( ]GG! .$ .! p"b#2GJJU
J CF CGG"@GE7  8 D  X D  Z G &P(b# C CGs"G	?@  GN GC b# CGGtGb!@( }  G & = CP
b#2gI Cs"G@  G7 GG&vH =Gb# CGGM@GDԒD) G =GGTG0b# I-  ),  EIA
%HAE C@   &vHGTG8b# C , d!  $-HI
+ID Cv@
 GG&vH =Gb# CGG!@G  EGCPb#G8 EA  8  hGtG E-  , %!
  IIF
H	GFE C#@DG"  h, H! ݠa*I CC jH "aD h< &. F. 0J =R
PJ "2F  Ӱ .@ / y#JX
KF   ,`B ,HE
H D  
  h, ( C aH h< h" I- )!J II  I=tGHb#_G  4GhbT^ EG0 ]8 ]@ }H P X ݤ` h p =x ] }  #kp#4G8 ^@ ~H P X ޴` h p >x ^ Gۤ0 ^GG$J  ~G  %!J{  ^( ~^PTGb#   8 D
  O_D  G  4Gb^ G G$vH%vH=b# C CTG@j@  C( =GGG%H@b#)'H C CGGG"@ DC  G Ghb#TG@D
G;  G4G Hb#%@5  GC b# CGGtG @,  GC =Gb# CGGGq!@   =tGGb#! 	.! ) " ). "JQ!J ?$F! F	   . . C =JV
JF C/@G C (b#G4GtG>@ 
G  
_E" 4G8D*  )   @ 	.
  qHP J CF 	>  e.tI0@GS dJ:GKtF  e>( RK 2/zRK  /@B'J;GHgHG$GG 2?  ?  u ø  ,   A  H   <tGb#_G  4Gb^ GG0 ]8 ]@ }H P X ݤ` h p =x ]  #kG#4G0 ^8 ~@ H P ޴X ` h >p G ۤG( ^#JG$!J  ~%J  { ^  ~^TGb#   8 D  _DG    (b4GQ^ G GG#v`H$vH=b# C CTGti@ =CGGb#G)'H CGtG@D'  8 Df  G &)b# C CGs"GD=@ D   GY G  b# C CGtG@  %vHG =! = Cb#2I C CG@DEB G  C  =tGG! $.$ D.! $ )'I
b#!JR
AJ2F CG4
@#   G%vH
b#TG! (,!  $ . C$HP
J0D C@D   GCG`b#! (,!  $ .GG%HP
JG0D C Cr @ GG%vHC =b# C CGGG@DԒD  G(D8D#  "  (. }r0H
 (!Q 0J c"2F (> C . . JU
J 7#F  v W/ A w/YK[
yK[G   ( ,  @ H  <tGb#_G4G  (b^ GG( ]0 ]8 }@ H P ݤX ` h =p  #kG#4G8 ^@ ~H P X ޴` h G`{G0 ^G  ~   x{ >  ^( ~>^ TG =G$v HP>b#!v H C Ch@  =GG Cb#C1'HtGy@ Dk  ( =G C =Cb#2'HGG@DG_    hb#  8 F  TG_DGU   tGG = p. P" . C`b#rJT
JtF C^.@  GD"G8D@  a"3  .
 "uSJT J CF >  .xHG$HW J0 BF  >  }H ,dH  ,B!gKD6Ha6H DD D <  <G( 1'J ,tG  .9J8Jq9JKxKDFD <F  >hb#6_ G"tGhb# , ! D H  <,_ GGG  4Gb^G0 ] D8 ]@ }H P X ݤ` h p #k#C  ^0v J( G  ~"J ^2GJ ^?FG{#e @D   1v@HG                                                                                                                                                                                                                                                                           fT $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
                        R "            F"v@HQD_D GG ] D  ]( 0 #k#C  ^0v J( G  ~"J ^2GJ ^?FG{#W @D   1v@HG F"v@HQD_D GG ] D  ]( 0 #k#F  ^B( ~ G0 ?F8 GG  ~G C ^C#J0v J CGGGG`{# @GCPb#GG4G@  ] v`HG CD"v@H @DDGG ] G  ]( }0 8 @ #kG#0v J  ~?F ^2GJ G ^{# @G ]X D ?D  #kp#TGX ^` ~h p x ޴ G8 ^#JP ^GG2v`H@ ~C  ~$!JXb#D  CH ^GS_DGe  0 4GD ]P F  j @  r.t2JSrJtF  r>Y  ¤4GGdHb#v`H  ^   $@ =G6J%H% ]"DD `@  J8 }vJG* .8gJ% .KxKFFF* >F% >G. ,C+ ,+ }#CG;HDHGGc;HEHGb#D. < CD+ <GtGN|@D   ` GDX F$F G ,   =,G }HA$HGaHD DH b#D2GJbJ@  GG(b4G^GP ] DX ]` }h p x ݤ  #k r.
2JS
rJtF r>à#4J ^TG  ^( ~0 8 @ ޴H P X GG&v J  ~G CG'!Jb#GG CG_DGM   4GP F  U   e.t%JSeJtF  e>B GGDb# C4G_ 8 D  4GJ   .qHPJF  >1 `4GGxb  T^   D"
 "Gb# C   d. .G . .rJ  $,TJJWJtFF $HBJbJGf@DG  ݤG@  GD b#@G@GG4G  bi^G ] E  ]( }0 8 @ ݤH P X ` #k e.
%JS
eJtF e> .
HP
JF >#C  ^0v J( G  ~"J ~3gJ ^?F_FG{# @   =0v@HG "D!v H0D?D GG ]  ]( 0 #kG#TG8 ^@ ~H P X ޴` h p G  ~?F( 0 ^GG  [G&J%AJ fC( { CG[Zk
  G&vH( ] C b# CtG_GQ 4GGeHb C  ^  vH ?$G'H4JD D @ G" }. ="6gH ].JtJJvJuFTFwFVF" }> ]># =#G# ]/H& }/gHZYK[yKGGeG& }?# ]?CGCHb#GGGtG{@D G ` },   ,HG&vHdH( @Hb#D`D2GJbJ CGY@GG4G  b^G0 ] D8 ]@ }H P X ݤ` h p  #k#4G0 ^8 ~@ H P ޴X ` h >p GG( ^GGG  ~G  &aJ({#v`H >  ^Q^ G C Ab#TG D Ce@  =G Cb#C1'HtG@DG  Gq G4G DXb#	G[)_i  =@'  F@ "&H07J&@H	&AG  C Gb#TG)_   = CGTGb# A. a. !"QJS
qJSF C_G0 A  U @Hb#D4Gk)_GE>  G0@G8  C Gb#TG})_*   =TGGb# ), 	! 	.I@(HP
J0D C Cx_ U @   G A_  	 @ ݢ CG4G%b#0@ 6. " /7JXK8F4@G 4GHb#4)_ D@@  0@  %-I %I  %=GDG  4G8b^G( ] E0 ]8 }@ H P ݤX ` h =p  #k#4G0 ^8 ~@ H P ޴X ` h >p ^x G( ^GG&J  ~G '!J )J  { ~  ^^G C{b#G4GA  G!vHDAb# C CTGd@  CG Cb#G1HtG@ D  G GG!vHDAb#
 C C CTGd@ =  CGGpb#3'H2H CGGO@ D  G GG4G b#(_
DG @G   %.r%HQ%J2F  %>%J  B bGGtG
@LeZk	?E C'  I)A  )$I%H%%AH	G	%AG   8b#CTG(_   =G0vHb#TG A. !" a.QJS
qJSF C_G0 A U @ b#D4G(_GDJ    #.Q #J  #>GGC G8b#TG(_9    ,!vHGTGb# H@1   '. G. "0JR
PJ C2F C_ U @    ,  H@G@_     . 7/ w/ J #8K[xKBVA;G5   V/a6KZVKAG  V?  #. #JQ #J4@BrCJ2F  #>4GG b#:(_ӿ  ,G H`DGG4G  b^G( ] D0 ]8 }@ H P ݤX ` h =p ]x  #k %.
%HQ
%J2F %>b e.SeJrFe V/
6KZ
VKAG V?ð#4G0 ^8 ~@ H G  {( ^GG  ~   8 { > ^ ~  ^ G =  =0v JG?F  2Hb#3'H C Ci@G  GH b4G^G( ] D0 ]8 }@ H P #kp B#  0. C >#   0J# CF?F BF  !  p/0 C?D  . pK BuaKT J71 BF  >0 @  .G?D  !. JsJQ !J3F  !>0 @  7.G?D  / 7Jr!JX KG  ?  #k#C  ^GGTG( ^0 ~8 G  ~GG  b#5@ DGL   b#4G_'_ DF  GGC TGb#'_9   =GCpb#TG . !"	 a" JG  	 . .JU
JF C@  =Cb# A.	 . a" .	 "
 /
 " !/ SJJV
JKY
7KGGFG C CG @ DG    # TGb#@G4G b#U'_G4G  b#6@G  ] G( ]0 }8 @ #kG#  B ^TG ~  ( 0 ޴8 G G ^G  ~ C  `  b#<@Dp  Gb#G CTGa@D   d. . D"
 .
 $"p¤rJTJG Jpb#tF"J CtGs@ D5  Gzb#4GTGTG9AG     Gu  B C(bTGtGcZk  4GG b#0@$_   Gf G  4GG b#@$_   G\ G0TGG  &  ؅b#  . D.JR
DJF C$_   GK    E" e.tG . .  $. $ rJJGQ
!J
b#T
JFtF C C C@ D    & . e"GTG !. "  A.TJb#0JR
PJ2F %. C3J4Fa
@!  E. %  . e" .G .AJPJGJ  &U
Jb#PFF C C@D    .   $,eHqeHPJA%HF1D > $<G ] D ] }  ( 0 ݤ8 @ #k 0 B#  "  ~ ^tG ^  ~( 0 8 ޴@   @.G `.  @  0,GQJGSqJ   0Hb#SFBJG%GJCGG@  G Gb#TGA
@DG
 G4G b#o
@  GGPb#G4GtG7@G ] D ]  }( 0 8 ݤ@ P #k#  TG ^ ~  ( GP{G ^G  ~ C`b#;@D c.Y   .
 . C"rJTJG
 #"b# JtF"J CtG@DG6  {b#4GTGTG8AG     G= GpB CxbTGtGbZk  4GGpb#0@#_   G- G  $4GGpb##@#_   G# G"TGG  $  !(b#  A. a.AJS
aJSF C#_   G  G% #,& .% C   "HPJ% D q@D0D  Qp@Ds4HRTJSF  QWB
 `G ] ] D }  ( 0 #kG Q0 H_FSF Q# 0 B  ~    ^tG G   . @.  p.!JRAJG{# pJ 2FHG1Hk6@G ] D   #kG#  B ^TG ~  ( 0 ޴8 @ G ^G  `  @G C  ~    b#-;@D  h¤GG`b#TG C
@DG `bb#GTG C@D   e. . E"
 .
 %"rJTJG Jb#tF"J CtG@ D5  G`{b#4GTGTGC8AG     G B CbTGtGaZk  4GGb#0@"_   G G  4GGb#@"_   G GTGG  '  xb#  . E.JR
EJF C#_   G|    F" f.G
 .! .$ %.! % rJJGQ
!Jb#TJFtF CBJ CGG@ D+  G`{b#4GGTG7AG     GX B CbGtGaZk  Š4GGb#@"_   GI G  TGG  %! ',!  $ .xb#&HP
J0D C"_   G8   Š #" C.tG c. &,  .  `¤QJ'HGP
J`b#S
qJ0DSF C C C@D!  C. . #  . c" .AJPJGJ  %U
J	b#PFF C CG0
@D  Ơ  &, f,  HA%HpHCeH1D &<pD f<G ] ] D }  ( 0 ݤ8 @ P #k#  B ^TG ~  ( 0 ޴8 G  G ^G  ~ C  `  0b#6:@D¤G  GGb# CTG	@D D.G ` d. $"
 $,QJb
 "SqJGb# 0HSF"J CtG@ D5  G{b#4GTGTGS7AG  G   @ B CH bTGtG`Zk  4GG@b#0@"_  Gr G  4GGG@b#@!_  h GP TGGG  #  b#  . D.JR
DJF C("_  W    F" f.G
 .! .$ $.! $ rJJGQ
!J0b#TJFtF CBJ CGG@DG,  G4G{b#GTG7AG    G2 G@ B CH bGtG`Zk  4GG@b#@!_  G" G  cTGG  $! .! # $ C.b#JR
AJF C!_  G ! f,! F " &,  bHA"HaD! $ q Dp D  0rsHQ3J2FW`B  0 @G ] D ] }  ( 0 ݤ8 @ #k 00`H?F2F 0# 0 B  ~ @ ^  "  ^ "( ~tG0 G  @.G `.  . .QJSqJ  .JGVJ
b# SFHF"H1H C JGG@ DG  CG =Pb#2gHGGG,@DG ` = =Gb#tG a. A" .rJT
JtF C%@  GG ]  ] D( }0 @ #k# 0 B  ~   0 ^C8 ^C@ ~GH GP X    .G @.  @  p.G!JGRAJ`b# pJ2F"H >G  GGGG@DGT   =C                                                                                                                                                                                                                                                                           =R $      PWRKV50F1050.G                 a}% > [NW.KIT.AEXE]PWVN$NETWARE.EXE;1                                                                                                     
  