                            5^ $      DCEAXPMUPA013.A                                                                                                                                                                                              G p               DCEAXPMUPA013.A  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY DECW$KITD:[*...]*.*; _$2$DIA24:[DCE.ALPHA_V13_BL4_MUPA_MAY05.][SYSUPD]DCEAXPMUPA013.A/LABEL=(DCEAXPMUPA)/SAVE/BLOCK=9000/GROUP=25  VAX/VMS SPKITBLD Procedure  GBDBUILD       @   Z       V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  $                       * [SYSHLP]EXAMPLES.DIR;1 +  , 5   .     /  @   4                            - a,    0   1    2   3     K  P   W   O     5   6 (   7 I   8          9          G  @  H  J  I                     DCE.DIR  7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         * [SYSHLP.EXAMPLES]DCE.DIR;1 +  , 7   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6    7    8          9          G  @  H   J  I                 DTSS.DIR >     GDE_DCE_APPS.DIR 5     	POSIX.DIR  .
=     RPC.DIR  5     SX.DIR <                                                                                                                                                                                                                                                                                                                                                                                                                         * [SYSHLP.EXAMPLES.DCE]DTSS.DIR;1 +  , >   .     /  @   4                            - 7    0   1    2   3     K  P   W   O     5   6 zA   7 Ⱥ   8          9          G  @  H   J  I                            DCE$DTS_PROVIDER.C 3   &  DCE$DTS_PROVIDER_BUILD.COM d	8   (  DCE$DTS_PROVIDER_GC1000.EXE  9   &  DCE$DTS_PROVIDER_HOPF.EXE  4   &  DCE$DTS_PROVIDER_NULL.EXE  >   &  DCE$DTS_PROVIDER_PSTI.EXE  ;   &  DCE$DTS_PROVIDER_SPEC.EXE  9   &  DCE$DTS_PROVIDER_START.COM 	9   &  DCE$DTS_PROVIDER_TRAC.EXE  8                                                                                                                                                                             . * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2 +  , 3   .     /  @   4 S       
                    - >    0   1    2   3      K  P   W   O     5   6 %86Պ  7 *   8          9          G  @  H   J                  /* ** @OSF_COPYRIGHT@ */ /*#  *	Module dts_spectracom_provider.c   *	Version V1.0   */  /*  * Copyright (c) 1990, 1991 by0  * Digital Equipment Corporation, Maynard, Mass.  *H  * This software is furnished under a license and may be used and copiedH  * only  in  accordance  with  the  terms  of such  license and with theH  * inclusion of the above copyright notice.  This software or any  otherH  * copies thereof may not be provided or otherwise made available to anyH  * other person.  No title to and ownership of the  software  is  hereby  * transferred.   *H  * The information in this software  is subject to change without noticeH  * and  should  not be  construed  as  a commitment by Digital Equipment  * Corporation.   *H  * Digital assumes no responsibility for the use or  reliability  of its:  * software on equipment which is not supplied by Digital.  *>  * FACILITY:	Distributed Time Synchronization Service (DECdts)  *C  * ABSTRACT:    Implements a DECdts Time Provider which obtains the 5  *		time from a Spectracom radio clock connected to a   *		terminal line.  *5  * ENVIRONMENT:	OSF Distributed Computing Environment   *:  * AUTHORS:     Digital Distributed Time Service (DECdts).-  *		Distributed Processing Engineering (DPE).   *                  * DATE:	June 20, 1990  *  */    /*/  *                           DESCRIPTION OF THE   *			   SPECTRACOM RADIO CLOCK  *  E  *	The SPECTRACOM-8170 and NetClock-2 are WWVB receivers suitable for E  *	connection to a serial port. These function within the majority of +  *	North America. They are manufactured by:   *  *		SPECTRACOM CORPORATION  *		101 Despatch Drive#  *		East Rochester, New York, 14445   *		(716) 381-4827  *E  *	Contact SPECTRACOM about availability of products suitable for use 
  *	in Europe.   *M  * --------------------------------------------------------------------------   */   M /* -------------------------------------------------------------------------- +  *	Compiling and Running the time provider.   *@  *    Two steps are required to build the time provider program:  *A  *    1. Generate the interface file dtsprovider.h and the server @  *       stub code dtsprovider_sstub.c by compiling the IDL file@  *       /usr/include/dce/dtsprovider.idl with the IDL compiler.>  *       Note that only the server stub needs to be generated.
  *            C  *       % idl -client none -no_mepv -keep c_source dtsprovider.idl   *F  *    2. Compile the C source code and link with the libdce.so library  *G  *       % cc -I. -std1 dts_spectracom_provider.c dtsprovider_sstub.c \ 7  *         -ldce -lpthreads -lc_r -lmach -o dtsprovider   *  *A  *    To run the program interactively, simply type 'dtsprovider'   *  *	% dtsprovider  *D  *	The provider will then ask you to enter the following parameters:  *E  *	1. The name of the device to which the radio clock is connected,     *	   '/dev/tty02' for example. =  *	2. The poll period, which is the number of seconds between @  *	   queries.  Entering 60 for example would cause the provider#  *	   to be queried once a minute.  B  *	3. The Base inaccuracy, which is the number of milliseconds of >  *	   systematic inaccuracy in the timestamps delivered by theE  *	   radio clock. The default value is 100 ms. If the times returned A  *	   by the provider are systematically incorrect, then the base *  *	   inaccuracy may need to be increased.<  *	4. The number of timestamps read at each synchronization.=  *         The range is 1 to 6 readings and the default is 4. <  *	5. The 'disallow clock set' flag which causes the serviceA  *         to enable or disable clock adjustments which DTS would A  *         otherwise cause. This is useful during TP development. >  *         Setting 'disallow clock set' to TRUE disables clock  *         adjustments. C  *      6. The 'output trace' flag enables and disables the logging A  *         of TP tracing information to standard output.  Setting A  *         the output trace flag to true causes information to be   *         logged.  *C  *	The provider can also be run in the background using the command   *	line interface:  *'  *		% dtsprovider -d /dev/tty02 -p 60 &   *>  *	To view the valid command line arguments start the provider=  *	interactively and then exit. The arguments will displayed.   */    /* Include Files: */  ? #pragma  nostandard		/* A VMS only Module                    */  #include <iodef.h> #include <ssdef.h> #include <descrip.h> #include <lnmdef.h>  #include <ctype.h>   #include <socket.h>  /* #include fd.h */    #include <pthread.h> #include <stdio.h> #include <string.h>  #include <fcntl.h> /* #include <sgtty.h> */ #include <time.h> 0 #include <dce/utc.h>		/* utc library routines */E #include <dce/dtsprovider.h>	/* This file is generated by the NIDL */ # 				/* compiler from dtsprovider */ 3 #include <dce/dce_error.h>	/* DCE error messages */ 6 #include <dce/dce_cf.h>		/* DCE config declarations */ /*  	  *	MACROS   */  /*
  *  Constants   */ 
 #ifdef VMS  . typedef struct IOsb {				/* IO status Block */     unsigned short status;     unsigned short byteCount;      unsigned long  devStatus;      } IOsb;    /*D  * This structure contains the current service synch serial number. C  * The message is sent to the Time Provider to wake it into sending &  * a time response message (TPrspMsg).  */  typedef struct TPreqMsg  {      unsigned short version_major;     unsigned short version_minor;B    unsigned long TPsyncID; 		/* service synch. Serial Number    */ } TPreqMsg;    /*5  * Time Provider message to the se                                                                                                                                                                                                                                                                                                                          =S $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              aS "            rver contains a set )  * of time stamps or a time out response.   */  typedef struct TPrspMsg  { !     unsigned short version_major; !     unsigned short version_minor; ?     unsigned short status;        	/* TPI message status 		  */ H     unsigned short TPmsgType;      	/* type of message (control,data) */L     unsigned long TPsyncID;             /* message/synchronization ID     */
     union      { 5 	TPctlMsg     TPctlMsg;    	/* Message contents		  */  	TPtimeMsg    TimeMsg;
     } TPdata;  }  TPrspMsg;    
 #endif VMS   /*  * Threadsafe macros  */  #if _DECTHREADS_  - #define BEGIN_NONREENTRANT cma_lock_global(); - #define END_NONREENTRANT cma_unlock_global();    #else    #define BEGIN_NONREENTRANT #define END_NONREENTRANT   #endif /* _DECTHREADS_ */  /**  * Tracing Macro, Execute the code only if  * the TRACING flag is set.   */ M #define TraceIf(Code)	if (TRACING) {BEGIN_NONREENTRANT Code END_NONREENTRANT}  /*  * Get the next argument#  * from the command line interface.   */ L #define GETNEXTARG(argcount) if (++i >= argcount) { PrintHelp (); exit(1); } /*  * FD macros  */  #ifndef FD_SET #define	NFDBITS		32  #define	FD_SETSIZE	32 K #define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS))) L #define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))L #define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))7 #define FD_ZERO(p)	memset((char *)(p), 0, sizeof(*(p)))  #endif /*)  * Spectracom character conversion macros   */ + #define CVT_ASCII_TO_INT(chr) ((chr) - '0') 0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))      /*  *	Conversion factors   */   ! #define K_NS_PER_SEC	(1000000000)  #define K_MS_PER_SEC	(1000) 1 #define K_NS_PER_MS	(K_NS_PER_SEC / K_MS_PER_SEC)  #define K_100NS_PER_MS  (10000)    /*  *	Literals   */    #define SPECTRACOM_PROMPT		"T"  B #define MAX_RESPONSE_LENGTH	(100)	/* Length of maximum response	*/C #define MIN_RESPONSE_LENGTH	(26)	/* Length of minimum valid resp.*/   ? #define K_SPECTRACOM_TIMEOUT	(5)	/* Allow 5 seconds for radio	*  					 * clock to respond		*/2 #define K_SPECTRACOM_RETRY	(2)	/* Retry twice			*/  C #define SPECTRACOM_BAUD		(B9600)	/* Baud rate of Spectracom term.*/    /*%  *  Maximum/Minimum parameters for TP   */ B #define K_MIN_INACCURACY     (10)	/* Allow for at least 10 ms of	* 					 * systematic inaccuracy	* ' 					 * in each radio clock response.*/ 0 #define K_MAX_INACCURACY     (10 * K_MS_PER_SEC)% 					/* Allow for at most 10 sec of	* # 					 * inacc in each radio clock	*  					 * response			*/ C #define K_MIN_POLLRATE	     (30)	/* Minimum time between synchs.	*/ I #define K_MAX_POLLRATE       (60 * 60)	/* Maximum time between synchs.	*/   C #define K_MAX_DEV_NAME	     (255)	/* largest device name string.	*/    /*   *	Default Control/Config Values  */ D #define K_DEF_INACCURACY     (30)          /* 30 ms inacc. in each	*" 					    * radio clock response	*/E #define K_DEF_TMORATE	     (1 * 60)	   /* Let service wait 1 minute	*  					    * for provider to		*  					    * succeed.			*/G #define K_DEF_POLLRATE       (2 * 60)	   /* Query the radio clock     * & 					    * every 2 minutes to get    * 					    * the time			*/= #define K_DEF_TIMESTAMPS     (4)	   /* Read the radio clock	* ! 					    * 4 times each synch.	*/ ; #define K_DEF_NOCLOCKSET     (0)	   /* Allow the clock to	*  					    * be set.			*/ = #define K_DEF_TRACING	     (0)	   /* Time Provider tracing	*/    /*  *     RPC definitions  */   K #define ABORT                (1)    /* abort the TP if error in RPC call */ E #define CONTINUE             (0)    /* continue after an RPC error */ L #define K_MAX_NUM_THREADS    (1)    /* Maximum number of threads we allow */   /*4  * This macro checks if an error occurred in an RPC <  * call. Print the message if this is the case. Exit the TPP3  * process if requested by the caller of the macro.   */   9 #define ProcessRPCerror(st, message, code)              \ 9    {                                                    \ 2 	if ((st) != rpc_s_ok)                           \2 	{                                               \ 	   int _locstat;				\+ 	   char _rpcmsg[dce_c_error_string_len];	\  							\2 	   dce_error_inq_text((st),                     \9                               (unsigned char *)_rpcmsg, \ 9                               &_locstat);               \  	   BEGIN_NONREENTRANT				\ = 	   (void)fprintf(stderr, "%s - %s\n", (message), _rpcmsg); \              END_NONREENTRANT				\9            if ((code) == ABORT)                         \m2 	       exit(1);                                 \2 	}                                               \    }   , /*  *	Forward Definitions  */u  
 int Delay ();i void PrintError ();  void PrintISO ();  void PrintTimes ();  void PrintHelp (); void InterActiveInput ();i void CommandLineInput ();i int ReadTimes ();o int QueryProvider(); int ParseTime ();a void InitializeTPdefaults( );    /*  * RPC global definitionsr  *  6  * Entry point vector for routines called from the DTS/  * deamon (RPC client) to the TPP (RPC server).s  */r  6 globaldef time_provider_v1_0_epv_t time_provider_epv = {e     ContactProvider,     ServerRequestProviderTime* };   /* n  * Global Variabless  */n
 #ifdef VMSI $DESCRIPTOR(TSTPLOG,  "DCE$DTS_TSTP_MBX");	/* tpts mailbox             */ I $DESCRIPTOR(TPTSLOG,  "DCE$DTS_TPTS_MBX");	/* tstp mailbox             */ J $DESCRIPTOR(TPDEVICE, "DCE$DTS_TP_DEVICE");	/* Device name parameter    */N $DESCRIPTOR(TPINACC,  "DCE$DTS_TP_INACCURACY");	/* Inaccuracy parameter     */M $DESCRIPTOR(TPRATE,   "DCE$DTS_TP_POLL_RATE");	/* Poll rate parameter      */AO $DESCRIPTOR(TPSTAMPS, "DCE$DTS_TP_TIME_STAMPS");	/* Time stamps parameter    */gP $DESCRIPTOR(MAXERROR, "DCE$DTS_TP_MAXERROR");     /* Max error allowed on TP  */P $DESCRIPTOR(FIRSTSYNC,"DCE$DTS_TP_FIRSTSYNC");    /* Always synch first time  */P $DESCRIPTOR(VERBOSE,  "DCE$DTS_TP_VERBOSE");      /* Print info out.          */  M $DESCRIPTOR(PROCESS_NAME, "DCE$DTS_PROVIDER");	/* Process name when OK     */iM /* $DESCRIPTOR(LNM_TABLE,"LNM$SYSTEM_TABLE") ;	/* Table to search          */hK $DESCRIPTOR(LNM_TABLE,"LNM$PROCESS_TABLE") ;	/* Table to search          */a  N unsigned long  FIRSTSYNCH;                      /* always synch first time  */N unsigned long  MAXTPERROR;                      /* Max error on TP.         */N unsigned long  ISVERBOSE;                       /* Print info.              */N unsigned long  SYNCHCOUNT;                      /* current synch. number    */  4 static int	ttchan;				/* channel number of term   */  E char devicename[K_MAX_DEV_NAME+1]= "\0";	     /* name of TP device	*/s   #endifK unsigned long  RETRIES;                       /* time stamps at each sync*/o  J unsigned long  TIMESTAMP = K_DEF_TIMESTAMPS; /* time stamps at each sync*/  L unsigned long  TMORATE   = K_DEF_TMORATE;    /* provider response timeout */  J unsigned long  POLLRATE  = K_DEF_POLLRATE;   /* seconds between TP syncs*/  J unsigned long  NOCLOCKSET= K_DEF_NOCLOCKSET; /* clock set               */  J unsigned long  TRACING   = K_DEF_TRACING;    /* output tracing          */  F unsigned long  INACCURACY= K_DEF_INACCURACY; /* provider inaccuracy	*/  3 unsigned long  INACC;			 /* inacc in nanoseconds	*/e    < struct tm INACC_TM;			 /* inaccuracy of each time reading */  4 int providerFD;				 /* provider file descriptor   */       /* */ vms_setup()e {      char value[255];     unsigned long status;oA     unsigned long attr = LNM$M_CASE_BLIND;	/* attributes mask */ h     short size;      struct { 	    short bufln ; 	    short itmcd ; 	    long *bufad ; 	    long *rtnln ; 	    long term;m:         } itmlst = { 255, LNM$_STRING, &value, &size, 0 };         /*,      * Set the process name to dtss$provider      */ 2     if (!(status = SYS$SETPRN( &PROCESS_NAME ))&1) 	exit(status);  A     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPRATE, 0, &itmlst );s     if ((status & 1))z     {  	value[size] = '\0';	 !         POLLRATE = atoi( value );4     } ;      C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPSTAMPS, 0, &itmlst );e     if ((status & 1))t     {h 	value[size] = '\0';	 "         TIMESTAMP = atoi( value );C 	if (TIMESTAMP > K_MAX_TIMESTAMPS || TIMESTAMP < K_MIN_TIMESTAMPS )U 	{D 	    fprintf(stderr,"The time stamp value is out of legal range\n");0 	    fprintf(stderr,"Legal Range is %d to %d\n",) 		    K_MIN_TIMESTAMPS,K_MAX_TIMESTAMPS);u
 	    exit(1);* 	}     }      B     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPINACC, 0, &itmlst );     if ((status                                                                                                                                                                                                                                                                            k $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                               "            & 1))      {  	value[size] = '\0';	s$         INACCURACY = atoi( value ) ;     } ;   A     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPRATE, 0, &itmlst );l     if ((status & 1))      {r 	value[size] = '\0';	t!         POLLRATE = atoi( value );y     } ;      C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &MAXERROR, 0, &itmlst );      if ((status & 1))c     {o 	value[size] = '\0';	.#         MAXTPERROR = atoi( value );n     } ;      B     status = SYS$TRNLNM(&attr, &LNM_TABLE, &VERBOSE, 0, &itmlst );     if ((status & 1))e     {. 	value[size] = '\0';	 "         ISVERBOSE = atoi( value );         TRACING =  ISVERBOSE;      } ;<     D     status = SYS$TRNLNM(&attr, &LNM_TABLE, &FIRSTSYNC, 0, &itmlst );     if ((status & 1))h     {* 	value[size] = '\0';	m#         FIRSTSYNCH = atoi( value );r     } ;           value[0] = '\0';C     status = SYS$TRNLNM(&attr, &LNM_TABLE, &TPDEVICE, 0, &itmlst );      if ((status & 1))      {  	value[size] = '\0';	t     strcpy (devicename,value);     } ;       }s   s /*  *++
  *  main()  *  *  Functional Description:n  *  *	Main Loop for the TP.  *  *  Inputs:   *7  *	argc, argv - standard command line input parameters.T  *
  *  Outputs: t  *  *	None.  *    *  Value Returned:     *  *	None.  *  *--  */( main(argc, argv)	 int	argc;u
 char	*argv[];  {      #ifndef VMSe     struct sgttyb ttyb;  #endif  K     int             numThreads;         /* Max number of threads created *//K     uuid_t          TP_uuid;            /* UUID for this interface       */ J     unsigned32	    status;             /* status return values          */J     unsigned long	statusL;             /* status return values          */     int i, sts;tH     unsigned32    maxCalls;         /* Max # of concurrent calls this */H                                     /* server can receive.            */H     rpc_binding_vector_p_t bind_vector;  /* vector of binding handles */L                                          /* over which server can receive */L                                          /* remote procedure calls.       */*     unsigned_char_t *machinePrincipalName;         /* _#      *  read the startup parametersc      */_#     InitializeTPdefaults(&POLLRATE,_ 			 &TIMESTAMP,f 			 &INACCURACY,
 			 &TMORATE,  			 &NOCLOCKSET,
 			 &RETRIES,M 			 &FIRSTSYNCH, 			 &MAXTPERROR, 			 &ISVERBOSE);       /*+     ** get any logicals that might be there_     */     vms_setup();  +     if ((argc < 3) && !strlen(devicename) )o     {o 	PrintHelp ();         InterActiveInput();A     }o4     else if (argc > 1) CommandLineInput(argc, argv);       /*&      * Echo back the input parameters.      */ (     fprintf(stderr,"PARAMETERS SET:\n");2     fprintf(stderr,"TP_DEVICE:		%s\n",devicename);C     fprintf(stderr,"TP_INACCURACY:      %d seconds\n", INACCURACY);(A     fprintf(stderr,"TP_POLL_RATE:       %d seconds\n", POLLRATE);]E     fprintf(stderr,"TP_TIME_STAMPS:     %d timestamps\n", TIMESTAMP);iC     fprintf(stderr,"TP_MAXERROR:        %d seconds\n", MAXTPERROR); J     fprintf(stderr,"TP_FIRSTSYNC:       %s\n", FIRSTSYNCH?"TRUE":"FALSE");M     fprintf(stderr,"TP_VERBOSE:         %s\n\n\n", ISVERBOSE?"TRUE":"FALSE");h       /*1      * Convert the user specified inaccuracy intoS#      * a TM struct for use with APIP      */	>     INACC_TM.tm_year = INACC_TM.tm_mon = INACC_TM.tm_mday = 0;     INACC_TM.tm_hour = 0; 7     INACC_TM.tm_min = INACCURACY / (60 * K_MS_PER_SEC);"$     INACCURACY %= 60 * K_MS_PER_SEC;0     INACC_TM.tm_sec = INACCURACY / K_MS_PER_SEC;     INACCURACY %= K_MS_PER_SEC;i%     INACC = INACCURACY * K_NS_PER_MS;C       /*?      * Open the radio clock file descriptor for read and write./      */    #ifndef VMST #ifndef _AIX9     if ((providerFD = open(devicename, O_RDWR, 0)) < 0) {t- 	PrintError("dtsprovider: open radio clock");i	 	exit(1);e     }T        /*       * Set tty for exclusive use      */r     BEGIN_NONREENTRANT2     sts = ioctl(providerFD, TIOCEXCL, (char *) 0);     END_NONREENTRANT       if (sts < 0) {= 	PrintError("dtsprovider: setting radio clock to excl. use");	 	(void) close(providerFD);	 	exit(1);      }     #else	       /*A      * AIX does not support IOCTL with TIOCEXCL for a tty device.d:      * so we have to use the O_EXCL flag in the open call.      */*    B     if ((providerFD = open(devicename, O_EXCL | O_RDWR, 0)) < 0) {- 	PrintError("dtsprovider: open radio clock"); 	 	exit(1);_     }C    #endif     /*      * Set to cooked modeh      */   6     ttyb.sg_ispeed = ttyb.sg_ospeed = SPECTRACOM_BAUD;%     ttyb.sg_erase = ttyb.sg_kill = 0;	#     ttyb.sg_flags = EVENP|ODDP|RAW;	     BEGIN_NONREENTRANT7     sts = ioctl (providerFD, TIOCSETP, (char *) &ttyb);i     END_NONREENTRANT     if (sts < 0) {= 	PrintError("dtsprovider: setting terminal characteristics");S 	(void) close(providerFD);	 	exit(1);      }    #else  	/* * 	 * Initialize the time provider hardware. 	 */       if ( !(InitTP() & 1 ) )  	{1 	    PrintError("dtsprovider: init radio clock");T 		exit(status);i 	} #endif       /* CJ      * The rest of this code (in main) is relevant to RPC. Initialize the N      * server by registering the interface and the protocol sequence with the K      * RPC run-time library. Then, listen for calls coming from a client.  aD      * There is only one Time Provider RPC server per node and only .      * one client invokes it (the DTS daemon).      */t       /*@      * Create a null type UUID for registering the TPP interface      */s(     uuid_create_nil (&TP_uuid, &status);       /*?      * Register the TPP interface with the RPC run-time library=      */)8     rpc_server_register_if (time_provider_v1_0_s_ifspec, 			    &TP_uuid,* 			    (rpc_mgr_epv_t) &time_provider_epv, 			    &status);     /*;      * If not a successful interface registration, exit TPP       */      ProcessRPCerror (status,/ 		     "Unable to register interface for TPP",   		     ABORT);       /*G      * Tell the RPC run-time to listen for remote procedure calls usingsB      * all supported protocol sequences.  Since there is only one F      * client sending calls (The DTS time service), the maximum number.      * of concurrent calls should be only one.      */      maxCalls = 1; *     rpc_server_use_all_protseqs (maxCalls, 			         &status);      ProcessRPCerror (status, d5 		     "TPP unable to register protocol sequences ", ; 		     ABORT);       /* i=      * Get the vector of bindings over which this server can i&      * receive remote procedure calls.      */u  4     rpc_server_inq_bindings (&bind_vector, &status);>     ProcessRPCerror (status, "Can't inquire bindings", ABORT);       /*>      * If trace has been enabled, check the binding vector to ,      * confirm that the TPP server is there.      */        TraceIf(5 	    rpc_server_inq_bindings (&bind_vector, &status);d%             ProcessRPCerror (status, T) 			     "Can't inquire bindings", ABORT); * 	    for (i=0; i< bind_vector->count; i++) 	    {  		unsigned_char_p_t str_binding; 		; 		rpc_binding_to_string_binding (bind_vector->binding_h[i],  					       &str_binding,D 					       &status);I= 		ProcessRPCerror (status, "Can't bind to string", CONTINUE);O 		if (status == rpc_s_ok)a8 		   fprintf (stderr, "Got binding: %s\n", str_binding);* 		rpc_string_free (&str_binding, &status); 	    } 	    );        /*E      * Add address information for this Time Provider to the endpoint,F      * mapper database. The endpoint map is managed by the RPC daemon,C      * which creates and deletes elements on behalf of RPC servers.       */P  1     rpc_ep_register (time_provider_v1_0_s_ifspec,e 		     bind_vector,$ 		     NULL,5 		     (unsigned_char_p_t)"Spectracom Time Provider",  		     &status);K     ProcessRPCerror (status, "Can't register with endpoint mapper", ABORT);l       /*&      * Free up memory allocated by RPC      */ 4     rpc_binding_vector_free (&bind_vector, &status);       /*B      * Obtain the name of the machine's principal and register an G      * authentication service to use for authenticated remote procedure G      * calls coming from the time service daemon.  HostName is NULL, soaC      * this routine implicitely gets the host name and returns the         * machine's principal name.      */i  M     dce_cf_prin_name_from_host ((char *)NULL, (char **)&machinePrincipalName,n*                                 &statusL);F     ProcessRPCerror (statusL, "Can't get machine's host name", ABORT);  8     rpc_server_register_auth_info (machinePrincipalName, 				  rpc_c_authn_dce_private, 				  NULL,n 				  NULL,n 				  &status);E  E     ProcessRPCer                                                                                                                                                                                                                                                                           g $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              * "     .       ror (status, "Can't register authentication", ABORT);I         /*<      * At this point we listen for incoming calls from a DTS=      * daemon client program (running as a server) that wantsn=      * to synchronize with the Time Provider.  RPC dispatchesN2      * the requests to the appropriate procedures.      */d  #     numThreads = K_MAX_NUM_THREADS;   
     TraceIf (/9 	     fprintf(stderr, "Listening for connections ...\n");  	     );  ,     rpc_server_listen (numThreads, &status);H     ProcessRPCerror (status, "RPC listen terminated abnormally", ABORT);   }o /* End of main program*/     /*  *++  *  ValidateTime()  *  *  Functional Description:   *D  *  This routine confirms that the time returned from the system, isB  *  within MAXTPERROR seconds of the time returned by the external  *  device.e  *  *  Inputs:   *2  *      systemTime  - time returned by the system.;  *      externalTime- time returned by the external device.;  *  *  Implicit Inputs: (  *%  *	SYNCHCOUNT - current synch number.S:  *      FIRSTSYNCH - allow first synch to always validate.;  *      MAXTPERROR - greatest difference between two times.E  *
  *  Outputs:    *  *	None.  *  *  Implicit Outputs:  M  * P
  *      None.A-  *                                              *  Value Returned:  a  *        *    Returns TRUE iff9  *      (abs(externalTime - systemTime) <= MAXTPERROR) ||S'  *      (FIRSTSYNCH && SYNCHCOUNT == 1)   *  *  Side Effects:   *  *	None.  *  *--  */,) int ValidateTime(systemTime,externalTime)  struct utc *systemTime;s struct utc *externalTime;( {l utc_t              result; struct timespec    inaccsp;A struct reltimespec timesp;       /* s:      * find the difference between the system time and the+      * time reported by the external clock.t      */T7     if (utc_subtime(&result,systemTime,externalTime) ||f0 	utc_abstime(&result,&result)                 ||* 	utc_binreltime(&timesp,&inaccsp,&result))	 	exit(0);        /*7      * if the difference is less than the max error, or .      * if first synch is enabled, return true.      */ 2     return( ((SYNCHCOUNT == 1) && (FIRSTSYNCH)) ||% 	    (timesp.tv_sec <= MAXTPERROR) );= }      N      &G /**********************************************************************l  *1  *	DTS TP/TS REMOTE PROCEDURE CALL (RPC) ROUTINESr  *H  **********************************************************************/   /*  *++  *  ContactProvider()   *  *  Functional Description:e  *G  *     This procedure is invoked by a remote client to initiate contact*G  *     with the Time Provider Program.  The task of this routine is to r>  *     send an initial control response message to the client.  *     u  *    *  Inputs: @  *       bind_handle         - pointer to the rpc_binding_handle3  *                             passed by the client B  *       TimeServiceRequest  - pointer to a structure with control,  *                             information.   *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:E  *       TMOresponse   - pointer to time response message returned to H  *                       the client (the DTS server) which will identify3  *                       this TPP server as active.   *B  *       ComStatus     - This status is used by RPC to detect any E  *                       communication errors between the client and  E  *                       the server.  We return the value rpc_s_ok if ;  *                       the call was successfully invoked.   *  *  Implicit Outputs:e  *  *	None.  *  *  Value Returned:   *  *  *  Side Effects:e  *  *  *--  */   ; void ContactProvider( bind_handle, TMOresponse, ComStatus )_ handle_t        bind_handle; TPctlMsg       *TMOresponse; error_status_t *ComStatus; {        TraceIf(8 	    fprintf(stderr, "Executing ContactProvider ...\n"); 	    );	       /*B      * Prepare a time out response message to issue to the service7      * which will identify this process as active, and  D      * tell the service how long it must wait for the time response.      */n8     TMOresponse->status = (unsigned short)K_TPI_SUCCESS;%     TMOresponse->nextPoll = POLLRATE;*$     TMOresponse->timeout  = TMORATE;)     TMOresponse->noClockSet = NOCLOCKSET;"     *ComStatus = rpc_s_ok;   } /* End of ContactProvider */   ( /*  *++  *  ServerRequestProviderTime()I  *  *  Functional Description:"  *  *        *    *  Inputs:,:  *       bind_handle   - pointer to the rpc_binding_handle-  *                       passed by the clientP  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:F  *       TimeResponse   - This structure contains the time stamps and >  *                        version info returned to the client.  *C  *       ComStatus      - This status is used by RPC to detect any *F  *                        communication errors between the client and F  *                        the server.  We return the value rpc_s_ok if<  *                        the call was successfully invoked.  *        *  *  Implicit Outputs:t  *  *	None.  *  *  Value Returned:   *  *  *  Side Effects:i  *  *  *--  */UF void  ServerRequestProviderTime( bind_handle, timeResponse, ComStatus) handle_t       bind_handle;  TPtimeMsg      *timeResponse;A error_status_t *ComStatus; {d     int errStatus;       TraceIf(A 	   fprintf(stderr, "Executing ServerRequestProviderTime ...\n");  	    );        /*7      * Return the number of time stamps in the message.       */o  -     timeResponse->timeStampCount = TIMESTAMP;O          /*4      * Send the requests to the provider and get the      * results.c      */	?     errStatus = ReadTimes(TIMESTAMP, providerFD, timeResponse);        /*A      * Check to see if the times were read by the child properly. @      * Return success if the times are there, failure otherwise.      */f  E     timeResponse->status = errStatus ? K_TPI_FAILURE : K_TPI_SUCCESS;(         TraceIf(' 	    (void)printf("Reply written :\n");  	    PrintTimes(timeResponse); 	    );h       /*A      * return RPC status to the caller.  This status is used for b@      * signaling communication errors to the client, in case it F      * cannot bind to the server, or the server crashes while handlingD      * an RPC call.  Return rpc_s_ok, since Time Provider errors are.      * returned in the timeResponse structure.      */        *ComStatus = rpc_s_ok;  ( } /* End of ServerRequestProviderTime */ mD /*******************************************************************  *  *		User Interface Routineso  *E  *******************************************************************/i   /*  *++  *  CommandLineInput()  *  *  Functional Description:y  *6  *	Set the Time provider control parameters using the "  *	user's command line parameters.  *    *  Inputs:   *  *	argv - argv from main.*  *  *  Outputs:  *  *	None.  * s  *  Value Returned:l  *  *	None.  *  *--  */ ! void CommandLineInput(argc, argv) 
 int  argc;
 char *argv[];t { 
     int i;       for (i=1 ; i<argc ; i++)     {  	if (argv[i][0] != '-')i 	{ 	    PrintHelp ();
 	    exit(1);  	} P
         else h	         {n 	    /* $ 	     * Accept upper and lower case. 	     */! 	    switch (tolower(argv[i][1]))P 	    {
 		case 'o': {_ 		    GETNEXTARG(argc);,- 		    if (1 != sscanf(argv[i],"%d",&TRACING))c 		    {t 			(void) fprintf(stderr, / 				"-o:Output value is out of legal range\n");  			PrintHelp (); 			exit(1);f 		    }  		    break; 		}   
 		case 'c': {l 		    GETNEXTARG(argc);t0 		    if (1 != sscanf(argv[i],"%d",&NOCLOCKSET)) 		    {p 			(void) fprintf(stderr, 1 				"-c:Clockset value is out of legal range\n");D 			PrintHelp (); 			exit(1);u 		    }  		    break; 		}l  
 		case 'p': {  		    GETNEXTARG(argc);l0 		    if (1 != sscanf(argv[i],"%d",&POLLRATE) ||  			POLLRATE < K_MIN_POLLRATE ||  			POLLRATE > K_MAX_POLLRATE)  		    {b 			(void) fprintf(stderr, 1 				"-p:Pollrate value is out of legal range\n");t 			PrintHelp (); 			exit(1);h 		    }v 		    break; 		}c  
 		case 'i': {d 		    GETNEXTARG(argc); 4 		    if (1 != sscanf(argv[i], "%d", &INACCURACY) ||$ 			INACCURACY < K_MIN_INACCURACY || ! 			INACCURACY > K_MAX_INACCURACY)  		    {r 			(void) fprintf(stderr, 3 				"-i:Inaccuracy value is out of legal range\n");e 			PrintHelp();  			exit(1);  		    }  		    break; 		}_  
 		case 't': {e 		    GETNEXTARG(argc); 3 		    if (1 != sscanf(argv[i], "%d", &TIMESTAMP) ||e# 			TIMESTAMP < K_MIN_TIMESTAMPS || i  			TIMESTAMP > K_MAX_TIMESTAMPS) 		    {n 			(void) fprintf(stderr,	3 				"-t:Time stamp count is out of legal range\n");n 			PrintHelp();  		                                                                                                                                                                                                                                                                            $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              _ "     ?       	exit(1);i 		    }	 		    break; 		}   
 		case 'd': {  		    GETNEXTARG(argc);t( 		    (void)strcpy(devicename, argv[i]);7             strcpy (TPDEVICE.dsc$a_pointer,devicename);i7             TPDEVICE.dsc$w_length = strlen(devicename);  		    break; 		}    		default: { 		    PrintHelp(); 		    exit(1); 		}t 	    }	/* switch */m
 	}	/* else */      }		/* for */ }a e /*  *++  *  InteractiveInput()  *  *  Functional Description:b  *6  *	Set the Time provider control parameters using the    *	user's interactive responses.  *    *  Inputs:   *  *	None.  *  *  Outputs:  *  *	None.  * e  *  Value Returned:&  *  *	None.  *  *--  */  void InterActiveInput()w {      char inputLine[512];     3     (void) printf("\n\n\nEnter the Device Name: "); (     (void) fgets(inputLine, 512, stdin);2     (void) sscanf(inputLine, "%255s", devicename);          /*      * Get the POLLRATE       */tD     (void) printf("Enter the Poll Rate in Seconds[%d]: ", POLLRATE);(     (void) fgets(inputLine, 512, stdin);/     (void) sscanf(inputLine, "%d", &POLLRATE); l?     if (POLLRATE < K_MIN_POLLRATE || POLLRATE > K_MAX_POLLRATE)i     {nE 	(void) fprintf(stderr, "-p:Pollrate value is out of legal range\n");*	 	exit(1);i     }a       /*      * Get the Inaccuracy       */;@     (void) printf("Enter the Inaccuracy[%d(ms)]: ", INACCURACY);(     (void) fgets(inputLine, 512, stdin);0     (void) sscanf(inputLine, "%d", &INACCURACY);G     if (INACCURACY < K_MIN_INACCURACY || INACCURACY > K_MAX_INACCURACY)o     {uG 	(void) fprintf(stderr, "-i:Inaccuracy value is out of legal range\n");p	 	exit(1);t     }i       /*      * Get the timestamp count      */r@     (void) printf("Enter the Timestamp Count[%d]: ", TIMESTAMP);(     (void) fgets(inputLine, 512, stdin);.     (void) sscanf(inputLine, "%d",&TIMESTAMP);E     if (TIMESTAMP < K_MIN_TIMESTAMPS || TIMESTAMP > K_MAX_TIMESTAMPS)      {(G 	(void) fprintf(stderr, "-t:Time stamp count is out of legal range\n");l	 	exit(1);h     }&       /*&      * Get the disallow clock set flag      */eD     (void) printf("Disallow clock set[%d(Y:1,N:0)] : ", NOCLOCKSET);(     (void) fgets(inputLine, 512, stdin);/     (void) sscanf(inputLine, "%d",&NOCLOCKSET);t       /*       * Get the Output Trace flag      */P<     (void) printf("Output Trace [%d(Y:1,N:0)] : ", TRACING);(     (void) fgets(inputLine, 512, stdin);,     (void) sscanf(inputLine, "%d",&TRACING);   }l e /*  *++  *  Delay()e  *  *  Functional Description:t  *$  *	Print out error text to the user.  *    *  Inputs:   *  *	None.  *  *  Outputs:  *  *	None.  * .  *  Value Returned:-  *  *	None.  *  *--  */t int Delay (secs) unsigned secs; {* #if _DECTHREADS_     timespec_t interval;       interval.tv_sec = secs;      interval.tv_nsec = 0; )     if (pthread_delay_np (&interval) < 0)      { ) 	PrintError("dtsprovider: cannot delay");m 	return (1);     }| #else      unsigned sleep();H       sleep(secs); #endif       return (0);n   } /* End of routine Delay */ e /*  *++  *  PrintError()  *  *  Functional Description:u  *$  *	Print out error text to the user.  *    *  Inputs:m  *  *	None.  *  *  Outputs:  *  *	None.  *    *  Value Returned:h  *  *	None.  *  *--  */e void PrintError (errorString)o char *errorString; {o     BEGIN_NONREENTRANT       perror (errorString);e       END_NONREENTRANT }s /* End of routine PrintError */    /*  *++  *  PrintHelp(),  *  *  Functional Description:   *#  *	Print out help text to the user.t  *    *  Inputs:o  *  *	None.  *  *  Outputs:  *  *	None.  *    *  Value Returned:   *  *	None.  *  *--  */Y void PrintHelp() {p     (void) fprintf(stderr,- 		   "usage:\tdtsprovider -d device-name\n");*     (void) fprintf(stderr,6 		   "\t\t[-p pollrate, range %d : %d, default %d]\n",3 		   K_MIN_POLLRATE,K_MAX_POLLRATE,K_DEF_POLLRATE);*     (void) fprintf(stderr,H      "\t\t[-i milliseconds of inaccuracy, range %d : %d, default %d]\n",; 		   K_MIN_INACCURACY, K_MAX_INACCURACY, K_DEF_INACCURACY);i     (void) fprintf(stderr,8 		   "\t\t[-t timestamps, range %d : %d, default %d]\n",9 		   K_MIN_TIMESTAMPS,K_MAX_TIMESTAMPS,K_DEF_TIMESTAMPS);g     (void) fprintf(stderr,K      "\t\t[-c disallow clock set, range 0(false) : 1(true), default %d]\n",_ 		   K_DEF_NOCLOCKSET);      (void) fprintf(stderr,E      "\t\t[-o output trace, range 0(false) : 1(true), default %d]\n",r 		   K_DEF_TRACING); }  /* End of routine PrintHelp */  B /*****************************************************************  *  *	Device Dependent code	- e#  *			Spectracom radio clock control   *C  *****************************************************************/  /*  *++  *  ReadTimes()c  *  *  Functional Description:   *4  *	Parse out time stamps from the radio clock input.  *    *  Inputs:i  *0  *	timeStamps - the number of timestamps to read#  *	fd - radio clock file descriptor   *  *  Outputs:  *3  *	tpTimeMsg - buffer to return the timestamp data.k  *    *  Value Returned:u  *  *	0 - Success  *	-1 - Failureu  *  *--  */ * int ReadTimes( timeStamps, fd, tpTimeMsg ) unsigned long timeStamps;n int fd;e TPtimeMsg  *tpTimeMsg; {e5     int i;                          /* temp, index */r     int retry;     int status;        retry = K_SPECTRACOM_RETRY;x       /*"      * Now Read The Time Stamps.  K      * Note that this loop will terminate having read timeStamps timestamps =      * or exhausting retry retries. and thus is non-infinite.t      */e  
     i = 0;     while ( i < timeStamps ) {C 	status = QueryProvider( fd, &tpTimeMsg->timeStampList[i].TPtime,  S- 				&tpTimeMsg->timeStampList[i].beforeTime,  - 				&tpTimeMsg->timeStampList[i].afterTime );s   	if (status & 1) {A 	   status = ValidateTime(&tpTimeMsg->timeStampList[i].afterTime,/1 			         &tpTimeMsg->timeStampList[i].TPtime);  	   if (!(status & 1))D 	       PrintValidationError(&tpTimeMsg->timeStampList[i].afterTime,6   			            &tpTimeMsg->timeStampList[i].TPtime);     }e   	if (status & 1) { 	    i += 1;	 	} else {  	    if (retry-- == 0) 		return(0); 	}       }s       return(0); }c a /*  *++  *  InitTP()  *  *  Functional Description:o  *  *G  *  This is the first routine called by the DECdts time provider, it is D  *  called at the beginning of each synchronization.  This allows us%  *  do any necessary initializations.   *  *    *  Inputs:   *  *	None.  *  *  Implicit Inputs:  *  *	The TP year info is valid.c:  *	Note that the TP does not read any year info.  The year;  *	info is manually dialed into the hardware by setting thes9  *	appropriate DIP switches.  If the DIP switches are notnA  *	set correctly, the year and date info of the TP may be faulty.P+  *	The DIP switches must be set each year. *  *;  *	On the PSTI, it is also possible to issue an SY command t2  *	to initialize the year info at machine startup.  *  *  Outputs:  *  *  *  Implicit Outputs:   *  *        *  Value Returned:*  *:  *	The Value returned by this routine directly impacts the8  *	result of a synchronization.  If this routine returns8  *	failure, then the DECdts Time Provider will abort the  *	synchronization.  R  *  *	1 if success, 0 otherwise.t  *  *  *  Side Effects:d  *  *	None.  *--  */  InitTP() {      unsigned long status;e   #ifndef TP_NULLs     /*D      * Assign a channel to the terminal port device connected to the      * TP device.r      */ E     status = SYS$ASSIGN(&TPDEVICE,    	 	/* device name descriptor */ & 			&providerFD, 		/* channel number */  			0,	       		/* access mode */ 			0);			/* mailbox */ #elsec     /*E      * The NULL TP example does not perform any I/O with the externalr      * time source.e      */a     status = 1;  #endif       return( status );    }P /* End of routine initTP */t e /*  *++  *  ExitTP()  *  *  Functional Description:t  *I  *  This is the last user routine called by the DECdts time provider.  It*I  *  allows us to detach the TP's IPC channel to the Time service process.eH  *  It also allows this process to detach from the Time Provider device.  *  *  *    *  Inputs:*  *8  *	providerFD (ttchan)	- channel to time provider device  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *  *	None.  *  *  Implicit Outputs:   *  *	None.  *  *  Value Returned:*  *  *	status	- Status of deassign.s  *  *  Side Effects:   *  *	None.  *--  */* ExitTP( ttchan ) unsigned short ttchan; {a     unsigned long status;   "     status = SYS$DASSGN( ttchan );       return( status );0 }= /* End of routine ExitTP */;    
 /*  #endif /* */                                                                                                                                                                                                                                                                            mN4 $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                               "     P          #ifndef VMS    /*  *++  *  QueryProvider()t  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:   *   *	fd - file descriptor to read.  *  *  Outputs:  *>  *	providerTime - return utc time, the time read from provider7  *	beforeTime - the utc just before the command is sent	=  *	afterTime - the utc just after the on time marker arrived.s  * (  *  Value Returned:S  *-  *	-1	Unequivocal failure - Radio clock fault:  *	0	Success'  *	1	Timeout failure - retry warranted.p  *  *--  */) int O QueryProvider(int fd, utc_t *providerTime, utc_t *beforeTime, utc_t *afterTime)( {=B     struct timeval timeout;		/* time out value for select       */A     char dataLine[MAX_RESPONSE_LENGTH];	/* Response buffer		   */r;     fd_set readfds;			/* mask of file descriptors        */i3     int	n;				/* file descriptor selected on     */cP     int nfds = fd+1;                    /* number of file descripts to select */     int ioctl_arg;     int status;I       /*$      * Flush input and output queues      */      ioctl_arg = 0;   #ifndef VMS	     BEGIN_NONREENTRANT6     status = ioctl(fd, TIOCFLUSH, (char *)&ioctl_arg);     END_NONREENTRANT     if (status < 0) {': 	PrintError("dtsprovider: can't flush radio clock input");
 	exit (1);     }) #endif       /*      * Prepare for select	      */P     FD_ZERO(&readfds);     FD_SET(fd, &readfds);t*     timeout.tv_sec = K_SPECTRACOM_TIMEOUT;     timeout.tv_usec = 0;       /*       * Record 'before' timestamp      */ #     (void) utc_gettime(beforeTime);g       /*+      * Write 'Query' command to radio clock       */yF     if (write(fd, SPECTRACOM_PROMPT, (sizeof(SPECTRACOM_PROMPT)-1)) !=! 	(sizeof(SPECTRACOM_PROMPT)-1)) {a> 	PrintError("dtsprovider: can't send command to radio clock");	 	exit(1);/     }h       /*9      * Wait for the reply by watching the file descriptort      */)=     if ((n = select(nfds, &readfds, (fd_set *)0, (fd_set *)0,r%                     &timeout)) < 0) {'/ 	PrintError("dtsprovider: radio clock select"); 	 	exit(1);*     }u       /*      * Record 'after' timestampn      */ "     (void) utc_gettime(afterTime);       /*"      * Check for timeout in select      */      if (n == 0) {\ 	BEGIN_NONREENTRANTe7 	(void) fprintf(stderr, "dtsprovider:\t* Timeout *\n");i 	END_NONREENTRANT, 	return(1);i     };       /*?      * Wait so that all the characters are in and read the liner      */ 
     Delay(2);[0     n = read(fd, dataLine, MAX_RESPONSE_LENGTH);"     if (n < MIN_RESPONSE_LENGTH) {
 	if (n < 0) {LA             PrintError("dtsprovider: error reading radio clock");L	 	} else {  	    BEGIN_NONREENTRANTr 	    (void) fprintf(stderr,fN                       "dtsprovider: radio clock returned only %d bytes\n", n); 	    END_NONREENTRANTt 	    dataLine[n] = '\0';> 	    (void) fprintf(stderr, "time returned - %s\n", dataLine);	         }) 	return(1);L	     }    &     dataLine[n] = '\0';C       /*C      * Now parse the radio clock data to determine the actual time.p      */e.     return(ParseTime(providerTime, dataLine)); }p #endif   #ifdef TP_PSTI /*;  **********************************************************(  *		PSTI Specific Routines. ;  **********************************************************   */i   /*  * PSTI specific constants  */ B #define M_PSTI_AVAIL		0x08	/* bit to test for time availability */; #define M_PSTI_OUT_OF_SPEC	0x40	/* out of spec time mask */u8 #define M_PSTI_HARD_FAULT	0x20	/* PSTI hardware fault */B #define M_PSTI_SIGNAL_FAULT	0x10	/* PSTI signal fault time mask */  H #define PSTI_PROMPT             "QA0000"/* prompt string for OEM time */@ #define PSTI_RESPONSE_LENGTH     (13)	/* bytes returned by QA */M #define PSTI_NOCLOCKSET          (0)     /* allow the clock to be affected */rM #define PSTI_POLL_RATE           (60)    /* sixty seconds between tp polls */ M #define PSTI_TIME_STAMPS         (3)     /* number of time samples to read */ K #define PSTI_INACCURACY          (30)    /* 30ms of inaccuracy default   */ L #define PSTI_TMORATE             (30)	 /* 30 secs to respond to TS request*/  K #define PSTI_QIO_TIMEOUT         (3)	 /* seconds till read QIO times out */iP #define PSTI_RETRIES             (5)     /* allow 5 retries after a TP failure*/6 #define PSTI_ISVERBOSE		 (1)     /* generate output */L #define PSTI_MAXTPERROR          (60)    /* ignore deltas greater than 60 */L #define PSTI_FIRSTSYNCH          (1)     /* synch up the first time thru  */   /*  B  * There are only 6 bits of valid data in any PSTI data byte.  Bit9  * 7 and 0 are used for parity checks and other purposes.t8  * Mask07 strips bit 7 and bit 0 from a PSTI data byte, +  * then it normalizes the data into a byte.   */ 6 #define Mask07( dataByte )  (( dataByte & 0x7F) >> 1 )   /*J  * Mask07AndAdd  strips non data bits from two bytes and then concatenatesI  * them into a single value.  Used for data that does not fit in a single   * byte of information.c  */l2 #define Mask07AndAdd(dataByteHi, dataByteLo)     \5 		( Mask07(dataByteLo) + ( Mask07(dataByteHi) << 6 )):     /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:d  *A  *  Initialize the default input parameters for the external time 
  *  provider.n  *  *  *    *  Inputs:d  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rateL7  *    timestamp- int to be set to the default number ofsD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).n@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notpE  *               be affected by the results of the TP synch, false ifGC  *               the clock can be modified by the results of the TP*  *               synch.*E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the *=  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the external >  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messages #  *               will be displayed.   *  *    *  Implicit Outputs:r  *    none.r  *        *  Value Returned:r  *    none.C  *  *  Side Effects:   *    none.   *  *--  */.- void InitializeTPdefaults(pollrate,timestamp,a 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,i 			  isverbose)  int *pollrate,     *timestamp,      *inaccuracy,
     *tmorate,u     *clockSet,
     *retries,m     *firstsynch,     *maxtperror,     *isverbose;s {]8     *pollrate  = PSTI_POLL_RATE;    /* seconds        */8     *timestamp = PSTI_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= PSTI_INACCURACY;   /* milliseconds   */8     *tmorate   = PSTI_TMORATE;      /* seconds        */8     *clockSet  = PSTI_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = PSTI_RETRIES;      /* int > 0        */8     *firstsynch= PSTI_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= PSTI_MAXTPERROR;   /* seconds        */:     *isverbose = PSTI_ISVERBOSE;      /* int > 0        */ }i) /* End of routine InitializeTPdefaults */      o /*  *++  *  QueryProvider()   *  *  Functional Description:h  *B  *  This routine issues a single QA300 command to the PSTI device.?  *  It returns the Binary Absolute Time represented by the PSTI*  *  data returned.  *  *    *  Inputs:   *2  *	ttchan - The active channel to the PSTI device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the PSTI device.e  * s  *  Implicit Outputs:t  *  *        *  Value Returned:o  *(  *	0 - Failure - The PSTI device failed.4  *      1 - Success - The PSTI device was contacted.  *  *  Side Effects:   *  *  *--  */  int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)l {r     /*=      * Passing Binary encoded data. See PSTI dip switches fora@      * baud.  Set                                                                                                                                                                                                                                                                            9{ $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              , "     a       terminal characteristics for Eightbit,pasall,       * pasthru.t      */s(     char TPdata[PSTI_RESPONSE_LENGTH+1];     int  status;     int  retSize;	.     IOsb  TPIOSB;		/* status block for PSTI */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};    			        /*r0    				 * now a structure to set the terminator  				 * character for the read.
    				 */  %     (void) utc_gettime( beforeTime );        /*C      * post qiow read to the psti with a timeout.  This also purges02      * the input buffer of any residue characters.      */e+     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */P 			IO$M_TIMED |n 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */c; 		      PSTI_RESPONSE_LENGTH,	/* buffer size of response */ ; 		      PSTI_QIO_TIMEOUT,	        /* P3; secs to timeout */ : 		      &term_mask,		/* P4: mask specifying terminators */. 		      PSTI_PROMPT, 		/* P5; prompt string */9 		      strlen(PSTI_PROMPT)); 	/* P6; length of prompt */O    $     (void) utc_gettime( afterTime );       if ( !(status & 1) )     {eC 	(void) fprintf(stderr, "M_PSTI: QIO Status failure %x\n", status);t         return ( status );     }      if ( !(TPIOSB.status & 1) )      {=B         (void) fprintf(stderr, "M_PSTI: IOSB Status failure %x\n", 		       TPIOSB.status);!         return ( TPIOSB.status );*     }        /*5      * check that we got the correct number of bytes. #      * Otherwise return hard error.n      */ 2     if (TPIOSB.byteCount != PSTI_RESPONSE_LENGTH)      {s? 	(void) fprintf(stderr, "M_PSTI: response length failure %x\n",u 		       TPIOSB.byteCount);r 	return(0);f     }      /*F      * Check all the status bits, make sure this time is truely valid.      * Additional stamps?       */ '     if ( !(TPdata[0] & M_PSTI_AVAIL) ) a     { : 	(void) fprintf(stderr, "M_PSTI: time not Available %x\n", 		       TPdata[0]); 	return(0);      }P)     if ( TPdata[0] & M_PSTI_OUT_OF_SPEC )*     {i< 	(void) fprintf(stderr, "M_PSTI: out of spec detected %x\n", 		       TPdata[0]); 	return(0);      }d*     if ( TPdata[0] & M_PSTI_SIGNAL_FAULT )     { < 	(void) fprintf(stderr, "M_PSTI: out of spec detected %x\n", 		       TPdata[0]); 	return(0);t     }c(     if ( TPdata[0] & M_PSTI_HARD_FAULT )     { ; 	(void) fprintf(stderr, "M_PSTI: hard fault detected %x\n",_ 		       TPdata[0]); 	return(0);      }u    p     /*=      * Convert the data returned by the PSTI into struct utc.       */R)     return(CvtTPtoUTC( TPdata, TPtime ));    }    c /*  *++  *  CvtTPtoUTC()  *  *  Functional Description:t  *C  * This routine converts the response string of the PSTI QA command %  * into a Binary Absolute Time value.l  *  *  *    *  Inputs:(  *&  *	respString - The QA command string.  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:u  * t  *	None.  *        *  Value Returned:e  * r  *	None.  *  *  Side Effects:*  *    *	None.  *  *--  */M CvtTPtoUTC( TPdata, TPtime )
 char *TPdata;( struct utc *TPtime;M   {)    long		tns, ins;    struct tm	time, inacc;a       /*  '      * convert bytes 2 and 3 into msec.       */ =     tns = (Mask07AndAdd(TPdata[2], TPdata[3])) * K_NS_PER_MS;f       /* c0      * convert bytes 4,5,6 into sec, mins, hours      */ $     time.tm_sec = Mask07(TPdata[4]);$     time.tm_min = Mask07(TPdata[5]);%     time.tm_hour = Mask07(TPdata[6]);c       /*-      * convert bytes 7 and 8 into day of yeara      */;5     time.tm_yday = Mask07AndAdd(TPdata[7],TPdata[8]);         /* =:      * convert byte 9 (offset from 1986) into current year      */*3     time.tm_year = 1986 + Mask07(TPdata[9]) - 1900;        /*  &      * get it yearday into mon and day      */ G     MonthDay (time.tm_year, time.tm_yday, &time.tm_mon, &time.tm_mday);M     time.tm_isdst = 0;       /*      * Get the inaccuracy       */L  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;i"     inacc.tm_min = 0;                  inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0; 4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  6     if (utc_mkgmtime(TPtime, &time, tns, &inacc, ins)) 	return(0);t     else 	return(1);d   }\ /* End of routine CvtTPtoUTC */r   L /*  *++  *  MonthDay()  *  *  Functional Description:w  *B  *  This routine Converts the current year, and the current day of2  *  the year (ie 174th day of 1989) to a month andC  *  day in month format ( 12 - 31 - 1989 ).  This serves to convert*;  *  the PSTI date into something we can more easily handle.*  *  *    *  Inputs:*  * *-  *	currYear - The current year as an integer.c)  *	yearDay - The current day in the year.8  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *-  *	currMonth - The numerical month ( 1 - 12 )n1  *	dayInMonth   - The day in the month ( 1 - 31 )   * n  *  Implicit Outputs:x  *	   *	None.  *  *  Value Returned:d  *  *	None.  *  *  Side Effects:"  *  *	None.  *  *--  */ 2 MonthDay(currYear, yearDay, currMonth, dayInMonth)* int	currYear;				/* current year - 1900 */! int	yearDay;				/* day of year */o% int	*currMonth;				/* ptr to month */E- int	*dayInMonth;				/* ptr to day of month */p {s   int dayTab [2] [13] = {M5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, 6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};; 			/* table for get_month and day from day of year input */	     int	i, leap;    1 	leap = (currYear%4 == 0 && currYear%100 != 0) || '                (currYear+300)%400 == 0;*+ 	for (i=1; yearDay > dayTab[leap] [i]; i++)/! 	    yearDay -= dayTab[leap] [i];e   	*currMonth = i-1; 	*dayInMonth = yearDay;e }t #endif f #ifdef TP_GC1000 /*;  **********************************************************S  *		GC1000 Specific Routines. ;  **********************************************************   */s  H #define GC1000_PROMPT          " "	/* Prompt string for clock trigger */K #define GC1000_RESPONSE_LENGTH (24)	/* Number of bytes returned by clock */ L #define GC1000_NOCLOCKSET      (0)      /* allow the clock to be affected */L #define GC1000_POLL_RATE       (60)     /* sixty seconds between tp polls */L #define GC1000_TIME_STAMPS     (3)      /* number of time samples to read */J #define GC1000_INACCURACY      (30)     /* 30ms of inaccuracy default   */J #define GC1000_TMORATE         (30)	/* 30 secs to respond to TS request */H #define GC1000_QIO_TIMEOUT     (3)	/* seconds till read QIO times out */P #define GC1000_RETRIES         (5)      /* allow 5 retries after a TP failure */< #define GC1000_ISVERBOSE       (1)     /* generate output */J #define GC1000_MAXTPERROR      (60)    /* ignore deltas greater than 60 */J #define GC1000_FIRSTSYNCH      (1)     /* synch up the first time thru  */   /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:e  *A  *  Initialize the default input parameters for the external timer
  *  provider.   *  *  *    *  Inputs:e  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rate 7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).o@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notaE  *               be affected by the results of the TP synch, false ifrC  *               the clock can be modified by the results of the TPr  *               synch. E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the  =  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the externaln>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, theo2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagesp#  *               will be displayed.c  *  *  * t  *  Implic                                                                                                                                                                                                                                                                           \/J $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                               "     r       it Outputs:,  *    none.s  *        *  Value Returned:p  *    none.i  *  *  Side Effects:l  *    none._  *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,S 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch, maxtperror, 			  isverbose)a int *pollrate,     *timestamp,n     *inaccuracy,
     *tmorate,T     *clockSet,
     *retries,/     *firstsynch,     *maxtperror,     *isverbose;    { :     *pollrate  = GC1000_POLL_RATE;    /* seconds        */:     *timestamp = GC1000_TIME_STAMPS;  /* int, 1-6       */:     *inaccuracy= GC1000_INACCURACY;   /* seconds        */:     *tmorate   = GC1000_TMORATE;      /* seconds        */:     *clockSet  = GC1000_NOCLOCKSET;   /* int, t/f - 1/0 */:     *retries   = GC1000_RETRIES;      /* int > 0        */:     *firstsynch= GC1000_FIRSTSYNCH;   /* int > 0        */:     *maxtperror= GC1000_MAXTPERROR;   /* seconds        */<     *isverbose = GC1000_ISVERBOSE;      /* int > 0        */   } ) /* End of routine InitializeTPdefaults */p     /*  *++  *  QueryProvider()e  *  *  Functional Description:   *F  *  This routine issues a single trigger command to the GC1000 device.A  *  It returns the Binary Absolute Time represented by the GC1000   *  data returned.  *  *    *  Inputs:   *4  *	ttchan - The active channel to the GC1000 device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *3  *	TPtime - The Time returned by the GC1000 device.   * s  *  Implicit Outputs:a  *  *        *  Value Returned:*  **  *	0 - Failure - The GC1000 device failed.6  *      1 - Success - The GC1000 device was contacted.  *  *  Side Effects:;  *  *  *--  */    int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)  {r*     char TPdata[GC1000_RESPONSE_LENGTH+1];     int  status;0     IOsb  TPIOSB;		/* status block for GC1000 */  %     (void) utc_gettime( beforeTime );*          /*D      * post qiow read to the clock with a timeout.  This also purges2      * the input buffer of any residue characters.      */O+     status = SYS$QIOW(0,			/* event flag */*& 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */	 			IO$M_TIMED |	 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */S= 		      GC1000_RESPONSE_LENGTH,	/* buffer size of response */O5 		      GC1000_QIO_TIMEOUT,	/* P3; secs to timeout */a& 		      0,			/* P4: terminator mask */0 		      GC1000_PROMPT, 		/* P5; prompt string */; 		      strlen(GC1000_PROMPT)); 	/* P6; length of prompt */     $     (void) utc_gettime( afterTime );       if ( !(status & 1) )     { E 	(void) fprintf(stderr, "M_GC1000: QIO Status failure %x\n", status);          return ( status );     }      if ( !(TPIOSB.status & 1) )      { D         (void) fprintf(stderr, "M_GC1000: IOSB Status failure %x\n", 		       TPIOSB.status);!         return ( TPIOSB.status );      }        /*5      * check that we got the correct number of bytes. #      * Otherwise return hard error. "      * (Subtract one for the <CR>)      */S6     if (TPIOSB.byteCount != GC1000_RESPONSE_LENGTH-1)      {eA 	(void) fprintf(stderr, "M_GC1000: response length failure %x\n",  		       TPIOSB.byteCount);l 	return(0);i     }e     /*=      * Check the return buffer to make sure it's a valid time       *	buf[0:1]	HoursM      *  buf[2]		':'       *  buf[3:4]        MinutesT      *  buf[5]		':'       *  buf[6:7]        Secondst      *  buf[8]		'.'       *  buf[9]		Tenths      *  buf[10:14]	blankso      *  buf[15:16]      Montht      *  buf[17]		'/'      *  buf[18:19]	Day      *  buf[20]		'/'      *  buf[21:22]	YearP      *  buf[23]         <CR>      */i     if ( TPdata[0] == '?' )      {cC /*	(void) fprintf(stderr, "M_GC1000: clock not synchronized\n"); */t 	return(0);_     }U       /*9      * If tenths of seconds are '?', then we are drifting\      */      if ( TPdata[9] == '?' )      {u #ifdef DEBUG 	TPdata[9] = '0';e #elsee> /*	(void) fprintf(stderr, "M_GC1000: time not accurate\n"); */ 	return(0);, #endif     }        /*,      * Check delimiters for proper positions      */i!     if ( ( TPdata[2] != ':' ) || t!          ( TPdata[5] != ':' ) || o!          ( TPdata[8] != '.' ) || i"          ( TPdata[17] != '/' ) ||            ( TPdata[20] != '/' ) )     {rG 	(void) fprintf(stderr, "M_GC1000: time/date string format invalid\n");* 	return(0);      }e       /*)      * Check fields for proper charactersn      */ $     if ( !( isdigit(TPdata[0]) ) ||  	 !( isdigit(TPdata[1]) ) ||   	 !( isdigit(TPdata[3]) ) || T 	 !( isdigit(TPdata[4]) ) || * 	 !( isdigit(TPdata[6]) ) ||   	 !( isdigit(TPdata[7]) ) || r 	 !( isdigit(TPdata[9]) ) ||   	 !( isdigit(TPdata[15]) ) ||  	 !( isdigit(TPdata[16]) ) ||  	 !( isdigit(TPdata[18]) ) ||  	 !( isdigit(TPdata[19]) ) ||  	 !( isdigit(TPdata[21]) ) ||  	 !( isdigit(TPdata[22]) ) )     {eF 	(void) fprintf(stderr, "M_GC1000: time/date field format invalid\n"); 	return(0);=     }(    a     /*?      * Convert the data returned by the GC1000 into struct utc.;      */e)     return(CvtTPtoUTC( TPdata, TPtime ));)   }      /*  *++  *  CvtTPtoUTC()  *  *  Functional Description:e  *:  * This routine converts the response string of the GC1000%  * into a Binary Absolute Time value.n  *    *  Inputs:   *-  *	The GC1000 date/time string in the format:m4  *		"HH:MM:SS.D_____MM/DD/YY" (where '_' is a space)  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:   *    *	None.  *        *  Value Returned:   *    *	None.  *  *  Side Effects:   * C  *	None.  *  *--  */_ CvtTPtoUTC( TPdata, TPtime )
 char *TPdata;i struct utc *TPtime;)   {t"    long		tns, ins, dns, dns_inacc;-    struct tm	time, inacc, delta, delta_inacc;     struct utc   TPdelta;    struct utc   TPraw;       /* *#      * convert all fields in recorde      */h1     if ( sscanf( TPdata, "%d:%d:%d.%d %d/%d/%d", 9A                 &time.tm_hour, &time.tm_min, &time.tm_sec, &tns,  E                 &time.tm_mon, &time.tm_mday, &time.tm_year ) == EOF )      {*I 	(void) fprintf(stderr, "M_GC1000: time/date field conversion failed\n");r 	return(0);y     }c       /* i9      * convert tenths of seconds (hundreds of ms) into ns*      */:"     tns = tns * 100 * K_NS_PER_MS;       /* 1)      * Adjust the months to be zero basedh      */        time.tm_mon -= 1;t       /*  !      * Zero out the unused fieldsd      */N       time.tm_wday = 0;s     time.tm_yday = 0;*     time.tm_isdst = 0;       /*      * Get the inaccuracy       */e  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;	     inacc.tm_min = 0;	     inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;m4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  6     if (utc_mkgmtime(&TPraw, &time, tns, &inacc, ins)) 	return(0);,       /*,      * Adjust the time for the clock delays:-      *  1.00 seconds from trigger to responseaA      *  0.024 seconds from response to processed ( at 9600 baud )       */u       delta.tm_hour = 0;     delta.tm_min = 0;a     delta.tm_sec = 1;      delta.tm_wday = 0;     delta.tm_mday = 0;     delta.tm_mon = 0;a     delta.tm_year = 0;     delta.tm_yday = 0;     delta.tm_isdst = 0;*     dns = 24 * K_NS_PER_MS;*       delta_inacc.tm_hour = 0;     delta_inacc.tm_min  = 0;     delta_inacc.tm_sec  = 0;     delta_inacc.tm_wday = 0;     delta_inacc.tm_mday = 0;     delta_inacc.tm_mon  = 0;     delta_inacc.tm_year = 0;     delta_inacc.tm_yday = 0;     delta_inacc.tm_isdst= 0;     dns_inacc = 0;  F     if (utc_mkreltime(&TPdelta, &delta, dns, &delta_inacc, dns_inacc)) 	return(0);s  .     if (utc_addtime(TPtime, &TPdelta, &TPraw)) 	return(0);      else 	return(1);t   }a /* End of routine CvtTPtoUTC */I #endif   #ifdef TP_SPEC /*;  **********************************************************0#  * 		Spectracom Specific  Routines. ;  **********************************************************I  */e /*)  * Spectracom character conversion macros   */a+ #define CVT_ASCII_TO_INT(chr) ((chr) - '0') 0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))r     /*  *	Literalsf  */C  > #define M_SPECTRACOM_CLOCK_RESET   (0x1)    /* Clock reset		*/@ #define M_SPECTRACOM_YEAR_MISMATCH (0x2)    /* Year mismatch		*/? #define M_SPECTRACOM_AVAIL	   (0x4)    /* Time not available	*/x                                                                                                                                                                                                                                                   	                        &!z $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              "5 "            ? #define M_SPECTRACOM_SIGNAL_FAULT  (0x8)    /* Signal fault		*/lA #define M_SPECTRACOM_HARD_FAULT	   (0x10)   /* Hardware fault		*/sC #define M_SPECTRACOM_OUT_OF_SPEC   (0x20)   /* Time out of spec		*/e  9 #define M_SPECTRACOM_PM_TIME	   (0x8)	/* PM indication	*/e8 #define M_SPECTRACOM_12_HR	   (0x10)	/* 12 hour mode		*/  K #define SPECTRACOM_NOCLOCKSET    (0)   /* allow the clock to be affected */eK #define SPECTRACOM_POLL_RATE     (60)  /* sixty seconds between tp polls */tK #define SPECTRACOM_TIME_STAMPS   (3)   /* number of time samples to read */ I #define SPECTRACOM_INACCURACY    (30)  /* 30ms of inaccuracy default   */ P #define SPECTRACOM_TMORATE       (30)  /* 30 seconds to respond to TS request */I #define SPECTRACOM_RETRIES       (2)  /* allow 2 errors per radio read */f #define SPECTRACOM_PROMPT	 "T"  K #define SPECTRACOM_RESPONSE_LENGTH      (26) /* Length of valid response */   G #define SPECTRACOM_TIMEOUT	        (30) /* Allow 30 seconds for radio *r( 					      * clock to respond to TS	  */L #define SPECTRACOM_QIO_TIMEOUT           (5) /* Allow  5 secs to respond  */C #define SPECTRACOM_RETRY	         (2) /* Retry twice on error 	  */t8 #define SPECTRACOM_ISVERBOSE		 (1) /* generate output */P #define SPECTRACOM_MAXTPERROR            (60)/* ignore deltas greater than 60 */P #define SPECTRACOM_FIRSTSYNCH            (1) /* synch up the first time thru  */     r /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:   *A  *  Initialize the default input parameters for the external times
  *  provider.s  *  *  *    *  Inputs:n  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll ratea7  *    timestamp- int to be set to the default number ofeD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).i@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should notcE  *               be affected by the results of the TP synch, false if C  *               the clock can be modified by the results of the TPf  *               synch.NE  *    retries -  int to be set to the number of times the program is c7  *               allowed to resend a request after the *=  *               external time source has returned a failure.sG  *    firstsync- boolean, assume that the time returned by the externaln>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, thec2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messages #  *               will be displayed.   *  *  * d  *  Implicit Outputs:-  *    none.e  *        *  Value Returned:s  *    none.0  *  *  Side Effects:   *    none.E  *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,  			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)t int *pollrate,     *timestamp,t     *inaccuracy,
     *tmorate,      *clockSet,
     *retries,	     *firstsynch,     *maxtperror,     *isverbose;i { >     *pollrate  = SPECTRACOM_POLL_RATE;    /* seconds        */>     *timestamp = SPECTRACOM_TIME_STAMPS;  /* int, 1-6       */>     *inaccuracy= SPECTRACOM_INACCURACY;   /* seconds        */>     *tmorate   = SPECTRACOM_TIMEOUT;      /* seconds        */>     *clockSet  = SPECTRACOM_NOCLOCKSET;   /* int, t/f - 1/0 */>     *retries   = SPECTRACOM_RETRIES;      /* int > 0        */>     *firstsynch= SPECTRACOM_FIRSTSYNCH;   /* int > 0        */>     *maxtperror= SPECTRACOM_MAXTPERROR;   /* seconds        */@     *isverbose = SPECTRACOM_ISVERBOSE;      /* int > 0        */   }0) /* End of routine InitializeTPdefaults */      /*  *++  *  QueryProvider()/  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:c  *  *	ttchan - channel to read.  *  *  Outputs:  *8  *	TPtime - return utc time, the time read from provider7  *	beforeTime - the utc just before the command is sent =  *	afterTime - the utc just after the on time marker arrived.d  * "  *  Value Returned:   *-  *	-1	Unequivocal failure - Radio clock faulte  *	0	Success'  *	1	Timeout failure - retry warranted.k  *  *--  */e int R QueryProvider ( int ttchan, utc_t  *TPtime, utc_t  *beforeTime, utc_t  *afterTime) {eH     char TPdata[SPECTRACOM_RESPONSE_LENGTH + 1];   /* Response buffer	*/     int  status;     int  retSize;	4     IOsb  TPIOSB;		/* status block for spectracom */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};    			        /*r0    				 * now a structure to set the terminator  				 * character for the read.
    				 */       /*       * Record 'before' timestamp      */ #     (void) utc_gettime(beforeTime);*       /*I      * post qiow read to the spectracom with a timeout.  This also purges 2      * the input buffer of any residue characters.      */ +     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */- 		      IO$_READPROMPT |		/* function code */1 			IO$M_TIMED |n 			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */ A 		      SPECTRACOM_RESPONSE_LENGTH, /* buffer size of response */ ; 		      SPECTRACOM_QIO_TIMEOUT,	  /* P3; secs to timeout */m: 		      &term_mask,		/* P4: mask specifying terminators */4 		      SPECTRACOM_PROMPT, 		/* P5; prompt string */? 		      strlen(SPECTRACOM_PROMPT)); 	/* P6; length of prompt */        /*      * Record 'after' timestamp       */p"     (void) utc_gettime(afterTime);       if ( !(status & 1) )     {(C 	(void) fprintf(stderr, "M_SPEC: QIO Status failure %x\n", status);          return ( status );     }0     if ( !(TPIOSB.status & 1) )      { K         (void) fprintf(stderr, "M_SPEC: IOSB Status failure %x bytes %d\n",T 		       TPIOSB.status,d 		       TPIOSB.byteCount);i!         return ( TPIOSB.status );g     }t       /*5      * check that we got the correct number of bytes.[#      * Otherwise return hard error.)      */(8     if (TPIOSB.byteCount != SPECTRACOM_RESPONSE_LENGTH)      { ? 	(void) fprintf(stderr, "M_SPEC: response length failure %x\n",\ 		       TPIOSB.byteCount);  	return(0);      }n.     TPdata[SPECTRACOM_RESPONSE_LENGTH] = '\0';       /*C      * Now parse the radio clock data to determine the actual time.*      */v&     return(ParseTime(TPtime, TPdata)); }e * /*  *++  *  ParseTime()t  *  *  Functional Description:   *A  *	Convert the radio clock text data string into a numerical utc.G  *    *  Inputs:i  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  *    *  Value Returned:   *  *	1 - Success  * 	0 - Failure   *  *--  */t int ParseTime (utcTime, buffer)  struct utc *utcTime; char   *buffer;. {*!     static char daytab[2][13] = {.5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},P6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;t     struct tm inacc;     unsigned long ins;     unsigned long tns;     char status;     int leapyear;e
     int i;       /*%      * Convert and parse status bytes"      */%     status = buffer[2];        if (status == '*') { 	(void) fprintf(stderr,,L                   "dtssprovider: Spectracom manually set, ignoring time\n"); 	return(0);      }(       if (status == '?') {F 	(void) fprintf(stderr, "dtssprovider: Spectracom has lost signal\n"); 	return(0);h     }c       if (buffer[3] == '$') {  	(void) fprintf(stderr, B 		       "dtssprovider: Spectracom year incorrect in switches\n"); 	return(0);*     }        /*%      * Check clock qualtity indicator       */d       if (buffer[3] == 'A')e4 	ins += 9 * K_NS_PER_MS;		/* Add additional 9 ms. */     else if (buffer[3] == 'B')5 	ins += 99 * K_NS_PER_MS;	/* Add additional 99 ms. */C     else if (buffer[3] == 'C')7 	ins += 499 * K_NS_PER_MS;	/* Add additional 499 ms. */;     else if (buffer[3] == 'D')% 	return(0);			/* Clock too far out */S  5     if ((buffer[0] != '\015' || buffer[1] != '\n') ||cL         (buffer[13] != ':') || (buffer[16] != ':') || (buffer[                                                                                                                                                                                                                                                   
                        e $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                               "            19] != '.')) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n"); : 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	return(0);t     }u       /*I      * Convert bytes 2 and 3 into year. If the result is before 1990, thee%      * century most have rolled over.a      */t  7     timetm.tm_year = CVT_ASCII_TO_INT(buffer[4]) * 10 +=# 		     CVT_ASCII_TO_INT(buffer[5]);      if (timetm.tm_year < 90) 	timetm.tm_year += 100;        /*0      * Convert bytes 5, 6 and 7 into day of year      */e8     timetm.tm_yday = CVT_ASCII_TO_INT(buffer[7]) * 100 +) 		     CVT_ASCII_TO_INT(buffer[8]) * 10 +m# 		     CVT_ASCII_TO_INT(buffer[9]);        /*(      * Convert bytes 9 and 10 into hours      */l8     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[11]) * 10 +$ 		     CVT_ASCII_TO_INT(buffer[12]);       /*+      * Convert bytes 12 and 13 into minuteso      */ 7     timetm.tm_min = CVT_ASCII_TO_INT(buffer[14]) * 10 +*# 		    CVT_ASCII_TO_INT(buffer[15]);*       /*+      * Convert bytes 15 and 16 into seconds*      */*7     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[17]) * 10 + # 		    CVT_ASCII_TO_INT(buffer[18]);c       /*3      * Convert bytes 18, 19 and 20 into nanosecondsn      */I/     tns = (CVT_ASCII_TO_INT(buffer[20]) * 100 +_' 	   CVT_ASCII_TO_INT(buffer[21]) * 10 +)0 	   CVT_ASCII_TO_INT(buffer[22])) * K_NS_PER_MS;       /*%      * Compute month and day of monthd      */PL     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);f$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];      timetm.tm_mon = i-1;       /*      * Check values*      */f2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||  	timetm.tm_hour > 23 ||	 	timetm.tm_yday > 366) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n");n: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	return(0);d     }P       /*B      * Convert the data returned by radio clock into a struct utc.      * Call the DTSS API      */s5     (void)memset((void *)&inacc,0,sizeof(struct tm));E-     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;u4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;K     return((utc_mkgmtime(utcTime, &timetm, tns, &inacc, ins)== 0) ? 1 : 0);R   }R #endif   H #ifdef TP_TRAC /*;  **********************************************************(!  * 		Traconex Specific  Routines.r  *;  **********************************************************O  */O   /*'  * Traconex character conversion macros/  */f+ #define CVT_ASCII_TO_INT(chr) ((chr) - '0')i0 #define CVT_ASCII_TO_INT_AND_ADD(chrhi, chrlo) \; 	((CVT_ASCII_TO_INT(chrhi) << 6) + CVT_ASCII_TO_INT(chrlo))    /*  *  Traconex Literalsr  */ 9 #define M_TRACONEX_CLOCK_RESET	 (0x1)	/* Clock reset			*/ ; #define M_TRACONEX_YEAR_MISMATCH (0x2)	/* Year mismatch		*/a9 #define M_TRACONEX_AVAIL	 (0x4)	/* Time not available		*/ ; #define M_TRACONEX_SIGNAL_FAULT	 (0x8)	/* Signal fault			*/s; #define M_TRACONEX_HARD_FAULT	 (0x10)	/* Hardware fault		*/p> #define M_TRACONEX_OUT_OF_SPEC	 (0x20)	/* Time out of spec		*/  6 #define M_TRACONEX_PM_TIME	 (0x8)	/* PM indication		*/5 #define M_TRACONEX_12_HR	 (0x10)	/* 12 hour mode			*/o  & #define TRACONEX_PROMPT		 "\003QU0000"$ #define TRACONEX_PROMPT_LENGTH   (9)  J #define TRACONEX_RESPONSE_LENGTH (10) /* Length of valid resp.          */  C #define TRACONEX_TIMEOUT       (45)   /* Allow 45 seconds for TPP	*t. 				       * to respond to TS               */A #define TRACONEX_RETRY	       (5)    /* Retry 5 times		        */lJ #define TRACONEX_QIO_TIMEOUT   (30)   /* allow 30 secs for radio to resp*/J #define TRACONEX_NOCLOCKSET    (0)    /* allow the clock to be affected */J #define TRACONEX_POLL_RATE     (60)   /* sixty seconds between tp polls */J #define TRACONEX_TIME_STAMPS   (3)    /* number of time samples to read */J #define TRACONEX_INACCURACY    (30)   /* 30ms of inaccuracy default     */J #define TRACONEX_ISVERBOSE     (1)    /* generate output                */J #define TRACONEX_MAXTPERROR    (60)   /* ignore deltas greater than 60  */J #define TRACONEX_FIRSTSYNCH    (1)    /* synch up the first time thru   */     l /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:t  *A  *  Initialize the default input parameters for the external time 
  *  provider.l  *  *  *    *  Inputs:r  *    None.b  *  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rate 7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).t@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not E  *               be affected by the results of the TP synch, false if C  *               the clock can be modified by the results of the TPt  *               synch.EE  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the E=  *               external time source has returned a failure.SG  *    firstsync- boolean, assume that the time returned by the external*>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, thei2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagese#  *               will be displayed.v  *  *  * r  *  Implicit Outputs:f  *    none.n  *        *  Value Returned:u  *    none.   *  *  Side Effects:v  *    none.*  *  *--  */d- void InitializeTPdefaults(pollrate,timestamp,  			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)e int *pollrate,     *timestamp,t     *inaccuracy,
     *tmorate,m     *clockSet,
     *retries,C     *firstsynch,     *maxtperror,     *isverbose;    {sA     *pollrate  = TRACONEX_POLL_RATE;         /* seconds        */sA     *timestamp = TRACONEX_TIME_STAMPS;       /* int, 1-6       */{A     *inaccuracy= TRACONEX_INACCURACY;        /* seconds        */eA     *tmorate   = TRACONEX_TIMEOUT;           /* seconds        */ A     *clockSet  = TRACONEX_NOCLOCKSET;        /* int, t/f - 1/0 */bA     *retries   = TRACONEX_RETRY;             /* int > 0        */hA     *firstsynch= TRACONEX_FIRSTSYNCH;        /* int > 0        */dA     *maxtperror= TRACONEX_MAXTPERROR;        /* seconds        */*C     *isverbose = TRACONEX_ISVERBOSE;           /* int > 0        */	 }f) /* End of routine InitializeTPdefaults */_   O /*  *++  *  QueryProvider()I  *  *  Functional Description:   *H  *      Query the provider for the time. Generate the timestamp triplet.  *    *  Inputs:r  *  *	ttchan - channel to read.  *  *  Outputs:  *8  *	TPtime - return utc time, the time read from provider>  *	beforeTime - the utc just before the on time marker arrived=  *	afterTime - the utc just after the on time marker arrived.   * t  *  Value Returned:t  *4  *	-1	Unequivocal failure - Stratum too far from TP.  *	0	Success&  *	1	Timeout failure - retry warented.  *  *--  */t   int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)  {      /*&      * Posting and reading characters.9      * See Traconex DIP switches for speed and parity forr      * data exchange.       */SF     char TPdata[TRACONEX_RESPONSE_LENGTH+1];	/* Response buffer		   */@     static char traconex_prompt_string[TRACONEX_PROMPT_LENGTH] =(     {0,'0','3','Q','U','0','0','0','0'};     int  status;     int  retSize;	.     IOsb  TPIOSB;		/* status block for PSTI */     struct {long null;) 	    long mask;} term_mask = {0, 0x0000};	   			        /*e0    				 * now a structure to set the terminator  				 * character for the read.
    				 */            /*       * Record 'before' timestamp      */i#     (void) utc_gettime(beforeTime);T       /*C      * post qiow read to the psti with a timeout.  This also purgesp2      * the input buffer of any residue characters.      */a+     status = SYS$QIOW(0,			/* event flag */b& 		      ttchan,			/* channel number */- 		                                                                                                                                                                                                                                                                             R $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              F "                IO$_READPROMPT |		/* function code */y 			IO$M_TIMED |  			IO$M_NOECHO | 			IO$M_PURGE,( 		      &TPIOSB,			/* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */3 		      TPdata,	       		/* buffer for user data */,? 		      TRACONEX_RESPONSE_LENGTH,	/* buffer size of response */37 		      TRACONEX_QIO_TIMEOUT,	/* P3; secs to timeout */t: 		      &term_mask,		/* P4: mask specifying terminators */7 		      traconex_prompt_string,	/* P5; prompt string */r; 		      TRACONEX_PROMPT_LENGTH); /* P6; length of prompt */e       /*      * Record 'after' timestamp       */t"     (void) utc_gettime(afterTime);       if ( !(status & 1) )     {:C 	(void) fprintf(stderr, "M_TRAC: QIO Status failure %x\n", status);          return ( status );     }p     if ( !(TPIOSB.status & 1) )t     {aB         (void) fprintf(stderr, "M_TRAC: IOSB Status failure %x\n", 		       TPIOSB.status);E 	(void) fprintf(stderr, "M_TRAC: Bytes Read: %d\n",TPIOSB.byteCount);;  !         return ( TPIOSB.status );      }k       /*5      * check that we got the correct number of bytes.e#      * Otherwise return hard error.d      */ 6     if (TPIOSB.byteCount != TRACONEX_RESPONSE_LENGTH)      {S? 	(void) fprintf(stderr, "M_TRAC: response length failure %x\n",i 		       TPIOSB.byteCount);d 	return(0);4     }*     /*C      * Now parse the radio clock data to determine the actual time.       */b    &     return(ParseTime(TPtime, TPdata)); }    /*  *++  *  ParseTime()u  *  *  Functional Description:=  *A  *	Convert the radio clock text data string into a numerical utc.   *    *  Inputs:t  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  *    *  Value Returned:r  *#  *	0 - Buffer, parse was successfull  *	-1 - hard Failure. '  *	1 - Temporary failure - Retry later.f  *  *--  */  int ParseTime (utcTime, buffer)) struct utc *utcTime; char   *buffer;t {m!     static char daytab[2][13] = {n5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},i6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;)     struct tm inacc;     unsigned long ins;     unsigned long tns;     int status1, status2;s     int leapyear;e
     int i;       /*%      * Convert and parse status bytesA      */N*     status1 = CVT_ASCII_TO_INT(buffer[0]);*     status2 = CVT_ASCII_TO_INT(buffer[1]);  +     if (status1 & M_TRACONEX_OUT_OF_SPEC) { 7 	(void) printf("dtssprovider: Traconex out of spec\n");* 	return(0);s     }   *     if (status1 & M_TRACONEX_HARD_FAULT) {9 	(void)printf("dtssprovider: Traconex hardware fault\n");I 	return(0);)     }   ,     if (status1 & M_TRACONEX_SIGNAL_FAULT) {8 	(void) printf("dtssprovider: Traconex signal fault\n"); 	return(0);      }_  (     if (!(status1 & M_TRACONEX_AVAIL)) {> 	(void) printf("dtssprovider: Traconex time not available\n"); 	return(0);y     }t  -     if (status1 & M_TRACONEX_YEAR_MISMATCH) { 9 	(void) printf("dtssprovider: Traconex year mismatch\n");i 	return(0);%     }        /*%      * Convert bytes 2 and 3 into ms.o      */iI     tns = (CVT_ASCII_TO_INT_AND_ADD(buffer[2], buffer[3])) * K_NS_PER_MS;r       /*9      * Convert bytes 4, 5 and 6 into secs, mins and hours       */ 0     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[4]);0     timetm.tm_min = CVT_ASCII_TO_INT(buffer[5]);1     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[6]);e       /*+      * Handle 12/24 hour and Military modesi      */r%     if (status2 & M_TRACONEX_12_HR) {r$ 	if (status2 & M_TRACONEX_PM_TIME) {4 	    if (timetm.tm_hour != 12) timetm.tm_hour += 12;	 	} else {*2 	    if (timetm.tm_hour == 12) timetm.tm_hour = 0; 	}     },       /*-      * Convert bytes 7 and 8 into day of yearS      */uD     timetm.tm_yday = CVT_ASCII_TO_INT_AND_ADD(buffer[7], buffer[8]);        /*u3       * Convert byte 9 (offset from 1986) into year        */?     timetm.tm_year = CVT_ASCII_TO_INT(buffer[9]) + 1986 - 1900;*      *     /*%      * Compute month and day of months      */*L     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);f$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];T     timetm.tm_mon = i-1;       /*      * Check valuesn      */N2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||/ 	timetm.tm_hour > 23 ||f 	timetm.tm_yday > 366) {= 	(void) fprintf(stderr, "dtssprovider: radio clock fault\n");(A 	(void) fprintf(stderr, "time returned - %d %d:%02d:%02d.%09d\n",*E                        timetm.tm_yday, timetm.tm_hour, timetm.tm_min,t+                        timetm.tm_sec, tns);0     }P       /*B      * Convert the data returned by radio clock into a struct utc.      * Call the DTSS API      */"5     (void)memset((void *)&inacc,0,sizeof(struct tm));N-     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;.4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;L     return((utc_mkgmtime(utcTime, &timetm, tns, &inacc, ins) == 0) ? 1 : 0);     }n #endif R #ifdef TP_HOPF /*;  **********************************************************(  *		HOPF Specific Routines. ;  **********************************************************t  */o   /*  * HOPF specific constants  */P2 #define M_HOPF_FLAG_STX		2	/* 'STX' header flag */ /*  * HOPF status byte 1_  */SF #define M_HOPF_TIME_RADIO	0x08	/* bit to test for time availability */8 #define M_HOPF_TIME_CLOCK	0x04	/* internal clock mode */0 #define M_HOPF_DST_IND		0x02	/* DST indicator */3 #define M_HOPF_DST_ANN		0x01	/* DST announcement */0 /*  * HOPF status byte 2r  */ 0 #define M_HOPF_UTC_IND		0x08	/* UTC indicator *// #define M_HOPF_WEEK_DAY		0x07	/* day of week */+  M #define HOPF_NOCLOCKSET          (0)     /* allow the clock to be affected */eM #define HOPF_POLL_RATE           (60)    /* sixty seconds between tp polls */*M #define HOPF_TIME_STAMPS         (3)     /* number of time samples to read */ K #define HOPF_INACCURACY          (30)    /* 30ms of inaccuracy default   */-L #define HOPF_TMORATE             (30)	 /* 30 secs to respond to TS request*/  : #define HOPF_PROMPT "g02"	 /* prompt string for TP time */E #define HOPF_RESPONSE_LENGTH 18	 /* max. # of bytes returned by TP */oP #define HOPF_RESPONSE_NUMLEN 15	 /* min # of numerical bytes required from TP */   #define HOPF_QIO_TIMEOUT1   1eD #define HOPF_QIO_TIMEOUT2   2	 /* seconds till read QIO times out */H #define HOPF_RETRIES        5    /* allow 5 retries after a TP failure*/5 #define HOPF_ISVERBOSE	    1    /* generate output */fD #define HOPF_MAXTPERROR     60   /* ignore deltas greater than 60 */D #define HOPF_FIRSTSYNCH     1    /* synch up the first time thru  */ t e /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:t  *A  *  Initialize the default input parameters for the external timea
  *  provider.i  *  *  *    *  Inputs:o  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll rateh7  *    timestamp- int to be set to the default number ofeD  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).*@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not E  *               be affected by the results of the TP synch, false ifaC  *               the clock can be modified by the results of the TP   *               synch.pE  *    retries -  int to be set to the number of times the program is k7  *               allowed to resend a request after the  =  *               external time source has returned a failure. G  *    firstsync- boolean, assume that the time returned by the external/>  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messageso#  *               will be displayed.o  *  *  * *  *  Implicit Outputs:O  *    none.;  *        *  Value Returned:	  *    none.o  *  *  Side Effects:e  *    none.   *  *--  */*- void InitializeTPdefaults(pollrate,timestamp,i 			  inaccuracy,tmorate, 			  clo                                                                                                                                                                                                                                                                           l
N $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              J "            ckSet,retries, 			  firstsynch,maxtperror,e 			  isverbose)u int *pollrate,     *timestamp,r     *inaccuracy,
     *tmorate,t     *clockSet,
     *retries,      *firstsynch,     *maxtperror,     *isverbose;r {h8     *pollrate  = HOPF_POLL_RATE;    /* seconds        */8     *timestamp = HOPF_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= HOPF_INACCURACY;   /* seconds        */8     *tmorate   = HOPF_TMORATE;      /* seconds        */8     *clockSet  = HOPF_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = HOPF_RETRIES;      /* int > 0        */8     *firstsynch= HOPF_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= HOPF_MAXTPERROR;   /* seconds        */:     *isverbose = HOPF_ISVERBOSE;      /* int > 0        */   } ) /* End of routine InitializeTPdefaults */_   /*  *++  *  QueryProvider()   *  *  Functional Description:p  *B  *  This routine issues a single 'g02' command to the HOPF device.?  *  It returns the Binary Absolute Time represented by the HOPF   *  data returned.  *  *    *  Inputs:n  *2  *	ttchan - The active channel to the HOPF device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the HOPF device.   * *  *  Implicit Outputs:'  *  *        *  Value Returned:c  *(  *	0 - Failure - The HOPF device failed.4  *      1 - Success - The HOPF device was contacted.  *  *  Side Effects:f  *  *  *--  */c   int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime)o {      /*9      * passing binary encoded data.  Set terminal char toI%      * eightbit,passall, and pasthru.,      */ (     char HOPFdata[HOPF_RESPONSE_LENGTH];     int  status;     int  retSize;	     int count,i,temp; 0     IOsb  hopfIOSB;		/* status block for HOPF */     struct {long null;) 	    long mask;} term_mask = {0, 0x0008};    			        /*k0    				 * now a structure to set the terminator $ 				 * character 'ETX' for the read.
    				 */       /*H      * First, post a qiow read to the HOPF with a timeout first to purge2      * the input buffer of any residue characters.      */i  +     status = SYS$QIOW(0,			/* event flag */d& 		      ttchan,			/* channel number */+ 		      IO$_READVBLK |		/* function code */u 			IO$M_TIMED |  			IO$M_PURGE,0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPFdata,	       		/* buffer for user data */I; 		      HOPF_RESPONSE_LENGTH,	/* buffer size of response */k4 		      HOPF_QIO_TIMEOUT1,	/* P3; secs to timeout */2 		      0,			/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */R) 		      0);		 	/* P6; length of prompt */p       /*-      * Next, get the internal UTC time first.	      */I  %     (void) utc_gettime( beforeTime );        /*>      * Now, post a qiow write to the HOPF to ask for UTC time.      */b  +     status = SYS$QIOW(0,			/* event flag */ & 		      ttchan,			/* channel number */+ 		      IO$_WRITEVBLK,		/* function code */e0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPF_PROMPT,     		/* buffer for user data */y: 		      strlen(HOPF_PROMPT),	/* buffer size of response */& 		      0,			/* P3; secs to timeout */2 		      0,			/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */f) 		      0); 			/* P6; length of prompt */t       /*E      * Now, post a qiow read to the HOPF with a timeout and a special,      * terminator of "ETX".3      */,  +     status = SYS$QIOW(0,			/* event flag */t& 		      ttchan,			/* channel number */+ 		      IO$_READVBLK |		/* function code */  			IO$M_TIMED,0 		      &hopfIOSB,	        /* io status block */ 		      0,			/* ast entry */  		      0,			/* ast parameter */5 		      HOPFdata,	       		/* buffer for user data */_; 		      HOPF_RESPONSE_LENGTH,	/* buffer size of response */C4 		      HOPF_QIO_TIMEOUT2,	/* P3; secs to timeout */: 		      &term_mask,		/* P4: mask specifying terminators */% 		      0,	 		/* P5; prompt string */o) 		      0);		 	/* P6; length of prompt */r       /**      * Now get the internal UTC time last.      */   $     (void) utc_gettime( afterTime );       /*H      * Now do the various checks to ensure that we have a valid UTC time%      * string from the HOPF receiver.t      */v       if ( !(status & 1) )     { C 	(void) fprintf(stderr, "M_HOPF: QIO Status failure %x\n", status);s         return ( status );     })  !     if ( !(hopfIOSB.status & 1) )      {nB         (void) fprintf(stderr, "M_HOPF: IOSB Status failure %x\n", 		       hopfIOSB.status);#         return ( hopfIOSB.status );C     }b       /*     *  First check for 'STX'     */  *     if ( HOPFdata[0] != M_HOPF_FLAG_STX )      {;A 	(void) fprintf(stderr, "M_HOPF: Missing STX %s\n", HOPFdata[0]);o         return ( 0 );u       }e       /*E      * Now search for the 'LF' which terminates the numerical string.s      */C  (     for (i=0; i< hopfIOSB.byteCount;i++)     {{ 	if (HOPFdata[i] == '\n' )
 		count = i ;h     }1       /*D      * Check the position of 'LF' to ensure that we got the correct       * number of bytes.b      */d  '     if (count != HOPF_RESPONSE_NUMLEN) t     {== 	(void) fprintf(stderr, "M_HOPF: string length failure %x\n",  		       count); 	return(0);o     }        /*3      * Now convert status bytes for various checks.f      */1        temp = (HOPFdata[1] - '0' );       if ( HOPFdata[1] > '9' )       {*& 	    temp = (HOPFdata[1] - 'A' ) + 10;     }(       HOPFdata[1] = temp ;        temp = (HOPFdata[2] - '0' );       if ( HOPFdata[2] > '9' ) =     {.& 	    temp = (HOPFdata[2] - 'A' ) + 10;     }[       HOPFdata[2] = temp ;       /*5      * Check that we got the correct number of bytes. #      * Otherwise return hard error.       */e  3     if (hopfIOSB.byteCount < HOPF_RESPONSE_NUMLEN) t     { ? 	(void) fprintf(stderr, "M_HOPF: response length failure %x\n",d 		       hopfIOSB.byteCount);: 	return(0);f     })       /*F      * Check all the status bits, make sure this time is truely valid.      */        /* m4      * First check, if receiver gets radio datagram.      */t  .     if ( !(HOPFdata[1] & M_HOPF_TIME_RADIO) )      {e@ 	(void) fprintf(stderr, "M_HOPF: radio time not Available %x\n", 		       HOPFdata[1]); 	return(0);(     }&       /* e/      * Now check, if internal clock is running.       */S  -     if ( !(HOPFdata[1] & M_HOPF_TIME_CLOCK) )S     {;> 	(void) fprintf(stderr, "M_HOPF: no internal clock time %x\n", 		       HOPFdata[1]); 	return(0);i     }_       /* *%      * Now check, if we got UTC time.*      */*  *     if ( !(HOPFdata[2] & M_HOPF_UTC_IND) )     {*3 	(void) fprintf(stderr, "M_HOPF: no UTC time %x\n",  		       HOPFdata[2]); 	return(0);P     }n         /*(      * Now convert the data to integers.      */s  *      for ( i=3;i<HOPF_RESPONSE_NUMLEN;i++)      { 	temp = HOPFdata[i] - '0' ;  	HOPFdata[i] = temp ;_      }       /*=      * Convert the data returned by the HOPF into struct utc.o      */f  -     return(CvtHOPFtoUTC( HOPFdata, TPtime ));    }*     /*  *++  *  CvtHOPFtoUTC()  *  *  Functional Description:a  *F  * This routine converts the response string of the HOPF 'g02' command%  * into a Binary Absolute Time value.l  *  *  *    *  Inputs:f  *&  *	TPdata - The 'g02' response string.  *  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *$  *	TPtime - The converted utc value.  *  *  Implicit Outputs:R  *    *	None.  *        *  Value Returned:u  * *  *	None.  *  *  Side Effects:   * 0  *	None.  *  *--  */t" CvtHOPFtoUTC( HOPFdata, HOPFtime ) char *HOPFdata;t struct utc *HOPFtime;    {n    long		tns,ins;G    struct tm	time, inacc;e       /* P(      * Convert bytes 3 and 4 into hours.      */n  3     time.tm_hour = 10 * HOPFdata[3] + HOPFdata[4] ;T       /* e*      * Convert bytes 5 and 6 into minutes.      */   2     time.tm_min = 10 * HOPFdata[5] + HOPFdata[6] ;       /* r*      * Convert bytes 7 and 8 into seconds.      */1  2     time.tm_sec = 10 * HOPFdata[7] + HOPFdata[8] ;       /* g0      * Convert bytes 9 and 10 into day of month.      */   4     time.tm_mday = 10 * HOPFdata[9] + HOPFdata[10] ;         /* a2      * Convert bytes 11 and 12 into month of year.      */n  4     time.tm_mon = 10 * HOPFdata[11] + HOPFdata[12] ;       /* r      * Adjust month (0 - 11).       */        time.tm_mon -= 1;         /*  1      * Convert bytes 13 and 14 into year - 1900 .o      */   5     time.tm_year = 10 * HOPFdata[13] + HOP                                                                                                                                                                                                                                                   
                        H& $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              P "            Fdata[14] ;        /*!      * Now get day of week first.e      */i  5     time.tm_wday = ( HOPFdata[2] & M_HOPF_WEEK_DAY );l       /*      * Now get DST indicator.t      */e  5     time.tm_isdst = ( HOPFdata[1] & M_HOPF_DST_IND );e       /*  /      * Now convert month and day into yearday. e      */n  F     YearDay (time.tm_year, time.tm_mon, time.tm_mday, &time.tm_yday );       /*      * Get the inaccuracyi      */t  -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;d     inacc.tm_min = 0;T     inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;u4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;     tns = 0;       /*     * Now get UTC time     */   8     if (utc_mkgmtime(HOPFtime, &time, tns, &inacc, ins))     	return(0);e     else     	return(1);u      }i! /* End of routine CvtHOPFtoUTC */s   t /*  *++
  *  YearDay()t  *  *  Functional Description:o  *B  *  This routine converts the current year, and the current day ofC  *  the current month into the day of the year ( ie 174th of 1989 )r&  *  to be stored in the time string.    *  *    *  Inputs:a  * c-  *	currYear - The current year as an integer.o-  *	currMonth - The numerical month ( 0 - 11 )e1  *	dayInMonth   - The day in the month ( 1 - 31 )   *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *)  *	yearDay - The current day in the year.   * n  *  Implicit Outputs:   *	i  *	None.  *  *  Value Returned:-  *  *	None.  *  *  Side Effects:l  *  *	None.  *  *--  */r1 YearDay(currYear, currMonth, dayInMonth, yearDay)c* int	currYear;				/* current year - 1900 */% int	currMonth;				/* current month */,% int	dayInMonth;				/* day of month */r) int	*yearDay;				/* ptr to day of year */, {      /*3    * table to convert month and day to day of year.c    */      int dayTab [2] [13] = {_5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},P6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};     int	i, leap;    1 	leap = (currYear%4 == 0 && currYear%100 != 0) || '                (currYear+300)%400 == 0;H   	for (i=1; i < currMonth; i++)" 	    *yearDay += dayTab[leap] [i];   	*yearDay += dayInMonth ;  }m     #endif /* TP_HOPF */   * #ifdef TP_NULL /*;  **********************************************************   *		NULL TP Specific Routines. P  *;  *   The null time provider is an uncompleted time providerl9  *   that uses the NOCLOCKSET function.  NOCLOCKSET beingc8  *   set to 1, instructs the time service to ignore the :  *   the time which the tp program returns, but to include5  *   set the system inaccuracy to the returned value.t8  *   This is useful if the system is being controlled by;  *   a time service other than DTSS, or if the system clockH=  *   is being controlled at the hardware level by an accuratea>  *   clock.  In either case, the system clock is not affected.  *;  **********************************************************E  */s  N #define NULL_NOCLOCKSET          (1)     /* allow only inacc to be affected */N #define NULL_POLL_RATE           (60)    /* sixty seconds between tp polls  */N #define NULL_TIME_STAMPS         (3)     /* number of time samples to read  */N #define NULL_INACCURACY          (30)    /* 30ms of inaccuracy default      */L #define NULL_TMORATE             (30)	 /* 30 secs to respond to TS request*/N #define NULL_RETRIES             (1)     /* allow 1 retries                 */6 #define NULL_ISVERBOSE		 (1)     /* generate output */L #define NULL_MAXTPERROR          (60)    /* ignore deltas greater than 60 */L #define NULL_FIRSTSYNCH          (1)     /* synch up the first time thru  */ i /*  *++  *  InitializeTPdefaults()  *  *  Functional Description:.  *A  *  Initialize the default input parameters for the external timeh
  *  provider.l  *  *  *    *  Inputs:D  *  Implicit Inputs:  *  *  *  Outputs:  *7  *    pollrate - int to be set to the default poll ratel7  *    timestamp- int to be set to the default number of D  *               timestamps to read from the external time provider.@  *    inaccuracy-int to be set to the default inaccuracy for the;  *               external time provider (systematic error).	@  *    tmorate   -int to be set to the default time-out rate (the@  *               number of seconds the dtss server must wait for$  *               the data response).E  *    clockset - int to be set to true if the system clock should not*E  *               be affected by the results of the TP synch, false if*C  *               the clock can be modified by the results of the TP	  *               synch. E  *    retries -  int to be set to the number of times the program is  7  *               allowed to resend a request after the  =  *               external time source has returned a failure.fG  *    firstsync- boolean, assume that the time returned by the external >  *               clock is correct on the first synchronizationB  *    maxtperror-if the difference between the local clock and theC  *               time provider differs by more than maxtperror, the 2  *               external clock is assumed faulty.2  *               local clock and the time providerC  *    isverbose -boolean, > 0 indicates that informational messagesn#  *               will be displayed.	  *  * o  *  Implicit Outputs:E  *    none.h  *        *  Value Returned:l  *    none.   *  *  Side Effects:   *    none./  *  *--  */ - void InitializeTPdefaults(pollrate,timestamp,e 			  inaccuracy,tmorate, 			  clockSet,retries, 			  firstsynch,maxtperror,  			  isverbose)T int *pollrate,     *timestamp,      *inaccuracy,
     *tmorate,i     *clockSet,
     *retries,,     *firstsynch,     *maxtperror,     *isverbose;e {h8     *pollrate  = NULL_POLL_RATE;    /* seconds        */8     *timestamp = NULL_TIME_STAMPS;  /* int, 1-6       */8     *inaccuracy= NULL_INACCURACY;   /* milliseconds   */8     *tmorate   = NULL_TMORATE;      /* seconds        */8     *clockSet  = NULL_NOCLOCKSET;   /* int, t/f - 1/0 */8     *retries   = NULL_RETRIES;      /* int > 0        */8     *firstsynch= NULL_FIRSTSYNCH;   /* int > 0        */8     *maxtperror= NULL_MAXTPERROR;   /* seconds        */:     *isverbose = NULL_ISVERBOSE;      /* int > 0        */ }.) /* End of routine InitializeTPdefaults */)   /*  *++  *  QueryProvider()c  *  *  Functional Description:(  *"  *     Return the inaccuracy only.  *  *    *  Inputs:e  *2  *	ttchan - The active channel to the HOPF device.  *  *  Implicit Inputs:  *  *	None.  *  *  Outputs:  *1  *	TPtime - The Time returned by the HOPF device.*  *    *  Implicit Outputs:S  *  *        *  Value Returned:d  *(  *	0 - Failure - The HOPF device failed.4  *      1 - Success - The HOPF device was contacted.  *  *  Side Effects:   *  *  *--  */s int D QueryProvider(int ttchan, struct utc *TPtime,struct utc *beforeTime,C                                              struct utc *afterTime); {r long ins,inst,tns; struct tm inacc,inacctm,timetm;u       /*D      *  Depending upon the clock implementation, the time and/or theG      *  inaccuracy could also be read from the time device using RS232 1H      *  for example. In that case, the radio time provider examples may        *  provide useful examples.C      *  In the following example, the inaccuracy as defined by the aC      *  user inaccuracy value is converted and returned to the time @      *  server.  Since the noclockset bit was set to one in the @      *  initialization routine, the actual time is ignored, but 8      *  the system inaccuracy is nonmonotonically set by@      *  the server to the value returned in the inacc tm struct.      */k     /**      * Get the inaccuracy into a tm struct      */ -     inacc.tm_sec = INACCURACY / K_MS_PER_SEC;i"     inacc.tm_min = 0;                  inacc.tm_hour = 0;     inacc.tm_yday = 0;     inacc.tm_isdst = 0;(4     ins = (INACCURACY % K_MS_PER_SEC) * K_NS_PER_MS;  "     (void)utc_gettime(beforeTime);:     (void)utc_localtime(NULL,&timetm,&tns,&inacctm,&inst);7     (void)utc_mklocaltime(TPtime,&timetm,0,&inacc,ins);O!     (void)utc_gettime(afterTime);e       return;  }e #endif  /* TP_NULL */        #ifndef VMS]   /*  *++  *  ParseTime()   *  *  Functional Description:   *A  *	Convert the radio clock text data string into a numerical utc.   *    *  Inputs:(  *(  *	buffer - the radio clock data string.  *  *  Outputs:  *&  *	utcTime - utc returned by the parse  * t  *  Value Returned:.  *#  *	0 - Buffer, parse was successfulN  *	-1 - hard Failure. '  *	1 - Temporary failure - Retry later.]  *  *--  */  int  ParseTime (utcTime, buffer)t utc_t *utcTime;  char   *buffer                                                                                                                                                                                                                                                                           6j $      DCEAXPMUPA013.A                3  >  .[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER.C;2                                                                                 S                              9             ;u {o!     static char daytab[2][13] = {T5 	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},H6 	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};          struct tm timetm;s     unsigned long ins;     unsigned long tns;     char status;     int leapyear;*
     int i;       /*      * Copy base inaccuracye      */      ins = INACC;       /*%      * Convert and parse status bytes*      */      status = buffer[2];        if (status == '*') { 	BEGIN_NONREENTRANT  	(void) fprintf(stderr, K                   "dtsprovider: Spectracom manually set, ignoring time\n");P 	END_NONREENTRANTO 	return(1);r     }a       if (status == '?') { 	BEGIN_NONREENTRANTiE 	(void) fprintf(stderr, "dtsprovider: Spectracom has lost signal\n");d 	END_NONREENTRANT      }        /*%      * Check clock qualtity indicator       */        if (buffer[3] == 'A')a4 	ins += 9 * K_NS_PER_MS;		/* Add additional 9 ms. */     else if (buffer[3] == 'B')5 	ins += 99 * K_NS_PER_MS;	/* Add additional 99 ms. */      else if (buffer[3] == 'C')7 	ins += 499 * K_NS_PER_MS;	/* Add additional 499 ms. */b     else if (buffer[3] == 'D')% 	return(1);			/* Clock too far out */O       if (buffer[3] == '$') {  	BEGIN_NONREENTRANTe 	(void) fprintf(stderr,oA 		       "dtsprovider: Spectracom year incorrect in switches\n");F 	END_NONREENTRANT*     }   5     if ((buffer[0] != '\015' || buffer[1] != '\n') ||=L         (buffer[13] != ':') || (buffer[16] != ':') || (buffer[19] != '.')) { 	BEGIN_NONREENTRANTr< 	(void) fprintf(stderr, "dtsprovider: radio clock fault\n");: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	END_NONREENTRANTE 	return(1);      }        /*I      * Convert bytes 4 and 5 into year. If the result is before 1990, theF%      * century most have rolled over.n      */h  7     timetm.tm_year = CVT_ASCII_TO_INT(buffer[4]) * 10 +y# 		     CVT_ASCII_TO_INT(buffer[5]);.     if (timetm.tm_year < 90) 	timetm.tm_year += 100;*       /*0      * Convert bytes 7, 8 and 9 into day of year      */n8     timetm.tm_yday = CVT_ASCII_TO_INT(buffer[7]) * 100 +) 		     CVT_ASCII_TO_INT(buffer[8]) * 10 +C# 		     CVT_ASCII_TO_INT(buffer[9]);        /*)      * Convert bytes 11 and 12 into hours       */(8     timetm.tm_hour = CVT_ASCII_TO_INT(buffer[11]) * 10 +$ 		     CVT_ASCII_TO_INT(buffer[12]);       /*+      * Convert bytes 14 and 15 into minutes       */ 7     timetm.tm_min = CVT_ASCII_TO_INT(buffer[14]) * 10 +s# 		    CVT_ASCII_TO_INT(buffer[15]);n       /*+      * Convert bytes 15 and 16 into secondsy      */e7     timetm.tm_sec = CVT_ASCII_TO_INT(buffer[17]) * 10 +r# 		    CVT_ASCII_TO_INT(buffer[18]);        /*3      * Convert bytes 20, 21 and 22 into nanosecondsT      */c/     tns = (CVT_ASCII_TO_INT(buffer[20]) * 100 +n' 	   CVT_ASCII_TO_INT(buffer[21]) * 10 +I0 	   CVT_ASCII_TO_INT(buffer[22])) * K_NS_PER_MS;       /*%      * Compute month and day of monthm      */tL     leapyear = ((timetm.tm_year % 4 == 0) && (timetm.tm_year % 100 != 0)) ||+                (timetm.tm_year % 400 == 0);a$     timetm.tm_mday = timetm.tm_yday;8     for (i=1; timetm.tm_mday > daytab[leapyear][i]; i++)' 	timetm.tm_mday -= daytab[leapyear][i];I     timetm.tm_mon = i-1;       /*      * Check valueso      */e2     if (timetm.tm_sec > 60 ||			/* Leap seconds */         timetm.tm_min > 59 ||  	timetm.tm_hour > 23 ||_ 	timetm.tm_yday > 366) { 	BEGIN_NONREENTRANT3< 	(void) fprintf(stderr, "dtsprovider: radio clock fault\n");: 	(void) fprintf(stderr, "time returned - %26s\n", buffer); 	END_NONREENTRANT  	return(1);(     }r       /*=      * Convert the data returned by radio clock into a utc_t.a      * Call the UTC API       */o@     return(utc_mkgmtime(utcTime, &timetm, tns, &INACC_TM, ins));   }* #endif    * /*;  **********************************************************i  *		Debugging  Routines.;  **********************************************************s  */N /*  *++  *  PrintTimes()  *  *  Functional Description:c  *4  *	Print out the contents of a time response message  *    *  Inputs:s  *9  *	timeResponse - the time response message to print out.d  *  *  Outputs:  *  *	None.  * s  *  Value Returned:l  *  *	None.  *  *--  */t void PrintTimes(timeResponse)  TPtimeMsg  *timeResponse;o {d     int  i;a  .     if (timeResponse->status == K_TPI_FAILURE)     {e" 	(void) printf("K_TPI_FAILURE\n");F         (void) printf("******************************************\n"); 	return;     }K  %     (void) printf("K_TPI_SUCCESS\n");t)     (void) printf("Time Stamps   : %d\n", " 		  timeResponse->timeStampCount);6     for (i = 0; i < timeResponse->timeStampCount; i++)     {u! 	(void) printf("Before Time\t:");d6 	PrintISO(&timeResponse->timeStampList[i].beforeTime);! 	(void) printf("\nTP Time\t\t:");T2 	PrintISO(&timeResponse->timeStampList[i].TPtime);" 	(void) printf("\nAfter Time\t:");5 	PrintISO(&timeResponse->timeStampList[i].afterTime);  	(void) printf("\n\n");(     }/B     (void) printf("******************************************\n"); }e l /*  *++  *  PrintISO()  *  *  Functional Description:)  *8  *	Print out a binary absolute time as an LOCAL ISO time  *    *  Inputs:)  *$  *	utcTime - the address of a utc_t.  *  *  Outputs:  *  *	None.  * t  *  Value Returned:t  *  *	None.  *  *--  */  void PrintISO(utcTime) utc_t *utcTime;  {      char	gmTimeStr[50];   A     (void) utc_ascgmtime (gmTimeStr, sizeof(gmTimeStr), utcTime);-     printf ("%s\t", gmTimeStr);b }o   * /*  *++  *  PrintValidationError()  *  *  Functional Description:   *;  *      The timeprovider is returning invalid times, report   *      to the user.  *    *  Inputs:e  *
  *      None.   *  *  Implicit Inputs:  *  *	SYNCHCOUNT,MAXTPERROR.t  *  *  Outputs:  *  *	None.  * s  *  Implicit Outputs:a  *  *        *  Value Returned:e  *	  * 	None.   *  *  Side Effects:t  *
  *      None.t  *  *--  */ - PrintValidationError(systemTime,externalTime)t struct utc *systemTime;i struct utc *externalTime;o {c char timestr[UTC_MAX_STR_LEN];  S     fprintf(stderr,"\n!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!\n");e;     fprintf(stderr,"The external time did not validate\n");e=     fprintf(stderr,"Synchronization Count: %u\n",SYNCHCOUNT);n=     fprintf(stderr,"Error Tolerance:       %u\n",MAXTPERROR);r6     utc_ascgmtime(timestr,UTC_MAX_STR_LEN,systemTime);:     fprintf(stderr,"System Time:           %s\n",timestr);8     utc_ascgmtime(timestr,UTC_MAX_STR_LEN,externalTime);:     fprintf(stderr,"External Device Time:  %s\n",timestr);-     fprintf(stderr,"\n!!!!!!!!!!!!!!!!!!\n");*      }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_BUILD.COM;2 +  , d	8   .     /  @   4 J                           - >    0   1    2   3      K  P   W   O     5   6 e5؊  7 hE   8          9          G  @  H   J                          $!4 $! This DCL Command Procedure will compile and link & $! the DCE/DTS Time Provider examples. $!( $! Derermine compiler and linker options $! $ @DCE:DCE$CC_TEST $ cc := cc'f$trnlnm("dce$cc")' $!  $ $ If( f$trnlnm("dce$cc") .eqs. " " )J $ Then  options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options"' $ Else  options = "dce:dce.opt/options"  $ Endif  $!& $ if F$Edit(P1,"upcase") .eqs. "DEBUG" $ then	  $    debug = "/debug"  $    list  = "/list" $    opt   = "/NOopt"  $ else $    debug = ""  $    list  = ""  $    opt   = "" / $    write sys$output "P1 default - NOdebug..."  $ endif  $! $ prename := DCE$DTS_PROVIDER  $! $ name   = "NULL" 
 $ gosub build  $ name   = "SPEC" 
 $ gosub build  $ name   = "TRAC" 
 $ gosub build  $ name   = "PSTI" 
 $ gosub build  $ name   = "HOPF" 
 $ gosub build  $ name   = "GC1000" 
 $ gosub build  $ exit $ !  $ build:2 $ write sys$output " ** Compile ''name' Provider "6 $ cc 'debug 'list 'opt 'standard /OBJ='prename'_'name-1         /G_FLO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          k $      DCEAXPMUPA013.A                d	8  >  6[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_BUILD.COM;2                                                                         J                              z             AT/DEFINE=(TP_'name'=1) 'prename'.c  $ ! / $ write sys$output " ** Link ''name' Provider " 4 $ link'debug'/exe='prename'_'name 'prename'_'name, --              dce:dtsprovider_sstub, 'options'  $ return $ !                                                                                                                                                                                                                                                                                                                            7 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;2 +  , 9   . L    /  @   4     L   K                     - >    0   1    2   3      K  P   W   O M    5   6 PS  7 _   8          9          G  @  H   J                               L    h                                                  (   ~              0       P                                                                         0 DCE$DTS_PROVIDER_GC1000                DCE V1.3-950305T10-58               $             
               $             
               $    <                         $    .            1             $                             $             J   H             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0          0                                           `              0     X                     
                          0     (     0                                                                                                            `     P                                               
     p
                   0          P                                    0
     &              '              `
     0         @      <               @                                  
      
     
     
     
      
              0(         `      |       @
                                                                     P
     0                                                                             @      
                                 `      0         P                                    @                                          @              
                                                         0     0     0                            0H     &            <       @                     0@     p&     `              0     $            |       0     x"                                                                       08     (     p       <                                             0                                  0              0(          @              p                                           0     0     `             0          0              0              0          @              0          0              0     @(     0              P              9                            0     9     `                            P       0     09     `                                    0     8     `                            0     8     0              `              0     7     0                            0     7     0              P              0     6     0              @              0      6     `              0     5     0                            0     5     0                            0     4     0                            0      4     0                            0     p3     `              0     2     0              @              0     p2     0                             0     1     0                            0     X1     @                            0     0     0                            0     H0     0                            0     /     0              p              0      /     @              `              0     .     0              P              0     .     0              @              0     x-     `              0     ,     0                             0     `,     0                            0     *     0                           0     @*     0                             0     )     0                            0     @)     0                            0     (     0               :                                                                                                                                                                                                                                                                                                                                                               p TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d                      

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
        -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      M_GC1000: QIO Status failure %x
        M_GC1000: IOSB Status failure %x
       M_GC1000: response length failure %x
   M_GC1000: time/date string format invalid
      M_GC1000: time/date field format invalid
       %d:%d:%d.%d %d/%d/%d    M_GC1000: time/date field conver                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $      DCEAXPMUPA013.A                9  >  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;2                                                                             L                         GK "            sion failed
    K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                                                                                                                                                                                                                                                                         H                                   0                         x                x                        <                                                                                                 `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @pB4GxbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  0B8bVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @(¤ 0B 8b  GwZk4GGG0B0 &"  8bwZk4G4G0B8bxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZkH  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ b@¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "BGF Hb( <GGgBZk }
  PB( ="@#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~tG^^ ~޴ (0>8@GGGGGb#@¤    $h  %4G  X `⤸8"  G     '  (  )_ 8	  XBWZk  b#@pb#@ G   GGb#@ bTG(Bc 0b  GvZktG(B #"  0b8BvZktG(B  ( #"  F0bvZktG(BH #"    D0bvZktG(B  h #"  E0bvZktG(B #"    H0bvZktG   (B   D0b #"GvZktG  )  ( (B   #"%E0bGzvZk $`   GH BP bG~Zk?"G LH BP b(AG~Zk &@B"I@'WHi)A)@)	A  & 4M / . " 5"XKWJ ?  > ! 5,p E ,pFA5H 5<DH <   u. U.SqJRQJ q>  Q> , u/GH[uK < u?     BGG"Gb}ZkG  BbZk4GB "bZkGBbZk4G(B< 0bUZkh B@ "p b< ="TGbZkG8 BC"b@ ="  < }"{lZktG< P="  ( B0 b, ]"%FZkGBbcZkG(B#"  C"0bP}"uZkGBbeZk4G4G(B0bTZkB< ="b4GTG\uZktG< ="  ( B( ]"0 bFZkGBb@ZkG(B  @#"0bPC"}"uZkGBbBZk4G4G(B0bTZkB4 "b< ="TGKsZktG<   ( B0 b="$ ]"EZkGBbZkG(B  #"0bC"}"uZkGBbZk4G4G(B0bTZk8G  f BbZkTGB4 "b< ="!sZktG<   ( Bp="0 b  ]"EZkGBb~ZkG(B#"  C"0bp}"uZkGBb~Zk4G4G(B0bhTZk4   C8  	GG4 ݠ =" B< ]" btG@ SZktG< ="  ( B0 b ]"EZkGBb~ZkG(B#"  C"0b}"cuZkGBb~Zk< ݠ#"  tG (B ]0bVuZkB "b< ="TG>JZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGbZktG< 0="  ( B0 b ]"OEZkGBb~ZkG(B0#"  @C"0b0}")uZkGBb~Zk4G4G(B0bTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"uZktG8 =" ]"  ( B0 b%EZkGBbc~ZkG(Bh#"  xC"0b}"tZkGBbe~Zk4G4G(B0bSZkB< "0 4GbGGG=]ZktG<   ( B ="0 b ]"DZkGBb=~ZkG(B#"  C"0b }"tZkGBb?~Zk4G4G(B0bSZk  G
 Bb&~ZkTG(B  #"0btZkGBb*~Zk B< =" b4GTGsZktG< P =" ]"  ( B0 bDZkGBb
~ZkG(B  #"0bC"P }"tZkGBb~Zk4G4G(B0bSZkG]] 4G }ݤ (0=8@P#kq Ep E  &vHpFI7IB	6E Ƣ  &HVJF ƲA?qFpF  yHDH BD !  HY0K$G !4G# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]":UZk  BGb4G.SZk(""  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]@G     Bb}ZkTG ("0B   8b01"tZkGBb}Zk 4GB    p   R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]G`    BbP}ZkTG@H"PB   XbP1"sZkGBbR}ZkG"b#    #     1y@G@     Bb3}Zk4GHBb"7uZkGhb#~@BGb4}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  BbPHJ
dZk&u@7@ \@8  k0@	@  b#@4G  B4G( brRZkF@B0BtG  ¤b@ G0MZk 8 D  "X&" BTG(b  }sZk 0@	@ b#@4G  B4G( bTRZkF@BbtG  ¤` BH GMZk 8 D  "x&" BTG(b  _sZk 0@	@ b#@4G  B4G( b6RZkF@BtG  ¤P bGGLZk"  Ơ 8 D"@@D8 F0Dx   B  '"(bTG9sZkj 0@	@ b#@4G  B4G( bRZkG@8 ¤BtG  bGX GLZk'"  Ơ 8 D"S@@D8 F0DR   B  '"(bTGsZkD 0@	@ b#e@4G  B4G( bQZkG@¤BtG  bG` GLZk  Ơ 8 D'"@@  D8D&D+  BTG(brZk G0@	@ b#?@4G  B4G( bQZk0 ¤G@@ B  'GzZk"G@ B zZkP BGb{Zk  y H8JG  ! b#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G
tZk ?"tG  8 B "@ b  DHZktGB#"b "BBLZkTG( B  "0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "G-LZk? TG  H #"ӣ@@  8DD BburZk4G4GBbRQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "GLZk'? TG   #"S@@  8DD BbMrZk4G4GBb*QZkx "( BTG0 b  %sZk ?"tG8 B  D "@ b\HZktGBb #" "GKZkTG   #"@נ@8DD
 "Bb  &rZk4G4GBbQZk"( BTG0 b  %sZk ?"tG8 B  D "@ b5HZktGBb#" "GKZkTG@"( B0 b  %ksZk ?"tG8 B "  D@ b HZktGB#"b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  Bb7{Zk4GxBb"zZkG Bb;{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bzZkG@ BH b{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 b|qZkGtG0 B$"  8 buqZkGtG0 B                                                                                                                                                                                                                                                                           [ $      DCEAXPMUPA013.A                9  >  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;2                                                                             L                          "     !          $"8 bnqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~  ( 0 ޴8 @ H >P ^X GGCG(  GGTGG @Q?Bq1B@ !( 1! Q"GGG0b#\ @GG
G @b#_GG
G @`b#~@ @0@GA G	GA  &1@G ] ] G }  ( 0 ݤ8 @ H =P ]X ` #kG#  ( ;G  ~G ^G0 [ 8 {GxZkG ]   #k#0v J  ~4G ^( [ G0 {:yZkG ]   #kG  G >G ޢ  tG    4G    G         k#4G  ~8 ^@ ^H ~P X ` GG#  BG( bG0 =GJZkGhb }"B = c  "[yZkG_"G  >G0 BG >tG >G   ~8 b( OxZk4G  BG( bGmJZk
 `p#"pBGxbtG  pZk G  !vH
  `pB#"xb C  tGpZk %vH vH GRH CBF  `#"tG   G , "$ ]" ]# HD  =,@  0H  F  $ =. 2JEF @! }.! " tJF  . JF  . # =/ J :KXGXGGG @ }/  [dKgKG@  ;, ;H`G{ ` .  P JJF@  0. 0J " Fp   ]. }"SSJgJF@  . JFf  . "VJJF@  . JF\  =/ #Y8K'K?G@  Y/ YK@GR @ ,DHHD@  d/ dK$  `GH ` ,PHJF@  0. 0J& " F>   ].S]JgJF@  . JF5   .! "VJJF@  . JF+ " /# =#YK'K?G@  Y/ YK@G! @# =,D$HHD@  d/ dK`G `% ,PHJF@  0. 0J " F  & ].' }"0 =SSJgJF@  . JF b# @ `	#"   `#"  TGpBxboZk GG8 ]@ ]H }P X ` p #kG#4G  ~ ^ ^ ~ GG#b  B ]" = ="  >c   =" > }"b " "GcIZk   	  "B #"bTG  oZk GV b?"Bb  cGxZk &@B" ?' T@5WH =tB( B5B0 bX B5u@ N7JxC8B@B9#!1 @ = "  =" x }" x |     OGG ]SZk   G( X 4GT n_&P = 6R"h  "\ P ="` ( }"d Gl Gp 0 , ( 8 B@ 4 8 < D @ bH ;VZk   G H B ="  ]"P btG1WZk@G ] ] }  #kG#4G  ~ ^ ^ ~   ޴ GGG    XB( `bGpZk "T G4GXB`bh GpZkTGXB " #`bpZk CB    GXB( "`b4GpZkTGtGBbG "HaZkTGXB`bH" ="zpZk4GXB`b8 "upZkTGtGBb E"@ "6aZkTGXB`bH"@ ="hpZk4GXB`bH "cpZkTGtGBb  E"x "$aZkTGXB`bH"x ="VpZk4GXB`b@"QpZk 0@0  @X "XB4G`bGpZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb`ZkTG xB ="b"'pZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =8G0@B Hb  GnZkTG@B@ %"  HbnZktG0 "h %"@B    AHbnZktG" %"@B    AHbnZkTGtG  B( b "G`ZktG@B   %"Hb ]"nZkTGtG  B@ ] "( b`ZktG@B   %"Hb ]"snZkTG@B %"  HbmnZkGH ]P ]X }` h p  #k        #G  ~ ^ ^ ~  GGG  B( b|Zk4G0 BG8 btCZkG@ BH bG#|ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXb{Zk4G  BG( bDZkGpBxbG|ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( b
AZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( blZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb ={ZkTG  B =G( bWZkG BbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBb|{Zk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4GwZkG0BG8bX{ZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D   4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]{ZktG  BG = ]( bfCZkG`BhbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =zZkTG  B =G( bVtZkGBbGzZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBbzZktGPB8  0  @8 =XbGSoZkGBb zZk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( b8FZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( bIZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }dzZkG  B =G ] }( bKZkG@BHbGezZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]?zZktG  BG = ]( bsZkGpBxbGAzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]zZktG  BG = ]( bZzZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b~ZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }yZkG  B =G ] }( bhAZkG BbGyZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b2@ZkG0B8bGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHbyZk4G  BG( bCZkG`BhbGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbsyZk4G  BG( bTXZkGBbGwyZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBbPyZkTG B0  0  @(bG:oZkGBb QyZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBb/yZk4G  BG( bKZkGBbG3yZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =yZkTG  B =G( b>OZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(bxZk4G  BG( bBZkG@BHbxZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =xZkTG  B =G( biZkGpBxbxZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxbxZktGB8  0  @8 =bGaoZkGBb xZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbxZkG  B( b&pZkGBbGxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBbkxZk4G  BG( b&pZkGBbGoxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG BbKxZk4G  BG( b YZkG B(bGOxZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =*xZkTG  B =G( b~PZkGPB#HXbgH,xZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`BhbxZktG  B8  0  @8 =( bGlZkGBb xZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBbwZkTG( B0  0  @0 bGmZkGBb wZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbwZktG  B8  0  @8 =( bGqnZkGBb wZk G ] ]  ` #k                                                                                                                                                                                                                                                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P                                                                                                                                                                                                                                                                                 ot! $      DCEAXPMUPA013.A                9  >  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;2                                                                             L                         ~8 "     2         ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE                                                                                                                                                                                                                                                                           .j $      DCEAXPMUPA013.A                9  >  7[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_GC1000.EXE;2                                                                             L                               C       4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                     T               T       |          	                              (                       0                    0  @  P  p              0  @             0  @  p                   @   `      (      0      p          0  @    p       `           P       	  0	  	  	  	  
  @
  p
  
  
     0          @  p                                                  
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;2 +  , 4   . L    /  @   4     L   M                     - >    0   1    2   3      K  P   W   O M    5   6    7 hz   8          9          G  @  H   J                                 L    h                                                  (   ~              0       P                                                                         + DCE$DTS_PROVIDER_HOPF                  DCE V1.3-950305T10-58               $             
               $             
               $    @                         $    .            3             $                             $             J   J             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0          0                                           `              0     X                     
                          0     (     0                                          
                                                                 `     P                                               
     `
                   0          P                                    
     &              '              P
     0         @      <               @                                  
     
     
     p
     
      
              0(         `      |       0
                                                                    @
     0                                                                             @      
                                 `      0         P                                    @                                          @              
                                                         0     0     0                            0H     *            <       @                     0@     8*     `              0     P(            |       0p     &                    >
ף               0     P#                                  08     (     p                                           0                          0              0(          @              p                                           0     0     `             0          0              0              0          @              0          0              0      ,     0              P              9                            0     =     `                            P       0     <     `                                    0     X<     `                            0     ;     0              `              0     P;     0                            0     :     0              P              0     X:     0              @              0     9     `              0     @9     0                            0     8     0                            0     @8     0                            0     7     0                            0     07     `              0     6     0              @              0     06     0                             0     5     0                            0     5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               8 $      DCEAXPMUPA013.A                4  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;2                                                                               L                         x "     	       @                            0     4     0                            0     4     0                            0     x3     0              p              0     2     @              `              0     X2     0              P              0     1     0              @              0     81     `              0     0     0                             0      0     0                            0     .     0                           0      .     0                             0     -     0                            0      -     0                            0     ,     0               :                                                                                                                                                                                                                                                                                                                                       p TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d      g02     g02     

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
        -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      M_HOPF: QIO Status failure %x
  M_HOPF: IOSB Status failure %x
 M_HOPF: Missing STX %s
 M_HOPF: string length failure %x
       M_HOPF: response length failure %x
     M_HOPF: radio time not Available %x
    M_HOPF: no internal clock time %x
      M_HOPF: no UTC time %x
 K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                                                                                                                                                                                                                                                                         H                                   0                         x                x                        <                                                                                                 `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @pB4GxbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  0B8bVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @(¤ 0B 8b  GwZk4GGG0B0 &"  8bwZk4G4G0B8bxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZkH  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ b@¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "BGF Hb( <GGgBZk }
  PB( ="@#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~tG^^ ~޴ (0>8@GGGGGb#@¤    $h  %4G  X `⤸8"  G     '  (  )_ 8	  XBWZk  b#@pb#@ G   GGb#@ bTG(Bc 0b  GvZktG(B #"  0b8BvZktG(B  ( #"  F0bvZktG(BH #"    D0bvZktG(B  h #"  E0bvZktG(B #"    H0bvZktG   (B   D0b #"GvZktG  )  ( (B   #"%E0bGzvZk $`   GH BP bG~Zk?"G LH BP b(AG~Zk &@B"I@'WHi)A)@)	A  & 4M / . " 5"XKWJ ?  > ! 5,p E ,pFA5H 5<DH <   u. U.SqJRQJ q>  Q> , u/GH[uK < u?     BGG"Gb}ZkG  BbZk4GB "bZkGBbZk4G(B< 0bUZkh B@ "p b< ="TGbZkG8 BC"b@ ="  < }"{lZktG< P="  ( B0 b, ]"%FZkGBbcZkG(B#"  C"0bP}"uZkGBbeZk4G4G(B0bTZkB< ="b4GTG\uZktG< ="  ( B( ]"0 bFZkGBb@ZkG(B  @#"0bPC"}"uZkGBbBZk4G4G(B0bTZkB4 "b< ="TGKsZktG<   ( B0 b="$ ]"EZkGBbZkG(B  #"0bC"}"uZkGBbZk4G4G(B0bTZk8G  f BbZkTGB4 "b< ="!sZktG<   ( Bp="0 b  ]"EZkGBb~ZkG(B#"  C"0bp}"uZkGBb~Zk4G4G(B0bhTZk4   C8  	GG4 ݠ =" B< ]" btG@ SZktG< ="  ( B0 b ]"EZkGBb~ZkG(B#"  C"0b}"cuZkGBb~Zk< ݠ#"  tG (B ]0bVuZkB "b< ="TG>JZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGbZktG< 0="  ( B0 b ]"OEZkGBb~ZkG(B0#"  @C"0b0}")uZkGBb~Zk4G4G(B0bTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"uZktG8 =" ]"  ( B0 b%EZkGBbc~ZkG(Bh#"  xC"0b}"tZkGBbe~Zk4G4G(B0bSZkB< "0 4G                                                                                                                                                                                                                                                                           + $      DCEAXPMUPA013.A                4  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;2                                                                               L                          "            bGGG=]ZktG<   ( B ="0 b ]"DZkGBb=~ZkG(B#"  C"0b }"tZkGBb?~Zk4G4G(B0bSZk  G
 Bb&~ZkTG(B  #"0btZkGBb*~Zk B< =" b4GTGsZktG< P =" ]"  ( B0 bDZkGBb
~ZkG(B  #"0bC"P }"tZkGBb~Zk4G4G(B0bSZkG]] 4G }ݤ (0=8@P#kq Ep E  &vHpFI7IB	6E Ƣ  &HVJF ƲA?qFpF  yHDH BD !  HY0K$G !4G# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]":UZk  BGb4G.SZk(""  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]@G     Bb}ZkTG ("0B   8b01"tZkGBb}Zk 4GB    p   R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]G`    BbP}ZkTG@H"PB   XbP1"sZkGBbR}ZkG"b#    #     1y@G@     Bb3}Zk4GHBb"7uZkGhb#p@BGb4}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  BbPHJ
dZk&u@7@ \@8  k0@	@  b#@4G  B4G( brRZkF@B0BtG  ¤b@ G0MZk 8 D  "X&" BTG(b  }sZk 0@	@ b#@4G  B4G( bTRZkF@BbtG  ¤` BH GMZk 8 D  "x&" BTG(b  _sZk 0@	@ b#@4G  B4G( b6RZkF@BtG  ¤P bGGLZk"  Ơ 8 D"@@D8 F0Dx   B  '"(bTG9sZkj 0@	@ b#@4G  B4G( bRZkG@8 ¤BtG  bGX GLZk'"  Ơ 8 D"S@@D8 F0DR   B  '"(bTGsZkD 0@	@ b#e@4G  B4G( bQZkG@¤BtG  bG` GLZk  Ơ 8 D'"@@  D8D&D+  BTG(brZk G0@	@ b#?@4G  B4G( bQZk0 ¤G@@ B  'GzZk"G@ B zZkP BGb{Zk  y H8JG  ! b#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G
tZk ?"tG  8 B "@ b  DHZktGB#"b "BBLZkTG( B  "0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "G-LZk? TG  H #"ӣ@@  8DD BburZk4G4GBbRQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "GLZk'? TG   #"S@@  8DD BbMrZk4G4GBb*QZkx "( BTG0 b  %sZk ?"tG8 B  D "@ b\HZktGBb #" "GKZkTG   #"@נ@8DD
 "Bb  &rZk4G4GBbQZk"( BTG0 b  %sZk ?"tG8 B  D "@ b5HZktGBb#" "GKZkTG@"( B0 b  %ksZk ?"tG8 B "  D@ b HZktGB#"b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  Bb7{Zk4GxBb"zZkG Bb;{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bzZkG@ BH b{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 b|qZkGtG0 B$"  8 buqZkGtG0 B   $"8 bnqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~  ( 0 ޴8 @ H >P ^X GGCG(  GGTGG @Q?Bq1B@ !( 1! Q"GGG@b#\ @GG
G @b#_GG
G @`b#p@ @0@GA G	GA  &1@G ] ] G }  ( 0 ݤ8 @ H =P ]X ` #kG#  ( ;G  ~G ^G0 [ 8 {GxZkG ]   #k#0v J  ~4G ^  [ G( {:yZkG ]   #kG  G >G ޢ  tG    4G    G         k#    ~ wH8 ^G@ ^GH ~GP X ` G#G0 =G  ="0 BTG  > 4G ^G G  }"  G8 bG( _"UxZk4G  BG( btJZkXbGB }"c  "EyZkGGG0 BG  ~G     8 b( ;xZkG4GG     TG0 B  TG  =  > }"  G8 bG( G'xZk4G  BG( bGEJZktG	 P`Bp#"hbG  pZk G  #"PtG!vH  	  `Bhb CypZk /vI vI G =,tGP" =HX F   ]. }"`B  RSJhb#"GJepZk G GRHGC  G ="  q.0 BB0 B qJ 1"XFF0A   .B J 1"XGG0A_AFP	 ``Bhb#"   tGApZk G G - =  "OIIo"2A ` .UJJ2B . " , }#a[JWJ@ HJ D  <":B   =. !Q/J'J:&B . }"uSK@T J#"F  >	 P`BGhbtG  pZk Gf  -  P" ]"tG I  E	  =.`BhbR2J	#"GJoZk GT  , !P" ]"tG H  E	  =.`BhbR2J@	#"GJoZk GB  , !P" ]"tG H  E	  =.`BhbR2Jh	#"GJoZk G0   ' !  d, $"  . $# . d" dH D.W J .#f@xdH JF  >1&B D/{9J SJ  Z YK3fB[G  Y? $,p`J "UJA  HJ0D   < .5B D"cJT J  F  >@0 = "b#
 @G8 ]@ ]H }P X ` p #kG0#G  ~ 0  ^ P" G ,G 0.VAHR2J'HGJ !@A !@ 2@8 ] 0. 0  p.  	 P"Q!JS`J'JgJ 1BQ 1B 3B4 } p" 0, 0.A0HR2J'HGJ !@A !@ 2@0 ]	 ,
 0"
 0, P"QHR2H'JGJ 1BQ 1B 2B<  , 0  0.
 P"AHR2J'HGJ !@A !@ 2@ 1@B@  0 
 0. P.Q!JSSJ'JVgJ 1BQ 1B 3BD = p" 0. 3J`FH } 0. " 0JX "P FGyZkL "P =p D   @2@B#H @3D4BN֤JF5BZ B5JzZC:B::@ @,a#6cK,"qG;qCyOGeKqG;qC {CR_B;7aKrRB;rC;;@ tC ` 4G"G( Q B3`J2q @q1B	@3qB=@BC8 D4G\ s"8F   4D  G  s@C    3  B uC qC tC	RC  y s"	@C    0@C  9	@C s" 4@  _?"Vv  GEwZk &@B"GT@  9!WH  VtB 44@( v5B N 8B   0 ="  }"$ G( GGBSZkG ] @ #k# G  ~Gp ^G( @Gx G0 @G "GyZkp D    9 C#H  @  0D10B2NDJPF2PBS _B2@JssB3SB33@ `,"  @J,?#F4BNGEKUG:UC ZC[C:7AK{{C;[C;;@ yC ` 4GS ?B1 J qBssB	B33B= @"C  8F4G s" 8F F   S@B  8	@B 3 s  :@ YC [C pC  x s"	VB    30@B  X	VB s" YC  X   B  Gp ]x  #k#4G  ~ ^ ^ ~   ޴ GGG    XB `bGoZk "T G4GXB`bX GoZkTGXB " #`boZk CB    GXB( "`b4GoZkTGtGBbG "V`ZkTGXB`bX" ="oZk4GXB`b8 "oZkTGtGBb E"@ "D`ZkTGXB`bX"@ ="voZk4GXB`bH "qoZkTGtGBb  E"x "2`ZkTGXB`bX"x ="doZk4GXB`bP"_oZk 0@0  @X "XB4G`bUoZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb`ZkTG xB ="b"5oZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =8G0@B Hb  GmZkTG@B@ %"  HbmZktG0 "h %"@B    AHbmZktG" %"@B    AHbmZkTGtG  B( b "G_ZktG@B   %"Hb ]"mZkTGtG  B@ ] "( b_ZktG@B   %"Hb ]"mZkTG@B %"  Hb{mZkGH ]P ]X }` h p  #k#G  ~ ^ ^ ~  GGG  B( b/{Zk4G0 BG8 bBZkG@ BH bG3{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXb{Zk4G  BG( bCZkGpBxbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBbzZk4G  BG( b@ZkGBbGzZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBbzZk4G  BG( bkZkGBbGzZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( bVZkG BbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBbzZk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4G~ZkG0BG8bhzZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D                                                                                                                                                                                                                                                                           $ $      DCEAXPMUPA013.A                4  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;2                                                                               L                          "     +          4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]%zZktG  BG = ]( bvBZkG`BhbG'zZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =zZkTG  B =G( bfsZkGBbGzZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBbyZktGPB8  0  @8 =XbGcnZkGBb yZk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb =yZkTG  B =G( bHEZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb =yZkTG  B =G( bHZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }tyZkG  B =G ] }( bJZkG@BHbGuyZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]OyZktG  BG = ]( brZkGpBxbGQyZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]+yZktG  BG = ]( bjyZkGBbG-yZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBb	yZk4G  BG( b}ZkGBbG
yZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }xZkG  B =G ] }( bx@ZkG BbGxZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbxZk4G  BG( bBZkG0B8bGxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHbxZk4G  BG( bBZkG`BhbGxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbxZk4G  BG( bdWZkGBbGxZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBb`xZkTG B0  0  @(bGJnZkGBb axZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBb?xZk4G  BG( bJZkGBbGCxZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =xZkTG  B =G( bNNZkGBbG!xZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(bwZk4G  BG( bAZkG@BHbxZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =wZkTG  B =G( bhZkGpBxbwZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxbwZktGB8  0  @8 =bGqnZkGBb wZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbwZkG  B( b6oZkGBbGwZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{wZk4G  BG( b6oZkGBbGwZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG Bb[wZk4G  BG( bXZkG B(bG_wZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =:wZkTG  B =G( bOZkGPB#HXbgH<wZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`BhbwZktG  B8  0  @8 =( bGkZkGBb wZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBbvZkTG( B0  0  @0 bGlZkGBb vZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbvZktG  B8  0  @8 =( bGmZkGBb vZk G ] ]  ` #k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (                                                                                                                                                                                                                                                                                   
LQg $      DCEAXPMUPA013.A                4  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_HOPF.EXE;2                                                                               L                         " "     <       TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                     T               T       t          	                              (                     0                    0  @  P  p              0  @          P                     @   `      (      0      p          0  @    p       `           P       	  0	  	  	  	  
  @
  p
  
  
     0          @  p                                                  
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    w| $      DCEAXPMUPA013.A                >  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2                                                                               H                                      5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2 +  , >   . H    /  @   4     H   G                     - >    0   1    2   3      K  P   W   O I    5   6 PZ(  7    8          9          G  @  H   J                                  L    h                                                  (   '~              0       0                                                                          ' DCE$DTS_PROVIDER_NULL                  DCE V1.3-950305T10-58               $             
               $             
               $    6                         $    .            -             $                             $             J   D             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0     @     0                                           `              0           0          0                                          0             '              &                                       0     X     P                              
     @     `                           h                                  x                                                                         0    x     @      <               @                                                 P           
              0(         `      |                                                                                 0                                                                             @              @      p                   `      0         P                                    @                                                        
                                                         0     0     0                            0H     !            <       @                     0@     X!     `              0     p            |       0     X                                          0                            0                          0              0(          @              p                                           0                      0          0              0              0     @     @                    0     x     0                      0      #     0              P              9                            0     4     `                            P       0     4     `                                    0     x3     `                            0     2     0              `              0     p2     0                            0     1     0              P              0     x1     0              @              0     0     `              0     `0     0                            0     /     0                            0     `/     0                            0     .     0                            0     P.     `              0     -     0              @              0     P-     0                             0     ,     0                            0     8,     @                            0     +     0                            0     (+     0                            0     *     0              p              0      *     @              `              0     x)     0              P              0     (     0              @              0     X(     `              0     '     0                             0     @'     0                            0     %     0                           0      %     0                             0     $     0                            0      $     0                            0     #     0               :                                                                                                                                                                                                                                                                                                                                                                                                                                                              (   TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d      

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
        -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                                                                                                                                                                                                                                                                         8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   nRQ $      DCEAXPMUPA013.A                >  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2                                                                               H                         ! "                                                                x                h                        <                                                                                                 P                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @B4GbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  BbVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @¤ B (b  GwZk4GGG B0 &"  (bwZk4G4GBbxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZk`  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ bp¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "hBGF Hb( <GGgBZk }
  PB( ="#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~tG^^ ~޴ (0>8@GGGGGb#X¤    $4G  %  (h "`⤸8"         (  	_ 	  8BXZk  b#@pb#@    GGxb#@bTGBc  b  GvZktGB #"   bBvZktGB  ( #"  F bvZktGBH #"    D bvZktGB  h #"  E bvZktGB #"    H bvZktG    B(   D b #"GvZktG  )0 8 B   #"%E bG|vZk $`   GH BP bG~Zk?"G LH BP b(AG~Zk &@B"I@'WH¦i)A)@)	A  & 4M " 6" !  p E 6/ /Y7K 7?XK  ? . 6,PJ >A6H 6< v.pF V.SqJRQJ q>  Q> , v/GH[vK < v?     B@ "b< ="TGbZkG8 X BC"` b@ ="  < }"lZktG< P="  ( B0 b, ]"BFZkGBbZkGB#"  C" bP}"vZkGBbZk4G4GBbTZkB< ="b4GTGyuZktG< ="  ( B( ]"0 bFZkGBb]ZkGB  @#" bPC"}"uZkGBb_Zk4G4GBbTZkB4 "b< ="TGhsZktG<   ( B0 b="$ ]"EZkGBb:ZkGB  #" bC"}"uZkGBb<Zk4G4GBbTZkhG  g Bb"ZkTGB4 "b< =">sZktG<   ( Bp="0 b  ]"EZkGBbZkGB#"  C" bp}"uZkGBbZk4G4GBbTZk4   C9  	GG_4 ݠ =" B< ]" btG@ 7SZktG< ="  ( B0 b ]"EZkGBb~ZkGB#"  C" b}"uZkGBb~Zk< ݠ#"  tG B ] bruZkB "b< ="TGZJZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGcZktG< 0="  ( B0 b ]"kEZkGBb~ZkGB0#"  @C" b0}"EuZkGBb~Zk4G4GBbTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"
vZktG8 =" ]"  ( B0 bAEZkGBb~ZkGBh#"  xC" b}"uZkGBb~Zk4G4GBbSZkB< "0 4GbGGGY]ZktG<   ( B ="0 b ]"EZkGBbY~ZkGB#"  C" b }"tZkGBb[~Zk4G4GBbSZk  G
 BbB~ZkTGB  #" btZkGBbF~Zk B< =" b4GTG$sZktG< P =" ]"  ( B0 bDZkGBb&~ZkGB  #" bC"P }"tZkGBb(~Zk4G4GBbSZkG]] 4G }ݤ (0=8@P#kq Ep E  &tHpFI5IB	4E   &HTJF [?qFpF  8aHY$K@!G 8  8HA$H9D 8NG# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]"VUZk  BGb4GJSZkx"0"  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]G     B b}ZkTGX`"hB   pb01";tZkGB b}Zk  4G0B    x   R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]G     B(bl}ZkTG"B   bP1"tZkG@BHbn}Zk0G  "b#    #     1y@G@      B(bO}Zk4GBb"SuZkGb#T@@BGHbP}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  P BX bPHJ&dZk&u@7@ \@`   k0@	@  pb#@4G  B4G( bRZkF@BbtG  ¤ BP GLMZk 8 D  "H&"BTGb  sZk 0@	@ pb#@4G  B4G( bpRZkF@BBtG  ¤bX G.MZk 8 D  "h&"BTGb  {sZk 0@	@ pb#@4G  B4G( bRRZkF@BtG  8 ¤` bGGMZk"  Ơ 8 D"@@D8 F0Dx  B  '"bTGUsZkj 0@	@ pb#@4G  B4G( b,RZkG@¤BtG  bGh GLZk'"  Ơ 8 D"S@@D8 F0DR  B  '"bTG/sZkD 0@	@ pb#e@4G  B4G( bRZkG@@ ¤BtG  bGp GLZk  Ơ 8 D'"@@  D8D&D+ BTGb
sZk G0@	@ pb#?@4G  B4G( bQZk0 ¤G@B  'GzZk"GB zZkBG~{Zk  y H8JG  ! pb#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G)tZk ?"tG  8 B "@ b  DHZktGB#" b "8B^LZkTG@( B  "0 b  %tZk ?"tG8 B  D "@ bHZktGB b #" "GILZk? TG  H #"ӣ@@  8DD BbrZk4G4G(B0bnQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGB b#" "G!LZk'? TG   #"S@@  8DD BbirZk4G4G(B0bFQZkH "( BTG0 b  %sZk ?"tG8 B  D "@ bxHZktGB b#" "GKZkTG   #"@נ@8DD
 "Bb  BrZk4G4G(B0bQZk"( BTG0 b  %sZk ?"tG8 B  D "@ bQHZktGB b#" "GKZkTG@"( B0 b  %sZk ?"tG8 B "  D@ b<HZktGB #" b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  PBXbS{Zk4G`Bhb"zZkGpBxbW{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b1{Zk4G0 BG8 bzZkG@ BH b6{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 bqZkGtG0 B$"  8 bqZkGtG0 B   $"8 bqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~   ޴   > ^ ~   ޵  GGGC $ BGT  TGG@B 	0 E  ?"BbGyZk4GU@!WHX uB\ 55@` 5Bt  NXb @x PBpB@ P# p!( !GPBGGGJZkGG`B ="hb ]"0 }" "SZkGGpBxb ="X }"GGTZk4GPBXbGJZkG
  GGb#_GGb#G !@ 0@GA GGGA %1@G ] ] G }   ݤ   = ] }   ݥ  #k 4Gk#0v J  ~4G ^  [ G( {.yZkG ]   #kG  G >G ޢ  tG    4G             kG@#G  ~ ^ ^ ~  GG }G?"Bb  G)yZk &@B"4GV@( B!WH\ vB` 66@t 6Bx  N0 bX GGlJZkGG8 B ="@ b ]"0 }" ")SZkGGH BP b ="X }"GGBTZk4G( B 0 bUJZkG ] ] }   #kG#4G  ~ ^ ^ ~   ޴ GGG    XB `bGqZk "T G4GXB`bH GqZkTGXB " #`b                                                                                                                                                                                                                                                                           . $      DCEAXPMUPA013.A                                                                   qn{LD.COM;2                                                                                                         `            zpܓ!u	<5uɂf%nA{tUXO3h-=tN
,KqIWt{4^N>"Jwwo}mv͚r{iJAlBXr}E#:oK09D2BA;j~@O;Ȟ0|Ll5nD5K!P6+woOn*$MMVb)h&sՔ aܽo(`¦XTa1EŇqJ&j,Sgh[dn]l\k}9lEq;9!B *sʔ}1"\"֌SxCKZW&魓1zykU5P/A0<rz$zȎχg1"Sh,8Ig[GO2Ӂ| @9/V
sIT6,&P׸Kѝk,bb}*Gyej%"ECb	!GְpU4lZ<<^&ʫ&6Ӕyj_ %ԥƥa!ֻXUL|{XǱi3i7{
Z,5un[6bwoG5mGe5[=
Dd+B:Ӻf;+pmDte}	LH_=FeZr=!	&Sk,aǗ  'o~6fX w,u"+8[!\Ќkx=
u׹6hiEBzg~ &PklPLh}dx5CFKL^Xw"tXw@=.5pKJ,<D9\>Ĝaqy{3]dΥ>VUP^@?AscN(;hqxOvڣxVSpn pJ\n6D;~a1i+LLWS
Shr7d4%iԑxGε2;4.b3@W"]oXQަawWR|u'S6*
@m򢩽\i]~)Mr,!K$W9p~|m,rq fzF>d=Gdw0CMN|o|(τ=aC2kNI`㠅Bk;vu屼"5܃hyW')2lfEI8.ƛ7Gq<Zz0	A 7qv42Pś<o^*P3V%͹mO"aNNEx>K۴0Bc9_iWS~جyԵC-gIMȏ@m2WY܎׎[sV]՚Odz?|GeyJboetcnp}1CX4*>ɷ)῞)j	?QkgbFȃzϫ$Y9Y/-"q7]pk,"@5HV$v |+/d]ε!
S1]}cHnڝ`
	igeIVmI?Fbmz)ڹp4GTߤc
(6LGcZ7lIO+?[Ae}xB;n|vVMN,/VݙU8ԃ1%G5DZ[Y!_Saԙ#, J F 23-XpH=kb[E;WGD,ʛ #%Yo[a2:!^(8aZ32P]n8rik1ߌ[)#b{hk܀LbAooOq43xC/V V"\oE(R*;Xn_>ޤV9Vg۬]jMPиiW%	əKW-ZWҶϓ̑Tr}V: s)bmRܻ8nѐh6u<:MMʔE&'	})NFSvIz@vwż&BxKh;eEg嚋1ynP+el?̺thn	
"IyPg8 C!ig$:U<JlH/M0xRYaF VD}l=.)T|bh\2CZYTBhdq|lkbMmjHjPiJ%f5WS80HYA}N%pg ج1mB>/;k͚ ZQ lG M$ePH扨7Gukۨ*8kpg<PΗXU
Uؼ6nqI|3-C3JӇl$N9lM/<N'=}LFKe$K."G1UfuZh99 +d/:y%a+)%MH͏n'l 
pfYP9"Uu]n#{mFnfXt9OgzsEes
ʫsɦyCwY-Sh,ҧ@bh@d&
ޟU(./ _l`
\ҳfr"Imq܃	qF_=GٓA?{&n}~^ZTXdG@w+p 60"A4}R
3? tzneMzFns};C{wAu*X$dߡZLOsv[uO[O@`?* KKT=p7Ֆ4hE[k+,|N>@ ov! T.x&:&9!z;xa|;&-m={cEܳͅ'EC_A[J@T4 tyev>y]H2k&9~ ǺYu`OR2$*5O[J{߳xc.҉]./`00
mOlsY٘W:l><X]ЛO8{!Z*Gox 0guwV-͎3k7
.Eߎr2d	"Ok
'0eT~Jk胓RTk*S
̌U} ')16([w:L9k1o_,Og,艋$9ydpH&*e3í5kQnpqs/ejBWK]r`btr~RݚX}'<4/|qAaOME	>aQN
h5n#nOopIЮZxOxp v)IJrv|i``W172ȺpӧluG[|\?;[XA6V|񗄲ULQvlx,zD̀w,={)Q'B-\Ce*D8{7r<qK3# aR:$k?%&"}V"Co$[XDh:
2cO1wR|b8xLC,H%	k@kl[h*Jٱ"?x|r"F&3nahSģC^}[Ӽ;heHgdoNrr'?#|xŀ(i? j^zs|~L읉?mKQV*>sT򣯏rId2>{j62K>},ɎXg*Xr<:y_i(|O=iE:xlNފyx+>	7>`.ghT%z<ſq;R
zst&ԏyS_?EV@Nebf
F$P@Vmd>4?  E^7xdmGͽ{/8$XtA57?˿!-I=>$UE!|;ݓ\Hy$n0>HC697Q<cпq]誣ck+M2\h-?~`gK7%N2??	Uny?ra=Jyݭ[ ۶1y<d/]X;>$`J;`рofW,4Jc>c>kLmR}1cz~$_@4!ޗؤ硛A?I81bwWEjz0qXf%kꌿaz|şK7.`/)2"ޒA7sbA2
{0D`C¨V$:T,rYF:<+bLoSI๚Eos*;^ahĠDM@	I]
z!--<On/|NcT?fmztp3< Liݩ@9vDu1/V)#̨@e?sq&!+t3X;uP{e2>z}J2ܻo*	]>	ƵjAD2rسx[Tߝ7;bbeنEbe?F͢p3WHbvu[P>exZ_5iI>l@Mp>|y$A:ٙTMy"rȂ
MatؿS R*2Dp^aYbs[mΰjh1<nɏ1eǪxArZUo(=[o?'qiѹ;jMMf!>./K&wI| 9ТW5OyH虁fBgsYpRIݲo	2⎛U_zD Sj|
W<A%ksP#EEfgFIy91JTNA<^SGw<}%Psr!-1Oeif<#l!	)t 2Jy:֢dѲ.~KAvg_|qv2(p"o<y  Bi$	S<uAw
RGel2@#c4ظ[1n,FIKcI*SGhߩ9puZxf| `U+ hyvA
R)
NBewXr\%
KhF]ZXprɾ*Nz)(],}7	?l2٬v@aDߘ
£rBC}p"
5o7d}zD)<˄ˣ" Wl樭uהd/ݠxPkg)̴+S+YRGK<!ӟF˃V/INmF$]jx^c)|d^  I[RSHL
~䇐UjVقpUCbwjQjCHRȉ6VPTѦqPn{o[-,n
ȉ,Vߐ99 n!!jGל;eoeԶ[Qd*kectvJ
sh,]?(+Lɘƭ
Պu/TDi|0)ۼ3z/5ȍr Od+q]igq).ld=ӠDkg&zV߽FxnNH$
0g Pm5[D+*t
8i'R̷=H]+s#1]S-9mr(ЍP/%rwS9p9F 0r2:D
uwl&kGp+ЌwajNzR̜s҂fI4!ǰm$ye71:reNz=83YP%
)ᵃXOZr_!TxaPǉaA{tua5N `,LqD󿡜gb!o Wb~8.\OVq6](~UyRBC4@E C>_z)?9lfd.F,2Xⰳ?!ޭWYٔvU$k6(X
7XJ? K8MBa
Qg-}|(MAHg@#j۶ggnKr2}V@EZ9o4`,%ۭb6/%~QEAtøy;FvSbT!:'LRIR>踛=DNQYD>'"c*aR
+[EeHWY\"F9$,*,Ov@V^ǋ}wцNg$mlHTd$-1fQSt\{Y4	mYYH[?7O)?jg-Z~B/hR٬;ebzQ^ckkJ?c	@ZZ!CB%p6KDMKd|G'_ucgN \Uwaea)vKΟwebB02Ɇ{
F|NRh۲\L/-?~Є?_TFV#sD dY,D5
*!=M/M;3	#ٖ1UʉBE#l':Mo卲fThVp}2`p!1m?yFna"<&W.ELE|?aK&﫤5 $DSl`j+:ꘘc'$@D<ʙZ"YsٌKӭ`3HO|*h Ȓ2=f\.zܠo4<C8/VeQ;gl"EFۖ38oŮ^wg%^=)͘p`Jt4>Fre79QdVܛOBaMY"7Bm^
/2/{#h^w+@5٪qԄ,$-<0Q'|\	5$Lwv]%Cc1=Juv_Pc^jPոIXc&*$rE0D"2cXBnIfd2:K<qkamZz!2yzrzh$lv^Q%Lʳݙ/B(N;\cmqv39EpwֶQ7{nqe̛C~3ƅNU.HtiCtEj)_fs
z6ǡD i~0U",mT1QtR:Ytrt361jv{lDn 3OXKҋrmԩ4ʜT謞 5
Q6ZP>ƹgG
E *u>p8`tKdEދwjި~ɉ"{VmG|*+įq
Hg=!
>se}lCbpgBByJÍnMā:}4L7}t!qL814&d
y. LѤ~$1!jQy>rv#Y/d NcQ!Bwwi2@oȰ7b5iE,5c5Ϝh%|I*Qݺ\Sg^Q
0.myQ{.Ĉ(
M\
⦍*O"H_zZO3P4.j-?C!9{Kvr}</qAlכ@=DyJk':I^#65u}R+ص3Hd+DuΠPHPNEAV+0pVO}VUbWXO@zL1KmړYF4~n96S~n
d
`Kۮ=0b-ŨkI~[h0ЫjF=)۵C#kbq:cFSTkXsOM,J->.!b_KsZ/z}ݯ>]p#Ѳ|uP?~žCk!$YgFvd	.hTNG(|l6,$רv)Fȓc諃j1aV	qIܯ\DApXfycx-5Aaܮam<Io'Ͱw=*uJ颾2vU 䠍\Pz#u
@e
k-5`1!GfL!NCl͹m״W~B9>SNM
q7X	_~jR*"Y]邒                                                                                                                                                                                                                                                                             $      DCEAXPMUPA013.A                >  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2                                                                               H                         )R "     "       qZk CB    GXB( "`b4GqZkTGtGBbG "bZkTGXB`bh" ="qZk4GXB`b8 "qZkTGtGBb E"@ "|bZkTGXB`bh"@ ="qZk4GXB`bH "qZkTGtGBb  E"x "jbZkTGXB`bh"x ="qZk4GXB`b`"qZk 0@0  @X "XB4G`bqZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb<bZkTGxB ="b"mqZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =(G 0B 8b  GoZkTG0B@ %"  8boZktG0 "h %"0B    A8boZktG" %"0B    A8boZkTGtG  B( b "GaZktG0B   %"8b ]"oZkTGtG  B@ ] "( baZktG0B   %"8b ]"oZkTG0B %"  8boZkGH ]P ]X }` h p  #k#G  ~ ^ ^ ~  GGG  B( bg}Zk4G0 BG8 bDZkG@ BH bGk}ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXbG}Zk4G  BG( bEZkGpBxbGK}ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb'}Zk4G  BG( bRBZkGBbG+}ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb}Zk4G  BG( b$nZkGBbG}ZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =|ZkTG  B =G( b
YZkG BbG|ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBb|Zk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4G@ZkG0BG8b|ZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D   4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]]|ZktG  BG = ]( bDZkG`BhbG_|ZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =:|ZkTG  B =G( buZkGBbG=|ZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBb|ZktGPB8  0  @8 =XbGpZkGBb |Zk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb ={ZkTG  B =G( bGZkGBbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb ={ZkTG  B =G( bKZkGBbG{ZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }{ZkG  B =G ] }( bMZkG@BHbG{ZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]{ZktG  BG = ]( b*uZkGpBxbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]c{ZktG  BG = ]( b{ZkGBbGe{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBbA{Zk4G  BG( b(@ZkGBbGE{ZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }{ZkG  B =G ] }( bBZkG BbG{ZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbzZk4G  BG( bzAZkG0B8bGzZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHbzZk4G  BG( b.EZkG`BhbGzZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbzZk4G  BG( bYZkGBbGzZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBbzZkTG B0  0  @(bGpZkGBb zZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBbwzZk4G  BG( bLZkGBbG{zZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =VzZkTG  B =G( bPZkGBbGYzZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(b5zZk4G  BG( bCZkG@BHb:zZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =zZkTG  B =G( bkZkGpBxbzZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxbyZktGB8  0  @8 =bGpZkGBb yZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbyZkG  B( bnqZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( bnqZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG BbyZk4G  BG( bHZZkG B(bGyZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =ryZkTG  B =G( bQZkGPB#HXbgHtyZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`BhbNyZktG  B8  0  @8 =( bGmZkGBb NyZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBb(yZkTG( B0  0  @0 bGoZkGBb )yZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbyZktG  B8  0  @8 =( bGoZkGBb yZk G ] ]  ` #k                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS                                                                                                                                                                                                                                                                           ث $      DCEAXPMUPA013.A                >  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2                                                                               H                         ^ "     3       4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        % $      DCEAXPMUPA013.A                >  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_NULL.EXE;2                                                                               H                         b      D                               T               T       t          	                                                                         0  @  `                                                @     p    (      0                 @         P         0  `        @  p       	  P	  	  	  	  
  @
  p
  
  
     P          @                `    P                       
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;2 +  , ;   . L    /  @   4     L   K                     - >    0   1    2   3      K  P   W   O M    5   6   7 6   8          9          G  @  H   J                                 L    h                                                  (   5~              0       P                                                                         !5 DCE$DTS_PROVIDER_PSTI                  DCE V1.3-950305T10-58               $             
               $             
               $    <                         $    .            1             $                             $             J   H             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0          0                                           `              0     X                     
                          0     (     0                                          
                                                                 `     P                                               p
     P
                   0          P                                    
     &              '              @
     0         @      <               @                                  
      
     
     `
     
      
              0(         `      |        
                                                                     0
     0                                                                             @      
                                 `      0         P                                    @                                          @              
                                                         0     0     0                            0H     x'            <       @                     0@     '     `              0      %            |       0p     #                    >
ף               0                                       00     (     `       <                                     0                          0              0(          @              p                                           0     0     `             0          0              0              0          @              0          0              0     (     0              P              9                            0     P:     `                            P       0     9     `                                    0     (9     `                            0     8     0              `              0      8     0                            0     7     0              P              0     (7     0              @              0     6     `              0     6     0                            0     5     0                            0     5     0                            0     4     0                            0      4     `              0     3     0              @              0      3     0                             0     2     0                            0     1     @                            0     h1     0                            0     0     0                            0     H0     0              p              0     /     @              `              0     (/     0              P              0     .     0              @              0     .     `              0     -     0                             0     ,     0                            0     X+     0                           0     *     0                             0     P*     0                            0     )     0                            0     P)     0               :                                                                                                                                                                                                                                                                                                                                       p TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d      QA0000  QA0000  

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          = $      DCEAXPMUPA013.A                ;  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;2                                                                               L                          "                    -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      M_PSTI: QIO Status failure %x
  M_PSTI: IOSB Status failure %x
 M_PSTI: response length failure %x
     M_PSTI: time not Available %x
  M_PSTI: out of spec detected %x
        M_PSTI: out of spec detected %x
        M_PSTI: hard fault detected %x
 K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                                                                                                                                                                                                                                                                                 H                                   0                         x                x                        <                                                                                                 `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @pB4GxbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  0B8bVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @(¤ 0B 8b  GwZk4GGG0B0 &"  8bwZk4G4G0B8bxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZkH  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ b@¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "BGF Hb( <GGgBZk }
  PB( ="@#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~tG^^ ~޴ (0>8@GGGGGb#@¤    $h  %4G  X `⤸8"  G     '  (  )_ 8	  XBWZk  b#@pb#@ G   GGb#@ bTG(Bc 0b  GvZktG(B #"  0b8BvZktG(B  ( #"  F0bvZktG(BH #"    D0bvZktG(B  h #"  E0bvZktG(B #"    H0bvZktG   (B   D0b #"GvZktG  )  ( (B   #"%E0bGzvZk $`   GH BP bG~Zk?"G LH BP b(AG~Zk &@B"I@'WHi)A)@)	A  & 4M / . " 5"XKWJ ?  > ! 5,p E ,pFA5H 5<DH <   u. U.SqJRQJ q>  Q> , u/GH[uK < u?     BGG"Gb}ZkG  BbZk4GB "bZkGBbZk4G(B< 0bUZkh B@ "p b< ="TGbZkG8 BC"b@ ="  < }"{lZktG< P="  ( B0 b, ]"%FZkGBbcZkG(B#"  C"0bP}"uZkGBbeZk4G4G(B0bTZkB< ="b4GTG\uZktG< ="  ( B( ]"0 bFZkGBb@ZkG(B  @#"0bPC"}"uZkGBbBZk4G4G(B0bTZkB4 "b< ="TGKsZktG<   ( B0 b="$ ]"EZkGBbZkG(B  #"0bC"}"uZkGBbZk4G4G(B0bTZk8G  f BbZkTGB4 "b< ="!sZktG<   ( Bp="0 b  ]"EZkGBb~ZkG(B#"  C"0bp}"uZkGBb~Zk4G4G(B0bhTZk4   C8  	GG4 ݠ =" B< ]" btG@ SZktG< ="  ( B0 b ]"EZkGBb~ZkG(B#"  C"0b}"cuZkGBb~Zk< ݠ#"  tG (B ]0bVuZkB "b< ="TG>JZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGbZktG< 0="  ( B0 b ]"OEZkGBb~ZkG(B0#"  @C"0b0}")uZkGBb~Zk4G4G(B0bTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"uZktG8 =" ]"  ( B0 b%EZkGBbc~ZkG(Bh#"  xC"0b}"tZkGBbe~Zk4G4G(B0bSZkB< "0 4GbGGG=]ZktG<   ( B ="0 b ]"DZkGBb=~ZkG(B#"  C"0b }"tZkGBb?~Zk4G4G(B0bSZk  G
 Bb&~ZkTG(B  #"0btZkGBb*~Zk B< =" b4GTGsZktG< P =" ]"  ( B0 bDZkGBb
~ZkG(B  #"0bC"P }"tZkGBb~Zk4G4G(B0bSZkG]] 4G }ݤ (0=8@P#kq Ep E  &vHpFI7IB	6E Ƣ  &HVJF ƲA?qFpF  yHDH BD !  HY0K$G !4G# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]":UZk  BGb4G.SZk(""  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]@G     Bb}ZkTG ("0B   8b01"tZkGBb}Zk 4GB    p   R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]G`    BbP}ZkTG@H"PB   XbP1"sZkGBbR}ZkG"b#    #     1y@G@     Bb3}Zk4GHBb"7uZkGhb#@BGb4}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  BbPHJ
dZk&u@7@ \@8  k0@	@  b#@4G  B4G( brRZkF@B0BtG  ¤b@ G0MZk 8 D  "X&" BTG(b  }sZk 0@	@ b#@4G  B4G( bTRZkF@BbtG  ¤` BH GMZk 8 D  "x&" BTG(b  _sZk 0@	@ b#@4G  B4G( b6RZkF@BtG  ¤P bGGLZk"  Ơ 8 D"@@D8 F0Dx   B  '"(bTG9sZkj 0@	@ b#@4G  B4G( bRZkG@8 ¤BtG  bGX GLZk'"  Ơ 8 D"S@@D8 F0DR   B  '"(bTGsZkD 0@	@ b#e@4G  B4G( bQZkG@¤BtG  bG` GLZk  Ơ 8 D'"@@  D8D&D+  BTG(brZk G0@	@ b#?@4G  B4G( bQZk0 ¤G@@ B  'GzZk"G@ B zZkP BGb{Zk  y H8JG  ! b#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G
tZk ?"tG  8 B "@ b  DHZktGB#"b "BBLZkTG( B  "0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "G-LZk? TG  H #"ӣ@@  8DD BburZk4G4GB                                                                                                                                                                                                                                                                           ; $      DCEAXPMUPA013.A                ;  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;2                                                                               L                         } "            bRQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "GLZk'? TG   #"S@@  8DD BbMrZk4G4GBb*QZkx "( BTG0 b  %sZk ?"tG8 B  D "@ b\HZktGBb #" "GKZkTG   #"@נ@8DD
 "Bb  &rZk4G4GBbQZk"( BTG0 b  %sZk ?"tG8 B  D "@ b5HZktGBb#" "GKZkTG@"( B0 b  %ksZk ?"tG8 B "  D@ b HZktGB#"b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  Bb7{Zk4GxBb"zZkG Bb;{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bzZkG@ BH b{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 b|qZkGtG0 B$"  8 buqZkGtG0 B   $"8 bnqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~  ( 0 ޴8 @ H >P ^X GGCG(  GGTGG @Q?Bq1B@ !( 1! Q"GGG@b#\ @GG
G @b#_GG
G @`b#@ @0@GA G	GA  &1@G ] ] G }  ( 0 ݤ8 @ H =P ]X ` #kG#  ( ;G  ~G ^G0 [ 8 {GxZkG ]   #k#0v J  ~4G ^  [ G( {:yZkG ]   #kG  G >G ޢ  tG    4G    G         k#4G  ~0 ^8 ^@ ~H P X GG#0 BG( =G8 bG JZkGXbB }" = c  ]" "YyZkGGG  >G  BG >tG > ^  ~_"( b( MxZk4G0 BG8 bGkJZktG	 P`Bp#"hbG  pZk Gj  #"PtG!vH  	  `Bhb CpZk %vH vH[ GRHP#" CAF    `BhbtGpZk GM G , ]"P"tG H  D
  =.`BhbR2J#"GJ}pZk G; G , ]"P"tG H  D
  =.`BhbR2J#"GJkpZk G) G , ]"P"tG H  D
  =.`BhbR2J 	#"GJYpZk G G , ]"P"tG H  D
  =.`BhbR2JH	#"GJGpZk G G( = "b#
 @G0 ]8 ]@ }H P X ` #kG # 0   ~G ^ p" ^ " G , P" 0.G H , 2JV/D7 H0 = H ,OFoF7`J H7@JF7J4    0.3`J ?$ SB  J@B!  aN/F7 J8 = 0, p" ,G 3H HoF7`JOF7@J3`J  SBL 	 .	 "V JX "F7JQzZk*@GD =p D    0 B#Hv  1D2QBSNdJqF3qBT B3`JtB4tB44@ ,"vJ,_"F5BNGeKzG;zC {CPB;7aKpB;pC;;@ rC ` G4GS ?B1 JssBX "33BB4G 
@  "G_ Z#  0@@  Z90C "
2C @ Z#  40@@  91C "
 C6?"Vv  GxZk &@B"T@!WH  VtB( v44@5B N"1@@@ ]0 ="< = }"P G G G $ ( GTZkG ]@ ]  #k# G  ~Gp ^G( @Gx G0 @G "GyZkp D    9 C#H  @  0D10B2NDJPF2PBS _B2@JssB3SB33@ `,"  @J,?#F4BNGEKUG:UC ZC[C:7AK{{C;[C;;@ yC ` 4GP ?B1 JpB ]"10BQB 4G r R"G
B `G "   R"  46B 0 @
B   "  r 0 @  46B R"
B? 1 @    زGp ]x  #k#4G  ~ ^ ^ ~   ޴ GGG    XB  `bG{pZk "T G4GXB`b@ GqpZkTGXB " #`bkpZk CB    GXB( "`b4GapZkTGtGBbG ""aZkTGXB`bp" ="TpZk4GXB`b8 "OpZkTGtGBb E"@ "aZkTGXB`bp"@ ="BpZk4GXB`bH "=pZkTGtGBb  E"x "`ZkTGXB`bp"x ="0pZk4GXB`bh"+pZk 0@0  @X "XB4G`b!pZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb`ZkTG xB ="b"pZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =8G0@B Hb  GnZkTG@B@ %"  HbynZktG0 "h %"@B    AHbqnZktG" %"@B    AHbinZkTGtG  B( b "G`ZktG@B   %"Hb ]"[nZkTGtG  B@ ] "( b`ZktG@B   %"Hb ]"MnZkTG@B %"  HbGnZkGH ]P ]X }` h p  #k#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bPCZkG@ BH bG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXb{Zk4G  BG( b`DZkGpBxbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( b@ZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( blZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =z{ZkTG  B =G( bWZkG BbG}{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBbX{Zk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4GSZkG0BG8b4{ZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D   4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]zZktG  BG = ]( bBCZkG`BhbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =zZkTG  B =G( b2tZkGBbGzZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBbzZktGPB8  0  @8 =XbG/oZkGBb zZk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( bFZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb =dzZkTG  B =G( bIZkGBbGgzZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }@zZkG  B =G ] }( bKZkG@BHbGAzZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]zZktG  BG = ]( bsZkGpBxbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]yZktG  BG = ]( b6zZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b~ZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }yZkG  B =G ] }( bDAZkG BbGyZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b@ZkG0B8bGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHboyZk4G  BG( bCZkG`BhbGsyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbOyZk4G  BG( b0XZkGBbGSyZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBb,yZkTG B0  0  @(bGoZkGBb -yZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBbyZk4G  BG( bxKZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =xZkTG  B =G( bOZkGBbGxZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(bxZk4G  BG( bfBZkG@BHbxZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =xZkTG  B =G( biZkGpBxbxZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxbxZktGB8  0  @8 =bG=oZkGBb xZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbfxZkG  B( bpZkGBbGkxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBbGxZk4G  BG( bpZkGBbGKxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG Bb'xZk4G  BG( bXZkG B(bG+xZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =xZkTG  B =G( bZPZkGPB#HXbgHxZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`BhbwZktG  B8  0  @8 =( bGglZkGBb wZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBbwZk                                                                                                                                                                                                                                                                            Che $      DCEAXPMUPA013.A                ;  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;2                                                                               L                         g "     0       TG( B0  0  @0 bGmZkGBb wZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbwZktG  B8  0  @8 =( bGMnZkGBb wZk G ] ]  ` #k                                                                                                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B                                                                                                                                                                                                                                                          !                        <D $      DCEAXPMUPA013.A                ;  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_PSTI.EXE;2                                                                               L                               A        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                     T               T       t          	                              (                     0                    0  @  P  p              0  @          P                     @   `      (      0      p          0  @    p       `           P       	  0	  	  	  	  
  @
  p
  
  
     0          @  p                                                  
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;2 +  , 9   . L    /  @   4     L   K                     - >    0   1    2   3      K  P   W   O M    5   6    7 (   8          9          G  @  H   J                                 L    h                                                  (   ~              0       P                                                                          DCE$DTS_PROVIDER_SPEC                  DCE V1.3-950305T10-58               $             
               $             
               $    <                         $    .            1             $                             $             J   H             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0          0                                           `              0     X                     P                          0     (     0                                                                                                           `     P                                               0                        0          P                                   
     &              '                    0         @      <               @                                  `     
                p      
              0(         `      |       
                                                                    
     0                                                                             @      @                                 `      0         P                                    @                                          @              
                                                         0     0     0                            0H     '            <       @                     0@     8'     `              0     P%            |       0`                 <       >
ף                                      0@     (     p                                                    0                          0              0(          @              p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              "                        ҹ $      DCEAXPMUPA013.A                9  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;2                                                                               L                         29 "                           0     0     `             0          0              0              0          @              0          0              0      )     0              P              9                            0     :     `                            P       0     9     `                                    0     X9     `                            0     8     0              `              0     P8     0                            0     7     0              P              0     X7     0              @              0     6     `              0     @6     0                            0     5     0                            0     @5     0                            0     4     0                            0     04     `              0     3     0              @              0     03     0                             0     2     0                            0     2     @                            0     1     0                            0     1     0                            0     x0     0              p              0     /     @              `              0     X/     0              P              0     .     0              @              0     8.     `              0     -     0                             0      -     0                            0     +     0                           0      +     0                             0     *     0                            0      *     0                            0     )     0               :                                                                                                                                                                                                                                                                                                                                                                               ` TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d      T       T       

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
        -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      M_SPEC: QIO Status failure %x
  M_SPEC: IOSB Status failure %x bytes %d
        M_SPEC: response length failure %x
     dtssprovider: Spectracom manually set, ignoring time
   dtssprovider: Spectracom has lost signal
       dtssprovider: Spectracom year incorrect in switches
    dtssprovider: radio clock fault
        time returned - %26s
   dtssprovider: radio clock fault
        time returned - %26s
   K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                                                                                                                                                                                                                                                                                         H                                   0                         x                x                        <                                                                                                 `                                                                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @pB4GxbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  0B8bVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @(¤ 0B 8b  GwZk4GGG0B0 &"  8bwZk4G4G0B8bxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZkH  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ b@¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "BGF Hb( <GGgBZk }
  PB( ="@#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~tG^^ ~޴ (0>8@GGGGGb#@¤    $h  %4G  X `⤸8"  TG     '  (  )_ 8	  XBWZk  b#@pb#@ G   GGb#@ bTG(Bc 0b  GvZktG(B #"  0b8BvZktG(B  ( #"  F0bvZktG(BH #"    D0bvZktG(B  h #"  E0bvZktG(B #"    H0bvZktG   (B   D0b #"GvZktG  )  ( (B   #"%E0bGzvZk $`   GH BP bG~Zk?"G LH BP b(AG~Zk &@B"I@'WHi)A)@)	A  & 4M / . " 5"XKWJ ?  > ! 5,p E ,pFA5H 5<DH <   u. U.SqJRQJ q>  Q> , u/GH[uK < u?     BGG"Gb}ZkG  BbZk4GB "bZkGBbZk4G(B< 0bUZkh B@ "p b< ="TGbZkG8 BC"b@ ="  < }"{lZktG< P="  ( B0 b, ]"%FZkGBbcZkG(B#"  C"0bP}"uZkGBbeZk4G4G(B0bTZkB< ="b4G                                                                                                                                                                                                                                                   #                        EVE $      DCEAXPMUPA013.A                9  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;2                                                                               L                          "            TG\uZktG< ="  ( B( ]"0 bFZkGBb@ZkG(B  @#"0bPC"}"uZkGBbBZk4G4G(B0bTZkB4 "b< ="TGKsZktG<   ( B0 b="$ ]"EZkGBbZkG(B  #"0bC"}"uZkGBbZk4G4G(B0bTZk8G  f BbZkTGB4 "b< ="!sZktG<   ( Bp="0 b  ]"EZkGBb~ZkG(B#"  C"0bp}"uZkGBb~Zk4G4G(B0bhTZk4   C8  	GG4 ݠ =" B< ]" btG@ SZktG< ="  ( B0 b ]"EZkGBb~ZkG(B#"  C"0b}"cuZkGBb~Zk< ݠ#"  tG (B ]0bVuZkB "b< ="TG>JZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGbZktG< 0="  ( B0 b ]"OEZkGBb~ZkG(B0#"  @C"0b0}")uZkGBb~Zk4G4G(B0bTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"uZktG8 =" ]"  ( B0 b%EZkGBbc~ZkG(Bh#"  xC"0b}"tZkGBbe~Zk4G4G(B0bSZkB< "0 4GbGGG=]ZktG<   ( B ="0 b ]"DZkGBb=~ZkG(B#"  C"0b }"tZkGBb?~Zk4G4G(B0bSZk  G
 Bb&~ZkTG(B  #"0btZkGBb*~Zk B< =" b4GTGsZktG< P =" ]"  ( B0 bDZkGBb
~ZkG(B  #"0bC"P }"tZkGBb~Zk4G4G(B0bSZkG]] 4G }ݤ (0=8@P#kq Ep E  &vHpFI7IB	6E Ƣ  &HVJF ƲA?qFpF  yHDH BD !  HY0K$G !4G# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]":UZk   BGb4G.SZk8""  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]PG     Bb}ZkTG08"@B   Hb01"tZkGBb}Zk 4GB       R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]Gp    BbP}ZkTGPX"`B   hbP1"sZkGBbR}Zk G"b#    #     1y@G@     Bb3}Zk4GXBb"7uZkGxb#@BGb4}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  BbPHJ
dZk&u@7@ \@8  k0@	@  b#@4G  B4G( brRZkF@B0BtG  ¤b@ G0MZk 8 D  "X&" BTG(b  }sZk 0@	@ b#@4G  B4G( bTRZkF@BbtG  ¤` BH GMZk 8 D  "x&" BTG(b  _sZk 0@	@ b#@4G  B4G( b6RZkF@BtG  ¤P bGGLZk"  Ơ 8 D"@@D8 F0Dx   B  '"(bTG9sZkj 0@	@ b#@4G  B4G( bRZkG@8 ¤BtG  bGX GLZk'"  Ơ 8 D"S@@D8 F0DR   B  '"(bTGsZkD 0@	@ b#e@4G  B4G( bQZkG@¤BtG  bG` GLZk  Ơ 8 D'"@@  D8D&D+  BTG(brZk G0@	@ b#?@4G  B4G( bQZk0 ¤G@@ B  'GzZk"G@ B zZkP BGb{Zk  y H8JG  ! b#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G
tZk ?"tG  8 B "@ b  DHZktGB#"b "BBLZkTG( B  "0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "G-LZk? TG  H #"ӣ@@  8DD BburZk4G4GBbRQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "GLZk'? TG   #"S@@  8DD BbMrZk4G4GBb*QZkx "( BTG0 b  %sZk ?"tG8 B  D "@ b\HZktGBb #" "GKZkTG   #"@נ@8DD
 "Bb  &rZk4G4GBbQZk"( BTG0 b  %sZk ?"tG8 B  D "@ b5HZktGBb#" "GKZkTG@"( B0 b  %ksZk ?"tG8 B "  D@ b HZktGB#"b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  Bb7{Zk4G Bb"zZkGBb;{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bzZkG@ BH b{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 b|qZkGtG0 Bh$"  8 buqZkGtG0 B   $"8 bnqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~  ( 0 ޴8 @ H >P ^X GGCG(  GGTGG @Q?Bq1B@ !( 1! Q"GGG8b#\ @GG
G @b#_GG
G @pb#@ @0@GA G	GA  &1@G ] ] G }  ( 0 ݤ8 @ H =P ]X ` #kG#  ( ;G  ~G ^G0 [ 8 {GxZkG ]   #k#0v J  ~4G ^  [ G( {:yZkG ]   #kG  G >G ޢ  tG    4G    TG         k#4G  ~@ ^H ^P ~X ` GG#8 =8 BG< }G@ b JZkGpb }"B =  ]"c  "ZyZkGG  >TG( BG >G >G ^_"  ~0 b( NxZk4G8 B< G@ blJZktG
 hp#"xBGb   pZk G+ G GhB0vH  RRH
  xB Cb CG#"GpZk  v H v H GRHh#" CXCF    xBbtGpZk G	 G2 },2   ="b#C dH  d<8  @G@ ]H ]P }X ` p #kp#  ~` ^h ^p ~x   GGX  #  ,G"DHHXD    "TG1"5ø"D" TG  1"- , # "DHHD    "TG1"!8DXD  xD  D    C. c# "   CJaF` . " JXF 
 .
 " JXF  / KX'G   C/ [KeG ` #, #. P0HQ$JJ'J BP B B1 Bq"D = `,BD = .	 ## /
 c#	 C/? VJYKJ'KW B6J[[KwB 9CgK7BY 9C B ;C;aCL } . C" c.
 #" #RJSqJGJgJ RBR RB SB3`B8 } . #  C/ " c"XJZCKKGK CX C C:@C4 ] #/ " , "_#Y!KPH'KJ 9CY 9C 0C9 C0 = C. ?$ .@B!  /$SSJD VJgJJT B3`JXKtB BK4tBV B B B:C AO l  p F:DCG      @J
    F2QBUN֤JF5BW B5JwB7B7B J  ¦GF4BNJF6B BXC67JxC8B8B   G4G$ Ha!@$@ @   D/< }4GZ@KGK
zC `    $. "  <  "  d.U5J0@BVvJJJ5B
B< 
     D#  ,6B< ݲ0@BZHGK
B_L =21@B@ ]4 1"+  8 }}B?"8 Fs"% `0 B8FF  Bb  GwZk $@B GU@H B6WHuB6B8C O "G]yZk8 BG 0 ="X  }"@ bGGSZk@ G%"BTGb  ;oZk  %" TGB  b  G/oZk  ( %"GtGBb(oZk GG` ]h ]p }x    #k#4G  ~ ^ ^ ~   ޴ GGG    XB `bGopZk "T G4GXB`b GepZkTGXB " #`b_pZk CB    GXB( "`b4GUpZkTGtGBbG "aZkTGXB`b" ="HpZk4GXB`b8 "CpZkTGtGBb E"@ "aZkTGXB`b"@ ="6pZk4GXB`bH "1pZkTGtGBb  E"x "`ZkTGXB`b"x ="$pZk4GXB`b"pZk 0@0  @X "XB4G`bpZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb`ZkTG xB ="b"oZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =8G0@Bh Hb  GsnZkTG@B@ %"  HbmnZktG0 "h %"@B    AHbenZktG" %"@B    AHb]nZkTGtG  B( b "G`ZktG@B   %"Hb ]"OnZkTGtG  B@ ] "( bv`ZktG@B   %"Hb ]"AnZkTG@B %"  Hb;nZkGH ]P ]X }` h p  #k#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bDCZkG@ BH bG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXb{Zk4G  BG( bTDZkGpBxbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( b@ZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( blZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =n{ZkTG  B =G( bWZkG BbGq{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBbL{Zk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `                                                                                                                                                                                                                                                   $                        )
0 $      DCEAXPMUPA013.A                9  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;2                                                                               L                         y "     )       p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4GGZkG0BG8b({ZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D   4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]zZktG  BG = ]( b6CZkG`BhbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =zZkTG  B =G( b&tZkGBbGzZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBbzZktGPB8  0  @8 =XbG#oZkGBb zZk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb =zzZkTG  B =G( bFZkGBbG}zZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb =XzZkTG  B =G( bIZkGBbG[zZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }4zZkG  B =G ] }( bKZkG@BHbG5zZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]zZktG  BG = ]( bsZkGpBxbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]yZktG  BG = ]( b*zZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b~ZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }yZkG  B =G ] }( b8AZkG BbGyZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b@ZkG0B8bGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHbcyZk4G  BG( bCZkG`BhbGgyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbCyZk4G  BG( b$XZkGBbGGyZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBb yZkTG B0  0  @(bG
oZkGBb !yZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBbxZk4G  BG( blKZkGBbGyZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =xZkTG  B =G( bOZkGBbGxZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(bxZk4G  BG( bZBZkG@BHbxZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =xZkTG  B =G( biZkGpBxbxZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxb|xZktGB8  0  @8 =bG1oZkGBb |xZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbZxZkG  B( boZkGBbG_xZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb;xZk4G  BG( boZkGBbG?xZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG BbxZk4G  BG( bXZkG B(bGxZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =wZkTG  B =G( bNPZkGPB#HXbgHwZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`BhbwZktG  B8  0  @8 =( bG[lZkGBb wZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBbwZkTG( B0  0  @0 bGmZkGBb wZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbwZktG  B8  0  @8 =( bGAnZkGBb wZk G ] ]  ` #k                                                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (                                                                                                                                                                                                                                                           %                        ( $      DCEAXPMUPA013.A                9  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_SPEC.EXE;2                                                                               L                         5 "     :       TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                     T               T       t           	                              (                     @                       0  @  P  p              0  @          0                     @   P      (      0      p          0  @    p      P          @         	  p	  	  	   
  0
  `
  
  
  
     p         0  `                         p                         
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        &                        J G $      DCEAXPMUPA013.A                	9  >  6[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_START.COM;2                                                                         ]                              P             6 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_START.COM;2 +  , 	9   .     /  @   4 ]                           - >    0   1    2   3      K  P   W   O 
    5   6 vKl  7    8          9          G  @  H   J                          $ ! D $ !	DTSS_TP_START.COM - Procedure to start the DCE/DTS Time Provider $ !  $ !  $ ! TO RUN:  $ ! D $ !     command line parameters can be passed or logical names used.& $ !	"usage: dtsprovider -d device-name? $ !        [-p pollrate, range 30 : 3600 default 120] (seconds) H $ !        [-i milliseconds of inaccuracy, range 10 : 10000, default 30]% $ !        [-t timestamps, default 4] G $ !        [-c disallow clock set, range 0(false) : 1(true), default 0] A $ !        [-o output trace, range 0(false) : 1(true), default 0]  $ !  $ ! ; $ !	Four logical names are translated at program start from C $ !	the system logical name table which control the characteristics 4 $ !      of the time provider's operation, they are: $ !  $ !	Logical name		< $ !	  DTSS$_TP_DEVICE :   Device to which provider attached.D $ !              This is usually an RS232 port to which the providerE $ !              radio is attatched.  The terminal characteristics of C $ !              the port must be set using the 'set term/perm' DCL H $ !              command.  Each provider type requires specific settingsL $ !              which are documented in the provider specific documentation# $ !              in the code below.  $ ! ' $ !           Format: Any ASCII string.  $ ! ; $ !	  DTSS$_TP_INACCURACY  :   Systematic inaccuracy in ms. D $ !              Each radio clock specifies the amount of systematicC $ !              inaccuracy which is returned with each time-stamp. D $ !              This is usually proportional to the number of milesG $ !              the device is physically located from the transmission J $ !              center from which time is read.  The inaccuracy specifiedH $ !              by this parameter is added to the times returned to the $ !              time server.  $ ! - $ !           Format: a non-negative integer.  $ ! A $ !	  DTSS$_TP_POLL_RATE   :   Rate in seconds that the device is F $ !              polled.  This value will override the DTSS management9 $ !              parameter 'synchronization hold down'.    $ ! L $ !           Format: an integer (seconds) in the range 1 second to 31 days; $ !                           C $ !	   DTSS$_TP_TIME_STAMPS :   This parameter specifies the number B $ !              of timestamps which are read and returned to the 5 $ !              time server at each synchronization.  $ ! 6 $ !           Format: an integer in the range 1 to 6;  $ ! / $ !     The following two are not implemented    $ ! C $ !         DTSS$_TP_MAXERROR : If the difference between the time  @ $ !              provider and the local clock differs more than F $ !              maxerror, then the timeprovider is considered faulty,. $ !              and its timestamp is ignored. $ ! 7 $ !           Format: a non-negative integer (seconds).  $ ! @ $ !         DTSS$_TP_FIRSTSYNC : If this value is TRUE, then theC $ !              DTSS$TP_MAXERROR parameter is ignored on the first ! $ !              synchronization.  $ ! 1 $ !           Format: 0 , false;  otherwise TRUE.  $ ! 6 $ !         DTSS$_TP_VERBOSE : Display info to std out $ !         / $ !           Format: 0, false; otherwise TRUE.  $ ! E $ !      This is an example session, only setting the dtss$_tp_device 6 $ !      logical is required, all others are optional: $ !  $ ! @ $ ! set the terminal characteristics.  The exact characteristicsC $ ! are specific to the external device.  Important characteristics < $ ! to consider are buad rate and parity.  After setting the> $ ! terminal characteristics, set host _TTA3:/dte, can be usedA $ ! to test the external device and the terminal characteristics.  $ ! C $ !      set DEVICE equal to the device name for the time provider.  $ device    = "TTA1:" + $ write sys$output "Default - device TTA1:"  $ ! B $ !      set this to the brand id for the time provider being used! $ !             Spectracom = SPEC " $ !             Psti       = PSTI # $ !             GC1000     = GC1000 ! $ !             Traconex   = TRAC ! $ !             Hopf       = HOPF  $ tmbrand   :=  spec $ ! ( $ procedure = f$environment("PROCEDURE")P $ path      = f$parse(procedure,,,"DEVICE") + f$parse(procedure,,,"DIRECTORY")   $  $ ! : $ ! now define the time provider logicals, only the device/ $ ! name is required or pass them as parameters  $ ! ] $ if (F$mode() .NES. "INTERACTIVE") .or. (F$edit(P1,"upcase") .EQS. "DEBUG") then goto pass_1  $ ! - $ ! run the provider detatched at priority 10  $ !  $ ' $ run sys$system:loginout.exe /detach -          /input = 'procedure -          /priority=10 -'         /process_name=DCE$DTS_PROVIDE - :      	/output=dce$local:[var.adm.time]dce$dts_tp_out.log -7     	/error=dce$local:[var.adm.time]dce$dts_tp_err.log  J $ write sys$output "Output/Error log location -> DCE$LOCAL:[VAR.ADM.TIME]" $ !  $ exit $ ! 	 $ PASS_1: C $ ! define DCE$DTS_TP_DEVICE       'device	! your device - required ? $ ! define DCE$DTS_TP_TIME_STAMPS  4		! read 4 times each synch > $ ! define DCE$DTS_TP_POLL_RATE    30		! synch each 30 seconds= $ ! define DCE$DTS_TP_VERBOSE      1		! Verbose output to log  $ 1 $ set term 'device /passall/pasthru/eightbit/perm ; $ mcr 'path'dce$dts_provider_'tmbrand -d 'device -t 4 -p 30  $! $ exit                                                                                                                                                                                                                                                                                                                                                                                               5 * [SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2 +  , 8   . L    /  @   4     L   K                     - >    0   1    2   3      K  P   W   O M    5   6 P  7 Ȓ   8          9          G  @  H   J              
                   L    h                                                  (   ~              0       P                                                                          DCE$DTS_PROVIDER_TRAC                  DCE V1.3-950305T10-58               $             
               $             
               $    <                         $    .            1             $                             $             J   H             $    (                       8                         DCE$LIB_SHR_001      8    $                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8    ,                    DECC$SHR_001         4    "                     
LIBOTS_001       @                       w'SYS$PUBLIC_VECTORS_001             0          0                                           `              0     X                     P                          0     (     0                                                                                                           `     P                                               0                        0          P                                   
     &              '                    0         @      <               @                                  `     
                p      
              0(         `      |       
                                                                    
     0                                                                             @      @                                 `      0         P                                    @                                                                                                                                                                                                             '                        } $      DCEAXPMUPA013.A                8  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2                                                                               L                         o "            @              
                                                         0     0     0                            0H     &            <       @                     0@     h&     `              0     $            |       0`                 <       >
ף                                      00     0     `       <                                             0                          0              0(          @              p                                           0     0     `             0          0              0              0          @              0          0              0     0(     0              P              9                            0     9     `                            P       0      9     `                                    0     8     `                            0      8     0              `              0     7     0                            0      7     0              P              0     6     0              @              0     5     `              0     p5     0                            0     4     0                            0     p4     0                            0     3     0                            0     `3     `              0     2     0              @              0     `2     0                             0     1     0                            0     H1     @                            0     0     0                            0     80     0                            0     /     0              p              0     /     @              `              0     .     0              P              0      .     0              @              0     h-     `              0     ,     0                             0     P,     0                            0     *     0                           0     0*     0                             0     )     0                            0     0)     0                            0     (     0               :                                                                                                                                                                                                                                                                                                                                                                               ` TRUE    FALSE   TRUE    FALSE   %d      %d      %d      %d      %d      %255s   %d      %d      %d      %d      %d      

      %s	     DCE$DTS_TSTP_MBX        DCE$DTS_TPTS_MBX        DCE$DTS_TP_DEVICE       DCE$DTS_TP_INACCURACY   DCE$DTS_TP_POLL_RATE    DCE$DTS_TP_TIME_STAMPS  DCE$DTS_TP_MAXERROR     DCE$DTS_TP_FIRSTSYNC    DCE$DTS_TP_VERBOSE      DCE$DTS_PROVIDER        LNM$PROCESS_TABLE       The time stamp value is out of legal range
     Legal Range is %d to %d
        PARAMETERS SET:
        TP_DEVICE:		%s
 TP_INACCURACY:      %d seconds
 TP_POLL_RATE:       %d seconds
 TP_TIME_STAMPS:     %d timestamps
      TP_MAXERROR:        %d seconds
 TP_FIRSTSYNC:       %s
 TP_VERBOSE:         %s


       dtsprovider: init radio clock   %s - %s
        Unable to register interface for TPP    %s - %s
        TPP unable to register protocol sequences       %s - %s
        Can't inquire bindings  %s - %s
        Can't inquire bindings  %s - %s
        Can't bind to string    Got binding: %s
        Spectracom Time Provider        %s - %s
        Can't register with endpoint mapper     %s - %s
        Can't get machine's host name   %s - %s
        Can't register authentication   Listening for connections ...
  %s - %s
        RPC listen terminated abnormally        Executing ContactProvider ...
  Executing ServerRequestProviderTime ...
        Reply written :
        -o:Output value is out of legal range
  -c:Clockset value is out of legal range
        -p:Pollrate value is out of legal range
        -i:Inaccuracy value is out of legal range
      -t:Time stamp count is out of legal range
      


Enter the Device Name:       Enter the Poll Rate in Seconds[%d]:     -p:Pollrate value is out of legal range
        Enter the Inaccuracy[%d(ms)]:   -i:Inaccuracy value is out of legal range
      Enter the Timestamp Count[%d]:  -t:Time stamp count is out of legal range
      Disallow clock set[%d(Y:1,N:0)] :       Output Trace [%d(Y:1,N:0)] :    dtsprovider: cannot delay       usage:	dtsprovider -d device-name
      		[-p pollrate, range %d : %d, default %d]
     		[-i milliseconds of inaccuracy, range %d : %d, default %d]
   		[-t timestamps, range %d : %d, default %d]
   		[-o output trace, range 0(false) : 1(true), default %d]
      M_TRAC: QIO Status failure %x
  M_TRAC: IOSB Status failure %x
 M_TRAC: Bytes Read: %d
 M_TRAC: response length failure %x
     dtssprovider: Traconex out of spec
     dtssprovider: Traconex hardware fault
  dtssprovider: Traconex signal fault
    dtssprovider: Traconex time not available
      dtssprovider: Traconex year mismatch
   dtssprovider: radio clock fault
        time returned - %d %d:%02d:%02d.%09d
   K_TPI_FAILURE
  ******************************************
     K_TPI_SUCCESS
  Time Stamps   : %d
     Before Time	:   
TP Time		:     
After Time	:   ******************************************
     
!!!!!!!!! DTSS: EXTERNAL TIME SOURCE IS FAULTY !!!!!!!!!
      The external time did not validate
     Synchronization Count: %u
      Error Tolerance:       %u
      System Time:           %s
      External Device Time:  %s
      
!!!!!!!!!!!!!!!!!!
    		[-c disallow clock set, range 0(false) : 1(true), default %d]
                 03QU0000                                                                                                                                                                                                                                                                        8                                                             x                h                        <                                                                                                 P                                                                                                                                                                                                                                                                                                                         Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #4G  ~ ^  ^( GG#  B     =  >  ( b :iZk =Hb# @pB4GxbGVZkG ]  ]( 0 #kG# $  ~   (^ ?&0^4G8~@HP޴XGG P B( "  =   = X b =AZk4GG  0B8bVZkb  "   "BGbGGG1CZk4G
   =0 B8 b!&H&HC( 0.Q 0J( 0>( "xQZk"  B  "B "bGGGCZk4G)   =0 B8 b!&H&HC( 0.Q 0J( 0>( "`QZkTG C B"?B8@FQF   @(¤ 0B 8b  GwZk4GGG0B0 &"  8bwZk4G4G0B8bxVZkB  "B "bGGGBZk4G
   0 B( "8 b%HHC( &,A &H( &<,QZkH  B  "b "GGGGBZk4G
   ݠ0 B( "8 b&HHC( e,C eH( e<QZkb  B  "b "p BGGGBZk4G
   0 B( "8 b%HHC( f,C fH( f<PZkb  B  "b "` BGGGBZk4G   0 B( "8 b%HHC( f,C fH( f<PZk@ b@¤   C  fB  "B "bGGGBZk4G
   0 B( "8 b%HHC( ,F H( <PZkh b  ( ,  "B "BGF Hb( <GGgBZk }
  PB( ="@#fHfHC( ,F H( <ZkG(]0]8}@HPݤX`#kG# G  ~^^ ~޴ (0>8@GGG"GG   tG@¤Gh"b#    X `⤸8"  &4G  G     '    )_ 	  XB8VZk  b#@pb#@    GGb#@ bTG(Bc 0b  GvZktG(B #"  0b8BvZktG(B  ( #"  F0bvZktG(BH #"    D0bvZktG(B  h #"  E0bvZktG(B #"    H0bvZktG    (B(   D0b #"GvZktG  )0 8 (B   #"%E0bGzvZk $`   GH BP bG~Zk                                                                                                                                                                                                                                                   (                        } $      DCEAXPMUPA013.A                8  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2                                                                               L                         ^Y "            ?"G LH BP b(AG~Zk &@B"I@'WHi)A)@)	A  & 4M / . " 5"XKWJ ?  > ! 5,p E ,pFA5H 5<DH <   u. U.SqJRQJ q>  Q> , u/GH[uK < u?     BGG"Gb}ZkG  BbZk4GB "bZkGBbZk4G(B< 0bUZkh B@ "p b< ="TGbZkG8 BC"b@ ="  < }"{lZktG< P="  ( B0 b, ]"%FZkGBbcZkG(B#"  C"0bP}"uZkGBbeZk4G4G(B0bTZkB< ="b4GTG\uZktG< ="  ( B( ]"0 bFZkGBb@ZkG(B  @#"0bPC"}"uZkGBbBZk4G4G(B0bTZkB4 "b< ="TGKsZktG<   ( B0 b="$ ]"EZkGBbZkG(B  #"0bC"}"uZkGBbZk4G4G(B0bTZk8G  f BbZkTGB4 "b< ="!sZktG<   ( Bp="0 b  ]"EZkGBb~ZkG(B#"  C"0bp}"uZkGBb~Zk4G4G(B0bhTZk4   C8  	GG4 ݠ =" B< ]" btG@ SZktG< ="  ( B0 b ]"EZkGBb~ZkG(B#"  C"0b}"cuZkGBb~Zk< ݠ#"  tG (B ]0bVuZkB "b< ="TG>JZk4 ݠ	0 A@  Ơ&ABGb~Zk Bc"  < "4 =G bGbZktG< 0="  ( B0 b ]"OEZkGBb~ZkG(B0#"  @C"0b0}")uZkGBb~Zk4G4G(B0bTZkB4 "b< ="TGPZkGtGx B0 =" b8 ]"uZktG8 =" ]"  ( B0 b%EZkGBbc~ZkG(Bh#"  xC"0b}"tZkGBbe~Zk4G4G(B0bSZkB< "0 4GbGGG=]ZktG<   ( B ="0 b ]"DZkGBb=~ZkG(B#"  C"0b }"tZkGBb?~Zk4G4G(B0bSZk  G
 Bb&~ZkTG(B  #"0btZkGBb*~Zk B< =" b4GTGsZktG< P =" ]"  ( B0 bDZkGBb
~ZkG(B  #"0bC"P }"tZkGBb~Zk4G4G(B0bSZkG]] 4G }ݤ (0=8@P#kq Ep E  &vHpFI7IB	6E Ƣ  &HVJF ƲA?qFpF  yHDH BD !  HY0K$G !4G# G  ~G( ^G0 ^tG8 GG "  B( b\ZkTG  0 B8 b " ="_ZktG  @ B "H b =" ]":UZk   BGb4G.SZk8""  !      1C5 @B D  1DG( ]0 ] G8 @ #k#G  ~ ^ ^  ~( GG ]PG     Bb}ZkTG08"@B   Hb01"tZkGBb}Zk 4GB       R C      G ] ]  }( 0 #kG#G  ~ ^ ^  ~( 0 GG ]Gp    BbP}ZkTGPX"`B   hbP1"sZkGBbR}Zk G"b#    #     1y@G@     Bb3}Zk4GXBb"7uZkGxb#|@BGb4}Zk   G ] ]  }( 0 @ #k#  ~ ^ ^ ~  ( 0 ޴8 @ GG GG  4G_P@4G  Р  &. &J%F   ,  BbPHJ
dZk&u@7@ \@8  k0@	@  b#@4G  B4G( brRZkF@B0BtG  ¤bP G0MZk 8 D  "H&" BTG(b  }sZk 0@	@ b#@4G  B4G( bTRZkF@BbtG  ¤` BX GMZk 8 D  "h&" BTG(b  _sZk 0@	@ b#@4G  B4G( b6RZkF@BtG  ¤` bGGLZk"  Ơ 8 D"@@D8 F0Dx   B  '"(bTG9sZkj 0@	@ b#@4G  B4G( bRZkG@8 ¤BtG  bGh GLZk'"  Ơ 8 D"S@@D8 F0DR   B  '"(bTGsZkD 0@	@ b#e@4G  B4G( bQZkG@¤BtG  bGp GLZk  Ơ 8 D'"@@  D8D&D+  BTG(brZk G0@	@ b#?@4G  B4G( bQZk0 ¤G@@ B  'GzZk"G@ B zZkP BGb{Zk  y H8JG  ! b#$@  B4G( b4GQZk0@	@G ] ] }  ( 0 ݤ8 @ P #kG#4G  ~^^~ (0GGb( B0 bc G
tZk ?"tG  8 B "@ b  DHZktGB#"b "BBLZkTG( B  "0 b  %sZk ?"tG8 B  D "@ bHZktGBb #" "G-LZk? TG  H #"ӣ@@  8DD BburZk4G4GBbRQZkx "( BTG0 b  %sZk ?"tG8 B  D "@ bHZktGBb#" "GLZk'? TG   #"S@@  8DD BbMrZk4G4GBb*QZkx "( BTG0 b  %sZk ?"tG8 B  D "@ b\HZktGBb#" "GKZkTG   #"@נ@8DD
 "Bb  &rZk4G4GBbQZk"( BTG0 b  %sZk ?"tG8 B  D "@ b5HZktGBb#" "GKZkTG@"( B0 b  %ksZk ?"tG8 B "  D@ b HZktGB #"b "GKZkG]]} (0@#k#4G  ~ ^ ^  GG  "  B( b ZkG  Bb7{Zk4G Bb"zZkGBb;{Zk 4G G GG ] ]  0 #kG#G  ~ ^ ^ ~  GGG  B( b{Zk4G0 BG8 bzZkG@ BH b{ZkG ] ] }  0 #kG#TG  ~ ^ ^ ~  ( GG  b( 0 B  8 bGqZkG"G0 B( $"  G8 bqZkTG'"0 BX $"  G8 bGqZk4GGG0 B $"  G8 b|qZkGtG0 Bp$"  8 buqZkGtG0 B   $"8 bnqZkG ] ] }  ( 0 #k#  ~ ^ ^ ~  ( 0 ޴8 @ H >P ^X GGCG(  GGTGG @Q?Bq1B@ !( 1! Q"GGG8b#^ @GG
G @b#_GG
G @pb#|@ @0@GA G	GA  &1@G ] ] G }  ( 0 ݤ8 @ H =P ]X ` #kG#  ( ;G  ~G ^G0 [ 8 {GxZkG ]   #k#0v J  ~4G ^  [ G( {:yZkG ]   #kG  G > ޢ  tG  G  2G  S4G  G         kG#4G  ~0 ^8 ^@ ~H P X GG#8 BG( =G, }@ b JZk4G_"p     TG  G( B =    > }"  G( G0 bGGGMxZk4G8 BG, @ bkJZktG	 `hxB0$"bG   pZk G,  }P$"tG0v`H  hxB Cb  EGGpZktG p$"xB  R Hb CpZk %vH vH R`Hh$" CXAF    xBbtGpZk G G(  ="b#
 @G0 ]8 ]@ }H P X ` #kGp#4G  ~` ^h ^p ~x   GG#X  #   , #" .GAHQJ'H'J$&@ D%&B  8B@b"qZk G GD  8B@b4G"qZk G D  8B@b4G"qZk G D  8B@b4G "qZk G PD 8B@b4G0"qZk G  , #  . #" .0_"DHQJH'J$׀H & @ "12B@Bs" 3NUJ #J c#5B0 D .DXJK8C4  C/[[KgKG;fC8 }
  aG aC  8 = GaGF8 } .	 C# #/XJZ:KKGK8 K C:RCL ]	 #,
 c C#HgHd@D }p`D ` %@cH
   pD10B4NքJF4BU B4JuB5B5u@ cH  GvD;vCwOeKvG;vC {CY?C;7aKy9C;yC;{@ ` 4G2 KxC8XB @ 8  ,< ]4GAH'H
AC @ #  . " #<  8#  .TJ0 BYJJ'K7B
B< 
 ` # 8   ,9B< =0 BAH'H
!C?L 11 B@ =4 }"
  8 ݢ}g@8`D" 0 B8FF b%"BTGb  oZkGB%"  0 4 8 }L ]b  {oZkb?"Bb  cGwZk &@B"GE@H B4WHe@4B4t@ N "GuyZkG8 B 0 ="X  }"@ bGGSZk@G` ]h ]p }x    #kG#4G  ~ ^ ^ ~   ޴ GGG    XB `bGpZk "T G4GXB`b GpZkTGXB " #`bpZk CB    GXB( "`b4GpZkTGtGBbG "JaZkTGXB`b" ="|pZk4GXB`b8 "wpZkTGtGBb E"@ "8aZkTGXB`b"@ ="jpZk4GXB`bH "epZkTGtGBb  E"x "&aZkTGXB`b"x ="XpZk4GXB`b"SpZk 0@0  @X "XB4G`bIpZkG ] ] }   ݤ  #kG#G  ~TG@ ^tGH ^P GG "Bb`ZkTG xB ="b")pZkG@ ]H ]P ` #kG#TG  ~H ^P ^X ~` h p GG@ =8G0@Bp Hb  GnZkTG@B@ %"  HbnZktG0 "h %"@B    AHbnZktG" %"@B    AHbnZkTGtG  B( b "G`ZktG@B   %"Hb ]"nZkTGtG  B@ ] "( b`ZktG@B   %"Hb ]"unZkTG@B %"  HbonZkGH ]P ]X }` h p  #k#G  ~ ^ ^ ~  GGG  B( b#|Zk4G0 BG8 bxCZkG@ BH bG'|ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGPBXb|Zk4G  BG( bDZkGpBxbG|ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( bAZkGBbG{ZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBb{Zk4G  BG( blZkGB                                                                                                                                                                                                                                                   )                        }| $      DCEAXPMUPA013.A                8  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2                                                                               L                          "     (       bG{ZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb ={ZkTG  B =G( bWZkG BbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  ( GGGBb{Zk     .  , @"  . JA
 H 2J0D CHF	C_B01 B rF `p D)      / y/ Y/ 9  Y"aKZ
AKp@F[G C ;"*    2  ;/ {#[;KgKGG G  BG( b4G{ZkG0BG8b\{ZkG ] G ] }  ( 0 #kq Dp D  բwJVJ CF   ղJWJF q@Fp@F  p4J@HB D   4JPJ F G#G  ~ ^ ^  ~( GG =@BGHb ]{ZktG  BG = ]( bjCZkG`BhbG{ZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGpBxb =zZkTG  B =G( bZtZkGBbGzZkG ] G ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGBbzZktGPB8  0  @8 =XbGWoZkGBb zZk G ] ]  ` #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( b<FZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GGGBb =zZkTG  B =G( bIZkGBbGzZkG ] G ]  }( 0 #kG#G  ~ ^  ^( ~0 GG = BG ](b }hzZkG  B =G ] }( bKZkG@BHbGizZkG ] G  ]( }0 @ #kG#G  ~ ^ ^  ~( GG =PBGXb ]CzZktG  BG = ]( bsZkGpBxbGEzZkG ] G ]  }( 0 #kG#G  ~ ^ ^  ~( GG =BGb ]zZktG  BG = ]( b^zZkGBbG!zZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b~ZkGBbGzZkG ] G ] }  0 #kG#G  ~ ^  ^( ~0 GG =BG ]b }yZkG  B =G ] }( blAZkG BbGyZkG ] G  ]( }0 @ #kG#G  ~ ^ ^ ~  GGGBbyZk4G  BG( b6@ZkG0B8bGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG@BHbyZk4G  BG( bCZkG`BhbGyZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGpBxbwyZk4G  BG( bXXZkGBbG{yZkG ] G ] }  0 #kG#G( >  @ hG  ~G ^ ^  GGBbTyZkTG B0  0  @(bG>oZkGBb UyZk G ] ]  ` #k#G  ~ ^ ^ ~  GGGBb3yZk4G  BG( bKZkGBbG7yZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGGBb =yZkTG  B =G( bBOZkGBbGyZkG ] G ]  }( 0 #kG#G  ~ ^ ^ ~  GGG B(bxZk4G  BG( bBZkG@BHbxZkG ] ] }  0 #kG#G  ~ ^ ^  ~( GGGPBXb =xZkTG  B =G( biZkGpBxbxZkG ] ]  }( 0 #kG#G( >  @ hG  ~G ^ ^  GGpBxbxZktGB8  0  @8 =bGeoZkGBb xZk G ] ]  ` #kG#G  ~ ^ ^ ~  GGBbxZkG  B( b*pZkGBbGxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGGBboxZk4G  BG( b*pZkGBbGsxZkG ] G ] }  0 #kG#G  ~ ^ ^ ~  GGG BbOxZk4G  BG( bYZkG B(bGSxZkG ] G ] }  0 #kG#G  ~ ^ ^  ~( GGG0B8b =.xZkTG  B =G( bPZkGPB#HXbgH0xZkG ] G ]  }( 0 #k#G( >  @ hG  ~G ^ ^  GG`Bhb
xZktG  B8  0  @8 =( bGlZkGBb 
xZk G ] ]  ` #kG#G( >  @ hG  ~G ^ ^  GGBbwZkTG( B0  0  @0 bGmZkGBb wZk G ] ]  ` #k0 #G( >  @ hG  ~G ^ ^  GGBbwZktG  B8  0  @8 =( bGunZkGBb wZk G ] ]  ` #k                                                                                                                                                                                                                                                                                                                                                                                                                                                                      e         -  (   -                        {            @  (p  0  8  @  HD  Pv  X  `  h  p*  xX        2	  `	  	  	  	  ,
  Ȁb
  Ѐ
  ؀
    耕:  j           @   n  (  0  8$
  @Z
  H
  P
  X  `L  h  p  x  ,  f        P        ȁ6  ЁX  ؁|    聕       (  N  n       (  0  88  @X  Hx  P  X  `  h  p(  xH  h          J  |    (  0&  8p  @  H  P  X  `J  h  p  x   `    >  h    F  |      ȃJ  Ѓ  ؃    胕       :  n    Ȅ  Є  ؄B  H  P  X"   `Z   h   p   x!  j!  !  !  "  ^"  ~"  "  "  #  Ȇ`#  І#  ؆#  $  膕F$  v$  $   $  $%  d%  %   %  (0&  0x&  8&  @'  H`'  P'  X'  `'  h(  p@(  xl(  (  (  ")  T)  )  )  *  J*  h*  p*  x&+  h+  +  +  b,  ,  .        NORMALnormal successful completion 8        ADVERTISEMENT_TAdvertisement Interval!_!_!AS 2        CHECK_INTERVAL_Check Interval!_!_!_!AS 0        EPOCH_NUMBER_TXEpoch Number!_!_!_!AS 2        ERROR_TOLLERANCError Tolerance!_!_!_!AS<        
TIME_DIFF_TXT#Local Time Differential Factor!_!AS 4        MAXIMUM_INACCURMaximum Inaccuracy!_!_!AS 2        SERVERS_REQUIREServers Required!_!_!AS 2        QUERY_ATTEMPTS_Query Attempts!_!_!_!AS .        LAN_TIMEOUT_TXTLAN Timeout!_!_!_!AS.        WAN_TIMEOUT_TXTWAN Timeout!_!_!_!AS2        	SYNCH_TXTSynchronization Hold Down!_!AS&        VARIANT_TXTType!_!_!_!_!AS .        SERVER_NAME_TXTServer Name!_!_!_!AS0        COURIER_ROLE_TXCourier Role!_!_!_!AS 4        BACKUP_COURIER_Acting Courier Role!_!_!AS8        CLOCK_ADJUSTMENClock Adj. Rate (NS/Sec)!_!AS >        CLOCK_DRIFT_TXT#Max. Clock Drift Rate (NS/Sec)!_!AS .        DNA_VERSION_TXTDNA Version!_!_!_!AS0        DECDTS_VERSION_DTSS Version!_!_!_!AS 8        TIME_REP_TXT Time Representation Version!_!AS 0        SERVICE_TRACE_TService Trace!_!_!_!AS4        COMM_TRACE_TXTCommunication Trace!_!_!AS 6        SYNCH_TRACE_TXTSynchronization Trace!_!_!AS2        ARITH_TRACE_TXTArithmetic Trace!_!_!AS 8        LOCAL_SERVER_TXLocal Server Directory!_!_!AS 8        GLOBAL_SERVER_TGlobal Server Directory!_!_!AS6        TP_PRESENT_TXTTime Provider Present!_!_!AS 0        NEXT_TDF_TXTNext TDF Change!_!_!_!AS 0        AUTO_TDF_TXTAuto TDF Change!_!_!_!AS .        CURRENT_TIME_TXCurrent Time!_!_!AS          UID_TXTUID!_!_!_!_!AS4        LAST_SYNCH_TXTLast Synchronization!_!_!AS$        	STATE_TXTState!_!_!_!_!AS.        CREATION_TIME_TCreation Time!_!_!AS>        LOCAL_FAULT_TXT#Local Times Not Intersecting!_!_!AS >        FAULTY_SERVER_T$Server Times Not Intersecting!_!_!AS:        DIFFERENT_EPOCH Different Epochs Detected!_!_!AS6        TOO_FEW_TXTToo Few Servers Detected!_!_!AS 8        TOO_MANY_TXT Too Many Servers Detected!_!_!AS >        PROTOCOL_VERSIO#Protocol Mismatches Detected!_!_!AS B        
TIME_REPS_TXT*Time Representation Mismatch Detected!_!AS:        INVALID_MESSAGE Invalid Messages Detected!_!_!AS:        
NO_GLOBAL_TXT!No Global Servers Detected!_!_!AS :        NOT_RESPONDING_Servers Not Responding!_!_!_!AS 2        
CLOCK_SET_TXTClock Settings!_!_!_!_!AS :        EPOCH_DECLARATIEpoch Change Completed!_!_!_!AS :        SYSTEM_ERROR_TXSystem Errors Detected!_!_!_!AS <        SYNCH_COMPLETED!Synchronizations Completed!_!_!AS 4        UPDATE_COMPLETEUpdates Initiated!_!_!_!AS<        STARTUP_                                                                                                                                                                                                                                                   *                        r $      DCEAXPMUPA013.A                8  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2                                                                               L                         g* "     9       COMPLET"Enable Directives Completed!_!_!AS>        SHUTDOWN_COMPLE#Disable Directives Completed!_!_!AS @        INSUFFICIENT_RE&Insufficient Resources Detected!_!_!AS@        TIME_PROVIDER_T&Time Provider Failures Detected!_!_!AS2        LAST_OBSERVED_TLast Observed Time!_!AS 4        LAST_OBSERVED_SLast Observed Skew!_!_!AS "        TYPE_COURIER_TXCourier $        TYPE_NONCOURIER
NonCourier(        TYPE_BACKUPCOURBackup Courier        TYPE_STATE_ON_TOn        TYPE_STATE_OFF_Off (        TYPE_STATE_SYNC
Synchronizing "        TYPE_STATE_UPDAUpdating&        TYPE_STATE_CREANot Created          TYPE_VARIANT_SEServer         TYPE_VARIANT_CLClerk         TYPE_BOOLEAN_TRTRUE         TYPE_BOOLEAN_FAFALSE &        KNOWN_SERVER_1
Known ServersF        KNOWN_SERVER_2-=============================================         TYPE_SERVER_GLOGlobal         TYPE_SERVER_LOCLocal 0        NOT_USED----------Not Used---------- $        TYPE_TRANS_IEEE
IEEE 802.3         TYPE_TRANS_UDPUDP/IP          TYPE_TRANS_TCPTCP/IP         TYPE_TRANS_RPCRPC         TYPE_TRANS_DECDECnet          TYPE_TRANS_UNKN??????,        
KS_LTP_TXT!_Last Time Polled!_!AS.        
KS_LOT_TXT!_Last Observed Time!_!AS.        
KS_LOS_TXT!_Last Observed Skew!_!AS.        	KS_LS_TXT!_Used in Last Synch!_!AS ,        KS_TRANSPORT_TX!_Transport!_!_!AS2        LAN_RESPONSES_TLAN Responses!_!_!_!_!AS2        WAN_RESPONSES_TWAN Responses!_!_!_!_!AS.        WAN_SERVICE_TXTWAN Service!_!_!_!ASJ        SYNCHING6command illegal while a synchronization is in progress J        UPDATINGTIME3command illegal while an update time is in progressb        
LOCALFAULTMDTSS, Local Time Not Intersecting!/!_Computed Time: !AS !/!_Local Time : !AS L        CLOCKSET8DTSS, Local Clock Set!/!_Old Time: !AS !/!_New Time: !AS v        FAULTYSERVD`DTSS, Server Time Not Intersecting!/!_Computed Time: !AS!/!_Server Name: !AS!/!_Server Time: !ASb        SYNCCOMPNDTSS, Synchronization Completed!/!_Computed Time: !AS !/!_Clock Adjustment !AS T        
UPDATEINIT?DTSS, Update Initiated!/!_Current Time: !AS !/!_Update Time !AS`        TOOFEWDMDTSS, Too Few Servers Detected!/!_Number Detected: !UL!/!_Number Required !UL (        ENABLEDDTSS, Enable CompletedN        	DIFFEPOCH:DTSS, Differing Epoch Detected!/!_Local Epoch Number !UL!/@        DIFFEPOCH_1)!_Epoch Number: !UL, !_Server Name: !AS!/ |        PROTOCOLhDTSS, Protocol Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL b        TOOMANYDODTSS, Too Many Servers Detected!/!_Number Detected: !UL, !_Number Accepted: !UL*        DISABLEDTSS, Disable Completed V        INVMESSDBDTSS, Invalid Message Detected!/!_Server Name: !AS!/!_Message: !AS         	TIMEREP2DsDTSS, Time Representation Version Mismatch Detected!/!_Server Name: !AS!/!_Major Version: !UL, !_Minor Version: !UL 6        
NOGLOBALSD DTSS, No Global Servers Detected B        
SERVERNOTR-DTSS, Server Not Responding!/Server Name: !AST        TDFSETBDTSS, Time Differential Factor Set!/!_Old TDF: !AS!/!_New TDF: !AS 8        INSFRECD%DTSS, Insufficient Resources DetectedT        EPOCHCHANGE>DTSS, Epoch Change Completed!/!_New Epoch: !UL, Old Epoch: !UL:        
EPOCHCHANGE_1"!/!_Old Time: !AS!/!_New Time: !AS6        TPFAILD$DTSS, Time Provider Failure Detected        
SYSTEMERRDjDTSS, System Error Detected!/!_Local Operating System: VMS!_Local Error Code: !UL!/!_Local Error Text: !AS :        SUPERSEDELOG#Superseding system logical name !AF.        OLDRULEUsing old timezone rule !AF D        
AMBIGLOCAL/Local time is ambiguous, assuming standard time4        SETTDF"DTSS set new timezone differential .        	OPENETHERcan not open ethernet port.        
OPENDECNETcan not open decnet port :        LOGICALFAIL#Failed to create system logical !AF >        NORULE,System logical SYS$TIMEZONE_RULE not defined N        NOGD>Global Directory is Undefined, Illegal,or Unknown by DNS Clerk P        
EPOCHRANGE:epoch out of range or must be different than current epoch B        HASPROVIDER,command illegal while a time provider exists8        	ISSTARTED$the service has already been started6        MINSERVERSRANGEvalid range is from 1 to 10 J        NOPRIV9need OPER and LOG_IO privileges to modify DTSS operations@        
NOTAFTERSTART'command only legal before START command P        NOTIMEUPDATE8new time interval not contained in current time interval 2        	NOTSERVERcommand only valid for servers>        
NOTSTARTED)command is only legal after START command:        NOTSUPPORTED"command is currently not supported J        
SYNCHOLDRANGE2valid range is from 0 00:00:00.00 to 0 01:00:00.00         SYNTAXinvalid syntax .        	ALLOCVIRTmemory allocation failure @        	ERRCREATE,error occurred while trying to create entity0        
ALREADYDISservice is already disabledD        
NOTCREATED.Command Valid only after DTSS has been CREATED 2        SETERRORInvalid argument to set commandB        FAILED0error occured while trying to complete directive J        
WRONGSTATE4DTSS is the the wrong state to perform the directive (        	INVSYNTAXInvalid syntax: !AF 0        INVRULEInvalid SYS$TIMEZONE_RULE: !AF6        ALREADYCREATEDDTSS has already been created6        ALREADYENABLEDDTSS has already been enabledB        NOTDISABLED+Command is valid only after DISABLE command @        
NOTENABLED*Command is valid only after ENABLE command :        
SERVERONLY%Command is valid for DTSS server onlyF        UPDATING3Command is not valid while the service is UPDATEINGL        NOIDP;IDP is not defined, can not build local communication tower H        INVIDP6User defined IDP string is invalid, redefine DTSS$_IDP N        INVNS>Name Space is Undefined,  Illegal, or directory unknown to DNSN        INVGD>Global Directory is Undefined, Illegal,or Unknown by DNS ClerkL        
NOTCOURIER6Servers with active time providers can not be couriers <        RPC_COMFAILURE#Detected RPC Communications Failure&        TS_SHUTDOWNService Shutdown.        NOTGLOBALSERVERNot A Global Server (        PRS_UNKNOWNParse file unknown(        PRS_FAILUREParse file failure,        PRS_INITCannot locate parse file *        INTERNALInternal error detected>        	NODNSPRIV)Access to global directory via DNS denied N        	NOGLOCOMM9Communications failure trying to contact global directory 2        DNSERRORUnknown error occurred from DNST        	NOTDECNET?DTS server is not configured to accept time from DECnet sources :        UNAUTH(DTS control program is not authenticated *        CPERRORError executing command >        NOWRITE,Must have write permission to the DTS entity<        NOREAD+Must have read permission to the DTS entityJ        ANOTHERDTSS4another DTSS service is already running on this nodeV        UNKPROTOCOL?protocol version mismatch between DTSS$SERVICE and DTSS$CONTROL B        INITIPC0can not initiate communication with DTSS$SERVICEJ        STOPDTS8Please stop the time service before running this programF        
NORULEFILE1The posix timezone rules file is not on SYS$DISK:j        
NOCLERKPAKTDTSS Clerk requires either the DVNETRTG or the DVNETEND PAK licenses to be installed R        	NOSERVPAK>DTSS Server requires the DVNETSERV PAK license to be installedN        
NOEXECLOAD8SYS$UTC_SERVICES.EXE has not been properly loaded by VMS  DTSS                                                                                                                                                                                                                                                     T               T       t           	                              (                     @                       0  @  P  p              0  @          0                     @   P      (      0      p          0  @    p      P          @         	  p	  	  	   
  0
  `
  
  
  
     p         0  `                         p                         
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       DECC$SHR                                               @       LIBOTS                                                                                                                                                                                                                                                                                    +                        @ $      DCEAXPMUPA013.A                8  >  5[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS_PROVIDER_TRAC.EXE;2                                                                               L                               J                       @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ' * [SYSHLP.EXAMPLES.DCE]GDE_DCE_APPS.DIR;1 +  , 5   .     /  @   4                            - 7    0   1    2   3     K  P   W   O     5   6 ȃ   7 ̺   8          9          G  @  H   J  I                    ARITHMETIC.DIR 2     
INVENTORY.DIR  i.     REMOTE_FILE.DIR  +     TRANSFER_DATA.DIR  )                                                                                                                                                                                                                                                                                                                                                                                                                       2 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]ARITHMETIC.DIR;1 +  , 2   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6    7 )   8          9          G  @  H   J  I                         ARITHMETIC.SAV h0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  = * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1 +  , h0   . @    /  @   4   ~  @   @      ~               - 2    0   1    2   3      K  P   W   O A    5   6 >  7 YK   8          9          G  @  H   J                                              ! ~      ARITHMETIC.SAV                                                                                                                                                                                               P                ARITHMETIC.SAV9  BACKUP SRC$:*.* OBJ$:ARITHMETIC.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   K>      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                           # * [RPCARITHMETIC.SRC]ARITHMETIC.COM;1 +  , '   .     /  @   4 L                          - %    0   1    2   3      K  P   W   O     5   6 Yt  7 Eut  8          9          G  @  H  J $ N                   ?                    $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:: $!	ARITHMETIC.COM -- Builds the arithmetic example program $! Modification History:, $!	03-Sep-1993 FWB Modified for VMS DCE V1.1 $!* $! Determine which compiler is being used. $ @DCE:DCE$CC_TEST $! $! Determine option files $ $ If( f$trnlnm("dce$cc") .eqs. " " )I $ THEN	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ ELSE	options = "dce:dce.opt/options" $ ENDIF - $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ # $! Compile the interface definition  $idl -v arithmetic.idl $ ) $! Build the local version of the example ! $cc/define=LOCAL client,procedure 1 $link/exe=LOCAL_CLIENT client,procedure,'options' $ $delete client.obj;*,procedure.obj;* $  $! Build the arithmetic client
 $cc client' $link client,arithmetic_cstub,'options'  $  $! Build the arithmetic server $cc/list server,procedure 1 $link server,procedure,arithmetic_sstub,'options'  $ 6 $! Define the entry for the server in the name service8 $ ARITHMETIC_SERVER_ENTRY == "/.:/arithmetic_serverhost" $ 5 $! Define the entry for the client to find the server 2 $ RPC_DEFAULT_ENTRY == "/.:/arithmetic_serverhost"                                                        # * [RPCARITHMETIC.SRC]ARITHMETIC.IDL;1 +  , (   .     /  @   4 P                         - %    0   1    2   3      K  P   W   O     5   6 b]  7 i]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: arithmetic.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* This Interface Definition Language file represents a basic arithmetic    */
/* procedure that a remote procedure call application can use.              */
[
uuid(C985A380-255B-11C9-A50B-08002B0ECEF1)/* Universal Unique ID          <CO>*/
]
interface arithmetic                      /* interface name is arithmetic <CO>*/
{
   const unsigned short ARRAY_SIZE = 10;/* an unsigned integer constant   <CO>*/
   typedef long long_array[ARRAY_SIZE]; /* an array type of long integers <CO>*/

   void sum_arrays ( /* The sum_arrays procedure does not return a value  <CO>*/
      [in] long_array a,                /* 1st parameter is passed in       */
      [in] long_array b,                /* 2nd parameter is passed in       */
      [out] long_array c                /* 3rd parameter is passed out      */
   );
}
                                                                                                           # * [RPCARITHMETIC.SRC]CHECK_STATUS.H;1 +  , 	8#   .     /  @   4 P       %                  - %    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                                          * [RPCARITHMETIC.SRC]CLIENT.C;1 +  , 8   .     /  @   4 L       .                   - %    0   1    2   3      K  P   W   O     5   6 F]  7 I  G]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: client.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
**  This is the client module of the arithmetic example.
*/
#include <stdio.h>
#include "arithmetic.h"    /* the header file created by the IDL compiler */

long_array a ={100,20`                                                                                                                                                                                                                                                                                                                                                                                  ,                        h $      DCEAXPMUPA013.A                h0  2  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                         G "     
       0,345,23,67,65,0,0,0,0};
long_array b ={4,0,2,3,1,7,5,9,6,8};

main ()
{
   long_array    result; 
   int i;

   sum_arrays(a, b, result);         /* A Remote Procedure Call <CO>*/
   puts("sums:");
   for(i = 0; i < ARRAY_SIZE; i++)
      printf("%ld\n", result[i]);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 * [RPCARITHMETIC.SRC]CLIENT.COM;1 +  , 3<   .     /  @   4 D                          - %    0   1    2   3      K  P   W   O     5   6 

  7 B 

  8          9          G  @  H  J $ N                   ?                       5 $! Define the entry for the client to find the server D $ inquire host "Enter server host name inside quotes (ie. ""host"")"/ $ RPC_DEFAULT_ENTRY == "/.:/arithmetic_''host'"  $ sho sym RPC_DEFAULT_ENTRY / $ write sys$output "Running the CLIENT program"  $ run client                                                                                                                                                                                                                                                               * [RPCARITHMETIC.SRC]CLIENT.SH;1 +  , =   .     /  @   4 6                           - %    0   1    2   3      K  P   W   O     5   6 `G'  7  8'  8          9          G  @  H  J $ N                   ?                        echo "Enter the arithmetic server host name"
read CLIENTHOST ETC
echo "Server host: $CLIENTHOST$ETC will be accessed"
def_log RPC_DEFAULT_ENTRY "/.:/arithmetic_$CLIENTHOST"
client
del_log RPC_DEFAULT_ENTRY
#
                                                                                                                                                                                                                                                                                                                               * [RPCARITHMETIC.SRC]MAKEFILE.;1 +  , Z   .     /  @   4 N                           - %    0   1    2   3      K  P   W   O 	    5   6 9W  7 MRW  8          9          G  @  H  J $ N                   ?                        # FILE NAME: Makefile 
# Makefile for OpenVMS/POSIX  arithmetic example application program
#
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# definitions for this make file
#
DCL_IDL= dcl mcr dce\$$idl
IDL= $(DCL_IDL)
CFLAGS_INIT = -U VMS -I. 
IDL_CFLAGS= -v -keep c_source 
CC = c89
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt
APPL=arithmetic
IDLCMD=$(IDL) 
#LIBS=-ldce -lcma -li -ldnet   #dce and internationalization libraries
#CFLAGS=   
#CC=cc 
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi


#
# COMPLETE BUILD of the application
#
build:	local ostubs client server


#
# LOCAL BUILD of the client application to test locally
#       
local:	 client.c procedure.c
		$(CC) $(C_FLAGS) -DLOCAL -o local_client client.c procedure.c 
# 		remove object files so they do not interfere with a real build
		rm client.o procedure.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl $(IDL_CFLAGS)

# STUB OBJECTS BUILD
ostubs: $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c 
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	$(APPL).h client.o $(APPL)_cstub.o 
	   $(CC) $(C_FLAGS) -o client client.o $(APPL)_cstub.o $(OPTFILE) 


#
# SERVER BUILD 
#
server:	$(APPL).h server.o procedure.o $(APPL)_sstub.o
	   $(CC) $(C_FLAGS) -o server server.o procedure.o $(APPL)_sstub.o $(OPTFILE)
clean:
	rm $(APPL).h *.o $(APPL)_cstub.c $(APPL)_sstub.c client server

                                                                                                                                                                                                                                                                                                                                       " * [RPCARITHMETIC.SRC]MAKEFILE.OSF1;1 +  , @m   .     /  @   4 K                         - %    0   1    2   3      K  P   W   O 	    5   6 K3a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?                    # FILE NAME: Makefile 
# Makefile for the arithmetic application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file
#
APPL=arithmetic
IDLCMD=idl -v
LIBS=-ldce -lcma    #dce and thread libraries 
CFLAGS= -D_USER_THREADS_ 
CC=cc 


#
# COMPLETE BUILD of the application
#
all:	local interface client server


#
# LOCAL BUILD of the client application to test locally
#       
local:	interface client.c procedure.c
	   $(CC)   -DLOCAL -o local_client client.c procedure.c
# remove object files so they do not interfere with a real build
	   rm client.o procedure.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	$(APPL).h client.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -o client client.o $(APPL)_cstub.o $(LIBS) 


#
# SERVER BUILD 
#
server:	$(APPL).h server.o procedure.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -o server server.o procedure.o $(APPL)_sstub.o $(LIBS)
                                                                                                                                            * [RPCARITHMETIC.SRC]PROCEDURE.C;1 +  , m	   .     /  @   4 P                         - %    0   1    2   3      K  P   W   O     5   6 [M]  7 WN]  8          9 #ΚL!b  G  @  H  J $ N                   ?                      /* FILE NAME: procedure.c 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  An implementation of the procedure defined in the arithmetic interface. */
#include <stdio.h>
#include "ari                                                                                                                                                                                                                                                   -                         $      DCEAXPMUPA013.A                h0  2  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                         ! "            thmetic.h"

void sum_arrays(a, b, c)    /* implementation of the sum_arrays procedure <CO>*/
   long_array a;
   long_array b;
   long_array c;
   {
      int i;

      for(i = 0; i < ARRAY_SIZE; i++)
         c[i] = a[i] + b[i];    /* array elements are each added together <CO>*/
   }
                * [RPCARITHMETIC.SRC]README.LIS;1 +  , &(   .     /  @   4 k                         - %    0   1    2   3      K  P   W   O     5   6 W  7 +B  8          9          G  @  H  J $ N                   ?                       
taken from Appendix C of Guide to Writing DCE Applications, by John Shirley




			COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

 THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
 ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
 OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
 THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
 PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

 THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

 DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
 SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.




                                                                        C
        _________________________________________________________________

                                               The Arithmetic Application


              The arithmetic application makes a remote procedure call
              to a procedure named sum_arrays, which adds together the
              values for the same array index in two long integer arrays
              and returns the sums in another array of long integers.

              The application demonstrates the basics of a distributed
              application with a remote procedure call and includes these
              features:

              o  Defining a simple array in an interface definition

              o  Using the automatic binding method

              o  Exporting a server to the name service

              o  Checking the error status of RPC runtime calls

    How to Build The Application

      To create the NONDISTRIBUTED LOCAL test of the application,
      enter the following command:

         For the OpenVMS/POSIX environment copy files from the DCE examples
         directory to your POSIX accessible directory):
         	psx> cd /mydev/mydir
	 	psx> copy /usr/dce/examples/gde_dce_apps/arithmetic/*  .

            Build the local version of the example
                psx> make 			(currently this will actually 
						 build all versions)

         For the OpenVMS environment copy files from the DCE examples directory
         to your local directory:
         	C$ set default mydisk:[mydirectory]
         	C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.arithmetic]*.* []
         	C$ @arithmetic

	      	    Running ARITHMETIC.COM creates all the executables (lcoal
	            and Distributed) for the arithmetic application.

      To build the DISTRIBUTED application
  
         For the OpenVMS/POSIX environment, enter the following:

	 	psx> make 


    How to Run The Application

      To run the LOCAL test on OpenVMS, define a foreign command with the 
      full directory specification:

         C$ local_client :== "$mydisk:[arith-directory]local_client.exe"

      Then, to run the NONDISTRIBUTED LOCAL test of the application
      on any system, enter the following command:

         C$ local_client

      To run the server of the DISTRIBUTED application, set the
      application-specific environment variable ARITHMETIC_SERVER_ENTRY 
      to the server entry name /.:/arithmetic_serverhost, where "serverhost" 
      is the name of your server system. (The server.com for OpenVMS and
      server.sh for OpenVMS/POSIX will set the environment variable)

      For the OpenVMS/POSIX environment, enter the following:

	 psx> server.sh 

	 Enter the server host name, principal and password in double 
	 quotes at the prompts.
              
      For the OpenVMS environment, enter the following:

         Define the following command:

         S$ server :== @mydisk:[arith-directory]server.com


         Then, to run the server, enter the following command:

         S$ server  

      Enter the server host name, principal and password in double quotes at 
      the prompts.

      Server exports a binding to the (CDS) Name Service. The principal 
      logging in must be a member of the "/.:/subsys/dce/cds-server" group 
      (via rgy_edit) or cell_admin to successfully export the binding.  
     
      To log in the OpenVMS environment:
	 S$ dce_login
	   (and enter the username and password)

      To log in the OpenVMS/POSIX environment:
         S> dce_login
	   (and enter the username and password)
            
            
      To run the client of the distributed application, set the
      RPC environment variable RPC_DEFAULT_ENTRY to the server
      entry name /.:/arithmetic_serverhost. The serverhost is
      the server host name, not the client host name. (The 
      client.com for OpenVMS and client.sh for OpenVMS/POSIX will 
      set the environment variable)

      For the OpenVMS/POSIX environment, enter the following:

	 psx> client.sh 
	 
         and enter client host name at the prompt, RPC_DEFAULT_ENTRY will be 
	 set

      For the OpenVMS environment, the symbol is defined in client.com.
      Define the following command:

         C$ client :== @mydisk:[arith-directory]client.com ! Enter server host name as instructed at prompt

      Then, to run the client, enter the following command:

         S$ client

         Enter the server host name as instructed at the prompt



              Application Files

              Makefile:  The Makefile contains descriptions of how the
              application is compiled in under VMS/POSIX. Use the compilation "make", to
              create all the executable files for the application. Use
	      "make clean" first to rebuild the .h, .o and executables.

              Makefile.osf1:  The Makefile for OSF/1 systems.

	      arithmetic.com: This file builds all the arithmetic
	      executables.

              client.sh:  This file is a shell script to set 
              RPC_DEFAULT_ENTRY execute the client.

              server.sh:  This file is a shell script to set the
              environment and execute the server.

              client.com:  This file is a command procedure file to set the
              environment and execute the client.

              server.com:  This file is a command procedure file to set the
              environment and execute the server.

              arithmetic.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              client.c:  For this application, the client initializes two
              arrays, calls the remote procedure sum_arrays, and displays
              the results of the returned array.

              procedure.c:  This is the remote procedure implementation.

              server.c:  The server is initialized with a series of RPC
              runtime calls.

              check_status.h:  The CHECK_STATUS macro is defined to
              interpret error status codes that may return from RPC
              runtime calls.




                                                                                                    * [RPCARITHMETIC.SRC]SERVER.C;1 +  , GG   .     /  @   4 Q                          - %    0   1    2   3      K  P   W   O 	    5   6 	@}]  7 铚}]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: server.c
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "arithmetic.h"             /* header created by the idl compiler <CO>*/
#include "check_status.h"           /* header with the CHECK_STATUS macro   */

main ()
{
   unsigned32           status;          /* error status (nbase.h)          */
   rpc_binding_vector_t *binding_vector; /*set of binding handles(rpcbase.h)*/
   unsigned_char_t      *entry_name; /*entry name for name service (lbase.h)*/
   char *getenv();

   rpc_server_register_if(     /* register interface                                                                                                                                                                                                                                                   .                        " $      DCEAXPMUPA013.A                h0  2  =[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.ARITHMETIC]ARITHMETIC.SAV;1                                                                    ~   ~@                         4 "     /        with the RPC runtime <CO>*/
      arithmetic_v0_0_s_ifspec,   /* interface specification (arithmetic.h) */
      NULL, 
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(        /* establish protocol sequences    <CO>*/
      rpc_c_protseq_max_reqs_default,  /* queue size for calls   (rpcbase.h)*/
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(   /* get set of this server's binding handles <CO>*/
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   entry_name = (unsigned_char_t *)getenv("ARITHMETIC_SERVER_ENTRY");
   rpc_ns_binding_export(       /* establish name service database entry  <CO>*/
      rpc_c_ns_syntax_default,     /* syntax of the entry name  (rpcbase.h) */
      entry_name,                  /* entry name for name service           */
      arithmetic_v0_0_s_ifspec,    /* interface specification (arithmetic.h)*/
      binding_vector,              /* the set of server binding handles     */
      NULL,
      &status 
   );
   CHECK_STATUS(status, "Can't export to name service database\n", ABORT);

   rpc_ep_register(           /* register endpoints in local endpoint map <CO>*/
      arithmetic_v0_0_s_ifspec,   /* interface specification (arithmetic.h) */
      binding_vector,             /* the set of server binding handles      */
      NULL,                     
      NULL,                       
      &status 
   );
   CHECK_STATUS(status, "Can't add address to the endpoint map\n", ABORT);
   
   rpc_binding_vector_free(         /* free set of server binding handles <CO>*/
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't free server binding handles and vector\n", ABORT);

   puts("Listening for remote procedure calls...");
   rpc_server_listen(                 /* listen for remote calls          <CO>*/
      rpc_c_listen_max_calls_default, /*concurrent calls to server (rpcbase.h)*/
      &status
   );
   CHECK_STATUS(status, "rpc listen failed\n", ABORT);
}   
                                                                                                                                                                                                                                                                                      * [RPCARITHMETIC.SRC]SERVER.COM;1 +  , LG   .     /  @   4 y       "                    - %    0   1    2   3      K  P   W   O     5   6 s>@  7 ^d>@  8          9          G  @  H  J $ N                   ?                       I $! Insure DCE creds & define the entry for the server in the name service % $ if  f$trnlmn("krb5ccname") .EQS. ""  $ theny $ 	write sys$output "dce_login must be run first: The Principal needs registry group membership in subsys/dce/cds-server" 4 $	write sys$output "OR use the cell_admin principal" $ 	goto exit $ endif A $! Define the server host name as part of ARITHMETIC_SERVER_ENTRY F $ inquire host "Enter server host name inside quotes (ie. ""host"")"  5 $ ARITHMETIC_SERVER_ENTRY == "/.:/arithmetic_''host'"  $ run server $ exit:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * [RPCARITHMETIC.SRC]SERVER.SH;1 +  , OG	   .     /  @   4 p                          - %    0   1    2   3      K  P   W   O     5   6 h|ݲ  7 ƣݲ  8          9          G  @  H  J $ N                   ?                        # Shell to check credentials and establish enviromental for the Arithmetic Server.  Burgher
# 14-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"	
if [ -z "$CREDS" ]
then
	echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
	echo " OR use the cell_admin principal:"
	exit 1
fi
echo "Enter the arithmetic server host name:"
read SERVERHOST
ARITHMETIC_SERVER_ENTRY="/.:/arithmetic_$SERVERHOST"
export ARITHMETIC_SERVER_ENTRY
trap 'while true
do 
break
done' INT QUIT TERM EXIT
server
echo "Arithmetic Server exiting"
#
                                                                                                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                        #c $      DCEAXPMUPA013.A                i.  5  1[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]INVENTORY.DIR;1                                                                                                           t            1 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]INVENTORY.DIR;1 +  , i.   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6    7 2   8          9          G  @  H   J  I                          EXPLICIT.DIR k*     IMPLICIT.DIR *     
INVENTORY.SAV  j0                                                                                                                                                                                                                                                                                                                                                                                                                                                             : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]EXPLICIT.DIR;1 +  , k*   .     /  @   4                            - i.    0   1    2   3     K  P   W   O     5   6 g   7 țZ   8          9          G  @  H   J  I                 
INVENEXPL.SAV  +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1 +  , +   . @    /  @   4   ~  @   @      ~               - k*    0   1    2   3      K  P   W   O A    5   6  D,?  7 v   8          9          G  @  H   J                                                       )  ~      
INVENEXPL.SAV                                                                                                                                                                                                p              
  INVENEXPL.SAVo  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]*.*; OBJ$:INVENEXPL.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @    ,?      V5.5	 	 _OPNDCE:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8        @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]CHECK_STATUS.H;1 +  , ;H   .     /  @   4 P       %                  - (    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]DO_IMPORT_BINDING.C;1 +  , HH   .     /  @   4 R                          - (    0   1    2   3      K  P   W   O 	    5   6  !  7 Rg  8          9          G  @  H  J $ N                   ?                
            " /* FILE NAME: do_import_binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <string.h>  #include "inventory.h" #include "check_status.h"   # extern void do_interpret_binding();   R void do_import_binding(entry_name, binding_h) /* Get binding from name service. */P char                   entry_name[];        /* entry name to begin search     */P rpc_binding_handle_t   *binding_h;          /* a binding handle (rpcbase.h)   */ { P    unsigned32      status;                  /* error status (nbase.h)         */P    rpc_ns_handle_t import_context;          /* required to import (rpcbase.h) */P    char            protseq[20];             /* protocol sequence              */  R    rpc_ns_binding_import_begin(/* set context to import binding handles     <CO>*/P       rpc_c_ns_syntax_default,       /* use default syntax                    */P       (unsigned_char_t *)entry_name, /* begin search with this name           */P       inventory_v1_0_c_ifspec,       /* interface specification (inventory.h) */P       NULL,                          /* no optional object UUID required      */P       &import_context,               /* import context obtained               */
       &status     ); 7    CHECK_STATUS(status, "Can't begin import:", RESUME);       while(1) {   R       rpc_ns_binding_import_next( /* import a binding handle                <CO>*/P          import_context,          /* context from rpc_ns_binding_import_begin */P          binding_h,               /* a binding handle is obtained             */          &status       );       if(status != rpc_s_ok) {H          CHECK_STATUS(status, "Can't import a binding handle:", RESUME);          break;        }   R       /** application specific selection criteria (by protocol sequence) ***<CO>*/1       do_interpret_binding(*binding_h ,protseq);  P       if(strcmp(protseq, "ncacn_ip_tcp") == 0)  /* select connection protocol */          break;        else {R          rpc_binding_free(         /* free binding information not selected <CO>*/             binding_h,             &status           ); I          CHECK_STATUS(status, "Can't free binding information:", RESUME);        }     } /*end while */   R    rpc_ns_binding_import_done(   /* done with import context                <CO>*/P       &import_context,           /* obtained from rpc_ns_binding_import_begin */
       &status     );     return;     }                                                                     P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]DO_INTERPRET_BINDING.C;1 +  , PH   .     /  @   4 P                          - (    0   1    2   3      K  P   W   O 	    5   6  pV!  7 }zg  8          9          G  @  H  J $ N                   ?                         % /* FILE NAME: do_interpret_binding.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* Interpret binding information and return the protocol sequence */ #include <stdio.h> #include <dce/rpc.h> #include <string.h>  #include "check_status.h"   0 void do_interpret_binding(binding, protocol_seq)N rpc_binding_handle_t binding;    /* binding handle to interpret (rpcbase.h) */N char                 *protocol_seq;    /* protocol sequence to obtain       */ { N    unsigned32      status;             /* error status                      */N    unsigned_char_t *string_binding;    /* string of binding info. (lbase.h) */N    unsigned_char_t *protseq;           /* binding component of interest     */  P    rpc_binding_to_string_binding(/* convert binding information to string <CO>*/N       binding,                            /* the binding handle to convert  */N       &string_binding,                    /* the string of binding data     */
       &status     ); =    CHECK_STATUS(status, "Can't get string binding:", RESUME);   P    rpc_string_binding_parse(          /* get components of string binding <CO>*/N       string_binding,           /* the string of binding data               */O       NULL,                     /* an object UUID string is not obtained    */  N       &protseq,                 /* a protocol sequence string IS obtained   */N       NULL,                     /* a netwoP                                                                                                                                                                                                                                                                                                                                                                  0                        G $      DCEAXPMUPA013.A                +  k*  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                         3 "            rk address string is not obtained */N       NULL,                     /* an endpoint string is not obtained       */N       NULL,                     /* a network options string is not obtained */
       &status     ); ?    CHECK_STATUS(status, "Can't parse string binding:", RESUME);   *    strcpy(protocol_seq, (char *)protseq);   P    /* free all strings allocated by other runtime routines                <CO>*/.    rpc_string_free(&string_binding,  &status);/    rpc_string_free(&protseq,         &status);  
    return; }                                                             P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT-INVENTORY.ACF;1 +  , YH	   .     /  @   4 M                         - (    0   1    2   3      K  P   W   O     5   6 z]  7 '{]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: inventory.acf (explicit version)
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  This Attribute Configuration File is used in conjunction with the     */
/*  associated IDL file (inventory.idl) when the IDL compiler is invoked. */ 
[
explicit_handle           /* explicit binding method */
]
interface  inventory      /* The interface name must match the idl file */
{     
}
                                                                                @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT.COM;1 +  , H   .     /  @   4 V       j                   - (    0   1    2   3      K  P   W   O     5   6   7   8          9          G  @  H  J $ N                   ?                    $!9 $! EXPLICIT.COM -- Builds the inventory example utilizing  $!	the explicit binding method $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST& $ If( f$trnlnm( "dce$cc") .eqs. " " )	I $ then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ else	options = "dce:dce.opt/options" $ endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion5 $idl -v -cpp_cmd inventory.idl -DINV_EXP -server none  $ I $! No local build is developed for the explicit client because the remote G $! procedure implementations for the server have been developed without F $! explicit binding.  In order to test this client locally, the remoteG $! procedure implementations need to have a binding handle as the first 
 $! parameter.  $  $! Build the inventory client P $cc/g_float/include=([])  explicit_client,do_import_binding,do_interpret_bindingV $link explicit_client,do_import_binding,do_interpret_binding,inventory_cstub,'options'                                                                                                                                                    @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.C;1 +  , H   .     /  @   4 Y       
                    - (    0   1    2   3      K  P   W   O 
    5   6  I#  7 .h  8          9          G  @  H  J $ N                   ?                /* FILE NAME: explicit_client.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******* Client of the inventory application with explicit method ***********/ #include <stdio.h>   #include <stdlib.h>  #include <ctype.h>P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/    extern void do_import_binding();  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";    main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */  B    rpc_binding_handle_t binding_h;  /* declare a binding handle */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");  N #ifndef LOCAL                       /* find server in name service database */9    do_import_binding("/.:/inventory_group", &binding_h);   #endif     N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(binding_h, part.number))          /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(binding_h, part.number, part.name);    /*<CO>*//                 printf("name:%s\n", part.name);                  break;#       case 'd': part.description =  P                    get_part_description(binding_h, part.number);        /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  Q       case 'p': whatis_part_price(binding_h, part.number, &(part.price));/*<CO>*/ >                 printf("price:%10.2f\n", part.price.per_unit);                 break;  X       case 'q': whatis_part_quantity(binding_h, part.number, &(part.quantity)); /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(binding_h, part.number, &subparts);    /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);                 result =  Y                    order_part(binding_h, part.number, &(part.quantity), account);/*<CO>*/                   if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quanti                                                                                                                                                                                                                                                   1                        K] $      DCEAXPMUPA013.A                +  k*  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                          "            ty.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.COM;1 +  , <J	   .     /  @   4 ,       f                   - (    0   1    2   3      K  P   W   O     5   6  HSe  7  e  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run explicit_client                                                                                                                                                                                                                                                                                                                                                                                                                         @             I * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]EXPLICIT_CLIENT.SH;1 +  , OJ   .     /  @   4 /       [                   - (    0   1    2   3      K  P   W   O     5   6 ^e  7  e  8          9          G  @  H  J $ N                   ?             def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
explicit_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENTORY.IDL;1 +  , mI	   .     /  @   4 P       4                  - (    0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                   ?                  /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   typedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]MAKEFILE.EXPLICIT;1 +  , I   .     /  @   4 \                         - (    0   1    2   3      K  P   W   O 	    5   6 \  7   8          9          G  @  H  J $ N                   ?              # FILE NAME: makefile 
# Makefile for the inventory application (explicit version)
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#--------------------------------------------------------------                                                                                                                                                                                                                                                   2                         $      DCEAXPMUPA013.A                +  k*  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]INVENEXPL.SAV;1                                                             ~   ~@                         
q       0       ----------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -DINV_EXP -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE= make -f makefile.explicit

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	ostubs client 

#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl
#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	explicit_client
explicit_client:	explicit_client.o $(APPL)_cstub.o do_import_binding.o\
			do_interpret_binding.o
	$(CC) $(C_FLAGS) -o explicit_client explicit_client.o \
	do_import_binding.o do_interpret_binding.o \
	$(APPL)_cstub.o $(OPTFILE)

explicit_client.o:	explicit_client.c
			$(CC) $(C_FLAGS) -c explicit_client.c
do_import_binding.o:	do_import_binding.c
			$(CC) $(C_FLAGS) -c do_import_binding.c
do_interpret_binding.o:	do_interpret_binding.c
			$(CC) $(C_FLAGS) -c do_interpret_binding.c
clean:
	rm -f *.o $(APPL).h i_server explicit_client 
#<ENDCOMMENT>
                                                                                                   @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.EXPLICIT]MAKEFILE.OSF1;1 +  , I   .     /  @   4 S                          - (    0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?      
            # FILE NAME: Makefile 
# Makefile for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere with a real build
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLICIT.DIR;1 +  , *   .     /  @   4                            - i.    0   1    2   3     K  P   W   O     5   6    7 <b   8          9          G  @  H   J  I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     3                        hB $      DCEAXPMUPA013.A                *  i.  :[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLICIT.DIR;1                                                                                                  V$              
INVENIMPL.SAV  '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1 +  , '   .     /  @   4   ~           ~               - *    0   1    2   3      K  P   W   O     5   6 `~7?  7 h   8          9          G  @  H   J                                                       ؒ5 ~      
INVENIMPL.SAV                                                                                                                                                                                                i              
  INVENIMPL.SAVo  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]*.*; OBJ$:INVENIMPL.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   `6?      V5.5	 	 _OPNDCE:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8        @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]CHECK_STATUS.H;1 +  , ;H   .     /  @   4 P       %                  - (    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]DO_IMPORT_BINDING.C;1 +  , HH   .     /  @   4 R                          - (    0   1    2   3      K  P   W   O 	    5   6  !  7 Rg  8          9          G  @  H  J $ N                   ?                
            " /* FILE NAME: do_import_binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <string.h>  #include "inventory.h" #include "check_status.h"   # extern void do_interpret_binding();   R void do_import_binding(entry_name, binding_h) /* Get binding from name service. */P char                   entry_name[];        /* entry name to begin search     */P rpc_binding_handle_t   *binding_h;          /* a binding handle (rpcbase.h)   */ { P    unsigned32      status;                  /* error status (nbase.h)         */P    rpc_ns_handle_t import_context;          /* required to import (rpcbase.h) */P    char            protseq[20];             /* protocol sequence              */  R    rpc_ns_binding_import_begin(/* set context to import binding handles     <CO>*/P       rpc_c_ns_syntax_default,       /* use default syntax                    */P       (unsigned_char_t *)entry_name, /* begin search with this name           */P       inventory_v1_0_c_ifspec,       /* interface specification (inventory.h) */P       NULL,                          /* no optional object UUID required      */P       &import_context,               /* import context obtained               */
       &status     ); 7    CHECK_STATUS(status, "Can't begin import:", RESUME);       while(1) {   R       rpc_ns_binding_import_next( /* import a binding handle                <CO>*/P          import_context,          /* context from rpc_ns_binding_import_begin */P          binding_h,               /* a binding handle is obtained             */          &status       );       if(status != rpc_s_ok) {H          CHECK_STATUS(status, "Can't import a binding handle:", RESUME);          break;        }   R       /** application specific selection criteria (by protocol sequence) ***<CO>*/1       do_interpret_binding(*binding_h ,protseq);  P       if(strcmp(protseq, "ncacn_ip_tcp") == 0)  /* select connection protocol */          break;        else {R          rpc_binding_free(         /* free binding information not selected <CO>*/             binding_h,             &status           ); I          CHECK_STATUS(status, "Can't free binding information:", RESUME);        }     } /*end while */   R    rpc_ns_binding_import_done(   /* done with import context                <CO>*/P       &import_context,           /* obtained from rpc_ns_binding_import_begin */
       &status     );     return;     }                                                                     P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]DO_INTERPRET_BINDING.C;1 +  , PH   .     /  @   4 P                          - (    0   1    2   3      K  P   W   O 	    5   6  pV!  7 }zg  8          9          G  @  H  J $ N                   ?                         % /* FILE NAME: do_interpret_binding.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* Interpret binding information and return the protocol sequence */ #include <stdio.h> #include <dce/rpc.h> #include <string.h>  #include "check_status.h"   0 void do_interpret_binding(binding, protocol_seq)N rpc_binding_handle_t binding;    /* binding handle to interpret (rpcbase.h) */N char                 *protocol_seq;    /* protocol sequence to obtain       */ { N    unsigned32      status;             /* error status                      */N    unsigned_char_t *string_binding;    /* string of binding info. (lbase.h) */N    unsigned_char_t *protseq;           /* binding component of interest     */  P    rpc_binding_to_string_binding(/* convert binding information to string <CO>*/N       binding,                            /* the binding handle to convert  */N       &string_binding,                    /* the string of binding data     */
       &status     ); =    CHECK_STATUS(status, "Can't get string binding:", RESUME);   P    rpc_string_binding_parse(          /* get components of string binding <CO>*/N       string_binding,           /* the string of binding data               */O       NULL,                     /* an object UUID string is not obtained    */  N       &protseq,                 /* a protocol sequence string IS obtained   */N       NULL,                     /* a network address string is not obtained */N       NULL,                     /* an endpoint string is not obtained       */N       NULL,                     /* a network options string is not obtained */
       &status     ); ?    CHECK_STATUS(status, "Can't parse string binding:", RESUME);   *    strcpy(protocol_seq, (char *)protseq);   P    /* free all strings allocated by other runtime routines                <CO>*/.    rpc_string_free(&string_binding,  &status);/    rpc_string_free(&protseq,         &status);  
    return; }                                                             P             L * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLEMENT_INVENTORY.C;1 +  , H	   .     /  @   4 p      
 =                   - (    0   1    2   3      K  P   W   O     5   6  !]  7 )Sh  8          9          G  @  H  J $ N                   ?                          /* FILE NAME: implement_inventory.c 
**
**  Copyright (c) 1993 b                                                                                                                                                                                                                                                                                                                                                                                                                                                  4                         $      DCEAXPMUPA013.A                	   =  D[SYSHLP.EXAMPLES.DCE.DTSS]DCE$DTS,XNPGO]OTOWFQ]&KvD*->caL.SAV;1                                                           ]                              s 2     o       :C*^hR6to~tǝ8ǢX!XI/_rK^;~{AY^$,uejLTe5輊 nZ1܏qp!Hx3Yޝma҄p9G$dNY"d1*E~)HNu}dmeCEۈiQwLo*Nb`"<-Nб8#ZB8v6叓gDv{΁i}	k^6ױn@ M|x85R3aqr'"h4 :[7\VѣZp;I"`'D?h~0zga{FH(T}?KM2wE8
2חC
6< f];λ#k%՗*?'(6x~6x"=oK%i,[UD^a結r#QF}@&szy5@XP GP;w4V<X b0FwkXQw*?I
턑QBMB?VfĮ݋xCr67ȤvrrR޶+'
srtax4*pa!PmB1(pO|;T[][i2.U.)ÓS6kǝZ	BWp@۝ѥJIY4)j#7skgjNmsΩI<BDx`!hQ5<C΃mTlË2d[֩ljvwx.Otdl^+ZN7WbvӽWs59lUR/QvHa H_yC19o򵧿-z,4u <*6?4J4O*ynJZ09eSdg#{_W"\#?,2;y)*7JZ0lZMb8_hSTf,LPh6p6E6(a%ywSjvnFSQCUՔkab):11;%
tOovY!^=UG3uiԑtiwBV<f
XVPU/[Syc825̶~I I@Վp
zϭ-F`~o,duG{K9Ƕ訩M%V!QAȇ/ZAehF(* ClIMbmB}̼s'i^5FqT	jsѭEʑ`tTJK΁JvjwRXEñُ.;<=a+̪nz;3Zy4
dj@\@QX12y(cFkwt%	/>^5 #h*sӠAC>7*m]}=Zм@(0鸒kig;ua:Ҟn	k"O[ASEF"A>a@' /o&ޙ/mKޥ zb틖͗9^#ޚBl8.݉ ?>ؒk@đZ=t 1Od RLƉ(۹L!H|>@e%_ HDU9\+Zݸ8zC% ZFXnO]EbJo:w	y"
u7fP\ظݟ9GY6@7jR%p`;NVf8F`t\a14&Y8 \aP2bw?,خG	Đvya{0<=}gӼ{Vh(:Zl3JS bAj.>(Wa4Y`ZD6.
kØ'%<P\خu:{JU jmp)T_$,;[\WRj_d{\%J>!#꘾z`eHG$: 2L\	[LSAH0mEE͟98wh=_궳Gܐp{P1fr2Pa\}Zcx&U7l*&cw)A`8q2D~ֱO#2y(dH1k-bYnAat1!I4(;\A		io\H]TюUVR\ǣV߫nxM;߃""'nֿP'NQ<r-	<,u2_I18bPAv羚n̛NM *9$qkZ%6ވJ#V\=j467XK}4B{ūȩ~cG6N=)Rc.Sb$g \xQ5vthAB͆Beyf5
XqF'siރZnng-<{xZn/i$:$EclAS3gaVZ! W/\wl.ů"<*G.,.H_Æ
0T?8hTh7dTXj2]G1w#+&1t_~唳YrO9땚2<IO">ڋΨڿvGrT@cyk2*\oL>aɹOg}X i4Kvհa~~Mļcw͍7g}n1~I+Ew2$eܤOv|	}3vGyv6)jULo+
{Z~@nK'D7l*u,dA\_E1$I
ͤus8"݊k,Mw4X#"D|8cޟH%g_NK6LX^Wt!;$V'uOAh
d)q9̅%\/bf6g/jmܤ?>LO~YN$ҖYUT[y(@0Fv-UܞȂ`e	b
&9g>Y|4<S`s*n$УO
_hB4>w'2]7JՊS̑/.h6Y}w
X_؍=zAr^[DS^=U-JiyT%l#&Jg)0P%yj9yאAi2W!A=\Tĕwr/Y	i^E-@@:Q5*[UTz*|dW$$>Vg7:gⶦ+|[9HGy&j97|Jxz3ќPͪps?@F`X;Wd I{1.YQICX b|ZɊnk>Bθ5F|gHf$ϐThSs0 t6!{imks;hYJ1E+9C哯y709J`Ki0-cb2͘f`o>cp5~-$ǧzmȰpƊgu	vq)O1*7tRC}UЎlKCMH
fx'~1K"+Aͽ~i͓6\X	ڹ=%W&J%_f,[[6xޞ
L(cL(f}-Qaa]w=sm_WVK q~!yه)aBf(Z;beHqG*_"40MNN2J7Q'̰-WOliNզ~vh#ĳսfGc=ØXuG_shMkK#91k s^(`;=PngcvbYLD~s)zmK̦Y݉aο.Tk<!Q@fXQ3=Xp	*UMD㽣&$='?f>PjB_<q%C%x,Od{]rEL}Np7$f|SqjzYٸ޾P ya5C1eQ*sAz
jzaN
eK2 $?^ʽѸ-0DTEyz,<1?-ZÒnDjRECm PŌU8o(CDS{>#%AyN9r^֨ēQ?gjK<y|Jp(S?0z`ɽƚ`9Z!KE]QEp#^w$C@UbΚw plĹhv96/(%ItHA:B$Gj h%?ˎ{ɏqG8\t2TBT˚`N+ą{ئzr,) \1´!N"$K%B^T`{Cͷcz"@O
xL8mZ\=x0=kZJEWQg݇X}.&QF7Zn?f
mssbt0?	XӉ,!V.l*5w
/WD\~֬G?)2{Q#e5T2K9n4-_cW6УuPCΙ"yDFѷEܷG3X$|cWc1p"6ΠD1_/$M;7.j-Dk}=Zaˍ#ꝂvΝ[!&uGmB=[<4.*R1Ee³N=!)X"@@)0ZU[wL!_]r,dZ좫qSA3|[tr,L^EXW탐i&\z_ƶAEλ;'8RnaVj$}jښF6#!v1AFiʙe}	~EjWK܍)vDeKeލ`JS-0-
X6l>v[f2VH4L8&"ȯ|*'ѩ7LBXcx_J9Zm-*>he`T|r
f:Et3og1mnʨpGn0)KŐ?nxAlTU=1H\I. Q5RzOnvtOtZd<QqD2t7UYХHW]1p&EBb,x5+;>x:Pu Hq|&EU4/Έ3Z¾ ym!YdG&]~s}YF cU'5H~lh̈M8r
`S߳cǽar쮝~TXKke&5m/ f9'=puIG#X++vT־"1E1True1C6^Βm~A/iXh]奒,\z6Q;y\1->
t/۝>9غk:0-6sViء;UNEr;8O'0ldhp}g_گeŴtG~B+zV*i	;Pqi(Gz)H{:	0'P4{Yr%4d*ʳ[Jۋ'*DPx^T9i,8 .oUD1"oY#taDϤOiAX#Yax/ؓ-pVΗƩ@d>pmE`@P
.y03ձ|v҉5)Z`^-ȾwH8`LyY#[~]!titGGO??䝻wĨsvcL]t졄3A9:OI_TO<Lm{+#r<'	i>&:tKܰ<]Jh߯Nn*Dyɱ3gtkHXE6Xcd!}mq)0JG}Ր>VHX"nP}\|0t~~X3v;y-Oޞ5vs<d~Xbb;/cmEq.zk`$ѹrk|;\!fQqE'mNKeP*ӸxP7PPRFF3l!z0kE`U]y<C/x7~[mJxfjO3.%%-^C \HV[;=nYQ!8RB6(05EkwSe f+SbA[Pp	JhZKA3
)CY_Srz7⃅gmǎ<t=Y#Z۲xٟ(G2z%շ$Qga~ϒPY-KZ
c
,2iy
8mڼ)r*p}ItvݨnF(i6-}4]!10됴*1J⯗DdOu־0(%}X^9qO0hr
>8k-`cN}*Pb_4"m@[gyuKB~锒"t]ԫvf9|,&be?`AʆfI
m<f+Ixb dgׄ`qwmj.ЫǼ:PK x!}$ŵX>HH$7z
o5Q}T

S|&}nV1
f
-q.$YE 
lv&Z[.6h[T~FѓzЦhEUUlKKeUAAEX-HkqHdCW9SZZ
ʭ^قvbX@~)(
MP$-7ҖXMico*36m:<K`D
%,Ru
$FקЮ|RbNRHo|xvi+ȍ|ߓYV(f/`bic˨rh|g_3*,`ޑZkL^[512sN1$Nlь{K0vaIGiŐd㯾Eo~2ǓUHt
K$3	޴7-7#Z/wx&kzT!`PVq-}(m8"ཟDYۑL#j)Y}z7'-}.Aħ9>xT;psv+[EK3kN(@ybطتBM+H
Ewk~]{i=p'^#H=Ga%VhBۄ	Bb55
mHkNʁU(hR esjJ#ːq
bF;PvkUy;yKsmw1X
33
p`0)[)2 @mLiB73,HVBb;7\lH6
c3MV]gbj5!ni۪G¿ؖaNzypލN]x3>a%YqK'keiQ e4zқ78T}XUD^݇z19fZH:vG68y[˛3|	!q;%*\G4!eqK?IE1+{ܥS@2u>JYE'eqx&^>
8JIH{aa`r8jªlɹyp5r5ɻ]C
]pek/z#=k 4)g09r</X|WDn.fm*GٲƘ<B."5)h~n;΁8@p--<Jrx}a$
1غ/
KkGR;kD*+UQ 9Db3ֲAQa27x]{sY ͯ
KlhSV|R9n+G<|]D>A$S<fhb|;0NW@۩8uelXv)
vCbLf52$瞥#ijd>1P0EwXqD?֒F5QHuم> శ=Md?2%1
Y ze!
O,g籮6Ƈ18@:R|6;B+rE%N^7۠xlRL7>AHhO<$7>#a{J8#.=aIq݇*VMv@O
2lϾL]3xV)q$.f6P}L5>-N*H>;9l<yn R9B`	{vܷ&݊p8_Tx
                              @                                                                                                                                                                                                             5                        . $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         dE "            y
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* A sample implementation of an inventory.                                 */
/* For simplicity, a few inventory items are maintained in the inventory.   */
/* The valid numbers are printed when the open_inventory() procedure is     */
/* called so the user knows what numbers to test.                           */
#include <stdio.h>
#include "inventory.h"
#define MAX_PARTS    10        /* maximum number of parts in this inventory */
#define MAX_SUBPARTS 5         /* maximum number of subparts for a part     */

static part_record *rec[MAX_PARTS]; /* array of pointers for this inventory */
static inventory_is_open = 0;       /* flag is reset to non-zero when open  */

/* Data for empty record or unknown part number */
static part_record no_part = {0,"UNKNOWN"};
static part_num    no_subparts[MAX_SUBPARTS];


void open_inventory()  /***** setup inventory *******************************/
{
   int i,j;
   unsigned size;
   char *malloc(), *strcpy(), *strncpy();

   /* Allocate memory for the inventory array.  Each part gets the size of  */
   /* a part_record plus enough memory for a subpart list.  Since the       */
   /* subpart list is already defined in the part_record as an array of 1,  */
   /* the new array memory only needs to be MAX_SUBPARTS-1 in size.       */
   for(i = 0; i < MAX_PARTS; i++) {
      size = sizeof(part_record) + (sizeof(part_num) * (MAX_SUBPARTS-1));
      rec[i] = (part_record *)malloc(size);
   }
   /* assign some data to the inventory array (part of an exercise machine) */
   rec[0]->number                = 102;
   strncpy((char *)rec[0]->name, "electronics display module", MAX_STRING);
   rec[0]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[0]->description,
      "The electronics display module is a liquid crystal display containing\n\
a timer, counter, metronome, and calorie counter.");
   rec[0]->price.units           = ITEM;
   rec[0]->price.per_unit        = 7.00;
   rec[0]->quantity.units        = rec[0]->price.units;
   rec[0]->quantity.total.number = 432;
   rec[0]->subparts.size         = 4;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[0]->subparts.size; i++) /* values used are not relevant */
      rec[0]->subparts.numbers[i] = rec[0]->number + 1 + i;

   rec[1]->number                = 203;
   strncpy((char *)rec[1]->name, "base assembly", MAX_STRING);
   rec[1]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[1]->description,
      "The base assembly rests on the floor to stabilize the machine.\n\
The arm and bench assemblies are attached to it.");
   rec[1]->price.units           = ITEM;
   rec[1]->price.per_unit        = 85.00;
   rec[1]->quantity.units        = rec[1]->price.units;
   rec[1]->quantity.total.number = 1078;
   rec[1]->subparts.size         = 5;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[1]->subparts.size; i++) /* values used are not relevant */
      rec[1]->subparts.numbers[i] = rec[1]->number + 17 + i;

   rec[2]->number                = 444;
   strncpy((char *)rec[2]->name, "ballast", MAX_STRING);
   rec[2]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[2]->description,
      "The ballast is used to counter balance the force exerted by the user.");
   rec[2]->price.units           = KILOGRAM;
   rec[2]->price.per_unit        = 1.59;
   rec[2]->quantity.units        = rec[2]->price.units;
   rec[2]->quantity.total.weight = 13456.2;
   rec[2]->subparts.size         = 0;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < MAX_SUBPARTS; i++)  /* zero out subpart array */
      rec[2]->subparts.numbers[i] = no_subparts[i];

   /* fill in rest of inventory as "empty" data */
   for(i = 3; i < MAX_PARTS; i++) {
      rec[i] = &no_part;
      for(j = 0; j < MAX_SUBPARTS; j++)
         rec[i]->subparts.numbers[j] = no_subparts[j];
   }
   puts("Part numbers in inventory:");
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number > 0)
         printf("%ld\n", rec[i]->number);
   inventory_is_open = 1;
   return;
}


void close_inventory()  /**** close inventory *******************************/
{ 
   /* Undo whatever is done in open_inventory.  Free memory and so forth.   */
   /* (not implemented) */
   return;
}


int read_part_record(number, part_ptr) /** get record for this part number **/
part_num number;
part_record **part_ptr;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   *part_ptr = &no_part;                      /* initialize assuming no part */
   for(i = 0; i < MAX_PARTS; i++)             /* search the inventory        */
      if(rec[i]->number == number) {          /* found the part              */
         *part_ptr = rec[i];
         break;
      }
   if( (*part_ptr)->number > 0)
      return(1);  
   else                                       /* not a valid part            */
      return(0);
}


int write_part_record(part)  /*** update inventory for this part number *****/
part_record *part;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number == part->number) {
         rec[i] = part;   /* overwrite inventory with new data */
         return(1);
      }
   return(0);
}

/*<COMMENT> dump the part data to the screen.
static dump_part_record(index)
int index;
{
   printf("number input:%ld  part number:%ld\n", number, rec[index]->number);
   printf("part name:%s\n", rec[index]->name);
   printf("description:%s\n", rec[index]->description);
   printf("price:%f per %s\n", rec[index]->price.per_unit, (rec[index]->price.units == ITEM) ? "item" : "gram");
   printf("quantity:");
   switch(rec[index]->quantity.units) {
   case ITEM: printf("%ld items\n", rec[index]->quantity.total.number); break;
   case GRAM: printf("%f grams\n", rec[index]->quantity.total.weight); break;
   case KILOGRAM: printf("%f kilos\n", rec[index]->quantity.total.weight); break;
   }
   printf("subparts: ");
   for(i = 0; i < rec[index]->subparts.size; i++)
      printf("%ld  ", rec[index]->subparts.numbers[i]);
   printf("\n");
}<ENDCOMMENT>*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                   P             M * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT-INVENTORY.ACF;1 +  , H   .     /  @   4 N                         - (    0   1    2   3      K  P   W   O     5   6 ]  7 =]  8          9 #ΚL!b  G  @  H  J $ N                   ?                         /* FILE NAME: inventory.acf (implicit version)
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/*  This Attribute Configuration File is used in conjunction with the     */
/*  associated IDL file (inventory.idl) when the IDL compiler is invoked. */ 
[
implicit_handle(handle_t global_binding_h)   /* implicit binding method <CO>*/
]
interface  inventory      /* The interface name must match the idl file <CO>*/
{     
}
                                                  @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT.COM;1 +  , H   .     /  @   4 p       z                   - (    0   1    2   3      K  P   W   O     5   6 5iT	  7 Yn	  8          9          G  @  H  J $ N                   ?                    $!9 $! IMPLICIT.COM -- Builds the inventory example utilizing  $!	the implicit binding method $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS                                                                                                                                                                                                                                                   6                        
  $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                          "     !       9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST' $ If( f$trnlnm( "dce$cc" ) .eqs. " " )	 I $ then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ else	options = "dce:dce.opt/options" $ endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion+ $idl -v -cpp_cmd inventory.idl -server none  $ ) $! Build the local version of the example V $cc/g_float/define=LOCAL/include=([]) implicit_client,i_procedures,implement_inventoryZ $link/exe=local_implicit_client implicit_client,i_procedures,implement_inventory,'options'J $delete implicit_client.obj;*,i_procedures.obj;*,implement_inventory.obj;* $  $! Build the inventory client p $cc/g_float/include=([]) implicit_client,do_import_binding,do_interpret_binding,i_procedures,implement_inventoryV $link implicit_client,do_import_binding,do_interpret_binding,inventory_cstub,'options'                                                                                                                                    @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.C;1 +  , H   .     /  @   4 T      
                   - (    0   1    2   3      K  P   W   O 
    5   6 e  7 e  8          9          G  @  H  J $ N                   ?                /* FILE NAME: implicit_client.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******* Client of the inventory application with implicit method ***********/ #include <stdio.h>   #include <stdlib.h>  #include <ctype.h>  P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/    extern void do_import_binding();  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";   & rpc_binding_handle_t	global_binding_h;   main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");  N #ifndef LOCAL                       /* find server in name service database */@    do_import_binding("/.:/inventory_group", &global_binding_h);  #endif     N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(part.number))                     /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(part.number, part.name);               /*<CO>*//                 printf("name:%s\n", part.name);                  break;P       case 'd': part.description = get_part_description(part.number);   /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  P       case 'p': whatis_part_price(part.number, &(part.price));          /*<CO>*/>                 printf("price:%10.2f\n", part.price.per_unit);                 break;  P       case 'q': whatis_part_quantity(part.number, &(part.quantity));    /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(part.number, &subparts);               /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);T                 result = order_part(part.number, &(part.quantity), account);/*<CO>*/                  if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quantity.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                          P             J * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.COM;1 +  , CJ   .     /  @   4 ,       f                   - (    0   1    2   3      K  P   W   O     5   6 @e  7 @tξe  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run implicit_client                                                                                                                                                                                                                                                                                                                                                                                                                         @             I * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]IMPLICIT_CLIENT.SH;1 +  , TJ   .     /  @   4 /       [                   - (    0   1    2   3      K  P   W   O     5   6 6ue  7 @eue  8          9          G  @  H  J $ N                   ?             def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
implicit_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENTORY.IDL;1 +  , mI	   .     /  @   4 P       4                  - (    0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                                                                                                                                                                                                                                                                7                         $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         ]6 "     2             ?                  /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   typedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            @             E * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]I_PROCEDURES.C;1 +  , ~I   .     /  @   4 P      
                     - (    0   1    2   3      K  P   W   O     5   6  !   7 "j  8          9          G  @  H  J $ N                   ?     
             /* FILE NAME: i_procedures.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */P /*** Implementation of the remote procedures for the inventory application. ***/ #include <stdio.h> #include "inventory.h" #include <stdlib.h>  #include <string.h>  #ifdef LOCALN    /* stub support procedures are redefined for a local test of application */ #define rpc_ss_allocate mallocN    /* In a distributed RPC application, rpc_ss_free is called automatically */N    /* by the server stub. In a local test, data is not automatically freed. */ #define rpc_ss_free free #endif   int read_part_record();  int write_part_record();  % idl_boolean is_part_available(number)  part_num number; { H    part_record *part;                   /* a pointer to a part record */
    int found;      ,    found = read_part_record(number, &part);     if(found)       return(idl_true);     else        return(idl_false); }     # void whatis_part_name(number, name)  part_num  number;  part_name name;  {   H    part_record *part;                   /* a pointer to a part record */    char * strncpy();   #    read_part_record(number, &part); 9    strncpy((char *)name, (char *)part->name, MAX_STRING); 
    return; }     & paragraph get_part_description(number) part_num  number;  { H    part_record *part;                   /* a pointer to a part record */    paragraph description;     int size;    char *strcpy();  *    if( read_part_record(number, &part) ) {K       /* Allocated data that is returned to the client must be allocated */ K       /* with the rpc_ss_allocate stub support routine.                  */ 3       size = strlen((char *)part->description) + 1; ?       description = (paragraph)rpc_ss_allocate((unsigned)size); =       strcpy((char *)description, (char *)part->description);     }    else        description = NULL;     return(description);  }     % void whatis_part_price(number, price)  part_num   number; part_price  *price;  { H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); $    price->units = part->price.units;*    price->per_unit = part->price.per_unit;
    return; }     + void whatis_part_quantity(number, quantity)  part_num      number;  part_quantity *quantity; {   H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); *    quantity->units = part->quantity.units;    switch(quantity->units) {F       case ITEM: quantity->total.nump                                                                                                                                                           ` ~      
INVENIMPL.SAV                  ~I  '  E[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]I_PROCEDURES.C;1                                                          P                              Wh             ber = part->quantity.total.number;                  break;        case KILOGRAM:F       case GRAM: quantity->total.weight = part->quantity.total.weight;                  break;     }
    return; }     * void whatare_subparts(number, subpart_ptr) part_num  number;  part_list **subpart_ptr; { F    part_record *part;                   /* pointer to a part record */	    int i;     int size;   #    read_part_record(number, &part);   N    /* Allocated data that is output to the client must be allocated with    */N    /* the rpc_ss_allocate stub support routine.  Allocate for a part_list   */N    /* struct plus the array of subpart numbers.  Remember the part_list     */N    /* struct already has an array with one element, hence the -1.           */K    size = sizeof(part_list) + (sizeof(part_num) * (part->subparts.size-1)); ?    *subpart_ptr = (part_list *)rpc_ss_allocate((unsigned)size);       /* fill in the values */ .    (*subpart_ptr)->size = part->subparts.size;,    for(i = 0; i < (*subpart_ptr)->size; i++)=       (*subpart_ptr)->numbers[i] = part->subparts.numbers[i]; 
    return; }     2 idl_long_int order_part(number, quantity, account) part_num      number;  part_quantity *quantity; account_num   account; { >    part_record *                                                                                                                                                                                                                                                   8                        m7@ $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         l "     C       part;           /* pointer to a part record */  5    long error = 1;  /* assume no error to start */        /* Test for valid input */ P    if( !read_part_record(number, &part) ) /* invalid part number input        */        error = -1;               P    else if(quantity->units == ITEM)       /* invalid quantity input           */9       error = (quantity->total.number <= 0) ? -2 : error; B    else if(quantity->units == GRAM || quantity->units == KILOGRAM);       error = (quantity->total.weight <= 0.0) ? -2 : error; P    /* else if()                              invalid account, not implemented */%    /*    error = -3;               */     if(error < 0)       return(error);  I    /* convert input quantity & units if units are not correct for part */ 0    if(quantity->units != part->quantity.units) {J       if(part->quantity.units == ITEM)     /* convert weight to items   */G          quantity->total.number = (idl_long_int)quantity->total.weight; J       else if(quantity->units == ITEM)     /* convert items to weight   */I          quantity->total.weight = (idl_long_float)quantity->total.number; J       else if(quantity->units == GRAM && part->quantity.units == KILOGRAM)K          quantity->total.weight /= 1000.0; /* convert grams to kilograms */ J       else if(quantity->units == KILOGRAM && part->quantity.units == GRAM)K          quantity->total.weight *= 1000.0; /* convert kilograms to grams */ -       quantity->units = part->quantity.units;     }  4    /* check if enough in inventory for this order */!    switch(part->quantity.units) { 
    case ITEM: >       if(part->quantity.total.number > quantity->total.number)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.number -= quantity->total.number;        else {H          /* order all available and reduce quantity in inventory to 0 */>          quantity->total.number = part->quantity.total.number;)          part->quantity.total.number = 0;        }        break;    case KILOGRAM: 
    case GRAM: >       if(part->quantity.total.weight > quantity->total.weight)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.weight -= quantity->total.weight;        else {J          /* order all available and reduce quantity in inventory to 0.0 */>          quantity->total.weight = part->quantity.total.weight;+          part->quantity.total.weight = 0.0;        }        break;    }     5    write_part_record(part);    /* update inventory */       return(1); /* order ok */ }                                                                                                                                                                                                                                                                                 @             H * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]MAKEFILE.IMPLICIT;1 +  , I   .     /  @   4 \                          - (    0   1    2   3      K  P   W   O 	    5   6 H{  7   8          9          G  @  H  J $ N                   ?              # FILE NAME: makefile 
# Makefile for the inventory application 
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE=make -f makefile.implicit

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	local ostubs client 

#
# LOCAL BUILD of the application to test locally.
#
local:	implicit_client.c i_procedures.c implement_inventory.c
	$(CC) $(C_FLAGS) -DLOCAL -o local_implicit_client \
		implicit_client.c i_procedures.c implement_inventory.c
	#remove the object files so they do not interfere with a real build
	rm implicit_client.o 

#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl
#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	implicit_client
implicit_client:	implicit_client.o $(APPL)_cstub.o do_import_binding.o\
			do_interpret_binding.o
	$(CC) $(C_FLAGS) -o implicit_client implicit_client.o \
	do_import_binding.o do_interpret_binding.o \
	$(APPL)_cstub.o $(OPTFILE)

implicit_client.o:	implicit_client.c
			$(CC) $(C_FLAGS) -c implicit_client.c
do_import_binding.o:	do_import_binding.c
			$(CC) $(C_FLAGS) -c do_import_binding.c
do_interpret_binding.o:	do_interpret_binding.c
			$(CC) $(C_FLAGS) -c do_interpret_binding.c
clean:
	rm -f *.o $(APPL).h i_server implicit_client local_implicit_client 
#<ENDCOMMENT>
                                                                                                                                                                                                                                                                                                     @             D * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]MAKEFILE.OSF1;1 +  , I   .     /  @   4 S                          - (    0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?      
            # FILE NAME: Makefile 
# Makefile for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere with a real build                                                                                                                                                                                                                                                   9                        c.I $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         / "     T       
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                              R                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 :                        2( $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         U "     e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ;                        H1 $      DCEAXPMUPA013.A                '  *  D[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY.IMPLICIT]INVENIMPL.SAV;1                                                             ~   ~                         \      v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1 +  , j0   .     /  @   4   ~           ~               - i.    0   1    2   3      K  P   W   O     5   6  ##?  7 hWh   8          9          G  @  H   J                                                9Fm ~      
INVENTORY.SAV                                                                                                                                                                                                              
  INVENTORY.SAVf  BACKUP RESD$:[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]*.*; OBJ$:INVENTORY.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   M#?      V5.5	 	 _OPNDCE:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8 @             < * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]CHECK_STATUS.H;1 +  , ;H   .     /  @   4 P       %                  - (    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                          /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                           0             7 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]CLIENT.SH;1 +  , BH	   .     /  @   4       T                    - (    0   1    2   3      K  P   W   O     5   6 80  7 +  8          9          G  @  H  J $ N                   ?               def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
i_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                                        : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]EXPLICIT.DIR;1 +  , '   .     /  @   4                            - y'    0  1    2   3     K  P   W   O     5   6 b=  7 @=  8          9          G  @  H  J  I ` N                            ?      ?	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             <                        ϛ $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         | "                                                                                            @             C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLEMENT_INVENTORY.C;1 +  , H	   .     /  @   4 p      
 =                   - (    0   1    2   3      K  P   W   O     5   6  !]  7 )Sh  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: implement_inventory.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* A sample implementation of an inventory.                                 */
/* For simplicity, a few inventory items are maintained in the inventory.   */
/* The valid numbers are printed when the open_inventory() procedure is     */
/* called so the user knows what numbers to test.                           */
#include <stdio.h>
#include "inventory.h"
#define MAX_PARTS    10        /* maximum number of parts in this inventory */
#define MAX_SUBPARTS 5         /* maximum number of subparts for a part     */

static part_record *rec[MAX_PARTS]; /* array of pointers for this inventory */
static inventory_is_open = 0;       /* flag is reset to non-zero when open  */

/* Data for empty record or unknown part number */
static part_record no_part = {0,"UNKNOWN"};
static part_num    no_subparts[MAX_SUBPARTS];


void open_inventory()  /***** setup inventory *******************************/
{
   int i,j;
   unsigned size;
   char *malloc(), *strcpy(), *strncpy();

   /* Allocate memory for the inventory array.  Each part gets the size of  */
   /* a part_record plus enough memory for a subpart list.  Since the       */
   /* subpart list is already defined in the part_record as an array of 1,  */
   /* the new array memory only needs to be MAX_SUBPARTS-1 in size.       */
   for(i = 0; i < MAX_PARTS; i++) {
      size = sizeof(part_record) + (sizeof(part_num) * (MAX_SUBPARTS-1));
      rec[i] = (part_record *)malloc(size);
   }
   /* assign some data to the inventory array (part of an exercise machine) */
   rec[0]->number                = 102;
   strncpy((char *)rec[0]->name, "electronics display module", MAX_STRING);
   rec[0]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[0]->description,
      "The electronics display module is a liquid crystal display containing\n\
a timer, counter, metronome, and calorie counter.");
   rec[0]->price.units           = ITEM;
   rec[0]->price.per_unit        = 7.00;
   rec[0]->quantity.units        = rec[0]->price.units;
   rec[0]->quantity.total.number = 432;
   rec[0]->subparts.size         = 4;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[0]->subparts.size; i++) /* values used are not relevant */
      rec[0]->subparts.numbers[i] = rec[0]->number + 1 + i;

   rec[1]->number                = 203;
   strncpy((char *)rec[1]->name, "base assembly", MAX_STRING);
   rec[1]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[1]->description,
      "The base assembly rests on the floor to stabilize the machine.\n\
The arm and bench assemblies are attached to it.");
   rec[1]->price.units           = ITEM;
   rec[1]->price.per_unit        = 85.00;
   rec[1]->quantity.units        = rec[1]->price.units;
   rec[1]->quantity.total.number = 1078;
   rec[1]->subparts.size         = 5;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < rec[1]->subparts.size; i++) /* values used are not relevant */
      rec[1]->subparts.numbers[i] = rec[1]->number + 17 + i;

   rec[2]->number                = 444;
   strncpy((char *)rec[2]->name, "ballast", MAX_STRING);
   rec[2]->description = (paragraph)malloc(1000);
   strcpy((char *)rec[2]->description,
      "The ballast is used to counter balance the force exerted by the user.");
   rec[2]->price.units           = KILOGRAM;
   rec[2]->price.per_unit        = 1.59;
   rec[2]->quantity.units        = rec[2]->price.units;
   rec[2]->quantity.total.weight = 13456.2;
   rec[2]->subparts.size         = 0;  /* cannot be greater than MAX_SUBPARTS */
   for(i = 0; i < MAX_SUBPARTS; i++)  /* zero out subpart array */
      rec[2]->subparts.numbers[i] = no_subparts[i];

   /* fill in rest of inventory as "empty" data */
   for(i = 3; i < MAX_PARTS; i++) {
      rec[i] = &no_part;
      for(j = 0; j < MAX_SUBPARTS; j++)
         rec[i]->subparts.numbers[j] = no_subparts[j];
   }
   puts("Part numbers in inventory:");
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number > 0)
         printf("%ld\n", rec[i]->number);
   inventory_is_open = 1;
   return;
}


void close_inventory()  /**** close inventory *******************************/
{ 
   /* Undo whatever is done in open_inventory.  Free memory and so forth.   */
   /* (not implemented) */
   return;
}


int read_part_record(number, part_ptr) /** get record for this part number **/
part_num number;
part_record **part_ptr;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   *part_ptr = &no_part;                      /* initialize assuming no part */
   for(i = 0; i < MAX_PARTS; i++)             /* search the inventory        */
      if(rec[i]->number == number) {          /* found the part              */
         *part_ptr = rec[i];
         break;
      }
   if( (*part_ptr)->number > 0)
      return(1);  
   else                                       /* not a valid part            */
      return(0);
}


int write_part_record(part)  /*** update inventory for this part number *****/
part_record *part;
{
   int i;

   if(inventory_is_open == 0)
      open_inventory();
   for(i = 0; i < MAX_PARTS; i++)
      if(rec[i]->number == part->number) {
         rec[i] = part;   /* overwrite inventory with new data */
         return(1);
      }
   return(0);
}

/*<COMMENT> dump the part data to the screen.
static dump_part_record(index)
int index;
{
   printf("number input:%ld  part number:%ld\n", number, rec[index]->number);
   printf("part name:%s\n", rec[index]->name);
   printf("description:%s\n", rec[index]->description);
   printf("price:%f per %s\n", rec[index]->price.per_unit, (rec[index]->price.units == ITEM) ? "item" : "gram");
   printf("quantity:");
   switch(rec[index]->quantity.units) {
   case ITEM: printf("%ld items\n", rec[index]->quantity.total.number); break;
   case GRAM: printf("%f grams\n", rec[index]->quantity.total.weight); break;
   case KILOGRAM: printf("%f kilos\n", rec[index]->quantity.total.weight); break;
   }
   printf("subparts: ");
   for(i = 0; i < rec[index]->subparts.size; i++)
      printf("%ld  ", rec[index]->subparts.numbers[i]);
   printf("\n");
}<ENDCOMMENT>*/
                                                                                                                                                                                                                                                                                                                                                                                                                                                                               : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]IMPLICIT.DIR;1 +  , '   .     /  @   4                            - y'    0  1    2   3     K  P   W   O     5   6 &=  7  9=  8          9          G  @  H  J  I ` N                            ?      ?	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.COM;1 +  , eI   .     /  @   4 U                           - (    0   1    2   3      K  P   W   O 	    5   6 E8<w  7 f<w  8          9          G  @  H  J $ N                   ?               
             $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF TH                                                                                                                                                                                                                                                   =                        8|l $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                          "            E ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:8 $!	INVENTORY.COM -- Builds the inventory example program $! $! Modification History:- $! 	26-Aug-1993 FWB Modified for VMS DCE V1.1  $!- $@DCE:DCE$CC_TEST                             K $! Determine which compiler is being used and establish the linker options  ' $ If( f$trnlnm("dce$cc") .eqs. " " )    H $ Then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options' $ Else	options = "dce:dce.opt/options"   $ Endif  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl " $! Compile the interface defintion $idl -cpp_cmd inventory.idl  $! $!cc := cc'f$trnlnm("dce$cc")' $!) $! Build the local version of the example U $cc/g_float/define=("CC$mixed_float",LOCAL) i_client,i_procedures,implement_inventory L $link/exe=local_i_client i_client,i_procedures,implement_inventory,'options' $!C $delete i_client.obj;*,i_procedures.obj;*,implement_inventory.obj;*  $! $! Build the inventory client , $cc/g_float/define="CC$mixed_float" i_client, $link i_client,inventory_cstub.obj,'options' $! $! Build the inventory server  $cc/g_float i_server, $cc/g_float i_procedures,implement_inventoryI $link i_server,i_procedures,implement_inventory,inventory_sstub,'options'  $!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.IDL;1 +  , mI	   .     /  @   4 P       4                  - (    0   1    2   3      K  P   W   O 	    5   6 ؤe  7 `e  8          9          G  @  H  J $ N                   ?                           /* FILE NAME: inventory.idl 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(008B3C84-93A5-11C9-85B0-08002B147A61), /* universal unique identifier<CO>*/
version(1.0),                               /* version of this interface  <CO>*/
pointer_default(ptr)                        /* pointer default            <CO>*/
] interface  inventory                      /* interface name             <CO>*/
{
   const long MAX_STRING = 30;                /* constant for string size <CO>*/

   typedef long     part_num;                    /* inventory part number <CO>*/

   typedef [string] char part_name[MAX_STRING+1];/* name of part          <CO>*/

   typedef [string, ptr] char *paragraph;        /* description of part   <CO>*/

   typedef enum {
      ITEM, GRAM, KILOGRAM
   } part_units;                                 /* units of measurement  <CO>*/

   typedef struct part_price {                   /* price of part         <CO>*/
      part_units units;
      double     per_unit;
   } part_price;

   typedef union switch(part_units units) total {/* quantity of part      <CO>*/
      case ITEM:     long int number;
      case GRAM:
      case KILOGRAM: double   weight;
   } part_quantity;

   typedef struct part_list{                     /* list of part numbers  <CO>*/
      long                     size;           /* number of parts in array  */
      [size_is(size)] part_num numbers[*];     /* conformant array of parts */
   } part_list;

   typedef struct part_record {                  /* data for each part      */
      part_num      number;
      part_name     name;
      paragraph     description;
      part_price    price;
      part_quantity quantity;
      part_list     subparts;    
   } part_record;

   typedef long account_num;                     /* user account number     */

   /************************ Procedure Declarations *************************/
   boolean is_part_available(           /* return true if in inventory    <CO>*/
#ifdef INV_EXP
      [in] handle_t binding_h,
#endif
      [in] part_num number              /* input part number */
   );

   void whatis_part_name(               /* get part name from inventory   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,           /* input part number */
      [out] part_name name              /* output part name  */
   );

   paragraph get_part_description(      /* return a pointer to a string   <CO>*/
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number
   );

   void whatis_part_price(              /* get part price from inventory    */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num   number,
      [out] part_price *price
   );

   void whatis_part_quantity(           /* get part quantity from inventory */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num      number,
      [out] part_quantity *quantity
   );

   void whatare_subparts(               /* get list of subpart numbers      */
#ifdef INV_EXP
      [in]  handle_t binding_h,
#endif
      [in]  part_num  number,
      [out] part_list **subparts        /* structure containing the array <CO>*/
   );

   /* Order part from inventory with part number, quantity desired, and     */
   /* account number.  If inventory does not have enough, output lesser     */
   /* quantity ordered.  Return values:  1=ordered OK,                      */
   /* -1=invalid part, -2=invalid quantity, -3=invalid account.             */

   long order_part(   /* order part from inventory, return OK or error code */
#ifdef INV_EXP
      [in]     handle_t binding_h,
#endif
      [in]     part_num      number,
      [in,out] part_quantity *quantity,               /* quantity ordered <CO>*/
      [in]     account_num   account
   );
} /* end of interface definition */
                                                                                                                                                                                                            0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_CLIENT.C;1 +  , rI   .     /  @   4 T      
                     - (    0   1    2   3      K  P   W   O 
    5   6    7 
j  8          9          G  @  H  J $ N                   ?               /* FILE NAME: i_client.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */N /******************** Client of the inventory application *******************/ #include <stdio.h>   #include <stdlib.h> P #include "inventory.h"         /* header file created by the IDL compiler <CO>*/ #include <ctype.h>  M char instructions[] = "Type character followed by appropriate argument(s).\n\ 7    Is part available?               a  [part_number]\n\ 7    What is part name?               n  [part_number]\n\ 7    Get part description.            d  [part_number]\n\ 7    What is part price?              p  [part_number]\n\ 7    What is part quantity?           q  [part_number]\n\ 7    What are subparts of this part?  s  [part_number]\n\ ?    Order part.                      o  part_number  quantity\n\ (    REDISPLAY                        r\n\)    EXIT                             e\n";    main() { N    part_record part;                /* structure for all data about a part  */N    part_list   *subparts;           /* pointer to parts list data structure */N    account_num account = 1234;      /* a user account number                */      int i, num_args, done = 0;     long result; 0    char input[100], selection[20], quantity[20];    char *strcpy();      puts(instructions);    part.number = 0;     strcpy(quantity, "");N    while(!done) {            /* user makes selections and each is processed */;       printf("Selection: ");  fflush(stdout);  gets(input); O       num_args = sscanf(input, "%s%ld%s", selection, &(part.number), quantity);   &       switch (tolower(selection[0])) {P       case 'a': if (is_part_available(part.number)                                                                                                                                                                                                                                                   >                        ܆͛ $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         E{ "     *       )                     /*<CO>*/*                    puts("available: Yes");                 else)                    puts("available: No");                  break;P       case 'n': whatis_part_name(part.number, part.name);               /*<CO>*//                 printf("name:%s\n", part.name);                  break;P       case 'd': part.description = get_part_description(part.number);   /*<CO>*/?                 printf("description:\n%s\n", part.description); ,                 if(part.description != NULL)K                    free(part.description);      /* free memory allocated */                  break;  P       case 'p': whatis_part_price(part.number, &(part.price));          /*<CO>*/>                 printf("price:%10.2f\n", part.price.per_unit);                 break;  P       case 'q': whatis_part_quantity(part.number, &(part.quantity));    /*<CO>*//                 if(part.quantity.units == ITEM) K                    printf("total items:%ld\n", part.quantity.total.number); 4                 else if(part.quantity.units == GRAM)N                    printf("total grams:%10.2f\n", part.quantity.total.weight);8                 else if(part.quantity.units == KILOGRAM)N                    printf("total kilos:%10.2f\n", part.quantity.total.weight);                 break;P       case 's': whatare_subparts(part.number, &subparts);               /*<CO>*/3                 for(i = 0; i < subparts->size; i++) 9                    printf("%ld  ", subparts->numbers[i]); K                 printf("\ntotal number of subparts:%ld\n", subparts->size); N                 free(subparts);        /* free memory for conformant struct */                 break;"       case 'o': if(num_args < 3) {0                    puts("Not enough arguments");                    break;                  } E                 /* Assume KILOGRAM units and assign quantity input */ /                 part.quantity.units = KILOGRAM; <                 part.quantity.total.weight = atof(quantity);T                 result = order_part(part.number, &(part.quantity), account);/*<CO>*/                  if(result > 0) {2                    if(part.quantity.units == ITEM)P                       printf("ordered %ld items\n", part.quantity.total.number);7                    else if(part.quantity.units == GRAM) S                       printf("ordered %10.2f grams\n", part.quantity.total.weight); ;                    else if(part.quantity.units == KILOGRAM) S                       printf("ordered %10.2f kilos\n", part.quantity.total.weight);                  } (                 else { /* error cases */@                    if(result == -1) puts("Invalid part number");B                    else if(result == -2) puts("Invalid quantity");H                    else if(result == -3) puts("Invalid account number");                 }                  break;N       case 'r':   /* redisplay selection or bad input displays instructions */,       default:  puts(instructions);  break; !       case 'e': done = 1;  break;        } /*end case */     } /* end while */ } /* end main() */                                                                                                                                                                                                                                                                                                                                                      @             : * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_CLIENT.COM;1 +  , xI	   .     /  @   4 ,       ^                   - (    0   1    2   3      K  P   W   O     5   6 o  7  4o  8          9          G  @  H  J $ N                   ?                            , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run i_client                                                                                                                                                                                                                                                                                                                                                                                                                                @             < * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_PROCEDURES.C;1 +  , ~I   .     /  @   4 P      
                     - (    0   1    2   3      K  P   W   O     5   6  !   7 "j  8          9          G  @  H  J $ N                   ?                           /* FILE NAME: i_procedures.c   **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */P /*** Implementation of the remote procedures for the inventory application. ***/ #include <stdio.h> #include "inventory.h" #include <stdlib.h>  #include <string.h>  #ifdef LOCALN    /* stub support procedures are redefined for a local test of application */ #define rpc_ss_allocate mallocN    /* In a distributed RPC application, rpc_ss_free is called automatically */N    /* by the server stub. In a local test, data is not automatically freed. */ #define rpc_ss_free free #endif   int read_part_record();  int write_part_record();  % idl_boolean is_part_available(number)  part_num number; { H    part_record *part;                   /* a pointer to a part record */
    int found;      ,    found = read_part_record(number, &part);     if(found)       return(idl_true);     else        return(idl_false); }     # void whatis_part_name(number, name)  part_num  number;  part_name name;  {   H    part_record *part;                   /* a pointer to a part record */    char * strncpy();   #    read_part_record(number, &part); 9    strncpy((char *)name, (char *)part->name, MAX_STRING); 
    return; }     & paragraph get_part_description(number) part_num  number;  { H    part_record *part;                   /* a pointer to a part record */    paragraph description;     int size;    char *strcpy();  *    if( read_part_record(number, &part) ) {K       /* Allocated data that is returned to the client must be allocated */ K       /* with the rpc_ss_allocate stub support routine.                  */ 3       size = strlen((char *)part->description) + 1; ?       description = (paragraph)rpc_ss_allocate((unsigned)size); =       strcpy((char *)description, (char *)part->description);     }    else        description = NULL;     return(description);  }     % void whatis_part_price(number, price)  part_num   number; part_price  *price;  { H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); $    price->units = part->price.units;*    price->per_unit = part->price.per_unit;
    return; }     + void whatis_part_quantity(number, quantity)  part_num      number;  part_quantity *quantity; {   H    part_record *part;                   /* a pointer to a part record */     $    read_part_record(number, &part); *    quantity->units = part->quantity.units;    switch(quantity->units) {F       case ITEM: quantity->total.number = part->quantity.total.number;                  break;        case KILOGRAM:F       case GRAM: quantity->total.weight = part->quantity.total.weight;                  break;     }
    return; }     * void whatare_subparts(number, subpart_ptr) part_num  number;  part_list **subpart_ptr; { F    part_record *part;                   /* pointer to a part record */	    int i;     int size;   #    read_part_record(number, &part);   N    /* Allocated data that is output to the client must be allocated with    */N    /* the rpc_ss_allocate stub support routine.  Allocate for a part_list   */N    /* struct plus the array of subpart numbers.  Remember the part_list     */N    /* struct already has an array with one element, hence the -1.           */K    size = sizeof(part_list) + (sizeof(part_num) * (part->subparts.size-1)); ?    *subpart_ptr = (part_list *)rpc_ss_allocate((unsigned)size);       /* fill in the values */ .    (*subpart_ptr)->size = part->subparts.size;,    for(i = 0; i < (*subpart_ptr)->size; i++)=       (*subpart_ptr)->numbers[i] = part->subparts.numbers[i]; 
    return; }     2 idl_long_int order_part(number, quantity, account) part_num      number;  part_quantity *quantity; account_num   account; { >    part_record *part;           /* pointer to a part record */  5    long error = 1;  /* assume no error to start */        /* Test for valid input */ P    if( !read_part_record(number, &part) ) /* invalid part number input        */        error = -1;                                                                                                                                                                                                                                                      ?                        &G $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                          "     ;                   P    else if(quantity->units == ITEM)       /* invalid quantity input           */9       error = (quantity->total.number <= 0) ? -2 : error; B    else if(quantity->units == GRAM || quantity->units == KILOGRAM);       error = (quantity->total.weight <= 0.0) ? -2 : error; P    /* else if()                              invalid account, not implemented */%    /*    error = -3;               */     if(error < 0)       return(error);  I    /* convert input quantity & units if units are not correct for part */ 0    if(quantity->units != part->quantity.units) {J       if(part->quantity.units == ITEM)     /* convert weight to items   */G          quantity->total.number = (idl_long_int)quantity->total.weight; J       else if(quantity->units == ITEM)     /* convert items to weight   */I          quantity->total.weight = (idl_long_float)quantity->total.number; J       else if(quantity->units == GRAM && part->quantity.units == KILOGRAM)K          quantity->total.weight /= 1000.0; /* convert grams to kilograms */ J       else if(quantity->units == KILOGRAM && part->quantity.units == GRAM)K          quantity->total.weight *= 1000.0; /* convert kilograms to grams */ -       quantity->units = part->quantity.units;     }  4    /* check if enough in inventory for this order */!    switch(part->quantity.units) { 
    case ITEM: >       if(part->quantity.total.number > quantity->total.number)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.number -= quantity->total.number;        else {H          /* order all available and reduce quantity in inventory to 0 */>          quantity->total.number = part->quantity.total.number;)          part->quantity.total.number = 0;        }        break;    case KILOGRAM: 
    case GRAM: >       if(part->quantity.total.weight > quantity->total.weight)=          /* reduce quantity in inventory by amount ordered */ ?          part->quantity.total.weight -= quantity->total.weight;        else {J          /* order all available and reduce quantity in inventory to 0.0 */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          P} ~      
INVENTORY.SAV                  ~I  y'  <[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_PROCEDURES.C;1                                                                   P                                    
       >          quantity->total.weight = part->quantity.total.weight;+          part->quantity.total.weight = 0.0;        }        break;    }     5    write_part_record(part);    /* update inventory */       return(1); /* order ok */ }                                                                                                                                                                                                                                                                                 0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]I_SERVER.C;1 +  , I	   .     /  @   4 V       '                   - (    0   1    2   3      K  P   W   O     5   6 折  7 囶折  8          9          G  @  H  J $ N                   ?              /* FILE NAME: i_server.c 
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#if defined(VMS)
#include <descrip.h>
#include <ssdef.h>
#include <lnmdef.h>
#include <starlet.h>
#endif
#include <ctype.h>
#include "inventory.h"              /* header created by the IDL compiler <CO>*/
#include "check_status.h"           /* contains the CHECK_STATUS macro      */
#define STRINGLEN 50

void open_inventory();
void close_inventory();

main (argc, argv)
int argc;
char *argv[];
{
   unsigned32           status;          /* error status (nbase.h)        <CO>*/
                                         /* RPC vectors                   <CO>*/
   rpc_binding_vector_t *binding_vector; /* binding handle list (rpcbase.h) */
   rpc_protseq_vector_t *protseq_vector; /*protocol sequence list(rpcbase.h)*/

   char entry_name[STRINGLEN];           /* name service entry name         */
   char group_name[STRINGLEN];           /* name service group name         */
   char annotation[STRINGLEN];           /* annotation for endpoint map     */
   static char hostname[STRINGLEN];  
   char *strcpy(), *strcat();    
   /************************** REGISTER INTERFACE ***************************/
   rpc_server_register_if(                                             /* <CO>*/
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      NULL,
      NULL,
      &status
   );
   CHECK_STATUS(status, "Can't register interface:", ABORT);            /*<CO>*/
  
   /****************** CREATING SERVER BINDING INFORMATION ******************/
   if(argc > 1) {
      rpc_server_use_protseq(             /* use a protocol sequence      <CO>*/
         (unsigned_char_t *)argv[1],      /* the input protocol sequence    */
         rpc_c_protseq_max_calls_default, /* (rpcbase.h)                    */
         &status
      );    
      CHECK_STATUS(status, "Can't use this protocol sequence:", ABORT);
   }
   else {
      puts("You can invoke the server with a protocol sequence argument.");
      rpc_server_use_all_protseqs(        /* use all protocol sequences   <CO>*/
         rpc_c_protseq_max_calls_default, /* (rpcbase.h)                    */
         &status
      );    
      CHECK_STATUS(status, "Can't register protocol sequences:", ABORT);
   }

   rpc_server_inq_bindings(     /* get all binding information for server <CO>*/
      &binding_vector,
      &status
   );
   CHECK_STATUS(status, "Can't get binding information:", ABORT);

   /*************************** ADVERTISE SERVER ****************************/

   strcpy(entry_name, "/.:/inventory_");

    /*
     * get the host name and initialize the entry name in the table
     */

#if defined(VMS)
    /*
     *  Use sys$trnlnm() to remove dependency on UCX.
     *  NOTE that we do not use sys$getsyi() since not every system
     *  have SCSNODE defined.
     */
{
    $DESCRIPTOR (sys_table, "LNM$SYSTEM_TABLE");
    $DESCRIPTOR (dnet_name,  "SYS$NODE");
    $DESCRIPTOR (inet_name,  "UCX$INET_HOST");
    static int	hostname_len;
    long lnm_status;

    struct
    {
          short   buf_len;
          short   item_code;
          char    *buf_addr;
          int     *ret_len;
          int     *null_item;
    } itmlst = {
                STRINGLEN,
                LNM$_STRING,
                hostname,
                &hostname_len,
                NULL
               };

    lnm_status = sys$trnlnm (0, &sys_table, &dnet_name, 0, &itmlst);

    if (lnm_status != SS$_NORMAL)
    {
       lnm_status = sys$trnlnm (0, &sys_table, &inet_name, 0, &itmlst);
       if (lnm_status != SS$_NORMAL)
       {
       fprintf (stderr, "Failed to execute SYS$TRNLNM\n");
       exit (lnm_status);
       }
    }
    else
       /*
        *  Remove trailing "::" for Decnet
        */
        hostname [hostname_len - 2] = '\0';
}
#else
   gethostname(hostname, STRINGLEN);
#endif
   strcat(entry_name, hostname);
   rpc_ns_binding_export(          /* export to a name service database   <CO>*/
      rpc_c_ns_syntax_default,     /* syntax of entry name (rpcbase.h)      */
      (unsigned_char_t *)entry_name, /* name of entry in name service       */
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      binding_vector,              /* binding information                   */
      NULL,                        /* no object UUIDs exported              */
      &status 
   );
   CHECK_STATUS(status, "Can't export to name service database:", RESUME);

   strcpy(group_name, "/.:/inventory_group");
   rpc_ns_group_mbr_add(           /* add as member of name service group <CO>*/
      rpc_c_ns_syntax_default,       /* syntax of group name (rpcbase.h)    */
      (unsigned_char_t *)group_name, /* name of group in name service       */
      rpc_c_ns_syntax_default,       /* syntax of member name (rpcbase.h)   */
      (unsigned_char_t *)entry_name, /* name of member in name service      */
      &status 
   );
   CHECK_STATUS(status, "Can't                                                                                                                                                                                                                                                    @                        zĐ $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                          "     L       add group member to name service database:", RESUME);

   /*************************** MANAGE ENDPOINTS ****************************/
   strcpy(annotation, "Inventory interface");
   rpc_ep_register(                /* add endpoints to local endpoint map <CO>*/
      inventory_v1_0_s_ifspec,     /* interface specification (inventory.h) */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* no object UUIDs to register           */
      (unsigned_char_t *)annotation, /* annotation supplied (not required)  */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", RESUME);

   rpc_binding_vector_free(                /* free server binding handles <CO>*/
      &binding_vector,
      &status
   );
   CHECK_STATUS(status, "Can't free server binding handles:", RESUME);

   open_inventory();                      /* application specific procedure */

   /******************* LISTEN FOR REMOTE PROCEDURE CALLS *******************/
   TRY                                 /* thread exception handling macro <CO>*/
      rpc_server_listen(                                                /*<CO>*/
         1,                  /* process one remote procedure call at a time */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);

   FINALLY                                /* error recovery and cleanup     */
      close_inventory();                  /* application specific procedure */
      rpc_server_inq_bindings(                 /* get binding information <CO>*/
         &binding_vector,
         &status
      );
      CHECK_STATUS(status, "Can't get binding information:", RESUME);

      rpc_ep_unregister(      /* remove endpoints from local endpoint map <CO>*/
         inventory_v1_0_s_ifspec,  /* interface specification (inventory.h) */
         binding_vector,           /* vector of server binding handles      */
         NULL,                     /* no object UUIDs                       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from local endpoint map:", RESUME);

      rpc_binding_vector_free(             /* free server binding handles <CO>*/
         &binding_vector,
         &status
      );  
      CHECK_STATUS(status, "Can't free server binding handles:", RESUME);

      puts("\nServer quit!");
   ENDTRY
}  /* END SERVER INITIALIZATION */
                                                                                                                                                                                                                         @             @ * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]LOCAL_I_CLIENT.COM;1 +  , 5J   .     /  @   4 ,       d                   - (    0   1    2   3      K  P   W   O     5   6 f  7 0f  8          9          G  @  H  J $ N                   ?                      , $ rpc_default_entry == "/.:/inventory_group" $ define sys$input sys$command $ run local_i_client                                                                                                                                                                                                                                                                                                                                                                                                                          @             ? * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]LOCAL_I_CLIENT.SH;1 +  , HJ   .     /  @   4 /       Z                   - (    0   1    2   3      K  P   W   O     5   6 Wi  7 Wi  8          9          G  @  H  J $ N                   ?                       def_log RPC_DEFAULT_ENTRY "/.:/inventory_group"
local_i_client
del_log RPC_DEFAULT_ENTRY

                                                                                                                                                                                                                                                                                                                                                                                                                                      @             > * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]MAKEFILE.GENERAL;1 +  , I   .     /  @   4 \                         - (    0   1    2   3      K  P   W   O 	    5   6   7 $  8          9          G  @  H  J $ N                   ?                        # FILE NAME: makefile 
# Makefile for the inventory application 
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 13-Aug-1993 burgher Modified file to build under VMS/POSIX on VAX/AXP
#
# definitions for this make file 
#
APPL=inventory
DCL_IDL= dcl mcr dce\$$idl
IDL_FLAGS= -v -cpp_cmd -keep c_source
IDLCMD=$(DCL_IDL) $(IDL_FLAGS)
CFLAGS_INIT = -U VMS -I. -G
#LIBDCE=-ldce -lcma -li -ldnet        # dce and internationalization libraries
CHECK=../arithmetic     # directory containing check_status.h 
CC= c89
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt # dce and internationalization libraries 
MAKE=make -f makefile.general

#
# COMPLETE BUILD of the application.
#

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi
                                        
build:	local ostubs client server

#
# LOCAL BUILD of the application to test locally.
#
local:	i_client.c i_procedures.c implement_inventory.c
	$(CC) $(C_FLAGS) -DLOCAL -o local_i_client i_client.c \
		i_procedures.c implement_inventory.c
	#remove the object files so they do not interfere with a real build
	rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
#<COMMENT>Build the interface definition from pieces shown in book
#<ENDCOMMENT>
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl

#
# STUBS BUILD
#
ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o	$(APPL)_sstub.o:	$(APPL)_cstub.c	$(APPL)_sstub.c
	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(C_FLAGS) -o i_client i_client.o $(APPL)_cstub.o $(OPTFILE)

i_client.o:	i_client.c
			$(CC) $(C_FLAGS) -c i_client.c

#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(C_FLAGS) -I$(CHECK) -o i_server i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(OPTFILE)

i_server.o:	i_server.c
			$(CC) $(C_FLAGS) -c i_server.c

i_procedures.o:	i_procedures.c
			$(CC) $(C_FLAGS) -c i_procedures.c

implement_inventory.o:	implement_inventory.c
			$(CC) $(C_FLAGS) -c implement_inventory.c

clean:
	rm -f *.o $(APPL).h i_server i_client local_i_client 
#<ENDCOMMENT>
                                                                               @             ; * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]MAKEFILE.OSF1;1 +  , I   .     /  @   4 S                          - (    0   1    2   3      K  P   W   O 	    5   6 5a  7 a  8          9 #ΚL!b  G  @  H  J $ N                   ?               
            # FILE NAME: Makefile 
# Makefil                                                                                                                                                                                                                                                   A                        (O $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                         6 "     ]       e for the inventory application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file 
#
APPL=inventory
IDLCMD=idl -v
LIBDCE=-ldce -lcma      # dce and thread libraries
CHECK=../arithmetic     # directory containing check_status.h
CFLAGS= -D_USER_THREADS_
CC= cc 


#
# COMPLETE BUILD of the application.
#
all:	local interface client server


#
# LOCAL BUILD of the application to test locally.
#
local:	interface i_client.c i_procedures.c implement_inventory.c
	   $(CC) $(CFLAGS) -DLOCAL -o local_i_client.exe i_client.c \
		  i_procedures.c implement_inventory.c
#remove the object files so they do not interfere with a real build
	   rm i_client.o i_procedures.o implement_inventory.o 


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILD 
#
client:	i_client
i_client:	i_client.o $(APPL)_cstub.o
	   $(CC) $(CFLAGS) -o i_client.exe i_client.o $(APPL)_cstub.o $(LIBDCE)


#
# SERVER BUILD 
#
server:	i_server
i_server:	$(APPL).h i_server.o i_procedures.o implement_inventory.o $(APPL)_sstub.o
	   $(CC) $(CFLAGS) -I$(CHECK) -o i_server.exe i_server.o i_procedures.o \
		   implement_inventory.o \
		   $(APPL)_sstub.o $(LIBDCE)
i_server.o:	i_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c i_server.c
                                                                                                                                                                                                                                                                                             0             8 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]README.LIS;1 +  , I   .     /  @   4 b       T                  - (    0   1    2   3      K  P   W   O     5   6 
  7 
  8          9          G  @  H  J $ N                   ?  ,            
taken from Appendix D of Guide to Writing DCE Applications, by John Shirley

 




                      COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.






                                                                        D
        _________________________________________________________________

                                                The Inventory Application


              The inventory application allows a user to inquire about
              and order from a simple inventory. Data structures are
              defined in the interface definition for the following
              items:

                 Part number (to identify a part)
                 Part name
                 Part description
                 Part price
                 Quantity of part
                 Part list
                 Account number (to identify a user)

              Procedures are also defined in the interface definition to
              do the following:

                 Confirm if a part is available.
                 Obtain a part name.
                 Obtain a part description.
                 Obtain a part price.
                 Obtain the quantity of parts available.
                 Obtain a list of subpart numbers.
                 Order a part.

              The application demonstrates many features of IDL and RPC
              application development including:

              o  Using strings, pointers, structures, a union, and a
                 conformant array.

              o  Allocating new memory in a remote procedure for data
                 returned to the client using stub support routines.
                 The get_part_description and whatare_subparts remote
                 procedures demonstrate server allocation of a string and
                 a conformant structure.

              o  Managing protocol sequences, interpreting binding
                 information, selecting binding information, and using
                 exception handler macros.

              o  Variations on a client using ACFs and the automatic,
                 implicit, and explicit binding methods.

              o  Finding a server by importing from a name service
                 database.

   How to build the executables
	For the OpenVMS/POSIX environments:

		psx> cd /mydev/mydir
	 	psx> copy /usr/dce/examples/gde_dce_apps/inventory/* .
		psx> mkdir /mydev/mydir/explicit		
		psx> cd /mydev/mydir/explicit
		psx> copy /usr/dce/examples/gde_dce_apps/inventory/explicit * .
		psx> mkdir /mydev/mydir/implicit    
		psx> cd /mydev/mydir/explicit
		psx> copy /usr/dce/examples/gde_dce_apps/inventory/implicit * .
		
		In /mydev/mydir
                psx> make -f makefile.general 
	             This builds the server, i_client and local_i_client
	
		In /mydev/mydir/implicit
		psx> make -f makefile.implicit
	             This builds the implicit clients (local and distributed)

		In /mydev/mydir/explicit
		psx> make -f makefile.explicit
		     This builds the explicit clients (local and distributed)
	NOTE: After building each type of client cleanup the environment for
	      files left behind from previous builds:
	
		psx> make -f makefile.[general or implicit or explicit] clean

	For OpenVMS environments:

	Running INVENTORY.COM creates all the top-level executables for the 
        inventory application.

         	C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory]*.* []
                C$ @inventory

	Build the Implicit version
		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory.implicit]*.* []
		C$ @implicit

	Build the Implicit version
		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.inventory.explicit]*.* []
		C$ @explicit

   How to Run the Application

        To run the NONDISTRIBUTED LOCAL test of the application,
        enter the following commands:

	   For the OpenVMS/POSIX environments:

         	psx> local_i_client


    	   For OpenVMS environments, define a foreign command with the full 
	   directory specification:
         
         	C$ local_i_client :== "$mydisk:[inven-directory]local_i_client.exe"
         	C$ local_i_client


   	To run the server of the distributed application, first perform 
	dce_login as a principal that is a member of the 
	/.:/subsys/dce/cds-servers group or use cell_admin. 

	   For the OpenVMS/POSIX environment, enter the following commands:
              
         	psx> dce_login
			# Principal entered must be a member 
	                  of /.:/subsys/dce/cds-servers, or use cell_admin    
	 	psx> server.sh     
                        # Checks presence of credentials and invokes inventory 
	                  server 

	   For the OpenVMS environment, 	Define a foreign command with the full directory specification:

	 	S$ dce_login ! reply with principal name & password at prompts 
         	S$ i_server :== $mydisk:[inven-directory]i_server.exe              

	        Then, to run the server of the application, enter the 
	        following command:

	         S$ i_server

	To run the client of the distributed application:

	   For the OpenVMS/POSIX envi                                                                                                                                                                                                                                                   B                        Yj~ $      DCEAXPMUPA013.A                j0  i.  ;[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]INVENTORY.SAV;1                                                                      ~   ~                          "     n       ronment, enter the following command:
              	
         	psx> implicit_client.sh 
		     # This script sets RPC_DEFAULT_ENTRY = /.:/inventory_group & invokes i_client              
		     # and runs the implicit client.

         	psx> explicit_client.sh 
		     # This script sets RPC_DEFAULT_ENTRY = /.:/inventory_group & invokes i_client              
		     # and runs the explicit client.

           For the OpenVMS environments, the symbol is defined in i_client.com.
	   Enter the following commands:
              
	        C$ implicit_client :== @mydisk:[inven-directory]implicit_client.com              
	        C$ implicit_client 
		   For the implicit client

	        C$ explicit_client :== @mydisk:[inven-directory]explicit_client.com              
	        C$ explicit_client 
		   For the explicit client

 

              Application Files

              Makefile.general:  The Makefile contains descriptions of how the
              application (server, i_client and local_i_client) is compiled. 

              Makefile.implicit:  The Makefile contains descriptions of how the
              implicit client (local and distributed) is compiled. 

              Makefile.explicit:  The Makefile contains descriptions of how the
              explicit client (local and distributed) is compiled. 

              Makefile.osf1:  The Makefile for OSF/1 systems.

              inventory.com: The command procedure file for building on 
	      OpenVMS systems.

              i_client.sh:  This file is a shell script to set the
              environment and execute the client (i_client) that uses automatic
              binding management.

              i_client.com:  This file is a command procedure file to set the
              environment and execute the client (i_client) that uses automatic
              binding management.

              implicit_client.sh:  This file is a shell script to set the
              environment and execute the implicit client.

              implicit_client.com:  This file is a command procedure file to set the
              environment and execute the implicit client.

              explicit_client.sh:  This file is a shell script to set the
              environment and execute the explicit client.

              explicit_client.com:  This file is a command procedure file to set the
              environment and execute the explicit client.

	      server.sh:  This file is a shell script to set the environment
	      and execute the explicit client.

              inventory.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              i_client.c:  For this application, the client displays
              the instructions for the user and in a loop processes user
              input until exit is selected. Each remote procedure is
              exercised depending on the input from the user.

              i_procedures.c:  This is the implementation of all the
              remote procedures defined in this interface.

              implement_inventory.c:  This is the implementation of the
              inventory database. For simplicity, only three inventory
              items are included. The part numbers for these are printed
              when the inventory is opened.

              i_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls. In
              addition to the required calls, this server also selects a
              specific protocol sequence, uses exception handling macros,
              and does some basic cleanup when the server quits.

              implicit-inventory.acf:  An attribute configuration file
              is used to customize how you use an interface. In this
              application it is used to select the implicit binding
              method.

              implicit_client.c:  This client imports a binding
              handle from the name service database.

              do_import_binding.c:  This contains the do_import_
              binding procedure, which shows how to import a binding
              handle from the name service database.

              do_interpret_binding.c:  This contains the do_
              interpret_binding procedure, which shows how to obtain the
              binding information a binding handle references.

              explicit.com: The command procedure file for building
              the explicit client. 

              The server for the explicit client is the same as the one
              for the automatic and implicit clients.

              explicit-inventory.acf:  An attribute configuration file
              is used to customize how you use an interface. In this
              application it is used to select the explicit binding
              method for all remote procedures in the interface.

              explicit_client.c:  This client imports a binding
              handle from the name service database. All procedures have
              a binding handle as the first parameter.

              Note: explicit/implicit Example Programs are not supported in the EFT release.



                                                                                                                                                                            0             7 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.INVENTORY]SERVER.SH;1 +  , I   .     /  @   4 t       <                   - (    0   1    2   3      K  P   W   O     5   6 (j𳒗  7 𳒗  8          9          G  @  H  J $ N                   ?               # Shell to check credentials and establish enviromental for the Arithmetic Server.  Burgher
# 19-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"
if [ -z "$CREDS" ]
then
        echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
        echo " OR use the cell_admin principal:"
        exit 1
fi
trap 'while true
do 
break
done' INT QUIT TERM EXIT
i_server
echo "Inventory Server Exiting"
#
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C                        ߘc $      DCEAXPMUPA013.A                +  5  3[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]REMOTE_FILE.DIR;1                                                                                                         ?            3 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]REMOTE_FILE.DIR;1 +  , +   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6 <з   7 :   8          9          G  @  H   J  I                        REMOTE_FILE.SAV  7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ? * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1 +  , 7   .     /  @   4   ~           ~               - +    0   1    2   3      K  P   W   O     5   6 1k?  7 h   8          9          G  @  H   J                                             ~      REMOTE_FILE.SAV                                                                                                                                                                                                              REMOTE_FILE.SAV:  BACKUP SRC$:*.* OBJ$:REMOTE_FILE.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   ۦ?      V5.5	 	 _OPENUP:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                         $ * [RPCREMOTE_FILE.SRC]CHECK_STATUS.H;1 +  , !I   .     /  @   4 P       %                  - Z)    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                  /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                                                                                                                                         ' * [RPCREMOTE_FILE.SRC]CONTEXT_RUNDOWN.C;1 +  , &I	   .     /  @   4 N       *                   - Z)    0   1    2   3      K  P   W   O     5   6 1]  7 QȖ]  8          9 #ΚL!b  G  @  H  J $ N                   ?               /* FILE NAME: context_rundown.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "remote_file.h"

void filehandle_rundown(remote_fh)  
filehandle remote_fh;               /* the context handle is passed in      */
{
   fprintf(stderr, "Server executing context rundown\n");
   if( (FILE *)remote_fh != stdout )
      fclose( (FILE *)remote_fh );  /* the file is closed if client is gone */
   remote_fh = NULL;                /* must set context handle to NULL      */
   return;   
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ) * [RPCREMOTE_FILE.SRC]DO_STRING_BINDING.C;1 +  , ,I	   .     /  @   4 Y                          - Z)    0   1    2   3      K  P   W   O 	    5   6 }BTF  7 uTF  8          9          G  @  H  J $ N                   ?             /* FILE NAME: do_string_binding.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Find a server binding handle from strings of binding information        */
/* including protocol sequence, host address, and server process endpoint. */
#include <stdio.h>
#include <dce/rpc.h>
#include "check_status.h"               /* contains the CHECK_STATUS macro */
#include "remote_file.h"

int do_string_binding(host, binding_h) /* return=0 if binding valid,  else -1 */
char             host[];  /* server host name or network address is input <CO>*/
rpc_binding_handle_t *binding_h;      /* binding handle is output (rpcbase.h) */
{
   rpc_protseq_vector_t *protseq_vector; /* protocol sequence list (rpcbase.h)*/
   unsigned_char_t      *string_binding; /* string of binding info. (lbase.h) */
   unsigned32           status;          /* error status (nbase.h)            */
   int                  i, result;

   rpc_network_inq_protseqs( /* obtain a list of valid protocol sequences <CO>*/
      &protseq_vector,               /* list of protocol sequences obtained */ 
      &status
   );
   CHECK_STATUS(status, "Can't get protocol sequences:", ABORT);

   /* loop through protocol sequences until a binding handle is obtained */
   for(i=0; i < protseq_vector->count; i++) {

      rpc_string_binding_compose(  /* make string binding from components <CO>*/
         NULL,                           /* no object UUIDs are required    */
         protseq_vector->protseq[i],     /* protocol sequence               */
         (unsigned_char_t *)host,        /* host name or network address    */
         NULL,                           /* no endpoint is required         */
         NULL,                           /* no network options are required */
         &string_binding,                /* the constructed string binding  */
         &status
      );
      CHECK_STATUS(status, "Can't compose a string binding:", RESUME);
   
      rpc_binding_from_string_binding(/* convert string to binding handle <CO>*/
         string_binding,            /* input string binding                 */
         binding_h,                 /* binding handle is obtained here      */
         &status
      );
      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't convert string to binding handle:", RESUME);
      }
      else 
         result = 0;

      rpc_string_free(                     /* free string binding created <CO>*/
         &string_binding, 
         &status
      );
      CHECK_STATUS(status, "Can't free string binding:", RESUME);

      rpc_ep_resolve_binding(
         *binding_h,                /* binding handle is obtained here      */
         remote_file_v1_0_c_ifspec,/* if spec is required here             */
         &status
      );

      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't get endpoint information:", RESUME);
	 rpc_binding_free(
	    binding_h,
	    &status
	 );
	 CHECK_STATUS(status, "Can't free binding handle:", RESUME); 
      }
      else
         result = 0;

      if(result == 0)
	 break;                        /* got a valid binding */
      else
	 fprintf(stderr, "  %s:%s is not a server registered binding, trying next binding...\n",
		    protseq_vector->protseq[i],(unsigned_char_t *)host);
   }

   rpc_protseq_vector_free(        /* free the list of protocol sequences <CO>*/
      &protseq_vector, 
      &status
   );
   CHECK_STATUS(status, "Can't free protocol sequence vector:", RESUME);
   if (result == 0)
   {
	rpc_binding_to_string_binding(
	    *binding_h,
	    &string_binding,
	    &status
	);
	CHECK_STATUS(status, "Can't convert binding to string binding:", RESUME);
	fprintf(stderr, "Using string binding: %s\n", string_binding);
	rpc_string_free(    /* free string binding created <CO>*/
         &string_binding, 
         &status
	);
	CHECK_STATUS(status, "Can't free string binding:", RESUME);
   }
   return(result);
}
                                                                                                          * [RPCREMOTE_FILE.SRC]GET_ARGS.C;1 +  , 1I
   .     /  @   4 J                                                                                                                                                                      D                        ԸyH $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         + "                1                   - Z)    0   1    2   3      K  P   W   O     5   6 QK]  7 a]  8          9 #ΚL!b  G  @  H  J $ N                   ?                      /* FILE NAME: get_args.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h> 

get_args(argc, argv, local_fh, host, remote_name)
int  argc;
char *argv[];
FILE **local_fh;
char host[];
char remote_name[];
{
   char local_name[100];
   char *strcpy();
   void exit();

   switch(argc) {
   case 1:
   case 2: printf("Usage: %s [local_file] host [remote_file]\n", argv[0]);
           puts("Use \"\" for local stdin.");
           exit(0);
           break;
   case 3: strcpy(local_name, argv[1]);  /* use the same file name */
           strcpy(remote_name, local_name);
           strcpy(host, argv[2]);
           break;
   default: strcpy(local_name, argv[1]);
           strcpy(host, argv[2]);
           strcpy(remote_name, argv[3]);
           break;
   }
   if(strlen(local_name) == 0) {
      (*local_fh) = stdin;
      puts("Using stdin.  Type input:");
   }
   else
      if( ( (*local_fh) = fopen(local_name, "r")) == NULL ) {
         puts("Cannot open local file");
         exit(1);
      }
   return;
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              * [RPCREMOTE_FILE.SRC]MAKEFILE.;1 +  , 9I	   .     /  @   4 \                         - Z)    0   1    2   3      K  P   W   O 	    5   6 (t  7 :u  8          9          G  @  H  J $ N                   ?                       # FILE NAME: Makefile 
# Makefile for the remote_file application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 27-Jul-1993 Burgher Modified for OpenVMS/POSIX & added .o and .c target/dep statements
#
# definitions for this make file
#
DCL_IDL= dcl mcr dce\$$idl
IDL= $(DCL_IDL)
CFLAGS_INIT = -U VMS -I.
IDL_CFLAGS= -v -keep c_source
CC = c89
LIBDCE=/vms/sys0/syscommon/dce\$$library/dce.opt    # dce and internationalization libraries
APPL=remote_file
IDLCMD= $(IDL) $(IDL_CFLAGS)
CHECK=../arithmetic      # Directory containing check_status.h
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`

default: interface machine

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi  

#
# COMPLETE BUILD of the distributed application.
#

#
# INTERFACE BUILD 
#
interface:	$(APPL).h  $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl

build:	local ostubs client server

#
# LOCAL BUILD of the client application to test locally.
#

local:
local_r_client:	r_client.c get_args.c r_procedures.c
		$(CC) $(C_FLAGS) -DLOCAL -o local_r_client \
		r_client.c get_args.c r_procedures.c
		# 	remove object files so they do not interfere with a real build
		rm r_client.o get_args.o r_procedures.o 

# STUB OBJECTS BUILD
#
ostubs: $(APPL)_cstub.o $(APPL)_sstub.o
$(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c
			$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c

#
# CLIENT BUILD 
#
client:	r_client
r_client:	$(APPL).h r_client.o get_args.o do_string_binding.o $(APPL)_cstub.o
			$(CC) $(C_FLAGS) -o r_client r_client.o \
			get_args.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)

r_client.o:		r_client.c
					$(CC) $(C_FLAGS) -c r_client.c

get_args.o:		get_args.c
					$(CC) $(C_FLAGS) -c get_args.c

do_string_binding.o:	do_string_binding.c
				$(CC) $(C_FLAGS) -I$(CHECK) -c do_string_binding.c
	
#
# SERVER BUILD 
#
server:	r_server 
r_server:	$(APPL).h r_server.o r_procedures.o context_rundown.o $(APPL)_sstub.o 
			$(CC) $(C_FLAGS) -I$(CHECK) -o r_server r_server.o \
			r_procedures.o context_rundown.o $(APPL)_sstub.o $(LIBDCE)

r_server.o:	r_server.c
			$(CC) $(C_FLAGS) -I$(CHECK) -c r_server.c
                        
context_rundown.o:	context_rundown.c
			$(CC) $(C_FLAGS) -c context_rundown.c
                        
r_procedures.o:		r_procedures.c
					$(CC) $(C_FLAGS) -c r_procedures.c

clean:
	rm -f r_client r_server *.o $(APPL)*stub.c $(APPL).h 
                                 * [RPCREMOTE_FILE.SRC]README.LIS;1 +  , I   .     /  @   4 K       6                   - Z)    0   1    2   3      K  P   W   O     5   6 M  7 4N  8          9          G  @  H  J $ N                   ?                      
taken from Appendix E of Guide to Writing DCE Applications, by John Shirley

 


	                  COPYRIGHT (C) 1993 BY
		   DIGITAL EQUIPMENT CORPORATION, MAYNARD
                    MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.






                                                                        E
        _________________________________________________________________

                                              The Remote_file Application


              The remote_file client copies ASCII data from the client to
              the server. The source can be a data file or the standard
              input of the client. The target on the server system is
              either a file or the server standard output. The remote_
              file application demonstrates some advanced features of IDL
              and RPC application development including the following:

              o  Using a context handle with a context rundown procedure.

              o  Using the explicit binding method with a primitive
                 binding handle.

              o  Finding a server using strings of binding information.


   How to Build the Application

              To run the local test of the application, use an ASCII text
              file as input and a new data file as output. The host is
              not relevant for the local test. 

	For OpenVMS/POSIX environments, enter the following commands:
		psx> cd	/dev/mydir/examp_dir
		psx> copy /usr/dce/examples/gde_dce_apps/remote_file/*.* .
		psx> make 

	For OpenVMS systems, enter the following commands:

		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.remote_file]*.* []
		C$ @remote_file

	           Running REMOTE_FILE.COM creates all (Local and distributed)
	           the executables for the remote_file application.

   How to Run the Application

	To run the LOCAL / NONDISTRIBUTED test 

	   For OpenVMS/POSIX environments:

		psx> local_r_client input  host  output

	   For OpenVMS environments:

	      Define a foreign command with the full directory specification:

		C$ local_r_client :==                                                                                                                                                                                                                                                    E                        {I $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     !       $mydisk:[rem-directory]local_r_client.exe

              Then, run the client:

		C$ local_r_client input  host  output

	To run the DISTRIBUTED test

	   Server For OpenVMS/POSIX environments, enter the following command:

		psx> r_server

	   Server For OpenVMS environments, enter the following command:

	      Define a foreign command with the full directory specification:

		S$ r_server :== $mydisk:[rem-directory]r_server.exe

              Then, run the server:

		S$ r_server

	To run the client of the distributed application to
	transfer ASCII data, use an ASCII text file as input and
	a new data file on the server host as output If the server
	is running on a remote host use the network address as the
	"host". 


	   Client for OpenVMS/POSIX, enter the following command:

		psx> r_client. input  host  output

	   Client for OpenVMS systems, enter the following command:

	      Define a foreign command with the full directory specification:

		C$ r_client :== $mydisk:[rem-directory]r_client.exe

              Then, run the client:

		C$ r_client input  host  output




              Application Files

              Makefile:  This Makefile contains descriptions of how the
              application is compiled for OpenVMS/POSIX.

	      remote_file.com:  The command procedure file for building the 
	      application on OpenVMS systems.

              remote_file.idl:  The interface definition contains the
              description of the data types and procedures for the
              interface.

              r_client.c:  For this application, the client interprets
              the user input by calling the application specific
              procedure get_args. A binding handle representing the
              information about a client-server relationship is obtained
              from strings of binding information. The remote procedure
              remote_open is called to open the server target file. A
              buffer is allocated for a conformant array. The application
              loops reading source data and sending the buffer of data
              to the target with a remote procedure call to remote_send.
              Finally, the remote procedure remote_close is called to
              close the target file.

              get_args.c:  The user input is interpreted to obtain the
              name of a local client ASCII file of source data, the
              server host to use, and the server target file.

              do_string_binding.c:  This contains the do_string_binding
              procedure which shows how to find a server from strings
              of binding information. A host name or network address is
              input and then combined with a generated protocol sequence
              to create a valid binding handle which is returned as a
              parameter.

              r_procedures.c:  This is the implementation of the remote
              procedures defined in the remote_file interface.

              context_rundown.c:  This is the implementation of a context
              rundown procedure which is called automatically by the
              server stub if communication breaks between a client and
              a server which is maintaining context for the client. For
              this application, the context is a file handle of a server
              data file. This context rundown procedure closes the file.


              r_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls.
              In this application, all protocol sequences available are
              registered. The server is not advertised in a name service
              database. The server's dynamic endpoints are added to the
              server's local endpoint map. A client finds this server
              by constructing a string binding containing a protocol
              sequence and the host name or network address.




                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        % * [RPCREMOTE_FILE.SRC]REMOTE_FILE.COM;1 +  , I   .     /  @   4 L       
                   - Z)    0   1    2   3      K  P   W   O 	    5   6 d  7 Uڲd  8          9          G  @  H  J $ N                   ?     
             $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:= $!	REMOTE_FILE.COM -- Builds the remote_file example program   $! $! Modification History:, $! 01-Sep-1993 fwb Modified for VMS DCE V1.1 $!J $! Determine which compiler is being used and establish the linker options $ @DCE:DCE$CC_TEST' $ If( f$trnlnm( "dce$cc" ) .eqs. " " )	 I $ Then	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ Else	options = "dce:dce.opt/options" $ Endif - $! Enable the universal IDL command interface  $idl := mcr dce$idl  $ " $! Compile the interface defintion $idl  remote_file.idl  $   $ cc/g_float/include=[] r_server $ cc := cc'f$trnlnm("dce$cc")' $ ) $! Build the local version of the example B $cc/g_float/define=LOCAL/include=[] r_client,get_args,r_proceduresA $link/exe=local_r_client r_client,get_args,r_procedures,'options' 8 $delete r_client.obj;*,get_args.obj;*,r_procedures.obj;* $  $! Build the remote_file client / $cc/g_float r_client,get_args,do_string_binding E $link r_client,get_args,do_string_binding,remote_file_cstub,'options'  $  $! Build the remote_file server 3 $cc/g_float/include=[] r_procedures,context_rundown G $link r_server,r_procedures,context_rundown,remote_file_sstub,'options'  $ > $! Example command definitions to invoke r_server and r_clientJ $ local_r_client == "$ " + f$environment("DEFAULT") + "local_r_client.exe"> $ r_server == "$ " + f$environment("DEFAULT") + "r_server.exe"> $ r_client == "$ " + f$environment("DEFAULT") + "r_client.exe"                                                                                                                                                                                                                                                                  % * [RPCREMOTE_FILE.SRC]REMOTE_FILE.IDL;1 +  , I
   .     /  @   4 N       ^                  - Z)    0   1    2   3      K  P   W   O     5   6 ]  7 ]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: remote_file.idl 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(016B2B80-F9B4-11C9-B31A-08002B111685),
version(1.0)
]
interface remote_file  /* file manipulation on a remote system */
{
   typedef [context_handle] void *filehandle;  /*<CO>*/
   typedef                  byte buffer[];

filehandle remote_open(       /* open for write  <CO>*/
   [in] handle_t binding_h,   /* explicit primitive binding handle     */
   [in, string] char name[],  /* if name is null, use stdout in server */
   [in, string] char mode[]   /* values can be "r", "w", or "a"        */
);

long remote_send(
   [in] filehandle fh,                         /*<CO>*/                       
   [in, max_is(max)] buffer buf,
   [in] long max
);

void remote_close(
   [in,out] filehandle *fh                     /*<CO>*/
);
}
                                                                                                                                                                                  * [RPCREMOTE                                                                                                                                                                                                                                                   F                        -; $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     2       _FILE.SRC]R_CLIENT.C;1 +  , I	   .     /  @   4 P       H                   - Z)    0   1    2   3      K  P   W   O 	    5   6 {bbw  7 2bw  8          9          G  @  H  J $ N                   ?          
            /* FILE NAME: r_client.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <string.h>
#include "remote_file.h"
#define MAX 200         /* maximum line length for a file */

void get_args( int argc,
               char *argv[], 
	       FILE **local_fh, 
               char host[], 
               char remote_name[] );

int do_string_binding( char host[],
                       rpc_binding_handle_t *binding_h );

main(argc, argv)
int argc;
char *argv[];
{
   FILE         *local_fh;            /* file handle for client file input  */
   char         host[100];        /* name or network address of remote host */
   idl_char     remote_name[100];     /* name of remote file                */
   rpc_binding_handle_t binding_h;    /* binding handle                     */
   filehandle   remote_fh;            /* context handle                     */
   buffer       *buf_ptr;             /* buffer pointer for data sent       */
   int          size;                 /* size of data buffer                */
   void exit();
   char *malloc();

   get_args(argc, argv, &local_fh, host, (char *)remote_name);
#ifndef LOCAL   
   if(do_string_binding(host, &binding_h) < 0) {                        /*<CO>*/
      fprintf(stderr, "Cannot get binding\n");
      exit(1);
   }
#endif
   remote_fh = remote_open(binding_h, remote_name, (idl_char *)"w");    /*<CO>*/
   if(remote_fh == NULL) {
      fprintf(stderr, "Cannot open remote file\n");
      exit(1);
   }
   /* A conformant array has an array size of 1 in the header file so       */
   /* memory must be allocated for the rest of the array elements desired.  */
   /* The MAX_IS attribute in the interface definition defines a variable   */
   /* representing the maximum index value for the array and since arrays   */
   /* in C begin with 0, memory must be allocated for MAX+1 elements.       */
   buf_ptr = (buffer *)malloc((MAX+1) * sizeof(buffer));

   while( fgets((char *)buf_ptr, MAX, local_fh) != NULL) {
      size = (int)strlen((char *)buf_ptr); /* data sent will not include \0 */
      if( remote_send(remote_fh, (*buf_ptr), size) < 1) {               /*<CO>*/
         fprintf(stderr, "Cannot write to remote file\n");
         exit(1);
      }
   }
   remote_close(&remote_fh);                                            /*<CO>*/
}
                                                                                                                                                                                                      $ * [RPCREMOTE_FILE.SRC]R_PROCEDURES.C;1 +  , I   .     /  @   4 U       _                   - Z)    0   1    2   3      K  P   W   O     5   6  :TF  7  TF  8          9          G  @  H  J $ N                   ?                  /* FILE NAME: r_procedures.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "remote_file.h"

filehandle remote_open(binding_h, name, mode)  /*<CO>*/
rpc_binding_handle_t binding_h;
idl_char             name[];
idl_char             mode[];
{
   FILE *FILEh;

   if(strlen((char *)name) == 0)            /* no file name given */
      if(strcmp((char *)mode, "r") == 0)
         FILEh = NULL;                 /* cannot read nonexistent file        */
      else FILEh = stdout;             /* use server stdout instead of a file */

   else if(access((char *)name, F_OK) == 0) /* file exists */
      if(strcmp((char *)mode, "w") == 0)
#ifdef VMS
	FILEh = fopen((char *)name, (char *)mode);  /* open for write */
#else
        FILEh = NULL;                 /* do not overwrite existing file      */
#endif
      else FILEh = fopen((char *)name, (char *)mode);  /* open for read or append */

   else                             /* file does not exist  */
      if(strcmp((char *)mode, "r") == 0) 
         FILEh = NULL;                 /* cannot read nonexistent file        */
      else FILEh = fopen((char *)name, (char *)mode);  /* open for write or append */

   return( (filehandle)FILEh );        /* cast FILE handle to context handle  */
}


idl_long_int remote_send(fh, buf, max)         /*<CO>*/
filehandle fh;
buffer buf;
idl_long_int max;
{
   /* write data to the file (context), which is cast as a FILE pointer */
   return( fwrite(buf, sizeof(buffer), max, (FILE *)fh) );
}


void remote_close(fh)                          /*<CO>*/
filehandle *fh;   /* the client stub needs the changed value upon return */
{
   if( (FILE *)(*fh) != stdout )
      fclose( (FILE *)(*fh) );
   (*fh) = NULL;         /* assign NULL to the context handle to free it */
   return;
}
                                                                                                                                                                                 * [RPCREMOTE_FILE.SRC]R_SERVER.C;1 +  , I   .     /  @   4 P       v                    - Z)    0   1    2   3      K  P   W   O 	    5   6  -4RF  7  TF  8          9          G  @  H  J $ N                   ?                      /* FILE NAME: r_server.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "remote_file.h"               /* header created by the idl compiler */
#include "check_status.h"              /* contains the CHECK_STATUS macro    */
main ()
{
   int			  i;
   unsigned32             status;          /* error status (nbase.h)         */
   rpc_binding_vector_t   *binding_vector; /* binding handle list (rpcbase.h)*/

   rpc_server_register_if(       /* register interface with the RPC runtime */
      remote_file_v1_0_s_ifspec, /* handle for interface specification      */
      NULL,                     
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(            /* establish protocol sequences  */
      rpc_c_protseq_max_reqs_default,      /* queue length for remote calls */
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(     /* get set of this server's binding handles */
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   rpc_ep_register(                /* add endpoint to local endpoint map    */
      remote_file_v1_0_s_ifspec,   /* handle for interface specification    */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* P                                                                                                                           AN ~      REMOTE_FILE.SAV                I  Z)   [RPCREMOTE_FILE.SRC]R_SERVER.C;1                                                                                               P                              >             no object UUIDs to register           */
      (unsigned_char_t *)"remote_file server", /* annotation (not required) */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", ABORT);

   for (i = 0; i < binding_vector->count; i++)
   {
        unsigned_char_p_t sb;

        rpc_binding_to_string_binding(
	    binding_vector->binding_h[i],
	    &sb,
	    &status
	);
	CHECK_STATUS(status, "Can't get string binding:", RESUME);

        fprintf (stderr, "Got binding: %s\n", sb);

        rpc_string_free(
	    &sb,
	    &status
	);
	CHECK_STATUS(status, "Can't free string binding:", RESUME);
    }
   puts("Listening for remote procedure calls...");
   TRY
      rpc_server_listen(                   /* listen for remote calls       */
         rpc_c_listen_max_calls_default,   /* number of threads             */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);
   FINALLY
      puts("Removing endpoints from local endpoint map.");
      rpc_ep_unregister(     /* remove endpoints from local endpoint map    */
         remote_file_v1_0_s_ifspec,  /* handle for interface specificaiton  */
         binding_vector,             /* vector of server binding handles    */
         NULL,                                                                                                                                                                                                                                                         G                        Z# $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         a "     C                        /* no object UUIDs to unregister       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from endpoint map:", RESUME);

      rpc_binding_vector_free(               /* free set of binding handles */
         &binding_vector,
         &status
      ); 
      CHECK_STATUS(status, "Can't free binding handles and vector\n", ABORT);
   ENDTRY
}
                                                                                                                                                                                                                                                                                                                                                                                                                         * [RPCREMOTE_FILE.SRC]UNISTD.H;1 +  , I
   .     /  @   4        &                    - Z)    0   1    2   3      K  P   W   O     5   6 `
T{A  7 UUF  8          9 $AF  G  @  H  J $ N                   ?                         #include <unixio.h>  #define F_OK 4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 H                        < $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                          "     T                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          I                         $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                         #x "     e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          J                        I $      DCEAXPMUPA013.A                7  +  ?[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.REMOTE_FILE]REMOTE_FILE.SAV;1                                                                  ~   ~                               v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   5 * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]TRANSFER_DATA.DIR;1 +  , )   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6    7 (@   8          9          G  @  H   J  I                      TRANSFER_DATA.SAV  )(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               C * [SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1 +  , )(   .     /  @   4   ~           ~               - )    0   1    2   3      K  P   W   O     5   6 5?  7    8          9          G  @  H   J                                                        \x ~      TRANSFER_DATA.SAV                                                                                                                                                                                            T                TRANSFER_DATA.SAV<  BACKUP SRC$:*.* OBJ$:TRANSFER_DATA.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   `5?      V5.5	 	 _OPNVMS:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                       * [RPCTRANSFER_DAT.SRC]BINDING.C;1 +  , QI   .     /  @   4 U                          - (    0   1    2   3      K  P   W   O     5   6  ?(  7 &0"  8          9          G  @  H  J $ N                   ?                       /* FILE NAME: binding.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */G #include "transfer_data.h"     /* header created by the IDL compiler */ G #include "check_status.h"      /* contains the CHECK_STATUS macro    */     P handle_t file_spec_bind(spec)  /* binding procedure for customized handle <CO>*/ file_spec spec;  { "    rpc_binding_handle_t binding_h;    int do_string_binding();   5    if(do_string_binding(spec.host, &binding_h) < 0) { .       fprintf(stderr, "Cannot get binding\n");       exit(1);    }    return(binding_h);  }   U void file_spec_unbind(spec, binding_h) /*unbind procedure for customized handle<CO>*/  file_spec spec;  handle_t binding_h;  {   )    unsigned32 status;  /* error status */   )    rpc_binding_free(&binding_h, &status); >    CHECK_STATUS(status, "Can't free binding handle:", RESUME);
    return; }                                                                                                                                   % * [RPCTRANSFER_DAT.SRC]CHECK_STATUS.H;1 +  , UI   .     /  @   4 P       %                  - (    0   1    2   3      K  P   W   O     5   6 )>]  7 N]  8          9 #ΚL!b  G  @  H  J $ N                   ?                 /* FILE NAME: check_status.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include <dce/dce_error.h>   /* required to call dce_error_inq_text routine   */
#include <dce/pthread.h>     /* needed if application uses threads            */
#include <dce/rpcexc.h>      /* needed if application uses exception handlers */

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
   if(input_status != rpc_s_ok) { \
      dce_error_inq_text(input_status, error_string, &error_stat); \
      fprintf(stderr, "%s %s\n", comment, error_string); \
      if(action == ABORT) \
         exit(1); \
   } \
}

static int            error_stat;
static unsigned char  error_string[dce_c_error_string_len];

void exit();
                                                                                                                           p                                                                                                                                   K                        m $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         
 "                                                                                                                          % * [RPCTRANSFER_DAT.SRC]CLIENT_ALLOC.C;1 +  , XI   .     /  @   4 P                          - (    0   1    2   3      K  P   W   O     5   6  o]  7 F0"  8          9          G  @  H  J $ N                   ?                 /* FILE NAME: client_alloc.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "transfer_data.h"
#include "pipe_state.h"

#define BUFFER_SIZE 2000
idl_short_float client_buffer[BUFFER_SIZE];

void client_alloc(state, bsize, buf, bcount)     /* allocation for a pipe <CO>*/
pipe_state          *state;           /* coordinates pipe procedure calls <CO>*/
idl_ulong_int       bsize;            /* desired size of buffer in bytes  <CO>*/
idl_short_float     **buf;            /* allocated buffer                 <CO>*/
idl_ulong_int       *bcount;          /* allocated buffer size in bytes   <CO>*/
{
    *buf = client_buffer;
    *bcount = BUFFER_SIZE;
    return;
}
                                                                                                                                                                                                                                                                                                                ' * [RPCTRANSFER_DAT.SRC]CLIENT_RECEIVE.C;1 +  , ^I
   .     /  @   4 P                           - (    0   1    2   3      K  P   W   O 	    5   6  <l  7 ``0"  8          9          G  @  H  J $ N                   ?                /* FILE NAME: client_receive.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */7 /* Client for customized handle and output pipe test */  #include <stdio.h> #include <string.h>  #include "transfer_data.h"P #include "pipe_state.h"  /* definition of a state structure for pipe data <CO>*/ void exit();   main(argc, argv)	 int argc; 
 char *argv[];  { I    file_spec  cust_binding_h;            /* customized binding handle  */     pipe_state state;P    pipe_type  data;                      /* a pipe structure is allocated <CO>*/     char       local_target[100];/               /* procedures in other modules */ (    void       client_alloc(),out_push();    void       receive_floats();        /* get user input */     if(argc < 4) { H       printf("USAGE: %s  local_target  host  remote_source\n", argv[0]);       exit(0);    }  7    /* initialize customized binding handle structure */ !    strcpy(local_target, argv[1]); 0    strcpy((char *)cust_binding_h.host, argv[2]);4    strcpy((char *)cust_binding_h.filename, argv[3]);   "    /* initialize pipe structure */!    state.filename = local_target;     state.filehandle = -1;     state.start_output = true; P    data.state = (rpc_ss_pipe_state_t)&state;     /* initialize pipe state <CO>*/P    data.alloc = client_alloc; /* initialize alloc procedure for a pipe    <CO>*/P    data.push = out_push;      /* Initialize push procedure for output pipe<CO>*/     P    receive_floats(cust_binding_h, &data);/* procedure with an output pipe <CO>*/ }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $ * [RPCTRANSFER_DAT.SRC]CLIENT_SEND.C;1 +  , I	   .     /  @   4 P                           - (    0   1    2   3      K  P   W   O 	    5   6   7 @}0"  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: client_send.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */6 /* Client for customized handle and input pipe test */ #include <stdio.h> #include <string.h>  #include "transfer_data.h"P #include "pipe_state.h"  /* definition of a state structure for pipe data <CO>*/   void exit();   main(argc, argv)	 int argc; 
 char *argv[];  { I    file_spec  cust_binding_h;            /* customized binding handle  */     pipe_state state;P    pipe_type  data;                      /* a pipe structure is allocated <CO>*/     char       local_source[100];/               /* procedures in other modules */ (    void       client_alloc(), in_pull();    void       send_floats();       /* get user input */     if(argc < 4) { H       printf("USAGE: %s  local_source  host  remote_target\n", argv[0]);       exit(0);    }7    /* initialize customized binding handle structure */ !    strcpy(local_source, argv[1]); 1    strcpy((char *)cust_binding_h.host, argv[2]);  5    strcpy((char *)cust_binding_h.filename, argv[3]);     "    /* initialize pipe structure */!    state.filename = local_source;     state.filehandle = -1;     state.start_output = false;P    data.state = (rpc_ss_pipe_state_t)&state;     /* initialize pipe state <CO>*/P    data.alloc = client_alloc; /* initialize alloc procedure for a pipe    <CO>*/P    data.pull = in_pull;       /* Initialize pull procedure for input pipe <CO>*/     P    send_floats(cust_binding_h, data); /* remote procedure with input pipe <CO>*/ }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       0             * * [RPCTRANSFER_DAT.SRC]DO_STRING_BINDING.C;1 +  , I   .     /  @   4 Q       O                  - (    0   1    2   3      K  P   W   O 	    5   6 ]  7   8          9          G  @  H  J $ N                   ?                            /* FILE NAME: do_string_binding.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Find a server binding handle from strings of binding information        */
/* including protocol sequence, host address, and server process endpoint. */
#include <stdio.h>
#include <dce/rpc.h>
#include "check_status.h"               /* contains the CHECK_STATUS macro */

int do_string_binding(host, binding_h) /* return=0 if binding valid,  else -1 */
char             host[];  /* server host name or network address is input <CO>*/
rpc_binding_handle_t *binding_h;      /* binding handle is output (rpcbase.h) */
{
   rpc_protseq_vector_t *protseq_vector; /* protocol sequence list (rpcbase.h)*/
   unsigned_char_t      *string_binding; /* string of binding info. (lbase.h) */
   unsigned32           status;          /* error status (nbase.h)            */
   int                  i, result;

   rpc_network_inq_protseqs( /* obtain a list of valid protocol sequences <CO>*/
      &protseq_vector,               /* list of protocol sequences obtained */ 
      &status
   );
   CHECK_STATUS(status, "Can't get protocol sequences:", ABORT);

   /* loop through protocol sequences until a binding handle is obtained */
   for(i=0; i < protseq_vector->count; i++) {

      rpc_string_binding_compose(  /* make string binding from components <CO>*/
         NULL,                           /* no object UUIDs are required    */
         protseq_vector->protseq[i],     /* protocol sequence               */
         (unsigned_char_t *)host,        /* host name or network address    */
         NULL,                           /* no endpoint is required         */
         NULL,                           /* no network options are required */
         &string_binding,                /* the constructed string binding  */
         &status
      );
      CHECK_STATUS(status, "Can't compose a string binding:", RESUME);
   
      rpc_binding_from_string_binding(/* convert string to binding handle <CO>*/
         string_binding,            /* input string binding                 */
         binding_h,                 /* binding handle is obtained here      */
                                                                                                                                                                                                                                                       L                        Uq^, $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                          "                 &status
      );
      if(status != rpc_s_ok) {
         result = -1;
         CHECK_STATUS(status, "Can't convert string to binding handle:", RESUME);
      }
      else 
         result = 0;

      rpc_string_free(                     /* free string binding created <CO>*/
         &string_binding, 
         &status
      );
      CHECK_STATUS(status, "Can't free string binding:", RESUME);
      if(result == 0)  break;                        /* got a valid binding */
   }

   rpc_protseq_vector_free(        /* free the list of protocol sequences <CO>*/
      &protseq_vector, 
      &status
   );
   CHECK_STATUS(status, "Can't free protocol sequence vector:", RESUME);
   return(result);
}
                                                                                                                                                                                               # * [RPCTRANSFER_DAT.SRC]FLOAT_UTIL.C;1 +  , I   .     /  @   4 V                          - (    0   1    2   3      K  P   W   O 	    5   6  [v  7 `ʝ0"  8          9          G  @  H  J $ N                   ?       
             /* FILE NAME: float_util.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */D /* utility to generate or read a file of float data to test pipes */ #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif   void exit(); static write_floats(); static read_floats();    main(argc, argv)	 int argc; 
 char *argv[];  { "    char choice[20], filename[100];      if(argc == 1)  { ?       printf("Usage: %s [write | read] [filename]\n", argv[0]); 3       puts("Enter w to create a file, r to read:");        gets(choice);     }    else        strcpy(choice, argv[1]);    if(argc > 2)         strcpy(filename, argv[2]);    else        strcpy(filename, "");       if(choice[0] == 'w')        write_floats(filename);     else        read_floats(filename); }    write_floats(file) char file[]; {     char filename[100];    int filehand;    long num, i;     float *buf, x;          strcpy(filename, file);    if(strlen(filename) == 0) {0       puts("enter name of data file to create");       gets(filename);     }A    filehand = open(filename, O_CREAT | O_TRUNC | O_WRONLY, 0777);     if(filehand == 0) {C       fprintf(stderr, "Cannot open file %s for write\n", filename);        exit(0);    }.    puts("enter number of data items desired");    fscanf(stdin, "%ld", &num);.    buf = (float *)malloc(sizeof(float) * num);M    for(i=0, x=1.1; i < num; i++, x+=0.4567) {  /* insert arbitrary numbers */        buf[i] =  x;       printf("%f\n", buf[i]);     }A    write(filehand, (char *)buf, (int)(sizeof(float) * num) );         close(filehand);  }      read_floats(file)  char file[]; {     char filename[100];    int filehand;*    long num, i, total, bytesread, numread;    float *buf;      strcpy(filename, file);    if(strlen(filename) == 0) {.       puts("enter name of data file to read");       gets(filename);     }-    filehand = open(filename, O_RDONLY, NULL);     if(filehand == 0) {@       fprintf(stderr, "Cannot open file %s for read", filename);       exit(0);    }    num = 5; total = 0;.    buf = (float *)malloc(sizeof(float) * num);V    while((bytesread = read(filehand, (char *)buf, (int)(sizeof(float) * num) )) > 0) {(       numread = bytesread/sizeof(float);        for(i=0; i < numread; i++)           printf("%f  ", buf[i]);       puts("");        total+=numread;     }&    printf("Total read: %ld\n", total);    close(filehand);  }                                         * [RPCTRANSFER_DAT.SRC]IN_PULL.C;1 +  , I   .     /  @   4 P                           - (    0   1    2   3      K  P   W   O 	    5   6    7 ս0"  8          9          G  @  H  J $ N                   ?                       /* FILE NAME: in_pull.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS) #include <unixio.h>  #endif #include "transfer_data.h"N #include "pipe_state.h"    /* definition of a state structure for pipe data */ void exit();  P void in_pull(state, buf, esize, ecount)/* input pipe uses a pull procedure<CO>*/P pipe_state      *state;               /* coordinates pipe procedure calls <CO>*/P idl_short_float *buf;                 /* buffer of data pulled            <CO>*/P idl_ulong_int   esize;                /* maximum element count in buffer  <CO>*/P idl_ulong_int   *ecount;              /* actual element count in buffer   <CO>*/ { I    /* for this application, open local source file if not open already */ !    if(state->filehandle == -1) {  @       state->filehandle = open(state->filename, O_RDONLY, NULL);#       if(state->filehandle == -1) { L          fprintf(stderr, "Cannot open file %s for read\n", state->filename);          exit(0);        }     },    /* process buffer for your application */P    *ecount = read(state->filehandle, buf, (sizeof(float)*esize))/sizeof(float);   P    /* To signal the end of data, pull procedure must set the count to 0   <CO>*/H    if(*ecount == 0) {  /* end of data reached, do application cleanup */!       close(state->filehandle);   P       /* if pipe is an in/out parameter, set the flag for push procedure  <CO>*/"       state->start_output = true;     }
    return; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       * [RPCTRANSFER_DAT.SRC]MAKEFILE.;1 +  , I	   .     /  @   4 N      	                    - (    0   1    2   3      K  P   W   O 
    5   6 %!  7 x7  8          9          G  @  H  J $ N                   ?                      # FILE NAME: Makefile 
# Makefile for the customized handle and pipes application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
# 01-Sep-1993 fwb Modified for OpenVMS/DCE POSIX
# definitions for this make file
#
APPL=transfer_data
DCL_IDL= dcl mcr dce\$$idl
IDL_CFLAGS= -v -keep c_source
IDL= $(DCL_IDL) $(IDL_CFLAGS)
ALIGN = -W member_alignment
MACHINE_TYPE:=`uname -Wh`
CFLAGS_INIT = -U VMS -I.
CC = c89
OPTFILE=/vms/sys0/syscommon/dce\$$library/dce.opt

default:	interface machine

#
# INTERFACE BUILD 
#

interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c
$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl
		$(IDL) $(APPL).idl

machine:
	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \
	echo "Complile & Link for VMS/Posix VAX" ; \
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\
	else ; echo "Compile & Link for VMS/Posix AXP:" ;\
	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\
	fi

build:		utility	local	client	server
#
# COMPLETE BUILD of the application

#
# BUILD OF UTILITY to create and read files of float data  
#
utility:	float_util
float_util:	float_util.c
	$(CC) $(C_FLAGS) -o float_util float_util.c 

#
# LOCAL BUILD of the clients to test locally.
#
local:	local_client_send  local_client_receive

local_client_send:	client_send.c client_alloc.c in_pull.c \
			   send_floats.c
	   $(CC) $(C_FLAGS) -DLOCAL -I. -o                                                                                                                                                                                                                                                   M                        Z $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         FT "     )        local_client_send \
		client_send.c client_alloc.c in_pull.c send_floats.c 
# remove object files so they do not interfere with a real build
	   rm  client_send.o  send_floats.o  client_alloc.o  in_pull.o     

local_client_receive:	client_receive.c client_alloc.c out_push.c \
			   receive_floats.c
	   $(CC) $(C_FLAGS) -DLOCAL -I. \
		-o local_client_receive client_receive.c \
		client_alloc.c out_push.c receive_floats.c
# remove object files so they do not interfere with a real build
		rm  client_receive.o receive_floats.o client_alloc.o out_push.o

#
# CLIENT BUILDS  
#
client:	client_send	client_receive      

client_send:	client_send.o client_alloc.o in_pull.o \
		binding.o do_string_binding.o $(APPL)_cstub.o 
		$(CC) $(C_FLAGS) -o client_send \
			client_send.o client_alloc.o in_pull.o \
			binding.o do_string_binding.o $(APPL)_cstub.o $(OPTFILE)

client_send.o:	client_send.c
		$(CC) $(C_FLAGS) -c client_send.c
in_pull.o:	in_pull.c
		$(CC) $(C_FLAGS) -I. -c in_pull.c

client_receive:	client_receive.o client_alloc.o out_push.o \
		binding.o do_string_binding.o $(APPL)_cstub.o 
		$(CC) $(C_FLAGS) -o client_receive \
			client_receive.o client_alloc.o out_push.o \
			binding.o do_string_binding.o \
			$(APPL)_cstub.o $(OPTFILE)

client_receive.o:	client_receive.c 
		$(CC) $(C_FLAGS) -c client_receive.c 

out_push.o:	out_push.c
		$(CC) $(C_FLAGS) -I. -c out_push.c

$(APPL)_cstub.o:	$(APPL)_cstub.c
		$(CC) $(C_FLAGS) -c $(APPL)_cstub.c
#
# modules needed by both clients 
#
client_alloc.o:	client_alloc.c
		$(CC) $(C_FLAGS) -I. -c client_alloc.c

binding.o:	binding.c
		$(CC) $(C_FLAGS) -c binding.c
	   
# module needed from remote_file application 
do_string_binding.o:	do_string_binding.c
		$(CC) $(C_FLAGS) -c do_string_binding.c


#
# SERVER BUILD.  Notice the server stub auxiliary file is required. 
#
server:	t_server
t_server:	$(APPL).h t_server.o send_floats.o receive_floats.o $(APPL)_sstub.o 
		$(CC) $(C_FLAGS) -o t_server t_server.o \
			send_floats.o receive_floats.o \
			$(APPL)_sstub.o $(OPTFILE)

t_server.o:	t_server.c
		$(CC) $(C_FLAGS) -c t_server.c

$(APPL)_sstub.o:	$(APPL)_sstub.c
		$(CC) $(C_FLAGS) -I. -c $(APPL)_sstub.c

clean:
	rm -f *.o $(APPL).h $(APPL)*stub.c local_client_receive \
		float_util t_server client_send client_receive
                                                                            $ * [RPCTRANSFER_DAT.SRC]MAKEFILE.OSF1;1 +  , I	   .     /  @   4 ]      	                    - (    0   1    2   3      K  P   W   O 
    5   6 +<a  7 8=a  8          9 #ΚL!b  G  @  H  J $ N                   ?                  # FILE NAME: Makefile 
# Makefile for the customized handle and pipes application
#------------------------------------------------------------------------/
#			COPYRIGHT (C) 1993 BY
#                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
#                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
#
# THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
# ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
# OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
# THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
# PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
#
# THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
# SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
#
# DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
# SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
#
#------------------------------------------------------------------------/
#
# definitions for this make file
#
APPL=transfer_data
IDLCMD=idl -v  
CHECK=../arithmetic      # Directory containing check_status.h
LIBDCE=-ldce -lcma       # dce and thread libraries 
CFLAGS= -D_USER_THREADS_ 
CC= cc 


#
# COMPLETE BUILD of the application
#
all:	utility local interface client server


#
# BUILD OF UTILITY to create and read files of float data  
#
utility:	float_util
float_util:	float_util.c
	$(CC) $(CFLAGS) -o float_util.exe float_util.c 


#
# LOCAL BUILD of the clients to test locally.
#
local:	interface  local_client_send  local_client_receive

local_client_send:	client_send.c client_alloc.c in_pull.c \
			   send_floats.c
	   $(CC) $(CFLAGS) -DLOCAL -I. -o local_client_send.exe \
		   client_send.c client_alloc.c in_pull.c send_floats.c 
# remove object files so they do not interfere with a real build
	   rm  client_send.o  send_floats.o  client_alloc.o  in_pull.o     

local_client_receive:	client_receive.c client_alloc.c out_push.c \
			   receive_floats.c
	   $(CC) $(CFLAGS) -DLOCAL -I. \
		   -o local_client_receive.exe client_receive.c \
		   client_alloc.c out_push.c receive_floats.c
# remove object files so they do not interfere with a real build
	   rm  client_receive.o receive_floats.o client_alloc.o out_push.o


#
# INTERFACE BUILD 
#
interface:	$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o $(APPL)_saux.o
$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o $(APPL)_saux.o:	$(APPL).idl
	   $(IDLCMD) $(APPL).idl


#
# CLIENT BUILDS  
#
client:	client_send  client_receive 
client_send:	client_send.o client_alloc.o in_pull.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o client_send.exe \
		   client_send.o client_alloc.o in_pull.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)
client_send.o:	client_send.c
	   $(CC) $(CFLAGS) -c client_send.c
in_pull.o:	in_pull.c
	   $(CC) $(CFLAGS) -I. -c in_pull.c

client_receive:	client_receive.o client_alloc.o out_push.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o client_receive.exe \
		   client_receive.o client_alloc.o out_push.o \
		   binding.o do_string_binding.o $(APPL)_cstub.o $(LIBDCE)
client_receive.o:	client_receive.c 
	   $(CC) $(CFLAGS) -c client_receive.c 
out_push.o:	out_push.c
	   $(CC) $(CFLAGS) -I. -c out_push.c

#
# modules needed by both clients 
#
client_alloc.o:	client_alloc.c
	   $(CC) $(CFLAGS) -I. -c client_alloc.c

binding.o:	binding.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c binding.c
	   
# module needed from remote_file application 
do_string_binding.o:	../remote_file/do_string_binding.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c ../remote_file/do_string_binding.c


#
# SERVER BUILD.  Notice the server stub auxiliary file is required. 
#
server:	t_server
t_server:	$(APPL).h t_server.o send_floats.o receive_floats.o $(APPL)_sstub.o $(APPL)_saux.o 
	   $(CC) $(CFLAGS) -I$(CHECK) -o t_server.exe t_server.o \
		   send_floats.o receive_floats.o \
		   $(APPL)_sstub.o $(APPL)_saux.o $(LIBDCE)

t_server.o:	t_server.c
	   $(CC) $(CFLAGS) -I$(CHECK) -c t_server.c
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             ! * [RPCTRANSFER_DAT.SRC]OUT_PUSH.C;1 +  , I
   .     /  @   4 O       z                   - (    0   1    2   3      K  P   W   O 	    5   6   7 }1"  8          9          G  @  H  J $ N                   ?                      /* FILE NAME: out_push.c ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif   #include "transfer_data.h"N #include "pipe_state.h"    /* definition of a state structure for pipe data */ void exit();  O void out_push(state, buf, ecount)  /* output pipe needs a push procedure <CO>*/ O pipe_state    *state;              /* coordinates pipe procedure calls   <CO>*/ O idl_char      *buf;                /* buffer of data pushed              <CO>*/ O idl_ulong_int ecount;              /* number of elements for buffer      <CO>*/  {   O    /* If pipe is an in/out parameter, a state turn around may be needed  <CO>*/ $    if(state->start_output == true) {K       /* A turn around may mean the file pointer is set to the beginning */ K       /* of the file or the file is closed and reopended for write.      */ K       /* The flag must be reset so this code can only be executed once.  */ "       state->start_output = false;    }  I    /* for this application,                                                                                                                                                                                                                                                    N                         $      DCEAXPMUPA013.A                #  3  0[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS]TRANSFER_7A$QXL1"
g		jXGYLm
1                                                                                        8    I       _/t@|V؜WIK:'r.c-XC|2>E@Uv=K :I)a_`7`Gs^E2=Ee^s|c~in4z}Rj|_<BI-<\T9$AJ7<{2@%,572F_`wga2i>w9<*zAWvvl87VFyk7<w!t7*ef!/M*_B2=(Eu=.ASC4xxQ,=z~)tFM^a#>=<-H*<TDGCh&mIG`墧]Hk-N]Q
kE%=BXV
Ke!#}31 BWd
,)7J::j{+vK2BaO"GF.Pnx=M1w<8lMqC=AD~bL؀cM](?yRWTbOQ"hB:L2
ra|=GP=Lr/=V&E~]k6XS 4J$P$`reH]V4Ajcc0vj.Spd&r\[{z
g4`v@Lqu+69v@mr3$Q
?_Ya|~ MXV9iHQ8l]A"{^fn)i V{cr2]~+FCI,;dIB4t~<<4Ar5A|>O~@Xj'oDIV_n9P"+b.#UV1pa	$G@G,xf`MFm*",z#s{{Y;G3D5tgz[Ebx
'$5w>%JkJRh-Ck)/aM.gWsJS3ZW
XjvV*?y9BnhTAlzh>/dk\T&6%~HJwhjx; NYHRPzFt%7}J4j}-YiYnFQLd	kC$}A$L@gL'!?ah:5x$>y^mf,<|r
7O1ny-D&ZJ5'2YUtx@?l,]w>,>BHX'H%J;	[<'xQrlY[r
LZ043)(B:I8]*|H*f&.Y .75+ XmS~`#o$'o	=f,ku/!}=8'57Jf;Ja B{%DcK65YEHU!S%R:rc-wtJp"8[UAyp-Po
5qYa>vYz(yf:oT88 9RDh GTBn&zRdqtq:D1U(vF/Y_.L8N/MtXiy%m``tU\
ItnY!L%0'-3'\r>U[rMZ3dDg;*TU;No#g>`vLYM)Wv`5_8(k?%|:Z*"KWGXK22pn)#S4$<!l\TrjDr$9xes
Xt#*L"%l7[@Uq!<7Fm6}IDdBGuikOs#nWyS\aP+#=t
$K+z4G.}^Ln/Hj9DOa 8l^	2FaTV-oRmR/T+ 2G$b:pw
 ]S3ufnW'@{|(m0Z}ne[pW9`|I"t8m#[ U9ry-2;9r&I,S,1F.TX݃.(uM$.H]=X_Z"~A^Cr}Zh+Ģ] JU3N3v7@wMcgx{xW: I?bDJ
z
.~[3!dN<<C eG>63sa3+fM)u*R1x(\
;(
HSGO]+'AHZAks3w:i#24f^q3jE,Z!neEf@.MmX:?uQ2V8Z,V.Cm]l*e|7xgQ>jHFeL?&>:Ue5#L=L} 7Al"UpzAQgJ3E0X<3iP9J &!O\sn]n+V!-eE2)qyc)pe358'%l# h1M?4Fwy !d޲")9
,t,w!;]EGl0vP|j5S'PNvW\xd:_%ZUg(tO})#51zDhYoU_vK;%^,fk|*Q{ZShOq
m!LN)
#>nIi$b'B>Zy}vJ|jxmcpJXs+/8l;h|DL '7M5lRy"sMIS;cRgg>
AwN/G5
KoNw&KkI)
C+u{
I[/M&X0)z^"5;GOLn-t^Y\>n~	D'g&f r=Nzd@E~{E;?!}L$L$jjh
L8Df>y-Q(TXXxnX-;v%=~g -NOg7
<hL H4F *Mi~{6C WI^%tww`D!(0@yG	Edu]nSSHr6nUg'RYf/`.(X)PUT	`buJ9O$XD.8eXs}pN}k9.rdU~Pv7B0T=1G_g+lv1F8|8hjj)L&kdfmL6U"EN-1A4GxiIEPHEGi0ENI$3j%IaUzOBWAKT--<]VSbHwVkH >3B?1-}
8]No+	O"X&cN\>4B~%i!2ttbj!aa~
|x\0G: ~"-0niRb19 ]'YK]E	>opa3m<IH<>~"toK	%S#W'
Bn&S17ij]uW!)	]%Um4<Xke&p\|
lߚODk
C$eT"Y}d&waQ@LD=6tz!E	$3BK"Kb"l|J\Q|.BIp+SVsxy<y8wp+`q%*Xl5#8podaqZW#akfBE|;FNPu<w-Kk&0ZM+ /Hз#5oCH[rr1N<2PAFCjFDs:0V
_.h8pFV?D2B`zJD]DHEf:	zm/HpeqIO 4JHL|fY5kX|9|aTKVyw]y%Vz:) %WW5X2?e3@v'Kg^ͨUA:d7Ģ0U>GE;p/T h[7e?|/<^{X@9
[f@a)VUp5:8@3FN%)#=bPqr':~	zzsw+a<f`_
Q=oLgQ|\hP%F4Ex6'gt(#J	'tCv:/zW$
'^4i.U?03	T~_
mii776r>_
"v%2C{Ug8C{&/+;a6'//J"tޗuI@IjF Md0
|1gb1[z	H?US#@c?klq*iR2l-[z|\n(jtUup$jJq`{07|
{9 p͔kTCfzmNi>~Ns"yyj`z2kn(?gהto^_ῂvm=E%+7OXJ Q5[0C;
|j6pEz>x:=V5f;*}dp O~	2_-
(<NT]TV0urUxM'M~!z/F3Eʳy4FgG4N

470Q";9Tk1puP B]34.$6U47I$D
i(?z$,raCX<lcYF$pho5.10MkkH"[ Xj)G"Vrp`dyMPBj
T\B"Yw{?M-}*[@"XrZ.WHXBE4WK.G3!.G<>;7P|VN6j>(9H/s}$HxfSN%+~U^&,6VDa7M1Y[KJ!L@A +zH[}U}1k-*	gUc*{/=9]3^}_QM|EnXTF21WlC;"{<@uU-Jl=.Va9*)chbIf:"Uz%_m{<
Z3uS29=5l]C	}L0M_Gh?/".U뷈9#RxFTkROz2+@xda	aeKAyaA)y1"p!D	m\jTQu<s(;Ys'(MumffWL0bam;<EE3R1WCU7c(k-:oJb_e"d[1 &e"-O7,qKWaI	t3-:hn
5EBdPxoD*EG;q.
;IMHU"g&\x]fxp(Yxuuxa[k!tEj^P}	SW!OPOS$M5俹%<1W\.g!+M>%m&qs6G֒CochPbE`a6P\wn'i'QSGs :3fas_
"b?OrIg$J\|y_Rj-gW6,U?I~_aPdȬͼ.V(e4 N)Ty(9xv ,rG	b9[iX]g^,bDWE}ɏQ>]!m zSk\TXYH:6qr-Y?SMas)Rs	!( ;] tc.aNYK&WwsFOqnq!S$!*_(
<Br:,%KW) PY\Zqt9z7*
	7yPU3)|R?*1r7
Q {@2dGE!Md/,%SDrMu|M	%
Qe "*sD[,hLPoow
`ZYW]6d;Z1e;WJjo}9vi6SM 7X695R;%9<1w8}1]~@5h"6=80N7T#dpA^|4o]:'7kkbzV_r%H'30nqZ,8H\G[iHp7/@%A< Z a(Ev9$rFUhm0_*#pD
'`=v	k &:fv{a.pjDlUqHzZT{EP%'^}Aywk$Lh
cOA
	cVbVUgG0^|".\?hqE@h4+^|DiUR0@b^63q6j!in73K%@XINCKU)^JNiLR| gq5?XUV-{pipԗbH=<n(Gr57ԔuuredPj@<\4QF3T]is-E,FQ{CM\'UEh(&$h/JEX/r^
5BW~pyD_aM);Z,2U҃\E0sr=E_R/} Y5]Kt`!aoD6ls$f]
#NmLf2NM\<M>#g;V]
p&nZqG'l]Sbsfda!Tw&v"	N8|Xf@
h "f6i= 5s#Xa?6Ak"t($R.;!T*gR95 LQhFugwLO/y{==P(UL [K$߻bor9TGv:gI	U\xC[fuI`>s^z#O 37%935&N6ͯ9]q9>260ekfRy>j0>zg{@ 2$gilZB~E7`7hbv>$z-	z/)y{dcMc/A*PgQo6AfnN{7&#;OJ
g's6+_$I&gtB32z18Kf u mdol0q6w(y_j	HSs!T}NI$<g R,J,v1EX'huJtfKcBJT^hvi/rhJYP!#YAWjJr_^>	"OA3AoB#X#
q:2udY{s/fk]rxxAa^"gwLT
+^gfa<Gy8)?^p.S#s1|p7,VbUqh"ACIsIj88&=n#`EP(cl!^3y6ye1
B_~l2!EI1KcZb4l !E"E[\_LUny
	/HGC;#y.U\63rW5%|-`v/0Uu8|e:L(6o8"U62/8E1OioH
sA\{7nb[CM=fIw	 1\<@;S7t`%myA?$#fCu~iZs`'FH.-}l"kyn
\gQ9>SrH)Z1iiof$Lbef?m&xTPonn<w>JFGu{G(*F<mvOCv]'Zx4@A*&"kOO ^I8
ښH@5A)l7/	ms\"h#3dgch%\=ۆ'#{dco=|\?$_5-D[gH~M',~0+k_X|k]v&6r}]&6]y4v]nvkLRQ(kwY=C_46mRQ7F\-17ztaecj;_	<1>on#*ӟ6_J,P(=48;Alkndx}u@
'2BWoSQOJ sa]ugW=g@8ŕ%n@P)mmo&"@*='qp`l.&"&s
z|#|7GZ4d3 7_soB*)1Hw]V~j8T\k
6)?-*~y<).#sSPI:(iN9z`HceaE`j#I`-6=F|b9Jo9:/biI#e.&kZG0t)
I!J!d>=VRC]`H^PDqy{,,
5S)?~*vjqoɕ+YE"
u ,8aZNv[' hxQ7~ g!]VM%
(S@[u55&(\E}&GZX"3akCS|LwEb!@}$E+\G^Ir MBXfs(&p},X6&+qR?nOZv#I7i+l<EuOBbjjL+0EJoD
gtYQ5BJ9ZIzx06b"cZf^cltb#P*c;rH|01	[ D^cU4 n`|gnlh]e
 	_$O*+qL(B>BG@6e'ky3MU4ixO`k>bS7 
do88qL?2FoQ6wQ8:bRey
GB>l@zZYx-Tl@{*QA!e=_2TQxN'#feP44>z
3 >
@mpk~I`2p<,PLC2$%jLNF>OY5y`#omL}'6
0XSfZBPuEl_F#@Sp
F4"m(junD:JU%l&k+E+P98^@9H=f?R0m^;Jk13_TƲ/Ob.(xB_p%~Tw|]KCNjK-7LZzq6(Ihf*th:FYXdQ$'^b_zv	v=FY1PeSbl1N3K7,pU
%	}fZq_rwy;#Z]Sbr@T
d-RMWD
3|d-j;Kl1G42voqre
LjL 
SNjsK
nK;~X-_*T.O[715w4N_APu=:v}?63-:`Y@~7|{!9Q<?00Jeo CVTg;qcOo_OC6o[yIVxJtC9B1NX($ drB3<>0wWD,zUa
~+	p@|K	
D+kt]GJ\w[ H4^f z:qm(=q+'@INTrln)JQ#-A`3c=|H XKbz.zxxJ nB~z4dWG,`)Q~a5t	(VW3YEDcŭZ4Ol|ocHLC'CBSl(\UX
sq5Lj(?`o|XiZ^7Gm:E
GCkW4Gv3lSS`k;o	p[w>bU6vKV~?k`#{^,TW@jz *h/ό^sz:$vV%%tI
Pp <}Oao'ed`bSI^IBA#t
>7DM%7q2>zRbw!.0u_`8OkzJ{*vF!&I8Em%PU5V9'24W3<-{z);bF[6|Y5Pv-W	"'0L>Bxt?8}PK[bG[nUnp~0Y9{WqeY%n"~J-0}l4Y*,?dvU_Xl*f}`b
[t:]-\ %ml
"7sPXVpm<T\E|/d 
#wEn*O*Y8o|*gZYw|:YIE$p}7\3~vD7C}JTs?G@czcKM[+5I
y>G2s_
H={N*G^A`oL![)C+j]2;H!+7Ys729g4FUrtyd1tpky\1$@b$%?yD-ORwV˴j\ #6GShjNCy+R`?F&,o,="CKO9Q|{|*\R;BJ%JGevT2ae1wD!]`~=6$CGgCUsV_y'"H+#)JeCa9q(
FoV$f?[hAU_.\N%kh`ChOXMjXQ5RD4JchNPa8qf92,U,0.<oQ%QLcʝUJxH7}Ee; tDlcqt;V<2dԲ!La*p--,`	]4i
N*k!c3,wSyf!6\7Z*vݨ9'( %T83y:&a*\ϩa9304ibpCobpEz)Q$gRia?}-5Pwjs6-OzzpHd,Ɣ,`Jb"waoۖMEd#-Z}[
@e8kMYyW- a,{4
MWYo|=!DG:a=֒qw9:WT~V!1':-n;)^ ;\y*2Paj]0
	o7&Q7MG'xv=	1zWXNSb4$HR
,BPo@miڂDR)%OZ%N)."UT'cF><X"#X=1#@I
Zq8 0~wqvO@nf,CzQ+]Q-B9XplR%%fB"(<Yv
&d!"iXkh8qsa-s
DYQvLvf1RnMR&
jB4wGi
,o/2Sx?]~XbKqzW6<D*#)Y1u1pbkp@0CJ_>
DqM:c.*%JOz w@WsDuh`|	5(";/	3i3_~c6jJSN2!'O>gTCD<QaOa>yPfE?39cFkFzG)(-fK;g{\#&`L1r-h5i3B;	cZXa\HQxB{WJU;",7~.QKK2K'K4t{A+}bj`BO;[Qx7	u] J<~Cere0  !:UX?QC.yXfUflYTv	
~uX{m
gV a$1J
r7foF,d5h4sgZMkf~Wg{
X9yp>V=6Y<.m`8GZT4b JXKwzr66<P>Q1,?H /rзX|^dޔ̧H==+
<1DKo`+:>O#73CRr5ۏ],Y0V"A"Y$vߜlSHyjaz&i{ce`#AmyNUy=N`e]Dm:D}I#
3SMudB,^Hwx,w='XO X
~`3_  * [RPCREMOTE_FILE.SRC]GET_ARGS.C;1 +  , 1I
   .     /  @   4 J                                  p                                                                                                                                   O                        I $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         ' "     :       open local target file if not open already */      if(state->filehandle == -1) {I       if(ecount <= 0)   /* if first buffer is empty, don't do anything */           return;0       state->filehandle = open(state->filename, F                                   O_CREAT | O_TRUNC | O_WRONLY, 0777);#       if(state->filehandle == -1) { M          fprintf(stderr, "Cannot open file %s for write\n", state->filename);           exit(0);        }     }O    /* To detect the end of data, push routine must test the count for 0. <CO>*/ M    if(ecount == 0)                      /* do application specific cleanup */         close(state->filehandle); M    else                                 /* process buffer for application  */ B       write(state->filehandle, buf, (sizeof(float) * ecount));    
    return; }                                                                                                                                                   # * [RPCTRANSFER_DAT.SRC]PIPE_STATE.H;1 +  , I   .     /  @   4 O                         - (    0   1    2   3      K  P   W   O     5   6 A ]  7 !z]  8          9 #ΚL!b  G  @  H  J $ N                   ?                   /* FILE NAME: pipe_state.h 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
/* Definition of an application specific state structure of client pipe data */
typedef struct pipe_state { 
   char *filename;              /* name of client data file   */
   int  filehandle;             /* handle of client data file */
   int  start_output;           /* a flag needed only if parameter is in/out */
} pipe_state;
                                                                            ! * [RPCTRANSFER_DAT.SRC]README.LIS;1 +  , I	   .     /  @   4 N       b                   - (    0   1    2   3      K  P   W   O     5   6 (  7 )  8          9          G  @  H  J $ N                   ?                     
taken from Appendix F of Guide to Writing DCE Applications, by John Shirley

 



                      COPYRIGHT (C) 1993 BY
                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
                  MASSACHUSETTS.  ALL RIGHTS RESERVED.

THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Qw ~      TRANSFER_DATA.SAV              I	  (  ![RPCTRANSFER_DAT.SRC]README.LIS;1                                                                                              N                             C             THER
PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.

THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.

DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.

02-Sep-1993 fwb Text for OpenVMS POSIX added




                                                                        F
        _________________________________________________________________

                                            The Transfer_data Application


              There are two clients for the transfer_data application.
              One sends a binary file of floating point data from a
              client to a server and the other receives a binary file
              of floating point data from a server. The transfer_data
              application demonstrates the following advanced features of
              IDL and RPC application development including:

              o  Using input and output pipes.

              o  Using the explicit binding method.

              o  Using a customized binding handle and the associated
                 bind and unbind procedures.


    How to Build the Application

	For OpenVMS/POSIX environments, enter the following commands:
		psx> cd /dev/mydir/transfer_data
		psx> copy /usr/dce/examples/gde_dce_apps/transfer_data/* .
		psx> make 

 	For OpenVMS environments, enter the following commands:

		C$ copy sys$common:[syshlp.examples.dce.gde_dce_apps.transfer_data]*.* []
		C$ @transfer_data

	            Running TRANSFER_DATA.COM creates all the executables 
	            for the transfer_data application.

   How to Run the Application

      To create a binary file of float data for the application:

	For OpenVMS/POSIX environments:

		psx> float_util write datafile_name
 
        For OpenVMS environments, define a foreign command with the full 
	directory specification:

		C$ float_util :== $mydisk:[trans-directory]float_util.exe

	  Then, to run the utility program, enter the following command

		C$ float_util write datafile_name


      To run the LOCAL / NONDISTRIBUTED tests of the application, use the 
      binary file of float data as a source file and a new data file
      as the target file. The host is not relevant for the local
      test. 

	For OpenVMS/POSIX environments, enter the following commands:

		psx> local_client_send source  host  target
		psx> local_client_receive target  host  source

	For OpenVMS environments define the following commands:

		C$ local_client_send :== -
		_C$ $mydisk:[trans-directory]local_client_send.exe

		C$ local_client_receive :== -
		_C$ $mydisk:[trans-directory]local_client_receive.exe

      Then, to run the LOCAL NONDISTRIBUTED tests of the application,
      enter the following commands:

		C$ local_client_send source  host  target
		C$ local_client_receive target  host  source

      To run the server for the clients of the DISTRIBUTED application:

	For OpenVMS/POSIX environments, enter the following command:

		psx> t_server

	For OpenVMS environments, enter the following commands:

		S$ t_server :== $mydisk:[trans-directory]t_server.exe

              Then, to run the server, enter the following command:
	
		S$ t_server

	      
      To run the client of the distributed application the network
      address of a remote server is needed for "host" (ex. 16.33.3.92)  
      If the server is running on your local node "host" can be the node name.

	For OpenVMS/POSIX environments, enter the following commands:

		psx> client_send  source  host  target
		psx> client_receive target  host  source

	For OpenVMS environments, enter the following commands:

		C$ client_send :== $mydisk:[trans-directory]client_send.exe
		C$ client_receive :== $mydisk:[trans-directory]client_receive.exe

              Then, to run the client, enter the following commands:

		C$ client_send source  host  target
		C$ client_receive target  host  source


              Application Files

              Makefile:  The Makefile contains descriptions of how the
              application is compiled in the OpenVMS POSIX Environment.
	      Previous builds can be cleaned up by entering:

psx> make clean

              Makefile.osf1:  The Makefile for OSF/1 systems.

              transfer_data.com:  The command procedure file for OpenVMS 
	      systems.

              float_util.c:  This contains code that generates and writes
              a binary file of float data or reads a binary file of float
              data.

              transfer_data.idl:  The interface definition contains the
              description of the constants, data types, and procedures
              for the interface.

              client_send.c:  This client demonstrates use of a pipe that
              is an input parameter. The customized binding handle is
              initialized, the pipe structure is initialized for an input
              pipe, and the remote procedure send_floats is called to
              transfer pipe data to the server.

              client_receive.c:  This client demonstrates use of a pipe
              that is an output parameter. The customized binding handle
              is initialized, the pipe structure is initialized for an
                                                                                                                                                                                                                                                    P                         $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                          "     K                    output pipe, and the remote procedure receive_floats is
              called to transfer pipe data from the server to the client.

              binding.c:  This contains the bind and unbind procedures
              the client stub calls to obtain and free a binding handle.
              After the customized binding information is initialized in
              the client application, the binding is handled entirely by
              the client stub with these routines.

              send_floats.c:  This contains the implementation of the
              send_floats remote procedure.

              receive_floats.c:  This contains the implementation of the
              receive_floats remote procedure.

              t_server.c:  The server is initialized with a series of
              runtime calls prior to servicing remote procedure calls.
              In this application, all protocol sequences available are
              registered. The server is not advertised in a name service
              database. The server's dynamic endpoints are added to the
              server's local endpoint map. A client finds this server
              by constructing a string binding containing a protocol
              sequence and the host name or network address.

              pipe_state.h:  For this application, the pipe state
              is a structure containing a client file name, its file
              handle, and a state turn around flag.

              client_alloc.c:  This contains the client_alloc
              procedure which the client stub calls to allocate a buffer
              for pipe data.

              in_pull.c:  This contains the in_pull procedure which
              the client stub calls to process input pipe data.

              out_push.c:  This contains the out_push procedure
              which the client stub calls to process output pipe data.




                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [RPCTRANSFER_DAT.SRC]RECEIVE_FLOATS.C;1 +  , I   .     /  @   4 P                           - (    0   1    2   3      K  P   W   O 	    5   6 Kq  7  wv1"  8          9          G  @  H  J $ N                   ?                /* FILE NAME: receive_floats.c   ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS)   #include <unixio.h>  #endif   #include "transfer_data.h" #define MAX_ELEMENTS  1000  N void receive_floats(c_b_h, out_data)   /* copy server file data to a client */9 file_spec c_b_h;          /* customized binding handle */  pipe_type *out_data; {     int             file_h;K    idl_short_float buf[MAX_ELEMENTS];       /* pipe data buffer          */ K    idl_ulong_int   element_count;           /* number of elements pushed */     int             nbytes;     +    /* open local file on server for read */ :    file_h = open((char *)c_b_h.filename, O_RDONLY, NULL); 3    nbytes = sizeof(idl_short_float) * MAX_ELEMENTS;       if(file_h > 0) {        while(true)  {P          /*****        application specific process of buffer        *****<CO>*/M          element_count = read(file_h, buf, nbytes) / sizeof(idl_short_float); &          if(element_count == 0) break;  P          out_data->push(     /* push routine is used for an output pipe   <CO>*/N             out_data->state, /* the state is controlled by the stub         */N             buf,             /* the buffer of data to send                  */N             element_count    /* the number of data elements to send         */          );        }        close(file_h);    }  P    out_data->push(out_data->state, buf, 0);    /* 0 indicates end of pipe <CO>*/
    return; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             $ * [RPCTRANSFER_DAT.SRC]SEND_FLOATS.C;1 +  , I   .     /  @   4 P                           - (    0   1    2   3      K  P   W   O 	    5   6  b  7  u1"  8          9          G  @  H  J $ N                   ?                   /* FILE NAME: send_floats.c  ** **  Copyright (c) 1993 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** */ #include <stdio.h> #include <sys/file.h>  #if defined(VMS) #include <unixio.h>  #endif #include "transfer_data.h" #define MAX_ELEMENTS  1000  G void send_floats(c_b_h, in_data) /* copy input data to a server file */ G file_spec  c_b_h;                /* customized binding handle        */  pipe_type in_data; {     int             file_h;L    idl_short_float buf[MAX_ELEMENTS];        /* pipe data buffer          */L    idl_ulong_int   element_count;            /* number of elements pulled */  ,    /* open local file on server for write */M    file_h = open((char *)c_b_h.filename, O_CREAT | O_TRUNC | O_WRONLY, 0777); N    if(file_h < 0)      /* If can't open file, need to discard the pipe data */1       file_h = open("/dev/null", O_WRONLY, NULL);   P    while(true) {             /* entire pipe must be processed             <CO>*/P       (in_data.pull)(        /* pull routine is used for an input pipe    <CO>*/N          in_data.state,      /* state is controlled by the stub             */N          buf,                /* the buffer to be filled                     */N          MAX_ELEMENTS,       /* maximum number of data elements in buffer   */N          &element_count      /* actual number of elements in the buffer     */       );P       if(element_count == 0) break;      /* 0 count signals pipe is empty <CO>*/P       /****          application specific process of buffer        ****   <CO>*/D       write(file_h, buf, (sizeof(idl_short_float) * element_count));    }      close(file_h); 
    return; }                                                                                                                                                                                                                                                                                                                                                                                                           ( * [RPCTRANSFER_DAT.SRC]TRANSFER_DATA.COM;1 +  , I   .     /  @   4 b                           - (    0   1    2   3      K  P   W   O 	    5   6 nw  7 dKSnw  8          9          G  @  H  J $ N                   ?               $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! Abstract:A $! 	TRANSFER_DATA.COM -- Builds the transfer_data example program  $! $! Modification History:0 $! 02-Sep-1993 fwb Modified for OpenVMS/DCE V1.1 $! $@DCE:DCE$CC_TEST  $!cc := cc'f$trnlnm("dce$cc")' $! Determine option files $ $ IF( f$trnlnm("dce$cc") .eqs " " ) I $ THEN	options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options" & $ ELSE	options = "dce:dce.opt/options" $ ENDIF  $!- $! Enable the universal IDL command interface  $idl := mcr dce$idl                                                                                                                                                                                                                                                    Q                        B~` $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         g "     \        $ " $! Compile the interface defintion $idl -v transfer_data.idl  $ = $! Make ULTRIX-style reference for #include <sys/file.h> work  $ define sys sys$library $! $ cc/g_float t_server  $! $ cc := cc'f$trnlnm("dce$cc")' $!' $! Build the float_util utility program  $cc/g_float float_util $link float_util,'options' $ ) $! Build the local version of the example R $cc/g_float/define=LOCAL/include=([]) client_send,send_floats,client_alloc,in_pullR $link/exe=local_client_send client_send,send_floats,client_alloc,in_pull,'options'L $delete client_send.obj;*,send_floats.obj;*,client_alloc.obj;*,in_pull.obj;* $ Y $cc/g_float/define=LOCAL/include=([]) client_receive,receive_floats,client_alloc,out_push \ $link/exe=local_client_receive client_receive,receive_floats,client_alloc,out_push,'options'S $delete client_receive.obj;*,receive_floats.obj;*,client_alloc.obj;*,out_push.obj;*  $ % $! Build files common to both clients ? $cc/g_float/include=([]) binding,client_alloc,do_string_binding  $ - $! Build the transfer_data client client_send , $cc/g_float/include=([]) client_send,in_pull^ $link client_send,transfer_data_cstub,client_alloc,in_pull,binding,do_string_binding,'options' $ 0 $! Build the transfer_data client client_receive0 $cc/g_float/include=([]) client_receive,out_pushb $link client_receive,transfer_data_cstub,client_alloc,out_push,binding,do_string_binding,'options' $ ! $! Build the transfer_data server & $cc/g_float send_floats,receive_floatsG $link t_server,send_floats,receive_floats,transfer_data_sstub,'options'  $  $! Example command defintions B $ float_util == "$ " + f$environment("DEFAULT") + "float_util.exe"P $ local_client_send == "$ " + f$environment("DEFAULT") + "local_client_send.exe"D $ client_send == "$ " + f$environment("DEFAULT") + "client_send.exe"J $ client_receive == "$ " + f$environment("DEFAULT") + "client_receive.exe"                                                                                                                                                                                                                                                                                                                                                                                            ( * [RPCTRANSFER_DAT.SRC]TRANSFER_DATA.IDL;1 +  , [J   .     /  @   4 K                         - (    0   1    2   3      K  P   W   O     5   6 aD]  7 !!D]  8          9 #ΚL!b  G  @  H  J $ N                   ?              /* FILE NAME: transfer_data.idl 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
[
uuid(A6876974-F555-11CA-BAE1-08002B245A28),
version(1.0) 
]
interface transfer_data   /* data transfer to and from a remote system */
{
   const long NAME_LENGTH = 200;

   typedef [handle] struct {          /* a customized handle type */
      char host[NAME_LENGTH+1];
      char filename[NAME_LENGTH+1];
   } file_spec; 

   typedef pipe float pipe_type;      /* a pipe data type            <CO>*/

void send_floats(       /* send pipe of floats to a file on the server */
   [in] file_spec  cust_binding_h,    /* customized binding for server */
   [in] pipe_type data                /* input pipe of float data    <CO>*/
);

void receive_floats(   /* get pipe of floats from a file on the server */
   [in] file_spec  cust_binding_h,    /* customized binding for server */
   [out] pipe_type *data              /* output pipe of float data   <CO>*/
);
}
                                                       ! * [RPCTRANSFER_DAT.SRC]T_SERVER.C;1 +  , ]J   .     /  @   4 P                          - (    0   1    2   3      K  P   W   O 	    5   6  \]  7 n1"  8          9          G  @  H  J $ N                   ?                     /* FILE NAME: t_server.c 
**
**  Copyright (c) 1993 by
**      Digital Equipment Corporation, Maynard, Mass.
**
*/
#include <stdio.h>
#include "transfer_data.h"             /* header created by the idl compiler */
#include "check_status.h"              /* contains the CHECK_STATUS macro    */
main ()
{
   unsigned32             status;          /* error status (nbase.h)         */
   rpc_binding_vector_t   *binding_vector; /* binding handle list (rpcbase.h)*/

   rpc_server_register_if(       /* register interface with the RPC runtime */
      transfer_data_v1_0_s_ifspec, /* handle to interface specification     */
      NULL,                     
      NULL,                     
      &status                   /* error status */
   );
   CHECK_STATUS(status, "Can't register interface\n", ABORT);

   rpc_server_use_all_protseqs(            /* establish protocol sequences  */
      rpc_c_protseq_max_reqs_default,      /* queue length for remote calls */
      &status
   );
   CHECK_STATUS(status, "Can't establish protocol sequences\n", ABORT);

   rpc_server_inq_bindings(     /* get set of this server's binding handles */
      &binding_vector,
      &status
   ); 
   CHECK_STATUS(status, "Can't get binding handles\n", ABORT);

   rpc_ep_register(                /* add endpoint to local endpoint map    */
      transfer_data_v1_0_s_ifspec, /* handle to interface specification     */
      binding_vector,              /* vector of server binding handles      */
      NULL,                        /* no object UUIDs to register           */
      (unsigned_char_t *)"transfer_data server", /* annotation (not required) */
      &status 
   );
   CHECK_STATUS(status, "Can't add endpoints to local endpoint map:", ABORT);

   puts("Listening for remote procedure calls...");
   TRY
      rpc_server_listen(                   /* listen for remote calls       */
         rpc_c_listen_max_calls_default,   /* number of threads             */
         &status
      );
      CHECK_STATUS(status, "rpc listen failed:", RESUME);
   FINALLY
      puts("Removing endpoints from local endpoint map.");
      rpc_ep_unregister(     /* remove endpoints from local endpoint map    */
         transfer_data_v1_0_s_ifspec, /* handle to interface specification  */
         binding_vector,             /* vector of server binding handles    */
         NULL,                       /* no object UUIDs to unregister       */
         &status 
      );
      CHECK_STATUS(status, "Can't remove endpoints from endpoint map:", RESUME);

      rpc_binding_vector_free(               /* free set of binding handles */
         &binding_vector,
         &status
      ); 
      CHECK_STATUS(status, "Can't free binding handles and vector\n", ABORT);
   ENDTRY
}
                                                                                                                                                                                                                                                                                                                      *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 R                        |M $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                          "     m                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          S                        ~# $      DCEAXPMUPA013.A                )(  )  C[SYSHLP.EXAMPLES.DCE.GDE_DCE_APPS.TRANSFER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~                         '      ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * [SYSHLP.EXAMPLES.DCE]POSIX.DIR;1 +  , .
=   .     /  @   4                            - 7    0   1    2   3     K  P   W   O     5   6 h   7 (Һ   8          9          G  @  H   J  I                           	POSIX.SAV  n>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       & * [SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1 +  , n>   .     /  @   4   ~           ~               - .
=    0   1    2   3      K  P   W   O     5   6 V>  7 h   8          9          G  @  H   J                                                     Fb ~      	POSIX.SAV                                                                                                                                                                                                                  	  POSIX.SAV4  BACKUP SRC$:*.* OBJ$:POSIX.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @    ?>      V5.5	 	 _OPENUP:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                     * [POSIX.SRC]ACL_EDIT.;1 +  , W-   .     /  @   4        	                     - %    0   1    2   3      K  P   W   O     5   6 K<s=  7 R'>  8          9          G  @  H  J $ N                   ?                           h                                                  (   ,=              0       @  `                                                              Z),= _0_362001B4_ACL_EDIT_PSX_AXP           V1.0           A10-62               $             
               $                             $             J                $    (                       8    0                     DCE$LIB_SHR_001      8    &                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8                         POSIXC$SHR_001       @                       ^6SYS$PUBLIC_VECTORS_001             0           0              
                                                          00            P                                                                                                                                                                                                                                                                                                                                                                                                             #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 b4sZk   "4GP BX bbnZk 4G@ BH byZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                                T                           T   |                                0         @   P                           
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       
POSIXC$SHR                                             @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                     *        VMS_ACL_EDITDEC C T1.3-019A     TRANSFER$BREAK$GO       main      	                       `  __main  8                                                                                                                                                                                                                                                                                                                                                          8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [POSIX.SRC]CDSCP.;1 +  , -   .     /  @   4                             - %    0   1    2   3      K  P   W   O     5   6 8X e  7 H>  8          9          G  @  H  J $ N                   ?                              h                                                  (   ]              0       @  @                                                              ] _0_34A005CE_CDSCP_PSX_AXP              V1.0           A10-62               $             
               $                             $             J                $    (                       <                         DCE$UTIL_SHR_001         8                         POSIXC$SHR_001       @                       ^6SYS$PUBLIC_VECTORS_001             0           0                                            00            P                                                                                                                                                                                                                                                                                                                                                                                                                                             #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 b0@Zk  C4G  B( byZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                                                                                                                                                               T                        <f= $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         A "                                                                                    T                           T   x                                0             `                        
                                 @       DCE$UTIL_SHR                                           @       
POSIXC$SHR                                             @       SYS$PUBLIC_VECTORS                                                                                                                                                                                         +        
VMS_MGMT_MAINDEC C T1.3-019A     TRANSFER$BREAK$GO       main    
  9               p        @  __main  8                                                                                                                                                                                                                                                                                                                                                           p      $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [POSIX.SRC]DCE_DEFS.SH;1 +  , g,   .     /  @   4                          - %    0   1    2   3      K  P   W   O     5   6 `'oRg  7 LSg  8          9          G  @  H  J $ N                   ?              #!/bin/sh
# This script is called from /etc/profile to set up DCE specific environment for
# the user.
#
#
# Add path /usr/dce/bin to the users path name
#
if [ -L /usr/dce/bin ]
then
	export PATH=$PATH:/usr/dce/bin
	echo /usr/dce/bin added to PATH
else
	echo /usr/dce/bin does not exist! PATH not updated!
fi
#
# Provide aliases for DCL calls to VMS images
#
alias -x rpccp="dcl mcr sys\\\$system:dce\\\$rpccp.exe"
#
#
#
                                                                                                        * [POSIX.SRC]DCE_LOGIN.;1 +  , /   .      /  @   4                              - %    0   1    2   3      K  P   W   O !    5 	  6 	oUoe  7  s>  8          9          G  @  H  J $ N                   ?   &                       h                                                  (   D              0       @                                                       D         ID _0_34A007B6_DCE_LOGIN_PSX_AXP          V1.0           A10-62               $             
               $             
               $                	             $                             $             J                $    (                       8    0                     DCE$LIB_SHR_001      8    &                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8                         POSIXC$SHR_001       4                         
LIBRTL_001       4    "                     
LIBOTS_001       @                       ^6SYS$PUBLIC_VECTORS_001             0@          `              $               
              LNM$PROCESS     P              `                           !              0x                                     @                        KRB5CCNAME                                 X               p          SHELL         0     -e                                                                                      - %s
         "                            0    (     0                                                         
       @                                                                           P               "              -exec   -c            /bin/sh                 `              X          x          (     %s
     00            P                             KRB5CCNAME      Error: Cannot acquire logical name "%d"
        Error: cannot define %s logical name
   def_log %s '%s'         Unable to establish User Principal's Credentials
       An OpenVMS POSIX child C shell is now being created
    Unable to execute %s
   dce_login_noexec        Sorry.
User Identification Failure.     Sorry.
Password Validation Failure.     Unable to set context: %s
      Validated from local override entry, no network credentials obtained.
  Credentials obtained from local registry.
      Password must be changed!
      Validation error: %s
   Enter Password:         Enter Principal Name:   Command must be specified after -exec
  Usage: %s [username] [password] [-c] [-exec | -e <cmd_string> ]
        Illegal argument %s
                                                                                                                                                                                                                                                                                                                                                                                                                                                    P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~@^H^P~XGG8 $     @  $  ?$ !  =  G =!v?H`Q H D = 4G ]2^J`q H@F ]8 4G  B( bpZk 0J` H F 8 = =@ }" }0 " 8 }8 4G  B( bpZk H `@ ,    H D   05 B ]2_Jp JPF ]  =" ]" "GGG0 B8 bRCZk,  C8 D  0 0JJC@ Q.R QJ@ Q>0 }3fJfJ4`B C4GP BX bYZk(  C  ( @ ="TG B bqZk ` 8 =TGp Bx bnZk GG@]H]P}X`#kp#  ~x^^GG  = "@ " ] }G0 B8 b9nZk "4G  B( buZk   G H  =TGBbmZk Gx]]#k#  ~^^~ GG\ X =P L H  4G8 8 =\ 	 B  X 8 = NB   ""TGBbVpZk  4GH =] X =8 ]@N2B   ""TGBbHpZkV  X =8  N0@  p""TGBb=pZkK  P =  X 8 = NB  P > L }$ ` "X 8 NB  4 _"tG B bmZk =?D =X 8 = NB  pX ]8 }`NSB  4G@BHboZkGGG`BRAZk4GL = h"X 8  OB  WtG0 B8 bTmZkp "X }  CtG0 B8 bLmZk4G4G  B( bxZk8 }0`@8 }8 =0 @\ 0D  "TG0 B8 b8mZkp "X }  CtG0 B8 b0mZk4G4G  B( bxZkX }8   L `@    P D   4GBb2mZk"4GBbsZk"BR" ?"tG B b{ZkP  C  4G4G  B( blxZkP 4G@BHboZk4 P =4 0@!.!  !JX!D  P ]4 }SB."U J  >4 ݢ0B4GpBxbXZkP  C  TG4G  B( bIxZkP ="TGBboZkP ( ]" }"GGBb~mZk  L } ` ? 4 =( ]"4 }"GG B bPZk0  C  tG4G  B( b&xZk4G } =  =  H } `(  ="D ]"< }" "G                                                                                                                                                                                                                                                   U                        00 $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                          "             BboZk@ 
 (  ="D ]"< }" "G B bnZk@ @ =E   
   ` =", ]"tG@ BH baZk ` ="TGBblZkD } `0"TG0 B8 blZk< }8`D `0"TG0 B8 blZk< }X`D `"TG0 B8 bzlZkZ (  ="TG B(bOsZk }R ` ` =", ]"tG@ BH bjaZk8` ="TGBbxlZkG4G  B( bwZk? P4GBbmlZk } ` ` =", ]"tG@ BH bPaZk"` ="TGBb^lZk P "4GBbXlZkG4G  B( bwZk H4GBbMlZk } ` ` =", ]"tG@ BH b0aZk"` ="TGBb>lZk P "4GBb8lZkG4G  B( bwZkX }  "TGBbnZk  8b  "4G` Bh bFZkGGTGBblZkG4G  B( bjwZk\  } `     =TGBbpZkX  }  #TGBb	lZkK b   b#_b  "  !    "  1b#_  TG4G  B( bCwZkb  4G Bb\ZkP "4GBbkZk4GBbkZk
 @4GBbkZkTG4G  B( b(wZkX"4G` Bh bFZkT  C   "T X ]T }  rX  T X =TGBbpZkX T =TGBbkZk4G4G  B( bwZk 4GG]]} 0#k                                                                        T               T       l        ,  
                                            @                      `  p                   p                       @  `    @        P        	   0                        
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       
POSIXC$SHR                                             @       LIBRTL                                                 @       LIBOTS                                                 @       SYS$PUBLIC_VECTORS                                                                                                         '        	DCE_LOGINDEC C T1.3-019A   TRANSFER$BREAK$GO       
getenv_log    &  	- 
           p           
setenv_log     	-                   (  main  (   	- 		. 	. 	. 	. 	. 	.   (	S. 	i. 	m. 
	y. 	\. )	. 	. 	. +  	.    P                    __main  8                                                                                                                                                                                                                                                                                                                                                                                                               P       P  P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        * [POSIX.SRC]KDESTROY.;1 +  , %G	   .     /  @   4        	                     - %    0   1    2   3      K  P   W   O     5   6 ife  7 `>  8          9          G  @  H  J $ N                   ?                           h                                                  (                 0       @  `                                                              n _0_34A004C8_KDESTROY_PSX_AXP           V1.0           A10-62               $             
               $                             $             J                $    (                       8    0                     DCE$LIB_SHR_001      8    &                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8                         POSIXC$SHR_001       @                       ^6SYS$PUBLIC_VECTORS_001             0           0              
                                                         00            P                                                                                                                                                                                                                                                                                                                                                                                                             #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 bfZk   "4GP BX bbnZk @4G@ BH byZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                            T                           T   |                                0         @   P                           
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       
POSIXC$SHR                                             @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                     *        VMS_KDESTROYDEC C T1.3-019A     TRANSFER$BREAK$GO       main      	                        `  __main  8                                                                                                                                                                                                                                                                                                                                                            <                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [POSIX.SRC]KINIT.;1 +  , )G   .     /  @   4        	                     - %    0   1    2   3      K  P   W   O     5   6 6;[e  7  >  8          9          G  @  H  J $ N                   ?                              h                                                  (                 0       @  `                                                              4靏 _0_34A006B7_KINIT_PSX_AXP              V1.0           A10-62                                                                                                                                                                                                                                                            V                        'U $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         x "     1             $             
               $                             $             J                $    (                       8    0                     DCE$LIB_SHR_001      8    &                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8                         POSIXC$SHR_001       @                       ^6SYS$PUBLIC_VECTORS_001             0           0              
                                                         00            P                                                                                                                                                                                                                                                                                                                                                                                                             #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 b'iZk   "4GP BX bbnZk @4G@ BH byZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                            T                           T   |                                0         @   P                           
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       
POSIXC$SHR                                             @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                     '        	VMS_KINITDEC C T1.3-019A     TRANSFER$BREAK$GO       main      	                        `  __main  8                                                                                                                                                                                                                                                                                                                                                               <                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [POSIX.SRC]KLIST.;1 +  , *G   .     /  @   4        	                     - %    0   1    2   3      K  P   W   O     5   6 e  7  c>  8          9          G  @  H  J $ N                   ?                              h                                                  (                 0       @  `                                                              i _0_34A00647_KLIST_PSX_AXP              V1.0           A10-62               $             
               $                             $             J                $    (                       8    0                     DCE$LIB_SHR_001      8    &                     DTSS$SHR_001         @                          CMA$OPEN_LIB_SHR_001         8                          CMA$LIB_SHR_001      <    $                     CMA$OPEN_RTL_001         4                         
CMA$RTL_001      8                         POSIXC$SHR_001       @                       ^6SYS$PUBLIC_VECTORS_001             0           0              
                                                         00            P                                                                                                                                                                                                                                                                                                                                                                                                             #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( bFZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 bxkZk   "4GP BX bbnZk @4G@ BH byZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                            T                           T   |                                0         @   P                           
                                 @       DCE$LIB_SHR                                            @       DTSS$SHR                                               @       CMA$OPEN_LIB_SHR                                       @       CMA$LIB_SHR                                            @       CMA$OPEN_RTL                                           @       CMA$RTL                                                @       
POSIXC$SHR                                             @       SYS$PUBLIC_VECTORS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               } ~      	POSIX.SAV                      *G  %  [POSIX.SRC]KLIST.;1                                                                                                                                                       '        	VMS_KLISTDEC C T1.3-019A     TRANSFER$BREAK$GO       main      	                        `  __main  8                                                                                                                                                                                                                                                                                                                                                               <                                                                                                                                                                                                                                                                                                                                                                                                                                                                         W                        %` $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         u "     B                                                                                                                                                                                                                                                                                                     * [POSIX.SRC]NSEDIT.;1 +  , .G   .     /  @   4                             - %    0   1    2   3      K  P   W   O     5   6 6  7  $>  8          9          G  @  H  J $ N                   ?                         |    h                                                  (   =              0       @                                                                          Դ _0_244013A7_NSEDIT                     DCE T1.2-940319A10-62               $             
               $                             $             J                $    (                       <    8                     DCE$NSEDIT_SHR_001       8                         DCE$LIB_SHR_001      8                         POSIXC$SHR_001             0          0                                            00     0     P                                                                                                                                                                                                                                                                                                                                                                                                                                             Copyright (c) Digital Equipment Corporation. 1990, 1994. All rights reserved.  Copyright is claimed in the computer program and user interface thereof. NOTICE:  This computer program contains Confidential and Trade Secret information, and use hereof is permitted only pursuant to a valid license.        #  ~0 ^8 ^@ G#G( $ =  ] }  ( $ =  ] }       =  >   4G  B( b:FZk  =b# @G4GBbyZkG0 ]8 ]@ P #k#  ~ ^  ^( GG  =  =TG0 B8 bZk  C4G  B( bfyZk 4GG ]  ]( 0 #k                                                                                                                                                                                                                                                                                                                                                                                                                                                                    T                           T   x                                0             `                        
                                 @       DCE$NSEDIT_SHR                                         @       DCE$LIB_SHR                                            @       
POSIXC$SHR                                                                                                                                                                                                 k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 X                        Z6 $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                          "     S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Y                        { $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                         Il "     d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Z                        5 $      DCEAXPMUPA013.A                n>  .
=  &[SYSHLP.EXAMPLES.DCE.POSIX]POSIX.SAV;1                                                                                           ~   ~                               u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     * [SYSHLP.EXAMPLES.DCE]RPC.DIR;1 +  , 5   .     /  @   4                            - 7    0   1    2   3     K  P   W   O     5   6 w
   7 غ   8          9          G  @  H   J  I                             BOOK.DIR ?     MATRIX1.DIR  8     MATRIX2.DIR  ;     PAYROLL.DIR  /5     
PHONEBOOK.DIR  14     	TEST1.DIR  8     	TEST2.DIR  8                                                                                                                                                                                                                                                                                                                                                              # * [SYSHLP.EXAMPLES.DCE.RPC]BOOK.DIR;1 +  , ?   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6 H#5   7 Q   8          9          G  @  H   J  I                        BOOK.SAV ;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ( * [SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2 +  , ;   . <   /  @   4   ~  <  <     ~               - ?    0   1    2   3      K  P   W   O =   5   6   7    8          9          G  @  H   J                                                   > ~      BOOK.SAV                                                                                                                                                                                                     S                BOOK.SAV3  BACKUP SRC$:*.* OBJ$:BOOK.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @   R      V5.5	 	 _OPNSME:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                       * [RPCBOOK.SRC]BOOK.ACF;1 +  , ,   .     /  @   4 L                         - 1    0   1    2   3      K  P   W   O     5   6 L9c  7 {THM9c  8          9          G  @  H  J $ N                   ?               /* 
**			COPYRIGHT (C) 1993 BY
**                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
**                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
** SOFTWARE ON EQUIPME                                                                                                                                                                                                                                                                                                                                                                                                                  [                        ] $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        $ "            NT THAT IS NOT SUPPLIED BY DIGITAL.
**
**
**  NAME
**
**      book.acf
**
**  FACILITY:
**
**      RPC example program - BOOK calendar.
**
**  ABSTRACT:
**
**  Attribute Configuration File for the remote interface to the
**  BOOK server.
**
*/

interface book
{

/*
 * simply declare a comm_status argument for each routine
 * in the server interface
 */
 
book_fill_week
(
    [comm_status]       rpc_comm_status
);

book_get_booking
(
    [comm_status]       rpc_comm_status
);

book_put_booking
(
    [comm_status]       rpc_comm_status
);

book_remove_booking
(
    [comm_status]       rpc_comm_status
);

book_update_file
(
    [comm_status]       rpc_comm_status
);

}
                                                                                                           * [RPCBOOK.SRC]BOOK.C;1 +  ,  ,   . d    /  @   4 n   d   b                    - 1    0   1    2   3      K  P   W   O e    5   6  xA  7 @W:$  8          9          G  @  H  J $ N                   ?     r             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book.c **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **A **  This is the client program that presents the interactive user ! **  interface to the BOOK server.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **< **  28-jun-93 sinkewicz added changes for ansi-c compliance ; **  11-may-92 hsiao     pass an argument to exit() function 8 **  02-Mar-92 harrow    modify to use idl-supplied types? **  11-feb-92 sudama    change to use cuserid() for portability < **  20-nov-91 sudama    convert to use book_status argument;0 **                      fix bug in show_calendar< **  03-oct-91 sudama    add interface spec to import_begin()J **  21-aug-91 sudama    add server binding import; add comments and formatE **                      add rpc comm status check to all remote calls ) **  16-apr-91 sudama    original creation  ** **  %a%private_end   ** */ #include <stdio.h> #include <stdlib.h>  #include <time.h>  #include <dce/dce_error.h> #include "book.h"  #if defined(VMS) #include <unixio.h>  #endif  & #define book_c_date_string_max      26% #define book_c_time_string_max      6   
 int strcmp(); 
 int strlen();  char *strcpy();   static int unpack_date_string();  static int unpack_system_date();   static this_week();  static main_loop();  static get_string(); int toupper(); static int show_agenda();  static int create_booking(); static int show_calendar();  static int delete_booking(); static int show_booking(); static int go_to_week(); static help(); static write_date(); static int modify_booking(); static int repeat_booking(); static int get_day();  static int get_time(); static int write_booking();  static write_time();   /*   * for terminal escape sequences  */ & #define ESC                         27  " #define REPORT_DCE_ERROR(status) \ { \ =     dce_error_inq_text (status, error_text, &error_status); \  \      if (error_status != -1) \      { \ =         printf (">>> rpc runtime error: %s\n", error_text); \      } \ 
     else \     { \ H         printf (">>> rpc runtime error: no error text translation\n"); \     } \  }   8 idl_char                book_name[book_c_book_name_max];. rpc_binding_handle_t    binding_handle = NULL;    book_booking_record_t   booking;  = idl_short_int week[book_c_days_in_week][book_c_times_in_day];  idl_short_int week_date; idl_short_int day; idl_short_int time_of_day;  1 idl_char      error_text[dce_c_error_string_len];  int           error_status;     char          *month_name[12] = ;                 { "JAN", "FEB", "MAR", "APR", "MAY", "JUN", =                   "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };   L /*************************************************************************** **? **  The client intialization routine to be executed on startup.  **L ***************************************************************************/   main (argc, argv)    int         argc;  char        *argv[];   { #     rpc_ns_handle_t import_context; %     unsigned_char_p_t string_binding;      unsigned32      status; ,     idl_ulong_int   book_status = book_s_ok;$     error_status_t  rpc_comm_status;            /*@      * if a user was specified in the command argument, use it -6      * otherwise, use the name for the current account      */      if (argc > 1)      { $         strcpy (book_name, argv[1]);     }      else     { +         strcpy (book_name, cuserid (NULL));      }        /*/      * set the current week to the current date       */      this_week();       /*B      * set up a search context in order to import a binding handle3      * for a book server from the directory service       */ !     rpc_ns_binding_import_begin (           rpc_c_ns_syntax_default,-         (unsigned_char_t *) ".:/book_server",          book_v1_0_c_ifspec, 
         NULL,          &import_context,         &status);               if (status != rpc_s_ok)      { "         REPORT_DCE_ERROR (status);         exit(EXIT_FAILURE);      }        /*<      * keep searching until a usable binding handle is found      */ "     while (binding_handle == NULL)     { 
         /*D          * import a single binding handle, then try it in a real RPC          */ N         rpc_ns_binding_import_next (import_context, &binding_handle, &status);           if (status != rpc_s_ok) 	         { &             REPORT_DCE_ERROR (status);             exit(EXIT_FAILURE); 	         }   
         /*G          * convert the binding information obtained to a string binding           */ %         rpc_binding_to_string_binding ;                 (binding_handle, &string_binding, &status);            if (status != rpc_s_ok) 	         { &             REPORT_DCE_ERROR (status);             exit(EXIT_FAILURE); 	         }   
         /*B          * only use this binding if it's for the datagram protocol          */    	/* + 	 * To filter uncomment the following line: > 	 *  if ((strncmp ((char *) string_binding, "ncadg", 5)) == 0) 	 */' 	if (1)  /* In place of above filter */ 	         {              /*5              * update the booking file, counting back ,              * the specified number of weeks              */              book_update_file (                 binding_handle,                  book_name,=                 week_date - (book_c_retirement_interval * 7),                  &book_status, "                 &rpc_comm_status);  )             if (book_status != book_s_ok) 
             { B                 printf ("book: unable to access %s\n", book_name);#                 exit(EXIT_FAILURE); 
             }                /*H              * if the call doesn't get through, clear the binding handle7              * and try to import another server binding               */ ,             if (rpc_comm_status != rpc_s_ok)
             { 3                 REPORT_DCE_ERROR (rpc_comm_status);   <                 rpc_binding_free (&binding_handle, &status);
             } 	         }          else	         {              /*;              * if this binding handle isn't useful, free it               */ 8             rpc_binding_free (&binding_handle, &status);	         }   
         /**          * free the string binding as well          */ 3         rpc_string_free (&string_binding, &status); 	     }            /*      * free the search context      */ :     rpc_ns_binding_import_done (&import_context, &status);          if (status != rpc_s_ok)      { "         REPORT_DCE_ERROR (status);         exit(EXIT_FAILURE);      }        /*=      * enter the main loop to respond to interactive commands       */      printf ("\n");       main_loop(); }   L /***********************************************************************                                                                                                                                                                                                                                                   \                        rL $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "            **** **2 ** The main loop for accepting user command input. **L ***************************************************************************/   main_loop()  {      char        command[2];        for (;;)     {          printf ("BOOK> ");  
         /*B          * wait for command input, then upcase the first character          */          get_string (command);   *         command[0] = toupper (command[0]);           switch (command[0]) 	         {              case 'A': /                 if (show_agenda() == idl_false)                  { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'B': 2                 if (create_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;  -             case 'C': show_calendar(); break;                case 'D': 2                 if (delete_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;  )             case 'E': exit(EXIT_SUCCESS);                case 'F': 0                 if (show_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'G': .                 if (go_to_week() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;  $             case 'H': help(); break;               case 'L':                  week_date -= 7; 2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;               case 'M': 2                 if (modify_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'N':                  week_date += 7; 2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;  )             case 'Q': exit(EXIT_SUCCESS);                           case 'R': 2                 if (repeat_booking() == idl_false)                 { @                     printf ("Unable to access %s\n", book_name);                 }                  break;               case 'T':                  this_week();2                 printf ("Current week starting ");6                 write_date (week_date); printf ("\n");                 break;  5             default: printf ("Not a BOOK command\n");U	         }      }R }R .L /*************************************************************************** **D **  Get the next input string.  This is a thread-synchronous versionD **  of what gets() does. It has to be used because gets() may not beF **  thread-safe (in some threads implementations). If gets() is calledD **  it will block the whole process, which will prevent the protocol@ **  timer threads in the RPC runtime from executing as required. ** **  Inputs:T **      none ** **  Outputs:1 **	string = pointer to string buffer to be filledR ** **  Returns:3 **      idl_true for success, idl_false for failureL **L ***************************************************************************/   get_string (string)k   char        *string;   {*#     char        char_buf, *str_ptr;n     int         status;          /*2      * make sure we're starting with a clean slate      */*     fflush (stdout);     fflush (stderr);       /*J      * use read() to do input, which is thread-safe in this implementation      */n     for (str_ptr = string;<         ((status = read (fileno (stdin), &char_buf, 1))) > 0"             && (char_buf != '\n'); 	*str_ptr++ = char_buf);       /*+      * see if anything was actually read in       */ )     if (status <= 0 && str_ptr == string)n     {  	return (idl_false);     }n       /*&      * null-terminate the input string      */t     *str_ptr++ = '\0';       return (idl_true); }b iL /*************************************************************************** **0 **  Create a new booking in the server database. ** **  Returns:3 **      idl_true for success, idl_false for failure> **L ***************************************************************************/  k create_booking() {)     idl_short_int   begins;f     idl_short_int   ends;t     idl_short_int   previous;c     char            reply[2];       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */c     book_fill_week (         binding_handle,_         book_name,         week_date,
         week,o         &book_status,i         &rpc_comm_status);  !     if (book_status != book_s_ok)o     {;         return (idl_false);e     };  $     if (rpc_comm_status != rpc_s_ok)     {a+         REPORT_DCE_ERROR (rpc_comm_status);i         return (idl_false);i     }i       /*)      * collect details of the new bookings      */e     printf ("Day of week: ");         if ((day = get_day()) == -1)     {R         return (idl_true);     }n       printf ("Time begins: ");r  $     if ((begins = get_time()) == -1)     {          return (idl_true);     }c       printf ("Time finish: ");)  "     if ((ends = get_time()) == -1)     {          return (idl_true);     }e       ends--;l       if (ends <= begins)      {h8         printf ("How could it end before it starts?\n");         return (idl_true);     }N       reply[0] = 'y';c     previous = idl_false;r       /*E      * check to see if the new booking conflicts with an existing one       */_K     for (time_of_day = begins / 30; time_of_day < ends / 30; time_of_day++)s     {e#         if (week[day][time_of_day]) 	         {               previous = idl_true;             break;	         }"     },       if (previous)      {J
         /*I          * if there is a conflict, see what the user wants to do about it*          */*         if (!write_booking()) 	         {i             return (idl_false);e	         }p  >         printf ("\nDo you wish to cancel this meeting [n]? ");         get_string (reply);r  3         if ((reply[0] == 'y') || (reply[0] == 'Y')) 	         {p             /*C              * if this is an overwrite, remove the previous booking2'              * from the server databases              */;!             book_remove_booking (u                 binding_handle,s                 book_name,                  week_date + day,!                 time_of_day * 30,t                 &book_status,c"                 &rpc_comm_status);  )             if (book_status != book_s_ok) 
             {o/                 printf ("Meeting cancelled\n"); 
             }e             else
             { 2                 printf ("Error in book access\n");#                 return (idl_false);d
             }   ,             if (rpc_comm_status != rpc_s_ok)
             { 3                 REPORT_DCE_ERROR (rpc_comm_status);a#                 return (idl_false);*
             }e	         }      }v  /     if ((reply[0] == 'y') || (reply[0] == 'Y'))t     { 
         /*+          * get the rest of the booking info           */ <         printf ("Meeting who: "); get_string (booking.name);@         printf ("Meets where: "); get_string (booking.location);7         printf ("Notes: "); get_string (booking.notes); '         booking.date = week_date + day;i$         booking.time_start = begins;          booking.time_end = ends;  
         /*7          * write the new booking to the server database           */t         book_put_booking (             binding_handle,              book_name,               &booking,              &book_status,              &rpc_comm_status);  %         if (book_status != book_s_ok) 	         { .             printf ("Error in book access\n");             return (idl_false);n	         }u  (         if (rpc_comm_status != rpc_s_ok)	         { /             REPORT_DCE_ERROR (rpc_comm_status);              return (idl_false); 	         }*     }        return (idl_true); }  sL /*************************************************************************** **. **  Remove a booking from the server database. ** **  Returns:3 **      idl_true for success, idl_false for failurer **L ***************************************************************************/  c delete_booking() {e     char            reply[2];       idl_ulong_int   book_s                                                                                                                                                                                                                                                   ]                        ݴS $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        o "     &       tatus;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name, s         week_date, (         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)a     {          return (idl_false);R     }   $     if (rpc_comm_status != rpc_s_ok)     {i+         REPORT_DCE_ERROR (rpc_comm_status);d         return (idl_false);d     }        printf ("Day of week: ");         if ((day = get_day()) == -1)     {a         return (idl_true);     }        printf ("Time of day: ");p  )     if ((time_of_day = get_time()) == -1)n     {(         return (idl_true);     }        time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {h         time_of_day = 17;f     }e        if (!week[day][time_of_day])     {d:         printf ("No meeting is scheduled at this time\n");     }      else     {t         if (!write_booking())*	         {              return (idl_false); 	         }          else	         {              reply[0] = 'y'; B             printf ("\nDo you wish to cancel this meeting [n]? ");             get_string (reply);   7             if ((reply[0] == 'y') || (reply[0] == 'Y'))E
             { %                 book_remove_booking ( $                     binding_handle,                      book_name,%                     week_date + day, *&                     time_of_day * 30, !                     &book_status,T&                     &rpc_comm_status);  -                 if (book_status == book_s_ok)*                 {*3                     printf ("Meeting cancelled\n");                  }                  else                 {>6                     printf ("Error in book access\n");'                     return (idl_false);*                 }i  0                 if (rpc_comm_status != rpc_s_ok)                 { 7                     REPORT_DCE_ERROR (rpc_comm_status); '                     return (idl_false);f                 } 
             } 	         }      }(       return (idl_true); }_ eL /*************************************************************************** **A **  Update a booking in the server database with new information.  ** **  Returns:3 **      idl_true for success, idl_false for failure  **L ***************************************************************************/   modify_booking() {'     char            line[255];      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date, g         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);a     }   $     if (rpc_comm_status != rpc_s_ok)     {_+         REPORT_DCE_ERROR (rpc_comm_status);          return (idl_false);l     }c       printf ("Day of week: ");         if ((day = get_day()) == -1)     {          return (idl_true);     }        printf ("Time of day: ");   )     if ((time_of_day = get_time()) == -1)C     {w         return (idl_true);     }r       time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {'         time_of_day = 17;o     }o        if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }      else     {          if (!write_booking()) 	         {'             return (idl_false);7	         }            book_remove_booking (r             binding_handle,              book_name,             week_date + day, a             time_of_day * 30,              &book_status,              &rpc_comm_status);  %         if (book_status != book_s_ok)a	         { .             printf ("Error in book access\n");             return (idl_false); 	         }   (         if (rpc_comm_status != rpc_s_ok)	         { /             REPORT_DCE_ERROR (rpc_comm_status);n             return (idl_false); 	         }   6         printf ("\nMeeting who: "); get_string (line);           if (strlen (line))	         {o(             strcpy (booking.name, line);	         }*  4         printf ("Meets where: "); get_string (line);           if (strlen (line))	         {i,             strcpy (booking.location, line);	         }f  .         printf ("Notes: "); get_string (line);           if (strlen (line))	         {r)             strcpy (booking.notes, line); 	         }            book_put_booking (             binding_handle,              book_name, C             &booking,              &book_status,s             &rpc_comm_status);  %         if (book_status != book_s_ok)t	         {R.             printf ("Error in book access\n");             return (idl_false);*	         }*  (         if (rpc_comm_status != rpc_s_ok)	         {*/             REPORT_DCE_ERROR (rpc_comm_status);n             return (idl_false);f	         }n     }n       return (idl_true); }*  L /*************************************************************************** **B **  Repeat an existing booking in the server database for n weeks. ** **  Returns:3 **      idl_true for success, idl_false for failurer **L ***************************************************************************/   repeat_booking() {*     char            line[32];*     int             n;      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name, *         week_date, *         week,          &book_status,*         &rpc_comm_status);  !     if (book_status != book_s_ok)*     {e         return (idl_false);s     }   $     if (rpc_comm_status != rpc_s_ok)     {*+         REPORT_DCE_ERROR (rpc_comm_status);*         return (idl_false);g     }        printf ("Day of week: ");         if ((day = get_day()) == -1)     {          return (idl_true);     }l       printf ("Time of day: ");s  )     if ((time_of_day = get_time()) == -1)      {          return (idl_true);     }        time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)      {i         time_of_day = 17;k     }         if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }=     else     {          if (!write_booking())e	         {              return (idl_false);o	         }          else	         {(G             printf ("\nHow many weeks would you like to repeat [0]? ");*             get_string (line);$             sscanf (line, "%d", &n);                for (; n >= 1; n--) 
             { "                 booking.date += 7;                   /*;                  * append the new record at the end of file                   */e"                 book_put_booking ($                     binding_handle,                      book_name, (                     &booking, !                     &book_status, &                     &rpc_comm_status);  -                 if (book_status != book_s_ok)                  {[6                     printf ("Error in book access\n");'                     return (idl_false);s                 }n  0                 if (rpc_comm_status != rpc_s_ok)                 {37                     REPORT_DCE_ERROR (rpc_comm_status);_'                     return (idl_false);=                 } 
             } 	         }      }        return (idl_true); }   L /*************************************************************************** **1 **  Display the full agenda for the current week.  ** **  Returns:3 **      idl_true for success, idl_false for failureD **L ***************************************************************************/  f
 show_agenda()' {       int             slot_filled;     char            ch;       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;         /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date,           week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);      }   $     if (rpc_comm_status != rpc_s_ok)     {e+         REPORT_DCE_ERROR (rpc_comm_status);          return (idl_false);      }f       /*/      * paint the screen with the resulting dataa      */ &     printf ("%c[1;1H%c[2J", ESC, ESC);:     printf ("Agenda of %                                                                                                                                                                                                                                                   ^                        Pb $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "     7       s for week starting ", book_name);     write_date (week_date);a:     printf ("\n----------------------------------------");:     printf ("----------------------------------------\n");F     printf ("Time|    %c[1mMonday%c[m    |   %c[1mTuesday%c[m    |  ",         ESC, ESC, ESC, ESC);A     printf ("%c[1mWednesday%c[m   |   %c[1mThursday%c[m   |    ",e         ESC, ESC, ESC, ESC);0     printf ("%c[1mFriday%c[m    |\n", ESC, ESC);8     printf ("----------------------------------------");:     printf ("----------------------------------------\n");       /*L      * check each time slot in the week to see if there is an active booking      */ K     for (time_of_day = 0; time_of_day < book_c_times_in_day; time_of_day++)      {m!         if (time_of_day % 2 == 0) 	         {_             ch = '|';r!             if (time_of_day < 10)k
             {_N                 printf (" %c[1m%2d%c[m |", ESC, ((time_of_day / 2) + 8), ESC);
             }s             else
             {pN                 printf (" %c[1m%2d%c[m |", ESC, ((time_of_day / 2) - 4), ESC);
             } 	         }n         else	         {*             ch = '+';(             printf ("    +");*	         }*  P         for (slot_filled = idl_false, day = 0; day < book_c_days_in_week; day++)	         {d'             if (week[day][time_of_day])r
             { '                 slot_filled = idl_true;*
             }*	         }*           if (slot_filled)	         { ;             for (day = 0; day < book_c_days_in_week; day++)_
             {k,                 if (!week[day][time_of_day])                 {*4                     printf ("              %c", ch);                 }                  else                 {a                     /*G                      * for each time slot that shows a booking, get the F                      * details of the booking from the server database                      */ &                     book_get_booking ((                         binding_handle, "                         book_name,)                         week_date + day,  *                         time_of_day * 30, !                         &booking,e%                         &book_status, *                         &rpc_comm_status);  1                     if (book_status != book_s_ok)                      { :                         printf ("Error in book access\n");+                         return (idl_false);e                     }   4                     if (rpc_comm_status != rpc_s_ok)                     {l;                         REPORT_DCE_ERROR (rpc_comm_status); +                         return (idl_false);                      }   A                     if (time_of_day == (booking.time_start / 30))l                     { :                         printf (" %c[1;7m%-12.12s%c[m %c",8                             ESC, booking.name, ESC, ch);                     }k                     else                     { I                         if (time_of_day == (booking.time_start / 30) + 1)                          {0>                             printf (" %c[1m> %-10.10s%c[m %c",@                                 ESC, booking.location, ESC, ch);                         }                          else                         { A                             printf (" %c[1m     \"      %c[m %c", .                                 ESC, ESC, ch);                         })                     }                  }f
             }u               printf ("\n");	         }          else	         {EG             printf ("              %c              %c              %c",                  ch, ch, ch);B             printf ("              %c              %c\n", ch, ch);	         }*     }*  8     printf ("----------------------------------------");:     printf ("----------------------------------------\n");       return (idl_true); }e rL /*************************************************************************** **, **  Show the details of a specified booking. ** **  Returns:3 **      idl_true for success, idl_false for failurea **L ********************************************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Z ~      BOOK.SAV                        ,  1  [RPCBOOK.SRC]BOOK.C;1                                                                                                          n     d                          R     :       *******************/  e show_booking() {m      idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*F      * fill in the current week of time slots from the server database      */      book_fill_week (         binding_handle,          book_name,           week_date, s         week,          &book_status,          &rpc_comm_status);  !     if (book_status != book_s_ok)      {          return (idl_false);c     }   $     if (rpc_comm_status != rpc_s_ok)     {t+         REPORT_DCE_ERROR (rpc_comm_status);r         return (idl_false);T     }d       printf ("Day of week: ");=        if ((day = get_day()) == -1)     {n         return (idl_true);     }_       printf ("Time of day: ");   )     if ((time_of_day = get_time()) == -1)e     {          return (idl_true);     }]       time_of_day /= 30;  +     if (time_of_day == book_c_times_in_day)t     {;         time_of_day = 17;      }         if (!week[day][time_of_day])     { :         printf ("No meeting is scheduled at this time\n");     }      else     {i         if (!write_booking())k	         {              return (idl_false); 	         }o         else	         { ?             printf ("\nLocation: %.70s\n\n", booking.location);k.             printf ("%.70s\n", booking.notes);	         }r     }o       return (idl_true); }e nL /*************************************************************************** **< **  Display information on a booking in the server database. ** **  Returns:3 **      idl_true for success, idl_false for failure) **L ***************************************************************************/  o write_booking(); {       idl_ulong_int   book_status;$     error_status_t  rpc_comm_status;            /*9      * lookup the specified record in the server databasei      */      book_get_booking (         binding_handle,          book_name,         week_date + day, r         time_of_day * 30,          &booking,          &book_status,k         &rpc_comm_status);  !     if (book_status != book_s_ok)m     { *         printf ("Error in book access\n");         return (idl_false);t     }   $     if (rpc_comm_status != rpc_s_ok)     { +         REPORT_DCE_ERROR (rpc_comm_status);s         return (idl_false);d     })       /*&      * display the booking information      */ N     printf ("\nYou have a previously scheduled meeting with %c[1m%.12s%c[m\n",          ESC, booking.name, ESC);     printf ("on %c[1m", ESC);        switch (day)     {*)         case 0: printf ("Monday"); break;**         case 1: printf ("Tuesday"); break;,         case 2: printf ("Wednesday"); break;+         case 3: printf ("Thursday"); break;a)         case 4: printf ("Friday"); break;*     }*  )     printf ("%c[m from %c[1m", ESC, ESC);/$     write_time (booking.time_start);'     printf ("%c[m to %c[1m", ESC, ESC);;"     write_time (booking.time_end);     printf ("%c[m\n", ESC);s       return (idl_true); }* lL /***************************************************************************L ****************************************************************************L **************************************************************************** **H **  The rest of the code consists of local operations which have nothingC **  specific to do with to do with distribution of the application.E **L ****************************************************************************L ****************************************************************************L ***************************************************************************/ tL /*************************************************************************** **1 **  Convert day, month and year to a julian date.  ** **  Returns: **      julian date  **L ****************************                                                                                                                                                                                                                                                   _                        wQ $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        V "     H       ***********************************************/  d% int date_to_julian (day, month, year)e   int         day; int         month; int         year;    {      int         date;     
     date = 0;l  )     for (year -= 61; year > 3; year -= 4)n     {          date += 1461;t     })       date += year * 365;(  #     if ((year == 3) && (month > 2))      {          day++;     }>       switch (month)     { "         case 2 : day += 31; break;"         case 3 : day += 59; break;"         case 4 : day += 90; break;#         case 5 : day += 120; break; #         case 6 : day += 151; break; #         case 7 : day += 181; break; #         case 8 : day += 212; break; #         case 9 : day += 243; break; #         case 10: day += 273; break; #         case 11: day += 304; break; #         case 12: day += 334; break;      }        date += day;     return (date); }  kL /*************************************************************************** **2 **  Convert ASCII day format input to a day value. ** **  Returns: **      day valueO **L ***************************************************************************/  	 get_day()  {      char        week_day[2];     int         day = -1;      int         i;         get_string (week_day);       for (i = 0; i < 2; i++)*     {*,         week_day[i] = toupper (week_day[i]);     }        switch (week_day[0])     {s!         case 'M': day = 0; break;          case 'T':*                switch (week_day[1])
             {*)                 case 'U': day = 1; break; )                 case 'H': day = 3; break; 
             }_             break;  !         case 'W': day = 2; break; !         case 'F': day = 4; break;e     }        if (day == -1)     { %         printf ("Not a valid day\n");(     }        return (day);  }  oL /*************************************************************************** **4 **  Convert ASCII time format input to a time value. ** **  Returns: **      time value **L ***************************************************************************/  (
 get_time() {)     int         time, t1, t2; 4     char        time_string[book_c_time_string_max];         t1 = t2 = 0;     get_string (time_string); 0     sscanf (time_string, "%d %*c %d", &t1, &t2);       if (t1 < 8);     {r         t1 += 12;)     }         time = ((t1 - 8) * 60) + t2;  #     if ((time < 0) || (time > 540))-     {-;         printf ("Time is not in the range 8:00 to 5:00\n");n         time = -1;     }%       return (time); }, CL /*************************************************************************** **; **  Set the current date to a date that is fully specified.  ** **  Returns:3 **      idl_true for success, idl_false for failure" **L ***************************************************************************/   go_to_week() { +     int         new_date, day, month, year;i.     char        ndate[book_c_date_string_max];    0     printf ("Go to date: "); get_string (ndate);  8     if (unpack_date_string (ndate, &day, &month, &year))     {r5         new_date = date_to_julian (day, month, year);            if ((new_date % 7) < 2)m	         {(:             printf ("Sorry, we never work on weekends\n");	         }          else	         {r8             week_date = (new_date - (new_date % 7)) + 2;.             printf ("Current week starting ");#             write_date (week_date);              printf ("\n");	         }      }      else     {d/         printf ("Improperly formatted date\n");      }        return (idl_true); }e dL /*************************************************************************** **7 **  Display a help message showing the command options.  **L ***************************************************************************/   help() {      char        reply[2];d    #     printf ("%c[2J%c[H", ESC, ESC);   4     printf ("\n\nBOOK %c[1mHELP%c[m\n\n", ESC, ESC);  5     printf ("        %c[1mAgenda%c[m    ", ESC, ESC); <     printf ("-  Display the agenda for the current week\n");  5     printf ("        %c[1mBook%c[m      ", ESC, ESC);h?     printf ("-  Schedule a new meeting in the current week\n");   5     printf ("        %c[1mCalendar%c[m  ", ESC, ESC); 7     printf ("-  Display the current calendar range\n");   5     printf ("        %c[1mDelete%c[m    ", ESC, ESC); A     printf ("-  Remove an existing meeting from the schedule\n");   5     printf ("        %c[1mExit%c[m      ", ESC, ESC); 2     printf ("-  Terminate calendar processing\n");  5     printf ("        %c[1mFocus%c[m     ", ESC, ESC); <     printf ("-  Show the details of a specified meeting\n");  5     printf ("        %c[1mGoto%c[m      ", ESC, ESC); 7     printf ("-  Set the agenda to a different week\n");   5     printf ("        %c[1mHelp%c[m      ", ESC, ESC);E.     printf ("-  Display this help message\n");  5     printf ("        %c[1mLast%c[m      ", ESC, ESC); 8     printf ("-  Set the agenda to the previous week\n");  5     printf ("        %c[1mModify%c[m    ", ESC, ESC);(>     printf ("-  Modify the details of a specified meeting\n");  5     printf ("        %c[1mNext%c[m      ", ESC, ESC); 4     printf ("-  Set the agenda to the next week\n");  5     printf ("        %c[1mQuit%c[m      ", ESC, ESC); 2     printf ("-  Terminate calendar processing\n");  5     printf ("        %c[1mRepeat%c[m    ", ESC, ESC); 1     printf ("-  Extend a meeting for n weeks\n");   5     printf ("        %c[1mThis%c[m      ", ESC, ESC); 7     printf ("-  Set the agenda to the current week\n");n       printf ("\n\n");  H     printf ("Do you need the command format [n]? "); get_string (reply);  /     if ((reply[0] == 'y') || (reply[0] == 'Y'))      { '         printf ("%c[2J%c[H", ESC, ESC); D         printf ("\n\nBOOK commands have the following format:\n\n");S         printf ("     o  Top level commands may be entered as a single letter,\n");r         printf ("        ");O         printf ("upper or lower case. For example:  %c[1ma%c[m  =  Agenda\n\n",-             ESC, ESC);         printf ("     o  ");P         printf ("Days may be entered as a single letter, with the exception\n");U         printf ("        of Tuesday and Thursday, which require two letters. For\n"); &         printf ("        example:  ");F         printf ("%c[1mm%c[m  =  Monday,  %c[1mtu%c[m  =  Tuesday\n\n",              ESC, ESC, ESC, ESC);S         printf ("     o  Times are entered as a string, in the format hh : mm.\n"); Q         printf ("        Any non-digit character can be used as a separator,\n");eT         printf ("        and the minutes if (omitted default to 0. For example:\n");n         printf ("        %c[1m8:00%c[m = Eight AM, %c[1m3%c[m = Three PM, %c[1m4 50%c[m = Four-fifty PM.\n\n",*             ESC, ESC, ESC, ESC, ESC, ESC);T         printf ("     o  Dates are entered as strings, in the format dd-mmm-yy.\n");O         printf ("        For example:  %c[1m3-Jun-82%c[m  =  June 3, 1982\n\n",_             ESC, ESC);         printf ("     o  ");P         printf ("Account names are entered as a string. Sub-directories are\n");         printf ("        ");P         printf ("allowed. For example:  %c[1mDoe.Dates%c[m  =  [DOE.DATES]\n\n",             ESC, ESC);     }; }   L /*************************************************************************** **1 **  Convert a julian date to day, month and year.  **L ***************************************************************************/   ' julian_to_date (date, day, month, year)    int         date;_ int         *day;o int         *month;  int         *year;   {(E     *year = (((date / 1461) * 4) + ((date % 1461) / 365) + 61) % 100;s     date = (date % 1461) % 365;      *month = 1;u       if (date > 31)     {*         (*month)++;*         date -= 31;*     }*  %     if ((*month > 1) && (date > 28)) m     {n$         if (((*year - 64) % 4) != 0)	         {n             (*month)++;s             date -= 28;l	         }*         else	         {*             if (date > 29)
             {*                 (*month)++;                  date -= 29;a
             }_	         }p     }s  @     if ((*month > 2) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 3) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 4) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 5) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 6) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 7) && (date > 31)) { (*month)++; date -= 31; }@     if ((*month > 8) && (date > 30)) { (*month)++; date -= 30; }@     if ((*month > 9) && (date > 31)) { (*month)++; date -= 31; }A     if                                                                                                                                                                                                                                                   `                        lZ $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        0 "     Y        ((*month > 10) && (date > 30)) { (*month)++; date -= 30; }i       *day = date; }f \L /*************************************************************************** **? **  Paint the screen with a calendar based on the current date.a **L ***************************************************************************/   show_calendar()  { 
     struct     {W         int         year;          int         number;b         int         length;f         int         first_day;     } months[4];  &     static short    month_length[12] =K                         { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };e       int         d, w, m, x, y;     int         count[4];u!     int         day, month, year;*$     int         sday, smonth, syear;     int         month_date;*         /*      * get the system date      */*0     unpack_system_date (&sday, &smonth, &syear);              /*G      * fill in the data for the four month window - starting last month       */o4     julian_to_date (week_date, &day, &month, &year);     month--;       /*      * adjust for december      */*     if (month == 0)*     {*         month = 12;*         year--;*     }*  $     for (m = 0; m < 4; m++, month++)     {*
         /*5          * do next month, adjusting for year-end wrap*          */*         if (month > 12)*	         {*             month %= 12;             year++;*	         }*           months[m].year = year;!         months[m].number = month;:3         months[m].length = month_length[month - 1];*  
         /*;          * adjust length of february if this is a leap year(          */e,         if ((month == 2) && (year % 4 == 0))	         { "             months[m].length = 29;	         }a  
         /*:          * get the julian date for the first of this month          */ 5         month_date = date_to_julian (1, month, year);3  
         /*6          * mark the day of the week the first falls on          */ -         months[m].first_day = month_date % 7;3  %         if (months[m].first_day == 0)y	         {a$             months[m].first_day = 7;	         }      }:  &     printf ("%c[2;1H%c[2J", ESC, ESC);  '     for (y = 0; y < 4; count[y++] = 1);1  @     printf ("                     Calendar for week starting ");     write_date (week_date);a     printf ("\n");M     printf ("                     ------------------------------------\n\n");e       for (y = 0; y <= 2; y += 2)*     {*J         printf ("          S  %c[7m M   T   W   T   F %c[m  S", ESC, ESC);P         printf ("              S  %c[7m M   T   W   T   F %c[m  S\n", ESC, ESC);9         printf ("        +---+---+---+---+---+---+---+");*=         printf ("          +---+---+---+---+---+---+---+\n");            for (w = 0; w < 6; w++) 	         { #             for (x = 0; x < 2; x++)o
             {;                 if (w < 3)                 {wO                     printf ("    %c  ", month_name[months[x+y].number - 1][w]);                  }                  else                 {y'                     printf ("       ");e                 }k  (                 for (d = 1; d <= 7; d++)                 { J                     if (((count[x+y] == 1) && (d < months[x+y].first_day))=                         || (count[x+y] > months[x+y].length))                      {y(                         printf ("    ");                     }*                     else                     {*                         /*E                          * if this is the current date, highlight it,l?                          * otherwise just display it ordinarily*                          */i=                         if ((months[x+y].number == smonth) &&sP                             (count[x+y] == sday) && (months[x+y].year == syear))                         {,N                             printf ("  %c[1;5m%2d%c[m", ESC, count[x+y], ESC);                         }6                         else                         { 7                             printf ("%4d", count[x+y]);)                         }   %                         count[x+y]++;*                     }*                 }*                   if (x == 0)*                 {a$                     printf ("    ");                 }                  else                 {o"                     printf ("\n");                 }*
             }*	         }*  $         if (y == 0) printf ("\n\n");     }e     printf ("\n"); }r  L /*************************************************************************** **6 **  Set the current week according to the system time. **L ***************************************************************************/    this_week()f {n!     int         day, month, year;          /*:      * get the current system time (date) in unpacked form      */ -     unpack_system_date (&day, &month, &year);        /*-      * get julian date for first of this weekt      */;2     week_date = date_to_julian (day, month, year);2     week_date = (week_date - (week_date % 7)) + 2; }   L /*************************************************************************** **9 **  Extract the day, month and year from the system time.* **L ***************************************************************************/  % unpack_system_date (day, month, year)*   int         *day;* int         *month;  int         *year;   {      time_t	system_time;n      struct tm   *time_structure;         /*+      * get the current system time and date       */      time (&system_time);       /*/      * convert binary value to a time structurec      */e.     time_structure = localtime (&system_time);       /*B      * then extract the appropriate information from the structure      */ #     *day = time_structure->tm_mday; (     *month = time_structure->tm_mon + 1;$     *year = time_structure->tm_year; }n (L /*************************************************************************** **> **  Extract the day, month and year from an ASCII date string. ** **  Returns:3 **      idl_true for success, idl_false for failure" **L ***************************************************************************/  2 unpack_date_string (date_string, day, month, year)   char        date_string[]; int         *day;  int         *month;g int         *year;   {n      char        month_string[4];     int         i;    C     sscanf (date_string, "%d-%[^-]%*c%d", day, month_string, year);        for (i = 0; i < 4; i++)C     { 4         month_string[i] = toupper (month_string[i]);     }   6     if (strcmp (month_string, "JAN") == 0) *month = 1;;     else if (strcmp (month_string, "FEB") == 0) *month = 2; ;     else if (strcmp (month_string, "MAR") == 0) *month = 3; ;     else if (strcmp (month_string, "APR") == 0) *month = 4;f;     else if (strcmp (month_string, "MAY") == 0) *month = 5; ;     else if (strcmp (month_string, "JUN") == 0) *month = 6;[;     else if (strcmp (month_string, "JUL") == 0) *month = 7;i;     else if (strcmp (month_string, "AUG") == 0) *month = 8; ;     else if (strcmp (month_string, "SEP") == 0) *month = 9;n<     else if (strcmp (month_string, "OCT") == 0) *month = 10;<     else if (strcmp (month_string, "NOV") == 0) *month = 11;<     else if (strcmp (month_string, "DEC") == 0) *month = 12;     else return (idl_false);  "     if (*year > 99) *year -= 1900;       return (idl_true); };  L /*************************************************************************** **. **  Display a time value in ASCII time format. **L ***************************************************************************/  C write_time (time)(   int      time;   {r     int         minutes, hours;i         minutes = time % 60;     hours = (time / 60) + 8;       if (hours > 12)d     {c         hours -= 12;     })  '     printf ("%d:%02d", hours, minutes);  }   L /*************************************************************************** **6 **  Display a julian date in ASCII date string format. **L ***************************************************************************/  c write_date (date)d   int      date;   { !     int         day, month, year;n         /*5      * convert the julian date to day, month and year       */[/     julian_to_date (date, &day, &month, &year);1:     printf ("%d-%s-%02d", day, month_name[month-1], year); }CESC, ESC);T         printf ("     o  Dates are entered as strings, in the format dd-mmm-yy.\n");O         printf ("               * [RPCBOOK.SRC]BOOK.COM;1 +  , !1   .     /  @   4 L                          - 1    0   1    2   3      K  P   W   O     5   6 >u  7 6S(u  8          9          G  @  H                                                                                                                                                                                                                                                    a                        ed
 $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "     j        J $ N                   ?                $!- $!                      COPYRIGHT (C) 1993 BY 9 $!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 $!                  MASSACHUSETTS.  ALL RIGHTS RESERVED. $!H $! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK $! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D $! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG $! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L $! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. $!K $! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L $! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. $!F $! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 $! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  $! $! Abstract:. $!	BOOK.COM -- Builds the book example program $! $! Modification History:1 $! 	31-Aug-1993 fwb Modified for OpenVMS DCE V1.1  $!  : $! Establish compiler-specific arguments to the CC command $ @DCE:DCE$CC_TEST $! Determine option files $ $ If( f$trnlnm("dce$cc") .eqs. " " )J $ Then  options = "dce:dce.opt/options" + "," + "dce:dce_vaxc.opt/options"' $ Else  options = "dce:dce.opt/options"  $ Endif  $!- $! Enable the universal IDL command interface   $ idl := $sys$system:dce$idl.exe $ # $! Compile the interface definition A $! -keep all is used to keep the IDL output for training purposes 6 $ idl book.idl -keep all -trace all -trace log_manager $! $ cc := cc'f$trnlnm("dce$cc")'' $! Compile the client application files  $ cc book.c  $  $! Link the client application  $ link book,book_cstub,'options'# $ write sys$output "BOOK.EXE done."  $ ' $! Compile the server application files  $ cc book_main.c,book_mgr.c  $  $! Link the server application8 $ link/exe=bookd book_main,book_mgr,book_sstub,'options'$ $ write sys$output "BOOKD.EXE done."                                                                                                                                * [RPCBOOK.SRC]BOOK.IDL;1 +  , "-   .     /  @   4 L                          - 1    0   1    2   3      K  P   W   O 
    5   6 {'Y9c  7 Y9c  8          9          G  @  H  J $ N                   ?               /* 
**			COPYRIGHT (C) 1993 BY
**                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
**                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
**
**
**  NAME
**
**      book.idl
**
**  FACILITY:
**
**      RPC example program - BOOK calendar.
**
**  ABSTRACT:
**
**  Definitions of types/constants and procedures that make up the
**  remote interface to the BOOK server.
**
*/

[
uuid(0fe3973c-2fc5-11ca-bfb5-08002b1bb4f5),
version(1.0)
]

interface book
{

const long book_c_file_name_max     = 256;
const long book_c_book_name_max     = book_c_file_name_max - 5;

const long book_c_days_in_week      = 5;
const long book_c_times_in_day      = 18;

/*
 * how many weeks appointments are kept around
 */
const long book_c_retirement_interval = 8;

const long book_c_name_max          = 12;
const long book_c_location_max      = 70;
const long book_c_notes_max         = 70;

const long book_s_ok                = 0;
const long book_s_error             = 1;

typedef struct
{
    short       date;
    short       time_start;
    short       time_end;
    char        name[book_c_name_max];
    char        location[book_c_location_max];
    char        notes[book_c_notes_max];
} book_booking_record_t;

typedef [ptr] book_booking_record_t *book_booking_record_p_t;

/*
 * declare each routine in the server interface
 */
 
void book_fill_week
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [out]   short           week[book_c_days_in_week][book_c_times_in_day],
    [out]   error_status_t  *book_status
);

void book_get_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [in]    short           time,
    [out]   book_booking_record_t *booking,
    [out]   error_status_t  *book_status
);

void book_put_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    book_booking_record_p_t booking,
    [out]   error_status_t  *book_status
);

void book_remove_booking
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [in]    short           time,
    [out]   error_status_t  *book_status
);

void book_update_file
(
    [in]    handle_t        binding_handle,
    [in]    char            book_name[book_c_book_name_max],
    [in]    short           date,
    [out]   error_status_t  *book_status
);

}
                                                                                                                                                                                                                                                                                                                                                                                   * [RPCBOOK.SRC]BOOK.OPT;1 +  , #-   .     /  @   4                            - 1    0   1    2   3      K  P   W   O     5   6 ǋ.  7 *S  8          9          G  @  H  J $ N                   ?                sys$share:dce$lib_shr/share                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * [RPCBOOK.SRC]BOOK_MAIN.C;1 +  , $-   .     /  @   4 S      	                    - 1    0   1    2   3      K  P   W   O 
    5   6 }A  7  ;$  8          9          G  @  H  J $ N                   ?                             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book_main.c  **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **F **  This is the server "main" program that executes on server startup.J **  It creates an environment for the server to run, then starts listening **  for client requests. ** */ #include <pthread.h> #include <stdio.h> #include <stdlib.h>  #include <dce/dce_error.h> #include "rpcserver.h" #include "book.h"   % #define     book_c_server_if_count  1   " #define REPORT_DCE_ERROR(status) \ { \ Q     dce_error_inq_text (status, (unsigned_char_t *) error_text, &error_status); \  \      if (error_status == 0) \     { \ ;         fprintf (stderr, "DCE status: %s\n", error_text); \      }                                                                                                                                                                                                                                                    b                        bc# $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        	f "     {       \ 
     else \     { \ S         fprintf (stderr, "DCE status: %x (no error text translation)\n", status); \      } \  }   3 INTERNAL char   error_text[dce_c_error_string_len];  INTERNAL int    error_status;  int strncmp();   /*M  * the global file mutex - initialized here, and used by the manager routines   */ * pthread_mutex_t         book_g_file_mutex;  L /*************************************************************************** **F **  The server initialization routine that executes on server startup. **L ***************************************************************************/   main (argc, argv)    int             argc;  char            *argv[];   {      int                     i;.     rpc_if_descriptor_t     if_descriptors[1];4     char                    *program_name = "bookd";<     char                    *server_name = ".:/book_server";2     char                    *logfile = "book.log";1     char                    *logfile_name = NULL; B     unsigned int            mode = rpc_c_server_mode_no_privilege;#     error_status_t          status; (     int                     init_status;         /*"      * check out command arguments      */      for (i = 1; i < argc; i++)     { 
         /*!          * check for "debug" mode           */ .         if ((strncmp (argv[i], "-d", 2)) == 0)	         { ,             mode |= rpc_c_server_mode_debug;	         }   
         /*"          * check for "verify" mode          */ .         if ((strncmp (argv[i], "-v", 2)) == 0)	         { -             mode |= rpc_c_server_mode_verify; 	         }   
         /*#          * check for "logging" mode           */ .         if ((strncmp (argv[i], "-l", 2)) == 0)	         { #             logfile_name = logfile; 	         }      }        /*4      * call the common server initialization routine      */ 5     if_descriptors[0].if_handle = book_v1_0_s_ifspec; (     if_descriptors[0].object_ids = NULL;(     if_descriptors[0].annotation = NULL;  B     if ((init_status                                                            ~      BOOK.SAV                       $-  1  [RPCBOOK.SRC]BOOK_MAIN.C;1                                                                                                     S                              b              = rpc_server_init (program_name, server_name,6         1, if_descriptors, mode, NULL, &status)) != 0)     { "         REPORT_DCE_ERROR (status);         exit (init_status);      }        /*'      * initialize the global file mutex       */ G     pthread_mutex_init (&book_g_file_mutex, pthread_mutexattr_default);        /*$      * detach from the user terminal      */ +     if (! (mode & rpc_c_server_mode_debug))      {          if ((init_status =J             rpc_server_detach (program_name, logfile_name, &status)) != 0)	         { &             REPORT_DCE_ERROR (status);             exit (init_status); 	         }      }        /*      * wait for a remote call       */ @     rpc_server_listen (rpc_c_listen_max_calls_default, &status);          if (status != rpc_s_ok)      {          fprintf (stderr,I             "(%s) Error in rpc_server_listen - Exiting\n", program_name); "         REPORT_DCE_ERROR (status);         exit (EXIT_FAILURE);     }   
     exit (0);  }                                   * [RPCBOOK.SRC]BOOK_MGR.C;1 +  , %-   . ,    /  @   4 L   ,   )                     - 1    0   1    2   3      K  P   W   O -    5   6 wA  7 `:;$  8          9          G  @  H  J $ N                   ? R             /*   **			COPYRIGHT (C) 1993 BY9 **                 DIGITAL EQUIPMENT CORPORATION, MAYNARD 8 **                  MASSACHUSETTS.  ALL RIGHTS RESERVED. **H ** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDK ** ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION D ** OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESG ** THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER L ** PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED. **K ** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND L ** SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION. **F ** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS9 ** SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.  ** ** **  NAME ** **      book_mgr.c **
 **  FACILITY:  **+ **      RPC example program - BOOK calendar  **
 **  ABSTRACT:  **@ **  These are the server "manager" routines that actually handle **  incoming client requests.  ** */   #include <pthread.h> #include <stdio.h> #include <stdlib.h>  #include "book.h"    /*C  * Since the file system used for maintaining the calendar database C  * doesn't preserve updates from multiple readers and writers, in a H  * multi-threaded server we have to insure this doesn't happen. A simpleJ  * way to do this is to have a single mutex lock that must be taken beforeH  * any file operations can be performed. This will cause any thread that8  * wants to do a write to block until the mutex is free.  *E  * The downside of this implementation is that only one calendar file J  * can be open for reading or writing at any time. A better implementationC  * would keep a list of available calendar files, with a mutex lock D  * associated with each list entry. A thread that wanted to access aH  * calendar file would search the list for the name of the calendar, andH  * take out the lock on that entry. This would at least allow concurrent3  * operations on multiple different calendar files.   *  F  * Even more sophisticated implementations might take into account theI  * fact that it is ok for a file to be open for multiple readers, as long   * as there are no writers.   */    ) extern pthread_mutex_t book_g_file_mutex;   L /*************************************************************************** **@ **  Return to the client the current week of time slots based on, **  the booking information in the database. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user0 **      date = date of first day in current week ** **  Outputs:B **      week = array of time slots (booleans) for the current weekI **             (each time slot is idl_true if there is an active booking) . **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_fill_week  #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle, :       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,,       /* [out] */ idl_short_int week[5][18],.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else B 	(binding_handle, book_name, date, week, book_status, comm_status) handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date; ? idl_short_int   week[book_c_days_in_week][book_c_times_in_day];  error_status_t  *book_status;  error_status_t  *comm_status;  #endif   { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;      int         i, j;      int         pointer;         /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */ 7     if ((book = fopen ((char*)file_name, "r")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;      }        /*!      * clear out the current week       */ -     for (i = 0; i < book_c_days_in_week; i++)      { 1         for (j = 0; j < book_c_times_in_day; j++) 	         { #             week[i][j] = idl_false; 	         }      }        /*+      * read each record in the booking file       */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      { 
         /*8          * see if                                                                                                                                                                                                                                                    c                         $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "            this booking falls in the current week          */ *         if ((booking_record.date >= date) C             && (booking_record.date <= date + book_c_days_in_week)) 	         {              /*L              * fill in the time slot for each time contained in this booking              */ 6             for (j = (booking_record.time_start / 30);9                 j <= (booking_record.time_end / 30); j++) 
             { ?                 week[booking_record.date - date][j] = idl_true; 
             } 	         }      }        /*      * close the booking file       */      fclose (book);       /*&      * free the global file mutex lock      */ .     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);!     *book_status = book_s_ok;          return;  }   L /*************************************************************************** **@ **  Return to the client the booking information in the database" **  for a specified date and time. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user" **      date = date of the booking" **      time = time of the booking ** **  Outputs:/ **      booking = record of booking information . **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_get_booking  #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle, :       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,$       /* [in] */ idl_short_int time,1       /* [out] */ book_booking_record_t *booking, .       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else 	 K 	(binding_handle, book_name, date, time, booking, book_status, comm_status)    handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;  idl_short_int   time;  book_booking_record_t *booking;  error_status_t   *book_status; error_status_t   *comm_status;   #endif   { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;          /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */ 7     if ((book = fopen ((char*)file_name, "r")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);(         *book_status = book_s_error;             return;      }        /*+      * read each record in the booking file       */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      { 
         /*,          * see if there is a date/time match          */ '         if (date == booking_record.date 1             && (time >= booking_record.time_start 4                 && time <= booking_record.time_end))	         {              /*B              * on a match, return the booking record to the client              */ &             *booking = booking_record;               fclose (book);               /*.              * free the global file mutex lock              */ 6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);%             *book_status = book_s_ok;              return; 	         }      }        fclose (book);       /*&      * free the global file mutex lock      */ .     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);      *book_status = book_s_error;     return;  }   L /*************************************************************************** **: **  Write a record of booking information to the database. ** **  Inputs: ' **      binding_handle = client binding , **      book_name = string name of book user/ **      booking = record of booking information  ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_put_booking B     (binding_handle, book_name, booking, book_status, comm_status)   handle_t        binding_handle;  idl_char        book_name[];  book_booking_record_p_t booking; idl_ulong_int   *book_status;  idl_ulong_int   *comm_status;    { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;         /*@      * create a filename for the booking file from the book name      */ 5     sprintf ((char*)file_name, "%s.book", book_name);        /**      * take out the global file mutex lock      */ #     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*B      * open the existing file for read and write access at the end      */T8     if ((book = fopen ((char*)file_name, "a+")) == NULL)     {A
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;O     }O     else     {I
         /*?          * append the new record at the end of the booking fileD          */ &         if ((fwrite ((char *) booking,;             sizeof (book_booking_record_t), 1, book)) != 1)R	         {*             fclose (book);               /*.              * free the global file mutex lock              */M6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);(             *book_status = book_s_error;             return; 	         }            fclose (book);  
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);!         *book_status = book_s_ok;e         return;      }u }< rL /*************************************************************************** **G **  Remove a specified record of booking information from the database.n ** **  Inputs:e' **      binding_handle = client binding , **      book_name = string name of book user" **      date = date of the booking" **      time = time of the booking ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_remove_booking #ifdef IDL_PROTOTYPESn ( )       /* [in] */ handle_t binding_handle,b:       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,$       /* [in] */ idl_short_int time,.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )t #else 	hB 	(binding_handle, book_name, date, time, book_status, comm_status)   handle_t        binding_handle;r0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;o idl_short_int   time;h error_status_t  *book_status;e error_status_t  *comm_status;  #endif h { 0     idl_char    file_name[book_c_file_name_max];     FILE        *book;)     book_booking_record_t booking_record;*         /*@      * create a filename for the booking file from the book name      */m5     sprintf ((char*)file_name, "%s.book", book_name);t       /**      * take out the global file mutex lock      */n#     pthread_setcancel (CANCEL_OFF);f,     pthread_mutex_lock (&book_g_file_mutex);          /*E      * open the existing file for read/modify access at the beginningh      */ 8     if ((book = fopen ((char*)file_name, "r+")) == NULL)     { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;*     }*       /*+      * read each record in the booking file*      */ +     while (fread ((char *) &booking_record, 1         sizeof (book_booking_record_t), 1, book))      {n
         /*,          * see if there is a date/time match          */o'         if (date == booking_record.date_4             && (time >= booking_record.time_start &&1                 time <= booking_record.time_end))o	         {              /*=              * on a match, mark the current record as                                                                                                                                                                                                                                                    d                        Һe $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        B "            deleted               */i$             booking_record.date = 0;               /*F              * back up and write the deleted record back into the file              */i@             fseek (book, - (sizeof (book_booking_record_t)), 1);  1             if (fwrite ((char *) &booking_record,c9                 sizeof (book_booking_record_t), 1, book))r
             {_                 fclose (book);                   /*2                  * free the global file mutex lock                  */b:                 pthread_mutex_unlock (&book_g_file_mutex);.                 pthread_setcancel (CANCEL_ON);)                 *book_status = book_s_ok;_                 return; 
             }e	         }o     }e       fclose (book);       /*&      * free the global file mutex lock      */n.     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);      *book_status = book_s_error;     return;  }k  L /*************************************************************************** **J **  Update the database of booking information. Removes records previouslyJ **  marked for deletion, as well as entries older than the specified date. ** **  Inputs:d' **      binding_handle = client bindingj, **      book_name = string name of book user8 **      date = date marking beginning of active bookings ** **  Outputs:. **      book_status = pointer to idl_ulong_int. **      comm_status = pointer to idl_ulong_int **L ***************************************************************************/   void book_update_filel #ifdef IDL_PROTOTYPES  ( )       /* [in] */ handle_t binding_handle,>:       /* [in] */ idl_char book_name[book_c_file_name_max],$       /* [in] */ idl_short_int date,.       /* [out] */ error_status_t *book_status,1       /* [out] */ error_status_t *rpc_comm_status  )  #else < 	(binding_handle, book_name, date, book_status, comm_status)   handle_t        binding_handle; 0 idl_char        book_name[book_c_file_name_max]; idl_short_int   date;t error_status_t  *book_status;  error_status_t  *comm_status;* #endif   {e0     idl_char    file_name[book_c_file_name_max];0     idl_char    temp_name[book_c_file_name_max];2     idl_char    backup_name[book_c_file_name_max];     FILE        *book;     FILE        *new_book;     FILE        *backup;     int         backup_open;)     book_booking_record_t booking_record;*     int         status;          /*@      * create filenames for the booking files from the book name      */e5     sprintf ((char*)file_name, "%s.book", book_name);d5     sprintf ((char*)temp_name, "%s.temp", book_name);f       /**      * take out the global file mutex lock      */t#     pthread_setcancel (CANCEL_OFF); ,     pthread_mutex_lock (&book_g_file_mutex);          /*>      * open the existing file for read access at the beginning      */l7     if ((book = fopen ((char*)file_name, "r")) == NULL)*     {*
         /*/          * if it's not there, try to create oneI          */ ;         if ((book = fopen ((char*)file_name, "w")) == NULL)n	         {a             /*.              * free the global file mutex lock              */*6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);(             *book_status = book_s_error;             return;*	         }a         else	         {d             fclose (book);               /*.              * free the global file mutex lock              */_6             pthread_mutex_unlock (&book_g_file_mutex);*             pthread_setcancel (CANCEL_ON);%             *book_status = book_s_ok;s             return;r	         }t     }m       /*@      * open a new booking file for write access at the beginning      */ ;     if ((new_book = fopen ((char*)temp_name, "w")) == NULL)      { 
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;      }_       backup_open = idl_false;       /*/      * copy all valid records into the new fileg      */ +     while (fread ((char *) &booking_record,f2         sizeof (book_booking_record_t), 1, book))      { 
         /*"          * discard deleted records          */           if (booking_record.date)	         {_             /*D              * if booking has not expired, write it to the new file,4              * otherwise write it to the backup file              */n,             if (booking_record.date >= date)
             {k6                 if ((fwrite ((char *) &booking_record,G                     sizeof (book_booking_record_t), 1, new_book)) == 0)h                 { "                     fclose (book);&                     fclose (new_book);$                     fclose (backup);                       /*6                      * free the global file mutex lock                      */o>                     pthread_mutex_unlock (&book_g_file_mutex);2                     pthread_setcancel (CANCEL_ON);0                     *book_status = book_s_error;                     return;                  }_
             }_             else
             {_!                 if (!backup_open)                  {_                     /*G                      * open the backup file for write access at the end                       */ G                     sprintf ((char*)backup_name, "%s.back", book_name);n=                     backup = fopen ((char*)backup_name, "a"); +                     backup_open = idl_true;*                 }*                   /*8                  * append this record to the backup file                  */ 6                 if ((fwrite ((char *) &booking_record,E                     sizeof (book_booking_record_t), 1, backup)) == 0)n                 { "                     fclose (book);&                     fclose (new_book);$                     fclose (backup);                       /*6                      * free the global file mutex lock                      */n>                     pthread_mutex_unlock (&book_g_file_mutex);2                     pthread_setcancel (CANCEL_ON);0                     *book_status = book_s_error;                     return;_                 }t
             } 	         }      }n       fclose (book);     fclose (new_book);       /*9      * rename the new booking file to replace the old onet      */a4     if (rename ((char*)temp_name, (char*)file_name))     {n
         /**          * free the global file mutex lock          */ 2         pthread_mutex_unlock (&book_g_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;e     }        /*&      * free the global file mutex lock      */m.     pthread_mutex_unlock (&book_g_file_mutex);"     pthread_setcancel (CANCEL_ON);     *book_status = book_s_ok;u     return;b }_file_mutex);&         pthread_setcancel (CANCEL_ON);$         *book_status = book_s_error;         return;O     }O     else     {I
         /*?          * append the new record at the end of the booking fileD          */ &         if ((fwrite ((char *) booking,;             sizeof (book_booking_record_t), 1,              * [RPCBOOK.SRC]MAKEFILE.;1 +  , &,   .     /  @   4 R                            - 1    0   1    2   3      K  P   W   O     5   6 @  7 	@  8          9          G  @  H  J $ N                   ?               DCL_IDL= dcl mcr dce\$$idl IDL= $(DCL_IDL)  CFLAGS_INIT = -U VMS -I. IDL_CFLAGS= -v -keep c_source  CC = c892 OPTFILE= /vms/sys0/syscommon/dce\$$library/dce.opt	 APPL=book  IDLCMD=$(IDL)  ALIGN = -W member_alignment  MACHINE_TYPE:=`uname -Wh`    default: interface machine   machine:. 	@if [ "${MACHINE_TYPE}" != "Alpha" ] ; then \- 	echo "Complile & Link for VMS/Posix VAX" ; \ 9 	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT}"  build  ;\ 3 	else ; echo "Compile & Link for VMS/Posix AXP:" ;\ @ 	${MAKE} ${MAKEFLAGS} C_FLAGS="${CFLAGS_INIT} ${ALIGN}" build ;\ 	fi    build: ostubs book bookd   #  # INTERFACE BUILD  # 4 interface:	$(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c6 $(APPL).h $(APPL)_cstub.c $(APPL)_sstub.c:	$(APPL).idl$ 	$(IDLCMD) $(APPL).idl $(IDL_CFLAGS)   # STUB OBJECTS BUILD' ostubs:	$(APPL)_cstub.o $(APPL)_sstub.o @ $(APPL)_cstub.o $(APPL)_sstub.o:	$(APPL)_cstub.c $(APPL)_sstub.c4 	$(CC) $(C_FLAGS) -c $(APPL)_cstub.c $(APPL)_sstub.c   #  # CLIENT BUILD   # ) book:	$(APPL).h $(APPL).o $(APPL)_cstub.o A 	$(CC) $(C_FLAGS) -o $(APPL) $(APPL).o $(APPL)_cstub.o $(OPTFILE)    $(APPL).o: $(APPL).c 	$(CC) $(C_FLAGS) -c $(APPL).c                                                                                                                                                                                                                                                      e                        5a $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        j "            #  # SERVER BUILD   # 3 bookd:	$(APPL)_main.o $(APPL)_mgr.o $(APPL)_sstub.o R 	$(CC) $(C_FLAGS) -o bookd $(APPL)_main.o $(APPL)_mgr.o $(APPL)_sstub.o $(OPTFILE)   $(APPL)_main.o:	$(APPL)_main.c% 		$(CC) $(C_FLAGS) -c $(APPL)_main.c     $(APPL)_mgr.o:	$(APPL)_mgr.c" 	$(CC) $(C_FLAGS) -c $(APPL)_mgr.c     clean:2 	rm -f $(APPL) bookd *.o $(APPL)_*stub.c $(APPL).h              * [RPCBOOK.SRC]README.LIS;1 +  , '-   .     /  @   4 e       V                   - 1    0   1    2   3      K  P   W   O 
    5   6 hq>  7 ȾA>  8          9          G  @  H  J $ N                   ?               ! 		       BOOK Example Application   J /------------------------------------------------------------------------/ 			COPYRIGHT (C) 1993 BY7                  DIGITAL EQUIPMENT CORPORATION, MAYNARD 6                   MASSACHUSETTS.  ALL RIGHTS RESERVED.  F  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDI  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION B  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESE  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER J  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.  I  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND J  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.  D  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS7  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.   J /------------------------------------------------------------------------/  A The Distributed Calendar (BOOK) program is a fairly sophisticated E client/server application that makes use of a number of DCE services. E The program registers transport endpoints with the RPC daemon, and it D exports server binding information to the directory service. It alsoH demonstrates some minimal use of mutex locks to protect resources on the, server from access by multiple call threads.  H You can run this example application by building the necessary programs,L running the server, then running the client. Each step is discussed in turn, below.     1) Building the BOOK Programs     D    To build the BOOK example programs, enter the following commands:  !    In OpenVMS POSIX environments:         psx> cd /dev/mydir -      psx> copy /usr/dce/examples/rpc/book/* .       psx> make      On OpenVMS systems:  ;      $ copy sys$common:[syshlp.examples.dce.rpc.book]*.* []   '      Then, enter the following command:           $ @book.com  G      If the command procedure successfully builds each executable, you  G      receive a message informing you that an executable has been built.        	            2) Running the BOOKD Server   F    After the build is complete, you can run the server and the client.P    Both are built with the ability to log all events with the RPC Event Logger. <    See the Product Guide chapter on the RPC Event Logger for;    information about activating and using the event logger.   Q    To run the server on OpenVMS, you must perform dce_login ( use principal with  a    /.:/sybsys/dce/cds-server group membership or use cell_admin p/p) and define a foreign command *    with the full directory specification :  1      $ bookd :== "$mydisk:[mydirectory]bookd.exe"   0    Start the server with the following commands:      On OpenVMS            $ bookd -v            On OpenVMS/POSIX   c      psx> dce_login #Enter a principal/password that has /.:/sybsys/dce/cds-server group membership  			 or use cell_admin p/p e      psx> server.sh -v  # Checks for presence of credentials and invokes book server in verbose mode    C    The server accepts the following optional command arguments that F    affect the initialization sequence. The syntax for specifying these3    arguments is the same on both VMS and VMS/POSIX.          Argument    Description   L       -d          (Debug mode) Do not create a child process (run the server)                   in the parent process).   F       -v          (Verbose mode) Display informational messages during!                   initialization.   C   The server calls a useful set of initialization routines from the D   DCE library. These are shipped in rpcserver.c and rpcserver.h. TheE   first call, rpc_server_init(), creates (forks) a process to run the C   server (on UNIX systems) and initializes the RPC runtime with the F   appropriate parameters. The program does this before any other calls@   are made by the server to the RPC runtime and before any otherE   threads calls are made (because thread context is not guaranteed to E   be preserved across a fork).  After performing other initialization B   functions (this program initializes a global mutex), the programD   makes a second call to rpc_server_detach(). This call releases theE   terminal associated with the parent process, after which the parent F   process is free to exit. The server then starts listening for client   requests.        3) Running the BOOK Client      J    Once the server is running, you can run the client on the same host, orI    on any other host in the network that is configured to run in the same     cell as the server host.   B    To run the client on OpenVMS, you must define a foreign command)    with the full directory specification:   /      $ book :== "$mydisk:[mydirectory]book.exe"       Start the client on OpenVMS:          book [name]       On OpenVMS/POSIX         psx> book [name]    E    The [name] parameter is optional, and specifies whose calendar you     wish to use.   C    The client imports server binding information from the directory E    service, and causes the server to update the calendar file for the I    account in which the client is running. The client has a help facility F    that lists the commands that you can execute to modify the calendar    database on the server.  F    You can execute the client as many times as desired, as long as the    server is still running.   F    If you are building the programs on OpenVMS/POSIX, you can clean upE    the directory for this application so that you can build it again.      Enter the following command:        psx> make clean   F    This feature is not currently available on OpenVMS. You must delete    old files manually.                                                                                                                                                                                                                                                                                                                                                                                                                                                           * [RPCBOOK.SRC]RPCSERVER.C;2 +  , 3   . 4    /  @   4 S   4   2                    - 1   0   1    2   3      K  P   W   O 5    5   6 u  7 x3  8          9          G  @  H  J $ N                   ?                             /* **  Copyright (c) 1991 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** **  %a%copyright(,**  )  ** **  NAME ** **      rpcserver.c  **
 **  FACILITY:  ** **      DCE RPC  **
 **  ABSTRACT:  **+ **      Useful RPC server utility routines.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **7 **  11-jun-93 ferris    change freopen mode from A to a J **  25-jan-92 magid     in rpc_server_init(), convert the pid to a string I **                      before allocating the annotation string to ensure 1 **                      we don't overwrite memory ? **  16-dec-92 martin    add inclusion of vaxcshr.h for deccrtl. , **  31-Mar-92 keegan    add #include errno.h> **  23-feb-92 sudama    add no_privilege flag to mode argumentI **  19-feb-91 sudama    change error handling, add explicit output status D **  07-feb-92 htink     use DceError to provide locking of cat files1 **  23-jan-92 sudama    add interface descriptors ) **  20-jan-92 sudama    original creation  ** **  %a                                                           K.. ~      BOOK.SAV                       3  1  [RPCBOOK.SRC]RPCSERVER.C;2                                                                                                     S     4                          `            %private_end   ** */  ) #if defined(VAX) && defined(USE_DECC_RTL)  #include <vaxcshr.h> #endif   #include <pthread.h> #include <stdio.h> #include <errno.h> #include <stdlib.h>  #include <string.h> " #if defined(UNIX) || defined(uni                                                                                                                                                                                                                                                   f                        y% $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        { "            x) #include <time.h>  #include <unistd.h>  #include <sys/types.h> #include <sys/file.h>  #include <sys/wait.h>  #include <sys/ioctl.h> #endif #include <dce/rpc.h> #include <rpcserver.h>  " #if defined(UNIX) || defined(unix)! int         parent_child_pipe[2];  #endif   /* **++' **  ROUTINE NAME:       rpc_server_init  **9 **  SCOPE:              PRIVATE - declared in rpcserver.h  ** **  DESCRIPTION: **I **  (optionally) Fork a process to execute the server, and initialize the F **  RPC runtime in preparation for the server to listen for RPC calls. ** **  INPUTS:  **6 **      program_name    The name of the server daemon.J **      server_name     The name of the directory service entry into whichE **                      server binding information is to be exported. I **                      If NULL, no binding information will be exported. G **      if_count        A count of the number of RPC server interfaces. J **      if_descriptors  An array of size if_count of interface descriptorsE **                      to be registered with the RPC runtime and the F **                      endpoint mapper, and exported to the directory8 **                      service. For each if descriptor: **E **                      if_handle = interface handle generated by idl M **                      object_ids = vector of object uuid's to be registered L **                          with ep mapper and exported to directory serviceO **                          along with this interface; NULL if no object uuid's K **                      annotation = annotation field to be registered with @ **                          ep mapper along with this interface;E **                          NULL to use default based on program name  **M **                      Note that the first interface descriptor in the array J **                      will be used to check if there is already a serverF **                      of this type running, so it should contain theG **                      descriptor of some interface that will uniquely J **                      identify the server. Furthermore, the first objectM **                      id in the vector for the first interface will be used G **                      in the test, so in the event there is no unique N **                      interface for the server, an object id can be suppliedJ **                      that will uniquely identify a server of a specific **                      type.  **                      C **      mode            A bit mask containing the following fields:  **N **                      rpc_c_server_mode_debug - don't create a child processF **                          and don't require privileges to run serverH **                      rpc_c_server_mode_verify - display informational: **                          messages during initializationI **                      rpc_c_server_mode_no_if_register - don't register ; **                          interfaces with the RPC runtime I **                      rpc_c_server_mode_no_ep_register - don't register 9 **                          interfaces with the ep mapper F **                      rpc_c_server_mode_no_privilege - don't require4 **                          privileges to run server ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **M **     binding_vector   A vector of generated server bindings, comprising the L **                      protocol sequences actually supported by the server.6 **                      NULL on input if not required.J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  7 PRIVATE int rpc_server_init (program_name, server_name, ;     if_count, if_descriptors, mode, binding_vector, status)   & char                    *program_name;% char                    *server_name; ! unsigned int            if_count; ' rpc_if_descriptor_p_t   if_descriptors;  unsigned int            mode; ( rpc_binding_vector_p_t  *binding_vector;  error_status_t          *status;   {      int                     i;9     rpc_binding_vector_p_t  server_binding_vector = NULL; ,     char                    *ep_name = NULL;(     char                    *annotation;'     uuid_vector_p_t         object_ids; 4     error_status_t          local_status = rpc_s_ok;(     error_status_t          temp_status;)     char                    pid_buf[128];        /*7      * if the caller wants output status, initialize it       */      if (status)      {          *status = rpc_s_ok;      }   " #if defined(UNIX) || defined(unix)     { )         int                     uid, pid; -         char                    dummy_buffer;        /         if (! (mode & rpc_c_server_mode_debug)) 	         { :             if (! (mode & rpc_c_server_mode_no_privilege))
             {                  /*B                  * must be root (uid=0) to start the server daemon                  */                  uid = getuid();                         if (uid != 0)                  { $                     fprintf (stderr,H "(%s) You must have system privileges to start this server - Exiting\n",&                         program_name);                     return (1);                  } 
             }                /*J              * create a pipe on which the parent will listen for the childI              * to tell it that's it's ok to exit - which happens later on #              * in rpc_server_detach               *I              * this is here to try to insure that the parent doesn't exit K              * before the server is actually listening, to avoid messing up L              * something else that might be started in sequence that dependsH              * on this server - but it's not totally reliable, since theO              * child has to report *before* it actually calls rpc_server_listen               */ 0             if ((pipe (parent_child_pipe)) != 0)
             {              	fprintf (stderr, M                     "(%s) Unable to establish parent/child pipe - Exiting\n", "                     program_name);             	return (1);
             }                /*;              * fork a daemon process to execute this server               */              pid = fork();                /*1              * return an error if the fork failed               */              if (pid == -1)
             {                   fprintf (stderr,B "(%s) Unable to fork child process to execute server - Exiting\n","                     program_name);             	return (1);
             }                if (pid > 0)
             {      	    	int e_status;                 	/*A     	    	 * the parent waits for the child to report, then exits                   */ *             	close (parent_child_pipe[1]);  O             	read (parent_child_pipe[0], &dummy_buffer, sizeof (dummy_buffer));   5     	    	if (waitpid (pid, &e_status, WNOHANG) != 0)              	{,     	    	    exit (WEXITSTATUS (e_status));             	}     	    	else             	{     	    	    exit (0);              	}
             }                /*"              * the child continues              */ )             close (parent_child_pipe[0]);   0             if (mode & rpc_c_server_mode_verify)
             { C             	fprintf (stdout, "(%s) Created server process [%d]\n", ,                     program_name, getpid());
             }      	}     }  #endif       /*:      * set up the runtime to use all supported protocols -G      * first with the assumption that the one or more of the interfaces 3      * in the list has well-known endpoints defined       */ "     for (i = 0; i < if_count; i++)     { G         rpc_server_use_all_protseqs_if (rpc_c_protseq_max_reqs_default, 8             if_descriptors[i].if_handle, &local_status);  
         /*D          * if the same well-known endpoint is used for more than oneN          * interface, the call might fail because the soecket is already bound          */ )         if ((local_status != rpc_s_ok) && 5             (local_status != rpc_s_cant_bind_socket)) 	         { 2             if (local_status != rpc_s_no_protseqs)
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf                                                                                                                                                                                                                                                    g                        bR $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "            (stderr,S                         "(%s) Error in rpc_server_use_all_protseqs_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             } 	         }      }        /*6      * accomodate the use of dynamic endpoints as well      */bP     rpc_server_use_all_protseqs (rpc_c_protseq_max_reqs_default, &local_status);  !     if (local_status != rpc_s_ok)s     { +         if (mode & rpc_c_server_mode_debug)*	         {A             fprintf (stderr,H                 "(%s) Error in rpc_server_use_all_protseqs - Exiting\n",                 program_name);	         }e         goto EXIT_HANDLER;     }j       /**      * get back what is actually supported      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)t     {i+         if (mode & rpc_c_server_mode_debug)s	         {s             fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }          goto EXIT_HANDLER;     }d       /*F      * for each binding in the vector, try to contact a running server      */l6     for (i = 0; i < server_binding_vector->count; i++)     {j
         /*5          * clear any existing endpoint in the binding/          */eO         rpc_binding_reset (server_binding_vector->binding_h[i], &local_status);a  %         if (local_status != rpc_s_ok).	         {e/             if (mode & rpc_c_server_mode_debug)N
             {uO                 fprintf (stderr, "(%s) Error in rpc_binding_reset - Exiting\n",<"                     program_name);
             }/             goto EXIT_HANDLER;	         }c  
         /*I          * if there are any object id's for the first interface, use them]8          * to disambiguate servers of the same interface          */ 1         if (if_descriptors[0].object_ids != NULL)r	         { H             rpc_binding_set_object (server_binding_vector->binding_h[i],F                 if_descriptors[0].object_ids->uuid[0], &local_status);  -             if ((local_status != rpc_s_ok) && 7                 (local_status != ept_s_not_registered)) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_binding_set_object - Exiting\n", &                         program_name);                 }f"                 goto EXIT_HANDLER;
             }n	         }i  
         /*C          * resolve this binding to see if an endpoint is registered           */mD         rpc_ep_resolve_binding (server_binding_vector->binding_h[i],8             if_descriptors[0].if_handle, &local_status);  )         if ((local_status != rpc_s_ok) &&h3             (local_status != ept_s_not_registered)) 	         { /             if (mode & rpc_c_server_mode_debug)s
             {                   fprintf (stderr,G                     "(%s) Error in rpc_ep_resolve_binding - Exiting\n",h"                     program_name);
             }              goto EXIT_HANDLER;	         }l  
         /*C          * if there is a server registered for this binding, try toe+          * contact it to see if it's actives          */e%         if (local_status == rpc_s_ok) 	         {e             /*>              * set the comm timeout to a relatively short wait              */ $             rpc_mgmt_set_com_timeoutH                 (server_binding_vector->binding_h[i], 1, &local_status);  )             if (local_status != rpc_s_ok)a
             { 3                 if (mode & rpc_c_server_mode_debug)r                 {e$                     fprintf (stderr,M                         "(%s) Error in rpc_mgmt_set_com_timeout - Exiting\n",s&                         program_name);                 } "                 goto EXIT_HANDLER;
             }u  ,             if (rpc_mgmt_is_server_listeningD                 (server_binding_vector->binding_h[i], &temp_status))
             {                   fprintf (stderr,K "(%s) Please verify that no other %s is active on this system - Exiting\n",_0                     program_name, program_name);O                 rpc_binding_vector_free (&server_binding_vector, &temp_status); M                 errno = 0;      /* this return (1) is NOT a system failure */                  return (1);n
             }*	         }      }        /*      * free the binding vector      */ D     rpc_binding_vector_free (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)_     {r+         if (mode & rpc_c_server_mode_debug) 	         {s             fprintf (stderr,D                 "(%s) Error in rpc_binding_vector_free - Exiting\n",                 program_name);	         }v         goto EXIT_HANDLER;     }e     (     if (mode & rpc_c_server_mode_verify)     {rM         fprintf (stdout, "(%s) Server protocols registered\n", program_name);l     }c       /*2      * get back what is actually supported (again)      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)      { +         if (mode & rpc_c_server_mode_debug) 	         {              fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }f         goto EXIT_HANDLER;     }r  (     if (mode & rpc_c_server_mode_verify)     {C         fprintf (stdout,H             "(%s) Server binding information inquired\n", program_name);     }o       /*3      * Display the pid using the host's convention.sD      * VMS displays pids in hex. Everyone else seems to use decimal.      */h  #if defined(VMS) || defined(vms)(     sprintf (pid_buf, "[%X]", getpid()); #elsen(     sprintf (pid_buf, "[%d]", getpid()); #endif       /*I      * construct a name to annotate the ep map entry. Add 1 char for the gF      * space between program name and the pid. Add 1 char for the null      * terminating char.      */tO     ep_name = (char *) (malloc (strlen (program_name) + strlen (pid_buf) + 2));           if (ep_name == NULL)     { +         if (mode & rpc_c_server_mode_debug) 	         {sJ             fprintf (stderr, "(%s) Unable to allocate memory - Exiting\n",                 program_name);	         }]'         local_status = rpc_s_no_memory;o         goto EXIT_HANDLER;     }*  6     sprintf (ep_name, "%s %s", program_name, pid_buf);     "     for (i = 0; i < if_count; i++)     { 8         if (! (mode & rpc_c_server_mode_no_if_register))	         {              /*6              * register the interface with the runtime              */ "             rpc_server_register_ifI                 (if_descriptors[i].if_handle, NULL, NULL, &local_status);   )             if (local_status != rpc_s_ok)s
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_server_register_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             }   0             if (mode & rpc_c_server_mode_verify)
             {c                  fprintf (stdout,I                     "(%s) Server interfaces registered\n", program_name);-
             }l	         }      
         /*9          * check the optional fields in the if descriptorr          */n)         if (if_descriptors[i].object_ids) 	         {r6             object_ids = if_descriptors[i].object_ids;	         }          else	         {m             object_ids = NULL;	         }   8         if (! (mode & rpc_c_server_mode_no_ep_register))	         { -             if (if_descriptors[i].annotation)a
             {p:                 annotation = if_descriptors[i].annotation;
             }e             else
             { %                 annotation = ep_name; 
             }e               /*?              * register the dynamic endpoints that were created               */rP             rpc_ep_register (if_descriptors[i].if_handle, server_binding_vector,K                 object_ids, (unsigned_char_t *) annotation, &local_status);   )             if (local_status != rpc_s_ok) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,D                         "(%s) Error in rpc_ep_register - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }	  0             if (mode & rpc_c_server_mode_verify)
             {o                  fprintf (stdout,H                     "(%s                                                                                                                                                                                                                                                   h                        b
0K $      DCEAXPMUPA013.A                -  T+  M[SYSHLP.EXAMPLES.DCE.E[U8^QZ[O[G26;W;)htER_DATA]TRANSFER_DATA.SAV;1                                                              ~   ~<                        Q 4            Y T[;`!SP[EUJ;l5S#aBG&HyI>o	#fd5` 5DT3?F<,>>,oZ'
E
JDh:)
;n)P?~K2XE<R?L+PGF[dDgLevP% _L	!/F`nr/[6W-e/Nڱ자
UDkF^д[2Ȍ
^ӛj@MN+_VyhNzB	 Fj-QLA6^p`a t,j =gyEJMr
l&'υc:)VN Q"W^gprumRBb(MR7_u+P||<{w[R3Yd/?YH| +
:bWV{{"G!p z,09p<q*PPMx&> 'CR!Z-wɦ3L]E#^#HS#07#@i<9lx/*_%2~m	L%}Xl m\@0бHUxӋ46+1'>b	# {Sn|.{|w) EqþY3%lròI 2pSUfH#t&s5MhP<GFߩ-
h;+Rŋ(Ƕ{bn%
HP</rz+VEܱd%*зs:c~MZu
bÜΧQjz39;x7س[0{IY]ƺ7`jB.B<%iNhtNxNw H |x={&O9iFb||3cO9R^5
4.Z)
W4/CKl|QcbU1,%Q/)]$9:	Յ4#}(u+!ZW^~0h|䦶,,)gH#/|MBZ;;Msm(UU(w`s~0
Ħzbkw_t:%]&n? R|ad]j$VcI^^שxKy&yIףl.^hSgUjDZ*[IlIlW`XW8kLgs\b`Qz@C
paVmK_V0aYl:f)\UP;cs{4xSnD,M a
HE]X%X; ~1ѶǖNiԨʩǗbgtݪ@̌a$`s:d	+fy|:l
^#ՓC?;vyj
o Ӻ}Ү$|.%Ⱦ{wJTs<=	
'6챂"ƹ>ӢҘ?Eؿ(΄}Mv!?ٞdƤuoq;̋>NԱزgՒJX{
M4Q[ЦXQ旐둣7Z)0%ݦ6ܩ{sEҫ@Lҋ֡ԛb|(o~J2\P^1|;by1(1p8HA<#W;fT3%3{yS0"P}r2F; ?AwpO2ZPMGkp-D&(Ju8wY4Mk{1yn6_}.Eu%QNQ).d,e!?Rx"*`tMAy#fE8 :Tl_5__8^:0P;y!%ozyenK9(Cm6{HHM{|VI3ZT"9u* 4b>
 Aa
t030ZHpD=[F[T6I]cW"`LAw}xx/瘯bk*Dc bYMZ7;~_zj`>%qUIN!~\j3go-9.^PhHybrt'f^CqRay	;%.X3zG]	.rlt&XN\s'aI&
l'ɰ 9W-I3-S:- C{.k'.Sf@C<oq>jVVV-F$ewq yN^e'qu`mx{iuQ
M	#OuvE
R"v*sRa:n
> BAml4q;]>zS135DHikb5QfIt>#zm)oC**(NoU`S"OH+C;Bf{3q;$j|0g~@q:=:uCk?jsA!o%TO	@}i}Yvt|Tc.yC7!P8DR8	~D%  fChvvqa#gSH[w-JI$,^c|V
:oG]0?,	es2H.v~r+oF^j|(KKn B6}fۈ{LmUZ7%w#>w^zLhHb>O671?^+'t-E8c/44xiKۭ!3X(:ݍ-yPDgqK0e,suf^7L?,K|lIHU1HOj(|-+:cT--ڃ{}岵cR#2Lni[
:
SuQy'/bڢ`7|Zszj@947"x1_
fLӾ9ww٫U*uj94Q2$:U&ٳ#ٔ[>eAFZI3"(G(C`JgzL QT"ff/\G\=_%M~xHǛ҂ [(\Uw98$4`,.`ǎE[7}'QC
XiOQw*wvZPƨ(L҄6@Vgh,z=!V=-K$NyU
w-_3|> k-$!hH
Bw 㪬͖i ߣ;25{V?>k+87"A"׬/04OX7gfW'>=r~Q)o+ C/JrClqzcbt `A5?Up)C:+j5;5e4ddRZ%BYID H_c"m^yn6V<.^S1M!|,>'bKY'tJZ.l_9%Z
Awt0RPsR6~<r	QZ\*VeTusA8swBmJZ=2mh*cYUM~V,O={]{.Bosl7BD8C	jkn)k8uibb"0Wo58?~@.g*Ehm/%Tv103 \B+uobIMy&r@*w^94MHA
D+UsrX̚ܐSF+I<Dv~i4aA|?)|BIx?4C:&Z4V^XOyI{fiY&]M&^-$,+gcnC@nt>a1wI<Xw^5ga|-Ә9ɗכÏ߸ɾǌƧԼĸپ߱&KPbdh3;lw	c%I
|5Jh%H<Dk2md)6@xtu4SmL^, NM$Ow6G/?GRlTi
Q6t)XX1r43=xRpyhc&$:vGK418rs%J-lPf;[q-Pvk~9Im
.'KHI!
"`aa. *#+X,8/> L
+m4'	R+< <chBKc]@	+[Lv]hc}
$2/V{U=$VDofE-$ byiq|!0E6C	iMSRF8Iml
Aa!rGFڦүǩ౫򶗋諒jɊ홥xLu_O;e
7,YFJv"j`G$9P	v
z\o=|]LbKTTR|VI~;SsN,7]%~O+"Z=%$nrE
gmfsZSG_iJgWz#|vkrlh%_?˄܋րvӧݫ,,貫Z51 Q$[Yϗc(%JX*esw4g3%B ;?[Úc;Ͱ~cɭ-!ewk;y˾tݫʆ@A\4Q
ֳyj(eloF c[קJ$`/6gXN
Y^`=jټW:-ioҿ8RCрPS4EeKXaǙFY 8)r]N
qEzԧ=w-Nݧ#\ݰ׷Cv]G4}~ G9E,&/F\eNl#
	p!HM.2Gm=?,/o<<G!*@Ek%dv
c_pNTlC	 QnQ#^_" a-4']j!shCND/5+Vy{+aq%xp^A?gQGLz0)~w2PN~5U@\OY%9s'z.GS7T0{[`aiE<zTqU-+1wiHnRJrU(W;e5|l:D`L
P)}bYRox@{sYWfFsuz]LW+F{\d<iلէfݚɔ⠠I1(B|Z~]"4hxD(nMX+jpa6V/0[",}j'P+M]3Ncж햬ظðʜණهJ; v^da_W%KKV|~5s?c%N+VwWth%+v,;;|gHiHk-W*+3!e
rO/zM`'DrwNUh9Q5G W70L/q1le?Hw=.[r E
\AeE[dZi|# %5vfK7r. ^WOBw[ /1@Tt'26`vcc?Be0N$&Yns\};
8>Pom  +'Gh[l[:X^["#M2K]Ի6J6\-,N:	uXbyh52-4aqm!pr
b0B
w)CQt/4={lfs1|n!\%/5j+*iղ;gF<B"[Fo?d-̀㸉*_WI͓䧁`^ݬСٕיÖ=Mx򂶑躑ÔѰ.ɜ۳=ာإ΁lcTtp-uy a(^I>?/iA(j;(gU, JX_ZGnV{-eTqJ4m+
Lz
X7l5r?tqP8<Di{qR
j/.CT=k/y1{	R{
Bh},_0}I(\B9r%JR?^>1^Y3@q_tK@;VpgkKh]"1]3(6]!kR댻l9{<XGZT	wdG0"zE93u4d slq"M<Nn k6C|t6O[BrZ63*bX	T<stE"3| a^>~P	 6Sj<!DA<D?-48v%TE1 _&u4P)X7EoxN{X?|8_j36XXj9(7Th|$v$IRg3p|~2(Ga'$s<8<cNV`z+ag]>mnqy}_}es^J*"'m"q%+{dxԜ=O"OtEȅ_+<ĥ^/N5e8aS*7NDRMzjyw\v15ݰGQ(6\ޭ
K[M5
C{JXw٢iFf\aKLC$zc1F)W A|r37/0
광崂J
Y0
)JRW	ot_}3uj[#+hi 5b52G=K?55rw{bgBI' lzJ_yTTN32vVb76-2bhV;Hsx<ru<`ˠ7~`>4z".F׸*R4@d]_,v2X0V|<:@552Vrl'CD]~w@]8:[,qW50Ån[y|seBt)0JD2g"LcȚDq[T$juC6/7?,(~IS
l1) :zKj<uv4)>R::IjKA*SuP|'[Px%-~$L0fzU$|;J,,U5<IQC* $~>j6[g	jPz4 /N@:E&,IfaJ *BW9?2#U/!?%:{'/Ȏ~;u/G{
}Dc.bQhSJg/wzhqGw6IOASzg[vY[T~(=IWuWz_
zFKcv@wU \dw{k4rEAz*5Ԁ[1lKje,WB) mh}CjlplquJn*}Wp7
^:=Avk$zj*w\@d[Ft>`aC%/n/yXxFKI5I7]	 3+:elvT|W`$/^)^4yFG;hP7CV|wJ2Uhg3jBl3#lS;KUQi<hvhM*Ycd!GT'J/Cp!yt8h|sU7aOMDJ=c]0}i
U}QIXD.MgmSHjU-g2l/Hq<_iH+
$6arbBaMRf'C{j?d>.|+"JY8.SM{kAc1caEWd 5JyUiMYy$CIK>S}XXF}e}p<}t0|W>Q'%^B0su P7G=3oDu?OYwc'C_73X>]n6Tml)H/Hh)nr-"L8%@k>I?E`&
R1N!f+/SskC6q>P<^O[&"MLCAN"A_.?9W'Y_|<2#}N6Dg] iZ%[I	\Y \#/ZsmZ}{0LszK\V?LOMtY?c`Ciwj]oyKy3YGZN~JyB,; t"#km[Ei*1iL";),^T>@RQ"[u8Kcq?
ϰfA`k/U1~b6k{bōouAqtD;%[%f/MnwƚWE	{}si8=haLEk0_jw%㡑1_		tWv|:b({csab,;ӈg!kyB8"H+%
FDkF"@PZe+qnpN=:aUBy+"7T@l}8j P$__Va}i9D0	
Dj~Su_q:+*=2hFzr/tEnCarzKX!_<oTi2Gq&YkP @Q}Xlmqus%a>Eh^{f,R/,]XdP?~8LH"--0A(ZzKZAtmj[Q4yEvECEp"FqK	M1DhVSK{FNе\;SJ\)CH`.#WhIP	E[}OvX:C@4"63=@,/n+5bSb}`,4u_ 9XV3aI,;i65Р#s6M
	iK~~
.@!'VD8虘R&d&_}8BǷG2KL	?~jϴIK=hyP6ށ_d3Î1a#.ؽ-׽XY~TG[GC|
E'잟!)&bM٨|jFmrNnS`,dЮpջ
[+.4 f<+M"m=﯎2aӷBj삭ͧT`JTסI)НhguKWAFglI
ko}#$K kv'ȍd@F'L|)=, J[|9nw:j6+%]
MmYIXMS>#UqHLQK8AW79f(p
u?
(]i^ap[T<gb+g8x` m
e-,T}~9TB;? .j\<WI;Nf
q`J X ׶mi"BE9*]^za@D2xQjI&4H,
sI
!U^RoeW@r:AU[Ó`Y?Gcxyb7-{T%;/ yFDq4]-#a;QaI(Rc?!Za/?Gmk;l`cs1p!^	ӣE4yKN,gyyLϘ0VH+/D!m*
mYO|,@ =bg:P_PBH6|A~MG`p]HbH)/wDЍeHDG7;e R:*إ0@GPדxH+9m"`6[\<~N@Dȭ:C	h͜Bf.NyKI!34P-!6x,L
xsELDbjMP7TpOWX.6j&aB5I}Q)j
Zw-XxW騡2NsE0x*LN](p<VXo8u-Ov;$S7ye4^Ƌ37ܧKvfyV[ɚ4m|_zh_`;{uYX	24pfU_[6b񩜻f~mRW<
DEub%	[![(ilEubO	?"P;`-A3A2c~smSe|JgA1O=[@P(P<r&z%1)2/.
% 5AF3 \!IcfC&=                                                                                                                                                                                                                                                  i                        ä# $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        J  "            ) Server endpoints registered\n", program_name);
             }p	         }_            if (server_name != NULL)	         {              /*B              * export the server bindings to the directory service              */S#             rpc_ns_binding_export ( (                 rpc_c_ns_syntax_default,0                 (unsigned_char_t *) server_name,,                 if_descriptors[i].if_handle,&                 server_binding_vector,                 object_ids,                  &local_status);_  )             if (local_status != rpc_s_ok)r
             {(3                 if (mode & rpc_c_server_mode_debug)                  {e$                     fprintf (stderr,J                         "(%s) Error in rpc_ns_binding_export - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }w  0             if (mode & rpc_c_server_mode_verify)
             {                   fprintf (stdout,P                     "(%s) Server binding information exported\n", program_name);
             }t	         }      }*    
 EXIT_HANDLER:        /*8      * free the name used for the ep database annotation      */      if (ep_name != NULL)     {e         free (ep_name);      }        /*:      * free the binding vector, unless the caller wants it      */c?     if ((local_status == rpc_s_ok) && (binding_vector != NULL))p     {p-     	*binding_vector = server_binding_vector;o%         server_binding_vector = NULL;      }      else     { *         if (server_binding_vector != NULL)	         {rK             rpc_binding_vector_free (&server_binding_vector, &temp_status); 	         }e	     }       !     if (local_status != rpc_s_ok)_     {;
         /*>          * pass back the failure status if the caller wants it          */o         if (status)b	         {e#             *status = local_status;m	         }a         return (1);      }f       return (0);p }_ s /* **++) **  ROUTINE NAME:       rpc_server_detach* **9 **  SCOPE:              PRIVATE - declared in rpcserver.hs ** **  DESCRIPTION: **F **  Detach the server from the user terminal and (optionally) redirect$ **  stdout and stderr to a log file. ** **  INPUTS:t **6 **      program_name    The name of the server daemon.@ **      logfile_name    The full pathname of the server logfile.D **                      If NULL, no logfile will be created - stdoutC **                      and stderr will be redirected to /dev/null.  ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  B PRIVATE int rpc_server_detach (program_name, logfile_name, status)  & char                    *program_name;& char                    *logfile_name;  error_status_t          *status;   {      /*7      * if the caller wants output status, initialize itf      */t     if (status)t     {b         *status = rpc_s_ok;t     }   " #if defined(UNIX) || defined(unix)     {b$         int                     tty;)         FILE                    *logfile;g(         time_t                  systime;    
         /*F          * we must reassign stdout and stderr to files or we'll end upE          * spewing some random garbage into a random terminal at some           * random future time 
          *M          * do this before detaching the terminal, so we can report errors andd&          * exit if anything goes wrong          */i!         if (logfile_name != NULL) 	         { :             logfile = freopen (logfile_name, "a", stdout);                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }s
         }    &         else	         { 9             logfile = freopen ("/dev/null", "w", stdout);u                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }g	         }   +         setvbuf (logfile, NULL, _IONBF, 0);            if ((dup2 (1,2)) == -1)*	         {s             fprintf (stderr,B                 "(%s) Unable to reassign program I/O - Exiting\n",                 program_name);             return (1); 	         }   
         /*(          * write a header to the logfile          */t         time (&systime);B         fprintf (stdout, "[%d] %s\n", getpid(), ctime (&systime));.                                               . #ifdef _BSD                                   .         if (setpgrp(0, getpid()) < 0) {       .             fprintf (stderr,                  H                 "(%s) Unable to create a new process group - Exiting\n",.                 program_name);                .             return(1);                        .         }                                     .                                               .         if (setreuid (0,0) < 0) {             .             fprintf (stderr,                  ;                 "(%s) Unable to set uids to 0 - Exiting\n",i.                 program_name);                .             return(1);                        .         }                                     .                                               
         /*&          * detach from controlling tty          */ 3         if ((tty = open ("/dev/tty", O_RDWR)) >= 0) 	         { /             ioctl (tty, TIOCNOTTY, (char *) 0);i             close (tty);         }                                     #else                          if (setsid() < 0) {&             fprintf (stderr,B                 "(%s) Unable to set process group id - Exiting\n",                 program_name);             return(1);         }                      if (setuid(0) < 0) {             fprintf (stderr,:                 "(%s) Unable to set uid to 0 - Exiting\n",                 program_name);             return(1);         }              #endif                  
         /*M          * inform the parent that we're ready to process requests (by closing_7          * the pipe, and causing the parent to wake up)           */(%         close (parent_child_pipe[1]);      }  #endif       return (0);  }                                                                                                                                              * [RPCBOOK.SRC]RPCSERVER.C;1 +  , (-   . 4    /  @   4 S   4   2                    - 1    0   1    2   3      K  P   W   O 5    5   6 u  7 xb  8          9          G  @  H  J $ N                   ?                             /* **  Copyright (c) 1991 by 5 **      Digital Equipment Corporation, Maynard, Mass.  ** **  %a%copyright(,**  )  ** **  NAME ** **      rpcserver.c  **
 **  FACILITY:  ** **      DCE RPC  **
 **  ABSTRACT:  **+ **      Useful RPC server utility routines.  ** **  %a%private_begin ** **  MODIFICATION HISTORY:  **7 **  11-jun-93 ferris    change freopen mode from A to a J **  25-jan-92 magid     in rpc_server_init(), convert the pid to a string I **                      before allocating the annotation string to ensure 1 **                      we don't overwrite memory ? **  16-dec-92 martin    add inclusion of vaxcshr.h for deccrtl. , **  31-Mar-92 keegan    add #include errno.h> **  23-feb-92 sudama    add no_privilege flag to mode argumentI **  19-feb-91 sudama    change error handling, add explicit output status D **  07-feb-92 htink     use DceError to provide locking of cat files1 **  23-jan-92 sudama    add interface descriptors ) **  20-jan-92 sudama    original creation  ** **  %a%private_end   ** */  ) #if defined(VAX) && defined(USE_DECC_RTL)  #include <vaxcshr.h> #endif   #include <pthread.h> #include <stdio.h> #include <errno.h> #include <stdlib.h>  #include <string.h> " #if defined(UNIX) || defined(unix) #include <time.h>  #include <unistd.h>  #include <sys/types.h> #include <sys/file.h>  #include <sys/wait.h>  #include <sys/ioctl.h> #endif #include <dce/rpc.h> #include <rpcserver.                                                                                                                                                                                                                                                   j                        
	 $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "            h>  " #if defined(UNIX) || defined(unix)! int         parent_child_pipe[2];  #endif   /* **++' **  ROUTINE NAME:       rpc_server_init  **9 **  SCOPE:              PRIVATE - declared in rpcserver.h  ** **  DESCRIPTION: **I **  (optionally) Fork a process to execute the server, and initialize the F **  RPC runtime in preparation for the server to listen for RPC calls. ** **  INPUTS:  **6 **      program_name    The name of the server daemon.J **      server_name     The name of the directory service entry into whichE **                      server binding information is to be exported. I **                      If NULL, no binding information will be exported. G **      if_count        A count of the number of RPC server interfaces. J **      if_descriptors  An array of size if_count of interface descriptorsE **                      to be registered with the RPC runtime and the F **                      endpoint mapper, and exported to the directory8 **                      service. For each if descriptor: **E **                      if_handle = interface handle generated by idl M **                      object_ids = vector of object uuid's to be registered L **                          with ep mapper and exported to directory serviceO **                          along with this interface; NULL if no object uuid's K **                      annotation = annotation field to be registered with @ **                          ep mapper along with this interface;E **                          NULL to use default based on program name  **M **                      Note that the first interface descriptor in the array J **                      will be used to check if there is already a serverF **                      of this type running, so it should contain theG **                      descriptor of some interface that will uniquely J **                      identify the server. Furthermore, the first objectM **                      id in the vector for the first interface will be used G **                      in the test, so in the event there is no unique N **                      interface for the server, an object id can be suppliedJ **                      that will uniquely identify a server of a specific **                      type.  **                      C **      mode            A bit mask containing the following fields:  **N **                      rpc_c_server_mode_debug - don't create a child processF **                          and don't require privileges to run serverH **                      rpc_c_server_mode_verify - display informational: **                          messages during initializationI **                      rpc_c_server_mode_no_if_register - don't register ; **                          interfaces with the RPC runtime I **                      rpc_c_server_mode_no_ep_register - don't register 9 **                          interfaces with the ep mapper F **                      rpc_c_server_mode_no_privilege - don't require4 **                          privileges to run server ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **M **     binding_vector   A vector of generated server bindings, comprising the L **                      protocol sequences actually supported by the server.6 **                      NULL on input if not required.J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  7 PRIVATE int rpc_server_init (program_name, server_name, ;     if_count, if_descriptors, mode, binding_vector, status)   & char                    *program_name;% char                    *server_name; ! unsigned int            if_count; ' rpc_if_descriptor_p_t   if_descriptors;  unsigned int            mode; ( rpc_binding_vector_p_t  *binding_vector;  error_status_t          *status;   {      int                     i;9     rpc_binding_vector_p_t  server_binding_vector = NULL; ,     char                    *ep_name = NULL;(     char                    *annotation;'     uuid_vector_p_t         object_ids; 4     error_status_t          local_status = rpc_s_ok;(     error_status_t          temp_status;)     char                    pid_buf[128];        /*7      * if the caller wants output status, initialize it       */      if (status)      {          *status = rpc_s_ok;      }   " #if defined(UNIX) || defined(unix)     { )         int                     uid, pid; -         char                    dummy_buffer;        /         if (! (mode & rpc_c_server_mode_debug)) 	         { :             if (! (mode & rpc_c_server_mode_no_privilege))
             {                  /*B                  * must be root (uid=0) to start the server daemon                  */                  uid = getuid();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       䓡 ~      BOOK.SAV                       (-  1  [RPCBOOK.SRC]RPCSERVER.C;1                                                                                                     S     4                         _ J                        if (uid != 0)                  { $                     fprintf (stderr,H "(%s) You must have system privileges to start this server - Exiting\n",&                         program_name);                     return (1);                  } 
             }                /*J              * create a pipe on which the parent will listen for the childI              * to tell it that's it's ok to exit - which happens later on #              * in rpc_server_detach               *I              * this is here to try to insure that the parent doesn't exit K              * before the server is actually listening, to avoid messing up L              * something else that might be started in sequence that dependsH              * on this server - but it's not totally reliable, since theO              * child has to report *before* it actually calls rpc_server_listen               */ 0             if ((pipe (parent_child_pipe)) != 0)
             {              	fprintf (stderr, M                     "(%s) Unable to establish parent/child pipe - Exiting\n", "                     program_name);             	return (1);
             }                /*;              * fork a daemon process to execute this server               */              pid = fork();                /*1              * return an error if the fork failed               */              if (pid == -1)
             {                   fprintf (stderr,B "(%s) Unable to fork child process to execute server - Exiting\n","                     program_name);             	return (1);
             }                if (pid > 0)
             {      	    	int e_status;                 	/*A     	    	 * the parent waits for the child to report, then exits                   */ *             	close (parent_child_pipe[1]);  O             	read (parent_child_pipe[0], &dummy_buffer, sizeof (dummy_buffer));   5     	    	if (waitpid (pid, &e_status, WNOHANG) != 0)              	{,     	    	    exit (WEXITSTATUS (e_status));             	}     	    	else             	{     	    	    exit (0);              	}
             }                /*"              * the child continues              */ )             close (parent_child_pipe[0]);   0             if (mode & rpc_c_server_mode_verify)
             { C             	fprintf (stdout, "(%s) Created server process [%d]\n", ,                     program_name, getpid());
             }      	}     }  #endif       /*:      * set up the runtime to use all supported protocols -G      * first with the assumption that the one or more of the interfaces 3      * in the list has well-known endpoints defined       */ "     for (i = 0; i < if_count; i++)     { G         rpc_server_use_all_protseqs_if (rpc_c_protseq_max_reqs_default, 8                                                                                                                                                                                                                                                          k                        uQ} $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        ss "                 if_descriptors[i].if_handle, &local_status);  
         /*D          * if the same well-known endpoint is used for more than oneN          * interface, the call might fail because the soecket is already bound          */ )         if ((local_status != rpc_s_ok) && 5             (local_status != rpc_s_cant_bind_socket)) 	         { 2             if (local_status != rpc_s_no_protseqs)
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,S                         "(%s) Error in rpc_server_use_all_protseqs_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             } 	         }      }        /*6      * accomodate the use of dynamic endpoints as well      */bP     rpc_server_use_all_protseqs (rpc_c_protseq_max_reqs_default, &local_status);  !     if (local_status != rpc_s_ok)s     { +         if (mode & rpc_c_server_mode_debug)*	         {A             fprintf (stderr,H                 "(%s) Error in rpc_server_use_all_protseqs - Exiting\n",                 program_name);	         }e         goto EXIT_HANDLER;     }j       /**      * get back what is actually supported      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)t     {i+         if (mode & rpc_c_server_mode_debug)s	         {s             fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }          goto EXIT_HANDLER;     }d       /*F      * for each binding in the vector, try to contact a running server      */l6     for (i = 0; i < server_binding_vector->count; i++)     {j
         /*5          * clear any existing endpoint in the binding/          */eO         rpc_binding_reset (server_binding_vector->binding_h[i], &local_status);a  %         if (local_status != rpc_s_ok).	         {e/             if (mode & rpc_c_server_mode_debug)N
             {uO                 fprintf (stderr, "(%s) Error in rpc_binding_reset - Exiting\n",<"                     program_name);
             }/             goto EXIT_HANDLER;	         }c  
         /*I          * if there are any object id's for the first interface, use them]8          * to disambiguate servers of the same interface          */ 1         if (if_descriptors[0].object_ids != NULL)r	         { H             rpc_binding_set_object (server_binding_vector->binding_h[i],F                 if_descriptors[0].object_ids->uuid[0], &local_status);  -             if ((local_status != rpc_s_ok) && 7                 (local_status != ept_s_not_registered)) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_binding_set_object - Exiting\n", &                         program_name);                 }f"                 goto EXIT_HANDLER;
             }n	         }i  
         /*C          * resolve this binding to see if an endpoint is registered           */mD         rpc_ep_resolve_binding (server_binding_vector->binding_h[i],8             if_descriptors[0].if_handle, &local_status);  )         if ((local_status != rpc_s_ok) &&h3             (local_status != ept_s_not_registered)) 	         { /             if (mode & rpc_c_server_mode_debug)s
             {                   fprintf (stderr,G                     "(%s) Error in rpc_ep_resolve_binding - Exiting\n",h"                     program_name);
             }              goto EXIT_HANDLER;	         }l  
         /*C          * if there is a server registered for this binding, try toe+          * contact it to see if it's actives          */e%         if (local_status == rpc_s_ok) 	         {e             /*>              * set the comm timeout to a relatively short wait              */ $             rpc_mgmt_set_com_timeoutH                 (server_binding_vector->binding_h[i], 1, &local_status);  )             if (local_status != rpc_s_ok)a
             { 3                 if (mode & rpc_c_server_mode_debug)r                 {e$                     fprintf (stderr,M                         "(%s) Error in rpc_mgmt_set_com_timeout - Exiting\n",s&                         program_name);                 } "                 goto EXIT_HANDLER;
             }u  ,             if (rpc_mgmt_is_server_listeningD                 (server_binding_vector->binding_h[i], &temp_status))
             {                   fprintf (stderr,K "(%s) Please verify that no other %s is active on this system - Exiting\n",_0                     program_name, program_name);O                 rpc_binding_vector_free (&server_binding_vector, &temp_status); M                 errno = 0;      /* this return (1) is NOT a system failure */                  return (1);n
             }*	         }      }        /*      * free the binding vector      */ D     rpc_binding_vector_free (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)_     {r+         if (mode & rpc_c_server_mode_debug) 	         {s             fprintf (stderr,D                 "(%s) Error in rpc_binding_vector_free - Exiting\n",                 program_name);	         }v         goto EXIT_HANDLER;     }e     (     if (mode & rpc_c_server_mode_verify)     {rM         fprintf (stdout, "(%s) Server protocols registered\n", program_name);l     }c       /*2      * get back what is actually supported (again)      */nD     rpc_server_inq_bindings (&server_binding_vector, &local_status);     !     if (local_status != rpc_s_ok)      { +         if (mode & rpc_c_server_mode_debug) 	         {              fprintf (stderr,D                 "(%s) Error in rpc_server_inq_bindings - Exiting\n",                 program_name);	         }f         goto EXIT_HANDLER;     }r  (     if (mode & rpc_c_server_mode_verify)     {C         fprintf (stdout,H             "(%s) Server binding information inquired\n", program_name);     }o       /*3      * Display the pid using the host's convention.sD      * VMS displays pids in hex. Everyone else seems to use decimal.      */h  #if defined(VMS) || defined(vms)(     sprintf (pid_buf, "[%X]", getpid()); #elsen(     sprintf (pid_buf, "[%d]", getpid()); #endif       /*I      * construct a name to annotate the ep map entry. Add 1 char for the gF      * space between program name and the pid. Add 1 char for the null      * terminating char.      */tO     ep_name = (char *) (malloc (strlen (program_name) + strlen (pid_buf) + 2));           if (ep_name == NULL)     { +         if (mode & rpc_c_server_mode_debug) 	         {sJ             fprintf (stderr, "(%s) Unable to allocate memory - Exiting\n",                 program_name);	         }]'         local_status = rpc_s_no_memory;o         goto EXIT_HANDLER;     }*  6     sprintf (ep_name, "%s %s", program_name, pid_buf);     "     for (i = 0; i < if_count; i++)     { 8         if (! (mode & rpc_c_server_mode_no_if_register))	         {              /*6              * register the interface with the runtime              */ "             rpc_server_register_ifI                 (if_descriptors[i].if_handle, NULL, NULL, &local_status);   )             if (local_status != rpc_s_ok)s
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,K                         "(%s) Error in rpc_server_register_if - Exiting\n", &                         program_name);                 } "                 goto EXIT_HANDLER;
             }   0             if (mode & rpc_c_server_mode_verify)
             {c                  fprintf (stdout,I                     "(%s) Server interfaces registered\n", program_name);-
             }l	         }      
         /*9          * check the optional fields in the if descriptorr          */n)         if (if_descriptors[i].object_ids) 	         {r6             object_ids = if_descriptors[i].object_ids;	         }          else	         {m             object_ids = NULL;	         }   8         if (! (mode & rpc_c_server_mode_no_ep_register))	         { -             if (if_descriptors[i].annotation)a
             {p:                 annotation = if_descriptors[i].annotation;
             }e             else
             { %                 annotation = ep_name; 
             }e               /*?              * register the dynamic endpoints that were created               */rP             rpc_ep_register (if_descriptors[i].if_handle, server_binding_vector,K                 object_ids, (unsigned_char_t *)                                                                                                                                                                                                                                                    l                        2 $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                         "           annotation, &local_status);   )             if (local_status != rpc_s_ok) 
             { 3                 if (mode & rpc_c_server_mode_debug)                  { $                     fprintf (stderr,D                         "(%s) Error in rpc_ep_register - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }	  0             if (mode & rpc_c_server_mode_verify)
             {o                  fprintf (stdout,H                     "(%s) Server endpoints registered\n", program_name);
             }p	         }_            if (server_name != NULL)	         {              /*B              * export the server bindings to the directory service              */S#             rpc_ns_binding_export ( (                 rpc_c_ns_syntax_default,0                 (unsigned_char_t *) server_name,,                 if_descriptors[i].if_handle,&                 server_binding_vector,                 object_ids,                  &local_status);_  )             if (local_status != rpc_s_ok)r
             {(3                 if (mode & rpc_c_server_mode_debug)                  {e$                     fprintf (stderr,J                         "(%s) Error in rpc_ns_binding_export - Exiting\n",&                         program_name);                 } "                 goto EXIT_HANDLER;
             }w  0             if (mode & rpc_c_server_mode_verify)
             {                   fprintf (stdout,P                     "(%s) Server binding information exported\n", program_name);
             }t	         }      }*    
 EXIT_HANDLER:        /*8      * free the name used for the ep database annotation      */      if (ep_name != NULL)     {e         free (ep_name);      }        /*:      * free the binding vector, unless the caller wants it      */c?     if ((local_status == rpc_s_ok) && (binding_vector != NULL))p     {p-     	*binding_vector = server_binding_vector;o%         server_binding_vector = NULL;      }      else     { *         if (server_binding_vector != NULL)	         {rK             rpc_binding_vector_free (&server_binding_vector, &temp_status); 	         }e	     }       !     if (local_status != rpc_s_ok)_     {;
         /*>          * pass back the failure status if the caller wants it          */o         if (status)b	         {e#             *status = local_status;m	         }a         return (1);      }f       return (0);p }_ s /* **++) **  ROUTINE NAME:       rpc_server_detach* **9 **  SCOPE:              PRIVATE - declared in rpcserver.hs ** **  DESCRIPTION: **F **  Detach the server from the user terminal and (optionally) redirect$ **  stdout and stderr to a log file. ** **  INPUTS:t **6 **      program_name    The name of the server daemon.@ **      logfile_name    The full pathname of the server logfile.D **                      If NULL, no logfile will be created - stdoutC **                      and stderr will be redirected to /dev/null.  ** **  INPUT/OUTPUTS:      none ** **  OUTPUTS: **J **      status          The status of the operation. This will be rpc_s_okJ **                      if the operation succeeds. If the operation fails,L **                      it will either be rpc_s_ok, or some DCE error statusJ **                      providing specific information on the cause of the  **                      failure. ** **  IMPLICIT INPUTS:    none ** **  IMPLICIT OUTPUTS:   none **4 **  FUNCTION VALUE:     0 for success, 1 for failure ** **  SIDE EFFECTS:       none ** **-- */  B PRIVATE int rpc_server_detach (program_name, logfile_name, status)  & char                    *program_name;& char                    *logfile_name;  error_status_t          *status;   {      /*7      * if the caller wants output status, initialize itf      */t     if (status)t     {b         *status = rpc_s_ok;t     }   " #if defined(UNIX) || defined(unix)     {b$         int                     tty;)         FILE                    *logfile;g(         time_t                  systime;    
         /*F          * we must reassign stdout and stderr to files or we'll end upE          * spewing some random garbage into a random terminal at some           * random future time 
          *M          * do this before detaching the terminal, so we can report errors andd&          * exit if anything goes wrong          */i!         if (logfile_name != NULL) 	         { :             logfile = freopen (logfile_name, "a", stdout);                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }s
         }    &         else	         { 9             logfile = freopen ("/dev/null", "w", stdout);u                if (logfile == NULL)
             {                   fprintf (stderr,F                     "(%s) Unable to reassign program I/O - Exiting\n","                     program_name);                 return (1); 
             }g	         }   +         setvbuf (logfile, NULL, _IONBF, 0);            if ((dup2 (1,2)) == -1)*	         {s             fprintf (stderr,B                 "(%s) Unable to reassign program I/O - Exiting\n",                 program_name);             return (1); 	         }   
         /*(          * write a header to the logfile          */t         time (&systime);B         fprintf (stdout, "[%d] %s\n", getpid(), ctime (&systime));.                                               . #ifdef _BSD                                   .         if (setpgrp(0, getpid()) < 0) {       .             fprintf (stderr,                  H                 "(%s) Unable to create a new process group - Exiting\n",.                 program_name);                .             return(1);                        .         }                                     .                                               .         if (setreuid (0,0) < 0) {             .             fprintf (stderr,                  ;                 "(%s) Unable to set uids to 0 - Exiting\n",i.                 program_name);                .             return(1);                        .         }                                     .                                               
         /*&          * detach from controlling tty          */ 3         if ((tty = open ("/dev/tty", O_RDWR)) >= 0) 	         { /             ioctl (tty, TIOCNOTTY, (char *) 0);i             close (tty);         }                                     #else                          if (setsid() < 0) {&             fprintf (stderr,B                 "(%s) Unable to set process group id - Exiting\n",                 program_name);             return(1);         }                      if (setuid(0) < 0) {             fprintf (stderr,:                 "(%s) Unable to set uid to 0 - Exiting\n",                 program_name);             return(1);         }              #endif                  
         /*M          * inform the parent that we're ready to process requests (by closing_7          * the pipe, and causing the parent to wake up)           */(%         close (parent_child_pipe[1]);      }  #endif       return (0);  }                                                                                                                                              * [RPCBOOK.SRC]RPCSERVER.H;2 +  , Lv   .     /  @   4 >                          - 1   0   1    2   3      K  P   W   O     5   6 Fyw>  7   8          9          G  @  H  J $ N                   ?                            #ifndef RPCSERVER_H
#define RPCSERVER_H
/*
**  Copyright (c) 1991 by
**      Digital Equipment Corporation, Maynard, Mass.
**
**  %a%copyright(,**  )
**
**  NAME:
**
**      rpcserver.h
**
**  FACILITY:
**
**      DCE RPC
**
**  ABSTRACT:
**
**      Useful RPC server utility functions.
**
**  %a%private_begin
**
**  MODIFICATION HISTORY: 
** 
**  23-feb-92 sudama    add no_privilege flag to mode argument
**  19-feb-92 sudama    add output status
**  23-jan-92 sudama    add ep register options
**  29-dec-91 sudama    original creation
**
**  %a%private_end  
**
*/

#include <dce/rpc.h>
#ifndef PROTOTYPE
#   if defined(__STDC__)
#       define PROTOTYPE(x) x
#   else
#       define PROTOTYPE(x) ()
#   endif
#endif

#ifndef EXTERNAL
#define EXTERNAL extern
#endif

#ifndef GLOBAL
#define GLOBAL
#endif

#ifndef PUBLIC
#define PUBLIC
#endif

#ifndef PRIVATE
#define PRIVATE
#endif

#ifndef INTERNAL
#define INTERNAL static
#endif

#ifdef                                                                                                                                                                                                                                                   m                        ˰ $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                        8 "     %       GLOBALDEFS
#define IMPEXP
#else
#define IMPEXP extern
#endif

#define rpc_c_server_mode_debug             1
#define rpc_c_server_mode_verify            2
#define rpc_c_server_mode_no_if_register    4
#define rpc_c_server_mode_no_ep_register    8
#define rpc_c_server_mode_no_privilege      16

typedef struct
{
    rpc_if_handle_t     if_handle;
    uuid_vector_p_t     object_ids;
    char                *annotation;
} rpc_if_descriptor_t, *rpc_if_descriptor_p_t;


PRIVATE int rpc_server_init
    PROTOTYPE ((
        char                    *program_name,
        char                    *server_name,
        unsigned int            if_count,
        rpc_if_descriptor_p_t   if_descriptors,
        unsigned int            mode,
	rpc_binding_vector_p_t  *binding_vector,
        error_status_t          *status
    ));

PRIVATE int rpc_server_detach
    PROTOTYPE ((
        char                    *program_name,
        char                    *logfile_name,
        error_status_t          *status
    ));

#endif
                                                                                               * [RPCBOOK.SRC]RPCSERVER.H;1 +  ,    .     /  @   4 >                          - 1   0   1    2   3      K  P   W   O     5   6 Fyw>  7 Pb  8          9          G  @  H  J $ N                   ?                            #ifndef RPCSERVER_H
#define RPCSERVER_H
/*
**  Copyright (c) 1991 by
**      Digital Equipment Corporation, Maynard, Mass.
**
**  %a%copyright(,**  )
**
**  NAME:
**
**      rpcserver.h
**
**  FACILITY:
**
**      DCE RPC
**
**  ABSTRACT:
**
**      Useful RPC server utility functions.
**
**  %a%private_begin
**
**  MODIFICATION HISTORY: 
** 
**  23-feb-92 sudama    add no_privilege flag to mode argument
**  19-feb-92 sudama    add output status
**  23-jan-92 sudama    add ep register options
**  29-dec-91 sudama    original creation
**
**  %a%private_end  
**
*/

#include <dce/rpc.h>
#ifndef PROTOTYPE
#   if defined(__STDC__)
#       define PROTOTYPE(x) x
#   else
#       define PROTOTYPE(x) ()
#   endif
#endif

#ifndef EXTERNAL
#define EXTERNAL extern
#endif

#ifndef GLOBAL
#define GLOBAL
#endif

#ifndef PUBLIC
#define PUBLIC
#endif

#ifndef PRIVATE
#define PRIVATE
#endif

#ifndef INTERNAL
#define INTERNAL static
#endif

#ifdef GLOBALDEFS
#define IMPEXP
#else
#define IMPEXP extern
#endif

#define rpc_c_server_mode_debug             1
#define rpc_c_server_mode_verify            2
#define rpc_c_server_mode_no_if_register    4
#define rpc_c_server_mode_no_ep_register    8
#define rpc_c_server_mode_no_privilege      16

typedef struct
{
    rpc_if_handle_t     if_handle;
    uuid_vector_p_t     object_ids;
    char                *annotation;
} rpc_if_descriptor_t, *rpc_if_descriptor_p_t;


PRIVATE int rpc_server_init
    PROTOTYPE ((
        char                    *program_name,
        char                    *server_name,
        unsigned int            if_count,
        rpc_if_descriptor_p_t   if_descriptors,
        unsigned int            mode,
	rpc_binding_vector_p_t  *binding_vector,
        error_status_t          *status
    ));

PRIVATE int rpc_server_detach
    PROTOTYPE ((
        char                    *program_name,
        char                    *logfile_name,
        error_status_t          *status
    ));

#endif
                                                                                              * [RPCBOOK.SRC]SERVER.SH;1 +  , ).   .     /  @   4 t       <                   - 1    0   1    2   3      K  P   W   O     5   6 N>`  7 (td`  8          9          G  @  H  J $ N                   ?              # Shell to check credentials and establish enviromental for the Book Server.  Burgher
# 19-Oct-1993 FWB Modified for dce_login executable & to insure dce_login was performed before server is invoked
#
CREDS=`show_log KRB5CCNAME |grep FILE`
#echo "CREDS = $CREDS"
if [ -z "$CREDS" ]
then
        echo " dce_login must be run first: Use a principal with registry group membership in subsys/dce/cds-server"
        echo " OR use the cell_admin principal:"
        exit 1
fi
trap 'while true
do 
break
done' INT QUIT TERM EXIT
bookd -v
echo "\n"
echo "Book  Server exiting"
#
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 n                         $      DCEAXPMUPA013.A                ;  ?  ([SYSHLP.EXAMPLES.DCE.RPC.BOOK]BOOK.SAV;2                                                                                         ~   ~<                              6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   & * [SYSHLP.EXAMPLES.DCE.RPC]MATRIX1.DIR;1 +  , 8   .     /  @   4                            - 5    0   1    2   3     K  P   W   O     5   6 !   7 xȻ   8          9          G  @  H   J  I                     MATRIX1.SAV  :                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     . * [SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1 +  , :   .     /  @   4   ~           ~               - 8    0   1    2   3      K  P   W   O     5   6 O}i?  7     8          9          G  @  H   J                                             |^ ~      MATRIX1.SAV                                                                                                                                                                                                  >                MATRIX1.SAV6  BACKUP SRC$:*.* OBJ$:MATRIX1.SAV/SAVE_SET/GROUP_SIZE=0  GBDBUILD       @    Mh?      V5.5	 	 _OPENUP:: 
  
  _$2$DIA24:  V5.5-2 
  ~        8                   * [RPCMATRIX1.SRC]CHECK_STATUS.H;1 +  , |H   .     /  @   4 ?       E                    - (    0   1    2   3      K  P   W   O     5   6  $؇  7 ^  8          9 @,  G  @  H  J $ N                   ?                      /* FILE NAME: check_status.h */
/* Contains error checking macro */

#include <iostream.h>
#include <stdlib.h>
#include <dce/dce_error.h>
#include <dce/pthread.h>
#include <dce/rpcexc.h>

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
    if (input_status != rpc_s_ok) { \
	dce_error_inq_text(input_status, error_string, &error_stat); \
	cerr << comment << " " << (char *) error_string; \
	if (action == ABORT) \
	    exit(1); \
    } \
}

static int	error_stat;
static unsigned char error_string[dce_c_error_string_len];
void exit();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [RPCMATRIX1.SRC]CLIENT.CXX;1 +  , H	   .     /  @   4 I                          - (    0   1    2   3      K  P   W   O 	    5   6 ʠ쭚  7 E菝  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: client.cxx */
/* This file contains the client application */

#include <iostream.h>

#include "matrix.h"		// IDL generated header file
#include "globals.h"		// Contains names used by the application
#include "check_status.h"	// Error checking macro

// Function Declarations

inline void print(Matrix *m);	// Prints a matrix to stdout

int
main()
{
	idl_long_int		d1, d2, d3, d4;
	Matrix			*m1, *m2, *m3;
	uuid_t			objectID;
	unsigned32              status;
	rpc_binding_handle_t	binding_handle;

	d1 = 1; d2 = 2; d3 = 3; d4 = 4;

	// show how dynamic objects are created
	cout << "creating dynamic objects" << endl;

	// create a remote matrix on a server using a 
	// static member function and auto handle
	m1 = Matrix::newMatrix(d1, d2, d3, d4);
	cout << "m1 created by a static member function:" << endl;
	print(m1);
	delete m1;

	// create a remote matrix on a server using a different
	// static member function and auto handle
	m1 = Matrix::createMatrix(d1, d2, d3, d4);
	cout << "m1 created by a static member function:" << endl;
	print(m1);
	delete m1;

	// create a remote matrix on a server using a 
	// matrix creator member function and auto handle
	m1 = Matrix::new2x2(d1, d2, d3, d4);
	cout << "m1 created by a object creator function:" << endl;
	print(m1);
	delete m1;

	cout << "***********************************************************\n";

	// show how to bind to named objects
	cout << "binding to named objects" << endl;

	// bind to a named object by name
	m1 = Matrix::bind((unsigned_char_t *) IdentityMatrixName);
	cout << "Identity Matrix (bind-by-name):" << endl;
	print(m1);

	// convert the IdentityBH literal to a binding handle
	rpc_binding_from_string_binding(
		(unsigned_char_t *) IdentityBH,
		&binding_handle,
		&status
	);
	CHECK_STATUS(status, "Can't convert binding from string:", ABORT);

	// bind to a named object by binding handle
	m1 = Matrix::bind(binding_handle);
	cout << "Identity Matrix (bind-by-handle):" << endl;
	print(m1);

	// convert the IdentityMatrixId literal to a uuid_t
	uuid_from_string(
		(unsigned_char_t *) IdentityMatrixId,
		&objectID,
		&status
	);
	CHECK_STATUS(status, "Can't convert uuid from string:", ABORT);

	// bind to a named object by uuid
	// search starts with RPC_DEFAULT_ENTRY in the name space
	m1 = Matrix::bind(objectID);
	cout << "Identity Matrix (bind-by-uuid):" << endl;
	print(m1);

	cout << "***********************************************************\n";

	// show how to u                                                                                                                                                                                   o                        e $      DCEAXPMUPA013.A                :  8  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                          "     
       se interface operations
	cout << "testing interface operations" << endl;

	// create a remote matrix with a creator function
	m1 = Matrix::new2x2(d1, d2, d3, d4);
	cout << "m1:" << endl;
	print(m1);

	// set an element to a value - operation occurs remotely
	m1->set(1, 1, 10);
	cout << "m1 after setting m1[1][1] = 10:" << endl;
	print(m1);

	// creates another remote matrix using m1
	m2 = m1->invert();
	cout << "m2 (inverion of m1):" << endl;
	print(m2);

	// creates another remote matrix while accessing the remote m1
	m3 = m1->multiply(m2);
	cout << "product of m1 and m2:" << endl;
	print(m3);

	delete m1, m2, m3;

	cout << "client exiting" << endl;

	return 0;
}

//
// This functions prints a matrix to stdout.
// It accesses the matrix transparently whether the
// actual object is local or remote using the matrix interface
//

inline void
print(Matrix *m) {
	cout << "    [" << m->get(0,0) << "," << m->get(0,1) << "]" << endl;
	cout << "    [" << m->get(1,0) << "," << m->get(1,1) << "]" << endl;
	cout << endl;
}
                                                                                          * [RPCMATRIX1.SRC]DESCRIP.MMS;1 +  , H
   .     /  @   4 E       U                   - (    0   1    2   3      K  P   W   O     5   6  qY  7 xL"  8          9 @,  G  @  H  J $ N                   ?                         ! FILE NAME: descrip.mms
! Makefile for the matrix application

.SUFFIXES .obj .cxx .h

APPL=matrix
IDL=idl
IDLFLAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS= /NOLIST/G_FLOAT
DCELIBS=dce.opt/opt

!
! cxx compiler rule
!
.cxx.obj
	$(CXX) $(CXXFLAGS) /INCLUDE=([],DCE:) $(MMS$SOURCE)

all : client.exe server.exe
	@ write SYS$OUTPUT "Done."

clean :  
	@- delete *.obj;*,*_%stub.c*;*,$(APPL).h;*,client.exe;*,server.exe;*

client.exe : client.obj $(APPL)_cstub.obj $(APPL)_sstub.obj \
		matrixmgr.obj statics.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) client.obj, $(APPL)_cstub.obj, \
	 $(APPL)_sstub.obj, matrixmgr.obj, statics.obj, $(DCELIBS) 

server.exe : server.obj matrixmgr.obj statics.obj \
		$(APPL)_sstub.obj $(APPL)_cstub.obj
	- link $(LINKFLAGS) $(CXXLFLAGS) server.obj, matrixmgr.obj, \
	 statics.obj, $(APPL)_sstub.obj, $(APPL)_cstub.obj, $(DCELIBS)


client.obj : client.cxx $(APPL).h
server.obj : server.cxx $(APPL).h

csetup :
	@ define/job RPC_DEFAULT_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical RPC_DEFAULT_ENTRY

ssetup :
	@ define/job EXAMPLE2_SERVER_ENTRY \
		"/.:/example2_''f$edit(f$getsyi("NODENAME"),"LOWERCASE")'"
	@ show logical EXAMPLE2_SERVER_ENTRY

! Stubs, auxiliary and header file from the IDL file

$(APPL).h $(APPL)_cstub.o $(APPL)_sstub.o : $(APPL).idl $(APPL).acf
	$(IDL) $(IDLFLAGS) $(APPL).idl
                                                                                                                                                                                          * [RPCMATRIX1.SRC]GLOBALS.H;1 +  , H   .     /  @   4 D       `                   - (    0   1    2   3      K  P   W   O     5   6  Sd  7 U  8          9 @,  G  @  H  J $ N                   ?                           // FILE NAME: globals.h
// This file defines some of the information for 
// registering and binding to a named Matrix object.

#define IdentityMatrixName "/.:/objects/identityMatrix"
#define IdentityMatrixId   "dcea4900-65ba-11cd-bb34-08002b3d8412"
#define IdentityBH         IdentityMatrixId "@ncacn_ip_tcp:" NETADDR

extern Matrix * IdentityMatrix;
                                                                                                                                                                               * [RPCMATRIX1.SRC]LOOKUP.CXX;1 +  , H	   .     /  @   4 C                          - (    0   1    2   3      K  P   W   O     5   6 -  7 O  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: lookup.cxx */
/* This file contains the server lookup callout function */
/* specified by the [cxx_lookup] attribute. It is called */
/* whenever an object cannot be found within             */
/* the DCE runtime.                                      */

#include "matrixmgr.h"
#include "globals.h"
#include "check_status.h"

// The gloable Identity Matrix
Matrix *IdentityMatrix = new MatrixMgr(1, 0, 0, 1);

//
// This functions performs the server management of object lookups.
// If the uuid_t parameter identifies the Identity Matrix,
// this function returns its interface.
//

Matrix *
server_lookup(uuid_t *uuid_p)
{
	signed32 notIdentityID;
	unsigned32 status;
	uuid_t	identityUuid;

	uuid_from_string(
		(unsigned_char_t *) IdentityMatrixId,
		&identityUuid,
		&status
	);
	CHECK_STATUS(status, "Can't convert uuid from string:", ABORT);

	notIdentityID = uuid_compare(
				uuid_p,
				&identityUuid,
				&status
	);
	CHECK_STATUS(status, "Can't compare uuids:", ABORT);

	// if not the Identity Matrix uuid, return 0
	if (notIdentityID)
		return 0;

	// register the Identity Matrix with the run time
	// so that future references will find it and not
	// call this function.
	//
	// The second parameter defaults to TRUE 
	// but is shown here to be explicit.

	IdentityMatrix->register_named_object(
		(unsigned_char_t *) IdentityMatrixName,
		TRUE
	);

	return IdentityMatrix;
}
                                                                                                                                                * [RPCMATRIX1.SRC]LOOKUP.H;1 +  , H   .     /  @   4 /                           - (    0   1    2   3      K  P   W   O     5   6  p<  7 f娘  8          9          G  @  H  J $ N                   ?                            // FILE NAME: lookup.h
// This file declares the lookup function used 
// for server management of object lookup.

Matrix *server_lookup(uuid_t *);
                                                                                                                                                                                                                                                                                                                                                                                           * [RPCMATRIX1.SRC]MAKEFILE.;1 +  , H
   .     /  @   4 L                          - (    0   1    2   3      K  P   W   O     5   6 ?
F?  7 F?  8          9          G  @  H  J $ N                   ?                           # FILE NAME: Makefile
# Makefile for the matrix1 application

.SUFFIXES: .o .cxx .h

APPL=matrix

DCL_IDL= dcl mcr dce\$$idl
IDL=$(DCL_IDL)
IDLFLAGS=-lang cxx -keep both
CXX=cxx
CXXFLAGS=-c -I. -D NETADDR='"$(netaddr)"'
#LDFLAGS=-call_shared 
#DCELIBS=-L/usr/proj/rpc/nck/uxalpha_o -lnidl -ldce -lpthreads -lc_r -lmach 
OPTFILE=/vms/sys0/syscommon/dce\$$library/dce_cxx.opt
#
# cxx compiler rule
#
.cxx.o: 
	$(CXX) $(CXXFLAGS) $<

all: client server
	@ echo Done.

clean:
	@- rm *.o *.obj *_?stub.cxx* ${APPL}.h client server

cleancds:
	rpccp remove entry /.:/objects/identityMatrix
	cdscp delete directory /.:/objects

client: client.o ${APPL}_cstub.obj
	${CXX} $(LDFLAGS) -o client client.o \
 		${APPL}_cstub.obj \
		$(OPTFILE) 

server: server.o ${APPL}_sstub.obj lookup.o matrixmgr.o
	${CXX} $(LDFLAGS) -o server server.o lookup.o matrixmgr.o \
		${APPL}_sstub.obj \
		$(OPTFILE)

client.o: ${APPL}.h client.cxx
server.o: ${APPL}.h server.cxx
lookup.o: lookup.cxx
matrixmgr.o: matrixmgr.cxx

# Stubs and header file from the IDL file

${APPL}.h ${APPL}_cstub.obj ${APPL}_sstub.obj : ${APPL}.idl ${APPL}.acf
	$(IDL) $(IDLFLAGS) ${APPL}.idl -I$(DCEINC) 

cds:
	echo "exporting a CDS entry"
	-@ cdscp create directory /.:/objects
	-@ rpccp export \
		-o dcea4900-65ba-11cd-bb34-08002b3d8412 \
		-i d784B260-B5DB-11CB-832C-08002B2A1BCA \
		-b ncacn_ip_tcp:$(netaddr) \
		-b ncadg_ip_udp:$(netaddr) \
		/.:/objects/identityMatrix

                                                                                                                       * [RPCMATRIX1.SRC]MATRIX.ACF;1 +  , H   .     /  @   4                          - (    0   1    2   3      K  P   W   O     5   6 hc  7 ?R簥  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.acf */
/* This file defines                                                                                                                                                                                                                                                   p                        VU $      DCEAXPMUPA013.A                :  8  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         2 "             some attributes for the matrix interface */

[
    cxx_lookup(server_lookup)  /* server lookup function for object management*/
]
interface Matrix
{
	/* include files generated into the server stub */
	[sstub] include "matrixmgr", "lookup";

    	/* new2x2 should be mapped as a creator */
	[cxx_new(MatrixMgr)] new2x2 ();

	/* createMatrix is a static function */
	[cxx_static] createMatrix ();
}
                                                                                * [RPCMATRIX1.SRC]MATRIX.COM;1 +  , H   .     /  @   4 N                          - (    0   1    2   3      K  P   W   O 	    5   6 hUE  7 =CUE  8          9          G  @  H  J $ N                   ?                          $!
$!                      COPYRIGHT (C) 1995 BY
$!                 DIGITAL EQUIPMENT CORPORATION, MAYNARD
$!                  MASSACHUSETTS.  ALL RIGHTS RESERVED.
$!
$! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$! ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$! OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$! THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$! PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
$!
$! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$! SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$!
$! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$! SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$!
$! Abstract:
$!	Matrix.Com    Builds the Matrix1 example program and sets up the
$!                    necessary definitions in rpccp and cdscp.
$!
$!             Input: The network address of the server.
$!
$! Modification History:
$!	12-Jan-1995 CKe Created for VMS DCE V1.3
$!
$!
$ if( p1 .eqs. "CLEAN" ) then goto cleanup
$!
$! Check that symbol 'netaddr' is defined for the other functions.
$!
$ if( f$type( netaddr ) .eqs. "" ) 
$    then
$    read/prompt="Enter the IP address of the server: " sys$command netaddr
$    endif 
$!
$ if( p1 .eqs. "CLIENT" ) then goto do_client
$ if( p1 .eqs. "SERVER" ) then goto do_server
$ if( p1 .eqs. "SETUP" ) then goto setup_env
$!
$!  Run the idl compiler to generate the *.h and the *stubs.
$!
$ idl  -lang cxx -keep both matrix.idl
$!
$!  Build the client 
$!
$do_client:
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
      /INCLUDE=(DCE:) CLIENT.CXX
$ link/TRACE/NOMAP/EXEC=CLIENT.EXE  client.obj, matrix_cstub.obj, -
      dce:dce_cxx.opt/opt 
$ write sys$output "Client done."
$!
$! Build the server
$!
$do_server:
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
					/INCLUDE=([],DCE:) SERVER.CXX
$ cxx /NOLIST/G_FLOAT/DEFINE=(NETADDR="""''netaddr'""") -
					/INCLUDE=([],DCE:) LOOKUP.CXX
$ cxx /NOLIST/G_FLOAT/INCLUDE=([],DCE:)			   MATRIXMGR.CXX
$ link/TRACE/NOMAP/EXEC=SERVER.EXE server.obj, matrix_sstub.obj, lookup.obj, -
       matrixmgr.obj, dce:dce_cxx.opt/opt
$ 
$ write SYS$OUTPUT "Server Done."
$ exit
$!
$!  Setup the necessary definitions
$!
$setup_env:
$ set verify
$ on error then continue
$ cdscp create directory "/.:/objects"
$!
$ on error then continue
$ rpccp export -o dcea4900-65ba-11cd-bb34-08002b3d8412 -
               -i d784B260-B5DB-11CB-832C-08002B2A1BCA -
               -b "ncacn_ip_tcp:''netaddr'" - 
               -b "ncadg_ip_udp:''netaddr'" -
               "/.:/objects/identityMatrix"
$!
$ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix"
$ set noverify
$ exit
$!
$! Remove definitions from enviromnent
$! 
$cleanup:
$ set verify
$ on error then continue
$ rpccp remove entry "/.:/objects/identityMatrix"
$ on error then continue  
$ cdscp delete directory "/.:/objects"	
$ set noverify
$ exit
                                                   * [RPCMATRIX1.SRC]MATRIX.IDL;1 +  , I   .     /  @   4                           - (    0   1    2   3      K  P   W   O     5   6  c  7 )@  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: matrix.idl */
/* This file contains the interface definition for a Matrix object */

[
    uuid(D784B260-B5DB-11CB-832C-08002B2A1BCA)
]
interface Matrix
{
    /* Create a 2x2 matrix with a static member function */
    static Matrix * newMatrix(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Create a 2x2 matrix with a static member function */
    Matrix * createMatrix(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Create a 2x2 matrix with a dynamic creator function */
    Matrix * new2x2(
	[in] long & v11,
	[in] long & v12,
	[in] long & v21,
	[in] long & v22
    );

    /* Set a new value in the matrix */
    void set(
	[in] long row,
	[in] long col,
	[in] long  value
    );

    /* Get a value from the matrix */
    long  get(
	[in] long row,
	[in] long col
    );

    /* Return a new matrix which is the inversion of the matrix */
    Matrix * invert();

    /* Return a new matrix which is the product of the matrix and m1 */
    Matrix * multiply(
	[in] Matrix * m1
    );

    /* Return in m2 the sum of the matrix and m1 */
    void add(
	[in] Matrix * m1,
	[out] Matrix ** m2
    );

}
                                                                                                                                                                                                                                                                                                                                                                 * [RPCMATRIX1.SRC]MATRIXMGR.CXX;1 +  , I   .     /  @   4                           - (    0   1    2   3      K  P   W   O     5   6 c  7 X(  8          9 @,  G  @  H  J $ N                   ?                       // FILE NAME: matrixmgr.cxx
// This file contains the implemenation of a MatrixMgr class
// which supports the IDL-generated Matrix interface.

#include "matrixmgr.h"

// Constructor 
MatrixMgr::MatrixMgr(idl_long_int v1, idl_long_int v2,
                     idl_long_int v3, idl_long_int v4)
{
	d[0][0] = v1;
	d[0][1] = v2;
	d[1][0] = v3;
	d[1][1] = v4;
}

// Destructor for new2x2
MatrixMgr::~MatrixMgr(void)
{
	return;
}

// Sets the matrix element to value
void
MatrixMgr::set(idl_long_int row, idl_long_int col, idl_long_int value)
{
	d[row][col] = value;
}

// Returns an element from the matrix 
idl_long_int
MatrixMgr::get(idl_long_int row, idl_long_int col)
{ 
	return d[row][col];
}

// Returns a new inverted matrix built from this
Matrix *
MatrixMgr::invert(void){
	return new MatrixMgr(d[1][1],d[1][0],d[0][1],d[0][0]);
}

// Returns the product of this and the parameter
Matrix *
MatrixMgr::multiply(Matrix *m)
{
	Matrix *newp = new MatrixMgr(0,0,0,0);

	for (int i = 0; i < 2; i++) {
	    for (int j = 0; j < 2; j++) {
		idl_long_int s = 0;
		for (int k = 0; k < 2; k++) {
		    s += get(i, k) * m->get(k, j);
		}
		newp->set(i, j, s);
	    }
	}
	return newp;
}
      
// Returns the sum of this and m1 in m2
void
MatrixMgr::add(Matrix *m1, Matrix **m2)
{
	*m2 =  new MatrixMgr(
			d[0][0] + m1->get(0, 0),
			d[0][1] + m1->get(0, 1),
			d[1][0] + m1->get(1, 0),
			d[1][1] + m1->get(1, 1)
	);
    	return;
}
      
Matrix *
Matrix::createMatrix(idl_long_int &v11, idl_long_int &v12,
                     idl_long_int &v21, idl_long_int &v22)
{
	return new MatrixMgr(v11, v12, v21, v22);
}
      
Matrix *
Matrix::newMatrix(idl_long_int &v11, idl_long_int &v12,
                  idl_long_int &v21, idl_long_int &v22)
{
	return new MatrixMgr(v11, v12, v21, v22);
}
                                                                                                                                                                                                                                                                                          * [RPCMATRIX1.SRC]MATRIXMGR.H;1 +  , I   .     /  @   4                          - (    0   1    2   3      K  P   W   O     5   6 c  7 c  8          9 @,  G  @  H  J $ N                   ?                         // FILE NAME: matrixmgr.h
// This file contains the implemenation of a Matrix class

#ifndef matrix_mgr_h
#define matrix_mgr_h

#include "matrix.h"

// Local Implementation of a 2x2 Matrix

class MatrixMgr : public Matrix {
    private:
	idl_long_int d[2][2];		//  actual data

    public: 
	// Construct                                                                                                                                                                                                                                                   q                        `i! $      DCEAXPMUPA013.A                :  8  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         s "     ,       or for new2x2
        MatrixMgr(idl_long_int v1, idl_long_int v2,
                  idl_long_int v3, idl_long_int v4);

	// Destructor for new2x2
	~MatrixMgr(void);

	// Static function to create a new matrix
        static Matrix * newMatrix(idl_long_int &, idl_long_int &,
                                  idl_long_int &, idl_long_int &);

	// Static function to create a new matrix
        static Matrix * createMatrix(idl_long_int &, idl_long_int &,
                                     idl_long_int &, idl_long_int &);

	// Sets the matrix element to value
	void set(idl_long_int row, idl_long_int col, idl_long_int value);

	// Returns an element from the matrix 
	idl_long_int get(idl_long_int row, idl_long_int col);

	// Returns a new inverted matrix built from this
	Matrix * invert(void);

	// Returns the product of this and the parameter
	Matrix * multiply(Matrix *m);
      
	// Returns the sum of this and m1 in m2
	void add( Matrix *m1, Matrix **m2);
};

#endif
                                                                                                                                                                                                                                                                            * [RPCMATRIX1.SRC]README.TXT;1 +  ,  I   .     /  @   4 N      
 J                    - (    0   1    2   3      K  P   W   O     5   6 hDEI  7 HwFI  8          9          G  @  H  J $ N                   ?                               			COPYRIGHT (C) 1995 BY7                  DIGITAL EQUIPMENT CORPORATION, MAYNARD 6                   MASSACHUSETTS.  ALL RIGHTS RESERVED.  F  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIEDI  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION B  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIESE  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER J  PERSON.  NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.  I  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND J  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.  D  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS7  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.   K   _________________________________________________________________________ 3                 OBJECT-ORIENTED RPC TEST PROGRAM #1   B   This example implements a 2x2 matrix in a server application andD   allows the client application to manipulate the matrix with an IDL5   interface. The following features are illustrated:      > - server advertizes a named object with the DCE Naming service  8 - server provides a callout for object lookup management  A - server provides a creator function for creating dynamic objects   C - server provides two static functions for creating dynamic objects   7 - client binds to the named object three different ways   C - client creates dynamic objects using the object creator operation   K - client creates dynamic objects using the static member function operation       * HOW TO BUILD THE APPLICATION UNDER OpenVMS* ------------------------------------------  C Copy files from the DCE examples directory to your local directory.   %    $ set default mydisk:[mydirectory] <    $ copy sys$common:[syshlp.examples.dce.rpc.matrix1]*.* []  = To build the application, first define the symbol netaddr to  E be the network address of the server, then run the command procedure:   "    $ netaddr = "<network-address>"    $ @matrix  @    or if you have MMS you can use the description file included:  +    $  MMS/MACRO=NETADDR="<network-address>"      TO RUN THE APPLICATION  F The server advertizes a named object with the Naming service using theC name defined by the IdentityMatrix literal defined in the globals.h F header file. In order for the client to bind to this object using onlyF the object's uuid, the RPC_DEFAULT_ENTRY must be set to this name. The server is run as follows:  				     $ dce_login      $ @matrix clean      $ @matrix setup	     $ run server       or using the mms script:       $ dce_login      $ mms cleancds
     $ mms cds :     $ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix     $ run server  H The advertized object is associated with a specific object uuid as notedB by the IdentityMatrixId literal. In order to reuse the same objectF uuid consistently, an entry with the object uuid and interface uuid isG explicitly exported to the name service. The following commands perform 4 this task and are included in the command procedure:  )      $ cdscp create directory /.:/objects       $ rpccp export \e5            -o dcea4900-65ba-11cd-bb34-08002b3d8412 \e 5            -i d784B260-B5DB-11CB-832C-08002B2A1BCA \e )            -b ncacn_ip_tcp:16.31.48.49 \e )            -b ncadg_ip_udp:16.31.48.49 \e (               /.:/objects/identityMatrix   Run the client as follows:  ;     $ define RPC_DEFAULT_ENTRY "/.:/objects/identityMatrix"      $ run client    ( HOW TO BUILD THE APPLICATION UNDER POSIX( ----------------------------------------  H Copy the files from the DCE examples directory to your Posix accessible 
 directory.      psx> cd /mydev/mydir 8    psx> copy /usr/dce/examples/gde_dce_apps/matrix1/*  .  5 To build the application, run the following commands:   )   psx> export netaddr="<network_address>"    psx> make      TO RUN THE APPLICATION  F The server advertizes a named object with the Naming service using theC name defined by the IdentityMatrix literal defined in the globals.h F header file. In order for the client to bind to this object using onlyF the object's uuid, the RPC_DEFAULT_ENTRY must be set to this name. The server is run as follows:       psx> dce_login     psx> make cds<    psx> def_log RPC_DEFAULT_ENTRY=/.:/objects/identityMatrix    psx> server  H The advertized object is associated with a specific object uuid as notedB by the IdentityMatrixId literal. In order to reuse the same objectF uuid consistently, an entry with the object uuid and interface uuid isG explicitly exported to the name service. The following commands perform , this task and are included in the make file:A                                                                     '      cdscp create directory /.:/objects       rpccp export \ 0        -o dcea4900-65ba-11cd-bb34-08002b3d8412 \0        -i d784B260-B5DB-11CB-832C-08002B2A1BCA \$        -b ncacn_ip_tcp:16.31.48.49 \$        -b ncadg_ip_udp:16.31.48.49 \$           /.:/objects/identityMatrix   Run the client as follows:  <    psx> def_log RPC_DEFAULT_ENTRY=/.:/objects/identityMatrix    psx> client     APPLICATION FILES: ------------------   descrip.mms < Contains the description of how the application is compiled.  
 matrix.idl/ Contains the interface definition for a matrix.   
 matrix.acf5 Contains the attributes for the interface definition.   
 matrix.com  Builds the application from DCL.  	 globals.h 5 Defines some global literals used by the application.    matrixmgr.h N Contains the class definition of a 2x2 matrix supporting the Matrix interface.  
 matrixmgr.cxx L Contains the implementation of a 2x2 matrix supporting the Matrix interface.  
 client.cxx6 Illustrates several ways to manipulate remote objects.  
 server.cxxM Initializes the server and advertises a named object with the Naming service.    lookup.hE Declares the function prototype for a server object lookup operation.   
 lookup.cxx? Returns a reference to the 2x2 identity matrix if the parameter : specifies the proper object uuid. Otherwise, returns zero.   check_status.h8 Defines an error checking macro used by the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   * [RPCMATRIX1.SRC]SERVER.CXX;1 +  , $I   .     /  @   4 L                          - (    0   1    2   3      K  P   W   O 	    5   6 :%  7 J  8          9 @,  G  @  H  J $ N                   ?                          /* FILE NAME: server.cxx */
/* This is the server module of the matrix application. */

#include <iostream.h>

#include "matrixmgr.h"
#include "globals.h"
#include "check_statu                                                                                                                                                                                                                                                   r                        1uF $      DCEAXPMUPA013.A                :  8  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         A "     =       s.h"

// Function Declarations

void advertizeAnObject();    // advertizes an object with the naming service

int
main()
{
	error_status_t		status;
	rpc_binding_vector_p_t	binding_vector;
	char			*entry_name;

	// create some binding handles
	rpc_server_use_all_protseqs(
  		rpc_c_protseq_max_reqs_default,
		&status
	);
	CHECK_STATUS(status, "Can't create binding information:", ABORT);

	// register the matrix interface - use the default epv
	rpc_server_register_if(
		Matrix_v0_0_s_ifspec, 
		NULL,
		NULL,
  		&status
	);
	CHECK_STATUS(status, "Can't register interface:", ABORT);

	// get the binding vector
	rpc_server_inq_bindings(&binding_vector, &status);
	CHECK_STATUS(status, "Can't get binding information:", ABORT);

	// manage endpoints
	rpc_ep_register(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		(unsigned_char_t *) "Matrix Example 1 Server",
		&status
	);
	CHECK_STATUS(status, "Can't add address to the endpoint map:", ABORT);

	// advertise the server
	rpc_ns_binding_export(
		rpc_c_ns_syntax_default,
		(unsigned_char_t *) IdentityMatrixName,
		Matrix_v0_0_s_ifspec,
		binding_vector,
		NULL,
		&status
	);
	CHECK_STATUS(status, "Can't export to name service database:", ABORT);


	// advertize a named object
	advertizeAnObject();

	TRY
	    cout << "server is listening" << endl;
	    rpc_server_listen(5, &status);
	    CHE                                                                                                                                                                                                            ~      MATRIX1.SAV                    $I  (  [RPCMATRIX1.SRC]SERVER.CXX;1                                                                                                   L                              /<             CK_STATUS(status, "rpc listen failed:", ABORT);
	FINALLY
	    rpc_server_inq_bindings(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't get binding information:", ABORT);

	    rpc_ep_unregister(
		Matrix_v0_0_s_ifspec, 
		binding_vector,
		NULL, 
		&status
	    );
	    CHECK_STATUS(status, "Can't unregister endpoint:", ABORT);

	    rpc_binding_vector_free(&binding_vector, &status);
	    CHECK_STATUS(status, "Can't free binding vector:", ABORT);

	    cout << "server exiting" << endl;

	ENDTRY

	return 0;
}

//
// This function advertizes the Identity Matrix name with the name service.
// It does NOT register the object with the run time.
// The server object lookup management routine will do that after it
// is referenced the first time.
//

void 
advertizeAnObject()
{
	// a FALSE second parameter causes just the name to
	// be advertised, but the object not registered.
	IdentityMatrix->register_named_object(
		(unsigned_char_t *) IdentityMatrixName,
		FALSE
	);
}
                                                * [RPCMATRIX1.SRC]STATICS.H;1 +  , *I
   .     /  @   4                           - (    0   1    2   3      K  P   W   O     5   6 ȓc  7 UX  8          9 @,  G  @  H  J $ N                   ?                           // FILE NAME: statics.h
// This file declares the static function to call 
// when invoking Matrix::createMatrix

Matrix *createMatrix(idl_long_int &, idl_long_int &,
                     idl_long_int &, idl_long_int &);
                                                                                                                                                                                                                                                                                                   u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 s                        u? $      DCEAXPMUPA013.A                :  8  .[SYSHLP.EXAMPLES.DCE.RPC.MATRIX1]MATRIX1.SAV;1                                                                                   ~   ~                         J "     N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 