/*
**
** vms_dir.h
**
** Copyright (C) 1995, 1996, 1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#ifndef	_VMS_DIR_H_
#define	_VMS_DIR_H_

#ifdef VMS

/* Make sure we get the definitons for the faulty DEC C library
   functions, so they can be savely overwritten afterwards ;-)
*/   
#include <types.h>

#define MAXNAMLEN 255
#if defined(__DECC) && (__CRTL_VER>70000000) 
#   include <dirent.h>
#endif

extern char *			getwd (
#if NeedFunctionPrototypes
#endif
);

struct  gv_dirent {
   char d_name[MAXNAMLEN+1];            /* name (up to MAXNAMLEN + 1)            */
};

typedef struct {
  unsigned long dd_fd;                  /* file descriptor for lib$find_file     */
  unsigned long dd_loc;                 /* lib$find_file stores the context here */
  struct gv_dirent *dd_buf;                /* -> directory buffer                   */
} gv_DIR;

extern gv_DIR *			gv_opendir (
#if NeedFunctionPrototypes
   char *dirname
#endif
);

extern struct gv_dirent *		gv_readdir (
#if NeedFunctionPrototypes
   gv_DIR *
#endif
);

extern int			gv_closedir (
#if NeedFunctionPrototypes
   gv_DIR *
#endif
);


#endif /* VMS */

#endif	/* _VMS_DIR_H_ */

