I {************************************************************************  *									* " *  JUMP -- JUMP_PERSONA.PAS						* *									* B *  JUMP_PERSONA implements the PERSONA system services to change	*" *  process characteristics.						* *									* I ************************************************************************* / *  Author and Maintainer: Jonathan Ridler.				*  *									* C *  This software is owned and maintained privately by the author,	* F *  Jonathan Ridler. It is NOT in any way produced, owned, supported,	*D *  maintained or endorsed by Hewlett Packard Pty Ltd or any of its	* *  legal entities.							* *									* ( *  Email: vmsjump@internode.on.net					*I ************************************************************************* I *************************************************************************  ***								      ***$ ***			    LICENCE NOTICE			      *** ***								      ***H ***  This software is COPYRIGHT (c) 1993-2012 Jonathan Ridler.	      ***' ***  ALL RIGHTS RESERVED.					      ***  ***								      ***G ***  Please READ the file JUMP_LICENCE.TXT which contains the	      *** C ***  complete Licence and all conditions of use for JUMP.	      ***  ***								      ***I ************************************************************************* I *************************************************************************  *									*  *  History:								*4 *	01-Feb-2012	JER	Original version for JUMP V6.0. 	*! *	03-Feb-2012	JER	JUMP V6.1.				* 8 *	21-Feb-2012	JER	JUMP V6.1a; added build level ident;	*( *				Fixed debug structure definition.	*I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',& 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES')]   MODULE Jump_Persona (OUTPUT) ;   CONST   L { The effective length of a username is 12 characters. However, the internalE   fields are 32 characters.  Use 12 characters as the maximum length.   K   ENSURE the constant is identical in the JUMP, JUMP_POKER and JUMP_PERSONA 
   modules!  }    Max_Username_Len = 12 ;    TYPE   $UWORD = [WORD] 0..65535 ;: $UQUAD = [QUAD,UNSAFE] RECORD  L0 , L1 : UNSIGNED ;  END ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;    Debug_Mask = RECORD  	       CASE INTEGER OF ? 	       1: (All_Bits : UNSIGNED ;) ;    { 32 bits - roomy! :) } C 	       2: (Info     : [BIT, POS(0)]  BOOLEAN ;	   { General Info } = 		   D1	    : [BIT, POS(1)]  BOOLEAN ;	   { Diagnostic info } = 		   D2	    : [BIT, POS(2)]  BOOLEAN ;	   { Diagnostic info } = 		   D3	    : [BIT, POS(3)]  BOOLEAN ;	   { Diagnostic info } = 		   D4	    : [BIT, POS(4)]  BOOLEAN ;	   { Diagnostic info } = 		   D5	    : [BIT, POS(5)]  BOOLEAN ;	   { Diagnostic info } = 		   D6	    : [BIT, POS(6)]  BOOLEAN ;	   { Diagnostic info } = 		   D7	    : [BIT, POS(7)]  BOOLEAN ;	   { Diagnostic info } = 		   D8	    : [BIT, POS(8)]  BOOLEAN ;	   { Diagnostic info } = 		   D9	    : [BIT, POS(9)]  BOOLEAN ;	   { Diagnostic info } > 		   X1	    : [BIT, POS(11)] BOOLEAN ;	   { Change execution }> 		   X2	    : [BIT, POS(12)] BOOLEAN ;	   { Change execution }> 		   X3	    : [BIT, POS(13)] BOOLEAN ;	   { Change execution }> 		   X4	    : [BIT, POS(14)] BOOLEAN ;	   { Change execution }> 		   X5	    : [BIT, POS(15)] BOOLEAN ;	   { Change execution }> 		   X6	    : [BIT, POS(16)] BOOLEAN ;	   { Change execution }> 		   X7	    : [BIT, POS(17)] BOOLEAN ;	   { Change execution }> 		   X8	    : [BIT, POS(18)] BOOLEAN ;	   { Change execution }? 		   X9	    : [BIT, POS(19)] BOOLEAN ;) ;  { Change execution }  	     END ;   6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } E 	     Detach,	{  5: May create detached processes (aka Impersonate) } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  C Privset = PACKED SET OF Privilege ;		{ Allow easy bit union, etc. }   < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;  3 Just_A_String = VARYING [1024] OF CHAR VALUE ZERO ;    VAR   I {************************************************************************ I  ****  INCREMENT the BUILD LEVEL every time the module is changed!!  **** J  ************************************************************************}  7 Persona_Bl : [GLOBAL] VARYING [12] OF CHAR := '1.008' ;   1 Acme_Agent_Id : [STATIC,VOLATILE] UNSIGNED := 0 ;    Acme_Agent_Name , ; Orig_User : [EXTERNAL] VARYING [Max_Username_Len] OF CHAR ;   0 Bugger : [EXTERNAL] Debug_Mask ;	{ Debug flags }  1 Dbgfile : [EXTERNAL] TEXT ;	{ Debug output file }   G Privs : Privset := [Cmkrnl,Cmexec,Sysnam,Detach,Tmpmbx,Netmbx,Sysprv] ;       PROCEDURE Zip (Rst1 : UNSIGNED ;3 	       Rst2 : UNSIGNED := SS$_NORMAL) ; EXTERNAL ;     A FUNCTION Str_Privs (Privs : Privset) : Just_A_String ; EXTERNAL ;    PROCEDURE Get_Priv_Info ;   > { Get relevant information about the invoker of the program. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ; - 	Item_List : Item_List_Template (4) := ZERO ;   - 	Image_Work_Priv ,		{ Image's active  privs } - 	Image_Perm_Priv ,		{ Image's default privs } , 	Image_Auth_Priv 		{ Image's auth'd  privs }+ 	    : [UNSAFE,VOLATILE]  Privset := ZERO ;      BEGIN 	{ Get_Priv_Info }#   Item_List[1].Buffer_Length := 8 ; 5   Item_List[1].Item_Code     := JPI$_IMAGE_PERMPRIV ; <   Item_List[1].Buffer_Addr   := IADDRESS (Image_Perm_Priv) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; 5   Item_List[2].Item_Code     := JPI$_IMAGE_AUTHPRIV ; <   Item_List[2].Buffer_Addr   := IADDRESS (Image_Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 8 ; 5   Item_List[3].Item_Code     := JPI$_IMAGE_WORKPRIV ; <   Item_List[3].Buffer_Addr   := IADDRESS (Image_Work_Priv) ;#   Item_List[3].Return_Addr   := 0 ;   B   Item_List[4].Terminator    := 0 ;    { Terminate the item list }  '   Rst := $GETJPIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;   Zip (Rst,Iosb[1]) ;   H   WRITELN (Dbgfile,'*** Image perm privs:',Str_Privs(Image_Perm_Priv)) ;H   WRITELN (Dbgfile,'*** Image auth privs:',Str_Privs(Image_Auth_Priv)) ;H   WRITELN (Dbgfile,'*** Image work privs:',Str_Privs(Image_Work_Priv)) ;   END ; 	{ of Get_Priv_Info }     # PROCEDURE Check_Persona_Extension ;      VAR  Rst : UNSIGNED := 0 ;,        Checked : [STATIC] BOOLEAN := FALSE ;  C   { Check to see if the requested external authentication extension      is available. }   $   BEGIN 	{ Check_Persona_Extension }   IF NOT Checked  THEN
      BEGING      Rst := $PERSONA_EXTENSION_LOOKUP (Acme_Agent_Name,Acme_Agent_Id) ;       IF Bugger.D4  THEN = 	WRITELN (Dbgfile,'*** Check_EID: Rst = ',Rst:1,' / Name = ', 1 		 Acme_Agent_Name,' / EID = ',Acme_Agent_Id:1) ; !      IF Rst = SS$_NOSUCHEXT  THEN  	BEGINC 	LIB$SIGNAL (SS$_NOEXTAUTH-4) ;	   { WARN: Ext Auth not supported } 
 	WRITELN ; 	END
       ELSE%      IF Acme_Agent_Name = 'VMS'  THEN A 	Rst := ACME$_FAILURE	   { Ext Auth already supported -- ignore } 
       ELSE 	Zip (Rst) ;      Checked := TRUE ;
      END ;$   END ; 	{ Check_Persona_Extension }    J [GLOBAL] PROCEDURE Change_Persona (New_Username : VARYING [Len] OF CHAR) ;     VAR  Rst ,$        New_Persona : UNSIGNED := 0 ;3        Item_List : Item_List_Template (2) := ZERO ;      BEGIN 	{ Change_Persona }      IF Bugger.D4	THEN :      WRITELN (Dbgfile,'*** Entering Change_Persona ...') ;  1   Rst := $PERSONA_CREATE (Persona := New_Persona,  			  Usrnam  := New_Username) ; 
   Zip (Rst) ;      IF Bugger.D4	THEN 6      WRITELN (Dbgfile,'*** Persona Created! ',Rst:1) ;     Check_Persona_Extension ;   ;   { Now modify the privs and then assume the new persona. }   $   IF Bugger.D4	THEN  Get_Priv_Info ;  #   Item_List[1].Buffer_Length := 8 ; 5   Item_List[1].Item_Code     := ISS$_IMAGE_WORKPRIV ; 2   Item_List[1].Buffer_Addr   := IADDRESS (Privs) ;#   Item_List[1].Return_Addr   := 0 ;   ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }   2   Rst := $PERSONA_MODIFY (New_Persona,Item_List) ;
   Zip (Rst) ;      IF Bugger.D4	THEN 7      WRITELN (Dbgfile,'*** Persona Modified! ',Rst:1) ;   (   Rst := $PERSONA_ASSUME (New_Persona) ;
   Zip (Rst) ;      IF Bugger.D4	THEN 6      WRITELN (Dbgfile,'*** Persona Assumed! ',Rst:1) ;   END ; 	{ Change_Persona }    END.