D char filename[40];         /* name of the file that was just read */   #define ANS_LENGTH 80 P char ans[ANS_LENGTH];              /* buffer for tokens that are input by user*/  L #define WATCH_LIM 9         /* number of 'watch' points is WATCH_LIM + 1  */   /*******  declared in tm.c  */  5 extern char tm_state;  /* the turing machine state */ : extern int tm_num_exe; /* number of executions of quints*/L extern int trace;     /* flag whether or not to show the tape at each step*/3 extern int debug;     /* turn debug on or off    */ < extern int max_step;   /* maximum steps to take with 'go' */   /*** 'WATCH' variables****/   = extern char watch_state[];   /* buffer for states to watch */  extern int nwatchstate;   > extern char watch_symbol[];  /* buffer for symbols to watch */ extern int nwatchsymbol;   /****************************/    G /********************************************************************** 3      PROTOTYPES FOR EXTERNALLY CALLED FUNCTIONS:    G **********************************************************************/   
 /*  move_head F       Move the tape read-write head one cell left or right.  Returns aG       pointer to the resulting position of the head on the tape.  Takes J       'l' or 'r' as input char to move 'l'eft or 'r'ight.               */  7 extern struct cell *move_head(/*struct tape*, char */);   
 /*  show_tape I       print a listing of the tape, also showing the location of the head.        Returns int status. */  / extern void show_tape(/*struct tape*, int* */);    /*  get_new_tapeH       Get a new tape from standard input.  Returns int status.        */  3 extern void get_new_tape(/*struct tape *, int* */);      /*  find_quint  E     returns a pointer to the quint that has current state and current 9     symbol as input characters.  Returns int status.   */   G extern struct quint *find_quint(/* struct qlist*, char, char, int* */);   
 /*  new_quint ?       creates and adds a new quintuple to the quintuple list.   B       input: quintuple string, comment string.  Function value is :       pointer to the new quintuple. Returns int status  */  I extern struct quint *new_quint(/* struct qlist*, char *, char*, int* */);    /* get_comment:       Prompts the user to enter a quintuple comment.    */  , extern void get_comment(/*struct qlist* */);   /*  list_quints <       Prints out the quintuple list.  Returns int status. */  3 extern void list_quints(/* struct qlist*, int* */);   
 /*  del_quint M       Deletes the quint with given state and symbol from the quintuple list.         Returns int status.*/   < extern void del_quint(/*struct qlist*, char, char, int* */);   /*  del_all_quint N       Deletes all the quintuples from the quintuple list. Returns int status*/  4 extern void del_all_quint(/*struct qlist*, int* */);   /*  del_list_quint8       Removes the quintuple list.  Returns int status */  5 extern void del_list_quint(/*struct qlist*, int* */);    /* zero_quint_iter7       Set iteration count of all quintuples to zero  */   * void zero_quint_iter(/*struct qlist * */);   /* print_quint       Show a quintuple  */  7 void print_quint(/* struct quint *, struct qlist * */);    /*  new_macword D       add a new macro word to the end of the macro list.  Input: the(       macro word.  Returns int status.*/  F extern struct macword *new_macword(/*struct maclist*, char*, int* */);   /*  list_mac9       Print a listing of the macro. Returns int status.*/   1 extern void list_mac(/*struct maclist*, int* */);    /*  del_macword E       Delete a word from the macro list.  Input int: ordinal location 7       of the word on the list.  Returns int status.  */   9 extern void del_macword(/*struct maclist*, int, int* */);    /*  del_all_mac F       Delete all the words from the macro list.  Returns int status.*/  4 extern void del_all_mac(/*struct maclist*, int* */);   /*  set_mac <       Start a new macro list.   Returns int status.       */  0 extern void set_mac(/*struct maclist*, int* */);   /*  run_mac @       Runs the commands on the macro list.  Returns int status*/  0 extern void run_mac(/*struct maclist*, int* */);   /*  edmacro +       Macro list editor.                 */   * extern void edmacro(/*struct maclist* */);   /*  add 2       Add a quintuple to the quintuple list.    */  $ extern void add(/*struct qlist* */);  
 /*  cancel2       Cancel a watch point or a break point.    */  ' extern void cancel(/*struct qlist* */);    /*  dele4       Delete a quintupe from the quintuple list.  */  % extern void dele(/*struct qlist* */);    /*  moveJ       Move the read-write tape head along the tape.  Returns int status */  * extern void move(/*struct tape*, int* */);  	 /*  enter >       routine for accepting quintuples from standard input. */  & extern void enter(/*struct qlist* */);   /*  set G       Routine for setting a number of TM parameters and values.  Called        only in tm.c         */   C extern void set(/*struct qlist*, struct tape*, struct maclist* */);    /*  showL       Routine for showing a number of TM conditions.  Called only in tm.c */  D extern void show(/*struct qlist*, struct tape*, struct maclist* */);   /*  stepG       Perform one or more turing machine cycles.  Returns int status */   9 extern void step(/*struct qlist*, struct tape*, int* */);    /*  goH       Perform turing machine cycles until MAX_STEP is exceeded.  Returns       int status */   7 extern void go(/*struct qlist*, struct tape*, int* */);    /*  read_file, write_file I       Routines that read or write .tm or a .mac files from disk.  Some of !       these return int status. */   ; extern void read_file(/*struct qlist*, struct maclist* */); < extern void write_file(/*struct qlist*, struct maclist* */);: extern void read_tm_file(/*char*, struct qlist*, int* */);9 extern void write_tm_file(/*char*,struct qlist*,int* */); = extern void read_mac_file(/*char*, struct maclist*, int* */); < extern void write_mac_file(/*char*,struct maclist*,int* */);   /*  message F       Send a message (usually an error message) to the user.  Input isF       an (optional) string to append to error, and the status flag. */  $ extern void message(/*char*, int*/);  : /*  getcmd routines.  See getcmd.c                      */  & extern void getcmd(/*char*, char* */);$ extern int iscmd(/*char*, char* */);( extern void flushcmd(/*char*, char* */); extern int morecmd();   extern void pushcmd(/*char* */); extern int getifint(/*int* */); & extern int getifcmd(/*char*,char* */);# extern int getint(/*char*,int* */);   ' /*  help routines.  See help.c       */   " extern void init_help(/*char* */);! extern void get_help(/*char* */);   : /* watch point and break point routines.                */   extern void set_watch(); extern void cancel_watch(); 0 extern void set_break(/*struct qlist*, int* */);3 extern void cancel_break(/*struct qlist*, int* */);  extern void show_watch(); 1 extern void show_break(/*struct qlist*, int* */);     J /*************************************************************************       STATUS VALUES   K **************************************************************************/   E #define OK              1   /* successful completion-- no message  */ ? #define COM_TOO_LONG   -1   /* quintuple comment is too long */ F #define END_IN_LR      -2   /* quintuple fails to end in 'l' or 'r' */: #define QEXISTS        -3   /* quintuple already exists */E #define NEEDS_5        -4   /* quintuple must have five characters */ 6 #define NO_MLIST       -5   /* no macro list exists */6 #define HALTED         -6   /* machine has halted.  */E #define HALTED_FINAL   -7   /* machine has halted in a final state */ L #define MEM_ERROR      -8   /* memory allocation error-- out of memory(?) */; #define NO_SUCH_Q      -9   /* no such quintuple exists  */ < #define NO_QLIST      -10   /* there is no quintuple list */= #define EMPTY_QLIST   -11   /* the quintuple list is empty */ ; #define NO_READ_OPEN  -12   /* can't open a file to read */ @ #define EMPTY_QFILE   -13   /* the .tm file has no quintuples */B #define EMPTY_MFILE   -14   /* the .mac file has no macro words */N #define NO_STR_END    -15   /* the end of string wasn't found on a file line*/8 #define NO_MACRO      -16   /* there is no macro list */9 #define EMPTY_MACRO   -17   /* the macro list is empty */ B #define NO_WRITE_OPEN -18   /* a file can't be opened for write */5 #define WORD_TOO_LONG -19   /* a word was too long */ L #define CANT_INSERT   -20   /* can't insert a macro word at this location */D #define SHOW_TAPE     -22   /* tells the program to show the tape */H #define NO_SHOW_TAPE  -23   /* tells the program not to show the tape */L #define NON_HAVE_STATE -24  /* no quintuple has the requested col 1 state */L #define STATE_BUT_NO_SYM -25 /* quint has the col 1 state, but not the sym*/O #define WORD_NOT_FOUND -26  /* couldn't find the input macro word on the list*/ 3 #define NO_TAPE       -27   /* there is no tape. */ N #define CANT_RUN_RUN  -28   /* can't put 'run' in a macro... recursive call */H #define AT_BREAK_POINT -29  /* one_step has encountered a break point */F #define AT_STATE_WATCH -30  /* one_step has found state watch point */G #define AT_SYMBOL_WATCH -31 /* one_step has found symbol watch point */ 