  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |                NOPE               %%   \ @  *                %% |          support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *  *D  *  This is a new release of the NOPE (NO PurgE) originally from theF  *  VAX87C Fall 1987 VAX SIG DECUS tape. Much of the original code hasG  *  been replaced by my own code, primarily to simplify maintaining the I  *  code subsequent to adding command line parsing and substantial output I  *  formatting changes. The original code is available in this archive in 0  *  the file NOPE_ORIG.SRC for those interested.  *  @  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-1" #pragma module SUPPORT VERSION   #include <stdio.h> #include <atrdef.h>  #include <climsgdef.h> #include <descrip.h> #include <dvidef.h>  #include <fibdef.h>  #include <file.h>  #include <iodef.h> #include <rms.h> #include <ssdef.h> #include <string.h>   D extern int BckBin[2];           /* quadword value for Backup date */D extern int CreBin[2];           /* quadword value for Create date */D extern int ExpBin[2];           /* quadword value for Expire date */F extern int RevBin[2];           /* quadword value for Revision date */K extern int CurBin[2];           /* bin value for /BEFORE or /SINCE date */     extern int status;   extern short BeforeFlg; L extern short KeepCount;         /* number of times current filename found */K extern short KeepFlg;           /* integer value for /KEEP was specified */ K extern short KeepValue;         /* the nonzero value for /KEEP specified */ M extern short QualFlg;           /* bit mask reflecting selected time stamp */  extern short SinceFlg;  6 extern char Buffer[80];         /* cli value string */I extern char CmdVerb[32];        /* foreign command inviking this image */ L extern char DateStr[28];        /* date string for ascii date to bin date */B extern char InputFile[132];     /* input file from command line */ extern char *ptr;   = extern struct FAB WildFab;      /* FAB for wildcard search */ J extern struct NAM WildNam;      /* NAM used in conjunction with WildFab */D extern struct FAB SizeFab;      /* FAB for file allocation values */   struct fibdef Fib;   #define BACKUP_DATE 1  #define CREATE_DATE 2  #define EXPIRE_DATE 4  #define REVISE_DATE 8    #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif   #define LIB$_NORMAL 1409025    globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;    globalvalue NOPE_CLD;    extern void ShowVers();  extern int lib$get_input();          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCliInfo F  * Description: check for parameters and qualifiers which were enteredJ  *              at the command line. If values are required, verify syntax-  *              and set respective variables.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCliInfo()  { ;     char CliStr[80];                /* cli string buffer */ J     char CmdLine[132];              /* buffer reflecting input cmd line */     char CurTim[28];     char LineBuf[132];     char *DefPath;   F     int CliStat;                    /* return status from cli calls */K     int Delta[2] = 0;               /* binary delta offset for yesterday */   J     short CliStrLen;                /* integer depicting cli value size */     short CmdLen;      short CurLen;    J     $DESCRIPTOR(DscBuf, Buffer);    /* string returned by cli$get_value */G     $DESCRIPTOR(DscCli, CliStr);    /* cli param or qualifier string */ !     $DESCRIPTOR(DscCmd, CmdLine); C     $DESCRIPTOR(DscCur, CurTim);    /* user provided time string */ "     $DESCRIPTOR(DscLbuf, LineBuf);$     $DESCRIPTOR(DscPath, InputFile);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "NOPE ");      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); E     CliStat = cli$dcl_parse(&DscLbuf, NOPE_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   C         /* check for presence of qualifiers which are not dependant (            on additional input values */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr, "HELP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    I         /* if we get here (we would not if either of the above qualifiers I            were entered, as they call sys$exit at the conclusion of their K            respective function calls) then check for and process input file 2            parameter if it is present and valid */        strcpy(CliStr, "FILESPEC"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(InputFile, Buffer);    /* input file to change */	         }      } H     else {          /* FILESPEC not specified on cmdline, use default */!         DefPath = getenv("PATH"); #         strcpy(InputFile, DefPath); 1         DscPath.dsc$w_length = strlen(InputFile); 0         status = str$upcase(&DscPath, &DscPath);     }         strcpy(CliStr, "BACKUP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); 7     if(CliStat == CLI$_PRESENT) QualFlg |= BACKUP_DATE;        strcpy(CliStr, "BEFORE"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; *             if(!strcmp(Buffer, "TODAY")) {<                 status = sys$asctim(&CurLen, &DscCur, 0, 0);6                 if(status != SS$_NORMAL) exit(status);#                 CurTim[CurLen] = 0; 1                 strcpy(CurTim+12, "00:00:00.00"); 5                 DscCur.dsc$w_length = strlen(CurTim); 6                 status = sys$bintim(&DscCur, &CurBin);6                 if(status != SS$_NORMAL) exit(status);
             }              else {'                 strcpy(CurTim, Buffer); 0                 DscCur.dsc$w_length = CliStrLen;6                 status = sys$bintim(&DscCur, &CurBin);6                 if(status != SS$_NORMAL) exit(status);
             } 	         }          BeforeFlg = TRUE;      }        strcpy(CliStr, "CREATED");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); 7     if(CliStat == CLI$_PRESENT) QualFlg |= CREATE_DATE;         strcpy(CliStr, "EXPIRED");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); 7     if(CliStat == CLI$_PRESENT) QualFlg |= EXPIRE_DATE;         strcpy(CliStr, "KEEP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; L             KeepValue = atoi(Buffer);   /* will be zero if ALL is present */L             if(KeepValue) KeepFlg = TRUE; /* if KeepValue is 0, ignore it */	         }          else KeepValue = 0;      }        strcpy(CliStr, "MODIFIED"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); 7     if(CliStat == CLI$_PRESENT) QualFlg |= REVISE_DATE;         strcpy(CliStr, "SINCE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; *             if(!strcmp(Buffer, "TODAY")) {<                 status = sys$asctim(&CurLen, &DscCur, 0, 0);6                 if(status != SS$_NORMAL) exit(status);#                 CurTim[CurLen] = 0; 1                 strcpy(CurTim+12, "00:00:00.00"); 5                 DscCur.dsc$w_length = strlen(CurTim); 6                 status = sys$bintim(&DscCur, &CurBin);6                 if(status != SS$_NORMAL) exit(status);
             }              else {'                 strcpy(CurTim, Buffer); 0                 DscCur.dsc$w_length = CliStrLen;6                 status = sys$bintim(&DscCur, &CurBin);6                 if(status != SS$_NORMAL) exit(status);
             } 	         }          SinceFlg = TRUE;     } J     if(!QualFlg) QualFlg |= CREATE_DATE;    /* default, just like PURGE */ }      H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;!     int     retstat = SS$_NORMAL; A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }      } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }             J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetDateInfoD  * Description: This routine determines current target file from theE  *              WildNam structure. It then uses the ACP QIO interface M  *              to get the target file timestamps for Creation, Modification, D  *              Backup and Expiration. The specified timestamp valueH  *              is compared to the value entered by user on command lineE  *              for either /BEFORE or /SINCE. The compare defaults to D  *              Creation date if not specified on command line. ThisL  *              routine is not called if /BEFORE or /SINC are not specified.E  *              We return TRUE if compare result os positive, else we   *              return FALSE.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetDateInfo()  {      int     Fstat;A     int     DeltaBin[2] = 0;        /* result of lib$sub_times */      int     devchar;C     short   Channel;                /* I/O channel to input file */ G     short   Iosb[4];                /* I/O status block for SYS$QIOW */   <     char    DevName[32];            /* target disk device */     char    Fname[80];     char    *DviPtr;     char    *ptr;   4     struct {short size, type; int *address;} Atr[5];;     struct {short len, code; int *buf, *retlen;} DviItm[2];    D     $DESCRIPTOR(DscDev, DevName);       /* device name descriptor */O     $DESCRIPTOR(DscFib, (char *)&Fib);  /* NOTE: this is not your normal dsc */ =     $DESCRIPTOR(DscWork, Fname);        /* target filename */    4         /* ititialize the itemlist for SYS$GETJPI */        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;=     DviItm[0].buf    = &devchar;   /* disk characteristics */      DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;    '     DscFib.dsc$w_length = FIB$C_LENGTH;    G         /* initialize ACP-QIO Attributes structure. The primary purpose G            here is to get specific date/time values. This could grow in 6            time for other items, but it is unlikely */   !     Atr[0].size = sizeof(CreBin);       Atr[0].type = ATR$C_CREDATE;     Atr[0].address = &CreBin; !     Atr[1].size = sizeof(RevBin);       Atr[1].type = ATR$C_REVDATE;     Atr[1].address = &RevBin; !     Atr[2].size = sizeof(ExpBin);       Atr[2].type = ATR$C_EXPDATE;     Atr[2].address = &ExpBin; !     Atr[3].size = sizeof(BckBin);       Atr[3].type = ATR$C_BAKDATE;     Atr[3].address = &BckBin;      Atr[4].size = 0;     Atr[4].type = 0;     Atr[4].address = 0;    :         /* get the disk device name for target filepath */   #     DviPtr = &WildNam.nam$t_dvi[1];      strcpy(DevName, DviPtr);&     DevName[WildNam.nam$t_dvi[0]] = 0;/     DscDev.dsc$w_length = WildNam.nam$t_dvi[0]; =     status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0);**     if(status != SS$_NORMAL) exit(status);  *6         /* get and save target filename w/o dirspec */  %     ptr = WildNam.nam$l_name;\     strcpy(Fname, ptr);_  _C             /* clear the entire Fib structure so the $QIO operation G                does not reflect Fib values from a previous file. We are B                in fact inside a 'for' loop, even if we are working"                on just one file */  %!     memset(&Fib, 0, sizeof(Fib));    <             /* init the Fib structure, only need file id and?                directory id fields filled in from WildNam block%,                following successful $PARSE*/   6             /* copy the file ID from WildNam to Fib */   -     Fib.fib$w_fid_num = WildNam.nam$w_fid[0]; -     Fib.fib$w_fid_seq = WildNam.nam$w_fid[1];|-     Fib.fib$w_fid_rvn = WildNam.nam$w_fid[2];_  _;             /* copy the directory ID from WildNam to Fib */s  A-     Fib.fib$w_did_num = WildNam.nam$w_did[0]; -     Fib.fib$w_did_seq = WildNam.nam$w_did[1];s-     Fib.fib$w_did_rvn = WildNam.nam$w_did[2];   aE             /* issue QIOW with IO$_ACCESS to fill primarily the itemso@                in the ATR structure. This does not open the file;                so does not change the revision date/time */    1     status = sys$assign(&DscDev, &Channel, 0, 0);a*     if(status != SS$_NORMAL) exit(status);  S)     DscWork.dsc$w_length = strlen(Fname);e  r:     status = sys$qiow(0, Channel, IO$_ACCESS, &Iosb, 0, 0,4                   &DscFib, &DscWork, 0, 0, &Atr, 0);*     if(status != SS$_NORMAL) exit(status);     status = Iosb[0]; *     if(status != SS$_NORMAL) exit(status);!     status = sys$DASSGN(Channel);e*     if(status != SS$_NORMAL) exit(status);  H         /* check against creation date if QualFlg bit 'CREATE' is set */  *     if(QualFlg & CREATE_DATE) {*         if(BeforeFlg) {*@             status = lib$sub_times(&CurBin, &CreBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);d             else return(FALSE);i	         }c           if(SinceFlg) {@             status = lib$sub_times(&CreBin, &CurBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);g             else return(FALSE); 	         }a     }a   H         /* check against revision date if QualFlg bit 'REVISE' is set */  a     if(QualFlg & REVISE_DATE) {          if(BeforeFlg) {u@             status = lib$sub_times(&CurBin, &RevBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);              else return(FALSE); 	         }            if(SinceFlg) {@             status = lib$sub_times(&RevBin, &CurBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);t             else return(FALSE);l	         }P     } C         /* The file may or may not have expiration or backup dates./I            First check to see if the date field has a value in it, if nots>            then print <none specified> in place of the date */  rJ         /* check against expiration date if QualFlg bit 'EXPIRE' is set */  n     if(QualFlg & EXPIRE_DATE) {          if(BeforeFlg) { @             status = lib$sub_times(&CurBin, &ExpBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);              else return(FALSE);c	         }a           if(SinceFlg) {@             status = lib$sub_times(&ExpBin, &CurBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);              else return(FALSE);e	         }u     }e  iF         /* check against backup date if QualFlg bit 'BACKUP' is set */        if(QualFlg & BACKUP_DATE) {f         if(BeforeFlg) { @             status = lib$sub_times(&CurBin, &BckBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);L             else return(FALSE);b	         }_           if(SinceFlg) {@             status = lib$sub_times(&BckBin, &CurBin, &DeltaBin);3             if(status == LIB$_NORMAL) return(TRUE);*             else return(FALSE);*	         }*     }  }o  G  l  fH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowVersmC  * Description: Displays current installed version, build date, and C  *              required privs for interactive usage and/or the VMS*C  *              install utility (note bypass used for directories).   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */; void ShowVers()b {e1     printf("\n\t\t%s by Lyle W West\n", CmdVerb);;2     printf("\t\tOriginal Author: Thomas Bodoh\n");F     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");y5     printf("\t\tRequired Privs: None (Readall)\n\n");i     exit(1); }c  v  