#                                               8 July 2012.  SMS.
#
#    GZIP 1.5 for VMS - MMS (or MMK) Source Description File.
#

# This description file is included by other description files.  It is
# not intended to be used alone.  Verify proper inclusion.

.IFDEF INCL_DESCRIP_SRC
.ELSE
$$$$ THIS DESCRIPTION FILE IS NOT INTENDED TO BE USED THIS WAY.
.ENDIF


# Define MMK architecture macros when using MMS.

.IFDEF __MMK__                  # __MMK__
.ELSE                           # __MMK__
ALPHA_X_ALPHA = 1
IA64_X_IA64 = 1
VAX_X_VAX = 1
.IFDEF $(MMS$ARCH_NAME)_X_ALPHA     # $(MMS$ARCH_NAME)_X_ALPHA
__ALPHA__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_ALPHA
.IFDEF $(MMS$ARCH_NAME)_X_IA64      # $(MMS$ARCH_NAME)_X_IA64
__IA64__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_IA64
.IFDEF $(MMS$ARCH_NAME)_X_VAX       # $(MMS$ARCH_NAME)_X_VAX
__VAX__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_VAX
.ENDIF                          # __MMK__

# Combine command-line VAX C compiler macros.

.IFDEF VAXC                     # VAXC
VAXC_OR_FORCE_VAXC = 1
.ELSE                           # VAXC
.IFDEF FORCE_VAXC                   # FORCE_VAXC
VAXC_OR_FORCE_VAXC = 1
.ENDIF                              # FORCE_VAXC
.ENDIF                          # VAXC

# Analyze architecture-related and option macros.

.IFDEF __ALPHA__                # __ALPHA__
DECC = 1
DESTM = ALPHA
.ELSE                           # __ALPHA__
.IFDEF __IA64__                     # __IA64__
DECC = 1
DESTM = IA64
.ELSE                               # __IA64__
.IFDEF __VAX__                          # __VAX__
.IFDEF VAXC_OR_FORCE_VAXC                   # VAXC_OR_FORCE_VAXC
DESTM = VAXV
.ELSE                                       # VAXC_OR_FORCE_VAXC
.IFDEF GNUC                                     # GNUC
CC = GCC
DESTM = VAXG
.ELSE                                           # GNUC
DECC = 1
DESTM = VAX
.ENDIF                                          # GNUC
.ENDIF                                      # VAXC_OR_FORCE_VAXC
.ELSE                                   # __VAX__
DESTM = UNK
UNK_DEST = 1
.ENDIF                                  # __VAX__
.ENDIF                              # __IA64__
.ENDIF                          # __ALPHA__

.IFDEF LARGE                    # LARGE
.IFDEF __VAX__                      # __VAX__
DESTL =
.ELSE                               # __VAX__
DESTL = L
.ENDIF                              # __VAX__
.ELSE                           # LARGE
DESTL =
.ENDIF                          # LARGE

DEST = $(DESTM)$(DESTL)

# Check for option problems.

.IFDEF __VAX__                  # __VAX__
.IFDEF LARGE                        # LARGE
LARGE_VAX = 1
.ENDIF                              # LARGE
.IFDEF VAXC_OR_FORCE_VAXC           # VAXC_OR_FORCE_VAXC
.IFDEF GNUC                             # GNUC
VAX_MULTI_CMPL = 1
.ENDIF                                  # GNUC
.ENDIF                              # VAXC_OR_FORCE_VAXC
.ELSE                           # __VAX__
.IFDEF VAXC_OR_FORCE_VAXC           # VAXC_OR_FORCE_VAXC
NON_VAX_CMPL = 1
.ELSE                               # VAXC_OR_FORCE_VAXC
.IFDEF GNUC                             # GNUC
NON_VAX_CMPL = 1
.ENDIF                                  # GNUC
.ENDIF                              # VAXC_OR_FORCE_VAXC
.ENDIF                          # __VAX__

# Complain if warranted.  Otherwise, show destination directory.
# Make the destination directory, if necessary.
				
.IFDEF UNK_DEST                 # UNK_DEST
.FIRST
	@ write sys$output -
 "   Unknown system architecture."
.IFDEF __MMK__                      # __MMK__
	@ write sys$output -
 "   MMK on IA64?  Try adding ""/MACRO = __IA64__""."
.ELSE                               # __MMK__
	@ write sys$output -
 "   MMS too old?  Try adding ""/MACRO = MMS$ARCH_NAME=ALPHA"","
	@ write sys$output -
 "   or ""/MACRO = MMS$ARCH_NAME=IA64"", or ""/MACRO = MMS$ARCH_NAME=VAX"","
	@ write sys$output -
 "   as appropriate.  (Or try a newer version of MMS.)"
.ENDIF                              # __MMK__
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                           # UNK_DEST
.IFDEF VAX_MULTI_CMPL               # VAX_MULTI_CMPL
.FIRST
	@ write sys$output -
 "   Macro ""GNUC"" is incompatible with ""VAXC"" or ""FORCE_VAXC""."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                               # VAX_MULTI_CMPL
.IFDEF NON_VAX_CMPL                     # NON_VAX_CMPL
.FIRST
	@ write sys$output -
 "   Macros ""GNUC"", ""VAXC"", and ""FORCE_VAXC"" are valid only on VAX."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                                   # NON_VAX_CMPL
.IFDEF LARGE_VAX                            # LARGE_VAX
.FIRST
	@ write sys$output -
 "   Macro ""LARGE"" is invalid on VAX."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                                       # LARGE_VAX
.FIRST
	@ write sys$output "   Destination: [.$(DEST)]"
	@ write sys$output ""
	if (f$search( "$(DEST).DIR;1") .eqs. "") then -
	 create /directory [.$(DEST)]
.IFDEF VAXC_OR_FORCE_VAXC                       # VAXC_OR_FORCE_VAXC
	@ define sys sys$library
.ENDIF                                          # VAXC_OR_FORCE_VAXC
.ENDIF                                      # LARGE_VAX
.ENDIF                                  # NON_VAX_CMPL
.ENDIF                              # VAX_MULTI_CMPL
.ENDIF                          # UNK_DEST

# DBG options.

.IFDEF DBG                      # DBG
CFLAGS_DBG = /debug /nooptimize
LINKFLAGS_DBG = /debug /traceback
.ELSE                           # DBG
CFLAGS_DBG =
LINKFLAGS_DBG = /notraceback
.ENDIF                          # DBG

# Large-file options.

.IFDEF LARGE                    # LARGE
CDEFS_LARGE = , _LARGEFILE
.ELSE                           # LARGE
CDEFS_LARGE =
.ENDIF                          # LARGE

# C compiler defines.

.IFDEF LOCAL_GZIP
C_LOCAL_GZIP = , $(LOCAL_GZIP)
.ELSE
C_LOCAL_GZIP =
.ENDIF

CDEFS = VMS, HAVE_CONFIG_H $(CDEFS_LARGE) $(C_LOCAL_GZIP)

# Other C compiler options.

.IFDEF DECC                             # DECC
CFLAGS_ARCH = /decc /prefix = -
 (all, except = (getopt, gettimeofday, optarg, opterr, optind, optopt))
.ELSE                                   # DECC
.IFDEF FORCE_VAXC                           # FORCE_VAXC
CFLAGS_ARCH = /vaxc
.IFDEF VAXC                                     # VAXC
.ELSE                                           # VAXC
VAXC = 1
.ENDIF                                          # VAXC
.ELSE                                       # FORCE_VAXC
CFLAGS_ARCH =
.ENDIF                                      # FORCE_VAXC
.ENDIF                                  # DECC

CFLAGS_INCL = /include = ([], [.vms], [.lib])

# LINK options.

.IFDEF VAXC_OR_FORCE_VAXC               # VAXC_OR_FORCE_VAXC
OPT_FILE = [.$(DEST)]VAXCSHR.OPT
LINKFLAGS_ARCH = , $(OPT_FILE) /options
.ELSE                                   # VAXC_OR_FORCE_VAXC
.IFDEF GNUC                                 # GNUC
OPT_FILE = [.$(DEST)]VAXCSHR.OPT
LINKFLAGS_GNU = GNU_CC:[000000]GCCLIB.OLB /LIBRARY
LINKFLAGS_ARCH = , $(LINKFLAGS_GNU), SYS$DISK:$(OPT_FILE) /options
.ELSE                                       # GNUC
OPT_FILE =
LINKFLAGS_ARCH =
.ENDIF                                      # GNUC
.ENDIF                                  # VAXC_OR_FORCE_VAXC

# LIST options.

.IFDEF LIST                     # LIST
.IFDEF DECC                         # DECC
CFLAGS_LIST = /list = $*.LIS /show = (all, nomessages)
.ELSE                               # DECC
CFLAGS_LIST = /list = $*.LIS /show = (all)
.ENDIF                              # DECC
LINKFLAGS_LIST = /map = $*.MAP /cross_reference /full
.ELSE                           # LIST
CFLAGS_LIST =
LINKFLAGS_LIST =
.ENDIF                          # LIST

# Common CFLAGS and LINKFLAGS.

CFLAGS = \
 $(CFLAGS_ARCH) $(CFLAGS_DBG) $(CFLAGS_INCL) $(CFLAGS_LIST) $(CCOPTS) \
 /object = $(MMS$TARGET)

LINKFLAGS = \
 $(LINKFLAGS_DBG) $(LINKFLAGS_LIST) $(LINKOPTS) \
 /executable = $(MMS$TARGET)


# System-specific header files.

CONFIG_H = [.LIB]CONFIG.H
CONFIG_H_VMS = [.VMS]CONFIG.H_VMS

GENERATED_HEADERS = $(CONFIG_H)


# Object library module=object lists.

#    GNU object library, [.lib].

MODS_OBJS_LIB_GNU = \
 basename-lgpl=[.$(DEST)]BASENAME-LGPL.OBJ \
 c-ctype=[.$(DEST)]C-CTYPE.OBJ \
 c-strcasecmp=[.$(DEST)]C-STRCASECMP.OBJ \
 calloc=[.$(DEST)]CALLOC.OBJ \
 chdir-long=[.$(DEST)]CHDIR-LONG.OBJ \
 cloexec=[.$(DEST)]CLOEXEC.OBJ \
 closein=[.$(DEST)]CLOSEIN.OBJ \
 closeout=[.$(DEST)]CLOSEOUT.OBJ \
 close-stream=[.$(DEST)]CLOSE-STREAM.OBJ \
 dirfd=[.$(DEST)]DIRFD.OBJ \
 dup-safer=[.$(DEST)]DUP-SAFER.OBJ \
 error=[.$(DEST)]ERROR.OBJ \
 exitfail=[.$(DEST)]EXITFAIL.OBJ \
 fchdir=[.$(DEST)]FCHDIR.OBJ \
 fdopendir=[.$(DEST)]FDOPENDIR.OBJ \
 fd-safer=[.$(DEST)]FD-SAFER.OBJ \
 filenamecat-lgpl=[.$(DEST)]FILENAMECAT-LGPL.OBJ \
 fpending=[.$(DEST)]FPENDING.OBJ \
 freadahead=[.$(DEST)]FREADAHEAD.OBJ \
 getopt=[.$(DEST)]GETOPT.OBJ \
 getopt1=[.$(DEST)]GETOPT1.OBJ \
 gettime=[.$(DEST)]GETTIME.OBJ \
 gettimeofday=[.$(DEST)]GETTIMEOFDAY.OBJ \
 localcharset=[.$(DEST)]LOCALCHARSET.OBJ \
 malloc=[.$(DEST)]MALLOC.OBJ \
 memrchr=[.$(DEST)]MEMRCHR.OBJ \
 openat=[.$(DEST)]OPENAT.OBJ \
 openat-die=[.$(DEST)]OPENAT-DIE.OBJ \
 openat-proc=[.$(DEST)]OPENAT-PROC.OBJ \
 opendir-safer=[.$(DEST)]OPENDIR-SAFER.OBJ \
 open-safer=[.$(DEST)]OPEN-SAFER.OBJ \
 quotearg=[.$(DEST)]QUOTEARG.OBJ \
 realloc=[.$(DEST)]REALLOC.OBJ \
 savedir=[.$(DEST)]SAVEDIR.OBJ \
 save-cwd=[.$(DEST)]SAVE-CWD.OBJ \
 utimens=[.$(DEST)]UTIMENS.OBJ \
 xmalloc=[.$(DEST)]XMALLOC.OBJ \
 yesno=[.$(DEST)]YESNO.OBJ

#    Primary object library, [].

MODS_OBJS_LIB_GZIP_N = \
 bits=[.$(DEST)]BITS.OBJ \
 deflate=[.$(DEST)]DEFLATE.OBJ \
 gzip=[.$(DEST)]GZIP.OBJ \
 inflate=[.$(DEST)]INFLATE.OBJ \
 lzw=[.$(DEST)]LZW.OBJ \
 trees=[.$(DEST)]TREES.OBJ \
 unlzh=[.$(DEST)]UNLZH.OBJ \
 unlzw=[.$(DEST)]UNLZW.OBJ \
 unpack=[.$(DEST)]UNPACK.OBJ \
 unzip=[.$(DEST)]UNZIP.OBJ \
 util=[.$(DEST)]UTIL.OBJ \
 zip=[.$(DEST)]ZIP.OBJ

#    Primary object library, [.vms].

MODS_OBJS_LIB_GZIP_V = \
 version=[.$(DEST)]VERSION.OBJ \
 vms=[.$(DEST)]VMS.OBJ

MODS_OBJS_LIB_GZIP = $(MODS_OBJS_LIB_GZIP_N) $(MODS_OBJS_LIB_GZIP_V)

# Executables.

GZIP = [.$(DEST)]GZIP.EXE

DECC_VER = [.$(DEST)]DECC_VER.EXE

