#                                               30 March 2011.  SMS.
#
#    GZIP 1.5 for VMS - MMS Dependency Description File.
#
#    MMS /EXTENDED_SYNTAX description file to generate a C source
#    dependencies file.  Unsightly errors result when /EXTENDED_SYNTAX
#    is not specified.  Typical usage:
#
#    $ MMS /EXTEND /DESCRIP = [.vms]descrip_mkdeps.mms /SKIP
#
#    which discards individual source dependency files, or:
#
#    $ MMS /EXTEND /DESCRIP = [.vms]descrip_mkdeps.mms /MACRO = NOSKIP=1
#
#    which retains them.  Retaining them can save time when doing code
#    development.
#
# Note that this description file must be used from the main
# distribution directory, not from the [.vms] subdirectory.
#
#
# The default target is the comprehensive source dependency file,
# $(DEPS_FILE) = "[.vms]DESCRIP_DEPS.MMS".
#
# Other targets:
#
#    CLEAN      deletes the individual source dependency files,
#               *.MMSD;*, but leaves the comprehensive source dependency
#               file.
#
#    CLEAN_ALL  deletes all source dependency files, including the
#               individual *.MMSD;* files and the comprehensive file,
#               DESCRIP_DEPS.MMS.*.
#
# MMK users without MMS may be unable to generate the dependencies file
# using this description file, however there should be one supplied in
# the kit.  If this file has been deleted, users in this predicament
# will need to recover it from the original distribution kit.
#
# Note:  This dependency generation scheme assumes that the dependencies
# do not depend on host architecture type or other such variables. 
# Therefore, no "#include" directive in the C source itself should be
# conditional on such variables.
#
# This description file uses this command procedure:
#
#    [.vms]collect_deps.com
#

# Required command procedures.

COMS = [.vms]collect_deps.com

# Include the source file lists (among other data).

INCL_DESCRIP_SRC = 1
.INCLUDE [.vms]descrip_src.mms

# The ultimate product, a comprehensive dependency list.

DEPS_FILE = [.vms]descrip_deps.mms 

# Detect valid qualifier and/or macro options.

.IF $(FINDSTRING Skip, $(MMSQUALIFIERS)) .eq Skip
DELETE_MMSD = 1
.ELSIF NOSKIP
PURGE_MMSD = 1
.ELSE
UNK_MMSD = 1
.ENDIF

# Dependency suffixes and rules.
#
# .FIRST is assumed to be used already, so the MMS qualifier/macro check
# is included in each rule (one way or another).

.SUFFIXES_BEFORE .C .MMSD

.C.MMSD :
.IF UNK_MMSD
	@ write sys$output -
 "   /SKIP_INTERMEDIATES is expected on the MMS command line."
	@ write sys$output -
 "   For normal behavior (delete .MMSD files), specify ""/SKIP""."
	@ write sys$output -
 "   To retain the .MMSD files, specify ""/MACRO = NOSKIP=1""."
	@ exit %x00000004
.ENDIF
	$(CC) $(CFLAGS_INCL) /define = ($(CDEFS)) /NOLIST /NOOBJECT -
	 $(MMS$SOURCE) -
	 /MMS_DEPENDENCIES = (FILE = $(MMS$TARGET))

# List of MMS dependency files.

# In case it's not obvious...
# To extract module name lists from object library module=object lists:
# 1.  Transform "module=[.dest]NAME.OBJ" into "module=[.dest] NAME".
# 2.  For [.vms], add [.vms] to name.
# 3.  Delete "*]" words.
#
# A similar scheme works for executable lists.

MODS_LIB_GNU = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] [.lib]*, $(MODS_OBJS_LIB_GNU)))

MODS_LIB_GZIP_N = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_GZIP_N)))

MODS_LIB_GZIP_V = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] [.vms]*, $(MODS_OBJS_LIB_GZIP_V)))

MODS_EXE_N = $(FILTER-OUT *], \
 $(PATSUBST *]*.EXE, *] *, $(GZIP)))

MODS_EXE_V = $(FILTER-OUT *], \
 $(PATSUBST *]*.EXE, *] [.vms]*, $(DECC_VER)))

# Complete list of C object dependency file names.

DEPS = $(FOREACH NAME, \
 $(MODS_LIB_GNU) \
 $(MODS_LIB_GZIP_N) $(MODS_LIB_GZIP_V) \
 $(MODS_EXE_N) $(MODS_EXE_V), \
 $(NAME).mmsd)

# Target is the comprehensive dependency list.

$(DEPS_FILE) : $(CONFIG_H) $(DEPS) $(COMS)
.IF UNK_MMSD
	@ write sys$output -
 "   /SKIP_INTERMEDIATES is expected on the MMS command line."
	@ write sys$output -
 "   For normal behavior (delete individual .MMSD files), specify ""/SKIP""."
	@ write sys$output -
 "   To retain the individual .MMSD files, specify ""/MACRO = NOSKIP=1""."
	@ exit %x00000004
.ENDIF
#
#       Note that the space in P3, which prevents immediate macro
#       expansion, is removed by COLLECT_DEPS.COM.
#
        @[.vms]collect_deps.com "GZIP for VMS" "$(MMS$TARGET)" -
	 "[...]*.mmsd" "[.$ (DEST)]" $(MMSDESCRIPTION_FILE)
        @ write sys$output -
         "Created a new dependency file: $(MMS$TARGET)"
.IF DELETE_MMSD
	@ write sys$output -
         "Deleting intermediate .MMSD files..."
	delete /log *.mmsd;*, [.lib]*.mmsd;*, [.vms]*.mmsd;*
.ELSE
	@ write sys$output -
         "Purging intermediate .MMSD files..."
	purge /log *.mmsd, [.lib]*.mmsd, [.vms]*.mmsd
.ENDIF


# CLEAN target.  Delete:
#    The "config.h" file.
#    The individual C dependency files.

CLEAN :
        if (f$search( "$(CONFIG_H)") .nes. "") then -
         delete /log $(CONFIG_H);*
        if (f$search( "*.mmsd;*") .nes. "") then -
         delete /log *.mmsd;*
        if (f$search( "[.lib]*.mmsd;*") .nes. "") then -
         delete /log [.lib]*.mmsd;*
        if (f$search( "[.vms]*.mmsd;*") .nes. "") then -
         delete /log [.vms]*.mmsd;*

# CLEAN_ALL target.  Delete:
#    The "config.h" file.
#    The individual C dependency files.
#    The collected source dependency file.

CLEAN_ALL :
        if (f$search( "$(CONFIG_H)") .nes. "") then -
         delete /log $(CONFIG_H);*
        if (f$search( "*.mmsd;*") .nes. "") then -
         delete /log *.mmsd;*
        if (f$search( "[.lib]*.mmsd;*") .nes. "") then -
         delete /log [.lib]*.mmsd;*
        if (f$search( "[.vms]*.mmsd;*") .nes. "") then -
         delete /log [.vms]*.mmsd;*
        if (f$search( "$(DEPS_FILE);*") .nes. "") then -
         delete /log $(DEPS_FILE);*


# PURGE target.

PURGE :
        if (f$search( "$(CONFIG_H);-1") .nes. "") then -
         purge /log $(CONFIG_H)
        if (f$search( "*.mmsd;*") .nes. "") then -
         purge /log *.mmsd
        if (f$search( "[.lib]*.mmsd;*") .nes. "") then -
         purge /log [.vms]*.mmsd
        if (f$search( "[.lib]*.mmsd;*") .nes. "") then -
         purge /log [.vms]*.mmsd
        if (f$search( "$(DEPS_FILE);-1") .nes. "") then -
         purge /log $(DEPS_FILE)


# Generated header files.

INCL_CONFIG_SRC = 1
.INCLUDE [.vms]descrip_config.mms

