   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |             NEXT_UIC              %%   \ @  *                %% |         next_uic.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *B  *      Copyright (C) 2004, 1998 Lyle W. West, Hein van den Heuvel  *      All Rights Reserved.N  *      Permission is granted to copy and use this program so long as [1] thisL  *      copyright notice is preserved, and [2] no financial gain is involvedL  *      in copying the program.  This program may not be sold as "shareware"K  *      or "public domain" software without the express, written permission   *      of the authors.   *G  *      This program provides the next available uic available within a E  *      uic group. The UID (user identification) is based on the next C  *      highest value above the current highest value, and does not F  *      consider gaps caused by former user accounts. The single inputD  *      parameter is any username within the desired group. All userH  *      accounts above the entered username are located, and the user isD  *      presented with the next uid value above the current highest.  *H  *      Originally created by Hein van den Heuvel in 1998 in response toC  *      a posted request on COMP-OS-VMS, it was posted by Hein as a L  *      concept, and was written to be built utilizing VaxC. It was recentlyG  *      resurrected and cleaned up, extensively modified and now can be   *      built using DecC V6.2   *H  *      The original 1998 posting and source are in this directory under;  *      the filename NEXT_UIC.SRC if there is any interest,   *7  *      User should define a foreign symbol as follows:   *<  *          $ next_uic == "$ device:[dir1.dir2]next_uic.exe"  *#  *          Usage: next_uic newuser *  *                 next_uic /group=default&  *                 next_uic /group=200  *G  *      Where newuser is the username of any user in the group in which E  *      the new UIC is to be created. Else user can omit the Username J  *      parameter and use the /GROUP qualifier. This qualifier will acceptI  *      a identifier name representing the target group or it will accept E  *      a numeric identifier value. The numeric identifier must be an %  *      octal group identifier value.   *H  *      NEXT_UIC will display the next unused UIC value for the new userI  *      based on the parameter or qualifier entered. Disabled or inactive M  *      UIC values are not evaluated, since DISUSERed accounts can have files G  *      in various locations which can and have created problems during   *      security audits.  *I  *      07-Sep-04: Added SYMBOLS qualifier. Thanks to Jeremy Begg for the @  *      suggestion and code samples. Use of SYMBOLS is optional.  *E  *      Next_Uic displays output as three octal digits for both group H  *      and member values. This will permit up to 511 users. If a largerG  *      number if users requires higher resolution, change the 'printf'   *      statements as follows:=  *          From: printf("\nNext Octal Uic: [%03o,%03o]\n\n"  <  *            To: printf("\nNext Octal Uic: [%06o,%06o]\n\n"  *D  *      This application must be relinked if the current VMS version/  *      is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.3-5" #pragma module NEXT_UIC VERSION     #include <stdio.h> #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <libclidef.h> #include <lib$routines.h>  #include <rms.h> #include <string.h>  #include <ssdef.h> #include <uaidef.h>  #include <uicdef.h>  #include "sysuaf.h"     struct FAB  fab; struct RAB  rab;    #define START 1 
 #define END 2     char CmdVerb[32];     int BinUic;  int MaxUic;  int RmsStat;    short HeaderDone = FALSE;  short GroupFlg = FALSE;  short ListFlg = FALSE; short SymbolFlg = FALSE; short count = 0;    struct UAF uafrec;    globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     globalvalue NEXT_UIC_CLD;             N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ListStats D  * Description: Display statistical summary regarding info collected  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ListStats(int stage)  { $     char    Boldoff[] = {"\033[0m"};#     char    Boldon[] = {"\033[1m"};         if(stage == START) {>         printf("\n %s%-16s %-16s %s%s \n", Boldon, "Username",%             "Uic", "Owner", Boldoff);          HeaderDone = TRUE;     } ?     if(stage == END) printf("\n Summary: %d Users\n\n", count);  }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowVersH  * Description: User entered the /VERSION qualifier to display the imageH  *              version, C compiler type, and required image privileges.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowVers()  { 3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb); 0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);-     printf("\t\tRequired Privs: SYSPRV\n\n");      exit(1); }    L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowHelpA  * Description: User entered the /HELP qualifier to get a list of @  *             parameters and qualifiers available to this image  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 1     printf("\n\n %s (%s)\n\n", CmdVerb, VERSION);       printf("   Parameters\n\n");F     printf("     USERNAME - Any username within the group where a\n");E     printf("\t\tuser is to be added. The next avilable UIC value\n"); J     printf("\t\twill be displayed for that partiular group. Note that\n");?     printf("\t\tmissing and DISUSERed UICs are not reused.\n"); P     printf("\t\tOptional, not needed if /GROUP or /LIST_GROUP is entered.\n\n");      printf("   Qualifiers\n\n");M     printf("     /GROUP=xxx - Symbolic or numeric group identifier value\n"); 9     printf("\t\trepresenting the group to add a uic.\n"); C     printf("\t\tOptional, not needed if USERNAME is entered.\n\n"); S     printf("     /LIST_GROUP=xxx - if present, %s will display a list\n", CmdVerb); N     printf("\t\tof all users withing that group. The entered value can be\n");J     printf("\t\teither an identifier name or an octal group number.\n\n");T     printf("     /SYMBOLS - if present, %s defines global DCL symbols:\n", CmdVerb);=     printf("\t\tNEXT_UIC_GRP - the group number in octal\n"); >     printf("\t\tNEXT_UIC_MEM - the member number in octal\n");2     printf("\t\tNEXT_UIC_UIC - the full UIC\n\n");E     printf("     /HELP - if present, %s displays list of ", CmdVerb); L     printf("parameters and \n\t\tqualifiers available for %s\n\n", CmdVerb);M     printf("     /VERSION - if present %s displays version, build", CmdVerb); 1     printf(" date,\n\t\tand required privs\n\n");      exit();  }    H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }      } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }          J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetGroupEntry C  * Description: User entered a group identifier, either symbolic or C  *              numeric. Determine identifier format, then validate E  *              the identifier. If valid identifier, copy numeric uic F  *              longword to 'uafrec.uic' and if entry was with numericI  *              identifier in ascii, set actual identifier name to Ident. G  *              Last, return overal status of this operation to caller.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetGroupEntry(char *Ident) {      int GrpStat = 0;     int BinIdent = 0;      int BinMask = 0;     short length = 0;      char IdentStr[32];"     $DESCRIPTOR(Dsc_Id, IdentStr);   5         /* first test if valid symbolic identifier */         strcpy(IdentStr, Ident);+     Dsc_Id.dsc$w_length = strlen(IdentStr); 8     GrpStat = sys$asctoid(&Dsc_Id, &BinIdent, &BinMask);   D         /* if status is not SS$_NORMAL then assume octal group id */        if(GrpStat != SS$_NORMAL) { *         sscanf(IdentStr, "%o", &BinIdent);-         BinIdent = 0xffff | (BinIdent << 16); /         Dsc_Id.dsc$w_length = sizeof(IdentStr); J         GrpStat = sys$idtoasc(BinIdent, &length, &Dsc_Id, 0, &BinMask, 0);2         if(GrpStat != SS$_NORMAL) return(GrpStat);         IdentStr[length] = 0;           strcpy(Ident, IdentStr);        }      BinUic = BinIdent;     return(SS$_NORMAL);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowGroupInfo @  * Description: Display Username, Uic, and Owner values for user7  *              record currently in structure 'uafrec'.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowGroupInfo() {      char FaoArgI[] = "!%I";      char FaoArgU[] = "!%U";      char OwnerStr[48];     char UicStrI[60];      char UicStrU[60];      char UserName[32];     char *ptr1;      char *ptr2;         int status;      int uic;        short length;    #     $DESCRIPTOR(Dsc_FaoI, FaoArgI); #     $DESCRIPTOR(Dsc_FaoU, FaoArgU); #     $DESCRIPTOR(Dsc_UicI, UicStrI); #     $DESCRIPTOR(Dsc_UicU, UicStrU);    6     uic = (uafrec.uaf$w_grp << 16) | uafrec.uaf$w_mem;1     strncpy(UserName, uafrec.uaf$t_username, 13);      UserName[12] = 0;      ptr2 = &uafrec.uaf$t_owner;      length = (short) *ptr2; "     ptr1 = uafrec.uaf$t_owner + 1;      strncpy(OwnerStr, ptr1, 31);     OwnerStr[length] = 0; 9     status = sys$fao(&Dsc_FaoU, &length, &Dsc_UicU, uic);      UicStrU[length] = 0;>     printf(" %-16s %-16s %s \n", UserName, UicStrU, OwnerStr); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CreateGrpList :  * Description: Display a list of users within a specified  *              uic group   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CreateGrpList() { ?         /* since we have the first record, display user info */         ListStats(START);      ShowGroupInfo();     count++;   >         /* find all valid uic values for this group by reading.            all records with target group id */   @     MaxUic = BinUic;                    /* longword uic value */=     rab.rab$l_kbf = (char *) &MaxUic;   /* RAB$M_LIM value */ K     RmsStat = SYS$GET(&rab);            /* get same record using uic key */ -     MaxUic = (MaxUic + 0x10000) & 0xFFFF0000; J     rab.rab$l_rop = RAB$M_LIM;          /* limit max to value in MaxUic */G     rab.rab$b_rac = RAB$C_SEQ;          /* sequential record access  */    H         /* read each record in this uic group until we get a record withG            the group value higher than selected group, or EOF. Then add G            one to the last uid value and display next uic available for             this group */        while(RmsStat & 1) {          RmsStat = SYS$GET(&rab);;         if(RmsStat == RMS$_OK_LIM || RmsStat == RMS$_EOF) {              ListStats(END);              break;	         }          else {?             BinUic = uafrec.uaf$w_grp << 16 | uafrec.uaf$w_mem;              ShowGroupInfo();             count++;	         }      }      RmsStat = SYS$CLOSE(&fab);     exit(RmsStat); }   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *"  *    Function: CreateGlobalSymbolG  * Description: If the commandline qualifier SYMBOLS is present and the I  *              LIST_GROUP qualifier is not present, NEXT_UIC will create L  *              3 dcl symbols, NEXT_UIC_GRP, NEXT_UIC_MEM, and NEXT_UIC_UIC.I  *              The above symbols are created in the global symbol table.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 9 void CreateGlobalSymbol (char *SymbName, char *SymbValue)  {      int SymbStat = 0; %     int Table = LIB$K_CLI_GLOBAL_SYM;   $     $DESCRIPTOR(Dsc_Name, SymbName);&     $DESCRIPTOR(Dsc_Value, SymbValue);  -     Dsc_Name.dsc$w_length = strlen(SymbName); /     Dsc_Value.dsc$w_length = strlen(SymbValue);   =     SymbStat = lib$set_symbol(&Dsc_Name, &Dsc_Value, &Table); .     if(SymbStat != SS$_NORMAL) exit(SymbStat);   }      J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: main  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int main() {*     int     BinKey;*     int     CliStat;     int     LastUic;     int     status;   %     short   CliStrLen;     short   CmdLen;      short   LastGid;     short   LastUid;     short   NoSuchId = FALSE;      short   TargetLen;     short   TargetGid = 0;     short   TestGid = 0;   >     char    CliStr[80];                 /* CLI sting buffer */N     char    CmdLine[132];               /* buffer reflecting input cmd line */     char    LineBuf[132]; N     char    Target[32];                 /* entered username in target group */H     char    UicSymbStr[32];             /* used to create Dcl symbols */     char    *ptr;          K     $DESCRIPTOR(Dsc_Cli, CliStr);       /* cli param or qualifier string */ J     $DESCRIPTOR(Dsc_Cmd, CmdLine);      /* user supplied input cmd line */#     $DESCRIPTOR(Dsc_Lbuf, LineBuf);_"     $DESCRIPTOR(Dsc_Trgt, Target);#     $DESCRIPTOR(Dsc_Verb, CmdVerb);         fab = cc$rms_fab;h     rab = cc$rms_rab;e  s!     fab.fab$b_shr = FAB$M_SHRPUT;s!     fab.fab$b_fac = FAB$M_SHRGET;      fab.fab$l_fna = "SYSUAF";,*     fab.fab$b_fns = strlen(fab.fab$l_fna);&     fab.fab$l_dna = "SYS$SYSTEM:.DAT";*     fab.fab$b_dns = strlen(fab.fab$l_dna);  u6         /* assuming user will enter a username string,&            so setup for primary key */        rab.rab$l_fab = &fab; %     rab.rab$l_ubf = (char *) &uafrec; #     rab.rab$w_usz = sizeof(uafrec);t     rab.rab$l_kbf = Target;x:     rab.rab$b_krf = 0;          /* assume key 0 for now */     rab.rab$b_rac = RAB$C_KEY;   <         /* get the command line used to invoke this image */  eO     status = GetCmdLine(&Dsc_Cmd, &CmdLen);  /* get invoking foreign cmd str */e*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';n   3         /* extract foreign cmd verb from CmdLine */g  l#     sscanf(CmdLine, "%s", CmdVerb);1     ptr = strchr(CmdVerb, '/');t     if(ptr) *ptr = '\0';,     Dsc_Verb.dsc$w_length = strlen(CmdVerb);.     status = str$upcase(&Dsc_Verb, &Dsc_Verb);   G         /* get parameter and qualifier(s) from command line, prefix thewL            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */  n6     status = lib$get_foreign(&Dsc_Cmd, 0, &CmdLen, 0);*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';e!     strcpy(LineBuf, "NEXT_UIC ");      strcat(LineBuf, CmdLine);v,     Dsc_Lbuf.dsc$w_length = strlen(LineBuf);J     CliStat = cli$dcl_parse(&Dsc_Lbuf, NEXT_UIC_CLD, lib$get_input, 0, 0);,     if(CliStat != CLI$_NORMAL) exit(status);  r>         /* if user typed /HELP then show help text and exit */        strcpy(CliStr, "HELP");d9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer);s$     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowHelp();s  i     strcpy(CliStr, "VERSION");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer);n$     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowVers();l  i=         /* if user typed /GROUP, get group qualifier value */   t+     strcpy(Dsc_Cli.dsc$a_pointer, "GROUP");r9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer);U$     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) {dA         CliStat = cli$get_value(&Dsc_Cli, &Dsc_Trgt, &TargetLen); !         Target[TargetLen] = '\0';r*         Dsc_Trgt.dsc$w_length = TargetLen;         GroupFlg = TRUE;(         status = GetGroupEntry(&Target);<         if(status == SS$_NORMAL || status == SS$_NOSUCHID) {(             if(status == SS$_NOSUCHID) {                  NoSuchId = TRUE;.                 sscanf(Target, "%o", &BinKey);&                 BinUic = BinKey << 16;                  BinKey = BinUic;
             }t	         } :         else exit(status);  /* some other error occured */   E         MaxUic = BinUic;                        /* group uic value */cM         if(BinKey != BinUic) BinKey = BinUic & 0xffff0000;   /* pseudo key */*M         rab.rab$b_krf = 1;                      /* using key 1, binary uic */f)         rab.rab$l_kbf = (char *) &BinKey;I         rab.rab$b_ksz = 4;     }   c;         /* if user typed /LIST_GROUP some users in group */   c0     strcpy(Dsc_Cli.dsc$a_pointer, "LIST_GROUP");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer);i$     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) {tA         CliStat = cli$get_value(&Dsc_Cli, &Dsc_Trgt, &TargetLen); !         Target[TargetLen] = '\0';U*         Dsc_Trgt.dsc$w_length = TargetLen;         ListFlg = TRUE;r(         status = GetGroupEntry(&Target);<         if(status == SS$_NORMAL || status == SS$_NOSUCHID) {(             if(status == SS$_NOSUCHID) {                  NoSuchId = TRUE;.                 sscanf(Target, "%o", &BinKey);&                 BinUic = BinKey << 16;                  BinKey = BinUic;
             }*	         }*:         else exit(status);  /* some other error occured */  *E         MaxUic = BinUic;                        /* group uic value */ M         if(BinKey != BinUic) BinKey = BinUic & 0xffff0000;   /* pseudo key */ M         rab.rab$b_krf = 1;                      /* using key 1, binary uic */r)         rab.rab$l_kbf = (char *) &BinKey;a         rab.rab$b_ksz = 4;     }%  1  %/         /* see if user reuqested DCL symbols */U       strcpy(CliStr, "SYMBOLS");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);1     if(CliStat == CLI$_PRESENT) SymbolFlg = TRUE;*  *:         /* get entered username to determine target group.>            This is ignored if valid group qualifier entered */  i     if(!GroupFlg && !ListFlg) {c1         strcpy(Dsc_Cli.dsc$a_pointer,"USERNAME");*=         Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer);*(         CliStat = cli$present(&Dsc_Cli);%         if(CliStat != CLI$_PRESENT) {V5             printf("\nUsage: %s /HELP\n\n", CmdVerb);;             exit(SS$_NORMAL);%	         }E         else {E             CliStat = cli$get_value(&Dsc_Cli, &Dsc_Trgt, &TargetLen);*%             Target[TargetLen] = '\0';*.             Dsc_Trgt.dsc$w_length = TargetLen;&             rab.rab$b_ksz = TargetLen;	         }i     }    <         /* open sysuaf, get a uaf record for target group */        RmsStat = SYS$OPEN(&fab);*%     if(!(RmsStat & 1)) exit(RmsStat);*      RmsStat = SYS$CONNECT(&rab);%     if(!(RmsStat & 1)) exit(RmsStat);n  CK         /* if we are performing an IDENTIFIER lookup, just use the suppliedMI            username for key 0 value. if we are performing a GROUP lookup,bI            perform key 1 read of sysuaf using a key with target GID and ae+            null UID, currently in BinKey */   r     if(GroupFlg || ListFlg) { O         rab.rab$l_rop = RAB$M_EQNXT;    /* read records for key1 group value */SJ         rab.rab$b_rac = RAB$C_KEY;      /* this should not have changed */         rab.rab$b_krf = 1;N         rab.rab$l_kbf = (char *) &BinKey;  /* key is now longword uic value */         rab.rab$b_ksz = 4;         status = SYS$GET(&rab);R)         if(!(RmsStat & 1)) exit(RmsStat);/;         BinUic = uafrec.uaf$w_grp << 16 | uafrec.uaf$w_mem;r     } K     else {                  /* use key-0, symbolic identifier (username) */           RmsStat = SYS$GET(&rab);1         if(RmsStat != RMS$_NORMAL) exit(RmsStat);f;         BinUic = uafrec.uaf$w_grp << 16 | uafrec.uaf$w_mem;n@         MaxUic = BinUic;                /* longword uic value */K         LastUic = BinUic;               /* in case this is last in group */          rab.rab$b_krf = 1;         rab.rab$b_ksz = 4;     }   /D         /* if user entered an invalid group id, it will show up hereG            (tested manually as RAB$M_LIM is not yet active for 'rop' */"        if(GroupFlg || ListFlg) {a!         TargetGid = BinKey >> 16;          TestGid = BinUic >> 16;p5         if(TestGid != TargetGid) exit(SS$_INVUICGRP);*     }*  *=     if(ListFlg) CreateGrpList();    /* print group summary */e  dB         /* find all valid uic values for this group, always savingD            the last one retrieved. When we pass the limit range, add=            one to member field, this is next available uic */e  n@     MaxUic = BinUic;                    /* longword uic value */K     LastUic = BinUic;                   /* in case this is last in group */s=     rab.rab$l_kbf = (char *) &MaxUic;   /* RAB$M_LIM value */aK     RmsStat = SYS$GET(&rab);            /* get same record using uic key */u-     MaxUic = (MaxUic + 0x10000) & 0xFFFF0000;tJ     rab.rab$l_rop = RAB$M_LIM;          /* limit max to value in MaxUic */G     rab.rab$b_rac = RAB$C_SEQ;          /* sequential record access  */s  eH         /* read each record in this uic group until we get a record withG            the group value higher than selected group, or EOF. Then addrG            one to the last uid value and display next uic available fort            this group */  l     while(RmsStat & 1) {          RmsStat = SYS$GET(&rab);?         if((RmsStat == RMS$_OK_LIM) || (RmsStat == RMS$_EOF)) {n$             LastGid = LastUic >> 16;-             LastUid = (LastUic & 0xFFFF) + 1;u             if(!ListFlg) {;                 printf("\nNext Octal Uic: [%03o,%03o]\n\n",b.                             LastGid, LastUid);O                 if(SymbolFlg) {     /* Define DCL symbols for current values */f9                     sprintf(UicSymbStr, "%03o", LastGid); C                     CreateGlobalSymbol("NEXT_UIC_GRP", UicSymbStr);L9                     sprintf(UicSymbStr, "%03o", LastUid);;C                     CreateGlobalSymbol("NEXT_UIC_MEM", UicSymbStr);cI                     sprintf(UicSymbStr, "[%03o,%03o]", LastGid, LastUid);oC                     CreateGlobalSymbol("NEXT_UIC_UIC", UicSymbStr);                  }e
             }=H             break;  /* not sure why this is here, but it does no harm */	         } @         else BinUic = uafrec.uaf$w_grp << 16 | uafrec.uaf$w_mem;         LastUic = BinUic;n     }e  n     RmsStat = SYS$CLOSE(&fab);     exit(RmsStat); }l  c /* end of NEXT_UIC.C */ 