! MMS description file for Mosaic
! Bjorn S. Nilsson, Aleph, CERN, 21-Nov-1993
! (Mosaic version 2.0)
! Motif 1.2 support added on 3-Jun-1994
! Mosaic 2.4 on 20-Aug-1994
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
!       $ MMS/MACRO=(MULTINET=1)        for MultiNet
! Add a DEBUG=1  macro when debugging.
! Add a DECC=1   macro when compiling with DEC C.
! Add a NOWAIS=1 macro when excluding direct WAIS support
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

! Define your home page, default print command and mail prefix here:
HOME="HOME_PAGE_DEFAULT=""http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/NCSAMosaicHome.html"""
PRINT_COMMAND ="PRINT_DEFAULT=""Print/Name=\""From Mosaic\""/Notify/Identify/Delete"""
MAIL_PREFIX="MAIL_PREFIX_DEFAULT=""in%"""

! If your server does not have 17 pt fonts or Lucida fonts, keep the next line
! as is, else remove NO_17_PT,NO_LUCIDA,
VMS_DEFS = $(HOME),$(PRINT_COMMAND),$(MAIL_PREFIX),NO_17_PT,NO_LUCIDA,

NAME = MOSAIC
CC = CC

.IFDEF NOWAIS
.ELSE
LIBWAIS = [-.freeWAIS-0_3.ir]libWAIS.Olb
LIBWAISQ = ,$(LIBWAIS)/Lib
.ENDIF

.IFDEF MOTIF1_2
VMS_ALLDEFS = $(VMS_DEFS)MOTIF1_2,
.ELSE
VMS_ALLDEFS = $(VMS_DEFS)
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS		! GET OUR RULES
CQUALC=/Standard=VAXC $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=/Standard=VAXC
.ENDIF
.ENDIF
!VAX C
.ELSE
CQUALC=
.ENDIF

.IFDEF DEBUG
CQUAL =/NoOpt/Debug$(CQUALC)
LINK_OPTIONS =/Debug
.ELSE
CQUAL =$(CQUALC)
LINK_OPTIONS =/NoDebug/NoTrace
.ENDIF

.IFDEF MULTINET
.IFDEF DEBUG
CDEFS =/Define=($(VMS_DEFS)MULTINET,DEBUGVMS)
.ELSE
CDEFS =/Define=($(VMS_DEFS)MULTINET)
.ENDIF
OPTION_FILE = Multinet.Opt
TCP=MULTINET

.ELSE    ! Not MULTINET

.IFDEF PATHWAY
.IFDEF DEBUG
CDEFS =/Define=($(VMS_DEFS)WIN_TCP,DEBUGVMS)
.ELSE
CDEFS =/Define=($(VMS_DEFS)WIN_TCP)
.ENDIF
OPTION_FILE = PathWay.Opt
TCP=WIN_TCP

.ELSE  ! Not PATHWAY, i.e. UCX

.IFDEF DEBUG
CDEFS =/Define=($(VMS_DEFS)UCX,DEBUGVMS)
.ELSE
CDEFS =/Define=($(VMS_DEFS)UCX)
.ENDIF
.IFDEF DECC
OPTION_FILE = UCX_AXP.Opt
.ELSE
OPTION_FILE = UCX_VAX.Opt
.ENDIF
TCP=UCX
.ENDIF


.ENDIF
.IFDEF MOTIF1_2
LIBS = $(OPTION_FILE)/Opt,Motif1_2.Opt/Opt
.ELSE
LIBS = $(OPTION_FILE)/Opt,Motif1_1.Opt/Opt
.ENDIF

.FIRST
	@ Topdir = F$Environment("Default")-"SRC]"
	@ Define LIBWWW2  'Topdir'LIBWWW2]
	@ Define LIBXMX   'Topdir'LIBXMX]
	@ Define LIBHTMLW 'Topdir'LIBHTMLW]
.IFDEF PATHWAY
	@ @[-.TWG]DEF
.ELSE
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
	@ Define Netinet SYS
.ENDIF
.IFDEF DECC
.IFDEF PATHWAY
.ELSE
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS
.IFDEF MULTINET
	@ Define DECC$SYSTEM_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,SYS
.ELSE
	@ Define DECC$SYSTEM_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,SYS
.ENDIF
.ENDIF
.ELSE	! VAX C compilation
	@ Define VAXC$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS
	@ Define C$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS
.ENDIF

PROG_LIBS = [-.LIBHTMLW]LIBHTMLW.OLB [-.LIBXMX]LIBXMX.OLB [-.LIBWWW2]LIBWWW.OLB $(LIBWAIS)
PROG_LIBSQ = [-.LIBHTMLW]LIBHTMLW.OLB/LIB, [-.LIBXMX]LIBXMX.OLB/LIB, [-.LIBWWW2]LIBWWW.OLB/LIB $(LIBWAISQ)
 
CFILES = main.c gui.c gui-dialogs.c gui-menubar.c gui-documents.c mo-www.c\
  mo-dtm.c hotlist.c whine.c history.c\
  annotate.c pan.c grpan.c grpan-www.c audan.c globalhist.c img.c\
  picread.c xpmhash.c xpmread.c gifread.c pixmaps.c\
  medcut.c mo-hdf.c
OBJS = main.obj,gui.obj,gui-dialogs.obj,gui-menubar.obj,gui-documents.obj,mo-www.obj,\
  mo-dtm.obj,hotlist.obj,whine.obj,history.obj,\
  annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,globalhist.obj,img.obj,\
  picread.obj,xpmhash.obj,xpmread.obj,gifread.obj,pixmaps.obj,\
  medcut.obj,mo-hdf.obj

AUXCFILES =
AUXOBJS =

HFILES = mosaic.h

$(NAME).exe : $(OBJS) $(AUXOBJS) $(PROG_LIBS)
	LINK$(LINK_OPTIONS)/Exe=$(NAME).exe $(OBJS),$(PROG_LIBSQ),[]$(LIBS)
	@ Write SYS$Output "Linking done. Welcome to VMS Mosaic 2.4"

$(OBJS) : $(HFILES)

gui.obj : xresources.h

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.C

clean :
	Delete/Log *.OBJ;*
