$! Create Mosaic version 2.0 on VMS.
$! This command procedure compiles and links Mosaic 2.0 in one go.
$! For a more controlled build you can use MMS.
$! Options: DEBUG, LUCIDA, 17_PT, NOWAIS
$! Bjrn S. Nilsson, 25-Nov-1993
$! Motif 1.2 sensitivity added 2-June-1994
$! Mosaic 2.4 with WAIS Dec. 1994
$!
$! Define your home page, default print command and mail prefix here:
$ HOME          ="HOME_PAGE_DEFAULT=""""""http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/NCSAMosaicHome.html"""""""
$ PRINT_COMMAND ="PRINT_DEFAULT=""""""Print/Name=\""""From Mosaic\""""/Notify/Identify/Delete"""""""
$ MAIL_PREFIX   ="MAIL_PREFIX_DEFAULT=""""""in%"""""""
$ NEWSHOST      =""
$!
$ On Error Then GoTo The_End
$ On Control_Y Then GoTo The_End
$ Set Symbol/Scope=(NoGlobal,NoLocal)
$ Compiler = "VAXC"
$ If F$Search("SYS$System:DECC$Compiler.Exe") .NES. "" Then Compiler = "DECC"
$ pwd = F$Environment("Default")
$ Args = P1 + "," + P2 + "," + P3 + "," + P4 + "," + P5 + "," + P6 + "," +-
   P7 + "," + P8
$ Args = F$Edit(Args,"Collapse,UPCase")
$ If F$Locate("DEB",Args) .EQ. F$Length(Args)
$  Then
$   COpt = "/Optim"
$   LOpt = "/NoTrace"
$  Else
$   COpt = "/NoOptim/Debug"
$   LOpt = "/Debug"
$  EndIf
$ If Compiler .EQS. "DECC" Then COpt = COpt + "/Standard=VAXC"
$!
$ VMS_Extra = ""
$ If HOME          .NES. "" Then VMS_Extra = HOME + ","
$ If PRINT_COMMAND .NES. "" Then VMS_Extra = VMS_Extra + PRINT_COMMAND + ","
$ If MAIL_PREFIX   .NES. "" Then VMS_Extra = VMS_Extra + MAIL_PREFIX + ","
$ VMS_Extra = VMS_Extra + "NO_17_PT,NO_LUCIDA,"
$ If F$Locate("NO_17_PT",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("17_PT",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_17_PT,"
$  EndIf
$ If F$Locate("NO_LUCIDA",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("LUCIDA",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_LUCIDA,"
$  EndIf
$!
$ IP = "UCX"
$ If F$Trnlnm("MULTINET") .NES. "" Then IP = "MULTINET"
$ If F$Trnlnm("TWG$TCP")  .NES. "" 
$  Then 
$   IP     = "WIN_TCP"      ! let WIN_TCP be -- really PathWay
$   @[.twg]def.com          ! define the location of PathWay include files
$  EndIf
$ If IP .EQS. "MULTINET" .AND. Compiler .EQS. "DECC" Then -
   COpt = COpt + "/PREFIX=ANSI"
$!
$ Motif12 = ""
$ If F$Search("SYS$Update:DECW$Get_Image_Version.COM") .NES. ""
$  Then
$   Set Symbol/Scope=(Global,Local)
$   @SYS$Update:DECW$Get_Image_Version SYS$Share:DECW$XLibshr.EXE DECW$Version 
$   If (F$Length(DECW$Version) .NE. 0) .AND. -
     (F$Locate("V1.2", DECW$Version) .NE. F$Length(DECW$Version))
$    Then
$     Motif12 = "MOTIF1_2,"
$     Write SYS$Output "Your system has Motif 1.2"
$    EndIf
$   Set Symbol/Scope=(NoGlobal,NoLocal)
$  Else
$   Write SYS$Output "You do not seem to have DECW Motif installed correctly!"
$  EndIf
$ If F$Locate("DEB",Args) .NE. F$Length(Args) Then Show Symbol/Local *
$ LibWAIS = ""
$ WAISD = ""
$ Verify = F$Verify(1)
$ Define Sys SYS$Library
$ If Compiler .EQS. "DECC" .AND. F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" -
   Then Define Sys DECC$Library_Include
$ If F$Locate("NOWAIS",Args) .NE. F$Length(Args) Then GoTo After_WAIS
$!
$! Create [.freeWAIS-0_3.ir]libWAIS.olb
$!
$ Set Default [.freeWAIS-0_3.ir]
$ If F$Search("libWAIS.olb") .EQS. "" Then Library/Create/Log libWAIS.olb
$ Comp = "CC" + COpt + "/Define=''IP'"
$ 'Comp' cutil.c
$ 'Comp' futil.c
$ 'Comp' panic.c
$ 'Comp' ui.c
$ 'Comp' wmessage.c
$ 'Comp' wprot.c
$ 'Comp' wutil.c
$ 'Comp' zprot.c
$ 'Comp' ztype1.c
$ 'Comp' zutil.c
$ Library/Replace/Log libWAIS.olb *.obj
$ LibWAIS = ",[-.freeWAIS-0_3.ir]libWAIS.olb/lib"
$ WAISD = "DIRECT_WAIS,"
$ Define WAIS_IR 'F$Environment("Default")'
$ Set Default [-.-]
$After_WAIS:
$!
$! Create [.libwww2]libwww.olb
$!
$ Set Default [.libwww2]
$ If F$Search("libwww.olb") .EQS. "" Then Library/Create/Log libwww.olb
$ Comp = "CC" + COpt + "/Define=(''WAISD'''IP')"
$ Compn = Comp
$ If NEWSHOST .NES. ""
$  Then
$   Compn = Comp - ")"
$   Compn = Compn + ",DEFAULT_NEWS_HOST=""""""" + NEWSHOST + """"""")"
$  EndIf
$ 'Comp' HTAccess.c
$ 'Comp' HTAlert.c
$ 'Comp' HTAnchor.c
$ 'Comp' HTAtom.c
$ 'Comp' HTSort.c
$ 'Comp' HTChunk.c
$ 'Comp' HTFTP.c
$ 'Comp' HTFWriter
$ 'Comp' HTFile.c
$ 'Comp' HTFormat.c
$ 'Comp' HTGopher.c
$ 'Comp' HTInit.c
$ 'Comp' HTList.c
$ 'Comp' HTMIME.c
$ 'Comp' HTML.c
$ 'Comp' HTMLDTD.c
$ 'Comp' HTMLGen
$ 'Compn' HTNews.c
$ 'Comp' HTParse.c
$ 'Comp' HTPlain.c
$ 'Comp' HTMosaicHTML.c
$ 'Comp' HTString.c
$ 'Comp' HTTCP.c
$ 'Comp' HTTP.c
$ 'Comp' HTTelnet.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args) Then 'Comp' HTWSRC.c
$ 'Comp' HTWriter.c
$ 'Comp' SGML.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args)
$  Then
$   If Compiler .EQS. "DECC"
$    Then
$     Define/User DECC$User_Include 'F$Environment("Default")',WAIS_IR
$     Define/User DECC$System_Include 'F$Environment("Default")',WAIS_IR
$    Else
$     Define/User VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS$Library
$     Define/User C$Include 'F$Environment("Default")',WAIS_IR
$    EndIf
$   'Comp' HTWAIS.c
$  EndIf
$ 'Comp' HTIcon.c
$ 'Comp' HTCompressed.c
$ 'Comp' HTAAUtil.c
$ 'Comp' HTAssoc.c
$ 'Comp' HTUU.c
$ 'Comp' HTAABrow.c
$ Library/Replace/Log libwww.olb *.obj
$!
$! Create [.libhtmlw]libhtmlw.olb
$!
$ Set Default [-.libhtmlw]
$ If F$Search("libhtmlw.olb") .EQS. "" Then Library/Create/Log libhtmlw.olb
$ Comp = "CC" + COpt + "/Define=(MOTIF,XMOSAIC,''Motif12'''IP')"
$ 'Comp' HTML.c
$ 'Comp' HTMLlists.c
$ 'Comp' HTMLformat.c
$ 'Comp' HTMLparse.c
$ 'Comp' HTMLimages.c
$ 'Comp' HTMLwidgets.c
$ 'Comp' HTML-PSformat.c
$ 'Comp' HTMLjot.c
$ Library/Replace/Log libhtmlw.olb *.obj
$!
$! Create [.libxmx]libxmx.olb
$!
$ Set Default [-.libXmx]
$ If F$Search("libXmx.olb") .EQS. "" Then Library/Create/Log libXmx.olb
$ Comp = "CC" + COpt + "/Define=(''Motif12'''IP')"
$ 'Comp' Xmx.c
$ 'Comp' Xmx2.c
$ Library/Replace/Log libXmx.olb *.obj
$!
$! Compile the [.src] modules.
$!
$ Set Default [-.src]
$ Comp = "CC" + COpt + "/Define=(" + VMS_Extra + Motif12 + IP + ")"
$ Define Netinet SYS
$ Topdir = F$Environment("Default")-"SRC]"
$ Define LIBWWW2   'Topdir'LIBWWW2]
$ Define LIBXMX    'Topdir'LIBXMX]
$ Define LIBHTMLW  'Topdir'LIBHTMLW]
$ If Compiler .EQS. "DECC"
$  Then
$   Define DECC$User_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS
$   Define DECC$System_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS
$  Else
$   Define VAXC$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$   Define C$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$  EndIf
$ 'Comp' main.c
$ 'Comp' gui.c
$ 'Comp' gui-dialogs.c
$ 'Comp' gui-menubar.c
$ 'Comp' gui-documents.c
$ 'Comp' mo-www.c
$ 'Comp' mo-dtm.c
$ 'Comp' hotlist.c
$ 'Comp' whine.c
$ 'Comp' history.c
$ 'Comp' annotate.c
$ 'Comp' pan.c
$ 'Comp' grpan.c
$ 'Comp' grpan-www.c
$ 'Comp' audan.c
$ 'Comp' globalhist.c
$ 'Comp' img.c
$ 'Comp' picread.c
$ 'Comp' xpmhash.c
$ 'Comp' xpmread.c
$ 'Comp' gifread.c
$ 'Comp' pixmaps.c
$ 'Comp' medcut.c
$ 'Comp' mo-hdf.c
$!
$! Finally link ...
$!
$ Optfile = "''IP'.Opt"
$ If IP .EQS. "UCX"
$  Then
$   Optfile = "UCX_VAX.Opt"
$   If F$GetSYI("Arch_Name") .EQS. "Alpha" Then Optfile = "UCX_AXP.Opt"
$  EndIf
$ XMOptfile = "Motif1_1.Opt"
$ If Motif12 .NES. "" Then XMOptfile = "Motif1_2.Opt"
$ Link'LOpt'/Exe=mosaic.exe main.obj,gui.obj,gui-dialogs.obj,gui-menubar.obj,-
   gui-documents.obj,mo-www.obj,mo-dtm.obj,hotlist.obj,whine.obj,history.obj,-
   annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,globalhist.obj,-
   img.obj,picread.obj,xpmhash.obj,xpmread.obj,gifread.obj,pixmaps.obj,-
   medcut.obj,mo-hdf.obj,-
   [-.libhtmlw]libhtmlw.olb/Lib,[-.libxmx]libxmx.olb/Lib,-
   [-.libwww2]libwww.olb/Lib'LibWAIS',[]'Optfile'/Opt,'XMOptfile'/Opt
$ xxx = F$Verify(Verify)
$ Write SYS$Output "Linking done. Welcome to VMS Mosaic 2.4"
$ Set Default 'pwd'
$ Write SYS$Output "The executable is in [.src]Mosaic.exe"
$ Dir/Date=Modif/Size=All [.src]Mosaic.exe
$The_End:
$ xxx = F$Verify(Verify)
$ If F$Trnlnm("SYS","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SYS
$ If F$Trnlnm("NETINET","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process NETINET
$ If F$Trnlnm("LIBHTMLW","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBHTMLW
$ If F$Trnlnm("LIBWWW2","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBWWW2
$ If F$Trnlnm("DECC$User_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$User_Include
$ If F$Trnlnm("DECC$System_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$System_Include
$ If F$Trnlnm("VAXC$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process VAXC$Include
$ If F$Trnlnm("C$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process C$Include
$ If F$Trnlnm("WAIS_IR","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process WAIS_IR
$ Set Default 'pwd'
