 $! Purpose: H $!	Extract, from a MAIL folder, parts of a VMS_SHARE'd package and write. $!	them into files into the current directory.D $!	The subject line is used as the key, and is expected to be in the= $!	format generated by the related utility -- PAKMAIL, i.e. :  $!: $!	     xxx.nnn-OF-mmm  ... optional comment text here ... $! $!	 $!	where:  $!	  xxx = package name  $!	  nnn = current part number $!	  mmm = total parts $!A $!      Older part format identifiers are recognized too, namely: 5 $!	    xxx.n_OF_m  ... Optional comment text here ... 2 $!	    xxx n/m  ... Optional comment text here ... $!E $!	The files which are generated have the same format for their names  $!	i.e.  $! $!	     xxx.nnn-OF-mmm $!F $!	It is important that the folder is not modified during execution ofE $!	this procedure, other than to add new messages at the end. Failure E $!	to observe this restriction can result in the wrong messages being ! $!	extracted into external files.  $! $! Parameters: $!	P1	Package name/ $!	P2	Expected number of parts (`mmm' in above) 6 $!	P3	folder containing the package (default: NEWMAIL)7 $!	P4	Flag to suppress auto-combining/editing of parts.  $!		(if =NOJOIN) $! $! Privileges: $!	NONE  $! $! Environment:  $!	VMS 5.0 or above < $!	Works only with packages sent using PAKMAIL 2.0 and above $! $! Revision History:A $!	1.0	Andy Harper	19-FEB-1993	Original Version for VMS_SHARE 8.3 A $!	1.1	Andy Harper	24-MAY-1993	Add auto-joining and NOJOIN option  $  $ set="set" % $ set symbol/scope=(nolocal,noglobal) 
 $ set noonM $ em="write sys$error ""%"+f$parse(f$environment("PROCEDURE"),,,"NAME")+"""," 7 $ tempcom1 = "SYS$SCRATCH:DIRCM1." + f$getjpi("","PID") 7 $ tempcom2 = "SYS$SCRATCH:DIRCM2." + f$getjpi("","PID") 7 $ tempout  = "SYS$SCRATCH:DIROUT." + f$getjpi("","PID")  $ P $ em "-I-VERSION, PAKEXTRACT 1.1 -- ", f$cvtime(,,"WEEKDAY"), f$fao(", !20%D",0) $  $ M $! -------------------------------------------------------------------------- ( $! Break out parameters and set defaultsM $! --------------------------------------------------------------------------  $ package        = P1 
 $Get_Package:  $ if package .eqs. ""  $   thenD $     read/prompt=" * Package name : "/end=abort sys$command package- $     package = f$edit(package,"TRIM,UPCASE")  $     goto Get_Package $ endif  $ , $ if f$parse(package,,,"NAME") .nes. package $   thenE $     em "-E-INVPACKN, Package name invalid - specify NAME part only"  $     goto abort $ endif  $  $ expected_parts = p2  $Get_Parts:  $ if expected_parts .eqs. "" $   thenK $     read/prompt=" * Total parts  : "/end=abort sys$command expected_parts ; $     expected_parts = f$edit(expected_parts,"TRIM,UPCASE")  $     goto Get_Parts $ endif  $ + $ if f$type(expected_parts) .nes. "INTEGER"  $   then4 $     em "-E-NOTNUM,  Total parts value not numeric" $     goto abort $ endif  $  $ if expected_parts .lt. 1 $   then; $     em "-E-NOTPOS,  Total parts value must be at least 1"  $     goto abort $ endif  $  $ folder         = P3 . $ if folder .eqs. "" then $ folder = "NEWMAIL" $  $ M $! --------------------------------------------------------------------------   $! Trap aborts and tidy up filesM $! --------------------------------------------------------------------------   $ on CONTROL_Y then $ goto abort $  $ M $! -------------------------------------------------------------------------- G $! Since we can't pass parameters to MAIL, we write a command procedure L $! containing the necessary data to generate a directory listing of matching$ $! messages in the specified folder.M $! -------------------------------------------------------------------------- & $ open/write PAKEXTRACT_COM1 &tempcom1  $ write PAKEXTRACT_COM1 "$ mail"= $ write PAKEXTRACT_COM1 "  DIR ''folder' /SUBJECT=''package'"  $ close PAKEXTRACT_COM1  $  $ M $! -------------------------------------------------------------------------- K $! Now run the procedure to create the directory of matching subject fields M $! -------------------------------------------------------------------------- B $ em "-I-DIRSCAN, Scanning MAIL folder ", folder, " for ", package $ @&tempcom1/out=&tempout # $ delete/nolog/noconfirm &tempcom1.  $  $ M $! -------------------------------------------------------------------------- D $! Read back the info and build a procedure to extract the data into $! separate parts M $! -------------------------------------------------------------------------- A $ em "-I-PROCESS, Processing list of messages matching ", package E $ open/read       PAKEXTRACT_DATA &tempout	! Read back directory data 
 $startdir:( $ read/end=nodata PAKEXTRACT_DATA recordH $ if f$extract(0,1,f$edit(record,"TRIM")) .nes. "#" then $ goto startdir( $ read/end=nodata PAKEXTRACT_DATA record $ A $ open/write      PAKEXTRACT_COM2 &tempcom2	! For extraction info @ $ write           PAKEXTRACT_COM2 "$ define/user sys$output NL:"* $ write           PAKEXTRACT_COM2 "$ mail"L $ write           PAKEXTRACT_COM2 "  select ", folder, " /subject=", package $  $ M $! -------------------------------------------------------------------------- K $! Read the next line of data, parse the subject line, and get the filename K $! We must still manually parse the subject line since the package name may I $! appear in other contexts that have no relation to the package we want! M $! --------------------------------------------------------------------------  $ N = 0  $ M = 0  $nextentry: / $ read/end=NoMoreParts   PAKEXTRACT_DATA record  $ N = N + 1 4 $ subject = f$extract(40,f$length(record)-40,record) $  $ M $! -------------------------------------------------------------------------- R $! Parse the line into the package name and part numbers and check for consistencyM $! --------------------------------------------------------------------------  $ gosub Parse_Subject # $ if .not. OK then $ goto nextentry  $  $ M $! -------------------------------------------------------------------------- A $! What we have looks like a valid part identifier, so process it M $! -------------------------------------------------------------------------- L $ file=f$fao("!AS.!#ZL-OF-!AS",package,f$length(totpart),'thispart',totpart)! $ em "-I-PARTFND, Located ", file   $ if totpart .ne. expected_parts $   then[ $     em "-W-MISPRTSI, Total parts mismatch (Found ''totpart', expected ''expected_parts')"  $     goto nextentry $ endif : $ if (thispart .lt. 1) .or. (thispart .gt. expected_parts) $   thenR $     em "-W-OUTRANGE, Part number ", thispart, " out of range 1-", expected_parts $     goto nextentry $ endif  $ ( $ write PAKEXTRACT_COM2 "   read ",    N2 $ write PAKEXTRACT_COM2 "   extract/nohead ", file $ M=M+1  $ goto nextentry $  $ M $! -------------------------------------------------------------------------- & $! Run out of mail messages to processM $! -------------------------------------------------------------------------- 
 $NoMoreParts:  $ close PAKEXTRACT_COM2  $ close PAKEXTRACT_DATA " $ delete/nolog/noconfirm &tempout. $  $ M $! -------------------------------------------------------------------------- J $! Let's see if the directory search found any valid parts; give up if notM $! --------------------------------------------------------------------------   $ if M .eq. 0 then $ goto nodata $  $ M $! -------------------------------------------------------------------------- C $! Run the generated procedure and extract the parts to files !!!!! M $! -------------------------------------------------------------------------- 1 $ em "-I-EXTRACT, Extracting parts - please wait"  $ @&tempcom2# $ delete/nolog/noconfirm &tempcom2.  $  $ M $! -------------------------------------------------------------------------- I $! Loop through the generated files to ensure that all required parts are  $! present. M $! -------------------------------------------------------------------------- ! $ em "-I-CHKPART, Checking parts"  $ N = 0  $ M = 0 	 $chkpart:  $ N = N + 1  $ if N .le. expected_parts $   thenW $     file = f$fao("!AS.!#ZL-OF-!AS",package,f$length(expected_parts),N,expected_parts)   $     if f$search(file) .eqs. "" $       then> $         em "-W-NOPART,  Part ", N, " has not been extracted" $       else $         M=M+1  $     endif  $     goto chkpart $ endif  $  $ M $! -------------------------------------------------------------------------- > $! If we get here with M=totpart, all parts were extracted OK;M $! --------------------------------------------------------------------------  $ if M .ne. expected_parts $   thenS $     em "-E-MISPART, One or more parts of ", package, " missing. Processing ended"  $     goto abort $ endif  $  $ M $! -------------------------------------------------------------------------- J $! Unless told not To (NOJOIN), remove the headers from the first part andL $! combine them into a single .SHAR file in the right order, then delete all $! the individual parts.M $! -------------------------------------------------------------------------- 2 $ if f$locate(P4,"NOJOIN") .ne. 0 .or. P4 .eqs. "" $   then $ < $     em "-I-JOINING, Joining parts to form ''package'.SHAR" $ / $   ! Edit the mail headers from the first part W $     file = f$fao("!AS.!#ZL-OF-!AS",package,f$length(expected_parts),1,expected_parts)   $     define/user sys$output nl:& $     edit/edt/command=sys$input &file delete 1:"$! ----" exit $     if .not. $status $       thenC $         em "-E-CANTREM, Unable to remove headers from first part" G $         em "-I-NODELE,  Extract parts available separately as ", file  $         goto abort $     endif  $  $   ! Purge down the first part ! $     purge/nolog/noconfirm &file  $ 0 $   ! Combine the parts into a single share fileU $     file = f$fao("!AS.!#*%-OF-!AS",package,f$length(expected_parts),expected_parts)  $ L $   ! Old algorithm - uses wildcard append to join files; fast but uses lots $   ! of disk space , $!    append/new/nolog 'file' 'package'.SHAR $!    if .not. $status $!      thenG $!        em "-E-NOSHAR,  Share file creation error. May be incomplete" I $!        em "-I-NODELE,  Extracted parts available separately as ", file  $!        goto abort $!    endif % $!    delete/nolog/noconfirm 'file';*  $ K $   ! New algorithm - appends/deletes each file separately; slower but uses  $   ! less disk space  $     create 'package'.shar  $   Append_Part: $     part = f$search(file) - $     if part .eqs. "" then $ goto end_append ( $     append/nolog 'part' 'package'.shar $     if .not. $status $       then@ $         part = f$parse(part,,,"name") + f$parse(part,,,"type")E $         em "-E-NOSHAR,  Share file creation error appending ", part 9 $         em "-I-INCOMP,  ''package'.SHAR is incomplete."  $         goto abort $     endif # $     delete/nolog/noconfirm 'part'  $     goto Append_Part $   End_Append:  $ , $  ! Confirmation of success if we get here.< $     em "-I-SHAREOK, Share file ''package'.SHAR created OK"N $     em "-I-UNPACK,  To unpack the files, Issue the command @''package'.shar" $ endif  $  $ M $! -------------------------------------------------------------------------- K $! We get here if user aborts the procedure (or fall thru from normal exit) M $! --------------------------------------------------------------------------  $abort: F $ if f$trnlnm("PAKEXTRACT_COM1") .nes. "" then $ close PAKEXTRACT_COM1F $ if f$trnlnm("PAKEXTRACT_COM2") .nes. "" then $ close PAKEXTRACT_COM2F $ if f$trnlnm("PAKEXTRACT_DATA") .nes. "" then $ close PAKEXTRACT_DATAR $ if f$search(tempcom1)        .nes. "" then $ delete /nolog/noconfirm &tempcom1;*R $ if f$search(tempcom2)        .nes. "" then $ delete /nolog/noconfirm &tempcom2;*Q $ if f$search(tempout)         .nes. "" then $ delete /nolog/noconfirm &tempout;*  $ exit $  $ M $! -------------------------------------------------------------------------- @ $! We get here if the DIR found no subjects matching the packageM $! --------------------------------------------------------------------------  $nodata:, $ em "-E-NOPARTS, No matching parts located" $ goto abort $  $  $! M $! --------------------------------------------------------------------------  $! PARSE SUBJECT $!K $! This routine parses the subject line to extract the name and part number N $! of the mailed part. The subject line, for historical reasons, can be in any $! of the following formats: $!) $!	package.nnn-OF-mmm		Most recent format  $!	package.n_OF_m			old format# $!	package  n/m			really old format 4 $!      package  n|m			Dyslexic version of the above  $!      package  n\m			Ditto ... $!I $! If the subject line fails to fatch any of these formats, then it's not  $! a part matching this package  $!
 $! Inputs:, $!	package		The name of the required package$ $!	subject		The current subject line $! $! Outputs: ' $!	OK		True if a valid part, else False 5 $!	thispart	The current part number (if a valid part) 5 $!	totpart		The maximum part number (if a valid part)  $!M $! --------------------------------------------------------------------------  $Parse_Subject:   $! Assume we find a valid part..
 $ OK = "TRUE"  $ D $! Look for the `package.nnn-OF-mmm' or the `package.n_OF_m' formatsC $ name = f$element(0,".",subject)	! Pull out package name `xxxxxxx'  $ if name .eqs. package  $   then6 $     type = f$element(0," ",f$element(1,".",subject)) $  $   ! package.nnn-OF-mmm& $     thispart = f$element(0,"-",type)& $     totpart  = f$element(2,"-",type) $ 6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -6          f$element(1,"-",type) .eqs. "OF"      .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $  $   ! package.ext_nnn-OF-mmm& $     thispart = f$element(0,"-",type)& $     totpart  = f$element(2,"-",type) $ 6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -6          f$element(1,"-",type) .eqs. "OF"      .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $  $   ! package.n_OF_m& $     thispart = f$element(0,"_",type)& $     separator= f$element(1,"_",type)& $     totpart  = f$element(2,"_",type) $ 6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -6          f$element(1,"_",type) .eqs. "OF"      .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $ endif  $  $ * $! Look for the `package[.ext] n/m' format2 $ name = f$element(0,".",f$element(0," ",subject)) $ if name .eqs. package  $   thenH $     type = f$element(1," ",f$edit(subject,"TRIM,COMPRESS"))	! Get  n/m& $     thispart = f$element(0,"/",type)& $     totpart  = f$element(1,"/",type)6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $ endif  $ * $! Look for the `package[.ext] n|m' format2 $ name = f$element(0,".",f$element(0," ",subject)) $ if name .eqs. package  $   thenH $     type = f$element(1," ",f$edit(subject,"TRIM,COMPRESS"))	! Get  n/m& $     thispart = f$element(0,"|",type)& $     totpart  = f$element(1,"|",type)6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $ endif  $ * $! Look for the `package[.ext] n\m' format2 $ name = f$element(0,".",f$element(0," ",subject)) $ if name .eqs. package  $   thenH $     type = f$element(1," ",f$edit(subject,"TRIM,COMPRESS"))	! Get  n/m& $     thispart = f$element(0,"\",type)& $     totpart  = f$element(1,"\",type)6 $     if f$type(thispart)      .eqs. "INTEGER" .and. -F          f$type(totpart)       .eqs. "INTEGER"           then $ return $ endif  $ O $! It hasn't matched any of the recognized formats, so it can't be a valid part  $ OK = "FALSE" $ return