 !+ ! Program:	CONVERT_SIXEL_TO_HP	 ! Module: # ! Author:	Nick de Smith	August 1989 S !		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England. @ !		+44 892 511000, PSI%234213300154::NICK	NICK@NCDLAB.ULCC.AC.UK ! Description:o ! This program will convert any current sixel format output into a format acceptable to an HP LaserJet printer. i ! The LaserJet queue can be the implemented with the PSM_LASER symbiont in the [.LASER] directory in this  ! distribution.  ! K ! Copyright (c) 1989 by Applied Telematics Group Limited and Nick de Smith. n ! This software is supplied for information only. No guarantee is supplied for this software, and no liabilityn ! will be accepted for any action resulting from the use of this software or the information contained herein.j ! Under no circumstances may this software be used for commercial gain, including its sale, lease or loan.O ! This software may be copied only with the inclusion of this copyright notice. g ! The author is prepared to enter into correspondance with interested parties, but will not necessarily 9 ! maintain this software. Having said all that, enjoy it!  !  ! Edit	Edit date	By	Reason" !  01	21-Aug-89	NMdS	First attempt !-     !+
 ! OUTPUT_LINE  !	line_data  !		String by descriptor  !		Data to output to file K !		Called from Flush_Buffer() in SIXEL_PARSE.C as a user-supplied callback.  !  !-# sub OUTPUT_LINE( string line_data )   0 	option	type = explicit, constant type = integer  W 	declare	long constant input_lun = 1, output_lun = 2			! Declare channel numbers to use   \ 	move to #output_lun, line_data = len( line_data )			! Move output data to output channel...P 	put #output_lun, count len( line_data )					! ...and write the data to the file   end sub    !+
 ! SIXEL_TO_HP  ! E ! Stand alone program to convert a sixel file to HP LaserJet+ format. @ ! Calls the SIXEL_PARSE routines to do the parse and conversion. ! ' ! The logic is fairly straight forward:  ! 7 !	1.  Ask for DPI (resolution) to use for the LaserJet  3 !	2.  Ask for name of SIXEL input file, and open it . !	3.  Ask for name of output file, and open it  !	4.  Output initial HP commands !	5.  Initialise the scannerF !	6.  Read in a line from the input file, if end-of-file, goto step 9. !	7.  Process the input line !	8.  Goto step 6. !	9.  Flush any pending output !	10. Output final HP commands !	11. Close the files  ! 5 ! The escape sequences sent to the HP are as follows:  ! ] ! 	<esc>*t<num>R		Set DPI for printing. The LaserJet resolution is 300dpi both vertically and P !				horizontally. Allowable values for <num> are 75,100,150 and 300. We use 100R !				as things from a 15" or 19" workstation come out nicely. You may change this.4 !	<esc>&a0C		Start printing graphics at left margin. !	<esc>*r1A		Start graphics.# !	<esc>*b<byte-count>W<byte-stream> = !				A single pixel line of byte-count bytes (in byte-stream)  !	<esc>*rB		End of graphics  !- program CONVERT_SIXEL_TO_HP   # 	option	type	= explicit	,									& % 		constant type = integer	,									&  		size	= integer long   ! 	%include "$SSDEF" %from %library   # 	external long constant											& 0 		BAS$K_ENDFILDEV							! End of file on device	3 	declare	string	sixel_file, output_file, input_data 4 	declare	long	running, dpi, handle, l_program_statusA 	declare	long constant input_lun = 1, output_lun = 2, cmd_lun = 3   , 	open "SYS$INPUT:" for input as file cmd_lun 	printM 	print "CONVERT_SIXEL_TO_HP	- Convert SIXEL data file to HP LaserJet+ format"  	print   	when error inJ 		input #cmd_lun, "DPI         : "; dpi				! Ask for horizontal resolution 		select dpi 			case 75,100,150,300 			case elseJ 				print "%CVT-W-NOTREC, "; num1$( dpi ); " is not a recommended setting"E 				print "%CVT-I-USEDPI, You should use one of: 75, 100, 150 or 300"  		end select 		print   M 		input #cmd_lun, "Sixel File  : "; sixel_file			! Ask for name of input file > 		open sixel_file for input as file input_lun, recordsize 4096 		print   O 		input #cmd_lun, "Output file : "; output_file			! Ask for name of output file D 		open output_file for output as file output_lun, recordsize 4096, &4 			organization sequential variable, recordtype none 		print   B 		call LIB$INIT_TIMER( handle )					! Set up timers for statistics  R 		print #output_lun, ESC + "*t" + num1$( dpi ) + "R" + ESC + "&a0C" + ESC + "*r1A"  3 		call SIXEL_RESET()						! Reset the sixel scanner   
 		running = 1  		while running  			when error in? 				linput #input_lun, input_data			! Read a line of input data N 				call SIXEL_PARSE_STRING( edit$( input_data, 2 ) ) ! Process the input data 			use* 				select err					! Determine error cause) 					case BAS$K_ENDFILDEV			! End-of-file B 						l_program_status = SS$_NORMAL	! ...so just quit with success' 					case else				! Unexpected error... 3 						print ert$( err )		! ...display BASIC message A 						l_program_status = VMSSTATUS	! ...so extract the real cause  				end select 				running = 0  			end when  		next  2 		call SIXEL_FLUSH()						! Flush the sixel buffer  G 		print #output_lun, ESC + "*rB"					! Terminate the HP graphics stream   M 		close #input_lun, output_lun, cmd_lun				! Close the input and output files   " 		print "Final timing statistics:"D 		call LIB$SHOW_TIMER( handle )					! Tell the user how long it took 	use* 		select err							! Determine error cause) 			case BAS$K_ENDFILDEV					! End-of-file B 				l_program_status = SS$_NORMAL			! ...so just quit with success' 			case else						! Unexpected error... 3 				print ert$( err )				! ...display BASIC message A 				l_program_status = VMSSTATUS			! ...so extract the real cause  		end select	 	end when    end program l_program_status