 /*  *++  *  * Module: pushd.c  *  * Abstract:D  *	This module manages a set of routines to store and change a usersA  *	current working directory. This modules uses three routines to @  *	validate and change the current working device and directory:E  *	SET_DEFAULT, GET_DEFAULT and VALID_DEFAULT; and the three routines 2  *	to manage the directory stack: PUSH, POP, SCAN.  *  * Environment:   *	VAX/VMS operating system.  *
  * Author:  *	Eric M. LaFranchi  *  * Creation Date:   *	22-jun-1988  *  * Modification History:'  *	13-oct-1992	EML000	Eric M. LaFranchi ,  *	cleaned up code and added a few comments.  *
  * Functions: :  *	validate( const struct dsc$descriptor_s *const dirspec,  *		  const char *const errmsg,    *		  const char *const defans )  *8  *	retrieve_dir( struct dsc$descriptor_s *const retdesc,#  *		      unsigned long int level )   *8  *	get_new_directory( struct dsc$descriptor_s *retdesc )  *  *	change_default( )  *  *	load_directory( )  *
  *	main( )  *--  */   = #include <ctype.h>			/* Character Type Classification Mac  */ ; #include <ssdef.h>			/* Standard VMS messages code	      */ : #include <stdio.h>			/* Standard I/O definitions.	      */> #include <stdlib.h>			/* Standard library definitions.      */> #include <string.h>			/* Standard string definitions.       */> #include <descrip.h>			/* VMS descriptor definitions.	      */A #include <climsgdef.h>			/* Command definition utility symbols.*/   > #include "dirutl.h"			/* directory utility macros and def   */  F     /* Global descriptor definitions for CLI qualifiers and parameters      */ 2 static const $DESCRIPTOR( def_desc, "SYS$LOGIN" );8 static const $DESCRIPTOR( load_desc, "LOAD_DIRECTORY" );: static const $DESCRIPTOR( entry_desc, "DIRECTORY_ENTRY" );@ static const $DESCRIPTOR( validate_desc, "VALIDATE_DIRECTORY" );F static const $DESCRIPTOR( directory_desc, "DIRECTORY_SPECIFICATION" );   /*  *++  * Function: validate( )  *  * Abstract:F  *	Validate confirms that the directory specification is valid, if theD  *	confirm options is specified on the push command. If the entry isI  *	not valid the user is prompted with a question asking if the operation   *	should be aborted.   *
  * Inputs:J  *	dirspec - pointer to a descriptor containing the director specification+  *	errmsg - pointer to error message string G  *	defans - pointer to default answer -- must be (Y(es),N(o),T(rue), or   *		 F(alse)  *  * Outputs: :  *	Writes the new default directory specification to user.  *  * Return Value:  *	VMS status code  *  *--  */  static unsigned long int 7 validate( const struct dsc$descriptor_s *const dirspec,  	  const char *const errmsg, 	  const char *const defans )  {       static $DESCALLOC( answer );       char buf[32]; 
     struct     {  	unsigned short	argcnt;  	unsigned short	msg_opt; 	unsigned long	msg_cod;  	unsigned short	fao_cnt; 	unsigned short	new_opt; 	struct dsc$descriptor_s *fao1; 
     } msgvec;        register char *cp;     register status, tmp;   8     if ( CLI$PRESENT( &validate_desc ) != CLI$_NEGATED )     { # 	status = valid_default( dirspec );  	if ( !(status & 1) )  	{ 	    for ( ;; )  	    { 		fflush( stdout );  		*((long *)buf) = 0; 3 		fprintf( stdout, "%s ? [%s]: ", errmsg, defans ); 3 		if ( fgets( buf, sizeof( buf ), stdin ) == NULL )  		    continue;  		     		if ( buf[0] == '\n' )  		{  		    tmp = (char)defans[0]; 		    break; 		}   / 		for ( cp = buf; *cp = toupper( *cp ); cp++ );    		tmp = *((long *)buf);  #		pragma nostandard, 		if ( tmp == 'N\n\0\0' || tmp == 'NO\n\0' ) 		    break;  > 		if ( tmp == 'Y\n\0\0' || tmp == 'YE\n\0' || tmp == 'YES\n' ) 		   break;   - 		if ( tmp == 'T\n\0\0' || tmp == 'TR\n\0' || ( 		     tmp == 'TRU\n' || tmp == 'TRUE' ) 		    break;  - 		if ( tmp == 'F\n\0\0' || tmp == 'FA\n\0' || ( 		     tmp == 'FAL\n' || tmp == 'FALS' ) 		    break; #		pragma standard  ( 		*((char *)strchr( buf, '\n' )) = '\0'; 		$DESCINIT( answer, buf );   : 		    /* build message vector and give message to the user	 		     */  		msgvec.argcnt = 3; 		msgvec.msg_opt = 0x0f;$ 		msgvec.msg_cod = DIRUTL$_INVALANS; 		msgvec.fao_cnt = 1;  		msgvec.new_opt = 0x0f; 		msgvec.fao1 = &answer;  ' 		SYS$PUTMSG( &msgvec, NULL, NULL, 0 );  	    }4 	    if ( ((char)tmp == 'N') || ((char)tmp == 'F') ) 		return ( DIRUTL$_INVDEF ); 	}     }        return( SS$_NORMAL );  }    /*  *++  * Function: retrieve_dir( )  *  * Abstract:H  *	retrieve_dir uses the scan routine to retrieve the specified entry in  *	the directory stack.   *
  * Inputs:;  *	dsc -- pointer to descriptor to to contain new directory ;  *	level -- remaining number directories to search in stack   *  * Outputs:   *	None   *  * Return Value:  *	Normal status code   *  *--  */  static unsigned long int 5 retrieve_dir( struct dsc$descriptor_s *const retdesc,   	      unsigned long int level ) {      void *context = NULL;        register status, i, len;  = 	/* scan the directory stack and pull out the specified entry  	 */      len = retdesc->dsc$w_length;"     for ( i = 1; i <= level; i++ )     {  	retdesc->dsc$w_length = len; $ 	status = scan( retdesc, &context ); 	if ( !(status & 1) )  	     return ( status );     }        return ( SS$_NORMAL ); }    /*  *++!  * Function: get_new_directory( )   *  * Abstract:H  *	The get_new_directory manages the CLD routines and the functions that9  *	retrieving the new directory and device specification.   *
  * Inputs::  *	retdsc -- pointer to descriptor which the new directory"  *		  specification is written to.  *  * Outputs: <  *	retdesc is filled in with the new directory specification  *  * Return Value:  *	VMS status code  *  *--  */  static unsigned long int 5 get_new_directory( struct dsc$descriptor_s *retdesc )  {      static $DESCALLOC( level );        char levbuf[32];
     struct     {  	unsigned short	argcnt;  	unsigned short	msg_opt; 	unsigned long	msg_cod;  	unsigned short	fao_cnt; 	unsigned short	new_opt; 	unsigned long	fao1;
     } msgvec;        register status, lvl, tmp;   	/* initialize descriptor  	 */1     $DESCFILL( level, sizeof( levbuf ), levbuf );   : 	/* Is an entry number present on the command line? If yes2 	 * get the directory specification from the stack 	 */3     if ( CLI$PRESENT(&entry_desc) == CLI$_PRESENT )      { D 	status = CLI$GET_VALUE( &entry_desc, &level, &level.dsc$w_length );( 	if ( !(status & 1) ) return ( status );  0 	level.dsc$a_pointer[level.dsc$w_length] = '\0';) 	lvl = atol((char *)level.dsc$a_pointer);    	if ( lvl > 0 ) + 	    status = retrieve_dir( retdesc, lvl );   # 	if ( !(status & 1) || (lvl <= 0) )  	{ 	    if ( lvl == 0 )! 		status = DIRUTL$_TOPSTACKENTRY; 	 	    else ' 	        status = DIRUTL$_NOSTACKENTRY;   6 		/* build message vector and give message to the user 		 */  	    msgvec.argcnt = 3;  	    msgvec.msg_opt = 0x0f;  	    msgvec.msg_cod = status;  	    msgvec.fao_cnt = 1; 	    msgvec.new_opt = 0x0f;  	    msgvec.fao1 = lvl;   * 	    SYS$PUTMSG( &msgvec, NULL, NULL, 0 ); 	    SYS$EXIT( SS$_NORMAL ); 	}   	return( SS$_NORMAL );     }   D 	/* Check if a directory is not present on the command line, use theE 	 * last directory saved (This will allow the PUSHD command to toggle 6 	 * between two directories.) Otherwise use SYS$LOGIN. 	 */8     if ( CLI$PRESENT( &directory_desc ) == CLI$_ABSENT )     { # 	retdesc->dsc$w_length = MAXDIRLEN;    	if ( !(pop( retdesc ) & 1) )  	{3 	    retdesc->dsc$w_length = def_desc.dsc$w_length; < 	    memcpy( retdesc->dsc$a_pointer, def_desc.dsc$a_pointer, 		    retdesc->dsc$w_length ); 	}     }      else     { 2 	status = CLI$GET_VALUE( &directory_desc, retdesc,$ 			        &retdesc->dsc$w_length );( 	if ( !(status & 1) ) return ( status );     }        return ( SS$_NORMAL ); }    /*  *++  * Function: load_directory( )  *  * Abstract:7  *	If the load qualifier is not specified, then return. D  *	The load directory routine get the directory and device specifiedA  *	on the load qualifier and pushes it onto the top of the stack.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Return Value:  *	VMS status code  *--  */  static unsigned long int  load_directory( )  { !     static $DESCALLOC( dirspec );        char buf[80];      char dirbuf[MAXDIRLEN];      void *context = NULL;        register status;  2 	/* If the load qualifier is not specified return. 	 */  4     if ( CLI$PRESENT( &load_desc ) != CLI$_PRESENT ) 	return;   	/* initial dirspec descriptor 	 */3     $DESCFILL( dirspec, sizeof( dirbuf ), dirbuf );   0 	/* get the directory specification to be loaded 	 */J     status = CLI$GET_VALUE( &load_desc, &dirspec, &dirspec.dsc$w_length );+     if ( !(status & 1) ) return ( status );   > 	/* check and see if the new directory is valid, if not return 	 */L     status = validate( &dirspec, "Do you want to load the directory", "N" );/     if ( !(status & 1) ) return ( SS$_NORMAL );   ; 	/* load the directory on to the top of the directory stack  	 */     status = push( &dirspec );,     if ( !(status & 1) )  return ( status );  + 	/* Write loading default directory string.  	 */(     status = scan( &dirspec, &context );+     if ( !(status & 1) ) return ( status );   (     dirbuf[dirspec.dsc$w_length] = '\0';?     fprintf( stdout, "loading directory ...\n  %s\n", dirbuf );        SYS$EXIT( SS$_NORMAL );  }    /*  *++  * Function: change_default( )  *  * Abstract:9  *	main routine get the new directory entry, validates it C  *	then save the current device and directory on the stack and then 9  *	changes to the new device and directory specification.   *
  * Inputs:  *	None   *  * Outputs:   *	None   *  * Side Effects:(  *	Current working directory is changed.  *  * Return Value:  *	VMS status code  *--  */  static main( )  { !     static $DESCALLOC( new_dir ); !     static $DESCALLOC( def_dir );        char newdir[MAXDIRLEN];      char dirbuf[MAXDIRLEN];        register status;   	/* initialize descriptors 	 */3     $DESCFILL( new_dir, sizeof( newdir ), newdir ); 3     $DESCFILL( def_dir, sizeof( dirbuf ), dirbuf );   ? 	/* load a directory specification onto the top of the stack if ? 	 * specified. NOte this routine does not return if a directory # 	 * entry is loaded onto the stack.  	 */     load_directory( );  ' 	/* get the new directory specification  	 */+     status = get_new_directory( &new_dir ); +     if ( !(status & 1) ) return ( status );   3 	/* get the current working directory specification  	 */%     status = get_default( &def_dir ); +     if ( !(status & 1) ) return ( status );   > 	/* check and see if the new directory is valid, if not return 	 */N     status = validate( &new_dir, "Do you want to change the directory", "N" );/     if ( !(status & 1) ) return ( SS$_NORMAL );   5 	/* change our current directory to the new directory  	 */%     status = set_default( &new_dir ); +     if ( !(status & 1) ) return ( status );   < 	/* save the old directory on the top of the directory stack 	 */     status = push( &def_dir );+     if ( !(status & 1) ) return ( status );   ' 	/* Write new default directory string.  	 */     status = show_default( );      if ( !(status & 1) ) 	return ( status );        return ( SS$_NORMAL ); } 