 /* **++ **  FACILITY:	NETLIB **% **  ABSTRACT:	Miscellaneous routines.  ** **  MODULE DESCRIPTION:  ** **  	tbs ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  22-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	22-OCT-1994 V1.0    Madison 	Initial coding. 5 **  	27-NOV-1997 V1.1    Madison 	Added version info. P **      10-JAN-2002 V1.2    Madison     Don't allow extra dot after dotted-quad.N **      04-FEB-2002 V1.2-1  Madison     Last change was not correctly checking5 **                                      final length.  **-- */ #include "netlib.h" # #include "etc_dir:netlib_version.h"   
 #ifdef __DECC  #pragma extern_model save % #pragma extern_model common_block shr  #endifV     char $$$Copyright[] = "Copyright (c) 2008, Matthew Madison. All Rights Reserved.";
 #ifdef __DECC  #pragma extern_model restore #endif   /* **  Forward declarations */S     unsigned int netlib_strtoaddr(struct dsc$descriptor *dsc, struct INADDRDEF *a); N     unsigned int netlib_addrtostr(struct INADDRDEF *, struct dsc$descriptor *,*     	    	    	    	    unsigned short *);P     unsigned int netlib___find_symbol(char *imgnam, char *symnam, void *symptr);H     static unsigned int find_image_symbol(struct dsc$descriptor *imgdsc,<     	    	    	struct dsc$descriptor *symdsc, void *symptr);2     unsigned int netlib_hton_long(unsigned int *);2     unsigned int netlib_ntoh_long(unsigned int *);6     unsigned short netlib_hton_word(unsigned short *);7     unsigned short netlib_ntoh_short(unsigned short *); T     unsigned int netlib_version(struct dsc$descriptor *ver, unsigned short *retlen);   /* **++ **  ROUTINE:	netlib_strtoaddr  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */Q unsigned int netlib_strtoaddr (struct dsc$descriptor *dsc, struct INADDRDEF *a) {        unsigned short len;      char *cp, *anchor;'     unsigned int status, parts[4], val; 
     int i;  /     status = lib$analyze_sdesc(dsc, &len, &cp); #     if (!OK(status)) return status;   (     for (i = 0; len > 0 && i < 4; i++) {
     	val = 0; $     	while (*cp != '.' && len > 0) {.     	    if (!isdigit(*cp)) return SS$_IVADDR;&     	    val = val * 10 + (*cp - '0');     	    cp++; len--;      	}     	parts[i] = val;         if (len > 0) {             cp++; len--;	         }      }        switch (i) {     	case 0: return SS$_IVADDR;      	case 1: val = parts[0];     	    	break;<     	case 2: val = (parts[0] << 24) | (parts[1] & 0xffffff);     	    	break;A     	case 3: val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) | '     	    	    	    (parts[2] & 0xffff);      	    	break;     	case 4: if (len > 0) &                     return SS$_IVADDR;D                 val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |=     	    	      ((parts[2] & 0xff) << 8) | (parts[3] & 0xff);      	    	break;     }   -     a->inaddr_l_addr = netlib_long_swap(val);        return SS$_NORMAL;   } /* netlib_strtoaddr */   /* **++ **  ROUTINE:	netlib_addrtostr  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */6 unsigned int netlib_addrtostr (struct INADDRDEF *addr,F     	    	    	    	struct dsc$descriptor *dsc, unsigned short *len) {  
     int argc; 2     static $DESCRIPTOR(faodsc, "!UB.!UB.!UB.!UB");     SETARGCOUNT(argc);:     return lib$sys_fao(&faodsc, (argc > 2) ? len : 0, dsc,1     	    	    (addr->inaddr_l_addr)       & 0xff, 1     	    	    (addr->inaddr_l_addr >> 8)  & 0xff, 1     	    	    (addr->inaddr_l_addr >> 16) & 0xff, 2     	    	    (addr->inaddr_l_addr >> 24) & 0xff);   } /* netlib_addrtostr */   /* **++! **  ROUTINE:	netlib___find_symbol  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */N unsigned int netlib___find_symbol (char *imgnam, char *symnam, void *symptr) {  )     struct dsc$descriptor imgdsc, symdsc;   "     lib$establish(lib$sig_to_ret);  /     INIT_SDESC(imgdsc, strlen(imgnam), imgnam); /     INIT_SDESC(symdsc, strlen(symnam), symnam); 7     return find_image_symbol(&imgdsc, &symdsc, symptr);    } /* netlib___find_symbol */   /* **++ **  ROUTINE:	find_image_symbol ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */E static unsigned int find_image_symbol (struct dsc$descriptor *imgdsc, =     	    	    	struct dsc$descriptor *symdsc, void *symptr) {   9     return lib$find_image_symbol(imgdsc, symdsc, symptr);    } /* find_image_symbol */    /* **++ **  ROUTINE:	netlib_hton_long  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */5 unsigned int netlib_hton_long (unsigned int *value) {   $     return netlib_long_swap(*value);   } /* netlib_hton_long */   /* **++ **  ROUTINE:	netlib_ntoh_long  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */5 unsigned int netlib_ntoh_long (unsigned int *value) {   $     return netlib_long_swap(*value);   } /* netlib_ntoh_long */   /* **++ **  ROUTINE:	netlib_hton_word  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, wordword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */9 unsigned short netlib_hton_word (unsigned short *value) {   $     return netlib_word_swap(*value);   } /* netlib_hton_word */   /* **++ **  ROUTINE:	netlib_ntoh_word  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, wordword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */9 unsigned short netlib_ntoh_word (unsigned short *value) {   $     return netlib_word_swap(*value);   } /* netlib_ntoh_word */   /* **++ **  ROUTINE:	netlib_version  ** **  FUNCTIONAL DESCRIPTION:  **' **  	Returns the NETLIB version string.  **S **  RETURNS:	cond_value, condition value, longword (unsigned), write only, by value  ** **  PROTOTYPE: **" **  	NETLIB_VERSION  ver [,retlen] **E **  ver:    	char_string, character string, write only, by descriptor E **  retlen: 	word_unsigned, word (unsigned), write only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */R unsigned int netlib_version (struct dsc$descriptor *ver, unsigned short *retlen) {  
     int argc;      unsigned int status;4     static char version_string[] = NETLIB_T_VERSION;&     static $DESCRIPTOR(faodsc, "!AD");       SETARGCOUNT(argc);%     if (argc < 1) return SS$_INSFARG; &     if (ver == 0) return SS$_BADPARAM;  =     return lib$sys_fao(&faodsc, (argc > 1 ? retlen : 0), ver, 9     	    	    	sizeof(version_string)-1, version_string);    } /* netlib_version */