 /* **++) **  FACILITY:	NETLIB test "forked" server  ** **  ABSTRACT:	Echo server. ** **  MODULE DESCRIPTION:  **B **  	This is a test server that simply returns any characters sentG **  	to it over a TCP connection.  It is primarily intended for testing , **  	NETLIB's "forked" server compatibility. ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  17-NOV-1994  ** **  MODIFICATION HISTORY:  **1 **  	17-NOV-1994 V1.0    Madison 	Initial coding.  **-- */! #include "netlib_dir:netlibdef.h"  #include <descrip.h> #include <stsdef.h>  #include <ssdef.h> #include <string.h>  /*9 **  The following definition should match the port number M **  you have configured for this service in your master server configuration.  */*     const unsigned short ECHO_PORT = 2000; /* **  Forward declarations */     unsigned int main(void);   /* **++ **  ROUTINE:	main  ** **  FUNCTIONAL DESCRIPTION:  **C **  	Echo server main routine.  Establishes the service connection, ; **  	then just echoes any received data back to the sender.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	main()  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int main (void) {       struct SINDEF server_sin;      struct dsc$descriptor dsc;
     char chr; !     unsigned int status, context; 7     const unsigned int sinsize = sizeof(struct SINDEF);  /*5 **  The server setup MUST precede any CRTL I/O calls!  **D **  The socket address argument is ignored by all TCP/IPs except forD **  CMU TCP/IP, which requires it, due to the way forked servers are  **  implemented in that package. */$     memset(&server_sin, 0, sinsize);9     server_sin.sin_w_port = netlib_hton_word(&ECHO_PORT);   B     status = netlib_server_setup(&context, &server_sin, &sinsize);4     if (!$VMS_STATUS_SUCCESS(status)) return status;  $     dsc.dsc$b_dtype = DSC$K_DTYPE_T;$     dsc.dsc$b_class = DSC$K_CLASS_S;     dsc.dsc$a_pointer = &chr;      dsc.dsc$w_length = 1;    /*D **  The logic here is very simple because we're doing the I/O 1 byteH **  at a time.  As soon as the 1-byte buffer is filled, the read requestC **  will complete; we then immediately echo the data back again and  **  start up another read. */     while (1) {   *     	status = netlib_read(&context, &dsc);-     	if (!$VMS_STATUS_SUCCESS(status)) break; +     	status = netlib_write(&context, &dsc); -     	if (!$VMS_STATUS_SUCCESS(status)) break;        }    /*B **  LINKDISCON is the normal ending status for us -- it just means/ **  the remote side closed down the connection.  */6     if (status == SS$_LINKDISCON) status = SS$_NORMAL;       netlib_close(&context);        return status;   } /* main */