  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               REVERT              %%   \ @  *                %% |           revert.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *D  *  Changes the file version number of single/multiple versions of a?  *  filename in a directory. The lowest version of the filename <  *  is renamed to version 1, and the highest version becomes<  *  version n, where n is the total number of existing files>  *  of that name. If used with the /KEEP qualifier, lower file=  *  versions are purged up to the KEEP value entered, and the >  *  remaining file versions are renumbered, up from version 1.  *  >  *  Note that if the /MINIMUM value is between the highest andC  *  the lowest versions of a target filespec, we adjust the minimum ?  *  value so all applicable versions are purged. Use the /CHECK 8  *  qualifier first to determine file versions involved.  *D  *  A significant attribute of REVERT is after the file versions areH  *  reverted to lower version numbers, all date/time stamps of each file:  *  remain exactly the same as prior to executing REVERT.   *L  *  REVERT has been designed as a system management tool and is not intendedJ  *  to be accessed by general users. As described below, certain privs areI  *  required to succesfully execute REVERT. Additionally, if the image is J  *  located where global access is available, it is prudent for the sysmgr   *  to have trusted users enter:  *,  *      DEFINE /JOB /EXEC SECURE_LNM ENABLED  *I  *  prior to attempting execution. REVERT requires SYSPRV to successfully D  *  complete certain RMS calls. If SETPRV is enabled for the caller,I  *  the above privs will be enabled for the duration of image activation. I  *  If not, user will see 'RMS-E-PRV' message at exit. If image is built  H  *  with SECURE defined, user will see 'SYSTEM-x-AUTHFAIL' if there is a@  *  discrepancy with LNM definition. See source (#ifdef SECURE).  *E  *  Note that this information is not documented elsewhere. This is a G  *  poor mans substitute for an identifier, most unpriv'ed users cannot K  *  access another users job table. There may be some user with the ability J  *  to determine the need for this logical to be defined in the JOB table,E  *  but not be able to define it with EXEC priv. See the source code     *  (search for 'ifdef SECURE').  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #define VERSION "V1.2-2" #pragma module REVERT VERSION    #include <stdio.h> #include <ctype.h> #include <climsgdef.h> #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <lib$routines.h>  #include <prvdef.h>  #include <ssdef.h> #include <starlet.h> #include <string.h>  #include <stdlib.h> = #include <rms.h>            /* Include the RMS definitions */    struct FAB Fab;  struct NAM Nam;    typedef struct {      unsigned char FileName[132];     unsigned int Value;      unsigned int Status; } FILE_LST;    int PurgeCount;  int RevertCount; int CheckCount;  int ErrCnt;  int TotalAlloc;  int TotalUsed; int alloc_size;  int used_size;  G short AllFlg;               /* user specified cmdline /ALL qualifier */ E short CheckFlg;             /* user wants to see filespec contents */ G short ElipsisFlg;           /* user specified [...] withing filespec */  short ExcludeCount; > short ExcludeFlg;           /* exclude specified file types */G short KeepFlg;              /* user supplied cmdline /KEEP qualifier */ B short KeepValue;            /* value provided by user for above */J short MinimumFlg;           /* user supplied cmdline /MINIMUM qualifier */B short MinimumValue;         /* value provided by user for above */K short NumFiles;             /* quantity of files of same name, diff vers */ D short PathFlg;              /* filepath to Dispatch() has changed */   char Buffer[80];E char CmdVerb[32];           /* foreign command invoking this image */  char CurPath[80]; G char ExcludeStr[80];        /* file types to exclude from operations */  char NewPath[80];  char TargetPath[80];   globalvalue REVERT_CLD;    extern void Dispatch();   
 int main() { >     int CliStat;            /* return status from cli calls */     int LastVers = 0;      int DuplCount = 0;@     int curvers;            /* bin value of current file vers */     int status;        short CmdLen;      short CliStrLen;8     short CvLen;            /* Length of command verb */    3     char CliStr[80];        /* cli string buffer */ B     char CmdLine[132];      /* buffer reflecting input cmd line */     char Esa[132];     char Rsa[132];     char RsaTmp[132];      char Fspec[132];     char LastFspec[132];     char LastFspecTmp[132];      char LineBuf[132];     char NewFname[80];     char OldFname[80];9     char VersStr[10];       /* version of current file */      char enable_lnm[32];     char *ptr;       FILE_LST  *MainList;3     FILE_LST  *FilePtr;     /* FilePtr->FileName */   K     $DESCRIPTOR(DscCli, CliStr);        /* cli param or qualifier string */ J     $DESCRIPTOR(DscCmd, CmdLine);       /* user supplied input cmd line */N     $DESCRIPTOR(DscBuf, Buffer);        /* string returned by cli$get_value */"     $DESCRIPTOR(DscLbuf, LineBuf);J     $DESCRIPTOR(DscVerb, CmdVerb);      /* foreign invoking symbol name */  H     Fab = cc$rms_fab;           /* Initialize the input FAB structure */H     Nam = cc$rms_nam;           /* Initialize the input NAM structure */  @         /* define the security logical name, even if not used */  %     strcpy(enable_lnm, "SECURE_LNM");   <         /* get the command line used to invoke this image */  M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;   3         /* extract foreign cmd verb from CmdLine */   $     sscanf(CmdLine, "%s", &CmdVerb);     ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);  G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */  5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0'; E     strcpy(LineBuf, "REVERT ");         /* use imagename here only */      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, REVERT_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);  )         /* get user entered qualifiers */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();        strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();     P         /* we call 'CheckLnm' with the address of the job logical name to check.G            If the return status is SS$_NORMAL, then the logical does in J            fact exist and the pointer address now contains the equivalenceK            string of the logical. We then verify this string is what we are O            are expecting and react appropriately. Note that if this test fails, N            the user only receives a AUTHFAIL message for security purposes. */  
 #ifdef SECURE K         /* Some notes about error messages from the next few lines of code: J             W-AUTHFAIL - indicates logical IS defined, but the equivalenceC                          string is defined incorrectly (lowercase?) I             F-AUTHFAIL - Indicates the logical name is not defined in the E                          user's LNM$JOB table or wrong access mode */   7     status = CheckLnm(&enable_lnm, sizeof(enable_lnm)); J     if(status == SS$_NORMAL) { /* this says logical defined to some str */M         if(strcmp(enable_lnm, "ENABLED") != 0) { /* must match this string */ M             exit(0x2760);     /* %SYSTEM-W-AUTHFAIL, authorization failure */ 	         }      } J     else exit(0x2764);     /* %SYSTEM-F-AUTHFAIL, authorization failure */ #endif  &         /* check for /ALL qualifier */       strcpy(CliStr, "ALL");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); .     if(CliStat == CLI$_PRESENT) AllFlg = TRUE;     else AllFlg = FALSE;       strcpy(CliStr, "CHECK");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); 0     if(CliStat == CLI$_PRESENT) CheckFlg = TRUE;  K         /* check for filetype excludes, put to comma separated/ended str */        strcpy(CliStr, "EXCLUDE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);<         if(CliStat == CLI$_COMMA || CliStat == SS$_NORMAL) {%             Buffer[CliStrLen] = '\0'; L             strcpy(ExcludeStr, Buffer);    /* requested protection values */             ExcludeCount = 1; *             while(CliStat == CLI$_COMMA) {F                 CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);8                 if(CliStat & 1) strcat(ExcludeStr, ",");)                 Buffer[CliStrLen] = '\0'; +                 strcat(ExcludeStr, Buffer);                  ExcludeCount++; 
             } @             strcat(ExcludeStr, ",");  /* for parsing purposes */             ExcludeFlg = TRUE;	         }      }        strcpy(CliStr, "KEEP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; %             KeepValue = atoi(Buffer); L             if(!KeepValue) KeepValue = 1; /* defaults to 1, as does PURGE */             KeepFlg = TRUE; 	         } 5         else exit(CliStat); /* should not get here */      }      else if(!CheckFlg) {         KeepValue = 1;         KeepFlg = TRUE;      }        strcpy(CliStr, "MINIMUM");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; (             MinimumValue = atoi(Buffer);             MinimumFlg = TRUE;	         }      }        strcpy(CliStr, "INFILE"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); >     if(CliStat == CLI$_DEFAULTED || CliStat == CLI$_PRESENT) {=         if(CliStat == CLI$_DEFAULTED) strcpy(Fspec, "*.*;*"); %         if(CliStat == CLI$_PRESENT) { B             CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);'             if(CliStat == SS$_NORMAL) { )                 Buffer[CliStrLen] = '\0'; G                 strcpy(Fspec, Buffer);    /* input filepec to change */ )                 ptr = strchr(Fspec, ']');                  if(ptr) {                      ptr++;<                     if(!strlen(ptr)) strcat(Fspec, "*.*;*");                 }                  else {-                     ptr = strchr(Fspec, ':');                      if(ptr) {                          ptr++;@                         if(!strlen(ptr)) strcat(Fspec, "*.*;*");                     }                  } 
             } '             ptr = strstr(Fspec, "..."); &             if(ptr) ElipsisFlg = TRUE;	         }      } < #ifdef OLDCLI           /* not needed with CLI$_DEFAULTED */B     else {              /* INFILE not specified on command line */         exit(0x381F0);@     }   /* %CLI-W-ABSENT, filespec absent from command string */ #endif  +         /* make sure we get all versions */        ptr = strchr(Fspec, ';'); 
     if(ptr) { "         ptr = strstr(Fspec, ";*");$         if(!ptr) strcat(Fspec, "*");     }      else strcat(Fspec, ";*");   C         /* initialize RMS structures used by the (main) function */   :     Fab.fab$l_dna = Fspec;          /* address of Fspec */<     Fab.fab$b_dns = strlen(Fspec);  /* assign the length. */>     Fab.fab$l_nam = &Nam;           /* address of NAM block */  <     Nam.nam$l_esa = Esa;            /* address of the Esa */;     Nam.nam$b_ess = sizeof(Esa);    /* length of the Esa */ <     Nam.nam$l_rsa = Rsa;            /* address of the Rsa */;     Nam.nam$b_rss = sizeof(Rsa);    /* length of the Rsa */   #     status = sys$parse(&Fab, 0, 0); +     if(status != RMS$_NORMAL) exit(status);      Esa[Nam.nam$b_esl] = '\0';     if(!ElipsisFlg) { &         printf("\nTarget: %s\n", Esa);'         sprintf(TargetPath, "%s", Esa); &         ptr = strchr(TargetPath, ']');         if(ptr) {              ptr++;             *ptr = 0; 	         }      }   B         /* We tend to lose our RMS context if we jump out to otherH            functions in the middle of a SYS$SEARCH operation, so we willE            go thru the user provided filepath and identify all multi- F            version filenames. First time thru, we count the number of H            filenames having multiple versions, the second pass will saveA            these filespecs so a third pass can operate on them */   "     while(status == RMS$_NORMAL) {(         status = sys$search(&Fab, 0, 0);          if(status == RMS$_NMF) {             if(NumFiles) {                 DuplCount++;
             } 	         }          else {&             Rsa[Nam.nam$b_rsl] = '\0';             if(!NumFiles) { 1                 strcpy(LastFspec, Nam.nam$l_dev); H                 sscanf(Nam.nam$l_ver+1, "%d", &LastVers); /* not used */
             } -             strcpy(NewFname, Nam.nam$l_name); (             ptr = strchr(NewFname, ';');             if(ptr) *ptr = 0; :             if(strcmp(NewFname, OldFname)== 0) NumFiles++;             else {+                 strcpy(OldFname, NewFname);                  if(NumFiles) {                      DuplCount++;!                     NumFiles = 0;                  } 
             } 	         }      }   F         /* this is second pass. Allocate storage for the filenames and)            save them for the next pass */   B     MainList = (FILE_LST *) calloc(DuplCount+1, sizeof(FILE_LST));     FilePtr = MainList;   3         /* reset the necessary rms context items */        NumFiles = 0; -     memset(&LastFspec, 0, sizeof(LastFspec)); +     memset(&OldFname, 0, sizeof(OldFname)); K     Fab.fab$l_dna = Fspec;              /* address of Fspec from cmdline */ @     Fab.fab$b_dns = strlen(Fspec);      /* assign the length. */#     status = sys$parse(&Fab, 0, 0); +     if(status != RMS$_NORMAL) exit(status);      Esa[Nam.nam$b_esl] = '\0';  "     while(status == RMS$_NORMAL) {(         status = sys$search(&Fab, 0, 0);          if(status == RMS$_NMF) {              if(FilePtr->Value) {5                 strcpy(FilePtr->FileName, LastFspec); !                 FilePtr->Value++;                  FilePtr++;
             }*	         }*         else {&             Rsa[Nam.nam$b_rsl] = '\0';,             strcpy(LastFspecTmp, LastFspec);              strcpy(RsaTmp, Rsa);,             ptr = strchr(LastFspecTmp, ';');             if(ptr) *ptr = 0; &             ptr = strchr(RsaTmp, ';');             if(ptr) *ptr = 0; 3             if(strcmp(LastFspecTmp, RsaTmp) == 0) {.%                 if(!FilePtr->Value) { 9                     strcpy(FilePtr->FileName, LastFspec); %                     FilePtr->Value++;                  }*&                 else FilePtr->Value++;
             }%             else {1                 strcpy(LastFspec, Nam.nam$l_dev);|-                 if(FilePtr->Value) FilePtr++; 
             } 	         }      }   J         /* if AllFlg is not set, we retrieve saved filespecs and pass eachI            to the Dispatch() routine. If AllFlg is set, we once again getlN            each filename in target filespec (highest version only) and compareJ            to each filespec saved in pass 2. If filenames match, pass the I            filespec and number of files to Dispatch(). If no match, that oK            filename has only one version. We still pass the filespec to the,A            Dispatch routine, but with number of files as zero. */v  B     FilePtr = MainList;         /* reset pointer to top of list */  E     if(!AllFlg) {   /* operate on files with version higher than 1 */a*         while(strlen(FilePtr->FileName)) {1             strcpy(LastFspec, FilePtr->FileName);*&             NumFiles = FilePtr->Value;!             Dispatch(&LastFspec);a             FilePtr++;	         }r     } F     else {          /* operate only on files with multiple versions */         NumFiles = 0;eB         ptr = strchr(Fspec, ';');   /* get highest version only */         if(ptr) {c             ptr++;             *ptr = 0;a	         }e  3         /* reset the necessary rms context items */   O         Fab.fab$l_dna = Fspec;              /* address of Fspec from cmdline */aD         Fab.fab$b_dns = strlen(Fspec);      /* assign the length. */'         status = sys$parse(&Fab, 0, 0);n/         if(status != RMS$_NORMAL) exit(status); "         Esa[Nam.nam$b_esl] = '\0';  &         while(status == RMS$_NORMAL) {,             status = sys$search(&Fab, 0, 0);)             if(status == RMS$_NMF) break;r&             Rsa[Nam.nam$b_rsl] = '\0';1             if(!strcmp(Rsa, FilePtr->FileName)) {a5                 strcpy(LastFspec, FilePtr->FileName);o*                 NumFiles = FilePtr->Value;%                 Dispatch(&LastFspec);*                 FilePtr++;
             }u             else {8                 sscanf(Nam.nam$l_ver+1, "%d", &curvers);"                 if(curvers != 1) {+                     strcpy(LastFspec, Rsa);g!                     NumFiles = 0;l)                     Dispatch(&LastFspec);                  }h
             },	         }s     }TC     cfree(MainList);    /* free the filename storage we reserved */e  7         /* display a results message with some stats */n  1     if(CheckFlg) {      /* display Check stats */nB         if(!CheckCount) printf("\tNo matching files located\n\n");:         else printf("\n    Total: %d (%d/%d blocks)\n\n", /             CheckCount, TotalUsed, TotalAlloc);g     } 
     else {2         if(!PurgeCount && !RevertCount && !ErrCnt)6             printf("\tNo matching files located\n\n");         else {             if(ErrCnt) printf(L                "\n\tPurged: %d (%d/%d blocks), Reverted: %d, Other: %d\n\n",L                     PurgeCount, TotalUsed, TotalAlloc, RevertCount, ErrCnt);             elseI                 printf("\n\tPurged: %d (%d/%d blocks), Reverted: %d\n\n", D                     PurgeCount, TotalUsed, TotalAlloc, RevertCount);	         }f     }i }u        N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowChecktM  * Description: Called from Dispatch with a filespec of one or more versions,dJ  *              We simply display all versions and the blocksize for each ,  *              target file for user review.L  *              Sometimes you just need to see what is there before you pull  *              the trigger.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */h void ShowCheck(char *filespec) {pN     int localalloc = 0;     /* blocks allocated of last file from sys$parse */I     int localused = 0;      /* blocks used of last file from sys$parse */.     int rmsstat;@     int curvers;            /* bin value of current file vers */       char ChkRsa[132];/     char ChkEsa[132];      char TargetStr[80];d     char filename[80];     char fullspec[132];      char *ptr;       struct FAB ChkFab;     struct NAM ChkNam;       ChkFab = cc$rms_fab;     ChkNam = cc$rms_nam;       strcpy(fullspec, filespec);e      ptr = strchr(fullspec, ';');     if(ptr) *ptr = 0;      strcat(fullspec, ";*");eD     ChkFab.fab$l_dna = fullspec;           /* address of fullspec */C     ChkFab.fab$b_dns = strlen(fullspec);   /* assign the length. */ E     ChkFab.fab$l_nam = &ChkNam;            /* address of NAM block */c  B     ChkNam.nam$l_esa = ChkEsa;             /* address of ChkEsa */A     ChkNam.nam$b_ess = sizeof(ChkEsa);     /* length of ChkEsa */ B     ChkNam.nam$l_rsa = ChkRsa;             /* address of ChkRsa */A     ChkNam.nam$b_rss = sizeof(ChkRsa);     /* length of ChkRsa */   '     rmsstat = sys$parse(&ChkFab, 0, 0); $     ChkEsa[ChkNam.nam$b_esl] = '\0';  #     while(rmsstat == RMS$_NORMAL) {n,         rmsstat = sys$search(&ChkFab, 0, 0);)         if(rmsstat != RMS$_NORMAL) break; (         ChkRsa[ChkNam.nam$b_rsl] = '\0';         if(ElipsisFlg) {"             if(!strlen(CurPath)) {(                 strcpy(CurPath, ChkRsa);+                 ptr = strchr(CurPath, ']');r                 if(ptr) {F                     ptr++;                     *ptr = 0;1                 }n5                 sprintf(TargetStr, "\n %s", CurPath); 
             }n             else {(                 strcpy(NewPath, ChkRsa);+                 ptr = strchr(NewPath, ']');F                 if(ptr) {e                     ptr++;                     *ptr = 0;p                 }t3                 if(strcmp(CurPath, NewPath) != 0) {u7                     sprintf(TargetStr, " %s", NewPath);u-                     strcpy(CurPath, NewPath);u                 }O
             }B	         }D  -         /* get the size info for this file */k  4         rmsstat = GetBlockValues(&ChkRsa, &curvers);$         if(rmsstat != RMS$_NORMAL) {G             if(rmsstat == RMS$_FLK) printf("    %s    <file locked>\n",/                 ChkRsa);             else exit(rmsstat);t	         } $         if(rmsstat == RMS$_NORMAL) {,             if(MinimumFlg && MinimumValue) {-                 if(curvers >= MinimumValue) {D!                     if(PathFlg) {r3                         printf("%s\n", TargetPath);t$                         PathFlg = 0;                     }n9                     printf("    %s    (%d/%d blocks)\n", dB                         ChkNam.nam$l_name, used_size, alloc_size);-                     localalloc += alloc_size; +                     localused += used_size; -                     TotalAlloc += alloc_size;c+                     TotalUsed += used_size;a!                     CheckCount++;u                 }/
             }=             else {                 if(PathFlg) {s/                     printf("%s\n", TargetPath);m                      PathFlg = 0;                 } 4                 printf("    %s    (%d/%d blocks)\n",>                     ChkNam.nam$l_name, used_size, alloc_size);)                 localalloc += alloc_size; '                 localused += used_size; )                 TotalAlloc += alloc_size;t'                 TotalUsed += used_size;y                 CheckCount++;i
             } 	         }t         else {             CheckCount++; "             rmsstat = RMS$_NORMAL;	         }      }c }C    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *J  *    RenameFile - Final step of the revert process. Input is the filespecJ  *                 of the target file and the new reverted version number.K  *                 The latter is superfluous, as sys$rename will by default I  *                 try to assign the lowest version number possible. Dont ,  *                 leave anything to chance.  *L  *                 We create fab and nam structures for old and new versionsI  *                 of the target file. First open old file, get date-timeLL  *                 info and close file. Apply old date-time info to new file/  *                 after the rename completion.e  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ + int RenameFile(char *filespec, int newvers)t {(     int CpyFlg = 0; C     int CreBin[2];                  /* target file creation date */ L     int RevBin[2];                  /* modify/revision date of input file */     int rms_stat = 0;_  M     short RevNum = 0;               /* revision count of input file header */e       char oldfilespec[132];     char newfilespec[132];     char newverstr[12];h     char *ptr1;      char *ptr2;0<     char OldRsa[132], OldEsa[132], NewRsa[132], NewEsa[132];  E     struct FAB OldFab, NewFab;      /* FAB's for old-new filenames */hE     struct NAM OldNam, NewNam;      /* NAM's for old-new filenames */ H     struct XABDAT XabDat;           /* date/time info for oldfilename */L     struct XABRDT XabRdt;           /* allows set revision date on $CLOSE */    "     strcpy(oldfilespec, filespec);"     strcpy(newfilespec, filespec);'     sprintf(newverstr, ";%d", newvers);l$     ptr1 = strchr(newfilespec, ';');     *ptr1 = 0;#     strcat(newfilespec, newverstr);h  	        /*;J         * The following declarations are for the old and new FAB, NAM, and6         * XAB declarations with respect to SYS$RENAME.
         */  K     OldFab = cc$rms_fab;           /* Initialize the input FAB structure */tL     NewFab = cc$rms_fab;           /* Initialize the output FAB structure */K     OldNam = cc$rms_nam;           /* Initialize the input NAM structure */ L     NewNam = cc$rms_nam;           /* Initialize the output NAM structure */H     XabDat = cc$rms_xabdat;        /* Initialize the XabDat structure */H     XabRdt = cc$rms_xabrdt;        /* Initialize the XabRdt structure */  &     memset(OldRsa, 0, sizeof(OldRsa));&     memset(OldEsa, 0, sizeof(OldEsa));&     memset(NewRsa, 0, sizeof(NewRsa));&     memset(NewEsa, 0, sizeof(NewEsa));  6         /*  Build old FAB and associated structures */  #     OldFab.fab$l_fna = oldfilespec;t+     OldFab.fab$b_fns = strlen(oldfilespec); M     OldFab.fab$b_fac = FAB$M_GET | FAB$M_DEL;   /* We want read+del access */ 3     OldFab.fab$b_shr = FAB$M_SHRGET | FAB$M_SHRDEL; <     OldFab.fab$l_xab = &XabDat;     /* chain the date xab */L     OldFab.fab$l_nam = &OldNam;     /* Point the 'fab' to the 'nam' block */K     OldNam.nam$l_esa = OldEsa;      /* Init the pointers and size fields */ ;     OldNam.nam$l_rsa = OldRsa;      /* of the ESA & RSA. */uO     OldNam.nam$b_ess = sizeof(OldEsa); /* These variables are declared above */ &     OldNam.nam$b_rss = sizeof(OldRsa);  C         /* open old file, get/save revision date, close old file */   !     rms_stat = sys$open(&OldFab);E1     if(rms_stat != RMS$_NORMAL) return(rms_stat);s$     OldEsa[OldNam.nam$b_esl] = '\0';B     if(CpyFlg) {        /* if change revise date to create date */8         if(CreBin[0]) memset(CreBin, 0, sizeof(CreBin));E         memcpy(&CreBin, &XabDat.xab$q_cdt, sizeof(XabDat.xab$q_cdt));      } 4     if(RevBin[0]) memset(RevBin, 0, sizeof(RevBin));A     memcpy(&RevBin, &XabDat.xab$q_rdt, sizeof(XabDat.xab$q_rdt));      if(RevNum) RevNum = 0;A     memcpy(&RevNum, &XabDat.xab$w_rvn, sizeof(XabDat.xab$w_rvn));S  "     rms_stat = sys$close(&OldFab);1     if(rms_stat != RMS$_NORMAL) return(rms_stat);)  6         /*  Build new FAB and associated structures */  N     NewFab.fab$l_fna = newfilespec;         /* Addr of new filename cmdline */H     NewFab.fab$b_fns = strlen(newfilespec); /* Length of new filename */H     NewFab.fab$b_fac = FAB$M_PUT | FAB$M_UPD; /* We want write access */3     NewFab.fab$b_shr = FAB$M_SHRPUT | FAB$M_SHRUPD; E     NewFab.fab$l_xab = &XabRdt;          /* chain the revision xab */ Q     NewFab.fab$l_nam = &NewNam;          /* Point the 'fab' to the 'nam' block */ R     NewNam.nam$l_esa = NewEsa;           /* Initialize pointers and size fields */@     NewNam.nam$l_rsa = NewRsa;           /* of the ESA & RSA. */Q     NewNam.nam$b_ess = sizeof(NewEsa);   /* These variables are declared above */ &     NewNam.nam$b_rss = sizeof(NewRsa);  <         /* call RMS service SYS$RENAME to rename file (NOTE:>            FAB$W_IFI must be zero, ie, file must be closed) */  3     rms_stat = sys$rename(&OldFab, 0, 0, &NewFab);  !     if(rms_stat != RMS$_NORMAL) { ?         if(OldFab.fab$l_stv == 0x868) return(OldFab.fab$l_stv);E         else return(rms_stat);     }   M         /* open new file FAB, set revision date and number, close new file */p  !     rms_stat = sys$open(&NewFab);t1     if(rms_stat != RMS$_NORMAL) return(rms_stat);s7     memcpy(&XabRdt.xab$q_rdt, &RevBin, sizeof(RevBin)); 7     memcpy(&XabRdt.xab$w_rvn, &RevNum, sizeof(RevNum));i"     rms_stat = sys$close(&NewFab);     return(rms_stat);  }e        Fab.fab$b_dns = strlen(Fspec);  /* assign the length. */>     Fab.fab$l_nam = &Nam;           /* address of NAM block */  <     Nam.nam$l_esa = Esa;            /* address of the Esa */;     Nam.nam$b_ess = sizeof(Esa);    /* length of the Esa */ <     Nam.nam$l_rsa = Rsa;            /* address of the Rsa */;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     