#include <lib$routines.h>
#include <stdio.h>
#include <ssdef.h>
#include "tachyon_utilities:sample_dispatcher.h"
#include "tachyon_utilities:sample_priv_c_services.h"
#include "tachyon_utilities:sample_unpriv_c_services.h"

/* This short program calls the routines in the dispatcher just built. */

Date system_time,first_time;
long the_phd;
long the_pcb;
int sts;
short chan;
long ucb;
long vcb;
long ccb;
long ddt;
char time_string[50];


int main()

{

sts = get_my_phd_address(&the_phd);       /* get address of phd for this process */
if (!(sts & 1))  lib$signal(sts);
print_control_block_address(the_phd,"phd");

sts = get_my_pcb_address(&the_pcb);   /* get address of pcb for this process */
if (!(sts & 1))  lib$signal(sts);
print_control_block_address(the_pcb,"pcb");

printf("assigning channel to terminal\n");
chan = assign_channel ("tt",0);		/* assign i/o channel */
if (chan != 0) {
   sts = get_data_from_channel_number(chan,&ucb,&vcb,&ddt,&ccb);
   if (!(sts & 1))  lib$signal(sts);
   print_control_block_address(ucb,"ucb");
   print_control_block_address(vcb,"vcb");
   print_control_block_address(ccb,"ccb");
   print_control_block_address(ddt,"ddt");
   }

printf("assigning channel to sys$disk\n");
chan = assign_channel ("sys$disk",0);		/* assign i/o channel */
if (chan != 0) {
   sts = get_data_from_channel_number(chan,&ucb,&vcb,&ddt,&ccb);
   if (!(sts & 1))  lib$signal(sts);
   print_control_block_address(ucb,"ucb");
   print_control_block_address(vcb,"vcb");
   print_control_block_address(ccb,"ccb");
   print_control_block_address(ddt,"ddt");
   }

/* let's try to crash the system by getting an access violation in kernel */

/* first we'll give invalid output addresses; the kernel routine won't be */
/* able to write to them; the PROBEs should catch it			  */

if (get_data_from_channel_number(chan,0,0,0,0)==SS$_ACCVIO) 
   printf("If this message prints, the access violation was intercepted\n");

/* now we'll give an invalid channel number; since the kernel routine   */
/* doesn't check for that, it should get an access violation trying to  */
/* access the ucb; the condition handler ought to catch it		*/

if (get_data_from_channel_number(-1,&ucb,&vcb,&ddt,&ccb)==SS$_ACCVIO) 
   printf("If this message prints, the second access violation was intercepted\n");



sts = get_system_time(&system_time,&first_time); /*get system time and time of 1st tqe*/
if (!(sts & 1))  lib$signal(sts);

sts = get_date_time_string(system_time, time_string);
if (!(sts & 1))  lib$signal(sts);

printf("system time is %s\n",time_string);

sts = get_date_time_string(first_time, time_string);
if (!(sts & 1))  lib$signal(sts);

printf("time of 1st TQE is %s\n",time_string);

}

