$!
$! This script verifies and diagnoses userdir protection problems.
$! It takes the translated path info specified after the script name and
$! reconstructs a OpenVMS file specification of the directories in the
$! path.  The directory path is then traversed from the top down to verify
$! the existence/readability of each directory, allowing the user to pinpoint
$! where any protection problems lie.
$!
$! If the translations uses a concealed root logical, that directory path
$! for the root logical is verified as well.
$!
$! Author:   David Jones
$! Date:     24-APR-1997
$!
$!  Load environment variables and tell client what we are doing.
$!
$ crlf == f$fao("!/")
$ CGI_SYMBOLS WWW_
$ netwrite = "write net_link/err=abort"
$ netwrite "Content-type: text/plain",crlf,crlf
$ if f$type(www_path_translated) .eqs. "" then www_path_translated = ""
$ if f$type(www_path_info) .eqs. "" then www_path_info = ""
$ netwrite "The path you requested to verify is '", www_path_info,"'",crlf
$ netwrite "The server translates this path to '", www_path_translated, "'",crlf,crlf
$!
$! Parse the components in the translated path string and rebuild as an
$! OpenVMS directory specification.
$!
$ i = 0
$ vms_path = ""
$ next_elem:
$    i = i + 1
$    elem = f$element(i,"/",www_path_translated)
$    if elem .eqs. "/" .or. elem .eqs. "" then goto nomore_elem
$    if f$element(1,".",elem) .nes. "." then goto nomore_elem
$!    netwrite "  element[",i,"] = '", elem, "'", crlf
$    if i .eq. 1
$    then
$!
$!	First element is device name.
$	if f$trnlnm(elem,,,,,"CONCEALED")
$	then
$	    vms_path = f$trnlnm(elem)
$ 	    netwrite "Verifying concealed root ", vms_path, crlf
$	    gosub verify_path
$	endif
$	vms_path = elem + ":"
$	separator = "["
$    else
$	vms_path = vms_path + separator + elem
$	separator = "."
$    endif
$    goto next_elem
$ nomore_elem:
$ if i .eq. 1 then netwrite write "Path ", www_path, " has no translation",crlf
$ if i .eq. 2 then vms_path = vms_path - ":["
$ if i .gt. 2 then vms_path = vms_path + "]"
$!
$! Validate the resulting path.
$!
$ netwrite crlf, "Verifying VMS path ", vms_path, crlf
$ gosub verify_path
$ netwrite crlf,"Note that an 'unreadable'", -
	" directory may be 'OK' if it grants execute access",crlf
$ abort:
$  exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! The verify_path subroutine parses the vms_path symbol and test each
$! constituent directory for existence and accessibility.  The status
$! of each directory test is reported to the client.
$!
$ verify_path:
$ parent = f$element(0,"[",vms_path) + "[000000]"
$ dlist = f$element(1,"[",f$element(0,"]",vms_path))
$ dsep = ""
$ j = 0
$ next_dir:
$    dname = f$element(j,".",dlist)
$    if dname .eqs. "." then return
$    if dname .eqs. "" then return
$    dspec = f$parse(dname,parent+".dir;1")
$    netwrite "    Directory ", dspec
$    dstatus = " - OK"
$    if dspec .eqs. ""
$    then
$	dstatus = " - (" + parent + ")"
$    else
$       if f$search(dspec) .eqs. "" 
$	then 
$	    dstatus = " - non-existent or inaccessible"
$	else
$	    dstatus = " - Unreadable "
$	    open/read/share dtest 'dspec'/err=dtest_err
$	    dstatus = " - OK"
$	    close dtest
$ dtest_err:
$	endif
$    endif
$    netwrite dstatus, crlf
$    if j .eq. 0 then dspec = f$element(0,"[",dspec) + "[]"
$    parent = f$element(0,"]",dspec) + dsep + dname + "]"
$    dsep = "."
$    j = j + 1
$    goto next_dir
