 /* **++ **  FACILITY:	NSQUERY  **" **  ABSTRACT:	The NSQUERY program. ** **  MODULE DESCRIPTION:  **F **  	This module contains the NSQUERY main program and some supporting
 **  routines.  **D **  	NSQUERY is a program that interrogates domain name servers.  ItF **  formats a query, sends it to a server (either via UDP or TCP), and& **  decodes and prints out the result. ** **  AUTHOR: 	    M. Madison G **  	    	    COPYRIGHT  1993, MADGOAT SOFTWARE.  ALL RIGHTS RESERVED.  ** **  CREATION DATE:  25-SEP-1992  ** **  MODIFICATION HISTORY:  **6 **  	25-SEP-1992 X3.0    Madison 	Initial coding in C.D **  	28-SEP-1992 V3.0    Madison 	Separate out network dependencies.1 **  	23-NOV-1992 V3.0-1  Madison 	Fix WKS output. C **  	11-OCT-1993 V3.0-2  Madison 	Slight cleanup, fix for pre-V5.2.  **-- */ #define NSQ_VERSION 	"V3.0-2" Q #define NSQ_COPYRIGHT	"Copyright  1993, MadGoat Software.  All Rights Reserved."   
 #ifdef __DECC " #pragma module NSQUERY NSQ_VERSION #else  #module NSQUERY NSQ_VERSION  #endif   #include "nsquery.h" #include "ipns_const.h"   
 #ifdef __DECC  #pragma extern_model save % #pragma extern_model common_block shr  #endif*     char $$$Copyright[]   = NSQ_COPYRIGHT;
 #ifdef __DECC  #pragma extern_model restore #endif   /* ** Forward declarations  */     unsigned int main(void);J     static void Show_RR(struct dsc$descriptor_s *, int, unsigned char **);;     static void name_unpack(unsigned char **, char *, int); ,     static void check_inverse_query(char *);   /* ** External references */#     extern void Print(char *, ...); ,     extern unsigned int cli_present(char *);;     extern unsigned int cli_get_value(char *, char *, int); 9     extern unsigned int get_logical(char *, char *, int); B     extern struct dsc$descriptor *address_to_string(unsigned int);-     extern unsigned int network_init(void *); G     extern unsigned int network_open(void *, unsigned int *, int, int); .     extern unsigned int network_close(void *);:     extern unsigned int network_send(void *, void *, int);=     extern void         network_lookup(char *, struct QUE *); <     extern void         network_local_hostname(char *, int);O     extern unsigned int network_response(void *, void *, int, short *, TIME *);    /* ** Message codes */ #pragma nostandard8     globalvalue unsigned int CLI$_NEGATED, CLI$_PRESENT;G     globalvalue unsigned int NSQ__TRYNS, NSQ__NSOPNERR, NSQ__NOCONTACT, @     	NSQ__UNKRC, NSQ__HDRERR, NSQ__IDENTMISMATCH, NSQ__RCVQUERY,E     	NSQ__MSGTRUNC, NSQ__AUTHRESP, NSQ__SMALLBYTLM, NSQ__SMALLMAXBUF, 4     	NSQ__NOALLOC, NSQ__NORECURSION, NSQ__SRVNAMERR; #pragma standard   /* ** External data references  */"     extern unsigned int nsq_cld();6     extern char *cls_name[], *pro_name[], *wks_name[];>     extern int cls_name_count, pro_name_count, wks_name_count;!     extern unsigned int rc_msg[]; -     extern char *type_name[], *class_input[]; @     extern int rc_msg_count, type_name_count, class_input_count;+     extern int type_value[], class_value[];    /*+ ** Header used in DNS queries and responses  */     union NSMSG {      	unsigned int lw; 
     	struct {      	    short id;#     	    int recursion_desired	: 1; !     	    int truncation	    	: 1; "     	    int authoritative   	: 1;     	    int opcode  	    	: 4;      	    int response	    	: 1;      	    int rcode   	    	: 4;      	    int unused  	    	: 3; "     	    int recursion_avail 	: 1;     	} hdr;      };   /*
 ** Local data  */A     static unsigned char nsbuf[4096];	/* query/response buffer */    /* **++ **  ROUTINE:	main  ** **  FUNCTIONAL DESCRIPTION:  ** **  	Main program. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	main()  ** **  IMPLICIT INPUTS:	See above.  ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	See above.  ** **-- */ unsigned int main() {   0     char cmdline[STRING_SIZE], tmp[STRING_SIZE];5     char qhost[STRING_SIZE], nameserver[STRING_SIZE];       unsigned char *nsbase, *nsp;     char *cp, *anchor;     union NSMSG hdr, rcvhdr;     struct dsc$descriptor sdsc;      struct ADR *adr;     struct QUE adrque;!     TIME qident, receive_timeout; 9     short len, nslen, qdcount, ancount, nscount, arcount;      int i, port, use_tcp;       unsigned int status, netctx;   /*# ** Fetch and parse the command line  */      strcpy(cmdline, "NSQUERY ");3     INIT_SDESC(sdsc, sizeof(cmdline)-9, cmdline+8); -     status = lib$get_foreign(&sdsc, 0, &len); #     if (!OK(status)) return status; %     INIT_SDESC(sdsc, len+8, cmdline); I     status = cli$dcl_parse(&sdsc, nsq_cld, lib$get_input, lib$get_input); #     if (!OK(status)) return status;    /*" ** Get the name we're asking about */1     cli_get_value("QNAME", qhost, sizeof(qhost));      check_inverse_query(qhost);    /*$ ** Get the name server we're to ask. */     nameserver[0] = '\0'; 0     if (cli_present("SERVER") == CLI$_PRESENT) {=     	cli_get_value("SERVER", nameserver, sizeof(nameserver));      }      if (!nameserver[0]) { H     	status = get_logical("NSQ_SERVER", nameserver, sizeof(nameserver));     	if (!OK(status)) { 0     	    static $DESCRIPTOR(prompt,"_Server: ");<     	    INIT_SDESC(sdsc, sizeof(nameserver)-1, nameserver);6     	    status = lib$get_input(&sdsc, &prompt, &len);'     	    if (!OK(status) || len == 0) {      	    	return SS$_NORMAL;     	    } else { !     	    	nameserver[len] = '\0'; 
     	    }     	}     }    /*= ** Now translate the name server string into its address(es).  */-     network_local_hostname(tmp, sizeof(tmp)); (     adrque.head = adrque.tail = &adrque;(     network_lookup(nameserver, &adrque);   /*# ** Time stamp used as an identifier  */     sys$gettim(&qident);   /*A ** Set up the buffer pointers.  Reserve the first two bytes for a ( ** length value in case we're using TCP. */'     nsp = nsbase = nsbuf+sizeof(short);       /* ** Set up the header...  */     hdr.lw = 0; '     hdr.hdr.id = qident.long1 & 0xffff; I     hdr.hdr.recursion_desired = cli_present("RECURSIVE") == CLI$_PRESENT;    /*D ** We use a bigger timeout on UDP-based queries if the user requests
 ** recursion.  */     { .     	static $DESCRIPTOR(bigtime,"0 00:00:30");2     	static $DESCRIPTOR(littletime, "0 00:00:15");C     	sys$bintim(hdr.hdr.recursion_desired ? &bigtime : &littletime,      	    	&receive_timeout);     }    /*5 ** Start filling the buffer.  Add the header, counts.  */     LONG_PACK(hdr.lw, nsp);      qdcount = 1;!     BYTE_SWAP_PACK(qdcount, nsp); $     ancount = nscount = arcount = 0;!     BYTE_SWAP_PACK(ancount, nsp); !     BYTE_SWAP_PACK(nscount, nsp); !     BYTE_SWAP_PACK(arcount, nsp);    /* ** Stuff in the query host name  */  <     if (*(qhost+strlen(qhost)-1) != '.') strcat(qhost, ".");     anchor = qhost;      while (*anchor) {      	cp = strchr(anchor, '.');8     	if (cp-anchor > 0) strncpy(tmp, anchor, cp-anchor);     	tmp[cp-anchor] = '\0';      	ASCIC_PACK(tmp, nsp);     	anchor = cp + 1;      }      *nsp++ = '\0';   /*3 ** Get the query type and store in the query buffer  */  .     if (cli_present("TYPE") == CLI$_PRESENT) {-     	cli_get_value("TYPE", tmp, sizeof(tmp));      } else {     	strcpy(tmp, "ALL");     } +     for (i = 0; i < type_name_count; i++) { 5     	if (strstr(type_name[i], tmp) == type_name[i]) { '     	    WORD_PACK(type_value[i], nsp);      	    break;      	}     }    /* ** Now for the class */  /     if (cli_present("CLASS") == CLI$_PRESENT) { .     	cli_get_value("CLASS", tmp, sizeof(tmp));     } else {     	strcpy(tmp, "INTERNET");      } -     for (i = 0; i < class_input_count; i++) { 9     	if (strstr(class_input[i], tmp) == class_input[i]) { (     	    WORD_PACK(class_value[i], nsp);     	    break;      	}     }    /*A ** Determine the port to which we direct the request (usually 53)  */  .     if (cli_present("PORT") == CLI$_PRESENT) {-     	cli_get_value("PORT", tmp, sizeof(tmp)); )     	lib$cvt_dtb(strlen(tmp), tmp, port);      } else {     	port = 53;      }    /*- ** Which protocol to use (typically want UDP)  */  2     if (cli_present("PROTOCOL") == CLI$_PRESENT) {1     	cli_get_value("PROTOCOL", tmp, sizeof(tmp));      	upcase(tmp); '     	use_tcp = strcmp(tmp, "TCP") == 0;      } else use_tcp = 0;    /* ** Now make the query  */     netctx = 0; #     status = network_init(&netctx); &     if (!OK(status)) lib$stop(status);'     while (REMQUE(adrque.head, &adr)) { @     	lib$signal(NSQ__TRYNS, 1, address_to_string(adr->address));D     	status = network_open(&netctx, &(adr->address), port, use_tcp);     	free(adr);  /*A ** For TCP-based queries, we stick the length of the query in the 9 ** first two bytes of the query buffer (in network order)  */     	if (use_tcp) {      	    len = nsp-nsbase;$     	    nsbuf[0] = (len&0xff00)>>8;     	    nsbuf[1] = len&0x00ff;      	    nsbase = nsbuf;     	} /* ** Send the query  */H     	if (OK(status)) status = network_send(&netctx, nsbase, nsp-nsbase); /* ** Get the response  */     	if (OK(status)) {A     	    status = network_response(&netctx, nsbuf, sizeof(nsbuf), -     	    	    	    &nslen, &receive_timeout);      	}     	if (OK(status)) break; *     	lib$signal(NSQ__NSOPNERR, 0, status);     }    /*@ ** All done with the network.  If we couldn't contact any of the) ** server's addresses, let the user know.  */     network_close(&netctx); $     if (!OK(status) || nslen == 0) {!     	lib$stop(NSQ__NOCONTACT, 0);      }    /*" ** We have a response... decode it */     nsp = nsbuf+sizeof(short);     LONG_UNPACK(nsp,rcvhdr.lw); &     if (rcvhdr.hdr.id != hdr.hdr.id) {@     	lib$stop(NSQ__HDRERR, 0, NSQ__IDENTMISMATCH, 2, hdr.hdr.id,     	    rcvhdr.hdr.id);     }        if (!rcvhdr.hdr.response) { 0     	lib$stop(NSQ__HDRERR, 0, NSQ__RCVQUERY, 0);     }         if (rcvhdr.hdr.truncation) {"     	lib$signal(NSQ__MSGTRUNC, 0);     } #     if (rcvhdr.hdr.authoritative) { "     	lib$signal(NSQ__AUTHRESP, 0);     } C     if (hdr.hdr.recursion_desired && !rcvhdr.hdr.recursion_avail) { %     	lib$signal(NSQ__NORECURSION, 0);      } 1     if (rc_msg[rcvhdr.hdr.rcode] == NSQ__UNKRC) { 1     	lib$signal(NSQ__UNKRC, 1, rcvhdr.hdr.rcode);      } else {-     	lib$signal(rc_msg[rcvhdr.hdr.rcode], 0);      }        Print("");  "     BYTE_SWAP_UNPACK(nsp,qdcount);"     BYTE_SWAP_UNPACK(nsp,ancount);"     BYTE_SWAP_UNPACK(nsp,nscount);"     BYTE_SWAP_UNPACK(nsp,arcount);   /* ** Display what we asked for */$     for (i = 1; i <= qdcount; i++) {     	short qtword, qcword;     	NAME_UNPACK(nsp, qhost); #     	BYTE_SWAP_UNPACK(nsp, qtword); #     	BYTE_SWAP_UNPACK(nsp, qcword); ;     	Print("QUERY  #!UL: QName=!AD, QType=!UW, QClass=!UW", 2     	    i, strlen(qhost), qhost, qtword, qcword);     }    /*G ** Now display the answers, the authority RR's, and any additional RR's  */     if (ancount > 0) {'     	static $DESCRIPTOR(hdr, "ANSWER");      	Print(""); ;     	for (i = 1; i <= ancount; i++) Show_RR(&hdr, i, &nsp);      }      if (nscount > 0) {'     	static $DESCRIPTOR(hdr, "AUTHOR");      	Print(""); ;     	for (i = 1; i <= nscount; i++) Show_RR(&hdr, i, &nsp);      }      if (arcount > 0) {'     	static $DESCRIPTOR(hdr, "ADDTNL");      	Print(""); ;     	for (i = 1; i <= arcount; i++) Show_RR(&hdr, i, &nsp);      }      Print("");       return SS$_NORMAL;   } /* nsquery */    /* **++ **  ROUTINE:	Show_RR ** **  FUNCTIONAL DESCRIPTION:  **, **  	Unpacks and displays a resource record. ** **  RETURNS:	void  ** **  PROTOTYPE: **L **  	Show_RR(struct dsc$descriptor *hdr, int number, unsigned char **bufptr) **1 **  hdr:    char_string, read only, by descriptor ( **  number: integer, read only, by value. **  bufptr: byte pointer, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */J void Show_RR(struct dsc$descriptor_s *xhdr, int n, unsigned char **nspp) {  "     unsigned char *nsp, *nsp_save;3     char name[STRING_SIZE], classname[STRING_SIZE]; 0     char name2[STRING_SIZE], name3[STRING_SIZE];&     struct dsc$descriptor cldsc, ndsc;      short type, class, rdlength;
     int i, j; 
     TIME ttl;        nsp = *nspp;       NAME_UNPACK(nsp, name); )     INIT_SDESC(ndsc, strlen(name), name);      WORD_UNPACK(nsp, type); !     BYTE_SWAP_UNPACK(nsp, class); "     if (class >= cls_name_count) {%     	sprintf(classname, "%d", class);      } else {(     	strcpy(classname, cls_name[class]);     } 4     INIT_SDESC(cldsc, strlen(classname), classname);     TIME_UNPACK(nsp, ttl);$     BYTE_SWAP_UNPACK(nsp, rdlength);     nsp_save = nsp;        switch(type) {       case IPNS_TYPE_A: {      	unsigned int address;     	LONG_UNPACK(nsp, address); D     	Print("!AS #!UL: !AS, A, !AS, !13%D, Addr=!AS", xhdr, n, &ndsc,3     	    &cldsc, &ttl, address_to_string(address));      	break;      }        case IPNS_TYPE_NS: {     	NAME_UNPACK(nsp, name2); C     	Print("!AS #!UL: !AS, NS, !AS, !13%D, NS=!AD", xhdr, n, &ndsc, -     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_CNAME: {      	NAME_UNPACK(nsp, name2); B     	Print("!AS #!UL: !AS, CNAME, !AS, !13%D, CName=!AD", xhdr, n,4     	    &ndsc, &cldsc, &ttl, strlen(name2), name2);     	break;      }        case IPNS_TYPE_PTR: {      	NAME_UNPACK(nsp, name2); E     	Print("!AS #!UL: !AS, PTR, !AS, !13%D, Ptr=!AD", xhdr, n, &ndsc, -     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_HINFO: {      	ASCIC_UNPACK(nsp, name2);     	ASCIC_UNPACK(nsp, name3);H     	Print("!AS #!UL: !AS, HINFO, !AS, !13%D, CPU=!AD, OS=!AD", xhdr, n,J     	    &ndsc, &cldsc, &ttl, strlen(name2), name2, strlen(name3), name3);     	break;      }        case IPNS_TYPE_MX: {     	short pref;!     	BYTE_SWAP_UNPACK(nsp, pref);      	NAME_UNPACK(nsp, name2); H     	Print("!AS #!UL: !AS, MX, !AS, !13%D, Pref=!UW, Exch=!AD", xhdr, n,:     	    &ndsc, &cldsc, &ttl, pref, strlen(name2), name2);     	break;      }        case IPNS_TYPE_MF: {     	NAME_UNPACK(nsp, name2); F     	Print("!AS #!UL: !AS, MF, !AS, !13%D, Agent=!AD", xhdr, n, &ndsc,-     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_MB: {     	NAME_UNPACK(nsp, name2); H     	Print("!AS #!UL: !AS, MB, !AS, !13%D, BoxHost=!AD", xhdr, n, &ndsc,-     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_MG: {     	NAME_UNPACK(nsp, name2); H     	Print("!AS #!UL: !AS, MG, !AS, !13%D, GrpHost=!AD", xhdr, n, &ndsc,-     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_MR: {     	NAME_UNPACK(nsp, name2); H     	Print("!AS #!UL: !AS, MR, !AS, !13%D, NewName=!AD", xhdr, n, &ndsc,-     	    &cldsc, &ttl, strlen(name2), name2);      	break;      }        case IPNS_TYPE_MINFO: {      	NAME_UNPACK(nsp, name2);      	NAME_UNPACK(nsp, name3); R     	Print("!AS #!UL: !AS, MINFO, !AS, !13%D, Resp=!AD, Errs=!AD", xhdr, n, &ndsc,C     	    &cldsc, &ttl, strlen(name2), name2, strlen(name3), name3);      	break;      }        case IPNS_TYPE_TXT: { 
     	int len; 
     	short i; K     	Print("!AS #!UL: !AS, TXT, !AS, !13%D", xhdr, n, &ndsc, &cldsc, &ttl);      	len = rdlength;     	while (len > 0) {&     	    ASCICN_UNPACK(nsp, name2, i);$     	    Print("    !AD", i, name2);     	    len -= i+1;     	}     	break;      }      case IPNS_TYPE_SOA: {      	int serial;*     	TIME refresh, retry, expire, minimum;     	NAME_UNPACK(nsp, name2);      	NAME_UNPACK(nsp, name3); K     	Print("!AS #!UL: !AS, SOA, !AS, !13%D", xhdr, n, &ndsc, &cldsc, &ttl); 7     	Print("    Primary NS: !AD!/    Responsible: !AD", 5     	    strlen(name2), name2, strlen(name3), name3); &     	LONG_REVERSE_UNPACK(nsp, serial);     	TIME_UNPACK(nsp, refresh);      	TIME_UNPACK(nsp, retry);      	TIME_UNPACK(nsp, expire);     	TIME_UNPACK(nsp, minimum); @     	Print("    Serial=!UL, Refresh=!13%D, Retry=!13%D", serial,      	    	    &refresh, &retry);A     	Print("    Expire=!13%D, Minimum=!13%D", &expire, &minimum);      	break;      }        case IPNS_TYPE_WKS: { 0     	char wkname[STRING_SIZE], tmp[STRING_SIZE];$     	char proname[STRING_SIZE], *cp;      	int address, mapsize, wksn;"     	unsigned char proto, wksbyte;       	LONG_UNPACK(nsp, address); F     	Print("!AS #!UL: !AS, WKS, !AS, !13%D, Addr=!AS", xhdr, n, &ndsc,3     	    &cldsc, &ttl, address_to_string(address));r     	BYTE_UNPACK(nsp, proto);n#     	if (proto >= pro_name_count) { %     	    sprintf(proname,"%d",proto); 
     	} else { *     	    strcpy(proname, pro_name[proto]);     	}/     	sprintf(tmp, "  Protocol %s: /", proname);      	cp = tmp+strlen(tmp);     	mapsize = rdlength-5;%     	for (i = 1; i <= mapsize; i++) {	"     	    BYTE_UNPACK(nsp,wksbyte);"     	    for (j = 0; j < 8; j++) {     	    	if (wksbyte&(1<<j)) {V#     	    	    wksn = i * 8 - j - 1;o+     	    	    if (wksn >= wks_name_count) {"!     	    	    	if (wksn == 243) {p.     	    	    	    strcpy(wkname, "SUR-MEAS");(     	    	    	} else if (wksn == 245) {*     	    	    	    strcpy(wkname, "LINK");     	    	    	} else { /     	    	    	    sprintf(wkname, "%d", wksn);      	    	    	}     	    	    } else {.     	    	    	strcpy(wkname, wks_name[wksn]);     	    	    }y/     	    	    if (cp-tmp+strlen(wkname) > 75) {m     	    	    	*cp = '\0';     	    	    	Print(tmp);0     	    	    	sprintf(tmp, "    /%s/", wkname);$     	    	    	cp = tmp+strlen(tmp);     	    	    } else {"     	    	    	strcpy(cp, wkname);$     	    	    	cp += strlen(wkname);     	    	    	*cp++ = '/';(     	    	    }*     	    	}e
     	    }     	}     	if (cp != tmp) {.     	    *cp = '\0';     	    Print(tmp);     	}     	break;s     }n       default: {@     	Print("!AS #!UL: !AS, Type=!UW, !AS, !13%D (unknown type)",?     	    xhdr, n, &ndsc, ((type&0xff00)>>8)+((type&0x00ff)<<8),n     	    &cldsc, &ttl);e     	break;n     }r       } /* switch */        *nspp = nsp_save + rdlength;   } /* Show_RR */, t /* **++ **  ROUTINE:	name_unpack ** **  FUNCTIONAL DESCRIPTION:u **; **  	Unpacks a domain name, decoding any offset references. G **  This is referenced through the NAME_UNPACK macro in other routines.w ** **  RETURNS:	void  ** **  PROTOTYPE: **> **  	name_unpack(unsigned char **bufptr, char *name, int size) **. **  bufptr: byte pointer, modify, by reference2 **  name:   ASCIZ_string, write only, by reference( **  size:   integer, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.R ** **  COMPLETION CODES:	None.R ** **  SIDE EFFECTS:   	None. ** **-- */G static void name_unpack(unsigned char **nspp, char *buf, int bufsize) {R       char seg[STRING_SIZE];      unsigned char *nsp, *offset;     char *bufp;s     unsigned short xoffset;e       nsp = *nspp;     if (!*nsp) {     	strcpy(buf, ".");     	*nspp += 1;     	return;     }m       bufp = buf;n     while (*nsp) {     	if (*nsp < 64) {t)     	    if (bufp-buf+*nsp < bufsize-2) {t$     	    	memcpy(bufp, nsp+1, *nsp);     	    	bufp += *nsp;i     	    	*bufp++ = '.';     	    	*bufp = '\0';s
     	    }     	    nsp += *nsp + 1; 
     	} else { '     	    BYTE_SWAP_UNPACK(nsp,xoffset); =     	    offset = nsbuf + (xoffset - 0xc000) + sizeof(short); 0     	    name_unpack(&offset, seg, sizeof(seg));     	    strcpy(bufp, seg);o     	    *nspp = nsp;      	    return;     	}     }      *nspp = nsp + 1;   } /* name_unpack */u   /* **++  **  ROUTINE:	check_inverse_query ** **  FUNCTIONAL DESCRIPTION:  **< **  	Converts dotted-decimal IP address into the appropriate **  	.IN-ADDR.ARPA name. ** **  RETURNS:	voidm ** **  PROTOTYPE: **$ **  	check_inverse_query(char *host) **. **  host:   ASCIZ_string, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.* ** **  COMPLETION CODES:	None.* ** **  SIDE EFFECTS:   	None. ** **-- */- static void check_inverse_query(char *host) {   -     char tmp[STRING_SIZE], tmp2[STRING_SIZE]; 
     char *cp;d  <     if (strspn(host, "0123456789.") != strlen(host)) return;       strcpy(tmp, host);     tmp2[0] = '\0'; 2     for (cp = tmp+strlen(tmp)-1; cp > tmp; cp--) {     	if (*cp == '.') {     	    strcat(tmp2, cp+1);     	    strcat(tmp2, ".");t     	    *cp = '\0';     	}     }e     strcat(tmp2, tmp);#     strcat(tmp2, ".IN-ADDR.ARPA.");a     strcpy(host, tmp2);,   } /* check_inverse_query */a