  #pragma module PPPD$LOGGER "X-3" /*N  *****************************************************************************  *  2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *  N  *****************************************************************************      
 	FACILITY:    		PPPD   
 	ABSTRACT:     A   		This routine provides the diagnostic logging capability.  The G 	logger runs as a detached process and is started up by the management  C 	utility.  The management utility will pass in the mailbox name as  D 	the SYS$INPUT string and the log file name as the SYS$OUTPUT stringC 	when the process with the logger is started.  The log process will F 	create the log file and write binary log messages into the log file. G 	Because we will be writing binary data the log file will be a variable H 	length record file instead of stream file.  The logger will continue toF 	write log records until it encounters a fatal error or until it get a7 	log record that indicates that it should stop logging.   A 		The logger works at two levels a main non-AST thread will write F 	log records to the file.  The AST thread will read the mailbox, queueH 	the log records to the mainline and start another read on the mailbox. G 	This scheme should be sufficiently quick enough to work for the ASYNCH G 	ports.  We may need to devise a faster mechanism when we and if we add  	support for ISDN lines.    	AUTHOR:   $ 		Forrest A. Kenney	14-December-1995    	REVISION HISTORY:   .   	X-3	BWK002 		Barry W. Kierstein	17-DEC-1996<                 Replaced the standard Digital copyright with6                 one compatible with the CMU copyright.  .   	X-2	BWK001 		Barry W. Kierstein	26-Jul-1996D                 Moved mailbox delete code to the EOF message section>                 so that the mailbox will not be deleted unless=                 we have a normal shutdown of the PPP tracing. '   		Changed the EFN used from 0 to 128.  */    " #pragma message disable (ALIGNEXT)      1 /* Include various necessary description files */    #include	<descrip.h> #include	<iodef.h> #include	<libdef.h>  #include	<lib$routines.h>  #include	<lnmdef.h>  #include	<rms.h> #include	<ssdef.h> #include	<starlet.h> #include	<stdio.h> #include	<stdlib.h>    #include	"pppd_log_if.h"# #include        "pppdutil_common.h"     ! /* Non-Shared module constants */    #define		EFN	PPPD_EFN  #define		FALSE	0 #define		MAXNAME	255 #define		TRUE	1       & /* Define several gloabl structures */   typedef struct item  {  short int	buff_size; short int	item;  char		*buffaddr; short int	*length; } ITEM;   A typedef struct	io_buff			/* I/O block used by logger code      */  { = int		*flink; 	      	/* forward and backard queue links    */  int		*blink;@ short	int	status;			/* IOSB used to mailbox read requests     */ short	int	byte_cnt;  	int	unused; logRecord	record; 
 } IO_BUFF;  2 struct	q_head				/* Queue head structure		      */ {  int		*flink; int		*blink; };        /* Forward routine references */     FILE			*create_log_file ();    int			open_mailbox();   ! IO_BUFF			*allocate_io_buffer ();   ( void			free_io_buffer (IO_BUFF *buffer);& void			mbx_read_ast (IO_BUFF *buffer);       /* Global Variables*/    FILE			*logfile;   short	int		mbx_chan;   int			exiting = FALSE; int			exit_status = SS$_NORMAL;   6 struct	q_head		 _align(QUADWORD)	buffer_queue = {0,0};3 struct	q_head		 _align(QUADWORD)	log_queue = {0,0};        /* **+  ** main - Main routine ** ** Functional Description: **J **	The program intitializes the environment and then hibernates waiting toK ** be awakened.  Once awakend it will remove a log record from the queue of O ** log records.  It will then examing the record and if the type is EOF it will M ** set the exiting flag.  Even if the log record is and EOF record it will be I ** written to the log file.  If it is not exiting it will see if there is M ** another entry to remove.  If no more entries it will hibernate once again.  **I **	When it is all done it will close the log file, flush any outstanding  O ** I/O on the mailbox, and request that the mailbox be deleted.  If any errors  J ** occured then the final exit status will be the error that triggered theO ** early exit.  Otherwise it will be any errors encountered as part of exiting.  ** ** ** Explicit Inputs:  ** **	None  ** ** Implicit Inputs:  **8 **	exiting		-	Flag indicating if program is finishing up **				processing> **	exit_status	-	Contains the reason while logging is stopping* **	logfile		-	FILE pointer to the log file> **	log_queue	-	Queue of I/O buffers to be written to log file 1 **	mbx_chan	-	VMS channel pointing logger mailboc  ** ** Local Variables:  **@ **	got_buf-status	-	Return status from removing entry from queue; **	log_buff	-	Pointer to current log buffer being processed 5 **	status		-	Return status from various routine calls  **	  ** ** Outputs:  **
 **       None  **	 ** NOTES:  **
 **       None  ** **-  */   main() {    int			got_buf_status; 
 int			status;    IO_BUFF			*log_buff;    , if (!(status = open_mailbox() & SS$_NORMAL)) {     return (status);  }    if (create_log_file() == NULL) {     return (exit_status); }    do { 6    got_buf_status = LIB$REMQHI(&log_queue, &log_buff);&    while (got_buf_status & SS$_NORMAL)    {H       fwrite((void *)&log_buff->record, log_buff->byte_cnt, 1, logfile);.       if (log_buff->record.msgType == LOG_EOF)       {           exiting = TRUE;G          /* No status is checked for these items as there is nothing */ 7          /* of any value that can be done about them */ '          status = SYS$CANCEL(mbx_chan);  #ifdef DEBUG_CODE q          log_buff->record.msgLen = sprintf ((char *)log_buff->record.msg, "Status for SYS$CANCEL = %8X", status); K          fwrite((void *)&log_buff->record, log_buff->byte_cnt, 1, logfile);  #endif'          status = SYS$DELMBX(mbx_chan);  #ifdef DEBUG_CODE q          log_buff->record.msgLen = sprintf ((char *)log_buff->record.msg, "Status for SYS$DELMBX = %8X", status); K          fwrite((void *)&log_buff->record, log_buff->byte_cnt, 1, logfile);  #endif       }        free_io_buffer(log_buff); 9       got_buf_status = LIB$REMQHI(&log_queue, &log_buff);     }    if (!exiting) SYS$HIBER(); / } while ((!exiting) || (log_queue.flink != 0));   H /* No status is checked for these items as there is nothing of any value!    that can be done about them */  fclose(logfile);   if (exit_status != SS$_NORMAL) {    status = exit_status;  }    return (status);   }        /* **+ 8 ** allocate_io_buffer - Get a free I/O buffer from queue ** ** Functional Description: **B **	This routine is used to get a free I/O buffer from the queue ofL ** available I/O buffers.  If the program is exiting then this routine will  ** return with an error. ** ** Explicit Inputs:  ** **	None  ** ** Implicit Inputs:  **	 * **	buffer_queue	-	Queue of free I/O buffer8 **	exiting		-	Flag indicating if program is finishing up **				processing ** ** Local Variables:  **> **	buff_addr	-	Pointer to free I/O buffer if one was available* **	status		-	Return status from LIB$REMQHI ** ** Outputs:  **' **	return_status	-	Address of buffer or " **	  LIB$_QUEWASEMP 	no I/O buffer) **        SS$_FORCEDEXIT 	program exiting  **	 ** NOTES:  **
 **       None  ** **-  */   IO_BUFF		*allocate_io_buffer() {   
 int			status;    IO_BUFF			*buff_addr;   
 if (!exiting)  { 2    status = LIB$REMQHI(&buffer_queue, &buff_addr);    if (status & SS$_NORMAL)     {       return(buff_addr);    }    else     {1       return((IO_BUFF *)malloc(sizeof(IO_BUFF)));     } }  else { %    return((IO_BUFF *)SS$_FORCEDEXIT);  }    }        /* **+ * ** create_log_file - Create a new log file ** ** Functional Description: **C **		This routine will create a new log file using the name obtained O ** by translating the logical name SYS$OUTPUT.  It will then open the log file.  ** ** Explicit Inputs:  ** **	None  ** ** Implicit Inputs:  **	 > **	exit_status	-	Contains the reason while logging is stopping8 **	logfile		-	File pointer log file that will be created ** ** Local Variables:  **5 **	attributes	-	Logical name translation attribute(s) * **	item_lst	-	Item list to pass to $TRNLNM4 **	log_name	-	String descriptor with logical name to **				translate : **	name_length	-	Length in byte of translated logical name! **	name_string	-	Translated name  / **	status		-	Return status from call to $TRNLNM > **	table_name	-	String descriptor with the logical name tables **				to be searched ** ** Outputs:  **0 **       FILE		-	C file pointer for the log file **	 ** NOTES:  **
 **       None  ** **-  */   FILE		*create_log_file() {   # $DESCRIPTOR(log_name,"SYS$OUTPUT"); , $DESCRIPTOR(table_name,"LNM$PROCESS_TABLE");# int		attributes = LNM$M_CASE_BLIND;  char		name_string[MAXNAME];  short int	name_length; int		status; ITEM		item_lst[2];      item_lst[0].buff_size = MAXNAME; item_lst[0].item = LNM$_STRING; # item_lst[0].buffaddr = name_string; " item_lst[0].length = &name_length; item_lst[1].buff_size = 0; item_lst[1].item = 0;  item_lst[1].buffaddr = 0;  item_lst[1].length = 0;     G status = SYS$TRNLNM(&attributes, &table_name, &log_name, 0, &item_lst);  if (status & SS$_NORMAL) { '    name_string[name_length] = (char) 0; T    logfile = fopen(name_string, "wb+", "ctx=rec", "rat=none", "rfm=var", "shr=get");    if (logfile == NULL)*    {E       exit_status = SS$_ABORT;  /* Dummy error if file open failed */C    }    else     {       exit_status = SS$_NORMAL;r    }    return (logfile); }r else {       exit_status = status;    return ((FILE *) NULL); }    }t     e /* **+t@ ** free_io_buffer - Put I/O buffer on queue of available buffers ** ** Functional Description: **J **	This routine will place a free I/O buffer on the queue of available I/O ** buffers.g ** ** Explicit Inputs:e **= **	buff_addr	-	Pointer to I/O buffer to be placed on queue of* **				free I/O buffers ** ** Implicit Inputs:e *** **	buffer_queue	-	Queue of free I/O buffer8 **	exiting		-	Flag indicating if program is finishing up **				processing> **	exit_status	-	Contains the reason while logging is stopping( **	mbx_chan	-	Channel number for mailbox ** ** Local Variables:A **% **	status		-	Return status from READ   ** ** Outputs:* **
 **       None* **	 ** NOTES:* **
 **       None* ** **-  */  ) void		free_io_buffer (IO_BUFF *buff_addr)  {	   int			ast_stat;e
 int			status;c    
 if (!exiting). {h(    LIB$INSQHI(buff_addr, &buffer_queue); }    }e       /* **+eD ** mbx_read_ast - Handle last log record and queue read for next one ** ** Functional Description: **G **  	This routine is called when a logger record has been read from theeM ** mailbox.  It makes sure that the read was successful and places the record O ** in the queue of records to be written to the log file.  If this is the firsteK ** entry on the queue it also wakes up the main line code.  If not it skips K ** waking the mainline on the assumption that it is already awake.  It theniL ** gets another buffer and queues another read to the loggers mailbox.  ThisN ** will continue until we get a sever error or until the exiting flag is set.  ** ** Explicit Inputs:i **$ **	buff_addr	-	Pointer to I/O buffer ** ** Implicit Inputs:a **8 **	exiting		-	Flag indicating if program is finishing up **				processing> **	exit_status	-	Contains the reason while logging is stopping; **	log_queue	-	Queue of logger records to be written to the. **				log file  ( **	mbx_chan	-	Channel number for mailbox ** ** Local Variables:  **" **	status		-	System status returns ** ** Outputs:  **
 **       Nones **	 ** NOTES:  **
 **       None  ** **-  */  & void		mbx_read_ast(IO_BUFF *buff_addr) {2  
 int			status;.  
 if (!exiting)- {6&    if (buff_addr->status & SS$_NORMAL)    {1       status = LIB$INSQTI(buff_addr, &log_queue);h"       if (status = LIB$_ONEENTQUE)       {           SYS$WAKE (0, 0);u       }t'       buff_addr = allocate_io_buffer();d0       if (((int)buff_addr != LIB$_QUEWASEMP) && -           ((int)buff_addr != SS$_FORCEDEXIT))y       {iK          status = SYS$QIO (EFN, mbx_chan, IO$_READVBLK, &buff_addr->status, G                            mbx_read_ast, buff_addr, &buff_addr->record,c:                            sizeof(logRecord), 0, 0, 0, 0);$          if (!(status & SS$_NORMAL))
          {             exiting = TRUE;n!             exit_status = status;n             SYS$WAKE (0, 0);
          }       }E    }    elseX    {       exiting = TRUE; &       exit_status = buff_addr->status;       SYS$WAKE (0, 0);    } }    }      f /* **+h" ** open_mailbox - Open the mailbox ** ** Functional Description: **C **		This routine will create a new log file using the name obtained	N ** by translating the SYS$OUTPUT.  It will allocate a couple of logger buffersL ** and place them on the queue of free buffers.  Then it will then assign a 3 ** channel to the mailbox and queue the first read.t ** ** Explicit Inputs:e ** **	None	 ** ** Implicit Inputs:; **		> **	exit_status	-	Contains the reason while logging is stopping( **	mbx_chan	-	Channel number for mailbox ** ** Local Variables:l **5 **	attributes	-	Logical name translation attribute(s)f' **	buff_addr	-	Pointer to an I/O bufferr= **	devname		-	String descriptor used to hold the mailbox name	 **	i		-	Random loop countern* **	item_lst	-	Item list to pass to $TRNLNM4 **	log_name	-	String descriptor with logical name to **				translatea: **	name_length	-	Length in byte of translated logical name! **	name_string	-	Translated name t2 **	status		-	Return status from call to SYS$TRNLNM> **	table_name	-	String descriptor with the logical name tables **				to be searched ** ** Outputs:r **; **       status 	-	return status from various system calls.e **	 ** NOTES:  **
 **       None  ** **-t */   int		open_mailbox()h {o  " $DESCRIPTOR(log_name,"SYS$INPUT");, $DESCRIPTOR(table_name,"LNM$PROCESS_TABLE");  # int		attributes = LNM$M_CASE_BLIND;h char		name_string[MAXNAME];r int		i;  int		status; IO_BUFF		*buff_addr; ITEM		item_lst[2];! struct dsc$descriptor_vs devname;h  " devname.dsc$w_maxstrlen = MAXNAME;% devname.dsc$b_dtype = DSC$K_DTYPE_VT;l% devname.dsc$b_class = DSC$K_CLASS_VS; $ devname.dsc$a_pointer = name_string;    item_lst[0].buff_size = MAXNAME; item_lst[0].item = LNM$_STRING; # item_lst[0].buffaddr = name_string; ; item_lst[0].length = (short int *)&devname.dsc$w_maxstrlen;s item_lst[1].buff_size = 0; item_lst[1].item = 0;  item_lst[1].buffaddr = 0;i item_lst[1].length = 0;a    G status = SYS$TRNLNM(&attributes, &table_name, &log_name, 0, &item_lst);o if (status & SS$_NORMAL) {o    for (i=0; i< 10; i++)    {9       free_io_buffer((IO_BUFF *)malloc(sizeof(IO_BUFF)));     }  2    buff_addr = (IO_BUFF *)malloc(sizeof(IO_BUFF));5    status = SYS$ASSIGN(&devname, &mbx_chan, 0, 0, 0);n    if (status & SS$_NORMAL)n    {H       status = SYS$QIO (EFN, mbx_chan, IO$_READVBLK, &buff_addr->status,D                         mbx_read_ast, buff_addr, &buff_addr->record,7                         sizeof(logRecord), 0, 0, 0, 0);	    } }  return (status);   };