I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I ************************************************************************* I **                                                                      * I **      Important Note:                                                 * I **                                                                      * I **         This coding example uses privileged OpenVMS interfaces.      * I **         OpenVMS does not guarantee that these interfaces will        * I **         be supported indefinitely, and may change these interfaces   * I **         without prior notice.                                        * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      fsm_if.h.  ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **       1-August-1996    Barry W. Kierstein< **                        Added "Important Note" disclaimer. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      29-November-1995  Original version.  ** **-- */ #ifndef _FSM_IF_H_ #define _FSM_IF_H_  O /*---------------------------------------------------------------------------*/ O /*                 Structure for Providing Callback Routines                 */ O /*---------------------------------------------------------------------------*/  typedef struct clientCallbacks { D     void (*open)();		/* Called to request a protocol be started   */E     void (*close)();		/* Notify that protocol has been stopped     */ G     void (*resetci)();		/* Reset our Configuration Information       */ E     int  (*cilen)();		/* Length of our Configuration Information   */ E     void (*addci)();		/* Add our Configuration Information         */ E     int  (*ackci)();		/* ACK our Configuration Information         */ E     int  (*nakci)();		/* NAK our Configuration Information         */ E     int  (*rejci)();		/* Reject our Configuration Information      */ E     int  (*reqci)();		/* Request peer's Configuration Information  */ B     void (*up)();		/* Called when fsm reaches OPENED state      */D     void (*down)();		/* Called when fsm leaves OPENED state       */G     int  (*extcode)();		/* Called when unknown code received         */  } clientCallbacks;  O /*---------------------------------------------------------------------------*/ O /*         Define the structure containing pointers to fsm routines          */ O /*---------------------------------------------------------------------------*/    typedef struct fsmRtns { 8     void (*deregisterNCP)( unsigned short ctrlProtcol );=     unsigned int (*registerNCP)( unsigned short ctrlProtocol, ! 			  clientCallbacks  *callbacks,  			  unsigned int     *error ); ,     void (*start)( void *fsmRef, int unit );!     void (*stop)( void *fsmRef ); 
 } fsmRtns;   #endif /* _FSM_IF_H */