 /**  ; Facility: < ;	ROUTINES.C	Copyright (c) 1991, 1992, 1993	Bruce R'. Miller ;							and TGV, Inc.  ;  ; Abstract: C ;	Routines called from FTS_PARSE.CLD to parce DCL args and dispatch  ;	commands.  ; 	 ; Author: ! ;	Bruce R. Miller, MILLER@TGV.COM  ;	TGV, Inc.  ;	603 Mission St.  ;	Santa Cruz, CA 95060 ;	(408) 427-4366 ;  ; Date:		May 10, 1991  ;  ; Notes:+ ;	Review and minimize procedure entry masks  ; 1 ; Copyright (c) 1991, 1992, 1993	Bruce R'. Miller  ; All rights reserved. ; A ;	Redistribution and use in source and binary forms are permitted A ;	provided that the above copyright notice and this paragraph are : ;	duplicated in all such forms and that any documentation,< ;	advertising materials, and other materials related to suchB ;	distribution and use acknowledge that the software was developed$ ;	by Bruce R'. Miller and TGV, Inc..> ;	THIS SOFTWARE IS PROVIDED AS IS'' AND WITHOUT ANY EXPRESS OR@ ;	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIEDE ;	WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  ;  ; Modifications: ;  **/    #include <descrip.h> #include <chfdef.h>  #include <climsgdef.h> #include <libdef.h>  #include <lnmdef.h>  #include <prtdef.h>  #include <psldef.h>  #include <rmsdef.h>  #include <ssdef.h>   #include "fts.h"  2 static	$DESCRIPTOR(jasmon_desc,"JASMON_DATABASE");1 static	$DESCRIPTOR(lnt_desc,"LNM$PROCESS_TABLE"); - static 	unsigned long EXEC_mode = PSL$C_EXEC;   E static char *Prot_Tab2[] = { 		/* sorted by prot code order (0-15) */  	"NA",				/* 0 */  	"RESRV",			/* 1 */  	"KW",				/* 2 */  	"KR",				/* 3 */  	"UW",				/* 4 */  	"EW",				/* 5 */  	"ERKW",				/* 6 */  	"ER",				/* 7 */  	"SW",				/* 8 */  	"SREW",				/* 9 */  	"SRKW",				/* A */  	"SR",				/* B */  	"URSW",				/* C */  	"UREW",				/* D */  	"URKW",				/* E */  	"UR"				/* F */ 	};      /**  ;	Get_Database ;  ; Input:3 ;	4(AP) - pntr to longword to hold database address  ; 	 ; Output: 
 ;	R0 - Status  ;	@4(AP) - database address  ; I ; Note:  We prevent JASMON from being loaded twice by defining a logical. M ;   We also use the local to store the address of the JASMON database (code). F ;   This is ugly.  I mean, really ugly.  We're talking butt-ugly.  AndE ;   to make matters worse, I don't think we're even doing that right.  **/   ! unsigned long Get_Database(dbptr)       unsigned long *dbptr; {  	unsigned long rc; 	char buffer[20];  	short retlen; 	unsigned long desc[2]; 	 	struct {  		short len;
 		short code;  		char *buffer;  		int *retlen; 	} ilst[2] = {' 		{ 20, LNM$_STRING, buffer, &retlen },  		{ 0, 0, 0, 0 }};   	/*  	 * Translate the logical name 	 */; 	rc = sys$trnlnm(0,&lnt_desc,&jasmon_desc,&EXEC_mode,ilst);  	if (ERROR(rc)) return(rc);    	/*  	 * Convert text to value  	 */$ 	desc[0] = retlen;	desc[1] = buffer; 	rc = ots$cvt_tz_l(desc,dbptr);  	return(rc); }    /**  ;	Set_Database ;  ; Input:6 ;	4(AP) - pntr to longword to holding database address ; 	 ; Output: 
 ;	R0 - Status  ; I ; Note:  We prevent JASMON from being loaded twice by defining a logical. O ;   We also use the logical to store the address of the JASMON database (code). F ;   This is ugly.  I mean, really ugly.  We're talking butt ugly.  AndE ;   to make matters worse, I don't think we're even doing that right.  **/    Set_Database(dbptr)       unsigned long *dbptr; {  	unsigned long rc; 	char hex_str[16];, 	unsigned long hex_desc[2] = { 8, hex_str };	 	struct {  		short len;
 		short code;  		char *buffer;  		int *retlen; 	} ilst[2] = {! 		{ 8, LNM$_STRING, hex_str, 0 },  		{ 0, 0, 0, 0 }};   	/* 0 	 * Are we setting the database, or clearing it? 	 */ 	if (!dbptr) { 		/* 		 * Delete the logical name 		 */ 7 		rc = sys$dellnm(&lnt_desc, &jasmon_desc, &EXEC_mode); 	 	} else {  		/* 		 * Convert value to text 		 */ ) 		rc = ots$cvt_l_tz(&dbptr,hex_desc,8,4);  		if (ERROR(rc)) return(rc);   		/* 		 * Translate logical name  		 */ @ 		rc = sys$crelnm(0, &lnt_desc, &jasmon_desc, &EXEC_mode, ilst); 	} 	return(rc); }      /** 5 ;  COMMAND:	ALONONPAGED - Grab us some non-paged pool  ; C ; Note: We need to add an alignment flag (eg. /QUAD, /PAGE. etc...)  ***/   FTS_AloNonPaged()  {  	unsigned long rc; 	int bytes = 512;  	unsigned long addr;   	/* 3 	 * get dcl argument - decimal value for block size  	 */( 	if (!ERROR(Check_DCL_Switch("SIZE"))) {" 		rc = Get_DCL_dec("SIZE",&bytes);  		if (ERROR(rc)) lib$signal(rc); 	}   	/* # 	 * Call exec to grab some npagdyn.  	 */# 	rc = MM_AloNonPaged(&addr,&bytes);  	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Print a message  	 */@ 	printf("  Allocated %4d(^x%x) bytes at %x\n",bytes,bytes,addr);   	return(rc); }        /**  ;  COMMAND:	Crash  ;  ;	Crash VMS. **/    FTS_Crash()  {  	unsigned long rc; 	unsigned long pid;  	unsigned long args[2];  	extern Crash_VMS();   	/* 2 	 * get dcl argument - hex ID for process to blame 	 */' 	if (!ERROR(Check_DCL_Switch("PID"))) {  		rc = Get_DCL_dec("PID",&pid);   		if (ERROR(rc)) lib$signal(rc); 	}   	/* " 	 * Call crash code in kernel mode 	 */
 	args[0] = 1;  	args[1] = pid; ! 	rc = sys$cmkrnl(Crash_VMS,args);  	if (ERROR(rc)) lib$signal(rc);  	return(rc); }        /**  ;  COMMAND:	CretVA ; 2 ;	Create some virtual addresses in specified range ;  **/      FTS_CretVA() {  	unsigned long rc; 	unsigned long Start_VA,End_VA; % 	unsigned long inaddr[2], retaddr[2];  	unsigned long mode;   	/*  	 * Get the starting VA  	 */' 	rc = Get_DCL_hex("STARTVA",&Start_VA);  	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Get the ending VA  	 */# 	rc = Get_DCL_hex("ENDVA",&End_VA);  	if (ERROR(rc)) lib$signal(rc);    	/* & 	 * get dcl argument - page protection 	 */$ 	rc = Get_DCL_access("ACCESS",mode);$ 	if (ERROR(rc)) mode = PSL$C_KERNEL;   	/*  	 * Print information message  	 */* 	printf("Mapping VA [%x,%x] to mode %x\n", 	       Start_VA,End_VA,mode);   	/* ) 	 * Call system service to map the new VA  	 */+ 	inaddr[0] = Start_VA;  inaddr[1] = End_VA; & 	rc = sys$cretva(inaddr,mode,retaddr); 	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Print success message  	 */) 	printf("Mapped VA [%x,%x] to mode %x\n", $ 	       retaddr[0],retaddr[1],mode);   	return(rc); }      /**  ;  COMMAND:	DEANONPAGED  ;  ;	Free some non-paged pool ;  **/    FTS_DeaNonPaged()  {  	unsigned long rc; 	unsigned long addr,size;    	/* # 	 * Get the virtual address into R2  	 */# 	rc = Get_DCL_hex("ADDRESS",&addr);  	if (ERROR(rc)) lib$signal(rc);    	/* 9 	 * get dcl argument - decimal value for block size in R3  	 */  	rc = Get_DCL_dec("SIZE",&size); 	if (ERROR(rc)) size = 0;    	/*  	 * Call exec to free npagdyn. 	 */" 	rc = MM_DeaNonPaged(&addr,&size); 	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Print a message  	 */A 	printf("  Deallocated %d(^x%x) bytes at %08x\n",size,size,addr);    	return(rc); }        /**  ;  COMMAND:	Deposit  ; 2 ;	Deposit a value at the specified memory location ;  **/     
 FTS_Deposit()  {  	unsigned long rc;' 	unsigned long addr,value,size,pid,tmp;   7 	/* get dcl argument - hex value for memory location */ $ 	rc = Get_DCL_hex("LOCATION",&addr); 	if (ERROR(rc)) lib$signal(rc);   2 	/* get dcl argument - value for reference size */! 	rc = Get_DCL_size("SIZE",&size);  	if (ERROR(rc)) size = 4;   + 	/* get dcl argument - hex value for PID */  	rc = Get_DCL_pid("PID",&pid); 	if (ERROR(rc)) pid=0;  - 	/* get dcl argument - hex value for value */ " 	rc = Get_DCL_hex("VALUE",&value); 	if (ERROR(rc)) lib$signal(rc);    	/* Print attempt message */9 	printf("Attempting to deposit %x at %08x\n",value,addr); 
 	tmp = value;    	/*  	 * Call Deposit routine 	 */$ 	rc = Deposit(addr,size,pid,&value); 	if (ERROR(rc)) {  		/* Print error message */ # 		printf("Access error = %x\n",rc); 	 	} else {  		/* Print success message */ 4 		printf("New value: %x Old value: %x\n",tmp,value); 	} 	return(rc); }        /**  ;  COMMAND:	Deq  ; 2 ;	Deposit a value at the specified memory location ;  **/   	 FTS_Deq()  {  	unsigned long rc; 	unsigned long lid,mode,pid;  / 	/* get dcl argument - hex value for lock id */ ! 	rc = Get_DCL_hex("LOCKID",&lid);  	if (ERROR(rc)) lib$signal(rc);   / 	/* get dcl argument - value for access mode */ # 	rc = Get_DCL_access("MODE",&mode); " 	if (ERROR(rc)) mode = PSL$C_USER;  + 	/* get dcl argument - hex value for PID */  	rc = Get_DCL_pid("PID",&pid);9 	if (ERROR(rc)) pid = 0;			/* use this proc as default */  	  	/* Print attempt message */7 	printf("Attempting to dequeue lock, id = %08x\n",lid);    	/*  	 * Call Deq routine 	 */ 	rc = Deq(lid,mode,pid);) 	if (ERROR(rc))	/* Print error message */ 6 		printf("Error = ^x%x (from $DEQ or $GETLKIW)\n",rc);! 	else /* Print success message */ % 		printf("Dequeued lock %08x\n",lid);    	return(rc); }       
 FTS_DFWM() {  	unsigned long rc; 	unsigned long addr;   	rc = DFWM(&addr); 	if (ERROR(rc)) lib$signal(rc);   ( 	printf("EXE$GRANT_LICENSE+2 = %08x\n");   	return(rc); }        /**  ; Description: ; : ;	A routine to handle people who enter silly things at the ;	FTS> prompt	 ;  **/    FTS_Directory()  { # 	printf("Nothing happens here.\n");  	return(SS$_NORMAL); }        /**  ;  COMMAND:	Examine  ; ' ;	Examine the specified memory location  **/   
 FTS_Examine()  {  	unsigned long rc; 	unsigned long addr,size,pid;  	unsigned char buffer[32]; 	int i;   7 	/* get dcl argument - hex value for memory location */ $ 	rc = Get_DCL_hex("LOCATION",&addr); 	if (ERROR(rc)) lib$signal(rc);   2 	/* get dcl argument - value for reference size */! 	rc = Get_DCL_size("SIZE",&size);  	if (ERROR(rc)) { ( 		if (rc != CLI$_ABSENT) lib$signal(rc); 		size = 4;  	}  + 	/* get dcl argument - hex value for PID */  	rc = Get_DCL_pid("PID",&pid); 	if (ERROR(rc)) { ( 		if (rc != CLI$_ABSENT) lib$signal(rc);
 		pid = 0; 	}   	/* Clear out the buffer */ $ 	for (i=0; i<32; i++) buffer[i] = 0;   	/*  	 * Call Examine routine 	 */$ 	rc = Examine(addr,size,pid,buffer);) 	if (ERROR(rc))	/* Print error message */ # 		printf("Access error = %x\n",rc); ! 	else /* Print success message */ ! 		printf("%x\n",*(long *)buffer);    	return(rc); }        /**  ; Description:1 ;	A CLI Dispatch routine to exit the FTS Utility.  ;  ; Note: 3 ;	As the End Of File condition must not be stopped.  **/   
 Exit_FTS() {  	return(RMS$_EOF); }      /**  ;  COMMAND:	ForceX ; ' ;	Forces image exit in a given process.  ;  **/    FTS_ForceX() {  	unsigned long rc; 	unsigned long pid,rcode;    	/* " 	 * get dcl argument - Process ID  	 */ 	rc = Get_DCL_pid("PID",&pid); 	if (ERROR(rc)) lib$signal(rc);    	/* 0 	 * get dcl argument - hex value for return code 	 */" 	rc = Get_DCL_hex("RCODE",&rcode); 	if (ERROR(rc)) {  		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		rcode = SS$_NORMAL;  	}  A 	printf("  Forcing exit of process %08x with RC=%x\n",pid,rcode);    	/* < 	 * Call system service to invoke the pocesses exit handler. 	 */ 	rc = sys$forcex(&pid,0,rcode);  	if (ERROR(rc)) lib$signal(rc);  	return(rc); }        /**  ;  COMMAND:	Halt ;  ;	HALT the VAX.  **/   
 FTS_HALT() {  	unsigned long rc; 	extern Halt_VAX();    	/* ( 	 * Call HALT instruction in kernel mode 	 */ 	rc = sys$cmkrnl(Halt_VAX,0);  	if (ERROR(rc)) lib$signal(rc);    	return(rc); }        /**  ;  COMMAND:	HELP ;   ;  Will give user a little help. **/   
 FTS_Help() { K     printf("Welcome to FTS, the Functionality Testing Suite (aka Futz)\n"); M     printf("FTS is a collection of dangerous utility programs that would\n"); O     printf("like nothing better than to crash your system.  The authors of\n"); Q     printf("the various packages contained herein disavow any responsibility\n"); C     printf("for the bone-headed things you are about to try.\n\n"); A     printf("Some Commands: (Read FTS_PARSE.CLD for details).\n"); J     printf("ALONONPAG | DEANONPAGED\tAlocate and free some npageddyn.\n");G     printf("EXAM | DEPOSIT\t\tExamine or modify a memory location.\n"); -     printf("EXIT\t\t\tLeave the program.\n"); D     printf("FORCEX pid [/rcode]\tForce another process to exit.\n");J     printf("[UN]LOAD JASMON\t\tstart/stop the system service monitor.\n");D     printf("LOAD XDT\t\tInvoke XDelta, loading it if necessary.\n");C     printf("[UN]WATCH [SS|RMS] srvc\tMonitor a system service.\n"); N     printf("WATCH SS QIO[W] device\tMonitor $QIO calls to a given device.\n");K     printf("WATCH DEVICE device\tMonitor FDT access to a given device.\n"); F     printf("VERSION\t\t\tDisplay info about authors and commands.\n");C     printf("CRASH | HALT\t\tCause the system to crash or halt.\n");        return(SS$_NORMAL);  }        /** 
 ; JASMON_LOAD  ;  ; Description:$ ;	Load the JASMON code into P1 space **/    FTS_Load_Jasmon()  {  	unsigned long rc; 	unsigned long database;   	rc = JASMON_Load(&database);  	return(rc); }        /**  ; FTS_LOAD_XDT ;  ; Description:) ;	Invoke XDelta, loading it if necessary.  **/    FTS_Load_XDT() {  	unsigned long rc;   	rc = LDXDT(); 	if (ERROR(rc)) lib$signal(rc);  	return(rc); }        /**  ;	FTS_Show_Error ;  ; Description: ;	Evaluate a condition code  **/    FTS_Show_Error() {  	unsigned long rc,rcode; 	struct chf$signal_array sig;   3 	/* get dcl argument - hex value for Return code */ " 	rc = Get_DCL_hex("RCODE",&rcode); 	if (ERROR(rc)) lib$signal(rc);    	/*  	 * set up signal array  	 */ 	sig.chf$l_sig_args = 0; 	sig.chf$l_sig_name = rcode; 	sig.chf$l_sig_arg1 = 0;   	/*  	 * Print the signal text  	 */ 	rc = sys$putmsg(&sig,0,0,0);    	return(rc); }        /**  ;	FTS_Show_Page  ;  ; Description:" ;	Display info about a memory page **/    FTS_Show_Page()  {  	unsigned long rc; 	unsigned long addr,size,prot;  * 	/* get dcl argument - hex value for VA */  	rc = Get_DCL_hex("ADDR",&addr); 	if (ERROR(rc)) lib$signal(rc);   , 	/* get dcl argument - hex value for size */% /*	rc = Get_DCL_hex("SIZE",&size); */ $ /*	if (ERROR(rc)) lib$signal(rc); */   	/*  	 * Get the page protection  	 */! /*	rc = Show_Page(addr,&prot); */  	if (ERROR(rc)) lib$signal(rc);    	/* Print success message */" 	printf("protection = %x\n",prot);   	return(rc); }        /**  ; Functional Description:  ;  ;	Call LIB$SPAWN.  **/    Spawn(command)      char *command;  {  	unsigned long rc;; 	unsigned long command_desc[2] = {strlen(command),command};   / 	rc = lib$spawn(command,0,0,0,0,0,0,0,0,0,0,0);  	if (ERROR(rc)) lib$signal(rc);  }    /**  ;	FTS_Spawn  ;  ; Functional Description:  **/    FTS_Spawn()  {  	unsigned long rc; 	char command[512];    	/* print a blank line */  	printf("\n");   	/* Get command line */ 1 	rc = Get_DCL_Switch("Command_line",command,512);  	if (ERROR(rc)) {  		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		command[0] = '\0'; 	} 		 	rc = Spawn(command);  	return(rc); }        /**  ;	FTS_Set_Page ;  ; Description: ;	Modify a memory page **/    FTS_Set_page() {  	unsigned char *addr; # 	unsigned long size,prot,prev_prot; 
 	char *cp; 	unsigned long rc;   	/* 3 	 * get dcl argument - hex value for VA into "addr"  	 */  	rc = Get_DCL_hex("ADDR",&addr); 	if (ERROR(rc)) lib$signal(rc);    	/* 1 	 * get dcl argument - hex value for size into R3  	 */  	rc = Get_DCL_hex("SIZE",&size); 	if (ERROR(rc)) {  		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		size = 4;  	}   	/* 2 	 * get dcl argument - new page protection into R4 	 */' 	rc = Get_DCL_prot("PROTECTION",&prot);  	if (ERROR(rc)) {  		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		prot = 16;
 		return(rc);  	}   	/*  	 * Modify the page protection 	 */* 	rc = Set_Page(addr,size,prot,&prev_prot); 	if (ERROR(rc)) lib$signal(rc);    	/* ' 	 * Convert protection code to a string  	 */  	cp = Prot_Tab2[prev_prot&0x0F];   	/*  	 * Print success message  	 */: 	printf("Previous protection = %02x (%s)\n",prev_prot,cp);   	return(rc); }        /**  ;  COMMAND:	SHOW DEFAULT ; 4 ;	Display the default directory for a given process. **/    FTS_Show_Default() {  	char buf[128];  	unsigned long rc,pid;   	rc = Get_DCL_pid("PID",&pid); 	if (ERROR(rc)) lib$signal(rc);     	rc = Show_Default(pid,buf,128); 	if (ERROR(rc)) lib$signal(rc);	   	buf[1+buf[0]] = '\0';0 	printf("Default directory for PID %08x = %s\n", 	       pid,buf+1);t   	return(SS$_NORMAL); }c   /**o ;	FTS_Show_Deviceh ;  ; Description:" ;	Show detailed device information **/    FTS_Show_Device()  {z 	unsigned long rc; 	char device[64];e  ) 	rc = Get_DCL_Switch("DEVICE",device,64);m 	if (ERROR(rc)) lib$signal(rc);    	rc = Show_Device(device); 	if (ERROR(rc)) lib$signal(rc);h   	return(rc); }	   /**i ;	FTS_Show_Ether ;r ; Description:$ ;	Show EtherNet datalink information **/v   FTS_Show_Ether() {t 	printf("NYI (RSN)\n");l }t       /**h ;  COMMAND:	SHOW LOGICAL ;t5 ;	Display the value of a logical for a given process.t **/    FTS_Show_Logical() {u 	char buf[128];a 	unsigned long rc,pid;   	rc = Get_DCL_pid("PID",&pid);  	if (ERROR(rc)) lib$signal(rc);;    	rc = Show_Logical(pid,buf,128);  	if (ERROR(rc)) lib$signal(rc);;  2 	printf("Default directory for PID %08x = [%s]\n", 	       pid,buf);I   	return(SS$_NORMAL); }O   /** 
 ;	FTS_Unwasten ;  ; Description:' ;	Get a process out of the RWAST state.i **/e  
 FTS_Unwaste()i {u 	printf("NYI (RSN)\n");< 	return(SS$_NORMAL); }d       /**u2 ;	Print information about current version of FTS.; **/   
 FTS_Version()" { 9     printf("\nCurrent FTS version is %s.\n",FTS_VERSION);$U     printf("All comments should be directed to Bruce R'. Miller (MILLER@TGV.COM)\n");C[     printf("Thanks go to TGV Inc. for allowing me to blow off work and play with this.\n");*[     printf("Finacial compensations should be redirected to your company's beer fund.\n\n");	*     printf("Module\t\tVersion\tAuthor\n");A     printf("JASMON\t\tA1.0\tBruce R. Miller (MILLER@TGV.COM)\n");AA     printf("DEVWATCH\tA1.0\tBruce R. Miller (MILLER@TGV.COM)\n"); Q     printf("LOADXDT\t\tV1.0\tKen Johnson - Meridian Technology Corporation\n\n");nO     printf("Note: Contact author for latest version of software.  Please\n\n");- }a       /**) ;  COMMAND:	Wake ; ; ;	Call SYS$WAKE to wake the given process from hibernation.i **/a  
 FTS_Wake() {e 	unsigned long rc; 	unsigned long pid;o   	/*A5 	 * get dcl argument - hex value for Process ID in R2l 	 */ 	rc = Get_DCL_hex("PID",&pid); 	if (ERROR(rc)) lib$signal(rc);n   	/*k 	 * Print attempt messaget 	 */4 	printf("Attempting to wake up process %08x\n",pid);   	/**, 	 * Call system service to wake the pocesses 	 */ 	rc = sys$wake(&pid,0);  	if (ERROR(rc)) lib$signal(rc);r   	return(rc); }e   	   /**u ; JASMON_UNLOADt ;; ; Description:& ;	Unload the JASMON code from P1 space **/	   FTS_Unload_Jasmon()  {  	unsigned long rc;   	rc = JASMON_Unload(); 	return(rc); }c   m   /**,2 ;	FTS_UNWATCH_RMS - stop monitoring an RMS service ;  **/    FTS_Unwatch_RMS()  {  	unsigned long rc; 	char service[32]; 	unsigned long serv_desc[2];   	/*r 	 * Get service name from DCLa 	 */+ 	rc = Get_DCL_Switch("SERVICE",service,32);  	if (ERROR(rc)) lib$signal(rc);u  	serv_desc[0] = strlen(service); 	serv_desc[1] = service;   	/* Call JASMon code */	  	rc = JASMON_UnWatch(serv_desc); 	return(rc); }e     FTS_Unwatch_SS() {N 	unsigned long rc; 	char service[32]; 	unsigned long serv_desc[2];   	/*t 	 * Get service name from DCLr 	 */+ 	rc = Get_DCL_Switch("SERVICE",service,32);  	if (ERROR(rc)) lib$signal(rc);   	serv_desc[0] = strlen(service); 	serv_desc[1] = service;   	/* Call JASMon code */	  	rc = JASMON_UnWatch(serv_desc); 	return(rc); };   h   FTS_Watch_Device() {r 	unsigned long rc; 	char device[64];  	unsigned long device_desc[2]; 	unsigned long scratch; 3 	unsigned long FDT_flag,ALTSTART_flag,STARTIO_flag,   		      CANCEL_flag,IOPOST_flag; 	unsigned long style;	  ) 	rc = Get_DCL_Switch("DEVICE",device,64);s 	if (ERROR(rc)) lib$signal(rc);*! 	device_desc[0] = strlen(device);  	device_desc[1] = device;r   	/*s8 	 * Figure out the display style (device specific stuff) 	 */' 	rc = Get_DCL_qiostyle("STYLE",&style);, 	if (ERROR(rc)) {_ 		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		style = STYLE_K_DEFAULT; 	}   	/*  	 * Scan for flags 	 */* 	IOPOST_flag = Check_DCL_Switch("IOPOST");* 	CANCEL_flag = Check_DCL_Switch("CANCEL");, 	STARTIO_flag = Check_DCL_Switch("STARTIO");. 	ALTSTART_flag = Check_DCL_Switch("ALTSTART");$ 	FDT_flag = Check_DCL_Switch("FDT");   	rc = DevWatch(device_desc,(, 		      FDT_flag,ALTSTART_flag,STARTIO_flag,  		      CANCEL_flag,IOPOST_flag, 		      &scratch,style); 	if (ERROR(rc)) lib$signal(rc);n   	return(rc); }    A   FTS_Watch_RMS()y {) 	unsigned long rc; 	char service[32]; 	unsigned long serv_desc[2];   	/*i 	 * Get service name from DCLs 	 */+ 	rc = Get_DCL_Switch("SERVICE",service,32);  	if (ERROR(rc)) lib$signal(rc);   	serv_desc[0] = strlen(service); 	serv_desc[1] = service;   	/* Call JASMon code */	 	rc = JASMON_Watch(serv_desc); 	return(rc); }      FTS_Watch_SS() {- 	unsigned long rc; 	char service[32]; 	unsigned long serv_desc[2]; 	unsigned long dbptr;d   	/*" 	 * Get service name from DCLs 	 */+ 	rc = Get_DCL_Switch("SERVICE",service,32);e 	if (ERROR(rc)) lib$signal(rc);g  	serv_desc[0] = strlen(service); 	serv_desc[1] = service;   	/* Call JASMon code */	% 	rc = JASMON_Watch(serv_desc,&dbptr);	 	return(rc); }a   m   FTS_Watch_SS_QIO() {e 	char device[64];* 	char service[16]; 	unsigned long device_desc[2]; 	unsigned long serv_desc[2]; 	unsigned long rc; 	unsigned long style;g   	/*g/ 	 * Get the name of the system service (QIO[W])r 	 */+ 	rc = Get_DCL_Switch("SERVICE",service,16);r 	if (ERROR(rc)) lib$signal(rc);   	serv_desc[0] = strlen(service); 	serv_desc[1] = service;   	/* ) 	 * get the name of the device to monitore 	 */) 	rc = Get_DCL_Switch("DEVICE",device,64);_ 	if (ERROR(rc)) lib$signal(rc);E! 	device_desc[0] = strlen(device);/ 	device_desc[1] = device;e   	/* 8 	 * Figure out the display style (device specific stuff) 	 */' 	rc = Get_DCL_qiostyle("STYLE",&style);  	if (ERROR(rc)) {n 		if (rc != CLI$_ABSENT) 			lib$signal(rc); 		style = STYLE_K_DEFAULT; 	}   	/*o1 	 * Call JASMON_Watch_QIO(&service,&device,style)/ 	 */4 	rc = JASMON_Watch_QIO(serv_desc,device_desc,style);   	return(rc); }        /** Do nothing **/
 FTS_NOOP() {r 	return(SS$_NORMAL); }      /** Hello - User said "Hi!" **/e FTS_Hello()e {o 	char who_str[64];	 	int who;( 	unsigned long rc;, 	unsigned long param_desc[2] = { 3, "WHO" };   	/*h 	 * Get hello text 	 */ 	rc = cli$present(param_desc); 	if (rc == CLI$_ABSENT) {) 		printf("Hi!\n"); 		return(SS$_NORMAL);u 	} 	if (ERROR(rc)) lib$signal(rc);n 	  	/*/ 	 * Lookup recipient 	 */  	rc = Get_DCL_hello("WHO",&who); 	if (ERROR(rc)) {e 		if (rc != LIB$_UNRKEY) 			lib$signal(rc); 	} 	switch (who) { 
 		case 1 : 			printf("Howdy,\n");. 			printf("\tCall bruce at (408) 427-4366\n");2 			printf("\tor send e-mail to MILLER@TGV.COM\n"); 			printf("\tHave a day.\n"); 	 			break;	
 		case 2 :% 			printf("Nothing happens here.\n");m	 			break;n 		default :  			printf("Nobody home.\n"); 	} 	return(SS$_NORMAL); }d   FTS_XYZZY()d {pL 	printf("You find yourself in a maze of twisty dollar signs, all alike.\n"); 	return(RMS$_EOF); } 