          PROGRAM LIST
C
C         AUTHOR
C           JONATHAN C. BAKER     N23 -> N23A -> N86 -> N861
C         DATE
C           2  JUN 1987
C           9  JUN 1987  JON BAKER
C                        ADDED OUTPUT SPECIFIER AND HANDLE LIST OF
C                        USERNAME BY *  AS IN FULL NAME SEARCH
C           17 JUN 1987  JON BAKER
C                        NUMBER SELECTED IN LIST SEARCH
C           19 DEC 1987  JON BAKER
C                        ADDED HEADERS AND ARRANGEMENT OF LIST WITH
C                        LAST NAME SORT
C           4  JUL 1988  JON BAKER
C                        LAST NAME SEARCH BY INDEX INSTEAD OF SEQUENTIAL
C           22 AUG 1988  JON BAKER
C                        READONLY ON OPEN TO ALLOW THE WORLD PROTECTION
C                        FOR THE INDEX FILE TO EXCLUDE WRITE ACCESS.
C           19 DEC 1988  JON BAKER
C                        FIX \ OPTION IF USER PLACES NO CHARACTERS AFTER
C                        OPTION.
C           18 MAY 1990  JON BAKER
C                        FIX OUTPUT MASK.
C           14 AUG 1990  JON BAKER
C                        ALLOW DELETION THROUGH LIST, INSTEAD OF SUPPORT
C                        PROGRAMS.
C           25 AUG 1990  JON BAKER
C                        ALLOW ADDING OF USERS THROUGH LIST, INSTEAD OF
C                        SUPPORT PROGRAMS.
C           07 JAN 1991  JON BAKER
C                        RENAME USERNAME ABILITY ADDED
C           11 JAN 1991  JON BAKER
C                        ADDING GROUP TO LIST
C           24 JAN 1992  JON BAKER
C                        ADDED /LISTING AND /COMPRESS QUALIFIERS
C           19 MAY 1993  JON BAKER
C                        ADD EMPLOYER FIELD AND DATE LAST MODIFIED FIELD
C                        ADD /FULL AND /CHECK QUALIFIERS AS WELL AS
C                        CHECK SUBROUTINE
C           21 MAY 1993  JON BAKER
C                        ADD /CLEANUP ROUTINE AND UIC
C           13 JAN 1994  JON BAKER
C                        MODIFY OUTPUT OF /FULL QUALIFIER TO MAKE EASIER
C                        TO READ
C           15 JAN 1994  JON BAKER
C                        ADD DISABLE_CHECK ROUTINE AND DISPLAY IF USER
C                        ACCOUNTS ARE DISABLED IN CONJUCTION WITH /FULL
C                        QUALIFIER.
C           25 MAR 1994  JON BAKER
C                        ADD /BORING QUALIFIER FOR MUNDANE AND BORING ERROR
C                        MESSAGES REFERENCING INSUFFICIENT PRIVILEGES.
C            1 JUN 1994  JON BAKER
C                        ADD /ACCOUNT_FIELD TO ALLOW SYSTEM ADMINISTRATOR
C                        CHOICE OF SYSUAF.DAT FIELD TO USE (ADAPTED FROM
C                        LAST UTILITY).
C           26 JUL 1994  JON BAKER
C                        ADD .PLAN FILE CAPABILITY (STEALING IDEA FROM FINGER).
C                        CREATE DISPLAY_PLAN ROUTINE
C           29 JUL 1994  JON BAKER
C                        ADD PROCEDURE TO REMOVE CONTROL CHARACTERS FROM
C                        LIST.PLAN OUTPUT SO AS NOT TO INTERFERE WITH DISPLAY.
C                        (ALLOW FOR NULL AND HORIZONTAL TAB CHARACTERS).
C            1 AUG 1994  JON BAKER
C                        FIX OUTPUT OVERFLOW STATEMENT FOR PLAN WHEN WRITTING
C                        TO OUTPUT FILE.
C           11 SEP 1995  JON BAKER
C                        IN CLEANUP, MODIFY STALE GROUPS AND UIC'S FOR USERS
C                        MOD DATE IS NOT CHANGED INCASE A PHONE NUMBER MAY
C                        HAVE POSSIBLY CHANGED.
C           26 NOV 1996  JON BAKER
C                        MODIFY A FEW HEADER DISPLAYS
C 2.4       05 JUN 1997  JON BAKER
C                        ADD /CROSS_CHECK FROM SYSUAF TO LIST DATABASE
C           06 JUN 1997  JON BAKER
C                        ADD OPEN_SYSUAF routine
C           08 JUN 1997  JON BAKER
C                        ADD /IGNORE for /CROSS_CHECK
C 2.4-A     18 DEC 1997  JON BAKER     (MODIFY)
C                        FIX PROBLEM OF HITTING <RETURN> ON EMPLOYER FIELD
C                        WHEN USING LIST/MODIFY/USER=<user>
C 2.4-A1    11 FEB 1998  JON BAKER     (LENGTH)
C                        EXCLUDE TABS AS WELL AS SPACES
C
C         PURPOSE
C           TO DISPLAY USERS IN THE USER PHONE.BOOK
C         DESCRIPTION
C           DISPLAY ACCORDING TO THE INPUT
C         COMMUNICATIONS
C  S        ADD          : ADDS USERS TO LIST
C  S        AUTHINFO     : LOOK INTO SYSUAF FOR GROUP
C  S        CHECK        : CHECK TO SEE IF TIME TO UPDATE RECORD
C  S        CLEAN_PLAN   : REMOVE CONTROL CHARACTERS FROM LIST.PLAN DISPLAY
C  S        CLEAN_UP     : DELETE RECORDS THAT HAVE NO CORRESPONDING SYSUAF
C  S        CLOSE_INPUT  : CLOSE INPUT FILE
C  S        COMPRESS     : COMPRESS A STRING
C  S        CROSS_CHECK  : CHECKS TO SEE IF ALL ENTRIES IN SYSUAF IN DATABASE
C  S        DELETE       : DELETES USERS FROM LIST
C  F        DISABLE_CHECK: CHECK TO SEE IF USER ACCOUNT IS DISABLED
C  S        DISPLAY_PLAN : WRITE OUT PLAN FILE
C  S        GROUP_LIST   : LIST BY GROUP
C  S        FILE_COMP    : FILE COMPRESSION ROUTINE
C  F        IGNORE       : CHECK IF IGNORE USER ACCOUNT FROM CROSS_CHECK
C  F        LENGTH       : FINDS LENGTH OF STRING UP TO FIRST BLANK
C  S        MODIFY       : MODIFY USER'S INFORMATION
C  S        NAME_LIST    : LIST BY NAME
C  F        NUMBER_CHECK : CHECK TO SEE IF PHONE NUMBER IN GOOD FORMAT
C  S        OPEN_INPUT   : OPEN INPUT FILE IN APPROPRIATE MANNER
C  S        PRINT_HEADER : PRINT THE OUTPUT HEADERS
C  S        RENAME       : RENAME USERNAME
C  F        SYSPRIV      : CHECKS FOR SYSPRV PRIVELEGE
C  S        USER_LIST    : LIST BY USERNAME
C
C         LOCAL GLOSSARY
C           LEN       : LENGTH OF OUTPUT FILE
C           LOGLEN    : LENGTH OF RETURNED LOGICAL
C           LOGPLAN   : PLAN LENGTH, CHARACTER BASED
C           LOOKFOR   : KEY TO LOOK FOR
C           OUT       : OUTPUT FILE
C           OUTPUT    : OUTPUT QUALIFIER
C           PLAN$LENGTH
C                     : NUMERICAL LOGPLAN
C           SELECT    : COUNTER OF NUMBER OF USERS SELECTED FROM KEY
C           STATUS    : RETURN VARIABLE
C           UNT       : UNIT NUMBER FOR OUTPUT
C
C         INCLUDES
C
          INCLUDE '($LNMDEF)'
          INCLUDE '($SSDEF)'
          INCLUDE '($SYSSRVNAM)'
          INCLUDE '($PSLDEF)'
C
C         FORMATS
C
  115     FORMAT(A2,1X,I4,2X,A33)
  151     FORMAT(I2)
  120     FORMAT($,X,'_Enter user:  ')
  200     FORMAT(X,'%LIST-E-NOSUCHUSR, No such user  ',A)
  210     FORMAT(A12)
C
C
C         STRUCTURE
C
          STRUCTURE    /TRNLNM_ITEM/
            UNION
              MAP
                INTEGER*2      BUFLEN, ITEM_CODE
                INTEGER*4      BUFADR, RETLEN
              END MAP
              MAP
                INTEGER*4      END_LIST
              END MAP
            END UNION
          END STRUCTURE

          RECORD  /TRNLNM_ITEM/  TRANSLOG(2)
C
C         DECLARE VARIABLES
C
          INTEGER*4      CLI$GET_VALUE, SELECT, LEN, LOGLEN
          INTEGER*4      STATUS, UNT, LENGTH, PLAN$LENGTH
          CHARACTER*2    LOGPLANX
          CHARACTER*31   LOOKFOR
          CHARACTER*35   OUT
          CHARACTER*255  LOGPLAN
          LOGICAL        OUTPUT, CLI$PRESENT, USER_LIST
C
C         COMMON BLOCK
C
          COMMON /PLAN/ PLAN$LENGTH
C
C         DETERMINE PATH OF ACTION
C
          IF (CLI$PRESENT('ABOUT')) THEN
            WRITE (*,*) ' '
            WRITE (*,*) '             LIST 2.4-A1'
            WRITE (*,*) ' '
            WRITE (*,*) '  LIST was conceived and written by'
            WRITE (*,*) '  Jonathan C. Baker using the FORTRAN'
            WRITE (*,*) '  programming language.  All questions,'
            WRITE (*,*) '  problems or suggestions can be addressed'
            WRITE (*,*) '  to Jon at his address, phone or internet'
            WRITE (*,*) '  address:'
            WRITE (*,*) '      Naval Surface Warfare Center'
            WRITE (*,*) '      17320 Dahlgren Rd.   Code N83'
            WRITE (*,*) '      Dahlgren, VA 22448-5150'
            WRITE (*,*) '      540-653-8705'
            WRITE (*,*) '      jbaker@nswc.navy.mil'
            WRITE (*,*) ' '
            CALL EXIT
          ELSEIF (CLI$PRESENT('ADD')) THEN
            CALL ADD
          ELSEIF (CLI$PRESENT('CHECK')) THEN
            CALL CHECK
          ELSEIF ((CLI$PRESENT('COMPRESS')) .OR. 
     1            (CLI$PRESENT('CLEANUP'))  .OR.
     2            (CLI$PRESENT('CROSS_CHECK'))) THEN
            IF (CLI$PRESENT ('CLEANUP')) THEN
              CALL CLEAN_UP
            ENDIF
            IF (CLI$PRESENT('CROSS_CHECK')) THEN
              CALL CROSS_CHECK 
            ENDIF
            IF (CLI$PRESENT ('COMPRESS')) THEN
              CALL FILE_COMP
            ENDIF
          ELSEIF (CLI$PRESENT('DELETE')) THEN
            CALL DELETE
          ELSEIF (CLI$PRESENT('MODIFY')) THEN
            CALL MODIFY
          ELSEIF (CLI$PRESENT('RENAME')) THEN
            CALL RENAME
          ELSE
C
C         INITIALIZE VARIABLES
C
            SELECT = 0
            TRANSLOG(1).ITEM_CODE   = LNM$_STRING
            TRANSLOG(1).BUFLEN      = 255
            TRANSLOG(1).BUFADR      = %LOC(LOGPLAN)
            TRANSLOG(1).RETLEN      = %LOC(LOGLEN)
            TRANSLOG(2).END_LIST    = 0
            STATUS = SYS$TRNLNM (,'LNM$SYSTEM_TABLE',
     1                           'LIST$PLAN_LENGTH',,
     2                            TRANSLOG)
            IF (STATUS) THEN
              LOGPLANX = LOGPLAN(1:LOGLEN)
              READ (LOGPLANX,151,ERR=9111) PLAN$LENGTH
              IF (LOGLEN .EQ. 1) THEN
                PLAN$LENGTH = PLAN$LENGTH / 10
              ENDIF
              IF (.FALSE.) THEN
 9111           PLAN$LENGTH = 4
              ENDIF
            ELSE
              PLAN$LENGTH = 4
            ENDIF
C
C         DETERMINE OUTPUT
C
            OUTPUT = CLI$PRESENT('OUTPUT')
            IF(OUTPUT)THEN
              STATUS = CLI$GET_VALUE('OUTPUT',OUT,LEN)
              CALL STR$UPCASE (OUT, OUT)
              UNT = 20
              OPEN(UNIT=UNT,
     1             FILE=OUT,
     2             STATUS='NEW',
     3             ORGANIZATION='SEQUENTIAL',
     4             FORM='FORMATTED',
     5             CARRIAGECONTROL='LIST',
     6             RECL=80,
     7             IOSTAT=IOST,
     8             ERR=2345)
              IF(.FALSE.)THEN
 2345           WRITE (6,*) ' %LIST-W-OPENERROR, Error opening ',
     1                      OUT
                WRITE (6,*) ' *** IOSTAT =',IOST,
     1                      '    Opening  FOR020.DAT'
              ENDIF
            ELSE
              UNT = 6
            ENDIF
C
C         DETERMINE TYPE OF LISTING
C
            IF (CLI$PRESENT('GROUP')) THEN
C
C         LIST BY GROUP
C
              CALL GROUP_LIST (UNT, SELECT)
            ELSE
C
C         GET NAME, USERNAME SEARCH KEY
C
              STATUS = CLI$GET_VALUE('P1',LOOKFOR)
              DOWHILE (LENGTH (LOOKFOR) .EQ. 0)
                WRITE (6,120)
                READ (6,210) LOOKFOR
              ENDDO
              CALL STR$UPCASE (LOOKFOR , LOOKFOR)
C
C         CHECKING WHAT TO SEARCH ON (USERNAME OR LAST NAME)
C
              IF(LOOKFOR(1:1) .EQ. '\')THEN                        
C
C           LIST BY LAST NAME
C
                CALL NAME_LIST (UNT, SELECT, LOOKFOR(2:))
              ELSE
C
C           LIST BY USER
C
                CALL USER_LIST (UNT, SELECT, LOOKFOR)
              ENDIF
            ENDIF
C
 1000       CALL CLOSE_INPUT
C
C           WRITE OUT FINDINGS TO TERMINAL
C
            IF(SELECT .NE. 0)THEN
              WRITE (6,*) ' '
              WRITE (6,115) ' [', SELECT,
     1                         'USER(S) SELECTED FROM LIST KEY. ]'
              WRITE (6,*) ' '
            ENDIF
C
            IF(OUTPUT)THEN
              WRITE (20,*) ' '
              CLOSE(20)
            ENDIF
          ENDIF
C
C         STOP
          END
C
C         END OF MAIN PROGRAM
C
C***************************************************************************
C
          SUBROUTINE ADD
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           17 AUG 1990
C           18 MAY 1993    JON BAKER
C                          ADD IN EMPLOYER AND DATE FIELDS
C         PURPOSE
C           TO ADD A USER TO PHONE LIST
C         DESCRIPTION
C           ENTER A NEW RECORD INTO THE INDEXED FILE
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             AUTHINFO
C             CLOSE_INPUT
C             LENGTH
C             NUMBER
C             OPEN_INPUT
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           EMPLOYER   : WHERE USER WORKS
C           EXIST      : A USERNAME EXISTS IN PHONE.LIST
C           GROUP      : USER'S GROUP
C           NAME       : FULL NAME
C           NUMBER     : PHONE NUMBER
C           OK         : LOGICAL CONTROL VARIABLE
C           OKNUM      : OK NUMBER
C           PRIVS      : USER HAS PRIVELEGE
C           STAUS      : RETURN VARIABLE
C           THE_DATE   : DATE ADDED
C           UIC        : USER CODE
C           ULEN       : USERNAME LENGTH
C           USRNAME    : UTILITY USER'S USERNAME
C           USERNAME   : USERNAME
C           USERREAD   : USERNAME READ FROM INDEX FILE
C
C         FORMATS
C
  100     FORMAT($,X,'_Enter user to add:  ')
  101     FORMAT(X,'_Enter user''s full name - ( LAST,   FIRST   ',
     1           'MIDDLE   [nick-name] )',/,$,X,
     2           '[<CR> -  blank]:  ')
  102     FORMAT(X,'_Enter user''s phone number with format - ',
     1           '(123)456-7890',/,$,X,'[<CR> - blank]:  ')
  103     FORMAT(X,'%LIST-I-NOCOMMA, Separate last name with comma.')
  105     FORMAT(X,'%LIST-I-USRADD, User successfully added')
  110     FORMAT(X,'%LIST-E-USREXISTS, User already exists  ',A)
  120     FORMAT(X,'%LIST-E-NOPRIV, Sorry BUB, No privilege ',
     1           'for attempted operation, cannot add.')
  130     FORMAT(X,'_Enter user''s employer, etc.',/,$,X,
     1           '[<CR> - blank]:  ')
  200     FORMAT(A12)
  201     FORMAT(A50)
  202     FORMAT(A22)
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C         DECLARE VARIABLES
C
          INTEGER*4       LENGTH, STATUS, CLI$GET_VALUE, ULEN
          CHARACTER*11    THE_DATE
          CHARACTER*12    USERNAME, USRNAME, USERREAD
          CHARACTER*15    GROUP
          CHARACTER*22    NUMBER
          CHARACTER*30    EMPLOYER, UIC
          CHARACTER*50    NAME
          LOGICAL         SYSPRIV, PRIVS, OK, NUMBER_CHECK, OKNUM,
     1                    EXIST, CLI$PRESENT
C
C         GET PRIVILEGE STATUS OF USER AND USERNAME 
C
          PRIVS = SYSPRIV (USRNAME)
          STATUS = CLI$GET_VALUE ('P1', USERNAME)
          IF ((PRIVS) .AND. (.NOT. CLI$PRESENT('CHECK'))) THEN
C
C         GET USERNAME TO ADD
C
            DOWHILE(LENGTH(USERNAME) .EQ. 0)
              WRITE(6,100)
              READ(6,200) USERNAME
            ENDDO
            CALL STR$UPCASE (USERNAME, USERNAME)
          ELSE
C
C         NO PRIVED USER, CHECK TO MAKE SURE NOT ATTEMPTING TO ADD
C         SOMEONE OTHER THAN THEMSELVES
C
            IF (LENGTH (USERNAME) .NE. 0) THEN
              IF (CLI$PRESENT('BORING'))THEN
                WRITE (6,600)
              ELSE
                WRITE (6,120)
              ENDIF
              CALL EXIT
            ELSE
              USERNAME = USRNAME
            ENDIF
          ENDIF
C
C         SEE IF USER ALREADY EXISTS
C
          EXIST = .TRUE.
          CALL OPEN_INPUT (.TRUE.)
          ULEN = LENGTH (USERNAME)
          READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1          USERREAD
          CALL CLOSE_INPUT

          IF (USERNAME .NE. USERREAD) THEN
            EXIST = .FALSE.
          ELSE
            WRITE (6,110) USERNAME
          ENDIF
C
C         USER DOES NOT EXIST
C
          IF (.NOT.  EXIST) THEN
C
C         GET GROUP OF USER
C
 9100       CALL AUTHINFO (USERNAME, GROUP, UIC)
C
C         GET NAME OF USER
C
            CALL CLOSE_INPUT
            STATUS = CLI$GET_VALUE ('P2', NAME)
            DOWHILE (((INDEX (NAME, ',') .EQ. 0) .OR.
     1                (INDEX (NAME, ',') .EQ. 1)) .AND.
     2               (NAME(1:1) .NE. '*'))
              WRITE(6,101)
              READ(6,201) NAME
              IF (NAME(1:1) .EQ. ' ') THEN
                NAME(1:1) = '*'
              ELSE IF ((INDEX (NAME, ',') .EQ. 0) .OR.
     1                 (INDEX (NAME, ',') .EQ. 1)) THEN
                WRITE (6,*) ' '
                WRITE (6,103)
                WRITE (6,*) ' '
              ENDIF
            ENDDO
            CALL STR$UPCASE (NAME, NAME)
            CALL COMPRESS (NAME)
C
C         GET PHONE NUMBER OF USER
C
            STATUS = CLI$GET_VALUE ('P3', NUMBER)
            CALL COMPRESS (NUMBER)
            OKNUM = NUMBER_CHECK (NUMBER)
            IF (.NOT. (OKNUM)) THEN
              OK = .FALSE.
              DOWHILE (.NOT. (OK))
                WRITE(6,102)
                READ(6,202) NUMBER
                IF (LENGTH (NUMBER) .EQ. 0) THEN
                  NUMBER(1:1) = '*'
                  OK = .TRUE.
                ELSE
                  CALL COMPRESS (NUMBER)
                  OKNUM = NUMBER_CHECK (NUMBER)
                  IF (OKNUM) THEN
                    OK = .TRUE.
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
C
C         GET EMPLOYER OR SUCH
C
            EMPLOYER = ' '
            STATUS = CLI$GET_VALUE ('P4', EMPLOYER)
            WRITE(6,130)
            READ(6,201) EMPLOYER
            CALL STR$UPCASE (EMPLOYER, EMPLOYER)
            CALL COMPRESS (EMPLOYER)
C
C         GET DATE ADDED
C
            CALL LIB$DATE_TIME (THE_DATE)
C
C         CLEAR STRINGS IF NO INFORMATION TO ADD TO LISTING
C
            IF (NAME(1:1) .EQ. '*') THEN
              DO 1000 I = 1, LEN(NAME)
                NAME(I:I) = ' '
 1000         CONTINUE
            ELSE
              CALL STR$UPCASE (NAME, NAME)
              CALL COMPRESS (NAME)
            ENDIF

            IF (NUMBER(1:1) .EQ. '*') THEN
              DO 1010 I = 1, LEN(NUMBER)
                NUMBER(I:I) = ' '
 1010         CONTINUE
            ELSE
              DO 1011 I = 14, LEN(NUMBER)
                NUMBER(I:I) = ' '
 1011         CONTINUE
            ENDIF
C
C         OUTPUT THE INFORMATION TO PHONE.BOOK
C
            CALL OPEN_INPUT (.FALSE.)
            WRITE (10,210) USERNAME, NAME, GROUP, NUMBER, THE_DATE,
     1                     EMPLOYER, UIC
            CALL CLOSE_INPUT
            WRITE (6,105)
          ENDIF
C
 9090     RETURN
          END
C
C         END OF ADD
C
C***************************************************************************
C
          SUBROUTINE AUTHINFO (USER, GROUP, UIC)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           21 JAN 1991
C         PURPOSE
C           GET USER'S GROUP
C         DESCRIPTION
C           USER GETUAI TO PULL INFO FROM SYSUAF.DAT
C         COMMUNICATIONS
C           CALLS FROM
C             ADD
C             MODIFY
C             RENAME
C           CALLS TO
C             LENGTH
C
C         PARAMETERS
C           GROUP     : GROUP OF USER
C           UIC       : USER CODE
C           USER      : USER TO EXTRACT GROUP INFO
C         LOCAL GLOSSARY
C           STATUS    : RETURN VARIABLE
C           UIC_NUM   : UIC BIT CODE
C           UIC1      : FIRST PART OF ASCII UIC
C           UIC2      : SECOND PART OF ASCII UIC
C           USERGROUP : GROUP RETURNED FROM SYSUAF           
C
C
C         FORMATS
C
  100     FORMAT(X,'%LIST-I-FAKEUSR, User is not found in SYSUAF, ',
     1           'group field set to "***********".')
  101     FORMAT(X,'%LIST-I-FAKEUSR, User is not found in SYSUAF, ',
     1           'UIC set to "***********".')
C
C         INCLUDES
C
          INCLUDE        '($UAIDEF)'
          INCLUDE        '($UICDEF)'
C
C         DECLARE STRUCTURES AND RECORDS
C
          STRUCTURE      /ITMLST/
            UNION
              MAP
                INTEGER*2  BUFLEN
                INTEGER*2  ITMCOD
                INTEGER*4  BUFADR
                INTEGER*4  RETADR
              END MAP
              MAP
                INTEGER*4  END_LIST
              END MAP
            END UNION
          END STRUCTURE
C
          RECORD  / ITMLST /  GETUAI_LIST(3)
C
C         DECLARE VARIABLES
C
          INTEGER*4      SYS$IDTOASC, SYS$GETUAI, STATUS, UIC_NUM,
     1                   LENGTH
          CHARACTER*(*)  USER
          CHARACTER*(*)  UIC
          CHARACTER*(*)  GROUP
          CHARACTER*15   UIC1, UIC2
          CHARACTER*32   USERGROUP
          LOGICAL        CLI$PRESENT
C
C         INTIALIZE ITMLST
C         
          IF (CLI$PRESENT ('ACCOUNT_FIELD')) THEN
            GETUAI_LIST(1).BUFLEN = 32
            GETUAI_LIST(1).ITMCOD = UAI$_ACCOUNT
            GETUAI_LIST(1).BUFADR = %LOC(USERGROUP)
            GETUAI_LIST(1).RETADR = %LOC(GROUP_LEN)
          ELSE
            GETUAI_LIST(1).BUFLEN = 32
            GETUAI_LIST(1).ITMCOD = UAI$_OWNER
            GETUAI_LIST(1).BUFADR = %LOC(USERGROUP)
            GETUAI_LIST(1).RETADR = %LOC(GROUP_LEN)
          ENDIF
          GETUAI_LIST(2).BUFLEN = 4
          GETUAI_LIST(2).ITMCOD = UAI$_UIC
          GETUAI_LIST(2).BUFADR = %LOC(UIC_NUM)
          GETUAI_LIST(2).RETADR = %LOC(GROUP_LEN)
          GETUAI_LIST(3).END_LIST = 0
C
C        CLEAR CHARACTER ARRAYS
C
          DO 1010 I = 1, 32
            USERGROUP(I:I) = ' '
 1010     CONTINUE
C
C         GET THE USER INFORMATION FROM THE UAF FILES
C
          UIC1 = ' '
          UIC2 = ' '
          STATUS = SYS$GETUAI(,,USER,GETUAI_LIST,,,)
          STATUS = SYS$IDTOASC (%VAL(UIC_NUM),,UIC2,,,)
          UIC_NUM = IOR (UIC_NUM,'0000FFFF'X)
          STATUS = SYS$IDTOASC (%VAL(UIC_NUM),,UIC1,,,)
C
C         CHECK ON ASCII UIC AND SET UP
C
          IF ((LENGTH (UIC1) .EQ. 0) .AND. 
     1        (LENGTH (UIC2) .EQ. 0)) THEN
            DO 1021 I = 1, LEN(UIC)
              UIC(I:I) = '*'
 1021       CONTINUE
            IF (.NOT. CLI$PRESENT ('CLEANUP')) THEN
              WRITE (6,101)
            ENDIF
          ELSE IF (LENGTH (UIC1) .EQ. 0) THEN
            I = LENGTH (UIC2)
            UIC = '[' // UIC2(1:I) // ']'
          ELSE IF (LENGTH (UIC2) .EQ. 0) THEN
            I = LENGTH (UIC1)
            UIC = '[' // UIC1(1:I) // ']'
          ELSE
            I = LENGTH (UIC1)
            J = LENGTH (UIC2)
            UIC = '[' // UIC1(1:I) // ',' // UIC2(1:J) // ']'
          ENDIF
C
C         CHECK ON USERGROUP
C
          IF (USERGROUP(1:1) .EQ. ' ') THEN
            DO 1020 I = 1, LEN(USERGROUP)
              USERGROUP(I:I) = '*'
 1020       CONTINUE
            IF (.NOT. CLI$PRESENT ('CLEANUP')) THEN
              WRITE (6,100)
            ENDIF
          ENDIF
C
          IF (CLI$PRESENT ('ACCOUNT_FIELD')) THEN
            GROUP = USERGROUP(1:)
          ELSE
            GROUP = USERGROUP(2:)
          ENDIF
C
          RETURN
          END
C
C         END OF AUTHINFO
C
C***************************************************************************
C
          SUBROUTINE CHECK
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           19 MAY 1993         
C         PURPOSE
C           TO SEE IF USER RECORD NEEDS MODIFICATION
C         DESCRIPTION
C           PULL ENTRY AND CHECK DATE.  IF NEEDS MODIFICATION,
C           CALL MODIFY ROUTINE.  ADD IF NON-EXISTENT
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             ADD
C             AUTHINFO
C             COMPRESS
C             LENGTH
C             MODIFY
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           ALPHA_DIFF: VALUE READ AS PARAMETER FOR DIFF
C           ANS       : ANSWER
C           CUR_DATE  : CURRENT DATE
C           DAY1      : NUMERICAL DAY OF LAST MOD
C           DAY2      : NUMERICAL DAY OF CURRENT DAY
C           DIFF      : COMPARISON VALUE PARAMETER
C           DISABLED  : ACCOUNT HAS BEEN DISABLED
C           EMPLOYER  : EMPLOYER
C           GROUP     : GROUP IN LIST
C           I         : CONTROL VARIABLE
C           LASTUP    : CONVERSION VERIABLE
C           MGROUP    : MODIFIED GROUP
C           MUIC      : MODIFIED USER CODE
C           NAME      : NAME IN LIST
C           NUMBER    : PHONE NUMBER IN LIST
C           PRIVS     : USER HAS PRIVS??
C           STATUS    : RETURN VARIABLE
C           TEMP      : TEMPORARY VARIABLE
C           THE_DATE  : DATE MODIFIED
C           UIC       : USE CODE
C           ULEN      : LENGTH OF USERNAME
C           USERREAD  : USERNAME READ FROM LIST
C           USERNAME  : USERNAME TO MODIFY
C
C
C         INCLUDES
C
          INCLUDE '($JPIDEF)'
C
C         FORMATS
C
  100     FORMAT(5X,'Username:        ',A,T55,'(non-modifiable)')
  101     FORMAT(5X,'Name:            ',A)
  102     FORMAT(5X,'Group:           ',A,T55,'(auto-modified)')
  103     FORMAT(5X,'Employer (etc):  ',A)
  104     FORMAT(5X,'Phone number:    ',A)
  105     FORMAT(10X,'Date last modified/checked:  ',A)
  106     FORMAT(5X,'UIC:             ',A,T55,'(auto-modified)')
  107     FORMAT(5X,'Disabled:        ',A,T55,'(non-modifiable)')
  109     FORMAT(T23,A)
  110     FORMAT(X,'%LIST-E-NOSUCHUSR, No such user  ',A)
  111     FORMAT(X,'-LIST-I-ADDUSER, Adding user to list.')
  150     FORMAT($,10X,'Would you like to update this record (Y/N): ')
  151     FORMAT(A)
  205     FORMAT(X,'%LIST-I-NOMODS, No modifications made.')
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  300     FORMAT(X,'%LIST-F-INVCHECKVAL, Invalid input for /CHECK')
  301     FORMAT(I5)
C
C         DECLARE VARIABLES
C
          INTEGER*4       CLI$GET_VALUE, STATUS, ULEN, LENGTH, DIFF,
     1                    DAY1, DAY2, LASTUP(2), I, LIB$GETJPI
          CHARACTER*1     ANS
          CHARACTER*5     ALPHA_DIFF
          CHARACTER*11    THE_DATE, CUR_DATE, DISABLED
          CHARACTER*12    USERNAME, USERREAD
          CHARACTER*14    NUMBER
          CHARACTER*15    GROUP, MGROUP
          CHARACTER*23    TEMP
          CHARACTER*30    EMPLOYER, NAME, UIC, MUIC
          LOGICAL         SYSPRIV, PRIVS, CLI$PRESENT, DISABLE_CHECK
C
C         DETERMINE USERNAME
C
          PRIVS = SYSPRIV (USERNAME)
          CALL STR$UPCASE (USERNAME, USERNAME)
C
C         CHECK TO SEE IF USER EXISTS
C
          CALL OPEN_INPUT (.TRUE.)
          ULEN = LENGTH (USERNAME)
          READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1          USERREAD, NAME, MGROUP, NUMBER, THE_DATE, 
     2          EMPLOYER, MUIC
          CALL CLOSE_INPUT
          IF (USERREAD .EQ. USERNAME) THEN
C
C         GET NUMBER OF DAYS TO MAKE DIFFERENCE
C
            STATUS = CLI$GET_VALUE ('CHECK', ALPHA_DIFF)
            I = LENGTH (ALPHA_DIFF)
            READ (ALPHA_DIFF(1:I),301,ERR=9004) DIFF
            IF (LENGTH (THE_DATE) .EQ. 0) THEN
              DIFF = 0
            ENDIF
            CALL LIB$DATE_TIME (CUR_DATE)
C
C         GET GROUP INFO 
C
            CALL AUTHINFO (USERNAME, GROUP, UIC)
            IF (DISABLE_CHECK (USERNAME)) THEN
              DISABLED = 'Yes'
            ELSE
              DISABLED = 'No'
            ENDIF
C
C         CHECK DATE DELAY AND DISPLAY INFORMATION IF WARRANTED
C
            IF (LENGTH (THE_DATE) .EQ. 0) THEN
              CALL LIB$DAY (DAY1)
            ELSE
              TEMP = THE_DATE // ' 12:00:00.00'
              CALL SYS$BINTIM (TEMP,LASTUP)
              CALL LIB$DAY (DAY1,LASTUP)
            ENDIF

            CALL LIB$DAY (DAY2)
            IF (LENGTH (NAME) .EQ. 0) THEN
              NAME = CHAR(27) // '[7m(none)' // CHAR(27) // '[m'
            ENDIF
            IF (LENGTH (NUMBER) .EQ. 0) THEN
              NUMBER = CHAR(27) // '[7m(none)' // CHAR(27) // '[m'
            ENDIF
            IF (LENGTH (EMPLOYER) .EQ. 0) THEN
              EMPLOYER = CHAR(27) // '[7m(none)' // CHAR(27) // '[m'
            ENDIF
            ANS = 'X'

            IF ((DAY2 - DAY1) .GE. DIFF) THEN
              DOWHILE ((ANS .NE. 'Y') .AND. (ANS .NE. 'N'))
                WRITE (6,*) (CHAR(27) // '[0;0H' // CHAR(27) // '[J')
                WRITE (6,109) 'LIST Database Information Check'
                WRITE (6,109) '-------------------------------'
                WRITE (6,*) (CHAR(27) // '[5;0H')
                WRITE (6,100) USERNAME
                WRITE (6,101) NAME
                WRITE (6,102) GROUP
                WRITE (6,106) UIC
                WRITE (6,103) EMPLOYER
                WRITE (6,104) NUMBER
                WRITE (6,107) DISABLED
                WRITE (6,*) ' '
                IF (LENGTH (THE_DATE) .EQ. 0) THEN
                  WRITE (6,105) '(never)'
                ELSE
                  WRITE (6,105) THE_DATE
                ENDIF
                WRITE (6,*) ' '
                WRITE (6,150)
                READ (6,151) ANS
                CALL STR$UPCASE (ANS, ANS)
                WRITE (6,*) ' '
              ENDDO
C
C         TAKE INDICATED ACTION
C
              IF (ANS .EQ. 'Y') THEN
                CALL MODIFY
              ELSE
                CALL OPEN_INPUT (.FALSE.)
                ULEN = LENGTH (USERNAME)
                READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1                USERREAD, NAME, MGROUP, NUMBER, THE_DATE, 
     2                EMPLOYER, MUIC
                REWRITE (10,210) USERNAME, NAME, GROUP, NUMBER,
     1                           CUR_DATE, EMPLOYER, UIC
                CALL CLOSE_INPUT
              ENDIF
            ENDIF

          ELSE
C
C         UNKNOWN USER
C
 9100       WRITE (6,110) USERNAME
            WRITE (6,111)
            WRITE (6,*) ' '
            CALL CLOSE_INPUT
            CALL ADD
          ENDIF
C
C         ERROR BLOCK
C
          IF (.FALSE.) THEN
 9004       WRITE (6,300)
          ENDIF
C
          RETURN
          END
C
C         END OF CHECK
C
C*****************************************************************************
C
          SUBROUTINE CLEAN_PLAN (STR)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           29 JULY 1994
C         PURPOSE
C           SUPPRESS DISPLAY OF CONTROL CHARACTERS
C         DESCRIPTION
C           REPLACE ALL CONTROL CHARACTERS WITH NULL CHARACTERS.  LEAVE
C           HORIZONTAL TABS IN PLACE.
C         COMMUNICATIONS
C           CALLS FROM
C             DISPLAY_PLAN
C           CALLS TO
C             LENGTH
C
C         PARAMETERS
C           STR        : STRING TO CLEAN
C         LOCAL GLOSSARY
C           BLANK      : BLANK CHARACTER
C           I          : CONTROL VARIABLE
C           J          : CONTROL VARIABLE
C           NULL       : NULL CHARACTER
C           TAB        : HORIZONTAL TAB CHARACTER
C
C         DECLARE VARIABLES
C
          CHARACTER*(*)  STR
          INTEGER*4      I, J, LENGTH
          CHARACTER*1    NULL, TAB, BLANK
C
C         SETUP VARIABLES (ASCII REP)
C
          J = LENGTH (STR)
          NULL = CHAR (0)
          TAB  = CHAR (9)
          BLANK = CHAR (32)
C
C         PERFORM CLEAN
C
          DO 1000 I = 1,J
            IF ((STR(I:I) .LT. BLANK) .AND.
     1          (STR(I:I) .NE. NULL)  .AND.
     2          (STR(I:I) .NE. TAB))  THEN
              STR(I:I) = NULL
            ENDIF
 1000     CONTINUE     
C
          RETURN
          END
C
C         END OF CLEAN_PLAN
C
C*****************************************************************************
C
          SUBROUTINE CLEAN_UP
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           21 MAY 1993
C           11 SEP 1995   JON BAKER
C                         MODIFY STALE GROUPS FOR USERS AND THEIR UIC'S
C         PURPOSE
C           TO DELETE RECORDS THAT HAVE NO RECORD IN THE SYSUAF.DAT 
C         DESCRIPTION
C           READ AND CHECK EACH RECORD
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             CLOSE_INPUT
C             OPEN_INPUT
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           DATE        : DATE OF MODIFICATION (NOT MODIFIED HERE IN
C                                               CASE OF NUMBER CHANGE)
C           EMPLOYER    : USER EMPLOYER
C           GROUP       : GROUP OF USERNAME
C           I           : CONTROL VARIABLE
C           IOST        : STATUS VARIABLE
C           J           : CONTROL VARIABLE
C           NAME        : USER'S NAME
C           OLD_GROUP   : GROUP IN PHONE BOOK
C           OLD_UIC     : UIC IN PHONE BOOK
C           PHONE       : USER'S PHONE NUMBER
C           PHONEFILE   : FILE TO CLEANUP
C           UIC         : USER CODE
C           UPDATE      : GROUP/UIC SWITCH VARIABLE
C           USER        : PARAMETER PASSED FROM SYSPRIV (NOT USED)
C           USERNAME    : USERNAME READ FROM LISTING FILE
C
C
C         FORMATS
C
  100     FORMAT (X,'%LIST-F-NOPRIV, Don''t even try it buddy!')
  110     FORMAT (X,'%LIST-F-UKNLIST, Can''t find that file.')
  120     FORMAT (X,'%LIST-S-UNABLE, File may be locked.')
  200     FORMAT (X,'%LIST-I-USRDEL, User ',A,' is now a gonner.')
  201     FORMAT (X,'%LIST-I-TOTDEL, ',I4,' total users deleted.')
  205     FORMAT (X,'%LIST-I-MODGROUP, Modified ',A,' to group ',A)
  206     FORMAT (X,'%LIST-I-MODUIC, Modified ',A,' to uic ',A)
  210     FORMAT (X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C         DECLARE VARIABLES
C
          INTEGER*4      IOST, I, J
          CHARACTER*11   DATE
          CHARACTER*12   USER, USERNAME
          CHARACTER*13   PHONE
          CHARACTER*15   GROUP, OLD_GROUP
          CHARACTER*30   UIC, NAME, EMPLOYER, OLD_UIC
          CHARACTER*100  PHONEFILE
          LOGICAL        SYSPRIV, CLI$PRESENT, UPDATE
C
C         COMMON BLOCK
C
          COMMON /LIST_FILE/ PHONEFILE
C
C         INITIALIZE VARIABLES
C
          J = 0
C
C         CHECK FOR PRIVS
C
          IF (.NOT. SYSPRIV(USER)) THEN
            IF (CLI$PRESENT('BORING')) THEN
              WRITE (6,600)
            ELSE
              WRITE (6,100)
            ENDIF
            CALL EXIT
          ENDIF
C
C         CHECK FOR FILE EXISTENCE
C
          STATUS = CLI$GET_VALUE ('LISTING', PHONEFILE)
          OPEN(UNIT=10,
     1         FILE=PHONEFILE,
     2         STATUS='OLD',
     3         ORGANIZATION='INDEXED',
     4         FORM='FORMATTED',
     5         RECL=255,
     6         ACCESS='KEYED',
     7         KEY=(2:13:CHARACTER,17:46:CHARACTER,
     8              50:64:CHARACTER),
     9         IOSTAT=IOST,
     A         ERR=1234)
          IF (.FALSE.) THEN
 1234       IF (IOST .EQ. 29) THEN
              WRITE (6,110)
            ELSE
              WRITE (6,120)
            ENDIF
            CALL EXIT
          ENDIF
C
C         CLEANUP FILE
C
          DOWHILE (.TRUE.)
            READ (10,210,END=9000) USERNAME, NAME, OLD_GROUP, PHONE,
     1                             DATE, EMPLOYER, OLD_UIC
C
C         GET GROUP AND UIC INFO
C
            UPDATE = .FALSE.
            CALL AUTHINFO (USERNAME, GROUP, UIC)
            I = LENGTH (USERNAME)
            IF (GROUP(1:5) .EQ. '*****') THEN
              DELETE (10)
              J = J + 1
              WRITE (6,200) USERNAME(1:I)
            ELSE IF (GROUP .NE. OLD_GROUP) THEN
              UPDATE = .TRUE.
              WRITE (6,205) USERNAME(1:I), GROUP
            ELSE IF (UIC .NE. OLD_UIC) THEN
              UPDATE = .TRUE.
              WRITE (6,206) USERNAME(1:I), UIC
            ENDIF

            IF (UPDATE) THEN
              REWRITE (10,210) USERNAME, NAME, GROUP, PHONE, DATE,
     1                         EMPLOYER, UIC
            ENDIF
          ENDDO
C
 9000     CLOSE (10)
          WRITE (6,*) ' '
          WRITE (6,201) J
          WRITE (6,*) ' '
C
          RETURN
          END
C
C         END OF CLEAN_UP
C
C****************************************************************************
C
          SUBROUTINE  CLOSE_INPUT
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           14 AUG 1990
C         PURPOSE
C           TO CLOSE INPUT
C         DESCRIPTION
C           CLOSE INPUT FILE
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             (NONE)
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           (NONE)
C
          CLOSE (10)
C
          RETURN
          END
C
C         END OF CLOSE_INPUT
C
C****************************************************************************
C
          SUBROUTINE COMPRESS (STR)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           11 JAN 1991
C         PURPOSE
C           COLLAPSE A STRING
C         DESCRIPTION
C           TAKE OUT DOUBLE OCCURANCES OF SPACES, TAKE OUT TABS, TAKE OUT
C           LEADING BLANKS AND SPACES AND ASSURE THAT THERE IS A SPACE AFTER
C           A COMMA
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             LENGTH
C
C         PARAMETERS
C           STR     : STRING TO COLLAPSE
C         LOCAL GLOSSARY
C           BLANK   : A BLANK CHARACTER
C           I       : CONTROL VARIABLE
C           J       : CONTROL VARIABLE
C           SKIP    : SHOULD NEXT BLANK/TAB BE SKIPPED??
C           STR_LEN : LENGTH OF STR
C           TAB     : A TAB CHARACTER
C           TEMP    : TEMPORARY STORAGE VARIABLE
C           
C         DECLARE VARIABLES
C
          INTEGER        STR_LEN, I ,LENGTH, J
          CHARACTER*(*)  STR
          CHARACTER*1    BLANK, TAB
          CHARACTER*255  TEMP
          LOGICAL        SKIP
C
C         INITIALIZE VARIABLES (ASCII REP)
C
          BLANK = CHAR(32)
          TAB = CHAR(9)
          STR_LEN = LENGTH (STR)

          DO 1000 I = 1,255
            TEMP(I:I) = BLANK
 1000     CONTINUE

          SKIP = .FALSE.
          J = 1
C
C         SKIP OVER LEADING BLANKS AND TABS
C
          I = 1
          DOWHILE ((I .LE. STR_LEN) .AND.
     1             ((STR(I:I) .EQ. BLANK) .OR.
     2              (STR(I:I) .EQ. TAB)))
            I = I + 1
          ENDDO
C
C         COMPRESS
C
          DOWHILE (I .LE. STR_LEN)
C
C         SKIP OVER NECESSARY BLANKS AND TABS
C
            IF ((STR(I:I) .EQ. BLANK) .OR.
     1          (STR(I:I) .EQ. TAB)) THEN
              IF (.NOT. (SKIP)) THEN
                SKIP = .TRUE.
                TEMP(J:J) = BLANK
                J = J + 1
              ENDIF
            ELSE
C
C         PUT CHARACTER INTO TEMP STRING
C
              SKIP = .FALSE.
              TEMP(J:J) = STR(I:I)
              J = J + 1
              IF (STR(I:I) .EQ. ',') THEN
                TEMP(J:J) = BLANK
                J = J + 1
                SKIP = .TRUE.
              ENDIF
            ENDIF
            I = I + 1
          ENDDO
C
C         REPLACE COMPRESSED STRING INTO STR
C
          DO 1050 I = 1,LEN(STR)
            STR(I:I) = TEMP(I:I)
 1050     CONTINUE
C
          RETURN
          END
C
C         END OF COMPRESS
C
C***************************************************************************
C
          SUBROUTINE CROSS_CHECK
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           4 JUNE 1997
C         PURPOSE
C           SEE WHICH USER ACCOUNTS IN SYSUAF ARE NOT IN LIST DATABASE
C         DESCRIPTION
C           READ EACH RECORD FROM SYSUAF AND CHECK FOR DUPLICATE IN LIST
C           DATABASE
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             IGNORE
C             LENGTH
C             OPEN_INPUT 
C             OPEN_SYSUAF
C             SYSPRIV
C
C         PARAMETERS
C           NONE
C         LOCAL GLOSSARY
C           I          : CONTROL VARIABLE
C           IGNORE_FILE: FILE CONTAINING ACCOUNTS TO IGNORE
C           IGNORE_TEST: RETURN FROM CALL TO IGNORE ROUTINE
C           LEN        : LENGTH RETURN VARIABLE
C           STATUS     : RETURN VARIABLE
C           SYS_UNT    : SYSUAF UNIT
C           TEST       : TEST VARIABLE FOR EXISTENCE
C           UNT        : OUTPUT UNIT
C           USE_IGNORE : USE IGNORE FILE
C           USER       : RESULT FROM LIST SEARCH
C           USERNAME   : NAME TO SEARCH FOR
C
C
C         FORMATS
C
  100     FORMAT(4X,A12)
  210     FORMAT(X,A12)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
  610     FORMAT (X,'%LIST-F-NOPRIV, Don''t even try it buddy!')
C
C
C         DECLARE VARIABLES
C
          INTEGER*4       SYS_UNT, STATUS, CLI$GET_VALUE, LEN, 
     1                    IOST, I, UNT, IGN_UNT
          CHARACTER*12    USERNAME, USER
          CHARACTER*255   OUTFILE, IGNORE_FILE
          LOGICAL         CLI$PRESENT, USE_IGNORE, IGNORE, 
     1                    IGNORE_TEST, SYSPRIV
C
C         CHECK FOR PRIVILEGES
C
          IF (.NOT. SYSPRIV(USER)) THEN
            IF (CLI$PRESENT('BORING')) THEN
              WRITE (6,600)
            ELSE
              WRITE (6,610)
            ENDIF
            CALL EXIT
          ENDIF
C
C         OPEN OUTPUT FILE IF NEEDED
C
          STATUS = CLI$GET_VALUE ('CROSS_CHECK', OUTFILE, LEN)
          IF (LEN .GT. 0) THEN
            UNT = 42
            OPEN(UNIT=UNT,
     1           FILE=OUTFILE(1:LEN),
     2           STATUS='NEW',
     3           IOSTAT=IOST,
     4           ERR=9011)
          ELSE
            UNT = 6
          ENDIF
C
C         CHECK IGNORE STATUS
C
          IF (CLI$PRESENT('IGNORE')) THEN
            STATUS = CLI$GET_VALUE('IGNORE', IGNORE_FILE, LEN)
            IGN_UNT = 31
            OPEN (UNIT=IGN_UNT,
     1            FILE=IGNORE_FILE(1:LEN),
     2            STATUS='OLD',
     3            READONLY,
     4            ACCESS='SEQUENTIAL',
     5            ERR=9100)
            USE_IGNORE = .TRUE.
          ELSE
 9100       IF (CLI$PRESENT('IGNORE')) THEN
              WRITE (UNT,*) '%LIST-I-NOIGNORE, Cannot open ',
     1                      '/CROSS_CHECK ignore file - okay.'
            ENDIF
            USE_IGNORE = .FALSE.
          ENDIF
C
C         OPEN SYSUAF
C
          SYS_UNT=60
          CALL OPEN_SYSUAF (SYS_UNT)
C
C         OPEN LIST FILE
C
          CALL OPEN_INPUT (.TRUE.)
C
          DOWHILE (.TRUE.)
            READ(SYS_UNT,100,END=9000)  USERNAME
            I = LENGTH (USERNAME)
            READ(10,210,KEY=USERNAME(1:I),KEYID=0,ERR=9010) USER

            IF (USER .NE. USERNAME) THEN
C
C         USER NOT THERE, CHECK IGNORE STATUS
C
 9010         CONTINUE

              IF (USE_IGNORE) THEN
                IGNORE_TEST = IGNORE (IGN_UNT, USERNAME)
              ENDIF
C
C         OUTPUT USERNAME IF FITS IGNORE CRITERIA
C
              IF ((.NOT. USE_IGNORE) .OR. 
     1            (USE_IGNORE .AND. (.NOT. IGNORE_TEST))) THEN
                WRITE (UNT,*) '%LIST-I-NOLIST, user in SYSUAF ',
     1                        'not in LIST -  ', USERNAME
              ENDIF
            ENDIF
          ENDDO


 9011     WRITE (*,*) '%LIST-F-OPENERR, Cannot open CROSS_CHECK ',
     1                'output file'
          CALL EXIT (IOST)

 9000     CLOSE (10)
          CLOSE (SYS_UNT)

          IF (UNT .NE. 6) THEN
            CLOSE (UNT)
          ELSE
            WRITE (UNT,*) ' '
          ENDIF

          IF (USE_IGNORE) THEN
            CLOSE (IGN_UNT)
          ENDIF

          RETURN
          END
C
C         END OF CROSS_CHECK
C
C****************************************************************************
C
          SUBROUTINE DELETE
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           14 AUG 1990
C         PURPOSE
C           TO DELETE USER FROM USER LIST
C         DESCRIPTION
C           LOOK FOR USER IN USER LIST AND REMOVE
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             CLOSE_INPUT
C             OPEN_INPUT
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           PRIVS         : USER HAS PRIVELEGE
C           STATUS        : CONTROL VARIABLE
C           ULEN          : USERNAME LENGTH
C           USERNAME      : USERNAME TO DELETE
C           USERREAD      : USERNAME READ FROM INPUT FILE
C           USRNAME       : UTILITY USER'S USERNAME
C
C         FORMATS
C
  100     FORMAT($,X,'_Enter user to delete:  ')
  105     FORMAT(X,'%LIST-I-USRDEL, User is now a gonner.')
  110     FORMAT(X,'%LIST-E-NOSUCHUSR, No such user  ',A)
  120     FORMAT(X,'%LIST-E-NOPRIV, Sorry BUB, No privilege ',
     1           'for attempted operation, cannot delete.')
  200     FORMAT(A12)
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C         DECLARE VARIABLES
C
          INTEGER*4      STATUS, CLI$GET_VALUE, ULEN
          CHARACTER*12   USERNAME, USERREAD, USRNAME
          LOGICAL        SYSPRIV, PRIVS, CLI$PRESENT
C
C         SEE IF USER HAS PRIVELEGES
C
          PRIVS = SYSPRIV (USRNAME)
          IF (PRIVS) THEN
C 
C         GET USERNAME TO DELETE
C
            STATUS = CLI$GET_VALUE ('P1', USERNAME)
            DOWHILE(LENGTH(USERNAME) .EQ. 0)
              WRITE(6,100)
              READ(6,200) USERNAME
            ENDDO
            CALL STR$UPCASE (USERNAME, USERNAME)
C
C         OPEN INPUT FILE
C
            CALL OPEN_INPUT (.FALSE.)
C
C         SEARCH FOR USER IN LIST
C
            ULEN = LENGTH(USERNAME)
            READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1          USERREAD
            IF(USERREAD .EQ. USERNAME)THEN
              DELETE (10)
              WRITE (6,105) 
            ELSE
 9100         WRITE(6,110) USERNAME
            ENDIF
C
C         CLOSE INPUT FILE
C
            CALL CLOSE_INPUT

          ELSE
            IF (CLI$PRESENT('BORING')) THEN
              WRITE (6,600)
            ELSE
              WRITE (6,120)
            ENDIF
          ENDIF
C
          RETURN
          END
C
C         END OF DELETE
C
C****************************************************************************
C
          SUBROUTINE FILE_COMP
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           24 JUN 1992
C         PURPOSE
C           TO COMPRESS LISTING FILES AND PACK DATA
C         DESCRIPTION
C           USE VMS COMPRESSION UTILITY AND SPAWN
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             CLOSE_INPUT
C             OPEN_INPUT
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           COMMAND     : SPAWN COMMAND
C           IOST        : STATUS VARIABLE
C           PHONEFILE   : FILE TO COMPRESS
C           STATUS      : RETURN VARIABLE
C           USER        : PARAMETER PASSED FROM SYSPRIV (NOT USED)
C
C         FORMATS
C
  100     FORMAT (X,'%LIST-F-NOPRIV, Don''t even try it buddy!')
  110     FORMAT (X,'%LIST-F-UKNLIST, Can''t find that file.')
  120     FORMAT (X,'%LIST-S-UNABLE, File may be locked.')
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C         DECLARE VARIABLES
C
          INTEGER*4      STATUS, LIB$SPAWN, IOST
          CHARACTER*12   USER
          CHARACTER*100  PHONEFILE
          CHARACTER*150  COMMAND
          LOGICAL        SYSPRIV, CLI$PRESENT
C
C         COMMON BLOCK
C
          COMMON /LIST_FILE/ PHONEFILE
C
C         CHECK FOR PRIVS
C
          IF (.NOT. SYSPRIV(USER)) THEN
            IF (CLI$PRESENT('BORING')) THEN
              WRITE (6,600)
            ELSE
              WRITE (6,100)
            ENDIF
            CALL EXIT
          ENDIF
C
C         CHECK FOR FILE EXISTENCE
C
          IF (.NOT. CLI$PRESENT('CLEANUP')) THEN
            STATUS = CLI$GET_VALUE ('LISTING', PHONEFILE)
          ENDIF

          OPEN(UNIT=10,
     1         FILE=PHONEFILE,
     2         STATUS='OLD',
     3         ORGANIZATION='INDEXED',
     4         FORM='FORMATTED',
     5         RECL=255,
     6         READONLY,
     7         SHARED,
     8         ACCESS='KEYED',
     9         KEY=(2:13:CHARACTER,17:46:CHARACTER,
     A              50:64:CHARACTER),
     B         IOSTAT=IOST,
     C         ERR=1234)
          IF (.FALSE.) THEN
 1234       IF (IOST .EQ. 29) THEN
              WRITE (6,110)
            ELSE
              WRITE (6,120)
            ENDIF
            CALL EXIT
          ENDIF
C
C         COMPRESS FILE
C
          COMMAND = 'CONVERT/STAT ' // PHONEFILE // '  ' // PHONEFILE
          STATUS = LIB$SPAWN (COMMAND)
C
          RETURN
          END
C
C         END OF FILE_COMP
C
C****************************************************************************
C
         LOGICAL FUNCTION  DISABLE_CHECK (USER)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          15 JANUARY 1994
C        PURPOSE
C          TO CHECK ON DISUSER STATUS OF AN ACCOUNT
C        DESCRIPTION
C          USE GETUAI SYSTEM SERVICE
C        COMMUNICATIONS
C          CALLS FROM
C            CHECK
C            GROUP_LIST
C            NAME_LIST
C            USER_LIST
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          USER      : USER TO CHECK STATUS FOR
C        LOCAL GLOSSARY
C          FLAG      : LIST OF USER FLAGS FOR SYSUAF.DAT
C          FLAG_LEN  : RETURN VARIABLE FOR FLAG
C          STATUS    : RETURN VARIABLE
C
C
C        INCLUDES
C
         INCLUDE        '($UAIDEF)'
C
C        DECLARE STRUCTURES AND RECORDS
C
         STRUCTURE      /ITMLST/
           UNION
             MAP
               INTEGER*2  BUFLEN
               INTEGER*2  ITMCOD
               INTEGER*4  BUFADR
               INTEGER*4  RETADR
             END MAP
             MAP
               INTEGER*4  END_LIST
             END MAP
           END UNION
         END STRUCTURE
C
         RECORD  / ITMLST /  GETUAI_LIST(2)
C
C        DECLARE VARIABLES
C
         INTEGER*4      STATUS, SYS$GETUAI, FLAG_LEN, FLAGS
         CHARACTER*(*)  USER
C
C        INTIALIZE ITMLST
C         
         GETUAI_LIST(1).BUFLEN = 4
         GETUAI_LIST(1).ITMCOD = UAI$_FLAGS
         GETUAI_LIST(1).BUFADR = %LOC(FLAGS)
         GETUAI_LIST(1).RETADR = %LOC(FLAG_LEN)
         GETUAI_LIST(2).END_LIST = 0
C
C        GET THE USER INFORMATION FROM THE UAF FILES
C
         STATUS = SYS$GETUAI(,,USER,GETUAI_LIST,,,)

         IF (BTEST(FLAGS, UAI$V_DISACNT)) THEN
           DISABLE_CHECK = .TRUE.
         ELSE
           DISABLE_CHECK = .FALSE.
         ENDIF
C
         RETURN
         END
C
C        END OF DISABLE_CHECK
C
C***********************************************************************
C
         SUBROUTINE DISPLAY_PLAN (USER, UNT)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          26 JULY 1994
C        PURPOSE
C          DISPLAY PLAN FILE
C        DESCRIPTION
C          EXTRACT USER'S LOGIN DEVICE AND DIRECTORY FROM SYSUAF AND
C          WRITE OUT PLAN$LENGTH LINES FROM LIST.PLAN IN USER'S HOME DIRECTORY
C        COMMUNICATIONS
C          CALLS FROM
C            NAME_LIST
C            USER_LIST
C          CALLS TO
C            CLEAN_PLAN
C            LENGTH
C
C        PARAMETERS
C          UNT       : UNIT TO WRITE TO
C          USER      : USER TO DISPLAY PLAN FILE FOR
C        LOCAL GLOSSARY
C          DEV       : LOGIN DEVICE
C          DEVLEN    : LENGTH OF DEV
C          DIR       : LOGIN DIRECTORY
C          DIRLEN    : LENGTH OF DIR
C          FILENAME  : THE PLAN FILE
C          I         : CONTROL VARIABLE
C          J         : CONTROL VARIABLE
C          PLAN$LENGTH
C                    : NUMBER OF PLAN FILE LINES TO DISPLAY
C          RECORD    : RECORD READ FROM PLAN FILE
C
C        INCLUDES
C
         INCLUDE        '($UAIDEF)'
         INCLUDE        '($UICDEF)'
C
C        FORMATS
C
  100    FORMAT (A80)
  101    FORMAT (X,A)
  102    FORMAT (A)
C
C        STRUCTURE
C
         STRUCTURE  /SYSUAF_ITEM/
           UNION
             MAP
               INTEGER*2    BUFLEN, ITEM_CODE
               INTEGER*4    BUFADR, RETADR
             END MAP
             MAP
               INTEGER*4    END_LIST
             END MAP
           END UNION
         END STRUCTURE

         RECORD /SYSUAF_ITEM/  SYSUAF_INFO(3)
C
C        DECLARE VARIABLES
C
         INTEGER*4       PLAN$LENGTH, I, DEVLEN, DIRLEN, STATUS,
     1                   SYS$GETUAI, LENGTH, UNT, J
         CHARACTER*(*)   USER
         CHARACTER*32    DEV
         CHARACTER*64    DIR
         CHARACTER*80    RECORD
         CHARACTER*255   FILENAME
C
C        COMMON BLOCK
C
         COMMON /PLAN/ PLAN$LENGTH
C
C        SET UP VARIABLES
C
         I = 0
         SYSUAF_INFO(1).ITEM_CODE  = UAI$_DEFDEV
         SYSUAF_INFO(1).BUFLEN     = 32
         SYSUAF_INFO(1).BUFADR     = %LOC(DEV)
         SYSUAF_INFO(1).RETADR     = %LOC(DEVLEN)
         SYSUAF_INFO(2).ITEM_CODE  = UAI$_DEFDIR
         SYSUAF_INFO(2).BUFLEN     = 64
         SYSUAF_INFO(2).BUFADR     = %LOC(DIR)
         SYSUAF_INFO(2).RETADR     = %LOC(DIRLEN)
         SYSUAF_INFO(3).END_LIST   = 0

         STATUS = SYS$GETUAI(,,USER,SYSUAF_INFO,,,)
C
         IF (STATUS) THEN
C
C        SETUP FILE NAME
C
           IF (ICHAR(DEV(1:1)) .LE. 32) THEN
             DEV = DEV(2:)
           ENDIF
           IF (ICHAR(DIR(1:1)) .LE. 32) THEN
             DIR = DIR(2:)
           ENDIF
           DIRLEN = LENGTH (DIR)
           DEVLEN = LENGTH (DEV)
           IF (DIRLEN .LE. 0) THEN
             DIR = '[000000]'
           ENDIF
           DIRLEN = LENGTH (DIR)

           IF (DEVLEN .GT. 0) THEN
             IF (DEV(DEVLEN:DEVLEN) .NE. ':') THEN
               DEV = DEV(1:DEVLEN) // ':'
               DEVLEN = DEVLEN + 1
             ENDIF
           ENDIF

           FILENAME = DEV(1:DEVLEN) // DIR(1:DIRLEN) // 'LIST.PLAN'
C
C        OPEN FILENAME
C
           OPEN (UNIT=80,
     1           FILE=FILENAME,
     2           STATUS='OLD',
     3           READONLY,
     4           SHARED,
     5           CARRIAGECONTROL='LIST',
     6           ERR=9112)
C
           I = 0
           DOWHILE (I .LT. PLAN$LENGTH)
             READ (80,100,ERR=9113,END=9113) RECORD
             IF (I .EQ. 0) THEN
               WRITE (UNT,*) 'Plan:'
             ENDIF
             CALL CLEAN_PLAN (RECORD)
             J = LENGTH (RECORD)
             IF (UNT .EQ. 6) THEN
               WRITE (UNT,101) RECORD(1:J)
             ELSE
               WRITE (UNT,102) RECORD(1:J)
             ENDIF
             I = I + 1
           ENDDO
 9113      CLOSE (80)
           IF (I .EQ. 0) THEN
             I = LENGTH (USER)
             WRITE (UNT,*) 'Plan:    ', USER(1:I), '  has empty plan ',
     1                     'file.'
           ENDIF
         ELSE
 9112      I = LENGTH (USER)
           WRITE (UNT,*) 'Plan:    ', USER(1:I), '  has no plan.'
         ENDIF
C
         RETURN
         END
C
C        END OF DISPLAY_PLAN
C
C***********************************************************************
C
          SUBROUTINE GROUP_LIST (UNT, COUNT)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           14 JAN 1991
C           19 MAY 1993       JON BAKER
C                             DISPLAY EMPLOYER AND DATE FIELDS IF /FULL
C         PURPOSE
C           TO PRINT OUT THE LIST BY GROUP
C         DESCRIPTION
C           PRINT ACCORDING TO GROUP KEY
C         COMMUNICATIONS
C           CALLS BY
C             MAIN
C           CALLS TO
C             DISPLAY_PLAN
C             PRINT_HEADER
C             LENGTH
C
C         PARAMETERS
C           COUNT   : COUNT OF USERS DISPLAYED
C           UNT     : UNIT NUMBER FOR PRINTING
C         LOCAL GLOSSARY
C           DISABLED: ACCOUNT HAS BEEN DISABLED
C           EMPLOYER: EMPLOYER NAME
C           GROUP   : GROUP TO GET INFO ON
C           I       : CONTROL VARIABLE
C           PHONE   : PHONE NUMBER
C           PLAN$LENGTH
C                   : NUMBER OF LINES TO DISPLAY FROM PLAN FILE
C           STAT    : RETURN STATUS VARIABLE
C           THE_DATE: DATE RECORD MODIFIED/ADDED
C           UGROUP  : GROUPG OF A USER
C           UNAME   : NAME OF USER
C           USER    : USERNAME OF USER
C           
C
C         FORMATS
C
  120     FORMAT(X,A15,3X,A12,3X,A30,2X,A13)
  121     FORMAT(10X,'EMP: ',A30,4X,'(last mod): ',A11)
  122     FORMAT(10X,'UIC: ',A30,4X,'(disabled): ',A)
  130     FORMAT(X,'%LIST-I-NOLIST, Phone listing is empty. ')
  200     FORMAT(X,'%LIST-E-NOGROUP, No group specified.')
  210     FORMAT(X,'%LIST-E-UNKNWNGROUP, Unknown group  ',A)
  215     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
C
C         DECLARE VARIABLES
C
          INTEGER       UNT, COUNT, STAT, CLI$GET_VALUE, I
          INTEGER*4     PLAN$LENGTH
          CHARACTER*11  THE_DATE, DISABLED
          CHARACTER*12  USER
          CHARACTER*14  PHONE
          CHARACTER*15  GROUP, UGROUP
          CHARACTER*30  UNAME, EMPLOYER, UIC
          LOGICAL       CLI$PRESENT, DISABLE_CHECK
C
C         COMMON BLOCK
C
          COMMON /PLAN/ PLAN$LENGTH
C
C         INITIALIZE VARIABLES
C
          COUNT = 0
C
C         GET GROUP KEY
C
          STAT = CLI$GET_VALUE('GROUP',GROUP)
          CALL STR$UPCASE (GROUP, GROUP)
          CALL OPEN_INPUT (.TRUE.)
          IF (GROUP(1:1) .NE. ' ') THEN
            I = LENGTH (GROUP)
C
C         SEARCH FOR KEY
C
            READ(10,215,KEY=GROUP(1:I),KEYID=2,ERR=9900) USER, 
     1          UNAME, UGROUP, PHONE, THE_DATE, EMPLOYER, UIC
            CALL PRINT_HEADER ('G', UNT)
C
C         READ WHILE DATA MATCHES KEY
C
            DOWHILE (GROUP(1:I) .EQ. UGROUP(1:I))
              COUNT = COUNT + 1
              WRITE (UNT,120) UGROUP, USER, UNAME, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USER)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USER, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ(10,215,ERR=9910,END=9910) USER, 
     1            UNAME, UGROUP, PHONE, DATE, EMPLOYER
            ENDDO
          ELSE
C
C         LIST ALL GROUPS
C
            READ (10,215,KEYGE=' ',KEYID=2,ERR=9020) 
     1            USER, UNAME, UGROUP, PHONE, THE_DATE, EMPLOYER,
     2            UIC
            CALL PRINT_HEADER ('G', UNT)
            DOWHILE (.TRUE.)
              COUNT = COUNT + 1
              WRITE (UNT,120) UGROUP, USER, UNAME, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USER)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USERNAME, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ (10,215,END=9910) USER, UNAME, UGROUP, PHONE,
     1                               THE_DATE, EMPLOYER, UIC
            ENDDO
          ENDIF
C
C         GROUP IS NOT KNOWN
C
          IF (.FALSE.) THEN
 9900       WRITE (6,210) GROUP
          ENDIF
C
C         EMPTY LISTING FILE
C
          IF (.FALSE.) THEN
 9020       WRITE (6,130) GROUP
          ENDIF
C
 9910     RETURN
          END 
C
C         END OF GROUP_LIST
C
C***************************************************************************
C
         LOGICAL FUNCTION IGNORE (UNT, USER)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          5 JUNE 1997
C        PURPOSE
C          TO FIND IF USER IS TO BE IGNORED DURING CROSS_CHECK
C        DESCRIPTION
C          CHECK FOR USER IN IGNORE FILE.  IF THERE, RETURN TRUE.
C          FILE OPENED IN PREVIOUS ROUTINE.
C        COMMUNICATIONS
C          CALLS FROM
C            CROSS_CHECK
C          CALLS TO
C            NONE
C
C        PARAMETERS
C          UNT      : IGNORE FILE UNIT NUMBER
C          USER     : USER TO SEARCH FOR
C        LOCAL GLOSSARY
C          NONE
C
C        FORMATS
C
  100    FORMAT(A12)
C
C        DECLARE VARIABLES
C
         INTEGER*4      UNT
         CHARACTER*12   USER, USERNAME
         LOGICAL        FOUND
C
         IGNORE = .FALSE.
         FOUND  = .FALSE.
         REWIND (UNT)
C
         DOWHILE (.NOT. FOUND)
           READ (UNT,100,END=9000) USERNAME
           IF (USER .EQ. USERNAME) THEN
             IGNORE = .TRUE.
             FOUND  = .TRUE.
           ENDIF
         ENDDO
C
 9000    RETURN
         END
C
C        END OF IGNORE
C
C****************************************************************************
C
          INTEGER FUNCTION LENGTH(STR)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           06 MAR 1986
C           09 FEB 1998  JON BAKER
C                EXCLUDE VERTICAL TABS AS WELL AS SPACES.
C         PURPOSE
C           TO FIND LENGTH OF STRING STR
C         DESCRIPTION
C           READ EACH CHARACTER OF X UNTIL BLANK IS FOUND
C         PRE
C           X MUST BE CHARACTER
C         POST
C           LENGTH OF X IS FOUND TO FIRST BLANK
C         COMMUNICATIONS
C           CALLS BY
C             MAIN
C           CALLS TO
C             (NONE)
C
C         PARAMETERS
C           STR : STRING TO FIND LENGTH OF
C         LOCAL GLOSSARY
C           I   : CONTROL VARIABLE
C       
C         DECLARE VARIABLES
C
          INTEGER        I
          CHARACTER*1    BLANK, TAB
          CHARACTER*(*)  STR
C
C         SETUP VARIABLES (ASCII REP)
C
          BLANK = CHAR(32)
          TAB   = CHAR(9)
C
          I = LEN(STR)
          DOWHILE((I .GT. 0) .AND. ((STR(I:I) .EQ. BLANK) .OR.
     1                              (STR(I:I) .EQ. TAB)))
            I = I - 1
          ENDDO
          LENGTH = I
C
          RETURN
          END
C
C         END OF LENGTH
C
C*****************************************************************************
C
          SUBROUTINE MODIFY
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           20 DECEMBER 1990
C           18 MAY 1993         JON BAKER
C                               ADD IN EMPLOYER AND DATE FIELDS
C           18 DEC 1997         JON BAKER
C                               FIX BLANKING OUT EMPLOYER FIELD WHEN HITTING
C                               <RETURN> WITH NO CHANGES
C         PURPOSE
C           TO MODIFY AN EXISTING ENTRY
C         DESCRIPTION
C           PULL ENTRY AND REPLACE WITH NEW INFORMATION
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C           CALLS TO
C             AUTHINFO
C             COMPRESS
C             LENGTH
C             SYSPRIV
C
C         PARAMETERS
C           (NONE)
C         LOCAL GLOSSARY
C           CHANGE    : CHANGES MADE TO USER INFO??
C           GROUP     : GROUP IN LIST
C           MEMPLOYER : MODIFIED EMPLOYER
C           MGROUP    : MODIFIED GROUP
C           MNAME     : MODIFIED NAME
C           MNUMBER   : MODIFIED PHONE NUMBER
C           MUIC      : MODIFIED USER CODE
C           NAME      : NAME IN LIST
C           NUMBER    : PHONE NUMBER IN LIST
C           OK        : OKAY TO CONTINUE??
C           OKNUM     : OK NUMBER
C           PRIVS     : USER HAS PRIVS??
C           STATUS    : RETURN VARIABLE
C           THE_DATE  : DATE MODIFIED
C           UIC       : USER CODE
C           ULEN      : LENGTH OF USERNAME
C           USERREAD  : USERNAME READ FROM LIST
C           USERNAME  : USERNAME TO MODIFY
C
C         FORMATS
C
  101     FORMAT(X,'_Enter new full name - ( LAST,   FIRST   ',
     1           'MIDDLE   [nick-name] )',/,$,X,
     2           '[<CR> -  no change]:  ')
  102     FORMAT(X,'_Enter new phone number with format - ',
     1           '(123)456-7890',/,$,X,'[<CR> - no change]:  ')
  103     FORMAT(X,'%LIST-I-NOCOMMA, Separte last name with comma.')
  105     FORMAT(X,'%LIST-I-USRMOD, List successfully modified')
  110     FORMAT(X,'%LIST-E-NOSUCHUSR, No such user  ',A)
  120     FORMAT(X,'%LIST-E-NOPRIV, Don''t you just wish you had',
     1           ' the privilege to modify.')
  130     FORMAT(X,'_Enter new employer, etc. ',/,$,X,
     1           '[<CR> - no change]:  ')
  200     FORMAT(A12)
  201     FORMAT(A)
  202     FORMAT(A22)
  205     FORMAT(X,'%LIST-I-NOMODS, No modifications made.')
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C         DECLARE VARIABLES
C
          INTEGER*4       CLI$GET_VALUE, STATUS, ULEN, LENGTH
          CHARACTER*11    THE_DATE
          CHARACTER*12    USERNAME, USERREAD
          CHARACTER*14    MNUMBER
          CHARACTER*15    GROUP, MGROUP
          CHARACTER*22    NUMBER
          CHARACTER*30    EMPLOYER, MEMPLOYER, UIC, MUIC
          CHARACTER*35    NAME, MNAME
          LOGICAL         SYSPRIV, PRIVS, CLI$PRESENT, CHANGE, OK,
     1                    NUMBER_CHECK, OKNUM
C
C         INITIALIZE VARIABLES
C
          UIC = ' '
          MUIC = ' '
C
C         DETERMINE USERNAME
C
          PRIVS = SYSPRIV (USERNAME)
          IF (CLI$PRESENT('USER'))THEN
            STATUS = CLI$GET_VALUE ('USER', USERNAME)
          ENDIF
          CALL STR$UPCASE (USERNAME, USERNAME)

          IF (((CLI$PRESENT('USER')) .AND. (PRIVS)) .OR.
     1        (.NOT. (CLI$PRESENT('USER')))) THEN
C
C         CHECK TO SEE IF USER EXISTS
C
            CALL OPEN_INPUT (.TRUE.)
            ULEN = LENGTH (USERNAME)
            READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1          USERREAD, MNAME, MGROUP, MNUMBER, THE_DATE, 
     2          MEMPLOYER, MUIC
            CALL CLOSE_INPUT
            IF (USERREAD .EQ. USERNAME) THEN
C
C         GET GROUP INFO
C
              CALL AUTHINFO (USERNAME, GROUP, UIC)
C
C         GET NEW NAME OF USER
C
              STATUS = CLI$GET_VALUE ('P1', NAME)
              DOWHILE (((INDEX (NAME, ',') .EQ. 0) .OR.
     1                  (INDEX (NAME, ',') .EQ. 1)) .AND.
     2                 (NAME(1:1) .NE. '*'))
                WRITE(6,101)
                READ(6,201) NAME
                IF (LENGTH (NAME) .EQ. 0) THEN
                  NAME(1:1) = '*'
                ELSE IF ((INDEX (NAME, ',') .EQ. 0) .OR.
     1                   (INDEX (NAME, ',') .EQ. 1)) THEN
                  WRITE (6,*) ' '
                  WRITE (6,103)
                  WRITE (6,*) ' '
                ENDIF
              ENDDO
              CALL STR$UPCASE (NAME, NAME)
              CALL COMPRESS (NAME)
C
C         GET NEW PHONE NUMBER OF USER
C
              STATUS = CLI$GET_VALUE ('P2', NUMBER)
              IF (LENGTH(NUMBER) .EQ. 0) THEN
                OK = .FALSE.
                DOWHILE (.NOT. (OK))
                  WRITE(6,102)
                  READ(6,202) NUMBER
                  IF (LENGTH (NUMBER) .EQ. 0) THEN
                    NUMBER(1:1) = '*'
                    OK = .TRUE.
                  ELSE
                    CALL COMPRESS (NUMBER)
                    OKNUM = NUMBER_CHECK (NUMBER)
                    IF (OKNUM) THEN
                      OK = .TRUE.
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF
C
C         GET NEW EMPLOYER NAME
C
              STATUS = CLI$GET_VALUE ('P3', EMPLOYER)
              IF (LENGTH(EMPLOYER) .EQ. 0) THEN
                WRITE(6,130)
                READ(6,201) EMPLOYER
                IF (LENGTH (EMPLOYER) .EQ. 0) THEN
                  EMPLOYER = MEMPLOYER
                ELSE
                  CALL STR$UPCASE (EMPLOYER, EMPLOYER)
                  CALL COMPRESS (EMPLOYER)
                ENDIF
              ENDIF
C
C         CHECK TO SEE IF ANY CHANGES
C
              CHANGE = .FALSE.
              IF (GROUP .NE. MGROUP) THEN
                MGROUP = GROUP
                CHANGE = .TRUE.
              ENDIF

              IF (UIC .NE. MUIC) THEN
                MUIC = UIC
                CHANGE = .TRUE.
              ENDIF

              IF (NUMBER(1:1) .NE. '*') THEN
                MNUMBER = NUMBER
                CHANGE = .TRUE.
                DO 1011 I = 14, LEN(NUMBER)
                  MNUMBER(I:I) = ' '
 1011           CONTINUE
              ENDIF

              IF (NAME(1:1) .NE. '*') THEN
                MNAME = NAME
                CHANGE = .TRUE.
              ENDIF

              IF (EMPLOYER .NE. MEMPLOYER) THEN
                MEMPLOYER = EMPLOYER
                CHANGE = .TRUE.
              ENDIF

              IF (CHANGE) THEN
                CALL LIB$DATE_TIME (THE_DATE)
                CALL OPEN_INPUT (.FALSE.)
                READ(10,210,KEYID=0,KEY=USERNAME(1:ULEN),ERR=9100) 
     1          USERREAD
                REWRITE (10,210) USERNAME, MNAME, MGROUP, MNUMBER,
     1                           THE_DATE, MEMPLOYER, MUIC
                WRITE (6,105)
                CALL CLOSE_INPUT
              ELSE
                WRITE (6,205)
              ENDIF
            ELSE
C
C         UNKNOWN USER
C
 9100         WRITE (6,110) USERNAME
              CALL CLOSE_INPUT
            ENDIF
          ELSE
            IF (CLI$PRESENT('BORING')) THEN
              WRITE (6,600)
            ELSE
              WRITE (6,120) 
            ENDIF
          ENDIF
C
          RETURN
          END
C
C         END OF MODIFY
C
C*****************************************************************************
C
          SUBROUTINE NAME_LIST (UNT, COUNT, NAME)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           17 JAN 1991
C           19 MAY 1993       JON BAKER
C                             DISPLAY EMPLOYER AND DATE FIELDS IF /FULL
C         PURPOSE
C           TO PRINT OUT THE LIST BY NAME
C         DESCRIPTION
C           PRINT ACCORDING TO NAME KEY
C         COMMUNICATIONS
C           CALLS BY
C             MAIN
C           CALLS TO
C             DISPLAY_PLAN
C             PRINT_HEADER
C             LENGTH
C
C         PARAMETERS
C           COUNT   : COUNT OF USERS DISPLAYED
C           NAME    : NAME OF USER TO SEARCH FOR
C           UNT     : UNIT NUMBER FOR PRINTING
C         LOCAL GLOSSARY
C           DISABLED: ACCOUNT HAS BEEN DISABLED
C           EMPLOYER: EMPLOYER NAME
C           GROUP   : GROUP FROM FILE
C           I       : CONTROL VARIABLE
C           PHONE   : PHONE NUMBER FROM FILE
C           PLAN$LENGTH
C                   : NUMERICAL LOGPLAN
C           THE_DATE: DATE RECORD MODIFIED/ADDED
C           UIC     : USER CODE
C           UNAME   : USER'S NAME FROM FILE
C           USER    : USERNAME FROM FILE
C
C         FORMATS
C
  100     FORMAT(X,A12,3X,A30,3X,A15,2X,A13)
  110     FORMAT(X,'%LIST-I-UNKNOWN, Unknown name - ',A)
  120     FORMAT(X,A30,3X,A12,3X,A15,3X,A13)
  121     FORMAT(10X,'EMP: ',A30,4X,'(last mod): ',A11)
  122     FORMAT(10X,'UIC: ',A30,4X,'(disabled): ',A)
  130     FORMAT(X,'%LIST-I-NOLIST, Phone listing is empty. ')
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
C
C         DECLARE VARIABLES
C
          INTEGER       COUNT, UNT, I
          INTEGER*4     PLAN$LENGTH
          CHARACTER*11  THE_DATE, DISABLED
          CHARACTER*12  USER
          CHARACTER*14  PHONE
          CHARACTER*15  GROUP
          CHARACTER*30  UNAME, NAME, EMPLOYER, UIC
          LOGICAL       CLI$PRESENT, DISABLE_CHECK
C
C         COMMON BLOCK
C
          COMMON /PLAN/ PLAN$LENGTH
C
C         INITIALIZE VARIABLES
C
          COUNT = 0
C
C         OPEN INPUT FILE
C
          CALL OPEN_INPUT (.TRUE.)
          IF (NAME(1:1) .NE. ' ') THEN
C
C         FIND KEY IN PHONE BOOK
C
            I = LENGTH (NAME)
            READ(10,210,KEY=NAME(1:I),KEYID=1,ERR=9000) USER, UNAME,
     1          GROUP, PHONE, THE_DATE, EMPLOYER, UIC
            CALL PRINT_HEADER ('N', UNT)
C
C         LOOP WHILE KEY FITS
C
            DOWHILE (NAME(1:I) .EQ. UNAME(1:I))
              COUNT = COUNT + 1
              WRITE (UNT,120) UNAME, USER, GROUP, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USER)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USER, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ(10,210,END=9010) USER, UNAME,
     1             GROUP, PHONE, THE_DATE, EMPLOYER, UIC
            ENDDO
          ELSE
C
C         LIST ALL BY NAME
C
            READ(10,210,ERR=9040,KEYGE=' ',KEYID=1) 
     1           USER, UNAME, GROUP, PHONE, THE_DATE, EMPLOYER,
     2           UIC
            CALL PRINT_HEADER ('N', UNT)
            DOWHILE (.TRUE.)
              COUNT = COUNT + 1
              WRITE (UNT,120) UNAME, USER, GROUP, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USER)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USERNAME, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ (10,210,END=9010) USER, UNAME, GROUP, PHONE,
     1                               THE_DATE, EMPLOYER, UIC
            ENDDO
          ENDIF
C
C         NAME DOES NOT EXIST
C
          IF (.FALSE.) THEN
 9000       WRITE (6,110) NAME
          ENDIF
C
C         EMPTY LISTING FILE
C
          IF (.FALSE.) THEN
 9040       WRITE (6,130) GROUP
          ENDIF
C
 9010     RETURN
          END
C
C         END OF NAME_LIST
C
C****************************************************************************
C
          LOGICAL FUNCTION NUMBER_CHECK (NUM)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           28 DECEMBER 1990
C         PURPOSE
C           TO CHECK TO SEE IF VALID PHONE NUMBER
C         DESCRIPTION
C           MAKE SURE ALL NUMBERS EXCEPT (, ), -
C         COMMUNICATIONS
C           CALLS FROM
C             ADD
C             MODIFY
C           CALLS TO
C             LENGTH
C
C         PARAMETERS
C           NUM      : NUMBER TO CHECK
C         LOCAL GLOSSARY
C           DASH     : LOCATION OF A DASH
C           I        : CONTROL VARIABLE
C           J        : CONTROL VARIABLE
C           LP       : LOCATION OF A LEFT PAREN
C           NUMCOUNT : A COUNT OF NUMBERS
C           NUMLEN   : LENGTH OF NUM
C           QUIT     : STOP CHECKING
C           RP       : LOCATION OF A RIGHT PAREN
C           TEMP     : TEMPORARY VARIABLE
C
C         FORMAT
C
  100     FORMAT (X,'%LIST-W-WRONGNUM, Use the correct',
     1            ' number format.')
C
C         DECLARE VARIABLES
C
          INTEGER        I, LENGTH, DASH, LP, RP, NUMLEN,
     1                   NUMCOUNT, J
          CHARACTER*(*)  NUM
          CHARACTER*20   TEMP
          LOGICAL        QUIT
C
C         INITIALIZE VARIABLES
C
          NUMBER_CHECK = .TRUE.
          NUMLEN = LENGTH (NUM)
          IF (NUMLEN .GE. 10) THEN
            TEMP(1:1) = '('
            TEMP(5:5) = ')'
            TEMP(9:9) = '-'
            NUMCOUNT = 0
C
C         ERASE (, ), -
C 
            LP = INDEX (NUM, '(')
            DOWHILE (LP .GT. 0)
              NUM(LP:LP) = ' '
              LP = INDEX (NUM, '(')
            ENDDO

            RP = INDEX (NUM, ')')
            DOWHILE (RP .GT. 0)
              NUM(RP:RP) = ' '
              RP = INDEX (NUM, ')')
            ENDDO

            DASH = INDEX (NUM, '-')
            DOWHILE (DASH .GT. 0)
              NUM(DASH:DASH) = ' '
              DASH = INDEX (NUM, '-')
            ENDDO
C
C         DISCERN IF PROPER
C
            J = 1
            I = 1
            QUIT = .FALSE.

            DOWHILE ((I .LE. NUMLEN) .AND. (.NOT. (QUIT)))
              IF (((NUM(I:I) .LT. '0') .OR. 
     1             (NUM(I:I) .GT. '9')) .AND.
     2            (NUM(I:I) .NE. ' ')) THEN
                QUIT = .TRUE.
              ELSE IF (NUM(I:I) .EQ. ' ') THEN
                I = I + 1
              ELSE
                J = J + 1
C
C        CHECK FOR ()- FORMAT
C
                IF ((J .EQ. 1) .OR.
     1              (J .EQ. 5) .OR.
     2              (J .EQ. 9)) THEN
                  J = J + 1
                ENDIF
                NUMCOUNT = NUMCOUNT + 1
                TEMP(J:J) = NUM(I:I)
                I = I + 1            
              ENDIF
            ENDDO
          ENDIF
C
C         SET THE NUMBER RETURN
C
          IF ((QUIT) .OR. (NUMCOUNT .NE. 10))THEN
            IF (LENGTH (NUM) .GT. 0) THEN
              WRITE (6,*) ' '
              WRITE (6,100)
              WRITE (6,*) ' '
            ENDIF
            NUM(1:1) = ' '
            NUMBER_CHECK = .FALSE.
          ELSE
            NUM = TEMP
          ENDIF
C
          RETURN
          END
C
C         END OF NUMBER_CHECK
C
C*****************************************************************************
C
          SUBROUTINE OPEN_INPUT (ONLYREAD)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           14 AUG 1990
C           24 JUN 1992   JON BAKER
C              ADAPT FOR /LISTING QUALIFIER
C         PURPOSE
C           TO OPEN THE INDEXED FILE OF USERS
C         DESCRIPTION
C           OPEN FILE INDEXED ACCORDINGLY (EITHER READ/WRITE OR READONLY)
C           TRUE   = OPEN FOR READ ONLY
C           FALSE  = OPEN FOR READ/WRITE
C         COMMUNICATIONS
C           CALLS FROM
C             MAIN
C             ADD
C             DELETE
C             MODIFY
C           CALLS TO
C             (NONE)
C
C         PARAMETERS
C           ONLYREAD       : FILE OPEN FOR READONLY??
C         LOCAL GLOSSARY
C           COUNT          : OPEN TRY COUNT
C           IOST           : IOSTAT OPEN NUMBER
C           PHONEFILE      : PHONE LISTING FILE
C           STATUS         : CONTROL VARIABLE
C           USER           : USERNAME PASSED FROM SYSPRIV (NOT USED)
C
C         FORMAT
C
  150     FORMAT (X,'LIST-I-CRELIST, Creating phone list...')
  160     FORMAT (X,'LIST-F-UKNLIST, Unknown phone list.')
C
C         DECLARE VARIABLES
C
          INTEGER*4        IOST, COUNT, STATUS, LIB$WAIT, CLI$GET_VALUE
          CHARACTER*12     USER
          CHARACTER*100    PHONEFILE
          LOGICAL          ONLYREAD, SYSPRIV, CLI$PRESENT
C
C         GET LISTING FILE
C
          STATUS = CLI$GET_VALUE ('LISTING', PHONEFILE)
C
C         OPEN INPUT FILE
C
          IOST=30
          COUNT = 0
          DOWHILE ((IOST .EQ. 30) .AND. (COUNT .LT. 5))
            IF (ONLYREAD) THEN
C
C         OPEN FILE TO READ ONLY
C
              OPEN(UNIT=10,
     1             FILE=PHONEFILE,
     2             STATUS='OLD',
     3             ORGANIZATION='INDEXED',
     4             FORM='FORMATTED',
     5             RECL=255,
     6             READONLY,
     7             SHARED,
     8             ACCESS='KEYED',
     9             KEY=(2:13:CHARACTER,17:46:CHARACTER,
     A                  50:64:CHARACTER),
     B             IOSTAT=IOST,
     C             ERR=4321)
            ELSE
 4321         IF ((IOST .EQ. 0)  .OR.
     1            (IOST .EQ. 29) .OR. 
     2            (IOST .EQ. 30)) THEN

                IF (IOST .EQ. 29) THEN
                  IF (SYSPRIV(USER)) THEN
                    WRITE (6,150)
                  ELSE
                    WRITE (6,160)
                    CALL EXIT
                  ENDIF
                ENDIF
C
C           OPEN FILE FOR READ / WRITE
C
                OPEN(UNIT=10,
     1               FILE=PHONEFILE,
     2               STATUS='UNKNOWN',
     3               ORGANIZATION='INDEXED',
     4               FORM='FORMATTED',
     5               RECL=255,
     6               ACCESS='KEYED',
     7               KEY=(2:13:CHARACTER,17:46:CHARACTER,
     8                    50:64:CHARACTER),
     9               IOSTAT=IOST,
     A               ERR=1234)
              ENDIF
            ENDIF

 1234       IF (IOST .EQ. 30) THEN
              STATUS = LIB$WAIT(2.0)
              COUNT = COUNT + 1
              IF (COUNT .EQ. 5) THEN
                IF (.NOT. CLI$PRESENT('CHECK')) THEN
                  WRITE(6,*)' %LIST-W-FILEACC, File already accessed.'
                  WRITE(6,*)' Try again in a few seconds.'
                ENDIF
                CALL EXIT
              ENDIF
            ELSE IF (IOST .EQ. 29) THEN
C
C           NULL BODY (HANDLED PREVIOUSLY - JUST DON'T WANT TO DISPLAY
C           FOLLOWING ERROR MESSAGE.)
C
            ELSEIF (IOST .NE. 0) THEN
              WRITE(6,*) ' %LIST-F-OPENERROR, Error opening PHONE.BOOK'
              WRITE(6,*) ' Contact and notify SYSTEMS GROUP of error.'
              WRITE(6,*) ' *** IOSTAT=',IOST
              CALL EXIT
            ENDIF
          ENDDO
C
          RETURN
          END
C
C         END OF OPEN_INPUT
C
C*************************************************************************
C
          SUBROUTINE PRINT_HEADER (FORM, UNT)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           14 JAN 1991
C         PURPOSE
C           TO PRINT OUTPUT HEADER
C         DESCRIPTION
C           PRINT OUT HEADER ACCORDING TO FORM
C         COMMUNICATIONS
C           CALLS BY
C             MAIN
C           CALLS TO
C             (NONE)
C
C         PARAMETERS
C           FORM    : WAY TO PRINT HEADER
C           UNT     : UNIT NUMBER FOR PRINTING
C         LOCAL GLOSSARY
C           (NONE)
C
C         FORMATS
C
  100     FORMAT(X,A8,7X,A4,29X,A5,12X,A5)
  110     FORMAT(X,A4,29X,A8,7X,A5,12X,A5)
  120     FORMAT(X,A5,13X,A8,7X,A4,28X,A5)
C
C         DECLARE VARIABLES
C
          INTEGER       UNT
          CHARACTER*1   FORM
C
          WRITE (UNT,*) ' '
C
C         OUTPUT HEADER ACCORDING TO USERNAME
C
          IF (FORM .EQ. 'U') THEN
            WRITE (UNT,100) 'USERNAME', 'NAME', 'GROUP', 'PHONE'
            WRITE (UNT,100) '--------', '----', '-----', '-----'
C
C         OUTPUT HEADER ACCORDING TO NAME
C
          ELSE IF (FORM .EQ. 'N') THEN
            WRITE (UNT,110) 'NAME', 'USERNAME', 'GROUP', 'PHONE'
            WRITE (UNT,110) '----', '--------', '-----', '-----'
C
C         OUTPUT HEADER ACCORDING TO GROUP
C
          ELSE IF (FORM .EQ. 'G') THEN
            WRITE (UNT,120) 'GROUP', 'USERNAME', 'NAME', 'PHONE'
            WRITE (UNT,120) '-----', '--------', '----', '-----'
          ELSE
            WRITE (6,*) '%LIST-F-HEADERR, Improper header marker.'
          ENDIF
C
          WRITE (UNT,*) ' '
C
          RETURN
          END
C
C         END OF PRINT_HEADER
C
C****************************************************************************
C
        SUBROUTINE RENAME
C
C       AUTHOR
C         JONATHAN C. BAKER
C       DATE
C         05 JAN 1991
C         19 MAY 1992     JON BAKER
C                         SET UP FOR DATE MODIFIED
C       PURPOSE
C         TO RENAME A USERNAME
C       DESCRIPTION
C         PULL USERNAME FROM DIRECTORY AND REWRITE
C       COMMUNICATIONS
C         CALLS FROM
C           MAIN
C         CALLS TO
C           AUTHINFO
C           CLOSE_INPUT
C           OPEN_INPUT
C           SYSPRIV
C
C       PARAMETERS
C         (NONE)
C       LOCAL GLOSSARY
C         EMPLOYER  : EMPLOYER NAME
C         I         : CONTROL VARIABLE
C         GROUP     : GROUP
C         NUMBER    : PHONE NUMBER
C         PRIV      : LOGICAL FOR PRIV STATUS
C         STATUS    : RETURN VARIABLE
C         THE_DATE  : CURRENT DATE (MODIFIED)
C         UIC       : USER CODE
C         USER1     : USER TO LOOK FOR
C         USER2     : USERNAME CHANGED TO
C         USERNAME  : USER LISTED
C
C       FORMATS
C
  100     FORMAT($,X,'_Enter primary username:  ')
  101     FORMAT($,X,'_Enter new username:  ')
  105     FORMAT(X,'%LIST-I-SUCCREN, User successfully renamed.')
  110     FORMAT(X,'%LIST-E-NOSUCHUSR, No such user in database  ',A)
  111     FORMAT(X,'%LIST-E-EXISTS, User already exists ',
     1           'in database  ',A)
  120     FORMAT(X,'%LIST-E-NOPRIV, Sorry BUB, No privilege ',
     1           'for attempted operation, cannot rename.')
  200     FORMAT(A12)
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
  600     FORMAT(X,'%LIST-E-NOPRIV, Insufficient privileges for ',
     1           'attempted operation.')
C
C       DECLARE VARIABLES
C
        INTEGER       I, STATUS, CLI$GET_VALUE
        CHARACTER*11  THE_DATE
        CHARACTER*12  USER1, USER2, USERNAME
        CHARACTER*14  NUMBER
        CHARACTER*15  GROUP
        CHARACTER*30  EMPLOYER, UIC
        CHARACTER*35  NAME
        LOGICAL       PRIV, SYSPRIV, CLI$PRESENT
C
C       CHECK FOR APPROPRIATE PRIVS
C
        PRIV = SYSPRIV (USER1)
        IF (PRIV) THEN
C
C       GET ORIGINAL USERNAME
C
          STATUS = CLI$GET_VALUE ('P1',USER1)
          DOWHILE (LENGTH (USER1) .EQ. 0) 
            WRITE (6,100)
            READ (6,200) USER1
          ENDDO
          CALL STR$UPCASE (USER1, USER1)
C
C       GET NEW USERNAME
C
          STATUS = CLI$GET_VALUE ('P2',USER2)
          DOWHILE (LENGTH (USER2) .EQ. 0)
            WRITE (6,101)
            READ (6,200) USER2
          ENDDO
          CALL STR$UPCASE (USER2, USER2)

          CALL OPEN_INPUT (.FALSE.)
C
C       CHECK TO SEE IF USER1 EXISTS
C
          I = LENGTH (USER1)
          READ(10,210,KEYID=0,KEY=USER1,ERR=9100) 
     1        USERNAME, NAME, GROUP, NUMBER, THE_DATE, EMPLOYER, UIC
          IF (USER1 .EQ. USERNAME) THEN
C
C       TRY TO WRITE NEW USER
C
            THE_DATE = ' '
            CALL AUTHINFO (USER2, GROUP, UIC)
            WRITE (10,210,ERR=9200) USER2, NAME, GROUP, NUMBER,
     1                              THE_DATE, EMPLOYER, UIC
C
C       DELETE OLD ENTRY
C
            READ(10,210,KEYID=0,KEY=USER1,ERR=9100) 
     1          USERNAME, NAME, GROUP, NUMBER, THE_DATE, EMPLOYER, UIC
            DELETE (10)
            WRITE (6,105)
          ELSE
            WRITE (6,110) USER1
          ENDIF
        ELSE
          IF (CLI$PRESENT('BORING')) THEN
            WRITE (6,600)
          ELSE
            WRITE (6,120)
          ENDIF
        ENDIF

        CALL CLOSE_INPUT
C
C       ERROR BLOCK
C
        IF (.FALSE.) THEN
 9100     WRITE (6,110) USER1
        ENDIF
        IF (.FALSE.) THEN
 9200     WRITE (6,111) USER2
        ENDIF
C
        RETURN
        END
C
C
C       END OF RENAME
C
C*************************************************************************
C
        LOGICAL FUNCTION SYSPRIV (USRNAME)
C
C       AUTHOR
C         JONATHAN C. BAKER
C       DATE 
C         26 NOVEMBER 1990
C       PURPOSE
C         TO CHECK TO SEE IF SYSPRV IS ENABLED
C       DESCRIPTION
C         CALL SYSTEM SERVICES AND USE A MASK TO DIFFERENTIATE
C         IF SYSPRV IS SET
C       COMMUNICATIONS
C         CALLS FROM
C           MAIN
C         CALLS TO
C           (NONE)
C
C       PARAMETERS
C         USRNAME      : CALLER'S USERNAME
C       LOCAL GLOSSARY
C         CHECK        : CONTROL VARIABLE
C         I            : CONTROL VARIABLE
C         PRIV         : SYSPRV MASK
C         PRIVS        : RETURN PRIVELEGE MASK
C         PRIV_LEN     : LENGTH OF PRIVS
C
C
C       INCLUDES
C
        INCLUDE '($PRVDEF)'
        INCLUDE '($JPIDEF)'
C
        STRUCTURE    /ITMLST/
          UNION
            MAP
              INTEGER*2  BUFLEN
              INTEGER*2  ITMCOD
              INTEGER*4  BUFADR
              INTEGER*4  RETADR
            END MAP
            MAP
              INTEGER*4  END_LIST
            END MAP
          END UNION
        END STRUCTURE
C
C       RECORDS
C
        RECORD  /ITMLST/  GETJPI_LIST(3)
C
C       DECLARE VARIABLES
C
        INTEGER*4      SYS$GETJPIW, PRIV_LEN, PRIVS(2), PRIV,
     1                 CHECK, NAME_LEN, I
        CHARACTER*(*)  USRNAME
        CHARACTER*12   NAME
C
C       INITIALIZE VARIABLES
C
        DO 1000 I = 1,LEN(USRNAME)
          USRNAME(I:I) = ' '
 1000   CONTINUE

        PRIV = 2 ** 28
        GETJPI_LIST(1).BUFLEN = 8
        GETJPI_LIST(1).ITMCOD = JPI$_PROCPRIV
        GETJPI_LIST(1).BUFADR = %LOC(PRIVS)
        GETJPI_LIST(1).RETADR = %LOC(PRIV_LEN) 
        GETJPI_LIST(2).BUFLEN = 12
        GETJPI_LIST(2).ITMCOD = JPI$_USERNAME
        GETJPI_LIST(2).BUFADR = %LOC(NAME)
        GETJPI_LIST(2).RETADR = %LOC(NAME_LEN) 

        GETJPI_LIST(3).END_LIST = 0
C
        STATUS = SYS$GETJPIW(,,,GETJPI_LIST,,,)

        USRNAME = NAME
C
C       USE MASK
C
        CHECK = (PRIVS(1) .OR. PRIV)
        IF (CHECK .EQ. PRIVS(1)) THEN
          SYSPRIV = .TRUE.
        ELSE
          SYSPRIV = .FALSE.
        ENDIF
C
        RETURN
        END
C
C       END OF SYSPRIV
C
C**********************************************************************
C
         SUBROUTINE OPEN_SYSUAF (UNT)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          12 MAY 1997
C        PURPOSE
C          OPEN PROPER SYSUAF.DAT FILE
C        DESCRIPTION
C          CHECK /SYSUAF QUALIFIER, IF NOT THERE, TRY SYSUAF LOGICAL,
C          AND AS LAST RESORT TRY SYS$SYSTEM:SYSUAF.DAT
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            NONE
C
C        PARAMETERS
C            UNT          : UNIT NUMBER TO OPEN
C        LOCAL GLOSSARY
C            IOST         : STATUS OF OPEN
C            STATUS       : CALL STATUS VARIABLE
C            SYSLEN       : LENGTH OF SYSUAF_FILE
C            SYSUAF_FILE  : FILE TO OPEN
C
C        INCLUDE
C
         INCLUDE '($LNMDEF)'
C
C        STRUCTURE
C
         STRUCTURE    /TRNLNM_ITEM/
           UNION
             MAP
               INTEGER*2      BUFLEN, ITEM_CODE
               INTEGER*4      BUFADR, RETLEN
             END MAP
             MAP
               INTEGER*4      END_LIST
             END MAP
           END UNION
         END STRUCTURE

         RECORD  /TRNLNM_ITEM/  TRANSLOG(2)
C
C        DECLARE VARIABLES
C
         INTEGER*4        STATUS, CLI$GET_VALUE, SYSLEN, IOST, UNT,
     1                    SYS$TRNLNM
         CHARACTER*255    SYSUAF_FILE
C         LOGICAL          CLI$PRESENT
C
C        COMMON
C
         COMMON /SYSUAF_INFO/ SYSUAF_FILE
C
C        CHECK FOR SYSUAF QUALIFIER
C
C         IF (CLI$PRESENT('SYSUAF')) THEN
C
C           STATUS = CLI$GET_VALUE('SYSUAF',SYSUAF_FILE)
C
C         ELSE
C
C        CHECK OUT SYSUAF LOGICAL
C
           TRANSLOG(1).ITEM_CODE   = LNM$_STRING
           TRANSLOG(1).BUFLEN      = 255
           TRANSLOG(1).BUFADR      = %LOC(SYSUAF_FILE)
           TRANSLOG(1).RETLEN      = %LOC(SYSLEN)
           TRANSLOG(2).END_LIST    = 0
           STATUS = SYS$TRNLNM (,'LNM$SYSTEM_TABLE',
     1                           'SYSUAF',,TRANSLOG)

           IF (.NOT. STATUS) THEN
C
C        USE OLD STAND-BY
C
             SYSUAF_FILE = 'SYS$SYSTEM:SYSUAF.DAT'
           ENDIF
C         ENDIF
C
C        OPEN FILE AS SHARE/READONLY
C
         OPEN (UNIT=UNT,
     1         FILE=SYSUAF_FILE,
     2         STATUS='OLD',
     3         SHARED,READONLY,
     4         ORGANIZATION='INDEXED',
     5         ACCESS='SEQUENTIAL',
     6         ERR=9000,
     7         IOSTAT=IOST)

         RETURN
C
C        ERROR ON OPEN
C
 9000    CALL EXIT (IOST)
         END
C
C        END OF OPEN_SYSUAF
C
C**************************************************************************
C
          SUBROUTINE USER_LIST (UNT, COUNT, USER)
C
C         AUTHOR
C           JONATHAN C. BAKER
C         DATE
C           17 JAN 1991
C           19 MAY 1993       JON BAKER
C                             DISPLAY EMPLOYER AND DATE FIELDS IF /FULL
C         PURPOSE
C           TO PRINT OUT THE LIST BY USER
C         DESCRIPTION
C           PRINT ACCORDING TO USER KEY
C         COMMUNICATIONS
C           CALLS BY
C             MAIN
C             CROSS_CHECK
C           CALLS TO
C             DISPLAY_PLAN
C             PRINT_HEADER
C             LENGTH
C
C         PARAMETERS
C           COUNT   : COUNT OF USERS DISPLAYED
C           USER    : NAME OF USER TO SEARCH FOR
C           UNT     : UNIT NUMBER FOR PRINTING  
C         LOCAL GLOSSARY
C           DISABLED: ACCOUNT HAS BEEN DISABLED
C           EMPLOYER: EMPLOYER NAME
C           I       : CONTROL VARIABLE
C           GROUP   : GROUP FROM LIST
C           NAME    : NAME FROM LIST
C           PHONE   : PHONE FROM LIST
C           PLAN$LENGTH
C                   : NUMERICAL LOGPLAN
C           THE_DATE: DATE RECORD MODIFIED/ADDED
C           UIC     : USER CODE
C           USERNAME: USERNAME FROM LIST
C           
C
C         FORMATS
C
  100     FORMAT(X,A12,3X,A30,3X,A15,2X,A13)
  120     FORMAT(X,'%LIST-I-NOTTHERE, User does not exist',
     1           ' in LIST - ',A)
  121     FORMAT(10X,'EMP: ',A30,4X,'(last mod): ',A11)
  122     FORMAT(10X,'UIC: ',A30,4X,'(disabled): ',A)
  130     FORMAT(X,'%LIST-I-NOLIST, Phone listing is empty. ')
  210     FORMAT(X,A12,3X,A30,3X,A15,3X,A13,3X,A11,3X,A30,3X,A30)
C
C         DECLARE VARIABLES
C
          INTEGER       COUNT, UNT, I
          INTEGER*4     PLAN$LENGTH
          CHARACTER*11  THE_DATE, DISABLED
          CHARACTER*12  USER, USERNAME
          CHARACTER*14  PHONE
          CHARACTER*15  GROUP
          CHARACTER*30  NAME, EMPLOYER, UIC
          LOGICAL       CLI$PRESENT, DISABLE_CHECK
C
C         COMMON BLOCK
C
          COMMON /PLAN/ PLAN$LENGTH
C
C         INITIALIZE VARIABLES
C
          COUNT = 0
C
C         OPEN INPUT FILE
C
          CALL OPEN_INPUT (.TRUE.)
C
C         FIND KEY IN PHONE BOOK
C
          IF (USER(1:1) .EQ. '*') THEN
C
C         LIST ALL USERS
C
            READ (10,210,END=9020) USERNAME, NAME, GROUP, PHONE,
     1                             THE_DATE, EMPLOYER, UIC
            CALL PRINT_HEADER ('U', UNT)
            DOWHILE (.TRUE.)
              COUNT = COUNT + 1
              WRITE(UNT,100) USERNAME, NAME, GROUP, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USERNAME)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USERNAME, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ (10,210,END=9010) USERNAME, NAME, GROUP, PHONE,
     1                             THE_DATE, EMPLOYER, UIC
            ENDDO
          ELSE
C
C         LIST ON SPECIFIC USER KEY
C
            I = LENGTH (USER)
            READ(10,210,KEY=USER(1:I),KEYID=0,ERR=9000) USERNAME, 
     1          NAME, GROUP, PHONE, THE_DATE, EMPLOYER, UIC

            CALL PRINT_HEADER ('U', UNT)
C
C         LOOP WHILE KEY FITS
C
            DOWHILE (USER(1:I) .EQ. USERNAME(1:I))
              COUNT = COUNT + 1
              WRITE (UNT,100) USERNAME, NAME, GROUP, PHONE
              IF (CLI$PRESENT('FULL')) THEN
                IF (DISABLE_CHECK (USERNAME)) THEN
                  DISABLED = 'Yes'
                ELSE
                  DISABLED = 'No'
                ENDIF
                WRITE (UNT,121) EMPLOYER, THE_DATE
                WRITE (UNT,122) UIC, DISABLED
                IF (PLAN$LENGTH .GT. 0) THEN
                  CALL DISPLAY_PLAN (USERNAME, UNT)
                ENDIF
                WRITE (UNT,*) ' '
              ENDIF
              READ(10,210,END=9010) USERNAME, NAME,
     1            GROUP, PHONE, THE_DATE, EMPLOYER, UIC
            ENDDO
          ENDIF
C
C         USER DOES NOT EXIST
C
           
          IF (.FALSE.) THEN
 9000       WRITE (6,120) USER
          ENDIF
C
C         NO PHONE LIST ENTRIES
C
          IF (.FALSE.) THEN
 9020       WRITE (6,130)
          ENDIF
C
 9010     RETURN
          END
C
C         END OF USER_LIST
C
C********************************************************************
