F       INTEGER*4 FUNCTION OPEN_INDIRECT_FILE(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C + CP DATA DECLARATIONS for OPEN_INDIRECT_FILE  C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local variables  C        INTEGER*4 ILV_STATUS C  C   declare local COMMON's C        LOGICAL*1 LCV_CMDFIL       COMMON /INPUT/ LCV_CMDFIL         INCLUDE 'ETHERMON_PRS.INC' C ( C   declare local symbolic message codes C        EXTERNAL	ETH__ERROPNIND  C  CP BEGIN OPEN_INDIRECT_FILE * CP.  attempt to open indirect command file C =       OPEN(UNIT=1,FILE=CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN), <      +	   STATUS='OLD',DEFAULTFILE='.COM',IOSTAT=ILV_STATUS,8      +	   ACCESS='SEQUENTIAL',FORM='FORMATTED',READONLY) C  CP.  IF file open failed THEN  C        IF(ILV_STATUS.NE.0)THEN  C  CP.  .  return error status  C ( 	OPEN_INDIRECT_FILE=%LOC(ETH__ERROPNIND) C 	 CP.  ELSE  C 
       ELSE C  CP.  .  flag that file is open C  	LCV_CMDFIL=.TRUE. 	OPEN_INDIRECT_FILE=1  C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END OPEN_INDIRECT_FILE  C 	       END >       INTEGER*4 FUNCTION ADD_FILTER(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C # CP DATA DECLARATIONS for ADD_FILTER  C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local variables  C "       INTEGER*4 I, ILV_MSGVEC(0:3) C  C   declare local COMMON's C #       INCLUDE 'ETHERMON_FILTER.INC'         INCLUDE 'ETHERMON_PRS.INC' C ( C   declare local symbolic message codes C =       EXTERNAL	ETH__FLTTBLFUL, ETH__FLTADDENA, ETH__FLTADDDIS  C  CP BEGIN ADD_FILTER / CP.  scan for an empty slot in the filter table  C 	       I=1 +       DO WHILE (I.LE.ICVFLT_NUMFILTERS.AND. '      +		SCVFLT_FILTERS(I).ENABLE .NE.0)  	I=I+1       ENDDO  C , CP.  IF no open slots in existing table THEN C $       IF(I.GT.ICVFLT_NUMFILTERS)THEN C - CP.  .  try to add a new slot on end of table  C & 	ICVFLT_NUMFILTERS=ICVFLT_NUMFILTERS+1 C  CP.  .  IF no room left THEN C / 	IF(ICVFLT_NUMFILTERS.GT.ICPFLT_MAXFILTERS)THEN  C  CP.  .  .  report error  C & 	  ICVFLT_NUMFILTERS=ICPFLT_MAXFILTERS 	  ILV_MSGVEC(0)=1% 	  ILV_MSGVEC(1)=%LOC(ETH__FLTTBLFUL) ! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)  C  CP.  .  ELSE C  	ELSE  C  CP.  .  .  clear out new slot  C  	  I=ICVFLT_NUMFILTERS 	  SCVFLT_FILTERS(I).ENABLE=0  	  SCVFLT_FILTERS(I).PROT_ACT=0  	  SCVFLT_FILTERS(I).SRC_ACT=0 	  SCVFLT_FILTERS(I).DST_ACT=0 C 
 CP.  .  ENDIF  C  	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  IF slot found THEN  C ,       IF(SCVFLT_FILTERS(I).ENABLE .EQ.0)THEN C ) CP.  .  IF protocol number specified THEN  C  	IF(BCVPRS_PRTMOD.NE.0)THEN  C  CP.  .  .  store it  C . 	  SCVFLT_FILTERS(I).W_PROTOCOL=NCVPRS_PROTNUM+ 	  SCVFLT_FILTERS(I).PROT_ACT=BCVPRS_PRTMOD  C 
 CP.  .  ENDIF  C  	ENDIF C ( CP.  .  IF source address specified THEN C  	IF(BCVPRS_SRCMOD.NE.0)THEN  C  CP.  .  .  store it  C 1 	  SCVFLT_FILTERS(I).W_SOURCE(0)=NCVPRS_SRCADR(0) 1 	  SCVFLT_FILTERS(I).W_SOURCE(1)=NCVPRS_SRCADR(1) 1 	  SCVFLT_FILTERS(I).W_SOURCE(2)=NCVPRS_SRCADR(2) * 	  SCVFLT_FILTERS(I).SRC_ACT=BCVPRS_SRCMOD C 
 CP.  .  ENDIF  C  	ENDIF C - CP.  .  IF destination address specified THEN  C  	IF(BCVPRS_DSTMOD.NE.0)THEN  C  CP.  .  .  store it  C 6 	  SCVFLT_FILTERS(I).W_DESTINATION(0)=NCVPRS_DSTADR(0)6 	  SCVFLT_FILTERS(I).W_DESTINATION(1)=NCVPRS_DSTADR(1)6 	  SCVFLT_FILTERS(I).W_DESTINATION(2)=NCVPRS_DSTADR(2)* 	  SCVFLT_FILTERS(I).DST_ACT=BCVPRS_DSTMOD C 
 CP.  .  ENDIF  C  	ENDIF C : CP.  .  mark as enabled or disabled, based on flag setting C ' 	IF(BCVPRS_FLTMOD.EQ.0) BCVPRS_FLTMOD=1 ' 	SCVFLT_FILTERS(I).ENABLE=BCVPRS_FLTMOD  C 3 CP.  .  report entry number of newly created filter  C  	ILV_MSGVEC(0)=3 	IF(BCVPRS_FLTMOD)THEN% 	  ILV_MSGVEC(1)=%LOC(ETH__FLTADDENA)  	ELSE % 	  ILV_MSGVEC(1)=%LOC(ETH__FLTADDDIS)  	ENDIF 	ILV_MSGVEC(2)=1 	ILV_MSGVEC(3)=I 	CALL SYS$PUTMSG(ILV_MSGVEC,,,)  C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        ADD_FILTER=1       RETURN C  CP END ADD_FILTER  C 	       END @       INTEGER*4 FUNCTION CLEAR_FILTER(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C % CP DATA DECLARATIONS for CLEAR_FILTER  C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local variables  C        INTEGER*4 ILV_MSGVEC(0:3)  C  C   declare local COMMON's C #       INCLUDE 'ETHERMON_FILTER.INC'         INCLUDE 'ETHERMON_PRS.INC' C   C   declare local symbolic codes C :       EXTERNAL	ETH__ALLFLTDEL, ETH__INVFLTNUM, ETH__FLTDEL C  CP BEGIN CLEAR_FILTER 3 CP.  IF parameter code says /ALL was specified THEN  C #       IF(%LOC(ILA_PARAM).EQ.-1)THEN  C $ CP.  .  zero the active filter count C  	ICVFLT_NUMFILTERS=0 C  CP.  .  report deletion  C  	ILV_MSGVEC(0)=1# 	ILV_MSGVEC(1)=%LOC(ETH__ALLFLTDEL)  	CALL SYS$PUTMSG(ILV_MSGVEC,,,)  C 	 CP.  ELSE  C 
       ELSE C 8 CP.  .  IF the specified filter number is undefined THEN C  	IF(%LOC(ILA_NUMBER).LE.0.OR. 3      +	   %LOC(ILA_NUMBER).GT.ICVFLT_NUMFILTERS.OR. <      +	   SCVFLT_FILTERS(%LOC(ILA_NUMBER)).ENABLE .EQ.0)THEN C  CP.  .  .  report error  C  	  ILV_MSGVEC(0)=1% 	  ILV_MSGVEC(1)=%LOC(ETH__INVFLTNUM) ! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)  C  CP.  .  ELSE C  	ELSE  C , CP.  .  .  mark filter table entry as unused C , 	  SCVFLT_FILTERS(%LOC(ILA_NUMBER)).ENABLE=0. 	  SCVFLT_FILTERS(%LOC(ILA_NUMBER)).PROT_ACT=0- 	  SCVFLT_FILTERS(%LOC(ILA_NUMBER)).SRC_ACT=0 - 	  SCVFLT_FILTERS(%LOC(ILA_NUMBER)).DST_ACT=0  C  CP.  .  .  report deletion C  	  ILV_MSGVEC(0)=3" 	  ILV_MSGVEC(1)=%LOC(ETH__FLTDEL) 	  ILV_MSGVEC(2)=1! 	  ILV_MSGVEC(3)=%LOC(ILA_NUMBER) ! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)  C : CP.  .  .  IF filter was last filter defined in table THEN C 0 	  IF(%LOC(ILA_NUMBER).EQ.ICVFLT_NUMFILTERS)THEN C I CP.  .  .  .  backwind the filter count until a defined filter is last or  CP			table is empty  C * 	    DO WHILE (ICVFLT_NUMFILTERS.GT.0.AND.=      +		      SCVFLT_FILTERS(ICVFLT_NUMFILTERS).ENABLE .EQ.0) , 	      ICVFLT_NUMFILTERS=ICVFLT_NUMFILTERS-1
 	    ENDDO C  CP.  .  .  ENDIF C  	  ENDIF C 
 CP.  .  ENDIF  C  	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        CLEAR_FILTER=1       RETURN C  CP END CLEAR_FILTER  C 	       END ?       INTEGER*4 FUNCTION CLEAR_FLAGS(ILA_OPTIONS,ILA_STRINGCNT, 1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C $ CP DATA DECLARATIONS for CLEAR_FLAGS C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local variables  C        INTEGER*4 I  C  C   declare local COMMON's C !       INCLUDE 'ETHERMON_ADDR.INC'  C  CP BEGIN CLEAR_FLAGS( CP.  DO for all entries in address table C        DO I=0,ICPADR_MAXADDRS C ? CP.  .  clear IP gateway, multiple IP address, and IP ARP flags  C & 	ICVADR_FLAGS(I)=IAND(ICVADR_FLAGS(I),7      +			     NOT(ICPADR_INETMLTIPA+ICPADR_INETGATEWAY+       +				 ICPADR_IARP)) C 
 CP.  ENDDO C        ENDDO  C  CP.  RETURN  C        CLEAR_FLAGS=1        RETURN C  CP END CLEAR_FLAGS C 	       END >       INTEGER*4 FUNCTION DEFINE_KEY(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C # CP DATA DECLARATIONS for DEFINE_KEY  C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_PRS.INC'        INCLUDE 'ETHERMON_SMG.INC' C  C   declare system procedures  C        INTEGER*4 SMG$ADD_KEY_DEF        EXTERNAL	SMG$ADD_KEY_DEF C  CP BEGIN DEFINE_KEY % CP.  IF an IF_STATE was supplied THEN  C "       IF(NCVPRS_SYMLEN .GT. 0)THEN C ( CP.  .  IF a SET_STATE was supplied THEN C  	IF(NCVPRS_STATELEN .GT. 0)THEN  C  CP.  .  .  do call with both C , 	  DEFINE_KEY=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,.      +				     CCVPRS_KEYNAM(1:NCVPRS_KEYLEN),.      +				     CCVPRS_SYMNAM(1:NCVPRS_SYMLEN),      +				     ICVPRS_NUMBER, 5      +				     CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN), 2      +				     CCVPRS_STATENAM(1:NCVPRS_STATELEN)) C  CP.  .  ELSE C  	ELSE  C ( CP.  .  .  do call with only an IF_STATE C , 	  DEFINE_KEY=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,.      +				     CCVPRS_KEYNAM(1:NCVPRS_KEYLEN),.      +				     CCVPRS_SYMNAM(1:NCVPRS_SYMLEN),      +				     ICVPRS_NUMBER, 5      +				     CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN))  C 
 CP.  .  ENDIF  C  	ENDIF C  CP.  ELSE {no /IF_STATE} C 
       ELSE C ( CP.  .  IF a SET_STATE was supplied THEN C  	IF(NCVPRS_STATELEN .GT. 0)THEN  C ! CP.  .  .  do call with SET_STATE  C , 	  DEFINE_KEY=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,.      +				     CCVPRS_KEYNAM(1:NCVPRS_KEYLEN),,      +				     ,	! take default for IF_STATE      +				     ICVPRS_NUMBER, 5      +				     CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN), 2      +				     CCVPRS_STATENAM(1:NCVPRS_STATELEN)) C  CP.  .  ELSE C  	ELSE  C 0 CP.  .  .  do call with defaults for both states C , 	  DEFINE_KEY=SMG$ADD_KEY_DEF(ICVSMG_KTBLID,.      +				     CCVPRS_KEYNAM(1:NCVPRS_KEYLEN),,      +				     ,	! take default for IF_STATE      +				     ICVPRS_NUMBER, 5      +				     CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN))  C 
 CP.  .  ENDIF  C  	ENDIF C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END DEFINE_KEY  C 	       END >       INTEGER*4 FUNCTION DELETE_KEY(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C # CP DATA DECLARATIONS for DELETE_KEY  C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local COMMON's C         INCLUDE 'ETHERMON_PRS.INC'        INCLUDE 'ETHERMON_SMG.INC' C  C   declare system procedures  C "       INTEGER*4 SMG$DELETE_KEY_DEF!       EXTERNAL	SMG$DELETE_KEY_DEF  C  CP BEGIN DELETE_KEY ! CP.  IF a STATE was supplied THEN  C %        IF(NCVPRS_STATELEN .GT. 0)THEN  C  CP.  .  do call with both  C - 	DELETE_KEY=SMG$DELETE_KEY_DEF(ICVSMG_KTBLID, /      +				      CCVPRS_KEYNAM(1:NCVPRS_KEYLEN), 3      +				      CCVPRS_STATENAM(1:NCVPRS_STATELEN))  C 	 CP.  ELSE  C 
       ELSE C " CP.  .  do call with default state C - 	DELETE_KEY=SMG$DELETE_KEY_DEF(ICVSMG_KTBLID, /      +				      CCVPRS_KEYNAM(1:NCVPRS_KEYLEN),       +				      'DEFAULT') C 
 CP.  ENDIF C        ENDIF  C  CP.  RETURN  C        RETURN C  CP END DELETE_KEY  C 	       END        OPTIONS /CHECK=NOOVERFLOW ;       INTEGER*4 FUNCTION DISPLAY(ILA_OPTIONS,ILA_STRINGCNT, 1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  C   CP DATA DECLARATIONS for DISPLAY C        IMPLICIT NONE  C   C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAM  C  C   declare local COMMON's C D       INTEGER*4 ICVDSP_INTERVAL/4/, QCVDSP_INTERVAL(2)/-40000000,-1/       LOGICAL*1 LCVDSP_EXIT D       COMMON /DISPLAY/ ICVDSP_INTERVAL, QCVDSP_INTERVAL, LCVDSP_EXIT!       INCLUDE 'ETHERMON_ADDR.INC'         INCLUDE 'ETHERMON_DEV.INC'        INCLUDE 'ETHERMON_ETH.INC'"       INCLUDE 'ETHERMON_MANUF.INC'!       INCLUDE 'ETHERMON_PROT.INC'         INCLUDE 'ETHERMON_PRS.INC'        INCLUDE 'ETHERMON_SMG.INC'"       INCLUDE 'ETHERMON_STATS.INC' C ! C   declare system symbolic codes  C !       INCLUDE '($SMGDEF)	/NOLIST'  C  C   declare local variables  C        CHARACTER*8 CLV_SCR '       CHARACTER*18 CLV_DISPLAY_TITLE(5)        CHARACTER*23 CLV_SYSTIM        CHARACTER*120 CLV_LINE)       INTEGER*2 NLV_DSPTTLLEN(5), LN, LN2 0       INTEGER*4 ILV_STATUS, I, J, ILV_CNT, D, B,4      +		IDX(0:ICPADR_MAXADDRS), TIDX, QLV_SYSTIM(2),7      +		QLV_OLDSYSTIM(2), ILV_OLD_C_DBR, ILV_OLD_C_BRC, 4      +		ILV_OLD_C_MBY, ILV_OLD_C_MBL, ILV_OLD_C_BS1,4      +		ILV_OLD_C_BSM, ILV_OLD_C_BID, ILV_OLD_C_OVR,$      +		ILV_OLD_C_LBE, ILV_OLD_C_XBU"       LOGICAL*1 LLV_FIRST, LLV_TXT       REAL*4	RLP_LOG_2%       PARAMETER(RLP_LOG_2=0.69314718)        REAL*8	DLP_LARGENUM %       PARAMETER(DLP_LARGENUM=1.0E+10) 8       REAL*8	DLV_INTERVAL, DLV_AVG_C_DBR, DLV_AVG_C_BRC,4      +		DLV_AVG_C_MBY, DLV_AVG_C_MBL, DLV_AVG_C_BS1,4      +		DLV_AVG_C_BSM, DLV_AVG_C_BID, DLV_AVG_C_OVR,C      +		DLV_AVG_C_LBE, DLV_AVG_C_XBU, DLV_MIN_C_DBR, DLV_MIN_C_BRC, 4      +		DLV_MIN_C_MBY, DLV_MIN_C_MBL, DLV_MIN_C_BS1,4      +		DLV_MIN_C_BSM, DLV_MIN_C_BID, DLV_MIN_C_OVR,C      +		DLV_MIN_C_LBE, DLV_MIN_C_XBU, DLV_MAX_C_DBR, DLV_MAX_C_BRC, 4      +		DLV_MAX_C_MBY, DLV_MAX_C_MBL, DLV_MAX_C_BS1,4      +		DLV_MAX_C_BSM, DLV_MAX_C_BID, DLV_MAX_C_OVR,.      +		DLV_MAX_C_LBE, DLV_MAX_C_XBU, DLV_TEMP        RECORD /SMGDEF/ SLV_PBINFO@       DATA CLV_DISPLAY_TITLE/'TOP DESTINATIONS','TOP PROTOCOLS',?      +		'TOP MESSAGE SIZES','TOP SOURCES','GENERAL STATISTICS'/ (       DATA NLV_DSPTTLLEN/16,13,17,11,18/ C  C   declare local procedures C        LOGICAL*1 PORT_SATURATED5       EXTERNAL	PORT_SATURATED, DISPLAY_EXIT_EXCPTHDLR  C ( C   declare local symbolic message codes C -       EXTERNAL	ETH__SATURATED, ETH__DISPJAMMD  C  C   declare system procedures  C B       INTEGER*4 SMG$CREATE_PASTEBOARD,	SMG$CREATE_VIRTUAL_DISPLAY,9      +		SMG$PASTE_VIRTUAL_DISPLAY,	SMG$DELETE_PASTEBOARD, 2      +		SMG$DELETE_VIRTUAL_DISPLAY,	SMG$PUT_CHARS,>      +		SMG$DRAW_LINE,	SMG$BEGIN_DISPLAY_UPDATE, SMG$SNAPSHOT,A      +		SMG$END_DISPLAY_UPDATE,	SMG$PUT_LINE,	SMG$SET_CURSOR_ABS, %      +		SMG$GET_PASTEBOARD_ATTRIBUTES A       EXTERNAL	SMG$CREATE_PASTEBOARD,	SMG$CREATE_VIRTUAL_DISPLAY, 9      +		SMG$PASTE_VIRTUAL_DISPLAY,	SMG$DELETE_PASTEBOARD, 2      +		SMG$DELETE_VIRTUAL_DISPLAY,	SMG$PUT_CHARS,>      +		SMG$DRAW_LINE,	SMG$BEGIN_DISPLAY_UPDATE, SMG$SNAPSHOT,A      +		SMG$END_DISPLAY_UPDATE,	SMG$PUT_LINE,	SMG$SET_CURSOR_ABS, %      +		SMG$GET_PASTEBOARD_ATTRIBUTES  C  CP BEGIN DISPLAY> CP.  check if port counters are saturated, abort command if so C        IF(PORT_SATURATED(0))THEN  	DISPLAY=%LOC(ETH__SATURATED)  	RETURN        ENDIF  C   CP.  set up the screen with SMG$ C 6       ILV_STATUS=SMG$CREATE_PASTEBOARD(ICVSMG_PASTEID)       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF >       ILV_STATUS=SMG$GET_PASTEBOARD_ATTRIBUTES(ICVSMG_PASTEID,1      +				SLV_PBINFO,SMG$C_PASTEBOARD_INFO_BLOCK)        IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF Q       ICVSMG_ROWS=MIN(MAX(ZEXT(SLV_PBINFO.SMG$B_ROWS),18),40)-1 ! leave space for O       ICVSMG_COLS=MIN(MAX(SLV_PBINFO.SMG$W_WIDTH,65),120)       ! error display G       ILV_STATUS=SMG$CREATE_VIRTUAL_DISPLAY(2,ICVSMG_COLS,ICVSMG_ERRID,        +					    SMG$M_TRUNC_ICON)       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF G       ILV_STATUS=SMG$PASTE_VIRTUAL_DISPLAY(ICVSMG_ERRID,ICVSMG_PASTEID,       +					   ICVSMG_ROWS,1)       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF        LCVSMG_ERRHIDDEN=.TRUE. D       ILV_STATUS=SMG$CREATE_VIRTUAL_DISPLAY(ICVSMG_ROWS,ICVSMG_COLS,      +					    ICVSMG_DSPID)       IF(.NOT.ILV_STATUS)THEN " 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF G       ILV_STATUS=SMG$PASTE_VIRTUAL_DISPLAY(ICVSMG_DSPID,ICVSMG_PASTEID,       +					   1,1)       IF(.NOT.ILV_STATUS)THENE" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIFT CG. CP.  enable control-C and control-Z exit traps CP       LCVDSP_EXIT=.FALSE._0       CALL LIB$ESTABLISH(DISPLAY_EXIT_EXCPTHDLR) C_" CP.  start display setup buffering C 7       ILV_STATUS=SMG$BEGIN_DISPLAY_UPDATE(ICVSMG_DSPID)*       IF(.NOT.ILV_STATUS)THENL" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF  C_+ CP.  fill in background of selected display  Ca,       ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,3      +			       'VAX/VMS Ethernet Monitor Display',C#      +			       1,ICVSMG_COLS/2-15)D       IF(.NOT.ILV_STATUS)THENR" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIFd,       ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,?      +			       'on node '//CCVNAM_SYSNAM(1:NCVNAM_SYSNAMLEN)// 7      +				'  port '//CCVNAM_DEVNAM(1:NCVNAM_DEVNAMLEN),_#      +			       2,ICVSMG_COLS/2-13)'       IF(.NOT.ILV_STATUS)THENS" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIFT,       ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,-      +		CLV_DISPLAY_TITLE(%LOC(ILA_PARAM))(1:P,      +				  NLV_DSPTTLLEN(%LOC(ILA_PARAM))),B      +			       3,(ICVSMG_COLS-NLV_DSPTTLLEN(%LOC(ILA_PARAM)))/2,,       +			       SMG$M_REVERSE,0)       IF(.NOT.ILV_STATUS)THENT" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIFP"       IF(%LOC(ILA_PARAM).GE.1.AND.!      +	 %LOC(ILA_PARAM).LE.4)THEN F 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS-40,7,ICVSMG_COLS) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIFD 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,ICVSMG_ROWS-1,ICVSMG_COLS-40,%      +				 ICVSMG_ROWS-1,ICVSMG_COLS)u 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF8 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS-40,(      +				 ICVSMG_ROWS-1,ICVSMG_COLS-40) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF8 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS-30,(      +				 ICVSMG_ROWS-1,ICVSMG_COLS-30) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF8 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS-20,(      +				 ICVSMG_ROWS-1,ICVSMG_COLS-20) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF8 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS-10,(      +				 ICVSMG_ROWS-1,ICVSMG_COLS-10) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF5 	ILV_STATUS=SMG$DRAW_LINE(ICVSMG_DSPID,7,ICVSMG_COLS,I%      +				 ICVSMG_ROWS-1,ICVSMG_COLS)o 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,U4      +		'0        50       100       150       200',      +				 6,ICVSMG_COLS-40) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF&       ELSEIF(%LOC(ILA_PARAM).EQ.5)THEN 	I=6 	IF(ICVSMG_ROWS.GE.22)THEN 	  J=2 	ELSE= 	  J=1 	ENDIF% 	D=8+MIN(MAX((ICVSMG_COLS-65)/4,1),4)(4 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,'CUR',I,28+D) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF6 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,'AVG',I,28+2*D) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF6 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,'MIN',I,28+3*D) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF6 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,'MAX',I,28+4*D) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+J' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,)      +				 'Packets/second',      +				 I,4)R 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,R      +				 'Kbytes/second',       +				 I,4)P 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,I      +				 'Packet size',C      +				 I,4)  	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+J' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,I&      +				 'Multicast packets/second',      +				 I,4)E 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,L%      +				 'Multicast kbytes/second',       +				 I,4)t 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID, #      +				 'Multicast packet size',T      +				 I,4)  	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+J' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID, $      +				 'Trans Single Collision',      +				 I,4)L 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,N&      +				 'Trans Multiple Collision',      +				 I,4)  	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,N&      +				 'Trans Initially Deferred',      +				 I,4)K 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+J' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,_#      +				 'Internal Buffer Error',O      +				 I,4)  	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,L       +				 'Local Buffer Error',      +				 I,4)P 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF 	I=I+1' 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,        +				 'Buffer Unavailable',      +				 I,4)U 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF       ENDIFT CA  CP.  end display setup buffering CE5       ILV_STATUS=SMG$END_DISPLAY_UPDATE(ICVSMG_DSPID)t       IF(.NOT.ILV_STATUS)THENn" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF -       ILV_STATUS=SMG$SNAPSHOT(ICVSMG_PASTEID).       IF(.NOT.ILV_STATUS)THEN%" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF  CpB CP.  store the data processing mode for the Ethernet read routines CM%       CALL GET_PORT_COUNTERS(.FALSE.)        LLV_FIRST=.TRUE.       ICVSTT_BUFNUM=0r       ICVSTT_MSGS_S_PRE(0)=0       ICVSTT_MSGS_S_POST(0)=0A       ICVSTT_BYTES_S_PRE(0)=0I       ICVSTT_BYTES_S_POST(0)=0        ILV_OLD_C_DBR=ICVETH_C_DBR        ILV_OLD_C_BRC=ICVETH_C_BRC        ILV_OLD_C_MBL=ICVETH_C_MBL        ILV_OLD_C_MBY=ICVETH_C_MBY        ILV_OLD_C_BS1=ICVETH_C_BS1        ILV_OLD_C_BSM=ICVETH_C_BSM        ILV_OLD_C_BID=ICVETH_C_BID&       ILV_OLD_C_OVR=ZEXT(NCVETH_C_OVR)&       ILV_OLD_C_LBE=ZEXT(NCVETH_C_LBE)9       ILV_OLD_C_XBU=ZEXT(NCVETH_C_SBU)+ZEXT(NCVETH_C_UBU).        DLV_MIN_C_DBR=DLP_LARGENUM        DLV_MIN_C_BRC=DLP_LARGENUM        DLV_MIN_C_MBL=DLP_LARGENUM        DLV_MIN_C_MBY=DLP_LARGENUM        DLV_MIN_C_BS1=DLP_LARGENUM        DLV_MIN_C_BSM=DLP_LARGENUM        DLV_MIN_C_BID=DLP_LARGENUM        DLV_MIN_C_OVR=DLP_LARGENUM        DLV_MIN_C_LBE=DLP_LARGENUM        DLV_MIN_C_XBU=DLP_LARGENUM       DLV_MAX_C_DBR=0        DLV_MAX_C_BRC=0        DLV_MAX_C_MBL=0R       DLV_MAX_C_MBY=0T       DLV_MAX_C_BS1=0        DLV_MAX_C_BSM=0        DLV_MAX_C_BID=0E       DLV_MAX_C_OVR=0A       DLV_MAX_C_LBE=0N       DLV_MAX_C_XBU=0R$       CALL SYS$GETTIM(QLV_OLDSYSTIM)(       IF(IAND(ICVPRS_NUMBER,2).NE.0)THEN$ 	ICVETH_DISPLAYMODE=-%LOC(ILA_PARAM)
       ELSE# 	ICVETH_DISPLAYMODE=%LOC(ILA_PARAM)u       ENDIFs C % CP.  start the display interval timerN CT8       CALL SYS$SCHDWK(,,QCVDSP_INTERVAL,QCVDSP_INTERVAL) CR CP.  REPEAT  C_!       DO WHILE (.NOT.LCVDSP_EXIT)b C  CP.  .  wait for timer timeout Ce 	CALL SYS$HIBERN C  CP.  .  switch buffer flag CR 	B=ICVSTT_BUFNUM 	ICVSTT_BUFNUM=1-ICVSTT_BUFNUM Cr CP.  .  get current counters CO  	CALL GET_PORT_COUNTERS(.FALSE.) Ca CP.  .  get current system time, Cd 	CALL SYS$GETTIM(QLV_SYSTIM) C( CP.  .  start display buffering	 C 2 	ILV_STATUS=SMG$BEGIN_DISPLAY_UPDATE(ICVSMG_DSPID) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF C  CP.  .  display clock on screenN C ) 	CALL SYS$ASCTIM(,CLV_SYSTIM,QLV_SYSTIM,) 6 	CALL LIB$SUBX(QLV_SYSTIM,QLV_OLDSYSTIM,QLV_OLDSYSTIM) 	IF(QLV_OLDSYSTIM(2).NE.0)THEN" 	  CALL LIB$SIGNAL(ETH__DISPJAMMD) 	ENDIF1 	DLV_INTERVAL=MAX(QLV_OLDSYSTIM(1)*1.0D-7,0.01D0)FC 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_SYSTIM,3,ICVSMG_COLS-22)n 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF CNE CP.  .  calculate message loss factor & total bandwidth consumed and e CP			display it on screen  C & 	CLV_LINE(1:20)='xxx.xx% message loss'< 	CALL FOR$CVT_D_TF(DFLOAT(100*((ICVETH_C_DBR-ILV_OLD_C_DBR)-#      +						ICVSTT_MSGS_S_PRE(B)))/ 4      +				DFLOAT(MAX(ICVETH_C_DBR-ILV_OLD_C_DBR,1)),!      +			  CLV_LINE(1:6),%VAL(2))E: 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:20),4,1) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF( 	CLV_LINE(1:22)='xxx.xx% bandwidth used'6 	CALL FOR$CVT_D_TF(DFLOAT((ICVETH_C_BRC-ILV_OLD_C_BRC+2      +				  ((ICVETH_C_DBR-ILV_OLD_C_DBR)*38))*8)/,      +				(DCVETH_SPEED*DLV_INTERVAL/100.0),!      +			  CLV_LINE(1:6),%VAL(2))I: 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:22),5,1) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF Cl= CP.  .  write pre-filter and post-filter statistics to screenG CBB 	CALL SYS$FAO('    pre-filter:!6UL bytes/sec!6UL msg/sec xx.xx%',,E      +		     CLV_LINE,%VAL(NINT(ICVSTT_BYTES_S_PRE(B)/DLV_INTERVAL)),+;      +		     %VAL(NINT(ICVSTT_MSGS_S_PRE(B)/DLV_INTERVAL))) 1 	CALL FOR$CVT_D_TF(DFLOAT((ICVSTT_BYTES_S_PRE(B)+ *      +				  (ICVSTT_MSGS_S_PRE(B)*38))*8)/,      +				(DCVETH_SPEED*DLV_INTERVAL/100.0),#      +			  CLV_LINE(47:51),%VAL(2))E/ 	IF(ICVETH_DISPLAYMODE.LT.0) CLV_LINE(1:2)='->'GG 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:52),4,ICVSMG_COLS-51), 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIFB 	CALL SYS$FAO('   post-filter:!6UL bytes/sec!6UL msg/sec xx.xx%',,F      +		     CLV_LINE,%VAL(NINT(ICVSTT_BYTES_S_POST(B)/DLV_INTERVAL)),<      +		     %VAL(NINT(ICVSTT_MSGS_S_POST(B)/DLV_INTERVAL)))2 	CALL FOR$CVT_D_TF(DFLOAT((ICVSTT_BYTES_S_POST(B)++      +				  (ICVSTT_MSGS_S_POST(B)*38))*8)/t,      +				(DCVETH_SPEED*DLV_INTERVAL/100.0),#      +			  CLV_LINE(47:51),%VAL(2))E/ 	IF(ICVETH_DISPLAYMODE.GT.0) CLV_LINE(1:2)='->' G 	ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:52),5,ICVSMG_COLS-51)  	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF CL  CP.  .  DO CASE (displaymode) OF C ? 	GOTO (1000,2000,3000,1000,5000,6000), IABS(ICVETH_DISPLAYMODE)A CL. CP.  .  CASE 1 or 4 (destinations or sources): CD  1000	CONTINUE C M CP.  .  .  sort the address statistics by descending size (indexed shellsort)_ CI
 	  ILV_CNT=-1C 	  DO I=0,ICPADR_MAXADDRSN 	    IF(ICVADR_FLAGS(I).AND.+      +	       ICVADR_ADDRCNT(I,B).NE.0)THENr 	      ILV_CNT=ILV_CNT+1 	      IDX(ILV_CNT)=I.
 	    ENDIF 	  ENDDO3 	  D=(2**INT(LOG(FLOAT(MAX(ILV_CNT,1)))/RLP_LOG_2))  	  DO WHILE (D.GT.0) 	    DO I=0,ILV_CNT-D E 	      IF(ICVADR_ADDRCNT(IDX(I),B).LT.ICVADR_ADDRCNT(IDX(I+D),B))THEN  		TIDX=IDX(I+D)  		IDX(I+D)=IDX(I)P 		IF(I.GT.D)THEN	 		  J=I-D  		  DO WHILE (J.GE.0.AND. '      +			    ICVADR_ADDRCNT(TIDX,B).GT._$      +					ICVADR_ADDRCNT(IDX(J),B)) 		    IDX(J+D)=IDX(J)  		    J=J-D 	 		  ENDDOE 		  IDX(J+D)=TIDXE 		ELSE 		  IDX(I)=TIDX  		ENDIFE 	      ENDIF
 	    ENDDO
 	    D=D/2 	  ENDDO CT& CP.  .  .  position in virtual display C 2 	  ILV_STATUS=SMG$SET_CURSOR_ABS(ICVSMG_DSPID,8,1) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF C J CP.  .  .  DO for top N addresses (or as many as found, whichever smaller) CF 	  D=0% 	  DO WHILE (D.LT.ICVSMG_ROWS-10.AND.O*      +		    ICVADR_ADDRCNT(IDX(D),B).GT.0)
 	    D=D+1 	  ENDDO
 	  DO I=0,D-1I CC6 CP.  .  .  .  format line for display and write to SMG CS
 	    J=IDX(I)  	    CLV_LINE=' ' 	 	    LN=0  	    LN2=ICVSMG_COLS-63  	    LLV_TXT=.FALSE. 	    TIDX=1R+ 	    DO WHILE (TIDX.LE.ICVMNF_NUMNAMES.AND.	7      +		      IAND(SCVADR_ADDR(J).LNUM,'00FFFFFE'X).NE.e"      +					ICVMNF_MANUF_NUM(TIDX)) 	      TIDX=TIDX+1
 	    ENDDO% 	    IF(NCVMNF_NAMLEN(TIDX).GT.0)THENAC 	      CLV_LINE(1:LN2)=CCVMNF_NAM(TIDX)(1:NCVMNF_NAMLEN(TIDX))//':'R( 	      LN=MIN(NCVMNF_NAMLEN(TIDX)+1,LN2)
 	    ENDIF 	    IF(LN.LT.LN2.AND..      +	       NCVADR_DECNETNAMLEN(J).NE.0)THEN0 	      CLV_LINE(LN+1:LN2)=CCVADR_DECNETNAM(J)(1:!      +				NCVADR_DECNETNAMLEN(J))H, 	      LN=MIN(LN+NCVADR_DECNETNAMLEN(J),LN2) 	      LLV_TXT=.TRUE.R
 	    ENDIF 	    IF(LN.LT.LN2-1.AND.,      +	       NCVADR_INETNAMLEN(J).NE.0)THEN 	      IF(LLV_TXT)THEN	 		LN=LN+1a 		CLV_LINE(LN:LN)=','R 	      ENDIFC 	      CLV_LINE(LN+1:LN2)=CCVADR_INETNAM(J)(1:NCVADR_INETNAMLEN(J))S* 	      LN=MIN(LN+NCVADR_INETNAMLEN(J),LN2) 	      LLV_TXT=.TRUE.(
 	    ENDIF 	    IF(LN.LT.LN2-1.AND.,      +	       NCVADR_MISCNAMLEN(J).NE.0)THEN 	      IF(LLV_TXT)THEN	 		LN=LN+1  		CLV_LINE(LN:LN)=','  	      ENDIFC 	      CLV_LINE(LN+1:LN2)=CCVADR_MISCNAM(J)(1:NCVADR_MISCNAMLEN(J)),* 	      LN=MIN(LN+NCVADR_MISCNAMLEN(J),LN2)
 	    ENDIF; 	    CALL OTS$CVT_L_TZ(SCVADR_ADDR(J).LNUM,CLV_SCR,%VAL(8))S@ 	    CLV_LINE(ICVSMG_COLS-61:ICVSMG_COLS-51)=CLV_SCR(7:8)//'-'//;      +			CLV_SCR(5:6)//'-'//CLV_SCR(3:4)//'-'//CLV_SCR(1:2)G: 	    CALL OTS$CVT_L_TZ(SCVADR_ADDR(J).NUM(2),CLV_SCR(1:4),      +			      %VAL(4),%VAL(2))B@ 	    CLV_LINE(ICVSMG_COLS-50:ICVSMG_COLS-45)='-'//CLV_SCR(3:4)//      +					'-'//CLV_SCR(1:2)> 	    CALL OTS$CVT_L_TI(NINT(ICVADR_ADDRCNT(J,B)/DLV_INTERVAL),?      +			      CLV_LINE(ICVSMG_COLS-44:ICVSMG_COLS-41),%VAL(1))I2 	    CALL STR$DUPL_CHAR(CLV_LINE(ICVSMG_COLS-39:),=      +		MIN(NINT((ICVADR_ADDRCNT(J,B)+4)/DLV_INTERVAL)/5,39),+      +			       %REF('*'))D 	    ILV_STATUS=SMG$PUT_LINE(ICVSMG_DSPID,CLV_LINE(1:ICVSMG_COLS),1) 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF C  CP.  .  .  ENDDO CT 	  ENDDO CT; CP.  .  .  clear remaining lines of plot (if < N addresses)S CC 	  DO I=D,ICVSMG_ROWS-100 	    ILV_STATUS=SMG$PUT_LINE(ICVSMG_DSPID,' ',1) 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF 	  ENDDO 	  GOTO 9999 CP CP.  .  CASE 2 (protocols):  Cb  2000	CONTINUE C N CP.  .  .  sort the protocol statistics by descending size (indexed shellsort) Ce 	  ILV_CNT=0 	  DO I=1,ICVPRT_NUMNAMESO% 	    IF(ICVSTT_PROTCNT(I,B).NE.0)THEN+ 	      ILV_CNT=ILV_CNT+1 	      IDX(ILV_CNT)=ID
 	    ENDIF 	  ENDDO5 	  D=(2**INT(LOG(FLOAT(MAX(ILV_CNT-1,1)))/RLP_LOG_2)), 	  DO WHILE (D.GT.0) 	    DO I=1,ILV_CNT-D E 	      IF(ICVSTT_PROTCNT(IDX(I),B).LT.ICVSTT_PROTCNT(IDX(I+D),B))THEN	 		TIDX=IDX(I+D)D 		IDX(I+D)=IDX(I)  		IF(I.GT.D)THEN	 		  J=I-DD 		  DO WHILE (J.GE.1.AND.Y'      +			    ICVSTT_PROTCNT(TIDX,B).GT.G$      +					ICVSTT_PROTCNT(IDX(J),B)) 		    IDX(J+D)=IDX(J)$ 		    J=J-D 	 		  ENDDOR 		  IDX(J+D)=TIDXD 		ELSE 		  IDX(I)=TIDXO 		ENDIF+ 	      ENDIF
 	    ENDDO
 	    D=D/2 	  ENDDO CS& CP.  .  .  position in virtual display CU2 	  ILV_STATUS=SMG$SET_CURSOR_ABS(ICVSMG_DSPID,8,1) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF CSJ CP.  .  .  DO for top N protocols (or as many as found, whichever smaller) Cw 	  D=1) 	  DO WHILE (D.LT.(ICVSMG_ROWS-10)/2.AND.D*      +		    ICVSTT_PROTCNT(IDX(D),B).GT.0)
 	    D=D+1 	  ENDDO
 	  DO I=1,D-1S C 6 CP.  .  .  .  format line for display and write to SMG CS 	    CLV_LINE=' ' 9 	    CLV_LINE(2:ICVSMG_COLS-53)=CCVPRT_PROTNAM(IDX(I))(1:.$      +				NCVPRT_PROTNAMLEN(IDX(I)))/ 	    CALL OTS$CVT_L_TZ(NCVPRT_PROT_NUM(IDX(I)),W,      +			      CLV_SCR(1:4),%VAL(4),%VAL(2))@ 	    CLV_LINE(ICVSMG_COLS-51:ICVSMG_COLS-47)=CLV_SCR(3:4)//'-'//      +				CLV_SCR(1:2)% 	    IF(LCVPRT_PROT_IEEE(IDX(I)))THENT2 	      CLV_LINE(ICVSMG_COLS-46:ICVSMG_COLS-46)='i'
 	    ENDIFC 	    CALL OTS$CVT_L_TI(NINT(ICVSTT_PROTCNT(IDX(I),B)/DLV_INTERVAL),A?      +			      CLV_LINE(ICVSMG_COLS-45:ICVSMG_COLS-41),%VAL(1))D2 	    CALL STR$DUPL_CHAR(CLV_LINE(ICVSMG_COLS-39:),B      +		MIN(NINT((ICVSTT_PROTCNT(IDX(I),B)+4)/DLV_INTERVAL)/5,39),      +			       %REF('*'))D 	    ILV_STATUS=SMG$PUT_LINE(ICVSMG_DSPID,CLV_LINE(1:ICVSMG_COLS),2) 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF CS CP.  .  .  ENDDO CN 	  ENDDO CT; CP.  .  .  clear remaining lines of plot (if < N protocols)L CI 	  DO I=D,(ICVSMG_ROWS-10)/20 	    ILV_STATUS=SMG$PUT_LINE(ICVSMG_DSPID,' ',2) 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF 	  ENDDO 	  GOTO 9999 C  CP.  .  CASE 3 (sizes):  C   3000	CONTINUE CD& CP.  .  .  position in virtual display Cl2 	  ILV_STATUS=SMG$SET_CURSOR_ABS(ICVSMG_DSPID,8,1) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF CA& CP.  .  .  DO for all cell size ranges C  	  DO I=0,14 Cs6 CP.  .  .  .  format line for display and write to SMG C_ 	    CLV_LINE=' ' G 	    CALL SYS$FAO('!UL - !UL',,CLV_LINE(ICVSMG_COLS-58:ICVSMG_COLS-48),-(      +			 %VAL(I*100+1),%VAL((I+1)*100))> 	    CALL OTS$CVT_L_TI(NINT(ICVSTT_SIZECNT(I,B)/DLV_INTERVAL),?      +			      CLV_LINE(ICVSMG_COLS-46:ICVSMG_COLS-42),%VAL(1))S2 	    CALL STR$DUPL_CHAR(CLV_LINE(ICVSMG_COLS-39:),=      +		MIN(NINT((ICVSTT_SIZECNT(I,B)+4)/DLV_INTERVAL)/5,39),/      +			       %REF('*'))5 	    ILV_STATUS=SMG$PUT_LINE(ICVSMG_DSPID,CLV_LINE,1)N 	    IF(.NOT.ILV_STATUS)THEN( 	      CALL LIB$SIGNAL(%VAL(ILV_STATUS))
 	    ENDIF CP CP.  .  .  ENDDO C	 	  ENDDO 	  GOTO 9999 CR$ CP.  .  CASE 5 (general statistics): CV  5000	CONTINUE C_% CP.  .  .  display current statisticsE C,G 	  IF(ICVETH_C_DBR.LT.ILV_OLD_C_DBR) GOTO 9999	! someone zeroed counter  	  I=6 	  IF(ICVSMG_ROWS.GE.22)THEN 	    J=2 	  ELSEL 	    J=1 	  ENDIF' 	  D=8+MIN(MAX((ICVSMG_COLS-65)/4,1),4)P; 	  DLV_TEMP=DFLOAT(ICVETH_C_DBR-ILV_OLD_C_DBR)/DLV_INTERVAL 1 	  DLV_AVG_C_DBR=0.9*DLV_AVG_C_DBR + 0.1*DLV_TEMPS& 	  IF(LLV_FIRST)DLV_AVG_C_DBR=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_DBR) DLV_MAX_C_DBR=DLV_TEMPO7 	  IF(DLV_TEMP.LT.DLV_MIN_C_DBR) DLV_MIN_C_DBR=DLV_TEMPL 	  IF(ICVETH_C_DBR.NE.-1)THEN=6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEO 	    CLV_LINE(1:9)='------.--' 	  ENDIF 	  I=I+J> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_DBR,CLV_LINE(1:9),%VAL(2))S@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_DBR,CLV_LINE(1:9),%VAL(2))W@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_DBR,CLV_LINE(1:9),%VAL(2))S@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1/ 	  DLV_TEMP=DFLOAT(ICVETH_C_BRC-ILV_OLD_C_BRC)/       +			(1024.D0*DLV_INTERVAL)41 	  DLV_AVG_C_BRC=0.9*DLV_AVG_C_BRC + 0.1*DLV_TEMPA& 	  IF(LLV_FIRST)DLV_AVG_C_BRC=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_BRC) DLV_MAX_C_BRC=DLV_TEMP 7 	  IF(DLV_TEMP.LT.DLV_MIN_C_BRC) DLV_MIN_C_BRC=DLV_TEMP- 	  IF(ICVETH_C_BRC.NE.-1)THENU6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEC 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_BRC,CLV_LINE(1:9),%VAL(2))U@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_BRC,CLV_LINE(1:9),%VAL(2))M@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_BRC,CLV_LINE(1:9),%VAL(2))+@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+18 	  CALL FOR$CVT_D_TF(DFLOAT(ICVETH_C_BRC-ILV_OLD_C_BRC)/7      +			    DFLOAT(MAX(ICVETH_C_DBR-ILV_OLD_C_DBR,1)),S!      +			  CLV_LINE(1:9),%VAL(2))$> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+J; 	  DLV_TEMP=DFLOAT(ICVETH_C_MBL-ILV_OLD_C_MBL)/DLV_INTERVAL	1 	  DLV_AVG_C_MBL=0.9*DLV_AVG_C_MBL + 0.1*DLV_TEMPI& 	  IF(LLV_FIRST)DLV_AVG_C_MBL=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_MBL) DLV_MAX_C_MBL=DLV_TEMP_7 	  IF(DLV_TEMP.LT.DLV_MIN_C_MBL) DLV_MIN_C_MBL=DLV_TEMPT 	  IF(ICVETH_C_MBL.NE.-1)THENV6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEJ 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_MBL,CLV_LINE(1:9),%VAL(2))t@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_MBL,CLV_LINE(1:9),%VAL(2))+@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_MBL,CLV_LINE(1:9),%VAL(2))S@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1/ 	  DLV_TEMP=DFLOAT(ICVETH_C_MBY-ILV_OLD_C_MBY)/L!      +					(1024.D0*DLV_INTERVAL) 1 	  DLV_AVG_C_MBY=0.9*DLV_AVG_C_MBY + 0.1*DLV_TEMP	& 	  IF(LLV_FIRST)DLV_AVG_C_MBY=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_MBY) DLV_MAX_C_MBY=DLV_TEMPT7 	  IF(DLV_TEMP.LT.DLV_MIN_C_MBY) DLV_MIN_C_MBY=DLV_TEMPb 	  IF(ICVETH_C_MBY.NE.-1)THENS6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEE 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_MBY,CLV_LINE(1:9),%VAL(2))a@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_MBY,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_MBY,CLV_LINE(1:9),%VAL(2))L@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+18 	  CALL FOR$CVT_D_TF(DFLOAT(ICVETH_C_MBY-ILV_OLD_C_MBY)/7      +			    DFLOAT(MAX(ICVETH_C_MBL-ILV_OLD_C_MBL,1)), !      +			  CLV_LINE(1:9),%VAL(2)) > 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+J; 	  DLV_TEMP=DFLOAT(ICVETH_C_BS1-ILV_OLD_C_BS1)/DLV_INTERVAL_1 	  DLV_AVG_C_BS1=0.9*DLV_AVG_C_BS1 + 0.1*DLV_TEMPL& 	  IF(LLV_FIRST)DLV_AVG_C_BS1=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_BS1) DLV_MAX_C_BS1=DLV_TEMP_7 	  IF(DLV_TEMP.LT.DLV_MIN_C_BS1) DLV_MIN_C_BS1=DLV_TEMP= 	  IF(ICVETH_C_BS1.NE.-1)THEN 6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEF 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_BS1,CLV_LINE(1:9),%VAL(2))R@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_BS1,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_BS1,CLV_LINE(1:9),%VAL(2))_@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1; 	  DLV_TEMP=DFLOAT(ICVETH_C_BSM-ILV_OLD_C_BSM)/DLV_INTERVALL1 	  DLV_AVG_C_BSM=0.9*DLV_AVG_C_BSM + 0.1*DLV_TEMP.& 	  IF(LLV_FIRST)DLV_AVG_C_BSM=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_BSM) DLV_MAX_C_BSM=DLV_TEMP17 	  IF(DLV_TEMP.LT.DLV_MIN_C_BSM) DLV_MIN_C_BSM=DLV_TEMP, 	  IF(ICVETH_C_BSM.NE.-1)THENS6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSE  	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_BSM,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_BSM,CLV_LINE(1:9),%VAL(2))T@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_BSM,CLV_LINE(1:9),%VAL(2))0@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1; 	  DLV_TEMP=DFLOAT(ICVETH_C_BID-ILV_OLD_C_BID)/DLV_INTERVALt1 	  DLV_AVG_C_BID=0.9*DLV_AVG_C_BID + 0.1*DLV_TEMPe& 	  IF(LLV_FIRST)DLV_AVG_C_BID=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_BID) DLV_MAX_C_BID=DLV_TEMPB7 	  IF(DLV_TEMP.LT.DLV_MIN_C_BID) DLV_MIN_C_BID=DLV_TEMPP 	  IF(ICVETH_C_BID.NE.-1)THENO6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSES 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_BID,CLV_LINE(1:9),%VAL(2))S@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_BID,CLV_LINE(1:9),%VAL(2))+@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_BID,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+JB 	  DLV_TEMP=DFLOAT(JZEXT(NCVETH_C_OVR)-ILV_OLD_C_OVR)/DLV_INTERVAL1 	  DLV_AVG_C_OVR=0.9*DLV_AVG_C_OVR + 0.1*DLV_TEMPG& 	  IF(LLV_FIRST)DLV_AVG_C_OVR=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_OVR) DLV_MAX_C_OVR=DLV_TEMPi7 	  IF(DLV_TEMP.LT.DLV_MIN_C_OVR) DLV_MIN_C_OVR=DLV_TEMP  	  IF(NCVETH_C_OVR.NE.-1)THENn6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEA 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_OVR,CLV_LINE(1:9),%VAL(2))D@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_OVR,CLV_LINE(1:9),%VAL(2))D@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_OVR,CLV_LINE(1:9),%VAL(2))2@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1B 	  DLV_TEMP=DFLOAT(JZEXT(NCVETH_C_LBE)-ILV_OLD_C_LBE)/DLV_INTERVAL1 	  DLV_AVG_C_LBE=0.9*DLV_AVG_C_LBE + 0.1*DLV_TEMP & 	  IF(LLV_FIRST)DLV_AVG_C_LBE=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_LBE) DLV_MAX_C_LBE=DLV_TEMPD7 	  IF(DLV_TEMP.LT.DLV_MIN_C_LBE) DLV_MIN_C_LBE=DLV_TEMPl 	  IF(NCVETH_C_LBE.NE.-1)THENG6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEV 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_LBE,CLV_LINE(1:9),%VAL(2))(@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_LBE,CLV_LINE(1:9),%VAL(2))N@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_LBE,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  I=I+1' 	  DLV_TEMP=DFLOAT(JZEXT(NCVETH_C_SBU)+ .      +			  JZEXT(NCVETH_C_UBU)-ILV_OLD_C_XBU)/      +		   DLV_INTERVAL 1 	  DLV_AVG_C_XBU=0.9*DLV_AVG_C_XBU + 0.1*DLV_TEMPN& 	  IF(LLV_FIRST)DLV_AVG_C_XBU=DLV_TEMP7 	  IF(DLV_TEMP.GT.DLV_MAX_C_XBU) DLV_MAX_C_XBU=DLV_TEMP 7 	  IF(DLV_TEMP.LT.DLV_MIN_C_XBU) DLV_MIN_C_XBU=DLV_TEMPE 	  IF(NCVETH_C_SBU.NE.-1 .AND.#      +	     NCVETH_C_UBU.NE.-1)THENC6 	    CALL FOR$CVT_D_TF(DLV_TEMP,CLV_LINE(1:9),%VAL(2)) 	  ELSEL 	    CLV_LINE(1:9)='------.--' 	  ENDIF> 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_AVG_C_XBU,CLV_LINE(1:9),%VAL(2))V@ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+2*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MIN_C_XBU,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+3*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF9 	  CALL FOR$CVT_D_TF(DLV_MAX_C_XBU,CLV_LINE(1:9),%VAL(2)) @ 	  ILV_STATUS=SMG$PUT_CHARS(ICVSMG_DSPID,CLV_LINE(1:9),I,22+4*D) 	  IF(.NOT.ILV_STATUS)THEN& 	    CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	  ENDIF 	  LLV_FIRST=.FALSE. 	  GOTO 9999 CS' CP.  .  CASE 6 (historical throughput):S CU  6000	CONTINUE 	  GOTO 9999 C) CP.  .  END CASE CA  9999	CONTINUE CL  CP.  .  flush buffer to terminal CE0 	ILV_STATUS=SMG$END_DISPLAY_UPDATE(ICVSMG_DSPID) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF( 	ILV_STATUS=SMG$SNAPSHOT(ICVSMG_PASTEID) 	IF(.NOT.ILV_STATUS)THEN$ 	  CALL LIB$SIGNAL(%VAL(ILV_STATUS)) 	ENDIF CB2 CP.  .  clear buffer counts for next buffer switch CC 	QLV_OLDSYSTIM(1)=QLV_SYSTIM(1)D 	QLV_OLDSYSTIM(2)=QLV_SYSTIM(2)1 	DO I=0,ICPADR_MAXADDRSH 	  ICVADR_ADDRCNT(I,B)=0 	ENDDO 	DO I=0,ICPPRT_MAXNAMESC 	  ICVSTT_PROTCNT(I,B)=0 	ENDDO
 	DO I=0,15 	  ICVSTT_SIZECNT(I,B)=0 	ENDDO 	ICVSTT_BYTES_S_PRE(B)=0 	ICVSTT_MSGS_S_PRE(B)=0( 	ICVSTT_BYTES_S_POST(B)=0I 	ICVSTT_MSGS_S_POST(B)=0 C " CP.  .  save counters for next run C  	ILV_OLD_C_DBR=ICVETH_C_DBR- 	ILV_OLD_C_BRC=ICVETH_C_BRCT 	ILV_OLD_C_MBL=ICVETH_C_MBLO 	ILV_OLD_C_MBY=ICVETH_C_MBY  	ILV_OLD_C_BS1=ICVETH_C_BS1  	ILV_OLD_C_BSM=ICVETH_C_BSMr 	ILV_OLD_C_BID=ICVETH_C_BIDU! 	ILV_OLD_C_OVR=ZEXT(NCVETH_C_OVR),! 	ILV_OLD_C_LBE=ZEXT(NCVETH_C_LBE) 4 	ILV_OLD_C_XBU=ZEXT(NCVETH_C_SBU)+ZEXT(NCVETH_C_UBU) C  CP.  UNTIL exit trap triggered Cn       ENDDOh Ce CP.  turn off display mode C        ICVETH_DISPLAYMODE=0 CAO CP.  flush any extraneous pending wake-ups that might screw up the next DISPLAY, CS       CALL SYS$WAKE(,)       CALL SYS$HIBER Cr CP.  undo SMG screen control C 9       ILV_STATUS=SMG$DELETE_VIRTUAL_DISPLAY(ICVSMG_DSPID).       IF(.NOT.ILV_STATUS)THEND" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIFX       ICVSMG_DSPID=09       ILV_STATUS=SMG$DELETE_VIRTUAL_DISPLAY(ICVSMG_ERRID)1       IF(.NOT.ILV_STATUS)THEN'" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF_       ICVSMG_ERRID=08       ILV_STATUS=SMG$DELETE_PASTEBOARD(ICVSMG_PASTEID,0)       IF(.NOT.ILV_STATUS)THEN(" 	CALL LIB$SIGNAL(%VAL(ILV_STATUS))       ENDIF	 C  CP.  RETURNC CG       DISPLAY=1O       RETURN C  CP END DISPLAY CC	       ENDEA       INTEGER*4 FUNCTION DISPLAY_EXIT_EXCPTHDLR(ILA_SIG,ILA_MECH)L CN/ CP DATA DECLARATIONS for DISPLAY_EXIT_EXCPTHDLRI CS       IMPLICIT NONEV C_  C   declare subroutine arguments C +       INTEGER*4 ILA_SIG(0:*), ILA_MECH(0:4)N C% C   declare local COMMON's CSD       INTEGER*4 ICVDSP_INTERVAL/4/, QCVDSP_INTERVAL(2)/-40000000,-1/       LOGICAL*1 LCVDSP_EXIT D       COMMON /DISPLAY/ ICVDSP_INTERVAL, QCVDSP_INTERVAL, LCVDSP_EXIT CI) C   declare system symbolic message codes  CC!       INCLUDE '($SSDEF)		/NOLIST'  CE CP BEGIN DISPLAY_EXIT_EXCPTHDLR 2 CP.  assume that this is not the correct exception C.)       DISPLAY_EXIT_EXCPTHDLR=SS$_RESIGNALV CA# CP.  IF exception is control/C THEN, C *       IF(ILA_SIG(1) .EQ. SS$_CONTROLC)THEN CL! CP.  .  flag that display is doneP C. 	LCVDSP_EXIT=.TRUE.s C # CP.  .  stop display interval timer  C. 	CALL SYS$CANWAK(,)p C 1 CP.  .  force main program to exit wait state now  C$ 	CALL SYS$WAKE(,)V CNF CP.  .  mark that this is the correct exception and we have handled it C)$ 	DISPLAY_EXIT_EXCPTHDLR=SS$_CONTINUE CC
 CP.  ENDIF CE       ENDIF+ C  CP.  RETURN( CS       RETURN C_ CP END DISPLAY_EXIT_EXCPTHDLRT CU	       END_8       INTEGER*4 FUNCTION HELP(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR,''      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)_ CI CP DATA DECLARATIONS for HELPV CA       IMPLICIT NONE  C$  C   declare subroutine arguments C H       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAMs Cy C   declare local variablesI CC/       INTEGER*4 ILV_DESCRIPTOR(0:1), ILV_STATUSz Ce C   declare local COMMON's CG        INCLUDE 'ETHERMON_DEV.INC' C  C   declare system proceduresM C(       INTEGER*4 LBR$OUTPUT_HELPT=       EXTERNAL	LBR$OUTPUT_HELP, LIB$PUT_OUTPUT, LIB$GET_INPUTG CD! C   declare system symbolic codesS C !       INCLUDE '($HLPDEF)	/NOLIST'P C 
 CP BEGIN HELP.0 CP.  build descriptor of "token" (HELP keywords) CP*       ILV_DESCRIPTOR(0)=%LOC(ILA_TOKENCNT)*       ILV_DESCRIPTOR(1)=%LOC(ILA_TOKENPTR) CV. CP.  extract the results from the help library C :       HELP=LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,,ILV_DESCRIPTOR,>      +			   CCVNAM_EXEDIR(1:NCVNAM_EXEDIRLEN)//'ETHERMON.HLB','      +			   HLP$M_PROMPT,LIB$GET_INPUT)A CL CP.  RETURN  CD       RETURN CV CP END HELPG CD	       END(8       INTEGER*4 FUNCTION LOAD(ILA_OPTIONS,ILA_STRINGCNT,1      +			ILA_STRINGPTR,ILA_TOKENCNT,ILA_TOKENPTR, '      +			ILA_CHAR,ILA_NUMBER,ILA_PARAM)  CD CP DATA DECLARATIONS for LOADN CD       IMPLICIT NONE( CW  C   declare subroutine arguments CDH       INTEGER*4 ILA_OPTIONS, ILA_STRINGCNT, ILA_STRINGPTR, ILA_TOKENCNT,5      +		ILA_TOKENPTR, ILA_CHAR, ILA_NUMBER, ILA_PARAMD CM C   declare local COMMON's CS!       INCLUDE 'ETHERMON_ADDR.INC'G#       INCLUDE 'ETHERMON_FILTER.INC'("       INCLUDE 'ETHERMON_MANUF.INC'!       INCLUDE 'ETHERMON_PROT.INC'         INCLUDE 'ETHERMON_PRS.INC' C_ C   declare local variables	 C0       BYTE	BLV_INET(0:3,10)A"       CHARACTER*2 CLV_FLTMOD/'EO'/%       CHARACTER*256 CLV_SCR, CLV_FILEL       INTEGER*2 LN, LN2.9       INTEGER*4 ILV_STATUS, ILV_ENTRIES, I, ILV_INET(10),L       +		ILV_MSGVEC(0:3), J, K, L       LOGICAL*1 LLV_HOSTFILE       RECORD /ETH_ADR/ SLV_ADDRT&       EQUIVALENCE (ILV_INET, BLV_INET) CC C   declare local procedures CFA       INTEGER*4 FIND_ADDRSLOT, SETUP_HOSTADDR_CALL, GET_HOST_NAME @       EXTERNAL	FIND_ADDRSLOT, SETUP_HOSTADDR_CALL, GET_HOST_NAME CE( C   declare local symbolic message codes CL>       EXTERNAL	ETH__ADRTBLFUL,	ETH__FLTTBLFUL,	ETH__PRTTBLFUL,1      +		ETH__NOFILE,	ETH__FILOPNERR,	ETH__NOINET, &      +		ETH__FLTADDDIS, ETH__MNFTBLFUL CD C   declare system proceduresN CB       INTEGER*4 SYS$GETDVIW        EXTERNAL	SYS$GETDVIW CG) C   declare system symbolic message codesI CS$       INCLUDE '($FORIOSDEF)	/NOLIST' C_
 CP BEGIN LOADD9 CP.  IF target is unspecified or forced as addresses THEN) C        LOAD=1       ILV_ENTRIES=0D?       IF(NCVPRS_FILESPECLEN.LE.0)THEN	! deal with /CHECK=BOUNDSL 	CCVPRS_FILESPEC=' ' 	NCVPRS_FILESPECLEN=1I       ENDIF        IF(BCVPRS_FLTMOD.EQ.0.OR.I      +	 BCVPRS_FLTMOD.EQ.1)THENA CA& CP.  .  attempt to open the input file C	9 	OPEN(UNIT=47,FILE=CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN),S>      +	     STATUS='OLD',DEFAULTFILE='ETHERMON.ETH_ADDRESSES',8      +	     FORM='FORMATTED',READONLY,IOSTAT=ILV_STATUS) CV  CP.  .  IF file open failed THEN CB 	IF(ILV_STATUS.NE.0)THEN CC# CP.  .  .  report appropriate errorI C , 	  IF(ILV_STATUS .EQ. FOR$IOS_FILNOTFOU)THEN 	    ILV_MSGVEC(0)=1$ 	    ILV_MSGVEC(1)=%LOC(ETH__NOFILE) 	  ELSEL 	    ILV_MSGVEC(0)=3' 	    ILV_MSGVEC(1)=%LOC(ETH__FILOPNERR)T 	    ILV_MSGVEC(2)=1 	    ILV_MSGVEC(3)=ILV_STATUSV 	  ENDIF! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)- C  CP.  .  ELSE CS 	ELSEM CU% CP.  .  .  DO for all entries in file+ C  	  DO WHILE(ILV_STATUS.EQ.0) CC, CP.  .  .  .  attempt to read another record CL@ 	    READ(47,'(Z4,Z8,X,Q,A)',IOSTAT=ILV_STATUS) SLV_ADDR.NUM(2),#      +			SLV_ADDR.LNUM, LN, CLV_SCR( C)$ CP.  .  .  .  IF read succeeded THEN C  	    IF(ILV_STATUS.EQ.0)THEN  	      ILV_ENTRIES=ILV_ENTRIES+1 CF+ CP.  .  .  .  .  add entry to address tableV CA' 	      I=FIND_ADDRSLOT(SLV_ADDR,.TRUE.): 	      IF(I.LT.0)THENT 		ILV_MSGVEC(0)=1 $ 		ILV_MSGVEC(1)=%LOC(ETH__ADRTBLFUL)  		CALL SYS$PUTMSG(ILV_MSGVEC,,,) 		ILV_ENTRIES=ILV_ENTRIES-1( 		ILV_STATUS=-2U 	      ELSER2 		ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_USED) 		IF(CLV_SCR(1:1).EQ.' ')THENI	 		  LN2=0L* 		  DO WHILE (CLV_SCR(1+LN2:1+LN2).EQ.' ') 		    LN2=LN2+1B	 		  ENDDO_ 		  CLV_SCR=CLV_SCR(LN2:)* 		  LN=LN-LN2+1  		ENDIFC 		DO WHILE (LN.GT.0)  		  IF(CLV_SCR(1:2).EQ.'D:')THEN 		    LN2=0=0 		    DO WHILE (CLV_SCR(3+LN2:3+LN2).NE.' '.AND.      +			      LN2+3.LE.LN)E 		      LN2=LN2+1) 		    ENDDOY* 		    CCVADR_DECNETNAM(I)=CLV_SCR(3:2+LN2)' 		    NCVADR_DECNETNAMLEN(I)=MIN(LN2,7)1 		    LN2=LN2+3E8 		    ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_DECNET)$ 		  ELSEIF(CLV_SCR(1:2).EQ.'A:')THEN 		    LN2=15@ 		    CALL OTS$CVT_TZ_L(CLV_SCR(3:6),SCVADR_OTHERADDR(I).NUM(2),      +				      %VAL(2))? 		    CALL OTS$CVT_TZ_L(CLV_SCR(7:14),SCVADR_OTHERADDR(I).LNUM)$; 		    ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_OTHERADDR)V$ 		  ELSEIF(CLV_SCR(1:2).EQ.'I:')THEN 		    LN2=3)( 		    CALL OTS$CVT_TU_L(CLV_SCR(LN2:LN2+'      +					INDEX(CLV_SCR(LN2:),'.')-2),U$      +				    BLV_INET(0,1),%VAL(1))& 		    LN2=LN2+INDEX(CLV_SCR(LN2:),'.')( 		    CALL OTS$CVT_TU_L(CLV_SCR(LN2:LN2+'      +					INDEX(CLV_SCR(LN2:),'.')-2),C$      +				    BLV_INET(1,1),%VAL(1))& 		    LN2=LN2+INDEX(CLV_SCR(LN2:),'.')( 		    CALL OTS$CVT_TU_L(CLV_SCR(LN2:LN2+'      +					INDEX(CLV_SCR(LN2:),'.')-2),)$      +				    BLV_INET(2,1),%VAL(1))& 		    LN2=LN2+INDEX(CLV_SCR(LN2:),'.')( 		    CALL OTS$CVT_TU_L(CLV_SCR(LN2:LN2+(      +					INDEX(CLV_SCR(LN2:),'''')-2),$      +				    BLV_INET(3,1),%VAL(1))' 		    LN2=LN2+INDEX(CLV_SCR(LN2:),'''')I# 		    ICVADR_INETADR(I)=ILV_INET(1)$' 		    J=INDEX(CLV_SCR(LN2:),'''')+LN2-2I& 		    CCVADR_INETNAM(I)=CLV_SCR(LN2:J)> 		    NCVADR_INETNAMLEN(I)=MIN(J-LN2+1,LEN(CCVADR_INETNAM(0)))
 		    LN2=J+2 6 		    ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_INET)* 		    IF(CCVADR_INETNAM(I)(1:1).LT.'0'.OR.1      +		       CCVADR_INETNAM(I)(1:1).GT.'9')THEN=< 		      ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_INETNAME) 		    ENDIF1$ 		  ELSEIF(CLV_SCR(1:2).EQ.'S:')THEN 		    LN2=0-0 		    DO WHILE (CLV_SCR(3+LN2:3+LN2).NE.' '.AND.      +			      LN2+3.LE.LN)  		      LN2=LN2+1) 		    ENDDOL: 		    CALL OTS$CVT_TU_L(CLV_SCR(3:2+LN2),ICVADR_SERNUM(I)) 		    LN2=LN2+3C$ 		  ELSEIF(CLV_SCR(1:2).EQ.'X:')THEN 		    LN2=11: 		    CALL OTS$CVT_TZ_L(CLV_SCR(3:10),ICVADR_XNSNETNUM(I))# 		  ELSEIF(CLV_SCR(1:1).EQ.'M')THENT	 		    J=2E 		    DO WHILE (J.LT.LN.AND.)      +			      ((CLV_SCR(J:J).GE.'0'.AND.S"      +				CLV_SCR(J:J).LE.'9').OR.)      +			       (CLV_SCR(J:J).GE.'A'.AND.)       +				CLV_SCR(J:J).LE.'F')))
 		      J=J+1E 		    ENDDO  		    IF(J.GT.2)THEN+ 		      CALL OTS$CVT_TZ_L(CLV_SCR(2:J-1),K)M, 		      ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),&      +					  IAND(K,NOT(ICPADR_USED))) 		    ENDIF%' 		    CCVADR_MISCNAM(I)=CLV_SCR(J+1:LN)D; 		    NCVADR_MISCNAMLEN(I)=MIN(LN-J,LEN(CCVADR_MISCNAM(0)))D 		    LN2=LN+1# 		  ELSEIF(CLV_SCR(1:1).NE.' ')THEN( 		    CALL LIB$PUT_OUTPUT(6      +			'%ETHERMON-W-BADFIL, invalid record in file') 		    LN2=LN+1	 		  ENDIFL# 		  IF(CLV_SCR(LN2:LN2).EQ.' '.AND.       +		     LN2.LT.LN)THENS, 		    DO WHILE (CLV_SCR(LN2:LN2).EQ.' '.AND.      +			      LN2.LE.LN)C 		      LN2=LN2+1- 		    ENDDOF	 		  ENDIFA 		  CLV_SCR=CLV_SCR(LN2:)P 		  LN=LN-LN2+1I 		ENDDO  	      ENDIF CU CP.  .  .  .  ENDIF$ CN
 	    ENDIF CT CP.  .  .  ENDDO CL 	  ENDDO CF
 CP.  .  ENDIFC CL 	ENDIF CA CP.  .  close file CM 	INQUIRE(UNIT=47,NAME=CLV_FILE)($ 	CALL STR$TRIM(CLV_FILE,CLV_FILE,LN) 	CLOSE(UNIT=47)I CI, CP.  ELSEIF target is forced as filters THEN C_$       ELSEIF(BCVPRS_FLTMOD.EQ.2)THEN CT& CP.  .  attempt to open the input file CC9 	OPEN(UNIT=47,FILE=CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN),L<      +	     STATUS='OLD',DEFAULTFILE='ETHERMON.ETH_FILTERS',8      +	     FORM='FORMATTED',READONLY,IOSTAT=ILV_STATUS) C_  CP.  .  IF file open failed THEN C+ 	IF(ILV_STATUS.NE.0)THEN CH# CP.  .  .  report appropriate errorT C), 	  IF(ILV_STATUS .EQ. FOR$IOS_FILNOTFOU)THEN 	    ILV_MSGVEC(0)=1$ 	    ILV_MSGVEC(1)=%LOC(ETH__NOFILE) 	  ELSEB 	    ILV_MSGVEC(0)=3' 	    ILV_MSGVEC(1)=%LOC(ETH__FILOPNERR)I 	    ILV_MSGVEC(2)=1 	    ILV_MSGVEC(3)=ILV_STATUS  	  ENDIF! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)D CV CP.  .  ELSE CE 	ELSED C.% CP.  .  .  DO for all entries in fileM CL 	  DO WHILE(ILV_STATUS.EQ.0) C , CP.  .  .  .  attempt to read another record CA 	    CLV_SCR=' '3 	    READ(47,'(Q,A)',IOSTAT=ILV_STATUS) LN, CLV_SCRA C)$ CP.  .  .  .  IF read succeeded THEN CS 	    IF(ILV_STATUS.EQ.0)THEN  	      ILV_ENTRIES=ILV_ENTRIES+1 C(* CP.  .  .  .  .  add entry to filter table CC
 	      I=14 	      DO WHILE (SCVFLT_FILTERS(I).ENABLE .NE.0.AND.       +			I.LE.ICPFLT_MAXFILTERS) 		I=I+1  	      ENDDO% 	      IF(I.GT.ICPFLT_MAXFILTERS)THEN  		ILV_MSGVEC(0)=1_$ 		ILV_MSGVEC(1)=%LOC(ETH__FLTTBLFUL)  		CALL SYS$PUTMSG(ILV_MSGVEC,,,) 		ILV_ENTRIES=ILV_ENTRIES-1_ 		ILV_STATUS=-2F 	      ELSE$2 		SCVFLT_FILTERS(I).ENABLE=2		! initially disabled' 		ICVFLT_NUMFILTERS=ICVFLT_NUMFILTERS+1L 		SCVFLT_FILTERS(I).PROT_ACT=0 		SCVFLT_FILTERS(I).SRC_ACT=0I 		SCVFLT_FILTERS(I).DST_ACT=0F 		DO WHILE (LN.GT.0) 		  IF(CLV_SCR(2:2).EQ.'M')THENO@ 		    SCVFLT_FILTERS(I).DST_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))+4 		    LN2=3I$ 		  ELSEIF(CLV_SCR(2:3).EQ.'P:')THEN% 		    CALL OTS$CVT_TZ_L(CLV_SCR(4:7),C3      +				    SCVFLT_FILTERS(I).W_PROTOCOL,%VAL(2))M? 		    SCVFLT_FILTERS(I).PROT_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))$ 		    LN2=8T$ 		  ELSEIF(CLV_SCR(2:3).EQ.'A:')THEN. 		    IF(INDEX(CLV_SCR(4:LN+1),' ').LT.12)THEN' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:9),N%      +					SCVFLT_FILTERS(I).LSOURCE)HB 		      SCVFLT_FILTERS(I).SRC_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))+6 		      LN2=10
 		    ELSE' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:7),H.      +					SCVFLT_FILTERS(I).LSOURCE4,%VAL(2))( 		      CALL OTS$CVT_TZ_L(CLV_SCR(8:15),%      +					SCVFLT_FILTERS(I).LSOURCE)OB 		      SCVFLT_FILTERS(I).SRC_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))+4 		      LN2=16 		    ENDIFN$ 		  ELSEIF(CLV_SCR(2:3).EQ.'S:')THEN. 		    IF(INDEX(CLV_SCR(4:LN+1),' ').LT.12)THEN' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:9),O%      +					SCVFLT_FILTERS(I).LSOURCE)UB 		      SCVFLT_FILTERS(I).SRC_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))+2 		      LN2=10
 		    ELSE' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:7),I.      +					SCVFLT_FILTERS(I).LSOURCE4,%VAL(2))( 		      CALL OTS$CVT_TZ_L(CLV_SCR(8:15),%      +					SCVFLT_FILTERS(I).LSOURCE)(@ 		      SCVFLT_FILTERS(I).SRC_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1)) 		      LN2=16 		    ENDIFI$ 		  ELSEIF(CLV_SCR(2:3).EQ.'D:')THEN. 		    IF(INDEX(CLV_SCR(4:LN+1),' ').LT.12)THEN' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:9),1*      +					SCVFLT_FILTERS(I).LDESTINATION)B 		      SCVFLT_FILTERS(I).DST_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1))+2 		      LN2=10
 		    ELSE' 		      CALL OTS$CVT_TZ_L(CLV_SCR(4:7),A3      +					SCVFLT_FILTERS(I).LDESTINATION4,%VAL(2))G( 		      CALL OTS$CVT_TZ_L(CLV_SCR(8:15),*      +					SCVFLT_FILTERS(I).LDESTINATION)@ 		      SCVFLT_FILTERS(I).DST_ACT=INDEX(CLV_FLTMOD,CLV_SCR(1:1)) 		      LN2=16 		    ENDIFL# 		  ELSEIF(CLV_SCR(1:1).NE.' ')THEN( 		    CALL LIB$PUT_OUTPUT(6      +			'%ETHERMON-W-BADFIL, invalid record in file') 		    LN2=LN+1	 		  ENDIF # 		  IF(CLV_SCR(LN2:LN2).EQ.' '.AND.       +		     LN2.LT.LN)THENF, 		    DO WHILE (CLV_SCR(LN2:LN2).EQ.' '.AND.      +			      LN2.LE.LN)G 		      LN2=LN2+1) 		    ENDDO 	 		  ENDIFV 		  CLV_SCR=CLV_SCR(LN2:)$ 		  LN=LN-LN2+1T 		ENDDO  		ILV_MSGVEC(0)=3 $ 		ILV_MSGVEC(1)=%LOC(ETH__FLTADDDIS) 		ILV_MSGVEC(2)=1N 		ILV_MSGVEC(3)=ID  		CALL SYS$PUTMSG(ILV_MSGVEC,,,) 	      ENDIF CU CP.  .  .  .  ENDIF0 CD
 	    ENDIF C( CP.  .  .  ENDDO CB 	  ENDDO C 
 CP.  .  ENDIF. C_ 	ENDIF CD CP.  .  close file C  	INQUIRE(UNIT=47,NAME=CLV_FILE)D$ 	CALL STR$TRIM(CLV_FILE,CLV_FILE,LN) 	CLOSE(UNIT=47)  C . CP.  ELSEIF target is forced as protocols THEN C_$       ELSEIF(BCVPRS_FLTMOD.EQ.3)THEN CE& CP.  .  attempt to open the input file CD9 	OPEN(UNIT=47,FILE=CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN),I>      +	     STATUS='OLD',DEFAULTFILE='ETHERMON.ETH_PROTOCOLS',8      +	     FORM='FORMATTED',READONLY,IOSTAT=ILV_STATUS) CL  CP.  .  IF file open failed THEN C$ 	IF(ILV_STATUS.NE.0)THEN CN# CP.  .  .  report appropriate errorU CH, 	  IF(ILV_STATUS .EQ. FOR$IOS_FILNOTFOU)THEN 	    ILV_MSGVEC(0)=1$ 	    ILV_MSGVEC(1)=%LOC(ETH__NOFILE) 	  ELSE  	    ILV_MSGVEC(0)=3' 	    ILV_MSGVEC(1)=%LOC(ETH__FILOPNERR)  	    ILV_MSGVEC(2)=1 	    ILV_MSGVEC(3)=ILV_STATUS( 	  ENDIF! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)D CM CP.  .  ELSE C( 	ELSEA C)% CP.  .  .  DO for all entries in fileD CD 	  DO WHILE(ILV_STATUS.EQ.0) CN, CP.  .  .  .  attempt to read another record C_= 	    READ(47,'(Z4,X,Q,A)',IOSTAT=ILV_STATUS) LN, LN2, CLV_SCR  C $ CP.  .  .  .  IF read succeeded THEN C0 	    IF(ILV_STATUS.EQ.0)THEN  	      ILV_ENTRIES=ILV_ENTRIES+1 C ; CP.  .  .  .  .  find corresponding entry in protocol table_ CP
 	      I=1* 	      DO WHILE (I.LE.ICVPRT_NUMNAMES.AND.$      +			NCVPRT_PROT_NUM(I) .NE. LN) 		I=I+1S 	      ENDDO CT, CP.  .  .  .  .  IF no such entry found THEN CL# 	      IF(I.GT.ICVPRT_NUMNAMES)THENF CB. CP.  .  .  .  .  .  IF room left in table THEN Ch, 		IF(ICVPRT_NUMNAMES.LT.ICPPRT_MAXNAMES)THEN CY$ CP.  .  .  .  .  .  .  add new entry CX% 		  ICVPRT_NUMNAMES=ICVPRT_NUMNAMES+1O' 		  NCVPRT_PROT_NUM(ICVPRT_NUMNAMES)=LNT2 		  CCVPRT_PROTNAM(ICVPRT_NUMNAMES)=CLV_SCR(1:LN2)' 		  NCVPRT_PROTNAMLEN(ICVPRT_NUMNAMES)=I)      +				MIN(LN2,LEN(CCVPRT_PROTNAM(1)))T C= CP.  .  .  .  .  .  ELSE C  		ELSE C 2 CP.  .  .  .  .  .  .  report table overflow error C_ 		  ILV_MSGVEC(0)=1I& 		  ILV_MSGVEC(1)=%LOC(ETH__PRTTBLFUL)" 		  CALL SYS$PUTMSG(ILV_MSGVEC,,,) 		  ILV_STATUS=-2_ 		  ILV_ENTRIES=ILV_ENTRIES-1_ Cr CP.  .  .  .  .  .  ENDIFI C  		ENDIFC CR CP.  .  .  .  .  ELSEI CO 	      ELSE( CEB CP.  .  .  .  .  .  overwrite existing protocol name with new name CP" 		CCVPRT_PROTNAM(I)=CLV_SCR(1:LN2)6 		NCVPRT_PROTNAMLEN(I)=MIN(LN2,LEN(CCVPRT_PROTNAM(1))) CH CP.  .  .  .  .  ENDIF Cu 	      ENDIF C  CP.  .  .  .  ENDIF  Ch
 	    ENDIF Cn CP.  .  .  ENDDO C  	  ENDDO CK
 CP.  .  ENDIFL CS 	ENDIF C  CP.  .  close file Cn 	INQUIRE(UNIT=47,NAME=CLV_FILE)L$ 	CALL STR$TRIM(CLV_FILE,CLV_FILE,LN) 	CLOSE(UNIT=47)T CS- CP.  ELSEIF target is forced as Internet THEN  CN$       ELSEIF(BCVPRS_FLTMOD.EQ.4)THEN CT8 CP.  .  attempt to hook up to appropriate socket library CL 	LLV_HOSTFILE=.FALSE.I9 	ILV_STATUS=SYS$GETDVIW(,,'_INET0:',0,,,,)	! TGV MultinetD 	IF(ILV_STATUS)THENS< 	  ILV_STATUS=SETUP_HOSTADDR_CALL('MULTINET_SOCKET_LIBRARY',5      +			'GETHOSTBYADDR','INET_NETOF','GETNETBYADDR')I 	  CLV_FILE='TGV Multinet' 	  LN=12 	ENDIF 	IF(.NOT.ILV_STATUS)THEN4 	  ILV_STATUS=SYS$GETDVIW(,,'_BG0:',0,,,,)	! VMS UCX 	  IF(ILV_STATUS)THEN,. 	    ILV_STATUS=SETUP_HOSTADDR_CALL('VAXCRTL',0      +			'VAXC$GETHOSTBYADDR','VAXC$INET_NETOF',      +			'VAXC$GETNETBYADDR') ) 	    CLV_FILE='DEC VMS/Ultrix Connection'0
 	    LN=25 	  ENDIF 	ENDIF 	IF(.NOT.ILV_STATUS)THEN8 	  ILV_STATUS=SYS$GETDVIW(,,'_FUA0:',0,,,,)	! NRC Fusion 	  IF(ILV_STATUS)THENI0 	    ILV_STATUS=SETUP_HOSTADDR_CALL('FNS_SHARE',!      +			'GHBYADDR','INET_NETOF',l;      +			0)	! don't have one of these, so don't look for itF 	    CLV_FILE='NRC Fusion'
 	    LN=10 	  ENDIF 	ENDIF 	IF(.NOT.ILV_STATUS)THEN7 	  ILV_STATUS=SYS$GETDVIW(,,'_IP0:',0,,,,)	! CMU TCP/IPR 	  IF(ILV_STATUS)THENx 	    CLV_FILE='CMU TCP/IP: '* 	    INQUIRE(FILE='SYS$LIBRARY:HOSTS.TXT',0      +		    NAME=CLV_FILE(13:),EXIST=ILV_STATUS) 	    IF(ILV_STATUS)THEN  	      ILV_STATUS=1r* 	      CALL STR$TRIM(CLV_FILE,CLV_FILE,LN) 	      LLV_HOSTFILE=.TRUE.	 	    ELSEt 	      ILV_STATUS=0Y
 	    ENDIF 	  ENDIF 	ENDIF C % CP.  .  IF success in hooking up THENv Ca 	IF(ILV_STATUS)THENY CI. CP.  .  .  IF direct call access arranged THEN C  	  IF(.NOT.LLV_HOSTFILE)THEN C @ CP.  .  .  .  DO for all address entries with Internet addresses CN 	    DO I=0,ICPADR_MAXADDRSI C,H CP.  .  .  .  .  IF entry exists and doesn't already have real name THEN CI5 	      IF(IAND(ICVADR_FLAGS(I),ICPADR_INET).NE.0.AND.S%      +		 ICVADR_FLAGS(I).AND.		! used$8      +		 IAND(ICVADR_FLAGS(I),ICPADR_INETNAME).EQ.0)THEN CP0 CP.  .  .  .  .  .  attempt to get the real name C - 		ILV_STATUS=GET_HOST_NAME(ICVADR_INETADR(I),A      +					 CCVADR_INETNAM(I),!      +					 NCVADR_INETNAMLEN(I))C CT, CP.  .  .  .  .  .  IF attempt succeeds THEN CN 		IF(ILV_STATUS.NE.0)THENR C_ CP.  .  .  .  .  .  .  flag it Co8 		  ICVADR_FLAGS(I)=IOR(ICVADR_FLAGS(I),ICPADR_INETNAME) 		  ILV_ENTRIES=ILV_ENTRIES+1U CT CP.  .  .  .  .  .  ENDIFe Cr 		ENDIFs Co CP.  .  .  .  .  ENDIF CD 	      ENDIF CI CP.  .  .  .  ENDDOL C 
 	    ENDDO Cr" CP.  .  .  ELSE {read a host file} C  	  ELSEE CI@ CP.  .  .  .  attempt to open the host file for read-only access C)4 	    OPEN(UNIT=47,FILE=CLV_FILE(13:LN),STATUS='OLD',5      +		 READONLY,FORM='FORMATTED',IOSTAT=ILV_STATUS)R CO# CP.  .  .  .  IF open succeeds THENM CE 	    IF(ILV_STATUS.EQ.0)THEN C	* CP.  .  .  .  .  read first record in file CR6 	      READ(47,'(Q,A)',IOSTAT=ILV_STATUS) LN2, CLV_SCR C , CP.  .  .  .  .  DO WHILE not at end of file CN! 	      DO WHILE (ILV_STATUS.EQ.0)N C,# CP.  .  .  .  .  .  compress record_ CB 		IF(LN2.GT.0)THEN 		  I=1E 		  J=0S 		  DO WHILE (I.LT.LN2)L! 		    IF(CLV_SCR(I:I).NE.' '.AND.i+      +		       CLV_SCR(I:I).NE.CHAR(9).AND.,+      +		       CLV_SCR(I:I).NE.CHAR(0))THEN 
 		      J=J+1E# 		      IF(CLV_SCR(I:I).GE.'A'.AND.D6      +			 CLV_SCR(I:I).LE.'Z')THEN	! downshift letters, 			CLV_SCR(J:J)=CHAR(ICHAR(CLV_SCR(I:I))+32) 		      ELSE 			CLV_SCR(J:J)=CLV_SCR(I:I)
 		      ENDIF  		    ENDIFT 		    I=I+1 	 		  ENDDOH	 		  LN2=JN 		ENDIF  Ce7 CP.  .  .  .  .  .  IF record begins with 'HOST :' THEN  C ! 		IF(CLV_SCR(1:5).EQ.'host:'.AND.       +		   LN2.GT.13)THENV CL? CP.  .  .  .  .  .  .  extract all following Internet addressesR C, 		  I=0N 		  J=5  		  CLV_SCR(5:5)=',' 		  K=6L& 		  DO WHILE (CLV_SCR(J:J).NE.':'.AND.#      +			    J.LT.LN2.AND.J.LE.K+2)A 		    I=I+1E 		    J=J+1  		    ILV_INET(I)=0 % 		    K=J+INDEX(CLV_SCR(J:LN2),'.')-2D 		    IF(K.GE.J)THEN= 		      CALL OTS$CVT_TU_L(CLV_SCR(J:K),BLV_INET(0,I),%VAL(1))D
 		      J=K+2S 		    ENDIF % 		    K=J+INDEX(CLV_SCR(J:LN2),'.')-2  		    IF(K.GE.J)THEN= 		      CALL OTS$CVT_TU_L(CLV_SCR(J:K),BLV_INET(1,I),%VAL(1))L
 		      J=K+2R 		    ENDIFT% 		    K=J+INDEX(CLV_SCR(J:LN2),'.')-2F 		    IF(K.GE.J)THEN= 		      CALL OTS$CVT_TU_L(CLV_SCR(J:K),BLV_INET(2,I),%VAL(1))N
 		      J=K+2  		    ENDIFr% 		    K=J+INDEX(CLV_SCR(J:LN2),':')-2  		    IF(K-J.GT.3)THEN' 		      K=J+INDEX(CLV_SCR(J:LN2),',')-2a 		    ENDIFc 		    IF(K.GE.J)THEN= 		      CALL OTS$CVT_TU_L(CLV_SCR(J:K),BLV_INET(3,I),%VAL(1))N
 		      J=K+1E 		    ENDIF 	 		  ENDDOC CK: CP.  .  .  .  .  .  .  DO for all entries in address table CN 		  DO K=0,ICPADR_MAXADDRS C.O CP.  .  .  .  .  .  .  .  IF valid, has an Internet address and not a name THENi C 4 		    IF(IAND(ICVADR_FLAGS(K),ICPADR_USED).NE.0.AND.:      +		       IAND(ICVADR_FLAGS(K),ICPADR_INET).NE.0.AND.>      +		       IAND(ICVADR_FLAGS(K),ICPADR_INETNAME).EQ.0)THEN CUN CP.  .  .  .  .  .  .  .  .  IF entry's address matches one from hostfile THEN C  		      L=1r 		      DO WHILE (L.LE.I.AND.T+      +				ICVADR_INETADR(K).NE.ILV_INET(L))G 			L=L+1
 		      ENDDO( 		      IF(L.LE.I)THEN CSO CP.  .  .  .  .  .  .  .  .  .  extract first legal name from record & store itE C) 			J=J+1 			L=J 			DO WHILE (L.LT.LN2.AND.$      +				  CLV_SCR(L:L).NE.':'.AND.       +				  CLV_SCR(L:L).NE.',')
 			  L=L+1 			ENDDO 			L=L-1! 			CCVADR_INETNAM(K)=CLV_SCR(J:L). 			NCVADR_INETNAMLEN(K)=L-J+1o7 			ICVADR_FLAGS(K)=IOR(ICVADR_FLAGS(K),ICPADR_INETNAME)S 			ILV_ENTRIES=ILV_ENTRIES+1 C " CP.  .  .  .  .  .  .  .  .  ENDIF C)
 		      ENDIF  Cr CP.  .  .  .  .  .  .  .  ENDIFL CT 		    ENDIFN C  CP.  .  .  .  .  .  .  ENDDO CF	 		  ENDDO  C  CP.  .  .  .  .  .  ENDIFl C  		ENDIF  CF. CP.  .  .  .  .  .  read next record from file CE1 		READ(47,'(Q,A)',IOSTAT=ILV_STATUS) LN2, CLV_SCRD CL CP.  .  .  .  .  ENDDO C_ 	      ENDDO C_ CP.  .  .  .  .  close file_ CT 	      CLOSE(UNIT=47)	 CA CP.  .  .  .  ENDIFR CA
 	    ENDIF CE1 CP.  .  .  .  IF all FORTRAN statuses are OK THEN  CW 	    IF(ILV_STATUS.LE.0)THEN C)+ CP.  .  .  .  .  turn into valid VMS statusL CC 	      ILV_STATUS=1N C  CP.  .  .  .  ELSE C(	 	    ELSE	 CF. CP.  .  .  .  .  make sure status is erroneous CW 	      ILV_STATUS=0+ C) CP.  .  .  .  ENDIF	 C 
 	    ENDIF CE CP.  .  .  ENDIF C  	  ENDIF C  CP.  .  ELSE CE 	ELSE= C_, CP.  .  .  report error of "no such network" C2 	  LOAD=%LOC(ETH__NOINET)  CC
 CP.  .  ENDIFO CC 	ENDIF CI2 CP.  ELSEIF target is forced as manufacturers THEN C $       ELSEIF(BCVPRS_FLTMOD.EQ.5)THEN C_& CP.  .  attempt to open the input file C+9 	OPEN(UNIT=47,FILE=CCVPRS_FILESPEC(1:NCVPRS_FILESPECLEN),CB      +	     STATUS='OLD',DEFAULTFILE='ETHERMON.ETH_MANUFACTURERS',8      +	     FORM='FORMATTED',READONLY,IOSTAT=ILV_STATUS) C   CP.  .  IF file open failed THEN C_ 	IF(ILV_STATUS.NE.0)THEN CX# CP.  .  .  report appropriate error  CL, 	  IF(ILV_STATUS .EQ. FOR$IOS_FILNOTFOU)THEN 	    ILV_MSGVEC(0)=1$ 	    ILV_MSGVEC(1)=%LOC(ETH__NOFILE) 	  ELSEI 	    ILV_MSGVEC(0)=3' 	    ILV_MSGVEC(1)=%LOC(ETH__FILOPNERR)1 	    ILV_MSGVEC(2)=1 	    ILV_MSGVEC(3)=ILV_STATUSL 	  ENDIF! 	  CALL SYS$PUTMSG(ILV_MSGVEC,,,)D CC CP.  .  ELSE C- 	ELSE  C+% CP.  .  .  DO for all entries in fileN CN 	  DO WHILE(ILV_STATUS.EQ.0) C , CP.  .  .  .  attempt to read another record CDC 	    READ(47,'(Z6,X,A8,X,Q,A)',IOSTAT=ILV_STATUS) J, CLV_FILE(1:8),       +					LN, CLV_SCR C:$ CP.  .  .  .  IF read succeeded THEN CT 	    IF(ILV_STATUS.EQ.0)THEN  	      ILV_ENTRIES=ILV_ENTRIES+1 CM@ CP.  .  .  .  .  find corresponding entry in manufacturers table C_
 	      I=1* 	      DO WHILE (I.LE.ICVMNF_NUMNAMES.AND.$      +			ICVMNF_MANUF_NUM(I) .NE. J) 		I=I+1N 	      ENDDO C', CP.  .  .  .  .  IF no such entry found THEN C'# 	      IF(I.GT.ICVMNF_NUMNAMES)THEN( CA. CP.  .  .  .  .  .  IF room left in table THEN CE, 		IF(ICVMNF_NUMNAMES.LT.ICPMNF_MAXNAMES)THEN C $ CP.  .  .  .  .  .  .  add new entry C.% 		  ICVMNF_NUMNAMES=ICVMNF_NUMNAMES+1 ' 		  ICVMNF_MANUF_NUM(ICVMNF_NUMNAMES)=JC- 		  CCVMNF_NAM(ICVMNF_NUMNAMES)=CLV_FILE(1:8) . 		  CALL STR$TRIM(CCVMNF_NAM(ICVMNF_NUMNAMES),&      +				CCVMNF_NAM(ICVMNF_NUMNAMES),)      +				NCVMNF_NAMLEN(ICVMNF_NUMNAMES))L2 		  CCVMNF_MANUFNAM(ICVMNF_NUMNAMES)=CLV_SCR(1:LN)( 		  NCVMNF_MANUFNAMLEN(ICVMNF_NUMNAMES)=)      +				MIN(LN,LEN(CCVMNF_MANUFNAM(1))): CL CP.  .  .  .  .  .  ELSE CC 		ELSE C.2 CP.  .  .  .  .  .  .  report table overflow error C  		  ILV_MSGVEC(0)=1 & 		  ILV_MSGVEC(1)=%LOC(ETH__MNFTBLFUL)" 		  CALL SYS$PUTMSG(ILV_MSGVEC,,,) 		  ILV_STATUS=-2( 		  ILV_ENTRIES=ILV_ENTRIES-1I C( CP.  .  .  .  .  .  ENDIF  CI 		ENDIF  CA CP.  .  .  .  .  ELSE+ CN 	      ELSEA CMB CP.  .  .  .  .  .  overwrite existing protocol name with new name CE 		CCVMNF_NAM(I)=CLV_FILE(1:8)	 		CALL STR$TRIM(CCVMNF_NAM(I),      +				CCVMNF_NAM(I),      +				NCVMNF_NAMLEN(I)) " 		CCVMNF_MANUFNAM(I)=CLV_SCR(1:LN)7 		NCVMNF_MANUFNAMLEN(I)=MIN(LN,LEN(CCVMNF_MANUFNAM(1)))  CO CP.  .  .  .  .  ENDIF C. 	      ENDIF C	 CP.  .  .  .  ENDIF	 C 
 	    ENDIF C	 CP.  .  .  ENDDO CA 	  ENDDO C=
 CP.  .  ENDIF  C  	ENDIF CI CP.  .  close file CF 	INQUIRE(UNIT=47,NAME=CLV_FILE) $ 	CALL STR$TRIM(CLV_FILE,CLV_FILE,LN) 	CLOSE(UNIT=47). CN
 CP.  ENDIF CF       ENDIF  Cs, CP.  report number of entries read from file CL       IF(ILV_ENTRIES.NE.0)THEN. 	CALL SYS$FAO('!UL entries read from !AS',LN2,=      +		     CLV_SCR,%VAL(MAX(ILV_ENTRIES,0)),CLV_FILE(1:LN)) $ 	CALL LIB$PUT_OUTPUT(CLV_SCR(1:LN2))       ENDIFE CN CP.  RETURNV C_       RETURN C_ CP END LOADL C 	       ENDT