
 $! Procedure: B $!	Set up the underlying TCP/IP network stack software to initiate $!	a network service.  $! $! Parameters:# $!	P1	Network stack (UCX, MULTINET)  $!	P2	Service name $!	P3	Port Number  $!
 $! Author:, $!	Andy Harper	1.0	Nov 1996	Original Version0 $!	Andy Harper	1.1	Dec 1996	Fixed a few problems7 $!	Andy Harper	1.2	Jan 1997	Add a rudimentary CMU setup ; $!	Andy Harper	1.3	Jan 1997	Add a rudimentary TCPWARE setup 9 $!	Andy Harper	1.4	Jan 1997	Add checks for stack presence  $! $! Acknowledgements:7 $!	Ian Miller at Softel for the UCX set up information	 F $!	Curtis Williams at Western Kentucky University for the TCPWARE info $  $ 
 $ set noon $  $! Check parameter $ if (P1 .eqs. "") $   thenE $     write sys$error "You must specify the network stack name as P1" 
 $     exit $ endif  $  $ if (P2 .eqs. "") $   thenD $     write sys$error "You must specify the service name name as P2"
 $     exit $ endif  $  $ if (P3 .eqs. "") $   thenD $     write sys$error "You must specify the service port name as P3"
 $     exit $ endif  $  $  $! Fixed configurationF $ TEMPFILE = "SYS$SCRATCH:SERVICE-SETUP" + f$getjpi("","PID") + ".TMP" $ PARAMALIGN = 10  $ PARAMPREFIX= "STACK" $ N $! Parameters that may be changed by the user (not all are used by all stacks) $ STACK$SERVICE   = P2 $ STACK$PORT      = P3 $ STACK$TYPE      = "TCP" * $ STACK$IMAGE     = "''STACK$SERVICE'_EXE" $ STACK$USERNAME  = "SYSTEM" $ STACK$UIC       = "[1,3]"  $ STACK$PRCNAM    = P2H $ STACK$PROCEDURE = "''STACK$SERVICE'_ROOT:[000000]''STACK$SERVICE'.COM"P $ STACK$STARTLOG  = "''STACK$SERVICE'_ROOT:[000000]''STACK$SERVICE'_STARTUP.LOG" $ STACK$MAXSESS   = "20"* $ STACK$PRIVS     = "TMPMBX,NETMBX,SYSPRV": $ STACK$PGFLQUO   = f$string( f$getsyi("PQL_DPGFLQUOTA") ) $ STACK$MAXBUF    = "8300" $  $ % $! If UCX specified, set up the stack  $ if (P1 .eqs. "UCX")  $   then $ 8 $     if f$trnlnm("UCX$INET_HOST","LNM$SYSTEM") .eqs. "" $       thenQ $         write sys$output "%UCX-E-NOTFOUND, UCX not present/loaded on this node"  $         exit $     endif  $   $   ! Define UCX specific params+ $     STACK$PRCNAM  = "UCX$" + STACK$PRCNAM  $ ( $   ! Check the parameters with the userQ $     PARAMLIST = "SERVICE,PORT,IMAGE,PROCEDURE,USERNAME,PRCNAM,MAXSESS,STARTLOG"  $     gosub PARAMCHECK $ 5 $   ! Generate command procedure to configure service  $     gosub INITCONFIGPROC $     gosub WRITECONFIGMESS @ $     write CONFIGPROC "$ ucx set service ", STACK$SERVICE, " -"8 $     write CONFIGPROC "   /user=", STACK$USERNAME, " -"8 $     write CONFIGPROC "   /proc=", STACK$PRCNAM,   " -"8 $     write CONFIGPROC "   /limit=", STACK$MAXSESS, " -"8 $     write CONFIGPROC "   /port=", STACK$PORT,     " -"8 $     write CONFIGPROC "   /file=", STACK$PROCEDURE," -"A $     write CONFIGPROC "   /log=(file=", STACK$STARTLOG, ", ALL)"  $     gosub WRITEENABLEMESS H $     write CONFIGPROC "$ ucx set config enable service ", STACK$SERVICE= $     write CONFIGPROC "$ ucx enable service ", STACK$SERVICE  $     gosub WRITECREPROCMESS3 $     write CONFIGPROC "$ create ", STACK$PROCEDURE  $     write CONFIGPROC "$deck", $     write CONFIGPROC "$ run ", STACK$IMAGE $     write CONFIGPROC "$eod"  $     gosub WRITETERMMESS  $     gosub TERMCONFIGPROC $ * $    ! execute the configuration procedure $     gosub EXECCONFIGPROC $     gosub DELECONFIGPROC
 $     exit $ endif  $  $  $! Set up MULTINET stack $ if (P1 .eqs. "MULTINET") $   then $ 3 $     if f$trnlnm("MULTINET","LNM$SYSTEM") .eqs. ""  $       then[ $         write sys$output "%MULTINET-E-NOTFOUND, MULTINET not present/loaded on this node"  $         exit $     endif  $ ( $   ! Check the parameters with the user< $     PARAMLIST = "SERVICE,PORT,TYPE,IMAGE,USERNAME,PGFLQUO" $     gosub PARAMCHECK $ & $   ! generate configuration procedure $     gosub INITCONFIGPROC $     gosub WRITECONFIGMESS 4 $     write CONFIGPROC "$ multinet configure/server". $     write CONFIGPROC "  add ", STACK$SERVICE' $     write CONFIGPROC "  ", STACK$TYPE ' $     write CONFIGPROC "  ", STACK$PORT ( $     write CONFIGPROC "  ", STACK$IMAGE8 $     write CONFIGPROC "  set username ", STACK$USERNAME: $     write CONFIGPROC "  set pql-pgflquo ", STACK$PGFLQUO2 $     write CONFIGPROC "  disable ", STACK$SERVICE $     write CONFIGPROC "  save"  $     gosub WRITEENABLEMESS 4 $     write CONFIGPROC "$ multinet configure/server"1 $     write CONFIGPROC "  enable ", STACK$SERVICE  $     write CONFIGPROC "  save" " $     write CONFIGPROC "  restart" $     gosub WRITETERMMESS  $     gosub TERMCONFIGPROC $     gosub EXECCONFIGPROC $     gosub DELECONFIGPROC
 $     exit $ endif  $  $  $  $! Set up TCPWARE stack  $ if (P1 .eqs. "TCPWARE")  $   then $ 2 $     if f$trnlnm("TCPWARE","LNM$SYSTEM") .eqs. "" $       thenY $         write sys$output "%TCPWARE-E-NOTFOUND, TCPWARE not present/loaded on this node"  $         exit $     endif  $ ( $   ! Check the parameters with the user7 $     PARAMLIST = "SERVICE,PORT,TYPE,IMAGE,UIC,PGFLQUO"  $     gosub PARAMCHECK $ G $   ! Check whether the relevant WKS entry appears in the services file  $   !  (uncommented..) $     write sys$output "" O $     write sys$output P1,": Checking TCPWARE:SERVICES. file for service entry" / $     if f$search("TCPWARE:SERVICES.") .eqs. ""  $       thenL $         write sys$output " Configuration file TCPWARE:SERVICES. not found" $     endif  $  $     define/user sys$error nl:   $     define/user sys$output nl:= $     search/output='TEMPFILE' TCPWARE:SERVICES. 'STACK$PORT' 0 $     if f$file_attributes("''TEMPFILE'", "EOF") $       thenT $         write sys$output " An entry for this service appears in TCPWARE:SERVICES."- $         write sys$output " and looks like:"  $         write sys$output ""   $         type/nopage 'TEMPFILE' $       elseg $         write sys$output " No entry for ''STACK$SERVICE' on ''STACK$PORT' found in TCPWARE:SERVICES." d $         write sys$output " Edit this file to add the following line and then rerun SERVICE_SETUP:" $         write sys$output "" A $         write sys$output "  ''STACK$SERVICE'	''STACK$PORT'/TCP" # $         delete/nolog 'TEMPFILE';*  $         exit $     endif  $     write sys$output ""  $ & $   ! generate configuration procedure $     gosub INITCONFIGPROC $     gosub WRITECONFIGMESS   $     write CONFIGPROC "$ netcu 9 $     write CONFIGPROC "  add service ", STACK$PORT, " -" - $     write CONFIGPROC "  ", STACK$TYPE, " -" . $     write CONFIGPROC "  ", STACK$IMAGE, " -"1 $     write CONFIGPROC "  /uic=", STACK$UIC, " -" 5 $     write CONFIGPROC "  /page_file=", STACK$PGFLQUO  $     gosub WRITEENABLEMESS  $     gosub TERMCONFIGPROC $     gosub EXECCONFIGPROC $     gosub DELECONFIGPROC
 $     exit $ endif  $  $ if (P1 .eqs. "CMU")  $   then $ 5 $     if f$trnlnm("CMUIP_ROOT","LNM$SYSTEM") .eqs. ""  $       thenQ $         write sys$output "%CMU-E-NOTFOUND, CMU not present/loaded on this node"  $         exit $     endif  $  $   ! Extra privs required+ $     STACK$PRIVS = STACK$PRIVS + ",PHY_IO"  $ C $   ! Check user modifiable parameters for this stack with the user . $     PARAMLIST   = "SERVICE,PORT,IMAGE,PRIVS" $     gosub PARAMCHECK $ L $   ! Check whether the relevant WKS entry appears in the configuration file $   !  (uncommented..) $     write sys$output "" I $     write sys$output P1,": Checking INET$CONFIG file for service entry" ) $     if f$search("INET$CONFIG") .eqs. ""  $       thenF $         write sys$output " Configuration file INET$CONFIG not found" $     endif  $  $     define/user sys$error nl:   $     define/user sys$output nl:< $     search/output='TEMPFILE' inet$config WKS:'STACK$PORT': $     if $status $       thenN $         write sys$output " An entry for this service appears in INET$CONFIG"- $         write sys$output " and looks like:"  $         write sys$output ""   $         type/nopage 'TEMPFILE' $       elsea $         write sys$output " No entry for ''STACK$SERVICE' on ''STACK$PORT' found in INET$CONFIG" G $         write sys$output " Edit this file to add the following line:"  $         write sys$output "" n $         write sys$output "  WKS:''STACK$PORT':''STACK$SERVICE':''STACK$IMAGE':NETWRK:''STACK$PRIVS':::::4:5" $     endif  $     write sys$output ""  $ 8 $     write sys$output P1,": Checking SYSGEN parameters" $ % $   ! Check that MAXBUF is sufficient / $     if f$getsyi("MAXBUF") .ge. 'STACK$MAXBUF'  $       then- $         write sys$output " -- MAXBUF is OK"  $       elseR $         write sys$output " -- MAXBUF too low. Should be at least ", STACK$MAXBUF $     endif  $  $     gosub DELECONFIGPROC
 $     exit $ endif  $  $ $ $! A stack we know nothing about....J $ write sys$error "''P1': Service setup not supported for this stack type" $ exit $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $INITCONFIGPROC:g $ write sys$output "''P1': Creating configuration procedure for ''STACK$SERVICE' on port ''STACK$PORT'" / $ open/write/error=NOOPEN CONFIGPROC 'TEMPFILE'  $ return $NOOPEN:9 $ write sys$error "Cannot open temporary file ", TEMPFILE  $ exit $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $WRITECONFIGMESS: m $ write CONFIGPROC "$ write SYS$OUTPUT ""''P1': Configuring service ''STACK$SERVICE' on port ''STACK$PORT'"""  $ return $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $WRITEENABLEMESS: T $ write CONFIGPROC "$ write SYS$OUTPUT ""''P1': Enabling service ''STACK$SERVICE'""" $ return $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $WRITECREPROCMESS:X $ write CONFIGPROC "$ write SYS$OUTPUT ""''P1': Creating procedure ''STACK$PROCEDURE'""" $ return $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $WRITETERMMESS: I $ write CONFIGPROC "$ write SYS$OUTPUT ""''P1': Configuration complete"""  $ return $  $ K $! ------------------------------------------------------------------------ K $! ------------------------------------------------------------------------  $TERMCONFIGPROC: $ close CONFIGPROC $ return $ K $! ------------------------------------------------------------------------ = $! Execute the configuration procedure and check error return K $! ------------------------------------------------------------------------  $EXECCONFIGPROC:D $ write sys$output "''P1': Executing configuration procedure now..." $  $! type/nopage 'TEMPFILE' 	 $! return  $ 
 $ @'TEMPFILE'  $ if .not. $status $   theni $     write sys$error "''P1': config procedure failed. Status = ''$status', Message=", f$message($status)  $ endif  $ return $ K $! ------------------------------------------------------------------------ / $! Delete the temporary configuration procedure K $! ------------------------------------------------------------------------  $DELECONFIGPROC: $ delete 'TEMPFILE';*  $ return $  $! K $! ------------------------------------------------------------------------ F $! Scan list of parameters and confirm the value of each with the user $!
 $! Inputs:# $!	PARAMALIGN	Indentation of prompt B $!	PARAMPREFIX	Prefix used to form symbol name from parameter name$ $!	PARAMLIST	List of parameter namesM $!      'PREFIX'$'name'	List of symbols containing values of parameter 'name'  $! $! Outputs: M $!      'PREFIX'$'name'	List of symbols containing values of parameter 'name'  $!K $! ------------------------------------------------------------------------  $PARAMCHECK: $   write sys$output "" K $   write sys$output "Please confirm, or modify, the following parameters:"  $   write sys$output "" 	 $   N = 0  $  GUIloop: ( $   PARAMID = f$element(N,",",PARAMLIST) $   if (PARAMID .nes. ",")
 $     then- $        PARAMVALUE = 'PARAMPREFIX'$'PARAMID'  $        gosub ConfirmValue - $        'PARAMPREFIX'$'PARAMID' = PARAMVALUE  $        N = N+1 $        goto GUIloop 	 $   endif  $  $   write sys$output "" B $   read/prompt="  *  OK to proceed [N] ? " sys$command PARAMVALUE. $   if .not. PARAMVALUE then $ goto PARAMCHECK $ return $ K $! ------------------------------------------------------------------------ A $! Display the parameter, if user specifies new value, replace it  $!
 $! Inputs:- $!	PARAMID		Name of parameter to be confirmed ( $!	PARAMVALUE	Current value of parameter. $!	PARAMALIGN	Indentation depth, for alignment $! $! Outputs: $ $!	PARAMVALUE	New value of parameter $!K $! ------------------------------------------------------------------------  $ConfirmValue:d $   PromptString = f$fao("  * !#* !AS : [!AS] ?", PARAMALIGN-f$length(PARAMID), PARAMID, PARAMVALUE)8 $   read/prompt=&PromptString sys$command PromptResponseA $   if PromptResponse .nes. "" then $ PARAMVALUE = PromptResponse  $ return