$! Program:	Operating-system dependent routines -- VMS version
$!		Builds the C-CLIENT library and servers
$!
$! Author:	Yehavi Bourvine, The Hebrew University of Jerusalem.
$!		Internet: Yehavi@VMS.huji.ac.il
$!
$! Modified:	Andy Harper, Kings College London.
$!		Internet: A.Harper@kcl.ac.uk
$!
$! Date:	2 August 1994
$! Last Edited:	07-FEB-1997
$!
$! Copyright 1994 by the University of Washington
$!
$!  Permission to use, copy, modify, and distribute this software and its
$! documentation for any purpose and without fee is hereby granted, provided
$! that the above copyright notice appears in all copies and that both the
$! above copyright notice and this permission notice appear in supporting
$! documentation, and that the name of the University of Washington not be
$! used in advertising or publicity pertaining to distribution of the software
$! without specific, written prior permission.	This software is made available
$! "as is", and
$! THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
$! WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
$! WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
$! NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
$! INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
$! LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
$! (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
$! WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
$!
$! Parameters:
$!	P1	Build options
$!			NOTCP, MULTINET, NETLIB	- Select TCP stack support
$!			COMPILE-ONLY		- Bypass link stage
$!			LINK-ONLY		- Bypass compile stage
$!			VAXC			- Force use of VAXC
$!			GNUC			- Force use of GNUC
$!			DEBUG			- Include DEBUGGER
$!			NOTRACEBACK		- Link with /NOTRACE
$!			OPTIMIZE		- Specify optimize only if no DEBUG
$!
$!		The following are specific to this module!!
$!			LOGTRACE		- Add support for writing debug
$!						  stuff via mm_dlog at a level
$!						  determined by IMAPD_LOGLEVEL logical
$!			NETTRACE		- Logs network I/O to log file
$!						  at level determined via IMAPD_LOGLEVEL
$!
$!	P2	Modules to recompile
$!			module-list
$!
$!
$
$! -------------------------------------------------------------------------
$! Define location for object files and executables
$! -------------------------------------------------------------------------
$ Arch = "VAX"
$ if f$getsyi("VERSION") .ges. "V5.5" then $ Arch = f$getsyi("ARCH_NAME")
$ OLBDIR      = "[---.OBJ_''Arch']"
$ OBJDIR      = "[---.OBJ_''Arch'.C-CLIENT]"
$ EXEDIR      = "[---.EXE_''Arch']"
$ if f$parse(OLBDIR) .eqs. "" then $ create/dir 'OLBDIR'
$ if f$parse(OBJDIR) .eqs. "" then $ create/dir 'OBJDIR'
$ if f$parse(EXEDIR) .eqs. "" then $ create/dir 'EXEDIR'
$
$! -------------------------------------------------------------------------
$! Check compile and link conflicts
$! -------------------------------------------------------------------------
$ COMPILEONLY = f$locate("COMPILE-ONLY",P1) .lt. f$length(P1)
$ LINKONLY    = f$locate("LINK-ONLY",   P1) .lt. f$length(P1)
$ if (COMPILEONLY .and. LINKONLY)
$   then
$     write sys$output "%VMSBUILD-E-CONFLICT, Conflicting compile/link options"
$     exit
$ endif
$
$
$! Standard (+optional) defines
$ Defines   = "VMSIO"
$ if f$locate("LOGTRACE",P1)         .lt. f$length(P1) then $ Defines=Defines+",LOGTRACE"
$ if f$locate("NETTRACE",P1)         .lt. f$length(P1) then $ Defines=Defines+",NETTRACE"
$
$ Includes = ""
$
$! Initialize compile and link options
$ CC_PREF = ""
$ LINK_OPT = ""
$
$! -------------------------------------------------------------------------
$!    SELECT COMPILER;  DEC C, VAX C or GNU C currently supported
$! -------------------------------------------------------------------------
$
$! Find out which compilers we have
$ HAVEDECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$ HAVEVAXC = F$SEARCH("SYS$SYSTEM:VAXC.EXE")          .NES. ""
$ HAVEGNUC = F$SEARCH("GNU_CC:[000000]GCC.EXE")       .NES. ""
$
$! ... and which to use in preference (if any)
$ FORCEVAXC = f$locate("VAXC",P1) .lt. f$length(P1)
$ FORCEGNUC = f$locate("GNUC",P1) .lt. f$length(P1)
$ if .not. (HAVEDECC .or. HAVEVAXC .or. HAVEGNUC)
$   then
$     write sys$output "%VMSBUILD-E-NOCC, No supported C compiler detected"
$     exit
$ endif
$
$! Auto-select, in order of preference, the best compiler available
$ COMPILER = ""
$ if (HAVEGNUC) then $ COMPILER = "GNU C"
$ if (HAVEVAXC) then $ COMPILER = "VAX C"
$ if (HAVEDECC) then $ COMPILER = "DEC C"
$
$! Multiple compilers specified?
$ if (FORCEVAXC .and. FORCEGNUC)
$   then
$     write sys$output "%VMSBUILD-E-AMBIG, Multiple C compilers specified"
$     exit
$ endif
$
$! Has user requested GNU C?
$ if FORCEGNUC
$   then
$     if .not. HAVEGNUC
$       then
$         write sys$output "%VMSBUILD-E-NOGNUC, GNUC selected but not installed"
$         exit
$     endif
$     COMPILER = "GNU C"
$ endif
$
$! Has user requested VAX C
$ if (FORCEVAXC)
$   then
$     if .not. HAVEVAXC
$       then
$         write sys$output "%VMSBUILD-E-NOVAXC, VAXC selected but not installed"
$         exit
$     endif
$     COMPILER = "VAX C"
$ endif
$
$ IF (COMPILER .eqs. "GNU C")
$   THEN
$       if f$type(GCC) .nes. ""
$         then
$           CC = GCC		! Defined foreign
$         else
$           CC = "GCC"		! Defined via SET COMMAND
$       endif
$
$	sysdef = "GNU_CC_INCLUDE:[SYS],SYS$LIBRARY"
$       netdef = "GNU_CC_INCLUDE:[VMS],SYS$LIBRARY"
$       arpdef = "GNU_CC_INCLUDE:[VMS],SYS$LIBRARY"
$
$	CC_PREF = CC_PREF + "/DEFINE=(''Defines')"
$       LINK_OPT = LINK_OPT + ",[---]VMS_GCC_LINK/OPTION"
$ ENDIF
$
$ IF (COMPILER .eqs. "VAX C")
$   THEN
$       if (HAVEDECC) then $ CC_PREF = CC_PREF + "/VAXC"
$       
$	sysdef = "SYS$LIBRARY"
$	netdef = "SYS$LIBRARY"
$	arpdef = "SYS$LIBRARY"
$
$	CC_PREF = CC_PREF + "/DEFINE=(''Defines')"
$	LINK_OPT = LINK_OPT + ",[---]VMS_VAXC_LINK/OPTION"
$ ENDIF
$
$ IF (COMPILER .eqs. "DEC C")
$   THEN
$       if (HAVEVAXC) then $ CC_PREF = CC_PREF + "/DECC"
$
$	sysdef = ""
$	netdef = ""
$	arpdef = ""
$
$	CC_PREF = CC_PREF + "/STANDARD=VAXC"
$	CC_PREF = CC_PREF + "/DEFINE=(''Defines')"
$ ENDIF
$
$! Initially have no defines for include files
$ IF F$TRNLNM("SYS")     .NES. "" THEN $ DEASSIGN SYS
$ IF F$TRNLNM("NETINET") .NES. "" THEN $ DEASSIGN NETINET
$ IF F$TRNLNM("ARPA")    .NES. "" THEN $ DEASSIGN ARPA
$
$
$! -------------------------------------------------------------------------
$!  Select network transport to use; NETLIB, MULTINET or NOTCP currently supported
$! -------------------------------------------------------------------------
$!
$! Find out what's available...
$ HAVENETLIB    = f$trnlnm("NETLIB_DIR","LNM$SYSTEM") .nes. ""
$ HAVEMULTINET  = f$trnlnm("MULTINET","LNM$SYSTEM") .nes. ""
$
$! ... Select preferred stack
$ FORCENETLIB   = f$integer(f$locate("NETLIB",P1)   .lt. f$length(P1))
$ FORCEMULTINET = f$integer(f$locate("MULTINET",P1) .lt. f$length(P1))
$ FORCENOTCP    = f$integer(f$locate("NOTCP",P1)    .lt. f$length(P1))
$ if ((FORCEMULTINET + FORCENETLIB + FORCENOTCP) .gt. 1)
$   then
$     write sys$output "%VMSBUILD-E-CONFLTCP, Conflicting TCP stacks specified"
$     exit
$ endif
$
$
$! Pick best stack available
$ NETSTACK = "NO"
$ if (HAVEMULTINET) then $ NETSTACK = "MULTINET"
$ if (HAVENETLIB)   then $ NETSTACK = "NETLIB"
$
$ if (FORCENOTCP)   then $ NETSTACK = "NO"
$
$ if (FORCEMULTINET)
$   then
$     if .not. HAVEMULTINET
$       then
$         write sys$output "%VMSBUILD-E-NOTCP, MULTINET tcp not installed"
$         exit
$     endif
$     NETSTACK = "MULTINET"
$ endif
$
$ if (FORCENETLIB)
$   then
$     if .not. HAVENETLIB
$       then
$         write sys$output "%VMSBUILD-E-NOTCP, NETLIB tcp not installed"
$         exit
$     endif
$     NETSTACK = "NETLIB"
$ endif
$
$
$! Select the appropriate network interface
$ TCPMODULE  = "TCP_VMS_''NETSTACK'"
$ LINK_OPT   = ",[---]VMS_''NETSTACK'_LINK/OPTION" + LINK_OPT
$
$
$! -------------------------------------------------------------------------
$!   Set up /INCLUDE
$! -------------------------------------------------------------------------
$! Set up the includes based on the compiler and network requirements
$ CC_PREF = CC_PREF + "/INCLUDE=([]''includes')"
$
$! -------------------------------------------------------------------------
$!   Set up logical names for system libraries
$! -------------------------------------------------------------------------
$! Set up the defines based on the compiler requirements and the network requirements
$ if (sysdef .nes. "") then $ define /nolog sys     'sysdef'
$ if (netdef .nes. "") then $ define /nolog netinet 'netdef'
$ if (arpdef .nes. "") then $ define /nolog arpa    'arpdef'
$ 
$
$! -------------------------------------------------------------------------
$!   Set up compilation/link options based on debug requirements
$! -------------------------------------------------------------------------
$! Set up debug option
$ if f$locate("DEBUG", P1) .LT F$LENGTH(P1)
$   then
$     CC_PREF = CC_PREF + "/DEBUG/NOOPTIMIZE"
$     LINK = "LINK/DEBUG"
$   else
$     if f$locate("OPTIMIZE",P1) .LT. F$LENGTH(P1)
$       then
$         CC_PREF = CC_PREF + "/OPTIMIZE"	! /OPT is NOT the default !
$       else
$         CC_PREF = CC_PREF + "/NOOPTIMIZE"
$     endif
$     LINK= "LINK"
$     if f$locate("NOTRACEBACK",P1) .LT. F$LENGTH(P1)
$       then
$         LINK_OPT = LINK_OPT + "/NOTRACE"
$     endif
$ endif
$
$ CC_PREF = CC_PREF + "/OBJECT=''OBJDIR'"
$
$ if LINKONLY then $ goto LINK
$
$! -------------------------------------------------------------------------
$! Create VMS specific modules
$! -------------------------------------------------------------------------
$ CREATE LINKAGE.H
$ DECK
#define STDPROTO vmsmailproto
extern DRIVER imapdriver, nntpdriver, vmsmaildriver;
$ EOD
$ CREATE LINKAGE.C
$ DECK
    mail_link((DRIVER *)&imapdriver);
    mail_link((DRIVER *)&nntpdriver);
    mail_link((DRIVER *)&vmsmaildriver);
$ EOD
$ PURGE/nolog LINKAGE.*
$
$!
$ COPY/nolog OS_VMS.H OSDEP.H;	! Get the VMS specific header file in place
$ purge/nolog osdep.h
$
$
$! -------------------------------------------------------------------------
$!   Build the software module(s)
$! -------------------------------------------------------------------------
$ write sys$output "%VMSBUILD-I-CCLIENT, Building C-client library with ", COMPILER, " and ", NETSTACK, " TCP support"
$ if P2 .nes. ""
$   then
$      message = "$ CC" + CC_PREF + " " + P2
$      write/symbol sys$output message
$      CC'CC_PREF' 'P2'
$   else
$ SET VERIFY
$ CC'CC_PREF' OS_VMS
$ CC'CC_PREF' vms_mail
$ CC'CC_PREF' MAIL
$ CC'CC_PREF' SMTP
$ CC'CC_PREF' RFC822
$ CC'CC_PREF' NEWSRC
$ CC'CC_PREF' NNTP
$ CC'CC_PREF' nntpcvms
$ CC'CC_PREF' MISC
$ CC'CC_PREF' IMAP2
$ CC'CC_PREF' SM_VMS
$ CC'CC_PREF' 'TCPMODULE'
$!
$ CC'CC_PREF' MTEST
$ CC'CC_PREF' [-.IMAPD]IMAPD
$ CC'CC_PREF' [-.IPOPD]IPOP3D
$ SET NOVERIFY
$ endif
$!
$! -------------------------------------------------------------------------
$!   Create library of callable routines (exclude TCP_xx and main progs)
$! -------------------------------------------------------------------------
$ write sys$output "%VMSBUILD-I-LIBRARY, Creating C-Client library"
$ LIBRARY/OBJECT/CREATE/INSERT 'OLBDIR'C-CLIENT 'OBJDIR'os_vms,'OBJDIR'vms_mail,-
	'OBJDIR'mail,'OBJDIR'smtp,'OBJDIR'rfc822,'OBJDIR'newsrc,'OBJDIR'nntp,-
	'OBJDIR'nntpcvms,'OBJDIR'MISC,'OBJDIR'IMAP2,'OBJDIR'SM_VMS
$ PURGE/nolog 'OLBDIR'C-CLIENT.OLB
$ PURGE/nolog 'OBJDIR'*.OBJ
$
$!
$! -------------------------------------------------------------------------
$!  Link the executables
$! -------------------------------------------------------------------------
$LINK:
$ if COMPILEONLY then $ exit
$ write sys$output "%VMSBUILD-I-LINK, Linking stand-alone MTEST utility with ",NETSTACK, " TCP support"
$ define/user OBJ 'OBJDIR'
$ LINK /EXE='EXEDIR' 'OBJDIR'MTEST,-
   IMAP2,MAIL,MISC,NEWSRC,NNTP,NNTPCVMS,OS_VMS,RFC822,SMTP,SM_VMS,-
   VMS_MAIL'LINK_OPT'
$
$ write sys$output "%VMSBUILD-I-LINK, Linking stand-alone IMAPD server with ", NETSTACK, " TCP support"
$ define/user OBJ 'OBJDIR'
$ LINK /EXE='EXEDIR' 'OBJDIR'IMAPD,-
   IMAP2,MAIL,MISC,NEWSRC,NNTP,NNTPCVMS,OS_VMS,RFC822,SMTP,SM_VMS,-
   VMS_MAIL'LINK_OPT'
$
$ write sys$output "%VMSBUILD-I-LINK, Linking stand-alone POP3 server with ", NETSTACK, " TCP support"
$ define/user OBJ 'OBJDIR'
$ LINK /EXE='EXEDIR' 'OBJDIR'IPOP3D,-
   IMAP2,MAIL,MISC,NEWSRC,NNTP,NNTPCVMS,OS_VMS,RFC822,SMTP,SM_VMS,-
   VMS_MAIL'LINK_OPT'
$
$ PURGE/nolog 'EXEDIR'*.EXE
