$ #pragma module SETUSER "AXP VER-007"p /**************************************************************************************************************/p /*                                                  COPYRIGHT NOTICE                                          */p /*                                                                                                            */p /*  Copyright (c) 1994, 1995, State University of New York at Plattsburgh.  Permission is granted to make and */p /*  distribute copies of this software, provided this disclaimer and copyright notice are preserved on all    */p /*  copies.  This software may not, however, be sold or distributed for profit.  The information in this      */p /*  software is subject to change without notice and should not be construed as a commitment by the copyright */p /*  holder.                                                                                                   */p /*                                                                                                            */p /*                                                     DISCLAIMER                                             */p /*                                                                                                            */p /*  This program is provided "AS IS" without warranty of any kind, either express or implied, including,      */p /*  without limitation, expressed fitness for a particular purpose.  Neither the author, Thomas M. Deso, nor  */p /*  his employer, the State University of New York at Plattsburgh, warrant that the functions contained in    */p /*  this program will meet your requirements, or that the operation of the programs will be uninterrupted or  */p /*  error free.  In no event will the author or his employer be liable for any damages, including, without    */p /*  limitation, incidental or consequential damages, and damages for lost profits, arising out of the use of  */p /*  or inability to use these programs, even if the author and his employer have been advised of the          */p /*  possibility of such damages.                                                                              */p /*                                                                                                            */p /**************************************************************************************************************/p /*                                                                                                            */p /* FACILITY:    Kernel Mode Program for OpenVMS AXP System Management Version 6.1                             */p /*                                                                                                            */p /* ABSTRACT:    This program is a port of VAX/VMS Macro-32 code written by Andrew W. Potter, RIT to DEC C for */p /*              OpenVMS AXP.  SETUSER is a OpenVMS/AXP System Management Utility that allows a privileged     */p /*              user to become any other user on the system.                                                  */p /*                                                                                                            */p /* DESCRIPTION: This program allows a privileged user (CMKRNL, SYSNAM, READALL/SYSPRIV) to change the         */p /*              Username, Account, UIC, Process Name, and Default Directory to that of the specified user.    */p /*              It also changes the Group Logical Name Table and the Ownership of the JOB Logical Name Table, */p /*              allowing the user to turn off elevated privs and spawn a subprocess to simulate that user.    */p /*                                                                                                            */p /* AUTHOR:      Thomas M. Deso (desotm@splava.cc.plattsburgh.edu)  SUNY Plattsburgh                           */p /*                                                                                                            */p /* REVISIONS:   VER-003     OpenVMS/AXP Internals   19-DEC-1994 Initial Version / No Locking             TMD  */p /*              VER-004                             21-DEC-1994 Added Link Opt/#Pragmas/$LCK routine     TMD  */p /*              VER-005                             03-JAN-1995 Added __PAL_PROBER() to $LCK routine     TMD  */p /*              VER-006                             05-JAN-1995 Extended sizeof BlankPadded buffers      TMD  */p /*              VER-007                             17-JAN-1995 Remove Locking Code.  Was not needed.    TMD  */p /*                                                                                                            */p /**************************************************************************************************************/  6 /* Define system data structure types and constants */  D #include <builtins.h>                       /* For Alpha Builtins */D #include <string.h>                         /* __MEMCPY() Builtin */I #include <starlet.h>                        /* System Service Routines */  #include <stdio.h>H #include <ssdef.h>                          /* System Service Results */D #include <descrip.h>                        /* String Descriptors */B #include <pcbdef.h>                         /* Structure of PCB */B #include <jibdef.h>                         /* Structure of JIB */; #include <uaidef.h>                         /* $GETUAI() */ B #include <uicdef.h>                         /* Structure of UIC */A #include <ctype.h>                          /* Isspace() Macro */ J #include <lnmdef.h>                         /* Logical Name Translation */> #include <psldef.h>                         /* Access Modes */I #include <ossdef.h>                         /* $SET_SECURITY() Service */ C #include <syidef.h>                         /* $GETSYI() Service */      /* Define some Psuedo-Types */  7 typedef unsigned long                            ULONG; 8 typedef unsigned short                           USHORT;7 typedef unsigned char                            UCHAR; & typedef struct { USHORT buffer_length;"                  USHORT item_code;'                  ULONG  buffer_address; 9                  ULONG  return_length_address; } ITMLST3;     > /* Reference External Memory Locations in Control (P1) Page */  O extern PCB  *CTL$GL_PCB;                    /* Pointer to this Process's PCB */ B extern UCHAR CTL$T_ACCOUNT[8];              /* Account Name [8] */@ extern UCHAR CTL$T_USERNAME[12];            /* User Name [12] */    , /* Define some program specific constants */  L #define  FUDGE   5                          /* Extend for String Overflow */W #define  UNLEN   12                         /* Sizeof Username String in CTL and JIB */ V #define  ACLEN   8                          /* Sizeof Account String in CTL and JIB */L #define  DEVLEN  32                         /* Maximum Device Name Length */O #define  DIRLEN  64                         /* Maximum Directory Name Length */ % #define  LNMOBJ  "LOGICAL_NAME_TABLE" ( #define  LNMPDT  "LNM$PROCESS_DIRECTORY" #define  LNMJOB  "LNM$JOB"$ #define  LNMPT   "LNM$PROCESS_TABLE"     /* Global Variables */  W char         NewUserName[DIRLEN],       NewAccount[ACLEN+FUDGE];  /* Null Terminated */ T char         NewUserNameP[UNLEN+FUDGE], NewAccountP[ACLEN+FUDGE]; /* Blank Padded */: char         NewDefDev[DEVLEN],         NewDefDir[DIRLEN];? char         NewDevDir[DEVLEN+DIRLEN],  GroupTableName[DEVLEN];  union uicdef NewUic;     /* Function Declarations */   Z ULONG   uaf_lookup(char *nam, char *accnt, char *defdev, char *defdir, union uicdef *uic); ULONG   set_jobown(ULONG *uic); E ULONG   define_logical(char *tab, char *log, UCHAR *mode, char *equ);  ULONG   set_defdir(char *str); ULONG   set_procnam(char *str);  void    write_jibctl(void);       P /******************************************************************************/P /* MAIN()  Setuser - become an other user on the system.                      */P /******************************************************************************/  int main(int argc, char *argv[])     {      ULONG status;      char *s;    M     /* Get New Username as an argument or prompt for it, then Uppercase it */        s = NewUserName;     if(argc < 2) {         printf("_Usercode: ");         gets(s); }     else         strcpy(s,argv[1]);$     while((*s) && (! isspace(*s))) {         *s = toupper(*s);          ++s; }     *s = 0; f     sprintf(NewUserNameP,"%-*s",UNLEN,NewUserName);                 /* Format Blank-Filled Username */    W     /* Fetch Information about this NewUserName from the System UAF, then display it */   a     if((status = uaf_lookup(NewUserName,NewAccount,NewDefDev,NewDefDir,&NewUic)) != SS$_NORMAL) { F         printf("%%SETUSER-F-NOUSER, user %s not found\n",NewUserName);         return(status); } ,     printf("\nUsername:  %s\n",NewUserName);4     printf("Directory: %s%s\n",NewDefDev,NewDefDir);J     printf("UIC:       [%o,%o]\n",NewUic.uic$v_group,NewUic.uic$v_member);+     printf("Account:   %s\n\n",NewAccount);     M     /* Change Username, Account and UIC in PCB, JIB and CTL in KERNEL MODE */   l     sprintf(NewAccountP,"%-*s",ACLEN,NewAccount);                   /* Format Blank-Filled Account String */k     SYS$CMKRNL(write_jibctl,0);                                     /* Change Username, UIC, and Account */     (     /* Alter Logical Tables and Names */  k     set_jobown(&(NewUic.uic$l_uic));                                        /* Change Owner of Job Table */ m     sprintf(GroupTableName,"LNM$GROUP_%06o",NewUic.uic$v_group);            /* Format the Group Table Name */ f     sprintf(NewDevDir,"%s%s",NewDefDev,NewDefDir);                          /* Format for Sys$Login */  f     define_logical(LNMPDT,"LNM$GROUP",       &PSL$C_KERNEL,GroupTableName); /* Redefine Group Table */b     define_logical(LNMJOB,"SYS$LOGIN",       &PSL$C_EXEC,  NewDevDir);      /* Define SYS$LOGIN */d     define_logical(LNMJOB,"SYS$SCRATCH",     &PSL$C_EXEC,  NewDevDir);      /* Define SYS$SCRATCH */i     define_logical(LNMJOB,"SYS$LOGIN_DEVICE",&PSL$C_EXEC,  NewDefDev);      /* Define SYS$LOGIN_DEVICE */ a     define_logical(LNMPT, "SYS$DISK",        &PSL$C_EXEC,  NewDefDev);      /* Define SYS$DISK */ a     define_logical(LNMPT, "SYS$DISK",        &PSL$C_SUPER, NewDefDev);      /* Define SYS$DISK */   b     set_procnam(NewUserName);                                               /* Set Process Name */g     set_defdir(NewDefDir);                                                  /* Set Default Directory */      exit(SS$_NORMAL);      }     P /******************************************************************************/P /* UAF_LOOKUP()  Load Information for usr_name from System UAF, Trim and Null */P /*               Terminate all strings, and return SS$_NORMAL on success.     */P /******************************************************************************/n ULONG uaf_lookup(char *usr_name, char *usr_account, char *usr_defdev, char *usr_defdir, union uicdef *usr_uic)     {      ULONG  status;*     char   devbuf[DEVLEN], dirbuf[DIRLEN];g     struct dsc$descriptor_s usrname_dsc = { strlen(usr_name), DSC$K_DTYPE_T, DSC$K_CLASS_S, usr_name }; W     ITMLST3 getuai_itmlst[] = { { sizeof(union uicdef), UAI$_UIC,     usr_uic,     0 }, W                                 { 32,                   UAI$_ACCOUNT, usr_account, 0 }, W                                 { DEVLEN,               UAI$_DEFDEV,  devbuf,      0 }, W                                 { DIRLEN,               UAI$_DEFDIR,  dirbuf,      0 }, .                                 { 0,0,0,0 } };  1     *usr_account = *usr_defdev = *usr_defdir = 0; S     if((status = SYS$GETUAI(0,0,&usrname_dsc,getuai_itmlst,0,0,0)) == SS$_NORMAL) { l         while(! isspace(*usr_account)) ++usr_account;  *usr_account = 0;      /* Terminate Account String */m         *(devbuf + *devbuf+1) = *(dirbuf + *dirbuf+1) = 0;                    /* Terminate Counted Strings */ $         strcpy(usr_defdev,devbuf+1);&         strcpy(usr_defdir,dirbuf+1); }     return(status);      }     P /******************************************************************************/P /* SET_JOBOWN()  Set the Owner of the Job Logical Name Table                  */P /******************************************************************************/& ULONG set_jobown(unsigned long *owner)     {      ULONG context = 0;     char  tabnam[DEVLEN];      $DESCRIPTOR(dtab,LNMPDT);      $DESCRIPTOR(ltab,LNMJOB); b     struct dsc$descriptor_s objnam_dsc = { strlen(LNMOBJ), DSC$K_DTYPE_T, DSC$K_CLASS_S, LNMOBJ };b     struct dsc$descriptor_s tabnam_dsc = { 0,              DSC$K_DTYPE_T, DSC$K_CLASS_S, tabnam };n     ITMLST3 tran[] = { { DEVLEN,               LNM$_STRING, tabnam, &(tabnam_dsc.dsc$w_length) }, {0,0,0,0} };n     ITMLST3 oper[] = { { sizeof(union uicdef), OSS$_OWNER,  owner,  0 },                          {0,0,0,0} };  r     SYS$TRNLNM(0,&dtab,&ltab,&PSL$C_KERNEL,&tran);                                     /* Get Name of JOB Table */s     return(SYS$SET_SECURITY(&objnam_dsc,&tabnam_dsc,0,OSS$M_RELCTX,oper,&context,0));  /* Set Owner of JOB Table */      }     R /********************************************************************************/R /* DEFINE_LOGICAL()  Define a Logical Name at specified mode in specified table */R /********************************************************************************/` ULONG define_logical(char *table_name, char *logical_name, UCHAR *access_mode, char *equ_string)     { j     struct dsc$descriptor_s tabnam =   { strlen(table_name),   DSC$K_DTYPE_T, DSC$K_CLASS_S, table_name };l     struct dsc$descriptor_s lognam =   { strlen(logical_name), DSC$K_DTYPE_T, DSC$K_CLASS_S, logical_name };k     ITMLST3 itmlst[]               = { { strlen(equ_string),   LNM$_STRING,   equ_string, 0 }, {0,0,0,0} };   >     return(SYS$CRELNM(0,&tabnam,&lognam,access_mode,itmlst) );     }     P /******************************************************************************/P /* SET_PROCNAM()  Set the Name of the Current Process (15 chars max)          */P /******************************************************************************/! ULONG set_procnam(char *proc_nam)      { d     struct dsc$descriptor_s descript = { strlen(proc_nam), DSC$K_DTYPE_T, DSC$K_CLASS_S, proc_nam };"     return(SYS$SETPRN(&descript));     }     P /******************************************************************************/P /* SET_DEFDIR()  Set the Default Directory for the Current Process            */P /******************************************************************************/ ULONG set_defdir(char *new_dir)      { b     struct dsc$descriptor_s descript = { strlen(new_dir), DSC$K_DTYPE_T, DSC$K_CLASS_S, new_dir };'     return(SYS$SETDDIR(&descript,0,0));      }     U /***********************************************************************************/ U /* WRITE_JIBCTL()  KERNEL MODE Routine to update the contents of specific CTL, PCB */ U /*                 and JIB locations with New USERNAME, ACCOUNT, and UIC info.     */ U /***********************************************************************************/  void write_jibctl(void)      { e     CTL$GL_PCB->pcb$l_uic = NewUic.uic$l_uic;                                /* Set new UIC in PCB */ j     __MEMCPY(CTL$T_USERNAME,NewUserNameP,UNLEN);                             /* Set new USERNAME in CTL */i     __MEMCPY(CTL$T_ACCOUNT,NewAccountP,ACLEN);                               /* Set new ACCOUNT in CTL */ j     __MEMCPY(CTL$GL_PCB->pcb$l_jib->jib$t_username,NewUserNameP,UNLEN);      /* Set new USERNAME in JIB */i     __MEMCPY(CTL$GL_PCB->pcb$l_jib->jib$t_account,NewAccountP,ACLEN);        /* Set new ACCOUNT in JIB */      }   