/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985 by Supoj Sutanthavibul
 *
 * "Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty."
 *
 * Modified by DMB to work under VMS
 *
 */

#include "fig.h"
#include "mode.h"
#include "resources.h"

/*
 * Beware!  The string returned by this function is static and is
 * reused the next time the function is called!
 */

char *shell_protect_string(string)
    char	   *string;
{
#ifdef VMS
    /* This function isn't needed under VMS */
    return(string);
#else
    static char *buf = 0;
    static int buflen = 0;
    int len = 2 * strlen(string) + 1;
    char *cp, *cp2;

    if (! buf) {
	buf = XtMalloc(len);
	buflen = len;
    }
    else if (buflen < len) {
	buf = XtRealloc(buf, len);
	buflen = len;
    }

    for (cp = string, cp2 = buf; *cp; cp++) {
	*cp2++ = '\\';
	*cp2++ = *cp;
    }

    *cp2 = '\0';

#endif /* VMS */
}

print_to_printer(printer, flushleft, mag)
    char	    printer[];
    Boolean	    flushleft;
    float	    mag;
{
    char	    prcmd[2*PATH_MAX+200], translator[60];
    char	    syspr[2*PATH_MAX+200];
    char	    tmpfile[101];
#ifdef VMS
    char            printfile[101];
    int             errors;
#endif /* VMS */

#ifdef VMS
    sprintf(tmpfile, "%s%s%06d%s", TMPDIR, "xfig-print", getpid(),".TMP");
#else
    sprintf(tmpfile, "%s/%s%06d", TMPDIR, "xfig-print", getpid());
#endif /* VMS */
    if (write_file(tmpfile))
	return;

    /* DMB - Need quotes around capitals to preserve the upper case for VMS */
    sprintf(translator, "fig2dev \"-Lps\" %s \"-P\" -m %f %s",
	    flushleft ? "" : "-c" ,
	    mag,
	    print_landscape ? "-l xxx" : " ");


    if (emptyname(printer)) {	/* send to default printer */
#if defined(VMS)
        sprintf(syspr, "XFIG_PS_PRINT");
#elif defined(SYSV) || defined(SVR4)
	sprintf(syspr, "lp -oPS");
#else
	sprintf(syspr, "lpr -J %s", shell_protect_string(cur_filename));
#endif
	put_msg("Printing figure on default printer in %s mode ...     ",
		print_landscape ? "LANDSCAPE" : "PORTRAIT");
    } else {
#if defined(VMS)
        sprintf(syspr, "XFIG_PS_PRINT /QUEUE=%s", printer);
#elif defined(SYSV) || defined(SVR4)
	sprintf(syspr, "lp -d%s -oPS", printer);
#else
	sprintf(syspr, "lpr -J %s -P%s", shell_protect_string(cur_filename),
		printer);
#endif
	put_msg("Printing figure on printer %s in %s mode ...     ",
		printer, print_landscape ? "LANDSCAPE" : "PORTRAIT");
    }
    app_flush();		/* make sure message gets displayed */

    /* make up the whole translate/print command */
#ifdef VMS
    /* no pipes under VMS :-(  - use second temporary file */
    errors = 0;
    sprintf(printfile, "%s%s%06d%s", TMPDIR, "xfig-temp", getpid(), ".TMP");
    sprintf(prcmd, "%s %s %s", translator, tmpfile, printfile);
    if (system(prcmd) != 1) {
        errors = 1;
	file_msg("Error during PRINT (unable to find fig2dev?)");
    }
    if (!errors) {
        sprintf(prcmd, "%s %s ", syspr, printfile);
        if (system(prcmd) != 1) {
            errors = 1;
	    file_msg("Error during PRINT (unable to find print?)");
	}
    }
    if (!errors) {
#else
    sprintf(prcmd, "%s %s | %s", translator, tmpfile, syspr);
    if (system(prcmd) != 0)
	file_msg("Error during PRINT (unable to find fig2dev?)");
    else {
#endif /* VMS */
	if (emptyname(printer))
	    put_msg("Printing figure on printer %s in %s mode ... done",
		    printer, print_landscape ? "LANDSCAPE" : "PORTRAIT");
	else
	    put_msg("Printing figure on printer %s in %s mode ... done",
		    printer, print_landscape ? "LANDSCAPE" : "PORTRAIT");
    }
    unlink(tmpfile);
}

print_to_file(file, lang, mag, flushleft)
    char	   *file, *lang;
    float	    mag;
    Boolean	    flushleft;
{
    char	    prcmd[2*PATH_MAX+200];
    char	    tmp_name[PATH_MAX];
    char	    tmp_fig_file[PATH_MAX];
    char	   *outfile;
    int		    tlen, status;

    /* if file exists, ask if ok */
    if (!ok_to_write(file, "EXPORT"))
	return (1);

#ifdef VMS
    sprintf(tmp_fig_file, "%s%s%06d%s", TMPDIR, "xfig-fig", getpid(), ".TMP");
#else
    sprintf(tmp_fig_file, "%s/%s%06d", TMPDIR, "xfig-fig", getpid());
#endif /* VMS */
    /* write the fig objects to a temporary file */
    if (write_file(tmp_fig_file))
	return (1);
    outfile = shell_protect_string(file);

    put_msg("Exporting figure to file \"%s\" in %s mode ...     ",
	    file, print_landscape ? "LANDSCAPE" : "PORTRAIT");
    app_flush();		/* make sure message gets displayed */

    /* DMB - Need quotes around capitals to preserve the upper case for VMS */
#ifdef VMS
    if (!strcmp(lang, "PS"))
#else
    if (!strcmp(lang, "ps"))
#endif /* VMS */
	sprintf(prcmd, "fig2dev \"-Lps\" %s \"-P\" -m %f %s %s %s", flushleft ? "" : "-c" ,
		mag, print_landscape ? "-l xxx" : " ", tmp_fig_file,
		outfile);
#ifdef VMS
    else if (!strcmp(lang, "EPS"))
#else
    else if (!strcmp(lang, "eps"))
#endif /* VMS */
	sprintf(prcmd, "fig2dev \"-Lps\" -m %f %s %s %s",
		mag, print_landscape ? "-l xxx" : " ", tmp_fig_file,
		outfile);
#ifdef VMS
    else if (!strcmp(lang, "IBMGL"))
#else
    else if (!strcmp(lang, "ibmgl"))
#endif /* VMS */
	sprintf(prcmd, "fig2dev \"-Libmgl\" -m %f %s %s %s",
		mag, print_landscape ? " " : "\"-P\"", tmp_fig_file,
		outfile);
#ifdef VMS
    else if (!strcmp(lang, "PSTEX_T")) {
#else
    else if (!strcmp(lang, "pstex_t")) {
#endif /* VMS */
	/* make it automatically input the postscript part */
	strcpy(tmp_name, file);
	tlen = strlen(tmp_name);
	if (tlen > 2) {
#ifdef VMS
	    if (tmp_name[tlen-1] == 'T' && tmp_name[tlen-2] == '_')
#else
	    if (tmp_name[tlen-1] == 't' && tmp_name[tlen-2] == '_')
#endif /* VMS */
		tmp_name[tlen-2] = '\0';
	    else
		tmp_name[0] = '\0';
	} else
	    tmp_name[0] = '\0';
	sprintf(prcmd, "fig2dev \"-Lpstex_t\" -p %s -m %f %s %s",
		tmp_name, mag, tmp_fig_file, outfile);
    } else
	sprintf(prcmd, "fig2dev \"-L\"%s -m %f %s %s", lang,
		mag, tmp_fig_file, outfile);
#ifdef VMS
    if (system(prcmd) != 1)
#else
    if (system(prcmd) != 0)
#endif /* VMS */
	file_msg("Error during EXPORT (unable to find fig2dev?)");
    else
	put_msg("Exporting figure to file \"%s\" in %s mode ... done",
		file, print_landscape ? "LANDSCAPE" : "PORTRAIT");

    unlink(tmp_fig_file);
    return (0);
}
