> /* Copyright (C) 1995 Alexey Gadzhiev (alexey@ace.elektra.ru).)  * CRS comes with ABSOLUTELY NO WARRANTY. @  * This program is free software; you can redistribute it and/or@  * modify it under the terms of the GNU  General Public License.&  * (see file copying.txt for details).  */ 5 /* VAX/DEC CMS REPLACEMENT HISTORY, Element QSORT.C*/ B /* *1    14-APR-1994 14:42:13 ALEXEY "VAXC versions whith BUG ."*/5 /* VAX/DEC CMS REPLACEMENT HISTORY, Element QSORT.C*/  /*- N  * Copyright (c) 1980, 1983, 1990 The Regents of the University of California.  * All rights reserved.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   */   ( #if defined(LIBC_SCCS) && !defined(lint)< static char sccsid[] = "@(#)qsort.c	5.9 (Berkeley) 2/23/91";# #endif /* LIBC_SCCS and not lint */    #include <stddef.h>  /*F  * MTHRESH is the smallest partition for which we compare for a median+  * value instead of using the middle value.   */  #define	MTHRESH	6    /*G  * THRESH is the minimum number of entries in a partition for continued   * partitioning.  */  #define	THRESH	4   /*L  * Swap two areas of size number of bytes.  Although qsort(3) permits randomJ  * blocks of memory to be sorted, sorting pointers is almost certainly theK  * common case (and, were it not, could easily be made so).  Regardless, it K  * isn't worth optimizing; the SWAP's get sped up by the cache, and pointer K  * arithmetic gets lost in the time required for comparison function calls.   */  #define	SWAP(a, b) { \ 	cnt = size; \ 	do { \  		ch = *a; \ 		*a++ = *b; \ 		*b++ = ch; \ 	} while (--cnt); \  }    /*J  * Knuth, Vol. 3, page 116, Algorithm Q, step b, argues that a single passK  * of straight insertion sort after partitioning is complete is better than M  * sorting each small partition as it is created.  This isn't correct in this J  * implementation because comparisons require at least one (and often two)J  * function calls and are likely to be the dominating expense of the sort.H  * Doing a final insertion sort does more comparisons than are necessaryJ  * because it compares the "edges" and medians of the partitions which are  * known to be already sorted.  *H  * This is also the reasoning behind selecting a small THRESH value (seeI  * Knuth, page 122, equation 26), since the quicksort algorithm does less '  * comparisons than the insertion sort.   */  #define	SORT(bot, n) { \
 	if (n > 1) \  		if (n == 2) { \  			t1 = bot + size; \  			if (compar(t1, bot) < 0) \  				SWAP(t1, bot); \
 		} else \* 			insertion_sort(bot, n, size, compar); \ }      static void ( insertion_sort(bot, nmemb, size, compar) 	char *bot;  	register int size;  	int nmemb, (*compar)(); {  	register int cnt; 	register unsigned ch;( 	register char *s1, *s2, *t1, *t2, *top;   	/* B 	 * A simple insertion sort (see Knuth, Vol. 3, page 81, AlgorithmD 	 * S).  Insertion sort has the same worst case as most simple sortsB 	 * (O N^2).  It gets used here because it is (O N) in the case of 	 * sorted data. 	 */ 	top = bot + nmemb * size;# 	for (t1 = bot + size; t1 < top;) { < 		for (t2 = t1; (t2 -= size) >= bot && compar(t1, t2) < 0;); 		if (t1 != (t2 += size)) { . 			/* Bubble bytes up through each element. */" 			for (cnt = size; cnt--; ++t1) {
 				ch = *t1; 3 				for (s1 = s2 = t1; (s2 -= size) >= t2; s1 = s2)  					*s1 = *s2; 
 				*s1 = ch;  			} 		} else 			t1 += size; 	} }        static void $ quick_sort(bot, nmemb, size, compar) 	register char *bot; 	register int size;  	int nmemb, (*compar)(); {  	register int cnt; 	register unsigned ch;$ 	register char *top, *mid, *t1, *t2; 	register int n1, n2;  	char *bsv;   ) 	/* bot and nmemb must already be set. */ 
 partition:    	/* find mid and top elements */! 	mid = bot + size * (nmemb >> 1);   	top = bot + (nmemb - 1) * size;   	/* E 	 * Find the median of the first, last and middle element (see Knuth, C 	 * Vol. 3, page 123, Eq. 28).  This test order gets the equalities 
 	 * right. 	 */ 	if (nmemb >= MTHRESH) { 		n1 = compar(bot, mid); 		n2 = compar(mid, top); 		if (n1 < 0 && n2 > 0) ) 			t1 = compar(bot, top) < 0 ? top : bot;  		else if (n1 > 0 && n2 < 0)) 			t1 = compar(bot, top) > 0 ? top : bot;  		else 			t1 = mid;  9 		/* if mid element not selected, swap selection there */  		if (t1 != mid) { 			SWAP(t1, mid);  			mid -= size;  		}  	}  @ 	/* Standard quicksort, Knuth, Vol. 3, page 116, Algorithm Q. */ #define	didswap	n1 #define	newbot	t1  #define	replace	t2
 	didswap = 0;  	for (bsv = bot;;) {: 		for (; bot < mid && compar(bot, mid) <= 0; bot += size); 		while (top > mid) {  			if (compar(mid, top) <= 0) {  				top -= size;
 				continue;  			}5 			newbot = bot + size;	/* value of bot after swap */ 1 			if (bot == mid)		/* top <-> mid, mid == top */  				replace = mid = top; 			else {			/* bot <-> top */  				replace = top; 				top -= size; 			}
 			goto swap;  		}  		if (bot == mid) 	 			break;    		/* bot <-> mid, mid == bot */  		replace = mid;4 		newbot = mid = bot;		/* value of bot after swap */ 		top -= size;   swap:		SWAP(bot, replace); 		bot = newbot;  		didswap = 1; 	}   	/* D 	 * Quicksort behaves badly in the presence of data which is alreadyF 	 * sorted (see Knuth, Vol. 3, page 119) going from O N lg N to O N^2.B 	 * To avoid this worst case behavior, if a re-partitioning occursD 	 * without swapping any elements, it is not further partitioned andE 	 * is insert sorted.  This wins big with almost sorted data sets and D 	 * only loses if the data set is very strangely partitioned.  A fixG 	 * for those data sets would be to return prematurely if the insertion D 	 * sort routine is forced to make an excessive number of swaps, and 	 * continue the partitioning. 	 */ 	if (!didswap) {+ 		insertion_sort(bsv, nmemb, size, compar); 	 		return;  	}   	/* A 	 * Re-partition or sort as necessary.  Note that the mid element 6 	 * itself is correctly positioned and can be ignored. 	 */ #define	nlower	n1  #define	nupper	n2  	bot = bsv; ; 	nlower = (mid - bot) / size;	/* size of lower partition */ 
 	mid += size; ; 	nupper = nmemb - nlower - 1;	/* size of upper partition */    	/* B 	 * If must call recursively, do it on the smaller partition; this% 	 * bounds the stack to lg N entries.  	 */ 	if (nlower > nupper) {  		if (nupper >= THRESH) ) 			quick_sort(mid, nupper, size, compar);  		else { 			SORT(mid, nupper);  			if (nlower < THRESH) {  				SORT(bot, nlower); 				return;  			} 		}  		nmemb = nlower; 	 	} else {  		if (nlower >= THRESH) ) 			quick_sort(bot, nlower, size, compar);  		else { 			SORT(bot, nlower);  			if (nupper < THRESH) {  				SORT(mid, nupper); 				return;  			} 		}  		bot = mid; 		nmemb = nupper;  	} 	goto partition; 	/* NOTREACHED */  }    void# bsd_qsort(bot, nmemb, size, compar)  	void *bot;  	size_t nmemb, size;, 	int (*compar) (const void *, const void *); {      	if (nmemb <= 1)	 		return;    	if (nmemb >= THRESH) ' 		quick_sort(bot, nmemb, size, compar);  	else + 		insertion_sort(bot, nmemb, size, compar);  }   