 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** ** Module: VMS_MISC  ** ** Abstract:> **	This module includes all the functions that access VMSmail.A **	These functions provide a clean interface to perform mail file 
 **	access. **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	18-APR-1993 ** ** Modifications History: ( **	EML001		Eric M. LaFranchi	14-Jan-19944 **	Added support for selecting the mailfile to read. ** **-+-  */   #include <ctype.h>			/* */9 #include <stdio.h>			/* Standard I/O definitions.	     */ = #include <stdlib.h>			/* Standard library definitions.     */ = #include <string.h>			/* Standard string definitions.      */ : #include <maildef.h>			/* mail service definitions	     */< #include <descrip.h>			/* VMS descriptor definitions	     */: #include <ssdef.h>			/* Standard VMS messages code	     */ #include "vmsdef.h"  #include "msgdef.h"  #include "packdef.h"  E     /* define mail messages codes not in maildef.h. Values taken from       * sys$library starlet.req      */  #ifndef MAIL$_MSGTEXT  #define MAIL$_MSGTEXT 8322305  #endif   #ifndef MAIL$_NOMOREREC  #define MAIL$_NOMOREREC 8314792  #endif   #ifndef MAIL$_NOMOREMSG  #define MAIL$_NOMOREMSG	8290386  #endif   #ifndef MAIL$_NOTEXIST #define MAIL$_NOTEXIST	8290522 #endif   #define MAIL_C_BUFSIZ 256   "     /* extern function declaration      */ * void	LIB$ESTABLISH( const size_t (*)( ) );  6 size_t	handler( struct chf$signal_array *signal_array,' 		 struct chf$mech_array *mech_array );   S size_t	MAIL$MAILFILE_BEGIN( void **, const ITMLST * const , const ITMLST * const ); Q size_t	MAIL$MAILFILE_OPEN( void **, const ITMLST * const, const ITMLST * const ); R size_t	MAIL$MAILFILE_CLOSE( void **, const ITMLST * const, const ITMLST * const );P size_t	MAIL$MAILFILE_END( void **, const ITMLST * const, const ITMLST * const );R size_t	MAIL$MESSAGE_BEGIN( void **, const ITMLST * const, const ITMLST * const ); S size_t	MAIL$MESSAGE_DELETE( void **, const ITMLST * const, const ITMLST * const );  Q size_t	MAIL$MESSAGE_COPY( void **, const ITMLST * const, const ITMLST * const );  Q size_t	MAIL$MESSAGE_INFO( void **, const ITMLST * const, const ITMLST * const );  S size_t	MAIL$MESSAGE_SELECT( void **, const ITMLST * const, const ITMLST * const );  P size_t	MAIL$MESSAGE_GET( void **, const ITMLST * const, const ITMLST * const ); P size_t	MAIL$MESSAGE_END( void **, const ITMLST * const, const ITMLST * const ); O size_t	MAIL$USER_BEGIN( void **, const ITMLST * const, const ITMLST * const );  R size_t	MAIL$USER_SET_INFO( void **, const ITMLST * const, const ITMLST * const ); M size_t	MAIL$USER_END( void **, const ITMLST * const, const ITMLST * const );     struct context { 6     void *mfcontext;			/* mail file context pointer	*/5     void *msgcontext;			/* message context pointer	*/ C     unsigned int article_count;		/* article count in folder      */  };   #ifdef VAXC  #pragma nostandard #endifA extern size_t (*pack_connect)( void **const, const char *const ); C extern size_t (*select_articles)( void *const, const char *const ); J extern size_t (*scan_articles)( void *const, size_t (*)(), const void * );[ extern size_t (*extract_articles)( void *const, const size_t, size_t (*)(), const void * ); ? extern size_t (*cleanup_articles)( void *const, const size_t ); , extern size_t (*disconnect)( void **const );  # extern const unsigned int gblflags;    #ifdef VAXC  #pragma standard #endif  7 static const ITMLST nullitem[ ] = { 0, 0, NULL, NULL };      /*  *+-+   *  * Function: mail_open  *  * Abstract:C  *	mail_open localizes the opening of the mail file and sets up the "  *	context for message processing.  *
  * Inputs:G  *	context -- address of a pointer to structure that will contains mail ,  *		   file and message context information.  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t   mail_open( void **const context,  	   const char *const mailfile ) { "     static ITMLST in_itmlst[ ] = {D 	{ sizeof( struct context * ), MAIL$_MESSAGE_FILE_CTX, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  $     static ITMLST open_itmlst[ ] = {( 	{ 0, MAIL$_MAILFILE_NAME, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   5     cxt = (struct context *)malloc( sizeof( *cxt ) );      if ( cxt == NULL )) 	raise_exception( PACKASM_INSVIRMEM, 0 );   H     status = MAIL$MAILFILE_BEGIN( &cxt->mfcontext, nullitem, nullitem );+     if ( !(status & 1) ) return ( status );   *     if ( mailfile && mailfile[0] != '\0' )     { , 	open_itmlst[0].buflen = strlen( mailfile );* 	open_itmlst[0].bufadr = (char *)mailfile;     }   J     status = MAIL$MAILFILE_OPEN( &cxt->mfcontext, open_itmlst, nullitem );+     if ( !(status & 1) ) return ( status );   *     in_itmlst[0].bufadr = &cxt->mfcontext;I     status = MAIL$MESSAGE_BEGIN( &cxt->msgcontext, in_itmlst, nullitem ); +     if ( !(status & 1) ) return ( status );        cxt->article_count = 0;      *context = cxt;        return ( SS$_NORMAL ); }    /*  *+-+   *  * Function: mail_select_folder   *  * Abstract:3  *	This function selects the specified mail folder.   *
  * Inputs:G  *	context -- address of a pointer to structure that contains mail file &  *		   and message context information  *$  *	folder -- pointer to folder name.  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ( mail_select_folder( void *const context,  		    const char *const folder ) { #     static ITMLST folderitem[ ] = { ) 	{ 0, MAIL$_MESSAGE_FOLDER, NULL, NULL },  	{ 0, 0, NULL, NULL } };  #     static ITMLST msgcntitem[ ] = { @ 	{ sizeof( unsigned int ), MAIL$_MESSAGE_SELECTED, NULL, NULL }, 	{ 0, 0, NULL, NULL } };       unsigned int msgcnt;!     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;  1 	/* fill in folders and message count descriptors  	 */#     msgcntitem[0].bufadr = &msgcnt; ,     folderitem[0].buflen = strlen( folder );*     folderitem[0].bufadr = (char *)folder;  M     status = MAIL$MESSAGE_SELECT( &cxt->msgcontext, folderitem, msgcntitem );      if ( !(status & 1) ) 	return ( status );         cxt->article_count = msgcnt;       return ( SS$_NORMAL ); }    /*  *+-+   *  * Function: mail_scan_articles   *  * Abstract:D  *	This routine scans the specified VMSmail folder for subject linesE  *	that have packages that match the specified package name and other H  *	specified criteria. If a match is found the folder and article number*  *	passed to the add_part_record function.  *
  * Inputs:?  *	context -- pointer to structure that will contains mail file '  *		   and message context information. 4  *	packname -- pointer to package to compare against/  *	before -- pointer to user specified VMS time .  *	since -- pointer to user specified VMS time  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ( mail_scan_articles( void *const context," 		    size_t (*const callback)( ), 		    const void *callarg )  { "     static ITMLST msgiditem[ ] = {: 	{ sizeof( unsigned int ), MAIL$_MESSAGE_ID, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  !     static ITMLST infoitem[ ] = { * 	{ 0, MAIL$_MESSAGE_SUBJECT, NULL, NULL },. 	{ 0, MAIL$_MESSAGE_BINARY_DATE, NULL, NULL }, 	{ 0, 0, NULL, NULL } };        char subject[MAIL_C_BUFSIZ];(     unsigned int msgid, sublen, date[2];  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;   	/* item to be selected  	 */!     msgiditem[0].bufadr = &msgid;   /     infoitem[0].buflen = sizeof( subject ) - 1; !     infoitem[0].bufadr = subject; !     infoitem[0].retlen = &sublen;      infoitem[1].bufadr = date;(     infoitem[1].buflen = sizeof( date );  > 	/* select each message in the folder, then * try to determine< 	 * if it this part of the package we are trying to extract. 	 */;     for ( msgid = 1; msgid <= cxt->article_count; msgid++ )      { E 	status = MAIL$MESSAGE_INFO( &cxt->msgcontext, msgiditem, infoitem );  	if ( !(status & 1) )  	    return ( status );    	subject[sublen] = '\0';  4 	status = callback( callarg, subject, msgid, date ); 	if ( !(status & 1) )  	    continue;     }        return ( SS$_NORMAL ); }    /*  *+-+   *!  * Function: mail_extract_article   *  * Abstract:B  *	This function locates specified part using the folder and msgid%  *	information specified by the user.   *
  * Inputs:  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t * mail_extract_article( void *const context,! 		      const unsigned int msgid, $ 		      size_t (*const callback)( ), 		      const void *callarg )  { "     static ITMLST msgiditem[ ] = {: 	{ sizeof( unsigned int ), MAIL$_MESSAGE_ID, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  %     static ITMLST continueitem[ ] = { + 	{ 0, MAIL$_MESSAGE_CONTINUE, NULL, NULL },  	{ 0, 0, NULL, NULL } };  #     static ITMLST recorditem[ ] = { ) 	{ 0, MAIL$_MESSAGE_RECORD, NULL, NULL },  	{ 0, 0, NULL, NULL } };  $     char mail_record[MAIL_C_BUFSIZ];     unsigned int record_length; !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;   	/* select message 	 */1     msgiditem[0].bufadr = (unsigned int *)&msgid; G     status = MAIL$MESSAGE_GET( &cxt->msgcontext, msgiditem, nullitem );      if ( !(status & 1) ) 	return ( status );   1     recorditem[0].buflen = sizeof( mail_record ); '     recorditem[0].bufadr = mail_record; *     recorditem[0].retlen = &record_length;  : 	    /* read records from mail file and write to VMS file. 	     */     for ( ;; )     { I 	status = MAIL$MESSAGE_GET( &cxt->msgcontext, continueitem, recorditem );   ! 	if ( status == MAIL$_NOMOREREC )  	    break;  	  	if ( !(status & 1) )  	    return ( status );   # 	mail_record[record_length] = '\0';   + 	status = callback( callarg, mail_record );  	if ( !(status & 1) )  	    return (status );     }        return ( SS$_NORMAL ); }    /*  *+-+   *   * Function: mail_delete_article  *  * Abstract::  *	this routine delete the specified mail article from the  *	previously selected folder.  *
  * Inputs:B  *	context -- address of a pointer to structure that contains mail,  *		   file and message context information.@  *	msgid -- article identification for the article to be deleted  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ) mail_delete_article( void *const context, ! 		     const unsigned int msgid )  { "     static ITMLST msgiditem[ ] = {4 	{ sizeof( size_t ), MAIL$_MESSAGE_ID, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;   	/* article to be deleted  	 */1     msgiditem[0].bufadr = (unsigned int *)&msgid;   J     status = MAIL$MESSAGE_DELETE( &cxt->msgcontext, msgiditem, nullitem );     if ( !(status & 1) ) 	return (status );       return ( SS$_NORMAL ); }      /*  *+-+   *  * Function: mail_copy_article  *  * Abstract:A  *	this routine copies a message from the currently select folder   *	to the specified folder  *
  * Inputs:G  *	context -- address of a pointer to structure that will contains mail ,  *		   file and message context information.@  *	msgid -- article identification for the article to be deleted>  *	folder -- pointer to folder name of the folder to which the  *		  message is to be copied.  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ' mail_copy_article( void *const context,  		   const unsigned int msgid, 		   const char *const folder )  { !     static ITMLST copyitem[ ] = { 4 	{ sizeof( size_t ), MAIL$_MESSAGE_ID, NULL, NULL },) 	{ 0, MAIL$_MESSAGE_FOLDER, NULL, NULL },  	{ 0, 0, NULL, NULL } };  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;   	/* article to be copied 	 */0     copyitem[0].bufadr = (unsigned int *)&msgid;*     copyitem[1].buflen = strlen( folder );(     copyitem[1].bufadr = (char *)folder;  G     status = MAIL$MESSAGE_COPY( &cxt->msgcontext, copyitem, nullitem );      if ( !(status & 1) ) 	return (status );       return ( SS$_NORMAL ); }    /*  *+-+   *  * Function: mail_move_article  *  * Abstract:A  *	this routine copies a message from the currently select folder   *	to the specified folder  *
  * Inputs:G  *	context -- address of a pointer to structure that will contains mail ,  *		   file and message context information.@  *	msgid -- article identification for the article to be deleted>  *	folder -- pointer to folder name of the folder to which the  *		  message is to be copied.  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ' mail_move_article( void *const context,  		   const unsigned int msgid, 		   const char *const folder )  {      register size_t status;   $ 	/* copy article to specified folder 	 */9     status = mail_copy_article( context, msgid, folder );      if ( !(status & 1) ) 	return (status );  9 	/* delete the specified article from the selected folder  	 */3     status = mail_delete_article( context, msgid );      if ( !(status & 1) ) 	return (status );       return ( SS$_NORMAL ); }    /*  *+-+   *  * Function: mail_newmail_count   *  * Abstract:?  *	This function sets the correct message count in the new mail 
  *	folder.  *
  * Inputs:G  *	context -- address of a pointer to structure that contains mail file &  *		   and message context information  *$  *	folder -- pointer to folder name.  *  * Outputs:   *	None   *  * Returns: )  *	returns VMS status error or SS$_NORMAL   *  *-+-   */ 
 static size_t ) mail_newmail_count( void *const context )  { #     static ITMLST folderitem[ ] = { ) 	{ 0, MAIL$_MESSAGE_FOLDER, NULL, NULL }, # 	{ 0, MAIL$_NOSIGNAL, NULL, NULL },  	{ 0, 0, NULL, NULL } };  #     static ITMLST msgcntitem[ ] = { : 	{ sizeof( size_t ), MAIL$_MESSAGE_SELECTED, NULL, NULL }, 	{ 0, 0, NULL, NULL } };  #     static ITMLST newcntitem[ ] = { ( 	{ 0, MAIL$_USER_USERNAME, NULL, NULL },G 	{ sizeof( unsigned short ), MAIL$_USER_SET_NEW_MESSAGES, NULL, NULL }, # 	{ 0, MAIL$_NOSIGNAL, NULL, NULL },  	{ 0, 0, NULL, NULL } };       void *lcontext = NULL;     char username[12];     unsigned int msgcnt;  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;   	/* Use default NEWMAIL folder 	 */#     msgcntitem[0].bufadr = &msgcnt; 3     folderitem[0].buflen = sizeof( "NEWMAIL" ) - 1; %     folderitem[0].bufadr = "NEWMAIL";   @ 	/* select the folder "NEWMAIL". Assume that an error means that> 	 * the folder doesn't exist, so there's a zero message count. 	 */M     status = MAIL$MESSAGE_SELECT( &cxt->msgcontext, folderitem, msgcntitem );      if ( !(status & 1) )     {   	if ( status != MAIL$_NOTEXIST ) 	    return ( status );  	msgcnt = 0;     }         cxt->article_count = msgcnt;  :     status = get_username( username, sizeof( username ) );     if ( !(status & 1) )1 	raise_exception( PACKASM_INTERNERR, 0, status );9  >     status = MAIL$USER_BEGIN( &lcontext, nullitem, nullitem );     if ( !(status & 1) ) 	 return ( status );  .     newcntitem[0].buflen = sizeof( username );$     newcntitem[0].bufadr = username;#     newcntitem[1].bufadr = &msgcnt;   C     status = MAIL$USER_SET_INFO( &lcontext, newcntitem, nullitem );r     if ( !(status & 1) ) 	return ( status );e  <     status = MAIL$USER_END( &lcontext, nullitem, nullitem );     if ( !(status & 1) ) 	return ( status );t       return ( SS$_NORMAL ); }e c /*  *+-+d  *  * Function: mail_close.  *  * Abstract:B  *	close_mail localizes the releasing of mail file message context  *	and close the mail file.n  *
  * Inputs:G  *	context -- address of a pointer to structure that contains mail file &  *		   and message context information  *  * Outputs:s  *	Nonea  *  * Returns:t)  *	returns VMS status error or SS$_NORMALt  *  *-+-i  */L
 static size_t*" mail_close( void **const context ) {*!     register struct context *cxt;	     register size_t status;4       LIB$ESTABLISH( handler );t  %     cxt = (struct context *)*context;i  '     status = mail_newmail_count( cxt );>+     if ( !(status & 1) ) return ( status );c  G     status = MAIL$MESSAGE_END( &cxt->msgcontext, nullitem, nullitem  );g+     if ( !(status & 1) ) return ( status );   H     status = MAIL$MAILFILE_CLOSE( &cxt->mfcontext, nullitem, nullitem );+     if ( !(status & 1) ) return ( status );/  F     status = MAIL$MAILFILE_END( &cxt->mfcontext, nullitem, nullitem );+     if ( !(status & 1) ) return ( status );k       *context = NULL;     free( cxt );       return ( SS$_NORMAL ); }f   /*  *+-+s  *   * Function: mail_load_addresses  *  * Abstract:?  *	this routine loads the addresses of all the mail routines in   *	the global data structures.  *
  * Inputs:  *	NoneL  *  * Outputs:f2  *	global function	pointer to mail routines loaded  *  * Returns:n)  *	returns VMS status error or SS$_NORMAL   *  *-+-I  */  size_t load_VMSmail_routines( ) {n     pack_connect = mail_open; )     select_articles = mail_select_folder;t'     scan_articles = mail_scan_articles;s,     extract_articles = mail_extract_article;+     cleanup_articles = mail_delete_article;      disconnect = mail_close;       return ( PACKASM_SUCCESS );  } 