 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  **
 ** Module: **	PACK_PACKAGE.C  ** ** Abstract:= **	This module contains the routines to manage assembling and A **	extracting package parts. All the data structures that contain ? **	package information are contained in this module and package A **	information is only accessible though the provided interfaces.  **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	22-APR-1993 ** ** Special Notes: I **	The routine uudecode was based on: "uudecode.c 5.3 (Berkeley) 4/10/85"  ** ** Modification History:( **	EML006		Eric M. LaFranchi	14-Dec-1994? **	Added coded to pack_validate to pad an input string with the @ **	appropriate number of spaces if there are too few characters.: **      Courtesy of Peder Dahlberg: Modified pack_deliver  **( **	EML005		Eric M. LaFranchi	14-Jan-1994F **	Added pack_validate routine to check a string and determine if they5 **	all the characters are valid UUencoded characters.  **( **	EML004		Eric M. LaFranchi	23-Oct-19935 **	Enhanced support for more generic subject parsing.  **( **	EML003		Eric M. LaFranchi	23-Oct-19931 **	Fixed confirm message for deleting mail parts.  **( **	EML002		Eric M. LaFranchi	09-SEP-1993A **	Added pack_extract_by_article routine and supporting routines.  **( **	EML001		Eric M. LaFranchi	20-JUN-1993B **	Moved code that opened output file and added logic that allowedC **	for a directory and/or file specification to be used for output.  **( **	EML000		Eric M. LaFranchi	29-MAY-1993D **	Added cleanup code that is conditional called by the depending onI **	the state of the CLEANUP flag. Added decode logic for uuencoded files.  ** **-+-  */ #include <ctype.h> #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <stsdef.h>  #include "msgdef.h"  #include "packdef.h" #include "vmsdef.h"   4     /* define hash table size to a reasonable number      * for this application.      */  #define HASHTBLSIZ 61   E     /* defined the default number of message expected to be contained ?      * in one folder. Note this is a default and not a maximum.       */  #define DEFMSGCNT 48  H     /* default size for article table. Assume the user specifies package      * with less than 32 parts.       */  #define ARTICLE_TABLE_SIZE 32   9     /* define local constants that maintain package state       */  #define STATE_M_ZEROPART	0x0000   #define STATE_M_DUPLICATE	0x0001  #     /* define part record structure       */  struct part_record { 6     size_t package_part;		/* package part number		  */@     size_t article_number;		/* mail folder or newsgroup index */H     char article_folder[PACBUFSIZ];	/* mail folder or newsgroup name  */ };  #     /* define part record structure       */  struct cpart_record  { /     size_t part;			/* package part number		  */ 9     size_t number;			/* mail folder or newsgroup index */ B     char package[PACBUFSIZ];		/* mail folder or newsgroup name  */ };  &     /* define package record structure      */  struct package_record  { @     struct package_record *next;	/* pointer down hash chain	  */8     unsigned int	state;   	/* number of parts found	  */8     unsigned int	found;   	/* number of parts found	  */=     unsigned int	expected;	/* number of parts in package	  */ 5     unsigned int	last;		/* last part in package		  */ 4     char 		package[PACBUFSIZ]; /* package name		  */D     struct part_record  parts[1];	/* article part array records	  */ };  &     /* define cleanup record structure      */  struct cleanup_record  { @     struct cleanup_record *next;	/* pointer down hash chain	  */2     char 		folder[PACBUFSIZ]; /* folder name		  */*     size_t		size;		/* structure size		  *//     size_t		article_cnt;	/* article count		  */ 1     size_t		article_max;	/* article maximum		  */ L     struct cpart_record	article[DEFMSGCNT];/* article part array records  */ };  &     /* define message record structure      */  struct message_record  { ,     FILE 		*fp;		/* output file pointer		 */7     unsigned int	state;   	/* number of parts found	 */ .     unsigned int	part;   	/* part number			 */A     unsigned int	expected;   	/* expected number of parts      */ 5     unsigned int	flags;		/* user specified flags		 */ ;     char 		defspec[PACBUFSIZ]; /* default specification	 */ 3     char 		package[PACBUFSIZ]; /* package name		 */ >     char 		outfil[PACBUFSIZ];  /* output file specification */ };  $     /* external function definitions      */  #ifdef VAXC  #pragma nostandard #endif  C extern size_t (*select_articles)( void *const, const char *const );  extern size_t (*extract_articles)( void *const, const size_t, size_t (*)(struct message_record *reccxt, const char *const record), const void * );? extern size_t (*cleanup_articles)( void *const, const size_t );   # extern const unsigned int gblflags;    #ifdef VAXC  #pragma standard #endif  A     /* declare static hash table for package and cleanup records.       */ 2 static struct package_record *hashtbl[HASHTBLSIZ];3 static struct cleanup_record *clnuptbl[HASHTBLSIZ];      /*  *-*  *  * Routine: #  *	strhash( register char *string )   *  * Abstract:E  *	This routine hashes a character string and returns an integer. The H  *	function is not case sensitive (i.e. upper and lower case string bothE  *	hash to the same value.) The string must be terminated with a null 
  *	character.   *
  * Inputs:(  *	string -- pointer to character string  *  * Outputs:   *	None.  *  * Returns Value:   *	character string hash value  *  * Special Notes: F  *	The caller must do any modulo operations or scaling of return value  *  -*-  */ 
 static size_t & strhash( register const char *string ) { .     register unsigned i, cnt, val, tmp, *lptr;  . 	/* count the string length and divide by four 	 */      cnt = strlen( string ) >> 2;  7 	/* hash characters four at a time doing the following: 1 	 * 1.) convert characters to upper case if ascii # 	 * 2.) XOR with running hash value A 	 * 3.) ROTATE 9 bits (9 is relative prime to and greater than 8)  	 */(     for ( i = 0, val = 0; i < cnt; i++ )     { ; 	lptr = (unsigned *)string;		/* get pointer to long word */ / 	string += 4;				/* increment string by four */ = 	tmp = (*lptr & ~0x20202020);		/* convert to upper case    */ . 	val ^= tmp;				/* XOR with current hash val*/A         tmp = (val & 0xFF800000);		/* Rotate by 9 which is	    */ - 	val <<= 9;				/* relative prime to 9 and  */ 5 	val |= (tmp >> (32 - 9));		/* greater than 8.	    */      } 5                                                       2 	/* hash remaining characters (0, 1, 2, or 3 left)1 	 * 1.) convert characters to upper case if ascii # 	 * 2.) XOR with running hash value B 	 * 3.) ROTATE hash value 13 bits (13 is prime and greater than 8) 	 */7     while ( *string )				/* loop until I hit EOS	    */      { ; 	tmp = (*string++ & ~0x20);		/* convert to upper case    */ G 	val ^= tmp;                             /* XOR with current hash val*/ A         tmp = (val & 0xFFF80000);		/* Rotate by 13 which is    */ - 	val <<= 13;				/* relative prime to 8	    */ 6 	val |= (tmp >> (32 - 13));		/* greater than 8.	    */     }   E 	/* multiple by a large prime number (-1522591305) and rotate 19 bits A 	 * (71279461 another prime, incase I get tired of the last one.)  	 */     val *= 0xa53f19b7;     tmp = (val & 0xFFFFE000);      val <<= 19;      val |= (tmp >> (32 - 19));       return ( val );  }      /*  * Routine: pack_add_cleanup  *  * Abstract:?  *	This routine adds a record of article number that is to have %  *	some clean action performed on it.   *
  * Inputs:1  *	folder -- pointer to folder containing article   *	article -- article number  *  * Outputs:   *	None   *  * Return Value:  *	operation status   *  */ 
 static size_t + pack_add_cleanup( const char *const folder,  		  const unsigned int article,  		  const char *const package, 		  const unsigned int part )  { '     register unsigned int hashval, tmp; ,     register struct cleanup_record *cleanup;  0 	/* hash folder name to compute hash table index 	 */-     hashval = strhash( folder ) % HASHTBLSIZ;   A 	/* get the cleanup record data structure if it exists, otherwise ) 	 * allocate a new one and initialize it.  	 */Q     for ( cleanup = clnuptbl[hashval]; cleanup != NULL; cleanup = cleanup->next ) . 	if ( strcmp( cleanup->folder, folder ) == 0 ) 	    break;        if ( cleanup == NULL )     { " 	    /* allocate a cleanup record. 	     */D 	cleanup = (struct cleanup_record *)calloc( 1, sizeof( *cleanup ) ); 	if ( cleanup == NULL ) - 	    raise_exception( PACKASM_INSVIRMEM, 0 );   % 	    /* fill in cleanup record number  	     */# 	cleanup->next = clnuptbl[hashval];  	clnuptbl[hashval] = cleanup; # 	strcpy( cleanup->folder, folder ); $ 	cleanup->size = sizeof( *cleanup ); 	cleanup->article_cnt = 0;" 	cleanup->article_max = DEFMSGCNT;     }   7     cleanup->article[cleanup->article_cnt].part = part; <     cleanup->article[cleanup->article_cnt].number = article;F     strcpy( cleanup->article[cleanup->article_cnt].package, package );     cleanup->article_cnt++;   9 	/* if the cleanup record is full, then allocate a larger 
 	 * record 	 */7     if ( cleanup->article_cnt == cleanup->article_max )      {  	register size_t tmp; ( 	register struct cleanup_record *p, *p1;  
 	p = cleanup; > 	tmp = p->size + (DEFMSGCNT * sizeof( cleanup->article[0] ) );6 	cleanup = (struct cleanup_record *)realloc( p, tmp ); 	cleanup->size = tmp; # 	cleanup->article_max += DEFMSGCNT;    	p1 = clnuptbl[hashval]; 	if ( p1 != p )  	{ 	    while ( p1->next != p ) 		p1 = p1->next; 	    p1->next = cleanup; 	} 	else ! 	    clnuptbl[hashval] = cleanup;  	      	free( p );      }        return ( PACKASM_SUCCESS );  }      /*  * Routine: pack_add_part   *  * Abstract:F  *	This routine adds a part record into the appropriate package record?  *	If the package is not in the table, then a package record is   *	created for this package.  *
  * Inputs:%  *	package -- pointer to package name %  *	part_number -- integer part number +  *	expected -- integer expected part number ;  *	folder_name -- pointer to mail folder or news group name =  *	article_number -- mail folder or news group article number   *  * Outputs:   *	None   *  * Return Value:  *	operation status   *  */ 
 static size_t ) pack_add_part( const char *const package, ' 	       const unsigned int part_number, $ 	       const unsigned int expected,) 	       const char *const article_folder, * 	       const unsigned int article_number,) 	       const unsigned int subject_flag )  {      char hashstr[PACBUFSIZ];'     register unsigned int hashval, tmp; (     register struct part_record *pt_rec;+     register struct package_record *pk_rec;   8 	/* if this is a bogus part number, then return an error 	 */!     if ( part_number > expected )      { @ 	raise_exception( PACKASM_PARTNOTEXP, 2, package, part_number ); 	return ( PACKASM_PARTNOTEXP );      }   1 	/* hash package name to compute hash table index  	 */2     sprintf( hashstr, "%s%d", package, expected );.     hashval = strhash( hashstr ) % HASHTBLSIZ;  A 	/* get the package record data structure if it exists, otherwise ) 	 * allocate a new one and initialize it.  	 */L     for ( pk_rec = hashtbl[hashval]; pk_rec != NULL; pk_rec = pk_rec->next )/ 	if ( strcmp( pk_rec->package, package ) == 0 )  	    break;        if ( pk_rec == NULL )      { A 	    /* compute size of data structure to contain information for C 	     * for all parts in a package. Note that space for a zero part < 	     * is allocated even though most packages don't use it. 	     */8 	tmp = sizeof( *pk_rec ) + sizeof( *pt_rec ) * expected;  4 	pk_rec = (struct package_record *)calloc( 1, tmp ); 	if ( pk_rec == NULL )- 	    raise_exception( PACKASM_INSVIRMEM, 0 );   % 	    /* fill in package record number  	     */! 	pk_rec->next = hashtbl[hashval];  	hashtbl[hashval] = pk_rec;  	pk_rec->state = 0;  	pk_rec->found = 0;  	pk_rec->expected = expected;  	pk_rec->last = 0;$ 	strcpy( pk_rec->package, package );     }     	/* check for valid package part 	 */'     if ( expected != pk_rec->expected )      { 1 	raise_exception( PACKASM_INVEXPPART, 3, package, ! 			 expected, pk_rec->expected );  	return ( PACKASM_INVEXPPART );      }     	/* fill in the part information 	 */     pt_rec = pk_rec->parts;   - 	/* check for part number already encountered  	 */F     if ( ((part_number == 0) && (pk_rec->state & STATE_M_ZEROPART)) ||+ 	 (pt_rec[part_number].package_part != 0) )      { $ 	pk_rec->state |= STATE_M_DUPLICATE;? 	raise_exception( PACKASM_DUPLICATE, 2, package, part_number );  	return ( PACKASM_DUPLICATE );     }   3     pt_rec[part_number].package_part = part_number; 8     pt_rec[part_number].article_number = article_number;A     strcpy( pt_rec[part_number].article_folder, article_folder );        if ( part_number != 0 )      {  	pk_rec->found++;   	if ( expected < pk_rec->found ) 	{C 	    raise_exception( PACKASM_DUPLICATE, 2, package, part_number ); " 	    return ( PACKASM_DUPLICATE ); 	}     }      else# 	pk_rec->state |= STATE_M_ZEROPART;   ? 	/* if we were initially unable to determine the expected part, > 	 * but encountered a part that we know is the last, then save 	 * that part number.  	 */,     if ( subject_flag & PACKASM_M_LASTPART ) 	pk_rec->last = part_number;       return ( PACKASM_SUCCESS );  }      /*!  * Function: pack_process_subject   *  * Abstract:7  *	This function processes the subject line and date to 9  *	determine if the subject line contains a valid package   *	name.  *
  * Inputs:-  *	subcxt -- pointer to subject context block $  *	subject -- pointer subject string*  *	msgid -- message identifier for article6  *	date -- pointer to unsigned int containing the time  *  * Outputs: 
  *    None  *  * Return Value:  *	PACKASM_NOMATCH  *	PACKASM_SUCCESS  */  size_t: pack_process_subject( struct subject_record *const subcxt," 		      const char *const subject,! 		      const unsigned int msgid, " 		      const unsigned int *date ) {                        char prompt[PACBUFSIZ];      char package[PACBUFSIZ];     char scratch[PACBUFSIZ];      unsigned int part, expected;     unsigned int subopt;  )     register char *p, *e, *specification;      register size_t status;   > 	    /* check the message delivery time against the before and 	     * since dates  	     */A     status = compare_time( date, subcxt->before, subcxt->since );      if ( !(status & 1) ) 	return ( PACKASM_NOMATCH );  5 	/* parse the subject line to see if a package exists  	 */@     status = parse_subject( subject, subcxt->separator, package,# 			    &part, &expected, &subopt );      if ( !(status & 1) ) 	return ( PACKASM_NOMATCH );  8 	/* if the package name ends in '.', then remove the '.' 	 */7     if ( (p = strchr( package, '.' )) && p[1] == '\0' )  	*p = '\0';   5 	/* check the package name against packages specified  	 * by the user  	 */(     strcpy( scratch, subcxt->packages );     for ( p = scratch; p; )      {  	specification = p;  	if ( p = strchr( p, ',' ) ) 	    *p++ = '\0';   3 	status = compare_string( package, specification );  	if ( status & 1 ) 	     break;     }        if ( !(status & 1) ) 	return ( PACKASM_NOMATCH );  ? 	/* check the package name against the exclude list, if a match  	 * is found, then return. 	 */<     if ( subcxt->excludes && (subcxt->excludes[0] != '\0') )     { % 	strcpy( scratch, subcxt->excludes );  	for ( p = scratch; p; ) 	{ 	    specification = p;F  	    if ( p = strchr( p, ',' ) ) 		*p++ = '\0';  7 	    status = compare_string( package, specification );n 	    if ( status & 1 ) 		return ( PACKASM_NOMATCH );r 	}     }t  3 	/* passed all criteria, ask the users it he's surey 	 */,     if ( subcxt->flags & PACKASM_M_CONFIRM )     { H 	sprintf( prompt, "Include part %d of %d from folder %s for package %s",/ 			  part, expected, subcxt->folder, package );s  " 	status = ask_user( prompt, "Y" );  # 	if ( status == PACKASM_NOCONFIRM )s* 	    subcxt->flags  &= ~PACKASM_M_CONFIRM;  ! 	if ( status == PACKASM_FALSANS )c  	    return ( PACKASM_SUCCESS );     }.  ! 	/* The part record into databasem 	 */4     status = pack_add_part( package, part, expected,' 			    subcxt->folder, msgid, subopt );*     if ( !(status & 1) ) 	return ( status );        return ( PACKASM_SUCCESS );s }    e /*  * Routine: uudecode  *  * Abstract:5  *	This routine decodes a line from a uuencoded file.f  *G  *	Decode each line as it's passed to the function. Output a group of 3cH  *	bytes (4 input characters). The input chars are pointed to by p, theyI  *	are to be output to file fp. n is used to tell us not to output all ofe  *	them at the end of the file.u  *
  * Inputs:'  *	fp -- pointer to FILE data structurei-  *	encoded -- pointer to buffer to be decoded4  *  * Outputs:t1  *	Decoded characters are written to output file.*  *  * Return Value:  *  */f% #define DEC(c)    (((c) - ' ') & 077)    static voide uudecode( FILE *const fp,e 	  const char *const encoded ) {a
     int n;     const char *p;     char decoded[128], *bp;t       n = DEC(encoded[0]);     if ( n <= 0 )r 	return;       p = &encoded[1];     bp = decoded;i       while ( n >= 4 )     {E) 	*bp++ = DEC(p[0]) << 2 | DEC(p[1]) >> 4;r) 	*bp++ = DEC(p[1]) << 4 | DEC(p[2]) >> 2;-$ 	*bp++ = DEC(p[2]) << 6 | DEC(p[3]);   	p += 4; 	n -= 3;     }*       if ( n >= 1 )a) 	*bp++ = DEC(p[0]) << 2 | DEC(p[1]) >> 4;a       if ( n >= 2 )p) 	*bp++ = DEC(p[1]) << 4 | DEC(p[2]) >> 2;L       if ( n >= 3 ) $ 	*bp++ = DEC(p[2]) << 6 | DEC(p[3]);  +     fwrite( decoded, 1, bp - decoded, fp );y       return;e }i   n /*  * Routine: pack_validate*  *  * Abstract:G  *	This routine validates a string of UUencoded characters. In additon, D  *	if trailing characters are missing, then pad with the appropriate  *	number of spaces.  *
  * Inputs:6  *	line -- pointer to a string of UUencoded characters  *  * Outputs:<  *  *  * Return Value:=  *	PACKASM_UNEXPSTATE if invalid uuencoded characters exists.m5  *	PACKASM_SUCCESS if uuencoded characters are valid.l  *  * Side effects:B  *	Some space characters may be appended to the end of a UUencoded  *	line.  */m static unsigned inte! pack_validate( const char *line )o {r     register char *p;t!     register unsigned int len, n;f       if ( line == NULL )d 	return ( PACKASM_UNEXPSTATE );s       p = (char *)line;c     n = DEC(*p);2     len = n / 3 * 4 + (n % 3 ? n % 3 + 1 : 0) + 1;  !     for ( ; len > 0; len--, p++ )s     {h 	if ( *p == '\0' ) 	    break;*! 	if ( (*p >= 'a') || (*p < ' ') ) # 	    return ( PACKASM_UNEXPSTATE );      }d   	/* Pad with spaces if missing.* 	 */     if ( len > 0 )     {i 	for ( ; len > 0; len-- )a 	    *p++ = ' '; 	*p = '\0';t     }e       return ( PACKASM_SUCCESS );u }n   /*  * Routine: pack_deliver  *  * Abstract:F  *	This routine writes the record to the specified file if it pass theE  *	specified criteria. The state machine is use to remove headers anda'  *	trailers from the specified packages   *.  *	state 0 -- looking for beginning of package*  *		"$!" beginning of a VMS_SHARE package.,  *		"begin" beginning of a UUENCODE package.  * e?  *	state 1 -- Process first encoded line in the first part of a   *		   UUENCODED package. 7  *		   Determine the length of the lines to be decoded. 7  *		   If this is the only part then change to state 3, #  *		   otherwise change to state 2.;  *7  *	state 2 -- Process and decode all UUENCODED M lines.	+  *		   If last part, then change to state 3c  *:  *	state 3 -- Decode all lines assumeing UUENCODED M line.3  *		   If 'end' encounterd, then change to state 4.   *  *	state 4 -- Ignore everything   *<  *	state 5 -- Place holder, for addition of UUDECODE states.  *		   Should never get here.	  *E  *	state 6 -- Include everything in VMS_SHARE file upto part divider,	  *		   then change to state 7i  *F  *	state 7 -- Look for part divider, when found then change to state 6  *
  * Inputs:&  *	reccxt -- pointer to record context.  *	record -- text record to be written to file  *  * Outputs:s  *	Noned  *  * Return Value:  *	operation status   *  */  size_t, pack_deliver( struct message_record *reccxt,! 	      const char *const record )o {	     register size_t len;$     register const char *ptr = NULL;  0     if ( !(reccxt->flags & PACKASM_M_NOUNPACK) )     {  	switch ( reccxt->state )s 	{, 		/* state 0, scanning for beginning package/ 		 * All packages must be recognized in state 0p 		 */P 	    case 0:   		    /* VMS_SHARE file?	 		     */A( 		if ( strncmp( record, "$!", 2 ) == 0 ) 		{  		    char filename[128];d  : 		    make_file( reccxt->defspec, ".COM", reccxt->package, 			       filename );e? 		    reccxt->fp = fopen( filename, "w", "rfm=var", "rat=cr" );* 		    if ( reccxt->fp == NULL )o5 			raise_exception( PACKASM_ERROUTFIL, 1, filename );o  ) 		    strcpy( reccxt->outfil, filename );e 		    reccxt->state = 6; 		    break; 		}o   		    /* UUENCODED file?	 		     */  		if ( record[0] != 'X' )X 		    ptr = record;  		else 		    ptr = &record[1];a  , 		if ( (strncmp( ptr, "begin ", 6 ) == 0) && 		     isdigit( ptr[6] ) &&e 		     isdigit( ptr[7] ) &&t 		     isdigit( ptr[8] ) ) 		{t 		    int mode; $ 		    char file[128], filename[128];  +  			/* grab the filename and mode argumentsc 			 */D 		    if ( sscanf( ptr, "begin %o%[ ]%s", &mode, file, file ) != 3 ) 			return ( PACKASM_SUCCESS );   		    reccxt->state = 1;  - 		    if ( reccxt->flags & PACKASM_M_DECODE )g 		    {t  			    /* create the output file
 			     */4 			make_file( reccxt->defspec, "", file, filename );: 			reccxt->fp = fopen( filename, "w", "mbc=32", "mbf=2" ); 			if ( reccxt->fp == NULL )9 			    raise_exception( PACKASM_ERROUTFIL, 1, filename );   & 			strcpy( reccxt->outfil, filename ); 			return ( PACKASM_SUCCESS ); 		    } 
 		    else 		    {   			    /* create the output file
 			     */? 			make_file( reccxt->defspec, "", reccxt->package, filename ); < 			reccxt->fp = fopen( filename, "w", "rfm=var", "rat=cr" ); 			if ( reccxt->fp == NULL )9 			    raise_exception( PACKASM_ERROUTFIL, 1, filename );h  & 			strcpy( reccxt->outfil, filename ); 		    }e   		    break; 		}r   		return ( PACKASM_SUCCESS );   8 		/*====================================================! 		 * UUENCODED file state machine* 		 * States: 1, 2, 3 & 4 		 */  	    case 1:  ( 		if ( strncmp( record, "XM", 2 ) == 0 ) 		    ptr = &record[1];  		else if ( record[0] == 'M' ) 		    ptr = record;  		else$ 		    return ( PACKASM_UNEXPSTATE );  $ 		if ( !(pack_validate( ptr ) & 1) )$ 		    return ( PACKASM_UNEXPSTATE );   		if ( reccxt->expected > 1 )  		    reccxt->state = 2; 		else 		    reccxt->state = 3;  ) 		if ( reccxt->flags & PACKASM_M_DECODE )  		{ " 		    uudecode( reccxt->fp, ptr );! 		    return ( PACKASM_SUCCESS );  		}i   		break;   	    case 2:  ( 		if ( strncmp( record, "XM", 2 ) == 0 ) 		    ptr = &record[1];  		else if ( record[0] == 'M' ) 		    ptr = record;*   		if ( ptr != NULL ) 		{ ( 		    if ( !(pack_validate( ptr ) & 1) ) 			return ( PACKASM_SUCCESS );  - 		    if ( reccxt->expected == reccxt->part )  			reccxt->state = 3;0  - 		    if ( reccxt->flags & PACKASM_M_DECODE ); 		    {l 			uudecode( reccxt->fp, ptr );  			return ( PACKASM_SUCCESS ); 		    }    		    break; 		}u   		return ( PACKASM_SUCCESS );1 		 	    case 3:  , 		if ( (strncmp( record, "end", 3 ) == 0) ||, 		     (strncmp( record, "Xend", 4 ) == 0) ) 		{0 		    reccxt->state = 4;  - 		    if ( reccxt->flags & PACKASM_M_DECODE )m 			return ( PACKASM_SUCCESS );   		    break; 		}*  ( 		if ( strncmp( record, "XM", 2 ) == 0 ) 		    ptr = &record[1];s 		else 		    ptr = record;h  $ 		if ( !(pack_validate( ptr ) & 1) )! 		    return ( PACKASM_SUCCESS );f  ) 		if ( reccxt->flags & PACKASM_M_DECODE )  		{a" 		    uudecode( reccxt->fp, ptr );! 		    return ( PACKASM_SUCCESS );u 		}*   		break;   	    case 4:   		return ( PACKASM_SUCCESS );p   	    case 5:    		return ( PACKASM_UNEXPSTATE );  8 		/*====================================================! 		 * VMS_SHARE file state machines 		 * States: 6, & 7p 		 */  	    case 6:  7 		if ( strncmp( record, "+-+-+-+-+-+-+-+-", 16 ) != 0 )t 		    break;   		reccxt->state = 7; 		return ( PACKASM_SUCCESS );Z   	    case 7:  7 		if ( strncmp( record, "-+-+-+-+-+-+-+-+", 16 ) == 0 )  		    reccxt->state = 6;   		return ( PACKASM_SUCCESS );l  
 	    default:h    		return ( PACKASM_UNEXPSTATE ); 	}     }x     else     {p 	if ( reccxt->fp == NULL ) 	{ 	    char filename[128];  E 	    make_file( reccxt->defspec, ".TMP", reccxt->package, filename );/  > 	    reccxt->fp = fopen( filename, "w", "rfm=var", "rat=cr" ); 	    if ( reccxt->fp == NULL )4 		raise_exception( PACKASM_ERROUTFIL, 1, filename );  ( 	    strcpy( reccxt->outfil, filename ); 	}     }>  0     if ( reccxt->flags & PACKASM_M_REMOVE_HDRS )     {  	switch ( reccxt->state )o 	{ 	    case 0:   		if ( record[0] == '\0' ) 		     reccxt->state = 1;    		return ( PACKASM_SUCCESS );;   	    case 1:  8 		if ( (strncmp( record, "Return-Path: <", 14 ) == 0) ||8 		     (strncmp( record, "Archive-name: ", 14 ) == 0) ||4 		     (strncmp( record, "Posted-By: ", 11 ) == 0) ) 		{a 		    reccxt->state = 0;! 		    return ( PACKASM_SUCCESS );r 		}    		reccxt->state = 2; 		break;   	    case 2:   		break;  
 	    default:n    		return ( PACKASM_UNEXPSTATE ); 	}     }   *     fprintf( reccxt->fp, "%s\n", record );       return ( PACKASM_SUCCESS );p }i   ( /*  * Routine: pack_extract  *  * Abstract:F  *	This routine checks to see if the package and all the package partsG  *	exist. If so, the specified callback routine is called once for eachi(  *	part, otherwise an error is returned.  *
  * Inputs:'  *	handle -- pointer to article contexte&  *	pacptr -- pointer to package record(  *	outfil -- pointer to output file name  *  * Outputs:E  *	None   *  * Return Value:  *	operation status   *  */c
 static size_tt! pack_extract( void *const handle,r  	      const void *const pacptr,! 	      const char *const defspec, " 	      const char *const package ) { !     struct message_record msgrec;e#     char article_folder[PACBUFSIZ];_  *     register size_t hashval, part, status;+     register struct package_record *pk_rec;e(     register struct part_record *pt_rec;  -     pk_rec = (struct package_record *)pacptr;o   	/* if no package then returns 	 */     if ( pk_rec == NULL ):; 	raise_exception( PACKASM_PACKNOTASS, 1, pk_rec->package );r  0 	/* check if all the parts exists in the package 	 */     if ( pk_rec->last != 0 )! 	pk_rec->expected = pk_rec->last;s  ,     if ( pk_rec->expected != pk_rec->found )     {i< 	raise_exception( PACKASM_NOTALLPARTS, 1, pk_rec->package );    	return ( PACKASM_NOTALLPARTS );     }i  , 	/* get pointer to array of part information 	 */     pt_rec = pk_rec->parts;i   	/* build message record 	 */     msgrec.fp = NULL;b     msgrec.state = 0;r     msgrec.flags = gblflags;'     msgrec.expected = pk_rec->expected;e     msgrec.outfil[0] = '\0';&     strcpy( msgrec.defspec, defspec );&     strcpy( msgrec.package, package );       article_folder[0] = '\0';a  A 	/* call routine to extract package for each part in the package.  	 */<     for ( part = (pk_rec->state & STATE_M_ZEROPART) ? 0 : 1;% 	  part <= pk_rec->expected; part++ )t     { ( 	if ( gblflags & PACKASM_M_REMOVE_HDRS ) 	    msgrec.state = 0;    	if ( gblflags & PACKASM_M_LOG )5 	    display( PACKASM_PROCESSING, 3, pk_rec->package,g  		     part, pk_rec->expected );  @ 	    /* if folder was selected last time, then don't reselect it( 	     * otherwise select the new folder. 	     */B 	if ( strcmp( article_folder, pt_rec[part].article_folder ) != 0 ) 	{; 	    strcpy( article_folder, pt_rec[part].article_folder );p8 	    status = select_articles( handle, article_folder ); 	    if ( !(status & 1) )o 		break; 	}   	msgrec.part = part;@ 	status = extract_articles( handle, pt_rec[part].article_number, 				   pack_deliver, &msgrec );    	if ( !(status & 1) )  	    break;a  H 	    /* Add article into cleanup database if cleanup action is specified 	     */= 	if ( (gblflags & PACKASM_M_CLEANUP) && (msgrec.fp != NULL) )pC 	    pack_add_cleanup( article_folder, pt_rec[part].article_number, ! 			      pk_rec->package, part );e     }   7 	/* If the output file was never opened, tell the user,	 	 * otherwise close the file.  	 */     if ( msgrec.fp == NULL )     { ; 	raise_exception( PACKASM_PACKNOTASS, 1, pk_rec->package );- 	return( PACKASM_PACKNOTASS );     }l       fclose( msgrec.fp );  '     if ( status == PACKASM_UNEXPSTATE )e; 	raise_exception( PACKASM_UNEXPSTATE, 1, pk_rec->package );   = 	/* if sucessfully unpacked, then display message to the userc 	 */     if ( status & 1 )      {,0 	display( PACKASM_ASSEMBLED, 3, pk_rec->package,% 		 pk_rec->expected, msgrec.outfil );g     }=       return ( status ); }r u /*  * Routine: pack_cleanup  *  * Abstract:C  *	This routine does cleanup processing for all articles in folders(A  *	or newsgroups. Note that the articles are not ordered, but arep'  *	grouped under folders or newsgroups.   *
  * Inputs:  *	Nonek  *  * Outputs:)  *	Noner  *  * Return Value:  *	operation status   *  */p
 static size_t & pack_cleanup_all( void *const handle ) {l     char prompt[PACBUFSIZ];p  %     register unsigned int hashval, i;t0     register struct cleanup_record *cleanup, *p;#     register size_t lflags, status;        lflags = gblflags;  8     for ( hashval = 0; hashval < HASHTBLSIZ; hashval++ )     { 6 	for ( cleanup = clnuptbl[hashval]; cleanup != NULL; ) 	{ 		/* select the folder 		 */t9 	    status = select_articles( handle, cleanup->folder );i 	    if ( !(status & 1) )  		return( status );p  . 		/* do cleanup fro each article in the folder 		 */s1 	    for ( i = 0; i < cleanup->article_cnt; i++ )g 	    {' 		if ( lflags & PACKASM_M_CONFIRM_DEL )n 		{dE 		    sprintf( prompt, "Delete part %d of package %s from folder %s",a! 			     cleanup->article[i].part,M$ 			     cleanup->article[i].package, 			     cleanup->folder );  ' 		    status = ask_user( prompt, "N" );   ( 		    if ( status == PACKASM_NOCONFIRM )$ 			lflags &= ~PACKASM_M_CONFIRM_DEL;  & 		    if ( status == PACKASM_FALSANS ) 			continue; 		}p  B 		status = cleanup_articles( handle, cleanup->article[i].number ); 		if ( !(status & 1) ) 		    return( status );i  ! 		if ( gblflags & PACKASM_M_LOG ) ; 		    display( PACKASM_DELETE, 3, cleanup->article[i].part,e7 			     cleanup->article[i].package, cleanup->folder );  	    }   		/* delete the cleanup record 		 */f 	    p = cleanup->next;  	    free( cleanup );  	    cleanup = p;O 	}     }        return ( PACKASM_SUCCESS );f }p a /*  * Routine: pack_extract_all  *  * Abstract:A  *	This routine scans the hash table for all package and call the C  *	routine to deliver the parts to the users callback routine. Thene8  *	the cleanup routine is called to cleanup all folders.  *
  * Inputs:%  *	handle -- pointer to context block*+  *	defspec -- pointer to output file stringn  *  * Outputs:f  *	None   *  * Return Value:  *	operation statusb  *  */a size_t% pack_extract_all( void *const handle,s 		  const char *const defspec )c { +     register unsigned int i, found, status;o+     register struct package_record *pk_rec;    	/* find all package names 	 */     found = FALSE;&     for ( i = 0; i < HASHTBLSIZ; i++ )     {hC 	for ( pk_rec = hashtbl[i]; pk_rec != NULL; pk_rec = pk_rec->next )u 	{ 	    found = TRUE;G 	    status = pack_extract( handle, pk_rec, defspec, pk_rec->package );r  3 		/* until I figure out what to do with the status,  		 * just continue for now.= 		 */  	    if ( !(status & 1) )) 		continue;' 	}     }   A     if ( (!(gblflags & PACKASM_M_ARTICLES)) && (found == FALSE) )s! 	display( PACKASM_NOPACKFND, 0 );)  '     if ( gblflags & PACKASM_M_CLEANUP )a     {u 	    /* process cleanup actions( 	     */% 	status = pack_cleanup_all( handle );r 	if ( !(status & 1) )p 	    return ( status );%     }a       return ( PACKASM_SUCCESS );b }-   e /*   * Function: pack_match_articles  *  * Abstract:B  *	This functions builds checks if the article specified is in the  *	list of excluded articles.   *
  * Inputs:%  *	article -- article number to check =  *	excludes -- ascii string of article numbers to be excludedp  *  * Outputs:k
  *    None  *  * Return Value:  *	PACKASM_NOMATCH  *	PACKASM_SUCCESS  *  */ 
 static size_t 0 pack_match_articles( const unsigned int article,# 		     const char *const excludes )  {A     const char *d;     unsigned int start, end;  6     if ( (excludes == NULL) || (excludes[0] == '\0') ) 	return ( PACKASM_NOMATCH );       for ( d = excludes; *d; )s     {i 	start = 0;e 	while ( isdigit( *d ) )' 	    start = (start * 10) + *d++ - '0';o  " 	if ( (*d == '-') || (*d == ':') ) 	{ 	    end = 0; d++; 	    while ( isdigit( *d ) )  		end = (end * 10) + *d++ - '0'; 	} 	else  	    end = start;o   	if ( *d == ',' ) d++;   	if ( start < end )t2 	    if ( (article >= start) && (article <= end) ) 		return ( PACKASM_SUCCESS );  	else 2 	    if ( (article >= end) && (article <= start) ) 		return ( PACKASM_SUCCESS );d     }a       return ( PACKASM_NOMATCH );  }h   c /*%  * Function: pack_build_article_table;  *  * Abstract:D  *	This functions builds a linear array with each element containingB  *	a specified article number. This array is in the order that the  *	parts are specified.(  *
  * Inputs:8  *	arttbl -- pointer receive base of article table index1  *	size -- number of entries in the article table 8  *	articles -- user specified string contianing articles@  *	excludes -- user specified string contianing exclude articles  *  * Outputs:[
  *    None  *  * Return Value:  *	PACKASM_NOMATCH  *	PACKASM_SUCCESS  */ 
 static size_t 6 pack_build_article_table( unsigned int **const arttbl, 			  unsigned int *const size,  			  const char *const articles,! 			  const char *const excludes )i {t     const char *d;     unsigned int article;p     unsigned int tmp, idx;#     unsigned int start, end, tblsz;        idx = 0;     tblsz = ARTICLE_TABLE_SIZE;M  . 	/* allocate initial table for article numbers 	 */<     *arttbl = (size_t *)malloc( tblsz * sizeof( *arttbl ) );     if ( *arttbl == NULL )) 	raise_exception( PACKASM_INSVIRMEM, 0 );U       for ( d = articles; *d; )u     {  	start = 0;l 	while ( isdigit( *d ) )' 	    start = (start * 10) + *d++ - '0';r  " 	if ( (*d == '-') || (*d == ':') ) 	{ 	    end = 0; d++; 	    while ( isdigit( *d ) )  		end = (end * 10) + *d++ - '0'; 	} 	else  	    end = start;3   	if ( *d == ',' ) d++;  ; 	    /* check if the article number table is big enough for A 	     * next set of number. If not expand the table by increasingKB 	     * the size by a factor two or if necessary, increasing it to% 	     * hold the next set of entries.l 	     */ 	if ( start < end )  	    tmp = end - start;  	elsee 	    tmp = start - end;u 	tmp += (1 + idx);   	if ( tmp >= tblsz  )A 	{* 	    tblsz = MIN( tblsz + tmp, tblsz * 2);H 	    *arttbl = (size_t *)realloc( *arttbl, tblsz * sizeof( **arttbl ) ); 	    if ( *arttbl == NULL )a* 		raise_exception( PACKASM_INSVIRMEM, 0 ); 	}  L 	for ( article = start; article != end; start < end ? article++ : article--) 	{G 	    if ( pack_match_articles( article, excludes ) != PACKASM_NOMATCH )  		continue;   	    (*arttbl)[idx++] = article; 	}C 	if ( pack_match_articles( article, excludes ) == PACKASM_NOMATCH )t  	    (*arttbl)[idx++] = article;     }y       *size = idx;       return ( PACKASM_SUCCESS );  }s e /*#  * Routine: pack_extract_by_articlee  *  * Abstract:F  *	This routine checks to see if the package and all the package partsG  *	exist. If so, the specified callback routine is called once for each (  *	part, otherwise an error is returned.  *
  * Inputs:'  *	handle -- pointer to article context *  *	article_list -- pointer to article list*  *	exclude_list -- pointer to exclude list  *  * Outputs:_  *	Nonee  *  * Return Value:  *	operation status   *  */  size_t* pack_extract_articles( void *const handle,( 		       const char *const article_list,( 		       const char *const exclude_list," 		       const char *const folder,# 		       const char *const output )* {*     char prompt[PACBUFSIZ];s      unsigned int *article_table;      unsigned int part, expected;!     unsigned int article, lflags; !     struct message_record msgrec;        register status;   	/* check for bogus output filea 	 */     if ( output == NULL ) ) 	raise_exception( PACKASM_INTERNERR, 0 );e  = 	/* build the article table from the article and exclude listo 	 */A     status = pack_build_article_table( &article_table, &expected, ( 				       article_list, exclude_list );     if ( !(status & 1) ) 	return ( status );    	/* build message record 	 */     msgrec.fp = NULL;	     msgrec.state = 0;	     msgrec.flags = gblflags;     msgrec.expected = expected; %     strcpy( msgrec.defspec, output );i%     strcpy( msgrec.package, output );e       lflags = gblflags;  A 	/* call routine to extract package for each part in the package.  	 */-     for ( part = 0; part < expected; part++ )r     {] 	article = article_table[part];   ( 	    /* ask the users it he's/she's sure 	     */" 	if ( lflags & PACKASM_M_CONFIRM ) 	{: 	    sprintf( prompt, "Include article %d from folder %s", 			     article, folder );  & 	    status = ask_user( prompt, "Y" );  ' 	    if ( status == PACKASM_NOCONFIRM )   		lflags  &= ~PACKASM_M_CONFIRM;  % 	    if ( status == PACKASM_FALSANS )f 		continue;  	}  @ 	   /* if the user requested, tell him the part we're processing 	    */f  	if ( gblflags & PACKASM_M_LOG )B 	    display( PACKASM_PROCESSING, 3, output, part + 1, expected );   	msgrec.part = part + 1;E 	status = extract_articles( handle, article, pack_deliver, &msgrec );i  A 	    /* if we couldn't extract the article, then abort processing1 	     */ 	if ( !(status & 1) )x 	    break;l  H 	    /* Add article into cleanup database if cleanup action is specified 	     */= 	if ( (gblflags & PACKASM_M_CLEANUP) && (msgrec.fp != NULL) ),; 	    pack_add_cleanup( folder, article, output, part + 1 );l     }"  7 	/* If the output file was never opened, tell the user,	 	 * otherwise close the file.R 	 */     if ( msgrec.fp == NULL )     {x2 	raise_exception( PACKASM_PACKNOTASS, 1, output ); 	return( PACKASM_PACKNOTASS );     }        (void)fclose( msgrec.fp );  '     if ( status == PACKASM_UNEXPSTATE ) 2 	raise_exception( PACKASM_UNEXPSTATE, 1, output );  = 	/* if sucessfully unpacked, then display message to the user  	 */     if ( status & 1 )eB 	display( PACKASM_ASSEMBLED, 3, output, expected, msgrec.outfil );        (void)free( article_table );       return ( status ); }e   ( /*  * Routine: pack_removef  *  * Abstract:=  *	This routine removes all the package records from the hash 	  *	table.f  *
  * Inputs:  *	NoneM  *  * Outputs:   *	Noneu  *  * Return Value:  *	operation statusP  *  */C size_t pack_remove( ) { "     register unsigned int hashval;/     register struct package_record *pk_rec, *p;   8     for ( hashval = 0; hashval < HASHTBLSIZ; hashval++ )     {!3 	for ( pk_rec = hashtbl[hashval]; pk_rec != NULL; )) 	{ 	    p = pk_rec->next; 	    free( pk_rec ); 	    pk_rec = p; 	}     }r       return ( PACKASM_SUCCESS );  }f