*++MLSEARCHed - no changes
*
*	This file contains all routines concerned with outputting
*	lines found in the input files to the output file.
*	There are three formatting stages:
*	(1) Transform the record according to the /FORMAT spec.
*	(2) Transform the result according to /HIGHLIGHT.
*	(3) Output the line, with line numbers according to /NUMBER
*
*	These are handled by Type_Rec,Hilite_Rec and Output_Rec
*
	Subroutine Type_Rec(Record,Linnum)
	Implicit None
	Character*(*) Record
	Integer Linnum
*
*	This routine is given a line to output, and a line number if necessary.
*	It formats the output line if necessary, and then passes it to the
*	next output routine.
*	If the formatted version of the record is very long, it may break
*	it up into multiple subrecords.
*
	Include 'QUALCOM.INC'
	Include 'FORMAT.INC'

	Character*(mxolen) Outrec
	Character*1 C
	Integer L0,L1,L2,I
	Integer HT,CR,FF
	Parameter (HT = 9)
	Parameter (CR = 13)
	Parameter (FF = 12)
	Logical Rec_Truncated

	If(Format .eq. FmtAll) Then		!Simple - just output record

	  Call Hilite_Rec(Record,Linnum,.False.)

	Else
*
*	Must pre-format record
*
	  L1 = Len(Record)
	  L0 = 1
	  Rec_Truncated = .True.
*
*	Return here for record segments
*
50	  L2 = 0
	  Do I = L0,L1
	   C = Record(I:I)
*
*	  /FORMAT=NULL means ignore nulls
*
	   If(Format .eq. FmtNul .and. IChar(C) .eq. 0) Then
	    Continue
*
*	/FORMAT=TEXT means pass HT,CR,FF,VT,LF unchanged
*	/FORMAT=NOFF is the same, apart from FF, which is replaced by <FF>
*
	   Else If(Ichar(C) .ge. HT .and. Ichar(C) .le. CR .and.
     $             ((Format .eq. Fmttxt) .or. 
     $              (Format .eq. Fmtnoff .and. Ichar(C) .ne. FF))) Then
	    L2 = L2 + 1
	    If(L2 .gt. Len(Outrec))  Goto 100
	    Outrec(L2:L2) = C
	   Else
*
*	Otherwise look up character in translation table for formatted version
*	(/FORMAT=DUMP)
*
	    If(L2 + Lform(Ichar(C)) .gt. Len(Outrec)) Goto 100
	    Outrec(L2+1:L2+Lform(IChar(C))) = Cform(Ichar(C))
	    L2 = L2 + LForm(IChar(C))
	   Endif
	  Enddo

	  Rec_Truncated = .False.

100	  Call Hilite_Rec(Outrec(1:L2),Linnum,Rec_Truncated)

	  If(Rec_Truncated) Then
		L0 = I
		Goto 50
	  Endif

	Endif

	Return
	End

	Subroutine Hilite_Rec(Record,Linnum,Trunc_Flag)
	Implicit None
	Integer Linnum
	Logical Trunc_Flag
	Character*(*) Record
*
*	This is given a line in which non-printables have been removed if
*	necessary. It applies any highlighting rules necessary, and
*	then passes the result to the real highlight routine.
*	This method suffers from the same bug as SEARCH, in that if, after
*	pre-formatting, the string contains one of the targets (such as CAN)
*	it is incorrectly highlighted.
*
	Include 'QUALCOM.INC'
	Integer*2 Hpos(Mxolen)
	Integer Nchanges
	Character*(Mxolen) Nrec,Spaces,Unders
	Character*2 Hion(4),Hioff,CSI
	Character*1 Cr
	Parameter (CSI = Char(27)//'[', Cr= Char(13))
	Data Hion /'1m','5m','7m','4m'/
	Data Hioff /'0m'/
	Data Spaces,Unders/' ',' '/
	Integer Rp,I,Op,Hend
	Integer Tstr(2)

	If(Hilite .eq. Hilite_None) Then
	   Call Output_Rec(Record,Linnum,Trunc_Flag) !Simple - no highlighting

	Else
*
*	 Need to do highlighting of some sort. Allocate dynamic strings
*	if non-exact matching used.
*
	  If(.Not. Exact) Then
		If(Tstr(1) .eq. 0) Call Dynini(Tstr)
		Call Str$Upcase(Tstr,Record)
	  Else
		Tstr(1) = Len(Record)
		Tstr(2) = %Loc(Record)
	  Endif

	  Call Hilite_Position(Tstr,Hpos,Nchanges,Nrec)

	  If(Nchanges .eq. 0) Then
		  Call Output_Rec(Record,Linnum,Trunc_flag)
	  Else If(Hilite .le. Hilite_Under) Then	!Escape seq highlighting

		  Rp = 1
		  Op = 0

		  Do I = 2,Nchanges*2,2
		    If(Hpos(I-1) .gt. Rp)
     $               Call Output_Add(Record(Rp:Hpos(I-1)-1),
     $                                Nrec,Op,Linnum)
		    Rp = Hpos(I-1)
       		    Hend = Min(Hpos(I)-1,Len(Record))
       		    Call Output_Add(
     $                   CSI//Hion(Hilite)//Record(Rp:Hend)//Csi//Hioff,
     $                                           Nrec,Op,Linnum)
		    Rp = Hpos(I) 
		  Enddo
		  If(Rp .le. Len(Record))
     $                  Call Output_Add(Record(Rp:),Nrec,Op,Linnum)
		  If(Op .ne. 0)
     $                  Call Output_Rec(Nrec(1:op),Linnum,Trunc_flag)
	 Else		!Hardcopy highlighting

		Rp = 1
		Op = 0
		Call Output_Add(Record,Nrec,Op,Linnum)
		Call Output_Add(CR,Nrec,Op,Linnum)

		Do I = 2,Nchanges*2,2
		    If(Hpos(I-1) .gt. Rp)
     $               Call Output_Add(Spaces(:Hpos(I-1)-Rp),
     $                                Nrec,Op,Linnum)
		    Rp = Hpos(I-1)
       		    Hend = Min(Hpos(I)-1,Len(Record))
		    If(Hilite .eq. Hilite_Hunder) Then
		      If(Unders(1:1) .eq. ' ') Then
			Call Str$Dupl_Char(Unders,Mxolen,IChar('_'))
		      Endif
		      Call Output_Add(Unders(Rp:Hend),Nrec,Op,Linnum)
		    Else
		      Call Output_Add(Record(Rp:Hend),Nrec,Op,Linnum)
		    Endif

		    Rp = Hpos(I) 
		  Enddo
		  If(Op .ne. 0)
     $                  Call Output_Rec(Nrec(1:op),Linnum,Trunc_flag)

	 Endif
	Endif

	Return
	End

	Subroutine Hilite_Position(Record,Hpos,Nchanges,Tmp)
	Implicit None
	Integer*2 Hpos(*)
	Character*(*) Record,Tmp
	Integer Nchanges
*
*	This routine, given a record, returns a set of pairs indicating
*	where highlighting is to be turned on and off.
*	It also returns the number of such pairs.
*	Tmp is a work character array of the same size as RECORD.
*
	Include 'TRGCOM.INC'
	Integer Pos1,Snum,Rp,Rl,Tl

	Nchanges = 0
	Tmp = ' '
	Rl = Len(Record)
*
*	Starting with the whole string, use interface routine to Str$find_first
*	to locate where first hit is. We then search for subsequent hits from
*	the next character position. Note that it is important to order the
*	targets so that the largest is first in the list. This means we
*	correctly highlight when one target is a substring of another, and
*	the longer one appears in the source record.
*
*	First TMP is built up to contain spaces where no highlighting is
*	needed and uppercase H elsewhere.
*
	Rp = 1
	Call Str_Find_First_Substring(Record(Rp:),Pos1,Snum,Ntargets,Target)
	Do While (Snum .ne. 0 .and. Rp .le. Rl)
	   Tl = Target(Snum).Dsc$W_Maxstrlen
	   Call Str$Dupl_Char(Tmp(Rp+Pos1-1:Rp+Pos1+Tl-1),Tl,IChar('H'))
	   Rp = Rp + Pos1
	   Call Str_Find_First_Substring(
     $                 Record(Rp:),Pos1,Snum,Ntargets,Target)
	Enddo
*
*	This is now converted to a set of change pairs
*
  	If(Rp .ne. 1) Then
 		Rp = 1
		Pos1 = Index(Tmp(Rp:),'H')

		Do While (Pos1 .ne. 0)
		   Hpos(Nchanges*2+1) = Rp + Pos1 - 1
		   Nchanges = Nchanges + 1
		   Rp = Rp + Pos1
		   Pos1 = Index(Tmp(Rp:),' ')
		   If(Pos1 .ne. 0) Then
		     Hpos(Nchanges*2) = Rp + Pos1 - 1
		     Rp = Rp +  Pos1
		     Pos1 = Index(Tmp(Rp:),'H')
		   Else
		     Hpos(Nchanges*2) = Rl + 1
		   Endif
		Enddo
	Endif              
	
	Return
	End

	Subroutine Output_Add(Portion,Bulk,Pos,Linnum)
	Implicit None
	Character*(*) Portion,Bulk
	Integer Pos,Linnum
*
*	Add another chunk of output to an output record.
*	Flush the buffer with the continued marked if necessary
*
	If(Len(Portion) + Pos .gt. Len(Bulk)) Then
		Call Output_Rec(Bulk(1:Pos),Linnum,.True.)
		Pos = 0
	Endif

	Bulk(Pos+1:Pos+Len(Portion)) = Portion
	Pos = Pos + Len(Portion)
	Return
	End

	Subroutine Output_Rec(Record,Linnum,Contin)
	Implicit None
	Integer Linnum
	Logical Contin
	Character*(*) Record
*
*	This REALLY writes output to the output file.
*
	Include 'QUALCOM.INC'
	Include 'STATCOM.INC'

	If(.Not.Numbers) Then
		Write(Outlun,'(A)') Record
	Else
		Write(Outlun,'(I6,A,A)') Linnum,Char(9),Record
	Endif
	If(Contin) Write(Outlun,'(A)') '(continued)'
	Totout = Totout + 1
	Return
	End
