
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 *
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\
 *                %% \___________________________________%% \
 *                %% |                                   %%  \
 *                %% |              REMTREE              %%   \
 *                %% |          remtree.c  c2004         %%    \
 *                %% |            Lyle W. West           %%    |
 *                %% |                                   %%    |
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |
 *                \                                        \   |
 *                 \                                        \  |
 *                  \                                        \ |
 *                   \________________________________________\|
 *
 *
 *
 *  Copyright (C) 2004 Lyle W. West, All Rights Reserved.
 *  Permission is granted to copy and use this program so long as [1] this
 *  copyright notice is preserved, and [2] no financial gain is involved
 *  in copying the program.  This program may not be sold as "shareware"
 *  or "public domain" software without the express, written permission
 *  of the author.
 *
 *  REMTREE has been designed as a system management tool and is not intended
 *  to be accessed by general users. As described below, certain privs are
 *  required to succesfully execute REMTREE. Additionally, if the image is
 *  located where global access is available, it is prudent for the sysmgr
 *  to have trusted users enter:
 *
 *      DEFINE /JOB /EXEC SECURE_LNM ENABLED
 *
 *  prior to attempting execution. REMTREE requires SYSPRV to successfully
 *  complete certain RMS calls. If SETPRV is enabled for the caller,
 *  the above privs will be enabled for the duration of image activation.
 *  If not, user will see 'RMS-E-PRV' message at exit. If image is built 
 *  with SECURE defined, user will see 'SYSTEM-x-AUTHFAIL' if there is a
 *  discrepancy with LNM definition. See source (#ifdef SECURE).
 *
 *  Note that this information is not documented elsewhere. This is a
 *  poor mans substitute for an identifier, most unpriv'ed users cannot
 *  access another users job table. There may be some user with the ability
 *  to determine the need for this logical to be defined in the JOB table,
 *  but not be able to define it with EXEC priv. See the source code 
 *  (search for 'ifdef SECURE').
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "version.h"
#pragma module REMTREE VERSION

#include <clidef.h>
#include <climsgdef.h>
#include <descrip.h>
#include <iodef.h>
#include <lmfdef.h>
#include <lnmdef.h>
#include <ossdef.h>         /* defines for $get/$set_security calls */
#include <prvdef.h>
#include <psldef.h>
#include <rms.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defs.h"
 
int NumDirs;
int NumFiles;
int NumSubDirs;
int TotalAlloc;
int TotalUsed;
int alloc_size;
int used_size;

short ConfirmFlg;           /* confirm deletion of each file in the tree */
short LogFlg;               /* log deletion of each file in the tree */
short RetainFlg;          /* preserve target dir and files therein */

char CmdVerb[32];           /* foreign command invoking this image */
char TargetPath[132];       /* directory to recursively delete tree */

extern int DotSort();
extern int lib$get_input();
extern void ShowHelp();
extern void ShowMessage();
extern void ShowVers();
 


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: CheckLnm
 * Description: Function to translate a provided logical name to the defined
 *              equivalence string. Only the current JOB logical name table
 *              is searched for a match. If successful, the returned
 *              equivalence string is copied to the memory location used to
 *              provide the input logical name (*lnmstr) so caller must make
 *              certain the buffer containing the input logical name is
 *              large enough to contain the full equivalence string or 
 *              this routine returns SS$_BUFFEROVF. In all other cases,
 *              the return status of SYS$TRNLNM is returned to caller.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int CheckLnm(char *lnmstr, int buflen)
{
    int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */
    int eqvattrb = 0;               /* returned attributes of eqv string */
    int lnmstat = 0;
    short eqv_len = 0;
    short tbl_len = 0;
    char acmode;                    /* requires exec mode */
    char LnmTable[40];              /* logical name table */
    char LnmDef[40];                /* logical name string */
    char LnmEqv[80];                /* logical name equivalence string */

    struct {short len, code; int *bufadr, *retlen;} lnmitm[4];

    $DESCRIPTOR(dsc_tabnam, LnmTable);
    $DESCRIPTOR(dsc_lognam, LnmDef);
    $DESCRIPTOR(dsc_eqvnam, LnmEqv);

    acmode = PSL$C_EXEC;            /* requires exec mode */
    memset(&LnmEqv, 0, sizeof(LnmEqv));
    strcpy(LnmDef, lnmstr);
    strcpy(LnmTable, "LNM$JOB");

    dsc_tabnam.dsc$w_length = strlen(LnmTable);
    dsc_lognam.dsc$w_length = strlen(LnmDef);
    dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);

    lnmitm[0].len = sizeof(eqvattrb);
    lnmitm[0].code = LNM$_ATTRIBUTES;
    lnmitm[0].bufadr = &eqvattrb;
    lnmitm[0].retlen = 0;
    lnmitm[1].len = sizeof(LnmTable);
    lnmitm[1].code = LNM$_TABLE;
    lnmitm[1].bufadr = &LnmTable;
    lnmitm[1].retlen = &tbl_len;
    lnmitm[2].len = sizeof(LnmEqv);
    lnmitm[2].code = LNM$_STRING;
    lnmitm[2].bufadr = &LnmEqv;
    lnmitm[2].retlen = &eqv_len;
    lnmitm[3].len = 0;
    lnmitm[3].code = 0;

    lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);
    if(lnmstat == SS$_NORMAL) {
        LnmEqv[eqv_len] = '\0';
        LnmTable[tbl_len] = '\0';
        if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);
        else return(SS$_BUFFEROVF);
    }
    if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);
    else return(lnmstat);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: GetSubDirs
 * Description: using the filepath specified by argument 'Path', determine
 *              number of subdirs under that filepath. Identify each of the
 *              subdirectories and sort them with the deepest subdirs first,
 *              shallowest last and save these strings in a global array
 *              to be used by 'DeleteFiles()' to remove files.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int GetSubDirs(char *Path)
{
    int DirStat;
    int SubStat;
    int context = 0;
    int flag = 0;
    int indx;
    int numdots = 0;
    int offset = 0;
    int sortcount = 0;
    int subdircount = 0;
    int topdircount = 0;

    char ResultStr[132];
    char Target[132];
    char topdirtmp[80];
    char dirname[80];
    char *ptr1;
    char *ptr2;

    $DESCRIPTOR(Dsc_Trgt, Target);
    $DESCRIPTOR(Dsc_Rslt, ResultStr);

    DIR_LST  *DirPtr;
    FULL_LST *FullList;
    FULL_LST *FullPtr;           /* file pointer for FullList */
    SORT_LST *SortList;
    SORT_LST *SortPtr;
    TOP_LST  *TopList;
    TOP_LST  *TopPtr;

    strcpy(Target, Path);
    strcat(Target, "*.DIR");
    Dsc_Trgt.dsc$w_length = strlen(Target);

        /* find number of subdirs at the target toplevel */

    DirStat = RMS$_NORMAL;
    while(DirStat == RMS$_NORMAL) {
        DirStat = lib$find_file(&Dsc_Trgt, &Dsc_Rslt, &context, 0, 0, 0, &flag);
        if(DirStat == RMS$_NMF || DirStat == RMS$_FNF) break;
        topdircount++;
        ptr1 = strchr(ResultStr, ' ');
        *ptr1 = 0;
    }
    SubStat = lib$find_file_end(&context);
    if(DirStat == RMS$_FNF) return(DirStat);

        /* save list of top directories in TopList array */

    TopList = (TOP_LST *) calloc(topdircount+1, sizeof(TOP_LST));
    TopPtr = TopList;

    Dsc_Trgt.dsc$w_length = strlen(Target);
    DirStat = RMS$_NORMAL;
    while(DirStat == RMS$_NORMAL) {
        DirStat = lib$find_file(&Dsc_Trgt, &Dsc_Rslt, &context, 0, 0, 0, &flag);
        if(DirStat == RMS$_NMF || DirStat == RMS$_FNF) break;
        ptr1 = strchr(ResultStr, ' ');
        *ptr1 = 0;
        ptr1 = strchr(ResultStr, ']');
        ptr2 = strchr(ptr1, '.');
        *ptr1 = '.'; 
        *ptr2++ = ']';
        *ptr2 = 0;
        strcpy(TopPtr->SubDir, ResultStr);
        TopPtr++;
    }
    SubStat = lib$find_file_end(&context);
    
        /* using a local array, get total subdirs under toplevel */

    TopPtr = TopList;
    context = 0;

    while(strlen(TopPtr->SubDir)) {
        strcpy(Target, TopPtr->SubDir);
        ptr1 = strchr(Target, ']');
        *ptr1 = 0;
        strcat(Target, "...]*.DIR;");
        Dsc_Trgt.dsc$w_length = strlen(Target);
        DirStat = RMS$_NORMAL;
        while(DirStat == RMS$_NORMAL) {
            DirStat = lib$find_file(&Dsc_Trgt, &Dsc_Rslt, &context,
                0, 0, 0, &flag);
            if(DirStat == RMS$_NMF || DirStat == RMS$_FNF) break;
            if(DirStat == RMS$_NORMAL) subdircount++;
        }            
        TopPtr->SubdirCount = subdircount + 1; /* add 1 for self */
        NumSubDirs += subdircount;
        subdircount = 0;
        TopPtr++;
        context = 0;
     }

        /* for each base subdir, save subdir full path 
           and path to subdir name */

    NumDirs = NumSubDirs + topdircount;
    FullList = (FULL_LST *) calloc(NumDirs+1, sizeof(FULL_LST));
    FullPtr = FullList;
    TopPtr = TopList;
    context = 0;

    while(strlen(TopPtr->SubDir)) {
        strcpy(Target, TopPtr->SubDir);
        strcpy(dirname, TopPtr->SubDir);
        ptr1 = strrchr(dirname, '.');
        ptr2 = strchr(ptr1, ']');
        *ptr1 = ']'; 
        *ptr2 = 0;
        strcat(dirname, ".DIR;1");
        strcpy(FullPtr->SubdirPath, TopPtr->SubDir);
        strcpy(FullPtr->DirPath, dirname);
        FullPtr++;
        ptr1 = strchr(Target, ']');
        *ptr1 = 0;
        strcat(Target, "...]*.DIR;");
        Dsc_Trgt.dsc$w_length = strlen(Target);
        DirStat = RMS$_NORMAL;
        while(DirStat == RMS$_NORMAL) {
            DirStat = lib$find_file(&Dsc_Trgt, &Dsc_Rslt, &context,
                0, 0, 0, &flag);
            if(DirStat == RMS$_NMF || DirStat == RMS$_FNF) break;
            if(DirStat == RMS$_NORMAL) {
                ptr1 = strchr(ResultStr, ' ');
                *ptr1 = 0;
                strcpy(FullPtr->DirPath, ResultStr);
                ptr1 = strchr(ResultStr, ']');
                ptr2 = strchr(ptr1, '.');
                *ptr1 = '.';
                *ptr2++ = ']';
                *ptr2 = 0;
                strcpy(FullPtr->SubdirPath, ResultStr);
                FullPtr++;
            }
        }
        TopPtr++;
        context = 0;
    }
    SubStat = lib$find_file_end(&context);

        /* save each subdir's depth in FullList array */
 
    FullPtr = FullList;
    while(strlen(FullPtr->SubdirPath)) {
        strcpy(dirname, FullPtr->SubdirPath);
        ptr1 = &dirname;
        ptr2 = 1;
        while(ptr2) {
            ptr2 = strchr(ptr1, '.');
            if(!ptr2) break;
            ptr1 = ptr2+1;
            numdots++;
        }
        FullPtr->DotCount = numdots;
        FullPtr++;
        numdots = 0;
    }

        /* from the base filepath provided by user, for each base subdir
           feed the depth of all subsequent subdirectories to qsort which
           returns deepest subdir at top of list, etc. Create an array of
           all directories for each branch as applicable, sorted by depth,
           and add to master subdir list */

    DirList = (DIR_LST *) calloc(NumDirs+1, sizeof(DIR_LST));
    DirPtr = DirList;
    TopPtr = TopList;
    FullPtr = FullList;

    while(strlen(TopPtr->SubDir)) {
        strcpy(dirname, TopPtr->SubDir);
        ptr1 = strchr(dirname, '[');
        ptr2 = strchr(dirname, ']');
        *ptr2 = 0;
        if(strstr(FullPtr->SubdirPath, ptr1)) sortcount++;
        if(TopPtr->SubdirCount == sortcount) {
            SortList = (SORT_LST *) calloc(sortcount+1, sizeof(SORT_LST));
            SortPtr = SortList;
            FullPtr = FullList + offset;
            for(indx = 0; indx < sortcount; indx++) {
                SortPtr->DotCount = FullPtr->DotCount;
                strcpy(SortPtr->SubDir, FullPtr->SubdirPath);
                strcpy(SortPtr->DirPath, FullPtr->DirPath);
                SortPtr++;
                FullPtr++;
            }
            qsort((void *)SortList, sortcount, sizeof(SORT_LST), DotSort);
            SortPtr = SortList;
            for(indx = 0; indx < sortcount; indx++) {
                strcpy(DirPtr->SubdirPath, SortPtr->SubDir);
                strcpy(DirPtr->DirPath, SortPtr->DirPath);
                SortPtr++;
                DirPtr++;
            }
            FullPtr = FullList;
            TopPtr++;
            offset += sortcount;
            sortcount = 0;
        }
        else FullPtr++;
    }

#ifdef CURIOUS
        /* debugging sometimes leaves one a desire to see what 
           successes have actually occured; hence the excluded
           code segments below */

    FullPtr = FullList;
    while(strlen(FullPtr->SubdirPath)) {
        printf(" %d %s\n", FullPtr->DotCount, FullPtr->SubdirPath);
        FullPtr++;
    }
    printf("\n");

    DirPtr = DirList;
    while(strlen(DirPtr->SubdirPath)) {
        printf(" %s\n", DirPtr->SubdirPath);
        DirPtr++;
    }
#endif

        /* free memory used by work arrays */

    cfree(TopList);
    cfree(FullList);
    cfree(SortList);

    return(SS$_NORMAL);


}    


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: SetDirProt
 * Description: Set the word length protection mask for the object
 *              name buffer pointed to by ObjName. The ProtLoc
 *              constant defines where the new protection mask
 *              is located. The ObjType defines the object class (not used)
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int SetDirProt(char *ObjName, int *ProtLoc, int ObjType)
{
    int acmode = PSL$C_KERNEL;          /* needed for job table mods */
    int context = 0;
    int flags = OSS$M_RELCTX;           /* Mask specifying process options */
    int sdpstat;
    short length = 0;
    char ClassName[32];                 /* Name of object class */

    struct {short buf_size, item_code; long  buf_addr, buf_len;} OssItem[2];

    $DESCRIPTOR(Dsc_Class, ClassName);  /* Descriptor for object class */
    $DESCRIPTOR(Dsc_Obj, ObjName);  /* Descriptor for object name */

    strcpy(ClassName, "FILE");
    acmode = PSL$C_USER;

    Dsc_Class.dsc$w_length = strlen(ClassName);
    Dsc_Obj.dsc$w_length = strlen(ObjName);

    OssItem[0].buf_size = 2;
    OssItem[0].item_code = OSS$_PROTECTION;
    OssItem[0].buf_addr = ProtLoc;
    OssItem[0].buf_len  = 0;
    OssItem[1].buf_size = 0;
    OssItem[1].item_code = 0;

    sdpstat = sys$set_security(&Dsc_Class, &Dsc_Obj, 0, flags, &OssItem,
                              &context, &acmode);
    if(!(sdpstat & 1)) exit(sdpstat);
    return(SS$_NORMAL);
}





/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Function: main
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int main()
{
    int cvtflg = 0;
    int subdirs = TRUE;
    int status;

    long BinDelta[2] = 0;
    long BinDone[2] = 0;
    long BinStart[2] = 0;

    short CvLen;                 /* Length of command verb */
    short DirProt = 0;

    char CmdLine[80];
    char CurPath[80];
    char DirName[60];
    char DeltaStr[25];
    char LineBuf[132];
    char enable_lnm[32];
    char tmpstr[10];
    char *path;
    char *ptr1 = 0;
    char *ptr2;

    $DESCRIPTOR(DscCmd, CmdLine);
    $DESCRIPTOR(DscDelta, DeltaStr);
    $DESCRIPTOR(DscPath, CurPath);
    $DESCRIPTOR(DscSubd, DirName);
    $DESCRIPTOR(DscVerb, CmdVerb); /* foreign invoking symbol name */

    DIR_LST *DirPtr;            /* file pointer for FullList */

    path = getenv("PATH");
    strcpy(CurPath, path);
    DscPath.dsc$w_length = strlen(CurPath);
    status = str$upcase(&DscPath, &DscPath);

        /* define the security logical name, even if not used */

    strcpy(enable_lnm, "SECURE_LNM");

        /* get the command line used to invoke this image */

    status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */
    if(status != SS$_NORMAL) exit(status);
    CmdLine[CvLen] = 0;

        /* extract foreign cmd verb from CmdLine */

    sscanf(CmdLine, "%s", &CmdVerb);
    ptr1 = strchr(CmdVerb, '/');
    if(ptr1) *ptr1 = '\0';
    DscVerb.dsc$w_length = strlen(CmdVerb);
    status = str$upcase(&DscVerb, &DscVerb);

        /* get the cli values from command line */

    GetCliInfo();

        /* we call 'CheckLnm' with the address of the job logical name to check.
           If the return status is SS$_NORMAL, then the logical does in
           fact exist and the pointer address now contains the equivalence
           string of the logical. We then verify this string is what we are
           are expecting and react appropriately. Note that if this test fails,
           the user only receives a AUTHFAIL message for security purposes. */

#ifdef SECURE
        /* Some notes about error messages from the next few lines of code:
            W-AUTHFAIL - indicates logical IS defined, but the equivalence
                         string is defined incorrectly (lowercase?)
            F-AUTHFAIL - Indicates the logical name is not defined in the
                         user's LNM$JOB table or wrong access mode */

    status = CheckLnm(&enable_lnm, sizeof(enable_lnm));
    if(status == SS$_NORMAL) { /* this says logical defined to some str */
        if(strcmp(enable_lnm, "ENABLED") != 0) { /* must match this string */
            exit(0x2760);     /* %SYSTEM-W-AUTHFAIL, authorization failure */
        }
    }
    else exit(0x2764);     /* %SYSTEM-F-AUTHFAIL, authorization failure */
#endif

        /* see if we have privs to delete any file on system */

    status = CheckPrv();
    if(status != SS$_NORMAL) exit(status);

        /* check target directory for validity */

    status = CheckFilePath(&TargetPath);
    if(status != RMS$_NORMAL) {
        if(status == RMS$_DNF) {
            printf("%%%s-E-OPENIN, error opening %s*.*;* as input\n",
                CmdVerb, TargetPath);
            printf("-RMS-E-DNF, directory not found\n\n");
            exit(SS$_NORMAL);
        }
        else if(status == RMS$_FNF) {
            subdirs = FALSE;
            status = SS$_NORMAL;
        }
        else exit(status);
    }

        /* get number of subdirs and paths for this tree */

    if(subdirs) status = GetSubDirs(&TargetPath);
    if(status != SS$_NORMAL) exit(status);

    status = sys$gettim(&BinStart);
    if(NumDirs) {
        DirPtr = DirList;
        while(strlen(DirPtr->SubdirPath)) {

        /* delete all files in the specified directory */

            status = DeleteFiles(DirPtr->SubdirPath);
            if(status != SS$_NORMAL) {
                if(status == SS$_CANCEL || status == SS$_INVARG) exit(status);
                exit(status);
            }

        /* then delete the directory */

            strcpy(DirName, DirPtr->DirPath);
            status = SetDirProt(&DirName, &DirProt, 0);
            if(status != SS$_NORMAL) exit(status);
            DscSubd.dsc$w_length = strlen(DirName);
            status = lib$delete_file(&DscSubd);
            if(status != SS$_NORMAL) exit(status);

            DirPtr++;   /* next dir path */
        }
    }

        /* if the /RETAIN qualifier is present, do not remove base dir 
           the files therein. Default is to remove then */

    if(!RetainFlg) {
        status = DeleteFiles(&TargetPath);     
        if(status != SS$_NORMAL) {
            if(status == SS$_CANCEL || status == SS$_INVARG) exit(status);
                exit(status);
        }
        strcpy(DirName, TargetPath);
        ptr1 = strchr(DirName, ']');
        ptr2 = strchr(ptr1, '.');
        if(!ptr2) {
            ptr1 = strchr(DirName, '[');
            ptr1++;
            ptr2 = strchr(DirName, ']');
            *ptr2 = 0;
            strcpy(tmpstr, ptr1);
            *ptr1 = 0;
            strcat(ptr1, "000000]");
            strcat(ptr1, tmpstr);
            strcat(ptr1, ".DIR;");
        }
        else {
            *ptr1 = '.'; 
            *ptr2++ = ']';
            *ptr2 = 0;
        }
        status = SetDirProt(&DirName, &DirProt, 0);
        DscSubd.dsc$w_length = strlen(DirName);
        status = lib$delete_file(&DscSubd, 0, 0, 0, 0, 0, 0, 0);
        if(status == SS$_NORMAL) NumDirs++;
    }

        /* calc and display elapsed time of operation */

    status = sys$gettim(&BinDone);
    status = lib$sub_times(&BinDone, &BinStart, &BinDelta);
    status = sys$asctim(&CvLen, &DscDelta, &BinDelta, &cvtflg);
    DeltaStr[CvLen] = 0;

    printf("\n%%%s-I-SUMMARY, deleted %d files in %d directories,",
        CmdVerb, NumFiles+NumDirs, NumDirs);
    printf(" %d/%d blocks\n", TotalUsed, TotalAlloc);
    printf("%%%s-I-TIME, elapsed time %s\n\n", CmdVerb, DeltaStr);
}
 

