P C------------------------------------------------------------------------------- C  $ COMPARE_DIR p1  p2 6 C	/[NO]DATE=(CREATED,MODIFIED,EXPIRED,BACKUP,ALL,NONE)( C	/[NO]SIZE			! compare number of blocks; C	/INGORE=VERSION			! ignore differences in version number, = C	/IGNORE=MISSING=[EITHER/P1/P2]]	!   or ignore missing files > C!!!!	/EXCLUDE=filespec		! don't compare files that match this0 C	/SHOW=(SAME/DIFF/MISSING/ALL)	! type of output( C	/[no]BRIEF			! format of output, brief& C	/[no]FULL			! format of output, full$ C	/OUTPUT=filename		! output to file3 C	/COMMAND_FILE=filename		! copy comand output file $ C	   /FROM=(P1/P2/FIRST/SECOND/BOTH) C	   /SELECT_BY=()* C	/COPYWRITE			! list OSF copywrite notice C  C 7 C on remote nodes, must have REM_COMP_DIR.EXE and enter C C     $ NCP DEF OBJ REM_COMP_DIR NUMBER 0 FILE dev:REM_COMP_DIR.EXE C C and $ NCP SET OBJ REM_COMP_DIR NUMBER 0 FILE dev:REM_COMP_DIR.EXE  C P C------------------------------------------------------------------------------- 	PROGRAM COMPARE_DIRECTORIES 	IMPLICIT NONE C   	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C  	CALL CDIR$OPEN_SYSERROR() 	CALL CDIR$GET_PARAMS()  	CALL CDIR$OPEN_OUTPUT(), 	IF(CD.COPYWRITE) CALL CDIR$SHOW_COPYWRITE()* 	IF(CD.DEBUG) CALL CDIR$DEBUG_VERIFY_CLD()  	CALL CDIR$COMPARE_DIRECTORIES() 	CALL CDIR$CLOSE_OUTPUT() 
 	CALL EXIT 	END C;; ! 	SUBROUTINE CDIR$SHOW_COPYWRITE()  	IMPLICIT NONE 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU]    10	FORMAT(/'COMPARE_DIR, Version 0.1, Compares the contents of two directory structures.', G      >	     /,'Copywrite (C) 1994 Tim Fogarty  (fogarty@netcom.com)',/) W    20	FORMAT(5x,'This program is free software; you can redistribute it and/or modify', X      >	     /,5x,'it under the terms of the GNU General Public License as published by',U      >	     /,5x,'the Free Software Foundation; either version 2 of the License, or', :      >       /,5x,'(at your option) any later version.',/)R    30	FORMAT(5x,'This program is distributed in the hope that it will be useful,',R      >	     /,5x,'but WITHOUT ANY WARRANTY; without even the implied warranty of',Q      >	     /,5x,'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the', B      >	     /,5x,'GNU General Public License for more details.',/)T    40	FORMAT(5x,'You should have received a copy of the GNU General Public License',O      >	     /,5x,'along with this program; if not, write to the Free Software', N      >	     /,5x,'Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.'/) C  	WRITE(OLU,10) 	WRITE(OLU,20) 	WRITE(OLU,30) 	WRITE(OLU,40) 	RETURN  	END C;; # 	SUBROUTINE CDIR$DEBUG_VERIFY_CLD()  	IMPLICIT NONE 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU C   	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C   	IF(CD.FIRST.DIR_IS_REMOTE) THEN= 	  WRITE(ELU,*) ' first dir is remote on ',CD.first.node_name } 	  IF(CD.first.user_pass_length .gt.0) WRITE(ELU,*) ' using remote username ',CD.first.user_pass(1:CD.first.user_pass_length)  	ENDIF5 	WRITE(ELU,*) ' first dir  ',CD.first.file_name(1:60) ! 	IF(CD.SECOND.DIR_IS_REMOTE) THEN ? 	  WRITE(ELU,*) ' second dir is remote on ',CD.second.node_name  	  IF(CD.second.user_pass_length .gt.0) WRITE(ELU,*) ' using remote username ',CD.second.user_pass(1:CD.second.user_pass_length) 	ENDIF6 	WRITE(ELU,*) ' second dir ',CD.second.file_name(1:60) C < 	WRITE(ELU,*) ' create              ',CD.compare_create_date= 	WRITE(ELU,*) ' revised             ',CD.compare_revised_date = 	WRITE(ELU,*) ' expires             ',CD.compare_expires_date < 	WRITE(ELU,*) ' backup              ',CD.compare_backup_date5 	WRITE(ELU,*) ' size                ',CD.compare_size 7 	WRITE(ELU,*) ' ignore version      ',CD.ignore_version 5 	WRITE(ELU,*) ' ignore missing P1   ',CD.ignore_first 6 	WRITE(ELU,*) ' ignore missing P2   ',CD.ignore_second2 	WRITE(ELU,*) ' show same           ',CD.show_same7 	WRITE(ELU,*) ' show different      ',CD.show_different 5 	WRITE(ELU,*) ' show missing        ',CD.show_missing < 	WRITE(ELU,*) ' output format       ',CD.output_format_brief: 	WRITE(ELU,*) ' log output to       ',CD.output_file(1:60)1 	WRITE(ELU,*) ' create copy com file',CD.copy_com 7 	WRITE(ELU,*) ' com file            ',CD.com_file(1:60) 0 	WRITE(ELU,*) ' copy from p1        ',CD.from_p10 	WRITE(ELU,*) ' copy from p2        ',CD.from_p22 	WRITE(ELU,*) ' select by           ',CD.select_by1 	WRITE(ELU,*) ' by newer/bigger     ',CD.by_newer  	RETURN  	END C;; 	SUBROUTINE CDIR$GET_PARAMS()  	IMPLICIT NONE 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU C   	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C     10   FORMAT(A)  C  	INTEGER*4 I1,IFLAG & 	INTEGER*4 WA_UI$CLI_QUALIFIER_PRESENT% 	INTEGER*4 WA_UI$CLI_THREEWAY_PRESENT  	INCLUDE 'COMPARE_PARAMS.FOR'  	CHARACTER FILE_NAME*256P C-------------------------------------------------------------------------------6 	CALL WA_UI$CLI_GET_STRING('DIR1',FILE_NAME,I1,.TRUE.)0 	CALL CDIR$PARSE_FILENAME(FILE_NAME,I1,CD.FIRST) C 6 	CALL WA_UI$CLI_GET_STRING('DIR2',FILE_NAME,I1,.TRUE.)1 	CALL CDIR$PARSE_FILENAME(FILE_NAME,I1,CD.SECOND)  C 9 	IF(CD.FIRST.DOT_DOT_DOT .NE. CD.SECOND.DOT_DOT_DOT) THEN / 	  WRITE(ELU,10) 'ERROR IN FILE SPECIFICATIONS' ' 	  WRITE(ELU,10) 'BOTH MUST HAVE [...]'  	  STOP 'ABORT'  	ENDIFP C-------------------------------------------------------------------------------. 	CD.COMPARE_CREATE_DATE=.FALSE.			! /NODATE or3 	CD.COMPARE_REVISED_DATE=.FALSE.			! /DATE=NOALL or / 	CD.COMPARE_EXPIRES_DATE=.FALSE.			! /DATE=NONE  	CD.COMPARE_BACKUP_DATE=.FALSE.  C - 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('DATE_ALL') / 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN			! /DATE=ALL   	  CD.COMPARE_CREATE_DATE=.TRUE.! 	  CD.COMPARE_REVISED_DATE=.TRUE. ! 	  CD.COMPARE_EXPIRES_DATE=.TRUE.   	  CD.COMPARE_BACKUP_DATE=.TRUE. 	ENDIF C 1 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('DATE_CREATED') ! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN   	  CD.COMPARE_CREATE_DATE=.TRUE.% 	ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN ! 	  CD.COMPARE_CREATE_DATE=.FALSE.  	ENDIF C 2 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('DATE_MODIFIED')! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN ! 	  CD.COMPARE_REVISED_DATE=.TRUE. % 	ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN " 	  CD.COMPARE_REVISED_DATE=.FALSE. 	ENDIF C 1 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('DATE_EXPIRED') ! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN ! 	  CD.COMPARE_EXPIRES_DATE=.TRUE. % 	ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN " 	  CD.COMPARE_EXPIRES_DATE=.FALSE. 	ENDIF C 0 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('DATE_BACKUP')! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN   	  CD.COMPARE_BACKUP_DATE=.TRUE.% 	ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN ! 	  CD.COMPARE_BACKUP_DATE=.FALSE.  	ENDIFP C-------------------------------------------------------------------------------) 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('SIZE') ( 	CD.COMPARE_SIZE=IFLAG.EQ.WA$CLI_PRESENTP C-------------------------------------------------------------------------------3 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('IGNORE_VERSION') * 	CD.IGNORE_VERSION=IFLAG.EQ.WA$CLI_PRESENTP C-------------------------------------------------------------------------------; 	IF(.NOT.WA_UI$CLI_QUALIFIER_PRESENT('MISSING_FILES')) THEN  	  CD.IGNORE_FIRST=.FALSE. 	  CD.IGNORE_SECOND=.FALSE. ; 	ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('IGNORE_MISSING')) THEN  	  CD.IGNORE_FIRST=.TRUE.  	  CD.IGNORE_SECOND=.TRUE.6 	ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('IGNORE_P1')) THEN 	  CD.IGNORE_FIRST=.TRUE.  	  CD.IGNORE_SECOND=.FALSE. 9 	ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('IGNORE_FIRST')) THEN  	  CD.IGNORE_FIRST=.TRUE.  	  CD.IGNORE_SECOND=.FALSE. 6 	ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('IGNORE_P2')) THEN 	  CD.IGNORE_FIRST=.FALSE. 	  CD.IGNORE_SECOND=.TRUE.: 	ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('IGNORE_SECOND')) THEN 	  CD.IGNORE_FIRST=.FALSE. 	  CD.IGNORE_SECOND=.TRUE. 	ELSE  	  CD.IGNORE_FIRST=.FALSE. 	  CD.IGNORE_SECOND=.FALSE.  	ENDIFP C-------------------------------------------------------------------------------* 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('BRIEF')! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN   	  CD.OUTPUT_FORMAT_BRIEF=.TRUE.% 	ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN ! 	  CD.OUTPUT_FORMAT_BRIEF=.FALSE.  	ELSE + 	  IFLAG=WA_UI$CLI_THREEWAY_PRESENT('FULL') # 	  IF(IFLAG.EQ.WA$CLI_PRESENT) THEN # 	    CD.OUTPUT_FORMAT_BRIEF=.FALSE. ' 	  ELSEIF(IFLAG.EQ.WA$CLI_NEGATED) THEN " 	    CD.OUTPUT_FORMAT_BRIEF=.TRUE. 	  ELSE " 	    CD.OUTPUT_FORMAT_BRIEF=.TRUE. 	  ENDIF 	ENDIFP C------------------------------------------------------------------------------- 	CD.SHOW_SAME=.FALSE.  	CD.SHOW_DIFFERENT=.FALSE. 	CD.SHOW_MISSING=.FALSE. C - 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('SHOW_ALL') ! 	IF(IFLAG.EQ.WA$CLI_PRESENT) THEN  	  CD.SHOW_SAME=.TRUE. 	  CD.SHOW_DIFFERENT=.TRUE.  	  CD.SHOW_MISSING=.TRUE.  	ENDIF C . 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('SHOW_SAME')! 	IF(IFLAG.EQ.WA$CLI_NEGATED) THEN  	  CD.SHOW_SAME=.FALSE. % 	ELSEIF(IFLAG.EQ.WA$CLI_PRESENT) THEN  	  CD.SHOW_SAME=.TRUE. 	ENDIF C . 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('SHOW_DIFF')! 	IF(IFLAG.EQ.WA$CLI_NEGATED) THEN  	  CD.SHOW_DIFFERENT=.FALSE.% 	ELSEIF(IFLAG.EQ.WA$CLI_PRESENT) THEN  	  CD.SHOW_DIFFERENT=.TRUE.  	ENDIF C 1 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('SHOW_MISSING') ! 	IF(IFLAG.EQ.WA$CLI_NEGATED) THEN  	  CD.SHOW_MISSING=.FALSE.% 	ELSEIF(IFLAG.EQ.WA$CLI_PRESENT) THEN  	  CD.SHOW_MISSING=.TRUE.  	ENDIFP C-------------------------------------------------------------------------------+ 	IFLAG=WA_UI$CLI_THREEWAY_PRESENT('OUTPUT') / 	IF(IFLAG.EQ.WA$CLI_NEGATED) THEN			! NO OUTPUT  	  CD.OUTPUT_TO_FILE=.FALSE. 	  CD.SHOW_SAME=.FALSE.  	  CD.SHOW_DIFFERENT=.FALSE. 	  CD.SHOW_MISSING=.FALSE.% 	ELSEIF(IFLAG.EQ.WA$CLI_PRESENT) THEN  	  CD.OUTPUT_TO_FILE=.TRUE. ? 	  CALL WA_UI$CLI_GET_STRING('OUTPUT',CD.OUTPUT_FILE,I1,.TRUE.)  	ENDIFP C-------------------------------------------------------------------------------8 	CD.COPY_COM=WA_UI$CLI_QUALIFIER_PRESENT('COMMAND_FILE') 	IF(CD.COPY_COM) THEN   	  IF(CD.FIRST.DOT_DOT_DOT) THENL 	    WRITE(ELU,10) 'ERROR - UNABLE TO COPY FILES TO SUBDIRECTORY STRUCTURES' 	    CD.COPY_COM=.FALSE. 	  ELSE D 	    CALL WA_UI$CLI_GET_STRING('COMMAND_FILE',CD.COM_FILE,I1,.TRUE.); 	    IF(WA_UI$CLI_QUALIFIER_PRESENT('COPY_FROM_BOTH')) THEN  	      CD.FROM_P1=.TRUE. 	      CD.FROM_P2=.TRUE.= 	    ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('COPY_FROM_P1')) THEN  	      CD.FROM_P1=.TRUE. 	      CD.FROM_P2=.FALSE. = 	    ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('COPY_FROM_P2')) THEN  	      CD.FROM_P1=.FALSE.  	      CD.FROM_P2=.TRUE.@ 	    ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('COPY_FROM_FIRST')) THEN 	      CD.FROM_P1=.TRUE. 	      CD.FROM_P2=.FALSE. A 	    ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('COPY_FROM_SECOND')) THEN  	      CD.FROM_P1=.FALSE.  	      CD.FROM_P2=.TRUE.	 	    ELSE  	      CD.FROM_P1=.FALSE.  	      CD.FROM_P2=.FALSE. 
 	    ENDIF C 8 	    IF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_TYPE')) THEN: 	      IF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_SIZE')) THEN  		CD.SELECT_BY=CD$SELECT_BY_SIZE? 		CD.BY_NEWER=WA_UI$CLI_QUALIFIER_PRESENT('SELECT_SIZE.BIGGER') @ 	      ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_CREATE')) THEN' 		CD.SELECT_BY=CD$SELECT_BY_CREATE_DATE @ 		CD.BY_NEWER=WA_UI$CLI_QUALIFIER_PRESENT('SELECT_CREATE.NEWER')@ 	      ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_MODIFY')) THEN' 		CD.SELECT_BY=CD$SELECT_BY_MODIFY_DATE @ 		CD.BY_NEWER=WA_UI$CLI_QUALIFIER_PRESENT('SELECT_MODIFY.NEWER')@ 	      ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_BACKUP')) THEN' 		CD.SELECT_BY=CD$SELECT_BY_BACKUP_DATE @ 		CD.BY_NEWER=WA_UI$CLI_QUALIFIER_PRESENT('SELECT_BACKUP.NEWER')@ 	      ELSEIF(WA_UI$CLI_QUALIFIER_PRESENT('SELECT_EXPIRE')) THEN' 		CD.SELECT_BY=CD$SELECT_BY_EXPIRE_DATE @ 		CD.BY_NEWER=WA_UI$CLI_QUALIFIER_PRESENT('SELECT_EXPIRE.NEWER') 	      ELSE $ 		CD.SELECT_BY=CD$SELECT_BY_ANY_DIFF 	      ENDIF	 	    ELSE % 	      CD.SELECT_BY=CD$SELECT_BY_NONE 
 	    ENDIF 	  ENDIF 	ENDIFP C-------------------------------------------------------------------------------6 	CD.COPYWRITE=WA_UI$CLI_QUALIFIER_PRESENT('COPYWRITE'). 	CD.DEBUG=WA_UI$CLI_QUALIFIER_PRESENT('DEBUG') 	RETURN  	END C;; 8 	SUBROUTINE CDIR$PARSE_FILENAME(FILE_NAME,I1,FILE_PARAM) 	IMPLICIT NONE 	CHARACTER FILE_NAME*(*),LC  	INTEGER*4 I1,I2,I3   	INCLUDE 'COMPARE_DIR_STRUC.FOR'( 	RECORD/DIR_DIFF_FNAME_STRUC/ FILE_PARAM C  	I2=INDEX(FILE_NAME,'::')  	IF(I2.GT.1) THEN $ 	  FILE_PARAM.DIR_IS_REMOTE = .TRUE.  	  I3=INDEX(FILE_NAME(1:I2),'"') 	  IF(I3.GT.1) THEN + 	    FILE_PARAM.NODE_NAME=FILE_NAME(1:I3-1) , 	    FILE_PARAM.USER_PASS=FILE_NAME(I3:I2-1)& 	    FILE_PARAM.USER_PASS_LENGTH=I2-I3 	  ELSE + 	    FILE_PARAM.NODE_NAME=FILE_NAME(1:I2-1)  	    FILE_PARAM.USER_PASS=' ' " 	    FILE_PARAM.USER_PASS_LENGTH=0 	  ENDIF* 	  FILE_PARAM.FILE_NAME=FILE_NAME(I2+2:I1)
 	  I1=I1-I2-1  	ELSE # 	  FILE_PARAM.DIR_IS_REMOTE=.FALSE.   	  FILE_PARAM.USER_PASS_LENGTH=0 	  FILE_PARAM.NODE_NAME=' ' ' 	  FILE_PARAM.FILE_NAME=FILE_NAME(1:I1)  	ENDIF3 	FILE_PARAM.DOT_DOT_DOT=INDEX(FILE_NAME,'...').GT.0 ! 	LC = FILE_PARAM.FILE_NAME(I1:I1) > 	IF(LC.EQ.']'.OR.LC.EQ.':') FILE_PARAM.FILE_NAME(I1+1:)='*.*;' 	RETURN  	END C;;P C------------------------------------------------------------------------------- C P C-------------------------------------------------------------------------------  	SUBROUTINE CDIR$OPEN_SYSERROR() 	IMPLICIT NONE 	INTEGER*4 IOS 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU C  	integer*4 status,lib$get_lun  c  	STATUS=LIB$GET_LUN(ELU). 	if(.not.status) call lib$signal(%val(status)). 	OPEN(UNIT=ELU,FILE='SYS$ERROR:',STATUS='NEW',.      >	     CARRIAGECONTROL='LIST',IOSTAT=IOS), 	IF(IOS.NE.0) STOP 'ERROR OPENING SYS$ERROR' 	RETURN  	END C;; P C------------------------------------------------------------------------------- C P C------------------------------------------------------------------------------- 	SUBROUTINE CDIR$OPEN_OUTPUT() 	IMPLICIT NONE  	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C  	INTEGER*4 IOS 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU C  	integer*4 status,lib$get_lun  C  	status=LIB$GET_LUN(OLU). 	if(.not.status) call lib$signal(%val(status)) 	IF(CD.OUTPUT_TO_FILE) THEN 2 	  OPEN(UNIT=OLU,FILE=CD.OUTPUT_FILE,STATUS='NEW',*      >		CARRIAGECONTROL='LIST',IOSTAT=IOS)0 	  IF(IOS.NE.0) STOP 'ERROR OPENING OUTPUT FILE' 	ELSE 5 	  OPEN(UNIT=OLU,FILE='SYS$OUTPUT:',STATUS='UNKNOWN', *      >		CARRIAGECONTROL='LIST',IOSTAT=IOS)/ 	  IF(IOS.NE.0) STOP 'ERROR OPENING SYS$OUTPUT'  	ENDIF C  	IF(CD.COPY_COM) THEN  	  status=LIB$GET_LUN(CLU)0 	  if(.not.status) call lib$signal(%val(status))/ 	  OPEN(UNIT=CLU,FILE=CD.COM_FILE,STATUS='NEW', *      >		CARRIAGECONTROL='LIST',IOSTAT=IOS)2 	  IF(IOS.NE.0) STOP 'ERROR OPENING COPY COM FILE' 	ENDIF C  	RETURN  	END C;;  	SUBROUTINE CDIR$CLOSE_OUTPUT()  	IMPLICIT NONE  	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C  	INTEGER*4 IOS 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU C  	IF(CD.COPY_COM) THEN 
 	  CLOSE(CLU)  	  CALL LIB$FREE_LUN(CLU)  	ENDIF 	CLOSE(OLU)  	CALL LIB$FREE_LUN(OLU)  	CLOSE(ELU)  	CALL LIB$FREE_LUN(ELU)  	RETURN  	END C;;P C------------------------------------------------------------------------------- C P C-------------------------------------------------------------------------------& 	SUBROUTINE CDIR$COMPARE_DIRECTORIES() 	IMPLICIT NONE  	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CD  	COMMON/DIR_DIFF_BLK/ CD C 4 	INTEGER*4 I1,I2,SUBDIRS,SHOW_EXTRA_P1,SHOW_EXTRA_P2$ 	INTEGER*4 CDIR$COMPARE_NAMES,STATUS 	INCLUDE 'COMPARE_PARAMS.FOR'  C  	INCLUDE 'COMP_MATCH_STRUC.FOR' . 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH1,MATCH2" 	CHARACTER*256 MATCH_ONE,MATCH_TWO C  C  init context for file-spec-1  C  	MATCH1.MORE=.TRUE.  	MATCH1.REMOTE_LU=0  	MATCH1.CONTEXT=0  	MATCH1.COPY_FROM=CD.FROM_P1L 	IF(CD.FIRST.DIR_IS_REMOTE) CALL CDIR$ESTABLISH_REMOTE_LINK(CD.FIRST,MATCH1)/ 	CALL STR$TRIM(MATCH_ONE,CD.FIRST.FILE_NAME,I1) 0 	CALL CDIR$GET_NEXT_FILE(MATCH_ONE(1:I1),MATCH1) C  C  init context for file-spec-2  C  	MATCH2.MORE=.TRUE.  	MATCH2.REMOTE_LU=0  	MATCH2.CONTEXT=0  	MATCH2.COPY_FROM=CD.FROM_P2N 	IF(CD.SECOND.DIR_IS_REMOTE) CALL CDIR$ESTABLISH_REMOTE_LINK(CD.SECOND,MATCH2)0 	CALL STR$TRIM(MATCH_TWO,CD.SECOND.FILE_NAME,I2)0 	CALL CDIR$GET_NEXT_FILE(MATCH_TWO(1:I2),MATCH2) Cb 	SUBDIRS=CD.FIRST.DOT_DOT_DOT	% 	SHOW_EXTRA_P1=.NOT. CD.IGNORE_SECONDr$ 	SHOW_EXTRA_P2=.NOT. CD.IGNORE_FIRST C 7 C  compare for each file that matches file-spec-1 or -2t Cm' 	DO WHILE(MATCH1.MORE .OR. MATCH2.MORE)// 	  IF(.NOT. MATCH1.MORE) THEN			! no more f-s-1	A 	    IF(SHOW_EXTRA_P2) CALL CDIR$NOTE_MISSING_FILE(MATCH2,MATCH1) 4 	    CALL CDIR$GET_NEXT_FILE(MATCH_TWO(1:I2),MATCH2)2 	  ELSEIF(.NOT. MATCH2.MORE) THEN		! no more f-s-2A 	    IF(SHOW_EXTRA_P1) CALL CDIR$NOTE_MISSING_FILE(MATCH1,MATCH2)S4 	    CALL CDIR$GET_NEXT_FILE(MATCH_ONE(1:I1),MATCH1) 	  ELSE						! more fileseG 	    STATUS=CDIR$COMPARE_NAMES(MATCH1,MATCH2,CD.IGNORE_VERSION,SUBDIRS) 5 	    IF(STATUS.EQ.CD$FILE1_EQ_FILE2) THEN	! same nameC2 	      CALL CDIR$COMPARE_ATTRIBUTES(MATCH1,MATCH2)F 	      IF(MATCH1.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_ONE(1:I1),MATCH1)F 	      IF(MATCH2.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_TWO(1:I2),MATCH2)B 	    ELSEIF(STATUS.EQ.CD$FILE1_LT_FILE2) THEN	! FILE1 before FILE20 	      IF(SUBDIRS .AND. MATCH2.NEXT_SUBDIR) THEN 		type *,' 2 changed subdirs'A> 		IF(SHOW_EXTRA_P1) CALL CDIR$NOTE_MISSING_FILE(MATCH1,MATCH2)A 		IF(MATCH1.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_ONE(1:I1),MATCH1)  	      ELSEE> 		IF(SHOW_EXTRA_P1) CALL CDIR$NOTE_MISSING_FILE(MATCH1,MATCH2)A 		IF(MATCH1.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_ONE(1:I1),MATCH1)O 	      ENDIF" 	    ELSE					! FILE2 before FILE10 	      IF(SUBDIRS .AND. MATCH1.NEXT_SUBDIR) THEN 		type *,' 2 changed subdirs't> 		IF(SHOW_EXTRA_P2) CALL CDIR$NOTE_MISSING_FILE(MATCH2,MATCH1)A 		IF(MATCH2.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_TWO(1:I2),MATCH2)  	      ELSEr> 		IF(SHOW_EXTRA_P2) CALL CDIR$NOTE_MISSING_FILE(MATCH2,MATCH1)A 		IF(MATCH2.MORE) CALL CDIR$GET_NEXT_FILE(MATCH_TWO(1:I2),MATCH2)  	      ENDIF
 	    ENDIF 	  ENDIF 	END DOu 	CALL CDIR$END_CONTEXT(MATCH1) 	CALL CDIR$END_CONTEXT(MATCH2) 	RETURNb 	END C;;P C------------------------------------------------------------------------------- CvP C-------------------------------------------------------------------------------I 	INTEGER*4 FUNCTION CDIR$COMPARE_NAMES(MATCH1,MATCH2,NO_VERSION,SUB_DIRS)e 	IMPLICIT NONE 	INCLUDE 'COMP_MATCH_STRUC.FOR'l. 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH1,MATCH2 Cc 	INTEGER*4 NO_VERSION,SUB_DIRS 	INTEGER*4 B1,B2,E1,E2 	INCLUDE 'COMPARE_PARAMS.FOR'  C  	IF(SUB_DIRS) THEN% 	  B1=MATCH1.L2+1			! location of "["M 	  B2=MATCH2.L2+1 $ 	  E1=MATCH1.L3				! location of "]" 	  E2=MATCH2.L3E8 	  IF(MATCH1.FNAME(B1:E1) .GT. MATCH2.FNAME(B2:E2)) THEN) 	    CDIR$COMPARE_NAMES=CD$FILE1_LT_FILE2E 	    RETURNO< 	  ELSEIF(MATCH1.FNAME(B1:E1) .LT. MATCH2.FNAME(B2:E2)) THEN) 	    CDIR$COMPARE_NAMES=CD$FILE1_GT_FILE2M 	    RETURNB 	  ENDIF 	ENDIF CR* 	B1=MATCH1.L3+1				! beginning of filename 	B2=MATCH2.L3+1  	IF(NO_VERSION) THENB 	  E1=INDEX(MATCH1.FNAME,';')-1		! end of filename w/o version num 	  E2=INDEX(MATCH2.FNAME,';')-11 	ELSEs$ 	  E1=MATCH1.L4				! end of filename 	  E2=MATCH2.L4  	ENDIF C.4 	IF(MATCH1.FNAME(B1:E1).EQ.MATCH2.FNAME(B2:E2)) THEN' 	  CDIR$COMPARE_NAMES=CD$FILE1_EQ_FILE2 8 	ELSEIF(MATCH1.FNAME(B1:E1).LT.MATCH2.FNAME(B2:E2)) THEN' 	  CDIR$COMPARE_NAMES=CD$FILE1_LT_FILE2e 	ELSEe' 	  CDIR$COMPARE_NAMES=CD$FILE1_GT_FILE2t 	ENDIF 	RETURNE 	END C;;P C------------------------------------------------------------------------------- CmP C-------------------------------------------------------------------------------3 	SUBROUTINE CDIR$NOTE_MISSING_FILE(MATCH_A,MATCH_B)r 	IMPLICIT NONE 	INCLUDE 'COMP_MATCH_STRUC.FOR'D0 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH_A,MATCH_B C  	INCLUDE 'COMPARE_PARAMS.FOR'E 	INTEGER*4 L3a,L4a,L3b 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU CD  	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CDe 	COMMON/DIR_DIFF_BLK/ CD Cm"    10	FORMAT(A,' not found in ',A)     20	FORMAT('----------------')#    30	FORMAT(A,/,'not found in ',A)m    40	FORMAT('$ COPY ',A,' ',A)  CI0 	L3a=MATCH_A.L3+1		! beginning of first filename) 	L4a=MATCH_A.L4			! end of first filename 1 	L3b=MATCH_B.L3			! end of second node/device/dir  C  	IF(CD.SHOW_MISSING) THENE" 	  IF(CD.OUTPUT_FORMAT_BRIEF) THENE             WRITE(OLU,10) MATCH_A.FNAME(L3a:L4a),MATCH_B.FNAME(1:L3b)E 	  ELSEo 	    WRITE(OLU,20)C             WRITE(OLU,30) MATCH_A.FNAME(1:L4a),MATCH_B.FNAME(1:L3b)E 	  ENDIF 	ENDIF Cg- 	IF(CD.COPY_COM .AND. MATCH_A.COPY_FROM) THENS: 	  WRITE(CLU,40) MATCH_A.FNAME(1:L4a),MATCH_B.FNAME(1:L3b) 	ENDIF 	RETURN/ 	END C;;P C------------------------------------------------------------------------------- C P C-------------------------------------------------------------------------------2 	SUBROUTINE CDIR$COMPARE_ATTRIBUTES(MATCH1,MATCH2) 	IMPLICIT NONE 	INCLUDE 'COMP_MATCH_STRUC.FOR'F. 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH1,MATCH2 C- 	INCLUDE 'COMPARE_PARAMS.FOR'- 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU CI 	INTEGER*4 CTIME1(2),CTIME2(2) 	INTEGER*4 RTIME1(2),RTIME2(2) 	INTEGER*4 ETIME1(2),ETIME2(2) 	INTEGER*4 BTIME1(2),BTIME2(2) 	INTEGER*4 SIZE1,SIZE2 	INTEGER*4 SELECT_1,SELECT_2# 	INTEGER*4 CT,RT,ET,BT,SZ,DIFFERENTS 	INTEGER*4 STATUST 	INTEGER*4 CDIR$GET_FILE_INFON 	INTEGER*4 CDIR$COMPARE_TIMESE 	INTEGER*4 CDIR$DECIDE_TO_COPY 	INTEGER*4 L 	CHARACTER MESSAGE*72- 	CHARACTER STR1*20,STR2*20 C-  	INCLUDE 'COMPARE_DIR_STRUC.FOR' 	RECORD/COMPARE_DIR_STRUC/ CDF 	COMMON/DIR_DIFF_BLK/ CD CP-    10	FORMAT(A,' exist in both directories,')C*    15	FORMAT('  but ',A,' are different.')     20	FORMAT('----------------')    30	FORMAT(A)_=    31	FORMAT('Created times are different: ',A,' and ',A,'.')N=    32	FORMAT('Revised times are different: ',A,' and ',A,'.').=    33	FORMAT('Expires times are different: ',A,' and ',A,'.') =    34	FORMAT('Backup times are different:  ',A,' and ',A,'.')I9    35	FORMAT('Sizes are different: ',I10,' and ',I10,'.')S2    50	FORMAT(A,' is the same in both directories')    60	FORMAT('matches'))    90	FORMAT('$ COPY ',A,' ',A)= CLA 	IF(CD.SHOW_DIFFERENT + CD.SHOW_SAME + CD.COPY_COM .EQ. 0) RETURN)  D 	STATUS=CDIR$GET_FILE_INFO(MATCH1,CTIME1,RTIME1,ETIME1,BTIME1,SIZE1). 	IF(.NOT.STATUS) CALL LIB$SIGNAL(%VAL(STATUS)) CPD 	STATUS=CDIR$GET_FILE_INFO(MATCH2,CTIME2,RTIME2,ETIME2,BTIME2,SIZE2). 	IF(.NOT.STATUS) CALL LIB$SIGNAL(%VAL(STATUS)) CE( 	SZ=CD.COMPARE_SIZE .AND. SIZE1.NE.SIZE2D 	CT=CD.COMPARE_CREATE_DATE .AND. CDIR$COMPARE_TIMES(CTIME1,CTIME2,0)E 	RT=CD.COMPARE_REVISED_DATE .AND. CDIR$COMPARE_TIMES(RTIME1,RTIME2,0)FE 	ET=CD.COMPARE_EXPIRES_DATE .AND. CDIR$COMPARE_TIMES(ETIME1,ETIME2,0)(D 	BT=CD.COMPARE_BACKUP_DATE .AND. CDIR$COMPARE_TIMES(BTIME1,BTIME2,0)% 	DIFFERENT=CT.OR.RT.OR.ET.OR.BT.OR.SZ- C- 	IF(DIFFERENT) THEN- 	  IF(CD.SHOW_DIFFERENT) THEN_$ 	    IF(CD.OUTPUT_FORMAT_BRIEF) THEN3 		WRITE(OLU,10) MATCH1.FNAME(MATCH1.L3+1:MATCH1.L4)- 		L=1- 		IF(SZ) THEN					! SIZE 		  MESSAGE(L:)='Sizes, '-	 		  L=L+7W 		ENDIFT CE
 		IF(CT) THENN! 		  MESSAGE(L:)='Created Times, 'I
 		  L=L+15 		ENDIFT C-
 		IF(RT) THEN-" 		  MESSAGE(L:)='Modified Times, '
 		  L=L+16 		ENDIF- C-
 		IF(ET) THENI! 		  MESSAGE(L:)='Expired Times, 'E
 		  L=L+15 		ENDIFO CF
 		IF(BT) THEN   		  MESSAGE(L:)='Backup Times, '
 		  L=L+14 		ENDIF_ 		L=L-3I 		IF(L.LT.1) L=1 		WRITE(OLU,15) MESSAGE(1:L) 	    ELSE				! format not briefE 	      WRITE(OLU,20). 	      WRITE(OLU,30) MATCH1.FNAME(1:MATCH1.L4). 	      WRITE(OLU,30) MATCH2.FNAME(1:MATCH2.L4) 	      IF(CT) THEN  		CALL SYS$ASCTIM(,STR1,CTIME1,)  		CALL SYS$ASCTIM(,STR2,CTIME2,) 		WRITE(OLU,31) STR1,STR2S 	      ENDIF 	      IF(RT) THEN  		CALL SYS$ASCTIM(,STR1,RTIME1,)  		CALL SYS$ASCTIM(,STR2,RTIME2,) 		WRITE(OLU,32) STR1,STR2L 	      ENDIF 	      IF(ET) THEN  		CALL SYS$ASCTIM(,STR1,ETIME1,)  		CALL SYS$ASCTIM(,STR2,ETIME2,) 		WRITE(OLU,33) STR1,STR2  	      ENDIF 	      IF(BT) THEN  		CALL SYS$ASCTIM(,STR1,BTIME1,)  		CALL SYS$ASCTIM(,STR2,BTIME2,) 		WRITE(OLU,34) STR1,STR2_ 	      ENDIF' 	      IF(SZ) WRITE(OLU,35) SIZE1,SIZE2R$ 	    ENDIF					! end show brief/full 	  ENDIF						! show different CE 	  IF(CD.COPY_COM) THENT; 	    SELECT_1=CDIR$DECIDE_TO_COPY(CD.SELECT_BY,CD.BY_NEWER,R+      >			SIZE1,CTIME1,RTIME1,ETIME1,BTIME1,)+      >			SIZE2,CTIME2,RTIME2,ETIME2,BTIME2) ; 	    SELECT_2=CDIR$DECIDE_TO_COPY(CD.SELECT_BY,CD.BY_NEWER,A+      >			SIZE2,CTIME2,RTIME2,ETIME2,BTIME2,A+      >			SIZE1,CTIME1,RTIME1,ETIME1,BTIME1)-j 	    IF(MATCH1.COPY_FROM .AND. SELECT_1) WRITE(CLU,90) MATCH1.FNAME(1:MATCH1.L4),MATCH2.FNAME(1:MATCH2.L3)j 	    IF(MATCH2.COPY_FROM .AND. SELECT_2) WRITE(CLU,90) MATCH2.FNAME(1:MATCH2.L4),MATCH1.FNAME(1:MATCH1.L3) 	  ENDIF CT 	ELSE						! files sameU& 	  IF(CD.SHOW_SAME) THEN			! show same$ 	    IF(CD.OUTPUT_FORMAT_BRIEF) THEN8 	      WRITE(OLU,50) MATCH1.FNAME(MATCH1.L3+1:MATCH1.L4)	 	    ELSEE 	      WRITE(OLU,20). 	      WRITE(OLU,30) MATCH1.FNAME(1:MATCH1.L4) 	      WRITE(OLU,60). 	      WRITE(OLU,30) MATCH2.FNAME(1:MATCH2.L4)
 	    ENDIF 	  ENDIF						! end show sameA 	ENDIF 	RETURN. 	END C;;E8 	INTEGER*4 FUNCTION CDIR$COMPARE_TIMES(TIME1,TIME2,FUNC) 	IMPLICIT NONE! 	INTEGER*4 TIME1(2),TIME2(2),FUNCI 	INTEGER*2 NTIME(7),I_ 	CHARACTER*14 CTIME1,CTIME2L CE    10	FORMAT(I4.4,5I2.2) CI 	CALL SYS$NUMTIM(NTIME,TIME1)$" 	WRITE(CTIME1,10) (NTIME(I),I=1,6) 	CALL SYS$NUMTIM(NTIME,TIME2)-" 	WRITE(CTIME2,10) (NTIME(I),I=1,6) 	IF(FUNC.EQ.0) THEN-( 	  CDIR$COMPARE_TIMES = CTIME1.NE.CTIME2 	ELSET( 	  CDIR$COMPARE_TIMES = CTIME1.GT.CTIME2 	ENDIF 	RETURN  	END C;;T; 	INTEGER*4 FUNCTION CDIR$DECIDE_TO_COPY(SELECT_BY,BY_NEWER,T,      >				SIZEA,CTIMEA,RTIMEA,ETIMEA,BTIMEA,,      >				SIZEB,CTIMEB,RTIMEB,ETIMEB,BTIMEB) 	IMPLICIT NONE 	INTEGER*4 SELECT_BY,BY_NEWERU 	INTEGER*4 SIZEA,SIZEB2 	INTEGER*4 CTIMEA(2),RTIMEA(2),ETIMEA(2),BTIMEA(2)2 	INTEGER*4 CTIMEB(2),RTIMEB(2),ETIMEB(2),BTIMEB(2) 	INTEGER*4 CDIR$COMPARE_TIMESE CT 	INCLUDE 'COMPARE_PARAMS.FOR'O CT( 	IF(SELECT_BY.EQ.CD$SELECT_BY_NONE) THEN 	  CDIR$DECIDE_TO_COPY=.FALSE.0 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_ANY_DIFF) THEN 	  CDIR$DECIDE_TO_COPY=.TRUE. , 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_SIZE) THEN 	  IF(BY_NEWER) THEN+ 	    CDIR$DECIDE_TO_COPY = SIZEA .GT. SIZEBM 	  ELSET+ 	    CDIR$DECIDE_TO_COPY = SIZEB .GT. SIZEAM 	  ENDIF3 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_CREATE_DATE) THENP 	  IF(BY_NEWER) THEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(CTIMEA,CTIMEB,1) 	  ELSEE> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(CTIMEB,CTIMEA,1) 	  ENDIF3 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_MODIFY_DATE) THEN( 	  IF(BY_NEWER) THEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(RTIMEA,RTIMEB,1) 	  ELSEU> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(RTIMEB,RTIMEA,1) 	  ENDIF3 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_BACKUP_DATE) THEN. 	  IF(BY_NEWER) THEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(BTIMEA,BTIMEB,1) 	  ELSEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(BTIMEB,BTIMEA,1) 	  ENDIF3 	ELSEIF(SELECT_BY.EQ.CD$SELECT_BY_EXPIRE_DATE) THENE 	  IF(BY_NEWER) THEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(ETIMEA,ETIMEB,1) 	  ELSEN> 	    CDIR$DECIDE_TO_COPY = CDIR$COMPARE_TIMES(ETIMEB,ETIMEA,1) 	  ENDIF 	ELSE= 	  CDIR$DECIDE_TO_COPY=.FALSE. 	ENDIF 	RETURN) 	END C;;P C------------------------------------------------------------------------------- COP C-------------------------------------------------------------------------------8 	SUBROUTINE CDIR$ESTABLISH_REMOTE_LINK(FILE_PARAM,MATCH) 	IMPLICIT NONE  	INCLUDE 'COMPARE_DIR_STRUC.FOR'( 	RECORD/DIR_DIFF_FNAME_STRUC/ FILE_PARAM 	INCLUDE 'COMP_MATCH_STRUC.FOR'(& 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH C)" 	INTEGER*4 REMOTE_LU,L,IOS,I1,I2,I 	CHARACTER TASK*96 CE 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU CSN    10	FORMAT('Unable to open NCP object COMPARE_DIR_REMOTE on remote node ',A)8    20	FORMAT('Possible PROXY account access error.  ',/,I      >		'Try adding username and password to remote node specification.')- C-+ 	CALL STR$TRIM(TASK,FILE_PARAM.NODE_NAME,L)C  	TASK(L+1:)=FILE_PARAM.USER_PASS  	L=L+FILE_PARAM.USER_PASS_LENGTH) 	TASK(L+1:)='::"TASK=COMPARE_DIR_REMOTE"'M 	CALL LIB$GET_LUN(REMOTE_LU)7 	OPEN(UNIT=REMOTE_LU,FILE=TASK,STATUS='OLD',IOSTAT=IOS), 	IF(IOS.NE.0) THEN 	  WRITE(ELU,10) TASK(1:L) 	  IF(IOS.EQ.30) THEN  	    WRITE(ELU,20) 	  ELSEE) 	    WRITE(ELU,*) 'FORTRAN IO ERROR ',IOSA 	  ENDIF 	  STOP 'ABORT'  	ENDIF C( 	MATCH.REMOTE_LU=REMOTE_LU 	MATCH.FNAME=TASK(1:L+2)
 	MATCH.L1=L+2= 	I1=INDEX(MATCH.FNAME,' ')+1 	IF(I1.GT.1.AND.I1.LE.L) THEN-  	  I2=INDEX(MATCH.FNAME,'"::')-1 	  IF(I2.GE.I1) THEN 	    DO I=I1,I2E 	      MATCH.FNAME(I:I)='*'  	    END DOS 	  ENDIF 	ENDIF 	RETURNA 	END C;;0 	SUBROUTINE CDIR$GET_NEXT_FILE(MATCH_NAME,MATCH) 	IMPLICIT NONE 	CHARACTER*(*) MATCH_NAMEL 	INCLUDE 'COMP_MATCH_STRUC.FOR' & 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH CA 	INTEGER*4 L1,L2,L3,L4 	INTEGER*4 OLU,ELU,CLU$ 	COMMON/DIR_DIFF_LU_BLK/ OLU,ELU,CLU CO% 	CHARACTER FILE_NAME*256,LAST_DIR*256I, 	INTEGER*4 L0,REMOTE_LU,STATUS,LIB$FIND_FILE' 	integer*4 cdir$find_subdirectory_depth* 	INCLUDE '($SSDEF)'; 	INCLUDE '($RMSDEF)' 	INCLUDE '($LIBDEF)' C-    10	FORMAT(A4)    20	FORMAT(Z8.8)    30	FORMAT(A)-H    80	FORMAT('ERROR -- The SYSGEN parameter CHANNELCNT may be too low.');    90	FORMAT('ERROR GETTING NEXT FILE TO MATCH ',Z8.8,1X,A)I CG 	MATCH.NEXT_SUBDIR=.FALSE. 	REMOTE_LU=MATCH.REMOTE_LU 	IF(REMOTE_LU.NE.0) THEN 	  WRITE(REMOTE_LU,10) 'FILE'U$ 	  WRITE(REMOTE_LU,20) MATCH.CONTEXT! 	  WRITE(REMOTE_LU,30) MATCH_NAMEL# 	  READ(REMOTE_LU,20) MATCH.CONTEXT  	  READ(REMOTE_LU,30) FILE_NAME= 	  READ(REMOTE_LU,20) STATUS 	ELSEN? 	  STATUS=LIB$FIND_FILE(MATCH_NAME,FILE_NAME,MATCH.CONTEXT,,,,)- 	ENDIF C-J C note: when MATCH.MORE = .FALSE., NOTE_MISSING_FILES still needs MATCH.L3 C- 	IF(STATUS.EQ.RMS$_NORMAL) THEN-G 	  IF(MATCH.L2*MATCH.L3 .GT. 0) LAST_DIR=MATCH.FNAME(MATCH.L2:MATCH.L3)P& 	  L1=MATCH.L1				! remote info length1 	  CALL STR$TRIM(MATCH.FNAME(L1+1:),FILE_NAME,L4)40 	  L2=INDEX(MATCH.FNAME,'[')-1		! end of device 0 	  L3=INDEX(MATCH.FNAME,']')		! end of directory 	  IF(L3 .EQ. 0) THEN_
 	    L2=L1
 	    L3=L1 	  ENDIF 	  MATCH.L2=L2 	  MATCH.L3=L3" 	  MATCH.L4=L1+L4			! total length4 	  IF(MATCH.L2*MATCH.L3 .GT. 0) MATCH.NEXT_SUBDIR = 5      >			LAST_DIR .NE. MATCH.FNAME(MATCH.L2:MATCH.L3)  	  MATCH.MORE=.TRUE. CS1 	ELSEIF(STATUS.EQ.RMS$_NMF) THEN		! no more filesN 	  MATCH.MORE=.FALSE.E CT2 	ELSEIF(STATUS.EQ.RMS$_FNF) THEN		! file not found& 	  L1=MATCH.L1				! remote info length 	  L2=INDEX(MATCH_NAME,'[')-1$ 	  L3=INDEX(MATCH_NAME,']')u 	  IF(L3.EQ.0) THENa 	    L2=INDEX(MATCH_NAME,':')L
 	    L3=L2 	  ENDIFB 	  IF(L3.GT.0) CALL STR$TRIM(MATCH.FNAME(L1+1:),MATCH_NAME(1:L3),) 	  MATCH.L2=L1+L2  	  MATCH.L3=L1+L3D 	  MATCH.L4=L1+L3E 	  MATCH.MORE=.FALSE.D8 	  CALL LIB$SIGNAL(%VAL(LIB$_OPENIN),%VAL(1),MATCH_NAME,/      >			  %VAL(RMS$_FNF),%VAL(SS$_NOSUCHFILE))O CI7 	ELSEIF(STATUS.EQ.RMS$_DNF) THEN		! directory not foundU& 	  L1=MATCH.L1				! remote info length 	  L2=INDEX(MATCH_NAME,'[')-1C 	  L3=INDEX(MATCH_NAME,']')L 	  IF(L3.EQ.0) THENO 	    L2=INDEX(MATCH_NAME,':')U
 	    L3=L2 	  ENDIFB 	  IF(L3.GT.0) CALL STR$TRIM(MATCH.FNAME(L1+1:),MATCH_NAME(1:L3),) 	  MATCH.L2=L1+L2- 	  MATCH.L3=L1+L3- 	  MATCH.L4=L1+L3  	  MATCH.MORE=.FALSE.-6 	  CALL LIB$STOP(%VAL(LIB$_OPENIN),%VAL(1),MATCH_NAME,-      >			%VAL(RMS$_DNF),%VAL(SS$_NOSUCHFILE))P CI9 	ELSEIF(STATUS.EQ.RMS$_PRV) THEN		! file protection errorI& 	  L1=MATCH.L1				! remote info length 	  L2=INDEX(MATCH_NAME,'[')-1O 	  L3=INDEX(MATCH_NAME,']')T 	  IF(L3.EQ.0) THENA 	    L2=INDEX(MATCH_NAME,':')A
 	    L3=L2 	  ENDIFB 	  IF(L3.GT.0) CALL STR$TRIM(MATCH.FNAME(L1+1:),MATCH_NAME(1:L3),) 	  MATCH.L2=L1+L22 	  MATCH.L3=L1+L3T 	  MATCH.L4=L1+L3t 	  MATCH.MORE=.FALSE. ? 	  WRITE(ELU,*) ' file protection error'	! CHANGE TO LIB$SIGNAL   	ELSEIF(STATUS.EQ.RMS$_CHN) THEN 	  WRITE(ELU,80) O 	ELSEL 	  MATCH.MORE=.FALSE.L' 	  WRITE(ELU,90) STATUS,FILE_NAME(1:32)H  	  CALL LIB$SIGNAL(%VAL(STATUS)) 	ENDIF 	RETURNI 	END C;;EJ 	INTEGER*4 FUNCTION CDIR$GET_FILE_INFO(MATCH,CTIME,RTIME,ETIME,BTIME,SIZE) 	IMPLICIT NONE 	INCLUDE 'COMP_MATCH_STRUC.FOR'T& 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH C_ 	INTEGER*4 CTIME(2)E 	INTEGER*4 RTIME(2)C 	INTEGER*4 ETIME(2)L 	INTEGER*4 BTIME(2)C 	INTEGER*4 SIZEE C)' 	INTEGER*4 REMOTE_LU,L1,L2,L3,L4,STATUS)& 	INTEGER*4 GEN$GET_FILE_TIMES_AND_SIZE C	    10	FORMAT(A).    20	FORMAT(4Z8.8)r    30	FORMAT(Z8.8) CC 	L1=MATCH.L1 	L4=MATCH.L4 Cf 	REMOTE_LU=MATCH.REMOTE_LU 	IF(REMOTE_LU.NE.0) THEN 	  WRITE(REMOTE_LU,10) 'SIZE'O+ 	  WRITE(REMOTE_LU,10) MATCH.FNAME(L1+1:L4)r9 	  READ(REMOTE_LU,20) CTIME(1),CTIME(2),RTIME(1),RTIME(2)E9 	  READ(REMOTE_LU,20) ETIME(1),ETIME(2),BTIME(1),BTIME(2)I 	  READ(REMOTE_LU,30) SIZE 	  READ(REMOTE_LU,30) STATUS 	ELSE ; 	  STATUS=GEN$GET_FILE_TIMES_AND_SIZE(MATCH.FNAME(L1+1:L4),2)      >						CTIME,RTIME,ETIME,BTIME,SIZE)1 	ENDIF 	CDIR$GET_FILE_INFO=STATUS 	RETURN  	END C;;R# 	SUBROUTINE CDIR$END_CONTEXT(MATCH)E 	IMPLICIT NONE 	INCLUDE 'COMP_MATCH_STRUC.FOR'_& 	RECORD/MATCHED_FILE_INFO_STRUC/ MATCH CC 	INTEGER*4 REMOTE_LU,STATUSH 	INTEGER*4 LIB$FIND_FILE_END CD    10	FORMAT(A4)    20	FORMAT(Z8.8) C  	REMOTE_LU=MATCH.REMOTE_LU 	IF(REMOTE_LU.EQ.0) THEN* 	  STATUS=LIB$FIND_FILE_END(MATCH.CONTEXT)0 	  IF(.NOT.STATUS) CALL LIB$SIGNAL(%VAL(STATUS)) 	ELSER 	  WRITE(REMOTE_LU,10) 'EXIT'N$ 	  WRITE(REMOTE_LU,20) MATCH.CONTEXT 	  CLOSE(UNIT=REMOTE_LU) 	  REMOTE_LU=0 	ENDIF 	RETURN  	END