 $	Setv = 'F$Verify( "No" ) $! $! File			: SORT_DISKQUOTA.COM $! Author		: Nick de Smith $! Creation date	: 22-May-89 $! $! Edit	Edit date	By	Why- $!  02	23-Jan-90	NMdS	Improve error reporting = $!				Allow long identifier names (up to theoretical maximum) B $!				Log exception record to load command file as well as consoleI $!				Add in code to work round DISKQUOTA bug with "wildcard" identifiers ) $!  01	08-Nov-89	NMdS	New (from original) 7 $!				Re-written to directly access the disk quota file  $!				Now gives better reports. : $!				Also, now use an indexed file to sort the quota file $! Description: d $! This command file produces an output command file (default name RELOAD_DISKQUOTA.COM), that, whenO $! executed, will reload the specified disk's quota file in alphabetical order. e $! A report on disk usage is given, and warnings are displayed about users/identifiers that are close  $! to or over allocation. T $! This can make maintenance much more clear on systems with large numbers of users. $!5 $!	P1		Name of disk to use. Default is SYS$SYSDEVICE. I $!	P2		Name of command file to generate. Default is RELOAD_DISKQUOTA.COM.  $!g $! The procedure works by reading the specified QUOTA.SYS file, and loading a formatted version of each g $! active record into an indexed file. This, by default, sorts the records on the primary key, which in J $! this case is an ASCII representation of the UIC (as used by DISKQUOTA).k $! We read back the indexed file sequentially to get the records in alphabetical order. I used to use SORT, - $! but this method is neater (or so I think).  $!h $! Note that if a file is owned by a "wildcard UIC", say "[USER,*]", and you do a REBUILD, then an entryi $! for this "wildcard" UIC appears in QUOTA.SYS and can be seen by DISKQUOTA. However, you cannot REMOVE, h $! MODIFY, SHOW (except with "SHOW *") or ADD such an entry (you can delete it with REMOVE * but this is0 $! a bit drastic). Is this a "feature" or a bug?f $! If such an entry exists, this procedure will leave the wildcard entry alone to ensure that it keepsc $! its quota. This is done by explicitly deleting each entry in QUOTA.SYS with the exception of the b $! "wildcard" entries, and then reloading all but the wildcard entries. If there are no "wildcard"f $! entries then a "REMOVE *" is done. The consequence of this method is that when there are "wildcard"U $! UICs owning files, the reloaded QUOTA.SYS may not be in perfect alphatbetic order.  $!B $	Set Symbol /Scope=( NoLocal, NoGlobal )					! Insulate ourselves $!U $	Name	= F$Parse( F$Environment( "PROCEDURE" ) ,,, "NAME" )		! Name of this procedure 7 $	Info	= "%" + Name + "-I, "						! Information message 3 $	Warn	= "%" + Name + "-W, "						! Warning message 8 $	Fatal	= "%" + Name + "-F, "						! Fatal error message3 $	Say	= "Write SYS$OUTPUT"						! Print to terminal  $! $	Say "", $	Say Name, " - Sort diskquota file entries" $	Say "" $! $	On WARNING Then Goto HANDLER $	On CONTROL_Y Then Goto END $!A $	Safety_Limit	= 10							! Warning threshold (%) for identifiers Q $	Command		= "RELOAD_DISKQUOTA.COM"				! Default name of command file to generate k $	Sorted		= "SYS$SCRATCH:DISKQUOTA_" + F$GetJPI( "", "PID" ) + ".SORTED"	! Name for temp sorted output file  $!7 $	Total_InUse	= 0							! Total number of blocks in use H $	Total_Allowed	= 0							! Total number of blocks that could be allowedC $	Total_With_Overdrafts = 0						! Absolute maximum with overdrafts 5 $	Total_Identifiers = 0							! Total number of users  $!T $!	Definitions of the disk quota file format taken from SYS$LIBRARY:LIB.MLB, $DQFDEF $!# $	DQF$L_FLAGS	= 0							! Flag word , $		DQF$M_ACTIVE	= 1							! Record is active% $	DQF$L_UIC	= 4							! UIC of record ' $	DQF$L_USAGE	= 8							! Current usage 6 $	DQF$L_PERMQUOTA	= 12							! Allowed permanent quota0 $	DQF$L_OVERDRAFT	= 16							! Allowed overdraft $!, $	Device	:= 'P1								! Pick up device name\ $	Device = F$Parse( Device, "SYS$SYSDEVICE:",, "DEVICE" )			! Generate name of device to use> $	If (Device .eqs. "") .or. .not. F$GetDVI( Device, "EXISTS" )0 $	Then	Say Fatal, "Invalid device name specfied" $		Goto END  $	EndIf E $	Device = F$GetDVI( Device, "FULLDEVNAM" )				! Get full device name H $	Quota_File = Device + "[000000]QUOTA.SYS"				! Name of disk quota fileE $	If F$Search( Quota_File ) .eqs. ""					! If quota file not found... 7 $	Then	Say Fatal, "Disk quotas not enabled on ", Device  $		Goto END  $	EndIf  $!C $	Command = F$Parse( P2, Command )					! Generate command file name  $	If Command .eqs. "" 6 $	Then	Say Fatal, "Invalid command file name specfied" $		Goto END  $	EndIf  $!b $!	32 characters is the maximum size of an identifier. Therefore, "[" + 32 + "," + 32 + "]" is the\ $!	longest identifier allowed. 3 longwords are also used to store the diskquota information.T $!	Record size is therefore 1 + 32 + 1 + 32 + 1 ([ide,ide]) + 3 longwords = 79 bytes $!D $	Create /Fdl=SYS$INPUT &Sorted						! Create the sorted output file File 	Organization	Indexed  	Best_Try_Contiguous Yes
 	Extension	16  Record 	Format		Fixed	 	Size		79  Key 0  	Name		"Identifier" 
 	Type		String  	Seg0_Position	0 	Seg0_Length	67  $!c $	Open /Read /Share=Write /Error=QUOTA_OPEN_ERROR QUOTA_FILE &Quota_File	! Open the disk quota file @ $	Open /Read /Write SORTED &Sorted					! Open sorted output file> $	Open /Write COMMAND &Command						! Open output command file $	Write COMMAND "$!"P $	Write COMMAND "$! Command file to reload ", F$TrnLNM( "SYS$NODE" ), Quota_Filew $	Write COMMAND "$! Generated by ", F$Edit( F$GetJPI( "", "USERNAME" ), "COLLAPSE" ), " using ", Name, " on ", F$Time()  $	Write COMMAND "$!" $!> $	Say Info, "Processing ", Device, " and generating ", Command; $	OutRec[ 0, 67 + 3*4 ]  :=						! Pre-extend output record 7 $	Wild_Ident = 0								! Assume no wilcard identifiers f $ 10$:	Read /End=20$ /Error=QUOTA_READ_ERROR QUOTA_FILE Record			! Read one record from the quota fileW $	If (F$CvUI( DQF$L_FLAGS*8, 32, Record ) .and. DQF$M_ACTIVE)		! If record is active... ^ $	Then	Identifier	:= 'F$Fao( "!%I", F$CvUI( DQF$L_UIC*8, 32, Record ) ) ! Save user identifierJ $		Current		= F$CvUI( DQF$L_USAGE*8    , 32, Record )	! Save current usageM $		Permanent	= F$CvUI( DQF$L_PERMQUOTA*8, 32, Record )	!  ''  permanent quota O $		Overdraft	= F$CvUI( DQF$L_OVERDRAFT*8, 32, Record )	!  ''  allowed overdraft  $!Q $		Total_Identifiers = Total_Identifiers + 1			! Count number of identifiers seen C $		Total_InUse	= Total_InUse + Current				! Check the running total I $		Total_Allowed	= Total_Allowed + Permanent			! Check the total possible i $		Total_With_Overdrafts = Total_With_Overdrafts + Permanent + Overdraft ! Check the grand total possible  $!^ $		If F$Locate( "*", Identifier ) .ne. F$Length( Identifier )	! Check for wildcard identifiersD $		Then	Wild_Ident = Wild_Ident + 1				! Say one more wildcard foundW $			Call LOG Warn "''F$Fao( "Leaving wildcard identifier !AS untouched", Identifier )'"  $		EndIf $!; $		If Current .gt. Permanent					! If someone is over quota  $		Then g $			Call LOG Warn "''F$Fao( "!AS is using !UL block!%S over quota", Identifier, Current - Permanent )'"  $		Else O $			Temp = ((Permanent - Current)*100) / Permanent		! Determine % of quota left @ $			If Temp .le. Safety_Limit Then -			! If less than x% left...T 				Call LOG Warn "''F$Fao( "!AS is within !UL% of their quota", Identifier, Temp)'" $		EndIf$ $		OutRec[    0, 67 ] := 'Identifier8 $		OutRec[ 67*8, 32 ] = Current					! Save current usage< $		OutRec[ 71*8, 32 ] = Permanent					!  ''  permanent quota> $		OutRec[ 75*8, 32 ] = Overdraft					!  ''  allowed overdraft4 $		Write SORTED OutRec						! Save the output record $	EndIf 
 $	Goto 10$ $! $ 20$:	Close QUOTA_FILE  $	Close SORTED $! $!	Write out the usage report  $! $	If Wild_Ident .ne. 0 $	Then	Call LOG N $		Call LOG Warn "''F$Fao( "!UL wildcard identifier!%S found.", Wild_Ident )'"F $		Call LOG Warn "As a result, the reloaded DISKQUOTA file may not be"G $		Call LOG Warn "completely re-ordered. This is a bug/feature in VMS."  $	EndIf 
 $	Call LOG* $	Call LOG Info "Report on disk ''Device'"
 $	Call LOGq $	Call LOG Info "''F$Fao( "Total of !UL block!%S in use by !UL identifier!%S", Total_InUse, Total_Identifiers )'" d $	Call LOG Info "''F$Fao( "!UL further block!%S could be allocated", Total_Allowed - Total_Inuse )'" $	Call LOG "" "''F$Fao( "!_making an total of !UL block!%S (!UL including overdrafts)", Total_Allowed, Total_With_Overdrafts )'"[ $	Call LOG Info "''F$Fao( "Volume size is !UL block!%S", F$GetDVI( Device, "MAXBLOCK" ) )'" b $	Call LOG "" "''F$Fao( "!_with !UL block!%S currently free", F$GetDVI( Device, "FREEBLOCKS" ) )'"
 $	Call LOG $!H $! Read the sorted file and convert it into a DISKQUOTA.EXE command file $!, $	Write COMMAND "$	Run SYS$SYSTEM:DISKQUOTA" $	Write COMMAND "Use ", Device> $	If Wild_Ident .ne. 0							! If there were some wildcards...? $	Then	Open /Read SORTED &Sorted					! Open sorted listing file G $ 30$:		Read /End=40$ /Error=40$ SORTED Record				! Get an input record G $		Identifier	:= 'F$Extract( 0, 67, Record )			! Extract the identifier c $		If F$Locate( "*", Identifier ) .eq. F$Length( Identifier ) Then	- ! If this is not a wildcard... K $				Write COMMAND "Remove ", Identifier		! ...explicitly remove identifier  $		Goto 30$  $ 40$:		Close SORTED# $	Else									! No wildcards so... F $		Write COMMAND "Remove *"					! ...implicitly remove all identifiers $	EndIf ; $	Open /Read SORTED &Sorted						! Open sorted listing file  $ LOOP: J $	Read /End=END_LOOP /Error=END_LOOP SORTED Record			! Get an input recordG $	Identifier	:= 'F$Extract( 0, 67, Record )				! Extract the identifier B $	Current		= F$CvUI( 67*8, 32, Record )				!    ''   current usageE $	Permanent	= F$CvUI( 71*8, 32, Record )				!    ''   permanent quota E $	Overdraft	= F$CvUI( 75*8, 32, Record )				!    ''   overdraft limit  $!b $	If F$Locate( "*", Identifier ) .eq. F$Length( Identifier ) Then -	! If this is not a wildcard...t $		Write COMMAND F$Fao( "Add !67AS!_/PermQuota=!10AS /Overdraft=!UL", Identifier, F$String( Permanent ), Overdraft ) $! $	Goto LOOP  $! $ END_LOOP:  $	Write COMMAND "Rebuild"  $	Write COMMAND "$!" $	Close COMMAND  $!P $	Say Info, "Execute ", Command, " to rebuild your disk quota file for ", Device
 $	Goto END $!= $! Log a message to the screen and to the reload command file  $! $ LOG:	Subroutine ! $	If P1 .eqs. "" Then P1 = """""" 
 $	Say 'P1, P2  $	Write COMMAND "$! ", P2  $	EndSubroutine  $!
 $ HANDLER:C $	Say Fatal, F$Fao( "Unexpected error!/!AS", F$Message( $STATUS ) ) 
 $	Goto END $! $ QUOTA_OPEN_ERROR: P $	Say Fatal, F$Fao( "Error opening !AS!/!AS", Quota_File, F$Message( $STATUS ) )
 $	Goto END $! $ QUOTA_READ_ERROR: P $	Say Fatal, F$Fao( "Error reading !AS!/!AS", Quota_File, F$Message( $STATUS ) )
 $	Goto END $! $! Clean up any old rubbish  $! $ END: $	Close /Error=E_1$ COMMAND   $ E_1$:	Close /Error=E_2$ SORTED$ $ E_2$:	Close /Error=E_3$ QUOTA_FILET $ E_3$:	If F$Search( Sorted   ) .nes. "" Then Delete /NoLog 'F$Parse( ";*", Sorted )S $	If F$Search( Command  ) .nes. "" Then Purge  /NoLog 'F$Element( 0, ";", Command )  $	Setv = F$Verify( Setv ) 