 /*K  * Copyright  1991 by Hunter Goatley.  This code may be freely distributed L  * and modified for non-commercial purposes as long as this copyright notice  * is retained.   */  #ifdef VAXC  #module SCROLL_VIEW "01-000" #endif /*  *  *  Module:	SCROLL_VIEW   *  *  Author:	Hunter Goatley  *  *  Date:	October 18, 1991  *
  *  Abstract:   *B  *	This routine scrolls a viewport a certain number of lines.  TheD  *	number of lines is a signed quantity, where negative means scrollC  *	up the page (backwards) and positive means scroll down the page. ?  *	Unlike the SMG$ routines for menus, this routine handles the D  *	automatic wrap-around of the display when the beginning or end is  *	reached.   *H  *	It is assumed that the virtual display has a viewport associated with  *	it.  *  *  Modified by:  *,  *	01-000		Hunter Goatley		18-OCT-1991 08:40  *		Genesis.  */    #include <smgdef.h>   H /* Constants passed in to SMG$ routines (GNU C doesn't like &1, etc.) */% static const unsigned long one			= 1; 0 static const unsigned long smg_m_up		= SMG$M_UP;4 static const unsigned long smg_m_down		= SMG$M_DOWN;   /* FORWARD ROUTINE */ * void		scroll_view (unsigned long *, long);   /* MACROS */. #define errchk(s) if (!(s & 1)) lib$signal(s);, #define call(s)  status = s; errchk(status);     /*  *  Routine:	scroll_view  *  *  Functional description:   *B  *	This routine scrolls a viewport a certain number of lines.  TheD  *	number of lines is a signed quantity, where negative means scrollC  *	up the page (backwards) and positive means scroll down the page. ?  *	Unlike the SMG$ routines for menus, this routine handles the D  *	automatic wrap-around of the display when the beginning or end is  *	reached.   *H  *	It is assumed that the virtual display has a viewport associated with  *	it.  *  *  Formal parameters:  *A  *      vd	- The virtual display to scroll (passed by reference!) A  *	lines	- The signed number of lines to scroll (passed by value)   *  *  Implicit inputs:  *  *      various constants   *  *  Calling sequence:   *!  *	status = scroll_view (&vd, 1);   *  *  Returns:  *
  *      None.   *  */  void+ scroll_view (unsigned long *vd, long lines)  {    long work_row;   unsigned long status;    unsigned long currow;    unsigned long vrows;   unsigned long vstart;    unsigned long vrow;    unsigned long maxrows;  ,   call(SMG$GET_DISPLAY_ATTR (vd, &maxrows));C   /* Calculate the row within the viewport that the cursor is on */ :   call(SMG$GET_VIEWPORT_CHAR (vd, &vstart, 0, &vrows, 0));&   currow = vrow = SMG$CURSOR_ROW (vd);   vrow -= vstart; 	   vrow++;      if (lines != 0) {      work_row = currow + lines;     if (lines > 0) {       /*=        *  If we are on the last menu item, scroll back to top 	        */        if (currow == maxrows) { 	 , 	/* Move view port back up to top of menu */3 	call(SMG$CHANGE_VIEWPORT(vd, &one, &one, &vrows));  	  	/* Re-initialize rows */  	work_row = 1;       }        else { 	if (work_row >= maxrows) { % 	  lines = (long) (maxrows - currow);  	  work_row = maxrows; 	}# 	/*  If we need to scroll, do it */  	if ((vrow + lines) > vrows) {% 	  if ((work_row > (maxrows - vrows))  	      && lines > 1) {6 	    lines = (long) (maxrows - currow - vrows + vrow); 	  }4 	  call(SMG$SCROLL_VIEWPORT(vd, &smg_m_up, &lines)); 	}       }      } 
     else {       +       /* Move backwards through the menu */               if (currow == 1) {/ 	/* Move view port back up to bottom of menu */  	if (maxrows > vrows) {   	  currow = maxrows - vrows + 1;8 	  call(SMG$CHANGE_VIEWPORT(vd, &currow, &one, &vrows)); 	} 	else {  	  currow = maxrows;5 	  call(SMG$CHANGE_VIEWPORT(vd, &one, &one, &vrows));  	} 	  	/* Re-initialize rows */  	work_row = maxrows;       }        else { 	if (work_row < 1) { 	  lines = 1 - currow; 	  work_row = 1; 	} 	/* Moving backwards */ ! 	if ((long) (vrow + lines) < 1) { 3 	  if (((currow - vrow) < vrows) && (lines < -1)) { 8 	    lines = (long) (currow-vrow); /* top of viewport */ 	  } 	  lines = abs(lines);6 	  call(SMG$SCROLL_VIEWPORT(vd, &smg_m_down, &lines)); 	}       }      } 2     call(SMG$SET_CURSOR_ABS(vd, &work_row, &one));     currow = work_row;   }  } 