   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |            PERSONA_DECW           %%   \ @  *                %% |          support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #include "version.h" #pragma module SUPPORT VERSION   9 #include <stdio.h>          /* Standard IO definitions */ > #include <descrip.h>        /* Descriptor Definition Macros */? #include <dvidef.h>         /* Device Information item codes */ 6 #include <iodef.h>          /* I/O Definition codes */D #include <jpidef.h>         /* Job/Process Information item codes */6 #include <pqldef.h>         /* process quota limits */8 #include <prcdef.h>         /* Process Creation flags */0 #include <prvdef.h>         /* Priv mask defs */= #include <ssdef.h>          /* System Service return codes */ 8 #include <string.h>         /* currently for strlen() */@ #include <ttdef.h>          /* basic terminal characteristics */C #include <tt2def.h>         /* extended terminal characteristics */ K #include <uaidef.h>         /* User Authorization Information item codes */  #include "defs.h"    K #define SS$_INVPWD 2        /* can't find a definition, so I made one up */    K extern struct ITEM UaiItem[15];     /* Itemlist for Target user uaf info */ : extern struct IOSB QioIosb;         /* iosb for $QIO(W) */% extern struct dsc$descriptor_s DscTt; ( extern struct dsc$descriptor_s DscUserT;   C extern struct PQLLIST PqlTbl[15];   /* pql table for target user */     extern short TimLen;G extern short TtdChan;               /* Channel for original terminal */    L extern char CmdVerb[32];            /* foreign symbol invoking this image */ extern char CurTime[28];: extern char NewUser[16];            /* Target user name */M extern char NewUserTrim[14];        /* string for new username w/o padding */ G extern char OldProcN[18];           /* Process name of invoking user */ < extern char OldUser[16];            /* Invoking user name */H extern char OldUserTrim[14];        /* Invoking user name w/o padding */M extern char PrcName[18];            /* Process name of detached pseudoterm */ : extern char TtdName[32];            /* Original TT name */   H extern char DispNode[16];           /* Decw display node we are using */R extern char TransPort[8];           /* Decw display transport (decnet, tcpip... */   I extern int  OldPid;                 /* process id for original process */  extern int  NewPid; I extern int  NewTTChar[3];           /* Target terminal characteristics */ K extern int  OldTTChar[3];           /* Invoking terminal characteristics */ = extern int  CurPriv[2];             /* Image process privs */ = extern int  DefPriv[2];           /* Installed image privs */ V extern int  StsFlg;                 /* runtime options for created detached process */ extern int  status;    F char PwdBuf[32];                    /* User entered password string */   M int context;                        /* Context variable for multiple calls */    E $DESCRIPTOR(Dsc_Tt, "TT:");         /* originating terminal device */    B extern FILE *logfp;                 /* file pointer for logfile */    globalvalue PERSONA_DECW_CLD;  globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetNodeNameG  * Description: We determined Decw tansport to be local, so we retrieve B  *              the current node name and place it in the DispNode'  *              global string variable.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetNodeName()  {      short nodelen;;     int  SyiItm = 0x10d9;               /* SYI$_NODENAME */ O     $DESCRIPTOR(Dsc_Node, DispNode);     /* node which this image is running */    F         /* Use LIB$GETSYI to get this node's name. This is the same as@            the SCS_NODENAME in sysgen. Then set up DPY string */   ?     status = lib$getsyi(&SyiItm, 0, &Dsc_Node, &nodelen, 0, 0); '     if(!(status & 1)) lib$stop(status);      DispNode[nodelen] = 0;     return(1); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ChkPrivL  * Description: Check if we have sufficient privs to continue. If so, simplyH  *              return SS$_NORMAL, else see if invoking user can set theK  *              required privs from their process privs. If not, we have to J  *              return SS$_NOTALLPRIV to indicate this image cannot be run)  *              due to insufficent privs.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int ChkPriv()  { @     int EnabFlg = 1;               /* Enable flag for $SETPRV */     int PrevPriv[2] = 0;     int PrivMask[2] = 0;     int PrivStat = 0;      int jpicode = JPI$_CURPRIV;    
 #ifdef ARFL     PrivMask[0] = PRV$M_SYSPRV | PRV$M_DETACH | PRV$M_CMKRNL | PRV$M_BYPASS; #else =     PrivMask[0] = PRV$M_CMKRNL | PRV$M_DETACH | PRV$M_SYSPRV;  #endif   E     if((CurPriv[0] & PrivMask[0]) == PrivMask[0]) return(SS$_NORMAL); #     else CurPriv[0] |= PrivMask[0];    ;     PrivStat = sys$setprv(EnabFlg, &CurPriv, 0, &PrevPriv); 6     if(PrivStat != SS$_NORMAL) return(SS$_NOTALLPRIV);E     if((CurPriv[0] & PrivMask[0]) == PrivMask[0]) return(SS$_NORMAL);       else return(SS$_NOTALLPRIV); }          J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCurTime C  * Description: Get current date and time as ascii string and place ;  *              resultant string in global buffer 'CurTime'   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCurTime()  {      int cvtflg = 0;      char *ptr2 = 0; #     $DESCRIPTOR(Dsc_Time, CurTime);    8     status = sys$asctim(&TimLen, &Dsc_Time, 0, &cvtflg);     if(status == SS$_NORMAL) {$         ptr2 = strchr(CurTime, '.');         if(ptr2) *ptr2 = '\0';     }  }    J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetDisplayInfo D  * Description: Get Decw display info. we are only interested in theC  *              display node and transport info. Other display info B  *              is obtainable, but not needed here (this module is<  *              adapted from WSA.C elsewhere in my archives)  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetDisplayInfo() {      short  channel;      short  iosblk[4];    5         /* Input - DscDisp is a descriptor containing <                    the logical name/device of the display */   *     $DESCRIPTOR(Dsc_Disp, "DECW$DISPLAY");   ,         /* Assign a channel to the device */   3     status = sys$assign(&Dsc_Disp, &channel, 0, 0); -     if (status != SS$_NORMAL) return(status);    .         /* Get the display node information */   I     status = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosblk, :                          0, 0, DispNode, sizeof(DispNode),6                          DECW$C_WS_DSP_NODE, 0, 0, 0);-     if (status != SS$_NORMAL) return(status); 3     if (iosblk[0] != SS$_NORMAL) return(iosblk[0]);    +         /* Get the transport information */    O     status = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosblk, 0, 0, 2                       TransPort,sizeof(TransPort),8                       DECW$C_WS_DSP_TRANSPORT, 0, 0, 0);-     if (status != SS$_NORMAL) return(status); 3     if (iosblk[0] != SS$_NORMAL) return(iosblk[0]);    0         /* release the channel to the display */   !     status = sys$dassgn(channel); -     if (status != SS$_NORMAL) return(status);         return(SS$_NORMAL);     }          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetPql I  * Description: First, fill in the PwlTbl item codes, then create the uaf H  *              itemlist for the target user based on the uaf quotas forJ  *              the target user. Finally, fill in the pql values in PqlTbl%  *              by calling SYS$GETUAI   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 void GetPql()  { G         /* Create a descriptor pointing to target username. Please note ;            this is NOT same descriptor defined in main() */    #     $DESCRIPTOR(Dsc_User, NewUser); ,     Dsc_User.dsc$w_length = strlen(NewUser);   #     PqlTbl[0].code  =   PQL$_ASTLM; #     PqlTbl[1].code  =   PQL$_BIOLM; #     PqlTbl[2].code  =   PQL$_BYTLM; #     PqlTbl[3].code  =   PQL$_CPULM; #     PqlTbl[4].code  =   PQL$_DIOLM; #     PqlTbl[5].code  =   PQL$_FILLM; '     PqlTbl[6].code  =   PQL$_PGFLQUOTA; #     PqlTbl[7].code  =   PQL$_PRCLM; #     PqlTbl[8].code  =   PQL$_TQELM; #     PqlTbl[9].code  =   PQL$_ENQLM; (     PqlTbl[10].code  =   PQL$_WSDEFAULT;&     PqlTbl[11].code  =   PQL$_WSQUOTA;'     PqlTbl[12].code  =   PQL$_WSEXTENT; &     PqlTbl[13].code  =   PQL$_JTQUOTA;&     PqlTbl[14].code  =   PQL$_LISTEND;     PqlTbl[14].value =   0;    2     UaiItem[0].buf_size = sizeof(PqlTbl[0].value);&     UaiItem[0].item_code = UAI$_ASTLM;+     UaiItem[0].buf_addr = &PqlTbl[0].value;      UaiItem[0].buf_len  = 0;2     UaiItem[1].buf_size = sizeof(PqlTbl[1].value);&     UaiItem[1].item_code = UAI$_BIOLM;+     UaiItem[1].buf_addr = &PqlTbl[1].value;      UaiItem[1].buf_len  = 0;2     UaiItem[2].buf_size = sizeof(PqlTbl[2].value);&     UaiItem[2].item_code = UAI$_BYTLM;+     UaiItem[2].buf_addr = &PqlTbl[2].value;      UaiItem[2].buf_len  = 0;2     UaiItem[3].buf_size = sizeof(PqlTbl[3].value);'     UaiItem[3].item_code = UAI$_CPUTIM; +     UaiItem[3].buf_addr = &PqlTbl[3].value;      UaiItem[3].buf_len  = 0;2     UaiItem[4].buf_size = sizeof(PqlTbl[4].value);&     UaiItem[4].item_code = UAI$_DIOLM;+     UaiItem[4].buf_addr = &PqlTbl[4].value;      UaiItem[4].buf_len  = 0;2     UaiItem[5].buf_size = sizeof(PqlTbl[5].value);&     UaiItem[5].item_code = UAI$_FILLM;+     UaiItem[5].buf_addr = &PqlTbl[5].value;      UaiItem[5].buf_len  = 0;2     UaiItem[6].buf_size = sizeof(PqlTbl[6].value);*     UaiItem[6].item_code = UAI$_PGFLQUOTA;+     UaiItem[6].buf_addr = &PqlTbl[6].value;      UaiItem[6].buf_len  = 0;2     UaiItem[7].buf_size = sizeof(PqlTbl[7].value);'     UaiItem[7].item_code = UAI$_PRCCNT; +     UaiItem[7].buf_addr = &PqlTbl[7].value;      UaiItem[7].buf_len  = 0;2     UaiItem[8].buf_size = sizeof(PqlTbl[8].value);&     UaiItem[8].item_code = UAI$_TQCNT;+     UaiItem[8].buf_addr = &PqlTbl[8].value;      UaiItem[8].buf_len  = 0;2     UaiItem[9].buf_size = sizeof(PqlTbl[9].value);&     UaiItem[9].item_code = UAI$_ENQLM;+     UaiItem[9].buf_addr = &PqlTbl[9].value;      UaiItem[9].buf_len  = 0;4     UaiItem[10].buf_size = sizeof(PqlTbl[10].value);)     UaiItem[10].item_code = UAI$_DFWSCNT; -     UaiItem[10].buf_addr = &PqlTbl[10].value;      UaiItem[10].buf_len  = 0; 4     UaiItem[11].buf_size = sizeof(PqlTbl[11].value);)     UaiItem[11].item_code = UAI$_WSQUOTA; -     UaiItem[11].buf_addr = &PqlTbl[11].value;      UaiItem[11].buf_len  = 0; 4     UaiItem[12].buf_size = sizeof(PqlTbl[12].value);*     UaiItem[12].item_code = UAI$_WSEXTENT;-     UaiItem[12].buf_addr = &PqlTbl[12].value;      UaiItem[12].buf_len  = 0; 4     UaiItem[13].buf_size = sizeof(PqlTbl[13].value);)     UaiItem[13].item_code = UAI$_JTQUOTA; -     UaiItem[13].buf_addr = &PqlTbl[13].value;      UaiItem[13].buf_len  = 0;      UaiItem[14].buf_size = 0;      UaiItem[14].item_code = 0;   <     status = sys$getuai(0, 0, &Dsc_User, &UaiItem, 0, 0, 0);*     if(status != SS$_NORMAL) exit(status);    }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: PwdChk N  * Description: Prompt user for system manager password. Do not echo response,L  *              compare response string to existing password. If response isE  *              is positive return SS$_NORMAL, else return SS$_INVPWD   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int PwdChk() { 
     char Alg;      char UsrNam[] = {"SYSTEM"};      short Salt;      int IoFunct = 0;      long ChkHash[2], CurHash[2];$     $DESCRIPTOR(Dsc_ChkPwd, PwdBuf);"     $DESCRIPTOR(Dsc_User, UsrNam);   0     printf("\nEnter System Manager Password: ");0     status = sys$assign(&DscTt, &TtdChan, 0, 0);*     if(status != SS$_NORMAL) exit(status);D     IoFunct = IO$_READLBLK | IO$M_PURGE | IO$M_CVTLOW | IO$M_NOECHO;:     status = sys$qiow(0, TtdChan, IoFunct, &QioIosb, 0, 0,;                       &PwdBuf, sizeof(PwdBuf), 0, 0, 0, 0); *     if(status != SS$_NORMAL) exit(status);:     if(QioIosb.status != SS$_NORMAL) exit(QioIosb.status);$     PwdBuf[QioIosb.byte_cnt] = '\0';!     status = sys$dassgn(TtdChan); *     if(status != SS$_NORMAL) exit(status);     printf("\n");    &     Dsc_ChkPwd.dsc$a_pointer = PwdBuf;-     Dsc_ChkPwd.dsc$w_length = strlen(PwdBuf);         UaiItem[0].buf_size = 1;(     UaiItem[0].item_code = UAI$_ENCRYPT;     UaiItem[0].buf_addr = &Alg;      UaiItem[0].buf_len = 0;      UaiItem[1].buf_size = 2;%     UaiItem[1].item_code = UAI$_SALT;       UaiItem[1].buf_addr = &Salt;     UaiItem[1].buf_len = 0;      UaiItem[2].buf_size = 8;$     UaiItem[2].item_code = UAI$_PWD;#     UaiItem[2].buf_addr = &CurHash;      UaiItem[2].buf_len = 0;      UaiItem[3].buf_size = 0;     UaiItem[3].item_code = 0;    <     status = sys$getuai(0, 0, &Dsc_User, &UaiItem, 0, 0, 0);   A         /* use 'sys$hash_password' to get hash value from user */    K     status = sys$hash_password(&Dsc_ChkPwd, Alg, Salt, &Dsc_User, ChkHash); @     if((CurHash[0] != ChkHash[0]) || (CurHash[1] != ChkHash[1]))         return(SS$_INVPWD);      else return (SS$_NORMAL);  }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckIdent E  * Description: Reads the rights database to verify invoking user has G  *              appropriate identifier granted to assume the persona of A  *              the target user. If not, return SS$_NOSUCHID else <  *              if proper identifier then return SS$_NORMAL.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckIdent() {      char name[31];     char TargIdentStr[31];     unsigned int HolderBin[2];     unsigned int TargIdentBin;&     unsigned int HeldBin, context = 0;     unsigned short count = 0; !     $DESCRIPTOR (Dsc_Name, name); (     $DESCRIPTOR(Dsc_Pers, TargIdentStr);   <         /* get invoking username, convert to binary value */        strcpy(name, OldUser);)     Dsc_Name.dsc$w_length = strlen(name); 5     status = sys$asctoid ( &Dsc_Name, &HolderBin, 0); '     if(!(status & 1)) lib$stop(status);    7         /* get target username, prefix with PERS_, then %            convert to binary value */    2     sprintf(TargIdentStr, "PERS_%s", NewUserTrim);1     Dsc_Pers.dsc$w_length = strlen(TargIdentStr); 6     status = sys$asctoid(&Dsc_Pers, &TargIdentBin, 0);C     if(!(status & 1)) return(status);   /* probably SS$_NOSUCHID */(  c9         /* Make repeated calls to SYS$FIND_HELD to return 6            all identifiers held by holder (OldUser) */   ?     HolderBin[1] = 0;        /* complete the quadword holder */S!     while(status == SS$_NORMAL) {(B         status = sys$find_held(&HolderBin, &HeldBin, 0, &context);"         if(status == SS$_NORMAL) {)             if(HeldBin == TargIdentBin) {|P                 status = sys$finish_rdb(&context); /* rights database context */#                 return(SS$_NORMAL);S
             }              else count++;S	         }e>         if((status == SS$_NOSUCHID) && !count) return(status);     } B     return(status);     /* probably SS$_NOSUCHID with count > 0 */ }s  s  (L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowVers H  * Description: User entered the /VERSION qualifier to display the imageH  *              version, C compiler type, and required image privileges.F  *              This software application has NOT been built with VaxC  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */i
 ShowVers() {a3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb); 0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);;     printf("\t\tRequired Privs: CMKRNL, DETACH, SYSPRV\n");s=     printf("\t\t        (or SETPRV as Authorized Priv)\n\n");f     exit(1); }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowHelp A  * Description: User entered the /HELP qualifier to get a list of2A  *              parameters and qualifiers available to this image   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */6
 ShowHelp() {$;     printf(" \n\n%s Command line arguments:\n\n", CmdVerb);l      printf("   Parameters\n\n");J     printf("    USERNAME    Required. The USERNAME is a valid user in\n");I     printf("\t\tthe User Authorization File. The user account cannot\n");TN     printf("\t\tbe disabled. If invalid or disabled, %s exits.\n\n", CmdVerb);      printf("   Qualifiers\n\n");J     printf("    /HELP       If present, %s displays list of qualifiers\n",                 CmdVerb);I?     printf("\t\tavailable for %s (this display)\n\n", CmdVerb);;O     printf("    /IGNOREID   If present, %s ignores identifier requirements.\n",U                 CmdVerb);bL     printf("\t\tHowever, user is required to enter the system manager's\n");+     printf("\t\tpassword to continue\n\n");[P     printf("    /RESOURCE_FILE If present, %s will use this file as the user\n",                 CmdVerb);aH     printf("\t\tdefaults resource input for the created DecTerm. If\n");K     printf("\t\tomitted, %s will attempt to locate the default resource\n",f                 CmdVerb);bG     printf("\t\tfile: DECW$USER_DEFAULTS:DECW$TERMINAL_DEFAULT.DAT\n");;N     printf("\t\tThe value string must specify the FULL filespec, such as:\n");B     printf("\t\t      DDCU:[USERNAME]RESOURCE_FILENAME.TYPE\n\n");M     printf("    /VERSION    If present %s displays version, build", CmdVerb);[1     printf(" date,\n\t\tand required privs\n\n");P     exit(1); }      IH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recalleH  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event]H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMALd  *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.0  *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)T {1<     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0;=@     short   *Lptr = 0;      /* pointer to callers length word */  ;     int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */   $D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */  a=     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */R     if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */  *8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */fA     Iptr = RecallAddr;              /* pseudo pointer register */e     RecallAddr = *Iptr;*0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  2A         /* here we use recall allocation to determine the size ofOB            the recall buffer length field, changed at vms 7.3.2 */  "E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */S?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  oB         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */  ;     if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */g         else {             *length = -1;e"             return(SS$_BUFFEROVF);	         }h     }c2     else *length = *Sptr;       /*  8 bit value */  lC         /* get buffer length and copy cmd line to callers buffer */o  =     Sptr -= *length;!     strncpy(Dptr, Sptr, *length);I     return(SS$_NORMAL);  }I  [  b