" /* xrealloc.c -new memory or bust-4    Copyright (C) 1987 Free Software Foundation, Inc.  , This file is part of GAS, the GNU Assembler.  ; GAS is free software; you can redistribute it and/or modify D it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  6 GAS is distributed in the hope that it will be useful,> but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License 7 along with GAS; see the file COPYING.  If not, write to I the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */      /*     NAME& 	xrealloc () - get more memory or bust INDEX  	xrealloc () uses realloc () SYNOPSIS 	char   *my_memory;   & 	my_memory = xrealloc (my_memory, 42);9 	/ * my_memory gets (perhaps new) address of 42 chars * /    DESCRIPTION   F 	Use xrealloc () as an "error-free" realloc ().It does almost the sameB 	job.  When it cannot honour your request for memory it BOMBS yourE 	program with a "virtual memory exceeded" message.  Realloc() returns % 	NULL and does not bomb your program.    SEE ALSO 	realloc ()  */  
 #ifdef USG #include <malloc.h>  #endif   char   * xrealloc (ptr, n)  register char  *ptr;
 long    n; {      char   *realloc ();      void	error();   0     if ((ptr = realloc (ptr, (unsigned)n)) == 0)# 	error ("virtual memory exceeded");      return (ptr);  }    /* end: xrealloc.c */ 