A /*	$NetBSD: engine.c,v 1.13 2001/12/17 16:32:49 christos Exp $	*/    /*- 0  * Copyright (c) 1992, 1993, 1994 Henry Spencer.!  * Copyright (c) 1992, 1993, 1994 E  *	The Regents of the University of California.  All rights reserved.   *@  * This code is derived from software contributed to Berkeley by  * Henry Spencer.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.K  * 3. All advertising materials mentioning features or use of this software 1  *    must display the following acknowledgement: @  *	This product includes software developed by the University of-  *	California, Berkeley and its contributors. J  * 4. Neither the name of the University nor the names of its contributorsK  *    may be used to endorse or promote products derived from this software 0  *    without specific prior written permission.  *J  * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' ANDH  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THEM  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE K  * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE M  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL J  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODSH  * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)M  * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT L  * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAYI  * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF   * SUCH DAMAGE.   *&  *	@(#)engine.c	8.5 (Berkeley) 3/20/94  */    /*H  * The matching engine and friends.  This file is #included by regexec.cF  * after suitable #defines of a variety of macros used herein, so thatI  * different state representations can be used without duplicating masses   * of code.   */   
 #ifdef SNAMES  #define	matcher	smatcher #define	fast	sfast #define	slow	sslow #define	dissect	sdissect #define	backref	sbackref #define	step	sstep #define	print	sprint #define	at	sat #define	match	smat #endif
 #ifdef LNAMES  #define	matcher	lmatcher #define	fast	lfast #define	slow	lslow #define	dissect	ldissect #define	backref	lbackref #define	step	lstep #define	print	lprint #define	at	lat #define	match	lmat #endif  J /* another structure passed up and down to avoid zillions of parameters */ struct match { 	struct re_guts *g;  	int eflags;6 	regmatch_t *pmatch;	/* [nsub+1] (0 element unused) */* 	char *offp;		/* offsets work from here */= 	char *beginp;		/* start of string -- virtual NUL precedes */ 5 	char *endp;		/* end of string -- virtual NUL here */ 9 	char *coldp;		/* can be no match starting before here */ ! 	char **lastpos;		/* [nplus+1] */  	STATEVARS; ! 	states st;		/* current states */ . 	states fresh;		/* states for a fresh start */ 	states tmp;		/* temporary */ ) 	states empty;		/* empty set of states */  };  9 /* ========= begin header generated by ./mkh ========= */  #ifdef __cplusplus extern "C" { #endif   /* === engine.c === */j static int matcher __P((struct re_guts *g, char *string, size_t nmatch, regmatch_t pmatch[], int eflags));b static char *dissect __P((struct match *m, char *start, char *stop, sopno startst, sopno stopst));m static char *backref __P((struct match *m, char *start, char *stop, sopno startst, sopno stopst, sopno lev)); _ static char *fast __P((struct match *m, char *start, char *stop, sopno startst, sopno stopst)); _ static char *slow __P((struct match *m, char *start, char *stop, sopno startst, sopno stopst)); e static states step __P((struct re_guts *g, sopno start, sopno stop, states bef, int ch, states aft));  #define	BOL	(OUT+1)  #define	EOL	(BOL+1)  #define	BOLEOL	(BOL+2) #define	NOTHING	(BOL+3)  #define	BOW	(BOL+4)  #define	EOW	(BOL+5) 0 #define	CODEMAX	(BOL+5)		/* highest code used */# #define	NONCHAR(c)	((c) > CHAR_MAX) # #define	NNONCHAR	(CODEMAX-CHAR_MAX)  #ifdef REDEBUGT static void print __P((struct match *m, char *caption, states st, int ch, FILE *d)); #endif #ifdef REDEBUGi static void at __P((struct match *m, char *title, char *start, char *stop, sopno startst, sopno stopst));  #endif #ifdef REDEBUG! static char *pchar __P((int ch));  #endif   #ifdef __cplusplus }  #endif7 /* ========= end header generated by ./mkh ========= */    #ifdef REDEBUG- #define	SP(t, s, c)	print(m, t, s, c, stdout) 6 #define	AT(t, p1, p2, s1, s2)	at(m, t, p1, p2, s1, s2)F #define	NOTE(str)	{ if (m->eflags&REG_TRACE) printf("=%s\n", (str)); } #else ! #define	SP(t, s, c)	/* nothing */ + #define	AT(t, p1, p2, s1, s2)	/* nothing */  #define	NOTE(s)	/* nothing */  #endif   /*'  - matcher - the actual matching engine 9  == static int matcher(struct re_guts *g, char *string, \ 4  ==	size_t nmatch, regmatch_t pmatch[], int eflags);  */ 1 static int			/* 0 success, REG_NOMATCH failure */ * matcher(g, string, nmatch, pmatch, eflags) struct re_guts *g;
 char *string;  size_t nmatch; regmatch_t pmatch[]; int eflags;  {  	char *endp; 	int i;  	struct match mv;  	struct match *m = &mv; 
 	char *dp;4 	const sopno gf = g->firststate+1;	/* +1 for OEND */ 	const sopno gl = g->laststate; 
 	char *start;  	char *stop; 	int error = 0;    	_DIAGASSERT(g != NULL); 	_DIAGASSERT(string != NULL);  	/* pmatch checked below */   , 	/* simplify the situation where possible */ 	if (g->cflags&REG_NOSUB) 
 		nmatch = 0;  	if (eflags&REG_STARTEND) {  		_DIAGASSERT(pmatch != NULL);+ 		start = string + (size_t)pmatch[0].rm_so; * 		stop = string + (size_t)pmatch[0].rm_eo;	 	} else {  		start = string;  		stop = start + strlen(start);  	} 	if (stop < start) 		return(REG_INVARG);   @ 	/* prescreening; this does wonders for this rather slow code */ 	if (g->must != NULL) { # 		for (dp = start; dp < stop; dp++) 3 			if (*dp == g->must[0] && stop - dp >= g->mlen && . 				memcmp(dp, g->must, (size_t)g->mlen) == 0)
 				break;/ 		if (dp == stop)		/* we didn't find g->must */  			return(REG_NOMATCH);  	}   	/* match struct setup */ 
 	m->g = g; 	m->eflags = eflags; 	m->pmatch = NULL; 	m->lastpos = NULL;  	m->offp = string; 	m->beginp = start;  	m->endp = stop; 	STATESETUP(m, 4); 	SETUP(m->st); 	SETUP(m->fresh);  	SETUP(m->tmp);  	SETUP(m->empty);  	CLEAR(m->empty);   = 	/* this loop does only one repetition except for backrefs */  	for (;;) { & 		endp = fast(m, start, stop, gf, gl);# 		if (endp == NULL) {		/* a miss */  			error = REG_NOMATCH; 
 			goto done;  		} " 		if (nmatch == 0 && !g->backrefs)' 			break;		/* no further info needed */    		/* where? */ 		assert(m->coldp != NULL);  		for (;;) { 			NOTE("finding start"); * 			endp = slow(m, m->coldp, stop, gf, gl); 			if (endp != NULL)
 				break; 			assert(m->coldp < m->endp); 			m->coldp++; 		} " 		if (nmatch == 1 && !g->backrefs)' 			break;		/* no further info needed */   - 		/* oh my, he wants the subexpressions... */  		if (m->pmatch == NULL)6 			m->pmatch = (regmatch_t *)malloc((m->g->nsub + 1) * 							sizeof(regmatch_t));  		if (m->pmatch == NULL) { 			error = REG_ESPACE;
 			goto done;  		} # 		for (i = 1; i <= m->g->nsub; i++) : 			m->pmatch[i].rm_so = m->pmatch[i].rm_eo = (regoff_t)-1;/ 		if (!g->backrefs && !(m->eflags&REG_BACKR)) {  			NOTE("dissecting");+ 			dp = dissect(m, m->coldp, endp, gf, gl); 
 		} else {* 			if (g->nplus > 0 && m->lastpos == NULL)/ 				m->lastpos = (char **)malloc((g->nplus+1) *  							sizeof(char *)); , 			if (g->nplus > 0 && m->lastpos == NULL) { 				error = REG_ESPACE;  				goto done; 			} 			NOTE("backref dissect"); 5 			dp = backref(m, m->coldp, endp, gf, gl, (sopno)0);  		}  		if (dp != NULL) 	 			break;   = 		/* uh-oh... we couldn't find a subexpression-level match */ = 		assert(g->backrefs);	/* must be back references doing it */ . 		assert(g->nplus == 0 || m->lastpos != NULL); 		for (;;) {& 			if (dp != NULL || endp <= m->coldp) 				break;		/* defeat */ 			NOTE("backoff"); , 			endp = slow(m, m->coldp, endp-1, gf, gl); 			if (endp == NULL) 				break;		/* defeat */( 			/* try it on a shorter possibility */ #ifndef NDEBUG& 			for (i = 1; i <= m->g->nsub; i++) {/ 				assert(m->pmatch[i].rm_so == (regoff_t)-1); / 				assert(m->pmatch[i].rm_eo == (regoff_t)-1);  			} #endif 			NOTE("backoff dissect"); 5 			dp = backref(m, m->coldp, endp, gf, gl, (sopno)0);  		} # 		assert(dp == NULL || dp == endp); , 		if (dp != NULL)		/* found a shorter one */	 			break;   ; 		/* despite initial appearances, there is no match here */  		NOTE("false alarm");4 		start = m->coldp + 1;	/* recycle starting later */ 		assert(start <= stop); 	}  ' 	/* fill in the details if requested */  	if (nmatch > 0) { 		_DIAGASSERT(pmatch != NULL);' 		pmatch[0].rm_so = m->coldp - m->offp; # 		pmatch[0].rm_eo = endp - m->offp;  	} 	if (nmatch > 1) { 		assert(m->pmatch != NULL); 		for (i = 1; i < nmatch; i++) 			if (i <= m->g->nsub)  				pmatch[i] = m->pmatch[i]; 	 			else { # 				pmatch[i].rm_so = (regoff_t)-1; # 				pmatch[i].rm_eo = (regoff_t)-1;  			} 	}   done:  	if (m->pmatch != NULL) {  		free(m->pmatch); 		m->pmatch = NULL;  	} 	if (m->lastpos != NULL) { 		free(m->lastpos);  		m->lastpos = NULL; 	} 	STATETEARDOWN(m); 	return error; }    /*=  - dissect - figure out what matched what, no back references 8  == static char *dissect(struct match *m, char *start, \-  ==	char *stop, sopno startst, sopno stopst);   */ . static char *			/* == stop (success) always */( dissect(m, start, stop, startst, stopst) struct match *m; char *start; char *stop;  sopno startst;
 sopno stopst;  {  	int i; + 	sopno ss;	/* start sop of current subRE */ ) 	sopno es;	/* end sop of current subRE */ . 	char *sp;	/* start of string matched by it */7 	char *stp;	/* string matched by it cannot pass here */t* 	char *rest;	/* start of rest of string */1 	char *tail;	/* string unmatched by rest of RE */ ( 	sopno ssub;	/* start sop of subsubRE */& 	sopno esub;	/* end sop of subsubRE */5 	char *ssp;	/* start of string matched by subsubRE */ 3 	char *sep;	/* end of string matched by subsubRE */f! 	char *oldssp;	/* previous ssp */t #ifndef NDEBUG
 	char *dp; #endif   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(start != NULL); 	_DIAGASSERT(stop != NULL);t  * 	AT("diss", start, stop, startst, stopst); 	sp = start;+ 	for (ss = startst; ss < stopst; ss = es) {u 		/* identify end of subRE */d
 		es = ss;  		switch (OP(m->g->strip[es])) { 		case OPLUS_: 		case OQUEST_:n 			es += OPND(m->g->strip[es]);e	 			break;/ 		case OCH_:& 			while (OP(m->g->strip[es]) != O_CH)  				es += OPND(m->g->strip[es]);	 			break;u 		}r 		es++;h  " 		/* figure out what it matched */  		switch (OP(m->g->strip[ss])) { 		case OEND: 			assert(nope);	 			break;e
 		case OCHAR:  			sp++;	 			break;e 		case OBOL: 		case OEOL: 		case OBOW: 		case OEOW:	 			break;n 		case OANY: 		case OANYOF: 			sp++;	 			break;  		case OBACK_: 		case O_BACK: 			assert(nope);	 			break;*3 		/* cases where length of match is hard to find */* 		case OQUEST_:  			stp = stop;
 			for (;;) {T% 				/* how long could this one be? */O$ 				rest = slow(m, sp, stp, ss, es);, 				assert(rest != NULL);	/* it did match */( 				/* could the rest match the rest? */+ 				tail = slow(m, rest, stop, es, stopst);H 				if (tail == stop)R 					break;		/* yes! */R0 				/* no -- try a shorter match for this one */ 				stp = rest - 1; ( 				assert(stp >= sp);	/* it did work */ 			} 			ssub = ss + 1;U 			esub = es - 1;V 			/* did innards match? */R/ 			if (slow(m, sp, rest, ssub, esub) != NULL) {E
 #ifdef NDEBUGE
 				(void) #elseH	 				dp = N #endif) 				    dissect(m, sp, rest, ssub, esub);G 				_DIAGASSERT(dp == rest); 			} else		/* no */  				assert(sp == rest); 
 			sp = rest; 	 			break;I 		case OPLUS_: 			stp = stop;
 			for (;;) {.% 				/* how long could this one be? */*$ 				rest = slow(m, sp, stp, ss, es);, 				assert(rest != NULL);	/* it did match */( 				/* could the rest match the rest? */+ 				tail = slow(m, rest, stop, es, stopst);t 				if (tail == stop)o 					break;		/* yes! */*0 				/* no -- try a shorter match for this one */ 				stp = rest - 1;a( 				assert(stp >= sp);	/* it did work */ 			} 			ssub = ss + 1;k 			esub = es - 1;n 			ssp = sp; 			oldssp = ssp;. 			for (;;) {	/* find last match of innards */) 				sep = slow(m, ssp, rest, ssub, esub);d" 				if (sep == NULL || sep == ssp)( 					break;	/* failed or matched null */& 				oldssp = ssp;	/* on to next try */ 				ssp = sep; 			} 			if (sep == NULL) {m 				/* last successful match */e 				sep = ssp; 				ssp = oldssp;n 			}4 			assert(sep == rest);	/* must exhaust substring */1 			assert(slow(m, ssp, sep, ssub, esub) == rest);m
 #ifdef NDEBUG 	 			(void); #elsef 			dp =  #endif( 			    dissect(m, ssp, sep, ssub, esub); 			_DIAGASSERT(dp == sep);
 			sp = rest;*	 			break;i 		case OCH_: 			stp = stop;
 			for (;;) { % 				/* how long could this one be? */ $ 				rest = slow(m, sp, stp, ss, es);, 				assert(rest != NULL);	/* it did match */( 				/* could the rest match the rest? */+ 				tail = slow(m, rest, stop, es, stopst);a 				if (tail == stop)t 					break;		/* yes! */=0 				/* no -- try a shorter match for this one */ 				stp = rest - 1;l( 				assert(stp >= sp);	/* it did work */ 			} 			ssub = ss + 1;h) 			esub = ss + OPND(m->g->strip[ss]) - 1;z) 			assert(OP(m->g->strip[esub]) == OOR1);). 			for (;;) {	/* find first matching branch */. 				if (slow(m, sp, rest, ssub, esub) == rest)& 					break;	/* it matched all of it */' 				/* that one missed, try next one */ * 				assert(OP(m->g->strip[esub]) == OOR1); 				esub++;_* 				assert(OP(m->g->strip[esub]) == OOR2); 				ssub = esub + 1;$ 				esub += OPND(m->g->strip[esub]);& 				if (OP(m->g->strip[esub]) == OOR2) 					esub--; 				else+ 					assert(OP(m->g->strip[esub]) == O_CH);s 			}
 #ifdef NDEBUGn	 			(void)t #else  			dp =t #endif( 			    dissect(m, sp, rest, ssub, esub); 			_DIAGASSERT(dp == rest);)
 			sp = rest;N	 			break;  		case O_PLUS: 		case O_QUEST:	 		case OOR1: 		case OOR2: 		case O_CH: 			assert(nope);	 			break;C 		case OLPAREN:R 			i = OPND(m->g->strip[ss]);A$ 			assert(0 < i && i <= m->g->nsub);% 			m->pmatch[i].rm_so = sp - m->offp;a	 			break;e 		case ORPAREN:E 			i = OPND(m->g->strip[ss]); $ 			assert(0 < i && i <= m->g->nsub);% 			m->pmatch[i].rm_eo = sp - m->offp;p	 			break;  		default:		/* uh oh */  			assert(nope);	 			break;p 		}_ 	}   	assert(sp == stop); 	return(sp); }    /*F  - backref - figure out what matched what, figuring in back references8  == static char *backref(struct match *m, char *start, \8  ==	char *stop, sopno startst, sopno stopst, sopno lev);  */	9 static char *			/* == stop (success) or NULL (failure) */;- backref(m, start, stop, startst, stopst, lev)  struct match *m; char *start; char *stop;  sopno startst;
 sopno stopst; % sopno lev;			/* PLUS nesting level */a {i 	int i; + 	sopno ss;	/* start sop of current subRE */h. 	char *sp;	/* start of string matched by it */( 	sopno ssub;	/* start sop of subsubRE */& 	sopno esub;	/* end sop of subsubRE */5 	char *ssp;	/* start of string matched by subsubRE */s
 	char *dp; 	size_t len;
 	int hard; 	sop s;t 	regoff_t offsave;
 	cset *cs;   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(start != NULL); 	_DIAGASSERT(stop != NULL);s  * 	AT("back", start, stop, startst, stopst); 	sp = start;  + 	/* get as far as we can with easy stuff */;
 	hard = 0;/ 	for (ss = startst; !hard && ss < stopst; ss++)s$ 		switch (OP(s = m->g->strip[ss])) {
 		case OCHAR: , 			if (sp == stop || *sp++ != (char)OPND(s)) 				return(NULL);B	 			break;h 		case OANY: 			if (sp == stop) 				return(NULL);m 			sp++;	 			break;r 		case OANYOF: 			cs = &m->g->sets[OPND(s)];=& 			if (sp == stop || !CHIN(cs, *sp++)) 				return(NULL);t	 			break;t 		case OBOL:7 			if ( (sp == m->beginp && !(m->eflags&REG_NOTBOL)) ||R( 					(sp < m->endp && *(sp-1) == '\n' &&# 						(m->g->cflags&REG_NEWLINE)) )g 				{ /* yes */ }  			else  				return(NULL); 	 			break;i 		case OEOL:5 			if ( (sp == m->endp && !(m->eflags&REG_NOTEOL)) ||u$ 					(sp < m->endp && *sp == '\n' &&# 						(m->g->cflags&REG_NEWLINE)) )d 				{ /* yes */ }t 			elseO 				return(NULL); 	 			break;t 		case OBOW:8 			if (( (sp == m->beginp && !(m->eflags&REG_NOTBOL)) ||( 					(sp < m->endp && *(sp-1) == '\n' &&$ 						(m->g->cflags&REG_NEWLINE)) || 					(sp > m->beginp &&> 							!ISWORD(*(sp-1))) ) &&P$ 					(sp < m->endp && ISWORD(*sp)) ) 				{ /* yes */ }  			else  				return(NULL);i	 			break;  		case OEOW:6 			if (( (sp == m->endp && !(m->eflags&REG_NOTEOL)) ||$ 					(sp < m->endp && *sp == '\n' &&$ 						(m->g->cflags&REG_NEWLINE)) ||( 					(sp < m->endp && !ISWORD(*sp)) ) &&* 					(sp > m->beginp && ISWORD(*(sp-1))) ) 				{ /* yes */ }/ 			elset 				return(NULL); 	 			break;) 		case O_QUEST:i	 			break; 1 		case OOR1:	/* matches null but needs to skip */  			ss++; 			s = m->g->strip[ss];r 			do {p 				assert(OP(s) == OOR2); 				ss += OPND(s);- 			} while (OP(s = m->g->strip[ss]) != O_CH);r1 			/* note that the ss++ gets us past the O_CH */r	 			break;*& 		default:	/* have to make a choice */ 			hard = 1;	 			break;( 		}-! 	if (!hard) {		/* that was it! */h 		if (sp != stop)a 			return(NULL);
 		return(sp);P 	}3 	ss--;			/* adjust for the for's final increment */;   	/* the hard stuff */m" 	AT("hard", sp, stop, ss, stopst); 	s = m->g->strip[ss];s 	switch (OP(s)) {_& 	case OBACK_:		/* the vilest depths */ 		i = OPND(s);# 		assert(0 < i && i <= m->g->nsub); ) 		if (m->pmatch[i].rm_eo == (regoff_t)-1)  			return(NULL);- 		assert(m->pmatch[i].rm_so != (regoff_t)-1);h: 		len = (size_t)(m->pmatch[i].rm_eo - m->pmatch[i].rm_so);" 		assert(stop - m->beginp >= len); 		if (sp > stop - len)/ 			return(NULL);	/* not enough left to match */g- 		ssp = m->offp + (size_t)m->pmatch[i].rm_so;	  		if (memcmp(sp, ssp, len) != 0) 			return(NULL);+ 		while (m->g->strip[ss] != SOP(O_BACK, i)); 			ss++;6 		return(backref(m, sp+len, stop, ss+1, stopst, lev));  $ 	case OQUEST_:		/* to null or not *// 		dp = backref(m, sp, stop, ss+1, stopst, lev);	 		if (dp != NULL)T 			return(dp);	/* not */: 		return(backref(m, sp, stop, ss+OPND(s)+1, stopst, lev));  
 	case OPLUS_:a 		assert(m->lastpos != NULL);  		assert(lev+1 <= m->g->nplus);	 		m->lastpos[lev+1] = sp;b4 		return(backref(m, sp, stop, ss+1, stopst, lev+1));  
 	case O_PLUS:m9 		if (sp == m->lastpos[lev])	/* last pass matched null */(5 			return(backref(m, sp, stop, ss+1, stopst, lev-1));, 		/* try another pass */ 		m->lastpos[lev] = sp;d7 		dp = backref(m, sp, stop, ss-OPND(s)+1, stopst, lev);/ 		if (dp == NULL)*2 			dp = backref(m, sp, stop, ss+1, stopst, lev-1);
 		return(dp);a  - 	case OCH_:		/* find the right one, if any */s 		ssub = ss + 1; 		esub = ss + OPND(s) - 1;( 		assert(OP(m->g->strip[esub]) == OOR1);- 		for (;;) {	/* find first matching branch */ . 			dp = backref(m, sp, stop, ssub, esub, lev); 			if (dp != NULL) 				return(dp); & 			/* that one missed, try next one */% 			if (OP(m->g->strip[esub]) == O_CH)h% 				return(NULL);	/* there is none */m
 			esub++;) 			assert(OP(m->g->strip[esub]) == OOR2);s 			ssub = esub + 1;	# 			esub += OPND(m->g->strip[esub]);	% 			if (OP(m->g->strip[esub]) == OOR2)L 				esub--;m 			else;* 				assert(OP(m->g->strip[esub]) == O_CH); 		}L  8 	case OLPAREN:		/* must undo assignment if rest fails */ 		i = OPND(s);# 		assert(0 < i && i <= m->g->nsub);f 		offsave = m->pmatch[i].rm_so;a$ 		m->pmatch[i].rm_so = sp - m->offp;/ 		dp = backref(m, sp, stop, ss+1, stopst, lev);p 		if (dp != NULL)p 			return(dp); 		m->pmatch[i].rm_so = offsave;u 		return(NULL);   8 	case ORPAREN:		/* must undo assignment if rest fails */ 		i = OPND(s);# 		assert(0 < i && i <= m->g->nsub);p 		offsave = m->pmatch[i].rm_eo; $ 		m->pmatch[i].rm_eo = sp - m->offp;/ 		dp = backref(m, sp, stop, ss+1, stopst, lev);/ 		if (dp != NULL)a 			return(dp); 		m->pmatch[i].rm_eo = offsave;i 		return(NULL);e   	default:		/* uh oh */ 		assert(nope);n 		break; 	}   	/* "can't happen" */b 	assert(nope); 	/* NOTREACHED */t
 	return NULL;u }    /*.  - fast - step through the string at top speed5  == static char *fast(struct match *m, char *start, \p-  ==	char *stop, sopno startst, sopno stopst);a  */d: static char *			/* where tentative match ended, or NULL */% fast(m, start, stop, startst, stopst)E struct match *m; char *start; char *stop;) sopno startst;
 sopno stopst;s {t 	states st = m->st;t 	states fresh = m->fresh;s 	states tmp = m->tmp;  	char *p = start;f1 	int c = (start == m->beginp) ? OUT : *(start-1);] 	int lastc;	/* previous c */ 	int flagch; 	int i;(< 	char *coldp;	/* last p after which no match was underway */   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(start != NULL); 	_DIAGASSERT(stop != NULL);    	CLEAR(st);  	SET1(st, startst);	3 	st = step(m->g, startst, stopst, st, NOTHING, st);r 	ASSIGN(fresh, st);  	SP("start", st, *p);; 	coldp = NULL; 	for (;;) {	 		/* next character */ 		lastc = c;  		c = (p == m->endp) ? OUT : *p; 		if (EQ(st, fresh))
 			coldp = p;e  7 		/* is there an EOL and/or BOL between lastc and c? */* 		flagch = '\0'; 		i = 0;5 		if ( (lastc == '\n' && m->g->cflags&REG_NEWLINE) || 1 				(lastc == OUT && !(m->eflags&REG_NOTBOL)) ) {* 			flagch = BOL; 			i = m->g->nbol; 		}	1 		if ( (c == '\n' && m->g->cflags&REG_NEWLINE) ||c- 				(c == OUT && !(m->eflags&REG_NOTEOL)) ) {o+ 			flagch = (flagch == BOL) ? BOLEOL : EOL;= 			i += m->g->neol;	 		}e 		if (i != 0) {  			for (; i > 0; i--)f5 				st = step(m->g, startst, stopst, st, flagch, st);  			SP("boleol", st, c);	 		}	  " 		/* how about a word boundary? */= 		if ( (flagch == BOL || (lastc != OUT && !ISWORD(lastc))) &&u  					(c != OUT && ISWORD(c)) ) { 			flagch = BOW; 		}p) 		if ( (lastc != OUT && ISWORD(lastc)) &&s3 				(flagch == EOL || (c != OUT && !ISWORD(c))) ) {	 			flagch = EOW; 		}s' 		if (flagch == BOW || flagch == EOW) { 4 			st = step(m->g, startst, stopst, st, flagch, st); 			SP("boweow", st, c);b 		}*   		/* are we done? */% 		if (ISSET(st, stopst) || p == stop)) 			break;		/* NOTE BREAK OUT */d  , 		/* no, we must deal with this character */ 		ASSIGN(tmp, st); 		ASSIGN(st, fresh); 		assert(c != OUT);	/ 		st = step(m->g, startst, stopst, tmp, c, st);r 		SP("aft", st, c); ? 		assert(EQ(step(m->g, startst, stopst, st, NOTHING, st), st));s 		p++; 	}   	assert(coldp != NULL);s 	m->coldp = coldp; 	if (ISSET(st, stopst))f 		return(p+1); 	elsed 		return(NULL);l }m   /*3  - slow - step through the string more deliberatelys5  == static char *slow(struct match *m, char *start, \p-  ==	char *stop, sopno startst, sopno stopst);	  */	$ static char *			/* where it ended */% slow(m, start, stop, startst, stopst)s struct match *m; char *start; char *stop;* sopno startst;
 sopno stopst;a {r 	states st = m->st;s 	states empty = m->empty;f 	states tmp = m->tmp;e 	char *p = start;d1 	int c = (start == m->beginp) ? OUT : *(start-1);I 	int lastc;	/* previous c */ 	int flagch; 	int i;a2 	char *matchp;	/* last p at which a match ended */   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(start != NULL); 	_DIAGASSERT(stop != NULL);N  * 	AT("slow", start, stop, startst, stopst); 	CLEAR(st);e 	SET1(st, startst);o 	SP("sstart", st, *p);3 	st = step(m->g, startst, stopst, st, NOTHING, st);* 	matchp = NULL;t 	for (;;) {m 		/* next character */ 		lastc = c;  		c = (p == m->endp) ? OUT : *p;  7 		/* is there an EOL and/or BOL between lastc and c? */( 		flagch = '\0'; 		i = 0;5 		if ( (lastc == '\n' && m->g->cflags&REG_NEWLINE) ||*1 				(lastc == OUT && !(m->eflags&REG_NOTBOL)) ) {  			flagch = BOL; 			i = m->g->nbol; 		}i1 		if ( (c == '\n' && m->g->cflags&REG_NEWLINE) || - 				(c == OUT && !(m->eflags&REG_NOTEOL)) ) {=+ 			flagch = (flagch == BOL) ? BOLEOL : EOL;t 			i += m->g->neol;  		}s 		if (i != 0) {	 			for (; i > 0; i--)r5 				st = step(m->g, startst, stopst, st, flagch, st);	 			SP("sboleol", st, c); 		}(  " 		/* how about a word boundary? */= 		if ( (flagch == BOL || (lastc != OUT && !ISWORD(lastc))) &&d  					(c != OUT && ISWORD(c)) ) { 			flagch = BOW; 		}s) 		if ( (lastc != OUT && ISWORD(lastc)) &&P3 				(flagch == EOL || (c != OUT && !ISWORD(c))) ) {	 			flagch = EOW; 		}o' 		if (flagch == BOW || flagch == EOW) {=4 			st = step(m->g, startst, stopst, st, flagch, st); 			SP("sboweow", st, c); 		}    		/* are we done? */ 		if (ISSET(st, stopst)) 			matchp = p;! 		if (EQ(st, empty) || p == stop)< 			break;		/* NOTE BREAK OUT */m  , 		/* no, we must deal with this character */ 		ASSIGN(tmp, st); 		ASSIGN(st, empty); 		assert(c != OUT);p/ 		st = step(m->g, startst, stopst, tmp, c, st);f 		SP("saft", st, c);? 		assert(EQ(step(m->g, startst, stopst, st, NOTHING, st), st));c 		p++; 	}   	return(matchp); }r     /*H  - step - map set of states reachable before char to set reachable afterD  == static states step(struct re_guts *g, sopno start, sopno stop, \$  ==	states bef, int ch, states aft);  == #define	BOL	(OUT+1)   == #define	EOL	(BOL+1)   == #define	BOLEOL	(BOL+2)  == #define	NOTHING	(BOL+3)p  == #define	BOW	(BOL+4)r  == #define	EOW	(BOL+5);1  == #define	CODEMAX	(BOL+5)		// highest code used/'  == #define	NONCHAR(c)	((c) > CHAR_MAX)/'  == #define	NNONCHAR	(CODEMAX-CHAR_MAX)s  */o
 static statesd" step(g, start, stop, bef, ch, aft) struct re_guts *g;- sopno start;			/* start state within strip */I7 sopno stop;			/* state after stop state within strip */G* states bef;		/* states reachable before */* int ch;				/* character or NONCHAR code */7 states aft;		/* states already known reachable after */f {(
 	cset *cs; 	sop s;&
 	sopno pc;2 	onestate here;		/* note, macros know this name */ 	sopno look; 	int i;=   	_DIAGASSERT(g != NULL);  @ 	for (pc = start, INIT(here, pc); pc != stop; pc++, INC(here)) { 		s = g->strip[pc];m 		switch (OP(s)) { 		case OEND: 			assert(pc == stop-1);	 			break; 
 		case OCHAR:o" 			/* only characters can match *// 			assert(!NONCHAR(ch) || ch != (char)OPND(s));m 			if (ch == (char)OPND(s))O 				FWD(aft, bef, 1);m	 			break;( 		case OBOL:! 			if (ch == BOL || ch == BOLEOL)) 				FWD(aft, bef, 1); 	 			break;  		case OEOL:! 			if (ch == EOL || ch == BOLEOL)i 				FWD(aft, bef, 1);(	 			break;E 		case OBOW: 			if (ch == BOW)p 				FWD(aft, bef, 1);		 			break;l 		case OEOW: 			if (ch == EOW)s 				FWD(aft, bef, 1);e	 			break;  		case OANY: 			if (!NONCHAR(ch)) 				FWD(aft, bef, 1);m	 			break;G 		case OANYOF: 			cs = &g->sets[OPND(s)];$ 			if (!NONCHAR(ch) && CHIN(cs, ch)) 				FWD(aft, bef, 1);m	 			break;>" 		case OBACK_:		/* ignored here */ 		case O_BACK: 			FWD(aft, aft, 1);	 			break;*4 		case OPLUS_:		/* forward, this is just an empty */ 			FWD(aft, aft, 1);	 			break;&+ 		case O_PLUS:		/* both forward and back */n 			FWD(aft, aft, 1); 			i = ISSETBACK(aft, OPND(s));  			BACK(aft, aft, OPND(s));W' 			if (!i && ISSETBACK(aft, OPND(s))) {S( 				/* oho, must reconsider loop body */ 				pc -= OPND(s) + 1; 				INIT(here, pc);O 			}	 			break;k1 		case OQUEST_:		/* two branches, both forward */* 			FWD(aft, aft, 1); 			FWD(aft, aft, OPND(s));	 			break;O$ 		case O_QUEST:		/* just an empty */ 			FWD(aft, aft, 1);	 			break; + 		case OLPAREN:		/* not significant here */p 		case ORPAREN:  			FWD(aft, aft, 1);	 			break; / 		case OCH_:		/* mark the first two branches */  			FWD(aft, aft, 1);, 			assert(OP(g->strip[pc+OPND(s)]) == OOR2); 			FWD(aft, aft, OPND(s));	 			break;d0 		case OOR1:		/* done a branch, find the O_CH */ 			if (ISSTATEIN(aft, here)) { 				for (look = 1;( 						OP(s = g->strip[pc+look]) != O_CH; 						look += OPND(s)) 					assert(OP(s) == OOR2);s 				FWD(aft, aft, look); 			}	 			break;	, 		case OOR2:		/* propagate OCH_'s marking */ 			FWD(aft, aft, 1);* 			if (OP(g->strip[pc+OPND(s)]) != O_CH) {- 				assert(OP(g->strip[pc+OPND(s)]) == OOR2);r 				FWD(aft, aft, OPND(s));g 			}	 			break;f 		case O_CH:		/* just empty */ 			FWD(aft, aft, 1);	 			break;* 		default:		/* ooooops... */ 			assert(nope);	 			break;e 		}s 	}  
 	return(aft);	 }t   #ifdef REDEBUG /*   - print - print a set of states  == #ifdef REDEBUGB  == static void print(struct match *m, char *caption, states st, \  ==	int ch, FILE *d);p
  == #endif  */  static voidt print(m, caption, st, ch, d) struct match *m; char *caption;
 states st; int ch;t FILE *d; {) 	struct re_guts *g = m->g; 	int i;  	int first = 1;o   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(caption != NULL);   	if (!(m->eflags&REG_TRACE))	 		return;p   	_DIAGASSERT(d != NULL);   	fprintf(d, "%s", caption);l 	if (ch != '\0') 		fprintf(d, " %s", pchar(ch));r! 	for (i = 0; i < g->nstates; i++), 		if (ISSET(st, i)) {o0 			fprintf(d, "%s%d", (first) ? "\t" : ", ", i);
 			first = 0;p 		}O 	fprintf(d, "\n"); }/   /* (  - at - print current situations  == #ifdef REDEBUGK  == static void at(struct match *m, char *title, char *start, char *stop, \ &  ==						sopno startst, sopno stopst);
  == #endif  */( static voids* at(m, title, start, stop, startst, stopst) struct match *m; char *title; char *start; char *stop;, sopno startst;
 sopno stopst;	 {u   	_DIAGASSERT(m != NULL); 	_DIAGASSERT(title != NULL); 	_DIAGASSERT(start != NULL); 	_DIAGASSERT(stop != NULL);i   	if (!(m->eflags&REG_TRACE))	 		return;s  ( 	printf("%s %s-", title, pchar(*start)); 	printf("%s ", pchar(*stop));s2 	printf("%ld-%ld\n", (long)startst, (long)stopst); }b   #ifndef PCHARDONEs# #define	PCHARDONE	/* never again */  /*%  - pchar - make a character printablem  == #ifdef REDEBUG  == static char *pchar(int ch);&
  == #endif  *E  * Is this identical to regchar() over in debug.c?  Well, yes.  But aoE  * duplicate here avoids having a debugging-capable regexec.o tied toLD  * a matching debug.o, and this is convenient.  It all disappears in?  * the non-debug compilation anyway, so it doesn't matter much.   */D' static char *			/* -> representation */p	 pchar(ch)  int ch;c {] 	static char pbuf[10];   	if (isprint(ch) || ch == ' '). 		(void)snprintf(pbuf, sizeof pbuf, "%c", ch); 	elseL0 		(void)snprintf(pbuf, sizeof pbuf, "\\%o", ch); 	return(pbuf); }e #endif #endif   #undef	matcher #undef	fast	 #undef	slow  #undef	dissect #undef	backref #undef	stepO #undef	print	 #undef	atL #undef	match