#++
#   FACILITY:	VoIP Service
#
#   MODULE DESCRIPTION:
#	
#	This module contains a VoIP application TCL-script to perform a basic
#	Authentication/Authorization of a subscriber by using Calling-Id against
#	a server based Subscribers database. The AA task is performed by using the RADIUS
#	protocol.
#	This script is supposed to performs a central based authenticationand authorization
#	of subscribers who calls a VoIP service.
#
#  AUTHORS:
#
#	Ruslan R. Laishev
#
#  CREATION DATE: 18-OCT-2001
#
#  MODIFICATION HISTORY:
#
#--

#++
#	A main procedure
#--

	#++
	# Just accept a call and setup a speach path
	#--

	acceptCall

	#++
	# Send an authentication/authorization request to RADIUS-VMS server with:
	#	Calling-Id
	#	Called-Id
	#--
	set	event [authenticate [ani] [dnis] info]

	puts	"Calling-Id = [ani], Called-Id = [dnis], event = $event"

	#++
	# Check an authentication result
	#--
	if { $event == "authenticated" } {
		#++
		# If authentication is accepted then just place the call
		#--
		set event [placeCall [dnis] callInfo info]

		if { $event == "active" } {
			set event [waitEvent]
		}
	} else {
		#++
		# If authentication is rejected then play something and exit
		#--
		set prompt(url) flash:ru_no_service.au
		set prompt(playComplete) true

		set event [promptAndCollect prompt info]
	
		set state end
		}

	puts	"Calling-Id = [ani], Called-Id = [dnis], event = $event"
