#include <stdio.h>
#include <starlet.h>
#include <ssdef.h>
#include <stdlib.h>
#include <iosbdef.h>

/* RMI symbol definitions. */
#include <rmidef.h>
#include <string.h>

/* Item List Entry definitions. */
#include <iledef.h>

int sys$getrmi (unsigned int ,
        unsigned int ,
        unsigned int,
        void *,

struct _iosb *,
        void (*)(__unknown_params),
        int);

#define check(S) if(!((S)&1)) sys$exit(S)
#define RMI_EFN 33

int main(void)
{
        int status;
        iosb ios;

        __int64 int_state;
        __int64 mp_synch;
        __int64 kernel;
        __int64 exec;
        __int64 super;
        __int64 user;
        __int64 idle;
        __int64 total;

static unsigned int cur, com, hib, pfw, lef, cef, mwait;
static unsigned int bufio, dirio, como, hibo, lefo;

static  __int64 oint_state=0;
static  __int64 omp_synch=0;
static  __int64 okernel=0;
static  __int64 oexec=0;
static  __int64 osuper=0;
static  __int64 ouser=0;
static  __int64 oidle=0;
static  __int64 ototal = 0;
static  __int64 dtotal = 0;

ile3 items[] = {
                {sizeof(int_state),RMI$_CPUINTSTK,&int_state},
                {sizeof(mp_synch),RMI$_CPUMPSYNCH,&mp_synch},
                {sizeof(kernel),RMI$_CPUKERNEL,&kernel},
                {sizeof(exec),RMI$_CPUEXEC,&exec},
                {sizeof(super),RMI$_CPUSUPER,&super},
                {sizeof(user),RMI$_CPUUSER,&user},
                {sizeof(idle),RMI$_CPUIDLE,&idle},
                {sizeof(cur),RMI$_CUR,&cur},
                {sizeof(com),RMI$_COM,&com},
                {sizeof(hib),RMI$_HIB,&hib},
                {sizeof(pfw),RMI$_PFW,&pfw},
                {sizeof(lef),RMI$_LEF,&lef},
                {sizeof(cef),RMI$_CEF,&cef},
                {sizeof(mwait),RMI$_MWAIT,&mwait},
		{sizeof(bufio),RMI$_BUFIO,&bufio},
                {sizeof(dirio),RMI$_DIRIO,&dirio},
                {sizeof(como),RMI$_COMO,&como},
                {sizeof(hibo),RMI$_HIBO,&hibo},
                {sizeof(lefo),RMI$_LEFO,&lefo},
                {0,0}
               };

/*
oint_state = int_state;
omp_synch = mp_synch;
okernel = kernel;
oexec = exec;
osuper = super;
ouser = user;
oidle = idle;
ototal = total;
*/

// Get the CPU modes
status = sys$getrmi(RMI_EFN,0,0,items,&ios,0,0);
check(status);

// wait for the RMI completion
status = sys$waitfr(RMI_EFN);
check(status);
check(ios.iosb$w_status);

// CPU mode stats
total = int_state+mp_synch+kernel+exec+super+user+idle;
dtotal = total-ototal;

printf("%7s %7s %7s %7s %7s %7s %7s\n",
	"IState","MPSync","Kernel","Exec","Super","User","Idle");

printf("%6.2lf%% %6.2lf%% %6.2lf%% %6.2lf%% " " %6.2lf%% %6.2lf%% %6.2lf%%\n",
                (double)(int_state-oint_state)*100.0/dtotal,
                (double)(mp_synch-omp_synch)*100.0/dtotal,
                (double)(kernel-okernel)*100.0/dtotal,
                (double)(exec-oexec)*100.0/dtotal,
                (double)(super-osuper)*100.0/dtotal,
                (double)(user-ouser)*100.0/dtotal,
                (double)(idle-oidle)*100.0/dtotal
        );

printf("\n%7s %7s %7s %7s %7s %7s %7s\n",
        "CUR","COM","HIB","PFW","LEF","CEF","MWAIT"
        );

printf("%7u %7u %7u %7u %7u %7u %7u\n",
        cur, com, hib,pfw,lef,cef,mwait
        );

printf("\n%7s %7s %7s %7s %7s\n",
        "Buf I/O","Dir I/O","COM Out","HIB Out","LEF Out"
        );

printf("%7u %7u %7u %7u %7u\n",
        bufio,dirio,como,hibo,lefo
        );


oint_state = int_state;
omp_synch = mp_synch;
okernel = kernel;
oexec = exec;
osuper = super;
ouser = user;
oidle = idle;
ototal = total;

        return (SS$_NORMAL);
}
