/* Version: 	V1.0
 * Name:    	vms_osi.h 
 * Location:    sys$examples:
 *  
 * ABSTRACT:
 *
 * This exampe file contains macros, data structures and constants that
 * can be used by XTI programmers. The OSI example programs for XTI
 * (cx,subx,sx and xtiutil) use make use of this file.
 * 
 * 
 * ENVIRONMENT:
 *	VMS 6.1 
 */
#ifndef __VMS_OSI__
#define __VMS_OSI__

#include <xti.h>

/*
 *** Setup of provider strings for t_open, ex: PNM( PTY_OSI )  
 */

static char *pname[] =   { "unknown", "ucx/tcp", "ucx/udp", "dnet", "osi/cots", 
                         "osi/cots/r1006", "dnet/dnet/r1006" };


#define PTY_UNKNOWN 	0			/* Unknown provider   */
#define PTY_TCP 	1                       /* TCP provider       */
#define PTY_UDP 	2                       /* UDP provider       */
#define PTY_DNET 	3                       /* DECnet provider    */
#define PTY_OSI 	4                       /* OSI provider       */ 
#define PTY_1006 	5                       /* RFC 1006 over osi  */
#define PTY_D1006 	6                       /* RFC 1006 over dnet */

#define PNM(name)       ( ( ((name)>PTY_D1006) || ((name)<PTY_UNKNOWN) ) ? \
                            pname[PTY_UNKNOWN] : pname[(name)] ) 


/*
 ***	Helper macros for Casting address types
 */

#define IN(x)    ( (struct xtiaddr_in    *)  (x) ) 
#define OSI(x)   ( (struct xtiaddr_osi   *)  (x) ) 
#define DN(x)    ( (struct xtiaddr_dn    *)  (x) ) 
#define SOSI(x)  ( (struct sockaddr_osi  *)  (x) ) 

/*
 *** Macro strings setup OSF size field of addr structure   
 */

#define OSIADDRLEN(a) ( (a) != NULL ? sizeof(struct xtiaddr_osi) : 0 )

#define _upcase(c)     ( (c) & 0x5F  )

#define _swapb(x)      ( ((x)<<8&0xff00) | ((x)>>8&0x00ff) )

#define xti_ntohl(x)   (  ( ((x)&0x00ff)     <<24) | \
                          ( ((x)&0xff000000) >>24) | \
                          ( ((x)&0xff00)     <<8)  | \
                          ( ((x)&0xff0000)   >>8)  )

/*
 ** Macros to get and put 32 and 16 bits
 */

#define GET16(p)   (*(p) + (*(p+1)<<8))
#define GET32(p)   (*(p) + (*(p+1)<<8) + (*(p+2)<<16) + (*(p+3)<<24))
#define PUT16(p,n) p[0] = (n); p[1] = (n)>>8; p += 2
#define PUT32(p,n) p[0] = (n); p[1] = (n)>>8; p[2] = (n)>>16; p[3] = (n)>>24;p+= 4


/*
 *** macro for help with the t_select function, similar to <include/sys>types.h 
 */

/*
 *    The size of the fd_bits array is arbitrary here, we have 32 slots
 *    of 32 bits each. We use BITGRP to allocate chucks of bits, in this
 *    case 32. The n/BITGRP gives us 32 groups of 32 bits. We set/clear/check
 *    the cooresponding bit in the appropriate group by the use of 
 *    the modulo operator.
 *
 *    In summary, the subscript division gives you the groups of BITGRP bits and
 *    the modulo operator by BITGRP gives you the bit offset within that
 *    particular group of bits.
 */  

#define BITGRP 		sizeof(int) * 8        	/* 4 bytes * 8 bits */
#define fd_mask 	int

typedef	struct fd_set {
	fd_mask	fds_bits[ BITGRP ];
} fd_set;


#define	FD_SET(n, p)	((p)->fds_bits[(n)/BITGRP] |= (1 << ((n) % BITGRP)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/BITGRP] &= ~(1 << ((n) % BITGRP)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/BITGRP] & (1 << ((n) % BITGRP)))
#define FD_ZERO(p)	memset((char *)(p), 0, sizeof(*(p)))




/* 
 *** alias for GET32 used in example programs 
 */

#define EXT32(x)	GET32( (x) )

/*
 **  from OSF platform 
 */


#define OSIPROTO_COTS		   1	/* OSI Connection Oriented Transport */
#define OSIPROTO_CLNS		   2	/* OSI Network Services */
#define	OSIPROTO_NS	OSIPROTO_CLNS	/* ... */
#define	OSIPROTO_CONS	OSIPROTO_CLNS	/* ... */
#define OSIPROTO_NSDBG		   4	/* Network service debug protocol */
#define OSIPROTO_DNASESSION	   9	/* DNA Session Control */
#define OSIPROTO_NSP		  10	/* DNA NSP */
#define OSIPROTO_CLTS		8602	/* OSI Connection-Less Transport */
#define OSIPROTO_PING             99    /* OSI Ping protocol */


/*
 * Definitions relating to the OSI socket interface
 */
#define OSI_NLEN        20      /* Max length of an NSAP */
#define OSI_TLEN        32      /* Max length of a TSAP-ID (T-Selector) */
#define OSI_SLEN	64	/* Max length of SSAP */

#define PLEN		10		/* Max length of NS-provider address */
#define NLEN		OSI_NLEN	/* Max length of NSAP */
#define TLEN		OSI_TLEN	/* Max length of TSAP */
#define SLEN		OSI_SLEN	/* Max length of SSAP */
#define TCPLEN		2		/* Max length of TCP port */
#define IPLEN		4		/* Max length of Internet IP address */

/* OSF define constant - qlen */

#define SOMAXCONN	5


/*
 * Network services access point (nsap) format
 * Note that this field is only valid for Internet addressing.
 */
struct nsap {
    unsigned char nsap_length;          /* length of nsap address */
    unsigned char nsap_addr[OSI_NLEN];  /* nsap address */
};

/*
 *** Transport service access point (tsap) format
 */
struct tsap {
    unsigned char tsap_length;          /* length of tsap address */
    unsigned char tsap_addr[OSI_TLEN];  /* tsap address */
};



/* Architected Protocol Identifier octet strings */
#define PROTOID_DNASESSIONV2	0x02
#define PROTOID_DNASESSIONV3	0x03
#define PROTOID_NSP		0x04
#define PROTOID_COTS		0x05
#define PROTOID_OSINETWORK	0x06
#define PROTOID_CLNS		PROTOID_OSINETWORK
#define PROTOID_CONS		PROTOID_OSINETWORK
#define PROTOID_CLTS		0x0e
#define PROTOID_CMIPMICE	01, 19
#define PROTOID_TCP		0x07	/* Internet TCP */
#define PROTOID_UDP		0x08	/* Internet UDP */
#define PROTOID_IP		0x09	/* Internet IP */


/*	 
 ***  Structure to define OSI Options, extended and flowctrl are read only
 */	 


struct  isoco_options {                          /* for examples */
            struct lopt {
                struct t_opthdr opthdr;          /* in xti.h */
                unsigned long value;
            } class,expedited,checksum,extended,flowctrl;
};

/*
 *** use as an universal address   
 */
 struct sockaddr_osi { 
        union xtiaddr  u_sosi; 
};


#endif /* __VMS_OSI__ */
