/*
** COPYRIGHT (c) 1995 BY
** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
** ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
** CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
**
*/

#pragma module uwss_test "V01-00"

/*
**++
**  FACILITY:  SYS$EXAMPLES
**
**  MODULE DESCRIPTION:
**
**	UWSS_TEST: This module tests out the example C-language user-written
**	system service by calling each of the four routines in it ten times
**	legitimately and by calling the first_service routine with bad virtual
**	addresses (to ensure bogus addresses are rejected).
**
**  AUTHORS:
**
**      Digital Equipment Corporation
**
**  CREATION DATE:  5 January 1993
**
**  DESIGN ISSUES:
**
**      None known
**
**  PORTABILITY ISSUES:
**
**	This program is only intended to show that the example
**	user-written system services (in a privileged shareable image)
**	on OpenVMS Alpha work properly.  For the "intended to fail"
**	test, the program assumes 32-bit virtual addressing (and that
**	80000000 hex is the bottom of system space)
**
**  COMPILATION, LINKING AND INSTALLATION PROCEDURES:
**
**  	To compile this routine, use
**
**	$ CC UWSS_TEST
**
**	To link this routine, use the following link procedure:
**
**	$ LINK	/MAP /FULL /CROSS -
**	UWSS_TEST, SYS$INPUT:/OPTIONS
**	SYS$LIBRARY:UWSS/SHARE
**	$
**
**  MODIFICATION HISTORY:
**
**  X-1	DCP001		               		05-Jan-1993
**	Module created.
**
**  X-2	DCP001		               		17-Mar-1993
**	Add linking instructions, minor cosmetic changes.
**
**  X-3	NYK501					17-Mar-1995
**	Add 64-bit-related examples.
**
**--
*/

#include <chfdef.h>
#include <far_pointers.h>
#include <ints.h>
#include <lib$routines.h>
#include <ssdef.h>
#include <stdio.h>




/*
** First_service and fourth_service are declared as being able to accept 64-bit
** arguments only as means of illustrating run-time errors.  This example is
** illustrating how coding errors will be caught at run-time by the OpenVMS
** Alpha system service dispatcher.  Compiler warnings would be generated at
** the point in the program where 64-bit pointers are passed to first_service
** and fourth_service if proper declaration were used:
**
** int first_service  (int *ptr),
**     second_service (INT_PQ ptr),
**     third_service  (INT_PQ ptr),
**     fourth_service (int *ptr);
*/

int first_service(INT_PQ ptr),
    second_service(INT_PQ ptr),
    third_service(INT_PQ ptr),
    fourth_service(INT_PQ ptr);

/* The test program itself. */

main ()

{
/*
**  For this program, we use a fixed iteration count. More stringent
**  tests could use a larger count
*/
#define MAX_COUNT 10
    int iter_count;
    int params[] = {0xffffffff,-2};
    int64 req_size = sizeof (int) * 2;
    INT_PQ params_64;
    int ss_return;
    unsigned int bad_ret_addr_1=0x80000000;
    unsigned int bad_ret_addr_2=0;
	union {			/* this works for 32 bits only */
	    int * dummy;
	    unsigned int jimmy;
	    } bad_addr;

    ss_return = lib$get_vm_64 (
	&req_size,	    /* Number of bytes to allocate */
	&params_64);	    /* Pointer to block allocated */
    if ((ss_return & 1) != 1) return ss_return;
    printf ("Prior to calls, PS = %lx, Routine # = %ld\n",
	params[0], params[1]);

    for ( iter_count=1 ;  iter_count <= MAX_COUNT ;  iter_count++ )
    {
    	ss_return = first_service(params);
	if (ss_return!=SS$_NORMAL)
	{
	    printf ("Non-normal status return from service: %lx\n", ss_return);
	}
	printf ("Iteration # %lu: PS = %lx, Routine # = %ld\n",
	    iter_count, params[0], params[1]);

	/* Pass 64-bit pointer to second_service. */
    	ss_return = second_service(params_64);
	if (ss_return!=SS$_NORMAL)
	{
	    printf ("Non-normal status return from service: %lx\n", ss_return);
	}
	printf ("Iteration # %lu: PS = %lx, Routine # = %ld\n",
	    iter_count, params_64[0],params_64[1]);

	/* Pass 64-bit pointer to third_service. */
    	ss_return = third_service(params_64);
	if (ss_return!=SS$_NORMAL)
	{
	    printf ("Non-normal status return from service: %lx\n", ss_return);
	}
	printf ("Iteration # %lu: PS = %lx, Routine # = %ld\n",
	    iter_count, params_64[0],params_64[1]);
    	ss_return = fourth_service(params);
	if (ss_return!=SS$_NORMAL)
	{
	    printf ("Non-normal status return from service: %lx\n", ss_return);
	}
	printf ("Iteration # %lu: PS = %lx, Routine # = %ld\n",
	    iter_count, params[0],params[1]);
    }


    /*
    **  These attempts should fail with accvio's.
    */
    printf ("\nThe 2 following calls to first_service should receive SS$_ACCVIO (%lX) as a \nreturn status.\n",
	SS$_ACCVIO);
    bad_addr.jimmy=bad_ret_addr_1;
    ss_return = first_service(bad_addr.dummy);
    if (ss_return!=SS$_NORMAL)
    {
	printf ("Non-normal status return from service: %lX\n", ss_return);
    }

    bad_addr.jimmy=bad_ret_addr_2;
    ss_return = first_service(bad_addr.dummy);
    if (ss_return!=SS$_NORMAL)
    {
	printf ("Non-normal status return from service: %lX\n", ss_return);
    }

    /*
    **  These attempts should fail with arguments containing more than 32 bits.
    */
    printf ("\nThe 2 following calls to fourth_service should receive SS$_ARG_GTR_32_BITS \n(%lX) as a return status.\n",
	SS$_ARG_GTR_32_BITS);
    ss_return = fourth_service(params_64);
    if (ss_return!=SS$_NORMAL)
    {
	printf ("Non-normal status return from service: %lX\n", ss_return);
    }

    ss_return = fourth_service(params_64);
    if (ss_return!=SS$_NORMAL)
    {
	printf ("Non-normal status return from service: %lX\n", ss_return);
    }

    /*
    **  Return memory allocated from lib$get_vm_64 call.
    */
    ss_return = lib$free_vm_64 (
	&req_size,	    /* Number of bytes to deallocate */
	&params_64);	    /* Pointer to block */
    if ((ss_return & 1) != 1) return ss_return;
}
