/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          DECss7 IVP (Installation Verification Procedure)
 **
 **   ENVIRONMENT:       OSF/1 V3.0
 **
 **   MODULE NAME:       ss7_ivp_defines.h
 **
 **   DESCRIPTION:       Constants and macros
 **                      
 **   AUTHORS:          Marc Beatini
 **
 **   CREATION DATE:    17 February 1995
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **
 **       Pierre Garnero             13-MAy-1996 Port on VMS.
 **
 ************************************************************************/
 

/*
**
**  Constant definitions
**
*/

#define THREAD_STACK_SIZE 21120*6

/* type of message to treat at background level */
#define		HLR_INVOKE_C        1
#define         WRITE_BEGIN_C	    2
#define         WRITE_INVOKE_C	    3
#define         WRITE_CONTINUE_C    4
#define         WRITE_ABORT_C	    5
#define         WRITE_ERROR_C	    6
#define         WRITE_REJECT_C	    7
#define         WRITE_RESULT_C	    8
#define         WRITE_CANCEL_C	    9
#define         WRITE_END_C	    10

#define MAX_MSG                 500            /* queue record number */   
#define MAX_DATA_LEN		255
#define OFF    		   (unsigned char)0
#define ON     		   (unsigned char)1

					/* queue management return values */
#define Q_SUCCESS       0
#define Q_EMPTY         1
#define Q_WAS_EMPTY     2
#define Q_FAIL          255

                                               /* Point Code values */
#define BAD_VALUE -1
#define MAX_VALUE 255

/*
**
**  Macro definitions
**
*/

/* Check lowest bit for success */
#define $check(status) \
    if (status != SS7_NORMAL) \
	{ \
	printf ("Exiting due to unhandled error condition:\n%s\n", get_message (status)); \
	exit(-1); \
	}

/* The status for unix file operations gives -1 on error or
** something else e.g. bytes written or a channel number.
*/
#define $check_file_status(value) \
    if (value <= 0) \
	{ \
	printf ("Exiting due to I/O error.\n"); \
	exit(-1); \
	}

#if defined (__ALPHA) && !defined (__unix__)
#include <builtins.h>

/*************************************************************************
 ** Macro to find the first set bit in a longword, in the absence of a
 ** BUILTIN for the VAX FFS instruction.
 *************************************************************************/

#define _FFS(offset, width, base, result)                           \
    (lib$ffs (&(offset), &(width), (base), (result))==LIB$_NOTFOU)? 0 : 1
#else
/*************************************************************************
 ** Macros to insert in and remove from linked lists, in the absence of
 ** BUILTINs in DECC for VMS. Note that, unlike their VAX equivalents,
 ** these do not return any status indications, nor can they be used as
 ** indivisible instructions to achieve some software interlock!
 *************************************************************************/

struct linkage                  /* Used only in _INSQUE & _REMQUE */
    {
    struct linkage *fl;
    struct linkage *bl;
    };

#define _REMQUE(entry, rementry) {                                  \
    struct linkage *xxtmp;                                          \
    xxtmp = (struct linkage *)(entry);                              \
    (xxtmp->bl)->fl = xxtmp->fl;                                    \
    (xxtmp->fl)->bl = xxtmp->bl;                                    \
    *(rementry) = (void *) xxtmp; }

#define _INSQUE(new, pred) {                                        \
    ((struct linkage *)(new))->fl = ((struct linkage *)(pred))->fl; \
    ((struct linkage *)(pred))->fl = (void *)(new);                 \
    ((struct linkage *)(new))->bl = (void *)(pred);                 \
    (((struct linkage *)(new))->fl)->bl = (void *)(new); }

/*************************************************************************
 ** Macro to find the first set bit in a longword, in the absence of a
 ** BUILTIN for the VAX FFS instruction.
 *************************************************************************/

#define _FFS(offset, width, base, result)                           \
    (lib$ffs (&(offset), &(width), (base), (result))==LIB$_NOTFOU)? 0 : 1
#endif
