/*****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          DECss7 IVP IS41 (Installation Verification Procedure)
 **
 **   ENVIRONMENT:       OSF/1 V4.0
 **
 **   MODULE NAME:       ss7_is41_snd.c
 **
 **   DESCRIPTION:       IS41S part of the DECss7 IVP IS41.
 **         
 **   AUTHORS:          Didier DRIGUES
 **
 **   CREATION DATE:    24 July 1998
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **
 ************************************************************************/



/*
**
**  INCLUDE FILES
**
*/
/*************/
/* Libraries */
/*************/
#include <stdio.h>
#include <ss7_is41_api.h>
#ifdef VMS
#include <iodef.h>
#include <ssdef.h>
#include <descrip.h>
#else
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#endif
#include <ss7_cond_codes.h>

/***************/
/* Local files */
/***************/
#include "ss7_is41_common.h"

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Main line of IS41S:
**	Declare ourselves to SS7.
**	Open a dialogue.
**	SMS request.
**	Send to peer.
**      Wait for accept dialogue indication.
**      Wait for sms response indication. 
**      Wait for close dialogue indication. 
**      Wait for last operation indication. 
**
**  FORMAL PARAMETERS:
**
**      None.
**
**  RETURN VALUE:
**
**      None.
**
**  SIDE EFFECTS:
**
**      None
**
**
**--
*/
main(int argc, char *argv[])
{
   unsigned int status;
   unsigned long opr_time_out[SS7_K_IS41_MAX_OPR];
   ss7_ssn_t ossn,dssn;
   ss7_dpc_t opc,dpc;
   unsigned long sap_id;
   unsigned long dialogue_id;
   unsigned long user_param;
   unsigned long opr_type;
   ss7_invoke_id_t invoke_id;
   ss7_invoke_id_t correlation_id;
   ss7_is41_open_param_t open_param;
   ss7_is41_sms_param_t sms_param;
   unsigned short i;
   char read_c[255];

   ss7_is41_vector_t indications = {
     ss7_is41_open_dlg_ind,
     ss7_is41_accept_dlg_ind,
     ss7_is41_close_dlg_ind,
     0,
     0,
     ss7_is41_last_operation_ind,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     ss7_is41_sms_ind,
     ss7_is41_sms_rsp_ind
};

#ifdef VMS
   float delay = 10.0;                         /* Before "real" start */
   float delay_exit = 2.0;                     /* Before exiting */
#else
   int delay = 10;                           /* Before "real" start */
   int delay_exit = 2;                       /* Before exiting */
   /* ADD SIGNALS HANDLER. */
   sigset_t sig_set;

   sigemptyset(&sig_set);
   sigaddset(&sig_set, SIGXCPU);
   sigaddset(&sig_set, SIGABRT);
   sigaddset(&sig_set, SIGTERM);
   sigaddset(&sig_set, SIGURG);
   pthread_sigmask( SIG_BLOCK, &sig_set, 0 );
#endif /* VMS */
      
   /* check values if any */
   if ((argc != 1) && (argc != 5))
   {
      printf("Usage: %s [opc dpc ossn dssn]\n",argv[0]);
      exit(-1);
   }

   if (argc == 1)
   {
      dpc=IS41R_PC;
      opc=IS41S_PC;
      dssn = IS41R_SSN;
      ossn = IS41S_SSN;
   }
   else
   {
      opc=atoi(argv[1]);
      if ((opc < 0) || (opc > MAX_VALUE))
      {
         printf("Bad opc value (%s). Range is 0 to %d.\n",argv[1],MAX_VALUE);
         exit(-1);
      }
      dpc=atoi(argv[2]);
      if ((dpc < 0 ) || (dpc > MAX_VALUE)) 
      {
         printf("Bad dpc value (%s). Range is 0 to %d.\n",argv[2],MAX_VALUE);
         exit(-1);
      }

      ossn=atoi(argv[3]);
      if ((ossn < 0) || (ossn > MAX_VALUE))
      {
         printf("Bad ossn value (%s). Range is 0 to %d.\n",argv[1],MAX_VALUE);
         exit(-1);
      }
      dssn=atoi(argv[4]);
      if ((dssn < 0 ) || (dssn > MAX_VALUE)) 
      {
         printf("Bad dssn value (%s). Range is 0 to %d.\n",argv[2],MAX_VALUE);
         exit(-1);
      }
   }
   /* initialise operation timeout */
   for (i=0;i<SS7_K_IS41_MAX_OPR;i++)
   {
      opr_time_out[i] = 1800;
   }

   /*--------------------------*/
   /* First register to DECss7 */					
   /*--------------------------*/
   printf ("Enable Indications to DECss7 ...\n");
   status = ss7_is41_enable_indic(
                                  &indications,
                                  SS7_K_TRUE,
                                  SS7_K_IS41_C,
                                  ossn,
                                  &sap_id,
                                  opr_time_out
                                  );
   $check(status);  

   /* Wait a little bit ... */
#ifdef VMS
   lib$wait(&delay);
#else
   sleep(delay);
#endif

   printf("\nIS41S program started\n\n");
   printf(".... Press Return to send an SMS request ...\n\n");
   gets(read_c);

   /*-----------------*/
   /* Open a dialogue */
   /*-----------------*/
   printf("Open a dialogue ...\n");
   /* initialisation of open param structure */
   memset(&open_param, 0, sizeof(ss7_is41_open_param_t) );
   open_param.dest_addr.pres = SS7_K_TRUE;
   open_param.dest_addr.n_i_ind = SS7_K_NAT_IND;
   open_param.dest_addr.rtg_ind = SS7_K_RTE_SSN;
   open_param.dest_addr.ssn_ind = SS7_K_TRUE;
   open_param.dest_addr.ssn = dssn;
   open_param.dest_addr.pc_ind = SS7_K_TRUE;
   open_param.dest_addr.pc = dpc;
   open_param.dest_addr.gt.gti = 0;
   open_param.src_addr.pres = SS7_K_TRUE; 
   open_param.src_addr.n_i_ind = SS7_K_NAT_IND;
   open_param.src_addr.rtg_ind = SS7_K_RTE_SSN;
   open_param.src_addr.ssn_ind = SS7_K_TRUE;
   open_param.src_addr.ssn = ossn;
   open_param.src_addr.pc_ind = SS7_K_TRUE;
   open_param.src_addr.pc = opc;
   open_param.src_addr.gt.gti = 0;
   user_param = 0;

   /* call open dialogue function */
   status = ss7_is41_open_dlg (
                               &dialogue_id,
                               &open_param,
                               user_param,
                               sap_id
                               );
   $check(status);
   printf("Open a Dialogue OK. (Dialogue Id = %d)\n",dialogue_id);

   /*-------------*/
   /* SMS request */
   /*-------------*/
   printf("SMS request (SMS_DEL_BACK) ...\n");
   /* Specify invoke id */
   invoke_id.pres = SS7_K_TRUE;
   invoke_id.val = 10;

   /* Initialization of sms_param structure */
   memset( &sms_param, 0, sizeof(ss7_is41_sms_param_t) );
   sms_param.dlvy_bak_req.circ_id.pres = SS7_K_TRUE;
   sms_param.dlvy_bak_req.circ_id.len = 2;
   sms_param.dlvy_bak_req.circ_id.val[0] = 1;
   sms_param.dlvy_bak_req.circ_id.val[1] = 2;
   sms_param.dlvy_bak_req.min.pres = SS7_K_TRUE;
   sms_param.dlvy_bak_req.min.len = 5;
   sms_param.dlvy_bak_req.min.val[0] = 18;
   sms_param.dlvy_bak_req.min.val[1] = 19;
   sms_param.dlvy_bak_req.min.val[2] = 20;
   sms_param.dlvy_bak_req.min.val[3] = 21;
   sms_param.dlvy_bak_req.min.val[4] = 22;
   sms_param.dlvy_bak_req.bear_data.pres = SS7_K_TRUE;
   sms_param.dlvy_bak_req.bear_data.len = 8;
   sms_param.dlvy_bak_req.bear_data.val[0] = 0;
   sms_param.dlvy_bak_req.bear_data.val[1] = 1;
   sms_param.dlvy_bak_req.bear_data.val[2] = 2;
   sms_param.dlvy_bak_req.bear_data.val[3] = 3;
   sms_param.dlvy_bak_req.bear_data.val[4] = 4;
   sms_param.dlvy_bak_req.bear_data.val[5] = 5;
   sms_param.dlvy_bak_req.bear_data.val[6] = 6;
   sms_param.dlvy_bak_req.bear_data.val[7] = 7;
   sms_param.dlvy_bak_req.tele_id.pres = SS7_K_TRUE;
   sms_param.dlvy_bak_req.tele_id.len = 2;
   sms_param.dlvy_bak_req.tele_id.val[0] = 10;
   sms_param.dlvy_bak_req.tele_id.val[1] = 11;
   sms_param.dlvy_bak_req.esn.pres = SS7_K_TRUE;
   sms_param.dlvy_bak_req.esn.len = 4;
   sms_param.dlvy_bak_req.esn.val[0] = 20;
   sms_param.dlvy_bak_req.esn.val[1] = 21;
   sms_param.dlvy_bak_req.esn.val[2] = 22;
   sms_param.dlvy_bak_req.esn.val[3] = 23;

   /* Set operation type to SMS_DEL_BAK */
   opr_type = SS7_K_IS41_SMS_DEL_BAK;

   /* Call sms request function */
   status = ss7_is41_sms(
                        dialogue_id,
                        &invoke_id,
                        &sms_param,
                        opr_type
                        );
   $check(status);
   printf("SMS request (SMS_DEL_BACK) OK. (Invoke Id = %d)\n",
      (int)invoke_id.val);

   /*--------------*/
   /* Send to peer */      
   /*--------------*/
   printf("Send to peer ...\n");
   status = ss7_is41_send_to_peer (
                                   dialogue_id
                                  );
   $check(status);
   printf("Send to peer OK.\n");

   /*-------------------------------------*/
   /* Wait for Accept Dialogue Indication */
   /*-------------------------------------*/
   acc_dlg_rec = SS7_K_FALSE;
   printf("Wait for Accept dialogue Indication ...\n");
   status = ss7_is41_deliver_indic();
   if(acc_dlg_rec == SS7_K_FALSE)
   {
      printf("not Accept dialogue Indication, failed\n");
      exit(-1);
   }

   /*-----------------------*/
   /* Wait for SMS response */
   /*-----------------------*/
   sms_rsp_rec = SS7_K_FALSE;
   printf("Wait for SMS response indication ...\n");
   status = ss7_is41_deliver_indic();
   $check(status);
   if(sms_rsp_rec == SS7_K_FALSE)
   {
      printf("not SMS response indication, failed.\n");
      exit(-1);
   }

   /*-------------------------*/
   /* Wait for close dialogue */
   /*-------------------------*/
   clo_dlg_rec = SS7_K_FALSE;
   printf("Wait for close dialogue indication ...\n");
   status = ss7_is41_deliver_indic();
   $check(status);
   if(clo_dlg_rec == SS7_K_FALSE)
   {
      printf("not Close dialogue Indication, failed\n");
      exit(-1);
   }

   /* Now we can exit... after some delay... */
#ifdef VMS
   lib$wait(&delay_exit);
#else
   sleep(delay_exit);
#endif

   printf("\nIS41S program terminated.\n");
   exit(0);
}
